<?php
namespace Zaa\Custom\Block\Category;

use Magento\Backend\Block\Template;

class CatDescription extends Template
{
    // @var \Magento\Store\Model\StoreManagerInterface
    protected $_storeManager;

    // @var \Magento\Framework\App\ResourceConnection
    protected $_resource;

    // @var \Magento\Catalog\Model\Product\Option\Value
    protected $_objectManager;

    public function __construct(
        Template\Context                                                $context,
        \Magento\Store\Model\StoreManagerInterface                      $storeManager,
        \Magento\Framework\App\ResourceConnection                       $resource,
        \Magento\Framework\ObjectManagerInterface			            $objectManager,
        array $data = []
    ) {
        $this->_storeManager                = $storeManager;
        $this->_resource                    = $resource;
        $this->_objectManager			    = $objectManager;
        $this->_table_CCET                  = $this->_resource->getTableName('catalog_category_entity_text');
        parent::__construct($context, $data);
    }

    public function getCategoryDescription($catId) {
        $connection         = $this->_resource->getConnection();
        $select = $connection->select();
        $select->from(
            ['CCET' => $this->_table_CCET],
            ['CCET.value']
        );
        $select->where("CCET.entity_id = ?", $catId);
        $description = $connection->fetchOne($select);
        return $description;
    }

}
