define([
	'jquery',
	'Magento_Theme/js/bootstrap-select.min',
	'Magento_Theme/js/bootstrap.min',
	'Magento_Theme/js/slick-slider.min'
], function($, selectpicker)
{
	// slick init
	function initSlickCarousel() {
		jQuery('.slick-slider').slick({
			slidesToShow: 5,
			slidesToScroll: 1,
			autoplay: true,
			autoplaySpeed: 2000,
			responsive: [
			{
				breakpoint: 980, // tablet breakpoint
				settings: {
					slidesToShow: 3,
					slidesToScroll: 3
				}
			},
			{
				breakpoint: 480, // mobile breakpoint
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1
				}
			}
		]
		});
	}
	
	jQuery(function()
	{
		initSlickCarousel();
		
		$('.carousel').carousel({
			interval: 6000
		});
		
		$('.selectpicker').selectpicker({
			style: 'select',
			size: 4
		});
	});
});