require.config({"config": {
        "jsbuild":{"jquery.js":"/*!\n * jQuery JavaScript Library v1.12.4\n * http://jquery.com/\n *\n * Includes Sizzle.js\n * http://sizzlejs.com/\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license\n * http://jquery.org/license\n *\n * Date: 2016-05-20T17:17Z\n */\n\n(function( global, factory ) {\n\n\tif ( typeof module === \"object\" && typeof module.exports === \"object\" ) {\n\t\t// For CommonJS and CommonJS-like environments where a proper `window`\n\t\t// is present, execute the factory and get jQuery.\n\t\t// For environments that do not have a `window` with a `document`\n\t\t// (such as Node.js), expose a factory as module.exports.\n\t\t// This accentuates the need for the creation of a real `window`.\n\t\t// e.g. var jQuery = require(\"jquery\")(window);\n\t\t// See ticket #14549 for more info.\n\t\tmodule.exports = global.document ?\n\t\t\tfactory( global, true ) :\n\t\t\tfunction( w ) {\n\t\t\t\tif ( !w.document ) {\n\t\t\t\t\tthrow new Error( \"jQuery requires a window with a document\" );\n\t\t\t\t}\n\t\t\t\treturn factory( w );\n\t\t\t};\n\t} else {\n\t\tfactory( global );\n\t}\n\n// Pass this if window is not defined yet\n}(typeof window !== \"undefined\" ? window : this, function( window, noGlobal ) {\n\n// Support: Firefox 18+\n// Can't be in strict mode, several libs including ASP.NET trace\n// the stack via arguments.caller.callee and Firefox dies if\n// you try to trace through \"use strict\" call chains. (#13335)\n//\"use strict\";\n\tvar deletedIds = [];\n\n\tvar document = window.document;\n\n\tvar slice = deletedIds.slice;\n\n\tvar concat = deletedIds.concat;\n\n\tvar push = deletedIds.push;\n\n\tvar indexOf = deletedIds.indexOf;\n\n\tvar class2type = {};\n\n\tvar toString = class2type.toString;\n\n\tvar hasOwn = class2type.hasOwnProperty;\n\n\tvar support = {};\n\n\n\n\tvar\n\t\tversion = \"1.12.4\",\n\n\t\t// Define a local copy of jQuery\n\t\tjQuery = function( selector, context ) {\n\n\t\t\t// The jQuery object is actually just the init constructor 'enhanced'\n\t\t\t// Need init if jQuery is called (just allow error to be thrown if not included)\n\t\t\treturn new jQuery.fn.init( selector, context );\n\t\t},\n\n\t\t// Support: Android<4.1, IE<9\n\t\t// Make sure we trim BOM and NBSP\n\t\trtrim = /^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g,\n\n\t\t// Matches dashed string for camelizing\n\t\trmsPrefix = /^-ms-/,\n\t\trdashAlpha = /-([\\da-z])/gi,\n\n\t\t// Used by jQuery.camelCase as callback to replace()\n\t\tfcamelCase = function( all, letter ) {\n\t\t\treturn letter.toUpperCase();\n\t\t};\n\n\tjQuery.fn = jQuery.prototype = {\n\n\t\t// The current version of jQuery being used\n\t\tjquery: version,\n\n\t\tconstructor: jQuery,\n\n\t\t// Start with an empty selector\n\t\tselector: \"\",\n\n\t\t// The default length of a jQuery object is 0\n\t\tlength: 0,\n\n\t\ttoArray: function() {\n\t\t\treturn slice.call( this );\n\t\t},\n\n\t\t// Get the Nth element in the matched element set OR\n\t\t// Get the whole matched element set as a clean array\n\t\tget: function( num ) {\n\t\t\treturn num != null ?\n\n\t\t\t\t// Return just the one element from the set\n\t\t\t\t( num < 0 ? this[ num + this.length ] : this[ num ] ) :\n\n\t\t\t\t// Return all the elements in a clean array\n\t\t\t\tslice.call( this );\n\t\t},\n\n\t\t// Take an array of elements and push it onto the stack\n\t\t// (returning the new matched element set)\n\t\tpushStack: function( elems ) {\n\n\t\t\t// Build a new jQuery matched element set\n\t\t\tvar ret = jQuery.merge( this.constructor(), elems );\n\n\t\t\t// Add the old object onto the stack (as a reference)\n\t\t\tret.prevObject = this;\n\t\t\tret.context = this.context;\n\n\t\t\t// Return the newly-formed element set\n\t\t\treturn ret;\n\t\t},\n\n\t\t// Execute a callback for every element in the matched set.\n\t\teach: function( callback ) {\n\t\t\treturn jQuery.each( this, callback );\n\t\t},\n\n\t\tmap: function( callback ) {\n\t\t\treturn this.pushStack( jQuery.map( this, function( elem, i ) {\n\t\t\t\treturn callback.call( elem, i, elem );\n\t\t\t} ) );\n\t\t},\n\n\t\tslice: function() {\n\t\t\treturn this.pushStack( slice.apply( this, arguments ) );\n\t\t},\n\n\t\tfirst: function() {\n\t\t\treturn this.eq( 0 );\n\t\t},\n\n\t\tlast: function() {\n\t\t\treturn this.eq( -1 );\n\t\t},\n\n\t\teq: function( i ) {\n\t\t\tvar len = this.length,\n\t\t\t\tj = +i + ( i < 0 ? len : 0 );\n\t\t\treturn this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );\n\t\t},\n\n\t\tend: function() {\n\t\t\treturn this.prevObject || this.constructor();\n\t\t},\n\n\t\t// For internal use only.\n\t\t// Behaves like an Array's method, not like a jQuery method.\n\t\tpush: push,\n\t\tsort: deletedIds.sort,\n\t\tsplice: deletedIds.splice\n\t};\n\n\tjQuery.extend = jQuery.fn.extend = function() {\n\t\tvar src, copyIsArray, copy, name, options, clone,\n\t\t\ttarget = arguments[ 0 ] || {},\n\t\t\ti = 1,\n\t\t\tlength = arguments.length,\n\t\t\tdeep = false;\n\n\t\t// Handle a deep copy situation\n\t\tif ( typeof target === \"boolean\" ) {\n\t\t\tdeep = target;\n\n\t\t\t// skip the boolean and the target\n\t\t\ttarget = arguments[ i ] || {};\n\t\t\ti++;\n\t\t}\n\n\t\t// Handle case when target is a string or something (possible in deep copy)\n\t\tif ( typeof target !== \"object\" && !jQuery.isFunction( target ) ) {\n\t\t\ttarget = {};\n\t\t}\n\n\t\t// extend jQuery itself if only one argument is passed\n\t\tif ( i === length ) {\n\t\t\ttarget = this;\n\t\t\ti--;\n\t\t}\n\n\t\tfor ( ; i < length; i++ ) {\n\n\t\t\t// Only deal with non-null/undefined values\n\t\t\tif ( ( options = arguments[ i ] ) != null ) {\n\n\t\t\t\t// Extend the base object\n\t\t\t\tfor ( name in options ) {\n\t\t\t\t\tsrc = target[ name ];\n\t\t\t\t\tcopy = options[ name ];\n\n\t\t\t\t\t// Prevent never-ending loop\n\t\t\t\t\tif ( target === copy ) {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Recurse if we're merging plain objects or arrays\n\t\t\t\t\tif ( deep && copy && ( jQuery.isPlainObject( copy ) ||\n\t\t\t\t\t\t( copyIsArray = jQuery.isArray( copy ) ) ) ) {\n\n\t\t\t\t\t\tif ( copyIsArray ) {\n\t\t\t\t\t\t\tcopyIsArray = false;\n\t\t\t\t\t\t\tclone = src && jQuery.isArray( src ) ? src : [];\n\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tclone = src && jQuery.isPlainObject( src ) ? src : {};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Never move original objects, clone them\n\t\t\t\t\t\ttarget[ name ] = jQuery.extend( deep, clone, copy );\n\n\t\t\t\t\t\t// Don't bring in undefined values\n\t\t\t\t\t} else if ( copy !== undefined ) {\n\t\t\t\t\t\ttarget[ name ] = copy;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Return the modified object\n\t\treturn target;\n\t};\n\n\tjQuery.extend( {\n\n\t\t// Unique for each copy of jQuery on the page\n\t\texpando: \"jQuery\" + ( version + Math.random() ).replace( /\\D/g, \"\" ),\n\n\t\t// Assume jQuery is ready without the ready module\n\t\tisReady: true,\n\n\t\terror: function( msg ) {\n\t\t\tthrow new Error( msg );\n\t\t},\n\n\t\tnoop: function() {},\n\n\t\t// See test/unit/core.js for details concerning isFunction.\n\t\t// Since version 1.3, DOM methods and functions like alert\n\t\t// aren't supported. They return false on IE (#2968).\n\t\tisFunction: function( obj ) {\n\t\t\treturn jQuery.type( obj ) === \"function\";\n\t\t},\n\n\t\tisArray: Array.isArray || function( obj ) {\n\t\t\treturn jQuery.type( obj ) === \"array\";\n\t\t},\n\n\t\tisWindow: function( obj ) {\n\t\t\t/* jshint eqeqeq: false */\n\t\t\treturn obj != null && obj == obj.window;\n\t\t},\n\n\t\tisNumeric: function( obj ) {\n\n\t\t\t// parseFloat NaNs numeric-cast false positives (null|true|false|\"\")\n\t\t\t// ...but misinterprets leading-number strings, particularly hex literals (\"0x...\")\n\t\t\t// subtraction forces infinities to NaN\n\t\t\t// adding 1 corrects loss of precision from parseFloat (#15100)\n\t\t\tvar realStringObj = obj && obj.toString();\n\t\t\treturn !jQuery.isArray( obj ) && ( realStringObj - parseFloat( realStringObj ) + 1 ) >= 0;\n\t\t},\n\n\t\tisEmptyObject: function( obj ) {\n\t\t\tvar name;\n\t\t\tfor ( name in obj ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\treturn true;\n\t\t},\n\n\t\tisPlainObject: function( obj ) {\n\t\t\tvar key;\n\n\t\t\t// Must be an Object.\n\t\t\t// Because of IE, we also have to check the presence of the constructor property.\n\t\t\t// Make sure that DOM nodes and window objects don't pass through, as well\n\t\t\tif ( !obj || jQuery.type( obj ) !== \"object\" || obj.nodeType || jQuery.isWindow( obj ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\ttry {\n\n\t\t\t\t// Not own constructor property must be Object\n\t\t\t\tif ( obj.constructor &&\n\t\t\t\t\t!hasOwn.call( obj, \"constructor\" ) &&\n\t\t\t\t\t!hasOwn.call( obj.constructor.prototype, \"isPrototypeOf\" ) ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t} catch ( e ) {\n\n\t\t\t\t// IE8,9 Will throw exceptions on certain host objects #9897\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// Handle iteration over inherited properties before own properties.\n\t\t\tif ( !support.ownFirst ) {\n\t\t\t\tfor ( key in obj ) {\n\t\t\t\t\treturn hasOwn.call( obj, key );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Own properties are enumerated firstly, so to speed up,\n\t\t\t// if last one is own, then all properties are own.\n\t\t\tfor ( key in obj ) {}\n\n\t\t\treturn key === undefined || hasOwn.call( obj, key );\n\t\t},\n\n\t\ttype: function( obj ) {\n\t\t\tif ( obj == null ) {\n\t\t\t\treturn obj + \"\";\n\t\t\t}\n\t\t\treturn typeof obj === \"object\" || typeof obj === \"function\" ?\n\t\t\tclass2type[ toString.call( obj ) ] || \"object\" :\n\t\t\t\ttypeof obj;\n\t\t},\n\n\t\t// Workarounds based on findings by Jim Driscoll\n\t\t// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context\n\t\tglobalEval: function( data ) {\n\t\t\tif ( data && jQuery.trim( data ) ) {\n\n\t\t\t\t// We use execScript on Internet Explorer\n\t\t\t\t// We use an anonymous function so that context is window\n\t\t\t\t// rather than jQuery in Firefox\n\t\t\t\t( window.execScript || function( data ) {\n\t\t\t\t\twindow[ \"eval\" ].call( window, data ); // jscs:ignore requireDotNotation\n\t\t\t\t} )( data );\n\t\t\t}\n\t\t},\n\n\t\t// Convert dashed to camelCase; used by the css and data modules\n\t\t// Microsoft forgot to hump their vendor prefix (#9572)\n\t\tcamelCase: function( string ) {\n\t\t\treturn string.replace( rmsPrefix, \"ms-\" ).replace( rdashAlpha, fcamelCase );\n\t\t},\n\n\t\tnodeName: function( elem, name ) {\n\t\t\treturn elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();\n\t\t},\n\n\t\teach: function( obj, callback ) {\n\t\t\tvar length, i = 0;\n\n\t\t\tif ( isArrayLike( obj ) ) {\n\t\t\t\tlength = obj.length;\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tif ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( i in obj ) {\n\t\t\t\t\tif ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn obj;\n\t\t},\n\n\t\t// Support: Android<4.1, IE<9\n\t\ttrim: function( text ) {\n\t\t\treturn text == null ?\n\t\t\t\t\"\" :\n\t\t\t\t( text + \"\" ).replace( rtrim, \"\" );\n\t\t},\n\n\t\t// results is for internal usage only\n\t\tmakeArray: function( arr, results ) {\n\t\t\tvar ret = results || [];\n\n\t\t\tif ( arr != null ) {\n\t\t\t\tif ( isArrayLike( Object( arr ) ) ) {\n\t\t\t\t\tjQuery.merge( ret,\n\t\t\t\t\t\ttypeof arr === \"string\" ?\n\t\t\t\t\t\t\t[ arr ] : arr\n\t\t\t\t\t);\n\t\t\t\t} else {\n\t\t\t\t\tpush.call( ret, arr );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn ret;\n\t\t},\n\n\t\tinArray: function( elem, arr, i ) {\n\t\t\tvar len;\n\n\t\t\tif ( arr ) {\n\t\t\t\tif ( indexOf ) {\n\t\t\t\t\treturn indexOf.call( arr, elem, i );\n\t\t\t\t}\n\n\t\t\t\tlen = arr.length;\n\t\t\t\ti = i ? i < 0 ? Math.max( 0, len + i ) : i : 0;\n\n\t\t\t\tfor ( ; i < len; i++ ) {\n\n\t\t\t\t\t// Skip accessing in sparse arrays\n\t\t\t\t\tif ( i in arr && arr[ i ] === elem ) {\n\t\t\t\t\t\treturn i;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn -1;\n\t\t},\n\n\t\tmerge: function( first, second ) {\n\t\t\tvar len = +second.length,\n\t\t\t\tj = 0,\n\t\t\t\ti = first.length;\n\n\t\t\twhile ( j < len ) {\n\t\t\t\tfirst[ i++ ] = second[ j++ ];\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// Workaround casting of .length to NaN on otherwise arraylike objects (e.g., NodeLists)\n\t\t\tif ( len !== len ) {\n\t\t\t\twhile ( second[ j ] !== undefined ) {\n\t\t\t\t\tfirst[ i++ ] = second[ j++ ];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfirst.length = i;\n\n\t\t\treturn first;\n\t\t},\n\n\t\tgrep: function( elems, callback, invert ) {\n\t\t\tvar callbackInverse,\n\t\t\t\tmatches = [],\n\t\t\t\ti = 0,\n\t\t\t\tlength = elems.length,\n\t\t\t\tcallbackExpect = !invert;\n\n\t\t\t// Go through the array, only saving the items\n\t\t\t// that pass the validator function\n\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\tcallbackInverse = !callback( elems[ i ], i );\n\t\t\t\tif ( callbackInverse !== callbackExpect ) {\n\t\t\t\t\tmatches.push( elems[ i ] );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn matches;\n\t\t},\n\n\t\t// arg is for internal usage only\n\t\tmap: function( elems, callback, arg ) {\n\t\t\tvar length, value,\n\t\t\t\ti = 0,\n\t\t\t\tret = [];\n\n\t\t\t// Go through the array, translating each of the items to their new values\n\t\t\tif ( isArrayLike( elems ) ) {\n\t\t\t\tlength = elems.length;\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tvalue = callback( elems[ i ], i, arg );\n\n\t\t\t\t\tif ( value != null ) {\n\t\t\t\t\t\tret.push( value );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Go through every key on the object,\n\t\t\t} else {\n\t\t\t\tfor ( i in elems ) {\n\t\t\t\t\tvalue = callback( elems[ i ], i, arg );\n\n\t\t\t\t\tif ( value != null ) {\n\t\t\t\t\t\tret.push( value );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Flatten any nested arrays\n\t\t\treturn concat.apply( [], ret );\n\t\t},\n\n\t\t// A global GUID counter for objects\n\t\tguid: 1,\n\n\t\t// Bind a function to a context, optionally partially applying any\n\t\t// arguments.\n\t\tproxy: function( fn, context ) {\n\t\t\tvar args, proxy, tmp;\n\n\t\t\tif ( typeof context === \"string\" ) {\n\t\t\t\ttmp = fn[ context ];\n\t\t\t\tcontext = fn;\n\t\t\t\tfn = tmp;\n\t\t\t}\n\n\t\t\t// Quick check to determine if target is callable, in the spec\n\t\t\t// this throws a TypeError, but we will just return undefined.\n\t\t\tif ( !jQuery.isFunction( fn ) ) {\n\t\t\t\treturn undefined;\n\t\t\t}\n\n\t\t\t// Simulated bind\n\t\t\targs = slice.call( arguments, 2 );\n\t\t\tproxy = function() {\n\t\t\t\treturn fn.apply( context || this, args.concat( slice.call( arguments ) ) );\n\t\t\t};\n\n\t\t\t// Set the guid of unique handler to the same of original handler, so it can be removed\n\t\t\tproxy.guid = fn.guid = fn.guid || jQuery.guid++;\n\n\t\t\treturn proxy;\n\t\t},\n\n\t\tnow: function() {\n\t\t\treturn +( new Date() );\n\t\t},\n\n\t\t// jQuery.support is not used in Core but other projects attach their\n\t\t// properties to it so it needs to exist.\n\t\tsupport: support\n\t} );\n\n// JSHint would error on this code due to the Symbol not being defined in ES5.\n// Defining this global in .jshintrc would create a danger of using the global\n// unguarded in another place, it seems safer to just disable JSHint for these\n// three lines.\n\t/* jshint ignore: start */\n\tif ( typeof Symbol === \"function\" ) {\n\t\tjQuery.fn[ Symbol.iterator ] = deletedIds[ Symbol.iterator ];\n\t}\n\t/* jshint ignore: end */\n\n// Populate the class2type map\n\tjQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".split( \" \" ),\n\t\tfunction( i, name ) {\n\t\t\tclass2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n\t\t} );\n\n\tfunction isArrayLike( obj ) {\n\n\t\t// Support: iOS 8.2 (not reproducible in simulator)\n\t\t// `in` check used to prevent JIT error (gh-2145)\n\t\t// hasOwn isn't used here due to false negatives\n\t\t// regarding Nodelist length in IE\n\t\tvar length = !!obj && \"length\" in obj && obj.length,\n\t\t\ttype = jQuery.type( obj );\n\n\t\tif ( type === \"function\" || jQuery.isWindow( obj ) ) {\n\t\t\treturn false;\n\t\t}\n\n\t\treturn type === \"array\" || length === 0 ||\n\t\t\ttypeof length === \"number\" && length > 0 && ( length - 1 ) in obj;\n\t}\n\tvar Sizzle =\n\t\t/*!\n\t\t * Sizzle CSS Selector Engine v2.2.1\n\t\t * http://sizzlejs.com/\n\t\t *\n\t\t * Copyright jQuery Foundation and other contributors\n\t\t * Released under the MIT license\n\t\t * http://jquery.org/license\n\t\t *\n\t\t * Date: 2015-10-17\n\t\t */\n\t\t(function( window ) {\n\n\t\t\tvar i,\n\t\t\t\tsupport,\n\t\t\t\tExpr,\n\t\t\t\tgetText,\n\t\t\t\tisXML,\n\t\t\t\ttokenize,\n\t\t\t\tcompile,\n\t\t\t\tselect,\n\t\t\t\toutermostContext,\n\t\t\t\tsortInput,\n\t\t\t\thasDuplicate,\n\n\t\t\t\t// Local document vars\n\t\t\t\tsetDocument,\n\t\t\t\tdocument,\n\t\t\t\tdocElem,\n\t\t\t\tdocumentIsHTML,\n\t\t\t\trbuggyQSA,\n\t\t\t\trbuggyMatches,\n\t\t\t\tmatches,\n\t\t\t\tcontains,\n\n\t\t\t\t// Instance-specific data\n\t\t\t\texpando = \"sizzle\" + 1 * new Date(),\n\t\t\t\tpreferredDoc = window.document,\n\t\t\t\tdirruns = 0,\n\t\t\t\tdone = 0,\n\t\t\t\tclassCache = createCache(),\n\t\t\t\ttokenCache = createCache(),\n\t\t\t\tcompilerCache = createCache(),\n\t\t\t\tsortOrder = function( a, b ) {\n\t\t\t\t\tif ( a === b ) {\n\t\t\t\t\t\thasDuplicate = true;\n\t\t\t\t\t}\n\t\t\t\t\treturn 0;\n\t\t\t\t},\n\n\t\t\t\t// General-purpose constants\n\t\t\t\tMAX_NEGATIVE = 1 << 31,\n\n\t\t\t\t// Instance methods\n\t\t\t\thasOwn = ({}).hasOwnProperty,\n\t\t\t\tarr = [],\n\t\t\t\tpop = arr.pop,\n\t\t\t\tpush_native = arr.push,\n\t\t\t\tpush = arr.push,\n\t\t\t\tslice = arr.slice,\n\t\t\t\t// Use a stripped-down indexOf as it's faster than native\n\t\t\t\t// http://jsperf.com/thor-indexof-vs-for/5\n\t\t\t\tindexOf = function( list, elem ) {\n\t\t\t\t\tvar i = 0,\n\t\t\t\t\t\tlen = list.length;\n\t\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\t\tif ( list[i] === elem ) {\n\t\t\t\t\t\t\treturn i;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn -1;\n\t\t\t\t},\n\n\t\t\t\tbooleans = \"checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped\",\n\n\t\t\t\t// Regular expressions\n\n\t\t\t\t// http://www.w3.org/TR/css3-selectors/#whitespace\n\t\t\t\twhitespace = \"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\",\n\n\t\t\t\t// http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier\n\t\t\t\tidentifier = \"(?:\\\\\\\\.|[\\\\w-]|[^\\\\x00-\\\\xa0])+\",\n\n\t\t\t\t// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors\n\t\t\t\tattributes = \"\\\\[\" + whitespace + \"*(\" + identifier + \")(?:\" + whitespace +\n\t\t\t\t\t// Operator (capture 2)\n\t\t\t\t\t\"*([*^$|!~]?=)\" + whitespace +\n\t\t\t\t\t// \"Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]\"\n\t\t\t\t\t\"*(?:'((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\"|(\" + identifier + \"))|)\" + whitespace +\n\t\t\t\t\t\"*\\\\]\",\n\n\t\t\t\tpseudos = \":(\" + identifier + \")(?:\\\\((\" +\n\t\t\t\t\t// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:\n\t\t\t\t\t// 1. quoted (capture 3; capture 4 or capture 5)\n\t\t\t\t\t\"('((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\")|\" +\n\t\t\t\t\t// 2. simple (capture 6)\n\t\t\t\t\t\"((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\" + attributes + \")*)|\" +\n\t\t\t\t\t// 3. anything else (capture 2)\n\t\t\t\t\t\".*\" +\n\t\t\t\t\t\")\\\\)|)\",\n\n\t\t\t\t// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter\n\t\t\t\trwhitespace = new RegExp( whitespace + \"+\", \"g\" ),\n\t\t\t\trtrim = new RegExp( \"^\" + whitespace + \"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\" + whitespace + \"+$\", \"g\" ),\n\n\t\t\t\trcomma = new RegExp( \"^\" + whitespace + \"*,\" + whitespace + \"*\" ),\n\t\t\t\trcombinators = new RegExp( \"^\" + whitespace + \"*([>+~]|\" + whitespace + \")\" + whitespace + \"*\" ),\n\n\t\t\t\trattributeQuotes = new RegExp( \"=\" + whitespace + \"*([^\\\\]'\\\"]*?)\" + whitespace + \"*\\\\]\", \"g\" ),\n\n\t\t\t\trpseudo = new RegExp( pseudos ),\n\t\t\t\tridentifier = new RegExp( \"^\" + identifier + \"$\" ),\n\n\t\t\t\tmatchExpr = {\n\t\t\t\t\t\"ID\": new RegExp( \"^#(\" + identifier + \")\" ),\n\t\t\t\t\t\"CLASS\": new RegExp( \"^\\\\.(\" + identifier + \")\" ),\n\t\t\t\t\t\"TAG\": new RegExp( \"^(\" + identifier + \"|[*])\" ),\n\t\t\t\t\t\"ATTR\": new RegExp( \"^\" + attributes ),\n\t\t\t\t\t\"PSEUDO\": new RegExp( \"^\" + pseudos ),\n\t\t\t\t\t\"CHILD\": new RegExp( \"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\" + whitespace +\n\t\t\t\t\t\t\"*(even|odd|(([+-]|)(\\\\d*)n|)\" + whitespace + \"*(?:([+-]|)\" + whitespace +\n\t\t\t\t\t\t\"*(\\\\d+)|))\" + whitespace + \"*\\\\)|)\", \"i\" ),\n\t\t\t\t\t\"bool\": new RegExp( \"^(?:\" + booleans + \")$\", \"i\" ),\n\t\t\t\t\t// For use in libraries implementing .is()\n\t\t\t\t\t// We use this for POS matching in `select`\n\t\t\t\t\t\"needsContext\": new RegExp( \"^\" + whitespace + \"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\" +\n\t\t\t\t\t\twhitespace + \"*((?:-\\\\d)?\\\\d*)\" + whitespace + \"*\\\\)|)(?=[^-]|$)\", \"i\" )\n\t\t\t\t},\n\n\t\t\t\trinputs = /^(?:input|select|textarea|button)$/i,\n\t\t\t\trheader = /^h\\d$/i,\n\n\t\t\t\trnative = /^[^{]+\\{\\s*\\[native \\w/,\n\n\t\t\t\t// Easily-parseable/retrievable ID or TAG or CLASS selectors\n\t\t\t\trquickExpr = /^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,\n\n\t\t\t\trsibling = /[+~]/,\n\t\t\t\trescape = /'|\\\\/g,\n\n\t\t\t\t// CSS escapes http://www.w3.org/TR/CSS21/syndata.html#escaped-characters\n\t\t\t\trunescape = new RegExp( \"\\\\\\\\([\\\\da-f]{1,6}\" + whitespace + \"?|(\" + whitespace + \")|.)\", \"ig\" ),\n\t\t\t\tfunescape = function( _, escaped, escapedWhitespace ) {\n\t\t\t\t\tvar high = \"0x\" + escaped - 0x10000;\n\t\t\t\t\t// NaN means non-codepoint\n\t\t\t\t\t// Support: Firefox<24\n\t\t\t\t\t// Workaround erroneous numeric interpretation of +\"0x\"\n\t\t\t\t\treturn high !== high || escapedWhitespace ?\n\t\t\t\t\t\tescaped :\n\t\t\t\t\t\thigh < 0 ?\n\t\t\t\t\t\t\t// BMP codepoint\n\t\t\t\t\t\t\tString.fromCharCode( high + 0x10000 ) :\n\t\t\t\t\t\t\t// Supplemental Plane codepoint (surrogate pair)\n\t\t\t\t\t\t\tString.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );\n\t\t\t\t},\n\n\t\t\t\t// Used for iframes\n\t\t\t\t// See setDocument()\n\t\t\t\t// Removing the function wrapper causes a \"Permission Denied\"\n\t\t\t\t// error in IE\n\t\t\t\tunloadHandler = function() {\n\t\t\t\t\tsetDocument();\n\t\t\t\t};\n\n// Optimize for push.apply( _, NodeList )\n\t\t\ttry {\n\t\t\t\tpush.apply(\n\t\t\t\t\t(arr = slice.call( preferredDoc.childNodes )),\n\t\t\t\t\tpreferredDoc.childNodes\n\t\t\t\t);\n\t\t\t\t// Support: Android<4.0\n\t\t\t\t// Detect silently failing push.apply\n\t\t\t\tarr[ preferredDoc.childNodes.length ].nodeType;\n\t\t\t} catch ( e ) {\n\t\t\t\tpush = { apply: arr.length ?\n\n\t\t\t\t\t// Leverage slice if possible\n\t\t\t\t\tfunction( target, els ) {\n\t\t\t\t\t\tpush_native.apply( target, slice.call(els) );\n\t\t\t\t\t} :\n\n\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t// Otherwise append directly\n\t\t\t\t\tfunction( target, els ) {\n\t\t\t\t\t\tvar j = target.length,\n\t\t\t\t\t\t\ti = 0;\n\t\t\t\t\t\t// Can't trust NodeList.length\n\t\t\t\t\t\twhile ( (target[j++] = els[i++]) ) {}\n\t\t\t\t\t\ttarget.length = j - 1;\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tfunction Sizzle( selector, context, results, seed ) {\n\t\t\t\tvar m, i, elem, nid, nidselect, match, groups, newSelector,\n\t\t\t\t\tnewContext = context && context.ownerDocument,\n\n\t\t\t\t\t// nodeType defaults to 9, since context defaults to document\n\t\t\t\t\tnodeType = context ? context.nodeType : 9;\n\n\t\t\t\tresults = results || [];\n\n\t\t\t\t// Return early from calls with invalid selector or context\n\t\t\t\tif ( typeof selector !== \"string\" || !selector ||\n\t\t\t\t\tnodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {\n\n\t\t\t\t\treturn results;\n\t\t\t\t}\n\n\t\t\t\t// Try to shortcut find operations (as opposed to filters) in HTML documents\n\t\t\t\tif ( !seed ) {\n\n\t\t\t\t\tif ( ( context ? context.ownerDocument || context : preferredDoc ) !== document ) {\n\t\t\t\t\t\tsetDocument( context );\n\t\t\t\t\t}\n\t\t\t\t\tcontext = context || document;\n\n\t\t\t\t\tif ( documentIsHTML ) {\n\n\t\t\t\t\t\t// If the selector is sufficiently simple, try using a \"get*By*\" DOM method\n\t\t\t\t\t\t// (excepting DocumentFragment context, where the methods don't exist)\n\t\t\t\t\t\tif ( nodeType !== 11 && (match = rquickExpr.exec( selector )) ) {\n\n\t\t\t\t\t\t\t// ID selector\n\t\t\t\t\t\t\tif ( (m = match[1]) ) {\n\n\t\t\t\t\t\t\t\t// Document context\n\t\t\t\t\t\t\t\tif ( nodeType === 9 ) {\n\t\t\t\t\t\t\t\t\tif ( (elem = context.getElementById( m )) ) {\n\n\t\t\t\t\t\t\t\t\t\t// Support: IE, Opera, Webkit\n\t\t\t\t\t\t\t\t\t\t// TODO: identify versions\n\t\t\t\t\t\t\t\t\t\t// getElementById can match elements by name instead of ID\n\t\t\t\t\t\t\t\t\t\tif ( elem.id === m ) {\n\t\t\t\t\t\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Element context\n\t\t\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\t\t\t// Support: IE, Opera, Webkit\n\t\t\t\t\t\t\t\t\t// TODO: identify versions\n\t\t\t\t\t\t\t\t\t// getElementById can match elements by name instead of ID\n\t\t\t\t\t\t\t\t\tif ( newContext && (elem = newContext.getElementById( m )) &&\n\t\t\t\t\t\t\t\t\t\tcontains( context, elem ) &&\n\t\t\t\t\t\t\t\t\t\telem.id === m ) {\n\n\t\t\t\t\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Type selector\n\t\t\t\t\t\t\t} else if ( match[2] ) {\n\t\t\t\t\t\t\t\tpush.apply( results, context.getElementsByTagName( selector ) );\n\t\t\t\t\t\t\t\treturn results;\n\n\t\t\t\t\t\t\t\t// Class selector\n\t\t\t\t\t\t\t} else if ( (m = match[3]) && support.getElementsByClassName &&\n\t\t\t\t\t\t\t\tcontext.getElementsByClassName ) {\n\n\t\t\t\t\t\t\t\tpush.apply( results, context.getElementsByClassName( m ) );\n\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Take advantage of querySelectorAll\n\t\t\t\t\t\tif ( support.qsa &&\n\t\t\t\t\t\t\t!compilerCache[ selector + \" \" ] &&\n\t\t\t\t\t\t\t(!rbuggyQSA || !rbuggyQSA.test( selector )) ) {\n\n\t\t\t\t\t\t\tif ( nodeType !== 1 ) {\n\t\t\t\t\t\t\t\tnewContext = context;\n\t\t\t\t\t\t\t\tnewSelector = selector;\n\n\t\t\t\t\t\t\t\t// qSA looks outside Element context, which is not what we want\n\t\t\t\t\t\t\t\t// Thanks to Andrew Dupont for this workaround technique\n\t\t\t\t\t\t\t\t// Support: IE <=8\n\t\t\t\t\t\t\t\t// Exclude object elements\n\t\t\t\t\t\t\t} else if ( context.nodeName.toLowerCase() !== \"object\" ) {\n\n\t\t\t\t\t\t\t\t// Capture the context ID, setting it first if necessary\n\t\t\t\t\t\t\t\tif ( (nid = context.getAttribute( \"id\" )) ) {\n\t\t\t\t\t\t\t\t\tnid = nid.replace( rescape, \"\\\\$&\" );\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tcontext.setAttribute( \"id\", (nid = expando) );\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Prefix every selector in the list\n\t\t\t\t\t\t\t\tgroups = tokenize( selector );\n\t\t\t\t\t\t\t\ti = groups.length;\n\t\t\t\t\t\t\t\tnidselect = ridentifier.test( nid ) ? \"#\" + nid : \"[id='\" + nid + \"']\";\n\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\tgroups[i] = nidselect + \" \" + toSelector( groups[i] );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tnewSelector = groups.join( \",\" );\n\n\t\t\t\t\t\t\t\t// Expand context for sibling selectors\n\t\t\t\t\t\t\t\tnewContext = rsibling.test( selector ) && testContext( context.parentNode ) ||\n\t\t\t\t\t\t\t\t\tcontext;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif ( newSelector ) {\n\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\tpush.apply( results,\n\t\t\t\t\t\t\t\t\t\tnewContext.querySelectorAll( newSelector )\n\t\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t} catch ( qsaError ) {\n\t\t\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\t\t\tif ( nid === expando ) {\n\t\t\t\t\t\t\t\t\t\tcontext.removeAttribute( \"id\" );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// All others\n\t\t\t\treturn select( selector.replace( rtrim, \"$1\" ), context, results, seed );\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Create key-value caches of limited size\n\t\t\t * @returns {function(string, object)} Returns the Object data after storing it on itself with\n\t\t\t *\tproperty name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)\n\t\t\t *\tdeleting the oldest entry\n\t\t\t */\n\t\t\tfunction createCache() {\n\t\t\t\tvar keys = [];\n\n\t\t\t\tfunction cache( key, value ) {\n\t\t\t\t\t// Use (key + \" \") to avoid collision with native prototype properties (see Issue #157)\n\t\t\t\t\tif ( keys.push( key + \" \" ) > Expr.cacheLength ) {\n\t\t\t\t\t\t// Only keep the most recent entries\n\t\t\t\t\t\tdelete cache[ keys.shift() ];\n\t\t\t\t\t}\n\t\t\t\t\treturn (cache[ key + \" \" ] = value);\n\t\t\t\t}\n\t\t\t\treturn cache;\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Mark a function for special use by Sizzle\n\t\t\t * @param {Function} fn The function to mark\n\t\t\t */\n\t\t\tfunction markFunction( fn ) {\n\t\t\t\tfn[ expando ] = true;\n\t\t\t\treturn fn;\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Support testing using an element\n\t\t\t * @param {Function} fn Passed the created div and expects a boolean result\n\t\t\t */\n\t\t\tfunction assert( fn ) {\n\t\t\t\tvar div = document.createElement(\"div\");\n\n\t\t\t\ttry {\n\t\t\t\t\treturn !!fn( div );\n\t\t\t\t} catch (e) {\n\t\t\t\t\treturn false;\n\t\t\t\t} finally {\n\t\t\t\t\t// Remove from its parent by default\n\t\t\t\t\tif ( div.parentNode ) {\n\t\t\t\t\t\tdiv.parentNode.removeChild( div );\n\t\t\t\t\t}\n\t\t\t\t\t// release memory in IE\n\t\t\t\t\tdiv = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Adds the same handler for all of the specified attrs\n\t\t\t * @param {String} attrs Pipe-separated list of attributes\n\t\t\t * @param {Function} handler The method that will be applied\n\t\t\t */\n\t\t\tfunction addHandle( attrs, handler ) {\n\t\t\t\tvar arr = attrs.split(\"|\"),\n\t\t\t\t\ti = arr.length;\n\n\t\t\t\twhile ( i-- ) {\n\t\t\t\t\tExpr.attrHandle[ arr[i] ] = handler;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Checks document order of two siblings\n\t\t\t * @param {Element} a\n\t\t\t * @param {Element} b\n\t\t\t * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b\n\t\t\t */\n\t\t\tfunction siblingCheck( a, b ) {\n\t\t\t\tvar cur = b && a,\n\t\t\t\t\tdiff = cur && a.nodeType === 1 && b.nodeType === 1 &&\n\t\t\t\t\t\t( ~b.sourceIndex || MAX_NEGATIVE ) -\n\t\t\t\t\t\t( ~a.sourceIndex || MAX_NEGATIVE );\n\n\t\t\t\t// Use IE sourceIndex if available on both nodes\n\t\t\t\tif ( diff ) {\n\t\t\t\t\treturn diff;\n\t\t\t\t}\n\n\t\t\t\t// Check if b follows a\n\t\t\t\tif ( cur ) {\n\t\t\t\t\twhile ( (cur = cur.nextSibling) ) {\n\t\t\t\t\t\tif ( cur === b ) {\n\t\t\t\t\t\t\treturn -1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn a ? 1 : -1;\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Returns a function to use in pseudos for input types\n\t\t\t * @param {String} type\n\t\t\t */\n\t\t\tfunction createInputPseudo( type ) {\n\t\t\t\treturn function( elem ) {\n\t\t\t\t\tvar name = elem.nodeName.toLowerCase();\n\t\t\t\t\treturn name === \"input\" && elem.type === type;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Returns a function to use in pseudos for buttons\n\t\t\t * @param {String} type\n\t\t\t */\n\t\t\tfunction createButtonPseudo( type ) {\n\t\t\t\treturn function( elem ) {\n\t\t\t\t\tvar name = elem.nodeName.toLowerCase();\n\t\t\t\t\treturn (name === \"input\" || name === \"button\") && elem.type === type;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Returns a function to use in pseudos for positionals\n\t\t\t * @param {Function} fn\n\t\t\t */\n\t\t\tfunction createPositionalPseudo( fn ) {\n\t\t\t\treturn markFunction(function( argument ) {\n\t\t\t\t\targument = +argument;\n\t\t\t\t\treturn markFunction(function( seed, matches ) {\n\t\t\t\t\t\tvar j,\n\t\t\t\t\t\t\tmatchIndexes = fn( [], seed.length, argument ),\n\t\t\t\t\t\t\ti = matchIndexes.length;\n\n\t\t\t\t\t\t// Match elements found at the specified indexes\n\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\tif ( seed[ (j = matchIndexes[i]) ] ) {\n\t\t\t\t\t\t\t\tseed[j] = !(matches[j] = seed[j]);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Checks a node for validity as a Sizzle context\n\t\t\t * @param {Element|Object=} context\n\t\t\t * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value\n\t\t\t */\n\t\t\tfunction testContext( context ) {\n\t\t\t\treturn context && typeof context.getElementsByTagName !== \"undefined\" && context;\n\t\t\t}\n\n// Expose support vars for convenience\n\t\t\tsupport = Sizzle.support = {};\n\n\t\t\t/**\n\t\t\t * Detects XML nodes\n\t\t\t * @param {Element|Object} elem An element or a document\n\t\t\t * @returns {Boolean} True iff elem is a non-HTML XML node\n\t\t\t */\n\t\t\tisXML = Sizzle.isXML = function( elem ) {\n\t\t\t\t// documentElement is verified for cases where it doesn't yet exist\n\t\t\t\t// (such as loading iframes in IE - #4833)\n\t\t\t\tvar documentElement = elem && (elem.ownerDocument || elem).documentElement;\n\t\t\t\treturn documentElement ? documentElement.nodeName !== \"HTML\" : false;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Sets document-related variables once based on the current document\n\t\t\t * @param {Element|Object} [doc] An element or document object to use to set the document\n\t\t\t * @returns {Object} Returns the current document\n\t\t\t */\n\t\t\tsetDocument = Sizzle.setDocument = function( node ) {\n\t\t\t\tvar hasCompare, parent,\n\t\t\t\t\tdoc = node ? node.ownerDocument || node : preferredDoc;\n\n\t\t\t\t// Return early if doc is invalid or already selected\n\t\t\t\tif ( doc === document || doc.nodeType !== 9 || !doc.documentElement ) {\n\t\t\t\t\treturn document;\n\t\t\t\t}\n\n\t\t\t\t// Update global variables\n\t\t\t\tdocument = doc;\n\t\t\t\tdocElem = document.documentElement;\n\t\t\t\tdocumentIsHTML = !isXML( document );\n\n\t\t\t\t// Support: IE 9-11, Edge\n\t\t\t\t// Accessing iframe documents after unload throws \"permission denied\" errors (jQuery #13936)\n\t\t\t\tif ( (parent = document.defaultView) && parent.top !== parent ) {\n\t\t\t\t\t// Support: IE 11\n\t\t\t\t\tif ( parent.addEventListener ) {\n\t\t\t\t\t\tparent.addEventListener( \"unload\", unloadHandler, false );\n\n\t\t\t\t\t\t// Support: IE 9 - 10 only\n\t\t\t\t\t} else if ( parent.attachEvent ) {\n\t\t\t\t\t\tparent.attachEvent( \"onunload\", unloadHandler );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t/* Attributes\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// Support: IE<8\n\t\t\t\t// Verify that getAttribute really returns attributes and not properties\n\t\t\t\t// (excepting IE8 booleans)\n\t\t\t\tsupport.attributes = assert(function( div ) {\n\t\t\t\t\tdiv.className = \"i\";\n\t\t\t\t\treturn !div.getAttribute(\"className\");\n\t\t\t\t});\n\n\t\t\t\t/* getElement(s)By*\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// Check if getElementsByTagName(\"*\") returns only elements\n\t\t\t\tsupport.getElementsByTagName = assert(function( div ) {\n\t\t\t\t\tdiv.appendChild( document.createComment(\"\") );\n\t\t\t\t\treturn !div.getElementsByTagName(\"*\").length;\n\t\t\t\t});\n\n\t\t\t\t// Support: IE<9\n\t\t\t\tsupport.getElementsByClassName = rnative.test( document.getElementsByClassName );\n\n\t\t\t\t// Support: IE<10\n\t\t\t\t// Check if getElementById returns elements by name\n\t\t\t\t// The broken getElementById methods don't pick up programatically-set names,\n\t\t\t\t// so use a roundabout getElementsByName test\n\t\t\t\tsupport.getById = assert(function( div ) {\n\t\t\t\t\tdocElem.appendChild( div ).id = expando;\n\t\t\t\t\treturn !document.getElementsByName || !document.getElementsByName( expando ).length;\n\t\t\t\t});\n\n\t\t\t\t// ID find and filter\n\t\t\t\tif ( support.getById ) {\n\t\t\t\t\tExpr.find[\"ID\"] = function( id, context ) {\n\t\t\t\t\t\tif ( typeof context.getElementById !== \"undefined\" && documentIsHTML ) {\n\t\t\t\t\t\t\tvar m = context.getElementById( id );\n\t\t\t\t\t\t\treturn m ? [ m ] : [];\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t\tExpr.filter[\"ID\"] = function( id ) {\n\t\t\t\t\t\tvar attrId = id.replace( runescape, funescape );\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\treturn elem.getAttribute(\"id\") === attrId;\n\t\t\t\t\t\t};\n\t\t\t\t\t};\n\t\t\t\t} else {\n\t\t\t\t\t// Support: IE6/7\n\t\t\t\t\t// getElementById is not reliable as a find shortcut\n\t\t\t\t\tdelete Expr.find[\"ID\"];\n\n\t\t\t\t\tExpr.filter[\"ID\"] =  function( id ) {\n\t\t\t\t\t\tvar attrId = id.replace( runescape, funescape );\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\tvar node = typeof elem.getAttributeNode !== \"undefined\" &&\n\t\t\t\t\t\t\t\telem.getAttributeNode(\"id\");\n\t\t\t\t\t\t\treturn node && node.value === attrId;\n\t\t\t\t\t\t};\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t// Tag\n\t\t\t\tExpr.find[\"TAG\"] = support.getElementsByTagName ?\n\t\t\t\t\tfunction( tag, context ) {\n\t\t\t\t\t\tif ( typeof context.getElementsByTagName !== \"undefined\" ) {\n\t\t\t\t\t\t\treturn context.getElementsByTagName( tag );\n\n\t\t\t\t\t\t\t// DocumentFragment nodes don't have gEBTN\n\t\t\t\t\t\t} else if ( support.qsa ) {\n\t\t\t\t\t\t\treturn context.querySelectorAll( tag );\n\t\t\t\t\t\t}\n\t\t\t\t\t} :\n\n\t\t\t\t\tfunction( tag, context ) {\n\t\t\t\t\t\tvar elem,\n\t\t\t\t\t\t\ttmp = [],\n\t\t\t\t\t\t\ti = 0,\n\t\t\t\t\t\t\t// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too\n\t\t\t\t\t\t\tresults = context.getElementsByTagName( tag );\n\n\t\t\t\t\t\t// Filter out possible comments\n\t\t\t\t\t\tif ( tag === \"*\" ) {\n\t\t\t\t\t\t\twhile ( (elem = results[i++]) ) {\n\t\t\t\t\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\t\t\t\t\ttmp.push( elem );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn tmp;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn results;\n\t\t\t\t\t};\n\n\t\t\t\t// Class\n\t\t\t\tExpr.find[\"CLASS\"] = support.getElementsByClassName && function( className, context ) {\n\t\t\t\t\t\tif ( typeof context.getElementsByClassName !== \"undefined\" && documentIsHTML ) {\n\t\t\t\t\t\t\treturn context.getElementsByClassName( className );\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t/* QSA/matchesSelector\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// QSA and matchesSelector support\n\n\t\t\t\t// matchesSelector(:active) reports false when true (IE9/Opera 11.5)\n\t\t\t\trbuggyMatches = [];\n\n\t\t\t\t// qSa(:focus) reports false when true (Chrome 21)\n\t\t\t\t// We allow this because of a bug in IE8/9 that throws an error\n\t\t\t\t// whenever `document.activeElement` is accessed on an iframe\n\t\t\t\t// So, we allow :focus to pass through QSA all the time to avoid the IE error\n\t\t\t\t// See http://bugs.jquery.com/ticket/13378\n\t\t\t\trbuggyQSA = [];\n\n\t\t\t\tif ( (support.qsa = rnative.test( document.querySelectorAll )) ) {\n\t\t\t\t\t// Build QSA regex\n\t\t\t\t\t// Regex strategy adopted from Diego Perini\n\t\t\t\t\tassert(function( div ) {\n\t\t\t\t\t\t// Select is set to empty string on purpose\n\t\t\t\t\t\t// This is to test IE's treatment of not explicitly\n\t\t\t\t\t\t// setting a boolean content attribute,\n\t\t\t\t\t\t// since its presence should be enough\n\t\t\t\t\t\t// http://bugs.jquery.com/ticket/12359\n\t\t\t\t\t\tdocElem.appendChild( div ).innerHTML = \"<a id='\" + expando + \"'></a>\" +\n\t\t\t\t\t\t\t\"<select id='\" + expando + \"-\\r\\\\' msallowcapture=''>\" +\n\t\t\t\t\t\t\t\"<option selected=''></option></select>\";\n\n\t\t\t\t\t\t// Support: IE8, Opera 11-12.16\n\t\t\t\t\t\t// Nothing should be selected when empty strings follow ^= or $= or *=\n\t\t\t\t\t\t// The test attribute must be unknown in Opera but \"safe\" for WinRT\n\t\t\t\t\t\t// http://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section\n\t\t\t\t\t\tif ( div.querySelectorAll(\"[msallowcapture^='']\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \"[*^$]=\" + whitespace + \"*(?:''|\\\"\\\")\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Support: IE8\n\t\t\t\t\t\t// Boolean attributes and \"value\" are not treated correctly\n\t\t\t\t\t\tif ( !div.querySelectorAll(\"[selected]\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \"\\\\[\" + whitespace + \"*(?:value|\" + booleans + \")\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+\n\t\t\t\t\t\tif ( !div.querySelectorAll( \"[id~=\" + expando + \"-]\" ).length ) {\n\t\t\t\t\t\t\trbuggyQSA.push(\"~=\");\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Webkit/Opera - :checked should return selected option elements\n\t\t\t\t\t\t// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked\n\t\t\t\t\t\t// IE8 throws error here and will not see later tests\n\t\t\t\t\t\tif ( !div.querySelectorAll(\":checked\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push(\":checked\");\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Support: Safari 8+, iOS 8+\n\t\t\t\t\t\t// https://bugs.webkit.org/show_bug.cgi?id=136851\n\t\t\t\t\t\t// In-page `selector#id sibing-combinator selector` fails\n\t\t\t\t\t\tif ( !div.querySelectorAll( \"a#\" + expando + \"+*\" ).length ) {\n\t\t\t\t\t\t\trbuggyQSA.push(\".#.+[+~]\");\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\tassert(function( div ) {\n\t\t\t\t\t\t// Support: Windows 8 Native Apps\n\t\t\t\t\t\t// The type and name attributes are restricted during .innerHTML assignment\n\t\t\t\t\t\tvar input = document.createElement(\"input\");\n\t\t\t\t\t\tinput.setAttribute( \"type\", \"hidden\" );\n\t\t\t\t\t\tdiv.appendChild( input ).setAttribute( \"name\", \"D\" );\n\n\t\t\t\t\t\t// Support: IE8\n\t\t\t\t\t\t// Enforce case-sensitivity of name attribute\n\t\t\t\t\t\tif ( div.querySelectorAll(\"[name=d]\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \"name\" + whitespace + \"*[*^$|!~]?=\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)\n\t\t\t\t\t\t// IE8 throws error here and will not see later tests\n\t\t\t\t\t\tif ( !div.querySelectorAll(\":enabled\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \":enabled\", \":disabled\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Opera 10-11 does not throw on post-comma invalid pseudos\n\t\t\t\t\t\tdiv.querySelectorAll(\"*,:x\");\n\t\t\t\t\t\trbuggyQSA.push(\",.*:\");\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif ( (support.matchesSelector = rnative.test( (matches = docElem.matches ||\n\t\t\t\t\t\tdocElem.webkitMatchesSelector ||\n\t\t\t\t\t\tdocElem.mozMatchesSelector ||\n\t\t\t\t\t\tdocElem.oMatchesSelector ||\n\t\t\t\t\t\tdocElem.msMatchesSelector) )) ) {\n\n\t\t\t\t\tassert(function( div ) {\n\t\t\t\t\t\t// Check to see if it's possible to do matchesSelector\n\t\t\t\t\t\t// on a disconnected node (IE 9)\n\t\t\t\t\t\tsupport.disconnectedMatch = matches.call( div, \"div\" );\n\n\t\t\t\t\t\t// This should fail with an exception\n\t\t\t\t\t\t// Gecko does not error, returns false instead\n\t\t\t\t\t\tmatches.call( div, \"[s!='']:x\" );\n\t\t\t\t\t\trbuggyMatches.push( \"!=\", pseudos );\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\trbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join(\"|\") );\n\t\t\t\trbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join(\"|\") );\n\n\t\t\t\t/* Contains\n\t\t\t\t ---------------------------------------------------------------------- */\n\t\t\t\thasCompare = rnative.test( docElem.compareDocumentPosition );\n\n\t\t\t\t// Element contains another\n\t\t\t\t// Purposefully self-exclusive\n\t\t\t\t// As in, an element does not contain itself\n\t\t\t\tcontains = hasCompare || rnative.test( docElem.contains ) ?\n\t\t\t\t\tfunction( a, b ) {\n\t\t\t\t\t\tvar adown = a.nodeType === 9 ? a.documentElement : a,\n\t\t\t\t\t\t\tbup = b && b.parentNode;\n\t\t\t\t\t\treturn a === bup || !!( bup && bup.nodeType === 1 && (\n\t\t\t\t\t\t\t\tadown.contains ?\n\t\t\t\t\t\t\t\t\tadown.contains( bup ) :\n\t\t\t\t\t\t\t\ta.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16\n\t\t\t\t\t\t\t));\n\t\t\t\t\t} :\n\t\t\t\t\tfunction( a, b ) {\n\t\t\t\t\t\tif ( b ) {\n\t\t\t\t\t\t\twhile ( (b = b.parentNode) ) {\n\t\t\t\t\t\t\t\tif ( b === a ) {\n\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t};\n\n\t\t\t\t/* Sorting\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// Document order sorting\n\t\t\t\tsortOrder = hasCompare ?\n\t\t\t\t\tfunction( a, b ) {\n\n\t\t\t\t\t\t// Flag for duplicate removal\n\t\t\t\t\t\tif ( a === b ) {\n\t\t\t\t\t\t\thasDuplicate = true;\n\t\t\t\t\t\t\treturn 0;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Sort on method existence if only one input has compareDocumentPosition\n\t\t\t\t\t\tvar compare = !a.compareDocumentPosition - !b.compareDocumentPosition;\n\t\t\t\t\t\tif ( compare ) {\n\t\t\t\t\t\t\treturn compare;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Calculate position if both inputs belong to the same document\n\t\t\t\t\t\tcompare = ( a.ownerDocument || a ) === ( b.ownerDocument || b ) ?\n\t\t\t\t\t\t\ta.compareDocumentPosition( b ) :\n\n\t\t\t\t\t\t\t// Otherwise we know they are disconnected\n\t\t\t\t\t\t\t1;\n\n\t\t\t\t\t\t// Disconnected nodes\n\t\t\t\t\t\tif ( compare & 1 ||\n\t\t\t\t\t\t\t(!support.sortDetached && b.compareDocumentPosition( a ) === compare) ) {\n\n\t\t\t\t\t\t\t// Choose the first element that is related to our preferred document\n\t\t\t\t\t\t\tif ( a === document || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ) {\n\t\t\t\t\t\t\t\treturn -1;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif ( b === document || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ) {\n\t\t\t\t\t\t\t\treturn 1;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Maintain original order\n\t\t\t\t\t\t\treturn sortInput ?\n\t\t\t\t\t\t\t\t( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :\n\t\t\t\t\t\t\t\t0;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn compare & 4 ? -1 : 1;\n\t\t\t\t\t} :\n\t\t\t\t\tfunction( a, b ) {\n\t\t\t\t\t\t// Exit early if the nodes are identical\n\t\t\t\t\t\tif ( a === b ) {\n\t\t\t\t\t\t\thasDuplicate = true;\n\t\t\t\t\t\t\treturn 0;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tvar cur,\n\t\t\t\t\t\t\ti = 0,\n\t\t\t\t\t\t\taup = a.parentNode,\n\t\t\t\t\t\t\tbup = b.parentNode,\n\t\t\t\t\t\t\tap = [ a ],\n\t\t\t\t\t\t\tbp = [ b ];\n\n\t\t\t\t\t\t// Parentless nodes are either documents or disconnected\n\t\t\t\t\t\tif ( !aup || !bup ) {\n\t\t\t\t\t\t\treturn a === document ? -1 :\n\t\t\t\t\t\t\t\tb === document ? 1 :\n\t\t\t\t\t\t\t\t\taup ? -1 :\n\t\t\t\t\t\t\t\t\t\tbup ? 1 :\n\t\t\t\t\t\t\t\t\t\t\tsortInput ?\n\t\t\t\t\t\t\t\t\t\t\t\t( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :\n\t\t\t\t\t\t\t\t\t\t\t\t0;\n\n\t\t\t\t\t\t\t// If the nodes are siblings, we can do a quick check\n\t\t\t\t\t\t} else if ( aup === bup ) {\n\t\t\t\t\t\t\treturn siblingCheck( a, b );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Otherwise we need full lists of their ancestors for comparison\n\t\t\t\t\t\tcur = a;\n\t\t\t\t\t\twhile ( (cur = cur.parentNode) ) {\n\t\t\t\t\t\t\tap.unshift( cur );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tcur = b;\n\t\t\t\t\t\twhile ( (cur = cur.parentNode) ) {\n\t\t\t\t\t\t\tbp.unshift( cur );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Walk down the tree looking for a discrepancy\n\t\t\t\t\t\twhile ( ap[i] === bp[i] ) {\n\t\t\t\t\t\t\ti++;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn i ?\n\t\t\t\t\t\t\t// Do a sibling check if the nodes have a common ancestor\n\t\t\t\t\t\t\tsiblingCheck( ap[i], bp[i] ) :\n\n\t\t\t\t\t\t\t// Otherwise nodes in our document sort first\n\t\t\t\t\t\t\tap[i] === preferredDoc ? -1 :\n\t\t\t\t\t\t\t\tbp[i] === preferredDoc ? 1 :\n\t\t\t\t\t\t\t\t\t0;\n\t\t\t\t\t};\n\n\t\t\t\treturn document;\n\t\t\t};\n\n\t\t\tSizzle.matches = function( expr, elements ) {\n\t\t\t\treturn Sizzle( expr, null, null, elements );\n\t\t\t};\n\n\t\t\tSizzle.matchesSelector = function( elem, expr ) {\n\t\t\t\t// Set document vars if needed\n\t\t\t\tif ( ( elem.ownerDocument || elem ) !== document ) {\n\t\t\t\t\tsetDocument( elem );\n\t\t\t\t}\n\n\t\t\t\t// Make sure that attribute selectors are quoted\n\t\t\t\texpr = expr.replace( rattributeQuotes, \"='$1']\" );\n\n\t\t\t\tif ( support.matchesSelector && documentIsHTML &&\n\t\t\t\t\t!compilerCache[ expr + \" \" ] &&\n\t\t\t\t\t( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&\n\t\t\t\t\t( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\tvar ret = matches.call( elem, expr );\n\n\t\t\t\t\t\t// IE 9's matchesSelector returns false on disconnected nodes\n\t\t\t\t\t\tif ( ret || support.disconnectedMatch ||\n\t\t\t\t\t\t\t// As well, disconnected nodes are said to be in a document\n\t\t\t\t\t\t\t// fragment in IE 9\n\t\t\t\t\t\t\telem.document && elem.document.nodeType !== 11 ) {\n\t\t\t\t\t\t\treturn ret;\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch (e) {}\n\t\t\t\t}\n\n\t\t\t\treturn Sizzle( expr, document, null, [ elem ] ).length > 0;\n\t\t\t};\n\n\t\t\tSizzle.contains = function( context, elem ) {\n\t\t\t\t// Set document vars if needed\n\t\t\t\tif ( ( context.ownerDocument || context ) !== document ) {\n\t\t\t\t\tsetDocument( context );\n\t\t\t\t}\n\t\t\t\treturn contains( context, elem );\n\t\t\t};\n\n\t\t\tSizzle.attr = function( elem, name ) {\n\t\t\t\t// Set document vars if needed\n\t\t\t\tif ( ( elem.ownerDocument || elem ) !== document ) {\n\t\t\t\t\tsetDocument( elem );\n\t\t\t\t}\n\n\t\t\t\tvar fn = Expr.attrHandle[ name.toLowerCase() ],\n\t\t\t\t\t// Don't get fooled by Object.prototype properties (jQuery #13807)\n\t\t\t\t\tval = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?\n\t\t\t\t\t\tfn( elem, name, !documentIsHTML ) :\n\t\t\t\t\t\tundefined;\n\n\t\t\t\treturn val !== undefined ?\n\t\t\t\t\tval :\n\t\t\t\t\tsupport.attributes || !documentIsHTML ?\n\t\t\t\t\t\telem.getAttribute( name ) :\n\t\t\t\t\t\t(val = elem.getAttributeNode(name)) && val.specified ?\n\t\t\t\t\t\t\tval.value :\n\t\t\t\t\t\t\tnull;\n\t\t\t};\n\n\t\t\tSizzle.error = function( msg ) {\n\t\t\t\tthrow new Error( \"Syntax error, unrecognized expression: \" + msg );\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Document sorting and removing duplicates\n\t\t\t * @param {ArrayLike} results\n\t\t\t */\n\t\t\tSizzle.uniqueSort = function( results ) {\n\t\t\t\tvar elem,\n\t\t\t\t\tduplicates = [],\n\t\t\t\t\tj = 0,\n\t\t\t\t\ti = 0;\n\n\t\t\t\t// Unless we *know* we can detect duplicates, assume their presence\n\t\t\t\thasDuplicate = !support.detectDuplicates;\n\t\t\t\tsortInput = !support.sortStable && results.slice( 0 );\n\t\t\t\tresults.sort( sortOrder );\n\n\t\t\t\tif ( hasDuplicate ) {\n\t\t\t\t\twhile ( (elem = results[i++]) ) {\n\t\t\t\t\t\tif ( elem === results[ i ] ) {\n\t\t\t\t\t\t\tj = duplicates.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\twhile ( j-- ) {\n\t\t\t\t\t\tresults.splice( duplicates[ j ], 1 );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Clear input after sorting to release objects\n\t\t\t\t// See https://github.com/jquery/sizzle/pull/225\n\t\t\t\tsortInput = null;\n\n\t\t\t\treturn results;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Utility function for retrieving the text value of an array of DOM nodes\n\t\t\t * @param {Array|Element} elem\n\t\t\t */\n\t\t\tgetText = Sizzle.getText = function( elem ) {\n\t\t\t\tvar node,\n\t\t\t\t\tret = \"\",\n\t\t\t\t\ti = 0,\n\t\t\t\t\tnodeType = elem.nodeType;\n\n\t\t\t\tif ( !nodeType ) {\n\t\t\t\t\t// If no nodeType, this is expected to be an array\n\t\t\t\t\twhile ( (node = elem[i++]) ) {\n\t\t\t\t\t\t// Do not traverse comment nodes\n\t\t\t\t\t\tret += getText( node );\n\t\t\t\t\t}\n\t\t\t\t} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {\n\t\t\t\t\t// Use textContent for elements\n\t\t\t\t\t// innerText usage removed for consistency of new lines (jQuery #11153)\n\t\t\t\t\tif ( typeof elem.textContent === \"string\" ) {\n\t\t\t\t\t\treturn elem.textContent;\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Traverse its children\n\t\t\t\t\t\tfor ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {\n\t\t\t\t\t\t\tret += getText( elem );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} else if ( nodeType === 3 || nodeType === 4 ) {\n\t\t\t\t\treturn elem.nodeValue;\n\t\t\t\t}\n\t\t\t\t// Do not include comment or processing instruction nodes\n\n\t\t\t\treturn ret;\n\t\t\t};\n\n\t\t\tExpr = Sizzle.selectors = {\n\n\t\t\t\t// Can be adjusted by the user\n\t\t\t\tcacheLength: 50,\n\n\t\t\t\tcreatePseudo: markFunction,\n\n\t\t\t\tmatch: matchExpr,\n\n\t\t\t\tattrHandle: {},\n\n\t\t\t\tfind: {},\n\n\t\t\t\trelative: {\n\t\t\t\t\t\">\": { dir: \"parentNode\", first: true },\n\t\t\t\t\t\" \": { dir: \"parentNode\" },\n\t\t\t\t\t\"+\": { dir: \"previousSibling\", first: true },\n\t\t\t\t\t\"~\": { dir: \"previousSibling\" }\n\t\t\t\t},\n\n\t\t\t\tpreFilter: {\n\t\t\t\t\t\"ATTR\": function( match ) {\n\t\t\t\t\t\tmatch[1] = match[1].replace( runescape, funescape );\n\n\t\t\t\t\t\t// Move the given value to match[3] whether quoted or unquoted\n\t\t\t\t\t\tmatch[3] = ( match[3] || match[4] || match[5] || \"\" ).replace( runescape, funescape );\n\n\t\t\t\t\t\tif ( match[2] === \"~=\" ) {\n\t\t\t\t\t\t\tmatch[3] = \" \" + match[3] + \" \";\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn match.slice( 0, 4 );\n\t\t\t\t\t},\n\n\t\t\t\t\t\"CHILD\": function( match ) {\n\t\t\t\t\t\t/* matches from matchExpr[\"CHILD\"]\n\t\t\t\t\t\t 1 type (only|nth|...)\n\t\t\t\t\t\t 2 what (child|of-type)\n\t\t\t\t\t\t 3 argument (even|odd|\\d*|\\d*n([+-]\\d+)?|...)\n\t\t\t\t\t\t 4 xn-component of xn+y argument ([+-]?\\d*n|)\n\t\t\t\t\t\t 5 sign of xn-component\n\t\t\t\t\t\t 6 x of xn-component\n\t\t\t\t\t\t 7 sign of y-component\n\t\t\t\t\t\t 8 y of y-component\n\t\t\t\t\t\t */\n\t\t\t\t\t\tmatch[1] = match[1].toLowerCase();\n\n\t\t\t\t\t\tif ( match[1].slice( 0, 3 ) === \"nth\" ) {\n\t\t\t\t\t\t\t// nth-* requires argument\n\t\t\t\t\t\t\tif ( !match[3] ) {\n\t\t\t\t\t\t\t\tSizzle.error( match[0] );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// numeric x and y parameters for Expr.filter.CHILD\n\t\t\t\t\t\t\t// remember that false/true cast respectively to 0/1\n\t\t\t\t\t\t\tmatch[4] = +( match[4] ? match[5] + (match[6] || 1) : 2 * ( match[3] === \"even\" || match[3] === \"odd\" ) );\n\t\t\t\t\t\t\tmatch[5] = +( ( match[7] + match[8] ) || match[3] === \"odd\" );\n\n\t\t\t\t\t\t\t// other types prohibit arguments\n\t\t\t\t\t\t} else if ( match[3] ) {\n\t\t\t\t\t\t\tSizzle.error( match[0] );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn match;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"PSEUDO\": function( match ) {\n\t\t\t\t\t\tvar excess,\n\t\t\t\t\t\t\tunquoted = !match[6] && match[2];\n\n\t\t\t\t\t\tif ( matchExpr[\"CHILD\"].test( match[0] ) ) {\n\t\t\t\t\t\t\treturn null;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Accept quoted arguments as-is\n\t\t\t\t\t\tif ( match[3] ) {\n\t\t\t\t\t\t\tmatch[2] = match[4] || match[5] || \"\";\n\n\t\t\t\t\t\t\t// Strip excess characters from unquoted arguments\n\t\t\t\t\t\t} else if ( unquoted && rpseudo.test( unquoted ) &&\n\t\t\t\t\t\t\t// Get excess from tokenize (recursively)\n\t\t\t\t\t\t\t(excess = tokenize( unquoted, true )) &&\n\t\t\t\t\t\t\t// advance to the next closing parenthesis\n\t\t\t\t\t\t\t(excess = unquoted.indexOf( \")\", unquoted.length - excess ) - unquoted.length) ) {\n\n\t\t\t\t\t\t\t// excess is a negative index\n\t\t\t\t\t\t\tmatch[0] = match[0].slice( 0, excess );\n\t\t\t\t\t\t\tmatch[2] = unquoted.slice( 0, excess );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Return only captures needed by the pseudo filter method (type and argument)\n\t\t\t\t\t\treturn match.slice( 0, 3 );\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tfilter: {\n\n\t\t\t\t\t\"TAG\": function( nodeNameSelector ) {\n\t\t\t\t\t\tvar nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();\n\t\t\t\t\t\treturn nodeNameSelector === \"*\" ?\n\t\t\t\t\t\t\tfunction() { return true; } :\n\t\t\t\t\t\t\tfunction( elem ) {\n\t\t\t\t\t\t\t\treturn elem.nodeName && elem.nodeName.toLowerCase() === nodeName;\n\t\t\t\t\t\t\t};\n\t\t\t\t\t},\n\n\t\t\t\t\t\"CLASS\": function( className ) {\n\t\t\t\t\t\tvar pattern = classCache[ className + \" \" ];\n\n\t\t\t\t\t\treturn pattern ||\n\t\t\t\t\t\t\t(pattern = new RegExp( \"(^|\" + whitespace + \")\" + className + \"(\" + whitespace + \"|$)\" )) &&\n\t\t\t\t\t\t\tclassCache( className, function( elem ) {\n\t\t\t\t\t\t\t\treturn pattern.test( typeof elem.className === \"string\" && elem.className || typeof elem.getAttribute !== \"undefined\" && elem.getAttribute(\"class\") || \"\" );\n\t\t\t\t\t\t\t});\n\t\t\t\t\t},\n\n\t\t\t\t\t\"ATTR\": function( name, operator, check ) {\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\tvar result = Sizzle.attr( elem, name );\n\n\t\t\t\t\t\t\tif ( result == null ) {\n\t\t\t\t\t\t\t\treturn operator === \"!=\";\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif ( !operator ) {\n\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tresult += \"\";\n\n\t\t\t\t\t\t\treturn operator === \"=\" ? result === check :\n\t\t\t\t\t\t\t\toperator === \"!=\" ? result !== check :\n\t\t\t\t\t\t\t\t\toperator === \"^=\" ? check && result.indexOf( check ) === 0 :\n\t\t\t\t\t\t\t\t\t\toperator === \"*=\" ? check && result.indexOf( check ) > -1 :\n\t\t\t\t\t\t\t\t\t\t\toperator === \"$=\" ? check && result.slice( -check.length ) === check :\n\t\t\t\t\t\t\t\t\t\t\t\toperator === \"~=\" ? ( \" \" + result.replace( rwhitespace, \" \" ) + \" \" ).indexOf( check ) > -1 :\n\t\t\t\t\t\t\t\t\t\t\t\t\toperator === \"|=\" ? result === check || result.slice( 0, check.length + 1 ) === check + \"-\" :\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tfalse;\n\t\t\t\t\t\t};\n\t\t\t\t\t},\n\n\t\t\t\t\t\"CHILD\": function( type, what, argument, first, last ) {\n\t\t\t\t\t\tvar simple = type.slice( 0, 3 ) !== \"nth\",\n\t\t\t\t\t\t\tforward = type.slice( -4 ) !== \"last\",\n\t\t\t\t\t\t\tofType = what === \"of-type\";\n\n\t\t\t\t\t\treturn first === 1 && last === 0 ?\n\n\t\t\t\t\t\t\t// Shortcut for :nth-*(n)\n\t\t\t\t\t\t\tfunction( elem ) {\n\t\t\t\t\t\t\t\treturn !!elem.parentNode;\n\t\t\t\t\t\t\t} :\n\n\t\t\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\t\t\tvar cache, uniqueCache, outerCache, node, nodeIndex, start,\n\t\t\t\t\t\t\t\t\tdir = simple !== forward ? \"nextSibling\" : \"previousSibling\",\n\t\t\t\t\t\t\t\t\tparent = elem.parentNode,\n\t\t\t\t\t\t\t\t\tname = ofType && elem.nodeName.toLowerCase(),\n\t\t\t\t\t\t\t\t\tuseCache = !xml && !ofType,\n\t\t\t\t\t\t\t\t\tdiff = false;\n\n\t\t\t\t\t\t\t\tif ( parent ) {\n\n\t\t\t\t\t\t\t\t\t// :(first|last|only)-(child|of-type)\n\t\t\t\t\t\t\t\t\tif ( simple ) {\n\t\t\t\t\t\t\t\t\t\twhile ( dir ) {\n\t\t\t\t\t\t\t\t\t\t\tnode = elem;\n\t\t\t\t\t\t\t\t\t\t\twhile ( (node = node[ dir ]) ) {\n\t\t\t\t\t\t\t\t\t\t\t\tif ( ofType ?\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeName.toLowerCase() === name :\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeType === 1 ) {\n\n\t\t\t\t\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t// Reverse direction for :only-* (if we haven't yet done so)\n\t\t\t\t\t\t\t\t\t\t\tstart = dir = type === \"only\" && !start && \"nextSibling\";\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\tstart = [ forward ? parent.firstChild : parent.lastChild ];\n\n\t\t\t\t\t\t\t\t\t// non-xml :nth-child(...) stores cache data on `parent`\n\t\t\t\t\t\t\t\t\tif ( forward && useCache ) {\n\n\t\t\t\t\t\t\t\t\t\t// Seek `elem` from a previously-cached index\n\n\t\t\t\t\t\t\t\t\t\t// ...in a gzip-friendly way\n\t\t\t\t\t\t\t\t\t\tnode = parent;\n\t\t\t\t\t\t\t\t\t\touterCache = node[ expando ] || (node[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ node.uniqueID ] ||\n\t\t\t\t\t\t\t\t\t\t\t(outerCache[ node.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\t\tcache = uniqueCache[ type ] || [];\n\t\t\t\t\t\t\t\t\t\tnodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];\n\t\t\t\t\t\t\t\t\t\tdiff = nodeIndex && cache[ 2 ];\n\t\t\t\t\t\t\t\t\t\tnode = nodeIndex && parent.childNodes[ nodeIndex ];\n\n\t\t\t\t\t\t\t\t\t\twhile ( (node = ++nodeIndex && node && node[ dir ] ||\n\n\t\t\t\t\t\t\t\t\t\t\t// Fallback to seeking `elem` from the start\n\t\t\t\t\t\t\t\t\t\t\t(diff = nodeIndex = 0) || start.pop()) ) {\n\n\t\t\t\t\t\t\t\t\t\t\t// When found, cache indexes on `parent` and break\n\t\t\t\t\t\t\t\t\t\t\tif ( node.nodeType === 1 && ++diff && node === elem ) {\n\t\t\t\t\t\t\t\t\t\t\t\tuniqueCache[ type ] = [ dirruns, nodeIndex, diff ];\n\t\t\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\t// Use previously-cached element index if available\n\t\t\t\t\t\t\t\t\t\tif ( useCache ) {\n\t\t\t\t\t\t\t\t\t\t\t// ...in a gzip-friendly way\n\t\t\t\t\t\t\t\t\t\t\tnode = elem;\n\t\t\t\t\t\t\t\t\t\t\touterCache = node[ expando ] || (node[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ node.uniqueID ] ||\n\t\t\t\t\t\t\t\t\t\t\t\t(outerCache[ node.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\tcache = uniqueCache[ type ] || [];\n\t\t\t\t\t\t\t\t\t\t\tnodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];\n\t\t\t\t\t\t\t\t\t\t\tdiff = nodeIndex;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// xml :nth-child(...)\n\t\t\t\t\t\t\t\t\t\t// or :nth-last-child(...) or :nth(-last)?-of-type(...)\n\t\t\t\t\t\t\t\t\t\tif ( diff === false ) {\n\t\t\t\t\t\t\t\t\t\t\t// Use the same loop as above to seek `elem` from the start\n\t\t\t\t\t\t\t\t\t\t\twhile ( (node = ++nodeIndex && node && node[ dir ] ||\n\t\t\t\t\t\t\t\t\t\t\t\t(diff = nodeIndex = 0) || start.pop()) ) {\n\n\t\t\t\t\t\t\t\t\t\t\t\tif ( ( ofType ?\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeName.toLowerCase() === name :\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeType === 1 ) &&\n\t\t\t\t\t\t\t\t\t\t\t\t\t++diff ) {\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t// Cache the index of each encountered element\n\t\t\t\t\t\t\t\t\t\t\t\t\tif ( useCache ) {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\touterCache = node[ expando ] || (node[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ node.uniqueID ] ||\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t(outerCache[ node.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tuniqueCache[ type ] = [ dirruns, diff ];\n\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t\t\t\tif ( node === elem ) {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Incorporate the offset, then check against cycle size\n\t\t\t\t\t\t\t\t\tdiff -= last;\n\t\t\t\t\t\t\t\t\treturn diff === first || ( diff % first === 0 && diff / first >= 0 );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t};\n\t\t\t\t\t},\n\n\t\t\t\t\t\"PSEUDO\": function( pseudo, argument ) {\n\t\t\t\t\t\t// pseudo-class names are case-insensitive\n\t\t\t\t\t\t// http://www.w3.org/TR/selectors/#pseudo-classes\n\t\t\t\t\t\t// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters\n\t\t\t\t\t\t// Remember that setFilters inherits from pseudos\n\t\t\t\t\t\tvar args,\n\t\t\t\t\t\t\tfn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||\n\t\t\t\t\t\t\t\tSizzle.error( \"unsupported pseudo: \" + pseudo );\n\n\t\t\t\t\t\t// The user may use createPseudo to indicate that\n\t\t\t\t\t\t// arguments are needed to create the filter function\n\t\t\t\t\t\t// just as Sizzle does\n\t\t\t\t\t\tif ( fn[ expando ] ) {\n\t\t\t\t\t\t\treturn fn( argument );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// But maintain support for old signatures\n\t\t\t\t\t\tif ( fn.length > 1 ) {\n\t\t\t\t\t\t\targs = [ pseudo, pseudo, \"\", argument ];\n\t\t\t\t\t\t\treturn Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?\n\t\t\t\t\t\t\t\tmarkFunction(function( seed, matches ) {\n\t\t\t\t\t\t\t\t\tvar idx,\n\t\t\t\t\t\t\t\t\t\tmatched = fn( seed, argument ),\n\t\t\t\t\t\t\t\t\t\ti = matched.length;\n\t\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\t\tidx = indexOf( seed, matched[i] );\n\t\t\t\t\t\t\t\t\t\tseed[ idx ] = !( matches[ idx ] = matched[i] );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}) :\n\t\t\t\t\t\t\t\tfunction( elem ) {\n\t\t\t\t\t\t\t\t\treturn fn( elem, 0, args );\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn fn;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tpseudos: {\n\t\t\t\t\t// Potentially complex pseudos\n\t\t\t\t\t\"not\": markFunction(function( selector ) {\n\t\t\t\t\t\t// Trim the selector passed to compile\n\t\t\t\t\t\t// to avoid treating leading and trailing\n\t\t\t\t\t\t// spaces as combinators\n\t\t\t\t\t\tvar input = [],\n\t\t\t\t\t\t\tresults = [],\n\t\t\t\t\t\t\tmatcher = compile( selector.replace( rtrim, \"$1\" ) );\n\n\t\t\t\t\t\treturn matcher[ expando ] ?\n\t\t\t\t\t\t\tmarkFunction(function( seed, matches, context, xml ) {\n\t\t\t\t\t\t\t\tvar elem,\n\t\t\t\t\t\t\t\t\tunmatched = matcher( seed, null, xml, [] ),\n\t\t\t\t\t\t\t\t\ti = seed.length;\n\n\t\t\t\t\t\t\t\t// Match elements unmatched by `matcher`\n\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\tif ( (elem = unmatched[i]) ) {\n\t\t\t\t\t\t\t\t\t\tseed[i] = !(matches[i] = elem);\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}) :\n\t\t\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\t\t\tinput[0] = elem;\n\t\t\t\t\t\t\t\tmatcher( input, null, xml, results );\n\t\t\t\t\t\t\t\t// Don't keep the element (issue #299)\n\t\t\t\t\t\t\t\tinput[0] = null;\n\t\t\t\t\t\t\t\treturn !results.pop();\n\t\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"has\": markFunction(function( selector ) {\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\treturn Sizzle( selector, elem ).length > 0;\n\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"contains\": markFunction(function( text ) {\n\t\t\t\t\t\ttext = text.replace( runescape, funescape );\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\treturn ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;\n\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t// \"Whether an element is represented by a :lang() selector\n\t\t\t\t\t// is based solely on the element's language value\n\t\t\t\t\t// being equal to the identifier C,\n\t\t\t\t\t// or beginning with the identifier C immediately followed by \"-\".\n\t\t\t\t\t// The matching of C against the element's language value is performed case-insensitively.\n\t\t\t\t\t// The identifier C does not have to be a valid language name.\"\n\t\t\t\t\t// http://www.w3.org/TR/selectors/#lang-pseudo\n\t\t\t\t\t\"lang\": markFunction( function( lang ) {\n\t\t\t\t\t\t// lang value must be a valid identifier\n\t\t\t\t\t\tif ( !ridentifier.test(lang || \"\") ) {\n\t\t\t\t\t\t\tSizzle.error( \"unsupported lang: \" + lang );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tlang = lang.replace( runescape, funescape ).toLowerCase();\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\tvar elemLang;\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\tif ( (elemLang = documentIsHTML ?\n\t\t\t\t\t\t\t\t\t\telem.lang :\n\t\t\t\t\t\t\t\t\telem.getAttribute(\"xml:lang\") || elem.getAttribute(\"lang\")) ) {\n\n\t\t\t\t\t\t\t\t\telemLang = elemLang.toLowerCase();\n\t\t\t\t\t\t\t\t\treturn elemLang === lang || elemLang.indexOf( lang + \"-\" ) === 0;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} while ( (elem = elem.parentNode) && elem.nodeType === 1 );\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t// Miscellaneous\n\t\t\t\t\t\"target\": function( elem ) {\n\t\t\t\t\t\tvar hash = window.location && window.location.hash;\n\t\t\t\t\t\treturn hash && hash.slice( 1 ) === elem.id;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"root\": function( elem ) {\n\t\t\t\t\t\treturn elem === docElem;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"focus\": function( elem ) {\n\t\t\t\t\t\treturn elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);\n\t\t\t\t\t},\n\n\t\t\t\t\t// Boolean properties\n\t\t\t\t\t\"enabled\": function( elem ) {\n\t\t\t\t\t\treturn elem.disabled === false;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"disabled\": function( elem ) {\n\t\t\t\t\t\treturn elem.disabled === true;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"checked\": function( elem ) {\n\t\t\t\t\t\t// In CSS3, :checked should return both checked and selected elements\n\t\t\t\t\t\t// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked\n\t\t\t\t\t\tvar nodeName = elem.nodeName.toLowerCase();\n\t\t\t\t\t\treturn (nodeName === \"input\" && !!elem.checked) || (nodeName === \"option\" && !!elem.selected);\n\t\t\t\t\t},\n\n\t\t\t\t\t\"selected\": function( elem ) {\n\t\t\t\t\t\t// Accessing this property makes selected-by-default\n\t\t\t\t\t\t// options in Safari work properly\n\t\t\t\t\t\tif ( elem.parentNode ) {\n\t\t\t\t\t\t\telem.parentNode.selectedIndex;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn elem.selected === true;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Contents\n\t\t\t\t\t\"empty\": function( elem ) {\n\t\t\t\t\t\t// http://www.w3.org/TR/selectors/#empty-pseudo\n\t\t\t\t\t\t// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),\n\t\t\t\t\t\t//   but not by others (comment: 8; processing instruction: 7; etc.)\n\t\t\t\t\t\t// nodeType < 6 works because attributes (2) do not appear as children\n\t\t\t\t\t\tfor ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {\n\t\t\t\t\t\t\tif ( elem.nodeType < 6 ) {\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"parent\": function( elem ) {\n\t\t\t\t\t\treturn !Expr.pseudos[\"empty\"]( elem );\n\t\t\t\t\t},\n\n\t\t\t\t\t// Element/input types\n\t\t\t\t\t\"header\": function( elem ) {\n\t\t\t\t\t\treturn rheader.test( elem.nodeName );\n\t\t\t\t\t},\n\n\t\t\t\t\t\"input\": function( elem ) {\n\t\t\t\t\t\treturn rinputs.test( elem.nodeName );\n\t\t\t\t\t},\n\n\t\t\t\t\t\"button\": function( elem ) {\n\t\t\t\t\t\tvar name = elem.nodeName.toLowerCase();\n\t\t\t\t\t\treturn name === \"input\" && elem.type === \"button\" || name === \"button\";\n\t\t\t\t\t},\n\n\t\t\t\t\t\"text\": function( elem ) {\n\t\t\t\t\t\tvar attr;\n\t\t\t\t\t\treturn elem.nodeName.toLowerCase() === \"input\" &&\n\t\t\t\t\t\t\telem.type === \"text\" &&\n\n\t\t\t\t\t\t\t// Support: IE<8\n\t\t\t\t\t\t\t// New HTML5 attribute values (e.g., \"search\") appear with elem.type === \"text\"\n\t\t\t\t\t\t\t( (attr = elem.getAttribute(\"type\")) == null || attr.toLowerCase() === \"text\" );\n\t\t\t\t\t},\n\n\t\t\t\t\t// Position-in-collection\n\t\t\t\t\t\"first\": createPositionalPseudo(function() {\n\t\t\t\t\t\treturn [ 0 ];\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"last\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\t\t\t\treturn [ length - 1 ];\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"eq\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\t\t\t\treturn [ argument < 0 ? argument + length : argument ];\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"even\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\t\t\t\tvar i = 0;\n\t\t\t\t\t\tfor ( ; i < length; i += 2 ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"odd\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\t\t\t\tvar i = 1;\n\t\t\t\t\t\tfor ( ; i < length; i += 2 ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"lt\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\t\t\t\tvar i = argument < 0 ? argument + length : argument;\n\t\t\t\t\t\tfor ( ; --i >= 0; ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"gt\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\t\t\t\tvar i = argument < 0 ? argument + length : argument;\n\t\t\t\t\t\tfor ( ; ++i < length; ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t})\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tExpr.pseudos[\"nth\"] = Expr.pseudos[\"eq\"];\n\n// Add button/input type pseudos\n\t\t\tfor ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {\n\t\t\t\tExpr.pseudos[ i ] = createInputPseudo( i );\n\t\t\t}\n\t\t\tfor ( i in { submit: true, reset: true } ) {\n\t\t\t\tExpr.pseudos[ i ] = createButtonPseudo( i );\n\t\t\t}\n\n// Easy API for creating new setFilters\n\t\t\tfunction setFilters() {}\n\t\t\tsetFilters.prototype = Expr.filters = Expr.pseudos;\n\t\t\tExpr.setFilters = new setFilters();\n\n\t\t\ttokenize = Sizzle.tokenize = function( selector, parseOnly ) {\n\t\t\t\tvar matched, match, tokens, type,\n\t\t\t\t\tsoFar, groups, preFilters,\n\t\t\t\t\tcached = tokenCache[ selector + \" \" ];\n\n\t\t\t\tif ( cached ) {\n\t\t\t\t\treturn parseOnly ? 0 : cached.slice( 0 );\n\t\t\t\t}\n\n\t\t\t\tsoFar = selector;\n\t\t\t\tgroups = [];\n\t\t\t\tpreFilters = Expr.preFilter;\n\n\t\t\t\twhile ( soFar ) {\n\n\t\t\t\t\t// Comma and first run\n\t\t\t\t\tif ( !matched || (match = rcomma.exec( soFar )) ) {\n\t\t\t\t\t\tif ( match ) {\n\t\t\t\t\t\t\t// Don't consume trailing commas as valid\n\t\t\t\t\t\t\tsoFar = soFar.slice( match[0].length ) || soFar;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tgroups.push( (tokens = []) );\n\t\t\t\t\t}\n\n\t\t\t\t\tmatched = false;\n\n\t\t\t\t\t// Combinators\n\t\t\t\t\tif ( (match = rcombinators.exec( soFar )) ) {\n\t\t\t\t\t\tmatched = match.shift();\n\t\t\t\t\t\ttokens.push({\n\t\t\t\t\t\t\tvalue: matched,\n\t\t\t\t\t\t\t// Cast descendant combinators to space\n\t\t\t\t\t\t\ttype: match[0].replace( rtrim, \" \" )\n\t\t\t\t\t\t});\n\t\t\t\t\t\tsoFar = soFar.slice( matched.length );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Filters\n\t\t\t\t\tfor ( type in Expr.filter ) {\n\t\t\t\t\t\tif ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||\n\t\t\t\t\t\t\t(match = preFilters[ type ]( match ))) ) {\n\t\t\t\t\t\t\tmatched = match.shift();\n\t\t\t\t\t\t\ttokens.push({\n\t\t\t\t\t\t\t\tvalue: matched,\n\t\t\t\t\t\t\t\ttype: type,\n\t\t\t\t\t\t\t\tmatches: match\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tsoFar = soFar.slice( matched.length );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( !matched ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Return the length of the invalid excess\n\t\t\t\t// if we're just parsing\n\t\t\t\t// Otherwise, throw an error or return tokens\n\t\t\t\treturn parseOnly ?\n\t\t\t\t\tsoFar.length :\n\t\t\t\t\tsoFar ?\n\t\t\t\t\t\tSizzle.error( selector ) :\n\t\t\t\t\t\t// Cache the tokens\n\t\t\t\t\t\ttokenCache( selector, groups ).slice( 0 );\n\t\t\t};\n\n\t\t\tfunction toSelector( tokens ) {\n\t\t\t\tvar i = 0,\n\t\t\t\t\tlen = tokens.length,\n\t\t\t\t\tselector = \"\";\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tselector += tokens[i].value;\n\t\t\t\t}\n\t\t\t\treturn selector;\n\t\t\t}\n\n\t\t\tfunction addCombinator( matcher, combinator, base ) {\n\t\t\t\tvar dir = combinator.dir,\n\t\t\t\t\tcheckNonElements = base && dir === \"parentNode\",\n\t\t\t\t\tdoneName = done++;\n\n\t\t\t\treturn combinator.first ?\n\t\t\t\t\t// Check against closest ancestor/preceding element\n\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\t\t\t\treturn matcher( elem, context, xml );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} :\n\n\t\t\t\t\t// Check against all ancestor/preceding elements\n\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\tvar oldCache, uniqueCache, outerCache,\n\t\t\t\t\t\t\tnewCache = [ dirruns, doneName ];\n\n\t\t\t\t\t\t// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching\n\t\t\t\t\t\tif ( xml ) {\n\t\t\t\t\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\t\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\t\t\t\t\tif ( matcher( elem, context, xml ) ) {\n\t\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\t\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\t\t\t\t\touterCache = elem[ expando ] || (elem[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ elem.uniqueID ] || (outerCache[ elem.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\tif ( (oldCache = uniqueCache[ dir ]) &&\n\t\t\t\t\t\t\t\t\t\toldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {\n\n\t\t\t\t\t\t\t\t\t\t// Assign to newCache so results back-propagate to previous elements\n\t\t\t\t\t\t\t\t\t\treturn (newCache[ 2 ] = oldCache[ 2 ]);\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\t// Reuse newcache so results back-propagate to previous elements\n\t\t\t\t\t\t\t\t\t\tuniqueCache[ dir ] = newCache;\n\n\t\t\t\t\t\t\t\t\t\t// A match means we're done; a fail means we have to keep checking\n\t\t\t\t\t\t\t\t\t\tif ( (newCache[ 2 ] = matcher( elem, context, xml )) ) {\n\t\t\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t}\n\n\t\t\tfunction elementMatcher( matchers ) {\n\t\t\t\treturn matchers.length > 1 ?\n\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\tvar i = matchers.length;\n\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\tif ( !matchers[i]( elem, context, xml ) ) {\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t} :\n\t\t\t\t\tmatchers[0];\n\t\t\t}\n\n\t\t\tfunction multipleContexts( selector, contexts, results ) {\n\t\t\t\tvar i = 0,\n\t\t\t\t\tlen = contexts.length;\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tSizzle( selector, contexts[i], results );\n\t\t\t\t}\n\t\t\t\treturn results;\n\t\t\t}\n\n\t\t\tfunction condense( unmatched, map, filter, context, xml ) {\n\t\t\t\tvar elem,\n\t\t\t\t\tnewUnmatched = [],\n\t\t\t\t\ti = 0,\n\t\t\t\t\tlen = unmatched.length,\n\t\t\t\t\tmapped = map != null;\n\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tif ( (elem = unmatched[i]) ) {\n\t\t\t\t\t\tif ( !filter || filter( elem, context, xml ) ) {\n\t\t\t\t\t\t\tnewUnmatched.push( elem );\n\t\t\t\t\t\t\tif ( mapped ) {\n\t\t\t\t\t\t\t\tmap.push( i );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn newUnmatched;\n\t\t\t}\n\n\t\t\tfunction setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {\n\t\t\t\tif ( postFilter && !postFilter[ expando ] ) {\n\t\t\t\t\tpostFilter = setMatcher( postFilter );\n\t\t\t\t}\n\t\t\t\tif ( postFinder && !postFinder[ expando ] ) {\n\t\t\t\t\tpostFinder = setMatcher( postFinder, postSelector );\n\t\t\t\t}\n\t\t\t\treturn markFunction(function( seed, results, context, xml ) {\n\t\t\t\t\tvar temp, i, elem,\n\t\t\t\t\t\tpreMap = [],\n\t\t\t\t\t\tpostMap = [],\n\t\t\t\t\t\tpreexisting = results.length,\n\n\t\t\t\t\t\t// Get initial elements from seed or context\n\t\t\t\t\t\telems = seed || multipleContexts( selector || \"*\", context.nodeType ? [ context ] : context, [] ),\n\n\t\t\t\t\t\t// Prefilter to get matcher input, preserving a map for seed-results synchronization\n\t\t\t\t\t\tmatcherIn = preFilter && ( seed || !selector ) ?\n\t\t\t\t\t\t\tcondense( elems, preMap, preFilter, context, xml ) :\n\t\t\t\t\t\t\telems,\n\n\t\t\t\t\t\tmatcherOut = matcher ?\n\t\t\t\t\t\t\t// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,\n\t\t\t\t\t\t\tpostFinder || ( seed ? preFilter : preexisting || postFilter ) ?\n\n\t\t\t\t\t\t\t\t// ...intermediate processing is necessary\n\t\t\t\t\t\t\t\t[] :\n\n\t\t\t\t\t\t\t\t// ...otherwise use results directly\n\t\t\t\t\t\t\t\tresults :\n\t\t\t\t\t\t\tmatcherIn;\n\n\t\t\t\t\t// Find primary matches\n\t\t\t\t\tif ( matcher ) {\n\t\t\t\t\t\tmatcher( matcherIn, matcherOut, context, xml );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Apply postFilter\n\t\t\t\t\tif ( postFilter ) {\n\t\t\t\t\t\ttemp = condense( matcherOut, postMap );\n\t\t\t\t\t\tpostFilter( temp, [], context, xml );\n\n\t\t\t\t\t\t// Un-match failing elements by moving them back to matcherIn\n\t\t\t\t\t\ti = temp.length;\n\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\tif ( (elem = temp[i]) ) {\n\t\t\t\t\t\t\t\tmatcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( seed ) {\n\t\t\t\t\t\tif ( postFinder || preFilter ) {\n\t\t\t\t\t\t\tif ( postFinder ) {\n\t\t\t\t\t\t\t\t// Get the final matcherOut by condensing this intermediate into postFinder contexts\n\t\t\t\t\t\t\t\ttemp = [];\n\t\t\t\t\t\t\t\ti = matcherOut.length;\n\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\tif ( (elem = matcherOut[i]) ) {\n\t\t\t\t\t\t\t\t\t\t// Restore matcherIn since elem is not yet a final match\n\t\t\t\t\t\t\t\t\t\ttemp.push( (matcherIn[i] = elem) );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tpostFinder( null, (matcherOut = []), temp, xml );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Move matched elements from seed to results to keep them synchronized\n\t\t\t\t\t\t\ti = matcherOut.length;\n\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\tif ( (elem = matcherOut[i]) &&\n\t\t\t\t\t\t\t\t\t(temp = postFinder ? indexOf( seed, elem ) : preMap[i]) > -1 ) {\n\n\t\t\t\t\t\t\t\t\tseed[temp] = !(results[temp] = elem);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Add elements to results, through postFinder if defined\n\t\t\t\t\t} else {\n\t\t\t\t\t\tmatcherOut = condense(\n\t\t\t\t\t\t\tmatcherOut === results ?\n\t\t\t\t\t\t\t\tmatcherOut.splice( preexisting, matcherOut.length ) :\n\t\t\t\t\t\t\t\tmatcherOut\n\t\t\t\t\t\t);\n\t\t\t\t\t\tif ( postFinder ) {\n\t\t\t\t\t\t\tpostFinder( null, results, matcherOut, xml );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tpush.apply( results, matcherOut );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tfunction matcherFromTokens( tokens ) {\n\t\t\t\tvar checkContext, matcher, j,\n\t\t\t\t\tlen = tokens.length,\n\t\t\t\t\tleadingRelative = Expr.relative[ tokens[0].type ],\n\t\t\t\t\timplicitRelative = leadingRelative || Expr.relative[\" \"],\n\t\t\t\t\ti = leadingRelative ? 1 : 0,\n\n\t\t\t\t\t// The foundational matcher ensures that elements are reachable from top-level context(s)\n\t\t\t\t\tmatchContext = addCombinator( function( elem ) {\n\t\t\t\t\t\treturn elem === checkContext;\n\t\t\t\t\t}, implicitRelative, true ),\n\t\t\t\t\tmatchAnyContext = addCombinator( function( elem ) {\n\t\t\t\t\t\treturn indexOf( checkContext, elem ) > -1;\n\t\t\t\t\t}, implicitRelative, true ),\n\t\t\t\t\tmatchers = [ function( elem, context, xml ) {\n\t\t\t\t\t\tvar ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (\n\t\t\t\t\t\t\t\t(checkContext = context).nodeType ?\n\t\t\t\t\t\t\t\t\tmatchContext( elem, context, xml ) :\n\t\t\t\t\t\t\t\t\tmatchAnyContext( elem, context, xml ) );\n\t\t\t\t\t\t// Avoid hanging onto element (issue #299)\n\t\t\t\t\t\tcheckContext = null;\n\t\t\t\t\t\treturn ret;\n\t\t\t\t\t} ];\n\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tif ( (matcher = Expr.relative[ tokens[i].type ]) ) {\n\t\t\t\t\t\tmatchers = [ addCombinator(elementMatcher( matchers ), matcher) ];\n\t\t\t\t\t} else {\n\t\t\t\t\t\tmatcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );\n\n\t\t\t\t\t\t// Return special upon seeing a positional matcher\n\t\t\t\t\t\tif ( matcher[ expando ] ) {\n\t\t\t\t\t\t\t// Find the next relative operator (if any) for proper handling\n\t\t\t\t\t\t\tj = ++i;\n\t\t\t\t\t\t\tfor ( ; j < len; j++ ) {\n\t\t\t\t\t\t\t\tif ( Expr.relative[ tokens[j].type ] ) {\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn setMatcher(\n\t\t\t\t\t\t\t\ti > 1 && elementMatcher( matchers ),\n\t\t\t\t\t\t\t\ti > 1 && toSelector(\n\t\t\t\t\t\t\t\t\t// If the preceding token was a descendant combinator, insert an implicit any-element `*`\n\t\t\t\t\t\t\t\t\ttokens.slice( 0, i - 1 ).concat({ value: tokens[ i - 2 ].type === \" \" ? \"*\" : \"\" })\n\t\t\t\t\t\t\t\t).replace( rtrim, \"$1\" ),\n\t\t\t\t\t\t\t\tmatcher,\n\t\t\t\t\t\t\t\ti < j && matcherFromTokens( tokens.slice( i, j ) ),\n\t\t\t\t\t\t\t\tj < len && matcherFromTokens( (tokens = tokens.slice( j )) ),\n\t\t\t\t\t\t\t\tj < len && toSelector( tokens )\n\t\t\t\t\t\t\t);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tmatchers.push( matcher );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn elementMatcher( matchers );\n\t\t\t}\n\n\t\t\tfunction matcherFromGroupMatchers( elementMatchers, setMatchers ) {\n\t\t\t\tvar bySet = setMatchers.length > 0,\n\t\t\t\t\tbyElement = elementMatchers.length > 0,\n\t\t\t\t\tsuperMatcher = function( seed, context, xml, results, outermost ) {\n\t\t\t\t\t\tvar elem, j, matcher,\n\t\t\t\t\t\t\tmatchedCount = 0,\n\t\t\t\t\t\t\ti = \"0\",\n\t\t\t\t\t\t\tunmatched = seed && [],\n\t\t\t\t\t\t\tsetMatched = [],\n\t\t\t\t\t\t\tcontextBackup = outermostContext,\n\t\t\t\t\t\t\t// We must always have either seed elements or outermost context\n\t\t\t\t\t\t\telems = seed || byElement && Expr.find[\"TAG\"]( \"*\", outermost ),\n\t\t\t\t\t\t\t// Use integer dirruns iff this is the outermost matcher\n\t\t\t\t\t\t\tdirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1),\n\t\t\t\t\t\t\tlen = elems.length;\n\n\t\t\t\t\t\tif ( outermost ) {\n\t\t\t\t\t\t\toutermostContext = context === document || context || outermost;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Add elements passing elementMatchers directly to results\n\t\t\t\t\t\t// Support: IE<9, Safari\n\t\t\t\t\t\t// Tolerate NodeList properties (IE: \"length\"; Safari: <number>) matching elements by id\n\t\t\t\t\t\tfor ( ; i !== len && (elem = elems[i]) != null; i++ ) {\n\t\t\t\t\t\t\tif ( byElement && elem ) {\n\t\t\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\t\t\tif ( !context && elem.ownerDocument !== document ) {\n\t\t\t\t\t\t\t\t\tsetDocument( elem );\n\t\t\t\t\t\t\t\t\txml = !documentIsHTML;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\twhile ( (matcher = elementMatchers[j++]) ) {\n\t\t\t\t\t\t\t\t\tif ( matcher( elem, context || document, xml) ) {\n\t\t\t\t\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif ( outermost ) {\n\t\t\t\t\t\t\t\t\tdirruns = dirrunsUnique;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Track unmatched elements for set filters\n\t\t\t\t\t\t\tif ( bySet ) {\n\t\t\t\t\t\t\t\t// They will have gone through all possible matchers\n\t\t\t\t\t\t\t\tif ( (elem = !matcher && elem) ) {\n\t\t\t\t\t\t\t\t\tmatchedCount--;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Lengthen the array for every element, matched or not\n\t\t\t\t\t\t\t\tif ( seed ) {\n\t\t\t\t\t\t\t\t\tunmatched.push( elem );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// `i` is now the count of elements visited above, and adding it to `matchedCount`\n\t\t\t\t\t\t// makes the latter nonnegative.\n\t\t\t\t\t\tmatchedCount += i;\n\n\t\t\t\t\t\t// Apply set filters to unmatched elements\n\t\t\t\t\t\t// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`\n\t\t\t\t\t\t// equals `i`), unless we didn't visit _any_ elements in the above loop because we have\n\t\t\t\t\t\t// no element matchers and no seed.\n\t\t\t\t\t\t// Incrementing an initially-string \"0\" `i` allows `i` to remain a string only in that\n\t\t\t\t\t\t// case, which will result in a \"00\" `matchedCount` that differs from `i` but is also\n\t\t\t\t\t\t// numerically zero.\n\t\t\t\t\t\tif ( bySet && i !== matchedCount ) {\n\t\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\t\twhile ( (matcher = setMatchers[j++]) ) {\n\t\t\t\t\t\t\t\tmatcher( unmatched, setMatched, context, xml );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif ( seed ) {\n\t\t\t\t\t\t\t\t// Reintegrate element matches to eliminate the need for sorting\n\t\t\t\t\t\t\t\tif ( matchedCount > 0 ) {\n\t\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\t\tif ( !(unmatched[i] || setMatched[i]) ) {\n\t\t\t\t\t\t\t\t\t\t\tsetMatched[i] = pop.call( results );\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Discard index placeholder values to get only actual matches\n\t\t\t\t\t\t\t\tsetMatched = condense( setMatched );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Add matches to results\n\t\t\t\t\t\t\tpush.apply( results, setMatched );\n\n\t\t\t\t\t\t\t// Seedless set matches succeeding multiple successful matchers stipulate sorting\n\t\t\t\t\t\t\tif ( outermost && !seed && setMatched.length > 0 &&\n\t\t\t\t\t\t\t\t( matchedCount + setMatchers.length ) > 1 ) {\n\n\t\t\t\t\t\t\t\tSizzle.uniqueSort( results );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Override manipulation of globals by nested matchers\n\t\t\t\t\t\tif ( outermost ) {\n\t\t\t\t\t\t\tdirruns = dirrunsUnique;\n\t\t\t\t\t\t\toutermostContext = contextBackup;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn unmatched;\n\t\t\t\t\t};\n\n\t\t\t\treturn bySet ?\n\t\t\t\t\tmarkFunction( superMatcher ) :\n\t\t\t\t\tsuperMatcher;\n\t\t\t}\n\n\t\t\tcompile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {\n\t\t\t\tvar i,\n\t\t\t\t\tsetMatchers = [],\n\t\t\t\t\telementMatchers = [],\n\t\t\t\t\tcached = compilerCache[ selector + \" \" ];\n\n\t\t\t\tif ( !cached ) {\n\t\t\t\t\t// Generate a function of recursive functions that can be used to check each element\n\t\t\t\t\tif ( !match ) {\n\t\t\t\t\t\tmatch = tokenize( selector );\n\t\t\t\t\t}\n\t\t\t\t\ti = match.length;\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\tcached = matcherFromTokens( match[i] );\n\t\t\t\t\t\tif ( cached[ expando ] ) {\n\t\t\t\t\t\t\tsetMatchers.push( cached );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\telementMatchers.push( cached );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Cache the compiled function\n\t\t\t\t\tcached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );\n\n\t\t\t\t\t// Save selector and tokenization\n\t\t\t\t\tcached.selector = selector;\n\t\t\t\t}\n\t\t\t\treturn cached;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * A low-level selection function that works with Sizzle's compiled\n\t\t\t *  selector functions\n\t\t\t * @param {String|Function} selector A selector or a pre-compiled\n\t\t\t *  selector function built with Sizzle.compile\n\t\t\t * @param {Element} context\n\t\t\t * @param {Array} [results]\n\t\t\t * @param {Array} [seed] A set of elements to match against\n\t\t\t */\n\t\t\tselect = Sizzle.select = function( selector, context, results, seed ) {\n\t\t\t\tvar i, tokens, token, type, find,\n\t\t\t\t\tcompiled = typeof selector === \"function\" && selector,\n\t\t\t\t\tmatch = !seed && tokenize( (selector = compiled.selector || selector) );\n\n\t\t\t\tresults = results || [];\n\n\t\t\t\t// Try to minimize operations if there is only one selector in the list and no seed\n\t\t\t\t// (the latter of which guarantees us context)\n\t\t\t\tif ( match.length === 1 ) {\n\n\t\t\t\t\t// Reduce context if the leading compound selector is an ID\n\t\t\t\t\ttokens = match[0] = match[0].slice( 0 );\n\t\t\t\t\tif ( tokens.length > 2 && (token = tokens[0]).type === \"ID\" &&\n\t\t\t\t\t\tsupport.getById && context.nodeType === 9 && documentIsHTML &&\n\t\t\t\t\t\tExpr.relative[ tokens[1].type ] ) {\n\n\t\t\t\t\t\tcontext = ( Expr.find[\"ID\"]( token.matches[0].replace(runescape, funescape), context ) || [] )[0];\n\t\t\t\t\t\tif ( !context ) {\n\t\t\t\t\t\t\treturn results;\n\n\t\t\t\t\t\t\t// Precompiled matchers will still verify ancestry, so step up a level\n\t\t\t\t\t\t} else if ( compiled ) {\n\t\t\t\t\t\t\tcontext = context.parentNode;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tselector = selector.slice( tokens.shift().value.length );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Fetch a seed set for right-to-left matching\n\t\t\t\t\ti = matchExpr[\"needsContext\"].test( selector ) ? 0 : tokens.length;\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\ttoken = tokens[i];\n\n\t\t\t\t\t\t// Abort if we hit a combinator\n\t\t\t\t\t\tif ( Expr.relative[ (type = token.type) ] ) {\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( (find = Expr.find[ type ]) ) {\n\t\t\t\t\t\t\t// Search, expanding context for leading sibling combinators\n\t\t\t\t\t\t\tif ( (seed = find(\n\t\t\t\t\t\t\t\t\ttoken.matches[0].replace( runescape, funescape ),\n\t\t\t\t\t\t\t\t\trsibling.test( tokens[0].type ) && testContext( context.parentNode ) || context\n\t\t\t\t\t\t\t\t)) ) {\n\n\t\t\t\t\t\t\t\t// If seed is empty or no tokens remain, we can return early\n\t\t\t\t\t\t\t\ttokens.splice( i, 1 );\n\t\t\t\t\t\t\t\tselector = seed.length && toSelector( tokens );\n\t\t\t\t\t\t\t\tif ( !selector ) {\n\t\t\t\t\t\t\t\t\tpush.apply( results, seed );\n\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Compile and execute a filtering function if one is not provided\n\t\t\t\t// Provide `match` to avoid retokenization if we modified the selector above\n\t\t\t\t( compiled || compile( selector, match ) )(\n\t\t\t\t\tseed,\n\t\t\t\t\tcontext,\n\t\t\t\t\t!documentIsHTML,\n\t\t\t\t\tresults,\n\t\t\t\t\t!context || rsibling.test( selector ) && testContext( context.parentNode ) || context\n\t\t\t\t);\n\t\t\t\treturn results;\n\t\t\t};\n\n// One-time assignments\n\n// Sort stability\n\t\t\tsupport.sortStable = expando.split(\"\").sort( sortOrder ).join(\"\") === expando;\n\n// Support: Chrome 14-35+\n// Always assume duplicates if they aren't passed to the comparison function\n\t\t\tsupport.detectDuplicates = !!hasDuplicate;\n\n// Initialize against the default document\n\t\t\tsetDocument();\n\n// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)\n// Detached nodes confoundingly follow *each other*\n\t\t\tsupport.sortDetached = assert(function( div1 ) {\n\t\t\t\t// Should return 1, but returns 4 (following)\n\t\t\t\treturn div1.compareDocumentPosition( document.createElement(\"div\") ) & 1;\n\t\t\t});\n\n// Support: IE<8\n// Prevent attribute/property \"interpolation\"\n// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx\n\t\t\tif ( !assert(function( div ) {\n\t\t\t\t\tdiv.innerHTML = \"<a href='#'></a>\";\n\t\t\t\t\treturn div.firstChild.getAttribute(\"href\") === \"#\" ;\n\t\t\t\t}) ) {\n\t\t\t\taddHandle( \"type|href|height|width\", function( elem, name, isXML ) {\n\t\t\t\t\tif ( !isXML ) {\n\t\t\t\t\t\treturn elem.getAttribute( name, name.toLowerCase() === \"type\" ? 1 : 2 );\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n// Support: IE<9\n// Use defaultValue in place of getAttribute(\"value\")\n\t\t\tif ( !support.attributes || !assert(function( div ) {\n\t\t\t\t\tdiv.innerHTML = \"<input/>\";\n\t\t\t\t\tdiv.firstChild.setAttribute( \"value\", \"\" );\n\t\t\t\t\treturn div.firstChild.getAttribute( \"value\" ) === \"\";\n\t\t\t\t}) ) {\n\t\t\t\taddHandle( \"value\", function( elem, name, isXML ) {\n\t\t\t\t\tif ( !isXML && elem.nodeName.toLowerCase() === \"input\" ) {\n\t\t\t\t\t\treturn elem.defaultValue;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n// Support: IE<9\n// Use getAttributeNode to fetch booleans when getAttribute lies\n\t\t\tif ( !assert(function( div ) {\n\t\t\t\t\treturn div.getAttribute(\"disabled\") == null;\n\t\t\t\t}) ) {\n\t\t\t\taddHandle( booleans, function( elem, name, isXML ) {\n\t\t\t\t\tvar val;\n\t\t\t\t\tif ( !isXML ) {\n\t\t\t\t\t\treturn elem[ name ] === true ? name.toLowerCase() :\n\t\t\t\t\t\t\t(val = elem.getAttributeNode( name )) && val.specified ?\n\t\t\t\t\t\t\t\tval.value :\n\t\t\t\t\t\t\t\tnull;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn Sizzle;\n\n\t\t})( window );\n\n\n\n\tjQuery.find = Sizzle;\n\tjQuery.expr = Sizzle.selectors;\n\tjQuery.expr[ \":\" ] = jQuery.expr.pseudos;\n\tjQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;\n\tjQuery.text = Sizzle.getText;\n\tjQuery.isXMLDoc = Sizzle.isXML;\n\tjQuery.contains = Sizzle.contains;\n\n\n\n\tvar dir = function( elem, dir, until ) {\n\t\tvar matched = [],\n\t\t\ttruncate = until !== undefined;\n\n\t\twhile ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {\n\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\tif ( truncate && jQuery( elem ).is( until ) ) {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tmatched.push( elem );\n\t\t\t}\n\t\t}\n\t\treturn matched;\n\t};\n\n\n\tvar siblings = function( n, elem ) {\n\t\tvar matched = [];\n\n\t\tfor ( ; n; n = n.nextSibling ) {\n\t\t\tif ( n.nodeType === 1 && n !== elem ) {\n\t\t\t\tmatched.push( n );\n\t\t\t}\n\t\t}\n\n\t\treturn matched;\n\t};\n\n\n\tvar rneedsContext = jQuery.expr.match.needsContext;\n\n\tvar rsingleTag = ( /^<([\\w-]+)\\s*\\/?>(?:<\\/\\1>|)$/ );\n\n\n\n\tvar risSimple = /^.[^:#\\[\\.,]*$/;\n\n// Implement the identical functionality for filter and not\n\tfunction winnow( elements, qualifier, not ) {\n\t\tif ( jQuery.isFunction( qualifier ) ) {\n\t\t\treturn jQuery.grep( elements, function( elem, i ) {\n\t\t\t\t/* jshint -W018 */\n\t\t\t\treturn !!qualifier.call( elem, i, elem ) !== not;\n\t\t\t} );\n\n\t\t}\n\n\t\tif ( qualifier.nodeType ) {\n\t\t\treturn jQuery.grep( elements, function( elem ) {\n\t\t\t\treturn ( elem === qualifier ) !== not;\n\t\t\t} );\n\n\t\t}\n\n\t\tif ( typeof qualifier === \"string\" ) {\n\t\t\tif ( risSimple.test( qualifier ) ) {\n\t\t\t\treturn jQuery.filter( qualifier, elements, not );\n\t\t\t}\n\n\t\t\tqualifier = jQuery.filter( qualifier, elements );\n\t\t}\n\n\t\treturn jQuery.grep( elements, function( elem ) {\n\t\t\treturn ( jQuery.inArray( elem, qualifier ) > -1 ) !== not;\n\t\t} );\n\t}\n\n\tjQuery.filter = function( expr, elems, not ) {\n\t\tvar elem = elems[ 0 ];\n\n\t\tif ( not ) {\n\t\t\texpr = \":not(\" + expr + \")\";\n\t\t}\n\n\t\treturn elems.length === 1 && elem.nodeType === 1 ?\n\t\t\tjQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [] :\n\t\t\tjQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {\n\t\t\t\treturn elem.nodeType === 1;\n\t\t\t} ) );\n\t};\n\n\tjQuery.fn.extend( {\n\t\tfind: function( selector ) {\n\t\t\tvar i,\n\t\t\t\tret = [],\n\t\t\t\tself = this,\n\t\t\t\tlen = self.length;\n\n\t\t\tif ( typeof selector !== \"string\" ) {\n\t\t\t\treturn this.pushStack( jQuery( selector ).filter( function() {\n\t\t\t\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\t\t\t\tif ( jQuery.contains( self[ i ], this ) ) {\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} ) );\n\t\t\t}\n\n\t\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\t\tjQuery.find( selector, self[ i ], ret );\n\t\t\t}\n\n\t\t\t// Needed because $( selector, context ) becomes $( context ).find( selector )\n\t\t\tret = this.pushStack( len > 1 ? jQuery.unique( ret ) : ret );\n\t\t\tret.selector = this.selector ? this.selector + \" \" + selector : selector;\n\t\t\treturn ret;\n\t\t},\n\t\tfilter: function( selector ) {\n\t\t\treturn this.pushStack( winnow( this, selector || [], false ) );\n\t\t},\n\t\tnot: function( selector ) {\n\t\t\treturn this.pushStack( winnow( this, selector || [], true ) );\n\t\t},\n\t\tis: function( selector ) {\n\t\t\treturn !!winnow(\n\t\t\t\tthis,\n\n\t\t\t\t// If this is a positional/relative selector, check membership in the returned set\n\t\t\t\t// so $(\"p:first\").is(\"p:last\") won't return true for a doc with two \"p\".\n\t\t\t\ttypeof selector === \"string\" && rneedsContext.test( selector ) ?\n\t\t\t\t\tjQuery( selector ) :\n\t\t\t\tselector || [],\n\t\t\t\tfalse\n\t\t\t).length;\n\t\t}\n\t} );\n\n\n// Initialize a jQuery object\n\n\n// A central reference to the root jQuery(document)\n\tvar rootjQuery,\n\n\t\t// A simple way to check for HTML strings\n\t\t// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)\n\t\t// Strict HTML recognition (#11290: must start with <)\n\t\trquickExpr = /^(?:\\s*(<[\\w\\W]+>)[^>]*|#([\\w-]*))$/,\n\n\t\tinit = jQuery.fn.init = function( selector, context, root ) {\n\t\t\tvar match, elem;\n\n\t\t\t// HANDLE: $(\"\"), $(null), $(undefined), $(false)\n\t\t\tif ( !selector ) {\n\t\t\t\treturn this;\n\t\t\t}\n\n\t\t\t// init accepts an alternate rootjQuery\n\t\t\t// so migrate can support jQuery.sub (gh-2101)\n\t\t\troot = root || rootjQuery;\n\n\t\t\t// Handle HTML strings\n\t\t\tif ( typeof selector === \"string\" ) {\n\t\t\t\tif ( selector.charAt( 0 ) === \"<\" &&\n\t\t\t\t\tselector.charAt( selector.length - 1 ) === \">\" &&\n\t\t\t\t\tselector.length >= 3 ) {\n\n\t\t\t\t\t// Assume that strings that start and end with <> are HTML and skip the regex check\n\t\t\t\t\tmatch = [ null, selector, null ];\n\n\t\t\t\t} else {\n\t\t\t\t\tmatch = rquickExpr.exec( selector );\n\t\t\t\t}\n\n\t\t\t\t// Match html or make sure no context is specified for #id\n\t\t\t\tif ( match && ( match[ 1 ] || !context ) ) {\n\n\t\t\t\t\t// HANDLE: $(html) -> $(array)\n\t\t\t\t\tif ( match[ 1 ] ) {\n\t\t\t\t\t\tcontext = context instanceof jQuery ? context[ 0 ] : context;\n\n\t\t\t\t\t\t// scripts is true for back-compat\n\t\t\t\t\t\t// Intentionally let the error be thrown if parseHTML is not present\n\t\t\t\t\t\tjQuery.merge( this, jQuery.parseHTML(\n\t\t\t\t\t\t\tmatch[ 1 ],\n\t\t\t\t\t\t\tcontext && context.nodeType ? context.ownerDocument || context : document,\n\t\t\t\t\t\t\ttrue\n\t\t\t\t\t\t) );\n\n\t\t\t\t\t\t// HANDLE: $(html, props)\n\t\t\t\t\t\tif ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {\n\t\t\t\t\t\t\tfor ( match in context ) {\n\n\t\t\t\t\t\t\t\t// Properties of context are called as methods if possible\n\t\t\t\t\t\t\t\tif ( jQuery.isFunction( this[ match ] ) ) {\n\t\t\t\t\t\t\t\t\tthis[ match ]( context[ match ] );\n\n\t\t\t\t\t\t\t\t\t// ...and otherwise set as attributes\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tthis.attr( match, context[ match ] );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn this;\n\n\t\t\t\t\t\t// HANDLE: $(#id)\n\t\t\t\t\t} else {\n\t\t\t\t\t\telem = document.getElementById( match[ 2 ] );\n\n\t\t\t\t\t\t// Check parentNode to catch when Blackberry 4.6 returns\n\t\t\t\t\t\t// nodes that are no longer in the document #6963\n\t\t\t\t\t\tif ( elem && elem.parentNode ) {\n\n\t\t\t\t\t\t\t// Handle the case where IE and Opera return items\n\t\t\t\t\t\t\t// by name instead of ID\n\t\t\t\t\t\t\tif ( elem.id !== match[ 2 ] ) {\n\t\t\t\t\t\t\t\treturn rootjQuery.find( selector );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Otherwise, we inject the element directly into the jQuery object\n\t\t\t\t\t\t\tthis.length = 1;\n\t\t\t\t\t\t\tthis[ 0 ] = elem;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tthis.context = document;\n\t\t\t\t\t\tthis.selector = selector;\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t}\n\n\t\t\t\t\t// HANDLE: $(expr, $(...))\n\t\t\t\t} else if ( !context || context.jquery ) {\n\t\t\t\t\treturn ( context || root ).find( selector );\n\n\t\t\t\t\t// HANDLE: $(expr, context)\n\t\t\t\t\t// (which is just equivalent to: $(context).find(expr)\n\t\t\t\t} else {\n\t\t\t\t\treturn this.constructor( context ).find( selector );\n\t\t\t\t}\n\n\t\t\t\t// HANDLE: $(DOMElement)\n\t\t\t} else if ( selector.nodeType ) {\n\t\t\t\tthis.context = this[ 0 ] = selector;\n\t\t\t\tthis.length = 1;\n\t\t\t\treturn this;\n\n\t\t\t\t// HANDLE: $(function)\n\t\t\t\t// Shortcut for document ready\n\t\t\t} else if ( jQuery.isFunction( selector ) ) {\n\t\t\t\treturn typeof root.ready !== \"undefined\" ?\n\t\t\t\t\troot.ready( selector ) :\n\n\t\t\t\t\t// Execute immediately if ready is not present\n\t\t\t\t\tselector( jQuery );\n\t\t\t}\n\n\t\t\tif ( selector.selector !== undefined ) {\n\t\t\t\tthis.selector = selector.selector;\n\t\t\t\tthis.context = selector.context;\n\t\t\t}\n\n\t\t\treturn jQuery.makeArray( selector, this );\n\t\t};\n\n// Give the init function the jQuery prototype for later instantiation\n\tinit.prototype = jQuery.fn;\n\n// Initialize central reference\n\trootjQuery = jQuery( document );\n\n\n\tvar rparentsprev = /^(?:parents|prev(?:Until|All))/,\n\n\t\t// methods guaranteed to produce a unique set when starting from a unique set\n\t\tguaranteedUnique = {\n\t\t\tchildren: true,\n\t\t\tcontents: true,\n\t\t\tnext: true,\n\t\t\tprev: true\n\t\t};\n\n\tjQuery.fn.extend( {\n\t\thas: function( target ) {\n\t\t\tvar i,\n\t\t\t\ttargets = jQuery( target, this ),\n\t\t\t\tlen = targets.length;\n\n\t\t\treturn this.filter( function() {\n\t\t\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\t\t\tif ( jQuery.contains( this, targets[ i ] ) ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tclosest: function( selectors, context ) {\n\t\t\tvar cur,\n\t\t\t\ti = 0,\n\t\t\t\tl = this.length,\n\t\t\t\tmatched = [],\n\t\t\t\tpos = rneedsContext.test( selectors ) || typeof selectors !== \"string\" ?\n\t\t\t\t\tjQuery( selectors, context || this.context ) :\n\t\t\t\t\t0;\n\n\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\tfor ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {\n\n\t\t\t\t\t// Always skip document fragments\n\t\t\t\t\tif ( cur.nodeType < 11 && ( pos ?\n\t\t\t\t\t\tpos.index( cur ) > -1 :\n\n\t\t\t\t\t\t\t// Don't pass non-elements to Sizzle\n\t\t\t\t\t\tcur.nodeType === 1 &&\n\t\t\t\t\t\tjQuery.find.matchesSelector( cur, selectors ) ) ) {\n\n\t\t\t\t\t\tmatched.push( cur );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );\n\t\t},\n\n\t\t// Determine the position of an element within\n\t\t// the matched set of elements\n\t\tindex: function( elem ) {\n\n\t\t\t// No argument, return index in parent\n\t\t\tif ( !elem ) {\n\t\t\t\treturn ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;\n\t\t\t}\n\n\t\t\t// index in selector\n\t\t\tif ( typeof elem === \"string\" ) {\n\t\t\t\treturn jQuery.inArray( this[ 0 ], jQuery( elem ) );\n\t\t\t}\n\n\t\t\t// Locate the position of the desired element\n\t\t\treturn jQuery.inArray(\n\n\t\t\t\t// If it receives a jQuery object, the first element is used\n\t\t\t\telem.jquery ? elem[ 0 ] : elem, this );\n\t\t},\n\n\t\tadd: function( selector, context ) {\n\t\t\treturn this.pushStack(\n\t\t\t\tjQuery.uniqueSort(\n\t\t\t\t\tjQuery.merge( this.get(), jQuery( selector, context ) )\n\t\t\t\t)\n\t\t\t);\n\t\t},\n\n\t\taddBack: function( selector ) {\n\t\t\treturn this.add( selector == null ?\n\t\t\t\tthis.prevObject : this.prevObject.filter( selector )\n\t\t\t);\n\t\t}\n\t} );\n\n\tfunction sibling( cur, dir ) {\n\t\tdo {\n\t\t\tcur = cur[ dir ];\n\t\t} while ( cur && cur.nodeType !== 1 );\n\n\t\treturn cur;\n\t}\n\n\tjQuery.each( {\n\t\tparent: function( elem ) {\n\t\t\tvar parent = elem.parentNode;\n\t\t\treturn parent && parent.nodeType !== 11 ? parent : null;\n\t\t},\n\t\tparents: function( elem ) {\n\t\t\treturn dir( elem, \"parentNode\" );\n\t\t},\n\t\tparentsUntil: function( elem, i, until ) {\n\t\t\treturn dir( elem, \"parentNode\", until );\n\t\t},\n\t\tnext: function( elem ) {\n\t\t\treturn sibling( elem, \"nextSibling\" );\n\t\t},\n\t\tprev: function( elem ) {\n\t\t\treturn sibling( elem, \"previousSibling\" );\n\t\t},\n\t\tnextAll: function( elem ) {\n\t\t\treturn dir( elem, \"nextSibling\" );\n\t\t},\n\t\tprevAll: function( elem ) {\n\t\t\treturn dir( elem, \"previousSibling\" );\n\t\t},\n\t\tnextUntil: function( elem, i, until ) {\n\t\t\treturn dir( elem, \"nextSibling\", until );\n\t\t},\n\t\tprevUntil: function( elem, i, until ) {\n\t\t\treturn dir( elem, \"previousSibling\", until );\n\t\t},\n\t\tsiblings: function( elem ) {\n\t\t\treturn siblings( ( elem.parentNode || {} ).firstChild, elem );\n\t\t},\n\t\tchildren: function( elem ) {\n\t\t\treturn siblings( elem.firstChild );\n\t\t},\n\t\tcontents: function( elem ) {\n\t\t\treturn jQuery.nodeName( elem, \"iframe\" ) ?\n\t\t\telem.contentDocument || elem.contentWindow.document :\n\t\t\t\tjQuery.merge( [], elem.childNodes );\n\t\t}\n\t}, function( name, fn ) {\n\t\tjQuery.fn[ name ] = function( until, selector ) {\n\t\t\tvar ret = jQuery.map( this, fn, until );\n\n\t\t\tif ( name.slice( -5 ) !== \"Until\" ) {\n\t\t\t\tselector = until;\n\t\t\t}\n\n\t\t\tif ( selector && typeof selector === \"string\" ) {\n\t\t\t\tret = jQuery.filter( selector, ret );\n\t\t\t}\n\n\t\t\tif ( this.length > 1 ) {\n\n\t\t\t\t// Remove duplicates\n\t\t\t\tif ( !guaranteedUnique[ name ] ) {\n\t\t\t\t\tret = jQuery.uniqueSort( ret );\n\t\t\t\t}\n\n\t\t\t\t// Reverse order for parents* and prev-derivatives\n\t\t\t\tif ( rparentsprev.test( name ) ) {\n\t\t\t\t\tret = ret.reverse();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this.pushStack( ret );\n\t\t};\n\t} );\n\tvar rnotwhite = ( /\\S+/g );\n\n\n\n// Convert String-formatted options into Object-formatted ones\n\tfunction createOptions( options ) {\n\t\tvar object = {};\n\t\tjQuery.each( options.match( rnotwhite ) || [], function( _, flag ) {\n\t\t\tobject[ flag ] = true;\n\t\t} );\n\t\treturn object;\n\t}\n\n\t/*\n\t * Create a callback list using the following parameters:\n\t *\n\t *\toptions: an optional list of space-separated options that will change how\n\t *\t\t\tthe callback list behaves or a more traditional option object\n\t *\n\t * By default a callback list will act like an event callback list and can be\n\t * \"fired\" multiple times.\n\t *\n\t * Possible options:\n\t *\n\t *\tonce:\t\t\twill ensure the callback list can only be fired once (like a Deferred)\n\t *\n\t *\tmemory:\t\t\twill keep track of previous values and will call any callback added\n\t *\t\t\t\t\tafter the list has been fired right away with the latest \"memorized\"\n\t *\t\t\t\t\tvalues (like a Deferred)\n\t *\n\t *\tunique:\t\t\twill ensure a callback can only be added once (no duplicate in the list)\n\t *\n\t *\tstopOnFalse:\tinterrupt callings when a callback returns false\n\t *\n\t */\n\tjQuery.Callbacks = function( options ) {\n\n\t\t// Convert options from String-formatted to Object-formatted if needed\n\t\t// (we check in cache first)\n\t\toptions = typeof options === \"string\" ?\n\t\t\tcreateOptions( options ) :\n\t\t\tjQuery.extend( {}, options );\n\n\t\tvar // Flag to know if list is currently firing\n\t\t\tfiring,\n\n\t\t\t// Last fire value for non-forgettable lists\n\t\t\tmemory,\n\n\t\t\t// Flag to know if list was already fired\n\t\t\tfired,\n\n\t\t\t// Flag to prevent firing\n\t\t\tlocked,\n\n\t\t\t// Actual callback list\n\t\t\tlist = [],\n\n\t\t\t// Queue of execution data for repeatable lists\n\t\t\tqueue = [],\n\n\t\t\t// Index of currently firing callback (modified by add/remove as needed)\n\t\t\tfiringIndex = -1,\n\n\t\t\t// Fire callbacks\n\t\t\tfire = function() {\n\n\t\t\t\t// Enforce single-firing\n\t\t\t\tlocked = options.once;\n\n\t\t\t\t// Execute callbacks for all pending executions,\n\t\t\t\t// respecting firingIndex overrides and runtime changes\n\t\t\t\tfired = firing = true;\n\t\t\t\tfor ( ; queue.length; firingIndex = -1 ) {\n\t\t\t\t\tmemory = queue.shift();\n\t\t\t\t\twhile ( ++firingIndex < list.length ) {\n\n\t\t\t\t\t\t// Run callback and check for early termination\n\t\t\t\t\t\tif ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&\n\t\t\t\t\t\t\toptions.stopOnFalse ) {\n\n\t\t\t\t\t\t\t// Jump to end and forget the data so .add doesn't re-fire\n\t\t\t\t\t\t\tfiringIndex = list.length;\n\t\t\t\t\t\t\tmemory = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Forget the data if we're done with it\n\t\t\t\tif ( !options.memory ) {\n\t\t\t\t\tmemory = false;\n\t\t\t\t}\n\n\t\t\t\tfiring = false;\n\n\t\t\t\t// Clean up if we're done firing for good\n\t\t\t\tif ( locked ) {\n\n\t\t\t\t\t// Keep an empty list if we have data for future add calls\n\t\t\t\t\tif ( memory ) {\n\t\t\t\t\t\tlist = [];\n\n\t\t\t\t\t\t// Otherwise, this object is spent\n\t\t\t\t\t} else {\n\t\t\t\t\t\tlist = \"\";\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Actual Callbacks object\n\t\t\tself = {\n\n\t\t\t\t// Add a callback or a collection of callbacks to the list\n\t\t\t\tadd: function() {\n\t\t\t\t\tif ( list ) {\n\n\t\t\t\t\t\t// If we have memory from a past run, we should fire after adding\n\t\t\t\t\t\tif ( memory && !firing ) {\n\t\t\t\t\t\t\tfiringIndex = list.length - 1;\n\t\t\t\t\t\t\tqueue.push( memory );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t( function add( args ) {\n\t\t\t\t\t\t\tjQuery.each( args, function( _, arg ) {\n\t\t\t\t\t\t\t\tif ( jQuery.isFunction( arg ) ) {\n\t\t\t\t\t\t\t\t\tif ( !options.unique || !self.has( arg ) ) {\n\t\t\t\t\t\t\t\t\t\tlist.push( arg );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t} else if ( arg && arg.length && jQuery.type( arg ) !== \"string\" ) {\n\n\t\t\t\t\t\t\t\t\t// Inspect recursively\n\t\t\t\t\t\t\t\t\tadd( arg );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t} )( arguments );\n\n\t\t\t\t\t\tif ( memory && !firing ) {\n\t\t\t\t\t\t\tfire();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Remove a callback from the list\n\t\t\t\tremove: function() {\n\t\t\t\t\tjQuery.each( arguments, function( _, arg ) {\n\t\t\t\t\t\tvar index;\n\t\t\t\t\t\twhile ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {\n\t\t\t\t\t\t\tlist.splice( index, 1 );\n\n\t\t\t\t\t\t\t// Handle firing indexes\n\t\t\t\t\t\t\tif ( index <= firingIndex ) {\n\t\t\t\t\t\t\t\tfiringIndex--;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Check if a given callback is in the list.\n\t\t\t\t// If no argument is given, return whether or not list has callbacks attached.\n\t\t\t\thas: function( fn ) {\n\t\t\t\t\treturn fn ?\n\t\t\t\t\tjQuery.inArray( fn, list ) > -1 :\n\t\t\t\t\tlist.length > 0;\n\t\t\t\t},\n\n\t\t\t\t// Remove all callbacks from the list\n\t\t\t\tempty: function() {\n\t\t\t\t\tif ( list ) {\n\t\t\t\t\t\tlist = [];\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Disable .fire and .add\n\t\t\t\t// Abort any current/pending executions\n\t\t\t\t// Clear all callbacks and values\n\t\t\t\tdisable: function() {\n\t\t\t\t\tlocked = queue = [];\n\t\t\t\t\tlist = memory = \"\";\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\t\t\t\tdisabled: function() {\n\t\t\t\t\treturn !list;\n\t\t\t\t},\n\n\t\t\t\t// Disable .fire\n\t\t\t\t// Also disable .add unless we have memory (since it would have no effect)\n\t\t\t\t// Abort any pending executions\n\t\t\t\tlock: function() {\n\t\t\t\t\tlocked = true;\n\t\t\t\t\tif ( !memory ) {\n\t\t\t\t\t\tself.disable();\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\t\t\t\tlocked: function() {\n\t\t\t\t\treturn !!locked;\n\t\t\t\t},\n\n\t\t\t\t// Call all callbacks with the given context and arguments\n\t\t\t\tfireWith: function( context, args ) {\n\t\t\t\t\tif ( !locked ) {\n\t\t\t\t\t\targs = args || [];\n\t\t\t\t\t\targs = [ context, args.slice ? args.slice() : args ];\n\t\t\t\t\t\tqueue.push( args );\n\t\t\t\t\t\tif ( !firing ) {\n\t\t\t\t\t\t\tfire();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Call all the callbacks with the given arguments\n\t\t\t\tfire: function() {\n\t\t\t\t\tself.fireWith( this, arguments );\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// To know if the callbacks have already been called at least once\n\t\t\t\tfired: function() {\n\t\t\t\t\treturn !!fired;\n\t\t\t\t}\n\t\t\t};\n\n\t\treturn self;\n\t};\n\n\n\tjQuery.extend( {\n\n\t\tDeferred: function( func ) {\n\t\t\tvar tuples = [\n\n\t\t\t\t\t// action, add listener, listener list, final state\n\t\t\t\t\t[ \"resolve\", \"done\", jQuery.Callbacks( \"once memory\" ), \"resolved\" ],\n\t\t\t\t\t[ \"reject\", \"fail\", jQuery.Callbacks( \"once memory\" ), \"rejected\" ],\n\t\t\t\t\t[ \"notify\", \"progress\", jQuery.Callbacks( \"memory\" ) ]\n\t\t\t\t],\n\t\t\t\tstate = \"pending\",\n\t\t\t\tpromise = {\n\t\t\t\t\tstate: function() {\n\t\t\t\t\t\treturn state;\n\t\t\t\t\t},\n\t\t\t\t\talways: function() {\n\t\t\t\t\t\tdeferred.done( arguments ).fail( arguments );\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\t\t\t\t\tthen: function( /* fnDone, fnFail, fnProgress */ ) {\n\t\t\t\t\t\tvar fns = arguments;\n\t\t\t\t\t\treturn jQuery.Deferred( function( newDefer ) {\n\t\t\t\t\t\t\tjQuery.each( tuples, function( i, tuple ) {\n\t\t\t\t\t\t\t\tvar fn = jQuery.isFunction( fns[ i ] ) && fns[ i ];\n\n\t\t\t\t\t\t\t\t// deferred[ done | fail | progress ] for forwarding actions to newDefer\n\t\t\t\t\t\t\t\tdeferred[ tuple[ 1 ] ]( function() {\n\t\t\t\t\t\t\t\t\tvar returned = fn && fn.apply( this, arguments );\n\t\t\t\t\t\t\t\t\tif ( returned && jQuery.isFunction( returned.promise ) ) {\n\t\t\t\t\t\t\t\t\t\treturned.promise()\n\t\t\t\t\t\t\t\t\t\t\t.progress( newDefer.notify )\n\t\t\t\t\t\t\t\t\t\t\t.done( newDefer.resolve )\n\t\t\t\t\t\t\t\t\t\t\t.fail( newDefer.reject );\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tnewDefer[ tuple[ 0 ] + \"With\" ](\n\t\t\t\t\t\t\t\t\t\t\tthis === promise ? newDefer.promise() : this,\n\t\t\t\t\t\t\t\t\t\t\tfn ? [ returned ] : arguments\n\t\t\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t\tfns = null;\n\t\t\t\t\t\t} ).promise();\n\t\t\t\t\t},\n\n\t\t\t\t\t// Get a promise for this deferred\n\t\t\t\t\t// If obj is provided, the promise aspect is added to the object\n\t\t\t\t\tpromise: function( obj ) {\n\t\t\t\t\t\treturn obj != null ? jQuery.extend( obj, promise ) : promise;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tdeferred = {};\n\n\t\t\t// Keep pipe for back-compat\n\t\t\tpromise.pipe = promise.then;\n\n\t\t\t// Add list-specific methods\n\t\t\tjQuery.each( tuples, function( i, tuple ) {\n\t\t\t\tvar list = tuple[ 2 ],\n\t\t\t\t\tstateString = tuple[ 3 ];\n\n\t\t\t\t// promise[ done | fail | progress ] = list.add\n\t\t\t\tpromise[ tuple[ 1 ] ] = list.add;\n\n\t\t\t\t// Handle state\n\t\t\t\tif ( stateString ) {\n\t\t\t\t\tlist.add( function() {\n\n\t\t\t\t\t\t// state = [ resolved | rejected ]\n\t\t\t\t\t\tstate = stateString;\n\n\t\t\t\t\t\t// [ reject_list | resolve_list ].disable; progress_list.lock\n\t\t\t\t\t}, tuples[ i ^ 1 ][ 2 ].disable, tuples[ 2 ][ 2 ].lock );\n\t\t\t\t}\n\n\t\t\t\t// deferred[ resolve | reject | notify ]\n\t\t\t\tdeferred[ tuple[ 0 ] ] = function() {\n\t\t\t\t\tdeferred[ tuple[ 0 ] + \"With\" ]( this === deferred ? promise : this, arguments );\n\t\t\t\t\treturn this;\n\t\t\t\t};\n\t\t\t\tdeferred[ tuple[ 0 ] + \"With\" ] = list.fireWith;\n\t\t\t} );\n\n\t\t\t// Make the deferred a promise\n\t\t\tpromise.promise( deferred );\n\n\t\t\t// Call given func if any\n\t\t\tif ( func ) {\n\t\t\t\tfunc.call( deferred, deferred );\n\t\t\t}\n\n\t\t\t// All done!\n\t\t\treturn deferred;\n\t\t},\n\n\t\t// Deferred helper\n\t\twhen: function( subordinate /* , ..., subordinateN */ ) {\n\t\t\tvar i = 0,\n\t\t\t\tresolveValues = slice.call( arguments ),\n\t\t\t\tlength = resolveValues.length,\n\n\t\t\t\t// the count of uncompleted subordinates\n\t\t\t\tremaining = length !== 1 ||\n\t\t\t\t( subordinate && jQuery.isFunction( subordinate.promise ) ) ? length : 0,\n\n\t\t\t\t// the master Deferred.\n\t\t\t\t// If resolveValues consist of only a single Deferred, just use that.\n\t\t\t\tdeferred = remaining === 1 ? subordinate : jQuery.Deferred(),\n\n\t\t\t\t// Update function for both resolve and progress values\n\t\t\t\tupdateFunc = function( i, contexts, values ) {\n\t\t\t\t\treturn function( value ) {\n\t\t\t\t\t\tcontexts[ i ] = this;\n\t\t\t\t\t\tvalues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;\n\t\t\t\t\t\tif ( values === progressValues ) {\n\t\t\t\t\t\t\tdeferred.notifyWith( contexts, values );\n\n\t\t\t\t\t\t} else if ( !( --remaining ) ) {\n\t\t\t\t\t\t\tdeferred.resolveWith( contexts, values );\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t},\n\n\t\t\t\tprogressValues, progressContexts, resolveContexts;\n\n\t\t\t// add listeners to Deferred subordinates; treat others as resolved\n\t\t\tif ( length > 1 ) {\n\t\t\t\tprogressValues = new Array( length );\n\t\t\t\tprogressContexts = new Array( length );\n\t\t\t\tresolveContexts = new Array( length );\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tif ( resolveValues[ i ] && jQuery.isFunction( resolveValues[ i ].promise ) ) {\n\t\t\t\t\t\tresolveValues[ i ].promise()\n\t\t\t\t\t\t\t.progress( updateFunc( i, progressContexts, progressValues ) )\n\t\t\t\t\t\t\t.done( updateFunc( i, resolveContexts, resolveValues ) )\n\t\t\t\t\t\t\t.fail( deferred.reject );\n\t\t\t\t\t} else {\n\t\t\t\t\t\t--remaining;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// if we're not waiting on anything, resolve the master\n\t\t\tif ( !remaining ) {\n\t\t\t\tdeferred.resolveWith( resolveContexts, resolveValues );\n\t\t\t}\n\n\t\t\treturn deferred.promise();\n\t\t}\n\t} );\n\n\n// The deferred used on DOM ready\n\tvar readyList;\n\n\tjQuery.fn.ready = function( fn ) {\n\n\t\t// Add the callback\n\t\tjQuery.ready.promise().done( fn );\n\n\t\treturn this;\n\t};\n\n\tjQuery.extend( {\n\n\t\t// Is the DOM ready to be used? Set to true once it occurs.\n\t\tisReady: false,\n\n\t\t// A counter to track how many items to wait for before\n\t\t// the ready event fires. See #6781\n\t\treadyWait: 1,\n\n\t\t// Hold (or release) the ready event\n\t\tholdReady: function( hold ) {\n\t\t\tif ( hold ) {\n\t\t\t\tjQuery.readyWait++;\n\t\t\t} else {\n\t\t\t\tjQuery.ready( true );\n\t\t\t}\n\t\t},\n\n\t\t// Handle when the DOM is ready\n\t\tready: function( wait ) {\n\n\t\t\t// Abort if there are pending holds or we're already ready\n\t\t\tif ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Remember that the DOM is ready\n\t\t\tjQuery.isReady = true;\n\n\t\t\t// If a normal DOM Ready event fired, decrement, and wait if need be\n\t\t\tif ( wait !== true && --jQuery.readyWait > 0 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// If there are functions bound, to execute\n\t\t\treadyList.resolveWith( document, [ jQuery ] );\n\n\t\t\t// Trigger any bound ready events\n\t\t\tif ( jQuery.fn.triggerHandler ) {\n\t\t\t\tjQuery( document ).triggerHandler( \"ready\" );\n\t\t\t\tjQuery( document ).off( \"ready\" );\n\t\t\t}\n\t\t}\n\t} );\n\n\t/**\n\t * Clean-up method for dom ready events\n\t */\n\tfunction detach() {\n\t\tif ( document.addEventListener ) {\n\t\t\tdocument.removeEventListener( \"DOMContentLoaded\", completed );\n\t\t\twindow.removeEventListener( \"load\", completed );\n\n\t\t} else {\n\t\t\tdocument.detachEvent( \"onreadystatechange\", completed );\n\t\t\twindow.detachEvent( \"onload\", completed );\n\t\t}\n\t}\n\n\t/**\n\t * The ready event handler and self cleanup method\n\t */\n\tfunction completed() {\n\n\t\t// readyState === \"complete\" is good enough for us to call the dom ready in oldIE\n\t\tif ( document.addEventListener ||\n\t\t\twindow.event.type === \"load\" ||\n\t\t\tdocument.readyState === \"complete\" ) {\n\n\t\t\tdetach();\n\t\t\tjQuery.ready();\n\t\t}\n\t}\n\n\tjQuery.ready.promise = function( obj ) {\n\t\tif ( !readyList ) {\n\n\t\t\treadyList = jQuery.Deferred();\n\n\t\t\t// Catch cases where $(document).ready() is called\n\t\t\t// after the browser event has already occurred.\n\t\t\t// Support: IE6-10\n\t\t\t// Older IE sometimes signals \"interactive\" too soon\n\t\t\tif ( document.readyState === \"complete\" ||\n\t\t\t\t( document.readyState !== \"loading\" && !document.documentElement.doScroll ) ) {\n\n\t\t\t\t// Handle it asynchronously to allow scripts the opportunity to delay ready\n\t\t\t\twindow.setTimeout( jQuery.ready );\n\n\t\t\t\t// Standards-based browsers support DOMContentLoaded\n\t\t\t} else if ( document.addEventListener ) {\n\n\t\t\t\t// Use the handy event callback\n\t\t\t\tdocument.addEventListener( \"DOMContentLoaded\", completed );\n\n\t\t\t\t// A fallback to window.onload, that will always work\n\t\t\t\twindow.addEventListener( \"load\", completed );\n\n\t\t\t\t// If IE event model is used\n\t\t\t} else {\n\n\t\t\t\t// Ensure firing before onload, maybe late but safe also for iframes\n\t\t\t\tdocument.attachEvent( \"onreadystatechange\", completed );\n\n\t\t\t\t// A fallback to window.onload, that will always work\n\t\t\t\twindow.attachEvent( \"onload\", completed );\n\n\t\t\t\t// If IE and not a frame\n\t\t\t\t// continually check to see if the document is ready\n\t\t\t\tvar top = false;\n\n\t\t\t\ttry {\n\t\t\t\t\ttop = window.frameElement == null && document.documentElement;\n\t\t\t\t} catch ( e ) {}\n\n\t\t\t\tif ( top && top.doScroll ) {\n\t\t\t\t\t( function doScrollCheck() {\n\t\t\t\t\t\tif ( !jQuery.isReady ) {\n\n\t\t\t\t\t\t\ttry {\n\n\t\t\t\t\t\t\t\t// Use the trick by Diego Perini\n\t\t\t\t\t\t\t\t// http://javascript.nwbox.com/IEContentLoaded/\n\t\t\t\t\t\t\t\ttop.doScroll( \"left\" );\n\t\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\t\treturn window.setTimeout( doScrollCheck, 50 );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// detach all dom ready events\n\t\t\t\t\t\t\tdetach();\n\n\t\t\t\t\t\t\t// and execute any waiting functions\n\t\t\t\t\t\t\tjQuery.ready();\n\t\t\t\t\t\t}\n\t\t\t\t\t} )();\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn readyList.promise( obj );\n\t};\n\n// Kick off the DOM ready check even if the user does not\n\tjQuery.ready.promise();\n\n\n\n\n// Support: IE<9\n// Iteration over object's inherited properties before its own\n\tvar i;\n\tfor ( i in jQuery( support ) ) {\n\t\tbreak;\n\t}\n\tsupport.ownFirst = i === \"0\";\n\n// Note: most support tests are defined in their respective modules.\n// false until the test is run\n\tsupport.inlineBlockNeedsLayout = false;\n\n// Execute ASAP in case we need to set body.style.zoom\n\tjQuery( function() {\n\n\t\t// Minified: var a,b,c,d\n\t\tvar val, div, body, container;\n\n\t\tbody = document.getElementsByTagName( \"body\" )[ 0 ];\n\t\tif ( !body || !body.style ) {\n\n\t\t\t// Return for frameset docs that don't have a body\n\t\t\treturn;\n\t\t}\n\n\t\t// Setup\n\t\tdiv = document.createElement( \"div\" );\n\t\tcontainer = document.createElement( \"div\" );\n\t\tcontainer.style.cssText = \"position:absolute;border:0;width:0;height:0;top:0;left:-9999px\";\n\t\tbody.appendChild( container ).appendChild( div );\n\n\t\tif ( typeof div.style.zoom !== \"undefined\" ) {\n\n\t\t\t// Support: IE<8\n\t\t\t// Check if natively block-level elements act like inline-block\n\t\t\t// elements when setting their display to 'inline' and giving\n\t\t\t// them layout\n\t\t\tdiv.style.cssText = \"display:inline;margin:0;border:0;padding:1px;width:1px;zoom:1\";\n\n\t\t\tsupport.inlineBlockNeedsLayout = val = div.offsetWidth === 3;\n\t\t\tif ( val ) {\n\n\t\t\t\t// Prevent IE 6 from affecting layout for positioned elements #11048\n\t\t\t\t// Prevent IE from shrinking the body in IE 7 mode #12869\n\t\t\t\t// Support: IE<8\n\t\t\t\tbody.style.zoom = 1;\n\t\t\t}\n\t\t}\n\n\t\tbody.removeChild( container );\n\t} );\n\n\n\t( function() {\n\t\tvar div = document.createElement( \"div\" );\n\n\t\t// Support: IE<9\n\t\tsupport.deleteExpando = true;\n\t\ttry {\n\t\t\tdelete div.test;\n\t\t} catch ( e ) {\n\t\t\tsupport.deleteExpando = false;\n\t\t}\n\n\t\t// Null elements to avoid leaks in IE.\n\t\tdiv = null;\n\t} )();\n\tvar acceptData = function( elem ) {\n\t\tvar noData = jQuery.noData[ ( elem.nodeName + \" \" ).toLowerCase() ],\n\t\t\tnodeType = +elem.nodeType || 1;\n\n\t\t// Do not set data on non-element DOM nodes because it will not be cleared (#8335).\n\t\treturn nodeType !== 1 && nodeType !== 9 ?\n\t\t\tfalse :\n\n\t\t\t// Nodes accept data unless otherwise specified; rejection can be conditional\n\t\t!noData || noData !== true && elem.getAttribute( \"classid\" ) === noData;\n\t};\n\n\n\n\n\tvar rbrace = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/,\n\t\trmultiDash = /([A-Z])/g;\n\n\tfunction dataAttr( elem, key, data ) {\n\n\t\t// If nothing was found internally, try to fetch any\n\t\t// data from the HTML5 data-* attribute\n\t\tif ( data === undefined && elem.nodeType === 1 ) {\n\n\t\t\tvar name = \"data-\" + key.replace( rmultiDash, \"-$1\" ).toLowerCase();\n\n\t\t\tdata = elem.getAttribute( name );\n\n\t\t\tif ( typeof data === \"string\" ) {\n\t\t\t\ttry {\n\t\t\t\t\tdata = data === \"true\" ? true :\n\t\t\t\t\t\tdata === \"false\" ? false :\n\t\t\t\t\t\t\tdata === \"null\" ? null :\n\n\t\t\t\t\t\t\t\t// Only convert to a number if it doesn't change the string\n\t\t\t\t\t\t\t\t+data + \"\" === data ? +data :\n\t\t\t\t\t\t\t\t\trbrace.test( data ) ? jQuery.parseJSON( data ) :\n\t\t\t\t\t\t\t\t\t\tdata;\n\t\t\t\t} catch ( e ) {}\n\n\t\t\t\t// Make sure we set the data so it isn't changed later\n\t\t\t\tjQuery.data( elem, key, data );\n\n\t\t\t} else {\n\t\t\t\tdata = undefined;\n\t\t\t}\n\t\t}\n\n\t\treturn data;\n\t}\n\n// checks a cache object for emptiness\n\tfunction isEmptyDataObject( obj ) {\n\t\tvar name;\n\t\tfor ( name in obj ) {\n\n\t\t\t// if the public data object is empty, the private is still empty\n\t\t\tif ( name === \"data\" && jQuery.isEmptyObject( obj[ name ] ) ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\t\t\tif ( name !== \"toJSON\" ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\n\t\treturn true;\n\t}\n\n\tfunction internalData( elem, name, data, pvt /* Internal Use Only */ ) {\n\t\tif ( !acceptData( elem ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar ret, thisCache,\n\t\t\tinternalKey = jQuery.expando,\n\n\t\t\t// We have to handle DOM nodes and JS objects differently because IE6-7\n\t\t\t// can't GC object references properly across the DOM-JS boundary\n\t\t\tisNode = elem.nodeType,\n\n\t\t\t// Only DOM nodes need the global jQuery cache; JS object data is\n\t\t\t// attached directly to the object so GC can occur automatically\n\t\t\tcache = isNode ? jQuery.cache : elem,\n\n\t\t\t// Only defining an ID for JS objects if its cache already exists allows\n\t\t\t// the code to shortcut on the same path as a DOM node with no cache\n\t\t\tid = isNode ? elem[ internalKey ] : elem[ internalKey ] && internalKey;\n\n\t\t// Avoid doing any more work than we need to when trying to get data on an\n\t\t// object that has no data at all\n\t\tif ( ( !id || !cache[ id ] || ( !pvt && !cache[ id ].data ) ) &&\n\t\t\tdata === undefined && typeof name === \"string\" ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( !id ) {\n\n\t\t\t// Only DOM nodes need a new unique ID for each element since their data\n\t\t\t// ends up in the global cache\n\t\t\tif ( isNode ) {\n\t\t\t\tid = elem[ internalKey ] = deletedIds.pop() || jQuery.guid++;\n\t\t\t} else {\n\t\t\t\tid = internalKey;\n\t\t\t}\n\t\t}\n\n\t\tif ( !cache[ id ] ) {\n\n\t\t\t// Avoid exposing jQuery metadata on plain JS objects when the object\n\t\t\t// is serialized using JSON.stringify\n\t\t\tcache[ id ] = isNode ? {} : { toJSON: jQuery.noop };\n\t\t}\n\n\t\t// An object can be passed to jQuery.data instead of a key/value pair; this gets\n\t\t// shallow copied over onto the existing cache\n\t\tif ( typeof name === \"object\" || typeof name === \"function\" ) {\n\t\t\tif ( pvt ) {\n\t\t\t\tcache[ id ] = jQuery.extend( cache[ id ], name );\n\t\t\t} else {\n\t\t\t\tcache[ id ].data = jQuery.extend( cache[ id ].data, name );\n\t\t\t}\n\t\t}\n\n\t\tthisCache = cache[ id ];\n\n\t\t// jQuery data() is stored in a separate object inside the object's internal data\n\t\t// cache in order to avoid key collisions between internal data and user-defined\n\t\t// data.\n\t\tif ( !pvt ) {\n\t\t\tif ( !thisCache.data ) {\n\t\t\t\tthisCache.data = {};\n\t\t\t}\n\n\t\t\tthisCache = thisCache.data;\n\t\t}\n\n\t\tif ( data !== undefined ) {\n\t\t\tthisCache[ jQuery.camelCase( name ) ] = data;\n\t\t}\n\n\t\t// Check for both converted-to-camel and non-converted data property names\n\t\t// If a data property was specified\n\t\tif ( typeof name === \"string\" ) {\n\n\t\t\t// First Try to find as-is property data\n\t\t\tret = thisCache[ name ];\n\n\t\t\t// Test for null|undefined property data\n\t\t\tif ( ret == null ) {\n\n\t\t\t\t// Try to find the camelCased property\n\t\t\t\tret = thisCache[ jQuery.camelCase( name ) ];\n\t\t\t}\n\t\t} else {\n\t\t\tret = thisCache;\n\t\t}\n\n\t\treturn ret;\n\t}\n\n\tfunction internalRemoveData( elem, name, pvt ) {\n\t\tif ( !acceptData( elem ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar thisCache, i,\n\t\t\tisNode = elem.nodeType,\n\n\t\t\t// See jQuery.data for more information\n\t\t\tcache = isNode ? jQuery.cache : elem,\n\t\t\tid = isNode ? elem[ jQuery.expando ] : jQuery.expando;\n\n\t\t// If there is already no cache entry for this object, there is no\n\t\t// purpose in continuing\n\t\tif ( !cache[ id ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( name ) {\n\n\t\t\tthisCache = pvt ? cache[ id ] : cache[ id ].data;\n\n\t\t\tif ( thisCache ) {\n\n\t\t\t\t// Support array or space separated string names for data keys\n\t\t\t\tif ( !jQuery.isArray( name ) ) {\n\n\t\t\t\t\t// try the string as a key before any manipulation\n\t\t\t\t\tif ( name in thisCache ) {\n\t\t\t\t\t\tname = [ name ];\n\t\t\t\t\t} else {\n\n\t\t\t\t\t\t// split the camel cased version by spaces unless a key with the spaces exists\n\t\t\t\t\t\tname = jQuery.camelCase( name );\n\t\t\t\t\t\tif ( name in thisCache ) {\n\t\t\t\t\t\t\tname = [ name ];\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tname = name.split( \" \" );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} else {\n\n\t\t\t\t\t// If \"name\" is an array of keys...\n\t\t\t\t\t// When data is initially created, via (\"key\", \"val\") signature,\n\t\t\t\t\t// keys will be converted to camelCase.\n\t\t\t\t\t// Since there is no way to tell _how_ a key was added, remove\n\t\t\t\t\t// both plain key and camelCase key. #12786\n\t\t\t\t\t// This will only penalize the array argument path.\n\t\t\t\t\tname = name.concat( jQuery.map( name, jQuery.camelCase ) );\n\t\t\t\t}\n\n\t\t\t\ti = name.length;\n\t\t\t\twhile ( i-- ) {\n\t\t\t\t\tdelete thisCache[ name[ i ] ];\n\t\t\t\t}\n\n\t\t\t\t// If there is no data left in the cache, we want to continue\n\t\t\t\t// and let the cache object itself get destroyed\n\t\t\t\tif ( pvt ? !isEmptyDataObject( thisCache ) : !jQuery.isEmptyObject( thisCache ) ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// See jQuery.data for more information\n\t\tif ( !pvt ) {\n\t\t\tdelete cache[ id ].data;\n\n\t\t\t// Don't destroy the parent cache unless the internal data object\n\t\t\t// had been the only thing left in it\n\t\t\tif ( !isEmptyDataObject( cache[ id ] ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t}\n\n\t\t// Destroy the cache\n\t\tif ( isNode ) {\n\t\t\tjQuery.cleanData( [ elem ], true );\n\n\t\t\t// Use delete when supported for expandos or `cache` is not a window per isWindow (#10080)\n\t\t\t/* jshint eqeqeq: false */\n\t\t} else if ( support.deleteExpando || cache != cache.window ) {\n\t\t\t/* jshint eqeqeq: true */\n\t\t\tdelete cache[ id ];\n\n\t\t\t// When all else fails, undefined\n\t\t} else {\n\t\t\tcache[ id ] = undefined;\n\t\t}\n\t}\n\n\tjQuery.extend( {\n\t\tcache: {},\n\n\t\t// The following elements (space-suffixed to avoid Object.prototype collisions)\n\t\t// throw uncatchable exceptions if you attempt to set expando properties\n\t\tnoData: {\n\t\t\t\"applet \": true,\n\t\t\t\"embed \": true,\n\n\t\t\t// ...but Flash objects (which have this classid) *can* handle expandos\n\t\t\t\"object \": \"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\"\n\t\t},\n\n\t\thasData: function( elem ) {\n\t\t\telem = elem.nodeType ? jQuery.cache[ elem[ jQuery.expando ] ] : elem[ jQuery.expando ];\n\t\t\treturn !!elem && !isEmptyDataObject( elem );\n\t\t},\n\n\t\tdata: function( elem, name, data ) {\n\t\t\treturn internalData( elem, name, data );\n\t\t},\n\n\t\tremoveData: function( elem, name ) {\n\t\t\treturn internalRemoveData( elem, name );\n\t\t},\n\n\t\t// For internal use only.\n\t\t_data: function( elem, name, data ) {\n\t\t\treturn internalData( elem, name, data, true );\n\t\t},\n\n\t\t_removeData: function( elem, name ) {\n\t\t\treturn internalRemoveData( elem, name, true );\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\t\tdata: function( key, value ) {\n\t\t\tvar i, name, data,\n\t\t\t\telem = this[ 0 ],\n\t\t\t\tattrs = elem && elem.attributes;\n\n\t\t\t// Special expections of .data basically thwart jQuery.access,\n\t\t\t// so implement the relevant behavior ourselves\n\n\t\t\t// Gets all values\n\t\t\tif ( key === undefined ) {\n\t\t\t\tif ( this.length ) {\n\t\t\t\t\tdata = jQuery.data( elem );\n\n\t\t\t\t\tif ( elem.nodeType === 1 && !jQuery._data( elem, \"parsedAttrs\" ) ) {\n\t\t\t\t\t\ti = attrs.length;\n\t\t\t\t\t\twhile ( i-- ) {\n\n\t\t\t\t\t\t\t// Support: IE11+\n\t\t\t\t\t\t\t// The attrs elements can be null (#14894)\n\t\t\t\t\t\t\tif ( attrs[ i ] ) {\n\t\t\t\t\t\t\t\tname = attrs[ i ].name;\n\t\t\t\t\t\t\t\tif ( name.indexOf( \"data-\" ) === 0 ) {\n\t\t\t\t\t\t\t\t\tname = jQuery.camelCase( name.slice( 5 ) );\n\t\t\t\t\t\t\t\t\tdataAttr( elem, name, data[ name ] );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tjQuery._data( elem, \"parsedAttrs\", true );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn data;\n\t\t\t}\n\n\t\t\t// Sets multiple values\n\t\t\tif ( typeof key === \"object\" ) {\n\t\t\t\treturn this.each( function() {\n\t\t\t\t\tjQuery.data( this, key );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn arguments.length > 1 ?\n\n\t\t\t\t// Sets one value\n\t\t\t\tthis.each( function() {\n\t\t\t\t\tjQuery.data( this, key, value );\n\t\t\t\t} ) :\n\n\t\t\t\t// Gets one value\n\t\t\t\t// Try to fetch any internally stored data first\n\t\t\t\telem ? dataAttr( elem, key, jQuery.data( elem, key ) ) : undefined;\n\t\t},\n\n\t\tremoveData: function( key ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.removeData( this, key );\n\t\t\t} );\n\t\t}\n\t} );\n\n\n\tjQuery.extend( {\n\t\tqueue: function( elem, type, data ) {\n\t\t\tvar queue;\n\n\t\t\tif ( elem ) {\n\t\t\t\ttype = ( type || \"fx\" ) + \"queue\";\n\t\t\t\tqueue = jQuery._data( elem, type );\n\n\t\t\t\t// Speed up dequeue by getting out quickly if this is just a lookup\n\t\t\t\tif ( data ) {\n\t\t\t\t\tif ( !queue || jQuery.isArray( data ) ) {\n\t\t\t\t\t\tqueue = jQuery._data( elem, type, jQuery.makeArray( data ) );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tqueue.push( data );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn queue || [];\n\t\t\t}\n\t\t},\n\n\t\tdequeue: function( elem, type ) {\n\t\t\ttype = type || \"fx\";\n\n\t\t\tvar queue = jQuery.queue( elem, type ),\n\t\t\t\tstartLength = queue.length,\n\t\t\t\tfn = queue.shift(),\n\t\t\t\thooks = jQuery._queueHooks( elem, type ),\n\t\t\t\tnext = function() {\n\t\t\t\t\tjQuery.dequeue( elem, type );\n\t\t\t\t};\n\n\t\t\t// If the fx queue is dequeued, always remove the progress sentinel\n\t\t\tif ( fn === \"inprogress\" ) {\n\t\t\t\tfn = queue.shift();\n\t\t\t\tstartLength--;\n\t\t\t}\n\n\t\t\tif ( fn ) {\n\n\t\t\t\t// Add a progress sentinel to prevent the fx queue from being\n\t\t\t\t// automatically dequeued\n\t\t\t\tif ( type === \"fx\" ) {\n\t\t\t\t\tqueue.unshift( \"inprogress\" );\n\t\t\t\t}\n\n\t\t\t\t// clear up the last queue stop function\n\t\t\t\tdelete hooks.stop;\n\t\t\t\tfn.call( elem, next, hooks );\n\t\t\t}\n\n\t\t\tif ( !startLength && hooks ) {\n\t\t\t\thooks.empty.fire();\n\t\t\t}\n\t\t},\n\n\t\t// not intended for public consumption - generates a queueHooks object,\n\t\t// or returns the current one\n\t\t_queueHooks: function( elem, type ) {\n\t\t\tvar key = type + \"queueHooks\";\n\t\t\treturn jQuery._data( elem, key ) || jQuery._data( elem, key, {\n\t\t\t\t\tempty: jQuery.Callbacks( \"once memory\" ).add( function() {\n\t\t\t\t\t\tjQuery._removeData( elem, type + \"queue\" );\n\t\t\t\t\t\tjQuery._removeData( elem, key );\n\t\t\t\t\t} )\n\t\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\t\tqueue: function( type, data ) {\n\t\t\tvar setter = 2;\n\n\t\t\tif ( typeof type !== \"string\" ) {\n\t\t\t\tdata = type;\n\t\t\t\ttype = \"fx\";\n\t\t\t\tsetter--;\n\t\t\t}\n\n\t\t\tif ( arguments.length < setter ) {\n\t\t\t\treturn jQuery.queue( this[ 0 ], type );\n\t\t\t}\n\n\t\t\treturn data === undefined ?\n\t\t\t\tthis :\n\t\t\t\tthis.each( function() {\n\t\t\t\t\tvar queue = jQuery.queue( this, type, data );\n\n\t\t\t\t\t// ensure a hooks for this queue\n\t\t\t\t\tjQuery._queueHooks( this, type );\n\n\t\t\t\t\tif ( type === \"fx\" && queue[ 0 ] !== \"inprogress\" ) {\n\t\t\t\t\t\tjQuery.dequeue( this, type );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t},\n\t\tdequeue: function( type ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.dequeue( this, type );\n\t\t\t} );\n\t\t},\n\t\tclearQueue: function( type ) {\n\t\t\treturn this.queue( type || \"fx\", [] );\n\t\t},\n\n\t\t// Get a promise resolved when queues of a certain type\n\t\t// are emptied (fx is the type by default)\n\t\tpromise: function( type, obj ) {\n\t\t\tvar tmp,\n\t\t\t\tcount = 1,\n\t\t\t\tdefer = jQuery.Deferred(),\n\t\t\t\telements = this,\n\t\t\t\ti = this.length,\n\t\t\t\tresolve = function() {\n\t\t\t\t\tif ( !( --count ) ) {\n\t\t\t\t\t\tdefer.resolveWith( elements, [ elements ] );\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\tif ( typeof type !== \"string\" ) {\n\t\t\t\tobj = type;\n\t\t\t\ttype = undefined;\n\t\t\t}\n\t\t\ttype = type || \"fx\";\n\n\t\t\twhile ( i-- ) {\n\t\t\t\ttmp = jQuery._data( elements[ i ], type + \"queueHooks\" );\n\t\t\t\tif ( tmp && tmp.empty ) {\n\t\t\t\t\tcount++;\n\t\t\t\t\ttmp.empty.add( resolve );\n\t\t\t\t}\n\t\t\t}\n\t\t\tresolve();\n\t\t\treturn defer.promise( obj );\n\t\t}\n\t} );\n\n\n\t( function() {\n\t\tvar shrinkWrapBlocksVal;\n\n\t\tsupport.shrinkWrapBlocks = function() {\n\t\t\tif ( shrinkWrapBlocksVal != null ) {\n\t\t\t\treturn shrinkWrapBlocksVal;\n\t\t\t}\n\n\t\t\t// Will be changed later if needed.\n\t\t\tshrinkWrapBlocksVal = false;\n\n\t\t\t// Minified: var b,c,d\n\t\t\tvar div, body, container;\n\n\t\t\tbody = document.getElementsByTagName( \"body\" )[ 0 ];\n\t\t\tif ( !body || !body.style ) {\n\n\t\t\t\t// Test fired too early or in an unsupported environment, exit.\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Setup\n\t\t\tdiv = document.createElement( \"div\" );\n\t\t\tcontainer = document.createElement( \"div\" );\n\t\t\tcontainer.style.cssText = \"position:absolute;border:0;width:0;height:0;top:0;left:-9999px\";\n\t\t\tbody.appendChild( container ).appendChild( div );\n\n\t\t\t// Support: IE6\n\t\t\t// Check if elements with layout shrink-wrap their children\n\t\t\tif ( typeof div.style.zoom !== \"undefined\" ) {\n\n\t\t\t\t// Reset CSS: box-sizing; display; margin; border\n\t\t\t\tdiv.style.cssText =\n\n\t\t\t\t\t// Support: Firefox<29, Android 2.3\n\t\t\t\t\t// Vendor-prefix box-sizing\n\t\t\t\t\t\"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;\" +\n\t\t\t\t\t\"box-sizing:content-box;display:block;margin:0;border:0;\" +\n\t\t\t\t\t\"padding:1px;width:1px;zoom:1\";\n\t\t\t\tdiv.appendChild( document.createElement( \"div\" ) ).style.width = \"5px\";\n\t\t\t\tshrinkWrapBlocksVal = div.offsetWidth !== 3;\n\t\t\t}\n\n\t\t\tbody.removeChild( container );\n\n\t\t\treturn shrinkWrapBlocksVal;\n\t\t};\n\n\t} )();\n\tvar pnum = ( /[+-]?(?:\\d*\\.|)\\d+(?:[eE][+-]?\\d+|)/ ).source;\n\n\tvar rcssNum = new RegExp( \"^(?:([+-])=|)(\" + pnum + \")([a-z%]*)$\", \"i\" );\n\n\n\tvar cssExpand = [ \"Top\", \"Right\", \"Bottom\", \"Left\" ];\n\n\tvar isHidden = function( elem, el ) {\n\n\t\t// isHidden might be called from jQuery#filter function;\n\t\t// in that case, element will be second argument\n\t\telem = el || elem;\n\t\treturn jQuery.css( elem, \"display\" ) === \"none\" ||\n\t\t\t!jQuery.contains( elem.ownerDocument, elem );\n\t};\n\n\n\n\tfunction adjustCSS( elem, prop, valueParts, tween ) {\n\t\tvar adjusted,\n\t\t\tscale = 1,\n\t\t\tmaxIterations = 20,\n\t\t\tcurrentValue = tween ?\n\t\t\t\tfunction() { return tween.cur(); } :\n\t\t\t\tfunction() { return jQuery.css( elem, prop, \"\" ); },\n\t\t\tinitial = currentValue(),\n\t\t\tunit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" ),\n\n\t\t\t// Starting value computation is required for potential unit mismatches\n\t\t\tinitialInUnit = ( jQuery.cssNumber[ prop ] || unit !== \"px\" && +initial ) &&\n\t\t\t\trcssNum.exec( jQuery.css( elem, prop ) );\n\n\t\tif ( initialInUnit && initialInUnit[ 3 ] !== unit ) {\n\n\t\t\t// Trust units reported by jQuery.css\n\t\t\tunit = unit || initialInUnit[ 3 ];\n\n\t\t\t// Make sure we update the tween properties later on\n\t\t\tvalueParts = valueParts || [];\n\n\t\t\t// Iteratively approximate from a nonzero starting point\n\t\t\tinitialInUnit = +initial || 1;\n\n\t\t\tdo {\n\n\t\t\t\t// If previous iteration zeroed out, double until we get *something*.\n\t\t\t\t// Use string for doubling so we don't accidentally see scale as unchanged below\n\t\t\t\tscale = scale || \".5\";\n\n\t\t\t\t// Adjust and apply\n\t\t\t\tinitialInUnit = initialInUnit / scale;\n\t\t\t\tjQuery.style( elem, prop, initialInUnit + unit );\n\n\t\t\t\t// Update scale, tolerating zero or NaN from tween.cur()\n\t\t\t\t// Break the loop if scale is unchanged or perfect, or if we've just had enough.\n\t\t\t} while (\n\t\t\tscale !== ( scale = currentValue() / initial ) && scale !== 1 && --maxIterations\n\t\t\t\t);\n\t\t}\n\n\t\tif ( valueParts ) {\n\t\t\tinitialInUnit = +initialInUnit || +initial || 0;\n\n\t\t\t// Apply relative offset (+=/-=) if specified\n\t\t\tadjusted = valueParts[ 1 ] ?\n\t\t\tinitialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :\n\t\t\t\t+valueParts[ 2 ];\n\t\t\tif ( tween ) {\n\t\t\t\ttween.unit = unit;\n\t\t\t\ttween.start = initialInUnit;\n\t\t\t\ttween.end = adjusted;\n\t\t\t}\n\t\t}\n\t\treturn adjusted;\n\t}\n\n\n// Multifunctional method to get and set values of a collection\n// The value/s can optionally be executed if it's a function\n\tvar access = function( elems, fn, key, value, chainable, emptyGet, raw ) {\n\t\tvar i = 0,\n\t\t\tlength = elems.length,\n\t\t\tbulk = key == null;\n\n\t\t// Sets many values\n\t\tif ( jQuery.type( key ) === \"object\" ) {\n\t\t\tchainable = true;\n\t\t\tfor ( i in key ) {\n\t\t\t\taccess( elems, fn, i, key[ i ], true, emptyGet, raw );\n\t\t\t}\n\n\t\t\t// Sets one value\n\t\t} else if ( value !== undefined ) {\n\t\t\tchainable = true;\n\n\t\t\tif ( !jQuery.isFunction( value ) ) {\n\t\t\t\traw = true;\n\t\t\t}\n\n\t\t\tif ( bulk ) {\n\n\t\t\t\t// Bulk operations run against the entire set\n\t\t\t\tif ( raw ) {\n\t\t\t\t\tfn.call( elems, value );\n\t\t\t\t\tfn = null;\n\n\t\t\t\t\t// ...except when executing function values\n\t\t\t\t} else {\n\t\t\t\t\tbulk = fn;\n\t\t\t\t\tfn = function( elem, key, value ) {\n\t\t\t\t\t\treturn bulk.call( jQuery( elem ), value );\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( fn ) {\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tfn(\n\t\t\t\t\t\telems[ i ],\n\t\t\t\t\t\tkey,\n\t\t\t\t\t\traw ? value : value.call( elems[ i ], i, fn( elems[ i ], key ) )\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn chainable ?\n\t\t\telems :\n\n\t\t\t// Gets\n\t\t\tbulk ?\n\t\t\t\tfn.call( elems ) :\n\t\t\t\tlength ? fn( elems[ 0 ], key ) : emptyGet;\n\t};\n\tvar rcheckableType = ( /^(?:checkbox|radio)$/i );\n\n\tvar rtagName = ( /<([\\w:-]+)/ );\n\n\tvar rscriptType = ( /^$|\\/(?:java|ecma)script/i );\n\n\tvar rleadingWhitespace = ( /^\\s+/ );\n\n\tvar nodeNames = \"abbr|article|aside|audio|bdi|canvas|data|datalist|\" +\n\t\t\"details|dialog|figcaption|figure|footer|header|hgroup|main|\" +\n\t\t\"mark|meter|nav|output|picture|progress|section|summary|template|time|video\";\n\n\n\n\tfunction createSafeFragment( document ) {\n\t\tvar list = nodeNames.split( \"|\" ),\n\t\t\tsafeFrag = document.createDocumentFragment();\n\n\t\tif ( safeFrag.createElement ) {\n\t\t\twhile ( list.length ) {\n\t\t\t\tsafeFrag.createElement(\n\t\t\t\t\tlist.pop()\n\t\t\t\t);\n\t\t\t}\n\t\t}\n\t\treturn safeFrag;\n\t}\n\n\n\t( function() {\n\t\tvar div = document.createElement( \"div\" ),\n\t\t\tfragment = document.createDocumentFragment(),\n\t\t\tinput = document.createElement( \"input\" );\n\n\t\t// Setup\n\t\tdiv.innerHTML = \"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\";\n\n\t\t// IE strips leading whitespace when .innerHTML is used\n\t\tsupport.leadingWhitespace = div.firstChild.nodeType === 3;\n\n\t\t// Make sure that tbody elements aren't automatically inserted\n\t\t// IE will insert them into empty tables\n\t\tsupport.tbody = !div.getElementsByTagName( \"tbody\" ).length;\n\n\t\t// Make sure that link elements get serialized correctly by innerHTML\n\t\t// This requires a wrapper element in IE\n\t\tsupport.htmlSerialize = !!div.getElementsByTagName( \"link\" ).length;\n\n\t\t// Makes sure cloning an html5 element does not cause problems\n\t\t// Where outerHTML is undefined, this still works\n\t\tsupport.html5Clone =\n\t\t\tdocument.createElement( \"nav\" ).cloneNode( true ).outerHTML !== \"<:nav></:nav>\";\n\n\t\t// Check if a disconnected checkbox will retain its checked\n\t\t// value of true after appended to the DOM (IE6/7)\n\t\tinput.type = \"checkbox\";\n\t\tinput.checked = true;\n\t\tfragment.appendChild( input );\n\t\tsupport.appendChecked = input.checked;\n\n\t\t// Make sure textarea (and checkbox) defaultValue is properly cloned\n\t\t// Support: IE6-IE11+\n\t\tdiv.innerHTML = \"<textarea>x</textarea>\";\n\t\tsupport.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;\n\n\t\t// #11217 - WebKit loses check when the name is after the checked attribute\n\t\tfragment.appendChild( div );\n\n\t\t// Support: Windows Web Apps (WWA)\n\t\t// `name` and `type` must use .setAttribute for WWA (#14901)\n\t\tinput = document.createElement( \"input\" );\n\t\tinput.setAttribute( \"type\", \"radio\" );\n\t\tinput.setAttribute( \"checked\", \"checked\" );\n\t\tinput.setAttribute( \"name\", \"t\" );\n\n\t\tdiv.appendChild( input );\n\n\t\t// Support: Safari 5.1, iOS 5.1, Android 4.x, Android 2.3\n\t\t// old WebKit doesn't clone checked state correctly in fragments\n\t\tsupport.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;\n\n\t\t// Support: IE<9\n\t\t// Cloned elements keep attachEvent handlers, we use addEventListener on IE9+\n\t\tsupport.noCloneEvent = !!div.addEventListener;\n\n\t\t// Support: IE<9\n\t\t// Since attributes and properties are the same in IE,\n\t\t// cleanData must set properties to undefined rather than use removeAttribute\n\t\tdiv[ jQuery.expando ] = 1;\n\t\tsupport.attributes = !div.getAttribute( jQuery.expando );\n\t} )();\n\n\n// We have to close these tags to support XHTML (#13200)\n\tvar wrapMap = {\n\t\toption: [ 1, \"<select multiple='multiple'>\", \"</select>\" ],\n\t\tlegend: [ 1, \"<fieldset>\", \"</fieldset>\" ],\n\t\tarea: [ 1, \"<map>\", \"</map>\" ],\n\n\t\t// Support: IE8\n\t\tparam: [ 1, \"<object>\", \"</object>\" ],\n\t\tthead: [ 1, \"<table>\", \"</table>\" ],\n\t\ttr: [ 2, \"<table><tbody>\", \"</tbody></table>\" ],\n\t\tcol: [ 2, \"<table><tbody></tbody><colgroup>\", \"</colgroup></table>\" ],\n\t\ttd: [ 3, \"<table><tbody><tr>\", \"</tr></tbody></table>\" ],\n\n\t\t// IE6-8 can't serialize link, script, style, or any html5 (NoScope) tags,\n\t\t// unless wrapped in a div with non-breaking characters in front of it.\n\t\t_default: support.htmlSerialize ? [ 0, \"\", \"\" ] : [ 1, \"X<div>\", \"</div>\" ]\n\t};\n\n// Support: IE8-IE9\n\twrapMap.optgroup = wrapMap.option;\n\n\twrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;\n\twrapMap.th = wrapMap.td;\n\n\n\tfunction getAll( context, tag ) {\n\t\tvar elems, elem,\n\t\t\ti = 0,\n\t\t\tfound = typeof context.getElementsByTagName !== \"undefined\" ?\n\t\t\t\tcontext.getElementsByTagName( tag || \"*\" ) :\n\t\t\t\ttypeof context.querySelectorAll !== \"undefined\" ?\n\t\t\t\t\tcontext.querySelectorAll( tag || \"*\" ) :\n\t\t\t\t\tundefined;\n\n\t\tif ( !found ) {\n\t\t\tfor ( found = [], elems = context.childNodes || context;\n\t\t\t\t  ( elem = elems[ i ] ) != null;\n\t\t\t\t  i++\n\t\t\t) {\n\t\t\t\tif ( !tag || jQuery.nodeName( elem, tag ) ) {\n\t\t\t\t\tfound.push( elem );\n\t\t\t\t} else {\n\t\t\t\t\tjQuery.merge( found, getAll( elem, tag ) );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn tag === undefined || tag && jQuery.nodeName( context, tag ) ?\n\t\t\tjQuery.merge( [ context ], found ) :\n\t\t\tfound;\n\t}\n\n\n// Mark scripts as having already been evaluated\n\tfunction setGlobalEval( elems, refElements ) {\n\t\tvar elem,\n\t\t\ti = 0;\n\t\tfor ( ; ( elem = elems[ i ] ) != null; i++ ) {\n\t\t\tjQuery._data(\n\t\t\t\telem,\n\t\t\t\t\"globalEval\",\n\t\t\t\t!refElements || jQuery._data( refElements[ i ], \"globalEval\" )\n\t\t\t);\n\t\t}\n\t}\n\n\n\tvar rhtml = /<|&#?\\w+;/,\n\t\trtbody = /<tbody/i;\n\n\tfunction fixDefaultChecked( elem ) {\n\t\tif ( rcheckableType.test( elem.type ) ) {\n\t\t\telem.defaultChecked = elem.checked;\n\t\t}\n\t}\n\n\tfunction buildFragment( elems, context, scripts, selection, ignored ) {\n\t\tvar j, elem, contains,\n\t\t\ttmp, tag, tbody, wrap,\n\t\t\tl = elems.length,\n\n\t\t\t// Ensure a safe fragment\n\t\t\tsafe = createSafeFragment( context ),\n\n\t\t\tnodes = [],\n\t\t\ti = 0;\n\n\t\tfor ( ; i < l; i++ ) {\n\t\t\telem = elems[ i ];\n\n\t\t\tif ( elem || elem === 0 ) {\n\n\t\t\t\t// Add nodes directly\n\t\t\t\tif ( jQuery.type( elem ) === \"object\" ) {\n\t\t\t\t\tjQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );\n\n\t\t\t\t\t// Convert non-html into a text node\n\t\t\t\t} else if ( !rhtml.test( elem ) ) {\n\t\t\t\t\tnodes.push( context.createTextNode( elem ) );\n\n\t\t\t\t\t// Convert html into DOM nodes\n\t\t\t\t} else {\n\t\t\t\t\ttmp = tmp || safe.appendChild( context.createElement( \"div\" ) );\n\n\t\t\t\t\t// Deserialize a standard representation\n\t\t\t\t\ttag = ( rtagName.exec( elem ) || [ \"\", \"\" ] )[ 1 ].toLowerCase();\n\t\t\t\t\twrap = wrapMap[ tag ] || wrapMap._default;\n\n\t\t\t\t\ttmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];\n\n\t\t\t\t\t// Descend through wrappers to the right content\n\t\t\t\t\tj = wrap[ 0 ];\n\t\t\t\t\twhile ( j-- ) {\n\t\t\t\t\t\ttmp = tmp.lastChild;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Manually add leading whitespace removed by IE\n\t\t\t\t\tif ( !support.leadingWhitespace && rleadingWhitespace.test( elem ) ) {\n\t\t\t\t\t\tnodes.push( context.createTextNode( rleadingWhitespace.exec( elem )[ 0 ] ) );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove IE's autoinserted <tbody> from table fragments\n\t\t\t\t\tif ( !support.tbody ) {\n\n\t\t\t\t\t\t// String was a <table>, *may* have spurious <tbody>\n\t\t\t\t\t\telem = tag === \"table\" && !rtbody.test( elem ) ?\n\t\t\t\t\t\t\ttmp.firstChild :\n\n\t\t\t\t\t\t\t// String was a bare <thead> or <tfoot>\n\t\t\t\t\t\t\twrap[ 1 ] === \"<table>\" && !rtbody.test( elem ) ?\n\t\t\t\t\t\t\t\ttmp :\n\t\t\t\t\t\t\t\t0;\n\n\t\t\t\t\t\tj = elem && elem.childNodes.length;\n\t\t\t\t\t\twhile ( j-- ) {\n\t\t\t\t\t\t\tif ( jQuery.nodeName( ( tbody = elem.childNodes[ j ] ), \"tbody\" ) &&\n\t\t\t\t\t\t\t\t!tbody.childNodes.length ) {\n\n\t\t\t\t\t\t\t\telem.removeChild( tbody );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tjQuery.merge( nodes, tmp.childNodes );\n\n\t\t\t\t\t// Fix #12392 for WebKit and IE > 9\n\t\t\t\t\ttmp.textContent = \"\";\n\n\t\t\t\t\t// Fix #12392 for oldIE\n\t\t\t\t\twhile ( tmp.firstChild ) {\n\t\t\t\t\t\ttmp.removeChild( tmp.firstChild );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remember the top-level container for proper cleanup\n\t\t\t\t\ttmp = safe.lastChild;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Fix #11356: Clear elements from fragment\n\t\tif ( tmp ) {\n\t\t\tsafe.removeChild( tmp );\n\t\t}\n\n\t\t// Reset defaultChecked for any radios and checkboxes\n\t\t// about to be appended to the DOM in IE 6/7 (#8060)\n\t\tif ( !support.appendChecked ) {\n\t\t\tjQuery.grep( getAll( nodes, \"input\" ), fixDefaultChecked );\n\t\t}\n\n\t\ti = 0;\n\t\twhile ( ( elem = nodes[ i++ ] ) ) {\n\n\t\t\t// Skip elements already in the context collection (trac-4087)\n\t\t\tif ( selection && jQuery.inArray( elem, selection ) > -1 ) {\n\t\t\t\tif ( ignored ) {\n\t\t\t\t\tignored.push( elem );\n\t\t\t\t}\n\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tcontains = jQuery.contains( elem.ownerDocument, elem );\n\n\t\t\t// Append to fragment\n\t\t\ttmp = getAll( safe.appendChild( elem ), \"script\" );\n\n\t\t\t// Preserve script evaluation history\n\t\t\tif ( contains ) {\n\t\t\t\tsetGlobalEval( tmp );\n\t\t\t}\n\n\t\t\t// Capture executables\n\t\t\tif ( scripts ) {\n\t\t\t\tj = 0;\n\t\t\t\twhile ( ( elem = tmp[ j++ ] ) ) {\n\t\t\t\t\tif ( rscriptType.test( elem.type || \"\" ) ) {\n\t\t\t\t\t\tscripts.push( elem );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\ttmp = null;\n\n\t\treturn safe;\n\t}\n\n\n\t( function() {\n\t\tvar i, eventName,\n\t\t\tdiv = document.createElement( \"div\" );\n\n\t\t// Support: IE<9 (lack submit/change bubble), Firefox (lack focus(in | out) events)\n\t\tfor ( i in { submit: true, change: true, focusin: true } ) {\n\t\t\teventName = \"on\" + i;\n\n\t\t\tif ( !( support[ i ] = eventName in window ) ) {\n\n\t\t\t\t// Beware of CSP restrictions (https://developer.mozilla.org/en/Security/CSP)\n\t\t\t\tdiv.setAttribute( eventName, \"t\" );\n\t\t\t\tsupport[ i ] = div.attributes[ eventName ].expando === false;\n\t\t\t}\n\t\t}\n\n\t\t// Null elements to avoid leaks in IE.\n\t\tdiv = null;\n\t} )();\n\n\n\tvar rformElems = /^(?:input|select|textarea)$/i,\n\t\trkeyEvent = /^key/,\n\t\trmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,\n\t\trfocusMorph = /^(?:focusinfocus|focusoutblur)$/,\n\t\trtypenamespace = /^([^.]*)(?:\\.(.+)|)/;\n\n\tfunction returnTrue() {\n\t\treturn true;\n\t}\n\n\tfunction returnFalse() {\n\t\treturn false;\n\t}\n\n// Support: IE9\n// See #13393 for more info\n\tfunction safeActiveElement() {\n\t\ttry {\n\t\t\treturn document.activeElement;\n\t\t} catch ( err ) { }\n\t}\n\n\tfunction on( elem, types, selector, data, fn, one ) {\n\t\tvar origFn, type;\n\n\t\t// Types can be a map of types/handlers\n\t\tif ( typeof types === \"object\" ) {\n\n\t\t\t// ( types-Object, selector, data )\n\t\t\tif ( typeof selector !== \"string\" ) {\n\n\t\t\t\t// ( types-Object, data )\n\t\t\t\tdata = data || selector;\n\t\t\t\tselector = undefined;\n\t\t\t}\n\t\t\tfor ( type in types ) {\n\t\t\t\ton( elem, type, selector, data, types[ type ], one );\n\t\t\t}\n\t\t\treturn elem;\n\t\t}\n\n\t\tif ( data == null && fn == null ) {\n\n\t\t\t// ( types, fn )\n\t\t\tfn = selector;\n\t\t\tdata = selector = undefined;\n\t\t} else if ( fn == null ) {\n\t\t\tif ( typeof selector === \"string\" ) {\n\n\t\t\t\t// ( types, selector, fn )\n\t\t\t\tfn = data;\n\t\t\t\tdata = undefined;\n\t\t\t} else {\n\n\t\t\t\t// ( types, data, fn )\n\t\t\t\tfn = data;\n\t\t\t\tdata = selector;\n\t\t\t\tselector = undefined;\n\t\t\t}\n\t\t}\n\t\tif ( fn === false ) {\n\t\t\tfn = returnFalse;\n\t\t} else if ( !fn ) {\n\t\t\treturn elem;\n\t\t}\n\n\t\tif ( one === 1 ) {\n\t\t\torigFn = fn;\n\t\t\tfn = function( event ) {\n\n\t\t\t\t// Can use an empty set, since event contains the info\n\t\t\t\tjQuery().off( event );\n\t\t\t\treturn origFn.apply( this, arguments );\n\t\t\t};\n\n\t\t\t// Use same guid so caller can remove using origFn\n\t\t\tfn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );\n\t\t}\n\t\treturn elem.each( function() {\n\t\t\tjQuery.event.add( this, types, fn, data, selector );\n\t\t} );\n\t}\n\n\t/*\n\t * Helper functions for managing events -- not part of the public interface.\n\t * Props to Dean Edwards' addEvent library for many of the ideas.\n\t */\n\tjQuery.event = {\n\n\t\tglobal: {},\n\n\t\tadd: function( elem, types, handler, data, selector ) {\n\t\t\tvar tmp, events, t, handleObjIn,\n\t\t\t\tspecial, eventHandle, handleObj,\n\t\t\t\thandlers, type, namespaces, origType,\n\t\t\t\telemData = jQuery._data( elem );\n\n\t\t\t// Don't attach events to noData or text/comment nodes (but allow plain objects)\n\t\t\tif ( !elemData ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Caller can pass in an object of custom data in lieu of the handler\n\t\t\tif ( handler.handler ) {\n\t\t\t\thandleObjIn = handler;\n\t\t\t\thandler = handleObjIn.handler;\n\t\t\t\tselector = handleObjIn.selector;\n\t\t\t}\n\n\t\t\t// Make sure that the handler has a unique ID, used to find/remove it later\n\t\t\tif ( !handler.guid ) {\n\t\t\t\thandler.guid = jQuery.guid++;\n\t\t\t}\n\n\t\t\t// Init the element's event structure and main handler, if this is the first\n\t\t\tif ( !( events = elemData.events ) ) {\n\t\t\t\tevents = elemData.events = {};\n\t\t\t}\n\t\t\tif ( !( eventHandle = elemData.handle ) ) {\n\t\t\t\teventHandle = elemData.handle = function( e ) {\n\n\t\t\t\t\t// Discard the second event of a jQuery.event.trigger() and\n\t\t\t\t\t// when an event is called after a page has unloaded\n\t\t\t\t\treturn typeof jQuery !== \"undefined\" &&\n\t\t\t\t\t( !e || jQuery.event.triggered !== e.type ) ?\n\t\t\t\t\t\tjQuery.event.dispatch.apply( eventHandle.elem, arguments ) :\n\t\t\t\t\t\tundefined;\n\t\t\t\t};\n\n\t\t\t\t// Add elem as a property of the handle fn to prevent a memory leak\n\t\t\t\t// with IE non-native events\n\t\t\t\teventHandle.elem = elem;\n\t\t\t}\n\n\t\t\t// Handle multiple events separated by a space\n\t\t\ttypes = ( types || \"\" ).match( rnotwhite ) || [ \"\" ];\n\t\t\tt = types.length;\n\t\t\twhile ( t-- ) {\n\t\t\t\ttmp = rtypenamespace.exec( types[ t ] ) || [];\n\t\t\t\ttype = origType = tmp[ 1 ];\n\t\t\t\tnamespaces = ( tmp[ 2 ] || \"\" ).split( \".\" ).sort();\n\n\t\t\t\t// There *must* be a type, no attaching namespace-only handlers\n\t\t\t\tif ( !type ) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\t// If event changes its type, use the special event handlers for the changed type\n\t\t\t\tspecial = jQuery.event.special[ type ] || {};\n\n\t\t\t\t// If selector defined, determine special event api type, otherwise given type\n\t\t\t\ttype = ( selector ? special.delegateType : special.bindType ) || type;\n\n\t\t\t\t// Update special based on newly reset type\n\t\t\t\tspecial = jQuery.event.special[ type ] || {};\n\n\t\t\t\t// handleObj is passed to all event handlers\n\t\t\t\thandleObj = jQuery.extend( {\n\t\t\t\t\ttype: type,\n\t\t\t\t\torigType: origType,\n\t\t\t\t\tdata: data,\n\t\t\t\t\thandler: handler,\n\t\t\t\t\tguid: handler.guid,\n\t\t\t\t\tselector: selector,\n\t\t\t\t\tneedsContext: selector && jQuery.expr.match.needsContext.test( selector ),\n\t\t\t\t\tnamespace: namespaces.join( \".\" )\n\t\t\t\t}, handleObjIn );\n\n\t\t\t\t// Init the event handler queue if we're the first\n\t\t\t\tif ( !( handlers = events[ type ] ) ) {\n\t\t\t\t\thandlers = events[ type ] = [];\n\t\t\t\t\thandlers.delegateCount = 0;\n\n\t\t\t\t\t// Only use addEventListener/attachEvent if the special events handler returns false\n\t\t\t\t\tif ( !special.setup ||\n\t\t\t\t\t\tspecial.setup.call( elem, data, namespaces, eventHandle ) === false ) {\n\n\t\t\t\t\t\t// Bind the global event handler to the element\n\t\t\t\t\t\tif ( elem.addEventListener ) {\n\t\t\t\t\t\t\telem.addEventListener( type, eventHandle, false );\n\n\t\t\t\t\t\t} else if ( elem.attachEvent ) {\n\t\t\t\t\t\t\telem.attachEvent( \"on\" + type, eventHandle );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( special.add ) {\n\t\t\t\t\tspecial.add.call( elem, handleObj );\n\n\t\t\t\t\tif ( !handleObj.handler.guid ) {\n\t\t\t\t\t\thandleObj.handler.guid = handler.guid;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Add to the element's handler list, delegates in front\n\t\t\t\tif ( selector ) {\n\t\t\t\t\thandlers.splice( handlers.delegateCount++, 0, handleObj );\n\t\t\t\t} else {\n\t\t\t\t\thandlers.push( handleObj );\n\t\t\t\t}\n\n\t\t\t\t// Keep track of which events have ever been used, for event optimization\n\t\t\t\tjQuery.event.global[ type ] = true;\n\t\t\t}\n\n\t\t\t// Nullify elem to prevent memory leaks in IE\n\t\t\telem = null;\n\t\t},\n\n\t\t// Detach an event or set of events from an element\n\t\tremove: function( elem, types, handler, selector, mappedTypes ) {\n\t\t\tvar j, handleObj, tmp,\n\t\t\t\torigCount, t, events,\n\t\t\t\tspecial, handlers, type,\n\t\t\t\tnamespaces, origType,\n\t\t\t\telemData = jQuery.hasData( elem ) && jQuery._data( elem );\n\n\t\t\tif ( !elemData || !( events = elemData.events ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Once for each type.namespace in types; type may be omitted\n\t\t\ttypes = ( types || \"\" ).match( rnotwhite ) || [ \"\" ];\n\t\t\tt = types.length;\n\t\t\twhile ( t-- ) {\n\t\t\t\ttmp = rtypenamespace.exec( types[ t ] ) || [];\n\t\t\t\ttype = origType = tmp[ 1 ];\n\t\t\t\tnamespaces = ( tmp[ 2 ] || \"\" ).split( \".\" ).sort();\n\n\t\t\t\t// Unbind all events (on this namespace, if provided) for the element\n\t\t\t\tif ( !type ) {\n\t\t\t\t\tfor ( type in events ) {\n\t\t\t\t\t\tjQuery.event.remove( elem, type + types[ t ], handler, selector, true );\n\t\t\t\t\t}\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\tspecial = jQuery.event.special[ type ] || {};\n\t\t\t\ttype = ( selector ? special.delegateType : special.bindType ) || type;\n\t\t\t\thandlers = events[ type ] || [];\n\t\t\t\ttmp = tmp[ 2 ] &&\n\t\t\t\t\tnew RegExp( \"(^|\\\\.)\" + namespaces.join( \"\\\\.(?:.*\\\\.|)\" ) + \"(\\\\.|$)\" );\n\n\t\t\t\t// Remove matching events\n\t\t\t\torigCount = j = handlers.length;\n\t\t\t\twhile ( j-- ) {\n\t\t\t\t\thandleObj = handlers[ j ];\n\n\t\t\t\t\tif ( ( mappedTypes || origType === handleObj.origType ) &&\n\t\t\t\t\t\t( !handler || handler.guid === handleObj.guid ) &&\n\t\t\t\t\t\t( !tmp || tmp.test( handleObj.namespace ) ) &&\n\t\t\t\t\t\t( !selector || selector === handleObj.selector ||\n\t\t\t\t\t\tselector === \"**\" && handleObj.selector ) ) {\n\t\t\t\t\t\thandlers.splice( j, 1 );\n\n\t\t\t\t\t\tif ( handleObj.selector ) {\n\t\t\t\t\t\t\thandlers.delegateCount--;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( special.remove ) {\n\t\t\t\t\t\t\tspecial.remove.call( elem, handleObj );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Remove generic event handler if we removed something and no more handlers exist\n\t\t\t\t// (avoids potential for endless recursion during removal of special event handlers)\n\t\t\t\tif ( origCount && !handlers.length ) {\n\t\t\t\t\tif ( !special.teardown ||\n\t\t\t\t\t\tspecial.teardown.call( elem, namespaces, elemData.handle ) === false ) {\n\n\t\t\t\t\t\tjQuery.removeEvent( elem, type, elemData.handle );\n\t\t\t\t\t}\n\n\t\t\t\t\tdelete events[ type ];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove the expando if it's no longer used\n\t\t\tif ( jQuery.isEmptyObject( events ) ) {\n\t\t\t\tdelete elemData.handle;\n\n\t\t\t\t// removeData also checks for emptiness and clears the expando if empty\n\t\t\t\t// so use it instead of delete\n\t\t\t\tjQuery._removeData( elem, \"events\" );\n\t\t\t}\n\t\t},\n\n\t\ttrigger: function( event, data, elem, onlyHandlers ) {\n\t\t\tvar handle, ontype, cur,\n\t\t\t\tbubbleType, special, tmp, i,\n\t\t\t\teventPath = [ elem || document ],\n\t\t\t\ttype = hasOwn.call( event, \"type\" ) ? event.type : event,\n\t\t\t\tnamespaces = hasOwn.call( event, \"namespace\" ) ? event.namespace.split( \".\" ) : [];\n\n\t\t\tcur = tmp = elem = elem || document;\n\n\t\t\t// Don't do events on text and comment nodes\n\t\t\tif ( elem.nodeType === 3 || elem.nodeType === 8 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// focus/blur morphs to focusin/out; ensure we're not firing them right now\n\t\t\tif ( rfocusMorph.test( type + jQuery.event.triggered ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( type.indexOf( \".\" ) > -1 ) {\n\n\t\t\t\t// Namespaced trigger; create a regexp to match event type in handle()\n\t\t\t\tnamespaces = type.split( \".\" );\n\t\t\t\ttype = namespaces.shift();\n\t\t\t\tnamespaces.sort();\n\t\t\t}\n\t\t\tontype = type.indexOf( \":\" ) < 0 && \"on\" + type;\n\n\t\t\t// Caller can pass in a jQuery.Event object, Object, or just an event type string\n\t\t\tevent = event[ jQuery.expando ] ?\n\t\t\t\tevent :\n\t\t\t\tnew jQuery.Event( type, typeof event === \"object\" && event );\n\n\t\t\t// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)\n\t\t\tevent.isTrigger = onlyHandlers ? 2 : 3;\n\t\t\tevent.namespace = namespaces.join( \".\" );\n\t\t\tevent.rnamespace = event.namespace ?\n\t\t\t\tnew RegExp( \"(^|\\\\.)\" + namespaces.join( \"\\\\.(?:.*\\\\.|)\" ) + \"(\\\\.|$)\" ) :\n\t\t\t\tnull;\n\n\t\t\t// Clean up the event in case it is being reused\n\t\t\tevent.result = undefined;\n\t\t\tif ( !event.target ) {\n\t\t\t\tevent.target = elem;\n\t\t\t}\n\n\t\t\t// Clone any incoming data and prepend the event, creating the handler arg list\n\t\t\tdata = data == null ?\n\t\t\t\t[ event ] :\n\t\t\t\tjQuery.makeArray( data, [ event ] );\n\n\t\t\t// Allow special events to draw outside the lines\n\t\t\tspecial = jQuery.event.special[ type ] || {};\n\t\t\tif ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Determine event propagation path in advance, per W3C events spec (#9951)\n\t\t\t// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)\n\t\t\tif ( !onlyHandlers && !special.noBubble && !jQuery.isWindow( elem ) ) {\n\n\t\t\t\tbubbleType = special.delegateType || type;\n\t\t\t\tif ( !rfocusMorph.test( bubbleType + type ) ) {\n\t\t\t\t\tcur = cur.parentNode;\n\t\t\t\t}\n\t\t\t\tfor ( ; cur; cur = cur.parentNode ) {\n\t\t\t\t\teventPath.push( cur );\n\t\t\t\t\ttmp = cur;\n\t\t\t\t}\n\n\t\t\t\t// Only add window if we got to document (e.g., not plain obj or detached DOM)\n\t\t\t\tif ( tmp === ( elem.ownerDocument || document ) ) {\n\t\t\t\t\teventPath.push( tmp.defaultView || tmp.parentWindow || window );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Fire handlers on the event path\n\t\t\ti = 0;\n\t\t\twhile ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {\n\n\t\t\t\tevent.type = i > 1 ?\n\t\t\t\t\tbubbleType :\n\t\t\t\tspecial.bindType || type;\n\n\t\t\t\t// jQuery handler\n\t\t\t\thandle = ( jQuery._data( cur, \"events\" ) || {} )[ event.type ] &&\n\t\t\t\t\tjQuery._data( cur, \"handle\" );\n\n\t\t\t\tif ( handle ) {\n\t\t\t\t\thandle.apply( cur, data );\n\t\t\t\t}\n\n\t\t\t\t// Native handler\n\t\t\t\thandle = ontype && cur[ ontype ];\n\t\t\t\tif ( handle && handle.apply && acceptData( cur ) ) {\n\t\t\t\t\tevent.result = handle.apply( cur, data );\n\t\t\t\t\tif ( event.result === false ) {\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tevent.type = type;\n\n\t\t\t// If nobody prevented the default action, do it now\n\t\t\tif ( !onlyHandlers && !event.isDefaultPrevented() ) {\n\n\t\t\t\tif (\n\t\t\t\t\t( !special._default ||\n\t\t\t\t\t\tspecial._default.apply( eventPath.pop(), data ) === false\n\t\t\t\t\t) && acceptData( elem )\n\t\t\t\t) {\n\n\t\t\t\t\t// Call a native DOM method on the target with the same name name as the event.\n\t\t\t\t\t// Can't use an .isFunction() check here because IE6/7 fails that test.\n\t\t\t\t\t// Don't do default actions on window, that's where global variables be (#6170)\n\t\t\t\t\tif ( ontype && elem[ type ] && !jQuery.isWindow( elem ) ) {\n\n\t\t\t\t\t\t// Don't re-trigger an onFOO event when we call its FOO() method\n\t\t\t\t\t\ttmp = elem[ ontype ];\n\n\t\t\t\t\t\tif ( tmp ) {\n\t\t\t\t\t\t\telem[ ontype ] = null;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Prevent re-triggering of the same event, since we already bubbled it above\n\t\t\t\t\t\tjQuery.event.triggered = type;\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\telem[ type ]();\n\t\t\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t\t\t// IE<9 dies on focus/blur to hidden element (#1486,#12518)\n\t\t\t\t\t\t\t// only reproducible on winXP IE8 native, not IE9 in IE8 mode\n\t\t\t\t\t\t}\n\t\t\t\t\t\tjQuery.event.triggered = undefined;\n\n\t\t\t\t\t\tif ( tmp ) {\n\t\t\t\t\t\t\telem[ ontype ] = tmp;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn event.result;\n\t\t},\n\n\t\tdispatch: function( event ) {\n\n\t\t\t// Make a writable jQuery.Event from the native event object\n\t\t\tevent = jQuery.event.fix( event );\n\n\t\t\tvar i, j, ret, matched, handleObj,\n\t\t\t\thandlerQueue = [],\n\t\t\t\targs = slice.call( arguments ),\n\t\t\t\thandlers = ( jQuery._data( this, \"events\" ) || {} )[ event.type ] || [],\n\t\t\t\tspecial = jQuery.event.special[ event.type ] || {};\n\n\t\t\t// Use the fix-ed jQuery.Event rather than the (read-only) native event\n\t\t\targs[ 0 ] = event;\n\t\t\tevent.delegateTarget = this;\n\n\t\t\t// Call the preDispatch hook for the mapped type, and let it bail if desired\n\t\t\tif ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Determine handlers\n\t\t\thandlerQueue = jQuery.event.handlers.call( this, event, handlers );\n\n\t\t\t// Run delegates first; they may want to stop propagation beneath us\n\t\t\ti = 0;\n\t\t\twhile ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {\n\t\t\t\tevent.currentTarget = matched.elem;\n\n\t\t\t\tj = 0;\n\t\t\t\twhile ( ( handleObj = matched.handlers[ j++ ] ) &&\n\t\t\t\t!event.isImmediatePropagationStopped() ) {\n\n\t\t\t\t\t// Triggered event must either 1) have no namespace, or 2) have namespace(s)\n\t\t\t\t\t// a subset or equal to those in the bound event (both can have no namespace).\n\t\t\t\t\tif ( !event.rnamespace || event.rnamespace.test( handleObj.namespace ) ) {\n\n\t\t\t\t\t\tevent.handleObj = handleObj;\n\t\t\t\t\t\tevent.data = handleObj.data;\n\n\t\t\t\t\t\tret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||\n\t\t\t\t\t\thandleObj.handler ).apply( matched.elem, args );\n\n\t\t\t\t\t\tif ( ret !== undefined ) {\n\t\t\t\t\t\t\tif ( ( event.result = ret ) === false ) {\n\t\t\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\t\t\tevent.stopPropagation();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Call the postDispatch hook for the mapped type\n\t\t\tif ( special.postDispatch ) {\n\t\t\t\tspecial.postDispatch.call( this, event );\n\t\t\t}\n\n\t\t\treturn event.result;\n\t\t},\n\n\t\thandlers: function( event, handlers ) {\n\t\t\tvar i, matches, sel, handleObj,\n\t\t\t\thandlerQueue = [],\n\t\t\t\tdelegateCount = handlers.delegateCount,\n\t\t\t\tcur = event.target;\n\n\t\t\t// Support (at least): Chrome, IE9\n\t\t\t// Find delegate handlers\n\t\t\t// Black-hole SVG <use> instance trees (#13180)\n\t\t\t//\n\t\t\t// Support: Firefox<=42+\n\t\t\t// Avoid non-left-click in FF but don't block IE radio events (#3861, gh-2343)\n\t\t\tif ( delegateCount && cur.nodeType &&\n\t\t\t\t( event.type !== \"click\" || isNaN( event.button ) || event.button < 1 ) ) {\n\n\t\t\t\t/* jshint eqeqeq: false */\n\t\t\t\tfor ( ; cur != this; cur = cur.parentNode || this ) {\n\t\t\t\t\t/* jshint eqeqeq: true */\n\n\t\t\t\t\t// Don't check non-elements (#13208)\n\t\t\t\t\t// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)\n\t\t\t\t\tif ( cur.nodeType === 1 && ( cur.disabled !== true || event.type !== \"click\" ) ) {\n\t\t\t\t\t\tmatches = [];\n\t\t\t\t\t\tfor ( i = 0; i < delegateCount; i++ ) {\n\t\t\t\t\t\t\thandleObj = handlers[ i ];\n\n\t\t\t\t\t\t\t// Don't conflict with Object.prototype properties (#13203)\n\t\t\t\t\t\t\tsel = handleObj.selector + \" \";\n\n\t\t\t\t\t\t\tif ( matches[ sel ] === undefined ) {\n\t\t\t\t\t\t\t\tmatches[ sel ] = handleObj.needsContext ?\n\t\t\t\t\t\t\t\tjQuery( sel, this ).index( cur ) > -1 :\n\t\t\t\t\t\t\t\t\tjQuery.find( sel, this, null, [ cur ] ).length;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif ( matches[ sel ] ) {\n\t\t\t\t\t\t\t\tmatches.push( handleObj );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( matches.length ) {\n\t\t\t\t\t\t\thandlerQueue.push( { elem: cur, handlers: matches } );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Add the remaining (directly-bound) handlers\n\t\t\tif ( delegateCount < handlers.length ) {\n\t\t\t\thandlerQueue.push( { elem: this, handlers: handlers.slice( delegateCount ) } );\n\t\t\t}\n\n\t\t\treturn handlerQueue;\n\t\t},\n\n\t\tfix: function( event ) {\n\t\t\tif ( event[ jQuery.expando ] ) {\n\t\t\t\treturn event;\n\t\t\t}\n\n\t\t\t// Create a writable copy of the event object and normalize some properties\n\t\t\tvar i, prop, copy,\n\t\t\t\ttype = event.type,\n\t\t\t\toriginalEvent = event,\n\t\t\t\tfixHook = this.fixHooks[ type ];\n\n\t\t\tif ( !fixHook ) {\n\t\t\t\tthis.fixHooks[ type ] = fixHook =\n\t\t\t\t\trmouseEvent.test( type ) ? this.mouseHooks :\n\t\t\t\t\t\trkeyEvent.test( type ) ? this.keyHooks :\n\t\t\t\t\t\t{};\n\t\t\t}\n\t\t\tcopy = fixHook.props ? this.props.concat( fixHook.props ) : this.props;\n\n\t\t\tevent = new jQuery.Event( originalEvent );\n\n\t\t\ti = copy.length;\n\t\t\twhile ( i-- ) {\n\t\t\t\tprop = copy[ i ];\n\t\t\t\tevent[ prop ] = originalEvent[ prop ];\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// Fix target property (#1925)\n\t\t\tif ( !event.target ) {\n\t\t\t\tevent.target = originalEvent.srcElement || document;\n\t\t\t}\n\n\t\t\t// Support: Safari 6-8+\n\t\t\t// Target should not be a text node (#504, #13143)\n\t\t\tif ( event.target.nodeType === 3 ) {\n\t\t\t\tevent.target = event.target.parentNode;\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// For mouse/key events, metaKey==false if it's undefined (#3368, #11328)\n\t\t\tevent.metaKey = !!event.metaKey;\n\n\t\t\treturn fixHook.filter ? fixHook.filter( event, originalEvent ) : event;\n\t\t},\n\n\t\t// Includes some event props shared by KeyEvent and MouseEvent\n\t\tprops: ( \"altKey bubbles cancelable ctrlKey currentTarget detail eventPhase \" +\n\t\t\"metaKey relatedTarget shiftKey target timeStamp view which\" ).split( \" \" ),\n\n\t\tfixHooks: {},\n\n\t\tkeyHooks: {\n\t\t\tprops: \"char charCode key keyCode\".split( \" \" ),\n\t\t\tfilter: function( event, original ) {\n\n\t\t\t\t// Add which for key events\n\t\t\t\tif ( event.which == null ) {\n\t\t\t\t\tevent.which = original.charCode != null ? original.charCode : original.keyCode;\n\t\t\t\t}\n\n\t\t\t\treturn event;\n\t\t\t}\n\t\t},\n\n\t\tmouseHooks: {\n\t\t\tprops: ( \"button buttons clientX clientY fromElement offsetX offsetY \" +\n\t\t\t\"pageX pageY screenX screenY toElement\" ).split( \" \" ),\n\t\t\tfilter: function( event, original ) {\n\t\t\t\tvar body, eventDoc, doc,\n\t\t\t\t\tbutton = original.button,\n\t\t\t\t\tfromElement = original.fromElement;\n\n\t\t\t\t// Calculate pageX/Y if missing and clientX/Y available\n\t\t\t\tif ( event.pageX == null && original.clientX != null ) {\n\t\t\t\t\teventDoc = event.target.ownerDocument || document;\n\t\t\t\t\tdoc = eventDoc.documentElement;\n\t\t\t\t\tbody = eventDoc.body;\n\n\t\t\t\t\tevent.pageX = original.clientX +\n\t\t\t\t\t\t( doc && doc.scrollLeft || body && body.scrollLeft || 0 ) -\n\t\t\t\t\t\t( doc && doc.clientLeft || body && body.clientLeft || 0 );\n\t\t\t\t\tevent.pageY = original.clientY +\n\t\t\t\t\t\t( doc && doc.scrollTop  || body && body.scrollTop  || 0 ) -\n\t\t\t\t\t\t( doc && doc.clientTop  || body && body.clientTop  || 0 );\n\t\t\t\t}\n\n\t\t\t\t// Add relatedTarget, if necessary\n\t\t\t\tif ( !event.relatedTarget && fromElement ) {\n\t\t\t\t\tevent.relatedTarget = fromElement === event.target ?\n\t\t\t\t\t\toriginal.toElement :\n\t\t\t\t\t\tfromElement;\n\t\t\t\t}\n\n\t\t\t\t// Add which for click: 1 === left; 2 === middle; 3 === right\n\t\t\t\t// Note: button is not normalized, so don't use it\n\t\t\t\tif ( !event.which && button !== undefined ) {\n\t\t\t\t\tevent.which = ( button & 1 ? 1 : ( button & 2 ? 3 : ( button & 4 ? 2 : 0 ) ) );\n\t\t\t\t}\n\n\t\t\t\treturn event;\n\t\t\t}\n\t\t},\n\n\t\tspecial: {\n\t\t\tload: {\n\n\t\t\t\t// Prevent triggered image.load events from bubbling to window.load\n\t\t\t\tnoBubble: true\n\t\t\t},\n\t\t\tfocus: {\n\n\t\t\t\t// Fire native event if possible so blur/focus sequence is correct\n\t\t\t\ttrigger: function() {\n\t\t\t\t\tif ( this !== safeActiveElement() && this.focus ) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tthis.focus();\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// If we error on focus to hidden element (#1486, #12518),\n\t\t\t\t\t\t\t// let .trigger() run the handlers\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tdelegateType: \"focusin\"\n\t\t\t},\n\t\t\tblur: {\n\t\t\t\ttrigger: function() {\n\t\t\t\t\tif ( this === safeActiveElement() && this.blur ) {\n\t\t\t\t\t\tthis.blur();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tdelegateType: \"focusout\"\n\t\t\t},\n\t\t\tclick: {\n\n\t\t\t\t// For checkbox, fire native event so checked state will be right\n\t\t\t\ttrigger: function() {\n\t\t\t\t\tif ( jQuery.nodeName( this, \"input\" ) && this.type === \"checkbox\" && this.click ) {\n\t\t\t\t\t\tthis.click();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\t// For cross-browser consistency, don't fire native .click() on links\n\t\t\t\t_default: function( event ) {\n\t\t\t\t\treturn jQuery.nodeName( event.target, \"a\" );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbeforeunload: {\n\t\t\t\tpostDispatch: function( event ) {\n\n\t\t\t\t\t// Support: Firefox 20+\n\t\t\t\t\t// Firefox doesn't alert if the returnValue field is not set.\n\t\t\t\t\tif ( event.result !== undefined && event.originalEvent ) {\n\t\t\t\t\t\tevent.originalEvent.returnValue = event.result;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t// Piggyback on a donor event to simulate a different one\n\t\tsimulate: function( type, elem, event ) {\n\t\t\tvar e = jQuery.extend(\n\t\t\t\tnew jQuery.Event(),\n\t\t\t\tevent,\n\t\t\t\t{\n\t\t\t\t\ttype: type,\n\t\t\t\t\tisSimulated: true\n\n\t\t\t\t\t// Previously, `originalEvent: {}` was set here, so stopPropagation call\n\t\t\t\t\t// would not be triggered on donor event, since in our own\n\t\t\t\t\t// jQuery.event.stopPropagation function we had a check for existence of\n\t\t\t\t\t// originalEvent.stopPropagation method, so, consequently it would be a noop.\n\t\t\t\t\t//\n\t\t\t\t\t// Guard for simulated events was moved to jQuery.event.stopPropagation function\n\t\t\t\t\t// since `originalEvent` should point to the original event for the\n\t\t\t\t\t// constancy with other events and for more focused logic\n\t\t\t\t}\n\t\t\t);\n\n\t\t\tjQuery.event.trigger( e, null, elem );\n\n\t\t\tif ( e.isDefaultPrevented() ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t}\n\t\t}\n\t};\n\n\tjQuery.removeEvent = document.removeEventListener ?\n\t\tfunction( elem, type, handle ) {\n\n\t\t\t// This \"if\" is needed for plain objects\n\t\t\tif ( elem.removeEventListener ) {\n\t\t\t\telem.removeEventListener( type, handle );\n\t\t\t}\n\t\t} :\n\t\tfunction( elem, type, handle ) {\n\t\t\tvar name = \"on\" + type;\n\n\t\t\tif ( elem.detachEvent ) {\n\n\t\t\t\t// #8545, #7054, preventing memory leaks for custom events in IE6-8\n\t\t\t\t// detachEvent needed property on element, by name of that event,\n\t\t\t\t// to properly expose it to GC\n\t\t\t\tif ( typeof elem[ name ] === \"undefined\" ) {\n\t\t\t\t\telem[ name ] = null;\n\t\t\t\t}\n\n\t\t\t\telem.detachEvent( name, handle );\n\t\t\t}\n\t\t};\n\n\tjQuery.Event = function( src, props ) {\n\n\t\t// Allow instantiation without the 'new' keyword\n\t\tif ( !( this instanceof jQuery.Event ) ) {\n\t\t\treturn new jQuery.Event( src, props );\n\t\t}\n\n\t\t// Event object\n\t\tif ( src && src.type ) {\n\t\t\tthis.originalEvent = src;\n\t\t\tthis.type = src.type;\n\n\t\t\t// Events bubbling up the document may have been marked as prevented\n\t\t\t// by a handler lower down the tree; reflect the correct value.\n\t\t\tthis.isDefaultPrevented = src.defaultPrevented ||\n\t\t\tsrc.defaultPrevented === undefined &&\n\n\t\t\t// Support: IE < 9, Android < 4.0\n\t\t\tsrc.returnValue === false ?\n\t\t\t\treturnTrue :\n\t\t\t\treturnFalse;\n\n\t\t\t// Event type\n\t\t} else {\n\t\t\tthis.type = src;\n\t\t}\n\n\t\t// Put explicitly provided properties onto the event object\n\t\tif ( props ) {\n\t\t\tjQuery.extend( this, props );\n\t\t}\n\n\t\t// Create a timestamp if incoming event doesn't have one\n\t\tthis.timeStamp = src && src.timeStamp || jQuery.now();\n\n\t\t// Mark it as fixed\n\t\tthis[ jQuery.expando ] = true;\n\t};\n\n// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding\n// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html\n\tjQuery.Event.prototype = {\n\t\tconstructor: jQuery.Event,\n\t\tisDefaultPrevented: returnFalse,\n\t\tisPropagationStopped: returnFalse,\n\t\tisImmediatePropagationStopped: returnFalse,\n\n\t\tpreventDefault: function() {\n\t\t\tvar e = this.originalEvent;\n\n\t\t\tthis.isDefaultPrevented = returnTrue;\n\t\t\tif ( !e ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// If preventDefault exists, run it on the original event\n\t\t\tif ( e.preventDefault ) {\n\t\t\t\te.preventDefault();\n\n\t\t\t\t// Support: IE\n\t\t\t\t// Otherwise set the returnValue property of the original event to false\n\t\t\t} else {\n\t\t\t\te.returnValue = false;\n\t\t\t}\n\t\t},\n\t\tstopPropagation: function() {\n\t\t\tvar e = this.originalEvent;\n\n\t\t\tthis.isPropagationStopped = returnTrue;\n\n\t\t\tif ( !e || this.isSimulated ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// If stopPropagation exists, run it on the original event\n\t\t\tif ( e.stopPropagation ) {\n\t\t\t\te.stopPropagation();\n\t\t\t}\n\n\t\t\t// Support: IE\n\t\t\t// Set the cancelBubble property of the original event to true\n\t\t\te.cancelBubble = true;\n\t\t},\n\t\tstopImmediatePropagation: function() {\n\t\t\tvar e = this.originalEvent;\n\n\t\t\tthis.isImmediatePropagationStopped = returnTrue;\n\n\t\t\tif ( e && e.stopImmediatePropagation ) {\n\t\t\t\te.stopImmediatePropagation();\n\t\t\t}\n\n\t\t\tthis.stopPropagation();\n\t\t}\n\t};\n\n// Create mouseenter/leave events using mouseover/out and event-time checks\n// so that event delegation works in jQuery.\n// Do the same for pointerenter/pointerleave and pointerover/pointerout\n//\n// Support: Safari 7 only\n// Safari sends mouseenter too often; see:\n// https://code.google.com/p/chromium/issues/detail?id=470258\n// for the description of the bug (it existed in older Chrome versions as well).\n\tjQuery.each( {\n\t\tmouseenter: \"mouseover\",\n\t\tmouseleave: \"mouseout\",\n\t\tpointerenter: \"pointerover\",\n\t\tpointerleave: \"pointerout\"\n\t}, function( orig, fix ) {\n\t\tjQuery.event.special[ orig ] = {\n\t\t\tdelegateType: fix,\n\t\t\tbindType: fix,\n\n\t\t\thandle: function( event ) {\n\t\t\t\tvar ret,\n\t\t\t\t\ttarget = this,\n\t\t\t\t\trelated = event.relatedTarget,\n\t\t\t\t\thandleObj = event.handleObj;\n\n\t\t\t\t// For mouseenter/leave call the handler if related is outside the target.\n\t\t\t\t// NB: No relatedTarget if the mouse left/entered the browser window\n\t\t\t\tif ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {\n\t\t\t\t\tevent.type = handleObj.origType;\n\t\t\t\t\tret = handleObj.handler.apply( this, arguments );\n\t\t\t\t\tevent.type = fix;\n\t\t\t\t}\n\t\t\t\treturn ret;\n\t\t\t}\n\t\t};\n\t} );\n\n// IE submit delegation\n\tif ( !support.submit ) {\n\n\t\tjQuery.event.special.submit = {\n\t\t\tsetup: function() {\n\n\t\t\t\t// Only need this for delegated form submit events\n\t\t\t\tif ( jQuery.nodeName( this, \"form\" ) ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\t// Lazy-add a submit handler when a descendant form may potentially be submitted\n\t\t\t\tjQuery.event.add( this, \"click._submit keypress._submit\", function( e ) {\n\n\t\t\t\t\t// Node name check avoids a VML-related crash in IE (#9807)\n\t\t\t\t\tvar elem = e.target,\n\t\t\t\t\t\tform = jQuery.nodeName( elem, \"input\" ) || jQuery.nodeName( elem, \"button\" ) ?\n\n\t\t\t\t\t\t\t// Support: IE <=8\n\t\t\t\t\t\t\t// We use jQuery.prop instead of elem.form\n\t\t\t\t\t\t\t// to allow fixing the IE8 delegated submit issue (gh-2332)\n\t\t\t\t\t\t\t// by 3rd party polyfills/workarounds.\n\t\t\t\t\t\t\tjQuery.prop( elem, \"form\" ) :\n\t\t\t\t\t\t\tundefined;\n\n\t\t\t\t\tif ( form && !jQuery._data( form, \"submit\" ) ) {\n\t\t\t\t\t\tjQuery.event.add( form, \"submit._submit\", function( event ) {\n\t\t\t\t\t\t\tevent._submitBubble = true;\n\t\t\t\t\t\t} );\n\t\t\t\t\t\tjQuery._data( form, \"submit\", true );\n\t\t\t\t\t}\n\t\t\t\t} );\n\n\t\t\t\t// return undefined since we don't need an event listener\n\t\t\t},\n\n\t\t\tpostDispatch: function( event ) {\n\n\t\t\t\t// If form was submitted by the user, bubble the event up the tree\n\t\t\t\tif ( event._submitBubble ) {\n\t\t\t\t\tdelete event._submitBubble;\n\t\t\t\t\tif ( this.parentNode && !event.isTrigger ) {\n\t\t\t\t\t\tjQuery.event.simulate( \"submit\", this.parentNode, event );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tteardown: function() {\n\n\t\t\t\t// Only need this for delegated form submit events\n\t\t\t\tif ( jQuery.nodeName( this, \"form\" ) ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\t// Remove delegated handlers; cleanData eventually reaps submit handlers attached above\n\t\t\t\tjQuery.event.remove( this, \"._submit\" );\n\t\t\t}\n\t\t};\n\t}\n\n// IE change delegation and checkbox/radio fix\n\tif ( !support.change ) {\n\n\t\tjQuery.event.special.change = {\n\n\t\t\tsetup: function() {\n\n\t\t\t\tif ( rformElems.test( this.nodeName ) ) {\n\n\t\t\t\t\t// IE doesn't fire change on a check/radio until blur; trigger it on click\n\t\t\t\t\t// after a propertychange. Eat the blur-change in special.change.handle.\n\t\t\t\t\t// This still fires onchange a second time for check/radio after blur.\n\t\t\t\t\tif ( this.type === \"checkbox\" || this.type === \"radio\" ) {\n\t\t\t\t\t\tjQuery.event.add( this, \"propertychange._change\", function( event ) {\n\t\t\t\t\t\t\tif ( event.originalEvent.propertyName === \"checked\" ) {\n\t\t\t\t\t\t\t\tthis._justChanged = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} );\n\t\t\t\t\t\tjQuery.event.add( this, \"click._change\", function( event ) {\n\t\t\t\t\t\t\tif ( this._justChanged && !event.isTrigger ) {\n\t\t\t\t\t\t\t\tthis._justChanged = false;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Allow triggered, simulated change events (#11500)\n\t\t\t\t\t\t\tjQuery.event.simulate( \"change\", this, event );\n\t\t\t\t\t\t} );\n\t\t\t\t\t}\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\t// Delegated event; lazy-add a change handler on descendant inputs\n\t\t\t\tjQuery.event.add( this, \"beforeactivate._change\", function( e ) {\n\t\t\t\t\tvar elem = e.target;\n\n\t\t\t\t\tif ( rformElems.test( elem.nodeName ) && !jQuery._data( elem, \"change\" ) ) {\n\t\t\t\t\t\tjQuery.event.add( elem, \"change._change\", function( event ) {\n\t\t\t\t\t\t\tif ( this.parentNode && !event.isSimulated && !event.isTrigger ) {\n\t\t\t\t\t\t\t\tjQuery.event.simulate( \"change\", this.parentNode, event );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} );\n\t\t\t\t\t\tjQuery._data( elem, \"change\", true );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t},\n\n\t\t\thandle: function( event ) {\n\t\t\t\tvar elem = event.target;\n\n\t\t\t\t// Swallow native change events from checkbox/radio, we already triggered them above\n\t\t\t\tif ( this !== elem || event.isSimulated || event.isTrigger ||\n\t\t\t\t\t( elem.type !== \"radio\" && elem.type !== \"checkbox\" ) ) {\n\n\t\t\t\t\treturn event.handleObj.handler.apply( this, arguments );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tteardown: function() {\n\t\t\t\tjQuery.event.remove( this, \"._change\" );\n\n\t\t\t\treturn !rformElems.test( this.nodeName );\n\t\t\t}\n\t\t};\n\t}\n\n// Support: Firefox\n// Firefox doesn't have focus(in | out) events\n// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787\n//\n// Support: Chrome, Safari\n// focus(in | out) events fire after focus & blur events,\n// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order\n// Related ticket - https://code.google.com/p/chromium/issues/detail?id=449857\n\tif ( !support.focusin ) {\n\t\tjQuery.each( { focus: \"focusin\", blur: \"focusout\" }, function( orig, fix ) {\n\n\t\t\t// Attach a single capturing handler on the document while someone wants focusin/focusout\n\t\t\tvar handler = function( event ) {\n\t\t\t\tjQuery.event.simulate( fix, event.target, jQuery.event.fix( event ) );\n\t\t\t};\n\n\t\t\tjQuery.event.special[ fix ] = {\n\t\t\t\tsetup: function() {\n\t\t\t\t\tvar doc = this.ownerDocument || this,\n\t\t\t\t\t\tattaches = jQuery._data( doc, fix );\n\n\t\t\t\t\tif ( !attaches ) {\n\t\t\t\t\t\tdoc.addEventListener( orig, handler, true );\n\t\t\t\t\t}\n\t\t\t\t\tjQuery._data( doc, fix, ( attaches || 0 ) + 1 );\n\t\t\t\t},\n\t\t\t\tteardown: function() {\n\t\t\t\t\tvar doc = this.ownerDocument || this,\n\t\t\t\t\t\tattaches = jQuery._data( doc, fix ) - 1;\n\n\t\t\t\t\tif ( !attaches ) {\n\t\t\t\t\t\tdoc.removeEventListener( orig, handler, true );\n\t\t\t\t\t\tjQuery._removeData( doc, fix );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tjQuery._data( doc, fix, attaches );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t} );\n\t}\n\n\tjQuery.fn.extend( {\n\n\t\ton: function( types, selector, data, fn ) {\n\t\t\treturn on( this, types, selector, data, fn );\n\t\t},\n\t\tone: function( types, selector, data, fn ) {\n\t\t\treturn on( this, types, selector, data, fn, 1 );\n\t\t},\n\t\toff: function( types, selector, fn ) {\n\t\t\tvar handleObj, type;\n\t\t\tif ( types && types.preventDefault && types.handleObj ) {\n\n\t\t\t\t// ( event )  dispatched jQuery.Event\n\t\t\t\thandleObj = types.handleObj;\n\t\t\t\tjQuery( types.delegateTarget ).off(\n\t\t\t\t\thandleObj.namespace ?\n\t\t\t\t\thandleObj.origType + \".\" + handleObj.namespace :\n\t\t\t\t\t\thandleObj.origType,\n\t\t\t\t\thandleObj.selector,\n\t\t\t\t\thandleObj.handler\n\t\t\t\t);\n\t\t\t\treturn this;\n\t\t\t}\n\t\t\tif ( typeof types === \"object\" ) {\n\n\t\t\t\t// ( types-object [, selector] )\n\t\t\t\tfor ( type in types ) {\n\t\t\t\t\tthis.off( type, selector, types[ type ] );\n\t\t\t\t}\n\t\t\t\treturn this;\n\t\t\t}\n\t\t\tif ( selector === false || typeof selector === \"function\" ) {\n\n\t\t\t\t// ( types [, fn] )\n\t\t\t\tfn = selector;\n\t\t\t\tselector = undefined;\n\t\t\t}\n\t\t\tif ( fn === false ) {\n\t\t\t\tfn = returnFalse;\n\t\t\t}\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.event.remove( this, types, fn, selector );\n\t\t\t} );\n\t\t},\n\n\t\ttrigger: function( type, data ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.event.trigger( type, data, this );\n\t\t\t} );\n\t\t},\n\t\ttriggerHandler: function( type, data ) {\n\t\t\tvar elem = this[ 0 ];\n\t\t\tif ( elem ) {\n\t\t\t\treturn jQuery.event.trigger( type, data, elem, true );\n\t\t\t}\n\t\t}\n\t} );\n\n\n\tvar rinlinejQuery = / jQuery\\d+=\"(?:null|\\d+)\"/g,\n\t\trnoshimcache = new RegExp( \"<(?:\" + nodeNames + \")[\\\\s/>]\", \"i\" ),\n\t\trxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\\w:-]+)[^>]*)\\/>/gi,\n\n\t\t// Support: IE 10-11, Edge 10240+\n\t\t// In IE/Edge using regex groups here causes severe slowdowns.\n\t\t// See https://connect.microsoft.com/IE/feedback/details/1736512/\n\t\trnoInnerhtml = /<script|<style|<link/i,\n\n\t\t// checked=\"checked\" or checked\n\t\trchecked = /checked\\s*(?:[^=]|=\\s*.checked.)/i,\n\t\trscriptTypeMasked = /^true\\/(.*)/,\n\t\trcleanScript = /^\\s*<!(?:\\[CDATA\\[|--)|(?:\\]\\]|--)>\\s*$/g,\n\t\tsafeFragment = createSafeFragment( document ),\n\t\tfragmentDiv = safeFragment.appendChild( document.createElement( \"div\" ) );\n\n// Support: IE<8\n// Manipulating tables requires a tbody\n\tfunction manipulationTarget( elem, content ) {\n\t\treturn jQuery.nodeName( elem, \"table\" ) &&\n\t\tjQuery.nodeName( content.nodeType !== 11 ? content : content.firstChild, \"tr\" ) ?\n\n\t\telem.getElementsByTagName( \"tbody\" )[ 0 ] ||\n\t\telem.appendChild( elem.ownerDocument.createElement( \"tbody\" ) ) :\n\t\t\telem;\n\t}\n\n// Replace/restore the type attribute of script elements for safe DOM manipulation\n\tfunction disableScript( elem ) {\n\t\telem.type = ( jQuery.find.attr( elem, \"type\" ) !== null ) + \"/\" + elem.type;\n\t\treturn elem;\n\t}\n\tfunction restoreScript( elem ) {\n\t\tvar match = rscriptTypeMasked.exec( elem.type );\n\t\tif ( match ) {\n\t\t\telem.type = match[ 1 ];\n\t\t} else {\n\t\t\telem.removeAttribute( \"type\" );\n\t\t}\n\t\treturn elem;\n\t}\n\n\tfunction cloneCopyEvent( src, dest ) {\n\t\tif ( dest.nodeType !== 1 || !jQuery.hasData( src ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar type, i, l,\n\t\t\toldData = jQuery._data( src ),\n\t\t\tcurData = jQuery._data( dest, oldData ),\n\t\t\tevents = oldData.events;\n\n\t\tif ( events ) {\n\t\t\tdelete curData.handle;\n\t\t\tcurData.events = {};\n\n\t\t\tfor ( type in events ) {\n\t\t\t\tfor ( i = 0, l = events[ type ].length; i < l; i++ ) {\n\t\t\t\t\tjQuery.event.add( dest, type, events[ type ][ i ] );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// make the cloned public data object a copy from the original\n\t\tif ( curData.data ) {\n\t\t\tcurData.data = jQuery.extend( {}, curData.data );\n\t\t}\n\t}\n\n\tfunction fixCloneNodeIssues( src, dest ) {\n\t\tvar nodeName, e, data;\n\n\t\t// We do not need to do anything for non-Elements\n\t\tif ( dest.nodeType !== 1 ) {\n\t\t\treturn;\n\t\t}\n\n\t\tnodeName = dest.nodeName.toLowerCase();\n\n\t\t// IE6-8 copies events bound via attachEvent when using cloneNode.\n\t\tif ( !support.noCloneEvent && dest[ jQuery.expando ] ) {\n\t\t\tdata = jQuery._data( dest );\n\n\t\t\tfor ( e in data.events ) {\n\t\t\t\tjQuery.removeEvent( dest, e, data.handle );\n\t\t\t}\n\n\t\t\t// Event data gets referenced instead of copied if the expando gets copied too\n\t\t\tdest.removeAttribute( jQuery.expando );\n\t\t}\n\n\t\t// IE blanks contents when cloning scripts, and tries to evaluate newly-set text\n\t\tif ( nodeName === \"script\" && dest.text !== src.text ) {\n\t\t\tdisableScript( dest ).text = src.text;\n\t\t\trestoreScript( dest );\n\n\t\t\t// IE6-10 improperly clones children of object elements using classid.\n\t\t\t// IE10 throws NoModificationAllowedError if parent is null, #12132.\n\t\t} else if ( nodeName === \"object\" ) {\n\t\t\tif ( dest.parentNode ) {\n\t\t\t\tdest.outerHTML = src.outerHTML;\n\t\t\t}\n\n\t\t\t// This path appears unavoidable for IE9. When cloning an object\n\t\t\t// element in IE9, the outerHTML strategy above is not sufficient.\n\t\t\t// If the src has innerHTML and the destination does not,\n\t\t\t// copy the src.innerHTML into the dest.innerHTML. #10324\n\t\t\tif ( support.html5Clone && ( src.innerHTML && !jQuery.trim( dest.innerHTML ) ) ) {\n\t\t\t\tdest.innerHTML = src.innerHTML;\n\t\t\t}\n\n\t\t} else if ( nodeName === \"input\" && rcheckableType.test( src.type ) ) {\n\n\t\t\t// IE6-8 fails to persist the checked state of a cloned checkbox\n\t\t\t// or radio button. Worse, IE6-7 fail to give the cloned element\n\t\t\t// a checked appearance if the defaultChecked value isn't also set\n\n\t\t\tdest.defaultChecked = dest.checked = src.checked;\n\n\t\t\t// IE6-7 get confused and end up setting the value of a cloned\n\t\t\t// checkbox/radio button to an empty string instead of \"on\"\n\t\t\tif ( dest.value !== src.value ) {\n\t\t\t\tdest.value = src.value;\n\t\t\t}\n\n\t\t\t// IE6-8 fails to return the selected option to the default selected\n\t\t\t// state when cloning options\n\t\t} else if ( nodeName === \"option\" ) {\n\t\t\tdest.defaultSelected = dest.selected = src.defaultSelected;\n\n\t\t\t// IE6-8 fails to set the defaultValue to the correct value when\n\t\t\t// cloning other types of input fields\n\t\t} else if ( nodeName === \"input\" || nodeName === \"textarea\" ) {\n\t\t\tdest.defaultValue = src.defaultValue;\n\t\t}\n\t}\n\n\tfunction domManip( collection, args, callback, ignored ) {\n\n\t\t// Flatten any nested arrays\n\t\targs = concat.apply( [], args );\n\n\t\tvar first, node, hasScripts,\n\t\t\tscripts, doc, fragment,\n\t\t\ti = 0,\n\t\t\tl = collection.length,\n\t\t\tiNoClone = l - 1,\n\t\t\tvalue = args[ 0 ],\n\t\t\tisFunction = jQuery.isFunction( value );\n\n\t\t// We can't cloneNode fragments that contain checked, in WebKit\n\t\tif ( isFunction ||\n\t\t\t( l > 1 && typeof value === \"string\" &&\n\t\t\t!support.checkClone && rchecked.test( value ) ) ) {\n\t\t\treturn collection.each( function( index ) {\n\t\t\t\tvar self = collection.eq( index );\n\t\t\t\tif ( isFunction ) {\n\t\t\t\t\targs[ 0 ] = value.call( this, index, self.html() );\n\t\t\t\t}\n\t\t\t\tdomManip( self, args, callback, ignored );\n\t\t\t} );\n\t\t}\n\n\t\tif ( l ) {\n\t\t\tfragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );\n\t\t\tfirst = fragment.firstChild;\n\n\t\t\tif ( fragment.childNodes.length === 1 ) {\n\t\t\t\tfragment = first;\n\t\t\t}\n\n\t\t\t// Require either new content or an interest in ignored elements to invoke the callback\n\t\t\tif ( first || ignored ) {\n\t\t\t\tscripts = jQuery.map( getAll( fragment, \"script\" ), disableScript );\n\t\t\t\thasScripts = scripts.length;\n\n\t\t\t\t// Use the original fragment for the last item\n\t\t\t\t// instead of the first because it can end up\n\t\t\t\t// being emptied incorrectly in certain situations (#8070).\n\t\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\t\tnode = fragment;\n\n\t\t\t\t\tif ( i !== iNoClone ) {\n\t\t\t\t\t\tnode = jQuery.clone( node, true, true );\n\n\t\t\t\t\t\t// Keep references to cloned scripts for later restoration\n\t\t\t\t\t\tif ( hasScripts ) {\n\n\t\t\t\t\t\t\t// Support: Android<4.1, PhantomJS<2\n\t\t\t\t\t\t\t// push.apply(_, arraylike) throws on ancient WebKit\n\t\t\t\t\t\t\tjQuery.merge( scripts, getAll( node, \"script\" ) );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tcallback.call( collection[ i ], node, i );\n\t\t\t\t}\n\n\t\t\t\tif ( hasScripts ) {\n\t\t\t\t\tdoc = scripts[ scripts.length - 1 ].ownerDocument;\n\n\t\t\t\t\t// Reenable scripts\n\t\t\t\t\tjQuery.map( scripts, restoreScript );\n\n\t\t\t\t\t// Evaluate executable scripts on first document insertion\n\t\t\t\t\tfor ( i = 0; i < hasScripts; i++ ) {\n\t\t\t\t\t\tnode = scripts[ i ];\n\t\t\t\t\t\tif ( rscriptType.test( node.type || \"\" ) &&\n\t\t\t\t\t\t\t!jQuery._data( node, \"globalEval\" ) &&\n\t\t\t\t\t\t\tjQuery.contains( doc, node ) ) {\n\n\t\t\t\t\t\t\tif ( node.src ) {\n\n\t\t\t\t\t\t\t\t// Optional AJAX dependency, but won't run scripts if not present\n\t\t\t\t\t\t\t\tif ( jQuery._evalUrl ) {\n\t\t\t\t\t\t\t\t\tjQuery._evalUrl( node.src );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tjQuery.globalEval(\n\t\t\t\t\t\t\t\t\t( node.text || node.textContent || node.innerHTML || \"\" )\n\t\t\t\t\t\t\t\t\t\t.replace( rcleanScript, \"\" )\n\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Fix #11809: Avoid leaking memory\n\t\t\t\tfragment = first = null;\n\t\t\t}\n\t\t}\n\n\t\treturn collection;\n\t}\n\n\tfunction remove( elem, selector, keepData ) {\n\t\tvar node,\n\t\t\telems = selector ? jQuery.filter( selector, elem ) : elem,\n\t\t\ti = 0;\n\n\t\tfor ( ; ( node = elems[ i ] ) != null; i++ ) {\n\n\t\t\tif ( !keepData && node.nodeType === 1 ) {\n\t\t\t\tjQuery.cleanData( getAll( node ) );\n\t\t\t}\n\n\t\t\tif ( node.parentNode ) {\n\t\t\t\tif ( keepData && jQuery.contains( node.ownerDocument, node ) ) {\n\t\t\t\t\tsetGlobalEval( getAll( node, \"script\" ) );\n\t\t\t\t}\n\t\t\t\tnode.parentNode.removeChild( node );\n\t\t\t}\n\t\t}\n\n\t\treturn elem;\n\t}\n\n\tjQuery.extend( {\n\t\thtmlPrefilter: function( html ) {\n\t\t\treturn html.replace( rxhtmlTag, \"<$1></$2>\" );\n\t\t},\n\n\t\tclone: function( elem, dataAndEvents, deepDataAndEvents ) {\n\t\t\tvar destElements, node, clone, i, srcElements,\n\t\t\t\tinPage = jQuery.contains( elem.ownerDocument, elem );\n\n\t\t\tif ( support.html5Clone || jQuery.isXMLDoc( elem ) ||\n\t\t\t\t!rnoshimcache.test( \"<\" + elem.nodeName + \">\" ) ) {\n\n\t\t\t\tclone = elem.cloneNode( true );\n\n\t\t\t\t// IE<=8 does not properly clone detached, unknown element nodes\n\t\t\t} else {\n\t\t\t\tfragmentDiv.innerHTML = elem.outerHTML;\n\t\t\t\tfragmentDiv.removeChild( clone = fragmentDiv.firstChild );\n\t\t\t}\n\n\t\t\tif ( ( !support.noCloneEvent || !support.noCloneChecked ) &&\n\t\t\t\t( elem.nodeType === 1 || elem.nodeType === 11 ) && !jQuery.isXMLDoc( elem ) ) {\n\n\t\t\t\t// We eschew Sizzle here for performance reasons: http://jsperf.com/getall-vs-sizzle/2\n\t\t\t\tdestElements = getAll( clone );\n\t\t\t\tsrcElements = getAll( elem );\n\n\t\t\t\t// Fix all IE cloning issues\n\t\t\t\tfor ( i = 0; ( node = srcElements[ i ] ) != null; ++i ) {\n\n\t\t\t\t\t// Ensure that the destination node is not null; Fixes #9587\n\t\t\t\t\tif ( destElements[ i ] ) {\n\t\t\t\t\t\tfixCloneNodeIssues( node, destElements[ i ] );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Copy the events from the original to the clone\n\t\t\tif ( dataAndEvents ) {\n\t\t\t\tif ( deepDataAndEvents ) {\n\t\t\t\t\tsrcElements = srcElements || getAll( elem );\n\t\t\t\t\tdestElements = destElements || getAll( clone );\n\n\t\t\t\t\tfor ( i = 0; ( node = srcElements[ i ] ) != null; i++ ) {\n\t\t\t\t\t\tcloneCopyEvent( node, destElements[ i ] );\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tcloneCopyEvent( elem, clone );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Preserve script evaluation history\n\t\t\tdestElements = getAll( clone, \"script\" );\n\t\t\tif ( destElements.length > 0 ) {\n\t\t\t\tsetGlobalEval( destElements, !inPage && getAll( elem, \"script\" ) );\n\t\t\t}\n\n\t\t\tdestElements = srcElements = node = null;\n\n\t\t\t// Return the cloned set\n\t\t\treturn clone;\n\t\t},\n\n\t\tcleanData: function( elems, /* internal */ forceAcceptData ) {\n\t\t\tvar elem, type, id, data,\n\t\t\t\ti = 0,\n\t\t\t\tinternalKey = jQuery.expando,\n\t\t\t\tcache = jQuery.cache,\n\t\t\t\tattributes = support.attributes,\n\t\t\t\tspecial = jQuery.event.special;\n\n\t\t\tfor ( ; ( elem = elems[ i ] ) != null; i++ ) {\n\t\t\t\tif ( forceAcceptData || acceptData( elem ) ) {\n\n\t\t\t\t\tid = elem[ internalKey ];\n\t\t\t\t\tdata = id && cache[ id ];\n\n\t\t\t\t\tif ( data ) {\n\t\t\t\t\t\tif ( data.events ) {\n\t\t\t\t\t\t\tfor ( type in data.events ) {\n\t\t\t\t\t\t\t\tif ( special[ type ] ) {\n\t\t\t\t\t\t\t\t\tjQuery.event.remove( elem, type );\n\n\t\t\t\t\t\t\t\t\t// This is a shortcut to avoid jQuery.event.remove's overhead\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tjQuery.removeEvent( elem, type, data.handle );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Remove cache only if it was not already removed by jQuery.event.remove\n\t\t\t\t\t\tif ( cache[ id ] ) {\n\n\t\t\t\t\t\t\tdelete cache[ id ];\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// IE does not allow us to delete expando properties from nodes\n\t\t\t\t\t\t\t// IE creates expando attributes along with the property\n\t\t\t\t\t\t\t// IE does not have a removeAttribute function on Document nodes\n\t\t\t\t\t\t\tif ( !attributes && typeof elem.removeAttribute !== \"undefined\" ) {\n\t\t\t\t\t\t\t\telem.removeAttribute( internalKey );\n\n\t\t\t\t\t\t\t\t// Webkit & Blink performance suffers when deleting properties\n\t\t\t\t\t\t\t\t// from DOM nodes, so set to undefined instead\n\t\t\t\t\t\t\t\t// https://code.google.com/p/chromium/issues/detail?id=378607\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\telem[ internalKey ] = undefined;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tdeletedIds.push( id );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\n\t\t// Keep domManip exposed until 3.0 (gh-2225)\n\t\tdomManip: domManip,\n\n\t\tdetach: function( selector ) {\n\t\t\treturn remove( this, selector, true );\n\t\t},\n\n\t\tremove: function( selector ) {\n\t\t\treturn remove( this, selector );\n\t\t},\n\n\t\ttext: function( value ) {\n\t\t\treturn access( this, function( value ) {\n\t\t\t\treturn value === undefined ?\n\t\t\t\t\tjQuery.text( this ) :\n\t\t\t\t\tthis.empty().append(\n\t\t\t\t\t\t( this[ 0 ] && this[ 0 ].ownerDocument || document ).createTextNode( value )\n\t\t\t\t\t);\n\t\t\t}, null, value, arguments.length );\n\t\t},\n\n\t\tappend: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n\t\t\t\t\tvar target = manipulationTarget( this, elem );\n\t\t\t\t\ttarget.appendChild( elem );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tprepend: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n\t\t\t\t\tvar target = manipulationTarget( this, elem );\n\t\t\t\t\ttarget.insertBefore( elem, target.firstChild );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tbefore: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.parentNode ) {\n\t\t\t\t\tthis.parentNode.insertBefore( elem, this );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tafter: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.parentNode ) {\n\t\t\t\t\tthis.parentNode.insertBefore( elem, this.nextSibling );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tempty: function() {\n\t\t\tvar elem,\n\t\t\t\ti = 0;\n\n\t\t\tfor ( ; ( elem = this[ i ] ) != null; i++ ) {\n\n\t\t\t\t// Remove element nodes and prevent memory leaks\n\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\tjQuery.cleanData( getAll( elem, false ) );\n\t\t\t\t}\n\n\t\t\t\t// Remove any remaining nodes\n\t\t\t\twhile ( elem.firstChild ) {\n\t\t\t\t\telem.removeChild( elem.firstChild );\n\t\t\t\t}\n\n\t\t\t\t// If this is a select, ensure that it displays empty (#12336)\n\t\t\t\t// Support: IE<9\n\t\t\t\tif ( elem.options && jQuery.nodeName( elem, \"select\" ) ) {\n\t\t\t\t\telem.options.length = 0;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\tclone: function( dataAndEvents, deepDataAndEvents ) {\n\t\t\tdataAndEvents = dataAndEvents == null ? false : dataAndEvents;\n\t\t\tdeepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;\n\n\t\t\treturn this.map( function() {\n\t\t\t\treturn jQuery.clone( this, dataAndEvents, deepDataAndEvents );\n\t\t\t} );\n\t\t},\n\n\t\thtml: function( value ) {\n\t\t\treturn access( this, function( value ) {\n\t\t\t\tvar elem = this[ 0 ] || {},\n\t\t\t\t\ti = 0,\n\t\t\t\t\tl = this.length;\n\n\t\t\t\tif ( value === undefined ) {\n\t\t\t\t\treturn elem.nodeType === 1 ?\n\t\t\t\t\t\telem.innerHTML.replace( rinlinejQuery, \"\" ) :\n\t\t\t\t\t\tundefined;\n\t\t\t\t}\n\n\t\t\t\t// See if we can take a shortcut and just use innerHTML\n\t\t\t\tif ( typeof value === \"string\" && !rnoInnerhtml.test( value ) &&\n\t\t\t\t\t( support.htmlSerialize || !rnoshimcache.test( value )  ) &&\n\t\t\t\t\t( support.leadingWhitespace || !rleadingWhitespace.test( value ) ) &&\n\t\t\t\t\t!wrapMap[ ( rtagName.exec( value ) || [ \"\", \"\" ] )[ 1 ].toLowerCase() ] ) {\n\n\t\t\t\t\tvalue = jQuery.htmlPrefilter( value );\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\tfor ( ; i < l; i++ ) {\n\n\t\t\t\t\t\t\t// Remove element nodes and prevent memory leaks\n\t\t\t\t\t\t\telem = this[ i ] || {};\n\t\t\t\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\t\t\t\tjQuery.cleanData( getAll( elem, false ) );\n\t\t\t\t\t\t\t\telem.innerHTML = value;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\telem = 0;\n\n\t\t\t\t\t\t// If using innerHTML throws an exception, use the fallback method\n\t\t\t\t\t} catch ( e ) {}\n\t\t\t\t}\n\n\t\t\t\tif ( elem ) {\n\t\t\t\t\tthis.empty().append( value );\n\t\t\t\t}\n\t\t\t}, null, value, arguments.length );\n\t\t},\n\n\t\treplaceWith: function() {\n\t\t\tvar ignored = [];\n\n\t\t\t// Make the changes, replacing each non-ignored context element with the new content\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tvar parent = this.parentNode;\n\n\t\t\t\tif ( jQuery.inArray( this, ignored ) < 0 ) {\n\t\t\t\t\tjQuery.cleanData( getAll( this ) );\n\t\t\t\t\tif ( parent ) {\n\t\t\t\t\t\tparent.replaceChild( elem, this );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Force callback invocation\n\t\t\t}, ignored );\n\t\t}\n\t} );\n\n\tjQuery.each( {\n\t\tappendTo: \"append\",\n\t\tprependTo: \"prepend\",\n\t\tinsertBefore: \"before\",\n\t\tinsertAfter: \"after\",\n\t\treplaceAll: \"replaceWith\"\n\t}, function( name, original ) {\n\t\tjQuery.fn[ name ] = function( selector ) {\n\t\t\tvar elems,\n\t\t\t\ti = 0,\n\t\t\t\tret = [],\n\t\t\t\tinsert = jQuery( selector ),\n\t\t\t\tlast = insert.length - 1;\n\n\t\t\tfor ( ; i <= last; i++ ) {\n\t\t\t\telems = i === last ? this : this.clone( true );\n\t\t\t\tjQuery( insert[ i ] )[ original ]( elems );\n\n\t\t\t\t// Modern browsers can apply jQuery collections as arrays, but oldIE needs a .get()\n\t\t\t\tpush.apply( ret, elems.get() );\n\t\t\t}\n\n\t\t\treturn this.pushStack( ret );\n\t\t};\n\t} );\n\n\n\tvar iframe,\n\t\telemdisplay = {\n\n\t\t\t// Support: Firefox\n\t\t\t// We have to pre-define these values for FF (#10227)\n\t\t\tHTML: \"block\",\n\t\t\tBODY: \"block\"\n\t\t};\n\n\t/**\n\t * Retrieve the actual display of a element\n\t * @param {String} name nodeName of the element\n\t * @param {Object} doc Document object\n\t */\n\n// Called only from within defaultDisplay\n\tfunction actualDisplay( name, doc ) {\n\t\tvar elem = jQuery( doc.createElement( name ) ).appendTo( doc.body ),\n\n\t\t\tdisplay = jQuery.css( elem[ 0 ], \"display\" );\n\n\t\t// We don't have any data stored on the element,\n\t\t// so use \"detach\" method as fast way to get rid of the element\n\t\telem.detach();\n\n\t\treturn display;\n\t}\n\n\t/**\n\t * Try to determine the default display value of an element\n\t * @param {String} nodeName\n\t */\n\tfunction defaultDisplay( nodeName ) {\n\t\tvar doc = document,\n\t\t\tdisplay = elemdisplay[ nodeName ];\n\n\t\tif ( !display ) {\n\t\t\tdisplay = actualDisplay( nodeName, doc );\n\n\t\t\t// If the simple way fails, read from inside an iframe\n\t\t\tif ( display === \"none\" || !display ) {\n\n\t\t\t\t// Use the already-created iframe if possible\n\t\t\t\tiframe = ( iframe || jQuery( \"<iframe frameborder='0' width='0' height='0'/>\" ) )\n\t\t\t\t\t.appendTo( doc.documentElement );\n\n\t\t\t\t// Always write a new HTML skeleton so Webkit and Firefox don't choke on reuse\n\t\t\t\tdoc = ( iframe[ 0 ].contentWindow || iframe[ 0 ].contentDocument ).document;\n\n\t\t\t\t// Support: IE\n\t\t\t\tdoc.write();\n\t\t\t\tdoc.close();\n\n\t\t\t\tdisplay = actualDisplay( nodeName, doc );\n\t\t\t\tiframe.detach();\n\t\t\t}\n\n\t\t\t// Store the correct default display\n\t\t\telemdisplay[ nodeName ] = display;\n\t\t}\n\n\t\treturn display;\n\t}\n\tvar rmargin = ( /^margin/ );\n\n\tvar rnumnonpx = new RegExp( \"^(\" + pnum + \")(?!px)[a-z%]+$\", \"i\" );\n\n\tvar swap = function( elem, options, callback, args ) {\n\t\tvar ret, name,\n\t\t\told = {};\n\n\t\t// Remember the old values, and insert the new ones\n\t\tfor ( name in options ) {\n\t\t\told[ name ] = elem.style[ name ];\n\t\t\telem.style[ name ] = options[ name ];\n\t\t}\n\n\t\tret = callback.apply( elem, args || [] );\n\n\t\t// Revert the old values\n\t\tfor ( name in options ) {\n\t\t\telem.style[ name ] = old[ name ];\n\t\t}\n\n\t\treturn ret;\n\t};\n\n\n\tvar documentElement = document.documentElement;\n\n\n\n\t( function() {\n\t\tvar pixelPositionVal, pixelMarginRightVal, boxSizingReliableVal,\n\t\t\treliableHiddenOffsetsVal, reliableMarginRightVal, reliableMarginLeftVal,\n\t\t\tcontainer = document.createElement( \"div\" ),\n\t\t\tdiv = document.createElement( \"div\" );\n\n\t\t// Finish early in limited (non-browser) environments\n\t\tif ( !div.style ) {\n\t\t\treturn;\n\t\t}\n\n\t\tdiv.style.cssText = \"float:left;opacity:.5\";\n\n\t\t// Support: IE<9\n\t\t// Make sure that element opacity exists (as opposed to filter)\n\t\tsupport.opacity = div.style.opacity === \"0.5\";\n\n\t\t// Verify style float existence\n\t\t// (IE uses styleFloat instead of cssFloat)\n\t\tsupport.cssFloat = !!div.style.cssFloat;\n\n\t\tdiv.style.backgroundClip = \"content-box\";\n\t\tdiv.cloneNode( true ).style.backgroundClip = \"\";\n\t\tsupport.clearCloneStyle = div.style.backgroundClip === \"content-box\";\n\n\t\tcontainer = document.createElement( \"div\" );\n\t\tcontainer.style.cssText = \"border:0;width:8px;height:0;top:0;left:-9999px;\" +\n\t\t\t\"padding:0;margin-top:1px;position:absolute\";\n\t\tdiv.innerHTML = \"\";\n\t\tcontainer.appendChild( div );\n\n\t\t// Support: Firefox<29, Android 2.3\n\t\t// Vendor-prefix box-sizing\n\t\tsupport.boxSizing = div.style.boxSizing === \"\" || div.style.MozBoxSizing === \"\" ||\n\t\t\tdiv.style.WebkitBoxSizing === \"\";\n\n\t\tjQuery.extend( support, {\n\t\t\treliableHiddenOffsets: function() {\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn reliableHiddenOffsetsVal;\n\t\t\t},\n\n\t\t\tboxSizingReliable: function() {\n\n\t\t\t\t// We're checking for pixelPositionVal here instead of boxSizingReliableVal\n\t\t\t\t// since that compresses better and they're computed together anyway.\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn boxSizingReliableVal;\n\t\t\t},\n\n\t\t\tpixelMarginRight: function() {\n\n\t\t\t\t// Support: Android 4.0-4.3\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn pixelMarginRightVal;\n\t\t\t},\n\n\t\t\tpixelPosition: function() {\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn pixelPositionVal;\n\t\t\t},\n\n\t\t\treliableMarginRight: function() {\n\n\t\t\t\t// Support: Android 2.3\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn reliableMarginRightVal;\n\t\t\t},\n\n\t\t\treliableMarginLeft: function() {\n\n\t\t\t\t// Support: IE <=8 only, Android 4.0 - 4.3 only, Firefox <=3 - 37\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn reliableMarginLeftVal;\n\t\t\t}\n\t\t} );\n\n\t\tfunction computeStyleTests() {\n\t\t\tvar contents, divStyle,\n\t\t\t\tdocumentElement = document.documentElement;\n\n\t\t\t// Setup\n\t\t\tdocumentElement.appendChild( container );\n\n\t\t\tdiv.style.cssText =\n\n\t\t\t\t// Support: Android 2.3\n\t\t\t\t// Vendor-prefix box-sizing\n\t\t\t\t\"-webkit-box-sizing:border-box;box-sizing:border-box;\" +\n\t\t\t\t\"position:relative;display:block;\" +\n\t\t\t\t\"margin:auto;border:1px;padding:1px;\" +\n\t\t\t\t\"top:1%;width:50%\";\n\n\t\t\t// Support: IE<9\n\t\t\t// Assume reasonable values in the absence of getComputedStyle\n\t\t\tpixelPositionVal = boxSizingReliableVal = reliableMarginLeftVal = false;\n\t\t\tpixelMarginRightVal = reliableMarginRightVal = true;\n\n\t\t\t// Check for getComputedStyle so that this code is not run in IE<9.\n\t\t\tif ( window.getComputedStyle ) {\n\t\t\t\tdivStyle = window.getComputedStyle( div );\n\t\t\t\tpixelPositionVal = ( divStyle || {} ).top !== \"1%\";\n\t\t\t\treliableMarginLeftVal = ( divStyle || {} ).marginLeft === \"2px\";\n\t\t\t\tboxSizingReliableVal = ( divStyle || { width: \"4px\" } ).width === \"4px\";\n\n\t\t\t\t// Support: Android 4.0 - 4.3 only\n\t\t\t\t// Some styles come back with percentage values, even though they shouldn't\n\t\t\t\tdiv.style.marginRight = \"50%\";\n\t\t\t\tpixelMarginRightVal = ( divStyle || { marginRight: \"4px\" } ).marginRight === \"4px\";\n\n\t\t\t\t// Support: Android 2.3 only\n\t\t\t\t// Div with explicit width and no margin-right incorrectly\n\t\t\t\t// gets computed margin-right based on width of container (#3333)\n\t\t\t\t// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right\n\t\t\t\tcontents = div.appendChild( document.createElement( \"div\" ) );\n\n\t\t\t\t// Reset CSS: box-sizing; display; margin; border; padding\n\t\t\t\tcontents.style.cssText = div.style.cssText =\n\n\t\t\t\t\t// Support: Android 2.3\n\t\t\t\t\t// Vendor-prefix box-sizing\n\t\t\t\t\t\"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;\" +\n\t\t\t\t\t\"box-sizing:content-box;display:block;margin:0;border:0;padding:0\";\n\t\t\t\tcontents.style.marginRight = contents.style.width = \"0\";\n\t\t\t\tdiv.style.width = \"1px\";\n\n\t\t\t\treliableMarginRightVal =\n\t\t\t\t\t!parseFloat( ( window.getComputedStyle( contents ) || {} ).marginRight );\n\n\t\t\t\tdiv.removeChild( contents );\n\t\t\t}\n\n\t\t\t// Support: IE6-8\n\t\t\t// First check that getClientRects works as expected\n\t\t\t// Check if table cells still have offsetWidth/Height when they are set\n\t\t\t// to display:none and there are still other visible table cells in a\n\t\t\t// table row; if so, offsetWidth/Height are not reliable for use when\n\t\t\t// determining if an element has been hidden directly using\n\t\t\t// display:none (it is still safe to use offsets if a parent element is\n\t\t\t// hidden; don safety goggles and see bug #4512 for more information).\n\t\t\tdiv.style.display = \"none\";\n\t\t\treliableHiddenOffsetsVal = div.getClientRects().length === 0;\n\t\t\tif ( reliableHiddenOffsetsVal ) {\n\t\t\t\tdiv.style.display = \"\";\n\t\t\t\tdiv.innerHTML = \"<table><tr><td></td><td>t</td></tr></table>\";\n\t\t\t\tdiv.childNodes[ 0 ].style.borderCollapse = \"separate\";\n\t\t\t\tcontents = div.getElementsByTagName( \"td\" );\n\t\t\t\tcontents[ 0 ].style.cssText = \"margin:0;border:0;padding:0;display:none\";\n\t\t\t\treliableHiddenOffsetsVal = contents[ 0 ].offsetHeight === 0;\n\t\t\t\tif ( reliableHiddenOffsetsVal ) {\n\t\t\t\t\tcontents[ 0 ].style.display = \"\";\n\t\t\t\t\tcontents[ 1 ].style.display = \"none\";\n\t\t\t\t\treliableHiddenOffsetsVal = contents[ 0 ].offsetHeight === 0;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Teardown\n\t\t\tdocumentElement.removeChild( container );\n\t\t}\n\n\t} )();\n\n\n\tvar getStyles, curCSS,\n\t\trposition = /^(top|right|bottom|left)$/;\n\n\tif ( window.getComputedStyle ) {\n\t\tgetStyles = function( elem ) {\n\n\t\t\t// Support: IE<=11+, Firefox<=30+ (#15098, #14150)\n\t\t\t// IE throws on elements created in popups\n\t\t\t// FF meanwhile throws on frame elements through \"defaultView.getComputedStyle\"\n\t\t\tvar view = elem.ownerDocument.defaultView;\n\n\t\t\tif ( !view || !view.opener ) {\n\t\t\t\tview = window;\n\t\t\t}\n\n\t\t\treturn view.getComputedStyle( elem );\n\t\t};\n\n\t\tcurCSS = function( elem, name, computed ) {\n\t\t\tvar width, minWidth, maxWidth, ret,\n\t\t\t\tstyle = elem.style;\n\n\t\t\tcomputed = computed || getStyles( elem );\n\n\t\t\t// getPropertyValue is only needed for .css('filter') in IE9, see #12537\n\t\t\tret = computed ? computed.getPropertyValue( name ) || computed[ name ] : undefined;\n\n\t\t\t// Support: Opera 12.1x only\n\t\t\t// Fall back to style even without computed\n\t\t\t// computed is undefined for elems on document fragments\n\t\t\tif ( ( ret === \"\" || ret === undefined ) && !jQuery.contains( elem.ownerDocument, elem ) ) {\n\t\t\t\tret = jQuery.style( elem, name );\n\t\t\t}\n\n\t\t\tif ( computed ) {\n\n\t\t\t\t// A tribute to the \"awesome hack by Dean Edwards\"\n\t\t\t\t// Chrome < 17 and Safari 5.0 uses \"computed value\"\n\t\t\t\t// instead of \"used value\" for margin-right\n\t\t\t\t// Safari 5.1.7 (at least) returns percentage for a larger set of values,\n\t\t\t\t// but width seems to be reliably pixels\n\t\t\t\t// this is against the CSSOM draft spec:\n\t\t\t\t// http://dev.w3.org/csswg/cssom/#resolved-values\n\t\t\t\tif ( !support.pixelMarginRight() && rnumnonpx.test( ret ) && rmargin.test( name ) ) {\n\n\t\t\t\t\t// Remember the original values\n\t\t\t\t\twidth = style.width;\n\t\t\t\t\tminWidth = style.minWidth;\n\t\t\t\t\tmaxWidth = style.maxWidth;\n\n\t\t\t\t\t// Put in the new values to get a computed value out\n\t\t\t\t\tstyle.minWidth = style.maxWidth = style.width = ret;\n\t\t\t\t\tret = computed.width;\n\n\t\t\t\t\t// Revert the changed values\n\t\t\t\t\tstyle.width = width;\n\t\t\t\t\tstyle.minWidth = minWidth;\n\t\t\t\t\tstyle.maxWidth = maxWidth;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Support: IE\n\t\t\t// IE returns zIndex value as an integer.\n\t\t\treturn ret === undefined ?\n\t\t\t\tret :\n\t\t\tret + \"\";\n\t\t};\n\t} else if ( documentElement.currentStyle ) {\n\t\tgetStyles = function( elem ) {\n\t\t\treturn elem.currentStyle;\n\t\t};\n\n\t\tcurCSS = function( elem, name, computed ) {\n\t\t\tvar left, rs, rsLeft, ret,\n\t\t\t\tstyle = elem.style;\n\n\t\t\tcomputed = computed || getStyles( elem );\n\t\t\tret = computed ? computed[ name ] : undefined;\n\n\t\t\t// Avoid setting ret to empty string here\n\t\t\t// so we don't default to auto\n\t\t\tif ( ret == null && style && style[ name ] ) {\n\t\t\t\tret = style[ name ];\n\t\t\t}\n\n\t\t\t// From the awesome hack by Dean Edwards\n\t\t\t// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291\n\n\t\t\t// If we're not dealing with a regular pixel number\n\t\t\t// but a number that has a weird ending, we need to convert it to pixels\n\t\t\t// but not position css attributes, as those are\n\t\t\t// proportional to the parent element instead\n\t\t\t// and we can't measure the parent instead because it\n\t\t\t// might trigger a \"stacking dolls\" problem\n\t\t\tif ( rnumnonpx.test( ret ) && !rposition.test( name ) ) {\n\n\t\t\t\t// Remember the original values\n\t\t\t\tleft = style.left;\n\t\t\t\trs = elem.runtimeStyle;\n\t\t\t\trsLeft = rs && rs.left;\n\n\t\t\t\t// Put in the new values to get a computed value out\n\t\t\t\tif ( rsLeft ) {\n\t\t\t\t\trs.left = elem.currentStyle.left;\n\t\t\t\t}\n\t\t\t\tstyle.left = name === \"fontSize\" ? \"1em\" : ret;\n\t\t\t\tret = style.pixelLeft + \"px\";\n\n\t\t\t\t// Revert the changed values\n\t\t\t\tstyle.left = left;\n\t\t\t\tif ( rsLeft ) {\n\t\t\t\t\trs.left = rsLeft;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Support: IE\n\t\t\t// IE returns zIndex value as an integer.\n\t\t\treturn ret === undefined ?\n\t\t\t\tret :\n\t\t\tret + \"\" || \"auto\";\n\t\t};\n\t}\n\n\n\n\n\tfunction addGetHookIf( conditionFn, hookFn ) {\n\n\t\t// Define the hook, we'll check on the first run if it's really needed.\n\t\treturn {\n\t\t\tget: function() {\n\t\t\t\tif ( conditionFn() ) {\n\n\t\t\t\t\t// Hook not needed (or it's not possible to use it due\n\t\t\t\t\t// to missing dependency), remove it.\n\t\t\t\t\tdelete this.get;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Hook needed; redefine it so that the support test is not executed again.\n\t\t\t\treturn ( this.get = hookFn ).apply( this, arguments );\n\t\t\t}\n\t\t};\n\t}\n\n\n\tvar\n\n\t\tralpha = /alpha\\([^)]*\\)/i,\n\t\tropacity = /opacity\\s*=\\s*([^)]*)/i,\n\n\t\t// swappable if display is none or starts with table except\n\t\t// \"table\", \"table-cell\", or \"table-caption\"\n\t\t// see here for display values:\n\t\t// https://developer.mozilla.org/en-US/docs/CSS/display\n\t\trdisplayswap = /^(none|table(?!-c[ea]).+)/,\n\t\trnumsplit = new RegExp( \"^(\" + pnum + \")(.*)$\", \"i\" ),\n\n\t\tcssShow = { position: \"absolute\", visibility: \"hidden\", display: \"block\" },\n\t\tcssNormalTransform = {\n\t\t\tletterSpacing: \"0\",\n\t\t\tfontWeight: \"400\"\n\t\t},\n\n\t\tcssPrefixes = [ \"Webkit\", \"O\", \"Moz\", \"ms\" ],\n\t\temptyStyle = document.createElement( \"div\" ).style;\n\n\n// return a css property mapped to a potentially vendor prefixed property\n\tfunction vendorPropName( name ) {\n\n\t\t// shortcut for names that are not vendor prefixed\n\t\tif ( name in emptyStyle ) {\n\t\t\treturn name;\n\t\t}\n\n\t\t// check for vendor prefixed names\n\t\tvar capName = name.charAt( 0 ).toUpperCase() + name.slice( 1 ),\n\t\t\ti = cssPrefixes.length;\n\n\t\twhile ( i-- ) {\n\t\t\tname = cssPrefixes[ i ] + capName;\n\t\t\tif ( name in emptyStyle ) {\n\t\t\t\treturn name;\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction showHide( elements, show ) {\n\t\tvar display, elem, hidden,\n\t\t\tvalues = [],\n\t\t\tindex = 0,\n\t\t\tlength = elements.length;\n\n\t\tfor ( ; index < length; index++ ) {\n\t\t\telem = elements[ index ];\n\t\t\tif ( !elem.style ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tvalues[ index ] = jQuery._data( elem, \"olddisplay\" );\n\t\t\tdisplay = elem.style.display;\n\t\t\tif ( show ) {\n\n\t\t\t\t// Reset the inline display of this element to learn if it is\n\t\t\t\t// being hidden by cascaded rules or not\n\t\t\t\tif ( !values[ index ] && display === \"none\" ) {\n\t\t\t\t\telem.style.display = \"\";\n\t\t\t\t}\n\n\t\t\t\t// Set elements which have been overridden with display: none\n\t\t\t\t// in a stylesheet to whatever the default browser style is\n\t\t\t\t// for such an element\n\t\t\t\tif ( elem.style.display === \"\" && isHidden( elem ) ) {\n\t\t\t\t\tvalues[ index ] =\n\t\t\t\t\t\tjQuery._data( elem, \"olddisplay\", defaultDisplay( elem.nodeName ) );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\thidden = isHidden( elem );\n\n\t\t\t\tif ( display && display !== \"none\" || !hidden ) {\n\t\t\t\t\tjQuery._data(\n\t\t\t\t\t\telem,\n\t\t\t\t\t\t\"olddisplay\",\n\t\t\t\t\t\thidden ? display : jQuery.css( elem, \"display\" )\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Set the display of most of the elements in a second loop\n\t\t// to avoid the constant reflow\n\t\tfor ( index = 0; index < length; index++ ) {\n\t\t\telem = elements[ index ];\n\t\t\tif ( !elem.style ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\t\t\tif ( !show || elem.style.display === \"none\" || elem.style.display === \"\" ) {\n\t\t\t\telem.style.display = show ? values[ index ] || \"\" : \"none\";\n\t\t\t}\n\t\t}\n\n\t\treturn elements;\n\t}\n\n\tfunction setPositiveNumber( elem, value, subtract ) {\n\t\tvar matches = rnumsplit.exec( value );\n\t\treturn matches ?\n\n\t\t\t// Guard against undefined \"subtract\", e.g., when used as in cssHooks\n\t\tMath.max( 0, matches[ 1 ] - ( subtract || 0 ) ) + ( matches[ 2 ] || \"px\" ) :\n\t\t\tvalue;\n\t}\n\n\tfunction augmentWidthOrHeight( elem, name, extra, isBorderBox, styles ) {\n\t\tvar i = extra === ( isBorderBox ? \"border\" : \"content\" ) ?\n\n\t\t\t\t// If we already have the right measurement, avoid augmentation\n\t\t\t\t4 :\n\n\t\t\t\t// Otherwise initialize for horizontal or vertical properties\n\t\t\t\tname === \"width\" ? 1 : 0,\n\n\t\t\tval = 0;\n\n\t\tfor ( ; i < 4; i += 2 ) {\n\n\t\t\t// both box models exclude margin, so add it if we want it\n\t\t\tif ( extra === \"margin\" ) {\n\t\t\t\tval += jQuery.css( elem, extra + cssExpand[ i ], true, styles );\n\t\t\t}\n\n\t\t\tif ( isBorderBox ) {\n\n\t\t\t\t// border-box includes padding, so remove it if we want content\n\t\t\t\tif ( extra === \"content\" ) {\n\t\t\t\t\tval -= jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n\t\t\t\t}\n\n\t\t\t\t// at this point, extra isn't border nor margin, so remove border\n\t\t\t\tif ( extra !== \"margin\" ) {\n\t\t\t\t\tval -= jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n\t\t\t\t}\n\t\t\t} else {\n\n\t\t\t\t// at this point, extra isn't content, so add padding\n\t\t\t\tval += jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n\n\t\t\t\t// at this point, extra isn't content nor padding, so add border\n\t\t\t\tif ( extra !== \"padding\" ) {\n\t\t\t\t\tval += jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn val;\n\t}\n\n\tfunction getWidthOrHeight( elem, name, extra ) {\n\n\t\t// Start with offset property, which is equivalent to the border-box value\n\t\tvar valueIsBorderBox = true,\n\t\t\tval = name === \"width\" ? elem.offsetWidth : elem.offsetHeight,\n\t\t\tstyles = getStyles( elem ),\n\t\t\tisBorderBox = support.boxSizing &&\n\t\t\t\tjQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\";\n\n\t\t// some non-html elements return undefined for offsetWidth, so check for null/undefined\n\t\t// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285\n\t\t// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668\n\t\tif ( val <= 0 || val == null ) {\n\n\t\t\t// Fall back to computed then uncomputed css if necessary\n\t\t\tval = curCSS( elem, name, styles );\n\t\t\tif ( val < 0 || val == null ) {\n\t\t\t\tval = elem.style[ name ];\n\t\t\t}\n\n\t\t\t// Computed unit is not pixels. Stop here and return.\n\t\t\tif ( rnumnonpx.test( val ) ) {\n\t\t\t\treturn val;\n\t\t\t}\n\n\t\t\t// we need the check for style in case a browser which returns unreliable values\n\t\t\t// for getComputedStyle silently falls back to the reliable elem.style\n\t\t\tvalueIsBorderBox = isBorderBox &&\n\t\t\t\t( support.boxSizingReliable() || val === elem.style[ name ] );\n\n\t\t\t// Normalize \"\", auto, and prepare for extra\n\t\t\tval = parseFloat( val ) || 0;\n\t\t}\n\n\t\t// use the active box-sizing model to add/subtract irrelevant styles\n\t\treturn ( val +\n\t\t\t\taugmentWidthOrHeight(\n\t\t\t\t\telem,\n\t\t\t\t\tname,\n\t\t\t\t\textra || ( isBorderBox ? \"border\" : \"content\" ),\n\t\t\t\t\tvalueIsBorderBox,\n\t\t\t\t\tstyles\n\t\t\t\t)\n\t\t\t) + \"px\";\n\t}\n\n\tjQuery.extend( {\n\n\t\t// Add in style property hooks for overriding the default\n\t\t// behavior of getting and setting a style property\n\t\tcssHooks: {\n\t\t\topacity: {\n\t\t\t\tget: function( elem, computed ) {\n\t\t\t\t\tif ( computed ) {\n\n\t\t\t\t\t\t// We should always get a number back from opacity\n\t\t\t\t\t\tvar ret = curCSS( elem, \"opacity\" );\n\t\t\t\t\t\treturn ret === \"\" ? \"1\" : ret;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t// Don't automatically add \"px\" to these possibly-unitless properties\n\t\tcssNumber: {\n\t\t\t\"animationIterationCount\": true,\n\t\t\t\"columnCount\": true,\n\t\t\t\"fillOpacity\": true,\n\t\t\t\"flexGrow\": true,\n\t\t\t\"flexShrink\": true,\n\t\t\t\"fontWeight\": true,\n\t\t\t\"lineHeight\": true,\n\t\t\t\"opacity\": true,\n\t\t\t\"order\": true,\n\t\t\t\"orphans\": true,\n\t\t\t\"widows\": true,\n\t\t\t\"zIndex\": true,\n\t\t\t\"zoom\": true\n\t\t},\n\n\t\t// Add in properties whose names you wish to fix before\n\t\t// setting or getting the value\n\t\tcssProps: {\n\n\t\t\t// normalize float css property\n\t\t\t\"float\": support.cssFloat ? \"cssFloat\" : \"styleFloat\"\n\t\t},\n\n\t\t// Get and set the style property on a DOM Node\n\t\tstyle: function( elem, name, value, extra ) {\n\n\t\t\t// Don't set styles on text and comment nodes\n\t\t\tif ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Make sure that we're working with the right name\n\t\t\tvar ret, type, hooks,\n\t\t\t\torigName = jQuery.camelCase( name ),\n\t\t\t\tstyle = elem.style;\n\n\t\t\tname = jQuery.cssProps[ origName ] ||\n\t\t\t\t( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );\n\n\t\t\t// gets hook for the prefixed version\n\t\t\t// followed by the unprefixed version\n\t\t\thooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n\t\t\t// Check if we're setting a value\n\t\t\tif ( value !== undefined ) {\n\t\t\t\ttype = typeof value;\n\n\t\t\t\t// Convert \"+=\" or \"-=\" to relative numbers (#7345)\n\t\t\t\tif ( type === \"string\" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {\n\t\t\t\t\tvalue = adjustCSS( elem, name, ret );\n\n\t\t\t\t\t// Fixes bug #9237\n\t\t\t\t\ttype = \"number\";\n\t\t\t\t}\n\n\t\t\t\t// Make sure that null and NaN values aren't set. See: #7116\n\t\t\t\tif ( value == null || value !== value ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// If a number was passed in, add the unit (except for certain CSS properties)\n\t\t\t\tif ( type === \"number\" ) {\n\t\t\t\t\tvalue += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? \"\" : \"px\" );\n\t\t\t\t}\n\n\t\t\t\t// Fixes #8908, it can be done more correctly by specifing setters in cssHooks,\n\t\t\t\t// but it would mean to define eight\n\t\t\t\t// (for every problematic property) identical functions\n\t\t\t\tif ( !support.clearCloneStyle && value === \"\" && name.indexOf( \"background\" ) === 0 ) {\n\t\t\t\t\tstyle[ name ] = \"inherit\";\n\t\t\t\t}\n\n\t\t\t\t// If a hook was provided, use that value, otherwise just set the specified value\n\t\t\t\tif ( !hooks || !( \"set\" in hooks ) ||\n\t\t\t\t\t( value = hooks.set( elem, value, extra ) ) !== undefined ) {\n\n\t\t\t\t\t// Support: IE\n\t\t\t\t\t// Swallow errors from 'invalid' CSS values (#5509)\n\t\t\t\t\ttry {\n\t\t\t\t\t\tstyle[ name ] = value;\n\t\t\t\t\t} catch ( e ) {}\n\t\t\t\t}\n\n\t\t\t} else {\n\n\t\t\t\t// If a hook was provided get the non-computed value from there\n\t\t\t\tif ( hooks && \"get\" in hooks &&\n\t\t\t\t\t( ret = hooks.get( elem, false, extra ) ) !== undefined ) {\n\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\n\t\t\t\t// Otherwise just get the value from the style object\n\t\t\t\treturn style[ name ];\n\t\t\t}\n\t\t},\n\n\t\tcss: function( elem, name, extra, styles ) {\n\t\t\tvar num, val, hooks,\n\t\t\t\torigName = jQuery.camelCase( name );\n\n\t\t\t// Make sure that we're working with the right name\n\t\t\tname = jQuery.cssProps[ origName ] ||\n\t\t\t\t( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );\n\n\t\t\t// gets hook for the prefixed version\n\t\t\t// followed by the unprefixed version\n\t\t\thooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n\t\t\t// If a hook was provided get the computed value from there\n\t\t\tif ( hooks && \"get\" in hooks ) {\n\t\t\t\tval = hooks.get( elem, true, extra );\n\t\t\t}\n\n\t\t\t// Otherwise, if a way to get the computed value exists, use that\n\t\t\tif ( val === undefined ) {\n\t\t\t\tval = curCSS( elem, name, styles );\n\t\t\t}\n\n\t\t\t//convert \"normal\" to computed value\n\t\t\tif ( val === \"normal\" && name in cssNormalTransform ) {\n\t\t\t\tval = cssNormalTransform[ name ];\n\t\t\t}\n\n\t\t\t// Return, converting to number if forced or a qualifier was provided and val looks numeric\n\t\t\tif ( extra === \"\" || extra ) {\n\t\t\t\tnum = parseFloat( val );\n\t\t\t\treturn extra === true || isFinite( num ) ? num || 0 : val;\n\t\t\t}\n\t\t\treturn val;\n\t\t}\n\t} );\n\n\tjQuery.each( [ \"height\", \"width\" ], function( i, name ) {\n\t\tjQuery.cssHooks[ name ] = {\n\t\t\tget: function( elem, computed, extra ) {\n\t\t\t\tif ( computed ) {\n\n\t\t\t\t\t// certain elements can have dimension info if we invisibly show them\n\t\t\t\t\t// however, it must have a current display style that would benefit from this\n\t\t\t\t\treturn rdisplayswap.test( jQuery.css( elem, \"display\" ) ) &&\n\t\t\t\t\telem.offsetWidth === 0 ?\n\t\t\t\t\t\tswap( elem, cssShow, function() {\n\t\t\t\t\t\t\treturn getWidthOrHeight( elem, name, extra );\n\t\t\t\t\t\t} ) :\n\t\t\t\t\t\tgetWidthOrHeight( elem, name, extra );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tset: function( elem, value, extra ) {\n\t\t\t\tvar styles = extra && getStyles( elem );\n\t\t\t\treturn setPositiveNumber( elem, value, extra ?\n\t\t\t\t\taugmentWidthOrHeight(\n\t\t\t\t\t\telem,\n\t\t\t\t\t\tname,\n\t\t\t\t\t\textra,\n\t\t\t\t\t\tsupport.boxSizing &&\n\t\t\t\t\t\tjQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\",\n\t\t\t\t\t\tstyles\n\t\t\t\t\t) : 0\n\t\t\t\t);\n\t\t\t}\n\t\t};\n\t} );\n\n\tif ( !support.opacity ) {\n\t\tjQuery.cssHooks.opacity = {\n\t\t\tget: function( elem, computed ) {\n\n\t\t\t\t// IE uses filters for opacity\n\t\t\t\treturn ropacity.test( ( computed && elem.currentStyle ?\n\t\t\t\t\t\telem.currentStyle.filter :\n\t\t\t\t\t\telem.style.filter ) || \"\" ) ?\n\t\t\t\t( 0.01 * parseFloat( RegExp.$1 ) ) + \"\" :\n\t\t\t\t\tcomputed ? \"1\" : \"\";\n\t\t\t},\n\n\t\t\tset: function( elem, value ) {\n\t\t\t\tvar style = elem.style,\n\t\t\t\t\tcurrentStyle = elem.currentStyle,\n\t\t\t\t\topacity = jQuery.isNumeric( value ) ? \"alpha(opacity=\" + value * 100 + \")\" : \"\",\n\t\t\t\t\tfilter = currentStyle && currentStyle.filter || style.filter || \"\";\n\n\t\t\t\t// IE has trouble with opacity if it does not have layout\n\t\t\t\t// Force it by setting the zoom level\n\t\t\t\tstyle.zoom = 1;\n\n\t\t\t\t// if setting opacity to 1, and no other filters exist -\n\t\t\t\t// attempt to remove filter attribute #6652\n\t\t\t\t// if value === \"\", then remove inline opacity #12685\n\t\t\t\tif ( ( value >= 1 || value === \"\" ) &&\n\t\t\t\t\tjQuery.trim( filter.replace( ralpha, \"\" ) ) === \"\" &&\n\t\t\t\t\tstyle.removeAttribute ) {\n\n\t\t\t\t\t// Setting style.filter to null, \"\" & \" \" still leave \"filter:\" in the cssText\n\t\t\t\t\t// if \"filter:\" is present at all, clearType is disabled, we want to avoid this\n\t\t\t\t\t// style.removeAttribute is IE Only, but so apparently is this code path...\n\t\t\t\t\tstyle.removeAttribute( \"filter\" );\n\n\t\t\t\t\t// if there is no filter style applied in a css rule\n\t\t\t\t\t// or unset inline opacity, we are done\n\t\t\t\t\tif ( value === \"\" || currentStyle && !currentStyle.filter ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// otherwise, set new filter values\n\t\t\t\tstyle.filter = ralpha.test( filter ) ?\n\t\t\t\t\tfilter.replace( ralpha, opacity ) :\n\t\t\t\tfilter + \" \" + opacity;\n\t\t\t}\n\t\t};\n\t}\n\n\tjQuery.cssHooks.marginRight = addGetHookIf( support.reliableMarginRight,\n\t\tfunction( elem, computed ) {\n\t\t\tif ( computed ) {\n\t\t\t\treturn swap( elem, { \"display\": \"inline-block\" },\n\t\t\t\t\tcurCSS, [ elem, \"marginRight\" ] );\n\t\t\t}\n\t\t}\n\t);\n\n\tjQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,\n\t\tfunction( elem, computed ) {\n\t\t\tif ( computed ) {\n\t\t\t\treturn (\n\t\t\t\t\t\tparseFloat( curCSS( elem, \"marginLeft\" ) ) ||\n\n\t\t\t\t\t\t// Support: IE<=11+\n\t\t\t\t\t\t// Running getBoundingClientRect on a disconnected node in IE throws an error\n\t\t\t\t\t\t// Support: IE8 only\n\t\t\t\t\t\t// getClientRects() errors on disconnected elems\n\t\t\t\t\t\t( jQuery.contains( elem.ownerDocument, elem ) ?\n\t\t\t\t\t\t\telem.getBoundingClientRect().left -\n\t\t\t\t\t\t\tswap( elem, { marginLeft: 0 }, function() {\n\t\t\t\t\t\t\t\treturn elem.getBoundingClientRect().left;\n\t\t\t\t\t\t\t} ) :\n\t\t\t\t\t\t\t\t0\n\t\t\t\t\t\t)\n\t\t\t\t\t) + \"px\";\n\t\t\t}\n\t\t}\n\t);\n\n// These hooks are used by animate to expand properties\n\tjQuery.each( {\n\t\tmargin: \"\",\n\t\tpadding: \"\",\n\t\tborder: \"Width\"\n\t}, function( prefix, suffix ) {\n\t\tjQuery.cssHooks[ prefix + suffix ] = {\n\t\t\texpand: function( value ) {\n\t\t\t\tvar i = 0,\n\t\t\t\t\texpanded = {},\n\n\t\t\t\t\t// assumes a single number if not a string\n\t\t\t\t\tparts = typeof value === \"string\" ? value.split( \" \" ) : [ value ];\n\n\t\t\t\tfor ( ; i < 4; i++ ) {\n\t\t\t\t\texpanded[ prefix + cssExpand[ i ] + suffix ] =\n\t\t\t\t\t\tparts[ i ] || parts[ i - 2 ] || parts[ 0 ];\n\t\t\t\t}\n\n\t\t\t\treturn expanded;\n\t\t\t}\n\t\t};\n\n\t\tif ( !rmargin.test( prefix ) ) {\n\t\t\tjQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\t\tcss: function( name, value ) {\n\t\t\treturn access( this, function( elem, name, value ) {\n\t\t\t\tvar styles, len,\n\t\t\t\t\tmap = {},\n\t\t\t\t\ti = 0;\n\n\t\t\t\tif ( jQuery.isArray( name ) ) {\n\t\t\t\t\tstyles = getStyles( elem );\n\t\t\t\t\tlen = name.length;\n\n\t\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\t\tmap[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );\n\t\t\t\t\t}\n\n\t\t\t\t\treturn map;\n\t\t\t\t}\n\n\t\t\t\treturn value !== undefined ?\n\t\t\t\t\tjQuery.style( elem, name, value ) :\n\t\t\t\t\tjQuery.css( elem, name );\n\t\t\t}, name, value, arguments.length > 1 );\n\t\t},\n\t\tshow: function() {\n\t\t\treturn showHide( this, true );\n\t\t},\n\t\thide: function() {\n\t\t\treturn showHide( this );\n\t\t},\n\t\ttoggle: function( state ) {\n\t\t\tif ( typeof state === \"boolean\" ) {\n\t\t\t\treturn state ? this.show() : this.hide();\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tif ( isHidden( this ) ) {\n\t\t\t\t\tjQuery( this ).show();\n\t\t\t\t} else {\n\t\t\t\t\tjQuery( this ).hide();\n\t\t\t\t}\n\t\t\t} );\n\t\t}\n\t} );\n\n\n\tfunction Tween( elem, options, prop, end, easing ) {\n\t\treturn new Tween.prototype.init( elem, options, prop, end, easing );\n\t}\n\tjQuery.Tween = Tween;\n\n\tTween.prototype = {\n\t\tconstructor: Tween,\n\t\tinit: function( elem, options, prop, end, easing, unit ) {\n\t\t\tthis.elem = elem;\n\t\t\tthis.prop = prop;\n\t\t\tthis.easing = easing || jQuery.easing._default;\n\t\t\tthis.options = options;\n\t\t\tthis.start = this.now = this.cur();\n\t\t\tthis.end = end;\n\t\t\tthis.unit = unit || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" );\n\t\t},\n\t\tcur: function() {\n\t\t\tvar hooks = Tween.propHooks[ this.prop ];\n\n\t\t\treturn hooks && hooks.get ?\n\t\t\t\thooks.get( this ) :\n\t\t\t\tTween.propHooks._default.get( this );\n\t\t},\n\t\trun: function( percent ) {\n\t\t\tvar eased,\n\t\t\t\thooks = Tween.propHooks[ this.prop ];\n\n\t\t\tif ( this.options.duration ) {\n\t\t\t\tthis.pos = eased = jQuery.easing[ this.easing ](\n\t\t\t\t\tpercent, this.options.duration * percent, 0, 1, this.options.duration\n\t\t\t\t);\n\t\t\t} else {\n\t\t\t\tthis.pos = eased = percent;\n\t\t\t}\n\t\t\tthis.now = ( this.end - this.start ) * eased + this.start;\n\n\t\t\tif ( this.options.step ) {\n\t\t\t\tthis.options.step.call( this.elem, this.now, this );\n\t\t\t}\n\n\t\t\tif ( hooks && hooks.set ) {\n\t\t\t\thooks.set( this );\n\t\t\t} else {\n\t\t\t\tTween.propHooks._default.set( this );\n\t\t\t}\n\t\t\treturn this;\n\t\t}\n\t};\n\n\tTween.prototype.init.prototype = Tween.prototype;\n\n\tTween.propHooks = {\n\t\t_default: {\n\t\t\tget: function( tween ) {\n\t\t\t\tvar result;\n\n\t\t\t\t// Use a property on the element directly when it is not a DOM element,\n\t\t\t\t// or when there is no matching style property that exists.\n\t\t\t\tif ( tween.elem.nodeType !== 1 ||\n\t\t\t\t\ttween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {\n\t\t\t\t\treturn tween.elem[ tween.prop ];\n\t\t\t\t}\n\n\t\t\t\t// passing an empty string as a 3rd parameter to .css will automatically\n\t\t\t\t// attempt a parseFloat and fallback to a string if the parse fails\n\t\t\t\t// so, simple values such as \"10px\" are parsed to Float.\n\t\t\t\t// complex values such as \"rotate(1rad)\" are returned as is.\n\t\t\t\tresult = jQuery.css( tween.elem, tween.prop, \"\" );\n\n\t\t\t\t// Empty strings, null, undefined and \"auto\" are converted to 0.\n\t\t\t\treturn !result || result === \"auto\" ? 0 : result;\n\t\t\t},\n\t\t\tset: function( tween ) {\n\n\t\t\t\t// use step hook for back compat - use cssHook if its there - use .style if its\n\t\t\t\t// available and use plain properties where available\n\t\t\t\tif ( jQuery.fx.step[ tween.prop ] ) {\n\t\t\t\t\tjQuery.fx.step[ tween.prop ]( tween );\n\t\t\t\t} else if ( tween.elem.nodeType === 1 &&\n\t\t\t\t\t( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null ||\n\t\t\t\t\tjQuery.cssHooks[ tween.prop ] ) ) {\n\t\t\t\t\tjQuery.style( tween.elem, tween.prop, tween.now + tween.unit );\n\t\t\t\t} else {\n\t\t\t\t\ttween.elem[ tween.prop ] = tween.now;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n\n// Support: IE <=9\n// Panic based approach to setting things on disconnected nodes\n\n\tTween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {\n\t\tset: function( tween ) {\n\t\t\tif ( tween.elem.nodeType && tween.elem.parentNode ) {\n\t\t\t\ttween.elem[ tween.prop ] = tween.now;\n\t\t\t}\n\t\t}\n\t};\n\n\tjQuery.easing = {\n\t\tlinear: function( p ) {\n\t\t\treturn p;\n\t\t},\n\t\tswing: function( p ) {\n\t\t\treturn 0.5 - Math.cos( p * Math.PI ) / 2;\n\t\t},\n\t\t_default: \"swing\"\n\t};\n\n\tjQuery.fx = Tween.prototype.init;\n\n// Back Compat <1.8 extension point\n\tjQuery.fx.step = {};\n\n\n\n\n\tvar\n\t\tfxNow, timerId,\n\t\trfxtypes = /^(?:toggle|show|hide)$/,\n\t\trrun = /queueHooks$/;\n\n// Animations created synchronously will run synchronously\n\tfunction createFxNow() {\n\t\twindow.setTimeout( function() {\n\t\t\tfxNow = undefined;\n\t\t} );\n\t\treturn ( fxNow = jQuery.now() );\n\t}\n\n// Generate parameters to create a standard animation\n\tfunction genFx( type, includeWidth ) {\n\t\tvar which,\n\t\t\tattrs = { height: type },\n\t\t\ti = 0;\n\n\t\t// if we include width, step value is 1 to do all cssExpand values,\n\t\t// if we don't include width, step value is 2 to skip over Left and Right\n\t\tincludeWidth = includeWidth ? 1 : 0;\n\t\tfor ( ; i < 4 ; i += 2 - includeWidth ) {\n\t\t\twhich = cssExpand[ i ];\n\t\t\tattrs[ \"margin\" + which ] = attrs[ \"padding\" + which ] = type;\n\t\t}\n\n\t\tif ( includeWidth ) {\n\t\t\tattrs.opacity = attrs.width = type;\n\t\t}\n\n\t\treturn attrs;\n\t}\n\n\tfunction createTween( value, prop, animation ) {\n\t\tvar tween,\n\t\t\tcollection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ \"*\" ] ),\n\t\t\tindex = 0,\n\t\t\tlength = collection.length;\n\t\tfor ( ; index < length; index++ ) {\n\t\t\tif ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {\n\n\t\t\t\t// we're done with this property\n\t\t\t\treturn tween;\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction defaultPrefilter( elem, props, opts ) {\n\t\t/* jshint validthis: true */\n\t\tvar prop, value, toggle, tween, hooks, oldfire, display, checkDisplay,\n\t\t\tanim = this,\n\t\t\torig = {},\n\t\t\tstyle = elem.style,\n\t\t\thidden = elem.nodeType && isHidden( elem ),\n\t\t\tdataShow = jQuery._data( elem, \"fxshow\" );\n\n\t\t// handle queue: false promises\n\t\tif ( !opts.queue ) {\n\t\t\thooks = jQuery._queueHooks( elem, \"fx\" );\n\t\t\tif ( hooks.unqueued == null ) {\n\t\t\t\thooks.unqueued = 0;\n\t\t\t\toldfire = hooks.empty.fire;\n\t\t\t\thooks.empty.fire = function() {\n\t\t\t\t\tif ( !hooks.unqueued ) {\n\t\t\t\t\t\toldfire();\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\t\t\thooks.unqueued++;\n\n\t\t\tanim.always( function() {\n\n\t\t\t\t// doing this makes sure that the complete handler will be called\n\t\t\t\t// before this completes\n\t\t\t\tanim.always( function() {\n\t\t\t\t\thooks.unqueued--;\n\t\t\t\t\tif ( !jQuery.queue( elem, \"fx\" ).length ) {\n\t\t\t\t\t\thooks.empty.fire();\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t} );\n\t\t}\n\n\t\t// height/width overflow pass\n\t\tif ( elem.nodeType === 1 && ( \"height\" in props || \"width\" in props ) ) {\n\n\t\t\t// Make sure that nothing sneaks out\n\t\t\t// Record all 3 overflow attributes because IE does not\n\t\t\t// change the overflow attribute when overflowX and\n\t\t\t// overflowY are set to the same value\n\t\t\topts.overflow = [ style.overflow, style.overflowX, style.overflowY ];\n\n\t\t\t// Set display property to inline-block for height/width\n\t\t\t// animations on inline elements that are having width/height animated\n\t\t\tdisplay = jQuery.css( elem, \"display\" );\n\n\t\t\t// Test default display if display is currently \"none\"\n\t\t\tcheckDisplay = display === \"none\" ?\n\t\t\tjQuery._data( elem, \"olddisplay\" ) || defaultDisplay( elem.nodeName ) : display;\n\n\t\t\tif ( checkDisplay === \"inline\" && jQuery.css( elem, \"float\" ) === \"none\" ) {\n\n\t\t\t\t// inline-level elements accept inline-block;\n\t\t\t\t// block-level elements need to be inline with layout\n\t\t\t\tif ( !support.inlineBlockNeedsLayout || defaultDisplay( elem.nodeName ) === \"inline\" ) {\n\t\t\t\t\tstyle.display = \"inline-block\";\n\t\t\t\t} else {\n\t\t\t\t\tstyle.zoom = 1;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif ( opts.overflow ) {\n\t\t\tstyle.overflow = \"hidden\";\n\t\t\tif ( !support.shrinkWrapBlocks() ) {\n\t\t\t\tanim.always( function() {\n\t\t\t\t\tstyle.overflow = opts.overflow[ 0 ];\n\t\t\t\t\tstyle.overflowX = opts.overflow[ 1 ];\n\t\t\t\t\tstyle.overflowY = opts.overflow[ 2 ];\n\t\t\t\t} );\n\t\t\t}\n\t\t}\n\n\t\t// show/hide pass\n\t\tfor ( prop in props ) {\n\t\t\tvalue = props[ prop ];\n\t\t\tif ( rfxtypes.exec( value ) ) {\n\t\t\t\tdelete props[ prop ];\n\t\t\t\ttoggle = toggle || value === \"toggle\";\n\t\t\t\tif ( value === ( hidden ? \"hide\" : \"show\" ) ) {\n\n\t\t\t\t\t// If there is dataShow left over from a stopped hide or show\n\t\t\t\t\t// and we are going to proceed with show, we should pretend to be hidden\n\t\t\t\t\tif ( value === \"show\" && dataShow && dataShow[ prop ] !== undefined ) {\n\t\t\t\t\t\thidden = true;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\torig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );\n\n\t\t\t\t// Any non-fx value stops us from restoring the original display value\n\t\t\t} else {\n\t\t\t\tdisplay = undefined;\n\t\t\t}\n\t\t}\n\n\t\tif ( !jQuery.isEmptyObject( orig ) ) {\n\t\t\tif ( dataShow ) {\n\t\t\t\tif ( \"hidden\" in dataShow ) {\n\t\t\t\t\thidden = dataShow.hidden;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tdataShow = jQuery._data( elem, \"fxshow\", {} );\n\t\t\t}\n\n\t\t\t// store state if its toggle - enables .stop().toggle() to \"reverse\"\n\t\t\tif ( toggle ) {\n\t\t\t\tdataShow.hidden = !hidden;\n\t\t\t}\n\t\t\tif ( hidden ) {\n\t\t\t\tjQuery( elem ).show();\n\t\t\t} else {\n\t\t\t\tanim.done( function() {\n\t\t\t\t\tjQuery( elem ).hide();\n\t\t\t\t} );\n\t\t\t}\n\t\t\tanim.done( function() {\n\t\t\t\tvar prop;\n\t\t\t\tjQuery._removeData( elem, \"fxshow\" );\n\t\t\t\tfor ( prop in orig ) {\n\t\t\t\t\tjQuery.style( elem, prop, orig[ prop ] );\n\t\t\t\t}\n\t\t\t} );\n\t\t\tfor ( prop in orig ) {\n\t\t\t\ttween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );\n\n\t\t\t\tif ( !( prop in dataShow ) ) {\n\t\t\t\t\tdataShow[ prop ] = tween.start;\n\t\t\t\t\tif ( hidden ) {\n\t\t\t\t\t\ttween.end = tween.start;\n\t\t\t\t\t\ttween.start = prop === \"width\" || prop === \"height\" ? 1 : 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// If this is a noop like .hide().hide(), restore an overwritten display value\n\t\t} else if ( ( display === \"none\" ? defaultDisplay( elem.nodeName ) : display ) === \"inline\" ) {\n\t\t\tstyle.display = display;\n\t\t}\n\t}\n\n\tfunction propFilter( props, specialEasing ) {\n\t\tvar index, name, easing, value, hooks;\n\n\t\t// camelCase, specialEasing and expand cssHook pass\n\t\tfor ( index in props ) {\n\t\t\tname = jQuery.camelCase( index );\n\t\t\teasing = specialEasing[ name ];\n\t\t\tvalue = props[ index ];\n\t\t\tif ( jQuery.isArray( value ) ) {\n\t\t\t\teasing = value[ 1 ];\n\t\t\t\tvalue = props[ index ] = value[ 0 ];\n\t\t\t}\n\n\t\t\tif ( index !== name ) {\n\t\t\t\tprops[ name ] = value;\n\t\t\t\tdelete props[ index ];\n\t\t\t}\n\n\t\t\thooks = jQuery.cssHooks[ name ];\n\t\t\tif ( hooks && \"expand\" in hooks ) {\n\t\t\t\tvalue = hooks.expand( value );\n\t\t\t\tdelete props[ name ];\n\n\t\t\t\t// not quite $.extend, this wont overwrite keys already present.\n\t\t\t\t// also - reusing 'index' from above because we have the correct \"name\"\n\t\t\t\tfor ( index in value ) {\n\t\t\t\t\tif ( !( index in props ) ) {\n\t\t\t\t\t\tprops[ index ] = value[ index ];\n\t\t\t\t\t\tspecialEasing[ index ] = easing;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tspecialEasing[ name ] = easing;\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction Animation( elem, properties, options ) {\n\t\tvar result,\n\t\t\tstopped,\n\t\t\tindex = 0,\n\t\t\tlength = Animation.prefilters.length,\n\t\t\tdeferred = jQuery.Deferred().always( function() {\n\n\t\t\t\t// don't match elem in the :animated selector\n\t\t\t\tdelete tick.elem;\n\t\t\t} ),\n\t\t\ttick = function() {\n\t\t\t\tif ( stopped ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tvar currentTime = fxNow || createFxNow(),\n\t\t\t\t\tremaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),\n\n\t\t\t\t\t// Support: Android 2.3\n\t\t\t\t\t// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)\n\t\t\t\t\ttemp = remaining / animation.duration || 0,\n\t\t\t\t\tpercent = 1 - temp,\n\t\t\t\t\tindex = 0,\n\t\t\t\t\tlength = animation.tweens.length;\n\n\t\t\t\tfor ( ; index < length ; index++ ) {\n\t\t\t\t\tanimation.tweens[ index ].run( percent );\n\t\t\t\t}\n\n\t\t\t\tdeferred.notifyWith( elem, [ animation, percent, remaining ] );\n\n\t\t\t\tif ( percent < 1 && length ) {\n\t\t\t\t\treturn remaining;\n\t\t\t\t} else {\n\t\t\t\t\tdeferred.resolveWith( elem, [ animation ] );\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t},\n\t\t\tanimation = deferred.promise( {\n\t\t\t\telem: elem,\n\t\t\t\tprops: jQuery.extend( {}, properties ),\n\t\t\t\topts: jQuery.extend( true, {\n\t\t\t\t\tspecialEasing: {},\n\t\t\t\t\teasing: jQuery.easing._default\n\t\t\t\t}, options ),\n\t\t\t\toriginalProperties: properties,\n\t\t\t\toriginalOptions: options,\n\t\t\t\tstartTime: fxNow || createFxNow(),\n\t\t\t\tduration: options.duration,\n\t\t\t\ttweens: [],\n\t\t\t\tcreateTween: function( prop, end ) {\n\t\t\t\t\tvar tween = jQuery.Tween( elem, animation.opts, prop, end,\n\t\t\t\t\t\tanimation.opts.specialEasing[ prop ] || animation.opts.easing );\n\t\t\t\t\tanimation.tweens.push( tween );\n\t\t\t\t\treturn tween;\n\t\t\t\t},\n\t\t\t\tstop: function( gotoEnd ) {\n\t\t\t\t\tvar index = 0,\n\n\t\t\t\t\t\t// if we are going to the end, we want to run all the tweens\n\t\t\t\t\t\t// otherwise we skip this part\n\t\t\t\t\t\tlength = gotoEnd ? animation.tweens.length : 0;\n\t\t\t\t\tif ( stopped ) {\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t}\n\t\t\t\t\tstopped = true;\n\t\t\t\t\tfor ( ; index < length ; index++ ) {\n\t\t\t\t\t\tanimation.tweens[ index ].run( 1 );\n\t\t\t\t\t}\n\n\t\t\t\t\t// resolve when we played the last frame\n\t\t\t\t\t// otherwise, reject\n\t\t\t\t\tif ( gotoEnd ) {\n\t\t\t\t\t\tdeferred.notifyWith( elem, [ animation, 1, 0 ] );\n\t\t\t\t\t\tdeferred.resolveWith( elem, [ animation, gotoEnd ] );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tdeferred.rejectWith( elem, [ animation, gotoEnd ] );\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t} ),\n\t\t\tprops = animation.props;\n\n\t\tpropFilter( props, animation.opts.specialEasing );\n\n\t\tfor ( ; index < length ; index++ ) {\n\t\t\tresult = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );\n\t\t\tif ( result ) {\n\t\t\t\tif ( jQuery.isFunction( result.stop ) ) {\n\t\t\t\t\tjQuery._queueHooks( animation.elem, animation.opts.queue ).stop =\n\t\t\t\t\t\tjQuery.proxy( result.stop, result );\n\t\t\t\t}\n\t\t\t\treturn result;\n\t\t\t}\n\t\t}\n\n\t\tjQuery.map( props, createTween, animation );\n\n\t\tif ( jQuery.isFunction( animation.opts.start ) ) {\n\t\t\tanimation.opts.start.call( elem, animation );\n\t\t}\n\n\t\tjQuery.fx.timer(\n\t\t\tjQuery.extend( tick, {\n\t\t\t\telem: elem,\n\t\t\t\tanim: animation,\n\t\t\t\tqueue: animation.opts.queue\n\t\t\t} )\n\t\t);\n\n\t\t// attach callbacks from options\n\t\treturn animation.progress( animation.opts.progress )\n\t\t\t.done( animation.opts.done, animation.opts.complete )\n\t\t\t.fail( animation.opts.fail )\n\t\t\t.always( animation.opts.always );\n\t}\n\n\tjQuery.Animation = jQuery.extend( Animation, {\n\n\t\ttweeners: {\n\t\t\t\"*\": [ function( prop, value ) {\n\t\t\t\tvar tween = this.createTween( prop, value );\n\t\t\t\tadjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );\n\t\t\t\treturn tween;\n\t\t\t} ]\n\t\t},\n\n\t\ttweener: function( props, callback ) {\n\t\t\tif ( jQuery.isFunction( props ) ) {\n\t\t\t\tcallback = props;\n\t\t\t\tprops = [ \"*\" ];\n\t\t\t} else {\n\t\t\t\tprops = props.match( rnotwhite );\n\t\t\t}\n\n\t\t\tvar prop,\n\t\t\t\tindex = 0,\n\t\t\t\tlength = props.length;\n\n\t\t\tfor ( ; index < length ; index++ ) {\n\t\t\t\tprop = props[ index ];\n\t\t\t\tAnimation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];\n\t\t\t\tAnimation.tweeners[ prop ].unshift( callback );\n\t\t\t}\n\t\t},\n\n\t\tprefilters: [ defaultPrefilter ],\n\n\t\tprefilter: function( callback, prepend ) {\n\t\t\tif ( prepend ) {\n\t\t\t\tAnimation.prefilters.unshift( callback );\n\t\t\t} else {\n\t\t\t\tAnimation.prefilters.push( callback );\n\t\t\t}\n\t\t}\n\t} );\n\n\tjQuery.speed = function( speed, easing, fn ) {\n\t\tvar opt = speed && typeof speed === \"object\" ? jQuery.extend( {}, speed ) : {\n\t\t\tcomplete: fn || !fn && easing ||\n\t\t\tjQuery.isFunction( speed ) && speed,\n\t\t\tduration: speed,\n\t\t\teasing: fn && easing || easing && !jQuery.isFunction( easing ) && easing\n\t\t};\n\n\t\topt.duration = jQuery.fx.off ? 0 : typeof opt.duration === \"number\" ? opt.duration :\n\t\t\topt.duration in jQuery.fx.speeds ?\n\t\t\t\tjQuery.fx.speeds[ opt.duration ] : jQuery.fx.speeds._default;\n\n\t\t// normalize opt.queue - true/undefined/null -> \"fx\"\n\t\tif ( opt.queue == null || opt.queue === true ) {\n\t\t\topt.queue = \"fx\";\n\t\t}\n\n\t\t// Queueing\n\t\topt.old = opt.complete;\n\n\t\topt.complete = function() {\n\t\t\tif ( jQuery.isFunction( opt.old ) ) {\n\t\t\t\topt.old.call( this );\n\t\t\t}\n\n\t\t\tif ( opt.queue ) {\n\t\t\t\tjQuery.dequeue( this, opt.queue );\n\t\t\t}\n\t\t};\n\n\t\treturn opt;\n\t};\n\n\tjQuery.fn.extend( {\n\t\tfadeTo: function( speed, to, easing, callback ) {\n\n\t\t\t// show any hidden elements after setting opacity to 0\n\t\t\treturn this.filter( isHidden ).css( \"opacity\", 0 ).show()\n\n\t\t\t// animate to the value specified\n\t\t\t\t.end().animate( { opacity: to }, speed, easing, callback );\n\t\t},\n\t\tanimate: function( prop, speed, easing, callback ) {\n\t\t\tvar empty = jQuery.isEmptyObject( prop ),\n\t\t\t\toptall = jQuery.speed( speed, easing, callback ),\n\t\t\t\tdoAnimation = function() {\n\n\t\t\t\t\t// Operate on a copy of prop so per-property easing won't be lost\n\t\t\t\t\tvar anim = Animation( this, jQuery.extend( {}, prop ), optall );\n\n\t\t\t\t\t// Empty animations, or finishing resolves immediately\n\t\t\t\t\tif ( empty || jQuery._data( this, \"finish\" ) ) {\n\t\t\t\t\t\tanim.stop( true );\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\tdoAnimation.finish = doAnimation;\n\n\t\t\treturn empty || optall.queue === false ?\n\t\t\t\tthis.each( doAnimation ) :\n\t\t\t\tthis.queue( optall.queue, doAnimation );\n\t\t},\n\t\tstop: function( type, clearQueue, gotoEnd ) {\n\t\t\tvar stopQueue = function( hooks ) {\n\t\t\t\tvar stop = hooks.stop;\n\t\t\t\tdelete hooks.stop;\n\t\t\t\tstop( gotoEnd );\n\t\t\t};\n\n\t\t\tif ( typeof type !== \"string\" ) {\n\t\t\t\tgotoEnd = clearQueue;\n\t\t\t\tclearQueue = type;\n\t\t\t\ttype = undefined;\n\t\t\t}\n\t\t\tif ( clearQueue && type !== false ) {\n\t\t\t\tthis.queue( type || \"fx\", [] );\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tvar dequeue = true,\n\t\t\t\t\tindex = type != null && type + \"queueHooks\",\n\t\t\t\t\ttimers = jQuery.timers,\n\t\t\t\t\tdata = jQuery._data( this );\n\n\t\t\t\tif ( index ) {\n\t\t\t\t\tif ( data[ index ] && data[ index ].stop ) {\n\t\t\t\t\t\tstopQueue( data[ index ] );\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tfor ( index in data ) {\n\t\t\t\t\t\tif ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {\n\t\t\t\t\t\t\tstopQueue( data[ index ] );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor ( index = timers.length; index--; ) {\n\t\t\t\t\tif ( timers[ index ].elem === this &&\n\t\t\t\t\t\t( type == null || timers[ index ].queue === type ) ) {\n\n\t\t\t\t\t\ttimers[ index ].anim.stop( gotoEnd );\n\t\t\t\t\t\tdequeue = false;\n\t\t\t\t\t\ttimers.splice( index, 1 );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// start the next in the queue if the last step wasn't forced\n\t\t\t\t// timers currently will call their complete callbacks, which will dequeue\n\t\t\t\t// but only if they were gotoEnd\n\t\t\t\tif ( dequeue || !gotoEnd ) {\n\t\t\t\t\tjQuery.dequeue( this, type );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\t\tfinish: function( type ) {\n\t\t\tif ( type !== false ) {\n\t\t\t\ttype = type || \"fx\";\n\t\t\t}\n\t\t\treturn this.each( function() {\n\t\t\t\tvar index,\n\t\t\t\t\tdata = jQuery._data( this ),\n\t\t\t\t\tqueue = data[ type + \"queue\" ],\n\t\t\t\t\thooks = data[ type + \"queueHooks\" ],\n\t\t\t\t\ttimers = jQuery.timers,\n\t\t\t\t\tlength = queue ? queue.length : 0;\n\n\t\t\t\t// enable finishing flag on private data\n\t\t\t\tdata.finish = true;\n\n\t\t\t\t// empty the queue first\n\t\t\t\tjQuery.queue( this, type, [] );\n\n\t\t\t\tif ( hooks && hooks.stop ) {\n\t\t\t\t\thooks.stop.call( this, true );\n\t\t\t\t}\n\n\t\t\t\t// look for any active animations, and finish them\n\t\t\t\tfor ( index = timers.length; index--; ) {\n\t\t\t\t\tif ( timers[ index ].elem === this && timers[ index ].queue === type ) {\n\t\t\t\t\t\ttimers[ index ].anim.stop( true );\n\t\t\t\t\t\ttimers.splice( index, 1 );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// look for any animations in the old queue and finish them\n\t\t\t\tfor ( index = 0; index < length; index++ ) {\n\t\t\t\t\tif ( queue[ index ] && queue[ index ].finish ) {\n\t\t\t\t\t\tqueue[ index ].finish.call( this );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// turn off finishing flag\n\t\t\t\tdelete data.finish;\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.each( [ \"toggle\", \"show\", \"hide\" ], function( i, name ) {\n\t\tvar cssFn = jQuery.fn[ name ];\n\t\tjQuery.fn[ name ] = function( speed, easing, callback ) {\n\t\t\treturn speed == null || typeof speed === \"boolean\" ?\n\t\t\t\tcssFn.apply( this, arguments ) :\n\t\t\t\tthis.animate( genFx( name, true ), speed, easing, callback );\n\t\t};\n\t} );\n\n// Generate shortcuts for custom animations\n\tjQuery.each( {\n\t\tslideDown: genFx( \"show\" ),\n\t\tslideUp: genFx( \"hide\" ),\n\t\tslideToggle: genFx( \"toggle\" ),\n\t\tfadeIn: { opacity: \"show\" },\n\t\tfadeOut: { opacity: \"hide\" },\n\t\tfadeToggle: { opacity: \"toggle\" }\n\t}, function( name, props ) {\n\t\tjQuery.fn[ name ] = function( speed, easing, callback ) {\n\t\t\treturn this.animate( props, speed, easing, callback );\n\t\t};\n\t} );\n\n\tjQuery.timers = [];\n\tjQuery.fx.tick = function() {\n\t\tvar timer,\n\t\t\ttimers = jQuery.timers,\n\t\t\ti = 0;\n\n\t\tfxNow = jQuery.now();\n\n\t\tfor ( ; i < timers.length; i++ ) {\n\t\t\ttimer = timers[ i ];\n\n\t\t\t// Checks the timer has not already been removed\n\t\t\tif ( !timer() && timers[ i ] === timer ) {\n\t\t\t\ttimers.splice( i--, 1 );\n\t\t\t}\n\t\t}\n\n\t\tif ( !timers.length ) {\n\t\t\tjQuery.fx.stop();\n\t\t}\n\t\tfxNow = undefined;\n\t};\n\n\tjQuery.fx.timer = function( timer ) {\n\t\tjQuery.timers.push( timer );\n\t\tif ( timer() ) {\n\t\t\tjQuery.fx.start();\n\t\t} else {\n\t\t\tjQuery.timers.pop();\n\t\t}\n\t};\n\n\tjQuery.fx.interval = 13;\n\n\tjQuery.fx.start = function() {\n\t\tif ( !timerId ) {\n\t\t\ttimerId = window.setInterval( jQuery.fx.tick, jQuery.fx.interval );\n\t\t}\n\t};\n\n\tjQuery.fx.stop = function() {\n\t\twindow.clearInterval( timerId );\n\t\ttimerId = null;\n\t};\n\n\tjQuery.fx.speeds = {\n\t\tslow: 600,\n\t\tfast: 200,\n\n\t\t// Default speed\n\t\t_default: 400\n\t};\n\n\n// Based off of the plugin by Clint Helfers, with permission.\n// http://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/\n\tjQuery.fn.delay = function( time, type ) {\n\t\ttime = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;\n\t\ttype = type || \"fx\";\n\n\t\treturn this.queue( type, function( next, hooks ) {\n\t\t\tvar timeout = window.setTimeout( next, time );\n\t\t\thooks.stop = function() {\n\t\t\t\twindow.clearTimeout( timeout );\n\t\t\t};\n\t\t} );\n\t};\n\n\n\t( function() {\n\t\tvar a,\n\t\t\tinput = document.createElement( \"input\" ),\n\t\t\tdiv = document.createElement( \"div\" ),\n\t\t\tselect = document.createElement( \"select\" ),\n\t\t\topt = select.appendChild( document.createElement( \"option\" ) );\n\n\t\t// Setup\n\t\tdiv = document.createElement( \"div\" );\n\t\tdiv.setAttribute( \"className\", \"t\" );\n\t\tdiv.innerHTML = \"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\";\n\t\ta = div.getElementsByTagName( \"a\" )[ 0 ];\n\n\t\t// Support: Windows Web Apps (WWA)\n\t\t// `type` must use .setAttribute for WWA (#14901)\n\t\tinput.setAttribute( \"type\", \"checkbox\" );\n\t\tdiv.appendChild( input );\n\n\t\ta = div.getElementsByTagName( \"a\" )[ 0 ];\n\n\t\t// First batch of tests.\n\t\ta.style.cssText = \"top:1px\";\n\n\t\t// Test setAttribute on camelCase class.\n\t\t// If it works, we need attrFixes when doing get/setAttribute (ie6/7)\n\t\tsupport.getSetAttribute = div.className !== \"t\";\n\n\t\t// Get the style information from getAttribute\n\t\t// (IE uses .cssText instead)\n\t\tsupport.style = /top/.test( a.getAttribute( \"style\" ) );\n\n\t\t// Make sure that URLs aren't manipulated\n\t\t// (IE normalizes it by default)\n\t\tsupport.hrefNormalized = a.getAttribute( \"href\" ) === \"/a\";\n\n\t\t// Check the default checkbox/radio value (\"\" on WebKit; \"on\" elsewhere)\n\t\tsupport.checkOn = !!input.value;\n\n\t\t// Make sure that a selected-by-default option has a working selected property.\n\t\t// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)\n\t\tsupport.optSelected = opt.selected;\n\n\t\t// Tests for enctype support on a form (#6743)\n\t\tsupport.enctype = !!document.createElement( \"form\" ).enctype;\n\n\t\t// Make sure that the options inside disabled selects aren't marked as disabled\n\t\t// (WebKit marks them as disabled)\n\t\tselect.disabled = true;\n\t\tsupport.optDisabled = !opt.disabled;\n\n\t\t// Support: IE8 only\n\t\t// Check if we can trust getAttribute(\"value\")\n\t\tinput = document.createElement( \"input\" );\n\t\tinput.setAttribute( \"value\", \"\" );\n\t\tsupport.input = input.getAttribute( \"value\" ) === \"\";\n\n\t\t// Check if an input maintains its value after becoming a radio\n\t\tinput.value = \"t\";\n\t\tinput.setAttribute( \"type\", \"radio\" );\n\t\tsupport.radioValue = input.value === \"t\";\n\t} )();\n\n\n\tvar rreturn = /\\r/g,\n\t\trspaces = /[\\x20\\t\\r\\n\\f]+/g;\n\n\tjQuery.fn.extend( {\n\t\tval: function( value ) {\n\t\t\tvar hooks, ret, isFunction,\n\t\t\t\telem = this[ 0 ];\n\n\t\t\tif ( !arguments.length ) {\n\t\t\t\tif ( elem ) {\n\t\t\t\t\thooks = jQuery.valHooks[ elem.type ] ||\n\t\t\t\t\t\tjQuery.valHooks[ elem.nodeName.toLowerCase() ];\n\n\t\t\t\t\tif (\n\t\t\t\t\t\thooks &&\n\t\t\t\t\t\t\"get\" in hooks &&\n\t\t\t\t\t\t( ret = hooks.get( elem, \"value\" ) ) !== undefined\n\t\t\t\t\t) {\n\t\t\t\t\t\treturn ret;\n\t\t\t\t\t}\n\n\t\t\t\t\tret = elem.value;\n\n\t\t\t\t\treturn typeof ret === \"string\" ?\n\n\t\t\t\t\t\t// handle most common string cases\n\t\t\t\t\t\tret.replace( rreturn, \"\" ) :\n\n\t\t\t\t\t\t// handle cases where value is null/undef or number\n\t\t\t\t\t\tret == null ? \"\" : ret;\n\t\t\t\t}\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tisFunction = jQuery.isFunction( value );\n\n\t\t\treturn this.each( function( i ) {\n\t\t\t\tvar val;\n\n\t\t\t\tif ( this.nodeType !== 1 ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif ( isFunction ) {\n\t\t\t\t\tval = value.call( this, i, jQuery( this ).val() );\n\t\t\t\t} else {\n\t\t\t\t\tval = value;\n\t\t\t\t}\n\n\t\t\t\t// Treat null/undefined as \"\"; convert numbers to string\n\t\t\t\tif ( val == null ) {\n\t\t\t\t\tval = \"\";\n\t\t\t\t} else if ( typeof val === \"number\" ) {\n\t\t\t\t\tval += \"\";\n\t\t\t\t} else if ( jQuery.isArray( val ) ) {\n\t\t\t\t\tval = jQuery.map( val, function( value ) {\n\t\t\t\t\t\treturn value == null ? \"\" : value + \"\";\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\thooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];\n\n\t\t\t\t// If set returns undefined, fall back to normal setting\n\t\t\t\tif ( !hooks || !( \"set\" in hooks ) || hooks.set( this, val, \"value\" ) === undefined ) {\n\t\t\t\t\tthis.value = val;\n\t\t\t\t}\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.extend( {\n\t\tvalHooks: {\n\t\t\toption: {\n\t\t\t\tget: function( elem ) {\n\t\t\t\t\tvar val = jQuery.find.attr( elem, \"value\" );\n\t\t\t\t\treturn val != null ?\n\t\t\t\t\t\tval :\n\n\t\t\t\t\t\t// Support: IE10-11+\n\t\t\t\t\t\t// option.text throws exceptions (#14686, #14858)\n\t\t\t\t\t\t// Strip and collapse whitespace\n\t\t\t\t\t\t// https://html.spec.whatwg.org/#strip-and-collapse-whitespace\n\t\t\t\t\t\tjQuery.trim( jQuery.text( elem ) ).replace( rspaces, \" \" );\n\t\t\t\t}\n\t\t\t},\n\t\t\tselect: {\n\t\t\t\tget: function( elem ) {\n\t\t\t\t\tvar value, option,\n\t\t\t\t\t\toptions = elem.options,\n\t\t\t\t\t\tindex = elem.selectedIndex,\n\t\t\t\t\t\tone = elem.type === \"select-one\" || index < 0,\n\t\t\t\t\t\tvalues = one ? null : [],\n\t\t\t\t\t\tmax = one ? index + 1 : options.length,\n\t\t\t\t\t\ti = index < 0 ?\n\t\t\t\t\t\t\tmax :\n\t\t\t\t\t\t\tone ? index : 0;\n\n\t\t\t\t\t// Loop through all the selected options\n\t\t\t\t\tfor ( ; i < max; i++ ) {\n\t\t\t\t\t\toption = options[ i ];\n\n\t\t\t\t\t\t// oldIE doesn't update selected after form reset (#2551)\n\t\t\t\t\t\tif ( ( option.selected || i === index ) &&\n\n\t\t\t\t\t\t\t// Don't return options that are disabled or in a disabled optgroup\n\t\t\t\t\t\t\t( support.optDisabled ?\n\t\t\t\t\t\t\t\t!option.disabled :\n\t\t\t\t\t\t\toption.getAttribute( \"disabled\" ) === null ) &&\n\t\t\t\t\t\t\t( !option.parentNode.disabled ||\n\t\t\t\t\t\t\t!jQuery.nodeName( option.parentNode, \"optgroup\" ) ) ) {\n\n\t\t\t\t\t\t\t// Get the specific value for the option\n\t\t\t\t\t\t\tvalue = jQuery( option ).val();\n\n\t\t\t\t\t\t\t// We don't need an array for one selects\n\t\t\t\t\t\t\tif ( one ) {\n\t\t\t\t\t\t\t\treturn value;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Multi-Selects return an array\n\t\t\t\t\t\t\tvalues.push( value );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn values;\n\t\t\t\t},\n\n\t\t\t\tset: function( elem, value ) {\n\t\t\t\t\tvar optionSet, option,\n\t\t\t\t\t\toptions = elem.options,\n\t\t\t\t\t\tvalues = jQuery.makeArray( value ),\n\t\t\t\t\t\ti = options.length;\n\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\toption = options[ i ];\n\n\t\t\t\t\t\tif ( jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1 ) {\n\n\t\t\t\t\t\t\t// Support: IE6\n\t\t\t\t\t\t\t// When new option element is added to select box we need to\n\t\t\t\t\t\t\t// force reflow of newly added node in order to workaround delay\n\t\t\t\t\t\t\t// of initialization properties\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\toption.selected = optionSet = true;\n\n\t\t\t\t\t\t\t} catch ( _ ) {\n\n\t\t\t\t\t\t\t\t// Will be executed only in IE6\n\t\t\t\t\t\t\t\toption.scrollHeight;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\toption.selected = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Force browsers to behave consistently when non-matching value is set\n\t\t\t\t\tif ( !optionSet ) {\n\t\t\t\t\t\telem.selectedIndex = -1;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn options;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} );\n\n// Radios and checkboxes getter/setter\n\tjQuery.each( [ \"radio\", \"checkbox\" ], function() {\n\t\tjQuery.valHooks[ this ] = {\n\t\t\tset: function( elem, value ) {\n\t\t\t\tif ( jQuery.isArray( value ) ) {\n\t\t\t\t\treturn ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t\tif ( !support.checkOn ) {\n\t\t\tjQuery.valHooks[ this ].get = function( elem ) {\n\t\t\t\treturn elem.getAttribute( \"value\" ) === null ? \"on\" : elem.value;\n\t\t\t};\n\t\t}\n\t} );\n\n\n\n\n\tvar nodeHook, boolHook,\n\t\tattrHandle = jQuery.expr.attrHandle,\n\t\truseDefault = /^(?:checked|selected)$/i,\n\t\tgetSetAttribute = support.getSetAttribute,\n\t\tgetSetInput = support.input;\n\n\tjQuery.fn.extend( {\n\t\tattr: function( name, value ) {\n\t\t\treturn access( this, jQuery.attr, name, value, arguments.length > 1 );\n\t\t},\n\n\t\tremoveAttr: function( name ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.removeAttr( this, name );\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.extend( {\n\t\tattr: function( elem, name, value ) {\n\t\t\tvar ret, hooks,\n\t\t\t\tnType = elem.nodeType;\n\n\t\t\t// Don't get/set attributes on text, comment and attribute nodes\n\t\t\tif ( nType === 3 || nType === 8 || nType === 2 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Fallback to prop when attributes are not supported\n\t\t\tif ( typeof elem.getAttribute === \"undefined\" ) {\n\t\t\t\treturn jQuery.prop( elem, name, value );\n\t\t\t}\n\n\t\t\t// All attributes are lowercase\n\t\t\t// Grab necessary hook if one is defined\n\t\t\tif ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {\n\t\t\t\tname = name.toLowerCase();\n\t\t\t\thooks = jQuery.attrHooks[ name ] ||\n\t\t\t\t\t( jQuery.expr.match.bool.test( name ) ? boolHook : nodeHook );\n\t\t\t}\n\n\t\t\tif ( value !== undefined ) {\n\t\t\t\tif ( value === null ) {\n\t\t\t\t\tjQuery.removeAttr( elem, name );\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif ( hooks && \"set\" in hooks &&\n\t\t\t\t\t( ret = hooks.set( elem, value, name ) ) !== undefined ) {\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\n\t\t\t\telem.setAttribute( name, value + \"\" );\n\t\t\t\treturn value;\n\t\t\t}\n\n\t\t\tif ( hooks && \"get\" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {\n\t\t\t\treturn ret;\n\t\t\t}\n\n\t\t\tret = jQuery.find.attr( elem, name );\n\n\t\t\t// Non-existent attributes return null, we normalize to undefined\n\t\t\treturn ret == null ? undefined : ret;\n\t\t},\n\n\t\tattrHooks: {\n\t\t\ttype: {\n\t\t\t\tset: function( elem, value ) {\n\t\t\t\t\tif ( !support.radioValue && value === \"radio\" &&\n\t\t\t\t\t\tjQuery.nodeName( elem, \"input\" ) ) {\n\n\t\t\t\t\t\t// Setting the type on a radio button after the value resets the value in IE8-9\n\t\t\t\t\t\t// Reset value to default in case type is set after value during creation\n\t\t\t\t\t\tvar val = elem.value;\n\t\t\t\t\t\telem.setAttribute( \"type\", value );\n\t\t\t\t\t\tif ( val ) {\n\t\t\t\t\t\t\telem.value = val;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn value;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tremoveAttr: function( elem, value ) {\n\t\t\tvar name, propName,\n\t\t\t\ti = 0,\n\t\t\t\tattrNames = value && value.match( rnotwhite );\n\n\t\t\tif ( attrNames && elem.nodeType === 1 ) {\n\t\t\t\twhile ( ( name = attrNames[ i++ ] ) ) {\n\t\t\t\t\tpropName = jQuery.propFix[ name ] || name;\n\n\t\t\t\t\t// Boolean attributes get special treatment (#10870)\n\t\t\t\t\tif ( jQuery.expr.match.bool.test( name ) ) {\n\n\t\t\t\t\t\t// Set corresponding property to false\n\t\t\t\t\t\tif ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {\n\t\t\t\t\t\t\telem[ propName ] = false;\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// Also clear defaultChecked/defaultSelected (if appropriate)\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\telem[ jQuery.camelCase( \"default-\" + name ) ] =\n\t\t\t\t\t\t\t\telem[ propName ] = false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// See #9699 for explanation of this approach (setting first, then removal)\n\t\t\t\t\t} else {\n\t\t\t\t\t\tjQuery.attr( elem, name, \"\" );\n\t\t\t\t\t}\n\n\t\t\t\t\telem.removeAttribute( getSetAttribute ? name : propName );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} );\n\n// Hooks for boolean attributes\n\tboolHook = {\n\t\tset: function( elem, value, name ) {\n\t\t\tif ( value === false ) {\n\n\t\t\t\t// Remove boolean attributes when set to false\n\t\t\t\tjQuery.removeAttr( elem, name );\n\t\t\t} else if ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {\n\n\t\t\t\t// IE<8 needs the *property* name\n\t\t\t\telem.setAttribute( !getSetAttribute && jQuery.propFix[ name ] || name, name );\n\n\t\t\t} else {\n\n\t\t\t\t// Support: IE<9\n\t\t\t\t// Use defaultChecked and defaultSelected for oldIE\n\t\t\t\telem[ jQuery.camelCase( \"default-\" + name ) ] = elem[ name ] = true;\n\t\t\t}\n\t\t\treturn name;\n\t\t}\n\t};\n\n\tjQuery.each( jQuery.expr.match.bool.source.match( /\\w+/g ), function( i, name ) {\n\t\tvar getter = attrHandle[ name ] || jQuery.find.attr;\n\n\t\tif ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {\n\t\t\tattrHandle[ name ] = function( elem, name, isXML ) {\n\t\t\t\tvar ret, handle;\n\t\t\t\tif ( !isXML ) {\n\n\t\t\t\t\t// Avoid an infinite loop by temporarily removing this function from the getter\n\t\t\t\t\thandle = attrHandle[ name ];\n\t\t\t\t\tattrHandle[ name ] = ret;\n\t\t\t\t\tret = getter( elem, name, isXML ) != null ?\n\t\t\t\t\t\tname.toLowerCase() :\n\t\t\t\t\t\tnull;\n\t\t\t\t\tattrHandle[ name ] = handle;\n\t\t\t\t}\n\t\t\t\treturn ret;\n\t\t\t};\n\t\t} else {\n\t\t\tattrHandle[ name ] = function( elem, name, isXML ) {\n\t\t\t\tif ( !isXML ) {\n\t\t\t\t\treturn elem[ jQuery.camelCase( \"default-\" + name ) ] ?\n\t\t\t\t\t\tname.toLowerCase() :\n\t\t\t\t\t\tnull;\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t} );\n\n// fix oldIE attroperties\n\tif ( !getSetInput || !getSetAttribute ) {\n\t\tjQuery.attrHooks.value = {\n\t\t\tset: function( elem, value, name ) {\n\t\t\t\tif ( jQuery.nodeName( elem, \"input\" ) ) {\n\n\t\t\t\t\t// Does not return so that setAttribute is also used\n\t\t\t\t\telem.defaultValue = value;\n\t\t\t\t} else {\n\n\t\t\t\t\t// Use nodeHook if defined (#1954); otherwise setAttribute is fine\n\t\t\t\t\treturn nodeHook && nodeHook.set( elem, value, name );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n// IE6/7 do not support getting/setting some attributes with get/setAttribute\n\tif ( !getSetAttribute ) {\n\n\t\t// Use this for any attribute in IE6/7\n\t\t// This fixes almost every IE6/7 issue\n\t\tnodeHook = {\n\t\t\tset: function( elem, value, name ) {\n\n\t\t\t\t// Set the existing or create a new attribute node\n\t\t\t\tvar ret = elem.getAttributeNode( name );\n\t\t\t\tif ( !ret ) {\n\t\t\t\t\telem.setAttributeNode(\n\t\t\t\t\t\t( ret = elem.ownerDocument.createAttribute( name ) )\n\t\t\t\t\t);\n\t\t\t\t}\n\n\t\t\t\tret.value = value += \"\";\n\n\t\t\t\t// Break association with cloned elements by also using setAttribute (#9646)\n\t\t\t\tif ( name === \"value\" || value === elem.getAttribute( name ) ) {\n\t\t\t\t\treturn value;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t// Some attributes are constructed with empty-string values when not defined\n\t\tattrHandle.id = attrHandle.name = attrHandle.coords =\n\t\t\tfunction( elem, name, isXML ) {\n\t\t\t\tvar ret;\n\t\t\t\tif ( !isXML ) {\n\t\t\t\t\treturn ( ret = elem.getAttributeNode( name ) ) && ret.value !== \"\" ?\n\t\t\t\t\t\tret.value :\n\t\t\t\t\t\tnull;\n\t\t\t\t}\n\t\t\t};\n\n\t\t// Fixing value retrieval on a button requires this module\n\t\tjQuery.valHooks.button = {\n\t\t\tget: function( elem, name ) {\n\t\t\t\tvar ret = elem.getAttributeNode( name );\n\t\t\t\tif ( ret && ret.specified ) {\n\t\t\t\t\treturn ret.value;\n\t\t\t\t}\n\t\t\t},\n\t\t\tset: nodeHook.set\n\t\t};\n\n\t\t// Set contenteditable to false on removals(#10429)\n\t\t// Setting to empty string throws an error as an invalid value\n\t\tjQuery.attrHooks.contenteditable = {\n\t\t\tset: function( elem, value, name ) {\n\t\t\t\tnodeHook.set( elem, value === \"\" ? false : value, name );\n\t\t\t}\n\t\t};\n\n\t\t// Set width and height to auto instead of 0 on empty string( Bug #8150 )\n\t\t// This is for removals\n\t\tjQuery.each( [ \"width\", \"height\" ], function( i, name ) {\n\t\t\tjQuery.attrHooks[ name ] = {\n\t\t\t\tset: function( elem, value ) {\n\t\t\t\t\tif ( value === \"\" ) {\n\t\t\t\t\t\telem.setAttribute( name, \"auto\" );\n\t\t\t\t\t\treturn value;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t} );\n\t}\n\n\tif ( !support.style ) {\n\t\tjQuery.attrHooks.style = {\n\t\t\tget: function( elem ) {\n\n\t\t\t\t// Return undefined in the case of empty string\n\t\t\t\t// Note: IE uppercases css property names, but if we were to .toLowerCase()\n\t\t\t\t// .cssText, that would destroy case sensitivity in URL's, like in \"background\"\n\t\t\t\treturn elem.style.cssText || undefined;\n\t\t\t},\n\t\t\tset: function( elem, value ) {\n\t\t\t\treturn ( elem.style.cssText = value + \"\" );\n\t\t\t}\n\t\t};\n\t}\n\n\n\n\n\tvar rfocusable = /^(?:input|select|textarea|button|object)$/i,\n\t\trclickable = /^(?:a|area)$/i;\n\n\tjQuery.fn.extend( {\n\t\tprop: function( name, value ) {\n\t\t\treturn access( this, jQuery.prop, name, value, arguments.length > 1 );\n\t\t},\n\n\t\tremoveProp: function( name ) {\n\t\t\tname = jQuery.propFix[ name ] || name;\n\t\t\treturn this.each( function() {\n\n\t\t\t\t// try/catch handles cases where IE balks (such as removing a property on window)\n\t\t\t\ttry {\n\t\t\t\t\tthis[ name ] = undefined;\n\t\t\t\t\tdelete this[ name ];\n\t\t\t\t} catch ( e ) {}\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.extend( {\n\t\tprop: function( elem, name, value ) {\n\t\t\tvar ret, hooks,\n\t\t\t\tnType = elem.nodeType;\n\n\t\t\t// Don't get/set properties on text, comment and attribute nodes\n\t\t\tif ( nType === 3 || nType === 8 || nType === 2 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {\n\n\t\t\t\t// Fix name and attach hooks\n\t\t\t\tname = jQuery.propFix[ name ] || name;\n\t\t\t\thooks = jQuery.propHooks[ name ];\n\t\t\t}\n\n\t\t\tif ( value !== undefined ) {\n\t\t\t\tif ( hooks && \"set\" in hooks &&\n\t\t\t\t\t( ret = hooks.set( elem, value, name ) ) !== undefined ) {\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\n\t\t\t\treturn ( elem[ name ] = value );\n\t\t\t}\n\n\t\t\tif ( hooks && \"get\" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {\n\t\t\t\treturn ret;\n\t\t\t}\n\n\t\t\treturn elem[ name ];\n\t\t},\n\n\t\tpropHooks: {\n\t\t\ttabIndex: {\n\t\t\t\tget: function( elem ) {\n\n\t\t\t\t\t// elem.tabIndex doesn't always return the\n\t\t\t\t\t// correct value when it hasn't been explicitly set\n\t\t\t\t\t// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/\n\t\t\t\t\t// Use proper attribute retrieval(#12072)\n\t\t\t\t\tvar tabindex = jQuery.find.attr( elem, \"tabindex\" );\n\n\t\t\t\t\treturn tabindex ?\n\t\t\t\t\t\tparseInt( tabindex, 10 ) :\n\t\t\t\t\t\trfocusable.test( elem.nodeName ) ||\n\t\t\t\t\t\trclickable.test( elem.nodeName ) && elem.href ?\n\t\t\t\t\t\t\t0 :\n\t\t\t\t\t\t\t-1;\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tpropFix: {\n\t\t\t\"for\": \"htmlFor\",\n\t\t\t\"class\": \"className\"\n\t\t}\n\t} );\n\n// Some attributes require a special call on IE\n// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx\n\tif ( !support.hrefNormalized ) {\n\n\t\t// href/src property should get the full normalized URL (#10299/#12915)\n\t\tjQuery.each( [ \"href\", \"src\" ], function( i, name ) {\n\t\t\tjQuery.propHooks[ name ] = {\n\t\t\t\tget: function( elem ) {\n\t\t\t\t\treturn elem.getAttribute( name, 4 );\n\t\t\t\t}\n\t\t\t};\n\t\t} );\n\t}\n\n// Support: Safari, IE9+\n// Accessing the selectedIndex property\n// forces the browser to respect setting selected\n// on the option\n// The getter ensures a default option is selected\n// when in an optgroup\n\tif ( !support.optSelected ) {\n\t\tjQuery.propHooks.selected = {\n\t\t\tget: function( elem ) {\n\t\t\t\tvar parent = elem.parentNode;\n\n\t\t\t\tif ( parent ) {\n\t\t\t\t\tparent.selectedIndex;\n\n\t\t\t\t\t// Make sure that it also works with optgroups, see #5701\n\t\t\t\t\tif ( parent.parentNode ) {\n\t\t\t\t\t\tparent.parentNode.selectedIndex;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn null;\n\t\t\t},\n\t\t\tset: function( elem ) {\n\t\t\t\tvar parent = elem.parentNode;\n\t\t\t\tif ( parent ) {\n\t\t\t\t\tparent.selectedIndex;\n\n\t\t\t\t\tif ( parent.parentNode ) {\n\t\t\t\t\t\tparent.parentNode.selectedIndex;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n\tjQuery.each( [\n\t\t\"tabIndex\",\n\t\t\"readOnly\",\n\t\t\"maxLength\",\n\t\t\"cellSpacing\",\n\t\t\"cellPadding\",\n\t\t\"rowSpan\",\n\t\t\"colSpan\",\n\t\t\"useMap\",\n\t\t\"frameBorder\",\n\t\t\"contentEditable\"\n\t], function() {\n\t\tjQuery.propFix[ this.toLowerCase() ] = this;\n\t} );\n\n// IE6/7 call enctype encoding\n\tif ( !support.enctype ) {\n\t\tjQuery.propFix.enctype = \"encoding\";\n\t}\n\n\n\n\n\tvar rclass = /[\\t\\r\\n\\f]/g;\n\n\tfunction getClass( elem ) {\n\t\treturn jQuery.attr( elem, \"class\" ) || \"\";\n\t}\n\n\tjQuery.fn.extend( {\n\t\taddClass: function( value ) {\n\t\t\tvar classes, elem, cur, curValue, clazz, j, finalValue,\n\t\t\t\ti = 0;\n\n\t\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\t\treturn this.each( function( j ) {\n\t\t\t\t\tjQuery( this ).addClass( value.call( this, j, getClass( this ) ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( typeof value === \"string\" && value ) {\n\t\t\t\tclasses = value.match( rnotwhite ) || [];\n\n\t\t\t\twhile ( ( elem = this[ i++ ] ) ) {\n\t\t\t\t\tcurValue = getClass( elem );\n\t\t\t\t\tcur = elem.nodeType === 1 &&\n\t\t\t\t\t\t( \" \" + curValue + \" \" ).replace( rclass, \" \" );\n\n\t\t\t\t\tif ( cur ) {\n\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\twhile ( ( clazz = classes[ j++ ] ) ) {\n\t\t\t\t\t\t\tif ( cur.indexOf( \" \" + clazz + \" \" ) < 0 ) {\n\t\t\t\t\t\t\t\tcur += clazz + \" \";\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// only assign if different to avoid unneeded rendering.\n\t\t\t\t\t\tfinalValue = jQuery.trim( cur );\n\t\t\t\t\t\tif ( curValue !== finalValue ) {\n\t\t\t\t\t\t\tjQuery.attr( elem, \"class\", finalValue );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\tremoveClass: function( value ) {\n\t\t\tvar classes, elem, cur, curValue, clazz, j, finalValue,\n\t\t\t\ti = 0;\n\n\t\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\t\treturn this.each( function( j ) {\n\t\t\t\t\tjQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( !arguments.length ) {\n\t\t\t\treturn this.attr( \"class\", \"\" );\n\t\t\t}\n\n\t\t\tif ( typeof value === \"string\" && value ) {\n\t\t\t\tclasses = value.match( rnotwhite ) || [];\n\n\t\t\t\twhile ( ( elem = this[ i++ ] ) ) {\n\t\t\t\t\tcurValue = getClass( elem );\n\n\t\t\t\t\t// This expression is here for better compressibility (see addClass)\n\t\t\t\t\tcur = elem.nodeType === 1 &&\n\t\t\t\t\t\t( \" \" + curValue + \" \" ).replace( rclass, \" \" );\n\n\t\t\t\t\tif ( cur ) {\n\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\twhile ( ( clazz = classes[ j++ ] ) ) {\n\n\t\t\t\t\t\t\t// Remove *all* instances\n\t\t\t\t\t\t\twhile ( cur.indexOf( \" \" + clazz + \" \" ) > -1 ) {\n\t\t\t\t\t\t\t\tcur = cur.replace( \" \" + clazz + \" \", \" \" );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Only assign if different to avoid unneeded rendering.\n\t\t\t\t\t\tfinalValue = jQuery.trim( cur );\n\t\t\t\t\t\tif ( curValue !== finalValue ) {\n\t\t\t\t\t\t\tjQuery.attr( elem, \"class\", finalValue );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\ttoggleClass: function( value, stateVal ) {\n\t\t\tvar type = typeof value;\n\n\t\t\tif ( typeof stateVal === \"boolean\" && type === \"string\" ) {\n\t\t\t\treturn stateVal ? this.addClass( value ) : this.removeClass( value );\n\t\t\t}\n\n\t\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\t\treturn this.each( function( i ) {\n\t\t\t\t\tjQuery( this ).toggleClass(\n\t\t\t\t\t\tvalue.call( this, i, getClass( this ), stateVal ),\n\t\t\t\t\t\tstateVal\n\t\t\t\t\t);\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tvar className, i, self, classNames;\n\n\t\t\t\tif ( type === \"string\" ) {\n\n\t\t\t\t\t// Toggle individual class names\n\t\t\t\t\ti = 0;\n\t\t\t\t\tself = jQuery( this );\n\t\t\t\t\tclassNames = value.match( rnotwhite ) || [];\n\n\t\t\t\t\twhile ( ( className = classNames[ i++ ] ) ) {\n\n\t\t\t\t\t\t// Check each className given, space separated list\n\t\t\t\t\t\tif ( self.hasClass( className ) ) {\n\t\t\t\t\t\t\tself.removeClass( className );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tself.addClass( className );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Toggle whole class name\n\t\t\t\t} else if ( value === undefined || type === \"boolean\" ) {\n\t\t\t\t\tclassName = getClass( this );\n\t\t\t\t\tif ( className ) {\n\n\t\t\t\t\t\t// store className if set\n\t\t\t\t\t\tjQuery._data( this, \"__className__\", className );\n\t\t\t\t\t}\n\n\t\t\t\t\t// If the element has a class name or if we're passed \"false\",\n\t\t\t\t\t// then remove the whole classname (if there was one, the above saved it).\n\t\t\t\t\t// Otherwise bring back whatever was previously saved (if anything),\n\t\t\t\t\t// falling back to the empty string if nothing was stored.\n\t\t\t\t\tjQuery.attr( this, \"class\",\n\t\t\t\t\t\tclassName || value === false ?\n\t\t\t\t\t\t\t\"\" :\n\t\t\t\t\t\tjQuery._data( this, \"__className__\" ) || \"\"\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\thasClass: function( selector ) {\n\t\t\tvar className, elem,\n\t\t\t\ti = 0;\n\n\t\t\tclassName = \" \" + selector + \" \";\n\t\t\twhile ( ( elem = this[ i++ ] ) ) {\n\t\t\t\tif ( elem.nodeType === 1 &&\n\t\t\t\t\t( \" \" + getClass( elem ) + \" \" ).replace( rclass, \" \" )\n\t\t\t\t\t\t.indexOf( className ) > -1\n\t\t\t\t) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn false;\n\t\t}\n\t} );\n\n\n\n\n// Return jQuery for attributes-only inclusion\n\n\n\tjQuery.each( ( \"blur focus focusin focusout load resize scroll unload click dblclick \" +\n\t\t\"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave \" +\n\t\t\"change select submit keydown keypress keyup error contextmenu\" ).split( \" \" ),\n\t\tfunction( i, name ) {\n\n\t\t\t// Handle event binding\n\t\t\tjQuery.fn[ name ] = function( data, fn ) {\n\t\t\t\treturn arguments.length > 0 ?\n\t\t\t\t\tthis.on( name, null, data, fn ) :\n\t\t\t\t\tthis.trigger( name );\n\t\t\t};\n\t\t} );\n\n\tjQuery.fn.extend( {\n\t\thover: function( fnOver, fnOut ) {\n\t\t\treturn this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );\n\t\t}\n\t} );\n\n\n\tvar location = window.location;\n\n\tvar nonce = jQuery.now();\n\n\tvar rquery = ( /\\?/ );\n\n\n\n\tvar rvalidtokens = /(,)|(\\[|{)|(}|])|\"(?:[^\"\\\\\\r\\n]|\\\\[\"\\\\\\/bfnrt]|\\\\u[\\da-fA-F]{4})*\"\\s*:?|true|false|null|-?(?!0\\d)\\d+(?:\\.\\d+|)(?:[eE][+-]?\\d+|)/g;\n\n\tjQuery.parseJSON = function( data ) {\n\n\t\t// Attempt to parse using the native JSON parser first\n\t\tif ( window.JSON && window.JSON.parse ) {\n\n\t\t\t// Support: Android 2.3\n\t\t\t// Workaround failure to string-cast null input\n\t\t\treturn window.JSON.parse( data + \"\" );\n\t\t}\n\n\t\tvar requireNonComma,\n\t\t\tdepth = null,\n\t\t\tstr = jQuery.trim( data + \"\" );\n\n\t\t// Guard against invalid (and possibly dangerous) input by ensuring that nothing remains\n\t\t// after removing valid tokens\n\t\treturn str && !jQuery.trim( str.replace( rvalidtokens, function( token, comma, open, close ) {\n\n\t\t\t// Force termination if we see a misplaced comma\n\t\t\tif ( requireNonComma && comma ) {\n\t\t\t\tdepth = 0;\n\t\t\t}\n\n\t\t\t// Perform no more replacements after returning to outermost depth\n\t\t\tif ( depth === 0 ) {\n\t\t\t\treturn token;\n\t\t\t}\n\n\t\t\t// Commas must not follow \"[\", \"{\", or \",\"\n\t\t\trequireNonComma = open || comma;\n\n\t\t\t// Determine new depth\n\t\t\t// array/object open (\"[\" or \"{\"): depth += true - false (increment)\n\t\t\t// array/object close (\"]\" or \"}\"): depth += false - true (decrement)\n\t\t\t// other cases (\",\" or primitive): depth += true - true (numeric cast)\n\t\t\tdepth += !close - !open;\n\n\t\t\t// Remove this token\n\t\t\treturn \"\";\n\t\t} ) ) ?\n\t\t\t( Function( \"return \" + str ) )() :\n\t\t\tjQuery.error( \"Invalid JSON: \" + data );\n\t};\n\n\n// Cross-browser xml parsing\n\tjQuery.parseXML = function( data ) {\n\t\tvar xml, tmp;\n\t\tif ( !data || typeof data !== \"string\" ) {\n\t\t\treturn null;\n\t\t}\n\t\ttry {\n\t\t\tif ( window.DOMParser ) { // Standard\n\t\t\t\ttmp = new window.DOMParser();\n\t\t\t\txml = tmp.parseFromString( data, \"text/xml\" );\n\t\t\t} else { // IE\n\t\t\t\txml = new window.ActiveXObject( \"Microsoft.XMLDOM\" );\n\t\t\t\txml.async = \"false\";\n\t\t\t\txml.loadXML( data );\n\t\t\t}\n\t\t} catch ( e ) {\n\t\t\txml = undefined;\n\t\t}\n\t\tif ( !xml || !xml.documentElement || xml.getElementsByTagName( \"parsererror\" ).length ) {\n\t\t\tjQuery.error( \"Invalid XML: \" + data );\n\t\t}\n\t\treturn xml;\n\t};\n\n\n\tvar\n\t\trhash = /#.*$/,\n\t\trts = /([?&])_=[^&]*/,\n\n\t\t// IE leaves an \\r character at EOL\n\t\trheaders = /^(.*?):[ \\t]*([^\\r\\n]*)\\r?$/mg,\n\n\t\t// #7653, #8125, #8152: local protocol detection\n\t\trlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,\n\t\trnoContent = /^(?:GET|HEAD)$/,\n\t\trprotocol = /^\\/\\//,\n\t\trurl = /^([\\w.+-]+:)(?:\\/\\/(?:[^\\/?#]*@|)([^\\/?#:]*)(?::(\\d+)|)|)/,\n\n\t\t/* Prefilters\n\t\t * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)\n\t\t * 2) These are called:\n\t\t *    - BEFORE asking for a transport\n\t\t *    - AFTER param serialization (s.data is a string if s.processData is true)\n\t\t * 3) key is the dataType\n\t\t * 4) the catchall symbol \"*\" can be used\n\t\t * 5) execution will start with transport dataType and THEN continue down to \"*\" if needed\n\t\t */\n\t\tprefilters = {},\n\n\t\t/* Transports bindings\n\t\t * 1) key is the dataType\n\t\t * 2) the catchall symbol \"*\" can be used\n\t\t * 3) selection will start with transport dataType and THEN go to \"*\" if needed\n\t\t */\n\t\ttransports = {},\n\n\t\t// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression\n\t\tallTypes = \"*/\".concat( \"*\" ),\n\n\t\t// Document location\n\t\tajaxLocation = location.href,\n\n\t\t// Segment location into parts\n\t\tajaxLocParts = rurl.exec( ajaxLocation.toLowerCase() ) || [];\n\n// Base \"constructor\" for jQuery.ajaxPrefilter and jQuery.ajaxTransport\n\tfunction addToPrefiltersOrTransports( structure ) {\n\n\t\t// dataTypeExpression is optional and defaults to \"*\"\n\t\treturn function( dataTypeExpression, func ) {\n\n\t\t\tif ( typeof dataTypeExpression !== \"string\" ) {\n\t\t\t\tfunc = dataTypeExpression;\n\t\t\t\tdataTypeExpression = \"*\";\n\t\t\t}\n\n\t\t\tvar dataType,\n\t\t\t\ti = 0,\n\t\t\t\tdataTypes = dataTypeExpression.toLowerCase().match( rnotwhite ) || [];\n\n\t\t\tif ( jQuery.isFunction( func ) ) {\n\n\t\t\t\t// For each dataType in the dataTypeExpression\n\t\t\t\twhile ( ( dataType = dataTypes[ i++ ] ) ) {\n\n\t\t\t\t\t// Prepend if requested\n\t\t\t\t\tif ( dataType.charAt( 0 ) === \"+\" ) {\n\t\t\t\t\t\tdataType = dataType.slice( 1 ) || \"*\";\n\t\t\t\t\t\t( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );\n\n\t\t\t\t\t\t// Otherwise append\n\t\t\t\t\t} else {\n\t\t\t\t\t\t( structure[ dataType ] = structure[ dataType ] || [] ).push( func );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n// Base inspection function for prefilters and transports\n\tfunction inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {\n\n\t\tvar inspected = {},\n\t\t\tseekingTransport = ( structure === transports );\n\n\t\tfunction inspect( dataType ) {\n\t\t\tvar selected;\n\t\t\tinspected[ dataType ] = true;\n\t\t\tjQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {\n\t\t\t\tvar dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );\n\t\t\t\tif ( typeof dataTypeOrTransport === \"string\" &&\n\t\t\t\t\t!seekingTransport && !inspected[ dataTypeOrTransport ] ) {\n\n\t\t\t\t\toptions.dataTypes.unshift( dataTypeOrTransport );\n\t\t\t\t\tinspect( dataTypeOrTransport );\n\t\t\t\t\treturn false;\n\t\t\t\t} else if ( seekingTransport ) {\n\t\t\t\t\treturn !( selected = dataTypeOrTransport );\n\t\t\t\t}\n\t\t\t} );\n\t\t\treturn selected;\n\t\t}\n\n\t\treturn inspect( options.dataTypes[ 0 ] ) || !inspected[ \"*\" ] && inspect( \"*\" );\n\t}\n\n// A special extend for ajax options\n// that takes \"flat\" options (not to be deep extended)\n// Fixes #9887\n\tfunction ajaxExtend( target, src ) {\n\t\tvar deep, key,\n\t\t\tflatOptions = jQuery.ajaxSettings.flatOptions || {};\n\n\t\tfor ( key in src ) {\n\t\t\tif ( src[ key ] !== undefined ) {\n\t\t\t\t( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];\n\t\t\t}\n\t\t}\n\t\tif ( deep ) {\n\t\t\tjQuery.extend( true, target, deep );\n\t\t}\n\n\t\treturn target;\n\t}\n\n\t/* Handles responses to an ajax request:\n\t * - finds the right dataType (mediates between content-type and expected dataType)\n\t * - returns the corresponding response\n\t */\n\tfunction ajaxHandleResponses( s, jqXHR, responses ) {\n\t\tvar firstDataType, ct, finalDataType, type,\n\t\t\tcontents = s.contents,\n\t\t\tdataTypes = s.dataTypes;\n\n\t\t// Remove auto dataType and get content-type in the process\n\t\twhile ( dataTypes[ 0 ] === \"*\" ) {\n\t\t\tdataTypes.shift();\n\t\t\tif ( ct === undefined ) {\n\t\t\t\tct = s.mimeType || jqXHR.getResponseHeader( \"Content-Type\" );\n\t\t\t}\n\t\t}\n\n\t\t// Check if we're dealing with a known content-type\n\t\tif ( ct ) {\n\t\t\tfor ( type in contents ) {\n\t\t\t\tif ( contents[ type ] && contents[ type ].test( ct ) ) {\n\t\t\t\t\tdataTypes.unshift( type );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Check to see if we have a response for the expected dataType\n\t\tif ( dataTypes[ 0 ] in responses ) {\n\t\t\tfinalDataType = dataTypes[ 0 ];\n\t\t} else {\n\n\t\t\t// Try convertible dataTypes\n\t\t\tfor ( type in responses ) {\n\t\t\t\tif ( !dataTypes[ 0 ] || s.converters[ type + \" \" + dataTypes[ 0 ] ] ) {\n\t\t\t\t\tfinalDataType = type;\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tif ( !firstDataType ) {\n\t\t\t\t\tfirstDataType = type;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Or just use first one\n\t\t\tfinalDataType = finalDataType || firstDataType;\n\t\t}\n\n\t\t// If we found a dataType\n\t\t// We add the dataType to the list if needed\n\t\t// and return the corresponding response\n\t\tif ( finalDataType ) {\n\t\t\tif ( finalDataType !== dataTypes[ 0 ] ) {\n\t\t\t\tdataTypes.unshift( finalDataType );\n\t\t\t}\n\t\t\treturn responses[ finalDataType ];\n\t\t}\n\t}\n\n\t/* Chain conversions given the request and the original response\n\t * Also sets the responseXXX fields on the jqXHR instance\n\t */\n\tfunction ajaxConvert( s, response, jqXHR, isSuccess ) {\n\t\tvar conv2, current, conv, tmp, prev,\n\t\t\tconverters = {},\n\n\t\t\t// Work with a copy of dataTypes in case we need to modify it for conversion\n\t\t\tdataTypes = s.dataTypes.slice();\n\n\t\t// Create converters map with lowercased keys\n\t\tif ( dataTypes[ 1 ] ) {\n\t\t\tfor ( conv in s.converters ) {\n\t\t\t\tconverters[ conv.toLowerCase() ] = s.converters[ conv ];\n\t\t\t}\n\t\t}\n\n\t\tcurrent = dataTypes.shift();\n\n\t\t// Convert to each sequential dataType\n\t\twhile ( current ) {\n\n\t\t\tif ( s.responseFields[ current ] ) {\n\t\t\t\tjqXHR[ s.responseFields[ current ] ] = response;\n\t\t\t}\n\n\t\t\t// Apply the dataFilter if provided\n\t\t\tif ( !prev && isSuccess && s.dataFilter ) {\n\t\t\t\tresponse = s.dataFilter( response, s.dataType );\n\t\t\t}\n\n\t\t\tprev = current;\n\t\t\tcurrent = dataTypes.shift();\n\n\t\t\tif ( current ) {\n\n\t\t\t\t// There's only work to do if current dataType is non-auto\n\t\t\t\tif ( current === \"*\" ) {\n\n\t\t\t\t\tcurrent = prev;\n\n\t\t\t\t\t// Convert response if prev dataType is non-auto and differs from current\n\t\t\t\t} else if ( prev !== \"*\" && prev !== current ) {\n\n\t\t\t\t\t// Seek a direct converter\n\t\t\t\t\tconv = converters[ prev + \" \" + current ] || converters[ \"* \" + current ];\n\n\t\t\t\t\t// If none found, seek a pair\n\t\t\t\t\tif ( !conv ) {\n\t\t\t\t\t\tfor ( conv2 in converters ) {\n\n\t\t\t\t\t\t\t// If conv2 outputs current\n\t\t\t\t\t\t\ttmp = conv2.split( \" \" );\n\t\t\t\t\t\t\tif ( tmp[ 1 ] === current ) {\n\n\t\t\t\t\t\t\t\t// If prev can be converted to accepted input\n\t\t\t\t\t\t\t\tconv = converters[ prev + \" \" + tmp[ 0 ] ] ||\n\t\t\t\t\t\t\t\t\tconverters[ \"* \" + tmp[ 0 ] ];\n\t\t\t\t\t\t\t\tif ( conv ) {\n\n\t\t\t\t\t\t\t\t\t// Condense equivalence converters\n\t\t\t\t\t\t\t\t\tif ( conv === true ) {\n\t\t\t\t\t\t\t\t\t\tconv = converters[ conv2 ];\n\n\t\t\t\t\t\t\t\t\t\t// Otherwise, insert the intermediate dataType\n\t\t\t\t\t\t\t\t\t} else if ( converters[ conv2 ] !== true ) {\n\t\t\t\t\t\t\t\t\t\tcurrent = tmp[ 0 ];\n\t\t\t\t\t\t\t\t\t\tdataTypes.unshift( tmp[ 1 ] );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Apply converter (if not an equivalence)\n\t\t\t\t\tif ( conv !== true ) {\n\n\t\t\t\t\t\t// Unless errors are allowed to bubble, catch and return them\n\t\t\t\t\t\tif ( conv && s[ \"throws\" ] ) { // jscs:ignore requireDotNotation\n\t\t\t\t\t\t\tresponse = conv( response );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tresponse = conv( response );\n\t\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\t\tstate: \"parsererror\",\n\t\t\t\t\t\t\t\t\terror: conv ? e : \"No conversion from \" + prev + \" to \" + current\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn { state: \"success\", data: response };\n\t}\n\n\tjQuery.extend( {\n\n\t\t// Counter for holding the number of active queries\n\t\tactive: 0,\n\n\t\t// Last-Modified header cache for next request\n\t\tlastModified: {},\n\t\tetag: {},\n\n\t\tajaxSettings: {\n\t\t\turl: ajaxLocation,\n\t\t\ttype: \"GET\",\n\t\t\tisLocal: rlocalProtocol.test( ajaxLocParts[ 1 ] ),\n\t\t\tglobal: true,\n\t\t\tprocessData: true,\n\t\t\tasync: true,\n\t\t\tcontentType: \"application/x-www-form-urlencoded; charset=UTF-8\",\n\t\t\t/*\n\t\t\t timeout: 0,\n\t\t\t data: null,\n\t\t\t dataType: null,\n\t\t\t username: null,\n\t\t\t password: null,\n\t\t\t cache: null,\n\t\t\t throws: false,\n\t\t\t traditional: false,\n\t\t\t headers: {},\n\t\t\t */\n\n\t\t\taccepts: {\n\t\t\t\t\"*\": allTypes,\n\t\t\t\ttext: \"text/plain\",\n\t\t\t\thtml: \"text/html\",\n\t\t\t\txml: \"application/xml, text/xml\",\n\t\t\t\tjson: \"application/json, text/javascript\"\n\t\t\t},\n\n\t\t\tcontents: {\n\t\t\t\txml: /\\bxml\\b/,\n\t\t\t\thtml: /\\bhtml/,\n\t\t\t\tjson: /\\bjson\\b/\n\t\t\t},\n\n\t\t\tresponseFields: {\n\t\t\t\txml: \"responseXML\",\n\t\t\t\ttext: \"responseText\",\n\t\t\t\tjson: \"responseJSON\"\n\t\t\t},\n\n\t\t\t// Data converters\n\t\t\t// Keys separate source (or catchall \"*\") and destination types with a single space\n\t\t\tconverters: {\n\n\t\t\t\t// Convert anything to text\n\t\t\t\t\"* text\": String,\n\n\t\t\t\t// Text to html (true = no transformation)\n\t\t\t\t\"text html\": true,\n\n\t\t\t\t// Evaluate text as a json expression\n\t\t\t\t\"text json\": jQuery.parseJSON,\n\n\t\t\t\t// Parse text as xml\n\t\t\t\t\"text xml\": jQuery.parseXML\n\t\t\t},\n\n\t\t\t// For options that shouldn't be deep extended:\n\t\t\t// you can add your own custom options here if\n\t\t\t// and when you create one that shouldn't be\n\t\t\t// deep extended (see ajaxExtend)\n\t\t\tflatOptions: {\n\t\t\t\turl: true,\n\t\t\t\tcontext: true\n\t\t\t}\n\t\t},\n\n\t\t// Creates a full fledged settings object into target\n\t\t// with both ajaxSettings and settings fields.\n\t\t// If target is omitted, writes into ajaxSettings.\n\t\tajaxSetup: function( target, settings ) {\n\t\t\treturn settings ?\n\n\t\t\t\t// Building a settings object\n\t\t\t\tajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :\n\n\t\t\t\t// Extending ajaxSettings\n\t\t\t\tajaxExtend( jQuery.ajaxSettings, target );\n\t\t},\n\n\t\tajaxPrefilter: addToPrefiltersOrTransports( prefilters ),\n\t\tajaxTransport: addToPrefiltersOrTransports( transports ),\n\n\t\t// Main method\n\t\tajax: function( url, options ) {\n\n\t\t\t// If url is an object, simulate pre-1.5 signature\n\t\t\tif ( typeof url === \"object\" ) {\n\t\t\t\toptions = url;\n\t\t\t\turl = undefined;\n\t\t\t}\n\n\t\t\t// Force options to be an object\n\t\t\toptions = options || {};\n\n\t\t\tvar\n\n\t\t\t\t// Cross-domain detection vars\n\t\t\t\tparts,\n\n\t\t\t\t// Loop variable\n\t\t\t\ti,\n\n\t\t\t\t// URL without anti-cache param\n\t\t\t\tcacheURL,\n\n\t\t\t\t// Response headers as string\n\t\t\t\tresponseHeadersString,\n\n\t\t\t\t// timeout handle\n\t\t\t\ttimeoutTimer,\n\n\t\t\t\t// To know if global events are to be dispatched\n\t\t\t\tfireGlobals,\n\n\t\t\t\ttransport,\n\n\t\t\t\t// Response headers\n\t\t\t\tresponseHeaders,\n\n\t\t\t\t// Create the final options object\n\t\t\t\ts = jQuery.ajaxSetup( {}, options ),\n\n\t\t\t\t// Callbacks context\n\t\t\t\tcallbackContext = s.context || s,\n\n\t\t\t\t// Context for global events is callbackContext if it is a DOM node or jQuery collection\n\t\t\t\tglobalEventContext = s.context &&\n\t\t\t\t( callbackContext.nodeType || callbackContext.jquery ) ?\n\t\t\t\t\tjQuery( callbackContext ) :\n\t\t\t\t\tjQuery.event,\n\n\t\t\t\t// Deferreds\n\t\t\t\tdeferred = jQuery.Deferred(),\n\t\t\t\tcompleteDeferred = jQuery.Callbacks( \"once memory\" ),\n\n\t\t\t\t// Status-dependent callbacks\n\t\t\t\tstatusCode = s.statusCode || {},\n\n\t\t\t\t// Headers (they are sent all at once)\n\t\t\t\trequestHeaders = {},\n\t\t\t\trequestHeadersNames = {},\n\n\t\t\t\t// The jqXHR state\n\t\t\t\tstate = 0,\n\n\t\t\t\t// Default abort message\n\t\t\t\tstrAbort = \"canceled\",\n\n\t\t\t\t// Fake xhr\n\t\t\t\tjqXHR = {\n\t\t\t\t\treadyState: 0,\n\n\t\t\t\t\t// Builds headers hashtable if needed\n\t\t\t\t\tgetResponseHeader: function( key ) {\n\t\t\t\t\t\tvar match;\n\t\t\t\t\t\tif ( state === 2 ) {\n\t\t\t\t\t\t\tif ( !responseHeaders ) {\n\t\t\t\t\t\t\t\tresponseHeaders = {};\n\t\t\t\t\t\t\t\twhile ( ( match = rheaders.exec( responseHeadersString ) ) ) {\n\t\t\t\t\t\t\t\t\tresponseHeaders[ match[ 1 ].toLowerCase() ] = match[ 2 ];\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tmatch = responseHeaders[ key.toLowerCase() ];\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn match == null ? null : match;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Raw string\n\t\t\t\t\tgetAllResponseHeaders: function() {\n\t\t\t\t\t\treturn state === 2 ? responseHeadersString : null;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Caches the header\n\t\t\t\t\tsetRequestHeader: function( name, value ) {\n\t\t\t\t\t\tvar lname = name.toLowerCase();\n\t\t\t\t\t\tif ( !state ) {\n\t\t\t\t\t\t\tname = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;\n\t\t\t\t\t\t\trequestHeaders[ name ] = value;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Overrides response content-type header\n\t\t\t\t\toverrideMimeType: function( type ) {\n\t\t\t\t\t\tif ( !state ) {\n\t\t\t\t\t\t\ts.mimeType = type;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Status-dependent callbacks\n\t\t\t\t\tstatusCode: function( map ) {\n\t\t\t\t\t\tvar code;\n\t\t\t\t\t\tif ( map ) {\n\t\t\t\t\t\t\tif ( state < 2 ) {\n\t\t\t\t\t\t\t\tfor ( code in map ) {\n\n\t\t\t\t\t\t\t\t\t// Lazy-add the new callback in a way that preserves old ones\n\t\t\t\t\t\t\t\t\tstatusCode[ code ] = [ statusCode[ code ], map[ code ] ];\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\t\t// Execute the appropriate callbacks\n\t\t\t\t\t\t\t\tjqXHR.always( map[ jqXHR.status ] );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Cancel the request\n\t\t\t\t\tabort: function( statusText ) {\n\t\t\t\t\t\tvar finalText = statusText || strAbort;\n\t\t\t\t\t\tif ( transport ) {\n\t\t\t\t\t\t\ttransport.abort( finalText );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tdone( 0, finalText );\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t// Attach deferreds\n\t\t\tdeferred.promise( jqXHR ).complete = completeDeferred.add;\n\t\t\tjqXHR.success = jqXHR.done;\n\t\t\tjqXHR.error = jqXHR.fail;\n\n\t\t\t// Remove hash character (#7531: and string promotion)\n\t\t\t// Add protocol if not provided (#5866: IE7 issue with protocol-less urls)\n\t\t\t// Handle falsy url in the settings object (#10093: consistency with old signature)\n\t\t\t// We also use the url parameter if available\n\t\t\ts.url = ( ( url || s.url || ajaxLocation ) + \"\" )\n\t\t\t\t.replace( rhash, \"\" )\n\t\t\t\t.replace( rprotocol, ajaxLocParts[ 1 ] + \"//\" );\n\n\t\t\t// Alias method option to type as per ticket #12004\n\t\t\ts.type = options.method || options.type || s.method || s.type;\n\n\t\t\t// Extract dataTypes list\n\t\t\ts.dataTypes = jQuery.trim( s.dataType || \"*\" ).toLowerCase().match( rnotwhite ) || [ \"\" ];\n\n\t\t\t// A cross-domain request is in order when we have a protocol:host:port mismatch\n\t\t\tif ( s.crossDomain == null ) {\n\t\t\t\tparts = rurl.exec( s.url.toLowerCase() );\n\t\t\t\ts.crossDomain = !!( parts &&\n\t\t\t\t\t( parts[ 1 ] !== ajaxLocParts[ 1 ] || parts[ 2 ] !== ajaxLocParts[ 2 ] ||\n\t\t\t\t\t( parts[ 3 ] || ( parts[ 1 ] === \"http:\" ? \"80\" : \"443\" ) ) !==\n\t\t\t\t\t( ajaxLocParts[ 3 ] || ( ajaxLocParts[ 1 ] === \"http:\" ? \"80\" : \"443\" ) ) )\n\t\t\t\t);\n\t\t\t}\n\n\t\t\t// Convert data if not already a string\n\t\t\tif ( s.data && s.processData && typeof s.data !== \"string\" ) {\n\t\t\t\ts.data = jQuery.param( s.data, s.traditional );\n\t\t\t}\n\n\t\t\t// Apply prefilters\n\t\t\tinspectPrefiltersOrTransports( prefilters, s, options, jqXHR );\n\n\t\t\t// If request was aborted inside a prefilter, stop there\n\t\t\tif ( state === 2 ) {\n\t\t\t\treturn jqXHR;\n\t\t\t}\n\n\t\t\t// We can fire global events as of now if asked to\n\t\t\t// Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)\n\t\t\tfireGlobals = jQuery.event && s.global;\n\n\t\t\t// Watch for a new set of requests\n\t\t\tif ( fireGlobals && jQuery.active++ === 0 ) {\n\t\t\t\tjQuery.event.trigger( \"ajaxStart\" );\n\t\t\t}\n\n\t\t\t// Uppercase the type\n\t\t\ts.type = s.type.toUpperCase();\n\n\t\t\t// Determine if request has content\n\t\t\ts.hasContent = !rnoContent.test( s.type );\n\n\t\t\t// Save the URL in case we're toying with the If-Modified-Since\n\t\t\t// and/or If-None-Match header later on\n\t\t\tcacheURL = s.url;\n\n\t\t\t// More options handling for requests with no content\n\t\t\tif ( !s.hasContent ) {\n\n\t\t\t\t// If data is available, append data to url\n\t\t\t\tif ( s.data ) {\n\t\t\t\t\tcacheURL = ( s.url += ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + s.data );\n\n\t\t\t\t\t// #9682: remove data so that it's not used in an eventual retry\n\t\t\t\t\tdelete s.data;\n\t\t\t\t}\n\n\t\t\t\t// Add anti-cache in url if needed\n\t\t\t\tif ( s.cache === false ) {\n\t\t\t\t\ts.url = rts.test( cacheURL ) ?\n\n\t\t\t\t\t\t// If there is already a '_' parameter, set its value\n\t\t\t\t\t\tcacheURL.replace( rts, \"$1_=\" + nonce++ ) :\n\n\t\t\t\t\t\t// Otherwise add one to the end\n\t\t\t\t\tcacheURL + ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + \"_=\" + nonce++;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n\t\t\tif ( s.ifModified ) {\n\t\t\t\tif ( jQuery.lastModified[ cacheURL ] ) {\n\t\t\t\t\tjqXHR.setRequestHeader( \"If-Modified-Since\", jQuery.lastModified[ cacheURL ] );\n\t\t\t\t}\n\t\t\t\tif ( jQuery.etag[ cacheURL ] ) {\n\t\t\t\t\tjqXHR.setRequestHeader( \"If-None-Match\", jQuery.etag[ cacheURL ] );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set the correct header, if data is being sent\n\t\t\tif ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {\n\t\t\t\tjqXHR.setRequestHeader( \"Content-Type\", s.contentType );\n\t\t\t}\n\n\t\t\t// Set the Accepts header for the server, depending on the dataType\n\t\t\tjqXHR.setRequestHeader(\n\t\t\t\t\"Accept\",\n\t\t\t\ts.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?\n\t\t\t\ts.accepts[ s.dataTypes[ 0 ] ] +\n\t\t\t\t( s.dataTypes[ 0 ] !== \"*\" ? \", \" + allTypes + \"; q=0.01\" : \"\" ) :\n\t\t\t\t\ts.accepts[ \"*\" ]\n\t\t\t);\n\n\t\t\t// Check for headers option\n\t\t\tfor ( i in s.headers ) {\n\t\t\t\tjqXHR.setRequestHeader( i, s.headers[ i ] );\n\t\t\t}\n\n\t\t\t// Allow custom headers/mimetypes and early abort\n\t\t\tif ( s.beforeSend &&\n\t\t\t\t( s.beforeSend.call( callbackContext, jqXHR, s ) === false || state === 2 ) ) {\n\n\t\t\t\t// Abort if not done already and return\n\t\t\t\treturn jqXHR.abort();\n\t\t\t}\n\n\t\t\t// aborting is no longer a cancellation\n\t\t\tstrAbort = \"abort\";\n\n\t\t\t// Install callbacks on deferreds\n\t\t\tfor ( i in { success: 1, error: 1, complete: 1 } ) {\n\t\t\t\tjqXHR[ i ]( s[ i ] );\n\t\t\t}\n\n\t\t\t// Get transport\n\t\t\ttransport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );\n\n\t\t\t// If no transport, we auto-abort\n\t\t\tif ( !transport ) {\n\t\t\t\tdone( -1, \"No Transport\" );\n\t\t\t} else {\n\t\t\t\tjqXHR.readyState = 1;\n\n\t\t\t\t// Send global event\n\t\t\t\tif ( fireGlobals ) {\n\t\t\t\t\tglobalEventContext.trigger( \"ajaxSend\", [ jqXHR, s ] );\n\t\t\t\t}\n\n\t\t\t\t// If request was aborted inside ajaxSend, stop there\n\t\t\t\tif ( state === 2 ) {\n\t\t\t\t\treturn jqXHR;\n\t\t\t\t}\n\n\t\t\t\t// Timeout\n\t\t\t\tif ( s.async && s.timeout > 0 ) {\n\t\t\t\t\ttimeoutTimer = window.setTimeout( function() {\n\t\t\t\t\t\tjqXHR.abort( \"timeout\" );\n\t\t\t\t\t}, s.timeout );\n\t\t\t\t}\n\n\t\t\t\ttry {\n\t\t\t\t\tstate = 1;\n\t\t\t\t\ttransport.send( requestHeaders, done );\n\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t// Propagate exception as error if not done\n\t\t\t\t\tif ( state < 2 ) {\n\t\t\t\t\t\tdone( -1, e );\n\n\t\t\t\t\t\t// Simply rethrow otherwise\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthrow e;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Callback for when everything is done\n\t\t\tfunction done( status, nativeStatusText, responses, headers ) {\n\t\t\t\tvar isSuccess, success, error, response, modified,\n\t\t\t\t\tstatusText = nativeStatusText;\n\n\t\t\t\t// Called once\n\t\t\t\tif ( state === 2 ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// State is \"done\" now\n\t\t\t\tstate = 2;\n\n\t\t\t\t// Clear timeout if it exists\n\t\t\t\tif ( timeoutTimer ) {\n\t\t\t\t\twindow.clearTimeout( timeoutTimer );\n\t\t\t\t}\n\n\t\t\t\t// Dereference transport for early garbage collection\n\t\t\t\t// (no matter how long the jqXHR object will be used)\n\t\t\t\ttransport = undefined;\n\n\t\t\t\t// Cache response headers\n\t\t\t\tresponseHeadersString = headers || \"\";\n\n\t\t\t\t// Set readyState\n\t\t\t\tjqXHR.readyState = status > 0 ? 4 : 0;\n\n\t\t\t\t// Determine if successful\n\t\t\t\tisSuccess = status >= 200 && status < 300 || status === 304;\n\n\t\t\t\t// Get response data\n\t\t\t\tif ( responses ) {\n\t\t\t\t\tresponse = ajaxHandleResponses( s, jqXHR, responses );\n\t\t\t\t}\n\n\t\t\t\t// Convert no matter what (that way responseXXX fields are always set)\n\t\t\t\tresponse = ajaxConvert( s, response, jqXHR, isSuccess );\n\n\t\t\t\t// If successful, handle type chaining\n\t\t\t\tif ( isSuccess ) {\n\n\t\t\t\t\t// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n\t\t\t\t\tif ( s.ifModified ) {\n\t\t\t\t\t\tmodified = jqXHR.getResponseHeader( \"Last-Modified\" );\n\t\t\t\t\t\tif ( modified ) {\n\t\t\t\t\t\t\tjQuery.lastModified[ cacheURL ] = modified;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tmodified = jqXHR.getResponseHeader( \"etag\" );\n\t\t\t\t\t\tif ( modified ) {\n\t\t\t\t\t\t\tjQuery.etag[ cacheURL ] = modified;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// if no content\n\t\t\t\t\tif ( status === 204 || s.type === \"HEAD\" ) {\n\t\t\t\t\t\tstatusText = \"nocontent\";\n\n\t\t\t\t\t\t// if not modified\n\t\t\t\t\t} else if ( status === 304 ) {\n\t\t\t\t\t\tstatusText = \"notmodified\";\n\n\t\t\t\t\t\t// If we have data, let's convert it\n\t\t\t\t\t} else {\n\t\t\t\t\t\tstatusText = response.state;\n\t\t\t\t\t\tsuccess = response.data;\n\t\t\t\t\t\terror = response.error;\n\t\t\t\t\t\tisSuccess = !error;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\n\t\t\t\t\t// We extract error from statusText\n\t\t\t\t\t// then normalize statusText and status for non-aborts\n\t\t\t\t\terror = statusText;\n\t\t\t\t\tif ( status || !statusText ) {\n\t\t\t\t\t\tstatusText = \"error\";\n\t\t\t\t\t\tif ( status < 0 ) {\n\t\t\t\t\t\t\tstatus = 0;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Set data for the fake xhr object\n\t\t\t\tjqXHR.status = status;\n\t\t\t\tjqXHR.statusText = ( nativeStatusText || statusText ) + \"\";\n\n\t\t\t\t// Success/Error\n\t\t\t\tif ( isSuccess ) {\n\t\t\t\t\tdeferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );\n\t\t\t\t} else {\n\t\t\t\t\tdeferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );\n\t\t\t\t}\n\n\t\t\t\t// Status-dependent callbacks\n\t\t\t\tjqXHR.statusCode( statusCode );\n\t\t\t\tstatusCode = undefined;\n\n\t\t\t\tif ( fireGlobals ) {\n\t\t\t\t\tglobalEventContext.trigger( isSuccess ? \"ajaxSuccess\" : \"ajaxError\",\n\t\t\t\t\t\t[ jqXHR, s, isSuccess ? success : error ] );\n\t\t\t\t}\n\n\t\t\t\t// Complete\n\t\t\t\tcompleteDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );\n\n\t\t\t\tif ( fireGlobals ) {\n\t\t\t\t\tglobalEventContext.trigger( \"ajaxComplete\", [ jqXHR, s ] );\n\n\t\t\t\t\t// Handle the global AJAX counter\n\t\t\t\t\tif ( !( --jQuery.active ) ) {\n\t\t\t\t\t\tjQuery.event.trigger( \"ajaxStop\" );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn jqXHR;\n\t\t},\n\n\t\tgetJSON: function( url, data, callback ) {\n\t\t\treturn jQuery.get( url, data, callback, \"json\" );\n\t\t},\n\n\t\tgetScript: function( url, callback ) {\n\t\t\treturn jQuery.get( url, undefined, callback, \"script\" );\n\t\t}\n\t} );\n\n\tjQuery.each( [ \"get\", \"post\" ], function( i, method ) {\n\t\tjQuery[ method ] = function( url, data, callback, type ) {\n\n\t\t\t// shift arguments if data argument was omitted\n\t\t\tif ( jQuery.isFunction( data ) ) {\n\t\t\t\ttype = type || callback;\n\t\t\t\tcallback = data;\n\t\t\t\tdata = undefined;\n\t\t\t}\n\n\t\t\t// The url can be an options object (which then must have .url)\n\t\t\treturn jQuery.ajax( jQuery.extend( {\n\t\t\t\turl: url,\n\t\t\t\ttype: method,\n\t\t\t\tdataType: type,\n\t\t\t\tdata: data,\n\t\t\t\tsuccess: callback\n\t\t\t}, jQuery.isPlainObject( url ) && url ) );\n\t\t};\n\t} );\n\n\n\tjQuery._evalUrl = function( url ) {\n\t\treturn jQuery.ajax( {\n\t\t\turl: url,\n\n\t\t\t// Make this explicit, since user can override this through ajaxSetup (#11264)\n\t\t\ttype: \"GET\",\n\t\t\tdataType: \"script\",\n\t\t\tcache: true,\n\t\t\tasync: false,\n\t\t\tglobal: false,\n\t\t\t\"throws\": true\n\t\t} );\n\t};\n\n\n\tjQuery.fn.extend( {\n\t\twrapAll: function( html ) {\n\t\t\tif ( jQuery.isFunction( html ) ) {\n\t\t\t\treturn this.each( function( i ) {\n\t\t\t\t\tjQuery( this ).wrapAll( html.call( this, i ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( this[ 0 ] ) {\n\n\t\t\t\t// The elements to wrap the target around\n\t\t\t\tvar wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );\n\n\t\t\t\tif ( this[ 0 ].parentNode ) {\n\t\t\t\t\twrap.insertBefore( this[ 0 ] );\n\t\t\t\t}\n\n\t\t\t\twrap.map( function() {\n\t\t\t\t\tvar elem = this;\n\n\t\t\t\t\twhile ( elem.firstChild && elem.firstChild.nodeType === 1 ) {\n\t\t\t\t\t\telem = elem.firstChild;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn elem;\n\t\t\t\t} ).append( this );\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\twrapInner: function( html ) {\n\t\t\tif ( jQuery.isFunction( html ) ) {\n\t\t\t\treturn this.each( function( i ) {\n\t\t\t\t\tjQuery( this ).wrapInner( html.call( this, i ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tvar self = jQuery( this ),\n\t\t\t\t\tcontents = self.contents();\n\n\t\t\t\tif ( contents.length ) {\n\t\t\t\t\tcontents.wrapAll( html );\n\n\t\t\t\t} else {\n\t\t\t\t\tself.append( html );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\twrap: function( html ) {\n\t\t\tvar isFunction = jQuery.isFunction( html );\n\n\t\t\treturn this.each( function( i ) {\n\t\t\t\tjQuery( this ).wrapAll( isFunction ? html.call( this, i ) : html );\n\t\t\t} );\n\t\t},\n\n\t\tunwrap: function() {\n\t\t\treturn this.parent().each( function() {\n\t\t\t\tif ( !jQuery.nodeName( this, \"body\" ) ) {\n\t\t\t\t\tjQuery( this ).replaceWith( this.childNodes );\n\t\t\t\t}\n\t\t\t} ).end();\n\t\t}\n\t} );\n\n\n\tfunction getDisplay( elem ) {\n\t\treturn elem.style && elem.style.display || jQuery.css( elem, \"display\" );\n\t}\n\n\tfunction filterHidden( elem ) {\n\n\t\t// Disconnected elements are considered hidden\n\t\tif ( !jQuery.contains( elem.ownerDocument || document, elem ) ) {\n\t\t\treturn true;\n\t\t}\n\t\twhile ( elem && elem.nodeType === 1 ) {\n\t\t\tif ( getDisplay( elem ) === \"none\" || elem.type === \"hidden\" ) {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\telem = elem.parentNode;\n\t\t}\n\t\treturn false;\n\t}\n\n\tjQuery.expr.filters.hidden = function( elem ) {\n\n\t\t// Support: Opera <= 12.12\n\t\t// Opera reports offsetWidths and offsetHeights less than zero on some elements\n\t\treturn support.reliableHiddenOffsets() ?\n\t\t\t( elem.offsetWidth <= 0 && elem.offsetHeight <= 0 &&\n\t\t\t!elem.getClientRects().length ) :\n\t\t\tfilterHidden( elem );\n\t};\n\n\tjQuery.expr.filters.visible = function( elem ) {\n\t\treturn !jQuery.expr.filters.hidden( elem );\n\t};\n\n\n\n\n\tvar r20 = /%20/g,\n\t\trbracket = /\\[\\]$/,\n\t\trCRLF = /\\r?\\n/g,\n\t\trsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,\n\t\trsubmittable = /^(?:input|select|textarea|keygen)/i;\n\n\tfunction buildParams( prefix, obj, traditional, add ) {\n\t\tvar name;\n\n\t\tif ( jQuery.isArray( obj ) ) {\n\n\t\t\t// Serialize array item.\n\t\t\tjQuery.each( obj, function( i, v ) {\n\t\t\t\tif ( traditional || rbracket.test( prefix ) ) {\n\n\t\t\t\t\t// Treat each array item as a scalar.\n\t\t\t\t\tadd( prefix, v );\n\n\t\t\t\t} else {\n\n\t\t\t\t\t// Item is non-scalar (array or object), encode its numeric index.\n\t\t\t\t\tbuildParams(\n\t\t\t\t\t\tprefix + \"[\" + ( typeof v === \"object\" && v != null ? i : \"\" ) + \"]\",\n\t\t\t\t\t\tv,\n\t\t\t\t\t\ttraditional,\n\t\t\t\t\t\tadd\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t} );\n\n\t\t} else if ( !traditional && jQuery.type( obj ) === \"object\" ) {\n\n\t\t\t// Serialize object item.\n\t\t\tfor ( name in obj ) {\n\t\t\t\tbuildParams( prefix + \"[\" + name + \"]\", obj[ name ], traditional, add );\n\t\t\t}\n\n\t\t} else {\n\n\t\t\t// Serialize scalar item.\n\t\t\tadd( prefix, obj );\n\t\t}\n\t}\n\n// Serialize an array of form elements or a set of\n// key/values into a query string\n\tjQuery.param = function( a, traditional ) {\n\t\tvar prefix,\n\t\t\ts = [],\n\t\t\tadd = function( key, value ) {\n\n\t\t\t\t// If value is a function, invoke it and return its value\n\t\t\t\tvalue = jQuery.isFunction( value ) ? value() : ( value == null ? \"\" : value );\n\t\t\t\ts[ s.length ] = encodeURIComponent( key ) + \"=\" + encodeURIComponent( value );\n\t\t\t};\n\n\t\t// Set traditional to true for jQuery <= 1.3.2 behavior.\n\t\tif ( traditional === undefined ) {\n\t\t\ttraditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;\n\t\t}\n\n\t\t// If an array was passed in, assume that it is an array of form elements.\n\t\tif ( jQuery.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {\n\n\t\t\t// Serialize the form elements\n\t\t\tjQuery.each( a, function() {\n\t\t\t\tadd( this.name, this.value );\n\t\t\t} );\n\n\t\t} else {\n\n\t\t\t// If traditional, encode the \"old\" way (the way 1.3.2 or older\n\t\t\t// did it), otherwise encode params recursively.\n\t\t\tfor ( prefix in a ) {\n\t\t\t\tbuildParams( prefix, a[ prefix ], traditional, add );\n\t\t\t}\n\t\t}\n\n\t\t// Return the resulting serialization\n\t\treturn s.join( \"&\" ).replace( r20, \"+\" );\n\t};\n\n\tjQuery.fn.extend( {\n\t\tserialize: function() {\n\t\t\treturn jQuery.param( this.serializeArray() );\n\t\t},\n\t\tserializeArray: function() {\n\t\t\treturn this.map( function() {\n\n\t\t\t\t// Can add propHook for \"elements\" to filter or add form elements\n\t\t\t\tvar elements = jQuery.prop( this, \"elements\" );\n\t\t\t\treturn elements ? jQuery.makeArray( elements ) : this;\n\t\t\t} )\n\t\t\t\t.filter( function() {\n\t\t\t\t\tvar type = this.type;\n\n\t\t\t\t\t// Use .is(\":disabled\") so that fieldset[disabled] works\n\t\t\t\t\treturn this.name && !jQuery( this ).is( \":disabled\" ) &&\n\t\t\t\t\t\trsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&\n\t\t\t\t\t\t( this.checked || !rcheckableType.test( type ) );\n\t\t\t\t} )\n\t\t\t\t.map( function( i, elem ) {\n\t\t\t\t\tvar val = jQuery( this ).val();\n\n\t\t\t\t\treturn val == null ?\n\t\t\t\t\t\tnull :\n\t\t\t\t\t\tjQuery.isArray( val ) ?\n\t\t\t\t\t\t\tjQuery.map( val, function( val ) {\n\t\t\t\t\t\t\t\treturn { name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n\t\t\t\t\t\t\t} ) :\n\t\t\t\t\t\t{ name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n\t\t\t\t} ).get();\n\t\t}\n\t} );\n\n\n// Create the request object\n// (This is still attached to ajaxSettings for backward compatibility)\n\tjQuery.ajaxSettings.xhr = window.ActiveXObject !== undefined ?\n\n\t\t// Support: IE6-IE8\n\t\tfunction() {\n\n\t\t\t// XHR cannot access local files, always use ActiveX for that case\n\t\t\tif ( this.isLocal ) {\n\t\t\t\treturn createActiveXHR();\n\t\t\t}\n\n\t\t\t// Support: IE 9-11\n\t\t\t// IE seems to error on cross-domain PATCH requests when ActiveX XHR\n\t\t\t// is used. In IE 9+ always use the native XHR.\n\t\t\t// Note: this condition won't catch Edge as it doesn't define\n\t\t\t// document.documentMode but it also doesn't support ActiveX so it won't\n\t\t\t// reach this code.\n\t\t\tif ( document.documentMode > 8 ) {\n\t\t\t\treturn createStandardXHR();\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// oldIE XHR does not support non-RFC2616 methods (#13240)\n\t\t\t// See http://msdn.microsoft.com/en-us/library/ie/ms536648(v=vs.85).aspx\n\t\t\t// and http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9\n\t\t\t// Although this check for six methods instead of eight\n\t\t\t// since IE also does not support \"trace\" and \"connect\"\n\t\t\treturn /^(get|post|head|put|delete|options)$/i.test( this.type ) &&\n\t\t\t\tcreateStandardXHR() || createActiveXHR();\n\t\t} :\n\n\t\t// For all other browsers, use the standard XMLHttpRequest object\n\t\tcreateStandardXHR;\n\n\tvar xhrId = 0,\n\t\txhrCallbacks = {},\n\t\txhrSupported = jQuery.ajaxSettings.xhr();\n\n// Support: IE<10\n// Open requests must be manually aborted on unload (#5280)\n// See https://support.microsoft.com/kb/2856746 for more info\n\tif ( window.attachEvent ) {\n\t\twindow.attachEvent( \"onunload\", function() {\n\t\t\tfor ( var key in xhrCallbacks ) {\n\t\t\t\txhrCallbacks[ key ]( undefined, true );\n\t\t\t}\n\t\t} );\n\t}\n\n// Determine support properties\n\tsupport.cors = !!xhrSupported && ( \"withCredentials\" in xhrSupported );\n\txhrSupported = support.ajax = !!xhrSupported;\n\n// Create transport if the browser can provide an xhr\n\tif ( xhrSupported ) {\n\n\t\tjQuery.ajaxTransport( function( options ) {\n\n\t\t\t// Cross domain only allowed if supported through XMLHttpRequest\n\t\t\tif ( !options.crossDomain || support.cors ) {\n\n\t\t\t\tvar callback;\n\n\t\t\t\treturn {\n\t\t\t\t\tsend: function( headers, complete ) {\n\t\t\t\t\t\tvar i,\n\t\t\t\t\t\t\txhr = options.xhr(),\n\t\t\t\t\t\t\tid = ++xhrId;\n\n\t\t\t\t\t\t// Open the socket\n\t\t\t\t\t\txhr.open(\n\t\t\t\t\t\t\toptions.type,\n\t\t\t\t\t\t\toptions.url,\n\t\t\t\t\t\t\toptions.async,\n\t\t\t\t\t\t\toptions.username,\n\t\t\t\t\t\t\toptions.password\n\t\t\t\t\t\t);\n\n\t\t\t\t\t\t// Apply custom fields if provided\n\t\t\t\t\t\tif ( options.xhrFields ) {\n\t\t\t\t\t\t\tfor ( i in options.xhrFields ) {\n\t\t\t\t\t\t\t\txhr[ i ] = options.xhrFields[ i ];\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Override mime type if needed\n\t\t\t\t\t\tif ( options.mimeType && xhr.overrideMimeType ) {\n\t\t\t\t\t\t\txhr.overrideMimeType( options.mimeType );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// X-Requested-With header\n\t\t\t\t\t\t// For cross-domain requests, seeing as conditions for a preflight are\n\t\t\t\t\t\t// akin to a jigsaw puzzle, we simply never set it to be sure.\n\t\t\t\t\t\t// (it can always be set on a per-request basis or even using ajaxSetup)\n\t\t\t\t\t\t// For same-domain requests, won't change header if already provided.\n\t\t\t\t\t\tif ( !options.crossDomain && !headers[ \"X-Requested-With\" ] ) {\n\t\t\t\t\t\t\theaders[ \"X-Requested-With\" ] = \"XMLHttpRequest\";\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Set headers\n\t\t\t\t\t\tfor ( i in headers ) {\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// IE's ActiveXObject throws a 'Type Mismatch' exception when setting\n\t\t\t\t\t\t\t// request header to a null-value.\n\t\t\t\t\t\t\t//\n\t\t\t\t\t\t\t// To keep consistent with other XHR implementations, cast the value\n\t\t\t\t\t\t\t// to string and ignore `undefined`.\n\t\t\t\t\t\t\tif ( headers[ i ] !== undefined ) {\n\t\t\t\t\t\t\t\txhr.setRequestHeader( i, headers[ i ] + \"\" );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Do send the request\n\t\t\t\t\t\t// This may raise an exception which is actually\n\t\t\t\t\t\t// handled in jQuery.ajax (so no try/catch here)\n\t\t\t\t\t\txhr.send( ( options.hasContent && options.data ) || null );\n\n\t\t\t\t\t\t// Listener\n\t\t\t\t\t\tcallback = function( _, isAbort ) {\n\t\t\t\t\t\t\tvar status, statusText, responses;\n\n\t\t\t\t\t\t\t// Was never called and is aborted or complete\n\t\t\t\t\t\t\tif ( callback && ( isAbort || xhr.readyState === 4 ) ) {\n\n\t\t\t\t\t\t\t\t// Clean up\n\t\t\t\t\t\t\t\tdelete xhrCallbacks[ id ];\n\t\t\t\t\t\t\t\tcallback = undefined;\n\t\t\t\t\t\t\t\txhr.onreadystatechange = jQuery.noop;\n\n\t\t\t\t\t\t\t\t// Abort manually if needed\n\t\t\t\t\t\t\t\tif ( isAbort ) {\n\t\t\t\t\t\t\t\t\tif ( xhr.readyState !== 4 ) {\n\t\t\t\t\t\t\t\t\t\txhr.abort();\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tresponses = {};\n\t\t\t\t\t\t\t\t\tstatus = xhr.status;\n\n\t\t\t\t\t\t\t\t\t// Support: IE<10\n\t\t\t\t\t\t\t\t\t// Accessing binary-data responseText throws an exception\n\t\t\t\t\t\t\t\t\t// (#11426)\n\t\t\t\t\t\t\t\t\tif ( typeof xhr.responseText === \"string\" ) {\n\t\t\t\t\t\t\t\t\t\tresponses.text = xhr.responseText;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Firefox throws an exception when accessing\n\t\t\t\t\t\t\t\t\t// statusText for faulty cross-domain requests\n\t\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\t\tstatusText = xhr.statusText;\n\t\t\t\t\t\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t\t\t\t\t\t// We normalize with Webkit giving an empty statusText\n\t\t\t\t\t\t\t\t\t\tstatusText = \"\";\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Filter status for non standard behaviors\n\n\t\t\t\t\t\t\t\t\t// If the request is local and we have data: assume a success\n\t\t\t\t\t\t\t\t\t// (success with no data won't get notified, that's the best we\n\t\t\t\t\t\t\t\t\t// can do given current implementations)\n\t\t\t\t\t\t\t\t\tif ( !status && options.isLocal && !options.crossDomain ) {\n\t\t\t\t\t\t\t\t\t\tstatus = responses.text ? 200 : 404;\n\n\t\t\t\t\t\t\t\t\t\t// IE - #1450: sometimes returns 1223 when it should be 204\n\t\t\t\t\t\t\t\t\t} else if ( status === 1223 ) {\n\t\t\t\t\t\t\t\t\t\tstatus = 204;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Call complete if needed\n\t\t\t\t\t\t\tif ( responses ) {\n\t\t\t\t\t\t\t\tcomplete( status, statusText, responses, xhr.getAllResponseHeaders() );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\t// Do send the request\n\t\t\t\t\t\t// `xhr.send` may raise an exception, but it will be\n\t\t\t\t\t\t// handled in jQuery.ajax (so no try/catch here)\n\t\t\t\t\t\tif ( !options.async ) {\n\n\t\t\t\t\t\t\t// If we're in sync mode we fire the callback\n\t\t\t\t\t\t\tcallback();\n\t\t\t\t\t\t} else if ( xhr.readyState === 4 ) {\n\n\t\t\t\t\t\t\t// (IE6 & IE7) if it's in cache and has been\n\t\t\t\t\t\t\t// retrieved directly we need to fire the callback\n\t\t\t\t\t\t\twindow.setTimeout( callback );\n\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\t// Register the callback, but delay it in case `xhr.send` throws\n\t\t\t\t\t\t\t// Add to the list of active xhr callbacks\n\t\t\t\t\t\t\txhr.onreadystatechange = xhrCallbacks[ id ] = callback;\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\n\t\t\t\t\tabort: function() {\n\t\t\t\t\t\tif ( callback ) {\n\t\t\t\t\t\t\tcallback( undefined, true );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\t\t} );\n\t}\n\n// Functions to create xhrs\n\tfunction createStandardXHR() {\n\t\ttry {\n\t\t\treturn new window.XMLHttpRequest();\n\t\t} catch ( e ) {}\n\t}\n\n\tfunction createActiveXHR() {\n\t\ttry {\n\t\t\treturn new window.ActiveXObject( \"Microsoft.XMLHTTP\" );\n\t\t} catch ( e ) {}\n\t}\n\n\n\n\n// Install script dataType\n\tjQuery.ajaxSetup( {\n\t\taccepts: {\n\t\t\tscript: \"text/javascript, application/javascript, \" +\n\t\t\t\"application/ecmascript, application/x-ecmascript\"\n\t\t},\n\t\tcontents: {\n\t\t\tscript: /\\b(?:java|ecma)script\\b/\n\t\t},\n\t\tconverters: {\n\t\t\t\"text script\": function( text ) {\n\t\t\t\tjQuery.globalEval( text );\n\t\t\t\treturn text;\n\t\t\t}\n\t\t}\n\t} );\n\n// Handle cache's special case and global\n\tjQuery.ajaxPrefilter( \"script\", function( s ) {\n\t\tif ( s.cache === undefined ) {\n\t\t\ts.cache = false;\n\t\t}\n\t\tif ( s.crossDomain ) {\n\t\t\ts.type = \"GET\";\n\t\t\ts.global = false;\n\t\t}\n\t} );\n\n// Bind script tag hack transport\n\tjQuery.ajaxTransport( \"script\", function( s ) {\n\n\t\t// This transport only deals with cross domain requests\n\t\tif ( s.crossDomain ) {\n\n\t\t\tvar script,\n\t\t\t\thead = document.head || jQuery( \"head\" )[ 0 ] || document.documentElement;\n\n\t\t\treturn {\n\n\t\t\t\tsend: function( _, callback ) {\n\n\t\t\t\t\tscript = document.createElement( \"script\" );\n\n\t\t\t\t\tscript.async = true;\n\n\t\t\t\t\tif ( s.scriptCharset ) {\n\t\t\t\t\t\tscript.charset = s.scriptCharset;\n\t\t\t\t\t}\n\n\t\t\t\t\tscript.src = s.url;\n\n\t\t\t\t\t// Attach handlers for all browsers\n\t\t\t\t\tscript.onload = script.onreadystatechange = function( _, isAbort ) {\n\n\t\t\t\t\t\tif ( isAbort || !script.readyState || /loaded|complete/.test( script.readyState ) ) {\n\n\t\t\t\t\t\t\t// Handle memory leak in IE\n\t\t\t\t\t\t\tscript.onload = script.onreadystatechange = null;\n\n\t\t\t\t\t\t\t// Remove the script\n\t\t\t\t\t\t\tif ( script.parentNode ) {\n\t\t\t\t\t\t\t\tscript.parentNode.removeChild( script );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Dereference the script\n\t\t\t\t\t\t\tscript = null;\n\n\t\t\t\t\t\t\t// Callback if not abort\n\t\t\t\t\t\t\tif ( !isAbort ) {\n\t\t\t\t\t\t\t\tcallback( 200, \"success\" );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\t// Circumvent IE6 bugs with base elements (#2709 and #4378) by prepending\n\t\t\t\t\t// Use native DOM manipulation to avoid our domManip AJAX trickery\n\t\t\t\t\thead.insertBefore( script, head.firstChild );\n\t\t\t\t},\n\n\t\t\t\tabort: function() {\n\t\t\t\t\tif ( script ) {\n\t\t\t\t\t\tscript.onload( undefined, true );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t} );\n\n\n\n\n\tvar oldCallbacks = [],\n\t\trjsonp = /(=)\\?(?=&|$)|\\?\\?/;\n\n// Default jsonp settings\n\tjQuery.ajaxSetup( {\n\t\tjsonp: \"callback\",\n\t\tjsonpCallback: function() {\n\t\t\tvar callback = oldCallbacks.pop() || ( jQuery.expando + \"_\" + ( nonce++ ) );\n\t\t\tthis[ callback ] = true;\n\t\t\treturn callback;\n\t\t}\n\t} );\n\n// Detect, normalize options and install callbacks for jsonp requests\n\tjQuery.ajaxPrefilter( \"json jsonp\", function( s, originalSettings, jqXHR ) {\n\n\t\tvar callbackName, overwritten, responseContainer,\n\t\t\tjsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?\n\t\t\t\t\t\t\"url\" :\n\t\t\t\t\ttypeof s.data === \"string\" &&\n\t\t\t\t\t( s.contentType || \"\" )\n\t\t\t\t\t\t.indexOf( \"application/x-www-form-urlencoded\" ) === 0 &&\n\t\t\t\t\trjsonp.test( s.data ) && \"data\"\n\t\t\t\t);\n\n\t\t// Handle iff the expected data type is \"jsonp\" or we have a parameter to set\n\t\tif ( jsonProp || s.dataTypes[ 0 ] === \"jsonp\" ) {\n\n\t\t\t// Get callback name, remembering preexisting value associated with it\n\t\t\tcallbackName = s.jsonpCallback = jQuery.isFunction( s.jsonpCallback ) ?\n\t\t\t\ts.jsonpCallback() :\n\t\t\t\ts.jsonpCallback;\n\n\t\t\t// Insert callback into url or form data\n\t\t\tif ( jsonProp ) {\n\t\t\t\ts[ jsonProp ] = s[ jsonProp ].replace( rjsonp, \"$1\" + callbackName );\n\t\t\t} else if ( s.jsonp !== false ) {\n\t\t\t\ts.url += ( rquery.test( s.url ) ? \"&\" : \"?\" ) + s.jsonp + \"=\" + callbackName;\n\t\t\t}\n\n\t\t\t// Use data converter to retrieve json after script execution\n\t\t\ts.converters[ \"script json\" ] = function() {\n\t\t\t\tif ( !responseContainer ) {\n\t\t\t\t\tjQuery.error( callbackName + \" was not called\" );\n\t\t\t\t}\n\t\t\t\treturn responseContainer[ 0 ];\n\t\t\t};\n\n\t\t\t// force json dataType\n\t\t\ts.dataTypes[ 0 ] = \"json\";\n\n\t\t\t// Install callback\n\t\t\toverwritten = window[ callbackName ];\n\t\t\twindow[ callbackName ] = function() {\n\t\t\t\tresponseContainer = arguments;\n\t\t\t};\n\n\t\t\t// Clean-up function (fires after converters)\n\t\t\tjqXHR.always( function() {\n\n\t\t\t\t// If previous value didn't exist - remove it\n\t\t\t\tif ( overwritten === undefined ) {\n\t\t\t\t\tjQuery( window ).removeProp( callbackName );\n\n\t\t\t\t\t// Otherwise restore preexisting value\n\t\t\t\t} else {\n\t\t\t\t\twindow[ callbackName ] = overwritten;\n\t\t\t\t}\n\n\t\t\t\t// Save back as free\n\t\t\t\tif ( s[ callbackName ] ) {\n\n\t\t\t\t\t// make sure that re-using the options doesn't screw things around\n\t\t\t\t\ts.jsonpCallback = originalSettings.jsonpCallback;\n\n\t\t\t\t\t// save the callback name for future use\n\t\t\t\t\toldCallbacks.push( callbackName );\n\t\t\t\t}\n\n\t\t\t\t// Call if it was a function and we have a response\n\t\t\t\tif ( responseContainer && jQuery.isFunction( overwritten ) ) {\n\t\t\t\t\toverwritten( responseContainer[ 0 ] );\n\t\t\t\t}\n\n\t\t\t\tresponseContainer = overwritten = undefined;\n\t\t\t} );\n\n\t\t\t// Delegate to script\n\t\t\treturn \"script\";\n\t\t}\n\t} );\n\n\n\n\n// data: string of html\n// context (optional): If specified, the fragment will be created in this context,\n// defaults to document\n// keepScripts (optional): If true, will include scripts passed in the html string\n\tjQuery.parseHTML = function( data, context, keepScripts ) {\n\t\tif ( !data || typeof data !== \"string\" ) {\n\t\t\treturn null;\n\t\t}\n\t\tif ( typeof context === \"boolean\" ) {\n\t\t\tkeepScripts = context;\n\t\t\tcontext = false;\n\t\t}\n\t\tcontext = context || document;\n\n\t\tvar parsed = rsingleTag.exec( data ),\n\t\t\tscripts = !keepScripts && [];\n\n\t\t// Single tag\n\t\tif ( parsed ) {\n\t\t\treturn [ context.createElement( parsed[ 1 ] ) ];\n\t\t}\n\n\t\tparsed = buildFragment( [ data ], context, scripts );\n\n\t\tif ( scripts && scripts.length ) {\n\t\t\tjQuery( scripts ).remove();\n\t\t}\n\n\t\treturn jQuery.merge( [], parsed.childNodes );\n\t};\n\n\n// Keep a copy of the old load method\n\tvar _load = jQuery.fn.load;\n\n\t/**\n\t * Load a url into a page\n\t */\n\tjQuery.fn.load = function( url, params, callback ) {\n\t\tif ( typeof url !== \"string\" && _load ) {\n\t\t\treturn _load.apply( this, arguments );\n\t\t}\n\n\t\tvar selector, type, response,\n\t\t\tself = this,\n\t\t\toff = url.indexOf( \" \" );\n\n\t\tif ( off > -1 ) {\n\t\t\tselector = jQuery.trim( url.slice( off, url.length ) );\n\t\t\turl = url.slice( 0, off );\n\t\t}\n\n\t\t// If it's a function\n\t\tif ( jQuery.isFunction( params ) ) {\n\n\t\t\t// We assume that it's the callback\n\t\t\tcallback = params;\n\t\t\tparams = undefined;\n\n\t\t\t// Otherwise, build a param string\n\t\t} else if ( params && typeof params === \"object\" ) {\n\t\t\ttype = \"POST\";\n\t\t}\n\n\t\t// If we have elements to modify, make the request\n\t\tif ( self.length > 0 ) {\n\t\t\tjQuery.ajax( {\n\t\t\t\turl: url,\n\n\t\t\t\t// If \"type\" variable is undefined, then \"GET\" method will be used.\n\t\t\t\t// Make value of this field explicit since\n\t\t\t\t// user can override it through ajaxSetup method\n\t\t\t\ttype: type || \"GET\",\n\t\t\t\tdataType: \"html\",\n\t\t\t\tdata: params\n\t\t\t} ).done( function( responseText ) {\n\n\t\t\t\t// Save response for use in complete callback\n\t\t\t\tresponse = arguments;\n\n\t\t\t\tself.html( selector ?\n\n\t\t\t\t\t// If a selector was specified, locate the right elements in a dummy div\n\t\t\t\t\t// Exclude scripts to avoid IE 'Permission Denied' errors\n\t\t\t\t\tjQuery( \"<div>\" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :\n\n\t\t\t\t\t// Otherwise use the full result\n\t\t\t\t\tresponseText );\n\n\t\t\t\t// If the request succeeds, this function gets \"data\", \"status\", \"jqXHR\"\n\t\t\t\t// but they are ignored because response was set above.\n\t\t\t\t// If it fails, this function gets \"jqXHR\", \"status\", \"error\"\n\t\t\t} ).always( callback && function( jqXHR, status ) {\n\t\t\t\t\tself.each( function() {\n\t\t\t\t\t\tcallback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );\n\t\t\t\t\t} );\n\t\t\t\t} );\n\t\t}\n\n\t\treturn this;\n\t};\n\n\n\n\n// Attach a bunch of functions for handling common AJAX events\n\tjQuery.each( [\n\t\t\"ajaxStart\",\n\t\t\"ajaxStop\",\n\t\t\"ajaxComplete\",\n\t\t\"ajaxError\",\n\t\t\"ajaxSuccess\",\n\t\t\"ajaxSend\"\n\t], function( i, type ) {\n\t\tjQuery.fn[ type ] = function( fn ) {\n\t\t\treturn this.on( type, fn );\n\t\t};\n\t} );\n\n\n\n\n\tjQuery.expr.filters.animated = function( elem ) {\n\t\treturn jQuery.grep( jQuery.timers, function( fn ) {\n\t\t\treturn elem === fn.elem;\n\t\t} ).length;\n\t};\n\n\n\n\n\n\t/**\n\t * Gets a window from an element\n\t */\n\tfunction getWindow( elem ) {\n\t\treturn jQuery.isWindow( elem ) ?\n\t\t\telem :\n\t\t\telem.nodeType === 9 ?\n\t\t\telem.defaultView || elem.parentWindow :\n\t\t\t\tfalse;\n\t}\n\n\tjQuery.offset = {\n\t\tsetOffset: function( elem, options, i ) {\n\t\t\tvar curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,\n\t\t\t\tposition = jQuery.css( elem, \"position\" ),\n\t\t\t\tcurElem = jQuery( elem ),\n\t\t\t\tprops = {};\n\n\t\t\t// set position first, in-case top/left are set even on static elem\n\t\t\tif ( position === \"static\" ) {\n\t\t\t\telem.style.position = \"relative\";\n\t\t\t}\n\n\t\t\tcurOffset = curElem.offset();\n\t\t\tcurCSSTop = jQuery.css( elem, \"top\" );\n\t\t\tcurCSSLeft = jQuery.css( elem, \"left\" );\n\t\t\tcalculatePosition = ( position === \"absolute\" || position === \"fixed\" ) &&\n\t\t\t\tjQuery.inArray( \"auto\", [ curCSSTop, curCSSLeft ] ) > -1;\n\n\t\t\t// need to be able to calculate position if either top or left\n\t\t\t// is auto and position is either absolute or fixed\n\t\t\tif ( calculatePosition ) {\n\t\t\t\tcurPosition = curElem.position();\n\t\t\t\tcurTop = curPosition.top;\n\t\t\t\tcurLeft = curPosition.left;\n\t\t\t} else {\n\t\t\t\tcurTop = parseFloat( curCSSTop ) || 0;\n\t\t\t\tcurLeft = parseFloat( curCSSLeft ) || 0;\n\t\t\t}\n\n\t\t\tif ( jQuery.isFunction( options ) ) {\n\n\t\t\t\t// Use jQuery.extend here to allow modification of coordinates argument (gh-1848)\n\t\t\t\toptions = options.call( elem, i, jQuery.extend( {}, curOffset ) );\n\t\t\t}\n\n\t\t\tif ( options.top != null ) {\n\t\t\t\tprops.top = ( options.top - curOffset.top ) + curTop;\n\t\t\t}\n\t\t\tif ( options.left != null ) {\n\t\t\t\tprops.left = ( options.left - curOffset.left ) + curLeft;\n\t\t\t}\n\n\t\t\tif ( \"using\" in options ) {\n\t\t\t\toptions.using.call( elem, props );\n\t\t\t} else {\n\t\t\t\tcurElem.css( props );\n\t\t\t}\n\t\t}\n\t};\n\n\tjQuery.fn.extend( {\n\t\toffset: function( options ) {\n\t\t\tif ( arguments.length ) {\n\t\t\t\treturn options === undefined ?\n\t\t\t\t\tthis :\n\t\t\t\t\tthis.each( function( i ) {\n\t\t\t\t\t\tjQuery.offset.setOffset( this, options, i );\n\t\t\t\t\t} );\n\t\t\t}\n\n\t\t\tvar docElem, win,\n\t\t\t\tbox = { top: 0, left: 0 },\n\t\t\t\telem = this[ 0 ],\n\t\t\t\tdoc = elem && elem.ownerDocument;\n\n\t\t\tif ( !doc ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tdocElem = doc.documentElement;\n\n\t\t\t// Make sure it's not a disconnected DOM node\n\t\t\tif ( !jQuery.contains( docElem, elem ) ) {\n\t\t\t\treturn box;\n\t\t\t}\n\n\t\t\t// If we don't have gBCR, just use 0,0 rather than error\n\t\t\t// BlackBerry 5, iOS 3 (original iPhone)\n\t\t\tif ( typeof elem.getBoundingClientRect !== \"undefined\" ) {\n\t\t\t\tbox = elem.getBoundingClientRect();\n\t\t\t}\n\t\t\twin = getWindow( doc );\n\t\t\treturn {\n\t\t\t\ttop: box.top  + ( win.pageYOffset || docElem.scrollTop )  - ( docElem.clientTop  || 0 ),\n\t\t\t\tleft: box.left + ( win.pageXOffset || docElem.scrollLeft ) - ( docElem.clientLeft || 0 )\n\t\t\t};\n\t\t},\n\n\t\tposition: function() {\n\t\t\tif ( !this[ 0 ] ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tvar offsetParent, offset,\n\t\t\t\tparentOffset = { top: 0, left: 0 },\n\t\t\t\telem = this[ 0 ];\n\n\t\t\t// Fixed elements are offset from window (parentOffset = {top:0, left: 0},\n\t\t\t// because it is its only offset parent\n\t\t\tif ( jQuery.css( elem, \"position\" ) === \"fixed\" ) {\n\n\t\t\t\t// we assume that getBoundingClientRect is available when computed position is fixed\n\t\t\t\toffset = elem.getBoundingClientRect();\n\t\t\t} else {\n\n\t\t\t\t// Get *real* offsetParent\n\t\t\t\toffsetParent = this.offsetParent();\n\n\t\t\t\t// Get correct offsets\n\t\t\t\toffset = this.offset();\n\t\t\t\tif ( !jQuery.nodeName( offsetParent[ 0 ], \"html\" ) ) {\n\t\t\t\t\tparentOffset = offsetParent.offset();\n\t\t\t\t}\n\n\t\t\t\t// Add offsetParent borders\n\t\t\t\tparentOffset.top  += jQuery.css( offsetParent[ 0 ], \"borderTopWidth\", true );\n\t\t\t\tparentOffset.left += jQuery.css( offsetParent[ 0 ], \"borderLeftWidth\", true );\n\t\t\t}\n\n\t\t\t// Subtract parent offsets and element margins\n\t\t\t// note: when an element has margin: auto the offsetLeft and marginLeft\n\t\t\t// are the same in Safari causing offset.left to incorrectly be 0\n\t\t\treturn {\n\t\t\t\ttop:  offset.top  - parentOffset.top - jQuery.css( elem, \"marginTop\", true ),\n\t\t\t\tleft: offset.left - parentOffset.left - jQuery.css( elem, \"marginLeft\", true )\n\t\t\t};\n\t\t},\n\n\t\toffsetParent: function() {\n\t\t\treturn this.map( function() {\n\t\t\t\tvar offsetParent = this.offsetParent;\n\n\t\t\t\twhile ( offsetParent && ( !jQuery.nodeName( offsetParent, \"html\" ) &&\n\t\t\t\tjQuery.css( offsetParent, \"position\" ) === \"static\" ) ) {\n\t\t\t\t\toffsetParent = offsetParent.offsetParent;\n\t\t\t\t}\n\t\t\t\treturn offsetParent || documentElement;\n\t\t\t} );\n\t\t}\n\t} );\n\n// Create scrollLeft and scrollTop methods\n\tjQuery.each( { scrollLeft: \"pageXOffset\", scrollTop: \"pageYOffset\" }, function( method, prop ) {\n\t\tvar top = /Y/.test( prop );\n\n\t\tjQuery.fn[ method ] = function( val ) {\n\t\t\treturn access( this, function( elem, method, val ) {\n\t\t\t\tvar win = getWindow( elem );\n\n\t\t\t\tif ( val === undefined ) {\n\t\t\t\t\treturn win ? ( prop in win ) ? win[ prop ] :\n\t\t\t\t\t\twin.document.documentElement[ method ] :\n\t\t\t\t\t\telem[ method ];\n\t\t\t\t}\n\n\t\t\t\tif ( win ) {\n\t\t\t\t\twin.scrollTo(\n\t\t\t\t\t\t!top ? val : jQuery( win ).scrollLeft(),\n\t\t\t\t\t\ttop ? val : jQuery( win ).scrollTop()\n\t\t\t\t\t);\n\n\t\t\t\t} else {\n\t\t\t\t\telem[ method ] = val;\n\t\t\t\t}\n\t\t\t}, method, val, arguments.length, null );\n\t\t};\n\t} );\n\n// Support: Safari<7-8+, Chrome<37-44+\n// Add the top/left cssHooks using jQuery.fn.position\n// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084\n// getComputedStyle returns percent when specified for top/left/bottom/right\n// rather than make the css module depend on the offset module, we just check for it here\n\tjQuery.each( [ \"top\", \"left\" ], function( i, prop ) {\n\t\tjQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,\n\t\t\tfunction( elem, computed ) {\n\t\t\t\tif ( computed ) {\n\t\t\t\t\tcomputed = curCSS( elem, prop );\n\n\t\t\t\t\t// if curCSS returns percentage, fallback to offset\n\t\t\t\t\treturn rnumnonpx.test( computed ) ?\n\t\t\t\t\tjQuery( elem ).position()[ prop ] + \"px\" :\n\t\t\t\t\t\tcomputed;\n\t\t\t\t}\n\t\t\t}\n\t\t);\n\t} );\n\n\n// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods\n\tjQuery.each( { Height: \"height\", Width: \"width\" }, function( name, type ) {\n\t\tjQuery.each( { padding: \"inner\" + name, content: type, \"\": \"outer\" + name },\n\t\t\tfunction( defaultExtra, funcName ) {\n\n\t\t\t\t// margin is only for outerHeight, outerWidth\n\t\t\t\tjQuery.fn[ funcName ] = function( margin, value ) {\n\t\t\t\t\tvar chainable = arguments.length && ( defaultExtra || typeof margin !== \"boolean\" ),\n\t\t\t\t\t\textra = defaultExtra || ( margin === true || value === true ? \"margin\" : \"border\" );\n\n\t\t\t\t\treturn access( this, function( elem, type, value ) {\n\t\t\t\t\t\tvar doc;\n\n\t\t\t\t\t\tif ( jQuery.isWindow( elem ) ) {\n\n\t\t\t\t\t\t\t// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there\n\t\t\t\t\t\t\t// isn't a whole lot we can do. See pull request at this URL for discussion:\n\t\t\t\t\t\t\t// https://github.com/jquery/jquery/pull/764\n\t\t\t\t\t\t\treturn elem.document.documentElement[ \"client\" + name ];\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Get document width or height\n\t\t\t\t\t\tif ( elem.nodeType === 9 ) {\n\t\t\t\t\t\t\tdoc = elem.documentElement;\n\n\t\t\t\t\t\t\t// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],\n\t\t\t\t\t\t\t// whichever is greatest\n\t\t\t\t\t\t\t// unfortunately, this causes bug #3838 in IE6/8 only,\n\t\t\t\t\t\t\t// but there is currently no good, small way to fix it.\n\t\t\t\t\t\t\treturn Math.max(\n\t\t\t\t\t\t\t\telem.body[ \"scroll\" + name ], doc[ \"scroll\" + name ],\n\t\t\t\t\t\t\t\telem.body[ \"offset\" + name ], doc[ \"offset\" + name ],\n\t\t\t\t\t\t\t\tdoc[ \"client\" + name ]\n\t\t\t\t\t\t\t);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn value === undefined ?\n\n\t\t\t\t\t\t\t// Get width or height on the element, requesting but not forcing parseFloat\n\t\t\t\t\t\t\tjQuery.css( elem, type, extra ) :\n\n\t\t\t\t\t\t\t// Set width or height on the element\n\t\t\t\t\t\t\tjQuery.style( elem, type, value, extra );\n\t\t\t\t\t}, type, chainable ? margin : undefined, chainable, null );\n\t\t\t\t};\n\t\t\t} );\n\t} );\n\n\n\tjQuery.fn.extend( {\n\n\t\tbind: function( types, data, fn ) {\n\t\t\treturn this.on( types, null, data, fn );\n\t\t},\n\t\tunbind: function( types, fn ) {\n\t\t\treturn this.off( types, null, fn );\n\t\t},\n\n\t\tdelegate: function( selector, types, data, fn ) {\n\t\t\treturn this.on( types, selector, data, fn );\n\t\t},\n\t\tundelegate: function( selector, types, fn ) {\n\n\t\t\t// ( namespace ) or ( selector, types [, fn] )\n\t\t\treturn arguments.length === 1 ?\n\t\t\t\tthis.off( selector, \"**\" ) :\n\t\t\t\tthis.off( types, selector || \"**\", fn );\n\t\t}\n\t} );\n\n// The number of elements contained in the matched element set\n\tjQuery.fn.size = function() {\n\t\treturn this.length;\n\t};\n\n\tjQuery.fn.andSelf = jQuery.fn.addBack;\n\n\n\n\n// Register as a named AMD module, since jQuery can be concatenated with other\n// files that may use define, but not via a proper concatenation script that\n// understands anonymous AMD modules. A named AMD is safest and most robust\n// way to register. Lowercase jquery is used because AMD module names are\n// derived from file names, and jQuery is normally delivered in a lowercase\n// file name. Do this after creating the global so that if an AMD module wants\n// to call noConflict to hide this version of jQuery, it will work.\n\n// Note that for maximum portability, libraries that are not jQuery should\n// declare themselves as anonymous modules, and avoid setting a global if an\n// AMD loader is present. jQuery is a special case. For more information, see\n// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\t\tdefine( \"jquery\", [], function() {\n\t\t\treturn jQuery;\n\t\t} );\n\t}\n\n\n\n\tvar\n\n\t\t// Map over jQuery in case of overwrite\n\t\t_jQuery = window.jQuery,\n\n\t\t// Map over the $ in case of overwrite\n\t\t_$ = window.$;\n\n\tjQuery.noConflict = function( deep ) {\n\t\tif ( window.$ === jQuery ) {\n\t\t\twindow.$ = _$;\n\t\t}\n\n\t\tif ( deep && window.jQuery === jQuery ) {\n\t\t\twindow.jQuery = _jQuery;\n\t\t}\n\n\t\treturn jQuery;\n\t};\n\n// Expose jQuery and $ identifiers, even in\n// AMD (#7102#comment:10, https://github.com/jquery/jquery/pull/557)\n// and CommonJS for browser emulators (#13566)\n\tif ( !noGlobal ) {\n\t\twindow.jQuery = window.$ = jQuery;\n\t}\n\n\treturn jQuery;\n}));","underscore.js":"//     Underscore.js 1.8.2\n//     http://underscorejs.org\n//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors\n//     Underscore may be freely distributed under the MIT license.\n\n(function() {\n\n  // Baseline setup\n  // --------------\n\n  // Establish the root object, `window` in the browser, or `exports` on the server.\n  var root = this;\n\n  // Save the previous value of the `_` variable.\n  var previousUnderscore = root._;\n\n  // Save bytes in the minified (but not gzipped) version:\n  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;\n\n  // Create quick reference variables for speed access to core prototypes.\n  var\n    push             = ArrayProto.push,\n    slice            = ArrayProto.slice,\n    toString         = ObjProto.toString,\n    hasOwnProperty   = ObjProto.hasOwnProperty;\n\n  // All **ECMAScript 5** native function implementations that we hope to use\n  // are declared here.\n  var\n    nativeIsArray      = Array.isArray,\n    nativeKeys         = Object.keys,\n    nativeBind         = FuncProto.bind,\n    nativeCreate       = Object.create;\n\n  // Naked function reference for surrogate-prototype-swapping.\n  var Ctor = function(){};\n\n  // Create a safe reference to the Underscore object for use below.\n  var _ = function(obj) {\n    if (obj instanceof _) return obj;\n    if (!(this instanceof _)) return new _(obj);\n    this._wrapped = obj;\n  };\n\n  // Export the Underscore object for **Node.js**, with\n  // backwards-compatibility for the old `require()` API. If we're in\n  // the browser, add `_` as a global object.\n  if (typeof exports !== 'undefined') {\n    if (typeof module !== 'undefined' && module.exports) {\n      exports = module.exports = _;\n    }\n    exports._ = _;\n  } else {\n    root._ = _;\n  }\n\n  // Current version.\n  _.VERSION = '1.8.2';\n\n  // Internal function that returns an efficient (for current engines) version\n  // of the passed-in callback, to be repeatedly applied in other Underscore\n  // functions.\n  var optimizeCb = function(func, context, argCount) {\n    if (context === void 0) return func;\n    switch (argCount == null ? 3 : argCount) {\n      case 1: return function(value) {\n        return func.call(context, value);\n      };\n      case 2: return function(value, other) {\n        return func.call(context, value, other);\n      };\n      case 3: return function(value, index, collection) {\n        return func.call(context, value, index, collection);\n      };\n      case 4: return function(accumulator, value, index, collection) {\n        return func.call(context, accumulator, value, index, collection);\n      };\n    }\n    return function() {\n      return func.apply(context, arguments);\n    };\n  };\n\n  // A mostly-internal function to generate callbacks that can be applied\n  // to each element in a collection, returning the desired result \u2014 either\n  // identity, an arbitrary callback, a property matcher, or a property accessor.\n  var cb = function(value, context, argCount) {\n    if (value == null) return _.identity;\n    if (_.isFunction(value)) return optimizeCb(value, context, argCount);\n    if (_.isObject(value)) return _.matcher(value);\n    return _.property(value);\n  };\n  _.iteratee = function(value, context) {\n    return cb(value, context, Infinity);\n  };\n\n  // An internal function for creating assigner functions.\n  var createAssigner = function(keysFunc, undefinedOnly) {\n    return function(obj) {\n      var length = arguments.length;\n      if (length < 2 || obj == null) return obj;\n      for (var index = 1; index < length; index++) {\n        var source = arguments[index],\n            keys = keysFunc(source),\n            l = keys.length;\n        for (var i = 0; i < l; i++) {\n          var key = keys[i];\n          if (!undefinedOnly || obj[key] === void 0) obj[key] = source[key];\n        }\n      }\n      return obj;\n    };\n  };\n\n  // An internal function for creating a new object that inherits from another.\n  var baseCreate = function(prototype) {\n    if (!_.isObject(prototype)) return {};\n    if (nativeCreate) return nativeCreate(prototype);\n    Ctor.prototype = prototype;\n    var result = new Ctor;\n    Ctor.prototype = null;\n    return result;\n  };\n\n  // Helper for collection methods to determine whether a collection\n  // should be iterated as an array or as an object\n  // Related: http://people.mozilla.org/~jorendorff/es6-draft.html#sec-tolength\n  var MAX_ARRAY_INDEX = Math.pow(2, 53) - 1;\n  var isArrayLike = function(collection) {\n    var length = collection && collection.length;\n    return typeof length == 'number' && length >= 0 && length <= MAX_ARRAY_INDEX;\n  };\n\n  // Collection Functions\n  // --------------------\n\n  // The cornerstone, an `each` implementation, aka `forEach`.\n  // Handles raw objects in addition to array-likes. Treats all\n  // sparse array-likes as if they were dense.\n  _.each = _.forEach = function(obj, iteratee, context) {\n    iteratee = optimizeCb(iteratee, context);\n    var i, length;\n    if (isArrayLike(obj)) {\n      for (i = 0, length = obj.length; i < length; i++) {\n        iteratee(obj[i], i, obj);\n      }\n    } else {\n      var keys = _.keys(obj);\n      for (i = 0, length = keys.length; i < length; i++) {\n        iteratee(obj[keys[i]], keys[i], obj);\n      }\n    }\n    return obj;\n  };\n\n  // Return the results of applying the iteratee to each element.\n  _.map = _.collect = function(obj, iteratee, context) {\n    iteratee = cb(iteratee, context);\n    var keys = !isArrayLike(obj) && _.keys(obj),\n        length = (keys || obj).length,\n        results = Array(length);\n    for (var index = 0; index < length; index++) {\n      var currentKey = keys ? keys[index] : index;\n      results[index] = iteratee(obj[currentKey], currentKey, obj);\n    }\n    return results;\n  };\n\n  // Create a reducing function iterating left or right.\n  function createReduce(dir) {\n    // Optimized iterator function as using arguments.length\n    // in the main function will deoptimize the, see #1991.\n    function iterator(obj, iteratee, memo, keys, index, length) {\n      for (; index >= 0 && index < length; index += dir) {\n        var currentKey = keys ? keys[index] : index;\n        memo = iteratee(memo, obj[currentKey], currentKey, obj);\n      }\n      return memo;\n    }\n\n    return function(obj, iteratee, memo, context) {\n      iteratee = optimizeCb(iteratee, context, 4);\n      var keys = !isArrayLike(obj) && _.keys(obj),\n          length = (keys || obj).length,\n          index = dir > 0 ? 0 : length - 1;\n      // Determine the initial value if none is provided.\n      if (arguments.length < 3) {\n        memo = obj[keys ? keys[index] : index];\n        index += dir;\n      }\n      return iterator(obj, iteratee, memo, keys, index, length);\n    };\n  }\n\n  // **Reduce** builds up a single result from a list of values, aka `inject`,\n  // or `foldl`.\n  _.reduce = _.foldl = _.inject = createReduce(1);\n\n  // The right-associative version of reduce, also known as `foldr`.\n  _.reduceRight = _.foldr = createReduce(-1);\n\n  // Return the first value which passes a truth test. Aliased as `detect`.\n  _.find = _.detect = function(obj, predicate, context) {\n    var key;\n    if (isArrayLike(obj)) {\n      key = _.findIndex(obj, predicate, context);\n    } else {\n      key = _.findKey(obj, predicate, context);\n    }\n    if (key !== void 0 && key !== -1) return obj[key];\n  };\n\n  // Return all the elements that pass a truth test.\n  // Aliased as `select`.\n  _.filter = _.select = function(obj, predicate, context) {\n    var results = [];\n    predicate = cb(predicate, context);\n    _.each(obj, function(value, index, list) {\n      if (predicate(value, index, list)) results.push(value);\n    });\n    return results;\n  };\n\n  // Return all the elements for which a truth test fails.\n  _.reject = function(obj, predicate, context) {\n    return _.filter(obj, _.negate(cb(predicate)), context);\n  };\n\n  // Determine whether all of the elements match a truth test.\n  // Aliased as `all`.\n  _.every = _.all = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var keys = !isArrayLike(obj) && _.keys(obj),\n        length = (keys || obj).length;\n    for (var index = 0; index < length; index++) {\n      var currentKey = keys ? keys[index] : index;\n      if (!predicate(obj[currentKey], currentKey, obj)) return false;\n    }\n    return true;\n  };\n\n  // Determine if at least one element in the object matches a truth test.\n  // Aliased as `any`.\n  _.some = _.any = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var keys = !isArrayLike(obj) && _.keys(obj),\n        length = (keys || obj).length;\n    for (var index = 0; index < length; index++) {\n      var currentKey = keys ? keys[index] : index;\n      if (predicate(obj[currentKey], currentKey, obj)) return true;\n    }\n    return false;\n  };\n\n  // Determine if the array or object contains a given value (using `===`).\n  // Aliased as `includes` and `include`.\n  _.contains = _.includes = _.include = function(obj, target, fromIndex) {\n    if (!isArrayLike(obj)) obj = _.values(obj);\n    return _.indexOf(obj, target, typeof fromIndex == 'number' && fromIndex) >= 0;\n  };\n\n  // Invoke a method (with arguments) on every item in a collection.\n  _.invoke = function(obj, method) {\n    var args = slice.call(arguments, 2);\n    var isFunc = _.isFunction(method);\n    return _.map(obj, function(value) {\n      var func = isFunc ? method : value[method];\n      return func == null ? func : func.apply(value, args);\n    });\n  };\n\n  // Convenience version of a common use case of `map`: fetching a property.\n  _.pluck = function(obj, key) {\n    return _.map(obj, _.property(key));\n  };\n\n  // Convenience version of a common use case of `filter`: selecting only objects\n  // containing specific `key:value` pairs.\n  _.where = function(obj, attrs) {\n    return _.filter(obj, _.matcher(attrs));\n  };\n\n  // Convenience version of a common use case of `find`: getting the first object\n  // containing specific `key:value` pairs.\n  _.findWhere = function(obj, attrs) {\n    return _.find(obj, _.matcher(attrs));\n  };\n\n  // Return the maximum element (or element-based computation).\n  _.max = function(obj, iteratee, context) {\n    var result = -Infinity, lastComputed = -Infinity,\n        value, computed;\n    if (iteratee == null && obj != null) {\n      obj = isArrayLike(obj) ? obj : _.values(obj);\n      for (var i = 0, length = obj.length; i < length; i++) {\n        value = obj[i];\n        if (value > result) {\n          result = value;\n        }\n      }\n    } else {\n      iteratee = cb(iteratee, context);\n      _.each(obj, function(value, index, list) {\n        computed = iteratee(value, index, list);\n        if (computed > lastComputed || computed === -Infinity && result === -Infinity) {\n          result = value;\n          lastComputed = computed;\n        }\n      });\n    }\n    return result;\n  };\n\n  // Return the minimum element (or element-based computation).\n  _.min = function(obj, iteratee, context) {\n    var result = Infinity, lastComputed = Infinity,\n        value, computed;\n    if (iteratee == null && obj != null) {\n      obj = isArrayLike(obj) ? obj : _.values(obj);\n      for (var i = 0, length = obj.length; i < length; i++) {\n        value = obj[i];\n        if (value < result) {\n          result = value;\n        }\n      }\n    } else {\n      iteratee = cb(iteratee, context);\n      _.each(obj, function(value, index, list) {\n        computed = iteratee(value, index, list);\n        if (computed < lastComputed || computed === Infinity && result === Infinity) {\n          result = value;\n          lastComputed = computed;\n        }\n      });\n    }\n    return result;\n  };\n\n  // Shuffle a collection, using the modern version of the\n  // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher\u2013Yates_shuffle).\n  _.shuffle = function(obj) {\n    var set = isArrayLike(obj) ? obj : _.values(obj);\n    var length = set.length;\n    var shuffled = Array(length);\n    for (var index = 0, rand; index < length; index++) {\n      rand = _.random(0, index);\n      if (rand !== index) shuffled[index] = shuffled[rand];\n      shuffled[rand] = set[index];\n    }\n    return shuffled;\n  };\n\n  // Sample **n** random values from a collection.\n  // If **n** is not specified, returns a single random element.\n  // The internal `guard` argument allows it to work with `map`.\n  _.sample = function(obj, n, guard) {\n    if (n == null || guard) {\n      if (!isArrayLike(obj)) obj = _.values(obj);\n      return obj[_.random(obj.length - 1)];\n    }\n    return _.shuffle(obj).slice(0, Math.max(0, n));\n  };\n\n  // Sort the object's values by a criterion produced by an iteratee.\n  _.sortBy = function(obj, iteratee, context) {\n    iteratee = cb(iteratee, context);\n    return _.pluck(_.map(obj, function(value, index, list) {\n      return {\n        value: value,\n        index: index,\n        criteria: iteratee(value, index, list)\n      };\n    }).sort(function(left, right) {\n      var a = left.criteria;\n      var b = right.criteria;\n      if (a !== b) {\n        if (a > b || a === void 0) return 1;\n        if (a < b || b === void 0) return -1;\n      }\n      return left.index - right.index;\n    }), 'value');\n  };\n\n  // An internal function used for aggregate \"group by\" operations.\n  var group = function(behavior) {\n    return function(obj, iteratee, context) {\n      var result = {};\n      iteratee = cb(iteratee, context);\n      _.each(obj, function(value, index) {\n        var key = iteratee(value, index, obj);\n        behavior(result, value, key);\n      });\n      return result;\n    };\n  };\n\n  // Groups the object's values by a criterion. Pass either a string attribute\n  // to group by, or a function that returns the criterion.\n  _.groupBy = group(function(result, value, key) {\n    if (_.has(result, key)) result[key].push(value); else result[key] = [value];\n  });\n\n  // Indexes the object's values by a criterion, similar to `groupBy`, but for\n  // when you know that your index values will be unique.\n  _.indexBy = group(function(result, value, key) {\n    result[key] = value;\n  });\n\n  // Counts instances of an object that group by a certain criterion. Pass\n  // either a string attribute to count by, or a function that returns the\n  // criterion.\n  _.countBy = group(function(result, value, key) {\n    if (_.has(result, key)) result[key]++; else result[key] = 1;\n  });\n\n  // Safely create a real, live array from anything iterable.\n  _.toArray = function(obj) {\n    if (!obj) return [];\n    if (_.isArray(obj)) return slice.call(obj);\n    if (isArrayLike(obj)) return _.map(obj, _.identity);\n    return _.values(obj);\n  };\n\n  // Return the number of elements in an object.\n  _.size = function(obj) {\n    if (obj == null) return 0;\n    return isArrayLike(obj) ? obj.length : _.keys(obj).length;\n  };\n\n  // Split a collection into two arrays: one whose elements all satisfy the given\n  // predicate, and one whose elements all do not satisfy the predicate.\n  _.partition = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var pass = [], fail = [];\n    _.each(obj, function(value, key, obj) {\n      (predicate(value, key, obj) ? pass : fail).push(value);\n    });\n    return [pass, fail];\n  };\n\n  // Array Functions\n  // ---------------\n\n  // Get the first element of an array. Passing **n** will return the first N\n  // values in the array. Aliased as `head` and `take`. The **guard** check\n  // allows it to work with `_.map`.\n  _.first = _.head = _.take = function(array, n, guard) {\n    if (array == null) return void 0;\n    if (n == null || guard) return array[0];\n    return _.initial(array, array.length - n);\n  };\n\n  // Returns everything but the last entry of the array. Especially useful on\n  // the arguments object. Passing **n** will return all the values in\n  // the array, excluding the last N.\n  _.initial = function(array, n, guard) {\n    return slice.call(array, 0, Math.max(0, array.length - (n == null || guard ? 1 : n)));\n  };\n\n  // Get the last element of an array. Passing **n** will return the last N\n  // values in the array.\n  _.last = function(array, n, guard) {\n    if (array == null) return void 0;\n    if (n == null || guard) return array[array.length - 1];\n    return _.rest(array, Math.max(0, array.length - n));\n  };\n\n  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.\n  // Especially useful on the arguments object. Passing an **n** will return\n  // the rest N values in the array.\n  _.rest = _.tail = _.drop = function(array, n, guard) {\n    return slice.call(array, n == null || guard ? 1 : n);\n  };\n\n  // Trim out all falsy values from an array.\n  _.compact = function(array) {\n    return _.filter(array, _.identity);\n  };\n\n  // Internal implementation of a recursive `flatten` function.\n  var flatten = function(input, shallow, strict, startIndex) {\n    var output = [], idx = 0;\n    for (var i = startIndex || 0, length = input && input.length; i < length; i++) {\n      var value = input[i];\n      if (isArrayLike(value) && (_.isArray(value) || _.isArguments(value))) {\n        //flatten current level of array or arguments object\n        if (!shallow) value = flatten(value, shallow, strict);\n        var j = 0, len = value.length;\n        output.length += len;\n        while (j < len) {\n          output[idx++] = value[j++];\n        }\n      } else if (!strict) {\n        output[idx++] = value;\n      }\n    }\n    return output;\n  };\n\n  // Flatten out an array, either recursively (by default), or just one level.\n  _.flatten = function(array, shallow) {\n    return flatten(array, shallow, false);\n  };\n\n  // Return a version of the array that does not contain the specified value(s).\n  _.without = function(array) {\n    return _.difference(array, slice.call(arguments, 1));\n  };\n\n  // Produce a duplicate-free version of the array. If the array has already\n  // been sorted, you have the option of using a faster algorithm.\n  // Aliased as `unique`.\n  _.uniq = _.unique = function(array, isSorted, iteratee, context) {\n    if (array == null) return [];\n    if (!_.isBoolean(isSorted)) {\n      context = iteratee;\n      iteratee = isSorted;\n      isSorted = false;\n    }\n    if (iteratee != null) iteratee = cb(iteratee, context);\n    var result = [];\n    var seen = [];\n    for (var i = 0, length = array.length; i < length; i++) {\n      var value = array[i],\n          computed = iteratee ? iteratee(value, i, array) : value;\n      if (isSorted) {\n        if (!i || seen !== computed) result.push(value);\n        seen = computed;\n      } else if (iteratee) {\n        if (!_.contains(seen, computed)) {\n          seen.push(computed);\n          result.push(value);\n        }\n      } else if (!_.contains(result, value)) {\n        result.push(value);\n      }\n    }\n    return result;\n  };\n\n  // Produce an array that contains the union: each distinct element from all of\n  // the passed-in arrays.\n  _.union = function() {\n    return _.uniq(flatten(arguments, true, true));\n  };\n\n  // Produce an array that contains every item shared between all the\n  // passed-in arrays.\n  _.intersection = function(array) {\n    if (array == null) return [];\n    var result = [];\n    var argsLength = arguments.length;\n    for (var i = 0, length = array.length; i < length; i++) {\n      var item = array[i];\n      if (_.contains(result, item)) continue;\n      for (var j = 1; j < argsLength; j++) {\n        if (!_.contains(arguments[j], item)) break;\n      }\n      if (j === argsLength) result.push(item);\n    }\n    return result;\n  };\n\n  // Take the difference between one array and a number of other arrays.\n  // Only the elements present in just the first array will remain.\n  _.difference = function(array) {\n    var rest = flatten(arguments, true, true, 1);\n    return _.filter(array, function(value){\n      return !_.contains(rest, value);\n    });\n  };\n\n  // Zip together multiple lists into a single array -- elements that share\n  // an index go together.\n  _.zip = function() {\n    return _.unzip(arguments);\n  };\n\n  // Complement of _.zip. Unzip accepts an array of arrays and groups\n  // each array's elements on shared indices\n  _.unzip = function(array) {\n    var length = array && _.max(array, 'length').length || 0;\n    var result = Array(length);\n\n    for (var index = 0; index < length; index++) {\n      result[index] = _.pluck(array, index);\n    }\n    return result;\n  };\n\n  // Converts lists into objects. Pass either a single array of `[key, value]`\n  // pairs, or two parallel arrays of the same length -- one of keys, and one of\n  // the corresponding values.\n  _.object = function(list, values) {\n    var result = {};\n    for (var i = 0, length = list && list.length; i < length; i++) {\n      if (values) {\n        result[list[i]] = values[i];\n      } else {\n        result[list[i][0]] = list[i][1];\n      }\n    }\n    return result;\n  };\n\n  // Return the position of the first occurrence of an item in an array,\n  // or -1 if the item is not included in the array.\n  // If the array is large and already in sort order, pass `true`\n  // for **isSorted** to use binary search.\n  _.indexOf = function(array, item, isSorted) {\n    var i = 0, length = array && array.length;\n    if (typeof isSorted == 'number') {\n      i = isSorted < 0 ? Math.max(0, length + isSorted) : isSorted;\n    } else if (isSorted && length) {\n      i = _.sortedIndex(array, item);\n      return array[i] === item ? i : -1;\n    }\n    if (item !== item) {\n      return _.findIndex(slice.call(array, i), _.isNaN);\n    }\n    for (; i < length; i++) if (array[i] === item) return i;\n    return -1;\n  };\n\n  _.lastIndexOf = function(array, item, from) {\n    var idx = array ? array.length : 0;\n    if (typeof from == 'number') {\n      idx = from < 0 ? idx + from + 1 : Math.min(idx, from + 1);\n    }\n    if (item !== item) {\n      return _.findLastIndex(slice.call(array, 0, idx), _.isNaN);\n    }\n    while (--idx >= 0) if (array[idx] === item) return idx;\n    return -1;\n  };\n\n  // Generator function to create the findIndex and findLastIndex functions\n  function createIndexFinder(dir) {\n    return function(array, predicate, context) {\n      predicate = cb(predicate, context);\n      var length = array != null && array.length;\n      var index = dir > 0 ? 0 : length - 1;\n      for (; index >= 0 && index < length; index += dir) {\n        if (predicate(array[index], index, array)) return index;\n      }\n      return -1;\n    };\n  }\n\n  // Returns the first index on an array-like that passes a predicate test\n  _.findIndex = createIndexFinder(1);\n\n  _.findLastIndex = createIndexFinder(-1);\n\n  // Use a comparator function to figure out the smallest index at which\n  // an object should be inserted so as to maintain order. Uses binary search.\n  _.sortedIndex = function(array, obj, iteratee, context) {\n    iteratee = cb(iteratee, context, 1);\n    var value = iteratee(obj);\n    var low = 0, high = array.length;\n    while (low < high) {\n      var mid = Math.floor((low + high) / 2);\n      if (iteratee(array[mid]) < value) low = mid + 1; else high = mid;\n    }\n    return low;\n  };\n\n  // Generate an integer Array containing an arithmetic progression. A port of\n  // the native Python `range()` function. See\n  // [the Python documentation](http://docs.python.org/library/functions.html#range).\n  _.range = function(start, stop, step) {\n    if (arguments.length <= 1) {\n      stop = start || 0;\n      start = 0;\n    }\n    step = step || 1;\n\n    var length = Math.max(Math.ceil((stop - start) / step), 0);\n    var range = Array(length);\n\n    for (var idx = 0; idx < length; idx++, start += step) {\n      range[idx] = start;\n    }\n\n    return range;\n  };\n\n  // Function (ahem) Functions\n  // ------------------\n\n  // Determines whether to execute a function as a constructor\n  // or a normal function with the provided arguments\n  var executeBound = function(sourceFunc, boundFunc, context, callingContext, args) {\n    if (!(callingContext instanceof boundFunc)) return sourceFunc.apply(context, args);\n    var self = baseCreate(sourceFunc.prototype);\n    var result = sourceFunc.apply(self, args);\n    if (_.isObject(result)) return result;\n    return self;\n  };\n\n  // Create a function bound to a given object (assigning `this`, and arguments,\n  // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if\n  // available.\n  _.bind = function(func, context) {\n    if (nativeBind && func.bind === nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));\n    if (!_.isFunction(func)) throw new TypeError('Bind must be called on a function');\n    var args = slice.call(arguments, 2);\n    var bound = function() {\n      return executeBound(func, bound, context, this, args.concat(slice.call(arguments)));\n    };\n    return bound;\n  };\n\n  // Partially apply a function by creating a version that has had some of its\n  // arguments pre-filled, without changing its dynamic `this` context. _ acts\n  // as a placeholder, allowing any combination of arguments to be pre-filled.\n  _.partial = function(func) {\n    var boundArgs = slice.call(arguments, 1);\n    var bound = function() {\n      var position = 0, length = boundArgs.length;\n      var args = Array(length);\n      for (var i = 0; i < length; i++) {\n        args[i] = boundArgs[i] === _ ? arguments[position++] : boundArgs[i];\n      }\n      while (position < arguments.length) args.push(arguments[position++]);\n      return executeBound(func, bound, this, this, args);\n    };\n    return bound;\n  };\n\n  // Bind a number of an object's methods to that object. Remaining arguments\n  // are the method names to be bound. Useful for ensuring that all callbacks\n  // defined on an object belong to it.\n  _.bindAll = function(obj) {\n    var i, length = arguments.length, key;\n    if (length <= 1) throw new Error('bindAll must be passed function names');\n    for (i = 1; i < length; i++) {\n      key = arguments[i];\n      obj[key] = _.bind(obj[key], obj);\n    }\n    return obj;\n  };\n\n  // Memoize an expensive function by storing its results.\n  _.memoize = function(func, hasher) {\n    var memoize = function(key) {\n      var cache = memoize.cache;\n      var address = '' + (hasher ? hasher.apply(this, arguments) : key);\n      if (!_.has(cache, address)) cache[address] = func.apply(this, arguments);\n      return cache[address];\n    };\n    memoize.cache = {};\n    return memoize;\n  };\n\n  // Delays a function for the given number of milliseconds, and then calls\n  // it with the arguments supplied.\n  _.delay = function(func, wait) {\n    var args = slice.call(arguments, 2);\n    return setTimeout(function(){\n      return func.apply(null, args);\n    }, wait);\n  };\n\n  // Defers a function, scheduling it to run after the current call stack has\n  // cleared.\n  _.defer = _.partial(_.delay, _, 1);\n\n  // Returns a function, that, when invoked, will only be triggered at most once\n  // during a given window of time. Normally, the throttled function will run\n  // as much as it can, without ever going more than once per `wait` duration;\n  // but if you'd like to disable the execution on the leading edge, pass\n  // `{leading: false}`. To disable execution on the trailing edge, ditto.\n  _.throttle = function(func, wait, options) {\n    var context, args, result;\n    var timeout = null;\n    var previous = 0;\n    if (!options) options = {};\n    var later = function() {\n      previous = options.leading === false ? 0 : _.now();\n      timeout = null;\n      result = func.apply(context, args);\n      if (!timeout) context = args = null;\n    };\n    return function() {\n      var now = _.now();\n      if (!previous && options.leading === false) previous = now;\n      var remaining = wait - (now - previous);\n      context = this;\n      args = arguments;\n      if (remaining <= 0 || remaining > wait) {\n        if (timeout) {\n          clearTimeout(timeout);\n          timeout = null;\n        }\n        previous = now;\n        result = func.apply(context, args);\n        if (!timeout) context = args = null;\n      } else if (!timeout && options.trailing !== false) {\n        timeout = setTimeout(later, remaining);\n      }\n      return result;\n    };\n  };\n\n  // Returns a function, that, as long as it continues to be invoked, will not\n  // be triggered. The function will be called after it stops being called for\n  // N milliseconds. If `immediate` is passed, trigger the function on the\n  // leading edge, instead of the trailing.\n  _.debounce = function(func, wait, immediate) {\n    var timeout, args, context, timestamp, result;\n\n    var later = function() {\n      var last = _.now() - timestamp;\n\n      if (last < wait && last >= 0) {\n        timeout = setTimeout(later, wait - last);\n      } else {\n        timeout = null;\n        if (!immediate) {\n          result = func.apply(context, args);\n          if (!timeout) context = args = null;\n        }\n      }\n    };\n\n    return function() {\n      context = this;\n      args = arguments;\n      timestamp = _.now();\n      var callNow = immediate && !timeout;\n      if (!timeout) timeout = setTimeout(later, wait);\n      if (callNow) {\n        result = func.apply(context, args);\n        context = args = null;\n      }\n\n      return result;\n    };\n  };\n\n  // Returns the first function passed as an argument to the second,\n  // allowing you to adjust arguments, run code before and after, and\n  // conditionally execute the original function.\n  _.wrap = function(func, wrapper) {\n    return _.partial(wrapper, func);\n  };\n\n  // Returns a negated version of the passed-in predicate.\n  _.negate = function(predicate) {\n    return function() {\n      return !predicate.apply(this, arguments);\n    };\n  };\n\n  // Returns a function that is the composition of a list of functions, each\n  // consuming the return value of the function that follows.\n  _.compose = function() {\n    var args = arguments;\n    var start = args.length - 1;\n    return function() {\n      var i = start;\n      var result = args[start].apply(this, arguments);\n      while (i--) result = args[i].call(this, result);\n      return result;\n    };\n  };\n\n  // Returns a function that will only be executed on and after the Nth call.\n  _.after = function(times, func) {\n    return function() {\n      if (--times < 1) {\n        return func.apply(this, arguments);\n      }\n    };\n  };\n\n  // Returns a function that will only be executed up to (but not including) the Nth call.\n  _.before = function(times, func) {\n    var memo;\n    return function() {\n      if (--times > 0) {\n        memo = func.apply(this, arguments);\n      }\n      if (times <= 1) func = null;\n      return memo;\n    };\n  };\n\n  // Returns a function that will be executed at most one time, no matter how\n  // often you call it. Useful for lazy initialization.\n  _.once = _.partial(_.before, 2);\n\n  // Object Functions\n  // ----------------\n\n  // Keys in IE < 9 that won't be iterated by `for key in ...` and thus missed.\n  var hasEnumBug = !{toString: null}.propertyIsEnumerable('toString');\n  var nonEnumerableProps = ['valueOf', 'isPrototypeOf', 'toString',\n                      'propertyIsEnumerable', 'hasOwnProperty', 'toLocaleString'];\n\n  function collectNonEnumProps(obj, keys) {\n    var nonEnumIdx = nonEnumerableProps.length;\n    var constructor = obj.constructor;\n    var proto = (_.isFunction(constructor) && constructor.prototype) || ObjProto;\n\n    // Constructor is a special case.\n    var prop = 'constructor';\n    if (_.has(obj, prop) && !_.contains(keys, prop)) keys.push(prop);\n\n    while (nonEnumIdx--) {\n      prop = nonEnumerableProps[nonEnumIdx];\n      if (prop in obj && obj[prop] !== proto[prop] && !_.contains(keys, prop)) {\n        keys.push(prop);\n      }\n    }\n  }\n\n  // Retrieve the names of an object's own properties.\n  // Delegates to **ECMAScript 5**'s native `Object.keys`\n  _.keys = function(obj) {\n    if (!_.isObject(obj)) return [];\n    if (nativeKeys) return nativeKeys(obj);\n    var keys = [];\n    for (var key in obj) if (_.has(obj, key)) keys.push(key);\n    // Ahem, IE < 9.\n    if (hasEnumBug) collectNonEnumProps(obj, keys);\n    return keys;\n  };\n\n  // Retrieve all the property names of an object.\n  _.allKeys = function(obj) {\n    if (!_.isObject(obj)) return [];\n    var keys = [];\n    for (var key in obj) keys.push(key);\n    // Ahem, IE < 9.\n    if (hasEnumBug) collectNonEnumProps(obj, keys);\n    return keys;\n  };\n\n  // Retrieve the values of an object's properties.\n  _.values = function(obj) {\n    var keys = _.keys(obj);\n    var length = keys.length;\n    var values = Array(length);\n    for (var i = 0; i < length; i++) {\n      values[i] = obj[keys[i]];\n    }\n    return values;\n  };\n\n  // Returns the results of applying the iteratee to each element of the object\n  // In contrast to _.map it returns an object\n  _.mapObject = function(obj, iteratee, context) {\n    iteratee = cb(iteratee, context);\n    var keys =  _.keys(obj),\n          length = keys.length,\n          results = {},\n          currentKey;\n      for (var index = 0; index < length; index++) {\n        currentKey = keys[index];\n        results[currentKey] = iteratee(obj[currentKey], currentKey, obj);\n      }\n      return results;\n  };\n\n  // Convert an object into a list of `[key, value]` pairs.\n  _.pairs = function(obj) {\n    var keys = _.keys(obj);\n    var length = keys.length;\n    var pairs = Array(length);\n    for (var i = 0; i < length; i++) {\n      pairs[i] = [keys[i], obj[keys[i]]];\n    }\n    return pairs;\n  };\n\n  // Invert the keys and values of an object. The values must be serializable.\n  _.invert = function(obj) {\n    var result = {};\n    var keys = _.keys(obj);\n    for (var i = 0, length = keys.length; i < length; i++) {\n      result[obj[keys[i]]] = keys[i];\n    }\n    return result;\n  };\n\n  // Return a sorted list of the function names available on the object.\n  // Aliased as `methods`\n  _.functions = _.methods = function(obj) {\n    var names = [];\n    for (var key in obj) {\n      if (_.isFunction(obj[key])) names.push(key);\n    }\n    return names.sort();\n  };\n\n  // Extend a given object with all the properties in passed-in object(s).\n  _.extend = createAssigner(_.allKeys);\n\n  // Assigns a given object with all the own properties in the passed-in object(s)\n  // (https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/assign)\n  _.extendOwn = _.assign = createAssigner(_.keys);\n\n  // Returns the first key on an object that passes a predicate test\n  _.findKey = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var keys = _.keys(obj), key;\n    for (var i = 0, length = keys.length; i < length; i++) {\n      key = keys[i];\n      if (predicate(obj[key], key, obj)) return key;\n    }\n  };\n\n  // Return a copy of the object only containing the whitelisted properties.\n  _.pick = function(object, oiteratee, context) {\n    var result = {}, obj = object, iteratee, keys;\n    if (obj == null) return result;\n    if (_.isFunction(oiteratee)) {\n      keys = _.allKeys(obj);\n      iteratee = optimizeCb(oiteratee, context);\n    } else {\n      keys = flatten(arguments, false, false, 1);\n      iteratee = function(value, key, obj) { return key in obj; };\n      obj = Object(obj);\n    }\n    for (var i = 0, length = keys.length; i < length; i++) {\n      var key = keys[i];\n      var value = obj[key];\n      if (iteratee(value, key, obj)) result[key] = value;\n    }\n    return result;\n  };\n\n   // Return a copy of the object without the blacklisted properties.\n  _.omit = function(obj, iteratee, context) {\n    if (_.isFunction(iteratee)) {\n      iteratee = _.negate(iteratee);\n    } else {\n      var keys = _.map(flatten(arguments, false, false, 1), String);\n      iteratee = function(value, key) {\n        return !_.contains(keys, key);\n      };\n    }\n    return _.pick(obj, iteratee, context);\n  };\n\n  // Fill in a given object with default properties.\n  _.defaults = createAssigner(_.allKeys, true);\n\n  // Create a (shallow-cloned) duplicate of an object.\n  _.clone = function(obj) {\n    if (!_.isObject(obj)) return obj;\n    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);\n  };\n\n  // Invokes interceptor with the obj, and then returns obj.\n  // The primary purpose of this method is to \"tap into\" a method chain, in\n  // order to perform operations on intermediate results within the chain.\n  _.tap = function(obj, interceptor) {\n    interceptor(obj);\n    return obj;\n  };\n\n  // Returns whether an object has a given set of `key:value` pairs.\n  _.isMatch = function(object, attrs) {\n    var keys = _.keys(attrs), length = keys.length;\n    if (object == null) return !length;\n    var obj = Object(object);\n    for (var i = 0; i < length; i++) {\n      var key = keys[i];\n      if (attrs[key] !== obj[key] || !(key in obj)) return false;\n    }\n    return true;\n  };\n\n\n  // Internal recursive comparison function for `isEqual`.\n  var eq = function(a, b, aStack, bStack) {\n    // Identical objects are equal. `0 === -0`, but they aren't identical.\n    // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).\n    if (a === b) return a !== 0 || 1 / a === 1 / b;\n    // A strict comparison is necessary because `null == undefined`.\n    if (a == null || b == null) return a === b;\n    // Unwrap any wrapped objects.\n    if (a instanceof _) a = a._wrapped;\n    if (b instanceof _) b = b._wrapped;\n    // Compare `[[Class]]` names.\n    var className = toString.call(a);\n    if (className !== toString.call(b)) return false;\n    switch (className) {\n      // Strings, numbers, regular expressions, dates, and booleans are compared by value.\n      case '[object RegExp]':\n      // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')\n      case '[object String]':\n        // Primitives and their corresponding object wrappers are equivalent; thus, `\"5\"` is\n        // equivalent to `new String(\"5\")`.\n        return '' + a === '' + b;\n      case '[object Number]':\n        // `NaN`s are equivalent, but non-reflexive.\n        // Object(NaN) is equivalent to NaN\n        if (+a !== +a) return +b !== +b;\n        // An `egal` comparison is performed for other numeric values.\n        return +a === 0 ? 1 / +a === 1 / b : +a === +b;\n      case '[object Date]':\n      case '[object Boolean]':\n        // Coerce dates and booleans to numeric primitive values. Dates are compared by their\n        // millisecond representations. Note that invalid dates with millisecond representations\n        // of `NaN` are not equivalent.\n        return +a === +b;\n    }\n\n    var areArrays = className === '[object Array]';\n    if (!areArrays) {\n      if (typeof a != 'object' || typeof b != 'object') return false;\n\n      // Objects with different constructors are not equivalent, but `Object`s or `Array`s\n      // from different frames are.\n      var aCtor = a.constructor, bCtor = b.constructor;\n      if (aCtor !== bCtor && !(_.isFunction(aCtor) && aCtor instanceof aCtor &&\n                               _.isFunction(bCtor) && bCtor instanceof bCtor)\n                          && ('constructor' in a && 'constructor' in b)) {\n        return false;\n      }\n    }\n    // Assume equality for cyclic structures. The algorithm for detecting cyclic\n    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.\n    \n    // Initializing stack of traversed objects.\n    // It's done here since we only need them for objects and arrays comparison.\n    aStack = aStack || [];\n    bStack = bStack || [];\n    var length = aStack.length;\n    while (length--) {\n      // Linear search. Performance is inversely proportional to the number of\n      // unique nested structures.\n      if (aStack[length] === a) return bStack[length] === b;\n    }\n\n    // Add the first object to the stack of traversed objects.\n    aStack.push(a);\n    bStack.push(b);\n\n    // Recursively compare objects and arrays.\n    if (areArrays) {\n      // Compare array lengths to determine if a deep comparison is necessary.\n      length = a.length;\n      if (length !== b.length) return false;\n      // Deep compare the contents, ignoring non-numeric properties.\n      while (length--) {\n        if (!eq(a[length], b[length], aStack, bStack)) return false;\n      }\n    } else {\n      // Deep compare objects.\n      var keys = _.keys(a), key;\n      length = keys.length;\n      // Ensure that both objects contain the same number of properties before comparing deep equality.\n      if (_.keys(b).length !== length) return false;\n      while (length--) {\n        // Deep compare each member\n        key = keys[length];\n        if (!(_.has(b, key) && eq(a[key], b[key], aStack, bStack))) return false;\n      }\n    }\n    // Remove the first object from the stack of traversed objects.\n    aStack.pop();\n    bStack.pop();\n    return true;\n  };\n\n  // Perform a deep comparison to check if two objects are equal.\n  _.isEqual = function(a, b) {\n    return eq(a, b);\n  };\n\n  // Is a given array, string, or object empty?\n  // An \"empty\" object has no enumerable own-properties.\n  _.isEmpty = function(obj) {\n    if (obj == null) return true;\n    if (isArrayLike(obj) && (_.isArray(obj) || _.isString(obj) || _.isArguments(obj))) return obj.length === 0;\n    return _.keys(obj).length === 0;\n  };\n\n  // Is a given value a DOM element?\n  _.isElement = function(obj) {\n    return !!(obj && obj.nodeType === 1);\n  };\n\n  // Is a given value an array?\n  // Delegates to ECMA5's native Array.isArray\n  _.isArray = nativeIsArray || function(obj) {\n    return toString.call(obj) === '[object Array]';\n  };\n\n  // Is a given variable an object?\n  _.isObject = function(obj) {\n    var type = typeof obj;\n    return type === 'function' || type === 'object' && !!obj;\n  };\n\n  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp, isError.\n  _.each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp', 'Error'], function(name) {\n    _['is' + name] = function(obj) {\n      return toString.call(obj) === '[object ' + name + ']';\n    };\n  });\n\n  // Define a fallback version of the method in browsers (ahem, IE < 9), where\n  // there isn't any inspectable \"Arguments\" type.\n  if (!_.isArguments(arguments)) {\n    _.isArguments = function(obj) {\n      return _.has(obj, 'callee');\n    };\n  }\n\n  // Optimize `isFunction` if appropriate. Work around some typeof bugs in old v8,\n  // IE 11 (#1621), and in Safari 8 (#1929).\n  if (typeof /./ != 'function' && typeof Int8Array != 'object') {\n    _.isFunction = function(obj) {\n      return typeof obj == 'function' || false;\n    };\n  }\n\n  // Is a given object a finite number?\n  _.isFinite = function(obj) {\n    return isFinite(obj) && !isNaN(parseFloat(obj));\n  };\n\n  // Is the given value `NaN`? (NaN is the only number which does not equal itself).\n  _.isNaN = function(obj) {\n    return _.isNumber(obj) && obj !== +obj;\n  };\n\n  // Is a given value a boolean?\n  _.isBoolean = function(obj) {\n    return obj === true || obj === false || toString.call(obj) === '[object Boolean]';\n  };\n\n  // Is a given value equal to null?\n  _.isNull = function(obj) {\n    return obj === null;\n  };\n\n  // Is a given variable undefined?\n  _.isUndefined = function(obj) {\n    return obj === void 0;\n  };\n\n  // Shortcut function for checking if an object has a given property directly\n  // on itself (in other words, not on a prototype).\n  _.has = function(obj, key) {\n    return obj != null && hasOwnProperty.call(obj, key);\n  };\n\n  // Utility Functions\n  // -----------------\n\n  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its\n  // previous owner. Returns a reference to the Underscore object.\n  _.noConflict = function() {\n    root._ = previousUnderscore;\n    return this;\n  };\n\n  // Keep the identity function around for default iteratees.\n  _.identity = function(value) {\n    return value;\n  };\n\n  // Predicate-generating functions. Often useful outside of Underscore.\n  _.constant = function(value) {\n    return function() {\n      return value;\n    };\n  };\n\n  _.noop = function(){};\n\n  _.property = function(key) {\n    return function(obj) {\n      return obj == null ? void 0 : obj[key];\n    };\n  };\n\n  // Generates a function for a given object that returns a given property.\n  _.propertyOf = function(obj) {\n    return obj == null ? function(){} : function(key) {\n      return obj[key];\n    };\n  };\n\n  // Returns a predicate for checking whether an object has a given set of \n  // `key:value` pairs.\n  _.matcher = _.matches = function(attrs) {\n    attrs = _.extendOwn({}, attrs);\n    return function(obj) {\n      return _.isMatch(obj, attrs);\n    };\n  };\n\n  // Run a function **n** times.\n  _.times = function(n, iteratee, context) {\n    var accum = Array(Math.max(0, n));\n    iteratee = optimizeCb(iteratee, context, 1);\n    for (var i = 0; i < n; i++) accum[i] = iteratee(i);\n    return accum;\n  };\n\n  // Return a random integer between min and max (inclusive).\n  _.random = function(min, max) {\n    if (max == null) {\n      max = min;\n      min = 0;\n    }\n    return min + Math.floor(Math.random() * (max - min + 1));\n  };\n\n  // A (possibly faster) way to get the current timestamp as an integer.\n  _.now = Date.now || function() {\n    return new Date().getTime();\n  };\n\n   // List of HTML entities for escaping.\n  var escapeMap = {\n    '&': '&amp;',\n    '<': '&lt;',\n    '>': '&gt;',\n    '\"': '&quot;',\n    \"'\": '&#x27;',\n    '`': '&#x60;'\n  };\n  var unescapeMap = _.invert(escapeMap);\n\n  // Functions for escaping and unescaping strings to/from HTML interpolation.\n  var createEscaper = function(map) {\n    var escaper = function(match) {\n      return map[match];\n    };\n    // Regexes for identifying a key that needs to be escaped\n    var source = '(?:' + _.keys(map).join('|') + ')';\n    var testRegexp = RegExp(source);\n    var replaceRegexp = RegExp(source, 'g');\n    return function(string) {\n      string = string == null ? '' : '' + string;\n      return testRegexp.test(string) ? string.replace(replaceRegexp, escaper) : string;\n    };\n  };\n  _.escape = createEscaper(escapeMap);\n  _.unescape = createEscaper(unescapeMap);\n\n  // If the value of the named `property` is a function then invoke it with the\n  // `object` as context; otherwise, return it.\n  _.result = function(object, property, fallback) {\n    var value = object == null ? void 0 : object[property];\n    if (value === void 0) {\n      value = fallback;\n    }\n    return _.isFunction(value) ? value.call(object) : value;\n  };\n\n  // Generate a unique integer id (unique within the entire client session).\n  // Useful for temporary DOM ids.\n  var idCounter = 0;\n  _.uniqueId = function(prefix) {\n    var id = ++idCounter + '';\n    return prefix ? prefix + id : id;\n  };\n\n  // By default, Underscore uses ERB-style template delimiters, change the\n  // following template settings to use alternative delimiters.\n  _.templateSettings = {\n    evaluate    : /<%([\\s\\S]+?)%>/g,\n    interpolate : /<%=([\\s\\S]+?)%>/g,\n    escape      : /<%-([\\s\\S]+?)%>/g\n  };\n\n  // When customizing `templateSettings`, if you don't want to define an\n  // interpolation, evaluation or escaping regex, we need one that is\n  // guaranteed not to match.\n  var noMatch = /(.)^/;\n\n  // Certain characters need to be escaped so that they can be put into a\n  // string literal.\n  var escapes = {\n    \"'\":      \"'\",\n    '\\\\':     '\\\\',\n    '\\r':     'r',\n    '\\n':     'n',\n    '\\u2028': 'u2028',\n    '\\u2029': 'u2029'\n  };\n\n  var escaper = /\\\\|'|\\r|\\n|\\u2028|\\u2029/g;\n\n  var escapeChar = function(match) {\n    return '\\\\' + escapes[match];\n  };\n\n  // JavaScript micro-templating, similar to John Resig's implementation.\n  // Underscore templating handles arbitrary delimiters, preserves whitespace,\n  // and correctly escapes quotes within interpolated code.\n  // NB: `oldSettings` only exists for backwards compatibility.\n  _.template = function(text, settings, oldSettings) {\n    if (!settings && oldSettings) settings = oldSettings;\n    settings = _.defaults({}, settings, _.templateSettings);\n\n    // Combine delimiters into one regular expression via alternation.\n    var matcher = RegExp([\n      (settings.escape || noMatch).source,\n      (settings.interpolate || noMatch).source,\n      (settings.evaluate || noMatch).source\n    ].join('|') + '|$', 'g');\n\n    // Compile the template source, escaping string literals appropriately.\n    var index = 0;\n    var source = \"__p+='\";\n    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {\n      source += text.slice(index, offset).replace(escaper, escapeChar);\n      index = offset + match.length;\n\n      if (escape) {\n        source += \"'+\\n((__t=(\" + escape + \"))==null?'':_.escape(__t))+\\n'\";\n      } else if (interpolate) {\n        source += \"'+\\n((__t=(\" + interpolate + \"))==null?'':__t)+\\n'\";\n      } else if (evaluate) {\n        source += \"';\\n\" + evaluate + \"\\n__p+='\";\n      }\n\n      // Adobe VMs need the match returned to produce the correct offest.\n      return match;\n    });\n    source += \"';\\n\";\n\n    // If a variable is not specified, place data values in local scope.\n    if (!settings.variable) source = 'with(obj||{}){\\n' + source + '}\\n';\n\n    source = \"var __t,__p='',__j=Array.prototype.join,\" +\n      \"print=function(){__p+=__j.call(arguments,'');};\\n\" +\n      source + 'return __p;\\n';\n\n    try {\n      var render = new Function(settings.variable || 'obj', '_', source);\n    } catch (e) {\n      e.source = source;\n      throw e;\n    }\n\n    var template = function(data) {\n      return render.call(this, data, _);\n    };\n\n    // Provide the compiled source as a convenience for precompilation.\n    var argument = settings.variable || 'obj';\n    template.source = 'function(' + argument + '){\\n' + source + '}';\n\n    return template;\n  };\n\n  // Add a \"chain\" function. Start chaining a wrapped Underscore object.\n  _.chain = function(obj) {\n    var instance = _(obj);\n    instance._chain = true;\n    return instance;\n  };\n\n  // OOP\n  // ---------------\n  // If Underscore is called as a function, it returns a wrapped object that\n  // can be used OO-style. This wrapper holds altered versions of all the\n  // underscore functions. Wrapped objects may be chained.\n\n  // Helper function to continue chaining intermediate results.\n  var result = function(instance, obj) {\n    return instance._chain ? _(obj).chain() : obj;\n  };\n\n  // Add your own custom functions to the Underscore object.\n  _.mixin = function(obj) {\n    _.each(_.functions(obj), function(name) {\n      var func = _[name] = obj[name];\n      _.prototype[name] = function() {\n        var args = [this._wrapped];\n        push.apply(args, arguments);\n        return result(this, func.apply(_, args));\n      };\n    });\n  };\n\n  // Add all of the Underscore functions to the wrapper object.\n  _.mixin(_);\n\n  // Add all mutator Array functions to the wrapper.\n  _.each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {\n    var method = ArrayProto[name];\n    _.prototype[name] = function() {\n      var obj = this._wrapped;\n      method.apply(obj, arguments);\n      if ((name === 'shift' || name === 'splice') && obj.length === 0) delete obj[0];\n      return result(this, obj);\n    };\n  });\n\n  // Add all accessor Array functions to the wrapper.\n  _.each(['concat', 'join', 'slice'], function(name) {\n    var method = ArrayProto[name];\n    _.prototype[name] = function() {\n      return result(this, method.apply(this._wrapped, arguments));\n    };\n  });\n\n  // Extracts the result from a wrapped and chained object.\n  _.prototype.value = function() {\n    return this._wrapped;\n  };\n\n  // Provide unwrapping proxy for some methods used in engine operations\n  // such as arithmetic and JSON stringification.\n  _.prototype.valueOf = _.prototype.toJSON = _.prototype.value;\n  \n  _.prototype.toString = function() {\n    return '' + this._wrapped;\n  };\n\n  // AMD registration happens at the end for compatibility with AMD loaders\n  // that may not enforce next-turn semantics on modules. Even though general\n  // practice for AMD registration is to be anonymous, underscore registers\n  // as a named module because, like jQuery, it is a base library that is\n  // popular enough to be bundled in a third party lib, but not be part of\n  // an AMD load request. Those cases could generate an error when an\n  // anonymous define() is called outside of a loader request.\n  if (typeof define === 'function' && define.amd) {\n    define('underscore', [], function() {\n      return _;\n    });\n  }\n}.call(this));","moment.js":"//! moment.js\n//! version : 2.17.1\n//! authors : Tim Wood, Iskren Chernev, Moment.js contributors\n//! license : MIT\n//! momentjs.com\n!function(a,b){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=b():\"function\"==typeof define&&define.amd?define(b):a.moment=b()}(this,function(){\"use strict\";function a(){return od.apply(null,arguments)}\n// This is done to register the method called with moment()\n// without creating circular dependencies.\n    function b(a){od=a}function c(a){return a instanceof Array||\"[object Array]\"===Object.prototype.toString.call(a)}function d(a){\n// IE8 will treat undefined and null as object if it wasn't for\n// input != null\n        return null!=a&&\"[object Object]\"===Object.prototype.toString.call(a)}function e(a){var b;for(b in a)\n// even if its not own property I'd still call it non-empty\n        return!1;return!0}function f(a){return\"number\"==typeof a||\"[object Number]\"===Object.prototype.toString.call(a)}function g(a){return a instanceof Date||\"[object Date]\"===Object.prototype.toString.call(a)}function h(a,b){var c,d=[];for(c=0;c<a.length;++c)d.push(b(a[c],c));return d}function i(a,b){return Object.prototype.hasOwnProperty.call(a,b)}function j(a,b){for(var c in b)i(b,c)&&(a[c]=b[c]);return i(b,\"toString\")&&(a.toString=b.toString),i(b,\"valueOf\")&&(a.valueOf=b.valueOf),a}function k(a,b,c,d){return rb(a,b,c,d,!0).utc()}function l(){\n// We need to deep clone this object.\n        return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null}}function m(a){return null==a._pf&&(a._pf=l()),a._pf}function n(a){if(null==a._isValid){var b=m(a),c=qd.call(b.parsedDateParts,function(a){return null!=a}),d=!isNaN(a._d.getTime())&&b.overflow<0&&!b.empty&&!b.invalidMonth&&!b.invalidWeekday&&!b.nullInput&&!b.invalidFormat&&!b.userInvalidated&&(!b.meridiem||b.meridiem&&c);if(a._strict&&(d=d&&0===b.charsLeftOver&&0===b.unusedTokens.length&&void 0===b.bigHour),null!=Object.isFrozen&&Object.isFrozen(a))return d;a._isValid=d}return a._isValid}function o(a){var b=k(NaN);return null!=a?j(m(b),a):m(b).userInvalidated=!0,b}function p(a){return void 0===a}function q(a,b){var c,d,e;if(p(b._isAMomentObject)||(a._isAMomentObject=b._isAMomentObject),p(b._i)||(a._i=b._i),p(b._f)||(a._f=b._f),p(b._l)||(a._l=b._l),p(b._strict)||(a._strict=b._strict),p(b._tzm)||(a._tzm=b._tzm),p(b._isUTC)||(a._isUTC=b._isUTC),p(b._offset)||(a._offset=b._offset),p(b._pf)||(a._pf=m(b)),p(b._locale)||(a._locale=b._locale),rd.length>0)for(c in rd)d=rd[c],e=b[d],p(e)||(a[d]=e);return a}\n// Moment prototype object\n    function r(b){q(this,b),this._d=new Date(null!=b._d?b._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),\n// Prevent infinite loop in case updateOffset creates new moment\n// objects.\n    sd===!1&&(sd=!0,a.updateOffset(this),sd=!1)}function s(a){return a instanceof r||null!=a&&null!=a._isAMomentObject}function t(a){return a<0?Math.ceil(a)||0:Math.floor(a)}function u(a){var b=+a,c=0;return 0!==b&&isFinite(b)&&(c=t(b)),c}\n// compare two arrays, return the number of differences\n    function v(a,b,c){var d,e=Math.min(a.length,b.length),f=Math.abs(a.length-b.length),g=0;for(d=0;d<e;d++)(c&&a[d]!==b[d]||!c&&u(a[d])!==u(b[d]))&&g++;return g+f}function w(b){a.suppressDeprecationWarnings===!1&&\"undefined\"!=typeof console&&console.warn&&console.warn(\"Deprecation warning: \"+b)}function x(b,c){var d=!0;return j(function(){if(null!=a.deprecationHandler&&a.deprecationHandler(null,b),d){for(var e,f=[],g=0;g<arguments.length;g++){if(e=\"\",\"object\"==typeof arguments[g]){e+=\"\\n[\"+g+\"] \";for(var h in arguments[0])e+=h+\": \"+arguments[0][h]+\", \";e=e.slice(0,-2)}else e=arguments[g];f.push(e)}w(b+\"\\nArguments: \"+Array.prototype.slice.call(f).join(\"\")+\"\\n\"+(new Error).stack),d=!1}return c.apply(this,arguments)},c)}function y(b,c){null!=a.deprecationHandler&&a.deprecationHandler(b,c),td[b]||(w(c),td[b]=!0)}function z(a){return a instanceof Function||\"[object Function]\"===Object.prototype.toString.call(a)}function A(a){var b,c;for(c in a)b=a[c],z(b)?this[c]=b:this[\"_\"+c]=b;this._config=a,\n// Lenient ordinal parsing accepts just a number in addition to\n// number + (possibly) stuff coming from _ordinalParseLenient.\n        this._ordinalParseLenient=new RegExp(this._ordinalParse.source+\"|\"+/\\d{1,2}/.source)}function B(a,b){var c,e=j({},a);for(c in b)i(b,c)&&(d(a[c])&&d(b[c])?(e[c]={},j(e[c],a[c]),j(e[c],b[c])):null!=b[c]?e[c]=b[c]:delete e[c]);for(c in a)i(a,c)&&!i(b,c)&&d(a[c])&&(\n// make sure changes to properties don't modify parent config\n        e[c]=j({},e[c]));return e}function C(a){null!=a&&this.set(a)}function D(a,b,c){var d=this._calendar[a]||this._calendar.sameElse;return z(d)?d.call(b,c):d}function E(a){var b=this._longDateFormat[a],c=this._longDateFormat[a.toUpperCase()];return b||!c?b:(this._longDateFormat[a]=c.replace(/MMMM|MM|DD|dddd/g,function(a){return a.slice(1)}),this._longDateFormat[a])}function F(){return this._invalidDate}function G(a){return this._ordinal.replace(\"%d\",a)}function H(a,b,c,d){var e=this._relativeTime[c];return z(e)?e(a,b,c,d):e.replace(/%d/i,a)}function I(a,b){var c=this._relativeTime[a>0?\"future\":\"past\"];return z(c)?c(b):c.replace(/%s/i,b)}function J(a,b){var c=a.toLowerCase();Dd[c]=Dd[c+\"s\"]=Dd[b]=a}function K(a){return\"string\"==typeof a?Dd[a]||Dd[a.toLowerCase()]:void 0}function L(a){var b,c,d={};for(c in a)i(a,c)&&(b=K(c),b&&(d[b]=a[c]));return d}function M(a,b){Ed[a]=b}function N(a){var b=[];for(var c in a)b.push({unit:c,priority:Ed[c]});return b.sort(function(a,b){return a.priority-b.priority}),b}function O(b,c){return function(d){return null!=d?(Q(this,b,d),a.updateOffset(this,c),this):P(this,b)}}function P(a,b){return a.isValid()?a._d[\"get\"+(a._isUTC?\"UTC\":\"\")+b]():NaN}function Q(a,b,c){a.isValid()&&a._d[\"set\"+(a._isUTC?\"UTC\":\"\")+b](c)}\n// MOMENTS\n    function R(a){return a=K(a),z(this[a])?this[a]():this}function S(a,b){if(\"object\"==typeof a){a=L(a);for(var c=N(a),d=0;d<c.length;d++)this[c[d].unit](a[c[d].unit])}else if(a=K(a),z(this[a]))return this[a](b);return this}function T(a,b,c){var d=\"\"+Math.abs(a),e=b-d.length,f=a>=0;return(f?c?\"+\":\"\":\"-\")+Math.pow(10,Math.max(0,e)).toString().substr(1)+d}\n// token:    'M'\n// padded:   ['MM', 2]\n// ordinal:  'Mo'\n// callback: function () { this.month() + 1 }\n    function U(a,b,c,d){var e=d;\"string\"==typeof d&&(e=function(){return this[d]()}),a&&(Id[a]=e),b&&(Id[b[0]]=function(){return T(e.apply(this,arguments),b[1],b[2])}),c&&(Id[c]=function(){return this.localeData().ordinal(e.apply(this,arguments),a)})}function V(a){return a.match(/\\[[\\s\\S]/)?a.replace(/^\\[|\\]$/g,\"\"):a.replace(/\\\\/g,\"\")}function W(a){var b,c,d=a.match(Fd);for(b=0,c=d.length;b<c;b++)Id[d[b]]?d[b]=Id[d[b]]:d[b]=V(d[b]);return function(b){var e,f=\"\";for(e=0;e<c;e++)f+=d[e]instanceof Function?d[e].call(b,a):d[e];return f}}\n// format date using native date object\n    function X(a,b){return a.isValid()?(b=Y(b,a.localeData()),Hd[b]=Hd[b]||W(b),Hd[b](a)):a.localeData().invalidDate()}function Y(a,b){function c(a){return b.longDateFormat(a)||a}var d=5;for(Gd.lastIndex=0;d>=0&&Gd.test(a);)a=a.replace(Gd,c),Gd.lastIndex=0,d-=1;return a}function Z(a,b,c){$d[a]=z(b)?b:function(a,d){return a&&c?c:b}}function $(a,b){return i($d,a)?$d[a](b._strict,b._locale):new RegExp(_(a))}\n// Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript\n    function _(a){return aa(a.replace(\"\\\\\",\"\").replace(/\\\\(\\[)|\\\\(\\])|\\[([^\\]\\[]*)\\]|\\\\(.)/g,function(a,b,c,d,e){return b||c||d||e}))}function aa(a){return a.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g,\"\\\\$&\")}function ba(a,b){var c,d=b;for(\"string\"==typeof a&&(a=[a]),f(b)&&(d=function(a,c){c[b]=u(a)}),c=0;c<a.length;c++)_d[a[c]]=d}function ca(a,b){ba(a,function(a,c,d,e){d._w=d._w||{},b(a,d._w,d,e)})}function da(a,b,c){null!=b&&i(_d,a)&&_d[a](b,c._a,c,a)}function ea(a,b){return new Date(Date.UTC(a,b+1,0)).getUTCDate()}function fa(a,b){return a?c(this._months)?this._months[a.month()]:this._months[(this._months.isFormat||ke).test(b)?\"format\":\"standalone\"][a.month()]:this._months}function ga(a,b){return a?c(this._monthsShort)?this._monthsShort[a.month()]:this._monthsShort[ke.test(b)?\"format\":\"standalone\"][a.month()]:this._monthsShort}function ha(a,b,c){var d,e,f,g=a.toLocaleLowerCase();if(!this._monthsParse)for(\n// this is not used\n        this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],d=0;d<12;++d)f=k([2e3,d]),this._shortMonthsParse[d]=this.monthsShort(f,\"\").toLocaleLowerCase(),this._longMonthsParse[d]=this.months(f,\"\").toLocaleLowerCase();return c?\"MMM\"===b?(e=je.call(this._shortMonthsParse,g),e!==-1?e:null):(e=je.call(this._longMonthsParse,g),e!==-1?e:null):\"MMM\"===b?(e=je.call(this._shortMonthsParse,g),e!==-1?e:(e=je.call(this._longMonthsParse,g),e!==-1?e:null)):(e=je.call(this._longMonthsParse,g),e!==-1?e:(e=je.call(this._shortMonthsParse,g),e!==-1?e:null))}function ia(a,b,c){var d,e,f;if(this._monthsParseExact)return ha.call(this,a,b,c);\n// TODO: add sorting\n// Sorting makes sure if one month (or abbr) is a prefix of another\n// see sorting in computeMonthsParse\n        for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),d=0;d<12;d++){\n// test the regex\n            if(\n// make the regex if we don't have it already\n                e=k([2e3,d]),c&&!this._longMonthsParse[d]&&(this._longMonthsParse[d]=new RegExp(\"^\"+this.months(e,\"\").replace(\".\",\"\")+\"$\",\"i\"),this._shortMonthsParse[d]=new RegExp(\"^\"+this.monthsShort(e,\"\").replace(\".\",\"\")+\"$\",\"i\")),c||this._monthsParse[d]||(f=\"^\"+this.months(e,\"\")+\"|^\"+this.monthsShort(e,\"\"),this._monthsParse[d]=new RegExp(f.replace(\".\",\"\"),\"i\")),c&&\"MMMM\"===b&&this._longMonthsParse[d].test(a))return d;if(c&&\"MMM\"===b&&this._shortMonthsParse[d].test(a))return d;if(!c&&this._monthsParse[d].test(a))return d}}\n// MOMENTS\n    function ja(a,b){var c;if(!a.isValid())\n// No op\n        return a;if(\"string\"==typeof b)if(/^\\d+$/.test(b))b=u(b);else\n// TODO: Another silent failure?\n    if(b=a.localeData().monthsParse(b),!f(b))return a;return c=Math.min(a.date(),ea(a.year(),b)),a._d[\"set\"+(a._isUTC?\"UTC\":\"\")+\"Month\"](b,c),a}function ka(b){return null!=b?(ja(this,b),a.updateOffset(this,!0),this):P(this,\"Month\")}function la(){return ea(this.year(),this.month())}function ma(a){return this._monthsParseExact?(i(this,\"_monthsRegex\")||oa.call(this),a?this._monthsShortStrictRegex:this._monthsShortRegex):(i(this,\"_monthsShortRegex\")||(this._monthsShortRegex=ne),this._monthsShortStrictRegex&&a?this._monthsShortStrictRegex:this._monthsShortRegex)}function na(a){return this._monthsParseExact?(i(this,\"_monthsRegex\")||oa.call(this),a?this._monthsStrictRegex:this._monthsRegex):(i(this,\"_monthsRegex\")||(this._monthsRegex=oe),this._monthsStrictRegex&&a?this._monthsStrictRegex:this._monthsRegex)}function oa(){function a(a,b){return b.length-a.length}var b,c,d=[],e=[],f=[];for(b=0;b<12;b++)\n// make the regex if we don't have it already\n        c=k([2e3,b]),d.push(this.monthsShort(c,\"\")),e.push(this.months(c,\"\")),f.push(this.months(c,\"\")),f.push(this.monthsShort(c,\"\"));for(\n// Sorting makes sure if one month (or abbr) is a prefix of another it\n// will match the longer piece.\n        d.sort(a),e.sort(a),f.sort(a),b=0;b<12;b++)d[b]=aa(d[b]),e[b]=aa(e[b]);for(b=0;b<24;b++)f[b]=aa(f[b]);this._monthsRegex=new RegExp(\"^(\"+f.join(\"|\")+\")\",\"i\"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp(\"^(\"+e.join(\"|\")+\")\",\"i\"),this._monthsShortStrictRegex=new RegExp(\"^(\"+d.join(\"|\")+\")\",\"i\")}\n// HELPERS\n    function pa(a){return qa(a)?366:365}function qa(a){return a%4===0&&a%100!==0||a%400===0}function ra(){return qa(this.year())}function sa(a,b,c,d,e,f,g){\n//can't just apply() to create a date:\n//http://stackoverflow.com/questions/181348/instantiating-a-javascript-object-by-calling-prototype-constructor-apply\n        var h=new Date(a,b,c,d,e,f,g);\n//the date constructor remaps years 0-99 to 1900-1999\n        return a<100&&a>=0&&isFinite(h.getFullYear())&&h.setFullYear(a),h}function ta(a){var b=new Date(Date.UTC.apply(null,arguments));\n//the Date.UTC function remaps years 0-99 to 1900-1999\n        return a<100&&a>=0&&isFinite(b.getUTCFullYear())&&b.setUTCFullYear(a),b}\n// start-of-first-week - start-of-year\n    function ua(a,b,c){var// first-week day -- which january is always in the first week (4 for iso, 1 for other)\n        d=7+b-c,\n// first-week day local weekday -- which local weekday is fwd\n        e=(7+ta(a,0,d).getUTCDay()-b)%7;return-e+d-1}\n//http://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday\n    function va(a,b,c,d,e){var f,g,h=(7+c-d)%7,i=ua(a,d,e),j=1+7*(b-1)+h+i;return j<=0?(f=a-1,g=pa(f)+j):j>pa(a)?(f=a+1,g=j-pa(a)):(f=a,g=j),{year:f,dayOfYear:g}}function wa(a,b,c){var d,e,f=ua(a.year(),b,c),g=Math.floor((a.dayOfYear()-f-1)/7)+1;return g<1?(e=a.year()-1,d=g+xa(e,b,c)):g>xa(a.year(),b,c)?(d=g-xa(a.year(),b,c),e=a.year()+1):(e=a.year(),d=g),{week:d,year:e}}function xa(a,b,c){var d=ua(a,b,c),e=ua(a+1,b,c);return(pa(a)-d+e)/7}\n// HELPERS\n// LOCALES\n    function ya(a){return wa(a,this._week.dow,this._week.doy).week}function za(){return this._week.dow}function Aa(){return this._week.doy}\n// MOMENTS\n    function Ba(a){var b=this.localeData().week(this);return null==a?b:this.add(7*(a-b),\"d\")}function Ca(a){var b=wa(this,1,4).week;return null==a?b:this.add(7*(a-b),\"d\")}\n// HELPERS\n    function Da(a,b){return\"string\"!=typeof a?a:isNaN(a)?(a=b.weekdaysParse(a),\"number\"==typeof a?a:null):parseInt(a,10)}function Ea(a,b){return\"string\"==typeof a?b.weekdaysParse(a)%7||7:isNaN(a)?null:a}function Fa(a,b){return a?c(this._weekdays)?this._weekdays[a.day()]:this._weekdays[this._weekdays.isFormat.test(b)?\"format\":\"standalone\"][a.day()]:this._weekdays}function Ga(a){return a?this._weekdaysShort[a.day()]:this._weekdaysShort}function Ha(a){return a?this._weekdaysMin[a.day()]:this._weekdaysMin}function Ia(a,b,c){var d,e,f,g=a.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],d=0;d<7;++d)f=k([2e3,1]).day(d),this._minWeekdaysParse[d]=this.weekdaysMin(f,\"\").toLocaleLowerCase(),this._shortWeekdaysParse[d]=this.weekdaysShort(f,\"\").toLocaleLowerCase(),this._weekdaysParse[d]=this.weekdays(f,\"\").toLocaleLowerCase();return c?\"dddd\"===b?(e=je.call(this._weekdaysParse,g),e!==-1?e:null):\"ddd\"===b?(e=je.call(this._shortWeekdaysParse,g),e!==-1?e:null):(e=je.call(this._minWeekdaysParse,g),e!==-1?e:null):\"dddd\"===b?(e=je.call(this._weekdaysParse,g),e!==-1?e:(e=je.call(this._shortWeekdaysParse,g),e!==-1?e:(e=je.call(this._minWeekdaysParse,g),e!==-1?e:null))):\"ddd\"===b?(e=je.call(this._shortWeekdaysParse,g),e!==-1?e:(e=je.call(this._weekdaysParse,g),e!==-1?e:(e=je.call(this._minWeekdaysParse,g),e!==-1?e:null))):(e=je.call(this._minWeekdaysParse,g),e!==-1?e:(e=je.call(this._weekdaysParse,g),e!==-1?e:(e=je.call(this._shortWeekdaysParse,g),e!==-1?e:null)))}function Ja(a,b,c){var d,e,f;if(this._weekdaysParseExact)return Ia.call(this,a,b,c);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),d=0;d<7;d++){\n// test the regex\n        if(\n// make the regex if we don't have it already\n            e=k([2e3,1]).day(d),c&&!this._fullWeekdaysParse[d]&&(this._fullWeekdaysParse[d]=new RegExp(\"^\"+this.weekdays(e,\"\").replace(\".\",\".?\")+\"$\",\"i\"),this._shortWeekdaysParse[d]=new RegExp(\"^\"+this.weekdaysShort(e,\"\").replace(\".\",\".?\")+\"$\",\"i\"),this._minWeekdaysParse[d]=new RegExp(\"^\"+this.weekdaysMin(e,\"\").replace(\".\",\".?\")+\"$\",\"i\")),this._weekdaysParse[d]||(f=\"^\"+this.weekdays(e,\"\")+\"|^\"+this.weekdaysShort(e,\"\")+\"|^\"+this.weekdaysMin(e,\"\"),this._weekdaysParse[d]=new RegExp(f.replace(\".\",\"\"),\"i\")),c&&\"dddd\"===b&&this._fullWeekdaysParse[d].test(a))return d;if(c&&\"ddd\"===b&&this._shortWeekdaysParse[d].test(a))return d;if(c&&\"dd\"===b&&this._minWeekdaysParse[d].test(a))return d;if(!c&&this._weekdaysParse[d].test(a))return d}}\n// MOMENTS\n    function Ka(a){if(!this.isValid())return null!=a?this:NaN;var b=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=a?(a=Da(a,this.localeData()),this.add(a-b,\"d\")):b}function La(a){if(!this.isValid())return null!=a?this:NaN;var b=(this.day()+7-this.localeData()._week.dow)%7;return null==a?b:this.add(a-b,\"d\")}function Ma(a){if(!this.isValid())return null!=a?this:NaN;\n// behaves the same as moment#day except\n// as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)\n// as a setter, sunday should belong to the previous week.\n        if(null!=a){var b=Ea(a,this.localeData());return this.day(this.day()%7?b:b-7)}return this.day()||7}function Na(a){return this._weekdaysParseExact?(i(this,\"_weekdaysRegex\")||Qa.call(this),a?this._weekdaysStrictRegex:this._weekdaysRegex):(i(this,\"_weekdaysRegex\")||(this._weekdaysRegex=ue),this._weekdaysStrictRegex&&a?this._weekdaysStrictRegex:this._weekdaysRegex)}function Oa(a){return this._weekdaysParseExact?(i(this,\"_weekdaysRegex\")||Qa.call(this),a?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(i(this,\"_weekdaysShortRegex\")||(this._weekdaysShortRegex=ve),this._weekdaysShortStrictRegex&&a?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function Pa(a){return this._weekdaysParseExact?(i(this,\"_weekdaysRegex\")||Qa.call(this),a?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(i(this,\"_weekdaysMinRegex\")||(this._weekdaysMinRegex=we),this._weekdaysMinStrictRegex&&a?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function Qa(){function a(a,b){return b.length-a.length}var b,c,d,e,f,g=[],h=[],i=[],j=[];for(b=0;b<7;b++)\n// make the regex if we don't have it already\n        c=k([2e3,1]).day(b),d=this.weekdaysMin(c,\"\"),e=this.weekdaysShort(c,\"\"),f=this.weekdays(c,\"\"),g.push(d),h.push(e),i.push(f),j.push(d),j.push(e),j.push(f);for(\n// Sorting makes sure if one weekday (or abbr) is a prefix of another it\n// will match the longer piece.\n        g.sort(a),h.sort(a),i.sort(a),j.sort(a),b=0;b<7;b++)h[b]=aa(h[b]),i[b]=aa(i[b]),j[b]=aa(j[b]);this._weekdaysRegex=new RegExp(\"^(\"+j.join(\"|\")+\")\",\"i\"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp(\"^(\"+i.join(\"|\")+\")\",\"i\"),this._weekdaysShortStrictRegex=new RegExp(\"^(\"+h.join(\"|\")+\")\",\"i\"),this._weekdaysMinStrictRegex=new RegExp(\"^(\"+g.join(\"|\")+\")\",\"i\")}\n// FORMATTING\n    function Ra(){return this.hours()%12||12}function Sa(){return this.hours()||24}function Ta(a,b){U(a,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),b)})}\n// PARSING\n    function Ua(a,b){return b._meridiemParse}\n// LOCALES\n    function Va(a){\n// IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays\n// Using charAt should be more compatible.\n        return\"p\"===(a+\"\").toLowerCase().charAt(0)}function Wa(a,b,c){return a>11?c?\"pm\":\"PM\":c?\"am\":\"AM\"}function Xa(a){return a?a.toLowerCase().replace(\"_\",\"-\"):a}\n// pick the locale from the array\n// try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each\n// substring from most specific to least, but move to the next array item if it's a more specific variant than the current root\n    function Ya(a){for(var b,c,d,e,f=0;f<a.length;){for(e=Xa(a[f]).split(\"-\"),b=e.length,c=Xa(a[f+1]),c=c?c.split(\"-\"):null;b>0;){if(d=Za(e.slice(0,b).join(\"-\")))return d;if(c&&c.length>=b&&v(e,c,!0)>=b-1)\n//the next array item is better than a shallower substring of this one\n        break;b--}f++}return null}function Za(a){var b=null;\n// TODO: Find a better way to register and load all the locales in Node\n        if(!Be[a]&&\"undefined\"!=typeof module&&module&&module.exports)try{b=xe._abbr,require(\"./locale/\"+a),\n// because defineLocale currently also sets the global locale, we\n// want to undo that for lazy loaded locales\n            $a(b)}catch(a){}return Be[a]}\n// This function will load locale and then set the global locale.  If\n// no arguments are passed in, it will simply return the current global\n// locale key.\n    function $a(a,b){var c;\n// moment.duration._locale = moment._locale = data;\n        return a&&(c=p(b)?bb(a):_a(a,b),c&&(xe=c)),xe._abbr}function _a(a,b){if(null!==b){var c=Ae;if(b.abbr=a,null!=Be[a])y(\"defineLocaleOverride\",\"use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info.\"),c=Be[a]._config;else if(null!=b.parentLocale){if(null==Be[b.parentLocale])return Ce[b.parentLocale]||(Ce[b.parentLocale]=[]),Ce[b.parentLocale].push({name:a,config:b}),null;c=Be[b.parentLocale]._config}\n// backwards compat for now: also set the locale\n// make sure we set the locale AFTER all child locales have been\n// created, so we won't end up with the child locale set.\n        return Be[a]=new C(B(c,b)),Ce[a]&&Ce[a].forEach(function(a){_a(a.name,a.config)}),$a(a),Be[a]}\n// useful for testing\n        return delete Be[a],null}function ab(a,b){if(null!=b){var c,d=Ae;\n// MERGE\n        null!=Be[a]&&(d=Be[a]._config),b=B(d,b),c=new C(b),c.parentLocale=Be[a],Be[a]=c,\n// backwards compat for now: also set the locale\n            $a(a)}else\n// pass null for config to unupdate, useful for tests\n        null!=Be[a]&&(null!=Be[a].parentLocale?Be[a]=Be[a].parentLocale:null!=Be[a]&&delete Be[a]);return Be[a]}\n// returns locale data\n    function bb(a){var b;if(a&&a._locale&&a._locale._abbr&&(a=a._locale._abbr),!a)return xe;if(!c(a)){if(\n//short-circuit everything else\n        b=Za(a))return b;a=[a]}return Ya(a)}function cb(){return wd(Be)}function db(a){var b,c=a._a;return c&&m(a).overflow===-2&&(b=c[be]<0||c[be]>11?be:c[ce]<1||c[ce]>ea(c[ae],c[be])?ce:c[de]<0||c[de]>24||24===c[de]&&(0!==c[ee]||0!==c[fe]||0!==c[ge])?de:c[ee]<0||c[ee]>59?ee:c[fe]<0||c[fe]>59?fe:c[ge]<0||c[ge]>999?ge:-1,m(a)._overflowDayOfYear&&(b<ae||b>ce)&&(b=ce),m(a)._overflowWeeks&&b===-1&&(b=he),m(a)._overflowWeekday&&b===-1&&(b=ie),m(a).overflow=b),a}\n// date from iso format\n    function eb(a){var b,c,d,e,f,g,h=a._i,i=De.exec(h)||Ee.exec(h);if(i){for(m(a).iso=!0,b=0,c=Ge.length;b<c;b++)if(Ge[b][1].exec(i[1])){e=Ge[b][0],d=Ge[b][2]!==!1;break}if(null==e)return void(a._isValid=!1);if(i[3]){for(b=0,c=He.length;b<c;b++)if(He[b][1].exec(i[3])){\n// match[2] should be 'T' or space\n        f=(i[2]||\" \")+He[b][0];break}if(null==f)return void(a._isValid=!1)}if(!d&&null!=f)return void(a._isValid=!1);if(i[4]){if(!Fe.exec(i[4]))return void(a._isValid=!1);g=\"Z\"}a._f=e+(f||\"\")+(g||\"\"),kb(a)}else a._isValid=!1}\n// date from iso format or fallback\n    function fb(b){var c=Ie.exec(b._i);return null!==c?void(b._d=new Date(+c[1])):(eb(b),void(b._isValid===!1&&(delete b._isValid,a.createFromInputFallback(b))))}\n// Pick the first defined of two or three arguments.\n    function gb(a,b,c){return null!=a?a:null!=b?b:c}function hb(b){\n// hooks is actually the exported moment object\n        var c=new Date(a.now());return b._useUTC?[c.getUTCFullYear(),c.getUTCMonth(),c.getUTCDate()]:[c.getFullYear(),c.getMonth(),c.getDate()]}\n// convert an array to a date.\n// the array should mirror the parameters below\n// note: all values past the year are optional and will default to the lowest possible value.\n// [year, month, day , hour, minute, second, millisecond]\n    function ib(a){var b,c,d,e,f=[];if(!a._d){\n// Default to current date.\n// * if no year, month, day of month are given, default to today\n// * if day of month is given, default month and year\n// * if month is given, default only year\n// * if year is given, don't default anything\n        for(d=hb(a),\n//compute day of the year from weeks and weekdays\n            a._w&&null==a._a[ce]&&null==a._a[be]&&jb(a),\n//if the day of the year is set, figure out what it is\n            a._dayOfYear&&(e=gb(a._a[ae],d[ae]),a._dayOfYear>pa(e)&&(m(a)._overflowDayOfYear=!0),c=ta(e,0,a._dayOfYear),a._a[be]=c.getUTCMonth(),a._a[ce]=c.getUTCDate()),b=0;b<3&&null==a._a[b];++b)a._a[b]=f[b]=d[b];\n// Zero out whatever was not defaulted, including time\n        for(;b<7;b++)a._a[b]=f[b]=null==a._a[b]?2===b?1:0:a._a[b];\n// Check for 24:00:00.000\n        24===a._a[de]&&0===a._a[ee]&&0===a._a[fe]&&0===a._a[ge]&&(a._nextDay=!0,a._a[de]=0),a._d=(a._useUTC?ta:sa).apply(null,f),\n// Apply timezone offset from input. The actual utcOffset can be changed\n// with parseZone.\n        null!=a._tzm&&a._d.setUTCMinutes(a._d.getUTCMinutes()-a._tzm),a._nextDay&&(a._a[de]=24)}}function jb(a){var b,c,d,e,f,g,h,i;if(b=a._w,null!=b.GG||null!=b.W||null!=b.E)f=1,g=4,\n// TODO: We need to take the current isoWeekYear, but that depends on\n// how we interpret now (local, utc, fixed offset). So create\n// a now version of current config (take local/utc/offset flags, and\n// create now).\n        c=gb(b.GG,a._a[ae],wa(sb(),1,4).year),d=gb(b.W,1),e=gb(b.E,1),(e<1||e>7)&&(i=!0);else{f=a._locale._week.dow,g=a._locale._week.doy;var j=wa(sb(),f,g);c=gb(b.gg,a._a[ae],j.year),\n// Default to current week.\n        d=gb(b.w,j.week),null!=b.d?(\n// weekday -- low day numbers are considered next week\n        e=b.d,(e<0||e>6)&&(i=!0)):null!=b.e?(\n// local weekday -- counting starts from begining of week\n        e=b.e+f,(b.e<0||b.e>6)&&(i=!0)):\n// default to begining of week\n        e=f}d<1||d>xa(c,f,g)?m(a)._overflowWeeks=!0:null!=i?m(a)._overflowWeekday=!0:(h=va(c,d,e,f,g),a._a[ae]=h.year,a._dayOfYear=h.dayOfYear)}\n// date from string and format string\n    function kb(b){\n// TODO: Move this to another part of the creation flow to prevent circular deps\n        if(b._f===a.ISO_8601)return void eb(b);b._a=[],m(b).empty=!0;\n// This array is used to make a Date, either with `new Date` or `Date.UTC`\n        var c,d,e,f,g,h=\"\"+b._i,i=h.length,j=0;for(e=Y(b._f,b._locale).match(Fd)||[],c=0;c<e.length;c++)f=e[c],d=(h.match($(f,b))||[])[0],\n// console.log('token', token, 'parsedInput', parsedInput,\n//         'regex', getParseRegexForToken(token, config));\n        d&&(g=h.substr(0,h.indexOf(d)),g.length>0&&m(b).unusedInput.push(g),h=h.slice(h.indexOf(d)+d.length),j+=d.length),\n// don't parse if it's not a known token\n            Id[f]?(d?m(b).empty=!1:m(b).unusedTokens.push(f),da(f,d,b)):b._strict&&!d&&m(b).unusedTokens.push(f);\n// add remaining unparsed input length to the string\n        m(b).charsLeftOver=i-j,h.length>0&&m(b).unusedInput.push(h),\n// clear _12h flag if hour is <= 12\n        b._a[de]<=12&&m(b).bigHour===!0&&b._a[de]>0&&(m(b).bigHour=void 0),m(b).parsedDateParts=b._a.slice(0),m(b).meridiem=b._meridiem,\n// handle meridiem\n            b._a[de]=lb(b._locale,b._a[de],b._meridiem),ib(b),db(b)}function lb(a,b,c){var d;\n// Fallback\n        return null==c?b:null!=a.meridiemHour?a.meridiemHour(b,c):null!=a.isPM?(d=a.isPM(c),d&&b<12&&(b+=12),d||12!==b||(b=0),b):b}\n// date from string and array of format strings\n    function mb(a){var b,c,d,e,f;if(0===a._f.length)return m(a).invalidFormat=!0,void(a._d=new Date(NaN));for(e=0;e<a._f.length;e++)f=0,b=q({},a),null!=a._useUTC&&(b._useUTC=a._useUTC),b._f=a._f[e],kb(b),n(b)&&(\n// if there is any input that was not parsed add a penalty for that format\n        f+=m(b).charsLeftOver,\n//or tokens\n        f+=10*m(b).unusedTokens.length,m(b).score=f,(null==d||f<d)&&(d=f,c=b));j(a,c||b)}function nb(a){if(!a._d){var b=L(a._i);a._a=h([b.year,b.month,b.day||b.date,b.hour,b.minute,b.second,b.millisecond],function(a){return a&&parseInt(a,10)}),ib(a)}}function ob(a){var b=new r(db(pb(a)));\n// Adding is smart enough around DST\n        return b._nextDay&&(b.add(1,\"d\"),b._nextDay=void 0),b}function pb(a){var b=a._i,d=a._f;return a._locale=a._locale||bb(a._l),null===b||void 0===d&&\"\"===b?o({nullInput:!0}):(\"string\"==typeof b&&(a._i=b=a._locale.preparse(b)),s(b)?new r(db(b)):(g(b)?a._d=b:c(d)?mb(a):d?kb(a):qb(a),n(a)||(a._d=null),a))}function qb(b){var d=b._i;void 0===d?b._d=new Date(a.now()):g(d)?b._d=new Date(d.valueOf()):\"string\"==typeof d?fb(b):c(d)?(b._a=h(d.slice(0),function(a){return parseInt(a,10)}),ib(b)):\"object\"==typeof d?nb(b):f(d)?\n// from milliseconds\n        b._d=new Date(d):a.createFromInputFallback(b)}function rb(a,b,f,g,h){var i={};\n// object construction must be done this way.\n// https://github.com/moment/moment/issues/1423\n        return f!==!0&&f!==!1||(g=f,f=void 0),(d(a)&&e(a)||c(a)&&0===a.length)&&(a=void 0),i._isAMomentObject=!0,i._useUTC=i._isUTC=h,i._l=f,i._i=a,i._f=b,i._strict=g,ob(i)}function sb(a,b,c,d){return rb(a,b,c,d,!1)}\n// Pick a moment m from moments so that m[fn](other) is true for all\n// other. This relies on the function fn to be transitive.\n//\n// moments should either be an array of moment objects or an array, whose\n// first element is an array of moment objects.\n    function tb(a,b){var d,e;if(1===b.length&&c(b[0])&&(b=b[0]),!b.length)return sb();for(d=b[0],e=1;e<b.length;++e)b[e].isValid()&&!b[e][a](d)||(d=b[e]);return d}\n// TODO: Use [].sort instead?\n    function ub(){var a=[].slice.call(arguments,0);return tb(\"isBefore\",a)}function vb(){var a=[].slice.call(arguments,0);return tb(\"isAfter\",a)}function wb(a){var b=L(a),c=b.year||0,d=b.quarter||0,e=b.month||0,f=b.week||0,g=b.day||0,h=b.hour||0,i=b.minute||0,j=b.second||0,k=b.millisecond||0;\n// representation for dateAddRemove\n        this._milliseconds=+k+1e3*j+// 1000\n            6e4*i+// 1000 * 60\n            1e3*h*60*60,//using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978\n// Because of dateAddRemove treats 24 hours as different from a\n// day when working around DST, we need to store them separately\n            this._days=+g+7*f,\n// It is impossible translate months into days without knowing\n// which months you are are talking about, so we have to store\n// it separately.\n            this._months=+e+3*d+12*c,this._data={},this._locale=bb(),this._bubble()}function xb(a){return a instanceof wb}function yb(a){return a<0?Math.round(-1*a)*-1:Math.round(a)}\n// FORMATTING\n    function zb(a,b){U(a,0,0,function(){var a=this.utcOffset(),c=\"+\";return a<0&&(a=-a,c=\"-\"),c+T(~~(a/60),2)+b+T(~~a%60,2)})}function Ab(a,b){var c=(b||\"\").match(a);if(null===c)return null;var d=c[c.length-1]||[],e=(d+\"\").match(Me)||[\"-\",0,0],f=+(60*e[1])+u(e[2]);return 0===f?0:\"+\"===e[0]?f:-f}\n// Return a moment from input, that is local/utc/zone equivalent to model.\n    function Bb(b,c){var d,e;\n// Use low-level api, because this fn is low-level api.\n        return c._isUTC?(d=c.clone(),e=(s(b)||g(b)?b.valueOf():sb(b).valueOf())-d.valueOf(),d._d.setTime(d._d.valueOf()+e),a.updateOffset(d,!1),d):sb(b).local()}function Cb(a){\n// On Firefox.24 Date#getTimezoneOffset returns a floating point.\n// https://github.com/moment/moment/pull/1871\n        return 15*-Math.round(a._d.getTimezoneOffset()/15)}\n// MOMENTS\n// keepLocalTime = true means only change the timezone, without\n// affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->\n// 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset\n// +0200, so we adjust the time as needed, to be valid.\n//\n// Keeping the time actually adds/subtracts (one hour)\n// from the actual represented time. That is why we call updateOffset\n// a second time. In case it wants us to change the offset again\n// _changeInProgress == true case, then we have to adjust, because\n// there is no such time in the given timezone.\n    function Db(b,c){var d,e=this._offset||0;if(!this.isValid())return null!=b?this:NaN;if(null!=b){if(\"string\"==typeof b){if(b=Ab(Xd,b),null===b)return this}else Math.abs(b)<16&&(b=60*b);return!this._isUTC&&c&&(d=Cb(this)),this._offset=b,this._isUTC=!0,null!=d&&this.add(d,\"m\"),e!==b&&(!c||this._changeInProgress?Tb(this,Ob(b-e,\"m\"),1,!1):this._changeInProgress||(this._changeInProgress=!0,a.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?e:Cb(this)}function Eb(a,b){return null!=a?(\"string\"!=typeof a&&(a=-a),this.utcOffset(a,b),this):-this.utcOffset()}function Fb(a){return this.utcOffset(0,a)}function Gb(a){return this._isUTC&&(this.utcOffset(0,a),this._isUTC=!1,a&&this.subtract(Cb(this),\"m\")),this}function Hb(){if(null!=this._tzm)this.utcOffset(this._tzm);else if(\"string\"==typeof this._i){var a=Ab(Wd,this._i);null!=a?this.utcOffset(a):this.utcOffset(0,!0)}return this}function Ib(a){return!!this.isValid()&&(a=a?sb(a).utcOffset():0,(this.utcOffset()-a)%60===0)}function Jb(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function Kb(){if(!p(this._isDSTShifted))return this._isDSTShifted;var a={};if(q(a,this),a=pb(a),a._a){var b=a._isUTC?k(a._a):sb(a._a);this._isDSTShifted=this.isValid()&&v(a._a,b.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted}function Lb(){return!!this.isValid()&&!this._isUTC}function Mb(){return!!this.isValid()&&this._isUTC}function Nb(){return!!this.isValid()&&(this._isUTC&&0===this._offset)}function Ob(a,b){var c,d,e,g=a,\n// matching against regexp is expensive, do it on demand\n        h=null;// checks for null or undefined\n        return xb(a)?g={ms:a._milliseconds,d:a._days,M:a._months}:f(a)?(g={},b?g[b]=a:g.milliseconds=a):(h=Ne.exec(a))?(c=\"-\"===h[1]?-1:1,g={y:0,d:u(h[ce])*c,h:u(h[de])*c,m:u(h[ee])*c,s:u(h[fe])*c,ms:u(yb(1e3*h[ge]))*c}):(h=Oe.exec(a))?(c=\"-\"===h[1]?-1:1,g={y:Pb(h[2],c),M:Pb(h[3],c),w:Pb(h[4],c),d:Pb(h[5],c),h:Pb(h[6],c),m:Pb(h[7],c),s:Pb(h[8],c)}):null==g?g={}:\"object\"==typeof g&&(\"from\"in g||\"to\"in g)&&(e=Rb(sb(g.from),sb(g.to)),g={},g.ms=e.milliseconds,g.M=e.months),d=new wb(g),xb(a)&&i(a,\"_locale\")&&(d._locale=a._locale),d}function Pb(a,b){\n// We'd normally use ~~inp for this, but unfortunately it also\n// converts floats to ints.\n// inp may be undefined, so careful calling replace on it.\n        var c=a&&parseFloat(a.replace(\",\",\".\"));\n// apply sign while we're at it\n        return(isNaN(c)?0:c)*b}function Qb(a,b){var c={milliseconds:0,months:0};return c.months=b.month()-a.month()+12*(b.year()-a.year()),a.clone().add(c.months,\"M\").isAfter(b)&&--c.months,c.milliseconds=+b-+a.clone().add(c.months,\"M\"),c}function Rb(a,b){var c;return a.isValid()&&b.isValid()?(b=Bb(b,a),a.isBefore(b)?c=Qb(a,b):(c=Qb(b,a),c.milliseconds=-c.milliseconds,c.months=-c.months),c):{milliseconds:0,months:0}}\n// TODO: remove 'name' arg after deprecation is removed\n    function Sb(a,b){return function(c,d){var e,f;\n//invert the arguments, but complain about it\n        return null===d||isNaN(+d)||(y(b,\"moment().\"+b+\"(period, number) is deprecated. Please use moment().\"+b+\"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.\"),f=c,c=d,d=f),c=\"string\"==typeof c?+c:c,e=Ob(c,d),Tb(this,e,a),this}}function Tb(b,c,d,e){var f=c._milliseconds,g=yb(c._days),h=yb(c._months);b.isValid()&&(e=null==e||e,f&&b._d.setTime(b._d.valueOf()+f*d),g&&Q(b,\"Date\",P(b,\"Date\")+g*d),h&&ja(b,P(b,\"Month\")+h*d),e&&a.updateOffset(b,g||h))}function Ub(a,b){var c=a.diff(b,\"days\",!0);return c<-6?\"sameElse\":c<-1?\"lastWeek\":c<0?\"lastDay\":c<1?\"sameDay\":c<2?\"nextDay\":c<7?\"nextWeek\":\"sameElse\"}function Vb(b,c){\n// We want to compare the start of today, vs this.\n// Getting start-of-today depends on whether we're local/utc/offset or not.\n        var d=b||sb(),e=Bb(d,this).startOf(\"day\"),f=a.calendarFormat(this,e)||\"sameElse\",g=c&&(z(c[f])?c[f].call(this,d):c[f]);return this.format(g||this.localeData().calendar(f,this,sb(d)))}function Wb(){return new r(this)}function Xb(a,b){var c=s(a)?a:sb(a);return!(!this.isValid()||!c.isValid())&&(b=K(p(b)?\"millisecond\":b),\"millisecond\"===b?this.valueOf()>c.valueOf():c.valueOf()<this.clone().startOf(b).valueOf())}function Yb(a,b){var c=s(a)?a:sb(a);return!(!this.isValid()||!c.isValid())&&(b=K(p(b)?\"millisecond\":b),\"millisecond\"===b?this.valueOf()<c.valueOf():this.clone().endOf(b).valueOf()<c.valueOf())}function Zb(a,b,c,d){return d=d||\"()\",(\"(\"===d[0]?this.isAfter(a,c):!this.isBefore(a,c))&&(\")\"===d[1]?this.isBefore(b,c):!this.isAfter(b,c))}function $b(a,b){var c,d=s(a)?a:sb(a);return!(!this.isValid()||!d.isValid())&&(b=K(b||\"millisecond\"),\"millisecond\"===b?this.valueOf()===d.valueOf():(c=d.valueOf(),this.clone().startOf(b).valueOf()<=c&&c<=this.clone().endOf(b).valueOf()))}function _b(a,b){return this.isSame(a,b)||this.isAfter(a,b)}function ac(a,b){return this.isSame(a,b)||this.isBefore(a,b)}function bc(a,b,c){var d,e,f,g;// 1000\n// 1000 * 60\n// 1000 * 60 * 60\n// 1000 * 60 * 60 * 24, negate dst\n// 1000 * 60 * 60 * 24 * 7, negate dst\n        return this.isValid()?(d=Bb(a,this),d.isValid()?(e=6e4*(d.utcOffset()-this.utcOffset()),b=K(b),\"year\"===b||\"month\"===b||\"quarter\"===b?(g=cc(this,d),\"quarter\"===b?g/=3:\"year\"===b&&(g/=12)):(f=this-d,g=\"second\"===b?f/1e3:\"minute\"===b?f/6e4:\"hour\"===b?f/36e5:\"day\"===b?(f-e)/864e5:\"week\"===b?(f-e)/6048e5:f),c?g:t(g)):NaN):NaN}function cc(a,b){\n// difference in months\n        var c,d,e=12*(b.year()-a.year())+(b.month()-a.month()),\n// b is in (anchor - 1 month, anchor + 1 month)\n            f=a.clone().add(e,\"months\");\n//check for negative zero, return zero if negative zero\n// linear across the month\n// linear across the month\n        return b-f<0?(c=a.clone().add(e-1,\"months\"),d=(b-f)/(f-c)):(c=a.clone().add(e+1,\"months\"),d=(b-f)/(c-f)),-(e+d)||0}function dc(){return this.clone().locale(\"en\").format(\"ddd MMM DD YYYY HH:mm:ss [GMT]ZZ\")}function ec(){var a=this.clone().utc();return 0<a.year()&&a.year()<=9999?z(Date.prototype.toISOString)?this.toDate().toISOString():X(a,\"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]\"):X(a,\"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]\")}/**\n     * Return a human readable representation of a moment that can\n     * also be evaluated to get a new moment which is the same\n     *\n     * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects\n     */\n    function fc(){if(!this.isValid())return\"moment.invalid(/* \"+this._i+\" */)\";var a=\"moment\",b=\"\";this.isLocal()||(a=0===this.utcOffset()?\"moment.utc\":\"moment.parseZone\",b=\"Z\");var c=\"[\"+a+'(\"]',d=0<this.year()&&this.year()<=9999?\"YYYY\":\"YYYYYY\",e=\"-MM-DD[T]HH:mm:ss.SSS\",f=b+'[\")]';return this.format(c+d+e+f)}function gc(b){b||(b=this.isUtc()?a.defaultFormatUtc:a.defaultFormat);var c=X(this,b);return this.localeData().postformat(c)}function hc(a,b){return this.isValid()&&(s(a)&&a.isValid()||sb(a).isValid())?Ob({to:this,from:a}).locale(this.locale()).humanize(!b):this.localeData().invalidDate()}function ic(a){return this.from(sb(),a)}function jc(a,b){return this.isValid()&&(s(a)&&a.isValid()||sb(a).isValid())?Ob({from:this,to:a}).locale(this.locale()).humanize(!b):this.localeData().invalidDate()}function kc(a){return this.to(sb(),a)}\n// If passed a locale key, it will set the locale for this\n// instance.  Otherwise, it will return the locale configuration\n// variables for this instance.\n    function lc(a){var b;return void 0===a?this._locale._abbr:(b=bb(a),null!=b&&(this._locale=b),this)}function mc(){return this._locale}function nc(a){\n// the following switch intentionally omits break keywords\n// to utilize falling through the cases.\n        switch(a=K(a)){case\"year\":this.month(0);/* falls through */\n            case\"quarter\":case\"month\":this.date(1);/* falls through */\n            case\"week\":case\"isoWeek\":case\"day\":case\"date\":this.hours(0);/* falls through */\n            case\"hour\":this.minutes(0);/* falls through */\n            case\"minute\":this.seconds(0);/* falls through */\n            case\"second\":this.milliseconds(0)}\n// weeks are a special case\n// quarters are also special\n        return\"week\"===a&&this.weekday(0),\"isoWeek\"===a&&this.isoWeekday(1),\"quarter\"===a&&this.month(3*Math.floor(this.month()/3)),this}function oc(a){\n// 'date' is an alias for 'day', so it should be considered as such.\n        return a=K(a),void 0===a||\"millisecond\"===a?this:(\"date\"===a&&(a=\"day\"),this.startOf(a).add(1,\"isoWeek\"===a?\"week\":a).subtract(1,\"ms\"))}function pc(){return this._d.valueOf()-6e4*(this._offset||0)}function qc(){return Math.floor(this.valueOf()/1e3)}function rc(){return new Date(this.valueOf())}function sc(){var a=this;return[a.year(),a.month(),a.date(),a.hour(),a.minute(),a.second(),a.millisecond()]}function tc(){var a=this;return{years:a.year(),months:a.month(),date:a.date(),hours:a.hours(),minutes:a.minutes(),seconds:a.seconds(),milliseconds:a.milliseconds()}}function uc(){\n// new Date(NaN).toJSON() === null\n        return this.isValid()?this.toISOString():null}function vc(){return n(this)}function wc(){return j({},m(this))}function xc(){return m(this).overflow}function yc(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function zc(a,b){U(0,[a,a.length],0,b)}\n// MOMENTS\n    function Ac(a){return Ec.call(this,a,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function Bc(a){return Ec.call(this,a,this.isoWeek(),this.isoWeekday(),1,4)}function Cc(){return xa(this.year(),1,4)}function Dc(){var a=this.localeData()._week;return xa(this.year(),a.dow,a.doy)}function Ec(a,b,c,d,e){var f;return null==a?wa(this,d,e).year:(f=xa(a,d,e),b>f&&(b=f),Fc.call(this,a,b,c,d,e))}function Fc(a,b,c,d,e){var f=va(a,b,c,d,e),g=ta(f.year,0,f.dayOfYear);return this.year(g.getUTCFullYear()),this.month(g.getUTCMonth()),this.date(g.getUTCDate()),this}\n// MOMENTS\n    function Gc(a){return null==a?Math.ceil((this.month()+1)/3):this.month(3*(a-1)+this.month()%3)}\n// HELPERS\n// MOMENTS\n    function Hc(a){var b=Math.round((this.clone().startOf(\"day\")-this.clone().startOf(\"year\"))/864e5)+1;return null==a?b:this.add(a-b,\"d\")}function Ic(a,b){b[ge]=u(1e3*(\"0.\"+a))}\n// MOMENTS\n    function Jc(){return this._isUTC?\"UTC\":\"\"}function Kc(){return this._isUTC?\"Coordinated Universal Time\":\"\"}function Lc(a){return sb(1e3*a)}function Mc(){return sb.apply(null,arguments).parseZone()}function Nc(a){return a}function Oc(a,b,c,d){var e=bb(),f=k().set(d,b);return e[c](f,a)}function Pc(a,b,c){if(f(a)&&(b=a,a=void 0),a=a||\"\",null!=b)return Oc(a,b,c,\"month\");var d,e=[];for(d=0;d<12;d++)e[d]=Oc(a,d,c,\"month\");return e}\n// ()\n// (5)\n// (fmt, 5)\n// (fmt)\n// (true)\n// (true, 5)\n// (true, fmt, 5)\n// (true, fmt)\n    function Qc(a,b,c,d){\"boolean\"==typeof a?(f(b)&&(c=b,b=void 0),b=b||\"\"):(b=a,c=b,a=!1,f(b)&&(c=b,b=void 0),b=b||\"\");var e=bb(),g=a?e._week.dow:0;if(null!=c)return Oc(b,(c+g)%7,d,\"day\");var h,i=[];for(h=0;h<7;h++)i[h]=Oc(b,(h+g)%7,d,\"day\");return i}function Rc(a,b){return Pc(a,b,\"months\")}function Sc(a,b){return Pc(a,b,\"monthsShort\")}function Tc(a,b,c){return Qc(a,b,c,\"weekdays\")}function Uc(a,b,c){return Qc(a,b,c,\"weekdaysShort\")}function Vc(a,b,c){return Qc(a,b,c,\"weekdaysMin\")}function Wc(){var a=this._data;return this._milliseconds=Ze(this._milliseconds),this._days=Ze(this._days),this._months=Ze(this._months),a.milliseconds=Ze(a.milliseconds),a.seconds=Ze(a.seconds),a.minutes=Ze(a.minutes),a.hours=Ze(a.hours),a.months=Ze(a.months),a.years=Ze(a.years),this}function Xc(a,b,c,d){var e=Ob(b,c);return a._milliseconds+=d*e._milliseconds,a._days+=d*e._days,a._months+=d*e._months,a._bubble()}\n// supports only 2.0-style add(1, 's') or add(duration)\n    function Yc(a,b){return Xc(this,a,b,1)}\n// supports only 2.0-style subtract(1, 's') or subtract(duration)\n    function Zc(a,b){return Xc(this,a,b,-1)}function $c(a){return a<0?Math.floor(a):Math.ceil(a)}function _c(){var a,b,c,d,e,f=this._milliseconds,g=this._days,h=this._months,i=this._data;\n// if we have a mix of positive and negative values, bubble down first\n// check: https://github.com/moment/moment/issues/2166\n// The following code bubbles up values, see the tests for\n// examples of what that means.\n// convert days to months\n// 12 months -> 1 year\n        return f>=0&&g>=0&&h>=0||f<=0&&g<=0&&h<=0||(f+=864e5*$c(bd(h)+g),g=0,h=0),i.milliseconds=f%1e3,a=t(f/1e3),i.seconds=a%60,b=t(a/60),i.minutes=b%60,c=t(b/60),i.hours=c%24,g+=t(c/24),e=t(ad(g)),h+=e,g-=$c(bd(e)),d=t(h/12),h%=12,i.days=g,i.months=h,i.years=d,this}function ad(a){\n// 400 years have 146097 days (taking into account leap year rules)\n// 400 years have 12 months === 4800\n        return 4800*a/146097}function bd(a){\n// the reverse of daysToMonths\n        return 146097*a/4800}function cd(a){var b,c,d=this._milliseconds;if(a=K(a),\"month\"===a||\"year\"===a)return b=this._days+d/864e5,c=this._months+ad(b),\"month\"===a?c:c/12;switch(\n// handle milliseconds separately because of floating point math errors (issue #1867)\n        b=this._days+Math.round(bd(this._months)),a){case\"week\":return b/7+d/6048e5;case\"day\":return b+d/864e5;case\"hour\":return 24*b+d/36e5;case\"minute\":return 1440*b+d/6e4;case\"second\":return 86400*b+d/1e3;\n// Math.floor prevents floating point math errors here\n        case\"millisecond\":return Math.floor(864e5*b)+d;default:throw new Error(\"Unknown unit \"+a)}}\n// TODO: Use this.as('ms')?\n    function dd(){return this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*u(this._months/12)}function ed(a){return function(){return this.as(a)}}function fd(a){return a=K(a),this[a+\"s\"]()}function gd(a){return function(){return this._data[a]}}function hd(){return t(this.days()/7)}\n// helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize\n    function id(a,b,c,d,e){return e.relativeTime(b||1,!!c,a,d)}function jd(a,b,c){var d=Ob(a).abs(),e=of(d.as(\"s\")),f=of(d.as(\"m\")),g=of(d.as(\"h\")),h=of(d.as(\"d\")),i=of(d.as(\"M\")),j=of(d.as(\"y\")),k=e<pf.s&&[\"s\",e]||f<=1&&[\"m\"]||f<pf.m&&[\"mm\",f]||g<=1&&[\"h\"]||g<pf.h&&[\"hh\",g]||h<=1&&[\"d\"]||h<pf.d&&[\"dd\",h]||i<=1&&[\"M\"]||i<pf.M&&[\"MM\",i]||j<=1&&[\"y\"]||[\"yy\",j];return k[2]=b,k[3]=+a>0,k[4]=c,id.apply(null,k)}\n// This function allows you to set the rounding function for relative time strings\n    function kd(a){return void 0===a?of:\"function\"==typeof a&&(of=a,!0)}\n// This function allows you to set a threshold for relative time strings\n    function ld(a,b){return void 0!==pf[a]&&(void 0===b?pf[a]:(pf[a]=b,!0))}function md(a){var b=this.localeData(),c=jd(this,!a,b);return a&&(c=b.pastFuture(+this,c)),b.postformat(c)}function nd(){\n// for ISO strings we do not use the normal bubbling rules:\n//  * milliseconds bubble up until they become hours\n//  * days do not bubble at all\n//  * months bubble up until they become years\n// This is because there is no context-free conversion between hours and days\n// (think of clock changes)\n// and also not between days and months (28-31 days per month)\n        var a,b,c,d=qf(this._milliseconds)/1e3,e=qf(this._days),f=qf(this._months);\n// 3600 seconds -> 60 minutes -> 1 hour\n        a=t(d/60),b=t(a/60),d%=60,a%=60,\n// 12 months -> 1 year\n            c=t(f/12),f%=12;\n// inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js\n        var g=c,h=f,i=e,j=b,k=a,l=d,m=this.asSeconds();return m?(m<0?\"-\":\"\")+\"P\"+(g?g+\"Y\":\"\")+(h?h+\"M\":\"\")+(i?i+\"D\":\"\")+(j||k||l?\"T\":\"\")+(j?j+\"H\":\"\")+(k?k+\"M\":\"\")+(l?l+\"S\":\"\"):\"P0D\"}var od,pd;pd=Array.prototype.some?Array.prototype.some:function(a){for(var b=Object(this),c=b.length>>>0,d=0;d<c;d++)if(d in b&&a.call(this,b[d],d,b))return!0;return!1};var qd=pd,rd=a.momentProperties=[],sd=!1,td={};a.suppressDeprecationWarnings=!1,a.deprecationHandler=null;var ud;ud=Object.keys?Object.keys:function(a){var b,c=[];for(b in a)i(a,b)&&c.push(b);return c};var vd,wd=ud,xd={sameDay:\"[Today at] LT\",nextDay:\"[Tomorrow at] LT\",nextWeek:\"dddd [at] LT\",lastDay:\"[Yesterday at] LT\",lastWeek:\"[Last] dddd [at] LT\",sameElse:\"L\"},yd={LTS:\"h:mm:ss A\",LT:\"h:mm A\",L:\"MM/DD/YYYY\",LL:\"MMMM D, YYYY\",LLL:\"MMMM D, YYYY h:mm A\",LLLL:\"dddd, MMMM D, YYYY h:mm A\"},zd=\"Invalid date\",Ad=\"%d\",Bd=/\\d{1,2}/,Cd={future:\"in %s\",past:\"%s ago\",s:\"a few seconds\",m:\"a minute\",mm:\"%d minutes\",h:\"an hour\",hh:\"%d hours\",d:\"a day\",dd:\"%d days\",M:\"a month\",MM:\"%d months\",y:\"a year\",yy:\"%d years\"},Dd={},Ed={},Fd=/(\\[[^\\[]*\\])|(\\\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,Gd=/(\\[[^\\[]*\\])|(\\\\)?(LTS|LT|LL?L?L?|l{1,4})/g,Hd={},Id={},Jd=/\\d/,Kd=/\\d\\d/,Ld=/\\d{3}/,Md=/\\d{4}/,Nd=/[+-]?\\d{6}/,Od=/\\d\\d?/,Pd=/\\d\\d\\d\\d?/,Qd=/\\d\\d\\d\\d\\d\\d?/,Rd=/\\d{1,3}/,Sd=/\\d{1,4}/,Td=/[+-]?\\d{1,6}/,Ud=/\\d+/,Vd=/[+-]?\\d+/,Wd=/Z|[+-]\\d\\d:?\\d\\d/gi,Xd=/Z|[+-]\\d\\d(?::?\\d\\d)?/gi,Yd=/[+-]?\\d+(\\.\\d{1,3})?/,Zd=/[0-9]*['a-z\\u00A0-\\u05FF\\u0700-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]+|[\\u0600-\\u06FF\\/]+(\\s*?[\\u0600-\\u06FF]+){1,2}/i,$d={},_d={},ae=0,be=1,ce=2,de=3,ee=4,fe=5,ge=6,he=7,ie=8;vd=Array.prototype.indexOf?Array.prototype.indexOf:function(a){\n// I know\n        var b;for(b=0;b<this.length;++b)if(this[b]===a)return b;return-1};var je=vd;\n// FORMATTING\n    U(\"M\",[\"MM\",2],\"Mo\",function(){return this.month()+1}),U(\"MMM\",0,0,function(a){return this.localeData().monthsShort(this,a)}),U(\"MMMM\",0,0,function(a){return this.localeData().months(this,a)}),\n// ALIASES\n        J(\"month\",\"M\"),\n// PRIORITY\n        M(\"month\",8),\n// PARSING\n        Z(\"M\",Od),Z(\"MM\",Od,Kd),Z(\"MMM\",function(a,b){return b.monthsShortRegex(a)}),Z(\"MMMM\",function(a,b){return b.monthsRegex(a)}),ba([\"M\",\"MM\"],function(a,b){b[be]=u(a)-1}),ba([\"MMM\",\"MMMM\"],function(a,b,c,d){var e=c._locale.monthsParse(a,d,c._strict);\n// if we didn't find a month name, mark the date as invalid.\n        null!=e?b[be]=e:m(c).invalidMonth=a});\n// LOCALES\n    var ke=/D[oD]?(\\[[^\\[\\]]*\\]|\\s)+MMMM?/,le=\"January_February_March_April_May_June_July_August_September_October_November_December\".split(\"_\"),me=\"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec\".split(\"_\"),ne=Zd,oe=Zd;\n// FORMATTING\n    U(\"Y\",0,0,function(){var a=this.year();return a<=9999?\"\"+a:\"+\"+a}),U(0,[\"YY\",2],0,function(){return this.year()%100}),U(0,[\"YYYY\",4],0,\"year\"),U(0,[\"YYYYY\",5],0,\"year\"),U(0,[\"YYYYYY\",6,!0],0,\"year\"),\n// ALIASES\n        J(\"year\",\"y\"),\n// PRIORITIES\n        M(\"year\",1),\n// PARSING\n        Z(\"Y\",Vd),Z(\"YY\",Od,Kd),Z(\"YYYY\",Sd,Md),Z(\"YYYYY\",Td,Nd),Z(\"YYYYYY\",Td,Nd),ba([\"YYYYY\",\"YYYYYY\"],ae),ba(\"YYYY\",function(b,c){c[ae]=2===b.length?a.parseTwoDigitYear(b):u(b)}),ba(\"YY\",function(b,c){c[ae]=a.parseTwoDigitYear(b)}),ba(\"Y\",function(a,b){b[ae]=parseInt(a,10)}),\n// HOOKS\n        a.parseTwoDigitYear=function(a){return u(a)+(u(a)>68?1900:2e3)};\n// MOMENTS\n    var pe=O(\"FullYear\",!0);\n// FORMATTING\n    U(\"w\",[\"ww\",2],\"wo\",\"week\"),U(\"W\",[\"WW\",2],\"Wo\",\"isoWeek\"),\n// ALIASES\n        J(\"week\",\"w\"),J(\"isoWeek\",\"W\"),\n// PRIORITIES\n        M(\"week\",5),M(\"isoWeek\",5),\n// PARSING\n        Z(\"w\",Od),Z(\"ww\",Od,Kd),Z(\"W\",Od),Z(\"WW\",Od,Kd),ca([\"w\",\"ww\",\"W\",\"WW\"],function(a,b,c,d){b[d.substr(0,1)]=u(a)});var qe={dow:0,// Sunday is the first day of the week.\n        doy:6};\n// FORMATTING\n    U(\"d\",0,\"do\",\"day\"),U(\"dd\",0,0,function(a){return this.localeData().weekdaysMin(this,a)}),U(\"ddd\",0,0,function(a){return this.localeData().weekdaysShort(this,a)}),U(\"dddd\",0,0,function(a){return this.localeData().weekdays(this,a)}),U(\"e\",0,0,\"weekday\"),U(\"E\",0,0,\"isoWeekday\"),\n// ALIASES\n        J(\"day\",\"d\"),J(\"weekday\",\"e\"),J(\"isoWeekday\",\"E\"),\n// PRIORITY\n        M(\"day\",11),M(\"weekday\",11),M(\"isoWeekday\",11),\n// PARSING\n        Z(\"d\",Od),Z(\"e\",Od),Z(\"E\",Od),Z(\"dd\",function(a,b){return b.weekdaysMinRegex(a)}),Z(\"ddd\",function(a,b){return b.weekdaysShortRegex(a)}),Z(\"dddd\",function(a,b){return b.weekdaysRegex(a)}),ca([\"dd\",\"ddd\",\"dddd\"],function(a,b,c,d){var e=c._locale.weekdaysParse(a,d,c._strict);\n// if we didn't get a weekday name, mark the date as invalid\n        null!=e?b.d=e:m(c).invalidWeekday=a}),ca([\"d\",\"e\",\"E\"],function(a,b,c,d){b[d]=u(a)});\n// LOCALES\n    var re=\"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday\".split(\"_\"),se=\"Sun_Mon_Tue_Wed_Thu_Fri_Sat\".split(\"_\"),te=\"Su_Mo_Tu_We_Th_Fr_Sa\".split(\"_\"),ue=Zd,ve=Zd,we=Zd;U(\"H\",[\"HH\",2],0,\"hour\"),U(\"h\",[\"hh\",2],0,Ra),U(\"k\",[\"kk\",2],0,Sa),U(\"hmm\",0,0,function(){return\"\"+Ra.apply(this)+T(this.minutes(),2)}),U(\"hmmss\",0,0,function(){return\"\"+Ra.apply(this)+T(this.minutes(),2)+T(this.seconds(),2)}),U(\"Hmm\",0,0,function(){return\"\"+this.hours()+T(this.minutes(),2)}),U(\"Hmmss\",0,0,function(){return\"\"+this.hours()+T(this.minutes(),2)+T(this.seconds(),2)}),Ta(\"a\",!0),Ta(\"A\",!1),\n// ALIASES\n        J(\"hour\",\"h\"),\n// PRIORITY\n        M(\"hour\",13),Z(\"a\",Ua),Z(\"A\",Ua),Z(\"H\",Od),Z(\"h\",Od),Z(\"HH\",Od,Kd),Z(\"hh\",Od,Kd),Z(\"hmm\",Pd),Z(\"hmmss\",Qd),Z(\"Hmm\",Pd),Z(\"Hmmss\",Qd),ba([\"H\",\"HH\"],de),ba([\"a\",\"A\"],function(a,b,c){c._isPm=c._locale.isPM(a),c._meridiem=a}),ba([\"h\",\"hh\"],function(a,b,c){b[de]=u(a),m(c).bigHour=!0}),ba(\"hmm\",function(a,b,c){var d=a.length-2;b[de]=u(a.substr(0,d)),b[ee]=u(a.substr(d)),m(c).bigHour=!0}),ba(\"hmmss\",function(a,b,c){var d=a.length-4,e=a.length-2;b[de]=u(a.substr(0,d)),b[ee]=u(a.substr(d,2)),b[fe]=u(a.substr(e)),m(c).bigHour=!0}),ba(\"Hmm\",function(a,b,c){var d=a.length-2;b[de]=u(a.substr(0,d)),b[ee]=u(a.substr(d))}),ba(\"Hmmss\",function(a,b,c){var d=a.length-4,e=a.length-2;b[de]=u(a.substr(0,d)),b[ee]=u(a.substr(d,2)),b[fe]=u(a.substr(e))});var xe,ye=/[ap]\\.?m?\\.?/i,ze=O(\"Hours\",!0),Ae={calendar:xd,longDateFormat:yd,invalidDate:zd,ordinal:Ad,ordinalParse:Bd,relativeTime:Cd,months:le,monthsShort:me,week:qe,weekdays:re,weekdaysMin:te,weekdaysShort:se,meridiemParse:ye},Be={},Ce={},De=/^\\s*((?:[+-]\\d{6}|\\d{4})-(?:\\d\\d-\\d\\d|W\\d\\d-\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?::\\d\\d(?::\\d\\d(?:[.,]\\d+)?)?)?)([\\+\\-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,Ee=/^\\s*((?:[+-]\\d{6}|\\d{4})(?:\\d\\d\\d\\d|W\\d\\d\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?:\\d\\d(?:\\d\\d(?:[.,]\\d+)?)?)?)([\\+\\-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,Fe=/Z|[+-]\\d\\d(?::?\\d\\d)?/,Ge=[[\"YYYYYY-MM-DD\",/[+-]\\d{6}-\\d\\d-\\d\\d/],[\"YYYY-MM-DD\",/\\d{4}-\\d\\d-\\d\\d/],[\"GGGG-[W]WW-E\",/\\d{4}-W\\d\\d-\\d/],[\"GGGG-[W]WW\",/\\d{4}-W\\d\\d/,!1],[\"YYYY-DDD\",/\\d{4}-\\d{3}/],[\"YYYY-MM\",/\\d{4}-\\d\\d/,!1],[\"YYYYYYMMDD\",/[+-]\\d{10}/],[\"YYYYMMDD\",/\\d{8}/],\n// YYYYMM is NOT allowed by the standard\n        [\"GGGG[W]WWE\",/\\d{4}W\\d{3}/],[\"GGGG[W]WW\",/\\d{4}W\\d{2}/,!1],[\"YYYYDDD\",/\\d{7}/]],He=[[\"HH:mm:ss.SSSS\",/\\d\\d:\\d\\d:\\d\\d\\.\\d+/],[\"HH:mm:ss,SSSS\",/\\d\\d:\\d\\d:\\d\\d,\\d+/],[\"HH:mm:ss\",/\\d\\d:\\d\\d:\\d\\d/],[\"HH:mm\",/\\d\\d:\\d\\d/],[\"HHmmss.SSSS\",/\\d\\d\\d\\d\\d\\d\\.\\d+/],[\"HHmmss,SSSS\",/\\d\\d\\d\\d\\d\\d,\\d+/],[\"HHmmss\",/\\d\\d\\d\\d\\d\\d/],[\"HHmm\",/\\d\\d\\d\\d/],[\"HH\",/\\d\\d/]],Ie=/^\\/?Date\\((\\-?\\d+)/i;a.createFromInputFallback=x(\"value provided is not in a recognized ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.\",function(a){a._d=new Date(a._i+(a._useUTC?\" UTC\":\"\"))}),\n// constant that refers to the ISO standard\n        a.ISO_8601=function(){};var Je=x(\"moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var a=sb.apply(null,arguments);return this.isValid()&&a.isValid()?a<this?this:a:o()}),Ke=x(\"moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var a=sb.apply(null,arguments);return this.isValid()&&a.isValid()?a>this?this:a:o()}),Le=function(){return Date.now?Date.now():+new Date};zb(\"Z\",\":\"),zb(\"ZZ\",\"\"),\n// PARSING\n        Z(\"Z\",Xd),Z(\"ZZ\",Xd),ba([\"Z\",\"ZZ\"],function(a,b,c){c._useUTC=!0,c._tzm=Ab(Xd,a)});\n// HELPERS\n// timezone chunker\n// '+10:00' > ['10',  '00']\n// '-1530'  > ['-15', '30']\n    var Me=/([\\+\\-]|\\d\\d)/gi;\n// HOOKS\n// This function will be called whenever a moment is mutated.\n// It is intended to keep the offset in sync with the timezone.\n    a.updateOffset=function(){};\n// ASP.NET json date format regex\n    var Ne=/^(\\-)?(?:(\\d*)[. ])?(\\d+)\\:(\\d+)(?:\\:(\\d+)(\\.\\d*)?)?$/,Oe=/^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;Ob.fn=wb.prototype;var Pe=Sb(1,\"add\"),Qe=Sb(-1,\"subtract\");a.defaultFormat=\"YYYY-MM-DDTHH:mm:ssZ\",a.defaultFormatUtc=\"YYYY-MM-DDTHH:mm:ss[Z]\";var Re=x(\"moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.\",function(a){return void 0===a?this.localeData():this.locale(a)});\n// FORMATTING\n    U(0,[\"gg\",2],0,function(){return this.weekYear()%100}),U(0,[\"GG\",2],0,function(){return this.isoWeekYear()%100}),zc(\"gggg\",\"weekYear\"),zc(\"ggggg\",\"weekYear\"),zc(\"GGGG\",\"isoWeekYear\"),zc(\"GGGGG\",\"isoWeekYear\"),\n// ALIASES\n        J(\"weekYear\",\"gg\"),J(\"isoWeekYear\",\"GG\"),\n// PRIORITY\n        M(\"weekYear\",1),M(\"isoWeekYear\",1),\n// PARSING\n        Z(\"G\",Vd),Z(\"g\",Vd),Z(\"GG\",Od,Kd),Z(\"gg\",Od,Kd),Z(\"GGGG\",Sd,Md),Z(\"gggg\",Sd,Md),Z(\"GGGGG\",Td,Nd),Z(\"ggggg\",Td,Nd),ca([\"gggg\",\"ggggg\",\"GGGG\",\"GGGGG\"],function(a,b,c,d){b[d.substr(0,2)]=u(a)}),ca([\"gg\",\"GG\"],function(b,c,d,e){c[e]=a.parseTwoDigitYear(b)}),\n// FORMATTING\n        U(\"Q\",0,\"Qo\",\"quarter\"),\n// ALIASES\n        J(\"quarter\",\"Q\"),\n// PRIORITY\n        M(\"quarter\",7),\n// PARSING\n        Z(\"Q\",Jd),ba(\"Q\",function(a,b){b[be]=3*(u(a)-1)}),\n// FORMATTING\n        U(\"D\",[\"DD\",2],\"Do\",\"date\"),\n// ALIASES\n        J(\"date\",\"D\"),\n// PRIOROITY\n        M(\"date\",9),\n// PARSING\n        Z(\"D\",Od),Z(\"DD\",Od,Kd),Z(\"Do\",function(a,b){return a?b._ordinalParse:b._ordinalParseLenient}),ba([\"D\",\"DD\"],ce),ba(\"Do\",function(a,b){b[ce]=u(a.match(Od)[0],10)});\n// MOMENTS\n    var Se=O(\"Date\",!0);\n// FORMATTING\n    U(\"DDD\",[\"DDDD\",3],\"DDDo\",\"dayOfYear\"),\n// ALIASES\n        J(\"dayOfYear\",\"DDD\"),\n// PRIORITY\n        M(\"dayOfYear\",4),\n// PARSING\n        Z(\"DDD\",Rd),Z(\"DDDD\",Ld),ba([\"DDD\",\"DDDD\"],function(a,b,c){c._dayOfYear=u(a)}),\n// FORMATTING\n        U(\"m\",[\"mm\",2],0,\"minute\"),\n// ALIASES\n        J(\"minute\",\"m\"),\n// PRIORITY\n        M(\"minute\",14),\n// PARSING\n        Z(\"m\",Od),Z(\"mm\",Od,Kd),ba([\"m\",\"mm\"],ee);\n// MOMENTS\n    var Te=O(\"Minutes\",!1);\n// FORMATTING\n    U(\"s\",[\"ss\",2],0,\"second\"),\n// ALIASES\n        J(\"second\",\"s\"),\n// PRIORITY\n        M(\"second\",15),\n// PARSING\n        Z(\"s\",Od),Z(\"ss\",Od,Kd),ba([\"s\",\"ss\"],fe);\n// MOMENTS\n    var Ue=O(\"Seconds\",!1);\n// FORMATTING\n    U(\"S\",0,0,function(){return~~(this.millisecond()/100)}),U(0,[\"SS\",2],0,function(){return~~(this.millisecond()/10)}),U(0,[\"SSS\",3],0,\"millisecond\"),U(0,[\"SSSS\",4],0,function(){return 10*this.millisecond()}),U(0,[\"SSSSS\",5],0,function(){return 100*this.millisecond()}),U(0,[\"SSSSSS\",6],0,function(){return 1e3*this.millisecond()}),U(0,[\"SSSSSSS\",7],0,function(){return 1e4*this.millisecond()}),U(0,[\"SSSSSSSS\",8],0,function(){return 1e5*this.millisecond()}),U(0,[\"SSSSSSSSS\",9],0,function(){return 1e6*this.millisecond()}),\n// ALIASES\n        J(\"millisecond\",\"ms\"),\n// PRIORITY\n        M(\"millisecond\",16),\n// PARSING\n        Z(\"S\",Rd,Jd),Z(\"SS\",Rd,Kd),Z(\"SSS\",Rd,Ld);var Ve;for(Ve=\"SSSS\";Ve.length<=9;Ve+=\"S\")Z(Ve,Ud);for(Ve=\"S\";Ve.length<=9;Ve+=\"S\")ba(Ve,Ic);\n// MOMENTS\n    var We=O(\"Milliseconds\",!1);\n// FORMATTING\n    U(\"z\",0,0,\"zoneAbbr\"),U(\"zz\",0,0,\"zoneName\");var Xe=r.prototype;Xe.add=Pe,Xe.calendar=Vb,Xe.clone=Wb,Xe.diff=bc,Xe.endOf=oc,Xe.format=gc,Xe.from=hc,Xe.fromNow=ic,Xe.to=jc,Xe.toNow=kc,Xe.get=R,Xe.invalidAt=xc,Xe.isAfter=Xb,Xe.isBefore=Yb,Xe.isBetween=Zb,Xe.isSame=$b,Xe.isSameOrAfter=_b,Xe.isSameOrBefore=ac,Xe.isValid=vc,Xe.lang=Re,Xe.locale=lc,Xe.localeData=mc,Xe.max=Ke,Xe.min=Je,Xe.parsingFlags=wc,Xe.set=S,Xe.startOf=nc,Xe.subtract=Qe,Xe.toArray=sc,Xe.toObject=tc,Xe.toDate=rc,Xe.toISOString=ec,Xe.inspect=fc,Xe.toJSON=uc,Xe.toString=dc,Xe.unix=qc,Xe.valueOf=pc,Xe.creationData=yc,\n// Year\n        Xe.year=pe,Xe.isLeapYear=ra,\n// Week Year\n        Xe.weekYear=Ac,Xe.isoWeekYear=Bc,\n// Quarter\n        Xe.quarter=Xe.quarters=Gc,\n// Month\n        Xe.month=ka,Xe.daysInMonth=la,\n// Week\n        Xe.week=Xe.weeks=Ba,Xe.isoWeek=Xe.isoWeeks=Ca,Xe.weeksInYear=Dc,Xe.isoWeeksInYear=Cc,\n// Day\n        Xe.date=Se,Xe.day=Xe.days=Ka,Xe.weekday=La,Xe.isoWeekday=Ma,Xe.dayOfYear=Hc,\n// Hour\n        Xe.hour=Xe.hours=ze,\n// Minute\n        Xe.minute=Xe.minutes=Te,\n// Second\n        Xe.second=Xe.seconds=Ue,\n// Millisecond\n        Xe.millisecond=Xe.milliseconds=We,\n// Offset\n        Xe.utcOffset=Db,Xe.utc=Fb,Xe.local=Gb,Xe.parseZone=Hb,Xe.hasAlignedHourOffset=Ib,Xe.isDST=Jb,Xe.isLocal=Lb,Xe.isUtcOffset=Mb,Xe.isUtc=Nb,Xe.isUTC=Nb,\n// Timezone\n        Xe.zoneAbbr=Jc,Xe.zoneName=Kc,\n// Deprecations\n        Xe.dates=x(\"dates accessor is deprecated. Use date instead.\",Se),Xe.months=x(\"months accessor is deprecated. Use month instead\",ka),Xe.years=x(\"years accessor is deprecated. Use year instead\",pe),Xe.zone=x(\"moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/\",Eb),Xe.isDSTShifted=x(\"isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information\",Kb);var Ye=C.prototype;Ye.calendar=D,Ye.longDateFormat=E,Ye.invalidDate=F,Ye.ordinal=G,Ye.preparse=Nc,Ye.postformat=Nc,Ye.relativeTime=H,Ye.pastFuture=I,Ye.set=A,\n// Month\n        Ye.months=fa,Ye.monthsShort=ga,Ye.monthsParse=ia,Ye.monthsRegex=na,Ye.monthsShortRegex=ma,\n// Week\n        Ye.week=ya,Ye.firstDayOfYear=Aa,Ye.firstDayOfWeek=za,\n// Day of Week\n        Ye.weekdays=Fa,Ye.weekdaysMin=Ha,Ye.weekdaysShort=Ga,Ye.weekdaysParse=Ja,Ye.weekdaysRegex=Na,Ye.weekdaysShortRegex=Oa,Ye.weekdaysMinRegex=Pa,\n// Hours\n        Ye.isPM=Va,Ye.meridiem=Wa,$a(\"en\",{ordinalParse:/\\d{1,2}(th|st|nd|rd)/,ordinal:function(a){var b=a%10,c=1===u(a%100/10)?\"th\":1===b?\"st\":2===b?\"nd\":3===b?\"rd\":\"th\";return a+c}}),\n// Side effect imports\n        a.lang=x(\"moment.lang is deprecated. Use moment.locale instead.\",$a),a.langData=x(\"moment.langData is deprecated. Use moment.localeData instead.\",bb);var Ze=Math.abs,$e=ed(\"ms\"),_e=ed(\"s\"),af=ed(\"m\"),bf=ed(\"h\"),cf=ed(\"d\"),df=ed(\"w\"),ef=ed(\"M\"),ff=ed(\"y\"),gf=gd(\"milliseconds\"),hf=gd(\"seconds\"),jf=gd(\"minutes\"),kf=gd(\"hours\"),lf=gd(\"days\"),mf=gd(\"months\"),nf=gd(\"years\"),of=Math.round,pf={s:45,// seconds to minute\n        m:45,// minutes to hour\n        h:22,// hours to day\n        d:26,// days to month\n        M:11},qf=Math.abs,rf=wb.prototype;\n// Deprecations\n// Side effect imports\n// FORMATTING\n// PARSING\n// Side effect imports\n    return rf.abs=Wc,rf.add=Yc,rf.subtract=Zc,rf.as=cd,rf.asMilliseconds=$e,rf.asSeconds=_e,rf.asMinutes=af,rf.asHours=bf,rf.asDays=cf,rf.asWeeks=df,rf.asMonths=ef,rf.asYears=ff,rf.valueOf=dd,rf._bubble=_c,rf.get=fd,rf.milliseconds=gf,rf.seconds=hf,rf.minutes=jf,rf.hours=kf,rf.days=lf,rf.weeks=hd,rf.months=mf,rf.years=nf,rf.humanize=md,rf.toISOString=nd,rf.toString=nd,rf.toJSON=nd,rf.locale=lc,rf.localeData=mc,rf.toIsoString=x(\"toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)\",nd),rf.lang=Re,U(\"X\",0,0,\"unix\"),U(\"x\",0,0,\"valueOf\"),Z(\"x\",Vd),Z(\"X\",Yd),ba(\"X\",function(a,b,c){c._d=new Date(1e3*parseFloat(a,10))}),ba(\"x\",function(a,b,c){c._d=new Date(u(a))}),a.version=\"2.17.1\",b(sb),a.fn=Xe,a.min=ub,a.max=vb,a.now=Le,a.utc=k,a.unix=Lc,a.months=Rc,a.isDate=g,a.locale=$a,a.invalid=o,a.duration=Ob,a.isMoment=s,a.weekdays=Tc,a.parseZone=Mc,a.localeData=bb,a.isDuration=xb,a.monthsShort=Sc,a.weekdaysMin=Vc,a.defineLocale=_a,a.updateLocale=ab,a.locales=cb,a.weekdaysShort=Uc,a.normalizeUnits=K,a.relativeTimeRounding=kd,a.relativeTimeThreshold=ld,a.calendarFormat=Ub,a.prototype=Xe,a});","legacy-build.min.js":"var Prototype={Version:\"1.7\",Browser:(function(){var d=navigator.userAgent;var b=Object.prototype.toString.call(window.opera)==\"[object Opera]\";return{IE:!!window.attachEvent&&!b,Opera:b,WebKit:d.indexOf(\"AppleWebKit/\")>-1,Gecko:d.indexOf(\"Gecko\")>-1&&d.indexOf(\"KHTML\")===-1,MobileSafari:/Apple.*Mobile/.test(d)}})(),BrowserFeatures:{XPath:!!document.evaluate,SelectorsAPI:!!document.querySelector,ElementExtensions:(function(){var b=window.Element||window.HTMLElement;return !!(b&&b.prototype)})(),SpecificElementExtensions:(function(){if(typeof window.HTMLDivElement!==\"undefined\"){return true}var e=document.createElement(\"div\"),d=document.createElement(\"form\"),b=false;if(e.__proto__&&(e.__proto__!==d.__proto__)){b=true}e=d=null;return b})()},ScriptFragment:\"<script[^>]*>([\\\\S\\\\s]*?)<\\/script>\",JSONFilter:/^\\/\\*-secure-([\\s\\S]*)\\*\\/\\s*$/,emptyFunction:function(){},K:function(b){return b}};if(Prototype.Browser.MobileSafari){Prototype.BrowserFeatures.SpecificElementExtensions=false}var Abstract={};var Try={these:function(){var f;for(var d=0,g=arguments.length;d<g;d++){var b=arguments[d];try{f=b();break}catch(h){}}return f}};var Class=(function(){var f=(function(){for(var g in {toString:1}){if(g===\"toString\"){return false}}return true})();function b(){}function d(){var n=null,l=$A(arguments);if(Object.isFunction(l[0])){n=l.shift()}function g(){this.initialize.apply(this,arguments)}Object.extend(g,Class.Methods);g.superclass=n;g.subclasses=[];if(n){b.prototype=n.prototype;g.prototype=new b;n.subclasses.push(g)}for(var h=0,o=l.length;h<o;h++){g.addMethods(l[h])}if(!g.prototype.initialize){g.prototype.initialize=Prototype.emptyFunction}g.prototype.constructor=g;return g}function e(q){var l=this.superclass&&this.superclass.prototype,h=Object.keys(q);if(f){if(q.toString!=Object.prototype.toString){h.push(\"toString\")}if(q.valueOf!=Object.prototype.valueOf){h.push(\"valueOf\")}}for(var g=0,n=h.length;g<n;g++){var p=h[g],o=q[p];if(l&&Object.isFunction(o)&&o.argumentNames()[0]==\"$super\"){var r=o;o=(function(s){return function(){return l[s].apply(this,arguments)}})(p).wrap(r);o.valueOf=r.valueOf.bind(r);o.toString=r.toString.bind(r)}this.prototype[p]=o}return this}return{create:d,Methods:{addMethods:e}}})();(function(){var J=Object.prototype.toString,I=\"Null\",u=\"Undefined\",C=\"Boolean\",h=\"Number\",z=\"String\",O=\"Object\",A=\"[object Function]\",F=\"[object Boolean]\",l=\"[object Number]\",r=\"[object String]\",n=\"[object Array]\",E=\"[object Date]\",o=window.JSON&&typeof JSON.stringify===\"function\"&&JSON.stringify(0)===\"0\"&&typeof JSON.stringify(Prototype.K)===\"undefined\";function q(Q){switch(Q){case null:return I;case (void 0):return u}var P=typeof Q;switch(P){case\"boolean\":return C;case\"number\":return h;case\"string\":return z}return O}function G(P,R){for(var Q in R){P[Q]=R[Q]}return P}function N(P){try{if(e(P)){return\"undefined\"}if(P===null){return\"null\"}return P.inspect?P.inspect():String(P)}catch(Q){if(Q instanceof RangeError){return\"...\"}throw Q}}function K(P){return M(\"\",{\"\":P},[])}function M(Y,V,W){var X=V[Y],U=typeof X;if(q(X)===O&&typeof X.toJSON===\"function\"){X=X.toJSON(Y)}var R=J.call(X);switch(R){case l:case F:case r:X=X.valueOf()}switch(X){case null:return\"null\";case true:return\"true\";case false:return\"false\"}U=typeof X;switch(U){case\"string\":return X.inspect(true);case\"number\":return isFinite(X)?String(X):\"null\";case\"object\":for(var Q=0,P=W.length;Q<P;Q++){if(W[Q]===X){throw new TypeError()}}W.push(X);var T=[];if(R===n){for(var Q=0,P=X.length;Q<P;Q++){var S=M(Q,X,W);T.push(typeof S===\"undefined\"?\"null\":S)}T=\"[\"+T.join(\",\")+\"]\"}else{var Z=Object.keys(X);for(var Q=0,P=Z.length;Q<P;Q++){var Y=Z[Q],S=M(Y,X,W);if(typeof S!==\"undefined\"){T.push(Y.inspect(true)+\":\"+S)}}T=\"{\"+T.join(\",\")+\"}\"}W.pop();return T}}function D(P){return JSON.stringify(P)}function p(P){return $H(P).toQueryString()}function v(P){return P&&P.toHTML?P.toHTML():String.interpret(P)}function y(P){if(q(P)!==O){throw new TypeError()}var Q=[];for(var R in P){if(P.hasOwnProperty(R)){Q.push(R)}}return Q}function f(P){var Q=[];for(var R in P){Q.push(P[R])}return Q}function H(P){return G({},P)}function B(P){return !!(P&&P.nodeType==1)}function s(P){return J.call(P)===n}var d=(typeof Array.isArray==\"function\")&&Array.isArray([])&&!Array.isArray({});if(d){s=Array.isArray}function g(P){return P instanceof Hash}function b(P){return J.call(P)===A}function t(P){return J.call(P)===r}function w(P){return J.call(P)===l}function L(P){return J.call(P)===E}function e(P){return typeof P===\"undefined\"}G(Object,{extend:G,inspect:N,toJSON:o?D:K,toQueryString:p,toHTML:v,keys:Object.keys||y,values:f,clone:H,isElement:B,isArray:s,isHash:g,isFunction:b,isString:t,isNumber:w,isDate:L,isUndefined:e})})();Object.extend(Function.prototype,(function(){var p=Array.prototype.slice;function f(t,q){var s=t.length,r=q.length;while(r--){t[s+r]=q[r]}return t}function n(r,q){r=p.call(r,0);return f(r,q)}function l(){var q=this.toString().match(/^[\\s\\(]*function[^(]*\\(([^)]*)\\)/)[1].replace(/\\/\\/.*?[\\r\\n]|\\/\\*(?:.|[\\r\\n])*?\\*\\//g,\"\").replace(/\\s+/g,\"\").split(\",\");return q.length==1&&!q[0]?[]:q}function h(s){var q=this,r=p.call(arguments,1);return function(u){var t=f([u||window.event],r);return q.apply(s,t)}}function o(){if(!arguments.length){return this}var q=this,r=p.call(arguments,0);return function(){var s=n(r,arguments);return q.apply(this,s)}}function g(s){var q=this,r=p.call(arguments,1);s=s*1000;return window.setTimeout(function(){return q.apply(q,r)},s)}function b(){var q=f([0.01],arguments);return this.delay.apply(this,q)}function e(r){var q=this;return function(){var s=f([q.bind(this)],arguments);return r.apply(this,s)}}function d(){if(this._methodized){return this._methodized}var q=this;return this._methodized=function(){var r=f([this],arguments);return q.apply(null,r)}}return{argumentNames:l,bindAsEventListener:h,curry:o,delay:g,defer:b,wrap:e,methodize:d}})());(function(e){function d(){return this.getUTCFullYear()+\"-\"+(this.getUTCMonth()+1).toPaddedString(2)+\"-\"+this.getUTCDate().toPaddedString(2)+\"T\"+this.getUTCHours().toPaddedString(2)+\":\"+this.getUTCMinutes().toPaddedString(2)+\":\"+this.getUTCSeconds().toPaddedString(2)+\"Z\"}function b(){return this.toISOString()}if(!e.toISOString){e.toISOString=d}if(!e.toJSON){e.toJSON=b}})(Date.prototype);RegExp.prototype.match=RegExp.prototype.test;RegExp.escape=function(b){return String(b).replace(/([.*+?^=!:${}()|[\\]\\/\\\\])/g,\"\\\\$1\")};var PeriodicalExecuter=Class.create({initialize:function(d,b){this.callback=d;this.frequency=b;this.currentlyExecuting=false;this.registerCallback()},registerCallback:function(){this.timer=setInterval(this.onTimerEvent.bind(this),this.frequency*1000)},execute:function(){this.callback(this)},stop:function(){if(!this.timer){return}clearInterval(this.timer);this.timer=null},onTimerEvent:function(){if(!this.currentlyExecuting){try{this.currentlyExecuting=true;this.execute();this.currentlyExecuting=false}catch(b){this.currentlyExecuting=false;throw b}}}});Object.extend(String,{interpret:function(b){return b==null?\"\":String(b)},specialChar:{\"\\b\":\"\\\\b\",\"\\t\":\"\\\\t\",\"\\n\":\"\\\\n\",\"\\f\":\"\\\\f\",\"\\r\":\"\\\\r\",\"\\\\\":\"\\\\\\\\\"}});Object.extend(String.prototype,(function(){var NATIVE_JSON_PARSE_SUPPORT=window.JSON&&typeof JSON.parse===\"function\"&&JSON.parse('{\"test\": true}').test;function prepareReplacement(replacement){if(Object.isFunction(replacement)){return replacement}var template=new Template(replacement);return function(match){return template.evaluate(match)}}function gsub(pattern,replacement){var result=\"\",source=this,match;replacement=prepareReplacement(replacement);if(Object.isString(pattern)){pattern=RegExp.escape(pattern)}if(!(pattern.length||pattern.source)){replacement=replacement(\"\");return replacement+source.split(\"\").join(replacement)+replacement}while(source.length>0){if(match=source.match(pattern)){result+=source.slice(0,match.index);result+=String.interpret(replacement(match));source=source.slice(match.index+match[0].length)}else{result+=source,source=\"\"}}return result}function sub(pattern,replacement,count){replacement=prepareReplacement(replacement);count=Object.isUndefined(count)?1:count;return this.gsub(pattern,function(match){if(--count<0){return match[0]}return replacement(match)})}function scan(pattern,iterator){this.gsub(pattern,iterator);return String(this)}function truncate(length,truncation){length=length||30;truncation=Object.isUndefined(truncation)?\"...\":truncation;return this.length>length?this.slice(0,length-truncation.length)+truncation:String(this)}function strip(){return this.replace(/^\\s+/,\"\").replace(/\\s+$/,\"\")}function stripTags(){return this.replace(/<\\w+(\\s+(\"[^\"]*\"|'[^']*'|[^>])+)?>|<\\/\\w+>/gi,\"\")}function stripScripts(){return this.replace(new RegExp(Prototype.ScriptFragment,\"img\"),\"\")}function extractScripts(){var matchAll=new RegExp(Prototype.ScriptFragment,\"img\"),matchOne=new RegExp(Prototype.ScriptFragment,\"im\");return(this.match(matchAll)||[]).map(function(scriptTag){return(scriptTag.match(matchOne)||[\"\",\"\"])[1]})}function evalScripts(){return this.extractScripts().map(function(script){return eval(script)})}function escapeHTML(){return this.replace(/&/g,\"&amp;\").replace(/</g,\"&lt;\").replace(/>/g,\"&gt;\")}function unescapeHTML(){return this.stripTags().replace(/&lt;/g,\"<\").replace(/&gt;/g,\">\").replace(/&amp;/g,\"&\")}function toQueryParams(separator){var match=this.strip().match(/([^?#]*)(#.*)?$/);if(!match){return{}}return match[1].split(separator||\"&\").inject({},function(hash,pair){if((pair=pair.split(\"=\"))[0]){var key=decodeURIComponent(pair.shift()),value=pair.length>1?pair.join(\"=\"):pair[0];if(value!=undefined){value=decodeURIComponent(value)}if(key in hash){if(!Object.isArray(hash[key])){hash[key]=[hash[key]]}hash[key].push(value)}else{hash[key]=value}}return hash})}function toArray(){return this.split(\"\")}function succ(){return this.slice(0,this.length-1)+String.fromCharCode(this.charCodeAt(this.length-1)+1)}function times(count){return count<1?\"\":new Array(count+1).join(this)}function camelize(){return this.replace(/-+(.)?/g,function(match,chr){return chr?chr.toUpperCase():\"\"})}function capitalize(){return this.charAt(0).toUpperCase()+this.substring(1).toLowerCase()}function underscore(){return this.replace(/::/g,\"/\").replace(/([A-Z]+)([A-Z][a-z])/g,\"$1_$2\").replace(/([a-z\\d])([A-Z])/g,\"$1_$2\").replace(/-/g,\"_\").toLowerCase()}function dasherize(){return this.replace(/_/g,\"-\")}function inspect(useDoubleQuotes){var escapedString=this.replace(/[\\x00-\\x1f\\\\]/g,function(character){if(character in String.specialChar){return String.specialChar[character]}return\"\\\\u00\"+character.charCodeAt().toPaddedString(2,16)});if(useDoubleQuotes){return'\"'+escapedString.replace(/\"/g,'\\\\\"')+'\"'}return\"'\"+escapedString.replace(/'/g,\"\\\\'\")+\"'\"}function unfilterJSON(filter){return this.replace(filter||Prototype.JSONFilter,\"$1\")}function isJSON(){var str=this;if(str.blank()){return false}str=str.replace(/\\\\(?:[\"\\\\\\/bfnrt]|u[0-9a-fA-F]{4})/g,\"@\");str=str.replace(/\"[^\"\\\\\\n\\r]*\"|true|false|null|-?\\d+(?:\\.\\d*)?(?:[eE][+\\-]?\\d+)?/g,\"]\");str=str.replace(/(?:^|:|,)(?:\\s*\\[)+/g,\"\");return(/^[\\],:{}\\s]*$/).test(str)}function evalJSON(sanitize){var json=this.unfilterJSON(),cx=/[\\u0000\\u00ad\\u0600-\\u0604\\u070f\\u17b4\\u17b5\\u200c-\\u200f\\u2028-\\u202f\\u2060-\\u206f\\ufeff\\ufff0-\\uffff]/g;if(cx.test(json)){json=json.replace(cx,function(a){return\"\\\\u\"+(\"0000\"+a.charCodeAt(0).toString(16)).slice(-4)})}try{if(!sanitize||json.isJSON()){return eval(\"(\"+json+\")\")}}catch(e){}throw new SyntaxError(\"Badly formed JSON string: \"+this.inspect())}function parseJSON(){var json=this.unfilterJSON();return JSON.parse(json)}function include(pattern){return this.indexOf(pattern)>-1}function startsWith(pattern){return this.lastIndexOf(pattern,0)===0}function endsWith(pattern){var d=this.length-pattern.length;return d>=0&&this.indexOf(pattern,d)===d}function empty(){return this==\"\"}function blank(){return/^\\s*$/.test(this)}function interpolate(object,pattern){return new Template(this,pattern).evaluate(object)}return{gsub:gsub,sub:sub,scan:scan,truncate:truncate,strip:String.prototype.trim||strip,stripTags:stripTags,stripScripts:stripScripts,extractScripts:extractScripts,evalScripts:evalScripts,escapeHTML:escapeHTML,unescapeHTML:unescapeHTML,toQueryParams:toQueryParams,parseQuery:toQueryParams,toArray:toArray,succ:succ,times:times,camelize:camelize,capitalize:capitalize,underscore:underscore,dasherize:dasherize,inspect:inspect,unfilterJSON:unfilterJSON,isJSON:isJSON,evalJSON:NATIVE_JSON_PARSE_SUPPORT?parseJSON:evalJSON,include:include,startsWith:startsWith,endsWith:endsWith,empty:empty,blank:blank,interpolate:interpolate}})());var Template=Class.create({initialize:function(b,d){this.template=b.toString();this.pattern=d||Template.Pattern},evaluate:function(b){if(b&&Object.isFunction(b.toTemplateReplacements)){b=b.toTemplateReplacements()}return this.template.gsub(this.pattern,function(f){if(b==null){return(f[1]+\"\")}var h=f[1]||\"\";if(h==\"\\\\\"){return f[2]}var d=b,l=f[3],g=/^([^.[]+|\\[((?:.*?[^\\\\])?)\\])(\\.|\\[|$)/;f=g.exec(l);if(f==null){return h}while(f!=null){var e=f[1].startsWith(\"[\")?f[2].replace(/\\\\\\\\]/g,\"]\"):f[1];d=d[e];if(null==d||\"\"==f[3]){break}l=l.substring(\"[\"==f[3]?f[1].length:f[0].length);f=g.exec(l)}return h+String.interpret(d)})}});Template.Pattern=/(^|.|\\r|\\n)(#\\{(.*?)\\})/;var $break={};var Enumerable=(function(){function e(F,E){var D=0;try{this._each(function(H){F.call(E,H,D++)})}catch(G){if(G!=$break){throw G}}return this}function y(G,F,E){var D=-G,H=[],I=this.toArray();if(G<1){return I}while((D+=G)<I.length){H.push(I.slice(D,D+G))}return H.collect(F,E)}function d(F,E){F=F||Prototype.K;var D=true;this.each(function(H,G){D=D&&!!F.call(E,H,G);if(!D){throw $break}});return D}function o(F,E){F=F||Prototype.K;var D=false;this.each(function(H,G){if(D=!!F.call(E,H,G)){throw $break}});return D}function p(F,E){F=F||Prototype.K;var D=[];this.each(function(H,G){D.push(F.call(E,H,G))});return D}function A(F,E){var D;this.each(function(H,G){if(F.call(E,H,G)){D=H;throw $break}});return D}function n(F,E){var D=[];this.each(function(H,G){if(F.call(E,H,G)){D.push(H)}});return D}function l(G,F,E){F=F||Prototype.K;var D=[];if(Object.isString(G)){G=new RegExp(RegExp.escape(G))}this.each(function(I,H){if(G.match(I)){D.push(F.call(E,I,H))}});return D}function b(D){if(Object.isFunction(this.indexOf)){if(this.indexOf(D)!=-1){return true}}var E=false;this.each(function(F){if(F==D){E=true;throw $break}});return E}function w(E,D){D=Object.isUndefined(D)?null:D;return this.eachSlice(E,function(F){while(F.length<E){F.push(D)}return F})}function r(D,F,E){this.each(function(H,G){D=F.call(E,D,H,G)});return D}function C(E){var D=$A(arguments).slice(1);return this.map(function(F){return F[E].apply(F,D)})}function v(F,E){F=F||Prototype.K;var D;this.each(function(H,G){H=F.call(E,H,G);if(D==null||H>=D){D=H}});return D}function t(F,E){F=F||Prototype.K;var D;this.each(function(H,G){H=F.call(E,H,G);if(D==null||H<D){D=H}});return D}function g(G,E){G=G||Prototype.K;var F=[],D=[];this.each(function(I,H){(G.call(E,I,H)?F:D).push(I)});return[F,D]}function h(E){var D=[];this.each(function(F){D.push(F[E])});return D}function f(F,E){var D=[];this.each(function(H,G){if(!F.call(E,H,G)){D.push(H)}});return D}function s(E,D){return this.map(function(G,F){return{value:G,criteria:E.call(D,G,F)}}).sort(function(I,H){var G=I.criteria,F=H.criteria;return G<F?-1:G>F?1:0}).pluck(\"value\")}function u(){return this.map(Prototype.K)}function z(){var E=Prototype.K,D=$A(arguments);if(Object.isFunction(D.last())){E=D.pop()}var F=[this].concat(D).map($A);return this.map(function(H,G){return E(F.pluck(G))})}function q(){return this.toArray().length}function B(){return\"#<Enumerable:\"+this.toArray().inspect()+\">\"}return{each:e,eachSlice:y,all:d,any:o,collect:p,detect:A,findAll:n,select:n,grep:l,include:b,member:b,inGroupsOf:w,inject:r,invoke:C,partition:g,pluck:h,reject:f,sortBy:s,toArray:u,entries:u,zip:z,size:q,inspect:B,find:A,map:Array.prototype.map}})();function $A(e){if(!e){return[]}if(\"toArray\" in Object(e)){return e.toArray()}var d=e.length||0,b=new Array(d);while(d--){b[d]=e[d]}return b}function $w(b){if(!Object.isString(b)){return[]}b=b.strip();return b?b.split(/\\s+/):[]}Array.from=$A;(function(){var y=Array.prototype,s=y.slice,u=y.forEach;function d(D,C){for(var B=0,E=this.length>>>0;B<E;B++){if(B in this){D.call(C,this[B],B,this)}}}if(!u){u=d}function r(){this.length=0;return this}function f(){return this[0]}function l(){return this[this.length-1]}function o(){return this.select(function(B){return B!=null})}function A(){return this.inject([],function(C,B){if(Object.isArray(B)){return C.concat(B.flatten())}C.push(B);return C})}function n(){var B=s.call(arguments,0);return this.select(function(C){return !B.include(C)})}function h(B){return(B===false?this.toArray():this)._reverse()}function q(B){return this.inject([],function(E,D,C){if(0==C||(B?E.last()!=D:!E.include(D))){E.push(D)}return E})}function v(B){return this.uniq().findAll(function(C){return B.detect(function(D){return C===D})})}function w(){return s.call(this,0)}function p(){return this.length}function z(){return\"[\"+this.map(Object.inspect).join(\", \")+\"]\"}function b(D,B){B||(B=0);var C=this.length;if(B<0){B=C+B}for(;B<C;B++){if(this[B]===D){return B}}return -1}function t(C,B){B=isNaN(B)?this.length:(B<0?this.length+B:B)+1;var D=this.slice(0,B).reverse().indexOf(C);return(D<0)?D:B-D-1}function e(){var G=s.call(this,0),E;for(var C=0,D=arguments.length;C<D;C++){E=arguments[C];if(Object.isArray(E)&&!(\"callee\" in E)){for(var B=0,F=E.length;B<F;B++){G.push(E[B])}}else{G.push(E)}}return G}Object.extend(y,Enumerable);if(!y._reverse){y._reverse=y.reverse}Object.extend(y,{_each:u,clear:r,first:f,last:l,compact:o,flatten:A,without:n,reverse:h,uniq:q,intersect:v,clone:w,toArray:w,size:p,inspect:z});var g=(function(){return[].concat(arguments)[0][0]!==1})(1,2);if(g){y.concat=e}if(!y.indexOf){y.indexOf=b}if(!y.lastIndexOf){y.lastIndexOf=t}})();function $H(b){return new Hash(b)}var Hash=Class.create(Enumerable,(function(){function g(v){this._object=Object.isHash(v)?v.toObject():Object.clone(v)}function h(w){for(var v in this._object){var y=this._object[v],z=[v,y];z.key=v;z.value=y;w(z)}}function p(v,w){return this._object[v]=w}function e(v){if(this._object[v]!==Object.prototype[v]){return this._object[v]}}function s(v){var w=this._object[v];delete this._object[v];return w}function u(){return Object.clone(this._object)}function t(){return this.pluck(\"key\")}function r(){return this.pluck(\"value\")}function l(w){var v=this.detect(function(y){return y.value===w});return v&&v.key}function o(v){return this.clone().update(v)}function f(v){return new Hash(v).inject(this,function(w,y){w.set(y.key,y.value);return w})}function d(v,w){if(Object.isUndefined(w)){return v}return v+\"=\"+encodeURIComponent(String.interpret(w))}function b(){return this.inject([],function(A,D){var z=encodeURIComponent(D.key),w=D.value;if(w&&typeof w==\"object\"){if(Object.isArray(w)){var C=[];for(var y=0,v=w.length,B;y<v;y++){B=w[y];C.push(d(z,B))}return A.concat(C)}}else{A.push(d(z,w))}return A}).join(\"&\")}function q(){return\"#<Hash:{\"+this.map(function(v){return v.map(Object.inspect).join(\": \")}).join(\", \")+\"}>\"}function n(){return new Hash(this)}return{initialize:g,_each:h,set:p,get:e,unset:s,toObject:u,toTemplateReplacements:u,keys:t,values:r,index:l,merge:o,update:f,toQueryString:b,inspect:q,toJSON:u,clone:n}})());Hash.from=$H;Object.extend(Number.prototype,(function(){function f(){return this.toPaddedString(2,16)}function d(){return this+1}function n(p,o){$R(0,this,true).each(p,o);return this}function l(q,p){var o=this.toString(p||10);return\"0\".times(q-o.length)+o}function b(){return Math.abs(this)}function e(){return Math.round(this)}function g(){return Math.ceil(this)}function h(){return Math.floor(this)}return{toColorPart:f,succ:d,times:n,toPaddedString:l,abs:b,round:e,ceil:g,floor:h}})());function $R(e,b,d){return new ObjectRange(e,b,d)}var ObjectRange=Class.create(Enumerable,(function(){function d(h,f,g){this.start=h;this.end=f;this.exclusive=g}function e(f){var g=this.start;while(this.include(g)){f(g);g=g.succ()}}function b(f){if(f<this.start){return false}if(this.exclusive){return f<this.end}return f<=this.end}return{initialize:d,_each:e,include:b}})());var Ajax={getTransport:function(){return Try.these(function(){return new XMLHttpRequest()},function(){return new ActiveXObject(\"Msxml2.XMLHTTP\")},function(){return new ActiveXObject(\"Microsoft.XMLHTTP\")})||false},activeRequestCount:0};Ajax.Responders={responders:[],_each:function(b){this.responders._each(b)},register:function(b){if(!this.include(b)){this.responders.push(b)}},unregister:function(b){this.responders=this.responders.without(b)},dispatch:function(f,d,e,b){this.each(function(g){if(Object.isFunction(g[f])){try{g[f].apply(g,[d,e,b])}catch(h){}}})}};Object.extend(Ajax.Responders,Enumerable);Ajax.Responders.register({onCreate:function(){Ajax.activeRequestCount++},onComplete:function(){Ajax.activeRequestCount--}});Ajax.Base=Class.create({initialize:function(b){this.options={method:\"post\",asynchronous:true,contentType:\"application/x-www-form-urlencoded\",encoding:\"UTF-8\",parameters:\"\",evalJSON:true,evalJS:true};Object.extend(this.options,b||{});this.options.method=this.options.method.toLowerCase();if(Object.isHash(this.options.parameters)){this.options.parameters=this.options.parameters.toObject()}}});Ajax.Request=Class.create(Ajax.Base,{_complete:false,initialize:function($super,d,b){$super(b);this.transport=Ajax.getTransport();this.request(d)},request:function(d){this.url=d;this.method=this.options.method;var g=Object.isString(this.options.parameters)?this.options.parameters:Object.toQueryString(this.options.parameters);if(![\"get\",\"post\"].include(this.method)){g+=(g?\"&\":\"\")+\"_method=\"+this.method;this.method=\"post\"}if(g&&this.method===\"get\"){this.url+=(this.url.include(\"?\")?\"&\":\"?\")+g}this.parameters=g.toQueryParams();try{var b=new Ajax.Response(this);if(this.options.onCreate){this.options.onCreate(b)}Ajax.Responders.dispatch(\"onCreate\",this,b);this.transport.open(this.method.toUpperCase(),this.url,this.options.asynchronous);if(this.options.asynchronous){this.respondToReadyState.bind(this).defer(1)}this.transport.onreadystatechange=this.onStateChange.bind(this);this.setRequestHeaders();this.body=this.method==\"post\"?(this.options.postBody||g):null;this.transport.send(this.body);if(!this.options.asynchronous&&this.transport.overrideMimeType){this.onStateChange()}}catch(f){this.dispatchException(f)}},onStateChange:function(){var b=this.transport.readyState;if(b>1&&!((b==4)&&this._complete)){this.respondToReadyState(this.transport.readyState)}},setRequestHeaders:function(){var g={\"X-Requested-With\":\"XMLHttpRequest\",\"X-Prototype-Version\":Prototype.Version,Accept:\"text/javascript, text/html, application/xml, text/xml, */*\"};if(this.method==\"post\"){g[\"Content-type\"]=this.options.contentType+(this.options.encoding?\"; charset=\"+this.options.encoding:\"\");if(this.transport.overrideMimeType&&(navigator.userAgent.match(/Gecko\\/(\\d{4})/)||[0,2005])[1]<2005){g.Connection=\"close\"}}if(typeof this.options.requestHeaders==\"object\"){var e=this.options.requestHeaders;if(Object.isFunction(e.push)){for(var d=0,f=e.length;d<f;d+=2){g[e[d]]=e[d+1]}}else{$H(e).each(function(h){g[h.key]=h.value})}}for(var b in g){this.transport.setRequestHeader(b,g[b])}},success:function(){var b=this.getStatus();return !b||(b>=200&&b<300)||b==304},getStatus:function(){try{if(this.transport.status===1223){return 204}return this.transport.status||0}catch(b){return 0}},respondToReadyState:function(b){var f=Ajax.Request.Events[b],d=new Ajax.Response(this);if(f==\"Complete\"){try{this._complete=true;(this.options[\"on\"+d.status]||this.options[\"on\"+(this.success()?\"Success\":\"Failure\")]||Prototype.emptyFunction)(d,d.headerJSON)}catch(g){this.dispatchException(g)}var h=d.getHeader(\"Content-type\");if(this.options.evalJS==\"force\"||(this.options.evalJS&&this.isSameOrigin()&&h&&h.match(/^\\s*(text|application)\\/(x-)?(java|ecma)script(;.*)?\\s*$/i))){this.evalResponse()}}try{(this.options[\"on\"+f]||Prototype.emptyFunction)(d,d.headerJSON);Ajax.Responders.dispatch(\"on\"+f,this,d,d.headerJSON)}catch(g){this.dispatchException(g)}if(f==\"Complete\"){this.transport.onreadystatechange=Prototype.emptyFunction}},isSameOrigin:function(){var b=this.url.match(/^\\s*https?:\\/\\/[^\\/]*/);return !b||(b[0]==\"#{protocol}//#{domain}#{port}\".interpolate({protocol:location.protocol,domain:document.domain,port:location.port?\":\"+location.port:\"\"}))},getHeader:function(b){try{return this.transport.getResponseHeader(b)||null}catch(d){return null}},evalResponse:function(){try{return eval((this.transport.responseText||\"\").unfilterJSON())}catch(e){this.dispatchException(e)}},dispatchException:function(b){(this.options.onException||Prototype.emptyFunction)(this,b);Ajax.Responders.dispatch(\"onException\",this,b)}});Ajax.Request.Events=[\"Uninitialized\",\"Loading\",\"Loaded\",\"Interactive\",\"Complete\"];Ajax.Response=Class.create({initialize:function(e){this.request=e;var f=this.transport=e.transport,b=this.readyState=f.readyState;if((b>2&&!Prototype.Browser.IE)||b==4){this.status=this.getStatus();this.statusText=this.getStatusText();this.responseText=String.interpret(f.responseText);this.headerJSON=this._getHeaderJSON()}if(b==4){var d=f.responseXML;this.responseXML=Object.isUndefined(d)?null:d;this.responseJSON=this._getResponseJSON()}},status:0,statusText:\"\",getStatus:Ajax.Request.prototype.getStatus,getStatusText:function(){try{return this.transport.statusText||\"\"}catch(b){return\"\"}},getHeader:Ajax.Request.prototype.getHeader,getAllHeaders:function(){try{return this.getAllResponseHeaders()}catch(b){return null}},getResponseHeader:function(b){return this.transport.getResponseHeader(b)},getAllResponseHeaders:function(){return this.transport.getAllResponseHeaders()},_getHeaderJSON:function(){var b=this.getHeader(\"X-JSON\");if(!b){return null}b=decodeURIComponent(escape(b));try{return b.evalJSON(this.request.options.sanitizeJSON||!this.request.isSameOrigin())}catch(d){this.request.dispatchException(d)}},_getResponseJSON:function(){var b=this.request.options;if(!b.evalJSON||(b.evalJSON!=\"force\"&&!(this.getHeader(\"Content-type\")||\"\").include(\"application/json\"))||this.responseText.blank()){return null}try{return this.responseText.evalJSON(b.sanitizeJSON||!this.request.isSameOrigin())}catch(d){this.request.dispatchException(d)}}});Ajax.Updater=Class.create(Ajax.Request,{initialize:function($super,b,e,d){this.container={success:(b.success||b),failure:(b.failure||(b.success?null:b))};d=Object.clone(d);var f=d.onComplete;d.onComplete=(function(g,h){this.updateContent(g.responseText);if(Object.isFunction(f)){f(g,h)}}).bind(this);$super(e,d)},updateContent:function(f){var e=this.container[this.success()?\"success\":\"failure\"],b=this.options;if(!b.evalScripts){f=f.stripScripts()}if(e=$(e)){if(b.insertion){if(Object.isString(b.insertion)){var d={};d[b.insertion]=f;e.insert(d)}else{b.insertion(e,f)}}else{e.update(f)}}}});Ajax.PeriodicalUpdater=Class.create(Ajax.Base,{initialize:function($super,b,e,d){$super(d);this.onComplete=this.options.onComplete;this.frequency=(this.options.frequency||2);this.decay=(this.options.decay||1);this.updater={};this.container=b;this.url=e;this.start()},start:function(){this.options.onComplete=this.updateComplete.bind(this);this.onTimerEvent()},stop:function(){this.updater.options.onComplete=undefined;clearTimeout(this.timer);(this.onComplete||Prototype.emptyFunction).apply(this,arguments)},updateComplete:function(b){if(this.options.decay){this.decay=(b.responseText==this.lastText?this.decay*this.options.decay:1);this.lastText=b.responseText}this.timer=this.onTimerEvent.bind(this).delay(this.decay*this.frequency)},onTimerEvent:function(){this.updater=new Ajax.Updater(this.container,this.url,this.options)}});function $(d){if(arguments.length>1){for(var b=0,f=[],e=arguments.length;b<e;b++){f.push($(arguments[b]))}return f}if(Object.isString(d)){d=document.getElementById(d)}return Element.extend(d)}if(Prototype.BrowserFeatures.XPath){document._getElementsByXPath=function(h,b){var e=[];var g=document.evaluate(h,$(b)||document,null,XPathResult.ORDERED_NODE_SNAPSHOT_TYPE,null);for(var d=0,f=g.snapshotLength;d<f;d++){e.push(Element.extend(g.snapshotItem(d)))}return e}}if(!Node){var Node={}}if(!Node.ELEMENT_NODE){Object.extend(Node,{ELEMENT_NODE:1,ATTRIBUTE_NODE:2,TEXT_NODE:3,CDATA_SECTION_NODE:4,ENTITY_REFERENCE_NODE:5,ENTITY_NODE:6,PROCESSING_INSTRUCTION_NODE:7,COMMENT_NODE:8,DOCUMENT_NODE:9,DOCUMENT_TYPE_NODE:10,DOCUMENT_FRAGMENT_NODE:11,NOTATION_NODE:12})}(function(e){function f(h,g){if(h===\"select\"){return false}if(\"type\" in g){return false}return true}var d=(function(){try{var g=document.createElement('<input name=\"x\">');return g.tagName.toLowerCase()===\"input\"&&g.name===\"x\"}catch(h){return false}})();var b=e.Element;e.Element=function(l,h){h=h||{};l=l.toLowerCase();var g=Element.cache;if(d&&h.name){l=\"<\"+l+' name=\"'+h.name+'\">';delete h.name;return Element.writeAttribute(document.createElement(l),h)}if(!g[l]){g[l]=Element.extend(document.createElement(l))}var n=f(l,h)?g[l].cloneNode(false):document.createElement(l);return Element.writeAttribute(n,h)};Object.extend(e.Element,b||{});if(b){e.Element.prototype=b.prototype}})(this);Element.idCounter=1;Element.cache={};Element._purgeElement=function(d){var b=d._prototypeUID;if(b){Element.stopObserving(d);d._prototypeUID=void 0;delete Element.Storage[b]}};Element.Methods={visible:function(b){return $(b).style.display!=\"none\"},toggle:function(b){b=$(b);Element[Element.visible(b)?\"hide\":\"show\"](b);return b},hide:function(b){b=$(b);b.style.display=\"none\";return b},show:function(b){b=$(b);b.style.display=\"\";return b},remove:function(b){b=$(b);b.parentNode.removeChild(b);return b},update:(function(){var f=(function(){var l=document.createElement(\"select\"),n=true;l.innerHTML='<option value=\"test\">test</option>';if(l.options&&l.options[0]){n=l.options[0].nodeName.toUpperCase()!==\"OPTION\"}l=null;return n})();var d=(function(){try{var l=document.createElement(\"table\");if(l&&l.tBodies){l.innerHTML=\"<tbody><tr><td>test</td></tr></tbody>\";var o=typeof l.tBodies[0]==\"undefined\";l=null;return o}}catch(n){return true}})();var b=(function(){try{var l=document.createElement(\"div\");l.innerHTML=\"<link>\";var o=(l.childNodes.length===0);l=null;return o}catch(n){return true}})();var e=f||d||b;var h=(function(){var l=document.createElement(\"script\"),o=false;try{l.appendChild(document.createTextNode(\"\"));o=!l.firstChild||l.firstChild&&l.firstChild.nodeType!==3}catch(n){o=true}l=null;return o})();function g(q,r){q=$(q);var l=Element._purgeElement;var s=q.getElementsByTagName(\"*\"),p=s.length;while(p--){l(s[p])}if(r&&r.toElement){r=r.toElement()}if(Object.isElement(r)){return q.update().insert(r)}r=Object.toHTML(r);var o=q.tagName.toUpperCase();if(o===\"SCRIPT\"&&h){q.text=r;return q}if(e){if(o in Element._insertionTranslations.tags){while(q.firstChild){q.removeChild(q.firstChild)}Element._getContentFromAnonymousElement(o,r.stripScripts()).each(function(t){q.appendChild(t)})}else{if(b&&Object.isString(r)&&r.indexOf(\"<link\")>-1){while(q.firstChild){q.removeChild(q.firstChild)}var n=Element._getContentFromAnonymousElement(o,r.stripScripts(),true);n.each(function(t){q.appendChild(t)})}else{q.innerHTML=r.stripScripts()}}}else{q.innerHTML=r.stripScripts()}r.evalScripts.bind(r).defer();return q}return g})(),replace:function(d,e){d=$(d);if(e&&e.toElement){e=e.toElement()}else{if(!Object.isElement(e)){e=Object.toHTML(e);var b=d.ownerDocument.createRange();b.selectNode(d);e.evalScripts.bind(e).defer();e=b.createContextualFragment(e.stripScripts())}}d.parentNode.replaceChild(e,d);return d},insert:function(e,g){e=$(e);if(Object.isString(g)||Object.isNumber(g)||Object.isElement(g)||(g&&(g.toElement||g.toHTML))){g={bottom:g}}var f,h,d,l;for(var b in g){f=g[b];b=b.toLowerCase();h=Element._insertionTranslations[b];if(f&&f.toElement){f=f.toElement()}if(Object.isElement(f)){h(e,f);continue}f=Object.toHTML(f);d=((b==\"before\"||b==\"after\")?e.parentNode:e).tagName.toUpperCase();l=Element._getContentFromAnonymousElement(d,f.stripScripts());if(b==\"top\"||b==\"after\"){l.reverse()}l.each(h.curry(e));f.evalScripts.bind(f).defer()}return e},wrap:function(d,e,b){d=$(d);if(Object.isElement(e)){$(e).writeAttribute(b||{})}else{if(Object.isString(e)){e=new Element(e,b)}else{e=new Element(\"div\",e)}}if(d.parentNode){d.parentNode.replaceChild(e,d)}e.appendChild(d);return e},inspect:function(d){d=$(d);var b=\"<\"+d.tagName.toLowerCase();$H({id:\"id\",className:\"class\"}).each(function(h){var g=h.first(),e=h.last(),f=(d[g]||\"\").toString();if(f){b+=\" \"+e+\"=\"+f.inspect(true)}});return b+\">\"},recursivelyCollect:function(b,e,f){b=$(b);f=f||-1;var d=[];while(b=b[e]){if(b.nodeType==1){d.push(Element.extend(b))}if(d.length==f){break}}return d},ancestors:function(b){return Element.recursivelyCollect(b,\"parentNode\")},descendants:function(b){return Element.select(b,\"*\")},firstDescendant:function(b){b=$(b).firstChild;while(b&&b.nodeType!=1){b=b.nextSibling}return $(b)},immediateDescendants:function(d){var b=[],e=$(d).firstChild;while(e){if(e.nodeType===1){b.push(Element.extend(e))}e=e.nextSibling}return b},previousSiblings:function(b,d){return Element.recursivelyCollect(b,\"previousSibling\")},nextSiblings:function(b){return Element.recursivelyCollect(b,\"nextSibling\")},siblings:function(b){b=$(b);return Element.previousSiblings(b).reverse().concat(Element.nextSiblings(b))},match:function(d,b){d=$(d);if(Object.isString(b)){return Prototype.Selector.match(d,b)}return b.match(d)},up:function(d,f,b){d=$(d);if(arguments.length==1){return $(d.parentNode)}var e=Element.ancestors(d);return Object.isNumber(f)?e[f]:Prototype.Selector.find(e,f,b)},down:function(d,e,b){d=$(d);if(arguments.length==1){return Element.firstDescendant(d)}return Object.isNumber(e)?Element.descendants(d)[e]:Element.select(d,e)[b||0]},previous:function(d,e,b){d=$(d);if(Object.isNumber(e)){b=e,e=false}if(!Object.isNumber(b)){b=0}if(e){return Prototype.Selector.find(d.previousSiblings(),e,b)}else{return d.recursivelyCollect(\"previousSibling\",b+1)[b]}},next:function(d,f,b){d=$(d);if(Object.isNumber(f)){b=f,f=false}if(!Object.isNumber(b)){b=0}if(f){return Prototype.Selector.find(d.nextSiblings(),f,b)}else{var e=Object.isNumber(b)?b+1:1;return d.recursivelyCollect(\"nextSibling\",b+1)[b]}},select:function(b){b=$(b);var d=Array.prototype.slice.call(arguments,1).join(\", \");return Prototype.Selector.select(d,b)},adjacent:function(b){b=$(b);var d=Array.prototype.slice.call(arguments,1).join(\", \");return Prototype.Selector.select(d,b.parentNode).without(b)},identify:function(b){b=$(b);var d=Element.readAttribute(b,\"id\");if(d){return d}do{d=\"anonymous_element_\"+Element.idCounter++}while($(d));Element.writeAttribute(b,\"id\",d);return d},readAttribute:function(e,b){e=$(e);if(Prototype.Browser.IE){var d=Element._attributeTranslations.read;if(d.values[b]){return d.values[b](e,b)}if(d.names[b]){b=d.names[b]}if(b.include(\":\")){return(!e.attributes||!e.attributes[b])?null:e.attributes[b].value}}return e.getAttribute(b)},writeAttribute:function(g,e,h){g=$(g);var d={},f=Element._attributeTranslations.write;if(typeof e==\"object\"){d=e}else{d[e]=Object.isUndefined(h)?true:h}for(var b in d){e=f.names[b]||b;h=d[b];if(f.values[b]){e=f.values[b](g,h)}if(h===false||h===null){g.removeAttribute(e)}else{if(h===true){g.setAttribute(e,e)}else{g.setAttribute(e,h)}}}return g},getHeight:function(b){return Element.getDimensions(b).height},getWidth:function(b){return Element.getDimensions(b).width},classNames:function(b){return new Element.ClassNames(b)},hasClassName:function(b,d){if(!(b=$(b))){return}var e=b.className;return(e.length>0&&(e==d||new RegExp(\"(^|\\\\s)\"+d+\"(\\\\s|$)\").test(e)))},addClassName:function(b,d){if(!(b=$(b))){return}if(!Element.hasClassName(b,d)){b.className+=(b.className?\" \":\"\")+d}return b},removeClassName:function(b,d){if(!(b=$(b))){return}b.className=b.className.replace(new RegExp(\"(^|\\\\s+)\"+d+\"(\\\\s+|$)\"),\" \").strip();return b},toggleClassName:function(b,d){if(!(b=$(b))){return}return Element[Element.hasClassName(b,d)?\"removeClassName\":\"addClassName\"](b,d)},cleanWhitespace:function(d){d=$(d);var e=d.firstChild;while(e){var b=e.nextSibling;if(e.nodeType==3&&!/\\S/.test(e.nodeValue)){d.removeChild(e)}e=b}return d},empty:function(b){return $(b).innerHTML.blank()},descendantOf:function(d,b){d=$(d),b=$(b);if(d.compareDocumentPosition){return(d.compareDocumentPosition(b)&8)===8}if(b.contains){return b.contains(d)&&b!==d}while(d=d.parentNode){if(d==b){return true}}return false},scrollTo:function(b){b=$(b);var d=Element.cumulativeOffset(b);window.scrollTo(d[0],d[1]);return b},getStyle:function(d,e){d=$(d);e=e==\"float\"?\"cssFloat\":e.camelize();var f=d.style[e];if(!f||f==\"auto\"){var b=document.defaultView.getComputedStyle(d,null);f=b?b[e]:null}if(e==\"opacity\"){return f?parseFloat(f):1}return f==\"auto\"?null:f},getOpacity:function(b){return $(b).getStyle(\"opacity\")},setStyle:function(d,e){d=$(d);var g=d.style,b;if(Object.isString(e)){d.style.cssText+=\";\"+e;return e.include(\"opacity\")?d.setOpacity(e.match(/opacity:\\s*(\\d?\\.?\\d*)/)[1]):d}for(var f in e){if(f==\"opacity\"){d.setOpacity(e[f])}else{g[(f==\"float\"||f==\"cssFloat\")?(Object.isUndefined(g.styleFloat)?\"cssFloat\":\"styleFloat\"):f]=e[f]}}return d},setOpacity:function(b,d){b=$(b);b.style.opacity=(d==1||d===\"\")?\"\":(d<0.00001)?0:d;return b},makePositioned:function(b){b=$(b);var d=Element.getStyle(b,\"position\");if(d==\"static\"||!d){b._madePositioned=true;b.style.position=\"relative\";if(Prototype.Browser.Opera){b.style.top=0;b.style.left=0}}return b},undoPositioned:function(b){b=$(b);if(b._madePositioned){b._madePositioned=undefined;b.style.position=b.style.top=b.style.left=b.style.bottom=b.style.right=\"\"}return b},makeClipping:function(b){b=$(b);if(b._overflow){return b}b._overflow=Element.getStyle(b,\"overflow\")||\"auto\";if(b._overflow!==\"hidden\"){b.style.overflow=\"hidden\"}return b},undoClipping:function(b){b=$(b);if(!b._overflow){return b}b.style.overflow=b._overflow==\"auto\"?\"\":b._overflow;b._overflow=null;return b},clonePosition:function(d,f){var b=Object.extend({setLeft:true,setTop:true,setWidth:true,setHeight:true,offsetTop:0,offsetLeft:0},arguments[2]||{});f=$(f);var g=Element.viewportOffset(f),h=[0,0],e=null;d=$(d);if(Element.getStyle(d,\"position\")==\"absolute\"){e=Element.getOffsetParent(d);h=Element.viewportOffset(e)}if(e==document.body){h[0]-=document.body.offsetLeft;h[1]-=document.body.offsetTop}if(b.setLeft){d.style.left=(g[0]-h[0]+b.offsetLeft)+\"px\"}if(b.setTop){d.style.top=(g[1]-h[1]+b.offsetTop)+\"px\"}if(b.setWidth){d.style.width=f.offsetWidth+\"px\"}if(b.setHeight){d.style.height=f.offsetHeight+\"px\"}return d}};Object.extend(Element.Methods,{getElementsBySelector:Element.Methods.select,childElements:Element.Methods.immediateDescendants});Element._attributeTranslations={write:{names:{className:\"class\",htmlFor:\"for\"},values:{}}};if(Prototype.Browser.Opera){Element.Methods.getStyle=Element.Methods.getStyle.wrap(function(f,d,e){switch(e){case\"height\":case\"width\":if(!Element.visible(d)){return null}var g=parseInt(f(d,e),10);if(g!==d[\"offset\"+e.capitalize()]){return g+\"px\"}var b;if(e===\"height\"){b=[\"border-top-width\",\"padding-top\",\"padding-bottom\",\"border-bottom-width\"]}else{b=[\"border-left-width\",\"padding-left\",\"padding-right\",\"border-right-width\"]}return b.inject(g,function(h,l){var n=f(d,l);return n===null?h:h-parseInt(n,10)})+\"px\";default:return f(d,e)}});Element.Methods.readAttribute=Element.Methods.readAttribute.wrap(function(e,b,d){if(d===\"title\"){return b.title}return e(b,d)})}else{if(Prototype.Browser.IE){Element.Methods.getStyle=function(b,d){b=$(b);d=(d==\"float\"||d==\"cssFloat\")?\"styleFloat\":d.camelize();var e=b.style[d];if(!e&&b.currentStyle){e=b.currentStyle[d]}if(d==\"opacity\"){if(e=(b.getStyle(\"filter\")||\"\").match(/alpha\\(opacity=(.*)\\)/)){if(e[1]){return parseFloat(e[1])/100}}return 1}if(e==\"auto\"){if((d==\"width\"||d==\"height\")&&(b.getStyle(\"display\")!=\"none\")){return b[\"offset\"+d.capitalize()]+\"px\"}return null}return e};Element.Methods.setOpacity=function(d,g){function h(l){return l.replace(/alpha\\([^\\)]*\\)/gi,\"\")}d=$(d);var b=d.currentStyle;if((b&&!b.hasLayout)||(!b&&d.style.zoom==\"normal\")){d.style.zoom=1}var f=d.getStyle(\"filter\"),e=d.style;if(g==1||g===\"\"){(f=h(f))?e.filter=f:e.removeAttribute(\"filter\");return d}else{if(g<0.00001){g=0}}e.filter=h(f)+\"alpha(opacity=\"+(g*100)+\")\";return d};Element._attributeTranslations=(function(){var d=\"className\",b=\"for\",e=document.createElement(\"div\");e.setAttribute(d,\"x\");if(e.className!==\"x\"){e.setAttribute(\"class\",\"x\");if(e.className===\"x\"){d=\"class\"}}e=null;e=document.createElement(\"label\");e.setAttribute(b,\"x\");if(e.htmlFor!==\"x\"){e.setAttribute(\"htmlFor\",\"x\");if(e.htmlFor===\"x\"){b=\"htmlFor\"}}e=null;return{read:{names:{\"class\":d,className:d,\"for\":b,htmlFor:b},values:{_getAttr:function(f,g){return f.getAttribute(g)},_getAttr2:function(f,g){return f.getAttribute(g,2)},_getAttrNode:function(f,h){var g=f.getAttributeNode(h);return g?g.value:\"\"},_getEv:(function(){var g=document.createElement(\"div\"),l;g.onclick=Prototype.emptyFunction;var h=g.getAttribute(\"onclick\");if(String(h).indexOf(\"{\")>-1){l=function(f,n){n=f.getAttribute(n);if(!n){return null}n=n.toString();n=n.split(\"{\")[1];n=n.split(\"}\")[0];return n.strip()}}else{if(h===\"\"){l=function(f,n){n=f.getAttribute(n);if(!n){return null}return n.strip()}}}g=null;return l})(),_flag:function(f,g){return $(f).hasAttribute(g)?g:null},style:function(f){return f.style.cssText.toLowerCase()},title:function(f){return f.title}}}}})();Element._attributeTranslations.write={names:Object.extend({cellpadding:\"cellPadding\",cellspacing:\"cellSpacing\"},Element._attributeTranslations.read.names),values:{checked:function(b,d){b.checked=!!d},style:function(b,d){b.style.cssText=d?d:\"\"}}};Element._attributeTranslations.has={};$w(\"colSpan rowSpan vAlign dateTime accessKey tabIndex encType maxLength readOnly longDesc frameBorder\").each(function(b){Element._attributeTranslations.write.names[b.toLowerCase()]=b;Element._attributeTranslations.has[b.toLowerCase()]=b});(function(b){Object.extend(b,{href:b._getAttr2,src:b._getAttr2,type:b._getAttr,action:b._getAttrNode,disabled:b._flag,checked:b._flag,readonly:b._flag,multiple:b._flag,onload:b._getEv,onunload:b._getEv,onclick:b._getEv,ondblclick:b._getEv,onmousedown:b._getEv,onmouseup:b._getEv,onmouseover:b._getEv,onmousemove:b._getEv,onmouseout:b._getEv,onfocus:b._getEv,onblur:b._getEv,onkeypress:b._getEv,onkeydown:b._getEv,onkeyup:b._getEv,onsubmit:b._getEv,onreset:b._getEv,onselect:b._getEv,onchange:b._getEv})})(Element._attributeTranslations.read.values);if(Prototype.BrowserFeatures.ElementExtensions){(function(){function b(g){var d=g.getElementsByTagName(\"*\"),f=[];for(var e=0,h;h=d[e];e++){if(h.tagName!==\"!\"){f.push(h)}}return f}Element.Methods.down=function(e,f,d){e=$(e);if(arguments.length==1){return e.firstDescendant()}return Object.isNumber(f)?b(e)[f]:Element.select(e,f)[d||0]}})()}}else{if(Prototype.Browser.Gecko&&/rv:1\\.8\\.0/.test(navigator.userAgent)){Element.Methods.setOpacity=function(b,d){b=$(b);b.style.opacity=(d==1)?0.999999:(d===\"\")?\"\":(d<0.00001)?0:d;return b}}else{if(Prototype.Browser.WebKit){Element.Methods.setOpacity=function(b,d){b=$(b);b.style.opacity=(d==1||d===\"\")?\"\":(d<0.00001)?0:d;if(d==1){if(b.tagName.toUpperCase()==\"IMG\"&&b.width){b.width++;b.width--}else{try{var g=document.createTextNode(\" \");b.appendChild(g);b.removeChild(g)}catch(f){}}}return b}}}}}if(\"outerHTML\" in document.documentElement){Element.Methods.replace=function(e,g){e=$(e);if(g&&g.toElement){g=g.toElement()}if(Object.isElement(g)){e.parentNode.replaceChild(g,e);return e}g=Object.toHTML(g);var f=e.parentNode,d=f.tagName.toUpperCase();if(Element._insertionTranslations.tags[d]){var h=e.next(),b=Element._getContentFromAnonymousElement(d,g.stripScripts());f.removeChild(e);if(h){b.each(function(l){f.insertBefore(l,h)})}else{b.each(function(l){f.appendChild(l)})}}else{e.outerHTML=g.stripScripts()}g.evalScripts.bind(g).defer();return e}}Element._returnOffset=function(d,e){var b=[d,e];b.left=d;b.top=e;return b};Element._getContentFromAnonymousElement=function(g,f,h){var l=new Element(\"div\"),e=Element._insertionTranslations.tags[g];var b=false;if(e){b=true}else{if(h){b=true;e=[\"\",\"\",0]}}if(b){l.innerHTML=\"&nbsp;\"+e[0]+f+e[1];l.removeChild(l.firstChild);for(var d=e[2];d--;){l=l.firstChild}}else{l.innerHTML=f}return $A(l.childNodes)};Element._insertionTranslations={before:function(b,d){b.parentNode.insertBefore(d,b)},top:function(b,d){b.insertBefore(d,b.firstChild)},bottom:function(b,d){b.appendChild(d)},after:function(b,d){b.parentNode.insertBefore(d,b.nextSibling)},tags:{TABLE:[\"<table>\",\"</table>\",1],TBODY:[\"<table><tbody>\",\"</tbody></table>\",2],TR:[\"<table><tbody><tr>\",\"</tr></tbody></table>\",3],TD:[\"<table><tbody><tr><td>\",\"</td></tr></tbody></table>\",4],SELECT:[\"<select>\",\"</select>\",1]}};(function(){var b=Element._insertionTranslations.tags;Object.extend(b,{THEAD:b.TBODY,TFOOT:b.TBODY,TH:b.TD})})();Element.Methods.Simulated={hasAttribute:function(b,e){e=Element._attributeTranslations.has[e]||e;var d=$(b).getAttributeNode(e);return !!(d&&d.specified)}};Element.Methods.ByTag={};Object.extend(Element,Element.Methods);(function(b){if(!Prototype.BrowserFeatures.ElementExtensions&&b.__proto__){window.HTMLElement={};window.HTMLElement.prototype=b.__proto__;Prototype.BrowserFeatures.ElementExtensions=true}b=null})(document.createElement(\"div\"));Element.extend=(function(){function e(l){if(typeof window.Element!=\"undefined\"){var o=window.Element.prototype;if(o){var q=\"_\"+(Math.random()+\"\").slice(2),n=document.createElement(l);o[q]=\"x\";var p=(n[q]!==\"x\");delete o[q];n=null;return p}}return false}function d(n,l){for(var p in l){var o=l[p];if(Object.isFunction(o)&&!(p in n)){n[p]=o.methodize()}}}var f=e(\"object\");if(Prototype.BrowserFeatures.SpecificElementExtensions){if(f){return function(n){if(n&&typeof n._extendedByPrototype==\"undefined\"){var l=n.tagName;if(l&&(/^(?:object|applet|embed)$/i.test(l))){d(n,Element.Methods);d(n,Element.Methods.Simulated);d(n,Element.Methods.ByTag[l.toUpperCase()])}}return n}}return Prototype.K}var b={},g=Element.Methods.ByTag;var h=Object.extend(function(o){if(!o||typeof o._extendedByPrototype!=\"undefined\"||o.nodeType!=1||o==window){return o}var l=Object.clone(b),n=o.tagName.toUpperCase();if(g[n]){Object.extend(l,g[n])}d(o,l);o._extendedByPrototype=Prototype.emptyFunction;return o},{refresh:function(){if(!Prototype.BrowserFeatures.ElementExtensions){Object.extend(b,Element.Methods);Object.extend(b,Element.Methods.Simulated)}}});h.refresh();return h})();if(document.documentElement.hasAttribute){Element.hasAttribute=function(b,d){return b.hasAttribute(d)}}else{Element.hasAttribute=Element.Methods.Simulated.hasAttribute}Element.addMethods=function(e){var o=Prototype.BrowserFeatures,f=Element.Methods.ByTag;if(!e){Object.extend(Form,Form.Methods);Object.extend(Form.Element,Form.Element.Methods);Object.extend(Element.Methods.ByTag,{FORM:Object.clone(Form.Methods),INPUT:Object.clone(Form.Element.Methods),SELECT:Object.clone(Form.Element.Methods),TEXTAREA:Object.clone(Form.Element.Methods),BUTTON:Object.clone(Form.Element.Methods)})}if(arguments.length==2){var d=e;e=arguments[1]}if(!d){Object.extend(Element.Methods,e||{})}else{if(Object.isArray(d)){d.each(l)}else{l(d)}}function l(q){q=q.toUpperCase();if(!Element.Methods.ByTag[q]){Element.Methods.ByTag[q]={}}Object.extend(Element.Methods.ByTag[q],e)}function b(s,r,q){q=q||false;for(var u in s){var t=s[u];if(!Object.isFunction(t)){continue}if(!q||!(u in r)){r[u]=t.methodize()}}}function g(t){var q;var s={OPTGROUP:\"OptGroup\",TEXTAREA:\"TextArea\",P:\"Paragraph\",FIELDSET:\"FieldSet\",UL:\"UList\",OL:\"OList\",DL:\"DList\",DIR:\"Directory\",H1:\"Heading\",H2:\"Heading\",H3:\"Heading\",H4:\"Heading\",H5:\"Heading\",H6:\"Heading\",Q:\"Quote\",INS:\"Mod\",DEL:\"Mod\",A:\"Anchor\",IMG:\"Image\",CAPTION:\"TableCaption\",COL:\"TableCol\",COLGROUP:\"TableCol\",THEAD:\"TableSection\",TFOOT:\"TableSection\",TBODY:\"TableSection\",TR:\"TableRow\",TH:\"TableCell\",TD:\"TableCell\",FRAMESET:\"FrameSet\",IFRAME:\"IFrame\"};if(s[t]){q=\"HTML\"+s[t]+\"Element\"}if(window[q]){return window[q]}q=\"HTML\"+t+\"Element\";if(window[q]){return window[q]}q=\"HTML\"+t.capitalize()+\"Element\";if(window[q]){return window[q]}var r=document.createElement(t),u=r.__proto__||r.constructor.prototype;r=null;return u}var n=window.HTMLElement?HTMLElement.prototype:Element.prototype;if(o.ElementExtensions){b(Element.Methods,n);b(Element.Methods.Simulated,n,true)}if(o.SpecificElementExtensions){for(var p in Element.Methods.ByTag){var h=g(p);if(Object.isUndefined(h)){continue}b(f[p],h.prototype)}}Object.extend(Element,Element.Methods);delete Element.ByTag;if(Element.extend.refresh){Element.extend.refresh()}Element.cache={}};document.viewport={getDimensions:function(){return{width:this.getWidth(),height:this.getHeight()}},getScrollOffsets:function(){return Element._returnOffset(window.pageXOffset||document.documentElement.scrollLeft||document.body.scrollLeft,window.pageYOffset||document.documentElement.scrollTop||document.body.scrollTop)}};(function(d){var l=Prototype.Browser,g=document,e,f={};function b(){if(l.WebKit&&!g.evaluate){return document}if(l.Opera&&window.parseFloat(window.opera.version())<9.5){return document.body}return document.documentElement}function h(n){if(!e){e=b()}f[n]=\"client\"+n;d[\"get\"+n]=function(){return e[f[n]]};return d[\"get\"+n]()}d.getWidth=h.curry(\"Width\");d.getHeight=h.curry(\"Height\")})(document.viewport);Element.Storage={UID:1};Element.addMethods({getStorage:function(d){if(!(d=$(d))){return}var b;if(d===window){b=0}else{if(typeof d._prototypeUID===\"undefined\"){d._prototypeUID=Element.Storage.UID++}b=d._prototypeUID}if(!Element.Storage[b]){Element.Storage[b]=$H()}return Element.Storage[b]},store:function(d,b,e){if(!(d=$(d))){return}if(arguments.length===2){Element.getStorage(d).update(b)}else{Element.getStorage(d).set(b,e)}return d},retrieve:function(e,d,b){if(!(e=$(e))){return}var g=Element.getStorage(e),f=g.get(d);if(Object.isUndefined(f)){g.set(d,b);f=b}return f},clone:function(e,b){if(!(e=$(e))){return}var g=e.cloneNode(b);g._prototypeUID=void 0;if(b){var f=Element.select(g,\"*\"),d=f.length;while(d--){f[d]._prototypeUID=void 0}}return Element.extend(g)},purge:function(e){if(!(e=$(e))){return}var b=Element._purgeElement;b(e);var f=e.getElementsByTagName(\"*\"),d=f.length;while(d--){b(f[d])}return null}});(function(){function n(C){var B=C.match(/^(\\d+)%?$/i);if(!B){return null}return(Number(B[1])/100)}function u(M,N,C){var F=null;if(Object.isElement(M)){F=M;M=F.getStyle(N)}if(M===null){return null}if((/^(?:-)?\\d+(\\.\\d+)?(px)?$/i).test(M)){return window.parseFloat(M)}var H=M.include(\"%\"),D=(C===document.viewport);if(/\\d/.test(M)&&F&&F.runtimeStyle&&!(H&&D)){var B=F.style.left,L=F.runtimeStyle.left;F.runtimeStyle.left=F.currentStyle.left;F.style.left=M||0;M=F.style.pixelLeft;F.style.left=B;F.runtimeStyle.left=L;return M}if(F&&H){C=C||F.parentNode;var E=n(M);var I=null;var G=F.getStyle(\"position\");var K=N.include(\"left\")||N.include(\"right\")||N.include(\"width\");var J=N.include(\"top\")||N.include(\"bottom\")||N.include(\"height\");if(C===document.viewport){if(K){I=document.viewport.getWidth()}else{if(J){I=document.viewport.getHeight()}}}else{if(K){I=$(C).measure(\"width\")}else{if(J){I=$(C).measure(\"height\")}}}return(I===null)?0:I*E}return 0}function l(B){if(Object.isString(B)&&B.endsWith(\"px\")){return B}return B+\"px\"}function p(C){var B=C;while(C&&C.parentNode){var D=C.getStyle(\"display\");if(D===\"none\"){return false}C=$(C.parentNode)}return true}var f=Prototype.K;if(\"currentStyle\" in document.documentElement){f=function(B){if(!B.currentStyle.hasLayout){B.style.zoom=1}return B}}function h(B){if(B.include(\"border\")){B=B+\"-width\"}return B.camelize()}Element.Layout=Class.create(Hash,{initialize:function($super,C,B){$super();this.element=$(C);Element.Layout.PROPERTIES.each(function(D){this._set(D,null)},this);if(B){this._preComputing=true;this._begin();Element.Layout.PROPERTIES.each(this._compute,this);this._end();this._preComputing=false}},_set:function(C,B){return Hash.prototype.set.call(this,C,B)},set:function(C,B){throw\"Properties of Element.Layout are read-only.\"},get:function($super,C){var B=$super(C);return B===null?this._compute(C):B},_begin:function(){if(this._prepared){return}var F=this.element;if(p(F)){this._prepared=true;return}var H={position:F.style.position||\"\",width:F.style.width||\"\",visibility:F.style.visibility||\"\",display:F.style.display||\"\"};F.store(\"prototype_original_styles\",H);var I=F.getStyle(\"position\"),B=F.getStyle(\"width\");if(B===\"0px\"||B===null){F.style.display=\"block\";B=F.getStyle(\"width\")}var C=(I===\"fixed\")?document.viewport:F.parentNode;F.setStyle({position:\"absolute\",visibility:\"hidden\",display:\"block\"});var D=F.getStyle(\"width\");var E;if(B&&(D===B)){E=u(F,\"width\",C)}else{if(I===\"absolute\"||I===\"fixed\"){E=u(F,\"width\",C)}else{var J=F.parentNode,G=$(J).getLayout();E=G.get(\"width\")-this.get(\"margin-left\")-this.get(\"border-left\")-this.get(\"padding-left\")-this.get(\"padding-right\")-this.get(\"border-right\")-this.get(\"margin-right\")}}F.setStyle({width:E+\"px\"});this._prepared=true},_end:function(){var C=this.element;var B=C.retrieve(\"prototype_original_styles\");C.store(\"prototype_original_styles\",null);C.setStyle(B);this._prepared=false},_compute:function(C){var B=Element.Layout.COMPUTATIONS;if(!(C in B)){throw\"Property not found.\"}return this._set(C,B[C].call(this,this.element))},toObject:function(){var B=$A(arguments);var C=(B.length===0)?Element.Layout.PROPERTIES:B.join(\" \").split(\" \");var D={};C.each(function(E){if(!Element.Layout.PROPERTIES.include(E)){return}var F=this.get(E);if(F!=null){D[E]=F}},this);return D},toHash:function(){var B=this.toObject.apply(this,arguments);return new Hash(B)},toCSS:function(){var B=$A(arguments);var D=(B.length===0)?Element.Layout.PROPERTIES:B.join(\" \").split(\" \");var C={};D.each(function(E){if(!Element.Layout.PROPERTIES.include(E)){return}if(Element.Layout.COMPOSITE_PROPERTIES.include(E)){return}var F=this.get(E);if(F!=null){C[h(E)]=F+\"px\"}},this);return C},inspect:function(){return\"#<Element.Layout>\"}});Object.extend(Element.Layout,{PROPERTIES:$w(\"height width top left right bottom border-left border-right border-top border-bottom padding-left padding-right padding-top padding-bottom margin-top margin-bottom margin-left margin-right padding-box-width padding-box-height border-box-width border-box-height margin-box-width margin-box-height\"),COMPOSITE_PROPERTIES:$w(\"padding-box-width padding-box-height margin-box-width margin-box-height border-box-width border-box-height\"),COMPUTATIONS:{height:function(D){if(!this._preComputing){this._begin()}var B=this.get(\"border-box-height\");if(B<=0){if(!this._preComputing){this._end()}return 0}var E=this.get(\"border-top\"),C=this.get(\"border-bottom\");var G=this.get(\"padding-top\"),F=this.get(\"padding-bottom\");if(!this._preComputing){this._end()}return B-E-C-G-F},width:function(D){if(!this._preComputing){this._begin()}var C=this.get(\"border-box-width\");if(C<=0){if(!this._preComputing){this._end()}return 0}var G=this.get(\"border-left\"),B=this.get(\"border-right\");var E=this.get(\"padding-left\"),F=this.get(\"padding-right\");if(!this._preComputing){this._end()}return C-G-B-E-F},\"padding-box-height\":function(C){var B=this.get(\"height\"),E=this.get(\"padding-top\"),D=this.get(\"padding-bottom\");return B+E+D},\"padding-box-width\":function(B){var C=this.get(\"width\"),D=this.get(\"padding-left\"),E=this.get(\"padding-right\");return C+D+E},\"border-box-height\":function(C){if(!this._preComputing){this._begin()}var B=C.offsetHeight;if(!this._preComputing){this._end()}return B},\"border-box-width\":function(B){if(!this._preComputing){this._begin()}var C=B.offsetWidth;if(!this._preComputing){this._end()}return C},\"margin-box-height\":function(C){var B=this.get(\"border-box-height\"),D=this.get(\"margin-top\"),E=this.get(\"margin-bottom\");if(B<=0){return 0}return B+D+E},\"margin-box-width\":function(D){var C=this.get(\"border-box-width\"),E=this.get(\"margin-left\"),B=this.get(\"margin-right\");if(C<=0){return 0}return C+E+B},top:function(B){var C=B.positionedOffset();return C.top},bottom:function(B){var E=B.positionedOffset(),C=B.getOffsetParent(),D=C.measure(\"height\");var F=this.get(\"border-box-height\");return D-F-E.top},left:function(B){var C=B.positionedOffset();return C.left},right:function(D){var F=D.positionedOffset(),E=D.getOffsetParent(),B=E.measure(\"width\");var C=this.get(\"border-box-width\");return B-C-F.left},\"padding-top\":function(B){return u(B,\"paddingTop\")},\"padding-bottom\":function(B){return u(B,\"paddingBottom\")},\"padding-left\":function(B){return u(B,\"paddingLeft\")},\"padding-right\":function(B){return u(B,\"paddingRight\")},\"border-top\":function(B){return u(B,\"borderTopWidth\")},\"border-bottom\":function(B){return u(B,\"borderBottomWidth\")},\"border-left\":function(B){return u(B,\"borderLeftWidth\")},\"border-right\":function(B){return u(B,\"borderRightWidth\")},\"margin-top\":function(B){return u(B,\"marginTop\")},\"margin-bottom\":function(B){return u(B,\"marginBottom\")},\"margin-left\":function(B){return u(B,\"marginLeft\")},\"margin-right\":function(B){return u(B,\"marginRight\")}}});if(\"getBoundingClientRect\" in document.documentElement){Object.extend(Element.Layout.COMPUTATIONS,{right:function(C){var D=f(C.getOffsetParent());var E=C.getBoundingClientRect(),B=D.getBoundingClientRect();return(B.right-E.right).round()},bottom:function(C){var D=f(C.getOffsetParent());var E=C.getBoundingClientRect(),B=D.getBoundingClientRect();return(B.bottom-E.bottom).round()}})}Element.Offset=Class.create({initialize:function(C,B){this.left=C.round();this.top=B.round();this[0]=this.left;this[1]=this.top},relativeTo:function(B){return new Element.Offset(this.left-B.left,this.top-B.top)},inspect:function(){return\"#<Element.Offset left: #{left} top: #{top}>\".interpolate(this)},toString:function(){return\"[#{left}, #{top}]\".interpolate(this)},toArray:function(){return[this.left,this.top]}});function y(C,B){return new Element.Layout(C,B)}function d(B,C){return $(B).getLayout().get(C)}function t(C){C=$(C);var G=Element.getStyle(C,\"display\");if(G&&G!==\"none\"){return{width:C.offsetWidth,height:C.offsetHeight}}var D=C.style;var B={visibility:D.visibility,position:D.position,display:D.display};var F={visibility:\"hidden\",display:\"block\"};if(B.position!==\"fixed\"){F.position=\"absolute\"}Element.setStyle(C,F);var E={width:C.offsetWidth,height:C.offsetHeight};Element.setStyle(C,B);return E}function r(B){B=$(B);if(g(B)||e(B)||s(B)||q(B)){return $(document.body)}var C=(Element.getStyle(B,\"display\")===\"inline\");if(!C&&B.offsetParent){return $(B.offsetParent)}while((B=B.parentNode)&&B!==document.body){if(Element.getStyle(B,\"position\")!==\"static\"){return q(B)?$(document.body):$(B)}}return $(document.body)}function A(C){C=$(C);var B=0,D=0;if(C.parentNode){do{B+=C.offsetTop||0;D+=C.offsetLeft||0;C=C.offsetParent}while(C)}return new Element.Offset(D,B)}function v(C){C=$(C);var D=C.getLayout();var B=0,F=0;do{B+=C.offsetTop||0;F+=C.offsetLeft||0;C=C.offsetParent;if(C){if(s(C)){break}var E=Element.getStyle(C,\"position\");if(E!==\"static\"){break}}}while(C);F-=D.get(\"margin-top\");B-=D.get(\"margin-left\");return new Element.Offset(F,B)}function b(C){var B=0,D=0;do{B+=C.scrollTop||0;D+=C.scrollLeft||0;C=C.parentNode}while(C);return new Element.Offset(D,B)}function z(F){C=$(C);var B=0,E=0,D=document.body;var C=F;do{B+=C.offsetTop||0;E+=C.offsetLeft||0;if(C.offsetParent==D&&Element.getStyle(C,\"position\")==\"absolute\"){break}}while(C=C.offsetParent);C=F;do{if(C!=D){B-=C.scrollTop||0;E-=C.scrollLeft||0}}while(C=C.parentNode);return new Element.Offset(E,B)}function w(B){B=$(B);if(Element.getStyle(B,\"position\")===\"absolute\"){return B}var F=r(B);var E=B.viewportOffset(),C=F.viewportOffset();var G=E.relativeTo(C);var D=B.getLayout();B.store(\"prototype_absolutize_original_styles\",{left:B.getStyle(\"left\"),top:B.getStyle(\"top\"),width:B.getStyle(\"width\"),height:B.getStyle(\"height\")});B.setStyle({position:\"absolute\",top:G.top+\"px\",left:G.left+\"px\",width:D.get(\"width\")+\"px\",height:D.get(\"height\")+\"px\"});return B}function o(C){C=$(C);if(Element.getStyle(C,\"position\")===\"relative\"){return C}var B=C.retrieve(\"prototype_absolutize_original_styles\");if(B){C.setStyle(B)}return C}if(Prototype.Browser.IE){r=r.wrap(function(D,C){C=$(C);if(g(C)||e(C)||s(C)||q(C)){return $(document.body)}var B=C.getStyle(\"position\");if(B!==\"static\"){return D(C)}C.setStyle({position:\"relative\"});var E=D(C);C.setStyle({position:B});return E});v=v.wrap(function(E,C){C=$(C);if(!C.parentNode){return new Element.Offset(0,0)}var B=C.getStyle(\"position\");if(B!==\"static\"){return E(C)}var D=C.getOffsetParent();if(D&&D.getStyle(\"position\")===\"fixed\"){f(D)}C.setStyle({position:\"relative\"});var F=E(C);C.setStyle({position:B});return F})}else{if(Prototype.Browser.Webkit){A=function(C){C=$(C);var B=0,D=0;do{B+=C.offsetTop||0;D+=C.offsetLeft||0;if(C.offsetParent==document.body){if(Element.getStyle(C,\"position\")==\"absolute\"){break}}C=C.offsetParent}while(C);return new Element.Offset(D,B)}}}Element.addMethods({getLayout:y,measure:d,getDimensions:t,getOffsetParent:r,cumulativeOffset:A,positionedOffset:v,cumulativeScrollOffset:b,viewportOffset:z,absolutize:w,relativize:o});function s(B){return B.nodeName.toUpperCase()===\"BODY\"}function q(B){return B.nodeName.toUpperCase()===\"HTML\"}function g(B){return B.nodeType===Node.DOCUMENT_NODE}function e(B){return B!==document.body&&!Element.descendantOf(B,document.body)}if(\"getBoundingClientRect\" in document.documentElement){Element.addMethods({viewportOffset:function(B){B=$(B);if(e(B)){return new Element.Offset(0,0)}var C=B.getBoundingClientRect(),D=document.documentElement;return new Element.Offset(C.left-D.clientLeft,C.top-D.clientTop)}})}})();window.$$=function(){var b=$A(arguments).join(\", \");return Prototype.Selector.select(b,document)};Prototype.Selector=(function(){function b(){throw new Error('Method \"Prototype.Selector.select\" must be defined.')}function e(){throw new Error('Method \"Prototype.Selector.match\" must be defined.')}function f(q,r,n){n=n||0;var l=Prototype.Selector.match,p=q.length,h=0,o;for(o=0;o<p;o++){if(l(q[o],r)&&n==h++){return Element.extend(q[o])}}}function g(n){for(var h=0,l=n.length;h<l;h++){Element.extend(n[h])}return n}var d=Prototype.K;return{select:b,match:e,find:f,extendElements:(Element.extend===d)?d:g,extendElement:Element.extend}})();Prototype._original_property=window.Sizzle;\n/*!\n * Sizzle CSS Selector Engine - v1.0\n *  Copyright 2009, The Dojo Foundation\n *  Released under the MIT, BSD, and GPL Licenses.\n *  More information: http://sizzlejs.com/\n */\n(function(){var w=/((?:\\((?:\\([^()]+\\)|[^()]+)+\\)|\\[(?:\\[[^[\\]]*\\]|['\"][^'\"]*['\"]|[^[\\]'\"]+)+\\]|\\\\.|[^ >+~,(\\[\\\\]+)+|[>+~])(\\s*,\\s*)?((?:.|\\r|\\n)*)/g,p=0,g=Object.prototype.toString,u=false,o=true;[0,0].sort(function(){o=false;return 0});var d=function(L,B,I,D){I=I||[];var e=B=B||document;if(B.nodeType!==1&&B.nodeType!==9){return[]}if(!L||typeof L!==\"string\"){return I}var J=[],K,G,P,O,H,A,z=true,E=v(B),N=L;while((w.exec(\"\"),K=w.exec(N))!==null){N=K[3];J.push(K[1]);if(K[2]){A=K[3];break}}if(J.length>1&&q.exec(L)){if(J.length===2&&h.relative[J[0]]){G=l(J[0]+J[1],B)}else{G=h.relative[J[0]]?[B]:d(J.shift(),B);while(J.length){L=J.shift();if(h.relative[L]){L+=J.shift()}G=l(L,G)}}}else{if(!D&&J.length>1&&B.nodeType===9&&!E&&h.match.ID.test(J[0])&&!h.match.ID.test(J[J.length-1])){var Q=d.find(J.shift(),B,E);B=Q.expr?d.filter(Q.expr,Q.set)[0]:Q.set[0]}if(B){var Q=D?{expr:J.pop(),set:b(D)}:d.find(J.pop(),J.length===1&&(J[0]===\"~\"||J[0]===\"+\")&&B.parentNode?B.parentNode:B,E);G=Q.expr?d.filter(Q.expr,Q.set):Q.set;if(J.length>0){P=b(G)}else{z=false}while(J.length){var C=J.pop(),F=C;if(!h.relative[C]){C=\"\"}else{F=J.pop()}if(F==null){F=B}h.relative[C](P,F,E)}}else{P=J=[]}}if(!P){P=G}if(!P){throw\"Syntax error, unrecognized expression: \"+(C||L)}if(g.call(P)===\"[object Array]\"){if(!z){I.push.apply(I,P)}else{if(B&&B.nodeType===1){for(var M=0;P[M]!=null;M++){if(P[M]&&(P[M]===true||P[M].nodeType===1&&n(B,P[M]))){I.push(G[M])}}}else{for(var M=0;P[M]!=null;M++){if(P[M]&&P[M].nodeType===1){I.push(G[M])}}}}}else{b(P,I)}if(A){d(A,e,I,D);d.uniqueSort(I)}return I};d.uniqueSort=function(z){if(f){u=o;z.sort(f);if(u){for(var e=1;e<z.length;e++){if(z[e]===z[e-1]){z.splice(e--,1)}}}}return z};d.matches=function(e,z){return d(e,null,null,z)};d.find=function(F,e,G){var E,C;if(!F){return[]}for(var B=0,A=h.order.length;B<A;B++){var D=h.order[B],C;if((C=h.leftMatch[D].exec(F))){var z=C[1];C.splice(1,1);if(z.substr(z.length-1)!==\"\\\\\"){C[1]=(C[1]||\"\").replace(/\\\\/g,\"\");E=h.find[D](C,e,G);if(E!=null){F=F.replace(h.match[D],\"\");break}}}}if(!E){E=e.getElementsByTagName(\"*\")}return{set:E,expr:F}};d.filter=function(I,H,L,B){var A=I,N=[],F=H,D,e,E=H&&H[0]&&v(H[0]);while(I&&H.length){for(var G in h.filter){if((D=h.match[G].exec(I))!=null){var z=h.filter[G],M,K;e=false;if(F==N){N=[]}if(h.preFilter[G]){D=h.preFilter[G](D,F,L,N,B,E);if(!D){e=M=true}else{if(D===true){continue}}}if(D){for(var C=0;(K=F[C])!=null;C++){if(K){M=z(K,D,C,F);var J=B^!!M;if(L&&M!=null){if(J){e=true}else{F[C]=false}}else{if(J){N.push(K);e=true}}}}}if(M!==undefined){if(!L){F=N}I=I.replace(h.match[G],\"\");if(!e){return[]}break}}}if(I==A){if(e==null){throw\"Syntax error, unrecognized expression: \"+I}else{break}}A=I}return F};var h=d.selectors={order:[\"ID\",\"NAME\",\"TAG\"],match:{ID:/#((?:[\\w\\u00c0-\\uFFFF-]|\\\\.)+)/,CLASS:/\\.((?:[\\w\\u00c0-\\uFFFF-]|\\\\.)+)/,NAME:/\\[name=['\"]*((?:[\\w\\u00c0-\\uFFFF-]|\\\\.)+)['\"]*\\]/,ATTR:/\\[\\s*((?:[\\w\\u00c0-\\uFFFF-]|\\\\.)+)\\s*(?:(\\S?=)\\s*(['\"]*)(.*?)\\3|)\\s*\\]/,TAG:/^((?:[\\w\\u00c0-\\uFFFF\\*-]|\\\\.)+)/,CHILD:/:(only|nth|last|first)-child(?:\\((even|odd|[\\dn+-]*)\\))?/,POS:/:(nth|eq|gt|lt|first|last|even|odd)(?:\\((\\d*)\\))?(?=[^-]|$)/,PSEUDO:/:((?:[\\w\\u00c0-\\uFFFF-]|\\\\.)+)(?:\\((['\"]*)((?:\\([^\\)]+\\)|[^\\2\\(\\)]*)+)\\2\\))?/},leftMatch:{},attrMap:{\"class\":\"className\",\"for\":\"htmlFor\"},attrHandle:{href:function(e){return e.getAttribute(\"href\")}},relative:{\"+\":function(F,e,E){var C=typeof e===\"string\",G=C&&!/\\W/.test(e),D=C&&!G;if(G&&!E){e=e.toUpperCase()}for(var B=0,A=F.length,z;B<A;B++){if((z=F[B])){while((z=z.previousSibling)&&z.nodeType!==1){}F[B]=D||z&&z.nodeName===e?z||false:z===e}}if(D){d.filter(e,F,true)}},\">\":function(E,z,F){var C=typeof z===\"string\";if(C&&!/\\W/.test(z)){z=F?z:z.toUpperCase();for(var A=0,e=E.length;A<e;A++){var D=E[A];if(D){var B=D.parentNode;E[A]=B.nodeName===z?B:false}}}else{for(var A=0,e=E.length;A<e;A++){var D=E[A];if(D){E[A]=C?D.parentNode:D.parentNode===z}}if(C){d.filter(z,E,true)}}},\"\":function(B,z,D){var A=p++,e=y;if(!/\\W/.test(z)){var C=z=D?z:z.toUpperCase();e=t}e(\"parentNode\",z,A,B,C,D)},\"~\":function(B,z,D){var A=p++,e=y;if(typeof z===\"string\"&&!/\\W/.test(z)){var C=z=D?z:z.toUpperCase();e=t}e(\"previousSibling\",z,A,B,C,D)}},find:{ID:function(z,A,B){if(typeof A.getElementById!==\"undefined\"&&!B){var e=A.getElementById(z[1]);return e?[e]:[]}},NAME:function(A,D,E){if(typeof D.getElementsByName!==\"undefined\"){var z=[],C=D.getElementsByName(A[1]);for(var B=0,e=C.length;B<e;B++){if(C[B].getAttribute(\"name\")===A[1]){z.push(C[B])}}return z.length===0?null:z}},TAG:function(e,z){return z.getElementsByTagName(e[1])}},preFilter:{CLASS:function(B,z,A,e,E,F){B=\" \"+B[1].replace(/\\\\/g,\"\")+\" \";if(F){return B}for(var C=0,D;(D=z[C])!=null;C++){if(D){if(E^(D.className&&(\" \"+D.className+\" \").indexOf(B)>=0)){if(!A){e.push(D)}}else{if(A){z[C]=false}}}}return false},ID:function(e){return e[1].replace(/\\\\/g,\"\")},TAG:function(z,e){for(var A=0;e[A]===false;A++){}return e[A]&&v(e[A])?z[1]:z[1].toUpperCase()},CHILD:function(e){if(e[1]==\"nth\"){var z=/(-?)(\\d*)n((?:\\+|-)?\\d*)/.exec(e[2]==\"even\"&&\"2n\"||e[2]==\"odd\"&&\"2n+1\"||!/\\D/.test(e[2])&&\"0n+\"+e[2]||e[2]);e[2]=(z[1]+(z[2]||1))-0;e[3]=z[3]-0}e[0]=p++;return e},ATTR:function(C,z,A,e,D,E){var B=C[1].replace(/\\\\/g,\"\");if(!E&&h.attrMap[B]){C[1]=h.attrMap[B]}if(C[2]===\"~=\"){C[4]=\" \"+C[4]+\" \"}return C},PSEUDO:function(C,z,A,e,D){if(C[1]===\"not\"){if((w.exec(C[3])||\"\").length>1||/^\\w/.test(C[3])){C[3]=d(C[3],null,null,z)}else{var B=d.filter(C[3],z,A,true^D);if(!A){e.push.apply(e,B)}return false}}else{if(h.match.POS.test(C[0])||h.match.CHILD.test(C[0])){return true}}return C},POS:function(e){e.unshift(true);return e}},filters:{enabled:function(e){return e.disabled===false&&e.type!==\"hidden\"},disabled:function(e){return e.disabled===true},checked:function(e){return e.checked===true},selected:function(e){e.parentNode.selectedIndex;return e.selected===true},parent:function(e){return !!e.firstChild},empty:function(e){return !e.firstChild},has:function(A,z,e){return !!d(e[3],A).length},header:function(e){return/h\\d/i.test(e.nodeName)},text:function(e){return\"text\"===e.type},radio:function(e){return\"radio\"===e.type},checkbox:function(e){return\"checkbox\"===e.type},file:function(e){return\"file\"===e.type},password:function(e){return\"password\"===e.type},submit:function(e){return\"submit\"===e.type},image:function(e){return\"image\"===e.type},reset:function(e){return\"reset\"===e.type},button:function(e){return\"button\"===e.type||e.nodeName.toUpperCase()===\"BUTTON\"},input:function(e){return/input|select|textarea|button/i.test(e.nodeName)}},setFilters:{first:function(z,e){return e===0},last:function(A,z,e,B){return z===B.length-1},even:function(z,e){return e%2===0},odd:function(z,e){return e%2===1},lt:function(A,z,e){return z<e[3]-0},gt:function(A,z,e){return z>e[3]-0},nth:function(A,z,e){return e[3]-0==z},eq:function(A,z,e){return e[3]-0==z}},filter:{PSEUDO:function(E,A,B,F){var z=A[1],C=h.filters[z];if(C){return C(E,B,A,F)}else{if(z===\"contains\"){return(E.textContent||E.innerText||\"\").indexOf(A[3])>=0}else{if(z===\"not\"){var D=A[3];for(var B=0,e=D.length;B<e;B++){if(D[B]===E){return false}}return true}}}},CHILD:function(e,B){var E=B[1],z=e;switch(E){case\"only\":case\"first\":while((z=z.previousSibling)){if(z.nodeType===1){return false}}if(E==\"first\"){return true}z=e;case\"last\":while((z=z.nextSibling)){if(z.nodeType===1){return false}}return true;case\"nth\":var A=B[2],H=B[3];if(A==1&&H==0){return true}var D=B[0],G=e.parentNode;if(G&&(G.sizcache!==D||!e.nodeIndex)){var C=0;for(z=G.firstChild;z;z=z.nextSibling){if(z.nodeType===1){z.nodeIndex=++C}}G.sizcache=D}var F=e.nodeIndex-H;if(A==0){return F==0}else{return(F%A==0&&F/A>=0)}}},ID:function(z,e){return z.nodeType===1&&z.getAttribute(\"id\")===e},TAG:function(z,e){return(e===\"*\"&&z.nodeType===1)||z.nodeName===e},CLASS:function(z,e){return(\" \"+(z.className||z.getAttribute(\"class\"))+\" \").indexOf(e)>-1},ATTR:function(D,B){var A=B[1],e=h.attrHandle[A]?h.attrHandle[A](D):D[A]!=null?D[A]:D.getAttribute(A),E=e+\"\",C=B[2],z=B[4];return e==null?C===\"!=\":C===\"=\"?E===z:C===\"*=\"?E.indexOf(z)>=0:C===\"~=\"?(\" \"+E+\" \").indexOf(z)>=0:!z?E&&e!==false:C===\"!=\"?E!=z:C===\"^=\"?E.indexOf(z)===0:C===\"$=\"?E.substr(E.length-z.length)===z:C===\"|=\"?E===z||E.substr(0,z.length+1)===z+\"-\":false},POS:function(C,z,A,D){var e=z[2],B=h.setFilters[e];if(B){return B(C,A,z,D)}}}};var q=h.match.POS;for(var s in h.match){h.match[s]=new RegExp(h.match[s].source+/(?![^\\[]*\\])(?![^\\(]*\\))/.source);h.leftMatch[s]=new RegExp(/(^(?:.|\\r|\\n)*?)/.source+h.match[s].source)}var b=function(z,e){z=Array.prototype.slice.call(z,0);if(e){e.push.apply(e,z);return e}return z};try{Array.prototype.slice.call(document.documentElement.childNodes,0)}catch(r){b=function(C,B){var z=B||[];if(g.call(C)===\"[object Array]\"){Array.prototype.push.apply(z,C)}else{if(typeof C.length===\"number\"){for(var A=0,e=C.length;A<e;A++){z.push(C[A])}}else{for(var A=0;C[A];A++){z.push(C[A])}}}return z}}var f;if(document.documentElement.compareDocumentPosition){f=function(z,e){if(!z.compareDocumentPosition||!e.compareDocumentPosition){if(z==e){u=true}return 0}var A=z.compareDocumentPosition(e)&4?-1:z===e?0:1;if(A===0){u=true}return A}}else{if(\"sourceIndex\" in document.documentElement){f=function(z,e){if(!z.sourceIndex||!e.sourceIndex){if(z==e){u=true}return 0}var A=z.sourceIndex-e.sourceIndex;if(A===0){u=true}return A}}else{if(document.createRange){f=function(B,z){if(!B.ownerDocument||!z.ownerDocument){if(B==z){u=true}return 0}var A=B.ownerDocument.createRange(),e=z.ownerDocument.createRange();A.setStart(B,0);A.setEnd(B,0);e.setStart(z,0);e.setEnd(z,0);var C=A.compareBoundaryPoints(Range.START_TO_END,e);if(C===0){u=true}return C}}}}(function(){var z=document.createElement(\"div\"),A=\"script\"+(new Date).getTime();z.innerHTML=\"<a name='\"+A+\"'/>\";var e=document.documentElement;e.insertBefore(z,e.firstChild);if(!!document.getElementById(A)){h.find.ID=function(C,D,E){if(typeof D.getElementById!==\"undefined\"&&!E){var B=D.getElementById(C[1]);return B?B.id===C[1]||typeof B.getAttributeNode!==\"undefined\"&&B.getAttributeNode(\"id\").nodeValue===C[1]?[B]:undefined:[]}};h.filter.ID=function(D,B){var C=typeof D.getAttributeNode!==\"undefined\"&&D.getAttributeNode(\"id\");return D.nodeType===1&&C&&C.nodeValue===B}}e.removeChild(z);e=z=null})();(function(){var e=document.createElement(\"div\");e.appendChild(document.createComment(\"\"));if(e.getElementsByTagName(\"*\").length>0){h.find.TAG=function(z,D){var C=D.getElementsByTagName(z[1]);if(z[1]===\"*\"){var B=[];for(var A=0;C[A];A++){if(C[A].nodeType===1){B.push(C[A])}}C=B}return C}}e.innerHTML=\"<a href='#'></a>\";if(e.firstChild&&typeof e.firstChild.getAttribute!==\"undefined\"&&e.firstChild.getAttribute(\"href\")!==\"#\"){h.attrHandle.href=function(z){return z.getAttribute(\"href\",2)}}e=null})();if(document.querySelectorAll){(function(){var e=d,A=document.createElement(\"div\");A.innerHTML=\"<p class='TEST'></p>\";if(A.querySelectorAll&&A.querySelectorAll(\".TEST\").length===0){return}d=function(E,D,B,C){D=D||document;if(!C&&D.nodeType===9&&!v(D)){try{return b(D.querySelectorAll(E),B)}catch(F){}}return e(E,D,B,C)};for(var z in e){d[z]=e[z]}A=null})()}if(document.getElementsByClassName&&document.documentElement.getElementsByClassName){(function(){var e=document.createElement(\"div\");e.innerHTML=\"<div class='test e'></div><div class='test'></div>\";if(e.getElementsByClassName(\"e\").length===0){return}e.lastChild.className=\"e\";if(e.getElementsByClassName(\"e\").length===1){return}h.order.splice(1,0,\"CLASS\");h.find.CLASS=function(z,A,B){if(typeof A.getElementsByClassName!==\"undefined\"&&!B){return A.getElementsByClassName(z[1])}};e=null})()}function t(z,E,D,I,F,H){var G=z==\"previousSibling\"&&!H;for(var B=0,A=I.length;B<A;B++){var e=I[B];if(e){if(G&&e.nodeType===1){e.sizcache=D;e.sizset=B}e=e[z];var C=false;while(e){if(e.sizcache===D){C=I[e.sizset];break}if(e.nodeType===1&&!H){e.sizcache=D;e.sizset=B}if(e.nodeName===E){C=e;break}e=e[z]}I[B]=C}}}function y(z,E,D,I,F,H){var G=z==\"previousSibling\"&&!H;for(var B=0,A=I.length;B<A;B++){var e=I[B];if(e){if(G&&e.nodeType===1){e.sizcache=D;e.sizset=B}e=e[z];var C=false;while(e){if(e.sizcache===D){C=I[e.sizset];break}if(e.nodeType===1){if(!H){e.sizcache=D;e.sizset=B}if(typeof E!==\"string\"){if(e===E){C=true;break}}else{if(d.filter(E,[e]).length>0){C=e;break}}}e=e[z]}I[B]=C}}}var n=document.compareDocumentPosition?function(z,e){return z.compareDocumentPosition(e)&16}:function(z,e){return z!==e&&(z.contains?z.contains(e):true)};var v=function(e){return e.nodeType===9&&e.documentElement.nodeName!==\"HTML\"||!!e.ownerDocument&&e.ownerDocument.documentElement.nodeName!==\"HTML\"};var l=function(e,F){var B=[],C=\"\",D,A=F.nodeType?[F]:F;while((D=h.match.PSEUDO.exec(e))){C+=D[0];e=e.replace(h.match.PSEUDO,\"\")}e=h.relative[e]?e+\"*\":e;for(var E=0,z=A.length;E<z;E++){d(e,A[E],B)}return d.filter(C,B)};window.Sizzle=d})();(function(e){var f=Prototype.Selector.extendElements;function b(g,h){return f(e(g,h||document))}function d(h,g){return e.matches(g,[h]).length==1}Prototype.Selector.engine=e;Prototype.Selector.select=b;Prototype.Selector.match=d})(Sizzle);window.Sizzle=Prototype._original_property;delete Prototype._original_property;var Form={reset:function(b){b=$(b);b.reset();return b},serializeElements:function(n,f){if(typeof f!=\"object\"){f={hash:!!f}}else{if(Object.isUndefined(f.hash)){f.hash=true}}var g,l,b=false,h=f.submit,d,e;if(f.hash){e={};d=function(o,p,q){if(p in o){if(!Object.isArray(o[p])){o[p]=[o[p]]}o[p].push(q)}else{o[p]=q}return o}}else{e=\"\";d=function(o,p,q){return o+(o?\"&\":\"\")+encodeURIComponent(p)+\"=\"+encodeURIComponent(q)}}return n.inject(e,function(o,p){if(!p.disabled&&p.name){g=p.name;l=$(p).getValue();if(l!=null&&p.type!=\"file\"&&(p.type!=\"submit\"||(!b&&h!==false&&(!h||g==h)&&(b=true)))){o=d(o,g,l)}}return o})}};Form.Methods={serialize:function(d,b){return Form.serializeElements(Form.getElements(d),b)},getElements:function(g){var h=$(g).getElementsByTagName(\"*\"),f,b=[],e=Form.Element.Serializers;for(var d=0;f=h[d];d++){b.push(f)}return b.inject([],function(l,n){if(e[n.tagName.toLowerCase()]){l.push(Element.extend(n))}return l})},getInputs:function(l,e,f){l=$(l);var b=l.getElementsByTagName(\"input\");if(!e&&!f){return $A(b).map(Element.extend)}for(var g=0,n=[],h=b.length;g<h;g++){var d=b[g];if((e&&d.type!=e)||(f&&d.name!=f)){continue}n.push(Element.extend(d))}return n},disable:function(b){b=$(b);Form.getElements(b).invoke(\"disable\");return b},enable:function(b){b=$(b);Form.getElements(b).invoke(\"enable\");return b},findFirstElement:function(d){var e=$(d).getElements().findAll(function(f){return\"hidden\"!=f.type&&!f.disabled});var b=e.findAll(function(f){return f.hasAttribute(\"tabIndex\")&&f.tabIndex>=0}).sortBy(function(f){return f.tabIndex}).first();return b?b:e.find(function(f){return/^(?:input|select|textarea)$/i.test(f.tagName)})},focusFirstElement:function(d){d=$(d);var b=d.findFirstElement();if(b){b.activate()}return d},request:function(d,b){d=$(d),b=Object.clone(b||{});var f=b.parameters,e=d.readAttribute(\"action\")||\"\";if(e.blank()){e=window.location.href}b.parameters=d.serialize(true);if(f){if(Object.isString(f)){f=f.toQueryParams()}Object.extend(b.parameters,f)}if(d.hasAttribute(\"method\")&&!b.method){b.method=d.method}return new Ajax.Request(e,b)}};Form.Element={focus:function(b){$(b).focus();return b},select:function(b){$(b).select();return b}};Form.Element.Methods={serialize:function(b){b=$(b);if(!b.disabled&&b.name){var d=b.getValue();if(d!=undefined){var e={};e[b.name]=d;return Object.toQueryString(e)}}return\"\"},getValue:function(b){b=$(b);var d=b.tagName.toLowerCase();return Form.Element.Serializers[d](b)},setValue:function(b,d){b=$(b);var e=b.tagName.toLowerCase();Form.Element.Serializers[e](b,d);return b},clear:function(b){$(b).value=\"\";return b},present:function(b){return $(b).value!=\"\"},activate:function(b){b=$(b);try{b.focus();if(b.select&&(b.tagName.toLowerCase()!=\"input\"||!(/^(?:button|reset|submit)$/i.test(b.type)))){b.select()}}catch(d){}return b},disable:function(b){b=$(b);b.disabled=true;return b},enable:function(b){b=$(b);b.disabled=false;return b}};var Field=Form.Element;var $F=Form.Element.Methods.getValue;Form.Element.Serializers=(function(){function d(n,o){switch(n.type.toLowerCase()){case\"checkbox\":case\"radio\":return h(n,o);default:return g(n,o)}}function h(n,o){if(Object.isUndefined(o)){return n.checked?n.value:null}else{n.checked=!!o}}function g(n,o){if(Object.isUndefined(o)){return n.value}else{n.value=o}}function b(p,s){if(Object.isUndefined(s)){return(p.type===\"select-one\"?e:f)(p)}var o,q,t=!Object.isArray(s);for(var n=0,r=p.length;n<r;n++){o=p.options[n];q=this.optionValue(o);if(t){if(q==s){o.selected=true;return}}else{o.selected=s.include(q)}}}function e(o){var n=o.selectedIndex;return n>=0?l(o.options[n]):null}function f(q){var n,r=q.length;if(!r){return null}for(var p=0,n=[];p<r;p++){var o=q.options[p];if(o.selected){n.push(l(o))}}return n}function l(n){return Element.hasAttribute(n,\"value\")?n.value:n.text}return{input:d,inputSelector:h,textarea:g,select:b,selectOne:e,selectMany:f,optionValue:l,button:g}})();Abstract.TimedObserver=Class.create(PeriodicalExecuter,{initialize:function($super,b,d,e){$super(e,d);this.element=$(b);this.lastValue=this.getValue()},execute:function(){var b=this.getValue();if(Object.isString(this.lastValue)&&Object.isString(b)?this.lastValue!=b:String(this.lastValue)!=String(b)){this.callback(this.element,b);this.lastValue=b}}});Form.Element.Observer=Class.create(Abstract.TimedObserver,{getValue:function(){return Form.Element.getValue(this.element)}});Form.Observer=Class.create(Abstract.TimedObserver,{getValue:function(){return Form.serialize(this.element)}});Abstract.EventObserver=Class.create({initialize:function(b,d){this.element=$(b);this.callback=d;this.lastValue=this.getValue();if(this.element.tagName.toLowerCase()==\"form\"){this.registerFormCallbacks()}else{this.registerCallback(this.element)}},onElementEvent:function(){var b=this.getValue();if(this.lastValue!=b){this.callback(this.element,b);this.lastValue=b}},registerFormCallbacks:function(){Form.getElements(this.element).each(this.registerCallback,this)},registerCallback:function(b){if(b.type){switch(b.type.toLowerCase()){case\"checkbox\":case\"radio\":Event.observe(b,\"click\",this.onElementEvent.bind(this));break;default:Event.observe(b,\"change\",this.onElementEvent.bind(this));break}}}});Form.Element.EventObserver=Class.create(Abstract.EventObserver,{getValue:function(){return Form.Element.getValue(this.element)}});Form.EventObserver=Class.create(Abstract.EventObserver,{getValue:function(){return Form.serialize(this.element)}});(function(){var J={KEY_BACKSPACE:8,KEY_TAB:9,KEY_RETURN:13,KEY_ESC:27,KEY_LEFT:37,KEY_UP:38,KEY_RIGHT:39,KEY_DOWN:40,KEY_DELETE:46,KEY_HOME:36,KEY_END:35,KEY_PAGEUP:33,KEY_PAGEDOWN:34,KEY_INSERT:45,cache:{}};var h=document.documentElement;var K=\"onmouseenter\" in h&&\"onmouseleave\" in h;var b=function(L){return false};if(window.attachEvent){if(window.addEventListener){b=function(L){return !(L instanceof window.Event)}}else{b=function(L){return true}}}var y;function H(M,L){return M.which?(M.which===L+1):(M.button===L)}var u={0:1,1:4,2:2};function F(M,L){return M.button===u[L]}function I(M,L){switch(L){case 0:return M.which==1&&!M.metaKey;case 1:return M.which==2||(M.which==1&&M.metaKey);case 2:return M.which==3;default:return false}}if(window.attachEvent){if(!window.addEventListener){y=F}else{y=function(M,L){return b(M)?F(M,L):H(M,L)}}}else{if(Prototype.Browser.WebKit){y=I}else{y=H}}function C(L){return y(L,0)}function A(L){return y(L,1)}function t(L){return y(L,2)}function f(N){N=J.extend(N);var M=N.target,L=N.type,O=N.currentTarget;if(O&&O.tagName){if(L===\"load\"||L===\"error\"||(L===\"click\"&&O.tagName.toLowerCase()===\"input\"&&O.type===\"radio\")){M=O}}if(M.nodeType==Node.TEXT_NODE){M=M.parentNode}return Element.extend(M)}function v(M,N){var L=J.element(M);if(!N){return L}while(L){if(Object.isElement(L)&&Prototype.Selector.match(L,N)){return Element.extend(L)}L=L.parentNode}}function z(L){return{x:e(L),y:d(L)}}function e(N){var M=document.documentElement,L=document.body||{scrollLeft:0};return N.pageX||(N.clientX+(M.scrollLeft||L.scrollLeft)-(M.clientLeft||0))}function d(N){var M=document.documentElement,L=document.body||{scrollTop:0};return N.pageY||(N.clientY+(M.scrollTop||L.scrollTop)-(M.clientTop||0))}function w(L){J.extend(L);L.preventDefault();L.stopPropagation();L.stopped=true}J.Methods={isLeftClick:C,isMiddleClick:A,isRightClick:t,element:f,findElement:v,pointer:z,pointerX:e,pointerY:d,stop:w};var E=Object.keys(J.Methods).inject({},function(L,M){L[M]=J.Methods[M].methodize();return L});if(window.attachEvent){function o(M){var L;switch(M.type){case\"mouseover\":case\"mouseenter\":L=M.fromElement;break;case\"mouseout\":case\"mouseleave\":L=M.toElement;break;default:return null}return Element.extend(L)}var B={stopPropagation:function(){this.cancelBubble=true},preventDefault:function(){this.returnValue=false},inspect:function(){return\"[object Event]\"}};J.extend=function(M,L){if(!M){return false}if(!b(M)){return M}if(M._extendedByPrototype){return M}M._extendedByPrototype=Prototype.emptyFunction;var N=J.pointer(M);Object.extend(M,{target:M.srcElement||L,relatedTarget:o(M),pageX:N.x,pageY:N.y});Object.extend(M,E);Object.extend(M,B);return M}}else{J.extend=Prototype.K}if(window.addEventListener){J.prototype=window.Event.prototype||document.createEvent(\"HTMLEvents\").__proto__;Object.extend(J.prototype,E)}function s(P,O,Q){var N=Element.retrieve(P,\"prototype_event_registry\");if(Object.isUndefined(N)){g.push(P);N=Element.retrieve(P,\"prototype_event_registry\",$H())}var L=N.get(O);if(Object.isUndefined(L)){L=[];N.set(O,L)}if(L.pluck(\"handler\").include(Q)){return false}var M;if(O.include(\":\")){M=function(R){if(Object.isUndefined(R.eventName)){return false}if(R.eventName!==O){return false}J.extend(R,P);Q.call(P,R)}}else{if(!K&&(O===\"mouseenter\"||O===\"mouseleave\")){if(O===\"mouseenter\"||O===\"mouseleave\"){M=function(S){J.extend(S,P);var R=S.relatedTarget;while(R&&R!==P){try{R=R.parentNode}catch(T){R=P}}if(R===P){return}Q.call(P,S)}}}else{M=function(R){J.extend(R,P);Q.call(P,R)}}}M.handler=Q;L.push(M);return M}function n(){for(var L=0,M=g.length;L<M;L++){J.stopObserving(g[L]);g[L]=null}}var g=[];if(Prototype.Browser.IE){window.attachEvent(\"onunload\",n)}if(Prototype.Browser.WebKit){window.addEventListener(\"unload\",Prototype.emptyFunction,false)}var r=Prototype.K,l={mouseenter:\"mouseover\",mouseleave:\"mouseout\"};if(!K){r=function(L){return(l[L]||L)}}function D(O,N,P){O=$(O);var M=s(O,N,P);if(!M){return O}if(N.include(\":\")){if(O.addEventListener){O.addEventListener(\"dataavailable\",M,false)}else{O.attachEvent(\"ondataavailable\",M);O.attachEvent(\"onlosecapture\",M)}}else{var L=r(N);if(O.addEventListener){O.addEventListener(L,M,false)}else{O.attachEvent(\"on\"+L,M)}}return O}function q(R,O,S){R=$(R);var N=Element.retrieve(R,\"prototype_event_registry\");if(!N){return R}if(!O){N.each(function(U){var T=U.key;q(R,T)});return R}var P=N.get(O);if(!P){return R}if(!S){P.each(function(T){q(R,O,T.handler)});return R}var Q=P.length,M;while(Q--){if(P[Q].handler===S){M=P[Q];break}}if(!M){return R}if(O.include(\":\")){if(R.removeEventListener){R.removeEventListener(\"dataavailable\",M,false)}else{R.detachEvent(\"ondataavailable\",M);R.detachEvent(\"onlosecapture\",M)}}else{var L=r(O);if(R.removeEventListener){R.removeEventListener(L,M,false)}else{R.detachEvent(\"on\"+L,M)}}N.set(O,P.without(M));return R}function G(O,N,M,L){O=$(O);if(Object.isUndefined(L)){L=true}if(O==document&&document.createEvent&&!O.dispatchEvent){O=document.documentElement}var P;if(document.createEvent){P=document.createEvent(\"HTMLEvents\");P.initEvent(\"dataavailable\",L,true)}else{P=document.createEventObject();P.eventType=L?\"ondataavailable\":\"onlosecapture\"}P.eventName=N;P.memo=M||{};if(document.createEvent){O.dispatchEvent(P)}else{O.fireEvent(P.eventType,P)}return J.extend(P)}J.Handler=Class.create({initialize:function(N,M,L,O){this.element=$(N);this.eventName=M;this.selector=L;this.callback=O;this.handler=this.handleEvent.bind(this)},start:function(){J.observe(this.element,this.eventName,this.handler);return this},stop:function(){J.stopObserving(this.element,this.eventName,this.handler);return this},handleEvent:function(M){var L=J.findElement(M,this.selector);if(L){this.callback.call(this.element,M,L)}}});function p(N,M,L,O){N=$(N);if(Object.isFunction(L)&&Object.isUndefined(O)){O=L,L=null}return new J.Handler(N,M,L,O).start()}Object.extend(J,J.Methods);Object.extend(J,{fire:G,observe:D,stopObserving:q,on:p});Element.addMethods({fire:G,observe:D,stopObserving:q,on:p});Object.extend(document,{fire:G.methodize(),observe:D.methodize(),stopObserving:q.methodize(),on:p.methodize(),loaded:false});if(window.Event){Object.extend(window.Event,J)}else{window.Event=J}})();(function(){var e;function b(){if(document.loaded){return}if(e){window.clearTimeout(e)}document.loaded=true;document.fire(\"dom:loaded\")}function d(){if(document.readyState===\"complete\"){document.stopObserving(\"readystatechange\",d);b()}}if(document.addEventListener){document.addEventListener(\"DOMContentLoaded\",b,false)}else{document.observe(\"readystatechange\",d);if(window==top){var e=window.setInterval(function(){try{document.documentElement.doScroll(\"left\")}catch(f){return}window.clearInterval(e);b()},5)}}Event.observe(window,\"load\",b)})();Element.addMethods();Hash.toQueryString=Object.toQueryString;var Toggle={display:Element.toggle};Element.Methods.childOf=Element.Methods.descendantOf;var Insertion={Before:function(b,d){return Element.insert(b,{before:d})},Top:function(b,d){return Element.insert(b,{top:d})},Bottom:function(b,d){return Element.insert(b,{bottom:d})},After:function(b,d){return Element.insert(b,{after:d})}};var $continue=new Error('\"throw $continue\" is deprecated, use \"return\" instead');var Position={includeScrollOffsets:false,prepare:function(){this.deltaX=window.pageXOffset||document.documentElement.scrollLeft||document.body.scrollLeft||0;this.deltaY=window.pageYOffset||document.documentElement.scrollTop||document.body.scrollTop||0},within:function(d,b,e){if(this.includeScrollOffsets){return this.withinIncludingScrolloffsets(d,b,e)}this.xcomp=b;this.ycomp=e;this.offset=Element.cumulativeOffset(d);return(e>=this.offset[1]&&e<this.offset[1]+d.offsetHeight&&b>=this.offset[0]&&b<this.offset[0]+d.offsetWidth)},withinIncludingScrolloffsets:function(d,b,f){var e=Element.cumulativeScrollOffset(d);this.xcomp=b+e[0]-this.deltaX;this.ycomp=f+e[1]-this.deltaY;this.offset=Element.cumulativeOffset(d);return(this.ycomp>=this.offset[1]&&this.ycomp<this.offset[1]+d.offsetHeight&&this.xcomp>=this.offset[0]&&this.xcomp<this.offset[0]+d.offsetWidth)},overlap:function(d,b){if(!d){return 0}if(d==\"vertical\"){return((this.offset[1]+b.offsetHeight)-this.ycomp)/b.offsetHeight}if(d==\"horizontal\"){return((this.offset[0]+b.offsetWidth)-this.xcomp)/b.offsetWidth}},cumulativeOffset:Element.Methods.cumulativeOffset,positionedOffset:Element.Methods.positionedOffset,absolutize:function(b){Position.prepare();return Element.absolutize(b)},relativize:function(b){Position.prepare();return Element.relativize(b)},realOffset:Element.Methods.cumulativeScrollOffset,offsetParent:Element.Methods.getOffsetParent,page:Element.Methods.viewportOffset,clone:function(d,e,b){b=b||{};return Element.clonePosition(e,d,b)}};if(!document.getElementsByClassName){document.getElementsByClassName=function(d){function b(e){return e.blank()?null:\"[contains(concat(' ', @class, ' '), ' \"+e+\" ')]\"}d.getElementsByClassName=Prototype.BrowserFeatures.XPath?function(e,g){g=g.toString().strip();var f=/\\s/.test(g)?$w(g).map(b).join(\"\"):b(g);return f?document._getElementsByXPath(\".//*\"+f,e):[]}:function(g,h){h=h.toString().strip();var l=[],n=(/\\s/.test(h)?$w(h):null);if(!n&&!h){return l}var e=$(g).getElementsByTagName(\"*\");h=\" \"+h+\" \";for(var f=0,p,o;p=e[f];f++){if(p.className&&(o=\" \"+p.className+\" \")&&(o.include(h)||(n&&n.all(function(q){return !q.toString().blank()&&o.include(\" \"+q+\" \")})))){l.push(Element.extend(p))}}return l};return function(f,e){return $(e||document.body).getElementsByClassName(f)}}(Element.Methods)}Element.ClassNames=Class.create();Element.ClassNames.prototype={initialize:function(b){this.element=$(b)},_each:function(b){this.element.className.split(/\\s+/).select(function(d){return d.length>0})._each(b)},set:function(b){this.element.className=b},add:function(b){if(this.include(b)){return}this.set($A(this).concat(b).join(\" \"))},remove:function(b){if(!this.include(b)){return}this.set($A(this).without(b).join(\" \"))},toString:function(){return $A(this).join(\" \")}};Object.extend(Element.ClassNames.prototype,Enumerable);(function(){window.Selector=Class.create({initialize:function(b){this.expression=b.strip()},findElements:function(b){return Prototype.Selector.select(this.expression,b)},match:function(b){return Prototype.Selector.match(b,this.expression)},toString:function(){return this.expression},inspect:function(){return\"#<Selector: \"+this.expression+\">\"}});Object.extend(Selector,{matchElements:function(h,l){var b=Prototype.Selector.match,f=[];for(var e=0,g=h.length;e<g;e++){var d=h[e];if(b(d,l)){f.push(Element.extend(d))}}return f},findElement:function(h,l,d){d=d||0;var b=0,f;for(var e=0,g=h.length;e<g;e++){f=h[e];if(Prototype.Selector.match(f,l)&&d===b++){return Element.extend(f)}}},findChildElements:function(d,e){var b=e.toArray().join(\", \");return Prototype.Selector.select(b,d||document)}})})();var Window=Class.create();Window.keepMultiModalWindow=false;Window.hasEffectLib=(typeof Effect!=\"undefined\");Window.resizeEffectDuration=0.4;Window.prototype={initialize:function(){var e;var d=0;if(arguments.length>0){if(typeof arguments[0]==\"string\"){e=arguments[0];d=1}else{e=arguments[0]?arguments[0].id:null}}if(!e){e=\"window_\"+new Date().getTime()}if($(e)){alert(\"Window \"+e+\" is already registered in the DOM! Make sure you use setDestroyOnClose() or destroyOnClose: true in the constructor\")}this.options=Object.extend({className:\"dialog\",windowClassName:null,blurClassName:null,minWidth:100,minHeight:20,resizable:true,closable:true,minimizable:true,maximizable:true,draggable:true,userData:null,showEffect:(Window.hasEffectLib?Effect.Appear:Element.show),hideEffect:(Window.hasEffectLib?Effect.Fade:Element.hide),showEffectOptions:{},hideEffectOptions:{},effectOptions:null,parent:document.body,title:\"&nbsp;\",url:null,onload:Prototype.emptyFunction,width:200,height:300,opacity:1,recenterAuto:true,wiredDrag:false,closeOnEsc:true,closeCallback:null,destroyOnClose:false,gridX:1,gridY:1},arguments[d]||{});if(this.options.blurClassName){this.options.focusClassName=this.options.className}if(typeof this.options.top==\"undefined\"&&typeof this.options.bottom==\"undefined\"){this.options.top=this._round(Math.random()*500,this.options.gridY)}if(typeof this.options.left==\"undefined\"&&typeof this.options.right==\"undefined\"){this.options.left=this._round(Math.random()*500,this.options.gridX)}if(this.options.effectOptions){Object.extend(this.options.hideEffectOptions,this.options.effectOptions);Object.extend(this.options.showEffectOptions,this.options.effectOptions);if(this.options.showEffect==Element.Appear){this.options.showEffectOptions.to=this.options.opacity}}if(Window.hasEffectLib){if(this.options.showEffect==Effect.Appear){this.options.showEffectOptions.to=this.options.opacity}if(this.options.hideEffect==Effect.Fade){this.options.hideEffectOptions.from=this.options.opacity}}if(this.options.hideEffect==Element.hide){this.options.hideEffect=function(){Element.hide(this.element);if(this.options.destroyOnClose){this.destroy()}}.bind(this)}if(this.options.parent!=document.body){this.options.parent=$(this.options.parent)}this.element=this._createWindow(e);this.element.win=this;this.eventMouseDown=this._initDrag.bindAsEventListener(this);this.eventMouseUp=this._endDrag.bindAsEventListener(this);this.eventMouseMove=this._updateDrag.bindAsEventListener(this);this.eventOnLoad=this._getWindowBorderSize.bindAsEventListener(this);this.eventMouseDownContent=this.toFront.bindAsEventListener(this);this.eventResize=this._recenter.bindAsEventListener(this);this.eventKeyUp=this._keyUp.bindAsEventListener(this);this.topbar=$(this.element.id+\"_top\");this.bottombar=$(this.element.id+\"_bottom\");this.content=$(this.element.id+\"_content\");Event.observe(this.topbar,\"mousedown\",this.eventMouseDown);Event.observe(this.bottombar,\"mousedown\",this.eventMouseDown);Event.observe(this.content,\"mousedown\",this.eventMouseDownContent);Event.observe(window,\"load\",this.eventOnLoad);Event.observe(window,\"resize\",this.eventResize);Event.observe(window,\"scroll\",this.eventResize);Event.observe(document,\"keyup\",this.eventKeyUp);Event.observe(this.options.parent,\"scroll\",this.eventResize);if(this.options.draggable){var b=this;[this.topbar,this.topbar.up().previous(),this.topbar.up().next()].each(function(f){f.observe(\"mousedown\",b.eventMouseDown);f.addClassName(\"top_draggable\")});[this.bottombar.up(),this.bottombar.up().previous(),this.bottombar.up().next()].each(function(f){f.observe(\"mousedown\",b.eventMouseDown);f.addClassName(\"bottom_draggable\")})}if(this.options.resizable){this.sizer=$(this.element.id+\"_sizer\");Event.observe(this.sizer,\"mousedown\",this.eventMouseDown)}this.useLeft=null;this.useTop=null;if(typeof this.options.left!=\"undefined\"){this.element.setStyle({left:parseFloat(this.options.left)+\"px\"});this.useLeft=true}else{this.element.setStyle({right:parseFloat(this.options.right)+\"px\"});this.useLeft=false}if(typeof this.options.top!=\"undefined\"){this.element.setStyle({top:parseFloat(this.options.top)+\"px\"});this.useTop=true}else{this.element.setStyle({bottom:parseFloat(this.options.bottom)+\"px\"});this.useTop=false}this.storedLocation=null;this.setOpacity(this.options.opacity);if(this.options.zIndex){this.setZIndex(this.options.zIndex)}else{this.setZIndex(this.getMaxZIndex())}if(this.options.destroyOnClose){this.setDestroyOnClose(true)}this._getWindowBorderSize();this.width=this.options.width;this.height=this.options.height;this.visible=false;this.constraint=false;this.constraintPad={top:0,left:0,bottom:0,right:0};if(this.width&&this.height){this.setSize(this.options.width,this.options.height)}this.setTitle(this.options.title);Windows.register(this)},getMaxZIndex:function(){var b=0,d;var g=document.body.childNodes;for(d=0;d<g.length;d++){var e=g[d];var f=e.nodeType==1?parseInt(e.style.zIndex,10)||0:0;if(f<10000){b=Math.max(b,f)}}return b+10},destroy:function(){this._notify(\"onDestroy\");Event.stopObserving(this.topbar,\"mousedown\",this.eventMouseDown);Event.stopObserving(this.bottombar,\"mousedown\",this.eventMouseDown);Event.stopObserving(this.content,\"mousedown\",this.eventMouseDownContent);Event.stopObserving(window,\"load\",this.eventOnLoad);Event.stopObserving(window,\"resize\",this.eventResize);Event.stopObserving(window,\"scroll\",this.eventResize);Event.stopObserving(this.content,\"load\",this.options.onload);Event.stopObserving(document,\"keyup\",this.eventKeyUp);if(this._oldParent){var e=this.getContent();var b=null;for(var d=0;d<e.childNodes.length;d++){b=e.childNodes[d];if(b.nodeType==1){break}b=null}if(b){this._oldParent.appendChild(b)}this._oldParent=null}if(this.sizer){Event.stopObserving(this.sizer,\"mousedown\",this.eventMouseDown)}if(this.options.url){this.content.src=null}if(this.iefix){Element.remove(this.iefix)}Element.remove(this.element);Windows.unregister(this)},setCloseCallback:function(b){this.options.closeCallback=b},getContent:function(){return this.content},setContent:function(n,l,e){var b=$(n);if(null==b){throw\"Unable to find element '\"+n+\"' in DOM\"}this._oldParent=b.parentNode;var h=null;var g=null;if(l){h=Element.getDimensions(b)}if(e){g=Position.cumulativeOffset(b)}var f=this.getContent();this.setHTMLContent(\"\");f=this.getContent();f.appendChild(b);b.show();if(l){this.setSize(h.width,h.height)}if(e){this.setLocation(g[1]-this.heightN,g[0]-this.widthW)}},setHTMLContent:function(b){if(this.options.url){this.content.src=null;this.options.url=null;var d='<div id=\"'+this.getId()+'_content\" class=\"'+this.options.className+'_content\"> </div>';$(this.getId()+\"_table_content\").innerHTML=d;this.content=$(this.element.id+\"_content\")}this.getContent().innerHTML=b},setAjaxContent:function(d,b,f,e){this.showFunction=f?\"showCenter\":\"show\";this.showModal=e||false;b=b||{};this.setHTMLContent(\"\");this.onComplete=b.onComplete;if(!this._onCompleteHandler){this._onCompleteHandler=this._setAjaxContent.bind(this)}b.onComplete=this._onCompleteHandler;new Ajax.Request(d,b);b.onComplete=this.onComplete},_setAjaxContent:function(b){Element.update(this.getContent(),b.responseText);if(this.onComplete){this.onComplete(b)}this.onComplete=null;this[this.showFunction](this.showModal)},setURL:function(b){if(this.options.url){this.content.src=null}this.options.url=b;var d=\"<iframe frameborder='0' name='\"+this.getId()+\"_content'  id='\"+this.getId()+\"_content' src='\"+b+\"' width='\"+this.width+\"' height='\"+this.height+\"'> </iframe>\";$(this.getId()+\"_table_content\").innerHTML=d;this.content=$(this.element.id+\"_content\")},getURL:function(){return this.options.url?this.options.url:null},refresh:function(){if(this.options.url){$(this.element.getAttribute(\"id\")+\"_content\").src=this.options.url}},setCookie:function(d,e,t,g,b){d=d||this.element.id;this.cookie=[d,e,t,g,b];var r=WindowUtilities.getCookie(d);if(r){var s=r.split(\",\");var p=s[0].split(\":\");var o=s[1].split(\":\");var q=parseFloat(s[2]),l=parseFloat(s[3]);var n=s[4];var f=s[5];this.setSize(q,l);if(n==\"true\"){this.doMinimize=true}else{if(f==\"true\"){this.doMaximize=true}}this.useLeft=p[0]==\"l\";this.useTop=o[0]==\"t\";this.element.setStyle(this.useLeft?{left:p[1]}:{right:p[1]});this.element.setStyle(this.useTop?{top:o[1]}:{bottom:o[1]})}},getId:function(){return this.element.id},setDestroyOnClose:function(){this.options.destroyOnClose=true},setConstraint:function(b,d){this.constraint=b;this.constraintPad=Object.extend(this.constraintPad,d||{});if(this.useTop&&this.useLeft){this.setLocation(parseFloat(this.element.style.top),parseFloat(this.element.style.left))}},_initDrag:function(d){if(Event.element(d)==this.sizer&&this.isMinimized()){return}if(Event.element(d)!=this.sizer&&this.isMaximized()){return}if(Prototype.Browser.IE&&this.heightN==0){this._getWindowBorderSize()}this.pointer=[this._round(Event.pointerX(d),this.options.gridX),this._round(Event.pointerY(d),this.options.gridY)];if(this.options.wiredDrag){this.currentDrag=this._createWiredElement()}else{this.currentDrag=this.element}if(Event.element(d)==this.sizer){this.doResize=true;this.widthOrg=this.width;this.heightOrg=this.height;this.bottomOrg=parseFloat(this.element.getStyle(\"bottom\"));this.rightOrg=parseFloat(this.element.getStyle(\"right\"));this._notify(\"onStartResize\")}else{this.doResize=false;var b=$(this.getId()+\"_close\");if(b&&Position.within(b,this.pointer[0],this.pointer[1])){this.currentDrag=null;return}this.toFront();if(!this.options.draggable){return}this._notify(\"onStartMove\")}Event.observe(document,\"mouseup\",this.eventMouseUp,false);Event.observe(document,\"mousemove\",this.eventMouseMove,false);WindowUtilities.disableScreen(\"__invisible__\",\"__invisible__\",this.overlayOpacity);document.body.ondrag=function(){return false};document.body.onselectstart=function(){return false};this.currentDrag.show();Event.stop(d)},_round:function(d,b){return b==1?d:d=Math.floor(d/b)*b},_updateDrag:function(d){var b=[this._round(Event.pointerX(d),this.options.gridX),this._round(Event.pointerY(d),this.options.gridY)];var q=b[0]-this.pointer[0];var p=b[1]-this.pointer[1];if(this.doResize){var o=this.widthOrg+q;var f=this.heightOrg+p;q=this.width-this.widthOrg;p=this.height-this.heightOrg;if(this.useLeft){o=this._updateWidthConstraint(o)}else{this.currentDrag.setStyle({right:(this.rightOrg-q)+\"px\"})}if(this.useTop){f=this._updateHeightConstraint(f)}else{this.currentDrag.setStyle({bottom:(this.bottomOrg-p)+\"px\"})}this.setSize(o,f);this._notify(\"onResize\")}else{this.pointer=b;if(this.useLeft){var e=parseFloat(this.currentDrag.getStyle(\"left\"))+q;var n=this._updateLeftConstraint(e);this.pointer[0]+=n-e;this.currentDrag.setStyle({left:n+\"px\"})}else{this.currentDrag.setStyle({right:parseFloat(this.currentDrag.getStyle(\"right\"))-q+\"px\"})}if(this.useTop){var l=parseFloat(this.currentDrag.getStyle(\"top\"))+p;var g=this._updateTopConstraint(l);this.pointer[1]+=g-l;this.currentDrag.setStyle({top:g+\"px\"})}else{this.currentDrag.setStyle({bottom:parseFloat(this.currentDrag.getStyle(\"bottom\"))-p+\"px\"})}this._notify(\"onMove\")}if(this.iefix){this._fixIEOverlapping()}this._removeStoreLocation();Event.stop(d)},_endDrag:function(b){WindowUtilities.enableScreen(\"__invisible__\");if(this.doResize){this._notify(\"onEndResize\")}else{this._notify(\"onEndMove\")}Event.stopObserving(document,\"mouseup\",this.eventMouseUp,false);Event.stopObserving(document,\"mousemove\",this.eventMouseMove,false);Event.stop(b);this._hideWiredElement();this._saveCookie();document.body.ondrag=null;document.body.onselectstart=null},_updateLeftConstraint:function(d){if(this.constraint&&this.useLeft&&this.useTop){var b=this.options.parent==document.body?WindowUtilities.getPageSize().windowWidth:this.options.parent.getDimensions().width;if(d<this.constraintPad.left){d=this.constraintPad.left}if(d+this.width+this.widthE+this.widthW>b-this.constraintPad.right){d=b-this.constraintPad.right-this.width-this.widthE-this.widthW}}return d},_updateTopConstraint:function(e){if(this.constraint&&this.useLeft&&this.useTop){var b=this.options.parent==document.body?WindowUtilities.getPageSize().windowHeight:this.options.parent.getDimensions().height;var d=this.height+this.heightN+this.heightS;if(e<this.constraintPad.top){e=this.constraintPad.top}if(e+d>b-this.constraintPad.bottom){e=b-this.constraintPad.bottom-d}}return e},_updateWidthConstraint:function(b){if(this.constraint&&this.useLeft&&this.useTop){var d=this.options.parent==document.body?WindowUtilities.getPageSize().windowWidth:this.options.parent.getDimensions().width;var e=parseFloat(this.element.getStyle(\"left\"));if(e+b+this.widthE+this.widthW>d-this.constraintPad.right){b=d-this.constraintPad.right-e-this.widthE-this.widthW}}return b},_updateHeightConstraint:function(d){if(this.constraint&&this.useLeft&&this.useTop){var b=this.options.parent==document.body?WindowUtilities.getPageSize().windowHeight:this.options.parent.getDimensions().height;var e=parseFloat(this.element.getStyle(\"top\"));if(e+d+this.heightN+this.heightS>b-this.constraintPad.bottom){d=b-this.constraintPad.bottom-e-this.heightN-this.heightS}}return d},_createWindow:function(b){var h=this.options.className;var f=document.createElement(\"div\");f.setAttribute(\"id\",b);f.className=\"dialog\";if(this.options.windowClassName){f.className+=\" \"+this.options.windowClassName}var g;if(this.options.url){g='<iframe frameborder=\"0\" name=\"'+b+'_content\"  id=\"'+b+'_content\" src=\"'+this.options.url+'\"> </iframe>'}else{g='<div id=\"'+b+'_content\" class=\"'+h+'_content\"> </div>'}var l=this.options.closable?\"<div class='\"+h+\"_close' id='\"+b+\"_close' onclick='Windows.close(\\\"\"+b+\"\\\", event)'> </div>\":\"\";var n=this.options.minimizable?\"<div class='\"+h+\"_minimize' id='\"+b+\"_minimize' onclick='Windows.minimize(\\\"\"+b+\"\\\", event)'> </div>\":\"\";var o=this.options.maximizable?\"<div class='\"+h+\"_maximize' id='\"+b+\"_maximize' onclick='Windows.maximize(\\\"\"+b+\"\\\", event)'> </div>\":\"\";var e=this.options.resizable?\"class='\"+h+\"_sizer' id='\"+b+\"_sizer'\":\"class='\"+h+\"_se'\";var d=\"../themes/default/blank.gif\";f.innerHTML=l+n+o+\"      <a href='#' id='\"+b+\"_focus_anchor'><!-- --></a>      <table id='\"+b+\"_row1' class=\\\"top table_window\\\">        <tr>          <td class='\"+h+\"_nw'></td>          <td class='\"+h+\"_n'><div id='\"+b+\"_top' class='\"+h+\"_title title_window'>\"+this.options.title+\"</div></td>          <td class='\"+h+\"_ne'></td>        </tr>      </table>      <table id='\"+b+\"_row2' class=\\\"mid table_window\\\">        <tr>          <td class='\"+h+\"_w'></td>            <td id='\"+b+\"_table_content' class='\"+h+\"_content' valign='top'>\"+g+\"</td>          <td class='\"+h+\"_e'></td>        </tr>      </table>        <table id='\"+b+\"_row3' class=\\\"bot table_window\\\">        <tr>          <td class='\"+h+\"_sw'></td>            <td class='\"+h+\"_s'><div id='\"+b+\"_bottom' class='status_bar'><span style='float:left; width:1px; height:1px'></span></div></td>            <td \"+e+\"></td>        </tr>      </table>    \";Element.hide(f);this.options.parent.insertBefore(f,this.options.parent.firstChild);Event.observe($(b+\"_content\"),\"load\",this.options.onload);return f},changeClassName:function(b){var d=this.options.className;var e=this.getId();$A([\"_close\",\"_minimize\",\"_maximize\",\"_sizer\",\"_content\"]).each(function(f){this._toggleClassName($(e+f),d+f,b+f)}.bind(this));this._toggleClassName($(e+\"_top\"),d+\"_title\",b+\"_title\");$$(\"#\"+e+\" td\").each(function(f){f.className=f.className.sub(d,b)});this.options.className=b},_toggleClassName:function(e,d,b){if(e){e.removeClassName(d);e.addClassName(b)}},setLocation:function(f,d){f=this._updateTopConstraint(f);d=this._updateLeftConstraint(d);var b=this.currentDrag||this.element;b.setStyle({top:f+\"px\"});b.setStyle({left:d+\"px\"});this.useLeft=true;this.useTop=true},getLocation:function(){var b={};if(this.useTop){b=Object.extend(b,{top:this.element.getStyle(\"top\")})}else{b=Object.extend(b,{bottom:this.element.getStyle(\"bottom\")})}if(this.useLeft){b=Object.extend(b,{left:this.element.getStyle(\"left\")})}else{b=Object.extend(b,{right:this.element.getStyle(\"right\")})}return b},getSize:function(){return{width:this.width,height:this.height}},setSize:function(f,d,b){f=parseFloat(f);d=parseFloat(d);if(!this.minimized&&f<this.options.minWidth){f=this.options.minWidth}if(!this.minimized&&d<this.options.minHeight){d=this.options.minHeight}if(this.options.maxHeight&&d>this.options.maxHeight){d=this.options.maxHeight}if(this.options.maxWidth&&f>this.options.maxWidth){f=this.options.maxWidth}if(this.useTop&&this.useLeft&&Window.hasEffectLib&&Effect.ResizeWindow&&b){new Effect.ResizeWindow(this,null,null,f,d,{duration:Window.resizeEffectDuration})}else{this.width=f;this.height=d;var h=this.currentDrag?this.currentDrag:this.element;h.setStyle({width:f+this.widthW+this.widthE+\"px\"});h.setStyle({height:d+this.heightN+this.heightS+\"px\"});if(!this.currentDrag||this.currentDrag==this.element){var g=$(this.element.id+\"_content\");g.setStyle({height:d+\"px\"});g.setStyle({width:f+\"px\"})}}},updateHeight:function(){this.setSize(this.width,this.content.scrollHeight,true)},updateWidth:function(){this.setSize(this.content.scrollWidth,this.height,true)},toFront:function(){if(this.element.style.zIndex<Windows.maxZIndex){this.setZIndex(Windows.maxZIndex+1)}if(this.iefix){this._fixIEOverlapping()}},getBounds:function(d){if(!this.width||!this.height||!this.visible){this.computeBounds()}var b=this.width;var e=this.height;if(!d){b+=this.widthW+this.widthE;e+=this.heightN+this.heightS}var f=Object.extend(this.getLocation(),{width:b+\"px\",height:e+\"px\"});return f},computeBounds:function(){if(!this.width||!this.height){var b=WindowUtilities._computeSize(this.content.innerHTML,this.content.id,this.width,this.height,0,this.options.className);if(this.height){this.width=b+5}else{this.height=b+5}}this.setSize(this.width,this.height);if(this.centered){this._center(this.centerTop,this.centerLeft)}},show:function(d){this.visible=true;if(d){if(typeof this.overlayOpacity==\"undefined\"){var b=this;setTimeout(function(){b.show(d)},10);return}Windows.addModalWindow(this);this.modal=true;this.setZIndex(Windows.maxZIndex+1);Windows.unsetOverflow(this)}else{if(!this.element.style.zIndex){this.setZIndex(Windows.maxZIndex+1)}}if(this.oldStyle){this.getContent().setStyle({overflow:this.oldStyle})}this.computeBounds();this._notify(\"onBeforeShow\");if(this.options.showEffect!=Element.show&&this.options.showEffectOptions){this.options.showEffect(this.element,this.options.showEffectOptions)}else{this.options.showEffect(this.element)}this._checkIEOverlapping();WindowUtilities.focusedWindow=this;this._notify(\"onShow\");$(this.element.id+\"_focus_anchor\").focus()},showCenter:function(b,e,d){this.centered=true;this.centerTop=e;this.centerLeft=d;this.show(b)},isVisible:function(){return this.visible},_center:function(e,d){var f=WindowUtilities.getWindowScroll(this.options.parent);var b=WindowUtilities.getPageSize(this.options.parent);if(typeof e==\"undefined\"){e=(b.windowHeight-(this.height+this.heightN+this.heightS))/2}e+=f.top;if(typeof d==\"undefined\"){d=(b.windowWidth-(this.width+this.widthW+this.widthE))/2}d+=f.left;this.setLocation(e,d);this.toFront()},_recenter:function(d){if(this.centered){var b=WindowUtilities.getPageSize(this.options.parent);var e=WindowUtilities.getWindowScroll(this.options.parent);if(this.pageSize&&this.pageSize.windowWidth==b.windowWidth&&this.pageSize.windowHeight==b.windowHeight&&this.windowScroll.left==e.left&&this.windowScroll.top==e.top){return}this.pageSize=b;this.windowScroll=e;if($(\"overlay_modal\")){$(\"overlay_modal\").setStyle({height:(b.pageHeight+\"px\")})}if(this.options.recenterAuto){this._center(this.centerTop,this.centerLeft)}}},hide:function(){this.visible=false;if(this.modal){Windows.removeModalWindow(this);Windows.resetOverflow()}this.oldStyle=this.getContent().getStyle(\"overflow\")||\"auto\";this.getContent().setStyle({overflow:\"hidden\"});this.options.hideEffect(this.element,this.options.hideEffectOptions);if(this.iefix){this.iefix.hide()}if(!this.doNotNotifyHide){this._notify(\"onHide\")}},close:function(){if(this.visible){if(this.options.closeCallback&&!this.options.closeCallback(this)){return}if(this.options.destroyOnClose){var b=this.destroy.bind(this);if(this.options.hideEffectOptions.afterFinish){var d=this.options.hideEffectOptions.afterFinish;this.options.hideEffectOptions.afterFinish=function(){d();b()}}else{this.options.hideEffectOptions.afterFinish=function(){b()}}}Windows.updateFocusedWindow();this.doNotNotifyHide=true;this.hide();this.doNotNotifyHide=false;this._notify(\"onClose\")}},minimize:function(){if(this.resizing){return}var b=$(this.getId()+\"_row2\");if(!this.minimized){this.minimized=true;var f=b.getDimensions().height;this.r2Height=f;var e=this.element.getHeight()-f;if(this.useLeft&&this.useTop&&Window.hasEffectLib&&Effect.ResizeWindow){new Effect.ResizeWindow(this,null,null,null,this.height-f,{duration:Window.resizeEffectDuration})}else{this.height-=f;this.element.setStyle({height:e+\"px\"});b.hide()}if(!this.useTop){var d=parseFloat(this.element.getStyle(\"bottom\"));this.element.setStyle({bottom:(d+f)+\"px\"})}}else{this.minimized=false;var f=this.r2Height;this.r2Height=null;if(this.useLeft&&this.useTop&&Window.hasEffectLib&&Effect.ResizeWindow){new Effect.ResizeWindow(this,null,null,null,this.height+f,{duration:Window.resizeEffectDuration})}else{var e=this.element.getHeight()+f;this.height+=f;this.element.setStyle({height:e+\"px\"});b.show()}if(!this.useTop){var d=parseFloat(this.element.getStyle(\"bottom\"));this.element.setStyle({bottom:(d-f)+\"px\"})}this.toFront()}this._notify(\"onMinimize\");this._saveCookie()},maximize:function(){if(this.isMinimized()||this.resizing){return}if(Prototype.Browser.IE&&this.heightN==0){this._getWindowBorderSize()}if(this.storedLocation!=null){this._restoreLocation();if(this.iefix){this.iefix.hide()}}else{this._storeLocation();Windows.unsetOverflow(this);var l=WindowUtilities.getWindowScroll(this.options.parent);var d=WindowUtilities.getPageSize(this.options.parent);var h=l.left;var g=l.top;if(this.options.parent!=document.body){l={top:0,left:0,bottom:0,right:0};var f=this.options.parent.getDimensions();d.windowWidth=f.width;d.windowHeight=f.height;g=0;h=0}if(this.constraint){d.windowWidth-=Math.max(0,this.constraintPad.left)+Math.max(0,this.constraintPad.right);d.windowHeight-=Math.max(0,this.constraintPad.top)+Math.max(0,this.constraintPad.bottom);h+=Math.max(0,this.constraintPad.left);g+=Math.max(0,this.constraintPad.top)}var e=d.windowWidth-this.widthW-this.widthE;var b=d.windowHeight-this.heightN-this.heightS;if(this.useLeft&&this.useTop&&Window.hasEffectLib&&Effect.ResizeWindow){new Effect.ResizeWindow(this,g,h,e,b,{duration:Window.resizeEffectDuration})}else{this.setSize(e,b);this.element.setStyle(this.useLeft?{left:h}:{right:h});this.element.setStyle(this.useTop?{top:g}:{bottom:g})}this.toFront();if(this.iefix){this._fixIEOverlapping()}}this._notify(\"onMaximize\");this._saveCookie()},isMinimized:function(){return this.minimized},isMaximized:function(){return(this.storedLocation!=null)},setOpacity:function(b){if(Element.setOpacity){Element.setOpacity(this.element,b)}},setZIndex:function(b){this.element.setStyle({zIndex:b});Windows.updateZindex(b,this)},setTitle:function(b){if(!b||b==\"\"){b=\"&nbsp;\"}Element.update(this.element.id+\"_top\",b)},getTitle:function(){return $(this.element.id+\"_top\").innerHTML},setStatusBar:function(d){var b=$(this.getId()+\"_bottom\");if(typeof(d)==\"object\"){if(this.bottombar.firstChild){this.bottombar.replaceChild(d,this.bottombar.firstChild)}else{this.bottombar.appendChild(d)}}else{this.bottombar.innerHTML=d}},_checkIEOverlapping:function(){if(!this.iefix&&(navigator.appVersion.indexOf(\"MSIE\")>0)&&(navigator.userAgent.indexOf(\"Opera\")<0)&&(this.element.getStyle(\"position\")==\"absolute\")){new Insertion.After(this.element.id,'<iframe id=\"'+this.element.id+'_iefix\" style=\"display:none;position:absolute;filter:progid:DXImageTransform.Microsoft.Alpha(opacity=0);\" src=\"javascript:false;\" frameborder=\"0\" scrolling=\"no\"></iframe>');this.iefix=$(this.element.id+\"_iefix\")}if(this.iefix){setTimeout(this._fixIEOverlapping.bind(this),50)}},_fixIEOverlapping:function(){Position.clone(this.element,this.iefix);this.iefix.style.zIndex=this.element.style.zIndex-1;this.iefix.show()},_keyUp:function(b){if(27==b.keyCode&&this.options.closeOnEsc){this.close()}},_getWindowBorderSize:function(d){var e=this._createHiddenDiv(this.options.className+\"_n\");this.heightN=Element.getDimensions(e).height;e.parentNode.removeChild(e);var e=this._createHiddenDiv(this.options.className+\"_s\");this.heightS=Element.getDimensions(e).height;e.parentNode.removeChild(e);var e=this._createHiddenDiv(this.options.className+\"_e\");this.widthE=Element.getDimensions(e).width;e.parentNode.removeChild(e);var e=this._createHiddenDiv(this.options.className+\"_w\");this.widthW=Element.getDimensions(e).width;e.parentNode.removeChild(e);var e=document.createElement(\"div\");e.className=\"overlay_\"+this.options.className;document.body.appendChild(e);var b=this;setTimeout(function(){b.overlayOpacity=($(e).getStyle(\"opacity\"));e.parentNode.removeChild(e)},10);if(Prototype.Browser.IE){this.heightS=$(this.getId()+\"_row3\").getDimensions().height;this.heightN=$(this.getId()+\"_row1\").getDimensions().height}if(Prototype.Browser.WebKit&&Prototype.Browser.WebKitVersion<420){this.setSize(this.width,this.height)}if(this.doMaximize){this.maximize()}if(this.doMinimize){this.minimize()}},_createHiddenDiv:function(d){var b=document.body;var e=document.createElement(\"div\");e.setAttribute(\"id\",this.element.id+\"_tmp\");e.className=d;e.style.display=\"none\";e.innerHTML=\"\";b.insertBefore(e,b.firstChild);return e},_storeLocation:function(){if(this.storedLocation==null){this.storedLocation={useTop:this.useTop,useLeft:this.useLeft,top:this.element.getStyle(\"top\"),bottom:this.element.getStyle(\"bottom\"),left:this.element.getStyle(\"left\"),right:this.element.getStyle(\"right\"),width:this.width,height:this.height}}},_restoreLocation:function(){if(this.storedLocation!=null){this.useLeft=this.storedLocation.useLeft;this.useTop=this.storedLocation.useTop;if(this.useLeft&&this.useTop&&Window.hasEffectLib&&Effect.ResizeWindow){new Effect.ResizeWindow(this,this.storedLocation.top,this.storedLocation.left,this.storedLocation.width,this.storedLocation.height,{duration:Window.resizeEffectDuration})}else{this.element.setStyle(this.useLeft?{left:this.storedLocation.left}:{right:this.storedLocation.right});this.element.setStyle(this.useTop?{top:this.storedLocation.top}:{bottom:this.storedLocation.bottom});this.setSize(this.storedLocation.width,this.storedLocation.height)}Windows.resetOverflow();this._removeStoreLocation()}},_removeStoreLocation:function(){this.storedLocation=null},_saveCookie:function(){if(this.cookie){var b=\"\";if(this.useLeft){b+=\"l:\"+(this.storedLocation?this.storedLocation.left:this.element.getStyle(\"left\"))}else{b+=\"r:\"+(this.storedLocation?this.storedLocation.right:this.element.getStyle(\"right\"))}if(this.useTop){b+=\",t:\"+(this.storedLocation?this.storedLocation.top:this.element.getStyle(\"top\"))}else{b+=\",b:\"+(this.storedLocation?this.storedLocation.bottom:this.element.getStyle(\"bottom\"))}b+=\",\"+(this.storedLocation?this.storedLocation.width:this.width);b+=\",\"+(this.storedLocation?this.storedLocation.height:this.height);b+=\",\"+this.isMinimized();b+=\",\"+this.isMaximized();WindowUtilities.setCookie(b,this.cookie)}},_createWiredElement:function(){if(!this.wiredElement){if(Prototype.Browser.IE){this._getWindowBorderSize()}var d=document.createElement(\"div\");d.className=\"wired_frame \"+this.options.className+\"_wired_frame\";d.style.position=\"absolute\";this.options.parent.insertBefore(d,this.options.parent.firstChild);this.wiredElement=$(d)}if(this.useLeft){this.wiredElement.setStyle({left:this.element.getStyle(\"left\")})}else{this.wiredElement.setStyle({right:this.element.getStyle(\"right\")})}if(this.useTop){this.wiredElement.setStyle({top:this.element.getStyle(\"top\")})}else{this.wiredElement.setStyle({bottom:this.element.getStyle(\"bottom\")})}var b=this.element.getDimensions();this.wiredElement.setStyle({width:b.width+\"px\",height:b.height+\"px\"});this.wiredElement.setStyle({zIndex:Windows.maxZIndex+30});return this.wiredElement},_hideWiredElement:function(){if(!this.wiredElement||!this.currentDrag){return}if(this.currentDrag==this.element){this.currentDrag=null}else{if(this.useLeft){this.element.setStyle({left:this.currentDrag.getStyle(\"left\")})}else{this.element.setStyle({right:this.currentDrag.getStyle(\"right\")})}if(this.useTop){this.element.setStyle({top:this.currentDrag.getStyle(\"top\")})}else{this.element.setStyle({bottom:this.currentDrag.getStyle(\"bottom\")})}this.currentDrag.hide();this.currentDrag=null;if(this.doResize){this.setSize(this.width,this.height)}}},_notify:function(b){if(this.options[b]){this.options[b](this)}else{Windows.notify(b,this)}}};var Windows={windows:[],modalWindows:[],observers:[],focusedWindow:null,maxZIndex:0,overlayShowEffectOptions:{duration:0.5},overlayHideEffectOptions:{duration:0.5},addObserver:function(b){this.removeObserver(b);this.observers.push(b)},removeObserver:function(b){this.observers=this.observers.reject(function(d){return d==b})},notify:function(b,d){this.observers.each(function(e){if(e[b]){e[b](b,d)}})},getWindow:function(b){return this.windows.detect(function(e){return e.getId()==b})},getFocusedWindow:function(){return this.focusedWindow},updateFocusedWindow:function(){this.focusedWindow=this.windows.length>=2?this.windows[this.windows.length-2]:null},register:function(b){this.windows.push(b)},addModalWindow:function(b){if(this.modalWindows.length==0){WindowUtilities.disableScreen(b.options.className,\"overlay_modal\",b.overlayOpacity,b.getId(),b.options.parent)}else{if(Window.keepMultiModalWindow){$(\"overlay_modal\").style.zIndex=Windows.maxZIndex+1;Windows.maxZIndex+=1;WindowUtilities._hideSelect(this.modalWindows.last().getId())}else{this.modalWindows.last().element.hide()}WindowUtilities._showSelect(b.getId())}this.modalWindows.push(b)},removeModalWindow:function(b){this.modalWindows.pop();if(this.modalWindows.length==0){WindowUtilities.enableScreen()}else{if(Window.keepMultiModalWindow){this.modalWindows.last().toFront();WindowUtilities._showSelect(this.modalWindows.last().getId())}else{this.modalWindows.last().element.show()}}},register:function(b){this.windows.push(b)},unregister:function(b){this.windows=this.windows.reject(function(e){return e==b})},closeAll:function(){this.windows.each(function(b){Windows.close(b.getId())})},closeAllModalWindows:function(){WindowUtilities.enableScreen();this.modalWindows.each(function(b){if(b){b.close()}})},minimize:function(e,b){var d=this.getWindow(e);if(d&&d.visible){d.minimize()}Event.stop(b)},maximize:function(e,b){var d=this.getWindow(e);if(d&&d.visible){d.maximize()}Event.stop(b)},close:function(e,b){var d=this.getWindow(e);if(d){d.close()}if(b){Event.stop(b)}},blur:function(d){var b=this.getWindow(d);if(!b){return}if(b.options.blurClassName){b.changeClassName(b.options.blurClassName)}if(this.focusedWindow==b){this.focusedWindow=null}b._notify(\"onBlur\")},focus:function(d){var b=this.getWindow(d);if(!b){return}if(this.focusedWindow){this.blur(this.focusedWindow.getId())}if(b.options.focusClassName){b.changeClassName(b.options.focusClassName)}this.focusedWindow=b;b._notify(\"onFocus\")},unsetOverflow:function(b){this.windows.each(function(e){e.oldOverflow=e.getContent().getStyle(\"overflow\")||\"auto\";e.getContent().setStyle({overflow:\"hidden\"})});if(b&&b.oldOverflow){b.getContent().setStyle({overflow:b.oldOverflow})}},resetOverflow:function(){this.windows.each(function(b){if(b.oldOverflow){b.getContent().setStyle({overflow:b.oldOverflow})}})},updateZindex:function(b,d){if(b>this.maxZIndex){this.maxZIndex=b;if(this.focusedWindow){this.blur(this.focusedWindow.getId())}}this.focusedWindow=d;if(this.focusedWindow){this.focus(this.focusedWindow.getId())}}};var Dialog={dialogId:null,onCompleteFunc:null,callFunc:null,parameters:null,confirm:function(f,e){if(f&&typeof f!=\"string\"){Dialog._runAjaxRequest(f,e,Dialog.confirm);return}f=f||\"\";e=e||{};var h=e.okLabel?e.okLabel:\"Ok\";var b=e.cancelLabel?e.cancelLabel:\"Cancel\";e=Object.extend(e,e.windowParameters||{});e.windowParameters=e.windowParameters||{};e.className=e.className||\"alert\";var d=\"class ='\"+(e.buttonClass?e.buttonClass+\" \":\"\")+\" ok_button'\";var g=\"class ='\"+(e.buttonClass?e.buttonClass+\" \":\"\")+\" cancel_button'\";var f=\"      <div class='\"+e.className+\"_message'>\"+f+\"</div>        <div class='\"+e.className+\"_buttons'>          <button type='button' title='\"+h+\"' onclick='Dialog.okCallback()' \"+d+\"><span><span><span>\"+h+\"</span></span></span></button>          <button type='button' title='\"+b+\"' onclick='Dialog.cancelCallback()' \"+g+\"><span><span><span>\"+b+\"</span></span></span></button>        </div>    \";return this._openDialog(f,e)},alert:function(e,d){if(e&&typeof e!=\"string\"){Dialog._runAjaxRequest(e,d,Dialog.alert);return}e=e||\"\";d=d||{};var f=d.okLabel?d.okLabel:\"Ok\";d=Object.extend(d,d.windowParameters||{});d.windowParameters=d.windowParameters||{};d.className=d.className||\"alert\";var b=\"class ='\"+(d.buttonClass?d.buttonClass+\" \":\"\")+\" ok_button'\";var e=\"      <div class='\"+d.className+\"_message'>\"+e+\"</div>        <div class='\"+d.className+\"_buttons'>          <button type='button' title='\"+f+\"' onclick='Dialog.okCallback()' \"+b+\"><span><span><span>\"+f+\"</span></span></span></button>        </div>\";return this._openDialog(e,d)},info:function(d,b){if(d&&typeof d!=\"string\"){Dialog._runAjaxRequest(d,b,Dialog.info);return}d=d||\"\";b=b||{};b=Object.extend(b,b.windowParameters||{});b.windowParameters=b.windowParameters||{};b.className=b.className||\"alert\";var d=\"<div id='modal_dialog_message' class='\"+b.className+\"_message'>\"+d+\"</div>\";if(b.showProgress){d+=\"<div id='modal_dialog_progress' class='\"+b.className+\"_progress'>  </div>\"}b.ok=null;b.cancel=null;return this._openDialog(d,b)},setInfoMessage:function(b){$(\"modal_dialog_message\").update(b)},closeInfo:function(){Windows.close(this.dialogId)},_openDialog:function(g,f){var e=f.className;if(!f.height&&!f.width){f.width=WindowUtilities.getPageSize(f.options.parent||document.body).pageWidth/2}if(f.id){this.dialogId=f.id}else{var d=new Date();this.dialogId=\"modal_dialog_\"+d.getTime();f.id=this.dialogId}if(!f.height||!f.width){var b=WindowUtilities._computeSize(g,this.dialogId,f.width,f.height,5,e);if(f.height){f.width=b+5}else{f.height=b+5}}f.effectOptions=f.effectOptions;f.resizable=f.resizable||false;f.minimizable=f.minimizable||false;f.maximizable=f.maximizable||false;f.draggable=f.draggable||false;f.closable=f.closable||false;var h=new Window(f);h.getContent().innerHTML=g;h.showCenter(true,f.top,f.left);h.setDestroyOnClose();h.cancelCallback=f.onCancel||f.cancel;h.okCallback=f.onOk||f.ok;return h},_getAjaxContent:function(b){Dialog.callFunc(b.responseText,Dialog.parameters)},_runAjaxRequest:function(e,d,b){if(e.options==null){e.options={}}Dialog.onCompleteFunc=e.options.onComplete;Dialog.parameters=d;Dialog.callFunc=b;e.options.onComplete=Dialog._getAjaxContent;new Ajax.Request(e.url,e.options)},okCallback:function(){var b=Windows.focusedWindow;if(!b.okCallback||b.okCallback(b)){$$(\"#\"+b.getId()+\" input\").each(function(d){d.onclick=null});b.close()}},cancelCallback:function(){var b=Windows.focusedWindow;$$(\"#\"+b.getId()+\" input\").each(function(d){d.onclick=null});b.close();if(b.cancelCallback){b.cancelCallback(b)}}};if(Prototype.Browser.WebKit){var array=navigator.userAgent.match(new RegExp(/AppleWebKit\\/([\\d\\.\\+]*)/));Prototype.Browser.WebKitVersion=parseFloat(array[1])}var WindowUtilities={getWindowScroll:function(parent){var T,L,W,H;parent=parent||document.body;if(parent!=document.body){T=parent.scrollTop;L=parent.scrollLeft;W=parent.scrollWidth;H=parent.scrollHeight}else{var w=window;with(w.document){if(w.document.documentElement&&documentElement.scrollTop){T=documentElement.scrollTop;L=documentElement.scrollLeft}else{if(w.document.body){T=body.scrollTop;L=body.scrollLeft}}if(w.innerWidth){W=w.innerWidth;H=w.innerHeight}else{if(w.document.documentElement&&documentElement.clientWidth){W=documentElement.clientWidth;H=documentElement.clientHeight}else{W=body.offsetWidth;H=body.offsetHeight}}}}return{top:T,left:L,width:W,height:H}},getPageSize:function(f){f=f||document.body;var e,l;var g,d;if(f!=document.body){e=f.getWidth();l=f.getHeight();d=f.scrollWidth;g=f.scrollHeight}else{var h,b;if(window.innerHeight&&window.scrollMaxY){h=document.body.scrollWidth;b=window.innerHeight+window.scrollMaxY}else{if(document.body.scrollHeight>document.body.offsetHeight){h=document.body.scrollWidth;b=document.body.scrollHeight}else{h=document.body.offsetWidth;b=document.body.offsetHeight}}if(self.innerHeight){e=document.documentElement.clientWidth;l=self.innerHeight}else{if(document.documentElement&&document.documentElement.clientHeight){e=document.documentElement.clientWidth;l=document.documentElement.clientHeight}else{if(document.body){e=document.body.clientWidth;l=document.body.clientHeight}}}if(b<l){g=l}else{g=b}if(h<e){d=e}else{d=h}}return{pageWidth:d,pageHeight:g,windowWidth:e,windowHeight:l}},disableScreen:function(e,b,f,g,d){WindowUtilities.initLightbox(b,e,function(){this._disableScreen(e,b,f,g)}.bind(this),d||document.body)},_disableScreen:function(e,d,g,h){var f=$(d);var b=WindowUtilities.getPageSize(f.parentNode);if(h&&Prototype.Browser.IE){WindowUtilities._hideSelect();WindowUtilities._showSelect(h)}f.style.height=(b.pageHeight+\"px\");f.style.display=\"none\";if(d==\"overlay_modal\"&&Window.hasEffectLib&&Windows.overlayShowEffectOptions){f.overlayOpacity=g;new Effect.Appear(f,Object.extend({from:0,to:g},Windows.overlayShowEffectOptions))}else{f.style.display=\"block\"}},enableScreen:function(d){d=d||\"overlay_modal\";var b=$(d);if(b){if(d==\"overlay_modal\"&&Window.hasEffectLib&&Windows.overlayHideEffectOptions){new Effect.Fade(b,Object.extend({from:b.overlayOpacity,to:0},Windows.overlayHideEffectOptions))}else{b.style.display=\"none\";b.parentNode.removeChild(b)}if(d!=\"__invisible__\"){WindowUtilities._showSelect()}}},_hideSelect:function(b){if(Prototype.Browser.IE){b=b==null?\"\":\"#\"+b+\" \";$$(b+\"select\").each(function(d){if(!WindowUtilities.isDefined(d.oldVisibility)){d.oldVisibility=d.style.visibility?d.style.visibility:\"visible\";d.style.visibility=\"hidden\"}})}},_showSelect:function(b){if(Prototype.Browser.IE){b=b==null?\"\":\"#\"+b+\" \";$$(b+\"select\").each(function(d){if(WindowUtilities.isDefined(d.oldVisibility)){try{d.style.visibility=d.oldVisibility}catch(f){d.style.visibility=\"visible\"}d.oldVisibility=null}else{if(d.style.visibility){d.style.visibility=\"visible\"}}})}},isDefined:function(b){return typeof(b)!=\"undefined\"&&b!=null},initLightbox:function(g,e,b,d){if($(g)){Element.setStyle(g,{zIndex:Windows.maxZIndex+1});Windows.maxZIndex++;b()}else{var f=document.createElement(\"div\");f.setAttribute(\"id\",g);f.className=\"overlay_\"+e;f.style.display=\"none\";f.style.position=\"absolute\";f.style.top=\"0\";f.style.left=\"0\";f.style.zIndex=Windows.maxZIndex+1;Windows.maxZIndex++;f.style.width=\"100%\";d.insertBefore(f,d.firstChild);if(Prototype.Browser.WebKit&&g==\"overlay_modal\"){setTimeout(function(){b()},10)}else{b()}}},setCookie:function(d,b){document.cookie=b[0]+\"=\"+escape(d)+((b[1])?\"; expires=\"+b[1].toUTCString():\"\")+((b[2])?\"; path=\"+b[2]:\"\")+((b[3])?\"; domain=\"+b[3]:\"\")+((b[4])?\"; secure\":\"\")},getCookie:function(e){var d=document.cookie;var g=e+\"=\";var f=d.indexOf(\"; \"+g);if(f==-1){f=d.indexOf(g);if(f!=0){return null}}else{f+=2}var b=document.cookie.indexOf(\";\",f);if(b==-1){b=d.length}return unescape(d.substring(f+g.length,b))},_computeSize:function(g,b,d,l,f,h){var o=document.body;var e=document.createElement(\"div\");e.setAttribute(\"id\",b);e.className=h+\"_content\";if(l){e.style.height=l+\"px\"}else{e.style.width=d+\"px\"}e.style.position=\"absolute\";e.style.top=\"0\";e.style.left=\"0\";e.style.display=\"none\";e.innerHTML=g;o.insertBefore(e,o.firstChild);var n;if(l){n=$(e).getDimensions().width+f}else{n=$(e).getDimensions().height+f}o.removeChild(e);return n}};var Builder={NODEMAP:{AREA:\"map\",CAPTION:\"table\",COL:\"table\",COLGROUP:\"table\",LEGEND:\"fieldset\",OPTGROUP:\"select\",OPTION:\"select\",PARAM:\"object\",TBODY:\"table\",TD:\"table\",TFOOT:\"table\",TH:\"table\",THEAD:\"table\",TR:\"table\"},node:function(b){b=b.toUpperCase();var l=this.NODEMAP[b]||\"div\";var d=document.createElement(l);try{d.innerHTML=\"<\"+b+\"></\"+b+\">\"}catch(h){}var g=d.firstChild||null;if(g&&(g.tagName.toUpperCase()!=b)){g=g.getElementsByTagName(b)[0]}if(!g){g=document.createElement(b)}if(!g){return}if(arguments[1]){if(this._isStringOrNumber(arguments[1])||(arguments[1] instanceof Array)||arguments[1].tagName){this._children(g,arguments[1])}else{var f=this._attributes(arguments[1]);if(f.length){try{d.innerHTML=\"<\"+b+\" \"+f+\"></\"+b+\">\"}catch(h){}g=d.firstChild||null;if(!g){g=document.createElement(b);for(attr in arguments[1]){g[attr==\"class\"?\"className\":attr]=arguments[1][attr]}}if(g.tagName.toUpperCase()!=b){g=d.getElementsByTagName(b)[0]}}}}if(arguments[2]){this._children(g,arguments[2])}return $(g)},_text:function(b){return document.createTextNode(b)},ATTR_MAP:{className:\"class\",htmlFor:\"for\"},_attributes:function(b){var d=[];for(attribute in b){d.push((attribute in this.ATTR_MAP?this.ATTR_MAP[attribute]:attribute)+'=\"'+b[attribute].toString().escapeHTML().gsub(/\"/,\"&quot;\")+'\"')}return d.join(\" \")},_children:function(d,b){if(b.tagName){d.appendChild(b);return}if(typeof b==\"object\"){b.flatten().each(function(f){if(typeof f==\"object\"){d.appendChild(f)}else{if(Builder._isStringOrNumber(f)){d.appendChild(Builder._text(f))}}})}else{if(Builder._isStringOrNumber(b)){d.appendChild(Builder._text(b))}}},_isStringOrNumber:function(b){return(typeof b==\"string\"||typeof b==\"number\")},build:function(d){var b=this.node(\"div\");$(b).update(d.strip());return b.down()},dump:function(d){if(typeof d!=\"object\"&&typeof d!=\"function\"){d=window}var b=(\"A ABBR ACRONYM ADDRESS APPLET AREA B BASE BASEFONT BDO BIG BLOCKQUOTE BODY BR BUTTON CAPTION CENTER CITE CODE COL COLGROUP DD DEL DFN DIR DIV DL DT EM FIELDSET FONT FORM FRAME FRAMESET H1 H2 H3 H4 H5 H6 HEAD HR HTML I IFRAME IMG INPUT INS ISINDEX KBD LABEL LEGEND LI LINK MAP MENU META NOFRAMES NOSCRIPT OBJECT OL OPTGROUP OPTION P PARAM PRE Q S SAMP SCRIPT SELECT SMALL SPAN STRIKE STRONG STYLE SUB SUP TABLE TBODY TD TEXTAREA TFOOT TH THEAD TITLE TR TT U UL VAR\").split(/\\s+/);b.each(function(e){d[e]=function(){return Builder.node.apply(Builder,[e].concat($A(arguments)))}})}};String.prototype.parseColor=function(){var b=\"#\";if(this.slice(0,4)==\"rgb(\"){var e=this.slice(4,this.length-1).split(\",\");var d=0;do{b+=parseInt(e[d]).toColorPart()}while(++d<3)}else{if(this.slice(0,1)==\"#\"){if(this.length==4){for(var d=1;d<4;d++){b+=(this.charAt(d)+this.charAt(d)).toLowerCase()}}if(this.length==7){b=this.toLowerCase()}}}return(b.length==7?b:(arguments[0]||this))};Element.collectTextNodes=function(b){return $A($(b).childNodes).collect(function(d){return(d.nodeType==3?d.nodeValue:(d.hasChildNodes()?Element.collectTextNodes(d):\"\"))}).flatten().join(\"\")};Element.collectTextNodesIgnoreClass=function(b,d){return $A($(b).childNodes).collect(function(e){return(e.nodeType==3?e.nodeValue:((e.hasChildNodes()&&!Element.hasClassName(e,d))?Element.collectTextNodesIgnoreClass(e,d):\"\"))}).flatten().join(\"\")};Element.setContentZoom=function(b,d){b=$(b);b.setStyle({fontSize:(d/100)+\"em\"});if(Prototype.Browser.WebKit){window.scrollBy(0,0)}return b};Element.getInlineOpacity=function(b){return $(b).style.opacity||\"\"};Element.forceRerendering=function(b){try{b=$(b);var f=document.createTextNode(\" \");b.appendChild(f);b.removeChild(f)}catch(d){}};var Effect={_elementDoesNotExistError:{name:\"ElementDoesNotExistError\",message:\"The specified DOM element does not exist, but is required for this effect to operate\"},Transitions:{linear:Prototype.K,sinoidal:function(b){return(-Math.cos(b*Math.PI)/2)+0.5},reverse:function(b){return 1-b},flicker:function(b){var b=((-Math.cos(b*Math.PI)/4)+0.75)+Math.random()/4;return b>1?1:b},wobble:function(b){return(-Math.cos(b*Math.PI*(9*b))/2)+0.5},pulse:function(d,b){return(-Math.cos((d*((b||5)-0.5)*2)*Math.PI)/2)+0.5},spring:function(b){return 1-(Math.cos(b*4.5*Math.PI)*Math.exp(-b*6))},none:function(b){return 0},full:function(b){return 1}},DefaultOptions:{duration:1,fps:100,sync:false,from:0,to:1,delay:0,queue:\"parallel\"},tagifyText:function(b){var d=\"position:relative\";if(Prototype.Browser.IE){d+=\";zoom:1\"}b=$(b);$A(b.childNodes).each(function(e){if(e.nodeType==3){e.nodeValue.toArray().each(function(f){b.insertBefore(new Element(\"span\",{style:d}).update(f==\" \"?String.fromCharCode(160):f),e)});Element.remove(e)}})},multiple:function(d,e){var g;if(((typeof d==\"object\")||Object.isFunction(d))&&(d.length)){g=d}else{g=$(d).childNodes}var b=Object.extend({speed:0.1,delay:0},arguments[2]||{});var f=b.delay;$A(g).each(function(l,h){new e(l,Object.extend(b,{delay:h*b.speed+f}))})},PAIRS:{slide:[\"SlideDown\",\"SlideUp\"],blind:[\"BlindDown\",\"BlindUp\"],appear:[\"Appear\",\"Fade\"]},toggle:function(d,e){d=$(d);e=(e||\"appear\").toLowerCase();var b=Object.extend({queue:{position:\"end\",scope:(d.id||\"global\"),limit:1}},arguments[2]||{});Effect[d.visible()?Effect.PAIRS[e][1]:Effect.PAIRS[e][0]](d,b)}};Effect.DefaultOptions.transition=Effect.Transitions.sinoidal;Effect.ScopedQueue=Class.create(Enumerable,{initialize:function(){this.effects=[];this.interval=null},_each:function(b){this.effects._each(b)},add:function(d){var e=new Date().getTime();var b=Object.isString(d.options.queue)?d.options.queue:d.options.queue.position;switch(b){case\"front\":this.effects.findAll(function(f){return f.state==\"idle\"}).each(function(f){f.startOn+=d.finishOn;f.finishOn+=d.finishOn});break;case\"with-last\":e=this.effects.pluck(\"startOn\").max()||e;break;case\"end\":e=this.effects.pluck(\"finishOn\").max()||e;break}d.startOn+=e;d.finishOn+=e;if(!d.options.queue.limit||(this.effects.length<d.options.queue.limit)){this.effects.push(d)}if(!this.interval){this.interval=setInterval(this.loop.bind(this),15)}},remove:function(b){this.effects=this.effects.reject(function(d){return d==b});if(this.effects.length==0){clearInterval(this.interval);this.interval=null}},loop:function(){var e=new Date().getTime();for(var d=0,b=this.effects.length;d<b;d++){this.effects[d]&&this.effects[d].loop(e)}}});Effect.Queues={instances:$H(),get:function(b){if(!Object.isString(b)){return b}return this.instances.get(b)||this.instances.set(b,new Effect.ScopedQueue())}};Effect.Queue=Effect.Queues.get(\"global\");Effect.Base=Class.create({position:null,start:function(b){function d(f,e){return((f[e+\"Internal\"]?\"this.options.\"+e+\"Internal(this);\":\"\")+(f[e]?\"this.options.\"+e+\"(this);\":\"\"))}if(b&&b.transition===false){b.transition=Effect.Transitions.linear}this.options=Object.extend(Object.extend({},Effect.DefaultOptions),b||{});this.currentFrame=0;this.state=\"idle\";this.startOn=this.options.delay*1000;this.finishOn=this.startOn+(this.options.duration*1000);this.fromToDelta=this.options.to-this.options.from;this.totalTime=this.finishOn-this.startOn;this.totalFrames=this.options.fps*this.options.duration;this.render=(function(){function e(g,f){if(g.options[f+\"Internal\"]){g.options[f+\"Internal\"](g)}if(g.options[f]){g.options[f](g)}}return function(f){if(this.state===\"idle\"){this.state=\"running\";e(this,\"beforeSetup\");if(this.setup){this.setup()}e(this,\"afterSetup\")}if(this.state===\"running\"){f=(this.options.transition(f)*this.fromToDelta)+this.options.from;this.position=f;e(this,\"beforeUpdate\");if(this.update){this.update(f)}e(this,\"afterUpdate\")}}})();this.event(\"beforeStart\");if(!this.options.sync){Effect.Queues.get(Object.isString(this.options.queue)?\"global\":this.options.queue.scope).add(this)}},loop:function(e){if(e>=this.startOn){if(e>=this.finishOn){this.render(1);this.cancel();this.event(\"beforeFinish\");if(this.finish){this.finish()}this.event(\"afterFinish\");return}var d=(e-this.startOn)/this.totalTime,b=(d*this.totalFrames).round();if(b>this.currentFrame){this.render(d);this.currentFrame=b}}},cancel:function(){if(!this.options.sync){Effect.Queues.get(Object.isString(this.options.queue)?\"global\":this.options.queue.scope).remove(this)}this.state=\"finished\"},event:function(b){if(this.options[b+\"Internal\"]){this.options[b+\"Internal\"](this)}if(this.options[b]){this.options[b](this)}},inspect:function(){var b=$H();for(property in this){if(!Object.isFunction(this[property])){b.set(property,this[property])}}return\"#<Effect:\"+b.inspect()+\",options:\"+$H(this.options).inspect()+\">\"}});Effect.Parallel=Class.create(Effect.Base,{initialize:function(b){this.effects=b||[];this.start(arguments[1])},update:function(b){this.effects.invoke(\"render\",b)},finish:function(b){this.effects.each(function(d){d.render(1);d.cancel();d.event(\"beforeFinish\");if(d.finish){d.finish(b)}d.event(\"afterFinish\")})}});Effect.Tween=Class.create(Effect.Base,{initialize:function(e,h,g){e=Object.isString(e)?$(e):e;var d=$A(arguments),f=d.last(),b=d.length==5?d[3]:null;this.method=Object.isFunction(f)?f.bind(e):Object.isFunction(e[f])?e[f].bind(e):function(l){e[f]=l};this.start(Object.extend({from:h,to:g},b||{}))},update:function(b){this.method(b)}});Effect.Event=Class.create(Effect.Base,{initialize:function(){this.start(Object.extend({duration:0},arguments[0]||{}))},update:Prototype.emptyFunction});Effect.Opacity=Class.create(Effect.Base,{initialize:function(d){this.element=$(d);if(!this.element){throw (Effect._elementDoesNotExistError)}if(Prototype.Browser.IE&&(!this.element.currentStyle.hasLayout)){this.element.setStyle({zoom:1})}var b=Object.extend({from:this.element.getOpacity()||0,to:1},arguments[1]||{});this.start(b)},update:function(b){this.element.setOpacity(b)}});Effect.Move=Class.create(Effect.Base,{initialize:function(d){this.element=$(d);if(!this.element){throw (Effect._elementDoesNotExistError)}var b=Object.extend({x:0,y:0,mode:\"relative\"},arguments[1]||{});this.start(b)},setup:function(){this.element.makePositioned();this.originalLeft=parseFloat(this.element.getStyle(\"left\")||\"0\");this.originalTop=parseFloat(this.element.getStyle(\"top\")||\"0\");if(this.options.mode==\"absolute\"){this.options.x=this.options.x-this.originalLeft;this.options.y=this.options.y-this.originalTop}},update:function(b){this.element.setStyle({left:(this.options.x*b+this.originalLeft).round()+\"px\",top:(this.options.y*b+this.originalTop).round()+\"px\"})}});Effect.MoveBy=function(d,b,e){return new Effect.Move(d,Object.extend({x:e,y:b},arguments[3]||{}))};Effect.Scale=Class.create(Effect.Base,{initialize:function(d,e){this.element=$(d);if(!this.element){throw (Effect._elementDoesNotExistError)}var b=Object.extend({scaleX:true,scaleY:true,scaleContent:true,scaleFromCenter:false,scaleMode:\"box\",scaleFrom:100,scaleTo:e},arguments[2]||{});this.start(b)},setup:function(){this.restoreAfterFinish=this.options.restoreAfterFinish||false;this.elementPositioning=this.element.getStyle(\"position\");this.originalStyle={};[\"top\",\"left\",\"width\",\"height\",\"fontSize\"].each(function(d){this.originalStyle[d]=this.element.style[d]}.bind(this));this.originalTop=this.element.offsetTop;this.originalLeft=this.element.offsetLeft;var b=this.element.getStyle(\"font-size\")||\"100%\";[\"em\",\"px\",\"%\",\"pt\"].each(function(d){if(b.indexOf(d)>0){this.fontSize=parseFloat(b);this.fontSizeType=d}}.bind(this));this.factor=(this.options.scaleTo-this.options.scaleFrom)/100;this.dims=null;if(this.options.scaleMode==\"box\"){this.dims=[this.element.offsetHeight,this.element.offsetWidth]}if(/^content/.test(this.options.scaleMode)){this.dims=[this.element.scrollHeight,this.element.scrollWidth]}if(!this.dims){this.dims=[this.options.scaleMode.originalHeight,this.options.scaleMode.originalWidth]}},update:function(b){var d=(this.options.scaleFrom/100)+(this.factor*b);if(this.options.scaleContent&&this.fontSize){this.element.setStyle({fontSize:this.fontSize*d+this.fontSizeType})}this.setDimensions(this.dims[0]*d,this.dims[1]*d)},finish:function(b){if(this.restoreAfterFinish){this.element.setStyle(this.originalStyle)}},setDimensions:function(b,g){var h={};if(this.options.scaleX){h.width=g.round()+\"px\"}if(this.options.scaleY){h.height=b.round()+\"px\"}if(this.options.scaleFromCenter){var f=(b-this.dims[0])/2;var e=(g-this.dims[1])/2;if(this.elementPositioning==\"absolute\"){if(this.options.scaleY){h.top=this.originalTop-f+\"px\"}if(this.options.scaleX){h.left=this.originalLeft-e+\"px\"}}else{if(this.options.scaleY){h.top=-f+\"px\"}if(this.options.scaleX){h.left=-e+\"px\"}}}this.element.setStyle(h)}});Effect.Highlight=Class.create(Effect.Base,{initialize:function(d){this.element=$(d);if(!this.element){throw (Effect._elementDoesNotExistError)}var b=Object.extend({startcolor:\"#ffff99\"},arguments[1]||{});this.start(b)},setup:function(){if(this.element.getStyle(\"display\")==\"none\"){this.cancel();return}this.oldStyle={};if(!this.options.keepBackgroundImage){this.oldStyle.backgroundImage=this.element.getStyle(\"background-image\");this.element.setStyle({backgroundImage:\"none\"})}if(!this.options.endcolor){this.options.endcolor=this.element.getStyle(\"background-color\").parseColor(\"#ffffff\")}if(!this.options.restorecolor){this.options.restorecolor=this.element.getStyle(\"background-color\")}this._base=$R(0,2).map(function(b){return parseInt(this.options.startcolor.slice(b*2+1,b*2+3),16)}.bind(this));this._delta=$R(0,2).map(function(b){return parseInt(this.options.endcolor.slice(b*2+1,b*2+3),16)-this._base[b]}.bind(this))},update:function(b){this.element.setStyle({backgroundColor:$R(0,2).inject(\"#\",function(d,e,f){return d+((this._base[f]+(this._delta[f]*b)).round().toColorPart())}.bind(this))})},finish:function(){this.element.setStyle(Object.extend(this.oldStyle,{backgroundColor:this.options.restorecolor}))}});Effect.ScrollTo=function(e){var d=arguments[1]||{},b=document.viewport.getScrollOffsets(),f=$(e).cumulativeOffset();if(d.offset){f[1]+=d.offset}return new Effect.Tween(null,b.top,f[1],d,function(g){scrollTo(b.left,g.round())})};Effect.Fade=function(e){e=$(e);var b=e.getInlineOpacity();var d=Object.extend({from:e.getOpacity()||1,to:0,afterFinishInternal:function(f){if(f.options.to!=0){return}f.element.hide().setStyle({opacity:b})}},arguments[1]||{});return new Effect.Opacity(e,d)};Effect.Appear=function(d){d=$(d);var b=Object.extend({from:(d.getStyle(\"display\")==\"none\"?0:d.getOpacity()||0),to:1,afterFinishInternal:function(e){e.element.forceRerendering()},beforeSetup:function(e){e.element.setOpacity(e.options.from).show()}},arguments[1]||{});return new Effect.Opacity(d,b)};Effect.Puff=function(d){d=$(d);var b={opacity:d.getInlineOpacity(),position:d.getStyle(\"position\"),top:d.style.top,left:d.style.left,width:d.style.width,height:d.style.height};return new Effect.Parallel([new Effect.Scale(d,200,{sync:true,scaleFromCenter:true,scaleContent:true,restoreAfterFinish:true}),new Effect.Opacity(d,{sync:true,to:0})],Object.extend({duration:1,beforeSetupInternal:function(e){Position.absolutize(e.effects[0].element)},afterFinishInternal:function(e){e.effects[0].element.hide().setStyle(b)}},arguments[1]||{}))};Effect.BlindUp=function(b){b=$(b);b.makeClipping();return new Effect.Scale(b,0,Object.extend({scaleContent:false,scaleX:false,restoreAfterFinish:true,afterFinishInternal:function(d){d.element.hide().undoClipping()}},arguments[1]||{}))};Effect.BlindDown=function(d){d=$(d);var b=d.getDimensions();return new Effect.Scale(d,100,Object.extend({scaleContent:false,scaleX:false,scaleFrom:0,scaleMode:{originalHeight:b.height,originalWidth:b.width},restoreAfterFinish:true,afterSetup:function(e){e.element.makeClipping().setStyle({height:\"0px\"}).show()},afterFinishInternal:function(e){e.element.undoClipping()}},arguments[1]||{}))};Effect.SwitchOff=function(d){d=$(d);var b=d.getInlineOpacity();return new Effect.Appear(d,Object.extend({duration:0.4,from:0,transition:Effect.Transitions.flicker,afterFinishInternal:function(e){new Effect.Scale(e.element,1,{duration:0.3,scaleFromCenter:true,scaleX:false,scaleContent:false,restoreAfterFinish:true,beforeSetup:function(f){f.element.makePositioned().makeClipping()},afterFinishInternal:function(f){f.element.hide().undoClipping().undoPositioned().setStyle({opacity:b})}})}},arguments[1]||{}))};Effect.DropOut=function(d){d=$(d);var b={top:d.getStyle(\"top\"),left:d.getStyle(\"left\"),opacity:d.getInlineOpacity()};return new Effect.Parallel([new Effect.Move(d,{x:0,y:100,sync:true}),new Effect.Opacity(d,{sync:true,to:0})],Object.extend({duration:0.5,beforeSetup:function(e){e.effects[0].element.makePositioned()},afterFinishInternal:function(e){e.effects[0].element.hide().undoPositioned().setStyle(b)}},arguments[1]||{}))};Effect.Shake=function(f){f=$(f);var d=Object.extend({distance:20,duration:0.5},arguments[1]||{});var g=parseFloat(d.distance);var e=parseFloat(d.duration)/10;var b={top:f.getStyle(\"top\"),left:f.getStyle(\"left\")};return new Effect.Move(f,{x:g,y:0,duration:e,afterFinishInternal:function(h){new Effect.Move(h.element,{x:-g*2,y:0,duration:e*2,afterFinishInternal:function(l){new Effect.Move(l.element,{x:g*2,y:0,duration:e*2,afterFinishInternal:function(n){new Effect.Move(n.element,{x:-g*2,y:0,duration:e*2,afterFinishInternal:function(o){new Effect.Move(o.element,{x:g*2,y:0,duration:e*2,afterFinishInternal:function(p){new Effect.Move(p.element,{x:-g,y:0,duration:e,afterFinishInternal:function(q){q.element.undoPositioned().setStyle(b)}})}})}})}})}})}})};Effect.SlideDown=function(e){e=$(e).cleanWhitespace();var b=e.down().getStyle(\"bottom\");var d=e.getDimensions();return new Effect.Scale(e,100,Object.extend({scaleContent:false,scaleX:false,scaleFrom:window.opera?0:1,scaleMode:{originalHeight:d.height,originalWidth:d.width},restoreAfterFinish:true,afterSetup:function(f){f.element.makePositioned();f.element.down().makePositioned();if(window.opera){f.element.setStyle({top:\"\"})}f.element.makeClipping().setStyle({height:\"0px\"}).show()},afterUpdateInternal:function(f){f.element.down().setStyle({bottom:(f.dims[0]-f.element.clientHeight)+\"px\"})},afterFinishInternal:function(f){f.element.undoClipping().undoPositioned();f.element.down().undoPositioned().setStyle({bottom:b})}},arguments[1]||{}))};Effect.SlideUp=function(e){e=$(e).cleanWhitespace();var b=e.down().getStyle(\"bottom\");var d=e.getDimensions();return new Effect.Scale(e,window.opera?0:1,Object.extend({scaleContent:false,scaleX:false,scaleMode:\"box\",scaleFrom:100,scaleMode:{originalHeight:d.height,originalWidth:d.width},restoreAfterFinish:true,afterSetup:function(f){f.element.makePositioned();f.element.down().makePositioned();if(window.opera){f.element.setStyle({top:\"\"})}f.element.makeClipping().show()},afterUpdateInternal:function(f){f.element.down().setStyle({bottom:(f.dims[0]-f.element.clientHeight)+\"px\"})},afterFinishInternal:function(f){f.element.hide().undoClipping().undoPositioned();f.element.down().undoPositioned().setStyle({bottom:b})}},arguments[1]||{}))};Effect.Squish=function(b){return new Effect.Scale(b,window.opera?1:0,{restoreAfterFinish:true,beforeSetup:function(d){d.element.makeClipping()},afterFinishInternal:function(d){d.element.hide().undoClipping()}})};Effect.Grow=function(e){e=$(e);var d=Object.extend({direction:\"center\",moveTransition:Effect.Transitions.sinoidal,scaleTransition:Effect.Transitions.sinoidal,opacityTransition:Effect.Transitions.full},arguments[1]||{});var b={top:e.style.top,left:e.style.left,height:e.style.height,width:e.style.width,opacity:e.getInlineOpacity()};var l=e.getDimensions();var n,h;var g,f;switch(d.direction){case\"top-left\":n=h=g=f=0;break;case\"top-right\":n=l.width;h=f=0;g=-l.width;break;case\"bottom-left\":n=g=0;h=l.height;f=-l.height;break;case\"bottom-right\":n=l.width;h=l.height;g=-l.width;f=-l.height;break;case\"center\":n=l.width/2;h=l.height/2;g=-l.width/2;f=-l.height/2;break}return new Effect.Move(e,{x:n,y:h,duration:0.01,beforeSetup:function(o){o.element.hide().makeClipping().makePositioned()},afterFinishInternal:function(o){new Effect.Parallel([new Effect.Opacity(o.element,{sync:true,to:1,from:0,transition:d.opacityTransition}),new Effect.Move(o.element,{x:g,y:f,sync:true,transition:d.moveTransition}),new Effect.Scale(o.element,100,{scaleMode:{originalHeight:l.height,originalWidth:l.width},sync:true,scaleFrom:window.opera?1:0,transition:d.scaleTransition,restoreAfterFinish:true})],Object.extend({beforeSetup:function(p){p.effects[0].element.setStyle({height:\"0px\"}).show()},afterFinishInternal:function(p){p.effects[0].element.undoClipping().undoPositioned().setStyle(b)}},d))}})};Effect.Shrink=function(e){e=$(e);var d=Object.extend({direction:\"center\",moveTransition:Effect.Transitions.sinoidal,scaleTransition:Effect.Transitions.sinoidal,opacityTransition:Effect.Transitions.none},arguments[1]||{});var b={top:e.style.top,left:e.style.left,height:e.style.height,width:e.style.width,opacity:e.getInlineOpacity()};var h=e.getDimensions();var g,f;switch(d.direction){case\"top-left\":g=f=0;break;case\"top-right\":g=h.width;f=0;break;case\"bottom-left\":g=0;f=h.height;break;case\"bottom-right\":g=h.width;f=h.height;break;case\"center\":g=h.width/2;f=h.height/2;break}return new Effect.Parallel([new Effect.Opacity(e,{sync:true,to:0,from:1,transition:d.opacityTransition}),new Effect.Scale(e,window.opera?1:0,{sync:true,transition:d.scaleTransition,restoreAfterFinish:true}),new Effect.Move(e,{x:g,y:f,sync:true,transition:d.moveTransition})],Object.extend({beforeStartInternal:function(l){l.effects[0].element.makePositioned().makeClipping()},afterFinishInternal:function(l){l.effects[0].element.hide().undoClipping().undoPositioned().setStyle(b)}},d))};Effect.Pulsate=function(e){e=$(e);var d=arguments[1]||{},b=e.getInlineOpacity(),g=d.transition||Effect.Transitions.linear,f=function(h){return 1-g((-Math.cos((h*(d.pulses||5)*2)*Math.PI)/2)+0.5)};return new Effect.Opacity(e,Object.extend(Object.extend({duration:2,from:0,afterFinishInternal:function(h){h.element.setStyle({opacity:b})}},d),{transition:f}))};Effect.Fold=function(d){d=$(d);var b={top:d.style.top,left:d.style.left,width:d.style.width,height:d.style.height};d.makeClipping();return new Effect.Scale(d,5,Object.extend({scaleContent:false,scaleX:false,afterFinishInternal:function(e){new Effect.Scale(d,1,{scaleContent:false,scaleY:false,afterFinishInternal:function(f){f.element.hide().undoClipping().setStyle(b)}})}},arguments[1]||{}))};Effect.Morph=Class.create(Effect.Base,{initialize:function(e){this.element=$(e);if(!this.element){throw (Effect._elementDoesNotExistError)}var b=Object.extend({style:{}},arguments[1]||{});if(!Object.isString(b.style)){this.style=$H(b.style)}else{if(b.style.include(\":\")){this.style=b.style.parseStyle()}else{this.element.addClassName(b.style);this.style=$H(this.element.getStyles());this.element.removeClassName(b.style);var d=this.element.getStyles();this.style=this.style.reject(function(f){return f.value==d[f.key]});b.afterFinishInternal=function(f){f.element.addClassName(f.options.style);f.transforms.each(function(g){f.element.style[g.style]=\"\"})}}}this.start(b)},setup:function(){function b(d){if(!d||[\"rgba(0, 0, 0, 0)\",\"transparent\"].include(d)){d=\"#ffffff\"}d=d.parseColor();return $R(0,2).map(function(e){return parseInt(d.slice(e*2+1,e*2+3),16)})}this.transforms=this.style.map(function(l){var h=l[0],g=l[1],f=null;if(g.parseColor(\"#zzzzzz\")!=\"#zzzzzz\"){g=g.parseColor();f=\"color\"}else{if(h==\"opacity\"){g=parseFloat(g);if(Prototype.Browser.IE&&(!this.element.currentStyle.hasLayout)){this.element.setStyle({zoom:1})}}else{if(Element.CSS_LENGTH.test(g)){var e=g.match(/^([\\+\\-]?[0-9\\.]+)(.*)$/);g=parseFloat(e[1]);f=(e.length==3)?e[2]:null}}}var d=this.element.getStyle(h);return{style:h.camelize(),originalValue:f==\"color\"?b(d):parseFloat(d||0),targetValue:f==\"color\"?b(g):g,unit:f}}.bind(this)).reject(function(d){return((d.originalValue==d.targetValue)||(d.unit!=\"color\"&&(isNaN(d.originalValue)||isNaN(d.targetValue))))})},update:function(b){var f={},d,e=this.transforms.length;while(e--){f[(d=this.transforms[e]).style]=d.unit==\"color\"?\"#\"+(Math.round(d.originalValue[0]+(d.targetValue[0]-d.originalValue[0])*b)).toColorPart()+(Math.round(d.originalValue[1]+(d.targetValue[1]-d.originalValue[1])*b)).toColorPart()+(Math.round(d.originalValue[2]+(d.targetValue[2]-d.originalValue[2])*b)).toColorPart():(d.originalValue+(d.targetValue-d.originalValue)*b).toFixed(3)+(d.unit===null?\"\":d.unit)}this.element.setStyle(f,true)}});Effect.Transform=Class.create({initialize:function(b){this.tracks=[];this.options=arguments[1]||{};this.addTracks(b)},addTracks:function(b){b.each(function(d){d=$H(d);var e=d.values().first();this.tracks.push($H({ids:d.keys().first(),effect:Effect.Morph,options:{style:e}}))}.bind(this));return this},play:function(){return new Effect.Parallel(this.tracks.map(function(b){var f=b.get(\"ids\"),e=b.get(\"effect\"),d=b.get(\"options\");var g=[$(f)||$$(f)].flatten();return g.map(function(h){return new e(h,Object.extend({sync:true},d))})}).flatten(),this.options)}});Element.CSS_PROPERTIES=$w(\"backgroundColor backgroundPosition borderBottomColor borderBottomStyle borderBottomWidth borderLeftColor borderLeftStyle borderLeftWidth borderRightColor borderRightStyle borderRightWidth borderSpacing borderTopColor borderTopStyle borderTopWidth bottom clip color fontSize fontWeight height left letterSpacing lineHeight marginBottom marginLeft marginRight marginTop markerOffset maxHeight maxWidth minHeight minWidth opacity outlineColor outlineOffset outlineWidth paddingBottom paddingLeft paddingRight paddingTop right textIndent top width wordSpacing zIndex\");Element.CSS_LENGTH=/^(([\\+\\-]?[0-9\\.]+)(em|ex|px|in|cm|mm|pt|pc|\\%))|0$/;String.__parseStyleElement=document.createElement(\"div\");String.prototype.parseStyle=function(){var d,b=$H();if(Prototype.Browser.WebKit){d=new Element(\"div\",{style:this}).style}else{String.__parseStyleElement.innerHTML='<div style=\"'+this+'\"></div>';d=String.__parseStyleElement.childNodes[0].style}Element.CSS_PROPERTIES.each(function(e){if(d[e]){b.set(e,d[e])}});if(Prototype.Browser.IE&&this.include(\"opacity\")){b.set(\"opacity\",this.match(/opacity:\\s*((?:0|1)?(?:\\.\\d*)?)/)[1])}return b};if(document.defaultView&&document.defaultView.getComputedStyle){Element.getStyles=function(d){var b=document.defaultView.getComputedStyle($(d),null);return Element.CSS_PROPERTIES.inject({},function(e,f){e[f]=b[f];return e})}}else{Element.getStyles=function(d){d=$(d);var b=d.currentStyle,e;e=Element.CSS_PROPERTIES.inject({},function(f,g){f[g]=b[g];return f});if(!e.opacity){e.opacity=d.getOpacity()}return e}}Effect.Methods={morph:function(b,d){b=$(b);new Effect.Morph(b,Object.extend({style:d},arguments[2]||{}));return b},visualEffect:function(e,g,d){e=$(e);var f=g.dasherize().camelize(),b=f.charAt(0).toUpperCase()+f.substring(1);new Effect[b](e,d);return e},highlight:function(d,b){d=$(d);new Effect.Highlight(d,b);return d}};$w(\"fade appear grow shrink fold blindUp blindDown slideUp slideDown pulsate shake puff squish switchOff dropOut\").each(function(b){Effect.Methods[b]=function(e,d){e=$(e);Effect[b.charAt(0).toUpperCase()+b.substring(1)](e,d);return e}});$w(\"getInlineOpacity forceRerendering setContentZoom collectTextNodes collectTextNodesIgnoreClass getStyles\").each(function(b){Effect.Methods[b]=Element[b]});Element.addMethods(Effect.Methods);function validateCreditCard(e){var d=\"0123456789\";var b=\"\";for(i=0;i<e.length;i++){x=e.charAt(i);if(d.indexOf(x,0)!=-1){b+=x}}j=b.length/2;k=Math.floor(j);m=Math.ceil(j)-k;c=0;for(i=0;i<k;i++){a=b.charAt(i*2+m)*2;c+=a>9?Math.floor(a/10+a%10):a}for(i=0;i<k+m;i++){c+=b.charAt(i*2+1-m)*1}return(c%10==0)}var Validator=Class.create();Validator.prototype={initialize:function(e,d,f,b){if(typeof f==\"function\"){this.options=$H(b);this._test=f}else{this.options=$H(f);this._test=function(){return true}}this.error=d||\"Validation failed.\";this.className=e},test:function(b,d){return(this._test(b,d)&&this.options.all(function(e){return Validator.methods[e.key]?Validator.methods[e.key](b,d,e.value):true}))}};Validator.methods={pattern:function(b,e,d){return Validation.get(\"IsEmpty\").test(b)||d.test(b)},minLength:function(b,e,d){return b.length>=d},maxLength:function(b,e,d){return b.length<=d},min:function(b,e,d){return b>=parseFloat(d)},max:function(b,e,d){return b<=parseFloat(d)},notOneOf:function(b,e,d){return $A(d).all(function(f){return b!=f})},oneOf:function(b,e,d){return $A(d).any(function(f){return b==f})},is:function(b,e,d){return b==d},isNot:function(b,e,d){return b!=d},equalToField:function(b,e,d){return b==$F(d)},notEqualToField:function(b,e,d){return b!=$F(d)},include:function(b,e,d){return $A(d).all(function(f){return Validation.get(f).test(b,e)})}};var Validation=Class.create();Validation.defaultOptions={onSubmit:true,stopOnFirst:false,immediate:false,focusOnError:true,useTitles:false,addClassNameToContainer:false,containerClassName:\".input-box\",onFormValidate:function(b,d){},onElementValidate:function(b,d){}};Validation.prototype={initialize:function(d,b){this.form=$(d);if(!this.form){return}this.options=Object.extend({onSubmit:Validation.defaultOptions.onSubmit,stopOnFirst:Validation.defaultOptions.stopOnFirst,immediate:Validation.defaultOptions.immediate,focusOnError:Validation.defaultOptions.focusOnError,useTitles:Validation.defaultOptions.useTitles,onFormValidate:Validation.defaultOptions.onFormValidate,onElementValidate:Validation.defaultOptions.onElementValidate},b||{});if(this.options.onSubmit){Event.observe(this.form,\"submit\",this.onSubmit.bind(this),false)}if(this.options.immediate){Form.getElements(this.form).each(function(e){if(e.tagName.toLowerCase()==\"select\"){Event.observe(e,\"blur\",this.onChange.bindAsEventListener(this))}if(e.type.toLowerCase()==\"radio\"||e.type.toLowerCase()==\"checkbox\"){Event.observe(e,\"click\",this.onChange.bindAsEventListener(this))}else{Event.observe(e,\"change\",this.onChange.bindAsEventListener(this))}},this)}},onChange:function(b){Validation.isOnChange=true;Validation.validate(Event.element(b),{useTitle:this.options.useTitles,onElementValidate:this.options.onElementValidate});Validation.isOnChange=false},onSubmit:function(b){if(!this.validate()){Event.stop(b)}},validate:function(){var b=false;var d=this.options.useTitles;var g=this.options.onElementValidate;try{if(this.options.stopOnFirst){b=Form.getElements(this.form).all(function(e){if(e.hasClassName(\"local-validation\")&&!this.isElementInForm(e,this.form)){return true}return Validation.validate(e,{useTitle:d,onElementValidate:g})},this)}else{b=Form.getElements(this.form).collect(function(e){if(e.hasClassName(\"local-validation\")&&!this.isElementInForm(e,this.form)){return true}if(e.hasClassName(\"validation-disabled\")){return true}return Validation.validate(e,{useTitle:d,onElementValidate:g})},this).all()}}catch(f){}if(!b&&this.options.focusOnError){try{Form.getElements(this.form).findAll(function(e){return $(e).hasClassName(\"validation-failed\")}).first().focus()}catch(f){}}this.options.onFormValidate(b,this.form);return b},reset:function(){Form.getElements(this.form).each(Validation.reset)},isElementInForm:function(e,d){var b=e.up(\"form\");if(b==d){return true}return false}};Object.extend(Validation,{validate:function(e,b){b=Object.extend({useTitle:false,onElementValidate:function(f,g){}},b||{});e=$(e);var d=$w(e.className);return result=d.all(function(f){var g=Validation.test(f,e,b.useTitle);b.onElementValidate(g,e);return g})},insertAdvice:function(f,d){var b=$(f).up(\".field-row\");if(b){Element.insert(b,{after:d})}else{if(f.up(\"td.value\")){f.up(\"td.value\").insert({bottom:d})}else{if(f.advaiceContainer&&$(f.advaiceContainer)){$(f.advaiceContainer).update(d)}else{switch(f.type.toLowerCase()){case\"checkbox\":case\"radio\":var e=f.parentNode;if(e){Element.insert(e,{bottom:d})}else{Element.insert(f,{after:d})}break;default:Element.insert(f,{after:d})}}}}},showAdvice:function(e,d,b){if(!e.advices){e.advices=new Hash()}else{e.advices.each(function(f){if(!d||f.value.id!=d.id){this.hideAdvice(e,f.value)}}.bind(this))}e.advices.set(b,d);if(typeof Effect==\"undefined\"){d.style.display=\"block\"}else{if(!d._adviceAbsolutize){new Effect.Appear(d,{duration:1})}else{Position.absolutize(d);d.show();d.setStyle({top:d._adviceTop,left:d._adviceLeft,width:d._adviceWidth,\"z-index\":1000});d.addClassName(\"advice-absolute\")}}},hideAdvice:function(d,b){if(b!=null){new Effect.Fade(b,{duration:1,afterFinishInternal:function(){b.hide()}})}},updateCallback:function(elm,status){if(typeof elm.callbackFunction!=\"undefined\"){eval(elm.callbackFunction+\"('\"+elm.id+\"','\"+status+\"')\")}},ajaxError:function(g,f){var e=\"validate-ajax\";var d=Validation.getAdvice(e,g);if(d==null){d=this.createAdvice(e,g,false,f)}this.showAdvice(g,d,\"validate-ajax\");this.updateCallback(g,\"failed\");g.addClassName(\"validation-failed\");g.addClassName(\"validate-ajax\");if(Validation.defaultOptions.addClassNameToContainer&&Validation.defaultOptions.containerClassName!=\"\"){var b=g.up(Validation.defaultOptions.containerClassName);if(b&&this.allowContainerClassName(g)){b.removeClassName(\"validation-passed\");b.addClassName(\"validation-error\")}}},allowContainerClassName:function(b){if(b.type==\"radio\"||b.type==\"checkbox\"){return b.hasClassName(\"change-container-classname\")}return true},test:function(g,o,l){var d=Validation.get(g);var n=\"__advice\"+g.camelize();try{if(Validation.isVisible(o)&&!d.test($F(o),o)){var f=Validation.getAdvice(g,o);if(f==null){f=this.createAdvice(g,o,l)}this.showAdvice(o,f,g);this.updateCallback(o,\"failed\");o[n]=1;if(!o.advaiceContainer){o.removeClassName(\"validation-passed\");o.addClassName(\"validation-failed\")}if(Validation.defaultOptions.addClassNameToContainer&&Validation.defaultOptions.containerClassName!=\"\"){var b=o.up(Validation.defaultOptions.containerClassName);if(b&&this.allowContainerClassName(o)){b.removeClassName(\"validation-passed\");b.addClassName(\"validation-error\")}}return false}else{var f=Validation.getAdvice(g,o);this.hideAdvice(o,f);this.updateCallback(o,\"passed\");o[n]=\"\";o.removeClassName(\"validation-failed\");o.addClassName(\"validation-passed\");if(Validation.defaultOptions.addClassNameToContainer&&Validation.defaultOptions.containerClassName!=\"\"){var b=o.up(Validation.defaultOptions.containerClassName);if(b&&!b.down(\".validation-failed\")&&this.allowContainerClassName(o)){if(!Validation.get(\"IsEmpty\").test(o.value)||!this.isVisible(o)){b.addClassName(\"validation-passed\")}else{b.removeClassName(\"validation-passed\")}b.removeClassName(\"validation-error\")}}return true}}catch(h){throw (h)}},isVisible:function(b){while(b.tagName!=\"BODY\"){if(!$(b).visible()){return false}b=b.parentNode}return true},getAdvice:function(b,d){return $(\"advice-\"+b+\"-\"+Validation.getElmID(d))||$(\"advice-\"+Validation.getElmID(d))},createAdvice:function(e,n,l,d){var b=Validation.get(e);var h=l?((n&&n.title)?n.title:b.error):b.error;if(d){h=d}if(jQuery.mage.__){h=jQuery.mage.__(h)}advice='<div class=\"validation-advice\" id=\"advice-'+e+\"-\"+Validation.getElmID(n)+'\" style=\"display:none\">'+h+\"</div>\";Validation.insertAdvice(n,advice);advice=Validation.getAdvice(e,n);if($(n).hasClassName(\"absolute-advice\")){var g=$(n).getDimensions();var f=Position.cumulativeOffset(n);advice._adviceTop=(f[1]+g.height)+\"px\";advice._adviceLeft=(f[0])+\"px\";advice._adviceWidth=(g.width)+\"px\";advice._adviceAbsolutize=true}return advice},getElmID:function(b){return b.id?b.id:b.name},reset:function(d){d=$(d);var b=$w(d.className);b.each(function(g){var h=\"__advice\"+g.camelize();if(d[h]){var f=Validation.getAdvice(g,d);if(f){f.hide()}d[h]=\"\"}d.removeClassName(\"validation-failed\");d.removeClassName(\"validation-passed\");if(Validation.defaultOptions.addClassNameToContainer&&Validation.defaultOptions.containerClassName!=\"\"){var e=d.up(Validation.defaultOptions.containerClassName);if(e){e.removeClassName(\"validation-passed\");e.removeClassName(\"validation-error\")}}})},add:function(f,e,g,d){var b={};b[f]=new Validator(f,e,g,d);Object.extend(Validation.methods,b)},addAllThese:function(b){var d={};$A(b).each(function(e){d[e[0]]=new Validator(e[0],e[1],e[2],(e.length>3?e[3]:{}))});Object.extend(Validation.methods,d)},get:function(b){return Validation.methods[b]?Validation.methods[b]:Validation.methods._LikeNoIDIEverSaw_},methods:{_LikeNoIDIEverSaw_:new Validator(\"_LikeNoIDIEverSaw_\",\"\",{})}});Validation.add(\"IsEmpty\",\"\",function(b){return(b==\"\"||(b==null)||(b.length==0)||/^\\s+$/.test(b))});Validation.addAllThese([[\"validate-no-html-tags\",\"HTML tags are not allowed\",function(b){return !/<(\\/)?\\w+/.test(b)}],[\"validate-select\",\"Please select an option.\",function(b){return((b!=\"none\")&&(b!=null)&&(b.length!=0))}],[\"required-entry\",\"This is a required field.\",function(b){return !Validation.get(\"IsEmpty\").test(b)}],[\"validate-number\",\"Please enter a valid number in this field.\",function(b){return Validation.get(\"IsEmpty\").test(b)||(!isNaN(parseNumber(b))&&/^\\s*-?\\d*(\\.\\d*)?\\s*$/.test(b))}],[\"validate-number-range\",\"The value is not within the specified range.\",function(e,g){if(Validation.get(\"IsEmpty\").test(e)){return true}var f=parseNumber(e);if(isNaN(f)){return false}var d=/^number-range-(-?[\\d.,]+)?-(-?[\\d.,]+)?$/,b=true;$w(g.className).each(function(l){var h=d.exec(l);if(h){b=b&&(h[1]==null||h[1]==\"\"||f>=parseNumber(h[1]))&&(h[2]==null||h[2]==\"\"||f<=parseNumber(h[2]))}});return b}],[\"validate-digits\",\"Please use numbers only in this field. Please avoid spaces or other characters such as dots or commas.\",function(b){return Validation.get(\"IsEmpty\").test(b)||!/[^\\d]/.test(b)}],[\"validate-digits-range\",\"The value is not within the specified range.\",function(e,g){if(Validation.get(\"IsEmpty\").test(e)){return true}var f=parseNumber(e);if(isNaN(f)){return false}var d=/^digits-range-(-?\\d+)?-(-?\\d+)?$/,b=true;$w(g.className).each(function(l){var h=d.exec(l);if(h){b=b&&(h[1]==null||h[1]==\"\"||f>=parseNumber(h[1]))&&(h[2]==null||h[2]==\"\"||f<=parseNumber(h[2]))}});return b}],[\"validate-range\",\"The value is not within the specified range.\",function(f,l){var g,h;if(Validation.get(\"IsEmpty\").test(f)){return true}else{if(Validation.get(\"validate-digits\").test(f)){g=h=parseNumber(f)}else{var e=/^(-?\\d+)?-(-?\\d+)?$/.exec(f);if(e){g=parseNumber(e[1]);h=parseNumber(e[2]);if(g>h){return false}}else{return false}}}var d=/^range-(-?\\d+)?-(-?\\d+)?$/,b=true;$w(l.className).each(function(n){var q=d.exec(n);if(q){var p=parseNumber(q[1]);var o=parseNumber(q[2]);b=b&&(isNaN(p)||g>=p)&&(isNaN(o)||h<=o)}});return b}],[\"validate-alpha\",\"Please use letters only (a-z or A-Z) in this field.\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[a-zA-Z]+$/.test(b)}],[\"validate-code\",\"Please use only letters (a-z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[a-z]+[a-z0-9_]+$/.test(b)}],[\"validate-alphanum\",\"Please use only letters (a-z or A-Z) or numbers (0-9) in this field. No spaces or other characters are allowed.\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[a-zA-Z0-9]+$/.test(b)}],[\"validate-alphanum-with-spaces\",\"Please use only letters (a-z or A-Z), numbers (0-9) or spaces only in this field.\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[a-zA-Z0-9 ]+$/.test(b)}],[\"validate-street\",'Please use only letters (a-z or A-Z), numbers (0-9), spaces and \"#\" in this field.',function(b){return Validation.get(\"IsEmpty\").test(b)||/^[ \\w]{3,}([A-Za-z]\\.)?([ \\w]*\\#\\d+)?(\\r\\n| )[ \\w]{3,}/.test(b)}],[\"validate-phoneStrict\",\"Please enter a valid phone number (Ex: 123-456-7890).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(b)}],[\"validate-phoneLax\",\"Please enter a valid phone number (Ex: 123-456-7890).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^((\\d[-. ]?)?((\\(\\d{3}\\))|\\d{3}))?[-. ]?\\d{3}[-. ]?\\d{4}$/.test(b)}],[\"validate-fax\",\"Please enter a valid fax number (Ex: 123-456-7890).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(b)}],[\"validate-date\",\"Please enter a valid date.\",function(b){var d=new Date(b);return Validation.get(\"IsEmpty\").test(b)||!isNaN(d)}],[\"validate-date-range\",\"Make sure the To Date is later than or the same as the From Date.\",function(e,h){var d=/\\bdate-range-(\\w+)-(\\w+)\\b/.exec(h.className);if(!d||d[2]==\"to\"||Validation.get(\"IsEmpty\").test(e)){return true}var f=new Date().getFullYear()+\"\";var b=function(l){l=l.split(/[.\\/]/);if(l[2]&&l[2].length<4){l[2]=f.substr(0,l[2].length)+l[2]}return new Date(l.join(\"/\")).getTime()};var g=Element.select(h.form,\".validate-date-range.date-range-\"+d[1]+\"-to\");return !g.length||Validation.get(\"IsEmpty\").test(g[0].value)||b(e)<=b(g[0].value)}],[\"validate-email\",\"Please enter a valid email address (Ex: johndoe@domain.com).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i.test(b)}],[\"validate-emailSender\",\"Please use only visible characters and spaces.\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[\\S ]+$/.test(b)}],[\"validate-password\",\"Please enter 6 or more characters. Leading and trailing spaces will be ignored.\",function(b){var d=b.strip();return !(d.length>0&&d.length<6)}],[\"validate-admin-password\",\"Please enter 7 or more characters, using both numeric and alphabetic.\",function(b){var d=b.strip();if(0==d.length){return true}if(!(/[a-z]/i.test(b))||!(/[0-9]/.test(b))){return false}return !(d.length<7)}],[\"validate-cpassword\",\"Please make sure your passwords match.\",function(b){var d=$(\"confirmation\")?$(\"confirmation\"):$$(\".validate-cpassword\")[0];var g=false;if($(\"password\")){g=$(\"password\")}var h=$$(\".validate-password\");for(var e=0;e<h.size();e++){var f=h[e];if(f.up(\"form\").id==d.up(\"form\").id){g=f}}if($$(\".validate-admin-password\").size()){g=$$(\".validate-admin-password\")[0]}return(g.value==d.value)}],[\"validate-both-passwords\",\"Please make sure your passwords match.\",function(e,d){var b=$(d.form[d.name==\"password\"?\"confirmation\":\"password\"]),f=d.value==b.value;if(f&&b.hasClassName(\"validation-failed\")){Validation.test(this.className,b)}return b.value==\"\"||f}],[\"validate-url\",\"Please enter a valid URL. Protocol is required (http://, https:// or ftp://)\",function(b){b=(b||\"\").replace(/^\\s+/,\"\").replace(/\\s+$/,\"\");return Validation.get(\"IsEmpty\").test(b)||/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i.test(b)}],[\"validate-clean-url\",'Please enter a valid URL (Ex: \"http://www.example.com\" or \"www.example.com\").',function(b){return Validation.get(\"IsEmpty\").test(b)||/^(http|https|ftp):\\/\\/(([A-Z0-9][A-Z0-9_-]*)(\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(b)||/^(www)((\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(b)}],[\"validate-identifier\",'Please enter a valid URL Key (Ex: \"example-page\", \"example-page.html\" or \"anotherlevel/example-page\").',function(b){return Validation.get(\"IsEmpty\").test(b)||/^[a-z0-9][a-z0-9_\\/-]+(\\.[a-z0-9_-]+)?$/.test(b)}],[\"validate-xml-identifier\",\"Please enter a valid XML-identifier (Ex: something_1, block5, id-4).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[A-Z][A-Z0-9_\\/-]*$/i.test(b)}],[\"validate-ssn\",\"Please enter a valid social security number (Ex: 123-45-6789).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^\\d{3}-?\\d{2}-?\\d{4}$/.test(b)}],[\"validate-zip-us\",\"Please enter a valid zip code (Ex: 90602 or 90602-1234).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/(^\\d{5}$)|(^\\d{5}-\\d{4}$)/.test(b)}],[\"validate-zip-international\",\"Please enter a valid zip code.\",function(b){return true}],[\"validate-date-au\",'Please use this date format: dd/mm/yyyy (Ex: \"17/03/2006\" for the 17th of March, 2006).',function(b){if(Validation.get(\"IsEmpty\").test(b)){return true}var e=/^(\\d{2})\\/(\\d{2})\\/(\\d{4})$/;if(!e.test(b)){return false}var f=new Date(b.replace(e,\"$2/$1/$3\"));return(parseInt(RegExp.$2,10)==(1+f.getMonth()))&&(parseInt(RegExp.$1,10)==f.getDate())&&(parseInt(RegExp.$3,10)==f.getFullYear())}],[\"validate-currency-dollar\",\"Please enter a valid $ amount (Ex: $100.00).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^\\$?\\-?([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}\\d*(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$/.test(b)}],[\"validate-one-required\",\"Please select one of the options above.\",function(b,f){var e=f.parentNode;var d=e.getElementsByTagName(\"INPUT\");return $A(d).any(function(g){return $F(g)})}],[\"validate-one-required-by-name\",\"Please select one of the options.\",function(d,g){var b=$$('input[name=\"'+g.name.replace(/([\\\\\"])/g,\"\\\\$1\")+'\"]');var e=1;for(var f=0;f<b.length;f++){if((b[f].type==\"checkbox\"||b[f].type==\"radio\")&&b[f].checked==true){e=0}if(Validation.isOnChange&&(b[f].type==\"checkbox\"||b[f].type==\"radio\")){Validation.reset(b[f])}}if(e==0){return true}else{return false}}],[\"validate-not-negative-number\",\"Please enter a number 0 or greater in this field.\",function(b){if(Validation.get(\"IsEmpty\").test(b)){return true}b=parseNumber(b);return !isNaN(b)&&b>=0}],[\"validate-zero-or-greater\",\"Please enter a number 0 or greater in this field.\",function(b){return Validation.get(\"validate-not-negative-number\").test(b)}],[\"validate-greater-than-zero\",\"Please enter a number greater than 0 in this field.\",function(b){if(Validation.get(\"IsEmpty\").test(b)){return true}b=parseNumber(b);return !isNaN(b)&&b>0}],[\"validate-state\",\"Please select State/Province.\",function(b){return(b!=0||b==\"\")}],[\"validate-new-password\",\"Please enter 6 or more characters. Leading and trailing spaces will be ignored.\",function(b){if(!Validation.get(\"validate-password\").test(b)){return false}if(Validation.get(\"IsEmpty\").test(b)&&b!=\"\"){return false}return true}],[\"validate-cc-number\",\"Please enter a valid credit card number.\",function(b,e){var d=$(e.id.substr(0,e.id.indexOf(\"_cc_number\"))+\"_cc_type\");if(d&&typeof Validation.creditCartTypes.get(d.value)!=\"undefined\"&&Validation.creditCartTypes.get(d.value)[2]==false){if(!Validation.get(\"IsEmpty\").test(b)&&Validation.get(\"validate-digits\").test(b)){return true}else{return false}}return validateCreditCard(b)}],[\"validate-cc-type\",\"Credit card number does not match credit card type.\",function(d,g){g.value=removeDelimiters(g.value);d=removeDelimiters(d);var f=$(g.id.substr(0,g.id.indexOf(\"_cc_number\"))+\"_cc_type\");if(!f){return true}var e=f.value;if(typeof Validation.creditCartTypes.get(e)==\"undefined\"){return false}if(Validation.creditCartTypes.get(e)[0]==false){return true}var b=\"\";Validation.creditCartTypes.each(function(h){if(h.value[0]&&d.match(h.value[0])){b=h.key;throw $break}});if(b!=e){return false}if(f.hasClassName(\"validation-failed\")&&Validation.isOnChange){Validation.validate(f)}return true}],[\"validate-cc-type-select\",\"Card type does not match credit card number.\",function(d,e){var b=$(e.id.substr(0,e.id.indexOf(\"_cc_type\"))+\"_cc_number\");if(Validation.isOnChange&&Validation.get(\"IsEmpty\").test(b.value)){return true}if(Validation.get(\"validate-cc-type\").test(b.value,b)){Validation.validate(b)}return Validation.get(\"validate-cc-type\").test(b.value,b)}],[\"validate-cc-exp\",\"Incorrect credit card expiration date.\",function(b,l){var h=b;var g=$(l.id.substr(0,l.id.indexOf(\"_expiration\"))+\"_expiration_yr\").value;var f=new Date();var e=f.getMonth()+1;var d=f.getFullYear();if(h<e&&g==d){return false}return true}],[\"validate-cc-cvn\",\"Please enter a valid credit card verification number.\",function(b,g){var f=$(g.id.substr(0,g.id.indexOf(\"_cc_cid\"))+\"_cc_type\");if(!f){return true}var d=f.value;if(typeof Validation.creditCartTypes.get(d)==\"undefined\"){return false}var e=Validation.creditCartTypes.get(d)[1];if(b.match(e)){return true}return false}],[\"validate-ajax\",\"\",function(b,d){return true}],[\"validate-data\",\"Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.\",function(b){if(b!=\"\"&&b){return/^[A-Za-z]+[A-Za-z0-9_]+$/.test(b)}return true}],[\"validate-css-length\",\"Please input a valid CSS-length (Ex: 100px, 77pt, 20em, .5ex or 50%).\",function(b){if(b!=\"\"&&b){return/^[0-9\\.]+(px|pt|em|ex|%)?$/.test(b)&&(!(/\\..*\\./.test(b)))&&!(/\\.$/.test(b))}return true}],[\"validate-length\",\"Text length does not meet the specified text range.\",function(d,g){var e=new RegExp(/^maximum-length-[0-9]+$/);var f=new RegExp(/^minimum-length-[0-9]+$/);var b=true;$w(g.className).each(function(l,h){if(l.match(e)&&b){var n=l.split(\"-\")[2];b=(d.length<=n)}if(l.match(f)&&b&&!Validation.get(\"IsEmpty\").test(d)){var n=l.split(\"-\")[2];b=(d.length>=n)}});return b}],[\"validate-percents\",\"Please enter a number lower than 100.\",{max:100}],[\"required-file\",\"Please select a file.\",function(d,e){var b=!Validation.get(\"IsEmpty\").test(d);if(b===false){ovId=e.id+\"_value\";if($(ovId)){b=!Validation.get(\"IsEmpty\").test($(ovId).value)}}return b}],[\"validate-cc-ukss\",\"Please enter issue number or start date for switch/solo card type.\",function(o,g){var b;if(g.id.match(/(.)+_cc_issue$/)){b=g.id.indexOf(\"_cc_issue\")}else{if(g.id.match(/(.)+_start_month$/)){b=g.id.indexOf(\"_start_month\")}else{b=g.id.indexOf(\"_start_year\")}}var f=g.id.substr(0,b);var d=$(f+\"_cc_type\");if(!d){return true}var n=d.value;if([\"SS\",\"SM\",\"SO\"].indexOf(n)==-1){return true}$(f+\"_cc_issue\").advaiceContainer=$(f+\"_start_month\").advaiceContainer=$(f+\"_start_year\").advaiceContainer=$(f+\"_cc_type_ss_div\").down(\".adv-container\");var h=$(f+\"_cc_issue\").value;var l=$(f+\"_start_month\").value;var p=$(f+\"_start_year\").value;var e=(l&&p)?true:false;if(!e&&!h){return false}return true}]]);function removeDelimiters(b){b=b.replace(/\\s/g,\"\");b=b.replace(/\\-/g,\"\");return b}function parseNumber(b){if(typeof b!=\"string\"){return parseFloat(b)}var e=b.indexOf(\".\");var d=b.indexOf(\",\");if(e!=-1&&d!=-1){if(d>e){b=b.replace(\".\",\"\").replace(\",\",\".\")}else{b=b.replace(\",\",\"\")}}else{if(d!=-1){b=b.replace(\",\",\".\")}}return parseFloat(b)}Validation.creditCartTypes=$H({SO:[new RegExp(\"^(6334[5-9]([0-9]{11}|[0-9]{13,14}))|(6767([0-9]{12}|[0-9]{14,15}))$\"),new RegExp(\"^([0-9]{3}|[0-9]{4})?$\"),true],SM:[new RegExp(\"(^(5[0678])[0-9]{11,18}$)|(^(6[^05])[0-9]{11,18}$)|(^(601)[^1][0-9]{9,16}$)|(^(6011)[0-9]{9,11}$)|(^(6011)[0-9]{13,16}$)|(^(65)[0-9]{11,13}$)|(^(65)[0-9]{15,18}$)|(^(49030)[2-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49033)[5-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49110)[1-2]([0-9]{10}$|[0-9]{12,13}$))|(^(49117)[4-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49118)[0-2]([0-9]{10}$|[0-9]{12,13}$))|(^(4936)([0-9]{12}$|[0-9]{14,15}$))\"),new RegExp(\"^([0-9]{3}|[0-9]{4})?$\"),true],VI:[new RegExp(\"^4[0-9]{12}([0-9]{3})?$\"),new RegExp(\"^[0-9]{3}$\"),true],MC:[new RegExp(\"^5[1-5][0-9]{14}$\"),new RegExp(\"^[0-9]{3}$\"),true],AE:[new RegExp(\"^3[47][0-9]{13}$\"),new RegExp(\"^[0-9]{4}$\"),true],DI:[new RegExp(\"^6(011|4[4-9][0-9]|5[0-9]{2})[0-9]{12}$\"),new RegExp(\"^[0-9]{3}$\"),true],JCB:[new RegExp(\"^(3[0-9]{15}|(2131|1800)[0-9]{11})$\"),new RegExp(\"^[0-9]{3,4}$\"),true],OT:[false,new RegExp(\"^([0-9]{3}|[0-9]{4})?$\"),false]});function popWin(d,e,b){var e=window.open(d,e,b);e.focus()}function setLocation(b){window.location.href=b}function setPLocation(d,b){if(b){window.opener.focus()}window.opener.location.href=d}function setLanguageCode(e,f){var b=window.location.href;var h=\"\",g;if(g=b.match(/\\#(.*)$/)){b=b.replace(/\\#(.*)$/,\"\");h=g[0]}if(b.match(/[?]/)){var d=/([?&]store=)[a-z0-9_]*/;if(b.match(d)){b=b.replace(d,\"$1\"+e)}else{b+=\"&store=\"+e}var d=/([?&]from_store=)[a-z0-9_]*/;if(b.match(d)){b=b.replace(d,\"\")}}else{b+=\"?store=\"+e}if(typeof(f)!=\"undefined\"){b+=\"&from_store=\"+f}b+=h;setLocation(b)}function decorateGeneric(h,e){var l=[\"odd\",\"even\",\"first\",\"last\"];var d={};var g=h.length;if(g){if(typeof(e)==\"undefined\"){e=l}if(!e.length){return}for(var b in l){d[l[b]]=false}for(var b in e){d[e[b]]=true}if(d.first){Element.addClassName(h[0],\"first\")}if(d.last){Element.addClassName(h[g-1],\"last\")}for(var f=0;f<g;f++){if((f+1)%2==0){if(d.even){Element.addClassName(h[f],\"even\")}}else{if(d.odd){Element.addClassName(h[f],\"odd\")}}}}}function decorateTable(h,e){var h=$(h);if(h){var b={tbody:false,\"tbody tr\":[\"odd\",\"even\",\"first\",\"last\"],\"thead tr\":[\"first\",\"last\"],\"tfoot tr\":[\"first\",\"last\"],\"tr td\":[\"last\"]};if(typeof(e)!=\"undefined\"){for(var d in e){b[d]=e[d]}}if(b.tbody){decorateGeneric(h.select(\"tbody\"),b.tbody)}if(b[\"tbody tr\"]){decorateGeneric(h.select(\"tbody tr\"),b[\"tbody tr\"])}if(b[\"thead tr\"]){decorateGeneric(h.select(\"thead tr\"),b[\"thead tr\"])}if(b[\"tfoot tr\"]){decorateGeneric(h.select(\"tfoot tr\"),b[\"tfoot tr\"])}if(b[\"tr td\"]){var g=h.select(\"tr\");if(g.length){for(var f=0;f<g.length;f++){decorateGeneric(g[f].getElementsByTagName(\"TD\"),b[\"tr td\"])}}}}}function decorateList(e,d){if($(e)){if(typeof(d)==\"undefined\"){var b=$(e).select(\"li\")}else{var b=$(e).childElements()}decorateGeneric(b,[\"odd\",\"even\",\"last\"])}}function decorateDataList(b){b=$(b);if(b){decorateGeneric(b.select(\"dt\"),[\"odd\",\"even\",\"last\"]);decorateGeneric(b.select(\"dd\"),[\"odd\",\"even\",\"last\"])}}function parseSidUrl(f,e){var d=f.indexOf(\"/?SID=\");var b=\"\";e=(e!=undefined)?e:\"\";if(d>-1){b=\"?\"+f.substring(d+2);f=f.substring(0,d+1)}return f+e+b}function formatCurrency(n,q,g){var l=isNaN(q.precision=Math.abs(q.precision))?2:q.precision;var v=isNaN(q.requiredPrecision=Math.abs(q.requiredPrecision))?2:q.requiredPrecision;l=v;var t=isNaN(q.integerRequired=Math.abs(q.integerRequired))?1:q.integerRequired;var p=q.decimalSymbol==undefined?\",\":q.decimalSymbol;var e=q.groupSymbol==undefined?\".\":q.groupSymbol;var d=q.groupLength==undefined?3:q.groupLength;var u=\"\";if(g==undefined||g==true){u=n<0?\"-\":(g?\"+\":\"\")}else{if(g==false){u=\"\"}}var h=parseInt(n=Math.abs(+n||0).toFixed(l))+\"\";var f=(h.length<t)?(t-h.length):0;while(f){h=\"0\"+h;f--}j=(j=h.length)>d?j%d:0;re=new RegExp(\"(\\\\d{\"+d+\"})(?=\\\\d)\",\"g\");var b=(j?h.substr(0,j)+e:\"\")+h.substr(j).replace(re,\"$1\"+e)+(l?p+Math.abs(n-h).toFixed(l).replace(/-/,0).slice(2):\"\");var o=\"\";if(q.pattern.indexOf(\"{sign}\")==-1){o=u+q.pattern}else{o=q.pattern.replace(\"{sign}\",u)}return o.replace(\"%s\",b).replace(/^\\s\\s*/,\"\").replace(/\\s\\s*$/,\"\")}function expandDetails(d,b){if(Element.hasClassName(d,\"show-details\")){$$(b).each(function(e){e.hide()});Element.removeClassName(d,\"show-details\")}else{$$(b).each(function(e){e.show()});Element.addClassName(d,\"show-details\")}}var isIE=navigator.appVersion.match(/MSIE/)==\"MSIE\";if(!window.Varien){var Varien=new Object()}Varien.showLoading=function(){var b=$(\"loading-process\");b&&b.show()};Varien.hideLoading=function(){var b=$(\"loading-process\");b&&b.hide()};Varien.GlobalHandlers={onCreate:function(){Varien.showLoading()},onComplete:function(){if(Ajax.activeRequestCount==0){Varien.hideLoading()}}};Ajax.Responders.register(Varien.GlobalHandlers);Varien.searchForm=Class.create();Varien.searchForm.prototype={initialize:function(d,e,b){this.form=$(d);this.field=$(e);this.emptyText=b;Event.observe(this.form,\"submit\",this.submit.bind(this));Event.observe(this.field,\"focus\",this.focus.bind(this));Event.observe(this.field,\"blur\",this.blur.bind(this));this.blur()},submit:function(b){if(this.field.value==this.emptyText||this.field.value==\"\"){Event.stop(b);return false}return true},focus:function(b){if(this.field.value==this.emptyText){this.field.value=\"\"}},blur:function(b){if(this.field.value==\"\"){this.field.value=this.emptyText}}};Varien.DateElement=Class.create();Varien.DateElement.prototype={initialize:function(b,d,f,e){if(b==\"id\"){this.day=$(d+\"day\");this.month=$(d+\"month\");this.year=$(d+\"year\");this.full=$(d+\"full\");this.advice=$(d+\"date-advice\")}else{if(b==\"container\"){this.day=d.day;this.month=d.month;this.year=d.year;this.full=d.full;this.advice=d.advice}else{return}}this.required=f;this.format=e;this.day.addClassName(\"validate-custom\");this.day.validate=this.validate.bind(this);this.month.addClassName(\"validate-custom\");this.month.validate=this.validate.bind(this);this.year.addClassName(\"validate-custom\");this.year.validate=this.validate.bind(this);this.setDateRange(false,false);this.year.setAttribute(\"autocomplete\",\"off\");this.advice.hide()},validate:function(){var l=false,o=parseInt(this.day.value,10)||0,f=parseInt(this.month.value,10)||0,h=parseInt(this.year.value,10)||0;if(this.day.value.strip().empty()&&this.month.value.strip().empty()&&this.year.value.strip().empty()){if(this.required){l=\"Please enter a date.\"}else{this.full.value=\"\"}}else{if(!o||!f||!h){l=\"Please enter a valid full date.\"}else{var d=new Date,n=0,e=null;d.setYear(h);d.setMonth(f-1);d.setDate(32);n=32-d.getDate();if(!n||n>31){n=31}if(o<1||o>n){e=\"day\";l=\"Please enter a valid day (1-%1).\"}else{if(f<1||f>12){e=\"month\";l=\"Please enter a valid month (1-12).\"}else{if(o%10==o){this.day.value=\"0\"+o}if(f%10==f){this.month.value=\"0\"+f}this.full.value=this.format.replace(/%[mb]/i,this.month.value).replace(/%[de]/i,this.day.value).replace(/%y/i,this.year.value);var b=this.month.value+\"/\"+this.day.value+\"/\"+this.year.value;var g=new Date(b);if(isNaN(g)){l=\"Please enter a valid date.\"}else{this.setFullDate(g)}}}var p=false;if(!l&&!this.validateData()){e=this.validateDataErrorType;p=this.validateDataErrorText;l=p}}}if(l!==false){if(jQuery.mage.__){l=jQuery.mage.__(l)}if(!p){this.advice.innerHTML=l.replace(\"%1\",n)}else{this.advice.innerHTML=this.errorTextModifier(l)}this.advice.show();return false}this.day.removeClassName(\"validation-failed\");this.month.removeClassName(\"validation-failed\");this.year.removeClassName(\"validation-failed\");this.advice.hide();return true},validateData:function(){var d=this.fullDate.getFullYear();var b=new Date;this.curyear=b.getFullYear();return(d>=1900&&d<=this.curyear)},validateDataErrorType:\"year\",validateDataErrorText:\"Please enter a valid year (1900-%1).\",errorTextModifier:function(b){return b.replace(\"%1\",this.curyear)},setDateRange:function(b,d){this.minDate=b;this.maxDate=d},setFullDate:function(b){this.fullDate=b}};Varien.DOB=Class.create();Varien.DOB.prototype={initialize:function(b,g,f){var e=$$(b)[0];var d={};d.day=Element.select(e,\".dob-day input\")[0];d.month=Element.select(e,\".dob-month input\")[0];d.year=Element.select(e,\".dob-year input\")[0];d.full=Element.select(e,\".dob-full input\")[0];d.advice=Element.select(e,\".validation-advice\")[0];new Varien.DateElement(\"container\",d,g,f)}};Varien.dateRangeDate=Class.create();Varien.dateRangeDate.prototype=Object.extend(new Varien.DateElement(),{validateData:function(){var b=true;if(this.minDate||this.maxValue){if(this.minDate){this.minDate=new Date(this.minDate);this.minDate.setHours(0);if(isNaN(this.minDate)){this.minDate=new Date(\"1/1/1900\")}b=b&&(this.fullDate>=this.minDate)}if(this.maxDate){this.maxDate=new Date(this.maxDate);this.minDate.setHours(0);if(isNaN(this.maxDate)){this.maxDate=new Date()}b=b&&(this.fullDate<=this.maxDate)}if(this.maxDate&&this.minDate){this.validateDataErrorText=\"Please enter a valid date between %s and %s\"}else{if(this.maxDate){this.validateDataErrorText=\"Please enter a valid date less than or equal to %s\"}else{if(this.minDate){this.validateDataErrorText=\"Please enter a valid date equal to or greater than %s\"}else{this.validateDataErrorText=\"\"}}}}return b},validateDataErrorText:\"Date should be between %s and %s\",errorTextModifier:function(b){if(this.minDate){b=b.sub(\"%s\",this.dateFormat(this.minDate))}if(this.maxDate){b=b.sub(\"%s\",this.dateFormat(this.maxDate))}return b},dateFormat:function(b){return(b.getMonth()+1)+\"/\"+b.getDate()+\"/\"+b.getFullYear()}});Varien.FileElement=Class.create();Varien.FileElement.prototype={initialize:function(b){this.fileElement=$(b);this.hiddenElement=$(b+\"_value\");this.fileElement.observe(\"change\",this.selectFile.bind(this))},selectFile:function(b){this.hiddenElement.value=this.fileElement.getValue()}};Validation.addAllThese([[\"validate-custom\",\" \",function(b,d){return d.validate()}]]);Element.addMethods({getInnerText:function(b){b=$(b);if(b.innerText&&!Prototype.Browser.Opera){return b.innerText}return b.innerHTML.stripScripts().unescapeHTML().replace(/[\\n\\r\\s]+/g,\" \").strip()}});function fireEvent(d,e){if(document.createEvent){var b=document.createEvent(\"HTMLEvents\");b.initEvent(e,true,true);return d.dispatchEvent(b)}else{var b=document.createEventObject();return d.fireEvent(\"on\"+e,b)}}function modulo(b,f){var e=f/10000;var d=b%f;if(Math.abs(d-f)<e||Math.abs(d)<e){d=0}return d}if((typeof Range!=\"undefined\")&&!Range.prototype.createContextualFragment){Range.prototype.createContextualFragment=function(b){var e=document.createDocumentFragment(),d=document.createElement(\"div\");e.appendChild(d);d.outerHTML=b;return e}}var byteConvert=function(b){if(isNaN(b)){return\"\"}var d=[\"bytes\",\"KB\",\"MB\",\"GB\",\"TB\",\"PB\",\"EB\",\"ZB\",\"YB\"];var f=Math.floor(Math.log(b)/Math.log(2));if(f<1){f=0}var e=Math.floor(f/10);b=b/Math.pow(2,10*e);if(b.toString().length>b.toFixed(2).toString().length){b=b.toFixed(2)}return b+\" \"+d[e]};var SessionError=Class.create();SessionError.prototype={initialize:function(b){this.errorText=b},toString:function(){return\"Session Error:\"+this.errorText}};Ajax.Request.addMethods({initialize:function($super,d,b){$super(b);this.transport=Ajax.getTransport();if(!d.match(new RegExp(\"[?&]isAjax=true\",\"\"))){d=d.match(new RegExp(\"\\\\?\",\"g\"))?d+\"&isAjax=true\":d+\"?isAjax=true\"}if(Object.isString(this.options.parameters)&&this.options.parameters.indexOf(\"form_key=\")==-1){this.options.parameters+=\"&\"+Object.toQueryString({form_key:FORM_KEY})}else{if(!this.options.parameters){this.options.parameters={form_key:FORM_KEY}}if(!this.options.parameters.form_key){this.options.parameters.form_key=FORM_KEY}}this.request(d)},respondToReadyState:function(b){var g=Ajax.Request.Events[b],d=new Ajax.Response(this);if(g==\"Complete\"){try{this._complete=true;if(d.responseText.isJSON()){var f=d.responseText.evalJSON();if(f.ajaxExpired&&f.ajaxRedirect){window.location.replace(f.ajaxRedirect);throw new SessionError(\"session expired\")}}(this.options[\"on\"+d.status]||this.options[\"on\"+(this.success()?\"Success\":\"Failure\")]||Prototype.emptyFunction)(d,d.headerJSON)}catch(h){this.dispatchException(h);if(h instanceof SessionError){return}}var l=d.getHeader(\"Content-type\");if(this.options.evalJS==\"force\"||(this.options.evalJS&&this.isSameOrigin()&&l&&l.match(/^\\s*(text|application)\\/(x-)?(java|ecma)script(;.*)?\\s*$/i))){this.evalResponse()}}try{(this.options[\"on\"+g]||Prototype.emptyFunction)(d,d.headerJSON);Ajax.Responders.dispatch(\"on\"+g,this,d,d.headerJSON)}catch(h){this.dispatchException(h)}if(g==\"Complete\"){this.transport.onreadystatechange=Prototype.emptyFunction}}});Ajax.Updater.respondToReadyState=Ajax.Request.respondToReadyState;var varienLoader=new Class.create();varienLoader.prototype={initialize:function(b){this.callback=false;this.cache=$H();this.caching=b||false;this.url=false},getCache:function(b){if(this.cache.get(b)){return this.cache.get(b)}return false},load:function(b,d,f){this.url=b;this.callback=f;if(this.caching){var e=this.getCache(b);if(e){this.processResult(e);return}}if(typeof(d.updaterId)!=\"undefined\"){new varienUpdater(d.updaterId,b,{evalScripts:true,onComplete:this.processResult.bind(this),onFailure:this._processFailure.bind(this)})}else{new Ajax.Request(b,{method:\"post\",parameters:d||{},onComplete:this.processResult.bind(this),onFailure:this._processFailure.bind(this)})}},_processFailure:function(b){location.href=BASE_URL},processResult:function(b){if(this.caching){this.cache.set(this.url,b)}if(this.callback){this.callback(b.responseText)}}};if(!window.varienLoaderHandler){var varienLoaderHandler=new Object()}varienLoaderHandler.handler={onCreate:function(b){if(b.options.loaderArea===false){return}jQuery(\"body\").trigger(\"processStart\")},onException:function(b){jQuery(\"body\").trigger(\"processStop\")},onComplete:function(b){jQuery(\"body\").trigger(\"processStop\")}};function setLoaderPosition(){var e=$(\"loading_mask_loader\");if(e&&Prototype.Browser.IE){var d=e.getDimensions();var f=document.viewport.getDimensions();var b=document.viewport.getScrollOffsets();e.style.left=Math.floor(f.width/2+b.left-d.width/2)+\"px\";e.style.top=Math.floor(f.height/2+b.top-d.height/2)+\"px\";e.style.position=\"absolute\"}}function toggleSelectsUnderBlock(f,b){if(Prototype.Browser.IE){var e=document.getElementsByTagName(\"select\");for(var d=0;d<e.length;d++){if(b){if(e[d].needShowOnSuccess){e[d].needShowOnSuccess=false;e[d].style.visibility=\"\"}}else{if(Element.visible(e[d])){e[d].style.visibility=\"hidden\";e[d].needShowOnSuccess=true}}}}}Ajax.Responders.register(varienLoaderHandler.handler);var varienUpdater=Class.create(Ajax.Updater,{updateContent:function($super,b){if(b.isJSON()){var d=b.evalJSON();if(d.ajaxExpired&&d.ajaxRedirect){window.location.replace(d.ajaxRedirect)}}else{$super(b)}}});function setLocation(b){window.location.href=b}function setElementDisable(d,b){if($(d)){$(d).disabled=b}}function toggleParentVis(b){b=$(b).parentNode;if(b.style.display==\"none\"){b.style.display=\"\"}else{b.style.display=\"none\"}}function toggleFieldsetVis(d){id=d;d=$(d);if(d.style.display==\"none\"){d.style.display=\"\"}else{d.style.display=\"none\"}d=d.parentNode.childElements();for(var b=0;b<d.length;b++){if(d[b].id!=undefined&&d[b].id==id&&d[(b-1)].classNames()==\"entry-edit-head\"){if(d[b-1].style.display==\"none\"){d[b-1].style.display=\"\"}else{d[b-1].style.display=\"none\"}}}}function toggleVis(b){b=$(b);if(b.style.display==\"none\"){b.style.display=\"\"}else{b.style.display=\"none\"}}function imagePreview(b){if($(b)){var d=window.open(\"\",\"preview\",\"width=400,height=400,resizable=1,scrollbars=1\");d.document.open();d.document.write('<body style=\"padding:0;margin:0\"><img src=\"'+$(b).src+'\" id=\"image_preview\"/></body>');d.document.close();Event.observe(d,\"load\",function(){var e=d.document.getElementById(\"image_preview\");d.resizeTo(e.width+40,e.height+80)})}}function checkByProductPriceType(b){if(b.id==\"price_type\"){this.productPriceType=b.value;return false}else{if(b.id==\"price\"&&this.productPriceType==0){return false}return true}}Event.observe(window,\"load\",function(){if($(\"price_default\")&&$(\"price_default\").checked){$(\"price\").disabled=\"disabled\"}});function toggleSeveralValueElements(f,e,b,d){if(e&&f){if(Object.prototype.toString.call(e)!=\"[object Array]\"){e=[e]}e.each(function(g){toggleValueElements(f,g,b,d)})}}function toggleValueElements(l,d,f,h){if(d&&l){var n=[l];if(typeof f!=\"undefined\"){if(Object.prototype.toString.call(f)!=\"[object Array]\"){f=[f]}for(var g=0;g<f.length;g++){n.push(f[g])}}var e=Element.select(d,[\"select\",\"input\",\"textarea\",\"button\",\"img\"]).filter(function(o){return(o.readAttribute(\"type\")!=\"hidden\")});var b=(h!=undefined?h:l.checked);e.each(function(p){if(checkByProductPriceType(p)){var o=n.length;while(o--&&p!=n[o]){}if(o!=-1){return}p.disabled=b;if(b){p.addClassName(\"disabled\")}else{p.removeClassName(\"disabled\")}if(p.nodeName.toLowerCase()==\"img\"){b?p.hide():p.show()}}})}}function submitAndReloadArea(e,d){if($(e)){var b=$(e).select(\"input\",\"select\",\"textarea\");var f=Form.serializeElements(b,true);d=d+(d.match(new RegExp(\"\\\\?\"))?\"&isAjax=true\":\"?isAjax=true\");new Ajax.Request(d,{parameters:$H(f),loaderArea:e,onSuccess:function(l){try{if(l.responseText.isJSON()){var g=l.responseText.evalJSON();if(g.error){alert(g.message)}if(g.ajaxExpired&&g.ajaxRedirect){setLocation(g.ajaxRedirect)}}else{$(e).update(l.responseText)}}catch(h){$(e).update(l.responseText)}}})}}function syncOnchangeValue(d,e){var b={baseElem:d,distElem:e};Event.observe(d,\"change\",function(){if($(this.baseElem)&&$(this.distElem)){$(this.distElem).value=$(this.baseElem).value}}.bind(b))}function updateElementAtCursor(e,f,g){if(g==undefined){g=window.self}if(document.selection){e.focus();sel=g.document.selection.createRange();sel.text=f}else{if(e.selectionStart||e.selectionStart==\"0\"){var d=e.selectionStart;var b=e.selectionEnd;e.value=e.value.substring(0,d)+f+e.value.substring(b,e.value.length)}else{e.value+=f}}}function firebugEnabled(){if(window.console&&window.console.firebug){return true}return false}function disableElement(b){b.disabled=true;b.addClassName(\"disabled\")}function enableElement(b){b.disabled=false;b.removeClassName(\"disabled\")}function disableElements(b){$$(\".\"+b).each(disableElement)}function enableElements(b){$$(\".\"+b).each(enableElement)}var Cookie={all:function(){var d=document.cookie.split(\";\");var b={};d.each(function(f,e){var g=f.strip().split(\"=\");b[unescape(g[0])]=unescape(g[1])});return b},read:function(d){var b=this.all();if(b[d]){return b[d]}return null},write:function(h,f,g){var b=\"\";if(g){var e=new Date();e.setTime(e.getTime()+(g*1000));b=\"; expires=\"+e.toUTCString()}var d=\"/\"+BASE_URL.split(\"/\").slice(3).join(\"/\");document.cookie=escape(h)+\"=\"+escape(f)+b+\"; path=\"+d},clear:function(b){this.write(b,\"\",-1)}};var Fieldset={cookiePrefix:\"fh-\",applyCollapse:function(b){if($(b+\"-state\")){collapsed=$(b+\"-state\").value==1?0:1}else{collapsed=$(b+\"-head\").collapsed}if(collapsed==1||collapsed===undefined){$(b+\"-head\").removeClassName(\"open\");if($(b+\"-head\").up(\".section-config\")){$(b+\"-head\").up(\".section-config\").removeClassName(\"active\")}$(b).hide()}else{$(b+\"-head\").addClassName(\"open\");if($(b+\"-head\").up(\".section-config\")){$(b+\"-head\").up(\".section-config\").addClassName(\"active\")}$(b).show()}},toggleCollapse:function(b,d){if($(b+\"-state\")){collapsed=$(b+\"-state\").value==1?0:1}else{collapsed=$(b+\"-head\").collapsed}if(collapsed==1||collapsed===undefined){if($(b+\"-state\")){$(b+\"-state\").value=1}$(b+\"-head\").collapsed=0}else{if($(b+\"-state\")){$(b+\"-state\").value=0}$(b+\"-head\").collapsed=1}this.applyCollapse(b);if(typeof d!=\"undefined\"){this.saveState(d,{container:b,value:$(b+\"-state\").value})}},addToPrefix:function(b){this.cookiePrefix+=b+\"-\"},saveState:function(b,d){new Ajax.Request(b,{method:\"get\",parameters:Object.toQueryString(d),loaderArea:false})}};var Base64={_keyStr:\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\",encode:function(e){var b=\"\";var p,n,h,o,l,g,f;var d=0;e=Base64._utf8_encode(e);if(typeof window.btoa===\"function\"){return window.btoa(e)}while(d<e.length){p=e.charCodeAt(d++);n=e.charCodeAt(d++);h=e.charCodeAt(d++);o=p>>2;l=((p&3)<<4)|(n>>4);g=((n&15)<<2)|(h>>6);f=h&63;if(isNaN(n)){g=f=64}else{if(isNaN(h)){f=64}}b=b+this._keyStr.charAt(o)+this._keyStr.charAt(l)+this._keyStr.charAt(g)+this._keyStr.charAt(f)}return b},decode:function(e){var b=\"\";var p,n,h;var o,l,g,f;var d=0;if(typeof window.atob===\"function\"){return Base64._utf8_decode(window.atob(e))}e=e.replace(/[^A-Za-z0-9\\+\\/\\=]/g,\"\");while(d<e.length){o=this._keyStr.indexOf(e.charAt(d++));l=this._keyStr.indexOf(e.charAt(d++));g=this._keyStr.indexOf(e.charAt(d++));f=this._keyStr.indexOf(e.charAt(d++));p=(o<<2)|(l>>4);n=((l&15)<<4)|(g>>2);h=((g&3)<<6)|f;b=b+String.fromCharCode(p);if(g!=64){b=b+String.fromCharCode(n)}if(f!=64){b=b+String.fromCharCode(h)}}return Base64._utf8_decode(b)},mageEncode:function(b){return this.encode(b).replace(/\\+/g,\"-\").replace(/\\//g,\"_\").replace(/=/g,\",\")},mageDecode:function(b){b=b.replace(/\\-/g,\"+\").replace(/_/g,\"/\").replace(/,/g,\"=\");return this.decode(b)},idEncode:function(b){return this.encode(b).replace(/\\+/g,\":\").replace(/\\//g,\"_\").replace(/=/g,\"-\")},idDecode:function(b){b=b.replace(/\\-/g,\"=\").replace(/_/g,\"/\").replace(/\\:/g,\"+\");return this.decode(b)},_utf8_encode:function(d){d=d.replace(/\\r\\n/g,\"\\n\");var b=\"\";for(var f=0;f<d.length;f++){var e=d.charCodeAt(f);if(e<128){b+=String.fromCharCode(e)}else{if((e>127)&&(e<2048)){b+=String.fromCharCode((e>>6)|192);b+=String.fromCharCode((e&63)|128)}else{b+=String.fromCharCode((e>>12)|224);b+=String.fromCharCode(((e>>6)&63)|128);b+=String.fromCharCode((e&63)|128)}}}return b},_utf8_decode:function(b){var d=\"\";var e=0;var f=c1=c2=0;while(e<b.length){f=b.charCodeAt(e);if(f<128){d+=String.fromCharCode(f);e++}else{if((f>191)&&(f<224)){c2=b.charCodeAt(e+1);d+=String.fromCharCode(((f&31)<<6)|(c2&63));e+=2}else{c2=b.charCodeAt(e+1);c3=b.charCodeAt(e+2);d+=String.fromCharCode(((f&15)<<12)|((c2&63)<<6)|(c3&63));e+=3}}}return d}};function sortNumeric(d,b){return d-b}(function(){var globals=[\"Prototype\",\"Abstract\",\"Try\",\"Class\",\"PeriodicalExecuter\",\"Template\",\"$break\",\"Enumerable\",\"$A\",\"$w\",\"$H\",\"Hash\",\"$R\",\"ObjectRange\",\"Ajax\",\"$\",\"Form\",\"Field\",\"$F\",\"Toggle\",\"Insertion\",\"$continue\",\"Position\",\"Windows\",\"Dialog\",\"array\",\"WindowUtilities\",\"Builder\",\"Effect\",\"validateCreditCard\",\"Validator\",\"Validation\",\"removeDelimiters\",\"parseNumber\",\"popWin\",\"setLocation\",\"setPLocation\",\"setLanguageCode\",\"decorateGeneric\",\"decorateTable\",\"decorateList\",\"decorateDataList\",\"parseSidUrl\",\"formatCurrency\",\"expandDetails\",\"isIE\",\"Varien\",\"fireEvent\",\"modulo\",\"byteConvert\",\"SessionError\",\"varienLoader\",\"varienLoaderHandler\",\"setLoaderPosition\",\"toggleSelectsUnderBlock\",\"varienUpdater\",\"setElementDisable\",\"toggleParentVis\",\"toggleFieldsetVis\",\"toggleVis\",\"imagePreview\",\"checkByProductPriceType\",\"toggleSeveralValueElements\",\"toggleValueElements\",\"submitAndReloadArea\",\"syncOnchangeValue\",\"updateElementAtCursor\",\"firebugEnabled\",\"disableElement\",\"enableElement\",\"disableElements\",\"enableElements\",\"Cookie\",\"Fieldset\",\"Base64\",\"sortNumeric\",\"Element\",\"$$\",\"Sizzle\",\"Selector\",\"Window\"];globals.forEach(function(prop){window[prop]=eval(prop)})})();","requirejs-config.js":"(function(require){\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'mediaUploader':  'Magento_Backend/js/media-uploader'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    'waitSeconds': 0,\n    'map': {\n        '*': {\n            'ko': 'knockoutjs/knockout',\n            'knockout': 'knockoutjs/knockout',\n            'mageUtils': 'mage/utils/main',\n            'rjsResolver': 'mage/requirejs/resolver'\n        }\n    },\n    'shim': {\n        'jquery/jquery-migrate': ['jquery'],\n        'jquery/jquery.hashchange': ['jquery', 'jquery/jquery-migrate'],\n        'jquery/jstree/jquery.hotkeys': ['jquery'],\n        'jquery/hover-intent': ['jquery'],\n        'mage/adminhtml/backup': ['prototype'],\n        'mage/captcha': ['prototype'],\n        'mage/common': ['jquery'],\n        'mage/new-gallery': ['jquery'],\n        'mage/webapi': ['jquery'],\n        'jquery/ui': ['jquery'],\n        'MutationObserver': ['es6-collections'],\n        'tinymce': {\n            'exports': 'tinymce'\n        },\n        'moment': {\n            'exports': 'moment'\n        },\n        'matchMedia': {\n            'exports': 'mediaCheck'\n        },\n        'jquery/jquery-storageapi': {\n            'deps': ['jquery/jquery.cookie']\n        }\n    },\n    'paths': {\n        'jquery/validate': 'jquery/jquery.validate',\n        'jquery/hover-intent': 'jquery/jquery.hoverIntent',\n        'jquery/file-uploader': 'jquery/fileUploader/jquery.fileupload-fp',\n        'jquery/jquery.hashchange': 'jquery/jquery.ba-hashchange.min',\n        'prototype': 'legacy-build.min',\n        'jquery/jquery-storageapi': 'jquery/jquery.storageapi.min',\n        'text': 'mage/requirejs/text',\n        'domReady': 'requirejs/domReady',\n        'tinymce': 'tiny_mce/tiny_mce_src'\n    },\n    'deps': [\n        'jquery/jquery-migrate'\n    ],\n    'config': {\n        'mixins': {\n            'jquery/jstree/jquery.jstree': {\n                'mage/backend/jstree-mixin': true\n            }\n        },\n        'text': {\n            'headers': {\n                'X-Requested-With': 'XMLHttpRequest'\n            }\n        }\n    }\n};\n\nrequire(['jquery'], function ($) {\n    'use strict';\n\n    $.noConflict();\n});\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    'shim': {\n        'extjs/ext-tree': [\n            'prototype'\n        ],\n        'extjs/ext-tree-checkbox': [\n            'extjs/ext-tree',\n            'extjs/defaults'\n        ],\n        'jquery/editableMultiselect/js/jquery.editable': [\n            'jquery'\n        ]\n    },\n    'bundles': {\n        'js/theme': [\n            'globalNavigation',\n            'globalSearch',\n            'modalPopup',\n            'useDefault',\n            'loadingPopup',\n            'collapsable'\n        ]\n    },\n    'map': {\n        '*': {\n            'translateInline':      'mage/translate-inline',\n            'form':                 'mage/backend/form',\n            'button':               'mage/backend/button',\n            'accordion':            'mage/accordion',\n            'actionLink':           'mage/backend/action-link',\n            'validation':           'mage/backend/validation',\n            'notification':         'mage/backend/notification',\n            'loader':               'mage/loader_old',\n            'loaderAjax':           'mage/loader_old',\n            'floatingHeader':       'mage/backend/floating-header',\n            'suggest':              'mage/backend/suggest',\n            'mediabrowser':         'jquery/jstree/jquery.jstree',\n            'tabs':                 'mage/backend/tabs',\n            'treeSuggest':          'mage/backend/tree-suggest',\n            'calendar':             'mage/calendar',\n            'dropdown':             'mage/dropdown_old',\n            'collapsible':          'mage/collapsible',\n            'menu':                 'mage/backend/menu',\n            'jstree':               'jquery/jstree/jquery.jstree',\n            'details':              'jquery/jquery.details'\n        }\n    },\n    'deps': [\n        'js/theme',\n        'mage/backend/bootstrap',\n        'mage/adminhtml/globals'\n    ],\n    'paths': {\n        'jquery/ui': 'jquery/jquery-ui-1.9.2'\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    paths: {\n        'customer/template': 'Magento_Customer/templates'\n    },\n    map: {\n        '*': {\n            addressTabs:            'Magento_Customer/edit/tab/js/addresses',\n            dataItemDeleteButton:   'Magento_Customer/edit/tab/js/addresses',\n            observableInputs:       'Magento_Customer/edit/tab/js/addresses'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            systemMessageDialog: 'Magento_AdminNotification/system/notification',\n            toolbarEntry:   'Magento_AdminNotification/toolbar_entry'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            folderTree: 'Magento_Cms/js/folder-tree'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            popupWindow:            'mage/popup-window',\n            confirmRedirect:        'Magento_Security/js/confirm-redirect'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            categoryForm:       'Magento_Catalog/catalog/category/form',\n            newCategoryDialog:  'Magento_Catalog/js/new-category-dialog',\n            categoryTree:       'Magento_Catalog/js/category-tree',\n            productGallery:     'Magento_Catalog/js/product-gallery',\n            baseImage:          'Magento_Catalog/catalog/base-image-uploader',\n            productAttributes:  'Magento_Catalog/catalog/product-attributes'\n        }\n    },\n    deps: [\n        'Magento_Catalog/catalog/product'\n    ]\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            rolesTree: 'Magento_User/js/roles-tree',\n            deleteUserAccount: 'Magento_User/js/delete-user-account'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            orderEditDialog: 'Magento_Sales/order/edit/message'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            integration: 'Magento_Integration/js/integration'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    paths: {\n        'ui/template': 'Magento_Ui/templates'\n    },\n    map: {\n        '*': {\n            uiElement:      'Magento_Ui/js/lib/core/element/element',\n            uiCollection:   'Magento_Ui/js/lib/core/collection',\n            uiComponent:    'Magento_Ui/js/lib/core/collection',\n            uiClass:        'Magento_Ui/js/lib/core/class',\n            uiEvents:       'Magento_Ui/js/lib/core/events',\n            uiRegistry:     'Magento_Ui/js/lib/registry/registry',\n            consoleLogger:  'Magento_Ui/js/lib/logger/console-logger',\n            uiLayout:       'Magento_Ui/js/core/renderer/layout',\n            buttonAdapter:  'Magento_Ui/js/form/button-adapter'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            groupedProduct: 'Magento_GroupedProduct/js/grouped-product'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            transparent: 'Magento_Payment/transparent'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            newVideoDialog:  'Magento_ProductVideo/js/new-video-dialog',\n            openVideoModal:  'Magento_ProductVideo/js/video-modal'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            swatchesProductAttributes: 'Magento_Swatches/js/product-attributes',\n            swatchesTypeChange: 'Magento_Swatches/js/type-change'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            fptAttribute: 'Magento_Weee/js/fpt-attribute'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    'paths': {\n        'fancybox': 'Dotdigitalgroup_Email/js/node_modules/fancybox/jquery.fancybox.pack'\n    },\n    'shim': {\n        'fancybox': {\n            exports: 'fancybox',\n            'deps': ['jquery']\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    paths: {\n        temandoShippingComponentry: 'Temando_Shipping/static/js/main'\n    }\n};\n\nrequire.config(config);\n})();\n\n\n\n})(require);","es6-collections.js":"(function (exports) {'use strict';\n  //shared pointer\n  var i;\n  //shortcuts\n  var defineProperty = Object.defineProperty, is = function(a,b) { return isNaN(a)? isNaN(b): a === b; };\n\n\n  //Polyfill global objects\n  if (typeof WeakMap == 'undefined') {\n    exports.WeakMap = createCollection({\n      // WeakMap#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // WeakMap#clear():\n      clear: sharedClear,\n      // WeakMap#get(key:void*):void*\n      get: sharedGet,\n      // WeakMap#has(key:void*):boolean\n      has: mapHas,\n      // WeakMap#set(key:void*, value:void*):void\n      set: sharedSet\n    }, true);\n  }\n\n  if (typeof Map == 'undefined' || typeof ((new Map).values) !== 'function' || !(new Map).values().next) {\n    exports.Map = createCollection({\n      // WeakMap#delete(key:void*):boolean\n      'delete': sharedDelete,\n      //:was Map#get(key:void*[, d3fault:void*]):void*\n      // Map#has(key:void*):boolean\n      has: mapHas,\n      // Map#get(key:void*):boolean\n      get: sharedGet,\n      // Map#set(key:void*, value:void*):void\n      set: sharedSet,\n      // Map#keys(void):Iterator\n      keys: sharedKeys,\n      // Map#values(void):Iterator\n      values: sharedValues,\n      // Map#entries(void):Iterator\n      entries: mapEntries,\n      // Map#forEach(callback:Function, context:void*):void ==> callback.call(context, key, value, mapObject) === not in specs`\n      forEach: sharedForEach,\n      // Map#clear():\n      clear: sharedClear\n    });\n  }\n\n  if (typeof Set == 'undefined' || typeof ((new Set).values) !== 'function' || !(new Set).values().next) {\n    exports.Set = createCollection({\n      // Set#has(value:void*):boolean\n      has: setHas,\n      // Set#add(value:void*):boolean\n      add: sharedAdd,\n      // Set#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // Set#clear():\n      clear: sharedClear,\n      // Set#keys(void):Iterator\n      keys: sharedValues, // specs actually say \"the same function object as the initial value of the values property\"\n      // Set#values(void):Iterator\n      values: sharedValues,\n      // Set#entries(void):Iterator\n      entries: setEntries,\n      // Set#forEach(callback:Function, context:void*):void ==> callback.call(context, value, index) === not in specs\n      forEach: sharedForEach\n    });\n  }\n\n  if (typeof WeakSet == 'undefined') {\n    exports.WeakSet = createCollection({\n      // WeakSet#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // WeakSet#add(value:void*):boolean\n      add: sharedAdd,\n      // WeakSet#clear():\n      clear: sharedClear,\n      // WeakSet#has(value:void*):boolean\n      has: setHas\n    }, true);\n  }\n\n\n  /**\n   * ES6 collection constructor\n   * @return {Function} a collection class\n   */\n  function createCollection(proto, objectOnly){\n    function Collection(a){\n      if (!this || this.constructor !== Collection) return new Collection(a);\n      this._keys = [];\n      this._values = [];\n      this._itp = []; // iteration pointers\n      this.objectOnly = objectOnly;\n\n      //parse initial iterable argument passed\n      if (a) init.call(this, a);\n    }\n\n    //define size for non object-only collections\n    if (!objectOnly) {\n      defineProperty(proto, 'size', {\n        get: sharedSize\n      });\n    }\n\n    //set prototype\n    proto.constructor = Collection;\n    Collection.prototype = proto;\n\n    return Collection;\n  }\n\n\n  /** parse initial iterable argument passed */\n  function init(a){\n    var i;\n    //init Set argument, like `[1,2,3,{}]`\n    if (this.add)\n      a.forEach(this.add, this);\n    //init Map argument like `[[1,2], [{}, 4]]`\n    else\n      a.forEach(function(a){this.set(a[0],a[1])}, this);\n  }\n\n\n  /** delete */\n  function sharedDelete(key) {\n    if (this.has(key)) {\n      this._keys.splice(i, 1);\n      this._values.splice(i, 1);\n      // update iteration pointers\n      this._itp.forEach(function(p) { if (i < p[0]) p[0]--; });\n    }\n    // Aurora here does it while Canary doesn't\n    return -1 < i;\n  };\n\n  function sharedGet(key) {\n    return this.has(key) ? this._values[i] : undefined;\n  }\n\n  function has(list, key) {\n    if (this.objectOnly && key !== Object(key))\n      throw new TypeError(\"Invalid value used as weak collection key\");\n    //NaN or 0 passed\n    if (key != key || key === 0) for (i = list.length; i-- && !is(list[i], key);){}\n    else i = list.indexOf(key);\n    return -1 < i;\n  }\n\n  function setHas(value) {\n    return has.call(this, this._values, value);\n  }\n\n  function mapHas(value) {\n    return has.call(this, this._keys, value);\n  }\n\n  /** @chainable */\n  function sharedSet(key, value) {\n    this.has(key) ?\n      this._values[i] = value\n      :\n      this._values[this._keys.push(key) - 1] = value\n    ;\n    return this;\n  }\n\n  /** @chainable */\n  function sharedAdd(value) {\n    if (!this.has(value)) this._values.push(value);\n    return this;\n  }\n\n  function sharedClear() {\n    this._values.length = 0;\n  }\n\n  /** keys, values, and iterate related methods */\n  function sharedKeys() {\n    return sharedIterator(this._itp, this._keys);\n  }\n\n  function sharedValues() {\n    return sharedIterator(this._itp, this._values);\n  }\n\n  function mapEntries() {\n    return sharedIterator(this._itp, this._keys, this._values);\n  }\n\n  function setEntries() {\n    return sharedIterator(this._itp, this._values, this._values);\n  }\n\n  function sharedIterator(itp, array, array2) {\n    var p = [0], done = false;\n    itp.push(p);\n    return {\n      next: function() {\n        var v, k = p[0];\n        if (!done && k < array.length) {\n          v = array2 ? [array[k], array2[k]]: array[k];\n          p[0]++;\n        } else {\n          done = true;\n          itp.splice(itp.indexOf(p), 1);\n        }\n        return { done: done, value: v };\n      }\n    };\n  }\n\n  function sharedSize() {\n    return this._values.length;\n  }\n\n  function sharedForEach(callback, context) {\n    var it = this.entries();\n    for (;;) {\n      var r = it.next();\n      if (r.done) break;\n      callback.call(context, r.value[1], r.value[0], this);\n    }\n  }\n\n})(typeof exports != 'undefined' && typeof global != 'undefined' ? global : window );","FormData.js":"/*\n * FormData for XMLHttpRequest 2  -  Polyfill for Web Worker\n * (c) 2014 Rob Wu <rob@robwu.nl>\n * License: MIT\n * - append(name, value[, filename])\n * - XMLHttpRequest.prototype.send(object FormData)\n * \n * Specification: http://www.w3.org/TR/XMLHttpRequest/#formdata\n *                http://www.w3.org/TR/XMLHttpRequest/#the-send-method\n * The .append() implementation also accepts Uint8Array and ArrayBuffer objects\n * Web Workers do not natively support FormData:\n *                http://dev.w3.org/html5/workers/#apis-available-to-workers\n * Originally released in 2012 as a part of http://stackoverflow.com/a/10002486.\n * Updates since initial release:\n * - Forward-compatibility by testing whether FormData exists before defining it.\n * - Increased robustness of .append.\n * - Allow any typed array in .append.\n * - Remove use of String.prototype.toString to work around a Firefox bug.\n * - Use typed array in xhr.send instead of arraybuffer to get rid of deprecation\n *   warnings.\n **/\n(function(exports) {\n    if (exports.FormData) {\n        // Don't replace FormData if it already exists\n        return;\n    }\n    // Export variable to the global scope\n    exports.FormData = FormData;\n\n    var ___send$rw = XMLHttpRequest.prototype.send;\n    XMLHttpRequest.prototype.send = function(data) {\n        if (data instanceof FormData) {\n            if (!data.__endedMultipart) data.__append('--' + data.boundary + '--\\r\\n');\n            data.__endedMultipart = true;\n            this.setRequestHeader('Content-Type', 'multipart/form-data; boundary=' + data.boundary);\n            data = new Uint8Array(data.data);\n        }\n        // Invoke original XHR.send\n        return ___send$rw.call(this, data);\n    };\n\n    function FormData() {\n        // Force a Constructor\n        if (!(this instanceof FormData)) return new FormData();\n        // Generate a random boundary - This must be unique with respect to the form's contents.\n        this.boundary = '------RWWorkerFormDataBoundary' + Math.random().toString(36);\n        var internal_data = this.data = [];\n        /**\n         * Internal method.\n         * @param inp String | ArrayBuffer | Uint8Array  Input\n         */\n        this.__append = function(inp) {\n            var i = 0, len;\n            if (typeof inp == 'string') {\n                for (len = inp.length; i < len; ++i)\n                    internal_data.push(inp.charCodeAt(i) & 0xff);\n            } else if (inp && inp.byteLength) {/*If ArrayBuffer or typed array */\n                if (!('byteOffset' in inp))   /* If ArrayBuffer, wrap in view */\n                    inp = new Uint8Array(inp);\n                for (len = inp.byteLength; i < len; ++i)\n                    internal_data.push(inp[i] & 0xff);\n            }\n        };\n    }\n    /**\n     * @param name     String                                   Key name\n     * @param value    String|Blob|File|typed array|ArrayBuffer Value\n     * @param filename String                                   Optional File name (when value is not a string).\n     **/\n    FormData.prototype.append = function(name, value, filename) {\n        if (this.__endedMultipart) {\n            // Truncate the closing boundary\n            this.data.length -= this.boundary.length + 6;\n            this.__endedMultipart = false;\n        }\n        if (arguments.length < 2) {\n            throw new SyntaxError('Not enough arguments');\n        }\n        var part = '--' + this.boundary + '\\r\\n' +\n            'Content-Disposition: form-data; name=\"' + name + '\"';\n\n        if (value instanceof File || value instanceof Blob) {\n            return this.append(name,\n                new Uint8Array(new FileReaderSync().readAsArrayBuffer(value)),\n                filename || value.name);\n        } else if (typeof value.byteLength == 'number') {\n            // Duck-typed typed array or array buffer\n            part += '; filename=\"'+ (filename || 'blob').replace(/\"/g,'%22') +'\"\\r\\n';\n            part += 'Content-Type: application/octet-stream\\r\\n\\r\\n';\n            this.__append(part);\n            this.__append(value);\n            part = '\\r\\n';\n        } else {\n            part += '\\r\\n\\r\\n' + value + '\\r\\n';\n        }\n        this.__append(part);\n    };\n})(this || self);\n","moment-timezone-with-data.js":"//! moment-timezone.js\n//! version : 0.5.5\n//! author : Tim Wood\n//! license : MIT\n//! github.com/moment/moment-timezone\n!function(a,b){\"use strict\";\"function\"==typeof define&&define.amd?define([\"moment\"],b):\"object\"==typeof module&&module.exports?module.exports=b(require(\"moment\")):b(a.moment)}(this,function(a){\"use strict\";function b(a){return a>96?a-87:a>64?a-29:a-48}function c(a){var c,d=0,e=a.split(\".\"),f=e[0],g=e[1]||\"\",h=1,i=0,j=1;for(45===a.charCodeAt(0)&&(d=1,j=-1),d;d<f.length;d++)c=b(f.charCodeAt(d)),i=60*i+c;for(d=0;d<g.length;d++)h/=60,c=b(g.charCodeAt(d)),i+=c*h;return i*j}function d(a){for(var b=0;b<a.length;b++)a[b]=c(a[b])}function e(a,b){for(var c=0;c<b;c++)a[c]=Math.round((a[c-1]||0)+6e4*a[c]);a[b-1]=1/0}function f(a,b){var c,d=[];for(c=0;c<b.length;c++)d[c]=a[b[c]];return d}function g(a){var b=a.split(\"|\"),c=b[2].split(\" \"),g=b[3].split(\"\"),h=b[4].split(\" \");return d(c),d(g),d(h),e(h,g.length),{name:b[0],abbrs:f(b[1].split(\" \"),g),offsets:f(c,g),untils:h,population:0|b[5]}}function h(a){a&&this._set(g(a))}function i(a){var b=a.toTimeString(),c=b.match(/\\([a-z ]+\\)/i);c&&c[0]?(c=c[0].match(/[A-Z]/g),c=c?c.join(\"\"):void 0):(c=b.match(/[A-Z]{3,5}/g),c=c?c[0]:void 0),\"GMT\"===c&&(c=void 0),this.at=+a,this.abbr=c,this.offset=a.getTimezoneOffset()}function j(a){this.zone=a,this.offsetScore=0,this.abbrScore=0}function k(a,b){for(var c,d;d=6e4*((b.at-a.at)/12e4|0);)c=new i(new Date(a.at+d)),c.offset===a.offset?a=c:b=c;return a}function l(){var a,b,c,d=(new Date).getFullYear()-2,e=new i(new Date(d,0,1)),f=[e];for(c=1;c<48;c++)b=new i(new Date(d,c,1)),b.offset!==e.offset&&(a=k(e,b),f.push(a),f.push(new i(new Date(a.at+6e4)))),e=b;for(c=0;c<4;c++)f.push(new i(new Date(d+c,0,1))),f.push(new i(new Date(d+c,6,1)));return f}function m(a,b){return a.offsetScore!==b.offsetScore?a.offsetScore-b.offsetScore:a.abbrScore!==b.abbrScore?a.abbrScore-b.abbrScore:b.zone.population-a.zone.population}function n(a,b){var c,e;for(d(b),c=0;c<b.length;c++)e=b[c],I[e]=I[e]||{},I[e][a]=!0}function o(a){var b,c,d,e=a.length,f={},g=[];for(b=0;b<e;b++){d=I[a[b].offset]||{};for(c in d)d.hasOwnProperty(c)&&(f[c]=!0)}for(b in f)f.hasOwnProperty(b)&&g.push(H[b]);return g}function p(){try{var a=Intl.DateTimeFormat().resolvedOptions().timeZone;if(a){var b=H[r(a)];if(b)return b;z(\"Moment Timezone found \"+a+\" from the Intl api, but did not have that data loaded.\")}}catch(c){}var d,e,f,g=l(),h=g.length,i=o(g),k=[];for(e=0;e<i.length;e++){for(d=new j(t(i[e]),h),f=0;f<h;f++)d.scoreOffsetAt(g[f]);k.push(d)}return k.sort(m),k.length>0?k[0].zone.name:void 0}function q(a){return D&&!a||(D=p()),D}function r(a){return(a||\"\").toLowerCase().replace(/\\//g,\"_\")}function s(a){var b,c,d,e;for(\"string\"==typeof a&&(a=[a]),b=0;b<a.length;b++)d=a[b].split(\"|\"),c=d[0],e=r(c),F[e]=a[b],H[e]=c,d[5]&&n(e,d[2].split(\" \"))}function t(a,b){a=r(a);var c,d=F[a];return d instanceof h?d:\"string\"==typeof d?(d=new h(d),F[a]=d,d):G[a]&&b!==t&&(c=t(G[a],t))?(d=F[a]=new h,d._set(c),d.name=H[a],d):null}function u(){var a,b=[];for(a in H)H.hasOwnProperty(a)&&(F[a]||F[G[a]])&&H[a]&&b.push(H[a]);return b.sort()}function v(a){var b,c,d,e;for(\"string\"==typeof a&&(a=[a]),b=0;b<a.length;b++)c=a[b].split(\"|\"),d=r(c[0]),e=r(c[1]),G[d]=e,H[d]=c[0],G[e]=d,H[e]=c[1]}function w(a){s(a.zones),v(a.links),A.dataVersion=a.version}function x(a){return x.didShowError||(x.didShowError=!0,z(\"moment.tz.zoneExists('\"+a+\"') has been deprecated in favor of !moment.tz.zone('\"+a+\"')\")),!!t(a)}function y(a){return!(!a._a||void 0!==a._tzm)}function z(a){\"undefined\"!=typeof console&&\"function\"==typeof console.error&&console.error(a)}function A(b){var c=Array.prototype.slice.call(arguments,0,-1),d=arguments[arguments.length-1],e=t(d),f=a.utc.apply(null,c);return e&&!a.isMoment(b)&&y(f)&&f.add(e.parse(f),\"minutes\"),f.tz(d),f}function B(a){return function(){return this._z?this._z.abbr(this):a.call(this)}}function C(a){return function(){return this._z=null,a.apply(this,arguments)}}if(void 0!==a.tz)return z(\"Moment Timezone \"+a.tz.version+\" was already loaded \"+(a.tz.dataVersion?\"with data from \":\"without any data\")+a.tz.dataVersion),a;var D,E=\"0.5.5\",F={},G={},H={},I={},J=a.version.split(\".\"),K=+J[0],L=+J[1];(K<2||2===K&&L<6)&&z(\"Moment Timezone requires Moment.js >= 2.6.0. You are using Moment.js \"+a.version+\". See momentjs.com\"),h.prototype={_set:function(a){this.name=a.name,this.abbrs=a.abbrs,this.untils=a.untils,this.offsets=a.offsets,this.population=a.population},_index:function(a){var b,c=+a,d=this.untils;for(b=0;b<d.length;b++)if(c<d[b])return b},parse:function(a){var b,c,d,e,f=+a,g=this.offsets,h=this.untils,i=h.length-1;for(e=0;e<i;e++)if(b=g[e],c=g[e+1],d=g[e?e-1:e],b<c&&A.moveAmbiguousForward?b=c:b>d&&A.moveInvalidForward&&(b=d),f<h[e]-6e4*b)return g[e];return g[i]},abbr:function(a){return this.abbrs[this._index(a)]},offset:function(a){return this.offsets[this._index(a)]}},j.prototype.scoreOffsetAt=function(a){this.offsetScore+=Math.abs(this.zone.offset(a.at)-a.offset),this.zone.abbr(a.at).replace(/[^A-Z]/g,\"\")!==a.abbr&&this.abbrScore++},A.version=E,A.dataVersion=\"\",A._zones=F,A._links=G,A._names=H,A.add=s,A.link=v,A.load=w,A.zone=t,A.zoneExists=x,A.guess=q,A.names=u,A.Zone=h,A.unpack=g,A.unpackBase60=c,A.needsOffset=y,A.moveInvalidForward=!0,A.moveAmbiguousForward=!1;var M=a.fn;a.tz=A,a.defaultZone=null,a.updateOffset=function(b,c){var d,e=a.defaultZone;void 0===b._z&&(e&&y(b)&&!b._isUTC&&(b._d=a.utc(b._a)._d,b.utc().add(e.parse(b),\"minutes\")),b._z=e),b._z&&(d=b._z.offset(b),Math.abs(d)<16&&(d/=60),void 0!==b.utcOffset?b.utcOffset(-d,c):b.zone(d,c))},M.tz=function(b){return b?(this._z=t(b),this._z?a.updateOffset(this):z(\"Moment Timezone has no data for \"+b+\". See http://momentjs.com/timezone/docs/#/data-loading/.\"),this):this._z?this._z.name:void 0},M.zoneName=B(M.zoneName),M.zoneAbbr=B(M.zoneAbbr),M.utc=C(M.utc),a.tz.setDefault=function(b){return(K<2||2===K&&L<9)&&z(\"Moment Timezone setDefault() requires Moment.js >= 2.9.0. You are using Moment.js \"+a.version+\".\"),a.defaultZone=b?t(b):null,a};var N=a.momentProperties;return\"[object Array]\"===Object.prototype.toString.call(N)?(N.push(\"_z\"),N.push(\"_a\")):N&&(N._z=null),w({version:\"2016f\",zones:[\"Africa/Abidjan|LMT GMT|g.8 0|01|-2ldXH.Q|48e5\",\"Africa/Accra|LMT GMT GHST|.Q 0 -k|012121212121212121212121212121212121212121212121|-26BbX.8 6tzX.8 MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE|41e5\",\"Africa/Nairobi|LMT EAT BEAT BEAUT|-2r.g -30 -2u -2J|01231|-1F3Cr.g 3Dzr.g okMu MFXJ|47e5\",\"Africa/Algiers|PMT WET WEST CET CEST|-9.l 0 -10 -10 -20|0121212121212121343431312123431213|-2nco9.l cNb9.l HA0 19A0 1iM0 11c0 1oo0 Wo0 1rc0 QM0 1EM0 UM0 DA0 Imo0 rd0 De0 9Xz0 1fb0 1ap0 16K0 2yo0 mEp0 hwL0 jxA0 11A0 dDd0 17b0 11B0 1cN0 2Dy0 1cN0 1fB0 1cL0|26e5\",\"Africa/Lagos|LMT WAT|-d.A -10|01|-22y0d.A|17e6\",\"Africa/Bissau|LMT WAT GMT|12.k 10 0|012|-2ldWV.E 2xonV.E|39e4\",\"Africa/Maputo|LMT CAT|-2a.k -20|01|-2GJea.k|26e5\",\"Africa/Cairo|EET EEST|-20 -30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-1bIO0 vb0 1ip0 11z0 1iN0 1nz0 12p0 1pz0 10N0 1pz0 16p0 1jz0 s3d0 Vz0 1oN0 11b0 1oO0 10N0 1pz0 10N0 1pb0 10N0 1pb0 10N0 1pb0 10N0 1pz0 10N0 1pb0 10N0 1pb0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1WL0 rd0 1Rz0 wp0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1qL0 Xd0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1ny0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 WL0 1qN0 Rb0 1wp0 On0 1zd0 Lz0 1EN0 Fb0 c10 8n0 8Nd0 gL0 e10 mn0|15e6\",\"Africa/Casablanca|LMT WET WEST CET|u.k 0 -10 -10|0121212121212121213121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2gMnt.E 130Lt.E rb0 Dd0 dVb0 b6p0 TX0 EoB0 LL0 gnd0 rz0 43d0 AL0 1Nd0 XX0 1Cp0 pz0 dEp0 4mn0 SyN0 AL0 1Nd0 wn0 1FB0 Db0 1zd0 Lz0 1Nf0 wM0 co0 go0 1o00 s00 dA0 vc0 11A0 A00 e00 y00 11A0 uM0 e00 Dc0 11A0 s00 e00 IM0 WM0 mo0 gM0 LA0 WM0 jA0 e00 Rc0 11A0 e00 e00 U00 11A0 8o0 e00 11A0 11A0 5A0 e00 17c0 1fA0 1a00 1a00 1fA0 17c0 1io0 14o0 1lc0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1lc0 14o0 1fA0|32e5\",\"Africa/Ceuta|WET WEST CET CEST|0 -10 -10 -20|010101010101010101010232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-25KN0 11z0 drd0 18o0 3I00 17c0 1fA0 1a00 1io0 1a00 1y7p0 LL0 gnd0 rz0 43d0 AL0 1Nd0 XX0 1Cp0 pz0 dEp0 4VB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|85e3\",\"Africa/El_Aaiun|LMT WAT WET WEST|Q.M 10 0 -10|01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1rDz7.c 1GVA7.c 6L0 AL0 1Nd0 XX0 1Cp0 pz0 1cBB0 AL0 1Nd0 wn0 1FB0 Db0 1zd0 Lz0 1Nf0 wM0 co0 go0 1o00 s00 dA0 vc0 11A0 A00 e00 y00 11A0 uM0 e00 Dc0 11A0 s00 e00 IM0 WM0 mo0 gM0 LA0 WM0 jA0 e00 Rc0 11A0 e00 e00 U00 11A0 8o0 e00 11A0 11A0 5A0 e00 17c0 1fA0 1a00 1a00 1fA0 17c0 1io0 14o0 1lc0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1lc0 14o0 1fA0|20e4\",\"Africa/Johannesburg|SAST SAST SAST|-1u -20 -30|012121|-2GJdu 1Ajdu 1cL0 1cN0 1cL0|84e5\",\"Africa/Khartoum|LMT CAT CAST EAT|-2a.8 -20 -30 -30|01212121212121212121212121212121213|-1yW2a.8 1zK0a.8 16L0 1iN0 17b0 1jd0 17b0 1ip0 17z0 1i10 17X0 1hB0 18n0 1hd0 19b0 1gp0 19z0 1iN0 17b0 1ip0 17z0 1i10 18n0 1hd0 18L0 1gN0 19b0 1gp0 19z0 1iN0 17z0 1i10 17X0 yGd0|51e5\",\"Africa/Monrovia|MMT LRT GMT|H.8 I.u 0|012|-23Lzg.Q 29s01.m|11e5\",\"Africa/Ndjamena|LMT WAT WAST|-10.c -10 -20|0121|-2le10.c 2J3c0.c Wn0|13e5\",\"Africa/Tripoli|LMT CET CEST EET|-Q.I -10 -20 -20|012121213121212121212121213123123|-21JcQ.I 1hnBQ.I vx0 4iP0 xx0 4eN0 Bb0 7ip0 U0n0 A10 1db0 1cN0 1db0 1dd0 1db0 1eN0 1bb0 1e10 1cL0 1c10 1db0 1dd0 1db0 1cN0 1db0 1q10 fAn0 1ep0 1db0 AKq0 TA0 1o00|11e5\",\"Africa/Tunis|PMT CET CEST|-9.l -10 -20|0121212121212121212121212121212121|-2nco9.l 18pa9.l 1qM0 DA0 3Tc0 11B0 1ze0 WM0 7z0 3d0 14L0 1cN0 1f90 1ar0 16J0 1gXB0 WM0 1rA0 11c0 nwo0 Ko0 1cM0 1cM0 1rA0 10M0 zuM0 10N0 1aN0 1qM0 WM0 1qM0 11A0 1o00|20e5\",\"Africa/Windhoek|SWAT SAST SAST CAT WAT WAST|-1u -20 -30 -20 -10 -20|012134545454545454545454545454545454545454545454545454545454545454545454545454545454545454545|-2GJdu 1Ajdu 1cL0 1SqL0 9NA0 11D0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 11B0 1nX0 11B0|32e4\",\"America/Adak|NST NWT NPT BST BDT AHST HST HDT|b0 a0 a0 b0 a0 a0 a0 90|012034343434343434343434343434343456767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17SX0 8wW0 iB0 Qlb0 52O0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cm0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|326\",\"America/Anchorage|CAT CAWT CAPT AHST AHDT YST AKST AKDT|a0 90 90 a0 90 90 90 80|012034343434343434343434343434343456767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17T00 8wX0 iA0 Qlb0 52O0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cm0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|30e4\",\"America/Port_of_Spain|LMT AST|46.4 40|01|-2kNvR.U|43e3\",\"America/Araguaina|LMT BRT BRST|3c.M 30 20|0121212121212121212121212121212121212121212121212121|-2glwL.c HdKL.c 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 dMN0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 ny10 Lz0|14e4\",\"America/Argentina/Buenos_Aires|CMT ART ARST ART ARST|4g.M 40 30 30 20|0121212121212121212121212121212121212121213434343434343234343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 g0p0 10M0 j3c0 uL0 1qN0 WL0\",\"America/Argentina/Catamarca|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343454343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 ako0 7B0 8zb0 uL0\",\"America/Argentina/Cordoba|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343454343234343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 j3c0 uL0 1qN0 WL0\",\"America/Argentina/Jujuy|CMT ART ARST ART ARST WART WARST|4g.M 40 30 30 20 40 30|01212121212121212121212121212121212121212134343456543432343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1ze0 TX0 1ld0 WK0 1wp0 TX0 g0p0 10M0 j3c0 uL0\",\"America/Argentina/La_Rioja|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|01212121212121212121212121212121212121212134343434534343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Qn0 qO0 16n0 Rb0 1wp0 TX0 g0p0 10M0 ako0 7B0 8zb0 uL0\",\"America/Argentina/Mendoza|CMT ART ARST ART ARST WART WARST|4g.M 40 30 30 20 40 30|0121212121212121212121212121212121212121213434345656543235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1u20 SL0 1vd0 Tb0 1wp0 TW0 g0p0 10M0 agM0 Op0 7TX0 uL0\",\"America/Argentina/Rio_Gallegos|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343434343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 g0p0 10M0 ako0 7B0 8zb0 uL0\",\"America/Argentina/Salta|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|01212121212121212121212121212121212121212134343434543432343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 j3c0 uL0\",\"America/Argentina/San_Juan|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|01212121212121212121212121212121212121212134343434534343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Qn0 qO0 16n0 Rb0 1wp0 TX0 g0p0 10M0 ak00 m10 8lb0 uL0\",\"America/Argentina/San_Luis|CMT ART ARST ART ARST WART WARST|4g.M 40 30 30 20 40 30|01212121212121212121212121212121212121212134343456536353465653|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 XX0 1q20 SL0 AN0 kin0 10M0 ak00 m10 8lb0 8L0 jd0 1qN0 WL0 1qN0\",\"America/Argentina/Tucuman|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|012121212121212121212121212121212121212121343434345434323534343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 ako0 4N0 8BX0 uL0 1qN0 WL0\",\"America/Argentina/Ushuaia|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343434343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 g0p0 10M0 ajA0 8p0 8zb0 uL0\",\"America/Curacao|LMT ANT AST|4z.L 4u 40|012|-2kV7o.d 28KLS.d|15e4\",\"America/Asuncion|AMT PYT PYT PYST|3O.E 40 30 30|012131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313|-1x589.k 1DKM9.k 3CL0 3Dd0 10L0 1pB0 10n0 1pB0 10n0 1pB0 1cL0 1dd0 1db0 1dd0 1cL0 1dd0 1cL0 1dd0 1cL0 1dd0 1db0 1dd0 1cL0 1dd0 1cL0 1dd0 1cL0 1dd0 1db0 1dd0 1cL0 1lB0 14n0 1dd0 1cL0 1fd0 WL0 1rd0 1aL0 1dB0 Xz0 1qp0 Xb0 1qN0 10L0 1rB0 TX0 1tB0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 1cL0 WN0 1qL0 11B0 1nX0 1ip0 WL0 1qN0 WL0 1qN0 WL0 1tB0 TX0 1tB0 TX0 1tB0 19X0 1a10 1fz0 1a10 1fz0 1cN0 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0|28e5\",\"America/Atikokan|CST CDT CWT CPT EST|60 50 50 50 50|0101234|-25TQ0 1in0 Rnb0 3je0 8x30 iw0|28e2\",\"America/Bahia|LMT BRT BRST|2y.4 30 20|01212121212121212121212121212121212121212121212121212121212121|-2glxp.U HdLp.U 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 l5B0 Rb0|27e5\",\"America/Bahia_Banderas|LMT MST CST PST MDT CDT|71 70 60 80 60 50|0121212131414141414141414141414141414152525252525252525252525252525252525252525252525252525252|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 otX0 gmN0 P2N0 13Vd0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nW0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|84e3\",\"America/Barbados|LMT BMT AST ADT|3W.t 3W.t 40 30|01232323232|-1Q0I1.v jsM0 1ODC1.v IL0 1ip0 17b0 1ip0 17b0 1ld0 13b0|28e4\",\"America/Belem|LMT BRT BRST|3d.U 30 20|012121212121212121212121212121|-2glwK.4 HdKK.4 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0|20e5\",\"America/Belize|LMT CST CHDT CDT|5Q.M 60 5u 50|01212121212121212121212121212121212121212121212121213131|-2kBu7.c fPA7.c Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1f0Mu qn0 lxB0 mn0|57e3\",\"America/Blanc-Sablon|AST ADT AWT APT|40 30 30 30|010230|-25TS0 1in0 UGp0 8x50 iu0|11e2\",\"America/Boa_Vista|LMT AMT AMST|42.E 40 30|0121212121212121212121212121212121|-2glvV.k HdKV.k 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 smp0 WL0 1tB0 2L0|62e2\",\"America/Bogota|BMT COT COST|4U.g 50 40|0121|-2eb73.I 38yo3.I 2en0|90e5\",\"America/Boise|PST PDT MST MWT MPT MDT|80 70 70 60 60 60|0101023425252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252|-261q0 1nX0 11B0 1nX0 8C10 JCL0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 Dd0 1Kn0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|21e4\",\"America/Cambridge_Bay|-00 MST MWT MPT MDDT MDT CST CDT EST|0 70 60 60 50 60 60 50 50|0123141515151515151515151515151515151515151515678651515151515151515151515151515151515151515151515151515151515151515151515151|-21Jc0 RO90 8x20 ix0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11A0 1nX0 2K0 WQ0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|15e2\",\"America/Campo_Grande|LMT AMT AMST|3C.s 40 30|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-2glwl.w HdLl.w 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 1C10 Lz0 1Ip0 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0|77e4\",\"America/Cancun|LMT CST EST EDT CDT|5L.4 60 50 40 50|0123232341414141414141414141414141414141412|-1UQG0 2q2o0 yLB0 1lb0 14p0 1lb0 14p0 Lz0 xB0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 Dd0|63e4\",\"America/Caracas|CMT VET VET|4r.E 4u 40|01212|-2kV7w.k 28KM2.k 1IwOu kqo0|29e5\",\"America/Cayenne|LMT GFT GFT|3t.k 40 30|012|-2mrwu.E 2gWou.E|58e3\",\"America/Panama|CMT EST|5j.A 50|01|-2uduE.o|15e5\",\"America/Chicago|CST CDT EST CWT CPT|60 50 50 50 50|01010101010101010101010101010101010102010101010103401010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 1wp0 TX0 WN0 1qL0 1cN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 11B0 1Hz0 14p0 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 RB0 8x30 iw0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|92e5\",\"America/Chihuahua|LMT MST CST CDT MDT|74.k 70 60 50 60|0121212323241414141414141414141414141414141414141414141414141414141414141414141414141414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 2zQN0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|81e4\",\"America/Costa_Rica|SJMT CST CDT|5A.d 60 50|0121212121|-1Xd6n.L 2lu0n.L Db0 1Kp0 Db0 pRB0 15b0 1kp0 mL0|12e5\",\"America/Creston|MST PST|70 80|010|-29DR0 43B0|53e2\",\"America/Cuiaba|LMT AMT AMST|3I.k 40 30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-2glwf.E HdLf.E 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 4a10 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0|54e4\",\"America/Danmarkshavn|LMT WGT WGST GMT|1e.E 30 20 0|01212121212121212121212121212121213|-2a5WJ.k 2z5fJ.k 19U0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 DC0|8\",\"America/Dawson|YST YDT YWT YPT YDDT PST PDT|90 80 80 80 70 80 70|0101023040565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565|-25TN0 1in0 1o10 13V0 Ser0 8x00 iz0 LCL0 1fA0 jrA0 fNd0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|13e2\",\"America/Dawson_Creek|PST PDT PWT PPT MST|80 70 70 70 70|0102301010101010101010101010101010101010101010101010101014|-25TO0 1in0 UGp0 8x10 iy0 3NB0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 ML0|12e3\",\"America/Denver|MST MDT MWT MPT|70 60 60 60|01010101023010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261r0 1nX0 11B0 1nX0 11B0 1qL0 WN0 mn0 Ord0 8x20 ix0 LCN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|26e5\",\"America/Detroit|LMT CST EST EWT EPT EDT|5w.b 60 50 40 40 40|01234252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252|-2Cgir.N peqr.N 156L0 8x40 iv0 6fd0 11z0 Jy10 SL0 dnB0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|37e5\",\"America/Edmonton|LMT MST MDT MWT MPT|7x.Q 70 60 60 60|01212121212121341212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2yd4q.8 shdq.8 1in0 17d0 hz0 2dB0 1fz0 1a10 11z0 1qN0 WL0 1qN0 11z0 IGN0 8x20 ix0 3NB0 11z0 LFB0 1cL0 3Cp0 1cL0 66N0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|10e5\",\"America/Eirunepe|LMT ACT ACST AMT|4D.s 50 40 40|0121212121212121212121212121212131|-2glvk.w HdLk.w 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 dPB0 On0 yTd0 d5X0|31e3\",\"America/El_Salvador|LMT CST CDT|5U.M 60 50|012121|-1XiG3.c 2Fvc3.c WL0 1qN0 WL0|11e5\",\"America/Tijuana|LMT MST PST PDT PWT PPT|7M.4 70 80 70 70 70|012123245232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1UQE0 4PX0 8mM0 8lc0 SN0 1cL0 pHB0 83r0 zI0 5O10 1Rz0 cOP0 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 BUp0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|20e5\",\"America/Fort_Nelson|PST PDT PWT PPT MST|80 70 70 70 70|01023010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010104|-25TO0 1in0 UGp0 8x10 iy0 3NB0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0|39e2\",\"America/Fort_Wayne|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|010101023010101010101010101040454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 QI10 Db0 RB0 8x30 iw0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 5Tz0 1o10 qLb0 1cL0 1cN0 1cL0 1qhd0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Fortaleza|LMT BRT BRST|2y 30 20|0121212121212121212121212121212121212121|-2glxq HdLq 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 5z0 2mN0 On0|34e5\",\"America/Glace_Bay|LMT AST ADT AWT APT|3X.M 40 30 30 30|012134121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2IsI0.c CwO0.c 1in0 UGp0 8x50 iu0 iq10 11z0 Jg10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|19e3\",\"America/Godthab|LMT WGT WGST|3q.U 30 20|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2a5Ux.4 2z5dx.4 19U0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|17e3\",\"America/Goose_Bay|NST NDT NST NDT NWT NPT AST ADT ADDT|3u.Q 2u.Q 3u 2u 2u 2u 40 30 20|010232323232323245232323232323232323232323232323232323232326767676767676767676767676767676767676767676768676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-25TSt.8 1in0 DXb0 2HbX.8 WL0 1qN0 WL0 1qN0 WL0 1tB0 TX0 1tB0 WL0 1qN0 WL0 1qN0 7UHu itu 1tB0 WL0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1tB0 WL0 1ld0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 S10 g0u 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14n1 1lb0 14p0 1nW0 11C0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zcX Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|76e2\",\"America/Grand_Turk|KMT EST EDT AST|57.b 50 40 40|0121212121212121212121212121212121212121212121212121212121212121212121212123|-2l1uQ.N 2HHBQ.N 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|37e2\",\"America/Guatemala|LMT CST CDT|62.4 60 50|0121212121|-24KhV.U 2efXV.U An0 mtd0 Nz0 ifB0 17b0 zDB0 11z0|13e5\",\"America/Guayaquil|QMT ECT|5e 50|01|-1yVSK|27e5\",\"America/Guyana|LMT GBGT GYT GYT GYT|3Q.E 3J 3J 30 40|01234|-2dvU7.k 24JzQ.k mlc0 Bxbf|80e4\",\"America/Halifax|LMT AST ADT AWT APT|4e.o 40 30 30 30|0121212121212121212121212121212121212121212121212134121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2IsHJ.A xzzJ.A 1db0 3I30 1in0 3HX0 IL0 1E10 ML0 1yN0 Pb0 1Bd0 Mn0 1Bd0 Rz0 1w10 Xb0 1w10 LX0 1w10 Xb0 1w10 Lz0 1C10 Jz0 1E10 OL0 1yN0 Un0 1qp0 Xb0 1qp0 11X0 1w10 Lz0 1HB0 LX0 1C10 FX0 1w10 Xb0 1qp0 Xb0 1BB0 LX0 1td0 Xb0 1qp0 Xb0 Rf0 8x50 iu0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 3Qp0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 3Qp0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 6i10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|39e4\",\"America/Havana|HMT CST CDT|5t.A 50 40|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1Meuu.o 72zu.o ML0 sld0 An0 1Nd0 Db0 1Nd0 An0 6Ep0 An0 1Nd0 An0 JDd0 Mn0 1Ap0 On0 1fd0 11X0 1qN0 WL0 1wp0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 14n0 1ld0 14L0 1kN0 15b0 1kp0 1cL0 1cN0 1fz0 1a10 1fz0 1fB0 11z0 14p0 1nX0 11B0 1nX0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 14n0 1ld0 14n0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 1a10 1in0 1a10 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 17c0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 11A0 6i00 Rc0 1wo0 U00 1tA0 Rc0 1wo0 U00 1wo0 U00 1zc0 U00 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0|21e5\",\"America/Hermosillo|LMT MST CST PST MDT|7n.Q 70 60 80 60|0121212131414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 otX0 gmN0 P2N0 13Vd0 1lb0 14p0 1lb0 14p0 1lb0|64e4\",\"America/Indiana/Knox|CST CDT CWT CPT EST|60 50 50 50 50|0101023010101010101010101010101010101040101010101010101010101010101010101010101010101010141010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 3NB0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 11z0 1o10 11z0 1o10 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 3Cn0 8wp0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 z8o0 1o00 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Marengo|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|0101023010101010101010104545454545414545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 dyN0 11z0 6fd0 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 jrz0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1VA0 LA0 1BX0 1e6p0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Petersburg|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010104010101010101010101010141014545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 njX0 WN0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 3Fb0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 19co0 1o00 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Tell_City|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010101010454541010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 g0p0 11z0 1o10 11z0 1qL0 WN0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 caL0 1cL0 1cN0 1cL0 1qhd0 1o00 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Vevay|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|010102304545454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 kPB0 Awn0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1lnd0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Vincennes|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010101010454541014545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 g0p0 11z0 1o10 11z0 1qL0 WN0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 caL0 1cL0 1cN0 1cL0 1qhd0 1o00 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Winamac|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010101010101010454541054545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 jrz0 1cL0 1cN0 1cL0 1qhd0 1o00 Rd0 1za0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Inuvik|-00 PST PDDT MST MDT|0 80 60 70 60|0121343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|-FnA0 tWU0 1fA0 wPe0 2pz0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|35e2\",\"America/Iqaluit|-00 EWT EPT EST EDDT EDT CST CDT|0 40 40 50 30 40 60 50|01234353535353535353535353535353535353535353567353535353535353535353535353535353535353535353535353535353535353535353535353|-16K00 7nX0 iv0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11C0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|67e2\",\"America/Jamaica|KMT EST EDT|57.b 50 40|0121212121212121212121|-2l1uQ.N 2uM1Q.N 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0|94e4\",\"America/Juneau|PST PWT PPT PDT YDT YST AKST AKDT|80 70 70 70 80 90 90 80|01203030303030303030303030403030356767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17T20 8x10 iy0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cM0 1cM0 1cL0 1cN0 1fz0 1a10 1fz0 co0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|33e3\",\"America/Kentucky/Louisville|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|0101010102301010101010101010101010101454545454545414545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 3Fd0 Nb0 LPd0 11z0 RB0 8x30 iw0 Bb0 10N0 2bB0 8in0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 xz0 gso0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1VA0 LA0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Kentucky/Monticello|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|0101023010101010101010101010101010101010101010101010101010101010101010101454545454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 SWp0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/La_Paz|CMT BOST BOT|4w.A 3w.A 40|012|-1x37r.o 13b0|19e5\",\"America/Lima|LMT PET PEST|58.A 50 40|0121212121212121|-2tyGP.o 1bDzP.o zX0 1aN0 1cL0 1cN0 1cL0 1PrB0 zX0 1O10 zX0 6Gp0 zX0 98p0 zX0|11e6\",\"America/Los_Angeles|PST PDT PWT PPT|80 70 70 70|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261q0 1nX0 11B0 1nX0 SgN0 8x10 iy0 5Wp0 1Vb0 3dB0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|15e6\",\"America/Maceio|LMT BRT BRST|2m.Q 30 20|012121212121212121212121212121212121212121|-2glxB.8 HdLB.8 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 dMN0 Lz0 8Q10 WL0 1tB0 5z0 2mN0 On0|93e4\",\"America/Managua|MMT CST EST CDT|5J.c 60 50 50|0121313121213131|-1quie.M 1yAMe.M 4mn0 9Up0 Dz0 1K10 Dz0 s3F0 1KH0 DB0 9In0 k8p0 19X0 1o30 11y0|22e5\",\"America/Manaus|LMT AMT AMST|40.4 40 30|01212121212121212121212121212121|-2glvX.U HdKX.U 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 dPB0 On0|19e5\",\"America/Martinique|FFMT AST ADT|44.k 40 30|0121|-2mPTT.E 2LPbT.E 19X0|39e4\",\"America/Matamoros|LMT CST CDT|6E 60 50|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1UQG0 2FjC0 1nX0 i6p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|45e4\",\"America/Mazatlan|LMT MST CST PST MDT|75.E 70 60 80 60|0121212131414141414141414141414141414141414141414141414141414141414141414141414141414141414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 otX0 gmN0 P2N0 13Vd0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|44e4\",\"America/Menominee|CST CDT CWT CPT EST|60 50 50 50 50|01010230101041010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 LCN0 1fz0 6410 9Jb0 1cM0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|85e2\",\"America/Merida|LMT CST EST CDT|5W.s 60 50 50|0121313131313131313131313131313131313131313131313131313131313131313131313131313131313131|-1UQG0 2q2o0 2hz0 wu30 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|11e5\",\"America/Metlakatla|PST PWT PPT PDT AKST AKDT|80 70 70 70 90 80|0120303030303030303030303030303030454545454545454545454545454545454545454545454|-17T20 8x10 iy0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1hU10 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|14e2\",\"America/Mexico_City|LMT MST CST CDT CWT|6A.A 70 60 50 50|012121232324232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 gEn0 TX0 3xd0 Jb0 6zB0 SL0 e5d0 17b0 1Pff0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|20e6\",\"America/Miquelon|LMT AST PMST PMDT|3I.E 40 30 20|012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-2mKkf.k 2LTAf.k gQ10 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|61e2\",\"America/Moncton|EST AST ADT AWT APT|50 40 30 30 30|012121212121212121212134121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2IsH0 CwN0 1in0 zAo0 An0 1Nd0 An0 1Nd0 An0 1Nd0 An0 1Nd0 An0 1Nd0 An0 1K10 Lz0 1zB0 NX0 1u10 Wn0 S20 8x50 iu0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 3Cp0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14n1 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 ReX 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|64e3\",\"America/Monterrey|LMT CST CDT|6F.g 60 50|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1UQG0 2FjC0 1nX0 i6p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|41e5\",\"America/Montevideo|MMT UYT UYHST UYST UYT UYHST|3I.I 3u 30 20 30 2u|012121212121212121212121213434343434345454543453434343434343434343434343434343434343434|-20UIf.g 8jzJ.g 1cLu 1dcu 1cLu 1dcu 1cLu ircu 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 1qMu WLu 1qMu WLu 1qMu 11zu 1o0u 11zu NAu 11bu 2iMu zWu Dq10 19X0 pd0 jz0 cm10 19X0 1fB0 1on0 11d0 1oL0 1nB0 1fzu 1aou 1fzu 1aou 1fzu 3nAu Jb0 3MN0 1SLu 4jzu 2PB0 Lb0 3Dd0 1pb0 ixd0 An0 1MN0 An0 1wp0 On0 1wp0 Rb0 1zd0 On0 1wp0 Rb0 s8p0 1fB0 1ip0 11z0 1ld0 14n0 1o10 11z0 1o10 11z0 1o10 14n0 1ld0 14n0 1ld0 14n0 1o10 11z0 1o10 11z0 1o10 11z0|17e5\",\"America/Toronto|EST EDT EWT EPT|50 40 40 40|01010101010101010101010101010101010101010101012301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TR0 1in0 11Wu 1nzu 1fD0 WJ0 1wr0 Nb0 1Ap0 On0 1zd0 On0 1wp0 TX0 1tB0 TX0 1tB0 TX0 1tB0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 4kM0 8x40 iv0 1o10 11z0 1nX0 11z0 1o10 11z0 1o10 1qL0 11D0 1nX0 11B0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|65e5\",\"America/Nassau|LMT EST EDT|59.u 50 40|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2kNuO.u 26XdO.u 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|24e4\",\"America/New_York|EST EDT EWT EPT|50 40 40 40|01010101010101010101010101010101010101010101010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261t0 1nX0 11B0 1nX0 11B0 1qL0 1a10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 RB0 8x40 iv0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|21e6\",\"America/Nipigon|EST EDT EWT EPT|50 40 40 40|010123010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TR0 1in0 Rnb0 3je0 8x40 iv0 19yN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|16e2\",\"America/Nome|NST NWT NPT BST BDT YST AKST AKDT|b0 a0 a0 b0 a0 90 90 80|012034343434343434343434343434343456767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17SX0 8wW0 iB0 Qlb0 52O0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cl0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|38e2\",\"America/Noronha|LMT FNT FNST|29.E 20 10|0121212121212121212121212121212121212121|-2glxO.k HdKO.k 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 2L0 2pB0 On0|30e2\",\"America/North_Dakota/Beulah|MST MDT MWT MPT CST CDT|70 60 60 60 60 50|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101014545454545454545454545454545454545454545454545454545454|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/North_Dakota/Center|MST MDT MWT MPT CST CDT|70 60 60 60 60 50|010102301010101010101010101010101010101010101010101010101014545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14o0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/North_Dakota/New_Salem|MST MDT MWT MPT CST CDT|70 60 60 60 60 50|010102301010101010101010101010101010101010101010101010101010101010101010101010101454545454545454545454545454545454545454545454545454545454545454545454|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14o0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Ojinaga|LMT MST CST CDT MDT|6V.E 70 60 50 60|0121212323241414141414141414141414141414141414141414141414141414141414141414141414141414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 2zQN0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e3\",\"America/Pangnirtung|-00 AST AWT APT ADDT ADT EDT EST CST CDT|0 40 30 30 20 30 40 50 60 50|012314151515151515151515151515151515167676767689767676767676767676767676767676767676767676767676767676767676767676767676767|-1XiM0 PnG0 8x50 iu0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1o00 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11C0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|14e2\",\"America/Paramaribo|LMT PMT PMT NEGT SRT SRT|3E.E 3E.Q 3E.A 3u 3u 30|012345|-2nDUj.k Wqo0.c qanX.I 1dmLN.o lzc0|24e4\",\"America/Phoenix|MST MDT MWT|70 60 60|01010202010|-261r0 1nX0 11B0 1nX0 SgN0 4Al1 Ap0 1db0 SWqX 1cL0|42e5\",\"America/Port-au-Prince|PPMT EST EDT|4N 50 40|01212121212121212121212121212121212121212121|-28RHb 2FnMb 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14q0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 i6n0 1nX0 11B0 1nX0 d430 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e5\",\"America/Rio_Branco|LMT ACT ACST AMT|4v.c 50 40 40|01212121212121212121212121212131|-2glvs.M HdLs.M 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 NBd0 d5X0|31e4\",\"America/Porto_Velho|LMT AMT AMST|4f.A 40 30|012121212121212121212121212121|-2glvI.o HdKI.o 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0|37e4\",\"America/Puerto_Rico|AST AWT APT|40 30 30|0120|-17lU0 7XT0 iu0|24e5\",\"America/Rainy_River|CST CDT CWT CPT|60 50 50 50|010123010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TQ0 1in0 Rnb0 3je0 8x30 iw0 19yN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|842\",\"America/Rankin_Inlet|-00 CST CDDT CDT EST|0 60 40 50 50|012131313131313131313131313131313131313131313431313131313131313131313131313131313131313131313131313131313131313131313131|-vDc0 keu0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|26e2\",\"America/Recife|LMT BRT BRST|2j.A 30 20|0121212121212121212121212121212121212121|-2glxE.o HdLE.o 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 2L0 2pB0 On0|33e5\",\"America/Regina|LMT MST MDT MWT MPT CST|6W.A 70 60 60 60 60|012121212121212121212121341212121212121212121212121215|-2AD51.o uHe1.o 1in0 s2L0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 66N0 1cL0 1cN0 19X0 1fB0 1cL0 1fB0 1cL0 1cN0 1cL0 M30 8x20 ix0 1ip0 1cL0 1ip0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 3NB0 1cL0 1cN0|19e4\",\"America/Resolute|-00 CST CDDT CDT EST|0 60 40 50 50|012131313131313131313131313131313131313131313431313131313431313131313131313131313131313131313131313131313131313131313131|-SnA0 GWS0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|229\",\"America/Santarem|LMT AMT AMST BRT|3C.M 40 30 30|0121212121212121212121212121213|-2glwl.c HdLl.c 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 NBd0|21e4\",\"America/Santiago|SMT CLT CLT CLST CLST|4G.K 50 40 40 30|010203131313131212421242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424|-2q2jh.e fJAh.e 5knG.K 1Vzh.e jRAG.K 1pbh.e 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 nHX0 op0 9Bz0 jb0 1oN0 ko0 Qeo0 WL0 1zd0 On0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0|62e5\",\"America/Santo_Domingo|SDMT EST EDT EHDT AST|4E 50 40 4u 40|01213131313131414|-1ttjk 1lJMk Mn0 6sp0 Lbu 1Cou yLu 1RAu wLu 1QMu xzu 1Q0u xXu 1PAu 13jB0 e00|29e5\",\"America/Sao_Paulo|LMT BRT BRST|36.s 30 20|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-2glwR.w HdKR.w 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 pTd0 PX0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 1C10 Lz0 1Ip0 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0|20e6\",\"America/Scoresbysund|LMT CGT CGST EGST EGT|1r.Q 20 10 0 10|0121343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434|-2a5Ww.8 2z5ew.8 1a00 1cK0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|452\",\"America/Sitka|PST PWT PPT PDT YST AKST AKDT|80 70 70 70 90 90 80|01203030303030303030303030303030345656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565|-17T20 8x10 iy0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 co0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|90e2\",\"America/St_Johns|NST NDT NST NDT NWT NPT NDDT|3u.Q 2u.Q 3u 2u 2u 2u 1u|01010101010101010101010101010101010102323232323232324523232323232323232323232323232323232323232323232323232323232323232323232323232323232326232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-28oit.8 14L0 1nB0 1in0 1gm0 Dz0 1JB0 1cL0 1cN0 1cL0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 1cL0 1cN0 1cL0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 1cL0 1fB0 19X0 1fB0 19X0 10O0 eKX.8 19X0 1iq0 WL0 1qN0 WL0 1qN0 WL0 1tB0 TX0 1tB0 WL0 1qN0 WL0 1qN0 7UHu itu 1tB0 WL0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1tB0 WL0 1ld0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14n1 1lb0 14p0 1nW0 11C0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zcX Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|11e4\",\"America/Swift_Current|LMT MST MDT MWT MPT CST|7b.k 70 60 60 60 60|012134121212121212121215|-2AD4M.E uHdM.E 1in0 UGp0 8x20 ix0 1o10 17b0 1ip0 11z0 1o10 11z0 1o10 11z0 isN0 1cL0 3Cp0 1cL0 1cN0 11z0 1qN0 WL0 pMp0|16e3\",\"America/Tegucigalpa|LMT CST CDT|5M.Q 60 50|01212121|-1WGGb.8 2ETcb.8 WL0 1qN0 WL0 GRd0 AL0|11e5\",\"America/Thule|LMT AST ADT|4z.8 40 30|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2a5To.Q 31NBo.Q 1cL0 1cN0 1cL0 1fB0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|656\",\"America/Thunder_Bay|CST EST EWT EPT EDT|60 50 40 40 40|0123141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141|-2q5S0 1iaN0 8x40 iv0 XNB0 1cL0 1cN0 1fz0 1cN0 1cL0 3Cp0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|11e4\",\"America/Vancouver|PST PDT PWT PPT|80 70 70 70|0102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TO0 1in0 UGp0 8x10 iy0 1o10 17b0 1ip0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e5\",\"America/Whitehorse|YST YDT YWT YPT YDDT PST PDT|90 80 80 80 70 80 70|0101023040565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565|-25TN0 1in0 1o10 13V0 Ser0 8x00 iz0 LCL0 1fA0 3NA0 vrd0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e3\",\"America/Winnipeg|CST CDT CWT CPT|60 50 50 50|010101023010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aIi0 WL0 3ND0 1in0 Jap0 Rb0 aCN0 8x30 iw0 1tB0 11z0 1ip0 11z0 1o10 11z0 1o10 11z0 1rd0 10L0 1op0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 1cL0 1cN0 11z0 6i10 WL0 6i10 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|66e4\",\"America/Yakutat|YST YWT YPT YDT AKST AKDT|90 80 80 80 90 80|01203030303030303030303030303030304545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-17T10 8x00 iz0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cn0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|642\",\"America/Yellowknife|-00 MST MWT MPT MDDT MDT|0 70 60 60 50 60|012314151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151|-1pdA0 hix0 8x20 ix0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|19e3\",\"Antarctica/Casey|-00 AWST CAST|0 -80 -b0|012121|-2q00 1DjS0 T90 40P0 KL0|10\",\"Antarctica/Davis|-00 DAVT DAVT|0 -70 -50|01012121|-vyo0 iXt0 alj0 1D7v0 VB0 3Wn0 KN0|70\",\"Antarctica/DumontDUrville|-00 PMT DDUT|0 -a0 -a0|0102|-U0o0 cfq0 bFm0|80\",\"Antarctica/Macquarie|AEST AEDT -00 MIST|-a0 -b0 0 -b0|0102010101010101010101010101010101010101010101010101010101010101010101010101010101010101013|-29E80 19X0 4SL0 1ayy0 Lvs0 1cM0 1o00 Rc0 1wo0 Rc0 1wo0 U00 1wo0 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0|1\",\"Antarctica/Mawson|-00 MAWT MAWT|0 -60 -50|012|-CEo0 2fyk0|60\",\"Pacific/Auckland|NZMT NZST NZST NZDT|-bu -cu -c0 -d0|01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323|-1GCVu Lz0 1tB0 11zu 1o0u 11zu 1o0u 11zu 1o0u 14nu 1lcu 14nu 1lcu 1lbu 11Au 1nXu 11Au 1nXu 11Au 1nXu 11Au 1nXu 11Au 1qLu WMu 1qLu 11Au 1n1bu IM0 1C00 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1qM0 14o0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1io0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00|14e5\",\"Antarctica/Palmer|-00 ARST ART ART ARST CLT CLST|0 30 40 30 20 40 30|0121212121234356565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656|-cao0 nD0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 jsN0 14N0 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0|40\",\"Antarctica/Rothera|-00 ROTT|0 30|01|gOo0|130\",\"Antarctica/Syowa|-00 SYOT|0 -30|01|-vs00|20\",\"Antarctica/Troll|-00 UTC CEST|0 0 -20|01212121212121212121212121212121212121212121212121212121212121212121|1puo0 hd0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|40\",\"Antarctica/Vostok|-00 VOST|0 -60|01|-tjA0|25\",\"Europe/Oslo|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2awM0 Qm0 W6o0 5pf0 WM0 1fA0 1cM0 1cM0 1cM0 1cM0 wJc0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1qM0 WM0 zpc0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|62e4\",\"Asia/Riyadh|LMT AST|-36.Q -30|01|-TvD6.Q|57e5\",\"Asia/Almaty|LMT +05 +06 +07|-57.M -50 -60 -70|012323232323232323232321232323232323232323232323232|-1Pc57.M eUo7.M 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0|15e5\",\"Asia/Amman|LMT EET EEST|-2n.I -20 -30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1yW2n.I 1HiMn.I KL0 1oN0 11b0 1oN0 11b0 1pd0 1dz0 1cp0 11b0 1op0 11b0 fO10 1db0 1e10 1cL0 1cN0 1cL0 1cN0 1fz0 1pd0 10n0 1ld0 14n0 1hB0 15b0 1ip0 19X0 1cN0 1cL0 1cN0 17b0 1ld0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1So0 y00 1fc0 1dc0 1co0 1dc0 1cM0 1cM0 1cM0 1o00 11A0 1lc0 17c0 1cM0 1cM0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 4bX0 Dd0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0|25e5\",\"Asia/Anadyr|LMT ANAT ANAT ANAST ANAST ANAST ANAT|-bN.U -c0 -d0 -e0 -d0 -c0 -b0|01232414141414141414141561414141414141414141414141414141414141561|-1PcbN.U eUnN.U 23CL0 1db0 1cN0 1dc0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qN0 WM0|13e3\",\"Asia/Aqtau|LMT +04 +05 +06|-3l.4 -40 -50 -60|012323232323232323232123232312121212121212121212|-1Pc3l.4 eUnl.4 24PX0 2pX0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|15e4\",\"Asia/Aqtobe|LMT +04 +05 +06|-3M.E -40 -50 -60|0123232323232323232321232323232323232323232323232|-1Pc3M.E eUnM.E 23CL0 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0|27e4\",\"Asia/Ashgabat|LMT ASHT ASHT ASHST ASHST TMT TMT|-3R.w -40 -50 -60 -50 -40 -50|012323232323232323232324156|-1Pc3R.w eUnR.w 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 ba0 xC0|41e4\",\"Asia/Baghdad|BMT AST ADT|-2V.A -30 -40|012121212121212121212121212121212121212121212121212121|-26BeV.A 2ACnV.A 11b0 1cp0 1dz0 1dd0 1db0 1cN0 1cp0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1de0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0|66e5\",\"Asia/Qatar|LMT GST AST|-3q.8 -40 -30|012|-21Jfq.8 27BXq.8|96e4\",\"Asia/Baku|LMT BAKT BAKT BAKST BAKST AZST AZT AZT AZST|-3j.o -30 -40 -50 -40 -40 -30 -40 -50|01232323232323232323232456578787878787878787878787878787878787878787|-1Pc3j.o 1jUoj.o WCL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 10K0 c30 1cM0 1cM0 8wq0 1o00 11z0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00|27e5\",\"Asia/Bangkok|BMT ICT|-6G.4 -70|01|-218SG.4|15e6\",\"Asia/Barnaul|LMT +06 +07 +08|-5z -60 -70 -80|0123232323232323232323212323232321212121212121212121212121212121212|-21S5z pCnz 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 p90 LE0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0\",\"Asia/Beirut|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-21aq0 1on0 1410 1db0 19B0 1in0 1ip0 WL0 1lQp0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 q6N0 En0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1op0 11b0 dA10 17b0 1iN0 17b0 1iN0 17b0 1iN0 17b0 1vB0 SL0 1mp0 13z0 1iN0 17b0 1iN0 17b0 1jd0 12n0 1a10 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0|22e5\",\"Asia/Bishkek|LMT FRUT FRUT FRUST FRUST KGT KGST KGT|-4W.o -50 -60 -70 -60 -50 -60 -60|01232323232323232323232456565656565656565656565656567|-1Pc4W.o eUnW.o 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 11c0 1tX0 17b0 1ip0 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1cPu 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 T8u|87e4\",\"Asia/Brunei|LMT BNT BNT|-7D.E -7u -80|012|-1KITD.E gDc9.E|42e4\",\"Asia/Kolkata|HMT BURT IST IST|-5R.k -6u -5u -6u|01232|-18LFR.k 1unn.k HB0 7zX0|15e6\",\"Asia/Chita|LMT YAKT YAKT YAKST YAKST YAKT IRKT|-7x.Q -80 -90 -a0 -90 -a0 -80|0123232323232323232323241232323232323232323232323232323232323232562|-21Q7x.Q pAnx.Q 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3re0|33e4\",\"Asia/Choibalsan|LMT ULAT ULAT CHOST CHOT CHOT CHOST|-7C -70 -80 -a0 -90 -80 -90|0123434343434343434343434343434343434343434343456565656565656565656565656565656565656565656565|-2APHC 2UkoC cKn0 1da0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 3Db0 h1f0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0|38e3\",\"Asia/Shanghai|CST CDT|-80 -90|01010101010101010|-1c1I0 LX0 16p0 1jz0 1Myp0 Rb0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0|23e6\",\"Asia/Colombo|MMT IST IHST IST LKT LKT|-5j.w -5u -60 -6u -6u -60|01231451|-2zOtj.w 1rFbN.w 1zzu 7Apu 23dz0 11zu n3cu|22e5\",\"Asia/Dhaka|HMT BURT IST DACT BDT BDST|-5R.k -6u -5u -60 -60 -70|01213454|-18LFR.k 1unn.k HB0 m6n0 LqMu 1x6n0 1i00|16e6\",\"Asia/Damascus|LMT EET EEST|-2p.c -20 -30|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-21Jep.c Hep.c 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1xRB0 11X0 1oN0 10L0 1pB0 11b0 1oN0 10L0 1mp0 13X0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 Nb0 1AN0 Nb0 bcp0 19X0 1gp0 19X0 3ld0 1xX0 Vd0 1Bz0 Sp0 1vX0 10p0 1dz0 1cN0 1cL0 1db0 1db0 1g10 1an0 1ap0 1db0 1fd0 1db0 1cN0 1db0 1dd0 1db0 1cp0 1dz0 1c10 1dX0 1cN0 1db0 1dd0 1db0 1cN0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1db0 1cN0 1db0 1cN0 19z0 1fB0 1qL0 11B0 1on0 Wp0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0|26e5\",\"Asia/Dili|LMT TLT JST TLT WITA|-8m.k -80 -90 -90 -80|012343|-2le8m.k 1dnXm.k 8HA0 1ew00 Xld0|19e4\",\"Asia/Dubai|LMT GST|-3F.c -40|01|-21JfF.c|39e5\",\"Asia/Dushanbe|LMT DUST DUST DUSST DUSST TJT|-4z.c -50 -60 -70 -60 -50|0123232323232323232323245|-1Pc4z.c eUnz.c 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 14N0|76e4\",\"Asia/Gaza|EET EET EEST IST IDT|-20 -30 -30 -20 -30|010101010102020202020202020202023434343434343434343434343430202020202020202020202020202020202020202020202020202020202020202020202020202020202020|-1c2q0 5Rb0 10r0 1px0 10N0 1pz0 16p0 1jB0 16p0 1jx0 pBd0 Vz0 1oN0 11b0 1oO0 10N0 1pz0 10N0 1pb0 10N0 1pb0 10N0 1pb0 10N0 1pz0 10N0 1pb0 10N0 1pb0 11d0 1oL0 dW0 hfB0 Db0 1fB0 Rb0 npB0 11z0 1C10 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 M10 C00 17c0 1io0 17c0 1io0 17c0 1o00 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 17c0 1io0 18N0 1bz0 19z0 1gp0 1610 1iL0 11z0 1o10 14o0 1lA1 SKX 1xd1 MKX 1AN0 1a00 1fA0 1cL0 1cN0 1nX0 1210 1nz0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0|18e5\",\"Asia/Hebron|EET EET EEST IST IDT|-20 -30 -30 -20 -30|01010101010202020202020202020202343434343434343434343434343020202020202020202020202020202020202020202020202020202020202020202020202020202020202020|-1c2q0 5Rb0 10r0 1px0 10N0 1pz0 16p0 1jB0 16p0 1jx0 pBd0 Vz0 1oN0 11b0 1oO0 10N0 1pz0 10N0 1pb0 10N0 1pb0 10N0 1pb0 10N0 1pz0 10N0 1pb0 10N0 1pb0 11d0 1oL0 dW0 hfB0 Db0 1fB0 Rb0 npB0 11z0 1C10 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 M10 C00 17c0 1io0 17c0 1io0 17c0 1o00 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 17c0 1io0 18N0 1bz0 19z0 1gp0 1610 1iL0 12L0 1mN0 14o0 1lc0 Tb0 1xd1 MKX bB0 cn0 1cN0 1a00 1fA0 1cL0 1cN0 1nX0 1210 1nz0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0|25e4\",\"Asia/Ho_Chi_Minh|LMT PLMT ICT IDT JST|-76.E -76.u -70 -80 -90|0123423232|-2yC76.E bK00.a 1h7b6.u 5lz0 18o0 3Oq0 k5b0 aW00 BAM0|90e5\",\"Asia/Hong_Kong|LMT HKT HKST JST|-7A.G -80 -90 -90|0121312121212121212121212121212121212121212121212121212121212121212121|-2CFHA.G 1sEP6.G 1cL0 ylu 93X0 1qQu 1tX0 Rd0 1In0 NB0 1cL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1kL0 14N0 1nX0 U10 1tz0 U10 1wn0 Rd0 1wn0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1wn0 Rd0 1wn0 Rd0 1wn0 U10 1tz0 U10 1tz0 17d0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1cL0 6fd0 14n0|73e5\",\"Asia/Hovd|LMT HOVT HOVT HOVST|-66.A -60 -70 -80|012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-2APG6.A 2Uko6.A cKn0 1db0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 kEp0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0|81e3\",\"Asia/Irkutsk|IMT IRKT IRKT IRKST IRKST IRKT|-6V.5 -70 -80 -90 -80 -90|012323232323232323232324123232323232323232323232323232323232323252|-21zGV.5 pjXV.5 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|60e4\",\"Europe/Istanbul|IMT EET EEST TRST TRT|-1U.U -20 -30 -40 -30|012121212121212121212121212121212121212121212121212121234343434342121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ogNU.U dzzU.U 11b0 8tB0 1on0 1410 1db0 19B0 1in0 3Rd0 Un0 1oN0 11b0 zSp0 CL0 mN0 1Vz0 1gN0 1pz0 5Rd0 1fz0 1yp0 ML0 1kp0 17b0 1ip0 17b0 1fB0 19X0 1jB0 18L0 1ip0 17z0 qdd0 xX0 3S10 Tz0 dA10 11z0 1o10 11z0 1qN0 11z0 1ze0 11B0 WM0 1qO0 WI0 1nX0 1rB0 10L0 11B0 1in0 17d0 1in0 2pX0 19E0 1fU0 16Q0 1iI0 16Q0 1iI0 1Vd0 pb0 3Kp0 14o0 1df0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WO0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 Xc0 1qo0 WM0 1qM0 11A0 1o00 1200 1nA0 11A0 1tA0 U00 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|13e6\",\"Asia/Jakarta|BMT JAVT WIB JST WIB WIB|-77.c -7k -7u -90 -80 -70|01232425|-1Q0Tk luM0 mPzO 8vWu 6kpu 4PXu xhcu|31e6\",\"Asia/Jayapura|LMT WIT ACST|-9m.M -90 -9u|0121|-1uu9m.M sMMm.M L4nu|26e4\",\"Asia/Jerusalem|JMT IST IDT IDDT|-2k.E -20 -30 -40|01212121212132121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-26Bek.E SyMk.E 5Rb0 10r0 1px0 10N0 1pz0 16p0 1jB0 16p0 1jx0 3LB0 Em0 or0 1cn0 1dB0 16n0 10O0 1ja0 1tC0 14o0 1cM0 1a00 11A0 1Na0 An0 1MP0 AJ0 1Kp0 LC0 1oo0 Wl0 EQN0 Db0 1fB0 Rb0 npB0 11z0 1C10 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 1hB0 1dX0 1ep0 1aL0 1eN0 17X0 1nf0 11z0 1tB0 19W0 1e10 17b0 1ep0 1gL0 18N0 1fz0 1eN0 17b0 1gq0 1gn0 19d0 1dz0 1c10 17X0 1hB0 1gn0 19d0 1dz0 1c10 17X0 1kp0 1dz0 1c10 1aL0 1eN0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0|81e4\",\"Asia/Kabul|AFT AFT|-40 -4u|01|-10Qs0|46e5\",\"Asia/Kamchatka|LMT PETT PETT PETST PETST|-ay.A -b0 -c0 -d0 -c0|01232323232323232323232412323232323232323232323232323232323232412|-1SLKy.A ivXy.A 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qN0 WM0|18e4\",\"Asia/Karachi|LMT IST IST KART PKT PKST|-4s.c -5u -6u -50 -50 -60|012134545454|-2xoss.c 1qOKW.c 7zX0 eup0 LqMu 1fy00 1cL0 dK10 11b0 1610 1jX0|24e6\",\"Asia/Urumqi|LMT XJT|-5O.k -60|01|-1GgtO.k|32e5\",\"Asia/Kathmandu|LMT IST NPT|-5F.g -5u -5J|012|-21JhF.g 2EGMb.g|12e5\",\"Asia/Khandyga|LMT YAKT YAKT YAKST YAKST VLAT VLAST VLAT YAKT|-92.d -80 -90 -a0 -90 -a0 -b0 -b0 -a0|01232323232323232323232412323232323232323232323232565656565656565782|-21Q92.d pAp2.d 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 qK0 yN0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 17V0 7zD0|66e2\",\"Asia/Krasnoyarsk|LMT KRAT KRAT KRAST KRAST KRAT|-6b.q -60 -70 -80 -70 -80|012323232323232323232324123232323232323232323232323232323232323252|-21Hib.q prAb.q 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|10e5\",\"Asia/Kuala_Lumpur|SMT MALT MALST MALT MALT JST MYT|-6T.p -70 -7k -7k -7u -90 -80|01234546|-2Bg6T.p 17anT.p 7hXE dM00 17bO 8Fyu 1so1u|71e5\",\"Asia/Kuching|LMT BORT BORT BORTST JST MYT|-7l.k -7u -80 -8k -90 -80|01232323232323232425|-1KITl.k gDbP.k 6ynu AnE 1O0k AnE 1NAk AnE 1NAk AnE 1NAk AnE 1O0k AnE 1NAk AnE pAk 8Fz0 1so10|13e4\",\"Asia/Macau|LMT MOT MOST CST|-7y.k -80 -90 -80|0121212121212121212121212121212121212121213|-2le7y.k 1XO34.k 1wn0 Rd0 1wn0 R9u 1wqu U10 1tz0 TVu 1tz0 17gu 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cJu 1cL0 1cN0 1fz0 1cN0 1cOu 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cJu 1cL0 1cN0 1fz0 1cN0 1cL0 KEp0|57e4\",\"Asia/Magadan|LMT MAGT MAGT MAGST MAGST MAGT|-a3.c -a0 -b0 -c0 -b0 -c0|0123232323232323232323241232323232323232323232323232323232323232512|-1Pca3.c eUo3.c 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3Cq0|95e3\",\"Asia/Makassar|LMT MMT WITA JST|-7V.A -7V.A -80 -90|01232|-21JjV.A vfc0 myLV.A 8ML0|15e5\",\"Asia/Manila|PHT PHST JST|-80 -90 -90|010201010|-1kJI0 AL0 cK10 65X0 mXB0 vX0 VK10 1db0|24e6\",\"Asia/Nicosia|LMT EET EEST|-2d.s -20 -30|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1Vc2d.s 2a3cd.s 1cL0 1qp0 Xz0 19B0 19X0 1fB0 1db0 1cp0 1cL0 1fB0 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1o30 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|32e4\",\"Asia/Novokuznetsk|LMT +06 +07 +08|-5M.M -60 -70 -80|012323232323232323232321232323232323232323232323232323232323212|-1PctM.M eULM.M 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0|55e4\",\"Asia/Novosibirsk|LMT +06 +07 +08|-5v.E -60 -70 -80|0123232323232323232323212323212121212121212121212121212121212121212|-21Qnv.E pAFv.E 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 ml0 Os0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 4eN0|15e5\",\"Asia/Omsk|LMT OMST OMST OMSST OMSST OMST|-4R.u -50 -60 -70 -60 -70|012323232323232323232324123232323232323232323232323232323232323252|-224sR.u pMLR.u 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|12e5\",\"Asia/Oral|LMT +04 +05 +06|-3p.o -40 -50 -60|01232323232323232121212121212121212121212121212|-1Pc3p.o eUnp.o 23CL0 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 1cM0 IM0 1EM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|27e4\",\"Asia/Pontianak|LMT PMT WIB JST WIB WITA WIB|-7h.k -7h.k -7u -90 -80 -80 -70|012324256|-2ua7h.k XE00 munL.k 8Rau 6kpu 4PXu xhcu Wqnu|23e4\",\"Asia/Pyongyang|LMT KST JCST JST KST|-8n -8u -90 -90 -90|012341|-2um8n 97XR 12FXu jdA0 2Onc0|29e5\",\"Asia/Qyzylorda|LMT +04 +05 +06|-4l.Q -40 -50 -60|0123232323232323232323232323232323232323232323|-1Pc4l.Q eUol.Q 23CL0 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 3ao0 1EM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|73e4\",\"Asia/Rangoon|RMT BURT JST MMT|-6o.E -6u -90 -6u|0123|-21Jio.E SmnS.E 7j9u|48e5\",\"Asia/Sakhalin|LMT JCST JST SAKT SAKST SAKST SAKT|-9u.M -90 -90 -b0 -c0 -b0 -a0|01234343434343434343434356343434343435656565656565656565656565656363|-2AGVu.M 1iaMu.M je00 1qFa0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o10 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0|58e4\",\"Asia/Samarkand|LMT SAMT SAMT SAMST TAST UZST UZT|-4r.R -40 -50 -60 -60 -60 -50|01234323232323232323232356|-1Pc4r.R eUor.R 23CL0 1db0 1cM0 1dc0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 11x0 bf0|36e4\",\"Asia/Seoul|LMT KST JCST JST KST KDT KDT|-8r.Q -8u -90 -90 -90 -9u -a0|01234151515151515146464|-2um8r.Q 97XV.Q 12FXu jjA0 kKo0 2I0u OL0 1FB0 Rb0 1qN0 TX0 1tB0 TX0 1tB0 TX0 1tB0 TX0 2ap0 12FBu 11A0 1o00 11A0|23e6\",\"Asia/Singapore|SMT MALT MALST MALT MALT JST SGT SGT|-6T.p -70 -7k -7k -7u -90 -7u -80|012345467|-2Bg6T.p 17anT.p 7hXE dM00 17bO 8Fyu Mspu DTA0|56e5\",\"Asia/Srednekolymsk|LMT MAGT MAGT MAGST MAGST MAGT SRET|-ae.Q -a0 -b0 -c0 -b0 -c0 -b0|012323232323232323232324123232323232323232323232323232323232323256|-1Pcae.Q eUoe.Q 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|35e2\",\"Asia/Taipei|JWST JST CST CDT|-80 -90 -80 -90|01232323232323232323232323232323232323232|-1iw80 joM0 1yo0 Tz0 1ip0 1jX0 1cN0 11b0 1oN0 11b0 1oN0 11b0 1oN0 11b0 10N0 1BX0 10p0 1pz0 10p0 1pz0 10p0 1db0 1dd0 1db0 1cN0 1db0 1cN0 1db0 1cN0 1db0 1BB0 ML0 1Bd0 ML0 uq10 1db0 1cN0 1db0 97B0 AL0|74e5\",\"Asia/Tashkent|LMT TAST TAST TASST TASST UZST UZT|-4B.b -50 -60 -70 -60 -60 -50|01232323232323232323232456|-1Pc4B.b eUnB.b 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 11y0 bf0|23e5\",\"Asia/Tbilisi|TBMT TBIT TBIT TBIST TBIST GEST GET GET GEST|-2X.b -30 -40 -50 -40 -40 -30 -40 -50|0123232323232323232323245656565787878787878787878567|-1Pc2X.b 1jUnX.b WCL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 3y0 19f0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cM0 1cL0 1fB0 3Nz0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 An0 Os0 WM0|11e5\",\"Asia/Tehran|LMT TMT IRST IRST IRDT IRDT|-3p.I -3p.I -3u -40 -50 -4u|01234325252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252|-2btDp.I 1d3c0 1huLT.I TXu 1pz0 sN0 vAu 1cL0 1dB0 1en0 pNB0 UL0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 64p0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0|14e6\",\"Asia/Thimphu|LMT IST BTT|-5W.A -5u -60|012|-Su5W.A 1BGMs.A|79e3\",\"Asia/Tokyo|JCST JST JDT|-90 -90 -a0|0121212121|-1iw90 pKq0 QL0 1lB0 13X0 1zB0 NX0 1zB0 NX0|38e6\",\"Asia/Tomsk|LMT +06 +07 +08|-5D.P -60 -70 -80|0123232323232323232323212323232323232323232323212121212121212121212|-21NhD.P pxzD.P 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 co0 1bB0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3Qp0|10e5\",\"Asia/Ulaanbaatar|LMT ULAT ULAT ULAST|-77.w -70 -80 -90|012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-2APH7.w 2Uko7.w cKn0 1db0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 kEp0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0|12e5\",\"Asia/Ust-Nera|LMT YAKT YAKT MAGST MAGT MAGST MAGT MAGT VLAT VLAT|-9w.S -80 -90 -c0 -b0 -b0 -a0 -c0 -b0 -a0|0123434343434343434343456434343434343434343434343434343434343434789|-21Q9w.S pApw.S 23CL0 1d90 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 17V0 7zD0|65e2\",\"Asia/Vladivostok|LMT VLAT VLAT VLAST VLAST VLAT|-8L.v -90 -a0 -b0 -a0 -b0|012323232323232323232324123232323232323232323232323232323232323252|-1SJIL.v itXL.v 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|60e4\",\"Asia/Yakutsk|LMT YAKT YAKT YAKST YAKST YAKT|-8C.W -80 -90 -a0 -90 -a0|012323232323232323232324123232323232323232323232323232323232323252|-21Q8C.W pAoC.W 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|28e4\",\"Asia/Yekaterinburg|LMT PMT SVET SVET SVEST SVEST YEKT YEKST YEKT|-42.x -3J.5 -40 -50 -60 -50 -50 -60 -60|0123434343434343434343435267676767676767676767676767676767676767686|-2ag42.x 7mQh.s qBvJ.5 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|14e5\",\"Asia/Yerevan|LMT YERT YERT YERST YERST AMST AMT AMT AMST|-2W -30 -40 -50 -40 -40 -30 -40 -50|0123232323232323232323245656565657878787878787878787878787878787|-1Pc2W 1jUnW WCL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1am0 2r0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 3Fb0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0|13e5\",\"Atlantic/Azores|HMT AZOT AZOST AZOMT AZOT AZOST WET|1S.w 20 10 0 10 0 0|01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121454545454545454545454545454545456545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-2ldW5.s aPX5.s Sp0 LX0 1vc0 Tc0 1uM0 SM0 1vc0 Tc0 1vc0 SM0 1vc0 6600 1co0 3E00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 3I00 17c0 1cM0 1cM0 3Fc0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 1tA0 1cM0 1dc0 1400 gL0 IM0 s10 U00 dX0 Rc0 pd0 Rc0 gL0 Oo0 pd0 Rc0 gL0 Oo0 pd0 14o0 1cM0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 3Co0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 qIl0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|25e4\",\"Atlantic/Bermuda|LMT AST ADT|4j.i 40 30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1BnRE.G 1LTbE.G 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|65e3\",\"Atlantic/Canary|LMT CANT WET WEST|11.A 10 0 -10|01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1UtaW.o XPAW.o 1lAK0 1a10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|54e4\",\"Atlantic/Cape_Verde|LMT CVT CVST CVT|1y.4 20 10 10|01213|-2xomp.U 1qOMp.U 7zX0 1djf0|50e4\",\"Atlantic/Faroe|LMT WET WEST|r.4 0 -10|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2uSnw.U 2Wgow.U 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|49e3\",\"Atlantic/Madeira|FMT MADT MADST MADMT WET WEST|17.A 10 0 -10 0 -10|01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-2ldWQ.o aPWQ.o Sp0 LX0 1vc0 Tc0 1uM0 SM0 1vc0 Tc0 1vc0 SM0 1vc0 6600 1co0 3E00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 3I00 17c0 1cM0 1cM0 3Fc0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 1tA0 1cM0 1dc0 1400 gL0 IM0 s10 U00 dX0 Rc0 pd0 Rc0 gL0 Oo0 pd0 Rc0 gL0 Oo0 pd0 14o0 1cM0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 3Co0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 qIl0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|27e4\",\"Atlantic/Reykjavik|LMT IST ISST GMT|1s 10 0 0|012121212121212121212121212121212121212121212121212121212121212121213|-2uWmw mfaw 1Bd0 ML0 1LB0 Cn0 1LB0 3fX0 C10 HrX0 1cO0 LB0 1EL0 LA0 1C00 Oo0 1wo0 Rc0 1wo0 Rc0 1wo0 Rc0 1zc0 Oo0 1zc0 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1lc0 14o0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 14o0|12e4\",\"Atlantic/South_Georgia|GST|20|0||30\",\"Atlantic/Stanley|SMT FKT FKST FKT FKST|3P.o 40 30 30 20|0121212121212134343212121212121212121212121212121212121212121212121212|-2kJw8.A 12bA8.A 19X0 1fB0 19X0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 Cn0 1Cc10 WL0 1qL0 U10 1tz0 U10 1qM0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1tz0 U10 1tz0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1tz0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qN0 U10 1wn0 Rd0 1wn0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1wn0 U10 1tz0 U10 1tz0 U10|21e2\",\"Australia/Sydney|AEST AEDT|-a0 -b0|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 14o0 1o00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 11A0 1o00 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|40e5\",\"Australia/Adelaide|ACST ACDT|-9u -au|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lt xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 Oo0 1zc0 WM0 1qM0 Rc0 1zc0 U00 1tA0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|11e5\",\"Australia/Brisbane|AEST AEDT|-a0 -b0|01010101010101010|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 H1A0 Oo0 1zc0 Oo0 1zc0 Oo0|20e5\",\"Australia/Broken_Hill|ACST ACDT|-9u -au|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lt xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 14o0 1o00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|18e3\",\"Australia/Currie|AEST AEDT|-a0 -b0|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-29E80 19X0 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|746\",\"Australia/Darwin|ACST ACDT|-9u -au|010101010|-293lt xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0|12e4\",\"Australia/Eucla|ACWST ACWDT|-8J -9J|0101010101010101010|-293kI xcX 10jd0 yL0 1cN0 1cL0 1gSp0 Oo0 l5A0 Oo0 iJA0 G00 zU00 IM0 1qM0 11A0 1o00 11A0|368\",\"Australia/Hobart|AEST AEDT|-a0 -b0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-29E80 19X0 10jd0 yL0 1cN0 1cL0 1fB0 19X0 VfB0 1cM0 1o00 Rc0 1wo0 Rc0 1wo0 U00 1wo0 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|21e4\",\"Australia/Lord_Howe|AEST LHST LHDT LHDT|-a0 -au -bu -b0|0121212121313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313|raC0 1zdu Rb0 1zd0 On0 1zd0 On0 1zd0 On0 1zd0 TXu 1qMu WLu 1tAu WLu 1tAu TXu 1tAu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu 11zu 1o0u 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 11Au 1nXu 1qMu 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 1qMu 11zu 1o0u WLu 1qMu 14nu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1fzu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu|347\",\"Australia/Lindeman|AEST AEDT|-a0 -b0|010101010101010101010|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 H1A0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0|10\",\"Australia/Melbourne|AEST AEDT|-a0 -b0|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1qM0 11A0 1tA0 U00 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 11A0 1o00 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|39e5\",\"Australia/Perth|AWST AWDT|-80 -90|0101010101010101010|-293jX xcX 10jd0 yL0 1cN0 1cL0 1gSp0 Oo0 l5A0 Oo0 iJA0 G00 zU00 IM0 1qM0 11A0 1o00 11A0|18e5\",\"CET|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 1cM0 16M0 1gMM0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\",\"CST6CDT|CST CDT CWT CPT|60 50 50 50|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Pacific/Easter|EMT EAST EASST EAST EASST|7h.s 70 60 60 50|0121212121212121212121212121234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434|-1uSgG.w 1s4IG.w WL0 1zd0 On0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0|30e2\",\"EET|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\",\"EST|EST|50|0|\",\"EST5EDT|EST EDT EWT EPT|50 40 40 40|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261t0 1nX0 11B0 1nX0 SgN0 8x40 iv0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Europe/Dublin|DMT IST GMT BST IST|p.l -y.D 0 -10 -10|01232323232324242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242|-2ax9y.D Rc0 1fzy.D 14M0 1fc0 1g00 1co0 1dc0 1co0 1oo0 1400 1dc0 19A0 1io0 1io0 WM0 1o00 14o0 1o00 17c0 1io0 17c0 1fA0 1a00 1lc0 17c0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1cM0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1io0 1qM0 Dc0 g5X0 14p0 1wn0 17d0 1io0 11A0 1o00 17c0 1fA0 1a00 1fA0 1cM0 1fA0 1a00 17c0 1fA0 1a00 1io0 17c0 1lc0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1a00 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1tA0 IM0 90o0 U00 1tA0 U00 1tA0 U00 1tA0 U00 1tA0 WM0 1qM0 WM0 1qM0 WM0 1tA0 U00 1tA0 U00 1tA0 11z0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 14o0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Etc/GMT+0|GMT|0|0|\",\"Etc/GMT+1|GMT+1|10|0|\",\"Etc/GMT+10|GMT+10|a0|0|\",\"Etc/GMT+11|GMT+11|b0|0|\",\"Etc/GMT+12|GMT+12|c0|0|\",\"Etc/GMT+2|GMT+2|20|0|\",\"Etc/GMT+3|GMT+3|30|0|\",\"Etc/GMT+4|GMT+4|40|0|\",\"Etc/GMT+5|GMT+5|50|0|\",\"Etc/GMT+6|GMT+6|60|0|\",\"Etc/GMT+7|GMT+7|70|0|\",\"Etc/GMT+8|GMT+8|80|0|\",\"Etc/GMT+9|GMT+9|90|0|\",\"Etc/GMT-1|GMT-1|-10|0|\",\"Etc/GMT-10|GMT-10|-a0|0|\",\"Etc/GMT-11|GMT-11|-b0|0|\",\"Etc/GMT-12|GMT-12|-c0|0|\",\"Etc/GMT-13|GMT-13|-d0|0|\",\"Etc/GMT-14|GMT-14|-e0|0|\",\"Etc/GMT-2|GMT-2|-20|0|\",\"Etc/GMT-3|GMT-3|-30|0|\",\"Etc/GMT-4|GMT-4|-40|0|\",\"Etc/GMT-5|GMT-5|-50|0|\",\"Etc/GMT-6|GMT-6|-60|0|\",\"Etc/GMT-7|GMT-7|-70|0|\",\"Etc/GMT-8|GMT-8|-80|0|\",\"Etc/GMT-9|GMT-9|-90|0|\",\"Etc/UCT|UCT|0|0|\",\"Etc/UTC|UTC|0|0|\",\"Europe/Amsterdam|AMT NST NEST NET CEST CET|-j.w -1j.w -1k -k -20 -10|010101010101010101010101010101010101010101012323234545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545|-2aFcj.w 11b0 1iP0 11A0 1io0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1co0 1io0 1yo0 Pc0 1a00 1fA0 1Bc0 Mo0 1tc0 Uo0 1tA0 U00 1uo0 W00 1s00 VA0 1so0 Vc0 1sM0 UM0 1wo0 Rc0 1u00 Wo0 1rA0 W00 1s00 VA0 1sM0 UM0 1w00 fV0 BCX.w 1tA0 U00 1u00 Wo0 1sm0 601k WM0 1fA0 1cM0 1cM0 1cM0 16M0 1gMM0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|16e5\",\"Europe/Andorra|WET CET CEST|0 -10 -20|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-UBA0 1xIN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|79e3\",\"Europe/Astrakhan|LMT +03 +04 +05|-3c.c -30 -40 -50|012323232323232323212121212121212121212121212121212121212121212|-1Pcrc.c eUMc.c 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 3Co0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0\",\"Europe/Athens|AMT EET EEST CEST CET|-1y.Q -20 -30 -20 -10|012123434121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2a61x.Q CNbx.Q mn0 kU10 9b0 3Es0 Xa0 1fb0 1dd0 k3X0 Nz0 SCp0 1vc0 SO0 1cM0 1a00 1ao0 1fc0 1a10 1fG0 1cg0 1dX0 1bX0 1cQ0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|35e5\",\"Europe/London|GMT BST BDST|0 -10 -20|0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2axa0 Rc0 1fA0 14M0 1fc0 1g00 1co0 1dc0 1co0 1oo0 1400 1dc0 19A0 1io0 1io0 WM0 1o00 14o0 1o00 17c0 1io0 17c0 1fA0 1a00 1lc0 17c0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1cM0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1io0 1qM0 Dc0 2Rz0 Dc0 1zc0 Oo0 1zc0 Rc0 1wo0 17c0 1iM0 FA0 xB0 1fA0 1a00 14o0 bb0 LA0 xB0 Rc0 1wo0 11A0 1o00 17c0 1fA0 1a00 1fA0 1cM0 1fA0 1a00 17c0 1fA0 1a00 1io0 17c0 1lc0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1a00 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1tA0 IM0 90o0 U00 1tA0 U00 1tA0 U00 1tA0 U00 1tA0 WM0 1qM0 WM0 1qM0 WM0 1tA0 U00 1tA0 U00 1tA0 11z0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 14o0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|10e6\",\"Europe/Belgrade|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-19RC0 3IP0 WM0 1fA0 1cM0 1cM0 1rc0 Qo0 1vmo0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Berlin|CET CEST CEMT|-10 -20 -30|01010101010101210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 1cM0 kL0 Nc0 m10 WM0 1ao0 1cp0 dX0 jz0 Dd0 1io0 17c0 1fA0 1a00 1ehA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|41e5\",\"Europe/Prague|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 16M0 1lc0 1tA0 17A0 11c0 1io0 17c0 1io0 17c0 1fc0 1ao0 1bNc0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|13e5\",\"Europe/Brussels|WET CET CEST WEST|0 -10 -20 -10|0121212103030303030303030303030303030303030303030303212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ehc0 3zX0 11c0 1iO0 11A0 1o00 11A0 my0 Ic0 1qM0 Rc0 1EM0 UM0 1u00 10o0 1io0 1io0 17c0 1a00 1fA0 1cM0 1cM0 1io0 17c0 1fA0 1a00 1io0 1a30 1io0 17c0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 y00 5Wn0 WM0 1fA0 1cM0 16M0 1iM0 16M0 1C00 Uo0 1eeo0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|21e5\",\"Europe/Bucharest|BMT EET EEST|-1I.o -20 -30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1xApI.o 20LI.o RA0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1Axc0 On0 1fA0 1a10 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cK0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cL0 1cN0 1cL0 1fB0 1nX0 11E0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|19e5\",\"Europe/Budapest|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1ip0 17b0 1op0 1tb0 Q2m0 3Ne0 WM0 1fA0 1cM0 1cM0 1oJ0 1dc0 1030 1fA0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1iM0 1fA0 8Ha0 Rb0 1wN0 Rb0 1BB0 Lz0 1C20 LB0 SNX0 1a10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|17e5\",\"Europe/Zurich|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-19Lc0 11A0 1o00 11A0 1xG10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|38e4\",\"Europe/Chisinau|CMT BMT EET EEST CEST CET MSK MSD|-1T -1I.o -20 -30 -20 -10 -30 -40|012323232323232323234545467676767676767676767323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-26jdT wGMa.A 20LI.o RA0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 27A0 2en0 39g0 WM0 1fA0 1cM0 V90 1t7z0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 gL0 WO0 1cM0 1cM0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1nX0 11D0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|67e4\",\"Europe/Copenhagen|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2azC0 Tz0 VuO0 60q0 WM0 1fA0 1cM0 1cM0 1cM0 S00 1HA0 Nc0 1C00 Dc0 1Nc0 Ao0 1h5A0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Gibraltar|GMT BST BDST CET CEST|0 -10 -20 -10 -20|010101010101010101010101010101010101010101010101012121212121010121010101010101010101034343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|-2axa0 Rc0 1fA0 14M0 1fc0 1g00 1co0 1dc0 1co0 1oo0 1400 1dc0 19A0 1io0 1io0 WM0 1o00 14o0 1o00 17c0 1io0 17c0 1fA0 1a00 1lc0 17c0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1cM0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1io0 1qM0 Dc0 2Rz0 Dc0 1zc0 Oo0 1zc0 Rc0 1wo0 17c0 1iM0 FA0 xB0 1fA0 1a00 14o0 bb0 LA0 xB0 Rc0 1wo0 11A0 1o00 17c0 1fA0 1a00 1fA0 1cM0 1fA0 1a00 17c0 1fA0 1a00 1io0 17c0 1lc0 17c0 1fA0 10Jz0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|30e3\",\"Europe/Helsinki|HMT EET EEST|-1D.N -20 -30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1WuND.N OULD.N 1dA0 1xGq0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Kaliningrad|CET CEST CET CEST MSK MSD EEST EET FET|-10 -20 -20 -30 -30 -40 -30 -20 -30|0101010101010232454545454545454546767676767676767676767676767676767676767676787|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 Am0 Lb0 1en0 op0 1pNz0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|44e4\",\"Europe/Kiev|KMT EET MSK CEST CET MSD EEST|-22.4 -20 -30 -20 -10 -40 -30|0123434252525252525252525256161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161|-1Pc22.4 eUo2.4 rnz0 2Hg0 WM0 1fA0 da0 1v4m0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 Db0 3220 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cQ0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|34e5\",\"Europe/Kirov|LMT +03 +04 +05|-3i.M -30 -40 -50|01232323232323232321212121212121212121212121212121212121212121|-22WNi.M qHai.M 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 3Co0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|48e4\",\"Europe/Lisbon|LMT WET WEST WEMT CET CEST|A.J 0 -10 -20 -10 -20|012121212121212121212121212121212121212121212321232123212321212121212121212121212121212121212121214121212121212121212121212121212124545454212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ldXn.f aPWn.f Sp0 LX0 1vc0 Tc0 1uM0 SM0 1vc0 Tc0 1vc0 SM0 1vc0 6600 1co0 3E00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 3I00 17c0 1cM0 1cM0 3Fc0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 1tA0 1cM0 1dc0 1400 gL0 IM0 s10 U00 dX0 Rc0 pd0 Rc0 gL0 Oo0 pd0 Rc0 gL0 Oo0 pd0 14o0 1cM0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 3Co0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 pvy0 1cM0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|27e5\",\"Europe/Luxembourg|LMT CET CEST WET WEST WEST WET|-o.A -10 -20 0 -10 -20 -10|0121212134343434343434343434343434343434343434343434565651212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2DG0o.A t6mo.A TB0 1nX0 Up0 1o20 11A0 rW0 CM0 1qP0 R90 1EO0 UK0 1u20 10m0 1ip0 1in0 17e0 19W0 1fB0 1db0 1cp0 1in0 17d0 1fz0 1a10 1in0 1a10 1in0 17f0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 vA0 60L0 WM0 1fA0 1cM0 17c0 1io0 16M0 1C00 Uo0 1eeo0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|54e4\",\"Europe/Madrid|WET WEST WEMT CET CEST|0 -10 -20 -10 -20|01010101010101010101010121212121234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|-28dd0 11A0 1go0 19A0 1co0 1dA0 b1A0 18o0 3I00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 iyo0 Rc0 18o0 1hc0 1io0 1a00 14o0 5aL0 MM0 1vc0 17A0 1i00 1bc0 1eo0 17d0 1in0 17A0 6hA0 10N0 XIL0 1a10 1in0 17d0 19X0 1cN0 1fz0 1a10 1fX0 1cp0 1cO0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|62e5\",\"Europe/Malta|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2as10 M00 1cM0 1cM0 14o0 1o00 WM0 1qM0 17c0 1cM0 M3A0 5M20 WM0 1fA0 1cM0 1cM0 1cM0 16m0 1de0 1lc0 14m0 1lc0 WO0 1qM0 GTW0 On0 1C10 Lz0 1C10 Lz0 1EN0 Lz0 1C10 Lz0 1zd0 Oo0 1C00 On0 1cp0 1cM0 1lA0 Xc0 1qq0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1iN0 19z0 1fB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|42e4\",\"Europe/Minsk|MMT EET MSK CEST CET MSD EEST FET|-1O -20 -30 -20 -10 -40 -30 -30|012343432525252525252525252616161616161616161616161616161616161616172|-1Pc1O eUnO qNX0 3gQ0 WM0 1fA0 1cM0 Al0 1tsn0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 3Fc0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hy0|19e5\",\"Europe/Monaco|PMT WET WEST WEMT CET CEST|-9.l 0 -10 -20 -10 -20|01212121212121212121212121212121212121212121212121232323232345454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-2nco9.l cNb9.l HA0 19A0 1iM0 11c0 1oo0 Wo0 1rc0 QM0 1EM0 UM0 1u00 10o0 1io0 1wo0 Rc0 1a00 1fA0 1cM0 1cM0 1io0 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Df0 2RV0 11z0 11B0 1ze0 WM0 1fA0 1cM0 1fa0 1aq0 16M0 1ekn0 1cL0 1fC0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|38e3\",\"Europe/Moscow|MMT MMT MST MDST MSD MSK MSM EET EEST MSK|-2u.h -2v.j -3v.j -4v.j -40 -30 -50 -20 -30 -40|012132345464575454545454545454545458754545454545454545454545454545454545454595|-2ag2u.h 2pyW.W 1bA0 11X0 GN0 1Hb0 c20 imv.j 3DA0 dz0 15A0 c10 2q10 iM10 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|16e6\",\"Europe/Paris|PMT WET WEST CEST CET WEMT|-9.l 0 -10 -20 -10 -20|0121212121212121212121212121212121212121212121212123434352543434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434|-2nco8.l cNb8.l HA0 19A0 1iM0 11c0 1oo0 Wo0 1rc0 QM0 1EM0 UM0 1u00 10o0 1io0 1wo0 Rc0 1a00 1fA0 1cM0 1cM0 1io0 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Df0 Ik0 5M30 WM0 1fA0 1cM0 Vx0 hB0 1aq0 16M0 1ekn0 1cL0 1fC0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|11e6\",\"Europe/Riga|RMT LST EET MSK CEST CET MSD EEST|-1A.y -2A.y -20 -30 -20 -10 -40 -30|010102345454536363636363636363727272727272727272727272727272727272727272727272727272727272727272727272727272727272727272727272|-25TzA.y 11A0 1iM0 ko0 gWm0 yDXA.y 2bX0 3fE0 WM0 1fA0 1cM0 1cM0 4m0 1sLy0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 1o00 11A0 1o00 11A0 1qM0 3oo0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|64e4\",\"Europe/Rome|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2as10 M00 1cM0 1cM0 14o0 1o00 WM0 1qM0 17c0 1cM0 M3A0 5M20 WM0 1fA0 1cM0 16K0 1iO0 16m0 1de0 1lc0 14m0 1lc0 WO0 1qM0 GTW0 On0 1C10 Lz0 1C10 Lz0 1EN0 Lz0 1C10 Lz0 1zd0 Oo0 1C00 On0 1C10 Lz0 1zd0 On0 1C10 LA0 1C00 LA0 1zc0 Oo0 1C00 Oo0 1zc0 Oo0 1fC0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|39e5\",\"Europe/Samara|LMT SAMT SAMT KUYT KUYST MSD MSK EEST SAMST SAMST|-3k.k -30 -40 -40 -50 -40 -30 -30 -50 -40|012343434343434343435656712828282828282828282828282828282828282912|-22WNk.k qHak.k bcn0 1Qqo0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cN0 8o0 14m0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qN0 WM0|12e5\",\"Europe/Simferopol|SMT EET MSK CEST CET MSD EEST MSK|-2g -20 -30 -20 -10 -40 -30 -40|012343432525252525252525252161616525252616161616161616161616161616161616172|-1Pc2g eUog rEn0 2qs0 WM0 1fA0 1cM0 3V0 1u0L0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1Q00 4eL0 1cL0 1cN0 1cL0 1cN0 dX0 WL0 1cN0 1cL0 1fB0 1o30 11B0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11z0 1nW0|33e4\",\"Europe/Sofia|EET CET CEST EEST|-20 -10 -20 -30|01212103030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030|-168L0 WM0 1fA0 1cM0 1cM0 1cN0 1mKH0 1dd0 1fb0 1ap0 1fb0 1a20 1fy0 1a30 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1nX0 11E0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Stockholm|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2azC0 TB0 2yDe0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|15e5\",\"Europe/Tallinn|TMT CET CEST EET MSK MSD EEST|-1D -10 -20 -20 -30 -40 -30|012103421212454545454545454546363636363636363636363636363636363636363636363636363636363636363636363636363636363636363636363|-26oND teD 11A0 1Ta0 4rXl KSLD 2FX0 2Jg0 WM0 1fA0 1cM0 18J0 1sTX0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o10 11A0 1qM0 5QM0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|41e4\",\"Europe/Tirane|LMT CET CEST|-1j.k -10 -20|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2glBj.k 14pcj.k 5LC0 WM0 4M0 1fCK0 10n0 1op0 11z0 1pd0 11z0 1qN0 WL0 1qp0 Xb0 1qp0 Xb0 1qp0 11z0 1lB0 11z0 1qN0 11z0 1iN0 16n0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|42e4\",\"Europe/Ulyanovsk|LMT +03 +04 +05 +02|-3d.A -30 -40 -50 -20|01232323232323232321214121212121212121212121212121212121212121212|-22WNd.A qHad.A 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0\",\"Europe/Uzhgorod|CET CEST MSK MSD EET EEST|-10 -20 -30 -40 -20 -30|010101023232323232323232320454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-1cqL0 6i00 WM0 1fA0 1cM0 1ml0 1Cp0 1r3W0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1Q00 1Nf0 2pw0 1cL0 1cN0 1cL0 1cN0 1cL0 1cQ0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|11e4\",\"Europe/Vienna|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 3KM0 14o0 LA00 6i00 WM0 1fA0 1cM0 1cM0 1cM0 400 2qM0 1a00 1cM0 1cM0 1io0 17c0 1gHa0 19X0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|18e5\",\"Europe/Vilnius|WMT KMT CET EET MSK CEST MSD EEST|-1o -1z.A -10 -20 -30 -20 -40 -30|012324525254646464646464646473737373737373737352537373737373737373737373737373737373737373737373737373737373737373737373|-293do 6ILM.o 1Ooz.A zz0 Mfd0 29W0 3is0 WM0 1fA0 1cM0 LV0 1tgL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11B0 1o00 11A0 1qM0 8io0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|54e4\",\"Europe/Volgograd|LMT TSAT STAT STAT VOLT VOLST VOLST VOLT MSD MSK MSK|-2V.E -30 -30 -40 -40 -50 -40 -30 -40 -30 -40|0123454545454545454676767489898989898989898989898989898989898989a9|-21IqV.E cLXV.E cEM0 1gqn0 Lco0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1cM0 1fA0 1cM0 2pz0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|10e5\",\"Europe/Warsaw|WMT CET CEST EET EEST|-1o -10 -20 -20 -30|012121234312121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ctdo 1LXo 11d0 1iO0 11A0 1o00 11A0 1on0 11A0 6zy0 HWP0 5IM0 WM0 1fA0 1cM0 1dz0 1mL0 1en0 15B0 1aq0 1nA0 11A0 1io0 17c0 1fA0 1a00 iDX0 LA0 1cM0 1cM0 1C00 Oo0 1cM0 1cM0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1C00 LA0 uso0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|17e5\",\"Europe/Zaporozhye|CUT EET MSK CEST CET MSD EEST|-2k -20 -30 -20 -10 -40 -30|01234342525252525252525252526161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161|-1Pc2k eUok rdb0 2RE0 WM0 1fA0 8m0 1v9a0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cK0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cQ0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|77e4\",\"HST|HST|a0|0|\",\"Indian/Chagos|LMT IOT IOT|-4N.E -50 -60|012|-2xosN.E 3AGLN.E|30e2\",\"Indian/Christmas|CXT|-70|0||21e2\",\"Indian/Cocos|CCT|-6u|0||596\",\"Indian/Kerguelen|-00 TFT|0 -50|01|-MG00|130\",\"Indian/Mahe|LMT SCT|-3F.M -40|01|-2yO3F.M|79e3\",\"Indian/Maldives|MMT MVT|-4S -50|01|-olgS|35e4\",\"Indian/Mauritius|LMT MUT MUST|-3O -40 -50|012121|-2xorO 34unO 14L0 12kr0 11z0|15e4\",\"Indian/Reunion|LMT RET|-3F.Q -40|01|-2mDDF.Q|84e4\",\"Pacific/Kwajalein|MHT KWAT MHT|-b0 c0 -c0|012|-AX0 W9X0|14e3\",\"MET|MET MEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 1cM0 16M0 1gMM0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\",\"MST|MST|70|0|\",\"MST7MDT|MST MDT MWT MPT|70 60 60 60|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Pacific/Chatham|CHAST CHAST CHADT|-cf -cJ -dJ|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-WqAf 1adef IM0 1C00 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1qM0 14o0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1io0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00|600\",\"PST8PDT|PST PDT PWT PPT|80 70 70 70|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261q0 1nX0 11B0 1nX0 SgN0 8x10 iy0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Pacific/Apia|LMT WSST SST SDT WSDT WSST|bq.U bu b0 a0 -e0 -d0|01232345454545454545454545454545454545454545454545454545454|-2nDMx.4 1yW03.4 2rRbu 1ff0 1a00 CI0 AQ0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00|37e3\",\"Pacific/Bougainville|PGT JST BST|-a0 -90 -b0|0102|-16Wy0 7CN0 2MQp0|18e4\",\"Pacific/Chuuk|CHUT|-a0|0||49e3\",\"Pacific/Efate|LMT VUT VUST|-bd.g -b0 -c0|0121212121212121212121|-2l9nd.g 2Szcd.g 1cL0 1oN0 10L0 1fB0 19X0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 Lz0 1Nd0 An0|66e3\",\"Pacific/Enderbury|PHOT PHOT PHOT|c0 b0 -d0|012|nIc0 B8n0|1\",\"Pacific/Fakaofo|TKT TKT|b0 -d0|01|1Gfn0|483\",\"Pacific/Fiji|LMT FJT FJST|-bT.I -c0 -d0|0121212121212121212121212121212121212121212121212121212121212121|-2bUzT.I 3m8NT.I LA0 1EM0 IM0 nJc0 LA0 1o00 Rc0 1wo0 Ao0 1Nc0 Ao0 1Q00 xz0 1SN0 uM0 1SM0 uM0 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0|88e4\",\"Pacific/Funafuti|TVT|-c0|0||45e2\",\"Pacific/Galapagos|LMT ECT GALT|5W.o 50 60|012|-1yVS1.A 2dTz1.A|25e3\",\"Pacific/Gambier|LMT GAMT|8X.M 90|01|-2jof0.c|125\",\"Pacific/Guadalcanal|LMT SBT|-aD.M -b0|01|-2joyD.M|11e4\",\"Pacific/Guam|GST ChST|-a0 -a0|01|1fpq0|17e4\",\"Pacific/Honolulu|HST HDT HST|au 9u a0|010102|-1thLu 8x0 lef0 8Pz0 46p0|37e4\",\"Pacific/Kiritimati|LINT LINT LINT|aE a0 -e0|012|nIaE B8nk|51e2\",\"Pacific/Kosrae|KOST KOST|-b0 -c0|010|-AX0 1bdz0|66e2\",\"Pacific/Majuro|MHT MHT|-b0 -c0|01|-AX0|28e3\",\"Pacific/Marquesas|LMT MART|9i 9u|01|-2joeG|86e2\",\"Pacific/Pago_Pago|LMT NST BST SST|bm.M b0 b0 b0|0123|-2nDMB.c 2gVzB.c EyM0|37e2\",\"Pacific/Nauru|LMT NRT JST NRT|-b7.E -bu -90 -c0|01213|-1Xdn7.E PvzB.E 5RCu 1ouJu|10e3\",\"Pacific/Niue|NUT NUT NUT|bk bu b0|012|-KfME 17y0a|12e2\",\"Pacific/Norfolk|NMT NFT NFST NFT|-bc -bu -cu -b0|01213|-Kgbc W01G On0 1COp0|25e4\",\"Pacific/Noumea|LMT NCT NCST|-b5.M -b0 -c0|01212121|-2l9n5.M 2EqM5.M xX0 1PB0 yn0 HeP0 Ao0|98e3\",\"Pacific/Palau|PWT|-90|0||21e3\",\"Pacific/Pitcairn|PNT PST|8u 80|01|18Vku|56\",\"Pacific/Pohnpei|PONT|-b0|0||34e3\",\"Pacific/Port_Moresby|PGT|-a0|0||25e4\",\"Pacific/Rarotonga|CKT CKHST CKT|au 9u a0|012121212121212121212121212|lyWu IL0 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu Onu|13e3\",\"Pacific/Tahiti|LMT TAHT|9W.g a0|01|-2joe1.I|18e4\",\"Pacific/Tarawa|GILT|-c0|0||29e3\",\"Pacific/Tongatapu|TOT TOT TOST|-ck -d0 -e0|01212121|-1aB0k 2n5dk 15A0 1wo0 xz0 1Q10 xz0|75e3\",\"Pacific/Wake|WAKT|-c0|0||16e3\",\"Pacific/Wallis|WFT|-c0|0||94\",\"WET|WET WEST|0 -10|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\"],\n    links:[\"Africa/Abidjan|Africa/Bamako\",\"Africa/Abidjan|Africa/Banjul\",\"Africa/Abidjan|Africa/Conakry\",\"Africa/Abidjan|Africa/Dakar\",\"Africa/Abidjan|Africa/Freetown\",\"Africa/Abidjan|Africa/Lome\",\"Africa/Abidjan|Africa/Nouakchott\",\"Africa/Abidjan|Africa/Ouagadougou\",\"Africa/Abidjan|Africa/Sao_Tome\",\"Africa/Abidjan|Africa/Timbuktu\",\"Africa/Abidjan|Atlantic/St_Helena\",\"Africa/Cairo|Egypt\",\"Africa/Johannesburg|Africa/Maseru\",\"Africa/Johannesburg|Africa/Mbabane\",\"Africa/Khartoum|Africa/Juba\",\"Africa/Lagos|Africa/Bangui\",\"Africa/Lagos|Africa/Brazzaville\",\"Africa/Lagos|Africa/Douala\",\"Africa/Lagos|Africa/Kinshasa\",\"Africa/Lagos|Africa/Libreville\",\"Africa/Lagos|Africa/Luanda\",\"Africa/Lagos|Africa/Malabo\",\"Africa/Lagos|Africa/Niamey\",\"Africa/Lagos|Africa/Porto-Novo\",\"Africa/Maputo|Africa/Blantyre\",\"Africa/Maputo|Africa/Bujumbura\",\"Africa/Maputo|Africa/Gaborone\",\"Africa/Maputo|Africa/Harare\",\"Africa/Maputo|Africa/Kigali\",\"Africa/Maputo|Africa/Lubumbashi\",\"Africa/Maputo|Africa/Lusaka\",\"Africa/Nairobi|Africa/Addis_Ababa\",\"Africa/Nairobi|Africa/Asmara\",\"Africa/Nairobi|Africa/Asmera\",\"Africa/Nairobi|Africa/Dar_es_Salaam\",\"Africa/Nairobi|Africa/Djibouti\",\"Africa/Nairobi|Africa/Kampala\",\"Africa/Nairobi|Africa/Mogadishu\",\"Africa/Nairobi|Indian/Antananarivo\",\"Africa/Nairobi|Indian/Comoro\",\"Africa/Nairobi|Indian/Mayotte\",\"Africa/Tripoli|Libya\",\"America/Adak|America/Atka\",\"America/Adak|US/Aleutian\",\"America/Anchorage|US/Alaska\",\"America/Argentina/Buenos_Aires|America/Buenos_Aires\",\"America/Argentina/Catamarca|America/Argentina/ComodRivadavia\",\"America/Argentina/Catamarca|America/Catamarca\",\"America/Argentina/Cordoba|America/Cordoba\",\"America/Argentina/Cordoba|America/Rosario\",\"America/Argentina/Jujuy|America/Jujuy\",\"America/Argentina/Mendoza|America/Mendoza\",\"America/Atikokan|America/Coral_Harbour\",\"America/Chicago|US/Central\",\"America/Curacao|America/Aruba\",\"America/Curacao|America/Kralendijk\",\"America/Curacao|America/Lower_Princes\",\"America/Denver|America/Shiprock\",\"America/Denver|Navajo\",\"America/Denver|US/Mountain\",\"America/Detroit|US/Michigan\",\"America/Edmonton|Canada/Mountain\",\"America/Fort_Wayne|America/Indiana/Indianapolis\",\"America/Fort_Wayne|America/Indianapolis\",\"America/Fort_Wayne|US/East-Indiana\",\"America/Halifax|Canada/Atlantic\",\"America/Havana|Cuba\",\"America/Indiana/Knox|America/Knox_IN\",\"America/Indiana/Knox|US/Indiana-Starke\",\"America/Jamaica|Jamaica\",\"America/Kentucky/Louisville|America/Louisville\",\"America/Los_Angeles|US/Pacific\",\"America/Los_Angeles|US/Pacific-New\",\"America/Manaus|Brazil/West\",\"America/Mazatlan|Mexico/BajaSur\",\"America/Mexico_City|Mexico/General\",\"America/New_York|US/Eastern\",\"America/Noronha|Brazil/DeNoronha\",\"America/Panama|America/Cayman\",\"America/Phoenix|US/Arizona\",\"America/Port_of_Spain|America/Anguilla\",\"America/Port_of_Spain|America/Antigua\",\"America/Port_of_Spain|America/Dominica\",\"America/Port_of_Spain|America/Grenada\",\"America/Port_of_Spain|America/Guadeloupe\",\"America/Port_of_Spain|America/Marigot\",\"America/Port_of_Spain|America/Montserrat\",\"America/Port_of_Spain|America/St_Barthelemy\",\"America/Port_of_Spain|America/St_Kitts\",\"America/Port_of_Spain|America/St_Lucia\",\"America/Port_of_Spain|America/St_Thomas\",\"America/Port_of_Spain|America/St_Vincent\",\"America/Port_of_Spain|America/Tortola\",\"America/Port_of_Spain|America/Virgin\",\"America/Regina|Canada/East-Saskatchewan\",\"America/Regina|Canada/Saskatchewan\",\"America/Rio_Branco|America/Porto_Acre\",\"America/Rio_Branco|Brazil/Acre\",\"America/Santiago|Chile/Continental\",\"America/Sao_Paulo|Brazil/East\",\"America/St_Johns|Canada/Newfoundland\",\"America/Tijuana|America/Ensenada\",\"America/Tijuana|America/Santa_Isabel\",\"America/Tijuana|Mexico/BajaNorte\",\"America/Toronto|America/Montreal\",\"America/Toronto|Canada/Eastern\",\"America/Vancouver|Canada/Pacific\",\"America/Whitehorse|Canada/Yukon\",\"America/Winnipeg|Canada/Central\",\"Asia/Ashgabat|Asia/Ashkhabad\",\"Asia/Bangkok|Asia/Phnom_Penh\",\"Asia/Bangkok|Asia/Vientiane\",\"Asia/Dhaka|Asia/Dacca\",\"Asia/Dubai|Asia/Muscat\",\"Asia/Ho_Chi_Minh|Asia/Saigon\",\"Asia/Hong_Kong|Hongkong\",\"Asia/Jerusalem|Asia/Tel_Aviv\",\"Asia/Jerusalem|Israel\",\"Asia/Kathmandu|Asia/Katmandu\",\"Asia/Kolkata|Asia/Calcutta\",\"Asia/Macau|Asia/Macao\",\"Asia/Makassar|Asia/Ujung_Pandang\",\"Asia/Nicosia|Europe/Nicosia\",\"Asia/Qatar|Asia/Bahrain\",\"Asia/Riyadh|Asia/Aden\",\"Asia/Riyadh|Asia/Kuwait\",\"Asia/Seoul|ROK\",\"Asia/Shanghai|Asia/Chongqing\",\"Asia/Shanghai|Asia/Chungking\",\"Asia/Shanghai|Asia/Harbin\",\"Asia/Shanghai|PRC\",\"Asia/Singapore|Singapore\",\"Asia/Taipei|ROC\",\"Asia/Tehran|Iran\",\"Asia/Thimphu|Asia/Thimbu\",\"Asia/Tokyo|Japan\",\"Asia/Ulaanbaatar|Asia/Ulan_Bator\",\"Asia/Urumqi|Asia/Kashgar\",\"Atlantic/Faroe|Atlantic/Faeroe\",\"Atlantic/Reykjavik|Iceland\",\"Australia/Adelaide|Australia/South\",\"Australia/Brisbane|Australia/Queensland\",\"Australia/Broken_Hill|Australia/Yancowinna\",\"Australia/Darwin|Australia/North\",\"Australia/Hobart|Australia/Tasmania\",\"Australia/Lord_Howe|Australia/LHI\",\"Australia/Melbourne|Australia/Victoria\",\"Australia/Perth|Australia/West\",\"Australia/Sydney|Australia/ACT\",\"Australia/Sydney|Australia/Canberra\",\"Australia/Sydney|Australia/NSW\",\"Etc/GMT+0|Etc/GMT\",\"Etc/GMT+0|Etc/GMT-0\",\"Etc/GMT+0|Etc/GMT0\",\"Etc/GMT+0|Etc/Greenwich\",\"Etc/GMT+0|GMT\",\"Etc/GMT+0|GMT+0\",\"Etc/GMT+0|GMT-0\",\"Etc/GMT+0|GMT0\",\"Etc/GMT+0|Greenwich\",\"Etc/UCT|UCT\",\"Etc/UTC|Etc/Universal\",\"Etc/UTC|Etc/Zulu\",\"Etc/UTC|UTC\",\"Etc/UTC|Universal\",\"Etc/UTC|Zulu\",\"Europe/Belgrade|Europe/Ljubljana\",\"Europe/Belgrade|Europe/Podgorica\",\"Europe/Belgrade|Europe/Sarajevo\",\"Europe/Belgrade|Europe/Skopje\",\"Europe/Belgrade|Europe/Zagreb\",\"Europe/Chisinau|Europe/Tiraspol\",\"Europe/Dublin|Eire\",\"Europe/Helsinki|Europe/Mariehamn\",\"Europe/Istanbul|Asia/Istanbul\",\"Europe/Istanbul|Turkey\",\"Europe/Lisbon|Portugal\",\"Europe/London|Europe/Belfast\",\"Europe/London|Europe/Guernsey\",\"Europe/London|Europe/Isle_of_Man\",\"Europe/London|Europe/Jersey\",\"Europe/London|GB\",\"Europe/London|GB-Eire\",\"Europe/Moscow|W-SU\",\"Europe/Oslo|Arctic/Longyearbyen\",\"Europe/Oslo|Atlantic/Jan_Mayen\",\"Europe/Prague|Europe/Bratislava\",\"Europe/Rome|Europe/San_Marino\",\"Europe/Rome|Europe/Vatican\",\"Europe/Warsaw|Poland\",\"Europe/Zurich|Europe/Busingen\",\"Europe/Zurich|Europe/Vaduz\",\"Pacific/Auckland|Antarctica/McMurdo\",\"Pacific/Auckland|Antarctica/South_Pole\",\"Pacific/Auckland|NZ\",\"Pacific/Chatham|NZ-CHAT\",\"Pacific/Chuuk|Pacific/Truk\",\"Pacific/Chuuk|Pacific/Yap\",\"Pacific/Easter|Chile/EasterIsland\",\"Pacific/Guam|Pacific/Saipan\",\"Pacific/Honolulu|Pacific/Johnston\",\"Pacific/Honolulu|US/Hawaii\",\"Pacific/Kwajalein|Kwajalein\",\"Pacific/Pago_Pago|Pacific/Midway\",\"Pacific/Pago_Pago|Pacific/Samoa\",\"Pacific/Pago_Pago|US/Samoa\",\"Pacific/Pohnpei|Pacific/Ponape\"]}),a});\n","MutationObserver.js":"/**\n * @license\n * Copyright (c) 2014 The Polymer Project Authors. All rights reserved.\n * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt\n * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt\n * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt\n * Code distributed by Google as part of the polymer project is also\n * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt\n */\n\n(function(global) {\n\n  var registrationsTable = new WeakMap();\n\n  var setImmediate;\n\n  // As much as we would like to use the native implementation, IE\n  // (all versions) suffers a rather annoying bug where it will drop or defer\n  // callbacks when heavy DOM operations are being performed concurrently.\n  //\n  // For a thorough discussion on this, see:\n  // http://codeforhire.com/2013/09/21/setimmediate-and-messagechannel-broken-on-internet-explorer-10/\n  if (/Trident|Edge/.test(navigator.userAgent)) {\n    // Sadly, this bug also affects postMessage and MessageQueues.\n    //\n    // We would like to use the onreadystatechange hack for IE <= 10, but it is\n    // dangerous in the polyfilled environment due to requiring that the\n    // observed script element be in the document.\n    setImmediate = setTimeout;\n\n  // If some other browser ever implements it, let's prefer their native\n  // implementation:\n  } else if (window.setImmediate) {\n    setImmediate = window.setImmediate;\n\n  // Otherwise, we fall back to postMessage as a means of emulating the next\n  // task semantics of setImmediate.\n  } else {\n    var setImmediateQueue = [];\n    var sentinel = String(Math.random());\n    window.addEventListener('message', function(e) {\n      if (e.data === sentinel) {\n        var queue = setImmediateQueue;\n        setImmediateQueue = [];\n        queue.forEach(function(func) {\n          func();\n        });\n      }\n    });\n    setImmediate = function(func) {\n      setImmediateQueue.push(func);\n      window.postMessage(sentinel, '*');\n    };\n  }\n\n  // This is used to ensure that we never schedule 2 callas to setImmediate\n  var isScheduled = false;\n\n  // Keep track of observers that needs to be notified next time.\n  var scheduledObservers = [];\n\n  /**\n   * Schedules |dispatchCallback| to be called in the future.\n   * @param {MutationObserver} observer\n   */\n  function scheduleCallback(observer) {\n    scheduledObservers.push(observer);\n    if (!isScheduled) {\n      isScheduled = true;\n      setImmediate(dispatchCallbacks);\n    }\n  }\n\n  function wrapIfNeeded(node) {\n    return window.ShadowDOMPolyfill &&\n        window.ShadowDOMPolyfill.wrapIfNeeded(node) ||\n        node;\n  }\n\n  function dispatchCallbacks() {\n    // http://dom.spec.whatwg.org/#mutation-observers\n\n    isScheduled = false; // Used to allow a new setImmediate call above.\n\n    var observers = scheduledObservers;\n    scheduledObservers = [];\n    // Sort observers based on their creation UID (incremental).\n    observers.sort(function(o1, o2) {\n      return o1.uid_ - o2.uid_;\n    });\n\n    var anyNonEmpty = false;\n    observers.forEach(function(observer) {\n\n      // 2.1, 2.2\n      var queue = observer.takeRecords();\n      // 2.3. Remove all transient registered observers whose observer is mo.\n      removeTransientObserversFor(observer);\n\n      // 2.4\n      if (queue.length) {\n        observer.callback_(queue, observer);\n        anyNonEmpty = true;\n      }\n    });\n\n    // 3.\n    if (anyNonEmpty)\n      dispatchCallbacks();\n  }\n\n  function removeTransientObserversFor(observer) {\n    observer.nodes_.forEach(function(node) {\n      var registrations = registrationsTable.get(node);\n      if (!registrations)\n        return;\n      registrations.forEach(function(registration) {\n        if (registration.observer === observer)\n          registration.removeTransientObservers();\n      });\n    });\n  }\n\n  /**\n   * This function is used for the \"For each registered observer observer (with\n   * observer's options as options) in target's list of registered observers,\n   * run these substeps:\" and the \"For each ancestor ancestor of target, and for\n   * each registered observer observer (with options options) in ancestor's list\n   * of registered observers, run these substeps:\" part of the algorithms. The\n   * |options.subtree| is checked to ensure that the callback is called\n   * correctly.\n   *\n   * @param {Node} target\n   * @param {function(MutationObserverInit):MutationRecord} callback\n   */\n  function forEachAncestorAndObserverEnqueueRecord(target, callback) {\n    for (var node = target; node; node = node.parentNode) {\n      var registrations = registrationsTable.get(node);\n\n      if (registrations) {\n        for (var j = 0; j < registrations.length; j++) {\n          var registration = registrations[j];\n          var options = registration.options;\n\n          // Only target ignores subtree.\n          if (node !== target && !options.subtree)\n            continue;\n\n          var record = callback(options);\n          if (record)\n            registration.enqueue(record);\n        }\n      }\n    }\n  }\n\n  var uidCounter = 0;\n\n  /**\n   * The class that maps to the DOM MutationObserver interface.\n   * @param {Function} callback.\n   * @constructor\n   */\n  function JsMutationObserver(callback) {\n    this.callback_ = callback;\n    this.nodes_ = [];\n    this.records_ = [];\n    this.uid_ = ++uidCounter;\n  }\n\n  JsMutationObserver.prototype = {\n    observe: function(target, options) {\n      target = wrapIfNeeded(target);\n\n      // 1.1\n      if (!options.childList && !options.attributes && !options.characterData ||\n\n          // 1.2\n          options.attributeOldValue && !options.attributes ||\n\n          // 1.3\n          options.attributeFilter && options.attributeFilter.length &&\n              !options.attributes ||\n\n          // 1.4\n          options.characterDataOldValue && !options.characterData) {\n\n        throw new SyntaxError();\n      }\n\n      var registrations = registrationsTable.get(target);\n      if (!registrations)\n        registrationsTable.set(target, registrations = []);\n\n      // 2\n      // If target's list of registered observers already includes a registered\n      // observer associated with the context object, replace that registered\n      // observer's options with options.\n      var registration;\n      for (var i = 0; i < registrations.length; i++) {\n        if (registrations[i].observer === this) {\n          registration = registrations[i];\n          registration.removeListeners();\n          registration.options = options;\n          break;\n        }\n      }\n\n      // 3.\n      // Otherwise, add a new registered observer to target's list of registered\n      // observers with the context object as the observer and options as the\n      // options, and add target to context object's list of nodes on which it\n      // is registered.\n      if (!registration) {\n        registration = new Registration(this, target, options);\n        registrations.push(registration);\n        this.nodes_.push(target);\n      }\n\n      registration.addListeners();\n    },\n\n    disconnect: function() {\n      this.nodes_.forEach(function(node) {\n        var registrations = registrationsTable.get(node);\n        for (var i = 0; i < registrations.length; i++) {\n          var registration = registrations[i];\n          if (registration.observer === this) {\n            registration.removeListeners();\n            registrations.splice(i, 1);\n            // Each node can only have one registered observer associated with\n            // this observer.\n            break;\n          }\n        }\n      }, this);\n      this.records_ = [];\n    },\n\n    takeRecords: function() {\n      var copyOfRecords = this.records_;\n      this.records_ = [];\n      return copyOfRecords;\n    }\n  };\n\n  /**\n   * @param {string} type\n   * @param {Node} target\n   * @constructor\n   */\n  function MutationRecord(type, target) {\n    this.type = type;\n    this.target = target;\n    this.addedNodes = [];\n    this.removedNodes = [];\n    this.previousSibling = null;\n    this.nextSibling = null;\n    this.attributeName = null;\n    this.attributeNamespace = null;\n    this.oldValue = null;\n  }\n\n  function copyMutationRecord(original) {\n    var record = new MutationRecord(original.type, original.target);\n    record.addedNodes = original.addedNodes.slice();\n    record.removedNodes = original.removedNodes.slice();\n    record.previousSibling = original.previousSibling;\n    record.nextSibling = original.nextSibling;\n    record.attributeName = original.attributeName;\n    record.attributeNamespace = original.attributeNamespace;\n    record.oldValue = original.oldValue;\n    return record;\n  };\n\n  // We keep track of the two (possibly one) records used in a single mutation.\n  var currentRecord, recordWithOldValue;\n\n  /**\n   * Creates a record without |oldValue| and caches it as |currentRecord| for\n   * later use.\n   * @param {string} oldValue\n   * @return {MutationRecord}\n   */\n  function getRecord(type, target) {\n    return currentRecord = new MutationRecord(type, target);\n  }\n\n  /**\n   * Gets or creates a record with |oldValue| based in the |currentRecord|\n   * @param {string} oldValue\n   * @return {MutationRecord}\n   */\n  function getRecordWithOldValue(oldValue) {\n    if (recordWithOldValue)\n      return recordWithOldValue;\n    recordWithOldValue = copyMutationRecord(currentRecord);\n    recordWithOldValue.oldValue = oldValue;\n    return recordWithOldValue;\n  }\n\n  function clearRecords() {\n    currentRecord = recordWithOldValue = undefined;\n  }\n\n  /**\n   * @param {MutationRecord} record\n   * @return {boolean} Whether the record represents a record from the current\n   * mutation event.\n   */\n  function recordRepresentsCurrentMutation(record) {\n    return record === recordWithOldValue || record === currentRecord;\n  }\n\n  /**\n   * Selects which record, if any, to replace the last record in the queue.\n   * This returns |null| if no record should be replaced.\n   *\n   * @param {MutationRecord} lastRecord\n   * @param {MutationRecord} newRecord\n   * @param {MutationRecord}\n   */\n  function selectRecord(lastRecord, newRecord) {\n    if (lastRecord === newRecord)\n      return lastRecord;\n\n    // Check if the the record we are adding represents the same record. If\n    // so, we keep the one with the oldValue in it.\n    if (recordWithOldValue && recordRepresentsCurrentMutation(lastRecord))\n      return recordWithOldValue;\n\n    return null;\n  }\n\n  /**\n   * Class used to represent a registered observer.\n   * @param {MutationObserver} observer\n   * @param {Node} target\n   * @param {MutationObserverInit} options\n   * @constructor\n   */\n  function Registration(observer, target, options) {\n    this.observer = observer;\n    this.target = target;\n    this.options = options;\n    this.transientObservedNodes = [];\n  }\n\n  Registration.prototype = {\n    enqueue: function(record) {\n      var records = this.observer.records_;\n      var length = records.length;\n\n      // There are cases where we replace the last record with the new record.\n      // For example if the record represents the same mutation we need to use\n      // the one with the oldValue. If we get same record (this can happen as we\n      // walk up the tree) we ignore the new record.\n      if (records.length > 0) {\n        var lastRecord = records[length - 1];\n        var recordToReplaceLast = selectRecord(lastRecord, record);\n        if (recordToReplaceLast) {\n          records[length - 1] = recordToReplaceLast;\n          return;\n        }\n      } else {\n        scheduleCallback(this.observer);\n      }\n\n      records[length] = record;\n    },\n\n    addListeners: function() {\n      this.addListeners_(this.target);\n    },\n\n    addListeners_: function(node) {\n      var options = this.options;\n      if (options.attributes)\n        node.addEventListener('DOMAttrModified', this, true);\n\n      if (options.characterData)\n        node.addEventListener('DOMCharacterDataModified', this, true);\n\n      if (options.childList)\n        node.addEventListener('DOMNodeInserted', this, true);\n\n      if (options.childList || options.subtree)\n        node.addEventListener('DOMNodeRemoved', this, true);\n    },\n\n    removeListeners: function() {\n      this.removeListeners_(this.target);\n    },\n\n    removeListeners_: function(node) {\n      var options = this.options;\n      if (options.attributes)\n        node.removeEventListener('DOMAttrModified', this, true);\n\n      if (options.characterData)\n        node.removeEventListener('DOMCharacterDataModified', this, true);\n\n      if (options.childList)\n        node.removeEventListener('DOMNodeInserted', this, true);\n\n      if (options.childList || options.subtree)\n        node.removeEventListener('DOMNodeRemoved', this, true);\n    },\n\n    /**\n     * Adds a transient observer on node. The transient observer gets removed\n     * next time we deliver the change records.\n     * @param {Node} node\n     */\n    addTransientObserver: function(node) {\n      // Don't add transient observers on the target itself. We already have all\n      // the required listeners set up on the target.\n      if (node === this.target)\n        return;\n\n      this.addListeners_(node);\n      this.transientObservedNodes.push(node);\n      var registrations = registrationsTable.get(node);\n      if (!registrations)\n        registrationsTable.set(node, registrations = []);\n\n      // We know that registrations does not contain this because we already\n      // checked if node === this.target.\n      registrations.push(this);\n    },\n\n    removeTransientObservers: function() {\n      var transientObservedNodes = this.transientObservedNodes;\n      this.transientObservedNodes = [];\n\n      transientObservedNodes.forEach(function(node) {\n        // Transient observers are never added to the target.\n        this.removeListeners_(node);\n\n        var registrations = registrationsTable.get(node);\n        for (var i = 0; i < registrations.length; i++) {\n          if (registrations[i] === this) {\n            registrations.splice(i, 1);\n            // Each node can only have one registered observer associated with\n            // this observer.\n            break;\n          }\n        }\n      }, this);\n    },\n\n    handleEvent: function(e) {\n      // Stop propagation since we are managing the propagation manually.\n      // This means that other mutation events on the page will not work\n      // correctly but that is by design.\n      e.stopImmediatePropagation();\n\n      switch (e.type) {\n        case 'DOMAttrModified':\n          // http://dom.spec.whatwg.org/#concept-mo-queue-attributes\n\n          var name = e.attrName;\n          var namespace = e.relatedNode.namespaceURI;\n          var target = e.target;\n\n          // 1.\n          var record = new getRecord('attributes', target);\n          record.attributeName = name;\n          record.attributeNamespace = namespace;\n\n          // 2.\n          var oldValue =\n              e.attrChange === MutationEvent.ADDITION ? null : e.prevValue;\n\n          forEachAncestorAndObserverEnqueueRecord(target, function(options) {\n            // 3.1, 4.2\n            if (!options.attributes)\n              return;\n\n            // 3.2, 4.3\n            if (options.attributeFilter && options.attributeFilter.length &&\n                options.attributeFilter.indexOf(name) === -1 &&\n                options.attributeFilter.indexOf(namespace) === -1) {\n              return;\n            }\n            // 3.3, 4.4\n            if (options.attributeOldValue)\n              return getRecordWithOldValue(oldValue);\n\n            // 3.4, 4.5\n            return record;\n          });\n\n          break;\n\n        case 'DOMCharacterDataModified':\n          // http://dom.spec.whatwg.org/#concept-mo-queue-characterdata\n          var target = e.target;\n\n          // 1.\n          var record = getRecord('characterData', target);\n\n          // 2.\n          var oldValue = e.prevValue;\n\n\n          forEachAncestorAndObserverEnqueueRecord(target, function(options) {\n            // 3.1, 4.2\n            if (!options.characterData)\n              return;\n\n            // 3.2, 4.3\n            if (options.characterDataOldValue)\n              return getRecordWithOldValue(oldValue);\n\n            // 3.3, 4.4\n            return record;\n          });\n\n          break;\n\n        case 'DOMNodeRemoved':\n          this.addTransientObserver(e.target);\n          // Fall through.\n        case 'DOMNodeInserted':\n          // http://dom.spec.whatwg.org/#concept-mo-queue-childlist\n          var changedNode = e.target;\n          var addedNodes, removedNodes;\n          if (e.type === 'DOMNodeInserted') {\n            addedNodes = [changedNode];\n            removedNodes = [];\n          } else {\n\n            addedNodes = [];\n            removedNodes = [changedNode];\n          }\n          var previousSibling = changedNode.previousSibling;\n          var nextSibling = changedNode.nextSibling;\n\n          // 1.\n          var record = getRecord('childList', e.target.parentNode);\n          record.addedNodes = addedNodes;\n          record.removedNodes = removedNodes;\n          record.previousSibling = previousSibling;\n          record.nextSibling = nextSibling;\n\n          forEachAncestorAndObserverEnqueueRecord(e.relatedNode, function(options) {\n            // 2.1, 3.2\n            if (!options.childList)\n              return;\n\n            // 2.2, 3.3\n            return record;\n          });\n\n      }\n\n      clearRecords();\n    }\n  };\n\n  global.JsMutationObserver = JsMutationObserver;\n\n  if (!global.MutationObserver)\n    global.MutationObserver = JsMutationObserver;\n\n\n})(this);","requirejs-min-resolver.js":"    var ctx = require.s.contexts._,\n        origNameToUrl = ctx.nameToUrl;\n\n    ctx.nameToUrl = function() {\n        var url = origNameToUrl.apply(ctx, arguments);\n        if (!url.match(/\\/tiny_mce\\//)&&!url.match(/\\/Temando_Shipping\\/static\\/js\\//)) {\n            url = url.replace(/(\\.min)?\\.js$/, '.min.js');\n        }\n        return url;\n    };\n","Magento_Variable/variables.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Variables, updateElementAtCursor */\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/modal',\n    'jquery/ui',\n    'prototype'\n], function (jQuery, $t) {\n    'use strict';\n\n    window.Variables = {\n        textareaElementId: null,\n        variablesContent: null,\n        dialogWindow: null,\n        dialogWindowId: 'variables-chooser',\n        overlayShowEffectOptions: null,\n        overlayHideEffectOptions: null,\n        insertFunction: 'Variables.insertVariable',\n\n        /**\n         * @param {*} textareaElementId\n         * @param {Function} insertFunction\n         */\n        init: function (textareaElementId, insertFunction) {\n            if ($(textareaElementId)) {\n                this.textareaElementId = textareaElementId;\n            }\n\n            if (insertFunction) {\n                this.insertFunction = insertFunction;\n            }\n        },\n\n        /**\n         * reset data.\n         */\n        resetData: function () {\n            this.variablesContent = null;\n            this.dialogWindow = null;\n        },\n\n        /**\n         * @param {Object} variables\n         */\n        openVariableChooser: function (variables) {\n            if (this.variablesContent == null && variables) {\n                this.variablesContent = '<ul class=\"insert-variable\">';\n                variables.each(function (variableGroup) {\n                    if (variableGroup.label && variableGroup.value) {\n                        this.variablesContent += '<li><b>' + variableGroup.label + '</b></li>';\n                        variableGroup.value.each(function (variable) {\n                            if (variable.value && variable.label) {\n                                this.variablesContent += '<li>' +\n                                    this.prepareVariableRow(variable.value, variable.label) + '</li>';\n                            }\n                        }.bind(this));\n                    }\n                }.bind(this));\n                this.variablesContent += '</ul>';\n            }\n\n            if (this.variablesContent) {\n                this.openDialogWindow(this.variablesContent);\n            }\n        },\n\n        /**\n         * @param {*} variablesContent\n         */\n        openDialogWindow: function (variablesContent) {\n            var windowId = this.dialogWindowId;\n\n            jQuery('<div id=\"' + windowId + '\">' + Variables.variablesContent + '</div>').modal({\n                title: $t('Insert Variable...'),\n                type: 'slide',\n                buttons: [],\n\n                /** @inheritdoc */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                }\n            });\n\n            jQuery('#' + windowId).modal('openModal');\n\n            variablesContent.evalScripts.bind(variablesContent).defer();\n        },\n\n        /**\n         * Close dialog window.\n         */\n        closeDialogWindow: function () {\n            jQuery('#' + this.dialogWindowId).modal('closeModal');\n        },\n\n        /**\n         * @param {String} varValue\n         * @param {*} varLabel\n         * @return {String}\n         */\n        prepareVariableRow: function (varValue, varLabel) {\n            var value = varValue.replace(/\"/g, '&quot;').replace(/'/g, '\\\\&#39;'),\n                content = '<a href=\"#\" onclick=\"' +\n                    this.insertFunction +\n                    '(\\'' +\n                    value +\n                    '\\');return false;\">' +\n                    varLabel +\n                    '</a>';\n\n            return content;\n        },\n\n        /**\n         * @param {*} value\n         */\n        insertVariable: function (value) {\n            var windowId = this.dialogWindowId,\n                textareaElm, scrollPos;\n\n            jQuery('#' + windowId).modal('closeModal');\n            textareaElm = $(this.textareaElementId);\n\n            if (textareaElm) {\n                scrollPos = textareaElm.scrollTop;\n                updateElementAtCursor(textareaElm, value);\n                textareaElm.focus();\n                textareaElm.scrollTop = scrollPos;\n                jQuery(textareaElm).change();\n                textareaElm = null;\n            }\n\n            return;\n        }\n    };\n\n    window.MagentovariablePlugin = {\n        editor: null,\n        variables: null,\n        textareaId: null,\n\n        /**\n         * @param {*} editor\n         */\n        setEditor: function (editor) {\n            this.editor = editor;\n        },\n\n        /**\n         * @param {String} url\n         * @param {*} textareaId\n         */\n        loadChooser: function (url, textareaId) {\n            this.textareaId = textareaId;\n\n            if (this.variables == null) {\n                new Ajax.Request(url, {\n                    parameters: {},\n                    onComplete: function (transport) {\n                        if (transport.responseText.isJSON()) {\n                            Variables.init(null, 'MagentovariablePlugin.insertVariable');\n                            this.variables = transport.responseText.evalJSON();\n                            this.openChooser(this.variables);\n                        }\n                    }.bind(this)\n                });\n            } else {\n                this.openChooser(this.variables);\n            }\n\n            return;\n        },\n\n        /**\n         * @param {*} variables\n         */\n        openChooser: function (variables) {\n            Variables.openVariableChooser(variables);\n        },\n\n        /**\n         * @param {*} value\n         */\n        insertVariable: function (value) {\n            if (this.textareaId) {\n                Variables.init(this.textareaId);\n                Variables.insertVariable(value);\n            } else {\n                Variables.closeDialogWindow();\n                this.editor.execCommand('mceInsertContent', false, value);\n            }\n\n            return;\n        }\n    };\n});\n","Magento_Tax/js/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'mage/backend/editablemultiselect'\n]);\n","Magento_Tax/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Tax/price/adjustment',\n            taxPriceType: 'final_price',\n            taxPriceCssClass: 'price-including-tax',\n            bothPrices: 3,\n            inclTax: 2,\n            exclTax: 1,\n            modules: {\n                price: '${ $.parentName }'\n            },\n            listens: {\n                price: 'initializePriceAttributes'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super()\n                .initializePriceAttributes();\n\n            return this;\n        },\n\n        /**\n         * Update parent price.\n         *\n         * @returns {Object} Chainable.\n         */\n        initializePriceAttributes: function () {\n            if (this.displayBothPrices && this.price()) {\n                this.price().priceWrapperCssClasses = this.taxPriceCssClass;\n                this.price().priceWrapperAttr = {\n                    'data-label': $t('Incl. Tax')\n                };\n            }\n\n            return this;\n        },\n\n        /**\n         * Get price tax adjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTax: function (row) {\n            return row['price_info']['extension_attributes']['tax_adjustments']['formatted_prices'][this.taxPriceType];\n        },\n\n        /**\n         * Set price taax type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPrices: function () {\n            return +this.source.data.displayTaxes === this.bothPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceIncludeTax: function () {\n            return +this.source.data.displayTaxes === this.inclTax;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.exclTax;\n        }\n    });\n});\n","Magento_Ui/js/block-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Ui/js/lib/knockout/template/loader',\n    'mage/template'\n], function (ko, $, templateLoader, template) {\n    'use strict';\n\n    var blockLoaderTemplatePath = 'ui/block-loader',\n        blockContentLoadingClass = '_block-content-loading',\n        blockLoader,\n        blockLoaderClass,\n        loaderImageHref;\n\n    templateLoader.loadTemplate(blockLoaderTemplatePath).done(function (blockLoaderTemplate) {\n        blockLoader = template($.trim(blockLoaderTemplate), {\n            loaderImageHref: loaderImageHref\n        });\n        blockLoader = $(blockLoader);\n        blockLoaderClass = '.' + blockLoader.attr('class');\n    });\n\n    /**\n     * Helper function to check if blockContentLoading class should be applied.\n     * @param {Object} element\n     * @returns {Boolean}\n     */\n    function isLoadingClassRequired(element) {\n        var position = element.css('position');\n\n        if (position === 'absolute' || position === 'fixed') {\n            return false;\n        }\n\n        return true;\n    }\n\n    /**\n     * Add loader to block.\n     * @param {Object} element\n     */\n    function addBlockLoader(element) {\n        element.find(':focus').blur();\n        element.find('input:disabled, select:disabled').addClass('_disabled');\n        element.find('input, select').prop('disabled', true);\n\n        if (isLoadingClassRequired(element)) {\n            element.addClass(blockContentLoadingClass);\n        }\n        element.append(blockLoader.clone());\n    }\n\n    /**\n     * Remove loader from block.\n     * @param {Object} element\n     */\n    function removeBlockLoader(element) {\n        if (!element.has(blockLoaderClass).length) {\n            return;\n        }\n        element.find(blockLoaderClass).remove();\n        element.find('input:not(\"._disabled\"), select:not(\"._disabled\")').prop('disabled', false);\n        element.find('input:disabled, select:disabled').removeClass('_disabled');\n        element.removeClass(blockContentLoadingClass);\n    }\n\n    return function (loaderHref) {\n        loaderImageHref = loaderHref;\n        ko.bindingHandlers.blockLoader = {\n            /**\n             * Process loader for block\n             * @param {String} element\n             * @param {Boolean} displayBlockLoader\n             */\n            update: function (element, displayBlockLoader) {\n                element = $(element);\n\n                if (ko.unwrap(displayBlockLoader())) {\n                    addBlockLoader(element);\n                } else {\n                    removeBlockLoader(element);\n                }\n            }\n        };\n    };\n});\n","Magento_Ui/js/dynamic-rows/dnd.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiElement',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (ko, $, _, Element) {\n    'use strict';\n\n    var transformProp,\n        isTouchDevice = typeof document.ontouchstart !== 'undefined';\n\n    /**\n     * Get element context\n     */\n    function getContext(elem) {\n        return ko.contextFor(elem);\n    }\n\n    /**\n     * Defines supported css 'transform' property.\n     *\n     * @returns {String|Undefined}\n     */\n    transformProp = (function () {\n        var style = document.createElement('div').style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform !== 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] !== 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    return Element.extend({\n        defaults: {\n            separatorsClass: {\n                top: '_dragover-top',\n                bottom: '_dragover-bottom'\n            },\n            step: 'auto',\n            tableClass: 'table.admin__dynamic-rows',\n            recordsCache: [],\n            draggableElement: {},\n            draggableElementClass: '_dragged',\n            elemPositions: [],\n            listens: {\n                '${ $.recordsProvider }:elems': 'setCacheRecords'\n            },\n            modules: {\n                parentComponent: '${ $.recordsProvider }'\n            }\n        },\n\n        /**\n         * Initialize component\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'mousemoveHandler',\n                'mouseupHandler'\n            );\n\n            this._super()\n                .body = $('body');\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent, initializes 'options' and 'initialOptions'\n         *     properties, calls 'setOptions' passing options to it\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'recordsCache'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init listens to start drag\n         *\n         * @param {Object} elem - DOM element\n         * @param {Object} data - element data\n         */\n        initListeners: function (elem, data) {\n            if (isTouchDevice) {\n                $(elem).on('touchstart', this.mousedownHandler.bind(this, data, elem));\n            } else {\n                $(elem).on('mousedown', this.mousedownHandler.bind(this, data, elem));\n            }\n        },\n\n        /**\n         * Mouse down handler\n         *\n         * @param {Object} data - element data\n         * @param {Object} elem - element\n         * @param {Object} event - key down event\n         */\n        mousedownHandler: function (data, elem, event) {\n            var recordNode = this.getRecordNode(elem),\n                originRecord = $(elem).parents('tr').eq(0),\n                drEl = this.draggableElement,\n                $table = $(elem).parents('table').eq(0),\n                $tableWrapper = $table.parent();\n\n            $(recordNode).addClass(this.draggableElementClass);\n            $(originRecord).addClass(this.draggableElementClass);\n            this.step = this.step === 'auto' ? originRecord.height() / 2 : this.step;\n            drEl.originRow = originRecord;\n            drEl.instance = recordNode = this.processingStyles(recordNode, elem);\n            drEl.instanceCtx = this.getRecord(originRecord[0]);\n            drEl.eventMousedownY = isTouchDevice ? event.originalEvent.touches[0].pageY : event.pageY;\n            drEl.minYpos =\n                $table.offset().top - originRecord.offset().top + $table.children('thead').outerHeight();\n            drEl.maxYpos = drEl.minYpos + $table.children('tbody').outerHeight() - originRecord.outerHeight();\n            $tableWrapper.append(recordNode);\n\n            if (isTouchDevice) {\n                this.body.bind('touchmove', this.mousemoveHandler);\n                this.body.bind('touchend', this.mouseupHandler);\n            } else {\n                this.body.bind('mousemove', this.mousemoveHandler);\n                this.body.bind('mouseup', this.mouseupHandler);\n            }\n\n        },\n\n        /**\n         * Mouse move handler\n         *\n         * @param {Object} event - mouse move event\n         */\n        mousemoveHandler: function (event) {\n            var depEl = this.draggableElement,\n                pageY = isTouchDevice ? event.originalEvent.touches[0].pageY : event.pageY,\n                positionY = pageY - depEl.eventMousedownY,\n                processingPositionY = positionY + 'px',\n                processingMaxYpos = depEl.maxYpos + 'px',\n                processingMinYpos = depEl.minYpos + 'px',\n                depElement = this.getDepElement(depEl.instance, positionY, depEl.originRow);\n\n            event.stopPropagation();\n            event.preventDefault();\n\n            if (depElement) {\n                depEl.depElement ? depEl.depElement.elem.removeClass(depEl.depElement.className) : false;\n                depEl.depElement = depElement;\n                depEl.depElement.insert !== 'none' ? depEl.depElement.elem.addClass(depElement.className) : false;\n            } else if (depEl.depElement && depEl.depElement.insert !== 'none') {\n                depEl.depElement.elem.removeClass(depEl.depElement.className);\n                depEl.depElement.insert = 'none';\n            }\n\n            if (positionY > depEl.minYpos && positionY < depEl.maxYpos) {\n                $(depEl.instance)[0].style[transformProp] = 'translateY(' + processingPositionY + ')';\n            } else if (positionY < depEl.minYpos) {\n                $(depEl.instance)[0].style[transformProp] = 'translateY(' + processingMinYpos + ')';\n            } else if (positionY >= depEl.maxYpos) {\n                $(depEl.instance)[0].style[transformProp] = 'translateY(' + processingMaxYpos + ')';\n            }\n        },\n\n        /**\n         * Mouse up handler\n         */\n        mouseupHandler: function (event) {\n            var depElementCtx,\n                drEl = this.draggableElement,\n                pageY = isTouchDevice ? event.originalEvent.touches[0].pageY : event.pageY,\n                positionY = pageY - drEl.eventMousedownY;\n\n            drEl.depElement = this.getDepElement(drEl.instance, positionY, this.draggableElement.originRow);\n\n            drEl.instance.remove();\n\n            if (drEl.depElement) {\n                depElementCtx = this.getRecord(drEl.depElement.elem[0]);\n                drEl.depElement.elem.removeClass(drEl.depElement.className);\n\n                if (drEl.depElement.insert !== 'none') {\n                    this.setPosition(drEl.depElement.elem, depElementCtx, drEl);\n                }\n            }\n\n            drEl.originRow.removeClass(this.draggableElementClass);\n\n            if (isTouchDevice) {\n                this.body.unbind('touchmove', this.mousemoveHandler);\n                this.body.unbind('touchend', this.mouseupHandler);\n            } else {\n                this.body.unbind('mousemove', this.mousemoveHandler);\n                this.body.unbind('mouseup', this.mouseupHandler);\n            }\n\n            this.draggableElement = {};\n        },\n\n        /**\n         * Set position to element\n         *\n         * @param {Object} depElem - dep element\n         * @param {Object} depElementCtx - dep element context\n         * @param {Object} dragData - data draggable element\n         */\n        setPosition: function (depElem, depElementCtx, dragData) {\n            var depElemPosition = ~~depElementCtx.position;\n\n            if (dragData.depElement.insert === 'after') {\n                dragData.instanceCtx.position = depElemPosition + 1;\n            } else if (dragData.depElement.insert === 'before') {\n                dragData.instanceCtx.position = depElemPosition;\n            }\n        },\n\n        /**\n         * Get dependency element\n         *\n         * @param {Object} curInstance - current element instance\n         * @param {Number} position\n         * @param {Object} row\n         */\n        getDepElement: function (curInstance, position, row) {\n            var tableSelector = this.tableClass + ' tr',\n                $table = $(row).parents('table').eq(0),\n                $curInstance = $(curInstance),\n                recordsCollection = $table.find('table').length ?\n                    $table.find('tbody > tr').filter(function (index, elem) {\n                        return !$(elem).parents(tableSelector).length;\n                    }) :\n                    $table.find('tbody > tr'),\n                curInstancePositionTop = $curInstance.position().top,\n                curInstancePositionBottom = curInstancePositionTop + $curInstance.height();\n\n            if (position < 0) {\n                return this._getDepElement(recordsCollection, 'before', curInstancePositionTop);\n            } else if (position > 0) {\n                return this._getDepElement(recordsCollection, 'after', curInstancePositionBottom);\n            }\n        },\n\n        /**\n         * Get dependency element private\n         *\n         * @param {Array} collection - record collection\n         * @param {String} position - position to add\n         * @param {Number} dragPosition - position drag element\n         */\n        _getDepElement: function (collection, position, dragPosition) {\n            var rec,\n                rangeEnd,\n                rangeStart,\n                result,\n                className,\n                i = 0,\n                length = collection.length;\n\n            for (i; i < length; i++) {\n                rec = collection.eq(i);\n\n                if (position === 'before') {\n                    rangeStart = collection.eq(i).position().top - this.step;\n                    rangeEnd = rangeStart + this.step * 2;\n                    className = this.separatorsClass.top;\n                } else if (position === 'after') {\n                    rangeEnd = rec.position().top + rec.height() + this.step;\n                    rangeStart = rangeEnd - this.step * 2;\n                    className = this.separatorsClass.bottom;\n                }\n\n                if (dragPosition > rangeStart && dragPosition < rangeEnd) {\n                    result = {\n                        elem: rec,\n                        insert: rec[0] === this.draggableElement.originRow[0] ? 'none' : position,\n                        className: className\n                    };\n                }\n            }\n\n            return result;\n        },\n\n        /**\n         * Set default position of draggable element\n         *\n         * @param {Object} elem - current element instance\n         * @param {Object} data - current element data\n         */\n        _setDefaultPosition: function (elem, data) {\n            var originRecord = $(elem).parents('tr').eq(0),\n                position = originRecord.position();\n\n            ++position.top;\n            $(data).css(position);\n        },\n\n        /**\n         * Set records to cache\n         *\n         * @param {Object} records - record instance\n         */\n        setCacheRecords: function (records) {\n            this.recordsCache(records);\n        },\n\n        /**\n         * Set styles to draggable element\n         *\n         * @param {Object} data - data\n         * @param {Object} elem - elem instance\n         * @returns {Object} instance data.\n         */\n        processingStyles: function (data, elem) {\n            var table = $(elem).parents('table').eq(0),\n                columns = table.find('th'),\n                recordColumns = $(data).find('td');\n\n            this._setDefaultPosition(elem, $(data));\n            this._setColumnsWidth(columns, recordColumns);\n            this._setTableWidth(table, $(data));\n\n            return data;\n        },\n\n        /**\n         * Set table width.\n         *\n         * @param {Object} originalTable - original record instance\n         * @param {Object} recordTable - draggable record instance\n         */\n        _setTableWidth: function (originalTable, recordTable) {\n            recordTable.outerWidth(originalTable.outerWidth());\n        },\n\n        /**\n         * Set columns width.\n         *\n         * @param {Object} originColumns - original record instance\n         * @param {Object} recordColumns - draggable record instance\n         */\n        _setColumnsWidth: function (originColumns, recordColumns) {\n            var i = 0,\n                length = originColumns.length;\n\n            for (i; i < length; i++) {\n                recordColumns.eq(i).outerWidth(originColumns.eq(i).outerWidth());\n            }\n        },\n\n        /**\n         * Get copy original record\n         *\n         * @param {Object} record - original record instance\n         * @returns {Object} draggable record instance\n         */\n        getRecordNode: function (record) {\n            var $record = $(record),\n                table = $record.parents('table')[0].cloneNode(true),\n                $table = $(table);\n\n            $table.find('tr').remove();\n            $table.append($record.parents('tr')[0].cloneNode(true));\n\n            return table;\n        },\n\n        /**\n         * Get record context by element\n         *\n         * @param {Object} elem - original element\n         * @returns {Object} draggable record context\n         */\n        getRecord: function (elem) {\n            var ctx = getContext(elem),\n                index = _.isFunction(ctx.$index) ? ctx.$index() : ctx.$index;\n\n            return this.recordsCache()[index];\n        }\n\n    });\n});\n","Magento_Ui/js/dynamic-rows/record.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiCollection',\n    'uiRegistry'\n], function (_, uiCollection, registry) {\n    'use strict';\n\n    return uiCollection.extend({\n        defaults: {\n            visible: true,\n            disabled: true,\n            headerLabel: '',\n            label: '',\n            positionProvider: 'position',\n            imports: {\n                data: '${ $.provider }:${ $.dataScope }'\n            },\n            listens: {\n                position: 'initPosition',\n                elems: 'setColumnVisibileListener'\n            },\n            links: {\n                position: '${ $.name }.${ $.positionProvider }:value'\n            },\n            exports: {\n                recordId: '${ $.provider }:${ $.dataScope }.record_id'\n            },\n            modules: {\n                parentComponent: '${ $.parentName }'\n            }\n        },\n\n        /**\n         * Extends instance with default config, calls initialize of parent\n         * class, calls initChildren method, set observe variable.\n         * Use parent \"track\" method - wrapper observe array\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            registry.async(this.name + '.' + this.positionProvider)(function (component) {\n\n                /**\n                 * Overwrite hasChanged method\n                 *\n                 * @returns {Boolean}\n                 */\n                component.hasChanged = function () {\n\n                    /* eslint-disable eqeqeq */\n                    return this.value().toString() != this.initialValue.toString();\n\n                    /* eslint-enable eqeqeq */\n                };\n\n                if (!component.initialValue) {\n                    component.initialValue = self.parentComponent().maxPosition;\n                    component.bubble('update', component.hasChanged());\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Init config\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.label = this.label || this.headerLabel;\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('position')\n                .observe([\n                    'visible',\n                    'disabled',\n                    'data',\n                    'label'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init element position\n         *\n         * @param {Number} position - element position\n         */\n        initPosition: function (position) {\n            var pos = parseInt(position, 10);\n\n            this.parentComponent().setMaxPosition(pos, this);\n\n            if (!pos && pos !== 0) {\n                this.position = this.parentComponent().maxPosition;\n            }\n        },\n\n        /**\n         * Set column visibility listener\n         */\n        setColumnVisibileListener: function () {\n            var elem = _.find(this.elems(), function (curElem) {\n                return !curElem.hasOwnProperty('visibleListener');\n            });\n\n            if (!elem) {\n                return;\n            }\n\n            this.childVisibleListener(elem);\n\n            if (!elem.visibleListener) {\n                elem.on('visible', this.childVisibleListener.bind(this, elem));\n            }\n\n            elem.visibleListener = true;\n        },\n\n        /**\n         * Child visibility listener\n         *\n         * @param {Object} data\n         */\n        childVisibleListener: function (data) {\n            this.setVisibilityColumn(data.index, data.visible());\n        },\n\n        /**\n         * Reset data to initial value.\n         * Call method reset on child elements.\n         */\n        reset: function () {\n            var elems = this.elems(),\n                nameIsEqual,\n                dataScopeIsEqual;\n\n            _.each(elems, function (elem) {\n                nameIsEqual = this.name + '.' + this.positionProvider === elem.name;\n                dataScopeIsEqual = this.dataScope === elem.dataScope;\n\n                if (!(nameIsEqual || dataScopeIsEqual) && _.isFunction(elem.reset)) {\n                    elem.reset();\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Clear data\n         *\n         * @returns {Collection} Chainable.\n         */\n        clear: function () {\n            var elems = this.elems(),\n                nameIsEqual,\n                dataScopeIsEqual;\n\n            _.each(elems, function (elem) {\n                nameIsEqual = this.name + '.' + this.positionProvider === elem.name;\n                dataScopeIsEqual = this.dataScope === elem.dataScope;\n\n                if (!(nameIsEqual || dataScopeIsEqual) && _.isFunction(elem.reset)) {\n                    elem.clear();\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Get label for collapsible header\n         *\n         * @param {String} label\n         *\n         * @returns {String}\n         */\n        getLabel: function (label) {\n            if (_.isString(label)) {\n                this.label(label);\n            } else if (label && this.label()) {\n                return this.label();\n            } else {\n                this.label(this.headerLabel);\n            }\n\n            return this.label();\n        },\n\n        /**\n         * Set visibility to record child\n         *\n         * @param {Boolean} state\n         */\n        setVisible: function (state) {\n            this.elems.each(function (cell) {\n                cell.visible(state);\n            });\n        },\n\n        /**\n         * Set visibility to child by index\n         *\n         * @param {Number} index\n         * @param {Boolean} state\n         */\n        setVisibilityColumn: function (index, state) {\n            var elems = this.elems(),\n                curElem = parseInt(index, 10),\n                label;\n\n            if (!this.parentComponent()) {\n                return false;\n            }\n\n            if (_.isNaN(curElem)) {\n                _.findWhere(elems, {\n                    index: index\n                }).visible(state);\n                label = _.findWhere(this.parentComponent().labels(), {\n                    name: index\n                });\n                label.visible() !== state ? label.visible(state) : false;\n            } else {\n                elems[curElem].visible(state);\n            }\n        },\n\n        /**\n         * Set disabled to child\n         *\n         * @param {Boolean} state\n         */\n        setDisabled: function (state) {\n            this.elems.each(function (cell) {\n                cell.disabled(state);\n            });\n        },\n\n        /**\n         * Set disabled to child by index\n         *\n         * @param {Number} index\n         * @param {Boolean} state\n         */\n        setDisabledColumn: function (index, state) {\n            index = ~~index;\n            this.elems()[index].disabled(state);\n        }\n    });\n});\n","Magento_Ui/js/dynamic-rows/dynamic-rows.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'mageUtils',\n    'underscore',\n    'uiLayout',\n    'uiCollection',\n    'uiRegistry',\n    'mage/translate'\n], function (ko, utils, _, layout, uiCollection, registry, $t) {\n    'use strict';\n\n    /**\n     * Checks value type and cast to boolean if needed\n     *\n     * @param {*} value\n     *\n     * @returns {Boolean|*} casted or origin value\n     */\n    function castValue(value) {\n        if (_.isUndefined(value) || value === '' || _.isNull(value)) {\n            return false;\n        }\n\n        return value;\n    }\n\n    /**\n     * Compares arrays.\n     *\n     * @param {Array} base - array as method bases its decision on first argument.\n     * @param {Array} current - second array\n     *\n     * @returns {Boolean} result - is current array equal to base array\n     */\n    function compareArrays(base, current) {\n        var index = 0,\n            length = base.length;\n\n        if (base.length !== current.length) {\n            return false;\n        }\n\n        /*eslint-disable max-depth, eqeqeq, no-use-before-define */\n        for (index; index < length; index++) {\n            if (_.isArray(base[index]) && _.isArray(current[index])) {\n                if (!compareArrays(base[index], current[index])) {\n                    return false;\n                }\n            } else if (typeof base[index] === 'object' && typeof current[index] === 'object') {\n                if (!compareObjects(base[index], current[index])) {\n                    return false;\n                }\n            } else if (castValue(base[index]) != castValue(current[index])) {\n                return false;\n            }\n        }/*eslint-enable max-depth, eqeqeq, no-use-before-define */\n\n        return true;\n    }\n\n    /**\n     * Compares objects. Compares only properties from origin object,\n     * if current object has more properties - they are not considered\n     *\n     * @param {Object} base - first object\n     * @param {Object} current - second object\n     *\n     * @returns {Boolean} result - is current object equal to base object\n     */\n    function compareObjects(base, current) {\n        var prop;\n\n        /*eslint-disable max-depth, eqeqeq*/\n        for (prop in base) {\n            if (_.isArray(base[prop]) && _.isArray(current[prop])) {\n                if (!compareArrays(base[prop], current[prop])) {\n                    return false;\n                }\n            } else if (typeof base[prop] === 'object' && typeof current[prop] === 'object') {\n                if (!compareObjects(base[prop], current[prop])) {\n                    return false;\n                }\n            } else if (castValue(base[prop]) != castValue(current[prop])) {\n                return false;\n            }\n        }/*eslint-enable max-depth, eqeqeq */\n\n        return true;\n    }\n\n    return uiCollection.extend({\n        defaults: {\n            defaultRecord: false,\n            columnsHeader: true,\n            columnsHeaderAfterRender: false,\n            columnsHeaderClasses: '',\n            labels: [],\n            recordTemplate: 'record',\n            collapsibleHeader: false,\n            additionalClasses: {},\n            visible: true,\n            disabled: false,\n            fit: false,\n            addButton: true,\n            addButtonLabel: $t('Add'),\n            recordData: [],\n            maxPosition: 0,\n            deleteProperty: 'delete',\n            identificationProperty: 'record_id',\n            deleteValue: true,\n            showSpinner: true,\n            isDifferedFromDefault: false,\n            defaultState: [],\n            defaultPagesState: {},\n            pagesChanged: {},\n            hasInitialPagesState: {},\n            changed: false,\n            fallbackResetTpl: 'ui/form/element/helper/fallback-reset-link',\n            dndConfig: {\n                name: '${ $.name }_dnd',\n                component: 'Magento_Ui/js/dynamic-rows/dnd',\n                template: 'ui/dynamic-rows/cells/dnd',\n                recordsProvider: '${ $.name }',\n                enabled: true\n            },\n            templates: {\n                record: {\n                    parent: '${ $.$data.collection.name }',\n                    name: '${ $.$data.index }',\n                    dataScope: '${ $.$data.collection.index }.${ $.name }',\n                    nodeTemplate: '${ $.parent }.${ $.$data.collection.recordTemplate }'\n                }\n            },\n            links: {\n                recordData: '${ $.provider }:${ $.dataScope }.${ $.index }'\n            },\n            listens: {\n                visible: 'setVisible',\n                disabled: 'setDisabled',\n                childTemplate: 'initHeader',\n                recordTemplate: 'onUpdateRecordTemplate',\n                recordData: 'setDifferedFromDefault parsePagesData setRecordDataToCache',\n                currentPage: 'changePage',\n                elems: 'checkSpinner',\n                changed: 'updateTrigger'\n            },\n            modules: {\n                dnd: '${ $.dndConfig.name }'\n            },\n            pages: 1,\n            pageSize: 20,\n            relatedData: [],\n            currentPage: 1,\n            recordDataCache: [],\n            startIndex: 0\n        },\n\n        /**\n         * Sets record data to cache\n         */\n        setRecordDataToCache: function (data) {\n            this.recordDataCache = data;\n        },\n\n        /**\n         * Extends instance with default config, calls initialize of parent\n         * class, calls initChildren method, set observe variable.\n         * Use parent \"track\" method - wrapper observe array\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this,\n                'processingDeleteRecord',\n                'onChildrenUpdate',\n                'checkDefaultState',\n                'renderColumnsHeader',\n                'deleteHandler',\n                'setDefaultState'\n            );\n\n            this._super()\n                .initChildren()\n                .initDnd()\n                .initDefaultRecord()\n                .setInitialProperty()\n                .setColumnsHeaderListener()\n                .checkSpinner();\n\n            this.on('recordData', this.checkDefaultState);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        bubble: function (event) {\n            if (event === 'deleteRecord' || event === 'update') {\n                return false;\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Inits DND module\n         *\n         * @returns {Object} Chainable.\n         */\n        initDnd: function () {\n            if (this.dndConfig.enabled) {\n                layout([this.dndConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('childTemplate')\n                .observe([\n                    'pages',\n                    'currentPage',\n                    'recordData',\n                    'columnsHeader',\n                    'visible',\n                    'disabled',\n                    'labels',\n                    'showSpinner',\n                    'isDifferedFromDefault',\n                    'changed'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initElement: function (elem) {\n            this._super();\n            elem.on({\n                'deleteRecord': this.deleteHandler,\n                'update': this.onChildrenUpdate,\n                'addChild': this.setDefaultState\n            });\n\n            return this;\n        },\n\n        /**\n         * Handler for deleteRecord event\n         *\n         * @param {Number|String} index - element index\n         * @param {Number|String} id\n         */\n        deleteHandler: function (index, id) {\n            var defaultState;\n\n            this.setDefaultState();\n            defaultState = this.defaultPagesState[this.currentPage()];\n            this.processingDeleteRecord(index, id);\n            this.pagesChanged[this.currentPage()] =\n                !compareArrays(defaultState, this.arrayFilter(this.getChildItems()));\n            this.changed(_.some(this.pagesChanged));\n        },\n\n        /**\n         * Set initial property to records data\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            if (_.isArray(this.recordData())) {\n                this.recordData.each(function (data, index) {\n                    this.source.set(this.dataScope + '.' + this.index + '.' + index + '.initialize', true);\n                }, this);\n            }\n\n            return this;\n        },\n\n        /**\n         * Handler for update event\n         *\n         * @param {Boolean} state\n         */\n        onChildrenUpdate: function (state) {\n            var changed,\n                dataScope,\n                changedElemDataScope;\n\n            if (state && !this.hasInitialPagesState[this.currentPage()]) {\n                this.setDefaultState();\n                changed = this.getChangedElems(this.elems());\n                dataScope = this.elems()[0].dataScope.split('.');\n                dataScope.splice(dataScope.length - 1, 1);\n                changed.forEach(function (elem) {\n                    changedElemDataScope = elem.dataScope.split('.');\n                    changedElemDataScope.splice(0, dataScope.length);\n                    changedElemDataScope[0] =\n                        (parseInt(changedElemDataScope[0], 10) - this.pageSize * (this.currentPage() - 1)).toString();\n                    this.setValueByPath(\n                        this.defaultPagesState[this.currentPage()],\n                        changedElemDataScope, elem.initialValue\n                    );\n                }, this);\n            }\n\n            if (this.defaultPagesState[this.currentPage()]) {\n                this.pagesChanged[this.currentPage()] =\n                    !compareArrays(this.defaultPagesState[this.currentPage()], this.arrayFilter(this.getChildItems()));\n                this.changed(_.some(this.pagesChanged));\n            }\n        },\n\n        /**\n         * Set default dynamic-rows state or state before changing data\n         *\n         * @param {Array} data - defaultState data\n         */\n        setDefaultState: function (data) {\n            var componentData,\n                childItems;\n\n            if (!this.hasInitialPagesState[this.currentPage()]) {\n                childItems = this.getChildItems();\n                componentData = childItems.length ?\n                    utils.copy(childItems) :\n                    utils.copy(this.getChildItems(this.recordDataCache));\n                componentData.forEach(function (dataObj) {\n                    if (dataObj.hasOwnProperty('initialize')) {\n                        delete dataObj.initialize;\n                    }\n                });\n\n                this.hasInitialPagesState[this.currentPage()] = true;\n                this.defaultPagesState[this.currentPage()] = data ? data : this.arrayFilter(componentData);\n            }\n        },\n\n        /**\n         * Sets value to object by string path\n         *\n         * @param {Object} obj\n         * @param {Array|String} path\n         * @param {*} value\n         */\n        setValueByPath: function (obj, path, value) {\n            var prop;\n\n            if (_.isString(path)) {\n                path = path.split('.');\n            }\n\n            if (path.length - 1) {\n                prop = obj[path[0]];\n                path.splice(0, 1);\n                this.setValueByPath(prop, path, value);\n            } else if (path.length && obj) {\n                obj[path[0]] = value;\n            }\n        },\n\n        /**\n         * Returns elements which changed self state\n         *\n         * @param {Array} array - data array\n         * @param {Array} changed - array with changed elements\n         * @returns {Array} changed - array with changed elements\n         */\n        getChangedElems: function (array, changed) {\n            changed = changed || [];\n\n            array.forEach(function (elem) {\n                if (_.isFunction(elem.elems)) {\n                    this.getChangedElems(elem.elems(), changed);\n                } else if (_.isFunction(elem.hasChanged) && elem.hasChanged()) {\n                    changed.push(elem);\n                }\n            }, this);\n\n            return changed;\n        },\n\n        /**\n         * Checks columnsHeaderAfterRender property,\n         * and set listener on elems if needed\n         *\n         * @returns {Object} Chainable.\n         */\n        setColumnsHeaderListener: function () {\n            if (this.columnsHeaderAfterRender) {\n                this.on('recordData', this.renderColumnsHeader);\n\n                if (_.isArray(this.recordData()) && this.recordData().length) {\n                    this.renderColumnsHeader();\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks whether component's state is default or not\n         */\n        checkDefaultState: function () {\n            var isRecordDataArray = _.isArray(this.recordData()),\n                initialize,\n                hasNotDefaultRecords = isRecordDataArray ? !!this.recordData().filter(function (data) {\n                    return !data.initialize;\n                }).length : false;\n\n            if (!this.hasInitialPagesState[this.currentPage()] && isRecordDataArray && hasNotDefaultRecords) {\n                this.hasInitialPagesState[this.currentPage()] = true;\n                this.defaultPagesState[this.currentPage()] = utils.copy(this.getChildItems().filter(function (data) {\n                    initialize = data.initialize;\n                    delete data.initialize;\n\n                    return initialize;\n                }));\n\n                this.pagesChanged[this.currentPage()] =\n                    !compareArrays(this.defaultPagesState[this.currentPage()], this.arrayFilter(this.getChildItems()));\n                this.changed(_.some(this.pagesChanged));\n            } else if (this.hasInitialPagesState[this.currentPage()]) {\n                this.pagesChanged[this.currentPage()] =\n                    !compareArrays(this.defaultPagesState[this.currentPage()], this.arrayFilter(this.getChildItems()));\n                this.changed(_.some(this.pagesChanged));\n            }\n        },\n\n        /**\n         * Filters out deleted items from array\n         *\n         * @param {Array} data\n         *\n         * @returns {Array} filtered array\n         */\n        arrayFilter: function (data) {\n            var prop;\n\n            /*eslint-disable no-loop-func*/\n            data.forEach(function (elem) {\n                for (prop in elem) {\n                    if (_.isArray(elem[prop])) {\n                        elem[prop] = _.filter(elem[prop], function (elemProp) {\n                            return elemProp[this.deleteProperty] !== this.deleteValue;\n                        }, this);\n\n                        elem[prop].forEach(function (elemProp) {\n                            if (_.isArray(elemProp)) {\n                                elem[prop] = this.arrayFilter(elemProp);\n                            }\n                        }, this);\n                    }\n                }\n            }, this);\n\n            /*eslint-enable no-loop-func*/\n\n            return data;\n        },\n\n        /**\n         * Triggers update event\n         *\n         * @param {Boolean} val\n         */\n        updateTrigger: function (val) {\n            this.trigger('update', val);\n        },\n\n        /**\n         * Returns component state\n         */\n        hasChanged: function () {\n            return this.changed();\n        },\n\n        /**\n         * Render column header\n         */\n        renderColumnsHeader: function () {\n            this.recordData().length ? this.columnsHeader(true) : this.columnsHeader(false);\n        },\n\n        /**\n         * Init default record\n         *\n         * @returns Chainable.\n         */\n        initDefaultRecord: function () {\n            if (this.defaultRecord && !this.recordData().length) {\n                this.addChild();\n            }\n\n            return this;\n        },\n\n        /**\n         * Create header template\n         *\n         * @param {Object} prop - instance obj\n         *\n         * @returns {Object} Chainable.\n         */\n        createHeaderTemplate: function (prop) {\n            var visible = prop.visible !== false,\n                disabled = _.isUndefined(prop.disabled) ? this.disabled() : prop.disabled;\n\n            return {\n                visible: ko.observable(visible),\n                disabled: ko.observable(disabled)\n            };\n        },\n\n        /**\n         * Init header elements\n         */\n        initHeader: function () {\n            var data;\n\n            if (!this.labels().length) {\n                _.each(this.childTemplate.children, function (cell) {\n                    data = this.createHeaderTemplate(cell.config);\n                    cell.config.labelVisible = false;\n                    _.extend(data, {\n                        label: cell.config.label,\n                        name: cell.name,\n                        required: !!cell.config.validation,\n                        columnsHeaderClasses: cell.config.columnsHeaderClasses,\n                        sortOrder: cell.config.sortOrder\n                    });\n\n                    this.labels.push(data);\n                }, this);\n            }\n        },\n\n        /**\n         * Set max element position\n         *\n         * @param {Number} position - element position\n         * @param {Object} elem - instance\n         */\n        setMaxPosition: function (position, elem) {\n            if (position || position === 0) {\n                this.checkMaxPosition(position);\n                this.sort(position, elem);\n            } else {\n                this.maxPosition += 1;\n            }\n        },\n\n        /**\n         * Sort element by position\n         *\n         * @param {Number} position - element position\n         * @param {Object} elem - instance\n         */\n        sort: function (position, elem) {\n            var that = this,\n                sorted,\n                updatedCollection;\n\n            if (this.elems().filter(function (el) {\n                    return el.position || el.position === 0;\n                }).length !== this.getChildItems().length) {\n\n                return false;\n            }\n\n            if (!elem.containers.length) {\n                registry.get(elem.name, function () {\n                    that.sort(position, elem);\n                });\n\n                return false;\n            }\n\n            sorted = this.elems().sort(function (propOne, propTwo) {\n                return ~~propOne.position - ~~propTwo.position;\n            });\n\n            updatedCollection = this.updatePosition(sorted, position, elem.name);\n            this.elems(updatedCollection);\n        },\n\n        /**\n         * Checking loader visibility\n         *\n         * @param {Array} elems\n         */\n        checkSpinner: function (elems) {\n            this.showSpinner(!(!this.recordData().length || elems && elems.length === this.getChildItems().length));\n        },\n\n        /**\n         * Filtering data and calculates the quantity of pages\n         *\n         * @param {Array} data\n         */\n        parsePagesData: function (data) {\n            var pages;\n\n            this.relatedData = this.deleteProperty ?\n                _.filter(data, function (elem) {\n                    return elem && elem[this.deleteProperty] !== this.deleteValue;\n                }, this) : data;\n\n            pages = Math.ceil(this.relatedData.length / this.pageSize) || 1;\n            this.pages(pages);\n        },\n\n        /**\n         * Reinit record data in order to remove deleted values\n         *\n         * @return void\n         */\n        reinitRecordData: function () {\n            this.recordData(\n                _.filter(this.recordData(), function (elem) {\n                    return elem && elem[this.deleteProperty] !== this.deleteValue;\n                }, this)\n            );\n        },\n\n        /**\n         * Get items to rendering on current page\n         *\n         * @returns {Array} data\n         */\n        getChildItems: function (data, page) {\n            var dataRecord = data || this.relatedData,\n                startIndex;\n\n            this.startIndex = (~~this.currentPage() - 1) * this.pageSize;\n\n            startIndex = page || this.startIndex;\n\n            return dataRecord.slice(startIndex, this.startIndex + this.pageSize);\n        },\n\n        /**\n         * Get record count with filtered delete property.\n         *\n         * @returns {Number} count\n         */\n        getRecordCount: function () {\n            return _.filter(this.recordData(), function (record) {\n                return record && record[this.deleteProperty] !== this.deleteValue;\n            }, this).length;\n        },\n\n        /**\n         * Get number of columns\n         *\n         * @returns {Number} columns\n         */\n        getColumnsCount: function () {\n            return this.labels().length + (this.dndConfig.enabled ? 1 : 0);\n        },\n\n        /**\n         * Processing pages before addChild\n         *\n         * @param {Object} ctx - element context\n         * @param {Number|String} index - element index\n         * @param {Number|String} prop - additional property to element\n         */\n        processingAddChild: function (ctx, index, prop) {\n            this.bubble('addChild', false);\n\n            if (this.relatedData.length && this.relatedData.length % this.pageSize === 0) {\n                this.pages(this.pages() + 1);\n                this.nextPage();\n            } else if (~~this.currentPage() !== this.pages()) {\n                this.currentPage(this.pages());\n            }\n\n            this.addChild(ctx, index, prop);\n        },\n\n        /**\n         * Processing pages before deleteRecord\n         *\n         * @param {Number|String} index - element index\n         * @param {Number|String} recordId\n         */\n        processingDeleteRecord: function (index, recordId) {\n            this.deleteRecord(index, recordId);\n        },\n\n        /**\n         * Change page\n         *\n         * @param {Number} page - current page\n         */\n        changePage: function (page) {\n            if (page === 1 && !this.recordData().length) {\n                return false;\n            }\n\n            if (~~page > this.pages()) {\n                this.currentPage(this.pages());\n\n                return false;\n            } else if (~~page < 1) {\n                this.currentPage(1);\n\n                return false;\n            }\n\n            this.initChildren();\n\n            return true;\n        },\n\n        /**\n         * Check page\n         *\n         * @returns {Boolean} is page first or not\n         */\n        isFirst: function () {\n            return this.currentPage() === 1;\n        },\n\n        /**\n         * Check page\n         *\n         * @returns {Boolean} is page last or not\n         */\n        isLast: function () {\n            return this.currentPage() === this.pages();\n        },\n\n        /**\n         * Change page to next\n         */\n        nextPage: function () {\n            this.clear();\n            this.currentPage(this.currentPage() + 1);\n        },\n\n        /**\n         * Change page to previous\n         */\n        previousPage: function () {\n            this.clear();\n            this.currentPage(this.currentPage() - 1);\n        },\n\n        /**\n         * Check dependency and set position to elements\n         *\n         * @param {Array} collection - elems\n         * @param {Number} position - current position\n         * @param {String} elemName - element name\n         *\n         * @returns {Array} collection\n         */\n        updatePosition: function (collection, position, elemName) {\n            var curPos,\n                parsePosition = ~~position,\n                result = _.filter(collection, function (record) {\n                    return ~~record.position === parsePosition;\n                });\n\n            if (result[1]) {\n                curPos = parsePosition + 1;\n                result[0].name === elemName ? result[1].position = curPos : result[0].position = curPos;\n                this.updatePosition(collection, curPos);\n            }\n\n            return collection;\n        },\n\n        /**\n         * Check max elements position and set if max\n         *\n         * @param {Number} position - current position\n         */\n        checkMaxPosition: function (position) {\n            var max = 0,\n                pos;\n\n            this.elems.each(function (record) {\n                pos = ~~record.position;\n                pos > max ? max = pos : false;\n            });\n\n            max < position ? max = position : false;\n            this.maxPosition = max;\n        },\n\n        /**\n         * Remove and set new max position\n         */\n        removeMaxPosition: function () {\n            this.maxPosition = 0;\n            this.elems.each(function (record) {\n                this.maxPosition < record.position ? this.maxPosition = ~~record.position : false;\n            }, this);\n        },\n\n        /**\n         * Update record template and rerender elems\n         *\n         * @param {String} recordName - record name\n         */\n        onUpdateRecordTemplate: function (recordName) {\n            if (recordName) {\n                this.recordTemplate = recordName;\n                this.reload();\n            }\n        },\n\n        /**\n         * Delete record\n         *\n         * @param {Number} index - row index\n         *\n         */\n        deleteRecord: function (index, recordId) {\n            var recordInstance,\n                lastRecord,\n                recordsData;\n\n            if (this.deleteProperty) {\n                recordsData = this.recordData();\n                recordInstance = _.find(this.elems(), function (elem) {\n                    return elem.index === index;\n                });\n                recordInstance.destroy();\n                this.elems([]);\n                this._updateCollection();\n                this.removeMaxPosition();\n                recordsData[recordInstance.index][this.deleteProperty] = this.deleteValue;\n                this.recordData(recordsData);\n                this.reinitRecordData();\n                this.reload();\n            } else {\n                this.update = true;\n\n                if (~~this.currentPage() === this.pages()) {\n                    lastRecord =\n                        _.findWhere(this.elems(), {\n                            index: this.startIndex + this.getChildItems().length - 1\n                        }) ||\n                        _.findWhere(this.elems(), {\n                            index: (this.startIndex + this.getChildItems().length - 1).toString()\n                        });\n\n                    lastRecord.destroy();\n                }\n\n                this.removeMaxPosition();\n                recordsData = this._getDataByProp(recordId);\n                this._updateData(recordsData);\n                this.update = false;\n            }\n\n            this._reducePages();\n            this._sort();\n        },\n\n        /**\n         * Reduce the number of pages\n         *\n         * @private\n         * @return void\n         */\n        _reducePages: function () {\n            if (this.pages() < ~~this.currentPage()) {\n                this.currentPage(this.pages());\n            }\n        },\n\n        /**\n         * Get data object by some property\n         *\n         * @param {Number} id - element id\n         * @param {String} prop - property\n         */\n        _getDataByProp: function (id, prop) {\n            prop = prop || this.identificationProperty;\n\n            return _.reject(this.getChildItems(), function (recordData) {\n                return ~~recordData[prop] === ~~id;\n            }, this);\n        },\n\n        /**\n         * Sort elems by position property\n         */\n        _sort: function () {\n            this.elems(this.elems().sort(function (propOne, propTwo) {\n                return ~~propOne.position - ~~propTwo.position;\n            }));\n        },\n\n        /**\n         * Set new data to dataSource,\n         * delete element\n         *\n         * @param {Array} data - record data\n         */\n        _updateData: function (data) {\n            var elems = _.clone(this.elems()),\n                path,\n                dataArr;\n\n            dataArr = this.recordData.splice(this.startIndex, this.recordData().length - this.startIndex);\n            dataArr.splice(0, this.pageSize);\n            elems = _.sortBy(this.elems(), function (elem) {\n                return ~~elem.index;\n            });\n\n            data.concat(dataArr).forEach(function (rec, idx) {\n                if (elems[idx]) {\n                    elems[idx].recordId = rec[this.identificationProperty];\n                }\n\n                if (!rec.position) {\n                    rec.position = this.maxPosition;\n                    this.setMaxPosition();\n                }\n\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + idx);\n                this.source.set(path, rec);\n            }, this);\n\n            this.elems(elems);\n        },\n\n        /**\n         * Rerender dynamic-rows elems\n         */\n        reload: function () {\n            this.clear();\n            this.initChildren(false, true);\n        },\n\n        /**\n         * Destroy all dynamic-rows elems\n         *\n         * @returns {Object} Chainable.\n         */\n        clear: function () {\n            this.destroyChildren();\n\n            return this;\n        },\n\n        /**\n         * Reset data to initial value.\n         * Call method reset on child elements.\n         */\n        reset: function () {\n            var elems = this.elems();\n\n            _.each(elems, function (elem) {\n                if (_.isFunction(elem.reset)) {\n                    elem.reset();\n                }\n            });\n        },\n\n        /**\n         * Set classes\n         *\n         * @param {Object} data\n         *\n         * @returns {Object} Classes\n         */\n        setClasses: function (data) {\n            var additional;\n\n            if (_.isString(data.additionalClasses)) {\n                additional = data.additionalClasses.split(' ');\n                data.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    data.additionalClasses[name] = true;\n                });\n            }\n\n            if (!data.additionalClasses) {\n                data.additionalClasses = {};\n            }\n\n            _.extend(data.additionalClasses, {\n                '_fit': data.fit,\n                '_required': data.required,\n                '_error': data.error,\n                '_empty': !this.elems().length,\n                '_no-header': this.columnsHeaderAfterRender || this.collapsibleHeader\n            });\n\n            return data.additionalClasses;\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            this.showSpinner(true);\n            this.getChildItems().forEach(function (data, index) {\n                this.addChild(data, this.startIndex + index);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Set visibility to dynamic-rows child\n         *\n         * @param {Boolean} state\n         */\n        setVisible: function (state) {\n            this.elems.each(function (record) {\n                record.setVisible(state);\n            }, this);\n        },\n\n        /**\n         * Set disabled property to dynamic-rows child\n         *\n         * @param {Boolean} state\n         */\n        setDisabled: function (state) {\n            this.elems.each(function (record) {\n                record.setDisabled(state);\n            }, this);\n        },\n\n        /**\n         * Set visibility to column\n         *\n         * @param {Number} index - column index\n         * @param {Boolean} state\n         */\n        setVisibilityColumn: function (index, state) {\n            this.elems.each(function (record) {\n                record.setVisibilityColumn(index, state);\n            }, this);\n        },\n\n        /**\n         * Set disabled property to column\n         *\n         * @param {Number} index - column index\n         * @param {Boolean} state\n         */\n        setDisabledColumn: function (index, state) {\n            this.elems.each(function (record) {\n                record.setDisabledColumn(index, state);\n            }, this);\n        },\n\n        /**\n         * Add child components\n         *\n         * @param {Object} data - component data\n         * @param {Number} index - record(row) index\n         * @param {Number|String} prop - custom identify property\n         *\n         * @returns {Object} Chainable.\n         */\n        addChild: function (data, index, prop) {\n            var template = this.templates.record,\n                child;\n\n            index = index || _.isNumber(index) ? index : this.recordData().length;\n            prop = prop || _.isNumber(prop) ? prop : index;\n\n            _.extend(this.templates.record, {\n                recordId: prop\n            });\n\n            child = utils.template(template, {\n                collection: this,\n                index: index\n            });\n\n            layout([child]);\n\n            return this;\n        },\n\n        /**\n         * Restore value to default\n         */\n        restoreToDefault: function () {\n            this.recordData(utils.copy(this.default));\n            this.reload();\n        },\n\n        /**\n         * Update whether value differs from default value\n         */\n        setDifferedFromDefault: function () {\n            var recordData = utils.copy(this.recordData());\n\n            Array.isArray(recordData) && recordData.forEach(function (item) {\n                delete item['record_id'];\n            });\n\n            this.isDifferedFromDefault(!_.isEqual(recordData, this.default));\n        }\n    });\n});\n","Magento_Ui/js/dynamic-rows/dynamic-rows-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './dynamic-rows'\n], function (_, dynamicRows) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            dataProvider: '',\n            insertData: [],\n            map: null,\n            cacheGridData: [],\n            deleteProperty: false,\n            positionProvider: 'position',\n            dataLength: 0,\n            identificationProperty: 'id',\n            identificationDRProperty: 'id',\n            listens: {\n                'insertData': 'processingInsertData',\n                'recordData': 'initElements setToInsertData'\n            },\n            mappingSettings: {\n                enabled: true,\n                distinct: true\n            }\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'insertData'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Set data from recordData to insertData\n         */\n        setToInsertData: function () {\n            var insertData = [],\n                obj;\n\n            if (this.recordData().length && !this.update) {\n                _.each(this.recordData(), function (recordData) {\n                    obj = {};\n                    obj[this.map[this.identificationProperty]] = recordData[this.identificationProperty];\n                    insertData.push(obj);\n                }, this);\n\n                if (insertData.length) {\n                    this.source.set(this.dataProvider, insertData);\n                }\n            }\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            this.getChildItems().forEach(function (data, index) {\n                this.processingAddChild(data, this.startIndex + index, data[this.identificationDRProperty]);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Initialize elements from grid\n         *\n         * @param {Array} data\n         *\n         * @returns {Object} Chainable.\n         */\n        initElements: function (data) {\n            var newData = this.getNewData(data);\n\n            this.parsePagesData(data);\n\n            if (newData.length) {\n                if (this.insertData().length) {\n                    this.processingAddChild(newData[0], data.length - 1, newData[0][this.identificationProperty]);\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Delete record instance\n         * update data provider dataScope\n         *\n         * @param {String|Number} index - record index\n         * @param {String|Number} recordId\n         */\n        deleteRecord: function (index, recordId) {\n            this._super();\n\n            this.updateInsertData(recordId);\n        },\n\n        /**\n         * Updates insertData when record is deleted\n         *\n         * @param {String|Number} recordId\n         */\n        updateInsertData: function (recordId) {\n            var data = this.getElementData(this.insertData(), recordId),\n            prop = this.map[this.identificationDRProperty];\n\n            this.insertData(_.reject(this.source.get(this.dataProvider), function (recordData) {\n                return ~~recordData[prop] === ~~data[prop];\n            }, this));\n        },\n\n        /**\n         * Find data object by index\n         *\n         * @param {Array} array - data collection\n         * @param {Number} index - element index\n         * @param {String} property - to find by property\n         *\n         * @returns {Object} data object\n         */\n        getElementData: function (array, index, property) {\n            var obj = {},\n                result;\n\n            property ? obj[property] = index : obj[this.map[this.identificationDRProperty]] = index;\n            result = _.findWhere(array, obj);\n\n            if (!result) {\n                property ?\n                    obj[property] = index.toString() :\n                    obj[this.map[this.identificationDRProperty]] = index.toString();\n            }\n\n            result = _.findWhere(array, obj);\n\n            return result;\n        },\n\n        /**\n         * Processing pages before addChild\n         *\n         * @param {Object} ctx - element context\n         * @param {Number|String} index - element index\n         * @param {Number|String} prop - additional property to element\n         */\n        processingAddChild: function (ctx, index, prop) {\n            if (this._elems.length > this.pageSize) {\n                return false;\n            }\n\n            this.showSpinner(true);\n            this.addChild(ctx, index, prop);\n        },\n\n        /**\n         * Contains old data with new\n         *\n         * @param {Array} data\n         *\n         * @returns {Array} changed data\n         */\n        getNewData: function (data) {\n            var changes = [],\n                tmpObj = {};\n\n            if (data.length !== this.relatedData.length) {\n                _.each(data, function (obj) {\n                    tmpObj[this.identificationDRProperty] = obj[this.identificationDRProperty];\n\n                    if (!_.findWhere(this.relatedData, tmpObj)) {\n                        changes.push(obj);\n                    }\n                }, this);\n            }\n\n            return changes;\n        },\n\n        /**\n         * Processing insert data\n         *\n         * @param {Object} data\n         */\n        processingInsertData: function (data) {\n            var changes,\n                obj = {};\n\n            changes = this._checkGridData(data);\n            this.cacheGridData = data;\n\n            if (changes.length) {\n                obj[this.identificationDRProperty] = changes[0][this.map[this.identificationProperty]];\n\n                if (_.findWhere(this.recordData(), obj)) {\n                    return false;\n                }\n\n                changes.each(function (changedObject) {\n                    this.mappingValue(changedObject);\n                }, this);\n            }\n        },\n\n        /**\n         * Mapping value from grid\n         *\n         * @param {Array} data\n         */\n        mappingValue: function (data) {\n            var obj = {},\n                tmpObj = {};\n\n            if (this.mappingSettings.enabled) {\n                _.each(this.map, function (prop, index) {\n                    obj[index] = !_.isUndefined(data[prop]) ? data[prop] : '';\n                }, this);\n            } else {\n                obj = data;\n            }\n\n            if (this.mappingSettings.distinct) {\n                tmpObj[this.identificationDRProperty] = obj[this.identificationDRProperty];\n\n                if (_.findWhere(this.recordData(), tmpObj)) {\n                    return false;\n                }\n            }\n\n            if (!obj.hasOwnProperty(this.positionProvider)) {\n                this.setMaxPosition();\n                obj[this.positionProvider] = this.maxPosition;\n            }\n\n            this.source.set(this.dataScope + '.' + this.index + '.' + this.recordData().length, obj);\n        },\n\n        /**\n         * Check changed records\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                max = cacheLength > curData ? this.cacheGridData : data,\n                changes = [],\n                obj = {};\n\n            max.each(function (record, index) {\n                obj[this.map[this.identificationDRProperty]] = record[this.map[this.identificationDRProperty]];\n\n                if (!_.where(this.cacheGridData, obj).length) {\n                    changes.push(data[index]);\n                }\n            }, this);\n\n            return changes;\n        }\n    });\n});\n","Magento_Ui/js/dynamic-rows/action-delete.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: false\n            }\n        },\n\n        /**\n         * Delete record handler.\n         *\n         * @param {Number} index\n         * @param {Number} id\n         */\n        deleteRecord: function (index, id) {\n            this.bubble('deleteRecord', index, id);\n        }\n    });\n});\n","Magento_Ui/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/lib/spinner',\n    'rjsResolver',\n    'uiLayout',\n    'uiCollection'\n], function (ko, _, loader, resolver, layout, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/listing',\n            listTemplate: 'ui/list/listing',\n            stickyTmpl: 'ui/grid/sticky/listing',\n            viewSwitcherTmpl: 'ui/grid/view-switcher',\n            positions: false,\n            displayMode: 'grid',\n            displayModes: {\n                grid: {\n                    value: 'grid',\n                    label: 'Grid',\n                    template: '${ $.template }'\n                },\n                list: {\n                    value: 'list',\n                    label: 'List',\n                    template: '${ $.listTemplate }'\n                }\n            },\n            dndConfig: {\n                name: '${ $.name }_dnd',\n                component: 'Magento_Ui/js/grid/dnd',\n                columnsProvider: '${ $.name }',\n                enabled: true\n            },\n            editorConfig: {\n                name: '${ $.name }_editor',\n                component: 'Magento_Ui/js/grid/editing/editor',\n                columnsProvider: '${ $.name }',\n                dataProvider: '${ $.provider }',\n                enabled: false\n            },\n            resizeConfig: {\n                name: '${ $.name }_resize',\n                columnsProvider: '${ $.name }',\n                component: 'Magento_Ui/js/grid/resize',\n                enabled: false\n            },\n            imports: {\n                rows: '${ $.provider }:data.items'\n            },\n            listens: {\n                elems: 'updatePositions updateVisible',\n                '${ $.provider }:reload': 'onBeforeReload',\n                '${ $.provider }:reloaded': 'onDataReloaded'\n            },\n            modules: {\n                dnd: '${ $.dndConfig.name }',\n                resize: '${ $.resizeConfig.name }'\n            },\n            tracks: {\n                displayMode: true\n            },\n            statefull: {\n                displayMode: true\n            }\n        },\n\n        /**\n         * Initializes Listing component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'updateVisible');\n\n            this._super()\n                .initDnd()\n                .initEditor()\n                .initResize();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: [],\n                    visibleColumns: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Creates drag&drop widget instance.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initDnd: function () {\n            if (this.dndConfig.enabled) {\n                layout([this.dndConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes resize component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initResize: function () {\n            if (this.resizeConfig.enabled) {\n                layout([this.resizeConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates inline editing component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initEditor: function () {\n            if (this.editorConfig.enabled) {\n                layout([this.editorConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to current component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initElement: function (element) {\n            var currentCount = this.elems().length,\n                totalCount = this.initChildCount;\n\n            if (totalCount === currentCount) {\n                this.initPositions();\n            }\n\n            element.on('visible', this.updateVisible);\n\n            return this._super();\n        },\n\n        /**\n         * Defines initial order of child elements.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initPositions: function () {\n            this.on('positions', this.applyPositions.bind(this));\n\n            this.setStatefull('positions');\n\n            return this;\n        },\n\n        /**\n         * Updates current state of child positions.\n         *\n         * @returns {Listing} Chainable.\n         */\n        updatePositions: function () {\n            var positions = {};\n\n            this.elems.each(function (elem, index) {\n                positions[elem.index] = index;\n            });\n\n            this.set('positions', positions);\n\n            return this;\n        },\n\n        /**\n         * Resorts child elements array according to provided positions.\n         *\n         * @param {Object} positions - Object where key represents child\n         *      index and value is its' position.\n         * @returns {Listing} Chainable.\n         */\n        applyPositions: function (positions) {\n            var sorting;\n\n            sorting = this.elems.map(function (elem) {\n                return {\n                    elem: elem,\n                    position: positions[elem.index]\n                };\n            });\n\n            this.insertChild(sorting);\n\n            return this;\n        },\n\n        /**\n         * Returns reference to 'visibleColumns' array.\n         *\n         * @returns {Array}\n         */\n        getVisible: function () {\n            var observable = ko.getObservable(this, 'visibleColumns');\n\n            return observable || this.visibleColumns;\n        },\n\n        /**\n         * Returns path to the template\n         * defined for a current display mode.\n         *\n         * @returns {String} Path to the template.\n         */\n        getTemplate: function () {\n            var mode = this.displayModes[this.displayMode];\n\n            return mode.template;\n        },\n\n        /**\n         * Returns an array of available display modes.\n         *\n         * @returns {Array<Object>}\n         */\n        getDisplayModes: function () {\n            var modes = this.displayModes;\n\n            return _.values(modes);\n        },\n\n        /**\n         * Sets display mode to provided value.\n         *\n         * @param {String} index\n         * @returns {Listing} Chainable\n         */\n        setDisplayMode: function (index) {\n            this.displayMode = index;\n\n            return this;\n        },\n\n        /**\n         * Returns total number of displayed columns in grid.\n         *\n         * @returns {Number}\n         */\n        countVisible: function () {\n            return this.visibleColumns.length;\n        },\n\n        /**\n         * Updates array of visible columns.\n         *\n         * @returns {Listing} Chainable.\n         */\n        updateVisible: function () {\n            this.visibleColumns = this.elems.filter('visible');\n\n            return this;\n        },\n\n        /**\n         * Checks if grid has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !!this.rows && !!this.rows.length;\n        },\n\n        /**\n         * Hides loader.\n         */\n        hideLoader: function () {\n            loader.get(this.name).hide();\n        },\n\n        /**\n         * Shows loader.\n         */\n        showLoader: function () {\n            loader.get(this.name).show();\n        },\n\n        /**\n         * Handler of the data providers' 'reload' event.\n         */\n        onBeforeReload: function () {\n            this.showLoader();\n        },\n\n        /**\n         * Handler of the data providers' 'reloaded' event.\n         */\n        onDataReloaded: function () {\n            resolver(this.hideLoader, this);\n        }\n    });\n});\n","Magento_Ui/js/grid/export.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiElement'\n], function ($, _, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/exportButton',\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n            checked: '',\n            additionalParams: [],\n            modules: {\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n  