require.config({"config": {
        "jsbuild":{"jquery/jquery-ui-1.9.2.js":"/*! jQuery UI - v1.9.2 - 2012-11-23\n* http://jqueryui.com\n* Includes: jquery.ui.core.js, jquery.ui.widget.js, jquery.ui.mouse.js, jquery.ui.draggable.js, jquery.ui.droppable.js, jquery.ui.resizable.js, jquery.ui.selectable.js, jquery.ui.sortable.js, jquery.ui.effect.js, jquery.ui.accordion.js, jquery.ui.autocomplete.js, jquery.ui.button.js, jquery.ui.datepicker.js, jquery.ui.dialog.js, jquery.ui.effect-blind.js, jquery.ui.effect-bounce.js, jquery.ui.effect-clip.js, jquery.ui.effect-drop.js, jquery.ui.effect-explode.js, jquery.ui.effect-fade.js, jquery.ui.effect-fold.js, jquery.ui.effect-highlight.js, jquery.ui.effect-pulsate.js, jquery.ui.effect-scale.js, jquery.ui.effect-shake.js, jquery.ui.effect-slide.js, jquery.ui.effect-transfer.js, jquery.ui.menu.js, jquery.ui.position.js, jquery.ui.progressbar.js, jquery.ui.slider.js, jquery.ui.spinner.js, jquery.ui.tabs.js, jquery.ui.tooltip.js\n* Copyright 2012 jQuery Foundation and other contributors; Licensed MIT */\n\n(function( $, undefined ) {\n\nvar uuid = 0,\n\truniqueId = /^ui-id-\\d+$/;\n\n// prevent duplicate loading\n// this is only a problem because we proxy existing functions\n// and we don't want to double proxy them\n$.ui = $.ui || {};\nif ( $.ui.version ) {\n\treturn;\n}\n\n$.extend( $.ui, {\n\tversion: \"1.9.2\",\n\n\tkeyCode: {\n\t\tBACKSPACE: 8,\n\t\tCOMMA: 188,\n\t\tDELETE: 46,\n\t\tDOWN: 40,\n\t\tEND: 35,\n\t\tENTER: 13,\n\t\tESCAPE: 27,\n\t\tHOME: 36,\n\t\tLEFT: 37,\n\t\tNUMPAD_ADD: 107,\n\t\tNUMPAD_DECIMAL: 110,\n\t\tNUMPAD_DIVIDE: 111,\n\t\tNUMPAD_ENTER: 108,\n\t\tNUMPAD_MULTIPLY: 106,\n\t\tNUMPAD_SUBTRACT: 109,\n\t\tPAGE_DOWN: 34,\n\t\tPAGE_UP: 33,\n\t\tPERIOD: 190,\n\t\tRIGHT: 39,\n\t\tSPACE: 32,\n\t\tTAB: 9,\n\t\tUP: 38\n\t}\n});\n\n// plugins\n$.fn.extend({\n\t_focus: $.fn.focus,\n\tfocus: function( delay, fn ) {\n\t\treturn typeof delay === \"number\" ?\n\t\t\tthis.each(function() {\n\t\t\t\tvar elem = this;\n\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t$( elem ).focus();\n\t\t\t\t\tif ( fn ) {\n\t\t\t\t\t\tfn.call( elem );\n\t\t\t\t\t}\n\t\t\t\t}, delay );\n\t\t\t}) :\n\t\t\tthis._focus.apply( this, arguments );\n\t},\n\n\tscrollParent: function() {\n\t\tvar scrollParent;\n\t\tif (($.ui.ie && (/(static|relative)/).test(this.css('position'))) || (/absolute/).test(this.css('position'))) {\n\t\t\tscrollParent = this.parents().filter(function() {\n\t\t\t\treturn (/(relative|absolute|fixed)/).test($.css(this,'position')) && (/(auto|scroll)/).test($.css(this,'overflow')+$.css(this,'overflow-y')+$.css(this,'overflow-x'));\n\t\t\t}).eq(0);\n\t\t} else {\n\t\t\tscrollParent = this.parents().filter(function() {\n\t\t\t\treturn (/(auto|scroll)/).test($.css(this,'overflow')+$.css(this,'overflow-y')+$.css(this,'overflow-x'));\n\t\t\t}).eq(0);\n\t\t}\n\n\t\treturn (/fixed/).test(this.css('position')) || !scrollParent.length ? $(document) : scrollParent;\n\t},\n\n\tzIndex: function( zIndex ) {\n\t\tif ( zIndex !== undefined ) {\n\t\t\treturn this.css( \"zIndex\", zIndex );\n\t\t}\n\n\t\tif ( this.length ) {\n\t\t\tvar elem = $( this[ 0 ] ), position, value;\n\t\t\twhile ( elem.length && elem[ 0 ] !== document ) {\n\t\t\t\t// Ignore z-index if position is set to a value where z-index is ignored by the browser\n\t\t\t\t// This makes behavior of this function consistent across browsers\n\t\t\t\t// WebKit always returns auto if the element is positioned\n\t\t\t\tposition = elem.css( \"position\" );\n\t\t\t\tif ( position === \"absolute\" || position === \"relative\" || position === \"fixed\" ) {\n\t\t\t\t\t// IE returns 0 when zIndex is not specified\n\t\t\t\t\t// other browsers return a string\n\t\t\t\t\t// we ignore the case of nested elements with an explicit value of 0\n\t\t\t\t\t// <div style=\"z-index: -10;\"><div style=\"z-index: 0;\"></div></div>\n\t\t\t\t\tvalue = parseInt( elem.css( \"zIndex\" ), 10 );\n\t\t\t\t\tif ( !isNaN( value ) && value !== 0 ) {\n\t\t\t\t\t\treturn value;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telem = elem.parent();\n\t\t\t}\n\t\t}\n\n\t\treturn 0;\n\t},\n\n\tuniqueId: function() {\n\t\treturn this.each(function() {\n\t\t\tif ( !this.id ) {\n\t\t\t\tthis.id = \"ui-id-\" + (++uuid);\n\t\t\t}\n\t\t});\n\t},\n\n\tremoveUniqueId: function() {\n\t\treturn this.each(function() {\n\t\t\tif ( runiqueId.test( this.id ) ) {\n\t\t\t\t$( this ).removeAttr( \"id\" );\n\t\t\t}\n\t\t});\n\t}\n});\n\n// selectors\nfunction focusable( element, isTabIndexNotNaN ) {\n\tvar map, mapName, img,\n\t\tnodeName = element.nodeName.toLowerCase();\n\tif ( \"area\" === nodeName ) {\n\t\tmap = element.parentNode;\n\t\tmapName = map.name;\n\t\tif ( !element.href || !mapName || map.nodeName.toLowerCase() !== \"map\" ) {\n\t\t\treturn false;\n\t\t}\n\t\timg = $( \"img[usemap=#\" + mapName + \"]\" )[0];\n\t\treturn !!img && visible( img );\n\t}\n\treturn ( /input|select|textarea|button|object/.test( nodeName ) ?\n\t\t!element.disabled :\n\t\t\"a\" === nodeName ?\n\t\t\telement.href || isTabIndexNotNaN :\n\t\t\tisTabIndexNotNaN) &&\n\t\t// the element and all of its ancestors must be visible\n\t\tvisible( element );\n}\n\nfunction visible( element ) {\n\treturn $.expr.filters.visible( element ) &&\n\t\t!$( element ).parents().andSelf().filter(function() {\n\t\t\treturn $.css( this, \"visibility\" ) === \"hidden\";\n\t\t}).length;\n}\n\n$.extend( $.expr[ \":\" ], {\n\tdata: $.expr.createPseudo ?\n\t\t$.expr.createPseudo(function( dataName ) {\n\t\t\treturn function( elem ) {\n\t\t\t\treturn !!$.data( elem, dataName );\n\t\t\t};\n\t\t}) :\n\t\t// support: jQuery <1.8\n\t\tfunction( elem, i, match ) {\n\t\t\treturn !!$.data( elem, match[ 3 ] );\n\t\t},\n\n\tfocusable: function( element ) {\n\t\treturn focusable( element, !isNaN( $.attr( element, \"tabindex\" ) ) );\n\t},\n\n\ttabbable: function( element ) {\n\t\tvar tabIndex = $.attr( element, \"tabindex\" ),\n\t\t\tisTabIndexNaN = isNaN( tabIndex );\n\t\treturn ( isTabIndexNaN || tabIndex >= 0 ) && focusable( element, !isTabIndexNaN );\n\t}\n});\n\n// support\n$(function() {\n\tvar body = document.body,\n\t\tdiv = body.appendChild( div = document.createElement( \"div\" ) );\n\n\t// access offsetHeight before setting the style to prevent a layout bug\n\t// in IE 9 which causes the element to continue to take up space even\n\t// after it is removed from the DOM (#8026)\n\tdiv.offsetHeight;\n\n\t$.extend( div.style, {\n\t\tminHeight: \"100px\",\n\t\theight: \"auto\",\n\t\tpadding: 0,\n\t\tborderWidth: 0\n\t});\n\n\t$.support.minHeight = div.offsetHeight === 100;\n\t$.support.selectstart = \"onselectstart\" in div;\n\n\t// set display to none to avoid a layout bug in IE\n\t// http://dev.jquery.com/ticket/4014\n\tbody.removeChild( div ).style.display = \"none\";\n});\n\n// support: jQuery <1.8\nif ( !$( \"<a>\" ).outerWidth( 1 ).jquery ) {\n\t$.each( [ \"Width\", \"Height\" ], function( i, name ) {\n\t\tvar side = name === \"Width\" ? [ \"Left\", \"Right\" ] : [ \"Top\", \"Bottom\" ],\n\t\t\ttype = name.toLowerCase(),\n\t\t\torig = {\n\t\t\t\tinnerWidth: $.fn.innerWidth,\n\t\t\t\tinnerHeight: $.fn.innerHeight,\n\t\t\t\touterWidth: $.fn.outerWidth,\n\t\t\t\touterHeight: $.fn.outerHeight\n\t\t\t};\n\n\t\tfunction reduce( elem, size, border, margin ) {\n\t\t\t$.each( side, function() {\n\t\t\t\tsize -= parseFloat( $.css( elem, \"padding\" + this ) ) || 0;\n\t\t\t\tif ( border ) {\n\t\t\t\t\tsize -= parseFloat( $.css( elem, \"border\" + this + \"Width\" ) ) || 0;\n\t\t\t\t}\n\t\t\t\tif ( margin ) {\n\t\t\t\t\tsize -= parseFloat( $.css( elem, \"margin\" + this ) ) || 0;\n\t\t\t\t}\n\t\t\t});\n\t\t\treturn size;\n\t\t}\n\n\t\t$.fn[ \"inner\" + name ] = function( size ) {\n\t\t\tif ( size === undefined ) {\n\t\t\t\treturn orig[ \"inner\" + name ].call( this );\n\t\t\t}\n\n\t\t\treturn this.each(function() {\n\t\t\t\t$( this ).css( type, reduce( this, size ) + \"px\" );\n\t\t\t});\n\t\t};\n\n\t\t$.fn[ \"outer\" + name] = function( size, margin ) {\n\t\t\tif ( typeof size !== \"number\" ) {\n\t\t\t\treturn orig[ \"outer\" + name ].call( this, size );\n\t\t\t}\n\n\t\t\treturn this.each(function() {\n\t\t\t\t$( this).css( type, reduce( this, size, true, margin ) + \"px\" );\n\t\t\t});\n\t\t};\n\t});\n}\n\n// support: jQuery 1.6.1, 1.6.2 (http://bugs.jquery.com/ticket/9413)\nif ( $( \"<a>\" ).data( \"a-b\", \"a\" ).removeData( \"a-b\" ).data( \"a-b\" ) ) {\n\t$.fn.removeData = (function( removeData ) {\n\t\treturn function( key ) {\n\t\t\tif ( arguments.length ) {\n\t\t\t\treturn removeData.call( this, $.camelCase( key ) );\n\t\t\t} else {\n\t\t\t\treturn removeData.call( this );\n\t\t\t}\n\t\t};\n\t})( $.fn.removeData );\n}\n\n\n\n\n\n// deprecated\n\n(function() {\n\tvar uaMatch = /msie ([\\w.]+)/.exec( navigator.userAgent.toLowerCase() ) || [];\n\t$.ui.ie = uaMatch.length ? true : false;\n\t$.ui.ie6 = parseFloat( uaMatch[ 1 ], 10 ) === 6;\n})();\n\n$.fn.extend({\n\tdisableSelection: function() {\n\t\treturn this.bind( ( $.support.selectstart ? \"selectstart\" : \"mousedown\" ) +\n\t\t\t\".ui-disableSelection\", function( event ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t});\n\t},\n\n\tenableSelection: function() {\n\t\treturn this.unbind( \".ui-disableSelection\" );\n\t}\n});\n\n$.extend( $.ui, {\n\t// $.ui.plugin is deprecated.  Use the proxy pattern instead.\n\tplugin: {\n\t\tadd: function( module, option, set ) {\n\t\t\tvar i,\n\t\t\t\tproto = $.ui[ module ].prototype;\n\t\t\tfor ( i in set ) {\n\t\t\t\tproto.plugins[ i ] = proto.plugins[ i ] || [];\n\t\t\t\tproto.plugins[ i ].push( [ option, set[ i ] ] );\n\t\t\t}\n\t\t},\n\t\tcall: function( instance, name, args ) {\n\t\t\tvar i,\n\t\t\t\tset = instance.plugins[ name ];\n\t\t\tif ( !set || !instance.element[ 0 ].parentNode || instance.element[ 0 ].parentNode.nodeType === 11 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tfor ( i = 0; i < set.length; i++ ) {\n\t\t\t\tif ( instance.options[ set[ i ][ 0 ] ] ) {\n\t\t\t\t\tset[ i ][ 1 ].apply( instance.element, args );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\n\tcontains: $.contains,\n\n\t// only used by resizable\n\thasScroll: function( el, a ) {\n\n\t\t//If overflow is hidden, the element might have extra content, but the user wants to hide it\n\t\tif ( $( el ).css( \"overflow\" ) === \"hidden\") {\n\t\t\treturn false;\n\t\t}\n\n\t\tvar scroll = ( a && a === \"left\" ) ? \"scrollLeft\" : \"scrollTop\",\n\t\t\thas = false;\n\n\t\tif ( el[ scroll ] > 0 ) {\n\t\t\treturn true;\n\t\t}\n\n\t\t// TODO: determine which cases actually cause this to happen\n\t\t// if the element doesn't have the scroll set, see if it's possible to\n\t\t// set the scroll\n\t\tel[ scroll ] = 1;\n\t\thas = ( el[ scroll ] > 0 );\n\t\tel[ scroll ] = 0;\n\t\treturn has;\n\t},\n\n\t// these are odd functions, fix the API or move into individual plugins\n\tisOverAxis: function( x, reference, size ) {\n\t\t//Determines when x coordinate is over \"b\" element axis\n\t\treturn ( x > reference ) && ( x < ( reference + size ) );\n\t},\n\tisOver: function( y, x, top, left, height, width ) {\n\t\t//Determines when x, y coordinates is over \"b\" element\n\t\treturn $.ui.isOverAxis( y, top, height ) && $.ui.isOverAxis( x, left, width );\n\t}\n});\n\n})( jQuery );\n\n(function( $, undefined ) {\n\nvar uuid = 0,\n\tslice = Array.prototype.slice,\n\t_cleanData = $.cleanData;\n$.cleanData = function( elems ) {\n\tfor ( var i = 0, elem; (elem = elems[i]) != null; i++ ) {\n\t\ttry {\n\t\t\t$( elem ).triggerHandler( \"remove\" );\n\t\t// http://bugs.jquery.com/ticket/8235\n\t\t} catch( e ) {}\n\t}\n\t_cleanData( elems );\n};\n\n$.widget = function( name, base, prototype ) {\n\tvar fullName, existingConstructor, constructor, basePrototype,\n\t\tnamespace = name.split( \".\" )[ 0 ];\n\n\tname = name.split( \".\" )[ 1 ];\n\tfullName = namespace + \"-\" + name;\n\n\tif ( !prototype ) {\n\t\tprototype = base;\n\t\tbase = $.Widget;\n\t}\n\n\t// create selector for plugin\n\t$.expr[ \":\" ][ fullName.toLowerCase() ] = function( elem ) {\n\t\treturn !!$.data( elem, fullName );\n\t};\n\n\t$[ namespace ] = $[ namespace ] || {};\n\texistingConstructor = $[ namespace ][ name ];\n\tconstructor = $[ namespace ][ name ] = function( options, element ) {\n\t\t// allow instantiation without \"new\" keyword\n\t\tif ( !this._createWidget ) {\n\t\t\treturn new constructor( options, element );\n\t\t}\n\n\t\t// allow instantiation without initializing for simple inheritance\n\t\t// must use \"new\" keyword (the code above always passes args)\n\t\tif ( arguments.length ) {\n\t\t\tthis._createWidget( options, element );\n\t\t}\n\t};\n\t// extend with the existing constructor to carry over any static properties\n\t$.extend( constructor, existingConstructor, {\n\t\tversion: prototype.version,\n\t\t// copy the object used to create the prototype in case we need to\n\t\t// redefine the widget later\n\t\t_proto: $.extend( {}, prototype ),\n\t\t// track widgets that inherit from this widget in case this widget is\n\t\t// redefined after a widget inherits from it\n\t\t_childConstructors: []\n\t});\n\n\tbasePrototype = new base();\n\t// we need to make the options hash a property directly on the new instance\n\t// otherwise we'll modify the options hash on the prototype that we're\n\t// inheriting from\n\tbasePrototype.options = $.widget.extend( {}, basePrototype.options );\n\t$.each( prototype, function( prop, value ) {\n\t\tif ( $.isFunction( value ) ) {\n\t\t\tprototype[ prop ] = (function() {\n\t\t\t\tvar _super = function() {\n\t\t\t\t\t\treturn base.prototype[ prop ].apply( this, arguments );\n\t\t\t\t\t},\n\t\t\t\t\t_superApply = function( args ) {\n\t\t\t\t\t\treturn base.prototype[ prop ].apply( this, args );\n\t\t\t\t\t};\n\t\t\t\treturn function() {\n\t\t\t\t\tvar __super = this._super,\n\t\t\t\t\t\t__superApply = this._superApply,\n\t\t\t\t\t\treturnValue;\n\n\t\t\t\t\tthis._super = _super;\n\t\t\t\t\tthis._superApply = _superApply;\n\n\t\t\t\t\treturnValue = value.apply( this, arguments );\n\n\t\t\t\t\tthis._super = __super;\n\t\t\t\t\tthis._superApply = __superApply;\n\n\t\t\t\t\treturn returnValue;\n\t\t\t\t};\n\t\t\t})();\n\t\t}\n\t});\n\tconstructor.prototype = $.widget.extend( basePrototype, {\n\t\t// TODO: remove support for widgetEventPrefix\n\t\t// always use the name + a colon as the prefix, e.g., draggable:start\n\t\t// don't prefix for widgets that aren't DOM-based\n\t\twidgetEventPrefix: existingConstructor ? basePrototype.widgetEventPrefix : name\n\t}, prototype, {\n\t\tconstructor: constructor,\n\t\tnamespace: namespace,\n\t\twidgetName: name,\n\t\t// TODO remove widgetBaseClass, see #8155\n\t\twidgetBaseClass: fullName,\n\t\twidgetFullName: fullName\n\t});\n\n\t// If this widget is being redefined then we need to find all widgets that\n\t// are inheriting from it and redefine all of them so that they inherit from\n\t// the new version of this widget. We're essentially trying to replace one\n\t// level in the prototype chain.\n\tif ( existingConstructor ) {\n\t\t$.each( existingConstructor._childConstructors, function( i, child ) {\n\t\t\tvar childPrototype = child.prototype;\n\n\t\t\t// redefine the child widget using the same prototype that was\n\t\t\t// originally used, but inherit from the new version of the base\n\t\t\t$.widget( childPrototype.namespace + \".\" + childPrototype.widgetName, constructor, child._proto );\n\t\t});\n\t\t// remove the list of existing child constructors from the old constructor\n\t\t// so the old child constructors can be garbage collected\n\t\tdelete existingConstructor._childConstructors;\n\t} else {\n\t\tbase._childConstructors.push( constructor );\n\t}\n\n\t$.widget.bridge( name, constructor );\n};\n\n$.widget.extend = function( target ) {\n\tvar input = slice.call( arguments, 1 ),\n\t\tinputIndex = 0,\n\t\tinputLength = input.length,\n\t\tkey,\n\t\tvalue;\n\tfor ( ; inputIndex < inputLength; inputIndex++ ) {\n\t\tfor ( key in input[ inputIndex ] ) {\n\t\t\tvalue = input[ inputIndex ][ key ];\n\t\t\tif ( input[ inputIndex ].hasOwnProperty( key ) && value !== undefined ) {\n\t\t\t\t// Clone objects\n\t\t\t\tif ( $.isPlainObject( value ) ) {\n\t\t\t\t\ttarget[ key ] = $.isPlainObject( target[ key ] ) ?\n\t\t\t\t\t\t$.widget.extend( {}, target[ key ], value ) :\n\t\t\t\t\t\t// Don't extend strings, arrays, etc. with objects\n\t\t\t\t\t\t$.widget.extend( {}, value );\n\t\t\t\t// Copy everything else by reference\n\t\t\t\t} else {\n\t\t\t\t\ttarget[ key ] = value;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\treturn target;\n};\n\n$.widget.bridge = function( name, object ) {\n\tvar fullName = object.prototype.widgetFullName || name;\n\t$.fn[ name ] = function( options ) {\n\t\tvar isMethodCall = typeof options === \"string\",\n\t\t\targs = slice.call( arguments, 1 ),\n\t\t\treturnValue = this;\n\n\t\t// allow multiple hashes to be passed on init\n\t\toptions = !isMethodCall && args.length ?\n\t\t\t$.widget.extend.apply( null, [ options ].concat(args) ) :\n\t\t\toptions;\n\n\t\tif ( isMethodCall ) {\n\t\t\tthis.each(function() {\n\t\t\t\tvar methodValue,\n\t\t\t\t\tinstance = $.data( this, fullName );\n\t\t\t\tif ( !instance ) {\n\t\t\t\t\treturn $.error( \"cannot call methods on \" + name + \" prior to initialization; \" +\n\t\t\t\t\t\t\"attempted to call method '\" + options + \"'\" );\n\t\t\t\t}\n\t\t\t\tif ( !$.isFunction( instance[options] ) || options.charAt( 0 ) === \"_\" ) {\n\t\t\t\t\treturn $.error( \"no such method '\" + options + \"' for \" + name + \" widget instance\" );\n\t\t\t\t}\n\t\t\t\tmethodValue = instance[ options ].apply( instance, args );\n\t\t\t\tif ( methodValue !== instance && methodValue !== undefined ) {\n\t\t\t\t\treturnValue = methodValue && methodValue.jquery ?\n\t\t\t\t\t\treturnValue.pushStack( methodValue.get() ) :\n\t\t\t\t\t\tmethodValue;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\t\t} else {\n\t\t\tthis.each(function() {\n\t\t\t\tvar instance = $.data( this, fullName );\n\t\t\t\tif ( instance ) {\n\t\t\t\t\tinstance.option( options || {} )._init();\n\t\t\t\t} else {\n\t\t\t\t\t$.data( this, fullName, new object( options, this ) );\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\n\t\treturn returnValue;\n\t};\n};\n\n$.Widget = function( /* options, element */ ) {};\n$.Widget._childConstructors = [];\n\n$.Widget.prototype = {\n\twidgetName: \"widget\",\n\twidgetEventPrefix: \"\",\n\tdefaultElement: \"<div>\",\n\toptions: {\n\t\tdisabled: false,\n\n\t\t// callbacks\n\t\tcreate: null\n\t},\n\t_createWidget: function( options, element ) {\n\t\telement = $( element || this.defaultElement || this )[ 0 ];\n\t\tthis.element = $( element );\n\t\tthis.uuid = uuid++;\n\t\tthis.eventNamespace = \".\" + this.widgetName + this.uuid;\n\t\tthis.options = $.widget.extend( {},\n\t\t\tthis.options,\n\t\t\tthis._getCreateOptions(),\n\t\t\toptions );\n\n\t\tthis.bindings = $();\n\t\tthis.hoverable = $();\n\t\tthis.focusable = $();\n\n\t\tif ( element !== this ) {\n\t\t\t// 1.9 BC for #7810\n\t\t\t// TODO remove dual storage\n\t\t\t$.data( element, this.widgetName, this );\n\t\t\t$.data( element, this.widgetFullName, this );\n\t\t\tthis._on( true, this.element, {\n\t\t\t\tremove: function( event ) {\n\t\t\t\t\tif ( event.target === element ) {\n\t\t\t\t\t\tthis.destroy();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t\tthis.document = $( element.style ?\n\t\t\t\t// element within the document\n\t\t\t\telement.ownerDocument :\n\t\t\t\t// element is window or document\n\t\t\t\telement.document || element );\n\t\t\tthis.window = $( this.document[0].defaultView || this.document[0].parentWindow );\n\t\t}\n\n\t\tthis._create();\n\t\tthis._trigger( \"create\", null, this._getCreateEventData() );\n\t\tthis._init();\n\t},\n\t_getCreateOptions: $.noop,\n\t_getCreateEventData: $.noop,\n\t_create: $.noop,\n\t_init: $.noop,\n\n\tdestroy: function() {\n\t\tthis._destroy();\n\t\t// we can probably remove the unbind calls in 2.0\n\t\t// all event bindings should go through this._on()\n\t\tthis.element\n\t\t\t.unbind( this.eventNamespace )\n\t\t\t// 1.9 BC for #7810\n\t\t\t// TODO remove dual storage\n\t\t\t.removeData( this.widgetName )\n\t\t\t.removeData( this.widgetFullName )\n\t\t\t// support: jquery <1.6.3\n\t\t\t// http://bugs.jquery.com/ticket/9413\n\t\t\t.removeData( $.camelCase( this.widgetFullName ) );\n\t\tthis.widget()\n\t\t\t.unbind( this.eventNamespace )\n\t\t\t.removeAttr( \"aria-disabled\" )\n\t\t\t.removeClass(\n\t\t\t\tthis.widgetFullName + \"-disabled \" +\n\t\t\t\t\"ui-state-disabled\" );\n\n\t\t// clean up events and states\n\t\tthis.bindings.unbind( this.eventNamespace );\n\t\tthis.hoverable.removeClass( \"ui-state-hover\" );\n\t\tthis.focusable.removeClass( \"ui-state-focus\" );\n\t},\n\t_destroy: $.noop,\n\n\twidget: function() {\n\t\treturn this.element;\n\t},\n\n\toption: function( key, value ) {\n\t\tvar options = key,\n\t\t\tparts,\n\t\t\tcurOption,\n\t\t\ti;\n\n\t\tif ( arguments.length === 0 ) {\n\t\t\t// don't return a reference to the internal hash\n\t\t\treturn $.widget.extend( {}, this.options );\n\t\t}\n\n\t\tif ( typeof key === \"string\" ) {\n\t\t\t// handle nested keys, e.g., \"foo.bar\" => { foo: { bar: ___ } }\n\t\t\toptions = {};\n\t\t\tparts = key.split( \".\" );\n\t\t\tkey = parts.shift();\n\t\t\tif ( parts.length ) {\n\t\t\t\tcurOption = options[ key ] = $.widget.extend( {}, this.options[ key ] );\n\t\t\t\tfor ( i = 0; i < parts.length - 1; i++ ) {\n\t\t\t\t\tcurOption[ parts[ i ] ] = curOption[ parts[ i ] ] || {};\n\t\t\t\t\tcurOption = curOption[ parts[ i ] ];\n\t\t\t\t}\n\t\t\t\tkey = parts.pop();\n\t\t\t\tif ( value === undefined ) {\n\t\t\t\t\treturn curOption[ key ] === undefined ? null : curOption[ key ];\n\t\t\t\t}\n\t\t\t\tcurOption[ key ] = value;\n\t\t\t} else {\n\t\t\t\tif ( value === undefined ) {\n\t\t\t\t\treturn this.options[ key ] === undefined ? null : this.options[ key ];\n\t\t\t\t}\n\t\t\t\toptions[ key ] = value;\n\t\t\t}\n\t\t}\n\n\t\tthis._setOptions( options );\n\n\t\treturn this;\n\t},\n\t_setOptions: function( options ) {\n\t\tvar key;\n\n\t\tfor ( key in options ) {\n\t\t\tthis._setOption( key, options[ key ] );\n\t\t}\n\n\t\treturn this;\n\t},\n\t_setOption: function( key, value ) {\n\t\tthis.options[ key ] = value;\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis.widget()\n\t\t\t\t.toggleClass( this.widgetFullName + \"-disabled ui-state-disabled\", !!value )\n\t\t\t\t.attr( \"aria-disabled\", value );\n\t\t\tthis.hoverable.removeClass( \"ui-state-hover\" );\n\t\t\tthis.focusable.removeClass( \"ui-state-focus\" );\n\t\t}\n\n\t\treturn this;\n\t},\n\n\tenable: function() {\n\t\treturn this._setOption( \"disabled\", false );\n\t},\n\tdisable: function() {\n\t\treturn this._setOption( \"disabled\", true );\n\t},\n\n\t_on: function( suppressDisabledCheck, element, handlers ) {\n\t\tvar delegateElement,\n\t\t\tinstance = this;\n\n\t\t// no suppressDisabledCheck flag, shuffle arguments\n\t\tif ( typeof suppressDisabledCheck !== \"boolean\" ) {\n\t\t\thandlers = element;\n\t\t\telement = suppressDisabledCheck;\n\t\t\tsuppressDisabledCheck = false;\n\t\t}\n\n\t\t// no element argument, shuffle and use this.element\n\t\tif ( !handlers ) {\n\t\t\thandlers = element;\n\t\t\telement = this.element;\n\t\t\tdelegateElement = this.widget();\n\t\t} else {\n\t\t\t// accept selectors, DOM elements\n\t\t\telement = delegateElement = $( element );\n\t\t\tthis.bindings = this.bindings.add( element );\n\t\t}\n\n\t\t$.each( handlers, function( event, handler ) {\n\t\t\tfunction handlerProxy() {\n\t\t\t\t// allow widgets to customize the disabled handling\n\t\t\t\t// - disabled as an array instead of boolean\n\t\t\t\t// - disabled class as method for disabling individual parts\n\t\t\t\tif ( !suppressDisabledCheck &&\n\t\t\t\t\t\t( instance.options.disabled === true ||\n\t\t\t\t\t\t\t$( this ).hasClass( \"ui-state-disabled\" ) ) ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\treturn ( typeof handler === \"string\" ? instance[ handler ] : handler )\n\t\t\t\t\t.apply( instance, arguments );\n\t\t\t}\n\n\t\t\t// copy the guid so direct unbinding works\n\t\t\tif ( typeof handler !== \"string\" ) {\n\t\t\t\thandlerProxy.guid = handler.guid =\n\t\t\t\t\thandler.guid || handlerProxy.guid || $.guid++;\n\t\t\t}\n\n\t\t\tvar match = event.match( /^(\\w+)\\s*(.*)$/ ),\n\t\t\t\teventName = match[1] + instance.eventNamespace,\n\t\t\t\tselector = match[2];\n\t\t\tif ( selector ) {\n\t\t\t\tdelegateElement.delegate( selector, eventName, handlerProxy );\n\t\t\t} else {\n\t\t\t\telement.bind( eventName, handlerProxy );\n\t\t\t}\n\t\t});\n\t},\n\n\t_off: function( element, eventName ) {\n\t\teventName = (eventName || \"\").split( \" \" ).join( this.eventNamespace + \" \" ) + this.eventNamespace;\n\t\telement.unbind( eventName ).undelegate( eventName );\n\t},\n\n\t_delay: function( handler, delay ) {\n\t\tfunction handlerProxy() {\n\t\t\treturn ( typeof handler === \"string\" ? instance[ handler ] : handler )\n\t\t\t\t.apply( instance, arguments );\n\t\t}\n\t\tvar instance = this;\n\t\treturn setTimeout( handlerProxy, delay || 0 );\n\t},\n\n\t_hoverable: function( element ) {\n\t\tthis.hoverable = this.hoverable.add( element );\n\t\tthis._on( element, {\n\t\t\tmouseenter: function( event ) {\n\t\t\t\t$( event.currentTarget ).addClass( \"ui-state-hover\" );\n\t\t\t},\n\t\t\tmouseleave: function( event ) {\n\t\t\t\t$( event.currentTarget ).removeClass( \"ui-state-hover\" );\n\t\t\t}\n\t\t});\n\t},\n\n\t_focusable: function( element ) {\n\t\tthis.focusable = this.focusable.add( element );\n\t\tthis._on( element, {\n\t\t\tfocusin: function( event ) {\n\t\t\t\t$( event.currentTarget ).addClass( \"ui-state-focus\" );\n\t\t\t},\n\t\t\tfocusout: function( event ) {\n\t\t\t\t$( event.currentTarget ).removeClass( \"ui-state-focus\" );\n\t\t\t}\n\t\t});\n\t},\n\n\t_trigger: function( type, event, data ) {\n\t\tvar prop, orig,\n\t\t\tcallback = this.options[ type ];\n\n\t\tdata = data || {};\n\t\tevent = $.Event( event );\n\t\tevent.type = ( type === this.widgetEventPrefix ?\n\t\t\ttype :\n\t\t\tthis.widgetEventPrefix + type ).toLowerCase();\n\t\t// the original event may come from any element\n\t\t// so we need to reset the target on the new event\n\t\tevent.target = this.element[ 0 ];\n\n\t\t// copy original event properties over to the new event\n\t\torig = event.originalEvent;\n\t\tif ( orig ) {\n\t\t\tfor ( prop in orig ) {\n\t\t\t\tif ( !( prop in event ) ) {\n\t\t\t\t\tevent[ prop ] = orig[ prop ];\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tthis.element.trigger( event, data );\n\t\treturn !( $.isFunction( callback ) &&\n\t\t\tcallback.apply( this.element[0], [ event ].concat( data ) ) === false ||\n\t\t\tevent.isDefaultPrevented() );\n\t}\n};\n\n$.each( { show: \"fadeIn\", hide: \"fadeOut\" }, function( method, defaultEffect ) {\n\t$.Widget.prototype[ \"_\" + method ] = function( element, options, callback ) {\n\t\tif ( typeof options === \"string\" ) {\n\t\t\toptions = { effect: options };\n\t\t}\n\t\tvar hasOptions,\n\t\t\teffectName = !options ?\n\t\t\t\tmethod :\n\t\t\t\toptions === true || typeof options === \"number\" ?\n\t\t\t\t\tdefaultEffect :\n\t\t\t\t\toptions.effect || defaultEffect;\n\t\toptions = options || {};\n\t\tif ( typeof options === \"number\" ) {\n\t\t\toptions = { duration: options };\n\t\t}\n\t\thasOptions = !$.isEmptyObject( options );\n\t\toptions.complete = callback;\n\t\tif ( options.delay ) {\n\t\t\telement.delay( options.delay );\n\t\t}\n\t\tif ( hasOptions && $.effects && ( $.effects.effect[ effectName ] || $.uiBackCompat !== false && $.effects[ effectName ] ) ) {\n\t\t\telement[ method ]( options );\n\t\t} else if ( effectName !== method && element[ effectName ] ) {\n\t\t\telement[ effectName ]( options.duration, options.easing, callback );\n\t\t} else {\n\t\t\telement.queue(function( next ) {\n\t\t\t\t$( this )[ method ]();\n\t\t\t\tif ( callback ) {\n\t\t\t\t\tcallback.call( element[ 0 ] );\n\t\t\t\t}\n\t\t\t\tnext();\n\t\t\t});\n\t\t}\n\t};\n});\n\n// DEPRECATED\nif ( $.uiBackCompat !== false ) {\n\t$.Widget.prototype._getCreateOptions = function() {\n\t\treturn $.metadata && $.metadata.get( this.element[0] )[ this.widgetName ];\n\t};\n}\n\n})( jQuery );\n\n(function( $, undefined ) {\n\nvar mouseHandled = false;\n$( document ).mouseup( function( e ) {\n\tmouseHandled = false;\n});\n\n$.widget(\"ui.mouse\", {\n\tversion: \"1.9.2\",\n\toptions: {\n\t\tcancel: 'input,textarea,button,select,option',\n\t\tdistance: 1,\n\t\tdelay: 0\n\t},\n\t_mouseInit: function() {\n\t\tvar that = this;\n\n\t\tthis.element\n\t\t\t.bind('mousedown.'+this.widgetName, function(event) {\n\t\t\t\treturn that._mouseDown(event);\n\t\t\t})\n\t\t\t.bind('click.'+this.widgetName, function(event) {\n\t\t\t\tif (true === $.data(event.target, that.widgetName + '.preventClickEvent')) {\n\t\t\t\t\t$.removeData(event.target, that.widgetName + '.preventClickEvent');\n\t\t\t\t\tevent.stopImmediatePropagation();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\tthis.started = false;\n\t},\n\n\t// TODO: make sure destroying one instance of mouse doesn't mess with\n\t// other instances of mouse\n\t_mouseDestroy: function() {\n\t\tthis.element.unbind('.'+this.widgetName);\n\t\tif ( this._mouseMoveDelegate ) {\n\t\t\t$(document)\n\t\t\t\t.unbind('mousemove.'+this.widgetName, this._mouseMoveDelegate)\n\t\t\t\t.unbind('mouseup.'+this.widgetName, this._mouseUpDelegate);\n\t\t}\n\t},\n\n\t_mouseDown: function(event) {\n\t\t// don't let more than one widget handle mouseStart\n\t\tif( mouseHandled ) { return; }\n\n\t\t// we may have missed mouseup (out of window)\n\t\t(this._mouseStarted && this._mouseUp(event));\n\n\t\tthis._mouseDownEvent = event;\n\n\t\tvar that = this,\n\t\t\tbtnIsLeft = (event.which === 1),\n\t\t\t// event.target.nodeName works around a bug in IE 8 with\n\t\t\t// disabled inputs (#7620)\n\t\t\telIsCancel = (typeof this.options.cancel === \"string\" && event.target.nodeName ? $(event.target).closest(this.options.cancel).length : false);\n\t\tif (!btnIsLeft || elIsCancel || !this._mouseCapture(event)) {\n\t\t\treturn true;\n\t\t}\n\n\t\tthis.mouseDelayMet = !this.options.delay;\n\t\tif (!this.mouseDelayMet) {\n\t\t\tthis._mouseDelayTimer = setTimeout(function() {\n\t\t\t\tthat.mouseDelayMet = true;\n\t\t\t}, this.options.delay);\n\t\t}\n\n\t\tif (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {\n\t\t\tthis._mouseStarted = (this._mouseStart(event) !== false);\n\t\t\tif (!this._mouseStarted) {\n\t\t\t\tevent.preventDefault();\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\n\t\t// Click event may never have fired (Gecko & Opera)\n\t\tif (true === $.data(event.target, this.widgetName + '.preventClickEvent')) {\n\t\t\t$.removeData(event.target, this.widgetName + '.preventClickEvent');\n\t\t}\n\n\t\t// these delegates are required to keep context\n\t\tthis._mouseMoveDelegate = function(event) {\n\t\t\treturn that._mouseMove(event);\n\t\t};\n\t\tthis._mouseUpDelegate = function(event) {\n\t\t\treturn that._mouseUp(event);\n\t\t};\n\t\t$(document)\n\t\t\t.bind('mousemove.'+this.widgetName, this._mouseMoveDelegate)\n\t\t\t.bind('mouseup.'+this.widgetName, this._mouseUpDelegate);\n\n\t\tevent.preventDefault();\n\n\t\tmouseHandled = true;\n\t\treturn true;\n\t},\n\n\t_mouseMove: function(event) {\n\t\t// IE mouseup check - mouseup happened when mouse was out of window\n\t\tif ($.ui.ie && !(document.documentMode >= 9) && !event.button) {\n\t\t\treturn this._mouseUp(event);\n\t\t}\n\n\t\tif (this._mouseStarted) {\n\t\t\tthis._mouseDrag(event);\n\t\t\treturn event.preventDefault();\n\t\t}\n\n\t\tif (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {\n\t\t\tthis._mouseStarted =\n\t\t\t\t(this._mouseStart(this._mouseDownEvent, event) !== false);\n\t\t\t(this._mouseStarted ? this._mouseDrag(event) : this._mouseUp(event));\n\t\t}\n\n\t\treturn !this._mouseStarted;\n\t},\n\n\t_mouseUp: function(event) {\n\t\t$(document)\n\t\t\t.unbind('mousemove.'+this.widgetName, this._mouseMoveDelegate)\n\t\t\t.unbind('mouseup.'+this.widgetName, this._mouseUpDelegate);\n\n\t\tif (this._mouseStarted) {\n\t\t\tthis._mouseStarted = false;\n\n\t\t\tif (event.target === this._mouseDownEvent.target) {\n\t\t\t\t$.data(event.target, this.widgetName + '.preventClickEvent', true);\n\t\t\t}\n\n\t\t\tthis._mouseStop(event);\n\t\t}\n\n\t\treturn false;\n\t},\n\n\t_mouseDistanceMet: function(event) {\n\t\treturn (Math.max(\n\t\t\t\tMath.abs(this._mouseDownEvent.pageX - event.pageX),\n\t\t\t\tMath.abs(this._mouseDownEvent.pageY - event.pageY)\n\t\t\t) >= this.options.distance\n\t\t);\n\t},\n\n\t_mouseDelayMet: function(event) {\n\t\treturn this.mouseDelayMet;\n\t},\n\n\t// These are placeholder methods, to be overridden by extending plugin\n\t_mouseStart: function(event) {},\n\t_mouseDrag: function(event) {},\n\t_mouseStop: function(event) {},\n\t_mouseCapture: function(event) { return true; }\n});\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.widget(\"ui.draggable\", $.ui.mouse, {\n\tversion: \"1.9.2\",\n\twidgetEventPrefix: \"drag\",\n\toptions: {\n\t\taddClasses: true,\n\t\tappendTo: \"parent\",\n\t\taxis: false,\n\t\tconnectToSortable: false,\n\t\tcontainment: false,\n\t\tcursor: \"auto\",\n\t\tcursorAt: false,\n\t\tgrid: false,\n\t\thandle: false,\n\t\thelper: \"original\",\n\t\tiframeFix: false,\n\t\topacity: false,\n\t\trefreshPositions: false,\n\t\trevert: false,\n\t\trevertDuration: 500,\n\t\tscope: \"default\",\n\t\tscroll: true,\n\t\tscrollSensitivity: 20,\n\t\tscrollSpeed: 20,\n\t\tsnap: false,\n\t\tsnapMode: \"both\",\n\t\tsnapTolerance: 20,\n\t\tstack: false,\n\t\tzIndex: false\n\t},\n\t_create: function() {\n\n\t\tif (this.options.helper == 'original' && !(/^(?:r|a|f)/).test(this.element.css(\"position\")))\n\t\t\tthis.element[0].style.position = 'relative';\n\n\t\t(this.options.addClasses && this.element.addClass(\"ui-draggable\"));\n\t\t(this.options.disabled && this.element.addClass(\"ui-draggable-disabled\"));\n\n\t\tthis._mouseInit();\n\n\t},\n\n\t_destroy: function() {\n\t\tthis.element.removeClass( \"ui-draggable ui-draggable-dragging ui-draggable-disabled\" );\n\t\tthis._mouseDestroy();\n\t},\n\n\t_mouseCapture: function(event) {\n\n\t\tvar o = this.options;\n\n\t\t// among others, prevent a drag on a resizable-handle\n\t\tif (this.helper || o.disabled || $(event.target).is('.ui-resizable-handle'))\n\t\t\treturn false;\n\n\t\t//Quit if we're not on a valid handle\n\t\tthis.handle = this._getHandle(event);\n\t\tif (!this.handle)\n\t\t\treturn false;\n\n\t\t$(o.iframeFix === true ? \"iframe\" : o.iframeFix).each(function() {\n\t\t\t$('<div class=\"ui-draggable-iframeFix\" style=\"background: #fff;\"></div>')\n\t\t\t.css({\n\t\t\t\twidth: this.offsetWidth+\"px\", height: this.offsetHeight+\"px\",\n\t\t\t\tposition: \"absolute\", opacity: \"0.001\", zIndex: 1000\n\t\t\t})\n\t\t\t.css($(this).offset())\n\t\t\t.appendTo(\"body\");\n\t\t});\n\n\t\treturn true;\n\n\t},\n\n\t_mouseStart: function(event) {\n\n\t\tvar o = this.options;\n\n\t\t//Create and append the visible helper\n\t\tthis.helper = this._createHelper(event);\n\n\t\tthis.helper.addClass(\"ui-draggable-dragging\");\n\n\t\t//Cache the helper size\n\t\tthis._cacheHelperProportions();\n\n\t\t//If ddmanager is used for droppables, set the global draggable\n\t\tif($.ui.ddmanager)\n\t\t\t$.ui.ddmanager.current = this;\n\n\t\t/*\n\t\t * - Position generation -\n\t\t * This block generates everything position related - it's the core of draggables.\n\t\t */\n\n\t\t//Cache the margins of the original element\n\t\tthis._cacheMargins();\n\n\t\t//Store the helper's css position\n\t\tthis.cssPosition = this.helper.css(\"position\");\n\t\tthis.scrollParent = this.helper.scrollParent();\n\n\t\t//The element's absolute position on the page minus margins\n\t\tthis.offset = this.positionAbs = this.element.offset();\n\t\tthis.offset = {\n\t\t\ttop: this.offset.top - this.margins.top,\n\t\t\tleft: this.offset.left - this.margins.left\n\t\t};\n\n\t\t$.extend(this.offset, {\n\t\t\tclick: { //Where the click happened, relative to the element\n\t\t\t\tleft: event.pageX - this.offset.left,\n\t\t\t\ttop: event.pageY - this.offset.top\n\t\t\t},\n\t\t\tparent: this._getParentOffset(),\n\t\t\trelative: this._getRelativeOffset() //This is a relative to absolute position minus the actual position calculation - only used for relative positioned helper\n\t\t});\n\n\t\t//Generate the original position\n\t\tthis.originalPosition = this.position = this._generatePosition(event);\n\t\tthis.originalPageX = event.pageX;\n\t\tthis.originalPageY = event.pageY;\n\n\t\t//Adjust the mouse offset relative to the helper if 'cursorAt' is supplied\n\t\t(o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt));\n\n\t\t//Set a containment if given in the options\n\t\tif(o.containment)\n\t\t\tthis._setContainment();\n\n\t\t//Trigger event + callbacks\n\t\tif(this._trigger(\"start\", event) === false) {\n\t\t\tthis._clear();\n\t\t\treturn false;\n\t\t}\n\n\t\t//Recache the helper size\n\t\tthis._cacheHelperProportions();\n\n\t\t//Prepare the droppable offsets\n\t\tif ($.ui.ddmanager && !o.dropBehaviour)\n\t\t\t$.ui.ddmanager.prepareOffsets(this, event);\n\n\n\t\tthis._mouseDrag(event, true); //Execute the drag once - this causes the helper not to be visible before getting its correct position\n\n\t\t//If the ddmanager is used for droppables, inform the manager that dragging has started (see #5003)\n\t\tif ( $.ui.ddmanager ) $.ui.ddmanager.dragStart(this, event);\n\n\t\treturn true;\n\t},\n\n\t_mouseDrag: function(event, noPropagation) {\n\n\t\t//Compute the helpers position\n\t\tthis.position = this._generatePosition(event);\n\t\tthis.positionAbs = this._convertPositionTo(\"absolute\");\n\n\t\t//Call plugins and callbacks and use the resulting position if something is returned\n\t\tif (!noPropagation) {\n\t\t\tvar ui = this._uiHash();\n\t\t\tif(this._trigger('drag', event, ui) === false) {\n\t\t\t\tthis._mouseUp({});\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tthis.position = ui.position;\n\t\t}\n\n\t\tif(!this.options.axis || this.options.axis != \"y\") this.helper[0].style.left = this.position.left+'px';\n\t\tif(!this.options.axis || this.options.axis != \"x\") this.helper[0].style.top = this.position.top+'px';\n\t\tif($.ui.ddmanager) $.ui.ddmanager.drag(this, event);\n\n\t\treturn false;\n\t},\n\n\t_mouseStop: function(event) {\n\n\t\t//If we are using droppables, inform the manager about the drop\n\t\tvar dropped = false;\n\t\tif ($.ui.ddmanager && !this.options.dropBehaviour)\n\t\t\tdropped = $.ui.ddmanager.drop(this, event);\n\n\t\t//if a drop comes from outside (a sortable)\n\t\tif(this.dropped) {\n\t\t\tdropped = this.dropped;\n\t\t\tthis.dropped = false;\n\t\t}\n\n\t\t//if the original element is no longer in the DOM don't bother to continue (see #8269)\n\t\tvar element = this.element[0], elementInDom = false;\n\t\twhile ( element && (element = element.parentNode) ) {\n\t\t\tif (element == document ) {\n\t\t\t\telementInDom = true;\n\t\t\t}\n\t\t}\n\t\tif ( !elementInDom && this.options.helper === \"original\" )\n\t\t\treturn false;\n\n\t\tif((this.options.revert == \"invalid\" && !dropped) || (this.options.revert == \"valid\" && dropped) || this.options.revert === true || ($.isFunction(this.options.revert) && this.options.revert.call(this.element, dropped))) {\n\t\t\tvar that = this;\n\t\t\t$(this.helper).animate(this.originalPosition, parseInt(this.options.revertDuration, 10), function() {\n\t\t\t\tif(that._trigger(\"stop\", event) !== false) {\n\t\t\t\t\tthat._clear();\n\t\t\t\t}\n\t\t\t});\n\t\t} else {\n\t\t\tif(this._trigger(\"stop\", event) !== false) {\n\t\t\t\tthis._clear();\n\t\t\t}\n\t\t}\n\n\t\treturn false;\n\t},\n\n\t_mouseUp: function(event) {\n\t\t//Remove frame helpers\n\t\t$(\"div.ui-draggable-iframeFix\").each(function() {\n\t\t\tthis.parentNode.removeChild(this);\n\t\t});\n\n\t\t//If the ddmanager is used for droppables, inform the manager that dragging has stopped (see #5003)\n\t\tif( $.ui.ddmanager ) $.ui.ddmanager.dragStop(this, event);\n\n\t\treturn $.ui.mouse.prototype._mouseUp.call(this, event);\n\t},\n\n\tcancel: function() {\n\n\t\tif(this.helper.is(\".ui-draggable-dragging\")) {\n\t\t\tthis._mouseUp({});\n\t\t} else {\n\t\t\tthis._clear();\n\t\t}\n\n\t\treturn this;\n\n\t},\n\n\t_getHandle: function(event) {\n\n\t\tvar handle = !this.options.handle || !$(this.options.handle, this.element).length ? true : false;\n\t\t$(this.options.handle, this.element)\n\t\t\t.find(\"*\")\n\t\t\t.andSelf()\n\t\t\t.each(function() {\n\t\t\t\tif(this == event.target) handle = true;\n\t\t\t});\n\n\t\treturn handle;\n\n\t},\n\n\t_createHelper: function(event) {\n\n\t\tvar o = this.options;\n\t\tvar helper = $.isFunction(o.helper) ? $(o.helper.apply(this.element[0], [event])) : (o.helper == 'clone' ? this.element.clone().removeAttr('id') : this.element);\n\n\t\tif(!helper.parents('body').length)\n\t\t\thelper.appendTo((o.appendTo == 'parent' ? this.element[0].parentNode : o.appendTo));\n\n\t\tif(helper[0] != this.element[0] && !(/(fixed|absolute)/).test(helper.css(\"position\")))\n\t\t\thelper.css(\"position\", \"absolute\");\n\n\t\treturn helper;\n\n\t},\n\n\t_adjustOffsetFromHelper: function(obj) {\n\t\tif (typeof obj == 'string') {\n\t\t\tobj = obj.split(' ');\n\t\t}\n\t\tif ($.isArray(obj)) {\n\t\t\tobj = {left: +obj[0], top: +obj[1] || 0};\n\t\t}\n\t\tif ('left' in obj) {\n\t\t\tthis.offset.click.left = obj.left + this.margins.left;\n\t\t}\n\t\tif ('right' in obj) {\n\t\t\tthis.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;\n\t\t}\n\t\tif ('top' in obj) {\n\t\t\tthis.offset.click.top = obj.top + this.margins.top;\n\t\t}\n\t\tif ('bottom' in obj) {\n\t\t\tthis.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;\n\t\t}\n\t},\n\n\t_getParentOffset: function() {\n\n\t\t//Get the offsetParent and cache its position\n\t\tthis.offsetParent = this.helper.offsetParent();\n\t\tvar po = this.offsetParent.offset();\n\n\t\t// This is a special case where we need to modify a offset calculated on start, since the following happened:\n\t\t// 1. The position of the helper is absolute, so it's position is calculated based on the next positioned parent\n\t\t// 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't the document, which means that\n\t\t//    the scroll is included in the initial calculation of the offset of the parent, and never recalculated upon drag\n\t\tif(this.cssPosition == 'absolute' && this.scrollParent[0] != document && $.contains(this.scrollParent[0], this.offsetParent[0])) {\n\t\t\tpo.left += this.scrollParent.scrollLeft();\n\t\t\tpo.top += this.scrollParent.scrollTop();\n\t\t}\n\n\t\tif((this.offsetParent[0] == document.body) //This needs to be actually done for all browsers, since pageX/pageY includes this information\n\t\t|| (this.offsetParent[0].tagName && this.offsetParent[0].tagName.toLowerCase() == 'html' && $.ui.ie)) //Ugly IE fix\n\t\t\tpo = { top: 0, left: 0 };\n\n\t\treturn {\n\t\t\ttop: po.top + (parseInt(this.offsetParent.css(\"borderTopWidth\"),10) || 0),\n\t\t\tleft: po.left + (parseInt(this.offsetParent.css(\"borderLeftWidth\"),10) || 0)\n\t\t};\n\n\t},\n\n\t_getRelativeOffset: function() {\n\n\t\tif(this.cssPosition == \"relative\") {\n\t\t\tvar p = this.element.position();\n\t\t\treturn {\n\t\t\t\ttop: p.top - (parseInt(this.helper.css(\"top\"),10) || 0) + this.scrollParent.scrollTop(),\n\t\t\t\tleft: p.left - (parseInt(this.helper.css(\"left\"),10) || 0) + this.scrollParent.scrollLeft()\n\t\t\t};\n\t\t} else {\n\t\t\treturn { top: 0, left: 0 };\n\t\t}\n\n\t},\n\n\t_cacheMargins: function() {\n\t\tthis.margins = {\n\t\t\tleft: (parseInt(this.element.css(\"marginLeft\"),10) || 0),\n\t\t\ttop: (parseInt(this.element.css(\"marginTop\"),10) || 0),\n\t\t\tright: (parseInt(this.element.css(\"marginRight\"),10) || 0),\n\t\t\tbottom: (parseInt(this.element.css(\"marginBottom\"),10) || 0)\n\t\t};\n\t},\n\n\t_cacheHelperProportions: function() {\n\t\tthis.helperProportions = {\n\t\t\twidth: this.helper.outerWidth(),\n\t\t\theight: this.helper.outerHeight()\n\t\t};\n\t},\n\n\t_setContainment: function() {\n\n\t\tvar o = this.options;\n\t\tif(o.containment == 'parent') o.containment = this.helper[0].parentNode;\n\t\tif(o.containment == 'document' || o.containment == 'window') this.containment = [\n\t\t\to.containment == 'document' ? 0 : $(window).scrollLeft() - this.offset.relative.left - this.offset.parent.left,\n\t\t\to.containment == 'document' ? 0 : $(window).scrollTop() - this.offset.relative.top - this.offset.parent.top,\n\t\t\t(o.containment == 'document' ? 0 : $(window).scrollLeft()) + $(o.containment == 'document' ? document : window).width() - this.helperProportions.width - this.margins.left,\n\t\t\t(o.containment == 'document' ? 0 : $(window).scrollTop()) + ($(o.containment == 'document' ? document : window).height() || document.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top\n\t\t];\n\n\t\tif(!(/^(document|window|parent)$/).test(o.containment) && o.containment.constructor != Array) {\n\t\t\tvar c = $(o.containment);\n\t\t\tvar ce = c[0]; if(!ce) return;\n\t\t\tvar co = c.offset();\n\t\t\tvar over = ($(ce).css(\"overflow\") != 'hidden');\n\n\t\t\tthis.containment = [\n\t\t\t\t(parseInt($(ce).css(\"borderLeftWidth\"),10) || 0) + (parseInt($(ce).css(\"paddingLeft\"),10) || 0),\n\t\t\t\t(parseInt($(ce).css(\"borderTopWidth\"),10) || 0) + (parseInt($(ce).css(\"paddingTop\"),10) || 0),\n\t\t\t\t(over ? Math.max(ce.scrollWidth,ce.offsetWidth) : ce.offsetWidth) - (parseInt($(ce).css(\"borderLeftWidth\"),10) || 0) - (parseInt($(ce).css(\"paddingRight\"),10) || 0) - this.helperProportions.width - this.margins.left - this.margins.right,\n\t\t\t\t(over ? Math.max(ce.scrollHeight,ce.offsetHeight) : ce.offsetHeight) - (parseInt($(ce).css(\"borderTopWidth\"),10) || 0) - (parseInt($(ce).css(\"paddingBottom\"),10) || 0) - this.helperProportions.height - this.margins.top  - this.margins.bottom\n\t\t\t];\n\t\t\tthis.relative_container = c;\n\n\t\t} else if(o.containment.constructor == Array) {\n\t\t\tthis.containment = o.containment;\n\t\t}\n\n\t},\n\n\t_convertPositionTo: function(d, pos) {\n\n\t\tif(!pos) pos = this.position;\n\t\tvar mod = d == \"absolute\" ? 1 : -1;\n\t\tvar o = this.options, scroll = this.cssPosition == 'absolute' && !(this.scrollParent[0] != document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent, scrollIsRootNode = (/(html|body)/i).test(scroll[0].tagName);\n\n\t\treturn {\n\t\t\ttop: (\n\t\t\t\tpos.top\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n\t\t\t\t+ this.offset.relative.top * mod\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\t+ this.offset.parent.top * mod\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\t- ( ( this.cssPosition == 'fixed' ? -this.scrollParent.scrollTop() : ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ) * mod)\n\t\t\t),\n\t\t\tleft: (\n\t\t\t\tpos.left\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n\t\t\t\t+ this.offset.relative.left * mod\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\t+ this.offset.parent.left * mod\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\t- ( ( this.cssPosition == 'fixed' ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft() ) * mod)\n\t\t\t)\n\t\t};\n\n\t},\n\n\t_generatePosition: function(event) {\n\n\t\tvar o = this.options, scroll = this.cssPosition == 'absolute' && !(this.scrollParent[0] != document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent, scrollIsRootNode = (/(html|body)/i).test(scroll[0].tagName);\n\t\tvar pageX = event.pageX;\n\t\tvar pageY = event.pageY;\n\n\t\t/*\n\t\t * - Position constraining -\n\t\t * Constrain the position to a mix of grid, containment.\n\t\t */\n\n\t\tif(this.originalPosition) { //If we are not dragging yet, we won't check for options\n\t\t\tvar containment;\n\t\t\tif(this.containment) {\n\t\t\tif (this.relative_container){\n\t\t\t\tvar co = this.relative_container.offset();\n\t\t\t\tcontainment = [ this.containment[0] + co.left,\n\t\t\t\t\tthis.containment[1] + co.top,\n\t\t\t\t\tthis.containment[2] + co.left,\n\t\t\t\t\tthis.containment[3] + co.top ];\n\t\t\t}\n\t\t\telse {\n\t\t\t\tcontainment = this.containment;\n\t\t\t}\n\n\t\t\t\tif(event.pageX - this.offset.click.left < containment[0]) pageX = containment[0] + this.offset.click.left;\n\t\t\t\tif(event.pageY - this.offset.click.top < containment[1]) pageY = containment[1] + this.offset.click.top;\n\t\t\t\tif(event.pageX - this.offset.click.left > containment[2]) pageX = containment[2] + this.offset.click.left;\n\t\t\t\tif(event.pageY - this.offset.click.top > containment[3]) pageY = containment[3] + this.offset.click.top;\n\t\t\t}\n\n\t\t\tif(o.grid) {\n\t\t\t\t//Check for grid elements set to 0 to prevent divide by 0 error causing invalid argument errors in IE (see ticket #6950)\n\t\t\t\tvar top = o.grid[1] ? this.originalPageY + Math.round((pageY - this.originalPageY) / o.grid[1]) * o.grid[1] : this.originalPageY;\n\t\t\t\tpageY = containment ? (!(top - this.offset.click.top < containment[1] || top - this.offset.click.top > containment[3]) ? top : (!(top - this.offset.click.top < containment[1]) ? top - o.grid[1] : top + o.grid[1])) : top;\n\n\t\t\t\tvar left = o.grid[0] ? this.originalPageX + Math.round((pageX - this.originalPageX) / o.grid[0]) * o.grid[0] : this.originalPageX;\n\t\t\t\tpageX = containment ? (!(left - this.offset.click.left < containment[0] || left - this.offset.click.left > containment[2]) ? left : (!(left - this.offset.click.left < containment[0]) ? left - o.grid[0] : left + o.grid[0])) : left;\n\t\t\t}\n\n\t\t}\n\n\t\treturn {\n\t\t\ttop: (\n\t\t\t\tpageY\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n\t\t\t\t- this.offset.click.top\t\t\t\t\t\t\t\t\t\t\t\t\t// Click offset (relative to the element)\n\t\t\t\t- this.offset.relative.top\t\t\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\t- this.offset.parent.top\t\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\t+ ( ( this.cssPosition == 'fixed' ? -this.scrollParent.scrollTop() : ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ))\n\t\t\t),\n\t\t\tleft: (\n\t\t\t\tpageX\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n\t\t\t\t- this.offset.click.left\t\t\t\t\t\t\t\t\t\t\t\t// Click offset (relative to the element)\n\t\t\t\t- this.offset.relative.left\t\t\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\t- this.offset.parent.left\t\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\t+ ( ( this.cssPosition == 'fixed' ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft() ))\n\t\t\t)\n\t\t};\n\n\t},\n\n\t_clear: function() {\n\t\tthis.helper.removeClass(\"ui-draggable-dragging\");\n\t\tif(this.helper[0] != this.element[0] && !this.cancelHelperRemoval) this.helper.remove();\n\t\t//if($.ui.ddmanager) $.ui.ddmanager.current = null;\n\t\tthis.helper = null;\n\t\tthis.cancelHelperRemoval = false;\n\t},\n\n\t// From now on bulk stuff - mainly helpers\n\n\t_trigger: function(type, event, ui) {\n\t\tui = ui || this._uiHash();\n\t\t$.ui.plugin.call(this, type, [event, ui]);\n\t\tif(type == \"drag\") this.positionAbs = this._convertPositionTo(\"absolute\"); //The absolute position has to be recalculated after plugins\n\t\treturn $.Widget.prototype._trigger.call(this, type, event, ui);\n\t},\n\n\tplugins: {},\n\n\t_uiHash: function(event) {\n\t\treturn {\n\t\t\thelper: this.helper,\n\t\t\tposition: this.position,\n\t\t\toriginalPosition: this.originalPosition,\n\t\t\toffset: this.positionAbs\n\t\t};\n\t}\n\n});\n\n$.ui.plugin.add(\"draggable\", \"connectToSortable\", {\n\tstart: function(event, ui) {\n\n\t\tvar inst = $(this).data(\"draggable\"), o = inst.options,\n\t\t\tuiSortable = $.extend({}, ui, { item: inst.element });\n\t\tinst.sortables = [];\n\t\t$(o.connectToSortable).each(function() {\n\t\t\tvar sortable = $.data(this, 'sortable');\n\t\t\tif (sortable && !sortable.options.disabled) {\n\t\t\t\tinst.sortables.push({\n\t\t\t\t\tinstance: sortable,\n\t\t\t\t\tshouldRevert: sortable.options.revert\n\t\t\t\t});\n\t\t\t\tsortable.refreshPositions();\t// Call the sortable's refreshPositions at drag start to refresh the containerCache since the sortable container cache is used in drag and needs to be up to date (this will ensure it's initialised as well as being kept in step with any changes that might have happened on the page).\n\t\t\t\tsortable._trigger(\"activate\", event, uiSortable);\n\t\t\t}\n\t\t});\n\n\t},\n\tstop: function(event, ui) {\n\n\t\t//If we are still over the sortable, we fake the stop event of the sortable, but also remove helper\n\t\tvar inst = $(this).data(\"draggable\"),\n\t\t\tuiSortable = $.extend({}, ui, { item: inst.element });\n\n\t\t$.each(inst.sortables, function() {\n\t\t\tif(this.instance.isOver) {\n\n\t\t\t\tthis.instance.isOver = 0;\n\n\t\t\t\tinst.cancelHelperRemoval = true; //Don't remove the helper in the draggable instance\n\t\t\t\tthis.instance.cancelHelperRemoval = false; //Remove it in the sortable instance (so sortable plugins like revert still work)\n\n\t\t\t\t//The sortable revert is supported, and we have to set a temporary dropped variable on the draggable to support revert: 'valid/invalid'\n\t\t\t\tif(this.shouldRevert) this.instance.options.revert = true;\n\n\t\t\t\t//Trigger the stop of the sortable\n\t\t\t\tthis.instance._mouseStop(event);\n\n\t\t\t\tthis.instance.options.helper = this.instance.options._helper;\n\n\t\t\t\t//If the helper has been the original item, restore properties in the sortable\n\t\t\t\tif(inst.options.helper == 'original')\n\t\t\t\t\tthis.instance.currentItem.css({ top: 'auto', left: 'auto' });\n\n\t\t\t} else {\n\t\t\t\tthis.instance.cancelHelperRemoval = false; //Remove the helper in the sortable instance\n\t\t\t\tthis.instance._trigger(\"deactivate\", event, uiSortable);\n\t\t\t}\n\n\t\t});\n\n\t},\n\tdrag: function(event, ui) {\n\n\t\tvar inst = $(this).data(\"draggable\"), that = this;\n\n\t\tvar checkPos = function(o) {\n\t\t\tvar dyClick = this.offset.click.top, dxClick = this.offset.click.left;\n\t\t\tvar helperTop = this.positionAbs.top, helperLeft = this.positionAbs.left;\n\t\t\tvar itemHeight = o.height, itemWidth = o.width;\n\t\t\tvar itemTop = o.top, itemLeft = o.left;\n\n\t\t\treturn $.ui.isOver(helperTop + dyClick, helperLeft + dxClick, itemTop, itemLeft, itemHeight, itemWidth);\n\t\t};\n\n\t\t$.each(inst.sortables, function(i) {\n\n\t\t\tvar innermostIntersecting = false;\n\t\t\tvar thisSortable = this;\n\t\t\t//Copy over some variables to allow calling the sortable's native _intersectsWith\n\t\t\tthis.instance.positionAbs = inst.positionAbs;\n\t\t\tthis.instance.helperProportions = inst.helperProportions;\n\t\t\tthis.instance.offset.click = inst.offset.click;\n\n\t\t\tif(this.instance._intersectsWith(this.instance.containerCache)) {\n\t\t\t\tinnermostIntersecting = true;\n\t\t\t\t$.each(inst.sortables, function () {\n\t\t\t\t\tthis.instance.positionAbs = inst.positionAbs;\n\t\t\t\t\tthis.instance.helperProportions = inst.helperProportions;\n\t\t\t\t\tthis.instance.offset.click = inst.offset.click;\n\t\t\t\t\tif  (this != thisSortable\n\t\t\t\t\t\t&& this.instance._intersectsWith(this.instance.containerCache)\n\t\t\t\t\t\t&& $.ui.contains(thisSortable.instance.element[0], this.instance.element[0]))\n\t\t\t\t\t\tinnermostIntersecting = false;\n\t\t\t\t\t\treturn innermostIntersecting;\n\t\t\t\t});\n\t\t\t}\n\n\n\t\t\tif(innermostIntersecting) {\n\t\t\t\t//If it intersects, we use a little isOver variable and set it once, so our move-in stuff gets fired only once\n\t\t\t\tif(!this.instance.isOver) {\n\n\t\t\t\t\tthis.instance.isOver = 1;\n\t\t\t\t\t//Now we fake the start of dragging for the sortable instance,\n\t\t\t\t\t//by cloning the list group item, appending it to the sortable and using it as inst.currentItem\n\t\t\t\t\t//We can then fire the start event of the sortable with our passed browser event, and our own helper (so it doesn't create a new one)\n\t\t\t\t\tthis.instance.currentItem = $(that).clone().removeAttr('id').appendTo(this.instance.element).data(\"sortable-item\", true);\n\t\t\t\t\tthis.instance.options._helper = this.instance.options.helper; //Store helper option to later restore it\n\t\t\t\t\tthis.instance.options.helper = function() { return ui.helper[0]; };\n\n\t\t\t\t\tevent.target = this.instance.currentItem[0];\n\t\t\t\t\tthis.instance._mouseCapture(event, true);\n\t\t\t\t\tthis.instance._mouseStart(event, true, true);\n\n\t\t\t\t\t//Because the browser event is way off the new appended portlet, we modify a couple of variables to reflect the changes\n\t\t\t\t\tthis.instance.offset.click.top = inst.offset.click.top;\n\t\t\t\t\tthis.instance.offset.click.left = inst.offset.click.left;\n\t\t\t\t\tthis.instance.offset.parent.left -= inst.offset.parent.left - this.instance.offset.parent.left;\n\t\t\t\t\tthis.instance.offset.parent.top -= inst.offset.parent.top - this.instance.offset.parent.top;\n\n\t\t\t\t\tinst._trigger(\"toSortable\", event);\n\t\t\t\t\tinst.dropped = this.instance.element; //draggable revert needs that\n\t\t\t\t\t//hack so receive/update callbacks work (mostly)\n\t\t\t\t\tinst.currentItem = inst.element;\n\t\t\t\t\tthis.instance.fromOutside = inst;\n\n\t\t\t\t}\n\n\t\t\t\t//Provided we did all the previous steps, we can fire the drag event of the sortable on every draggable drag, when it intersects with the sortable\n\t\t\t\tif(this.instance.currentItem) this.instance._mouseDrag(event);\n\n\t\t\t} else {\n\n\t\t\t\t//If it doesn't intersect with the sortable, and it intersected before,\n\t\t\t\t//we fake the drag stop of the sortable, but make sure it doesn't remove the helper by using cancelHelperRemoval\n\t\t\t\tif(this.instance.isOver) {\n\n\t\t\t\t\tthis.instance.isOver = 0;\n\t\t\t\t\tthis.instance.cancelHelperRemoval = true;\n\n\t\t\t\t\t//Prevent reverting on this forced stop\n\t\t\t\t\tthis.instance.options.revert = false;\n\n\t\t\t\t\t// The out event needs to be triggered independently\n\t\t\t\t\tthis.instance._trigger('out', event, this.instance._uiHash(this.instance));\n\n\t\t\t\t\tthis.instance._mouseStop(event, true);\n\t\t\t\t\tthis.instance.options.helper = this.instance.options._helper;\n\n\t\t\t\t\t//Now we remove our currentItem, the list group clone again, and the placeholder, and animate the helper back to it's original size\n\t\t\t\t\tthis.instance.currentItem.remove();\n\t\t\t\t\tif(this.instance.placeholder) this.instance.placeholder.remove();\n\n\t\t\t\t\tinst._trigger(\"fromSortable\", event);\n\t\t\t\t\tinst.dropped = false; //draggable revert needs that\n\t\t\t\t}\n\n\t\t\t};\n\n\t\t});\n\n\t}\n});\n\n$.ui.plugin.add(\"draggable\", \"cursor\", {\n\tstart: function(event, ui) {\n\t\tvar t = $('body'), o = $(this).data('draggable').options;\n\t\tif (t.css(\"cursor\")) o._cursor = t.css(\"cursor\");\n\t\tt.css(\"cursor\", o.cursor);\n\t},\n\tstop: function(event, ui) {\n\t\tvar o = $(this).data('draggable').options;\n\t\tif (o._cursor) $('body').css(\"cursor\", o._cursor);\n\t}\n});\n\n$.ui.plugin.add(\"draggable\", \"opacity\", {\n\tstart: function(event, ui) {\n\t\tvar t = $(ui.helper), o = $(this).data('draggable').options;\n\t\tif(t.css(\"opacity\")) o._opacity = t.css(\"opacity\");\n\t\tt.css('opacity', o.opacity);\n\t},\n\tstop: function(event, ui) {\n\t\tvar o = $(this).data('draggable').options;\n\t\tif(o._opacity) $(ui.helper).css('opacity', o._opacity);\n\t}\n});\n\n$.ui.plugin.add(\"draggable\", \"scroll\", {\n\tstart: function(event, ui) {\n\t\tvar i = $(this).data(\"draggable\");\n\t\tif(i.scrollParent[0] != document && i.scrollParent[0].tagName != 'HTML') i.overflowOffset = i.scrollParent.offset();\n\t},\n\tdrag: function(event, ui) {\n\n\t\tvar i = $(this).data(\"draggable\"), o = i.options, scrolled = false;\n\n\t\tif(i.scrollParent[0] != document && i.scrollParent[0].tagName != 'HTML') {\n\n\t\t\tif(!o.axis || o.axis != 'x') {\n\t\t\t\tif((i.overflowOffset.top + i.scrollParent[0].offsetHeight) - event.pageY < o.scrollSensitivity)\n\t\t\t\t\ti.scrollParent[0].scrollTop = scrolled = i.scrollParent[0].scrollTop + o.scrollSpeed;\n\t\t\t\telse if(event.pageY - i.overflowOffset.top < o.scrollSensitivity)\n\t\t\t\t\ti.scrollParent[0].scrollTop = scrolled = i.scrollParent[0].scrollTop - o.scrollSpeed;\n\t\t\t}\n\n\t\t\tif(!o.axis || o.axis != 'y') {\n\t\t\t\tif((i.overflowOffset.left + i.scrollParent[0].offsetWidth) - event.pageX < o.scrollSensitivity)\n\t\t\t\t\ti.scrollParent[0].scrollLeft = scrolled = i.scrollParent[0].scrollLeft + o.scrollSpeed;\n\t\t\t\telse if(event.pageX - i.overflowOffset.left < o.scrollSensitivity)\n\t\t\t\t\ti.scrollParent[0].scrollLeft = scrolled = i.scrollParent[0].scrollLeft - o.scrollSpeed;\n\t\t\t}\n\n\t\t} else {\n\n\t\t\tif(!o.axis || o.axis != 'x') {\n\t\t\t\tif(event.pageY - $(document).scrollTop() < o.scrollSensitivity)\n\t\t\t\t\tscrolled = $(document).scrollTop($(document).scrollTop() - o.scrollSpeed);\n\t\t\t\telse if($(window).height() - (event.pageY - $(document).scrollTop()) < o.scrollSensitivity)\n\t\t\t\t\tscrolled = $(document).scrollTop($(document).scrollTop() + o.scrollSpeed);\n\t\t\t}\n\n\t\t\tif(!o.axis || o.axis != 'y') {\n\t\t\t\tif(event.pageX - $(document).scrollLeft() < o.scrollSensitivity)\n\t\t\t\t\tscrolled = $(document).scrollLeft($(document).scrollLeft() - o.scrollSpeed);\n\t\t\t\telse if($(window).width() - (event.pageX - $(document).scrollLeft()) < o.scrollSensitivity)\n\t\t\t\t\tscrolled = $(document).scrollLeft($(document).scrollLeft() + o.scrollSpeed);\n\t\t\t}\n\n\t\t}\n\n\t\tif(scrolled !== false && $.ui.ddmanager && !o.dropBehaviour)\n\t\t\t$.ui.ddmanager.prepareOffsets(i, event);\n\n\t}\n});\n\n$.ui.plugin.add(\"draggable\", \"snap\", {\n\tstart: function(event, ui) {\n\n\t\tvar i = $(this).data(\"draggable\"), o = i.options;\n\t\ti.snapElements = [];\n\n\t\t$(o.snap.constructor != String ? ( o.snap.items || ':data(draggable)' ) : o.snap).each(function() {\n\t\t\tvar $t = $(this); var $o = $t.offset();\n\t\t\tif(this != i.element[0]) i.snapElements.push({\n\t\t\t\titem: this,\n\t\t\t\twidth: $t.outerWidth(), height: $t.outerHeight(),\n\t\t\t\ttop: $o.top, left: $o.left\n\t\t\t});\n\t\t});\n\n\t},\n\tdrag: function(event, ui) {\n\n\t\tvar inst = $(this).data(\"draggable\"), o = inst.options;\n\t\tvar d = o.snapTolerance;\n\n\t\tvar x1 = ui.offset.left, x2 = x1 + inst.helperProportions.width,\n\t\t\ty1 = ui.offset.top, y2 = y1 + inst.helperProportions.height;\n\n\t\tfor (var i = inst.snapElements.length - 1; i >= 0; i--){\n\n\t\t\tvar l = inst.snapElements[i].left, r = l + inst.snapElements[i].width,\n\t\t\t\tt = inst.snapElements[i].top, b = t + inst.snapElements[i].height;\n\n\t\t\t//Yes, I know, this is insane ;)\n\t\t\tif(!((l-d < x1 && x1 < r+d && t-d < y1 && y1 < b+d) || (l-d < x1 && x1 < r+d && t-d < y2 && y2 < b+d) || (l-d < x2 && x2 < r+d && t-d < y1 && y1 < b+d) || (l-d < x2 && x2 < r+d && t-d < y2 && y2 < b+d))) {\n\t\t\t\tif(inst.snapElements[i].snapping) (inst.options.snap.release && inst.options.snap.release.call(inst.element, event, $.extend(inst._uiHash(), { snapItem: inst.snapElements[i].item })));\n\t\t\t\tinst.snapElements[i].snapping = false;\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tif(o.snapMode != 'inner') {\n\t\t\t\tvar ts = Math.abs(t - y2) <= d;\n\t\t\t\tvar bs = Math.abs(b - y1) <= d;\n\t\t\t\tvar ls = Math.abs(l - x2) <= d;\n\t\t\t\tvar rs = Math.abs(r - x1) <= d;\n\t\t\t\tif(ts) ui.position.top = inst._convertPositionTo(\"relative\", { top: t - inst.helperProportions.height, left: 0 }).top - inst.margins.top;\n\t\t\t\tif(bs) ui.position.top = inst._convertPositionTo(\"relative\", { top: b, left: 0 }).top - inst.margins.top;\n\t\t\t\tif(ls) ui.position.left = inst._convertPositionTo(\"relative\", { top: 0, left: l - inst.helperProportions.width }).left - inst.margins.left;\n\t\t\t\tif(rs) ui.position.left = inst._convertPositionTo(\"relative\", { top: 0, left: r }).left - inst.margins.left;\n\t\t\t}\n\n\t\t\tvar first = (ts || bs || ls || rs);\n\n\t\t\tif(o.snapMode != 'outer') {\n\t\t\t\tvar ts = Math.abs(t - y1) <= d;\n\t\t\t\tvar bs = Math.abs(b - y2) <= d;\n\t\t\t\tvar ls = Math.abs(l - x1) <= d;\n\t\t\t\tvar rs = Math.abs(r - x2) <= d;\n\t\t\t\tif(ts) ui.position.top = inst._convertPositionTo(\"relative\", { top: t, left: 0 }).top - inst.margins.top;\n\t\t\t\tif(bs) ui.position.top = inst._convertPositionTo(\"relative\", { top: b - inst.helperProportions.height, left: 0 }).top - inst.margins.top;\n\t\t\t\tif(ls) ui.position.left = inst._convertPositionTo(\"relative\", { top: 0, left: l }).left - inst.margins.left;\n\t\t\t\tif(rs) ui.position.left = inst._convertPositionTo(\"relative\", { top: 0, left: r - inst.helperProportions.width }).left - inst.margins.left;\n\t\t\t}\n\n\t\t\tif(!inst.snapElements[i].snapping && (ts || bs || ls || rs || first))\n\t\t\t\t(inst.options.snap.snap && inst.options.snap.snap.call(inst.element, event, $.extend(inst._uiHash(), { snapItem: inst.snapElements[i].item })));\n\t\t\tinst.snapElements[i].snapping = (ts || bs || ls || rs || first);\n\n\t\t};\n\n\t}\n});\n\n$.ui.plugin.add(\"draggable\", \"stack\", {\n\tstart: function(event, ui) {\n\n\t\tvar o = $(this).data(\"draggable\").options;\n\n\t\tvar group = $.makeArray($(o.stack)).sort(function(a,b) {\n\t\t\treturn (parseInt($(a).css(\"zIndex\"),10) || 0) - (parseInt($(b).css(\"zIndex\"),10) || 0);\n\t\t});\n\t\tif (!group.length) { return; }\n\n\t\tvar min = parseInt(group[0].style.zIndex) || 0;\n\t\t$(group).each(function(i) {\n\t\t\tthis.style.zIndex = min + i;\n\t\t});\n\n\t\tthis[0].style.zIndex = min + group.length;\n\n\t}\n});\n\n$.ui.plugin.add(\"draggable\", \"zIndex\", {\n\tstart: function(event, ui) {\n\t\tvar t = $(ui.helper), o = $(this).data(\"draggable\").options;\n\t\tif(t.css(\"zIndex\")) o._zIndex = t.css(\"zIndex\");\n\t\tt.css('zIndex', o.zIndex);\n\t},\n\tstop: function(event, ui) {\n\t\tvar o = $(this).data(\"draggable\").options;\n\t\tif(o._zIndex) $(ui.helper).css('zIndex', o._zIndex);\n\t}\n});\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.widget(\"ui.droppable\", {\n\tversion: \"1.9.2\",\n\twidgetEventPrefix: \"drop\",\n\toptions: {\n\t\taccept: '*',\n\t\tactiveClass: false,\n\t\taddClasses: true,\n\t\tgreedy: false,\n\t\thoverClass: false,\n\t\tscope: 'default',\n\t\ttolerance: 'intersect'\n\t},\n\t_create: function() {\n\n\t\tvar o = this.options, accept = o.accept;\n\t\tthis.isover = 0; this.isout = 1;\n\n\t\tthis.accept = $.isFunction(accept) ? accept : function(d) {\n\t\t\treturn d.is(accept);\n\t\t};\n\n\t\t//Store the droppable's proportions\n\t\tthis.proportions = { width: this.element[0].offsetWidth, height: this.element[0].offsetHeight };\n\n\t\t// Add the reference and positions to the manager\n\t\t$.ui.ddmanager.droppables[o.scope] = $.ui.ddmanager.droppables[o.scope] || [];\n\t\t$.ui.ddmanager.droppables[o.scope].push(this);\n\n\t\t(o.addClasses && this.element.addClass(\"ui-droppable\"));\n\n\t},\n\n\t_destroy: function() {\n\t\tvar drop = $.ui.ddmanager.droppables[this.options.scope];\n\t\tfor ( var i = 0; i < drop.length; i++ )\n\t\t\tif ( drop[i] == this )\n\t\t\t\tdrop.splice(i, 1);\n\n\t\tthis.element.removeClass(\"ui-droppable ui-droppable-disabled\");\n\t},\n\n\t_setOption: function(key, value) {\n\n\t\tif(key == 'accept') {\n\t\t\tthis.accept = $.isFunction(value) ? value : function(d) {\n\t\t\t\treturn d.is(value);\n\t\t\t};\n\t\t}\n\t\t$.Widget.prototype._setOption.apply(this, arguments);\n\t},\n\n\t_activate: function(event) {\n\t\tvar draggable = $.ui.ddmanager.current;\n\t\tif(this.options.activeClass) this.element.addClass(this.options.activeClass);\n\t\t(draggable && this._trigger('activate', event, this.ui(draggable)));\n\t},\n\n\t_deactivate: function(event) {\n\t\tvar draggable = $.ui.ddmanager.current;\n\t\tif(this.options.activeClass) this.element.removeClass(this.options.activeClass);\n\t\t(draggable && this._trigger('deactivate', event, this.ui(draggable)));\n\t},\n\n\t_over: function(event) {\n\n\t\tvar draggable = $.ui.ddmanager.current;\n\t\tif (!draggable || (draggable.currentItem || draggable.element)[0] == this.element[0]) return; // Bail if draggable and droppable are same element\n\n\t\tif (this.accept.call(this.element[0],(draggable.currentItem || draggable.element))) {\n\t\t\tif(this.options.hoverClass) this.element.addClass(this.options.hoverClass);\n\t\t\tthis._trigger('over', event, this.ui(draggable));\n\t\t}\n\n\t},\n\n\t_out: function(event) {\n\n\t\tvar draggable = $.ui.ddmanager.current;\n\t\tif (!draggable || (draggable.currentItem || draggable.element)[0] == this.element[0]) return; // Bail if draggable and droppable are same element\n\n\t\tif (this.accept.call(this.element[0],(draggable.currentItem || draggable.element))) {\n\t\t\tif(this.options.hoverClass) this.element.removeClass(this.options.hoverClass);\n\t\t\tthis._trigger('out', event, this.ui(draggable));\n\t\t}\n\n\t},\n\n\t_drop: function(event,custom) {\n\n\t\tvar draggable = custom || $.ui.ddmanager.current;\n\t\tif (!draggable || (draggable.currentItem || draggable.element)[0] == this.element[0]) return false; // Bail if draggable and droppable are same element\n\n\t\tvar childrenIntersection = false;\n\t\tthis.element.find(\":data(droppable)\").not(\".ui-draggable-dragging\").each(function() {\n\t\t\tvar inst = $.data(this, 'droppable');\n\t\t\tif(\n\t\t\t\tinst.options.greedy\n\t\t\t\t&& !inst.options.disabled\n\t\t\t\t&& inst.options.scope == draggable.options.scope\n\t\t\t\t&& inst.accept.call(inst.element[0], (draggable.currentItem || draggable.element))\n\t\t\t\t&& $.ui.intersect(draggable, $.extend(inst, { offset: inst.element.offset() }), inst.options.tolerance)\n\t\t\t) { childrenIntersection = true; return false; }\n\t\t});\n\t\tif(childrenIntersection) return false;\n\n\t\tif(this.accept.call(this.element[0],(draggable.currentItem || draggable.element))) {\n\t\t\tif(this.options.activeClass) this.element.removeClass(this.options.activeClass);\n\t\t\tif(this.options.hoverClass) this.element.removeClass(this.options.hoverClass);\n\t\t\tthis._trigger('drop', event, this.ui(draggable));\n\t\t\treturn this.element;\n\t\t}\n\n\t\treturn false;\n\n\t},\n\n\tui: function(c) {\n\t\treturn {\n\t\t\tdraggable: (c.currentItem || c.element),\n\t\t\thelper: c.helper,\n\t\t\tposition: c.position,\n\t\t\toffset: c.positionAbs\n\t\t};\n\t}\n\n});\n\n$.ui.intersect = function(draggable, droppable, toleranceMode) {\n\n\tif (!droppable.offset) return false;\n\n\tvar x1 = (draggable.positionAbs || draggable.position.absolute).left, x2 = x1 + draggable.helperProportions.width,\n\t\ty1 = (draggable.positionAbs || draggable.position.absolute).top, y2 = y1 + draggable.helperProportions.height;\n\tvar l = droppable.offset.left, r = l + droppable.proportions.width,\n\t\tt = droppable.offset.top, b = t + droppable.proportions.height;\n\n\tswitch (toleranceMode) {\n\t\tcase 'fit':\n\t\t\treturn (l <= x1 && x2 <= r\n\t\t\t\t&& t <= y1 && y2 <= b);\n\t\t\tbreak;\n\t\tcase 'intersect':\n\t\t\treturn (l < x1 + (draggable.helperProportions.width / 2) // Right Half\n\t\t\t\t&& x2 - (draggable.helperProportions.width / 2) < r // Left Half\n\t\t\t\t&& t < y1 + (draggable.helperProportions.height / 2) // Bottom Half\n\t\t\t\t&& y2 - (draggable.helperProportions.height / 2) < b ); // Top Half\n\t\t\tbreak;\n\t\tcase 'pointer':\n\t\t\tvar draggableLeft = ((draggable.positionAbs || draggable.position.absolute).left + (draggable.clickOffset || draggable.offset.click).left),\n\t\t\t\tdraggableTop = ((draggable.positionAbs || draggable.position.absolute).top + (draggable.clickOffset || draggable.offset.click).top),\n\t\t\t\tisOver = $.ui.isOver(draggableTop, draggableLeft, t, l, droppable.proportions.height, droppable.proportions.width);\n\t\t\treturn isOver;\n\t\t\tbreak;\n\t\tcase 'touch':\n\t\t\treturn (\n\t\t\t\t\t(y1 >= t && y1 <= b) ||\t// Top edge touching\n\t\t\t\t\t(y2 >= t && y2 <= b) ||\t// Bottom edge touching\n\t\t\t\t\t(y1 < t && y2 > b)\t\t// Surrounded vertically\n\t\t\t\t) && (\n\t\t\t\t\t(x1 >= l && x1 <= r) ||\t// Left edge touching\n\t\t\t\t\t(x2 >= l && x2 <= r) ||\t// Right edge touching\n\t\t\t\t\t(x1 < l && x2 > r)\t\t// Surrounded horizontally\n\t\t\t\t);\n\t\t\tbreak;\n\t\tdefault:\n\t\t\treturn false;\n\t\t\tbreak;\n\t\t}\n\n};\n\n/*\n\tThis manager tracks offsets of draggables and droppables\n*/\n$.ui.ddmanager = {\n\tcurrent: null,\n\tdroppables: { 'default': [] },\n\tprepareOffsets: function(t, event) {\n\n\t\tvar m = $.ui.ddmanager.droppables[t.options.scope] || [];\n\t\tvar type = event ? event.type : null; // workaround for #2317\n\t\tvar list = (t.currentItem || t.element).find(\":data(droppable)\").andSelf();\n\n\t\tdroppablesLoop: for (var i = 0; i < m.length; i++) {\n\n\t\t\tif(m[i].options.disabled || (t && !m[i].accept.call(m[i].element[0],(t.currentItem || t.element)))) continue;\t//No disabled and non-accepted\n\t\t\tfor (var j=0; j < list.length; j++) { if(list[j] == m[i].element[0]) { m[i].proportions.height = 0; continue droppablesLoop; } }; //Filter out elements in the current dragged item\n\t\t\tm[i].visible = m[i].element.css(\"display\") != \"none\"; if(!m[i].visible) continue; \t\t\t\t\t\t\t\t\t//If the element is not visible, continue\n\n\t\t\tif(type == \"mousedown\") m[i]._activate.call(m[i], event); //Activate the droppable if used directly from draggables\n\n\t\t\tm[i].offset = m[i].element.offset();\n\t\t\tm[i].proportions = { width: m[i].element[0].offsetWidth, height: m[i].element[0].offsetHeight };\n\n\t\t}\n\n\t},\n\tdrop: function(draggable, event) {\n\n\t\tvar dropped = false;\n\t\t$.each($.ui.ddmanager.droppables[draggable.options.scope] || [], function() {\n\n\t\t\tif(!this.options) return;\n\t\t\tif (!this.options.disabled && this.visible && $.ui.intersect(draggable, this, this.options.tolerance))\n\t\t\t\tdropped = this._drop.call(this, event) || dropped;\n\n\t\t\tif (!this.options.disabled && this.visible && this.accept.call(this.element[0],(draggable.currentItem || draggable.element))) {\n\t\t\t\tthis.isout = 1; this.isover = 0;\n\t\t\t\tthis._deactivate.call(this, event);\n\t\t\t}\n\n\t\t});\n\t\treturn dropped;\n\n\t},\n\tdragStart: function( draggable, event ) {\n\t\t//Listen for scrolling so that if the dragging causes scrolling the position of the droppables can be recalculated (see #5003)\n\t\tdraggable.element.parentsUntil( \"body\" ).bind( \"scroll.droppable\", function() {\n\t\t\tif( !draggable.options.refreshPositions ) $.ui.ddmanager.prepareOffsets( draggable, event );\n\t\t});\n\t},\n\tdrag: function(draggable, event) {\n\n\t\t//If you have a highly dynamic page, you might try this option. It renders positions every time you move the mouse.\n\t\tif(draggable.options.refreshPositions) $.ui.ddmanager.prepareOffsets(draggable, event);\n\n\t\t//Run through all droppables and check their positions based on specific tolerance options\n\t\t$.each($.ui.ddmanager.droppables[draggable.options.scope] || [], function() {\n\n\t\t\tif(this.options.disabled || this.greedyChild || !this.visible) return;\n\t\t\tvar intersects = $.ui.intersect(draggable, this, this.options.tolerance);\n\n\t\t\tvar c = !intersects && this.isover == 1 ? 'isout' : (intersects && this.isover == 0 ? 'isover' : null);\n\t\t\tif(!c) return;\n\n\t\t\tvar parentInstance;\n\t\t\tif (this.options.greedy) {\n\t\t\t\t// find droppable parents with same scope\n\t\t\t\tvar scope = this.options.scope;\n\t\t\t\tvar parent = this.element.parents(':data(droppable)').filter(function () {\n\t\t\t\t\treturn $.data(this, 'droppable').options.scope === scope;\n\t\t\t\t});\n\n\t\t\t\tif (parent.length) {\n\t\t\t\t\tparentInstance = $.data(parent[0], 'droppable');\n\t\t\t\t\tparentInstance.greedyChild = (c == 'isover' ? 1 : 0);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// we just moved into a greedy child\n\t\t\tif (parentInstance && c == 'isover') {\n\t\t\t\tparentInstance['isover'] = 0;\n\t\t\t\tparentInstance['isout'] = 1;\n\t\t\t\tparentInstance._out.call(parentInstance, event);\n\t\t\t}\n\n\t\t\tthis[c] = 1; this[c == 'isout' ? 'isover' : 'isout'] = 0;\n\t\t\tthis[c == \"isover\" ? \"_over\" : \"_out\"].call(this, event);\n\n\t\t\t// we just moved out of a greedy child\n\t\t\tif (parentInstance && c == 'isout') {\n\t\t\t\tparentInstance['isout'] = 0;\n\t\t\t\tparentInstance['isover'] = 1;\n\t\t\t\tparentInstance._over.call(parentInstance, event);\n\t\t\t}\n\t\t});\n\n\t},\n\tdragStop: function( draggable, event ) {\n\t\tdraggable.element.parentsUntil( \"body\" ).unbind( \"scroll.droppable\" );\n\t\t//Call prepareOffsets one final time since IE does not fire return scroll events when overflow was caused by drag (see #5003)\n\t\tif( !draggable.options.refreshPositions ) $.ui.ddmanager.prepareOffsets( draggable, event );\n\t}\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.widget(\"ui.resizable\", $.ui.mouse, {\n\tversion: \"1.9.2\",\n\twidgetEventPrefix: \"resize\",\n\toptions: {\n\t\talsoResize: false,\n\t\tanimate: false,\n\t\tanimateDuration: \"slow\",\n\t\tanimateEasing: \"swing\",\n\t\taspectRatio: false,\n\t\tautoHide: false,\n\t\tcontainment: false,\n\t\tghost: false,\n\t\tgrid: false,\n\t\thandles: \"e,s,se\",\n\t\thelper: false,\n        iframeFix: false,\n\t\tmaxHeight: null,\n\t\tmaxWidth: null,\n\t\tminHeight: 10,\n\t\tminWidth: 10,\n\t\tzIndex: 1000\n\t},\n\t_create: function() {\n\n\t\tvar that = this, o = this.options;\n\t\tthis.element.addClass(\"ui-resizable\");\n\n\t\t$.extend(this, {\n\t\t\t_aspectRatio: !!(o.aspectRatio),\n\t\t\taspectRatio: o.aspectRatio,\n\t\t\toriginalElement: this.element,\n\t\t\t_proportionallyResizeElements: [],\n\t\t\t_helper: o.helper || o.ghost || o.animate ? o.helper || 'ui-resizable-helper' : null\n\t\t});\n\n\t\t//Wrap the element if it cannot hold child nodes\n\t\tif(this.element[0].nodeName.match(/canvas|textarea|input|select|button|img/i)) {\n\n\t\t\t//Create a wrapper element and set the wrapper to the new current internal element\n\t\t\tthis.element.wrap(\n\t\t\t\t$('<div class=\"ui-wrapper\" style=\"overflow: hidden;\"></div>').css({\n\t\t\t\t\tposition: this.element.css('position'),\n\t\t\t\t\twidth: this.element.outerWidth(),\n\t\t\t\t\theight: this.element.outerHeight(),\n\t\t\t\t\ttop: this.element.css('top'),\n\t\t\t\t\tleft: this.element.css('left')\n\t\t\t\t})\n\t\t\t);\n\n\t\t\t//Overwrite the original this.element\n\t\t\tthis.element = this.element.parent().data(\n\t\t\t\t\"resizable\", this.element.data('resizable')\n\t\t\t);\n\n\t\t\tthis.elementIsWrapper = true;\n\n\t\t\t//Move margins to the wrapper\n\t\t\tthis.element.css({ marginLeft: this.originalElement.css(\"marginLeft\"), marginTop: this.originalElement.css(\"marginTop\"), marginRight: this.originalElement.css(\"marginRight\"), marginBottom: this.originalElement.css(\"marginBottom\") });\n\t\t\tthis.originalElement.css({ marginLeft: 0, marginTop: 0, marginRight: 0, marginBottom: 0});\n\n\t\t\t//Prevent Safari textarea resize\n\t\t\tthis.originalResizeStyle = this.originalElement.css('resize');\n\t\t\tthis.originalElement.css('resize', 'none');\n\n\t\t\t//Push the actual element to our proportionallyResize internal array\n\t\t\tthis._proportionallyResizeElements.push(this.originalElement.css({ position: 'static', zoom: 1, display: 'block' }));\n\n\t\t\t// avoid IE jump (hard set the margin)\n\t\t\tthis.originalElement.css({ margin: this.originalElement.css('margin') });\n\n\t\t\t// fix handlers offset\n\t\t\tthis._proportionallyResize();\n\n\t\t}\n\n\t\tthis.handles = o.handles || (!$('.ui-resizable-handle', this.element).length ? \"e,s,se\" : { n: '.ui-resizable-n', e: '.ui-resizable-e', s: '.ui-resizable-s', w: '.ui-resizable-w', se: '.ui-resizable-se', sw: '.ui-resizable-sw', ne: '.ui-resizable-ne', nw: '.ui-resizable-nw' });\n\t\tif(this.handles.constructor == String) {\n\n\t\t\tif(this.handles == 'all') this.handles = 'n,e,s,w,se,sw,ne,nw';\n\t\t\tvar n = this.handles.split(\",\"); this.handles = {};\n\n\t\t\tfor(var i = 0; i < n.length; i++) {\n\n\t\t\t\tvar handle = $.trim(n[i]), hname = 'ui-resizable-'+handle;\n\t\t\t\tvar axis = $('<div class=\"ui-resizable-handle ' + hname + '\"></div>');\n\n\t\t\t\t// Apply zIndex to all handles - see #7960\n\t\t\t\taxis.css({ zIndex: o.zIndex });\n\n\t\t\t\t//TODO : What's going on here?\n\t\t\t\tif ('se' == handle) {\n\t\t\t\t\taxis.addClass('ui-icon ui-icon-gripsmall-diagonal-se');\n\t\t\t\t};\n\n\t\t\t\t//Insert into internal handles object and append to element\n\t\t\t\tthis.handles[handle] = '.ui-resizable-'+handle;\n\t\t\t\tthis.element.append(axis);\n\t\t\t}\n\n\t\t}\n\n\t\tthis._renderAxis = function(target) {\n\n\t\t\ttarget = target || this.element;\n\n\t\t\tfor(var i in this.handles) {\n\n\t\t\t\tif(this.handles[i].constructor == String)\n\t\t\t\t\tthis.handles[i] = $(this.handles[i], this.element).show();\n\n\t\t\t\t//Apply pad to wrapper element, needed to fix axis position (textarea, inputs, scrolls)\n\t\t\t\tif (this.elementIsWrapper && this.originalElement[0].nodeName.match(/textarea|input|select|button/i)) {\n\n\t\t\t\t\tvar axis = $(this.handles[i], this.element), padWrapper = 0;\n\n\t\t\t\t\t//Checking the correct pad and border\n\t\t\t\t\tpadWrapper = /sw|ne|nw|se|n|s/.test(i) ? axis.outerHeight() : axis.outerWidth();\n\n\t\t\t\t\t//The padding type i have to apply...\n\t\t\t\t\tvar padPos = [ 'padding',\n\t\t\t\t\t\t/ne|nw|n/.test(i) ? 'Top' :\n\t\t\t\t\t\t/se|sw|s/.test(i) ? 'Bottom' :\n\t\t\t\t\t\t/^e$/.test(i) ? 'Right' : 'Left' ].join(\"\");\n\n\t\t\t\t\ttarget.css(padPos, padWrapper);\n\n\t\t\t\t\tthis._proportionallyResize();\n\n\t\t\t\t}\n\n\t\t\t\t//TODO: What's that good for? There's not anything to be executed left\n\t\t\t\tif(!$(this.handles[i]).length)\n\t\t\t\t\tcontinue;\n\n\t\t\t}\n\t\t};\n\n\t\t//TODO: make renderAxis a prototype function\n\t\tthis._renderAxis(this.element);\n\n\t\tthis._handles = $('.ui-resizable-handle', this.element)\n\t\t\t.disableSelection();\n\n\t\t//Matching axis name\n\t\tthis._handles.mouseover(function() {\n\t\t\tif (!that.resizing) {\n\t\t\t\tif (this.className)\n\t\t\t\t\tvar axis = this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i);\n\t\t\t\t//Axis, default = se\n\t\t\t\tthat.axis = axis && axis[1] ? axis[1] : 'se';\n\t\t\t}\n\t\t});\n\n\t\t//If we want to auto hide the elements\n\t\tif (o.autoHide) {\n\t\t\tthis._handles.hide();\n\t\t\t$(this.element)\n\t\t\t\t.addClass(\"ui-resizable-autohide\")\n\t\t\t\t.mouseenter(function() {\n\t\t\t\t\tif (o.disabled) return;\n\t\t\t\t\t$(this).removeClass(\"ui-resizable-autohide\");\n\t\t\t\t\tthat._handles.show();\n\t\t\t\t})\n\t\t\t\t.mouseleave(function(){\n\t\t\t\t\tif (o.disabled) return;\n\t\t\t\t\tif (!that.resizing) {\n\t\t\t\t\t\t$(this).addClass(\"ui-resizable-autohide\");\n\t\t\t\t\t\tthat._handles.hide();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t}\n\n\t\t//Initialize the mouse interaction\n\t\tthis._mouseInit();\n\n\t},\n\n\t_destroy: function() {\n\n\t\tthis._mouseDestroy();\n\n\t\tvar _destroy = function(exp) {\n\t\t\t$(exp).removeClass(\"ui-resizable ui-resizable-disabled ui-resizable-resizing\")\n\t\t\t\t.removeData(\"resizable\").removeData(\"ui-resizable\").unbind(\".resizable\").find('.ui-resizable-handle').remove();\n\t\t};\n\n\t\t//TODO: Unwrap at same DOM position\n\t\tif (this.elementIsWrapper) {\n\t\t\t_destroy(this.element);\n\t\t\tvar wrapper = this.element;\n\t\t\tthis.originalElement.css({\n\t\t\t\tposition: wrapper.css('position'),\n\t\t\t\twidth: wrapper.outerWidth(),\n\t\t\t\theight: wrapper.outerHeight(),\n\t\t\t\ttop: wrapper.css('top'),\n\t\t\t\tleft: wrapper.css('left')\n\t\t\t}).insertAfter( wrapper );\n\t\t\twrapper.remove();\n\t\t}\n\n\t\tthis.originalElement.css('resize', this.originalResizeStyle);\n\t\t_destroy(this.originalElement);\n\n\t\treturn this;\n\t},\n\n\t_mouseCapture: function(event) {\n\t\tvar handle = false;\n\t\tfor (var i in this.handles) {\n\t\t\tif ($(this.handles[i])[0] == event.target) {\n\t\t\t\thandle = true;\n\t\t\t}\n\t\t}\n\n\t\treturn !this.options.disabled && handle;\n\t},\n\n\t_mouseStart: function(event) {\n\n\t\tvar o = this.options, iniPos = this.element.position(), el = this.element;\n\n\t\tthis.resizing = true;\n\t\tthis.documentScroll = { top: $(document).scrollTop(), left: $(document).scrollLeft() };\n\n\t\t// bugfix for http://dev.jquery.com/ticket/1749\n\t\tif (el.is('.ui-draggable') || (/absolute/).test(el.css('position'))) {\n\t\t\tel.css({ position: 'absolute', top: iniPos.top, left: iniPos.left });\n\t\t}\n\n\t\tthis._renderProxy();\n\n\t\tvar curleft = num(this.helper.css('left')), curtop = num(this.helper.css('top'));\n\n\t\tif (o.containment) {\n\t\t\tcurleft += $(o.containment).scrollLeft() || 0;\n\t\t\tcurtop += $(o.containment).scrollTop() || 0;\n\t\t}\n\n\t\t//Store needed variables\n\t\tthis.offset = this.helper.offset();\n\t\tthis.position = { left: curleft, top: curtop };\n\t\tthis.size = this._helper ? { width: el.outerWidth(), height: el.outerHeight() } : { width: el.width(), height: el.height() };\n\t\tthis.originalSize = this._helper ? { width: el.outerWidth(), height: el.outerHeight() } : { width: el.width(), height: el.height() };\n\t\tthis.originalPosition = { left: curleft, top: curtop };\n\t\tthis.sizeDiff = { width: el.outerWidth() - el.width(), height: el.outerHeight() - el.height() };\n\t\tthis.originalMousePosition = { left: event.pageX, top: event.pageY };\n\n\t\t//Aspect Ratio\n\t\tthis.aspectRatio = (typeof o.aspectRatio == 'number') ? o.aspectRatio : ((this.originalSize.width / this.originalSize.height) || 1);\n\n\t\tvar cursor = $('.ui-resizable-' + this.axis).css('cursor');\n\t\t$('body').css('cursor', cursor == 'auto' ? this.axis + '-resize' : cursor);\n\n\t\tel.addClass(\"ui-resizable-resizing\");\n\t\tthis._propagate(\"start\", event);\n\t\treturn true;\n\t},\n\n\t_mouseDrag: function(event) {\n\n\t\t//Increase performance, avoid regex\n\t\tvar el = this.helper, o = this.options, props = {},\n\t\t\tthat = this, smp = this.originalMousePosition, a = this.axis;\n\n\t\tvar dx = (event.pageX-smp.left)||0, dy = (event.pageY-smp.top)||0;\n\t\tvar trigger = this._change[a];\n\t\tif (!trigger) return false;\n\n\t\t// Calculate the attrs that will be change\n\t\tvar data = trigger.apply(this, [event, dx, dy]);\n\n\t\t// Put this in the mouseDrag handler since the user can start pressing shift while resizing\n\t\tthis._updateVirtualBoundaries(event.shiftKey);\n\t\tif (this._aspectRatio || event.shiftKey)\n\t\t\tdata = this._updateRatio(data, event);\n\n\t\tdata = this._respectSize(data, event);\n\n\t\t// plugins callbacks need to be called first\n\t\tthis._propagate(\"resize\", event);\n\n\t\tel.css({\n\t\t\ttop: this.position.top + \"px\", left: this.position.left + \"px\",\n\t\t\twidth: this.size.width + \"px\", height: this.size.height + \"px\"\n\t\t});\n\n\t\tif (!this._helper && this._proportionallyResizeElements.length)\n\t\t\tthis._proportionallyResize();\n\n\t\tthis._updateCache(data);\n\n\t\t// calling the user callback at the end\n\t\tthis._trigger('resize', event, this.ui());\n\n\t\treturn false;\n\t},\n\n\t_mouseStop: function(event) {\n\n\t\tthis.resizing = false;\n\t\tvar o = this.options, that = this;\n\n\t\tif(this._helper) {\n\t\t\tvar pr = this._proportionallyResizeElements, ista = pr.length && (/textarea/i).test(pr[0].nodeName),\n\t\t\t\tsoffseth = ista && $.ui.hasScroll(pr[0], 'left') /* TODO - jump height */ ? 0 : that.sizeDiff.height,\n\t\t\t\tsoffsetw = ista ? 0 : that.sizeDiff.width;\n\n\t\t\tvar s = { width: (that.helper.width()  - soffsetw), height: (that.helper.height() - soffseth) },\n\t\t\t\tleft = (parseInt(that.element.css('left'), 10) + (that.position.left - that.originalPosition.left)) || null,\n\t\t\t\ttop = (parseInt(that.element.css('top'), 10) + (that.position.top - that.originalPosition.top)) || null;\n\n\t\t\tif (!o.animate)\n\t\t\t\tthis.element.css($.extend(s, { top: top, left: left }));\n\n\t\t\tthat.helper.height(that.size.height);\n\t\t\tthat.helper.width(that.size.width);\n\n\t\t\tif (this._helper && !o.animate) this._proportionallyResize();\n\t\t}\n\n\t\t$('body').css('cursor', 'auto');\n\n\t\tthis.element.removeClass(\"ui-resizable-resizing\");\n\n\t\tthis._propagate(\"stop\", event);\n\n\t\tif (this._helper) this.helper.remove();\n\t\treturn false;\n\n\t},\n\n\t_updateVirtualBoundaries: function(forceAspectRatio) {\n\t\tvar o = this.options, pMinWidth, pMaxWidth, pMinHeight, pMaxHeight, b;\n\n\t\tb = {\n\t\t\tminWidth: isNumber(o.minWidth) ? o.minWidth : 0,\n\t\t\tmaxWidth: isNumber(o.maxWidth) ? o.maxWidth : Infinity,\n\t\t\tminHeight: isNumber(o.minHeight) ? o.minHeight : 0,\n\t\t\tmaxHeight: isNumber(o.maxHeight) ? o.maxHeight : Infinity\n\t\t};\n\n\t\tif(this._aspectRatio || forceAspectRatio) {\n\t\t\t// We want to create an enclosing box whose aspect ration is the requested one\n\t\t\t// First, compute the \"projected\" size for each dimension based on the aspect ratio and other dimension\n\t\t\tpMinWidth = b.minHeight * this.aspectRatio;\n\t\t\tpMinHeight = b.minWidth / this.aspectRatio;\n\t\t\tpMaxWidth = b.maxHeight * this.aspectRatio;\n\t\t\tpMaxHeight = b.maxWidth / this.aspectRatio;\n\n\t\t\tif(pMinWidth > b.minWidth) b.minWidth = pMinWidth;\n\t\t\tif(pMinHeight > b.minHeight) b.minHeight = pMinHeight;\n\t\t\tif(pMaxWidth < b.maxWidth) b.maxWidth = pMaxWidth;\n\t\t\tif(pMaxHeight < b.maxHeight) b.maxHeight = pMaxHeight;\n\t\t}\n\t\tthis._vBoundaries = b;\n\t},\n\n\t_updateCache: function(data) {\n\t\tvar o = this.options;\n\t\tthis.offset = this.helper.offset();\n\t\tif (isNumber(data.left)) this.position.left = data.left;\n\t\tif (isNumber(data.top)) this.position.top = data.top;\n\t\tif (isNumber(data.height)) this.size.height = data.height;\n\t\tif (isNumber(data.width)) this.size.width = data.width;\n\t},\n\n\t_updateRatio: function(data, event) {\n\n\t\tvar o = this.options, cpos = this.position, csize = this.size, a = this.axis;\n\n\t\tif (isNumber(data.height)) data.width = (data.height * this.aspectRatio);\n\t\telse if (isNumber(data.width)) data.height = (data.width / this.aspectRatio);\n\n\t\tif (a == 'sw') {\n\t\t\tdata.left = cpos.left + (csize.width - data.width);\n\t\t\tdata.top = null;\n\t\t}\n\t\tif (a == 'nw') {\n\t\t\tdata.top = cpos.top + (csize.height - data.height);\n\t\t\tdata.left = cpos.left + (csize.width - data.width);\n\t\t}\n\n\t\treturn data;\n\t},\n\n\t_respectSize: function(data, event) {\n\n\t\tvar el = this.helper, o = this._vBoundaries, pRatio = this._aspectRatio || event.shiftKey, a = this.axis,\n\t\t\t\tismaxw = isNumber(data.width) && o.maxWidth && (o.maxWidth < data.width), ismaxh = isNumber(data.height) && o.maxHeight && (o.maxHeight < data.height),\n\t\t\t\t\tisminw = isNumber(data.width) && o.minWidth && (o.minWidth > data.width), isminh = isNumber(data.height) && o.minHeight && (o.minHeight > data.height);\n\n\t\tif (isminw) data.width = o.minWidth;\n\t\tif (isminh) data.height = o.minHeight;\n\t\tif (ismaxw) data.width = o.maxWidth;\n\t\tif (ismaxh) data.height = o.maxHeight;\n\n\t\tvar dw = this.originalPosition.left + this.originalSize.width, dh = this.position.top + this.size.height;\n\t\tvar cw = /sw|nw|w/.test(a), ch = /nw|ne|n/.test(a);\n\n\t\tif (isminw && cw) data.left = dw - o.minWidth;\n\t\tif (ismaxw && cw) data.left = dw - o.maxWidth;\n\t\tif (isminh && ch)\tdata.top = dh - o.minHeight;\n\t\tif (ismaxh && ch)\tdata.top = dh - o.maxHeight;\n\n\t\t// fixing jump error on top/left - bug #2330\n\t\tvar isNotwh = !data.width && !data.height;\n\t\tif (isNotwh && !data.left && data.top) data.top = null;\n\t\telse if (isNotwh && !data.top && data.left) data.left = null;\n\n\t\treturn data;\n\t},\n\n\t_proportionallyResize: function() {\n\n\t\tvar o = this.options;\n\t\tif (!this._proportionallyResizeElements.length) return;\n\t\tvar element = this.helper || this.element;\n\n\t\tfor (var i=0; i < this._proportionallyResizeElements.length; i++) {\n\n\t\t\tvar prel = this._proportionallyResizeElements[i];\n\n\t\t\tif (!this.borderDif) {\n\t\t\t\tvar b = [prel.css('borderTopWidth'), prel.css('borderRightWidth'), prel.css('borderBottomWidth'), prel.css('borderLeftWidth')],\n\t\t\t\t\tp = [prel.css('paddingTop'), prel.css('paddingRight'), prel.css('paddingBottom'), prel.css('paddingLeft')];\n\n\t\t\t\tthis.borderDif = $.map(b, function(v, i) {\n\t\t\t\t\tvar border = parseInt(v,10)||0, padding = parseInt(p[i],10)||0;\n\t\t\t\t\treturn border + padding;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tprel.css({\n\t\t\t\theight: (element.height() - this.borderDif[0] - this.borderDif[2]) || 0,\n\t\t\t\twidth: (element.width() - this.borderDif[1] - this.borderDif[3]) || 0\n\t\t\t});\n\n\t\t};\n\n\t},\n\n\t_renderProxy: function() {\n\n\t\tvar el = this.element, o = this.options;\n\t\tthis.elementOffset = el.offset();\n\n\t\tif(this._helper) {\n\n\t\t\tthis.helper = this.helper || $('<div style=\"overflow:hidden;\"></div>');\n\n\t\t\t// fix ie6 offset TODO: This seems broken\n\t\t\tvar ie6offset = ($.ui.ie6 ? 1 : 0),\n\t\t\tpxyoffset = ( $.ui.ie6 ? 2 : -1 );\n\n\t\t\tthis.helper.addClass(this._helper).css({\n\t\t\t\twidth: this.element.outerWidth() + pxyoffset,\n\t\t\t\theight: this.element.outerHeight() + pxyoffset,\n\t\t\t\tposition: 'absolute',\n\t\t\t\tleft: this.elementOffset.left - ie6offset +'px',\n\t\t\t\ttop: this.elementOffset.top - ie6offset +'px',\n\t\t\t\tzIndex: ++o.zIndex //TODO: Don't modify option\n\t\t\t});\n\n\t\t\tthis.helper\n\t\t\t\t.appendTo(\"body\")\n\t\t\t\t.disableSelection();\n\n\t\t} else {\n\t\t\tthis.helper = this.element;\n\t\t}\n\n\t},\n\n\t_change: {\n\t\te: function(event, dx, dy) {\n\t\t\treturn { width: this.originalSize.width + dx };\n\t\t},\n\t\tw: function(event, dx, dy) {\n\t\t\tvar o = this.options, cs = this.originalSize, sp = this.originalPosition;\n\t\t\treturn { left: sp.left + dx, width: cs.width - dx };\n\t\t},\n\t\tn: function(event, dx, dy) {\n\t\t\tvar o = this.options, cs = this.originalSize, sp = this.originalPosition;\n\t\t\treturn { top: sp.top + dy, height: cs.height - dy };\n\t\t},\n\t\ts: function(event, dx, dy) {\n\t\t\treturn { height: this.originalSize.height + dy };\n\t\t},\n\t\tse: function(event, dx, dy) {\n\t\t\treturn $.extend(this._change.s.apply(this, arguments), this._change.e.apply(this, [event, dx, dy]));\n\t\t},\n\t\tsw: function(event, dx, dy) {\n\t\t\treturn $.extend(this._change.s.apply(this, arguments), this._change.w.apply(this, [event, dx, dy]));\n\t\t},\n\t\tne: function(event, dx, dy) {\n\t\t\treturn $.extend(this._change.n.apply(this, arguments), this._change.e.apply(this, [event, dx, dy]));\n\t\t},\n\t\tnw: function(event, dx, dy) {\n\t\t\treturn $.extend(this._change.n.apply(this, arguments), this._change.w.apply(this, [event, dx, dy]));\n\t\t}\n\t},\n\n\t_propagate: function(n, event) {\n\t\t$.ui.plugin.call(this, n, [event, this.ui()]);\n\t\t(n != \"resize\" && this._trigger(n, event, this.ui()));\n\t},\n\n\tplugins: {},\n\n\tui: function() {\n\t\treturn {\n\t\t\toriginalElement: this.originalElement,\n\t\t\telement: this.element,\n\t\t\thelper: this.helper,\n\t\t\tposition: this.position,\n\t\t\tsize: this.size,\n\t\t\toriginalSize: this.originalSize,\n\t\t\toriginalPosition: this.originalPosition\n\t\t};\n\t}\n\n});\n\n/*\n * Resizable Extensions\n */\n\n$.ui.plugin.add(\"resizable\", \"alsoResize\", {\n\n\tstart: function (event, ui) {\n\t\tvar that = $(this).data(\"resizable\"), o = that.options;\n\n\t\tvar _store = function (exp) {\n\t\t\t$(exp).each(function() {\n\t\t\t\tvar el = $(this);\n\t\t\t\tel.data(\"resizable-alsoresize\", {\n\t\t\t\t\twidth: parseInt(el.width(), 10), height: parseInt(el.height(), 10),\n\t\t\t\t\tleft: parseInt(el.css('left'), 10), top: parseInt(el.css('top'), 10)\n\t\t\t\t});\n\t\t\t});\n\t\t};\n\n\t\tif (typeof(o.alsoResize) == 'object' && !o.alsoResize.parentNode) {\n\t\t\tif (o.alsoResize.length) { o.alsoResize = o.alsoResize[0]; _store(o.alsoResize); }\n\t\t\telse { $.each(o.alsoResize, function (exp) { _store(exp); }); }\n\t\t}else{\n\t\t\t_store(o.alsoResize);\n\t\t}\n\t},\n\n\tresize: function (event, ui) {\n\t\tvar that = $(this).data(\"resizable\"), o = that.options, os = that.originalSize, op = that.originalPosition;\n\n\t\tvar delta = {\n\t\t\theight: (that.size.height - os.height) || 0, width: (that.size.width - os.width) || 0,\n\t\t\ttop: (that.position.top - op.top) || 0, left: (that.position.left - op.left) || 0\n\t\t},\n\n\t\t_alsoResize = function (exp, c) {\n\t\t\t$(exp).each(function() {\n\t\t\t\tvar el = $(this), start = $(this).data(\"resizable-alsoresize\"), style = {},\n\t\t\t\t\tcss = c && c.length ? c : el.parents(ui.originalElement[0]).length ? ['width', 'height'] : ['width', 'height', 'top', 'left'];\n\n\t\t\t\t$.each(css, function (i, prop) {\n\t\t\t\t\tvar sum = (start[prop]||0) + (delta[prop]||0);\n\t\t\t\t\tif (sum && sum >= 0)\n\t\t\t\t\t\tstyle[prop] = sum || null;\n\t\t\t\t});\n\n\t\t\t\tel.css(style);\n\t\t\t});\n\t\t};\n\n\t\tif (typeof(o.alsoResize) == 'object' && !o.alsoResize.nodeType) {\n\t\t\t$.each(o.alsoResize, function (exp, c) { _alsoResize(exp, c); });\n\t\t}else{\n\t\t\t_alsoResize(o.alsoResize);\n\t\t}\n\t},\n\n\tstop: function (event, ui) {\n\t\t$(this).removeData(\"resizable-alsoresize\");\n\t}\n});\n\n$.ui.plugin.add(\"resizable\", \"animate\", {\n\n\tstop: function(event, ui) {\n\t\tvar that = $(this).data(\"resizable\"), o = that.options;\n\n\t\tvar pr = that._proportionallyResizeElements, ista = pr.length && (/textarea/i).test(pr[0].nodeName),\n\t\t\t\t\tsoffseth = ista && $.ui.hasScroll(pr[0], 'left') /* TODO - jump height */ ? 0 : that.sizeDiff.height,\n\t\t\t\t\t\tsoffsetw = ista ? 0 : that.sizeDiff.width;\n\n\t\tvar style = { width: (that.size.width - soffsetw), height: (that.size.height - soffseth) },\n\t\t\t\t\tleft = (parseInt(that.element.css('left'), 10) + (that.position.left - that.originalPosition.left)) || null,\n\t\t\t\t\t\ttop = (parseInt(that.element.css('top'), 10) + (that.position.top - that.originalPosition.top)) || null;\n\n\t\tthat.element.animate(\n\t\t\t$.extend(style, top && left ? { top: top, left: left } : {}), {\n\t\t\t\tduration: o.animateDuration,\n\t\t\t\teasing: o.animateEasing,\n\t\t\t\tstep: function() {\n\n\t\t\t\t\tvar data = {\n\t\t\t\t\t\twidth: parseInt(that.element.css('width'), 10),\n\t\t\t\t\t\theight: parseInt(that.element.css('height'), 10),\n\t\t\t\t\t\ttop: parseInt(that.element.css('top'), 10),\n\t\t\t\t\t\tleft: parseInt(that.element.css('left'), 10)\n\t\t\t\t\t};\n\n\t\t\t\t\tif (pr && pr.length) $(pr[0]).css({ width: data.width, height: data.height });\n\n\t\t\t\t\t// propagating resize, and updating values for each animation step\n\t\t\t\t\tthat._updateCache(data);\n\t\t\t\t\tthat._propagate(\"resize\", event);\n\n\t\t\t\t}\n\t\t\t}\n\t\t);\n\t}\n\n});\n\n$.ui.plugin.add(\"resizable\", \"containment\", {\n\n\tstart: function(event, ui) {\n\t\tvar that = $(this).data(\"resizable\"), o = that.options, el = that.element;\n\t\tvar oc = o.containment,\tce = (oc instanceof $) ? oc.get(0) : (/parent/.test(oc)) ? el.parent().get(0) : oc;\n\t\tif (!ce) return;\n\n\t\tthat.containerElement = $(ce);\n\n\t\tif (/document/.test(oc) || oc == document) {\n\t\t\tthat.containerOffset = { left: 0, top: 0 };\n\t\t\tthat.containerPosition = { left: 0, top: 0 };\n\n\t\t\tthat.parentData = {\n\t\t\t\telement: $(document), left: 0, top: 0,\n\t\t\t\twidth: $(document).width(), height: $(document).height() || document.body.parentNode.scrollHeight\n\t\t\t};\n\t\t}\n\n\t\t// i'm a node, so compute top, left, right, bottom\n\t\telse {\n\t\t\tvar element = $(ce), p = [];\n\t\t\t$([ \"Top\", \"Right\", \"Left\", \"Bottom\" ]).each(function(i, name) { p[i] = num(element.css(\"padding\" + name)); });\n\n\t\t\tthat.containerOffset = element.offset();\n\t\t\tthat.containerPosition = element.position();\n\t\t\tthat.containerSize = { height: (element.innerHeight() - p[3]), width: (element.innerWidth() - p[1]) };\n\n\t\t\tvar co = that.containerOffset, ch = that.containerSize.height,\tcw = that.containerSize.width,\n\t\t\t\t\t\twidth = ($.ui.hasScroll(ce, \"left\") ? ce.scrollWidth : cw ), height = ($.ui.hasScroll(ce) ? ce.scrollHeight : ch);\n\n\t\t\tthat.parentData = {\n\t\t\t\telement: ce, left: co.left, top: co.top, width: width, height: height\n\t\t\t};\n\t\t}\n\t},\n\n\tresize: function(event, ui) {\n\t\tvar that = $(this).data(\"resizable\"), o = that.options,\n\t\t\t\tps = that.containerSize, co = that.containerOffset, cs = that.size, cp = that.position,\n\t\t\t\tpRatio = that._aspectRatio || event.shiftKey, cop = { top:0, left:0 }, ce = that.containerElement;\n\n\t\tif (ce[0] != document && (/static/).test(ce.css('position'))) cop = co;\n\n\t\tif (cp.left < (that._helper ? co.left : 0)) {\n\t\t\tthat.size.width = that.size.width + (that._helper ? (that.position.left - co.left) : (that.position.left - cop.left));\n\t\t\tif (pRatio) that.size.height = that.size.width / that.aspectRatio;\n\t\t\tthat.position.left = o.helper ? co.left : 0;\n\t\t}\n\n\t\tif (cp.top < (that._helper ? co.top : 0)) {\n\t\t\tthat.size.height = that.size.height + (that._helper ? (that.position.top - co.top) : that.position.top);\n\t\t\tif (pRatio) that.size.width = that.size.height * that.aspectRatio;\n\t\t\tthat.position.top = that._helper ? co.top : 0;\n\t\t}\n\n\t\tthat.offset.left = that.parentData.left+that.position.left;\n\t\tthat.offset.top = that.parentData.top+that.position.top;\n\n\t\tvar woset = Math.abs( (that._helper ? that.offset.left - cop.left : (that.offset.left - cop.left)) + that.sizeDiff.width ),\n\t\t\t\t\thoset = Math.abs( (that._helper ? that.offset.top - cop.top : (that.offset.top - co.top)) + that.sizeDiff.height );\n\n\t\tvar isParent = that.containerElement.get(0) == that.element.parent().get(0),\n\t\t\tisOffsetRelative = /relative|absolute/.test(that.containerElement.css('position'));\n\n\t\tif(isParent && isOffsetRelative) woset -= that.parentData.left;\n\n\t\tif (woset + that.size.width >= that.parentData.width) {\n\t\t\tthat.size.width = that.parentData.width - woset;\n\t\t\tif (pRatio) that.size.height = that.size.width / that.aspectRatio;\n\t\t}\n\n\t\tif (hoset + that.size.height >= that.parentData.height) {\n\t\t\tthat.size.height = that.parentData.height - hoset;\n\t\t\tif (pRatio) that.size.width = that.size.height * that.aspectRatio;\n\t\t}\n\t},\n\n\tstop: function(event, ui){\n\t\tvar that = $(this).data(\"resizable\"), o = that.options, cp = that.position,\n\t\t\t\tco = that.containerOffset, cop = that.containerPosition, ce = that.containerElement;\n\n\t\tvar helper = $(that.helper), ho = helper.offset(), w = helper.outerWidth() - that.sizeDiff.width, h = helper.outerHeight() - that.sizeDiff.height;\n\n\t\tif (that._helper && !o.animate && (/relative/).test(ce.css('position')))\n\t\t\t$(this).css({ left: ho.left - cop.left - co.left, width: w, height: h });\n\n\t\tif (that._helper && !o.animate && (/static/).test(ce.css('position')))\n\t\t\t$(this).css({ left: ho.left - cop.left - co.left, width: w, height: h });\n\n\t}\n});\n\n$.ui.plugin.add(\"resizable\", \"ghost\", {\n\n\tstart: function(event, ui) {\n\n\t\tvar that = $(this).data(\"resizable\"), o = that.options, cs = that.size;\n\n\t\tthat.ghost = that.originalElement.clone();\n\t\tthat.ghost\n\t\t\t.css({ opacity: .25, display: 'block', position: 'relative', height: cs.height, width: cs.width, margin: 0, left: 0, top: 0 })\n\t\t\t.addClass('ui-resizable-ghost')\n\t\t\t.addClass(typeof o.ghost == 'string' ? o.ghost : '');\n\n\t\tthat.ghost.appendTo(that.helper);\n\n\t},\n\n\tresize: function(event, ui){\n\t\tvar that = $(this).data(\"resizable\"), o = that.options;\n\t\tif (that.ghost) that.ghost.css({ position: 'relative', height: that.size.height, width: that.size.width });\n\t},\n\n\tstop: function(event, ui){\n\t\tvar that = $(this).data(\"resizable\"), o = that.options;\n\t\tif (that.ghost && that.helper) that.helper.get(0).removeChild(that.ghost.get(0));\n\t}\n\n});\n\n$.ui.plugin.add(\"resizable\", \"grid\", {\n\n\tresize: function(event, ui) {\n\t\tvar that = $(this).data(\"resizable\"), o = that.options, cs = that.size, os = that.originalSize, op = that.originalPosition, a = that.axis, ratio = o._aspectRatio || event.shiftKey;\n\t\to.grid = typeof o.grid == \"number\" ? [o.grid, o.grid] : o.grid;\n\t\tvar ox = Math.round((cs.width - os.width) / (o.grid[0]||1)) * (o.grid[0]||1), oy = Math.round((cs.height - os.height) / (o.grid[1]||1)) * (o.grid[1]||1);\n\n\t\tif (/^(se|s|e)$/.test(a)) {\n\t\t\tthat.size.width = os.width + ox;\n\t\t\tthat.size.height = os.height + oy;\n\t\t}\n\t\telse if (/^(ne)$/.test(a)) {\n\t\t\tthat.size.width = os.width + ox;\n\t\t\tthat.size.height = os.height + oy;\n\t\t\tthat.position.top = op.top - oy;\n\t\t}\n\t\telse if (/^(sw)$/.test(a)) {\n\t\t\tthat.size.width = os.width + ox;\n\t\t\tthat.size.height = os.height + oy;\n\t\t\tthat.position.left = op.left - ox;\n\t\t}\n\t\telse {\n\t\t\tthat.size.width = os.width + ox;\n\t\t\tthat.size.height = os.height + oy;\n\t\t\tthat.position.top = op.top - oy;\n\t\t\tthat.position.left = op.left - ox;\n\t\t}\n\t}\n\n});\n\n$.ui.plugin.add(\"resizable\", \"iframeFix\", {\n    start: function (event, ui) {\n        var o = $(this).data('resizable').options;\n        $(o.iframeFix === true ? \"iframe\" : o.iframeFix).each(function () {\n            $('<div class=\"ui-resizable-iframeFix\" style=\"background: #fff;\"></div>')\n                .css({\n                    width: this.offsetWidth + \"px\", height: this.offsetHeight + \"px\",\n                    position: \"absolute\", opacity: \"0.001\", zIndex: 1000\n                })\n                .css($(this).offset())\n                .appendTo(\"body\");\n        });\n    },\n    stop: function (event, ui) {\n        $(\"div.ui-resizable-iframeFix\").each(function () {\n            this.parentNode.removeChild(this);\n        });\n    }\n});\n\nvar num = function(v) {\n\treturn parseInt(v, 10) || 0;\n};\n\nvar isNumber = function(value) {\n\treturn !isNaN(parseInt(value, 10));\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.widget(\"ui.selectable\", $.ui.mouse, {\n\tversion: \"1.9.2\",\n\toptions: {\n\t\tappendTo: 'body',\n\t\tautoRefresh: true,\n\t\tdistance: 0,\n\t\tfilter: '*',\n\t\ttolerance: 'touch'\n\t},\n\t_create: function() {\n\t\tvar that = this;\n\n\t\tthis.element.addClass(\"ui-selectable\");\n\n\t\tthis.dragged = false;\n\n\t\t// cache selectee children based on filter\n\t\tvar selectees;\n\t\tthis.refresh = function() {\n\t\t\tselectees = $(that.options.filter, that.element[0]);\n\t\t\tselectees.addClass(\"ui-selectee\");\n\t\t\tselectees.each(function() {\n\t\t\t\tvar $this = $(this);\n\t\t\t\tvar pos = $this.offset();\n\t\t\t\t$.data(this, \"selectable-item\", {\n\t\t\t\t\telement: this,\n\t\t\t\t\t$element: $this,\n\t\t\t\t\tleft: pos.left,\n\t\t\t\t\ttop: pos.top,\n\t\t\t\t\tright: pos.left + $this.outerWidth(),\n\t\t\t\t\tbottom: pos.top + $this.outerHeight(),\n\t\t\t\t\tstartselected: false,\n\t\t\t\t\tselected: $this.hasClass('ui-selected'),\n\t\t\t\t\tselecting: $this.hasClass('ui-selecting'),\n\t\t\t\t\tunselecting: $this.hasClass('ui-unselecting')\n\t\t\t\t});\n\t\t\t});\n\t\t};\n\t\tthis.refresh();\n\n\t\tthis.selectees = selectees.addClass(\"ui-selectee\");\n\n\t\tthis._mouseInit();\n\n\t\tthis.helper = $(\"<div class='ui-selectable-helper'></div>\");\n\t},\n\n\t_destroy: function() {\n\t\tthis.selectees\n\t\t\t.removeClass(\"ui-selectee\")\n\t\t\t.removeData(\"selectable-item\");\n\t\tthis.element\n\t\t\t.removeClass(\"ui-selectable ui-selectable-disabled\");\n\t\tthis._mouseDestroy();\n\t},\n\n\t_mouseStart: function(event) {\n\t\tvar that = this;\n\n\t\tthis.opos = [event.pageX, event.pageY];\n\n\t\tif (this.options.disabled)\n\t\t\treturn;\n\n\t\tvar options = this.options;\n\n\t\tthis.selectees = $(options.filter, this.element[0]);\n\n\t\tthis._trigger(\"start\", event);\n\n\t\t$(options.appendTo).append(this.helper);\n\t\t// position helper (lasso)\n\t\tthis.helper.css({\n\t\t\t\"left\": event.clientX,\n\t\t\t\"top\": event.clientY,\n\t\t\t\"width\": 0,\n\t\t\t\"height\": 0\n\t\t});\n\n\t\tif (options.autoRefresh) {\n\t\t\tthis.refresh();\n\t\t}\n\n\t\tthis.selectees.filter('.ui-selected').each(function() {\n\t\t\tvar selectee = $.data(this, \"selectable-item\");\n\t\t\tselectee.startselected = true;\n\t\t\tif (!event.metaKey && !event.ctrlKey) {\n\t\t\t\tselectee.$element.removeClass('ui-selected');\n\t\t\t\tselectee.selected = false;\n\t\t\t\tselectee.$element.addClass('ui-unselecting');\n\t\t\t\tselectee.unselecting = true;\n\t\t\t\t// selectable UNSELECTING callback\n\t\t\t\tthat._trigger(\"unselecting\", event, {\n\t\t\t\t\tunselecting: selectee.element\n\t\t\t\t});\n\t\t\t}\n\t\t});\n\n\t\t$(event.target).parents().andSelf().each(function() {\n\t\t\tvar selectee = $.data(this, \"selectable-item\");\n\t\t\tif (selectee) {\n\t\t\t\tvar doSelect = (!event.metaKey && !event.ctrlKey) || !selectee.$element.hasClass('ui-selected');\n\t\t\t\tselectee.$element\n\t\t\t\t\t.removeClass(doSelect ? \"ui-unselecting\" : \"ui-selected\")\n\t\t\t\t\t.addClass(doSelect ? \"ui-selecting\" : \"ui-unselecting\");\n\t\t\t\tselectee.unselecting = !doSelect;\n\t\t\t\tselectee.selecting = doSelect;\n\t\t\t\tselectee.selected = doSelect;\n\t\t\t\t// selectable (UN)SELECTING callback\n\t\t\t\tif (doSelect) {\n\t\t\t\t\tthat._trigger(\"selecting\", event, {\n\t\t\t\t\t\tselecting: selectee.element\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\tthat._trigger(\"unselecting\", event, {\n\t\t\t\t\t\tunselecting: selectee.element\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t}\n\t\t});\n\n\t},\n\n\t_mouseDrag: function(event) {\n\t\tvar that = this;\n\t\tthis.dragged = true;\n\n\t\tif (this.options.disabled)\n\t\t\treturn;\n\n\t\tvar options = this.options;\n\n\t\tvar x1 = this.opos[0], y1 = this.opos[1], x2 = event.pageX, y2 = event.pageY;\n\t\tif (x1 > x2) { var tmp = x2; x2 = x1; x1 = tmp; }\n\t\tif (y1 > y2) { var tmp = y2; y2 = y1; y1 = tmp; }\n\t\tthis.helper.css({left: x1, top: y1, width: x2-x1, height: y2-y1});\n\n\t\tthis.selectees.each(function() {\n\t\t\tvar selectee = $.data(this, \"selectable-item\");\n\t\t\t//prevent helper from being selected if appendTo: selectable\n\t\t\tif (!selectee || selectee.element == that.element[0])\n\t\t\t\treturn;\n\t\t\tvar hit = false;\n\t\t\tif (options.tolerance == 'touch') {\n\t\t\t\thit = ( !(selectee.left > x2 || selectee.right < x1 || selectee.top > y2 || selectee.bottom < y1) );\n\t\t\t} else if (options.tolerance == 'fit') {\n\t\t\t\thit = (selectee.left > x1 && selectee.right < x2 && selectee.top > y1 && selectee.bottom < y2);\n\t\t\t}\n\n\t\t\tif (hit) {\n\t\t\t\t// SELECT\n\t\t\t\tif (selectee.selected) {\n\t\t\t\t\tselectee.$element.removeClass('ui-selected');\n\t\t\t\t\tselectee.selected = false;\n\t\t\t\t}\n\t\t\t\tif (selectee.unselecting) {\n\t\t\t\t\tselectee.$element.removeClass('ui-unselecting');\n\t\t\t\t\tselectee.unselecting = false;\n\t\t\t\t}\n\t\t\t\tif (!selectee.selecting) {\n\t\t\t\t\tselectee.$element.addClass('ui-selecting');\n\t\t\t\t\tselectee.selecting = true;\n\t\t\t\t\t// selectable SELECTING callback\n\t\t\t\t\tthat._trigger(\"selecting\", event, {\n\t\t\t\t\t\tselecting: selectee.element\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// UNSELECT\n\t\t\t\tif (selectee.selecting) {\n\t\t\t\t\tif ((event.metaKey || event.ctrlKey) && selectee.startselected) {\n\t\t\t\t\t\tselectee.$element.removeClass('ui-selecting');\n\t\t\t\t\t\tselectee.selecting = false;\n\t\t\t\t\t\tselectee.$element.addClass('ui-selected');\n\t\t\t\t\t\tselectee.selected = true;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tselectee.$element.removeClass('ui-selecting');\n\t\t\t\t\t\tselectee.selecting = false;\n\t\t\t\t\t\tif (selectee.startselected) {\n\t\t\t\t\t\t\tselectee.$element.addClass('ui-unselecting');\n\t\t\t\t\t\t\tselectee.unselecting = true;\n\t\t\t\t\t\t}\n\t\t\t\t\t\t// selectable UNSELECTING callback\n\t\t\t\t\t\tthat._trigger(\"unselecting\", event, {\n\t\t\t\t\t\t\tunselecting: selectee.element\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif (selectee.selected) {\n\t\t\t\t\tif (!event.metaKey && !event.ctrlKey && !selectee.startselected) {\n\t\t\t\t\t\tselectee.$element.removeClass('ui-selected');\n\t\t\t\t\t\tselectee.selected = false;\n\n\t\t\t\t\t\tselectee.$element.addClass('ui-unselecting');\n\t\t\t\t\t\tselectee.unselecting = true;\n\t\t\t\t\t\t// selectable UNSELECTING callback\n\t\t\t\t\t\tthat._trigger(\"unselecting\", event, {\n\t\t\t\t\t\t\tunselecting: selectee.element\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\treturn false;\n\t},\n\n\t_mouseStop: function(event) {\n\t\tvar that = this;\n\n\t\tthis.dragged = false;\n\n\t\tvar options = this.options;\n\n\t\t$('.ui-unselecting', this.element[0]).each(function() {\n\t\t\tvar selectee = $.data(this, \"selectable-item\");\n\t\t\tselectee.$element.removeClass('ui-unselecting');\n\t\t\tselectee.unselecting = false;\n\t\t\tselectee.startselected = false;\n\t\t\tthat._trigger(\"unselected\", event, {\n\t\t\t\tunselected: selectee.element\n\t\t\t});\n\t\t});\n\t\t$('.ui-selecting', this.element[0]).each(function() {\n\t\t\tvar selectee = $.data(this, \"selectable-item\");\n\t\t\tselectee.$element.removeClass('ui-selecting').addClass('ui-selected');\n\t\t\tselectee.selecting = false;\n\t\t\tselectee.selected = true;\n\t\t\tselectee.startselected = true;\n\t\t\tthat._trigger(\"selected\", event, {\n\t\t\t\tselected: selectee.element\n\t\t\t});\n\t\t});\n\t\tthis._trigger(\"stop\", event);\n\n\t\tthis.helper.remove();\n\n\t\treturn false;\n\t}\n\n});\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.widget(\"ui.sortable\", $.ui.mouse, {\n\tversion: \"1.9.2\",\n\twidgetEventPrefix: \"sort\",\n\tready: false,\n\toptions: {\n\t\tappendTo: \"parent\",\n\t\taxis: false,\n\t\tconnectWith: false,\n\t\tcontainment: false,\n\t\tcursor: 'auto',\n\t\tcursorAt: false,\n\t\tdropOnEmpty: true,\n\t\tforcePlaceholderSize: false,\n\t\tforceHelperSize: false,\n\t\tgrid: false,\n\t\thandle: false,\n\t\thelper: \"original\",\n\t\titems: '> *',\n\t\topacity: false,\n\t\tplaceholder: false,\n\t\trevert: false,\n\t\tscroll: true,\n\t\tscrollSensitivity: 20,\n\t\tscrollSpeed: 20,\n\t\tscope: \"default\",\n\t\ttolerance: \"intersect\",\n\t\tzIndex: 1000\n\t},\n\t_create: function() {\n\n\t\tvar o = this.options;\n\t\tthis.containerCache = {};\n\t\tthis.element.addClass(\"ui-sortable\");\n\n\t\t//Get the items\n\t\tthis.refresh();\n\n\t\t//Let's determine if the items are being displayed horizontally\n\t\tthis.floating = this.items.length ? o.axis === 'x' || (/left|right/).test(this.items[0].item.css('float')) || (/inline|table-cell/).test(this.items[0].item.css('display')) : false;\n\n\t\t//Let's determine the parent's offset\n\t\tthis.offset = this.element.offset();\n\n\t\t//Initialize mouse events for interaction\n\t\tthis._mouseInit();\n\n\t\t//We're ready to go\n\t\tthis.ready = true\n\n\t},\n\n\t_destroy: function() {\n\t\tthis.element\n\t\t\t.removeClass(\"ui-sortable ui-sortable-disabled\");\n\t\tthis._mouseDestroy();\n\n\t\tfor ( var i = this.items.length - 1; i >= 0; i-- )\n\t\t\tthis.items[i].item.removeData(this.widgetName + \"-item\");\n\n\t\treturn this;\n\t},\n\n\t_setOption: function(key, value){\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis.options[ key ] = value;\n\n\t\t\tthis.widget().toggleClass( \"ui-sortable-disabled\", !!value );\n\t\t} else {\n\t\t\t// Don't call widget base _setOption for disable as it adds ui-state-disabled class\n\t\t\t$.Widget.prototype._setOption.apply(this, arguments);\n\t\t}\n\t},\n\n\t_mouseCapture: function(event, overrideHandle) {\n\t\tvar that = this;\n\n\t\tif (this.reverting) {\n\t\t\treturn false;\n\t\t}\n\n\t\tif(this.options.disabled || this.options.type == 'static') return false;\n\n\t\t//We have to refresh the items data once first\n\t\tthis._refreshItems(event);\n\n\t\t//Find out if the clicked node (or one of its parents) is a actual item in this.items\n\t\tvar currentItem = null, nodes = $(event.target).parents().each(function() {\n\t\t\tif($.data(this, that.widgetName + '-item') == that) {\n\t\t\t\tcurrentItem = $(this);\n\t\t\t\treturn false;\n\t\t\t}\n\t\t});\n\t\tif($.data(event.target, that.widgetName + '-item') == that) currentItem = $(event.target);\n\n\t\tif(!currentItem) return false;\n\t\tif(this.options.handle && !overrideHandle) {\n\t\t\tvar validHandle = false;\n\n\t\t\t$(this.options.handle, currentItem).find(\"*\").andSelf().each(function() { if(this == event.target) validHandle = true; });\n\t\t\tif(!validHandle) return false;\n\t\t}\n\n\t\tthis.currentItem = currentItem;\n\t\tthis._removeCurrentsFromItems();\n\t\treturn true;\n\n\t},\n\n\t_mouseStart: function(event, overrideHandle, noActivation) {\n\n\t\tvar o = this.options;\n\t\tthis.currentContainer = this;\n\n\t\t//We only need to call refreshPositions, because the refreshItems call has been moved to mouseCapture\n\t\tthis.refreshPositions();\n\n\t\t//Create and append the visible helper\n\t\tthis.helper = this._createHelper(event);\n\n\t\t//Cache the helper size\n\t\tthis._cacheHelperProportions();\n\n\t\t/*\n\t\t * - Position generation -\n\t\t * This block generates everything position related - it's the core of draggables.\n\t\t */\n\n\t\t//Cache the margins of the original element\n\t\tthis._cacheMargins();\n\n\t\t//Get the next scrolling parent\n\t\tthis.scrollParent = this.helper.scrollParent();\n\n\t\t//The element's absolute position on the page minus margins\n\t\tthis.offset = this.currentItem.offset();\n\t\tthis.offset = {\n\t\t\ttop: this.offset.top - this.margins.top,\n\t\t\tleft: this.offset.left - this.margins.left\n\t\t};\n\n\t\t$.extend(this.offset, {\n\t\t\tclick: { //Where the click happened, relative to the element\n\t\t\t\tleft: event.pageX - this.offset.left,\n\t\t\t\ttop: event.pageY - this.offset.top\n\t\t\t},\n\t\t\tparent: this._getParentOffset(),\n\t\t\trelative: this._getRelativeOffset() //This is a relative to absolute position minus the actual position calculation - only used for relative positioned helper\n\t\t});\n\n\t\t// Only after we got the offset, we can change the helper's position to absolute\n\t\t// TODO: Still need to figure out a way to make relative sorting possible\n\t\tthis.helper.css(\"position\", \"absolute\");\n\t\tthis.cssPosition = this.helper.css(\"position\");\n\n\t\t//Generate the original position\n\t\tthis.originalPosition = this._generatePosition(event);\n\t\tthis.originalPageX = event.pageX;\n\t\tthis.originalPageY = event.pageY;\n\n\t\t//Adjust the mouse offset relative to the helper if 'cursorAt' is supplied\n\t\t(o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt));\n\n\t\t//Cache the former DOM position\n\t\tthis.domPosition = { prev: this.currentItem.prev()[0], parent: this.currentItem.parent()[0] };\n\n\t\t//If the helper is not the original, hide the original so it's not playing any role during the drag, won't cause anything bad this way\n\t\tif(this.helper[0] != this.currentItem[0]) {\n\t\t\tthis.currentItem.hide();\n\t\t}\n\n\t\t//Create the placeholder\n\t\tthis._createPlaceholder();\n\n\t\t//Set a containment if given in the options\n\t\tif(o.containment)\n\t\t\tthis._setContainment();\n\n\t\tif(o.cursor) { // cursor option\n\t\t\tif ($('body').css(\"cursor\")) this._storedCursor = $('body').css(\"cursor\");\n\t\t\t$('body').css(\"cursor\", o.cursor);\n\t\t}\n\n\t\tif(o.opacity) { // opacity option\n\t\t\tif (this.helper.css(\"opacity\")) this._storedOpacity = this.helper.css(\"opacity\");\n\t\t\tthis.helper.css(\"opacity\", o.opacity);\n\t\t}\n\n\t\tif(o.zIndex) { // zIndex option\n\t\t\tif (this.helper.css(\"zIndex\")) this._storedZIndex = this.helper.css(\"zIndex\");\n\t\t\tthis.helper.css(\"zIndex\", o.zIndex);\n\t\t}\n\n\t\t//Prepare scrolling\n\t\tif(this.scrollParent[0] != document && this.scrollParent[0].tagName != 'HTML')\n\t\t\tthis.overflowOffset = this.scrollParent.offset();\n\n\t\t//Call callbacks\n\t\tthis._trigger(\"start\", event, this._uiHash());\n\n\t\t//Recache the helper size\n\t\tif(!this._preserveHelperProportions)\n\t\t\tthis._cacheHelperProportions();\n\n\n\t\t//Post 'activate' events to possible containers\n\t\tif(!noActivation) {\n\t\t\t for (var i = this.containers.length - 1; i >= 0; i--) { this.containers[i]._trigger(\"activate\", event, this._uiHash(this)); }\n\t\t}\n\n\t\t//Prepare possible droppables\n\t\tif($.ui.ddmanager)\n\t\t\t$.ui.ddmanager.current = this;\n\n\t\tif ($.ui.ddmanager && !o.dropBehaviour)\n\t\t\t$.ui.ddmanager.prepareOffsets(this, event);\n\n\t\tthis.dragging = true;\n\n\t\tthis.helper.addClass(\"ui-sortable-helper\");\n\t\tthis._mouseDrag(event); //Execute the drag once - this causes the helper not to be visible before getting its correct position\n\t\treturn true;\n\n\t},\n\n\t_mouseDrag: function(event) {\n\n\t\t//Compute the helpers position\n\t\tthis.position = this._generatePosition(event);\n\t\tthis.positionAbs = this._convertPositionTo(\"absolute\");\n\n\t\tif (!this.lastPositionAbs) {\n\t\t\tthis.lastPositionAbs = this.positionAbs;\n\t\t}\n\n\t\t//Do scrolling\n\t\tif(this.options.scroll) {\n\t\t\tvar o = this.options, scrolled = false;\n\t\t\tif(this.scrollParent[0] != document && this.scrollParent[0].tagName != 'HTML') {\n\n\t\t\t\tif((this.overflowOffset.top + this.scrollParent[0].offsetHeight) - event.pageY < o.scrollSensitivity)\n\t\t\t\t\tthis.scrollParent[0].scrollTop = scrolled = this.scrollParent[0].scrollTop + o.scrollSpeed;\n\t\t\t\telse if(event.pageY - this.overflowOffset.top < o.scrollSensitivity)\n\t\t\t\t\tthis.scrollParent[0].scrollTop = scrolled = this.scrollParent[0].scrollTop - o.scrollSpeed;\n\n\t\t\t\tif((this.overflowOffset.left + this.scrollParent[0].offsetWidth) - event.pageX < o.scrollSensitivity)\n\t\t\t\t\tthis.scrollParent[0].scrollLeft = scrolled = this.scrollParent[0].scrollLeft + o.scrollSpeed;\n\t\t\t\telse if(event.pageX - this.overflowOffset.left < o.scrollSensitivity)\n\t\t\t\t\tthis.scrollParent[0].scrollLeft = scrolled = this.scrollParent[0].scrollLeft - o.scrollSpeed;\n\n\t\t\t} else {\n\n\t\t\t\tif(event.pageY - $(document).scrollTop() < o.scrollSensitivity)\n\t\t\t\t\tscrolled = $(document).scrollTop($(document).scrollTop() - o.scrollSpeed);\n\t\t\t\telse if($(window).height() - (event.pageY - $(document).scrollTop()) < o.scrollSensitivity)\n\t\t\t\t\tscrolled = $(document).scrollTop($(document).scrollTop() + o.scrollSpeed);\n\n\t\t\t\tif(event.pageX - $(document).scrollLeft() < o.scrollSensitivity)\n\t\t\t\t\tscrolled = $(document).scrollLeft($(document).scrollLeft() - o.scrollSpeed);\n\t\t\t\telse if($(window).width() - (event.pageX - $(document).scrollLeft()) < o.scrollSensitivity)\n\t\t\t\t\tscrolled = $(document).scrollLeft($(document).scrollLeft() + o.scrollSpeed);\n\n\t\t\t}\n\n\t\t\tif(scrolled !== false && $.ui.ddmanager && !o.dropBehaviour)\n\t\t\t\t$.ui.ddmanager.prepareOffsets(this, event);\n\t\t}\n\n\t\t//Regenerate the absolute position used for position checks\n\t\tthis.positionAbs = this._convertPositionTo(\"absolute\");\n\n\t\t//Set the helper position\n\t\tif(!this.options.axis || this.options.axis != \"y\") this.helper[0].style.left = this.position.left+'px';\n\t\tif(!this.options.axis || this.options.axis != \"x\") this.helper[0].style.top = this.position.top+'px';\n\n\t\t//Rearrange\n\t\tfor (var i = this.items.length - 1; i >= 0; i--) {\n\n\t\t\t//Cache variables and intersection, continue if no intersection\n\t\t\tvar item = this.items[i], itemElement = item.item[0], intersection = this._intersectsWithPointer(item);\n\t\t\tif (!intersection) continue;\n\n\t\t\t// Only put the placeholder inside the current Container, skip all\n\t\t\t// items form other containers. This works because when moving\n\t\t\t// an item from one container to another the\n\t\t\t// currentContainer is switched before the placeholder is moved.\n\t\t\t//\n\t\t\t// Without this moving items in \"sub-sortables\" can cause the placeholder to jitter\n\t\t\t// beetween the outer and inner container.\n\t\t\tif (item.instance !== this.currentContainer) continue;\n\n\t\t\tif (itemElement != this.currentItem[0] //cannot intersect with itself\n\t\t\t\t&&\tthis.placeholder[intersection == 1 ? \"next\" : \"prev\"]()[0] != itemElement //no useless actions that have been done before\n\t\t\t\t&&\t!$.contains(this.placeholder[0], itemElement) //no action if the item moved is the parent of the item checked\n\t\t\t\t&& (this.options.type == 'semi-dynamic' ? !$.contains(this.element[0], itemElement) : true)\n\t\t\t\t//&& itemElement.parentNode == this.placeholder[0].parentNode // only rearrange items within the same container\n\t\t\t) {\n\n\t\t\t\tthis.direction = intersection == 1 ? \"down\" : \"up\";\n\n\t\t\t\tif (this.options.tolerance == \"pointer\" || this._intersectsWithSides(item)) {\n\t\t\t\t\tthis._rearrange(event, item);\n\t\t\t\t} else {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tthis._trigger(\"change\", event, this._uiHash());\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\t\t//Post events to containers\n\t\tthis._contactContainers(event);\n\n\t\t//Interconnect with droppables\n\t\tif($.ui.ddmanager) $.ui.ddmanager.drag(this, event);\n\n\t\t//Call callbacks\n\t\tthis._trigger('sort', event, this._uiHash());\n\n\t\tthis.lastPositionAbs = this.positionAbs;\n\t\treturn false;\n\n\t},\n\n\t_mouseStop: function(event, noPropagation) {\n\n\t\tif(!event) return;\n\n\t\t//If we are using droppables, inform the manager about the drop\n\t\tif ($.ui.ddmanager && !this.options.dropBehaviour)\n\t\t\t$.ui.ddmanager.drop(this, event);\n\n\t\tif(this.options.revert) {\n\t\t\tvar that = this;\n\t\t\tvar cur = this.placeholder.offset();\n\n\t\t\tthis.reverting = true;\n\n\t\t\t$(this.helper).animate({\n\t\t\t\tleft: cur.left - this.offset.parent.left - this.margins.left + (this.offsetParent[0] == document.body ? 0 : this.offsetParent[0].scrollLeft),\n\t\t\t\ttop: cur.top - this.offset.parent.top - this.margins.top + (this.offsetParent[0] == document.body ? 0 : this.offsetParent[0].scrollTop)\n\t\t\t}, parseInt(this.options.revert, 10) || 500, function() {\n\t\t\t\tthat._clear(event);\n\t\t\t});\n\t\t} else {\n\t\t\tthis._clear(event, noPropagation);\n\t\t}\n\n\t\treturn false;\n\n\t},\n\n\tcancel: function() {\n\n\t\tif(this.dragging) {\n\n\t\t\tthis._mouseUp({ target: null });\n\n\t\t\tif(this.options.helper == \"original\")\n\t\t\t\tthis.currentItem.css(this._storedCSS).removeClass(\"ui-sortable-helper\");\n\t\t\telse\n\t\t\t\tthis.currentItem.show();\n\n\t\t\t//Post deactivating events to containers\n\t\t\tfor (var i = this.containers.length - 1; i >= 0; i--){\n\t\t\t\tthis.containers[i]._trigger(\"deactivate\", null, this._uiHash(this));\n\t\t\t\tif(this.containers[i].containerCache.over) {\n\t\t\t\t\tthis.containers[i]._trigger(\"out\", null, this._uiHash(this));\n\t\t\t\t\tthis.containers[i].containerCache.over = 0;\n\t\t\t\t}\n\t\t\t}\n\n\t\t}\n\n\t\tif (this.placeholder) {\n\t\t\t//$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately, it unbinds ALL events from the original node!\n\t\t\tif(this.placeholder[0].parentNode) this.placeholder[0].parentNode.removeChild(this.placeholder[0]);\n\t\t\tif(this.options.helper != \"original\" && this.helper && this.helper[0].parentNode) this.helper.remove();\n\n\t\t\t$.extend(this, {\n\t\t\t\thelper: null,\n\t\t\t\tdragging: false,\n\t\t\t\treverting: false,\n\t\t\t\t_noFinalSort: null\n\t\t\t});\n\n\t\t\tif(this.domPosition.prev) {\n\t\t\t\t$(this.domPosition.prev).after(this.currentItem);\n\t\t\t} else {\n\t\t\t\t$(this.domPosition.parent).prepend(this.currentItem);\n\t\t\t}\n\t\t}\n\n\t\treturn this;\n\n\t},\n\n\tserialize: function(o) {\n\n\t\tvar items = this._getItemsAsjQuery(o && o.connected);\n\t\tvar str = []; o = o || {};\n\n\t\t$(items).each(function() {\n\t\t\tvar res = ($(o.item || this).attr(o.attribute || 'id') || '').match(o.expression || (/(.+)[-=_](.+)/));\n\t\t\tif(res) str.push((o.key || res[1]+'[]')+'='+(o.key && o.expression ? res[1] : res[2]));\n\t\t});\n\n\t\tif(!str.length && o.key) {\n\t\t\tstr.push(o.key + '=');\n\t\t}\n\n\t\treturn str.join('&');\n\n\t},\n\n\ttoArray: function(o) {\n\n\t\tvar items = this._getItemsAsjQuery(o && o.connected);\n\t\tvar ret = []; o = o || {};\n\n\t\titems.each(function() { ret.push($(o.item || this).attr(o.attribute || 'id') || ''); });\n\t\treturn ret;\n\n\t},\n\n\t/* Be careful with the following core functions */\n\t_intersectsWith: function(item) {\n\n\t\tvar x1 = this.positionAbs.left,\n\t\t\tx2 = x1 + this.helperProportions.width,\n\t\t\ty1 = this.positionAbs.top,\n\t\t\ty2 = y1 + this.helperProportions.height;\n\n\t\tvar l = item.left,\n\t\t\tr = l + item.width,\n\t\t\tt = item.top,\n\t\t\tb = t + item.height;\n\n\t\tvar dyClick = this.offset.click.top,\n\t\t\tdxClick = this.offset.click.left;\n\n\t\tvar isOverElement = (y1 + dyClick) > t && (y1 + dyClick) < b && (x1 + dxClick) > l && (x1 + dxClick) < r;\n\n\t\tif(\t   this.options.tolerance == \"pointer\"\n\t\t\t|| this.options.forcePointerForContainers\n\t\t\t|| (this.options.tolerance != \"pointer\" && this.helperProportions[this.floating ? 'width' : 'height'] > item[this.floating ? 'width' : 'height'])\n\t\t) {\n\t\t\treturn isOverElement;\n\t\t} else {\n\n\t\t\treturn (l < x1 + (this.helperProportions.width / 2) // Right Half\n\t\t\t\t&& x2 - (this.helperProportions.width / 2) < r // Left Half\n\t\t\t\t&& t < y1 + (this.helperProportions.height / 2) // Bottom Half\n\t\t\t\t&& y2 - (this.helperProportions.height / 2) < b ); // Top Half\n\n\t\t}\n\t},\n\n\t_intersectsWithPointer: function(item) {\n\n\t\tvar isOverElementHeight = (this.options.axis === 'x') || $.ui.isOverAxis(this.positionAbs.top + this.offset.click.top, item.top, item.height),\n\t\t\tisOverElementWidth = (this.options.axis === 'y') || $.ui.isOverAxis(this.positionAbs.left + this.offset.click.left, item.left, item.width),\n\t\t\tisOverElement = isOverElementHeight && isOverElementWidth,\n\t\t\tverticalDirection = this._getDragVerticalDirection(),\n\t\t\thorizontalDirection = this._getDragHorizontalDirection();\n\n\t\tif (!isOverElement)\n\t\t\treturn false;\n\n\t\treturn this.floating ?\n\t\t\t( ((horizontalDirection && horizontalDirection == \"right\") || verticalDirection == \"down\") ? 2 : 1 )\n\t\t\t: ( verticalDirection && (verticalDirection == \"down\" ? 2 : 1) );\n\n\t},\n\n\t_intersectsWithSides: function(item) {\n\n\t\tvar isOverBottomHalf = $.ui.isOverAxis(this.positionAbs.top + this.offset.click.top, item.top + (item.height/2), item.height),\n\t\t\tisOverRightHalf = $.ui.isOverAxis(this.positionAbs.left + this.offset.click.left, item.left + (item.width/2), item.width),\n\t\t\tverticalDirection = this._getDragVerticalDirection(),\n\t\t\thorizontalDirection = this._getDragHorizontalDirection();\n\n\t\tif (this.floating && horizontalDirection) {\n\t\t\treturn ((horizontalDirection == \"right\" && isOverRightHalf) || (horizontalDirection == \"left\" && !isOverRightHalf));\n\t\t} else {\n\t\t\treturn verticalDirection && ((verticalDirection == \"down\" && isOverBottomHalf) || (verticalDirection == \"up\" && !isOverBottomHalf));\n\t\t}\n\n\t},\n\n\t_getDragVerticalDirection: function() {\n\t\tvar delta = this.positionAbs.top - this.lastPositionAbs.top;\n\t\treturn delta != 0 && (delta > 0 ? \"down\" : \"up\");\n\t},\n\n\t_getDragHorizontalDirection: function() {\n\t\tvar delta = this.positionAbs.left - this.lastPositionAbs.left;\n\t\treturn delta != 0 && (delta > 0 ? \"right\" : \"left\");\n\t},\n\n\trefresh: function(event) {\n\t\tthis._refreshItems(event);\n\t\tthis.refreshPositions();\n\t\treturn this;\n\t},\n\n\t_connectWith: function() {\n\t\tvar options = this.options;\n\t\treturn options.connectWith.constructor == String\n\t\t\t? [options.connectWith]\n\t\t\t: options.connectWith;\n\t},\n\n\t_getItemsAsjQuery: function(connected) {\n\n\t\tvar items = [];\n\t\tvar queries = [];\n\t\tvar connectWith = this._connectWith();\n\n\t\tif(connectWith && connected) {\n\t\t\tfor (var i = connectWith.length - 1; i >= 0; i--){\n\t\t\t\tvar cur = $(connectWith[i]);\n\t\t\t\tfor (var j = cur.length - 1; j >= 0; j--){\n\t\t\t\t\tvar inst = $.data(cur[j], this.widgetName);\n\t\t\t\t\tif(inst && inst != this && !inst.options.disabled) {\n\t\t\t\t\t\tqueries.push([$.isFunction(inst.options.items) ? inst.options.items.call(inst.element) : $(inst.options.items, inst.element).not(\".ui-sortable-helper\").not('.ui-sortable-placeholder'), inst]);\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t};\n\t\t}\n\n\t\tqueries.push([$.isFunction(this.options.items) ? this.options.items.call(this.element, null, { options: this.options, item: this.currentItem }) : $(this.options.items, this.element).not(\".ui-sortable-helper\").not('.ui-sortable-placeholder'), this]);\n\n\t\tfor (var i = queries.length - 1; i >= 0; i--){\n\t\t\tqueries[i][0].each(function() {\n\t\t\t\titems.push(this);\n\t\t\t});\n\t\t};\n\n\t\treturn $(items);\n\n\t},\n\n\t_removeCurrentsFromItems: function() {\n\n\t\tvar list = this.currentItem.find(\":data(\" + this.widgetName + \"-item)\");\n\n\t\tthis.items = $.grep(this.items, function (item) {\n\t\t\tfor (var j=0; j < list.length; j++) {\n\t\t\t\tif(list[j] == item.item[0])\n\t\t\t\t\treturn false;\n\t\t\t};\n\t\t\treturn true;\n\t\t});\n\n\t},\n\n\t_refreshItems: function(event) {\n\n\t\tthis.items = [];\n\t\tthis.containers = [this];\n\t\tvar items = this.items;\n\t\tvar queries = [[$.isFunction(this.options.items) ? this.options.items.call(this.element[0], event, { item: this.currentItem }) : $(this.options.items, this.element), this]];\n\t\tvar connectWith = this._connectWith();\n\n\t\tif(connectWith && this.ready) { //Shouldn't be run the first time through due to massive slow-down\n\t\t\tfor (var i = connectWith.length - 1; i >= 0; i--){\n\t\t\t\tvar cur = $(connectWith[i]);\n\t\t\t\tfor (var j = cur.length - 1; j >= 0; j--){\n\t\t\t\t\tvar inst = $.data(cur[j], this.widgetName);\n\t\t\t\t\tif(inst && inst != this && !inst.options.disabled) {\n\t\t\t\t\t\tqueries.push([$.isFunction(inst.options.items) ? inst.options.items.call(inst.element[0], event, { item: this.currentItem }) : $(inst.options.items, inst.element), inst]);\n\t\t\t\t\t\tthis.containers.push(inst);\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t};\n\t\t}\n\n\t\tfor (var i = queries.length - 1; i >= 0; i--) {\n\t\t\tvar targetData = queries[i][1];\n\t\t\tvar _queries = queries[i][0];\n\n\t\t\tfor (var j=0, queriesLength = _queries.length; j < queriesLength; j++) {\n\t\t\t\tvar item = $(_queries[j]);\n\n\t\t\t\titem.data(this.widgetName + '-item', targetData); // Data for target checking (mouse manager)\n\n\t\t\t\titems.push({\n\t\t\t\t\titem: item,\n\t\t\t\t\tinstance: targetData,\n\t\t\t\t\twidth: 0, height: 0,\n\t\t\t\t\tleft: 0, top: 0\n\t\t\t\t});\n\t\t\t};\n\t\t};\n\n\t},\n\n\trefreshPositions: function(fast) {\n\n\t\t//This has to be redone because due to the item being moved out/into the offsetParent, the offsetParent's position will change\n\t\tif(this.offsetParent && this.helper) {\n\t\t\tthis.offset.parent = this._getParentOffset();\n\t\t}\n\n\t\tfor (var i = this.items.length - 1; i >= 0; i--){\n\t\t\tvar item = this.items[i];\n\n\t\t\t//We ignore calculating positions of all connected containers when we're not over them\n\t\t\tif(item.instance != this.currentContainer && this.currentContainer && item.item[0] != this.currentItem[0])\n\t\t\t\tcontinue;\n\n\t\t\tvar t = this.options.toleranceElement ? $(this.options.toleranceElement, item.item) : item.item;\n\n\t\t\tif (!fast) {\n\t\t\t\titem.width = t.outerWidth();\n\t\t\t\titem.height = t.outerHeight();\n\t\t\t}\n\n\t\t\tvar p = t.offset();\n\t\t\titem.left = p.left;\n\t\t\titem.top = p.top;\n\t\t};\n\n\t\tif(this.options.custom && this.options.custom.refreshContainers) {\n\t\t\tthis.options.custom.refreshContainers.call(this);\n\t\t} else {\n\t\t\tfor (var i = this.containers.length - 1; i >= 0; i--){\n\t\t\t\tvar p = this.containers[i].element.offset();\n\t\t\t\tthis.containers[i].containerCache.left = p.left;\n\t\t\t\tthis.containers[i].containerCache.top = p.top;\n\t\t\t\tthis.containers[i].containerCache.width\t= this.containers[i].element.outerWidth();\n\t\t\t\tthis.containers[i].containerCache.height = this.containers[i].element.outerHeight();\n\t\t\t};\n\t\t}\n\n\t\treturn this;\n\t},\n\n\t_createPlaceholder: function(that) {\n\t\tthat = that || this;\n\t\tvar o = that.options;\n\n\t\tif(!o.placeholder || o.placeholder.constructor == String) {\n\t\t\tvar className = o.placeholder;\n\t\t\to.placeholder = {\n\t\t\t\telement: function() {\n\n\t\t\t\t\tvar el = $(document.createElement(that.currentItem[0].nodeName))\n\t\t\t\t\t\t.addClass(className || that.currentItem[0].className+\" ui-sortable-placeholder\")\n\t\t\t\t\t\t.removeClass(\"ui-sortable-helper\")[0];\n\n\t\t\t\t\tif(!className)\n\t\t\t\t\t\tel.style.visibility = \"hidden\";\n\n\t\t\t\t\treturn el;\n\t\t\t\t},\n\t\t\t\tupdate: function(container, p) {\n\n\t\t\t\t\t// 1. If a className is set as 'placeholder option, we don't force sizes - the class is responsible for that\n\t\t\t\t\t// 2. The option 'forcePlaceholderSize can be enabled to force it even if a class name is specified\n\t\t\t\t\tif(className && !o.forcePlaceholderSize) return;\n\n\t\t\t\t\t//If the element doesn't have a actual height by itself (without styles coming from a stylesheet), it receives the inline height from the dragged item\n\t\t\t\t\tif(!p.height()) { p.height(that.currentItem.innerHeight() - parseInt(that.currentItem.css('paddingTop')||0, 10) - parseInt(that.currentItem.css('paddingBottom')||0, 10)); };\n\t\t\t\t\tif(!p.width()) { p.width(that.currentItem.innerWidth() - parseInt(that.currentItem.css('paddingLeft')||0, 10) - parseInt(that.currentItem.css('paddingRight')||0, 10)); };\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\n\t\t//Create the placeholder\n\t\tthat.placeholder = $(o.placeholder.element.call(that.element, that.currentItem));\n\n\t\t//Append it after the actual current item\n\t\tthat.currentItem.after(that.placeholder);\n\n\t\t//Update the size of the placeholder (TODO: Logic to fuzzy, see line 316/317)\n\t\to.placeholder.update(that, that.placeholder);\n\n\t},\n\n\t_contactContainers: function(event) {\n\n\t\t// get innermost container that intersects with item\n\t\tvar innermostContainer = null, innermostIndex = null;\n\n\n\t\tfor (var i = this.containers.length - 1; i >= 0; i--){\n\n\t\t\t// never consider a container that's located within the item itself\n\t\t\tif($.contains(this.currentItem[0], this.containers[i].element[0]))\n\t\t\t\tcontinue;\n\n\t\t\tif(this._intersectsWith(this.containers[i].containerCache)) {\n\n\t\t\t\t// if we've already found a container and it's more \"inner\" than this, then continue\n\t\t\t\tif(innermostContainer && $.contains(this.containers[i].element[0], innermostContainer.element[0]))\n\t\t\t\t\tcontinue;\n\n\t\t\t\tinnermostContainer = this.containers[i];\n\t\t\t\tinnermostIndex = i;\n\n\t\t\t} else {\n\t\t\t\t// container doesn't intersect. trigger \"out\" event if necessary\n\t\t\t\tif(this.containers[i].containerCache.over) {\n\t\t\t\t\tthis.containers[i]._trigger(\"out\", event, this._uiHash(this));\n\t\t\t\t\tthis.containers[i].containerCache.over = 0;\n\t\t\t\t}\n\t\t\t}\n\n\t\t}\n\n\t\t// if no intersecting containers found, return\n\t\tif(!innermostContainer) return;\n\n\t\t// move the item into the container if it's not there already\n\t\tif(this.containers.length === 1) {\n\t\t\tthis.containers[innermostIndex]._trigger(\"over\", event, this._uiHash(this));\n\t\t\tthis.containers[innermostIndex].containerCache.over = 1;\n\t\t} else {\n\n\t\t\t//When entering a new container, we will find the item with the least distance and append our item near it\n\t\t\tvar dist = 10000; var itemWithLeastDistance = null;\n\t\t\tvar posProperty = this.containers[innermostIndex].floating ? 'left' : 'top';\n\t\t\tvar sizeProperty = this.containers[innermostIndex].floating ? 'width' : 'height';\n\t\t\tvar base = this.positionAbs[posProperty] + this.offset.click[posProperty];\n\t\t\tfor (var j = this.items.length - 1; j >= 0; j--) {\n\t\t\t\tif(!$.contains(this.containers[innermostIndex].element[0], this.items[j].item[0])) continue;\n\t\t\t\tif(this.items[j].item[0] == this.currentItem[0]) continue;\n\t\t\t\tvar cur = this.items[j].item.offset()[posProperty];\n\t\t\t\tvar nearBottom = false;\n\t\t\t\tif(Math.abs(cur - base) > Math.abs(cur + this.items[j][sizeProperty] - base)){\n\t\t\t\t\tnearBottom = true;\n\t\t\t\t\tcur += this.items[j][sizeProperty];\n\t\t\t\t}\n\n\t\t\t\tif(Math.abs(cur - base) < dist) {\n\t\t\t\t\tdist = Math.abs(cur - base); itemWithLeastDistance = this.items[j];\n\t\t\t\t\tthis.direction = nearBottom ? \"up\": \"down\";\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif(!itemWithLeastDistance && !this.options.dropOnEmpty) //Check if dropOnEmpty is enabled\n\t\t\t\treturn;\n\n\t\t\tthis.currentContainer = this.containers[innermostIndex];\n\t\t\titemWithLeastDistance ? this._rearrange(event, itemWithLeastDistance, null, true) : this._rearrange(event, null, this.containers[innermostIndex].element, true);\n\t\t\tthis._trigger(\"change\", event, this._uiHash());\n\t\t\tthis.containers[innermostIndex]._trigger(\"change\", event, this._uiHash(this));\n\n\t\t\t//Update the placeholder\n\t\t\tthis.options.placeholder.update(this.currentContainer, this.placeholder);\n\n\t\t\tthis.containers[innermostIndex]._trigger(\"over\", event, this._uiHash(this));\n\t\t\tthis.containers[innermostIndex].containerCache.over = 1;\n\t\t}\n\n\n\t},\n\n\t_createHelper: function(event) {\n\n\t\tvar o = this.options;\n\t\tvar helper = $.isFunction(o.helper) ? $(o.helper.apply(this.element[0], [event, this.currentItem])) : (o.helper == 'clone' ? this.currentItem.clone() : this.currentItem);\n\n\t\tif(!helper.parents('body').length) //Add the helper to the DOM if that didn't happen already\n\t\t\t$(o.appendTo != 'parent' ? o.appendTo : this.currentItem[0].parentNode)[0].appendChild(helper[0]);\n\n\t\tif(helper[0] == this.currentItem[0])\n\t\t\tthis._storedCSS = { width: this.currentItem[0].style.width, height: this.currentItem[0].style.height, position: this.currentItem.css(\"position\"), top: this.currentItem.css(\"top\"), left: this.currentItem.css(\"left\") };\n\n\t\tif(helper[0].style.width == '' || o.forceHelperSize) helper.width(this.currentItem.width());\n\t\tif(helper[0].style.height == '' || o.forceHelperSize) helper.height(this.currentItem.height());\n\n\t\treturn helper;\n\n\t},\n\n\t_adjustOffsetFromHelper: function(obj) {\n\t\tif (typeof obj == 'string') {\n\t\t\tobj = obj.split(' ');\n\t\t}\n\t\tif ($.isArray(obj)) {\n\t\t\tobj = {left: +obj[0], top: +obj[1] || 0};\n\t\t}\n\t\tif ('left' in obj) {\n\t\t\tthis.offset.click.left = obj.left + this.margins.left;\n\t\t}\n\t\tif ('right' in obj) {\n\t\t\tthis.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;\n\t\t}\n\t\tif ('top' in obj) {\n\t\t\tthis.offset.click.top = obj.top + this.margins.top;\n\t\t}\n\t\tif ('bottom' in obj) {\n\t\t\tthis.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;\n\t\t}\n\t},\n\n\t_getParentOffset: function() {\n\n\n\t\t//Get the offsetParent and cache its position\n\t\tthis.offsetParent = this.helper.offsetParent();\n\t\tvar po = this.offsetParent.offset();\n\n\t\t// This is a special case where we need to modify a offset calculated on start, since the following happened:\n\t\t// 1. The position of the helper is absolute, so it's position is calculated based on the next positioned parent\n\t\t// 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't the document, which means that\n\t\t//    the scroll is included in the initial calculation of the offset of the parent, and never recalculated upon drag\n\t\tif(this.cssPosition == 'absolute' && this.scrollParent[0] != document && $.contains(this.scrollParent[0], this.offsetParent[0])) {\n\t\t\tpo.left += this.scrollParent.scrollLeft();\n\t\t\tpo.top += this.scrollParent.scrollTop();\n\t\t}\n\n\t\tif((this.offsetParent[0] == document.body) //This needs to be actually done for all browsers, since pageX/pageY includes this information\n\t\t|| (this.offsetParent[0].tagName && this.offsetParent[0].tagName.toLowerCase() == 'html' && $.ui.ie)) //Ugly IE fix\n\t\t\tpo = { top: 0, left: 0 };\n\n\t\treturn {\n\t\t\ttop: po.top + (parseInt(this.offsetParent.css(\"borderTopWidth\"),10) || 0),\n\t\t\tleft: po.left + (parseInt(this.offsetParent.css(\"borderLeftWidth\"),10) || 0)\n\t\t};\n\n\t},\n\n\t_getRelativeOffset: function() {\n\n\t\tif(this.cssPosition == \"relative\") {\n\t\t\tvar p = this.currentItem.position();\n\t\t\treturn {\n\t\t\t\ttop: p.top - (parseInt(this.helper.css(\"top\"),10) || 0) + this.scrollParent.scrollTop(),\n\t\t\t\tleft: p.left - (parseInt(this.helper.css(\"left\"),10) || 0) + this.scrollParent.scrollLeft()\n\t\t\t};\n\t\t} else {\n\t\t\treturn { top: 0, left: 0 };\n\t\t}\n\n\t},\n\n\t_cacheMargins: function() {\n\t\tthis.margins = {\n\t\t\tleft: (parseInt(this.currentItem.css(\"marginLeft\"),10) || 0),\n\t\t\ttop: (parseInt(this.currentItem.css(\"marginTop\"),10) || 0)\n\t\t};\n\t},\n\n\t_cacheHelperProportions: function() {\n\t\tthis.helperProportions = {\n\t\t\twidth: this.helper.outerWidth(),\n\t\t\theight: this.helper.outerHeight()\n\t\t};\n\t},\n\n\t_setContainment: function() {\n\n\t\tvar o = this.options;\n\t\tif(o.containment == 'parent') o.containment = this.helper[0].parentNode;\n\t\tif(o.containment == 'document' || o.containment == 'window') this.containment = [\n\t\t\t0 - this.offset.relative.left - this.offset.parent.left,\n\t\t\t0 - this.offset.relative.top - this.offset.parent.top,\n\t\t\t$(o.containment == 'document' ? document : window).width() - this.helperProportions.width - this.margins.left,\n\t\t\t($(o.containment == 'document' ? document : window).height() || document.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top\n\t\t];\n\n\t\tif(!(/^(document|window|parent)$/).test(o.containment)) {\n\t\t\tvar ce = $(o.containment)[0];\n\t\t\tvar co = $(o.containment).offset();\n\t\t\tvar over = ($(ce).css(\"overflow\") != 'hidden');\n\n\t\t\tthis.containment = [\n\t\t\t\tco.left + (parseInt($(ce).css(\"borderLeftWidth\"),10) || 0) + (parseInt($(ce).css(\"paddingLeft\"),10) || 0) - this.margins.left,\n\t\t\t\tco.top + (parseInt($(ce).css(\"borderTopWidth\"),10) || 0) + (parseInt($(ce).css(\"paddingTop\"),10) || 0) - this.margins.top,\n\t\t\t\tco.left+(over ? Math.max(ce.scrollWidth,ce.offsetWidth) : ce.offsetWidth) - (parseInt($(ce).css(\"borderLeftWidth\"),10) || 0) - (parseInt($(ce).css(\"paddingRight\"),10) || 0) - this.helperProportions.width - this.margins.left,\n\t\t\t\tco.top+(over ? Math.max(ce.scrollHeight,ce.offsetHeight) : ce.offsetHeight) - (parseInt($(ce).css(\"borderTopWidth\"),10) || 0) - (parseInt($(ce).css(\"paddingBottom\"),10) || 0) - this.helperProportions.height - this.margins.top\n\t\t\t];\n\t\t}\n\n\t},\n\n\t_convertPositionTo: function(d, pos) {\n\n\t\tif(!pos) pos = this.position;\n\t\tvar mod = d == \"absolute\" ? 1 : -1;\n\t\tvar o = this.options, scroll = this.cssPosition == 'absolute' && !(this.scrollParent[0] != document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent, scrollIsRootNode = (/(html|body)/i).test(scroll[0].tagName);\n\n\t\treturn {\n\t\t\ttop: (\n\t\t\t\tpos.top\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n\t\t\t\t+ this.offset.relative.top * mod\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\t+ this.offset.parent.top * mod\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\t- ( ( this.cssPosition == 'fixed' ? -this.scrollParent.scrollTop() : ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ) * mod)\n\t\t\t),\n\t\t\tleft: (\n\t\t\t\tpos.left\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n\t\t\t\t+ this.offset.relative.left * mod\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\t+ this.offset.parent.left * mod\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\t- ( ( this.cssPosition == 'fixed' ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft() ) * mod)\n\t\t\t)\n\t\t};\n\n\t},\n\n\t_generatePosition: function(event) {\n\n\t\tvar o = this.options, scroll = this.cssPosition == 'absolute' && !(this.scrollParent[0] != document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent, scrollIsRootNode = (/(html|body)/i).test(scroll[0].tagName);\n\n\t\t// This is another very weird special case that only happens for relative elements:\n\t\t// 1. If the css position is relative\n\t\t// 2. and the scroll parent is the document or similar to the offset parent\n\t\t// we have to refresh the relative offset during the scroll so there are no jumps\n\t\tif(this.cssPosition == 'relative' && !(this.scrollParent[0] != document && this.scrollParent[0] != this.offsetParent[0])) {\n\t\t\tthis.offset.relative = this._getRelativeOffset();\n\t\t}\n\n\t\tvar pageX = event.pageX;\n\t\tvar pageY = event.pageY;\n\n\t\t/*\n\t\t * - Position constraining -\n\t\t * Constrain the position to a mix of grid, containment.\n\t\t */\n\n\t\tif(this.originalPosition) { //If we are not dragging yet, we won't check for options\n\n\t\t\tif(this.containment) {\n\t\t\t\tif(event.pageX - this.offset.click.left < this.containment[0]) pageX = this.containment[0] + this.offset.click.left;\n\t\t\t\tif(event.pageY - this.offset.click.top < this.containment[1]) pageY = this.containment[1] + this.offset.click.top;\n\t\t\t\tif(event.pageX - this.offset.click.left > this.containment[2]) pageX = this.containment[2] + this.offset.click.left;\n\t\t\t\tif(event.pageY - this.offset.click.top > this.containment[3]) pageY = this.containment[3] + this.offset.click.top;\n\t\t\t}\n\n\t\t\tif(o.grid) {\n\t\t\t\tvar top = this.originalPageY + Math.round((pageY - this.originalPageY) / o.grid[1]) * o.grid[1];\n\t\t\t\tpageY = this.containment ? (!(top - this.offset.click.top < this.containment[1] || top - this.offset.click.top > this.containment[3]) ? top : (!(top - this.offset.click.top < this.containment[1]) ? top - o.grid[1] : top + o.grid[1])) : top;\n\n\t\t\t\tvar left = this.originalPageX + Math.round((pageX - this.originalPageX) / o.grid[0]) * o.grid[0];\n\t\t\t\tpageX = this.containment ? (!(left - this.offset.click.left < this.containment[0] || left - this.offset.click.left > this.containment[2]) ? left : (!(left - this.offset.click.left < this.containment[0]) ? left - o.grid[0] : left + o.grid[0])) : left;\n\t\t\t}\n\n\t\t}\n\n\t\treturn {\n\t\t\ttop: (\n\t\t\t\tpageY\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n\t\t\t\t- this.offset.click.top\t\t\t\t\t\t\t\t\t\t\t\t\t// Click offset (relative to the element)\n\t\t\t\t- this.offset.relative.top\t\t\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\t- this.offset.parent.top\t\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\t+ ( ( this.cssPosition == 'fixed' ? -this.scrollParent.scrollTop() : ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ))\n\t\t\t),\n\t\t\tleft: (\n\t\t\t\tpageX\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n\t\t\t\t- this.offset.click.left\t\t\t\t\t\t\t\t\t\t\t\t// Click offset (relative to the element)\n\t\t\t\t- this.offset.relative.left\t\t\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n\t\t\t\t- this.offset.parent.left\t\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n\t\t\t\t+ ( ( this.cssPosition == 'fixed' ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft() ))\n\t\t\t)\n\t\t};\n\n\t},\n\n\t_rearrange: function(event, i, a, hardRefresh) {\n\n\t\ta ? a[0].appendChild(this.placeholder[0]) : i.item[0].parentNode.insertBefore(this.placeholder[0], (this.direction == 'down' ? i.item[0] : i.item[0].nextSibling));\n\n\t\t//Various things done here to improve the performance:\n\t\t// 1. we create a setTimeout, that calls refreshPositions\n\t\t// 2. on the instance, we have a counter variable, that get's higher after every append\n\t\t// 3. on the local scope, we copy the counter variable, and check in the timeout, if it's still the same\n\t\t// 4. this lets only the last addition to the timeout stack through\n\t\tthis.counter = this.counter ? ++this.counter : 1;\n\t\tvar counter = this.counter;\n\n\t\tthis._delay(function() {\n\t\t\tif(counter == this.counter) this.refreshPositions(!hardRefresh); //Precompute after each DOM insertion, NOT on mousemove\n\t\t});\n\n\t},\n\n\t_clear: function(event, noPropagation) {\n\n\t\tthis.reverting = false;\n\t\t// We delay all events that have to be triggered to after the point where the placeholder has been removed and\n\t\t// everything else normalized again\n\t\tvar delayedTriggers = [];\n\n\t\t// We first have to update the dom position of the actual currentItem\n\t\t// Note: don't do it if the current item is already removed (by a user), or it gets reappended (see #4088)\n\t\tif(!this._noFinalSort && this.currentItem.parent().length) this.placeholder.before(this.currentItem);\n\t\tthis._noFinalSort = null;\n\n\t\tif(this.helper[0] == this.currentItem[0]) {\n\t\t\tfor(var i in this._storedCSS) {\n\t\t\t\tif(this._storedCSS[i] == 'auto' || this._storedCSS[i] == 'static') this._storedCSS[i] = '';\n\t\t\t}\n\t\t\tthis.currentItem.css(this._storedCSS).removeClass(\"ui-sortable-helper\");\n\t\t} else {\n\t\t\tthis.currentItem.show();\n\t\t}\n\n\t\tif(this.fromOutside && !noPropagation) delayedTriggers.push(function(event) { this._trigger(\"receive\", event, this._uiHash(this.fromOutside)); });\n\t\tif((this.fromOutside || this.domPosition.prev != this.currentItem.prev().not(\".ui-sortable-helper\")[0] || this.domPosition.parent != this.currentItem.parent()[0]) && !noPropagation) delayedTriggers.push(function(event) { this._trigger(\"update\", event, this._uiHash()); }); //Trigger update callback if the DOM position has changed\n\n\t\t// Check if the items Container has Changed and trigger appropriate\n\t\t// events.\n\t\tif (this !== this.currentContainer) {\n\t\t\tif(!noPropagation) {\n\t\t\t\tdelayedTriggers.push(function(event) { this._trigger(\"remove\", event, this._uiHash()); });\n\t\t\t\tdelayedTriggers.push((function(c) { return function(event) { c._trigger(\"receive\", event, this._uiHash(this)); };  }).call(this, this.currentContainer));\n\t\t\t\tdelayedTriggers.push((function(c) { return function(event) { c._trigger(\"update\", event, this._uiHash(this));  }; }).call(this, this.currentContainer));\n\t\t\t}\n\t\t}\n\n\n\t\t//Post events to containers\n\t\tfor (var i = this.containers.length - 1; i >= 0; i--){\n\t\t\tif(!noPropagation) delayedTriggers.push((function(c) { return function(event) { c._trigger(\"deactivate\", event, this._uiHash(this)); };  }).call(this, this.containers[i]));\n\t\t\tif(this.containers[i].containerCache.over) {\n\t\t\t\tdelayedTriggers.push((function(c) { return function(event) { c._trigger(\"out\", event, this._uiHash(this)); };  }).call(this, this.containers[i]));\n\t\t\t\tthis.containers[i].containerCache.over = 0;\n\t\t\t}\n\t\t}\n\n\t\t//Do what was originally in plugins\n\t\tif(this._storedCursor) $('body').css(\"cursor\", this._storedCursor); //Reset cursor\n\t\tif(this._storedOpacity) this.helper.css(\"opacity\", this._storedOpacity); //Reset opacity\n\t\tif(this._storedZIndex) this.helper.css(\"zIndex\", this._storedZIndex == 'auto' ? '' : this._storedZIndex); //Reset z-index\n\n\t\tthis.dragging = false;\n\t\tif(this.cancelHelperRemoval) {\n\t\t\tif(!noPropagation) {\n\t\t\t\tthis._trigger(\"beforeStop\", event, this._uiHash());\n\t\t\t\tfor (var i=0; i < delayedTriggers.length; i++) { delayedTriggers[i].call(this, event); }; //Trigger all delayed events\n\t\t\t\tthis._trigger(\"stop\", event, this._uiHash());\n\t\t\t}\n\n\t\t\tthis.fromOutside = false;\n\t\t\treturn false;\n\t\t}\n\n\t\tif(!noPropagation) this._trigger(\"beforeStop\", event, this._uiHash());\n\n\t\t//$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately, it unbinds ALL events from the original node!\n\t\tthis.placeholder[0].parentNode.removeChild(this.placeholder[0]);\n\n\t\tif(this.helper[0] != this.currentItem[0]) this.helper.remove(); this.helper = null;\n\n\t\tif(!noPropagation) {\n\t\t\tfor (var i=0; i < delayedTriggers.length; i++) { delayedTriggers[i].call(this, event); }; //Trigger all delayed events\n\t\t\tthis._trigger(\"stop\", event, this._uiHash());\n\t\t}\n\n\t\tthis.fromOutside = false;\n\t\treturn true;\n\n\t},\n\n\t_trigger: function() {\n\t\tif ($.Widget.prototype._trigger.apply(this, arguments) === false) {\n\t\t\tthis.cancel();\n\t\t}\n\t},\n\n\t_uiHash: function(_inst) {\n\t\tvar inst = _inst || this;\n\t\treturn {\n\t\t\thelper: inst.helper,\n\t\t\tplaceholder: inst.placeholder || $([]),\n\t\t\tposition: inst.position,\n\t\t\toriginalPosition: inst.originalPosition,\n\t\t\toffset: inst.positionAbs,\n\t\t\titem: inst.currentItem,\n\t\t\tsender: _inst ? _inst.element : null\n\t\t};\n\t}\n\n});\n\n})(jQuery);\n\n;(jQuery.effects || (function($, undefined) {\n\nvar backCompat = $.uiBackCompat !== false,\n\t// prefix used for storing data on .data()\n\tdataSpace = \"ui-effects-\";\n\n$.effects = {\n\teffect: {}\n};\n\n/*!\n * jQuery Color Animations v2.0.0\n * http://jquery.com/\n *\n * Copyright 2012 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * Date: Mon Aug 13 13:41:02 2012 -0500\n */\n(function( jQuery, undefined ) {\n\n\tvar stepHooks = \"backgroundColor borderBottomColor borderLeftColor borderRightColor borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor\".split(\" \"),\n\n\t// plusequals test for += 100 -= 100\n\trplusequals = /^([\\-+])=\\s*(\\d+\\.?\\d*)/,\n\t// a set of RE's that can match strings and generate color tuples.\n\tstringParsers = [{\n\t\t\tre: /rgba?\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*(?:,\\s*(\\d+(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ],\n\t\t\t\t\texecResult[ 2 ],\n\t\t\t\t\texecResult[ 3 ],\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\tre: /rgba?\\(\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d+(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ] * 2.55,\n\t\t\t\t\texecResult[ 2 ] * 2.55,\n\t\t\t\t\texecResult[ 3 ] * 2.55,\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\t// this regex ignores A-F because it's compared against an already lowercased string\n\t\t\tre: /#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\tparseInt( execResult[ 1 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 2 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 3 ], 16 )\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\t// this regex ignores A-F because it's compared against an already lowercased string\n\t\t\tre: /#([a-f0-9])([a-f0-9])([a-f0-9])/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\tparseInt( execResult[ 1 ] + execResult[ 1 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 2 ] + execResult[ 2 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 3 ] + execResult[ 3 ], 16 )\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\tre: /hsla?\\(\\s*(\\d+(?:\\.\\d+)?)\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d+(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tspace: \"hsla\",\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ],\n\t\t\t\t\texecResult[ 2 ] / 100,\n\t\t\t\t\texecResult[ 3 ] / 100,\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t}],\n\n\t// jQuery.Color( )\n\tcolor = jQuery.Color = function( color, green, blue, alpha ) {\n\t\treturn new jQuery.Color.fn.parse( color, green, blue, alpha );\n\t},\n\tspaces = {\n\t\trgba: {\n\t\t\tprops: {\n\t\t\t\tred: {\n\t\t\t\t\tidx: 0,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t},\n\t\t\t\tgreen: {\n\t\t\t\t\tidx: 1,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t},\n\t\t\t\tblue: {\n\t\t\t\t\tidx: 2,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\thsla: {\n\t\t\tprops: {\n\t\t\t\thue: {\n\t\t\t\t\tidx: 0,\n\t\t\t\t\ttype: \"degrees\"\n\t\t\t\t},\n\t\t\t\tsaturation: {\n\t\t\t\t\tidx: 1,\n\t\t\t\t\ttype: \"percent\"\n\t\t\t\t},\n\t\t\t\tlightness: {\n\t\t\t\t\tidx: 2,\n\t\t\t\t\ttype: \"percent\"\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\tpropTypes = {\n\t\t\"byte\": {\n\t\t\tfloor: true,\n\t\t\tmax: 255\n\t\t},\n\t\t\"percent\": {\n\t\t\tmax: 1\n\t\t},\n\t\t\"degrees\": {\n\t\t\tmod: 360,\n\t\t\tfloor: true\n\t\t}\n\t},\n\tsupport = color.support = {},\n\n\t// element for support tests\n\tsupportElem = jQuery( \"<p>\" )[ 0 ],\n\n\t// colors = jQuery.Color.names\n\tcolors,\n\n\t// local aliases of functions called often\n\teach = jQuery.each;\n\n// determine rgba support immediately\nsupportElem.style.cssText = \"background-color:rgba(1,1,1,.5)\";\nsupport.rgba = supportElem.style.backgroundColor.indexOf( \"rgba\" ) > -1;\n\n// define cache name and alpha properties\n// for rgba and hsla spaces\neach( spaces, function( spaceName, space ) {\n\tspace.cache = \"_\" + spaceName;\n\tspace.props.alpha = {\n\t\tidx: 3,\n\t\ttype: \"percent\",\n\t\tdef: 1\n\t};\n});\n\nfunction clamp( value, prop, allowEmpty ) {\n\tvar type = propTypes[ prop.type ] || {};\n\n\tif ( value == null ) {\n\t\treturn (allowEmpty || !prop.def) ? null : prop.def;\n\t}\n\n\t// ~~ is an short way of doing floor for positive numbers\n\tvalue = type.floor ? ~~value : parseFloat( value );\n\n\t// IE will pass in empty strings as value for alpha,\n\t// which will hit this case\n\tif ( isNaN( value ) ) {\n\t\treturn prop.def;\n\t}\n\n\tif ( type.mod ) {\n\t\t// we add mod before modding to make sure that negatives values\n\t\t// get converted properly: -10 -> 350\n\t\treturn (value + type.mod) % type.mod;\n\t}\n\n\t// for now all property types without mod have min and max\n\treturn 0 > value ? 0 : type.max < value ? type.max : value;\n}\n\nfunction stringParse( string ) {\n\tvar inst = color(),\n\t\trgba = inst._rgba = [];\n\n\tstring = string.toLowerCase();\n\n\teach( stringParsers, function( i, parser ) {\n\t\tvar parsed,\n\t\t\tmatch = parser.re.exec( string ),\n\t\t\tvalues = match && parser.parse( match ),\n\t\t\tspaceName = parser.space || \"rgba\";\n\n\t\tif ( values ) {\n\t\t\tparsed = inst[ spaceName ]( values );\n\n\t\t\t// if this was an rgba parse the assignment might happen twice\n\t\t\t// oh well....\n\t\t\tinst[ spaces[ spaceName ].cache ] = parsed[ spaces[ spaceName ].cache ];\n\t\t\trgba = inst._rgba = parsed._rgba;\n\n\t\t\t// exit each( stringParsers ) here because we matched\n\t\t\treturn false;\n\t\t}\n\t});\n\n\t// Found a stringParser that handled it\n\tif ( rgba.length ) {\n\n\t\t// if this came from a parsed string, force \"transparent\" when alpha is 0\n\t\t// chrome, (and maybe others) return \"transparent\" as rgba(0,0,0,0)\n\t\tif ( rgba.join() === \"0,0,0,0\" ) {\n\t\t\tjQuery.extend( rgba, colors.transparent );\n\t\t}\n\t\treturn inst;\n\t}\n\n\t// named colors\n\treturn colors[ string ];\n}\n\ncolor.fn = jQuery.extend( color.prototype, {\n\tparse: function( red, green, blue, alpha ) {\n\t\tif ( red === undefined ) {\n\t\t\tthis._rgba = [ null, null, null, null ];\n\t\t\treturn this;\n\t\t}\n\t\tif ( red.jquery || red.nodeType ) {\n\t\t\tred = jQuery( red ).css( green );\n\t\t\tgreen = undefined;\n\t\t}\n\n\t\tvar inst = this,\n\t\t\ttype = jQuery.type( red ),\n\t\t\trgba = this._rgba = [];\n\n\t\t// more than 1 argument specified - assume ( red, green, blue, alpha )\n\t\tif ( green !== undefined ) {\n\t\t\tred = [ red, green, blue, alpha ];\n\t\t\ttype = \"array\";\n\t\t}\n\n\t\tif ( type === \"string\" ) {\n\t\t\treturn this.parse( stringParse( red ) || colors._default );\n\t\t}\n\n\t\tif ( type === \"array\" ) {\n\t\t\teach( spaces.rgba.props, function( key, prop ) {\n\t\t\t\trgba[ prop.idx ] = clamp( red[ prop.idx ], prop );\n\t\t\t});\n\t\t\treturn this;\n\t\t}\n\n\t\tif ( type === \"object\" ) {\n\t\t\tif ( red instanceof color ) {\n\t\t\t\teach( spaces, function( spaceName, space ) {\n\t\t\t\t\tif ( red[ space.cache ] ) {\n\t\t\t\t\t\tinst[ space.cache ] = red[ space.cache ].slice();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\teach( spaces, function( spaceName, space ) {\n\t\t\t\t\tvar cache = space.cache;\n\t\t\t\t\teach( space.props, function( key, prop ) {\n\n\t\t\t\t\t\t// if the cache doesn't exist, and we know how to convert\n\t\t\t\t\t\tif ( !inst[ cache ] && space.to ) {\n\n\t\t\t\t\t\t\t// if the value was null, we don't need to copy it\n\t\t\t\t\t\t\t// if the key was alpha, we don't need to copy it either\n\t\t\t\t\t\t\tif ( key === \"alpha\" || red[ key ] == null ) {\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tinst[ cache ] = space.to( inst._rgba );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// this is the only case where we allow nulls for ALL properties.\n\t\t\t\t\t\t// call clamp with alwaysAllowEmpty\n\t\t\t\t\t\tinst[ cache ][ prop.idx ] = clamp( red[ key ], prop, true );\n\t\t\t\t\t});\n\n\t\t\t\t\t// everything defined but alpha?\n\t\t\t\t\tif ( inst[ cache ] && $.inArray( null, inst[ cache ].slice( 0, 3 ) ) < 0 ) {\n\t\t\t\t\t\t// use the default of 1\n\t\t\t\t\t\tinst[ cache ][ 3 ] = 1;\n\t\t\t\t\t\tif ( space.from ) {\n\t\t\t\t\t\t\tinst._rgba = space.from( inst[ cache ] );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t\treturn this;\n\t\t}\n\t},\n\tis: function( compare ) {\n\t\tvar is = color( compare ),\n\t\t\tsame = true,\n\t\t\tinst = this;\n\n\t\teach( spaces, function( _, space ) {\n\t\t\tvar localCache,\n\t\t\t\tisCache = is[ space.cache ];\n\t\t\tif (isCache) {\n\t\t\t\tlocalCache = inst[ space.cache ] || space.to && space.to( inst._rgba ) || [];\n\t\t\t\teach( space.props, function( _, prop ) {\n\t\t\t\t\tif ( isCache[ prop.idx ] != null ) {\n\t\t\t\t\t\tsame = ( isCache[ prop.idx ] === localCache[ prop.idx ] );\n\t\t\t\t\t\treturn same;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t\treturn same;\n\t\t});\n\t\treturn same;\n\t},\n\t_space: function() {\n\t\tvar used = [],\n\t\t\tinst = this;\n\t\teach( spaces, function( spaceName, space ) {\n\t\t\tif ( inst[ space.cache ] ) {\n\t\t\t\tused.push( spaceName );\n\t\t\t}\n\t\t});\n\t\treturn used.pop();\n\t},\n\ttransition: function( other, distance ) {\n\t\tvar end = color( other ),\n\t\t\tspaceName = end._space(),\n\t\t\tspace = spaces[ spaceName ],\n\t\t\tstartColor = this.alpha() === 0 ? color( \"transparent\" ) : this,\n\t\t\tstart = startColor[ space.cache ] || space.to( startColor._rgba ),\n\t\t\tresult = start.slice();\n\n\t\tend = end[ space.cache ];\n\t\teach( space.props, function( key, prop ) {\n\t\t\tvar index = prop.idx,\n\t\t\t\tstartValue = start[ index ],\n\t\t\t\tendValue = end[ index ],\n\t\t\t\ttype = propTypes[ prop.type ] || {};\n\n\t\t\t// if null, don't override start value\n\t\t\tif ( endValue === null ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\t// if null - use end\n\t\t\tif ( startValue === null ) {\n\t\t\t\tresult[ index ] = endValue;\n\t\t\t} else {\n\t\t\t\tif ( type.mod ) {\n\t\t\t\t\tif ( endValue - startValue > type.mod / 2 ) {\n\t\t\t\t\t\tstartValue += type.mod;\n\t\t\t\t\t} else if ( startValue - endValue > type.mod / 2 ) {\n\t\t\t\t\t\tstartValue -= type.mod;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tresult[ index ] = clamp( ( endValue - startValue ) * distance + startValue, prop );\n\t\t\t}\n\t\t});\n\t\treturn this[ spaceName ]( result );\n\t},\n\tblend: function( opaque ) {\n\t\t// if we are already opaque - return ourself\n\t\tif ( this._rgba[ 3 ] === 1 ) {\n\t\t\treturn this;\n\t\t}\n\n\t\tvar rgb = this._rgba.slice(),\n\t\t\ta = rgb.pop(),\n\t\t\tblend = color( opaque )._rgba;\n\n\t\treturn color( jQuery.map( rgb, function( v, i ) {\n\t\t\treturn ( 1 - a ) * blend[ i ] + a * v;\n\t\t}));\n\t},\n\ttoRgbaString: function() {\n\t\tvar prefix = \"rgba(\",\n\t\t\trgba = jQuery.map( this._rgba, function( v, i ) {\n\t\t\t\treturn v == null ? ( i > 2 ? 1 : 0 ) : v;\n\t\t\t});\n\n\t\tif ( rgba[ 3 ] === 1 ) {\n\t\t\trgba.pop();\n\t\t\tprefix = \"rgb(\";\n\t\t}\n\n\t\treturn prefix + rgba.join() + \")\";\n\t},\n\ttoHslaString: function() {\n\t\tvar prefix = \"hsla(\",\n\t\t\thsla = jQuery.map( this.hsla(), function( v, i ) {\n\t\t\t\tif ( v == null ) {\n\t\t\t\t\tv = i > 2 ? 1 : 0;\n\t\t\t\t}\n\n\t\t\t\t// catch 1 and 2\n\t\t\t\tif ( i && i < 3 ) {\n\t\t\t\t\tv = Math.round( v * 100 ) + \"%\";\n\t\t\t\t}\n\t\t\t\treturn v;\n\t\t\t});\n\n\t\tif ( hsla[ 3 ] === 1 ) {\n\t\t\thsla.pop();\n\t\t\tprefix = \"hsl(\";\n\t\t}\n\t\treturn prefix + hsla.join() + \")\";\n\t},\n\ttoHexString: function( includeAlpha ) {\n\t\tvar rgba = this._rgba.slice(),\n\t\t\talpha = rgba.pop();\n\n\t\tif ( includeAlpha ) {\n\t\t\trgba.push( ~~( alpha * 255 ) );\n\t\t}\n\n\t\treturn \"#\" + jQuery.map( rgba, function( v ) {\n\n\t\t\t// default to 0 when nulls exist\n\t\t\tv = ( v || 0 ).toString( 16 );\n\t\t\treturn v.length === 1 ? \"0\" + v : v;\n\t\t}).join(\"\");\n\t},\n\ttoString: function() {\n\t\treturn this._rgba[ 3 ] === 0 ? \"transparent\" : this.toRgbaString();\n\t}\n});\ncolor.fn.parse.prototype = color.fn;\n\n// hsla conversions adapted from:\n// https://code.google.com/p/maashaack/source/browse/packages/graphics/trunk/src/graphics/colors/HUE2RGB.as?r=5021\n\nfunction hue2rgb( p, q, h ) {\n\th = ( h + 1 ) % 1;\n\tif ( h * 6 < 1 ) {\n\t\treturn p + (q - p) * h * 6;\n\t}\n\tif ( h * 2 < 1) {\n\t\treturn q;\n\t}\n\tif ( h * 3 < 2 ) {\n\t\treturn p + (q - p) * ((2/3) - h) * 6;\n\t}\n\treturn p;\n}\n\nspaces.hsla.to = function ( rgba ) {\n\tif ( rgba[ 0 ] == null || rgba[ 1 ] == null || rgba[ 2 ] == null ) {\n\t\treturn [ null, null, null, rgba[ 3 ] ];\n\t}\n\tvar r = rgba[ 0 ] / 255,\n\t\tg = rgba[ 1 ] / 255,\n\t\tb = rgba[ 2 ] / 255,\n\t\ta = rgba[ 3 ],\n\t\tmax = Math.max( r, g, b ),\n\t\tmin = Math.min( r, g, b ),\n\t\tdiff = max - min,\n\t\tadd = max + min,\n\t\tl = add * 0.5,\n\t\th, s;\n\n\tif ( min === max ) {\n\t\th = 0;\n\t} else if ( r === max ) {\n\t\th = ( 60 * ( g - b ) / diff ) + 360;\n\t} else if ( g === max ) {\n\t\th = ( 60 * ( b - r ) / diff ) + 120;\n\t} else {\n\t\th = ( 60 * ( r - g ) / diff ) + 240;\n\t}\n\n\tif ( l === 0 || l === 1 ) {\n\t\ts = l;\n\t} else if ( l <= 0.5 ) {\n\t\ts = diff / add;\n\t} else {\n\t\ts = diff / ( 2 - add );\n\t}\n\treturn [ Math.round(h) % 360, s, l, a == null ? 1 : a ];\n};\n\nspaces.hsla.from = function ( hsla ) {\n\tif ( hsla[ 0 ] == null || hsla[ 1 ] == null || hsla[ 2 ] == null ) {\n\t\treturn [ null, null, null, hsla[ 3 ] ];\n\t}\n\tvar h = hsla[ 0 ] / 360,\n\t\ts = hsla[ 1 ],\n\t\tl = hsla[ 2 ],\n\t\ta = hsla[ 3 ],\n\t\tq = l <= 0.5 ? l * ( 1 + s ) : l + s - l * s,\n\t\tp = 2 * l - q;\n\n\treturn [\n\t\tMath.round( hue2rgb( p, q, h + ( 1 / 3 ) ) * 255 ),\n\t\tMath.round( hue2rgb( p, q, h ) * 255 ),\n\t\tMath.round( hue2rgb( p, q, h - ( 1 / 3 ) ) * 255 ),\n\t\ta\n\t];\n};\n\n\neach( spaces, function( spaceName, space ) {\n\tvar props = space.props,\n\t\tcache = space.cache,\n\t\tto = space.to,\n\t\tfrom = space.from;\n\n\t// makes rgba() and hsla()\n\tcolor.fn[ spaceName ] = function( value ) {\n\n\t\t// generate a cache for this space if it doesn't exist\n\t\tif ( to && !this[ cache ] ) {\n\t\t\tthis[ cache ] = to( this._rgba );\n\t\t}\n\t\tif ( value === undefined ) {\n\t\t\treturn this[ cache ].slice();\n\t\t}\n\n\t\tvar ret,\n\t\t\ttype = jQuery.type( value ),\n\t\t\tarr = ( type === \"array\" || type === \"object\" ) ? value : arguments,\n\t\t\tlocal = this[ cache ].slice();\n\n\t\teach( props, function( key, prop ) {\n\t\t\tvar val = arr[ type === \"object\" ? key : prop.idx ];\n\t\t\tif ( val == null ) {\n\t\t\t\tval = local[ prop.idx ];\n\t\t\t}\n\t\t\tlocal[ prop.idx ] = clamp( val, prop );\n\t\t});\n\n\t\tif ( from ) {\n\t\t\tret = color( from( local ) );\n\t\t\tret[ cache ] = local;\n\t\t\treturn ret;\n\t\t} else {\n\t\t\treturn color( local );\n\t\t}\n\t};\n\n\t// makes red() green() blue() alpha() hue() saturation() lightness()\n\teach( props, function( key, prop ) {\n\t\t// alpha is included in more than one space\n\t\tif ( color.fn[ key ] ) {\n\t\t\treturn;\n\t\t}\n\t\tcolor.fn[ key ] = function( value ) {\n\t\t\tvar vtype = jQuery.type( value ),\n\t\t\t\tfn = ( key === \"alpha\" ? ( this._hsla ? \"hsla\" : \"rgba\" ) : spaceName ),\n\t\t\t\tlocal = this[ fn ](),\n\t\t\t\tcur = local[ prop.idx ],\n\t\t\t\tmatch;\n\n\t\t\tif ( vtype === \"undefined\" ) {\n\t\t\t\treturn cur;\n\t\t\t}\n\n\t\t\tif ( vtype === \"function\" ) {\n\t\t\t\tvalue = value.call( this, cur );\n\t\t\t\tvtype = jQuery.type( value );\n\t\t\t}\n\t\t\tif ( value == null && prop.empty ) {\n\t\t\t\treturn this;\n\t\t\t}\n\t\t\tif ( vtype === \"string\" ) {\n\t\t\t\tmatch = rplusequals.exec( value );\n\t\t\t\tif ( match ) {\n\t\t\t\t\tvalue = cur + parseFloat( match[ 2 ] ) * ( match[ 1 ] === \"+\" ? 1 : -1 );\n\t\t\t\t}\n\t\t\t}\n\t\t\tlocal[ prop.idx ] = value;\n\t\t\treturn this[ fn ]( local );\n\t\t};\n\t});\n});\n\n// add .fx.step functions\neach( stepHooks, function( i, hook ) {\n\tjQuery.cssHooks[ hook ] = {\n\t\tset: function( elem, value ) {\n\t\t\tvar parsed, curElem,\n\t\t\t\tbackgroundColor = \"\";\n\n\t\t\tif ( jQuery.type( value ) !== \"string\" || ( parsed = stringParse( value ) ) ) {\n\t\t\t\tvalue = color( parsed || value );\n\t\t\t\tif ( !support.rgba && value._rgba[ 3 ] !== 1 ) {\n\t\t\t\t\tcurElem = hook === \"backgroundColor\" ? elem.parentNode : elem;\n\t\t\t\t\twhile (\n\t\t\t\t\t\t(backgroundColor === \"\" || backgroundColor === \"transparent\") &&\n\t\t\t\t\t\tcurElem && curElem.style\n\t\t\t\t\t) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tbackgroundColor = jQuery.css( curElem, \"backgroundColor\" );\n\t\t\t\t\t\t\tcurElem = curElem.parentNode;\n\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tvalue = value.blend( backgroundColor && backgroundColor !== \"transparent\" ?\n\t\t\t\t\t\tbackgroundColor :\n\t\t\t\t\t\t\"_default\" );\n\t\t\t\t}\n\n\t\t\t\tvalue = value.toRgbaString();\n\t\t\t}\n\t\t\ttry {\n\t\t\t\telem.style[ hook ] = value;\n\t\t\t} catch( error ) {\n\t\t\t\t// wrapped to prevent IE from throwing errors on \"invalid\" values like 'auto' or 'inherit'\n\t\t\t}\n\t\t}\n\t};\n\tjQuery.fx.step[ hook ] = function( fx ) {\n\t\tif ( !fx.colorInit ) {\n\t\t\tfx.start = color( fx.elem, hook );\n\t\t\tfx.end = color( fx.end );\n\t\t\tfx.colorInit = true;\n\t\t}\n\t\tjQuery.cssHooks[ hook ].set( fx.elem, fx.start.transition( fx.end, fx.pos ) );\n\t};\n});\n\njQuery.cssHooks.borderColor = {\n\texpand: function( value ) {\n\t\tvar expanded = {};\n\n\t\teach( [ \"Top\", \"Right\", \"Bottom\", \"Left\" ], function( i, part ) {\n\t\t\texpanded[ \"border\" + part + \"Color\" ] = value;\n\t\t});\n\t\treturn expanded;\n\t}\n};\n\n// Basic color names only.\n// Usage of any of the other color names requires adding yourself or including\n// jquery.color.svg-names.js.\ncolors = jQuery.Color.names = {\n\t// 4.1. Basic color keywords\n\taqua: \"#00ffff\",\n\tblack: \"#000000\",\n\tblue: \"#0000ff\",\n\tfuchsia: \"#ff00ff\",\n\tgray: \"#808080\",\n\tgreen: \"#008000\",\n\tlime: \"#00ff00\",\n\tmaroon: \"#800000\",\n\tnavy: \"#000080\",\n\tolive: \"#808000\",\n\tpurple: \"#800080\",\n\tred: \"#ff0000\",\n\tsilver: \"#c0c0c0\",\n\tteal: \"#008080\",\n\twhite: \"#ffffff\",\n\tyellow: \"#ffff00\",\n\n\t// 4.2.3. \"transparent\" color keyword\n\ttransparent: [ null, null, null, 0 ],\n\n\t_default: \"#ffffff\"\n};\n\n})( jQuery );\n\n\n\n/******************************************************************************/\n/****************************** CLASS ANIMATIONS ******************************/\n/******************************************************************************/\n(function() {\n\nvar classAnimationActions = [ \"add\", \"remove\", \"toggle\" ],\n\tshorthandStyles = {\n\t\tborder: 1,\n\t\tborderBottom: 1,\n\t\tborderColor: 1,\n\t\tborderLeft: 1,\n\t\tborderRight: 1,\n\t\tborderTop: 1,\n\t\tborderWidth: 1,\n\t\tmargin: 1,\n\t\tpadding: 1\n\t};\n\n$.each([ \"borderLeftStyle\", \"borderRightStyle\", \"borderBottomStyle\", \"borderTopStyle\" ], function( _, prop ) {\n\t$.fx.step[ prop ] = function( fx ) {\n\t\tif ( fx.end !== \"none\" && !fx.setAttr || fx.pos === 1 && !fx.setAttr ) {\n\t\t\tjQuery.style( fx.elem, prop, fx.end );\n\t\t\tfx.setAttr = true;\n\t\t}\n\t};\n});\n\nfunction getElementStyles() {\n\tvar style = this.ownerDocument.defaultView ?\n\t\t\tthis.ownerDocument.defaultView.getComputedStyle( this, null ) :\n\t\t\tthis.currentStyle,\n\t\tnewStyle = {},\n\t\tkey,\n\t\tlen;\n\n\t// webkit enumerates style porperties\n\tif ( style && style.length && style[ 0 ] && style[ style[ 0 ] ] ) {\n\t\tlen = style.length;\n\t\twhile ( len-- ) {\n\t\t\tkey = style[ len ];\n\t\t\tif ( typeof style[ key ] === \"string\" ) {\n\t\t\t\tnewStyle[ $.camelCase( key ) ] = style[ key ];\n\t\t\t}\n\t\t}\n\t} else {\n\t\tfor ( key in style ) {\n\t\t\tif ( typeof style[ key ] === \"string\" ) {\n\t\t\t\tnewStyle[ key ] = style[ key ];\n\t\t\t}\n\t\t}\n\t}\n\n\treturn newStyle;\n}\n\n\nfunction styleDifference( oldStyle, newStyle ) {\n\tvar diff = {},\n\t\tname, value;\n\n\tfor ( name in newStyle ) {\n\t\tvalue = newStyle[ name ];\n\t\tif ( oldStyle[ name ] !== value ) {\n\t\t\tif ( !shorthandStyles[ name ] ) {\n\t\t\t\tif ( $.fx.step[ name ] || !isNaN( parseFloat( value ) ) ) {\n\t\t\t\t\tdiff[ name ] = value;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\treturn diff;\n}\n\n$.effects.animateClass = function( value, duration, easing, callback ) {\n\tvar o = $.speed( duration, easing, callback );\n\n\treturn this.queue( function() {\n\t\tvar animated = $( this ),\n\t\t\tbaseClass = animated.attr( \"class\" ) || \"\",\n\t\t\tapplyClassChange,\n\t\t\tallAnimations = o.children ? animated.find( \"*\" ).andSelf() : animated;\n\n\t\t// map the animated objects to store the original styles.\n\t\tallAnimations = allAnimations.map(function() {\n\t\t\tvar el = $( this );\n\t\t\treturn {\n\t\t\t\tel: el,\n\t\t\t\tstart: getElementStyles.call( this )\n\t\t\t};\n\t\t});\n\n\t\t// apply class change\n\t\tapplyClassChange = function() {\n\t\t\t$.each( classAnimationActions, function(i, action) {\n\t\t\t\tif ( value[ action ] ) {\n\t\t\t\t\tanimated[ action + \"Class\" ]( value[ action ] );\n\t\t\t\t}\n\t\t\t});\n\t\t};\n\t\tapplyClassChange();\n\n\t\t// map all animated objects again - calculate new styles and diff\n\t\tallAnimations = allAnimations.map(function() {\n\t\t\tthis.end = getElementStyles.call( this.el[ 0 ] );\n\t\t\tthis.diff = styleDifference( this.start, this.end );\n\t\t\treturn this;\n\t\t});\n\n\t\t// apply original class\n\t\tanimated.attr( \"class\", baseClass );\n\n\t\t// map all animated objects again - this time collecting a promise\n\t\tallAnimations = allAnimations.map(function() {\n\t\t\tvar styleInfo = this,\n\t\t\t\tdfd = $.Deferred(),\n\t\t\t\topts = jQuery.extend({}, o, {\n\t\t\t\t\tqueue: false,\n\t\t\t\t\tcomplete: function() {\n\t\t\t\t\t\tdfd.resolve( styleInfo );\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\tthis.el.animate( this.diff, opts );\n\t\t\treturn dfd.promise();\n\t\t});\n\n\t\t// once all animations have completed:\n\t\t$.when.apply( $, allAnimations.get() ).done(function() {\n\n\t\t\t// set the final class\n\t\t\tapplyClassChange();\n\n\t\t\t// for each animated element,\n\t\t\t// clear all css properties that were animated\n\t\t\t$.each( arguments, function() {\n\t\t\t\tvar el = this.el;\n\t\t\t\t$.each( this.diff, function(key) {\n\t\t\t\t\tel.css( key, '' );\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// this is guarnteed to be there if you use jQuery.speed()\n\t\t\t// it also handles dequeuing the next anim...\n\t\t\to.complete.call( animated[ 0 ] );\n\t\t});\n\t});\n};\n\n$.fn.extend({\n\t_addClass: $.fn.addClass,\n\taddClass: function( classNames, speed, easing, callback ) {\n\t\treturn speed ?\n\t\t\t$.effects.animateClass.call( this,\n\t\t\t\t{ add: classNames }, speed, easing, callback ) :\n\t\t\tthis._addClass( classNames );\n\t},\n\n\t_removeClass: $.fn.removeClass,\n\tremoveClass: function( classNames, speed, easing, callback ) {\n\t\treturn speed ?\n\t\t\t$.effects.animateClass.call( this,\n\t\t\t\t{ remove: classNames }, speed, easing, callback ) :\n\t\t\tthis._removeClass( classNames );\n\t},\n\n\t_toggleClass: $.fn.toggleClass,\n\ttoggleClass: function( classNames, force, speed, easing, callback ) {\n\t\tif ( typeof force === \"boolean\" || force === undefined ) {\n\t\t\tif ( !speed ) {\n\t\t\t\t// without speed parameter\n\t\t\t\treturn this._toggleClass( classNames, force );\n\t\t\t} else {\n\t\t\t\treturn $.effects.animateClass.call( this,\n\t\t\t\t\t(force ? { add: classNames } : { remove: classNames }),\n\t\t\t\t\tspeed, easing, callback );\n\t\t\t}\n\t\t} else {\n\t\t\t// without force parameter\n\t\t\treturn $.effects.animateClass.call( this,\n\t\t\t\t{ toggle: classNames }, force, speed, easing );\n\t\t}\n\t},\n\n\tswitchClass: function( remove, add, speed, easing, callback) {\n\t\treturn $.effects.animateClass.call( this, {\n\t\t\tadd: add,\n\t\t\tremove: remove\n\t\t}, speed, easing, callback );\n\t}\n});\n\n})();\n\n/******************************************************************************/\n/*********************************** EFFECTS **********************************/\n/******************************************************************************/\n\n(function() {\n\n$.extend( $.effects, {\n\tversion: \"1.9.2\",\n\n\t// Saves a set of properties in a data storage\n\tsave: function( element, set ) {\n\t\tfor( var i=0; i < set.length; i++ ) {\n\t\t\tif ( set[ i ] !== null ) {\n\t\t\t\telement.data( dataSpace + set[ i ], element[ 0 ].style[ set[ i ] ] );\n\t\t\t}\n\t\t}\n\t},\n\n\t// Restores a set of previously saved properties from a data storage\n\trestore: function( element, set ) {\n\t\tvar val, i;\n\t\tfor( i=0; i < set.length; i++ ) {\n\t\t\tif ( set[ i ] !== null ) {\n\t\t\t\tval = element.data( dataSpace + set[ i ] );\n\t\t\t\t// support: jQuery 1.6.2\n\t\t\t\t// http://bugs.jquery.com/ticket/9917\n\t\t\t\t// jQuery 1.6.2 incorrectly returns undefined for any falsy value.\n\t\t\t\t// We can't differentiate between \"\" and 0 here, so we just assume\n\t\t\t\t// empty string since it's likely to be a more common value...\n\t\t\t\tif ( val === undefined ) {\n\t\t\t\t\tval = \"\";\n\t\t\t\t}\n\t\t\t\telement.css( set[ i ], val );\n\t\t\t}\n\t\t}\n\t},\n\n\tsetMode: function( el, mode ) {\n\t\tif (mode === \"toggle\") {\n\t\t\tmode = el.is( \":hidden\" ) ? \"show\" : \"hide\";\n\t\t}\n\t\treturn mode;\n\t},\n\n\t// Translates a [top,left] array into a baseline value\n\t// this should be a little more flexible in the future to handle a string & hash\n\tgetBaseline: function( origin, original ) {\n\t\tvar y, x;\n\t\tswitch ( origin[ 0 ] ) {\n\t\t\tcase \"top\": y = 0; break;\n\t\t\tcase \"middle\": y = 0.5; break;\n\t\t\tcase \"bottom\": y = 1; break;\n\t\t\tdefault: y = origin[ 0 ] / original.height;\n\t\t}\n\t\tswitch ( origin[ 1 ] ) {\n\t\t\tcase \"left\": x = 0; break;\n\t\t\tcase \"center\": x = 0.5; break;\n\t\t\tcase \"right\": x = 1; break;\n\t\t\tdefault: x = origin[ 1 ] / original.width;\n\t\t}\n\t\treturn {\n\t\t\tx: x,\n\t\t\ty: y\n\t\t};\n\t},\n\n\t// Wraps the element around a wrapper that copies position properties\n\tcreateWrapper: function( element ) {\n\n\t\t// if the element is already wrapped, return it\n\t\tif ( element.parent().is( \".ui-effects-wrapper\" )) {\n\t\t\treturn element.parent();\n\t\t}\n\n\t\t// wrap the element\n\t\tvar props = {\n\t\t\t\twidth: element.outerWidth(true),\n\t\t\t\theight: element.outerHeight(true),\n\t\t\t\t\"float\": element.css( \"float\" )\n\t\t\t},\n\t\t\twrapper = $( \"<div></div>\" )\n\t\t\t\t.addClass( \"ui-effects-wrapper\" )\n\t\t\t\t.css({\n\t\t\t\t\tfontSize: \"100%\",\n\t\t\t\t\tbackground: \"transparent\",\n\t\t\t\t\tborder: \"none\",\n\t\t\t\t\tmargin: 0,\n\t\t\t\t\tpadding: 0\n\t\t\t\t}),\n\t\t\t// Store the size in case width/height are defined in % - Fixes #5245\n\t\t\tsize = {\n\t\t\t\twidth: element.width(),\n\t\t\t\theight: element.height()\n\t\t\t},\n\t\t\tactive = document.activeElement;\n\n\t\t// support: Firefox\n\t\t// Firefox incorrectly exposes anonymous content\n\t\t// https://bugzilla.mozilla.org/show_bug.cgi?id=561664\n\t\ttry {\n\t\t\tactive.id;\n\t\t} catch( e ) {\n\t\t\tactive = document.body;\n\t\t}\n\n\t\telement.wrap( wrapper );\n\n\t\t// Fixes #7595 - Elements lose focus when wrapped.\n\t\tif ( element[ 0 ] === active || $.contains( element[ 0 ], active ) ) {\n\t\t\t$( active ).focus();\n\t\t}\n\n\t\twrapper = element.parent(); //Hotfix for jQuery 1.4 since some change in wrap() seems to actually lose the reference to the wrapped element\n\n\t\t// transfer positioning properties to the wrapper\n\t\tif ( element.css( \"position\" ) === \"static\" ) {\n\t\t\twrapper.css({ position: \"relative\" });\n\t\t\telement.css({ position: \"relative\" });\n\t\t} else {\n\t\t\t$.extend( props, {\n\t\t\t\tposition: element.css( \"position\" ),\n\t\t\t\tzIndex: element.css( \"z-index\" )\n\t\t\t});\n\t\t\t$.each([ \"top\", \"left\", \"bottom\", \"right\" ], function(i, pos) {\n\t\t\t\tprops[ pos ] = element.css( pos );\n\t\t\t\tif ( isNaN( parseInt( props[ pos ], 10 ) ) ) {\n\t\t\t\t\tprops[ pos ] = \"auto\";\n\t\t\t\t}\n\t\t\t});\n\t\t\telement.css({\n\t\t\t\tposition: \"relative\",\n\t\t\t\ttop: 0,\n\t\t\t\tleft: 0,\n\t\t\t\tright: \"auto\",\n\t\t\t\tbottom: \"auto\"\n\t\t\t});\n\t\t}\n\t\telement.css(size);\n\n\t\treturn wrapper.css( props ).show();\n\t},\n\n\tremoveWrapper: function( element ) {\n\t\tvar active = document.activeElement;\n\n\t\tif ( element.parent().is( \".ui-effects-wrapper\" ) ) {\n\t\t\telement.parent().replaceWith( element );\n\n\t\t\t// Fixes #7595 - Elements lose focus when wrapped.\n\t\t\tif ( element[ 0 ] === active || $.contains( element[ 0 ], active ) ) {\n\t\t\t\t$( active ).focus();\n\t\t\t}\n\t\t}\n\n\n\t\treturn element;\n\t},\n\n\tsetTransition: function( element, list, factor, value ) {\n\t\tvalue = value || {};\n\t\t$.each( list, function( i, x ) {\n\t\t\tvar unit = element.cssUnit( x );\n\t\t\tif ( unit[ 0 ] > 0 ) {\n\t\t\t\tvalue[ x ] = unit[ 0 ] * factor + unit[ 1 ];\n\t\t\t}\n\t\t});\n\t\treturn value;\n\t}\n});\n\n// return an effect options object for the given parameters:\nfunction _normalizeArguments( effect, options, speed, callback ) {\n\n\t// allow passing all options as the first parameter\n\tif ( $.isPlainObject( effect ) ) {\n\t\toptions = effect;\n\t\teffect = effect.effect;\n\t}\n\n\t// convert to an object\n\teffect = { effect: effect };\n\n\t// catch (effect, null, ...)\n\tif ( options == null ) {\n\t\toptions = {};\n\t}\n\n\t// catch (effect, callback)\n\tif ( $.isFunction( options ) ) {\n\t\tcallback = options;\n\t\tspeed = null;\n\t\toptions = {};\n\t}\n\n\t// catch (effect, speed, ?)\n\tif ( typeof options === \"number\" || $.fx.speeds[ options ] ) {\n\t\tcallback = speed;\n\t\tspeed = options;\n\t\toptions = {};\n\t}\n\n\t// catch (effect, options, callback)\n\tif ( $.isFunction( speed ) ) {\n\t\tcallback = speed;\n\t\tspeed = null;\n\t}\n\n\t// add options to effect\n\tif ( options ) {\n\t\t$.extend( effect, options );\n\t}\n\n\tspeed = speed || options.duration;\n\teffect.duration = $.fx.off ? 0 :\n\t\ttypeof speed === \"number\" ? speed :\n\t\tspeed in $.fx.speeds ? $.fx.speeds[ speed ] :\n\t\t$.fx.speeds._default;\n\n\teffect.complete = callback || options.complete;\n\n\treturn effect;\n}\n\nfunction standardSpeed( speed ) {\n\t// valid standard speeds\n\tif ( !speed || typeof speed === \"number\" || $.fx.speeds[ speed ] ) {\n\t\treturn true;\n\t}\n\n\t// invalid strings - treat as \"normal\" speed\n\tif ( typeof speed === \"string\" && !$.effects.effect[ speed ] ) {\n\t\t// TODO: remove in 2.0 (#7115)\n\t\tif ( backCompat && $.effects[ speed ] ) {\n\t\t\treturn false;\n\t\t}\n\t\treturn true;\n\t}\n\n\treturn false;\n}\n\n$.fn.extend({\n\teffect: function( /* effect, options, speed, callback */ ) {\n\t\tvar args = _normalizeArguments.apply( this, arguments ),\n\t\t\tmode = args.mode,\n\t\t\tqueue = args.queue,\n\t\t\teffectMethod = $.effects.effect[ args.effect ],\n\n\t\t\t// DEPRECATED: remove in 2.0 (#7115)\n\t\t\toldEffectMethod = !effectMethod && backCompat && $.effects[ args.effect ];\n\n\t\tif ( $.fx.off || !( effectMethod || oldEffectMethod ) ) {\n\t\t\t// delegate to the original method (e.g., .show()) if possible\n\t\t\tif ( mode ) {\n\t\t\t\treturn this[ mode ]( args.duration, args.complete );\n\t\t\t} else {\n\t\t\t\treturn this.each( function() {\n\t\t\t\t\tif ( args.complete ) {\n\t\t\t\t\t\targs.complete.call( this );\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\n\t\tfunction run( next ) {\n\t\t\tvar elem = $( this ),\n\t\t\t\tcomplete = args.complete,\n\t\t\t\tmode = args.mode;\n\n\t\t\tfunction done() {\n\t\t\t\tif ( $.isFunction( complete ) ) {\n\t\t\t\t\tcomplete.call( elem[0] );\n\t\t\t\t}\n\t\t\t\tif ( $.isFunction( next ) ) {\n\t\t\t\t\tnext();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// if the element is hiddden and mode is hide,\n\t\t\t// or element is visible and mode is show\n\t\t\tif ( elem.is( \":hidden\" ) ? mode === \"hide\" : mode === \"show\" ) {\n\t\t\t\tdone();\n\t\t\t} else {\n\t\t\t\teffectMethod.call( elem[0], args, done );\n\t\t\t}\n\t\t}\n\n\t\t// TODO: remove this check in 2.0, effectMethod will always be true\n\t\tif ( effectMethod ) {\n\t\t\treturn queue === false ? this.each( run ) : this.queue( queue || \"fx\", run );\n\t\t} else {\n\t\t\t// DEPRECATED: remove in 2.0 (#7115)\n\t\t\treturn oldEffectMethod.call(this, {\n\t\t\t\toptions: args,\n\t\t\t\tduration: args.duration,\n\t\t\t\tcallback: args.complete,\n\t\t\t\tmode: args.mode\n\t\t\t});\n\t\t}\n\t},\n\n\t_show: $.fn.show,\n\tshow: function( speed ) {\n\t\tif ( standardSpeed( speed ) ) {\n\t\t\treturn this._show.apply( this, arguments );\n\t\t} else {\n\t\t\tvar args = _normalizeArguments.apply( this, arguments );\n\t\t\targs.mode = \"show\";\n\t\t\treturn this.effect.call( this, args );\n\t\t}\n\t},\n\n\t_hide: $.fn.hide,\n\thide: function( speed ) {\n\t\tif ( standardSpeed( speed ) ) {\n\t\t\treturn this._hide.apply( this, arguments );\n\t\t} else {\n\t\t\tvar args = _normalizeArguments.apply( this, arguments );\n\t\t\targs.mode = \"hide\";\n\t\t\treturn this.effect.call( this, args );\n\t\t}\n\t},\n\n\t// jQuery core overloads toggle and creates _toggle\n\t__toggle: $.fn.toggle,\n\ttoggle: function( speed ) {\n\t\tif ( standardSpeed( speed ) || typeof speed === \"boolean\" || $.isFunction( speed ) ) {\n\t\t\treturn this.__toggle.apply( this, arguments );\n\t\t} else {\n\t\t\tvar args = _normalizeArguments.apply( this, arguments );\n\t\t\targs.mode = \"toggle\";\n\t\t\treturn this.effect.call( this, args );\n\t\t}\n\t},\n\n\t// helper functions\n\tcssUnit: function(key) {\n\t\tvar style = this.css( key ),\n\t\t\tval = [];\n\n\t\t$.each( [ \"em\", \"px\", \"%\", \"pt\" ], function( i, unit ) {\n\t\t\tif ( style.indexOf( unit ) > 0 ) {\n\t\t\t\tval = [ parseFloat( style ), unit ];\n\t\t\t}\n\t\t});\n\t\treturn val;\n\t}\n});\n\n})();\n\n/******************************************************************************/\n/*********************************** EASING ***********************************/\n/******************************************************************************/\n\n(function() {\n\n// based on easing equations from Robert Penner (http://www.robertpenner.com/easing)\n\nvar baseEasings = {};\n\n$.each( [ \"Quad\", \"Cubic\", \"Quart\", \"Quint\", \"Expo\" ], function( i, name ) {\n\tbaseEasings[ name ] = function( p ) {\n\t\treturn Math.pow( p, i + 2 );\n\t};\n});\n\n$.extend( baseEasings, {\n\tSine: function ( p ) {\n\t\treturn 1 - Math.cos( p * Math.PI / 2 );\n\t},\n\tCirc: function ( p ) {\n\t\treturn 1 - Math.sqrt( 1 - p * p );\n\t},\n\tElastic: function( p ) {\n\t\treturn p === 0 || p === 1 ? p :\n\t\t\t-Math.pow( 2, 8 * (p - 1) ) * Math.sin( ( (p - 1) * 80 - 7.5 ) * Math.PI / 15 );\n\t},\n\tBack: function( p ) {\n\t\treturn p * p * ( 3 * p - 2 );\n\t},\n\tBounce: function ( p ) {\n\t\tvar pow2,\n\t\t\tbounce = 4;\n\n\t\twhile ( p < ( ( pow2 = Math.pow( 2, --bounce ) ) - 1 ) / 11 ) {}\n\t\treturn 1 / Math.pow( 4, 3 - bounce ) - 7.5625 * Math.pow( ( pow2 * 3 - 2 ) / 22 - p, 2 );\n\t}\n});\n\n$.each( baseEasings, function( name, easeIn ) {\n\t$.easing[ \"easeIn\" + name ] = easeIn;\n\t$.easing[ \"easeOut\" + name ] = function( p ) {\n\t\treturn 1 - easeIn( 1 - p );\n\t};\n\t$.easing[ \"easeInOut\" + name ] = function( p ) {\n\t\treturn p < 0.5 ?\n\t\t\teaseIn( p * 2 ) / 2 :\n\t\t\t1 - easeIn( p * -2 + 2 ) / 2;\n\t};\n});\n\n})();\n\n})(jQuery));\n\n(function( $, undefined ) {\n\nvar uid = 0,\n\thideProps = {},\n\tshowProps = {};\n\nhideProps.height = hideProps.paddingTop = hideProps.paddingBottom =\n\thideProps.borderTopWidth = hideProps.borderBottomWidth = \"hide\";\nshowProps.height = showProps.paddingTop = showProps.paddingBottom =\n\tshowProps.borderTopWidth = showProps.borderBottomWidth = \"show\";\n\n$.widget( \"ui.accordion\", {\n\tversion: \"1.9.2\",\n\toptions: {\n\t\tactive: 0,\n\t\tanimate: {},\n\t\tcollapsible: false,\n\t\tevent: \"click\",\n\t\theader: \"> li > :first-child,> :not(li):even\",\n\t\theightStyle: \"auto\",\n\t\ticons: {\n\t\t\tactiveHeader: \"ui-icon-triangle-1-s\",\n\t\t\theader: \"ui-icon-triangle-1-e\"\n\t\t},\n\n\t\t// callbacks\n\t\tactivate: null,\n\t\tbeforeActivate: null\n\t},\n\n\t_create: function() {\n\t\tvar accordionId = this.accordionId = \"ui-accordion-\" +\n\t\t\t\t(this.element.attr( \"id\" ) || ++uid),\n\t\t\toptions = this.options;\n\n\t\tthis.prevShow = this.prevHide = $();\n\t\tthis.element.addClass( \"ui-accordion ui-widget ui-helper-reset\" );\n\n\t\tthis.headers = this.element.find( options.header )\n\t\t\t.addClass( \"ui-accordion-header ui-helper-reset ui-state-default ui-corner-all\" );\n\t\tthis._hoverable( this.headers );\n\t\tthis._focusable( this.headers );\n\n\t\tthis.headers.next()\n\t\t\t.addClass( \"ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom\" )\n\t\t\t.hide();\n\n\t\t// don't allow collapsible: false and active: false / null\n\t\tif ( !options.collapsible && (options.active === false || options.active == null) ) {\n\t\t\toptions.active = 0;\n\t\t}\n\t\t// handle negative values\n\t\tif ( options.active < 0 ) {\n\t\t\toptions.active += this.headers.length;\n\t\t}\n\t\tthis.active = this._findActive( options.active )\n\t\t\t.addClass( \"ui-accordion-header-active ui-state-active\" )\n\t\t\t.toggleClass( \"ui-corner-all ui-corner-top\" );\n\t\tthis.active.next()\n\t\t\t.addClass( \"ui-accordion-content-active\" )\n\t\t\t.show();\n\n\t\tthis._createIcons();\n\t\tthis.refresh();\n\n\t\t// ARIA\n\t\tthis.element.attr( \"role\", \"tablist\" );\n\n\t\tthis.headers\n\t\t\t.attr( \"role\", \"tab\" )\n\t\t\t.each(function( i ) {\n\t\t\t\tvar header = $( this ),\n\t\t\t\t\theaderId = header.attr( \"id\" ),\n\t\t\t\t\tpanel = header.next(),\n\t\t\t\t\tpanelId = panel.attr( \"id\" );\n\t\t\t\tif ( !headerId ) {\n\t\t\t\t\theaderId = accordionId + \"-header-\" + i;\n\t\t\t\t\theader.attr( \"id\", headerId );\n\t\t\t\t}\n\t\t\t\tif ( !panelId ) {\n\t\t\t\t\tpanelId = accordionId + \"-panel-\" + i;\n\t\t\t\t\tpanel.attr( \"id\", panelId );\n\t\t\t\t}\n\t\t\t\theader.attr( \"aria-controls\", panelId );\n\t\t\t\tpanel.attr( \"aria-labelledby\", headerId );\n\t\t\t})\n\t\t\t.next()\n\t\t\t\t.attr( \"role\", \"tabpanel\" );\n\n\t\tthis.headers\n\t\t\t.not( this.active )\n\t\t\t.attr({\n\t\t\t\t\"aria-selected\": \"false\",\n\t\t\t\ttabIndex: -1\n\t\t\t})\n\t\t\t.next()\n\t\t\t\t.attr({\n\t\t\t\t\t\"aria-expanded\": \"false\",\n\t\t\t\t\t\"aria-hidden\": \"true\"\n\t\t\t\t})\n\t\t\t\t.hide();\n\n\t\t// make sure at least one header is in the tab order\n\t\tif ( !this.active.length ) {\n\t\t\tthis.headers.eq( 0 ).attr( \"tabIndex\", 0 );\n\t\t} else {\n\t\t\tthis.active.attr({\n\t\t\t\t\"aria-selected\": \"true\",\n\t\t\t\ttabIndex: 0\n\t\t\t})\n\t\t\t.next()\n\t\t\t\t.attr({\n\t\t\t\t\t\"aria-expanded\": \"true\",\n\t\t\t\t\t\"aria-hidden\": \"false\"\n\t\t\t\t});\n\t\t}\n\n\t\tthis._on( this.headers, { keydown: \"_keydown\" });\n\t\tthis._on( this.headers.next(), { keydown: \"_panelKeyDown\" });\n\t\tthis._setupEvents( options.event );\n\t},\n\n\t_getCreateEventData: function() {\n\t\treturn {\n\t\t\theader: this.active,\n\t\t\tcontent: !this.active.length ? $() : this.active.next()\n\t\t};\n\t},\n\n\t_createIcons: function() {\n\t\tvar icons = this.options.icons;\n\t\tif ( icons ) {\n\t\t\t$( \"<span>\" )\n\t\t\t\t.addClass( \"ui-accordion-header-icon ui-icon \" + icons.header )\n\t\t\t\t.prependTo( this.headers );\n\t\t\tthis.active.children( \".ui-accordion-header-icon\" )\n\t\t\t\t.removeClass( icons.header )\n\t\t\t\t.addClass( icons.activeHeader );\n\t\t\tthis.headers.addClass( \"ui-accordion-icons\" );\n\t\t}\n\t},\n\n\t_destroyIcons: function() {\n\t\tthis.headers\n\t\t\t.removeClass( \"ui-accordion-icons\" )\n\t\t\t.children( \".ui-accordion-header-icon\" )\n\t\t\t\t.remove();\n\t},\n\n\t_destroy: function() {\n\t\tvar contents;\n\n\t\t// clean up main element\n\t\tthis.element\n\t\t\t.removeClass( \"ui-accordion ui-widget ui-helper-reset\" )\n\t\t\t.removeAttr( \"role\" );\n\n\t\t// clean up headers\n\t\tthis.headers\n\t\t\t.removeClass( \"ui-accordion-header ui-accordion-header-active ui-helper-reset ui-state-default ui-corner-all ui-state-active ui-state-disabled ui-corner-top\" )\n\t\t\t.removeAttr( \"role\" )\n\t\t\t.removeAttr( \"aria-selected\" )\n\t\t\t.removeAttr( \"aria-controls\" )\n\t\t\t.removeAttr( \"tabIndex\" )\n\t\t\t.each(function() {\n\t\t\t\tif ( /^ui-accordion/.test( this.id ) ) {\n\t\t\t\t\tthis.removeAttribute( \"id\" );\n\t\t\t\t}\n\t\t\t});\n\t\tthis._destroyIcons();\n\n\t\t// clean up content panels\n\t\tcontents = this.headers.next()\n\t\t\t.css( \"display\", \"\" )\n\t\t\t.removeAttr( \"role\" )\n\t\t\t.removeAttr( \"aria-expanded\" )\n\t\t\t.removeAttr( \"aria-hidden\" )\n\t\t\t.removeAttr( \"aria-labelledby\" )\n\t\t\t.removeClass( \"ui-helper-reset ui-widget-content ui-corner-bottom ui-accordion-content ui-accordion-content-active ui-state-disabled\" )\n\t\t\t.each(function() {\n\t\t\t\tif ( /^ui-accordion/.test( this.id ) ) {\n\t\t\t\t\tthis.removeAttribute( \"id\" );\n\t\t\t\t}\n\t\t\t});\n\t\tif ( this.options.heightStyle !== \"content\" ) {\n\t\t\tcontents.css( \"height\", \"\" );\n\t\t}\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"active\" ) {\n\t\t\t// _activate() will handle invalid values and update this.options\n\t\t\tthis._activate( value );\n\t\t\treturn;\n\t\t}\n\n\t\tif ( key === \"event\" ) {\n\t\t\tif ( this.options.event ) {\n\t\t\t\tthis._off( this.headers, this.options.event );\n\t\t\t}\n\t\t\tthis._setupEvents( value );\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\t// setting collapsible: false while collapsed; open first panel\n\t\tif ( key === \"collapsible\" && !value && this.options.active === false ) {\n\t\t\tthis._activate( 0 );\n\t\t}\n\n\t\tif ( key === \"icons\" ) {\n\t\t\tthis._destroyIcons();\n\t\t\tif ( value ) {\n\t\t\t\tthis._createIcons();\n\t\t\t}\n\t\t}\n\n\t\t// #5332 - opacity doesn't cascade to positioned elements in IE\n\t\t// so we need to add the disabled class to the headers and panels\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis.headers.add( this.headers.next() )\n\t\t\t\t.toggleClass( \"ui-state-disabled\", !!value );\n\t\t}\n\t},\n\n\t_keydown: function( event ) {\n\t\tif ( event.altKey || event.ctrlKey ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar keyCode = $.ui.keyCode,\n\t\t\tlength = this.headers.length,\n\t\t\tcurrentIndex = this.headers.index( event.target ),\n\t\t\ttoFocus = false;\n\n\t\tswitch ( event.keyCode ) {\n\t\t\tcase keyCode.RIGHT:\n\t\t\tcase keyCode.DOWN:\n\t\t\t\ttoFocus = this.headers[ ( currentIndex + 1 ) % length ];\n\t\t\t\tbreak;\n\t\t\tcase keyCode.LEFT:\n\t\t\tcase keyCode.UP:\n\t\t\t\ttoFocus = this.headers[ ( currentIndex - 1 + length ) % length ];\n\t\t\t\tbreak;\n\t\t\tcase keyCode.SPACE:\n\t\t\tcase keyCode.ENTER:\n\t\t\t\tthis._eventHandler( event );\n\t\t\t\tbreak;\n\t\t\tcase keyCode.HOME:\n\t\t\t\ttoFocus = this.headers[ 0 ];\n\t\t\t\tbreak;\n\t\t\tcase keyCode.END:\n\t\t\t\ttoFocus = this.headers[ length - 1 ];\n\t\t\t\tbreak;\n\t\t}\n\n\t\tif ( toFocus ) {\n\t\t\t$( event.target ).attr( \"tabIndex\", -1 );\n\t\t\t$( toFocus ).attr( \"tabIndex\", 0 );\n\t\t\ttoFocus.focus();\n\t\t\tevent.preventDefault();\n\t\t}\n\t},\n\n\t_panelKeyDown : function( event ) {\n\t\tif ( event.keyCode === $.ui.keyCode.UP && event.ctrlKey ) {\n\t\t\t$( event.currentTarget ).prev().focus();\n\t\t}\n\t},\n\n\trefresh: function() {\n\t\tvar maxHeight, overflow,\n\t\t\theightStyle = this.options.heightStyle,\n\t\t\tparent = this.element.parent();\n\n\n\t\tif ( heightStyle === \"fill\" ) {\n\t\t\t// IE 6 treats height like minHeight, so we need to turn off overflow\n\t\t\t// in order to get a reliable height\n\t\t\t// we use the minHeight support test because we assume that only\n\t\t\t// browsers that don't support minHeight will treat height as minHeight\n\t\t\tif ( !$.support.minHeight ) {\n\t\t\t\toverflow = parent.css( \"overflow\" );\n\t\t\t\tparent.css( \"overflow\", \"hidden\");\n\t\t\t}\n\t\t\tmaxHeight = parent.height();\n\t\t\tthis.element.siblings( \":visible\" ).each(function() {\n\t\t\t\tvar elem = $( this ),\n\t\t\t\t\tposition = elem.css( \"position\" );\n\n\t\t\t\tif ( position === \"absolute\" || position === \"fixed\" ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tmaxHeight -= elem.outerHeight( true );\n\t\t\t});\n\t\t\tif ( overflow ) {\n\t\t\t\tparent.css( \"overflow\", overflow );\n\t\t\t}\n\n\t\t\tthis.headers.each(function() {\n\t\t\t\tmaxHeight -= $( this ).outerHeight( true );\n\t\t\t});\n\n\t\t\tthis.headers.next()\n\t\t\t\t.each(function() {\n\t\t\t\t\t$( this ).height( Math.max( 0, maxHeight -\n\t\t\t\t\t\t$( this ).innerHeight() + $( this ).height() ) );\n\t\t\t\t})\n\t\t\t\t.css( \"overflow\", \"auto\" );\n\t\t} else if ( heightStyle === \"auto\" ) {\n\t\t\tmaxHeight = 0;\n\t\t\tthis.headers.next()\n\t\t\t\t.each(function() {\n\t\t\t\t\tmaxHeight = Math.max( maxHeight, $( this ).css( \"height\", \"\" ).height() );\n\t\t\t\t})\n\t\t\t\t.height( maxHeight );\n\t\t}\n\t},\n\n\t_activate: function( index ) {\n\t\tvar active = this._findActive( index )[ 0 ];\n\n\t\t// trying to activate the already active panel\n\t\tif ( active === this.active[ 0 ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// trying to collapse, simulate a click on the currently active header\n\t\tactive = active || this.active[ 0 ];\n\n\t\tthis._eventHandler({\n\t\t\ttarget: active,\n\t\t\tcurrentTarget: active,\n\t\t\tpreventDefault: $.noop\n\t\t});\n\t},\n\n\t_findActive: function( selector ) {\n\t\treturn typeof selector === \"number\" ? this.headers.eq( selector ) : $();\n\t},\n\n\t_setupEvents: function( event ) {\n\t\tvar events = {};\n\t\tif ( !event ) {\n\t\t\treturn;\n\t\t}\n\t\t$.each( event.split(\" \"), function( index, eventName ) {\n\t\t\tevents[ eventName ] = \"_eventHandler\";\n\t\t});\n\t\tthis._on( this.headers, events );\n\t},\n\n\t_eventHandler: function( event ) {\n\t\tvar options = this.options,\n\t\t\tactive = this.active,\n\t\t\tclicked = $( event.currentTarget ),\n\t\t\tclickedIsActive = clicked[ 0 ] === active[ 0 ],\n\t\t\tcollapsing = clickedIsActive && options.collapsible,\n\t\t\ttoShow = collapsing ? $() : clicked.next(),\n\t\t\ttoHide = active.next(),\n\t\t\teventData = {\n\t\t\t\toldHeader: active,\n\t\t\t\toldPanel: toHide,\n\t\t\t\tnewHeader: collapsing ? $() : clicked,\n\t\t\t\tnewPanel: toShow\n\t\t\t};\n\n\t\tevent.preventDefault();\n\n\t\tif (\n\t\t\t\t// click on active header, but not collapsible\n\t\t\t\t( clickedIsActive && !options.collapsible ) ||\n\t\t\t\t// allow canceling activation\n\t\t\t\t( this._trigger( \"beforeActivate\", event, eventData ) === false ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\toptions.active = collapsing ? false : this.headers.index( clicked );\n\n\t\t// when the call to ._toggle() comes after the class changes\n\t\t// it causes a very odd bug in IE 8 (see #6720)\n\t\tthis.active = clickedIsActive ? $() : clicked;\n\t\tthis._toggle( eventData );\n\n\t\t// switch classes\n\t\t// corner classes on the previously active header stay after the animation\n\t\tactive.removeClass( \"ui-accordion-header-active ui-state-active\" );\n\t\tif ( options.icons ) {\n\t\t\tactive.children( \".ui-accordion-header-icon\" )\n\t\t\t\t.removeClass( options.icons.activeHeader )\n\t\t\t\t.addClass( options.icons.header );\n\t\t}\n\n\t\tif ( !clickedIsActive ) {\n\t\t\tclicked\n\t\t\t\t.removeClass( \"ui-corner-all\" )\n\t\t\t\t.addClass( \"ui-accordion-header-active ui-state-active ui-corner-top\" );\n\t\t\tif ( options.icons ) {\n\t\t\t\tclicked.children( \".ui-accordion-header-icon\" )\n\t\t\t\t\t.removeClass( options.icons.header )\n\t\t\t\t\t.addClass( options.icons.activeHeader );\n\t\t\t}\n\n\t\t\tclicked\n\t\t\t\t.next()\n\t\t\t\t.addClass( \"ui-accordion-content-active\" );\n\t\t}\n\t},\n\n\t_toggle: function( data ) {\n\t\tvar toShow = data.newPanel,\n\t\t\ttoHide = this.prevShow.length ? this.prevShow : data.oldPanel;\n\n\t\t// handle activating a panel during the animation for another activation\n\t\tthis.prevShow.add( this.prevHide ).stop( true, true );\n\t\tthis.prevShow = toShow;\n\t\tthis.prevHide = toHide;\n\n\t\tif ( this.options.animate ) {\n\t\t\tthis._animate( toShow, toHide, data );\n\t\t} else {\n\t\t\ttoHide.hide();\n\t\t\ttoShow.show();\n\t\t\tthis._toggleComplete( data );\n\t\t}\n\n\t\ttoHide.attr({\n\t\t\t\"aria-expanded\": \"false\",\n\t\t\t\"aria-hidden\": \"true\"\n\t\t});\n\t\ttoHide.prev().attr( \"aria-selected\", \"false\" );\n\t\t// if we're switching panels, remove the old header from the tab order\n\t\t// if we're opening from collapsed state, remove the previous header from the tab order\n\t\t// if we're collapsing, then keep the collapsing header in the tab order\n\t\tif ( toShow.length && toHide.length ) {\n\t\t\ttoHide.prev().attr( \"tabIndex\", -1 );\n\t\t} else if ( toShow.length ) {\n\t\t\tthis.headers.filter(function() {\n\t\t\t\treturn $( this ).attr( \"tabIndex\" ) === 0;\n\t\t\t})\n\t\t\t.attr( \"tabIndex\", -1 );\n\t\t}\n\n\t\ttoShow\n\t\t\t.attr({\n\t\t\t\t\"aria-expanded\": \"true\",\n\t\t\t\t\"aria-hidden\": \"false\"\n\t\t\t})\n\t\t\t.prev()\n\t\t\t\t.attr({\n\t\t\t\t\t\"aria-selected\": \"true\",\n\t\t\t\t\ttabIndex: 0\n\t\t\t\t});\n\t},\n\n\t_animate: function( toShow, toHide, data ) {\n\t\tvar total, easing, duration,\n\t\t\tthat = this,\n\t\t\tadjust = 0,\n\t\t\tdown = toShow.length &&\n\t\t\t\t( !toHide.length || ( toShow.index() < toHide.index() ) ),\n\t\t\tanimate = this.options.animate || {},\n\t\t\toptions = down && animate.down || animate,\n\t\t\tcomplete = function() {\n\t\t\t\tthat._toggleComplete( data );\n\t\t\t};\n\n\t\tif ( typeof options === \"number\" ) {\n\t\t\tduration = options;\n\t\t}\n\t\tif ( typeof options === \"string\" ) {\n\t\t\teasing = options;\n\t\t}\n\t\t// fall back from options to animation in case of partial down settings\n\t\teasing = easing || options.easing || animate.easing;\n\t\tduration = duration || options.duration || animate.duration;\n\n\t\tif ( !toHide.length ) {\n\t\t\treturn toShow.animate( showProps, duration, easing, complete );\n\t\t}\n\t\tif ( !toShow.length ) {\n\t\t\treturn toHide.animate( hideProps, duration, easing, complete );\n\t\t}\n\n\t\ttotal = toShow.show().outerHeight();\n\t\ttoHide.animate( hideProps, {\n\t\t\tduration: duration,\n\t\t\teasing: easing,\n\t\t\tstep: function( now, fx ) {\n\t\t\t\tfx.now = Math.round( now );\n\t\t\t}\n\t\t});\n\t\ttoShow\n\t\t\t.hide()\n\t\t\t.animate( showProps, {\n\t\t\t\tduration: duration,\n\t\t\t\teasing: easing,\n\t\t\t\tcomplete: complete,\n\t\t\t\tstep: function( now, fx ) {\n\t\t\t\t\tfx.now = Math.round( now );\n\t\t\t\t\tif ( fx.prop !== \"height\" ) {\n\t\t\t\t\t\tadjust += fx.now;\n\t\t\t\t\t} else if ( that.options.heightStyle !== \"content\" ) {\n\t\t\t\t\t\tfx.now = Math.round( total - toHide.outerHeight() - adjust );\n\t\t\t\t\t\tadjust = 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t},\n\n\t_toggleComplete: function( data ) {\n\t\tvar toHide = data.oldPanel;\n\n\t\ttoHide\n\t\t\t.removeClass( \"ui-accordion-content-active\" )\n\t\t\t.prev()\n\t\t\t\t.removeClass( \"ui-corner-top\" )\n\t\t\t\t.addClass( \"ui-corner-all\" );\n\n\t\t// Work around for rendering bug in IE (#5421)\n\t\tif ( toHide.length ) {\n\t\t\ttoHide.parent()[0].className = toHide.parent()[0].className;\n\t\t}\n\n\t\tthis._trigger( \"activate\", null, data );\n\t}\n});\n\n\n\n// DEPRECATED\nif ( $.uiBackCompat !== false ) {\n\t// navigation options\n\t(function( $, prototype ) {\n\t\t$.extend( prototype.options, {\n\t\t\tnavigation: false,\n\t\t\tnavigationFilter: function() {\n\t\t\t\treturn this.href.toLowerCase() === location.href.toLowerCase();\n\t\t\t}\n\t\t});\n\n\t\tvar _create = prototype._create;\n\t\tprototype._create = function() {\n\t\t\tif ( this.options.navigation ) {\n\t\t\t\tvar that = this,\n\t\t\t\t\theaders = this.element.find( this.options.header ),\n\t\t\t\t\tcontent = headers.next(),\n\t\t\t\t\tcurrent = headers.add( content )\n\t\t\t\t\t\t.find( \"a\" )\n\t\t\t\t\t\t.filter( this.options.navigationFilter )\n\t\t\t\t\t\t[ 0 ];\n\t\t\t\tif ( current ) {\n\t\t\t\t\theaders.add( content ).each( function( index ) {\n\t\t\t\t\t\tif ( $.contains( this, current ) ) {\n\t\t\t\t\t\t\tthat.options.active = Math.floor( index / 2 );\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t\t_create.call( this );\n\t\t};\n\t}( jQuery, jQuery.ui.accordion.prototype ) );\n\n\t// height options\n\t(function( $, prototype ) {\n\t\t$.extend( prototype.options, {\n\t\t\theightStyle: null, // remove default so we fall back to old values\n\t\t\tautoHeight: true, // use heightStyle: \"auto\"\n\t\t\tclearStyle: false, // use heightStyle: \"content\"\n\t\t\tfillSpace: false // use heightStyle: \"fill\"\n\t\t});\n\n\t\tvar _create = prototype._create,\n\t\t\t_setOption = prototype._setOption;\n\n\t\t$.extend( prototype, {\n\t\t\t_create: function() {\n\t\t\t\tthis.options.heightStyle = this.options.heightStyle ||\n\t\t\t\t\tthis._mergeHeightStyle();\n\n\t\t\t\t_create.call( this );\n\t\t\t},\n\n\t\t\t_setOption: function( key ) {\n\t\t\t\tif ( key === \"autoHeight\" || key === \"clearStyle\" || key === \"fillSpace\" ) {\n\t\t\t\t\tthis.options.heightStyle = this._mergeHeightStyle();\n\t\t\t\t}\n\t\t\t\t_setOption.apply( this, arguments );\n\t\t\t},\n\n\t\t\t_mergeHeightStyle: function() {\n\t\t\t\tvar options = this.options;\n\n\t\t\t\tif ( options.fillSpace ) {\n\t\t\t\t\treturn \"fill\";\n\t\t\t\t}\n\n\t\t\t\tif ( options.clearStyle ) {\n\t\t\t\t\treturn \"content\";\n\t\t\t\t}\n\n\t\t\t\tif ( options.autoHeight ) {\n\t\t\t\t\treturn \"auto\";\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}( jQuery, jQuery.ui.accordion.prototype ) );\n\n\t// icon options\n\t(function( $, prototype ) {\n\t\t$.extend( prototype.options.icons, {\n\t\t\tactiveHeader: null, // remove default so we fall back to old values\n\t\t\theaderSelected: \"ui-icon-triangle-1-s\"\n\t\t});\n\n\t\tvar _createIcons = prototype._createIcons;\n\t\tprototype._createIcons = function() {\n\t\t\tif ( this.options.icons ) {\n\t\t\t\tthis.options.icons.activeHeader = this.options.icons.activeHeader ||\n\t\t\t\t\tthis.options.icons.headerSelected;\n\t\t\t}\n\t\t\t_createIcons.call( this );\n\t\t};\n\t}( jQuery, jQuery.ui.accordion.prototype ) );\n\n\t// expanded active option, activate method\n\t(function( $, prototype ) {\n\t\tprototype.activate = prototype._activate;\n\n\t\tvar _findActive = prototype._findActive;\n\t\tprototype._findActive = function( index ) {\n\t\t\tif ( index === -1 ) {\n\t\t\t\tindex = false;\n\t\t\t}\n\t\t\tif ( index && typeof index !== \"number\" ) {\n\t\t\t\tindex = this.headers.index( this.headers.filter( index ) );\n\t\t\t\tif ( index === -1 ) {\n\t\t\t\t\tindex = false;\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn _findActive.call( this, index );\n\t\t};\n\t}( jQuery, jQuery.ui.accordion.prototype ) );\n\n\t// resize method\n\tjQuery.ui.accordion.prototype.resize = jQuery.ui.accordion.prototype.refresh;\n\n\t// change events\n\t(function( $, prototype ) {\n\t\t$.extend( prototype.options, {\n\t\t\tchange: null,\n\t\t\tchangestart: null\n\t\t});\n\n\t\tvar _trigger = prototype._trigger;\n\t\tprototype._trigger = function( type, event, data ) {\n\t\t\tvar ret = _trigger.apply( this, arguments );\n\t\t\tif ( !ret ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tif ( type === \"beforeActivate\" ) {\n\t\t\t\tret = _trigger.call( this, \"changestart\", event, {\n\t\t\t\t\toldHeader: data.oldHeader,\n\t\t\t\t\toldContent: data.oldPanel,\n\t\t\t\t\tnewHeader: data.newHeader,\n\t\t\t\t\tnewContent: data.newPanel\n\t\t\t\t});\n\t\t\t} else if ( type === \"activate\" ) {\n\t\t\t\tret = _trigger.call( this, \"change\", event, {\n\t\t\t\t\toldHeader: data.oldHeader,\n\t\t\t\t\toldContent: data.oldPanel,\n\t\t\t\t\tnewHeader: data.newHeader,\n\t\t\t\t\tnewContent: data.newPanel\n\t\t\t\t});\n\t\t\t}\n\t\t\treturn ret;\n\t\t};\n\t}( jQuery, jQuery.ui.accordion.prototype ) );\n\n\t// animated option\n\t// NOTE: this only provides support for \"slide\", \"bounceslide\", and easings\n\t// not the full $.ui.accordion.animations API\n\t(function( $, prototype ) {\n\t\t$.extend( prototype.options, {\n\t\t\tanimate: null,\n\t\t\tanimated: \"slide\"\n\t\t});\n\n\t\tvar _create = prototype._create;\n\t\tprototype._create = function() {\n\t\t\tvar options = this.options;\n\t\t\tif ( options.animate === null ) {\n\t\t\t\tif ( !options.animated ) {\n\t\t\t\t\toptions.animate = false;\n\t\t\t\t} else if ( options.animated === \"slide\" ) {\n\t\t\t\t\toptions.animate = 300;\n\t\t\t\t} else if ( options.animated === \"bounceslide\" ) {\n\t\t\t\t\toptions.animate = {\n\t\t\t\t\t\tduration: 200,\n\t\t\t\t\t\tdown: {\n\t\t\t\t\t\t\teasing: \"easeOutBounce\",\n\t\t\t\t\t\t\tduration: 1000\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t} else {\n\t\t\t\t\toptions.animate = options.animated;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t_create.call( this );\n\t\t};\n\t}( jQuery, jQuery.ui.accordion.prototype ) );\n}\n\n})( jQuery );\n\n(function( $, undefined ) {\n\n// used to prevent race conditions with remote data sources\nvar requestIndex = 0;\n\n$.widget( \"ui.autocomplete\", {\n\tversion: \"1.9.2\",\n\tdefaultElement: \"<input>\",\n\toptions: {\n\t\tappendTo: \"body\",\n\t\tautoFocus: false,\n\t\tdelay: 300,\n\t\tminLength: 1,\n\t\tposition: {\n\t\t\tmy: \"left top\",\n\t\t\tat: \"left bottom\",\n\t\t\tcollision: \"none\"\n\t\t},\n\t\tsource: null,\n\n\t\t// callbacks\n\t\tchange: null,\n\t\tclose: null,\n\t\tfocus: null,\n\t\topen: null,\n\t\tresponse: null,\n\t\tsearch: null,\n\t\tselect: null\n\t},\n\n\tpending: 0,\n\n\t_create: function() {\n\t\t// Some browsers only repeat keydown events, not keypress events,\n\t\t// so we use the suppressKeyPress flag to determine if we've already\n\t\t// handled the keydown event. #7269\n\t\t// Unfortunately the code for & in keypress is the same as the up arrow,\n\t\t// so we use the suppressKeyPressRepeat flag to avoid handling keypress\n\t\t// events when we know the keydown event was used to modify the\n\t\t// search term. #7799\n\t\tvar suppressKeyPress, suppressKeyPressRepeat, suppressInput;\n\n\t\tthis.isMultiLine = this._isMultiLine();\n\t\tthis.valueMethod = this.element[ this.element.is( \"input,textarea\" ) ? \"val\" : \"text\" ];\n\t\tthis.isNewMenu = true;\n\n\t\tthis.element\n\t\t\t.addClass( \"ui-autocomplete-input\" )\n\t\t\t.attr( \"autocomplete\", \"off\" );\n\n\t\tthis._on( this.element, {\n\t\t\tkeydown: function( event ) {\n\t\t\t\tif ( this.element.prop( \"readOnly\" ) ) {\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tsuppressInput = true;\n\t\t\t\t\tsuppressKeyPressRepeat = true;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tsuppressKeyPress = false;\n\t\t\t\tsuppressInput = false;\n\t\t\t\tsuppressKeyPressRepeat = false;\n\t\t\t\tvar keyCode = $.ui.keyCode;\n\t\t\t\tswitch( event.keyCode ) {\n\t\t\t\tcase keyCode.PAGE_UP:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._move( \"previousPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.PAGE_DOWN:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._move( \"nextPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.UP:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._keyEvent( \"previous\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.DOWN:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._keyEvent( \"next\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.ENTER:\n\t\t\t\tcase keyCode.NUMPAD_ENTER:\n\t\t\t\t\t// when menu is open and has focus\n\t\t\t\t\tif ( this.menu.active ) {\n\t\t\t\t\t\t// #6055 - Opera still allows the keypress to occur\n\t\t\t\t\t\t// which causes forms to submit\n\t\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\tthis.menu.select( event );\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.TAB:\n\t\t\t\t\tif ( this.menu.active ) {\n\t\t\t\t\t\tthis.menu.select( event );\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.ESCAPE:\n\t\t\t\t\tif ( this.menu.element.is( \":visible\" ) ) {\n\t\t\t\t\t\tthis._value( this.term );\n\t\t\t\t\t\tthis.close( event );\n\t\t\t\t\t\t// Different browsers have different default behavior for escape\n\t\t\t\t\t\t// Single press can mean undo or clear\n\t\t\t\t\t\t// Double press in IE means clear the whole form\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tdefault:\n\t\t\t\t\tsuppressKeyPressRepeat = true;\n\t\t\t\t\t// search timeout should be triggered before the input value is changed\n\t\t\t\t\tthis._searchTimeout( event );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\tkeypress: function( event ) {\n\t\t\t\tif ( suppressKeyPress ) {\n\t\t\t\t\tsuppressKeyPress = false;\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tif ( suppressKeyPressRepeat ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// replicate some key handlers to allow them to repeat in Firefox and Opera\n\t\t\t\tvar keyCode = $.ui.keyCode;\n\t\t\t\tswitch( event.keyCode ) {\n\t\t\t\tcase keyCode.PAGE_UP:\n\t\t\t\t\tthis._move( \"previousPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.PAGE_DOWN:\n\t\t\t\t\tthis._move( \"nextPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.UP:\n\t\t\t\t\tthis._keyEvent( \"previous\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.DOWN:\n\t\t\t\t\tthis._keyEvent( \"next\", event );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\tinput: function( event ) {\n\t\t\t\tif ( suppressInput ) {\n\t\t\t\t\tsuppressInput = false;\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tthis._searchTimeout( event );\n\t\t\t},\n\t\t\tfocus: function() {\n\t\t\t\tthis.selectedItem = null;\n\t\t\t\tthis.previous = this._value();\n\t\t\t},\n\t\t\tblur: function( event ) {\n\t\t\t\tif ( this.cancelBlur ) {\n\t\t\t\t\tdelete this.cancelBlur;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tclearTimeout( this.searching );\n\t\t\t\tthis.close( event );\n\t\t\t\tthis._change( event );\n\t\t\t}\n\t\t});\n\n\t\tthis._initSource();\n\t\tthis.menu = $( \"<ul>\" )\n\t\t\t.addClass( \"ui-autocomplete\" )\n\t\t\t.appendTo( this.document.find( this.options.appendTo || \"body\" )[ 0 ] )\n\t\t\t.menu({\n\t\t\t\t// custom key handling for now\n\t\t\t\tinput: $(),\n\t\t\t\t// disable ARIA support, the live region takes care of that\n\t\t\t\trole: null\n\t\t\t})\n\t\t\t.zIndex( this.element.zIndex() + 1 )\n\t\t\t.hide()\n\t\t\t.data( \"menu\" );\n\n\t\tthis._on( this.menu.element, {\n\t\t\tmousedown: function( event ) {\n\t\t\t\t// prevent moving focus out of the text field\n\t\t\t\tevent.preventDefault();\n\n\t\t\t\t// IE doesn't prevent moving focus even with event.preventDefault()\n\t\t\t\t// so we set a flag to know when we should ignore the blur event\n\t\t\t\tthis.cancelBlur = true;\n\t\t\t\tthis._delay(function() {\n\t\t\t\t\tdelete this.cancelBlur;\n\t\t\t\t});\n\n\t\t\t\t// clicking on the scrollbar causes focus to shift to the body\n\t\t\t\t// but we can't detect a mouseup or a click immediately afterward\n\t\t\t\t// so we have to track the next mousedown and close the menu if\n\t\t\t\t// the user clicks somewhere outside of the autocomplete\n\t\t\t\tvar menuElement = this.menu.element[ 0 ];\n\t\t\t\tif ( !$( event.target ).closest( \".ui-menu-item\" ).length ) {\n\t\t\t\t\tthis._delay(function() {\n\t\t\t\t\t\tvar that = this;\n\t\t\t\t\t\tthis.document.one( \"mousedown\", function( event ) {\n\t\t\t\t\t\t\tif ( event.target !== that.element[ 0 ] &&\n\t\t\t\t\t\t\t\t\tevent.target !== menuElement &&\n\t\t\t\t\t\t\t\t\t!$.contains( menuElement, event.target ) ) {\n\t\t\t\t\t\t\t\tthat.close();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t},\n\t\t\tmenufocus: function( event, ui ) {\n\t\t\t\t// #7024 - Prevent accidental activation of menu items in Firefox\n\t\t\t\tif ( this.isNewMenu ) {\n\t\t\t\t\tthis.isNewMenu = false;\n\t\t\t\t\tif ( event.originalEvent && /^mouse/.test( event.originalEvent.type ) ) {\n\t\t\t\t\t\tthis.menu.blur();\n\n\t\t\t\t\t\tthis.document.one( \"mousemove\", function() {\n\t\t\t\t\t\t\t$( event.target ).trigger( event.originalEvent );\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// back compat for _renderItem using item.autocomplete, via #7810\n\t\t\t\t// TODO remove the fallback, see #8156\n\t\t\t\tvar item = ui.item.data( \"ui-autocomplete-item\" ) || ui.item.data( \"item.autocomplete\" );\n\t\t\t\tif ( false !== this._trigger( \"focus\", event, { item: item } ) ) {\n\t\t\t\t\t// use value to match what will end up in the input, if it was a key event\n\t\t\t\t\tif ( event.originalEvent && /^key/.test( event.originalEvent.type ) ) {\n\t\t\t\t\t\tthis._value( item.value );\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Normally the input is populated with the item's value as the\n\t\t\t\t\t// menu is navigated, causing screen readers to notice a change and\n\t\t\t\t\t// announce the item. Since the focus event was canceled, this doesn't\n\t\t\t\t\t// happen, so we update the live region so that screen readers can\n\t\t\t\t\t// still notice the change and announce it.\n\t\t\t\t\tthis.liveRegion.text( item.value );\n\t\t\t\t}\n\t\t\t},\n\t\t\tmenuselect: function( event, ui ) {\n\t\t\t\t// back compat for _renderItem using item.autocomplete, via #7810\n\t\t\t\t// TODO remove the fallback, see #8156\n\t\t\t\tvar item = ui.item.data( \"ui-autocomplete-item\" ) || ui.item.data( \"item.autocomplete\" ),\n\t\t\t\t\tprevious = this.previous;\n\n\t\t\t\t// only trigger when focus was lost (click on menu)\n\t\t\t\tif ( this.element[0] !== this.document[0].activeElement ) {\n\t\t\t\t\tthis.element.focus();\n\t\t\t\t\tthis.previous = previous;\n\t\t\t\t\t// #6109 - IE triggers two focus events and the second\n\t\t\t\t\t// is asynchronous, so we need to reset the previous\n\t\t\t\t\t// term synchronously and asynchronously :-(\n\t\t\t\t\tthis._delay(function() {\n\t\t\t\t\t\tthis.previous = previous;\n\t\t\t\t\t\tthis.selectedItem = item;\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif ( false !== this._trigger( \"select\", event, { item: item } ) ) {\n\t\t\t\t\tthis._value( item.value );\n\t\t\t\t}\n\t\t\t\t// reset the term after the select event\n\t\t\t\t// this allows custom select handling to work properly\n\t\t\t\tthis.term = this._value();\n\n\t\t\t\tthis.close( event );\n\t\t\t\tthis.selectedItem = item;\n\t\t\t}\n\t\t});\n\n\t\tthis.liveRegion = $( \"<span>\", {\n\t\t\t\trole: \"status\",\n\t\t\t\t\"aria-live\": \"polite\"\n\t\t\t})\n\t\t\t.addClass( \"ui-helper-hidden-accessible\" )\n\t\t\t.insertAfter( this.element );\n\n\t\tif ( $.fn.bgiframe ) {\n\t\t\tthis.menu.element.bgiframe();\n\t\t}\n\n\t\t// turning off autocomplete prevents the browser from remembering the\n\t\t// value when navigating through history, so we re-enable autocomplete\n\t\t// if the page is unloaded before the widget is destroyed. #7790\n\t\tthis._on( this.window, {\n\t\t\tbeforeunload: function() {\n\t\t\t\tthis.element.removeAttr( \"autocomplete\" );\n\t\t\t}\n\t\t});\n\t},\n\n\t_destroy: function() {\n\t\tclearTimeout( this.searching );\n\t\tthis.element\n\t\t\t.removeClass( \"ui-autocomplete-input\" )\n\t\t\t.removeAttr( \"autocomplete\" );\n\t\tthis.menu.element.remove();\n\t\tthis.liveRegion.remove();\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tthis._super( key, value );\n\t\tif ( key === \"source\" ) {\n\t\t\tthis._initSource();\n\t\t}\n\t\tif ( key === \"appendTo\" ) {\n\t\t\tthis.menu.element.appendTo( this.document.find( value || \"body\" )[0] );\n\t\t}\n\t\tif ( key === \"disabled\" && value && this.xhr ) {\n\t\t\tthis.xhr.abort();\n\t\t}\n\t},\n\n\t_isMultiLine: function() {\n\t\t// Textareas are always multi-line\n\t\tif ( this.element.is( \"textarea\" ) ) {\n\t\t\treturn true;\n\t\t}\n\t\t// Inputs are always single-line, even if inside a contentEditable element\n\t\t// IE also treats inputs as contentEditable\n\t\tif ( this.element.is( \"input\" ) ) {\n\t\t\treturn false;\n\t\t}\n\t\t// All other element types are determined by whether or not they're contentEditable\n\t\treturn this.element.prop( \"isContentEditable\" );\n\t},\n\n\t_initSource: function() {\n\t\tvar array, url,\n\t\t\tthat = this;\n\t\tif ( $.isArray(this.options.source) ) {\n\t\t\tarray = this.options.source;\n\t\t\tthis.source = function( request, response ) {\n\t\t\t\tresponse( $.ui.autocomplete.filter( array, request.term ) );\n\t\t\t};\n\t\t} else if ( typeof this.options.source === \"string\" ) {\n\t\t\turl = this.options.source;\n\t\t\tthis.source = function( request, response ) {\n\t\t\t\tif ( that.xhr ) {\n\t\t\t\t\tthat.xhr.abort();\n\t\t\t\t}\n\t\t\t\tthat.xhr = $.ajax({\n\t\t\t\t\turl: url,\n\t\t\t\t\tdata: request,\n\t\t\t\t\tdataType: \"json\",\n\t\t\t\t\tsuccess: function( data ) {\n\t\t\t\t\t\tresponse( data );\n\t\t\t\t\t},\n\t\t\t\t\terror: function() {\n\t\t\t\t\t\tresponse( [] );\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\t\t} else {\n\t\t\tthis.source = this.options.source;\n\t\t}\n\t},\n\n\t_searchTimeout: function( event ) {\n\t\tclearTimeout( this.searching );\n\t\tthis.searching = this._delay(function() {\n\t\t\t// only search if the value has changed\n\t\t\tif ( this.term !== this._value() ) {\n\t\t\t\tthis.selectedItem = null;\n\t\t\t\tthis.search( null, event );\n\t\t\t}\n\t\t}, this.options.delay );\n\t},\n\n\tsearch: function( value, event ) {\n\t\tvalue = value != null ? value : this._value();\n\n\t\t// always save the actual value, not the one passed as an argument\n\t\tthis.term = this._value();\n\n\t\tif ( value.length < this.options.minLength ) {\n\t\t\treturn this.close( event );\n\t\t}\n\n\t\tif ( this._trigger( \"search\", event ) === false ) {\n\t\t\treturn;\n\t\t}\n\n\t\treturn this._search( value );\n\t},\n\n\t_search: function( value ) {\n\t\tthis.pending++;\n\t\tthis.element.addClass( \"ui-autocomplete-loading\" );\n\t\tthis.cancelSearch = false;\n\n\t\tthis.source( { term: value }, this._response() );\n\t},\n\n\t_response: function() {\n\t\tvar that = this,\n\t\t\tindex = ++requestIndex;\n\n\t\treturn function( content ) {\n\t\t\tif ( index === requestIndex ) {\n\t\t\t\tthat.__response( content );\n\t\t\t}\n\n\t\t\tthat.pending--;\n\t\t\tif ( !that.pending ) {\n\t\t\t\tthat.element.removeClass( \"ui-autocomplete-loading\" );\n\t\t\t}\n\t\t};\n\t},\n\n\t__response: function( content ) {\n\t\tif ( content ) {\n\t\t\tcontent = this._normalize( content );\n\t\t}\n\t\tthis._trigger( \"response\", null, { content: content } );\n\t\tif ( !this.options.disabled && content && content.length && !this.cancelSearch ) {\n\t\t\tthis._suggest( content );\n\t\t\tthis._trigger( \"open\" );\n\t\t} else {\n\t\t\t// use ._close() instead of .close() so we don't cancel future searches\n\t\t\tthis._close();\n\t\t}\n\t},\n\n\tclose: function( event ) {\n\t\tthis.cancelSearch = true;\n\t\tthis._close( event );\n\t},\n\n\t_close: function( event ) {\n\t\tif ( this.menu.element.is( \":visible\" ) ) {\n\t\t\tthis.menu.element.hide();\n\t\t\tthis.menu.blur();\n\t\t\tthis.isNewMenu = true;\n\t\t\tthis._trigger( \"close\", event );\n\t\t}\n\t},\n\n\t_change: function( event ) {\n\t\tif ( this.previous !== this._value() ) {\n\t\t\tthis._trigger( \"change\", event, { item: this.selectedItem } );\n\t\t}\n\t},\n\n\t_normalize: function( items ) {\n\t\t// assume all items have the right format when the first item is complete\n\t\tif ( items.length && items[0].label && items[0].value ) {\n\t\t\treturn items;\n\t\t}\n\t\treturn $.map( items, function( item ) {\n\t\t\tif ( typeof item === \"string\" ) {\n\t\t\t\treturn {\n\t\t\t\t\tlabel: item,\n\t\t\t\t\tvalue: item\n\t\t\t\t};\n\t\t\t}\n\t\t\treturn $.extend({\n\t\t\t\tlabel: item.label || item.value,\n\t\t\t\tvalue: item.value || item.label\n\t\t\t}, item );\n\t\t});\n\t},\n\n\t_suggest: function( items ) {\n\t\tvar ul = this.menu.element\n\t\t\t.empty()\n\t\t\t.zIndex( this.element.zIndex() + 1 );\n\t\tthis._renderMenu( ul, items );\n\t\tthis.menu.refresh();\n\n\t\t// size and position menu\n\t\tul.show();\n\t\tthis._resizeMenu();\n\t\tul.position( $.extend({\n\t\t\tof: this.element\n\t\t}, this.options.position ));\n\n\t\tif ( this.options.autoFocus ) {\n\t\t\tthis.menu.next();\n\t\t}\n\t},\n\n\t_resizeMenu: function() {\n\t\tvar ul = this.menu.element;\n\t\tul.outerWidth( Math.max(\n\t\t\t// Firefox wraps long text (possibly a rounding bug)\n\t\t\t// so we add 1px to avoid the wrapping (#7513)\n\t\t\tul.width( \"\" ).outerWidth() + 1,\n\t\t\tthis.element.outerWidth()\n\t\t) );\n\t},\n\n\t_renderMenu: function( ul, items ) {\n\t\tvar that = this;\n\t\t$.each( items, function( index, item ) {\n\t\t\tthat._renderItemData( ul, item );\n\t\t});\n\t},\n\n\t_renderItemData: function( ul, item ) {\n\t\treturn this._renderItem( ul, item ).data( \"ui-autocomplete-item\", item );\n\t},\n\n\t_renderItem: function( ul, item ) {\n\t\treturn $( \"<li>\" )\n\t\t\t.append( $( \"<a>\" ).text( item.label ) )\n\t\t\t.appendTo( ul );\n\t},\n\n\t_move: function( direction, event ) {\n\t\tif ( !this.menu.element.is( \":visible\" ) ) {\n\t\t\tthis.search( null, event );\n\t\t\treturn;\n\t\t}\n\t\tif ( this.menu.isFirstItem() && /^previous/.test( direction ) ||\n\t\t\t\tthis.menu.isLastItem() && /^next/.test( direction ) ) {\n\t\t\tthis._value( this.term );\n\t\t\tthis.menu.blur();\n\t\t\treturn;\n\t\t}\n\t\tthis.menu[ direction ]( event );\n\t},\n\n\twidget: function() {\n\t\treturn this.menu.element;\n\t},\n\n\t_value: function() {\n\t\treturn this.valueMethod.apply( this.element, arguments );\n\t},\n\n\t_keyEvent: function( keyEvent, event ) {\n\t\tif ( !this.isMultiLine || this.menu.element.is( \":visible\" ) ) {\n\t\t\tthis._move( keyEvent, event );\n\n\t\t\t// prevents moving cursor to beginning/end of the text field in some browsers\n\t\t\tevent.preventDefault();\n\t\t}\n\t}\n});\n\n$.extend( $.ui.autocomplete, {\n\tescapeRegex: function( value ) {\n\t\treturn value.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\");\n\t},\n\tfilter: function(array, term) {\n\t\tvar matcher = new RegExp( $.ui.autocomplete.escapeRegex(term), \"i\" );\n\t\treturn $.grep( array, function(value) {\n\t\t\treturn matcher.test( value.label || value.value || value );\n\t\t});\n\t}\n});\n\n\n// live region extension, adding a `messages` option\n// NOTE: This is an experimental API. We are still investigating\n// a full solution for string manipulation and internationalization.\n$.widget( \"ui.autocomplete\", $.ui.autocomplete, {\n\toptions: {\n\t\tmessages: {\n\t\t\tnoResults: \"No search results.\",\n\t\t\tresults: function( amount ) {\n\t\t\t\treturn amount + ( amount > 1 ? \" results are\" : \" result is\" ) +\n\t\t\t\t\t\" available, use up and down arrow keys to navigate.\";\n\t\t\t}\n\t\t}\n\t},\n\n\t__response: function( content ) {\n\t\tvar message;\n\t\tthis._superApply( arguments );\n\t\tif ( this.options.disabled || this.cancelSearch ) {\n\t\t\treturn;\n\t\t}\n\t\tif ( content && content.length ) {\n\t\t\tmessage = this.options.messages.results( content.length );\n\t\t} else {\n\t\t\tmessage = this.options.messages.noResults;\n\t\t}\n\t\tthis.liveRegion.text( message );\n\t}\n});\n\n\n}( jQuery ));\n\n(function( $, undefined ) {\n\nvar lastActive, startXPos, startYPos, clickDragged,\n\tbaseClasses = \"ui-button ui-widget ui-state-default ui-corner-all\",\n\tstateClasses = \"ui-state-hover ui-state-active \",\n\ttypeClasses = \"ui-button-icons-only ui-button-icon-only ui-button-text-icons ui-button-text-icon-primary ui-button-text-icon-secondary ui-button-text-only\",\n\tformResetHandler = function() {\n\t\tvar buttons = $( this ).find( \":ui-button\" );\n\t\tsetTimeout(function() {\n\t\t\tbuttons.button( \"refresh\" );\n\t\t}, 1 );\n\t},\n\tradioGroup = function( radio ) {\n\t\tvar name = radio.name,\n\t\t\tform = radio.form,\n\t\t\tradios = $( [] );\n\t\tif ( name ) {\n\t\t\tif ( form ) {\n\t\t\t\tradios = $( form ).find( \"[name='\" + name + \"']\" );\n\t\t\t} else {\n\t\t\t\tradios = $( \"[name='\" + name + \"']\", radio.ownerDocument )\n\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\treturn !this.form;\n\t\t\t\t\t});\n\t\t\t}\n\t\t}\n\t\treturn radios;\n\t};\n\n$.widget( \"ui.button\", {\n\tversion: \"1.9.2\",\n\tdefaultElement: \"<button>\",\n\toptions: {\n\t\tdisabled: null,\n\t\ttext: true,\n\t\tlabel: null,\n\t\ticons: {\n\t\t\tprimary: null,\n\t\t\tsecondary: null\n\t\t}\n\t},\n\t_create: function() {\n\t\tthis.element.closest( \"form\" )\n\t\t\t.unbind( \"reset\" + this.eventNamespace )\n\t\t\t.bind( \"reset\" + this.eventNamespace, formResetHandler );\n\n\t\tif ( typeof this.options.disabled !== \"boolean\" ) {\n\t\t\tthis.options.disabled = !!this.element.prop( \"disabled\" );\n\t\t} else {\n\t\t\tthis.element.prop( \"disabled\", this.options.disabled );\n\t\t}\n\n\t\tthis._determineButtonType();\n\t\tthis.hasTitle = !!this.buttonElement.attr( \"title\" );\n\n\t\tvar that = this,\n\t\t\toptions = this.options,\n\t\t\ttoggleButton = this.type === \"checkbox\" || this.type === \"radio\",\n\t\t\tactiveClass = !toggleButton ? \"ui-state-active\" : \"\",\n\t\t\tfocusClass = \"ui-state-focus\";\n\n\t\tif ( options.label === null ) {\n\t\t\toptions.label = (this.type === \"input\" ? this.buttonElement.val() : this.buttonElement.html());\n\t\t}\n\n\t\tthis._hoverable( this.buttonElement );\n\n\t\tthis.buttonElement\n\t\t\t.addClass( baseClasses )\n\t\t\t.attr( \"role\", \"button\" )\n\t\t\t.bind( \"mouseenter\" + this.eventNamespace, function() {\n\t\t\t\tif ( options.disabled ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tif ( this === lastActive ) {\n\t\t\t\t\t$( this ).addClass( \"ui-state-active\" );\n\t\t\t\t}\n\t\t\t})\n\t\t\t.bind( \"mouseleave\" + this.eventNamespace, function() {\n\t\t\t\tif ( options.disabled ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\t$( this ).removeClass( activeClass );\n\t\t\t})\n\t\t\t.bind( \"click\" + this.eventNamespace, function( event ) {\n\t\t\t\tif ( options.disabled ) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tevent.stopImmediatePropagation();\n\t\t\t\t}\n\t\t\t});\n\n\t\tthis.element\n\t\t\t.bind( \"focus\" + this.eventNamespace, function() {\n\t\t\t\t// no need to check disabled, focus won't be triggered anyway\n\t\t\t\tthat.buttonElement.addClass( focusClass );\n\t\t\t})\n\t\t\t.bind( \"blur\" + this.eventNamespace, function() {\n\t\t\t\tthat.buttonElement.removeClass( focusClass );\n\t\t\t});\n\n\t\tif ( toggleButton ) {\n\t\t\tthis.element.bind( \"change\" + this.eventNamespace, function() {\n\t\t\t\tif ( clickDragged ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tthat.refresh();\n\t\t\t});\n\t\t\t// if mouse moves between mousedown and mouseup (drag) set clickDragged flag\n\t\t\t// prevents issue where button state changes but checkbox/radio checked state\n\t\t\t// does not in Firefox (see ticket #6970)\n\t\t\tthis.buttonElement\n\t\t\t\t.bind( \"mousedown\" + this.eventNamespace, function( event ) {\n\t\t\t\t\tif ( options.disabled ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tclickDragged = false;\n\t\t\t\t\tstartXPos = event.pageX;\n\t\t\t\t\tstartYPos = event.pageY;\n\t\t\t\t})\n\t\t\t\t.bind( \"mouseup\" + this.eventNamespace, function( event ) {\n\t\t\t\t\tif ( options.disabled ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tif ( startXPos !== event.pageX || startYPos !== event.pageY ) {\n\t\t\t\t\t\tclickDragged = true;\n\t\t\t\t\t}\n\t\t\t});\n\t\t}\n\n\t\tif ( this.type === \"checkbox\" ) {\n\t\t\tthis.buttonElement.bind( \"click\" + this.eventNamespace, function() {\n\t\t\t\tif ( options.disabled || clickDragged ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\t$( this ).toggleClass( \"ui-state-active\" );\n\t\t\t\tthat.buttonElement.attr( \"aria-pressed\", that.element[0].checked );\n\t\t\t});\n\t\t} else if ( this.type === \"radio\" ) {\n\t\t\tthis.buttonElement.bind( \"click\" + this.eventNamespace, function() {\n\t\t\t\tif ( options.disabled || clickDragged ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\t$( this ).addClass( \"ui-state-active\" );\n\t\t\t\tthat.buttonElement.attr( \"aria-pressed\", \"true\" );\n\n\t\t\t\tvar radio = that.element[ 0 ];\n\t\t\t\tradioGroup( radio )\n\t\t\t\t\t.not( radio )\n\t\t\t\t\t.map(function() {\n\t\t\t\t\t\treturn $( this ).button( \"widget\" )[ 0 ];\n\t\t\t\t\t})\n\t\t\t\t\t.removeClass( \"ui-state-active\" )\n\t\t\t\t\t.attr( \"aria-pressed\", \"false\" );\n\t\t\t});\n\t\t} else {\n\t\t\tthis.buttonElement\n\t\t\t\t.bind( \"mousedown\" + this.eventNamespace, function() {\n\t\t\t\t\tif ( options.disabled ) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\t$( this ).addClass( \"ui-state-active\" );\n\t\t\t\t\tlastActive = this;\n\t\t\t\t\tthat.document.one( \"mouseup\", function() {\n\t\t\t\t\t\tlastActive = null;\n\t\t\t\t\t});\n\t\t\t\t})\n\t\t\t\t.bind( \"mouseup\" + this.eventNamespace, function() {\n\t\t\t\t\tif ( options.disabled ) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\t$( this ).removeClass( \"ui-state-active\" );\n\t\t\t\t})\n\t\t\t\t.bind( \"keydown\" + this.eventNamespace, function(event) {\n\t\t\t\t\tif ( options.disabled ) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tif ( event.keyCode === $.ui.keyCode.SPACE || event.keyCode === $.ui.keyCode.ENTER ) {\n\t\t\t\t\t\t$( this ).addClass( \"ui-state-active\" );\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind( \"keyup\" + this.eventNamespace, function() {\n\t\t\t\t\t$( this ).removeClass( \"ui-state-active\" );\n\t\t\t\t});\n\n\t\t\tif ( this.buttonElement.is(\"a\") ) {\n\t\t\t\tthis.buttonElement.keyup(function(event) {\n\t\t\t\t\tif ( event.keyCode === $.ui.keyCode.SPACE ) {\n\t\t\t\t\t\t// TODO pass through original event correctly (just as 2nd argument doesn't work)\n\t\t\t\t\t\t$( this ).click();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\n\t\t// TODO: pull out $.Widget's handling for the disabled option into\n\t\t// $.Widget.prototype._setOptionDisabled so it's easy to proxy and can\n\t\t// be overridden by individual plugins\n\t\tthis._setOption( \"disabled\", options.disabled );\n\t\tthis._resetButton();\n\t},\n\n\t_determineButtonType: function() {\n\t\tvar ancestor, labelSelector, checked;\n\n\t\tif ( this.element.is(\"[type=checkbox]\") ) {\n\t\t\tthis.type = \"checkbox\";\n\t\t} else if ( this.element.is(\"[type=radio]\") ) {\n\t\t\tthis.type = \"radio\";\n\t\t} else if ( this.element.is(\"input\") ) {\n\t\t\tthis.type = \"input\";\n\t\t} else {\n\t\t\tthis.type = \"button\";\n\t\t}\n\n\t\tif ( this.type === \"checkbox\" || this.type === \"radio\" ) {\n\t\t\t// we don't search against the document in case the element\n\t\t\t// is disconnected from the DOM\n\t\t\tancestor = this.element.parents().last();\n\t\t\tlabelSelector = \"label[for='\" + this.element.attr(\"id\") + \"']\";\n\t\t\tthis.buttonElement = ancestor.find( labelSelector );\n\t\t\tif ( !this.buttonElement.length ) {\n\t\t\t\tancestor = ancestor.length ? ancestor.siblings() : this.element.siblings();\n\t\t\t\tthis.buttonElement = ancestor.filter( labelSelector );\n\t\t\t\tif ( !this.buttonElement.length ) {\n\t\t\t\t\tthis.buttonElement = ancestor.find( labelSelector );\n\t\t\t\t}\n\t\t\t}\n\t\t\tthis.element.addClass( \"ui-helper-hidden-accessible\" );\n\n\t\t\tchecked = this.element.is( \":checked\" );\n\t\t\tif ( checked ) {\n\t\t\t\tthis.buttonElement.addClass( \"ui-state-active\" );\n\t\t\t}\n\t\t\tthis.buttonElement.prop( \"aria-pressed\", checked );\n\t\t} else {\n\t\t\tthis.buttonElement = this.element;\n\t\t}\n\t},\n\n\twidget: function() {\n\t\treturn this.buttonElement;\n\t},\n\n\t_destroy: function() {\n\t\tthis.element\n\t\t\t.removeClass( \"ui-helper-hidden-accessible\" );\n\t\tthis.buttonElement\n\t\t\t.removeClass( baseClasses + \" \" + stateClasses + \" \" + typeClasses )\n\t\t\t.removeAttr( \"role\" )\n\t\t\t.removeAttr( \"aria-pressed\" )\n\t\t\t.html( this.buttonElement.find(\".ui-button-text\").html() );\n\n\t\tif ( !this.hasTitle ) {\n\t\t\tthis.buttonElement.removeAttr( \"title\" );\n\t\t}\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tthis._super( key, value );\n\t\tif ( key === \"disabled\" ) {\n\t\t\tif ( value ) {\n\t\t\t\tthis.element.prop( \"disabled\", true );\n\t\t\t} else {\n\t\t\t\tthis.element.prop( \"disabled\", false );\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\t\tthis._resetButton();\n\t},\n\n\trefresh: function() {\n\t\t//See #8237 & #8828\n\t\tvar isDisabled = this.element.is( \"input, button\" ) ? this.element.is( \":disabled\" ) : this.element.hasClass( \"ui-button-disabled\" );\n\n\t\tif ( isDisabled !== this.options.disabled ) {\n\t\t\tthis._setOption( \"disabled\", isDisabled );\n\t\t}\n\t\tif ( this.type === \"radio\" ) {\n\t\t\tradioGroup( this.element[0] ).each(function() {\n\t\t\t\tif ( $( this ).is( \":checked\" ) ) {\n\t\t\t\t\t$( this ).button( \"widget\" )\n\t\t\t\t\t\t.addClass( \"ui-state-active\" )\n\t\t\t\t\t\t.attr( \"aria-pressed\", \"true\" );\n\t\t\t\t} else {\n\t\t\t\t\t$( this ).button( \"widget\" )\n\t\t\t\t\t\t.removeClass( \"ui-state-active\" )\n\t\t\t\t\t\t.attr( \"aria-pressed\", \"false\" );\n\t\t\t\t}\n\t\t\t});\n\t\t} else if ( this.type === \"checkbox\" ) {\n\t\t\tif ( this.element.is( \":checked\" ) ) {\n\t\t\t\tthis.buttonElement\n\t\t\t\t\t.addClass( \"ui-state-active\" )\n\t\t\t\t\t.attr( \"aria-pressed\", \"true\" );\n\t\t\t} else {\n\t\t\t\tthis.buttonElement\n\t\t\t\t\t.removeClass( \"ui-state-active\" )\n\t\t\t\t\t.attr( \"aria-pressed\", \"false\" );\n\t\t\t}\n\t\t}\n\t},\n\n\t_resetButton: function() {\n\t\tif ( this.type === \"input\" ) {\n\t\t\tif ( this.options.label ) {\n\t\t\t\tthis.element.val( this.options.label );\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\t\tvar buttonElement = this.buttonElement.removeClass( typeClasses ),\n\t\t\tbuttonText = $( \"<span></span>\", this.document[0] )\n\t\t\t\t.addClass( \"ui-button-text\" )\n\t\t\t\t.html( this.options.label )\n\t\t\t\t.appendTo( buttonElement.empty() )\n\t\t\t\t.text(),\n\t\t\ticons = this.options.icons,\n\t\t\tmultipleIcons = icons.primary && icons.secondary,\n\t\t\tbuttonClasses = [];\n\n\t\tif ( icons.primary || icons.secondary ) {\n\t\t\tif ( this.options.text ) {\n\t\t\t\tbuttonClasses.push( \"ui-button-text-icon\" + ( multipleIcons ? \"s\" : ( icons.primary ? \"-primary\" : \"-secondary\" ) ) );\n\t\t\t}\n\n\t\t\tif ( icons.primary ) {\n\t\t\t\tbuttonElement.prepend( \"<span class='ui-button-icon-primary ui-icon \" + icons.primary + \"'></span>\" );\n\t\t\t}\n\n\t\t\tif ( icons.secondary ) {\n\t\t\t\tbuttonElement.append( \"<span class='ui-button-icon-secondary ui-icon \" + icons.secondary + \"'></span>\" );\n\t\t\t}\n\n\t\t\tif ( !this.options.text ) {\n\t\t\t\tbuttonClasses.push( multipleIcons ? \"ui-button-icons-only\" : \"ui-button-icon-only\" );\n\n\t\t\t\tif ( !this.hasTitle ) {\n\t\t\t\t\tbuttonElement.attr( \"title\", $.trim( buttonText ) );\n\t\t\t\t}\n\t\t\t}\n\t\t} else {\n\t\t\tbuttonClasses.push( \"ui-button-text-only\" );\n\t\t}\n\t\tbuttonElement.addClass( buttonClasses.join( \" \" ) );\n\t}\n});\n\n$.widget( \"ui.buttonset\", {\n\tversion: \"1.9.2\",\n\toptions: {\n\t\titems: \"button, input[type=button], input[type=submit], input[type=reset], input[type=checkbox], input[type=radio], a, :data(button)\"\n\t},\n\n\t_create: function() {\n\t\tthis.element.addClass( \"ui-buttonset\" );\n\t},\n\n\t_init: function() {\n\t\tthis.refresh();\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis.buttons.button( \"option\", key, value );\n\t\t}\n\n\t\tthis._super( key, value );\n\t},\n\n\trefresh: function() {\n\t\tvar rtl = this.element.css( \"direction\" ) === \"rtl\";\n\n\t\tthis.buttons = this.element.find( this.options.items )\n\t\t\t.filter( \":ui-button\" )\n\t\t\t\t.button( \"refresh\" )\n\t\t\t.end()\n\t\t\t.not( \":ui-button\" )\n\t\t\t\t.button()\n\t\t\t.end()\n\t\t\t.map(function() {\n\t\t\t\treturn $( this ).button( \"widget\" )[ 0 ];\n\t\t\t})\n\t\t\t\t.removeClass( \"ui-corner-all ui-corner-left ui-corner-right\" )\n\t\t\t\t.filter( \":first\" )\n\t\t\t\t\t.addClass( rtl ? \"ui-corner-right\" : \"ui-corner-left\" )\n\t\t\t\t.end()\n\t\t\t\t.filter( \":last\" )\n\t\t\t\t\t.addClass( rtl ? \"ui-corner-left\" : \"ui-corner-right\" )\n\t\t\t\t.end()\n\t\t\t.end();\n\t},\n\n\t_destroy: function() {\n\t\tthis.element.removeClass( \"ui-buttonset\" );\n\t\tthis.buttons\n\t\t\t.map(function() {\n\t\t\t\treturn $( this ).button( \"widget\" )[ 0 ];\n\t\t\t})\n\t\t\t\t.removeClass( \"ui-corner-left ui-corner-right\" )\n\t\t\t.end()\n\t\t\t.button( \"destroy\" );\n\t}\n});\n\n}( jQuery ) );\n\n(function( $, undefined ) {\n\n$.extend($.ui, { datepicker: { version: \"1.9.2\" } });\n\nvar PROP_NAME = 'datepicker';\nvar dpuuid = new Date().getTime();\nvar instActive;\n\n/* Date picker manager.\n   Use the singleton instance of this class, $.datepicker, to interact with the date picker.\n   Settings for (groups of) date pickers are maintained in an instance object,\n   allowing multiple different settings on the same page. */\n\nfunction Datepicker() {\n\tthis.debug = false; // Change this to true to start debugging\n\tthis._curInst = null; // The current instance in use\n\tthis._keyEvent = false; // If the last event was a key event\n\tthis._disabledInputs = []; // List of date picker inputs that have been disabled\n\tthis._datepickerShowing = false; // True if the popup picker is showing , false if not\n\tthis._inDialog = false; // True if showing within a \"dialog\", false if not\n\tthis._mainDivId = 'ui-datepicker-div'; // The ID of the main datepicker division\n\tthis._inlineClass = 'ui-datepicker-inline'; // The name of the inline marker class\n\tthis._appendClass = 'ui-datepicker-append'; // The name of the append marker class\n\tthis._triggerClass = 'ui-datepicker-trigger'; // The name of the trigger marker class\n\tthis._dialogClass = 'ui-datepicker-dialog'; // The name of the dialog marker class\n\tthis._disableClass = 'ui-datepicker-disabled'; // The name of the disabled covering marker class\n\tthis._unselectableClass = 'ui-datepicker-unselectable'; // The name of the unselectable cell marker class\n\tthis._currentClass = 'ui-datepicker-current-day'; // The name of the current day marker class\n\tthis._dayOverClass = 'ui-datepicker-days-cell-over'; // The name of the day hover marker class\n\tthis.regional = []; // Available regional settings, indexed by language code\n\tthis.regional[''] = { // Default regional settings\n\t\tcloseText: 'Done', // Display text for close link\n\t\tprevText: 'Prev', // Display text for previous month link\n\t\tnextText: 'Next', // Display text for next month link\n\t\tcurrentText: 'Today', // Display text for current month link\n\t\tmonthNames: ['January','February','March','April','May','June',\n\t\t\t'July','August','September','October','November','December'], // Names of months for drop-down and formatting\n\t\tmonthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'], // For formatting\n\t\tdayNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'], // For formatting\n\t\tdayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'], // For formatting\n\t\tdayNamesMin: ['Su','Mo','Tu','We','Th','Fr','Sa'], // Column headings for days starting at Sunday\n\t\tweekHeader: 'Wk', // Column header for week of the year\n\t\tdateFormat: 'mm/dd/yy', // See format options on parseDate\n\t\tfirstDay: 0, // The first day of the week, Sun = 0, Mon = 1, ...\n\t\tisRTL: false, // True if right-to-left language, false if left-to-right\n\t\tshowMonthAfterYear: false, // True if the year select precedes month, false for month then year\n\t\tyearSuffix: '' // Additional text to append to the year in the month headers\n\t};\n\tthis._defaults = { // Global defaults for all the date picker instances\n\t\tshowOn: 'focus', // 'focus' for popup on focus,\n\t\t\t// 'button' for trigger button, or 'both' for either\n\t\tshowAnim: 'fadeIn', // Name of jQuery animation for popup\n\t\tshowOptions: {}, // Options for enhanced animations\n\t\tdefaultDate: null, // Used when field is blank: actual date,\n\t\t\t// +/-number for offset from today, null for today\n\t\tappendText: '', // Display text following the input box, e.g. showing the format\n\t\tbuttonText: '...', // Text for trigger button\n\t\tbuttonImage: '', // URL for trigger button image\n\t\tbuttonImageOnly: false, // True if the image appears alone, false if it appears on a button\n\t\thideIfNoPrevNext: false, // True to hide next/previous month links\n\t\t\t// if not applicable, false to just disable them\n\t\tnavigationAsDateFormat: false, // True if date formatting applied to prev/today/next links\n\t\tgotoCurrent: false, // True if today link goes back to current selection instead\n\t\tchangeMonth: false, // True if month can be selected directly, false if only prev/next\n\t\tchangeYear: false, // True if year can be selected directly, false if only prev/next\n\t\tyearRange: 'c-10:c+10', // Range of years to display in drop-down,\n\t\t\t// either relative to today's year (-nn:+nn), relative to currently displayed year\n\t\t\t// (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)\n\t\tshowOtherMonths: false, // True to show dates in other months, false to leave blank\n\t\tselectOtherMonths: false, // True to allow selection of dates in other months, false for unselectable\n\t\tshowWeek: false, // True to show week of the year, false to not show it\n\t\tcalculateWeek: this.iso8601Week, // How to calculate the week of the year,\n\t\t\t// takes a Date and returns the number of the week for it\n\t\tshortYearCutoff: '+10', // Short year values < this are in the current century,\n\t\t\t// > this are in the previous century,\n\t\t\t// string value starting with '+' for current year + value\n\t\tminDate: null, // The earliest selectable date, or null for no limit\n\t\tmaxDate: null, // The latest selectable date, or null for no limit\n\t\tduration: 'fast', // Duration of display/closure\n\t\tbeforeShowDay: null, // Function that takes a date and returns an array with\n\t\t\t// [0] = true if selectable, false if not, [1] = custom CSS class name(s) or '',\n\t\t\t// [2] = cell title (optional), e.g. $.datepicker.noWeekends\n\t\tbeforeShow: null, // Function that takes an input field and\n\t\t\t// returns a set of custom settings for the date picker\n\t\tonSelect: null, // Define a callback function when a date is selected\n\t\tonChangeMonthYear: null, // Define a callback function when the month or year is changed\n\t\tonClose: null, // Define a callback function when the datepicker is closed\n\t\tnumberOfMonths: 1, // Number of months to show at a time\n\t\tshowCurrentAtPos: 0, // The position in multipe months at which to show the current month (starting at 0)\n\t\tstepMonths: 1, // Number of months to step back/forward\n\t\tstepBigMonths: 12, // Number of months to step back/forward for the big links\n\t\taltField: '', // Selector for an alternate field to store selected dates into\n\t\taltFormat: '', // The date format to use for the alternate field\n\t\tconstrainInput: true, // The input is constrained by the current date format\n\t\tshowButtonPanel: false, // True to show button panel, false to not show it\n\t\tautoSize: false, // True to size the input for the date format, false to leave as is\n\t\tdisabled: false // The initial disabled state\n\t};\n\t$.extend(this._defaults, this.regional['']);\n\tthis.dpDiv = bindHover($('<div id=\"' + this._mainDivId + '\" class=\"ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all\"></div>'));\n}\n\n$.extend(Datepicker.prototype, {\n\t/* Class name added to elements to indicate already configured with a date picker. */\n\tmarkerClassName: 'hasDatepicker',\n\n\t//Keep track of the maximum number of rows displayed (see #7043)\n\tmaxRows: 4,\n\n\t/* Debug logging (if enabled). */\n\tlog: function () {\n\t\tif (this.debug)\n\t\t\tconsole.log.apply('', arguments);\n\t},\n\n\t// TODO rename to \"widget\" when switching to widget factory\n\t_widgetDatepicker: function() {\n\t\treturn this.dpDiv;\n\t},\n\n\t/* Override the default settings for all instances of the date picker.\n\t   @param  settings  object - the new settings to use as defaults (anonymous object)\n\t   @return the manager object */\n\tsetDefaults: function(settings) {\n\t\textendRemove(this._defaults, settings || {});\n\t\treturn this;\n\t},\n\n\t/* Attach the date picker to a jQuery selection.\n\t   @param  target    element - the target input field or division or span\n\t   @param  settings  object - the new settings to use for this date picker instance (anonymous) */\n\t_attachDatepicker: function(target, settings) {\n\t\t// check for settings on the control itself - in namespace 'date:'\n\t\tvar inlineSettings = null;\n\t\tfor (var attrName in this._defaults) {\n\t\t\tvar attrValue = target.getAttribute('date:' + attrName);\n\t\t\tif (attrValue) {\n\t\t\t\tinlineSettings = inlineSettings || {};\n\t\t\t\ttry {\n\t\t\t\t\tinlineSettings[attrName] = eval(attrValue);\n\t\t\t\t} catch (err) {\n\t\t\t\t\tinlineSettings[attrName] = attrValue;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tvar nodeName = target.nodeName.toLowerCase();\n\t\tvar inline = (nodeName == 'div' || nodeName == 'span');\n\t\tif (!target.id) {\n\t\t\tthis.uuid += 1;\n\t\t\ttarget.id = 'dp' + this.uuid;\n\t\t}\n\t\tvar inst = this._newInst($(target), inline);\n\t\tinst.settings = $.extend({}, settings || {}, inlineSettings || {});\n\t\tif (nodeName == 'input') {\n\t\t\tthis._connectDatepicker(target, inst);\n\t\t} else if (inline) {\n\t\t\tthis._inlineDatepicker(target, inst);\n\t\t}\n\t},\n\n\t/* Create a new instance object. */\n\t_newInst: function(target, inline) {\n\t\tvar id = target[0].id.replace(/([^A-Za-z0-9_-])/g, '\\\\\\\\$1'); // escape jQuery meta chars\n\t\treturn {id: id, input: target, // associated target\n\t\t\tselectedDay: 0, selectedMonth: 0, selectedYear: 0, // current selection\n\t\t\tdrawMonth: 0, drawYear: 0, // month being drawn\n\t\t\tinline: inline, // is datepicker inline or not\n\t\t\tdpDiv: (!inline ? this.dpDiv : // presentation div\n\t\t\tbindHover($('<div class=\"' + this._inlineClass + ' ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all\"></div>')))};\n\t},\n\n\t/* Attach the date picker to an input field. */\n\t_connectDatepicker: function(target, inst) {\n\t\tvar input = $(target);\n\t\tinst.append = $([]);\n\t\tinst.trigger = $([]);\n\t\tif (input.hasClass(this.markerClassName))\n\t\t\treturn;\n\t\tthis._attachments(input, inst);\n\t\tinput.addClass(this.markerClassName).keydown(this._doKeyDown).\n\t\t\tkeypress(this._doKeyPress).keyup(this._doKeyUp).\n\t\t\tbind(\"setData.datepicker\", function(event, key, value) {\n\t\t\t\tinst.settings[key] = value;\n\t\t\t}).bind(\"getData.datepicker\", function(event, key) {\n\t\t\t\treturn this._get(inst, key);\n\t\t\t});\n\t\tthis._autoSize(inst);\n\t\t$.data(target, PROP_NAME, inst);\n\t\t//If disabled option is true, disable the datepicker once it has been attached to the input (see ticket #5665)\n\t\tif( inst.settings.disabled ) {\n\t\t\tthis._disableDatepicker( target );\n\t\t}\n\t},\n\n\t/* Make attachments based on settings. */\n\t_attachments: function(input, inst) {\n\t\tvar appendText = this._get(inst, 'appendText');\n\t\tvar isRTL = this._get(inst, 'isRTL');\n\t\tif (inst.append)\n\t\t\tinst.append.remove();\n\t\tif (appendText) {\n\t\t\tinst.append = $('<span class=\"' + this._appendClass + '\">' + appendText + '</span>');\n\t\t\tinput[isRTL ? 'before' : 'after'](inst.append);\n\t\t}\n\t\tinput.unbind('focus', this._showDatepicker);\n\t\tif (inst.trigger)\n\t\t\tinst.trigger.remove();\n\t\tvar showOn = this._get(inst, 'showOn');\n\t\tif (showOn == 'focus' || showOn == 'both') // pop-up date picker when in the marked field\n\t\t\tinput.focus(this._showDatepicker);\n\t\tif (showOn == 'button' || showOn == 'both') { // pop-up date picker when button clicked\n\t\t\tvar buttonText = this._get(inst, 'buttonText');\n\t\t\tvar buttonImage = this._get(inst, 'buttonImage');\n\t\t\tinst.trigger = $(this._get(inst, 'buttonImageOnly') ?\n\t\t\t\t$('<img/>').addClass(this._triggerClass).\n\t\t\t\t\tattr({ src: buttonImage, alt: buttonText, title: buttonText }) :\n\t\t\t\t$('<button type=\"button\"></button>').addClass(this._triggerClass).\n\t\t\t\t\thtml(buttonImage == '' ? buttonText : $('<img/>').attr(\n\t\t\t\t\t{ src:buttonImage, alt:buttonText, title:buttonText })));\n\t\t\tinput[isRTL ? 'before' : 'after'](inst.trigger);\n\t\t\tinst.trigger.click(function() {\n\t\t\t\tif ($.datepicker._datepickerShowing && $.datepicker._lastInput == input[0])\n\t\t\t\t\t$.datepicker._hideDatepicker();\n\t\t\t\telse if ($.datepicker._datepickerShowing && $.datepicker._lastInput != input[0]) {\n\t\t\t\t\t$.datepicker._hideDatepicker();\n\t\t\t\t\t$.datepicker._showDatepicker(input[0]);\n\t\t\t\t} else\n\t\t\t\t\t$.datepicker._showDatepicker(input[0]);\n\t\t\t\treturn false;\n\t\t\t});\n\t\t}\n\t},\n\n\t/* Apply the maximum length for the date format. */\n\t_autoSize: function(inst) {\n\t\tif (this._get(inst, 'autoSize') && !inst.inline) {\n\t\t\tvar date = new Date(2009, 12 - 1, 20); // Ensure double digits\n\t\t\tvar dateFormat = this._get(inst, 'dateFormat');\n\t\t\tif (dateFormat.match(/[DM]/)) {\n\t\t\t\tvar findMax = function(names) {\n\t\t\t\t\tvar max = 0;\n\t\t\t\t\tvar maxI = 0;\n\t\t\t\t\tfor (var i = 0; i < names.length; i++) {\n\t\t\t\t\t\tif (names[i].length > max) {\n\t\t\t\t\t\t\tmax = names[i].length;\n\t\t\t\t\t\t\tmaxI = i;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn maxI;\n\t\t\t\t};\n\t\t\t\tdate.setMonth(findMax(this._get(inst, (dateFormat.match(/MM/) ?\n\t\t\t\t\t'monthNames' : 'monthNamesShort'))));\n\t\t\t\tdate.setDate(findMax(this._get(inst, (dateFormat.match(/DD/) ?\n\t\t\t\t\t'dayNames' : 'dayNamesShort'))) + 20 - date.getDay());\n\t\t\t}\n\t\t\tinst.input.attr('size', this._formatDate(inst, date).length);\n\t\t}\n\t},\n\n\t/* Attach an inline date picker to a div. */\n\t_inlineDatepicker: function(target, inst) {\n\t\tvar divSpan = $(target);\n\t\tif (divSpan.hasClass(this.markerClassName))\n\t\t\treturn;\n\t\tdivSpan.addClass(this.markerClassName).append(inst.dpDiv).\n\t\t\tbind(\"setData.datepicker\", function(event, key, value){\n\t\t\t\tinst.settings[key] = value;\n\t\t\t}).bind(\"getData.datepicker\", function(event, key){\n\t\t\t\treturn this._get(inst, key);\n\t\t\t});\n\t\t$.data(target, PROP_NAME, inst);\n\t\tthis._setDate(inst, this._getDefaultDate(inst), true);\n\t\tthis._updateDatepicker(inst);\n\t\tthis._updateAlternate(inst);\n\t\t//If disabled option is true, disable the datepicker before showing it (see ticket #5665)\n\t\tif( inst.settings.disabled ) {\n\t\t\tthis._disableDatepicker( target );\n\t\t}\n\t\t// Set display:block in place of inst.dpDiv.show() which won't work on disconnected elements\n\t\t// http://bugs.jqueryui.com/ticket/7552 - A Datepicker created on a detached div has zero height\n\t\tinst.dpDiv.css( \"display\", \"block\" );\n\t},\n\n\t/* Pop-up the date picker in a \"dialog\" box.\n\t   @param  input     element - ignored\n\t   @param  date      string or Date - the initial date to display\n\t   @param  onSelect  function - the function to call when a date is selected\n\t   @param  settings  object - update the dialog date picker instance's settings (anonymous object)\n\t   @param  pos       int[2] - coordinates for the dialog's position within the screen or\n\t                     event - with x/y coordinates or\n\t                     leave empty for default (screen centre)\n\t   @return the manager object */\n\t_dialogDatepicker: function(input, date, onSelect, settings, pos) {\n\t\tvar inst = this._dialogInst; // internal instance\n\t\tif (!inst) {\n\t\t\tthis.uuid += 1;\n\t\t\tvar id = 'dp' + this.uuid;\n\t\t\tthis._dialogInput = $('<input type=\"text\" id=\"' + id +\n\t\t\t\t'\" style=\"position: absolute; top: -100px; width: 0px;\"/>');\n\t\t\tthis._dialogInput.keydown(this._doKeyDown);\n\t\t\t$('body').append(this._dialogInput);\n\t\t\tinst = this._dialogInst = this._newInst(this._dialogInput, false);\n\t\t\tinst.settings = {};\n\t\t\t$.data(this._dialogInput[0], PROP_NAME, inst);\n\t\t}\n\t\textendRemove(inst.settings, settings || {});\n\t\tdate = (date && date.constructor == Date ? this._formatDate(inst, date) : date);\n\t\tthis._dialogInput.val(date);\n\n\t\tthis._pos = (pos ? (pos.length ? pos : [pos.pageX, pos.pageY]) : null);\n\t\tif (!this._pos) {\n\t\t\tvar browserWidth = document.documentElement.clientWidth;\n\t\t\tvar browserHeight = document.documentElement.clientHeight;\n\t\t\tvar scrollX = document.documentElement.scrollLeft || document.body.scrollLeft;\n\t\t\tvar scrollY = document.documentElement.scrollTop || document.body.scrollTop;\n\t\t\tthis._pos = // should use actual width/height below\n\t\t\t\t[(browserWidth / 2) - 100 + scrollX, (browserHeight / 2) - 150 + scrollY];\n\t\t}\n\n\t\t// move input on screen for focus, but hidden behind dialog\n\t\tthis._dialogInput.css('left', (this._pos[0] + 20) + 'px').css('top', this._pos[1] + 'px');\n\t\tinst.settings.onSelect = onSelect;\n\t\tthis._inDialog = true;\n\t\tthis.dpDiv.addClass(this._dialogClass);\n\t\tthis._showDatepicker(this._dialogInput[0]);\n\t\tif ($.blockUI)\n\t\t\t$.blockUI(this.dpDiv);\n\t\t$.data(this._dialogInput[0], PROP_NAME, inst);\n\t\treturn this;\n\t},\n\n\t/* Detach a datepicker from its control.\n\t   @param  target    element - the target input field or division or span */\n\t_destroyDatepicker: function(target) {\n\t\tvar $target = $(target);\n\t\tvar inst = $.data(target, PROP_NAME);\n\t\tif (!$target.hasClass(this.markerClassName)) {\n\t\t\treturn;\n\t\t}\n\t\tvar nodeName = target.nodeName.toLowerCase();\n\t\t$.removeData(target, PROP_NAME);\n\t\tif (nodeName == 'input') {\n\t\t\tinst.append.remove();\n\t\t\tinst.trigger.remove();\n\t\t\t$target.removeClass(this.markerClassName).\n\t\t\t\tunbind('focus', this._showDatepicker).\n\t\t\t\tunbind('keydown', this._doKeyDown).\n\t\t\t\tunbind('keypress', this._doKeyPress).\n\t\t\t\tunbind('keyup', this._doKeyUp);\n\t\t} else if (nodeName == 'div' || nodeName == 'span')\n\t\t\t$target.removeClass(this.markerClassName).empty();\n\t},\n\n\t/* Enable the date picker to a jQuery selection.\n\t   @param  target    element - the target input field or division or span */\n\t_enableDatepicker: function(target) {\n\t\tvar $target = $(target);\n\t\tvar inst = $.data(target, PROP_NAME);\n\t\tif (!$target.hasClass(this.markerClassName)) {\n\t\t\treturn;\n\t\t}\n\t\tvar nodeName = target.nodeName.toLowerCase();\n\t\tif (nodeName == 'input') {\n\t\t\ttarget.disabled = false;\n\t\t\tinst.trigger.filter('button').\n\t\t\t\teach(function() { this.disabled = false; }).end().\n\t\t\t\tfilter('img').css({opacity: '1.0', cursor: ''});\n\t\t}\n\t\telse if (nodeName == 'div' || nodeName == 'span') {\n\t\t\tvar inline = $target.children('.' + this._inlineClass);\n\t\t\tinline.children().removeClass('ui-state-disabled');\n\t\t\tinline.find(\"select.ui-datepicker-month, select.ui-datepicker-year\").\n\t\t\t\tprop(\"disabled\", false);\n\t\t}\n\t\tthis._disabledInputs = $.map(this._disabledInputs,\n\t\t\tfunction(value) { return (value == target ? null : value); }); // delete entry\n\t},\n\n\t/* Disable the date picker to a jQuery selection.\n\t   @param  target    element - the target input field or division or span */\n\t_disableDatepicker: function(target) {\n\t\tvar $target = $(target);\n\t\tvar inst = $.data(target, PROP_NAME);\n\t\tif (!$target.hasClass(this.markerClassName)) {\n\t\t\treturn;\n\t\t}\n\t\tvar nodeName = target.nodeName.toLowerCase();\n\t\tif (nodeName == 'input') {\n\t\t\ttarget.disabled = true;\n\t\t\tinst.trigger.filter('button').\n\t\t\t\teach(function() { this.disabled = true; }).end().\n\t\t\t\tfilter('img').css({opacity: '0.5', cursor: 'default'});\n\t\t}\n\t\telse if (nodeName == 'div' || nodeName == 'span') {\n\t\t\tvar inline = $target.children('.' + this._inlineClass);\n\t\t\tinline.children().addClass('ui-state-disabled');\n\t\t\tinline.find(\"select.ui-datepicker-month, select.ui-datepicker-year\").\n\t\t\t\tprop(\"disabled\", true);\n\t\t}\n\t\tthis._disabledInputs = $.map(this._disabledInputs,\n\t\t\tfunction(value) { return (value == target ? null : value); }); // delete entry\n\t\tthis._disabledInputs[this._disabledInputs.length] = target;\n\t},\n\n\t/* Is the first field in a jQuery collection disabled as a datepicker?\n\t   @param  target    element - the target input field or division or span\n\t   @return boolean - true if disabled, false if enabled */\n\t_isDisabledDatepicker: function(target) {\n\t\tif (!target) {\n\t\t\treturn false;\n\t\t}\n\t\tfor (var i = 0; i < this._disabledInputs.length; i++) {\n\t\t\tif (this._disabledInputs[i] == target)\n\t\t\t\treturn true;\n\t\t}\n\t\treturn false;\n\t},\n\n\t/* Retrieve the instance data for the target control.\n\t   @param  target  element - the target input field or division or span\n\t   @return  object - the associated instance data\n\t   @throws  error if a jQuery problem getting data */\n\t_getInst: function(target) {\n\t\ttry {\n\t\t\treturn $.data(target, PROP_NAME);\n\t\t}\n\t\tcatch (err) {\n\t\t\tthrow 'Missing instance data for this datepicker';\n\t\t}\n\t},\n\n\t/* Update or retrieve the settings for a date picker attached to an input field or division.\n\t   @param  target  element - the target input field or division or span\n\t   @param  name    object - the new settings to update or\n\t                   string - the name of the setting to change or retrieve,\n\t                   when retrieving also 'all' for all instance settings or\n\t                   'defaults' for all global defaults\n\t   @param  value   any - the new value for the setting\n\t                   (omit if above is an object or to retrieve a value) */\n\t_optionDatepicker: function(target, name, value) {\n\t\tvar inst = this._getInst(target);\n\t\tif (arguments.length == 2 && typeof name == 'string') {\n\t\t\treturn (name == 'defaults' ? $.extend({}, $.datepicker._defaults) :\n\t\t\t\t(inst ? (name == 'all' ? $.extend({}, inst.settings) :\n\t\t\t\tthis._get(inst, name)) : null));\n\t\t}\n\t\tvar settings = name || {};\n\t\tif (typeof name == 'string') {\n\t\t\tsettings = {};\n\t\t\tsettings[name] = value;\n\t\t}\n\t\tif (inst) {\n\t\t\tif (this._curInst == inst) {\n\t\t\t\tthis._hideDatepicker();\n\t\t\t}\n\t\t\tvar date = this._getDateDatepicker(target, true);\n\t\t\tvar minDate = this._getMinMaxDate(inst, 'min');\n\t\t\tvar maxDate = this._getMinMaxDate(inst, 'max');\n\t\t\textendRemove(inst.settings, settings);\n\t\t\t// reformat the old minDate/maxDate values if dateFormat changes and a new minDate/maxDate isn't provided\n\t\t\tif (minDate !== null && settings['dateFormat'] !== undefined && settings['minDate'] === undefined)\n\t\t\t\tinst.settings.minDate = this._formatDate(inst, minDate);\n\t\t\tif (maxDate !== null && settings['dateFormat'] !== undefined && settings['maxDate'] === undefined)\n\t\t\t\tinst.settings.maxDate = this._formatDate(inst, maxDate);\n\t\t\tthis._attachments($(target), inst);\n\t\t\tthis._autoSize(inst);\n\t\t\tthis._setDate(inst, date);\n\t\t\tthis._updateAlternate(inst);\n\t\t\tthis._updateDatepicker(inst);\n\t\t}\n\t},\n\n\t// change method deprecated\n\t_changeDatepicker: function(target, name, value) {\n\t\tthis._optionDatepicker(target, name, value);\n\t},\n\n\t/* Redraw the date picker attached to an input field or division.\n\t   @param  target  element - the target input field or division or span */\n\t_refreshDatepicker: function(target) {\n\t\tvar inst = this._getInst(target);\n\t\tif (inst) {\n\t\t\tthis._updateDatepicker(inst);\n\t\t}\n\t},\n\n\t/* Set the dates for a jQuery selection.\n\t   @param  target   element - the target input field or division or span\n\t   @param  date     Date - the new date */\n\t_setDateDatepicker: function(target, date) {\n\t\tvar inst = this._getInst(target);\n\t\tif (inst) {\n\t\t\tthis._setDate(inst, date);\n\t\t\tthis._updateDatepicker(inst);\n\t\t\tthis._updateAlternate(inst);\n\t\t}\n\t},\n\n\t/* Get the date(s) for the first entry in a jQuery selection.\n\t   @param  target     element - the target input field or division or span\n\t   @param  noDefault  boolean - true if no default date is to be used\n\t   @return Date - the current date */\n\t_getDateDatepicker: function(target, noDefault) {\n\t\tvar inst = this._getInst(target);\n\t\tif (inst && !inst.inline)\n\t\t\tthis._setDateFromField(inst, noDefault);\n\t\treturn (inst ? this._getDate(inst) : null);\n\t},\n\n\t/* Handle keystrokes. */\n\t_doKeyDown: function(event) {\n\t\tvar inst = $.datepicker._getInst(event.target);\n\t\tvar handled = true;\n\t\tvar isRTL = inst.dpDiv.is('.ui-datepicker-rtl');\n\t\tinst._keyEvent = true;\n\t\tif ($.datepicker._datepickerShowing)\n\t\t\tswitch (event.keyCode) {\n\t\t\t\tcase 9: $.datepicker._hideDatepicker();\n\t\t\t\t\t\thandled = false;\n\t\t\t\t\t\tbreak; // hide on tab out\n\t\t\t\tcase 13: var sel = $('td.' + $.datepicker._dayOverClass + ':not(.' +\n\t\t\t\t\t\t\t\t\t$.datepicker._currentClass + ')', inst.dpDiv);\n\t\t\t\t\t\tif (sel[0])\n\t\t\t\t\t\t\t$.datepicker._selectDay(event.target, inst.selectedMonth, inst.selectedYear, sel[0]);\n\t\t\t\t\t\t\tvar onSelect = $.datepicker._get(inst, 'onSelect');\n\t\t\t\t\t\t\tif (onSelect) {\n\t\t\t\t\t\t\t\tvar dateStr = $.datepicker._formatDate(inst);\n\n\t\t\t\t\t\t\t\t// trigger custom callback\n\t\t\t\t\t\t\t\tonSelect.apply((inst.input ? inst.input[0] : null), [dateStr, inst]);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\t$.datepicker._hideDatepicker();\n\t\t\t\t\t\treturn false; // don't submit the form\n\t\t\t\t\t\tbreak; // select the value on enter\n\t\t\t\tcase 27: $.datepicker._hideDatepicker();\n\t\t\t\t\t\tbreak; // hide on escape\n\t\t\t\tcase 33: $.datepicker._adjustDate(event.target, (event.ctrlKey ?\n\t\t\t\t\t\t\t-$.datepicker._get(inst, 'stepBigMonths') :\n\t\t\t\t\t\t\t-$.datepicker._get(inst, 'stepMonths')), 'M');\n\t\t\t\t\t\tbreak; // previous month/year on page up/+ ctrl\n\t\t\t\tcase 34: $.datepicker._adjustDate(event.target, (event.ctrlKey ?\n\t\t\t\t\t\t\t+$.datepicker._get(inst, 'stepBigMonths') :\n\t\t\t\t\t\t\t+$.datepicker._get(inst, 'stepMonths')), 'M');\n\t\t\t\t\t\tbreak; // next month/year on page down/+ ctrl\n\t\t\t\tcase 35: if (event.ctrlKey || event.metaKey) $.datepicker._clearDate(event.target);\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\t\t\t\t\t\tbreak; // clear on ctrl or command +end\n\t\t\t\tcase 36: if (event.ctrlKey || event.metaKey) $.datepicker._gotoToday(event.target);\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\t\t\t\t\t\tbreak; // current on ctrl or command +home\n\t\t\t\tcase 37: if (event.ctrlKey || event.metaKey) $.datepicker._adjustDate(event.target, (isRTL ? +1 : -1), 'D');\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\t\t\t\t\t\t// -1 day on ctrl or command +left\n\t\t\t\t\t\tif (event.originalEvent.altKey) $.datepicker._adjustDate(event.target, (event.ctrlKey ?\n\t\t\t\t\t\t\t\t\t-$.datepicker._get(inst, 'stepBigMonths') :\n\t\t\t\t\t\t\t\t\t-$.datepicker._get(inst, 'stepMonths')), 'M');\n\t\t\t\t\t\t// next month/year on alt +left on Mac\n\t\t\t\t\t\tbreak;\n\t\t\t\tcase 38: if (event.ctrlKey || event.metaKey) $.datepicker._adjustDate(event.target, -7, 'D');\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\t\t\t\t\t\tbreak; // -1 week on ctrl or command +up\n\t\t\t\tcase 39: if (event.ctrlKey || event.metaKey) $.datepicker._adjustDate(event.target, (isRTL ? -1 : +1), 'D');\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\t\t\t\t\t\t// +1 day on ctrl or command +right\n\t\t\t\t\t\tif (event.originalEvent.altKey) $.datepicker._adjustDate(event.target, (event.ctrlKey ?\n\t\t\t\t\t\t\t\t\t+$.datepicker._get(inst, 'stepBigMonths') :\n\t\t\t\t\t\t\t\t\t+$.datepicker._get(inst, 'stepMonths')), 'M');\n\t\t\t\t\t\t// next month/year on alt +right\n\t\t\t\t\t\tbreak;\n\t\t\t\tcase 40: if (event.ctrlKey || event.metaKey) $.datepicker._adjustDate(event.target, +7, 'D');\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\t\t\t\t\t\tbreak; // +1 week on ctrl or command +down\n\t\t\t\tdefault: handled = false;\n\t\t\t}\n\t\telse if (event.keyCode == 36 && event.ctrlKey) // display the date picker on ctrl+home\n\t\t\t$.datepicker._showDatepicker(this);\n\t\telse {\n\t\t\thandled = false;\n\t\t}\n\t\tif (handled) {\n\t\t\tevent.preventDefault();\n\t\t\tevent.stopPropagation();\n\t\t}\n\t},\n\n\t/* Filter entered characters - based on date format. */\n\t_doKeyPress: function(event) {\n\t\tvar inst = $.datepicker._getInst(event.target);\n\t\tif ($.datepicker._get(inst, 'constrainInput')) {\n\t\t\tvar chars = $.datepicker._possibleChars($.datepicker._get(inst, 'dateFormat'));\n\t\t\tvar chr = String.fromCharCode(event.charCode == undefined ? event.keyCode : event.charCode);\n\t\t\treturn event.ctrlKey || event.metaKey || (chr < ' ' || !chars || chars.indexOf(chr) > -1);\n\t\t}\n\t},\n\n\t/* Synchronise manual entry and field/alternate field. */\n\t_doKeyUp: function(event) {\n\t\tvar inst = $.datepicker._getInst(event.target);\n\t\tif (inst.input.val() != inst.lastVal) {\n\t\t\ttry {\n\t\t\t\tvar date = $.datepicker.parseDate($.datepicker._get(inst, 'dateFormat'),\n\t\t\t\t\t(inst.input ? inst.input.val() : null),\n\t\t\t\t\t$.datepicker._getFormatConfig(inst));\n\t\t\t\tif (date) { // only if valid\n\t\t\t\t\t$.datepicker._setDateFromField(inst);\n\t\t\t\t\t$.datepicker._updateAlternate(inst);\n\t\t\t\t\t$.datepicker._updateDatepicker(inst);\n\t\t\t\t}\n\t\t\t}\n\t\t\tcatch (err) {\n\t\t\t\t$.datepicker.log(err);\n\t\t\t}\n\t\t}\n\t\treturn true;\n\t},\n\n\t/* Pop-up the date picker for a given input field.\n\t   If false returned from beforeShow event handler do not show.\n\t   @param  input  element - the input field attached to the date picker or\n\t                  event - if triggered by focus */\n\t_showDatepicker: function(input) {\n\t\tinput = input.target || input;\n\t\tif (input.nodeName.toLowerCase() != 'input') // find from button/image trigger\n\t\t\tinput = $('input', input.parentNode)[0];\n\t\tif ($.datepicker._isDisabledDatepicker(input) || $.datepicker._lastInput == input) // already here\n\t\t\treturn;\n\t\tvar inst = $.datepicker._getInst(input);\n\t\tif ($.datepicker._curInst && $.datepicker._curInst != inst) {\n\t\t\t$.datepicker._curInst.dpDiv.stop(true, true);\n\t\t\tif ( inst && $.datepicker._datepickerShowing ) {\n\t\t\t\t$.datepicker._hideDatepicker( $.datepicker._curInst.input[0] );\n\t\t\t}\n\t\t}\n\t\tvar beforeShow = $.datepicker._get(inst, 'beforeShow');\n\t\tvar beforeShowSettings = beforeShow ? beforeShow.apply(input, [input, inst]) : {};\n\t\tif(beforeShowSettings === false){\n\t\t\t//false\n\t\t\treturn;\n\t\t}\n\t\textendRemove(inst.settings, beforeShowSettings);\n\t\tinst.lastVal = null;\n\t\t$.datepicker._lastInput = input;\n\t\t$.datepicker._setDateFromField(inst);\n\t\tif ($.datepicker._inDialog) // hide cursor\n\t\t\tinput.value = '';\n\t\tif (!$.datepicker._pos) { // position below input\n\t\t\t$.datepicker._pos = $.datepicker._findPos(input);\n\t\t\t$.datepicker._pos[1] += input.offsetHeight; // add the height\n\t\t}\n\t\tvar isFixed = false;\n\t\t$(input).parents().each(function() {\n\t\t\tisFixed |= $(this).css('position') == 'fixed';\n\t\t\treturn !isFixed;\n\t\t});\n\t\tvar offset = {left: $.datepicker._pos[0], top: $.datepicker._pos[1]};\n\t\t$.datepicker._pos = null;\n\t\t//to avoid flashes on Firefox\n\t\tinst.dpDiv.empty();\n\t\t// determine sizing offscreen\n\t\tinst.dpDiv.css({position: 'absolute', display: 'block', top: '-1000px'});\n\t\t$.datepicker._updateDatepicker(inst);\n\t\t// fix width for dynamic number of date pickers\n\t\t// and adjust position before showing\n\t\toffset = $.datepicker._checkOffset(inst, offset, isFixed);\n\t\tinst.dpDiv.css({position: ($.datepicker._inDialog && $.blockUI ?\n\t\t\t'static' : (isFixed ? 'fixed' : 'absolute')), display: 'none',\n\t\t\tleft: offset.left + 'px', top: offset.top + 'px'});\n\t\tif (!inst.inline) {\n\t\t\tvar showAnim = $.datepicker._get(inst, 'showAnim');\n\t\t\tvar duration = $.datepicker._get(inst, 'duration');\n\t\t\tvar postProcess = function() {\n\t\t\t\tvar cover = inst.dpDiv.find('iframe.ui-datepicker-cover'); // IE6- only\n\t\t\t\tif( !! cover.length ){\n\t\t\t\t\tvar borders = $.datepicker._getBorders(inst.dpDiv);\n\t\t\t\t\tcover.css({left: -borders[0], top: -borders[1],\n\t\t\t\t\t\twidth: inst.dpDiv.outerWidth(), height: inst.dpDiv.outerHeight()});\n\t\t\t\t}\n\t\t\t};\n\t\t\tinst.dpDiv.zIndex($(input).zIndex()+1);\n\t\t\t$.datepicker._datepickerShowing = true;\n\n\t\t\t// DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed\n\t\t\tif ( $.effects && ( $.effects.effect[ showAnim ] || $.effects[ showAnim ] ) )\n\t\t\t\tinst.dpDiv.show(showAnim, $.datepicker._get(inst, 'showOptions'), duration, postProcess);\n\t\t\telse\n\t\t\t\tinst.dpDiv[showAnim || 'show']((showAnim ? duration : null), postProcess);\n\t\t\tif (!showAnim || !duration)\n\t\t\t\tpostProcess();\n\t\t\tif (inst.input.is(':visible') && !inst.input.is(':disabled'))\n\t\t\t\tinst.input.focus();\n\t\t\t$.datepicker._curInst = inst;\n\t\t}\n\t},\n\n\t/* Generate the date picker content. */\n\t_updateDatepicker: function(inst) {\n\t\tthis.maxRows = 4; //Reset the max number of rows being displayed (see #7043)\n\t\tvar borders = $.datepicker._getBorders(inst.dpDiv);\n\t\tinstActive = inst; // for delegate hover events\n\t\tinst.dpDiv.empty().append(this._generateHTML(inst));\n\t\tthis._attachHandlers(inst);\n\t\tvar cover = inst.dpDiv.find('iframe.ui-datepicker-cover'); // IE6- only\n\t\tif( !!cover.length ){ //avoid call to outerXXXX() when not in IE6\n\t\t\tcover.css({left: -borders[0], top: -borders[1], width: inst.dpDiv.outerWidth(), height: inst.dpDiv.outerHeight()})\n\t\t}\n\t\tinst.dpDiv.find('.' + this._dayOverClass + ' a').mouseover();\n\t\tvar numMonths = this._getNumberOfMonths(inst);\n\t\tvar cols = numMonths[1];\n\t\tvar width = 17;\n\t\tinst.dpDiv.removeClass('ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4').width('');\n\t\tif (cols > 1)\n\t\t\tinst.dpDiv.addClass('ui-datepicker-multi-' + cols).css('width', (width * cols) + 'em');\n\t\tinst.dpDiv[(numMonths[0] != 1 || numMonths[1] != 1 ? 'add' : 'remove') +\n\t\t\t'Class']('ui-datepicker-multi');\n\t\tinst.dpDiv[(this._get(inst, 'isRTL') ? 'add' : 'remove') +\n\t\t\t'Class']('ui-datepicker-rtl');\n\t\tif (inst == $.datepicker._curInst && $.datepicker._datepickerShowing && inst.input &&\n\t\t\t\t// #6694 - don't focus the input if it's already focused\n\t\t\t\t// this breaks the change event in IE\n\t\t\t\tinst.input.is(':visible') && !inst.input.is(':disabled') && inst.input[0] != document.activeElement)\n\t\t\tinst.input.focus();\n\t\t// deffered render of the years select (to avoid flashes on Firefox)\n\t\tif( inst.yearshtml ){\n\t\t\tvar origyearshtml = inst.yearshtml;\n\t\t\tsetTimeout(function(){\n\t\t\t\t//assure that inst.yearshtml didn't change.\n\t\t\t\tif( origyearshtml === inst.yearshtml && inst.yearshtml ){\n\t\t\t\t\tinst.dpDiv.find('select.ui-datepicker-year:first').replaceWith(inst.yearshtml);\n\t\t\t\t}\n\t\t\t\torigyearshtml = inst.yearshtml = null;\n\t\t\t}, 0);\n\t\t}\n\t},\n\n\t/* Retrieve the size of left and top borders for an element.\n\t   @param  elem  (jQuery object) the element of interest\n\t   @return  (number[2]) the left and top borders */\n\t_getBorders: function(elem) {\n\t\tvar convert = function(value) {\n\t\t\treturn {thin: 1, medium: 2, thick: 3}[value] || value;\n\t\t};\n\t\treturn [parseFloat(convert(elem.css('border-left-width'))),\n\t\t\tparseFloat(convert(elem.css('border-top-width')))];\n\t},\n\n\t/* Check positioning to remain on screen. */\n\t_checkOffset: function(inst, offset, isFixed) {\n\t\tvar dpWidth = inst.dpDiv.outerWidth();\n\t\tvar dpHeight = inst.dpDiv.outerHeight();\n\t\tvar inputWidth = inst.input ? inst.input.outerWidth() : 0;\n\t\tvar inputHeight = inst.input ? inst.input.outerHeight() : 0;\n\t\tvar viewWidth = document.documentElement.clientWidth + (isFixed ? 0 : $(document).scrollLeft());\n\t\tvar viewHeight = document.documentElement.clientHeight + (isFixed ? 0 : $(document).scrollTop());\n\n\t\toffset.left -= (this._get(inst, 'isRTL') ? (dpWidth - inputWidth) : 0);\n\t\toffset.left -= (isFixed && offset.left == inst.input.offset().left) ? $(document).scrollLeft() : 0;\n\t\toffset.top -= (isFixed && offset.top == (inst.input.offset().top + inputHeight)) ? $(document).scrollTop() : 0;\n\n\t\t// now check if datepicker is showing outside window viewport - move to a better place if so.\n\t\toffset.left -= Math.min(offset.left, (offset.left + dpWidth > viewWidth && viewWidth > dpWidth) ?\n\t\t\tMath.abs(offset.left + dpWidth - viewWidth) : 0);\n\t\toffset.top -= Math.min(offset.top, (offset.top + dpHeight > viewHeight && viewHeight > dpHeight) ?\n\t\t\tMath.abs(dpHeight + inputHeight) : 0);\n\n\t\treturn offset;\n\t},\n\n\t/* Find an object's position on the screen. */\n\t_findPos: function(obj) {\n\t\tvar inst = this._getInst(obj);\n\t\tvar isRTL = this._get(inst, 'isRTL');\n\t\twhile (obj && (obj.type == 'hidden' || obj.nodeType != 1 || $.expr.filters.hidden(obj))) {\n\t\t\tobj = obj[isRTL ? 'previousSibling' : 'nextSibling'];\n\t\t}\n\t\tvar position = $(obj).offset();\n\t\treturn [position.left, position.top];\n\t},\n\n\t/* Hide the date picker from view.\n\t   @param  input  element - the input field attached to the date picker */\n\t_hideDatepicker: function(input) {\n\t\tvar inst = this._curInst;\n\t\tif (!inst || (input && inst != $.data(input, PROP_NAME)))\n\t\t\treturn;\n\t\tif (this._datepickerShowing) {\n\t\t\tvar showAnim = this._get(inst, 'showAnim');\n\t\t\tvar duration = this._get(inst, 'duration');\n\t\t\tvar postProcess = function() {\n\t\t\t\t$.datepicker._tidyDialog(inst);\n\t\t\t};\n\n\t\t\t// DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed\n\t\t\tif ( $.effects && ( $.effects.effect[ showAnim ] || $.effects[ showAnim ] ) )\n\t\t\t\tinst.dpDiv.hide(showAnim, $.datepicker._get(inst, 'showOptions'), duration, postProcess);\n\t\t\telse\n\t\t\t\tinst.dpDiv[(showAnim == 'slideDown' ? 'slideUp' :\n\t\t\t\t\t(showAnim == 'fadeIn' ? 'fadeOut' : 'hide'))]((showAnim ? duration : null), postProcess);\n\t\t\tif (!showAnim)\n\t\t\t\tpostProcess();\n\t\t\tthis._datepickerShowing = false;\n\t\t\tvar onClose = this._get(inst, 'onClose');\n\t\t\tif (onClose)\n\t\t\t\tonClose.apply((inst.input ? inst.input[0] : null),\n\t\t\t\t\t[(inst.input ? inst.input.val() : ''), inst]);\n\t\t\tthis._lastInput = null;\n\t\t\tif (this._inDialog) {\n\t\t\t\tthis._dialogInput.css({ position: 'absolute', left: '0', top: '-100px' });\n\t\t\t\tif ($.blockUI) {\n\t\t\t\t\t$.unblockUI();\n\t\t\t\t\t$('body').append(this.dpDiv);\n\t\t\t\t}\n\t\t\t}\n\t\t\tthis._inDialog = false;\n\t\t}\n\t},\n\n\t/* Tidy up after a dialog display. */\n\t_tidyDialog: function(inst) {\n\t\tinst.dpDiv.removeClass(this._dialogClass).unbind('.ui-datepicker-calendar');\n\t},\n\n\t/* Close date picker if clicked elsewhere. */\n\t_checkExternalClick: function(event) {\n\t\tif (!$.datepicker._curInst)\n\t\t\treturn;\n\n\t\tvar $target = $(event.target),\n\t\t\tinst = $.datepicker._getInst($target[0]);\n\n\t\tif ( ( ( $target[0].id != $.datepicker._mainDivId &&\n\t\t\t\t$target.parents('#' + $.datepicker._mainDivId).length == 0 &&\n\t\t\t\t!$target.hasClass($.datepicker.markerClassName) &&\n\t\t\t\t!$target.closest(\".\" + $.datepicker._triggerClass).length &&\n\t\t\t\t$.datepicker._datepickerShowing && !($.datepicker._inDialog && $.blockUI) ) ) ||\n\t\t\t( $target.hasClass($.datepicker.markerClassName) && $.datepicker._curInst != inst ) )\n\t\t\t$.datepicker._hideDatepicker();\n\t},\n\n\t/* Adjust one of the date sub-fields. */\n\t_adjustDate: function(id, offset, period) {\n\t\tvar target = $(id);\n\t\tvar inst = this._getInst(target[0]);\n\t\tif (this._isDisabledDatepicker(target[0])) {\n\t\t\treturn;\n\t\t}\n\t\tthis._adjustInstDate(inst, offset +\n\t\t\t(period == 'M' ? this._get(inst, 'showCurrentAtPos') : 0), // undo positioning\n\t\t\tperiod);\n\t\tthis._updateDatepicker(inst);\n\t},\n\n\t/* Action for current link. */\n\t_gotoToday: function(id) {\n\t\tvar target = $(id);\n\t\tvar inst = this._getInst(target[0]);\n\t\tif (this._get(inst, 'gotoCurrent') && inst.currentDay) {\n\t\t\tinst.selectedDay = inst.currentDay;\n\t\t\tinst.drawMonth = inst.selectedMonth = inst.currentMonth;\n\t\t\tinst.drawYear = inst.selectedYear = inst.currentYear;\n\t\t}\n\t\telse {\n\t\t\tvar date = new Date();\n\t\t\tinst.selectedDay = date.getDate();\n\t\t\tinst.drawMonth = inst.selectedMonth = date.getMonth();\n\t\t\tinst.drawYear = inst.selectedYear = date.getFullYear();\n\t\t}\n\t\tthis._notifyChange(inst);\n\t\tthis._adjustDate(target);\n\t},\n\n\t/* Action for selecting a new month/year. */\n\t_selectMonthYear: function(id, select, period) {\n\t\tvar target = $(id);\n\t\tvar inst = this._getInst(target[0]);\n\t\tinst['selected' + (period == 'M' ? 'Month' : 'Year')] =\n\t\tinst['draw' + (period == 'M' ? 'Month' : 'Year')] =\n\t\t\tparseInt(select.options[select.selectedIndex].value,10);\n\t\tthis._notifyChange(inst);\n\t\tthis._adjustDate(target);\n\t},\n\n\t/* Action for selecting a day. */\n\t_selectDay: function(id, month, year, td) {\n\t\tvar target = $(id);\n\t\tif ($(td).hasClass(this._unselectableClass) || this._isDisabledDatepicker(target[0])) {\n\t\t\treturn;\n\t\t}\n\t\tvar inst = this._getInst(target[0]);\n\t\tinst.selectedDay = inst.currentDay = $('a', td).html();\n\t\tinst.selectedMonth = inst.currentMonth = month;\n\t\tinst.selectedYear = inst.currentYear = year;\n\t\tthis._selectDate(id, this._formatDate(inst,\n\t\t\tinst.currentDay, inst.currentMonth, inst.currentYear));\n\t},\n\n\t/* Erase the input field and hide the date picker. */\n\t_clearDate: function(id) {\n\t\tvar target = $(id);\n\t\tvar inst = this._getInst(target[0]);\n\t\tthis._selectDate(target, '');\n\t},\n\n\t/* Update the input field with the selected date. */\n\t_selectDate: function(id, dateStr) {\n\t\tvar target = $(id);\n\t\tvar inst = this._getInst(target[0]);\n\t\tdateStr = (dateStr != null ? dateStr : this._formatDate(inst));\n\t\tif (inst.input)\n\t\t\tinst.input.val(dateStr);\n\t\tthis._updateAlternate(inst);\n\t\tvar onSelect = this._get(inst, 'onSelect');\n\t\tif (onSelect)\n\t\t\tonSelect.apply((inst.input ? inst.input[0] : null), [dateStr, inst]);  // trigger custom callback\n\t\telse if (inst.input)\n\t\t\tinst.input.trigger('change'); // fire the change event\n\t\tif (inst.inline)\n\t\t\tthis._updateDatepicker(inst);\n\t\telse {\n\t\t\tthis._hideDatepicker();\n\t\t\tthis._lastInput = inst.input[0];\n\t\t\tif (typeof(inst.input[0]) != 'object')\n\t\t\t\tinst.input.focus(); // restore focus\n\t\t\tthis._lastInput = null;\n\t\t}\n\t},\n\n\t/* Update any alternate field to synchronise with the main field. */\n\t_updateAlternate: function(inst) {\n\t\tvar altField = this._get(inst, 'altField');\n\t\tif (altField) { // update alternate field too\n\t\t\tvar altFormat = this._get(inst, 'altFormat') || this._get(inst, 'dateFormat');\n\t\t\tvar date = this._getDate(inst);\n\t\t\tvar dateStr = this.formatDate(altFormat, date, this._getFormatConfig(inst));\n\t\t\t$(altField).each(function() { $(this).val(dateStr); });\n\t\t}\n\t},\n\n\t/* Set as beforeShowDay function to prevent selection of weekends.\n\t   @param  date  Date - the date to customise\n\t   @return [boolean, string] - is this date selectable?, what is its CSS class? */\n\tnoWeekends: function(date) {\n\t\tvar day = date.getDay();\n\t\treturn [(day > 0 && day < 6), ''];\n\t},\n\n\t/* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.\n\t   @param  date  Date - the date to get the week for\n\t   @return  number - the number of the week within the year that contains this date */\n\tiso8601Week: function(date) {\n\t\tvar checkDate = new Date(date.getTime());\n\t\t// Find Thursday of this week starting on Monday\n\t\tcheckDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7));\n\t\tvar time = checkDate.getTime();\n\t\tcheckDate.setMonth(0); // Compare with Jan 1\n\t\tcheckDate.setDate(1);\n\t\treturn Math.floor(Math.round((time - checkDate) / 86400000) / 7) + 1;\n\t},\n\n\t/* Parse a string value into a date object.\n\t   See formatDate below for the possible formats.\n\n\t   @param  format    string - the expected format of the date\n\t   @param  value     string - the date in the above format\n\t   @param  settings  Object - attributes include:\n\t                     shortYearCutoff  number - the cutoff year for determining the century (optional)\n\t                     dayNamesShort    string[7] - abbreviated names of the days from Sunday (optional)\n\t                     dayNames         string[7] - names of the days from Sunday (optional)\n\t                     monthNamesShort  string[12] - abbreviated names of the months (optional)\n\t                     monthNames       string[12] - names of the months (optional)\n\t   @return  Date - the extracted date value or null if value is blank */\n\tparseDate: function (format, value, settings) {\n\t\tif (format == null || value == null)\n\t\t\tthrow 'Invalid arguments';\n\t\tvalue = (typeof value == 'object' ? value.toString() : value + '');\n\t\tif (value == '')\n\t\t\treturn null;\n\t\tvar shortYearCutoff = (settings ? settings.shortYearCutoff : null) || this._defaults.shortYearCutoff;\n\t\tshortYearCutoff = (typeof shortYearCutoff != 'string' ? shortYearCutoff :\n\t\t\t\tnew Date().getFullYear() % 100 + parseInt(shortYearCutoff, 10));\n\t\tvar dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort;\n\t\tvar dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames;\n\t\tvar monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort;\n\t\tvar monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames;\n\t\tvar year = -1;\n\t\tvar month = -1;\n\t\tvar day = -1;\n\t\tvar doy = -1;\n\t\tvar literal = false;\n\t\t// Check whether a format character is doubled\n\t\tvar lookAhead = function(match) {\n\t\t\tvar matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) == match);\n\t\t\tif (matches)\n\t\t\t\tiFormat++;\n\t\t\treturn matches;\n\t\t};\n\t\t// Extract a number from the string value\n\t\tvar getNumber = function(match) {\n\t\t\tvar isDoubled = lookAhead(match);\n\t\t\tvar size = (match == '@' ? 14 : (match == '!' ? 20 :\n\t\t\t\t(match == 'y' && isDoubled ? 4 : (match == 'o' ? 3 : 2))));\n\t\t\tvar digits = new RegExp('^\\\\d{1,' + size + '}');\n\t\t\tvar num = value.substring(iValue).match(digits);\n\t\t\tif (!num)\n\t\t\t\tthrow 'Missing number at position ' + iValue;\n\t\t\tiValue += num[0].length;\n\t\t\treturn parseInt(num[0], 10);\n\t\t};\n\t\t// Extract a name from the string value and convert to an index\n\t\tvar getName = function(match, shortNames, longNames) {\n\t\t\tvar names = $.map(lookAhead(match) ? longNames : shortNames, function (v, k) {\n\t\t\t\treturn [ [k, v] ];\n\t\t\t}).sort(function (a, b) {\n\t\t\t\treturn -(a[1].length - b[1].length);\n\t\t\t});\n\t\t\tvar index = -1;\n\t\t\t$.each(names, function (i, pair) {\n\t\t\t\tvar name = pair[1];\n\t\t\t\tif (value.substr(iValue, name.length).toLowerCase() == name.toLowerCase()) {\n\t\t\t\t\tindex = pair[0];\n\t\t\t\t\tiValue += name.length;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\t\t\tif (index != -1)\n\t\t\t\treturn index + 1;\n\t\t\telse\n\t\t\t\tthrow 'Unknown name at position ' + iValue;\n\t\t};\n\t\t// Confirm that a literal character matches the string value\n\t\tvar checkLiteral = function() {\n\t\t\tif (value.charAt(iValue) != format.charAt(iFormat))\n\t\t\t\tthrow 'Unexpected literal at position ' + iValue;\n\t\t\tiValue++;\n\t\t};\n\t\tvar iValue = 0;\n\t\tfor (var iFormat = 0; iFormat < format.length; iFormat++) {\n\t\t\tif (literal)\n\t\t\t\tif (format.charAt(iFormat) == \"'\" && !lookAhead(\"'\"))\n\t\t\t\t\tliteral = false;\n\t\t\t\telse\n\t\t\t\t\tcheckLiteral();\n\t\t\telse\n\t\t\t\tswitch (format.charAt(iFormat)) {\n\t\t\t\t\tcase 'd':\n\t\t\t\t\t\tday = getNumber('d');\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase 'D':\n\t\t\t\t\t\tgetName('D', dayNamesShort, dayNames);\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase 'o':\n\t\t\t\t\t\tdoy = getNumber('o');\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase 'm':\n\t\t\t\t\t\tmonth = getNumber('m');\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase 'M':\n\t\t\t\t\t\tmonth = getName('M', monthNamesShort, monthNames);\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase 'y':\n\t\t\t\t\t\tyear = getNumber('y');\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase '@':\n\t\t\t\t\t\tvar date = new Date(getNumber('@'));\n\t\t\t\t\t\tyear = date.getFullYear();\n\t\t\t\t\t\tmonth = date.getMonth() + 1;\n\t\t\t\t\t\tday = date.getDate();\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase '!':\n\t\t\t\t\t\tvar date = new Date((getNumber('!') - this._ticksTo1970) / 10000);\n\t\t\t\t\t\tyear = date.getFullYear();\n\t\t\t\t\t\tmonth = date.getMonth() + 1;\n\t\t\t\t\t\tday = date.getDate();\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"'\":\n\t\t\t\t\t\tif (lookAhead(\"'\"))\n\t\t\t\t\t\t\tcheckLiteral();\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tliteral = true;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tcheckLiteral();\n\t\t\t\t}\n\t\t}\n\t\tif (iValue < value.length){\n\t\t\tvar extra = value.substr(iValue);\n\t\t\tif (!/^\\s+/.test(extra)) {\n\t\t\t\tthrow \"Extra/unparsed characters found in date: \" + extra;\n\t\t\t}\n\t\t}\n\t\tif (year == -1)\n\t\t\tyear = new Date().getFullYear();\n\t\telse if (year < 100)\n\t\t\tyear += new Date().getFullYear() - new Date().getFullYear() % 100 +\n\t\t\t\t(year <= shortYearCutoff ? 0 : -100);\n\t\tif (doy > -1) {\n\t\t\tmonth = 1;\n\t\t\tday = doy;\n\t\t\tdo {\n\t\t\t\tvar dim = this._getDaysInMonth(year, month - 1);\n\t\t\t\tif (day <= dim)\n\t\t\t\t\tbreak;\n\t\t\t\tmonth++;\n\t\t\t\tday -= dim;\n\t\t\t} while (true);\n\t\t}\n\t\tvar date = this._daylightSavingAdjust(new Date(year, month - 1, day));\n\t\tif (date.getFullYear() != year || date.getMonth() + 1 != month || date.getDate() != day)\n\t\t\tthrow 'Invalid date'; // E.g. 31/02/00\n\t\treturn date;\n\t},\n\n\t/* Standard date formats. */\n\tATOM: 'yy-mm-dd', // RFC 3339 (ISO 8601)\n\tCOOKIE: 'D, dd M yy',\n\tISO_8601: 'yy-mm-dd',\n\tRFC_822: 'D, d M y',\n\tRFC_850: 'DD, dd-M-y',\n\tRFC_1036: 'D, d M y',\n\tRFC_1123: 'D, d M yy',\n\tRFC_2822: 'D, d M yy',\n\tRSS: 'D, d M y', // RFC 822\n\tTICKS: '!',\n\tTIMESTAMP: '@',\n\tW3C: 'yy-mm-dd', // ISO 8601\n\n\t_ticksTo1970: (((1970 - 1) * 365 + Math.floor(1970 / 4) - Math.floor(1970 / 100) +\n\t\tMath.floor(1970 / 400)) * 24 * 60 * 60 * 10000000),\n\n\t/* Format a date object into a string value.\n\t   The format can be combinations of the following:\n\t   d  - day of month (no leading zero)\n\t   dd - day of month (two digit)\n\t   o  - day of year (no leading zeros)\n\t   oo - day of year (three digit)\n\t   D  - day name short\n\t   DD - day name long\n\t   m  - month of year (no leading zero)\n\t   mm - month of year (two digit)\n\t   M  - month name short\n\t   MM - month name long\n\t   y  - year (two digit)\n\t   yy - year (four digit)\n\t   @ - Unix timestamp (ms since 01/01/1970)\n\t   ! - Windows ticks (100ns since 01/01/0001)\n\t   '...' - literal text\n\t   '' - single quote\n\n\t   @param  format    string - the desired format of the date\n\t   @param  date      Date - the date value to format\n\t   @param  settings  Object - attributes include:\n\t                     dayNamesShort    string[7] - abbreviated names of the days from Sunday (optional)\n\t                     dayNames         string[7] - names of the days from Sunday (optional)\n\t                     monthNamesShort  string[12] - abbreviated names of the months (optional)\n\t                     monthNames       string[12] - names of the months (optional)\n\t   @return  string - the date in the above format */\n\tformatDate: function (format, date, settings) {\n\t\tif (!date)\n\t\t\treturn '';\n\t\tvar dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort;\n\t\tvar dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames;\n\t\tvar monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort;\n\t\tvar monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames;\n\t\t// Check whether a format character is doubled\n\t\tvar lookAhead = function(match) {\n\t\t\tvar matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) == match);\n\t\t\tif (matches)\n\t\t\t\tiFormat++;\n\t\t\treturn matches;\n\t\t};\n\t\t// Format a number, with leading zero if necessary\n\t\tvar formatNumber = function(match, value, len) {\n\t\t\tvar num = '' + value;\n\t\t\tif (lookAhead(match))\n\t\t\t\twhile (num.length < len)\n\t\t\t\t\tnum = '0' + num;\n\t\t\treturn num;\n\t\t};\n\t\t// Format a name, short or long as requested\n\t\tvar formatName = function(match, value, shortNames, longNames) {\n\t\t\treturn (lookAhead(match) ? longNames[value] : shortNames[value]);\n\t\t};\n\t\tvar output = '';\n\t\tvar literal = false;\n\t\tif (date)\n\t\t\tfor (var iFormat = 0; iFormat < format.length; iFormat++) {\n\t\t\t\tif (literal)\n\t\t\t\t\tif (format.charAt(iFormat) == \"'\" && !lookAhead(\"'\"))\n\t\t\t\t\t\tliteral = false;\n\t\t\t\t\telse\n\t\t\t\t\t\toutput += format.charAt(iFormat);\n\t\t\t\telse\n\t\t\t\t\tswitch (format.charAt(iFormat)) {\n\t\t\t\t\t\tcase 'd':\n\t\t\t\t\t\t\toutput += formatNumber('d', date.getDate(), 2);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase 'D':\n\t\t\t\t\t\t\toutput += formatName('D', date.getDay(), dayNamesShort, dayNames);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase 'o':\n\t\t\t\t\t\t\toutput += formatNumber('o',\n\t\t\t\t\t\t\t\tMath.round((new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / 86400000), 3);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase 'm':\n\t\t\t\t\t\t\toutput += formatNumber('m', date.getMonth() + 1, 2);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase 'M':\n\t\t\t\t\t\t\toutput += formatName('M', date.getMonth(), monthNamesShort, monthNames);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase 'y':\n\t\t\t\t\t\t\toutput += (lookAhead('y') ? date.getFullYear() :\n\t\t\t\t\t\t\t\t(date.getYear() % 100 < 10 ? '0' : '') + date.getYear() % 100);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase '@':\n\t\t\t\t\t\t\toutput += date.getTime();\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase '!':\n\t\t\t\t\t\t\toutput += date.getTime() * 10000 + this._ticksTo1970;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"'\":\n\t\t\t\t\t\t\tif (lookAhead(\"'\"))\n\t\t\t\t\t\t\t\toutput += \"'\";\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tliteral = true;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\toutput += format.charAt(iFormat);\n\t\t\t\t\t}\n\t\t\t}\n\t\treturn output;\n\t},\n\n\t/* Extract all possible characters from the date format. */\n\t_possibleChars: function (format) {\n\t\tvar chars = '';\n\t\tvar literal = false;\n\t\t// Check whether a format character is doubled\n\t\tvar lookAhead = function(match) {\n\t\t\tvar matches = (iFormat + 1 < format.length && format.charAt(iFormat + 1) == match);\n\t\t\tif (matches)\n\t\t\t\tiFormat++;\n\t\t\treturn matches;\n\t\t};\n\t\tfor (var iFormat = 0; iFormat < format.length; iFormat++)\n\t\t\tif (literal)\n\t\t\t\tif (format.charAt(iFormat) == \"'\" && !lookAhead(\"'\"))\n\t\t\t\t\tliteral = false;\n\t\t\t\telse\n\t\t\t\t\tchars += format.charAt(iFormat);\n\t\t\telse\n\t\t\t\tswitch (format.charAt(iFormat)) {\n\t\t\t\t\tcase 'd': case 'm': case 'y': case '@':\n\t\t\t\t\t\tchars += '0123456789';\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase 'D': case 'M':\n\t\t\t\t\t\treturn null; // Accept anything\n\t\t\t\t\tcase \"'\":\n\t\t\t\t\t\tif (lookAhead(\"'\"))\n\t\t\t\t\t\t\tchars += \"'\";\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tliteral = true;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tchars += format.charAt(iFormat);\n\t\t\t\t}\n\t\treturn chars;\n\t},\n\n\t/* Get a setting value, defaulting if necessary. */\n\t_get: function(inst, name) {\n\t\treturn inst.settings[name] !== undefined ?\n\t\t\tinst.settings[name] : this._defaults[name];\n\t},\n\n\t/* Parse existing date and initialise date picker. */\n\t_setDateFromField: function(inst, noDefault) {\n\t\tif (inst.input.val() == inst.lastVal) {\n\t\t\treturn;\n\t\t}\n\t\tvar dateFormat = this._get(inst, 'dateFormat');\n\t\tvar dates = inst.lastVal = inst.input ? inst.input.val() : null;\n\t\tvar date, defaultDate;\n\t\tdate = defaultDate = this._getDefaultDate(inst);\n\t\tvar settings = this._getFormatConfig(inst);\n\t\ttry {\n\t\t\tdate = this.parseDate(dateFormat, dates, settings) || defaultDate;\n\t\t} catch (event) {\n\t\t\tthis.log(event);\n\t\t\tdates = (noDefault ? '' : dates);\n\t\t}\n\t\tinst.selectedDay = date.getDate();\n\t\tinst.drawMonth = inst.selectedMonth = date.getMonth();\n\t\tinst.drawYear = inst.selectedYear = date.getFullYear();\n\t\tinst.currentDay = (dates ? date.getDate() : 0);\n\t\tinst.currentMonth = (dates ? date.getMonth() : 0);\n\t\tinst.currentYear = (dates ? date.getFullYear() : 0);\n\t\tthis._adjustInstDate(inst);\n\t},\n\n\t/* Retrieve the default date shown on opening. */\n\t_getDefaultDate: function(inst) {\n\t\treturn this._restrictMinMax(inst,\n\t\t\tthis._determineDate(inst, this._get(inst, 'defaultDate'), new Date()));\n\t},\n\n\t/* A date may be specified as an exact value or a relative one. */\n\t_determineDate: function(inst, date, defaultDate) {\n\t\tvar offsetNumeric = function(offset) {\n\t\t\tvar date = new Date();\n\t\t\tdate.setDate(date.getDate() + offset);\n\t\t\treturn date;\n\t\t};\n\t\tvar offsetString = function(offset) {\n\t\t\ttry {\n\t\t\t\treturn $.datepicker.parseDate($.datepicker._get(inst, 'dateFormat'),\n\t\t\t\t\toffset, $.datepicker._getFormatConfig(inst));\n\t\t\t}\n\t\t\tcatch (e) {\n\t\t\t\t// Ignore\n\t\t\t}\n\t\t\tvar date = (offset.toLowerCase().match(/^c/) ?\n\t\t\t\t$.datepicker._getDate(inst) : null) || new Date();\n\t\t\tvar year = date.getFullYear();\n\t\t\tvar month = date.getMonth();\n\t\t\tvar day = date.getDate();\n\t\t\tvar pattern = /([+-]?[0-9]+)\\s*(d|D|w|W|m|M|y|Y)?/g;\n\t\t\tvar matches = pattern.exec(offset);\n\t\t\twhile (matches) {\n\t\t\t\tswitch (matches[2] || 'd') {\n\t\t\t\t\tcase 'd' : case 'D' :\n\t\t\t\t\t\tday += parseInt(matches[1],10); break;\n\t\t\t\t\tcase 'w' : case 'W' :\n\t\t\t\t\t\tday += parseInt(matches[1],10) * 7; break;\n\t\t\t\t\tcase 'm' : case 'M' :\n\t\t\t\t\t\tmonth += parseInt(matches[1],10);\n\t\t\t\t\t\tday = Math.min(day, $.datepicker._getDaysInMonth(year, month));\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase 'y': case 'Y' :\n\t\t\t\t\t\tyear += parseInt(matches[1],10);\n\t\t\t\t\t\tday = Math.min(day, $.datepicker._getDaysInMonth(year, month));\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tmatches = pattern.exec(offset);\n\t\t\t}\n\t\t\treturn new Date(year, month, day);\n\t\t};\n\t\tvar newDate = (date == null || date === '' ? defaultDate : (typeof date == 'string' ? offsetString(date) :\n\t\t\t(typeof date == 'number' ? (isNaN(date) ? defaultDate : offsetNumeric(date)) : new Date(date.getTime()))));\n\t\tnewDate = (newDate && newDate.toString() == 'Invalid Date' ? defaultDate : newDate);\n\t\tif (newDate) {\n\t\t\tnewDate.setHours(0);\n\t\t\tnewDate.setMinutes(0);\n\t\t\tnewDate.setSeconds(0);\n\t\t\tnewDate.setMilliseconds(0);\n\t\t}\n\t\treturn this._daylightSavingAdjust(newDate);\n\t},\n\n\t/* Handle switch to/from daylight saving.\n\t   Hours may be non-zero on daylight saving cut-over:\n\t   > 12 when midnight changeover, but then cannot generate\n\t   midnight datetime, so jump to 1AM, otherwise reset.\n\t   @param  date  (Date) the date to check\n\t   @return  (Date) the corrected date */\n\t_daylightSavingAdjust: function(date) {\n\t\tif (!date) return null;\n\t\tdate.setHours(date.getHours() > 12 ? date.getHours() + 2 : 0);\n\t\treturn date;\n\t},\n\n\t/* Set the date(s) directly. */\n\t_setDate: function(inst, date, noChange) {\n\t\tvar clear = !date;\n\t\tvar origMonth = inst.selectedMonth;\n\t\tvar origYear = inst.selectedYear;\n\t\tvar newDate = this._restrictMinMax(inst, this._determineDate(inst, date, new Date()));\n\t\tinst.selectedDay = inst.currentDay = newDate.getDate();\n\t\tinst.drawMonth = inst.selectedMonth = inst.currentMonth = newDate.getMonth();\n\t\tinst.drawYear = inst.selectedYear = inst.currentYear = newDate.getFullYear();\n\t\tif ((origMonth != inst.selectedMonth || origYear != inst.selectedYear) && !noChange)\n\t\t\tthis._notifyChange(inst);\n\t\tthis._adjustInstDate(inst);\n\t\tif (inst.input) {\n\t\t\tinst.input.val(clear ? '' : this._formatDate(inst));\n\t\t}\n\t},\n\n\t/* Retrieve the date(s) directly. */\n\t_getDate: function(inst) {\n\t\tvar startDate = (!inst.currentYear || (inst.input && inst.input.val() == '') ? null :\n\t\t\tthis._daylightSavingAdjust(new Date(\n\t\t\tinst.currentYear, inst.currentMonth, inst.currentDay)));\n\t\t\treturn startDate;\n\t},\n\n\t/* Attach the onxxx handlers.  These are declared statically so\n\t * they work with static code transformers like Caja.\n\t */\n\t_attachHandlers: function(inst) {\n\t\tvar stepMonths = this._get(inst, 'stepMonths');\n\t\tvar id = '#' + inst.id.replace( /\\\\\\\\/g, \"\\\\\" );\n\t\tinst.dpDiv.find('[data-handler]').map(function () {\n\t\t\tvar handler = {\n\t\t\t\tprev: function () {\n\t\t\t\t\twindow['DP_jQuery_' + dpuuid].datepicker._adjustDate(id, -stepMonths, 'M');\n\t\t\t\t},\n\t\t\t\tnext: function () {\n\t\t\t\t\twindow['DP_jQuery_' + dpuuid].datepicker._adjustDate(id, +stepMonths, 'M');\n\t\t\t\t},\n\t\t\t\thide: function () {\n\t\t\t\t\twindow['DP_jQuery_' + dpuuid].datepicker._hideDatepicker();\n\t\t\t\t},\n\t\t\t\ttoday: function () {\n\t\t\t\t\twindow['DP_jQuery_' + dpuuid].datepicker._gotoToday(id);\n\t\t\t\t},\n\t\t\t\tselectDay: function () {\n\t\t\t\t\twindow['DP_jQuery_' + dpuuid].datepicker._selectDay(id, +this.getAttribute('data-month'), +this.getAttribute('data-year'), this);\n\t\t\t\t\treturn false;\n\t\t\t\t},\n\t\t\t\tselectMonth: function () {\n\t\t\t\t\twindow['DP_jQuery_' + dpuuid].datepicker._selectMonthYear(id, this, 'M');\n\t\t\t\t\treturn false;\n\t\t\t\t},\n\t\t\t\tselectYear: function () {\n\t\t\t\t\twindow['DP_jQuery_' + dpuuid].datepicker._selectMonthYear(id, this, 'Y');\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t};\n\t\t\t$(this).bind(this.getAttribute('data-event'), handler[this.getAttribute('data-handler')]);\n\t\t});\n\t},\n\n\t/* Generate the HTML for the current state of the date picker. */\n\t_generateHTML: function(inst) {\n\t\tvar today = new Date();\n\t\ttoday = this._daylightSavingAdjust(\n\t\t\tnew Date(today.getFullYear(), today.getMonth(), today.getDate())); // clear time\n\t\tvar isRTL = this._get(inst, 'isRTL');\n\t\tvar showButtonPanel = this._get(inst, 'showButtonPanel');\n\t\tvar hideIfNoPrevNext = this._get(inst, 'hideIfNoPrevNext');\n\t\tvar navigationAsDateFormat = this._get(inst, 'navigationAsDateFormat');\n\t\tvar numMonths = this._getNumberOfMonths(inst);\n\t\tvar showCurrentAtPos = this._get(inst, 'showCurrentAtPos');\n\t\tvar stepMonths = this._get(inst, 'stepMonths');\n\t\tvar isMultiMonth = (numMonths[0] != 1 || numMonths[1] != 1);\n\t\tvar currentDate = this._daylightSavingAdjust((!inst.currentDay ? new Date(9999, 9, 9) :\n\t\t\tnew Date(inst.currentYear, inst.currentMonth, inst.currentDay)));\n\t\tvar minDate = this._getMinMaxDate(inst, 'min');\n\t\tvar maxDate = this._getMinMaxDate(inst, 'max');\n\t\tvar drawMonth = inst.drawMonth - showCurrentAtPos;\n\t\tvar drawYear = inst.drawYear;\n\t\tif (drawMonth < 0) {\n\t\t\tdrawMonth += 12;\n\t\t\tdrawYear--;\n\t\t}\n\t\tif (maxDate) {\n\t\t\tvar maxDraw = this._daylightSavingAdjust(new Date(maxDate.getFullYear(),\n\t\t\t\tmaxDate.getMonth() - (numMonths[0] * numMonths[1]) + 1, maxDate.getDate()));\n\t\t\tmaxDraw = (minDate && maxDraw < minDate ? minDate : maxDraw);\n\t\t\twhile (this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1)) > maxDraw) {\n\t\t\t\tdrawMonth--;\n\t\t\t\tif (drawMonth < 0) {\n\t\t\t\t\tdrawMonth = 11;\n\t\t\t\t\tdrawYear--;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tinst.drawMonth = drawMonth;\n\t\tinst.drawYear = drawYear;\n\t\tvar prevText = this._get(inst, 'prevText');\n\t\tprevText = (!navigationAsDateFormat ? prevText : this.formatDate(prevText,\n\t\t\tthis._daylightSavingAdjust(new Date(drawYear, drawMonth - stepMonths, 1)),\n\t\t\tthis._getFormatConfig(inst)));\n\t\tvar prev = (this._canAdjustMonth(inst, -1, drawYear, drawMonth) ?\n\t\t\t'<a class=\"ui-datepicker-prev ui-corner-all\" data-handler=\"prev\" data-event=\"click\"' +\n\t\t\t' title=\"' + prevText + '\"><span class=\"ui-icon ui-icon-circle-triangle-' + ( isRTL ? 'e' : 'w') + '\">' + prevText + '</span></a>' :\n\t\t\t(hideIfNoPrevNext ? '' : '<a class=\"ui-datepicker-prev ui-corner-all ui-state-disabled\" title=\"'+ prevText +'\"><span class=\"ui-icon ui-icon-circle-triangle-' + ( isRTL ? 'e' : 'w') + '\">' + prevText + '</span></a>'));\n\t\tvar nextText = this._get(inst, 'nextText');\n\t\tnextText = (!navigationAsDateFormat ? nextText : this.formatDate(nextText,\n\t\t\tthis._daylightSavingAdjust(new Date(drawYear, drawMonth + stepMonths, 1)),\n\t\t\tthis._getFormatConfig(inst)));\n\t\tvar next = (this._canAdjustMonth(inst, +1, drawYear, drawMonth) ?\n\t\t\t'<a class=\"ui-datepicker-next ui-corner-all\" data-handler=\"next\" data-event=\"click\"' +\n\t\t\t' title=\"' + nextText + '\"><span class=\"ui-icon ui-icon-circle-triangle-' + ( isRTL ? 'w' : 'e') + '\">' + nextText + '</span></a>' :\n\t\t\t(hideIfNoPrevNext ? '' : '<a class=\"ui-datepicker-next ui-corner-all ui-state-disabled\" title=\"'+ nextText + '\"><span class=\"ui-icon ui-icon-circle-triangle-' + ( isRTL ? 'w' : 'e') + '\">' + nextText + '</span></a>'));\n\t\tvar currentText = this._get(inst, 'currentText');\n\t\tvar gotoDate = (this._get(inst, 'gotoCurrent') && inst.currentDay ? currentDate : today);\n\t\tcurrentText = (!navigationAsDateFormat ? currentText :\n\t\t\tthis.formatDate(currentText, gotoDate, this._getFormatConfig(inst)));\n\t\tvar controls = (!inst.inline ? '<button type=\"button\" class=\"ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all\" data-handler=\"hide\" data-event=\"click\">' +\n\t\t\tthis._get(inst, 'closeText') + '</button>' : '');\n\t\tvar buttonPanel = (showButtonPanel) ? '<div class=\"ui-datepicker-buttonpane ui-widget-content\">' + (isRTL ? controls : '') +\n\t\t\t(this._isInRange(inst, gotoDate) ? '<button type=\"button\" class=\"ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all\" data-handler=\"today\" data-event=\"click\"' +\n\t\t\t'>' + currentText + '</button>' : '') + (isRTL ? '' : controls) + '</div>' : '';\n\t\tvar firstDay = parseInt(this._get(inst, 'firstDay'),10);\n\t\tfirstDay = (isNaN(firstDay) ? 0 : firstDay);\n\t\tvar showWeek = this._get(inst, 'showWeek');\n\t\tvar dayNames = this._get(inst, 'dayNames');\n\t\tvar dayNamesShort = this._get(inst, 'dayNamesShort');\n\t\tvar dayNamesMin = this._get(inst, 'dayNamesMin');\n\t\tvar monthNames = this._get(inst, 'monthNames');\n\t\tvar monthNamesShort = this._get(inst, 'monthNamesShort');\n\t\tvar beforeShowDay = this._get(inst, 'beforeShowDay');\n\t\tvar showOtherMonths = this._get(inst, 'showOtherMonths');\n\t\tvar selectOtherMonths = this._get(inst, 'selectOtherMonths');\n\t\tvar calculateWeek = this._get(inst, 'calculateWeek') || this.iso8601Week;\n\t\tvar defaultDate = this._getDefaultDate(inst);\n\t\tvar html = '';\n\t\tfor (var row = 0; row < numMonths[0]; row++) {\n\t\t\tvar group = '';\n\t\t\tthis.maxRows = 4;\n\t\t\tfor (var col = 0; col < numMonths[1]; col++) {\n\t\t\t\tvar selectedDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, inst.selectedDay));\n\t\t\t\tvar cornerClass = ' ui-corner-all';\n\t\t\t\tvar calender = '';\n\t\t\t\tif (isMultiMonth) {\n\t\t\t\t\tcalender += '<div class=\"ui-datepicker-group';\n\t\t\t\t\tif (numMonths[1] > 1)\n\t\t\t\t\t\tswitch (col) {\n\t\t\t\t\t\t\tcase 0: calender += ' ui-datepicker-group-first';\n\t\t\t\t\t\t\t\tcornerClass = ' ui-corner-' + (isRTL ? 'right' : 'left'); break;\n\t\t\t\t\t\t\tcase numMonths[1]-1: calender += ' ui-datepicker-group-last';\n\t\t\t\t\t\t\t\tcornerClass = ' ui-corner-' + (isRTL ? 'left' : 'right'); break;\n\t\t\t\t\t\t\tdefault: calender += ' ui-datepicker-group-middle'; cornerClass = ''; break;\n\t\t\t\t\t\t}\n\t\t\t\t\tcalender += '\">';\n\t\t\t\t}\n\t\t\t\tcalender += '<div class=\"ui-datepicker-header ui-widget-header ui-helper-clearfix' + cornerClass + '\">' +\n\t\t\t\t\t(/all|left/.test(cornerClass) && row == 0 ? (isRTL ? next : prev) : '') +\n\t\t\t\t\t(/all|right/.test(cornerClass) && row == 0 ? (isRTL ? prev : next) : '') +\n\t\t\t\t\tthis._generateMonthYearHeader(inst, drawMonth, drawYear, minDate, maxDate,\n\t\t\t\t\trow > 0 || col > 0, monthNames, monthNamesShort) + // draw month headers\n\t\t\t\t\t'</div><table class=\"ui-datepicker-calendar\"><thead>' +\n\t\t\t\t\t'<tr>';\n\t\t\t\tvar thead = (showWeek ? '<th class=\"ui-datepicker-week-col\">' + this._get(inst, 'weekHeader') + '</th>' : '');\n\t\t\t\tfor (var dow = 0; dow < 7; dow++) { // days of the week\n\t\t\t\t\tvar day = (dow + firstDay) % 7;\n\t\t\t\t\tthead += '<th' + ((dow + firstDay + 6) % 7 >= 5 ? ' class=\"ui-datepicker-week-end\"' : '') + '>' +\n\t\t\t\t\t\t'<span title=\"' + dayNames[day] + '\">' + dayNamesMin[day] + '</span></th>';\n\t\t\t\t}\n\t\t\t\tcalender += thead + '</tr></thead><tbody>';\n\t\t\t\tvar daysInMonth = this._getDaysInMonth(drawYear, drawMonth);\n\t\t\t\tif (drawYear == inst.selectedYear && drawMonth == inst.selectedMonth)\n\t\t\t\t\tinst.selectedDay = Math.min(inst.selectedDay, daysInMonth);\n\t\t\t\tvar leadDays = (this._getFirstDayOfMonth(drawYear, drawMonth) - firstDay + 7) % 7;\n\t\t\t\tvar curRows = Math.ceil((leadDays + daysInMonth) / 7); // calculate the number of rows to generate\n\t\t\t\tvar numRows = (isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows); //If multiple months, use the higher number of rows (see #7043)\n\t\t\t\tthis.maxRows = numRows;\n\t\t\t\tvar printDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1 - leadDays));\n\t\t\t\tfor (var dRow = 0; dRow < numRows; dRow++) { // create date picker rows\n\t\t\t\t\tcalender += '<tr>';\n\t\t\t\t\tvar tbody = (!showWeek ? '' : '<td class=\"ui-datepicker-week-col\">' +\n\t\t\t\t\t\tthis._get(inst, 'calculateWeek')(printDate) + '</td>');\n\t\t\t\t\tfor (var dow = 0; dow < 7; dow++) { // create date picker days\n\t\t\t\t\t\tvar daySettings = (beforeShowDay ?\n\t\t\t\t\t\t\tbeforeShowDay.apply((inst.input ? inst.input[0] : null), [printDate]) : [true, '']);\n\t\t\t\t\t\tvar otherMonth = (printDate.getMonth() != drawMonth);\n\t\t\t\t\t\tvar unselectable = (otherMonth && !selectOtherMonths) || !daySettings[0] ||\n\t\t\t\t\t\t\t(minDate && printDate < minDate) || (maxDate && printDate > maxDate);\n\t\t\t\t\t\ttbody += '<td class=\"' +\n\t\t\t\t\t\t\t((dow + firstDay + 6) % 7 >= 5 ? ' ui-datepicker-week-end' : '') + // highlight weekends\n\t\t\t\t\t\t\t(otherMonth ? ' ui-datepicker-other-month' : '') + // highlight days from other months\n\t\t\t\t\t\t\t((printDate.getTime() == selectedDate.getTime() && drawMonth == inst.selectedMonth && inst._keyEvent) || // user pressed key\n\t\t\t\t\t\t\t(defaultDate.getTime() == printDate.getTime() && defaultDate.getTime() == selectedDate.getTime()) ?\n\t\t\t\t\t\t\t// or defaultDate is current printedDate and defaultDate is selectedDate\n\t\t\t\t\t\t\t' ' + this._dayOverClass : '') + // highlight selected day\n\t\t\t\t\t\t\t(unselectable ? ' ' + this._unselectableClass + ' ui-state-disabled': '') +  // highlight unselectable days\n\t\t\t\t\t\t\t(otherMonth && !showOtherMonths ? '' : ' ' + daySettings[1] + // highlight custom dates\n\t\t\t\t\t\t\t(printDate.getTime() == currentDate.getTime() ? ' ' + this._currentClass : '') + // highlight selected day\n\t\t\t\t\t\t\t(printDate.getTime() == today.getTime() ? ' ui-datepicker-today' : '')) + '\"' + // highlight today (if different)\n\t\t\t\t\t\t\t((!otherMonth || showOtherMonths) && daySettings[2] ? ' title=\"' + daySettings[2] + '\"' : '') + // cell title\n\t\t\t\t\t\t\t(unselectable ? '' : ' data-handler=\"selectDay\" data-event=\"click\" data-month=\"' + printDate.getMonth() + '\" data-year=\"' + printDate.getFullYear() + '\"') + '>' + // actions\n\t\t\t\t\t\t\t(otherMonth && !showOtherMonths ? '&#xa0;' : // display for other months\n\t\t\t\t\t\t\t(unselectable ? '<span class=\"ui-state-default\">' + printDate.getDate() + '</span>' : '<a class=\"ui-state-default' +\n\t\t\t\t\t\t\t(printDate.getTime() == today.getTime() ? ' ui-state-highlight' : '') +\n\t\t\t\t\t\t\t(printDate.getTime() == currentDate.getTime() ? ' ui-state-active' : '') + // highlight selected day\n\t\t\t\t\t\t\t(otherMonth ? ' ui-priority-secondary' : '') + // distinguish dates from other months\n\t\t\t\t\t\t\t'\" href=\"#\">' + printDate.getDate() + '</a>')) + '</td>'; // display selectable date\n\t\t\t\t\t\tprintDate.setDate(printDate.getDate() + 1);\n\t\t\t\t\t\tprintDate = this._daylightSavingAdjust(printDate);\n\t\t\t\t\t}\n\t\t\t\t\tcalender += tbody + '</tr>';\n\t\t\t\t}\n\t\t\t\tdrawMonth++;\n\t\t\t\tif (drawMonth > 11) {\n\t\t\t\t\tdrawMonth = 0;\n\t\t\t\t\tdrawYear++;\n\t\t\t\t}\n\t\t\t\tcalender += '</tbody></table>' + (isMultiMonth ? '</div>' +\n\t\t\t\t\t\t\t((numMonths[0] > 0 && col == numMonths[1]-1) ? '<div class=\"ui-datepicker-row-break\"></div>' : '') : '');\n\t\t\t\tgroup += calender;\n\t\t\t}\n\t\t\thtml += group;\n\t\t}\n\t\thtml += buttonPanel + ($.ui.ie6 && !inst.inline ?\n\t\t\t'<iframe src=\"javascript:false;\" class=\"ui-datepicker-cover\" frameborder=\"0\"></iframe>' : '');\n\t\tinst._keyEvent = false;\n\t\treturn html;\n\t},\n\n\t/* Generate the month and year header. */\n\t_generateMonthYearHeader: function(inst, drawMonth, drawYear, minDate, maxDate,\n\t\t\tsecondary, monthNames, monthNamesShort) {\n\t\tvar changeMonth = this._get(inst, 'changeMonth');\n\t\tvar changeYear = this._get(inst, 'changeYear');\n\t\tvar showMonthAfterYear = this._get(inst, 'showMonthAfterYear');\n\t\tvar html = '<div class=\"ui-datepicker-title\">';\n\t\tvar monthHtml = '';\n\t\t// month selection\n\t\tif (secondary || !changeMonth)\n\t\t\tmonthHtml += '<span class=\"ui-datepicker-month\">' + monthNames[drawMonth] + '</span>';\n\t\telse {\n\t\t\tvar inMinYear = (minDate && minDate.getFullYear() == drawYear);\n\t\t\tvar inMaxYear = (maxDate && maxDate.getFullYear() == drawYear);\n\t\t\tmonthHtml += '<select class=\"ui-datepicker-month\" data-handler=\"selectMonth\" data-event=\"change\">';\n\t\t\tfor (var month = 0; month < 12; month++) {\n\t\t\t\tif ((!inMinYear || month >= minDate.getMonth()) &&\n\t\t\t\t\t\t(!inMaxYear || month <= maxDate.getMonth()))\n\t\t\t\t\tmonthHtml += '<option value=\"' + month + '\"' +\n\t\t\t\t\t\t(month == drawMonth ? ' selected=\"selected\"' : '') +\n\t\t\t\t\t\t'>' + monthNamesShort[month] + '</option>';\n\t\t\t}\n\t\t\tmonthHtml += '</select>';\n\t\t}\n\t\tif (!showMonthAfterYear)\n\t\t\thtml += monthHtml + (secondary || !(changeMonth && changeYear) ? '&#xa0;' : '');\n\t\t// year selection\n\t\tif ( !inst.yearshtml ) {\n\t\t\tinst.yearshtml = '';\n\t\t\tif (secondary || !changeYear)\n\t\t\t\thtml += '<span class=\"ui-datepicker-year\">' + drawYear + '</span>';\n\t\t\telse {\n\t\t\t\t// determine range of years to display\n\t\t\t\tvar years = this._get(inst, 'yearRange').split(':');\n\t\t\t\tvar thisYear = new Date().getFullYear();\n\t\t\t\tvar determineYear = function(value) {\n\t\t\t\t\tvar year = (value.match(/c[+-].*/) ? drawYear + parseInt(value.substring(1), 10) :\n\t\t\t\t\t\t(value.match(/[+-].*/) ? thisYear + parseInt(value, 10) :\n\t\t\t\t\t\tparseInt(value, 10)));\n\t\t\t\t\treturn (isNaN(year) ? thisYear : year);\n\t\t\t\t};\n\t\t\t\tvar year = determineYear(years[0]);\n\t\t\t\tvar endYear = Math.max(year, determineYear(years[1] || ''));\n\t\t\t\tyear = (minDate ? Math.max(year, minDate.getFullYear()) : year);\n\t\t\t\tendYear = (maxDate ? Math.min(endYear, maxDate.getFullYear()) : endYear);\n\t\t\t\tinst.yearshtml += '<select class=\"ui-datepicker-year\" data-handler=\"selectYear\" data-event=\"change\">';\n\t\t\t\tfor (; year <= endYear; year++) {\n\t\t\t\t\tinst.yearshtml += '<option value=\"' + year + '\"' +\n\t\t\t\t\t\t(year == drawYear ? ' selected=\"selected\"' : '') +\n\t\t\t\t\t\t'>' + year + '</option>';\n\t\t\t\t}\n\t\t\t\tinst.yearshtml += '</select>';\n\n\t\t\t\thtml += inst.yearshtml;\n\t\t\t\tinst.yearshtml = null;\n\t\t\t}\n\t\t}\n\t\thtml += this._get(inst, 'yearSuffix');\n\t\tif (showMonthAfterYear)\n\t\t\thtml += (secondary || !(changeMonth && changeYear) ? '&#xa0;' : '') + monthHtml;\n\t\thtml += '</div>'; // Close datepicker_header\n\t\treturn html;\n\t},\n\n\t/* Adjust one of the date sub-fields. */\n\t_adjustInstDate: function(inst, offset, period) {\n\t\tvar year = inst.drawYear + (period == 'Y' ? offset : 0);\n\t\tvar month = inst.drawMonth + (period == 'M' ? offset : 0);\n\t\tvar day = Math.min(inst.selectedDay, this._getDaysInMonth(year, month)) +\n\t\t\t(period == 'D' ? offset : 0);\n\t\tvar date = this._restrictMinMax(inst,\n\t\t\tthis._daylightSavingAdjust(new Date(year, month, day)));\n\t\tinst.selectedDay = date.getDate();\n\t\tinst.drawMonth = inst.selectedMonth = date.getMonth();\n\t\tinst.drawYear = inst.selectedYear = date.getFullYear();\n\t\tif (period == 'M' || period == 'Y')\n\t\t\tthis._notifyChange(inst);\n\t},\n\n\t/* Ensure a date is within any min/max bounds. */\n\t_restrictMinMax: function(inst, date) {\n\t\tvar minDate = this._getMinMaxDate(inst, 'min');\n\t\tvar maxDate = this._getMinMaxDate(inst, 'max');\n\t\tvar newDate = (minDate && date < minDate ? minDate : date);\n\t\tnewDate = (maxDate && newDate > maxDate ? maxDate : newDate);\n\t\treturn newDate;\n\t},\n\n\t/* Notify change of month/year. */\n\t_notifyChange: function(inst) {\n\t\tvar onChange = this._get(inst, 'onChangeMonthYear');\n\t\tif (onChange)\n\t\t\tonChange.apply((inst.input ? inst.input[0] : null),\n\t\t\t\t[inst.selectedYear, inst.selectedMonth + 1, inst]);\n\t},\n\n\t/* Determine the number of months to show. */\n\t_getNumberOfMonths: function(inst) {\n\t\tvar numMonths = this._get(inst, 'numberOfMonths');\n\t\treturn (numMonths == null ? [1, 1] : (typeof numMonths == 'number' ? [1, numMonths] : numMonths));\n\t},\n\n\t/* Determine the current maximum date - ensure no time components are set. */\n\t_getMinMaxDate: function(inst, minMax) {\n\t\treturn this._determineDate(inst, this._get(inst, minMax + 'Date'), null);\n\t},\n\n\t/* Find the number of days in a given month. */\n\t_getDaysInMonth: function(year, month) {\n\t\treturn 32 - this._daylightSavingAdjust(new Date(year, month, 32)).getDate();\n\t},\n\n\t/* Find the day of the week of the first of a month. */\n\t_getFirstDayOfMonth: function(year, month) {\n\t\treturn new Date(year, month, 1).getDay();\n\t},\n\n\t/* Determines if we should allow a \"next/prev\" month display change. */\n\t_canAdjustMonth: function(inst, offset, curYear, curMonth) {\n\t\tvar numMonths = this._getNumberOfMonths(inst);\n\t\tvar date = this._daylightSavingAdjust(new Date(curYear,\n\t\t\tcurMonth + (offset < 0 ? offset : numMonths[0] * numMonths[1]), 1));\n\t\tif (offset < 0)\n\t\t\tdate.setDate(this._getDaysInMonth(date.getFullYear(), date.getMonth()));\n\t\treturn this._isInRange(inst, date);\n\t},\n\n\t/* Is the given date in the accepted range? */\n\t_isInRange: function(inst, date) {\n\t\tvar minDate = this._getMinMaxDate(inst, 'min');\n\t\tvar maxDate = this._getMinMaxDate(inst, 'max');\n\t\treturn ((!minDate || date.getTime() >= minDate.getTime()) &&\n\t\t\t(!maxDate || date.getTime() <= maxDate.getTime()));\n\t},\n\n\t/* Provide the configuration settings for formatting/parsing. */\n\t_getFormatConfig: function(inst) {\n\t\tvar shortYearCutoff = this._get(inst, 'shortYearCutoff');\n\t\tshortYearCutoff = (typeof shortYearCutoff != 'string' ? shortYearCutoff :\n\t\t\tnew Date().getFullYear() % 100 + parseInt(shortYearCutoff, 10));\n\t\treturn {shortYearCutoff: shortYearCutoff,\n\t\t\tdayNamesShort: this._get(inst, 'dayNamesShort'), dayNames: this._get(inst, 'dayNames'),\n\t\t\tmonthNamesShort: this._get(inst, 'monthNamesShort'), monthNames: this._get(inst, 'monthNames')};\n\t},\n\n\t/* Format the given date for display. */\n\t_formatDate: function(inst, day, month, year) {\n\t\tif (!day) {\n\t\t\tinst.currentDay = inst.selectedDay;\n\t\t\tinst.currentMonth = inst.selectedMonth;\n\t\t\tinst.currentYear = inst.selectedYear;\n\t\t}\n\t\tvar date = (day ? (typeof day == 'object' ? day :\n\t\t\tthis._daylightSavingAdjust(new Date(year, month, day))) :\n\t\t\tthis._daylightSavingAdjust(new Date(inst.currentYear, inst.currentMonth, inst.currentDay)));\n\t\treturn this.formatDate(this._get(inst, 'dateFormat'), date, this._getFormatConfig(inst));\n\t}\n});\n\n/*\n * Bind hover events for datepicker elements.\n * Done via delegate so the binding only occurs once in the lifetime of the parent div.\n * Global instActive, set by _updateDatepicker allows the handlers to find their way back to the active picker.\n */\nfunction bindHover(dpDiv) {\n\tvar selector = 'button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a';\n\treturn dpDiv.delegate(selector, 'mouseout', function() {\n\t\t\t$(this).removeClass('ui-state-hover');\n\t\t\tif (this.className.indexOf('ui-datepicker-prev') != -1) $(this).removeClass('ui-datepicker-prev-hover');\n\t\t\tif (this.className.indexOf('ui-datepicker-next') != -1) $(this).removeClass('ui-datepicker-next-hover');\n\t\t})\n\t\t.delegate(selector, 'mouseover', function(){\n\t\t\tif (!$.datepicker._isDisabledDatepicker( instActive.inline ? dpDiv.parent()[0] : instActive.input[0])) {\n\t\t\t\t$(this).parents('.ui-datepicker-calendar').find('a').removeClass('ui-state-hover');\n\t\t\t\t$(this).addClass('ui-state-hover');\n\t\t\t\tif (this.className.indexOf('ui-datepicker-prev') != -1) $(this).addClass('ui-datepicker-prev-hover');\n\t\t\t\tif (this.className.indexOf('ui-datepicker-next') != -1) $(this).addClass('ui-datepicker-next-hover');\n\t\t\t}\n\t\t});\n}\n\n/* jQuery extend now ignores nulls! */\nfunction extendRemove(target, props) {\n\t$.extend(target, props);\n\tfor (var name in props)\n\t\tif (props[name] == null || props[name] == undefined)\n\t\t\ttarget[name] = props[name];\n\treturn target;\n};\n\n/* Invoke the datepicker functionality.\n   @param  options  string - a command, optionally followed by additional parameters or\n\t                Object - settings for attaching new datepicker functionality\n   @return  jQuery object */\n$.fn.datepicker = function(options){\n\n\t/* Verify an empty collection wasn't passed - Fixes #6976 */\n\tif ( !this.length ) {\n\t\treturn this;\n\t}\n\n\t/* Initialise the date picker. */\n\tif (!$.datepicker.initialized) {\n\t\t$(document).mousedown($.datepicker._checkExternalClick).\n\t\t\tfind(document.body).append($.datepicker.dpDiv);\n\t\t$.datepicker.initialized = true;\n\t}\n\n\tvar otherArgs = Array.prototype.slice.call(arguments, 1);\n\tif (typeof options == 'string' && (options == 'isDisabled' || options == 'getDate' || options == 'widget'))\n\t\treturn $.datepicker['_' + options + 'Datepicker'].\n\t\t\tapply($.datepicker, [this[0]].concat(otherArgs));\n\tif (options == 'option' && arguments.length == 2 && typeof arguments[1] == 'string')\n\t\treturn $.datepicker['_' + options + 'Datepicker'].\n\t\t\tapply($.datepicker, [this[0]].concat(otherArgs));\n\treturn this.each(function() {\n\t\ttypeof options == 'string' ?\n\t\t\t$.datepicker['_' + options + 'Datepicker'].\n\t\t\t\tapply($.datepicker, [this].concat(otherArgs)) :\n\t\t\t$.datepicker._attachDatepicker(this, options);\n\t});\n};\n\n$.datepicker = new Datepicker(); // singleton instance\n$.datepicker.initialized = false;\n$.datepicker.uuid = new Date().getTime();\n$.datepicker.version = \"1.9.2\";\n\n// Workaround for #4055\n// Add another global to avoid noConflict issues with inline event handlers\nwindow['DP_jQuery_' + dpuuid] = $;\n\n})(jQuery);\n\n(function( $, undefined ) {\n\nvar uiDialogClasses = \"ui-dialog ui-widget ui-widget-content ui-corner-all \",\n\tsizeRelatedOptions = {\n\t\tbuttons: true,\n\t\theight: true,\n\t\tmaxHeight: true,\n\t\tmaxWidth: true,\n\t\tminHeight: true,\n\t\tminWidth: true,\n\t\twidth: true\n\t},\n\tresizableRelatedOptions = {\n\t\tmaxHeight: true,\n\t\tmaxWidth: true,\n\t\tminHeight: true,\n\t\tminWidth: true\n\t};\n\n$.widget(\"ui.dialog\", {\n\tversion: \"1.9.2\",\n\toptions: {\n\t\tautoOpen: true,\n\t\tbuttons: {},\n\t\tcloseOnEscape: true,\n\t\tcloseText: \"close\",\n\t\tdialogClass: \"\",\n\t\tdraggable: true,\n\t\thide: null,\n\t\theight: \"auto\",\n\t\tmaxHeight: false,\n\t\tmaxWidth: false,\n\t\tminHeight: 150,\n\t\tminWidth: 150,\n\t\tmodal: false,\n\t\tposition: {\n\t\t\tmy: \"center\",\n\t\t\tat: \"center\",\n\t\t\tof: window,\n\t\t\tcollision: \"fit\",\n\t\t\t// ensure that the titlebar is never outside the document\n\t\t\tusing: function( pos ) {\n\t\t\t\tvar topOffset = $( this ).css( pos ).offset().top;\n\t\t\t\tif ( topOffset < 0 ) {\n\t\t\t\t\t$( this ).css( \"top\", pos.top - topOffset );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\tresizable: true,\n\t\tshow: null,\n\t\tstack: true,\n\t\ttitle: \"\",\n\t\twidth: 300,\n\t\tzIndex: 1000\n\t},\n\n\t_create: function() {\n\t\tthis.originalTitle = this.element.attr( \"title\" );\n\t\t// #5742 - .attr() might return a DOMElement\n\t\tif ( typeof this.originalTitle !== \"string\" ) {\n\t\t\tthis.originalTitle = \"\";\n\t\t}\n\t\tthis.oldPosition = {\n\t\t\tparent: this.element.parent(),\n\t\t\tindex: this.element.parent().children().index( this.element )\n\t\t};\n\t\tthis.options.title = this.options.title || this.originalTitle;\n\t\tvar that = this,\n\t\t\toptions = this.options,\n\n\t\t\ttitle = options.title || \"&#160;\",\n\t\t\tuiDialog,\n\t\t\tuiDialogTitlebar,\n\t\t\tuiDialogTitlebarClose,\n\t\t\tuiDialogTitle,\n\t\t\tuiDialogButtonPane;\n\n\t\t\tuiDialog = ( this.uiDialog = $( \"<div>\" ) )\n\t\t\t\t.addClass( uiDialogClasses + options.dialogClass )\n\t\t\t\t.css({\n\t\t\t\t\tdisplay: \"none\",\n\t\t\t\t\toutline: 0, // TODO: move to stylesheet\n\t\t\t\t\tzIndex: options.zIndex\n\t\t\t\t})\n\t\t\t\t// setting tabIndex makes the div focusable\n\t\t\t\t.attr( \"tabIndex\", -1)\n\t\t\t\t.keydown(function( event ) {\n\t\t\t\t\tif ( options.closeOnEscape && !event.isDefaultPrevented() && event.keyCode &&\n\t\t\t\t\t\t\tevent.keyCode === $.ui.keyCode.ESCAPE ) {\n\t\t\t\t\t\tthat.close( event );\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.mousedown(function( event ) {\n\t\t\t\t\tthat.moveToTop( false, event );\n\t\t\t\t})\n\t\t\t\t.appendTo( \"body\" );\n\n\t\t\tthis.element\n\t\t\t\t.show()\n\t\t\t\t.removeAttr( \"title\" )\n\t\t\t\t.addClass( \"ui-dialog-content ui-widget-content\" )\n\t\t\t\t.appendTo( uiDialog );\n\n\t\t\tuiDialogTitlebar = ( this.uiDialogTitlebar = $( \"<div>\" ) )\n\t\t\t\t.addClass( \"ui-dialog-titlebar  ui-widget-header  \" +\n\t\t\t\t\t\"ui-corner-all  ui-helper-clearfix\" )\n\t\t\t\t.bind( \"mousedown\", function() {\n\t\t\t\t\t// Dialog isn't getting focus when dragging (#8063)\n\t\t\t\t\tuiDialog.focus();\n\t\t\t\t})\n\t\t\t\t.prependTo( uiDialog );\n\n\t\t\tuiDialogTitlebarClose = $( \"<a href='#'></a>\" )\n\t\t\t\t.addClass( \"ui-dialog-titlebar-close  ui-corner-all\" )\n\t\t\t\t.attr( \"role\", \"button\" )\n\t\t\t\t.click(function( event ) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tthat.close( event );\n\t\t\t\t})\n\t\t\t\t.appendTo( uiDialogTitlebar );\n\n\t\t\t( this.uiDialogTitlebarCloseText = $( \"<span>\" ) )\n\t\t\t\t.addClass( \"ui-icon ui-icon-closethick\" )\n\t\t\t\t.text( options.closeText )\n\t\t\t\t.appendTo( uiDialogTitlebarClose );\n\n\t\t\tuiDialogTitle = $( \"<span>\" )\n\t\t\t\t.uniqueId()\n\t\t\t\t.addClass( \"ui-dialog-title\" )\n\t\t\t\t.html( title )\n\t\t\t\t.prependTo( uiDialogTitlebar );\n\n\t\t\tuiDialogButtonPane = ( this.uiDialogButtonPane = $( \"<div>\" ) )\n\t\t\t\t.addClass( \"ui-dialog-buttonpane ui-widget-content ui-helper-clearfix\" );\n\n\t\t\t( this.uiButtonSet = $( \"<div>\" ) )\n\t\t\t\t.addClass( \"ui-dialog-buttonset\" )\n\t\t\t\t.appendTo( uiDialogButtonPane );\n\n\t\tuiDialog.attr({\n\t\t\trole: \"dialog\",\n\t\t\t\"aria-labelledby\": uiDialogTitle.attr( \"id\" )\n\t\t});\n\n\t\tuiDialogTitlebar.find( \"*\" ).add( uiDialogTitlebar ).disableSelection();\n\t\tthis._hoverable( uiDialogTitlebarClose );\n\t\tthis._focusable( uiDialogTitlebarClose );\n\n\t\tif ( options.draggable && $.fn.draggable ) {\n\t\t\tthis._makeDraggable();\n\t\t}\n\t\tif ( options.resizable && $.fn.resizable ) {\n\t\t\tthis._makeResizable();\n\t\t}\n\n\t\tthis._createButtons( options.buttons );\n\t\tthis._isOpen = false;\n\n\t\tif ( $.fn.bgiframe ) {\n\t\t\tuiDialog.bgiframe();\n\t\t}\n\n\t\t// prevent tabbing out of modal dialogs\n\t\tthis._on( uiDialog, { keydown: function( event ) {\n\t\t\tif ( !options.modal || event.keyCode !== $.ui.keyCode.TAB ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tvar tabbables = $( \":tabbable\", uiDialog ),\n\t\t\t\tfirst = tabbables.filter( \":first\" ),\n\t\t\t\tlast  = tabbables.filter( \":last\" );\n\n\t\t\tif ( event.target === last[0] && !event.shiftKey ) {\n\t\t\t\tfirst.focus( 1 );\n\t\t\t\treturn false;\n\t\t\t} else if ( event.target === first[0] && event.shiftKey ) {\n\t\t\t\tlast.focus( 1 );\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}});\n\t},\n\n\t_init: function() {\n\t\tif ( this.options.autoOpen ) {\n\t\t\tthis.open();\n\t\t}\n\t},\n\n\t_destroy: function() {\n\t\tvar next,\n\t\t\toldPosition = this.oldPosition;\n\n\t\tif ( this.overlay ) {\n\t\t\tthis.overlay.destroy();\n\t\t}\n\t\tthis.uiDialog.hide();\n\t\tthis.element\n\t\t\t.removeClass( \"ui-dialog-content ui-widget-content\" )\n\t\t\t.hide()\n\t\t\t.appendTo( \"body\" );\n\t\tthis.uiDialog.remove();\n\n\t\tif ( this.originalTitle ) {\n\t\t\tthis.element.attr( \"title\", this.originalTitle );\n\t\t}\n\n\t\tnext = oldPosition.parent.children().eq( oldPosition.index );\n\t\t// Don't try to place the dialog next to itself (#8613)\n\t\tif ( next.length && next[ 0 ] !== this.element[ 0 ] ) {\n\t\t\tnext.before( this.element );\n\t\t} else {\n\t\t\toldPosition.parent.append( this.element );\n\t\t}\n\t},\n\n\twidget: function() {\n\t\treturn this.uiDialog;\n\t},\n\n\tclose: function( event ) {\n\t\tvar that = this,\n\t\t\tmaxZ, thisZ;\n\n\t\tif ( !this._isOpen ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( false === this._trigger( \"beforeClose\", event ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis._isOpen = false;\n\n\t\tif ( this.overlay ) {\n\t\t\tthis.overlay.destroy();\n\t\t}\n\n\t\tif ( this.options.hide ) {\n\t\t\tthis._hide( this.uiDialog, this.options.hide, function() {\n\t\t\t\tthat._trigger( \"close\", event );\n\t\t\t});\n\t\t} else {\n\t\t\tthis.uiDialog.hide();\n\t\t\tthis._trigger( \"close\", event );\n\t\t}\n\n\t\t$.ui.dialog.overlay.resize();\n\n\t\t// adjust the maxZ to allow other modal dialogs to continue to work (see #4309)\n\t\tif ( this.options.modal ) {\n\t\t\tmaxZ = 0;\n\t\t\t$( \".ui-dialog\" ).each(function() {\n\t\t\t\tif ( this !== that.uiDialog[0] ) {\n\t\t\t\t\tthisZ = $( this ).css( \"z-index\" );\n\t\t\t\t\tif ( !isNaN( thisZ ) ) {\n\t\t\t\t\t\tmaxZ = Math.max( maxZ, thisZ );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t\t$.ui.dialog.maxZ = maxZ;\n\t\t}\n\n\t\treturn this;\n\t},\n\n\tisOpen: function() {\n\t\treturn this._isOpen;\n\t},\n\n\t// the force parameter allows us to move modal dialogs to their correct\n\t// position on open\n\tmoveToTop: function( force, event ) {\n\t\tvar options = this.options,\n\t\t\tsaveScroll;\n\n\t\tif ( ( options.modal && !force ) ||\n\t\t\t\t( !options.stack && !options.modal ) ) {\n\t\t\treturn this._trigger( \"focus\", event );\n\t\t}\n\n\t\tif ( options.zIndex > $.ui.dialog.maxZ ) {\n\t\t\t$.ui.dialog.maxZ = options.zIndex;\n\t\t}\n\t\tif ( this.overlay ) {\n\t\t\t$.ui.dialog.maxZ += 1;\n\t\t\t$.ui.dialog.overlay.maxZ = $.ui.dialog.maxZ;\n\t\t\tthis.overlay.$el.css( \"z-index\", $.ui.dialog.overlay.maxZ );\n\t\t}\n\n\t\t// Save and then restore scroll\n\t\t// Opera 9.5+ resets when parent z-index is changed.\n\t\t// http://bugs.jqueryui.com/ticket/3193\n\t\tsaveScroll = {\n\t\t\tscrollTop: this.element.scrollTop(),\n\t\t\tscrollLeft: this.element.scrollLeft()\n\t\t};\n\t\t$.ui.dialog.maxZ += 1;\n\t\tthis.uiDialog.css( \"z-index\", $.ui.dialog.maxZ );\n\t\tthis.element.attr( saveScroll );\n\t\tthis._trigger( \"focus\", event );\n\n\t\treturn this;\n\t},\n\n\topen: function() {\n\t\tif ( this._isOpen ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar hasFocus,\n\t\t\toptions = this.options,\n\t\t\tuiDialog = this.uiDialog;\n\n\t\tthis._size();\n\t\tthis._position( options.position );\n\t\tuiDialog.show( options.show );\n\t\tthis.overlay = options.modal ? new $.ui.dialog.overlay( this ) : null;\n\t\tthis.moveToTop( true );\n\n\t\t// set focus to the first tabbable element in the content area or the first button\n\t\t// if there are no tabbable elements, set focus on the dialog itself\n\t\thasFocus = this.element.find( \":tabbable\" );\n\t\tif ( !hasFocus.length ) {\n\t\t\thasFocus = this.uiDialogButtonPane.find( \":tabbable\" );\n\t\t\tif ( !hasFocus.length ) {\n\t\t\t\thasFocus = uiDialog;\n\t\t\t}\n\t\t}\n\t\thasFocus.eq( 0 ).focus();\n\n\t\tthis._isOpen = true;\n\t\tthis._trigger( \"open\" );\n\n\t\treturn this;\n\t},\n\n\t_createButtons: function( buttons ) {\n\t\tvar that = this,\n\t\t\thasButtons = false;\n\n\t\t// if we already have a button pane, remove it\n\t\tthis.uiDialogButtonPane.remove();\n\t\tthis.uiButtonSet.empty();\n\n\t\tif ( typeof buttons === \"object\" && buttons !== null ) {\n\t\t\t$.each( buttons, function() {\n\t\t\t\treturn !(hasButtons = true);\n\t\t\t});\n\t\t}\n\t\tif ( hasButtons ) {\n\t\t\t$.each( buttons, function( name, props ) {\n\t\t\t\tvar button, click;\n\t\t\t\tprops = $.isFunction( props ) ?\n\t\t\t\t\t{ click: props, text: name } :\n\t\t\t\t\tprops;\n\t\t\t\t// Default to a non-submitting button\n\t\t\t\tprops = $.extend( { type: \"button\" }, props );\n\t\t\t\t// Change the context for the click callback to be the main element\n\t\t\t\tclick = props.click;\n\t\t\t\tprops.click = function() {\n\t\t\t\t\tclick.apply( that.element[0], arguments );\n\t\t\t\t};\n\t\t\t\tbutton = $( \"<button></button>\", props )\n\t\t\t\t\t.appendTo( that.uiButtonSet );\n\t\t\t\tif ( $.fn.button ) {\n\t\t\t\t\tbutton.button();\n\t\t\t\t}\n\t\t\t});\n\t\t\tthis.uiDialog.addClass( \"ui-dialog-buttons\" );\n\t\t\tthis.uiDialogButtonPane.appendTo( this.uiDialog );\n\t\t} else {\n\t\t\tthis.uiDialog.removeClass( \"ui-dialog-buttons\" );\n\t\t}\n\t},\n\n\t_makeDraggable: function() {\n\t\tvar that = this,\n\t\t\toptions = this.options;\n\n\t\tfunction filteredUi( ui ) {\n\t\t\treturn {\n\t\t\t\tposition: ui.position,\n\t\t\t\toffset: ui.offset\n\t\t\t};\n\t\t}\n\n\t\tthis.uiDialog.draggable({\n\t\t\tcancel: \".ui-dialog-content, .ui-dialog-titlebar-close\",\n\t\t\thandle: \".ui-dialog-titlebar\",\n\t\t\tcontainment: \"document\",\n\t\t\tstart: function( event, ui ) {\n\t\t\t\t$( this )\n\t\t\t\t\t.addClass( \"ui-dialog-dragging\" );\n\t\t\t\tthat._trigger( \"dragStart\", event, filteredUi( ui ) );\n\t\t\t},\n\t\t\tdrag: function( event, ui ) {\n\t\t\t\tthat._trigger( \"drag\", event, filteredUi( ui ) );\n\t\t\t},\n\t\t\tstop: function( event, ui ) {\n\t\t\t\toptions.position = [\n\t\t\t\t\tui.position.left - that.document.scrollLeft(),\n\t\t\t\t\tui.position.top - that.document.scrollTop()\n\t\t\t\t];\n\t\t\t\t$( this )\n\t\t\t\t\t.removeClass( \"ui-dialog-dragging\" );\n\t\t\t\tthat._trigger( \"dragStop\", event, filteredUi( ui ) );\n\t\t\t\t$.ui.dialog.overlay.resize();\n\t\t\t}\n\t\t});\n\t},\n\n\t_makeResizable: function( handles ) {\n\t\thandles = (handles === undefined ? this.options.resizable : handles);\n\t\tvar that = this,\n\t\t\toptions = this.options,\n\t\t\t// .ui-resizable has position: relative defined in the stylesheet\n\t\t\t// but dialogs have to use absolute or fixed positioning\n\t\t\tposition = this.uiDialog.css( \"position\" ),\n\t\t\tresizeHandles = typeof handles === 'string' ?\n\t\t\t\thandles\t:\n\t\t\t\t\"n,e,s,w,se,sw,ne,nw\";\n\n\t\tfunction filteredUi( ui ) {\n\t\t\treturn {\n\t\t\t\toriginalPosition: ui.originalPosition,\n\t\t\t\toriginalSize: ui.originalSize,\n\t\t\t\tposition: ui.position,\n\t\t\t\tsize: ui.size\n\t\t\t};\n\t\t}\n\n\t\tthis.uiDialog.resizable({\n\t\t\tcancel: \".ui-dialog-content\",\n\t\t\tcontainment: \"document\",\n\t\t\talsoResize: this.element,\n\t\t\tmaxWidth: options.maxWidth,\n\t\t\tmaxHeight: options.maxHeight,\n\t\t\tminWidth: options.minWidth,\n\t\t\tminHeight: this._minHeight(),\n\t\t\thandles: resizeHandles,\n\t\t\tstart: function( event, ui ) {\n\t\t\t\t$( this ).addClass( \"ui-dialog-resizing\" );\n\t\t\t\tthat._trigger( \"resizeStart\", event, filteredUi( ui ) );\n\t\t\t},\n\t\t\tresize: function( event, ui ) {\n\t\t\t\tthat._trigger( \"resize\", event, filteredUi( ui ) );\n\t\t\t},\n\t\t\tstop: function( event, ui ) {\n\t\t\t\t$( this ).removeClass( \"ui-dialog-resizing\" );\n\t\t\t\toptions.height = $( this ).height();\n\t\t\t\toptions.width = $( this ).width();\n\t\t\t\tthat._trigger( \"resizeStop\", event, filteredUi( ui ) );\n\t\t\t\t$.ui.dialog.overlay.resize();\n\t\t\t}\n\t\t})\n\t\t.css( \"position\", position )\n\t\t.find( \".ui-resizable-se\" )\n\t\t\t.addClass( \"ui-icon ui-icon-grip-diagonal-se\" );\n\t},\n\n\t_minHeight: function() {\n\t\tvar options = this.options;\n\n\t\tif ( options.height === \"auto\" ) {\n\t\t\treturn options.minHeight;\n\t\t} else {\n\t\t\treturn Math.min( options.minHeight, options.height );\n\t\t}\n\t},\n\n\t_position: function( position ) {\n\t\tvar myAt = [],\n\t\t\toffset = [ 0, 0 ],\n\t\t\tisVisible;\n\n\t\tif ( position ) {\n\t\t\t// deep extending converts arrays to objects in jQuery <= 1.3.2 :-(\n\t//\t\tif (typeof position == 'string' || $.isArray(position)) {\n\t//\t\t\tmyAt = $.isArray(position) ? position : position.split(' ');\n\n\t\t\tif ( typeof position === \"string\" || (typeof position === \"object\" && \"0\" in position ) ) {\n\t\t\t\tmyAt = position.split ? position.split( \" \" ) : [ position[ 0 ], position[ 1 ] ];\n\t\t\t\tif ( myAt.length === 1 ) {\n\t\t\t\t\tmyAt[ 1 ] = myAt[ 0 ];\n\t\t\t\t}\n\n\t\t\t\t$.each( [ \"left\", \"top\" ], function( i, offsetPosition ) {\n\t\t\t\t\tif ( +myAt[ i ] === myAt[ i ] ) {\n\t\t\t\t\t\toffset[ i ] = myAt[ i ];\n\t\t\t\t\t\tmyAt[ i ] = offsetPosition;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tposition = {\n\t\t\t\t\tmy: myAt[0] + (offset[0] < 0 ? offset[0] : \"+\" + offset[0]) + \" \" +\n\t\t\t\t\t\tmyAt[1] + (offset[1] < 0 ? offset[1] : \"+\" + offset[1]),\n\t\t\t\t\tat: myAt.join( \" \" )\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tposition = $.extend( {}, $.ui.dialog.prototype.options.position, position );\n\t\t} else {\n\t\t\tposition = $.ui.dialog.prototype.options.position;\n\t\t}\n\n\t\t// need to show the dialog to get the actual offset in the position plugin\n\t\tisVisible = this.uiDialog.is( \":visible\" );\n\t\tif ( !isVisible ) {\n\t\t\tthis.uiDialog.show();\n\t\t}\n\t\tthis.uiDialog.position( position );\n\t\tif ( !isVisible ) {\n\t\t\tthis.uiDialog.hide();\n\t\t}\n\t},\n\n\t_setOptions: function( options ) {\n\t\tvar that = this,\n\t\t\tresizableOptions = {},\n\t\t\tresize = false;\n\n\t\t$.each( options, function( key, value ) {\n\t\t\tthat._setOption( key, value );\n\n\t\t\tif ( key in sizeRelatedOptions ) {\n\t\t\t\tresize = true;\n\t\t\t}\n\t\t\tif ( key in resizableRelatedOptions ) {\n\t\t\t\tresizableOptions[ key ] = value;\n\t\t\t}\n\t\t});\n\n\t\tif ( resize ) {\n\t\t\tthis._size();\n\t\t}\n\t\tif ( this.uiDialog.is( \":data(resizable)\" ) ) {\n\t\t\tthis.uiDialog.resizable( \"option\", resizableOptions );\n\t\t}\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tvar isDraggable, isResizable,\n\t\t\tuiDialog = this.uiDialog;\n\n\t\tswitch ( key ) {\n\t\t\tcase \"buttons\":\n\t\t\t\tthis._createButtons( value );\n\t\t\t\tbreak;\n\t\t\tcase \"closeText\":\n\t\t\t\t// ensure that we always pass a string\n\t\t\t\tthis.uiDialogTitlebarCloseText.text( \"\" + value );\n\t\t\t\tbreak;\n\t\t\tcase \"dialogClass\":\n\t\t\t\tuiDialog\n\t\t\t\t\t.removeClass( this.options.dialogClass )\n\t\t\t\t\t.addClass( uiDialogClasses + value );\n\t\t\t\tbreak;\n\t\t\tcase \"disabled\":\n\t\t\t\tif ( value ) {\n\t\t\t\t\tuiDialog.addClass( \"ui-dialog-disabled\" );\n\t\t\t\t} else {\n\t\t\t\t\tuiDialog.removeClass( \"ui-dialog-disabled\" );\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase \"draggable\":\n\t\t\t\tisDraggable = uiDialog.is( \":data(draggable)\" );\n\t\t\t\tif ( isDraggable && !value ) {\n\t\t\t\t\tuiDialog.draggable( \"destroy\" );\n\t\t\t\t}\n\n\t\t\t\tif ( !isDraggable && value ) {\n\t\t\t\t\tthis._makeDraggable();\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase \"position\":\n\t\t\t\tthis._position( value );\n\t\t\t\tbreak;\n\t\t\tcase \"resizable\":\n\t\t\t\t// currently resizable, becoming non-resizable\n\t\t\t\tisResizable = uiDialog.is( \":data(resizable)\" );\n\t\t\t\tif ( isResizable && !value ) {\n\t\t\t\t\tuiDialog.resizable( \"destroy\" );\n\t\t\t\t}\n\n\t\t\t\t// currently resizable, changing handles\n\t\t\t\tif ( isResizable && typeof value === \"string\" ) {\n\t\t\t\t\tuiDialog.resizable( \"option\", \"handles\", value );\n\t\t\t\t}\n\n\t\t\t\t// currently non-resizable, becoming resizable\n\t\t\t\tif ( !isResizable && value !== false ) {\n\t\t\t\t\tthis._makeResizable( value );\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase \"title\":\n\t\t\t\t// convert whatever was passed in o a string, for html() to not throw up\n\t\t\t\t$( \".ui-dialog-title\", this.uiDialogTitlebar )\n\t\t\t\t\t.html( \"\" + ( value || \"&#160;\" ) );\n\t\t\t\tbreak;\n\t\t}\n\n\t\tthis._super( key, value );\n\t},\n\n\t_size: function() {\n\t\t/* If the user has resized the dialog, the .ui-dialog and .ui-dialog-content\n\t\t * divs will both have width and height set, so we need to reset them\n\t\t */\n\t\tvar nonContentHeight, minContentHeight, autoHeight,\n\t\t\toptions = this.options,\n\t\t\tisVisible = this.uiDialog.is( \":visible\" );\n\n\t\t// reset content sizing\n\t\tthis.element.show().css({\n\t\t\twidth: \"auto\",\n\t\t\tminHeight: 0,\n\t\t\theight: 0\n\t\t});\n\n\t\tif ( options.minWidth > options.width ) {\n\t\t\toptions.width = options.minWidth;\n\t\t}\n\n\t\t// reset wrapper sizing\n\t\t// determine the height of all the non-content elements\n\t\tnonContentHeight = this.uiDialog.css({\n\t\t\t\theight: \"auto\",\n\t\t\t\twidth: options.width\n\t\t\t})\n\t\t\t.outerHeight();\n\t\tminContentHeight = Math.max( 0, options.minHeight - nonContentHeight );\n\n\t\tif ( options.height === \"auto\" ) {\n\t\t\t// only needed for IE6 support\n\t\t\tif ( $.support.minHeight ) {\n\t\t\t\tthis.element.css({\n\t\t\t\t\tminHeight: minContentHeight,\n\t\t\t\t\theight: \"auto\"\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tthis.uiDialog.show();\n\t\t\t\tautoHeight = this.element.css( \"height\", \"auto\" ).height();\n\t\t\t\tif ( !isVisible ) {\n\t\t\t\t\tthis.uiDialog.hide();\n\t\t\t\t}\n\t\t\t\tthis.element.height( Math.max( autoHeight, minContentHeight ) );\n\t\t\t}\n\t\t} else {\n\t\t\tthis.element.height( Math.max( options.height - nonContentHeight, 0 ) );\n\t\t}\n\n\t\tif (this.uiDialog.is( \":data(resizable)\" ) ) {\n\t\t\tthis.uiDialog.resizable( \"option\", \"minHeight\", this._minHeight() );\n\t\t}\n\t}\n});\n\n$.extend($.ui.dialog, {\n\tuuid: 0,\n\tmaxZ: 0,\n\n\tgetTitleId: function($el) {\n\t\tvar id = $el.attr( \"id\" );\n\t\tif ( !id ) {\n\t\t\tthis.uuid += 1;\n\t\t\tid = this.uuid;\n\t\t}\n\t\treturn \"ui-dialog-title-\" + id;\n\t},\n\n\toverlay: function( dialog ) {\n\t\tthis.$el = $.ui.dialog.overlay.create( dialog );\n\t}\n});\n\n$.extend( $.ui.dialog.overlay, {\n\tinstances: [],\n\t// reuse old instances due to IE memory leak with alpha transparency (see #5185)\n\toldInstances: [],\n\tmaxZ: 0,\n\tevents: $.map(\n\t\t\"focus,mousedown,mouseup,keydown,keypress,click\".split( \",\" ),\n\t\tfunction( event ) {\n\t\t\treturn event + \".dialog-overlay\";\n\t\t}\n\t).join( \" \" ),\n\tcreate: function( dialog ) {\n\t\tif ( this.instances.length === 0 ) {\n\t\t\t// prevent use of anchors and inputs\n\t\t\t// we use a setTimeout in case the overlay is created from an\n\t\t\t// event that we're going to be cancelling (see #2804)\n\t\t\tsetTimeout(function() {\n\t\t\t\t// handle $(el).dialog().dialog('close') (see #4065)\n\t\t\t\tif ( $.ui.dialog.overlay.instances.length ) {\n\t\t\t\t\t$( document ).bind( $.ui.dialog.overlay.events, function( event ) {\n\t\t\t\t\t\t// stop events if the z-index of the target is < the z-index of the overlay\n\t\t\t\t\t\t// we cannot return true when we don't want to cancel the event (#3523)\n\t\t\t\t\t\tif ( $( event.target ).zIndex() < $.ui.dialog.overlay.maxZ ) {\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}, 1 );\n\n\t\t\t// handle window resize\n\t\t\t$( window ).bind( \"resize.dialog-overlay\", $.ui.dialog.overlay.resize );\n\t\t}\n\n\t\tvar $el = ( this.oldInstances.pop() || $( \"<div>\" ).addClass( \"ui-widget-overlay\" ) );\n\n\t\t// allow closing by pressing the escape key\n\t\t$( document ).bind( \"keydown.dialog-overlay\", function( event ) {\n\t\t\tvar instances = $.ui.dialog.overlay.instances;\n\t\t\t// only react to the event if we're the top overlay\n\t\t\tif ( instances.length !== 0 && instances[ instances.length - 1 ] === $el &&\n\t\t\t\tdialog.options.closeOnEscape && !event.isDefaultPrevented() && event.keyCode &&\n\t\t\t\tevent.keyCode === $.ui.keyCode.ESCAPE ) {\n\n\t\t\t\tdialog.close( event );\n\t\t\t\tevent.preventDefault();\n\t\t\t}\n\t\t});\n\n\t\t$el.appendTo( document.body ).css({\n\t\t\twidth: this.width(),\n\t\t\theight: this.height()\n\t\t});\n\n\t\tif ( $.fn.bgiframe ) {\n\t\t\t$el.bgiframe();\n\t\t}\n\n\t\tthis.instances.push( $el );\n\t\treturn $el;\n\t},\n\n\tdestroy: function( $el ) {\n\t\tvar indexOf = $.inArray( $el, this.instances ),\n\t\t\tmaxZ = 0;\n\n\t\tif ( indexOf !== -1 ) {\n\t\t\tthis.oldInstances.push( this.instances.splice( indexOf, 1 )[ 0 ] );\n\t\t}\n\n\t\tif ( this.instances.length === 0 ) {\n\t\t\t$( [ document, window ] ).unbind( \".dialog-overlay\" );\n\t\t}\n\n\t\t$el.height( 0 ).width( 0 ).remove();\n\n\t\t// adjust the maxZ to allow other modal dialogs to continue to work (see #4309)\n\t\t$.each( this.instances, function() {\n\t\t\tmaxZ = Math.max( maxZ, this.css( \"z-index\" ) );\n\t\t});\n\t\tthis.maxZ = maxZ;\n\t},\n\n\theight: function() {\n\t\tvar scrollHeight,\n\t\t\toffsetHeight;\n\t\t// handle IE\n\t\tif ( $.ui.ie ) {\n\t\t\tscrollHeight = Math.max(\n\t\t\t\tdocument.documentElement.scrollHeight,\n\t\t\t\tdocument.body.scrollHeight\n\t\t\t);\n\t\t\toffsetHeight = Math.max(\n\t\t\t\tdocument.documentElement.offsetHeight,\n\t\t\t\tdocument.body.offsetHeight\n\t\t\t);\n\n\t\t\tif ( scrollHeight < offsetHeight ) {\n\t\t\t\treturn $( window ).height() + \"px\";\n\t\t\t} else {\n\t\t\t\treturn scrollHeight + \"px\";\n\t\t\t}\n\t\t// handle \"good\" browsers\n\t\t} else {\n\t\t\treturn $( document ).height() + \"px\";\n\t\t}\n\t},\n\n\twidth: function() {\n\t\tvar scrollWidth,\n\t\t\toffsetWidth;\n\t\t// handle IE\n\t\tif ( $.ui.ie ) {\n\t\t\tscrollWidth = Math.max(\n\t\t\t\tdocument.documentElement.scrollWidth,\n\t\t\t\tdocument.body.scrollWidth\n\t\t\t);\n\t\t\toffsetWidth = Math.max(\n\t\t\t\tdocument.documentElement.offsetWidth,\n\t\t\t\tdocument.body.offsetWidth\n\t\t\t);\n\n\t\t\tif ( scrollWidth < offsetWidth ) {\n\t\t\t\treturn $( window ).width() + \"px\";\n\t\t\t} else {\n\t\t\t\treturn scrollWidth + \"px\";\n\t\t\t}\n\t\t// handle \"good\" browsers\n\t\t} else {\n\t\t\treturn $( document ).width() + \"px\";\n\t\t}\n\t},\n\n\tresize: function() {\n\t\t/* If the dialog is draggable and the user drags it past the\n\t\t * right edge of the window, the document becomes wider so we\n\t\t * need to stretch the overlay. If the user then drags the\n\t\t * dialog back to the left, the document will become narrower,\n\t\t * so we need to shrink the overlay to the appropriate size.\n\t\t * This is handled by shrinking the overlay before setting it\n\t\t * to the full document size.\n\t\t */\n\t\tvar $overlays = $( [] );\n\t\t$.each( $.ui.dialog.overlay.instances, function() {\n\t\t\t$overlays = $overlays.add( this );\n\t\t});\n\n\t\t$overlays.css({\n\t\t\twidth: 0,\n\t\t\theight: 0\n\t\t}).css({\n\t\t\twidth: $.ui.dialog.overlay.width(),\n\t\t\theight: $.ui.dialog.overlay.height()\n\t\t});\n\t}\n});\n\n$.extend( $.ui.dialog.overlay.prototype, {\n\tdestroy: function() {\n\t\t$.ui.dialog.overlay.destroy( this.$el );\n\t}\n});\n\n}( jQuery ) );\n\n(function( $, undefined ) {\n\nvar rvertical = /up|down|vertical/,\n\trpositivemotion = /up|left|vertical|horizontal/;\n\n$.effects.effect.blind = function( o, done ) {\n\t// Create element\n\tvar el = $( this ),\n\t\tprops = [ \"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\" ],\n\t\tmode = $.effects.setMode( el, o.mode || \"hide\" ),\n\t\tdirection = o.direction || \"up\",\n\t\tvertical = rvertical.test( direction ),\n\t\tref = vertical ? \"height\" : \"width\",\n\t\tref2 = vertical ? \"top\" : \"left\",\n\t\tmotion = rpositivemotion.test( direction ),\n\t\tanimation = {},\n\t\tshow = mode === \"show\",\n\t\twrapper, distance, margin;\n\n\t// if already wrapped, the wrapper's properties are my property. #6245\n\tif ( el.parent().is( \".ui-effects-wrapper\" ) ) {\n\t\t$.effects.save( el.parent(), props );\n\t} else {\n\t\t$.effects.save( el, props );\n\t}\n\tel.show();\n\twrapper = $.effects.createWrapper( el ).css({\n\t\toverflow: \"hidden\"\n\t});\n\n\tdistance = wrapper[ ref ]();\n\tmargin = parseFloat( wrapper.css( ref2 ) ) || 0;\n\n\tanimation[ ref ] = show ? distance : 0;\n\tif ( !motion ) {\n\t\tel\n\t\t\t.css( vertical ? \"bottom\" : \"right\", 0 )\n\t\t\t.css( vertical ? \"top\" : \"left\", \"auto\" )\n\t\t\t.css({ position: \"absolute\" });\n\n\t\tanimation[ ref2 ] = show ? margin : distance + margin;\n\t}\n\n\t// start at 0 if we are showing\n\tif ( show ) {\n\t\twrapper.css( ref, 0 );\n\t\tif ( ! motion ) {\n\t\t\twrapper.css( ref2, margin + distance );\n\t\t}\n\t}\n\n\t// Animate\n\twrapper.animate( animation, {\n\t\tduration: o.duration,\n\t\teasing: o.easing,\n\t\tqueue: false,\n\t\tcomplete: function() {\n\t\t\tif ( mode === \"hide\" ) {\n\t\t\t\tel.hide();\n\t\t\t}\n\t\t\t$.effects.restore( el, props );\n\t\t\t$.effects.removeWrapper( el );\n\t\t\tdone();\n\t\t}\n\t});\n\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.effects.effect.bounce = function( o, done ) {\n\tvar el = $( this ),\n\t\tprops = [ \"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\" ],\n\n\t\t// defaults:\n\t\tmode = $.effects.setMode( el, o.mode || \"effect\" ),\n\t\thide = mode === \"hide\",\n\t\tshow = mode === \"show\",\n\t\tdirection = o.direction || \"up\",\n\t\tdistance = o.distance,\n\t\ttimes = o.times || 5,\n\n\t\t// number of internal animations\n\t\tanims = times * 2 + ( show || hide ? 1 : 0 ),\n\t\tspeed = o.duration / anims,\n\t\teasing = o.easing,\n\n\t\t// utility:\n\t\tref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n\t\tmotion = ( direction === \"up\" || direction === \"left\" ),\n\t\ti,\n\t\tupAnim,\n\t\tdownAnim,\n\n\t\t// we will need to re-assemble the queue to stack our animations in place\n\t\tqueue = el.queue(),\n\t\tqueuelen = queue.length;\n\n\t// Avoid touching opacity to prevent clearType and PNG issues in IE\n\tif ( show || hide ) {\n\t\tprops.push( \"opacity\" );\n\t}\n\n\t$.effects.save( el, props );\n\tel.show();\n\t$.effects.createWrapper( el ); // Create Wrapper\n\n\t// default distance for the BIGGEST bounce is the outer Distance / 3\n\tif ( !distance ) {\n\t\tdistance = el[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]() / 3;\n\t}\n\n\tif ( show ) {\n\t\tdownAnim = { opacity: 1 };\n\t\tdownAnim[ ref ] = 0;\n\n\t\t// if we are showing, force opacity 0 and set the initial position\n\t\t// then do the \"first\" animation\n\t\tel.css( \"opacity\", 0 )\n\t\t\t.css( ref, motion ? -distance * 2 : distance * 2 )\n\t\t\t.animate( downAnim, speed, easing );\n\t}\n\n\t// start at the smallest distance if we are hiding\n\tif ( hide ) {\n\t\tdistance = distance / Math.pow( 2, times - 1 );\n\t}\n\n\tdownAnim = {};\n\tdownAnim[ ref ] = 0;\n\t// Bounces up/down/left/right then back to 0 -- times * 2 animations happen here\n\tfor ( i = 0; i < times; i++ ) {\n\t\tupAnim = {};\n\t\tupAnim[ ref ] = ( motion ? \"-=\" : \"+=\" ) + distance;\n\n\t\tel.animate( upAnim, speed, easing )\n\t\t\t.animate( downAnim, speed, easing );\n\n\t\tdistance = hide ? distance * 2 : distance / 2;\n\t}\n\n\t// Last Bounce when Hiding\n\tif ( hide ) {\n\t\tupAnim = { opacity: 0 };\n\t\tupAnim[ ref ] = ( motion ? \"-=\" : \"+=\" ) + distance;\n\n\t\tel.animate( upAnim, speed, easing );\n\t}\n\n\tel.queue(function() {\n\t\tif ( hide ) {\n\t\t\tel.hide();\n\t\t}\n\t\t$.effects.restore( el, props );\n\t\t$.effects.removeWrapper( el );\n\t\tdone();\n\t});\n\n\t// inject all the animations we just queued to be first in line (after \"inprogress\")\n\tif ( queuelen > 1) {\n\t\tqueue.splice.apply( queue,\n\t\t\t[ 1, 0 ].concat( queue.splice( queuelen, anims + 1 ) ) );\n\t}\n\tel.dequeue();\n\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.effects.effect.clip = function( o, done ) {\n\t// Create element\n\tvar el = $( this ),\n\t\tprops = [ \"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\" ],\n\t\tmode = $.effects.setMode( el, o.mode || \"hide\" ),\n\t\tshow = mode === \"show\",\n\t\tdirection = o.direction || \"vertical\",\n\t\tvert = direction === \"vertical\",\n\t\tsize = vert ? \"height\" : \"width\",\n\t\tposition = vert ? \"top\" : \"left\",\n\t\tanimation = {},\n\t\twrapper, animate, distance;\n\n\t// Save & Show\n\t$.effects.save( el, props );\n\tel.show();\n\n\t// Create Wrapper\n\twrapper = $.effects.createWrapper( el ).css({\n\t\toverflow: \"hidden\"\n\t});\n\tanimate = ( el[0].tagName === \"IMG\" ) ? wrapper : el;\n\tdistance = animate[ size ]();\n\n\t// Shift\n\tif ( show ) {\n\t\tanimate.css( size, 0 );\n\t\tanimate.css( position, distance / 2 );\n\t}\n\n\t// Create Animation Object:\n\tanimation[ size ] = show ? distance : 0;\n\tanimation[ position ] = show ? 0 : distance / 2;\n\n\t// Animate\n\tanimate.animate( animation, {\n\t\tqueue: false,\n\t\tduration: o.duration,\n\t\teasing: o.easing,\n\t\tcomplete: function() {\n\t\t\tif ( !show ) {\n\t\t\t\tel.hide();\n\t\t\t}\n\t\t\t$.effects.restore( el, props );\n\t\t\t$.effects.removeWrapper( el );\n\t\t\tdone();\n\t\t}\n\t});\n\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.effects.effect.drop = function( o, done ) {\n\n\tvar el = $( this ),\n\t\tprops = [ \"position\", \"top\", \"bottom\", \"left\", \"right\", \"opacity\", \"height\", \"width\" ],\n\t\tmode = $.effects.setMode( el, o.mode || \"hide\" ),\n\t\tshow = mode === \"show\",\n\t\tdirection = o.direction || \"left\",\n\t\tref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n\t\tmotion = ( direction === \"up\" || direction === \"left\" ) ? \"pos\" : \"neg\",\n\t\tanimation = {\n\t\t\topacity: show ? 1 : 0\n\t\t},\n\t\tdistance;\n\n\t// Adjust\n\t$.effects.save( el, props );\n\tel.show();\n\t$.effects.createWrapper( el );\n\n\tdistance = o.distance || el[ ref === \"top\" ? \"outerHeight\": \"outerWidth\" ]( true ) / 2;\n\n\tif ( show ) {\n\t\tel\n\t\t\t.css( \"opacity\", 0 )\n\t\t\t.css( ref, motion === \"pos\" ? -distance : distance );\n\t}\n\n\t// Animation\n\tanimation[ ref ] = ( show ?\n\t\t( motion === \"pos\" ? \"+=\" : \"-=\" ) :\n\t\t( motion === \"pos\" ? \"-=\" : \"+=\" ) ) +\n\t\tdistance;\n\n\t// Animate\n\tel.animate( animation, {\n\t\tqueue: false,\n\t\tduration: o.duration,\n\t\teasing: o.easing,\n\t\tcomplete: function() {\n\t\t\tif ( mode === \"hide\" ) {\n\t\t\t\tel.hide();\n\t\t\t}\n\t\t\t$.effects.restore( el, props );\n\t\t\t$.effects.removeWrapper( el );\n\t\t\tdone();\n\t\t}\n\t});\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.effects.effect.explode = function( o, done ) {\n\n\tvar rows = o.pieces ? Math.round( Math.sqrt( o.pieces ) ) : 3,\n\t\tcells = rows,\n\t\tel = $( this ),\n\t\tmode = $.effects.setMode( el, o.mode || \"hide\" ),\n\t\tshow = mode === \"show\",\n\n\t\t// show and then visibility:hidden the element before calculating offset\n\t\toffset = el.show().css( \"visibility\", \"hidden\" ).offset(),\n\n\t\t// width and height of a piece\n\t\twidth = Math.ceil( el.outerWidth() / cells ),\n\t\theight = Math.ceil( el.outerHeight() / rows ),\n\t\tpieces = [],\n\n\t\t// loop\n\t\ti, j, left, top, mx, my;\n\n\t// children animate complete:\n\tfunction childComplete() {\n\t\tpieces.push( this );\n\t\tif ( pieces.length === rows * cells ) {\n\t\t\tanimComplete();\n\t\t}\n\t}\n\n\t// clone the element for each row and cell.\n\tfor( i = 0; i < rows ; i++ ) { // ===>\n\t\ttop = offset.top + i * height;\n\t\tmy = i - ( rows - 1 ) / 2 ;\n\n\t\tfor( j = 0; j < cells ; j++ ) { // |||\n\t\t\tleft = offset.left + j * width;\n\t\t\tmx = j - ( cells - 1 ) / 2 ;\n\n\t\t\t// Create a clone of the now hidden main element that will be absolute positioned\n\t\t\t// within a wrapper div off the -left and -top equal to size of our pieces\n\t\t\tel\n\t\t\t\t.clone()\n\t\t\t\t.appendTo( \"body\" )\n\t\t\t\t.wrap( \"<div></div>\" )\n\t\t\t\t.css({\n\t\t\t\t\tposition: \"absolute\",\n\t\t\t\t\tvisibility: \"visible\",\n\t\t\t\t\tleft: -j * width,\n\t\t\t\t\ttop: -i * height\n\t\t\t\t})\n\n\t\t\t// select the wrapper - make it overflow: hidden and absolute positioned based on\n\t\t\t// where the original was located +left and +top equal to the size of pieces\n\t\t\t\t.parent()\n\t\t\t\t.addClass( \"ui-effects-explode\" )\n\t\t\t\t.css({\n\t\t\t\t\tposition: \"absolute\",\n\t\t\t\t\toverflow: \"hidden\",\n\t\t\t\t\twidth: width,\n\t\t\t\t\theight: height,\n\t\t\t\t\tleft: left + ( show ? mx * width : 0 ),\n\t\t\t\t\ttop: top + ( show ? my * height : 0 ),\n\t\t\t\t\topacity: show ? 0 : 1\n\t\t\t\t}).animate({\n\t\t\t\t\tleft: left + ( show ? 0 : mx * width ),\n\t\t\t\t\ttop: top + ( show ? 0 : my * height ),\n\t\t\t\t\topacity: show ? 1 : 0\n\t\t\t\t}, o.duration || 500, o.easing, childComplete );\n\t\t}\n\t}\n\n\tfunction animComplete() {\n\t\tel.css({\n\t\t\tvisibility: \"visible\"\n\t\t});\n\t\t$( pieces ).remove();\n\t\tif ( !show ) {\n\t\t\tel.hide();\n\t\t}\n\t\tdone();\n\t}\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.effects.effect.fade = function( o, done ) {\n\tvar el = $( this ),\n\t\tmode = $.effects.setMode( el, o.mode || \"toggle\" );\n\n\tel.animate({\n\t\topacity: mode\n\t}, {\n\t\tqueue: false,\n\t\tduration: o.duration,\n\t\teasing: o.easing,\n\t\tcomplete: done\n\t});\n};\n\n})( jQuery );\n\n(function( $, undefined ) {\n\n$.effects.effect.fold = function( o, done ) {\n\n\t// Create element\n\tvar el = $( this ),\n\t\tprops = [ \"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\" ],\n\t\tmode = $.effects.setMode( el, o.mode || \"hide\" ),\n\t\tshow = mode === \"show\",\n\t\thide = mode === \"hide\",\n\t\tsize = o.size || 15,\n\t\tpercent = /([0-9]+)%/.exec( size ),\n\t\thorizFirst = !!o.horizFirst,\n\t\twidthFirst = show !== horizFirst,\n\t\tref = widthFirst ? [ \"width\", \"height\" ] : [ \"height\", \"width\" ],\n\t\tduration = o.duration / 2,\n\t\twrapper, distance,\n\t\tanimation1 = {},\n\t\tanimation2 = {};\n\n\t$.effects.save( el, props );\n\tel.show();\n\n\t// Create Wrapper\n\twrapper = $.effects.createWrapper( el ).css({\n\t\toverflow: \"hidden\"\n\t});\n\tdistance = widthFirst ?\n\t\t[ wrapper.width(), wrapper.height() ] :\n\t\t[ wrapper.height(), wrapper.width() ];\n\n\tif ( percent ) {\n\t\tsize = parseInt( percent[ 1 ], 10 ) / 100 * distance[ hide ? 0 : 1 ];\n\t}\n\tif ( show ) {\n\t\twrapper.css( horizFirst ? {\n\t\t\theight: 0,\n\t\t\twidth: size\n\t\t} : {\n\t\t\theight: size,\n\t\t\twidth: 0\n\t\t});\n\t}\n\n\t// Animation\n\tanimation1[ ref[ 0 ] ] = show ? distance[ 0 ] : size;\n\tanimation2[ ref[ 1 ] ] = show ? distance[ 1 ] : 0;\n\n\t// Animate\n\twrapper\n\t\t.animate( animation1, duration, o.easing )\n\t\t.animate( animation2, duration, o.easing, function() {\n\t\t\tif ( hide ) {\n\t\t\t\tel.hide();\n\t\t\t}\n\t\t\t$.effects.restore( el, props );\n\t\t\t$.effects.removeWrapper( el );\n\t\t\tdone();\n\t\t});\n\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.effects.effect.highlight = function( o, done ) {\n\tvar elem = $( this ),\n\t\tprops = [ \"backgroundImage\", \"backgroundColor\", \"opacity\" ],\n\t\tmode = $.effects.setMode( elem, o.mode || \"show\" ),\n\t\tanimation = {\n\t\t\tbackgroundColor: elem.css( \"backgroundColor\" )\n\t\t};\n\n\tif (mode === \"hide\") {\n\t\tanimation.opacity = 0;\n\t}\n\n\t$.effects.save( elem, props );\n\n\telem\n\t\t.show()\n\t\t.css({\n\t\t\tbackgroundImage: \"none\",\n\t\t\tbackgroundColor: o.color || \"#ffff99\"\n\t\t})\n\t\t.animate( animation, {\n\t\t\tqueue: false,\n\t\t\tduration: o.duration,\n\t\t\teasing: o.easing,\n\t\t\tcomplete: function() {\n\t\t\t\tif ( mode === \"hide\" ) {\n\t\t\t\t\telem.hide();\n\t\t\t\t}\n\t\t\t\t$.effects.restore( elem, props );\n\t\t\t\tdone();\n\t\t\t}\n\t\t});\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.effects.effect.pulsate = function( o, done ) {\n\tvar elem = $( this ),\n\t\tmode = $.effects.setMode( elem, o.mode || \"show\" ),\n\t\tshow = mode === \"show\",\n\t\thide = mode === \"hide\",\n\t\tshowhide = ( show || mode === \"hide\" ),\n\n\t\t// showing or hiding leaves of the \"last\" animation\n\t\tanims = ( ( o.times || 5 ) * 2 ) + ( showhide ? 1 : 0 ),\n\t\tduration = o.duration / anims,\n\t\tanimateTo = 0,\n\t\tqueue = elem.queue(),\n\t\tqueuelen = queue.length,\n\t\ti;\n\n\tif ( show || !elem.is(\":visible\")) {\n\t\telem.css( \"opacity\", 0 ).show();\n\t\tanimateTo = 1;\n\t}\n\n\t// anims - 1 opacity \"toggles\"\n\tfor ( i = 1; i < anims; i++ ) {\n\t\telem.animate({\n\t\t\topacity: animateTo\n\t\t}, duration, o.easing );\n\t\tanimateTo = 1 - animateTo;\n\t}\n\n\telem.animate({\n\t\topacity: animateTo\n\t}, duration, o.easing);\n\n\telem.queue(function() {\n\t\tif ( hide ) {\n\t\t\telem.hide();\n\t\t}\n\t\tdone();\n\t});\n\n\t// We just queued up \"anims\" animations, we need to put them next in the queue\n\tif ( queuelen > 1 ) {\n\t\tqueue.splice.apply( queue,\n\t\t\t[ 1, 0 ].concat( queue.splice( queuelen, anims + 1 ) ) );\n\t}\n\telem.dequeue();\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.effects.effect.puff = function( o, done ) {\n\tvar elem = $( this ),\n\t\tmode = $.effects.setMode( elem, o.mode || \"hide\" ),\n\t\thide = mode === \"hide\",\n\t\tpercent = parseInt( o.percent, 10 ) || 150,\n\t\tfactor = percent / 100,\n\t\toriginal = {\n\t\t\theight: elem.height(),\n\t\t\twidth: elem.width(),\n\t\t\touterHeight: elem.outerHeight(),\n\t\t\touterWidth: elem.outerWidth()\n\t\t};\n\n\t$.extend( o, {\n\t\teffect: \"scale\",\n\t\tqueue: false,\n\t\tfade: true,\n\t\tmode: mode,\n\t\tcomplete: done,\n\t\tpercent: hide ? percent : 100,\n\t\tfrom: hide ?\n\t\t\toriginal :\n\t\t\t{\n\t\t\t\theight: original.height * factor,\n\t\t\t\twidth: original.width * factor,\n\t\t\t\touterHeight: original.outerHeight * factor,\n\t\t\t\touterWidth: original.outerWidth * factor\n\t\t\t}\n\t});\n\n\telem.effect( o );\n};\n\n$.effects.effect.scale = function( o, done ) {\n\n\t// Create element\n\tvar el = $( this ),\n\t\toptions = $.extend( true, {}, o ),\n\t\tmode = $.effects.setMode( el, o.mode || \"effect\" ),\n\t\tpercent = parseInt( o.percent, 10 ) ||\n\t\t\t( parseInt( o.percent, 10 ) === 0 ? 0 : ( mode === \"hide\" ? 0 : 100 ) ),\n\t\tdirection = o.direction || \"both\",\n\t\torigin = o.origin,\n\t\toriginal = {\n\t\t\theight: el.height(),\n\t\t\twidth: el.width(),\n\t\t\touterHeight: el.outerHeight(),\n\t\t\touterWidth: el.outerWidth()\n\t\t},\n\t\tfactor = {\n\t\t\ty: direction !== \"horizontal\" ? (percent / 100) : 1,\n\t\t\tx: direction !== \"vertical\" ? (percent / 100) : 1\n\t\t};\n\n\t// We are going to pass this effect to the size effect:\n\toptions.effect = \"size\";\n\toptions.queue = false;\n\toptions.complete = done;\n\n\t// Set default origin and restore for show/hide\n\tif ( mode !== \"effect\" ) {\n\t\toptions.origin = origin || [\"middle\",\"center\"];\n\t\toptions.restore = true;\n\t}\n\n\toptions.from = o.from || ( mode === \"show\" ? {\n\t\theight: 0,\n\t\twidth: 0,\n\t\touterHeight: 0,\n\t\touterWidth: 0\n\t} : original );\n\toptions.to = {\n\t\theight: original.height * factor.y,\n\t\twidth: original.width * factor.x,\n\t\touterHeight: original.outerHeight * factor.y,\n\t\touterWidth: original.outerWidth * factor.x\n\t};\n\n\t// Fade option to support puff\n\tif ( options.fade ) {\n\t\tif ( mode === \"show\" ) {\n\t\t\toptions.from.opacity = 0;\n\t\t\toptions.to.opacity = 1;\n\t\t}\n\t\tif ( mode === \"hide\" ) {\n\t\t\toptions.from.opacity = 1;\n\t\t\toptions.to.opacity = 0;\n\t\t}\n\t}\n\n\t// Animate\n\tel.effect( options );\n\n};\n\n$.effects.effect.size = function( o, done ) {\n\n\t// Create element\n\tvar original, baseline, factor,\n\t\tel = $( this ),\n\t\tprops0 = [ \"position\", \"top\", \"bottom\", \"left\", \"right\", \"width\", \"height\", \"overflow\", \"opacity\" ],\n\n\t\t// Always restore\n\t\tprops1 = [ \"position\", \"top\", \"bottom\", \"left\", \"right\", \"overflow\", \"opacity\" ],\n\n\t\t// Copy for children\n\t\tprops2 = [ \"width\", \"height\", \"overflow\" ],\n\t\tcProps = [ \"fontSize\" ],\n\t\tvProps = [ \"borderTopWidth\", \"borderBottomWidth\", \"paddingTop\", \"paddingBottom\" ],\n\t\thProps = [ \"borderLeftWidth\", \"borderRightWidth\", \"paddingLeft\", \"paddingRight\" ],\n\n\t\t// Set options\n\t\tmode = $.effects.setMode( el, o.mode || \"effect\" ),\n\t\trestore = o.restore || mode !== \"effect\",\n\t\tscale = o.scale || \"both\",\n\t\torigin = o.origin || [ \"middle\", \"center\" ],\n\t\tposition = el.css( \"position\" ),\n\t\tprops = restore ? props0 : props1,\n\t\tzero = {\n\t\t\theight: 0,\n\t\t\twidth: 0,\n\t\t\touterHeight: 0,\n\t\t\touterWidth: 0\n\t\t};\n\n\tif ( mode === \"show\" ) {\n\t\tel.show();\n\t}\n\toriginal = {\n\t\theight: el.height(),\n\t\twidth: el.width(),\n\t\touterHeight: el.outerHeight(),\n\t\touterWidth: el.outerWidth()\n\t};\n\n\tif ( o.mode === \"toggle\" && mode === \"show\" ) {\n\t\tel.from = o.to || zero;\n\t\tel.to = o.from || original;\n\t} else {\n\t\tel.from = o.from || ( mode === \"show\" ? zero : original );\n\t\tel.to = o.to || ( mode === \"hide\" ? zero : original );\n\t}\n\n\t// Set scaling factor\n\tfactor = {\n\t\tfrom: {\n\t\t\ty: el.from.height / original.height,\n\t\t\tx: el.from.width / original.width\n\t\t},\n\t\tto: {\n\t\t\ty: el.to.height / original.height,\n\t\t\tx: el.to.width / original.width\n\t\t}\n\t};\n\n\t// Scale the css box\n\tif ( scale === \"box\" || scale === \"both\" ) {\n\n\t\t// Vertical props scaling\n\t\tif ( factor.from.y !== factor.to.y ) {\n\t\t\tprops = props.concat( vProps );\n\t\t\tel.from = $.effects.setTransition( el, vProps, factor.from.y, el.from );\n\t\t\tel.to = $.effects.setTransition( el, vProps, factor.to.y, el.to );\n\t\t}\n\n\t\t// Horizontal props scaling\n\t\tif ( factor.from.x !== factor.to.x ) {\n\t\t\tprops = props.concat( hProps );\n\t\t\tel.from = $.effects.setTransition( el, hProps, factor.from.x, el.from );\n\t\t\tel.to = $.effects.setTransition( el, hProps, factor.to.x, el.to );\n\t\t}\n\t}\n\n\t// Scale the content\n\tif ( scale === \"content\" || scale === \"both\" ) {\n\n\t\t// Vertical props scaling\n\t\tif ( factor.from.y !== factor.to.y ) {\n\t\t\tprops = props.concat( cProps ).concat( props2 );\n\t\t\tel.from = $.effects.setTransition( el, cProps, factor.from.y, el.from );\n\t\t\tel.to = $.effects.setTransition( el, cProps, factor.to.y, el.to );\n\t\t}\n\t}\n\n\t$.effects.save( el, props );\n\tel.show();\n\t$.effects.createWrapper( el );\n\tel.css( \"overflow\", \"hidden\" ).css( el.from );\n\n\t// Adjust\n\tif (origin) { // Calculate baseline shifts\n\t\tbaseline = $.effects.getBaseline( origin, original );\n\t\tel.from.top = ( original.outerHeight - el.outerHeight() ) * baseline.y;\n\t\tel.from.left = ( original.outerWidth - el.outerWidth() ) * baseline.x;\n\t\tel.to.top = ( original.outerHeight - el.to.outerHeight ) * baseline.y;\n\t\tel.to.left = ( original.outerWidth - el.to.outerWidth ) * baseline.x;\n\t}\n\tel.css( el.from ); // set top & left\n\n\t// Animate\n\tif ( scale === \"content\" || scale === \"both\" ) { // Scale the children\n\n\t\t// Add margins/font-size\n\t\tvProps = vProps.concat([ \"marginTop\", \"marginBottom\" ]).concat(cProps);\n\t\thProps = hProps.concat([ \"marginLeft\", \"marginRight\" ]);\n\t\tprops2 = props0.concat(vProps).concat(hProps);\n\n\t\tel.find( \"*[width]\" ).each( function(){\n\t\t\tvar child = $( this ),\n\t\t\t\tc_original = {\n\t\t\t\t\theight: child.height(),\n\t\t\t\t\twidth: child.width(),\n\t\t\t\t\touterHeight: child.outerHeight(),\n\t\t\t\t\touterWidth: child.outerWidth()\n\t\t\t\t};\n\t\t\tif (restore) {\n\t\t\t\t$.effects.save(child, props2);\n\t\t\t}\n\n\t\t\tchild.from = {\n\t\t\t\theight: c_original.height * factor.from.y,\n\t\t\t\twidth: c_original.width * factor.from.x,\n\t\t\t\touterHeight: c_original.outerHeight * factor.from.y,\n\t\t\t\touterWidth: c_original.outerWidth * factor.from.x\n\t\t\t};\n\t\t\tchild.to = {\n\t\t\t\theight: c_original.height * factor.to.y,\n\t\t\t\twidth: c_original.width * factor.to.x,\n\t\t\t\touterHeight: c_original.height * factor.to.y,\n\t\t\t\touterWidth: c_original.width * factor.to.x\n\t\t\t};\n\n\t\t\t// Vertical props scaling\n\t\t\tif ( factor.from.y !== factor.to.y ) {\n\t\t\t\tchild.from = $.effects.setTransition( child, vProps, factor.from.y, child.from );\n\t\t\t\tchild.to = $.effects.setTransition( child, vProps, factor.to.y, child.to );\n\t\t\t}\n\n\t\t\t// Horizontal props scaling\n\t\t\tif ( factor.from.x !== factor.to.x ) {\n\t\t\t\tchild.from = $.effects.setTransition( child, hProps, factor.from.x, child.from );\n\t\t\t\tchild.to = $.effects.setTransition( child, hProps, factor.to.x, child.to );\n\t\t\t}\n\n\t\t\t// Animate children\n\t\t\tchild.css( child.from );\n\t\t\tchild.animate( child.to, o.duration, o.easing, function() {\n\n\t\t\t\t// Restore children\n\t\t\t\tif ( restore ) {\n\t\t\t\t\t$.effects.restore( child, props2 );\n\t\t\t\t}\n\t\t\t});\n\t\t});\n\t}\n\n\t// Animate\n\tel.animate( el.to, {\n\t\tqueue: false,\n\t\tduration: o.duration,\n\t\teasing: o.easing,\n\t\tcomplete: function() {\n\t\t\tif ( el.to.opacity === 0 ) {\n\t\t\t\tel.css( \"opacity\", el.from.opacity );\n\t\t\t}\n\t\t\tif( mode === \"hide\" ) {\n\t\t\t\tel.hide();\n\t\t\t}\n\t\t\t$.effects.restore( el, props );\n\t\t\tif ( !restore ) {\n\n\t\t\t\t// we need to calculate our new positioning based on the scaling\n\t\t\t\tif ( position === \"static\" ) {\n\t\t\t\t\tel.css({\n\t\t\t\t\t\tposition: \"relative\",\n\t\t\t\t\t\ttop: el.to.top,\n\t\t\t\t\t\tleft: el.to.left\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\t$.each([ \"top\", \"left\" ], function( idx, pos ) {\n\t\t\t\t\t\tel.css( pos, function( _, str ) {\n\t\t\t\t\t\t\tvar val = parseInt( str, 10 ),\n\t\t\t\t\t\t\t\ttoRef = idx ? el.to.left : el.to.top;\n\n\t\t\t\t\t\t\t// if original was \"auto\", recalculate the new value from wrapper\n\t\t\t\t\t\t\tif ( str === \"auto\" ) {\n\t\t\t\t\t\t\t\treturn toRef + \"px\";\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn val + toRef + \"px\";\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t$.effects.removeWrapper( el );\n\t\t\tdone();\n\t\t}\n\t});\n\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.effects.effect.shake = function( o, done ) {\n\n\tvar el = $( this ),\n\t\tprops = [ \"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\" ],\n\t\tmode = $.effects.setMode( el, o.mode || \"effect\" ),\n\t\tdirection = o.direction || \"left\",\n\t\tdistance = o.distance || 20,\n\t\ttimes = o.times || 3,\n\t\tanims = times * 2 + 1,\n\t\tspeed = Math.round(o.duration/anims),\n\t\tref = (direction === \"up\" || direction === \"down\") ? \"top\" : \"left\",\n\t\tpositiveMotion = (direction === \"up\" || direction === \"left\"),\n\t\tanimation = {},\n\t\tanimation1 = {},\n\t\tanimation2 = {},\n\t\ti,\n\n\t\t// we will need to re-assemble the queue to stack our animations in place\n\t\tqueue = el.queue(),\n\t\tqueuelen = queue.length;\n\n\t$.effects.save( el, props );\n\tel.show();\n\t$.effects.createWrapper( el );\n\n\t// Animation\n\tanimation[ ref ] = ( positiveMotion ? \"-=\" : \"+=\" ) + distance;\n\tanimation1[ ref ] = ( positiveMotion ? \"+=\" : \"-=\" ) + distance * 2;\n\tanimation2[ ref ] = ( positiveMotion ? \"-=\" : \"+=\" ) + distance * 2;\n\n\t// Animate\n\tel.animate( animation, speed, o.easing );\n\n\t// Shakes\n\tfor ( i = 1; i < times; i++ ) {\n\t\tel.animate( animation1, speed, o.easing ).animate( animation2, speed, o.easing );\n\t}\n\tel\n\t\t.animate( animation1, speed, o.easing )\n\t\t.animate( animation, speed / 2, o.easing )\n\t\t.queue(function() {\n\t\t\tif ( mode === \"hide\" ) {\n\t\t\t\tel.hide();\n\t\t\t}\n\t\t\t$.effects.restore( el, props );\n\t\t\t$.effects.removeWrapper( el );\n\t\t\tdone();\n\t\t});\n\n\t// inject all the animations we just queued to be first in line (after \"inprogress\")\n\tif ( queuelen > 1) {\n\t\tqueue.splice.apply( queue,\n\t\t\t[ 1, 0 ].concat( queue.splice( queuelen, anims + 1 ) ) );\n\t}\n\tel.dequeue();\n\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.effects.effect.slide = function( o, done ) {\n\n\t// Create element\n\tvar el = $( this ),\n\t\tprops = [ \"position\", \"top\", \"bottom\", \"left\", \"right\", \"width\", \"height\" ],\n\t\tmode = $.effects.setMode( el, o.mode || \"show\" ),\n\t\tshow = mode === \"show\",\n\t\tdirection = o.direction || \"left\",\n\t\tref = (direction === \"up\" || direction === \"down\") ? \"top\" : \"left\",\n\t\tpositiveMotion = (direction === \"up\" || direction === \"left\"),\n\t\tdistance,\n\t\tanimation = {};\n\n\t// Adjust\n\t$.effects.save( el, props );\n\tel.show();\n\tdistance = o.distance || el[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]( true );\n\n\t$.effects.createWrapper( el ).css({\n\t\toverflow: \"hidden\"\n\t});\n\n\tif ( show ) {\n\t\tel.css( ref, positiveMotion ? (isNaN(distance) ? \"-\" + distance : -distance) : distance );\n\t}\n\n\t// Animation\n\tanimation[ ref ] = ( show ?\n\t\t( positiveMotion ? \"+=\" : \"-=\") :\n\t\t( positiveMotion ? \"-=\" : \"+=\")) +\n\t\tdistance;\n\n\t// Animate\n\tel.animate( animation, {\n\t\tqueue: false,\n\t\tduration: o.duration,\n\t\teasing: o.easing,\n\t\tcomplete: function() {\n\t\t\tif ( mode === \"hide\" ) {\n\t\t\t\tel.hide();\n\t\t\t}\n\t\t\t$.effects.restore( el, props );\n\t\t\t$.effects.removeWrapper( el );\n\t\t\tdone();\n\t\t}\n\t});\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\n$.effects.effect.transfer = function( o, done ) {\n\tvar elem = $( this ),\n\t\ttarget = $( o.to ),\n\t\ttargetFixed = target.css( \"position\" ) === \"fixed\",\n\t\tbody = $(\"body\"),\n\t\tfixTop = targetFixed ? body.scrollTop() : 0,\n\t\tfixLeft = targetFixed ? body.scrollLeft() : 0,\n\t\tendPosition = target.offset(),\n\t\tanimation = {\n\t\t\ttop: endPosition.top - fixTop ,\n\t\t\tleft: endPosition.left - fixLeft ,\n\t\t\theight: target.innerHeight(),\n\t\t\twidth: target.innerWidth()\n\t\t},\n\t\tstartPosition = elem.offset(),\n\t\ttransfer = $( '<div class=\"ui-effects-transfer\"></div>' )\n\t\t\t.appendTo( document.body )\n\t\t\t.addClass( o.className )\n\t\t\t.css({\n\t\t\t\ttop: startPosition.top - fixTop ,\n\t\t\t\tleft: startPosition.left - fixLeft ,\n\t\t\t\theight: elem.innerHeight(),\n\t\t\t\twidth: elem.innerWidth(),\n\t\t\t\tposition: targetFixed ? \"fixed\" : \"absolute\"\n\t\t\t})\n\t\t\t.animate( animation, o.duration, o.easing, function() {\n\t\t\t\ttransfer.remove();\n\t\t\t\tdone();\n\t\t\t});\n};\n\n})(jQuery);\n\n(function( $, undefined ) {\n\nvar mouseHandled = false;\n\n$.widget( \"ui.menu\", {\n\tversion: \"1.9.2\",\n\tdefaultElement: \"<ul>\",\n\tdelay: 300,\n\toptions: {\n\t\ticons: {\n\t\t\tsubmenu: \"ui-icon-carat-1-e\"\n\t\t},\n\t\tmenus: \"ul\",\n\t\tposition: {\n\t\t\tmy: \"left top\",\n\t\t\tat: \"right top\"\n\t\t},\n\t\trole: \"menu\",\n\n\t\t// callbacks\n\t\tblur: null,\n\t\tfocus: null,\n\t\tselect: null\n\t},\n\n\t_create: function() {\n\t\tthis.activeMenu = this.element;\n\t\tthis.element\n\t\t\t.uniqueId()\n\t\t\t.addClass( \"ui-menu ui-widget ui-widget-content ui-corner-all\" )\n\t\t\t.toggleClass( \"ui-menu-icons\", !!this.element.find( \".ui-icon\" ).length )\n\t\t\t.attr({\n\t\t\t\trole: this.options.role,\n\t\t\t\ttabIndex: 0\n\t\t\t})\n\t\t\t// need to catch all clicks on disabled menu\n\t\t\t// not possible through _on\n\t\t\t.bind( \"click\" + this.eventNamespace, $.proxy(function( event ) {\n\t\t\t\tif ( this.options.disabled ) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t}\n\t\t\t}, this ));\n\n\t\tif ( this.options.disabled ) {\n\t\t\tthis.element\n\t\t\t\t.addClass( \"ui-state-disabled\" )\n\t\t\t\t.attr( \"aria-disabled\", \"true\" );\n\t\t}\n\n\t\tthis._on({\n\t\t\t// Prevent focus from sticking to links inside menu after clicking\n\t\t\t// them (focus should always stay on UL during navigation).\n\t\t\t\"mousedown .ui-menu-item > a\": function( event ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t},\n\t\t\t\"click .ui-state-disabled > a\": function( event ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t},\n\t\t\t\"click .ui-menu-item:has(a)\": function( event ) {\n\t\t\t\tvar target = $( event.target ).closest( \".ui-menu-item\" );\n\t\t\t\tif ( !mouseHandled && target.not( \".ui-state-disabled\" ).length ) {\n\t\t\t\t\tmouseHandled = true;\n\n\t\t\t\t\tthis.select( event );\n\t\t\t\t\t// Open submenu on click\n\t\t\t\t\tif ( target.has( \".ui-menu\" ).length ) {\n\t\t\t\t\t\tthis.expand( event );\n\t\t\t\t\t} else if ( !this.element.is( \":focus\" ) ) {\n\t\t\t\t\t\t// Redirect focus to the menu\n\t\t\t\t\t\tthis.element.trigger( \"focus\", [ true ] );\n\n\t\t\t\t\t\t// If the active item is on the top level, let it stay active.\n\t\t\t\t\t\t// Otherwise, blur the active item since it is no longer visible.\n\t\t\t\t\t\tif ( this.active && this.active.parents( \".ui-menu\" ).length === 1 ) {\n\t\t\t\t\t\t\tclearTimeout( this.timer );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\t\"mouseenter .ui-menu-item\": function( event ) {\n\t\t\t\tvar target = $( event.currentTarget );\n\t\t\t\t// Remove ui-state-active class from siblings of the newly focused menu item\n\t\t\t\t// to avoid a jump caused by adjacent elements both having a class with a border\n\t\t\t\ttarget.siblings().children( \".ui-state-active\" ).removeClass( \"ui-state-active\" );\n\t\t\t\tthis.focus( event, target );\n\t\t\t},\n\t\t\tmouseleave: \"collapseAll\",\n\t\t\t\"mouseleave .ui-menu\": \"collapseAll\",\n\t\t\tfocus: function( event, keepActiveItem ) {\n\t\t\t\t// If there's already an active item, keep it active\n\t\t\t\t// If not, activate the first item\n\t\t\t\tvar item = this.active || this.element.children( \".ui-menu-item\" ).eq( 0 );\n\n\t\t\t\tif ( !keepActiveItem ) {\n\t\t\t\t\tthis.focus( event, item );\n\t\t\t\t}\n\t\t\t},\n\t\t\tblur: function( event ) {\n\t\t\t\tthis._delay(function() {\n\t\t\t\t\tif ( !$.contains( this.element[0], this.document[0].activeElement ) ) {\n\t\t\t\t\t\tthis.collapseAll( event );\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\tkeydown: \"_keydown\"\n\t\t});\n\n\t\tthis.refresh();\n\n\t\t// Clicks outside of a menu collapse any open menus\n\t\tthis._on( this.document, {\n\t\t\tclick: function( event ) {\n\t\t\t\tif ( !$( event.target ).closest( \".ui-menu\" ).length ) {\n\t\t\t\t\tthis.collapseAll( event );\n\t\t\t\t}\n\n\t\t\t\t// Reset the mouseHandled flag\n\t\t\t\tmouseHandled = false;\n\t\t\t}\n\t\t});\n\t},\n\n\t_destroy: function() {\n\t\t// Destroy (sub)menus\n\t\tthis.element\n\t\t\t.removeAttr( \"aria-activedescendant\" )\n\t\t\t.find( \".ui-menu\" ).andSelf()\n\t\t\t\t.removeClass( \"ui-menu ui-widget ui-widget-content ui-corner-all ui-menu-icons\" )\n\t\t\t\t.removeAttr( \"role\" )\n\t\t\t\t.removeAttr( \"tabIndex\" )\n\t\t\t\t.removeAttr( \"aria-labelledby\" )\n\t\t\t\t.removeAttr( \"aria-expanded\" )\n\t\t\t\t.removeAttr( \"aria-hidden\" )\n\t\t\t\t.removeAttr( \"aria-disabled\" )\n\t\t\t\t.removeUniqueId()\n\t\t\t\t.show();\n\n\t\t// Destroy menu items\n\t\tthis.element.find( \".ui-menu-item\" )\n\t\t\t.removeClass( \"ui-menu-item\" )\n\t\t\t.removeAttr( \"role\" )\n\t\t\t.removeAttr( \"aria-disabled\" )\n\t\t\t.children( \"a\" )\n\t\t\t\t.removeUniqueId()\n\t\t\t\t.removeClass( \"ui-corner-all ui-state-hover\" )\n\t\t\t\t.removeAttr( \"tabIndex\" )\n\t\t\t\t.removeAttr( \"role\" )\n\t\t\t\t.removeAttr( \"aria-haspopup\" )\n\t\t\t\t.children().each( function() {\n\t\t\t\t\tvar elem = $( this );\n\t\t\t\t\tif ( elem.data( \"ui-menu-submenu-carat\" ) ) {\n\t\t\t\t\t\telem.remove();\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t// Destroy menu dividers\n\t\tthis.element.find( \".ui-menu-divider\" ).removeClass( \"ui-menu-divider ui-widget-content\" );\n\t},\n\n\t_keydown: function( event ) {\n\t\tvar match, prev, character, skip, regex,\n\t\t\tpreventDefault = true;\n\n\t\tfunction escape( value ) {\n\t\t\treturn value.replace( /[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\" );\n\t\t}\n\n\t\tswitch ( event.keyCode ) {\n\t\tcase $.ui.keyCode.PAGE_UP:\n\t\t\tthis.previousPage( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.PAGE_DOWN:\n\t\t\tthis.nextPage( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.HOME:\n\t\t\tthis._move( \"first\", \"first\", event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.END:\n\t\t\tthis._move( \"last\", \"last\", event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.UP:\n\t\t\tthis.previous( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.DOWN:\n\t\t\tthis.next( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.LEFT:\n\t\t\tthis.collapse( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.RIGHT:\n\t\t\tif ( this.active && !this.active.is( \".ui-state-disabled\" ) ) {\n\t\t\t\tthis.expand( event );\n\t\t\t}\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.ENTER:\n\t\tcase $.ui.keyCode.SPACE:\n\t\t\tthis._activate( event );\n\t\t\tbreak;\n\t\tcase $.ui.keyCode.ESCAPE:\n\t\t\tthis.collapse( event );\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tpreventDefault = false;\n\t\t\tprev = this.previousFilter || \"\";\n\t\t\tcharacter = String.fromCharCode( event.keyCode );\n\t\t\tskip = false;\n\n\t\t\tclearTimeout( this.filterTimer );\n\n\t\t\tif ( character === prev ) {\n\t\t\t\tskip = true;\n\t\t\t} else {\n\t\t\t\tcharacter = prev + character;\n\t\t\t}\n\n\t\t\tregex = new RegExp( \"^\" + escape( character ), \"i\" );\n\t\t\tmatch = this.activeMenu.children( \".ui-menu-item\" ).filter(function() {\n\t\t\t\treturn regex.test( $( this ).children( \"a\" ).text() );\n\t\t\t});\n\t\t\tmatch = skip && match.index( this.active.next() ) !== -1 ?\n\t\t\t\tthis.active.nextAll( \".ui-menu-item\" ) :\n\t\t\t\tmatch;\n\n\t\t\t// If no matches on the current filter, reset to the last character pressed\n\t\t\t// to move down the menu to the first item that starts with that character\n\t\t\tif ( !match.length ) {\n\t\t\t\tcharacter = String.fromCharCode( event.keyCode );\n\t\t\t\tregex = new RegExp( \"^\" + escape( character ), \"i\" );\n\t\t\t\tmatch = this.activeMenu.children( \".ui-menu-item\" ).filter(function() {\n\t\t\t\t\treturn regex.test( $( this ).children( \"a\" ).text() );\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif ( match.length ) {\n\t\t\t\tthis.focus( event, match );\n\t\t\t\tif ( match.length > 1 ) {\n\t\t\t\t\tthis.previousFilter = character;\n\t\t\t\t\tthis.filterTimer = this._delay(function() {\n\t\t\t\t\t\tdelete this.previousFilter;\n\t\t\t\t\t}, 1000 );\n\t\t\t\t} else {\n\t\t\t\t\tdelete this.previousFilter;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tdelete this.previousFilter;\n\t\t\t}\n\t\t}\n\n\t\tif ( preventDefault ) {\n\t\t\tevent.preventDefault();\n\t\t}\n\t},\n\n\t_activate: function( event ) {\n\t\tif ( !this.active.is( \".ui-state-disabled\" ) ) {\n\t\t\tif ( this.active.children( \"a[aria-haspopup='true']\" ).length ) {\n\t\t\t\tthis.expand( event );\n\t\t\t} else {\n\t\t\t\tthis.select( event );\n\t\t\t}\n\t\t}\n\t},\n\n\trefresh: function() {\n\t\tvar menus,\n\t\t\ticon = this.options.icons.submenu,\n\t\t\tsubmenus = this.element.find( this.options.menus );\n\n\t\t// Initialize nested menus\n\t\tsubmenus.filter( \":not(.ui-menu)\" )\n\t\t\t.addClass( \"ui-menu ui-widget ui-widget-content ui-corner-all\" )\n\t\t\t.hide()\n\t\t\t.attr({\n\t\t\t\trole: this.options.role,\n\t\t\t\t\"aria-hidden\": \"true\",\n\t\t\t\t\"aria-expanded\": \"false\"\n\t\t\t})\n\t\t\t.each(function() {\n\t\t\t\tvar menu = $( this ),\n\t\t\t\t\titem = menu.prev( \"a\" ),\n\t\t\t\t\tsubmenuCarat = $( \"<span>\" )\n\t\t\t\t\t\t.addClass( \"ui-menu-icon ui-icon \" + icon )\n\t\t\t\t\t\t.data( \"ui-menu-submenu-carat\", true );\n\n\t\t\t\titem\n\t\t\t\t\t.attr( \"aria-haspopup\", \"true\" )\n\t\t\t\t\t.prepend( submenuCarat );\n\t\t\t\tmenu.attr( \"aria-labelledby\", item.attr( \"id\" ) );\n\t\t\t});\n\n\t\tmenus = submenus.add( this.element );\n\n\t\t// Don't refresh list items that are already adapted\n\t\tmenus.children( \":not(.ui-menu-item):has(a)\" )\n\t\t\t.addClass( \"ui-menu-item\" )\n\t\t\t.attr( \"role\", \"presentation\" )\n\t\t\t.children( \"a\" )\n\t\t\t\t.uniqueId()\n\t\t\t\t.addClass( \"ui-corner-all\" )\n\t\t\t\t.attr({\n\t\t\t\t\ttabIndex: -1,\n\t\t\t\t\trole: this._itemRole()\n\t\t\t\t});\n\n\t\t// Initialize unlinked menu-items containing spaces and/or dashes only as dividers\n\t\tmenus.children( \":not(.ui-menu-item)\" ).each(function() {\n\t\t\tvar item = $( this );\n\t\t\t// hyphen, em dash, en dash\n\t\t\tif ( !/[^\\-\u2014\u2013\\s]/.test( item.text() ) ) {\n\t\t\t\titem.addClass( \"ui-widget-content ui-menu-divider\" );\n\t\t\t}\n\t\t});\n\n\t\t// Add aria-disabled attribute to any disabled menu item\n\t\tmenus.children( \".ui-state-disabled\" ).attr( \"aria-disabled\", \"true\" );\n\n\t\t// If the active item has been removed, blur the menu\n\t\tif ( this.active && !$.contains( this.element[ 0 ], this.active[ 0 ] ) ) {\n\t\t\tthis.blur();\n\t\t}\n\t},\n\n\t_itemRole: function() {\n\t\treturn {\n\t\t\tmenu: \"menuitem\",\n\t\t\tlistbox: \"option\"\n\t\t}[ this.options.role ];\n\t},\n\n\tfocus: function( event, item ) {\n\t\tvar nested, focused;\n\t\tthis.blur( event, event && event.type === \"focus\" );\n\n\t\tthis._scrollIntoView( item );\n\n\t\tthis.active = item.first();\n\t\tfocused = this.active.children( \"a\" ).addClass( \"ui-state-focus\" );\n\t\t// Only update aria-activedescendant if there's a role\n\t\t// otherwise we assume focus is managed elsewhere\n\t\tif ( this.options.role ) {\n\t\t\tthis.element.attr( \"aria-activedescendant\", focused.attr( \"id\" ) );\n\t\t}\n\n\t\t// Highlight active parent menu item, if any\n\t\tthis.active\n\t\t\t.parent()\n\t\t\t.closest( \".ui-menu-item\" )\n\t\t\t.children( \"a:first\" )\n\t\t\t.addClass( \"ui-state-active\" );\n\n\t\tif ( event && event.type === \"keydown\" ) {\n\t\t\tthis._close();\n\t\t} else {\n\t\t\tthis.timer = this._delay(function() {\n\t\t\t\tthis._close();\n\t\t\t}, this.delay );\n\t\t}\n\n\t\tnested = item.children( \".ui-menu\" );\n\t\tif ( nested.length && ( /^mouse/.test( event.type ) ) ) {\n\t\t\tthis._startOpening(nested);\n\t\t}\n\t\tthis.activeMenu = item.parent();\n\n\t\tthis._trigger( \"focus\", event, { item: item } );\n\t},\n\n\t_scrollIntoView: function( item ) {\n\t\tvar borderTop, paddingTop, offset, scroll, elementHeight, itemHeight;\n\t\tif ( this._hasScroll() ) {\n\t\t\tborderTop = parseFloat( $.css( this.activeMenu[0], \"borderTopWidth\" ) ) || 0;\n\t\t\tpaddingTop = parseFloat( $.css( this.activeMenu[0], \"paddingTop\" ) ) || 0;\n\t\t\toffset = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop;\n\t\t\tscroll = this.activeMenu.scrollTop();\n\t\t\telementHeight = this.activeMenu.height();\n\t\t\titemHeight = item.height();\n\n\t\t\tif ( offset < 0 ) {\n\t\t\t\tthis.activeMenu.scrollTop( scroll + offset );\n\t\t\t} else if ( offset + itemHeight > elementHeight ) {\n\t\t\t\tthis.activeMenu.scrollTop( scroll + offset - elementHeight + itemHeight );\n\t\t\t}\n\t\t}\n\t},\n\n\tblur: function( event, fromFocus ) {\n\t\tif ( !fromFocus ) {\n\t\t\tclearTimeout( this.timer );\n\t\t}\n\n\t\tif ( !this.active ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.active.children( \"a\" ).removeClass( \"ui-state-focus\" );\n\t\tthis.active = null;\n\n\t\tthis._trigger( \"blur\", event, { item: this.active } );\n\t},\n\n\t_startOpening: function( submenu ) {\n\t\tclearTimeout( this.timer );\n\n\t\t// Don't open if already open fixes a Firefox bug that caused a .5 pixel\n\t\t// shift in the submenu position when mousing over the carat icon\n\t\tif ( submenu.attr( \"aria-hidden\" ) !== \"true\" ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.timer = this._delay(function() {\n\t\t\tthis._close();\n\t\t\tthis._open( submenu );\n\t\t}, this.delay );\n\t},\n\n\t_open: function( submenu ) {\n\t\tvar position = $.extend({\n\t\t\tof: this.active\n\t\t}, this.options.position );\n\n\t\tclearTimeout( this.timer );\n\t\tthis.element.find( \".ui-menu\" ).not( submenu.parents( \".ui-menu\" ) )\n\t\t\t.hide()\n\t\t\t.attr( \"aria-hidden\", \"true\" );\n\n\t\tsubmenu\n\t\t\t.show()\n\t\t\t.removeAttr( \"aria-hidden\" )\n\t\t\t.attr( \"aria-expanded\", \"true\" )\n\t\t\t.position( position );\n\t},\n\n\tcollapseAll: function( event, all ) {\n\t\tclearTimeout( this.timer );\n\t\tthis.timer = this._delay(function() {\n\t\t\t// If we were passed an event, look for the submenu that contains the event\n\t\t\tvar currentMenu = all ? this.element :\n\t\t\t\t$( event && event.target ).closest( this.element.find( \".ui-menu\" ) );\n\n\t\t\t// If we found no valid submenu ancestor, use the main menu to close all sub menus anyway\n\t\t\tif ( !currentMenu.length ) {\n\t\t\t\tcurrentMenu = this.element;\n\t\t\t}\n\n\t\t\tthis._close( currentMenu );\n\n\t\t\tthis.blur( event );\n\t\t\tthis.activeMenu = currentMenu;\n\t\t}, this.delay );\n\t},\n\n\t// With no arguments, closes the currently active menu - if nothing is active\n\t// it closes all menus.  If passed an argument, it will search for menus BELOW\n\t_close: function( startMenu ) {\n\t\tif ( !startMenu ) {\n\t\t\tstartMenu = this.active ? this.active.parent() : this.element;\n\t\t}\n\n\t\tstartMenu\n\t\t\t.find( \".ui-menu\" )\n\t\t\t\t.hide()\n\t\t\t\t.attr( \"aria-hidden\", \"true\" )\n\t\t\t\t.attr( \"aria-expanded\", \"false\" )\n\t\t\t.end()\n\t\t\t.find( \"a.ui-state-active\" )\n\t\t\t\t.removeClass( \"ui-state-active\" );\n\t},\n\n\tcollapse: function( event ) {\n\t\tvar newItem = this.active &&\n\t\t\tthis.active.parent().closest( \".ui-menu-item\", this.element );\n\t\tif ( newItem && newItem.length ) {\n\t\t\tthis._close();\n\t\t\tthis.focus( event, newItem );\n\t\t}\n\t},\n\n\texpand: function( event ) {\n\t\tvar newItem = this.active &&\n\t\t\tthis.active\n\t\t\t\t.children( \".ui-menu \" )\n\t\t\t\t.children( \".ui-menu-item\" )\n\t\t\t\t.first();\n\n\t\tif ( newItem && newItem.length ) {\n\t\t\tthis._open( newItem.parent() );\n\n\t\t\t// Delay so Firefox will not hide activedescendant change in expanding submenu from AT\n\t\t\tthis._delay(function() {\n\t\t\t\tthis.focus( event, newItem );\n\t\t\t});\n\t\t}\n\t},\n\n\tnext: function( event ) {\n\t\tthis._move( \"next\", \"first\", event );\n\t},\n\n\tprevious: function( event ) {\n\t\tthis._move( \"prev\", \"last\", event );\n\t},\n\n\tisFirstItem: function() {\n\t\treturn this.active && !this.active.prevAll( \".ui-menu-item\" ).length;\n\t},\n\n\tisLastItem: function() {\n\t\treturn this.active && !this.active.nextAll( \".ui-menu-item\" ).length;\n\t},\n\n\t_move: function( direction, filter, event ) {\n\t\tvar next;\n\t\tif ( this.active ) {\n\t\t\tif ( direction === \"first\" || direction === \"last\" ) {\n\t\t\t\tnext = this.active\n\t\t\t\t\t[ direction === \"first\" ? \"prevAll\" : \"nextAll\" ]( \".ui-menu-item\" )\n\t\t\t\t\t.eq( -1 );\n\t\t\t} else {\n\t\t\t\tnext = this.active\n\t\t\t\t\t[ direction + \"All\" ]( \".ui-menu-item\" )\n\t\t\t\t\t.eq( 0 );\n\t\t\t}\n\t\t}\n\t\tif ( !next || !next.length || !this.active ) {\n\t\t\tnext = this.activeMenu.children( \".ui-menu-item\" )[ filter ]();\n\t\t}\n\n\t\tthis.focus( event, next );\n\t},\n\n\tnextPage: function( event ) {\n\t\tvar item, base, height;\n\n\t\tif ( !this.active ) {\n\t\t\tthis.next( event );\n\t\t\treturn;\n\t\t}\n\t\tif ( this.isLastItem() ) {\n\t\t\treturn;\n\t\t}\n\t\tif ( this._hasScroll() ) {\n\t\t\tbase = this.active.offset().top;\n\t\t\theight = this.element.height();\n\t\t\tthis.active.nextAll( \".ui-menu-item\" ).each(function() {\n\t\t\t\titem = $( this );\n\t\t\t\treturn item.offset().top - base - height < 0;\n\t\t\t});\n\n\t\t\tthis.focus( event, item );\n\t\t} else {\n\t\t\tthis.focus( event, this.activeMenu.children( \".ui-menu-item\" )\n\t\t\t\t[ !this.active ? \"first\" : \"last\" ]() );\n\t\t}\n\t},\n\n\tpreviousPage: function( event ) {\n\t\tvar item, base, height;\n\t\tif ( !this.active ) {\n\t\t\tthis.next( event );\n\t\t\treturn;\n\t\t}\n\t\tif ( this.isFirstItem() ) {\n\t\t\treturn;\n\t\t}\n\t\tif ( this._hasScroll() ) {\n\t\t\tbase = this.active.offset().top;\n\t\t\theight = this.element.height();\n\t\t\tthis.active.prevAll( \".ui-menu-item\" ).each(function() {\n\t\t\t\titem = $( this );\n\t\t\t\treturn item.offset().top - base + height > 0;\n\t\t\t});\n\n\t\t\tthis.focus( event, item );\n\t\t} else {\n\t\t\tthis.focus( event, this.activeMenu.children( \".ui-menu-item\" ).first() );\n\t\t}\n\t},\n\n\t_hasScroll: function() {\n\t\treturn this.element.outerHeight() < this.element.prop( \"scrollHeight\" );\n\t},\n\n\tselect: function( event ) {\n\t\t// TODO: It should never be possible to not have an active item at this\n\t\t// point, but the tests don't trigger mouseenter before click.\n\t\tthis.active = this.active || $( event.target ).closest( \".ui-menu-item\" );\n\t\tvar ui = { item: this.active };\n\t\tif ( !this.active.has( \".ui-menu\" ).length ) {\n\t\t\tthis.collapseAll( event, true );\n\t\t}\n\t\tthis._trigger( \"select\", event, ui );\n\t}\n});\n\n}( jQuery ));\n\n(function( $, undefined ) {\n\n$.ui = $.ui || {};\n\nvar cachedScrollbarWidth,\n\tmax = Math.max,\n\tabs = Math.abs,\n\tround = Math.round,\n\trhorizontal = /left|center|right/,\n\trvertical = /top|center|bottom/,\n\troffset = /[\\+\\-]\\d+%?/,\n\trposition = /^\\w+/,\n\trpercent = /%$/,\n\t_position = $.fn.position;\n\nfunction getOffsets( offsets, width, height ) {\n\treturn [\n\t\tparseInt( offsets[ 0 ], 10 ) * ( rpercent.test( offsets[ 0 ] ) ? width / 100 : 1 ),\n\t\tparseInt( offsets[ 1 ], 10 ) * ( rpercent.test( offsets[ 1 ] ) ? height / 100 : 1 )\n\t];\n}\nfunction parseCss( element, property ) {\n\treturn parseInt( $.css( element, property ), 10 ) || 0;\n}\n\n$.position = {\n\tscrollbarWidth: function() {\n\t\tif ( cachedScrollbarWidth !== undefined ) {\n\t\t\treturn cachedScrollbarWidth;\n\t\t}\n\t\tvar w1, w2,\n\t\t\tdiv = $( \"<div style='display:block;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>\" ),\n\t\t\tinnerDiv = div.children()[0];\n\n\t\t$( \"body\" ).append( div );\n\t\tw1 = innerDiv.offsetWidth;\n\t\tdiv.css( \"overflow\", \"scroll\" );\n\n\t\tw2 = innerDiv.offsetWidth;\n\n\t\tif ( w1 === w2 ) {\n\t\t\tw2 = div[0].clientWidth;\n\t\t}\n\n\t\tdiv.remove();\n\n\t\treturn (cachedScrollbarWidth = w1 - w2);\n\t},\n\tgetScrollInfo: function( within ) {\n\t\tvar overflowX = within.isWindow ? \"\" : within.element.css( \"overflow-x\" ),\n\t\t\toverflowY = within.isWindow ? \"\" : within.element.css( \"overflow-y\" ),\n\t\t\thasOverflowX = overflowX === \"scroll\" ||\n\t\t\t\t( overflowX === \"auto\" && within.width < within.element[0].scrollWidth ),\n\t\t\thasOverflowY = overflowY === \"scroll\" ||\n\t\t\t\t( overflowY === \"auto\" && within.height < within.element[0].scrollHeight );\n\t\treturn {\n\t\t\twidth: hasOverflowX ? $.position.scrollbarWidth() : 0,\n\t\t\theight: hasOverflowY ? $.position.scrollbarWidth() : 0\n\t\t};\n\t},\n\tgetWithinInfo: function( element ) {\n\t\tvar withinElement = $( element || window ),\n\t\t\tisWindow = $.isWindow( withinElement[0] );\n\t\treturn {\n\t\t\telement: withinElement,\n\t\t\tisWindow: isWindow,\n\t\t\toffset: withinElement.offset() || { left: 0, top: 0 },\n\t\t\tscrollLeft: withinElement.scrollLeft(),\n\t\t\tscrollTop: withinElement.scrollTop(),\n\t\t\twidth: isWindow ? withinElement.width() : withinElement.outerWidth(),\n\t\t\theight: isWindow ? withinElement.height() : withinElement.outerHeight()\n\t\t};\n\t}\n};\n\n$.fn.position = function( options ) {\n\tif ( !options || !options.of ) {\n\t\treturn _position.apply( this, arguments );\n\t}\n\n\t// make a copy, we don't want to modify arguments\n\toptions = $.extend( {}, options );\n\n\tvar atOffset, targetWidth, targetHeight, targetOffset, basePosition,\n\t\ttarget = $( options.of ),\n\t\twithin = $.position.getWithinInfo( options.within ),\n\t\tscrollInfo = $.position.getScrollInfo( within ),\n\t\ttargetElem = target[0],\n\t\tcollision = ( options.collision || \"flip\" ).split( \" \" ),\n\t\toffsets = {};\n\n\tif ( targetElem.nodeType === 9 ) {\n\t\ttargetWidth = target.width();\n\t\ttargetHeight = target.height();\n\t\ttargetOffset = { top: 0, left: 0 };\n\t} else if ( $.isWindow( targetElem ) ) {\n\t\ttargetWidth = target.width();\n\t\ttargetHeight = target.height();\n\t\ttargetOffset = { top: target.scrollTop(), left: target.scrollLeft() };\n\t} else if ( targetElem.preventDefault ) {\n\t\t// force left top to allow flipping\n\t\toptions.at = \"left top\";\n\t\ttargetWidth = targetHeight = 0;\n\t\ttargetOffset = { top: targetElem.pageY, left: targetElem.pageX };\n\t} else {\n\t\ttargetWidth = target.outerWidth();\n\t\ttargetHeight = target.outerHeight();\n\t\ttargetOffset = target.offset();\n\t}\n\t// clone to reuse original targetOffset later\n\tbasePosition = $.extend( {}, targetOffset );\n\n\t// force my and at to have valid horizontal and vertical positions\n\t// if a value is missing or invalid, it will be converted to center\n\t$.each( [ \"my\", \"at\" ], function() {\n\t\tvar pos = ( options[ this ] || \"\" ).split( \" \" ),\n\t\t\thorizontalOffset,\n\t\t\tverticalOffset;\n\n\t\tif ( pos.length === 1) {\n\t\t\tpos = rhorizontal.test( pos[ 0 ] ) ?\n\t\t\t\tpos.concat( [ \"center\" ] ) :\n\t\t\t\trvertical.test( pos[ 0 ] ) ?\n\t\t\t\t\t[ \"center\" ].concat( pos ) :\n\t\t\t\t\t[ \"center\", \"center\" ];\n\t\t}\n\t\tpos[ 0 ] = rhorizontal.test( pos[ 0 ] ) ? pos[ 0 ] : \"center\";\n\t\tpos[ 1 ] = rvertical.test( pos[ 1 ] ) ? pos[ 1 ] : \"center\";\n\n\t\t// calculate offsets\n\t\thorizontalOffset = roffset.exec( pos[ 0 ] );\n\t\tverticalOffset = roffset.exec( pos[ 1 ] );\n\t\toffsets[ this ] = [\n\t\t\thorizontalOffset ? horizontalOffset[ 0 ] : 0,\n\t\t\tverticalOffset ? verticalOffset[ 0 ] : 0\n\t\t];\n\n\t\t// reduce to just the positions without the offsets\n\t\toptions[ this ] = [\n\t\t\trposition.exec( pos[ 0 ] )[ 0 ],\n\t\t\trposition.exec( pos[ 1 ] )[ 0 ]\n\t\t];\n\t});\n\n\t// normalize collision option\n\tif ( collision.length === 1 ) {\n\t\tcollision[ 1 ] = collision[ 0 ];\n\t}\n\n\tif ( options.at[ 0 ] === \"right\" ) {\n\t\tbasePosition.left += targetWidth;\n\t} else if ( options.at[ 0 ] === \"center\" ) {\n\t\tbasePosition.left += targetWidth / 2;\n\t}\n\n\tif ( options.at[ 1 ] === \"bottom\" ) {\n\t\tbasePosition.top += targetHeight;\n\t} else if ( options.at[ 1 ] === \"center\" ) {\n\t\tbasePosition.top += targetHeight / 2;\n\t}\n\n\tatOffset = getOffsets( offsets.at, targetWidth, targetHeight );\n\tbasePosition.left += atOffset[ 0 ];\n\tbasePosition.top += atOffset[ 1 ];\n\n\treturn this.each(function() {\n\t\tvar collisionPosition, using,\n\t\t\telem = $( this ),\n\t\t\telemWidth = elem.outerWidth(),\n\t\t\telemHeight = elem.outerHeight(),\n\t\t\tmarginLeft = parseCss( this, \"marginLeft\" ),\n\t\t\tmarginTop = parseCss( this, \"marginTop\" ),\n\t\t\tcollisionWidth = elemWidth + marginLeft + parseCss( this, \"marginRight\" ) + scrollInfo.width,\n\t\t\tcollisionHeight = elemHeight + marginTop + parseCss( this, \"marginBottom\" ) + scrollInfo.height,\n\t\t\tposition = $.extend( {}, basePosition ),\n\t\t\tmyOffset = getOffsets( offsets.my, elem.outerWidth(), elem.outerHeight() );\n\n\t\tif ( options.my[ 0 ] === \"right\" ) {\n\t\t\tposition.left -= elemWidth;\n\t\t} else if ( options.my[ 0 ] === \"center\" ) {\n\t\t\tposition.left -= elemWidth / 2;\n\t\t}\n\n\t\tif ( options.my[ 1 ] === \"bottom\" ) {\n\t\t\tposition.top -= elemHeight;\n\t\t} else if ( options.my[ 1 ] === \"center\" ) {\n\t\t\tposition.top -= elemHeight / 2;\n\t\t}\n\n\t\tposition.left += myOffset[ 0 ];\n\t\tposition.top += myOffset[ 1 ];\n\n\t\t// if the browser doesn't support fractions, then round for consistent results\n\t\tif ( !$.support.offsetFractions ) {\n\t\t\tposition.left = round( position.left );\n\t\t\tposition.top = round( position.top );\n\t\t}\n\n\t\tcollisionPosition = {\n\t\t\tmarginLeft: marginLeft,\n\t\t\tmarginTop: marginTop\n\t\t};\n\n\t\t$.each( [ \"left\", \"top\" ], function( i, dir ) {\n\t\t\tif ( $.ui.position[ collision[ i ] ] ) {\n\t\t\t\t$.ui.position[ collision[ i ] ][ dir ]( position, {\n\t\t\t\t\ttargetWidth: targetWidth,\n\t\t\t\t\ttargetHeight: targetHeight,\n\t\t\t\t\telemWidth: elemWidth,\n\t\t\t\t\telemHeight: elemHeight,\n\t\t\t\t\tcollisionPosition: collisionPosition,\n\t\t\t\t\tcollisionWidth: collisionWidth,\n\t\t\t\t\tcollisionHeight: collisionHeight,\n\t\t\t\t\toffset: [ atOffset[ 0 ] + myOffset[ 0 ], atOffset [ 1 ] + myOffset[ 1 ] ],\n\t\t\t\t\tmy: options.my,\n\t\t\t\t\tat: options.at,\n\t\t\t\t\twithin: within,\n\t\t\t\t\telem : elem\n\t\t\t\t});\n\t\t\t}\n\t\t});\n\n\t\tif ( $.fn.bgiframe ) {\n\t\t\telem.bgiframe();\n\t\t}\n\n\t\tif ( options.using ) {\n\t\t\t// adds feedback as second argument to using callback, if present\n\t\t\tusing = function( props ) {\n\t\t\t\tvar left = targetOffset.left - position.left,\n\t\t\t\t\tright = left + targetWidth - elemWidth,\n\t\t\t\t\ttop = targetOffset.top - position.top,\n\t\t\t\t\tbottom = top + targetHeight - elemHeight,\n\t\t\t\t\tfeedback = {\n\t\t\t\t\t\ttarget: {\n\t\t\t\t\t\t\telement: target,\n\t\t\t\t\t\t\tleft: targetOffset.left,\n\t\t\t\t\t\t\ttop: targetOffset.top,\n\t\t\t\t\t\t\twidth: targetWidth,\n\t\t\t\t\t\t\theight: targetHeight\n\t\t\t\t\t\t},\n\t\t\t\t\t\telement: {\n\t\t\t\t\t\t\telement: elem,\n\t\t\t\t\t\t\tleft: position.left,\n\t\t\t\t\t\t\ttop: position.top,\n\t\t\t\t\t\t\twidth: elemWidth,\n\t\t\t\t\t\t\theight: elemHeight\n\t\t\t\t\t\t},\n\t\t\t\t\t\thorizontal: right < 0 ? \"left\" : left > 0 ? \"right\" : \"center\",\n\t\t\t\t\t\tvertical: bottom < 0 ? \"top\" : top > 0 ? \"bottom\" : \"middle\"\n\t\t\t\t\t};\n\t\t\t\tif ( targetWidth < elemWidth && abs( left + right ) < targetWidth ) {\n\t\t\t\t\tfeedback.horizontal = \"center\";\n\t\t\t\t}\n\t\t\t\tif ( targetHeight < elemHeight && abs( top + bottom ) < targetHeight ) {\n\t\t\t\t\tfeedback.vertical = \"middle\";\n\t\t\t\t}\n\t\t\t\tif ( max( abs( left ), abs( right ) ) > max( abs( top ), abs( bottom ) ) ) {\n\t\t\t\t\tfeedback.important = \"horizontal\";\n\t\t\t\t} else {\n\t\t\t\t\tfeedback.important = \"vertical\";\n\t\t\t\t}\n\t\t\t\toptions.using.call( this, props, feedback );\n\t\t\t};\n\t\t}\n\n\t\telem.offset( $.extend( position, { using: using } ) );\n\t});\n};\n\n$.ui.position = {\n\tfit: {\n\t\tleft: function( position, data ) {\n\t\t\tvar within = data.within,\n\t\t\t\twithinOffset = within.isWindow ? within.scrollLeft : within.offset.left,\n\t\t\t\touterWidth = within.width,\n\t\t\t\tcollisionPosLeft = position.left - data.collisionPosition.marginLeft,\n\t\t\t\toverLeft = withinOffset - collisionPosLeft,\n\t\t\t\toverRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset,\n\t\t\t\tnewOverRight;\n\n\t\t\t// element is wider than within\n\t\t\tif ( data.collisionWidth > outerWidth ) {\n\t\t\t\t// element is initially over the left side of within\n\t\t\t\tif ( overLeft > 0 && overRight <= 0 ) {\n\t\t\t\t\tnewOverRight = position.left + overLeft + data.collisionWidth - outerWidth - withinOffset;\n\t\t\t\t\tposition.left += overLeft - newOverRight;\n\t\t\t\t// element is initially over right side of within\n\t\t\t\t} else if ( overRight > 0 && overLeft <= 0 ) {\n\t\t\t\t\tposition.left = withinOffset;\n\t\t\t\t// element is initially over both left and right sides of within\n\t\t\t\t} else {\n\t\t\t\t\tif ( overLeft > overRight ) {\n\t\t\t\t\t\tposition.left = withinOffset + outerWidth - data.collisionWidth;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tposition.left = withinOffset;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t// too far left -> align with left edge\n\t\t\t} else if ( overLeft > 0 ) {\n\t\t\t\tposition.left += overLeft;\n\t\t\t// too far right -> align with right edge\n\t\t\t} else if ( overRight > 0 ) {\n\t\t\t\tposition.left -= overRight;\n\t\t\t// adjust based on position and margin\n\t\t\t} else {\n\t\t\t\tposition.left = max( position.left - collisionPosLeft, position.left );\n\t\t\t}\n\t\t},\n\t\ttop: function( position, data ) {\n\t\t\tvar within = data.within,\n\t\t\t\twithinOffset = within.isWindow ? within.scrollTop : within.offset.top,\n\t\t\t\touterHeight = data.within.height,\n\t\t\t\tcollisionPosTop = position.top - data.collisionPosition.marginTop,\n\t\t\t\toverTop = withinOffset - collisionPosTop,\n\t\t\t\toverBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset,\n\t\t\t\tnewOverBottom;\n\n\t\t\t// element is taller than within\n\t\t\tif ( data.collisionHeight > outerHeight ) {\n\t\t\t\t// element is initially over the top of within\n\t\t\t\tif ( overTop > 0 && overBottom <= 0 ) {\n\t\t\t\t\tnewOverBottom = position.top + overTop + data.collisionHeight - outerHeight - withinOffset;\n\t\t\t\t\tposition.top += overTop - newOverBottom;\n\t\t\t\t// element is initially over bottom of within\n\t\t\t\t} else if ( overBottom > 0 && overTop <= 0 ) {\n\t\t\t\t\tposition.top = withinOffset;\n\t\t\t\t// element is initially over both top and bottom of within\n\t\t\t\t} else {\n\t\t\t\t\tif ( overTop > overBottom ) {\n\t\t\t\t\t\tposition.top = withinOffset + outerHeight - data.collisionHeight;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tposition.top = withinOffset;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t// too far up -> align with top\n\t\t\t} else if ( overTop > 0 ) {\n\t\t\t\tposition.top += overTop;\n\t\t\t// too far down -> align with bottom edge\n\t\t\t} else if ( overBottom > 0 ) {\n\t\t\t\tposition.top -= overBottom;\n\t\t\t// adjust based on position and margin\n\t\t\t} else {\n\t\t\t\tposition.top = max( position.top - collisionPosTop, position.top );\n\t\t\t}\n\t\t}\n\t},\n\tflip: {\n\t\tleft: function( position, data ) {\n\t\t\tvar within = data.within,\n\t\t\t\twithinOffset = within.offset.left + within.scrollLeft,\n\t\t\t\touterWidth = within.width,\n\t\t\t\toffsetLeft = within.isWindow ? within.scrollLeft : within.offset.left,\n\t\t\t\tcollisionPosLeft = position.left - data.collisionPosition.marginLeft,\n\t\t\t\toverLeft = collisionPosLeft - offsetLeft,\n\t\t\t\toverRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft,\n\t\t\t\tmyOffset = data.my[ 0 ] === \"left\" ?\n\t\t\t\t\t-data.elemWidth :\n\t\t\t\t\tdata.my[ 0 ] === \"right\" ?\n\t\t\t\t\t\tdata.elemWidth :\n\t\t\t\t\t\t0,\n\t\t\t\tatOffset = data.at[ 0 ] === \"left\" ?\n\t\t\t\t\tdata.targetWidth :\n\t\t\t\t\tdata.at[ 0 ] === \"right\" ?\n\t\t\t\t\t\t-data.targetWidth :\n\t\t\t\t\t\t0,\n\t\t\t\toffset = -2 * data.offset[ 0 ],\n\t\t\t\tnewOverRight,\n\t\t\t\tnewOverLeft;\n\n\t\t\tif ( overLeft < 0 ) {\n\t\t\t\tnewOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth - outerWidth - withinOffset;\n\t\t\t\tif ( newOverRight < 0 || newOverRight < abs( overLeft ) ) {\n\t\t\t\t\tposition.left += myOffset + atOffset + offset;\n\t\t\t\t}\n\t\t\t}\n\t\t\telse if ( overRight > 0 ) {\n\t\t\t\tnewOverLeft = position.left - data.collisionPosition.marginLeft + myOffset + atOffset + offset - offsetLeft;\n\t\t\t\tif ( newOverLeft > 0 || abs( newOverLeft ) < overRight ) {\n\t\t\t\t\tposition.left += myOffset + atOffset + offset;\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\ttop: function( position, data ) {\n\t\t\tvar within = data.within,\n\t\t\t\twithinOffset = within.offset.top + within.scrollTop,\n\t\t\t\touterHeight = within.height,\n\t\t\t\toffsetTop = within.isWindow ? within.scrollTop : within.offset.top,\n\t\t\t\tcollisionPosTop = position.top - data.collisionPosition.marginTop,\n\t\t\t\toverTop = collisionPosTop - offsetTop,\n\t\t\t\toverBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop,\n\t\t\t\ttop = data.my[ 1 ] === \"top\",\n\t\t\t\tmyOffset = top ?\n\t\t\t\t\t-data.elemHeight :\n\t\t\t\t\tdata.my[ 1 ] === \"bottom\" ?\n\t\t\t\t\t\tdata.elemHeight :\n\t\t\t\t\t\t0,\n\t\t\t\tatOffset = data.at[ 1 ] === \"top\" ?\n\t\t\t\t\tdata.targetHeight :\n\t\t\t\t\tdata.at[ 1 ] === \"bottom\" ?\n\t\t\t\t\t\t-data.targetHeight :\n\t\t\t\t\t\t0,\n\t\t\t\toffset = -2 * data.offset[ 1 ],\n\t\t\t\tnewOverTop,\n\t\t\t\tnewOverBottom;\n\t\t\tif ( overTop < 0 ) {\n\t\t\t\tnewOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight - outerHeight - withinOffset;\n\t\t\t\tif ( ( position.top + myOffset + atOffset + offset) > overTop && ( newOverBottom < 0 || newOverBottom < abs( overTop ) ) ) {\n\t\t\t\t\tposition.top += myOffset + atOffset + offset;\n\t\t\t\t}\n\t\t\t}\n\t\t\telse if ( overBottom > 0 ) {\n\t\t\t\tnewOverTop = position.top -  data.collisionPosition.marginTop + myOffset + atOffset + offset - offsetTop;\n\t\t\t\tif ( ( position.top + myOffset + atOffset + offset) > overBottom && ( newOverTop > 0 || abs( newOverTop ) < overBottom ) ) {\n\t\t\t\t\tposition.top += myOffset + atOffset + offset;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\tflipfit: {\n\t\tleft: function() {\n\t\t\t$.ui.position.flip.left.apply( this, arguments );\n\t\t\t$.ui.position.fit.left.apply( this, arguments );\n\t\t},\n\t\ttop: function() {\n\t\t\t$.ui.position.flip.top.apply( this, arguments );\n\t\t\t$.ui.position.fit.top.apply( this, arguments );\n\t\t}\n\t}\n};\n\n// fraction support test\n(function () {\n\tvar testElement, testElementParent, testElementStyle, offsetLeft, i,\n\t\tbody = document.getElementsByTagName( \"body\" )[ 0 ],\n\t\tdiv = document.createElement( \"div\" );\n\n\t//Create a \"fake body\" for testing based on method used in jQuery.support\n\ttestElement = document.createElement( body ? \"div\" : \"body\" );\n\ttestElementStyle = {\n\t\tvisibility: \"hidden\",\n\t\twidth: 0,\n\t\theight: 0,\n\t\tborder: 0,\n\t\tmargin: 0,\n\t\tbackground: \"none\"\n\t};\n\tif ( body ) {\n\t\t$.extend( testElementStyle, {\n\t\t\tposition: \"absolute\",\n\t\t\tleft: \"-1000px\",\n\t\t\ttop: \"-1000px\"\n\t\t});\n\t}\n\tfor ( i in testElementStyle ) {\n\t\ttestElement.style[ i ] = testElementStyle[ i ];\n\t}\n\ttestElement.appendChild( div );\n\ttestElementParent = body || document.documentElement;\n\ttestElementParent.insertBefore( testElement, testElementParent.firstChild );\n\n\tdiv.style.cssText = \"position: absolute; left: 10.7432222px;\";\n\n\toffsetLeft = $( div ).offset().left;\n\t$.support.offsetFractions = offsetLeft > 10 && offsetLeft < 11;\n\n\ttestElement.innerHTML = \"\";\n\ttestElementParent.removeChild( testElement );\n})();\n\n// DEPRECATED\nif ( $.uiBackCompat !== false ) {\n\t// offset option\n\t(function( $ ) {\n\t\tvar _position = $.fn.position;\n\t\t$.fn.position = function( options ) {\n\t\t\tif ( !options || !options.offset ) {\n\t\t\t\treturn _position.call( this, options );\n\t\t\t}\n\t\t\tvar offset = options.offset.split( \" \" ),\n\t\t\t\tat = options.at.split( \" \" );\n\t\t\tif ( offset.length === 1 ) {\n\t\t\t\toffset[ 1 ] = offset[ 0 ];\n\t\t\t}\n\t\t\tif ( /^\\d/.test( offset[ 0 ] ) ) {\n\t\t\t\toffset[ 0 ] = \"+\" + offset[ 0 ];\n\t\t\t}\n\t\t\tif ( /^\\d/.test( offset[ 1 ] ) ) {\n\t\t\t\toffset[ 1 ] = \"+\" + offset[ 1 ];\n\t\t\t}\n\t\t\tif ( at.length === 1 ) {\n\t\t\t\tif ( /left|center|right/.test( at[ 0 ] ) ) {\n\t\t\t\t\tat[ 1 ] = \"center\";\n\t\t\t\t} else {\n\t\t\t\t\tat[ 1 ] = at[ 0 ];\n\t\t\t\t\tat[ 0 ] = \"center\";\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn _position.call( this, $.extend( options, {\n\t\t\t\tat: at[ 0 ] + offset[ 0 ] + \" \" + at[ 1 ] + offset[ 1 ],\n\t\t\t\toffset: undefined\n\t\t\t} ) );\n\t\t};\n\t}( jQuery ) );\n}\n\n}( jQuery ) );\n\n(function( $, undefined ) {\n\n$.widget( \"ui.progressbar\", {\n\tversion: \"1.9.2\",\n\toptions: {\n\t\tvalue: 0,\n\t\tmax: 100\n\t},\n\n\tmin: 0,\n\n\t_create: function() {\n\t\tthis.element\n\t\t\t.addClass( \"ui-progressbar ui-widget ui-widget-content ui-corner-all\" )\n\t\t\t.attr({\n\t\t\t\trole: \"progressbar\",\n\t\t\t\t\"aria-valuemin\": this.min,\n\t\t\t\t\"aria-valuemax\": this.options.max,\n\t\t\t\t\"aria-valuenow\": this._value()\n\t\t\t});\n\n\t\tthis.valueDiv = $( \"<div class='ui-progressbar-value ui-widget-header ui-corner-left'></div>\" )\n\t\t\t.appendTo( this.element );\n\n\t\tthis.oldValue = this._value();\n\t\tthis._refreshValue();\n\t},\n\n\t_destroy: function() {\n\t\tthis.element\n\t\t\t.removeClass( \"ui-progressbar ui-widget ui-widget-content ui-corner-all\" )\n\t\t\t.removeAttr( \"role\" )\n\t\t\t.removeAttr( \"aria-valuemin\" )\n\t\t\t.removeAttr( \"aria-valuemax\" )\n\t\t\t.removeAttr( \"aria-valuenow\" );\n\n\t\tthis.valueDiv.remove();\n\t},\n\n\tvalue: function( newValue ) {\n\t\tif ( newValue === undefined ) {\n\t\t\treturn this._value();\n\t\t}\n\n\t\tthis._setOption( \"value\", newValue );\n\t\treturn this;\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"value\" ) {\n\t\t\tthis.options.value = value;\n\t\t\tthis._refreshValue();\n\t\t\tif ( this._value() === this.options.max ) {\n\t\t\t\tthis._trigger( \"complete\" );\n\t\t\t}\n\t\t}\n\n\t\tthis._super( key, value );\n\t},\n\n\t_value: function() {\n\t\tvar val = this.options.value;\n\t\t// normalize invalid value\n\t\tif ( typeof val !== \"number\" ) {\n\t\t\tval = 0;\n\t\t}\n\t\treturn Math.min( this.options.max, Math.max( this.min, val ) );\n\t},\n\n\t_percentage: function() {\n\t\treturn 100 * this._value() / this.options.max;\n\t},\n\n\t_refreshValue: function() {\n\t\tvar value = this.value(),\n\t\t\tpercentage = this._percentage();\n\n\t\tif ( this.oldValue !== value ) {\n\t\t\tthis.oldValue = value;\n\t\t\tthis._trigger( \"change\" );\n\t\t}\n\n\t\tthis.valueDiv\n\t\t\t.toggle( value > this.min )\n\t\t\t.toggleClass( \"ui-corner-right\", value === this.options.max )\n\t\t\t.width( percentage.toFixed(0) + \"%\" );\n\t\tthis.element.attr( \"aria-valuenow\", value );\n\t}\n});\n\n})( jQuery );\n\n(function( $, undefined ) {\n\n// number of pages in a slider\n// (how many times can you page up/down to go through the whole range)\nvar numPages = 5;\n\n$.widget( \"ui.slider\", $.ui.mouse, {\n\tversion: \"1.9.2\",\n\twidgetEventPrefix: \"slide\",\n\n\toptions: {\n\t\tanimate: false,\n\t\tdistance: 0,\n\t\tmax: 100,\n\t\tmin: 0,\n\t\torientation: \"horizontal\",\n\t\trange: false,\n\t\tstep: 1,\n\t\tvalue: 0,\n\t\tvalues: null\n\t},\n\n\t_create: function() {\n\t\tvar i, handleCount,\n\t\t\to = this.options,\n\t\t\texistingHandles = this.element.find( \".ui-slider-handle\" ).addClass( \"ui-state-default ui-corner-all\" ),\n\t\t\thandle = \"<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>\",\n\t\t\thandles = [];\n\n\t\tthis._keySliding = false;\n\t\tthis._mouseSliding = false;\n\t\tthis._animateOff = true;\n\t\tthis._handleIndex = null;\n\t\tthis._detectOrientation();\n\t\tthis._mouseInit();\n\n\t\tthis.element\n\t\t\t.addClass( \"ui-slider\" +\n\t\t\t\t\" ui-slider-\" + this.orientation +\n\t\t\t\t\" ui-widget\" +\n\t\t\t\t\" ui-widget-content\" +\n\t\t\t\t\" ui-corner-all\" +\n\t\t\t\t( o.disabled ? \" ui-slider-disabled ui-disabled\" : \"\" ) );\n\n\t\tthis.range = $([]);\n\n\t\tif ( o.range ) {\n\t\t\tif ( o.range === true ) {\n\t\t\t\tif ( !o.values ) {\n\t\t\t\t\to.values = [ this._valueMin(), this._valueMin() ];\n\t\t\t\t}\n\t\t\t\tif ( o.values.length && o.values.length !== 2 ) {\n\t\t\t\t\to.values = [ o.values[0], o.values[0] ];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tthis.range = $( \"<div></div>\" )\n\t\t\t\t.appendTo( this.element )\n\t\t\t\t.addClass( \"ui-slider-range\" +\n\t\t\t\t// note: this isn't the most fittingly semantic framework class for this element,\n\t\t\t\t// but worked best visually with a variety of themes\n\t\t\t\t\" ui-widget-header\" +\n\t\t\t\t( ( o.range === \"min\" || o.range === \"max\" ) ? \" ui-slider-range-\" + o.range : \"\" ) );\n\t\t}\n\n\t\thandleCount = ( o.values && o.values.length ) || 1;\n\n\t\tfor ( i = existingHandles.length; i < handleCount; i++ ) {\n\t\t\thandles.push( handle );\n\t\t}\n\n\t\tthis.handles = existingHandles.add( $( handles.join( \"\" ) ).appendTo( this.element ) );\n\n\t\tthis.handle = this.handles.eq( 0 );\n\n\t\tthis.handles.add( this.range ).filter( \"a\" )\n\t\t\t.click(function( event ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t})\n\t\t\t.mouseenter(function() {\n\t\t\t\tif ( !o.disabled ) {\n\t\t\t\t\t$( this ).addClass( \"ui-state-hover\" );\n\t\t\t\t}\n\t\t\t})\n\t\t\t.mouseleave(function() {\n\t\t\t\t$( this ).removeClass( \"ui-state-hover\" );\n\t\t\t})\n\t\t\t.focus(function() {\n\t\t\t\tif ( !o.disabled ) {\n\t\t\t\t\t$( \".ui-slider .ui-state-focus\" ).removeClass( \"ui-state-focus\" );\n\t\t\t\t\t$( this ).addClass( \"ui-state-focus\" );\n\t\t\t\t} else {\n\t\t\t\t\t$( this ).blur();\n\t\t\t\t}\n\t\t\t})\n\t\t\t.blur(function() {\n\t\t\t\t$( this ).removeClass( \"ui-state-focus\" );\n\t\t\t});\n\n\t\tthis.handles.each(function( i ) {\n\t\t\t$( this ).data( \"ui-slider-handle-index\", i );\n\t\t});\n\n\t\tthis._on( this.handles, {\n\t\t\tkeydown: function( event ) {\n\t\t\t\tvar allowed, curVal, newVal, step,\n\t\t\t\t\tindex = $( event.target ).data( \"ui-slider-handle-index\" );\n\n\t\t\t\tswitch ( event.keyCode ) {\n\t\t\t\t\tcase $.ui.keyCode.HOME:\n\t\t\t\t\tcase $.ui.keyCode.END:\n\t\t\t\t\tcase $.ui.keyCode.PAGE_UP:\n\t\t\t\t\tcase $.ui.keyCode.PAGE_DOWN:\n\t\t\t\t\tcase $.ui.keyCode.UP:\n\t\t\t\t\tcase $.ui.keyCode.RIGHT:\n\t\t\t\t\tcase $.ui.keyCode.DOWN:\n\t\t\t\t\tcase $.ui.keyCode.LEFT:\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\tif ( !this._keySliding ) {\n\t\t\t\t\t\t\tthis._keySliding = true;\n\t\t\t\t\t\t\t$( event.target ).addClass( \"ui-state-active\" );\n\t\t\t\t\t\t\tallowed = this._start( event, index );\n\t\t\t\t\t\t\tif ( allowed === false ) {\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tstep = this.options.step;\n\t\t\t\tif ( this.options.values && this.options.values.length ) {\n\t\t\t\t\tcurVal = newVal = this.values( index );\n\t\t\t\t} else {\n\t\t\t\t\tcurVal = newVal = this.value();\n\t\t\t\t}\n\n\t\t\t\tswitch ( event.keyCode ) {\n\t\t\t\t\tcase $.ui.keyCode.HOME:\n\t\t\t\t\t\tnewVal = this._valueMin();\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase $.ui.keyCode.END:\n\t\t\t\t\t\tnewVal = this._valueMax();\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase $.ui.keyCode.PAGE_UP:\n\t\t\t\t\t\tnewVal = this._trimAlignValue( curVal + ( (this._valueMax() - this._valueMin()) / numPages ) );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase $.ui.keyCode.PAGE_DOWN:\n\t\t\t\t\t\tnewVal = this._trimAlignValue( curVal - ( (this._valueMax() - this._valueMin()) / numPages ) );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase $.ui.keyCode.UP:\n\t\t\t\t\tcase $.ui.keyCode.RIGHT:\n\t\t\t\t\t\tif ( curVal === this._valueMax() ) {\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tnewVal = this._trimAlignValue( curVal + step );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase $.ui.keyCode.DOWN:\n\t\t\t\t\tcase $.ui.keyCode.LEFT:\n\t\t\t\t\t\tif ( curVal === this._valueMin() ) {\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tnewVal = this._trimAlignValue( curVal - step );\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tthis._slide( event, index, newVal );\n\t\t\t},\n\t\t\tkeyup: function( event ) {\n\t\t\t\tvar index = $( event.target ).data( \"ui-slider-handle-index\" );\n\n\t\t\t\tif ( this._keySliding ) {\n\t\t\t\t\tthis._keySliding = false;\n\t\t\t\t\tthis._stop( event, index );\n\t\t\t\t\tthis._change( event, index );\n\t\t\t\t\t$( event.target ).removeClass( \"ui-state-active\" );\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\tthis._refreshValue();\n\n\t\tthis._animateOff = false;\n\t},\n\n\t_destroy: function() {\n\t\tthis.handles.remove();\n\t\tthis.range.remove();\n\n\t\tthis.element\n\t\t\t.removeClass( \"ui-slider\" +\n\t\t\t\t\" ui-slider-horizontal\" +\n\t\t\t\t\" ui-slider-vertical\" +\n\t\t\t\t\" ui-slider-disabled\" +\n\t\t\t\t\" ui-widget\" +\n\t\t\t\t\" ui-widget-content\" +\n\t\t\t\t\" ui-corner-all\" );\n\n\t\tthis._mouseDestroy();\n\t},\n\n\t_mouseCapture: function( event ) {\n\t\tvar position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle,\n\t\t\tthat = this,\n\t\t\to = this.options;\n\n\t\tif ( o.disabled ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tthis.elementSize = {\n\t\t\twidth: this.element.outerWidth(),\n\t\t\theight: this.element.outerHeight()\n\t\t};\n\t\tthis.elementOffset = this.element.offset();\n\n\t\tposition = { x: event.pageX, y: event.pageY };\n\t\tnormValue = this._normValueFromMouse( position );\n\t\tdistance = this._valueMax() - this._valueMin() + 1;\n\t\tthis.handles.each(function( i ) {\n\t\t\tvar thisDistance = Math.abs( normValue - that.values(i) );\n\t\t\tif ( distance > thisDistance ) {\n\t\t\t\tdistance = thisDistance;\n\t\t\t\tclosestHandle = $( this );\n\t\t\t\tindex = i;\n\t\t\t}\n\t\t});\n\n\t\t// workaround for bug #3736 (if both handles of a range are at 0,\n\t\t// the first is always used as the one with least distance,\n\t\t// and moving it is obviously prevented by preventing negative ranges)\n\t\tif( o.range === true && this.values(1) === o.min ) {\n\t\t\tindex += 1;\n\t\t\tclosestHandle = $( this.handles[index] );\n\t\t}\n\n\t\tallowed = this._start( event, index );\n\t\tif ( allowed === false ) {\n\t\t\treturn false;\n\t\t}\n\t\tthis._mouseSliding = true;\n\n\t\tthis._handleIndex = index;\n\n\t\tclosestHandle\n\t\t\t.addClass( \"ui-state-active\" )\n\t\t\t.focus();\n\n\t\toffset = closestHandle.offset();\n\t\tmouseOverHandle = !$( event.target ).parents().andSelf().is( \".ui-slider-handle\" );\n\t\tthis._clickOffset = mouseOverHandle ? { left: 0, top: 0 } : {\n\t\t\tleft: event.pageX - offset.left - ( closestHandle.width() / 2 ),\n\t\t\ttop: event.pageY - offset.top -\n\t\t\t\t( closestHandle.height() / 2 ) -\n\t\t\t\t( parseInt( closestHandle.css(\"borderTopWidth\"), 10 ) || 0 ) -\n\t\t\t\t( parseInt( closestHandle.css(\"borderBottomWidth\"), 10 ) || 0) +\n\t\t\t\t( parseInt( closestHandle.css(\"marginTop\"), 10 ) || 0)\n\t\t};\n\n\t\tif ( !this.handles.hasClass( \"ui-state-hover\" ) ) {\n\t\t\tthis._slide( event, index, normValue );\n\t\t}\n\t\tthis._animateOff = true;\n\t\treturn true;\n\t},\n\n\t_mouseStart: function() {\n\t\treturn true;\n\t},\n\n\t_mouseDrag: function( event ) {\n\t\tvar position = { x: event.pageX, y: event.pageY },\n\t\t\tnormValue = this._normValueFromMouse( position );\n\n\t\tthis._slide( event, this._handleIndex, normValue );\n\n\t\treturn false;\n\t},\n\n\t_mouseStop: function( event ) {\n\t\tthis.handles.removeClass( \"ui-state-active\" );\n\t\tthis._mouseSliding = false;\n\n\t\tthis._stop( event, this._handleIndex );\n\t\tthis._change( event, this._handleIndex );\n\n\t\tthis._handleIndex = null;\n\t\tthis._clickOffset = null;\n\t\tthis._animateOff = false;\n\n\t\treturn false;\n\t},\n\n\t_detectOrientation: function() {\n\t\tthis.orientation = ( this.options.orientation === \"vertical\" ) ? \"vertical\" : \"horizontal\";\n\t},\n\n\t_normValueFromMouse: function( position ) {\n\t\tvar pixelTotal,\n\t\t\tpixelMouse,\n\t\t\tpercentMouse,\n\t\t\tvalueTotal,\n\t\t\tvalueMouse;\n\n\t\tif ( this.orientation === \"horizontal\" ) {\n\t\t\tpixelTotal = this.elementSize.width;\n\t\t\tpixelMouse = position.x - this.elementOffset.left - ( this._clickOffset ? this._clickOffset.left : 0 );\n\t\t} else {\n\t\t\tpixelTotal = this.elementSize.height;\n\t\t\tpixelMouse = position.y - this.elementOffset.top - ( this._clickOffset ? this._clickOffset.top : 0 );\n\t\t}\n\n\t\tpercentMouse = ( pixelMouse / pixelTotal );\n\t\tif ( percentMouse > 1 ) {\n\t\t\tpercentMouse = 1;\n\t\t}\n\t\tif ( percentMouse < 0 ) {\n\t\t\tpercentMouse = 0;\n\t\t}\n\t\tif ( this.orientation === \"vertical\" ) {\n\t\t\tpercentMouse = 1 - percentMouse;\n\t\t}\n\n\t\tvalueTotal = this._valueMax() - this._valueMin();\n\t\tvalueMouse = this._valueMin() + percentMouse * valueTotal;\n\n\t\treturn this._trimAlignValue( valueMouse );\n\t},\n\n\t_start: function( event, index ) {\n\t\tvar uiHash = {\n\t\t\thandle: this.handles[ index ],\n\t\t\tvalue: this.value()\n\t\t};\n\t\tif ( this.options.values && this.options.values.length ) {\n\t\t\tuiHash.value = this.values( index );\n\t\t\tuiHash.values = this.values();\n\t\t}\n\t\treturn this._trigger( \"start\", event, uiHash );\n\t},\n\n\t_slide: function( event, index, newVal ) {\n\t\tvar otherVal,\n\t\t\tnewValues,\n\t\t\tallowed;\n\n\t\tif ( this.options.values && this.options.values.length ) {\n\t\t\totherVal = this.values( index ? 0 : 1 );\n\n\t\t\tif ( ( this.options.values.length === 2 && this.options.range === true ) &&\n\t\t\t\t\t( ( index === 0 && newVal > otherVal) || ( index === 1 && newVal < otherVal ) )\n\t\t\t\t) {\n\t\t\t\tnewVal = otherVal;\n\t\t\t}\n\n\t\t\tif ( newVal !== this.values( index ) ) {\n\t\t\t\tnewValues = this.values();\n\t\t\t\tnewValues[ index ] = newVal;\n\t\t\t\t// A slide can be canceled by returning false from the slide callback\n\t\t\t\tallowed = this._trigger( \"slide\", event, {\n\t\t\t\t\thandle: this.handles[ index ],\n\t\t\t\t\tvalue: newVal,\n\t\t\t\t\tvalues: newValues\n\t\t\t\t} );\n\t\t\t\totherVal = this.values( index ? 0 : 1 );\n\t\t\t\tif ( allowed !== false ) {\n\t\t\t\t\tthis.values( index, newVal, true );\n\t\t\t\t}\n\t\t\t}\n\t\t} else {\n\t\t\tif ( newVal !== this.value() ) {\n\t\t\t\t// A slide can be canceled by returning false from the slide callback\n\t\t\t\tallowed = this._trigger( \"slide\", event, {\n\t\t\t\t\thandle: this.handles[ index ],\n\t\t\t\t\tvalue: newVal\n\t\t\t\t} );\n\t\t\t\tif ( allowed !== false ) {\n\t\t\t\t\tthis.value( newVal );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\n\t_stop: function( event, index ) {\n\t\tvar uiHash = {\n\t\t\thandle: this.handles[ index ],\n\t\t\tvalue: this.value()\n\t\t};\n\t\tif ( this.options.values && this.options.values.length ) {\n\t\t\tuiHash.value = this.values( index );\n\t\t\tuiHash.values = this.values();\n\t\t}\n\n\t\tthis._trigger( \"stop\", event, uiHash );\n\t},\n\n\t_change: function( event, index ) {\n\t\tif ( !this._keySliding && !this._mouseSliding ) {\n\t\t\tvar uiHash = {\n\t\t\t\thandle: this.handles[ index ],\n\t\t\t\tvalue: this.value()\n\t\t\t};\n\t\t\tif ( this.options.values && this.options.values.length ) {\n\t\t\t\tuiHash.value = this.values( index );\n\t\t\t\tuiHash.values = this.values();\n\t\t\t}\n\n\t\t\tthis._trigger( \"change\", event, uiHash );\n\t\t}\n\t},\n\n\tvalue: function( newValue ) {\n\t\tif ( arguments.length ) {\n\t\t\tthis.options.value = this._trimAlignValue( newValue );\n\t\t\tthis._refreshValue();\n\t\t\tthis._change( null, 0 );\n\t\t\treturn;\n\t\t}\n\n\t\treturn this._value();\n\t},\n\n\tvalues: function( index, newValue ) {\n\t\tvar vals,\n\t\t\tnewValues,\n\t\t\ti;\n\n\t\tif ( arguments.length > 1 ) {\n\t\t\tthis.options.values[ index ] = this._trimAlignValue( newValue );\n\t\t\tthis._refreshValue();\n\t\t\tthis._change( null, index );\n\t\t\treturn;\n\t\t}\n\n\t\tif ( arguments.length ) {\n\t\t\tif ( $.isArray( arguments[ 0 ] ) ) {\n\t\t\t\tvals = this.options.values;\n\t\t\t\tnewValues = arguments[ 0 ];\n\t\t\t\tfor ( i = 0; i < vals.length; i += 1 ) {\n\t\t\t\t\tvals[ i ] = this._trimAlignValue( newValues[ i ] );\n\t\t\t\t\tthis._change( null, i );\n\t\t\t\t}\n\t\t\t\tthis._refreshValue();\n\t\t\t} else {\n\t\t\t\tif ( this.options.values && this.options.values.length ) {\n\t\t\t\t\treturn this._values( index );\n\t\t\t\t} else {\n\t\t\t\t\treturn this.value();\n\t\t\t\t}\n\t\t\t}\n\t\t} else {\n\t\t\treturn this._values();\n\t\t}\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tvar i,\n\t\t\tvalsLength = 0;\n\n\t\tif ( $.isArray( this.options.values ) ) {\n\t\t\tvalsLength = this.options.values.length;\n\t\t}\n\n\t\t$.Widget.prototype._setOption.apply( this, arguments );\n\n\t\tswitch ( key ) {\n\t\t\tcase \"disabled\":\n\t\t\t\tif ( value ) {\n\t\t\t\t\tthis.handles.filter( \".ui-state-focus\" ).blur();\n\t\t\t\t\tthis.handles.removeClass( \"ui-state-hover\" );\n\t\t\t\t\tthis.handles.prop( \"disabled\", true );\n\t\t\t\t\tthis.element.addClass( \"ui-disabled\" );\n\t\t\t\t} else {\n\t\t\t\t\tthis.handles.prop( \"disabled\", false );\n\t\t\t\t\tthis.element.removeClass( \"ui-disabled\" );\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase \"orientation\":\n\t\t\t\tthis._detectOrientation();\n\t\t\t\tthis.element\n\t\t\t\t\t.removeClass( \"ui-slider-horizontal ui-slider-vertical\" )\n\t\t\t\t\t.addClass( \"ui-slider-\" + this.orientation );\n\t\t\t\tthis._refreshValue();\n\t\t\t\tbreak;\n\t\t\tcase \"value\":\n\t\t\t\tthis._animateOff = true;\n\t\t\t\tthis._refreshValue();\n\t\t\t\tthis._change( null, 0 );\n\t\t\t\tthis._animateOff = false;\n\t\t\t\tbreak;\n\t\t\tcase \"values\":\n\t\t\t\tthis._animateOff = true;\n\t\t\t\tthis._refreshValue();\n\t\t\t\tfor ( i = 0; i < valsLength; i += 1 ) {\n\t\t\t\t\tthis._change( null, i );\n\t\t\t\t}\n\t\t\t\tthis._animateOff = false;\n\t\t\t\tbreak;\n\t\t\tcase \"min\":\n\t\t\tcase \"max\":\n\t\t\t\tthis._animateOff = true;\n\t\t\t\tthis._refreshValue();\n\t\t\t\tthis._animateOff = false;\n\t\t\t\tbreak;\n\t\t}\n\t},\n\n\t//internal value getter\n\t// _value() returns value trimmed by min and max, aligned by step\n\t_value: function() {\n\t\tvar val = this.options.value;\n\t\tval = this._trimAlignValue( val );\n\n\t\treturn val;\n\t},\n\n\t//internal values getter\n\t// _values() returns array of values trimmed by min and max, aligned by step\n\t// _values( index ) returns single value trimmed by min and max, aligned by step\n\t_values: function( index ) {\n\t\tvar val,\n\t\t\tvals,\n\t\t\ti;\n\n\t\tif ( arguments.length ) {\n\t\t\tval = this.options.values[ index ];\n\t\t\tval = this._trimAlignValue( val );\n\n\t\t\treturn val;\n\t\t} else {\n\t\t\t// .slice() creates a copy of the array\n\t\t\t// this copy gets trimmed by min and max and then returned\n\t\t\tvals = this.options.values.slice();\n\t\t\tfor ( i = 0; i < vals.length; i+= 1) {\n\t\t\t\tvals[ i ] = this._trimAlignValue( vals[ i ] );\n\t\t\t}\n\n\t\t\treturn vals;\n\t\t}\n\t},\n\n\t// returns the step-aligned value that val is closest to, between (inclusive) min and max\n\t_trimAlignValue: function( val ) {\n\t\tif ( val <= this._valueMin() ) {\n\t\t\treturn this._valueMin();\n\t\t}\n\t\tif ( val >= this._valueMax() ) {\n\t\t\treturn this._valueMax();\n\t\t}\n\t\tvar step = ( this.options.step > 0 ) ? this.options.step : 1,\n\t\t\tvalModStep = (val - this._valueMin()) % step,\n\t\t\talignValue = val - valModStep;\n\n\t\tif ( Math.abs(valModStep) * 2 >= step ) {\n\t\t\talignValue += ( valModStep > 0 ) ? step : ( -step );\n\t\t}\n\n\t\t// Since JavaScript has problems with large floats, round\n\t\t// the final value to 5 digits after the decimal point (see #4124)\n\t\treturn parseFloat( alignValue.toFixed(5) );\n\t},\n\n\t_valueMin: function() {\n\t\treturn this.options.min;\n\t},\n\n\t_valueMax: function() {\n\t\treturn this.options.max;\n\t},\n\n\t_refreshValue: function() {\n\t\tvar lastValPercent, valPercent, value, valueMin, valueMax,\n\t\t\toRange = this.options.range,\n\t\t\to = this.options,\n\t\t\tthat = this,\n\t\t\tanimate = ( !this._animateOff ) ? o.animate : false,\n\t\t\t_set = {};\n\n\t\tif ( this.options.values && this.options.values.length ) {\n\t\t\tthis.handles.each(function( i ) {\n\t\t\t\tvalPercent = ( that.values(i) - that._valueMin() ) / ( that._valueMax() - that._valueMin() ) * 100;\n\t\t\t\t_set[ that.orientation === \"horizontal\" ? \"left\" : \"bottom\" ] = valPercent + \"%\";\n\t\t\t\t$( this ).stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( _set, o.animate );\n\t\t\t\tif ( that.options.range === true ) {\n\t\t\t\t\tif ( that.orientation === \"horizontal\" ) {\n\t\t\t\t\t\tif ( i === 0 ) {\n\t\t\t\t\t\t\tthat.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( { left: valPercent + \"%\" }, o.animate );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( i === 1 ) {\n\t\t\t\t\t\t\tthat.range[ animate ? \"animate\" : \"css\" ]( { width: ( valPercent - lastValPercent ) + \"%\" }, { queue: false, duration: o.animate } );\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif ( i === 0 ) {\n\t\t\t\t\t\t\tthat.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( { bottom: ( valPercent ) + \"%\" }, o.animate );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( i === 1 ) {\n\t\t\t\t\t\t\tthat.range[ animate ? \"animate\" : \"css\" ]( { height: ( valPercent - lastValPercent ) + \"%\" }, { queue: false, duration: o.animate } );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tlastValPercent = valPercent;\n\t\t\t});\n\t\t} else {\n\t\t\tvalue = this.value();\n\t\t\tvalueMin = this._valueMin();\n\t\t\tvalueMax = this._valueMax();\n\t\t\tvalPercent = ( valueMax !== valueMin ) ?\n\t\t\t\t\t( value - valueMin ) / ( valueMax - valueMin ) * 100 :\n\t\t\t\t\t0;\n\t\t\t_set[ this.orientation === \"horizontal\" ? \"left\" : \"bottom\" ] = valPercent + \"%\";\n\t\t\tthis.handle.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( _set, o.animate );\n\n\t\t\tif ( oRange === \"min\" && this.orientation === \"horizontal\" ) {\n\t\t\t\tthis.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( { width: valPercent + \"%\" }, o.animate );\n\t\t\t}\n\t\t\tif ( oRange === \"max\" && this.orientation === \"horizontal\" ) {\n\t\t\t\tthis.range[ animate ? \"animate\" : \"css\" ]( { width: ( 100 - valPercent ) + \"%\" }, { queue: false, duration: o.animate } );\n\t\t\t}\n\t\t\tif ( oRange === \"min\" && this.orientation === \"vertical\" ) {\n\t\t\t\tthis.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( { height: valPercent + \"%\" }, o.animate );\n\t\t\t}\n\t\t\tif ( oRange === \"max\" && this.orientation === \"vertical\" ) {\n\t\t\t\tthis.range[ animate ? \"animate\" : \"css\" ]( { height: ( 100 - valPercent ) + \"%\" }, { queue: false, duration: o.animate } );\n\t\t\t}\n\t\t}\n\t}\n\n});\n\n}(jQuery));\n\n(function( $ ) {\n\nfunction modifier( fn ) {\n\treturn function() {\n\t\tvar previous = this.element.val();\n\t\tfn.apply( this, arguments );\n\t\tthis._refresh();\n\t\tif ( previous !== this.element.val() ) {\n\t\t\tthis._trigger( \"change\" );\n\t\t}\n\t};\n}\n\n$.widget( \"ui.spinner\", {\n\tversion: \"1.9.2\",\n\tdefaultElement: \"<input>\",\n\twidgetEventPrefix: \"spin\",\n\toptions: {\n\t\tculture: null,\n\t\ticons: {\n\t\t\tdown: \"ui-icon-triangle-1-s\",\n\t\t\tup: \"ui-icon-triangle-1-n\"\n\t\t},\n\t\tincremental: true,\n\t\tmax: null,\n\t\tmin: null,\n\t\tnumberFormat: null,\n\t\tpage: 10,\n\t\tstep: 1,\n\n\t\tchange: null,\n\t\tspin: null,\n\t\tstart: null,\n\t\tstop: null\n\t},\n\n\t_create: function() {\n\t\t// handle string values that need to be parsed\n\t\tthis._setOption( \"max\", this.options.max );\n\t\tthis._setOption( \"min\", this.options.min );\n\t\tthis._setOption( \"step\", this.options.step );\n\n\t\t// format the value, but don't constrain\n\t\tthis._value( this.element.val(), true );\n\n\t\tthis._draw();\n\t\tthis._on( this._events );\n\t\tthis._refresh();\n\n\t\t// turning off autocomplete prevents the browser from remembering the\n\t\t// value when navigating through history, so we re-enable autocomplete\n\t\t// if the page is unloaded before the widget is destroyed. #7790\n\t\tthis._on( this.window, {\n\t\t\tbeforeunload: function() {\n\t\t\t\tthis.element.removeAttr( \"autocomplete\" );\n\t\t\t}\n\t\t});\n\t},\n\n\t_getCreateOptions: function() {\n\t\tvar options = {},\n\t\t\telement = this.element;\n\n\t\t$.each( [ \"min\", \"max\", \"step\" ], function( i, option ) {\n\t\t\tvar value = element.attr( option );\n\t\t\tif ( value !== undefined && value.length ) {\n\t\t\t\toptions[ option ] = value;\n\t\t\t}\n\t\t});\n\n\t\treturn options;\n\t},\n\n\t_events: {\n\t\tkeydown: function( event ) {\n\t\t\tif ( this._start( event ) && this._keydown( event ) ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t}\n\t\t},\n\t\tkeyup: \"_stop\",\n\t\tfocus: function() {\n\t\t\tthis.previous = this.element.val();\n\t\t},\n\t\tblur: function( event ) {\n\t\t\tif ( this.cancelBlur ) {\n\t\t\t\tdelete this.cancelBlur;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tthis._refresh();\n\t\t\tif ( this.previous !== this.element.val() ) {\n\t\t\t\tthis._trigger( \"change\", event );\n\t\t\t}\n\t\t},\n\t\tmousewheel: function( event, delta ) {\n\t\t\tif ( !delta ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tif ( !this.spinning && !this._start( event ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tthis._spin( (delta > 0 ? 1 : -1) * this.options.step, event );\n\t\t\tclearTimeout( this.mousewheelTimer );\n\t\t\tthis.mousewheelTimer = this._delay(function() {\n\t\t\t\tif ( this.spinning ) {\n\t\t\t\t\tthis._stop( event );\n\t\t\t\t}\n\t\t\t}, 100 );\n\t\t\tevent.preventDefault();\n\t\t},\n\t\t\"mousedown .ui-spinner-button\": function( event ) {\n\t\t\tvar previous;\n\n\t\t\t// We never want the buttons to have focus; whenever the user is\n\t\t\t// interacting with the spinner, the focus should be on the input.\n\t\t\t// If the input is focused then this.previous is properly set from\n\t\t\t// when the input first received focus. If the input is not focused\n\t\t\t// then we need to set this.previous based on the value before spinning.\n\t\t\tprevious = this.element[0] === this.document[0].activeElement ?\n\t\t\t\tthis.previous : this.element.val();\n\t\t\tfunction checkFocus() {\n\t\t\t\tvar isActive = this.element[0] === this.document[0].activeElement;\n\t\t\t\tif ( !isActive ) {\n\t\t\t\t\tthis.element.focus();\n\t\t\t\t\tthis.previous = previous;\n\t\t\t\t\t// support: IE\n\t\t\t\t\t// IE sets focus asynchronously, so we need to check if focus\n\t\t\t\t\t// moved off of the input because the user clicked on the button.\n\t\t\t\t\tthis._delay(function() {\n\t\t\t\t\t\tthis.previous = previous;\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// ensure focus is on (or stays on) the text field\n\t\t\tevent.preventDefault();\n\t\t\tcheckFocus.call( this );\n\n\t\t\t// support: IE\n\t\t\t// IE doesn't prevent moving focus even with event.preventDefault()\n\t\t\t// so we set a flag to know when we should ignore the blur event\n\t\t\t// and check (again) if focus moved off of the input.\n\t\t\tthis.cancelBlur = true;\n\t\t\tthis._delay(function() {\n\t\t\t\tdelete this.cancelBlur;\n\t\t\t\tcheckFocus.call( this );\n\t\t\t});\n\n\t\t\tif ( this._start( event ) === false ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tthis._repeat( null, $( event.currentTarget ).hasClass( \"ui-spinner-up\" ) ? 1 : -1, event );\n\t\t},\n\t\t\"mouseup .ui-spinner-button\": \"_stop\",\n\t\t\"mouseenter .ui-spinner-button\": function( event ) {\n\t\t\t// button will add ui-state-active if mouse was down while mouseleave and kept down\n\t\t\tif ( !$( event.currentTarget ).hasClass( \"ui-state-active\" ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( this._start( event ) === false ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tthis._repeat( null, $( event.currentTarget ).hasClass( \"ui-spinner-up\" ) ? 1 : -1, event );\n\t\t},\n\t\t// TODO: do we really want to consider this a stop?\n\t\t// shouldn't we just stop the repeater and wait until mouseup before\n\t\t// we trigger the stop event?\n\t\t\"mouseleave .ui-spinner-button\": \"_stop\"\n\t},\n\n\t_draw: function() {\n\t\tvar uiSpinner = this.uiSpinner = this.element\n\t\t\t.addClass( \"ui-spinner-input\" )\n\t\t\t.attr( \"autocomplete\", \"off\" )\n\t\t\t.wrap( this._uiSpinnerHtml() )\n\t\t\t.parent()\n\t\t\t\t// add buttons\n\t\t\t\t.append( this._buttonHtml() );\n\n\t\tthis.element.attr( \"role\", \"spinbutton\" );\n\n\t\t// button bindings\n\t\tthis.buttons = uiSpinner.find( \".ui-spinner-button\" )\n\t\t\t.attr( \"tabIndex\", -1 )\n\t\t\t.button()\n\t\t\t.removeClass( \"ui-corner-all\" );\n\n\t\t// IE 6 doesn't understand height: 50% for the buttons\n\t\t// unless the wrapper has an explicit height\n\t\tif ( this.buttons.height() > Math.ceil( uiSpinner.height() * 0.5 ) &&\n\t\t\t\tuiSpinner.height() > 0 ) {\n\t\t\tuiSpinner.height( uiSpinner.height() );\n\t\t}\n\n\t\t// disable spinner if element was already disabled\n\t\tif ( this.options.disabled ) {\n\t\t\tthis.disable();\n\t\t}\n\t},\n\n\t_keydown: function( event ) {\n\t\tvar options = this.options,\n\t\t\tkeyCode = $.ui.keyCode;\n\n\t\tswitch ( event.keyCode ) {\n\t\tcase keyCode.UP:\n\t\t\tthis._repeat( null, 1, event );\n\t\t\treturn true;\n\t\tcase keyCode.DOWN:\n\t\t\tthis._repeat( null, -1, event );\n\t\t\treturn true;\n\t\tcase keyCode.PAGE_UP:\n\t\t\tthis._repeat( null, options.page, event );\n\t\t\treturn true;\n\t\tcase keyCode.PAGE_DOWN:\n\t\t\tthis._repeat( null, -options.page, event );\n\t\t\treturn true;\n\t\t}\n\n\t\treturn false;\n\t},\n\n\t_uiSpinnerHtml: function() {\n\t\treturn \"<span class='ui-spinner ui-widget ui-widget-content ui-corner-all'></span>\";\n\t},\n\n\t_buttonHtml: function() {\n\t\treturn \"\" +\n\t\t\t\"<a class='ui-spinner-button ui-spinner-up ui-corner-tr'>\" +\n\t\t\t\t\"<span class='ui-icon \" + this.options.icons.up + \"'>&#9650;</span>\" +\n\t\t\t\"</a>\" +\n\t\t\t\"<a class='ui-spinner-button ui-spinner-down ui-corner-br'>\" +\n\t\t\t\t\"<span class='ui-icon \" + this.options.icons.down + \"'>&#9660;</span>\" +\n\t\t\t\"</a>\";\n\t},\n\n\t_start: function( event ) {\n\t\tif ( !this.spinning && this._trigger( \"start\", event ) === false ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tif ( !this.counter ) {\n\t\t\tthis.counter = 1;\n\t\t}\n\t\tthis.spinning = true;\n\t\treturn true;\n\t},\n\n\t_repeat: function( i, steps, event ) {\n\t\ti = i || 500;\n\n\t\tclearTimeout( this.timer );\n\t\tthis.timer = this._delay(function() {\n\t\t\tthis._repeat( 40, steps, event );\n\t\t}, i );\n\n\t\tthis._spin( steps * this.options.step, event );\n\t},\n\n\t_spin: function( step, event ) {\n\t\tvar value = this.value() || 0;\n\n\t\tif ( !this.counter ) {\n\t\t\tthis.counter = 1;\n\t\t}\n\n\t\tvalue = this._adjustValue( value + step * this._increment( this.counter ) );\n\n\t\tif ( !this.spinning || this._trigger( \"spin\", event, { value: value } ) !== false) {\n\t\t\tthis._value( value );\n\t\t\tthis.counter++;\n\t\t}\n\t},\n\n\t_increment: function( i ) {\n\t\tvar incremental = this.options.incremental;\n\n\t\tif ( incremental ) {\n\t\t\treturn $.isFunction( incremental ) ?\n\t\t\t\tincremental( i ) :\n\t\t\t\tMath.floor( i*i*i/50000 - i*i/500 + 17*i/200 + 1 );\n\t\t}\n\n\t\treturn 1;\n\t},\n\n\t_precision: function() {\n\t\tvar precision = this._precisionOf( this.options.step );\n\t\tif ( this.options.min !== null ) {\n\t\t\tprecision = Math.max( precision, this._precisionOf( this.options.min ) );\n\t\t}\n\t\treturn precision;\n\t},\n\n\t_precisionOf: function( num ) {\n\t\tvar str = num.toString(),\n\t\t\tdecimal = str.indexOf( \".\" );\n\t\treturn decimal === -1 ? 0 : str.length - decimal - 1;\n\t},\n\n\t_adjustValue: function( value ) {\n\t\tvar base, aboveMin,\n\t\t\toptions = this.options;\n\n\t\t// make sure we're at a valid step\n\t\t// - find out where we are relative to the base (min or 0)\n\t\tbase = options.min !== null ? options.min : 0;\n\t\taboveMin = value - base;\n\t\t// - round to the nearest step\n\t\taboveMin = Math.round(aboveMin / options.step) * options.step;\n\t\t// - rounding is based on 0, so adjust back to our base\n\t\tvalue = base + aboveMin;\n\n\t\t// fix precision from bad JS floating point math\n\t\tvalue = parseFloat( value.toFixed( this._precision() ) );\n\n\t\t// clamp the value\n\t\tif ( options.max !== null && value > options.max) {\n\t\t\treturn options.max;\n\t\t}\n\t\tif ( options.min !== null && value < options.min ) {\n\t\t\treturn options.min;\n\t\t}\n\n\t\treturn value;\n\t},\n\n\t_stop: function( event ) {\n\t\tif ( !this.spinning ) {\n\t\t\treturn;\n\t\t}\n\n\t\tclearTimeout( this.timer );\n\t\tclearTimeout( this.mousewheelTimer );\n\t\tthis.counter = 0;\n\t\tthis.spinning = false;\n\t\tthis._trigger( \"stop\", event );\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"culture\" || key === \"numberFormat\" ) {\n\t\t\tvar prevValue = this._parse( this.element.val() );\n\t\t\tthis.options[ key ] = value;\n\t\t\tthis.element.val( this._format( prevValue ) );\n\t\t\treturn;\n\t\t}\n\n\t\tif ( key === \"max\" || key === \"min\" || key === \"step\" ) {\n\t\t\tif ( typeof value === \"string\" ) {\n\t\t\t\tvalue = this._parse( value );\n\t\t\t}\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\tif ( value ) {\n\t\t\t\tthis.element.prop( \"disabled\", true );\n\t\t\t\tthis.buttons.button( \"disable\" );\n\t\t\t} else {\n\t\t\t\tthis.element.prop( \"disabled\", false );\n\t\t\t\tthis.buttons.button( \"enable\" );\n\t\t\t}\n\t\t}\n\t},\n\n\t_setOptions: modifier(function( options ) {\n\t\tthis._super( options );\n\t\tthis._value( this.element.val() );\n\t}),\n\n\t_parse: function( val ) {\n\t\tif ( typeof val === \"string\" && val !== \"\" ) {\n\t\t\tval = window.Globalize && this.options.numberFormat ?\n\t\t\t\tGlobalize.parseFloat( val, 10, this.options.culture ) : +val;\n\t\t}\n\t\treturn val === \"\" || isNaN( val ) ? null : val;\n\t},\n\n\t_format: function( value ) {\n\t\tif ( value === \"\" ) {\n\t\t\treturn \"\";\n\t\t}\n\t\treturn window.Globalize && this.options.numberFormat ?\n\t\t\tGlobalize.format( value, this.options.numberFormat, this.options.culture ) :\n\t\t\tvalue;\n\t},\n\n\t_refresh: function() {\n\t\tthis.element.attr({\n\t\t\t\"aria-valuemin\": this.options.min,\n\t\t\t\"aria-valuemax\": this.options.max,\n\t\t\t// TODO: what should we do with values that can't be parsed?\n\t\t\t\"aria-valuenow\": this._parse( this.element.val() )\n\t\t});\n\t},\n\n\t// update the value without triggering change\n\t_value: function( value, allowAny ) {\n\t\tvar parsed;\n\t\tif ( value !== \"\" ) {\n\t\t\tparsed = this._parse( value );\n\t\t\tif ( parsed !== null ) {\n\t\t\t\tif ( !allowAny ) {\n\t\t\t\t\tparsed = this._adjustValue( parsed );\n\t\t\t\t}\n\t\t\t\tvalue = this._format( parsed );\n\t\t\t}\n\t\t}\n\t\tthis.element.val( value );\n\t\tthis._refresh();\n\t},\n\n\t_destroy: function() {\n\t\tthis.element\n\t\t\t.removeClass( \"ui-spinner-input\" )\n\t\t\t.prop( \"disabled\", false )\n\t\t\t.removeAttr( \"autocomplete\" )\n\t\t\t.removeAttr( \"role\" )\n\t\t\t.removeAttr( \"aria-valuemin\" )\n\t\t\t.removeAttr( \"aria-valuemax\" )\n\t\t\t.removeAttr( \"aria-valuenow\" );\n\t\tthis.uiSpinner.replaceWith( this.element );\n\t},\n\n\tstepUp: modifier(function( steps ) {\n\t\tthis._stepUp( steps );\n\t}),\n\t_stepUp: function( steps ) {\n\t\tthis._spin( (steps || 1) * this.options.step );\n\t},\n\n\tstepDown: modifier(function( steps ) {\n\t\tthis._stepDown( steps );\n\t}),\n\t_stepDown: function( steps ) {\n\t\tthis._spin( (steps || 1) * -this.options.step );\n\t},\n\n\tpageUp: modifier(function( pages ) {\n\t\tthis._stepUp( (pages || 1) * this.options.page );\n\t}),\n\n\tpageDown: modifier(function( pages ) {\n\t\tthis._stepDown( (pages || 1) * this.options.page );\n\t}),\n\n\tvalue: function( newVal ) {\n\t\tif ( !arguments.length ) {\n\t\t\treturn this._parse( this.element.val() );\n\t\t}\n\t\tmodifier( this._value ).call( this, newVal );\n\t},\n\n\twidget: function() {\n\t\treturn this.uiSpinner;\n\t}\n});\n\n}( jQuery ) );\n\n(function( $, undefined ) {\n\nvar tabId = 0,\n\trhash = /#.*$/;\n\nfunction getNextTabId() {\n\treturn ++tabId;\n}\n\nfunction isLocal( anchor ) {\n\treturn anchor.hash.length > 1 &&\n\t\tanchor.href.replace( rhash, \"\" ) ===\n\t\t\tlocation.href.replace( rhash, \"\" )\n\t\t\t\t// support: Safari 5.1\n\t\t\t\t// Safari 5.1 doesn't encode spaces in window.location\n\t\t\t\t// but it does encode spaces from anchors (#8777)\n\t\t\t\t.replace( /\\s/g, \"%20\" );\n}\n\n$.widget( \"ui.tabs\", {\n\tversion: \"1.9.2\",\n\tdelay: 300,\n\toptions: {\n\t\tactive: null,\n\t\tcollapsible: false,\n\t\tevent: \"click\",\n\t\theightStyle: \"content\",\n\t\thide: null,\n\t\tshow: null,\n\n\t\t// callbacks\n\t\tactivate: null,\n\t\tbeforeActivate: null,\n\t\tbeforeLoad: null,\n\t\tload: null\n\t},\n\n\t_create: function() {\n\t\tvar that = this,\n\t\t\toptions = this.options,\n\t\t\tactive = options.active,\n\t\t\tlocationHash = location.hash.substring( 1 );\n\n\t\tthis.running = false;\n\n\t\tthis.element\n\t\t\t.addClass( \"ui-tabs ui-widget ui-widget-content ui-corner-all\" )\n\t\t\t.toggleClass( \"ui-tabs-collapsible\", options.collapsible )\n\t\t\t// Prevent users from focusing disabled tabs via click\n\t\t\t.delegate( \".ui-tabs-nav > li\", \"mousedown\" + this.eventNamespace, function( event ) {\n\t\t\t\tif ( $( this ).is( \".ui-state-disabled\" ) ) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t}\n\t\t\t})\n\t\t\t// support: IE <9\n\t\t\t// Preventing the default action in mousedown doesn't prevent IE\n\t\t\t// from focusing the element, so if the anchor gets focused, blur.\n\t\t\t// We don't have to worry about focusing the previously focused\n\t\t\t// element since clicking on a non-focusable element should focus\n\t\t\t// the body anyway.\n\t\t\t.delegate( \".ui-tabs-anchor\", \"focus\" + this.eventNamespace, function() {\n\t\t\t\tif ( $( this ).closest( \"li\" ).is( \".ui-state-disabled\" ) ) {\n\t\t\t\t\tthis.blur();\n\t\t\t\t}\n\t\t\t});\n\n\t\tthis._processTabs();\n\n\t\tif ( active === null ) {\n\t\t\t// check the fragment identifier in the URL\n\t\t\tif ( locationHash ) {\n\t\t\t\tthis.tabs.each(function( i, tab ) {\n\t\t\t\t\tif ( $( tab ).attr( \"aria-controls\" ) === locationHash ) {\n\t\t\t\t\t\tactive = i;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// check for a tab marked active via a class\n\t\t\tif ( active === null ) {\n\t\t\t\tactive = this.tabs.index( this.tabs.filter( \".ui-tabs-active\" ) );\n\t\t\t}\n\n\t\t\t// no active tab, set to false\n\t\t\tif ( active === null || active === -1 ) {\n\t\t\t\tactive = this.tabs.length ? 0 : false;\n\t\t\t}\n\t\t}\n\n\t\t// handle numbers: negative, out of range\n\t\tif ( active !== false ) {\n\t\t\tactive = this.tabs.index( this.tabs.eq( active ) );\n\t\t\tif ( active === -1 ) {\n\t\t\t\tactive = options.collapsible ? false : 0;\n\t\t\t}\n\t\t}\n\t\toptions.active = active;\n\n\t\t// don't allow collapsible: false and active: false\n\t\tif ( !options.collapsible && options.active === false && this.anchors.length ) {\n\t\t\toptions.active = 0;\n\t\t}\n\n\t\t// Take disabling tabs via class attribute from HTML\n\t\t// into account and update option properly.\n\t\tif ( $.isArray( options.disabled ) ) {\n\t\t\toptions.disabled = $.unique( options.disabled.concat(\n\t\t\t\t$.map( this.tabs.filter( \".ui-state-disabled\" ), function( li ) {\n\t\t\t\t\treturn that.tabs.index( li );\n\t\t\t\t})\n\t\t\t) ).sort();\n\t\t}\n\n\t\t// check for length avoids error when initializing empty list\n\t\tif ( this.options.active !== false && this.anchors.length ) {\n\t\t\tthis.active = this._findActive( this.options.active );\n\t\t} else {\n\t\t\tthis.active = $();\n\t\t}\n\n\t\tthis._refresh();\n\n\t\tif ( this.active.length ) {\n\t\t\tthis.load( options.active );\n\t\t}\n\t},\n\n\t_getCreateEventData: function() {\n\t\treturn {\n\t\t\ttab: this.active,\n\t\t\tpanel: !this.active.length ? $() : this._getPanelForTab( this.active )\n\t\t};\n\t},\n\n\t_tabKeydown: function( event ) {\n\t\tvar focusedTab = $( this.document[0].activeElement ).closest( \"li\" ),\n\t\t\tselectedIndex = this.tabs.index( focusedTab ),\n\t\t\tgoingForward = true;\n\n\t\tif ( this._handlePageNav( event ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tswitch ( event.keyCode ) {\n\t\t\tcase $.ui.keyCode.RIGHT:\n\t\t\tcase $.ui.keyCode.DOWN:\n\t\t\t\tselectedIndex++;\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.UP:\n\t\t\tcase $.ui.keyCode.LEFT:\n\t\t\t\tgoingForward = false;\n\t\t\t\tselectedIndex--;\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.END:\n\t\t\t\tselectedIndex = this.anchors.length - 1;\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.HOME:\n\t\t\t\tselectedIndex = 0;\n\t\t\t\tbreak;\n\t\t\tcase $.ui.keyCode.SPACE:\n\t\t\t\t// Activate only, no collapsing\n\t\t\t\tevent.preventDefault();\n\t\t\t\tclearTimeout( this.activating );\n\t\t\t\tthis._activate( selectedIndex );\n\t\t\t\treturn;\n\t\t\tcase $.ui.keyCode.ENTER:\n\t\t\t\t// Toggle (cancel delayed activation, allow collapsing)\n\t\t\t\tevent.preventDefault();\n\t\t\t\tclearTimeout( this.activating );\n\t\t\t\t// Determine if we should collapse or activate\n\t\t\t\tthis._activate( selectedIndex === this.options.active ? false : selectedIndex );\n\t\t\t\treturn;\n\t\t\tdefault:\n\t\t\t\treturn;\n\t\t}\n\n\t\t// Focus the appropriate tab, based on which key was pressed\n\t\tevent.preventDefault();\n\t\tclearTimeout( this.activating );\n\t\tselectedIndex = this._focusNextTab( selectedIndex, goingForward );\n\n\t\t// Navigating with control key will prevent automatic activation\n\t\tif ( !event.ctrlKey ) {\n\t\t\t// Update aria-selected immediately so that AT think the tab is already selected.\n\t\t\t// Otherwise AT may confuse the user by stating that they need to activate the tab,\n\t\t\t// but the tab will already be activated by the time the announcement finishes.\n\t\t\tfocusedTab.attr( \"aria-selected\", \"false\" );\n\t\t\tthis.tabs.eq( selectedIndex ).attr( \"aria-selected\", \"true\" );\n\n\t\t\tthis.activating = this._delay(function() {\n\t\t\t\tthis.option( \"active\", selectedIndex );\n\t\t\t}, this.delay );\n\t\t}\n\t},\n\n\t_panelKeydown: function( event ) {\n\t\tif ( this._handlePageNav( event ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Ctrl+up moves focus to the current tab\n\t\tif ( event.ctrlKey && event.keyCode === $.ui.keyCode.UP ) {\n\t\t\tevent.preventDefault();\n\t\t\tthis.active.focus();\n\t\t}\n\t},\n\n\t// Alt+page up/down moves focus to the previous/next tab (and activates)\n\t_handlePageNav: function( event ) {\n\t\tif ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_UP ) {\n\t\t\tthis._activate( this._focusNextTab( this.options.active - 1, false ) );\n\t\t\treturn true;\n\t\t}\n\t\tif ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_DOWN ) {\n\t\t\tthis._activate( this._focusNextTab( this.options.active + 1, true ) );\n\t\t\treturn true;\n\t\t}\n\t},\n\n\t_findNextTab: function( index, goingForward ) {\n\t\tvar lastTabIndex = this.tabs.length - 1;\n\n\t\tfunction constrain() {\n\t\t\tif ( index > lastTabIndex ) {\n\t\t\t\tindex = 0;\n\t\t\t}\n\t\t\tif ( index < 0 ) {\n\t\t\t\tindex = lastTabIndex;\n\t\t\t}\n\t\t\treturn index;\n\t\t}\n\n\t\twhile ( $.inArray( constrain(), this.options.disabled ) !== -1 ) {\n\t\t\tindex = goingForward ? index + 1 : index - 1;\n\t\t}\n\n\t\treturn index;\n\t},\n\n\t_focusNextTab: function( index, goingForward ) {\n\t\tindex = this._findNextTab( index, goingForward );\n\t\tthis.tabs.eq( index ).focus();\n\t\treturn index;\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"active\" ) {\n\t\t\t// _activate() will handle invalid values and update this.options\n\t\t\tthis._activate( value );\n\t\t\treturn;\n\t\t}\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\t// don't use the widget factory's disabled handling\n\t\t\tthis._setupDisabled( value );\n\t\t\treturn;\n\t\t}\n\n\t\tthis._super( key, value);\n\n\t\tif ( key === \"collapsible\" ) {\n\t\t\tthis.element.toggleClass( \"ui-tabs-collapsible\", value );\n\t\t\t// Setting collapsible: false while collapsed; open first panel\n\t\t\tif ( !value && this.options.active === false ) {\n\t\t\t\tthis._activate( 0 );\n\t\t\t}\n\t\t}\n\n\t\tif ( key === \"event\" ) {\n\t\t\tthis._setupEvents( value );\n\t\t}\n\n\t\tif ( key === \"heightStyle\" ) {\n\t\t\tthis._setupHeightStyle( value );\n\t\t}\n\t},\n\n\t_tabId: function( tab ) {\n\t\treturn tab.attr( \"aria-controls\" ) || \"ui-tabs-\" + getNextTabId();\n\t},\n\n\t_sanitizeSelector: function( hash ) {\n\t\treturn hash ? hash.replace( /[!\"$%&'()*+,.\\/:;<=>?@\\[\\]\\^`{|}~]/g, \"\\\\$&\" ) : \"\";\n\t},\n\n\trefresh: function() {\n\t\tvar options = this.options,\n\t\t\tlis = this.tablist.children( \":has(a[href])\" );\n\n\t\t// get disabled tabs from class attribute from HTML\n\t\t// this will get converted to a boolean if needed in _refresh()\n\t\toptions.disabled = $.map( lis.filter( \".ui-state-disabled\" ), function( tab ) {\n\t\t\treturn lis.index( tab );\n\t\t});\n\n\t\tthis._processTabs();\n\n\t\t// was collapsed or no tabs\n\t\tif ( options.active === false || !this.anchors.length ) {\n\t\t\toptions.active = false;\n\t\t\tthis.active = $();\n\t\t// was active, but active tab is gone\n\t\t} else if ( this.active.length && !$.contains( this.tablist[ 0 ], this.active[ 0 ] ) ) {\n\t\t\t// all remaining tabs are disabled\n\t\t\tif ( this.tabs.length === options.disabled.length ) {\n\t\t\t\toptions.active = false;\n\t\t\t\tthis.active = $();\n\t\t\t// activate previous tab\n\t\t\t} else {\n\t\t\t\tthis._activate( this._findNextTab( Math.max( 0, options.active - 1 ), false ) );\n\t\t\t}\n\t\t// was active, active tab still exists\n\t\t} else {\n\t\t\t// make sure active index is correct\n\t\t\toptions.active = this.tabs.index( this.active );\n\t\t}\n\n\t\tthis._refresh();\n\t},\n\n\t_refresh: function() {\n\t\tthis._setupDisabled( this.options.disabled );\n\t\tthis._setupEvents( this.options.event );\n\t\tthis._setupHeightStyle( this.options.heightStyle );\n\n\t\tthis.tabs.not( this.active ).attr({\n\t\t\t\"aria-selected\": \"false\",\n\t\t\ttabIndex: -1\n\t\t});\n\t\tthis.panels.not( this._getPanelForTab( this.active ) )\n\t\t\t.hide()\n\t\t\t.attr({\n\t\t\t\t\"aria-expanded\": \"false\",\n\t\t\t\t\"aria-hidden\": \"true\"\n\t\t\t});\n\n\t\t// Make sure one tab is in the tab order\n\t\tif ( !this.active.length ) {\n\t\t\tthis.tabs.eq( 0 ).attr( \"tabIndex\", 0 );\n\t\t} else {\n\t\t\tthis.active\n\t\t\t\t.addClass( \"ui-tabs-active ui-state-active\" )\n\t\t\t\t.attr({\n\t\t\t\t\t\"aria-selected\": \"true\",\n\t\t\t\t\ttabIndex: 0\n\t\t\t\t});\n\t\t\tthis._getPanelForTab( this.active )\n\t\t\t\t.show()\n\t\t\t\t.attr({\n\t\t\t\t\t\"aria-expanded\": \"true\",\n\t\t\t\t\t\"aria-hidden\": \"false\"\n\t\t\t\t});\n\t\t}\n\t},\n\n\t_processTabs: function() {\n\t\tvar that = this;\n\n\t\tthis.tablist = this._getList()\n\t\t\t.addClass( \"ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all\" )\n\t\t\t.attr( \"role\", \"tablist\" );\n\n\t\tthis.tabs = this.tablist.find( \"> li:has(a[href])\" )\n\t\t\t.addClass( \"ui-state-default ui-corner-top\" )\n\t\t\t.attr({\n\t\t\t\trole: \"tab\",\n\t\t\t\ttabIndex: -1\n\t\t\t});\n\n\t\tthis.anchors = this.tabs.map(function() {\n\t\t\t\treturn $( \"a\", this )[ 0 ];\n\t\t\t})\n\t\t\t.addClass( \"ui-tabs-anchor\" )\n\t\t\t.attr({\n\t\t\t\trole: \"presentation\",\n\t\t\t\ttabIndex: -1\n\t\t\t});\n\n\t\tthis.panels = $();\n\n\t\tthis.anchors.each(function( i, anchor ) {\n\t\t\tvar selector, panel, panelId,\n\t\t\t\tanchorId = $( anchor ).uniqueId().attr( \"id\" ),\n\t\t\t\ttab = $( anchor ).closest( \"li\" ),\n\t\t\t\toriginalAriaControls = tab.attr( \"aria-controls\" );\n\n\t\t\t// inline tab\n\t\t\tif ( isLocal( anchor ) ) {\n\t\t\t\tselector = anchor.hash;\n\t\t\t\tpanel = that.element.find( that._sanitizeSelector( selector ) );\n\t\t\t// remote tab\n\t\t\t} else {\n\t\t\t\tpanelId = that._tabId( tab );\n\t\t\t\tselector = \"#\" + panelId;\n\t\t\t\tpanel = that.element.find( selector );\n\t\t\t\tif ( !panel.length ) {\n\t\t\t\t\tpanel = that._createPanel( panelId );\n\t\t\t\t\tpanel.insertAfter( that.panels[ i - 1 ] || that.tablist );\n\t\t\t\t}\n\t\t\t\tpanel.attr( \"aria-live\", \"polite\" );\n\t\t\t}\n\n\t\t\tif ( panel.length) {\n\t\t\t\tthat.panels = that.panels.add( panel );\n\t\t\t}\n\t\t\tif ( originalAriaControls ) {\n\t\t\t\ttab.data( \"ui-tabs-aria-controls\", originalAriaControls );\n\t\t\t}\n\t\t\ttab.attr({\n\t\t\t\t\"aria-controls\": selector.substring( 1 ),\n\t\t\t\t\"aria-labelledby\": anchorId\n\t\t\t});\n\t\t\tpanel.attr( \"aria-labelledby\", anchorId );\n\t\t});\n\n\t\tthis.panels\n\t\t\t.addClass( \"ui-tabs-panel ui-widget-content ui-corner-bottom\" )\n\t\t\t.attr( \"role\", \"tabpanel\" );\n\t},\n\n\t// allow overriding how to find the list for rare usage scenarios (#7715)\n\t_getList: function() {\n\t\treturn this.element.find( \"ol,ul\" ).eq( 0 );\n\t},\n\n\t_createPanel: function( id ) {\n\t\treturn $( \"<div>\" )\n\t\t\t.attr( \"id\", id )\n\t\t\t.addClass( \"ui-tabs-panel ui-widget-content ui-corner-bottom\" )\n\t\t\t.data( \"ui-tabs-destroy\", true );\n\t},\n\n\t_setupDisabled: function( disabled ) {\n\t\tif ( $.isArray( disabled ) ) {\n\t\t\tif ( !disabled.length ) {\n\t\t\t\tdisabled = false;\n\t\t\t} else if ( disabled.length === this.anchors.length ) {\n\t\t\t\tdisabled = true;\n\t\t\t}\n\t\t}\n\n\t\t// disable tabs\n\t\tfor ( var i = 0, li; ( li = this.tabs[ i ] ); i++ ) {\n\t\t\tif ( disabled === true || $.inArray( i, disabled ) !== -1 ) {\n\t\t\t\t$( li )\n\t\t\t\t\t.addClass( \"ui-state-disabled\" )\n\t\t\t\t\t.attr( \"aria-disabled\", \"true\" );\n\t\t\t} else {\n\t\t\t\t$( li )\n\t\t\t\t\t.removeClass( \"ui-state-disabled\" )\n\t\t\t\t\t.removeAttr( \"aria-disabled\" );\n\t\t\t}\n\t\t}\n\n\t\tthis.options.disabled = disabled;\n\t},\n\n\t_setupEvents: function( event ) {\n\t\tvar events = {\n\t\t\tclick: function( event ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t}\n\t\t};\n\t\tif ( event ) {\n\t\t\t$.each( event.split(\" \"), function( index, eventName ) {\n\t\t\t\tevents[ eventName ] = \"_eventHandler\";\n\t\t\t});\n\t\t}\n\n\t\tthis._off( this.anchors.add( this.tabs ).add( this.panels ) );\n\t\tthis._on( this.anchors, events );\n\t\tthis._on( this.tabs, { keydown: \"_tabKeydown\" } );\n\t\tthis._on( this.panels, { keydown: \"_panelKeydown\" } );\n\n\t\tthis._focusable( this.tabs );\n\t\tthis._hoverable( this.tabs );\n\t},\n\n\t_setupHeightStyle: function( heightStyle ) {\n\t\tvar maxHeight, overflow,\n\t\t\tparent = this.element.parent();\n\n\t\tif ( heightStyle === \"fill\" ) {\n\t\t\t// IE 6 treats height like minHeight, so we need to turn off overflow\n\t\t\t// in order to get a reliable height\n\t\t\t// we use the minHeight support test because we assume that only\n\t\t\t// browsers that don't support minHeight will treat height as minHeight\n\t\t\tif ( !$.support.minHeight ) {\n\t\t\t\toverflow = parent.css( \"overflow\" );\n\t\t\t\tparent.css( \"overflow\", \"hidden\");\n\t\t\t}\n\t\t\tmaxHeight = parent.height();\n\t\t\tthis.element.siblings( \":visible\" ).each(function() {\n\t\t\t\tvar elem = $( this ),\n\t\t\t\t\tposition = elem.css( \"position\" );\n\n\t\t\t\tif ( position === \"absolute\" || position === \"fixed\" ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tmaxHeight -= elem.outerHeight( true );\n\t\t\t});\n\t\t\tif ( overflow ) {\n\t\t\t\tparent.css( \"overflow\", overflow );\n\t\t\t}\n\n\t\t\tthis.element.children().not( this.panels ).each(function() {\n\t\t\t\tmaxHeight -= $( this ).outerHeight( true );\n\t\t\t});\n\n\t\t\tthis.panels.each(function() {\n\t\t\t\t$( this ).height( Math.max( 0, maxHeight -\n\t\t\t\t\t$( this ).innerHeight() + $( this ).height() ) );\n\t\t\t})\n\t\t\t.css( \"overflow\", \"auto\" );\n\t\t} else if ( heightStyle === \"auto\" ) {\n\t\t\tmaxHeight = 0;\n\t\t\tthis.panels.each(function() {\n\t\t\t\tmaxHeight = Math.max( maxHeight, $( this ).height( \"\" ).height() );\n\t\t\t}).height( maxHeight );\n\t\t}\n\t},\n\n\t_eventHandler: function( event ) {\n\t\tvar options = this.options,\n\t\t\tactive = this.active,\n\t\t\tanchor = $( event.currentTarget ),\n\t\t\ttab = anchor.closest( \"li\" ),\n\t\t\tclickedIsActive = tab[ 0 ] === active[ 0 ],\n\t\t\tcollapsing = clickedIsActive && options.collapsible,\n\t\t\ttoShow = collapsing ? $() : this._getPanelForTab( tab ),\n\t\t\ttoHide = !active.length ? $() : this._getPanelForTab( active ),\n\t\t\teventData = {\n\t\t\t\toldTab: active,\n\t\t\t\toldPanel: toHide,\n\t\t\t\tnewTab: collapsing ? $() : tab,\n\t\t\t\tnewPanel: toShow\n\t\t\t};\n\n\t\tevent.preventDefault();\n\n\t\tif ( tab.hasClass( \"ui-state-disabled\" ) ||\n\t\t\t\t// tab is already loading\n\t\t\t\ttab.hasClass( \"ui-tabs-loading\" ) ||\n\t\t\t\t// can't switch durning an animation\n\t\t\t\tthis.running ||\n\t\t\t\t// click on active header, but not collapsible\n\t\t\t\t( clickedIsActive && !options.collapsible ) ||\n\t\t\t\t// allow canceling activation\n\t\t\t\t( this._trigger( \"beforeActivate\", event, eventData ) === false ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\toptions.active = collapsing ? false : this.tabs.index( tab );\n\n\t\tthis.active = clickedIsActive ? $() : tab;\n\t\tif ( this.xhr ) {\n\t\t\tthis.xhr.abort();\n\t\t}\n\n\t\tif ( !toHide.length && !toShow.length ) {\n\t\t\t$.error( \"jQuery UI Tabs: Mismatching fragment identifier.\" );\n\t\t}\n\n\t\tif ( toShow.length ) {\n\t\t\tthis.load( this.tabs.index( tab ), event );\n\t\t}\n\t\tthis._toggle( event, eventData );\n\t},\n\n\t// handles show/hide for selecting tabs\n\t_toggle: function( event, eventData ) {\n\t\tvar that = this,\n\t\t\ttoShow = eventData.newPanel,\n\t\t\ttoHide = eventData.oldPanel;\n\n\t\tthis.running = true;\n\n\t\tfunction complete() {\n\t\t\tthat.running = false;\n\t\t\tthat._trigger( \"activate\", event, eventData );\n\t\t}\n\n\t\tfunction show() {\n\t\t\teventData.newTab.closest( \"li\" ).addClass( \"ui-tabs-active ui-state-active\" );\n\n\t\t\tif ( toShow.length && that.options.show ) {\n\t\t\t\tthat._show( toShow, that.options.show, complete );\n\t\t\t} else {\n\t\t\t\ttoShow.show();\n\t\t\t\tcomplete();\n\t\t\t}\n\t\t}\n\n\t\t// start out by hiding, then showing, then completing\n\t\tif ( toHide.length && this.options.hide ) {\n\t\t\tthis._hide( toHide, this.options.hide, function() {\n\t\t\t\teventData.oldTab.closest( \"li\" ).removeClass( \"ui-tabs-active ui-state-active\" );\n\t\t\t\tshow();\n\t\t\t});\n\t\t} else {\n\t\t\teventData.oldTab.closest( \"li\" ).removeClass( \"ui-tabs-active ui-state-active\" );\n\t\t\ttoHide.hide();\n\t\t\tshow();\n\t\t}\n\n\t\ttoHide.attr({\n\t\t\t\"aria-expanded\": \"false\",\n\t\t\t\"aria-hidden\": \"true\"\n\t\t});\n\t\teventData.oldTab.attr( \"aria-selected\", \"false\" );\n\t\t// If we're switching tabs, remove the old tab from the tab order.\n\t\t// If we're opening from collapsed state, remove the previous tab from the tab order.\n\t\t// If we're collapsing, then keep the collapsing tab in the tab order.\n\t\tif ( toShow.length && toHide.length ) {\n\t\t\teventData.oldTab.attr( \"tabIndex\", -1 );\n\t\t} else if ( toShow.length ) {\n\t\t\tthis.tabs.filter(function() {\n\t\t\t\treturn $( this ).attr( \"tabIndex\" ) === 0;\n\t\t\t})\n\t\t\t.attr( \"tabIndex\", -1 );\n\t\t}\n\n\t\ttoShow.attr({\n\t\t\t\"aria-expanded\": \"true\",\n\t\t\t\"aria-hidden\": \"false\"\n\t\t});\n\t\teventData.newTab.attr({\n\t\t\t\"aria-selected\": \"true\",\n\t\t\ttabIndex: 0\n\t\t});\n\t},\n\n\t_activate: function( index ) {\n\t\tvar anchor,\n\t\t\tactive = this._findActive( index );\n\n\t\t// trying to activate the already active panel\n\t\tif ( active[ 0 ] === this.active[ 0 ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// trying to collapse, simulate a click on the current active header\n\t\tif ( !active.length ) {\n\t\t\tactive = this.active;\n\t\t}\n\n\t\tanchor = active.find( \".ui-tabs-anchor\" )[ 0 ];\n\t\tthis._eventHandler({\n\t\t\ttarget: anchor,\n\t\t\tcurrentTarget: anchor,\n\t\t\tpreventDefault: $.noop\n\t\t});\n\t},\n\n\t_findActive: function( index ) {\n\t\treturn index === false ? $() : this.tabs.eq( index );\n\t},\n\n\t_getIndex: function( index ) {\n\t\t// meta-function to give users option to provide a href string instead of a numerical index.\n\t\tif ( typeof index === \"string\" ) {\n\t\t\tindex = this.anchors.index( this.anchors.filter( \"[href$='\" + index + \"']\" ) );\n\t\t}\n\n\t\treturn index;\n\t},\n\n\t_destroy: function() {\n\t\tif ( this.xhr ) {\n\t\t\tthis.xhr.abort();\n\t\t}\n\n\t\tthis.element.removeClass( \"ui-tabs ui-widget ui-widget-content ui-corner-all ui-tabs-collapsible\" );\n\n\t\tthis.tablist\n\t\t\t.removeClass( \"ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all\" )\n\t\t\t.removeAttr( \"role\" );\n\n\t\tthis.anchors\n\t\t\t.removeClass( \"ui-tabs-anchor\" )\n\t\t\t.removeAttr( \"role\" )\n\t\t\t.removeAttr( \"tabIndex\" )\n\t\t\t.removeData( \"href.tabs\" )\n\t\t\t.removeData( \"load.tabs\" )\n\t\t\t.removeUniqueId();\n\n\t\tthis.tabs.add( this.panels ).each(function() {\n\t\t\tif ( $.data( this, \"ui-tabs-destroy\" ) ) {\n\t\t\t\t$( this ).remove();\n\t\t\t} else {\n\t\t\t\t$( this )\n\t\t\t\t\t.removeClass( \"ui-state-default ui-state-active ui-state-disabled \" +\n\t\t\t\t\t\t\"ui-corner-top ui-corner-bottom ui-widget-content ui-tabs-active ui-tabs-panel\" )\n\t\t\t\t\t.removeAttr( \"tabIndex\" )\n\t\t\t\t\t.removeAttr( \"aria-live\" )\n\t\t\t\t\t.removeAttr( \"aria-busy\" )\n\t\t\t\t\t.removeAttr( \"aria-selected\" )\n\t\t\t\t\t.removeAttr( \"aria-labelledby\" )\n\t\t\t\t\t.removeAttr( \"aria-hidden\" )\n\t\t\t\t\t.removeAttr( \"aria-expanded\" )\n\t\t\t\t\t.removeAttr( \"role\" );\n\t\t\t}\n\t\t});\n\n\t\tthis.tabs.each(function() {\n\t\t\tvar li = $( this ),\n\t\t\t\tprev = li.data( \"ui-tabs-aria-controls\" );\n\t\t\tif ( prev ) {\n\t\t\t\tli.attr( \"aria-controls\", prev );\n\t\t\t} else {\n\t\t\t\tli.removeAttr( \"aria-controls\" );\n\t\t\t}\n\t\t});\n\n\t\tthis.panels.show();\n\n\t\tif ( this.options.heightStyle !== \"content\" ) {\n\t\t\tthis.panels.css( \"height\", \"\" );\n\t\t}\n\t},\n\n\tenable: function( index ) {\n\t\tvar disabled = this.options.disabled;\n\t\tif ( disabled === false ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( index === undefined ) {\n\t\t\tdisabled = false;\n\t\t} else {\n\t\t\tindex = this._getIndex( index );\n\t\t\tif ( $.isArray( disabled ) ) {\n\t\t\t\tdisabled = $.map( disabled, function( num ) {\n\t\t\t\t\treturn num !== index ? num : null;\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tdisabled = $.map( this.tabs, function( li, num ) {\n\t\t\t\t\treturn num !== index ? num : null;\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t\tthis._setupDisabled( disabled );\n\t},\n\n\tdisable: function( index ) {\n\t\tvar disabled = this.options.disabled;\n\t\tif ( disabled === true ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( index === undefined ) {\n\t\t\tdisabled = true;\n\t\t} else {\n\t\t\tindex = this._getIndex( index );\n\t\t\tif ( $.inArray( index, disabled ) !== -1 ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tif ( $.isArray( disabled ) ) {\n\t\t\t\tdisabled = $.merge( [ index ], disabled ).sort();\n\t\t\t} else {\n\t\t\t\tdisabled = [ index ];\n\t\t\t}\n\t\t}\n\t\tthis._setupDisabled( disabled );\n\t},\n\n\tload: function( index, event ) {\n\t\tindex = this._getIndex( index );\n\t\tvar that = this,\n\t\t\ttab = this.tabs.eq( index ),\n\t\t\tanchor = tab.find( \".ui-tabs-anchor\" ),\n\t\t\tpanel = this._getPanelForTab( tab ),\n\t\t\teventData = {\n\t\t\t\ttab: tab,\n\t\t\t\tpanel: panel\n\t\t\t};\n\n\t\t// not remote\n\t\tif ( isLocal( anchor[ 0 ] ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.xhr = $.ajax( this._ajaxSettings( anchor, event, eventData ) );\n\n\t\t// support: jQuery <1.8\n\t\t// jQuery <1.8 returns false if the request is canceled in beforeSend,\n\t\t// but as of 1.8, $.ajax() always returns a jqXHR object.\n\t\tif ( this.xhr && this.xhr.statusText !== \"canceled\" ) {\n\t\t\ttab.addClass( \"ui-tabs-loading\" );\n\t\t\tpanel.attr( \"aria-busy\", \"true\" );\n\n\t\t\tthis.xhr\n\t\t\t\t.success(function( response ) {\n\t\t\t\t\t// support: jQuery <1.8\n\t\t\t\t\t// http://bugs.jquery.com/ticket/11778\n\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\tpanel.html( response );\n\t\t\t\t\t\tthat._trigger( \"load\", event, eventData );\n\t\t\t\t\t}, 1 );\n\t\t\t\t})\n\t\t\t\t.complete(function( jqXHR, status ) {\n\t\t\t\t\t// support: jQuery <1.8\n\t\t\t\t\t// http://bugs.jquery.com/ticket/11778\n\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\tif ( status === \"abort\" ) {\n\t\t\t\t\t\t\tthat.panels.stop( false, true );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttab.removeClass( \"ui-tabs-loading\" );\n\t\t\t\t\t\tpanel.removeAttr( \"aria-busy\" );\n\n\t\t\t\t\t\tif ( jqXHR === that.xhr ) {\n\t\t\t\t\t\t\tdelete that.xhr;\n\t\t\t\t\t\t}\n\t\t\t\t\t}, 1 );\n\t\t\t\t});\n\t\t}\n\t},\n\n\t// TODO: Remove this function in 1.10 when ajaxOptions is removed\n\t_ajaxSettings: function( anchor, event, eventData ) {\n\t\tvar that = this;\n\t\treturn {\n\t\t\turl: anchor.attr( \"href\" ),\n\t\t\tbeforeSend: function( jqXHR, settings ) {\n\t\t\t\treturn that._trigger( \"beforeLoad\", event,\n\t\t\t\t\t$.extend( { jqXHR : jqXHR, ajaxSettings: settings }, eventData ) );\n\t\t\t}\n\t\t};\n\t},\n\n\t_getPanelForTab: function( tab ) {\n\t\tvar id = $( tab ).attr( \"aria-controls\" );\n\t\treturn this.element.find( this._sanitizeSelector( \"#\" + id ) );\n\t}\n});\n\n// DEPRECATED\nif ( $.uiBackCompat !== false ) {\n\n\t// helper method for a lot of the back compat extensions\n\t$.ui.tabs.prototype._ui = function( tab, panel ) {\n\t\treturn {\n\t\t\ttab: tab,\n\t\t\tpanel: panel,\n\t\t\tindex: this.anchors.index( tab )\n\t\t};\n\t};\n\n\t// url method\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\turl: function( index, url ) {\n\t\t\tthis.anchors.eq( index ).attr( \"href\", url );\n\t\t}\n\t});\n\n\t// TODO: Remove _ajaxSettings() method when removing this extension\n\t// ajaxOptions and cache options\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\toptions: {\n\t\t\tajaxOptions: null,\n\t\t\tcache: false\n\t\t},\n\n\t\t_create: function() {\n\t\t\tthis._super();\n\n\t\t\tvar that = this;\n\n\t\t\tthis._on({ tabsbeforeload: function( event, ui ) {\n\t\t\t\t// tab is already cached\n\t\t\t\tif ( $.data( ui.tab[ 0 ], \"cache.tabs\" ) ) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tui.jqXHR.success(function() {\n\t\t\t\t\tif ( that.options.cache ) {\n\t\t\t\t\t\t$.data( ui.tab[ 0 ], \"cache.tabs\", true );\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}});\n\t\t},\n\n\t\t_ajaxSettings: function( anchor, event, ui ) {\n\t\t\tvar ajaxOptions = this.options.ajaxOptions;\n\t\t\treturn $.extend( {}, ajaxOptions, {\n\t\t\t\terror: function( xhr, status ) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\t// Passing index avoid a race condition when this method is\n\t\t\t\t\t\t// called after the user has selected another tab.\n\t\t\t\t\t\t// Pass the anchor that initiated this request allows\n\t\t\t\t\t\t// loadError to manipulate the tab content panel via $(a.hash)\n\t\t\t\t\t\tajaxOptions.error(\n\t\t\t\t\t\t\txhr, status, ui.tab.closest( \"li\" ).index(), ui.tab[ 0 ] );\n\t\t\t\t\t}\n\t\t\t\t\tcatch ( error ) {}\n\t\t\t\t}\n\t\t\t}, this._superApply( arguments ) );\n\t\t},\n\n\t\t_setOption: function( key, value ) {\n\t\t\t// reset cache if switching from cached to not cached\n\t\t\tif ( key === \"cache\" && value === false ) {\n\t\t\t\tthis.anchors.removeData( \"cache.tabs\" );\n\t\t\t}\n\t\t\tthis._super( key, value );\n\t\t},\n\n\t\t_destroy: function() {\n\t\t\tthis.anchors.removeData( \"cache.tabs\" );\n\t\t\tthis._super();\n\t\t},\n\n\t\turl: function( index ){\n\t\t\tthis.anchors.eq( index ).removeData( \"cache.tabs\" );\n\t\t\tthis._superApply( arguments );\n\t\t}\n\t});\n\n\t// abort method\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\tabort: function() {\n\t\t\tif ( this.xhr ) {\n\t\t\t\tthis.xhr.abort();\n\t\t\t}\n\t\t}\n\t});\n\n\t// spinner\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\toptions: {\n\t\t\tspinner: \"<em>Loading&#8230;</em>\"\n\t\t},\n\t\t_create: function() {\n\t\t\tthis._super();\n\t\t\tthis._on({\n\t\t\t\ttabsbeforeload: function( event, ui ) {\n\t\t\t\t\t// Don't react to nested tabs or tabs that don't use a spinner\n\t\t\t\t\tif ( event.target !== this.element[ 0 ] ||\n\t\t\t\t\t\t\t!this.options.spinner ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tvar span = ui.tab.find( \"span\" ),\n\t\t\t\t\t\thtml = span.html();\n\t\t\t\t\tspan.html( this.options.spinner );\n\t\t\t\t\tui.jqXHR.complete(function() {\n\t\t\t\t\t\tspan.html( html );\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t});\n\n\t// enable/disable events\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\toptions: {\n\t\t\tenable: null,\n\t\t\tdisable: null\n\t\t},\n\n\t\tenable: function( index ) {\n\t\t\tvar options = this.options,\n\t\t\t\ttrigger;\n\n\t\t\tif ( index && options.disabled === true ||\n\t\t\t\t\t( $.isArray( options.disabled ) && $.inArray( index, options.disabled ) !== -1 ) ) {\n\t\t\t\ttrigger = true;\n\t\t\t}\n\n\t\t\tthis._superApply( arguments );\n\n\t\t\tif ( trigger ) {\n\t\t\t\tthis._trigger( \"enable\", null, this._ui( this.anchors[ index ], this.panels[ index ] ) );\n\t\t\t}\n\t\t},\n\n\t\tdisable: function( index ) {\n\t\t\tvar options = this.options,\n\t\t\t\ttrigger;\n\n\t\t\tif ( index && options.disabled === false ||\n\t\t\t\t\t( $.isArray( options.disabled ) && $.inArray( index, options.disabled ) === -1 ) ) {\n\t\t\t\ttrigger = true;\n\t\t\t}\n\n\t\t\tthis._superApply( arguments );\n\n\t\t\tif ( trigger ) {\n\t\t\t\tthis._trigger( \"disable\", null, this._ui( this.anchors[ index ], this.panels[ index ] ) );\n\t\t\t}\n\t\t}\n\t});\n\n\t// add/remove methods and events\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\toptions: {\n\t\t\tadd: null,\n\t\t\tremove: null,\n\t\t\ttabTemplate: \"<li><a href='#{href}'><span>#{label}</span></a></li>\"\n\t\t},\n\n\t\tadd: function( url, label, index ) {\n\t\t\tif ( index === undefined ) {\n\t\t\t\tindex = this.anchors.length;\n\t\t\t}\n\n\t\t\tvar doInsertAfter, panel,\n\t\t\t\toptions = this.options,\n\t\t\t\tli = $( options.tabTemplate\n\t\t\t\t\t.replace( /#\\{href\\}/g, url )\n\t\t\t\t\t.replace( /#\\{label\\}/g, label ) ),\n\t\t\t\tid = !url.indexOf( \"#\" ) ?\n\t\t\t\t\turl.replace( \"#\", \"\" ) :\n\t\t\t\t\tthis._tabId( li );\n\n\t\t\tli.addClass( \"ui-state-default ui-corner-top\" ).data( \"ui-tabs-destroy\", true );\n\t\t\tli.attr( \"aria-controls\", id );\n\n\t\t\tdoInsertAfter = index >= this.tabs.length;\n\n\t\t\t// try to find an existing element before creating a new one\n\t\t\tpanel = this.element.find( \"#\" + id );\n\t\t\tif ( !panel.length ) {\n\t\t\t\tpanel = this._createPanel( id );\n\t\t\t\tif ( doInsertAfter ) {\n\t\t\t\t\tif ( index > 0 ) {\n\t\t\t\t\t\tpanel.insertAfter( this.panels.eq( -1 ) );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tpanel.appendTo( this.element );\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tpanel.insertBefore( this.panels[ index ] );\n\t\t\t\t}\n\t\t\t}\n\t\t\tpanel.addClass( \"ui-tabs-panel ui-widget-content ui-corner-bottom\" ).hide();\n\n\t\t\tif ( doInsertAfter ) {\n\t\t\t\tli.appendTo( this.tablist );\n\t\t\t} else {\n\t\t\t\tli.insertBefore( this.tabs[ index ] );\n\t\t\t}\n\n\t\t\toptions.disabled = $.map( options.disabled, function( n ) {\n\t\t\t\treturn n >= index ? ++n : n;\n\t\t\t});\n\n\t\t\tthis.refresh();\n\t\t\tif ( this.tabs.length === 1 && options.active === false ) {\n\t\t\t\tthis.option( \"active\", 0 );\n\t\t\t}\n\n\t\t\tthis._trigger( \"add\", null, this._ui( this.anchors[ index ], this.panels[ index ] ) );\n\t\t\treturn this;\n\t\t},\n\n\t\tremove: function( index ) {\n\t\t\tindex = this._getIndex( index );\n\t\t\tvar options = this.options,\n\t\t\t\ttab = this.tabs.eq( index ).remove(),\n\t\t\t\tpanel = this._getPanelForTab( tab ).remove();\n\n\t\t\t// If selected tab was removed focus tab to the right or\n\t\t\t// in case the last tab was removed the tab to the left.\n\t\t\t// We check for more than 2 tabs, because if there are only 2,\n\t\t\t// then when we remove this tab, there will only be one tab left\n\t\t\t// so we don't need to detect which tab to activate.\n\t\t\tif ( tab.hasClass( \"ui-tabs-active\" ) && this.anchors.length > 2 ) {\n\t\t\t\tthis._activate( index + ( index + 1 < this.anchors.length ? 1 : -1 ) );\n\t\t\t}\n\n\t\t\toptions.disabled = $.map(\n\t\t\t\t$.grep( options.disabled, function( n ) {\n\t\t\t\t\treturn n !== index;\n\t\t\t\t}),\n\t\t\t\tfunction( n ) {\n\t\t\t\t\treturn n >= index ? --n : n;\n\t\t\t\t});\n\n\t\t\tthis.refresh();\n\n\t\t\tthis._trigger( \"remove\", null, this._ui( tab.find( \"a\" )[ 0 ], panel[ 0 ] ) );\n\t\t\treturn this;\n\t\t}\n\t});\n\n\t// length method\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\tlength: function() {\n\t\t\treturn this.anchors.length;\n\t\t}\n\t});\n\n\t// panel ids (idPrefix option + title attribute)\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\toptions: {\n\t\t\tidPrefix: \"ui-tabs-\"\n\t\t},\n\n\t\t_tabId: function( tab ) {\n\t\t\tvar a = tab.is( \"li\" ) ? tab.find( \"a[href]\" ) : tab;\n\t\t\ta = a[0];\n\t\t\treturn $( a ).closest( \"li\" ).attr( \"aria-controls\" ) ||\n\t\t\t\ta.title && a.title.replace( /\\s/g, \"_\" ).replace( /[^\\w\\u00c0-\\uFFFF\\-]/g, \"\" ) ||\n\t\t\t\tthis.options.idPrefix + getNextTabId();\n\t\t}\n\t});\n\n\t// _createPanel method\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\toptions: {\n\t\t\tpanelTemplate: \"<div></div>\"\n\t\t},\n\n\t\t_createPanel: function( id ) {\n\t\t\treturn $( this.options.panelTemplate )\n\t\t\t\t.attr( \"id\", id )\n\t\t\t\t.addClass( \"ui-tabs-panel ui-widget-content ui-corner-bottom\" )\n\t\t\t\t.data( \"ui-tabs-destroy\", true );\n\t\t}\n\t});\n\n\t// selected option\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\t_create: function() {\n\t\t\tvar options = this.options;\n\t\t\tif ( options.active === null && options.selected !== undefined ) {\n\t\t\t\toptions.active = options.selected === -1 ? false : options.selected;\n\t\t\t}\n\t\t\tthis._super();\n\t\t\toptions.selected = options.active;\n\t\t\tif ( options.selected === false ) {\n\t\t\t\toptions.selected = -1;\n\t\t\t}\n\t\t},\n\n\t\t_setOption: function( key, value ) {\n\t\t\tif ( key !== \"selected\" ) {\n\t\t\t\treturn this._super( key, value );\n\t\t\t}\n\n\t\t\tvar options = this.options;\n\t\t\tthis._super( \"active\", value === -1 ? false : value );\n\t\t\toptions.selected = options.active;\n\t\t\tif ( options.selected === false ) {\n\t\t\t\toptions.selected = -1;\n\t\t\t}\n\t\t},\n\n\t\t_eventHandler: function() {\n\t\t\tthis._superApply( arguments );\n\t\t\tthis.options.selected = this.options.active;\n\t\t\tif ( this.options.selected === false ) {\n\t\t\t\tthis.options.selected = -1;\n\t\t\t}\n\t\t}\n\t});\n\n\t// show and select event\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\toptions: {\n\t\t\tshow: null,\n\t\t\tselect: null\n\t\t},\n\t\t_create: function() {\n\t\t\tthis._super();\n\t\t\tif ( this.options.active !== false ) {\n\t\t\t\tthis._trigger( \"show\", null, this._ui(\n\t\t\t\t\tthis.active.find( \".ui-tabs-anchor\" )[ 0 ],\n\t\t\t\t\tthis._getPanelForTab( this.active )[ 0 ] ) );\n\t\t\t}\n\t\t},\n\t\t_trigger: function( type, event, data ) {\n\t\t\tvar tab, panel,\n\t\t\t\tret = this._superApply( arguments );\n\n\t\t\tif ( !ret ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tif ( type === \"beforeActivate\" ) {\n\t\t\t\ttab = data.newTab.length ? data.newTab : data.oldTab;\n\t\t\t\tpanel = data.newPanel.length ? data.newPanel : data.oldPanel;\n\t\t\t\tret = this._super( \"select\", event, {\n\t\t\t\t\ttab: tab.find( \".ui-tabs-anchor\" )[ 0],\n\t\t\t\t\tpanel: panel[ 0 ],\n\t\t\t\t\tindex: tab.closest( \"li\" ).index()\n\t\t\t\t});\n\t\t\t} else if ( type === \"activate\" && data.newTab.length ) {\n\t\t\t\tret = this._super( \"show\", event, {\n\t\t\t\t\ttab: data.newTab.find( \".ui-tabs-anchor\" )[ 0 ],\n\t\t\t\t\tpanel: data.newPanel[ 0 ],\n\t\t\t\t\tindex: data.newTab.closest( \"li\" ).index()\n\t\t\t\t});\n\t\t\t}\n\t\t\treturn ret;\n\t\t}\n\t});\n\n\t// select method\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\tselect: function( index ) {\n\t\t\tindex = this._getIndex( index );\n\t\t\tif ( index === -1 ) {\n\t\t\t\tif ( this.options.collapsible && this.options.selected !== -1 ) {\n\t\t\t\t\tindex = this.options.selected;\n\t\t\t\t} else {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t\tthis.anchors.eq( index ).trigger( this.options.event + this.eventNamespace );\n\t\t}\n\t});\n\n\t// cookie option\n\t(function() {\n\n\tvar listId = 0;\n\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\toptions: {\n\t\t\tcookie: null // e.g. { expires: 7, path: '/', domain: 'jquery.com', secure: true }\n\t\t},\n\t\t_create: function() {\n\t\t\tvar options = this.options,\n\t\t\t\tactive;\n\t\t\tif ( options.active == null && options.cookie ) {\n\t\t\t\tactive = parseInt( this._cookie(), 10 );\n\t\t\t\tif ( active === -1 ) {\n\t\t\t\t\tactive = false;\n\t\t\t\t}\n\t\t\t\toptions.active = active;\n\t\t\t}\n\t\t\tthis._super();\n\t\t},\n\t\t_cookie: function( active ) {\n\t\t\tvar cookie = [ this.cookie ||\n\t\t\t\t( this.cookie = this.options.cookie.name || \"ui-tabs-\" + (++listId) ) ];\n\t\t\tif ( arguments.length ) {\n\t\t\t\tcookie.push( active === false ? -1 : active );\n\t\t\t\tcookie.push( this.options.cookie );\n\t\t\t}\n\t\t\treturn $.cookie.apply( null, cookie );\n\t\t},\n\t\t_refresh: function() {\n\t\t\tthis._super();\n\t\t\tif ( this.options.cookie ) {\n\t\t\t\tthis._cookie( this.options.active, this.options.cookie );\n\t\t\t}\n\t\t},\n\t\t_eventHandler: function() {\n\t\t\tthis._superApply( arguments );\n\t\t\tif ( this.options.cookie ) {\n\t\t\t\tthis._cookie( this.options.active, this.options.cookie );\n\t\t\t}\n\t\t},\n\t\t_destroy: function() {\n\t\t\tthis._super();\n\t\t\tif ( this.options.cookie ) {\n\t\t\t\tthis._cookie( null, this.options.cookie );\n\t\t\t}\n\t\t}\n\t});\n\n\t})();\n\n\t// load event\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\t_trigger: function( type, event, data ) {\n\t\t\tvar _data = $.extend( {}, data );\n\t\t\tif ( type === \"load\" ) {\n\t\t\t\t_data.panel = _data.panel[ 0 ];\n\t\t\t\t_data.tab = _data.tab.find( \".ui-tabs-anchor\" )[ 0 ];\n\t\t\t}\n\t\t\treturn this._super( type, event, _data );\n\t\t}\n\t});\n\n\t// fx option\n\t// The new animation options (show, hide) conflict with the old show callback.\n\t// The old fx option wins over show/hide anyway (always favor back-compat).\n\t// If a user wants to use the new animation API, they must give up the old API.\n\t$.widget( \"ui.tabs\", $.ui.tabs, {\n\t\toptions: {\n\t\t\tfx: null // e.g. { height: \"toggle\", opacity: \"toggle\", duration: 200 }\n\t\t},\n\n\t\t_getFx: function() {\n\t\t\tvar hide, show,\n\t\t\t\tfx = this.options.fx;\n\n\t\t\tif ( fx ) {\n\t\t\t\tif ( $.isArray( fx ) ) {\n\t\t\t\t\thide = fx[ 0 ];\n\t\t\t\t\tshow = fx[ 1 ];\n\t\t\t\t} else {\n\t\t\t\t\thide = show = fx;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn fx ? { show: show, hide: hide } : null;\n\t\t},\n\n\t\t_toggle: function( event, eventData ) {\n\t\t\tvar that = this,\n\t\t\t\ttoShow = eventData.newPanel,\n\t\t\t\ttoHide = eventData.oldPanel,\n\t\t\t\tfx = this._getFx();\n\n\t\t\tif ( !fx ) {\n\t\t\t\treturn this._super( event, eventData );\n\t\t\t}\n\n\t\t\tthat.running = true;\n\n\t\t\tfunction complete() {\n\t\t\t\tthat.running = false;\n\t\t\t\tthat._trigger( \"activate\", event, eventData );\n\t\t\t}\n\n\t\t\tfunction show() {\n\t\t\t\teventData.newTab.closest( \"li\" ).addClass( \"ui-tabs-active ui-state-active\" );\n\n\t\t\t\tif ( toShow.length && fx.show ) {\n\t\t\t\t\ttoShow\n\t\t\t\t\t\t.animate( fx.show, fx.show.duration, function() {\n\t\t\t\t\t\t\tcomplete();\n\t\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\ttoShow.show();\n\t\t\t\t\tcomplete();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// start out by hiding, then showing, then completing\n\t\t\tif ( toHide.length && fx.hide ) {\n\t\t\t\ttoHide.animate( fx.hide, fx.hide.duration, function() {\n\t\t\t\t\teventData.oldTab.closest( \"li\" ).removeClass( \"ui-tabs-active ui-state-active\" );\n\t\t\t\t\tshow();\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\teventData.oldTab.closest( \"li\" ).removeClass( \"ui-tabs-active ui-state-active\" );\n\t\t\t\ttoHide.hide();\n\t\t\t\tshow();\n\t\t\t}\n\t\t}\n\t});\n}\n\n})( jQuery );\n\n(function( $ ) {\n\nvar increments = 0;\n\nfunction addDescribedBy( elem, id ) {\n\tvar describedby = (elem.attr( \"aria-describedby\" ) || \"\").split( /\\s+/ );\n\tdescribedby.push( id );\n\telem\n\t\t.data( \"ui-tooltip-id\", id )\n\t\t.attr( \"aria-describedby\", $.trim( describedby.join( \" \" ) ) );\n}\n\nfunction removeDescribedBy( elem ) {\n\tvar id = elem.data( \"ui-tooltip-id\" ),\n\t\tdescribedby = (elem.attr( \"aria-describedby\" ) || \"\").split( /\\s+/ ),\n\t\tindex = $.inArray( id, describedby );\n\tif ( index !== -1 ) {\n\t\tdescribedby.splice( index, 1 );\n\t}\n\n\telem.removeData( \"ui-tooltip-id\" );\n\tdescribedby = $.trim( describedby.join( \" \" ) );\n\tif ( describedby ) {\n\t\telem.attr( \"aria-describedby\", describedby );\n\t} else {\n\t\telem.removeAttr( \"aria-describedby\" );\n\t}\n}\n\n$.widget( \"ui.tooltip\", {\n\tversion: \"1.9.2\",\n\toptions: {\n\t\tcontent: function() {\n\t\t\treturn $( this ).attr( \"title\" );\n\t\t},\n\t\thide: true,\n\t\t// Disabled elements have inconsistent behavior across browsers (#8661)\n\t\titems: \"[title]:not([disabled])\",\n\t\tposition: {\n\t\t\tmy: \"left top+15\",\n\t\t\tat: \"left bottom\",\n\t\t\tcollision: \"flipfit flip\"\n\t\t},\n\t\tshow: true,\n\t\ttooltipClass: null,\n\t\ttrack: false,\n\n\t\t// callbacks\n\t\tclose: null,\n\t\topen: null\n\t},\n\n\t_create: function() {\n\t\tthis._on({\n\t\t\tmouseover: \"open\",\n\t\t\tfocusin: \"open\"\n\t\t});\n\n\t\t// IDs of generated tooltips, needed for destroy\n\t\tthis.tooltips = {};\n\t\t// IDs of parent tooltips where we removed the title attribute\n\t\tthis.parents = {};\n\n\t\tif ( this.options.disabled ) {\n\t\t\tthis._disable();\n\t\t}\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tvar that = this;\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis[ value ? \"_disable\" : \"_enable\" ]();\n\t\t\tthis.options[ key ] = value;\n\t\t\t// disable element style changes\n\t\t\treturn;\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\tif ( key === \"content\" ) {\n\t\t\t$.each( this.tooltips, function( id, element ) {\n\t\t\t\tthat._updateContent( element );\n\t\t\t});\n\t\t}\n\t},\n\n\t_disable: function() {\n\t\tvar that = this;\n\n\t\t// close open tooltips\n\t\t$.each( this.tooltips, function( id, element ) {\n\t\t\tvar event = $.Event( \"blur\" );\n\t\t\tevent.target = event.currentTarget = element[0];\n\t\t\tthat.close( event, true );\n\t\t});\n\n\t\t// remove title attributes to prevent native tooltips\n\t\tthis.element.find( this.options.items ).andSelf().each(function() {\n\t\t\tvar element = $( this );\n\t\t\tif ( element.is( \"[title]\" ) ) {\n\t\t\t\telement\n\t\t\t\t\t.data( \"ui-tooltip-title\", element.attr( \"title\" ) )\n\t\t\t\t\t.attr( \"title\", \"\" );\n\t\t\t}\n\t\t});\n\t},\n\n\t_enable: function() {\n\t\t// restore title attributes\n\t\tthis.element.find( this.options.items ).andSelf().each(function() {\n\t\t\tvar element = $( this );\n\t\t\tif ( element.data( \"ui-tooltip-title\" ) ) {\n\t\t\t\telement.attr( \"title\", element.data( \"ui-tooltip-title\" ) );\n\t\t\t}\n\t\t});\n\t},\n\n\topen: function( event ) {\n\t\tvar that = this,\n\t\t\ttarget = $( event ? event.target : this.element )\n\t\t\t\t// we need closest here due to mouseover bubbling,\n\t\t\t\t// but always pointing at the same event target\n\t\t\t\t.closest( this.options.items );\n\n\t\t// No element to show a tooltip for or the tooltip is already open\n\t\tif ( !target.length || target.data( \"ui-tooltip-id\" ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( target.attr( \"title\" ) ) {\n\t\t\ttarget.data( \"ui-tooltip-title\", target.attr( \"title\" ) );\n\t\t}\n\n\t\ttarget.data( \"ui-tooltip-open\", true );\n\n\t\t// kill parent tooltips, custom or native, for hover\n\t\tif ( event && event.type === \"mouseover\" ) {\n\t\t\ttarget.parents().each(function() {\n\t\t\t\tvar parent = $( this ),\n\t\t\t\t\tblurEvent;\n\t\t\t\tif ( parent.data( \"ui-tooltip-open\" ) ) {\n\t\t\t\t\tblurEvent = $.Event( \"blur\" );\n\t\t\t\t\tblurEvent.target = blurEvent.currentTarget = this;\n\t\t\t\t\tthat.close( blurEvent, true );\n\t\t\t\t}\n\t\t\t\tif ( parent.attr( \"title\" ) ) {\n\t\t\t\t\tparent.uniqueId();\n\t\t\t\t\tthat.parents[ this.id ] = {\n\t\t\t\t\t\telement: this,\n\t\t\t\t\t\ttitle: parent.attr( \"title\" )\n\t\t\t\t\t};\n\t\t\t\t\tparent.attr( \"title\", \"\" );\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\n\t\tthis._updateContent( target, event );\n\t},\n\n\t_updateContent: function( target, event ) {\n\t\tvar content,\n\t\t\tcontentOption = this.options.content,\n\t\t\tthat = this,\n\t\t\teventType = event ? event.type : null;\n\n\t\tif ( typeof contentOption === \"string\" ) {\n\t\t\treturn this._open( event, target, contentOption );\n\t\t}\n\n\t\tcontent = contentOption.call( target[0], function( response ) {\n\t\t\t// ignore async response if tooltip was closed already\n\t\t\tif ( !target.data( \"ui-tooltip-open\" ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\t// IE may instantly serve a cached response for ajax requests\n\t\t\t// delay this call to _open so the other call to _open runs first\n\t\t\tthat._delay(function() {\n\t\t\t\t// jQuery creates a special event for focusin when it doesn't\n\t\t\t\t// exist natively. To improve performance, the native event\n\t\t\t\t// object is reused and the type is changed. Therefore, we can't\n\t\t\t\t// rely on the type being correct after the event finished\n\t\t\t\t// bubbling, so we set it back to the previous value. (#8740)\n\t\t\t\tif ( event ) {\n\t\t\t\t\tevent.type = eventType;\n\t\t\t\t}\n\t\t\t\tthis._open( event, target, response );\n\t\t\t});\n\t\t});\n\t\tif ( content ) {\n\t\t\tthis._open( event, target, content );\n\t\t}\n\t},\n\n\t_open: function( event, target, content ) {\n\t\tvar tooltip, events, delayedShow,\n\t\t\tpositionOption = $.extend( {}, this.options.position );\n\n\t\tif ( !content ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Content can be updated multiple times. If the tooltip already\n\t\t// exists, then just update the content and bail.\n\t\ttooltip = this._find( target );\n\t\tif ( tooltip.length ) {\n\t\t\ttooltip.find( \".ui-tooltip-content\" ).html( content );\n\t\t\treturn;\n\t\t}\n\n\t\t// if we have a title, clear it to prevent the native tooltip\n\t\t// we have to check first to avoid defining a title if none exists\n\t\t// (we don't want to cause an element to start matching [title])\n\t\t//\n\t\t// We use removeAttr only for key events, to allow IE to export the correct\n\t\t// accessible attributes. For mouse events, set to empty string to avoid\n\t\t// native tooltip showing up (happens only when removing inside mouseover).\n\t\tif ( target.is( \"[title]\" ) ) {\n\t\t\tif ( event && event.type === \"mouseover\" ) {\n\t\t\t\ttarget.attr( \"title\", \"\" );\n\t\t\t} else {\n\t\t\t\ttarget.removeAttr( \"title\" );\n\t\t\t}\n\t\t}\n\n\t\ttooltip = this._tooltip( target );\n\t\taddDescribedBy( target, tooltip.attr( \"id\" ) );\n\t\ttooltip.find( \".ui-tooltip-content\" ).html( content );\n\n\t\tfunction position( event ) {\n\t\t\tpositionOption.of = event;\n\t\t\tif ( tooltip.is( \":hidden\" ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\ttooltip.position( positionOption );\n\t\t}\n\t\tif ( this.options.track && event && /^mouse/.test( event.type ) ) {\n\t\t\tthis._on( this.document, {\n\t\t\t\tmousemove: position\n\t\t\t});\n\t\t\t// trigger once to override element-relative positioning\n\t\t\tposition( event );\n\t\t} else {\n\t\t\ttooltip.position( $.extend({\n\t\t\t\tof: target\n\t\t\t}, this.options.position ) );\n\t\t}\n\n\t\ttooltip.hide();\n\n\t\tthis._show( tooltip, this.options.show );\n\t\t// Handle tracking tooltips that are shown with a delay (#8644). As soon\n\t\t// as the tooltip is visible, position the tooltip using the most recent\n\t\t// event.\n\t\tif ( this.options.show && this.options.show.delay ) {\n\t\t\tdelayedShow = setInterval(function() {\n\t\t\t\tif ( tooltip.is( \":visible\" ) ) {\n\t\t\t\t\tposition( positionOption.of );\n\t\t\t\t\tclearInterval( delayedShow );\n\t\t\t\t}\n\t\t\t}, $.fx.interval );\n\t\t}\n\n\t\tthis._trigger( \"open\", event, { tooltip: tooltip } );\n\n\t\tevents = {\n\t\t\tkeyup: function( event ) {\n\t\t\t\tif ( event.keyCode === $.ui.keyCode.ESCAPE ) {\n\t\t\t\t\tvar fakeEvent = $.Event(event);\n\t\t\t\t\tfakeEvent.currentTarget = target[0];\n\t\t\t\t\tthis.close( fakeEvent, true );\n\t\t\t\t}\n\t\t\t},\n\t\t\tremove: function() {\n\t\t\t\tthis._removeTooltip( tooltip );\n\t\t\t}\n\t\t};\n\t\tif ( !event || event.type === \"mouseover\" ) {\n\t\t\tevents.mouseleave = \"close\";\n\t\t}\n\t\tif ( !event || event.type === \"focusin\" ) {\n\t\t\tevents.focusout = \"close\";\n\t\t}\n\t\tthis._on( true, target, events );\n\t},\n\n\tclose: function( event ) {\n\t\tvar that = this,\n\t\t\ttarget = $( event ? event.currentTarget : this.element ),\n\t\t\ttooltip = this._find( target );\n\n\t\t// disabling closes the tooltip, so we need to track when we're closing\n\t\t// to avoid an infinite loop in case the tooltip becomes disabled on close\n\t\tif ( this.closing ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// only set title if we had one before (see comment in _open())\n\t\tif ( target.data( \"ui-tooltip-title\" ) ) {\n\t\t\ttarget.attr( \"title\", target.data( \"ui-tooltip-title\" ) );\n\t\t}\n\n\t\tremoveDescribedBy( target );\n\n\t\ttooltip.stop( true );\n\t\tthis._hide( tooltip, this.options.hide, function() {\n\t\t\tthat._removeTooltip( $( this ) );\n\t\t});\n\n\t\ttarget.removeData( \"ui-tooltip-open\" );\n\t\tthis._off( target, \"mouseleave focusout keyup\" );\n\t\t// Remove 'remove' binding only on delegated targets\n\t\tif ( target[0] !== this.element[0] ) {\n\t\t\tthis._off( target, \"remove\" );\n\t\t}\n\t\tthis._off( this.document, \"mousemove\" );\n\n\t\tif ( event && event.type === \"mouseleave\" ) {\n\t\t\t$.each( this.parents, function( id, parent ) {\n\t\t\t\t$( parent.element ).attr( \"title\", parent.title );\n\t\t\t\tdelete that.parents[ id ];\n\t\t\t});\n\t\t}\n\n\t\tthis.closing = true;\n\t\tthis._trigger( \"close\", event, { tooltip: tooltip } );\n\t\tthis.closing = false;\n\t},\n\n\t_tooltip: function( element ) {\n\t\tvar id = \"ui-tooltip-\" + increments++,\n\t\t\ttooltip = $( \"<div>\" )\n\t\t\t\t.attr({\n\t\t\t\t\tid: id,\n\t\t\t\t\trole: \"tooltip\"\n\t\t\t\t})\n\t\t\t\t.addClass( \"ui-tooltip ui-widget ui-corner-all ui-widget-content \" +\n\t\t\t\t\t( this.options.tooltipClass || \"\" ) );\n\t\t$( \"<div>\" )\n\t\t\t.addClass( \"ui-tooltip-content\" )\n\t\t\t.appendTo( tooltip );\n\t\ttooltip.appendTo( this.document[0].body );\n\t\tif ( $.fn.bgiframe ) {\n\t\t\ttooltip.bgiframe();\n\t\t}\n\t\tthis.tooltips[ id ] = element;\n\t\treturn tooltip;\n\t},\n\n\t_find: function( target ) {\n\t\tvar id = target.data( \"ui-tooltip-id\" );\n\t\treturn id ? $( \"#\" + id ) : $();\n\t},\n\n\t_removeTooltip: function( tooltip ) {\n\t\ttooltip.remove();\n\t\tdelete this.tooltips[ tooltip.attr( \"id\" ) ];\n\t},\n\n\t_destroy: function() {\n\t\tvar that = this;\n\n\t\t// close open tooltips\n\t\t$.each( this.tooltips, function( id, element ) {\n\t\t\t// Delegate to close method to handle common cleanup\n\t\t\tvar event = $.Event( \"blur\" );\n\t\t\tevent.target = event.currentTarget = element[0];\n\t\t\tthat.close( event, true );\n\n\t\t\t// Remove immediately; destroying an open tooltip doesn't use the\n\t\t\t// hide animation\n\t\t\t$( \"#\" + id ).remove();\n\n\t\t\t// Restore the title\n\t\t\tif ( element.data( \"ui-tooltip-title\" ) ) {\n\t\t\t\telement.attr( \"title\", element.data( \"ui-tooltip-title\" ) );\n\t\t\t\telement.removeData( \"ui-tooltip-title\" );\n\t\t\t}\n\t\t});\n\t}\n});\n\n}( jQuery ) );\n","jquery/jquery.ba-hashchange.min.js":"/*\n * jQuery hashchange event - v1.3 - 7/21/2010\n * http://benalman.com/projects/jquery-hashchange-plugin/\n * \n * Copyright (c) 2010 \"Cowboy\" Ben Alman\n * Dual licensed under the MIT and GPL licenses.\n * http://benalman.com/about/license/\n */\n(function($,e,b){var c=\"hashchange\",h=document,f,g=$.event.special,i=h.documentMode,d=\"on\"+c in e&&(i===b||i>7);function a(j){j=j||location.href;return\"#\"+j.replace(/^[^#]*#?(.*)$/,\"$1\")}$.fn[c]=function(j){return j?this.bind(c,j):this.trigger(c)};$.fn[c].delay=50;g[c]=$.extend(g[c],{setup:function(){if(d){return false}$(f.start)},teardown:function(){if(d){return false}$(f.stop)}});f=(function(){var j={},p,m=a(),k=function(q){return q},l=k,o=k;j.start=function(){p||n()};j.stop=function(){p&&clearTimeout(p);p=b};function n(){var r=a(),q=o(m);if(r!==m){l(m=r,q);$(e).trigger(c)}else{if(q!==m){location.href=location.href.replace(/#.*/,\"\")+q}}p=setTimeout(n,$.fn[c].delay)}$.browser.msie&&!d&&(function(){var q,r;j.start=function(){if(!q){r=$.fn[c].src;r=r&&r+a();q=$('<iframe tabindex=\"-1\" title=\"empty\"/>').hide().one(\"load\",function(){r||l(a());n()}).attr(\"src\",r||\"javascript:0\").insertAfter(\"body\")[0].contentWindow;h.onpropertychange=function(){try{if(event.propertyName===\"title\"){q.document.title=h.title}}catch(s){}}}};j.stop=k;o=function(){return a(q.location.href)};l=function(v,s){var u=q.document,t=$.fn[c].domain;if(v!==s){u.title=h.title;u.open();t&&u.write('<script>document.domain=\"'+t+'\"<\\/script>');u.close();q.location.hash=v}}})();return j})()})(jQuery,this);","jquery/jquery.details.js":"/*! http://mths.be/details v0.0.6 by @mathias | includes http://mths.be/noselect v1.0.3 */\ndefine([\n    \"jquery\",\n    \"modernizr/modernizr.details\"\n], function($){\n\n    var proto = $.fn,\n        details,\n        // :'(\n        isOpera = Object.prototype.toString.call(window.opera) == '[object Opera]',\n        // Feature test for native `<details>` support\n        isDetailsSupported = $('html').hasClass('details'),\n        toggleOpen = function($details, $detailsSummary, $detailsNotSummary, toggle) {\n            var isOpen = typeof $details.attr('open') == 'string',\n                close = isOpen && toggle || !isOpen && !toggle;\n            if (close) {\n                $details.removeClass('open').prop('open', false).triggerHandler('close.details');\n                $detailsSummary.attr('aria-expanded', false);\n                $detailsNotSummary.hide();\n            } else {\n                $details.addClass('open').prop('open', true).triggerHandler('open.details');\n                $detailsSummary.attr('aria-expanded', true);\n                $detailsNotSummary.show();\n            }\n        };\n\n    /* http://mths.be/noselect v1.0.3 */\n    proto.noSelect = function() {\n\n        // Since the string 'none' is used three times, storing it in a variable gives better results after minification\n        var none = 'none';\n\n        // onselectstart and ondragstart for WebKit & IE\n        // onmousedown for WebKit & Opera\n        return this.bind('selectstart dragstart mousedown', function() {\n            return false;\n        }).css({\n            'MozUserSelect': none,\n            'msUserSelect': none,\n            'webkitUserSelect': none,\n            'userSelect': none\n        });\n\n    };\n\n    // Execute the fallback only if there\u2019s no native `details` support\n    if (isDetailsSupported) {\n        details = proto.details = function() {\n\n            return this.each(function() {\n                var $details = $(this),\n                    $summary = $('summary', $details).first();\n                $summary.attr({\n                    'role': 'button',\n                    'aria-expanded': $details.prop('open')\n                }).on('click.xxx', function() {\n                    // the value of the `open` property is the old value\n                    var close = $details.prop('open');\n                    $summary.attr('aria-expanded', !close);\n                    $details.triggerHandler((close ? 'close' : 'open') + '.details');\n                });\n            });\n\n        };\n\n        details.support = isDetailsSupported;\n\n    } else {\n        details = proto.details = function() {\n\n            // Loop through all `details` elements\n            return this.each(function() {\n\n                // Store a reference to the current `details` element in a variable\n                var $details = $(this),\n                    // Store a reference to the `summary` element of the current `details` element (if any) in a variable\n                    $detailsSummary = $('summary', $details).first(),\n                    // Do the same for the info within the `details` element\n                    $detailsNotSummary = $details.children(':not(summary)'),\n                    // This will be used later to look for direct child text nodes\n                    $detailsNotSummaryContents = $details.contents(':not(summary)');\n\n                // If there is no `summary` in the current `details` element\u2026\n                if (!$detailsSummary.length) {\n                    // \u2026create one with default text\n                    $detailsSummary = $('<summary>').text($.mage.__('Details')).prependTo($details);\n                }\n\n                // Look for direct child text nodes\n                if ($detailsNotSummary.length != $detailsNotSummaryContents.length) {\n                    // Wrap child text nodes in a `span` element\n                    $detailsNotSummaryContents.filter(function() {\n                        // Only keep the node in the collection if it\u2019s a text node containing more than only whitespace\n                        // http://www.whatwg.org/specs/web-apps/current-work/multipage/common-microsyntaxes.html#space-character\n                        return this.nodeType == 3 && /[^ \\t\\n\\f\\r]/.test(this.data);\n                    }).wrap('<span>');\n                    // There are now no direct child text nodes anymore \u2014 they\u2019re wrapped in `span` elements\n                    $detailsNotSummary = $details.children(':not(summary)');\n                }\n\n                // Hide content unless there\u2019s an `open` attribute\n                toggleOpen($details, $detailsSummary, $detailsNotSummary);\n\n                // Add `role=button` and set the `tabindex` of the `summary` element to `0` to make it keyboard accessible\n                $detailsSummary.attr('role', 'button').noSelect().prop('tabIndex', 0).off('click').on('click.details', function() {\n                    // Focus on the `summary` element\n                    $detailsSummary.focus();\n                    // Toggle the `open` and `aria-expanded` attributes and the `open` property of the `details` element and display the additional info\n                    toggleOpen($details, $detailsSummary, $detailsNotSummary, true);\n                }).keyup(function(event) {\n                    if (32 == event.keyCode || (13 == event.keyCode && !isOpera)) {\n                        // Space or Enter is pressed \u2014 trigger the `click` event on the `summary` element\n                        // Opera already seems to trigger the `click` event when Enter is pressed\n                        event.preventDefault();\n                        $detailsSummary.click();\n                    }\n                });\n\n            });\n\n        };\n\n        details.support = isDetailsSupported;\n\n    }\n\n});\n","jquery/jquery.hoverIntent.js":"/**\n * hoverIntent is similar to jQuery's built-in \"hover\" function except that\n * instead of firing the onMouseOver event immediately, hoverIntent checks\n * to see if the user's mouse has slowed down (beneath the sensitivity\n * threshold) before firing the onMouseOver event.\n *\n * hoverIntent r6 // 2011.02.26 // jQuery 1.5.1+\n * <http://cherne.net/brian/resources/jquery.hoverIntent.html>\n *\n * hoverIntent is currently available for use in all personal or commercial\n * projects under both MIT and GPL licenses. This means that you can choose\n * the license that best suits your project, and use it accordingly.\n *\n * // basic usage (just like .hover) receives onMouseOver and onMouseOut functions\n * $(\"ul li\").hoverIntent( showNav , hideNav );\n *\n * // advanced usage receives configuration object only\n * $(\"ul li\").hoverIntent({\n*\tsensitivity: 7, // number = sensitivity threshold (must be 1 or higher)\n*\tinterval: 100,   // number = milliseconds of polling interval\n*\tover: showNav,  // function = onMouseOver callback (required)\n*\ttimeout: 0,   // number = milliseconds delay before onMouseOut function call\n*\tout: hideNav    // function = onMouseOut callback (required)\n* });\n *\n * @param  f  onMouseOver function || An object with configuration options\n * @param  g  onMouseOut function  || Nothing (use configuration options object)\n * @author    Brian Cherne brian(at)cherne(dot)net\n */\n(function ($) {\n    $.fn.hoverIntent = function (f, g) {\n        // default configuration options\n        var cfg = {\n            sensitivity:7,\n            interval:100,\n            timeout:0\n        };\n        // override configuration options with user supplied object\n        cfg = $.extend(cfg, g ? { over:f, out:g } : f);\n\n        // instantiate variables\n        // cX, cY = current X and Y position of mouse, updated by mousemove event\n        // pX, pY = previous X and Y position of mouse, set by mouseover and polling interval\n        var cX, cY, pX, pY;\n\n        // A private function for getting mouse position\n        var track = function (ev) {\n            cX = ev.pageX;\n            cY = ev.pageY;\n        };\n\n        // A private function for comparing current and previous mouse position\n        var compare = function (ev, ob) {\n            ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t);\n            // compare mouse positions to see if they've crossed the threshold\n            if (( Math.abs(pX - cX) + Math.abs(pY - cY) ) < cfg.sensitivity) {\n                $(ob).unbind(\"mousemove\", track);\n                // set hoverIntent state to true (so mouseOut can be called)\n                ob.hoverIntent_s = 1;\n                return cfg.over.apply(ob, [ev]);\n            } else {\n                // set previous coordinates for next time\n                pX = cX;\n                pY = cY;\n                // use self-calling timeout, guarantees intervals are spaced out properly (avoids JavaScript timer bugs)\n                ob.hoverIntent_t = setTimeout(function () {\n                    compare(ev, ob);\n                }, cfg.interval);\n            }\n        };\n\n        // A private function for delaying the mouseOut function\n        var delay = function (ev, ob) {\n            ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t);\n            ob.hoverIntent_s = 0;\n            return cfg.out.apply(ob, [ev]);\n        };\n\n        // A private function for handling mouse 'hovering'\n        var handleHover = function (e) {\n            // copy objects to be passed into t (required for event object to be passed in IE)\n            var ev = jQuery.extend({}, e);\n            var ob = this;\n\n            // cancel hoverIntent timer if it exists\n            if (ob.hoverIntent_t) {\n                ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t);\n            }\n\n            // if e.type == \"mouseenter\"\n            if (e.type == \"mouseenter\") {\n                // set \"previous\" X and Y position based on initial entry point\n                pX = ev.pageX;\n                pY = ev.pageY;\n                // update \"current\" X and Y position based on mousemove\n                $(ob).bind(\"mousemove\", track);\n                // start polling interval (self-calling timeout) to compare mouse coordinates over time\n                if (ob.hoverIntent_s != 1) {\n                    ob.hoverIntent_t = setTimeout(function () {\n                        compare(ev, ob);\n                    }, cfg.interval);\n                }\n\n                // else e.type == \"mouseleave\"\n            } else {\n                // unbind expensive mousemove event\n                $(ob).unbind(\"mousemove\", track);\n                // if hoverIntent state is true, then call the mouseOut function after the specified delay\n                if (ob.hoverIntent_s == 1) {\n                    ob.hoverIntent_t = setTimeout(function () {\n                        delay(ev, ob);\n                    }, cfg.timeout);\n                }\n            }\n        };\n\n        // bind the function to the two event listeners\n        return this.bind('mouseenter', handleHover).bind('mouseleave', handleHover);\n    };\n})(jQuery);","jquery/jquery.validate.js":"/**\n * jQuery Validation Plugin @VERSION\n *\n * http://bassistance.de/jquery-plugins/jquery-plugin-validation/\n * http://docs.jquery.com/Plugins/Validation\n *\n * Copyright (c) 2012 J\u00f6rn Zaefferer\n *\n * Dual licensed under the MIT and GPL licenses:\n *   http://www.opensource.org/licenses/mit-license.php\n *   http://www.gnu.org/licenses/gpl.html\n */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery/jquery.metadata\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function (jQuery) {\n\n(function ($) {\n\n    $.extend($.fn, {\n        // http://docs.jquery.com/Plugins/Validation/validate\n        validate: function (options) {\n\n            // if nothing is selected, return nothing; can't chain anyway\n            if (!this.length) {\n                if (options && options.debug && window.console) {\n                    console.warn(\"nothing selected, can't validate, returning nothing\");\n                }\n                return;\n            }\n\n            // check if a validator for this form was already created\n            var validator = $.data(this[0], 'validator');\n            if (validator) {\n                return validator;\n            }\n\n            // Add novalidate tag if HTML5.\n            this.attr('novalidate', 'novalidate');\n\n            validator = new $.validator(options, this[0]);\n            $.data(this[0], 'validator', validator);\n\n            if (validator.settings.onsubmit) {\n\n                this.validateDelegate(\":submit\", \"click\", function (ev) {\n                    if (validator.settings.submitHandler) {\n                        validator.submitButton = ev.target;\n                    }\n                    // allow suppressing validation by adding a cancel class to the submit button\n                    if ($(ev.target).hasClass('cancel')) {\n                        validator.cancelSubmit = true;\n                    }\n                });\n\n                // validate the form on submit\n                this.submit(function (event) {\n                    if (validator.settings.debug) {\n                        // prevent form submit to be able to see console output\n                        event.preventDefault();\n                    }\n                    function handle() {\n                        var hidden;\n                        if (validator.settings.submitHandler) {\n                            if (validator.submitButton) {\n                                // insert a hidden input as a replacement for the missing submit button\n                                hidden = $(\"<input type='hidden'/>\").attr(\"name\", validator.submitButton.name).val(validator.submitButton.value).appendTo(validator.currentForm);\n                            }\n                            validator.settings.submitHandler.call(validator, validator.currentForm, event);\n                            if (validator.submitButton) {\n                                // and clean up afterwards; thanks to no-block-scope, hidden can be referenced\n                                hidden.remove();\n                            }\n                            return false;\n                        }\n                        return true;\n                    }\n\n                    // prevent submit for invalid forms or custom submit handlers\n                    if (validator.cancelSubmit) {\n                        validator.cancelSubmit = false;\n                        return handle();\n                    }\n                    if (validator.form()) {\n                        if (validator.pendingRequest) {\n                            validator.formSubmitted = true;\n                            return false;\n                        }\n                        return handle();\n                    } else {\n                        validator.focusInvalid();\n                        return false;\n                    }\n                });\n            }\n\n            return validator;\n        },\n        // http://docs.jquery.com/Plugins/Validation/valid\n        valid: function () {\n            if ($(this[0]).is('form')) {\n                return this.validate().form();\n            } else {\n                var valid = true;\n                var validator = $(this[0].form).validate();\n                this.each(function () {\n                    valid &= validator.element(this);\n                });\n                return valid;\n            }\n        },\n        // attributes: space seperated list of attributes to retrieve and remove\n        removeAttrs: function (attributes) {\n            var result = {},\n                $element = this;\n            $.each(attributes.split(/\\s/), function (index, value) {\n                result[value] = $element.attr(value);\n                $element.removeAttr(value);\n            });\n            return result;\n        },\n        // http://docs.jquery.com/Plugins/Validation/rules\n        rules: function (command, argument) {\n            var element = this[0];\n\n            if (command) {\n                var settings = $.data(element.form, 'validator').settings;\n                var staticRules = settings.rules;\n                var existingRules = $.validator.staticRules(element);\n                switch (command) {\n                    case \"add\":\n                        $.extend(existingRules, $.validator.normalizeRule(argument));\n                        staticRules[element.name] = existingRules;\n                        if (argument.messages) {\n                            settings.messages[element.name] = $.extend(settings.messages[element.name], argument.messages);\n                        }\n                        break;\n                    case \"remove\":\n                        if (!argument) {\n                            delete staticRules[element.name];\n                            return existingRules;\n                        }\n                        var filtered = {};\n                        $.each(argument.split(/\\s/), function (index, method) {\n                            filtered[method] = existingRules[method];\n                            delete existingRules[method];\n                        });\n                        return filtered;\n                }\n            }\n\n            var data = $.validator.normalizeRules(\n                $.extend(\n                    {},\n                    $.validator.metadataRules(element),\n                    $.validator.classRules(element),\n                    $.validator.attributeRules(element),\n                    $.validator.staticRules(element)\n                ), element);\n\n            // make sure required is at front\n            if (data.required) {\n                var param = data.required;\n                delete data.required;\n                data = $.extend({required: param}, data);\n            }\n\n            return data;\n        }\n    });\n\n// Custom selectors\n    $.extend($.expr[\":\"], {\n        // http://docs.jquery.com/Plugins/Validation/blank\n        blank: function (a) {\n            return !$.trim(\"\" + a.value);\n        },\n        // http://docs.jquery.com/Plugins/Validation/filled\n        filled: function (a) {\n            return !!$.trim(\"\" + a.value);\n        },\n        // http://docs.jquery.com/Plugins/Validation/unchecked\n        unchecked: function (a) {\n            return !a.checked;\n        }\n    });\n\n// constructor for validator\n    $.validator = function (options, form) {\n        this.settings = $.extend(true, {}, $.validator.defaults, options);\n        this.currentForm = form;\n        this.init();\n    };\n\n    $.validator.format = function (source, params) {\n        if (arguments.length === 1) {\n            return function () {\n                var args = $.makeArray(arguments);\n                args.unshift(source);\n                return $.validator.format.apply(this, args);\n            };\n        }\n        if (arguments.length > 2 && params.constructor !== Array) {\n            params = $.makeArray(arguments).slice(1);\n        }\n        if (params.constructor !== Array) {\n            params = [ params ];\n        }\n        $.each(params, function (i, n) {\n            source = source.replace(new RegExp(\"\\\\{\" + i + \"\\\\}\", \"g\"), n);\n        });\n        return source;\n    };\n\n    $.extend($.validator, {\n\n        defaults: {\n            messages: {},\n            groups: {},\n            rules: {},\n            errorClass: \"error\",\n            validClass: \"valid\",\n            errorElement: \"label\",\n            focusInvalid: true,\n            errorContainer: $([]),\n            errorLabelContainer: $([]),\n            onsubmit: true,\n            ignore: \":hidden\",\n            ignoreTitle: false,\n            onfocusin: function (element, event) {\n                this.lastActive = element;\n\n                // hide error label and remove error class on focus if enabled\n                if (this.settings.focusCleanup && !this.blockFocusCleanup) {\n                    if (this.settings.unhighlight) {\n                        this.settings.unhighlight.call(this, element, this.settings.errorClass, this.settings.validClass);\n                    }\n                    this.addWrapper(this.errorsFor(element)).hide();\n                }\n            },\n            onfocusout: function (element, event) {\n                if (!this.checkable(element) && (element.name in this.submitted || !this.optional(element))) {\n                    this.element(element);\n                }\n            },\n            onkeyup: function (element, event) {\n                if (event.which == 9 && this.elementValue(element) === '') {\n                    return;\n                } else if (element.name in this.submitted || element === this.lastActive) {\n                    this.element(element);\n                }\n            },\n            onclick: function (element, event) {\n                // click on selects, radiobuttons and checkboxes\n                if (element.name in this.submitted) {\n                    this.element(element);\n                }\n                // or option elements, check parent select in that case\n                else if (element.parentNode.name in this.submitted) {\n                    this.element(element.parentNode);\n                }\n            },\n            highlight: function (element, errorClass, validClass) {\n                if (element.type === 'radio') {\n                    this.findByName(element.name).addClass(errorClass).removeClass(validClass);\n                } else {\n                    $(element).addClass(errorClass).removeClass(validClass);\n                }\n            },\n            unhighlight: function (element, errorClass, validClass) {\n                if (element.type === 'radio') {\n                    this.findByName(element.name).removeClass(errorClass).addClass(validClass);\n                } else {\n                    $(element).removeClass(errorClass).addClass(validClass);\n                }\n            }\n        },\n\n        // http://docs.jquery.com/Plugins/Validation/Validator/setDefaults\n        setDefaults: function (settings) {\n            $.extend($.validator.defaults, settings);\n        },\n\n        messages: {\n            required: \"This field is required.\",\n            remote: \"Please fix this field.\",\n            email: \"Please enter a valid email address.\",\n            url: \"Please enter a valid URL.\",\n            date: \"Please enter a valid date.\",\n            dateISO: \"Please enter a valid date (ISO).\",\n            number: \"Please enter a valid number.\",\n            digits: \"Please enter only digits.\",\n            creditcard: \"Please enter a valid credit card number.\",\n            equalTo: \"Please enter the same value again.\",\n            maxlength: $.validator.format(\"Please enter no more than {0} characters.\"),\n            minlength: $.validator.format(\"Please enter at least {0} characters.\"),\n            rangelength: $.validator.format(\"Please enter a value between {0} and {1} characters long.\"),\n            range: $.validator.format(\"Please enter a value between {0} and {1}.\"),\n            max: $.validator.format(\"Please enter a value less than or equal to {0}.\"),\n            min: $.validator.format(\"Please enter a value greater than or equal to {0}.\")\n        },\n\n        autoCreateRanges: false,\n\n        prototype: {\n\n            init: function () {\n                this.labelContainer = $(this.settings.errorLabelContainer);\n                this.errorContext = this.labelContainer.length && this.labelContainer || $(this.currentForm);\n                this.containers = $(this.settings.errorContainer).add(this.settings.errorLabelContainer);\n                this.submitted = {};\n                this.valueCache = {};\n                this.pendingRequest = 0;\n                this.pending = {};\n                this.invalid = {};\n                this.reset();\n\n                var groups = (this.groups = {});\n                $.each(this.settings.groups, function (key, value) {\n                    $.each(value.split(/\\s/), function (index, name) {\n                        groups[name] = key;\n                    });\n                });\n                var rules = this.settings.rules;\n                $.each(rules, function (key, value) {\n                    rules[key] = $.validator.normalizeRule(value);\n                });\n\n                function delegate(event) {\n                    var validator = $.data(this[0].form, \"validator\"),\n                        eventType = \"on\" + event.type.replace(/^validate/, \"\");\n                    if (validator.settings[eventType]) {\n                        validator.settings[eventType].call(validator, this[0], event);\n                    }\n                }\n\n                $(this.currentForm)\n                    .validateDelegate(\":text, [type='password'], [type='file'], select, textarea, \" +\n                    \"[type='number'], [type='search'], input.search, [type='tel'], [type='url'], \" +\n                    \"[type='email'], [type='datetime'], [type='date'], [type='month'], \" +\n                    \"[type='week'], [type='time'], [type='datetime-local'], \" +\n                    \"[type='range'], [type='color'] \",\n                    \"focusin focusout keyup\", delegate)\n                    .validateDelegate(\"[type='radio'], [type='checkbox'], select, option\", \"click\", delegate);\n\n                if (this.settings.invalidHandler) {\n                    $(this.currentForm).bind(\"invalid-form.validate\", this.settings.invalidHandler);\n                }\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/form\n            form: function () {\n                this.checkForm();\n                $.extend(this.submitted, this.errorMap);\n                this.invalid = $.extend({}, this.errorMap);\n                if (!this.valid()) {\n                    $(this.currentForm).triggerHandler(\"invalid-form\", [this]);\n                }\n                this.showErrors();\n                return this.valid();\n            },\n\n            checkForm: function () {\n                this.prepareForm();\n                for (var i = 0, elements = (this.currentElements = this.elements()); elements[i]; i++) {\n                    this.check(elements[i]);\n                }\n                return this.valid();\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/element\n            element: function (element) {\n                element = this.validationTargetFor(this.clean(element));\n                this.lastElement = element;\n                this.prepareElement(element);\n                this.currentElements = $(element);\n                var result = this.check(element) !== false;\n                if (result) {\n                    delete this.invalid[element.name];\n                } else {\n                    this.invalid[element.name] = true;\n                }\n                if (!this.numberOfInvalids()) {\n                    // Hide error containers on last error\n                    this.toHide = this.toHide.add(this.containers);\n                }\n                this.showErrors();\n                return result;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/showErrors\n            showErrors: function (errors) {\n                if (errors) {\n                    // add items to error list and map\n                    $.extend(this.errorMap, errors);\n                    this.errorList = [];\n                    for (var name in errors) {\n                        this.errorList.push({\n                            message: errors[name],\n                            element: this.findByName(name)[0]\n                        });\n                    }\n                    // remove items from success list\n                    this.successList = $.grep(this.successList, function (element) {\n                        return !(element.name in errors);\n                    });\n                }\n                if (this.settings.showErrors) {\n                    this.settings.showErrors.call(this, this.errorMap, this.errorList);\n                } else {\n                    this.defaultShowErrors();\n                }\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/resetForm\n            resetForm: function () {\n                if ($.fn.resetForm) {\n                    $(this.currentForm).resetForm();\n                }\n                this.submitted = {};\n                this.lastElement = null;\n                this.prepareForm();\n                this.hideErrors();\n                this.elements().removeClass(this.settings.errorClass).removeData(\"previousValue\");\n            },\n\n            numberOfInvalids: function () {\n                return this.objectLength(this.invalid);\n            },\n\n            objectLength: function (obj) {\n                var count = 0;\n                for (var i in obj) {\n                    count++;\n                }\n                return count;\n            },\n\n            hideErrors: function () {\n                this.addWrapper(this.toHide).hide();\n            },\n\n            valid: function () {\n                return this.size() === 0;\n            },\n\n            size: function () {\n                return this.errorList.length;\n            },\n\n            focusInvalid: function () {\n                if (this.settings.focusInvalid) {\n                    try {\n                        $(this.findLastActive() || this.errorList.length && this.errorList[0].element || [])\n                            .filter(\":visible\")\n                            .focus()\n                            // manually trigger focusin event; without it, focusin handler isn't called, findLastActive won't have anything to find\n                            .trigger(\"focusin\");\n                    } catch (e) {\n                        // ignore IE throwing errors when focusing hidden elements\n                    }\n                }\n            },\n\n            findLastActive: function () {\n                var lastActive = this.lastActive;\n                return lastActive && $.grep(this.errorList,function (n) {\n                    return n.element.name === lastActive.name;\n                }).length === 1 && lastActive;\n            },\n\n            elements: function () {\n                var validator = this,\n                    rulesCache = {};\n\n                // select all valid inputs inside the form (no submit or reset buttons)\n                return $(this.currentForm)\n                    .find(\"input, select, textarea\")\n                    .not(\":submit, :reset, :image, [disabled]\")\n                    .not(this.settings.ignore)\n                    .filter(function () {\n                        if (!this.name && validator.settings.debug && window.console) {\n                            console.error(\"%o has no name assigned\", this);\n                        }\n\n                        // select only the first element for each name, and only those with rules specified\n                        if (this.name in rulesCache || !validator.objectLength($(this).rules())) {\n                            return false;\n                        }\n\n                        rulesCache[this.name] = true;\n                        return true;\n                    });\n            },\n\n            clean: function (selector) {\n                return $(selector)[0];\n            },\n\n            errors: function () {\n                var errorClass = this.settings.errorClass.replace(' ', '.');\n                return $(this.settings.errorElement + \".\" + errorClass, this.errorContext);\n            },\n\n            reset: function () {\n                this.successList = [];\n                this.errorList = [];\n                this.errorMap = {};\n                this.toShow = $([]);\n                this.toHide = $([]);\n                this.currentElements = $([]);\n            },\n\n            prepareForm: function () {\n                this.reset();\n                this.toHide = this.errors().add(this.containers);\n            },\n\n            prepareElement: function (element) {\n                this.reset();\n                this.toHide = this.errorsFor(element);\n            },\n\n            elementValue: function (element) {\n                var type = $(element).attr('type'),\n                    val = $(element).val();\n\n                if (type === 'radio' || type === 'checkbox') {\n                    return $('input[name=\"' + $(element).attr('name') + '\"]:checked').val();\n                }\n\n                if (typeof val === 'string') {\n                    return val.replace(/\\r/g, \"\");\n                }\n                return val;\n            },\n\n            check: function (element) {\n                element = this.validationTargetFor(this.clean(element));\n\n                var rules = $(element).rules();\n                var dependencyMismatch = false;\n                var val = this.elementValue(element);\n                var result;\n\n                for (var method in rules) {\n                    var rule = { method: method, parameters: rules[method] };\n                    try {\n\n                        result = $.validator.methods[method].call(this, val, element, rule.parameters);\n\n                        // if a method indicates that the field is optional and therefore valid,\n                        // don't mark it as valid when there are no other rules\n                        if (result === \"dependency-mismatch\") {\n                            dependencyMismatch = true;\n                            continue;\n                        }\n                        dependencyMismatch = false;\n\n                        if (result === \"pending\") {\n                            this.toHide = this.toHide.not(this.errorsFor(element));\n                            return;\n                        }\n\n                        if (!result) {\n                            this.formatAndAdd(element, rule);\n                            return false;\n                        }\n                    } catch (e) {\n                        if (this.settings.debug && window.console) {\n                            console.log(\"exception occurred when checking element \" + element.id + \", check the '\" + rule.method + \"' method\", e);\n                        }\n                        throw e;\n                    }\n                }\n                if (dependencyMismatch) {\n                    return;\n                }\n                if (this.objectLength(rules)) {\n                    this.successList.push(element);\n                }\n                return true;\n            },\n\n            // return the custom message for the given element and validation method\n            // specified in the element's \"messages\" metadata\n            customMetaMessage: function (element, method) {\n                if (!$.metadata) {\n                    return;\n                }\n                var meta = this.settings.meta ? $(element).metadata()[this.settings.meta] : $(element).metadata();\n                return meta && meta.messages && meta.messages[method];\n            },\n\n            // return the custom message for the given element and validation method\n            // specified in the element's HTML5 data attribute\n            customDataMessage: function (element, method) {\n                return $(element).data('msg-' + method.toLowerCase()) || (element.attributes && $(element).attr('data-msg-' + method.toLowerCase()));\n            },\n\n            // return the custom message for the given element name and validation method\n            customMessage: function (name, method) {\n                var m = this.settings.messages[name];\n                return m && (m.constructor === String ? m : m[method]);\n            },\n\n            // return the first defined argument, allowing empty strings\n            findDefined: function () {\n                for (var i = 0; i < arguments.length; i++) {\n                    if (arguments[i] !== undefined) {\n                        return arguments[i];\n                    }\n                }\n                return undefined;\n            },\n\n            defaultMessage: function (element, method) {\n                var noMessage = $.mage.__(\"Warning: No message defined for %s\");\n                return this.findDefined(\n                    this.customMessage(element.name, method),\n                    this.customDataMessage(element, method),\n                    this.customMetaMessage(element, method),\n                    // title is never undefined, so handle empty string as undefined\n                    !this.settings.ignoreTitle && element.title || undefined,\n                    $.validator.messages[method],\n                    \"<strong>\" + noMessage.replace('%s', element.name) + \"</strong>\"\n                );\n            },\n\n            formatAndAdd: function (element, rule) {\n                var message = this.defaultMessage(element, rule.method),\n                    theregex = /\\$?\\{(\\d+)\\}/g;\n                if (typeof message === \"function\") {\n                    message = message.call(this, rule.parameters, element);\n                } else if (theregex.test(message)) {\n                    message = $.validator.format(message.replace(theregex, '{$1}'), rule.parameters);\n                }\n                this.errorList.push({\n                    message: message,\n                    element: element\n                });\n\n                this.errorMap[element.name] = message;\n                this.submitted[element.name] = message;\n            },\n\n            addWrapper: function (toToggle) {\n                if (this.settings.wrapper) {\n                    toToggle = toToggle.add(toToggle.parent(this.settings.wrapper));\n                }\n                return toToggle;\n            },\n\n            defaultShowErrors: function () {\n                var i, elements;\n                for (i = 0; this.errorList[i]; i++) {\n                    var error = this.errorList[i];\n                    if (this.settings.highlight) {\n                        this.settings.highlight.call(this, error.element, this.settings.errorClass, this.settings.validClass);\n                    }\n                    this.showLabel(error.element, error.message);\n                }\n                if (this.errorList.length) {\n                    this.toShow = this.toShow.add(this.containers);\n                }\n                if (this.settings.success) {\n                    for (i = 0; this.successList[i]; i++) {\n                        this.showLabel(this.successList[i]);\n                    }\n                }\n                if (this.settings.unhighlight) {\n                    for (i = 0, elements = this.validElements(); elements[i]; i++) {\n                        this.settings.unhighlight.call(this, elements[i], this.settings.errorClass, this.settings.validClass);\n                    }\n                }\n                this.toHide = this.toHide.not(this.toShow);\n                this.hideErrors();\n                this.addWrapper(this.toShow).show();\n            },\n\n            validElements: function () {\n                return this.currentElements.not(this.invalidElements());\n            },\n\n            invalidElements: function () {\n                return $(this.errorList).map(function () {\n                    return this.element;\n                });\n            },\n\n            showLabel: function (element, message) {\n                var label = this.errorsFor(element);\n                if (label.length) {\n                    // refresh error/success class\n                    label.removeClass(this.settings.validClass).addClass(this.settings.errorClass);\n\n                    // check if we have a generated label, replace the message then\n                    if (label.attr(\"generated\")) {\n                        label.hide().html(message);\n                    }\n                } else {\n                    // create label\n                    label = $(\"<\" + this.settings.errorElement + \"/>\")\n                        .attr({\"for\": this.idOrName(element), generated: true})\n                        .addClass(this.settings.errorClass)\n                        .html(message || \"\");\n                    if (this.settings.wrapper) {\n                        // make sure the element is visible, even in IE\n                        // actually showing the wrapped element is handled elsewhere\n                        label = label.hide().show().wrap(\"<\" + this.settings.wrapper + \"/>\").parent();\n                    }\n                    if (!this.labelContainer.append(label).length) {\n                        if (this.settings.errorPlacement) {\n                            this.settings.errorPlacement(label, $(element));\n                        } else {\n                            label.insertAfter(element);\n                        }\n                    }\n                }\n                if (!message && this.settings.success) {\n                    label.text(\"\");\n                    if (typeof this.settings.success === \"string\") {\n                        label.addClass(this.settings.success);\n                    } else {\n                        this.settings.success(label, element);\n                    }\n                }\n                this.toShow = this.toShow.add(label);\n            },\n\n            errorsFor: function (element) {\n                var name = this.idOrName(element);\n                return this.errors().filter(function () {\n                    return $(this).attr('for') === name;\n                });\n            },\n\n            idOrName: function (element) {\n                return this.groups[element.name] || (this.checkable(element) ? element.name : element.id || element.name);\n            },\n\n            validationTargetFor: function (element) {\n                // if radio/checkbox, validate first element in group instead\n                if (this.checkable(element)) {\n                    element = this.findByName(element.name).not(this.settings.ignore)[0];\n                }\n                return element;\n            },\n\n            checkable: function (element) {\n                return (/radio|checkbox/i).test(element.type);\n            },\n\n            findByName: function (name) {\n                return $(this.currentForm).find('[name=\"' + name + '\"]');\n            },\n\n            getLength: function (value, element) {\n                switch (element.nodeName.toLowerCase()) {\n                    case 'select':\n                        return $(\"option:selected\", element).length;\n                    case 'input':\n                        if (this.checkable(element)) {\n                            return this.findByName(element.name).filter(':checked').length;\n                        }\n                }\n                return value.length;\n            },\n\n            depend: function (param, element) {\n                return this.dependTypes[typeof param] ? this.dependTypes[typeof param](param, element) : true;\n            },\n\n            dependTypes: {\n                \"boolean\": function (param, element) {\n                    return param;\n                },\n                \"string\": function (param, element) {\n                    return !!$(param, element.form).length;\n                },\n                \"function\": function (param, element) {\n                    return param(element);\n                }\n            },\n\n            optional: function (element) {\n                var val = this.elementValue(element);\n                return !$.validator.methods.required.call(this, val, element) && \"dependency-mismatch\";\n            },\n\n            startRequest: function (element) {\n                if (!this.pending[element.name]) {\n                    this.pendingRequest++;\n                    this.pending[element.name] = true;\n                }\n            },\n\n            stopRequest: function (element, valid) {\n                this.pendingRequest--;\n                // sometimes synchronization fails, make sure pendingRequest is never < 0\n                if (this.pendingRequest < 0) {\n                    this.pendingRequest = 0;\n                }\n                delete this.pending[element.name];\n                if (valid && this.pendingRequest === 0 && this.formSubmitted && this.form()) {\n                    $(this.currentForm).submit();\n                    this.formSubmitted = false;\n                } else if (!valid && this.pendingRequest === 0 && this.formSubmitted) {\n                    $(this.currentForm).triggerHandler(\"invalid-form\", [this]);\n                    this.formSubmitted = false;\n                }\n            },\n\n            previousValue: function (element) {\n                return $.data(element, \"previousValue\") || $.data(element, \"previousValue\", {\n                    old: null,\n                    valid: true,\n                    message: this.defaultMessage(element, \"remote\")\n                });\n            }\n\n        },\n\n        classRuleSettings: {\n            required: {required: true},\n            email: {email: true},\n            url: {url: true},\n            date: {date: true},\n            dateISO: {dateISO: true},\n            number: {number: true},\n            digits: {digits: true},\n            creditcard: {creditcard: true}\n        },\n\n        addClassRules: function (className, rules) {\n            if (className.constructor === String) {\n                this.classRuleSettings[className] = rules;\n            } else {\n                $.extend(this.classRuleSettings, className);\n            }\n        },\n\n        classRules: function (element) {\n            var rules = {};\n            var classes = $(element).attr('class');\n            if (classes) {\n                $.each(classes.split(' '), function () {\n                    if (this in $.validator.classRuleSettings) {\n                        $.extend(rules, $.validator.classRuleSettings[this]);\n                    }\n                });\n            }\n            return rules;\n        },\n\n        attributeRules: function (element) {\n            var rules = {};\n            var $element = $(element);\n\n            for (var method in $.validator.methods) {\n                var value;\n\n                // support for <input required> in both html5 and older browsers\n                if (method === 'required') {\n                    value = $element.get(0).getAttribute(method);\n                    // Some browsers return an empty string for the required attribute\n                    // and non-HTML5 browsers might have required=\"\" markup\n                    if (value === \"\") {\n                        value = true;\n                    }\n                    // force non-HTML5 browsers to return bool\n                    value = !!value;\n                } else {\n                    value = $element.attr(method);\n                }\n\n                if (value) {\n                    rules[method] = value;\n                } else if ($element[0].getAttribute(\"type\") === method) {\n                    rules[method] = true;\n                }\n            }\n\n            // maxlength may be returned as -1, 2147483647 (IE) and 524288 (safari) for text inputs\n            if (rules.maxlength && /-1|2147483647|524288/.test(rules.maxlength)) {\n                delete rules.maxlength;\n            }\n\n            return rules;\n        },\n\n        metadataRules: function (element) {\n            if (!$.metadata) {\n                return {};\n            }\n\n            var meta = $.data(element.form, 'validator').settings.meta;\n            return meta ?\n                $(element).metadata()[meta] :\n                $(element).metadata();\n        },\n\n        staticRules: function (element) {\n            var rules = {};\n            var validator = $.data(element.form, 'validator');\n            if (validator.settings.rules) {\n                rules = $.validator.normalizeRule(validator.settings.rules[element.name]) || {};\n            }\n            return rules;\n        },\n\n        normalizeRules: function (rules, element) {\n            // handle dependency check\n            $.each(rules, function (prop, val) {\n                // ignore rule when param is explicitly false, eg. required:false\n                if (val === false) {\n                    delete rules[prop];\n                    return;\n                }\n                if (val.param || val.depends) {\n                    var keepRule = true;\n                    switch (typeof val.depends) {\n                        case \"string\":\n                            keepRule = !!$(val.depends, element.form).length;\n                            break;\n                        case \"function\":\n                            keepRule = val.depends.call(element, element);\n                            break;\n                    }\n                    if (keepRule) {\n                        rules[prop] = val.param !== undefined ? val.param : true;\n                    } else {\n                        delete rules[prop];\n                    }\n                }\n            });\n\n            // evaluate parameters\n            $.each(rules, function (rule, parameter) {\n                rules[rule] = $.isFunction(parameter) ? parameter(element) : parameter;\n            });\n\n            // clean number parameters\n            $.each(['minlength', 'maxlength', 'min', 'max'], function () {\n                if (rules[this]) {\n                    rules[this] = Number(rules[this]);\n                }\n            });\n            $.each(['rangelength', 'range'], function () {\n                if (rules[this]) {\n                    rules[this] = [Number(rules[this][0]), Number(rules[this][1])];\n                }\n            });\n\n            if ($.validator.autoCreateRanges) {\n                // auto-create ranges\n                if (rules.min && rules.max) {\n                    rules.range = [rules.min, rules.max];\n                    delete rules.min;\n                    delete rules.max;\n                }\n                if (rules.minlength && rules.maxlength) {\n                    rules.rangelength = [rules.minlength, rules.maxlength];\n                    delete rules.minlength;\n                    delete rules.maxlength;\n                }\n            }\n\n            // To support custom messages in metadata ignore rule methods titled \"messages\"\n            if (rules.messages) {\n                delete rules.messages;\n            }\n\n            return rules;\n        },\n\n        // Converts a simple string to a {string: true} rule, e.g., \"required\" to {required:true}\n        normalizeRule: function (data) {\n            if (typeof data === \"string\") {\n                var transformed = {};\n                $.each(data.split(/\\s/), function () {\n                    transformed[this] = true;\n                });\n                data = transformed;\n            }\n            return data;\n        },\n\n        // http://docs.jquery.com/Plugins/Validation/Validator/addMethod\n        addMethod: function (name, method, message) {\n            $.validator.methods[name] = method;\n            $.validator.messages[name] = message !== undefined ? message : $.validator.messages[name];\n            if (method.length < 3) {\n                $.validator.addClassRules(name, $.validator.normalizeRule(name));\n            }\n        },\n\n        methods: {\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/required\n            required: function (value, element, param) {\n                // check if dependency is met\n                if (!this.depend(param, element)) {\n                    return \"dependency-mismatch\";\n                }\n                if (element.nodeName.toLowerCase() === \"select\") {\n                    // could be an array for select-multiple or a string, both are fine this way\n                    var val = $(element).val();\n                    return val && val.length > 0;\n                }\n                if (this.checkable(element)) {\n                    return this.getLength(value, element) > 0;\n                }\n                return $.trim(value).length > 0;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/remote\n            remote: function (value, element, param) {\n                if (this.optional(element)) {\n                    return \"dependency-mismatch\";\n                }\n\n                var previous = this.previousValue(element);\n                if (!this.settings.messages[element.name]) {\n                    this.settings.messages[element.name] = {};\n                }\n                previous.originalMessage = this.settings.messages[element.name].remote;\n                this.settings.messages[element.name].remote = previous.message;\n\n                param = typeof param === \"string\" && {url: param} || param;\n\n                if (this.pending[element.name]) {\n                    return \"pending\";\n                }\n                if (previous.old === value) {\n                    return previous.valid;\n                }\n\n                previous.old = value;\n                var validator = this;\n                this.startRequest(element);\n                var data = {};\n                data[element.name] = value;\n                $.ajax($.extend(true, {\n                    url: param,\n                    mode: \"abort\",\n                    port: \"validate\" + element.name,\n                    dataType: \"json\",\n                    data: data,\n                    success: function (response) {\n                        validator.settings.messages[element.name].remote = previous.originalMessage;\n                        var valid = response === true || response === \"true\";\n                        if (valid) {\n                            var submitted = validator.formSubmitted;\n                            validator.prepareElement(element);\n                            validator.formSubmitted = submitted;\n                            validator.successList.push(element);\n                            delete validator.invalid[element.name];\n                            validator.showErrors();\n                        } else {\n                            var errors = {};\n                            var message = response || validator.defaultMessage(element, \"remote\");\n                            errors[element.name] = previous.message = $.isFunction(message) ? message(value) : message;\n                            validator.invalid[element.name] = true;\n                            validator.showErrors(errors);\n                        }\n                        previous.valid = valid;\n                        validator.stopRequest(element, valid);\n                    }\n                }, param));\n                return \"pending\";\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/minlength\n            minlength: function (value, element, param) {\n                var length = $.isArray(value) ? value.length : this.getLength($.trim(value), element);\n                return this.optional(element) || length >= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/maxlength\n            maxlength: function (value, element, param) {\n                var length = $.isArray(value) ? value.length : this.getLength($.trim(value), element);\n                return this.optional(element) || length <= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/rangelength\n            rangelength: function (value, element, param) {\n                var length = $.isArray(value) ? value.length : this.getLength($.trim(value), element);\n                return this.optional(element) || ( length >= param[0] && length <= param[1] );\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/min\n            min: function (value, element, param) {\n                return this.optional(element) || value >= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/max\n            max: function (value, element, param) {\n                return this.optional(element) || value <= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/range\n            range: function (value, element, param) {\n                return this.optional(element) || ( value >= param[0] && value <= param[1] );\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/email\n            email: function (value, element) {\n                // contributed by Scott Gonzalez: http://projects.scottsplayground.com/email_address_validation/\n                return this.optional(element) || /^((([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\x22)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\x22)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)+(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))$/i.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/url\n            url: function (value, element) {\n                // contributed by Scott Gonzalez: http://projects.scottsplayground.com/iri/\n                return this.optional(element) || /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)+(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/date\n            date: function (value, element) {\n                return this.optional(element) || !/Invalid|NaN/.test(new Date(value));\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/dateISO\n            dateISO: function (value, element) {\n                return this.optional(element) || /^\\d{4}[\\/\\-]\\d{1,2}[\\/\\-]\\d{1,2}$/.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/number\n            number: function (value, element) {\n                return this.optional(element) || /^-?(?:\\d+|\\d{1,3}(?:,\\d{3})+)?(?:\\.\\d+)?$/.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/digits\n            digits: function (value, element) {\n                return this.optional(element) || /^\\d+$/.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/creditcard\n            // based on http://en.wikipedia.org/wiki/Luhn\n            creditcard: function (value, element) {\n                if (this.optional(element)) {\n                    return \"dependency-mismatch\";\n                }\n                // accept only spaces, digits and dashes\n                if (/[^0-9 \\-]+/.test(value)) {\n                    return false;\n                }\n                var nCheck = 0,\n                    nDigit = 0,\n                    bEven = false;\n\n                value = value.replace(/\\D/g, \"\");\n\n                for (var n = value.length - 1; n >= 0; n--) {\n                    var cDigit = value.charAt(n);\n                    nDigit = parseInt(cDigit, 10);\n                    if (bEven) {\n                        if ((nDigit *= 2) > 9) {\n                            nDigit -= 9;\n                        }\n                    }\n                    nCheck += nDigit;\n                    bEven = !bEven;\n                }\n\n                return (nCheck % 10) === 0;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/equalTo\n            equalTo: function (value, element, param) {\n                // bind to the blur event of the target in order to revalidate whenever the target field is updated\n                // TODO find a way to bind the event just once, avoiding the unbind-rebind overhead\n                var target = $(param);\n                if (this.settings.onfocusout) {\n                    target.unbind(\".validate-equalTo\").bind(\"blur.validate-equalTo\", function () {\n                        $(element).valid();\n                    });\n                }\n                return value === target.val();\n            }\n\n        }\n\n    });\n\n// deprecated, use $.validator.format instead\n    $.format = $.validator.format;\n\n}(jQuery));\n\n// ajax mode: abort\n// usage: $.ajax({ mode: \"abort\"[, port: \"uniqueport\"]});\n// if mode:\"abort\" is used, the previous request on that port (port can be undefined) is aborted via XMLHttpRequest.abort()\n(function ($) {\n    var pendingRequests = {};\n    // Use a prefilter if available (1.5+)\n    if ($.ajaxPrefilter) {\n        $.ajaxPrefilter(function (settings, _, xhr) {\n            var port = settings.port;\n            if (settings.mode === \"abort\") {\n                if (pendingRequests[port]) {\n                    pendingRequests[port].abort();\n                }\n                pendingRequests[port] = xhr;\n            }\n        });\n    } else {\n        // Proxy ajax\n        var ajax = $.ajax;\n        $.ajax = function (settings) {\n            var mode = ( \"mode\" in settings ? settings : $.ajaxSettings ).mode,\n                port = ( \"port\" in settings ? settings : $.ajaxSettings ).port;\n            if (mode === \"abort\") {\n                if (pendingRequests[port]) {\n                    pendingRequests[port].abort();\n                }\n                return (pendingRequests[port] = ajax.apply(this, arguments));\n            }\n            return ajax.apply(this, arguments);\n        };\n    }\n}(jQuery));\n\n// provides cross-browser focusin and focusout events\n// IE has native support, in other browsers, use event caputuring (neither bubbles)\n\n// provides delegate(type: String, delegate: Selector, handler: Callback) plugin for easier event delegation\n// handler is only called when $(event.target).is(delegate), in the scope of the jquery-object for event.target\n(function ($) {\n    // only implement if not provided by jQuery core (since 1.4)\n    // TODO verify if jQuery 1.4's implementation is compatible with older jQuery special-event APIs\n    if (!jQuery.event.special.focusin && !jQuery.event.special.focusout && document.addEventListener) {\n        $.each({\n            focus: 'focusin',\n            blur: 'focusout'\n        }, function (original, fix) {\n            $.event.special[fix] = {\n                setup: function () {\n                    this.addEventListener(original, handler, true);\n                },\n                teardown: function () {\n                    this.removeEventListener(original, handler, true);\n                },\n                handler: function (e) {\n                    var args = arguments;\n                    args[0] = $.event.fix(e);\n                    args[0].type = fix;\n                    return $.event.handle.apply(this, args);\n                }\n            };\n            function handler(e) {\n                e = $.event.fix(e);\n                e.type = fix;\n                return $.event.handle.call(this, e);\n            }\n        });\n    }\n    $.extend($.fn, {\n        validateDelegate: function (delegate, type, handler) {\n            return this.bind(type, function (event) {\n                var target = $(event.target);\n                if (target.is(delegate)) {\n                    return handler.apply(target, arguments);\n                }\n            });\n        }\n    });\n}(jQuery));\n\n}));","jquery/colorpicker/js/colorpicker.js":"/**\n *\n * Color picker\n * Author: Stefan Petre www.eyecon.ro\n * \n * Dual licensed under the MIT and GPL licenses\n * \n */\n\ndefine([\n\t\"jquery\",\n], function ($) {\n\tvar ColorPicker = function () {\n\t\tvar\n\t\t\tids = {},\n\t\t\tinAction,\n\t\t\tcharMin = 65,\n\t\t\tvisible,\n\t\t\ttpl = '<div class=\"colorpicker\"><div class=\"colorpicker_color\"><div><div></div></div></div><div class=\"colorpicker_hue\"><div></div></div><div class=\"colorpicker_new_color\"></div><div class=\"colorpicker_current_color\"></div><div class=\"colorpicker_hex\"><input type=\"text\" maxlength=\"6\" size=\"6\" /></div><div class=\"colorpicker_rgb_r colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_rgb_g colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_rgb_b colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_h colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_s colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_b colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_submit\"></div></div>',\n\t\t\tdefaults = {\n\t\t\t\teventName: 'click',\n\t\t\t\tonShow: function () {},\n\t\t\t\tonBeforeShow: function(){},\n\t\t\t\tonHide: function () {},\n\t\t\t\tonChange: function () {},\n\t\t\t\tonSubmit: function () {},\n\t\t\t\tcolor: 'ff0000',\n\t\t\t\tlivePreview: true,\n\t\t\t\tflat: false\n\t\t\t},\n\t\t\tfillRGBFields = function  (hsb, cal) {\n\t\t\t\tvar rgb = HSBToRGB(hsb);\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(1).val(rgb.r).end()\n\t\t\t\t\t.eq(2).val(rgb.g).end()\n\t\t\t\t\t.eq(3).val(rgb.b).end();\n\t\t\t},\n\t\t\tfillHSBFields = function  (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(4).val(hsb.h).end()\n\t\t\t\t\t.eq(5).val(hsb.s).end()\n\t\t\t\t\t.eq(6).val(hsb.b).end();\n\t\t\t},\n\t\t\tfillHexFields = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(0).val(HSBToHex(hsb)).end();\n\t\t\t},\n\t\t\tsetSelector = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').selector.css('backgroundColor', '#' + HSBToHex({h: hsb.h, s: 100, b: 100}));\n\t\t\t\t$(cal).data('colorpicker').selectorIndic.css({\n\t\t\t\t\tleft: parseInt(150 * hsb.s/100, 10),\n\t\t\t\t\ttop: parseInt(150 * (100-hsb.b)/100, 10)\n\t\t\t\t});\n\t\t\t},\n\t\t\tsetHue = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').hue.css('top', parseInt(150 - 150 * hsb.h/360, 10));\n\t\t\t},\n\t\t\tsetCurrentColor = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').currentColor.css('backgroundColor', '#' + HSBToHex(hsb));\n\t\t\t},\n\t\t\tsetNewColor = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').newColor.css('backgroundColor', '#' + HSBToHex(hsb));\n\t\t\t},\n\t\t\tkeyDown = function (ev) {\n\t\t\t\tvar pressedKey = ev.charCode || ev.keyCode || -1;\n\t\t\t\tif ((pressedKey > charMin && pressedKey <= 90) || pressedKey == 32) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tvar cal = $(this).parent().parent();\n\t\t\t\tif (cal.data('colorpicker').livePreview === true) {\n\t\t\t\t\tchange.apply(this);\n\t\t\t\t}\n\t\t\t},\n\t\t\tchange = function (ev) {\n\t\t\t\tvar cal = $(this).parent().parent(), col;\n\t\t\t\tif (this.parentNode.className.indexOf('_hex') > 0) {\n\t\t\t\t\tcal.data('colorpicker').color = col = HexToHSB(fixHex(this.value));\n\t\t\t\t} else if (this.parentNode.className.indexOf('_hsb') > 0) {\n\t\t\t\t\tcal.data('colorpicker').color = col = fixHSB({\n\t\t\t\t\t\th: parseInt(cal.data('colorpicker').fields.eq(4).val(), 10),\n\t\t\t\t\t\ts: parseInt(cal.data('colorpicker').fields.eq(5).val(), 10),\n\t\t\t\t\t\tb: parseInt(cal.data('colorpicker').fields.eq(6).val(), 10)\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\tcal.data('colorpicker').color = col = RGBToHSB(fixRGB({\n\t\t\t\t\t\tr: parseInt(cal.data('colorpicker').fields.eq(1).val(), 10),\n\t\t\t\t\t\tg: parseInt(cal.data('colorpicker').fields.eq(2).val(), 10),\n\t\t\t\t\t\tb: parseInt(cal.data('colorpicker').fields.eq(3).val(), 10)\n\t\t\t\t\t}));\n\t\t\t\t}\n\t\t\t\tif (ev) {\n\t\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\t}\n\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t\tcal.data('colorpicker').onChange.apply(cal, [col, HSBToHex(col), HSBToRGB(col)]);\n\t\t\t},\n\t\t\tblur = function (ev) {\n\t\t\t\tvar cal = $(this).parent().parent();\n\t\t\t\tcal.data('colorpicker').fields.parent().removeClass('colorpicker_focus');\n\t\t\t},\n\t\t\tfocus = function () {\n\t\t\t\tcharMin = this.parentNode.className.indexOf('_hex') > 0 ? 70 : 65;\n\t\t\t\t$(this).parent().parent().data('colorpicker').fields.parent().removeClass('colorpicker_focus');\n\t\t\t\t$(this).parent().addClass('colorpicker_focus');\n\t\t\t},\n\t\t\tdownIncrement = function (ev) {\n\t\t\t\tvar field = $(this).parent().find('input').focus();\n\t\t\t\tvar current = {\n\t\t\t\t\tel: $(this).parent().addClass('colorpicker_slider'),\n\t\t\t\t\tmax: this.parentNode.className.indexOf('_hsb_h') > 0 ? 360 : (this.parentNode.className.indexOf('_hsb') > 0 ? 100 : 255),\n\t\t\t\t\ty: ev.pageY,\n\t\t\t\t\tfield: field,\n\t\t\t\t\tval: parseInt(field.val(), 10),\n\t\t\t\t\tpreview: $(this).parent().parent().data('colorpicker').livePreview\t\t\t\t\t\n\t\t\t\t};\n\t\t\t\t$(document).bind('mouseup', current, upIncrement);\n\t\t\t\t$(document).bind('mousemove', current, moveIncrement);\n\t\t\t},\n\t\t\tmoveIncrement = function (ev) {\n\t\t\t\tev.data.field.val(Math.max(0, Math.min(ev.data.max, parseInt(ev.data.val + ev.pageY - ev.data.y, 10))));\n\t\t\t\tif (ev.data.preview) {\n\t\t\t\t\tchange.apply(ev.data.field.get(0), [true]);\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupIncrement = function (ev) {\n\t\t\t\tchange.apply(ev.data.field.get(0), [true]);\n\t\t\t\tev.data.el.removeClass('colorpicker_slider').find('input').focus();\n\t\t\t\t$(document).unbind('mouseup', upIncrement);\n\t\t\t\t$(document).unbind('mousemove', moveIncrement);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tdownHue = function (ev) {\n\t\t\t\tvar current = {\n\t\t\t\t\tcal: $(this).parent(),\n\t\t\t\t\ty: $(this).offset().top\n\t\t\t\t};\n\t\t\t\tcurrent.preview = current.cal.data('colorpicker').livePreview;\n\t\t\t\t$(document).bind('mouseup', current, upHue);\n\t\t\t\t$(document).bind('mousemove', current, moveHue);\n\t\t\t},\n\t\t\tmoveHue = function (ev) {\n\t\t\t\tchange.apply(\n\t\t\t\t\tev.data.cal.data('colorpicker')\n\t\t\t\t\t\t.fields\n\t\t\t\t\t\t.eq(4)\n\t\t\t\t\t\t.val(parseInt(360*(150 - Math.max(0,Math.min(150,(ev.pageY - ev.data.y))))/150, 10))\n\t\t\t\t\t\t.get(0),\n\t\t\t\t\t[ev.data.preview]\n\t\t\t\t);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupHue = function (ev) {\n\t\t\t\tfillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\tfillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\t$(document).unbind('mouseup', upHue);\n\t\t\t\t$(document).unbind('mousemove', moveHue);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tdownSelector = function (ev) {\n\t\t\t\tvar current = {\n\t\t\t\t\tcal: $(this).parent(),\n\t\t\t\t\tpos: $(this).offset()\n\t\t\t\t};\n\t\t\t\tcurrent.preview = current.cal.data('colorpicker').livePreview;\n\t\t\t\t$(document).bind('mouseup', current, upSelector);\n\t\t\t\t$(document).bind('mousemove', current, moveSelector);\n\t\t\t},\n\t\t\tmoveSelector = function (ev) {\n\t\t\t\tchange.apply(\n\t\t\t\t\tev.data.cal.data('colorpicker')\n\t\t\t\t\t\t.fields\n\t\t\t\t\t\t.eq(6)\n\t\t\t\t\t\t.val(parseInt(100*(150 - Math.max(0,Math.min(150,(ev.pageY - ev.data.pos.top))))/150, 10))\n\t\t\t\t\t\t.end()\n\t\t\t\t\t\t.eq(5)\n\t\t\t\t\t\t.val(parseInt(100*(Math.max(0,Math.min(150,(ev.pageX - ev.data.pos.left))))/150, 10))\n\t\t\t\t\t\t.get(0),\n\t\t\t\t\t[ev.data.preview]\n\t\t\t\t);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupSelector = function (ev) {\n\t\t\t\tfillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\tfillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\t$(document).unbind('mouseup', upSelector);\n\t\t\t\t$(document).unbind('mousemove', moveSelector);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tenterSubmit = function (ev) {\n\t\t\t\t$(this).addClass('colorpicker_focus');\n\t\t\t},\n\t\t\tleaveSubmit = function (ev) {\n\t\t\t\t$(this).removeClass('colorpicker_focus');\n\t\t\t},\n\t\t\tclickSubmit = function (ev) {\n\t\t\t\tvar cal = $(this).parent();\n\t\t\t\tvar col = cal.data('colorpicker').color;\n\t\t\t\tcal.data('colorpicker').origColor = col;\n\t\t\t\tsetCurrentColor(col, cal.get(0));\n\t\t\t\tcal.data('colorpicker').onSubmit(col, HSBToHex(col), HSBToRGB(col), cal.data('colorpicker').el);\n\t\t\t},\n\t\t\tshow = function (ev) {\n\t\t\t\tvar cal = $('#' + $(this).data('colorpickerId'));\n\t\t\t\tcal.data('colorpicker').onBeforeShow.apply(this, [cal.get(0)]);\n\t\t\t\tvar pos = $(this).offset();\n\t\t\t\tvar viewPort = getViewport();\n\t\t\t\tvar top = pos.top + this.offsetHeight;\n\t\t\t\tvar left = pos.left;\n\t\t\t\tif (top + 176 > viewPort.t + viewPort.h) {\n\t\t\t\t\ttop -= this.offsetHeight + 176;\n\t\t\t\t}\n\t\t\t\tif (left + 356 > viewPort.l + viewPort.w) {\n\t\t\t\t\tleft -= 356;\n\t\t\t\t}\n\t\t\t\tcal.css({left: left + 'px', top: top + 'px'});\n\t\t\t\tif (cal.data('colorpicker').onShow.apply(this, [cal.get(0)]) != false) {\n\t\t\t\t\tcal.show();\n\t\t\t\t}\n\t\t\t\t$(document).bind('mousedown', {cal: cal}, hide);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\thide = function (ev) {\n\t\t\t\tif (!isChildOf(ev.data.cal.get(0), ev.target, ev.data.cal.get(0))) {\n\t\t\t\t\tif (ev.data.cal.data('colorpicker').onHide.apply(this, [ev.data.cal.get(0)]) != false) {\n\t\t\t\t\t\tev.data.cal.hide();\n\t\t\t\t\t}\n\t\t\t\t\t$(document).unbind('mousedown', hide);\n\t\t\t\t}\n\t\t\t},\n\t\t\tisChildOf = function(parentEl, el, container) {\n\t\t\t\tif (parentEl == el) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\tif (parentEl.contains) {\n\t\t\t\t\treturn parentEl.contains(el);\n\t\t\t\t}\n\t\t\t\tif ( parentEl.compareDocumentPosition ) {\n\t\t\t\t\treturn !!(parentEl.compareDocumentPosition(el) & 16);\n\t\t\t\t}\n\t\t\t\tvar prEl = el.parentNode;\n\t\t\t\twhile(prEl && prEl != container) {\n\t\t\t\t\tif (prEl == parentEl)\n\t\t\t\t\t\treturn true;\n\t\t\t\t\tprEl = prEl.parentNode;\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tgetViewport = function () {\n\t\t\t\tvar m = document.compatMode == 'CSS1Compat';\n\t\t\t\treturn {\n\t\t\t\t\tl : window.pageXOffset || (m ? document.documentElement.scrollLeft : document.body.scrollLeft),\n\t\t\t\t\tt : window.pageYOffset || (m ? document.documentElement.scrollTop : document.body.scrollTop),\n\t\t\t\t\tw : window.innerWidth || (m ? document.documentElement.clientWidth : document.body.clientWidth),\n\t\t\t\t\th : window.innerHeight || (m ? document.documentElement.clientHeight : document.body.clientHeight)\n\t\t\t\t};\n\t\t\t},\n\t\t\tfixHSB = function (hsb) {\n\t\t\t\treturn {\n\t\t\t\t\th: Math.min(360, Math.max(0, hsb.h)),\n\t\t\t\t\ts: Math.min(100, Math.max(0, hsb.s)),\n\t\t\t\t\tb: Math.min(100, Math.max(0, hsb.b))\n\t\t\t\t};\n\t\t\t}, \n\t\t\tfixRGB = function (rgb) {\n\t\t\t\treturn {\n\t\t\t\t\tr: Math.min(255, Math.max(0, rgb.r)),\n\t\t\t\t\tg: Math.min(255, Math.max(0, rgb.g)),\n\t\t\t\t\tb: Math.min(255, Math.max(0, rgb.b))\n\t\t\t\t};\n\t\t\t},\n\t\t\tfixHex = function (hex) {\n\t\t\t\tvar len = 6 - hex.length;\n\t\t\t\tif (len > 0) {\n\t\t\t\t\tvar o = [];\n\t\t\t\t\tfor (var i=0; i<len; i++) {\n\t\t\t\t\t\to.push('0');\n\t\t\t\t\t}\n\t\t\t\t\to.push(hex);\n\t\t\t\t\thex = o.join('');\n\t\t\t\t}\n\t\t\t\treturn hex;\n\t\t\t}, \n\t\t\tHexToRGB = function (hex) {\n\t\t\t\tvar hex = parseInt(((hex.indexOf('#') > -1) ? hex.substring(1) : hex), 16);\n\t\t\t\treturn {r: hex >> 16, g: (hex & 0x00FF00) >> 8, b: (hex & 0x0000FF)};\n\t\t\t},\n\t\t\tHexToHSB = function (hex) {\n\t\t\t\treturn RGBToHSB(HexToRGB(hex));\n\t\t\t},\n\t\t\tRGBToHSB = function (rgb) {\n\t\t\t\tvar hsb = {\n\t\t\t\t\th: 0,\n\t\t\t\t\ts: 0,\n\t\t\t\t\tb: 0\n\t\t\t\t};\n\t\t\t\tvar min = Math.min(rgb.r, rgb.g, rgb.b);\n\t\t\t\tvar max = Math.max(rgb.r, rgb.g, rgb.b);\n\t\t\t\tvar delta = max - min;\n\t\t\t\thsb.b = max;\n\t\t\t\tif (max != 0) {\n\t\t\t\t\t\n\t\t\t\t}\n\t\t\t\thsb.s = max != 0 ? 255 * delta / max : 0;\n\t\t\t\tif (hsb.s != 0) {\n\t\t\t\t\tif (rgb.r == max) {\n\t\t\t\t\t\thsb.h = (rgb.g - rgb.b) / delta;\n\t\t\t\t\t} else if (rgb.g == max) {\n\t\t\t\t\t\thsb.h = 2 + (rgb.b - rgb.r) / delta;\n\t\t\t\t\t} else {\n\t\t\t\t\t\thsb.h = 4 + (rgb.r - rgb.g) / delta;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\thsb.h = -1;\n\t\t\t\t}\n\t\t\t\thsb.h *= 60;\n\t\t\t\tif (hsb.h < 0) {\n\t\t\t\t\thsb.h += 360;\n\t\t\t\t}\n\t\t\t\thsb.s *= 100/255;\n\t\t\t\thsb.b *= 100/255;\n\t\t\t\treturn hsb;\n\t\t\t},\n\t\t\tHSBToRGB = function (hsb) {\n\t\t\t\tvar rgb = {};\n\t\t\t\tvar h = Math.round(hsb.h);\n\t\t\t\tvar s = Math.round(hsb.s*255/100);\n\t\t\t\tvar v = Math.round(hsb.b*255/100);\n\t\t\t\tif(s == 0) {\n\t\t\t\t\trgb.r = rgb.g = rgb.b = v;\n\t\t\t\t} else {\n\t\t\t\t\tvar t1 = v;\n\t\t\t\t\tvar t2 = (255-s)*v/255;\n\t\t\t\t\tvar t3 = (t1-t2)*(h%60)/60;\n\t\t\t\t\tif(h==360) h = 0;\n\t\t\t\t\tif(h<60) {rgb.r=t1;\trgb.b=t2; rgb.g=t2+t3}\n\t\t\t\t\telse if(h<120) {rgb.g=t1; rgb.b=t2;\trgb.r=t1-t3}\n\t\t\t\t\telse if(h<180) {rgb.g=t1; rgb.r=t2;\trgb.b=t2+t3}\n\t\t\t\t\telse if(h<240) {rgb.b=t1; rgb.r=t2;\trgb.g=t1-t3}\n\t\t\t\t\telse if(h<300) {rgb.b=t1; rgb.g=t2;\trgb.r=t2+t3}\n\t\t\t\t\telse if(h<360) {rgb.r=t1; rgb.g=t2;\trgb.b=t1-t3}\n\t\t\t\t\telse {rgb.r=0; rgb.g=0;\trgb.b=0}\n\t\t\t\t}\n\t\t\t\treturn {r:Math.round(rgb.r), g:Math.round(rgb.g), b:Math.round(rgb.b)};\n\t\t\t},\n\t\t\tRGBToHex = function (rgb) {\n\t\t\t\tvar hex = [\n\t\t\t\t\trgb.r.toString(16),\n\t\t\t\t\trgb.g.toString(16),\n\t\t\t\t\trgb.b.toString(16)\n\t\t\t\t];\n\t\t\t\t$.each(hex, function (nr, val) {\n\t\t\t\t\tif (val.length == 1) {\n\t\t\t\t\t\thex[nr] = '0' + val;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\treturn hex.join('');\n\t\t\t},\n\t\t\tHSBToHex = function (hsb) {\n\t\t\t\treturn RGBToHex(HSBToRGB(hsb));\n\t\t\t},\n\t\t\trestoreOriginal = function () {\n\t\t\t\tvar cal = $(this).parent();\n\t\t\t\tvar col = cal.data('colorpicker').origColor;\n\t\t\t\tcal.data('colorpicker').color = col;\n\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t};\n\t\treturn {\n\t\t\tinit: function (opt) {\n\t\t\t\topt = $.extend({}, defaults, opt||{});\n\t\t\t\tif (typeof opt.color == 'string') {\n\t\t\t\t\topt.color = HexToHSB(opt.color);\n\t\t\t\t} else if (opt.color.r != undefined && opt.color.g != undefined && opt.color.b != undefined) {\n\t\t\t\t\topt.color = RGBToHSB(opt.color);\n\t\t\t\t} else if (opt.color.h != undefined && opt.color.s != undefined && opt.color.b != undefined) {\n\t\t\t\t\topt.color = fixHSB(opt.color);\n\t\t\t\t} else {\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t\treturn this.each(function () {\n\t\t\t\t\tif (!$(this).data('colorpickerId')) {\n\t\t\t\t\t\tvar options = $.extend({}, opt);\n\t\t\t\t\t\toptions.origColor = opt.color;\n\t\t\t\t\t\tvar id = 'collorpicker_' + parseInt(Math.random() * 1000);\n\t\t\t\t\t\t$(this).data('colorpickerId', id);\n\t\t\t\t\t\tvar cal = $(tpl).attr('id', id);\n\t\t\t\t\t\tif (options.flat) {\n\t\t\t\t\t\t\tcal.appendTo(this).show();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tcal.appendTo(document.body);\n\t\t\t\t\t\t}\n\t\t\t\t\t\toptions.fields = cal\n\t\t\t\t\t\t\t\t\t\t\t.find('input')\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('keyup', keyDown)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('change', change)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('blur', blur)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('focus', focus);\n\t\t\t\t\t\tcal\n\t\t\t\t\t\t\t.find('span').bind('mousedown', downIncrement).end()\n\t\t\t\t\t\t\t.find('>div.colorpicker_current_color').bind('click', restoreOriginal);\n\t\t\t\t\t\toptions.selector = cal.find('div.colorpicker_color').bind('mousedown', downSelector);\n\t\t\t\t\t\toptions.selectorIndic = options.selector.find('div div');\n\t\t\t\t\t\toptions.el = this;\n\t\t\t\t\t\toptions.hue = cal.find('div.colorpicker_hue div');\n\t\t\t\t\t\tcal.find('div.colorpicker_hue').bind('mousedown', downHue);\n\t\t\t\t\t\toptions.newColor = cal.find('div.colorpicker_new_color');\n\t\t\t\t\t\toptions.currentColor = cal.find('div.colorpicker_current_color');\n\t\t\t\t\t\tcal.data('colorpicker', options);\n\t\t\t\t\t\tcal.find('div.colorpicker_submit')\n\t\t\t\t\t\t\t.bind('mouseenter', enterSubmit)\n\t\t\t\t\t\t\t.bind('mouseleave', leaveSubmit)\n\t\t\t\t\t\t\t.bind('click', clickSubmit);\n\t\t\t\t\t\tfillRGBFields(options.color, cal.get(0));\n\t\t\t\t\t\tfillHSBFields(options.color, cal.get(0));\n\t\t\t\t\t\tfillHexFields(options.color, cal.get(0));\n\t\t\t\t\t\tsetHue(options.color, cal.get(0));\n\t\t\t\t\t\tsetSelector(options.color, cal.get(0));\n\t\t\t\t\t\tsetCurrentColor(options.color, cal.get(0));\n\t\t\t\t\t\tsetNewColor(options.color, cal.get(0));\n\t\t\t\t\t\tif (options.flat) {\n\t\t\t\t\t\t\tcal.css({\n\t\t\t\t\t\t\t\tposition: 'relative',\n\t\t\t\t\t\t\t\tdisplay: 'block'\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t$(this).bind(options.eventName, show);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\tshowPicker: function() {\n\t\t\t\treturn this.each( function () {\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\tshow.apply(this);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\thidePicker: function() {\n\t\t\t\treturn this.each( function () {\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\t$('#' + $(this).data('colorpickerId')).hide();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\tsetColor: function(col) {\n\t\t\t\tif (typeof col == 'string') {\n\t\t\t\t\tcol = HexToHSB(col);\n\t\t\t\t} else if (col.r != undefined && col.g != undefined && col.b != undefined) {\n\t\t\t\t\tcol = RGBToHSB(col);\n\t\t\t\t} else if (col.h != undefined && col.s != undefined && col.b != undefined) {\n\t\t\t\t\tcol = fixHSB(col);\n\t\t\t\t} else {\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t\treturn this.each(function(){\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\tvar cal = $('#' + $(this).data('colorpickerId'));\n\t\t\t\t\t\tcal.data('colorpicker').color = col;\n\t\t\t\t\t\tcal.data('colorpicker').origColor = col;\n\t\t\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\t\t\tsetCurrentColor(col, cal.get(0));\n\t\t\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\t}();\n\t$.fn.extend({\n\t\tColorPicker: ColorPicker.init,\n\t\tColorPickerHide: ColorPicker.hidePicker,\n\t\tColorPickerShow: ColorPicker.showPicker,\n\t\tColorPickerSetColor: ColorPicker.setColor\n\t});\n});","jquery/jstree/jquery.jstree.js":"/*\n * jsTree 1.0-rc3\n * http://jstree.com/\n *\n * Copyright (c) 2010 Ivan Bozhanov (vakata.com)\n *\n * Licensed same as jquery - under the terms of either the MIT License or the GPL Version 2 License\n *   http://www.opensource.org/licenses/mit-license.php\n *   http://www.gnu.org/licenses/gpl.html\n *\n * $Date: 2011-02-09 01:17:14 +0200 (\u0441\u0440, 09 \u0444\u0435\u0432\u0440 2011) $\n * $Revision: 236 $\n */\n\n/*jslint browser: true, onevar: true, undef: true, bitwise: true, strict: true */\n/*global window : false, clearInterval: false, clearTimeout: false, document: false, setInterval: false, setTimeout: false, jQuery: false, navigator: false, XSLTProcessor: false, DOMParser: false, XMLSerializer: false*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery/jquery.cookie\",\n            \"jquery/jstree/jquery.hotkeys\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\"use strict\";\n\n// top wrapper to prevent multiple inclusion (is this OK?)\n(function () { if(jQuery && jQuery.jstree) { return; }\n\tvar is_ie6 = false, is_ie7 = false, is_ff2 = false;\n\n/*\n * jsTree core\n */\n(function ($) {\n\t// Common functions not related to jsTree\n\t// decided to move them to a `vakata` \"namespace\"\n\t$.vakata = {};\n\t// CSS related functions\n\t$.vakata.css = {\n\t\tget_css : function(rule_name, delete_flag, sheet) {\n\t\t\trule_name = rule_name.toLowerCase();\n\t\t\tvar css_rules = sheet.cssRules || sheet.rules,\n\t\t\t\tj = 0;\n\t\t\tdo {\n\t\t\t\tif(css_rules.length && j > css_rules.length + 5) { return false; }\n\t\t\t\tif(css_rules[j].selectorText && css_rules[j].selectorText.toLowerCase() == rule_name) {\n\t\t\t\t\tif(delete_flag === true) {\n\t\t\t\t\t\tif(sheet.removeRule) { sheet.removeRule(j); }\n\t\t\t\t\t\tif(sheet.deleteRule) { sheet.deleteRule(j); }\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t\telse { return css_rules[j]; }\n\t\t\t\t}\n\t\t\t}\n\t\t\twhile (css_rules[++j]);\n\t\t\treturn false;\n\t\t},\n\t\tadd_css : function(rule_name, sheet) {\n\t\t\tif($.jstree.css.get_css(rule_name, false, sheet)) { return false; }\n\t\t\tif(sheet.insertRule) { sheet.insertRule(rule_name + ' { }', 0); } else { sheet.addRule(rule_name, null, 0); }\n\t\t\treturn $.vakata.css.get_css(rule_name);\n\t\t},\n\t\tremove_css : function(rule_name, sheet) {\n\t\t\treturn $.vakata.css.get_css(rule_name, true, sheet);\n\t\t},\n\t\tadd_sheet : function(opts) {\n\t\t\tvar tmp = false, is_new = true;\n\t\t\tif(opts.str) {\n\t\t\t\tif(opts.title) { tmp = $(\"style[id='\" + opts.title + \"-stylesheet']\")[0]; }\n\t\t\t\tif(tmp) { is_new = false; }\n\t\t\t\telse {\n\t\t\t\t\ttmp = document.createElement(\"style\");\n\t\t\t\t\ttmp.setAttribute('type',\"text/css\");\n\t\t\t\t\tif(opts.title) { tmp.setAttribute(\"id\", opts.title + \"-stylesheet\"); }\n\t\t\t\t}\n\t\t\t\tif(tmp.styleSheet) {\n\t\t\t\t\tif(is_new) {\n\t\t\t\t\t\tdocument.getElementsByTagName(\"head\")[0].appendChild(tmp);\n\t\t\t\t\t\ttmp.styleSheet.cssText = opts.str;\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\ttmp.styleSheet.cssText = tmp.styleSheet.cssText + \" \" + opts.str;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\ttmp.appendChild(document.createTextNode(opts.str));\n\t\t\t\t\tdocument.getElementsByTagName(\"head\")[0].appendChild(tmp);\n\t\t\t\t}\n\t\t\t\treturn tmp.sheet || tmp.styleSheet;\n\t\t\t}\n\t\t\tif(opts.url) {\n\t\t\t\tif(document.createStyleSheet) {\n\t\t\t\t\ttry { tmp = document.createStyleSheet(opts.url); } catch (e) { }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\ttmp\t\t\t= document.createElement('link');\n\t\t\t\t\ttmp.rel\t\t= 'stylesheet';\n\t\t\t\t\ttmp.type\t= 'text/css';\n\t\t\t\t\ttmp.media\t= \"all\";\n\t\t\t\t\ttmp.href\t= opts.url;\n\t\t\t\t\tdocument.getElementsByTagName(\"head\")[0].appendChild(tmp);\n\t\t\t\t\treturn tmp.styleSheet;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n\n\t// private variables\n\tvar instances = [],\t\t\t// instance array (used by $.jstree.reference/create/focused)\n\t\tfocused_instance = -1,\t// the index in the instance array of the currently focused instance\n\t\tplugins = {},\t\t\t// list of included plugins\n\t\tprepared_move = {};\t\t// for the move_node function\n\n\t// jQuery plugin wrapper (thanks to jquery UI widget function)\n\t$.fn.jstree = function (settings) {\n\t\tvar isMethodCall = (typeof settings == 'string'), // is this a method call like $().jstree(\"open_node\")\n\t\t\targs = Array.prototype.slice.call(arguments, 1),\n\t\t\treturnValue = this;\n\n\t\t// if a method call execute the method on all selected instances\n\t\tif(isMethodCall) {\n\t\t\tif(settings.substring(0, 1) == '_') { return returnValue; }\n\t\t\tthis.each(function() {\n\t\t\t\tvar instance = instances[$.data(this, \"jstree_instance_id\")],\n\t\t\t\t\tmethodValue = (instance && $.isFunction(instance[settings])) ? instance[settings].apply(instance, args) : instance;\n\t\t\t\t\tif(typeof methodValue !== \"undefined\" && (settings.indexOf(\"is_\") === 0 || (methodValue !== true && methodValue !== false))) { returnValue = methodValue; return false; }\n\t\t\t});\n\t\t}\n\t\telse {\n\t\t\tthis.each(function() {\n\t\t\t\t// extend settings and allow for multiple hashes and $.data\n\t\t\t\tvar instance_id = $.data(this, \"jstree_instance_id\"),\n\t\t\t\t\ta = [],\n\t\t\t\t\tb = settings ? $.extend({}, true, settings) : {},\n\t\t\t\t\tc = $(this),\n\t\t\t\t\ts = false,\n\t\t\t\t\tt = [];\n\t\t\t\ta = a.concat(args);\n\t\t\t\tif(c.data(\"jstree\")) { a.push(c.data(\"jstree\")); }\n\t\t\t\tb = a.length ? $.extend.apply(null, [true, b].concat(a)) : b;\n\n\t\t\t\t// if an instance already exists, destroy it first\n\t\t\t\tif(typeof instance_id !== \"undefined\" && instances[instance_id]) { instances[instance_id].destroy(); }\n\t\t\t\t// push a new empty object to the instances array\n\t\t\t\tinstance_id = parseInt(instances.push({}),10) - 1;\n\t\t\t\t// store the jstree instance id to the container element\n\t\t\t\t$.data(this, \"jstree_instance_id\", instance_id);\n\t\t\t\t// clean up all plugins\n\t\t\t\tb.plugins = $.isArray(b.plugins) ? b.plugins : $.jstree.defaults.plugins.slice();\n\t\t\t\tb.plugins.unshift(\"core\");\n\t\t\t\t// only unique plugins\n\t\t\t\tb.plugins = b.plugins.sort().join(\",,\").replace(/(,|^)([^,]+)(,,\\2)+(,|$)/g,\"$1$2$4\").replace(/,,+/g,\",\").replace(/,$/,\"\").split(\",\");\n\n\t\t\t\t// extend defaults with passed data\n\t\t\t\ts = $.extend(true, {}, $.jstree.defaults, b);\n\t\t\t\ts.plugins = b.plugins;\n\t\t\t\t$.each(plugins, function (i, val) {\n\t\t\t\t\tif($.inArray(i, s.plugins) === -1) { s[i] = null; delete s[i]; }\n\t\t\t\t\telse { t.push(i); }\n\t\t\t\t});\n\t\t\t\ts.plugins = t;\n\n\t\t\t\t// push the new object to the instances array (at the same time set the default classes to the container) and init\n\t\t\t\tinstances[instance_id] = new $.jstree._instance(instance_id, $(this).addClass(\"jstree jstree-\" + instance_id), s);\n\t\t\t\t// init all activated plugins for this instance\n\t\t\t\t$.each(instances[instance_id]._get_settings().plugins, function (i, val) { instances[instance_id].data[val] = {}; });\n\t\t\t\t$.each(instances[instance_id]._get_settings().plugins, function (i, val) { if(plugins[val]) { plugins[val].__init.apply(instances[instance_id]); } });\n\t\t\t\t// initialize the instance\n\t\t\t\tsetTimeout(function() { if(instances[instance_id]) { instances[instance_id].init(); } }, 0);\n\t\t\t});\n\t\t}\n\t\t// return the jquery selection (or if it was a method call that returned a value - the returned value)\n\t\treturn returnValue;\n\t};\n\t// object to store exposed functions and objects\n\t$.jstree = {\n\t\tdefaults : {\n\t\t\tplugins : []\n\t\t},\n\t\t_focused : function () { return instances[focused_instance] || null; },\n\t\t_reference : function (needle) {\n\t\t\t// get by instance id\n\t\t\tif(instances[needle]) { return instances[needle]; }\n\t\t\t// get by DOM (if still no luck - return null\n\t\t\tvar o = $(needle);\n\t\t\tif(!o.length && typeof needle === \"string\") { o = $(\"#\" + needle); }\n\t\t\tif(!o.length) { return null; }\n\t\t\treturn instances[o.closest(\".jstree\").data(\"jstree_instance_id\")] || null;\n\t\t},\n\t\t_instance : function (index, container, settings) {\n\t\t\t// for plugins to store data in\n\t\t\tthis.data = { core : {} };\n\t\t\tthis.get_settings\t= function () { return $.extend(true, {}, settings); };\n\t\t\tthis._get_settings\t= function () { return settings; };\n\t\t\tthis.get_index\t\t= function () { return index; };\n\t\t\tthis.get_container\t= function () { return container; };\n\t\t\tthis.get_container_ul = function () { return container.children(\"ul:eq(0)\"); };\n\t\t\tthis._set_settings\t= function (s) {\n\t\t\t\tsettings = $.extend(true, {}, settings, s);\n\t\t\t};\n\t\t},\n\t\t_fn : { },\n\t\tplugin : function (pname, pdata) {\n\t\t\tpdata = $.extend({}, {\n\t\t\t\t__init\t\t: $.noop,\n\t\t\t\t__destroy\t: $.noop,\n\t\t\t\t_fn\t\t\t: {},\n\t\t\t\tdefaults\t: false\n\t\t\t}, pdata);\n\t\t\tplugins[pname] = pdata;\n\n\t\t\t$.jstree.defaults[pname] = pdata.defaults;\n\t\t\t$.each(pdata._fn, function (i, val) {\n\t\t\t\tval.plugin\t\t= pname;\n\t\t\t\tval.old\t\t\t= $.jstree._fn[i];\n\t\t\t\t$.jstree._fn[i] = function () {\n\t\t\t\t\tvar rslt,\n\t\t\t\t\t\tfunc = val,\n\t\t\t\t\t\targs = Array.prototype.slice.call(arguments),\n\t\t\t\t\t\tevnt = new $.Event(\"before.jstree\"),\n\t\t\t\t\t\trlbk = false;\n\n\t\t\t\t\tif(this.data.core.locked === true && i !== \"unlock\" && i !== \"is_locked\") { return; }\n\n\t\t\t\t\t// Check if function belongs to the included plugins of this instance\n\t\t\t\t\tdo {\n\t\t\t\t\t\tif(func && func.plugin && $.inArray(func.plugin, this._get_settings().plugins) !== -1) { break; }\n\t\t\t\t\t\tfunc = func.old;\n\t\t\t\t\t} while(func);\n\t\t\t\t\tif(!func) { return; }\n\n\t\t\t\t\t// context and function to trigger events, then finally call the function\n\t\t\t\t\tif(i.indexOf(\"_\") === 0) {\n\t\t\t\t\t\trslt = func.apply(this, args);\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\trslt = this.get_container().triggerHandler(evnt, { \"func\" : i, \"inst\" : this, \"args\" : args, \"plugin\" : func.plugin });\n\t\t\t\t\t\tif(rslt === false) { return; }\n\t\t\t\t\t\tif(typeof rslt !== \"undefined\") { args = rslt; }\n\n\t\t\t\t\t\trslt = func.apply(\n\t\t\t\t\t\t\t$.extend({}, this, {\n\t\t\t\t\t\t\t\t__callback : function (data) {\n\t\t\t\t\t\t\t\t\tthis.get_container().triggerHandler( i + '.jstree', { \"inst\" : this, \"args\" : args, \"rslt\" : data, \"rlbk\" : rlbk });\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t__rollback : function () {\n\t\t\t\t\t\t\t\t\trlbk = this.get_rollback();\n\t\t\t\t\t\t\t\t\treturn rlbk;\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t__call_old : function (replace_arguments) {\n\t\t\t\t\t\t\t\t\treturn func.old.apply(this, (replace_arguments ? Array.prototype.slice.call(arguments, 1) : args ) );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}), args);\n\t\t\t\t\t}\n\n\t\t\t\t\t// return the result\n\t\t\t\t\treturn rslt;\n\t\t\t\t};\n\t\t\t\t$.jstree._fn[i].old = val.old;\n\t\t\t\t$.jstree._fn[i].plugin = pname;\n\t\t\t});\n\t\t},\n\t\trollback : function (rb) {\n\t\t\tif(rb) {\n\t\t\t\tif(!$.isArray(rb)) { rb = [ rb ]; }\n\t\t\t\t$.each(rb, function (i, val) {\n\t\t\t\t\tinstances[val.i].set_rollback(val.h, val.d);\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t};\n\t// set the prototype for all instances\n\t$.jstree._fn = $.jstree._instance.prototype = {};\n\n\t// load the css when DOM is ready\n\t$(function() {\n\t\t// code is copied from jQuery ($.browser is deprecated + there is a bug in IE)\n\t\tvar u = navigator.userAgent.toLowerCase(),\n\t\t\tv = (u.match( /.+?(?:rv|it|ra|ie)[\\/: ]([\\d.]+)/ ) || [0,'0'])[1],\n\t\t\tcss_string = '' +\n\t\t\t\t'.jstree ul, .jstree li { display:block; margin:0 0 0 0; padding:0 0 0 0; list-style-type:none; } ' +\n\t\t\t\t'.jstree li { display:block; min-height:18px; line-height:18px; white-space:nowrap; margin-left:18px; min-width:18px; } ' +\n\t\t\t\t'.jstree-rtl li { margin-left:0; margin-right:18px; } ' +\n\t\t\t\t'.jstree > ul > li { margin-left:0px; } ' +\n\t\t\t\t'.jstree-rtl > ul > li { margin-right:0px; } ' +\n\t\t\t\t'.jstree ins { display:inline-block; text-decoration:none; width:18px; height:18px; margin:0 0 0 0; padding:0; } ' +\n\t\t\t\t'.jstree a { display:inline-block; line-height:16px; height:16px; color:black; white-space:nowrap; text-decoration:none; padding:1px 2px; margin:0; } ' +\n\t\t\t\t'.jstree a:focus { outline: none; } ' +\n\t\t\t\t'.jstree a > ins { height:16px; width:16px; } ' +\n\t\t\t\t'.jstree a > .jstree-icon { margin-right:3px; } ' +\n\t\t\t\t'.jstree-rtl a > .jstree-icon { margin-left:3px; margin-right:0; } ' +\n\t\t\t\t'li.jstree-open > ul { display:block; } ' +\n\t\t\t\t'li.jstree-closed > ul { display:none; } ';\n\t\t// Correct IE 6 (does not support the > CSS selector)\n\t\tif(/msie/.test(u) && parseInt(v, 10) == 6) {\n\t\t\tis_ie6 = true;\n\n\t\t\t// fix image flicker and lack of caching\n\t\t\ttry {\n\t\t\t\tdocument.execCommand(\"BackgroundImageCache\", false, true);\n\t\t\t} catch (err) { }\n\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree li { height:18px; margin-left:0; margin-right:0; } ' +\n\t\t\t\t'.jstree li li { margin-left:18px; } ' +\n\t\t\t\t'.jstree-rtl li li { margin-left:0px; margin-right:18px; } ' +\n\t\t\t\t'li.jstree-open ul { display:block; } ' +\n\t\t\t\t'li.jstree-closed ul { display:none !important; } ' +\n\t\t\t\t'.jstree li a { display:inline; border-width:0 !important; padding:0px 2px !important; } ' +\n\t\t\t\t'.jstree li a ins { height:16px; width:16px; margin-right:3px; } ' +\n\t\t\t\t'.jstree-rtl li a ins { margin-right:0px; margin-left:3px; } ';\n\t\t}\n\t\t// Correct IE 7 (shifts anchor nodes onhover)\n\t\tif(/msie/.test(u) && parseInt(v, 10) == 7) {\n\t\t\tis_ie7 = true;\n\t\t\tcss_string += '.jstree li a { border-width:0 !important; padding:0px 2px !important; } ';\n\t\t}\n\t\t// correct ff2 lack of display:inline-block\n\t\tif(!/compatible/.test(u) && /mozilla/.test(u) && parseFloat(v, 10) < 1.9) {\n\t\t\tis_ff2 = true;\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree ins { display:-moz-inline-box; } ' +\n\t\t\t\t'.jstree li { line-height:12px; } ' + // WHY??\n\t\t\t\t'.jstree a { display:-moz-inline-box; } ' +\n\t\t\t\t'.jstree .jstree-no-icons .jstree-checkbox { display:-moz-inline-stack !important; } ';\n\t\t\t\t/* this shouldn't be here as it is theme specific */\n\t\t}\n\t\t// the default stylesheet\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n\n\t// core functions (open, close, create, update, delete)\n\t$.jstree.plugin(\"core\", {\n\t\t__init : function () {\n\t\t\tthis.data.core.locked = false;\n\t\t\tthis.data.core.to_open = this.get_settings().core.initially_open;\n\t\t\tthis.data.core.to_load = this.get_settings().core.initially_load;\n\t\t},\n\t\tdefaults : {\n\t\t\thtml_titles\t: false,\n\t\t\tanimation\t: 500,\n\t\t\tinitially_open : [],\n\t\t\tinitially_load : [],\n\t\t\topen_parents : true,\n\t\t\tnotify_plugins : true,\n\t\t\trtl\t\t\t: false,\n\t\t\tload_open\t: false,\n\t\t\tstrings\t\t: {\n\t\t\t\tloading\t\t: \"Loading ...\",\n\t\t\t\tnew_node\t: \"New node\",\n\t\t\t\tmultiple_selection : \"Multiple selection\"\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\tinit\t: function () {\n\t\t\t\tthis.set_focus();\n\t\t\t\tif(this._get_settings().core.rtl) {\n\t\t\t\t\tthis.get_container().addClass(\"jstree-rtl\").css(\"direction\", \"rtl\");\n\t\t\t\t}\n\t\t\t\tthis.get_container().html(\"<ul><li class='jstree-last jstree-leaf'><ins>&#160;</ins><a class='jstree-loading' href='#'><ins class='jstree-icon'>&#160;</ins>\" + this._get_string(\"loading\") + \"</a></li></ul>\");\n\t\t\t\tthis.data.core.li_height = this.get_container_ul().find(\"li.jstree-closed, li.jstree-leaf\").eq(0).height() || 18;\n\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.delegate(\"li > ins\", \"click.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\t\tvar trgt = $(event.target);\n\t\t\t\t\t\t\t// if(trgt.is(\"ins\") && event.pageY - trgt.offset().top < this.data.core.li_height) { this.toggle_node(trgt); }\n\t\t\t\t\t\t\tthis.toggle_node(trgt);\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.bind(\"mousedown.jstree\", $.proxy(function () {\n\t\t\t\t\t\t\tthis.set_focus(); // This used to be setTimeout(set_focus,0) - why?\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.bind(\"dblclick.jstree\", function (event) {\n\t\t\t\t\t\tvar sel;\n\t\t\t\t\t\tif(document.selection && document.selection.empty) { document.selection.empty(); }\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif(window.getSelection) {\n\t\t\t\t\t\t\t\tsel = window.getSelection();\n\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\tsel.removeAllRanges();\n\t\t\t\t\t\t\t\t\tsel.collapse();\n\t\t\t\t\t\t\t\t} catch (err) { }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\tif(this._get_settings().core.notify_plugins) {\n\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t.bind(\"load_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\t\t\tvar o = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\t\t\tt = this;\n\t\t\t\t\t\t\t\tif(o === -1) { o = this.get_container_ul(); }\n\t\t\t\t\t\t\t\tif(!o.length) { return; }\n\t\t\t\t\t\t\t\to.find(\"li\").each(function () {\n\t\t\t\t\t\t\t\t\tvar th = $(this);\n\t\t\t\t\t\t\t\t\tif(th.data(\"jstree\")) {\n\t\t\t\t\t\t\t\t\t\t$.each(th.data(\"jstree\"), function (plugin, values) {\n\t\t\t\t\t\t\t\t\t\t\tif(t.data[plugin] && $.isFunction(t[\"_\" + plugin + \"_notify\"])) {\n\t\t\t\t\t\t\t\t\t\t\t\tt[\"_\" + plugin + \"_notify\"].call(t, th, values);\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t}\n\t\t\t\tif(this._get_settings().core.load_open) {\n\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t.bind(\"load_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\t\t\tvar o = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\t\t\tt = this;\n\t\t\t\t\t\t\t\tif(o === -1) { o = this.get_container_ul(); }\n\t\t\t\t\t\t\t\tif(!o.length) { return; }\n\t\t\t\t\t\t\t\to.find(\"li.jstree-open:not(:has(ul))\").each(function () {\n\t\t\t\t\t\t\t\t\tt.load_node(this, $.noop, $.noop);\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t}\n\t\t\t\tthis.__callback();\n\t\t\t\tthis.load_node(-1, function () { this.loaded(); this.reload_nodes(); });\n\t\t\t},\n\t\t\tdestroy\t: function () {\n\t\t\t\tvar i,\n\t\t\t\t\tn = this.get_index(),\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this;\n\n\t\t\t\t$.each(s.plugins, function (i, val) {\n\t\t\t\t\ttry { plugins[val].__destroy.apply(_this); } catch(err) { }\n\t\t\t\t});\n\t\t\t\tthis.__callback();\n\t\t\t\t// set focus to another instance if this one is focused\n\t\t\t\tif(this.is_focused()) {\n\t\t\t\t\tfor(i in instances) {\n\t\t\t\t\t\tif(instances.hasOwnProperty(i) && i != n) {\n\t\t\t\t\t\t\tinstances[i].set_focus();\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t// if no other instance found\n\t\t\t\tif(n === focused_instance) { focused_instance = -1; }\n\t\t\t\t// remove all traces of jstree in the DOM (only the ones set using jstree*) and cleans all events\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.unbind(\".jstree\")\n\t\t\t\t\t.undelegate(\".jstree\")\n\t\t\t\t\t.removeData(\"jstree_instance_id\")\n\t\t\t\t\t.find(\"[class^='jstree']\")\n\t\t\t\t\t\t.addBack()\n\t\t\t\t\t\t.attr(\"class\", function () { return this.className.replace(/jstree[^ ]*|$/ig,''); });\n\t\t\t\t$(document)\n\t\t\t\t\t.unbind(\".jstree-\" + n)\n\t\t\t\t\t.undelegate(\".jstree-\" + n);\n\t\t\t\t// remove the actual data\n\t\t\t\tinstances[n] = null;\n\t\t\t\tdelete instances[n];\n\t\t\t},\n\n\t\t\t_core_notify : function (n, data) {\n\t\t\t\tif(data.opened) {\n\t\t\t\t\tthis.open_node(n, false, true);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlock : function () {\n\t\t\t\tthis.data.core.locked = true;\n\t\t\t\tthis.get_container().children(\"ul\").addClass(\"jstree-locked\").css(\"opacity\",\"0.7\");\n\t\t\t\tthis.__callback({});\n\t\t\t},\n\t\t\tunlock : function () {\n\t\t\t\tthis.data.core.locked = false;\n\t\t\t\tthis.get_container().children(\"ul\").removeClass(\"jstree-locked\").css(\"opacity\",\"1\");\n\t\t\t\tthis.__callback({});\n\t\t\t},\n\t\t\tis_locked : function () { return this.data.core.locked; },\n\t\t\tsave_opened : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.data.core.to_open = [];\n\t\t\t\tthis.get_container_ul().find(\"li.jstree-open\").each(function () {\n\t\t\t\t\tif(this.id) { _this.data.core.to_open.push(\"#\" + this.id.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\")); }\n\t\t\t\t});\n\t\t\t\tthis.__callback(_this.data.core.to_open);\n\t\t\t},\n\t\t\tsave_loaded : function () { },\n\t\t\treload_nodes : function (is_callback) {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tdone = true,\n\t\t\t\t\tcurrent = [],\n\t\t\t\t\tremaining = [];\n\t\t\t\tif(!is_callback) {\n\t\t\t\t\tthis.data.core.reopen = false;\n\t\t\t\t\tthis.data.core.refreshing = true;\n\t\t\t\t\tthis.data.core.to_open = $.map($.makeArray(this.data.core.to_open), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t\tthis.data.core.to_load = $.map($.makeArray(this.data.core.to_load), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t\tif(this.data.core.to_open.length) {\n\t\t\t\t\t\tthis.data.core.to_load = this.data.core.to_load.concat(this.data.core.to_open);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(this.data.core.to_load.length) {\n\t\t\t\t\t$.each(this.data.core.to_load, function (i, val) {\n\t\t\t\t\t\tif(val == \"#\") { return true; }\n\t\t\t\t\t\tif($(val).length) { current.push(val); }\n\t\t\t\t\t\telse { remaining.push(val); }\n\t\t\t\t\t});\n\t\t\t\t\tif(current.length) {\n\t\t\t\t\t\tthis.data.core.to_load = remaining;\n\t\t\t\t\t\t$.each(current, function (i, val) {\n\t\t\t\t\t\t\tif(!_this._is_loaded(val)) {\n\t\t\t\t\t\t\t\t_this.load_node(val, function () { _this.reload_nodes(true); }, function () { _this.reload_nodes(true); });\n\t\t\t\t\t\t\t\tdone = false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(this.data.core.to_open.length) {\n\t\t\t\t\t$.each(this.data.core.to_open, function (i, val) {\n\t\t\t\t\t\t_this.open_node(val, false, true);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tif(done) {\n\t\t\t\t\t// TODO: find a more elegant approach to syncronizing returning requests\n\t\t\t\t\tif(this.data.core.reopen) { clearTimeout(this.data.core.reopen); }\n\t\t\t\t\tthis.data.core.reopen = setTimeout(function () { _this.__callback({}, _this); }, 50);\n\t\t\t\t\tthis.data.core.refreshing = false;\n\t\t\t\t\tthis.reopen();\n\t\t\t\t}\n\t\t\t},\n\t\t\treopen : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tif(this.data.core.to_open.length) {\n\t\t\t\t\t$.each(this.data.core.to_open, function (i, val) {\n\t\t\t\t\t\t_this.open_node(val, false, true);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tthis.__callback({});\n\t\t\t},\n\t\t\trefresh : function (obj) {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.save_opened();\n\t\t\t\tif(!obj) { obj = -1; }\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj) { obj = -1; }\n\t\t\t\tif(obj !== -1) { obj.children(\"UL\").remove(); }\n\t\t\t\telse { this.get_container_ul().empty(); }\n\t\t\t\tthis.load_node(obj, function () { _this.__callback({ \"obj\" : obj}); _this.reload_nodes(); });\n\t\t\t},\n\t\t\t// Dummy function to fire after the first load (so that there is a jstree.loaded event)\n\t\t\tloaded\t: function () {\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\t// deal with focus\n\t\t\tset_focus\t: function () {\n\t\t\t\tif(this.is_focused()) { return; }\n\t\t\t\tvar f = $.jstree._focused();\n\t\t\t\tif(f) { f.unset_focus(); }\n\n\t\t\t\tthis.get_container().addClass(\"jstree-focused\");\n\t\t\t\tfocused_instance = this.get_index();\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\tis_focused\t: function () {\n\t\t\t\treturn focused_instance == this.get_index();\n\t\t\t},\n\t\t\tunset_focus\t: function () {\n\t\t\t\tif(this.is_focused()) {\n\t\t\t\t\tthis.get_container().removeClass(\"jstree-focused\");\n\t\t\t\t\tfocused_instance = -1;\n\t\t\t\t}\n\t\t\t\tthis.__callback();\n\t\t\t},\n\n\t\t\t// traverse\n\t\t\t_get_node\t\t: function (obj) {\n\t\t\t\tvar $obj = $(obj, this.get_container());\n\t\t\t\tif($obj.is(\".jstree\") || obj == -1) { return -1; }\n\t\t\t\t$obj = $obj.closest(\"li\", this.get_container());\n\t\t\t\treturn $obj.length ? $obj : false;\n\t\t\t},\n\t\t\t_get_next\t\t: function (obj, strict) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1) { return this.get_container().find(\"> ul > li:first-child\"); }\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(strict) { return (obj.nextAll(\"li\").size() > 0) ? obj.nextAll(\"li:eq(0)\") : false; }\n\n\t\t\t\tif(obj.hasClass(\"jstree-open\")) { return obj.find(\"li:eq(0)\"); }\n\t\t\t\telse if(obj.nextAll(\"li\").size() > 0) { return obj.nextAll(\"li:eq(0)\"); }\n\t\t\t\telse { return obj.parentsUntil(\".jstree\",\"li\").next(\"li\").eq(0); }\n\t\t\t},\n\t\t\t_get_prev\t\t: function (obj, strict) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1) { return this.get_container().find(\"> ul > li:last-child\"); }\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(strict) { return (obj.prevAll(\"li\").length > 0) ? obj.prevAll(\"li:eq(0)\") : false; }\n\n\t\t\t\tif(obj.prev(\"li\").length) {\n\t\t\t\t\tobj = obj.prev(\"li\").eq(0);\n\t\t\t\t\twhile(obj.hasClass(\"jstree-open\")) { obj = obj.children(\"ul:eq(0)\").children(\"li:last\"); }\n\t\t\t\t\treturn obj;\n\t\t\t\t}\n\t\t\t\telse { var o = obj.parentsUntil(\".jstree\",\"li:eq(0)\"); return o.length ? o : false; }\n\t\t\t},\n\t\t\t_get_parent\t\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj == -1 || !obj.length) { return false; }\n\t\t\t\tvar o = obj.parentsUntil(\".jstree\", \"li:eq(0)\");\n\t\t\t\treturn o.length ? o : -1;\n\t\t\t},\n\t\t\t_get_children\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1) { return this.get_container().children(\"ul:eq(0)\").children(\"li\"); }\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\treturn obj.children(\"ul:eq(0)\").children(\"li\");\n\t\t\t},\n\t\t\tget_path\t\t: function (obj, id_mode) {\n\t\t\t\tvar p = [],\n\t\t\t\t\t_this = this;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1 || !obj || !obj.length) { return false; }\n\t\t\t\tobj.parentsUntil(\".jstree\", \"li\").each(function () {\n\t\t\t\t\tp.push( id_mode ? this.id : _this.get_text(this) );\n\t\t\t\t});\n\t\t\t\tp.reverse();\n\t\t\t\tp.push( id_mode ? obj.attr(\"id\") : this.get_text(obj) );\n\t\t\t\treturn p;\n\t\t\t},\n\n\t\t\t// string functions\n\t\t\t_get_string : function (key) {\n\t\t\t\treturn this._get_settings().core.strings[key] || key;\n\t\t\t},\n\n\t\t\tis_open\t\t: function (obj) { obj = this._get_node(obj); return obj && obj !== -1 && obj.hasClass(\"jstree-open\"); },\n\t\t\tis_closed\t: function (obj) { obj = this._get_node(obj); return obj && obj !== -1 && obj.hasClass(\"jstree-closed\"); },\n\t\t\tis_leaf\t\t: function (obj) { obj = this._get_node(obj); return obj && obj !== -1 && obj.hasClass(\"jstree-leaf\"); },\n\t\t\tcorrect_state\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || obj === -1) { return false; }\n\t\t\t\tobj.removeClass(\"jstree-closed jstree-open\").addClass(\"jstree-leaf\").children(\"ul\").remove();\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\t// open/close\n\t\t\topen_node\t: function (obj, callback, skip_animation) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(!obj.hasClass(\"jstree-closed\")) { if(callback) { callback.call(); } return false; }\n\t\t\t\tvar s = skip_animation || is_ie6 ? 0 : this._get_settings().core.animation,\n\t\t\t\t\tt = this;\n\t\t\t\tif(!this._is_loaded(obj)) {\n\t\t\t\t\tobj.children(\"a\").addClass(\"jstree-loading\");\n\t\t\t\t\tthis.load_node(obj, function () { t.open_node(obj, callback, skip_animation); }, callback);\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(this._get_settings().core.open_parents) {\n\t\t\t\t\t\tobj.parentsUntil(\".jstree\",\".jstree-closed\").each(function () {\n\t\t\t\t\t\t\tt.open_node(this, false, true);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t\tif(s) { obj.children(\"ul\").css(\"display\",\"none\"); }\n\t\t\t\t\tobj.removeClass(\"jstree-closed\").addClass(\"jstree-open\").children(\"a\").removeClass(\"jstree-loading\");\n\t\t\t\t\tif(s) { obj.children(\"ul\").stop(true, true).slideDown(s, function () { this.style.display = \"\"; t.after_open(obj); }); }\n\t\t\t\t\telse { t.after_open(obj); }\n\t\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t\t\tif(callback) { callback.call(); }\n\t\t\t\t}\n\t\t\t},\n\t\t\tafter_open\t: function (obj) { this.__callback({ \"obj\" : obj }); },\n\t\t\tclose_node\t: function (obj, skip_animation) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar s = skip_animation || is_ie6 ? 0 : this._get_settings().core.animation,\n\t\t\t\t\tt = this;\n\t\t\t\tif(!obj.length || !obj.hasClass(\"jstree-open\")) { return false; }\n\t\t\t\tif(s) { obj.children(\"ul\").attr(\"style\",\"display:block !important\"); }\n\t\t\t\tobj.removeClass(\"jstree-open\").addClass(\"jstree-closed\");\n\t\t\t\tif(s) { obj.children(\"ul\").stop(true, true).slideUp(s, function () { this.style.display = \"\"; t.after_close(obj); }); }\n\t\t\t\telse { t.after_close(obj); }\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tafter_close\t: function (obj) { this.__callback({ \"obj\" : obj }); },\n\t\t\ttoggle_node\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj.hasClass(\"jstree-closed\")) { return this.open_node(obj); }\n\t\t\t\tif(obj.hasClass(\"jstree-open\")) { return this.close_node(obj); }\n\t\t\t},\n\t\t\topen_all\t: function (obj, do_animation, original_obj) {\n\t\t\t\tobj = obj ? this._get_node(obj) : -1;\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container_ul(); }\n\t\t\t\tif(original_obj) {\n\t\t\t\t\tobj = obj.find(\"li.jstree-closed\");\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\toriginal_obj = obj;\n\t\t\t\t\tif(obj.is(\".jstree-closed\")) { obj = obj.find(\"li.jstree-closed\").addBack(); }\n\t\t\t\t\telse { obj = obj.find(\"li.jstree-closed\"); }\n\t\t\t\t}\n\t\t\t\tvar _this = this;\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tvar __this = this;\n\t\t\t\t\tif(!_this._is_loaded(this)) { _this.open_node(this, function() { _this.open_all(__this, do_animation, original_obj); }, !do_animation); }\n\t\t\t\t\telse { _this.open_node(this, false, !do_animation); }\n\t\t\t\t});\n\t\t\t\t// so that callback is fired AFTER all nodes are open\n\t\t\t\tif(original_obj.find('li.jstree-closed').length === 0) { this.__callback({ \"obj\" : original_obj }); }\n\t\t\t},\n\t\t\tclose_all\t: function (obj, do_animation) {\n\t\t\t\tvar _this = this;\n\t\t\t\tobj = obj ? this._get_node(obj) : this.get_container();\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container_ul(); }\n\t\t\t\tobj.find(\"li.jstree-open\").addBack().each(function () { _this.close_node(this, !do_animation); });\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tclean_node\t: function (obj) {\n\t\t\t\tobj = obj && obj != -1 ? $(obj) : this.get_container_ul();\n\t\t\t\tobj = obj.is(\"li\") ? obj.find(\"li\").addBack() : obj.find(\"li\");\n\t\t\t\tobj.removeClass(\"jstree-last\")\n\t\t\t\t\t.filter(\"li:last-child\").addClass(\"jstree-last\").end()\n\t\t\t\t\t.filter(\":has(li)\")\n\t\t\t\t\t\t.not(\".jstree-open\").removeClass(\"jstree-leaf\").addClass(\"jstree-closed\");\n\t\t\t\tobj.not(\".jstree-open, .jstree-closed\").addClass(\"jstree-leaf\").children(\"ul\").remove();\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\t// rollback\n\t\t\tget_rollback : function () {\n\t\t\t\tthis.__callback();\n\t\t\t\treturn { i : this.get_index(), h : this.get_container().children(\"ul\").clone(true), d : this.data };\n\t\t\t},\n\t\t\tset_rollback : function (html, data) {\n\t\t\t\tthis.get_container().empty().append(html);\n\t\t\t\tthis.data = data;\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\t// Dummy functions to be overwritten by any datastore plugin included\n\t\t\tload_node\t: function (obj, s_call, e_call) { this.__callback({ \"obj\" : obj }); },\n\t\t\t_is_loaded\t: function (obj) { return true; },\n\n\t\t\t// Basic operations: create\n\t\t\tcreate_node\t: function (obj, position, js, callback, is_loaded) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tposition = typeof position === \"undefined\" ? \"last\" : position;\n\t\t\t\tvar d = $(\"<li />\"),\n\t\t\t\t\ts = this._get_settings().core,\n\t\t\t\t\ttmp;\n\n\t\t\t\tif(obj !== -1 && !obj.length) { return false; }\n\t\t\t\tif(!is_loaded && !this._is_loaded(obj)) { this.load_node(obj, function () { this.create_node(obj, position, js, callback, true); }); return false; }\n\n\t\t\t\tthis.__rollback();\n\n\t\t\t\tif(typeof js === \"string\") { js = { \"data\" : js }; }\n\t\t\t\tif(!js) { js = {}; }\n\t\t\t\tif(js.attr) { d.attr(js.attr); }\n\t\t\t\tif(js.metadata) { d.data(js.metadata); }\n\t\t\t\tif(js.state) { d.addClass(\"jstree-\" + js.state); }\n\t\t\t\tif(!js.data) { js.data = this._get_string(\"new_node\"); }\n\t\t\t\tif(!$.isArray(js.data)) { tmp = js.data; js.data = []; js.data.push(tmp); }\n\t\t\t\t$.each(js.data, function (i, m) {\n\t\t\t\t\ttmp = $(\"<a />\");\n\t\t\t\t\tif($.isFunction(m)) { m = m.call(this, js); }\n\t\t\t\t\tif(typeof m == \"string\") { tmp.attr('href','#')[ s.html_titles ? \"html\" : \"text\" ](m); }\n\t\t\t\t\telse {\n\t\t\t\t\t\tif(!m.attr) { m.attr = {}; }\n\t\t\t\t\t\tif(!m.attr.href) { m.attr.href = '#'; }\n\t\t\t\t\t\ttmp.attr(m.attr)[ s.html_titles ? \"html\" : \"text\" ](m.title);\n\t\t\t\t\t\tif(m.language) { tmp.addClass(m.language); }\n\t\t\t\t\t}\n\t\t\t\t\ttmp.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\t\tif(!m.icon && js.icon) { m.icon = js.icon; }\n\t\t\t\t\tif(m.icon) {\n\t\t\t\t\t\tif(m.icon.indexOf(\"/\") === -1) { tmp.children(\"ins\").addClass(m.icon); }\n\t\t\t\t\t\telse { tmp.children(\"ins\").css(\"background\",\"url('\" + m.icon + \"') center center no-repeat\"); }\n\t\t\t\t\t}\n\t\t\t\t\td.append(tmp);\n\t\t\t\t});\n\t\t\t\td.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\tif(obj === -1) {\n\t\t\t\t\tobj = this.get_container();\n\t\t\t\t\tif(position === \"before\") { position = \"first\"; }\n\t\t\t\t\tif(position === \"after\") { position = \"last\"; }\n\t\t\t\t}\n\t\t\t\tswitch(position) {\n\t\t\t\t\tcase \"before\": obj.before(d); tmp = this._get_parent(obj); break;\n\t\t\t\t\tcase \"after\" : obj.after(d);  tmp = this._get_parent(obj); break;\n\t\t\t\t\tcase \"inside\":\n\t\t\t\t\tcase \"first\" :\n\t\t\t\t\t\tif(!obj.children(\"ul\").length) { obj.append(\"<ul />\"); }\n\t\t\t\t\t\tobj.children(\"ul\").prepend(d);\n\t\t\t\t\t\ttmp = obj;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"last\":\n\t\t\t\t\t\tif(!obj.children(\"ul\").length) { obj.append(\"<ul />\"); }\n\t\t\t\t\t\tobj.children(\"ul\").append(d);\n\t\t\t\t\t\ttmp = obj;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tif(!obj.children(\"ul\").length) { obj.append(\"<ul />\"); }\n\t\t\t\t\t\tif(!position) { position = 0; }\n\t\t\t\t\t\ttmp = obj.children(\"ul\").children(\"li\").eq(position);\n\t\t\t\t\t\tif(tmp.length) { tmp.before(d); }\n\t\t\t\t\t\telse { obj.children(\"ul\").append(d); }\n\t\t\t\t\t\ttmp = obj;\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tif(tmp === -1 || tmp.get(0) === this.get_container().get(0)) { tmp = -1; }\n\t\t\t\tthis.clean_node(tmp);\n\t\t\t\tthis.__callback({ \"obj\" : d, \"parent\" : tmp });\n\t\t\t\tif(callback) { callback.call(this, d); }\n\t\t\t\treturn d;\n\t\t\t},\n\t\t\t// Basic operations: rename (deal with text)\n\t\t\tget_text\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tvar s = this._get_settings().core.html_titles;\n\t\t\t\tobj = obj.children(\"a:eq(0)\");\n\t\t\t\tif(s) {\n\t\t\t\t\tobj = obj.clone();\n\t\t\t\t\tobj.children(\"INS\").remove();\n\t\t\t\t\treturn obj.html();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\treturn obj.nodeValue;\n\t\t\t\t}\n\t\t\t},\n\t\t\tset_text\t: function (obj, val) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tobj = obj.children(\"a:eq(0)\");\n\t\t\t\tif(this._get_settings().core.html_titles) {\n\t\t\t\t\tvar tmp = obj.children(\"INS\").clone();\n\t\t\t\t\tobj.html(val).prepend(tmp);\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val });\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val });\n\t\t\t\t\treturn (obj.nodeValue = val);\n\t\t\t\t}\n\t\t\t},\n\t\t\trename_node : function (obj, val) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tthis.__rollback();\n\t\t\t\tif(obj && obj.length && this.set_text.apply(this, Array.prototype.slice.call(arguments))) { this.__callback({ \"obj\" : obj, \"name\" : val }); }\n\t\t\t},\n\t\t\t// Basic operations: deleting nodes\n\t\t\tdelete_node : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tthis.__rollback();\n\t\t\t\tvar p = this._get_parent(obj), prev = $([]), t = this;\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tprev = prev.add(t._get_prev(this));\n\t\t\t\t});\n\t\t\t\tobj = obj.detach();\n\t\t\t\tif(p !== -1 && p.find(\"> ul > li\").length === 0) {\n\t\t\t\t\tp.removeClass(\"jstree-open jstree-closed\").addClass(\"jstree-leaf\");\n\t\t\t\t}\n\t\t\t\tthis.clean_node(p);\n\t\t\t\tthis.__callback({ \"obj\" : obj, \"prev\" : prev, \"parent\" : p });\n\t\t\t\treturn obj;\n\t\t\t},\n\t\t\tprepare_move : function (o, r, pos, cb, is_cb) {\n\t\t\t\tvar p = {};\n\n\t\t\t\tp.ot = $.jstree._reference(o) || this;\n\t\t\t\tp.o = p.ot._get_node(o);\n\t\t\t\tp.r = r === - 1 ? -1 : this._get_node(r);\n\t\t\t\tp.p = (typeof pos === \"undefined\" || pos === false) ? \"last\" : pos; // TODO: move to a setting\n\t\t\t\tif(!is_cb && prepared_move.o && prepared_move.o[0] === p.o[0] && prepared_move.r[0] === p.r[0] && prepared_move.p === p.p) {\n\t\t\t\t\tthis.__callback(prepared_move);\n\t\t\t\t\tif(cb) { cb.call(this, prepared_move); }\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tp.ot = $.jstree._reference(p.o) || this;\n\t\t\t\tp.rt = $.jstree._reference(p.r) || this; // r === -1 ? p.ot : $.jstree._reference(p.r) || this\n\t\t\t\tif(p.r === -1 || !p.r) {\n\t\t\t\t\tp.cr = -1;\n\t\t\t\t\tswitch(p.p) {\n\t\t\t\t\t\tcase \"first\":\n\t\t\t\t\t\tcase \"before\":\n\t\t\t\t\t\tcase \"inside\":\n\t\t\t\t\t\t\tp.cp = 0;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"after\":\n\t\t\t\t\t\tcase \"last\":\n\t\t\t\t\t\t\tp.cp = p.rt.get_container().find(\" > ul > li\").length;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\tp.cp = p.p;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(!/^(before|after)$/.test(p.p) && !this._is_loaded(p.r)) {\n\t\t\t\t\t\treturn this.load_node(p.r, function () { this.prepare_move(o, r, pos, cb, true); });\n\t\t\t\t\t}\n\t\t\t\t\tswitch(p.p) {\n\t\t\t\t\t\tcase \"before\":\n\t\t\t\t\t\t\tp.cp = p.r.index();\n\t\t\t\t\t\t\tp.cr = p.rt._get_parent(p.r);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"after\":\n\t\t\t\t\t\t\tp.cp = p.r.index() + 1;\n\t\t\t\t\t\t\tp.cr = p.rt._get_parent(p.r);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"inside\":\n\t\t\t\t\t\tcase \"first\":\n\t\t\t\t\t\t\tp.cp = 0;\n\t\t\t\t\t\t\tp.cr = p.r;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"last\":\n\t\t\t\t\t\t\tp.cp = p.r.find(\" > ul > li\").length;\n\t\t\t\t\t\t\tp.cr = p.r;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\tp.cp = p.p;\n\t\t\t\t\t\t\tp.cr = p.r;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tp.np = p.cr == -1 ? p.rt.get_container() : p.cr;\n\t\t\t\tp.op = p.ot._get_parent(p.o);\n\t\t\t\tp.cop = p.o.index();\n\t\t\t\tif(p.op === -1) { p.op = p.ot ? p.ot.get_container() : this.get_container(); }\n\t\t\t\tif(!/^(before|after)$/.test(p.p) && p.op && p.np && p.op[0] === p.np[0] && p.o.index() < p.cp) { p.cp++; }\n\t\t\t\t//if(p.p === \"before\" && p.op && p.np && p.op[0] === p.np[0] && p.o.index() < p.cp) { p.cp--; }\n\t\t\t\tp.or = p.np.find(\" > ul > li:nth-child(\" + (p.cp + 1) + \")\");\n\t\t\t\tprepared_move = p;\n\t\t\t\tthis.__callback(prepared_move);\n\t\t\t\tif(cb) { cb.call(this, prepared_move); }\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tvar obj = prepared_move, ret = true, r = obj.r === -1 ? this.get_container() : obj.r;\n\t\t\t\tif(!obj || !obj.o || obj.or[0] === obj.o[0]) { return false; }\n\t\t\t\tif(obj.op && obj.np && obj.op[0] === obj.np[0] && obj.cp - 1 === obj.o.index()) { return false; }\n\t\t\t\tobj.o.each(function () {\n\t\t\t\t\tif(r.parentsUntil(\".jstree\", \"li\").addBack().index(this) !== -1) { ret = false; return false; }\n\t\t\t\t});\n\t\t\t\treturn ret;\n\t\t\t},\n\t\t\tmove_node : function (obj, ref, position, is_copy, is_prepared, skip_check) {\n\t\t\t\tif(!is_prepared) {\n\t\t\t\t\treturn this.prepare_move(obj, ref, position, function (p) {\n\t\t\t\t\t\tthis.move_node(p, false, false, is_copy, true, skip_check);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tif(is_copy) {\n\t\t\t\t\tprepared_move.cy = true;\n\t\t\t\t}\n\t\t\t\tif(!skip_check && !this.check_move()) { return false; }\n\n\t\t\t\tthis.__rollback();\n\t\t\t\tvar o = false;\n\t\t\t\tif(is_copy) {\n\t\t\t\t\to = obj.o.clone(true);\n\t\t\t\t\to.find(\"*[id]\").addBack().each(function () {\n\t\t\t\t\t\tif(this.id) { this.id = \"copy_\" + this.id; }\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\telse { o = obj.o; }\n\n\t\t\t\tif(obj.or.length) { obj.or.before(o); }\n\t\t\t\telse {\n\t\t\t\t\tif(!obj.np.children(\"ul\").length) { $(\"<ul />\").appendTo(obj.np); }\n\t\t\t\t\tobj.np.children(\"ul:eq(0)\").append(o);\n\t\t\t\t}\n\n\t\t\t\ttry {\n\t\t\t\t\tobj.ot.clean_node(obj.op);\n\t\t\t\t\tobj.rt.clean_node(obj.np);\n\t\t\t\t\tif(!obj.op.find(\"> ul > li\").length) {\n\t\t\t\t\t\tobj.op.removeClass(\"jstree-open jstree-closed\").addClass(\"jstree-leaf\").children(\"ul\").remove();\n\t\t\t\t\t}\n\t\t\t\t} catch (e) { }\n\n\t\t\t\tif(is_copy) {\n\t\t\t\t\tprepared_move.cy = true;\n\t\t\t\t\tprepared_move.oc = o;\n\t\t\t\t}\n\t\t\t\tthis.__callback(prepared_move);\n\t\t\t\treturn prepared_move;\n\t\t\t},\n\t\t\t_get_move : function () { return prepared_move; }\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree ui plugin\n * This plugins handles selecting/deselecting/hovering/dehovering nodes\n */\n(function ($) {\n\tvar scrollbar_width, e1, e2;\n\t$(function() {\n\t\tif (/msie/.test(navigator.userAgent.toLowerCase())) {\n\t\t\te1 = $('<textarea cols=\"10\" rows=\"2\"></textarea>').css({ position: 'absolute', top: -1000, left: 0 }).appendTo('body');\n\t\t\te2 = $('<textarea cols=\"10\" rows=\"2\" style=\"overflow: hidden;\"></textarea>').css({ position: 'absolute', top: -1000, left: 0 }).appendTo('body');\n\t\t\tscrollbar_width = e1.width() - e2.width();\n\t\t\te1.add(e2).remove();\n\t\t}\n\t\telse {\n\t\t\te1 = $('<div />').css({ width: 100, height: 100, overflow: 'auto', position: 'absolute', top: -1000, left: 0 })\n\t\t\t\t\t.prependTo('body').append('<div />').find('div').css({ width: '100%', height: 200 });\n\t\t\tscrollbar_width = 100 - e1.width();\n\t\t\te1.parent().remove();\n\t\t}\n\t});\n\t$.jstree.plugin(\"ui\", {\n\t\t__init : function () {\n\t\t\tthis.data.ui.selected = $();\n\t\t\tthis.data.ui.last_selected = false;\n\t\t\tthis.data.ui.hovered = null;\n\t\t\tthis.data.ui.to_select = this.get_settings().ui.initially_select;\n\n\t\t\tthis.get_container()\n\t\t\t\t.delegate(\"a\", \"click.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\tevent.currentTarget.blur();\n\t\t\t\t\t\tif(!$(event.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.select_node(event.currentTarget, true, event);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseenter.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\tif(!$(event.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.hover_node(event.target);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseleave.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\tif(!$(event.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.dehover_node(event.target);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"reopen.jstree\", $.proxy(function () {\n\t\t\t\t\t\tthis.reselect();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"get_rollback.jstree\", $.proxy(function () {\n\t\t\t\t\t\tthis.dehover_node();\n\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"set_rollback.jstree\", $.proxy(function () {\n\t\t\t\t\t\tthis.reselect();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"close_node.jstree\", $.proxy(function (event, data) {\n\t\t\t\t\t\tvar s = this._get_settings().ui,\n\t\t\t\t\t\t\tobj = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\tclk = (obj && obj.length) ? obj.children(\"ul\").find(\"a.jstree-clicked\") : $(),\n\t\t\t\t\t\t\t_this = this;\n\t\t\t\t\t\tif(s.selected_parent_close === false || !clk.length) { return; }\n\t\t\t\t\t\tclk.each(function () {\n\t\t\t\t\t\t\t_this.deselect_node(this);\n\t\t\t\t\t\t\tif(s.selected_parent_close === \"select_parent\") { _this.select_node(obj); }\n\t\t\t\t\t\t});\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"delete_node.jstree\", $.proxy(function (event, data) {\n\t\t\t\t\t\tvar s = this._get_settings().ui.select_prev_on_delete,\n\t\t\t\t\t\t\tobj = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\tclk = (obj && obj.length) ? obj.find(\"a.jstree-clicked\") : [],\n\t\t\t\t\t\t\t_this = this;\n\t\t\t\t\t\tclk.each(function () { _this.deselect_node(this); });\n\t\t\t\t\t\tif(s && clk.length) {\n\t\t\t\t\t\t\tdata.rslt.prev.each(function () {\n\t\t\t\t\t\t\t\tif(this.parentNode) { _this.select_node(this); return false; /* if return false is removed all prev nodes will be selected */}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (event, data) {\n\t\t\t\t\t\tif(data.rslt.cy) {\n\t\t\t\t\t\t\tdata.rslt.oc.find(\"a.jstree-clicked\").removeClass(\"jstree-clicked\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tselect_limit : -1, // 0, 1, 2 ... or -1 for unlimited\n\t\t\tselect_multiple_modifier : \"ctrl\", // on, or ctrl, shift, alt\n\t\t\tselect_range_modifier : \"shift\",\n\t\t\tselected_parent_close : \"select_parent\", // false, \"deselect\", \"select_parent\"\n\t\t\tselected_parent_open : true,\n\t\t\tselect_prev_on_delete : true,\n\t\t\tdisable_selecting_children : false,\n\t\t\tinitially_select : []\n\t\t},\n\t\t_fn : {\n\t\t\t_get_node : function (obj, allow_multiple) {\n\t\t\t\tif(typeof obj === \"undefined\" || obj === null) { return allow_multiple ? this.data.ui.selected : this.data.ui.last_selected; }\n\t\t\t\tvar $obj = $(obj, this.get_container());\n\t\t\t\tif($obj.is(\".jstree\") || obj == -1) { return -1; }\n\t\t\t\t$obj = $obj.closest(\"li\", this.get_container());\n\t\t\t\treturn $obj.length ? $obj : false;\n\t\t\t},\n\t\t\t_ui_notify : function (n, data) {\n\t\t\t\tif(data.selected) {\n\t\t\t\t\tthis.select_node(n, false);\n\t\t\t\t}\n\t\t\t},\n\t\t\tsave_selected : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.data.ui.to_select = [];\n\t\t\t\tthis.data.ui.selected.each(function () { if(this.id) { _this.data.ui.to_select.push(\"#\" + this.id.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\")); } });\n\t\t\t\tthis.__callback(this.data.ui.to_select);\n\t\t\t},\n\t\t\treselect : function () {\n\t\t\t\tvar _this = this,\n\t\t\t\t\ts = this.data.ui.to_select;\n\t\t\t\ts = $.map($.makeArray(s), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t// this.deselect_all(); WHY deselect, breaks plugin state notifier?\n\t\t\t\t$.each(s, function (i, val) { if(val && val !== \"#\") { _this.select_node(val); } });\n\t\t\t\tthis.data.ui.selected = this.data.ui.selected.filter(function () { return this.parentNode; });\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\trefresh : function (obj) {\n\t\t\t\tthis.save_selected();\n\t\t\t\treturn this.__call_old();\n\t\t\t},\n\t\t\thover_node : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\t//if(this.data.ui.hovered && obj.get(0) === this.data.ui.hovered.get(0)) { return; }\n\t\t\t\tif(!obj.hasClass(\"jstree-hovered\")) { this.dehover_node(); }\n\t\t\t\tthis.data.ui.hovered = obj.children(\"a\").addClass(\"jstree-hovered\").parent();\n\t\t\t\tthis._fix_scroll(obj);\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tdehover_node : function () {\n\t\t\t\tvar obj = this.data.ui.hovered, p;\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tp = obj.children(\"a\").removeClass(\"jstree-hovered\").parent();\n\t\t\t\tif(this.data.ui.hovered[0] === p[0]) { this.data.ui.hovered = null; }\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tselect_node : function (obj, check, e) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj == -1 || !obj || !obj.length) { return false; }\n\t\t\t\tvar s = this._get_settings().ui,\n\t\t\t\t\tis_multiple = (s.select_multiple_modifier == \"on\" || (s.select_multiple_modifier !== false && e && e[s.select_multiple_modifier + \"Key\"])),\n\t\t\t\t\tis_range = (s.select_range_modifier !== false && e && e[s.select_range_modifier + \"Key\"] && this.data.ui.last_selected && this.data.ui.last_selected[0] !== obj[0] && this.data.ui.last_selected.parent()[0] === obj.parent()[0]),\n\t\t\t\t\tis_selected = this.is_selected(obj),\n\t\t\t\t\tproceed = true,\n\t\t\t\t\tt = this;\n\t\t\t\tif(check) {\n\t\t\t\t\tif(s.disable_selecting_children && is_multiple &&\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\t(obj.parentsUntil(\".jstree\",\"li\").children(\"a.jstree-clicked\").length) ||\n\t\t\t\t\t\t\t(obj.children(\"ul\").find(\"a.jstree-clicked:eq(0)\").length)\n\t\t\t\t\t\t)\n\t\t\t\t\t) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tproceed = false;\n\t\t\t\t\tswitch(!0) {\n\t\t\t\t\t\tcase (is_range):\n\t\t\t\t\t\t\tthis.data.ui.last_selected.addClass(\"jstree-last-selected\");\n\t\t\t\t\t\t\tobj = obj[ obj.index() < this.data.ui.last_selected.index() ? \"nextUntil\" : \"prevUntil\" ](\".jstree-last-selected\").addBack();\n\t\t\t\t\t\t\tif(s.select_limit == -1 || obj.length < s.select_limit) {\n\t\t\t\t\t\t\t\tthis.data.ui.last_selected.removeClass(\"jstree-last-selected\");\n\t\t\t\t\t\t\t\tthis.data.ui.selected.each(function () {\n\t\t\t\t\t\t\t\t\tif(this !== t.data.ui.last_selected[0]) { t.deselect_node(this); }\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\tis_selected = false;\n\t\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tproceed = false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (is_selected && !is_multiple):\n\t\t\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\t\t\tis_selected = false;\n\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (!is_selected && !is_multiple):\n\t\t\t\t\t\t\tif(s.select_limit == -1 || s.select_limit > 0) {\n\t\t\t\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (is_selected && is_multiple):\n\t\t\t\t\t\t\tthis.deselect_node(obj);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (!is_selected && is_multiple):\n\t\t\t\t\t\t\tif(s.select_limit == -1 || this.data.ui.selected.length + 1 <= s.select_limit) {\n\t\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(proceed && !is_selected) {\n\t\t\t\t\tif(!is_range) { this.data.ui.last_selected = obj; }\n\t\t\t\t\tobj.children(\"a\").addClass(\"jstree-clicked\");\n\t\t\t\t\tif(s.selected_parent_open) {\n\t\t\t\t\t\tobj.parents(\".jstree-closed\").each(function () { t.open_node(this, false, true); });\n\t\t\t\t\t}\n\t\t\t\t\tthis.data.ui.selected = this.data.ui.selected.add(obj);\n\t\t\t\t\tthis._fix_scroll(obj.eq(0));\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"e\" : e });\n\t\t\t\t}\n\t\t\t},\n\t\t\t_fix_scroll : function (obj) {\n\t\t\t\tvar c = this.get_container()[0], t;\n\t\t\t\tif(c.scrollHeight > c.offsetHeight) {\n\t\t\t\t\tobj = this._get_node(obj);\n\t\t\t\t\tif(!obj || obj === -1 || !obj.length || !obj.is(\":visible\")) { return; }\n\t\t\t\t\tt = obj.offset().top - this.get_container().offset().top;\n\t\t\t\t\tif(t < 0) {\n\t\t\t\t\t\tc.scrollTop = c.scrollTop + t - 1;\n\t\t\t\t\t}\n\t\t\t\t\tif(t + this.data.core.li_height + (c.scrollWidth > c.offsetWidth ? scrollbar_width : 0) > c.offsetHeight) {\n\t\t\t\t\t\tc.scrollTop = c.scrollTop + (t - c.offsetHeight + this.data.core.li_height + 1 + (c.scrollWidth > c.offsetWidth ? scrollbar_width : 0));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tdeselect_node : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(this.is_selected(obj)) {\n\t\t\t\t\tobj.children(\"a\").removeClass(\"jstree-clicked\");\n\t\t\t\t\tthis.data.ui.selected = this.data.ui.selected.not(obj);\n\t\t\t\t\tif(this.data.ui.last_selected.get(0) === obj.get(0)) { this.data.ui.last_selected = this.data.ui.selected.eq(0); }\n\t\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t\t}\n\t\t\t},\n\t\t\ttoggle_select : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(this.is_selected(obj)) { this.deselect_node(obj); }\n\t\t\t\telse { this.select_node(obj); }\n\t\t\t},\n\t\t\tis_selected : function (obj) { return this.data.ui.selected.index(this._get_node(obj)) >= 0; },\n\t\t\tget_selected : function (context) {\n\t\t\t\treturn context ? $(context).find(\"a.jstree-clicked\").parent() : this.data.ui.selected;\n\t\t\t},\n\t\t\tdeselect_all : function (context) {\n\t\t\t\tvar ret = context ? $(context).find(\"a.jstree-clicked\").parent() : this.get_container().find(\"a.jstree-clicked\").parent();\n\t\t\t\tret.children(\"a.jstree-clicked\").removeClass(\"jstree-clicked\");\n\t\t\t\tthis.data.ui.selected = $([]);\n\t\t\t\tthis.data.ui.last_selected = false;\n\t\t\t\tthis.__callback({ \"obj\" : ret });\n\t\t\t}\n\t\t}\n\t});\n\t// include the selection plugin by default\n\t$.jstree.defaults.plugins.push(\"ui\");\n})(jQuery);\n//*/\n\n/*\n * jsTree CRRM plugin\n * Handles creating/renaming/removing/moving nodes by user interaction.\n */\n(function ($) {\n\t$.jstree.plugin(\"crrm\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\tif(this._get_settings().crrm.move.open_onmove) {\n\t\t\t\t\t\tvar t = this;\n\t\t\t\t\t\tdata.rslt.np.parentsUntil(\".jstree\").addBack().filter(\".jstree-closed\").each(function () {\n\t\t\t\t\t\t\tt.open_node(this, false, true);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tinput_width_limit : 200,\n\t\t\tmove : {\n\t\t\t\talways_copy\t\t\t: false, // false, true or \"multitree\"\n\t\t\t\topen_onmove\t\t\t: true,\n\t\t\t\tdefault_position\t: \"last\",\n\t\t\t\tcheck_move\t\t\t: function (m) { return true; }\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\t_show_input : function (obj, callback) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar rtl = this._get_settings().core.rtl,\n\t\t\t\t\tw = this._get_settings().crrm.input_width_limit,\n\t\t\t\t\tw1 = obj.children(\"ins\").width(),\n\t\t\t\t\tw2 = obj.find(\"> a:visible > ins\").width() * obj.find(\"> a:visible > ins\").length,\n\t\t\t\t\tt = this.get_text(obj),\n\t\t\t\t\th1 = $(\"<div />\", { css : { \"position\" : \"absolute\", \"top\" : \"-200px\", \"left\" : (rtl ? \"0px\" : \"-1000px\"), \"visibility\" : \"hidden\" } }).appendTo(\"body\"),\n\t\t\t\t\th2 = obj.css(\"position\",\"relative\").append(\n\t\t\t\t\t$(\"<input />\", {\n\t\t\t\t\t\t\"value\" : t,\n\t\t\t\t\t\t\"class\" : \"jstree-rename-input\",\n\t\t\t\t\t\t// \"size\" : t.length,\n\t\t\t\t\t\t\"css\" : {\n\t\t\t\t\t\t\t\"padding\" : \"0\",\n\t\t\t\t\t\t\t\"border\" : \"1px solid silver\",\n\t\t\t\t\t\t\t\"position\" : \"absolute\",\n\t\t\t\t\t\t\t\"left\"  : (rtl ? \"auto\" : (w1 + w2 + 4) + \"px\"),\n\t\t\t\t\t\t\t\"right\" : (rtl ? (w1 + w2 + 4) + \"px\" : \"auto\"),\n\t\t\t\t\t\t\t\"top\" : \"0px\",\n\t\t\t\t\t\t\t\"height\" : (this.data.core.li_height - 2) + \"px\",\n\t\t\t\t\t\t\t\"lineHeight\" : (this.data.core.li_height - 2) + \"px\",\n\t\t\t\t\t\t\t\"width\" : \"150px\" // will be set a bit further down\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"blur\" : $.proxy(function () {\n\t\t\t\t\t\t\tvar i = obj.children(\".jstree-rename-input\"),\n\t\t\t\t\t\t\t\tv = i.val();\n\t\t\t\t\t\t\tif(v === \"\") { v = t; }\n\t\t\t\t\t\t\th1.remove();\n\t\t\t\t\t\t\ti.remove(); // rollback purposes\n\t\t\t\t\t\t\tthis.set_text(obj,t); // rollback purposes\n\t\t\t\t\t\t\tthis.rename_node(obj, v);\n\t\t\t\t\t\t\tcallback.call(this, obj, v, t);\n\t\t\t\t\t\t\tobj.css(\"position\",\"\");\n\t\t\t\t\t\t}, this),\n\t\t\t\t\t\t\"keyup\" : function (event) {\n\t\t\t\t\t\t\tvar key = event.keyCode || event.which;\n\t\t\t\t\t\t\tif(key == 27) { this.value = t; this.blur(); return; }\n\t\t\t\t\t\t\telse if(key == 13) { this.blur(); return; }\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\th2.width(Math.min(h1.text(\"pW\" + this.value).width(),w));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"keypress\" : function(event) {\n\t\t\t\t\t\t\tvar key = event.keyCode || event.which;\n\t\t\t\t\t\t\tif(key == 13) { return false; }\n\t\t\t\t\t\t}\n\t\t\t\t\t})\n\t\t\t\t).children(\".jstree-rename-input\");\n\t\t\t\tthis.set_text(obj, \"\");\n\t\t\t\th1.css({\n\t\t\t\t\t\tfontFamily\t\t: h2.css('fontFamily')\t\t|| '',\n\t\t\t\t\t\tfontSize\t\t: h2.css('fontSize')\t\t|| '',\n\t\t\t\t\t\tfontWeight\t\t: h2.css('fontWeight')\t\t|| '',\n\t\t\t\t\t\tfontStyle\t\t: h2.css('fontStyle')\t\t|| '',\n\t\t\t\t\t\tfontStretch\t\t: h2.css('fontStretch')\t\t|| '',\n\t\t\t\t\t\tfontVariant\t\t: h2.css('fontVariant')\t\t|| '',\n\t\t\t\t\t\tletterSpacing\t: h2.css('letterSpacing')\t|| '',\n\t\t\t\t\t\twordSpacing\t\t: h2.css('wordSpacing')\t\t|| ''\n\t\t\t\t});\n\t\t\t\th2.width(Math.min(h1.text(\"pW\" + h2[0].value).width(),w))[0].select();\n\t\t\t},\n\t\t\trename : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tthis.__rollback();\n\t\t\t\tvar f = this.__callback;\n\t\t\t\tthis._show_input(obj, function (obj, new_name, old_name) {\n\t\t\t\t\tf.call(this, { \"obj\" : obj, \"new_name\" : new_name, \"old_name\" : old_name });\n\t\t\t\t});\n\t\t\t},\n\t\t\tcreate : function (obj, position, js, callback, skip_rename) {\n\t\t\t\tvar t, _this = this;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj) { obj = -1; }\n\t\t\t\tthis.__rollback();\n\t\t\t\tt = this.create_node(obj, position, js, function (t) {\n\t\t\t\t\tvar p = this._get_parent(t),\n\t\t\t\t\t\tpos = $(t).index();\n\t\t\t\t\tif(callback) { callback.call(this, t); }\n\t\t\t\t\tif(p.length && p.hasClass(\"jstree-closed\")) { this.open_node(p, false, true); }\n\t\t\t\t\tif(!skip_rename) {\n\t\t\t\t\t\tthis._show_input(t, function (obj, new_name, old_name) {\n\t\t\t\t\t\t\t_this.__callback({ \"obj\" : obj, \"name\" : new_name, \"parent\" : p, \"position\" : pos });\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t\telse { _this.__callback({ \"obj\" : t, \"name\" : this.get_text(t), \"parent\" : p, \"position\" : pos }); }\n\t\t\t\t});\n\t\t\t\treturn t;\n\t\t\t},\n\t\t\tremove : function (obj) {\n\t\t\t\tobj = this._get_node(obj, true);\n\t\t\t\tvar p = this._get_parent(obj), prev = this._get_prev(obj);\n\t\t\t\tthis.__rollback();\n\t\t\t\tobj = this.delete_node(obj);\n\t\t\t\tif(obj !== false) { this.__callback({ \"obj\" : obj, \"prev\" : prev, \"parent\" : p }); }\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tif(!this.__call_old()) { return false; }\n\t\t\t\tvar s = this._get_settings().crrm.move;\n\t\t\t\tif(!s.check_move.call(this, this._get_move())) { return false; }\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tmove_node : function (obj, ref, position, is_copy, is_prepared, skip_check) {\n\t\t\t\tvar s = this._get_settings().crrm.move;\n\t\t\t\tif(!is_prepared) {\n\t\t\t\t\tif(typeof position === \"undefined\") { position = s.default_position; }\n\t\t\t\t\tif(position === \"inside\" && !s.default_position.match(/^(before|after)$/)) { position = s.default_position; }\n\t\t\t\t\treturn this.__call_old(true, obj, ref, position, is_copy, false, skip_check);\n\t\t\t\t}\n\t\t\t\t// if the move is already prepared\n\t\t\t\tif(s.always_copy === true || (s.always_copy === \"multitree\" && obj.rt.get_index() !== obj.ot.get_index() )) {\n\t\t\t\t\tis_copy = true;\n\t\t\t\t}\n\t\t\t\tthis.__call_old(true, obj, ref, position, is_copy, true, skip_check);\n\t\t\t},\n\n\t\t\tcut : function (obj) {\n\t\t\t\tobj = this._get_node(obj, true);\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tthis.data.crrm.cp_nodes = false;\n\t\t\t\tthis.data.crrm.ct_nodes = obj;\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tcopy : function (obj) {\n\t\t\t\tobj = this._get_node(obj, true);\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tthis.data.crrm.ct_nodes = false;\n\t\t\t\tthis.data.crrm.cp_nodes = obj;\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tpaste : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tvar nodes = this.data.crrm.ct_nodes ? this.data.crrm.ct_nodes : this.data.crrm.cp_nodes;\n\t\t\t\tif(!this.data.crrm.ct_nodes && !this.data.crrm.cp_nodes) { return false; }\n\t\t\t\tif(this.data.crrm.ct_nodes) { this.move_node(this.data.crrm.ct_nodes, obj); this.data.crrm.ct_nodes = false; }\n\t\t\t\tif(this.data.crrm.cp_nodes) { this.move_node(this.data.crrm.cp_nodes, obj, false, true); }\n\t\t\t\tthis.__callback({ \"obj\" : obj, \"nodes\" : nodes });\n\t\t\t}\n\t\t}\n\t});\n\t// include the crr plugin by default\n\t// $.jstree.defaults.plugins.push(\"crrm\");\n})(jQuery);\n//*/\n\n/*\n * jsTree themes plugin\n * Handles loading and setting themes, as well as detecting path to themes, etc.\n */\n(function ($) {\n\tvar themes_loaded = [];\n\t// this variable stores the path to the themes folder - if left as false - it will be autodetected\n\t$.jstree._themes = false;\n\t$.jstree.plugin(\"themes\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function () {\n\t\t\t\t\t\tvar s = this._get_settings().themes;\n\t\t\t\t\t\tthis.data.themes.dots = s.dots;\n\t\t\t\t\t\tthis.data.themes.icons = s.icons;\n\t\t\t\t\t\tthis.set_theme(s.theme, s.url);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"loaded.jstree\", $.proxy(function () {\n\t\t\t\t\t\t// bound here too, as simple HTML tree's won't honor dots & icons otherwise\n\t\t\t\t\t\tif(!this.data.themes.dots) { this.hide_dots(); }\n\t\t\t\t\t\telse { this.show_dots(); }\n\t\t\t\t\t\tif(!this.data.themes.icons) { this.hide_icons(); }\n\t\t\t\t\t\telse { this.show_icons(); }\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\ttheme : \"default\",\n\t\t\turl : false,\n\t\t\tdots : false,\n\t\t\ticons : true\n\t\t},\n\t\t_fn : {\n\t\t\tset_theme : function (theme_name, theme_url) {\n\t\t\t\tif(!theme_name) { return false; }\n\t\t\t\tif(!theme_url) { theme_url = $.jstree._themes + theme_name + '/style.css'; }\n\t\t\t\tif($.inArray(theme_url, themes_loaded) == -1) {\n\t\t\t\t\t// $.vakata.css.add_sheet({ \"url\" : theme_url });\n\t\t\t\t\tthemes_loaded.push(theme_url);\n\t\t\t\t}\n\t\t\t\tif(this.data.themes.theme != theme_name) {\n\t\t\t\t\tthis.get_container().removeClass('jstree-' + this.data.themes.theme);\n\t\t\t\t\tthis.data.themes.theme = theme_name;\n\t\t\t\t}\n\t\t\t\tthis.get_container().addClass('jstree-' + theme_name);\n\t\t\t\tif(!this.data.themes.dots) { this.hide_dots(); }\n\t\t\t\telse { this.show_dots(); }\n\t\t\t\tif(!this.data.themes.icons) { this.hide_icons(); }\n\t\t\t\telse { this.show_icons(); }\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\tget_theme\t: function () { return this.data.themes.theme; },\n\n\t\t\tshow_dots\t: function () { this.data.themes.dots = true; this.get_container().children(\"ul\").removeClass(\"jstree-no-dots\"); },\n\t\t\thide_dots\t: function () { this.data.themes.dots = false; this.get_container().children(\"ul\").addClass(\"jstree-no-dots\"); },\n\t\t\ttoggle_dots\t: function () { if(this.data.themes.dots) { this.hide_dots(); } else { this.show_dots(); } },\n\n\t\t\tshow_icons\t: function () { this.data.themes.icons = true; this.get_container().children(\"ul\").removeClass(\"jstree-no-icons\"); },\n\t\t\thide_icons\t: function () { this.data.themes.icons = false; this.get_container().children(\"ul\").addClass(\"jstree-no-icons\"); },\n\t\t\ttoggle_icons: function () { if(this.data.themes.icons) { this.hide_icons(); } else { this.show_icons(); } }\n\t\t}\n\t});\n\t// autodetect themes path\n\t$(function () {\n\t\tif($.jstree._themes === false) {\n\t\t\t$(\"script\").each(function () {\n\t\t\t\tif(this.src.toString().match(/jquery\\.jstree[^\\/]*?\\.js(\\?.*)?$/)) {\n\t\t\t\t\t$.jstree._themes = this.src.toString().replace(/jquery\\.jstree[^\\/]*?\\.js(\\?.*)?$/, \"\") + 'themes/';\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t\tif($.jstree._themes === false) { $.jstree._themes = \"themes/\"; }\n\t});\n\t// include the themes plugin by default\n\t$.jstree.defaults.plugins.push(\"themes\");\n})(jQuery);\n//*/\n\n/*\n * jsTree hotkeys plugin\n * Enables keyboard navigation for all tree instances\n * Depends on the jstree ui & jquery hotkeys plugins\n */\n(function ($) {\n\tvar bound = [];\n\tfunction exec(i, event) {\n\t\tvar f = $.jstree._focused(), tmp;\n\t\tif(f && f.data && f.data.hotkeys && f.data.hotkeys.enabled) {\n\t\t\ttmp = f._get_settings().hotkeys[i];\n\t\t\tif(tmp) { return tmp.call(f, event); }\n\t\t}\n\t}\n\t$.jstree.plugin(\"hotkeys\", {\n\t\t__init : function () {\n\t\t\tif(typeof $.hotkeys === \"undefined\") { throw \"jsTree hotkeys: jQuery hotkeys plugin not included.\"; }\n\t\t\tif(!this.data.ui) { throw \"jsTree hotkeys: jsTree UI plugin not included.\"; }\n\t\t\t$.each(this._get_settings().hotkeys, function (i, v) {\n\t\t\t\tif(v !== false && $.inArray(i, bound) == -1) {\n\t\t\t\t\t$(document).bind(\"keydown\", i, function (event) { return exec(i, event); });\n\t\t\t\t\tbound.push(i);\n\t\t\t\t}\n\t\t\t});\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"lock.jstree\", $.proxy(function () {\n\t\t\t\t\t\tif(this.data.hotkeys.enabled) { this.data.hotkeys.enabled = false; this.data.hotkeys.revert = true; }\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"unlock.jstree\", $.proxy(function () {\n\t\t\t\t\t\tif(this.data.hotkeys.revert) { this.data.hotkeys.enabled = true; }\n\t\t\t\t\t}, this));\n\t\t\tthis.enable_hotkeys();\n\t\t},\n\t\tdefaults : {\n\t\t\t\"up\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_prev(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+up\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_prev(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+up\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_prev(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"down\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_next(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+down\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_next(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+down\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_next(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"left\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o) {\n\t\t\t\t\tif(o.hasClass(\"jstree-open\")) { this.close_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_prev(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+left\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o) {\n\t\t\t\t\tif(o.hasClass(\"jstree-open\")) { this.close_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_prev(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+left\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o) {\n\t\t\t\t\tif(o.hasClass(\"jstree-open\")) { this.close_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_prev(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"right\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o && o.length) {\n\t\t\t\t\tif(o.hasClass(\"jstree-closed\")) { this.open_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_next(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+right\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o && o.length) {\n\t\t\t\t\tif(o.hasClass(\"jstree-closed\")) { this.open_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_next(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+right\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o && o.length) {\n\t\t\t\t\tif(o.hasClass(\"jstree-closed\")) { this.open_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_next(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"space\" : function () {\n\t\t\t\tif(this.data.ui.hovered) { this.data.ui.hovered.children(\"a:eq(0)\").click(); }\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+space\" : function (event) {\n\t\t\t\tevent.type = \"click\";\n\t\t\t\tif(this.data.ui.hovered) { this.data.ui.hovered.children(\"a:eq(0)\").trigger(event); }\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+space\" : function (event) {\n\t\t\t\tevent.type = \"click\";\n\t\t\t\tif(this.data.ui.hovered) { this.data.ui.hovered.children(\"a:eq(0)\").trigger(event); }\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"f2\" : function () { this.rename(this.data.ui.hovered || this.data.ui.last_selected); },\n\t\t\t\"del\" : function () { this.remove(this.data.ui.hovered || this._get_node(null)); }\n\t\t},\n\t\t_fn : {\n\t\t\tenable_hotkeys : function () {\n\t\t\t\tthis.data.hotkeys.enabled = true;\n\t\t\t},\n\t\t\tdisable_hotkeys : function () {\n\t\t\t\tthis.data.hotkeys.enabled = false;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree JSON plugin\n * The JSON data store. Datastores are build by overriding the `load_node` and `_is_loaded` functions.\n */\n(function ($) {\n\t$.jstree.plugin(\"json_data\", {\n\t\t__init : function() {\n\t\t\tvar s = this._get_settings().json_data;\n\t\t\tif(s.progressive_unload) {\n\t\t\t\tthis.get_container().bind(\"after_close.jstree\", function (e, data) {\n\t\t\t\t\tdata.rslt.obj.children(\"ul\").remove();\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\t// `data` can be a function:\n\t\t\t//  * accepts two arguments - node being loaded and a callback to pass the result to\n\t\t\t//  * will be executed in the current tree's scope & ajax won't be supported\n\t\t\tdata : false,\n\t\t\tajax : false,\n\t\t\tcorrect_state : true,\n\t\t\tprogressive_render : false,\n\t\t\tprogressive_unload : false\n\t\t},\n\t\t_fn : {\n\t\t\tload_node : function (obj, s_call, e_call) { var _this = this; this.load_node_json(obj, function () { _this.__callback({ \"obj\" : _this._get_node(obj) }); s_call.call(this); }, e_call); },\n\t\t\t_is_loaded : function (obj) {\n\t\t\t\tvar s = this._get_settings().json_data;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj == -1 || !obj || (!s.ajax && !s.progressive_render && !$.isFunction(s.data)) || obj.is(\".jstree-open, .jstree-leaf\") || obj.children(\"ul\").children(\"li\").length > 0;\n\t\t\t},\n\t\t\trefresh : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar s = this._get_settings().json_data;\n\t\t\t\tif(obj && obj !== -1 && s.progressive_unload && ($.isFunction(s.data) || !!s.ajax)) {\n\t\t\t\t\tobj.removeData(\"jstree_children\");\n\t\t\t\t}\n\t\t\t\treturn this.__call_old();\n\t\t\t},\n\t\t\tload_node_json : function (obj, s_call, e_call) {\n\t\t\t\tvar s = this.get_settings().json_data, d,\n\t\t\t\t\terror_func = function () {},\n\t\t\t\t\tsuccess_func = function () {};\n\t\t\t\tobj = this._get_node(obj);\n\n\t\t\t\tif(obj && obj !== -1 && (s.progressive_render || s.progressive_unload) && !obj.is(\".jstree-open, .jstree-leaf\") && obj.children(\"ul\").children(\"li\").length === 0 && obj.data(\"jstree_children\")) {\n\t\t\t\t\td = this._parse_json(obj.data(\"jstree_children\"), obj);\n\t\t\t\t\tif(d) {\n\t\t\t\t\t\tobj.append(d);\n\t\t\t\t\t\tif(!s.progressive_unload) { obj.removeData(\"jstree_children\"); }\n\t\t\t\t\t}\n\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\tif(obj.data(\"jstree_is_loading\")) { return; }\n\t\t\t\t\telse { obj.data(\"jstree_is_loading\",true); }\n\t\t\t\t}\n\t\t\t\tswitch(!0) {\n\t\t\t\t\tcase (!s.data && !s.ajax): throw \"Neither data nor ajax settings supplied.\";\n\t\t\t\t\t// function option added here for easier model integration (also supporting async - see callback)\n\t\t\t\t\tcase ($.isFunction(s.data)):\n\t\t\t\t\t\ts.data.call(this, obj, $.proxy(function (d) {\n\t\t\t\t\t\t\td = this._parse_json(d, obj);\n\t\t\t\t\t\t\tif(!d) {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\telse { obj.append(d).children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this));\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!!s.data && !s.ajax) || (!!s.data && !!s.ajax && (!obj || obj === -1)):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\td = this._parse_json(s.data, obj);\n\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty().append(d.children());\n\t\t\t\t\t\t\t\tthis.clean_node();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !!s.ajax) || (!!s.data && !!s.ajax && obj && obj !== -1):\n\t\t\t\t\t\terror_func = function (x, t, e) {\n\t\t\t\t\t\t\tvar ef = this.get_settings().json_data.ajax.error;\n\t\t\t\t\t\t\tif(ef) { ef.call(this, x, t, e); }\n\t\t\t\t\t\t\tif(obj != -1 && obj.length) {\n\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t};\n\t\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\t\tvar sf = this.get_settings().json_data.ajax.success;\n\t\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\t\tif(d === \"\" || (d && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") === \"\") || (!$.isArray(d) && !$.isPlainObject(d))) {\n\t\t\t\t\t\t\t\treturn error_func.call(this, x, t, \"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\td = this._parse_json(d, obj);\n\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\telse { obj.append(d).children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\t\tif(!s.ajax.dataType) { s.ajax.dataType = \"json\"; }\n\t\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, obj); }\n\t\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, obj); }\n\t\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\t_parse_json : function (js, obj, is_callback) {\n\t\t\t\tvar d = false,\n\t\t\t\t\tp = this._get_settings(),\n\t\t\t\t\ts = p.json_data,\n\t\t\t\t\tt = p.core.html_titles,\n\t\t\t\t\ttmp, i, j, ul1, ul2;\n\n\t\t\t\tif(!js) { return d; }\n\t\t\t\tif(s.progressive_unload && obj && obj !== -1) {\n\t\t\t\t\tobj.data(\"jstree_children\", d);\n\t\t\t\t}\n\t\t\t\tif($.isArray(js)) {\n\t\t\t\t\td = $();\n\t\t\t\t\tif(!js.length) { return false; }\n\t\t\t\t\tfor(i = 0, j = js.length; i < j; i++) {\n\t\t\t\t\t\ttmp = this._parse_json(js[i], obj, true);\n\t\t\t\t\t\tif(tmp.length) { d = d.add(tmp); }\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(typeof js == \"string\") { js = { data : js }; }\n\t\t\t\t\tif(!js.data && js.data !== \"\") { return d; }\n\t\t\t\t\td = $(\"<li />\");\n\t\t\t\t\tif(js.attr) { d.attr(js.attr); }\n\t\t\t\t\tif(js.metadata) { d.data(js.metadata); }\n\t\t\t\t\tif(js.state) { d.addClass(\"jstree-\" + js.state); }\n\t\t\t\t\tif(!$.isArray(js.data)) { tmp = js.data; js.data = []; js.data.push(tmp); }\n\t\t\t\t\t$.each(js.data, function (i, m) {\n\t\t\t\t\t\ttmp = $(\"<a />\");\n\t\t\t\t\t\tif($.isFunction(m)) { m = m.call(this, js); }\n\t\t\t\t\t\tif(typeof m == \"string\") { tmp.attr('href','#')[ t ? \"html\" : \"text\" ](m); }\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif(!m.attr) { m.attr = {}; }\n\t\t\t\t\t\t\tif(!m.attr.href) { m.attr.href = '#'; }\n\t\t\t\t\t\t\ttmp.attr(m.attr)[ t ? \"html\" : \"text\" ](m.title);\n\t\t\t\t\t\t\tif(m.language) { tmp.addClass(m.language); }\n\t\t\t\t\t\t}\n\t\t\t\t\t\ttmp.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\t\t\tif(!m.icon && js.icon) { m.icon = js.icon; }\n\t\t\t\t\t\tif(m.icon) {\n\t\t\t\t\t\t\tif(m.icon.indexOf(\"/\") === -1) { tmp.children(\"ins\").addClass(m.icon); }\n\t\t\t\t\t\t\telse { tmp.children(\"ins\").css(\"background\",\"url('\" + m.icon + \"') center center no-repeat\"); }\n\t\t\t\t\t\t}\n\t\t\t\t\t\td.append(tmp);\n\t\t\t\t\t});\n\t\t\t\t\td.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\t\tif(js.children) {\n\t\t\t\t\t\tif(s.progressive_render && js.state !== \"open\") {\n\t\t\t\t\t\t\td.addClass(\"jstree-closed\").data(\"jstree_children\", js.children);\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif(s.progressive_unload) { d.data(\"jstree_children\", js.children); }\n\t\t\t\t\t\t\tif($.isArray(js.children) && js.children.length) {\n\t\t\t\t\t\t\t\ttmp = this._parse_json(js.children, obj, true);\n\t\t\t\t\t\t\t\tif(tmp.length) {\n\t\t\t\t\t\t\t\t\tul2 = $(\"<ul />\");\n\t\t\t\t\t\t\t\t\tul2.append(tmp);\n\t\t\t\t\t\t\t\t\td.append(ul2);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(!is_callback) {\n\t\t\t\t\tul1 = $(\"<ul />\");\n\t\t\t\t\tul1.append(d);\n\t\t\t\t\td = ul1;\n\t\t\t\t}\n\t\t\t\treturn d;\n\t\t\t},\n\t\t\tget_json : function (obj, li_attr, a_attr, is_callback) {\n\t\t\t\tvar result = [],\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this,\n\t\t\t\t\ttmp1, tmp2, li, a, t, lang;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container().find(\"> ul > li\"); }\n\t\t\t\tli_attr = $.isArray(li_attr) ? li_attr : [ \"id\", \"class\" ];\n\t\t\t\tif(!is_callback && this.data.types) { li_attr.push(s.types.type_attr); }\n\t\t\t\ta_attr = $.isArray(a_attr) ? a_attr : [ ];\n\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tli = $(this);\n\t\t\t\t\ttmp1 = { data : [] };\n\t\t\t\t\tif(li_attr.length) { tmp1.attr = { }; }\n\t\t\t\t\t$.each(li_attr, function (i, v) {\n\t\t\t\t\t\ttmp2 = li.attr(v);\n\t\t\t\t\t\tif(tmp2 && tmp2.length && tmp2.replace(/jstree[^ ]*/ig,'').length) {\n\t\t\t\t\t\t\ttmp1.attr[v] = (\" \" + tmp2).replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\");\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tif(li.hasClass(\"jstree-open\")) { tmp1.state = \"open\"; }\n\t\t\t\t\tif(li.hasClass(\"jstree-closed\")) { tmp1.state = \"closed\"; }\n\t\t\t\t\tif(li.data()) { tmp1.metadata = li.data(); }\n\t\t\t\t\ta = li.children(\"a\");\n\t\t\t\t\ta.each(function () {\n\t\t\t\t\t\tt = $(this);\n\t\t\t\t\t\tif(\n\t\t\t\t\t\t\ta_attr.length ||\n\t\t\t\t\t\t\t$.inArray(\"languages\", s.plugins) !== -1 ||\n\t\t\t\t\t\t\tt.children(\"ins\").get(0).style.backgroundImage.length ||\n\t\t\t\t\t\t\t(t.children(\"ins\").get(0).className && t.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').length)\n\t\t\t\t\t\t) {\n\t\t\t\t\t\t\tlang = false;\n\t\t\t\t\t\t\tif($.inArray(\"languages\", s.plugins) !== -1 && $.isArray(s.languages) && s.languages.length) {\n\t\t\t\t\t\t\t\t$.each(s.languages, function (l, lv) {\n\t\t\t\t\t\t\t\t\tif(t.hasClass(lv)) {\n\t\t\t\t\t\t\t\t\t\tlang = lv;\n\t\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\ttmp2 = { attr : { }, title : _this.get_text(t, lang) };\n\t\t\t\t\t\t\t$.each(a_attr, function (k, z) {\n\t\t\t\t\t\t\t\ttmp2.attr[z] = (\" \" + (t.attr(z) || \"\")).replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\");\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tif($.inArray(\"languages\", s.plugins) !== -1 && $.isArray(s.languages) && s.languages.length) {\n\t\t\t\t\t\t\t\t$.each(s.languages, function (k, z) {\n\t\t\t\t\t\t\t\t\tif(t.hasClass(z)) { tmp2.language = z; return true; }\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(t.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/^\\s+$/ig,\"\").length) {\n\t\t\t\t\t\t\t\ttmp2.icon = t.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(t.children(\"ins\").get(0).style.backgroundImage.length) {\n\t\t\t\t\t\t\t\ttmp2.icon = t.children(\"ins\").get(0).style.backgroundImage.replace(\"url(\",\"\").replace(\")\",\"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\ttmp2 = _this.get_text(t);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(a.length > 1) { tmp1.data.push(tmp2); }\n\t\t\t\t\t\telse { tmp1.data = tmp2; }\n\t\t\t\t\t});\n\t\t\t\t\tli = li.find(\"> ul > li\");\n\t\t\t\t\tif(li.length) { tmp1.children = _this.get_json(li, li_attr, a_attr, true); }\n\t\t\t\t\tresult.push(tmp1);\n\t\t\t\t});\n\t\t\t\treturn result;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree languages plugin\n * Adds support for multiple language versions in one tree\n * This basically allows for many titles coexisting in one node, but only one of them being visible at any given time\n * This is useful for maintaining the same structure in many languages (hence the name of the plugin)\n */\n(function ($) {\n\t$.jstree.plugin(\"languages\", {\n\t\t__init : function () { this._load_css();  },\n\t\tdefaults : [],\n\t\t_fn : {\n\t\t\tset_lang : function (i) {\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\tst = false,\n\t\t\t\t\tselector = \".jstree-\" + this.get_index() + ' a';\n\t\t\t\tif(!$.isArray(langs) || langs.length === 0) { return false; }\n\t\t\t\tif($.inArray(i,langs) == -1) {\n\t\t\t\t\tif(!!langs[i]) { i = langs[i]; }\n\t\t\t\t\telse { return false; }\n\t\t\t\t}\n\t\t\t\tif(i == this.data.languages.current_language) { return true; }\n\t\t\t\tst = $.vakata.css.get_css(selector + \".\" + this.data.languages.current_language, false, this.data.languages.language_css);\n\t\t\t\tif(st !== false) { st.style.display = \"none\"; }\n\t\t\t\tst = $.vakata.css.get_css(selector + \".\" + i, false, this.data.languages.language_css);\n\t\t\t\tif(st !== false) { st.style.display = \"\"; }\n\t\t\t\tthis.data.languages.current_language = i;\n\t\t\t\tthis.__callback(i);\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tget_lang : function () {\n\t\t\t\treturn this.data.languages.current_language;\n\t\t\t},\n\t\t\t_get_string : function (key, lang) {\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\ts = this._get_settings().core.strings;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tlang = (lang && $.inArray(lang,langs) != -1) ? lang : this.data.languages.current_language;\n\t\t\t\t}\n\t\t\t\tif(s[lang] && s[lang][key]) { return s[lang][key]; }\n\t\t\t\tif(s[key]) { return s[key]; }\n\t\t\t\treturn key;\n\t\t\t},\n\t\t\tget_text : function (obj, lang) {\n\t\t\t\tobj = this._get_node(obj) || this.data.ui.last_selected;\n\t\t\t\tif(!obj.size()) { return false; }\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\ts = this._get_settings().core.html_titles;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tlang = (lang && $.inArray(lang,langs) != -1) ? lang : this.data.languages.current_language;\n\t\t\t\t\tobj = obj.children(\"a.\" + lang);\n\t\t\t\t}\n\t\t\t\telse { obj = obj.children(\"a:eq(0)\"); }\n\t\t\t\tif(s) {\n\t\t\t\t\tobj = obj.clone();\n\t\t\t\t\tobj.children(\"INS\").remove();\n\t\t\t\t\treturn obj.html();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\treturn obj.nodeValue;\n\t\t\t\t}\n\t\t\t},\n\t\t\tset_text : function (obj, val, lang) {\n\t\t\t\tobj = this._get_node(obj) || this.data.ui.last_selected;\n\t\t\t\tif(!obj.size()) { return false; }\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\ts = this._get_settings().core.html_titles,\n\t\t\t\t\ttmp;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tlang = (lang && $.inArray(lang,langs) != -1) ? lang : this.data.languages.current_language;\n\t\t\t\t\tobj = obj.children(\"a.\" + lang);\n\t\t\t\t}\n\t\t\t\telse { obj = obj.children(\"a:eq(0)\"); }\n\t\t\t\tif(s) {\n\t\t\t\t\ttmp = obj.children(\"INS\").clone();\n\t\t\t\t\tobj.html(val).prepend(tmp);\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val, \"lang\" : lang });\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val, \"lang\" : lang });\n\t\t\t\t\treturn (obj.nodeValue = val);\n\t\t\t\t}\n\t\t\t},\n\t\t\t_load_css : function () {\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\tstr = \"/* languages css */\",\n\t\t\t\t\tselector = \".jstree-\" + this.get_index() + ' a',\n\t\t\t\t\tln;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tthis.data.languages.current_language = langs[0];\n\t\t\t\t\tfor(ln = 0; ln < langs.length; ln++) {\n\t\t\t\t\t\tstr += selector + \".\" + langs[ln] + \" {\";\n\t\t\t\t\t\tif(langs[ln] != this.data.languages.current_language) { str += \" display:none; \"; }\n\t\t\t\t\t\tstr += \" } \";\n\t\t\t\t\t}\n\t\t\t\t\tthis.data.languages.language_css = $.vakata.css.add_sheet({ 'str' : str, 'title' : \"jstree-languages\" });\n\t\t\t\t}\n\t\t\t},\n\t\t\tcreate_node : function (obj, position, js, callback) {\n\t\t\t\tvar t = this.__call_old(true, obj, position, js, function (t) {\n\t\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\t\ta = t.children(\"a\"),\n\t\t\t\t\t\tln;\n\t\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\t\tfor(ln = 0; ln < langs.length; ln++) {\n\t\t\t\t\t\t\tif(!a.is(\".\" + langs[ln])) {\n\t\t\t\t\t\t\t\tt.append(a.eq(0).clone().removeClass(langs.join(\" \")).addClass(langs[ln]));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\ta.not(\".\" + langs.join(\", .\")).remove();\n\t\t\t\t\t}\n\t\t\t\t\tif(callback) { callback.call(this, t); }\n\t\t\t\t});\n\t\t\t\treturn t;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree cookies plugin\n * Stores the currently opened/selected nodes in a cookie and then restores them\n * Depends on the jquery.cookie plugin\n */\n(function ($) {\n\t$.jstree.plugin(\"cookies\", {\n\t\t__init : function () {\n\t\t\tif(typeof $.cookie === \"undefined\") { throw \"jsTree cookie: jQuery cookie plugin not included.\"; }\n\n\t\t\tvar s = this._get_settings().cookies,\n\t\t\t\ttmp;\n\t\t\tif(!!s.save_loaded) {\n\t\t\t\ttmp = $.cookie(s.save_loaded);\n\t\t\t\tif(tmp && tmp.length) { this.data.core.to_load = tmp.split(\",\"); }\n\t\t\t}\n\t\t\tif(!!s.save_opened) {\n\t\t\t\ttmp = $.cookie(s.save_opened);\n\t\t\t\tif(tmp && tmp.length) { this.data.core.to_open = tmp.split(\",\"); }\n\t\t\t}\n\t\t\tif(!!s.save_selected) {\n\t\t\t\ttmp = $.cookie(s.save_selected);\n\t\t\t\tif(tmp && tmp.length && this.data.ui) { this.data.ui.to_select = tmp.split(\",\"); }\n\t\t\t}\n\t\t\tthis.get_container()\n\t\t\t\t.one( ( this.data.ui ? \"reselect\" : \"reopen\" ) + \".jstree\", $.proxy(function () {\n\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t.bind(\"open_node.jstree close_node.jstree select_node.jstree deselect_node.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\t\t\tif(this._get_settings().cookies.auto_save) { this.save_cookie((e.handleObj.namespace + e.handleObj.type).replace(\"jstree\",\"\")); }\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tsave_loaded\t\t: \"jstree_load\",\n\t\t\tsave_opened\t\t: \"jstree_open\",\n\t\t\tsave_selected\t: \"jstree_select\",\n\t\t\tauto_save\t\t: true,\n\t\t\tcookie_options\t: {}\n\t\t},\n\t\t_fn : {\n\t\t\tsave_cookie : function (c) {\n\t\t\t\tif(this.data.core.refreshing) { return; }\n\t\t\t\tvar s = this._get_settings().cookies;\n\t\t\t\tif(!c) { // if called manually and not by event\n\t\t\t\t\tif(s.save_loaded) {\n\t\t\t\t\t\tthis.save_loaded();\n\t\t\t\t\t\t$.cookie(s.save_loaded, this.data.core.to_load.join(\",\"), s.cookie_options);\n\t\t\t\t\t}\n\t\t\t\t\tif(s.save_opened) {\n\t\t\t\t\t\tthis.save_opened();\n\t\t\t\t\t\t$.cookie(s.save_opened, this.data.core.to_open.join(\",\"), s.cookie_options);\n\t\t\t\t\t}\n\t\t\t\t\tif(s.save_selected && this.data.ui) {\n\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t\t$.cookie(s.save_selected, this.data.ui.to_select.join(\",\"), s.cookie_options);\n\t\t\t\t\t}\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tswitch(c) {\n\t\t\t\t\tcase \"open_node\":\n\t\t\t\t\tcase \"close_node\":\n\t\t\t\t\t\tif(!!s.save_opened) {\n\t\t\t\t\t\t\tthis.save_opened();\n\t\t\t\t\t\t\t$.cookie(s.save_opened, this.data.core.to_open.join(\",\"), s.cookie_options);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(!!s.save_loaded) {\n\t\t\t\t\t\t\tthis.save_loaded();\n\t\t\t\t\t\t\t$.cookie(s.save_loaded, this.data.core.to_load.join(\",\"), s.cookie_options);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"select_node\":\n\t\t\t\t\tcase \"deselect_node\":\n\t\t\t\t\t\tif(!!s.save_selected && this.data.ui) {\n\t\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t\t\t$.cookie(s.save_selected, this.data.ui.to_select.join(\",\"), s.cookie_options);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\t// include cookies by default\n\t// $.jstree.defaults.plugins.push(\"cookies\");\n})(jQuery);\n//*/\n\n/*\n * jsTree sort plugin\n * Sorts items alphabetically (or using any other function)\n */\n(function ($) {\n\t$.jstree.plugin(\"sort\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"load_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar obj = this._get_node(data.rslt.obj);\n\t\t\t\t\t\tobj = obj === -1 ? this.get_container().children(\"ul\") : obj.children(\"ul\");\n\t\t\t\t\t\tthis.sort(obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"rename_node.jstree create_node.jstree create.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.sort(data.rslt.obj.parent());\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar m = data.rslt.np == -1 ? this.get_container() : data.rslt.np;\n\t\t\t\t\t\tthis.sort(m.children(\"ul\"));\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : function (a, b) { return this.get_text(a) > this.get_text(b) ? 1 : -1; },\n\t\t_fn : {\n\t\t\tsort : function (obj) {\n\t\t\t\tvar s = this._get_settings().sort,\n\t\t\t\t\tt = this;\n\t\t\t\tobj.append($.makeArray(obj.children(\"li\")).sort($.proxy(s, t)));\n\t\t\t\tobj.find(\"> li > ul\").each(function() { t.sort($(this)); });\n\t\t\t\tthis.clean_node(obj);\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree DND plugin\n * Drag and drop plugin for moving/copying nodes\n */\n(function ($) {\n\tvar o = false,\n\t\tr = false,\n\t\tm = false,\n\t\tml = false,\n\t\tsli = false,\n\t\tsti = false,\n\t\tdir1 = false,\n\t\tdir2 = false,\n\t\tlast_pos = false;\n\t$.vakata.dnd = {\n\t\tis_down : false,\n\t\tis_drag : false,\n\t\thelper : false,\n\t\tscroll_spd : 10,\n\t\tinit_x : 0,\n\t\tinit_y : 0,\n\t\tthreshold : 5,\n\t\thelper_left : 5,\n\t\thelper_top : 10,\n\t\tuser_data : {},\n\n\t\tdrag_start : function (e, data, html) {\n\t\t\tif($.vakata.dnd.is_drag) { $.vakata.drag_stop({}); }\n\t\t\ttry {\n\t\t\t\te.currentTarget.unselectable = \"on\";\n\t\t\t\te.currentTarget.onselectstart = function() { return false; };\n\t\t\t\tif(e.currentTarget.style) { e.currentTarget.style.MozUserSelect = \"none\"; }\n\t\t\t} catch(err) { }\n\t\t\t$.vakata.dnd.init_x = e.pageX;\n\t\t\t$.vakata.dnd.init_y = e.pageY;\n\t\t\t$.vakata.dnd.user_data = data;\n\t\t\t$.vakata.dnd.is_down = true;\n\t\t\t$.vakata.dnd.helper = $(\"<div id='vakata-dragged' />\").html(html); //.fadeTo(10,0.25);\n\t\t\t$(document).bind(\"mousemove\", $.vakata.dnd.drag);\n\t\t\t$(document).bind(\"mouseup\", $.vakata.dnd.drag_stop);\n\t\t\treturn false;\n\t\t},\n\t\tdrag : function (e) {\n\t\t\tif(!$.vakata.dnd.is_down) { return; }\n\t\t\tif(!$.vakata.dnd.is_drag) {\n\t\t\t\tif(Math.abs(e.pageX - $.vakata.dnd.init_x) > 5 || Math.abs(e.pageY - $.vakata.dnd.init_y) > 5) {\n\t\t\t\t\t$.vakata.dnd.helper.appendTo(\"body\");\n\t\t\t\t\t$.vakata.dnd.is_drag = true;\n\t\t\t\t\t$(document).triggerHandler(\"drag_start.vakata\", { \"event\" : e, \"data\" : $.vakata.dnd.user_data });\n\t\t\t\t}\n\t\t\t\telse { return; }\n\t\t\t}\n\n\t\t\t// maybe use a scrolling parent element instead of document?\n\t\t\tif(e.type === \"mousemove\") { // thought of adding scroll in order to move the helper, but mouse poisition is n/a\n\t\t\t\tvar d = $(document), t = d.scrollTop(), l = d.scrollLeft();\n\t\t\t\tif(e.pageY - t < 20) {\n\t\t\t\t\tif(sti && dir1 === \"down\") { clearInterval(sti); sti = false; }\n\t\t\t\t\tif(!sti) { dir1 = \"up\"; sti = setInterval(function () { $(document).scrollTop($(document).scrollTop() - $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sti && dir1 === \"up\") { clearInterval(sti); sti = false; }\n\t\t\t\t}\n\t\t\t\tif($(window).height() - (e.pageY - t) < 20) {\n\t\t\t\t\tif(sti && dir1 === \"up\") { clearInterval(sti); sti = false; }\n\t\t\t\t\tif(!sti) { dir1 = \"down\"; sti = setInterval(function () { $(document).scrollTop($(document).scrollTop() + $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sti && dir1 === \"down\") { clearInterval(sti); sti = false; }\n\t\t\t\t}\n\n\t\t\t\tif(e.pageX - l < 20) {\n\t\t\t\t\tif(sli && dir2 === \"right\") { clearInterval(sli); sli = false; }\n\t\t\t\t\tif(!sli) { dir2 = \"left\"; sli = setInterval(function () { $(document).scrollLeft($(document).scrollLeft() - $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sli && dir2 === \"left\") { clearInterval(sli); sli = false; }\n\t\t\t\t}\n\t\t\t\tif($(window).width() - (e.pageX - l) < 20) {\n\t\t\t\t\tif(sli && dir2 === \"left\") { clearInterval(sli); sli = false; }\n\t\t\t\t\tif(!sli) { dir2 = \"right\"; sli = setInterval(function () { $(document).scrollLeft($(document).scrollLeft() + $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sli && dir2 === \"right\") { clearInterval(sli); sli = false; }\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t$.vakata.dnd.helper.css({ left : (e.pageX + $.vakata.dnd.helper_left) + \"px\", top : (e.pageY + $.vakata.dnd.helper_top) + \"px\" });\n\t\t\t$(document).triggerHandler(\"drag.vakata\", { \"event\" : e, \"data\" : $.vakata.dnd.user_data });\n\t\t},\n\t\tdrag_stop : function (e) {\n\t\t\tif(sli) { clearInterval(sli); }\n\t\t\tif(sti) { clearInterval(sti); }\n\t\t\t$(document).unbind(\"mousemove\", $.vakata.dnd.drag);\n\t\t\t$(document).unbind(\"mouseup\", $.vakata.dnd.drag_stop);\n\t\t\t$(document).triggerHandler(\"drag_stop.vakata\", { \"event\" : e, \"data\" : $.vakata.dnd.user_data });\n\t\t\t$.vakata.dnd.helper.remove();\n\t\t\t$.vakata.dnd.init_x = 0;\n\t\t\t$.vakata.dnd.init_y = 0;\n\t\t\t$.vakata.dnd.user_data = {};\n\t\t\t$.vakata.dnd.is_down = false;\n\t\t\t$.vakata.dnd.is_drag = false;\n\t\t}\n\t};\n\t$(function() {\n\t\tvar css_string = '#vakata-dragged { display:block; margin:0 0 0 0; padding:4px 4px 4px 24px; position:absolute; top:-2000px; line-height:16px; z-index:10000; } ';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"vakata\" });\n\t});\n\n\t$.jstree.plugin(\"dnd\", {\n\t\t__init : function () {\n\t\t\tthis.data.dnd = {\n\t\t\t\tactive : false,\n\t\t\t\tafter : false,\n\t\t\t\tinside : false,\n\t\t\t\tbefore : false,\n\t\t\t\toff : false,\n\t\t\t\tprepared : false,\n\t\t\t\tw : 0,\n\t\t\t\tto1 : false,\n\t\t\t\tto2 : false,\n\t\t\t\tcof : false,\n\t\t\t\tcw : false,\n\t\t\t\tch : false,\n\t\t\t\ti1 : false,\n\t\t\t\ti2 : false,\n\t\t\t\tmto : false\n\t\t\t};\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"mouseenter.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(this.data.themes) {\n\t\t\t\t\t\t\t\tm.attr(\"class\", \"jstree-\" + this.data.themes.theme);\n\t\t\t\t\t\t\t\tif(ml) { ml.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.attr(\"class\", \"jstree-dnd-helper jstree-\" + this.data.themes.theme);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t//if($(e.currentTarget).find(\"> ul > li\").length === 0) {\n\t\t\t\t\t\t\tif(e.currentTarget === e.target && $.vakata.dnd.user_data.obj && $($.vakata.dnd.user_data.obj).length && $($.vakata.dnd.user_data.obj).parents(\".jstree:eq(0)\")[0] !== e.target) { // node should not be from the same tree\n\t\t\t\t\t\t\t\tvar tr = $.jstree._reference(e.target), dc;\n\t\t\t\t\t\t\t\tif(tr.data.dnd.foreign) {\n\t\t\t\t\t\t\t\t\tdc = tr._get_settings().dnd.drag_check.call(this, { \"o\" : o, \"r\" : tr.get_container(), is_root : true });\n\t\t\t\t\t\t\t\t\tif(dc === true || dc.inside === true || dc.before === true || dc.after === true) {\n\t\t\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\ttr.prepare_move(o, tr.get_container(), \"last\");\n\t\t\t\t\t\t\t\t\tif(tr.check_move()) {\n\t\t\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"mouseup.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\t//if($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && $(e.currentTarget).find(\"> ul > li\").length === 0) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && e.currentTarget === e.target && $.vakata.dnd.user_data.obj && $($.vakata.dnd.user_data.obj).length && $($.vakata.dnd.user_data.obj).parents(\".jstree:eq(0)\")[0] !== e.target) { // node should not be from the same tree\n\t\t\t\t\t\t\tvar tr = $.jstree._reference(e.currentTarget), dc;\n\t\t\t\t\t\t\tif(tr.data.dnd.foreign) {\n\t\t\t\t\t\t\t\tdc = tr._get_settings().dnd.drag_check.call(this, { \"o\" : o, \"r\" : tr.get_container(), is_root : true });\n\t\t\t\t\t\t\t\tif(dc === true || dc.inside === true || dc.before === true || dc.after === true) {\n\t\t\t\t\t\t\t\t\ttr._get_settings().dnd.drag_finish.call(this, { \"o\" : o, \"r\" : tr.get_container(), is_root : true });\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\ttr.move_node(o, tr.get_container(), \"last\", e[tr._get_settings().dnd.copy_modifier + \"Key\"]);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"mouseleave.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif(e.relatedTarget && e.relatedTarget.id && e.relatedTarget.id === \"jstree-marker-line\") {\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\tif(this.data.dnd.to1) { clearTimeout(this.data.dnd.to1); }\n\t\t\t\t\t\t\tif(this.data.dnd.to2) { clearTimeout(this.data.dnd.to2); }\n\t\t\t\t\t\t\tif($.vakata.dnd.helper.children(\"ins\").hasClass(\"jstree-ok\")) {\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"mousemove.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tvar cnt = this.get_container()[0];\n\n\t\t\t\t\t\t\t// Horizontal scroll\n\t\t\t\t\t\t\tif(e.pageX + 24 > this.data.dnd.cof.left + this.data.dnd.cw) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i1 = setInterval($.proxy(function () { this.scrollLeft += $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse if(e.pageX - 24 < this.data.dnd.cof.left) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i1 = setInterval($.proxy(function () { this.scrollLeft -= $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Vertical scroll\n\t\t\t\t\t\t\tif(e.pageY + 24 > this.data.dnd.cof.top + this.data.dnd.ch) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i2 = setInterval($.proxy(function () { this.scrollTop += $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse if(e.pageY - 24 < this.data.dnd.cof.top) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i2 = setInterval($.proxy(function () { this.scrollTop -= $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"scroll.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && m && ml) {\n\t\t\t\t\t\t\tm.hide();\n\t\t\t\t\t\t\tml.hide();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mousedown.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif(e.which === 1) {\n\t\t\t\t\t\t\tthis.start_drag(e.currentTarget, e);\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseenter.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tthis.dnd_enter(e.currentTarget);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mousemove.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(!r || !r.length || r.children(\"a\")[0] !== e.currentTarget) {\n\t\t\t\t\t\t\t\tthis.dnd_enter(e.currentTarget);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(typeof this.data.dnd.off.top === \"undefined\") { this.data.dnd.off = $(e.target).offset(); }\n\t\t\t\t\t\t\tthis.data.dnd.w = (e.pageY - (this.data.dnd.off.top || 0)) % this.data.core.li_height;\n\t\t\t\t\t\t\tif(this.data.dnd.w < 0) { this.data.dnd.w += this.data.core.li_height; }\n\t\t\t\t\t\t\tthis.dnd_show();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseleave.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(e.relatedTarget && e.relatedTarget.id && e.relatedTarget.id === \"jstree-marker-line\") {\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif(m) { m.hide(); }\n\t\t\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\t\t/*\n\t\t\t\t\t\t\tvar ec = $(e.currentTarget).closest(\"li\"),\n\t\t\t\t\t\t\t\ter = $(e.relatedTarget).closest(\"li\");\n\t\t\t\t\t\t\tif(er[0] !== ec.prev()[0] && er[0] !== ec.next()[0]) {\n\t\t\t\t\t\t\t\tif(m) { m.hide(); }\n\t\t\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t*/\n\t\t\t\t\t\t\tthis.data.dnd.mto = setTimeout(\n\t\t\t\t\t\t\t\t(function (t) { return function () { t.dnd_leave(e); }; })(this),\n\t\t\t\t\t\t\t0);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseup.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tthis.dnd_finish(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\n\t\t\t$(document)\n\t\t\t\t.bind(\"drag_stop.vakata\", $.proxy(function () {\n\t\t\t\t\t\tif(this.data.dnd.to1) { clearTimeout(this.data.dnd.to1); }\n\t\t\t\t\t\tif(this.data.dnd.to2) { clearTimeout(this.data.dnd.to2); }\n\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\tthis.data.dnd.after\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.before\t= false;\n\t\t\t\t\t\tthis.data.dnd.inside\t= false;\n\t\t\t\t\t\tthis.data.dnd.off\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.prepared\t= false;\n\t\t\t\t\t\tthis.data.dnd.w\t\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.to1\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.to2\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.i1\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.i2\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.active\t= false;\n\t\t\t\t\t\tthis.data.dnd.foreign\t= false;\n\t\t\t\t\t\tif(m) { m.css({ \"top\" : \"-2000px\" }); }\n\t\t\t\t\t\tif(ml) { ml.css({ \"top\" : \"-2000px\" }); }\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"drag_start.vakata\", $.proxy(function (e, data) {\n\t\t\t\t\t\tif(data.data.jstree) {\n\t\t\t\t\t\t\tvar et = $(data.event.target);\n\t\t\t\t\t\t\tif(et.closest(\".jstree\").hasClass(\"jstree-\" + this.get_index())) {\n\t\t\t\t\t\t\t\tthis.dnd_enter(et);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t\t\t/*\n\t\t\t\t.bind(\"keydown.jstree-\" + this.get_index() + \" keyup.jstree-\" + this.get_index(), $.proxy(function(e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && !this.data.dnd.foreign) {\n\t\t\t\t\t\t\tvar h = $.vakata.dnd.helper.children(\"ins\");\n\t\t\t\t\t\t\tif(e[this._get_settings().dnd.copy_modifier + \"Key\"] && h.hasClass(\"jstree-ok\")) {\n\t\t\t\t\t\t\t\th.parent().html(h.parent().html().replace(/ \\(Copy\\)$/, \"\") + \" (Copy)\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\th.parent().html(h.parent().html().replace(/ \\(Copy\\)$/, \"\"));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this)); */\n\n\n\n\t\t\tvar s = this._get_settings().dnd;\n\t\t\tif(s.drag_target) {\n\t\t\t\t$(document)\n\t\t\t\t\t.delegate(s.drag_target, \"mousedown.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\to = e.target;\n\t\t\t\t\t\t$.vakata.dnd.drag_start(e, { jstree : true, obj : e.target }, \"<ins class='jstree-icon'></ins>\" + $(e.target).text() );\n\t\t\t\t\t\tif(this.data.themes) {\n\t\t\t\t\t\t\tif(m) { m.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t\t\tif(ml) { ml.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t\t\t$.vakata.dnd.helper.attr(\"class\", \"jstree-dnd-helper jstree-\" + this.data.themes.theme);\n\t\t\t\t\t\t}\n\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\t\t\tvar cnt = this.get_container();\n\t\t\t\t\t\tthis.data.dnd.cof = cnt.offset();\n\t\t\t\t\t\tthis.data.dnd.cw = parseInt(cnt.width(),10);\n\t\t\t\t\t\tthis.data.dnd.ch = parseInt(cnt.height(),10);\n\t\t\t\t\t\tthis.data.dnd.foreign = true;\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}, this));\n\t\t\t}\n\t\t\tif(s.drop_target) {\n\t\t\t\t$(document)\n\t\t\t\t\t.delegate(s.drop_target, \"mouseenter.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\t\tif(this.data.dnd.active && this._get_settings().dnd.drop_check.call(this, { \"o\" : o, \"r\" : $(e.target), \"e\" : e })) {\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.delegate(s.drop_target, \"mouseleave.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\t\tif(this.data.dnd.active) {\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.delegate(s.drop_target, \"mouseup.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\t\tif(this.data.dnd.active && $.vakata.dnd.helper.children(\"ins\").hasClass(\"jstree-ok\")) {\n\t\t\t\t\t\t\t\tthis._get_settings().dnd.drop_finish.call(this, { \"o\" : o, \"r\" : $(e.target), \"e\" : e });\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this));\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\tcopy_modifier\t: \"ctrl\",\n\t\t\tcheck_timeout\t: 100,\n\t\t\topen_timeout\t: 500,\n\t\t\tdrop_target\t\t: \".jstree-drop\",\n\t\t\tdrop_check\t\t: function (data) { return true; },\n\t\t\tdrop_finish\t\t: $.noop,\n\t\t\tdrag_target\t\t: \".jstree-draggable\",\n\t\t\tdrag_finish\t\t: $.noop,\n\t\t\tdrag_check\t\t: function (data) { return { after : false, before : false, inside : true }; }\n\t\t},\n\t\t_fn : {\n\t\t\tdnd_prepare : function () {\n\t\t\t\tif(!r || !r.length) { return; }\n\t\t\t\tthis.data.dnd.off = r.offset();\n\t\t\t\tif(this._get_settings().core.rtl) {\n\t\t\t\t\tthis.data.dnd.off.right = this.data.dnd.off.left + r.width();\n\t\t\t\t}\n\t\t\t\tif(this.data.dnd.foreign) {\n\t\t\t\t\tvar a = this._get_settings().dnd.drag_check.call(this, { \"o\" : o, \"r\" : r });\n\t\t\t\t\tthis.data.dnd.after = a.after;\n\t\t\t\t\tthis.data.dnd.before = a.before;\n\t\t\t\t\tthis.data.dnd.inside = a.inside;\n\t\t\t\t\tthis.data.dnd.prepared = true;\n\t\t\t\t\treturn this.dnd_show();\n\t\t\t\t}\n\t\t\t\tthis.prepare_move(o, r, \"before\");\n\t\t\t\tthis.data.dnd.before = this.check_move();\n\t\t\t\tthis.prepare_move(o, r, \"after\");\n\t\t\t\tthis.data.dnd.after = this.check_move();\n\t\t\t\tif(this._is_loaded(r)) {\n\t\t\t\t\tthis.prepare_move(o, r, \"inside\");\n\t\t\t\t\tthis.data.dnd.inside = this.check_move();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.data.dnd.inside = false;\n\t\t\t\t}\n\t\t\t\tthis.data.dnd.prepared = true;\n\t\t\t\treturn this.dnd_show();\n\t\t\t},\n\t\t\tdnd_show : function () {\n\t\t\t\tif(!this.data.dnd.prepared) { return; }\n\t\t\t\tvar o = [\"before\",\"inside\",\"after\"],\n\t\t\t\t\tr = false,\n\t\t\t\t\trtl = this._get_settings().core.rtl,\n\t\t\t\t\tpos;\n\t\t\t\tif(this.data.dnd.w < this.data.core.li_height/3) { o = [\"before\",\"inside\",\"after\"]; }\n\t\t\t\telse if(this.data.dnd.w <= this.data.core.li_height*2/3) {\n\t\t\t\t\to = this.data.dnd.w < this.data.core.li_height/2 ? [\"inside\",\"before\",\"after\"] : [\"inside\",\"after\",\"before\"];\n\t\t\t\t}\n\t\t\t\telse { o = [\"after\",\"inside\",\"before\"]; }\n\t\t\t\t$.each(o, $.proxy(function (i, val) {\n\t\t\t\t\tif(this.data.dnd[val]) {\n\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\tr = val;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}, this));\n\t\t\t\tif(r === false) { $.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\"); }\n\n\t\t\t\tpos = rtl ? (this.data.dnd.off.right - 18) : (this.data.dnd.off.left + 10);\n\t\t\t\tswitch(r) {\n\t\t\t\t\tcase \"before\":\n\t\t\t\t\t\tm.css({ \"left\" : pos + \"px\", \"top\" : (this.data.dnd.off.top - 6) + \"px\" }).show();\n\t\t\t\t\t\tif(ml) { ml.css({ \"left\" : (pos + 8) + \"px\", \"top\" : (this.data.dnd.off.top - 1) + \"px\" }).show(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"after\":\n\t\t\t\t\t\tm.css({ \"left\" : pos + \"px\", \"top\" : (this.data.dnd.off.top + this.data.core.li_height - 6) + \"px\" }).show();\n\t\t\t\t\t\tif(ml) { ml.css({ \"left\" : (pos + 8) + \"px\", \"top\" : (this.data.dnd.off.top + this.data.core.li_height - 1) + \"px\" }).show(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"inside\":\n\t\t\t\t\t\tm.css({ \"left\" : pos + ( rtl ? -4 : 4) + \"px\", \"top\" : (this.data.dnd.off.top + this.data.core.li_height/2 - 5) + \"px\" }).show();\n\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tm.hide();\n\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tlast_pos = r;\n\t\t\t\treturn r;\n\t\t\t},\n\t\t\tdnd_open : function () {\n\t\t\t\tthis.data.dnd.to2 = false;\n\t\t\t\tthis.open_node(r, $.proxy(this.dnd_prepare,this), true);\n\t\t\t},\n\t\t\tdnd_finish : function (e) {\n\t\t\t\tif(this.data.dnd.foreign) {\n\t\t\t\t\tif(this.data.dnd.after || this.data.dnd.before || this.data.dnd.inside) {\n\t\t\t\t\t\tthis._get_settings().dnd.drag_finish.call(this, { \"o\" : o, \"r\" : r, \"p\" : last_pos });\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.dnd_prepare();\n\t\t\t\t\tthis.move_node(o, r, last_pos, e[this._get_settings().dnd.copy_modifier + \"Key\"]);\n\t\t\t\t}\n\t\t\t\to = false;\n\t\t\t\tr = false;\n\t\t\t\tm.hide();\n\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t},\n\t\t\tdnd_enter : function (obj) {\n\t\t\t\tif(this.data.dnd.mto) {\n\t\t\t\t\tclearTimeout(this.data.dnd.mto);\n\t\t\t\t\tthis.data.dnd.mto = false;\n\t\t\t\t}\n\t\t\t\tvar s = this._get_settings().dnd;\n\t\t\t\tthis.data.dnd.prepared = false;\n\t\t\t\tr = this._get_node(obj);\n\t\t\t\tif(s.check_timeout) {\n\t\t\t\t\t// do the calculations after a minimal timeout (users tend to drag quickly to the desired location)\n\t\t\t\t\tif(this.data.dnd.to1) { clearTimeout(this.data.dnd.to1); }\n\t\t\t\t\tthis.data.dnd.to1 = setTimeout($.proxy(this.dnd_prepare, this), s.check_timeout);\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.dnd_prepare();\n\t\t\t\t}\n\t\t\t\tif(s.open_timeout) {\n\t\t\t\t\tif(this.data.dnd.to2) { clearTimeout(this.data.dnd.to2); }\n\t\t\t\t\tif(r && r.length && r.hasClass(\"jstree-closed\")) {\n\t\t\t\t\t\t// if the node is closed - open it, then recalculate\n\t\t\t\t\t\tthis.data.dnd.to2 = setTimeout($.proxy(this.dnd_open, this), s.open_timeout);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(r && r.length && r.hasClass(\"jstree-closed\")) {\n\t\t\t\t\t\tthis.dnd_open();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tdnd_leave : function (e) {\n\t\t\t\tthis.data.dnd.after\t\t= false;\n\t\t\t\tthis.data.dnd.before\t= false;\n\t\t\t\tthis.data.dnd.inside\t= false;\n\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\tm.hide();\n\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\tif(r && r[0] === e.target.parentNode) {\n\t\t\t\t\tif(this.data.dnd.to1) {\n\t\t\t\t\t\tclearTimeout(this.data.dnd.to1);\n\t\t\t\t\t\tthis.data.dnd.to1 = false;\n\t\t\t\t\t}\n\t\t\t\t\tif(this.data.dnd.to2) {\n\t\t\t\t\t\tclearTimeout(this.data.dnd.to2);\n\t\t\t\t\t\tthis.data.dnd.to2 = false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tstart_drag : function (obj, e) {\n\t\t\t\to = this._get_node(obj);\n\t\t\t\tif(this.data.ui && this.is_selected(o)) { o = this._get_node(null, true); }\n\t\t\t\tvar dt = o.length > 1 ? this._get_string(\"multiple_selection\") : this.get_text(o),\n\t\t\t\t\tcnt = this.get_container();\n\t\t\t\tif(!this._get_settings().core.html_titles) { dt = dt.replace(/</ig,\"&lt;\").replace(/>/ig,\"&gt;\"); }\n\t\t\t\t$.vakata.dnd.drag_start(e, { jstree : true, obj : o }, \"<ins class='jstree-icon'></ins>\" + dt );\n\t\t\t\tif(this.data.themes) {\n\t\t\t\t\tif(m) { m.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\tif(ml) { ml.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t$.vakata.dnd.helper.attr(\"class\", \"jstree-dnd-helper jstree-\" + this.data.themes.theme);\n\t\t\t\t}\n\t\t\t\tthis.data.dnd.cof = cnt.offset();\n\t\t\t\tthis.data.dnd.cw = parseInt(cnt.width(),10);\n\t\t\t\tthis.data.dnd.ch = parseInt(cnt.height(),10);\n\t\t\t\tthis.data.dnd.active = true;\n\t\t\t}\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '' +\n\t\t\t'#vakata-dragged ins { display:block; text-decoration:none; width:16px; height:16px; margin:0 0 0 0; padding:0; position:absolute; top:4px; left:4px; ' +\n\t\t\t' -moz-border-radius:4px; border-radius:4px; -webkit-border-radius:4px; ' +\n\t\t\t'} ' +\n\t\t\t'#vakata-dragged .jstree-ok { background:green; } ' +\n\t\t\t'#vakata-dragged .jstree-invalid { background:red; } ' +\n\t\t\t'#jstree-marker { padding:0; margin:0; font-size:12px; overflow:hidden; height:12px; width:8px; position:absolute; top:-30px; z-index:10001; background-repeat:no-repeat; display:none; background-color:transparent; text-shadow:1px 1px 1px white; color:black; line-height:10px; } ' +\n\t\t\t'#jstree-marker-line { padding:0; margin:0; line-height:0%; font-size:1px; overflow:hidden; height:1px; width:100px; position:absolute; top:-30px; z-index:10000; background-repeat:no-repeat; display:none; background-color:#456c43; ' +\n\t\t\t' cursor:pointer; border:1px solid #eeeeee; border-left:0; -moz-box-shadow: 0px 0px 2px #666; -webkit-box-shadow: 0px 0px 2px #666; box-shadow: 0px 0px 2px #666; ' +\n\t\t\t' -moz-border-radius:1px; border-radius:1px; -webkit-border-radius:1px; ' +\n\t\t\t'}' +\n\t\t\t'';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t\tm = $(\"<div />\").attr({ id : \"jstree-marker\" }).hide().html(\"&raquo;\")\n\t\t\t.bind(\"mouseleave mouseenter\", function (e) {\n\t\t\t\tm.hide();\n\t\t\t\tml.hide();\n\t\t\t\te.preventDefault();\n\t\t\t\te.stopImmediatePropagation();\n\t\t\t\treturn false;\n\t\t\t})\n\t\t\t.appendTo(\"body\");\n\t\tml = $(\"<div />\").attr({ id : \"jstree-marker-line\" }).hide()\n\t\t\t.bind(\"mouseup\", function (e) {\n\t\t\t\tif(r && r.length) {\n\t\t\t\t\tr.children(\"a\").trigger(e);\n\t\t\t\t\te.preventDefault();\n\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t})\n\t\t\t.bind(\"mouseleave\", function (e) {\n\t\t\t\tvar rt = $(e.relatedTarget);\n\t\t\t\tif(rt.is(\".jstree\") || rt.closest(\".jstree\").length === 0) {\n\t\t\t\t\tif(r && r.length) {\n\t\t\t\t\t\tr.children(\"a\").trigger(e);\n\t\t\t\t\t\tm.hide();\n\t\t\t\t\t\tml.hide();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t})\n\t\t\t.appendTo(\"body\");\n\t\t$(document).bind(\"drag_start.vakata\", function (e, data) {\n\t\t\tif(data.data.jstree) { m.show(); if(ml) { ml.show(); } }\n\t\t});\n\t\t$(document).bind(\"drag_stop.vakata\", function (e, data) {\n\t\t\tif(data.data.jstree) { m.hide(); if(ml) { ml.hide(); } }\n\t\t});\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree checkbox plugin\n * Inserts checkboxes in front of every node\n * Depends on the ui plugin\n * DOES NOT WORK NICELY WITH MULTITREE DRAG'N'DROP\n */\n(function ($) {\n\t$.jstree.plugin(\"checkbox\", {\n\t\t__init : function () {\n\t\t\tthis.data.checkbox.noui = this._get_settings().checkbox.override_ui;\n\t\t\tif(this.data.ui && this.data.checkbox.noui) {\n\t\t\t\tthis.select_node = this.deselect_node = this.deselect_all = $.noop;\n\t\t\t\tthis.get_selected = this.get_checked;\n\t\t\t}\n\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"open_node.jstree create_node.jstree clean_node.jstree refresh.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._prepare_checkboxes(data.rslt.obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"loaded.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tthis._prepare_checkboxes();\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate( (this.data.ui && this.data.checkbox.noui ? \"a\" : \"ins.jstree-checkbox\") , \"click.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\tif(this._get_node(e.target).hasClass(\"jstree-checked\")) { this.uncheck_node(e.target); }\n\t\t\t\t\t\telse { this.check_node(e.target); }\n\t\t\t\t\t\tif(this.data.ui && this.data.checkbox.noui) {\n\t\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t\t\tif(this.data.cookies) { this.save_cookie(\"select_node\"); }\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\toverride_ui : false,\n\t\t\ttwo_state : false,\n\t\t\treal_checkboxes : false,\n\t\t\tchecked_parent_open : true,\n\t\t\treal_checkboxes_names : function (n) { return [ (\"check_\" + (n[0].id || Math.ceil(Math.random() * 10000))) , 1]; }\n\t\t},\n\t\t__destroy : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.find(\"input.jstree-real-checkbox\").removeClass(\"jstree-real-checkbox\").end()\n\t\t\t\t.find(\"ins.jstree-checkbox\").remove();\n\t\t},\n\t\t_fn : {\n\t\t\t_checkbox_notify : function (n, data) {\n\t\t\t\tif(data.checked) {\n\t\t\t\t\tthis.check_node(n, false);\n\t\t\t\t}\n\t\t\t},\n\t\t\t_prepare_checkboxes : function (obj) {\n\t\t\t\tobj = !obj || obj == -1 ? this.get_container().find(\"> ul > li\") : this._get_node(obj);\n\t\t\t\tif(obj === false) { return; } // added for removing root nodes\n\t\t\t\tvar c, _this = this, t, ts = this._get_settings().checkbox.two_state, rc = this._get_settings().checkbox.real_checkboxes, rcn = this._get_settings().checkbox.real_checkboxes_names;\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tt = $(this);\n\t\t\t\t\tc = t.is(\"li\") && (t.hasClass(\"jstree-checked\") || (rc && t.children(\":checked\").length)) ? \"jstree-checked\" : \"jstree-unchecked\";\n\t\t\t\t\tt.find(\"li\").addBack().each(function () {\n\t\t\t\t\t\tvar $t = $(this), nm;\n\t\t\t\t\t\t$t.children(\"a\" + (_this.data.languages ? \"\" : \":eq(0)\") ).not(\":has(.jstree-checkbox)\").prepend(\"<ins class='jstree-checkbox'>&#160;</ins>\").parent().not(\".jstree-checked, .jstree-unchecked\").addClass( ts ? \"jstree-unchecked\" : c );\n\t\t\t\t\t\tif(rc) {\n\t\t\t\t\t\t\tif(!$t.children(\":checkbox\").length) {\n\t\t\t\t\t\t\t\tnm = rcn.call(_this, $t);\n\t\t\t\t\t\t\t\t$t.prepend(\"<input type='checkbox' class='jstree-real-checkbox' id='\" + nm[0] + \"' name='\" + nm[0] + \"' value='\" + nm[1] + \"' />\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t$t.children(\":checkbox\").addClass(\"jstree-real-checkbox\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(!ts) {\n\t\t\t\t\t\t\tif(c === \"jstree-checked\" || $t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n\t\t\t\t\t\t\t\t$t.find(\"li\").addBack().addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif($t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n\t\t\t\t\t\t\t\t$t.addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t\tif(!ts) {\n\t\t\t\t\tobj.find(\".jstree-checked\").parent().parent().each(function () { _this._repair_state(this); });\n\t\t\t\t}\n\t\t\t},\n\t\t\tchange_state : function (obj, state) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar coll = false, rc = this._get_settings().checkbox.real_checkboxes;\n\t\t\t\tif(!obj || obj === -1) { return false; }\n\t\t\t\tstate = (state === false || state === true) ? state : obj.hasClass(\"jstree-checked\");\n\t\t\t\tif(this._get_settings().checkbox.two_state) {\n\t\t\t\t\tif(state) {\n\t\t\t\t\t\tobj.removeClass(\"jstree-checked\").addClass(\"jstree-unchecked\");\n\t\t\t\t\t\tif(rc) { obj.children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\tobj.removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n\t\t\t\t\t\tif(rc) { obj.children(\":checkbox\").prop(\"checked\", true); }\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(state) {\n\t\t\t\t\t\tcoll = obj.find(\"li\").addBack();\n\t\t\t\t\t\tif(!coll.filter(\".jstree-checked, .jstree-undetermined\").length) { return false; }\n\t\t\t\t\t\tcoll.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n\t\t\t\t\t\tif(rc) { coll.children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\tcoll = obj.find(\"li\").addBack();\n\t\t\t\t\t\tif(!coll.filter(\".jstree-unchecked, .jstree-undetermined\").length) { return false; }\n\t\t\t\t\t\tcoll.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n\t\t\t\t\t\tif(rc) { coll.children(\":checkbox\").prop(\"checked\", true); }\n\t\t\t\t\t\tif(this.data.ui) { this.data.ui.last_selected = obj; }\n\t\t\t\t\t\tthis.data.checkbox.last_selected = obj;\n\t\t\t\t\t}\n\t\t\t\t\tobj.parentsUntil(\".jstree\", \"li\").each(function () {\n\t\t\t\t\t\tvar $this = $(this);\n\t\t\t\t\t\tif(state) {\n\t\t\t\t\t\t\tif($this.children(\"ul\").children(\"li.jstree-checked, li.jstree-undetermined\").length) {\n\t\t\t\t\t\t\t\t$this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n\t\t\t\t\t\t\t\tif(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t$this.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n\t\t\t\t\t\t\t\tif(rc) { $this.children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif($this.children(\"ul\").children(\"li.jstree-unchecked, li.jstree-undetermined\").length) {\n\t\t\t\t\t\t\t\t$this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n\t\t\t\t\t\t\t\tif(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t$this.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n\t\t\t\t\t\t\t\tif(rc) { $this.children(\":checkbox\").prop(\"checked\", true); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tif(this.data.ui && this.data.checkbox.noui) { this.data.ui.selected = this.get_checked(); }\n\t\t\t\tthis.__callback(obj);\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tcheck_node : function (obj) {\n\t\t\t\tif(this.change_state(obj, false)) {\n\t\t\t\t\tobj = this._get_node(obj);\n\t\t\t\t\tif(this._get_settings().checkbox.checked_parent_open) {\n\t\t\t\t\t\tvar t = this;\n\t\t\t\t\t\tobj.parents(\".jstree-closed\").each(function () { t.open_node(this, false, true); });\n\t\t\t\t\t}\n\t\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t\t}\n\t\t\t},\n\t\t\tuncheck_node : function (obj) {\n\t\t\t\tif(this.change_state(obj, true)) { this.__callback({ \"obj\" : this._get_node(obj) }); }\n\t\t\t},\n\t\t\tcheck_all : function () {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tcoll = this._get_settings().checkbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n\t\t\t\tcoll.each(function () {\n\t\t\t\t\t_this.change_state(this, false);\n\t\t\t\t});\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\tuncheck_all : function () {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tcoll = this._get_settings().checkbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n\t\t\t\tcoll.each(function () {\n\t\t\t\t\t_this.change_state(this, true);\n\t\t\t\t});\n\t\t\t\tthis.__callback();\n\t\t\t},\n\n\t\t\tis_checked : function(obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj.length ? obj.is(\".jstree-checked\") : false;\n\t\t\t},\n\t\t\tget_checked : function (obj, get_all) {\n\t\t\t\tobj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n\t\t\t\treturn get_all || this._get_settings().checkbox.two_state ? obj.find(\".jstree-checked\") : obj.find(\"> ul > .jstree-checked, .jstree-undetermined > ul > .jstree-checked\");\n\t\t\t},\n\t\t\tget_unchecked : function (obj, get_all) {\n\t\t\t\tobj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n\t\t\t\treturn get_all || this._get_settings().checkbox.two_state ? obj.find(\".jstree-unchecked\") : obj.find(\"> ul > .jstree-unchecked, .jstree-undetermined > ul > .jstree-unchecked\");\n\t\t\t},\n\n\t\t\tshow_checkboxes : function () { this.get_container().children(\"ul\").removeClass(\"jstree-no-checkboxes\"); },\n\t\t\thide_checkboxes : function () { this.get_container().children(\"ul\").addClass(\"jstree-no-checkboxes\"); },\n\n\t\t\t_repair_state : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return; }\n\t\t\t\tif(this._get_settings().checkbox.two_state) {\n\t\t\t\t\tobj.find('li').addBack().not('.jstree-checked').removeClass('jstree-undetermined').addClass('jstree-unchecked').children(':checkbox').prop('checked', true);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tvar rc = this._get_settings().checkbox.real_checkboxes,\n\t\t\t\t\ta = obj.find(\"> ul > .jstree-checked\").length,\n\t\t\t\t\tb = obj.find(\"> ul > .jstree-undetermined\").length,\n\t\t\t\t\tc = obj.find(\"> ul > li\").length;\n\t\t\t\tif(c === 0) { if(obj.hasClass(\"jstree-undetermined\")) { this.change_state(obj, false); } }\n\t\t\t\telse if(a === 0 && b === 0) { this.change_state(obj, true); }\n\t\t\t\telse if(a === c) { this.change_state(obj, false); }\n\t\t\t\telse {\n\t\t\t\t\tobj.parentsUntil(\".jstree\",\"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n\t\t\t\t\tif(rc) { obj.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t}\n\t\t\t},\n\t\t\treselect : function () {\n\t\t\t\tif(this.data.ui && this.data.checkbox.noui) {\n\t\t\t\t\tvar _this = this,\n\t\t\t\t\t\ts = this.data.ui.to_select;\n\t\t\t\t\ts = $.map($.makeArray(s), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\t$.each(s, function (i, val) { _this.check_node(val); });\n\t\t\t\t\tthis.__callback();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.__call_old();\n\t\t\t\t}\n\t\t\t},\n\t\t\tsave_loaded : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.data.core.to_load = [];\n\t\t\t\tthis.get_container_ul().find(\"li.jstree-closed.jstree-undetermined\").each(function () {\n\t\t\t\t\tif(this.id) { _this.data.core.to_load.push(\"#\" + this.id); }\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '.jstree .jstree-real-checkbox { display:none; } ';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree XML plugin\n * The XML data store. Datastores are build by overriding the `load_node` and `_is_loaded` functions.\n */\n(function ($) {\n\t$.vakata.xslt = function (xml, xsl, callback) {\n\t\tvar rs = \"\", xm, xs, processor, support;\n\t\t// TODO: IE9 no XSLTProcessor, no document.recalc\n\t\tif(document.recalc) {\n\t\t\txm = document.createElement('xml');\n\t\t\txs = document.createElement('xml');\n\t\t\txm.innerHTML = xml;\n\t\t\txs.innerHTML = xsl;\n\t\t\t$(\"body\").append(xm).append(xs);\n\t\t\tsetTimeout( (function (xm, xs, callback) {\n\t\t\t\treturn function () {\n\t\t\t\t\tcallback.call(null, xm.transformNode(xs.XMLDocument));\n\t\t\t\t\tsetTimeout( (function (xm, xs) { return function () { $(xm).remove(); $(xs).remove(); }; })(xm, xs), 200);\n\t\t\t\t};\n\t\t\t})(xm, xs, callback), 100);\n\t\t\treturn true;\n\t\t}\n\t\tif(typeof window.DOMParser !== \"undefined\" && typeof window.XMLHttpRequest !== \"undefined\" && typeof window.XSLTProcessor === \"undefined\") {\n\t\t\txml = new DOMParser().parseFromString(xml, \"text/xml\");\n\t\t\txsl = new DOMParser().parseFromString(xsl, \"text/xml\");\n\t\t\t// alert(xml.transformNode());\n\t\t\t// callback.call(null, new XMLSerializer().serializeToString(rs));\n\n\t\t}\n\t\tif(typeof window.DOMParser !== \"undefined\" && typeof window.XMLHttpRequest !== \"undefined\" && typeof window.XSLTProcessor !== \"undefined\") {\n\t\t\tprocessor = new XSLTProcessor();\n\t\t\tsupport = $.isFunction(processor.transformDocument) ? (typeof window.XMLSerializer !== \"undefined\") : true;\n\t\t\tif(!support) { return false; }\n\t\t\txml = new DOMParser().parseFromString(xml, \"text/xml\");\n\t\t\txsl = new DOMParser().parseFromString(xsl, \"text/xml\");\n\t\t\tif($.isFunction(processor.transformDocument)) {\n\t\t\t\trs = document.implementation.createDocument(\"\", \"\", null);\n\t\t\t\tprocessor.transformDocument(xml, xsl, rs, null);\n\t\t\t\tcallback.call(null, new XMLSerializer().serializeToString(rs));\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\telse {\n\t\t\t\tprocessor.importStylesheet(xsl);\n\t\t\t\trs = processor.transformToFragment(xml, document);\n\t\t\t\tcallback.call(null, $(\"<div />\").append(rs).html());\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t};\n\tvar xsl = {\n\t\t'nest' : '<' + '?xml version=\"1.0\" encoding=\"utf-8\" ?>' +\n\t\t\t'<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" >' +\n\t\t\t'<xsl:output method=\"html\" encoding=\"utf-8\" omit-xml-declaration=\"yes\" standalone=\"no\" indent=\"no\" media-type=\"text/html\" />' +\n\t\t\t'<xsl:template match=\"/\">' +\n\t\t\t'\t<xsl:call-template name=\"nodes\">' +\n\t\t\t'\t\t<xsl:with-param name=\"node\" select=\"/root\" />' +\n\t\t\t'\t</xsl:call-template>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'<xsl:template name=\"nodes\">' +\n\t\t\t'\t<xsl:param name=\"node\" />' +\n\t\t\t'\t<ul>' +\n\t\t\t'\t<xsl:for-each select=\"$node/item\">' +\n\t\t\t'\t\t<xsl:variable name=\"children\" select=\"count(./item) &gt; 0\" />' +\n\t\t\t'\t\t<li>' +\n\t\t\t'\t\t\t<xsl:attribute name=\"class\">' +\n\t\t\t'\t\t\t\t<xsl:if test=\"position() = last()\">jstree-last </xsl:if>' +\n\t\t\t'\t\t\t\t<xsl:choose>' +\n\t\t\t'\t\t\t\t\t<xsl:when test=\"@state = \\'open\\'\">jstree-open </xsl:when>' +\n\t\t\t'\t\t\t\t\t<xsl:when test=\"$children or @hasChildren or @state = \\'closed\\'\">jstree-closed </xsl:when>' +\n\t\t\t'\t\t\t\t\t<xsl:otherwise>jstree-leaf </xsl:otherwise>' +\n\t\t\t'\t\t\t\t</xsl:choose>' +\n\t\t\t'\t\t\t\t<xsl:value-of select=\"@class\" />' +\n\t\t\t'\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t\t\t<xsl:if test=\"name() != \\'class\\' and name() != \\'state\\' and name() != \\'hasChildren\\'\">' +\n\t\t\t'\t\t\t\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t</xsl:if>' +\n\t\t\t'\t\t\t</xsl:for-each>' +\n\t\t\t'\t<ins class=\"jstree-icon\"><xsl:text>&#xa0;</xsl:text></ins>' +\n\t\t\t'\t\t\t<xsl:for-each select=\"content/name\">' +\n\t\t\t'\t\t\t\t<a>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"href\">' +\n\t\t\t'\t\t\t\t\t<xsl:choose>' +\n\t\t\t'\t\t\t\t\t<xsl:when test=\"@href\"><xsl:value-of select=\"@href\" /></xsl:when>' +\n\t\t\t'\t\t\t\t\t<xsl:otherwise>#</xsl:otherwise>' +\n\t\t\t'\t\t\t\t\t</xsl:choose>' +\n\t\t\t'\t\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"class\"><xsl:value-of select=\"@lang\" /> <xsl:value-of select=\"@class\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"style\"><xsl:value-of select=\"@style\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t\t\t\t<xsl:if test=\"name() != \\'style\\' and name() != \\'class\\' and name() != \\'href\\'\">' +\n\t\t\t'\t\t\t\t\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t\t</xsl:if>' +\n\t\t\t'\t\t\t\t</xsl:for-each>' +\n\t\t\t'\t\t\t\t\t<ins>' +\n\t\t\t'\t\t\t\t\t\t<xsl:attribute name=\"class\">jstree-icon ' +\n\t\t\t'\t\t\t\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and not(contains(@icon,\\'/\\'))\"><xsl:value-of select=\"@icon\" /></xsl:if>' +\n\t\t\t'\t\t\t\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and contains(@icon,\\'/\\')\"><xsl:attribute name=\"style\">background:url(<xsl:value-of select=\"@icon\" />) center center no-repeat;</xsl:attribute></xsl:if>' +\n\t\t\t'\t\t\t\t\t\t<xsl:text>&#xa0;</xsl:text>' +\n\t\t\t'\t\t\t\t\t</ins>' +\n\t\t\t'\t\t\t\t\t<xsl:copy-of select=\"./child::node()\" />' +\n\t\t\t'\t\t\t\t</a>' +\n\t\t\t'\t\t\t</xsl:for-each>' +\n\t\t\t'\t\t\t<xsl:if test=\"$children or @hasChildren\"><xsl:call-template name=\"nodes\"><xsl:with-param name=\"node\" select=\"current()\" /></xsl:call-template></xsl:if>' +\n\t\t\t'\t\t</li>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t</ul>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'</xsl:stylesheet>',\n\n\t\t'flat' : '<' + '?xml version=\"1.0\" encoding=\"utf-8\" ?>' +\n\t\t\t'<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" >' +\n\t\t\t'<xsl:output method=\"html\" encoding=\"utf-8\" omit-xml-declaration=\"yes\" standalone=\"no\" indent=\"no\" media-type=\"text/xml\" />' +\n\t\t\t'<xsl:template match=\"/\">' +\n\t\t\t'\t<ul>' +\n\t\t\t'\t<xsl:for-each select=\"//item[not(@parent_id) or @parent_id=0 or not(@parent_id = //item/@id)]\">' + /* the last `or` may be removed */\n\t\t\t'\t\t<xsl:call-template name=\"nodes\">' +\n\t\t\t'\t\t\t<xsl:with-param name=\"node\" select=\".\" />' +\n\t\t\t'\t\t\t<xsl:with-param name=\"is_last\" select=\"number(position() = last())\" />' +\n\t\t\t'\t\t</xsl:call-template>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t</ul>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'<xsl:template name=\"nodes\">' +\n\t\t\t'\t<xsl:param name=\"node\" />' +\n\t\t\t'\t<xsl:param name=\"is_last\" />' +\n\t\t\t'\t<xsl:variable name=\"children\" select=\"count(//item[@parent_id=$node/attribute::id]) &gt; 0\" />' +\n\t\t\t'\t<li>' +\n\t\t\t'\t<xsl:attribute name=\"class\">' +\n\t\t\t'\t\t<xsl:if test=\"$is_last = true()\">jstree-last </xsl:if>' +\n\t\t\t'\t\t<xsl:choose>' +\n\t\t\t'\t\t\t<xsl:when test=\"@state = \\'open\\'\">jstree-open </xsl:when>' +\n\t\t\t'\t\t\t<xsl:when test=\"$children or @hasChildren or @state = \\'closed\\'\">jstree-closed </xsl:when>' +\n\t\t\t'\t\t\t<xsl:otherwise>jstree-leaf </xsl:otherwise>' +\n\t\t\t'\t\t</xsl:choose>' +\n\t\t\t'\t\t<xsl:value-of select=\"@class\" />' +\n\t\t\t'\t</xsl:attribute>' +\n\t\t\t'\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t<xsl:if test=\"name() != \\'parent_id\\' and name() != \\'hasChildren\\' and name() != \\'class\\' and name() != \\'state\\'\">' +\n\t\t\t'\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t</xsl:if>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t<ins class=\"jstree-icon\"><xsl:text>&#xa0;</xsl:text></ins>' +\n\t\t\t'\t<xsl:for-each select=\"content/name\">' +\n\t\t\t'\t\t<a>' +\n\t\t\t'\t\t<xsl:attribute name=\"href\">' +\n\t\t\t'\t\t\t<xsl:choose>' +\n\t\t\t'\t\t\t<xsl:when test=\"@href\"><xsl:value-of select=\"@href\" /></xsl:when>' +\n\t\t\t'\t\t\t<xsl:otherwise>#</xsl:otherwise>' +\n\t\t\t'\t\t\t</xsl:choose>' +\n\t\t\t'\t\t</xsl:attribute>' +\n\t\t\t'\t\t<xsl:attribute name=\"class\"><xsl:value-of select=\"@lang\" /> <xsl:value-of select=\"@class\" /></xsl:attribute>' +\n\t\t\t'\t\t<xsl:attribute name=\"style\"><xsl:value-of select=\"@style\" /></xsl:attribute>' +\n\t\t\t'\t\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t\t<xsl:if test=\"name() != \\'style\\' and name() != \\'class\\' and name() != \\'href\\'\">' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t\t</xsl:if>' +\n\t\t\t'\t\t</xsl:for-each>' +\n\t\t\t'\t\t\t<ins>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"class\">jstree-icon ' +\n\t\t\t'\t\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and not(contains(@icon,\\'/\\'))\"><xsl:value-of select=\"@icon\" /></xsl:if>' +\n\t\t\t'\t\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and contains(@icon,\\'/\\')\"><xsl:attribute name=\"style\">background:url(<xsl:value-of select=\"@icon\" />) center center no-repeat;</xsl:attribute></xsl:if>' +\n\t\t\t'\t\t\t\t<xsl:text>&#xa0;</xsl:text>' +\n\t\t\t'\t\t\t</ins>' +\n\t\t\t'\t\t\t<xsl:copy-of select=\"./child::node()\" />' +\n\t\t\t'\t\t</a>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t<xsl:if test=\"$children\">' +\n\t\t\t'\t\t<ul>' +\n\t\t\t'\t\t<xsl:for-each select=\"//item[@parent_id=$node/attribute::id]\">' +\n\t\t\t'\t\t\t<xsl:call-template name=\"nodes\">' +\n\t\t\t'\t\t\t\t<xsl:with-param name=\"node\" select=\".\" />' +\n\t\t\t'\t\t\t\t<xsl:with-param name=\"is_last\" select=\"number(position() = last())\" />' +\n\t\t\t'\t\t\t</xsl:call-template>' +\n\t\t\t'\t\t</xsl:for-each>' +\n\t\t\t'\t\t</ul>' +\n\t\t\t'\t</xsl:if>' +\n\t\t\t'\t</li>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'</xsl:stylesheet>'\n\t},\n\tescape_xml = function(string) {\n\t\treturn string\n\t\t\t.toString()\n\t\t\t.replace(/&/g, '&amp;')\n\t\t\t.replace(/</g, '&lt;')\n\t\t\t.replace(/>/g, '&gt;')\n\t\t\t.replace(/\"/g, '&quot;')\n\t\t\t.replace(/'/g, '&apos;');\n\t};\n\t$.jstree.plugin(\"xml_data\", {\n\t\tdefaults : {\n\t\t\tdata : false,\n\t\t\tajax : false,\n\t\t\txsl : \"flat\",\n\t\t\tclean_node : false,\n\t\t\tcorrect_state : true,\n\t\t\tget_skip_empty : false,\n\t\t\tget_include_preamble : true\n\t\t},\n\t\t_fn : {\n\t\t\tload_node : function (obj, s_call, e_call) { var _this = this; this.load_node_xml(obj, function () { _this.__callback({ \"obj\" : _this._get_node(obj) }); s_call.call(this); }, e_call); },\n\t\t\t_is_loaded : function (obj) {\n\t\t\t\tvar s = this._get_settings().xml_data;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj == -1 || !obj || (!s.ajax && !$.isFunction(s.data)) || obj.is(\".jstree-open, .jstree-leaf\") || obj.children(\"ul\").children(\"li\").size() > 0;\n\t\t\t},\n\t\t\tload_node_xml : function (obj, s_call, e_call) {\n\t\t\t\tvar s = this.get_settings().xml_data,\n\t\t\t\t\terror_func = function () {},\n\t\t\t\t\tsuccess_func = function () {};\n\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\tif(obj.data(\"jstree_is_loading\")) { return; }\n\t\t\t\t\telse { obj.data(\"jstree_is_loading\",true); }\n\t\t\t\t}\n\t\t\t\tswitch(!0) {\n\t\t\t\t\tcase (!s.data && !s.ajax): throw \"Neither data nor ajax settings supplied.\";\n\t\t\t\t\tcase ($.isFunction(s.data)):\n\t\t\t\t\t\ts.data.call(this, obj, $.proxy(function (d) {\n\t\t\t\t\t\t\tthis.parse_xml(d, $.proxy(function (d) {\n\t\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\t\td = d.replace(/ ?xmlns=\"[^\"]*\"/ig, \"\");\n\t\t\t\t\t\t\t\t\tif(d.length > 10) {\n\t\t\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\t\t\tif(s.clean_node) { this.clean_node(obj); }\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t\t\t}, this));\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!!s.data && !s.ajax) || (!!s.data && !!s.ajax && (!obj || obj === -1)):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\tthis.parse_xml(s.data, $.proxy(function (d) {\n\t\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\t\td = d.replace(/ ?xmlns=\"[^\"]*\"/ig, \"\");\n\t\t\t\t\t\t\t\t\tif(d.length > 10) {\n\t\t\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty().append(d.children());\n\t\t\t\t\t\t\t\t\t\tif(s.clean_node) { this.clean_node(obj); }\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !!s.ajax) || (!!s.data && !!s.ajax && obj && obj !== -1):\n\t\t\t\t\t\terror_func = function (x, t, e) {\n\t\t\t\t\t\t\tvar ef = this.get_settings().xml_data.ajax.error;\n\t\t\t\t\t\t\tif(ef) { ef.call(this, x, t, e); }\n\t\t\t\t\t\t\tif(obj !== -1 && obj.length) {\n\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t};\n\t\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\t\td = x.responseText;\n\t\t\t\t\t\t\tvar sf = this.get_settings().xml_data.ajax.success;\n\t\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\t\tif(d === \"\" || (d && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") === \"\")) {\n\t\t\t\t\t\t\t\treturn error_func.call(this, x, t, \"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tthis.parse_xml(d, $.proxy(function (d) {\n\t\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\t\td = d.replace(/ ?xmlns=\"[^\"]*\"/ig, \"\");\n\t\t\t\t\t\t\t\t\tif(d.length > 10) {\n\t\t\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\t\t\tif(s.clean_node) { this.clean_node(obj); }\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t\t\t};\n\t\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\t\tif(!s.ajax.dataType) { s.ajax.dataType = \"xml\"; }\n\t\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, obj); }\n\t\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, obj); }\n\t\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\tparse_xml : function (xml, callback) {\n\t\t\t\tvar s = this._get_settings().xml_data;\n\t\t\t\t$.vakata.xslt(xml, xsl[s.xsl], callback);\n\t\t\t},\n\t\t\tget_xml : function (tp, obj, li_attr, a_attr, is_callback) {\n\t\t\t\tvar result = \"\",\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this,\n\t\t\t\t\ttmp1, tmp2, li, a, lang;\n\t\t\t\tif(!tp) { tp = \"flat\"; }\n\t\t\t\tif(!is_callback) { is_callback = 0; }\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container().find(\"> ul > li\"); }\n\t\t\t\tli_attr = $.isArray(li_attr) ? li_attr : [ \"id\", \"class\" ];\n\t\t\t\tif(!is_callback && this.data.types && $.inArray(s.types.type_attr, li_attr) === -1) { li_attr.push(s.types.type_attr); }\n\n\t\t\t\ta_attr = $.isArray(a_attr) ? a_attr : [ ];\n\n\t\t\t\tif(!is_callback) {\n\t\t\t\t\tif(s.xml_data.get_include_preamble) {\n\t\t\t\t\t\tresult += '<' + '?xml version=\"1.0\" encoding=\"UTF-8\"?' + '>';\n\t\t\t\t\t}\n\t\t\t\t\tresult += \"<root>\";\n\t\t\t\t}\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tresult += \"<item\";\n\t\t\t\t\tli = $(this);\n\t\t\t\t\t$.each(li_attr, function (i, v) {\n\t\t\t\t\t\tvar t = li.attr(v);\n\t\t\t\t\t\tif(!s.xml_data.get_skip_empty || typeof t !== \"undefined\") {\n\t\t\t\t\t\t\tresult += \" \" + v + \"=\\\"\" + escape_xml((\" \" + (t || \"\")).replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\")) + \"\\\"\";\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tif(li.hasClass(\"jstree-open\")) { result += \" state=\\\"open\\\"\"; }\n\t\t\t\t\tif(li.hasClass(\"jstree-closed\")) { result += \" state=\\\"closed\\\"\"; }\n\t\t\t\t\tif(tp === \"flat\") { result += \" parent_id=\\\"\" + escape_xml(is_callback) + \"\\\"\"; }\n\t\t\t\t\tresult += \">\";\n\t\t\t\t\tresult += \"<content>\";\n\t\t\t\t\ta = li.children(\"a\");\n\t\t\t\t\ta.each(function () {\n\t\t\t\t\t\ttmp1 = $(this);\n\t\t\t\t\t\tlang = false;\n\t\t\t\t\t\tresult += \"<name\";\n\t\t\t\t\t\tif($.inArray(\"languages\", s.plugins) !== -1) {\n\t\t\t\t\t\t\t$.each(s.languages, function (k, z) {\n\t\t\t\t\t\t\t\tif(tmp1.hasClass(z)) { result += \" lang=\\\"\" + escape_xml(z) + \"\\\"\"; lang = z; return false; }\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(a_attr.length) {\n\t\t\t\t\t\t\t$.each(a_attr, function (k, z) {\n\t\t\t\t\t\t\t\tvar t = tmp1.attr(z);\n\t\t\t\t\t\t\t\tif(!s.xml_data.get_skip_empty || typeof t !== \"undefined\") {\n\t\t\t\t\t\t\t\t\tresult += \" \" + z + \"=\\\"\" + escape_xml((\" \" + t || \"\").replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\")) + \"\\\"\";\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(tmp1.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/^\\s+$/ig,\"\").length) {\n\t\t\t\t\t\t\tresult += ' icon=\"' + escape_xml(tmp1.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\")) + '\"';\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(tmp1.children(\"ins\").get(0).style.backgroundImage.length) {\n\t\t\t\t\t\t\tresult += ' icon=\"' + escape_xml(tmp1.children(\"ins\").get(0).style.backgroundImage.replace(\"url(\",\"\").replace(\")\",\"\").replace(/'/ig,\"\").replace(/\"/ig,\"\")) + '\"';\n\t\t\t\t\t\t}\n\t\t\t\t\t\tresult += \">\";\n\t\t\t\t\t\tresult += \"<![CDATA[\" + _this.get_text(tmp1, lang) + \"]]>\";\n\t\t\t\t\t\tresult += \"</name>\";\n\t\t\t\t\t});\n\t\t\t\t\tresult += \"</content>\";\n\t\t\t\t\ttmp2 = li[0].id || true;\n\t\t\t\t\tli = li.find(\"> ul > li\");\n\t\t\t\t\tif(li.length) { tmp2 = _this.get_xml(tp, li, li_attr, a_attr, tmp2); }\n\t\t\t\t\telse { tmp2 = \"\"; }\n\t\t\t\t\tif(tp == \"nest\") { result += tmp2; }\n\t\t\t\t\tresult += \"</item>\";\n\t\t\t\t\tif(tp == \"flat\") { result += tmp2; }\n\t\t\t\t});\n\t\t\t\tif(!is_callback) { result += \"</root>\"; }\n\t\t\t\treturn result;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree search plugin\n * Enables both sync and async search on the tree\n * DOES NOT WORK WITH JSON PROGRESSIVE RENDER\n */\n(function ($) {\n\t$.expr[':'].jstree_contains = function(a,i,m){\n\t\treturn (a.textContent || a.innerText || \"\").toLowerCase().indexOf(m[3].toLowerCase())>=0;\n\t};\n\t$.expr[':'].jstree_title_contains = function(a,i,m) {\n\t\treturn (a.getAttribute(\"title\") || \"\").toLowerCase().indexOf(m[3].toLowerCase())>=0;\n\t};\n\t$.jstree.plugin(\"search\", {\n\t\t__init : function () {\n\t\t\tthis.data.search.str = \"\";\n\t\t\tthis.data.search.result = $();\n\t\t\tif(this._get_settings().search.show_only_matches) {\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.bind(\"search.jstree\", function (e, data) {\n\t\t\t\t\t\t$(this).children(\"ul\").find(\"li\").hide().removeClass(\"jstree-last\");\n\t\t\t\t\t\tdata.rslt.nodes.parentsUntil(\".jstree\").addBack().show()\n\t\t\t\t\t\t\t.filter(\"ul\").each(function () { $(this).children(\"li:visible\").eq(-1).addClass(\"jstree-last\"); });\n\t\t\t\t\t})\n\t\t\t\t\t.bind(\"clear_search.jstree\", function () {\n\t\t\t\t\t\t$(this).children(\"ul\").find(\"li\").css(\"display\",\"\").end().end().jstree(\"clean_node\", -1);\n\t\t\t\t\t});\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\tajax : false,\n\t\t\tsearch_method : \"jstree_contains\", // for case insensitive - jstree_contains\n\t\t\tshow_only_matches : false\n\t\t},\n\t\t_fn : {\n\t\t\tsearch : function (str, skip_async) {\n\t\t\t\tif($.trim(str) === \"\") { this.clear_search(); return; }\n\t\t\t\tvar s = this.get_settings().search,\n\t\t\t\t\tt = this,\n\t\t\t\t\terror_func = function () { },\n\t\t\t\t\tsuccess_func = function () { };\n\t\t\t\tthis.data.search.str = str;\n\n\t\t\t\tif(!skip_async && s.ajax !== false && this.get_container_ul().find(\"li.jstree-closed:not(:has(ul)):eq(0)\").length > 0) {\n\t\t\t\t\tthis.search.supress_callback = true;\n\t\t\t\t\terror_func = function () { };\n\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\tvar sf = this.get_settings().search.ajax.success;\n\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\tthis.data.search.to_open = d;\n\t\t\t\t\t\tthis._search_open();\n\t\t\t\t\t};\n\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, str); }\n\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, str); }\n\t\t\t\t\tif(!s.ajax.data) { s.ajax.data = { \"search_string\" : str }; }\n\t\t\t\t\tif(!s.ajax.dataType || /^json/.exec(s.ajax.dataType)) { s.ajax.dataType = \"json\"; }\n\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tif(this.data.search.result.length) { this.clear_search(); }\n\t\t\t\tthis.data.search.result = this.get_container().find(\"a\" + (this.data.languages ? \".\" + this.get_lang() : \"\" ) + \":\" + (s.search_method) + \"(\" + this.data.search.str + \")\");\n\t\t\t\tthis.data.search.result.addClass(\"jstree-search\").parent().parents(\".jstree-closed\").each(function () {\n\t\t\t\t\tt.open_node(this, false, true);\n\t\t\t\t});\n\t\t\t\tthis.__callback({ nodes : this.data.search.result, str : str });\n\t\t\t},\n\t\t\tclear_search : function (str) {\n\t\t\t\tthis.data.search.result.removeClass(\"jstree-search\");\n\t\t\t\tthis.__callback(this.data.search.result);\n\t\t\t\tthis.data.search.result = $();\n\t\t\t},\n\t\t\t_search_open : function (is_callback) {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tdone = true,\n\t\t\t\t\tcurrent = [],\n\t\t\t\t\tremaining = [];\n\t\t\t\tif(this.data.search.to_open.length) {\n\t\t\t\t\t$.each(this.data.search.to_open, function (i, val) {\n\t\t\t\t\t\tif(val == \"#\") { return true; }\n\t\t\t\t\t\tif($(val).length && $(val).is(\".jstree-closed\")) { current.push(val); }\n\t\t\t\t\t\telse { remaining.push(val); }\n\t\t\t\t\t});\n\t\t\t\t\tif(current.length) {\n\t\t\t\t\t\tthis.data.search.to_open = remaining;\n\t\t\t\t\t\t$.each(current, function (i, val) {\n\t\t\t\t\t\t\t_this.open_node(val, function () { _this._search_open(true); });\n\t\t\t\t\t\t});\n\t\t\t\t\t\tdone = false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(done) { this.search(this.data.search.str, true); }\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree contextmenu plugin\n */\n(function ($) {\n\t$.vakata.context = {\n\t\thide_on_mouseleave : false,\n\n\t\tcnt\t\t: $(\"<div id='vakata-contextmenu' />\"),\n\t\tvis\t\t: false,\n\t\ttgt\t\t: false,\n\t\tpar\t\t: false,\n\t\tfunc\t: false,\n\t\tdata\t: false,\n\t\trtl\t\t: false,\n\t\tshow\t: function (s, t, x, y, d, p, rtl) {\n\t\t\t$.vakata.context.rtl = !!rtl;\n\t\t\tvar html = $.vakata.context.parse(s), h, w;\n\t\t\tif(!html) { return; }\n\t\t\t$.vakata.context.vis = true;\n\t\t\t$.vakata.context.tgt = t;\n\t\t\t$.vakata.context.par = p || t || null;\n\t\t\t$.vakata.context.data = d || null;\n\t\t\t$.vakata.context.cnt\n\t\t\t\t.html(html)\n\t\t\t\t.css({ \"visibility\" : \"hidden\", \"display\" : \"block\", \"left\" : 0, \"top\" : 0 });\n\n\t\t\tif($.vakata.context.hide_on_mouseleave) {\n\t\t\t\t$.vakata.context.cnt\n\t\t\t\t\t.one(\"mouseleave\", function(e) { $.vakata.context.hide(); });\n\t\t\t}\n\n\t\t\th = $.vakata.context.cnt.height();\n\t\t\tw = $.vakata.context.cnt.width();\n\t\t\tif(x + w > $(document).width()) {\n\t\t\t\tx = $(document).width() - (w + 5);\n\t\t\t\t$.vakata.context.cnt.find(\"li > ul\").addClass(\"right\");\n\t\t\t}\n\t\t\tif(y + h > $(document).height()) {\n\t\t\t\ty = y - (h + t[0].offsetHeight);\n\t\t\t\t$.vakata.context.cnt.find(\"li > ul\").addClass(\"bottom\");\n\t\t\t}\n\n\t\t\t$.vakata.context.cnt\n\t\t\t\t.css({ \"left\" : x, \"top\" : y })\n\t\t\t\t.find(\"li:has(ul)\")\n\t\t\t\t\t.bind(\"mouseenter\", function (e) {\n\t\t\t\t\t\tvar w = $(document).width(),\n\t\t\t\t\t\t\th = $(document).height(),\n\t\t\t\t\t\t\tul = $(this).children(\"ul\").show();\n\t\t\t\t\t\tif(w !== $(document).width()) { ul.toggleClass(\"right\"); }\n\t\t\t\t\t\tif(h !== $(document).height()) { ul.toggleClass(\"bottom\"); }\n\t\t\t\t\t})\n\t\t\t\t\t.bind(\"mouseleave\", function (e) {\n\t\t\t\t\t\t$(this).children(\"ul\").hide();\n\t\t\t\t\t})\n\t\t\t\t\t.end()\n\t\t\t\t.css({ \"visibility\" : \"visible\" })\n\t\t\t\t.show();\n\t\t\t$(document).triggerHandler(\"context_show.vakata\");\n\t\t},\n\t\thide\t: function () {\n\t\t\t$.vakata.context.vis = false;\n\t\t\t$.vakata.context.cnt.attr(\"class\",\"\").css({ \"visibility\" : \"hidden\" });\n\t\t\t$(document).triggerHandler(\"context_hide.vakata\");\n\t\t},\n\t\tparse\t: function (s, is_callback) {\n\t\t\tif(!s) { return false; }\n\t\t\tvar str = \"\",\n\t\t\t\ttmp = false,\n\t\t\t\twas_sep = true;\n\t\t\tif(!is_callback) { $.vakata.context.func = {}; }\n\t\t\tstr += \"<ul>\";\n\t\t\t$.each(s, function (i, val) {\n\t\t\t\tif(!val) { return true; }\n\t\t\t\t$.vakata.context.func[i] = val.action;\n\t\t\t\tif(!was_sep && val.separator_before) {\n\t\t\t\t\tstr += \"<li class='vakata-separator vakata-separator-before'></li>\";\n\t\t\t\t}\n\t\t\t\twas_sep = false;\n\t\t\t\tstr += \"<li class='\" + (val._class || \"\") + (val._disabled ? \" jstree-contextmenu-disabled \" : \"\") + \"'><ins \";\n\t\t\t\tif(val.icon && val.icon.indexOf(\"/\") === -1) { str += \" class='\" + val.icon + \"' \"; }\n\t\t\t\tif(val.icon && val.icon.indexOf(\"/\") !== -1) { str += \" style='background:url(\" + val.icon + \") center center no-repeat;' \"; }\n\t\t\t\tstr += \">&#160;</ins><a href='#' rel='\" + i + \"'>\";\n\t\t\t\tif(val.submenu) {\n\t\t\t\t\tstr += \"<span style='float:\" + ($.vakata.context.rtl ? \"left\" : \"right\") + \";'>&raquo;</span>\";\n\t\t\t\t}\n\t\t\t\tstr += val.label + \"</a>\";\n\t\t\t\tif(val.submenu) {\n\t\t\t\t\ttmp = $.vakata.context.parse(val.submenu, true);\n\t\t\t\t\tif(tmp) { str += tmp; }\n\t\t\t\t}\n\t\t\t\tstr += \"</li>\";\n\t\t\t\tif(val.separator_after) {\n\t\t\t\t\tstr += \"<li class='vakata-separator vakata-separator-after'></li>\";\n\t\t\t\t\twas_sep = true;\n\t\t\t\t}\n\t\t\t});\n\t\t\tstr = str.replace(/<li class\\='vakata-separator vakata-separator-after'\\><\\/li\\>$/,\"\");\n\t\t\tstr += \"</ul>\";\n\t\t\t$(document).triggerHandler(\"context_parse.vakata\");\n\t\t\treturn str.length > 10 ? str : false;\n\t\t},\n\t\texec\t: function (i) {\n\t\t\tif($.isFunction($.vakata.context.func[i])) {\n\t\t\t\t// if is string - eval and call it!\n\t\t\t\t$.vakata.context.func[i].call($.vakata.context.data, $.vakata.context.par);\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\telse { return false; }\n\t\t}\n\t};\n\t$(function () {\n\t\tvar css_string = '' +\n\t\t\t'#vakata-contextmenu { display:block; visibility:hidden; left:0; top:-200px; position:absolute; margin:0; padding:0; min-width:180px; background:#ebebeb; border:1px solid silver; z-index:10000; *width:180px; } ' +\n\t\t\t'#vakata-contextmenu ul { min-width:180px; *width:180px; } ' +\n\t\t\t'#vakata-contextmenu ul, #vakata-contextmenu li { margin:0; padding:0; list-style-type:none; display:block; } ' +\n\t\t\t'#vakata-contextmenu li { line-height:20px; min-height:20px; position:relative; padding:0px; } ' +\n\t\t\t'#vakata-contextmenu li a { padding:1px 6px; line-height:17px; display:block; text-decoration:none; margin:1px 1px 0 1px; } ' +\n\t\t\t'#vakata-contextmenu li ins { float:left; width:16px; height:16px; text-decoration:none; margin-right:2px; } ' +\n\t\t\t'#vakata-contextmenu li a:hover, #vakata-contextmenu li.vakata-hover > a { background:gray; color:white; } ' +\n\t\t\t'#vakata-contextmenu li ul { display:none; position:absolute; top:-2px; left:100%; background:#ebebeb; border:1px solid gray; } ' +\n\t\t\t'#vakata-contextmenu .right { right:100%; left:auto; } ' +\n\t\t\t'#vakata-contextmenu .bottom { bottom:-1px; top:auto; } ' +\n\t\t\t'#vakata-contextmenu li.vakata-separator { min-height:0; height:1px; line-height:1px; font-size:1px; overflow:hidden; margin:0 2px; background:silver; /* border-top:1px solid #fefefe; */ padding:0; } ';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"vakata\" });\n\t\t$.vakata.context.cnt\n\t\t\t.delegate(\"a\",\"click\", function (e) { e.preventDefault(); })\n\t\t\t.delegate(\"a\",\"mouseup\", function (e) {\n\t\t\t\tif(!$(this).parent().hasClass(\"jstree-contextmenu-disabled\") && $.vakata.context.exec($(this).attr(\"rel\"))) {\n\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t}\n\t\t\t\telse { $(this).blur(); }\n\t\t\t})\n\t\t\t.delegate(\"a\",\"mouseover\", function () {\n\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").removeClass(\"vakata-hover\");\n\t\t\t})\n\t\t\t.appendTo(\"body\");\n\t\t$(document).bind(\"mousedown\", function (e) { if($.vakata.context.vis && !$.contains($.vakata.context.cnt[0], e.target)) { $.vakata.context.hide(); } });\n\t\tif(typeof $.hotkeys !== \"undefined\") {\n\t\t\t$(document)\n\t\t\t\t.bind(\"keydown\", \"up\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\tvar o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\".vakata-hover\").removeClass(\"vakata-hover\").prevAll(\"li:not(.vakata-separator)\").first();\n\t\t\t\t\t\tif(!o.length) { o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\"li:not(.vakata-separator)\").last(); }\n\t\t\t\t\t\to.addClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"down\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\tvar o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\".vakata-hover\").removeClass(\"vakata-hover\").nextAll(\"li:not(.vakata-separator)\").first();\n\t\t\t\t\t\tif(!o.length) { o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\"li:not(.vakata-separator)\").first(); }\n\t\t\t\t\t\to.addClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"right\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").children(\"ul\").show().children(\"li:not(.vakata-separator)\").removeClass(\"vakata-hover\").first().addClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"left\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").children(\"ul\").hide().children(\".vakata-separator\").removeClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"esc\", function (e) {\n\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t\te.preventDefault();\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"space\", function (e) {\n\t\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").last().children(\"a\").click();\n\t\t\t\t\te.preventDefault();\n\t\t\t\t});\n\t\t}\n\t});\n\n\t$.jstree.plugin(\"contextmenu\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.delegate(\"a\", \"contextmenu.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\tif(!$(e.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.show_contextmenu(e.currentTarget, e.pageX, e.pageY);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"click.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif(this.data.contextmenu) {\n\t\t\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"destroy.jstree\", $.proxy(function () {\n\t\t\t\t\t\t// TODO: move this to descruct method\n\t\t\t\t\t\tif(this.data.contextmenu) {\n\t\t\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t\t$(document).bind(\"context_hide.vakata\", $.proxy(function () { this.data.contextmenu = false; }, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tselect_node : false, // requires UI plugin\n\t\t\tshow_at_node : true,\n\t\t\titems : { // Could be a function that should return an object like this one\n\t\t\t\t\"create\" : {\n\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\"separator_after\"\t: true,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Create\",\n\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.create(obj); }\n\t\t\t\t},\n\t\t\t\t\"rename\" : {\n\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Rename\",\n\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.rename(obj); }\n\t\t\t\t},\n\t\t\t\t\"remove\" : {\n\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Delete\",\n\t\t\t\t\t\"action\"\t\t\t: function (obj) { if(this.is_selected(obj)) { this.remove(); } else { this.remove(obj); } }\n\t\t\t\t},\n\t\t\t\t\"ccp\" : {\n\t\t\t\t\t\"separator_before\"\t: true,\n\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Edit\",\n\t\t\t\t\t\"action\"\t\t\t: false,\n\t\t\t\t\t\"submenu\" : {\n\t\t\t\t\t\t\"cut\" : {\n\t\t\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\t\t\"label\"\t\t\t\t: \"Cut\",\n\t\t\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.cut(obj); }\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"copy\" : {\n\t\t\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\t\t\"label\"\t\t\t\t: \"Copy\",\n\t\t\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.copy(obj); }\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"paste\" : {\n\t\t\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\t\t\"label\"\t\t\t\t: \"Paste\",\n\t\t\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.paste(obj); }\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\tshow_contextmenu : function (obj, x, y) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar s = this.get_settings().contextmenu,\n\t\t\t\t\ta = obj.children(\"a:visible:eq(0)\"),\n\t\t\t\t\to = false,\n\t\t\t\t\ti = false;\n\t\t\t\tif(s.select_node && this.data.ui && !this.is_selected(obj)) {\n\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\tthis.select_node(obj, true);\n\t\t\t\t}\n\t\t\t\tif(s.show_at_node || typeof x === \"undefined\" || typeof y === \"undefined\") {\n\t\t\t\t\to = a.offset();\n\t\t\t\t\tx = o.left;\n\t\t\t\t\ty = o.top + this.data.core.li_height;\n\t\t\t\t}\n\t\t\t\ti = obj.data(\"jstree\") && obj.data(\"jstree\").contextmenu ? obj.data(\"jstree\").contextmenu : s.items;\n\t\t\t\tif($.isFunction(i)) { i = i.call(this, obj); }\n\t\t\t\tthis.data.contextmenu = true;\n\t\t\t\t$.vakata.context.show(i, a, x, y, this, obj, this._get_settings().core.rtl);\n\t\t\t\tif(this.data.themes) { $.vakata.context.cnt.attr(\"class\", \"jstree-\" + this.data.themes.theme + \"-context\"); }\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree types plugin\n * Adds support types of nodes\n * You can set an attribute on each li node, that represents its type.\n * According to the type setting the node may get custom icon/validation rules\n */\n(function ($) {\n\t$.jstree.plugin(\"types\", {\n\t\t__init : function () {\n\t\t\tvar s = this._get_settings().types;\n\t\t\tthis.data.types.attach_to = [];\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function () {\n\t\t\t\t\t\tvar types = s.types,\n\t\t\t\t\t\t\tattr  = s.type_attr,\n\t\t\t\t\t\t\ticons_css = \"\",\n\t\t\t\t\t\t\t_this = this;\n\n\t\t\t\t\t\t$.each(types, function (i, tp) {\n\t\t\t\t\t\t\t$.each(tp, function (k, v) {\n\t\t\t\t\t\t\t\tif(!/^(max_depth|max_children|icon|valid_children)$/.test(k)) { _this.data.types.attach_to.push(k); }\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tif(!tp.icon) { return true; }\n\t\t\t\t\t\t\tif( tp.icon.image || tp.icon.position) {\n\t\t\t\t\t\t\t\tif(i == \"default\")\t{ icons_css += '.jstree-' + _this.get_index() + ' a > .jstree-icon { '; }\n\t\t\t\t\t\t\t\telse\t\t\t\t{ icons_css += '.jstree-' + _this.get_index() + ' li[' + attr + '=\"' + i + '\"] > a > .jstree-icon { '; }\n\t\t\t\t\t\t\t\tif(tp.icon.image)\t{ icons_css += ' background-image:url(' + tp.icon.image + '); '; }\n\t\t\t\t\t\t\t\tif(tp.icon.position){ icons_css += ' background-position:' + tp.icon.position + '; '; }\n\t\t\t\t\t\t\t\telse\t\t\t\t{ icons_css += ' background-position:0 0; '; }\n\t\t\t\t\t\t\t\ticons_css += '} ';\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t\tif(icons_css !== \"\") { $.vakata.css.add_sheet({ 'str' : icons_css, title : \"jstree-types\" }); }\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"before.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar s, t,\n\t\t\t\t\t\t\to = this._get_settings().types.use_data ? this._get_node(data.args[0]) : false,\n\t\t\t\t\t\t\td = o && o !== -1 && o.length ? o.data(\"jstree\") : false;\n\t\t\t\t\t\tif(d && d.types && d.types[data.func] === false) { e.stopImmediatePropagation(); return false; }\n\t\t\t\t\t\tif($.inArray(data.func, this.data.types.attach_to) !== -1) {\n\t\t\t\t\t\t\tif(!data.args[0] || (!data.args[0].tagName && !data.args[0].jquery)) { return; }\n\t\t\t\t\t\t\ts = this._get_settings().types.types;\n\t\t\t\t\t\t\tt = this._get_type(data.args[0]);\n\t\t\t\t\t\t\tif(\n\t\t\t\t\t\t\t\t(\n\t\t\t\t\t\t\t\t\t(s[t] && typeof s[t][data.func] !== \"undefined\") ||\n\t\t\t\t\t\t\t\t\t(s[\"default\"] && typeof s[\"default\"][data.func] !== \"undefined\")\n\t\t\t\t\t\t\t\t) && this._check(data.func, data.args[0]) === false\n\t\t\t\t\t\t\t) {\n\t\t\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t\tif(is_ie6) {\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.bind(\"load_node.jstree set_type.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\t\tvar r = data && data.rslt && data.rslt.obj && data.rslt.obj !== -1 ? this._get_node(data.rslt.obj).parent() : this.get_container_ul(),\n\t\t\t\t\t\t\t\tc = false,\n\t\t\t\t\t\t\t\ts = this._get_settings().types;\n\t\t\t\t\t\t\t$.each(s.types, function (i, tp) {\n\t\t\t\t\t\t\t\tif(tp.icon && (tp.icon.image || tp.icon.position)) {\n\t\t\t\t\t\t\t\t\tc = i === \"default\" ? r.find(\"li > a > .jstree-icon\") : r.find(\"li[\" + s.type_attr + \"='\" + i + \"'] > a > .jstree-icon\");\n\t\t\t\t\t\t\t\t\tif(tp.icon.image) { c.css(\"backgroundImage\",\"url(\" + tp.icon.image + \")\"); }\n\t\t\t\t\t\t\t\t\tc.css(\"backgroundPosition\", tp.icon.position || \"0 0\");\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}, this));\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\t// defines maximum number of root nodes (-1 means unlimited, -2 means disable max_children checking)\n\t\t\tmax_children\t\t: -1,\n\t\t\t// defines the maximum depth of the tree (-1 means unlimited, -2 means disable max_depth checking)\n\t\t\tmax_depth\t\t\t: -1,\n\t\t\t// defines valid node types for the root nodes\n\t\t\tvalid_children\t\t: \"all\",\n\n\t\t\t// whether to use $.data\n\t\t\tuse_data : false,\n\t\t\t// where is the type stores (the rel attribute of the LI element)\n\t\t\ttype_attr : \"rel\",\n\t\t\t// a list of types\n\t\t\ttypes : {\n\t\t\t\t// the default type\n\t\t\t\t\"default\" : {\n\t\t\t\t\t\"max_children\"\t: -1,\n\t\t\t\t\t\"max_depth\"\t\t: -1,\n\t\t\t\t\t\"valid_children\": \"all\"\n\n\t\t\t\t\t// Bound functions - you can bind any other function here (using boolean or function)\n\t\t\t\t\t//\"select_node\"\t: true\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\t_types_notify : function (n, data) {\n\t\t\t\tif(data.type && this._get_settings().types.use_data) {\n\t\t\t\t\tthis.set_type(data.type, n);\n\t\t\t\t}\n\t\t\t},\n\t\t\t_get_type : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn (!obj || !obj.length) ? false : obj.attr(this._get_settings().types.type_attr) || \"default\";\n\t\t\t},\n\t\t\tset_type : function (str, obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar ret = (!obj.length || !str) ? false : obj.attr(this._get_settings().types.type_attr, str);\n\t\t\t\tif(ret) { this.__callback({ obj : obj, type : str}); }\n\t\t\t\treturn ret;\n\t\t\t},\n\t\t\t_check : function (rule, obj, opts) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar v = false, t = this._get_type(obj), d = 0, _this = this, s = this._get_settings().types, data = false;\n\t\t\t\tif(obj === -1) {\n\t\t\t\t\tif(!!s[rule]) { v = s[rule]; }\n\t\t\t\t\telse { return; }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(t === false) { return; }\n\t\t\t\t\tdata = s.use_data ? obj.data(\"jstree\") : false;\n\t\t\t\t\tif(data && data.types && typeof data.types[rule] !== \"undefined\") { v = data.types[rule]; }\n\t\t\t\t\telse if(!!s.types[t] && typeof s.types[t][rule] !== \"undefined\") { v = s.types[t][rule]; }\n\t\t\t\t\telse if(!!s.types[\"default\"] && typeof s.types[\"default\"][rule] !== \"undefined\") { v = s.types[\"default\"][rule]; }\n\t\t\t\t}\n\t\t\t\tif($.isFunction(v)) { v = v.call(this, obj); }\n\t\t\t\tif(rule === \"max_depth\" && obj !== -1 && opts !== false && s.max_depth !== -2 && v !== 0) {\n\t\t\t\t\t// also include the node itself - otherwise if root node it is not checked\n\t\t\t\t\tobj.children(\"a:eq(0)\").parentsUntil(\".jstree\",\"li\").each(function (i) {\n\t\t\t\t\t\t// check if current depth already exceeds global tree depth\n\t\t\t\t\t\tif(s.max_depth !== -1 && s.max_depth - (i + 1) <= 0) { v = 0; return false; }\n\t\t\t\t\t\td = (i === 0) ? v : _this._check(rule, this, false);\n\t\t\t\t\t\t// check if current node max depth is already matched or exceeded\n\t\t\t\t\t\tif(d !== -1 && d - (i + 1) <= 0) { v = 0; return false; }\n\t\t\t\t\t\t// otherwise - set the max depth to the current value minus current depth\n\t\t\t\t\t\tif(d >= 0 && (d - (i + 1) < v || v < 0) ) { v = d - (i + 1); }\n\t\t\t\t\t\t// if the global tree depth exists and it minus the nodes calculated so far is less than `v` or `v` is unlimited\n\t\t\t\t\t\tif(s.max_depth >= 0 && (s.max_depth - (i + 1) < v || v < 0) ) { v = s.max_depth - (i + 1); }\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\treturn v;\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tif(!this.__call_old()) { return false; }\n\t\t\t\tvar m  = this._get_move(),\n\t\t\t\t\ts  = m.rt._get_settings().types,\n\t\t\t\t\tmc = m.rt._check(\"max_children\", m.cr),\n\t\t\t\t\tmd = m.rt._check(\"max_depth\", m.cr),\n\t\t\t\t\tvc = m.rt._check(\"valid_children\", m.cr),\n\t\t\t\t\tch = 0, d = 1, t;\n\n\t\t\t\tif(vc === \"none\") { return false; }\n\t\t\t\tif($.isArray(vc) && m.ot && m.ot._get_type) {\n\t\t\t\t\tm.o.each(function () {\n\t\t\t\t\t\tif($.inArray(m.ot._get_type(this), vc) === -1) { d = false; return false; }\n\t\t\t\t\t});\n\t\t\t\t\tif(d === false) { return false; }\n\t\t\t\t}\n\t\t\t\tif(s.max_children !== -2 && mc !== -1) {\n\t\t\t\t\tch = m.cr === -1 ? this.get_container().find(\"> ul > li\").not(m.o).length : m.cr.find(\"> ul > li\").not(m.o).length;\n\t\t\t\t\tif(ch + m.o.length > mc) { return false; }\n\t\t\t\t}\n\t\t\t\tif(s.max_depth !== -2 && md !== -1) {\n\t\t\t\t\td = 0;\n\t\t\t\t\tif(md === 0) { return false; }\n\t\t\t\t\tif(typeof m.o.d === \"undefined\") {\n\t\t\t\t\t\t// TODO: deal with progressive rendering and async when checking max_depth (how to know the depth of the moved node)\n\t\t\t\t\t\tt = m.o;\n\t\t\t\t\t\twhile(t.length > 0) {\n\t\t\t\t\t\t\tt = t.find(\"> ul > li\");\n\t\t\t\t\t\t\td ++;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tm.o.d = d;\n\t\t\t\t\t}\n\t\t\t\t\tif(md - m.o.d < 0) { return false; }\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tcreate_node : function (obj, position, js, callback, is_loaded, skip_check) {\n\t\t\t\tif(!skip_check && (is_loaded || this._is_loaded(obj))) {\n\t\t\t\t\tvar p  = (typeof position == \"string\" && position.match(/^before|after$/i) && obj !== -1) ? this._get_parent(obj) : this._get_node(obj),\n\t\t\t\t\t\ts  = this._get_settings().types,\n\t\t\t\t\t\tmc = this._check(\"max_children\", p),\n\t\t\t\t\t\tmd = this._check(\"max_depth\", p),\n\t\t\t\t\t\tvc = this._check(\"valid_children\", p),\n\t\t\t\t\t\tch;\n\t\t\t\t\tif(typeof js === \"string\") { js = { data : js }; }\n\t\t\t\t\tif(!js) { js = {}; }\n\t\t\t\t\tif(vc === \"none\") { return false; }\n\t\t\t\t\tif($.isArray(vc)) {\n\t\t\t\t\t\tif(!js.attr || !js.attr[s.type_attr]) {\n\t\t\t\t\t\t\tif(!js.attr) { js.attr = {}; }\n\t\t\t\t\t\t\tjs.attr[s.type_attr] = vc[0];\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif($.inArray(js.attr[s.type_attr], vc) === -1) { return false; }\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif(s.max_children !== -2 && mc !== -1) {\n\t\t\t\t\t\tch = p === -1 ? this.get_container().find(\"> ul > li\").length : p.find(\"> ul > li\").length;\n\t\t\t\t\t\tif(ch + 1 > mc) { return false; }\n\t\t\t\t\t}\n\t\t\t\t\tif(s.max_depth !== -2 && md !== -1 && (md - 1) < 0) { return false; }\n\t\t\t\t}\n\t\t\t\treturn this.__call_old(true, obj, position, js, callback, is_loaded, skip_check);\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree HTML plugin\n * The HTML data store. Datastores are build by replacing the `load_node` and `_is_loaded` functions.\n */\n(function ($) {\n\t$.jstree.plugin(\"html_data\", {\n\t\t__init : function () {\n\t\t\t// this used to use html() and clean the whitespace, but this way any attached data was lost\n\t\t\tthis.data.html_data.original_container_html = this.get_container().find(\" > ul > li\").clone(true);\n\t\t\t// remove white space from LI node - otherwise nodes appear a bit to the right\n\t\t\tthis.data.html_data.original_container_html.find(\"li\").addBack().contents().filter(function() { return this.nodeType == 3; }).remove();\n\t\t},\n\t\tdefaults : {\n\t\t\tdata : false,\n\t\t\tajax : false,\n\t\t\tcorrect_state : true\n\t\t},\n\t\t_fn : {\n\t\t\tload_node : function (obj, s_call, e_call) { var _this = this; this.load_node_html(obj, function () { _this.__callback({ \"obj\" : _this._get_node(obj) }); s_call.call(this); }, e_call); },\n\t\t\t_is_loaded : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj == -1 || !obj || (!this._get_settings().html_data.ajax && !$.isFunction(this._get_settings().html_data.data)) || obj.is(\".jstree-open, .jstree-leaf\") || obj.children(\"ul\").children(\"li\").size() > 0;\n\t\t\t},\n\t\t\tload_node_html : function (obj, s_call, e_call) {\n\t\t\t\tvar d,\n\t\t\t\t\ts = this.get_settings().html_data,\n\t\t\t\t\terror_func = function () {},\n\t\t\t\t\tsuccess_func = function () {};\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\tif(obj.data(\"jstree_is_loading\")) { return; }\n\t\t\t\t\telse { obj.data(\"jstree_is_loading\",true); }\n\t\t\t\t}\n\t\t\t\tswitch(!0) {\n\t\t\t\t\tcase ($.isFunction(s.data)):\n\t\t\t\t\t\ts.data.call(this, obj, $.proxy(function (d) {\n\t\t\t\t\t\t\tif(d && d !== \"\" && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") !== \"\") {\n\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\tif(!d.is(\"ul\")) { d = $(\"<ul />\").append(d); }\n\t\t\t\t\t\t\t\tif(obj == -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()).find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); }\n\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d).children(\"ul\").find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this));\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !s.ajax):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t\t.children(\"ul\").empty()\n\t\t\t\t\t\t\t\t.append(this.data.html_data.original_container_html)\n\t\t\t\t\t\t\t\t.find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end()\n\t\t\t\t\t\t\t\t.filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\");\n\t\t\t\t\t\t\tthis.clean_node();\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!!s.data && !s.ajax) || (!!s.data && !!s.ajax && (!obj || obj === -1)):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\td = $(s.data);\n\t\t\t\t\t\t\tif(!d.is(\"ul\")) { d = $(\"<ul />\").append(d); }\n\t\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t\t.children(\"ul\").empty().append(d.children())\n\t\t\t\t\t\t\t\t.find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end()\n\t\t\t\t\t\t\t\t.filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\");\n\t\t\t\t\t\t\tthis.clean_node();\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !!s.ajax) || (!!s.data && !!s.ajax && obj && obj !== -1):\n\t\t\t\t\t\tobj = this._get_node(obj);\n\t\t\t\t\t\terror_func = function (x, t, e) {\n\t\t\t\t\t\t\tvar ef = this.get_settings().html_data.ajax.error;\n\t\t\t\t\t\t\tif(ef) { ef.call(this, x, t, e); }\n\t\t\t\t\t\t\tif(obj != -1 && obj.length) {\n\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t};\n\t\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\t\tvar sf = this.get_settings().html_data.ajax.success;\n\t\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\t\tif(d === \"\" || (d && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") === \"\")) {\n\t\t\t\t\t\t\t\treturn error_func.call(this, x, t, \"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\tif(!d.is(\"ul\")) { d = $(\"<ul />\").append(d); }\n\t\t\t\t\t\t\t\tif(obj == -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()).find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); }\n\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d).children(\"ul\").find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\t\tif(!s.ajax.dataType) { s.ajax.dataType = \"html\"; }\n\t\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, obj); }\n\t\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, obj); }\n\t\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\t// include the HTML data plugin by default\n\t$.jstree.defaults.plugins.push(\"html_data\");\n})(jQuery);\n//*/\n\n/*\n * jsTree themeroller plugin\n * Adds support for jQuery UI themes. Include this at the end of your plugins list, also make sure \"themes\" is not included.\n */\n(function ($) {\n\t$.jstree.plugin(\"themeroller\", {\n\t\t__init : function () {\n\t\t\tvar s = this._get_settings().themeroller;\n\t\t\tthis.get_container()\n\t\t\t\t.addClass(\"ui-widget-content\")\n\t\t\t\t.addClass(\"jstree-themeroller\")\n\t\t\t\t.delegate(\"a\",\"mouseenter.jstree\", function (e) {\n\t\t\t\t\tif(!$(e.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t$(this).addClass(s.item_h);\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.delegate(\"a\",\"mouseleave.jstree\", function () {\n\t\t\t\t\t$(this).removeClass(s.item_h);\n\t\t\t\t})\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.inst.get_container().find(\"> ul > li > .jstree-loading > ins\").addClass(\"ui-icon-refresh\");\n\t\t\t\t\t\tthis._themeroller(data.inst.get_container().find(\"> ul > li\"));\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"open_node.jstree create_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"loaded.jstree refresh.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tthis._themeroller();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"close_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"delete_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.parent);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"correct_state.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.opened + \" \" + s.closed + \" ui-icon\").end()\n\t\t\t\t\t\t\t.find(\"> a > ins.ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_open + \" \" + s.item_clsd).addClass(s.item_leaf || \"jstree-no-icon\");\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"select_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj.children(\"a\").addClass(s.item_a);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"deselect_node.jstree deselect_all.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t.find(\"a.\" + s.item_a).removeClass(s.item_a).end()\n\t\t\t\t\t\t\t.find(\"a.jstree-clicked\").addClass(s.item_a);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"dehover_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj.children(\"a\").removeClass(s.item_h);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"hover_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t.find(\"a.\" + s.item_h).not(data.rslt.obj).removeClass(s.item_h);\n\t\t\t\t\t\tdata.rslt.obj.children(\"a\").addClass(s.item_h);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.o);\n\t\t\t\t\t\tthis._themeroller(data.rslt.op);\n\t\t\t\t\t}, this));\n\t\t},\n\t\t__destroy : function () {\n\t\t\tvar s = this._get_settings().themeroller,\n\t\t\t\tc = [ \"ui-icon\" ];\n\t\t\t$.each(s, function (i, v) {\n\t\t\t\tv = v.split(\" \");\n\t\t\t\tif(v.length) { c = c.concat(v); }\n\t\t\t});\n\t\t\tthis.get_container()\n\t\t\t\t.removeClass(\"ui-widget-content\")\n\t\t\t\t.find(\".\" + c.join(\", .\")).removeClass(c.join(\" \"));\n\t\t},\n\t\t_fn : {\n\t\t\t_themeroller : function (obj) {\n\t\t\t\tvar s = this._get_settings().themeroller;\n\t\t\t\tobj = !obj || obj == -1 ? this.get_container_ul() : this._get_node(obj).parent();\n\t\t\t\tobj\n\t\t\t\t\t.find(\"li.jstree-closed\")\n\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.opened).addClass(\"ui-icon \" + s.closed).end()\n\t\t\t\t\t\t.children(\"a\").addClass(s.item)\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").addClass(\"ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_leaf + \" \" + s.item_open).addClass(s.item_clsd || \"jstree-no-icon\")\n\t\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t.end()\n\t\t\t\t\t.end()\n\t\t\t\t\t.find(\"li.jstree-open\")\n\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.closed).addClass(\"ui-icon \" + s.opened).end()\n\t\t\t\t\t\t.children(\"a\").addClass(s.item)\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").addClass(\"ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_leaf + \" \" + s.item_clsd).addClass(s.item_open || \"jstree-no-icon\")\n\t\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t.end()\n\t\t\t\t\t.end()\n\t\t\t\t\t.find(\"li.jstree-leaf\")\n\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.closed + \" ui-icon \" + s.opened).end()\n\t\t\t\t\t\t.children(\"a\").addClass(s.item)\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").addClass(\"ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_clsd + \" \" + s.item_open).addClass(s.item_leaf || \"jstree-no-icon\");\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\t\"opened\"\t: \"ui-icon-triangle-1-se\",\n\t\t\t\"closed\"\t: \"ui-icon-triangle-1-e\",\n\t\t\t\"item\"\t\t: \"ui-state-default\",\n\t\t\t\"item_h\"\t: \"ui-state-hover\",\n\t\t\t\"item_a\"\t: \"ui-state-active\",\n\t\t\t\"item_open\"\t: \"ui-icon-folder-open\",\n\t\t\t\"item_clsd\"\t: \"ui-icon-folder-collapsed\",\n\t\t\t\"item_leaf\"\t: \"ui-icon-document\"\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '' +\n\t\t\t'.jstree-themeroller .ui-icon { overflow:visible; } ' +\n\t\t\t'.jstree-themeroller a { padding:0 2px; } ' +\n\t\t\t'.jstree-themeroller .jstree-no-icon { display:none; }';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree unique plugin\n * Forces different names amongst siblings (still a bit experimental)\n * NOTE: does not check language versions (it will not be possible to have nodes with the same title, even in different languages)\n */\n(function ($) {\n\t$.jstree.plugin(\"unique\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"before.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar nms = [], res = true, p, t;\n\t\t\t\t\t\tif(data.func == \"move_node\") {\n\t\t\t\t\t\t\t// obj, ref, position, is_copy, is_prepared, skip_check\n\t\t\t\t\t\t\tif(data.args[4] === true) {\n\t\t\t\t\t\t\t\tif(data.args[0].o && data.args[0].o.length) {\n\t\t\t\t\t\t\t\t\tdata.args[0].o.children(\"a\").each(function () { nms.push($(this).text().replace(/^\\s+/g,\"\")); });\n\t\t\t\t\t\t\t\t\tres = this._check_unique(nms, data.args[0].np.find(\"> ul > li\").not(data.args[0].o), \"move_node\");\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(data.func == \"create_node\") {\n\t\t\t\t\t\t\t// obj, position, js, callback, is_loaded\n\t\t\t\t\t\t\tif(data.args[4] || this._is_loaded(data.args[0])) {\n\t\t\t\t\t\t\t\tp = this._get_node(data.args[0]);\n\t\t\t\t\t\t\t\tif(data.args[1] && (data.args[1] === \"before\" || data.args[1] === \"after\")) {\n\t\t\t\t\t\t\t\t\tp = this._get_parent(data.args[0]);\n\t\t\t\t\t\t\t\t\tif(!p || p === -1) { p = this.get_container(); }\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif(typeof data.args[2] === \"string\") { nms.push(data.args[2]); }\n\t\t\t\t\t\t\t\telse if(!data.args[2] || !data.args[2].data) { nms.push(this._get_string(\"new_node\")); }\n\t\t\t\t\t\t\t\telse { nms.push(data.args[2].data); }\n\t\t\t\t\t\t\t\tres = this._check_unique(nms, p.find(\"> ul > li\"), \"create_node\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(data.func == \"rename_node\") {\n\t\t\t\t\t\t\t// obj, val\n\t\t\t\t\t\t\tnms.push(data.args[1]);\n\t\t\t\t\t\t\tt = this._get_node(data.args[0]);\n\t\t\t\t\t\t\tp = this._get_parent(t);\n\t\t\t\t\t\t\tif(!p || p === -1) { p = this.get_container(); }\n\t\t\t\t\t\t\tres = this._check_unique(nms, p.find(\"> ul > li\").not(t), \"rename_node\");\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(!res) {\n\t\t\t\t\t\t\te.stopPropagation();\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\terror_callback : $.noop\n\t\t},\n\t\t_fn : {\n\t\t\t_check_unique : function (nms, p, func) {\n\t\t\t\tvar cnms = [];\n\t\t\t\tp.children(\"a\").each(function () { cnms.push($(this).text().replace(/^\\s+/g,\"\")); });\n\t\t\t\tif(!cnms.length || !nms.length) { return true; }\n\t\t\t\tcnms = cnms.sort().join(\",,\").replace(/(,|^)([^,]+)(,,\\2)+(,|$)/g,\"$1$2$4\").replace(/,,+/g,\",\").replace(/,$/,\"\").split(\",\");\n\t\t\t\tif((cnms.length + nms.length) != cnms.concat(nms).sort().join(\",,\").replace(/(,|^)([^,]+)(,,\\2)+(,|$)/g,\"$1$2$4\").replace(/,,+/g,\",\").replace(/,$/,\"\").split(\",\").length) {\n\t\t\t\t\tthis._get_settings().unique.error_callback.call(null, nms, p, func);\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tif(!this.__call_old()) { return false; }\n\t\t\t\tvar p = this._get_move(), nms = [];\n\t\t\t\tif(p.o && p.o.length) {\n\t\t\t\t\tp.o.children(\"a\").each(function () { nms.push($(this).text().replace(/^\\s+/g,\"\")); });\n\t\t\t\t\treturn this._check_unique(nms, p.np.find(\"> ul > li\").not(p.o), \"check_move\");\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree wholerow plugin\n * Makes select and hover work on the entire width of the node\n * MAY BE HEAVY IN LARGE DOM\n */\n(function ($) {\n\t$.jstree.plugin(\"wholerow\", {\n\t\t__init : function () {\n\t\t\tif(!this.data.ui) { throw \"jsTree wholerow: jsTree UI plugin not included.\"; }\n\t\t\tthis.data.wholerow.html = false;\n\t\t\tthis.data.wholerow.to = false;\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._get_settings().core.animation = 0;\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"open_node.jstree create_node.jstree clean_node.jstree loaded.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._prepare_wholerow_span( data && data.rslt && data.rslt.obj ? data.rslt.obj : -1 );\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"search.jstree clear_search.jstree reopen.jstree after_open.jstree after_close.jstree create_node.jstree delete_node.jstree clean_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tif(this.data.to) { clearTimeout(this.data.to); }\n\t\t\t\t\t\tthis.data.to = setTimeout( (function (t, o) { return function() { t._prepare_wholerow_ul(o); }; })(this,  data && data.rslt && data.rslt.obj ? data.rslt.obj : -1), 0);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"deselect_all.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container().find(\" > .jstree-wholerow .jstree-clicked\").removeClass(\"jstree-clicked \" + (this.data.themeroller ? this._get_settings().themeroller.item_a : \"\" ));\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"select_node.jstree deselect_node.jstree \", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj.each(function () {\n\t\t\t\t\t\t\tvar ref = data.inst.get_container().find(\" > .jstree-wholerow li:visible:eq(\" + ( parseInt((($(this).offset().top - data.inst.get_container().offset().top + data.inst.get_container()[0].scrollTop) / data.inst.data.core.li_height),10)) + \")\");\n\t\t\t\t\t\t\t// ref.children(\"a\")[e.type === \"select_node\" ? \"addClass\" : \"removeClass\"](\"jstree-clicked\");\n\t\t\t\t\t\t\tref.children(\"a\").attr(\"class\",data.rslt.obj.children(\"a\").attr(\"class\"));\n\t\t\t\t\t\t});\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"hover_node.jstree dehover_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container().find(\" > .jstree-wholerow .jstree-hovered\").removeClass(\"jstree-hovered \" + (this.data.themeroller ? this._get_settings().themeroller.item_h : \"\" ));\n\t\t\t\t\t\tif(e.type === \"hover_node\") {\n\t\t\t\t\t\t\tvar ref = this.get_container().find(\" > .jstree-wholerow li:visible:eq(\" + ( parseInt(((data.rslt.obj.offset().top - this.get_container().offset().top + this.get_container()[0].scrollTop) / this.data.core.li_height),10)) + \")\");\n\t\t\t\t\t\t\t// ref.children(\"a\").addClass(\"jstree-hovered\");\n\t\t\t\t\t\t\tref.children(\"a\").attr(\"class\",data.rslt.obj.children(\".jstree-hovered\").attr(\"class\"));\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\".jstree-wholerow-span, ins.jstree-icon, li\", \"click.jstree\", function (e) {\n\t\t\t\t\t\tvar n = $(e.currentTarget);\n\t\t\t\t\t\tif(e.target.tagName === \"A\" || (e.target.tagName === \"INS\" && n.closest(\"li\").is(\".jstree-open, .jstree-closed\"))) { return; }\n\t\t\t\t\t\tn.closest(\"li\").children(\"a:visible:eq(0)\").click();\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t})\n\t\t\t\t.delegate(\"li\", \"mouseover.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\tif($(e.currentTarget).children(\".jstree-hovered, .jstree-clicked\").length) { return false; }\n\t\t\t\t\t\tthis.hover_node(e.currentTarget);\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"li\", \"mouseleave.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($(e.currentTarget).children(\"a\").hasClass(\"jstree-hovered\").length) { return; }\n\t\t\t\t\t\tthis.dehover_node(e.currentTarget);\n\t\t\t\t\t}, this));\n\t\t\tif(is_ie7 || is_ie6) {\n\t\t\t\t$.vakata.css.add_sheet({ str : \".jstree-\" + this.get_index() + \" { position:relative; } \", title : \"jstree\" });\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t},\n\t\t__destroy : function () {\n\t\t\tthis.get_container().children(\".jstree-wholerow\").remove();\n\t\t\tthis.get_container().find(\".jstree-wholerow-span\").remove();\n\t\t},\n\t\t_fn : {\n\t\t\t_prepare_wholerow_span : function (obj) {\n\t\t\t\tobj = !obj || obj == -1 ? this.get_container().find(\"> ul > li\") : this._get_node(obj);\n\t\t\t\tif(obj === false) { return; } // added for removing root nodes\n\t\t\t\tobj.each(function () {\n\t\t\t\t\t$(this).find(\"li\").addBack().each(function () {\n\t\t\t\t\t\tvar $t = $(this);\n\t\t\t\t\t\tif($t.children(\".jstree-wholerow-span\").length) { return true; }\n\t\t\t\t\t\t$t.prepend(\"<span class='jstree-wholerow-span' style='width:\" + ($t.parentsUntil(\".jstree\",\"li\").length * 18) + \"px;'>&#160;</span>\");\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t},\n\t\t\t_prepare_wholerow_ul : function () {\n\t\t\t\tvar o = this.get_container().children(\"ul\").eq(0), h = o.html();\n\t\t\t\to.addClass(\"jstree-wholerow-real\");\n\t\t\t\tif(this.data.wholerow.last_html !== h) {\n\t\t\t\t\tthis.data.wholerow.last_html = h;\n\t\t\t\t\tthis.get_container().children(\".jstree-wholerow\").remove();\n\t\t\t\t\tthis.get_container().append(\n\t\t\t\t\t\to.clone().removeClass(\"jstree-wholerow-real\")\n\t\t\t\t\t\t\t.wrapAll(\"<div class='jstree-wholerow' />\").parent()\n\t\t\t\t\t\t\t.width(o.parent()[0].scrollWidth)\n\t\t\t\t\t\t\t.css(\"top\", (o.height() + ( is_ie7 ? 5 : 0)) * -1 )\n\t\t\t\t\t\t\t.find(\"li[id]\").each(function () { this.removeAttribute(\"id\"); }).end()\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '' +\n\t\t\t'.jstree .jstree-wholerow-real { position:relative; z-index:1; } ' +\n\t\t\t'.jstree .jstree-wholerow-real li { cursor:pointer; } ' +\n\t\t\t'.jstree .jstree-wholerow-real a { border-left-color:transparent !important; border-right-color:transparent !important; } ' +\n\t\t\t'.jstree .jstree-wholerow { position:relative; z-index:0; height:0; } ' +\n\t\t\t'.jstree .jstree-wholerow ul, .jstree .jstree-wholerow li { width:100%; } ' +\n\t\t\t'.jstree .jstree-wholerow, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow li, .jstree .jstree-wholerow a { margin:0 !important; padding:0 !important; } ' +\n\t\t\t'.jstree .jstree-wholerow, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow li { background:transparent !important; }' +\n\t\t\t'.jstree .jstree-wholerow ins, .jstree .jstree-wholerow span, .jstree .jstree-wholerow input { display:none !important; }' +\n\t\t\t'.jstree .jstree-wholerow a, .jstree .jstree-wholerow a:hover { text-indent:-9999px; !important; width:100%; padding:0 !important; border-right-width:0px !important; border-left-width:0px !important; } ' +\n\t\t\t'.jstree .jstree-wholerow-span { position:absolute; left:0; margin:0px; padding:0; height:18px; border-width:0; padding:0; z-index:0; }';\n\t\tif(is_ff2) {\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree .jstree-wholerow a { display:block; height:18px; margin:0; padding:0; border:0; } ' +\n\t\t\t\t'.jstree .jstree-wholerow-real a { border-color:transparent !important; } ';\n\t\t}\n\t\tif(is_ie7 || is_ie6) {\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree .jstree-wholerow, .jstree .jstree-wholerow li, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow a { margin:0; padding:0; line-height:18px; } ' +\n\t\t\t\t'.jstree .jstree-wholerow a { display:block; height:18px; line-height:18px; overflow:hidden; } ';\n\t\t}\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n})(jQuery);\n//*/\n\n/*\n* jsTree model plugin\n* This plugin gets jstree to use a class model to retrieve data, creating great dynamism\n*/\n(function ($) {\n\tvar nodeInterface = [\"getChildren\",\"getChildrenCount\",\"getAttr\",\"getName\",\"getProps\"],\n\t\tvalidateInterface = function(obj, inter) {\n\t\t\tvar valid = true;\n\t\t\tobj = obj || {};\n\t\t\tinter = [].concat(inter);\n\t\t\t$.each(inter, function (i, v) {\n\t\t\t\tif(!$.isFunction(obj[v])) { valid = false; return false; }\n\t\t\t});\n\t\t\treturn valid;\n\t\t};\n\t$.jstree.plugin(\"model\", {\n\t\t__init : function () {\n\t\t\tif(!this.data.json_data) { throw \"jsTree model: jsTree json_data plugin not included.\"; }\n\t\t\tthis._get_settings().json_data.data = function (n, b) {\n\t\t\t\tvar obj = (n == -1) ? this._get_settings().model.object : n.data(\"jstree_model\");\n\t\t\t\tif(!validateInterface(obj, nodeInterface)) { return b.call(null, false); }\n\t\t\t\tif(this._get_settings().model.async) {\n\t\t\t\t\tobj.getChildren($.proxy(function (data) {\n\t\t\t\t\t\tthis.model_done(data, b);\n\t\t\t\t\t}, this));\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.model_done(obj.getChildren(), b);\n\t\t\t\t}\n\t\t\t};\n\t\t},\n\t\tdefaults : {\n\t\t\tobject : false,\n\t\t\tid_prefix : false,\n\t\t\tasync : false\n\t\t},\n\t\t_fn : {\n\t\t\tmodel_done : function (data, callback) {\n\t\t\t\tvar ret = [],\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this;\n\n\t\t\t\tif(!$.isArray(data)) { data = [data]; }\n\t\t\t\t$.each(data, function (i, nd) {\n\t\t\t\t\tvar r = nd.getProps() || {};\n\t\t\t\t\tr.attr = nd.getAttr() || {};\n\t\t\t\t\tif(nd.getChildrenCount()) { r.state = \"closed\"; }\n\t\t\t\t\tr.data = nd.getName();\n\t\t\t\t\tif(!$.isArray(r.data)) { r.data = [r.data]; }\n\t\t\t\t\tif(_this.data.types && $.isFunction(nd.getType)) {\n\t\t\t\t\t\tr.attr[s.types.type_attr] = nd.getType();\n\t\t\t\t\t}\n\t\t\t\t\tif(r.attr.id && s.model.id_prefix) { r.attr.id = s.model.id_prefix + r.attr.id; }\n\t\t\t\t\tif(!r.metadata) { r.metadata = { }; }\n\t\t\t\t\tr.metadata.jstree_model = nd;\n\t\t\t\t\tret.push(r);\n\t\t\t\t});\n\t\t\t\tcallback.call(null, ret);\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n\n/*\n * jsTree checkbox plugin copy-paste\n * change_state method was modified\n * refactoring is needed after update to a newer version of jstree, that supports plugin extending\n */\n(function ($) {\n    $.jstree.plugin(\"vcheckbox\", {\n        __init : function () {\n            this.data.vcheckbox.noui = this._get_settings().vcheckbox.override_ui;\n            if(this.data.ui && this.data.vcheckbox.noui) {\n                this.select_node = this.deselect_node = this.deselect_all = $.noop;\n                this.get_selected = this.get_checked;\n            }\n\n            this.get_container()\n                .bind(\"open_node.jstree create_node.jstree clean_node.jstree refresh.jstree\", $.proxy(function (e, data) {\n                    this._prepare_checkboxes(data.rslt.obj);\n                }, this))\n                .bind(\"loaded.jstree\", $.proxy(function (e) {\n                    this._prepare_checkboxes();\n                }, this))\n                .delegate( (this.data.ui && this.data.vcheckbox.noui ? \"a\" : \"ins.jstree-checkbox\") , \"click.jstree\", $.proxy(function (e) {\n                    e.preventDefault();\n                    if(this._get_node(e.target).hasClass(\"jstree-checked\")) { this.uncheck_node(e.target); }\n                    else { this.check_node(e.target); }\n                    if(this.data.ui && this.data.vcheckbox.noui) {\n                        this.save_selected();\n                        if(this.data.cookies) { this.save_cookie(\"select_node\"); }\n                    }\n                    else {\n                        e.stopImmediatePropagation();\n                        return false;\n                    }\n                }, this));\n        },\n        defaults : {\n            override_ui : false,\n            two_state : false,\n            real_checkboxes : false,\n            checked_parent_open : true,\n            real_checkboxes_names : function (n) { return [ (\"check_\" + (n[0].id || Math.ceil(Math.random() * 10000))) , 1]; }\n        },\n        __destroy : function () {\n            this.get_container()\n                .find(\"input.jstree-real-checkbox\").removeClass(\"jstree-real-checkbox\").end()\n                .find(\"ins.jstree-checkbox\").remove();\n        },\n        _fn : {\n            _checkbox_notify : function (n, data) {\n                if(data.checked) {\n                    this.check_node(n, false);\n                }\n            },\n            _prepare_checkboxes : function (obj) {\n                obj = !obj || obj == -1 ? this.get_container().find(\"> ul > li\") : this._get_node(obj);\n                if(obj === false) { return; } // added for removing root nodes\n                var c, _this = this, t, ts = this._get_settings().vcheckbox.two_state, rc = this._get_settings().vcheckbox.real_checkboxes, rcn = this._get_settings().vcheckbox.real_checkboxes_names;\n                obj.each(function () {\n                    t = $(this);\n                    c = t.is(\"li\") && (t.hasClass(\"jstree-checked\") || (rc && t.children(\":checked\").length)) ? \"jstree-checked\" : \"jstree-unchecked\";\n                    t.find(\"li\").addBack().each(function () {\n                        var $t = $(this), nm;\n                        $t.children(\"a\" + (_this.data.languages ? \"\" : \":eq(0)\") ).not(\":has(.jstree-checkbox)\").prepend(\"<ins class='jstree-checkbox'>&#160;</ins>\").parent().not(\".jstree-checked, .jstree-unchecked\").addClass( ts ? \"jstree-unchecked\" : c );\n                        if(rc) {\n                            if(!$t.children(\":checkbox\").length) {\n                                nm = rcn.call(_this, $t);\n                                $t.prepend(\"<input type='checkbox' class='jstree-real-checkbox' id='\" + nm[0] + \"' name='\" + nm[0] + \"' value='\" + nm[1] + \"' />\");\n                            }\n                            else {\n                                $t.children(\":checkbox\").addClass(\"jstree-real-checkbox\");\n                            }\n                        }\n                        if(!ts) {\n                            if(c === \"jstree-checked\" || $t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n                                $t.find(\"li\").addBack().addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n                            }\n                        }\n                        else {\n                            if($t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n                                $t.addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n                            }\n                        }\n                    });\n                });\n                if(!ts) {\n                    obj.find(\".jstree-checked\").parent().parent().each(function () { _this._repair_state(this); });\n                }\n            },\n            change_state : function (obj, state) {\n                obj = this._get_node(obj);\n                var coll = false, rc = this._get_settings().vcheckbox.real_checkboxes;\n                if(!obj || obj === -1) { return false; }\n                state = (state === false || state === true) ? state : obj.hasClass(\"jstree-checked\");\n                if(this._get_settings().vcheckbox.two_state) {\n                    if(state) {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-checked\").length) { return false; }\n                        coll.removeClass(\"jstree-checked\").addClass(\"jstree-unchecked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", false); }\n                    }\n                    else {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-unchecked\").length) { return false; }\n                        coll.removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", true); }\n                        if(this.data.ui) { this.data.ui.last_selected = obj; }\n                        this.data.vcheckbox.last_selected = obj;\n                    }\n                    obj.parentsUntil(\".jstree\", \"li\").each(function () {\n                        var $this = $(this);\n                        if(state) {\n                            if($this.children(\"ul\").children(\"li.jstree-checked\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", true); }\n                                return false;\n                            }\n                        }\n                        else {\n                            if($this.children(\"ul\").children(\"li.jstree-unchecked\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", true); }\n                                return false;\n                            }\n                            else {\n                                $this.removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                                if(rc) { $this.children(\":checkbox\").prop(\"checked\", true); }\n                            }\n                        }\n                    });\n                }\n                else {\n                    if(state) {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-checked, .jstree-undetermined\").length) { return false; }\n                        coll.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", false); }\n                    }\n                    else {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-unchecked, .jstree-undetermined\").length) { return false; }\n                        coll.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", true); }\n                        if(this.data.ui) { this.data.ui.last_selected = obj; }\n                        this.data.vcheckbox.last_selected = obj;\n                    }\n                    obj.parentsUntil(\".jstree\", \"li\").each(function () {\n                        var $this = $(this);\n                        if(state) {\n                            if($this.children(\"ul\").children(\"li.jstree-checked, li.jstree-undetermined\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n                                return false;\n                            }\n                            else {\n                                $this.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n                                if(rc) { $this.children(\":checkbox\").prop(\"checked\", false); }\n                            }\n                        }\n                        else {\n                            if($this.children(\"ul\").children(\"li.jstree-unchecked, li.jstree-undetermined\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n                                return false;\n                            }\n                            else {\n                                $this.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n                                if(rc) { $this.children(\":checkbox\").prop(\"checked\", true); }\n                            }\n                        }\n                    });\n                }\n                if(this.data.ui && this.data.vcheckbox.noui) { this.data.ui.selected = this.get_checked(); }\n                this.__callback(obj);\n                return true;\n            },\n            check_node : function (obj) {\n                if(this.change_state(obj, false)) {\n                    obj = this._get_node(obj);\n                    if(this._get_settings().vcheckbox.checked_parent_open) {\n                        var t = this;\n                        obj.parents(\".jstree-closed\").each(function () { t.open_node(this, false, true); });\n                    }\n                    this.__callback({ \"obj\" : obj });\n                }\n            },\n            uncheck_node : function (obj) {\n                if(this.change_state(obj, true)) { this.__callback({ \"obj\" : this._get_node(obj) }); }\n            },\n            check_all : function () {\n                var _this = this,\n                    coll = this._get_settings().vcheckbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n                coll.each(function () {\n                    _this.change_state(this, false);\n                });\n                this.__callback();\n            },\n            uncheck_all : function () {\n                var _this = this,\n                    coll = this._get_settings().vcheckbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n                coll.each(function () {\n                    _this.change_state(this, true);\n                });\n                this.__callback();\n            },\n\n            is_checked : function(obj) {\n                obj = this._get_node(obj);\n                return obj.length ? obj.is(\".jstree-checked\") : false;\n            },\n            get_checked : function (obj, get_all) {\n                obj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n                return get_all || this._get_settings().vcheckbox.two_state ? obj.find(\".jstree-checked\") : obj.find(\"> ul > .jstree-checked, .jstree-undetermined > ul > .jstree-checked\");\n            },\n            get_unchecked : function (obj, get_all) {\n                obj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n                return get_all || this._get_settings().vcheckbox.two_state ? obj.find(\".jstree-unchecked\") : obj.find(\"> ul > .jstree-unchecked, .jstree-undetermined > ul > .jstree-unchecked\");\n            },\n\n            show_checkboxes : function () { this.get_container().children(\"ul\").removeClass(\"jstree-no-checkboxes\"); },\n            hide_checkboxes : function () { this.get_container().children(\"ul\").addClass(\"jstree-no-checkboxes\"); },\n\n            _repair_state : function (obj) {\n                obj = this._get_node(obj);\n                if(!obj.length) { return; }\n                if(this._get_settings().vcheckbox.two_state) {\n                    obj.find('li').addBack().not('.jstree-checked').removeClass('jstree-undetermined').addClass('jstree-unchecked').children(':checkbox').prop('checked', true);\n                    return;\n                }\n                var rc = this._get_settings().vcheckbox.real_checkboxes,\n                    a = obj.find(\"> ul > .jstree-checked\").length,\n                    b = obj.find(\"> ul > .jstree-undetermined\").length,\n                    c = obj.find(\"> ul > li\").length;\n                if(c === 0) { if(obj.hasClass(\"jstree-undetermined\")) { this.change_state(obj, false); } }\n                else if(a === 0 && b === 0) { this.change_state(obj, true); }\n                else if(a === c) { this.change_state(obj, false); }\n                else {\n                    obj.parentsUntil(\".jstree\",\"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n                    if(rc) { obj.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n                }\n            },\n            reselect : function () {\n                if(this.data.ui && this.data.vcheckbox.noui) {\n                    var _this = this,\n                        s = this.data.ui.to_select;\n                    s = $.map($.makeArray(s), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n                    this.deselect_all();\n                    $.each(s, function (i, val) { _this.check_node(val); });\n                    this.__callback();\n                }\n                else {\n                    this.__call_old();\n                }\n            },\n            save_loaded : function () {\n                var _this = this;\n                this.data.core.to_load = [];\n                this.get_container_ul().find(\"li.jstree-closed.jstree-undetermined\").each(function () {\n                    if(this.id) { _this.data.core.to_load.push(\"#\" + this.id); }\n                });\n            }\n        }\n    });\n    $(function() {\n        var css_string = '.jstree .jstree-real-checkbox { display:none; } ';\n        $.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n    });\n})(jQuery);\n\n\n})();\n\n}));","jquery/jstree/jquery.hotkeys.js":"/*\n * jQuery Hotkeys Plugin\n * Copyright 2010, John Resig\n * Dual licensed under the MIT or GPL Version 2 licenses.\n *\n * Based upon the plugin by Tzury Bar Yochay:\n * http://github.com/tzuryby/hotkeys\n *\n * Original idea by:\n * Binny V A, http://www.openjs.com/scripts/events/keyboard_shortcuts/\n*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\"jquery\"], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function (jQuery) {\n\n\tjQuery.hotkeys = {\n\t\tversion: \"0.8\",\n\n\t\tspecialKeys: {\n\t\t\t8: \"backspace\", 9: \"tab\", 13: \"return\", 16: \"shift\", 17: \"ctrl\", 18: \"alt\", 19: \"pause\",\n\t\t\t20: \"capslock\", 27: \"esc\", 32: \"space\", 33: \"pageup\", 34: \"pagedown\", 35: \"end\", 36: \"home\",\n\t\t\t37: \"left\", 38: \"up\", 39: \"right\", 40: \"down\", 45: \"insert\", 46: \"del\", \n\t\t\t96: \"0\", 97: \"1\", 98: \"2\", 99: \"3\", 100: \"4\", 101: \"5\", 102: \"6\", 103: \"7\",\n\t\t\t104: \"8\", 105: \"9\", 106: \"*\", 107: \"+\", 109: \"-\", 110: \".\", 111 : \"/\", \n\t\t\t112: \"f1\", 113: \"f2\", 114: \"f3\", 115: \"f4\", 116: \"f5\", 117: \"f6\", 118: \"f7\", 119: \"f8\", \n\t\t\t120: \"f9\", 121: \"f10\", 122: \"f11\", 123: \"f12\", 144: \"numlock\", 145: \"scroll\", 191: \"/\", 224: \"meta\"\n\t\t},\n\t\n\t\tshiftNums: {\n\t\t\t\"`\": \"~\", \"1\": \"!\", \"2\": \"@\", \"3\": \"#\", \"4\": \"$\", \"5\": \"%\", \"6\": \"^\", \"7\": \"&\", \n\t\t\t\"8\": \"*\", \"9\": \"(\", \"0\": \")\", \"-\": \"_\", \"=\": \"+\", \";\": \": \", \"'\": \"\\\"\", \",\": \"<\", \n\t\t\t\".\": \">\",  \"/\": \"?\",  \"\\\\\": \"|\"\n\t\t}\n\t};\n\n\tfunction keyHandler( handleObj ) {\n\t\t// Only care when a possible input has been specified\n\t\tif ( typeof handleObj.data !== \"string\" ) {\n\t\t\treturn;\n\t\t}\n\t\t\n\t\tvar origHandler = handleObj.handler,\n\t\t\tkeys = handleObj.data.toLowerCase().split(\" \");\n\t\n\t\thandleObj.handler = function( event ) {\n\t\t\t// Don't fire in text-accepting inputs that we didn't directly bind to\n\t\t\tif ( this !== event.target && (/textarea|select/i.test( event.target.nodeName ) ||\n\t\t\t\t event.target.type === \"text\") ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\t\n\t\t\t// Keypress represents characters, not special keys\n\t\t\tvar special = event.type !== \"keypress\" && jQuery.hotkeys.specialKeys[ event.which ],\n\t\t\t\tcharacter = String.fromCharCode( event.which ).toLowerCase(),\n\t\t\t\tkey, modif = \"\", possible = {};\n\n\t\t\t// check combinations (alt|ctrl|shift+anything)\n\t\t\tif ( event.altKey && special !== \"alt\" ) {\n\t\t\t\tmodif += \"alt+\";\n\t\t\t}\n\n\t\t\tif ( event.ctrlKey && special !== \"ctrl\" ) {\n\t\t\t\tmodif += \"ctrl+\";\n\t\t\t}\n\t\t\t\n\t\t\t// TODO: Need to make sure this works consistently across platforms\n\t\t\tif ( event.metaKey && !event.ctrlKey && special !== \"meta\" ) {\n\t\t\t\tmodif += \"meta+\";\n\t\t\t}\n\n\t\t\tif ( event.shiftKey && special !== \"shift\" ) {\n\t\t\t\tmodif += \"shift+\";\n\t\t\t}\n\n\t\t\tif ( special ) {\n\t\t\t\tpossible[ modif + special ] = true;\n\n\t\t\t} else {\n\t\t\t\tpossible[ modif + character ] = true;\n\t\t\t\tpossible[ modif + jQuery.hotkeys.shiftNums[ character ] ] = true;\n\n\t\t\t\t// \"$\" can be triggered as \"Shift+4\" or \"Shift+$\" or just \"$\"\n\t\t\t\tif ( modif === \"shift+\" ) {\n\t\t\t\t\tpossible[ jQuery.hotkeys.shiftNums[ character ] ] = true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfor ( var i = 0, l = keys.length; i < l; i++ ) {\n\t\t\t\tif ( possible[ keys[i] ] ) {\n\t\t\t\t\treturn origHandler.apply( this, arguments );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n\tjQuery.each([ \"keydown\", \"keyup\", \"keypress\" ], function() {\n\t\tjQuery.event.special[ this ] = { add: keyHandler };\n\t});\n\n}));","jquery/fileUploader/jquery.iframe-transport.js":"/*\n * jQuery Iframe Transport Plugin 1.5\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*jslint unparam: true, nomen: true */\n/*global define, window, document */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define(['jquery'], factory);\n    } else {\n        // Browser globals:\n        factory(window.jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    // Helper variable to create unique names for the transport iframes:\n    var counter = 0;\n\n    // The iframe transport accepts three additional options:\n    // options.fileInput: a jQuery collection of file input fields\n    // options.paramName: the parameter name for the file form data,\n    //  overrides the name property of the file input field(s),\n    //  can be a string or an array of strings.\n    // options.formData: an array of objects with name and value properties,\n    //  equivalent to the return data of .serializeArray(), e.g.:\n    //  [{name: 'a', value: 1}, {name: 'b', value: 2}]\n    $.ajaxTransport('iframe', function (options) {\n        if (options.async && (options.type === 'POST' || options.type === 'GET')) {\n            var form,\n                iframe;\n            return {\n                send: function (_, completeCallback) {\n                    form = $('<form style=\"display:none;\"></form>');\n                    form.attr('accept-charset', options.formAcceptCharset);\n                    // javascript:false as initial iframe src\n                    // prevents warning popups on HTTPS in IE6.\n                    // IE versions below IE8 cannot set the name property of\n                    // elements that have already been added to the DOM,\n                    // so we set the name along with the iframe HTML markup:\n                    iframe = $(\n                        '<iframe src=\"javascript:false;\" name=\"iframe-transport-' +\n                            (counter += 1) + '\"></iframe>'\n                    ).bind('load', function () {\n                        var fileInputClones,\n                            paramNames = $.isArray(options.paramName) ?\n                                    options.paramName : [options.paramName];\n                        iframe\n                            .unbind('load')\n                            .bind('load', function () {\n                                var response;\n                                // Wrap in a try/catch block to catch exceptions thrown\n                                // when trying to access cross-domain iframe contents:\n                                try {\n                                    response = iframe.contents();\n                                    // Google Chrome and Firefox do not throw an\n                                    // exception when calling iframe.contents() on\n                                    // cross-domain requests, so we unify the response:\n                                    if (!response.length || !response[0].firstChild) {\n                                        throw new Error();\n                                    }\n                                } catch (e) {\n                                    response = undefined;\n                                }\n                                // The complete callback returns the\n                                // iframe content document as response object:\n                                completeCallback(\n                                    200,\n                                    'success',\n                                    {'iframe': response}\n                                );\n                                // Fix for IE endless progress bar activity bug\n                                // (happens on form submits to iframe targets):\n                                $('<iframe src=\"javascript:false;\"></iframe>')\n                                    .appendTo(form);\n                                form.remove();\n                            });\n                        form\n                            .prop('target', iframe.prop('name'))\n                            .prop('action', options.url)\n                            .prop('method', options.type);\n                        if (options.formData) {\n                            $.each(options.formData, function (index, field) {\n                                $('<input type=\"hidden\"/>')\n                                    .prop('name', field.name)\n                                    .val(field.value)\n                                    .appendTo(form);\n                            });\n                        }\n                        if (options.fileInput && options.fileInput.length &&\n                                options.type === 'POST') {\n                            fileInputClones = options.fileInput.clone();\n                            // Insert a clone for each file input field:\n                            options.fileInput.after(function (index) {\n                                return fileInputClones[index];\n                            });\n                            if (options.paramName) {\n                                options.fileInput.each(function (index) {\n                                    $(this).prop(\n                                        'name',\n                                        paramNames[index] || options.paramName\n                                    );\n                                });\n                            }\n                            // Appending the file input fields to the hidden form\n                            // removes them from their original location:\n                            form\n                                .append(options.fileInput)\n                                .prop('enctype', 'multipart/form-data')\n                                // enctype must be set as encoding for IE:\n                                .prop('encoding', 'multipart/form-data');\n                        }\n                        form.submit();\n                        // Insert the file input fields at their original location\n                        // by replacing the clones with the originals:\n                        if (fileInputClones && fileInputClones.length) {\n                            options.fileInput.each(function (index, input) {\n                                var clone = $(fileInputClones[index]);\n                                $(input).prop('name', clone.prop('name'));\n                                clone.replaceWith(input);\n                            });\n                        }\n                    });\n                    form.append(iframe).appendTo(document.body);\n                },\n                abort: function () {\n                    if (iframe) {\n                        // javascript:false as iframe src aborts the request\n                        // and prevents warning popups on HTTPS in IE6.\n                        // concat is used to avoid the \"Script URL\" JSLint error:\n                        iframe\n                            .unbind('load')\n                            .prop('src', 'javascript'.concat(':false;'));\n                    }\n                    if (form) {\n                        form.remove();\n                    }\n                }\n            };\n        }\n    });\n\n    // The iframe transport returns the iframe content document as response.\n    // The following adds converters from iframe to text, json, html, and script:\n    $.ajaxSetup({\n        converters: {\n            'iframe text': function (iframe) {\n                return $(iframe[0].body).text();\n            },\n            'iframe json': function (iframe) {\n                return $.parseJSON($(iframe[0].body).text());\n            },\n            'iframe html': function (iframe) {\n                return $(iframe[0].body).html();\n            },\n            'iframe script': function (iframe) {\n                return $.globalEval($(iframe[0].body).text());\n            }\n        }\n    });\n\n}));\n","jquery/fileUploader/locale.js":"/*\n * jQuery File Upload Plugin Localization Example 6.5.1\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2012, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*global window */\n\nwindow.locale = {\n    \"fileupload\": {\n        \"errors\": {\n            \"maxFileSize\": \"File is too big\",\n            \"minFileSize\": \"File is too small\",\n            \"acceptFileTypes\": \"Filetype not allowed\",\n            \"maxNumberOfFiles\": \"Max number of files exceeded\",\n            \"uploadedBytes\": \"Uploaded bytes exceed file size\",\n            \"emptyResult\": \"Empty file upload result\"\n        },\n        \"error\": \"Error\",\n        \"start\": \"Start\",\n        \"cancel\": \"Cancel\",\n        \"destroy\": \"Delete\"\n    }\n};\n","jquery/fileUploader/jquery.fileupload-ui.js":"/*\n * jQuery File Upload User Interface Plugin 6.9.5\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2010, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*jslint nomen: true, unparam: true, regexp: true */\n/*global define, window, document, URL, webkitURL, FileReader */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define([\n            'jquery',\n            'mage/template',\n            'jquery/fileUploader/load-image',\n            'jquery/fileUploader/jquery.fileupload-fp',\n            'jquery/fileUploader/jquery.iframe-transport'\n        ], factory);\n    } else {\n        // Browser globals:\n        factory(\n            window.jQuery,\n            window.mageTemplate,\n            window.loadImage\n        );\n    }\n}(function ($, tmpl, loadImage) {\n    'use strict';\n\n    // The UI version extends the FP (file processing) version or the basic\n    // file upload widget and adds complete user interface interaction:\n    var parentWidget = ($.blueimpFP || $.blueimp).fileupload;\n    $.widget('blueimpUI.fileupload', parentWidget, {\n\n        options: {\n            // By default, files added to the widget are uploaded as soon\n            // as the user clicks on the start buttons. To enable automatic\n            // uploads, set the following option to true:\n            autoUpload: false,\n            // The following option limits the number of files that are\n            // allowed to be uploaded using this widget:\n            maxNumberOfFiles: undefined,\n            // The maximum allowed file size:\n            maxFileSize: undefined,\n            // The minimum allowed file size:\n            minFileSize: undefined,\n            // The regular expression for allowed file types, matches\n            // against either file type or file name:\n            acceptFileTypes:  /.+$/i,\n            // The regular expression to define for which files a preview\n            // image is shown, matched against the file type:\n            previewSourceFileTypes: /^image\\/(gif|jpeg|png)$/,\n            // The maximum file size of images that are to be displayed as preview:\n            previewSourceMaxFileSize: 5000000, // 5MB\n            // The maximum width of the preview images:\n            previewMaxWidth: 80,\n            // The maximum height of the preview images:\n            previewMaxHeight: 80,\n            // By default, preview images are displayed as canvas elements\n            // if supported by the browser. Set the following option to false\n            // to always display preview images as img elements:\n            previewAsCanvas: true,\n            // The ID of the upload template:\n            uploadTemplateId: 'template-upload',\n            // The ID of the download template:\n            downloadTemplateId: 'template-download',\n            // The container for the list of files. If undefined, it is set to\n            // an element with class \"files\" inside of the widget element:\n            filesContainer: undefined,\n            // By default, files are appended to the files container.\n            // Set the following option to true, to prepend files instead:\n            prependFiles: false,\n            // The expected data type of the upload response, sets the dataType\n            // option of the $.ajax upload requests:\n            dataType: 'json',\n\n            // The add callback is invoked as soon as files are added to the fileupload\n            // widget (via file input selection, drag & drop or add API call).\n            // See the basic file upload widget for more information:\n            add: function (e, data) {\n                var that = $(this).data('fileupload'),\n                    options = that.options,\n                    files = data.files;\n                $(this).fileupload('process', data).done(function () {\n                    that._adjustMaxNumberOfFiles(-files.length);\n                    data.maxNumberOfFilesAdjusted = true;\n                    data.files.valid = data.isValidated = that._validate(files);\n                    data.context = that._renderUpload(files).data('data', data);\n                    options.filesContainer[\n                        options.prependFiles ? 'prepend' : 'append'\n                    ](data.context);\n                    that._renderPreviews(files, data.context);\n                    that._forceReflow(data.context);\n                    that._transition(data.context).done(\n                        function () {\n                            if ((that._trigger('added', e, data) !== false) &&\n                                    (options.autoUpload || data.autoUpload) &&\n                                    data.autoUpload !== false && data.isValidated) {\n                                data.submit();\n                            }\n                        }\n                    );\n                });\n            },\n            // Callback for the start of each file upload request:\n            send: function (e, data) {\n                var that = $(this).data('fileupload');\n                if (!data.isValidated) {\n                    if (!data.maxNumberOfFilesAdjusted) {\n                        that._adjustMaxNumberOfFiles(-data.files.length);\n                        data.maxNumberOfFilesAdjusted = true;\n                    }\n                    if (!that._validate(data.files)) {\n                        return false;\n                    }\n                }\n                if (data.context && data.dataType &&\n                        data.dataType.substr(0, 6) === 'iframe') {\n                    // Iframe Transport does not support progress events.\n                    // In lack of an indeterminate progress bar, we set\n                    // the progress to 100%, showing the full animated bar:\n                    data.context\n                        .find('.progress').addClass(\n                            !$.support.transition && 'progress-animated'\n                        )\n                        .attr('aria-valuenow', 100)\n                        .find('.bar').css(\n                            'width',\n                            '100%'\n                        );\n                }\n                return that._trigger('sent', e, data);\n            },\n            // Callback for successful uploads:\n            done: function (e, data) {\n                var that = $(this).data('fileupload'),\n                    template;\n                if (data.context) {\n                    data.context.each(function (index) {\n                        var file = ($.isArray(data.result) &&\n                                data.result[index]) || {error: 'emptyResult'};\n                        if (file.error) {\n                            that._adjustMaxNumberOfFiles(1);\n                        }\n                        that._transition($(this)).done(\n                            function () {\n                                var node = $(this);\n                                template = that._renderDownload([file])\n                                    .replaceAll(node);\n                                that._forceReflow(template);\n                                that._transition(template).done(\n                                    function () {\n                                        data.context = $(this);\n                                        that._trigger('completed', e, data);\n                                    }\n                                );\n                            }\n                        );\n                    });\n                } else {\n                    if ($.isArray(data.result)) {\n                        $.each(data.result, function (index, file) {\n                            if (data.maxNumberOfFilesAdjusted && file.error) {\n                                that._adjustMaxNumberOfFiles(1);\n                            } else if (!data.maxNumberOfFilesAdjusted &&\n                                    !file.error) {\n                                that._adjustMaxNumberOfFiles(-1);\n                            }\n                        });\n                        data.maxNumberOfFilesAdjusted = true;\n                    }\n                    template = that._renderDownload(data.result)\n                        .appendTo(that.options.filesContainer);\n                    that._forceReflow(template);\n                    that._transition(template).done(\n                        function () {\n                            data.context = $(this);\n                            that._trigger('completed', e, data);\n                        }\n                    );\n                }\n            },\n            // Callback for failed (abort or error) uploads:\n            fail: function (e, data) {\n                var that = $(this).data('fileupload'),\n                    template;\n                if (data.maxNumberOfFilesAdjusted) {\n                    that._adjustMaxNumberOfFiles(data.files.length);\n                }\n                if (data.context) {\n                    data.context.each(function (index) {\n                        if (data.errorThrown !== 'abort') {\n                            var file = data.files[index];\n                            file.error = file.error || data.errorThrown ||\n                                true;\n                            that._transition($(this)).done(\n                                function () {\n                                    var node = $(this);\n                                    template = that._renderDownload([file])\n                                        .replaceAll(node);\n                                    that._forceReflow(template);\n                                    that._transition(template).done(\n                                        function () {\n                                            data.context = $(this);\n                                            that._trigger('failed', e, data);\n                                        }\n                                    );\n                                }\n                            );\n                        } else {\n                            that._transition($(this)).done(\n                                function () {\n                                    $(this).remove();\n                                    that._trigger('failed', e, data);\n                                }\n                            );\n                        }\n                    });\n                } else if (data.errorThrown !== 'abort') {\n                    data.context = that._renderUpload(data.files)\n                        .appendTo(that.options.filesContainer)\n                        .data('data', data);\n                    that._forceReflow(data.context);\n                    that._transition(data.context).done(\n                        function () {\n                            data.context = $(this);\n                            that._trigger('failed', e, data);\n                        }\n                    );\n                } else {\n                    that._trigger('failed', e, data);\n                }\n            },\n            // Callback for upload progress events:\n            progress: function (e, data) {\n                if (data.context) {\n                    var progress = parseInt(data.loaded / data.total * 100, 10);\n                    data.context.find('.progress')\n                        .attr('aria-valuenow', progress)\n                        .find('.bar').css(\n                            'width',\n                            progress + '%'\n                        );\n                }\n            },\n            // Callback for global upload progress events:\n            progressall: function (e, data) {\n                var $this = $(this),\n                    progress = parseInt(data.loaded / data.total * 100, 10),\n                    globalProgressNode = $this.find('.fileupload-progress'),\n                    extendedProgressNode = globalProgressNode\n                        .find('.progress-extended');\n                if (extendedProgressNode.length) {\n                    extendedProgressNode.html(\n                        $this.data('fileupload')._renderExtendedProgress(data)\n                    );\n                }\n                globalProgressNode\n                    .find('.progress')\n                    .attr('aria-valuenow', progress)\n                    .find('.bar').css(\n                        'width',\n                        progress + '%'\n                    );\n            },\n            // Callback for uploads start, equivalent to the global ajaxStart event:\n            start: function (e) {\n                var that = $(this).data('fileupload');\n                that._transition($(this).find('.fileupload-progress')).done(\n                    function () {\n                        that._trigger('started', e);\n                    }\n                );\n            },\n            // Callback for uploads stop, equivalent to the global ajaxStop event:\n            stop: function (e) {\n                var that = $(this).data('fileupload');\n                that._transition($(this).find('.fileupload-progress')).done(\n                    function () {\n                        $(this).find('.progress')\n                            .attr('aria-valuenow', '0')\n                            .find('.bar').css('width', '0%');\n                        $(this).find('.progress-extended').html('&nbsp;');\n                        that._trigger('stopped', e);\n                    }\n                );\n            },\n            // Callback for file deletion:\n            destroy: function (e, data) {\n                var that = $(this).data('fileupload');\n                if (data.url) {\n                    $.ajax(data);\n                    that._adjustMaxNumberOfFiles(1);\n                }\n                that._transition(data.context).done(\n                    function () {\n                        $(this).remove();\n                        that._trigger('destroyed', e, data);\n                    }\n                );\n            }\n        },\n\n        // Link handler, that allows to download files\n        // by drag & drop of the links to the desktop:\n        _enableDragToDesktop: function () {\n            var link = $(this),\n                url = link.prop('href'),\n                name = link.prop('download'),\n                type = 'application/octet-stream';\n            link.bind('dragstart', function (e) {\n                try {\n                    e.originalEvent.dataTransfer.setData(\n                        'DownloadURL',\n                        [type, name, url].join(':')\n                    );\n                } catch (err) {}\n            });\n        },\n\n        _adjustMaxNumberOfFiles: function (operand) {\n            if (typeof this.options.maxNumberOfFiles === 'number') {\n                this.options.maxNumberOfFiles += operand;\n                if (this.options.maxNumberOfFiles < 1) {\n                    this._disableFileInputButton();\n                } else {\n                    this._enableFileInputButton();\n                }\n            }\n        },\n\n        _formatFileSize: function (bytes) {\n            if (typeof bytes !== 'number') {\n                return '';\n            }\n            if (bytes >= 1000000000) {\n                return (bytes / 1000000000).toFixed(2) + ' GB';\n            }\n            if (bytes >= 1000000) {\n                return (bytes / 1000000).toFixed(2) + ' MB';\n            }\n            return (bytes / 1000).toFixed(2) + ' KB';\n        },\n\n        _formatBitrate: function (bits) {\n            if (typeof bits !== 'number') {\n                return '';\n            }\n            if (bits >= 1000000000) {\n                return (bits / 1000000000).toFixed(2) + ' Gbit/s';\n            }\n            if (bits >= 1000000) {\n                return (bits / 1000000).toFixed(2) + ' Mbit/s';\n            }\n            if (bits >= 1000) {\n                return (bits / 1000).toFixed(2) + ' kbit/s';\n            }\n            return bits + ' bit/s';\n        },\n\n        _formatTime: function (seconds) {\n            var date = new Date(seconds * 1000),\n                days = parseInt(seconds / 86400, 10);\n            days = days ? days + 'd ' : '';\n            return days +\n                ('0' + date.getUTCHours()).slice(-2) + ':' +\n                ('0' + date.getUTCMinutes()).slice(-2) + ':' +\n                ('0' + date.getUTCSeconds()).slice(-2);\n        },\n\n        _formatPercentage: function (floatValue) {\n            return (floatValue * 100).toFixed(2) + ' %';\n        },\n\n        _renderExtendedProgress: function (data) {\n            return this._formatBitrate(data.bitrate) + ' | ' +\n                this._formatTime(\n                    (data.total - data.loaded) * 8 / data.bitrate\n                ) + ' | ' +\n                this._formatPercentage(\n                    data.loaded / data.total\n                ) + ' | ' +\n                this._formatFileSize(data.loaded) + ' / ' +\n                this._formatFileSize(data.total);\n        },\n\n        _hasError: function (file) {\n            if (file.error) {\n                return file.error;\n            }\n            // The number of added files is subtracted from\n            // maxNumberOfFiles before validation, so we check if\n            // maxNumberOfFiles is below 0 (instead of below 1):\n            if (this.options.maxNumberOfFiles < 0) {\n                return 'maxNumberOfFiles';\n            }\n            // Files are accepted if either the file type or the file name\n            // matches against the acceptFileTypes regular expression, as\n            // only browsers with support for the File API report the type:\n            if (!(this.options.acceptFileTypes.test(file.type) ||\n                    this.options.acceptFileTypes.test(file.name))) {\n                return 'acceptFileTypes';\n            }\n            if (this.options.maxFileSize &&\n                    file.size > this.options.maxFileSize) {\n                return 'maxFileSize';\n            }\n            if (typeof file.size === 'number' &&\n                    file.size < this.options.minFileSize) {\n                return 'minFileSize';\n            }\n            return null;\n        },\n\n        _validate: function (files) {\n            var that = this,\n                valid = !!files.length;\n            $.each(files, function (index, file) {\n                file.error = that._hasError(file);\n                if (file.error) {\n                    valid = false;\n                }\n            });\n            return valid;\n        },\n\n        _renderTemplate: function (func, files) {\n            if (!func) {\n                return $();\n            }\n            var result = func({\n                files: files,\n                formatFileSize: this._formatFileSize,\n                options: this.options\n            });\n            if (result instanceof $) {\n                return result;\n            }\n            return $(this.options.templatesContainer).html(result).children();\n        },\n\n        _renderPreview: function (file, node) {\n            var that = this,\n                options = this.options,\n                dfd = $.Deferred();\n            return ((loadImage && loadImage(\n                file,\n                function (img) {\n                    node.append(img);\n                    that._forceReflow(node);\n                    that._transition(node).done(function () {\n                        dfd.resolveWith(node);\n                    });\n                    if (!$.contains(document.body, node[0])) {\n                        // If the element is not part of the DOM,\n                        // transition events are not triggered,\n                        // so we have to resolve manually:\n                        dfd.resolveWith(node);\n                    }\n                },\n                {\n                    maxWidth: options.previewMaxWidth,\n                    maxHeight: options.previewMaxHeight,\n                    canvas: options.previewAsCanvas\n                }\n            )) || dfd.resolveWith(node)) && dfd;\n        },\n\n        _renderPreviews: function (files, nodes) {\n            var that = this,\n                options = this.options;\n            nodes.find('.preview span').each(function (index, element) {\n                var file = files[index];\n                if (options.previewSourceFileTypes.test(file.type) &&\n                        ($.type(options.previewSourceMaxFileSize) !== 'number' ||\n                        file.size < options.previewSourceMaxFileSize)) {\n                    that._processingQueue = that._processingQueue.pipe(function () {\n                        var dfd = $.Deferred();\n                        that._renderPreview(file, $(element)).done(\n                            function () {\n                                dfd.resolveWith(that);\n                            }\n                        );\n                        return dfd.promise();\n                    });\n                }\n            });\n            return this._processingQueue;\n        },\n\n        _renderUpload: function (files) {\n            return this._renderTemplate(\n                this.options.uploadTemplate,\n                files\n            );\n        },\n\n        _renderDownload: function (files) {\n            return this._renderTemplate(\n                this.options.downloadTemplate,\n                files\n            ).find('a[download]').each(this._enableDragToDesktop).end();\n        },\n\n        _startHandler: function (e) {\n            e.preventDefault();\n            var button = $(this),\n                template = button.closest('.template-upload'),\n                data = template.data('data');\n            if (data && data.submit && !data.jqXHR && data.submit()) {\n                button.prop('disabled', true);\n            }\n        },\n\n        _cancelHandler: function (e) {\n            e.preventDefault();\n            var template = $(this).closest('.template-upload'),\n                data = template.data('data') || {};\n            if (!data.jqXHR) {\n                data.errorThrown = 'abort';\n                e.data.fileupload._trigger('fail', e, data);\n            } else {\n                data.jqXHR.abort();\n            }\n        },\n\n        _deleteHandler: function (e) {\n            e.preventDefault();\n            var button = $(this);\n            e.data.fileupload._trigger('destroy', e, {\n                context: button.closest('.template-download'),\n                url: button.attr('data-url'),\n                type: button.attr('data-type') || 'DELETE',\n                dataType: e.data.fileupload.options.dataType\n            });\n        },\n\n        _forceReflow: function (node) {\n            return $.support.transition && node.length &&\n                node[0].offsetWidth;\n        },\n\n        _transition: function (node) {\n            var dfd = $.Deferred();\n            if ($.support.transition && node.hasClass('fade')) {\n                node.bind(\n                    $.support.transition.end,\n                    function (e) {\n                        // Make sure we don't respond to other transitions events\n                        // in the container element, e.g. from button elements:\n                        if (e.target === node[0]) {\n                            node.unbind($.support.transition.end);\n                            dfd.resolveWith(node);\n                        }\n                    }\n                ).toggleClass('in');\n            } else {\n                node.toggleClass('in');\n                dfd.resolveWith(node);\n            }\n            return dfd;\n        },\n\n        _initButtonBarEventHandlers: function () {\n            var fileUploadButtonBar = this.element.find('.fileupload-buttonbar'),\n                filesList = this.options.filesContainer,\n                ns = this.options.namespace;\n            fileUploadButtonBar.find('.start')\n                .bind('click.' + ns, function (e) {\n                    e.preventDefault();\n                    filesList.find('.start button').click();\n                });\n            fileUploadButtonBar.find('.cancel')\n                .bind('click.' + ns, function (e) {\n                    e.preventDefault();\n                    filesList.find('.cancel button').click();\n                });\n            fileUploadButtonBar.find('.delete')\n                .bind('click.' + ns, function (e) {\n                    e.preventDefault();\n                    filesList.find('.delete input:checked')\n                        .siblings('button').click();\n                    fileUploadButtonBar.find('.toggle')\n                        .prop('checked', false);\n                });\n            fileUploadButtonBar.find('.toggle')\n                .bind('change.' + ns, function (e) {\n                    filesList.find('.delete input').prop(\n                        'checked',\n                        $(this).is(':checked')\n                    );\n                });\n        },\n\n        _destroyButtonBarEventHandlers: function () {\n            this.element.find('.fileupload-buttonbar button')\n                .unbind('click.' + this.options.namespace);\n            this.element.find('.fileupload-buttonbar .toggle')\n                .unbind('change.' + this.options.namespace);\n        },\n\n        _initEventHandlers: function () {\n            parentWidget.prototype._initEventHandlers.call(this);\n            var eventData = {fileupload: this};\n            this.options.filesContainer\n                .delegate(\n                    '.start button',\n                    'click.' + this.options.namespace,\n                    eventData,\n                    this._startHandler\n                )\n                .delegate(\n                    '.cancel button',\n                    'click.' + this.options.namespace,\n                    eventData,\n                    this._cancelHandler\n                )\n                .delegate(\n                    '.delete button',\n                    'click.' + this.options.namespace,\n                    eventData,\n                    this._deleteHandler\n                );\n            this._initButtonBarEventHandlers();\n        },\n\n        _destroyEventHandlers: function () {\n            var options = this.options;\n            this._destroyButtonBarEventHandlers();\n            options.filesContainer\n                .undelegate('.start button', 'click.' + options.namespace)\n                .undelegate('.cancel button', 'click.' + options.namespace)\n                .undelegate('.delete button', 'click.' + options.namespace);\n            parentWidget.prototype._destroyEventHandlers.call(this);\n        },\n\n        _enableFileInputButton: function () {\n            this.element.find('.fileinput-button input')\n                .prop('disabled', false)\n                .parent().removeClass('disabled');\n        },\n\n        _disableFileInputButton: function () {\n            this.element.find('.fileinput-button input')\n                .prop('disabled', true)\n                .parent().addClass('disabled');\n        },\n\n        _initTemplates: function () {\n            var options = this.options;\n            options.templatesContainer = document.createElement(\n                options.filesContainer.prop('nodeName')\n            );\n            if (tmpl) {\n                if (options.uploadTemplateId) {\n                    options.uploadTemplate = tmpl(options.uploadTemplateId);\n                }\n                if (options.downloadTemplateId) {\n                    options.downloadTemplate = tmpl(options.downloadTemplateId);\n                }\n            }\n        },\n\n        _initFilesContainer: function () {\n            var options = this.options;\n            if (options.filesContainer === undefined) {\n                options.filesContainer = this.element.find('.files');\n            } else if (!(options.filesContainer instanceof $)) {\n                options.filesContainer = $(options.filesContainer);\n            }\n        },\n\n        _stringToRegExp: function (str) {\n            var parts = str.split('/'),\n                modifiers = parts.pop();\n            parts.shift();\n            return new RegExp(parts.join('/'), modifiers);\n        },\n\n        _initRegExpOptions: function () {\n            var options = this.options;\n            if ($.type(options.acceptFileTypes) === 'string') {\n                options.acceptFileTypes = this._stringToRegExp(\n                    options.acceptFileTypes\n                );\n            }\n            if ($.type(options.previewSourceFileTypes) === 'string') {\n                options.previewSourceFileTypes = this._stringToRegExp(\n                    options.previewSourceFileTypes\n                );\n            }\n        },\n\n        _initSpecialOptions: function () {\n            parentWidget.prototype._initSpecialOptions.call(this);\n            this._initFilesContainer();\n            this._initTemplates();\n            this._initRegExpOptions();\n        },\n\n        _create: function () {\n            parentWidget.prototype._create.call(this);\n            this._refreshOptionsList.push(\n                'filesContainer',\n                'uploadTemplateId',\n                'downloadTemplateId'\n            );\n            if (!$.blueimpFP) {\n                this._processingQueue = $.Deferred().resolveWith(this).promise();\n                this.process = function () {\n                    return this._processingQueue;\n                };\n            }\n        },\n\n        enable: function () {\n            var wasDisabled = false;\n            if (this.options.disabled) {\n                wasDisabled = true;\n            }\n            parentWidget.prototype.enable.call(this);\n            if (wasDisabled) {\n                this.element.find('input, button').prop('disabled', false);\n                this._enableFileInputButton();\n            }\n        },\n\n        disable: function () {\n            if (!this.options.disabled) {\n                this.element.find('input, button').prop('disabled', true);\n                this._disableFileInputButton();\n            }\n            parentWidget.prototype.disable.call(this);\n        }\n\n    });\n\n}));\n","jquery/fileUploader/load-image.js":"(function(a){\"use strict\";var b=function(a,c,d){var e=document.createElement(\"img\"),f,g;return e.onerror=c,e.onload=function(){g&&(!d||!d.noRevoke)&&b.revokeObjectURL(g),c(b.scale(e,d))},window.Blob&&a instanceof Blob||window.File&&a instanceof File?f=g=b.createObjectURL(a):f=a,f?(e.src=f,e):b.readFile(a,function(a){e.src=a})},c=window.createObjectURL&&window||window.URL&&URL.revokeObjectURL&&URL||window.webkitURL&&webkitURL;b.scale=function(a,b){b=b||{};var c=document.createElement(\"canvas\"),d=a.width,e=a.height,f=Math.max((b.minWidth||d)/d,(b.minHeight||e)/e);return f>1&&(d=parseInt(d*f,10),e=parseInt(e*f,10)),f=Math.min((b.maxWidth||d)/d,(b.maxHeight||e)/e),f<1&&(d=parseInt(d*f,10),e=parseInt(e*f,10)),a.getContext||b.canvas&&c.getContext?(c.width=d,c.height=e,c.getContext(\"2d\").drawImage(a,0,0,d,e),c):(a.width=d,a.height=e,a)},b.createObjectURL=function(a){return c?c.createObjectURL(a):!1},b.revokeObjectURL=function(a){return c?c.revokeObjectURL(a):!1},b.readFile=function(a,b){if(window.FileReader&&FileReader.prototype.readAsDataURL){var c=new FileReader;return c.onload=function(a){b(a.target.result)},c.readAsDataURL(a),c}return!1},typeof define==\"function\"&&define.amd?define(function(){return b}):a.loadImage=b})(this);","jquery/fileUploader/jquery.fileupload.js":"/*\n * jQuery File Upload Plugin 5.16.4\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2010, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*jslint nomen: true, unparam: true, regexp: true */\n/*global define, window, document, Blob, FormData, location */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define([\n            'jquery',\n            'jquery/ui',\n            'jquery/fileUploader/jquery.iframe-transport'\n        ], factory);\n    } else {\n        // Browser globals:\n        factory(window.jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    // The FileReader API is not actually used, but works as feature detection,\n    // as e.g. Safari supports XHR file uploads via the FormData API,\n    // but not non-multipart XHR file uploads:\n    $.support.xhrFileUpload = !!(window.XMLHttpRequestUpload && window.FileReader);\n    $.support.xhrFormDataFileUpload = !!window.FormData;\n\n    // The fileupload widget listens for change events on file input fields defined\n    // via fileInput setting and paste or drop events of the given dropZone.\n    // In addition to the default jQuery Widget methods, the fileupload widget\n    // exposes the \"add\" and \"send\" methods, to add or directly send files using\n    // the fileupload API.\n    // By default, files added via file input selection, paste, drag & drop or\n    // \"add\" method are uploaded immediately, but it is possible to override\n    // the \"add\" callback option to queue file uploads.\n    $.widget('blueimp.fileupload', {\n\n        options: {\n            // The namespace used for event handler binding on the dropZone and\n            // fileInput collections.\n            // If not set, the name of the widget (\"fileupload\") is used.\n            namespace: undefined,\n            // The drop target collection, by the default the complete document.\n            // Set to null or an empty collection to disable drag & drop support:\n            dropZone: $(document),\n            // The file input field collection, that is listened for change events.\n            // If undefined, it is set to the file input fields inside\n            // of the widget element on plugin initialization.\n            // Set to null or an empty collection to disable the change listener.\n            fileInput: undefined,\n            // By default, the file input field is replaced with a clone after\n            // each input field change event. This is required for iframe transport\n            // queues and allows change events to be fired for the same file\n            // selection, but can be disabled by setting the following option to false:\n            replaceFileInput: true,\n            // The parameter name for the file form data (the request argument name).\n            // If undefined or empty, the name property of the file input field is\n            // used, or \"files[]\" if the file input name property is also empty,\n            // can be a string or an array of strings:\n            paramName: undefined,\n            // By default, each file of a selection is uploaded using an individual\n            // request for XHR type uploads. Set to false to upload file\n            // selections in one request each:\n            singleFileUploads: true,\n            // To limit the number of files uploaded with one XHR request,\n            // set the following option to an integer greater than 0:\n            limitMultiFileUploads: undefined,\n            // Set the following option to true to issue all file upload requests\n            // in a sequential order:\n            sequentialUploads: false,\n            // To limit the number of concurrent uploads,\n            // set the following option to an integer greater than 0:\n            limitConcurrentUploads: undefined,\n            // Set the following option to true to force iframe transport uploads:\n            forceIframeTransport: false,\n            // Set the following option to the location of a redirect url on the\n            // origin server, for cross-domain iframe transport uploads:\n            redirect: undefined,\n            // The parameter name for the redirect url, sent as part of the form\n            // data and set to 'redirect' if this option is empty:\n            redirectParamName: undefined,\n            // Set the following option to the location of a postMessage window,\n            // to enable postMessage transport uploads:\n            postMessage: undefined,\n            // By default, XHR file uploads are sent as multipart/form-data.\n            // The iframe transport is always using multipart/form-data.\n            // Set to false to enable non-multipart XHR uploads:\n            multipart: true,\n            // To upload large files in smaller chunks, set the following option\n            // to a preferred maximum chunk size. If set to 0, null or undefined,\n            // or the browser does not support the required Blob API, files will\n            // be uploaded as a whole.\n            maxChunkSize: undefined,\n            // When a non-multipart upload or a chunked multipart upload has been\n            // aborted, this option can be used to resume the upload by setting\n            // it to the size of the already uploaded bytes. This option is most\n            // useful when modifying the options object inside of the \"add\" or\n            // \"send\" callbacks, as the options are cloned for each file upload.\n            uploadedBytes: undefined,\n            // By default, failed (abort or error) file uploads are removed from the\n            // global progress calculation. Set the following option to false to\n            // prevent recalculating the global progress data:\n            recalculateProgress: true,\n            // Interval in milliseconds to calculate and trigger progress events:\n            progressInterval: 100,\n            // Interval in milliseconds to calculate progress bitrate:\n            bitrateInterval: 500,\n\n            // Additional form data to be sent along with the file uploads can be set\n            // using this option, which accepts an array of objects with name and\n            // value properties, a function returning such an array, a FormData\n            // object (for XHR file uploads), or a simple object.\n            // The form of the first fileInput is given as parameter to the function:\n            formData: function (form) {\n                return form.serializeArray();\n            },\n\n            // The add callback is invoked as soon as files are added to the fileupload\n            // widget (via file input selection, drag & drop, paste or add API call).\n            // If the singleFileUploads option is enabled, this callback will be\n            // called once for each file in the selection for XHR file uplaods, else\n            // once for each file selection.\n            // The upload starts when the submit method is invoked on the data parameter.\n            // The data object contains a files property holding the added files\n            // and allows to override plugin options as well as define ajax settings.\n            // Listeners for this callback can also be bound the following way:\n            // .bind('fileuploadadd', func);\n            // data.submit() returns a Promise object and allows to attach additional\n            // handlers using jQuery's Deferred callbacks:\n            // data.submit().done(func).fail(func).always(func);\n            add: function (e, data) {\n                data.submit();\n            },\n\n            // Other callbacks:\n            // Callback for the submit event of each file upload:\n            // submit: function (e, data) {}, // .bind('fileuploadsubmit', func);\n            // Callback for the start of each file upload request:\n            // send: function (e, data) {}, // .bind('fileuploadsend', func);\n            // Callback for successful uploads:\n            // done: function (e, data) {}, // .bind('fileuploaddone', func);\n            // Callback for failed (abort or error) uploads:\n            // fail: function (e, data) {}, // .bind('fileuploadfail', func);\n            // Callback for completed (success, abort or error) requests:\n            // always: function (e, data) {}, // .bind('fileuploadalways', func);\n            // Callback for upload progress events:\n            // progress: function (e, data) {}, // .bind('fileuploadprogress', func);\n            // Callback for global upload progress events:\n            // progressall: function (e, data) {}, // .bind('fileuploadprogressall', func);\n            // Callback for uploads start, equivalent to the global ajaxStart event:\n            // start: function (e) {}, // .bind('fileuploadstart', func);\n            // Callback for uploads stop, equivalent to the global ajaxStop event:\n            // stop: function (e) {}, // .bind('fileuploadstop', func);\n            // Callback for change events of the fileInput collection:\n            // change: function (e, data) {}, // .bind('fileuploadchange', func);\n            // Callback for paste events to the dropZone collection:\n            // paste: function (e, data) {}, // .bind('fileuploadpaste', func);\n            // Callback for drop events of the dropZone collection:\n            // drop: function (e, data) {}, // .bind('fileuploaddrop', func);\n            // Callback for dragover events of the dropZone collection:\n            // dragover: function (e) {}, // .bind('fileuploaddragover', func);\n\n            // The plugin options are used as settings object for the ajax calls.\n            // The following are jQuery ajax settings required for the file uploads:\n            processData: false,\n            contentType: false,\n            cache: false\n        },\n\n        // A list of options that require a refresh after assigning a new value:\n        _refreshOptionsList: [\n            'namespace',\n            'dropZone',\n            'fileInput',\n            'multipart',\n            'forceIframeTransport'\n        ],\n\n        _BitrateTimer: function () {\n            this.timestamp = +(new Date());\n            this.loaded = 0;\n            this.bitrate = 0;\n            this.getBitrate = function (now, loaded, interval) {\n                var timeDiff = now - this.timestamp;\n                if (!this.bitrate || !interval || timeDiff > interval) {\n                    this.bitrate = (loaded - this.loaded) * (1000 / timeDiff) * 8;\n                    this.loaded = loaded;\n                    this.timestamp = now;\n                }\n                return this.bitrate;\n            };\n        },\n\n        _isXHRUpload: function (options) {\n            return !options.forceIframeTransport &&\n                ((!options.multipart && $.support.xhrFileUpload) ||\n                $.support.xhrFormDataFileUpload);\n        },\n\n        _getFormData: function (options) {\n            var formData;\n            if (typeof options.formData === 'function') {\n                return options.formData(options.form);\n            }\n\t\t\tif ($.isArray(options.formData)) {\n                return options.formData;\n            }\n\t\t\tif (options.formData) {\n                formData = [];\n                $.each(options.formData, function (name, value) {\n                    formData.push({name: name, value: value});\n                });\n                return formData;\n            }\n            return [];\n        },\n\n        _getTotal: function (files) {\n            var total = 0;\n            $.each(files, function (index, file) {\n                total += file.size || 1;\n            });\n            return total;\n        },\n\n        _onProgress: function (e, data) {\n            if (e.lengthComputable) {\n                var now = +(new Date()),\n                    total,\n                    loaded;\n                if (data._time && data.progressInterval &&\n                        (now - data._time < data.progressInterval) &&\n                        e.loaded !== e.total) {\n                    return;\n                }\n                data._time = now;\n                total = data.total || this._getTotal(data.files);\n                loaded = parseInt(\n                    e.loaded / e.total * (data.chunkSize || total),\n                    10\n                ) + (data.uploadedBytes || 0);\n                this._loaded += loaded - (data.loaded || data.uploadedBytes || 0);\n                data.lengthComputable = true;\n                data.loaded = loaded;\n                data.total = total;\n                data.bitrate = data._bitrateTimer.getBitrate(\n                    now,\n                    loaded,\n                    data.bitrateInterval\n                );\n                // Trigger a custom progress event with a total data property set\n                // to the file size(s) of the current upload and a loaded data\n                // property calculated accordingly:\n                this._trigger('progress', e, data);\n                // Trigger a global progress event for all current file uploads,\n                // including ajax calls queued for sequential file uploads:\n                this._trigger('progressall', e, {\n                    lengthComputable: true,\n                    loaded: this._loaded,\n                    total: this._total,\n                    bitrate: this._bitrateTimer.getBitrate(\n                        now,\n                        this._loaded,\n                        data.bitrateInterval\n                    )\n                });\n            }\n        },\n\n        _initProgressListener: function (options) {\n            var that = this,\n                xhr = options.xhr ? options.xhr() : $.ajaxSettings.xhr();\n            // Accesss to the native XHR object is required to add event listeners\n            // for the upload progress event:\n            if (xhr.upload) {\n                $(xhr.upload).bind('progress', function (e) {\n                    var oe = e.originalEvent;\n                    // Make sure the progress event properties get copied over:\n                    e.lengthComputable = oe.lengthComputable;\n                    e.loaded = oe.loaded;\n                    e.total = oe.total;\n                    that._onProgress(e, options);\n                });\n                options.xhr = function () {\n                    return xhr;\n                };\n            }\n        },\n\n        _initXHRData: function (options) {\n            var formData,\n                file = options.files[0],\n                // Ignore non-multipart setting if not supported:\n                multipart = options.multipart || !$.support.xhrFileUpload,\n                paramName = options.paramName[0];\n            if (!multipart || options.blob) {\n                // For non-multipart uploads and chunked uploads,\n                // file meta data is not part of the request body,\n                // so we transmit this data as part of the HTTP headers.\n                // For cross domain requests, these headers must be allowed\n                // via Access-Control-Allow-Headers or removed using\n                // the beforeSend callback:\n                options.headers = $.extend(options.headers, {\n                    'X-File-Name': file.name,\n                    'X-File-Type': file.type,\n                    'X-File-Size': file.size\n                });\n                if (!options.blob) {\n                    // Non-chunked non-multipart upload:\n                    options.contentType = file.type;\n                    options.data = file;\n                } else if (!multipart) {\n                    // Chunked non-multipart upload:\n                    options.contentType = 'application/octet-stream';\n                    options.data = options.blob;\n                }\n            }\n            if (multipart && $.support.xhrFormDataFileUpload) {\n                if (options.postMessage) {\n                    // window.postMessage does not allow sending FormData\n                    // objects, so we just add the File/Blob objects to\n                    // the formData array and let the postMessage window\n                    // create the FormData object out of this array:\n                    formData = this._getFormData(options);\n                    if (options.blob) {\n                        formData.push({\n                            name: paramName,\n                            value: options.blob\n                        });\n                    } else {\n                        $.each(options.files, function (index, file) {\n                            formData.push({\n                                name: options.paramName[index] || paramName,\n                                value: file\n                            });\n                        });\n                    }\n                } else {\n                    if (options.formData instanceof FormData) {\n                        formData = options.formData;\n                    } else {\n                        formData = new FormData();\n                        $.each(this._getFormData(options), function (index, field) {\n                            formData.append(field.name, field.value);\n                        });\n                    }\n                    if (options.blob) {\n                        formData.append(paramName, options.blob, file.name);\n                    } else {\n                        $.each(options.files, function (index, file) {\n                            // File objects are also Blob instances.\n                            // This check allows the tests to run with\n                            // dummy objects:\n                            if (file instanceof Blob) {\n                                formData.append(\n                                    options.paramName[index] || paramName,\n                                    file,\n                                    file.name\n                                );\n                            }\n                        });\n                    }\n                }\n                options.data = formData;\n            }\n            // Blob reference is not needed anymore, free memory:\n            options.blob = null;\n        },\n\n        _initIframeSettings: function (options) {\n            // Setting the dataType to iframe enables the iframe transport:\n            options.dataType = 'iframe ' + (options.dataType || '');\n            // The iframe transport accepts a serialized array as form data:\n            options.formData = this._getFormData(options);\n            // Add redirect url to form data on cross-domain uploads:\n            if (options.redirect && $('<a></a>').prop('href', options.url)\n                    .prop('host') !== location.host) {\n                options.formData.push({\n                    name: options.redirectParamName || 'redirect',\n                    value: options.redirect\n                });\n            }\n        },\n\n        _initDataSettings: function (options) {\n            if (this._isXHRUpload(options)) {\n                if (!this._chunkedUpload(options, true)) {\n                    if (!options.data) {\n                        this._initXHRData(options);\n                    }\n                    this._initProgressListener(options);\n                }\n                if (options.postMessage) {\n                    // Setting the dataType to postmessage enables the\n                    // postMessage transport:\n                    options.dataType = 'postmessage ' + (options.dataType || '');\n                }\n            } else {\n                this._initIframeSettings(options, 'iframe');\n            }\n        },\n\n        _getParamName: function (options) {\n            var fileInput = $(options.fileInput),\n                paramName = options.paramName;\n            if (!paramName) {\n                paramName = [];\n                fileInput.each(function () {\n                    var input = $(this),\n                        name = input.prop('name') || 'files[]',\n                        i = (input.prop('files') || [1]).length;\n                    while (i) {\n                        paramName.push(name);\n                        i -= 1;\n                    }\n                });\n                if (!paramName.length) {\n                    paramName = [fileInput.prop('name') || 'files[]'];\n                }\n            } else if (!$.isArray(paramName)) {\n                paramName = [paramName];\n            }\n            return paramName;\n        },\n\n        _initFormSettings: function (options) {\n            // Retrieve missing options from the input field and the\n            // associated form, if available:\n            if (!options.form || !options.form.length) {\n                options.form = $(options.fileInput.prop('form'));\n            }\n            options.paramName = this._getParamName(options);\n            if (!options.url) {\n                options.url = options.form.prop('action') || location.href;\n            }\n            // The HTTP request method must be \"POST\" or \"PUT\":\n            options.type = (options.type || options.form.prop('method') || '')\n                .toUpperCase();\n            if (options.type !== 'POST' && options.type !== 'PUT') {\n                options.type = 'POST';\n            }\n            if (!options.formAcceptCharset) {\n                options.formAcceptCharset = options.form.attr('accept-charset');\n            }\n        },\n\n        _getAJAXSettings: function (data) {\n            var options = $.extend({}, this.options, data);\n            this._initFormSettings(options);\n            this._initDataSettings(options);\n            return options;\n        },\n\n        // Maps jqXHR callbacks to the equivalent\n        // methods of the given Promise object:\n        _enhancePromise: function (promise) {\n            promise.success = promise.done;\n            promise.error = promise.fail;\n            promise.complete = promise.always;\n            return promise;\n        },\n\n        // Creates and returns a Promise object enhanced with\n        // the jqXHR methods abort, success, error and complete:\n        _getXHRPromise: function (resolveOrReject, context, args) {\n            var dfd = $.Deferred(),\n                promise = dfd.promise();\n            context = context || this.options.context || promise;\n            if (resolveOrReject === true) {\n                dfd.resolveWith(context, args);\n            } else if (resolveOrReject === false) {\n                dfd.rejectWith(context, args);\n            }\n            promise.abort = dfd.promise;\n            return this._enhancePromise(promise);\n        },\n\n        // Uploads a file in multiple, sequential requests\n        // by splitting the file up in multiple blob chunks.\n        // If the second parameter is true, only tests if the file\n        // should be uploaded in chunks, but does not invoke any\n        // upload requests:\n        _chunkedUpload: function (options, testOnly) {\n            var that = this,\n                file = options.files[0],\n                fs = file.size,\n                ub = options.uploadedBytes = options.uploadedBytes || 0,\n                mcs = options.maxChunkSize || fs,\n                // Use the Blob methods with the slice implementation\n                // according to the W3C Blob API specification:\n                slice = file.webkitSlice || file.mozSlice || file.slice,\n                upload,\n                n,\n                jqXHR,\n                pipe;\n            if (!(this._isXHRUpload(options) && slice && (ub || mcs < fs)) ||\n                    options.data) {\n                return false;\n            }\n            if (testOnly) {\n                return true;\n            }\n            if (ub >= fs) {\n                file.error = 'uploadedBytes';\n                return this._getXHRPromise(\n                    false,\n                    options.context,\n                    [null, 'error', file.error]\n                );\n            }\n            // n is the number of blobs to upload,\n            // calculated via filesize, uploaded bytes and max chunk size:\n            n = Math.ceil((fs - ub) / mcs);\n            // The chunk upload method accepting the chunk number as parameter:\n            upload = function (i) {\n                if (!i) {\n                    return that._getXHRPromise(true, options.context);\n                }\n                // Upload the blobs in sequential order:\n                return upload(i -= 1).pipe(function () {\n                    // Clone the options object for each chunk upload:\n                    var o = $.extend({}, options);\n                    o.blob = slice.call(\n                        file,\n                        ub + i * mcs,\n                        ub + (i + 1) * mcs\n                    );\n                    // Expose the chunk index:\n                    o.chunkIndex = i;\n                    // Expose the number of chunks:\n                    o.chunksNumber = n;\n                    // Store the current chunk size, as the blob itself\n                    // will be dereferenced after data processing:\n                    o.chunkSize = o.blob.size;\n                    // Process the upload data (the blob and potential form data):\n                    that._initXHRData(o);\n                    // Add progress listeners for this chunk upload:\n                    that._initProgressListener(o);\n                    jqXHR = ($.ajax(o) || that._getXHRPromise(false, o.context))\n                        .done(function () {\n                            // Create a progress event if upload is done and\n                            // no progress event has been invoked for this chunk:\n                            if (!o.loaded) {\n                                that._onProgress($.Event('progress', {\n                                    lengthComputable: true,\n                                    loaded: o.chunkSize,\n                                    total: o.chunkSize\n                                }), o);\n                            }\n                            options.uploadedBytes = o.uploadedBytes +=\n                                o.chunkSize;\n                        });\n                    return jqXHR;\n                });\n            };\n            // Return the piped Promise object, enhanced with an abort method,\n            // which is delegated to the jqXHR object of the current upload,\n            // and jqXHR callbacks mapped to the equivalent Promise methods:\n            pipe = upload(n);\n            pipe.abort = function () {\n                return jqXHR.abort();\n            };\n            return this._enhancePromise(pipe);\n        },\n\n        _beforeSend: function (e, data) {\n            if (this._active === 0) {\n                // the start callback is triggered when an upload starts\n                // and no other uploads are currently running,\n                // equivalent to the global ajaxStart event:\n                this._trigger('start');\n                // Set timer for global bitrate progress calculation:\n                this._bitrateTimer = new this._BitrateTimer();\n            }\n            this._active += 1;\n            // Initialize the global progress values:\n            this._loaded += data.uploadedBytes || 0;\n            this._total += this._getTotal(data.files);\n        },\n\n        _onDone: function (result, textStatus, jqXHR, options) {\n            if (!this._isXHRUpload(options)) {\n                // Create a progress event for each iframe load:\n                this._onProgress($.Event('progress', {\n                    lengthComputable: true,\n                    loaded: 1,\n                    total: 1\n                }), options);\n            }\n            options.result = result;\n            options.textStatus = textStatus;\n            options.jqXHR = jqXHR;\n            this._trigger('done', null, options);\n        },\n\n        _onFail: function (jqXHR, textStatus, errorThrown, options) {\n            options.jqXHR = jqXHR;\n            options.textStatus = textStatus;\n            options.errorThrown = errorThrown;\n            this._trigger('fail', null, options);\n            if (options.recalculateProgress) {\n                // Remove the failed (error or abort) file upload from\n                // the global progress calculation:\n                this._loaded -= options.loaded || options.uploadedBytes || 0;\n                this._total -= options.total || this._getTotal(options.files);\n            }\n        },\n\n        _onAlways: function (jqXHRorResult, textStatus, jqXHRorError, options) {\n            this._active -= 1;\n            options.textStatus = textStatus;\n            if (jqXHRorError && jqXHRorError.always) {\n                options.jqXHR = jqXHRorError;\n                options.result = jqXHRorResult;\n            } else {\n                options.jqXHR = jqXHRorResult;\n                options.errorThrown = jqXHRorError;\n            }\n            this._trigger('always', null, options);\n            if (this._active === 0) {\n                // The stop callback is triggered when all uploads have\n                // been completed, equivalent to the global ajaxStop event:\n                this._trigger('stop');\n                // Reset the global progress values:\n                this._loaded = this._total = 0;\n                this._bitrateTimer = null;\n            }\n        },\n\n        _onSend: function (e, data) {\n            var that = this,\n                jqXHR,\n                slot,\n                pipe,\n                options = that._getAJAXSettings(data),\n                send = function (resolve, args) {\n                    that._sending += 1;\n                    // Set timer for bitrate progress calculation:\n                    options._bitrateTimer = new that._BitrateTimer();\n                    jqXHR = jqXHR || (\n                        (resolve !== false &&\n                        that._trigger('send', e, options) !== false &&\n                        (that._chunkedUpload(options) || $.ajax(options))) ||\n                        that._getXHRPromise(false, options.context, args)\n                    ).done(function (result, textStatus, jqXHR) {\n                        that._onDone(result, textStatus, jqXHR, options);\n                    }).fail(function (jqXHR, textStatus, errorThrown) {\n                        that._onFail(jqXHR, textStatus, errorThrown, options);\n                    }).always(function (jqXHRorResult, textStatus, jqXHRorError) {\n                        that._sending -= 1;\n                        that._onAlways(\n                            jqXHRorResult,\n                            textStatus,\n                            jqXHRorError,\n                            options\n                        );\n                        if (options.limitConcurrentUploads &&\n                                options.limitConcurrentUploads > that._sending) {\n                            // Start the next queued upload,\n                            // that has not been aborted:\n                            var nextSlot = that._slots.shift(),\n                                isPending;\n                            while (nextSlot) {\n                                // jQuery 1.6 doesn't provide .state(),\n                                // while jQuery 1.8+ removed .isRejected():\n                                isPending = nextSlot.state ?\n                                        nextSlot.state() === 'pending' :\n                                        !nextSlot.isRejected();\n                                if (isPending) {\n                                    nextSlot.resolve();\n                                    break;\n                                }\n                                nextSlot = that._slots.shift();\n                            }\n                        }\n                    });\n                    return jqXHR;\n                };\n            this._beforeSend(e, options);\n            if (this.options.sequentialUploads ||\n                    (this.options.limitConcurrentUploads &&\n                    this.options.limitConcurrentUploads <= this._sending)) {\n                if (this.options.limitConcurrentUploads > 1) {\n                    slot = $.Deferred();\n                    this._slots.push(slot);\n                    pipe = slot.pipe(send);\n                } else {\n                    pipe = (this._sequence = this._sequence.pipe(send, send));\n                }\n                // Return the piped Promise object, enhanced with an abort method,\n                // which is delegated to the jqXHR object of the current upload,\n                // and jqXHR callbacks mapped to the equivalent Promise methods:\n                pipe.abort = function () {\n                    var args = [undefined, 'abort', 'abort'];\n                    if (!jqXHR) {\n                        if (slot) {\n                            slot.rejectWith(pipe, args);\n                        }\n                        return send(false, args);\n                    }\n                    return jqXHR.abort();\n                };\n                return this._enhancePromise(pipe);\n            }\n            return send();\n        },\n\n        _onAdd: function (e, data) {\n            var that = this,\n                result = true,\n                options = $.extend({}, this.options, data),\n                limit = options.limitMultiFileUploads,\n                paramName = this._getParamName(options),\n                paramNameSet,\n                paramNameSlice,\n                fileSet,\n                i;\n            if (!(options.singleFileUploads || limit) ||\n                    !this._isXHRUpload(options)) {\n                fileSet = [data.files];\n                paramNameSet = [paramName];\n            } else if (!options.singleFileUploads && limit) {\n                fileSet = [];\n                paramNameSet = [];\n                for (i = 0; i < data.files.length; i += limit) {\n                    fileSet.push(data.files.slice(i, i + limit));\n                    paramNameSlice = paramName.slice(i, i + limit);\n                    if (!paramNameSlice.length) {\n                        paramNameSlice = paramName;\n                    }\n                    paramNameSet.push(paramNameSlice);\n                }\n            } else {\n                paramNameSet = paramName;\n            }\n            data.originalFiles = data.files;\n            $.each(fileSet || data.files, function (index, element) {\n                var newData = $.extend({}, data);\n                newData.files = fileSet ? element : [element];\n                newData.paramName = paramNameSet[index];\n                newData.submit = function () {\n                    newData.jqXHR = this.jqXHR =\n                        (that._trigger('submit', e, this) !== false) &&\n                        that._onSend(e, this);\n                    return this.jqXHR;\n                };\n                return (result = that._trigger('add', e, newData));\n            });\n            return result;\n        },\n\n        _replaceFileInput: function (input) {\n            var inputClone = input.clone(true);\n            $('<form></form>').append(inputClone)[0].reset();\n            // Detaching allows to insert the fileInput on another form\n            // without loosing the file input value:\n            input.after(inputClone).detach();\n            // Avoid memory leaks with the detached file input:\n            $.cleanData(input.unbind('remove'));\n            // Replace the original file input element in the fileInput\n            // collection with the clone, which has been copied including\n            // event handlers:\n            this.options.fileInput = this.options.fileInput.map(function (i, el) {\n                if (el === input[0]) {\n                    return inputClone[0];\n                }\n                return el;\n            });\n            // If the widget has been initialized on the file input itself,\n            // override this.element with the file input clone:\n            if (input[0] === this.element[0]) {\n                this.element = inputClone;\n            }\n        },\n\n        _handleFileTreeEntry: function (entry, path) {\n            var that = this,\n                dfd = $.Deferred(),\n                errorHandler = function () {\n                    dfd.reject();\n                },\n                dirReader;\n            path = path || '';\n            if (entry.isFile) {\n                entry.file(function (file) {\n                    file.relativePath = path;\n                    dfd.resolve(file);\n                }, errorHandler);\n            } else if (entry.isDirectory) {\n                dirReader = entry.createReader();\n                dirReader.readEntries(function (entries) {\n                    that._handleFileTreeEntries(\n                        entries,\n                        path + entry.name + '/'\n                    ).done(function (files) {\n                        dfd.resolve(files);\n                    }).fail(errorHandler);\n                }, errorHandler);\n            } else {\n                errorHandler();\n            }\n            return dfd.promise();\n        },\n\n        _handleFileTreeEntries: function (entries, path) {\n            var that = this;\n            return $.when.apply(\n                $,\n                $.map(entries, function (entry) {\n                    return that._handleFileTreeEntry(entry, path);\n                })\n            ).pipe(function () {\n                return Array.prototype.concat.apply(\n                    [],\n                    arguments\n                );\n            });\n        },\n\n        _getDroppedFiles: function (dataTransfer) {\n            dataTransfer = dataTransfer || {};\n            var items = dataTransfer.items;\n            if (items && items.length && (items[0].webkitGetAsEntry ||\n                    items[0].getAsEntry)) {\n                return this._handleFileTreeEntries(\n                    $.map(items, function (item) {\n                        if (item.webkitGetAsEntry) {\n                            return item.webkitGetAsEntry();\n                        }\n                        return item.getAsEntry();\n                    })\n                );\n            }\n            return $.Deferred().resolve(\n                $.makeArray(dataTransfer.files)\n            ).promise();\n        },\n\n        _getFileInputFiles: function (fileInput) {\n            fileInput = $(fileInput);\n            var entries = fileInput.prop('webkitEntries') ||\n                    fileInput.prop('entries'),\n                files,\n                value;\n            if (entries && entries.length) {\n                return this._handleFileTreeEntries(entries);\n            }\n            files = $.makeArray(fileInput.prop('files'));\n            if (!files.length) {\n                value = fileInput.prop('value');\n                if (!value) {\n                    return $.Deferred().reject([]).promise();\n                }\n                // If the files property is not available, the browser does not\n                // support the File API and we add a pseudo File object with\n                // the input value as name with path information removed:\n                files = [{name: value.replace(/^.*\\\\/, '')}];\n            }\n            return $.Deferred().resolve(files).promise();\n        },\n\n        _onChange: function (e) {\n            var that = e.data.fileupload,\n                data = {\n                    fileInput: $(e.target),\n                    form: $(e.target.form)\n                };\n            that._getFileInputFiles(data.fileInput).always(function (files) {\n                data.files = files;\n                if (that.options.replaceFileInput) {\n                    that._replaceFileInput(data.fileInput);\n                }\n                if (that._trigger('change', e, data) !== false) {\n                    that._onAdd(e, data);\n                }\n            });\n        },\n\n        _onPaste: function (e) {\n            var that = e.data.fileupload,\n                cbd = e.originalEvent.clipboardData,\n                items = (cbd && cbd.items) || [],\n                data = {files: []};\n            $.each(items, function (index, item) {\n                var file = item.getAsFile && item.getAsFile();\n                if (file) {\n                    data.files.push(file);\n                }\n            });\n            if (that._trigger('paste', e, data) === false ||\n                    that._onAdd(e, data) === false) {\n                return false;\n            }\n        },\n\n        _onDrop: function (e) {\n            e.preventDefault();\n            var that = e.data.fileupload,\n                dataTransfer = e.dataTransfer = e.originalEvent.dataTransfer,\n                data = {};\n            that._getDroppedFiles(dataTransfer).always(function (files) {\n                data.files = files;\n                if (that._trigger('drop', e, data) !== false) {\n                    that._onAdd(e, data);\n                }\n            });\n        },\n\n        _onDragOver: function (e) {\n            var that = e.data.fileupload,\n                dataTransfer = e.dataTransfer = e.originalEvent.dataTransfer;\n            if (that._trigger('dragover', e) === false) {\n                return false;\n            }\n            if (dataTransfer) {\n                dataTransfer.dropEffect = 'copy';\n            }\n            e.preventDefault();\n        },\n\n        _initEventHandlers: function () {\n            var ns = this.options.namespace;\n            if (this._isXHRUpload(this.options)) {\n                this.options.dropZone\n                    .bind('dragover.' + ns, {fileupload: this}, this._onDragOver)\n                    .bind('drop.' + ns, {fileupload: this}, this._onDrop)\n                    .bind('paste.' + ns, {fileupload: this}, this._onPaste);\n            }\n            this.options.fileInput\n                .bind('change.' + ns, {fileupload: this}, this._onChange);\n        },\n\n        _destroyEventHandlers: function () {\n            var ns = this.options.namespace;\n            this.options.dropZone\n                .unbind('dragover.' + ns, this._onDragOver)\n                .unbind('drop.' + ns, this._onDrop)\n                .unbind('paste.' + ns, this._onPaste);\n            this.options.fileInput\n                .unbind('change.' + ns, this._onChange);\n        },\n\n        _setOption: function (key, value) {\n            var refresh = $.inArray(key, this._refreshOptionsList) !== -1;\n            if (refresh) {\n                this._destroyEventHandlers();\n            }\n            $.Widget.prototype._setOption.call(this, key, value);\n            if (refresh) {\n                this._initSpecialOptions();\n                this._initEventHandlers();\n            }\n        },\n\n        _initSpecialOptions: function () {\n            var options = this.options;\n            if (options.fileInput === undefined) {\n                options.fileInput = this.element.is('input[type=\"file\"]') ?\n                        this.element : this.element.find('input[type=\"file\"]');\n            } else if (!(options.fileInput instanceof $)) {\n                options.fileInput = $(options.fileInput);\n            }\n            if (!(options.dropZone instanceof $)) {\n                options.dropZone = $(options.dropZone);\n            }\n        },\n\n        _create: function () {\n            var options = this.options;\n            // Initialize options set via HTML5 data-attributes:\n            $.extend(options, $(this.element[0].cloneNode(false)).data());\n            options.namespace = options.namespace || this.widgetName;\n            this._initSpecialOptions();\n            this._slots = [];\n            this._sequence = this._getXHRPromise(true);\n            this._sending = this._active = this._loaded = this._total = 0;\n            this._initEventHandlers();\n        },\n\n        destroy: function () {\n            this._destroyEventHandlers();\n            $.Widget.prototype.destroy.call(this);\n        },\n\n        enable: function () {\n            var wasDisabled = false;\n            if (this.options.disabled) {\n                wasDisabled = true;\n            }\n            $.Widget.prototype.enable.call(this);\n            if (wasDisabled) {\n                this._initEventHandlers();\n            }\n        },\n\n        disable: function () {\n            if (!this.options.disabled) {\n                this._destroyEventHandlers();\n            }\n            $.Widget.prototype.disable.call(this);\n        },\n\n        // This method is exposed to the widget API and allows adding files\n        // using the fileupload API. The data parameter accepts an object which\n        // must have a files property and can contain additional options:\n        // .fileupload('add', {files: filesList});\n        add: function (data) {\n            var that = this;\n            if (!data || this.options.disabled) {\n                return;\n            }\n            if (data.fileInput && !data.files) {\n                this._getFileInputFiles(data.fileInput).always(function (files) {\n                    data.files = files;\n                    that._onAdd(null, data);\n                });\n            } else {\n                data.files = $.makeArray(data.files);\n                this._onAdd(null, data);\n            }\n        },\n\n        // This method is exposed to the widget API and allows sending files\n        // using the fileupload API. The data parameter accepts an object which\n        // must have a files or fileInput property and can contain additional options:\n        // .fileupload('send', {files: filesList});\n        // The method returns a Promise object for the file upload call.\n        send: function (data) {\n            if (data && !this.options.disabled) {\n                if (data.fileInput && !data.files) {\n                    var that = this,\n                        dfd = $.Deferred(),\n                        promise = dfd.promise(),\n                        jqXHR,\n                        aborted;\n                    promise.abort = function () {\n                        aborted = true;\n                        if (jqXHR) {\n                            return jqXHR.abort();\n                        }\n                        dfd.reject(null, 'abort', 'abort');\n                        return promise;\n                    };\n                    this._getFileInputFiles(data.fileInput).always(\n                        function (files) {\n                            if (aborted) {\n                                return;\n                            }\n                            data.files = files;\n                            jqXHR = that._onSend(null, data).then(\n                                function (result, textStatus, jqXHR) {\n                                    dfd.resolve(result, textStatus, jqXHR);\n                                },\n                                function (jqXHR, textStatus, errorThrown) {\n                                    dfd.reject(jqXHR, textStatus, errorThrown);\n                                }\n                            );\n                        }\n                    );\n                    return this._enhancePromise(promise);\n                }\n                data.files = $.makeArray(data.files);\n                if (data.files.length) {\n                    return this._onSend(null, data);\n                }\n            }\n            return this._getXHRPromise(false, data && data.context);\n        }\n\n    });\n\n}));\n","jquery/fileUploader/canvas-to-blob.js":"(function(a){\"use strict\";var b=a.HTMLCanvasElement&&a.HTMLCanvasElement.prototype,c=a.Blob&&function(){try{return Boolean(new Blob)}catch(a){return!1}}(),d=c&&a.Uint8Array&&function(){try{return(new Blob([new Uint8Array(100)])).size===100}catch(a){return!1}}(),e=a.BlobBuilder||a.WebKitBlobBuilder||a.MozBlobBuilder||a.MSBlobBuilder,f=(c||e)&&a.atob&&a.ArrayBuffer&&a.Uint8Array&&function(a){var b,f,g,h,i,j;a.split(\",\")[0].indexOf(\"base64\")>=0?b=atob(a.split(\",\")[1]):b=decodeURIComponent(a.split(\",\")[1]),f=new ArrayBuffer(b.length),g=new Uint8Array(f);for(h=0;h<b.length;h+=1)g[h]=b.charCodeAt(h);return i=a.split(\",\")[0].split(\":\")[1].split(\";\")[0],c?new Blob([d?g:f],{type:i}):(j=new e,j.append(f),j.getBlob(i))};a.HTMLCanvasElement&&!b.toBlob&&(b.mozGetAsFile?b.toBlob=function(a,b){a(this.mozGetAsFile(\"blob\",b))}:b.toDataURL&&f&&(b.toBlob=function(a,b){a(f(this.toDataURL(b)))})),typeof define==\"function\"&&define.amd?define(function(){return f}):a.dataURLtoBlob=f})(this);","jquery/fileUploader/jquery.fileupload-fp.js":"/*\n * jQuery File Upload File Processing Plugin 1.0\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2012, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*jslint nomen: true, unparam: true, regexp: true */\n/*global define, window, document */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define([\n            'jquery',\n            'jquery/fileUploader/load-image',\n            'jquery/fileUploader/canvas-to-blob',\n            'jquery/fileUploader/jquery.fileupload'\n        ], factory);\n    } else {\n        // Browser globals:\n        factory(\n            window.jQuery,\n            window.loadImage\n        );\n    }\n}(function ($, loadImage) {\n    'use strict';\n\n    // The File Upload IP version extends the basic fileupload widget\n    // with file processing functionality:\n    $.widget('blueimpFP.fileupload', $.blueimp.fileupload, {\n\n        options: {\n            // The list of file processing actions:\n            process: [\n            /*\n                {\n                    action: 'load',\n                    fileTypes: /^image\\/(gif|jpeg|png)$/,\n                    maxFileSize: 20000000 // 20MB\n                },\n                {\n                    action: 'resize',\n                    maxWidth: 1920,\n                    maxHeight: 1200,\n                    minWidth: 800,\n                    minHeight: 600\n                },\n                {\n                    action: 'save'\n                }\n            */\n            ],\n\n            // The add callback is invoked as soon as files are added to the\n            // fileupload widget (via file input selection, drag & drop or add\n            // API call). See the basic file upload widget for more information:\n            add: function (e, data) {\n                $(this).fileupload('process', data).done(function () {\n                    data.submit();\n                });\n            }\n        },\n\n        processActions: {\n            // Loads the image given via data.files and data.index\n            // as canvas element.\n            // Accepts the options fileTypes (regular expression)\n            // and maxFileSize (integer) to limit the files to load:\n            load: function (data, options) {\n                var that = this,\n                    file = data.files[data.index],\n                    dfd = $.Deferred();\n                if (window.HTMLCanvasElement &&\n                        window.HTMLCanvasElement.prototype.toBlob &&\n                        ($.type(options.maxFileSize) !== 'number' ||\n                            file.size < options.maxFileSize) &&\n                        (!options.fileTypes ||\n                            options.fileTypes.test(file.type))) {\n                    loadImage(\n                        file,\n                        function (canvas) {\n                            data.canvas = canvas;\n                            dfd.resolveWith(that, [data]);\n                        },\n                        {canvas: true}\n                    );\n                } else {\n                    dfd.rejectWith(that, [data]);\n                }\n                return dfd.promise();\n            },\n            // Resizes the image given as data.canvas and updates\n            // data.canvas with the resized image.\n            // Accepts the options maxWidth, maxHeight, minWidth and\n            // minHeight to scale the given image:\n            resize: function (data, options) {\n                if (data.canvas) {\n                    var canvas = loadImage.scale(data.canvas, options);\n                    if (canvas.width !== data.canvas.width ||\n                            canvas.height !== data.canvas.height) {\n                        data.canvas = canvas;\n                        data.processed = true;\n                    }\n                }\n                return data;\n            },\n            // Saves the processed image given as data.canvas\n            // inplace at data.index of data.files:\n            save: function (data, options) {\n                // Do nothing if no processing has happened:\n                if (!data.canvas || !data.processed) {\n                    return data;\n                }\n                var that = this,\n                    file = data.files[data.index],\n                    name = file.name,\n                    dfd = $.Deferred(),\n                    callback = function (blob) {\n                        if (!blob.name) {\n                            if (file.type === blob.type) {\n                                blob.name = file.name;\n                            } else if (file.name) {\n                                blob.name = file.name.replace(\n                                    /\\..+$/,\n                                    '.' + blob.type.substr(6)\n                                );\n                            }\n                        }\n                        // Store the created blob at the position\n                        // of the original file in the files list:\n                        data.files[data.index] = blob;\n                        dfd.resolveWith(that, [data]);\n                    };\n                // Use canvas.mozGetAsFile directly, to retain the filename, as\n                // Gecko doesn't support the filename option for FormData.append:\n                if (data.canvas.mozGetAsFile) {\n                    callback(data.canvas.mozGetAsFile(\n                        (/^image\\/(jpeg|png)$/.test(file.type) && name) ||\n                            ((name && name.replace(/\\..+$/, '')) ||\n                                'blob') + '.png',\n                        file.type\n                    ));\n                } else {\n                    data.canvas.toBlob(callback, file.type);\n                }\n                return dfd.promise();\n            }\n        },\n\n        // Resizes the file at the given index and stores the created blob at\n        // the original position of the files list, returns a Promise object:\n        _processFile: function (files, index, options) {\n            var that = this,\n                dfd = $.Deferred().resolveWith(that, [{\n                    files: files,\n                    index: index\n                }]),\n                chain = dfd.promise();\n            that._processing += 1;\n            $.each(options.process, function (i, settings) {\n                chain = chain.pipe(function (data) {\n                    return that.processActions[settings.action]\n                        .call(this, data, settings);\n                });\n            });\n            chain.always(function () {\n                that._processing -= 1;\n                if (that._processing === 0) {\n                    that.element\n                        .removeClass('fileupload-processing');\n                }\n            });\n            if (that._processing === 1) {\n                that.element.addClass('fileupload-processing');\n            }\n            return chain;\n        },\n\n        // Processes the files given as files property of the data parameter,\n        // returns a Promise object that allows to bind a done handler, which\n        // will be invoked after processing all files (inplace) is done:\n        process: function (data) {\n            var that = this,\n                options = $.extend({}, this.options, data);\n            if (options.process && options.process.length &&\n                    this._isXHRUpload(options)) {\n                $.each(data.files, function (index, file) {\n                    that._processingQueue = that._processingQueue.pipe(\n                        function () {\n                            var dfd = $.Deferred();\n                            that._processFile(data.files, index, options)\n                                .always(function () {\n                                    dfd.resolveWith(that);\n                                });\n                            return dfd.promise();\n                        }\n                    );\n                });\n            }\n            return this._processingQueue;\n        },\n\n        _create: function () {\n            $.blueimp.fileupload.prototype._create.call(this);\n            this._processing = 0;\n            this._processingQueue = $.Deferred().resolveWith(this)\n                .promise();\n        }\n\n    });\n\n}));\n","jquery/fileUploader/main.js":"/*\n * jQuery File Upload Plugin JS Example 6.7\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2010, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*jslint nomen: true, unparam: true, regexp: true */\n/*global $, window, document */\n\n$(function () {\n    'use strict';\n\n    // Initialize the jQuery File Upload widget:\n    $('#fileupload').fileupload();\n\n    // Enable iframe cross-domain access via redirect option:\n    $('#fileupload').fileupload(\n        'option',\n        'redirect',\n        window.location.href.replace(\n            /\\/[^\\/]*$/,\n            '/cors/result.html?%s'\n        )\n    );\n\n    if (window.location.hostname === 'blueimp.github.com') {\n        // Demo settings:\n        $('#fileupload').fileupload('option', {\n            url: '//jquery-file-upload.appspot.com/',\n            maxFileSize: 5000000,\n            acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n            process: [\n                {\n                    action: 'load',\n                    fileTypes: /^image\\/(gif|jpeg|png)$/,\n                    maxFileSize: 20000000 // 20MB\n                },\n                {\n                    action: 'resize',\n                    maxWidth: 1440,\n                    maxHeight: 900\n                },\n                {\n                    action: 'save'\n                }\n            ]\n        });\n        // Upload server status check for browsers with CORS support:\n        if ($.support.cors) {\n            $.ajax({\n                url: '//jquery-file-upload.appspot.com/',\n                type: 'HEAD'\n            }).fail(function () {\n                $('<span class=\"alert alert-error\"/>')\n                    .text($.mage.__('Upload server currently unavailable - ') +\n                            new Date())\n                    .appendTo('#fileupload');\n            });\n        }\n    } else {\n        // Load existing files:\n        $('#fileupload').each(function () {\n            var that = this;\n            $.getJSON(this.action, function (result) {\n                if (result && result.length) {\n                    $(that).fileupload('option', 'done')\n                        .call(that, null, {result: result});\n                }\n            });\n        });\n    }\n\n});\n","jquery/fileUploader/cors/jquery.xdr-transport.js":"/*\n * jQuery XDomainRequest Transport Plugin 1.1.2\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n *\n * Based on Julian Aubourg's ajaxHooks xdr.js:\n * https://github.com/jaubourg/ajaxHooks/\n */\n\n/*jslint unparam: true */\n/*global define, window, XDomainRequest */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define(['jquery'], factory);\n    } else {\n        // Browser globals:\n        factory(window.jQuery);\n    }\n}(function ($) {\n    'use strict';\n    if (window.XDomainRequest && !$.support.cors) {\n        $.ajaxTransport(function (s) {\n            if (s.crossDomain && s.async) {\n                if (s.timeout) {\n                    s.xdrTimeout = s.timeout;\n                    delete s.timeout;\n                }\n                var xdr;\n                return {\n                    send: function (headers, completeCallback) {\n                        function callback(status, statusText, responses, responseHeaders) {\n                            xdr.onload = xdr.onerror = xdr.ontimeout = $.noop;\n                            xdr = null;\n                            completeCallback(status, statusText, responses, responseHeaders);\n                        }\n                        xdr = new XDomainRequest();\n                        // XDomainRequest only supports GET and POST:\n                        if (s.type === 'DELETE') {\n                            s.url = s.url + (/\\?/.test(s.url) ? '&' : '?') +\n                                '_method=DELETE';\n                            s.type = 'POST';\n                        } else if (s.type === 'PUT') {\n                            s.url = s.url + (/\\?/.test(s.url) ? '&' : '?') +\n                                '_method=PUT';\n                            s.type = 'POST';\n                        }\n                        xdr.open(s.type, s.url);\n                        xdr.onload = function () {\n                            callback(\n                                200,\n                                'OK',\n                                {text: xdr.responseText},\n                                'Content-Type: ' + xdr.contentType\n                            );\n                        };\n                        xdr.onerror = function () {\n                            callback(404, 'Not Found');\n                        };\n                        if (s.xdrTimeout) {\n                            xdr.ontimeout = function () {\n                                callback(0, 'timeout');\n                            };\n                            xdr.timeout = s.xdrTimeout;\n                        }\n                        xdr.send((s.hasContent && s.data) || null);\n                    },\n                    abort: function () {\n                        if (xdr) {\n                            xdr.onerror = $.noop();\n                            xdr.abort();\n                        }\n                    }\n                };\n            }\n        });\n    }\n}));\n","jquery/fileUploader/cors/jquery.postmessage-transport.js":"/*\n * jQuery postMessage Transport Plugin 1.1\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/MIT\n */\n\n/*jslint unparam: true, nomen: true */\n/*global define, window, document */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // Register as an anonymous AMD module:\n        define(['jquery'], factory);\n    } else {\n        // Browser globals:\n        factory(window.jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    var counter = 0,\n        names = [\n            'accepts',\n            'cache',\n            'contents',\n            'contentType',\n            'crossDomain',\n            'data',\n            'dataType',\n            'headers',\n            'ifModified',\n            'mimeType',\n            'password',\n            'processData',\n            'timeout',\n            'traditional',\n            'type',\n            'url',\n            'username'\n        ],\n        convert = function (p) {\n            return p;\n        };\n\n    $.ajaxSetup({\n        converters: {\n            'postmessage text': convert,\n            'postmessage json': convert,\n            'postmessage html': convert\n        }\n    });\n\n    $.ajaxTransport('postmessage', function (options) {\n        if (options.postMessage && window.postMessage) {\n            var iframe,\n                loc = $('<a>').prop('href', options.postMessage)[0],\n                target = loc.protocol + '//' + loc.host,\n                xhrUpload = options.xhr().upload;\n            return {\n                send: function (_, completeCallback) {\n                    var message = {\n                            id: 'postmessage-transport-' + (counter += 1)\n                        },\n                        eventName = 'message.' + message.id;\n                    iframe = $(\n                        '<iframe style=\"display:none;\" src=\"' +\n                            options.postMessage + '\" name=\"' +\n                            message.id + '\"></iframe>'\n                    ).bind('load', function () {\n                        $.each(names, function (i, name) {\n                            message[name] = options[name];\n                        });\n                        message.dataType = message.dataType.replace('postmessage ', '');\n                        $(window).bind(eventName, function (e) {\n                            e = e.originalEvent;\n                            var data = e.data,\n                                ev;\n                            if (e.origin === target && data.id === message.id) {\n                                if (data.type === 'progress') {\n                                    ev = document.createEvent('Event');\n                                    ev.initEvent(data.type, false, true);\n                                    $.extend(ev, data);\n                                    xhrUpload.dispatchEvent(ev);\n                                } else {\n                                    completeCallback(\n                                        data.status,\n                                        data.statusText,\n                                        {postmessage: data.result},\n                                        data.headers\n                                    );\n                                    iframe.remove();\n                                    $(window).unbind(eventName);\n                                }\n                            }\n                        });\n                        iframe[0].contentWindow.postMessage(\n                            message,\n                            target\n                        );\n                    }).appendTo(document.body);\n                },\n                abort: function () {\n                    if (iframe) {\n                        iframe.remove();\n                    }\n                }\n            };\n        }\n    });\n\n}));\n","jquery/fileUploader/vendor/jquery.ui.widget.js":"/*\n * jQuery UI Widget 1.8.23+amd\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2012, AUTHORS.txt (http://jqueryui.com/about)\n * Dual licensed under the MIT or GPL Version 2 licenses.\n * http://jquery.org/license\n *\n * http://docs.jquery.com/UI/Widget\n */\n\n(function (factory) {\n    if (typeof define === \"function\" && define.amd) {\n        // Register as an anonymous AMD module:\n        define([\"jquery\"], factory);\n    } else {\n        // Browser globals:\n        factory(jQuery);\n    }\n}(function( $, undefined ) {\n\n// jQuery 1.4+\nif ( $.cleanData ) {\n\tvar _cleanData = $.cleanData;\n\t$.cleanData = function( elems ) {\n\t\tfor ( var i = 0, elem; (elem = elems[i]) != null; i++ ) {\n\t\t\ttry {\n\t\t\t\t$( elem ).triggerHandler( \"remove\" );\n\t\t\t// http://bugs.jquery.com/ticket/8235\n\t\t\t} catch( e ) {}\n\t\t}\n\t\t_cleanData( elems );\n\t};\n} else {\n\tvar _remove = $.fn.remove;\n\t$.fn.remove = function( selector, keepData ) {\n\t\treturn this.each(function() {\n\t\t\tif ( !keepData ) {\n\t\t\t\tif ( !selector || $.filter( selector, [ this ] ).length ) {\n\t\t\t\t\t$( \"*\", this ).add( [ this ] ).each(function() {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t$( this ).triggerHandler( \"remove\" );\n\t\t\t\t\t\t// http://bugs.jquery.com/ticket/8235\n\t\t\t\t\t\t} catch( e ) {}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn _remove.call( $(this), selector, keepData );\n\t\t});\n\t};\n}\n\n$.widget = function( name, base, prototype ) {\n\tvar namespace = name.split( \".\" )[ 0 ],\n\t\tfullName;\n\tname = name.split( \".\" )[ 1 ];\n\tfullName = namespace + \"-\" + name;\n\n\tif ( !prototype ) {\n\t\tprototype = base;\n\t\tbase = $.Widget;\n\t}\n\n\t// create selector for plugin\n\t$.expr[ \":\" ][ fullName ] = function( elem ) {\n\t\treturn !!$.data( elem, name );\n\t};\n\n\t$[ namespace ] = $[ namespace ] || {};\n\t$[ namespace ][ name ] = function( options, element ) {\n\t\t// allow instantiation without initializing for simple inheritance\n\t\tif ( arguments.length ) {\n\t\t\tthis._createWidget( options, element );\n\t\t}\n\t};\n\n\tvar basePrototype = new base();\n\t// we need to make the options hash a property directly on the new instance\n\t// otherwise we'll modify the options hash on the prototype that we're\n\t// inheriting from\n//\t$.each( basePrototype, function( key, val ) {\n//\t\tif ( $.isPlainObject(val) ) {\n//\t\t\tbasePrototype[ key ] = $.extend( {}, val );\n//\t\t}\n//\t});\n\tbasePrototype.options = $.extend( true, {}, basePrototype.options );\n\t$[ namespace ][ name ].prototype = $.extend( true, basePrototype, {\n\t\tnamespace: namespace,\n\t\twidgetName: name,\n\t\twidgetEventPrefix: $[ namespace ][ name ].prototype.widgetEventPrefix || name,\n\t\twidgetBaseClass: fullName\n\t}, prototype );\n\n\t$.widget.bridge( name, $[ namespace ][ name ] );\n};\n\n$.widget.bridge = function( name, object ) {\n\t$.fn[ name ] = function( options ) {\n\t\tvar isMethodCall = typeof options === \"string\",\n\t\t\targs = Array.prototype.slice.call( arguments, 1 ),\n\t\t\treturnValue = this;\n\n\t\t// allow multiple hashes to be passed on init\n\t\toptions = !isMethodCall && args.length ?\n\t\t\t$.extend.apply( null, [ true, options ].concat(args) ) :\n\t\t\toptions;\n\n\t\t// prevent calls to internal methods\n\t\tif ( isMethodCall && options.charAt( 0 ) === \"_\" ) {\n\t\t\treturn returnValue;\n\t\t}\n\n\t\tif ( isMethodCall ) {\n\t\t\tthis.each(function() {\n\t\t\t\tvar instance = $.data( this, name ),\n\t\t\t\t\tmethodValue = instance && $.isFunction( instance[options] ) ?\n\t\t\t\t\t\tinstance[ options ].apply( instance, args ) :\n\t\t\t\t\t\tinstance;\n\t\t\t\t// TODO: add this back in 1.9 and use $.error() (see #5972)\n//\t\t\t\tif ( !instance ) {\n//\t\t\t\t\tthrow \"cannot call methods on \" + name + \" prior to initialization; \" +\n//\t\t\t\t\t\t\"attempted to call method '\" + options + \"'\";\n//\t\t\t\t}\n//\t\t\t\tif ( !$.isFunction( instance[options] ) ) {\n//\t\t\t\t\tthrow \"no such method '\" + options + \"' for \" + name + \" widget instance\";\n//\t\t\t\t}\n//\t\t\t\tvar methodValue = instance[ options ].apply( instance, args );\n\t\t\t\tif ( methodValue !== instance && methodValue !== undefined ) {\n\t\t\t\t\treturnValue = methodValue;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\t\t} else {\n\t\t\tthis.each(function() {\n\t\t\t\tvar instance = $.data( this, name );\n\t\t\t\tif ( instance ) {\n\t\t\t\t\tinstance.option( options || {} )._init();\n\t\t\t\t} else {\n\t\t\t\t\t$.data( this, name, new object( options, this ) );\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\n\t\treturn returnValue;\n\t};\n};\n\n$.Widget = function( options, element ) {\n\t// allow instantiation without initializing for simple inheritance\n\tif ( arguments.length ) {\n\t\tthis._createWidget( options, element );\n\t}\n};\n\n$.Widget.prototype = {\n\twidgetName: \"widget\",\n\twidgetEventPrefix: \"\",\n\toptions: {\n\t\tdisabled: false\n\t},\n\t_createWidget: function( options, element ) {\n\t\t// $.widget.bridge stores the plugin instance, but we do it anyway\n\t\t// so that it's stored even before the _create function runs\n\t\t$.data( element, this.widgetName, this );\n\t\tthis.element = $( element );\n\t\tthis.options = $.extend( true, {},\n\t\t\tthis.options,\n\t\t\tthis._getCreateOptions(),\n\t\t\toptions );\n\n\t\tvar self = this;\n\t\tthis.element.bind( \"remove.\" + this.widgetName, function() {\n\t\t\tself.destroy();\n\t\t});\n\n\t\tthis._create();\n\t\tthis._trigger( \"create\" );\n\t\tthis._init();\n\t},\n\t_getCreateOptions: function() {\n\t\treturn $.metadata && $.metadata.get( this.element[0] )[ this.widgetName ];\n\t},\n\t_create: function() {},\n\t_init: function() {},\n\n\tdestroy: function() {\n\t\tthis.element\n\t\t\t.unbind( \".\" + this.widgetName )\n\t\t\t.removeData( this.widgetName );\n\t\tthis.widget()\n\t\t\t.unbind( \".\" + this.widgetName )\n\t\t\t.removeAttr( \"aria-disabled\" )\n\t\t\t.removeClass(\n\t\t\t\tthis.widgetBaseClass + \"-disabled \" +\n\t\t\t\t\"ui-state-disabled\" );\n\t},\n\n\twidget: function() {\n\t\treturn this.element;\n\t},\n\n\toption: function( key, value ) {\n\t\tvar options = key;\n\n\t\tif ( arguments.length === 0 ) {\n\t\t\t// don't return a reference to the internal hash\n\t\t\treturn $.extend( {}, this.options );\n\t\t}\n\n\t\tif  (typeof key === \"string\" ) {\n\t\t\tif ( value === undefined ) {\n\t\t\t\treturn this.options[ key ];\n\t\t\t}\n\t\t\toptions = {};\n\t\t\toptions[ key ] = value;\n\t\t}\n\n\t\tthis._setOptions( options );\n\n\t\treturn this;\n\t},\n\t_setOptions: function( options ) {\n\t\tvar self = this;\n\t\t$.each( options, function( key, value ) {\n\t\t\tself._setOption( key, value );\n\t\t});\n\n\t\treturn this;\n\t},\n\t_setOption: function( key, value ) {\n\t\tthis.options[ key ] = value;\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis.widget()\n\t\t\t\t[ value ? \"addClass\" : \"removeClass\"](\n\t\t\t\t\tthis.widgetBaseClass + \"-disabled\" + \" \" +\n\t\t\t\t\t\"ui-state-disabled\" )\n\t\t\t\t.attr( \"aria-disabled\", value );\n\t\t}\n\n\t\treturn this;\n\t},\n\n\tenable: function() {\n\t\treturn this._setOption( \"disabled\", false );\n\t},\n\tdisable: function() {\n\t\treturn this._setOption( \"disabled\", true );\n\t},\n\n\t_trigger: function( type, event, data ) {\n\t\tvar prop, orig,\n\t\t\tcallback = this.options[ type ];\n\n\t\tdata = data || {};\n\t\tevent = $.Event( event );\n\t\tevent.type = ( type === this.widgetEventPrefix ?\n\t\t\ttype :\n\t\t\tthis.widgetEventPrefix + type ).toLowerCase();\n\t\t// the original event may come from any element\n\t\t// so we need to reset the target on the new event\n\t\tevent.target = this.element[ 0 ];\n\n\t\t// copy original event properties over to the new event\n\t\torig = event.originalEvent;\n\t\tif ( orig ) {\n\t\t\tfor ( prop in orig ) {\n\t\t\t\tif ( !( prop in event ) ) {\n\t\t\t\t\tevent[ prop ] = orig[ prop ];\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tthis.element.trigger( event, data );\n\n\t\treturn !( $.isFunction(callback) &&\n\t\t\tcallback.call( this.element[0], event, data ) === false ||\n\t\t\tevent.isDefaultPrevented() );\n\t}\n};\n\n}));\n","jquery/editableMultiselect/js/jquery.multiselect.js":"define([\n    \"jquery\"\n], function($){\n\n    /*\n     * jQuery.multiselect plugin\n     *\n     * Form control: allow select several values from list and add new value(s) to list\n     *\n     * Licensed under the BSD License:\n     *   http://www.opensource.org/licenses/bsd-license\n     *\n     * Version: 0.9.0\n     *\n     * @author Dmitry (dio) Levashov, dio@std42.ru\n     * @example\n     *  html: <select name=\"my-select\" multiple=\"on\"><option .... </select>\n     * js   : $('select[name=\"my-select\"]').multiselect()\n     *  or\n     * var opts = { ... };\n     * $('select[name=\"my-select\"]').multiselect(opts);\n     */\n    $.fn.multiselect = function(opts) {\n        var o = $.extend({\n            mselectHiddenClass: 'mselect-hidden',\n            mselectItemNotEditableClass: 'mselect-list-item-not-editable',\n            mselectItemNotRemovableClass: 'mselect-list-item-not-removable',\n            mselectListClass: 'mselect-list',\n            mselectItemsWrapperClass: 'mselect-items-wrapper',\n            mselectButtonAddClass: 'mselect-button-add',\n            mselectInputContainerClass: 'mselect-input-container',\n            mselectInputClass: 'mselect-input',\n            mselectButtonCancelClass: 'mselect-cancel',\n            mselectButtonSaveClass: 'mselect-save',\n            mselectListItemClass: 'mselect-list-item',\n            mselectItemsWrapperOverflowClass: 'mselect-fixed',\n            mselectDisabledClass: 'mselect-disabled',\n            mselectCheckedClass: 'mselect-checked',\n            layout: '<section class=\"block %mselectListClass%\">'\n                +'<div class=\"block-content\"><div class=\"%mselectItemsWrapperClass%\">'\n                +'%items%'\n                +'</div></div>'\n                +'<footer class=\"block-footer\">'\n                +'<span class=\"action-add %mselectButtonAddClass%\">%addText%</span>'\n                +'</footer>'\n                +'<div class=\"%mselectInputContainerClass%\">'\n                +'<input type=\"text\" class=\"%mselectInputClass%\" title=\"%inputTitle%\"/>'\n                +'<span class=\"%mselectButtonCancelClass%\" title=\"%cancelText%\"></span>'\n                +'<span class=\"%mselectButtonSaveClass%\" title=\"Add\"></span>'\n                +'</div>'\n                +'</section>',\n            item : '<div  class=\"%mselectListItemClass% %mselectDisabledClass% %iseditable% %isremovable%\"><label><input type=\"checkbox\" class=\"%mselectCheckedClass%\" value=\"%value%\" %checked% %disabled% /><span>%label%</span></label>' +\n                '<span class=\"mselect-edit\" title=\"Edit\">Edit</span>' +\n                '<span class=\"mselect-delete\" title=\"Delete\">Delete</span> ' +\n                '</div>',\n            addText: 'Add new value',\n            cancelText: 'Cancel',\n            inputTitle: 'Enter new option',\n            size: 5,\n            keyCodes: {\n                Enter: 13,\n                Esc: 27\n            },\n            toggleAddButton: true,\n            // New option for callback\n            mselectInputSubmitCallback: null,\n            parse : function(v) { return v.split(/\\s*,\\s*/); }\n        }, opts||{});\n\n        return this.filter('select[multiple]:not(.' + o.mselectHiddenClass + ')').each(function() {\n            var select = $(this).addClass(o.mselectHiddenClass).hide(),\n                size = select.attr('size') > 0 ? select.attr('size') : o.size,\n                items = (function() {\n                    var str = '';\n\n                    select.children('option').each(function(i, option) {\n                        option = $(option);\n\n                        str += o.item\n                            .replace(/%value%/gi,  option.val())\n                            .replace(/%checked%/gi, option.attr('selected') ? 'checked' : '')\n                            .replace(/%mselectCheckedClass%/gi, option.attr('selected') ? ''+o.mselectCheckedClass+'' : '')\n                            .replace(/%disabled%/gi, option.attr('disabled') ? 'disabled' : '')\n                            .replace(/%mselectDisabledClass%/gi, option.attr('disabled') ? ''+o.mselectDisabledClass+'' : '')\n                            .replace(/%mselectListItemClass%/gi, o.mselectListItemClass)\n                            .replace(/%iseditable%/gi, option.attr('data-is-editable') ? ''+o.mselectItemNotEditableClass+'' : '')\n                            .replace(/%isremovable%/i, option.attr('data-is-removable') ? ''+o.mselectItemNotRemovableClass+'' : '')\n                            .replace(/%label%/gi,  option.html());\n                    });\n\n                    return str;\n                })(),\n                html = o.layout\n                    .replace(/%items%/gi, items)\n                    .replace(/%mselectListClass%/gi, o.mselectListClass)\n                    .replace(/%mselectButtonAddClass%/gi, o.mselectButtonAddClass)\n                    .replace(/%mselectButtonSaveClass%/gi, o.mselectButtonSaveClass)\n                    .replace(/%mselectButtonCancelClass%/gi, o.mselectButtonCancelClass)\n                    .replace(/%mselectItemsWrapperClass%/gi, o.mselectItemsWrapperClass)\n                    .replace(/%mselectInputContainerClass%/gi, o.mselectInputContainerClass)\n                    .replace(/%mselectInputClass%/gi, o.mselectInputClass)\n                    .replace(/%addText%/gi, o.addText)\n                    .replace(/%cancelText%/gi, o.cancelText)\n                    .replace(/%inputTitle%/gi, o.inputTitle),\n                widget = $(html)\n                    .insertAfter(this)\n                    .on('change.mselectCheck', '[type=checkbox]', function() {\n                        var checkbox = $(this),\n                            index = checkbox.closest('.' + o.mselectListItemClass + '').index();\n\n                        select.find('option').eq(index).attr('selected', !!checkbox.attr('checked'));\n                    }),\n                list = widget.find('.' + o.mselectItemsWrapperClass + ''),\n                buttonAdd = widget.find('.' + o.mselectButtonAddClass + '')\n                    .on('click.mselectAdd', function(e) {\n                        e.preventDefault();\n                        o.toggleAddButton && buttonAdd.hide();\n                        container.show();\n                        input.focus();\n                        if (input.parents(o.mselectListClass).length) {\n                            list.scrollTop(list.height());\n                        }\n                    }),\n                container = widget.find('.' + o.mselectInputContainerClass + ''),\n                input = container.find('[type=text].' + o.mselectInputClass + '')\n                    .on('blur.mselectReset', function() {\n                        reset();\n                    })\n                    .on('keydown.mselectAddNewOption', function(e) {\n                        var c = e.keyCode;\n\n                        if (c == o.keyCodes.Enter || c == o.keyCodes.Esc) {\n                            e.preventDefault();\n                            c == o.keyCodes.Enter ? append(input.val())  : reset();\n                        }\n                    }),\n                buttonSave = container.find('.' + o.mselectButtonSaveClass + '')\n                    .on('mousedown.mselectSave', function(e) {\n                        append(input.val());\n                    }),\n                buttonCancel = container.find('.' + o.mselectButtonCancelClass + '')\n                    .on('mousedown.mdelectCancel', function(e) {\n                        input.val('');\n                    }),\n                append = function(v) {\n                    // Add ability to define custom handler for adding new values\n                    if ($.isFunction(o.mselectInputSubmitCallback)) {\n                        o.mselectInputSubmitCallback(v, o);\n                        return;\n                    }\n                    // end of callback implementation\n                    $.each(typeof(o.parse) == 'function' ? o.parse(v) : [$.trim(v)], function(i, v) {\n                        var item;\n\n                        if (v && !select.children('[value=\"' + v + '\"]').length) {\n                            item = $(o.item.replace(/%value%|%label%/gi, v)\n                                .replace(/%mselectDisabledClass%|%iseditable%|%isremovable%/gi,'')\n                                .replace(/%mselectListItemClass%/gi,o.mselectListItemClass))\n                                .find('[type=checkbox]')\n                                .attr('checked', true)\n                                .addClass(o.mselectCheckedClass)\n                                .end();\n\n                            list.children('.' + o.mselectListItemClass + '').length\n                                ? list.children('.' + o.mselectListItemClass + ':last').after(item)\n                                : list.prepend(item);\n\n                            select.append('<option value=\"' + v + '\" selected=\"selected\">' + v + '</option>');\n                        }\n                    });\n\n                    reset();\n                    list.scrollTop(list.height());\n                },\n                reset = function() {\n                    var ch = select.children();\n\n                    input.val('');\n                    container.hide();\n                    buttonAdd.show();\n                    list[list.children().length ? 'show' : 'hide']();\n\n                    if (ch.length >= size && !list.hasClass(o.mselectItemsWrapperOverflowClass)) {\n                        list.height(list.children('.' + o.mselectListItemClass + ':first')\n                            .outerHeight(true) * size)\n                            .addClass(o.mselectItemsWrapperOverflowClass);\n                    }\n                };\n            reset();\n        }).end();\n    };\n});","jquery/editableMultiselect/js/jquery.editable.js":"/*\n * Jeditable - jQuery in place edit plugin\n *\n * Copyright (c) 2006-2009 Mika Tuupola, Dylan Verheul\n *\n * Licensed under the MIT license:\n *   http://www.opensource.org/licenses/mit-license.php\n *\n * Project home:\n *   http://www.appelsiini.net/projects/jeditable\n *\n * Based on editable by Dylan Verheul <dylan_at_dyve.net>:\n *    http://www.dyve.net/jquery/?editable\n *\n */\n\n/**\n * Version 1.7.1\n *\n * ** means there is basic unit tests for this parameter.\n *\n * @name  Jeditable\n * @type  jQuery\n * @param String  target             (POST) URL or function to send edited content to **\n * @param Hash    options            additional options\n * @param String  options[method]    method to use to send edited content (POST or PUT) **\n * @param Function options[callback] Function to run after submitting edited content **\n * @param String  options[name]      POST parameter name of edited content\n * @param String  options[id]        POST parameter name of edited div id\n * @param Hash    options[submitdata] Extra parameters to send when submitting edited content.\n * @param String  options[type]      text, textarea or select (or any 3rd party input type) **\n * @param Integer options[rows]      number of rows if using textarea **\n * @param Integer options[cols]      number of columns if using textarea **\n * @param Mixed   options[height]    'auto', 'none' or height in pixels **\n * @param Mixed   options[width]     'auto', 'none' or width in pixels **\n * @param String  options[loadurl]   URL to fetch input content before editing **\n * @param String  options[loadtype]  Request type for load url. Should be GET or POST.\n * @param String  options[loadtext]  Text to display while loading external content.\n * @param Mixed   options[loaddata]  Extra parameters to pass when fetching content before editing.\n * @param Mixed   options[data]      Or content given as paramameter. String or function.**\n * @param String  options[indicator] indicator html to show when saving\n * @param String  options[tooltip]   optional tooltip text via title attribute **\n * @param String  options[event]     jQuery event such as 'click' of 'dblclick' **\n * @param String  options[submit]    submit button value, empty means no button **\n * @param String  options[cancel]    cancel button value, empty means no button **\n * @param String  options[cssclass]  CSS class to apply to input form. 'inherit' to copy from parent. **\n * @param String  options[style]     Style to apply to input form 'inherit' to copy from parent. **\n * @param String  options[select]    true or false, when true text is highlighted ??\n * @param String  options[placeholder] Placeholder text or html to insert when element is empty. **\n * @param String  options[onblur]    'cancel', 'submit', 'ignore' or function ??\n *\n * @param Function options[onsubmit] function(settings, original) { ... } called before submit\n * @param Function options[onreset]  function(settings, original) { ... } called before reset\n * @param Function options[onerror]  function(settings, original, xhr) { ... } called on error\n *\n * @param Hash    options[ajaxoptions]  jQuery Ajax options. See docs.jquery.com.\n *\n */\n\n(function($) {\n\n    $.fn.editable = function(target, options) {\n\n        if ('disable' == target) {\n            $(this).data('disabled.editable', true);\n            return;\n        }\n        if ('enable' == target) {\n            $(this).data('disabled.editable', false);\n            return;\n        }\n        if ('destroy' == target) {\n            $(this)\n                .unbind($(this).data('event.editable'))\n                .removeData('disabled.editable')\n                .removeData('event.editable');\n            return;\n        }\n\n        var settings = $.extend({}, $.fn.editable.defaults, {target:target}, options);\n\n        /* setup some functions */\n        var plugin   = $.editable.types[settings.type].plugin || function() { };\n        var submit   = $.editable.types[settings.type].submit || function() { };\n        var buttons  = $.editable.types[settings.type].buttons\n            || $.editable.types['defaults'].buttons;\n        var content  = $.editable.types[settings.type].content\n            || $.editable.types['defaults'].content;\n        var element  = $.editable.types[settings.type].element\n            || $.editable.types['defaults'].element;\n        var reset    = $.editable.types[settings.type].reset\n            || $.editable.types['defaults'].reset;\n        var callback = settings.callback || function() { };\n        var onedit   = settings.onedit   || function() { };\n        var onsubmit = settings.onsubmit || function() { };\n        var onreset  = settings.onreset  || function() { };\n        var onerror  = settings.onerror  || reset;\n\n        /* show tooltip */\n        if (settings.tooltip) {\n            $(this).attr('title', settings.tooltip);\n        }\n\n        settings.autowidth  = 'auto' == settings.width;\n        settings.autoheight = 'auto' == settings.height;\n\n        return this.each(function() {\n\n            /* save this to self because this changes when scope changes */\n            var self = this;\n\n            /* inlined block elements lose their width and height after first edit */\n            /* save them for later use as workaround */\n            var savedwidth  = $(self).width();\n            var savedheight = $(self).height();\n\n            /* save so it can be later used by $.editable('destroy') */\n            $(this).data('event.editable', settings.event);\n\n            /* if element is empty add something clickable (if requested) */\n            if (!$.trim($(this).html())) {\n                $(this).html(settings.placeholder);\n            }\n\n            $(this).bind(settings.event, function(e) {\n\n                /* abort if disabled for this element */\n                if (true === $(this).data('disabled.editable')) {\n                    return;\n                }\n\n                /* prevent throwing an exeption if edit field is clicked again */\n                if (self.editing) {\n                    return;\n                }\n\n                /* abort if onedit hook returns false */\n                if (false === onedit.apply(this, [settings, self])) {\n                    return;\n                }\n\n                /* prevent default action and bubbling */\n                e.preventDefault();\n                e.stopPropagation();\n\n                /* remove tooltip */\n                if (settings.tooltip) {\n                    $(self).removeAttr('title');\n                }\n\n                /* figure out how wide and tall we are, saved width and height */\n                /* are workaround for http://dev.jquery.com/ticket/2190 */\n                if (0 == $(self).width()) {\n                    //$(self).css('visibility', 'hidden');\n                    settings.width  = savedwidth;\n                    settings.height = savedheight;\n                } else {\n                    if (settings.width != 'none') {\n                        settings.width =\n                            settings.autowidth ? $(self).width()  : settings.width;\n                    }\n                    if (settings.height != 'none') {\n                        settings.height =\n                            settings.autoheight ? $(self).height() : settings.height;\n                    }\n                }\n                //$(this).css('visibility', '');\n\n                /* remove placeholder text, replace is here because of IE */\n                if ($(this).html().toLowerCase().replace(/(;|\")/g, '') ==\n                    settings.placeholder.toLowerCase().replace(/(;|\")/g, '')) {\n                    $(this).html('');\n                }\n\n                self.editing    = true;\n                self.revert     = $(self).html();\n                $(self).html('');\n\n                /* create the form object */\n                var form = $('<form />');\n\n                /* apply css or style or both */\n                if (settings.cssclass) {\n                    if ('inherit' == settings.cssclass) {\n                        form.attr('class', $(self).attr('class'));\n                    } else {\n                        form.attr('class', settings.cssclass);\n                    }\n                }\n\n                if (settings.style) {\n                    if ('inherit' == settings.style) {\n                        form.attr('style', $(self).attr('style'));\n                        /* IE needs the second line or display wont be inherited */\n                        form.css('display', $(self).css('display'));\n                    } else {\n                        form.attr('style', settings.style);\n                    }\n                }\n\n                /* add main input element to form and store it in input */\n                var input = element.apply(form, [settings, self]);\n\n                /* set input content via POST, GET, given data or existing value */\n                var input_content;\n\n                if (settings.loadurl) {\n                    var t = setTimeout(function() {\n                        input.disabled = true;\n                        content.apply(form, [settings.loadtext, settings, self]);\n                    }, 100);\n\n                    var loaddata = {};\n                    loaddata[settings.id] = self.id;\n                    if ($.isFunction(settings.loaddata)) {\n                        $.extend(loaddata, settings.loaddata.apply(self, [self.revert, settings]));\n                    } else {\n                        $.extend(loaddata, settings.loaddata);\n                    }\n                    $.ajax({\n                        type : settings.loadtype,\n                        url  : settings.loadurl,\n                        data : loaddata,\n                        async : false,\n                        success: function(result) {\n                            window.clearTimeout(t);\n                            input_content = result;\n                            input.disabled = false;\n                        }\n                    });\n                } else if (settings.data) {\n                    input_content = settings.data;\n                    if ($.isFunction(settings.data)) {\n                        input_content = settings.data.apply(self, [self.revert, settings]);\n                    }\n                } else {\n                    input_content = self.revert;\n                }\n                content.apply(form, [input_content, settings, self]);\n\n                input.attr('name', settings.name);\n\n                /* add buttons to the form */\n                buttons.apply(form, [settings, self]);\n\n                /* add created form to self */\n                $(self).append(form);\n\n                /* attach 3rd party plugin if requested */\n                plugin.apply(form, [settings, self]);\n\n                /* focus to first visible form element */\n                $(':input:visible:enabled:first', form).focus();\n\n                /* highlight input contents when requested */\n                if (settings.select) {\n                    input.select();\n                }\n\n                /* discard changes if pressing esc */\n                input.keydown(function(e) {\n                    if (e.keyCode == 27) {\n                        e.preventDefault();\n                        //self.reset();\n                        reset.apply(form, [settings, self]);\n                    }\n                });\n\n                /* discard, submit or nothing with changes when clicking outside */\n                /* do nothing is usable when navigating with tab */\n                var t;\n                if ('cancel' == settings.onblur) {\n                    input.blur(function(e) {\n                        /* prevent canceling if submit was clicked */\n                        t = setTimeout(function() {\n                            reset.apply(form, [settings, self]);\n                        }, 500);\n                    });\n                } else if ('submit' == settings.onblur) {\n                    input.blur(function(e) {\n                        /* prevent double submit if submit was clicked */\n                        t = setTimeout(function() {\n                            form.submit();\n                        }, 200);\n                    });\n                } else if ($.isFunction(settings.onblur)) {\n                    input.blur(function(e) {\n                        settings.onblur.apply(self, [input.val(), settings]);\n                    });\n                } else {\n                    input.blur(function(e) {\n                        /* TODO: maybe something here */\n                    });\n                }\n\n                form.submit(function(e) {\n\n                    if (t) {\n                        clearTimeout(t);\n                    }\n\n                    /* do no submit */\n                    e.preventDefault();\n\n                    /* call before submit hook. */\n                    /* if it returns false abort submitting */\n                    if (false !== onsubmit.apply(form, [settings, self])) {\n                        /* custom inputs call before submit hook. */\n                        /* if it returns false abort submitting */\n                        if (false !== submit.apply(form, [settings, self])) {\n\n                            /* check if given target is function */\n                            if ($.isFunction(settings.target)) {\n                                var str = settings.target.apply(self, [input.val(), settings]);\n                                $(self).html(str);\n                                self.editing = false;\n                                callback.apply(self, [self.innerHTML, settings]);\n                                /* TODO: this is not dry */\n                                if (!$.trim($(self).html())) {\n                                    $(self).html(settings.placeholder);\n                                }\n                            } else {\n                                /* add edited content and id of edited element to POST */\n                                var submitdata = {};\n                                submitdata[settings.name] = input.val();\n                                submitdata[settings.id] = self.id;\n                                /* add extra data to be POST:ed */\n                                if ($.isFunction(settings.submitdata)) {\n                                    $.extend(submitdata, settings.submitdata.apply(self, [self.revert, settings]));\n                                } else {\n                                    $.extend(submitdata, settings.submitdata);\n                                }\n\n                                /* quick and dirty PUT support */\n                                if ('PUT' == settings.method) {\n                                    submitdata['_method'] = 'put';\n                                }\n\n                                /* show the saving indicator */\n                                $(self).html(settings.indicator);\n\n                                /* defaults for ajaxoptions */\n                                var ajaxoptions = {\n                                    type    : 'POST',\n                                    data    : submitdata,\n                                    dataType: 'html',\n                                    url     : settings.target,\n                                    success : function(result, status) {\n                                        if (ajaxoptions.dataType == 'html') {\n                                            $(self).html(result);\n                                        }\n                                        self.editing = false;\n                                        callback.apply(self, [result, settings]);\n                                        if (!$.trim($(self).html())) {\n                                            $(self).html(settings.placeholder);\n                                        }\n                                    },\n                                    error   : function(xhr, status, error) {\n                                        onerror.apply(form, [settings, self, xhr]);\n                                    }\n                                };\n\n                                /* override with what is given in settings.ajaxoptions */\n                                $.extend(ajaxoptions, settings.ajaxoptions);\n                                $.ajax(ajaxoptions);\n\n                            }\n                        }\n                    }\n\n                    /* show tooltip again */\n                    $(self).attr('title', settings.tooltip);\n\n                    return false;\n                });\n            });\n\n            /* privileged methods */\n            this.reset = function(form) {\n                /* prevent calling reset twice when blurring */\n                if (this.editing) {\n                    /* before reset hook, if it returns false abort reseting */\n                    if (false !== onreset.apply(form, [settings, self])) {\n                        $(self).html(self.revert);\n                        self.editing   = false;\n                        if (!$.trim($(self).html())) {\n                            $(self).html(settings.placeholder);\n                        }\n                        /* show tooltip again */\n                        if (settings.tooltip) {\n                            $(self).attr('title', settings.tooltip);\n                        }\n                    }\n                }\n            };\n        });\n\n    };\n\n\n    $.editable = {\n        types: {\n            defaults: {\n                element : function(settings, original) {\n                    var input = $('<input type=\"hidden\"></input>');\n                    $(this).append(input);\n                    return(input);\n                },\n                content : function(string, settings, original) {\n                    $(':input:first', this).val(string);\n                },\n                reset : function(settings, original) {\n                    settings.data.apply(original, [original, settings]);\n                    original.reset(this);\n                },\n                buttons : function(settings, original) {\n                    var form = this;\n                    if (settings.submit) {\n                        /* if given html string use that */\n                        if (settings.submit.match(/>$/)) {\n                            var submit = $(settings.submit).click(function() {\n                                if (submit.attr(\"type\") != \"submit\") {\n                                    form.submit();\n                                }\n                            });\n                            /* otherwise use button with given string as text */\n                        } else {\n                            var submit = $('<button type=\"submit\" />');\n                            submit.html(settings.submit);\n                        }\n                        $(this).append(submit);\n                    }\n                    if (settings.cancel) {\n                        /* if given html string use that */\n                        if (settings.cancel.match(/>$/)) {\n                            var cancel = $(settings.cancel);\n                            /* otherwise use button with given string as text */\n                        } else {\n                            var cancel = $('<button type=\"cancel\" />');\n                            cancel.html(settings.cancel);\n                        }\n                        $(this).append(cancel);\n\n                        $(cancel).click(function(event) {\n                            original.reset(this);\n                            return false;\n                        });\n                    }\n                }\n            },\n            text: {\n                element : function(settings, original) {\n                    var input = $('<input type=\"text\"/>');\n//                    if (settings.width  != 'none') { input.width(settings.width);  }\n//                    if (settings.height != 'none') { input.height(settings.height); }\n                    /* https://bugzilla.mozilla.org/show_bug.cgi?id=236791 */\n                    //input[0].setAttribute('autocomplete','off');\n                    input.attr('autocomplete','off');\n                    $(this).append(input);\n                    return(input);\n                }\n            },\n            textarea: {\n                element : function(settings, original) {\n                    var textarea = $('<textarea />');\n                    if (settings.rows) {\n                        textarea.attr('rows', settings.rows);\n                    } else if (settings.height != \"none\") {\n                        textarea.height(settings.height);\n                    }\n                    if (settings.cols) {\n                        textarea.attr('cols', settings.cols);\n                    } else if (settings.width != \"none\") {\n                        textarea.width(settings.width);\n                    }\n                    $(this).append(textarea);\n                    return(textarea);\n                }\n            },\n            select: {\n                element : function(settings, original) {\n                    var select = $('<select />');\n                    $(this).append(select);\n                    return(select);\n                },\n                content : function(data, settings, original) {\n                    /* If it is string assume it is json. */\n                    if (String == data.constructor) {\n                        eval ('var json = ' + data);\n                    } else {\n                        /* Otherwise assume it is a hash already. */\n                        var json = data;\n                    }\n                    for (var key in json) {\n                        if (!json.hasOwnProperty(key)) {\n                            continue;\n                        }\n                        if ('selected' == key) {\n                            continue;\n                        }\n                        var option = $('<option />').val(key).append(json[key]);\n                        $('select', this).append(option);\n                    }\n                    /* Loop option again to set selected. IE needed this... */\n                    $('select', this).children().each(function() {\n                        if ($(this).val() == json['selected'] ||\n                            $(this).text() == $.trim(original.revert)) {\n                            $(this).attr('selected', 'selected');\n                        }\n                    });\n                }\n            }\n        },\n\n        /* Add new input type */\n        addInputType: function(name, input) {\n            $.editable.types[name] = input;\n        }\n    };\n\n    // publicly accessible defaults\n    $.fn.editable.defaults = {\n        name       : 'value',\n        id         : 'id',\n        type       : 'text',\n        width      : 'auto',\n        height     : 'auto',\n        event      : 'click.editable',\n        onblur     : 'cancel',\n        loadtype   : 'GET',\n        loadtext   : 'Loading...',\n        placeholder: 'Click to edit',\n        loaddata   : {},\n        submitdata : {},\n        ajaxoptions: {}\n    };\n\n})(jQuery);\n","Magento_Review/js/rating.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('marketing.ratingControl', {\n        options: {\n            colorFilled: '#333',\n            colorUnfilled: '#CCCCCC',\n            colorHover: '#f30'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._labels = this.element.find('label');\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this._labels.on({\n                click: $.proxy(function (e) {\n                    $('[id=\"' + $(e.currentTarget).attr('for') + '\"]').prop('checked', true);\n                    this._updateRating();\n                }, this),\n\n                hover: $.proxy(function (e) {\n                    this._updateHover($(e.currentTarget), this.options.colorHover);\n                }, this),\n\n                mouseleave: $.proxy(function (e) {\n                    this._updateHover($(e.currentTarget), this.options.colorUnfilled);\n                }, this)\n            });\n\n            this._updateRating();\n        },\n\n        /**\n         * @param {jQuery} elem\n         * @param {String} color\n         * @private\n         */\n        _updateHover: function (elem, color) {\n            elem.nextAll('label').addBack().filter(function () {\n                return !$(this).data('checked');\n            }).css('color', color);\n        },\n\n        /**\n         * @private\n         */\n        _updateRating: function () {\n            var checkedInputs = this.element.find('input[type=\"radio\"]:checked');\n\n            checkedInputs.nextAll('label').addBack().css('color', this.options.colorFilled).data('checked', true);\n            checkedInputs.prevAll('label').css('color', this.options.colorUnfilled).data('checked', false);\n        }\n    });\n\n});\n","Magento_GroupedProduct/js/grouped-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'mage/adminhtml/grid'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.groupedProduct', {\n        /**\n         * Create widget\n         * @private\n         */\n        _create: function () {\n            this.$grid = this.element.find('[data-role=grouped-product-grid]');\n            this.$grid.sortable({\n                distance: 8,\n                items: '[data-role=row]',\n                tolerance: 'pointer',\n                cancel: ':input',\n                update: $.proxy(function () {\n                    this.element.trigger('resort');\n                }, this)\n            });\n\n            this.productTmpl = mageTemplate('#group-product-template');\n\n            $.each(\n                this.$grid.data('products'),\n                $.proxy(function (index, product) {\n                    this._add(null, product);\n                }, this)\n            );\n\n            this._on({\n                'add': '_add',\n                'resort': '_resort',\n                'click [data-column=actions] [data-role=delete]': '_remove'\n            });\n\n            this._bindDialog();\n            this._updateGridVisibility();\n        },\n\n        /**\n         * Add product to grouped grid\n         * @param {EventObject} event\n         * @param {Object} product\n         * @private\n         */\n        _add: function (event, product) {\n            var tmpl,\n                productExists;\n\n            productExists = this.$grid.find('[data-role=id]')\n                .filter(function (index, element) {\n                    return $(element).val() == product.id; //eslint-disable-line eqeqeq\n                }).length;\n\n            if (!productExists) {\n                tmpl = this.productTmpl({\n                    data: product\n                });\n\n                $(tmpl).appendTo(this.$grid.find('tbody'));\n            }\n        },\n\n        /**\n         * Remove product\n         * @param {EventObject} event\n         * @private\n         */\n        _remove: function (event) {\n            $(event.target).closest('[data-role=row]').remove();\n            this.element.trigger('resort');\n            this._updateGridVisibility();\n        },\n\n        /**\n         * Resort products\n         * @private\n         */\n        _resort: function () {\n            this.element.find('[data-role=position]').each($.proxy(function (index, element) {\n                $(element).val(index + 1);\n            }, this));\n        },\n\n        /**\n         * Create modal for show product\n         *\n         * @private\n         */\n        _bindDialog: function () {\n            var widget = this,\n                selectedProductList = {},\n                popup = $('[data-role=add-product-dialog]'),\n                gridPopup;\n\n            popup.modal({\n                type: 'slide',\n                innerScroll: true,\n                title: $.mage.__('Add Products to Group'),\n                modalClass: 'grouped',\n\n                /** @inheritdoc */\n                open: function () {\n                    $(this).addClass('admin__scope-old'); // ToDo UI: remove with old styles removal\n                },\n                buttons: [{\n                    id: 'grouped-product-dialog-apply-button',\n                    text: $.mage.__('Add Selected Products'),\n                    'class': 'action-primary action-add',\n\n                    /** @inheritdoc */\n                    click: function () {\n                        $.each(selectedProductList, function (index, product) {\n                            widget._add(null, product);\n                        });\n                        widget._resort();\n                        widget._updateGridVisibility();\n                        popup.modal('closeModal');\n                    }\n                }]\n            });\n\n            popup.on('click', '[data-role=row]', function (event) {\n                var target = $(event.target);\n\n                if (!target.is('input')) {\n                    target.closest('[data-role=row]')\n                        .find('[data-column=entity_ids] input')\n                        .prop('checked', function (element, value) {\n                            return !value;\n                        })\n                        .trigger('change');\n                }\n            });\n\n            popup.on(\n                'change',\n                '[data-role=row] [data-column=entity_ids] input',\n                $.proxy(function (event) {\n                    var element = $(event.target),\n                        product = {};\n\n                    if (element.is(':checked')) {\n                        product.id = element.val();\n                        product.qty = 0;\n                        element.closest('[data-role=row]').find('[data-column]').each(function (index, el) {\n                            product[$(el).data('column')] = $.trim($(el).text());\n                        });\n                        selectedProductList[product.id] = product;\n                    } else {\n                        delete selectedProductList[element.val()];\n                    }\n                }, this)\n            );\n\n            gridPopup = $(this.options.gridPopup).data('gridObject');\n\n            $('[data-role=add-product]').on('click', function (event) {\n                event.preventDefault();\n                popup.modal('openModal');\n                gridPopup.reload();\n                selectedProductList = {};\n            });\n\n            $('#' + gridPopup.containerId).on('gridajaxsettings', function (event, ajaxSettings) {\n                var ids = widget.$grid.find('[data-role=id]').map(function (index, element) {\n                    return $(element).val();\n                }).toArray();\n\n                ajaxSettings.data.filter = $.extend(ajaxSettings.data.filter || {}, {\n                    'entity_ids': ids\n                });\n            }).on('gridajax', function (event, ajaxRequest) {\n                ajaxRequest.done(function () {\n                    popup.find('[data-role=row] [data-column=entity_ids] input').each(function (index, element) {\n                        var $element = $(element);\n\n                        $element.prop('checked', !!selectedProductList[$element.val()]);\n                    });\n                });\n            });\n        },\n\n        /**\n         * Show or hide message\n         * @private\n         */\n        _updateGridVisibility: function () {\n            var showGrid = this.element.find('[data-role=id]').length > 0;\n\n            this.element.find('.grid-container').toggle(showGrid);\n            this.element.find('.no-products-message').toggle(!showGrid);\n        }\n    });\n\n    return $.mage.groupedProduct;\n});\n","Magento_Integration/js/integration.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * jQuery plugin is added.\n *\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate',\n    'Magento_Ui/js/modal/modal'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.integration', {\n        /**\n         * Options common to all instances of this widget.\n         * @type {Object}\n         */\n        options: {\n            /**\n             * URL of the integration grid.\n             * @type {String}\n             */\n            gridUrl: ''\n        },\n\n        /**\n         * Bind event handler for the action when admin clicks \"Save & Activate\" button.\n         * @private\n         */\n        _create: function () {\n            if ($('#save-split-button-activate').length) {\n                // We're on the \"New integration\" page - bind related handler\n                this._form = $('#edit_form');\n                this._form.on('saveAndActivate', $.proxy(this._saveAndActivate, this));\n            }\n        },\n\n        /**\n         * Save new integration, then kick off the activate dialog.\n         * @private\n         */\n        _saveAndActivate: function () {\n            if (this._form.validation && !this._form.validation('isValid')) {\n                return false;\n            }\n\n            $.ajax({\n                url: this._form.prop('action'),\n                type: 'post',\n                data: this._form.serialize(),\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    $('body').trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                success: function (data) {\n                    var integrationName, that;\n\n                    if (data._redirect) {\n                        window.location.href = data._redirect;\n                    } else if (data.integrationId) {\n                        integrationName = $('#integration_properties_name').val();\n                        window.integration.popup.show($('<span>').attr({\n                            'data-row-dialog': 'permissions',\n                            'data-row-id': data.integrationId,\n                            // We do escaping here instead of the place of actual output because _showPopup()\n                            // actually receives dialog window title from couple of places: from here and from the grid.\n                            // The issue is we always should escape values in the grid, so that value is already\n                            // escaped. To avoid double escaping we do it here instead of the output.\n                            'data-row-name': $('<div>').text(integrationName).html(),\n                            'data-row-is-reauthorize': '0',\n                            'data-row-is-token-exchange': data.isTokenExchange\n                        }));\n                        that = this;\n                        $('#integration-popup-container').on('dialogclose', function () {\n                            $('body').trigger('processStart');\n                            window.location.href = that.options.gridUrl;\n\n                            return false;\n                        });\n                    }\n                },\n\n                /** @inheritdoc */\n                error: function (jqXHR, status, error) {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    window.console && console.log(status + ': ' + error + '\\nResponse text:\\n' + jqXHR.responseText);\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    $('body').trigger('processStop');\n                }\n            });\n\n            return true;\n        }\n    });\n\n    /**\n     * @param {*} permissionsDialogUrl\n     * @param {*} tokensDialogUrl\n     * @param {*} tokensExchangeUrl\n     * @param {*} gridUrl\n     * @param {*} successCallbackUrl\n     * @return {Object}\n     * @constructor\n     */\n    window.Integration = function (\n        permissionsDialogUrl,\n        tokensDialogUrl,\n        tokensExchangeUrl,\n        gridUrl,\n        successCallbackUrl\n    ) {\n        var url = {\n            permissions: permissionsDialogUrl,\n            tokens: tokensDialogUrl,\n            tokensExchange: tokensExchangeUrl,\n            grid: gridUrl\n        },\n        IdentityLogin = {\n            win: null,\n            strLocation: null,\n            checker: null,\n            isCalledBack: false,\n            //Info popup dialog. Should be hidden when login window is closed\n            jqInfoDialog: $('#integration-popup-container'),\n            successCallbackUrl: successCallbackUrl,\n            Constants: {\n                /*\n                 This interval is set such that it adjusts to the child window closing timeout of 1000 ms. This will\n                 give the checker function enough time to detect if the successCallback has been invoked\n                 */\n                CHECKER_INTERVAL: 500,\n                //Login screen size plus some buffer\n                WIDTH: 680,\n                HEIGHT: 510,\n                // subtract pixels(30) and width(680) from screen width to move popup from extreme left\n                LEFT: screen.width - 680 - 30,\n                // subtract pixels(300) and height(300) from screen height to move from top\n                TOP: screen.height - 510 - 300\n            },\n\n            /**\n             * @param {*} identityCallbackUrl\n             * @param {*} consumerKey\n             * @param {*} jqInfoDialog\n             */\n            invokePopup: function (identityCallbackUrl, consumerKey, jqInfoDialog) {\n                var param;\n\n                // Callback should be invoked only once. Reset callback flag on subsequent invocations.\n                IdentityLogin.isCalledBack = false;\n                IdentityLogin.jqInfoDialog = jqInfoDialog;\n                param = $.param({\n                    'oauth_consumer_key': consumerKey,\n                    'success_call_back': IdentityLogin.successCallbackUrl\n                });\n                IdentityLogin.win = window.open(identityCallbackUrl + '?' + param, '',\n                    'top=' + IdentityLogin.Constants.TOP +\n                        ', left=' + IdentityLogin.Constants.LEFT +\n                        ', width=' + IdentityLogin.Constants.WIDTH +\n                        ', height=' + IdentityLogin.Constants.HEIGHT + ',scrollbars=no');\n\n                if (IdentityLogin.checker != null) {\n                    //Clear any previous check\n                    clearInterval(IdentityLogin.checker);\n                }\n                //Polling to detect url of the child window.\n                IdentityLogin.checker = setInterval(\n                    IdentityLogin.fnCheckLocation, IdentityLogin.Constants.CHECKER_INTERVAL\n                );\n            },\n\n            /**\n             * Function to check the location of the child popoup window.\n             * Once detected if the callback is successful, parent window will be reloaded\n             */\n            fnCheckLocation: function () {\n                if (IdentityLogin.win == null) {\n                    return;\n                }\n                // Check to see if the location has changed.\n                try {\n                    //Is the success callback invoked\n                    if (IdentityLogin.win.closed ||\n                        IdentityLogin.win.location.href == IdentityLogin.successCallbackUrl //eslint-disable-line eqeqeq\n                    ) {\n                        //Stop the the polling\n                        clearInterval(IdentityLogin.checker);\n                        $('body').trigger('processStart');\n                        //Check for window closed\n                        window.location.reload();\n                        IdentityLogin.jqInfoDialog.modal('closeModal');\n                    }\n                } catch (e) {\n                    //squash. In case Window closed without success callback, clear polling\n                    if (IdentityLogin.win.closed) {\n                        IdentityLogin.jqInfoDialog.modal('closeModal');\n                        clearInterval(IdentityLogin.checker);\n                    }\n\n                    return;\n                }\n            }\n        },\n\n        /**\n         * @param {Object} popupWindow\n         * @return {Boolean}\n         */\n        isPopupBlocked = function (popupWindow) {\n            try {\n                popupWindow.focus();\n            } catch (e) {\n                alert({\n                    content: $.mage.__('Popup Blocker is enabled! Please add this site to your exception list.')\n                });\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {*} dialog\n         * @param {*} title\n         * @param {*} okButton\n         * @param {*} ajaxUrl\n         * @private\n         */\n        _showPopup = function (dialog, title, okButton, ajaxUrl) {\n            $.ajax({\n                url: ajaxUrl,\n                cache: false,\n                data: {\n                    'form_key': window.FORM_KEY\n                },\n                method: 'GET',\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    // Show the spinner\n                    $('body').trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                success: function (result) {\n                    var redirect = result._redirect,\n                        identityLinkUrl, consumerKey, popupHtml, popup, resultObj, buttons, dialogProperties;\n\n                    if (redirect) {\n                        window.location.href = redirect;\n\n                        return;\n                    }\n\n                    identityLinkUrl = null;\n                    consumerKey = null;\n                    popupHtml = null;\n                    popup = $('#integration-popup-container');\n\n                    try {\n                        resultObj = typeof result === 'string' ?\n                            JSON.parse(result) :\n                            result;\n\n                        identityLinkUrl = resultObj['identity_link_url'];\n                        consumerKey      = resultObj['oauth_consumer_key'];\n                        popupHtml       = resultObj['popup_content'];\n\n                    } catch (e) {\n                        //This is expected if result is not json. Do nothing.\n                    }\n\n                    if (identityLinkUrl && consumerKey && popupHtml) {\n                        IdentityLogin.invokePopup(identityLinkUrl, consumerKey, popup);\n\n                        if (isPopupBlocked(IdentityLogin.win)) {\n                            return;\n                        }\n                    } else {\n                        popupHtml = result;\n                    }\n\n                    if (popup.length === 0) {\n                        popup = $('<div/>');\n                    }\n                    popup.html(popupHtml);\n\n                    buttons = [];\n                    dialogProperties = {\n                        title: title,\n                        type: 'slide',\n                        dialogClass: dialog == 'permissions' ? 'integration-dialog' : 'integration-dialog no-close' //eslint-disable-line\n                    };\n\n                    // Add confirmation button to the list of dialog buttons. okButton not set for tokenExchange dialog\n                    if (okButton) {\n                        buttons.push(okButton);\n                    }\n                    // Add button only if its not empty\n                    if (buttons.length > 0) {\n                        dialogProperties.buttons = buttons;\n                    }\n                    popup.modal(dialogProperties);\n                    popup.modal('openModal');\n                },\n\n                /** @inheritdoc */\n                error: function (jqXHR, status, error) {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    window.console && console.log(status + ': ' + error + '\\nResponse text:\\n' + jqXHR.responseText);\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    // Hide the spinner\n                    $('body').trigger('processStop');\n                }\n            });\n        };\n\n        return {\n            popup: {\n                /**\n                 * @param {*} ctx\n                 */\n                show: function (ctx) {\n                    var dialog = $(ctx).attr('data-row-dialog'),\n                        isReauthorize = $(ctx).attr('data-row-is-reauthorize'),\n                        isTokenExchange = $(ctx).attr('data-row-is-token-exchange'),\n                        integrationId, ajaxUrl, integrationName, okButton;\n\n                    if (!url.hasOwnProperty(dialog)) {\n                        throw 'Invalid dialog type';\n                    }\n\n                    integrationId = $(ctx).attr('data-row-id');\n\n                    if (!integrationId) {\n                        throw 'Unable to find integration ID';\n                    }\n\n                    // Replace placeholders in URL\n                    ajaxUrl = url[dialog].replace(':id', integrationId).replace(':isReauthorize', isReauthorize);\n\n                    try {\n                        // Get integration name either from current element or from neighbor column\n                        integrationName = $(ctx).attr('data-row-name') ||\n                            $(ctx).parents('tr').find('.col-name').html().trim();\n\n                        if (integrationName.indexOf('<span') > -1) {\n                            // Remove unsecure URL warning from popup window title if it is present\n                            integrationName = integrationName.substring(0, integrationName.indexOf('<span'));\n                        }\n                    } catch (e) {\n                        throw 'Unable to find integration name';\n                    }\n\n                    okButton = {\n                        permissions: {\n                            text: isReauthorize == '1' ? $.mage.__('Reauthorize') : $.mage.__('Allow'), //eslint-disable-line\n                            'class': 'action-primary',\n                            attr: {\n                                'data-row-id': integrationId,\n                                'data-row-name': integrationName,\n                                'data-row-dialog': isTokenExchange == '1' ? 'tokensExchange' : 'tokens', //eslint-disable-line\n                                'data-row-is-reauthorize': isReauthorize,\n                                'data-row-is-token-exchange': isTokenExchange\n                            },\n\n                            /**\n                             * Click.\n                             */\n                            click: function () {\n                                // Find the 'Allow' button and clone - it has all necessary data, but is going to be\n                                // destroyed along with the current dialog\n                                va