require.config({"config": {
        "jsbuild":{"jquery.js":"/*!\n * jQuery JavaScript Library v1.12.4\n * http://jquery.com/\n *\n * Includes Sizzle.js\n * http://sizzlejs.com/\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license\n * http://jquery.org/license\n *\n * Date: 2016-05-20T17:17Z\n */\n\n(function( global, factory ) {\n\n\tif ( typeof module === \"object\" && typeof module.exports === \"object\" ) {\n\t\t// For CommonJS and CommonJS-like environments where a proper `window`\n\t\t// is present, execute the factory and get jQuery.\n\t\t// For environments that do not have a `window` with a `document`\n\t\t// (such as Node.js), expose a factory as module.exports.\n\t\t// This accentuates the need for the creation of a real `window`.\n\t\t// e.g. var jQuery = require(\"jquery\")(window);\n\t\t// See ticket #14549 for more info.\n\t\tmodule.exports = global.document ?\n\t\t\tfactory( global, true ) :\n\t\t\tfunction( w ) {\n\t\t\t\tif ( !w.document ) {\n\t\t\t\t\tthrow new Error( \"jQuery requires a window with a document\" );\n\t\t\t\t}\n\t\t\t\treturn factory( w );\n\t\t\t};\n\t} else {\n\t\tfactory( global );\n\t}\n\n// Pass this if window is not defined yet\n}(typeof window !== \"undefined\" ? window : this, function( window, noGlobal ) {\n\n// Support: Firefox 18+\n// Can't be in strict mode, several libs including ASP.NET trace\n// the stack via arguments.caller.callee and Firefox dies if\n// you try to trace through \"use strict\" call chains. (#13335)\n//\"use strict\";\n\tvar deletedIds = [];\n\n\tvar document = window.document;\n\n\tvar slice = deletedIds.slice;\n\n\tvar concat = deletedIds.concat;\n\n\tvar push = deletedIds.push;\n\n\tvar indexOf = deletedIds.indexOf;\n\n\tvar class2type = {};\n\n\tvar toString = class2type.toString;\n\n\tvar hasOwn = class2type.hasOwnProperty;\n\n\tvar support = {};\n\n\n\n\tvar\n\t\tversion = \"1.12.4\",\n\n\t\t// Define a local copy of jQuery\n\t\tjQuery = function( selector, context ) {\n\n\t\t\t// The jQuery object is actually just the init constructor 'enhanced'\n\t\t\t// Need init if jQuery is called (just allow error to be thrown if not included)\n\t\t\treturn new jQuery.fn.init( selector, context );\n\t\t},\n\n\t\t// Support: Android<4.1, IE<9\n\t\t// Make sure we trim BOM and NBSP\n\t\trtrim = /^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g,\n\n\t\t// Matches dashed string for camelizing\n\t\trmsPrefix = /^-ms-/,\n\t\trdashAlpha = /-([\\da-z])/gi,\n\n\t\t// Used by jQuery.camelCase as callback to replace()\n\t\tfcamelCase = function( all, letter ) {\n\t\t\treturn letter.toUpperCase();\n\t\t};\n\n\tjQuery.fn = jQuery.prototype = {\n\n\t\t// The current version of jQuery being used\n\t\tjquery: version,\n\n\t\tconstructor: jQuery,\n\n\t\t// Start with an empty selector\n\t\tselector: \"\",\n\n\t\t// The default length of a jQuery object is 0\n\t\tlength: 0,\n\n\t\ttoArray: function() {\n\t\t\treturn slice.call( this );\n\t\t},\n\n\t\t// Get the Nth element in the matched element set OR\n\t\t// Get the whole matched element set as a clean array\n\t\tget: function( num ) {\n\t\t\treturn num != null ?\n\n\t\t\t\t// Return just the one element from the set\n\t\t\t\t( num < 0 ? this[ num + this.length ] : this[ num ] ) :\n\n\t\t\t\t// Return all the elements in a clean array\n\t\t\t\tslice.call( this );\n\t\t},\n\n\t\t// Take an array of elements and push it onto the stack\n\t\t// (returning the new matched element set)\n\t\tpushStack: function( elems ) {\n\n\t\t\t// Build a new jQuery matched element set\n\t\t\tvar ret = jQuery.merge( this.constructor(), elems );\n\n\t\t\t// Add the old object onto the stack (as a reference)\n\t\t\tret.prevObject = this;\n\t\t\tret.context = this.context;\n\n\t\t\t// Return the newly-formed element set\n\t\t\treturn ret;\n\t\t},\n\n\t\t// Execute a callback for every element in the matched set.\n\t\teach: function( callback ) {\n\t\t\treturn jQuery.each( this, callback );\n\t\t},\n\n\t\tmap: function( callback ) {\n\t\t\treturn this.pushStack( jQuery.map( this, function( elem, i ) {\n\t\t\t\treturn callback.call( elem, i, elem );\n\t\t\t} ) );\n\t\t},\n\n\t\tslice: function() {\n\t\t\treturn this.pushStack( slice.apply( this, arguments ) );\n\t\t},\n\n\t\tfirst: function() {\n\t\t\treturn this.eq( 0 );\n\t\t},\n\n\t\tlast: function() {\n\t\t\treturn this.eq( -1 );\n\t\t},\n\n\t\teq: function( i ) {\n\t\t\tvar len = this.length,\n\t\t\t\tj = +i + ( i < 0 ? len : 0 );\n\t\t\treturn this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );\n\t\t},\n\n\t\tend: function() {\n\t\t\treturn this.prevObject || this.constructor();\n\t\t},\n\n\t\t// For internal use only.\n\t\t// Behaves like an Array's method, not like a jQuery method.\n\t\tpush: push,\n\t\tsort: deletedIds.sort,\n\t\tsplice: deletedIds.splice\n\t};\n\n\tjQuery.extend = jQuery.fn.extend = function() {\n\t\tvar src, copyIsArray, copy, name, options, clone,\n\t\t\ttarget = arguments[ 0 ] || {},\n\t\t\ti = 1,\n\t\t\tlength = arguments.length,\n\t\t\tdeep = false;\n\n\t\t// Handle a deep copy situation\n\t\tif ( typeof target === \"boolean\" ) {\n\t\t\tdeep = target;\n\n\t\t\t// skip the boolean and the target\n\t\t\ttarget = arguments[ i ] || {};\n\t\t\ti++;\n\t\t}\n\n\t\t// Handle case when target is a string or something (possible in deep copy)\n\t\tif ( typeof target !== \"object\" && !jQuery.isFunction( target ) ) {\n\t\t\ttarget = {};\n\t\t}\n\n\t\t// extend jQuery itself if only one argument is passed\n\t\tif ( i === length ) {\n\t\t\ttarget = this;\n\t\t\ti--;\n\t\t}\n\n\t\tfor ( ; i < length; i++ ) {\n\n\t\t\t// Only deal with non-null/undefined values\n\t\t\tif ( ( options = arguments[ i ] ) != null ) {\n\n\t\t\t\t// Extend the base object\n\t\t\t\tfor ( name in options ) {\n\t\t\t\t\tsrc = target[ name ];\n\t\t\t\t\tcopy = options[ name ];\n\n\t\t\t\t\t// Prevent never-ending loop\n\t\t\t\t\tif ( target === copy ) {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Recurse if we're merging plain objects or arrays\n\t\t\t\t\tif ( deep && copy && ( jQuery.isPlainObject( copy ) ||\n\t\t\t\t\t\t( copyIsArray = jQuery.isArray( copy ) ) ) ) {\n\n\t\t\t\t\t\tif ( copyIsArray ) {\n\t\t\t\t\t\t\tcopyIsArray = false;\n\t\t\t\t\t\t\tclone = src && jQuery.isArray( src ) ? src : [];\n\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tclone = src && jQuery.isPlainObject( src ) ? src : {};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Never move original objects, clone them\n\t\t\t\t\t\ttarget[ name ] = jQuery.extend( deep, clone, copy );\n\n\t\t\t\t\t\t// Don't bring in undefined values\n\t\t\t\t\t} else if ( copy !== undefined ) {\n\t\t\t\t\t\ttarget[ name ] = copy;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Return the modified object\n\t\treturn target;\n\t};\n\n\tjQuery.extend( {\n\n\t\t// Unique for each copy of jQuery on the page\n\t\texpando: \"jQuery\" + ( version + Math.random() ).replace( /\\D/g, \"\" ),\n\n\t\t// Assume jQuery is ready without the ready module\n\t\tisReady: true,\n\n\t\terror: function( msg ) {\n\t\t\tthrow new Error( msg );\n\t\t},\n\n\t\tnoop: function() {},\n\n\t\t// See test/unit/core.js for details concerning isFunction.\n\t\t// Since version 1.3, DOM methods and functions like alert\n\t\t// aren't supported. They return false on IE (#2968).\n\t\tisFunction: function( obj ) {\n\t\t\treturn jQuery.type( obj ) === \"function\";\n\t\t},\n\n\t\tisArray: Array.isArray || function( obj ) {\n\t\t\treturn jQuery.type( obj ) === \"array\";\n\t\t},\n\n\t\tisWindow: function( obj ) {\n\t\t\t/* jshint eqeqeq: false */\n\t\t\treturn obj != null && obj == obj.window;\n\t\t},\n\n\t\tisNumeric: function( obj ) {\n\n\t\t\t// parseFloat NaNs numeric-cast false positives (null|true|false|\"\")\n\t\t\t// ...but misinterprets leading-number strings, particularly hex literals (\"0x...\")\n\t\t\t// subtraction forces infinities to NaN\n\t\t\t// adding 1 corrects loss of precision from parseFloat (#15100)\n\t\t\tvar realStringObj = obj && obj.toString();\n\t\t\treturn !jQuery.isArray( obj ) && ( realStringObj - parseFloat( realStringObj ) + 1 ) >= 0;\n\t\t},\n\n\t\tisEmptyObject: function( obj ) {\n\t\t\tvar name;\n\t\t\tfor ( name in obj ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\treturn true;\n\t\t},\n\n\t\tisPlainObject: function( obj ) {\n\t\t\tvar key;\n\n\t\t\t// Must be an Object.\n\t\t\t// Because of IE, we also have to check the presence of the constructor property.\n\t\t\t// Make sure that DOM nodes and window objects don't pass through, as well\n\t\t\tif ( !obj || jQuery.type( obj ) !== \"object\" || obj.nodeType || jQuery.isWindow( obj ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\ttry {\n\n\t\t\t\t// Not own constructor property must be Object\n\t\t\t\tif ( obj.constructor &&\n\t\t\t\t\t!hasOwn.call( obj, \"constructor\" ) &&\n\t\t\t\t\t!hasOwn.call( obj.constructor.prototype, \"isPrototypeOf\" ) ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t} catch ( e ) {\n\n\t\t\t\t// IE8,9 Will throw exceptions on certain host objects #9897\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// Handle iteration over inherited properties before own properties.\n\t\t\tif ( !support.ownFirst ) {\n\t\t\t\tfor ( key in obj ) {\n\t\t\t\t\treturn hasOwn.call( obj, key );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Own properties are enumerated firstly, so to speed up,\n\t\t\t// if last one is own, then all properties are own.\n\t\t\tfor ( key in obj ) {}\n\n\t\t\treturn key === undefined || hasOwn.call( obj, key );\n\t\t},\n\n\t\ttype: function( obj ) {\n\t\t\tif ( obj == null ) {\n\t\t\t\treturn obj + \"\";\n\t\t\t}\n\t\t\treturn typeof obj === \"object\" || typeof obj === \"function\" ?\n\t\t\tclass2type[ toString.call( obj ) ] || \"object\" :\n\t\t\t\ttypeof obj;\n\t\t},\n\n\t\t// Workarounds based on findings by Jim Driscoll\n\t\t// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context\n\t\tglobalEval: function( data ) {\n\t\t\tif ( data && jQuery.trim( data ) ) {\n\n\t\t\t\t// We use execScript on Internet Explorer\n\t\t\t\t// We use an anonymous function so that context is window\n\t\t\t\t// rather than jQuery in Firefox\n\t\t\t\t( window.execScript || function( data ) {\n\t\t\t\t\twindow[ \"eval\" ].call( window, data ); // jscs:ignore requireDotNotation\n\t\t\t\t} )( data );\n\t\t\t}\n\t\t},\n\n\t\t// Convert dashed to camelCase; used by the css and data modules\n\t\t// Microsoft forgot to hump their vendor prefix (#9572)\n\t\tcamelCase: function( string ) {\n\t\t\treturn string.replace( rmsPrefix, \"ms-\" ).replace( rdashAlpha, fcamelCase );\n\t\t},\n\n\t\tnodeName: function( elem, name ) {\n\t\t\treturn elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();\n\t\t},\n\n\t\teach: function( obj, callback ) {\n\t\t\tvar length, i = 0;\n\n\t\t\tif ( isArrayLike( obj ) ) {\n\t\t\t\tlength = obj.length;\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tif ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( i in obj ) {\n\t\t\t\t\tif ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn obj;\n\t\t},\n\n\t\t// Support: Android<4.1, IE<9\n\t\ttrim: function( text ) {\n\t\t\treturn text == null ?\n\t\t\t\t\"\" :\n\t\t\t\t( text + \"\" ).replace( rtrim, \"\" );\n\t\t},\n\n\t\t// results is for internal usage only\n\t\tmakeArray: function( arr, results ) {\n\t\t\tvar ret = results || [];\n\n\t\t\tif ( arr != null ) {\n\t\t\t\tif ( isArrayLike( Object( arr ) ) ) {\n\t\t\t\t\tjQuery.merge( ret,\n\t\t\t\t\t\ttypeof arr === \"string\" ?\n\t\t\t\t\t\t\t[ arr ] : arr\n\t\t\t\t\t);\n\t\t\t\t} else {\n\t\t\t\t\tpush.call( ret, arr );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn ret;\n\t\t},\n\n\t\tinArray: function( elem, arr, i ) {\n\t\t\tvar len;\n\n\t\t\tif ( arr ) {\n\t\t\t\tif ( indexOf ) {\n\t\t\t\t\treturn indexOf.call( arr, elem, i );\n\t\t\t\t}\n\n\t\t\t\tlen = arr.length;\n\t\t\t\ti = i ? i < 0 ? Math.max( 0, len + i ) : i : 0;\n\n\t\t\t\tfor ( ; i < len; i++ ) {\n\n\t\t\t\t\t// Skip accessing in sparse arrays\n\t\t\t\t\tif ( i in arr && arr[ i ] === elem ) {\n\t\t\t\t\t\treturn i;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn -1;\n\t\t},\n\n\t\tmerge: function( first, second ) {\n\t\t\tvar len = +second.length,\n\t\t\t\tj = 0,\n\t\t\t\ti = first.length;\n\n\t\t\twhile ( j < len ) {\n\t\t\t\tfirst[ i++ ] = second[ j++ ];\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// Workaround casting of .length to NaN on otherwise arraylike objects (e.g., NodeLists)\n\t\t\tif ( len !== len ) {\n\t\t\t\twhile ( second[ j ] !== undefined ) {\n\t\t\t\t\tfirst[ i++ ] = second[ j++ ];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfirst.length = i;\n\n\t\t\treturn first;\n\t\t},\n\n\t\tgrep: function( elems, callback, invert ) {\n\t\t\tvar callbackInverse,\n\t\t\t\tmatches = [],\n\t\t\t\ti = 0,\n\t\t\t\tlength = elems.length,\n\t\t\t\tcallbackExpect = !invert;\n\n\t\t\t// Go through the array, only saving the items\n\t\t\t// that pass the validator function\n\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\tcallbackInverse = !callback( elems[ i ], i );\n\t\t\t\tif ( callbackInverse !== callbackExpect ) {\n\t\t\t\t\tmatches.push( elems[ i ] );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn matches;\n\t\t},\n\n\t\t// arg is for internal usage only\n\t\tmap: function( elems, callback, arg ) {\n\t\t\tvar length, value,\n\t\t\t\ti = 0,\n\t\t\t\tret = [];\n\n\t\t\t// Go through the array, translating each of the items to their new values\n\t\t\tif ( isArrayLike( elems ) ) {\n\t\t\t\tlength = elems.length;\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tvalue = callback( elems[ i ], i, arg );\n\n\t\t\t\t\tif ( value != null ) {\n\t\t\t\t\t\tret.push( value );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Go through every key on the object,\n\t\t\t} else {\n\t\t\t\tfor ( i in elems ) {\n\t\t\t\t\tvalue = callback( elems[ i ], i, arg );\n\n\t\t\t\t\tif ( value != null ) {\n\t\t\t\t\t\tret.push( value );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Flatten any nested arrays\n\t\t\treturn concat.apply( [], ret );\n\t\t},\n\n\t\t// A global GUID counter for objects\n\t\tguid: 1,\n\n\t\t// Bind a function to a context, optionally partially applying any\n\t\t// arguments.\n\t\tproxy: function( fn, context ) {\n\t\t\tvar args, proxy, tmp;\n\n\t\t\tif ( typeof context === \"string\" ) {\n\t\t\t\ttmp = fn[ context ];\n\t\t\t\tcontext = fn;\n\t\t\t\tfn = tmp;\n\t\t\t}\n\n\t\t\t// Quick check to determine if target is callable, in the spec\n\t\t\t// this throws a TypeError, but we will just return undefined.\n\t\t\tif ( !jQuery.isFunction( fn ) ) {\n\t\t\t\treturn undefined;\n\t\t\t}\n\n\t\t\t// Simulated bind\n\t\t\targs = slice.call( arguments, 2 );\n\t\t\tproxy = function() {\n\t\t\t\treturn fn.apply( context || this, args.concat( slice.call( arguments ) ) );\n\t\t\t};\n\n\t\t\t// Set the guid of unique handler to the same of original handler, so it can be removed\n\t\t\tproxy.guid = fn.guid = fn.guid || jQuery.guid++;\n\n\t\t\treturn proxy;\n\t\t},\n\n\t\tnow: function() {\n\t\t\treturn +( new Date() );\n\t\t},\n\n\t\t// jQuery.support is not used in Core but other projects attach their\n\t\t// properties to it so it needs to exist.\n\t\tsupport: support\n\t} );\n\n// JSHint would error on this code due to the Symbol not being defined in ES5.\n// Defining this global in .jshintrc would create a danger of using the global\n// unguarded in another place, it seems safer to just disable JSHint for these\n// three lines.\n\t/* jshint ignore: start */\n\tif ( typeof Symbol === \"function\" ) {\n\t\tjQuery.fn[ Symbol.iterator ] = deletedIds[ Symbol.iterator ];\n\t}\n\t/* jshint ignore: end */\n\n// Populate the class2type map\n\tjQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".split( \" \" ),\n\t\tfunction( i, name ) {\n\t\t\tclass2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n\t\t} );\n\n\tfunction isArrayLike( obj ) {\n\n\t\t// Support: iOS 8.2 (not reproducible in simulator)\n\t\t// `in` check used to prevent JIT error (gh-2145)\n\t\t// hasOwn isn't used here due to false negatives\n\t\t// regarding Nodelist length in IE\n\t\tvar length = !!obj && \"length\" in obj && obj.length,\n\t\t\ttype = jQuery.type( obj );\n\n\t\tif ( type === \"function\" || jQuery.isWindow( obj ) ) {\n\t\t\treturn false;\n\t\t}\n\n\t\treturn type === \"array\" || length === 0 ||\n\t\t\ttypeof length === \"number\" && length > 0 && ( length - 1 ) in obj;\n\t}\n\tvar Sizzle =\n\t\t/*!\n\t\t * Sizzle CSS Selector Engine v2.2.1\n\t\t * http://sizzlejs.com/\n\t\t *\n\t\t * Copyright jQuery Foundation and other contributors\n\t\t * Released under the MIT license\n\t\t * http://jquery.org/license\n\t\t *\n\t\t * Date: 2015-10-17\n\t\t */\n\t\t(function( window ) {\n\n\t\t\tvar i,\n\t\t\t\tsupport,\n\t\t\t\tExpr,\n\t\t\t\tgetText,\n\t\t\t\tisXML,\n\t\t\t\ttokenize,\n\t\t\t\tcompile,\n\t\t\t\tselect,\n\t\t\t\toutermostContext,\n\t\t\t\tsortInput,\n\t\t\t\thasDuplicate,\n\n\t\t\t\t// Local document vars\n\t\t\t\tsetDocument,\n\t\t\t\tdocument,\n\t\t\t\tdocElem,\n\t\t\t\tdocumentIsHTML,\n\t\t\t\trbuggyQSA,\n\t\t\t\trbuggyMatches,\n\t\t\t\tmatches,\n\t\t\t\tcontains,\n\n\t\t\t\t// Instance-specific data\n\t\t\t\texpando = \"sizzle\" + 1 * new Date(),\n\t\t\t\tpreferredDoc = window.document,\n\t\t\t\tdirruns = 0,\n\t\t\t\tdone = 0,\n\t\t\t\tclassCache = createCache(),\n\t\t\t\ttokenCache = createCache(),\n\t\t\t\tcompilerCache = createCache(),\n\t\t\t\tsortOrder = function( a, b ) {\n\t\t\t\t\tif ( a === b ) {\n\t\t\t\t\t\thasDuplicate = true;\n\t\t\t\t\t}\n\t\t\t\t\treturn 0;\n\t\t\t\t},\n\n\t\t\t\t// General-purpose constants\n\t\t\t\tMAX_NEGATIVE = 1 << 31,\n\n\t\t\t\t// Instance methods\n\t\t\t\thasOwn = ({}).hasOwnProperty,\n\t\t\t\tarr = [],\n\t\t\t\tpop = arr.pop,\n\t\t\t\tpush_native = arr.push,\n\t\t\t\tpush = arr.push,\n\t\t\t\tslice = arr.slice,\n\t\t\t\t// Use a stripped-down indexOf as it's faster than native\n\t\t\t\t// http://jsperf.com/thor-indexof-vs-for/5\n\t\t\t\tindexOf = function( list, elem ) {\n\t\t\t\t\tvar i = 0,\n\t\t\t\t\t\tlen = list.length;\n\t\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\t\tif ( list[i] === elem ) {\n\t\t\t\t\t\t\treturn i;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn -1;\n\t\t\t\t},\n\n\t\t\t\tbooleans = \"checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped\",\n\n\t\t\t\t// Regular expressions\n\n\t\t\t\t// http://www.w3.org/TR/css3-selectors/#whitespace\n\t\t\t\twhitespace = \"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\",\n\n\t\t\t\t// http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier\n\t\t\t\tidentifier = \"(?:\\\\\\\\.|[\\\\w-]|[^\\\\x00-\\\\xa0])+\",\n\n\t\t\t\t// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors\n\t\t\t\tattributes = \"\\\\[\" + whitespace + \"*(\" + identifier + \")(?:\" + whitespace +\n\t\t\t\t\t// Operator (capture 2)\n\t\t\t\t\t\"*([*^$|!~]?=)\" + whitespace +\n\t\t\t\t\t// \"Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]\"\n\t\t\t\t\t\"*(?:'((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\"|(\" + identifier + \"))|)\" + whitespace +\n\t\t\t\t\t\"*\\\\]\",\n\n\t\t\t\tpseudos = \":(\" + identifier + \")(?:\\\\((\" +\n\t\t\t\t\t// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:\n\t\t\t\t\t// 1. quoted (capture 3; capture 4 or capture 5)\n\t\t\t\t\t\"('((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\")|\" +\n\t\t\t\t\t// 2. simple (capture 6)\n\t\t\t\t\t\"((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\" + attributes + \")*)|\" +\n\t\t\t\t\t// 3. anything else (capture 2)\n\t\t\t\t\t\".*\" +\n\t\t\t\t\t\")\\\\)|)\",\n\n\t\t\t\t// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter\n\t\t\t\trwhitespace = new RegExp( whitespace + \"+\", \"g\" ),\n\t\t\t\trtrim = new RegExp( \"^\" + whitespace + \"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\" + whitespace + \"+$\", \"g\" ),\n\n\t\t\t\trcomma = new RegExp( \"^\" + whitespace + \"*,\" + whitespace + \"*\" ),\n\t\t\t\trcombinators = new RegExp( \"^\" + whitespace + \"*([>+~]|\" + whitespace + \")\" + whitespace + \"*\" ),\n\n\t\t\t\trattributeQuotes = new RegExp( \"=\" + whitespace + \"*([^\\\\]'\\\"]*?)\" + whitespace + \"*\\\\]\", \"g\" ),\n\n\t\t\t\trpseudo = new RegExp( pseudos ),\n\t\t\t\tridentifier = new RegExp( \"^\" + identifier + \"$\" ),\n\n\t\t\t\tmatchExpr = {\n\t\t\t\t\t\"ID\": new RegExp( \"^#(\" + identifier + \")\" ),\n\t\t\t\t\t\"CLASS\": new RegExp( \"^\\\\.(\" + identifier + \")\" ),\n\t\t\t\t\t\"TAG\": new RegExp( \"^(\" + identifier + \"|[*])\" ),\n\t\t\t\t\t\"ATTR\": new RegExp( \"^\" + attributes ),\n\t\t\t\t\t\"PSEUDO\": new RegExp( \"^\" + pseudos ),\n\t\t\t\t\t\"CHILD\": new RegExp( \"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\" + whitespace +\n\t\t\t\t\t\t\"*(even|odd|(([+-]|)(\\\\d*)n|)\" + whitespace + \"*(?:([+-]|)\" + whitespace +\n\t\t\t\t\t\t\"*(\\\\d+)|))\" + whitespace + \"*\\\\)|)\", \"i\" ),\n\t\t\t\t\t\"bool\": new RegExp( \"^(?:\" + booleans + \")$\", \"i\" ),\n\t\t\t\t\t// For use in libraries implementing .is()\n\t\t\t\t\t// We use this for POS matching in `select`\n\t\t\t\t\t\"needsContext\": new RegExp( \"^\" + whitespace + \"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\" +\n\t\t\t\t\t\twhitespace + \"*((?:-\\\\d)?\\\\d*)\" + whitespace + \"*\\\\)|)(?=[^-]|$)\", \"i\" )\n\t\t\t\t},\n\n\t\t\t\trinputs = /^(?:input|select|textarea|button)$/i,\n\t\t\t\trheader = /^h\\d$/i,\n\n\t\t\t\trnative = /^[^{]+\\{\\s*\\[native \\w/,\n\n\t\t\t\t// Easily-parseable/retrievable ID or TAG or CLASS selectors\n\t\t\t\trquickExpr = /^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,\n\n\t\t\t\trsibling = /[+~]/,\n\t\t\t\trescape = /'|\\\\/g,\n\n\t\t\t\t// CSS escapes http://www.w3.org/TR/CSS21/syndata.html#escaped-characters\n\t\t\t\trunescape = new RegExp( \"\\\\\\\\([\\\\da-f]{1,6}\" + whitespace + \"?|(\" + whitespace + \")|.)\", \"ig\" ),\n\t\t\t\tfunescape = function( _, escaped, escapedWhitespace ) {\n\t\t\t\t\tvar high = \"0x\" + escaped - 0x10000;\n\t\t\t\t\t// NaN means non-codepoint\n\t\t\t\t\t// Support: Firefox<24\n\t\t\t\t\t// Workaround erroneous numeric interpretation of +\"0x\"\n\t\t\t\t\treturn high !== high || escapedWhitespace ?\n\t\t\t\t\t\tescaped :\n\t\t\t\t\t\thigh < 0 ?\n\t\t\t\t\t\t\t// BMP codepoint\n\t\t\t\t\t\t\tString.fromCharCode( high + 0x10000 ) :\n\t\t\t\t\t\t\t// Supplemental Plane codepoint (surrogate pair)\n\t\t\t\t\t\t\tString.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );\n\t\t\t\t},\n\n\t\t\t\t// Used for iframes\n\t\t\t\t// See setDocument()\n\t\t\t\t// Removing the function wrapper causes a \"Permission Denied\"\n\t\t\t\t// error in IE\n\t\t\t\tunloadHandler = function() {\n\t\t\t\t\tsetDocument();\n\t\t\t\t};\n\n// Optimize for push.apply( _, NodeList )\n\t\t\ttry {\n\t\t\t\tpush.apply(\n\t\t\t\t\t(arr = slice.call( preferredDoc.childNodes )),\n\t\t\t\t\tpreferredDoc.childNodes\n\t\t\t\t);\n\t\t\t\t// Support: Android<4.0\n\t\t\t\t// Detect silently failing push.apply\n\t\t\t\tarr[ preferredDoc.childNodes.length ].nodeType;\n\t\t\t} catch ( e ) {\n\t\t\t\tpush = { apply: arr.length ?\n\n\t\t\t\t\t// Leverage slice if possible\n\t\t\t\t\tfunction( target, els ) {\n\t\t\t\t\t\tpush_native.apply( target, slice.call(els) );\n\t\t\t\t\t} :\n\n\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t// Otherwise append directly\n\t\t\t\t\tfunction( target, els ) {\n\t\t\t\t\t\tvar j = target.length,\n\t\t\t\t\t\t\ti = 0;\n\t\t\t\t\t\t// Can't trust NodeList.length\n\t\t\t\t\t\twhile ( (target[j++] = els[i++]) ) {}\n\t\t\t\t\t\ttarget.length = j - 1;\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tfunction Sizzle( selector, context, results, seed ) {\n\t\t\t\tvar m, i, elem, nid, nidselect, match, groups, newSelector,\n\t\t\t\t\tnewContext = context && context.ownerDocument,\n\n\t\t\t\t\t// nodeType defaults to 9, since context defaults to document\n\t\t\t\t\tnodeType = context ? context.nodeType : 9;\n\n\t\t\t\tresults = results || [];\n\n\t\t\t\t// Return early from calls with invalid selector or context\n\t\t\t\tif ( typeof selector !== \"string\" || !selector ||\n\t\t\t\t\tnodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {\n\n\t\t\t\t\treturn results;\n\t\t\t\t}\n\n\t\t\t\t// Try to shortcut find operations (as opposed to filters) in HTML documents\n\t\t\t\tif ( !seed ) {\n\n\t\t\t\t\tif ( ( context ? context.ownerDocument || context : preferredDoc ) !== document ) {\n\t\t\t\t\t\tsetDocument( context );\n\t\t\t\t\t}\n\t\t\t\t\tcontext = context || document;\n\n\t\t\t\t\tif ( documentIsHTML ) {\n\n\t\t\t\t\t\t// If the selector is sufficiently simple, try using a \"get*By*\" DOM method\n\t\t\t\t\t\t// (excepting DocumentFragment context, where the methods don't exist)\n\t\t\t\t\t\tif ( nodeType !== 11 && (match = rquickExpr.exec( selector )) ) {\n\n\t\t\t\t\t\t\t// ID selector\n\t\t\t\t\t\t\tif ( (m = match[1]) ) {\n\n\t\t\t\t\t\t\t\t// Document context\n\t\t\t\t\t\t\t\tif ( nodeType === 9 ) {\n\t\t\t\t\t\t\t\t\tif ( (elem = context.getElementById( m )) ) {\n\n\t\t\t\t\t\t\t\t\t\t// Support: IE, Opera, Webkit\n\t\t\t\t\t\t\t\t\t\t// TODO: identify versions\n\t\t\t\t\t\t\t\t\t\t// getElementById can match elements by name instead of ID\n\t\t\t\t\t\t\t\t\t\tif ( elem.id === m ) {\n\t\t\t\t\t\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Element context\n\t\t\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\t\t\t// Support: IE, Opera, Webkit\n\t\t\t\t\t\t\t\t\t// TODO: identify versions\n\t\t\t\t\t\t\t\t\t// getElementById can match elements by name instead of ID\n\t\t\t\t\t\t\t\t\tif ( newContext && (elem = newContext.getElementById( m )) &&\n\t\t\t\t\t\t\t\t\t\tcontains( context, elem ) &&\n\t\t\t\t\t\t\t\t\t\telem.id === m ) {\n\n\t\t\t\t\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Type selector\n\t\t\t\t\t\t\t} else if ( match[2] ) {\n\t\t\t\t\t\t\t\tpush.apply( results, context.getElementsByTagName( selector ) );\n\t\t\t\t\t\t\t\treturn results;\n\n\t\t\t\t\t\t\t\t// Class selector\n\t\t\t\t\t\t\t} else if ( (m = match[3]) && support.getElementsByClassName &&\n\t\t\t\t\t\t\t\tcontext.getElementsByClassName ) {\n\n\t\t\t\t\t\t\t\tpush.apply( results, context.getElementsByClassName( m ) );\n\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Take advantage of querySelectorAll\n\t\t\t\t\t\tif ( support.qsa &&\n\t\t\t\t\t\t\t!compilerCache[ selector + \" \" ] &&\n\t\t\t\t\t\t\t(!rbuggyQSA || !rbuggyQSA.test( selector )) ) {\n\n\t\t\t\t\t\t\tif ( nodeType !== 1 ) {\n\t\t\t\t\t\t\t\tnewContext = context;\n\t\t\t\t\t\t\t\tnewSelector = selector;\n\n\t\t\t\t\t\t\t\t// qSA looks outside Element context, which is not what we want\n\t\t\t\t\t\t\t\t// Thanks to Andrew Dupont for this workaround technique\n\t\t\t\t\t\t\t\t// Support: IE <=8\n\t\t\t\t\t\t\t\t// Exclude object elements\n\t\t\t\t\t\t\t} else if ( context.nodeName.toLowerCase() !== \"object\" ) {\n\n\t\t\t\t\t\t\t\t// Capture the context ID, setting it first if necessary\n\t\t\t\t\t\t\t\tif ( (nid = context.getAttribute( \"id\" )) ) {\n\t\t\t\t\t\t\t\t\tnid = nid.replace( rescape, \"\\\\$&\" );\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tcontext.setAttribute( \"id\", (nid = expando) );\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Prefix every selector in the list\n\t\t\t\t\t\t\t\tgroups = tokenize( selector );\n\t\t\t\t\t\t\t\ti = groups.length;\n\t\t\t\t\t\t\t\tnidselect = ridentifier.test( nid ) ? \"#\" + nid : \"[id='\" + nid + \"']\";\n\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\tgroups[i] = nidselect + \" \" + toSelector( groups[i] );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tnewSelector = groups.join( \",\" );\n\n\t\t\t\t\t\t\t\t// Expand context for sibling selectors\n\t\t\t\t\t\t\t\tnewContext = rsibling.test( selector ) && testContext( context.parentNode ) ||\n\t\t\t\t\t\t\t\t\tcontext;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif ( newSelector ) {\n\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\tpush.apply( results,\n\t\t\t\t\t\t\t\t\t\tnewContext.querySelectorAll( newSelector )\n\t\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t} catch ( qsaError ) {\n\t\t\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\t\t\tif ( nid === expando ) {\n\t\t\t\t\t\t\t\t\t\tcontext.removeAttribute( \"id\" );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// All others\n\t\t\t\treturn select( selector.replace( rtrim, \"$1\" ), context, results, seed );\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Create key-value caches of limited size\n\t\t\t * @returns {function(string, object)} Returns the Object data after storing it on itself with\n\t\t\t *\tproperty name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)\n\t\t\t *\tdeleting the oldest entry\n\t\t\t */\n\t\t\tfunction createCache() {\n\t\t\t\tvar keys = [];\n\n\t\t\t\tfunction cache( key, value ) {\n\t\t\t\t\t// Use (key + \" \") to avoid collision with native prototype properties (see Issue #157)\n\t\t\t\t\tif ( keys.push( key + \" \" ) > Expr.cacheLength ) {\n\t\t\t\t\t\t// Only keep the most recent entries\n\t\t\t\t\t\tdelete cache[ keys.shift() ];\n\t\t\t\t\t}\n\t\t\t\t\treturn (cache[ key + \" \" ] = value);\n\t\t\t\t}\n\t\t\t\treturn cache;\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Mark a function for special use by Sizzle\n\t\t\t * @param {Function} fn The function to mark\n\t\t\t */\n\t\t\tfunction markFunction( fn ) {\n\t\t\t\tfn[ expando ] = true;\n\t\t\t\treturn fn;\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Support testing using an element\n\t\t\t * @param {Function} fn Passed the created div and expects a boolean result\n\t\t\t */\n\t\t\tfunction assert( fn ) {\n\t\t\t\tvar div = document.createElement(\"div\");\n\n\t\t\t\ttry {\n\t\t\t\t\treturn !!fn( div );\n\t\t\t\t} catch (e) {\n\t\t\t\t\treturn false;\n\t\t\t\t} finally {\n\t\t\t\t\t// Remove from its parent by default\n\t\t\t\t\tif ( div.parentNode ) {\n\t\t\t\t\t\tdiv.parentNode.removeChild( div );\n\t\t\t\t\t}\n\t\t\t\t\t// release memory in IE\n\t\t\t\t\tdiv = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Adds the same handler for all of the specified attrs\n\t\t\t * @param {String} attrs Pipe-separated list of attributes\n\t\t\t * @param {Function} handler The method that will be applied\n\t\t\t */\n\t\t\tfunction addHandle( attrs, handler ) {\n\t\t\t\tvar arr = attrs.split(\"|\"),\n\t\t\t\t\ti = arr.length;\n\n\t\t\t\twhile ( i-- ) {\n\t\t\t\t\tExpr.attrHandle[ arr[i] ] = handler;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Checks document order of two siblings\n\t\t\t * @param {Element} a\n\t\t\t * @param {Element} b\n\t\t\t * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b\n\t\t\t */\n\t\t\tfunction siblingCheck( a, b ) {\n\t\t\t\tvar cur = b && a,\n\t\t\t\t\tdiff = cur && a.nodeType === 1 && b.nodeType === 1 &&\n\t\t\t\t\t\t( ~b.sourceIndex || MAX_NEGATIVE ) -\n\t\t\t\t\t\t( ~a.sourceIndex || MAX_NEGATIVE );\n\n\t\t\t\t// Use IE sourceIndex if available on both nodes\n\t\t\t\tif ( diff ) {\n\t\t\t\t\treturn diff;\n\t\t\t\t}\n\n\t\t\t\t// Check if b follows a\n\t\t\t\tif ( cur ) {\n\t\t\t\t\twhile ( (cur = cur.nextSibling) ) {\n\t\t\t\t\t\tif ( cur === b ) {\n\t\t\t\t\t\t\treturn -1;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn a ? 1 : -1;\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Returns a function to use in pseudos for input types\n\t\t\t * @param {String} type\n\t\t\t */\n\t\t\tfunction createInputPseudo( type ) {\n\t\t\t\treturn function( elem ) {\n\t\t\t\t\tvar name = elem.nodeName.toLowerCase();\n\t\t\t\t\treturn name === \"input\" && elem.type === type;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Returns a function to use in pseudos for buttons\n\t\t\t * @param {String} type\n\t\t\t */\n\t\t\tfunction createButtonPseudo( type ) {\n\t\t\t\treturn function( elem ) {\n\t\t\t\t\tvar name = elem.nodeName.toLowerCase();\n\t\t\t\t\treturn (name === \"input\" || name === \"button\") && elem.type === type;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Returns a function to use in pseudos for positionals\n\t\t\t * @param {Function} fn\n\t\t\t */\n\t\t\tfunction createPositionalPseudo( fn ) {\n\t\t\t\treturn markFunction(function( argument ) {\n\t\t\t\t\targument = +argument;\n\t\t\t\t\treturn markFunction(function( seed, matches ) {\n\t\t\t\t\t\tvar j,\n\t\t\t\t\t\t\tmatchIndexes = fn( [], seed.length, argument ),\n\t\t\t\t\t\t\ti = matchIndexes.length;\n\n\t\t\t\t\t\t// Match elements found at the specified indexes\n\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\tif ( seed[ (j = matchIndexes[i]) ] ) {\n\t\t\t\t\t\t\t\tseed[j] = !(matches[j] = seed[j]);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Checks a node for validity as a Sizzle context\n\t\t\t * @param {Element|Object=} context\n\t\t\t * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value\n\t\t\t */\n\t\t\tfunction testContext( context ) {\n\t\t\t\treturn context && typeof context.getElementsByTagName !== \"undefined\" && context;\n\t\t\t}\n\n// Expose support vars for convenience\n\t\t\tsupport = Sizzle.support = {};\n\n\t\t\t/**\n\t\t\t * Detects XML nodes\n\t\t\t * @param {Element|Object} elem An element or a document\n\t\t\t * @returns {Boolean} True iff elem is a non-HTML XML node\n\t\t\t */\n\t\t\tisXML = Sizzle.isXML = function( elem ) {\n\t\t\t\t// documentElement is verified for cases where it doesn't yet exist\n\t\t\t\t// (such as loading iframes in IE - #4833)\n\t\t\t\tvar documentElement = elem && (elem.ownerDocument || elem).documentElement;\n\t\t\t\treturn documentElement ? documentElement.nodeName !== \"HTML\" : false;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Sets document-related variables once based on the current document\n\t\t\t * @param {Element|Object} [doc] An element or document object to use to set the document\n\t\t\t * @returns {Object} Returns the current document\n\t\t\t */\n\t\t\tsetDocument = Sizzle.setDocument = function( node ) {\n\t\t\t\tvar hasCompare, parent,\n\t\t\t\t\tdoc = node ? node.ownerDocument || node : preferredDoc;\n\n\t\t\t\t// Return early if doc is invalid or already selected\n\t\t\t\tif ( doc === document || doc.nodeType !== 9 || !doc.documentElement ) {\n\t\t\t\t\treturn document;\n\t\t\t\t}\n\n\t\t\t\t// Update global variables\n\t\t\t\tdocument = doc;\n\t\t\t\tdocElem = document.documentElement;\n\t\t\t\tdocumentIsHTML = !isXML( document );\n\n\t\t\t\t// Support: IE 9-11, Edge\n\t\t\t\t// Accessing iframe documents after unload throws \"permission denied\" errors (jQuery #13936)\n\t\t\t\tif ( (parent = document.defaultView) && parent.top !== parent ) {\n\t\t\t\t\t// Support: IE 11\n\t\t\t\t\tif ( parent.addEventListener ) {\n\t\t\t\t\t\tparent.addEventListener( \"unload\", unloadHandler, false );\n\n\t\t\t\t\t\t// Support: IE 9 - 10 only\n\t\t\t\t\t} else if ( parent.attachEvent ) {\n\t\t\t\t\t\tparent.attachEvent( \"onunload\", unloadHandler );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t/* Attributes\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// Support: IE<8\n\t\t\t\t// Verify that getAttribute really returns attributes and not properties\n\t\t\t\t// (excepting IE8 booleans)\n\t\t\t\tsupport.attributes = assert(function( div ) {\n\t\t\t\t\tdiv.className = \"i\";\n\t\t\t\t\treturn !div.getAttribute(\"className\");\n\t\t\t\t});\n\n\t\t\t\t/* getElement(s)By*\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// Check if getElementsByTagName(\"*\") returns only elements\n\t\t\t\tsupport.getElementsByTagName = assert(function( div ) {\n\t\t\t\t\tdiv.appendChild( document.createComment(\"\") );\n\t\t\t\t\treturn !div.getElementsByTagName(\"*\").length;\n\t\t\t\t});\n\n\t\t\t\t// Support: IE<9\n\t\t\t\tsupport.getElementsByClassName = rnative.test( document.getElementsByClassName );\n\n\t\t\t\t// Support: IE<10\n\t\t\t\t// Check if getElementById returns elements by name\n\t\t\t\t// The broken getElementById methods don't pick up programatically-set names,\n\t\t\t\t// so use a roundabout getElementsByName test\n\t\t\t\tsupport.getById = assert(function( div ) {\n\t\t\t\t\tdocElem.appendChild( div ).id = expando;\n\t\t\t\t\treturn !document.getElementsByName || !document.getElementsByName( expando ).length;\n\t\t\t\t});\n\n\t\t\t\t// ID find and filter\n\t\t\t\tif ( support.getById ) {\n\t\t\t\t\tExpr.find[\"ID\"] = function( id, context ) {\n\t\t\t\t\t\tif ( typeof context.getElementById !== \"undefined\" && documentIsHTML ) {\n\t\t\t\t\t\t\tvar m = context.getElementById( id );\n\t\t\t\t\t\t\treturn m ? [ m ] : [];\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t\tExpr.filter[\"ID\"] = function( id ) {\n\t\t\t\t\t\tvar attrId = id.replace( runescape, funescape );\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\treturn elem.getAttribute(\"id\") === attrId;\n\t\t\t\t\t\t};\n\t\t\t\t\t};\n\t\t\t\t} else {\n\t\t\t\t\t// Support: IE6/7\n\t\t\t\t\t// getElementById is not reliable as a find shortcut\n\t\t\t\t\tdelete Expr.find[\"ID\"];\n\n\t\t\t\t\tExpr.filter[\"ID\"] =  function( id ) {\n\t\t\t\t\t\tvar attrId = id.replace( runescape, funescape );\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\tvar node = typeof elem.getAttributeNode !== \"undefined\" &&\n\t\t\t\t\t\t\t\telem.getAttributeNode(\"id\");\n\t\t\t\t\t\t\treturn node && node.value === attrId;\n\t\t\t\t\t\t};\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t// Tag\n\t\t\t\tExpr.find[\"TAG\"] = support.getElementsByTagName ?\n\t\t\t\t\tfunction( tag, context ) {\n\t\t\t\t\t\tif ( typeof context.getElementsByTagName !== \"undefined\" ) {\n\t\t\t\t\t\t\treturn context.getElementsByTagName( tag );\n\n\t\t\t\t\t\t\t// DocumentFragment nodes don't have gEBTN\n\t\t\t\t\t\t} else if ( support.qsa ) {\n\t\t\t\t\t\t\treturn context.querySelectorAll( tag );\n\t\t\t\t\t\t}\n\t\t\t\t\t} :\n\n\t\t\t\t\tfunction( tag, context ) {\n\t\t\t\t\t\tvar elem,\n\t\t\t\t\t\t\ttmp = [],\n\t\t\t\t\t\t\ti = 0,\n\t\t\t\t\t\t\t// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too\n\t\t\t\t\t\t\tresults = context.getElementsByTagName( tag );\n\n\t\t\t\t\t\t// Filter out possible comments\n\t\t\t\t\t\tif ( tag === \"*\" ) {\n\t\t\t\t\t\t\twhile ( (elem = results[i++]) ) {\n\t\t\t\t\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\t\t\t\t\ttmp.push( elem );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn tmp;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn results;\n\t\t\t\t\t};\n\n\t\t\t\t// Class\n\t\t\t\tExpr.find[\"CLASS\"] = support.getElementsByClassName && function( className, context ) {\n\t\t\t\t\t\tif ( typeof context.getElementsByClassName !== \"undefined\" && documentIsHTML ) {\n\t\t\t\t\t\t\treturn context.getElementsByClassName( className );\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t/* QSA/matchesSelector\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// QSA and matchesSelector support\n\n\t\t\t\t// matchesSelector(:active) reports false when true (IE9/Opera 11.5)\n\t\t\t\trbuggyMatches = [];\n\n\t\t\t\t// qSa(:focus) reports false when true (Chrome 21)\n\t\t\t\t// We allow this because of a bug in IE8/9 that throws an error\n\t\t\t\t// whenever `document.activeElement` is accessed on an iframe\n\t\t\t\t// So, we allow :focus to pass through QSA all the time to avoid the IE error\n\t\t\t\t// See http://bugs.jquery.com/ticket/13378\n\t\t\t\trbuggyQSA = [];\n\n\t\t\t\tif ( (support.qsa = rnative.test( document.querySelectorAll )) ) {\n\t\t\t\t\t// Build QSA regex\n\t\t\t\t\t// Regex strategy adopted from Diego Perini\n\t\t\t\t\tassert(function( div ) {\n\t\t\t\t\t\t// Select is set to empty string on purpose\n\t\t\t\t\t\t// This is to test IE's treatment of not explicitly\n\t\t\t\t\t\t// setting a boolean content attribute,\n\t\t\t\t\t\t// since its presence should be enough\n\t\t\t\t\t\t// http://bugs.jquery.com/ticket/12359\n\t\t\t\t\t\tdocElem.appendChild( div ).innerHTML = \"<a id='\" + expando + \"'></a>\" +\n\t\t\t\t\t\t\t\"<select id='\" + expando + \"-\\r\\\\' msallowcapture=''>\" +\n\t\t\t\t\t\t\t\"<option selected=''></option></select>\";\n\n\t\t\t\t\t\t// Support: IE8, Opera 11-12.16\n\t\t\t\t\t\t// Nothing should be selected when empty strings follow ^= or $= or *=\n\t\t\t\t\t\t// The test attribute must be unknown in Opera but \"safe\" for WinRT\n\t\t\t\t\t\t// http://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section\n\t\t\t\t\t\tif ( div.querySelectorAll(\"[msallowcapture^='']\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \"[*^$]=\" + whitespace + \"*(?:''|\\\"\\\")\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Support: IE8\n\t\t\t\t\t\t// Boolean attributes and \"value\" are not treated correctly\n\t\t\t\t\t\tif ( !div.querySelectorAll(\"[selected]\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \"\\\\[\" + whitespace + \"*(?:value|\" + booleans + \")\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+\n\t\t\t\t\t\tif ( !div.querySelectorAll( \"[id~=\" + expando + \"-]\" ).length ) {\n\t\t\t\t\t\t\trbuggyQSA.push(\"~=\");\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Webkit/Opera - :checked should return selected option elements\n\t\t\t\t\t\t// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked\n\t\t\t\t\t\t// IE8 throws error here and will not see later tests\n\t\t\t\t\t\tif ( !div.querySelectorAll(\":checked\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push(\":checked\");\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Support: Safari 8+, iOS 8+\n\t\t\t\t\t\t// https://bugs.webkit.org/show_bug.cgi?id=136851\n\t\t\t\t\t\t// In-page `selector#id sibing-combinator selector` fails\n\t\t\t\t\t\tif ( !div.querySelectorAll( \"a#\" + expando + \"+*\" ).length ) {\n\t\t\t\t\t\t\trbuggyQSA.push(\".#.+[+~]\");\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\tassert(function( div ) {\n\t\t\t\t\t\t// Support: Windows 8 Native Apps\n\t\t\t\t\t\t// The type and name attributes are restricted during .innerHTML assignment\n\t\t\t\t\t\tvar input = document.createElement(\"input\");\n\t\t\t\t\t\tinput.setAttribute( \"type\", \"hidden\" );\n\t\t\t\t\t\tdiv.appendChild( input ).setAttribute( \"name\", \"D\" );\n\n\t\t\t\t\t\t// Support: IE8\n\t\t\t\t\t\t// Enforce case-sensitivity of name attribute\n\t\t\t\t\t\tif ( div.querySelectorAll(\"[name=d]\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \"name\" + whitespace + \"*[*^$|!~]?=\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)\n\t\t\t\t\t\t// IE8 throws error here and will not see later tests\n\t\t\t\t\t\tif ( !div.querySelectorAll(\":enabled\").length ) {\n\t\t\t\t\t\t\trbuggyQSA.push( \":enabled\", \":disabled\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Opera 10-11 does not throw on post-comma invalid pseudos\n\t\t\t\t\t\tdiv.querySelectorAll(\"*,:x\");\n\t\t\t\t\t\trbuggyQSA.push(\",.*:\");\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif ( (support.matchesSelector = rnative.test( (matches = docElem.matches ||\n\t\t\t\t\t\tdocElem.webkitMatchesSelector ||\n\t\t\t\t\t\tdocElem.mozMatchesSelector ||\n\t\t\t\t\t\tdocElem.oMatchesSelector ||\n\t\t\t\t\t\tdocElem.msMatchesSelector) )) ) {\n\n\t\t\t\t\tassert(function( div ) {\n\t\t\t\t\t\t// Check to see if it's possible to do matchesSelector\n\t\t\t\t\t\t// on a disconnected node (IE 9)\n\t\t\t\t\t\tsupport.disconnectedMatch = matches.call( div, \"div\" );\n\n\t\t\t\t\t\t// This should fail with an exception\n\t\t\t\t\t\t// Gecko does not error, returns false instead\n\t\t\t\t\t\tmatches.call( div, \"[s!='']:x\" );\n\t\t\t\t\t\trbuggyMatches.push( \"!=\", pseudos );\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\trbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join(\"|\") );\n\t\t\t\trbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join(\"|\") );\n\n\t\t\t\t/* Contains\n\t\t\t\t ---------------------------------------------------------------------- */\n\t\t\t\thasCompare = rnative.test( docElem.compareDocumentPosition );\n\n\t\t\t\t// Element contains another\n\t\t\t\t// Purposefully self-exclusive\n\t\t\t\t// As in, an element does not contain itself\n\t\t\t\tcontains = hasCompare || rnative.test( docElem.contains ) ?\n\t\t\t\t\tfunction( a, b ) {\n\t\t\t\t\t\tvar adown = a.nodeType === 9 ? a.documentElement : a,\n\t\t\t\t\t\t\tbup = b && b.parentNode;\n\t\t\t\t\t\treturn a === bup || !!( bup && bup.nodeType === 1 && (\n\t\t\t\t\t\t\t\tadown.contains ?\n\t\t\t\t\t\t\t\t\tadown.contains( bup ) :\n\t\t\t\t\t\t\t\ta.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16\n\t\t\t\t\t\t\t));\n\t\t\t\t\t} :\n\t\t\t\t\tfunction( a, b ) {\n\t\t\t\t\t\tif ( b ) {\n\t\t\t\t\t\t\twhile ( (b = b.parentNode) ) {\n\t\t\t\t\t\t\t\tif ( b === a ) {\n\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t};\n\n\t\t\t\t/* Sorting\n\t\t\t\t ---------------------------------------------------------------------- */\n\n\t\t\t\t// Document order sorting\n\t\t\t\tsortOrder = hasCompare ?\n\t\t\t\t\tfunction( a, b ) {\n\n\t\t\t\t\t\t// Flag for duplicate removal\n\t\t\t\t\t\tif ( a === b ) {\n\t\t\t\t\t\t\thasDuplicate = true;\n\t\t\t\t\t\t\treturn 0;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Sort on method existence if only one input has compareDocumentPosition\n\t\t\t\t\t\tvar compare = !a.compareDocumentPosition - !b.compareDocumentPosition;\n\t\t\t\t\t\tif ( compare ) {\n\t\t\t\t\t\t\treturn compare;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Calculate position if both inputs belong to the same document\n\t\t\t\t\t\tcompare = ( a.ownerDocument || a ) === ( b.ownerDocument || b ) ?\n\t\t\t\t\t\t\ta.compareDocumentPosition( b ) :\n\n\t\t\t\t\t\t\t// Otherwise we know they are disconnected\n\t\t\t\t\t\t\t1;\n\n\t\t\t\t\t\t// Disconnected nodes\n\t\t\t\t\t\tif ( compare & 1 ||\n\t\t\t\t\t\t\t(!support.sortDetached && b.compareDocumentPosition( a ) === compare) ) {\n\n\t\t\t\t\t\t\t// Choose the first element that is related to our preferred document\n\t\t\t\t\t\t\tif ( a === document || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ) {\n\t\t\t\t\t\t\t\treturn -1;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif ( b === document || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ) {\n\t\t\t\t\t\t\t\treturn 1;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Maintain original order\n\t\t\t\t\t\t\treturn sortInput ?\n\t\t\t\t\t\t\t\t( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :\n\t\t\t\t\t\t\t\t0;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn compare & 4 ? -1 : 1;\n\t\t\t\t\t} :\n\t\t\t\t\tfunction( a, b ) {\n\t\t\t\t\t\t// Exit early if the nodes are identical\n\t\t\t\t\t\tif ( a === b ) {\n\t\t\t\t\t\t\thasDuplicate = true;\n\t\t\t\t\t\t\treturn 0;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tvar cur,\n\t\t\t\t\t\t\ti = 0,\n\t\t\t\t\t\t\taup = a.parentNode,\n\t\t\t\t\t\t\tbup = b.parentNode,\n\t\t\t\t\t\t\tap = [ a ],\n\t\t\t\t\t\t\tbp = [ b ];\n\n\t\t\t\t\t\t// Parentless nodes are either documents or disconnected\n\t\t\t\t\t\tif ( !aup || !bup ) {\n\t\t\t\t\t\t\treturn a === document ? -1 :\n\t\t\t\t\t\t\t\tb === document ? 1 :\n\t\t\t\t\t\t\t\t\taup ? -1 :\n\t\t\t\t\t\t\t\t\t\tbup ? 1 :\n\t\t\t\t\t\t\t\t\t\t\tsortInput ?\n\t\t\t\t\t\t\t\t\t\t\t\t( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :\n\t\t\t\t\t\t\t\t\t\t\t\t0;\n\n\t\t\t\t\t\t\t// If the nodes are siblings, we can do a quick check\n\t\t\t\t\t\t} else if ( aup === bup ) {\n\t\t\t\t\t\t\treturn siblingCheck( a, b );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Otherwise we need full lists of their ancestors for comparison\n\t\t\t\t\t\tcur = a;\n\t\t\t\t\t\twhile ( (cur = cur.parentNode) ) {\n\t\t\t\t\t\t\tap.unshift( cur );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tcur = b;\n\t\t\t\t\t\twhile ( (cur = cur.parentNode) ) {\n\t\t\t\t\t\t\tbp.unshift( cur );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Walk down the tree looking for a discrepancy\n\t\t\t\t\t\twhile ( ap[i] === bp[i] ) {\n\t\t\t\t\t\t\ti++;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn i ?\n\t\t\t\t\t\t\t// Do a sibling check if the nodes have a common ancestor\n\t\t\t\t\t\t\tsiblingCheck( ap[i], bp[i] ) :\n\n\t\t\t\t\t\t\t// Otherwise nodes in our document sort first\n\t\t\t\t\t\t\tap[i] === preferredDoc ? -1 :\n\t\t\t\t\t\t\t\tbp[i] === preferredDoc ? 1 :\n\t\t\t\t\t\t\t\t\t0;\n\t\t\t\t\t};\n\n\t\t\t\treturn document;\n\t\t\t};\n\n\t\t\tSizzle.matches = function( expr, elements ) {\n\t\t\t\treturn Sizzle( expr, null, null, elements );\n\t\t\t};\n\n\t\t\tSizzle.matchesSelector = function( elem, expr ) {\n\t\t\t\t// Set document vars if needed\n\t\t\t\tif ( ( elem.ownerDocument || elem ) !== document ) {\n\t\t\t\t\tsetDocument( elem );\n\t\t\t\t}\n\n\t\t\t\t// Make sure that attribute selectors are quoted\n\t\t\t\texpr = expr.replace( rattributeQuotes, \"='$1']\" );\n\n\t\t\t\tif ( support.matchesSelector && documentIsHTML &&\n\t\t\t\t\t!compilerCache[ expr + \" \" ] &&\n\t\t\t\t\t( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&\n\t\t\t\t\t( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\tvar ret = matches.call( elem, expr );\n\n\t\t\t\t\t\t// IE 9's matchesSelector returns false on disconnected nodes\n\t\t\t\t\t\tif ( ret || support.disconnectedMatch ||\n\t\t\t\t\t\t\t// As well, disconnected nodes are said to be in a document\n\t\t\t\t\t\t\t// fragment in IE 9\n\t\t\t\t\t\t\telem.document && elem.document.nodeType !== 11 ) {\n\t\t\t\t\t\t\treturn ret;\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch (e) {}\n\t\t\t\t}\n\n\t\t\t\treturn Sizzle( expr, document, null, [ elem ] ).length > 0;\n\t\t\t};\n\n\t\t\tSizzle.contains = function( context, elem ) {\n\t\t\t\t// Set document vars if needed\n\t\t\t\tif ( ( context.ownerDocument || context ) !== document ) {\n\t\t\t\t\tsetDocument( context );\n\t\t\t\t}\n\t\t\t\treturn contains( context, elem );\n\t\t\t};\n\n\t\t\tSizzle.attr = function( elem, name ) {\n\t\t\t\t// Set document vars if needed\n\t\t\t\tif ( ( elem.ownerDocument || elem ) !== document ) {\n\t\t\t\t\tsetDocument( elem );\n\t\t\t\t}\n\n\t\t\t\tvar fn = Expr.attrHandle[ name.toLowerCase() ],\n\t\t\t\t\t// Don't get fooled by Object.prototype properties (jQuery #13807)\n\t\t\t\t\tval = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?\n\t\t\t\t\t\tfn( elem, name, !documentIsHTML ) :\n\t\t\t\t\t\tundefined;\n\n\t\t\t\treturn val !== undefined ?\n\t\t\t\t\tval :\n\t\t\t\t\tsupport.attributes || !documentIsHTML ?\n\t\t\t\t\t\telem.getAttribute( name ) :\n\t\t\t\t\t\t(val = elem.getAttributeNode(name)) && val.specified ?\n\t\t\t\t\t\t\tval.value :\n\t\t\t\t\t\t\tnull;\n\t\t\t};\n\n\t\t\tSizzle.error = function( msg ) {\n\t\t\t\tthrow new Error( \"Syntax error, unrecognized expression: \" + msg );\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Document sorting and removing duplicates\n\t\t\t * @param {ArrayLike} results\n\t\t\t */\n\t\t\tSizzle.uniqueSort = function( results ) {\n\t\t\t\tvar elem,\n\t\t\t\t\tduplicates = [],\n\t\t\t\t\tj = 0,\n\t\t\t\t\ti = 0;\n\n\t\t\t\t// Unless we *know* we can detect duplicates, assume their presence\n\t\t\t\thasDuplicate = !support.detectDuplicates;\n\t\t\t\tsortInput = !support.sortStable && results.slice( 0 );\n\t\t\t\tresults.sort( sortOrder );\n\n\t\t\t\tif ( hasDuplicate ) {\n\t\t\t\t\twhile ( (elem = results[i++]) ) {\n\t\t\t\t\t\tif ( elem === results[ i ] ) {\n\t\t\t\t\t\t\tj = duplicates.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\twhile ( j-- ) {\n\t\t\t\t\t\tresults.splice( duplicates[ j ], 1 );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Clear input after sorting to release objects\n\t\t\t\t// See https://github.com/jquery/sizzle/pull/225\n\t\t\t\tsortInput = null;\n\n\t\t\t\treturn results;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Utility function for retrieving the text value of an array of DOM nodes\n\t\t\t * @param {Array|Element} elem\n\t\t\t */\n\t\t\tgetText = Sizzle.getText = function( elem ) {\n\t\t\t\tvar node,\n\t\t\t\t\tret = \"\",\n\t\t\t\t\ti = 0,\n\t\t\t\t\tnodeType = elem.nodeType;\n\n\t\t\t\tif ( !nodeType ) {\n\t\t\t\t\t// If no nodeType, this is expected to be an array\n\t\t\t\t\twhile ( (node = elem[i++]) ) {\n\t\t\t\t\t\t// Do not traverse comment nodes\n\t\t\t\t\t\tret += getText( node );\n\t\t\t\t\t}\n\t\t\t\t} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {\n\t\t\t\t\t// Use textContent for elements\n\t\t\t\t\t// innerText usage removed for consistency of new lines (jQuery #11153)\n\t\t\t\t\tif ( typeof elem.textContent === \"string\" ) {\n\t\t\t\t\t\treturn elem.textContent;\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Traverse its children\n\t\t\t\t\t\tfor ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {\n\t\t\t\t\t\t\tret += getText( elem );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} else if ( nodeType === 3 || nodeType === 4 ) {\n\t\t\t\t\treturn elem.nodeValue;\n\t\t\t\t}\n\t\t\t\t// Do not include comment or processing instruction nodes\n\n\t\t\t\treturn ret;\n\t\t\t};\n\n\t\t\tExpr = Sizzle.selectors = {\n\n\t\t\t\t// Can be adjusted by the user\n\t\t\t\tcacheLength: 50,\n\n\t\t\t\tcreatePseudo: markFunction,\n\n\t\t\t\tmatch: matchExpr,\n\n\t\t\t\tattrHandle: {},\n\n\t\t\t\tfind: {},\n\n\t\t\t\trelative: {\n\t\t\t\t\t\">\": { dir: \"parentNode\", first: true },\n\t\t\t\t\t\" \": { dir: \"parentNode\" },\n\t\t\t\t\t\"+\": { dir: \"previousSibling\", first: true },\n\t\t\t\t\t\"~\": { dir: \"previousSibling\" }\n\t\t\t\t},\n\n\t\t\t\tpreFilter: {\n\t\t\t\t\t\"ATTR\": function( match ) {\n\t\t\t\t\t\tmatch[1] = match[1].replace( runescape, funescape );\n\n\t\t\t\t\t\t// Move the given value to match[3] whether quoted or unquoted\n\t\t\t\t\t\tmatch[3] = ( match[3] || match[4] || match[5] || \"\" ).replace( runescape, funescape );\n\n\t\t\t\t\t\tif ( match[2] === \"~=\" ) {\n\t\t\t\t\t\t\tmatch[3] = \" \" + match[3] + \" \";\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn match.slice( 0, 4 );\n\t\t\t\t\t},\n\n\t\t\t\t\t\"CHILD\": function( match ) {\n\t\t\t\t\t\t/* matches from matchExpr[\"CHILD\"]\n\t\t\t\t\t\t 1 type (only|nth|...)\n\t\t\t\t\t\t 2 what (child|of-type)\n\t\t\t\t\t\t 3 argument (even|odd|\\d*|\\d*n([+-]\\d+)?|...)\n\t\t\t\t\t\t 4 xn-component of xn+y argument ([+-]?\\d*n|)\n\t\t\t\t\t\t 5 sign of xn-component\n\t\t\t\t\t\t 6 x of xn-component\n\t\t\t\t\t\t 7 sign of y-component\n\t\t\t\t\t\t 8 y of y-component\n\t\t\t\t\t\t */\n\t\t\t\t\t\tmatch[1] = match[1].toLowerCase();\n\n\t\t\t\t\t\tif ( match[1].slice( 0, 3 ) === \"nth\" ) {\n\t\t\t\t\t\t\t// nth-* requires argument\n\t\t\t\t\t\t\tif ( !match[3] ) {\n\t\t\t\t\t\t\t\tSizzle.error( match[0] );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// numeric x and y parameters for Expr.filter.CHILD\n\t\t\t\t\t\t\t// remember that false/true cast respectively to 0/1\n\t\t\t\t\t\t\tmatch[4] = +( match[4] ? match[5] + (match[6] || 1) : 2 * ( match[3] === \"even\" || match[3] === \"odd\" ) );\n\t\t\t\t\t\t\tmatch[5] = +( ( match[7] + match[8] ) || match[3] === \"odd\" );\n\n\t\t\t\t\t\t\t// other types prohibit arguments\n\t\t\t\t\t\t} else if ( match[3] ) {\n\t\t\t\t\t\t\tSizzle.error( match[0] );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn match;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"PSEUDO\": function( match ) {\n\t\t\t\t\t\tvar excess,\n\t\t\t\t\t\t\tunquoted = !match[6] && match[2];\n\n\t\t\t\t\t\tif ( matchExpr[\"CHILD\"].test( match[0] ) ) {\n\t\t\t\t\t\t\treturn null;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Accept quoted arguments as-is\n\t\t\t\t\t\tif ( match[3] ) {\n\t\t\t\t\t\t\tmatch[2] = match[4] || match[5] || \"\";\n\n\t\t\t\t\t\t\t// Strip excess characters from unquoted arguments\n\t\t\t\t\t\t} else if ( unquoted && rpseudo.test( unquoted ) &&\n\t\t\t\t\t\t\t// Get excess from tokenize (recursively)\n\t\t\t\t\t\t\t(excess = tokenize( unquoted, true )) &&\n\t\t\t\t\t\t\t// advance to the next closing parenthesis\n\t\t\t\t\t\t\t(excess = unquoted.indexOf( \")\", unquoted.length - excess ) - unquoted.length) ) {\n\n\t\t\t\t\t\t\t// excess is a negative index\n\t\t\t\t\t\t\tmatch[0] = match[0].slice( 0, excess );\n\t\t\t\t\t\t\tmatch[2] = unquoted.slice( 0, excess );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Return only captures needed by the pseudo filter method (type and argument)\n\t\t\t\t\t\treturn match.slice( 0, 3 );\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tfilter: {\n\n\t\t\t\t\t\"TAG\": function( nodeNameSelector ) {\n\t\t\t\t\t\tvar nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();\n\t\t\t\t\t\treturn nodeNameSelector === \"*\" ?\n\t\t\t\t\t\t\tfunction() { return true; } :\n\t\t\t\t\t\t\tfunction( elem ) {\n\t\t\t\t\t\t\t\treturn elem.nodeName && elem.nodeName.toLowerCase() === nodeName;\n\t\t\t\t\t\t\t};\n\t\t\t\t\t},\n\n\t\t\t\t\t\"CLASS\": function( className ) {\n\t\t\t\t\t\tvar pattern = classCache[ className + \" \" ];\n\n\t\t\t\t\t\treturn pattern ||\n\t\t\t\t\t\t\t(pattern = new RegExp( \"(^|\" + whitespace + \")\" + className + \"(\" + whitespace + \"|$)\" )) &&\n\t\t\t\t\t\t\tclassCache( className, function( elem ) {\n\t\t\t\t\t\t\t\treturn pattern.test( typeof elem.className === \"string\" && elem.className || typeof elem.getAttribute !== \"undefined\" && elem.getAttribute(\"class\") || \"\" );\n\t\t\t\t\t\t\t});\n\t\t\t\t\t},\n\n\t\t\t\t\t\"ATTR\": function( name, operator, check ) {\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\tvar result = Sizzle.attr( elem, name );\n\n\t\t\t\t\t\t\tif ( result == null ) {\n\t\t\t\t\t\t\t\treturn operator === \"!=\";\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif ( !operator ) {\n\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tresult += \"\";\n\n\t\t\t\t\t\t\treturn operator === \"=\" ? result === check :\n\t\t\t\t\t\t\t\toperator === \"!=\" ? result !== check :\n\t\t\t\t\t\t\t\t\toperator === \"^=\" ? check && result.indexOf( check ) === 0 :\n\t\t\t\t\t\t\t\t\t\toperator === \"*=\" ? check && result.indexOf( check ) > -1 :\n\t\t\t\t\t\t\t\t\t\t\toperator === \"$=\" ? check && result.slice( -check.length ) === check :\n\t\t\t\t\t\t\t\t\t\t\t\toperator === \"~=\" ? ( \" \" + result.replace( rwhitespace, \" \" ) + \" \" ).indexOf( check ) > -1 :\n\t\t\t\t\t\t\t\t\t\t\t\t\toperator === \"|=\" ? result === check || result.slice( 0, check.length + 1 ) === check + \"-\" :\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tfalse;\n\t\t\t\t\t\t};\n\t\t\t\t\t},\n\n\t\t\t\t\t\"CHILD\": function( type, what, argument, first, last ) {\n\t\t\t\t\t\tvar simple = type.slice( 0, 3 ) !== \"nth\",\n\t\t\t\t\t\t\tforward = type.slice( -4 ) !== \"last\",\n\t\t\t\t\t\t\tofType = what === \"of-type\";\n\n\t\t\t\t\t\treturn first === 1 && last === 0 ?\n\n\t\t\t\t\t\t\t// Shortcut for :nth-*(n)\n\t\t\t\t\t\t\tfunction( elem ) {\n\t\t\t\t\t\t\t\treturn !!elem.parentNode;\n\t\t\t\t\t\t\t} :\n\n\t\t\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\t\t\tvar cache, uniqueCache, outerCache, node, nodeIndex, start,\n\t\t\t\t\t\t\t\t\tdir = simple !== forward ? \"nextSibling\" : \"previousSibling\",\n\t\t\t\t\t\t\t\t\tparent = elem.parentNode,\n\t\t\t\t\t\t\t\t\tname = ofType && elem.nodeName.toLowerCase(),\n\t\t\t\t\t\t\t\t\tuseCache = !xml && !ofType,\n\t\t\t\t\t\t\t\t\tdiff = false;\n\n\t\t\t\t\t\t\t\tif ( parent ) {\n\n\t\t\t\t\t\t\t\t\t// :(first|last|only)-(child|of-type)\n\t\t\t\t\t\t\t\t\tif ( simple ) {\n\t\t\t\t\t\t\t\t\t\twhile ( dir ) {\n\t\t\t\t\t\t\t\t\t\t\tnode = elem;\n\t\t\t\t\t\t\t\t\t\t\twhile ( (node = node[ dir ]) ) {\n\t\t\t\t\t\t\t\t\t\t\t\tif ( ofType ?\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeName.toLowerCase() === name :\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeType === 1 ) {\n\n\t\t\t\t\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t// Reverse direction for :only-* (if we haven't yet done so)\n\t\t\t\t\t\t\t\t\t\t\tstart = dir = type === \"only\" && !start && \"nextSibling\";\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\tstart = [ forward ? parent.firstChild : parent.lastChild ];\n\n\t\t\t\t\t\t\t\t\t// non-xml :nth-child(...) stores cache data on `parent`\n\t\t\t\t\t\t\t\t\tif ( forward && useCache ) {\n\n\t\t\t\t\t\t\t\t\t\t// Seek `elem` from a previously-cached index\n\n\t\t\t\t\t\t\t\t\t\t// ...in a gzip-friendly way\n\t\t\t\t\t\t\t\t\t\tnode = parent;\n\t\t\t\t\t\t\t\t\t\touterCache = node[ expando ] || (node[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ node.uniqueID ] ||\n\t\t\t\t\t\t\t\t\t\t\t(outerCache[ node.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\t\tcache = uniqueCache[ type ] || [];\n\t\t\t\t\t\t\t\t\t\tnodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];\n\t\t\t\t\t\t\t\t\t\tdiff = nodeIndex && cache[ 2 ];\n\t\t\t\t\t\t\t\t\t\tnode = nodeIndex && parent.childNodes[ nodeIndex ];\n\n\t\t\t\t\t\t\t\t\t\twhile ( (node = ++nodeIndex && node && node[ dir ] ||\n\n\t\t\t\t\t\t\t\t\t\t\t// Fallback to seeking `elem` from the start\n\t\t\t\t\t\t\t\t\t\t\t(diff = nodeIndex = 0) || start.pop()) ) {\n\n\t\t\t\t\t\t\t\t\t\t\t// When found, cache indexes on `parent` and break\n\t\t\t\t\t\t\t\t\t\t\tif ( node.nodeType === 1 && ++diff && node === elem ) {\n\t\t\t\t\t\t\t\t\t\t\t\tuniqueCache[ type ] = [ dirruns, nodeIndex, diff ];\n\t\t\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\t// Use previously-cached element index if available\n\t\t\t\t\t\t\t\t\t\tif ( useCache ) {\n\t\t\t\t\t\t\t\t\t\t\t// ...in a gzip-friendly way\n\t\t\t\t\t\t\t\t\t\t\tnode = elem;\n\t\t\t\t\t\t\t\t\t\t\touterCache = node[ expando ] || (node[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ node.uniqueID ] ||\n\t\t\t\t\t\t\t\t\t\t\t\t(outerCache[ node.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\tcache = uniqueCache[ type ] || [];\n\t\t\t\t\t\t\t\t\t\t\tnodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];\n\t\t\t\t\t\t\t\t\t\t\tdiff = nodeIndex;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// xml :nth-child(...)\n\t\t\t\t\t\t\t\t\t\t// or :nth-last-child(...) or :nth(-last)?-of-type(...)\n\t\t\t\t\t\t\t\t\t\tif ( diff === false ) {\n\t\t\t\t\t\t\t\t\t\t\t// Use the same loop as above to seek `elem` from the start\n\t\t\t\t\t\t\t\t\t\t\twhile ( (node = ++nodeIndex && node && node[ dir ] ||\n\t\t\t\t\t\t\t\t\t\t\t\t(diff = nodeIndex = 0) || start.pop()) ) {\n\n\t\t\t\t\t\t\t\t\t\t\t\tif ( ( ofType ?\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeName.toLowerCase() === name :\n\t\t\t\t\t\t\t\t\t\t\t\t\tnode.nodeType === 1 ) &&\n\t\t\t\t\t\t\t\t\t\t\t\t\t++diff ) {\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t// Cache the index of each encountered element\n\t\t\t\t\t\t\t\t\t\t\t\t\tif ( useCache ) {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\touterCache = node[ expando ] || (node[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ node.uniqueID ] ||\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t(outerCache[ node.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tuniqueCache[ type ] = [ dirruns, diff ];\n\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t\t\t\tif ( node === elem ) {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Incorporate the offset, then check against cycle size\n\t\t\t\t\t\t\t\t\tdiff -= last;\n\t\t\t\t\t\t\t\t\treturn diff === first || ( diff % first === 0 && diff / first >= 0 );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t};\n\t\t\t\t\t},\n\n\t\t\t\t\t\"PSEUDO\": function( pseudo, argument ) {\n\t\t\t\t\t\t// pseudo-class names are case-insensitive\n\t\t\t\t\t\t// http://www.w3.org/TR/selectors/#pseudo-classes\n\t\t\t\t\t\t// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters\n\t\t\t\t\t\t// Remember that setFilters inherits from pseudos\n\t\t\t\t\t\tvar args,\n\t\t\t\t\t\t\tfn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||\n\t\t\t\t\t\t\t\tSizzle.error( \"unsupported pseudo: \" + pseudo );\n\n\t\t\t\t\t\t// The user may use createPseudo to indicate that\n\t\t\t\t\t\t// arguments are needed to create the filter function\n\t\t\t\t\t\t// just as Sizzle does\n\t\t\t\t\t\tif ( fn[ expando ] ) {\n\t\t\t\t\t\t\treturn fn( argument );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// But maintain support for old signatures\n\t\t\t\t\t\tif ( fn.length > 1 ) {\n\t\t\t\t\t\t\targs = [ pseudo, pseudo, \"\", argument ];\n\t\t\t\t\t\t\treturn Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?\n\t\t\t\t\t\t\t\tmarkFunction(function( seed, matches ) {\n\t\t\t\t\t\t\t\t\tvar idx,\n\t\t\t\t\t\t\t\t\t\tmatched = fn( seed, argument ),\n\t\t\t\t\t\t\t\t\t\ti = matched.length;\n\t\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\t\tidx = indexOf( seed, matched[i] );\n\t\t\t\t\t\t\t\t\t\tseed[ idx ] = !( matches[ idx ] = matched[i] );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}) :\n\t\t\t\t\t\t\t\tfunction( elem ) {\n\t\t\t\t\t\t\t\t\treturn fn( elem, 0, args );\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn fn;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tpseudos: {\n\t\t\t\t\t// Potentially complex pseudos\n\t\t\t\t\t\"not\": markFunction(function( selector ) {\n\t\t\t\t\t\t// Trim the selector passed to compile\n\t\t\t\t\t\t// to avoid treating leading and trailing\n\t\t\t\t\t\t// spaces as combinators\n\t\t\t\t\t\tvar input = [],\n\t\t\t\t\t\t\tresults = [],\n\t\t\t\t\t\t\tmatcher = compile( selector.replace( rtrim, \"$1\" ) );\n\n\t\t\t\t\t\treturn matcher[ expando ] ?\n\t\t\t\t\t\t\tmarkFunction(function( seed, matches, context, xml ) {\n\t\t\t\t\t\t\t\tvar elem,\n\t\t\t\t\t\t\t\t\tunmatched = matcher( seed, null, xml, [] ),\n\t\t\t\t\t\t\t\t\ti = seed.length;\n\n\t\t\t\t\t\t\t\t// Match elements unmatched by `matcher`\n\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\tif ( (elem = unmatched[i]) ) {\n\t\t\t\t\t\t\t\t\t\tseed[i] = !(matches[i] = elem);\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}) :\n\t\t\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\t\t\tinput[0] = elem;\n\t\t\t\t\t\t\t\tmatcher( input, null, xml, results );\n\t\t\t\t\t\t\t\t// Don't keep the element (issue #299)\n\t\t\t\t\t\t\t\tinput[0] = null;\n\t\t\t\t\t\t\t\treturn !results.pop();\n\t\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"has\": markFunction(function( selector ) {\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\treturn Sizzle( selector, elem ).length > 0;\n\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"contains\": markFunction(function( text ) {\n\t\t\t\t\t\ttext = text.replace( runescape, funescape );\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\treturn ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;\n\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t// \"Whether an element is represented by a :lang() selector\n\t\t\t\t\t// is based solely on the element's language value\n\t\t\t\t\t// being equal to the identifier C,\n\t\t\t\t\t// or beginning with the identifier C immediately followed by \"-\".\n\t\t\t\t\t// The matching of C against the element's language value is performed case-insensitively.\n\t\t\t\t\t// The identifier C does not have to be a valid language name.\"\n\t\t\t\t\t// http://www.w3.org/TR/selectors/#lang-pseudo\n\t\t\t\t\t\"lang\": markFunction( function( lang ) {\n\t\t\t\t\t\t// lang value must be a valid identifier\n\t\t\t\t\t\tif ( !ridentifier.test(lang || \"\") ) {\n\t\t\t\t\t\t\tSizzle.error( \"unsupported lang: \" + lang );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tlang = lang.replace( runescape, funescape ).toLowerCase();\n\t\t\t\t\t\treturn function( elem ) {\n\t\t\t\t\t\t\tvar elemLang;\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\tif ( (elemLang = documentIsHTML ?\n\t\t\t\t\t\t\t\t\t\telem.lang :\n\t\t\t\t\t\t\t\t\telem.getAttribute(\"xml:lang\") || elem.getAttribute(\"lang\")) ) {\n\n\t\t\t\t\t\t\t\t\telemLang = elemLang.toLowerCase();\n\t\t\t\t\t\t\t\t\treturn elemLang === lang || elemLang.indexOf( lang + \"-\" ) === 0;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} while ( (elem = elem.parentNode) && elem.nodeType === 1 );\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t};\n\t\t\t\t\t}),\n\n\t\t\t\t\t// Miscellaneous\n\t\t\t\t\t\"target\": function( elem ) {\n\t\t\t\t\t\tvar hash = window.location && window.location.hash;\n\t\t\t\t\t\treturn hash && hash.slice( 1 ) === elem.id;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"root\": function( elem ) {\n\t\t\t\t\t\treturn elem === docElem;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"focus\": function( elem ) {\n\t\t\t\t\t\treturn elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);\n\t\t\t\t\t},\n\n\t\t\t\t\t// Boolean properties\n\t\t\t\t\t\"enabled\": function( elem ) {\n\t\t\t\t\t\treturn elem.disabled === false;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"disabled\": function( elem ) {\n\t\t\t\t\t\treturn elem.disabled === true;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"checked\": function( elem ) {\n\t\t\t\t\t\t// In CSS3, :checked should return both checked and selected elements\n\t\t\t\t\t\t// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked\n\t\t\t\t\t\tvar nodeName = elem.nodeName.toLowerCase();\n\t\t\t\t\t\treturn (nodeName === \"input\" && !!elem.checked) || (nodeName === \"option\" && !!elem.selected);\n\t\t\t\t\t},\n\n\t\t\t\t\t\"selected\": function( elem ) {\n\t\t\t\t\t\t// Accessing this property makes selected-by-default\n\t\t\t\t\t\t// options in Safari work properly\n\t\t\t\t\t\tif ( elem.parentNode ) {\n\t\t\t\t\t\t\telem.parentNode.selectedIndex;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn elem.selected === true;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Contents\n\t\t\t\t\t\"empty\": function( elem ) {\n\t\t\t\t\t\t// http://www.w3.org/TR/selectors/#empty-pseudo\n\t\t\t\t\t\t// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),\n\t\t\t\t\t\t//   but not by others (comment: 8; processing instruction: 7; etc.)\n\t\t\t\t\t\t// nodeType < 6 works because attributes (2) do not appear as children\n\t\t\t\t\t\tfor ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {\n\t\t\t\t\t\t\tif ( elem.nodeType < 6 ) {\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t},\n\n\t\t\t\t\t\"parent\": function( elem ) {\n\t\t\t\t\t\treturn !Expr.pseudos[\"empty\"]( elem );\n\t\t\t\t\t},\n\n\t\t\t\t\t// Element/input types\n\t\t\t\t\t\"header\": function( elem ) {\n\t\t\t\t\t\treturn rheader.test( elem.nodeName );\n\t\t\t\t\t},\n\n\t\t\t\t\t\"input\": function( elem ) {\n\t\t\t\t\t\treturn rinputs.test( elem.nodeName );\n\t\t\t\t\t},\n\n\t\t\t\t\t\"button\": function( elem ) {\n\t\t\t\t\t\tvar name = elem.nodeName.toLowerCase();\n\t\t\t\t\t\treturn name === \"input\" && elem.type === \"button\" || name === \"button\";\n\t\t\t\t\t},\n\n\t\t\t\t\t\"text\": function( elem ) {\n\t\t\t\t\t\tvar attr;\n\t\t\t\t\t\treturn elem.nodeName.toLowerCase() === \"input\" &&\n\t\t\t\t\t\t\telem.type === \"text\" &&\n\n\t\t\t\t\t\t\t// Support: IE<8\n\t\t\t\t\t\t\t// New HTML5 attribute values (e.g., \"search\") appear with elem.type === \"text\"\n\t\t\t\t\t\t\t( (attr = elem.getAttribute(\"type\")) == null || attr.toLowerCase() === \"text\" );\n\t\t\t\t\t},\n\n\t\t\t\t\t// Position-in-collection\n\t\t\t\t\t\"first\": createPositionalPseudo(function() {\n\t\t\t\t\t\treturn [ 0 ];\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"last\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\t\t\t\treturn [ length - 1 ];\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"eq\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\t\t\t\treturn [ argument < 0 ? argument + length : argument ];\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"even\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\t\t\t\tvar i = 0;\n\t\t\t\t\t\tfor ( ; i < length; i += 2 ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"odd\": createPositionalPseudo(function( matchIndexes, length ) {\n\t\t\t\t\t\tvar i = 1;\n\t\t\t\t\t\tfor ( ; i < length; i += 2 ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"lt\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\t\t\t\tvar i = argument < 0 ? argument + length : argument;\n\t\t\t\t\t\tfor ( ; --i >= 0; ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t}),\n\n\t\t\t\t\t\"gt\": createPositionalPseudo(function( matchIndexes, length, argument ) {\n\t\t\t\t\t\tvar i = argument < 0 ? argument + length : argument;\n\t\t\t\t\t\tfor ( ; ++i < length; ) {\n\t\t\t\t\t\t\tmatchIndexes.push( i );\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn matchIndexes;\n\t\t\t\t\t})\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tExpr.pseudos[\"nth\"] = Expr.pseudos[\"eq\"];\n\n// Add button/input type pseudos\n\t\t\tfor ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {\n\t\t\t\tExpr.pseudos[ i ] = createInputPseudo( i );\n\t\t\t}\n\t\t\tfor ( i in { submit: true, reset: true } ) {\n\t\t\t\tExpr.pseudos[ i ] = createButtonPseudo( i );\n\t\t\t}\n\n// Easy API for creating new setFilters\n\t\t\tfunction setFilters() {}\n\t\t\tsetFilters.prototype = Expr.filters = Expr.pseudos;\n\t\t\tExpr.setFilters = new setFilters();\n\n\t\t\ttokenize = Sizzle.tokenize = function( selector, parseOnly ) {\n\t\t\t\tvar matched, match, tokens, type,\n\t\t\t\t\tsoFar, groups, preFilters,\n\t\t\t\t\tcached = tokenCache[ selector + \" \" ];\n\n\t\t\t\tif ( cached ) {\n\t\t\t\t\treturn parseOnly ? 0 : cached.slice( 0 );\n\t\t\t\t}\n\n\t\t\t\tsoFar = selector;\n\t\t\t\tgroups = [];\n\t\t\t\tpreFilters = Expr.preFilter;\n\n\t\t\t\twhile ( soFar ) {\n\n\t\t\t\t\t// Comma and first run\n\t\t\t\t\tif ( !matched || (match = rcomma.exec( soFar )) ) {\n\t\t\t\t\t\tif ( match ) {\n\t\t\t\t\t\t\t// Don't consume trailing commas as valid\n\t\t\t\t\t\t\tsoFar = soFar.slice( match[0].length ) || soFar;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tgroups.push( (tokens = []) );\n\t\t\t\t\t}\n\n\t\t\t\t\tmatched = false;\n\n\t\t\t\t\t// Combinators\n\t\t\t\t\tif ( (match = rcombinators.exec( soFar )) ) {\n\t\t\t\t\t\tmatched = match.shift();\n\t\t\t\t\t\ttokens.push({\n\t\t\t\t\t\t\tvalue: matched,\n\t\t\t\t\t\t\t// Cast descendant combinators to space\n\t\t\t\t\t\t\ttype: match[0].replace( rtrim, \" \" )\n\t\t\t\t\t\t});\n\t\t\t\t\t\tsoFar = soFar.slice( matched.length );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Filters\n\t\t\t\t\tfor ( type in Expr.filter ) {\n\t\t\t\t\t\tif ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||\n\t\t\t\t\t\t\t(match = preFilters[ type ]( match ))) ) {\n\t\t\t\t\t\t\tmatched = match.shift();\n\t\t\t\t\t\t\ttokens.push({\n\t\t\t\t\t\t\t\tvalue: matched,\n\t\t\t\t\t\t\t\ttype: type,\n\t\t\t\t\t\t\t\tmatches: match\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tsoFar = soFar.slice( matched.length );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( !matched ) {\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Return the length of the invalid excess\n\t\t\t\t// if we're just parsing\n\t\t\t\t// Otherwise, throw an error or return tokens\n\t\t\t\treturn parseOnly ?\n\t\t\t\t\tsoFar.length :\n\t\t\t\t\tsoFar ?\n\t\t\t\t\t\tSizzle.error( selector ) :\n\t\t\t\t\t\t// Cache the tokens\n\t\t\t\t\t\ttokenCache( selector, groups ).slice( 0 );\n\t\t\t};\n\n\t\t\tfunction toSelector( tokens ) {\n\t\t\t\tvar i = 0,\n\t\t\t\t\tlen = tokens.length,\n\t\t\t\t\tselector = \"\";\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tselector += tokens[i].value;\n\t\t\t\t}\n\t\t\t\treturn selector;\n\t\t\t}\n\n\t\t\tfunction addCombinator( matcher, combinator, base ) {\n\t\t\t\tvar dir = combinator.dir,\n\t\t\t\t\tcheckNonElements = base && dir === \"parentNode\",\n\t\t\t\t\tdoneName = done++;\n\n\t\t\t\treturn combinator.first ?\n\t\t\t\t\t// Check against closest ancestor/preceding element\n\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\t\t\t\treturn matcher( elem, context, xml );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} :\n\n\t\t\t\t\t// Check against all ancestor/preceding elements\n\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\tvar oldCache, uniqueCache, outerCache,\n\t\t\t\t\t\t\tnewCache = [ dirruns, doneName ];\n\n\t\t\t\t\t\t// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching\n\t\t\t\t\t\tif ( xml ) {\n\t\t\t\t\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\t\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\t\t\t\t\tif ( matcher( elem, context, xml ) ) {\n\t\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\twhile ( (elem = elem[ dir ]) ) {\n\t\t\t\t\t\t\t\tif ( elem.nodeType === 1 || checkNonElements ) {\n\t\t\t\t\t\t\t\t\touterCache = elem[ expando ] || (elem[ expando ] = {});\n\n\t\t\t\t\t\t\t\t\t// Support: IE <9 only\n\t\t\t\t\t\t\t\t\t// Defend against cloned attroperties (jQuery gh-1709)\n\t\t\t\t\t\t\t\t\tuniqueCache = outerCache[ elem.uniqueID ] || (outerCache[ elem.uniqueID ] = {});\n\n\t\t\t\t\t\t\t\t\tif ( (oldCache = uniqueCache[ dir ]) &&\n\t\t\t\t\t\t\t\t\t\toldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {\n\n\t\t\t\t\t\t\t\t\t\t// Assign to newCache so results back-propagate to previous elements\n\t\t\t\t\t\t\t\t\t\treturn (newCache[ 2 ] = oldCache[ 2 ]);\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\t// Reuse newcache so results back-propagate to previous elements\n\t\t\t\t\t\t\t\t\t\tuniqueCache[ dir ] = newCache;\n\n\t\t\t\t\t\t\t\t\t\t// A match means we're done; a fail means we have to keep checking\n\t\t\t\t\t\t\t\t\t\tif ( (newCache[ 2 ] = matcher( elem, context, xml )) ) {\n\t\t\t\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t}\n\n\t\t\tfunction elementMatcher( matchers ) {\n\t\t\t\treturn matchers.length > 1 ?\n\t\t\t\t\tfunction( elem, context, xml ) {\n\t\t\t\t\t\tvar i = matchers.length;\n\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\tif ( !matchers[i]( elem, context, xml ) ) {\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t} :\n\t\t\t\t\tmatchers[0];\n\t\t\t}\n\n\t\t\tfunction multipleContexts( selector, contexts, results ) {\n\t\t\t\tvar i = 0,\n\t\t\t\t\tlen = contexts.length;\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tSizzle( selector, contexts[i], results );\n\t\t\t\t}\n\t\t\t\treturn results;\n\t\t\t}\n\n\t\t\tfunction condense( unmatched, map, filter, context, xml ) {\n\t\t\t\tvar elem,\n\t\t\t\t\tnewUnmatched = [],\n\t\t\t\t\ti = 0,\n\t\t\t\t\tlen = unmatched.length,\n\t\t\t\t\tmapped = map != null;\n\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tif ( (elem = unmatched[i]) ) {\n\t\t\t\t\t\tif ( !filter || filter( elem, context, xml ) ) {\n\t\t\t\t\t\t\tnewUnmatched.push( elem );\n\t\t\t\t\t\t\tif ( mapped ) {\n\t\t\t\t\t\t\t\tmap.push( i );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn newUnmatched;\n\t\t\t}\n\n\t\t\tfunction setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {\n\t\t\t\tif ( postFilter && !postFilter[ expando ] ) {\n\t\t\t\t\tpostFilter = setMatcher( postFilter );\n\t\t\t\t}\n\t\t\t\tif ( postFinder && !postFinder[ expando ] ) {\n\t\t\t\t\tpostFinder = setMatcher( postFinder, postSelector );\n\t\t\t\t}\n\t\t\t\treturn markFunction(function( seed, results, context, xml ) {\n\t\t\t\t\tvar temp, i, elem,\n\t\t\t\t\t\tpreMap = [],\n\t\t\t\t\t\tpostMap = [],\n\t\t\t\t\t\tpreexisting = results.length,\n\n\t\t\t\t\t\t// Get initial elements from seed or context\n\t\t\t\t\t\telems = seed || multipleContexts( selector || \"*\", context.nodeType ? [ context ] : context, [] ),\n\n\t\t\t\t\t\t// Prefilter to get matcher input, preserving a map for seed-results synchronization\n\t\t\t\t\t\tmatcherIn = preFilter && ( seed || !selector ) ?\n\t\t\t\t\t\t\tcondense( elems, preMap, preFilter, context, xml ) :\n\t\t\t\t\t\t\telems,\n\n\t\t\t\t\t\tmatcherOut = matcher ?\n\t\t\t\t\t\t\t// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,\n\t\t\t\t\t\t\tpostFinder || ( seed ? preFilter : preexisting || postFilter ) ?\n\n\t\t\t\t\t\t\t\t// ...intermediate processing is necessary\n\t\t\t\t\t\t\t\t[] :\n\n\t\t\t\t\t\t\t\t// ...otherwise use results directly\n\t\t\t\t\t\t\t\tresults :\n\t\t\t\t\t\t\tmatcherIn;\n\n\t\t\t\t\t// Find primary matches\n\t\t\t\t\tif ( matcher ) {\n\t\t\t\t\t\tmatcher( matcherIn, matcherOut, context, xml );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Apply postFilter\n\t\t\t\t\tif ( postFilter ) {\n\t\t\t\t\t\ttemp = condense( matcherOut, postMap );\n\t\t\t\t\t\tpostFilter( temp, [], context, xml );\n\n\t\t\t\t\t\t// Un-match failing elements by moving them back to matcherIn\n\t\t\t\t\t\ti = temp.length;\n\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\tif ( (elem = temp[i]) ) {\n\t\t\t\t\t\t\t\tmatcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( seed ) {\n\t\t\t\t\t\tif ( postFinder || preFilter ) {\n\t\t\t\t\t\t\tif ( postFinder ) {\n\t\t\t\t\t\t\t\t// Get the final matcherOut by condensing this intermediate into postFinder contexts\n\t\t\t\t\t\t\t\ttemp = [];\n\t\t\t\t\t\t\t\ti = matcherOut.length;\n\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\tif ( (elem = matcherOut[i]) ) {\n\t\t\t\t\t\t\t\t\t\t// Restore matcherIn since elem is not yet a final match\n\t\t\t\t\t\t\t\t\t\ttemp.push( (matcherIn[i] = elem) );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tpostFinder( null, (matcherOut = []), temp, xml );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Move matched elements from seed to results to keep them synchronized\n\t\t\t\t\t\t\ti = matcherOut.length;\n\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\tif ( (elem = matcherOut[i]) &&\n\t\t\t\t\t\t\t\t\t(temp = postFinder ? indexOf( seed, elem ) : preMap[i]) > -1 ) {\n\n\t\t\t\t\t\t\t\t\tseed[temp] = !(results[temp] = elem);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Add elements to results, through postFinder if defined\n\t\t\t\t\t} else {\n\t\t\t\t\t\tmatcherOut = condense(\n\t\t\t\t\t\t\tmatcherOut === results ?\n\t\t\t\t\t\t\t\tmatcherOut.splice( preexisting, matcherOut.length ) :\n\t\t\t\t\t\t\t\tmatcherOut\n\t\t\t\t\t\t);\n\t\t\t\t\t\tif ( postFinder ) {\n\t\t\t\t\t\t\tpostFinder( null, results, matcherOut, xml );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tpush.apply( results, matcherOut );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tfunction matcherFromTokens( tokens ) {\n\t\t\t\tvar checkContext, matcher, j,\n\t\t\t\t\tlen = tokens.length,\n\t\t\t\t\tleadingRelative = Expr.relative[ tokens[0].type ],\n\t\t\t\t\timplicitRelative = leadingRelative || Expr.relative[\" \"],\n\t\t\t\t\ti = leadingRelative ? 1 : 0,\n\n\t\t\t\t\t// The foundational matcher ensures that elements are reachable from top-level context(s)\n\t\t\t\t\tmatchContext = addCombinator( function( elem ) {\n\t\t\t\t\t\treturn elem === checkContext;\n\t\t\t\t\t}, implicitRelative, true ),\n\t\t\t\t\tmatchAnyContext = addCombinator( function( elem ) {\n\t\t\t\t\t\treturn indexOf( checkContext, elem ) > -1;\n\t\t\t\t\t}, implicitRelative, true ),\n\t\t\t\t\tmatchers = [ function( elem, context, xml ) {\n\t\t\t\t\t\tvar ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (\n\t\t\t\t\t\t\t\t(checkContext = context).nodeType ?\n\t\t\t\t\t\t\t\t\tmatchContext( elem, context, xml ) :\n\t\t\t\t\t\t\t\t\tmatchAnyContext( elem, context, xml ) );\n\t\t\t\t\t\t// Avoid hanging onto element (issue #299)\n\t\t\t\t\t\tcheckContext = null;\n\t\t\t\t\t\treturn ret;\n\t\t\t\t\t} ];\n\n\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\tif ( (matcher = Expr.relative[ tokens[i].type ]) ) {\n\t\t\t\t\t\tmatchers = [ addCombinator(elementMatcher( matchers ), matcher) ];\n\t\t\t\t\t} else {\n\t\t\t\t\t\tmatcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );\n\n\t\t\t\t\t\t// Return special upon seeing a positional matcher\n\t\t\t\t\t\tif ( matcher[ expando ] ) {\n\t\t\t\t\t\t\t// Find the next relative operator (if any) for proper handling\n\t\t\t\t\t\t\tj = ++i;\n\t\t\t\t\t\t\tfor ( ; j < len; j++ ) {\n\t\t\t\t\t\t\t\tif ( Expr.relative[ tokens[j].type ] ) {\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn setMatcher(\n\t\t\t\t\t\t\t\ti > 1 && elementMatcher( matchers ),\n\t\t\t\t\t\t\t\ti > 1 && toSelector(\n\t\t\t\t\t\t\t\t\t// If the preceding token was a descendant combinator, insert an implicit any-element `*`\n\t\t\t\t\t\t\t\t\ttokens.slice( 0, i - 1 ).concat({ value: tokens[ i - 2 ].type === \" \" ? \"*\" : \"\" })\n\t\t\t\t\t\t\t\t).replace( rtrim, \"$1\" ),\n\t\t\t\t\t\t\t\tmatcher,\n\t\t\t\t\t\t\t\ti < j && matcherFromTokens( tokens.slice( i, j ) ),\n\t\t\t\t\t\t\t\tj < len && matcherFromTokens( (tokens = tokens.slice( j )) ),\n\t\t\t\t\t\t\t\tj < len && toSelector( tokens )\n\t\t\t\t\t\t\t);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tmatchers.push( matcher );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn elementMatcher( matchers );\n\t\t\t}\n\n\t\t\tfunction matcherFromGroupMatchers( elementMatchers, setMatchers ) {\n\t\t\t\tvar bySet = setMatchers.length > 0,\n\t\t\t\t\tbyElement = elementMatchers.length > 0,\n\t\t\t\t\tsuperMatcher = function( seed, context, xml, results, outermost ) {\n\t\t\t\t\t\tvar elem, j, matcher,\n\t\t\t\t\t\t\tmatchedCount = 0,\n\t\t\t\t\t\t\ti = \"0\",\n\t\t\t\t\t\t\tunmatched = seed && [],\n\t\t\t\t\t\t\tsetMatched = [],\n\t\t\t\t\t\t\tcontextBackup = outermostContext,\n\t\t\t\t\t\t\t// We must always have either seed elements or outermost context\n\t\t\t\t\t\t\telems = seed || byElement && Expr.find[\"TAG\"]( \"*\", outermost ),\n\t\t\t\t\t\t\t// Use integer dirruns iff this is the outermost matcher\n\t\t\t\t\t\t\tdirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1),\n\t\t\t\t\t\t\tlen = elems.length;\n\n\t\t\t\t\t\tif ( outermost ) {\n\t\t\t\t\t\t\toutermostContext = context === document || context || outermost;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Add elements passing elementMatchers directly to results\n\t\t\t\t\t\t// Support: IE<9, Safari\n\t\t\t\t\t\t// Tolerate NodeList properties (IE: \"length\"; Safari: <number>) matching elements by id\n\t\t\t\t\t\tfor ( ; i !== len && (elem = elems[i]) != null; i++ ) {\n\t\t\t\t\t\t\tif ( byElement && elem ) {\n\t\t\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\t\t\tif ( !context && elem.ownerDocument !== document ) {\n\t\t\t\t\t\t\t\t\tsetDocument( elem );\n\t\t\t\t\t\t\t\t\txml = !documentIsHTML;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\twhile ( (matcher = elementMatchers[j++]) ) {\n\t\t\t\t\t\t\t\t\tif ( matcher( elem, context || document, xml) ) {\n\t\t\t\t\t\t\t\t\t\tresults.push( elem );\n\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif ( outermost ) {\n\t\t\t\t\t\t\t\t\tdirruns = dirrunsUnique;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Track unmatched elements for set filters\n\t\t\t\t\t\t\tif ( bySet ) {\n\t\t\t\t\t\t\t\t// They will have gone through all possible matchers\n\t\t\t\t\t\t\t\tif ( (elem = !matcher && elem) ) {\n\t\t\t\t\t\t\t\t\tmatchedCount--;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Lengthen the array for every element, matched or not\n\t\t\t\t\t\t\t\tif ( seed ) {\n\t\t\t\t\t\t\t\t\tunmatched.push( elem );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// `i` is now the count of elements visited above, and adding it to `matchedCount`\n\t\t\t\t\t\t// makes the latter nonnegative.\n\t\t\t\t\t\tmatchedCount += i;\n\n\t\t\t\t\t\t// Apply set filters to unmatched elements\n\t\t\t\t\t\t// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`\n\t\t\t\t\t\t// equals `i`), unless we didn't visit _any_ elements in the above loop because we have\n\t\t\t\t\t\t// no element matchers and no seed.\n\t\t\t\t\t\t// Incrementing an initially-string \"0\" `i` allows `i` to remain a string only in that\n\t\t\t\t\t\t// case, which will result in a \"00\" `matchedCount` that differs from `i` but is also\n\t\t\t\t\t\t// numerically zero.\n\t\t\t\t\t\tif ( bySet && i !== matchedCount ) {\n\t\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\t\twhile ( (matcher = setMatchers[j++]) ) {\n\t\t\t\t\t\t\t\tmatcher( unmatched, setMatched, context, xml );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif ( seed ) {\n\t\t\t\t\t\t\t\t// Reintegrate element matches to eliminate the need for sorting\n\t\t\t\t\t\t\t\tif ( matchedCount > 0 ) {\n\t\t\t\t\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\t\t\t\t\tif ( !(unmatched[i] || setMatched[i]) ) {\n\t\t\t\t\t\t\t\t\t\t\tsetMatched[i] = pop.call( results );\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Discard index placeholder values to get only actual matches\n\t\t\t\t\t\t\t\tsetMatched = condense( setMatched );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Add matches to results\n\t\t\t\t\t\t\tpush.apply( results, setMatched );\n\n\t\t\t\t\t\t\t// Seedless set matches succeeding multiple successful matchers stipulate sorting\n\t\t\t\t\t\t\tif ( outermost && !seed && setMatched.length > 0 &&\n\t\t\t\t\t\t\t\t( matchedCount + setMatchers.length ) > 1 ) {\n\n\t\t\t\t\t\t\t\tSizzle.uniqueSort( results );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Override manipulation of globals by nested matchers\n\t\t\t\t\t\tif ( outermost ) {\n\t\t\t\t\t\t\tdirruns = dirrunsUnique;\n\t\t\t\t\t\t\toutermostContext = contextBackup;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn unmatched;\n\t\t\t\t\t};\n\n\t\t\t\treturn bySet ?\n\t\t\t\t\tmarkFunction( superMatcher ) :\n\t\t\t\t\tsuperMatcher;\n\t\t\t}\n\n\t\t\tcompile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {\n\t\t\t\tvar i,\n\t\t\t\t\tsetMatchers = [],\n\t\t\t\t\telementMatchers = [],\n\t\t\t\t\tcached = compilerCache[ selector + \" \" ];\n\n\t\t\t\tif ( !cached ) {\n\t\t\t\t\t// Generate a function of recursive functions that can be used to check each element\n\t\t\t\t\tif ( !match ) {\n\t\t\t\t\t\tmatch = tokenize( selector );\n\t\t\t\t\t}\n\t\t\t\t\ti = match.length;\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\tcached = matcherFromTokens( match[i] );\n\t\t\t\t\t\tif ( cached[ expando ] ) {\n\t\t\t\t\t\t\tsetMatchers.push( cached );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\telementMatchers.push( cached );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Cache the compiled function\n\t\t\t\t\tcached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );\n\n\t\t\t\t\t// Save selector and tokenization\n\t\t\t\t\tcached.selector = selector;\n\t\t\t\t}\n\t\t\t\treturn cached;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * A low-level selection function that works with Sizzle's compiled\n\t\t\t *  selector functions\n\t\t\t * @param {String|Function} selector A selector or a pre-compiled\n\t\t\t *  selector function built with Sizzle.compile\n\t\t\t * @param {Element} context\n\t\t\t * @param {Array} [results]\n\t\t\t * @param {Array} [seed] A set of elements to match against\n\t\t\t */\n\t\t\tselect = Sizzle.select = function( selector, context, results, seed ) {\n\t\t\t\tvar i, tokens, token, type, find,\n\t\t\t\t\tcompiled = typeof selector === \"function\" && selector,\n\t\t\t\t\tmatch = !seed && tokenize( (selector = compiled.selector || selector) );\n\n\t\t\t\tresults = results || [];\n\n\t\t\t\t// Try to minimize operations if there is only one selector in the list and no seed\n\t\t\t\t// (the latter of which guarantees us context)\n\t\t\t\tif ( match.length === 1 ) {\n\n\t\t\t\t\t// Reduce context if the leading compound selector is an ID\n\t\t\t\t\ttokens = match[0] = match[0].slice( 0 );\n\t\t\t\t\tif ( tokens.length > 2 && (token = tokens[0]).type === \"ID\" &&\n\t\t\t\t\t\tsupport.getById && context.nodeType === 9 && documentIsHTML &&\n\t\t\t\t\t\tExpr.relative[ tokens[1].type ] ) {\n\n\t\t\t\t\t\tcontext = ( Expr.find[\"ID\"]( token.matches[0].replace(runescape, funescape), context ) || [] )[0];\n\t\t\t\t\t\tif ( !context ) {\n\t\t\t\t\t\t\treturn results;\n\n\t\t\t\t\t\t\t// Precompiled matchers will still verify ancestry, so step up a level\n\t\t\t\t\t\t} else if ( compiled ) {\n\t\t\t\t\t\t\tcontext = context.parentNode;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tselector = selector.slice( tokens.shift().value.length );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Fetch a seed set for right-to-left matching\n\t\t\t\t\ti = matchExpr[\"needsContext\"].test( selector ) ? 0 : tokens.length;\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\ttoken = tokens[i];\n\n\t\t\t\t\t\t// Abort if we hit a combinator\n\t\t\t\t\t\tif ( Expr.relative[ (type = token.type) ] ) {\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( (find = Expr.find[ type ]) ) {\n\t\t\t\t\t\t\t// Search, expanding context for leading sibling combinators\n\t\t\t\t\t\t\tif ( (seed = find(\n\t\t\t\t\t\t\t\t\ttoken.matches[0].replace( runescape, funescape ),\n\t\t\t\t\t\t\t\t\trsibling.test( tokens[0].type ) && testContext( context.parentNode ) || context\n\t\t\t\t\t\t\t\t)) ) {\n\n\t\t\t\t\t\t\t\t// If seed is empty or no tokens remain, we can return early\n\t\t\t\t\t\t\t\ttokens.splice( i, 1 );\n\t\t\t\t\t\t\t\tselector = seed.length && toSelector( tokens );\n\t\t\t\t\t\t\t\tif ( !selector ) {\n\t\t\t\t\t\t\t\t\tpush.apply( results, seed );\n\t\t\t\t\t\t\t\t\treturn results;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Compile and execute a filtering function if one is not provided\n\t\t\t\t// Provide `match` to avoid retokenization if we modified the selector above\n\t\t\t\t( compiled || compile( selector, match ) )(\n\t\t\t\t\tseed,\n\t\t\t\t\tcontext,\n\t\t\t\t\t!documentIsHTML,\n\t\t\t\t\tresults,\n\t\t\t\t\t!context || rsibling.test( selector ) && testContext( context.parentNode ) || context\n\t\t\t\t);\n\t\t\t\treturn results;\n\t\t\t};\n\n// One-time assignments\n\n// Sort stability\n\t\t\tsupport.sortStable = expando.split(\"\").sort( sortOrder ).join(\"\") === expando;\n\n// Support: Chrome 14-35+\n// Always assume duplicates if they aren't passed to the comparison function\n\t\t\tsupport.detectDuplicates = !!hasDuplicate;\n\n// Initialize against the default document\n\t\t\tsetDocument();\n\n// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)\n// Detached nodes confoundingly follow *each other*\n\t\t\tsupport.sortDetached = assert(function( div1 ) {\n\t\t\t\t// Should return 1, but returns 4 (following)\n\t\t\t\treturn div1.compareDocumentPosition( document.createElement(\"div\") ) & 1;\n\t\t\t});\n\n// Support: IE<8\n// Prevent attribute/property \"interpolation\"\n// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx\n\t\t\tif ( !assert(function( div ) {\n\t\t\t\t\tdiv.innerHTML = \"<a href='#'></a>\";\n\t\t\t\t\treturn div.firstChild.getAttribute(\"href\") === \"#\" ;\n\t\t\t\t}) ) {\n\t\t\t\taddHandle( \"type|href|height|width\", function( elem, name, isXML ) {\n\t\t\t\t\tif ( !isXML ) {\n\t\t\t\t\t\treturn elem.getAttribute( name, name.toLowerCase() === \"type\" ? 1 : 2 );\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n// Support: IE<9\n// Use defaultValue in place of getAttribute(\"value\")\n\t\t\tif ( !support.attributes || !assert(function( div ) {\n\t\t\t\t\tdiv.innerHTML = \"<input/>\";\n\t\t\t\t\tdiv.firstChild.setAttribute( \"value\", \"\" );\n\t\t\t\t\treturn div.firstChild.getAttribute( \"value\" ) === \"\";\n\t\t\t\t}) ) {\n\t\t\t\taddHandle( \"value\", function( elem, name, isXML ) {\n\t\t\t\t\tif ( !isXML && elem.nodeName.toLowerCase() === \"input\" ) {\n\t\t\t\t\t\treturn elem.defaultValue;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n// Support: IE<9\n// Use getAttributeNode to fetch booleans when getAttribute lies\n\t\t\tif ( !assert(function( div ) {\n\t\t\t\t\treturn div.getAttribute(\"disabled\") == null;\n\t\t\t\t}) ) {\n\t\t\t\taddHandle( booleans, function( elem, name, isXML ) {\n\t\t\t\t\tvar val;\n\t\t\t\t\tif ( !isXML ) {\n\t\t\t\t\t\treturn elem[ name ] === true ? name.toLowerCase() :\n\t\t\t\t\t\t\t(val = elem.getAttributeNode( name )) && val.specified ?\n\t\t\t\t\t\t\t\tval.value :\n\t\t\t\t\t\t\t\tnull;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn Sizzle;\n\n\t\t})( window );\n\n\n\n\tjQuery.find = Sizzle;\n\tjQuery.expr = Sizzle.selectors;\n\tjQuery.expr[ \":\" ] = jQuery.expr.pseudos;\n\tjQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;\n\tjQuery.text = Sizzle.getText;\n\tjQuery.isXMLDoc = Sizzle.isXML;\n\tjQuery.contains = Sizzle.contains;\n\n\n\n\tvar dir = function( elem, dir, until ) {\n\t\tvar matched = [],\n\t\t\ttruncate = until !== undefined;\n\n\t\twhile ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {\n\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\tif ( truncate && jQuery( elem ).is( until ) ) {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tmatched.push( elem );\n\t\t\t}\n\t\t}\n\t\treturn matched;\n\t};\n\n\n\tvar siblings = function( n, elem ) {\n\t\tvar matched = [];\n\n\t\tfor ( ; n; n = n.nextSibling ) {\n\t\t\tif ( n.nodeType === 1 && n !== elem ) {\n\t\t\t\tmatched.push( n );\n\t\t\t}\n\t\t}\n\n\t\treturn matched;\n\t};\n\n\n\tvar rneedsContext = jQuery.expr.match.needsContext;\n\n\tvar rsingleTag = ( /^<([\\w-]+)\\s*\\/?>(?:<\\/\\1>|)$/ );\n\n\n\n\tvar risSimple = /^.[^:#\\[\\.,]*$/;\n\n// Implement the identical functionality for filter and not\n\tfunction winnow( elements, qualifier, not ) {\n\t\tif ( jQuery.isFunction( qualifier ) ) {\n\t\t\treturn jQuery.grep( elements, function( elem, i ) {\n\t\t\t\t/* jshint -W018 */\n\t\t\t\treturn !!qualifier.call( elem, i, elem ) !== not;\n\t\t\t} );\n\n\t\t}\n\n\t\tif ( qualifier.nodeType ) {\n\t\t\treturn jQuery.grep( elements, function( elem ) {\n\t\t\t\treturn ( elem === qualifier ) !== not;\n\t\t\t} );\n\n\t\t}\n\n\t\tif ( typeof qualifier === \"string\" ) {\n\t\t\tif ( risSimple.test( qualifier ) ) {\n\t\t\t\treturn jQuery.filter( qualifier, elements, not );\n\t\t\t}\n\n\t\t\tqualifier = jQuery.filter( qualifier, elements );\n\t\t}\n\n\t\treturn jQuery.grep( elements, function( elem ) {\n\t\t\treturn ( jQuery.inArray( elem, qualifier ) > -1 ) !== not;\n\t\t} );\n\t}\n\n\tjQuery.filter = function( expr, elems, not ) {\n\t\tvar elem = elems[ 0 ];\n\n\t\tif ( not ) {\n\t\t\texpr = \":not(\" + expr + \")\";\n\t\t}\n\n\t\treturn elems.length === 1 && elem.nodeType === 1 ?\n\t\t\tjQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [] :\n\t\t\tjQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {\n\t\t\t\treturn elem.nodeType === 1;\n\t\t\t} ) );\n\t};\n\n\tjQuery.fn.extend( {\n\t\tfind: function( selector ) {\n\t\t\tvar i,\n\t\t\t\tret = [],\n\t\t\t\tself = this,\n\t\t\t\tlen = self.length;\n\n\t\t\tif ( typeof selector !== \"string\" ) {\n\t\t\t\treturn this.pushStack( jQuery( selector ).filter( function() {\n\t\t\t\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\t\t\t\tif ( jQuery.contains( self[ i ], this ) ) {\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} ) );\n\t\t\t}\n\n\t\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\t\tjQuery.find( selector, self[ i ], ret );\n\t\t\t}\n\n\t\t\t// Needed because $( selector, context ) becomes $( context ).find( selector )\n\t\t\tret = this.pushStack( len > 1 ? jQuery.unique( ret ) : ret );\n\t\t\tret.selector = this.selector ? this.selector + \" \" + selector : selector;\n\t\t\treturn ret;\n\t\t},\n\t\tfilter: function( selector ) {\n\t\t\treturn this.pushStack( winnow( this, selector || [], false ) );\n\t\t},\n\t\tnot: function( selector ) {\n\t\t\treturn this.pushStack( winnow( this, selector || [], true ) );\n\t\t},\n\t\tis: function( selector ) {\n\t\t\treturn !!winnow(\n\t\t\t\tthis,\n\n\t\t\t\t// If this is a positional/relative selector, check membership in the returned set\n\t\t\t\t// so $(\"p:first\").is(\"p:last\") won't return true for a doc with two \"p\".\n\t\t\t\ttypeof selector === \"string\" && rneedsContext.test( selector ) ?\n\t\t\t\t\tjQuery( selector ) :\n\t\t\t\tselector || [],\n\t\t\t\tfalse\n\t\t\t).length;\n\t\t}\n\t} );\n\n\n// Initialize a jQuery object\n\n\n// A central reference to the root jQuery(document)\n\tvar rootjQuery,\n\n\t\t// A simple way to check for HTML strings\n\t\t// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)\n\t\t// Strict HTML recognition (#11290: must start with <)\n\t\trquickExpr = /^(?:\\s*(<[\\w\\W]+>)[^>]*|#([\\w-]*))$/,\n\n\t\tinit = jQuery.fn.init = function( selector, context, root ) {\n\t\t\tvar match, elem;\n\n\t\t\t// HANDLE: $(\"\"), $(null), $(undefined), $(false)\n\t\t\tif ( !selector ) {\n\t\t\t\treturn this;\n\t\t\t}\n\n\t\t\t// init accepts an alternate rootjQuery\n\t\t\t// so migrate can support jQuery.sub (gh-2101)\n\t\t\troot = root || rootjQuery;\n\n\t\t\t// Handle HTML strings\n\t\t\tif ( typeof selector === \"string\" ) {\n\t\t\t\tif ( selector.charAt( 0 ) === \"<\" &&\n\t\t\t\t\tselector.charAt( selector.length - 1 ) === \">\" &&\n\t\t\t\t\tselector.length >= 3 ) {\n\n\t\t\t\t\t// Assume that strings that start and end with <> are HTML and skip the regex check\n\t\t\t\t\tmatch = [ null, selector, null ];\n\n\t\t\t\t} else {\n\t\t\t\t\tmatch = rquickExpr.exec( selector );\n\t\t\t\t}\n\n\t\t\t\t// Match html or make sure no context is specified for #id\n\t\t\t\tif ( match && ( match[ 1 ] || !context ) ) {\n\n\t\t\t\t\t// HANDLE: $(html) -> $(array)\n\t\t\t\t\tif ( match[ 1 ] ) {\n\t\t\t\t\t\tcontext = context instanceof jQuery ? context[ 0 ] : context;\n\n\t\t\t\t\t\t// scripts is true for back-compat\n\t\t\t\t\t\t// Intentionally let the error be thrown if parseHTML is not present\n\t\t\t\t\t\tjQuery.merge( this, jQuery.parseHTML(\n\t\t\t\t\t\t\tmatch[ 1 ],\n\t\t\t\t\t\t\tcontext && context.nodeType ? context.ownerDocument || context : document,\n\t\t\t\t\t\t\ttrue\n\t\t\t\t\t\t) );\n\n\t\t\t\t\t\t// HANDLE: $(html, props)\n\t\t\t\t\t\tif ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {\n\t\t\t\t\t\t\tfor ( match in context ) {\n\n\t\t\t\t\t\t\t\t// Properties of context are called as methods if possible\n\t\t\t\t\t\t\t\tif ( jQuery.isFunction( this[ match ] ) ) {\n\t\t\t\t\t\t\t\t\tthis[ match ]( context[ match ] );\n\n\t\t\t\t\t\t\t\t\t// ...and otherwise set as attributes\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tthis.attr( match, context[ match ] );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn this;\n\n\t\t\t\t\t\t// HANDLE: $(#id)\n\t\t\t\t\t} else {\n\t\t\t\t\t\telem = document.getElementById( match[ 2 ] );\n\n\t\t\t\t\t\t// Check parentNode to catch when Blackberry 4.6 returns\n\t\t\t\t\t\t// nodes that are no longer in the document #6963\n\t\t\t\t\t\tif ( elem && elem.parentNode ) {\n\n\t\t\t\t\t\t\t// Handle the case where IE and Opera return items\n\t\t\t\t\t\t\t// by name instead of ID\n\t\t\t\t\t\t\tif ( elem.id !== match[ 2 ] ) {\n\t\t\t\t\t\t\t\treturn rootjQuery.find( selector );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Otherwise, we inject the element directly into the jQuery object\n\t\t\t\t\t\t\tthis.length = 1;\n\t\t\t\t\t\t\tthis[ 0 ] = elem;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tthis.context = document;\n\t\t\t\t\t\tthis.selector = selector;\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t}\n\n\t\t\t\t\t// HANDLE: $(expr, $(...))\n\t\t\t\t} else if ( !context || context.jquery ) {\n\t\t\t\t\treturn ( context || root ).find( selector );\n\n\t\t\t\t\t// HANDLE: $(expr, context)\n\t\t\t\t\t// (which is just equivalent to: $(context).find(expr)\n\t\t\t\t} else {\n\t\t\t\t\treturn this.constructor( context ).find( selector );\n\t\t\t\t}\n\n\t\t\t\t// HANDLE: $(DOMElement)\n\t\t\t} else if ( selector.nodeType ) {\n\t\t\t\tthis.context = this[ 0 ] = selector;\n\t\t\t\tthis.length = 1;\n\t\t\t\treturn this;\n\n\t\t\t\t// HANDLE: $(function)\n\t\t\t\t// Shortcut for document ready\n\t\t\t} else if ( jQuery.isFunction( selector ) ) {\n\t\t\t\treturn typeof root.ready !== \"undefined\" ?\n\t\t\t\t\troot.ready( selector ) :\n\n\t\t\t\t\t// Execute immediately if ready is not present\n\t\t\t\t\tselector( jQuery );\n\t\t\t}\n\n\t\t\tif ( selector.selector !== undefined ) {\n\t\t\t\tthis.selector = selector.selector;\n\t\t\t\tthis.context = selector.context;\n\t\t\t}\n\n\t\t\treturn jQuery.makeArray( selector, this );\n\t\t};\n\n// Give the init function the jQuery prototype for later instantiation\n\tinit.prototype = jQuery.fn;\n\n// Initialize central reference\n\trootjQuery = jQuery( document );\n\n\n\tvar rparentsprev = /^(?:parents|prev(?:Until|All))/,\n\n\t\t// methods guaranteed to produce a unique set when starting from a unique set\n\t\tguaranteedUnique = {\n\t\t\tchildren: true,\n\t\t\tcontents: true,\n\t\t\tnext: true,\n\t\t\tprev: true\n\t\t};\n\n\tjQuery.fn.extend( {\n\t\thas: function( target ) {\n\t\t\tvar i,\n\t\t\t\ttargets = jQuery( target, this ),\n\t\t\t\tlen = targets.length;\n\n\t\t\treturn this.filter( function() {\n\t\t\t\tfor ( i = 0; i < len; i++ ) {\n\t\t\t\t\tif ( jQuery.contains( this, targets[ i ] ) ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tclosest: function( selectors, context ) {\n\t\t\tvar cur,\n\t\t\t\ti = 0,\n\t\t\t\tl = this.length,\n\t\t\t\tmatched = [],\n\t\t\t\tpos = rneedsContext.test( selectors ) || typeof selectors !== \"string\" ?\n\t\t\t\t\tjQuery( selectors, context || this.context ) :\n\t\t\t\t\t0;\n\n\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\tfor ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {\n\n\t\t\t\t\t// Always skip document fragments\n\t\t\t\t\tif ( cur.nodeType < 11 && ( pos ?\n\t\t\t\t\t\tpos.index( cur ) > -1 :\n\n\t\t\t\t\t\t\t// Don't pass non-elements to Sizzle\n\t\t\t\t\t\tcur.nodeType === 1 &&\n\t\t\t\t\t\tjQuery.find.matchesSelector( cur, selectors ) ) ) {\n\n\t\t\t\t\t\tmatched.push( cur );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );\n\t\t},\n\n\t\t// Determine the position of an element within\n\t\t// the matched set of elements\n\t\tindex: function( elem ) {\n\n\t\t\t// No argument, return index in parent\n\t\t\tif ( !elem ) {\n\t\t\t\treturn ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;\n\t\t\t}\n\n\t\t\t// index in selector\n\t\t\tif ( typeof elem === \"string\" ) {\n\t\t\t\treturn jQuery.inArray( this[ 0 ], jQuery( elem ) );\n\t\t\t}\n\n\t\t\t// Locate the position of the desired element\n\t\t\treturn jQuery.inArray(\n\n\t\t\t\t// If it receives a jQuery object, the first element is used\n\t\t\t\telem.jquery ? elem[ 0 ] : elem, this );\n\t\t},\n\n\t\tadd: function( selector, context ) {\n\t\t\treturn this.pushStack(\n\t\t\t\tjQuery.uniqueSort(\n\t\t\t\t\tjQuery.merge( this.get(), jQuery( selector, context ) )\n\t\t\t\t)\n\t\t\t);\n\t\t},\n\n\t\taddBack: function( selector ) {\n\t\t\treturn this.add( selector == null ?\n\t\t\t\tthis.prevObject : this.prevObject.filter( selector )\n\t\t\t);\n\t\t}\n\t} );\n\n\tfunction sibling( cur, dir ) {\n\t\tdo {\n\t\t\tcur = cur[ dir ];\n\t\t} while ( cur && cur.nodeType !== 1 );\n\n\t\treturn cur;\n\t}\n\n\tjQuery.each( {\n\t\tparent: function( elem ) {\n\t\t\tvar parent = elem.parentNode;\n\t\t\treturn parent && parent.nodeType !== 11 ? parent : null;\n\t\t},\n\t\tparents: function( elem ) {\n\t\t\treturn dir( elem, \"parentNode\" );\n\t\t},\n\t\tparentsUntil: function( elem, i, until ) {\n\t\t\treturn dir( elem, \"parentNode\", until );\n\t\t},\n\t\tnext: function( elem ) {\n\t\t\treturn sibling( elem, \"nextSibling\" );\n\t\t},\n\t\tprev: function( elem ) {\n\t\t\treturn sibling( elem, \"previousSibling\" );\n\t\t},\n\t\tnextAll: function( elem ) {\n\t\t\treturn dir( elem, \"nextSibling\" );\n\t\t},\n\t\tprevAll: function( elem ) {\n\t\t\treturn dir( elem, \"previousSibling\" );\n\t\t},\n\t\tnextUntil: function( elem, i, until ) {\n\t\t\treturn dir( elem, \"nextSibling\", until );\n\t\t},\n\t\tprevUntil: function( elem, i, until ) {\n\t\t\treturn dir( elem, \"previousSibling\", until );\n\t\t},\n\t\tsiblings: function( elem ) {\n\t\t\treturn siblings( ( elem.parentNode || {} ).firstChild, elem );\n\t\t},\n\t\tchildren: function( elem ) {\n\t\t\treturn siblings( elem.firstChild );\n\t\t},\n\t\tcontents: function( elem ) {\n\t\t\treturn jQuery.nodeName( elem, \"iframe\" ) ?\n\t\t\telem.contentDocument || elem.contentWindow.document :\n\t\t\t\tjQuery.merge( [], elem.childNodes );\n\t\t}\n\t}, function( name, fn ) {\n\t\tjQuery.fn[ name ] = function( until, selector ) {\n\t\t\tvar ret = jQuery.map( this, fn, until );\n\n\t\t\tif ( name.slice( -5 ) !== \"Until\" ) {\n\t\t\t\tselector = until;\n\t\t\t}\n\n\t\t\tif ( selector && typeof selector === \"string\" ) {\n\t\t\t\tret = jQuery.filter( selector, ret );\n\t\t\t}\n\n\t\t\tif ( this.length > 1 ) {\n\n\t\t\t\t// Remove duplicates\n\t\t\t\tif ( !guaranteedUnique[ name ] ) {\n\t\t\t\t\tret = jQuery.uniqueSort( ret );\n\t\t\t\t}\n\n\t\t\t\t// Reverse order for parents* and prev-derivatives\n\t\t\t\tif ( rparentsprev.test( name ) ) {\n\t\t\t\t\tret = ret.reverse();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this.pushStack( ret );\n\t\t};\n\t} );\n\tvar rnotwhite = ( /\\S+/g );\n\n\n\n// Convert String-formatted options into Object-formatted ones\n\tfunction createOptions( options ) {\n\t\tvar object = {};\n\t\tjQuery.each( options.match( rnotwhite ) || [], function( _, flag ) {\n\t\t\tobject[ flag ] = true;\n\t\t} );\n\t\treturn object;\n\t}\n\n\t/*\n\t * Create a callback list using the following parameters:\n\t *\n\t *\toptions: an optional list of space-separated options that will change how\n\t *\t\t\tthe callback list behaves or a more traditional option object\n\t *\n\t * By default a callback list will act like an event callback list and can be\n\t * \"fired\" multiple times.\n\t *\n\t * Possible options:\n\t *\n\t *\tonce:\t\t\twill ensure the callback list can only be fired once (like a Deferred)\n\t *\n\t *\tmemory:\t\t\twill keep track of previous values and will call any callback added\n\t *\t\t\t\t\tafter the list has been fired right away with the latest \"memorized\"\n\t *\t\t\t\t\tvalues (like a Deferred)\n\t *\n\t *\tunique:\t\t\twill ensure a callback can only be added once (no duplicate in the list)\n\t *\n\t *\tstopOnFalse:\tinterrupt callings when a callback returns false\n\t *\n\t */\n\tjQuery.Callbacks = function( options ) {\n\n\t\t// Convert options from String-formatted to Object-formatted if needed\n\t\t// (we check in cache first)\n\t\toptions = typeof options === \"string\" ?\n\t\t\tcreateOptions( options ) :\n\t\t\tjQuery.extend( {}, options );\n\n\t\tvar // Flag to know if list is currently firing\n\t\t\tfiring,\n\n\t\t\t// Last fire value for non-forgettable lists\n\t\t\tmemory,\n\n\t\t\t// Flag to know if list was already fired\n\t\t\tfired,\n\n\t\t\t// Flag to prevent firing\n\t\t\tlocked,\n\n\t\t\t// Actual callback list\n\t\t\tlist = [],\n\n\t\t\t// Queue of execution data for repeatable lists\n\t\t\tqueue = [],\n\n\t\t\t// Index of currently firing callback (modified by add/remove as needed)\n\t\t\tfiringIndex = -1,\n\n\t\t\t// Fire callbacks\n\t\t\tfire = function() {\n\n\t\t\t\t// Enforce single-firing\n\t\t\t\tlocked = options.once;\n\n\t\t\t\t// Execute callbacks for all pending executions,\n\t\t\t\t// respecting firingIndex overrides and runtime changes\n\t\t\t\tfired = firing = true;\n\t\t\t\tfor ( ; queue.length; firingIndex = -1 ) {\n\t\t\t\t\tmemory = queue.shift();\n\t\t\t\t\twhile ( ++firingIndex < list.length ) {\n\n\t\t\t\t\t\t// Run callback and check for early termination\n\t\t\t\t\t\tif ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&\n\t\t\t\t\t\t\toptions.stopOnFalse ) {\n\n\t\t\t\t\t\t\t// Jump to end and forget the data so .add doesn't re-fire\n\t\t\t\t\t\t\tfiringIndex = list.length;\n\t\t\t\t\t\t\tmemory = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Forget the data if we're done with it\n\t\t\t\tif ( !options.memory ) {\n\t\t\t\t\tmemory = false;\n\t\t\t\t}\n\n\t\t\t\tfiring = false;\n\n\t\t\t\t// Clean up if we're done firing for good\n\t\t\t\tif ( locked ) {\n\n\t\t\t\t\t// Keep an empty list if we have data for future add calls\n\t\t\t\t\tif ( memory ) {\n\t\t\t\t\t\tlist = [];\n\n\t\t\t\t\t\t// Otherwise, this object is spent\n\t\t\t\t\t} else {\n\t\t\t\t\t\tlist = \"\";\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Actual Callbacks object\n\t\t\tself = {\n\n\t\t\t\t// Add a callback or a collection of callbacks to the list\n\t\t\t\tadd: function() {\n\t\t\t\t\tif ( list ) {\n\n\t\t\t\t\t\t// If we have memory from a past run, we should fire after adding\n\t\t\t\t\t\tif ( memory && !firing ) {\n\t\t\t\t\t\t\tfiringIndex = list.length - 1;\n\t\t\t\t\t\t\tqueue.push( memory );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t( function add( args ) {\n\t\t\t\t\t\t\tjQuery.each( args, function( _, arg ) {\n\t\t\t\t\t\t\t\tif ( jQuery.isFunction( arg ) ) {\n\t\t\t\t\t\t\t\t\tif ( !options.unique || !self.has( arg ) ) {\n\t\t\t\t\t\t\t\t\t\tlist.push( arg );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t} else if ( arg && arg.length && jQuery.type( arg ) !== \"string\" ) {\n\n\t\t\t\t\t\t\t\t\t// Inspect recursively\n\t\t\t\t\t\t\t\t\tadd( arg );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t} )( arguments );\n\n\t\t\t\t\t\tif ( memory && !firing ) {\n\t\t\t\t\t\t\tfire();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Remove a callback from the list\n\t\t\t\tremove: function() {\n\t\t\t\t\tjQuery.each( arguments, function( _, arg ) {\n\t\t\t\t\t\tvar index;\n\t\t\t\t\t\twhile ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {\n\t\t\t\t\t\t\tlist.splice( index, 1 );\n\n\t\t\t\t\t\t\t// Handle firing indexes\n\t\t\t\t\t\t\tif ( index <= firingIndex ) {\n\t\t\t\t\t\t\t\tfiringIndex--;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Check if a given callback is in the list.\n\t\t\t\t// If no argument is given, return whether or not list has callbacks attached.\n\t\t\t\thas: function( fn ) {\n\t\t\t\t\treturn fn ?\n\t\t\t\t\tjQuery.inArray( fn, list ) > -1 :\n\t\t\t\t\tlist.length > 0;\n\t\t\t\t},\n\n\t\t\t\t// Remove all callbacks from the list\n\t\t\t\tempty: function() {\n\t\t\t\t\tif ( list ) {\n\t\t\t\t\t\tlist = [];\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Disable .fire and .add\n\t\t\t\t// Abort any current/pending executions\n\t\t\t\t// Clear all callbacks and values\n\t\t\t\tdisable: function() {\n\t\t\t\t\tlocked = queue = [];\n\t\t\t\t\tlist = memory = \"\";\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\t\t\t\tdisabled: function() {\n\t\t\t\t\treturn !list;\n\t\t\t\t},\n\n\t\t\t\t// Disable .fire\n\t\t\t\t// Also disable .add unless we have memory (since it would have no effect)\n\t\t\t\t// Abort any pending executions\n\t\t\t\tlock: function() {\n\t\t\t\t\tlocked = true;\n\t\t\t\t\tif ( !memory ) {\n\t\t\t\t\t\tself.disable();\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\t\t\t\tlocked: function() {\n\t\t\t\t\treturn !!locked;\n\t\t\t\t},\n\n\t\t\t\t// Call all callbacks with the given context and arguments\n\t\t\t\tfireWith: function( context, args ) {\n\t\t\t\t\tif ( !locked ) {\n\t\t\t\t\t\targs = args || [];\n\t\t\t\t\t\targs = [ context, args.slice ? args.slice() : args ];\n\t\t\t\t\t\tqueue.push( args );\n\t\t\t\t\t\tif ( !firing ) {\n\t\t\t\t\t\t\tfire();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// Call all the callbacks with the given arguments\n\t\t\t\tfire: function() {\n\t\t\t\t\tself.fireWith( this, arguments );\n\t\t\t\t\treturn this;\n\t\t\t\t},\n\n\t\t\t\t// To know if the callbacks have already been called at least once\n\t\t\t\tfired: function() {\n\t\t\t\t\treturn !!fired;\n\t\t\t\t}\n\t\t\t};\n\n\t\treturn self;\n\t};\n\n\n\tjQuery.extend( {\n\n\t\tDeferred: function( func ) {\n\t\t\tvar tuples = [\n\n\t\t\t\t\t// action, add listener, listener list, final state\n\t\t\t\t\t[ \"resolve\", \"done\", jQuery.Callbacks( \"once memory\" ), \"resolved\" ],\n\t\t\t\t\t[ \"reject\", \"fail\", jQuery.Callbacks( \"once memory\" ), \"rejected\" ],\n\t\t\t\t\t[ \"notify\", \"progress\", jQuery.Callbacks( \"memory\" ) ]\n\t\t\t\t],\n\t\t\t\tstate = \"pending\",\n\t\t\t\tpromise = {\n\t\t\t\t\tstate: function() {\n\t\t\t\t\t\treturn state;\n\t\t\t\t\t},\n\t\t\t\t\talways: function() {\n\t\t\t\t\t\tdeferred.done( arguments ).fail( arguments );\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\t\t\t\t\tthen: function( /* fnDone, fnFail, fnProgress */ ) {\n\t\t\t\t\t\tvar fns = arguments;\n\t\t\t\t\t\treturn jQuery.Deferred( function( newDefer ) {\n\t\t\t\t\t\t\tjQuery.each( tuples, function( i, tuple ) {\n\t\t\t\t\t\t\t\tvar fn = jQuery.isFunction( fns[ i ] ) && fns[ i ];\n\n\t\t\t\t\t\t\t\t// deferred[ done | fail | progress ] for forwarding actions to newDefer\n\t\t\t\t\t\t\t\tdeferred[ tuple[ 1 ] ]( function() {\n\t\t\t\t\t\t\t\t\tvar returned = fn && fn.apply( this, arguments );\n\t\t\t\t\t\t\t\t\tif ( returned && jQuery.isFunction( returned.promise ) ) {\n\t\t\t\t\t\t\t\t\t\treturned.promise()\n\t\t\t\t\t\t\t\t\t\t\t.progress( newDefer.notify )\n\t\t\t\t\t\t\t\t\t\t\t.done( newDefer.resolve )\n\t\t\t\t\t\t\t\t\t\t\t.fail( newDefer.reject );\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tnewDefer[ tuple[ 0 ] + \"With\" ](\n\t\t\t\t\t\t\t\t\t\t\tthis === promise ? newDefer.promise() : this,\n\t\t\t\t\t\t\t\t\t\t\tfn ? [ returned ] : arguments\n\t\t\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t\tfns = null;\n\t\t\t\t\t\t} ).promise();\n\t\t\t\t\t},\n\n\t\t\t\t\t// Get a promise for this deferred\n\t\t\t\t\t// If obj is provided, the promise aspect is added to the object\n\t\t\t\t\tpromise: function( obj ) {\n\t\t\t\t\t\treturn obj != null ? jQuery.extend( obj, promise ) : promise;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tdeferred = {};\n\n\t\t\t// Keep pipe for back-compat\n\t\t\tpromise.pipe = promise.then;\n\n\t\t\t// Add list-specific methods\n\t\t\tjQuery.each( tuples, function( i, tuple ) {\n\t\t\t\tvar list = tuple[ 2 ],\n\t\t\t\t\tstateString = tuple[ 3 ];\n\n\t\t\t\t// promise[ done | fail | progress ] = list.add\n\t\t\t\tpromise[ tuple[ 1 ] ] = list.add;\n\n\t\t\t\t// Handle state\n\t\t\t\tif ( stateString ) {\n\t\t\t\t\tlist.add( function() {\n\n\t\t\t\t\t\t// state = [ resolved | rejected ]\n\t\t\t\t\t\tstate = stateString;\n\n\t\t\t\t\t\t// [ reject_list | resolve_list ].disable; progress_list.lock\n\t\t\t\t\t}, tuples[ i ^ 1 ][ 2 ].disable, tuples[ 2 ][ 2 ].lock );\n\t\t\t\t}\n\n\t\t\t\t// deferred[ resolve | reject | notify ]\n\t\t\t\tdeferred[ tuple[ 0 ] ] = function() {\n\t\t\t\t\tdeferred[ tuple[ 0 ] + \"With\" ]( this === deferred ? promise : this, arguments );\n\t\t\t\t\treturn this;\n\t\t\t\t};\n\t\t\t\tdeferred[ tuple[ 0 ] + \"With\" ] = list.fireWith;\n\t\t\t} );\n\n\t\t\t// Make the deferred a promise\n\t\t\tpromise.promise( deferred );\n\n\t\t\t// Call given func if any\n\t\t\tif ( func ) {\n\t\t\t\tfunc.call( deferred, deferred );\n\t\t\t}\n\n\t\t\t// All done!\n\t\t\treturn deferred;\n\t\t},\n\n\t\t// Deferred helper\n\t\twhen: function( subordinate /* , ..., subordinateN */ ) {\n\t\t\tvar i = 0,\n\t\t\t\tresolveValues = slice.call( arguments ),\n\t\t\t\tlength = resolveValues.length,\n\n\t\t\t\t// the count of uncompleted subordinates\n\t\t\t\tremaining = length !== 1 ||\n\t\t\t\t( subordinate && jQuery.isFunction( subordinate.promise ) ) ? length : 0,\n\n\t\t\t\t// the master Deferred.\n\t\t\t\t// If resolveValues consist of only a single Deferred, just use that.\n\t\t\t\tdeferred = remaining === 1 ? subordinate : jQuery.Deferred(),\n\n\t\t\t\t// Update function for both resolve and progress values\n\t\t\t\tupdateFunc = function( i, contexts, values ) {\n\t\t\t\t\treturn function( value ) {\n\t\t\t\t\t\tcontexts[ i ] = this;\n\t\t\t\t\t\tvalues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;\n\t\t\t\t\t\tif ( values === progressValues ) {\n\t\t\t\t\t\t\tdeferred.notifyWith( contexts, values );\n\n\t\t\t\t\t\t} else if ( !( --remaining ) ) {\n\t\t\t\t\t\t\tdeferred.resolveWith( contexts, values );\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t},\n\n\t\t\t\tprogressValues, progressContexts, resolveContexts;\n\n\t\t\t// add listeners to Deferred subordinates; treat others as resolved\n\t\t\tif ( length > 1 ) {\n\t\t\t\tprogressValues = new Array( length );\n\t\t\t\tprogressContexts = new Array( length );\n\t\t\t\tresolveContexts = new Array( length );\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tif ( resolveValues[ i ] && jQuery.isFunction( resolveValues[ i ].promise ) ) {\n\t\t\t\t\t\tresolveValues[ i ].promise()\n\t\t\t\t\t\t\t.progress( updateFunc( i, progressContexts, progressValues ) )\n\t\t\t\t\t\t\t.done( updateFunc( i, resolveContexts, resolveValues ) )\n\t\t\t\t\t\t\t.fail( deferred.reject );\n\t\t\t\t\t} else {\n\t\t\t\t\t\t--remaining;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// if we're not waiting on anything, resolve the master\n\t\t\tif ( !remaining ) {\n\t\t\t\tdeferred.resolveWith( resolveContexts, resolveValues );\n\t\t\t}\n\n\t\t\treturn deferred.promise();\n\t\t}\n\t} );\n\n\n// The deferred used on DOM ready\n\tvar readyList;\n\n\tjQuery.fn.ready = function( fn ) {\n\n\t\t// Add the callback\n\t\tjQuery.ready.promise().done( fn );\n\n\t\treturn this;\n\t};\n\n\tjQuery.extend( {\n\n\t\t// Is the DOM ready to be used? Set to true once it occurs.\n\t\tisReady: false,\n\n\t\t// A counter to track how many items to wait for before\n\t\t// the ready event fires. See #6781\n\t\treadyWait: 1,\n\n\t\t// Hold (or release) the ready event\n\t\tholdReady: function( hold ) {\n\t\t\tif ( hold ) {\n\t\t\t\tjQuery.readyWait++;\n\t\t\t} else {\n\t\t\t\tjQuery.ready( true );\n\t\t\t}\n\t\t},\n\n\t\t// Handle when the DOM is ready\n\t\tready: function( wait ) {\n\n\t\t\t// Abort if there are pending holds or we're already ready\n\t\t\tif ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Remember that the DOM is ready\n\t\t\tjQuery.isReady = true;\n\n\t\t\t// If a normal DOM Ready event fired, decrement, and wait if need be\n\t\t\tif ( wait !== true && --jQuery.readyWait > 0 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// If there are functions bound, to execute\n\t\t\treadyList.resolveWith( document, [ jQuery ] );\n\n\t\t\t// Trigger any bound ready events\n\t\t\tif ( jQuery.fn.triggerHandler ) {\n\t\t\t\tjQuery( document ).triggerHandler( \"ready\" );\n\t\t\t\tjQuery( document ).off( \"ready\" );\n\t\t\t}\n\t\t}\n\t} );\n\n\t/**\n\t * Clean-up method for dom ready events\n\t */\n\tfunction detach() {\n\t\tif ( document.addEventListener ) {\n\t\t\tdocument.removeEventListener( \"DOMContentLoaded\", completed );\n\t\t\twindow.removeEventListener( \"load\", completed );\n\n\t\t} else {\n\t\t\tdocument.detachEvent( \"onreadystatechange\", completed );\n\t\t\twindow.detachEvent( \"onload\", completed );\n\t\t}\n\t}\n\n\t/**\n\t * The ready event handler and self cleanup method\n\t */\n\tfunction completed() {\n\n\t\t// readyState === \"complete\" is good enough for us to call the dom ready in oldIE\n\t\tif ( document.addEventListener ||\n\t\t\twindow.event.type === \"load\" ||\n\t\t\tdocument.readyState === \"complete\" ) {\n\n\t\t\tdetach();\n\t\t\tjQuery.ready();\n\t\t}\n\t}\n\n\tjQuery.ready.promise = function( obj ) {\n\t\tif ( !readyList ) {\n\n\t\t\treadyList = jQuery.Deferred();\n\n\t\t\t// Catch cases where $(document).ready() is called\n\t\t\t// after the browser event has already occurred.\n\t\t\t// Support: IE6-10\n\t\t\t// Older IE sometimes signals \"interactive\" too soon\n\t\t\tif ( document.readyState === \"complete\" ||\n\t\t\t\t( document.readyState !== \"loading\" && !document.documentElement.doScroll ) ) {\n\n\t\t\t\t// Handle it asynchronously to allow scripts the opportunity to delay ready\n\t\t\t\twindow.setTimeout( jQuery.ready );\n\n\t\t\t\t// Standards-based browsers support DOMContentLoaded\n\t\t\t} else if ( document.addEventListener ) {\n\n\t\t\t\t// Use the handy event callback\n\t\t\t\tdocument.addEventListener( \"DOMContentLoaded\", completed );\n\n\t\t\t\t// A fallback to window.onload, that will always work\n\t\t\t\twindow.addEventListener( \"load\", completed );\n\n\t\t\t\t// If IE event model is used\n\t\t\t} else {\n\n\t\t\t\t// Ensure firing before onload, maybe late but safe also for iframes\n\t\t\t\tdocument.attachEvent( \"onreadystatechange\", completed );\n\n\t\t\t\t// A fallback to window.onload, that will always work\n\t\t\t\twindow.attachEvent( \"onload\", completed );\n\n\t\t\t\t// If IE and not a frame\n\t\t\t\t// continually check to see if the document is ready\n\t\t\t\tvar top = false;\n\n\t\t\t\ttry {\n\t\t\t\t\ttop = window.frameElement == null && document.documentElement;\n\t\t\t\t} catch ( e ) {}\n\n\t\t\t\tif ( top && top.doScroll ) {\n\t\t\t\t\t( function doScrollCheck() {\n\t\t\t\t\t\tif ( !jQuery.isReady ) {\n\n\t\t\t\t\t\t\ttry {\n\n\t\t\t\t\t\t\t\t// Use the trick by Diego Perini\n\t\t\t\t\t\t\t\t// http://javascript.nwbox.com/IEContentLoaded/\n\t\t\t\t\t\t\t\ttop.doScroll( \"left\" );\n\t\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\t\treturn window.setTimeout( doScrollCheck, 50 );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// detach all dom ready events\n\t\t\t\t\t\t\tdetach();\n\n\t\t\t\t\t\t\t// and execute any waiting functions\n\t\t\t\t\t\t\tjQuery.ready();\n\t\t\t\t\t\t}\n\t\t\t\t\t} )();\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn readyList.promise( obj );\n\t};\n\n// Kick off the DOM ready check even if the user does not\n\tjQuery.ready.promise();\n\n\n\n\n// Support: IE<9\n// Iteration over object's inherited properties before its own\n\tvar i;\n\tfor ( i in jQuery( support ) ) {\n\t\tbreak;\n\t}\n\tsupport.ownFirst = i === \"0\";\n\n// Note: most support tests are defined in their respective modules.\n// false until the test is run\n\tsupport.inlineBlockNeedsLayout = false;\n\n// Execute ASAP in case we need to set body.style.zoom\n\tjQuery( function() {\n\n\t\t// Minified: var a,b,c,d\n\t\tvar val, div, body, container;\n\n\t\tbody = document.getElementsByTagName( \"body\" )[ 0 ];\n\t\tif ( !body || !body.style ) {\n\n\t\t\t// Return for frameset docs that don't have a body\n\t\t\treturn;\n\t\t}\n\n\t\t// Setup\n\t\tdiv = document.createElement( \"div\" );\n\t\tcontainer = document.createElement( \"div\" );\n\t\tcontainer.style.cssText = \"position:absolute;border:0;width:0;height:0;top:0;left:-9999px\";\n\t\tbody.appendChild( container ).appendChild( div );\n\n\t\tif ( typeof div.style.zoom !== \"undefined\" ) {\n\n\t\t\t// Support: IE<8\n\t\t\t// Check if natively block-level elements act like inline-block\n\t\t\t// elements when setting their display to 'inline' and giving\n\t\t\t// them layout\n\t\t\tdiv.style.cssText = \"display:inline;margin:0;border:0;padding:1px;width:1px;zoom:1\";\n\n\t\t\tsupport.inlineBlockNeedsLayout = val = div.offsetWidth === 3;\n\t\t\tif ( val ) {\n\n\t\t\t\t// Prevent IE 6 from affecting layout for positioned elements #11048\n\t\t\t\t// Prevent IE from shrinking the body in IE 7 mode #12869\n\t\t\t\t// Support: IE<8\n\t\t\t\tbody.style.zoom = 1;\n\t\t\t}\n\t\t}\n\n\t\tbody.removeChild( container );\n\t} );\n\n\n\t( function() {\n\t\tvar div = document.createElement( \"div\" );\n\n\t\t// Support: IE<9\n\t\tsupport.deleteExpando = true;\n\t\ttry {\n\t\t\tdelete div.test;\n\t\t} catch ( e ) {\n\t\t\tsupport.deleteExpando = false;\n\t\t}\n\n\t\t// Null elements to avoid leaks in IE.\n\t\tdiv = null;\n\t} )();\n\tvar acceptData = function( elem ) {\n\t\tvar noData = jQuery.noData[ ( elem.nodeName + \" \" ).toLowerCase() ],\n\t\t\tnodeType = +elem.nodeType || 1;\n\n\t\t// Do not set data on non-element DOM nodes because it will not be cleared (#8335).\n\t\treturn nodeType !== 1 && nodeType !== 9 ?\n\t\t\tfalse :\n\n\t\t\t// Nodes accept data unless otherwise specified; rejection can be conditional\n\t\t!noData || noData !== true && elem.getAttribute( \"classid\" ) === noData;\n\t};\n\n\n\n\n\tvar rbrace = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/,\n\t\trmultiDash = /([A-Z])/g;\n\n\tfunction dataAttr( elem, key, data ) {\n\n\t\t// If nothing was found internally, try to fetch any\n\t\t// data from the HTML5 data-* attribute\n\t\tif ( data === undefined && elem.nodeType === 1 ) {\n\n\t\t\tvar name = \"data-\" + key.replace( rmultiDash, \"-$1\" ).toLowerCase();\n\n\t\t\tdata = elem.getAttribute( name );\n\n\t\t\tif ( typeof data === \"string\" ) {\n\t\t\t\ttry {\n\t\t\t\t\tdata = data === \"true\" ? true :\n\t\t\t\t\t\tdata === \"false\" ? false :\n\t\t\t\t\t\t\tdata === \"null\" ? null :\n\n\t\t\t\t\t\t\t\t// Only convert to a number if it doesn't change the string\n\t\t\t\t\t\t\t\t+data + \"\" === data ? +data :\n\t\t\t\t\t\t\t\t\trbrace.test( data ) ? jQuery.parseJSON( data ) :\n\t\t\t\t\t\t\t\t\t\tdata;\n\t\t\t\t} catch ( e ) {}\n\n\t\t\t\t// Make sure we set the data so it isn't changed later\n\t\t\t\tjQuery.data( elem, key, data );\n\n\t\t\t} else {\n\t\t\t\tdata = undefined;\n\t\t\t}\n\t\t}\n\n\t\treturn data;\n\t}\n\n// checks a cache object for emptiness\n\tfunction isEmptyDataObject( obj ) {\n\t\tvar name;\n\t\tfor ( name in obj ) {\n\n\t\t\t// if the public data object is empty, the private is still empty\n\t\t\tif ( name === \"data\" && jQuery.isEmptyObject( obj[ name ] ) ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\t\t\tif ( name !== \"toJSON\" ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\n\t\treturn true;\n\t}\n\n\tfunction internalData( elem, name, data, pvt /* Internal Use Only */ ) {\n\t\tif ( !acceptData( elem ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar ret, thisCache,\n\t\t\tinternalKey = jQuery.expando,\n\n\t\t\t// We have to handle DOM nodes and JS objects differently because IE6-7\n\t\t\t// can't GC object references properly across the DOM-JS boundary\n\t\t\tisNode = elem.nodeType,\n\n\t\t\t// Only DOM nodes need the global jQuery cache; JS object data is\n\t\t\t// attached directly to the object so GC can occur automatically\n\t\t\tcache = isNode ? jQuery.cache : elem,\n\n\t\t\t// Only defining an ID for JS objects if its cache already exists allows\n\t\t\t// the code to shortcut on the same path as a DOM node with no cache\n\t\t\tid = isNode ? elem[ internalKey ] : elem[ internalKey ] && internalKey;\n\n\t\t// Avoid doing any more work than we need to when trying to get data on an\n\t\t// object that has no data at all\n\t\tif ( ( !id || !cache[ id ] || ( !pvt && !cache[ id ].data ) ) &&\n\t\t\tdata === undefined && typeof name === \"string\" ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( !id ) {\n\n\t\t\t// Only DOM nodes need a new unique ID for each element since their data\n\t\t\t// ends up in the global cache\n\t\t\tif ( isNode ) {\n\t\t\t\tid = elem[ internalKey ] = deletedIds.pop() || jQuery.guid++;\n\t\t\t} else {\n\t\t\t\tid = internalKey;\n\t\t\t}\n\t\t}\n\n\t\tif ( !cache[ id ] ) {\n\n\t\t\t// Avoid exposing jQuery metadata on plain JS objects when the object\n\t\t\t// is serialized using JSON.stringify\n\t\t\tcache[ id ] = isNode ? {} : { toJSON: jQuery.noop };\n\t\t}\n\n\t\t// An object can be passed to jQuery.data instead of a key/value pair; this gets\n\t\t// shallow copied over onto the existing cache\n\t\tif ( typeof name === \"object\" || typeof name === \"function\" ) {\n\t\t\tif ( pvt ) {\n\t\t\t\tcache[ id ] = jQuery.extend( cache[ id ], name );\n\t\t\t} else {\n\t\t\t\tcache[ id ].data = jQuery.extend( cache[ id ].data, name );\n\t\t\t}\n\t\t}\n\n\t\tthisCache = cache[ id ];\n\n\t\t// jQuery data() is stored in a separate object inside the object's internal data\n\t\t// cache in order to avoid key collisions between internal data and user-defined\n\t\t// data.\n\t\tif ( !pvt ) {\n\t\t\tif ( !thisCache.data ) {\n\t\t\t\tthisCache.data = {};\n\t\t\t}\n\n\t\t\tthisCache = thisCache.data;\n\t\t}\n\n\t\tif ( data !== undefined ) {\n\t\t\tthisCache[ jQuery.camelCase( name ) ] = data;\n\t\t}\n\n\t\t// Check for both converted-to-camel and non-converted data property names\n\t\t// If a data property was specified\n\t\tif ( typeof name === \"string\" ) {\n\n\t\t\t// First Try to find as-is property data\n\t\t\tret = thisCache[ name ];\n\n\t\t\t// Test for null|undefined property data\n\t\t\tif ( ret == null ) {\n\n\t\t\t\t// Try to find the camelCased property\n\t\t\t\tret = thisCache[ jQuery.camelCase( name ) ];\n\t\t\t}\n\t\t} else {\n\t\t\tret = thisCache;\n\t\t}\n\n\t\treturn ret;\n\t}\n\n\tfunction internalRemoveData( elem, name, pvt ) {\n\t\tif ( !acceptData( elem ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar thisCache, i,\n\t\t\tisNode = elem.nodeType,\n\n\t\t\t// See jQuery.data for more information\n\t\t\tcache = isNode ? jQuery.cache : elem,\n\t\t\tid = isNode ? elem[ jQuery.expando ] : jQuery.expando;\n\n\t\t// If there is already no cache entry for this object, there is no\n\t\t// purpose in continuing\n\t\tif ( !cache[ id ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( name ) {\n\n\t\t\tthisCache = pvt ? cache[ id ] : cache[ id ].data;\n\n\t\t\tif ( thisCache ) {\n\n\t\t\t\t// Support array or space separated string names for data keys\n\t\t\t\tif ( !jQuery.isArray( name ) ) {\n\n\t\t\t\t\t// try the string as a key before any manipulation\n\t\t\t\t\tif ( name in thisCache ) {\n\t\t\t\t\t\tname = [ name ];\n\t\t\t\t\t} else {\n\n\t\t\t\t\t\t// split the camel cased version by spaces unless a key with the spaces exists\n\t\t\t\t\t\tname = jQuery.camelCase( name );\n\t\t\t\t\t\tif ( name in thisCache ) {\n\t\t\t\t\t\t\tname = [ name ];\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tname = name.split( \" \" );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} else {\n\n\t\t\t\t\t// If \"name\" is an array of keys...\n\t\t\t\t\t// When data is initially created, via (\"key\", \"val\") signature,\n\t\t\t\t\t// keys will be converted to camelCase.\n\t\t\t\t\t// Since there is no way to tell _how_ a key was added, remove\n\t\t\t\t\t// both plain key and camelCase key. #12786\n\t\t\t\t\t// This will only penalize the array argument path.\n\t\t\t\t\tname = name.concat( jQuery.map( name, jQuery.camelCase ) );\n\t\t\t\t}\n\n\t\t\t\ti = name.length;\n\t\t\t\twhile ( i-- ) {\n\t\t\t\t\tdelete thisCache[ name[ i ] ];\n\t\t\t\t}\n\n\t\t\t\t// If there is no data left in the cache, we want to continue\n\t\t\t\t// and let the cache object itself get destroyed\n\t\t\t\tif ( pvt ? !isEmptyDataObject( thisCache ) : !jQuery.isEmptyObject( thisCache ) ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// See jQuery.data for more information\n\t\tif ( !pvt ) {\n\t\t\tdelete cache[ id ].data;\n\n\t\t\t// Don't destroy the parent cache unless the internal data object\n\t\t\t// had been the only thing left in it\n\t\t\tif ( !isEmptyDataObject( cache[ id ] ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t}\n\n\t\t// Destroy the cache\n\t\tif ( isNode ) {\n\t\t\tjQuery.cleanData( [ elem ], true );\n\n\t\t\t// Use delete when supported for expandos or `cache` is not a window per isWindow (#10080)\n\t\t\t/* jshint eqeqeq: false */\n\t\t} else if ( support.deleteExpando || cache != cache.window ) {\n\t\t\t/* jshint eqeqeq: true */\n\t\t\tdelete cache[ id ];\n\n\t\t\t// When all else fails, undefined\n\t\t} else {\n\t\t\tcache[ id ] = undefined;\n\t\t}\n\t}\n\n\tjQuery.extend( {\n\t\tcache: {},\n\n\t\t// The following elements (space-suffixed to avoid Object.prototype collisions)\n\t\t// throw uncatchable exceptions if you attempt to set expando properties\n\t\tnoData: {\n\t\t\t\"applet \": true,\n\t\t\t\"embed \": true,\n\n\t\t\t// ...but Flash objects (which have this classid) *can* handle expandos\n\t\t\t\"object \": \"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\"\n\t\t},\n\n\t\thasData: function( elem ) {\n\t\t\telem = elem.nodeType ? jQuery.cache[ elem[ jQuery.expando ] ] : elem[ jQuery.expando ];\n\t\t\treturn !!elem && !isEmptyDataObject( elem );\n\t\t},\n\n\t\tdata: function( elem, name, data ) {\n\t\t\treturn internalData( elem, name, data );\n\t\t},\n\n\t\tremoveData: function( elem, name ) {\n\t\t\treturn internalRemoveData( elem, name );\n\t\t},\n\n\t\t// For internal use only.\n\t\t_data: function( elem, name, data ) {\n\t\t\treturn internalData( elem, name, data, true );\n\t\t},\n\n\t\t_removeData: function( elem, name ) {\n\t\t\treturn internalRemoveData( elem, name, true );\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\t\tdata: function( key, value ) {\n\t\t\tvar i, name, data,\n\t\t\t\telem = this[ 0 ],\n\t\t\t\tattrs = elem && elem.attributes;\n\n\t\t\t// Special expections of .data basically thwart jQuery.access,\n\t\t\t// so implement the relevant behavior ourselves\n\n\t\t\t// Gets all values\n\t\t\tif ( key === undefined ) {\n\t\t\t\tif ( this.length ) {\n\t\t\t\t\tdata = jQuery.data( elem );\n\n\t\t\t\t\tif ( elem.nodeType === 1 && !jQuery._data( elem, \"parsedAttrs\" ) ) {\n\t\t\t\t\t\ti = attrs.length;\n\t\t\t\t\t\twhile ( i-- ) {\n\n\t\t\t\t\t\t\t// Support: IE11+\n\t\t\t\t\t\t\t// The attrs elements can be null (#14894)\n\t\t\t\t\t\t\tif ( attrs[ i ] ) {\n\t\t\t\t\t\t\t\tname = attrs[ i ].name;\n\t\t\t\t\t\t\t\tif ( name.indexOf( \"data-\" ) === 0 ) {\n\t\t\t\t\t\t\t\t\tname = jQuery.camelCase( name.slice( 5 ) );\n\t\t\t\t\t\t\t\t\tdataAttr( elem, name, data[ name ] );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tjQuery._data( elem, \"parsedAttrs\", true );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn data;\n\t\t\t}\n\n\t\t\t// Sets multiple values\n\t\t\tif ( typeof key === \"object\" ) {\n\t\t\t\treturn this.each( function() {\n\t\t\t\t\tjQuery.data( this, key );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn arguments.length > 1 ?\n\n\t\t\t\t// Sets one value\n\t\t\t\tthis.each( function() {\n\t\t\t\t\tjQuery.data( this, key, value );\n\t\t\t\t} ) :\n\n\t\t\t\t// Gets one value\n\t\t\t\t// Try to fetch any internally stored data first\n\t\t\t\telem ? dataAttr( elem, key, jQuery.data( elem, key ) ) : undefined;\n\t\t},\n\n\t\tremoveData: function( key ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.removeData( this, key );\n\t\t\t} );\n\t\t}\n\t} );\n\n\n\tjQuery.extend( {\n\t\tqueue: function( elem, type, data ) {\n\t\t\tvar queue;\n\n\t\t\tif ( elem ) {\n\t\t\t\ttype = ( type || \"fx\" ) + \"queue\";\n\t\t\t\tqueue = jQuery._data( elem, type );\n\n\t\t\t\t// Speed up dequeue by getting out quickly if this is just a lookup\n\t\t\t\tif ( data ) {\n\t\t\t\t\tif ( !queue || jQuery.isArray( data ) ) {\n\t\t\t\t\t\tqueue = jQuery._data( elem, type, jQuery.makeArray( data ) );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tqueue.push( data );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn queue || [];\n\t\t\t}\n\t\t},\n\n\t\tdequeue: function( elem, type ) {\n\t\t\ttype = type || \"fx\";\n\n\t\t\tvar queue = jQuery.queue( elem, type ),\n\t\t\t\tstartLength = queue.length,\n\t\t\t\tfn = queue.shift(),\n\t\t\t\thooks = jQuery._queueHooks( elem, type ),\n\t\t\t\tnext = function() {\n\t\t\t\t\tjQuery.dequeue( elem, type );\n\t\t\t\t};\n\n\t\t\t// If the fx queue is dequeued, always remove the progress sentinel\n\t\t\tif ( fn === \"inprogress\" ) {\n\t\t\t\tfn = queue.shift();\n\t\t\t\tstartLength--;\n\t\t\t}\n\n\t\t\tif ( fn ) {\n\n\t\t\t\t// Add a progress sentinel to prevent the fx queue from being\n\t\t\t\t// automatically dequeued\n\t\t\t\tif ( type === \"fx\" ) {\n\t\t\t\t\tqueue.unshift( \"inprogress\" );\n\t\t\t\t}\n\n\t\t\t\t// clear up the last queue stop function\n\t\t\t\tdelete hooks.stop;\n\t\t\t\tfn.call( elem, next, hooks );\n\t\t\t}\n\n\t\t\tif ( !startLength && hooks ) {\n\t\t\t\thooks.empty.fire();\n\t\t\t}\n\t\t},\n\n\t\t// not intended for public consumption - generates a queueHooks object,\n\t\t// or returns the current one\n\t\t_queueHooks: function( elem, type ) {\n\t\t\tvar key = type + \"queueHooks\";\n\t\t\treturn jQuery._data( elem, key ) || jQuery._data( elem, key, {\n\t\t\t\t\tempty: jQuery.Callbacks( \"once memory\" ).add( function() {\n\t\t\t\t\t\tjQuery._removeData( elem, type + \"queue\" );\n\t\t\t\t\t\tjQuery._removeData( elem, key );\n\t\t\t\t\t} )\n\t\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\t\tqueue: function( type, data ) {\n\t\t\tvar setter = 2;\n\n\t\t\tif ( typeof type !== \"string\" ) {\n\t\t\t\tdata = type;\n\t\t\t\ttype = \"fx\";\n\t\t\t\tsetter--;\n\t\t\t}\n\n\t\t\tif ( arguments.length < setter ) {\n\t\t\t\treturn jQuery.queue( this[ 0 ], type );\n\t\t\t}\n\n\t\t\treturn data === undefined ?\n\t\t\t\tthis :\n\t\t\t\tthis.each( function() {\n\t\t\t\t\tvar queue = jQuery.queue( this, type, data );\n\n\t\t\t\t\t// ensure a hooks for this queue\n\t\t\t\t\tjQuery._queueHooks( this, type );\n\n\t\t\t\t\tif ( type === \"fx\" && queue[ 0 ] !== \"inprogress\" ) {\n\t\t\t\t\t\tjQuery.dequeue( this, type );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t},\n\t\tdequeue: function( type ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.dequeue( this, type );\n\t\t\t} );\n\t\t},\n\t\tclearQueue: function( type ) {\n\t\t\treturn this.queue( type || \"fx\", [] );\n\t\t},\n\n\t\t// Get a promise resolved when queues of a certain type\n\t\t// are emptied (fx is the type by default)\n\t\tpromise: function( type, obj ) {\n\t\t\tvar tmp,\n\t\t\t\tcount = 1,\n\t\t\t\tdefer = jQuery.Deferred(),\n\t\t\t\telements = this,\n\t\t\t\ti = this.length,\n\t\t\t\tresolve = function() {\n\t\t\t\t\tif ( !( --count ) ) {\n\t\t\t\t\t\tdefer.resolveWith( elements, [ elements ] );\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\tif ( typeof type !== \"string\" ) {\n\t\t\t\tobj = type;\n\t\t\t\ttype = undefined;\n\t\t\t}\n\t\t\ttype = type || \"fx\";\n\n\t\t\twhile ( i-- ) {\n\t\t\t\ttmp = jQuery._data( elements[ i ], type + \"queueHooks\" );\n\t\t\t\tif ( tmp && tmp.empty ) {\n\t\t\t\t\tcount++;\n\t\t\t\t\ttmp.empty.add( resolve );\n\t\t\t\t}\n\t\t\t}\n\t\t\tresolve();\n\t\t\treturn defer.promise( obj );\n\t\t}\n\t} );\n\n\n\t( function() {\n\t\tvar shrinkWrapBlocksVal;\n\n\t\tsupport.shrinkWrapBlocks = function() {\n\t\t\tif ( shrinkWrapBlocksVal != null ) {\n\t\t\t\treturn shrinkWrapBlocksVal;\n\t\t\t}\n\n\t\t\t// Will be changed later if needed.\n\t\t\tshrinkWrapBlocksVal = false;\n\n\t\t\t// Minified: var b,c,d\n\t\t\tvar div, body, container;\n\n\t\t\tbody = document.getElementsByTagName( \"body\" )[ 0 ];\n\t\t\tif ( !body || !body.style ) {\n\n\t\t\t\t// Test fired too early or in an unsupported environment, exit.\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Setup\n\t\t\tdiv = document.createElement( \"div\" );\n\t\t\tcontainer = document.createElement( \"div\" );\n\t\t\tcontainer.style.cssText = \"position:absolute;border:0;width:0;height:0;top:0;left:-9999px\";\n\t\t\tbody.appendChild( container ).appendChild( div );\n\n\t\t\t// Support: IE6\n\t\t\t// Check if elements with layout shrink-wrap their children\n\t\t\tif ( typeof div.style.zoom !== \"undefined\" ) {\n\n\t\t\t\t// Reset CSS: box-sizing; display; margin; border\n\t\t\t\tdiv.style.cssText =\n\n\t\t\t\t\t// Support: Firefox<29, Android 2.3\n\t\t\t\t\t// Vendor-prefix box-sizing\n\t\t\t\t\t\"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;\" +\n\t\t\t\t\t\"box-sizing:content-box;display:block;margin:0;border:0;\" +\n\t\t\t\t\t\"padding:1px;width:1px;zoom:1\";\n\t\t\t\tdiv.appendChild( document.createElement( \"div\" ) ).style.width = \"5px\";\n\t\t\t\tshrinkWrapBlocksVal = div.offsetWidth !== 3;\n\t\t\t}\n\n\t\t\tbody.removeChild( container );\n\n\t\t\treturn shrinkWrapBlocksVal;\n\t\t};\n\n\t} )();\n\tvar pnum = ( /[+-]?(?:\\d*\\.|)\\d+(?:[eE][+-]?\\d+|)/ ).source;\n\n\tvar rcssNum = new RegExp( \"^(?:([+-])=|)(\" + pnum + \")([a-z%]*)$\", \"i\" );\n\n\n\tvar cssExpand = [ \"Top\", \"Right\", \"Bottom\", \"Left\" ];\n\n\tvar isHidden = function( elem, el ) {\n\n\t\t// isHidden might be called from jQuery#filter function;\n\t\t// in that case, element will be second argument\n\t\telem = el || elem;\n\t\treturn jQuery.css( elem, \"display\" ) === \"none\" ||\n\t\t\t!jQuery.contains( elem.ownerDocument, elem );\n\t};\n\n\n\n\tfunction adjustCSS( elem, prop, valueParts, tween ) {\n\t\tvar adjusted,\n\t\t\tscale = 1,\n\t\t\tmaxIterations = 20,\n\t\t\tcurrentValue = tween ?\n\t\t\t\tfunction() { return tween.cur(); } :\n\t\t\t\tfunction() { return jQuery.css( elem, prop, \"\" ); },\n\t\t\tinitial = currentValue(),\n\t\t\tunit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" ),\n\n\t\t\t// Starting value computation is required for potential unit mismatches\n\t\t\tinitialInUnit = ( jQuery.cssNumber[ prop ] || unit !== \"px\" && +initial ) &&\n\t\t\t\trcssNum.exec( jQuery.css( elem, prop ) );\n\n\t\tif ( initialInUnit && initialInUnit[ 3 ] !== unit ) {\n\n\t\t\t// Trust units reported by jQuery.css\n\t\t\tunit = unit || initialInUnit[ 3 ];\n\n\t\t\t// Make sure we update the tween properties later on\n\t\t\tvalueParts = valueParts || [];\n\n\t\t\t// Iteratively approximate from a nonzero starting point\n\t\t\tinitialInUnit = +initial || 1;\n\n\t\t\tdo {\n\n\t\t\t\t// If previous iteration zeroed out, double until we get *something*.\n\t\t\t\t// Use string for doubling so we don't accidentally see scale as unchanged below\n\t\t\t\tscale = scale || \".5\";\n\n\t\t\t\t// Adjust and apply\n\t\t\t\tinitialInUnit = initialInUnit / scale;\n\t\t\t\tjQuery.style( elem, prop, initialInUnit + unit );\n\n\t\t\t\t// Update scale, tolerating zero or NaN from tween.cur()\n\t\t\t\t// Break the loop if scale is unchanged or perfect, or if we've just had enough.\n\t\t\t} while (\n\t\t\tscale !== ( scale = currentValue() / initial ) && scale !== 1 && --maxIterations\n\t\t\t\t);\n\t\t}\n\n\t\tif ( valueParts ) {\n\t\t\tinitialInUnit = +initialInUnit || +initial || 0;\n\n\t\t\t// Apply relative offset (+=/-=) if specified\n\t\t\tadjusted = valueParts[ 1 ] ?\n\t\t\tinitialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :\n\t\t\t\t+valueParts[ 2 ];\n\t\t\tif ( tween ) {\n\t\t\t\ttween.unit = unit;\n\t\t\t\ttween.start = initialInUnit;\n\t\t\t\ttween.end = adjusted;\n\t\t\t}\n\t\t}\n\t\treturn adjusted;\n\t}\n\n\n// Multifunctional method to get and set values of a collection\n// The value/s can optionally be executed if it's a function\n\tvar access = function( elems, fn, key, value, chainable, emptyGet, raw ) {\n\t\tvar i = 0,\n\t\t\tlength = elems.length,\n\t\t\tbulk = key == null;\n\n\t\t// Sets many values\n\t\tif ( jQuery.type( key ) === \"object\" ) {\n\t\t\tchainable = true;\n\t\t\tfor ( i in key ) {\n\t\t\t\taccess( elems, fn, i, key[ i ], true, emptyGet, raw );\n\t\t\t}\n\n\t\t\t// Sets one value\n\t\t} else if ( value !== undefined ) {\n\t\t\tchainable = true;\n\n\t\t\tif ( !jQuery.isFunction( value ) ) {\n\t\t\t\traw = true;\n\t\t\t}\n\n\t\t\tif ( bulk ) {\n\n\t\t\t\t// Bulk operations run against the entire set\n\t\t\t\tif ( raw ) {\n\t\t\t\t\tfn.call( elems, value );\n\t\t\t\t\tfn = null;\n\n\t\t\t\t\t// ...except when executing function values\n\t\t\t\t} else {\n\t\t\t\t\tbulk = fn;\n\t\t\t\t\tfn = function( elem, key, value ) {\n\t\t\t\t\t\treturn bulk.call( jQuery( elem ), value );\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( fn ) {\n\t\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\t\tfn(\n\t\t\t\t\t\telems[ i ],\n\t\t\t\t\t\tkey,\n\t\t\t\t\t\traw ? value : value.call( elems[ i ], i, fn( elems[ i ], key ) )\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn chainable ?\n\t\t\telems :\n\n\t\t\t// Gets\n\t\t\tbulk ?\n\t\t\t\tfn.call( elems ) :\n\t\t\t\tlength ? fn( elems[ 0 ], key ) : emptyGet;\n\t};\n\tvar rcheckableType = ( /^(?:checkbox|radio)$/i );\n\n\tvar rtagName = ( /<([\\w:-]+)/ );\n\n\tvar rscriptType = ( /^$|\\/(?:java|ecma)script/i );\n\n\tvar rleadingWhitespace = ( /^\\s+/ );\n\n\tvar nodeNames = \"abbr|article|aside|audio|bdi|canvas|data|datalist|\" +\n\t\t\"details|dialog|figcaption|figure|footer|header|hgroup|main|\" +\n\t\t\"mark|meter|nav|output|picture|progress|section|summary|template|time|video\";\n\n\n\n\tfunction createSafeFragment( document ) {\n\t\tvar list = nodeNames.split( \"|\" ),\n\t\t\tsafeFrag = document.createDocumentFragment();\n\n\t\tif ( safeFrag.createElement ) {\n\t\t\twhile ( list.length ) {\n\t\t\t\tsafeFrag.createElement(\n\t\t\t\t\tlist.pop()\n\t\t\t\t);\n\t\t\t}\n\t\t}\n\t\treturn safeFrag;\n\t}\n\n\n\t( function() {\n\t\tvar div = document.createElement( \"div\" ),\n\t\t\tfragment = document.createDocumentFragment(),\n\t\t\tinput = document.createElement( \"input\" );\n\n\t\t// Setup\n\t\tdiv.innerHTML = \"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\";\n\n\t\t// IE strips leading whitespace when .innerHTML is used\n\t\tsupport.leadingWhitespace = div.firstChild.nodeType === 3;\n\n\t\t// Make sure that tbody elements aren't automatically inserted\n\t\t// IE will insert them into empty tables\n\t\tsupport.tbody = !div.getElementsByTagName( \"tbody\" ).length;\n\n\t\t// Make sure that link elements get serialized correctly by innerHTML\n\t\t// This requires a wrapper element in IE\n\t\tsupport.htmlSerialize = !!div.getElementsByTagName( \"link\" ).length;\n\n\t\t// Makes sure cloning an html5 element does not cause problems\n\t\t// Where outerHTML is undefined, this still works\n\t\tsupport.html5Clone =\n\t\t\tdocument.createElement( \"nav\" ).cloneNode( true ).outerHTML !== \"<:nav></:nav>\";\n\n\t\t// Check if a disconnected checkbox will retain its checked\n\t\t// value of true after appended to the DOM (IE6/7)\n\t\tinput.type = \"checkbox\";\n\t\tinput.checked = true;\n\t\tfragment.appendChild( input );\n\t\tsupport.appendChecked = input.checked;\n\n\t\t// Make sure textarea (and checkbox) defaultValue is properly cloned\n\t\t// Support: IE6-IE11+\n\t\tdiv.innerHTML = \"<textarea>x</textarea>\";\n\t\tsupport.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;\n\n\t\t// #11217 - WebKit loses check when the name is after the checked attribute\n\t\tfragment.appendChild( div );\n\n\t\t// Support: Windows Web Apps (WWA)\n\t\t// `name` and `type` must use .setAttribute for WWA (#14901)\n\t\tinput = document.createElement( \"input\" );\n\t\tinput.setAttribute( \"type\", \"radio\" );\n\t\tinput.setAttribute( \"checked\", \"checked\" );\n\t\tinput.setAttribute( \"name\", \"t\" );\n\n\t\tdiv.appendChild( input );\n\n\t\t// Support: Safari 5.1, iOS 5.1, Android 4.x, Android 2.3\n\t\t// old WebKit doesn't clone checked state correctly in fragments\n\t\tsupport.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;\n\n\t\t// Support: IE<9\n\t\t// Cloned elements keep attachEvent handlers, we use addEventListener on IE9+\n\t\tsupport.noCloneEvent = !!div.addEventListener;\n\n\t\t// Support: IE<9\n\t\t// Since attributes and properties are the same in IE,\n\t\t// cleanData must set properties to undefined rather than use removeAttribute\n\t\tdiv[ jQuery.expando ] = 1;\n\t\tsupport.attributes = !div.getAttribute( jQuery.expando );\n\t} )();\n\n\n// We have to close these tags to support XHTML (#13200)\n\tvar wrapMap = {\n\t\toption: [ 1, \"<select multiple='multiple'>\", \"</select>\" ],\n\t\tlegend: [ 1, \"<fieldset>\", \"</fieldset>\" ],\n\t\tarea: [ 1, \"<map>\", \"</map>\" ],\n\n\t\t// Support: IE8\n\t\tparam: [ 1, \"<object>\", \"</object>\" ],\n\t\tthead: [ 1, \"<table>\", \"</table>\" ],\n\t\ttr: [ 2, \"<table><tbody>\", \"</tbody></table>\" ],\n\t\tcol: [ 2, \"<table><tbody></tbody><colgroup>\", \"</colgroup></table>\" ],\n\t\ttd: [ 3, \"<table><tbody><tr>\", \"</tr></tbody></table>\" ],\n\n\t\t// IE6-8 can't serialize link, script, style, or any html5 (NoScope) tags,\n\t\t// unless wrapped in a div with non-breaking characters in front of it.\n\t\t_default: support.htmlSerialize ? [ 0, \"\", \"\" ] : [ 1, \"X<div>\", \"</div>\" ]\n\t};\n\n// Support: IE8-IE9\n\twrapMap.optgroup = wrapMap.option;\n\n\twrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;\n\twrapMap.th = wrapMap.td;\n\n\n\tfunction getAll( context, tag ) {\n\t\tvar elems, elem,\n\t\t\ti = 0,\n\t\t\tfound = typeof context.getElementsByTagName !== \"undefined\" ?\n\t\t\t\tcontext.getElementsByTagName( tag || \"*\" ) :\n\t\t\t\ttypeof context.querySelectorAll !== \"undefined\" ?\n\t\t\t\t\tcontext.querySelectorAll( tag || \"*\" ) :\n\t\t\t\t\tundefined;\n\n\t\tif ( !found ) {\n\t\t\tfor ( found = [], elems = context.childNodes || context;\n\t\t\t\t  ( elem = elems[ i ] ) != null;\n\t\t\t\t  i++\n\t\t\t) {\n\t\t\t\tif ( !tag || jQuery.nodeName( elem, tag ) ) {\n\t\t\t\t\tfound.push( elem );\n\t\t\t\t} else {\n\t\t\t\t\tjQuery.merge( found, getAll( elem, tag ) );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn tag === undefined || tag && jQuery.nodeName( context, tag ) ?\n\t\t\tjQuery.merge( [ context ], found ) :\n\t\t\tfound;\n\t}\n\n\n// Mark scripts as having already been evaluated\n\tfunction setGlobalEval( elems, refElements ) {\n\t\tvar elem,\n\t\t\ti = 0;\n\t\tfor ( ; ( elem = elems[ i ] ) != null; i++ ) {\n\t\t\tjQuery._data(\n\t\t\t\telem,\n\t\t\t\t\"globalEval\",\n\t\t\t\t!refElements || jQuery._data( refElements[ i ], \"globalEval\" )\n\t\t\t);\n\t\t}\n\t}\n\n\n\tvar rhtml = /<|&#?\\w+;/,\n\t\trtbody = /<tbody/i;\n\n\tfunction fixDefaultChecked( elem ) {\n\t\tif ( rcheckableType.test( elem.type ) ) {\n\t\t\telem.defaultChecked = elem.checked;\n\t\t}\n\t}\n\n\tfunction buildFragment( elems, context, scripts, selection, ignored ) {\n\t\tvar j, elem, contains,\n\t\t\ttmp, tag, tbody, wrap,\n\t\t\tl = elems.length,\n\n\t\t\t// Ensure a safe fragment\n\t\t\tsafe = createSafeFragment( context ),\n\n\t\t\tnodes = [],\n\t\t\ti = 0;\n\n\t\tfor ( ; i < l; i++ ) {\n\t\t\telem = elems[ i ];\n\n\t\t\tif ( elem || elem === 0 ) {\n\n\t\t\t\t// Add nodes directly\n\t\t\t\tif ( jQuery.type( elem ) === \"object\" ) {\n\t\t\t\t\tjQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );\n\n\t\t\t\t\t// Convert non-html into a text node\n\t\t\t\t} else if ( !rhtml.test( elem ) ) {\n\t\t\t\t\tnodes.push( context.createTextNode( elem ) );\n\n\t\t\t\t\t// Convert html into DOM nodes\n\t\t\t\t} else {\n\t\t\t\t\ttmp = tmp || safe.appendChild( context.createElement( \"div\" ) );\n\n\t\t\t\t\t// Deserialize a standard representation\n\t\t\t\t\ttag = ( rtagName.exec( elem ) || [ \"\", \"\" ] )[ 1 ].toLowerCase();\n\t\t\t\t\twrap = wrapMap[ tag ] || wrapMap._default;\n\n\t\t\t\t\ttmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];\n\n\t\t\t\t\t// Descend through wrappers to the right content\n\t\t\t\t\tj = wrap[ 0 ];\n\t\t\t\t\twhile ( j-- ) {\n\t\t\t\t\t\ttmp = tmp.lastChild;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Manually add leading whitespace removed by IE\n\t\t\t\t\tif ( !support.leadingWhitespace && rleadingWhitespace.test( elem ) ) {\n\t\t\t\t\t\tnodes.push( context.createTextNode( rleadingWhitespace.exec( elem )[ 0 ] ) );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove IE's autoinserted <tbody> from table fragments\n\t\t\t\t\tif ( !support.tbody ) {\n\n\t\t\t\t\t\t// String was a <table>, *may* have spurious <tbody>\n\t\t\t\t\t\telem = tag === \"table\" && !rtbody.test( elem ) ?\n\t\t\t\t\t\t\ttmp.firstChild :\n\n\t\t\t\t\t\t\t// String was a bare <thead> or <tfoot>\n\t\t\t\t\t\t\twrap[ 1 ] === \"<table>\" && !rtbody.test( elem ) ?\n\t\t\t\t\t\t\t\ttmp :\n\t\t\t\t\t\t\t\t0;\n\n\t\t\t\t\t\tj = elem && elem.childNodes.length;\n\t\t\t\t\t\twhile ( j-- ) {\n\t\t\t\t\t\t\tif ( jQuery.nodeName( ( tbody = elem.childNodes[ j ] ), \"tbody\" ) &&\n\t\t\t\t\t\t\t\t!tbody.childNodes.length ) {\n\n\t\t\t\t\t\t\t\telem.removeChild( tbody );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tjQuery.merge( nodes, tmp.childNodes );\n\n\t\t\t\t\t// Fix #12392 for WebKit and IE > 9\n\t\t\t\t\ttmp.textContent = \"\";\n\n\t\t\t\t\t// Fix #12392 for oldIE\n\t\t\t\t\twhile ( tmp.firstChild ) {\n\t\t\t\t\t\ttmp.removeChild( tmp.firstChild );\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remember the top-level container for proper cleanup\n\t\t\t\t\ttmp = safe.lastChild;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Fix #11356: Clear elements from fragment\n\t\tif ( tmp ) {\n\t\t\tsafe.removeChild( tmp );\n\t\t}\n\n\t\t// Reset defaultChecked for any radios and checkboxes\n\t\t// about to be appended to the DOM in IE 6/7 (#8060)\n\t\tif ( !support.appendChecked ) {\n\t\t\tjQuery.grep( getAll( nodes, \"input\" ), fixDefaultChecked );\n\t\t}\n\n\t\ti = 0;\n\t\twhile ( ( elem = nodes[ i++ ] ) ) {\n\n\t\t\t// Skip elements already in the context collection (trac-4087)\n\t\t\tif ( selection && jQuery.inArray( elem, selection ) > -1 ) {\n\t\t\t\tif ( ignored ) {\n\t\t\t\t\tignored.push( elem );\n\t\t\t\t}\n\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tcontains = jQuery.contains( elem.ownerDocument, elem );\n\n\t\t\t// Append to fragment\n\t\t\ttmp = getAll( safe.appendChild( elem ), \"script\" );\n\n\t\t\t// Preserve script evaluation history\n\t\t\tif ( contains ) {\n\t\t\t\tsetGlobalEval( tmp );\n\t\t\t}\n\n\t\t\t// Capture executables\n\t\t\tif ( scripts ) {\n\t\t\t\tj = 0;\n\t\t\t\twhile ( ( elem = tmp[ j++ ] ) ) {\n\t\t\t\t\tif ( rscriptType.test( elem.type || \"\" ) ) {\n\t\t\t\t\t\tscripts.push( elem );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\ttmp = null;\n\n\t\treturn safe;\n\t}\n\n\n\t( function() {\n\t\tvar i, eventName,\n\t\t\tdiv = document.createElement( \"div\" );\n\n\t\t// Support: IE<9 (lack submit/change bubble), Firefox (lack focus(in | out) events)\n\t\tfor ( i in { submit: true, change: true, focusin: true } ) {\n\t\t\teventName = \"on\" + i;\n\n\t\t\tif ( !( support[ i ] = eventName in window ) ) {\n\n\t\t\t\t// Beware of CSP restrictions (https://developer.mozilla.org/en/Security/CSP)\n\t\t\t\tdiv.setAttribute( eventName, \"t\" );\n\t\t\t\tsupport[ i ] = div.attributes[ eventName ].expando === false;\n\t\t\t}\n\t\t}\n\n\t\t// Null elements to avoid leaks in IE.\n\t\tdiv = null;\n\t} )();\n\n\n\tvar rformElems = /^(?:input|select|textarea)$/i,\n\t\trkeyEvent = /^key/,\n\t\trmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,\n\t\trfocusMorph = /^(?:focusinfocus|focusoutblur)$/,\n\t\trtypenamespace = /^([^.]*)(?:\\.(.+)|)/;\n\n\tfunction returnTrue() {\n\t\treturn true;\n\t}\n\n\tfunction returnFalse() {\n\t\treturn false;\n\t}\n\n// Support: IE9\n// See #13393 for more info\n\tfunction safeActiveElement() {\n\t\ttry {\n\t\t\treturn document.activeElement;\n\t\t} catch ( err ) { }\n\t}\n\n\tfunction on( elem, types, selector, data, fn, one ) {\n\t\tvar origFn, type;\n\n\t\t// Types can be a map of types/handlers\n\t\tif ( typeof types === \"object\" ) {\n\n\t\t\t// ( types-Object, selector, data )\n\t\t\tif ( typeof selector !== \"string\" ) {\n\n\t\t\t\t// ( types-Object, data )\n\t\t\t\tdata = data || selector;\n\t\t\t\tselector = undefined;\n\t\t\t}\n\t\t\tfor ( type in types ) {\n\t\t\t\ton( elem, type, selector, data, types[ type ], one );\n\t\t\t}\n\t\t\treturn elem;\n\t\t}\n\n\t\tif ( data == null && fn == null ) {\n\n\t\t\t// ( types, fn )\n\t\t\tfn = selector;\n\t\t\tdata = selector = undefined;\n\t\t} else if ( fn == null ) {\n\t\t\tif ( typeof selector === \"string\" ) {\n\n\t\t\t\t// ( types, selector, fn )\n\t\t\t\tfn = data;\n\t\t\t\tdata = undefined;\n\t\t\t} else {\n\n\t\t\t\t// ( types, data, fn )\n\t\t\t\tfn = data;\n\t\t\t\tdata = selector;\n\t\t\t\tselector = undefined;\n\t\t\t}\n\t\t}\n\t\tif ( fn === false ) {\n\t\t\tfn = returnFalse;\n\t\t} else if ( !fn ) {\n\t\t\treturn elem;\n\t\t}\n\n\t\tif ( one === 1 ) {\n\t\t\torigFn = fn;\n\t\t\tfn = function( event ) {\n\n\t\t\t\t// Can use an empty set, since event contains the info\n\t\t\t\tjQuery().off( event );\n\t\t\t\treturn origFn.apply( this, arguments );\n\t\t\t};\n\n\t\t\t// Use same guid so caller can remove using origFn\n\t\t\tfn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );\n\t\t}\n\t\treturn elem.each( function() {\n\t\t\tjQuery.event.add( this, types, fn, data, selector );\n\t\t} );\n\t}\n\n\t/*\n\t * Helper functions for managing events -- not part of the public interface.\n\t * Props to Dean Edwards' addEvent library for many of the ideas.\n\t */\n\tjQuery.event = {\n\n\t\tglobal: {},\n\n\t\tadd: function( elem, types, handler, data, selector ) {\n\t\t\tvar tmp, events, t, handleObjIn,\n\t\t\t\tspecial, eventHandle, handleObj,\n\t\t\t\thandlers, type, namespaces, origType,\n\t\t\t\telemData = jQuery._data( elem );\n\n\t\t\t// Don't attach events to noData or text/comment nodes (but allow plain objects)\n\t\t\tif ( !elemData ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Caller can pass in an object of custom data in lieu of the handler\n\t\t\tif ( handler.handler ) {\n\t\t\t\thandleObjIn = handler;\n\t\t\t\thandler = handleObjIn.handler;\n\t\t\t\tselector = handleObjIn.selector;\n\t\t\t}\n\n\t\t\t// Make sure that the handler has a unique ID, used to find/remove it later\n\t\t\tif ( !handler.guid ) {\n\t\t\t\thandler.guid = jQuery.guid++;\n\t\t\t}\n\n\t\t\t// Init the element's event structure and main handler, if this is the first\n\t\t\tif ( !( events = elemData.events ) ) {\n\t\t\t\tevents = elemData.events = {};\n\t\t\t}\n\t\t\tif ( !( eventHandle = elemData.handle ) ) {\n\t\t\t\teventHandle = elemData.handle = function( e ) {\n\n\t\t\t\t\t// Discard the second event of a jQuery.event.trigger() and\n\t\t\t\t\t// when an event is called after a page has unloaded\n\t\t\t\t\treturn typeof jQuery !== \"undefined\" &&\n\t\t\t\t\t( !e || jQuery.event.triggered !== e.type ) ?\n\t\t\t\t\t\tjQuery.event.dispatch.apply( eventHandle.elem, arguments ) :\n\t\t\t\t\t\tundefined;\n\t\t\t\t};\n\n\t\t\t\t// Add elem as a property of the handle fn to prevent a memory leak\n\t\t\t\t// with IE non-native events\n\t\t\t\teventHandle.elem = elem;\n\t\t\t}\n\n\t\t\t// Handle multiple events separated by a space\n\t\t\ttypes = ( types || \"\" ).match( rnotwhite ) || [ \"\" ];\n\t\t\tt = types.length;\n\t\t\twhile ( t-- ) {\n\t\t\t\ttmp = rtypenamespace.exec( types[ t ] ) || [];\n\t\t\t\ttype = origType = tmp[ 1 ];\n\t\t\t\tnamespaces = ( tmp[ 2 ] || \"\" ).split( \".\" ).sort();\n\n\t\t\t\t// There *must* be a type, no attaching namespace-only handlers\n\t\t\t\tif ( !type ) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\t// If event changes its type, use the special event handlers for the changed type\n\t\t\t\tspecial = jQuery.event.special[ type ] || {};\n\n\t\t\t\t// If selector defined, determine special event api type, otherwise given type\n\t\t\t\ttype = ( selector ? special.delegateType : special.bindType ) || type;\n\n\t\t\t\t// Update special based on newly reset type\n\t\t\t\tspecial = jQuery.event.special[ type ] || {};\n\n\t\t\t\t// handleObj is passed to all event handlers\n\t\t\t\thandleObj = jQuery.extend( {\n\t\t\t\t\ttype: type,\n\t\t\t\t\torigType: origType,\n\t\t\t\t\tdata: data,\n\t\t\t\t\thandler: handler,\n\t\t\t\t\tguid: handler.guid,\n\t\t\t\t\tselector: selector,\n\t\t\t\t\tneedsContext: selector && jQuery.expr.match.needsContext.test( selector ),\n\t\t\t\t\tnamespace: namespaces.join( \".\" )\n\t\t\t\t}, handleObjIn );\n\n\t\t\t\t// Init the event handler queue if we're the first\n\t\t\t\tif ( !( handlers = events[ type ] ) ) {\n\t\t\t\t\thandlers = events[ type ] = [];\n\t\t\t\t\thandlers.delegateCount = 0;\n\n\t\t\t\t\t// Only use addEventListener/attachEvent if the special events handler returns false\n\t\t\t\t\tif ( !special.setup ||\n\t\t\t\t\t\tspecial.setup.call( elem, data, namespaces, eventHandle ) === false ) {\n\n\t\t\t\t\t\t// Bind the global event handler to the element\n\t\t\t\t\t\tif ( elem.addEventListener ) {\n\t\t\t\t\t\t\telem.addEventListener( type, eventHandle, false );\n\n\t\t\t\t\t\t} else if ( elem.attachEvent ) {\n\t\t\t\t\t\t\telem.attachEvent( \"on\" + type, eventHandle );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( special.add ) {\n\t\t\t\t\tspecial.add.call( elem, handleObj );\n\n\t\t\t\t\tif ( !handleObj.handler.guid ) {\n\t\t\t\t\t\thandleObj.handler.guid = handler.guid;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Add to the element's handler list, delegates in front\n\t\t\t\tif ( selector ) {\n\t\t\t\t\thandlers.splice( handlers.delegateCount++, 0, handleObj );\n\t\t\t\t} else {\n\t\t\t\t\thandlers.push( handleObj );\n\t\t\t\t}\n\n\t\t\t\t// Keep track of which events have ever been used, for event optimization\n\t\t\t\tjQuery.event.global[ type ] = true;\n\t\t\t}\n\n\t\t\t// Nullify elem to prevent memory leaks in IE\n\t\t\telem = null;\n\t\t},\n\n\t\t// Detach an event or set of events from an element\n\t\tremove: function( elem, types, handler, selector, mappedTypes ) {\n\t\t\tvar j, handleObj, tmp,\n\t\t\t\torigCount, t, events,\n\t\t\t\tspecial, handlers, type,\n\t\t\t\tnamespaces, origType,\n\t\t\t\telemData = jQuery.hasData( elem ) && jQuery._data( elem );\n\n\t\t\tif ( !elemData || !( events = elemData.events ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Once for each type.namespace in types; type may be omitted\n\t\t\ttypes = ( types || \"\" ).match( rnotwhite ) || [ \"\" ];\n\t\t\tt = types.length;\n\t\t\twhile ( t-- ) {\n\t\t\t\ttmp = rtypenamespace.exec( types[ t ] ) || [];\n\t\t\t\ttype = origType = tmp[ 1 ];\n\t\t\t\tnamespaces = ( tmp[ 2 ] || \"\" ).split( \".\" ).sort();\n\n\t\t\t\t// Unbind all events (on this namespace, if provided) for the element\n\t\t\t\tif ( !type ) {\n\t\t\t\t\tfor ( type in events ) {\n\t\t\t\t\t\tjQuery.event.remove( elem, type + types[ t ], handler, selector, true );\n\t\t\t\t\t}\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\tspecial = jQuery.event.special[ type ] || {};\n\t\t\t\ttype = ( selector ? special.delegateType : special.bindType ) || type;\n\t\t\t\thandlers = events[ type ] || [];\n\t\t\t\ttmp = tmp[ 2 ] &&\n\t\t\t\t\tnew RegExp( \"(^|\\\\.)\" + namespaces.join( \"\\\\.(?:.*\\\\.|)\" ) + \"(\\\\.|$)\" );\n\n\t\t\t\t// Remove matching events\n\t\t\t\torigCount = j = handlers.length;\n\t\t\t\twhile ( j-- ) {\n\t\t\t\t\thandleObj = handlers[ j ];\n\n\t\t\t\t\tif ( ( mappedTypes || origType === handleObj.origType ) &&\n\t\t\t\t\t\t( !handler || handler.guid === handleObj.guid ) &&\n\t\t\t\t\t\t( !tmp || tmp.test( handleObj.namespace ) ) &&\n\t\t\t\t\t\t( !selector || selector === handleObj.selector ||\n\t\t\t\t\t\tselector === \"**\" && handleObj.selector ) ) {\n\t\t\t\t\t\thandlers.splice( j, 1 );\n\n\t\t\t\t\t\tif ( handleObj.selector ) {\n\t\t\t\t\t\t\thandlers.delegateCount--;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( special.remove ) {\n\t\t\t\t\t\t\tspecial.remove.call( elem, handleObj );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Remove generic event handler if we removed something and no more handlers exist\n\t\t\t\t// (avoids potential for endless recursion during removal of special event handlers)\n\t\t\t\tif ( origCount && !handlers.length ) {\n\t\t\t\t\tif ( !special.teardown ||\n\t\t\t\t\t\tspecial.teardown.call( elem, namespaces, elemData.handle ) === false ) {\n\n\t\t\t\t\t\tjQuery.removeEvent( elem, type, elemData.handle );\n\t\t\t\t\t}\n\n\t\t\t\t\tdelete events[ type ];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove the expando if it's no longer used\n\t\t\tif ( jQuery.isEmptyObject( events ) ) {\n\t\t\t\tdelete elemData.handle;\n\n\t\t\t\t// removeData also checks for emptiness and clears the expando if empty\n\t\t\t\t// so use it instead of delete\n\t\t\t\tjQuery._removeData( elem, \"events\" );\n\t\t\t}\n\t\t},\n\n\t\ttrigger: function( event, data, elem, onlyHandlers ) {\n\t\t\tvar handle, ontype, cur,\n\t\t\t\tbubbleType, special, tmp, i,\n\t\t\t\teventPath = [ elem || document ],\n\t\t\t\ttype = hasOwn.call( event, \"type\" ) ? event.type : event,\n\t\t\t\tnamespaces = hasOwn.call( event, \"namespace\" ) ? event.namespace.split( \".\" ) : [];\n\n\t\t\tcur = tmp = elem = elem || document;\n\n\t\t\t// Don't do events on text and comment nodes\n\t\t\tif ( elem.nodeType === 3 || elem.nodeType === 8 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// focus/blur morphs to focusin/out; ensure we're not firing them right now\n\t\t\tif ( rfocusMorph.test( type + jQuery.event.triggered ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( type.indexOf( \".\" ) > -1 ) {\n\n\t\t\t\t// Namespaced trigger; create a regexp to match event type in handle()\n\t\t\t\tnamespaces = type.split( \".\" );\n\t\t\t\ttype = namespaces.shift();\n\t\t\t\tnamespaces.sort();\n\t\t\t}\n\t\t\tontype = type.indexOf( \":\" ) < 0 && \"on\" + type;\n\n\t\t\t// Caller can pass in a jQuery.Event object, Object, or just an event type string\n\t\t\tevent = event[ jQuery.expando ] ?\n\t\t\t\tevent :\n\t\t\t\tnew jQuery.Event( type, typeof event === \"object\" && event );\n\n\t\t\t// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)\n\t\t\tevent.isTrigger = onlyHandlers ? 2 : 3;\n\t\t\tevent.namespace = namespaces.join( \".\" );\n\t\t\tevent.rnamespace = event.namespace ?\n\t\t\t\tnew RegExp( \"(^|\\\\.)\" + namespaces.join( \"\\\\.(?:.*\\\\.|)\" ) + \"(\\\\.|$)\" ) :\n\t\t\t\tnull;\n\n\t\t\t// Clean up the event in case it is being reused\n\t\t\tevent.result = undefined;\n\t\t\tif ( !event.target ) {\n\t\t\t\tevent.target = elem;\n\t\t\t}\n\n\t\t\t// Clone any incoming data and prepend the event, creating the handler arg list\n\t\t\tdata = data == null ?\n\t\t\t\t[ event ] :\n\t\t\t\tjQuery.makeArray( data, [ event ] );\n\n\t\t\t// Allow special events to draw outside the lines\n\t\t\tspecial = jQuery.event.special[ type ] || {};\n\t\t\tif ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Determine event propagation path in advance, per W3C events spec (#9951)\n\t\t\t// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)\n\t\t\tif ( !onlyHandlers && !special.noBubble && !jQuery.isWindow( elem ) ) {\n\n\t\t\t\tbubbleType = special.delegateType || type;\n\t\t\t\tif ( !rfocusMorph.test( bubbleType + type ) ) {\n\t\t\t\t\tcur = cur.parentNode;\n\t\t\t\t}\n\t\t\t\tfor ( ; cur; cur = cur.parentNode ) {\n\t\t\t\t\teventPath.push( cur );\n\t\t\t\t\ttmp = cur;\n\t\t\t\t}\n\n\t\t\t\t// Only add window if we got to document (e.g., not plain obj or detached DOM)\n\t\t\t\tif ( tmp === ( elem.ownerDocument || document ) ) {\n\t\t\t\t\teventPath.push( tmp.defaultView || tmp.parentWindow || window );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Fire handlers on the event path\n\t\t\ti = 0;\n\t\t\twhile ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {\n\n\t\t\t\tevent.type = i > 1 ?\n\t\t\t\t\tbubbleType :\n\t\t\t\tspecial.bindType || type;\n\n\t\t\t\t// jQuery handler\n\t\t\t\thandle = ( jQuery._data( cur, \"events\" ) || {} )[ event.type ] &&\n\t\t\t\t\tjQuery._data( cur, \"handle\" );\n\n\t\t\t\tif ( handle ) {\n\t\t\t\t\thandle.apply( cur, data );\n\t\t\t\t}\n\n\t\t\t\t// Native handler\n\t\t\t\thandle = ontype && cur[ ontype ];\n\t\t\t\tif ( handle && handle.apply && acceptData( cur ) ) {\n\t\t\t\t\tevent.result = handle.apply( cur, data );\n\t\t\t\t\tif ( event.result === false ) {\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tevent.type = type;\n\n\t\t\t// If nobody prevented the default action, do it now\n\t\t\tif ( !onlyHandlers && !event.isDefaultPrevented() ) {\n\n\t\t\t\tif (\n\t\t\t\t\t( !special._default ||\n\t\t\t\t\t\tspecial._default.apply( eventPath.pop(), data ) === false\n\t\t\t\t\t) && acceptData( elem )\n\t\t\t\t) {\n\n\t\t\t\t\t// Call a native DOM method on the target with the same name name as the event.\n\t\t\t\t\t// Can't use an .isFunction() check here because IE6/7 fails that test.\n\t\t\t\t\t// Don't do default actions on window, that's where global variables be (#6170)\n\t\t\t\t\tif ( ontype && elem[ type ] && !jQuery.isWindow( elem ) ) {\n\n\t\t\t\t\t\t// Don't re-trigger an onFOO event when we call its FOO() method\n\t\t\t\t\t\ttmp = elem[ ontype ];\n\n\t\t\t\t\t\tif ( tmp ) {\n\t\t\t\t\t\t\telem[ ontype ] = null;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Prevent re-triggering of the same event, since we already bubbled it above\n\t\t\t\t\t\tjQuery.event.triggered = type;\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\telem[ type ]();\n\t\t\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t\t\t// IE<9 dies on focus/blur to hidden element (#1486,#12518)\n\t\t\t\t\t\t\t// only reproducible on winXP IE8 native, not IE9 in IE8 mode\n\t\t\t\t\t\t}\n\t\t\t\t\t\tjQuery.event.triggered = undefined;\n\n\t\t\t\t\t\tif ( tmp ) {\n\t\t\t\t\t\t\telem[ ontype ] = tmp;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn event.result;\n\t\t},\n\n\t\tdispatch: function( event ) {\n\n\t\t\t// Make a writable jQuery.Event from the native event object\n\t\t\tevent = jQuery.event.fix( event );\n\n\t\t\tvar i, j, ret, matched, handleObj,\n\t\t\t\thandlerQueue = [],\n\t\t\t\targs = slice.call( arguments ),\n\t\t\t\thandlers = ( jQuery._data( this, \"events\" ) || {} )[ event.type ] || [],\n\t\t\t\tspecial = jQuery.event.special[ event.type ] || {};\n\n\t\t\t// Use the fix-ed jQuery.Event rather than the (read-only) native event\n\t\t\targs[ 0 ] = event;\n\t\t\tevent.delegateTarget = this;\n\n\t\t\t// Call the preDispatch hook for the mapped type, and let it bail if desired\n\t\t\tif ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Determine handlers\n\t\t\thandlerQueue = jQuery.event.handlers.call( this, event, handlers );\n\n\t\t\t// Run delegates first; they may want to stop propagation beneath us\n\t\t\ti = 0;\n\t\t\twhile ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {\n\t\t\t\tevent.currentTarget = matched.elem;\n\n\t\t\t\tj = 0;\n\t\t\t\twhile ( ( handleObj = matched.handlers[ j++ ] ) &&\n\t\t\t\t!event.isImmediatePropagationStopped() ) {\n\n\t\t\t\t\t// Triggered event must either 1) have no namespace, or 2) have namespace(s)\n\t\t\t\t\t// a subset or equal to those in the bound event (both can have no namespace).\n\t\t\t\t\tif ( !event.rnamespace || event.rnamespace.test( handleObj.namespace ) ) {\n\n\t\t\t\t\t\tevent.handleObj = handleObj;\n\t\t\t\t\t\tevent.data = handleObj.data;\n\n\t\t\t\t\t\tret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||\n\t\t\t\t\t\thandleObj.handler ).apply( matched.elem, args );\n\n\t\t\t\t\t\tif ( ret !== undefined ) {\n\t\t\t\t\t\t\tif ( ( event.result = ret ) === false ) {\n\t\t\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\t\t\tevent.stopPropagation();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Call the postDispatch hook for the mapped type\n\t\t\tif ( special.postDispatch ) {\n\t\t\t\tspecial.postDispatch.call( this, event );\n\t\t\t}\n\n\t\t\treturn event.result;\n\t\t},\n\n\t\thandlers: function( event, handlers ) {\n\t\t\tvar i, matches, sel, handleObj,\n\t\t\t\thandlerQueue = [],\n\t\t\t\tdelegateCount = handlers.delegateCount,\n\t\t\t\tcur = event.target;\n\n\t\t\t// Support (at least): Chrome, IE9\n\t\t\t// Find delegate handlers\n\t\t\t// Black-hole SVG <use> instance trees (#13180)\n\t\t\t//\n\t\t\t// Support: Firefox<=42+\n\t\t\t// Avoid non-left-click in FF but don't block IE radio events (#3861, gh-2343)\n\t\t\tif ( delegateCount && cur.nodeType &&\n\t\t\t\t( event.type !== \"click\" || isNaN( event.button ) || event.button < 1 ) ) {\n\n\t\t\t\t/* jshint eqeqeq: false */\n\t\t\t\tfor ( ; cur != this; cur = cur.parentNode || this ) {\n\t\t\t\t\t/* jshint eqeqeq: true */\n\n\t\t\t\t\t// Don't check non-elements (#13208)\n\t\t\t\t\t// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)\n\t\t\t\t\tif ( cur.nodeType === 1 && ( cur.disabled !== true || event.type !== \"click\" ) ) {\n\t\t\t\t\t\tmatches = [];\n\t\t\t\t\t\tfor ( i = 0; i < delegateCount; i++ ) {\n\t\t\t\t\t\t\thandleObj = handlers[ i ];\n\n\t\t\t\t\t\t\t// Don't conflict with Object.prototype properties (#13203)\n\t\t\t\t\t\t\tsel = handleObj.selector + \" \";\n\n\t\t\t\t\t\t\tif ( matches[ sel ] === undefined ) {\n\t\t\t\t\t\t\t\tmatches[ sel ] = handleObj.needsContext ?\n\t\t\t\t\t\t\t\tjQuery( sel, this ).index( cur ) > -1 :\n\t\t\t\t\t\t\t\t\tjQuery.find( sel, this, null, [ cur ] ).length;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif ( matches[ sel ] ) {\n\t\t\t\t\t\t\t\tmatches.push( handleObj );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( matches.length ) {\n\t\t\t\t\t\t\thandlerQueue.push( { elem: cur, handlers: matches } );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Add the remaining (directly-bound) handlers\n\t\t\tif ( delegateCount < handlers.length ) {\n\t\t\t\thandlerQueue.push( { elem: this, handlers: handlers.slice( delegateCount ) } );\n\t\t\t}\n\n\t\t\treturn handlerQueue;\n\t\t},\n\n\t\tfix: function( event ) {\n\t\t\tif ( event[ jQuery.expando ] ) {\n\t\t\t\treturn event;\n\t\t\t}\n\n\t\t\t// Create a writable copy of the event object and normalize some properties\n\t\t\tvar i, prop, copy,\n\t\t\t\ttype = event.type,\n\t\t\t\toriginalEvent = event,\n\t\t\t\tfixHook = this.fixHooks[ type ];\n\n\t\t\tif ( !fixHook ) {\n\t\t\t\tthis.fixHooks[ type ] = fixHook =\n\t\t\t\t\trmouseEvent.test( type ) ? this.mouseHooks :\n\t\t\t\t\t\trkeyEvent.test( type ) ? this.keyHooks :\n\t\t\t\t\t\t{};\n\t\t\t}\n\t\t\tcopy = fixHook.props ? this.props.concat( fixHook.props ) : this.props;\n\n\t\t\tevent = new jQuery.Event( originalEvent );\n\n\t\t\ti = copy.length;\n\t\t\twhile ( i-- ) {\n\t\t\t\tprop = copy[ i ];\n\t\t\t\tevent[ prop ] = originalEvent[ prop ];\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// Fix target property (#1925)\n\t\t\tif ( !event.target ) {\n\t\t\t\tevent.target = originalEvent.srcElement || document;\n\t\t\t}\n\n\t\t\t// Support: Safari 6-8+\n\t\t\t// Target should not be a text node (#504, #13143)\n\t\t\tif ( event.target.nodeType === 3 ) {\n\t\t\t\tevent.target = event.target.parentNode;\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// For mouse/key events, metaKey==false if it's undefined (#3368, #11328)\n\t\t\tevent.metaKey = !!event.metaKey;\n\n\t\t\treturn fixHook.filter ? fixHook.filter( event, originalEvent ) : event;\n\t\t},\n\n\t\t// Includes some event props shared by KeyEvent and MouseEvent\n\t\tprops: ( \"altKey bubbles cancelable ctrlKey currentTarget detail eventPhase \" +\n\t\t\"metaKey relatedTarget shiftKey target timeStamp view which\" ).split( \" \" ),\n\n\t\tfixHooks: {},\n\n\t\tkeyHooks: {\n\t\t\tprops: \"char charCode key keyCode\".split( \" \" ),\n\t\t\tfilter: function( event, original ) {\n\n\t\t\t\t// Add which for key events\n\t\t\t\tif ( event.which == null ) {\n\t\t\t\t\tevent.which = original.charCode != null ? original.charCode : original.keyCode;\n\t\t\t\t}\n\n\t\t\t\treturn event;\n\t\t\t}\n\t\t},\n\n\t\tmouseHooks: {\n\t\t\tprops: ( \"button buttons clientX clientY fromElement offsetX offsetY \" +\n\t\t\t\"pageX pageY screenX screenY toElement\" ).split( \" \" ),\n\t\t\tfilter: function( event, original ) {\n\t\t\t\tvar body, eventDoc, doc,\n\t\t\t\t\tbutton = original.button,\n\t\t\t\t\tfromElement = original.fromElement;\n\n\t\t\t\t// Calculate pageX/Y if missing and clientX/Y available\n\t\t\t\tif ( event.pageX == null && original.clientX != null ) {\n\t\t\t\t\teventDoc = event.target.ownerDocument || document;\n\t\t\t\t\tdoc = eventDoc.documentElement;\n\t\t\t\t\tbody = eventDoc.body;\n\n\t\t\t\t\tevent.pageX = original.clientX +\n\t\t\t\t\t\t( doc && doc.scrollLeft || body && body.scrollLeft || 0 ) -\n\t\t\t\t\t\t( doc && doc.clientLeft || body && body.clientLeft || 0 );\n\t\t\t\t\tevent.pageY = original.clientY +\n\t\t\t\t\t\t( doc && doc.scrollTop  || body && body.scrollTop  || 0 ) -\n\t\t\t\t\t\t( doc && doc.clientTop  || body && body.clientTop  || 0 );\n\t\t\t\t}\n\n\t\t\t\t// Add relatedTarget, if necessary\n\t\t\t\tif ( !event.relatedTarget && fromElement ) {\n\t\t\t\t\tevent.relatedTarget = fromElement === event.target ?\n\t\t\t\t\t\toriginal.toElement :\n\t\t\t\t\t\tfromElement;\n\t\t\t\t}\n\n\t\t\t\t// Add which for click: 1 === left; 2 === middle; 3 === right\n\t\t\t\t// Note: button is not normalized, so don't use it\n\t\t\t\tif ( !event.which && button !== undefined ) {\n\t\t\t\t\tevent.which = ( button & 1 ? 1 : ( button & 2 ? 3 : ( button & 4 ? 2 : 0 ) ) );\n\t\t\t\t}\n\n\t\t\t\treturn event;\n\t\t\t}\n\t\t},\n\n\t\tspecial: {\n\t\t\tload: {\n\n\t\t\t\t// Prevent triggered image.load events from bubbling to window.load\n\t\t\t\tnoBubble: true\n\t\t\t},\n\t\t\tfocus: {\n\n\t\t\t\t// Fire native event if possible so blur/focus sequence is correct\n\t\t\t\ttrigger: function() {\n\t\t\t\t\tif ( this !== safeActiveElement() && this.focus ) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tthis.focus();\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// If we error on focus to hidden element (#1486, #12518),\n\t\t\t\t\t\t\t// let .trigger() run the handlers\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tdelegateType: \"focusin\"\n\t\t\t},\n\t\t\tblur: {\n\t\t\t\ttrigger: function() {\n\t\t\t\t\tif ( this === safeActiveElement() && this.blur ) {\n\t\t\t\t\t\tthis.blur();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tdelegateType: \"focusout\"\n\t\t\t},\n\t\t\tclick: {\n\n\t\t\t\t// For checkbox, fire native event so checked state will be right\n\t\t\t\ttrigger: function() {\n\t\t\t\t\tif ( jQuery.nodeName( this, \"input\" ) && this.type === \"checkbox\" && this.click ) {\n\t\t\t\t\t\tthis.click();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\t// For cross-browser consistency, don't fire native .click() on links\n\t\t\t\t_default: function( event ) {\n\t\t\t\t\treturn jQuery.nodeName( event.target, \"a\" );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tbeforeunload: {\n\t\t\t\tpostDispatch: function( event ) {\n\n\t\t\t\t\t// Support: Firefox 20+\n\t\t\t\t\t// Firefox doesn't alert if the returnValue field is not set.\n\t\t\t\t\tif ( event.result !== undefined && event.originalEvent ) {\n\t\t\t\t\t\tevent.originalEvent.returnValue = event.result;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t// Piggyback on a donor event to simulate a different one\n\t\tsimulate: function( type, elem, event ) {\n\t\t\tvar e = jQuery.extend(\n\t\t\t\tnew jQuery.Event(),\n\t\t\t\tevent,\n\t\t\t\t{\n\t\t\t\t\ttype: type,\n\t\t\t\t\tisSimulated: true\n\n\t\t\t\t\t// Previously, `originalEvent: {}` was set here, so stopPropagation call\n\t\t\t\t\t// would not be triggered on donor event, since in our own\n\t\t\t\t\t// jQuery.event.stopPropagation function we had a check for existence of\n\t\t\t\t\t// originalEvent.stopPropagation method, so, consequently it would be a noop.\n\t\t\t\t\t//\n\t\t\t\t\t// Guard for simulated events was moved to jQuery.event.stopPropagation function\n\t\t\t\t\t// since `originalEvent` should point to the original event for the\n\t\t\t\t\t// constancy with other events and for more focused logic\n\t\t\t\t}\n\t\t\t);\n\n\t\t\tjQuery.event.trigger( e, null, elem );\n\n\t\t\tif ( e.isDefaultPrevented() ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t}\n\t\t}\n\t};\n\n\tjQuery.removeEvent = document.removeEventListener ?\n\t\tfunction( elem, type, handle ) {\n\n\t\t\t// This \"if\" is needed for plain objects\n\t\t\tif ( elem.removeEventListener ) {\n\t\t\t\telem.removeEventListener( type, handle );\n\t\t\t}\n\t\t} :\n\t\tfunction( elem, type, handle ) {\n\t\t\tvar name = \"on\" + type;\n\n\t\t\tif ( elem.detachEvent ) {\n\n\t\t\t\t// #8545, #7054, preventing memory leaks for custom events in IE6-8\n\t\t\t\t// detachEvent needed property on element, by name of that event,\n\t\t\t\t// to properly expose it to GC\n\t\t\t\tif ( typeof elem[ name ] === \"undefined\" ) {\n\t\t\t\t\telem[ name ] = null;\n\t\t\t\t}\n\n\t\t\t\telem.detachEvent( name, handle );\n\t\t\t}\n\t\t};\n\n\tjQuery.Event = function( src, props ) {\n\n\t\t// Allow instantiation without the 'new' keyword\n\t\tif ( !( this instanceof jQuery.Event ) ) {\n\t\t\treturn new jQuery.Event( src, props );\n\t\t}\n\n\t\t// Event object\n\t\tif ( src && src.type ) {\n\t\t\tthis.originalEvent = src;\n\t\t\tthis.type = src.type;\n\n\t\t\t// Events bubbling up the document may have been marked as prevented\n\t\t\t// by a handler lower down the tree; reflect the correct value.\n\t\t\tthis.isDefaultPrevented = src.defaultPrevented ||\n\t\t\tsrc.defaultPrevented === undefined &&\n\n\t\t\t// Support: IE < 9, Android < 4.0\n\t\t\tsrc.returnValue === false ?\n\t\t\t\treturnTrue :\n\t\t\t\treturnFalse;\n\n\t\t\t// Event type\n\t\t} else {\n\t\t\tthis.type = src;\n\t\t}\n\n\t\t// Put explicitly provided properties onto the event object\n\t\tif ( props ) {\n\t\t\tjQuery.extend( this, props );\n\t\t}\n\n\t\t// Create a timestamp if incoming event doesn't have one\n\t\tthis.timeStamp = src && src.timeStamp || jQuery.now();\n\n\t\t// Mark it as fixed\n\t\tthis[ jQuery.expando ] = true;\n\t};\n\n// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding\n// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html\n\tjQuery.Event.prototype = {\n\t\tconstructor: jQuery.Event,\n\t\tisDefaultPrevented: returnFalse,\n\t\tisPropagationStopped: returnFalse,\n\t\tisImmediatePropagationStopped: returnFalse,\n\n\t\tpreventDefault: function() {\n\t\t\tvar e = this.originalEvent;\n\n\t\t\tthis.isDefaultPrevented = returnTrue;\n\t\t\tif ( !e ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// If preventDefault exists, run it on the original event\n\t\t\tif ( e.preventDefault ) {\n\t\t\t\te.preventDefault();\n\n\t\t\t\t// Support: IE\n\t\t\t\t// Otherwise set the returnValue property of the original event to false\n\t\t\t} else {\n\t\t\t\te.returnValue = false;\n\t\t\t}\n\t\t},\n\t\tstopPropagation: function() {\n\t\t\tvar e = this.originalEvent;\n\n\t\t\tthis.isPropagationStopped = returnTrue;\n\n\t\t\tif ( !e || this.isSimulated ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// If stopPropagation exists, run it on the original event\n\t\t\tif ( e.stopPropagation ) {\n\t\t\t\te.stopPropagation();\n\t\t\t}\n\n\t\t\t// Support: IE\n\t\t\t// Set the cancelBubble property of the original event to true\n\t\t\te.cancelBubble = true;\n\t\t},\n\t\tstopImmediatePropagation: function() {\n\t\t\tvar e = this.originalEvent;\n\n\t\t\tthis.isImmediatePropagationStopped = returnTrue;\n\n\t\t\tif ( e && e.stopImmediatePropagation ) {\n\t\t\t\te.stopImmediatePropagation();\n\t\t\t}\n\n\t\t\tthis.stopPropagation();\n\t\t}\n\t};\n\n// Create mouseenter/leave events using mouseover/out and event-time checks\n// so that event delegation works in jQuery.\n// Do the same for pointerenter/pointerleave and pointerover/pointerout\n//\n// Support: Safari 7 only\n// Safari sends mouseenter too often; see:\n// https://code.google.com/p/chromium/issues/detail?id=470258\n// for the description of the bug (it existed in older Chrome versions as well).\n\tjQuery.each( {\n\t\tmouseenter: \"mouseover\",\n\t\tmouseleave: \"mouseout\",\n\t\tpointerenter: \"pointerover\",\n\t\tpointerleave: \"pointerout\"\n\t}, function( orig, fix ) {\n\t\tjQuery.event.special[ orig ] = {\n\t\t\tdelegateType: fix,\n\t\t\tbindType: fix,\n\n\t\t\thandle: function( event ) {\n\t\t\t\tvar ret,\n\t\t\t\t\ttarget = this,\n\t\t\t\t\trelated = event.relatedTarget,\n\t\t\t\t\thandleObj = event.handleObj;\n\n\t\t\t\t// For mouseenter/leave call the handler if related is outside the target.\n\t\t\t\t// NB: No relatedTarget if the mouse left/entered the browser window\n\t\t\t\tif ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {\n\t\t\t\t\tevent.type = handleObj.origType;\n\t\t\t\t\tret = handleObj.handler.apply( this, arguments );\n\t\t\t\t\tevent.type = fix;\n\t\t\t\t}\n\t\t\t\treturn ret;\n\t\t\t}\n\t\t};\n\t} );\n\n// IE submit delegation\n\tif ( !support.submit ) {\n\n\t\tjQuery.event.special.submit = {\n\t\t\tsetup: function() {\n\n\t\t\t\t// Only need this for delegated form submit events\n\t\t\t\tif ( jQuery.nodeName( this, \"form\" ) ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\t// Lazy-add a submit handler when a descendant form may potentially be submitted\n\t\t\t\tjQuery.event.add( this, \"click._submit keypress._submit\", function( e ) {\n\n\t\t\t\t\t// Node name check avoids a VML-related crash in IE (#9807)\n\t\t\t\t\tvar elem = e.target,\n\t\t\t\t\t\tform = jQuery.nodeName( elem, \"input\" ) || jQuery.nodeName( elem, \"button\" ) ?\n\n\t\t\t\t\t\t\t// Support: IE <=8\n\t\t\t\t\t\t\t// We use jQuery.prop instead of elem.form\n\t\t\t\t\t\t\t// to allow fixing the IE8 delegated submit issue (gh-2332)\n\t\t\t\t\t\t\t// by 3rd party polyfills/workarounds.\n\t\t\t\t\t\t\tjQuery.prop( elem, \"form\" ) :\n\t\t\t\t\t\t\tundefined;\n\n\t\t\t\t\tif ( form && !jQuery._data( form, \"submit\" ) ) {\n\t\t\t\t\t\tjQuery.event.add( form, \"submit._submit\", function( event ) {\n\t\t\t\t\t\t\tevent._submitBubble = true;\n\t\t\t\t\t\t} );\n\t\t\t\t\t\tjQuery._data( form, \"submit\", true );\n\t\t\t\t\t}\n\t\t\t\t} );\n\n\t\t\t\t// return undefined since we don't need an event listener\n\t\t\t},\n\n\t\t\tpostDispatch: function( event ) {\n\n\t\t\t\t// If form was submitted by the user, bubble the event up the tree\n\t\t\t\tif ( event._submitBubble ) {\n\t\t\t\t\tdelete event._submitBubble;\n\t\t\t\t\tif ( this.parentNode && !event.isTrigger ) {\n\t\t\t\t\t\tjQuery.event.simulate( \"submit\", this.parentNode, event );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tteardown: function() {\n\n\t\t\t\t// Only need this for delegated form submit events\n\t\t\t\tif ( jQuery.nodeName( this, \"form\" ) ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\t// Remove delegated handlers; cleanData eventually reaps submit handlers attached above\n\t\t\t\tjQuery.event.remove( this, \"._submit\" );\n\t\t\t}\n\t\t};\n\t}\n\n// IE change delegation and checkbox/radio fix\n\tif ( !support.change ) {\n\n\t\tjQuery.event.special.change = {\n\n\t\t\tsetup: function() {\n\n\t\t\t\tif ( rformElems.test( this.nodeName ) ) {\n\n\t\t\t\t\t// IE doesn't fire change on a check/radio until blur; trigger it on click\n\t\t\t\t\t// after a propertychange. Eat the blur-change in special.change.handle.\n\t\t\t\t\t// This still fires onchange a second time for check/radio after blur.\n\t\t\t\t\tif ( this.type === \"checkbox\" || this.type === \"radio\" ) {\n\t\t\t\t\t\tjQuery.event.add( this, \"propertychange._change\", function( event ) {\n\t\t\t\t\t\t\tif ( event.originalEvent.propertyName === \"checked\" ) {\n\t\t\t\t\t\t\t\tthis._justChanged = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} );\n\t\t\t\t\t\tjQuery.event.add( this, \"click._change\", function( event ) {\n\t\t\t\t\t\t\tif ( this._justChanged && !event.isTrigger ) {\n\t\t\t\t\t\t\t\tthis._justChanged = false;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Allow triggered, simulated change events (#11500)\n\t\t\t\t\t\t\tjQuery.event.simulate( \"change\", this, event );\n\t\t\t\t\t\t} );\n\t\t\t\t\t}\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\t// Delegated event; lazy-add a change handler on descendant inputs\n\t\t\t\tjQuery.event.add( this, \"beforeactivate._change\", function( e ) {\n\t\t\t\t\tvar elem = e.target;\n\n\t\t\t\t\tif ( rformElems.test( elem.nodeName ) && !jQuery._data( elem, \"change\" ) ) {\n\t\t\t\t\t\tjQuery.event.add( elem, \"change._change\", function( event ) {\n\t\t\t\t\t\t\tif ( this.parentNode && !event.isSimulated && !event.isTrigger ) {\n\t\t\t\t\t\t\t\tjQuery.event.simulate( \"change\", this.parentNode, event );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} );\n\t\t\t\t\t\tjQuery._data( elem, \"change\", true );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t},\n\n\t\t\thandle: function( event ) {\n\t\t\t\tvar elem = event.target;\n\n\t\t\t\t// Swallow native change events from checkbox/radio, we already triggered them above\n\t\t\t\tif ( this !== elem || event.isSimulated || event.isTrigger ||\n\t\t\t\t\t( elem.type !== \"radio\" && elem.type !== \"checkbox\" ) ) {\n\n\t\t\t\t\treturn event.handleObj.handler.apply( this, arguments );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tteardown: function() {\n\t\t\t\tjQuery.event.remove( this, \"._change\" );\n\n\t\t\t\treturn !rformElems.test( this.nodeName );\n\t\t\t}\n\t\t};\n\t}\n\n// Support: Firefox\n// Firefox doesn't have focus(in | out) events\n// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787\n//\n// Support: Chrome, Safari\n// focus(in | out) events fire after focus & blur events,\n// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order\n// Related ticket - https://code.google.com/p/chromium/issues/detail?id=449857\n\tif ( !support.focusin ) {\n\t\tjQuery.each( { focus: \"focusin\", blur: \"focusout\" }, function( orig, fix ) {\n\n\t\t\t// Attach a single capturing handler on the document while someone wants focusin/focusout\n\t\t\tvar handler = function( event ) {\n\t\t\t\tjQuery.event.simulate( fix, event.target, jQuery.event.fix( event ) );\n\t\t\t};\n\n\t\t\tjQuery.event.special[ fix ] = {\n\t\t\t\tsetup: function() {\n\t\t\t\t\tvar doc = this.ownerDocument || this,\n\t\t\t\t\t\tattaches = jQuery._data( doc, fix );\n\n\t\t\t\t\tif ( !attaches ) {\n\t\t\t\t\t\tdoc.addEventListener( orig, handler, true );\n\t\t\t\t\t}\n\t\t\t\t\tjQuery._data( doc, fix, ( attaches || 0 ) + 1 );\n\t\t\t\t},\n\t\t\t\tteardown: function() {\n\t\t\t\t\tvar doc = this.ownerDocument || this,\n\t\t\t\t\t\tattaches = jQuery._data( doc, fix ) - 1;\n\n\t\t\t\t\tif ( !attaches ) {\n\t\t\t\t\t\tdoc.removeEventListener( orig, handler, true );\n\t\t\t\t\t\tjQuery._removeData( doc, fix );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tjQuery._data( doc, fix, attaches );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t} );\n\t}\n\n\tjQuery.fn.extend( {\n\n\t\ton: function( types, selector, data, fn ) {\n\t\t\treturn on( this, types, selector, data, fn );\n\t\t},\n\t\tone: function( types, selector, data, fn ) {\n\t\t\treturn on( this, types, selector, data, fn, 1 );\n\t\t},\n\t\toff: function( types, selector, fn ) {\n\t\t\tvar handleObj, type;\n\t\t\tif ( types && types.preventDefault && types.handleObj ) {\n\n\t\t\t\t// ( event )  dispatched jQuery.Event\n\t\t\t\thandleObj = types.handleObj;\n\t\t\t\tjQuery( types.delegateTarget ).off(\n\t\t\t\t\thandleObj.namespace ?\n\t\t\t\t\thandleObj.origType + \".\" + handleObj.namespace :\n\t\t\t\t\t\thandleObj.origType,\n\t\t\t\t\thandleObj.selector,\n\t\t\t\t\thandleObj.handler\n\t\t\t\t);\n\t\t\t\treturn this;\n\t\t\t}\n\t\t\tif ( typeof types === \"object\" ) {\n\n\t\t\t\t// ( types-object [, selector] )\n\t\t\t\tfor ( type in types ) {\n\t\t\t\t\tthis.off( type, selector, types[ type ] );\n\t\t\t\t}\n\t\t\t\treturn this;\n\t\t\t}\n\t\t\tif ( selector === false || typeof selector === \"function\" ) {\n\n\t\t\t\t// ( types [, fn] )\n\t\t\t\tfn = selector;\n\t\t\t\tselector = undefined;\n\t\t\t}\n\t\t\tif ( fn === false ) {\n\t\t\t\tfn = returnFalse;\n\t\t\t}\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.event.remove( this, types, fn, selector );\n\t\t\t} );\n\t\t},\n\n\t\ttrigger: function( type, data ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.event.trigger( type, data, this );\n\t\t\t} );\n\t\t},\n\t\ttriggerHandler: function( type, data ) {\n\t\t\tvar elem = this[ 0 ];\n\t\t\tif ( elem ) {\n\t\t\t\treturn jQuery.event.trigger( type, data, elem, true );\n\t\t\t}\n\t\t}\n\t} );\n\n\n\tvar rinlinejQuery = / jQuery\\d+=\"(?:null|\\d+)\"/g,\n\t\trnoshimcache = new RegExp( \"<(?:\" + nodeNames + \")[\\\\s/>]\", \"i\" ),\n\t\trxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\\w:-]+)[^>]*)\\/>/gi,\n\n\t\t// Support: IE 10-11, Edge 10240+\n\t\t// In IE/Edge using regex groups here causes severe slowdowns.\n\t\t// See https://connect.microsoft.com/IE/feedback/details/1736512/\n\t\trnoInnerhtml = /<script|<style|<link/i,\n\n\t\t// checked=\"checked\" or checked\n\t\trchecked = /checked\\s*(?:[^=]|=\\s*.checked.)/i,\n\t\trscriptTypeMasked = /^true\\/(.*)/,\n\t\trcleanScript = /^\\s*<!(?:\\[CDATA\\[|--)|(?:\\]\\]|--)>\\s*$/g,\n\t\tsafeFragment = createSafeFragment( document ),\n\t\tfragmentDiv = safeFragment.appendChild( document.createElement( \"div\" ) );\n\n// Support: IE<8\n// Manipulating tables requires a tbody\n\tfunction manipulationTarget( elem, content ) {\n\t\treturn jQuery.nodeName( elem, \"table\" ) &&\n\t\tjQuery.nodeName( content.nodeType !== 11 ? content : content.firstChild, \"tr\" ) ?\n\n\t\telem.getElementsByTagName( \"tbody\" )[ 0 ] ||\n\t\telem.appendChild( elem.ownerDocument.createElement( \"tbody\" ) ) :\n\t\t\telem;\n\t}\n\n// Replace/restore the type attribute of script elements for safe DOM manipulation\n\tfunction disableScript( elem ) {\n\t\telem.type = ( jQuery.find.attr( elem, \"type\" ) !== null ) + \"/\" + elem.type;\n\t\treturn elem;\n\t}\n\tfunction restoreScript( elem ) {\n\t\tvar match = rscriptTypeMasked.exec( elem.type );\n\t\tif ( match ) {\n\t\t\telem.type = match[ 1 ];\n\t\t} else {\n\t\t\telem.removeAttribute( \"type\" );\n\t\t}\n\t\treturn elem;\n\t}\n\n\tfunction cloneCopyEvent( src, dest ) {\n\t\tif ( dest.nodeType !== 1 || !jQuery.hasData( src ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar type, i, l,\n\t\t\toldData = jQuery._data( src ),\n\t\t\tcurData = jQuery._data( dest, oldData ),\n\t\t\tevents = oldData.events;\n\n\t\tif ( events ) {\n\t\t\tdelete curData.handle;\n\t\t\tcurData.events = {};\n\n\t\t\tfor ( type in events ) {\n\t\t\t\tfor ( i = 0, l = events[ type ].length; i < l; i++ ) {\n\t\t\t\t\tjQuery.event.add( dest, type, events[ type ][ i ] );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// make the cloned public data object a copy from the original\n\t\tif ( curData.data ) {\n\t\t\tcurData.data = jQuery.extend( {}, curData.data );\n\t\t}\n\t}\n\n\tfunction fixCloneNodeIssues( src, dest ) {\n\t\tvar nodeName, e, data;\n\n\t\t// We do not need to do anything for non-Elements\n\t\tif ( dest.nodeType !== 1 ) {\n\t\t\treturn;\n\t\t}\n\n\t\tnodeName = dest.nodeName.toLowerCase();\n\n\t\t// IE6-8 copies events bound via attachEvent when using cloneNode.\n\t\tif ( !support.noCloneEvent && dest[ jQuery.expando ] ) {\n\t\t\tdata = jQuery._data( dest );\n\n\t\t\tfor ( e in data.events ) {\n\t\t\t\tjQuery.removeEvent( dest, e, data.handle );\n\t\t\t}\n\n\t\t\t// Event data gets referenced instead of copied if the expando gets copied too\n\t\t\tdest.removeAttribute( jQuery.expando );\n\t\t}\n\n\t\t// IE blanks contents when cloning scripts, and tries to evaluate newly-set text\n\t\tif ( nodeName === \"script\" && dest.text !== src.text ) {\n\t\t\tdisableScript( dest ).text = src.text;\n\t\t\trestoreScript( dest );\n\n\t\t\t// IE6-10 improperly clones children of object elements using classid.\n\t\t\t// IE10 throws NoModificationAllowedError if parent is null, #12132.\n\t\t} else if ( nodeName === \"object\" ) {\n\t\t\tif ( dest.parentNode ) {\n\t\t\t\tdest.outerHTML = src.outerHTML;\n\t\t\t}\n\n\t\t\t// This path appears unavoidable for IE9. When cloning an object\n\t\t\t// element in IE9, the outerHTML strategy above is not sufficient.\n\t\t\t// If the src has innerHTML and the destination does not,\n\t\t\t// copy the src.innerHTML into the dest.innerHTML. #10324\n\t\t\tif ( support.html5Clone && ( src.innerHTML && !jQuery.trim( dest.innerHTML ) ) ) {\n\t\t\t\tdest.innerHTML = src.innerHTML;\n\t\t\t}\n\n\t\t} else if ( nodeName === \"input\" && rcheckableType.test( src.type ) ) {\n\n\t\t\t// IE6-8 fails to persist the checked state of a cloned checkbox\n\t\t\t// or radio button. Worse, IE6-7 fail to give the cloned element\n\t\t\t// a checked appearance if the defaultChecked value isn't also set\n\n\t\t\tdest.defaultChecked = dest.checked = src.checked;\n\n\t\t\t// IE6-7 get confused and end up setting the value of a cloned\n\t\t\t// checkbox/radio button to an empty string instead of \"on\"\n\t\t\tif ( dest.value !== src.value ) {\n\t\t\t\tdest.value = src.value;\n\t\t\t}\n\n\t\t\t// IE6-8 fails to return the selected option to the default selected\n\t\t\t// state when cloning options\n\t\t} else if ( nodeName === \"option\" ) {\n\t\t\tdest.defaultSelected = dest.selected = src.defaultSelected;\n\n\t\t\t// IE6-8 fails to set the defaultValue to the correct value when\n\t\t\t// cloning other types of input fields\n\t\t} else if ( nodeName === \"input\" || nodeName === \"textarea\" ) {\n\t\t\tdest.defaultValue = src.defaultValue;\n\t\t}\n\t}\n\n\tfunction domManip( collection, args, callback, ignored ) {\n\n\t\t// Flatten any nested arrays\n\t\targs = concat.apply( [], args );\n\n\t\tvar first, node, hasScripts,\n\t\t\tscripts, doc, fragment,\n\t\t\ti = 0,\n\t\t\tl = collection.length,\n\t\t\tiNoClone = l - 1,\n\t\t\tvalue = args[ 0 ],\n\t\t\tisFunction = jQuery.isFunction( value );\n\n\t\t// We can't cloneNode fragments that contain checked, in WebKit\n\t\tif ( isFunction ||\n\t\t\t( l > 1 && typeof value === \"string\" &&\n\t\t\t!support.checkClone && rchecked.test( value ) ) ) {\n\t\t\treturn collection.each( function( index ) {\n\t\t\t\tvar self = collection.eq( index );\n\t\t\t\tif ( isFunction ) {\n\t\t\t\t\targs[ 0 ] = value.call( this, index, self.html() );\n\t\t\t\t}\n\t\t\t\tdomManip( self, args, callback, ignored );\n\t\t\t} );\n\t\t}\n\n\t\tif ( l ) {\n\t\t\tfragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );\n\t\t\tfirst = fragment.firstChild;\n\n\t\t\tif ( fragment.childNodes.length === 1 ) {\n\t\t\t\tfragment = first;\n\t\t\t}\n\n\t\t\t// Require either new content or an interest in ignored elements to invoke the callback\n\t\t\tif ( first || ignored ) {\n\t\t\t\tscripts = jQuery.map( getAll( fragment, \"script\" ), disableScript );\n\t\t\t\thasScripts = scripts.length;\n\n\t\t\t\t// Use the original fragment for the last item\n\t\t\t\t// instead of the first because it can end up\n\t\t\t\t// being emptied incorrectly in certain situations (#8070).\n\t\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\t\tnode = fragment;\n\n\t\t\t\t\tif ( i !== iNoClone ) {\n\t\t\t\t\t\tnode = jQuery.clone( node, true, true );\n\n\t\t\t\t\t\t// Keep references to cloned scripts for later restoration\n\t\t\t\t\t\tif ( hasScripts ) {\n\n\t\t\t\t\t\t\t// Support: Android<4.1, PhantomJS<2\n\t\t\t\t\t\t\t// push.apply(_, arraylike) throws on ancient WebKit\n\t\t\t\t\t\t\tjQuery.merge( scripts, getAll( node, \"script\" ) );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tcallback.call( collection[ i ], node, i );\n\t\t\t\t}\n\n\t\t\t\tif ( hasScripts ) {\n\t\t\t\t\tdoc = scripts[ scripts.length - 1 ].ownerDocument;\n\n\t\t\t\t\t// Reenable scripts\n\t\t\t\t\tjQuery.map( scripts, restoreScript );\n\n\t\t\t\t\t// Evaluate executable scripts on first document insertion\n\t\t\t\t\tfor ( i = 0; i < hasScripts; i++ ) {\n\t\t\t\t\t\tnode = scripts[ i ];\n\t\t\t\t\t\tif ( rscriptType.test( node.type || \"\" ) &&\n\t\t\t\t\t\t\t!jQuery._data( node, \"globalEval\" ) &&\n\t\t\t\t\t\t\tjQuery.contains( doc, node ) ) {\n\n\t\t\t\t\t\t\tif ( node.src ) {\n\n\t\t\t\t\t\t\t\t// Optional AJAX dependency, but won't run scripts if not present\n\t\t\t\t\t\t\t\tif ( jQuery._evalUrl ) {\n\t\t\t\t\t\t\t\t\tjQuery._evalUrl( node.src );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tjQuery.globalEval(\n\t\t\t\t\t\t\t\t\t( node.text || node.textContent || node.innerHTML || \"\" )\n\t\t\t\t\t\t\t\t\t\t.replace( rcleanScript, \"\" )\n\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Fix #11809: Avoid leaking memory\n\t\t\t\tfragment = first = null;\n\t\t\t}\n\t\t}\n\n\t\treturn collection;\n\t}\n\n\tfunction remove( elem, selector, keepData ) {\n\t\tvar node,\n\t\t\telems = selector ? jQuery.filter( selector, elem ) : elem,\n\t\t\ti = 0;\n\n\t\tfor ( ; ( node = elems[ i ] ) != null; i++ ) {\n\n\t\t\tif ( !keepData && node.nodeType === 1 ) {\n\t\t\t\tjQuery.cleanData( getAll( node ) );\n\t\t\t}\n\n\t\t\tif ( node.parentNode ) {\n\t\t\t\tif ( keepData && jQuery.contains( node.ownerDocument, node ) ) {\n\t\t\t\t\tsetGlobalEval( getAll( node, \"script\" ) );\n\t\t\t\t}\n\t\t\t\tnode.parentNode.removeChild( node );\n\t\t\t}\n\t\t}\n\n\t\treturn elem;\n\t}\n\n\tjQuery.extend( {\n\t\thtmlPrefilter: function( html ) {\n\t\t\treturn html.replace( rxhtmlTag, \"<$1></$2>\" );\n\t\t},\n\n\t\tclone: function( elem, dataAndEvents, deepDataAndEvents ) {\n\t\t\tvar destElements, node, clone, i, srcElements,\n\t\t\t\tinPage = jQuery.contains( elem.ownerDocument, elem );\n\n\t\t\tif ( support.html5Clone || jQuery.isXMLDoc( elem ) ||\n\t\t\t\t!rnoshimcache.test( \"<\" + elem.nodeName + \">\" ) ) {\n\n\t\t\t\tclone = elem.cloneNode( true );\n\n\t\t\t\t// IE<=8 does not properly clone detached, unknown element nodes\n\t\t\t} else {\n\t\t\t\tfragmentDiv.innerHTML = elem.outerHTML;\n\t\t\t\tfragmentDiv.removeChild( clone = fragmentDiv.firstChild );\n\t\t\t}\n\n\t\t\tif ( ( !support.noCloneEvent || !support.noCloneChecked ) &&\n\t\t\t\t( elem.nodeType === 1 || elem.nodeType === 11 ) && !jQuery.isXMLDoc( elem ) ) {\n\n\t\t\t\t// We eschew Sizzle here for performance reasons: http://jsperf.com/getall-vs-sizzle/2\n\t\t\t\tdestElements = getAll( clone );\n\t\t\t\tsrcElements = getAll( elem );\n\n\t\t\t\t// Fix all IE cloning issues\n\t\t\t\tfor ( i = 0; ( node = srcElements[ i ] ) != null; ++i ) {\n\n\t\t\t\t\t// Ensure that the destination node is not null; Fixes #9587\n\t\t\t\t\tif ( destElements[ i ] ) {\n\t\t\t\t\t\tfixCloneNodeIssues( node, destElements[ i ] );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Copy the events from the original to the clone\n\t\t\tif ( dataAndEvents ) {\n\t\t\t\tif ( deepDataAndEvents ) {\n\t\t\t\t\tsrcElements = srcElements || getAll( elem );\n\t\t\t\t\tdestElements = destElements || getAll( clone );\n\n\t\t\t\t\tfor ( i = 0; ( node = srcElements[ i ] ) != null; i++ ) {\n\t\t\t\t\t\tcloneCopyEvent( node, destElements[ i ] );\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tcloneCopyEvent( elem, clone );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Preserve script evaluation history\n\t\t\tdestElements = getAll( clone, \"script\" );\n\t\t\tif ( destElements.length > 0 ) {\n\t\t\t\tsetGlobalEval( destElements, !inPage && getAll( elem, \"script\" ) );\n\t\t\t}\n\n\t\t\tdestElements = srcElements = node = null;\n\n\t\t\t// Return the cloned set\n\t\t\treturn clone;\n\t\t},\n\n\t\tcleanData: function( elems, /* internal */ forceAcceptData ) {\n\t\t\tvar elem, type, id, data,\n\t\t\t\ti = 0,\n\t\t\t\tinternalKey = jQuery.expando,\n\t\t\t\tcache = jQuery.cache,\n\t\t\t\tattributes = support.attributes,\n\t\t\t\tspecial = jQuery.event.special;\n\n\t\t\tfor ( ; ( elem = elems[ i ] ) != null; i++ ) {\n\t\t\t\tif ( forceAcceptData || acceptData( elem ) ) {\n\n\t\t\t\t\tid = elem[ internalKey ];\n\t\t\t\t\tdata = id && cache[ id ];\n\n\t\t\t\t\tif ( data ) {\n\t\t\t\t\t\tif ( data.events ) {\n\t\t\t\t\t\t\tfor ( type in data.events ) {\n\t\t\t\t\t\t\t\tif ( special[ type ] ) {\n\t\t\t\t\t\t\t\t\tjQuery.event.remove( elem, type );\n\n\t\t\t\t\t\t\t\t\t// This is a shortcut to avoid jQuery.event.remove's overhead\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tjQuery.removeEvent( elem, type, data.handle );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Remove cache only if it was not already removed by jQuery.event.remove\n\t\t\t\t\t\tif ( cache[ id ] ) {\n\n\t\t\t\t\t\t\tdelete cache[ id ];\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// IE does not allow us to delete expando properties from nodes\n\t\t\t\t\t\t\t// IE creates expando attributes along with the property\n\t\t\t\t\t\t\t// IE does not have a removeAttribute function on Document nodes\n\t\t\t\t\t\t\tif ( !attributes && typeof elem.removeAttribute !== \"undefined\" ) {\n\t\t\t\t\t\t\t\telem.removeAttribute( internalKey );\n\n\t\t\t\t\t\t\t\t// Webkit & Blink performance suffers when deleting properties\n\t\t\t\t\t\t\t\t// from DOM nodes, so set to undefined instead\n\t\t\t\t\t\t\t\t// https://code.google.com/p/chromium/issues/detail?id=378607\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\telem[ internalKey ] = undefined;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tdeletedIds.push( id );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\n\t\t// Keep domManip exposed until 3.0 (gh-2225)\n\t\tdomManip: domManip,\n\n\t\tdetach: function( selector ) {\n\t\t\treturn remove( this, selector, true );\n\t\t},\n\n\t\tremove: function( selector ) {\n\t\t\treturn remove( this, selector );\n\t\t},\n\n\t\ttext: function( value ) {\n\t\t\treturn access( this, function( value ) {\n\t\t\t\treturn value === undefined ?\n\t\t\t\t\tjQuery.text( this ) :\n\t\t\t\t\tthis.empty().append(\n\t\t\t\t\t\t( this[ 0 ] && this[ 0 ].ownerDocument || document ).createTextNode( value )\n\t\t\t\t\t);\n\t\t\t}, null, value, arguments.length );\n\t\t},\n\n\t\tappend: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n\t\t\t\t\tvar target = manipulationTarget( this, elem );\n\t\t\t\t\ttarget.appendChild( elem );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tprepend: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n\t\t\t\t\tvar target = manipulationTarget( this, elem );\n\t\t\t\t\ttarget.insertBefore( elem, target.firstChild );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tbefore: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.parentNode ) {\n\t\t\t\t\tthis.parentNode.insertBefore( elem, this );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tafter: function() {\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tif ( this.parentNode ) {\n\t\t\t\t\tthis.parentNode.insertBefore( elem, this.nextSibling );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tempty: function() {\n\t\t\tvar elem,\n\t\t\t\ti = 0;\n\n\t\t\tfor ( ; ( elem = this[ i ] ) != null; i++ ) {\n\n\t\t\t\t// Remove element nodes and prevent memory leaks\n\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\tjQuery.cleanData( getAll( elem, false ) );\n\t\t\t\t}\n\n\t\t\t\t// Remove any remaining nodes\n\t\t\t\twhile ( elem.firstChild ) {\n\t\t\t\t\telem.removeChild( elem.firstChild );\n\t\t\t\t}\n\n\t\t\t\t// If this is a select, ensure that it displays empty (#12336)\n\t\t\t\t// Support: IE<9\n\t\t\t\tif ( elem.options && jQuery.nodeName( elem, \"select\" ) ) {\n\t\t\t\t\telem.options.length = 0;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\tclone: function( dataAndEvents, deepDataAndEvents ) {\n\t\t\tdataAndEvents = dataAndEvents == null ? false : dataAndEvents;\n\t\t\tdeepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;\n\n\t\t\treturn this.map( function() {\n\t\t\t\treturn jQuery.clone( this, dataAndEvents, deepDataAndEvents );\n\t\t\t} );\n\t\t},\n\n\t\thtml: function( value ) {\n\t\t\treturn access( this, function( value ) {\n\t\t\t\tvar elem = this[ 0 ] || {},\n\t\t\t\t\ti = 0,\n\t\t\t\t\tl = this.length;\n\n\t\t\t\tif ( value === undefined ) {\n\t\t\t\t\treturn elem.nodeType === 1 ?\n\t\t\t\t\t\telem.innerHTML.replace( rinlinejQuery, \"\" ) :\n\t\t\t\t\t\tundefined;\n\t\t\t\t}\n\n\t\t\t\t// See if we can take a shortcut and just use innerHTML\n\t\t\t\tif ( typeof value === \"string\" && !rnoInnerhtml.test( value ) &&\n\t\t\t\t\t( support.htmlSerialize || !rnoshimcache.test( value )  ) &&\n\t\t\t\t\t( support.leadingWhitespace || !rleadingWhitespace.test( value ) ) &&\n\t\t\t\t\t!wrapMap[ ( rtagName.exec( value ) || [ \"\", \"\" ] )[ 1 ].toLowerCase() ] ) {\n\n\t\t\t\t\tvalue = jQuery.htmlPrefilter( value );\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\tfor ( ; i < l; i++ ) {\n\n\t\t\t\t\t\t\t// Remove element nodes and prevent memory leaks\n\t\t\t\t\t\t\telem = this[ i ] || {};\n\t\t\t\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\t\t\t\tjQuery.cleanData( getAll( elem, false ) );\n\t\t\t\t\t\t\t\telem.innerHTML = value;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\telem = 0;\n\n\t\t\t\t\t\t// If using innerHTML throws an exception, use the fallback method\n\t\t\t\t\t} catch ( e ) {}\n\t\t\t\t}\n\n\t\t\t\tif ( elem ) {\n\t\t\t\t\tthis.empty().append( value );\n\t\t\t\t}\n\t\t\t}, null, value, arguments.length );\n\t\t},\n\n\t\treplaceWith: function() {\n\t\t\tvar ignored = [];\n\n\t\t\t// Make the changes, replacing each non-ignored context element with the new content\n\t\t\treturn domManip( this, arguments, function( elem ) {\n\t\t\t\tvar parent = this.parentNode;\n\n\t\t\t\tif ( jQuery.inArray( this, ignored ) < 0 ) {\n\t\t\t\t\tjQuery.cleanData( getAll( this ) );\n\t\t\t\t\tif ( parent ) {\n\t\t\t\t\t\tparent.replaceChild( elem, this );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Force callback invocation\n\t\t\t}, ignored );\n\t\t}\n\t} );\n\n\tjQuery.each( {\n\t\tappendTo: \"append\",\n\t\tprependTo: \"prepend\",\n\t\tinsertBefore: \"before\",\n\t\tinsertAfter: \"after\",\n\t\treplaceAll: \"replaceWith\"\n\t}, function( name, original ) {\n\t\tjQuery.fn[ name ] = function( selector ) {\n\t\t\tvar elems,\n\t\t\t\ti = 0,\n\t\t\t\tret = [],\n\t\t\t\tinsert = jQuery( selector ),\n\t\t\t\tlast = insert.length - 1;\n\n\t\t\tfor ( ; i <= last; i++ ) {\n\t\t\t\telems = i === last ? this : this.clone( true );\n\t\t\t\tjQuery( insert[ i ] )[ original ]( elems );\n\n\t\t\t\t// Modern browsers can apply jQuery collections as arrays, but oldIE needs a .get()\n\t\t\t\tpush.apply( ret, elems.get() );\n\t\t\t}\n\n\t\t\treturn this.pushStack( ret );\n\t\t};\n\t} );\n\n\n\tvar iframe,\n\t\telemdisplay = {\n\n\t\t\t// Support: Firefox\n\t\t\t// We have to pre-define these values for FF (#10227)\n\t\t\tHTML: \"block\",\n\t\t\tBODY: \"block\"\n\t\t};\n\n\t/**\n\t * Retrieve the actual display of a element\n\t * @param {String} name nodeName of the element\n\t * @param {Object} doc Document object\n\t */\n\n// Called only from within defaultDisplay\n\tfunction actualDisplay( name, doc ) {\n\t\tvar elem = jQuery( doc.createElement( name ) ).appendTo( doc.body ),\n\n\t\t\tdisplay = jQuery.css( elem[ 0 ], \"display\" );\n\n\t\t// We don't have any data stored on the element,\n\t\t// so use \"detach\" method as fast way to get rid of the element\n\t\telem.detach();\n\n\t\treturn display;\n\t}\n\n\t/**\n\t * Try to determine the default display value of an element\n\t * @param {String} nodeName\n\t */\n\tfunction defaultDisplay( nodeName ) {\n\t\tvar doc = document,\n\t\t\tdisplay = elemdisplay[ nodeName ];\n\n\t\tif ( !display ) {\n\t\t\tdisplay = actualDisplay( nodeName, doc );\n\n\t\t\t// If the simple way fails, read from inside an iframe\n\t\t\tif ( display === \"none\" || !display ) {\n\n\t\t\t\t// Use the already-created iframe if possible\n\t\t\t\tiframe = ( iframe || jQuery( \"<iframe frameborder='0' width='0' height='0'/>\" ) )\n\t\t\t\t\t.appendTo( doc.documentElement );\n\n\t\t\t\t// Always write a new HTML skeleton so Webkit and Firefox don't choke on reuse\n\t\t\t\tdoc = ( iframe[ 0 ].contentWindow || iframe[ 0 ].contentDocument ).document;\n\n\t\t\t\t// Support: IE\n\t\t\t\tdoc.write();\n\t\t\t\tdoc.close();\n\n\t\t\t\tdisplay = actualDisplay( nodeName, doc );\n\t\t\t\tiframe.detach();\n\t\t\t}\n\n\t\t\t// Store the correct default display\n\t\t\telemdisplay[ nodeName ] = display;\n\t\t}\n\n\t\treturn display;\n\t}\n\tvar rmargin = ( /^margin/ );\n\n\tvar rnumnonpx = new RegExp( \"^(\" + pnum + \")(?!px)[a-z%]+$\", \"i\" );\n\n\tvar swap = function( elem, options, callback, args ) {\n\t\tvar ret, name,\n\t\t\told = {};\n\n\t\t// Remember the old values, and insert the new ones\n\t\tfor ( name in options ) {\n\t\t\told[ name ] = elem.style[ name ];\n\t\t\telem.style[ name ] = options[ name ];\n\t\t}\n\n\t\tret = callback.apply( elem, args || [] );\n\n\t\t// Revert the old values\n\t\tfor ( name in options ) {\n\t\t\telem.style[ name ] = old[ name ];\n\t\t}\n\n\t\treturn ret;\n\t};\n\n\n\tvar documentElement = document.documentElement;\n\n\n\n\t( function() {\n\t\tvar pixelPositionVal, pixelMarginRightVal, boxSizingReliableVal,\n\t\t\treliableHiddenOffsetsVal, reliableMarginRightVal, reliableMarginLeftVal,\n\t\t\tcontainer = document.createElement( \"div\" ),\n\t\t\tdiv = document.createElement( \"div\" );\n\n\t\t// Finish early in limited (non-browser) environments\n\t\tif ( !div.style ) {\n\t\t\treturn;\n\t\t}\n\n\t\tdiv.style.cssText = \"float:left;opacity:.5\";\n\n\t\t// Support: IE<9\n\t\t// Make sure that element opacity exists (as opposed to filter)\n\t\tsupport.opacity = div.style.opacity === \"0.5\";\n\n\t\t// Verify style float existence\n\t\t// (IE uses styleFloat instead of cssFloat)\n\t\tsupport.cssFloat = !!div.style.cssFloat;\n\n\t\tdiv.style.backgroundClip = \"content-box\";\n\t\tdiv.cloneNode( true ).style.backgroundClip = \"\";\n\t\tsupport.clearCloneStyle = div.style.backgroundClip === \"content-box\";\n\n\t\tcontainer = document.createElement( \"div\" );\n\t\tcontainer.style.cssText = \"border:0;width:8px;height:0;top:0;left:-9999px;\" +\n\t\t\t\"padding:0;margin-top:1px;position:absolute\";\n\t\tdiv.innerHTML = \"\";\n\t\tcontainer.appendChild( div );\n\n\t\t// Support: Firefox<29, Android 2.3\n\t\t// Vendor-prefix box-sizing\n\t\tsupport.boxSizing = div.style.boxSizing === \"\" || div.style.MozBoxSizing === \"\" ||\n\t\t\tdiv.style.WebkitBoxSizing === \"\";\n\n\t\tjQuery.extend( support, {\n\t\t\treliableHiddenOffsets: function() {\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn reliableHiddenOffsetsVal;\n\t\t\t},\n\n\t\t\tboxSizingReliable: function() {\n\n\t\t\t\t// We're checking for pixelPositionVal here instead of boxSizingReliableVal\n\t\t\t\t// since that compresses better and they're computed together anyway.\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn boxSizingReliableVal;\n\t\t\t},\n\n\t\t\tpixelMarginRight: function() {\n\n\t\t\t\t// Support: Android 4.0-4.3\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn pixelMarginRightVal;\n\t\t\t},\n\n\t\t\tpixelPosition: function() {\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn pixelPositionVal;\n\t\t\t},\n\n\t\t\treliableMarginRight: function() {\n\n\t\t\t\t// Support: Android 2.3\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn reliableMarginRightVal;\n\t\t\t},\n\n\t\t\treliableMarginLeft: function() {\n\n\t\t\t\t// Support: IE <=8 only, Android 4.0 - 4.3 only, Firefox <=3 - 37\n\t\t\t\tif ( pixelPositionVal == null ) {\n\t\t\t\t\tcomputeStyleTests();\n\t\t\t\t}\n\t\t\t\treturn reliableMarginLeftVal;\n\t\t\t}\n\t\t} );\n\n\t\tfunction computeStyleTests() {\n\t\t\tvar contents, divStyle,\n\t\t\t\tdocumentElement = document.documentElement;\n\n\t\t\t// Setup\n\t\t\tdocumentElement.appendChild( container );\n\n\t\t\tdiv.style.cssText =\n\n\t\t\t\t// Support: Android 2.3\n\t\t\t\t// Vendor-prefix box-sizing\n\t\t\t\t\"-webkit-box-sizing:border-box;box-sizing:border-box;\" +\n\t\t\t\t\"position:relative;display:block;\" +\n\t\t\t\t\"margin:auto;border:1px;padding:1px;\" +\n\t\t\t\t\"top:1%;width:50%\";\n\n\t\t\t// Support: IE<9\n\t\t\t// Assume reasonable values in the absence of getComputedStyle\n\t\t\tpixelPositionVal = boxSizingReliableVal = reliableMarginLeftVal = false;\n\t\t\tpixelMarginRightVal = reliableMarginRightVal = true;\n\n\t\t\t// Check for getComputedStyle so that this code is not run in IE<9.\n\t\t\tif ( window.getComputedStyle ) {\n\t\t\t\tdivStyle = window.getComputedStyle( div );\n\t\t\t\tpixelPositionVal = ( divStyle || {} ).top !== \"1%\";\n\t\t\t\treliableMarginLeftVal = ( divStyle || {} ).marginLeft === \"2px\";\n\t\t\t\tboxSizingReliableVal = ( divStyle || { width: \"4px\" } ).width === \"4px\";\n\n\t\t\t\t// Support: Android 4.0 - 4.3 only\n\t\t\t\t// Some styles come back with percentage values, even though they shouldn't\n\t\t\t\tdiv.style.marginRight = \"50%\";\n\t\t\t\tpixelMarginRightVal = ( divStyle || { marginRight: \"4px\" } ).marginRight === \"4px\";\n\n\t\t\t\t// Support: Android 2.3 only\n\t\t\t\t// Div with explicit width and no margin-right incorrectly\n\t\t\t\t// gets computed margin-right based on width of container (#3333)\n\t\t\t\t// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right\n\t\t\t\tcontents = div.appendChild( document.createElement( \"div\" ) );\n\n\t\t\t\t// Reset CSS: box-sizing; display; margin; border; padding\n\t\t\t\tcontents.style.cssText = div.style.cssText =\n\n\t\t\t\t\t// Support: Android 2.3\n\t\t\t\t\t// Vendor-prefix box-sizing\n\t\t\t\t\t\"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;\" +\n\t\t\t\t\t\"box-sizing:content-box;display:block;margin:0;border:0;padding:0\";\n\t\t\t\tcontents.style.marginRight = contents.style.width = \"0\";\n\t\t\t\tdiv.style.width = \"1px\";\n\n\t\t\t\treliableMarginRightVal =\n\t\t\t\t\t!parseFloat( ( window.getComputedStyle( contents ) || {} ).marginRight );\n\n\t\t\t\tdiv.removeChild( contents );\n\t\t\t}\n\n\t\t\t// Support: IE6-8\n\t\t\t// First check that getClientRects works as expected\n\t\t\t// Check if table cells still have offsetWidth/Height when they are set\n\t\t\t// to display:none and there are still other visible table cells in a\n\t\t\t// table row; if so, offsetWidth/Height are not reliable for use when\n\t\t\t// determining if an element has been hidden directly using\n\t\t\t// display:none (it is still safe to use offsets if a parent element is\n\t\t\t// hidden; don safety goggles and see bug #4512 for more information).\n\t\t\tdiv.style.display = \"none\";\n\t\t\treliableHiddenOffsetsVal = div.getClientRects().length === 0;\n\t\t\tif ( reliableHiddenOffsetsVal ) {\n\t\t\t\tdiv.style.display = \"\";\n\t\t\t\tdiv.innerHTML = \"<table><tr><td></td><td>t</td></tr></table>\";\n\t\t\t\tdiv.childNodes[ 0 ].style.borderCollapse = \"separate\";\n\t\t\t\tcontents = div.getElementsByTagName( \"td\" );\n\t\t\t\tcontents[ 0 ].style.cssText = \"margin:0;border:0;padding:0;display:none\";\n\t\t\t\treliableHiddenOffsetsVal = contents[ 0 ].offsetHeight === 0;\n\t\t\t\tif ( reliableHiddenOffsetsVal ) {\n\t\t\t\t\tcontents[ 0 ].style.display = \"\";\n\t\t\t\t\tcontents[ 1 ].style.display = \"none\";\n\t\t\t\t\treliableHiddenOffsetsVal = contents[ 0 ].offsetHeight === 0;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Teardown\n\t\t\tdocumentElement.removeChild( container );\n\t\t}\n\n\t} )();\n\n\n\tvar getStyles, curCSS,\n\t\trposition = /^(top|right|bottom|left)$/;\n\n\tif ( window.getComputedStyle ) {\n\t\tgetStyles = function( elem ) {\n\n\t\t\t// Support: IE<=11+, Firefox<=30+ (#15098, #14150)\n\t\t\t// IE throws on elements created in popups\n\t\t\t// FF meanwhile throws on frame elements through \"defaultView.getComputedStyle\"\n\t\t\tvar view = elem.ownerDocument.defaultView;\n\n\t\t\tif ( !view || !view.opener ) {\n\t\t\t\tview = window;\n\t\t\t}\n\n\t\t\treturn view.getComputedStyle( elem );\n\t\t};\n\n\t\tcurCSS = function( elem, name, computed ) {\n\t\t\tvar width, minWidth, maxWidth, ret,\n\t\t\t\tstyle = elem.style;\n\n\t\t\tcomputed = computed || getStyles( elem );\n\n\t\t\t// getPropertyValue is only needed for .css('filter') in IE9, see #12537\n\t\t\tret = computed ? computed.getPropertyValue( name ) || computed[ name ] : undefined;\n\n\t\t\t// Support: Opera 12.1x only\n\t\t\t// Fall back to style even without computed\n\t\t\t// computed is undefined for elems on document fragments\n\t\t\tif ( ( ret === \"\" || ret === undefined ) && !jQuery.contains( elem.ownerDocument, elem ) ) {\n\t\t\t\tret = jQuery.style( elem, name );\n\t\t\t}\n\n\t\t\tif ( computed ) {\n\n\t\t\t\t// A tribute to the \"awesome hack by Dean Edwards\"\n\t\t\t\t// Chrome < 17 and Safari 5.0 uses \"computed value\"\n\t\t\t\t// instead of \"used value\" for margin-right\n\t\t\t\t// Safari 5.1.7 (at least) returns percentage for a larger set of values,\n\t\t\t\t// but width seems to be reliably pixels\n\t\t\t\t// this is against the CSSOM draft spec:\n\t\t\t\t// http://dev.w3.org/csswg/cssom/#resolved-values\n\t\t\t\tif ( !support.pixelMarginRight() && rnumnonpx.test( ret ) && rmargin.test( name ) ) {\n\n\t\t\t\t\t// Remember the original values\n\t\t\t\t\twidth = style.width;\n\t\t\t\t\tminWidth = style.minWidth;\n\t\t\t\t\tmaxWidth = style.maxWidth;\n\n\t\t\t\t\t// Put in the new values to get a computed value out\n\t\t\t\t\tstyle.minWidth = style.maxWidth = style.width = ret;\n\t\t\t\t\tret = computed.width;\n\n\t\t\t\t\t// Revert the changed values\n\t\t\t\t\tstyle.width = width;\n\t\t\t\t\tstyle.minWidth = minWidth;\n\t\t\t\t\tstyle.maxWidth = maxWidth;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Support: IE\n\t\t\t// IE returns zIndex value as an integer.\n\t\t\treturn ret === undefined ?\n\t\t\t\tret :\n\t\t\tret + \"\";\n\t\t};\n\t} else if ( documentElement.currentStyle ) {\n\t\tgetStyles = function( elem ) {\n\t\t\treturn elem.currentStyle;\n\t\t};\n\n\t\tcurCSS = function( elem, name, computed ) {\n\t\t\tvar left, rs, rsLeft, ret,\n\t\t\t\tstyle = elem.style;\n\n\t\t\tcomputed = computed || getStyles( elem );\n\t\t\tret = computed ? computed[ name ] : undefined;\n\n\t\t\t// Avoid setting ret to empty string here\n\t\t\t// so we don't default to auto\n\t\t\tif ( ret == null && style && style[ name ] ) {\n\t\t\t\tret = style[ name ];\n\t\t\t}\n\n\t\t\t// From the awesome hack by Dean Edwards\n\t\t\t// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291\n\n\t\t\t// If we're not dealing with a regular pixel number\n\t\t\t// but a number that has a weird ending, we need to convert it to pixels\n\t\t\t// but not position css attributes, as those are\n\t\t\t// proportional to the parent element instead\n\t\t\t// and we can't measure the parent instead because it\n\t\t\t// might trigger a \"stacking dolls\" problem\n\t\t\tif ( rnumnonpx.test( ret ) && !rposition.test( name ) ) {\n\n\t\t\t\t// Remember the original values\n\t\t\t\tleft = style.left;\n\t\t\t\trs = elem.runtimeStyle;\n\t\t\t\trsLeft = rs && rs.left;\n\n\t\t\t\t// Put in the new values to get a computed value out\n\t\t\t\tif ( rsLeft ) {\n\t\t\t\t\trs.left = elem.currentStyle.left;\n\t\t\t\t}\n\t\t\t\tstyle.left = name === \"fontSize\" ? \"1em\" : ret;\n\t\t\t\tret = style.pixelLeft + \"px\";\n\n\t\t\t\t// Revert the changed values\n\t\t\t\tstyle.left = left;\n\t\t\t\tif ( rsLeft ) {\n\t\t\t\t\trs.left = rsLeft;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Support: IE\n\t\t\t// IE returns zIndex value as an integer.\n\t\t\treturn ret === undefined ?\n\t\t\t\tret :\n\t\t\tret + \"\" || \"auto\";\n\t\t};\n\t}\n\n\n\n\n\tfunction addGetHookIf( conditionFn, hookFn ) {\n\n\t\t// Define the hook, we'll check on the first run if it's really needed.\n\t\treturn {\n\t\t\tget: function() {\n\t\t\t\tif ( conditionFn() ) {\n\n\t\t\t\t\t// Hook not needed (or it's not possible to use it due\n\t\t\t\t\t// to missing dependency), remove it.\n\t\t\t\t\tdelete this.get;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Hook needed; redefine it so that the support test is not executed again.\n\t\t\t\treturn ( this.get = hookFn ).apply( this, arguments );\n\t\t\t}\n\t\t};\n\t}\n\n\n\tvar\n\n\t\tralpha = /alpha\\([^)]*\\)/i,\n\t\tropacity = /opacity\\s*=\\s*([^)]*)/i,\n\n\t\t// swappable if display is none or starts with table except\n\t\t// \"table\", \"table-cell\", or \"table-caption\"\n\t\t// see here for display values:\n\t\t// https://developer.mozilla.org/en-US/docs/CSS/display\n\t\trdisplayswap = /^(none|table(?!-c[ea]).+)/,\n\t\trnumsplit = new RegExp( \"^(\" + pnum + \")(.*)$\", \"i\" ),\n\n\t\tcssShow = { position: \"absolute\", visibility: \"hidden\", display: \"block\" },\n\t\tcssNormalTransform = {\n\t\t\tletterSpacing: \"0\",\n\t\t\tfontWeight: \"400\"\n\t\t},\n\n\t\tcssPrefixes = [ \"Webkit\", \"O\", \"Moz\", \"ms\" ],\n\t\temptyStyle = document.createElement( \"div\" ).style;\n\n\n// return a css property mapped to a potentially vendor prefixed property\n\tfunction vendorPropName( name ) {\n\n\t\t// shortcut for names that are not vendor prefixed\n\t\tif ( name in emptyStyle ) {\n\t\t\treturn name;\n\t\t}\n\n\t\t// check for vendor prefixed names\n\t\tvar capName = name.charAt( 0 ).toUpperCase() + name.slice( 1 ),\n\t\t\ti = cssPrefixes.length;\n\n\t\twhile ( i-- ) {\n\t\t\tname = cssPrefixes[ i ] + capName;\n\t\t\tif ( name in emptyStyle ) {\n\t\t\t\treturn name;\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction showHide( elements, show ) {\n\t\tvar display, elem, hidden,\n\t\t\tvalues = [],\n\t\t\tindex = 0,\n\t\t\tlength = elements.length;\n\n\t\tfor ( ; index < length; index++ ) {\n\t\t\telem = elements[ index ];\n\t\t\tif ( !elem.style ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tvalues[ index ] = jQuery._data( elem, \"olddisplay\" );\n\t\t\tdisplay = elem.style.display;\n\t\t\tif ( show ) {\n\n\t\t\t\t// Reset the inline display of this element to learn if it is\n\t\t\t\t// being hidden by cascaded rules or not\n\t\t\t\tif ( !values[ index ] && display === \"none\" ) {\n\t\t\t\t\telem.style.display = \"\";\n\t\t\t\t}\n\n\t\t\t\t// Set elements which have been overridden with display: none\n\t\t\t\t// in a stylesheet to whatever the default browser style is\n\t\t\t\t// for such an element\n\t\t\t\tif ( elem.style.display === \"\" && isHidden( elem ) ) {\n\t\t\t\t\tvalues[ index ] =\n\t\t\t\t\t\tjQuery._data( elem, \"olddisplay\", defaultDisplay( elem.nodeName ) );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\thidden = isHidden( elem );\n\n\t\t\t\tif ( display && display !== \"none\" || !hidden ) {\n\t\t\t\t\tjQuery._data(\n\t\t\t\t\t\telem,\n\t\t\t\t\t\t\"olddisplay\",\n\t\t\t\t\t\thidden ? display : jQuery.css( elem, \"display\" )\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Set the display of most of the elements in a second loop\n\t\t// to avoid the constant reflow\n\t\tfor ( index = 0; index < length; index++ ) {\n\t\t\telem = elements[ index ];\n\t\t\tif ( !elem.style ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\t\t\tif ( !show || elem.style.display === \"none\" || elem.style.display === \"\" ) {\n\t\t\t\telem.style.display = show ? values[ index ] || \"\" : \"none\";\n\t\t\t}\n\t\t}\n\n\t\treturn elements;\n\t}\n\n\tfunction setPositiveNumber( elem, value, subtract ) {\n\t\tvar matches = rnumsplit.exec( value );\n\t\treturn matches ?\n\n\t\t\t// Guard against undefined \"subtract\", e.g., when used as in cssHooks\n\t\tMath.max( 0, matches[ 1 ] - ( subtract || 0 ) ) + ( matches[ 2 ] || \"px\" ) :\n\t\t\tvalue;\n\t}\n\n\tfunction augmentWidthOrHeight( elem, name, extra, isBorderBox, styles ) {\n\t\tvar i = extra === ( isBorderBox ? \"border\" : \"content\" ) ?\n\n\t\t\t\t// If we already have the right measurement, avoid augmentation\n\t\t\t\t4 :\n\n\t\t\t\t// Otherwise initialize for horizontal or vertical properties\n\t\t\t\tname === \"width\" ? 1 : 0,\n\n\t\t\tval = 0;\n\n\t\tfor ( ; i < 4; i += 2 ) {\n\n\t\t\t// both box models exclude margin, so add it if we want it\n\t\t\tif ( extra === \"margin\" ) {\n\t\t\t\tval += jQuery.css( elem, extra + cssExpand[ i ], true, styles );\n\t\t\t}\n\n\t\t\tif ( isBorderBox ) {\n\n\t\t\t\t// border-box includes padding, so remove it if we want content\n\t\t\t\tif ( extra === \"content\" ) {\n\t\t\t\t\tval -= jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n\t\t\t\t}\n\n\t\t\t\t// at this point, extra isn't border nor margin, so remove border\n\t\t\t\tif ( extra !== \"margin\" ) {\n\t\t\t\t\tval -= jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n\t\t\t\t}\n\t\t\t} else {\n\n\t\t\t\t// at this point, extra isn't content, so add padding\n\t\t\t\tval += jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n\n\t\t\t\t// at this point, extra isn't content nor padding, so add border\n\t\t\t\tif ( extra !== \"padding\" ) {\n\t\t\t\t\tval += jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn val;\n\t}\n\n\tfunction getWidthOrHeight( elem, name, extra ) {\n\n\t\t// Start with offset property, which is equivalent to the border-box value\n\t\tvar valueIsBorderBox = true,\n\t\t\tval = name === \"width\" ? elem.offsetWidth : elem.offsetHeight,\n\t\t\tstyles = getStyles( elem ),\n\t\t\tisBorderBox = support.boxSizing &&\n\t\t\t\tjQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\";\n\n\t\t// some non-html elements return undefined for offsetWidth, so check for null/undefined\n\t\t// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285\n\t\t// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668\n\t\tif ( val <= 0 || val == null ) {\n\n\t\t\t// Fall back to computed then uncomputed css if necessary\n\t\t\tval = curCSS( elem, name, styles );\n\t\t\tif ( val < 0 || val == null ) {\n\t\t\t\tval = elem.style[ name ];\n\t\t\t}\n\n\t\t\t// Computed unit is not pixels. Stop here and return.\n\t\t\tif ( rnumnonpx.test( val ) ) {\n\t\t\t\treturn val;\n\t\t\t}\n\n\t\t\t// we need the check for style in case a browser which returns unreliable values\n\t\t\t// for getComputedStyle silently falls back to the reliable elem.style\n\t\t\tvalueIsBorderBox = isBorderBox &&\n\t\t\t\t( support.boxSizingReliable() || val === elem.style[ name ] );\n\n\t\t\t// Normalize \"\", auto, and prepare for extra\n\t\t\tval = parseFloat( val ) || 0;\n\t\t}\n\n\t\t// use the active box-sizing model to add/subtract irrelevant styles\n\t\treturn ( val +\n\t\t\t\taugmentWidthOrHeight(\n\t\t\t\t\telem,\n\t\t\t\t\tname,\n\t\t\t\t\textra || ( isBorderBox ? \"border\" : \"content\" ),\n\t\t\t\t\tvalueIsBorderBox,\n\t\t\t\t\tstyles\n\t\t\t\t)\n\t\t\t) + \"px\";\n\t}\n\n\tjQuery.extend( {\n\n\t\t// Add in style property hooks for overriding the default\n\t\t// behavior of getting and setting a style property\n\t\tcssHooks: {\n\t\t\topacity: {\n\t\t\t\tget: function( elem, computed ) {\n\t\t\t\t\tif ( computed ) {\n\n\t\t\t\t\t\t// We should always get a number back from opacity\n\t\t\t\t\t\tvar ret = curCSS( elem, \"opacity\" );\n\t\t\t\t\t\treturn ret === \"\" ? \"1\" : ret;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t// Don't automatically add \"px\" to these possibly-unitless properties\n\t\tcssNumber: {\n\t\t\t\"animationIterationCount\": true,\n\t\t\t\"columnCount\": true,\n\t\t\t\"fillOpacity\": true,\n\t\t\t\"flexGrow\": true,\n\t\t\t\"flexShrink\": true,\n\t\t\t\"fontWeight\": true,\n\t\t\t\"lineHeight\": true,\n\t\t\t\"opacity\": true,\n\t\t\t\"order\": true,\n\t\t\t\"orphans\": true,\n\t\t\t\"widows\": true,\n\t\t\t\"zIndex\": true,\n\t\t\t\"zoom\": true\n\t\t},\n\n\t\t// Add in properties whose names you wish to fix before\n\t\t// setting or getting the value\n\t\tcssProps: {\n\n\t\t\t// normalize float css property\n\t\t\t\"float\": support.cssFloat ? \"cssFloat\" : \"styleFloat\"\n\t\t},\n\n\t\t// Get and set the style property on a DOM Node\n\t\tstyle: function( elem, name, value, extra ) {\n\n\t\t\t// Don't set styles on text and comment nodes\n\t\t\tif ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Make sure that we're working with the right name\n\t\t\tvar ret, type, hooks,\n\t\t\t\torigName = jQuery.camelCase( name ),\n\t\t\t\tstyle = elem.style;\n\n\t\t\tname = jQuery.cssProps[ origName ] ||\n\t\t\t\t( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );\n\n\t\t\t// gets hook for the prefixed version\n\t\t\t// followed by the unprefixed version\n\t\t\thooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n\t\t\t// Check if we're setting a value\n\t\t\tif ( value !== undefined ) {\n\t\t\t\ttype = typeof value;\n\n\t\t\t\t// Convert \"+=\" or \"-=\" to relative numbers (#7345)\n\t\t\t\tif ( type === \"string\" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {\n\t\t\t\t\tvalue = adjustCSS( elem, name, ret );\n\n\t\t\t\t\t// Fixes bug #9237\n\t\t\t\t\ttype = \"number\";\n\t\t\t\t}\n\n\t\t\t\t// Make sure that null and NaN values aren't set. See: #7116\n\t\t\t\tif ( value == null || value !== value ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// If a number was passed in, add the unit (except for certain CSS properties)\n\t\t\t\tif ( type === \"number\" ) {\n\t\t\t\t\tvalue += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? \"\" : \"px\" );\n\t\t\t\t}\n\n\t\t\t\t// Fixes #8908, it can be done more correctly by specifing setters in cssHooks,\n\t\t\t\t// but it would mean to define eight\n\t\t\t\t// (for every problematic property) identical functions\n\t\t\t\tif ( !support.clearCloneStyle && value === \"\" && name.indexOf( \"background\" ) === 0 ) {\n\t\t\t\t\tstyle[ name ] = \"inherit\";\n\t\t\t\t}\n\n\t\t\t\t// If a hook was provided, use that value, otherwise just set the specified value\n\t\t\t\tif ( !hooks || !( \"set\" in hooks ) ||\n\t\t\t\t\t( value = hooks.set( elem, value, extra ) ) !== undefined ) {\n\n\t\t\t\t\t// Support: IE\n\t\t\t\t\t// Swallow errors from 'invalid' CSS values (#5509)\n\t\t\t\t\ttry {\n\t\t\t\t\t\tstyle[ name ] = value;\n\t\t\t\t\t} catch ( e ) {}\n\t\t\t\t}\n\n\t\t\t} else {\n\n\t\t\t\t// If a hook was provided get the non-computed value from there\n\t\t\t\tif ( hooks && \"get\" in hooks &&\n\t\t\t\t\t( ret = hooks.get( elem, false, extra ) ) !== undefined ) {\n\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\n\t\t\t\t// Otherwise just get the value from the style object\n\t\t\t\treturn style[ name ];\n\t\t\t}\n\t\t},\n\n\t\tcss: function( elem, name, extra, styles ) {\n\t\t\tvar num, val, hooks,\n\t\t\t\torigName = jQuery.camelCase( name );\n\n\t\t\t// Make sure that we're working with the right name\n\t\t\tname = jQuery.cssProps[ origName ] ||\n\t\t\t\t( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );\n\n\t\t\t// gets hook for the prefixed version\n\t\t\t// followed by the unprefixed version\n\t\t\thooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n\t\t\t// If a hook was provided get the computed value from there\n\t\t\tif ( hooks && \"get\" in hooks ) {\n\t\t\t\tval = hooks.get( elem, true, extra );\n\t\t\t}\n\n\t\t\t// Otherwise, if a way to get the computed value exists, use that\n\t\t\tif ( val === undefined ) {\n\t\t\t\tval = curCSS( elem, name, styles );\n\t\t\t}\n\n\t\t\t//convert \"normal\" to computed value\n\t\t\tif ( val === \"normal\" && name in cssNormalTransform ) {\n\t\t\t\tval = cssNormalTransform[ name ];\n\t\t\t}\n\n\t\t\t// Return, converting to number if forced or a qualifier was provided and val looks numeric\n\t\t\tif ( extra === \"\" || extra ) {\n\t\t\t\tnum = parseFloat( val );\n\t\t\t\treturn extra === true || isFinite( num ) ? num || 0 : val;\n\t\t\t}\n\t\t\treturn val;\n\t\t}\n\t} );\n\n\tjQuery.each( [ \"height\", \"width\" ], function( i, name ) {\n\t\tjQuery.cssHooks[ name ] = {\n\t\t\tget: function( elem, computed, extra ) {\n\t\t\t\tif ( computed ) {\n\n\t\t\t\t\t// certain elements can have dimension info if we invisibly show them\n\t\t\t\t\t// however, it must have a current display style that would benefit from this\n\t\t\t\t\treturn rdisplayswap.test( jQuery.css( elem, \"display\" ) ) &&\n\t\t\t\t\telem.offsetWidth === 0 ?\n\t\t\t\t\t\tswap( elem, cssShow, function() {\n\t\t\t\t\t\t\treturn getWidthOrHeight( elem, name, extra );\n\t\t\t\t\t\t} ) :\n\t\t\t\t\t\tgetWidthOrHeight( elem, name, extra );\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tset: function( elem, value, extra ) {\n\t\t\t\tvar styles = extra && getStyles( elem );\n\t\t\t\treturn setPositiveNumber( elem, value, extra ?\n\t\t\t\t\taugmentWidthOrHeight(\n\t\t\t\t\t\telem,\n\t\t\t\t\t\tname,\n\t\t\t\t\t\textra,\n\t\t\t\t\t\tsupport.boxSizing &&\n\t\t\t\t\t\tjQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\",\n\t\t\t\t\t\tstyles\n\t\t\t\t\t) : 0\n\t\t\t\t);\n\t\t\t}\n\t\t};\n\t} );\n\n\tif ( !support.opacity ) {\n\t\tjQuery.cssHooks.opacity = {\n\t\t\tget: function( elem, computed ) {\n\n\t\t\t\t// IE uses filters for opacity\n\t\t\t\treturn ropacity.test( ( computed && elem.currentStyle ?\n\t\t\t\t\t\telem.currentStyle.filter :\n\t\t\t\t\t\telem.style.filter ) || \"\" ) ?\n\t\t\t\t( 0.01 * parseFloat( RegExp.$1 ) ) + \"\" :\n\t\t\t\t\tcomputed ? \"1\" : \"\";\n\t\t\t},\n\n\t\t\tset: function( elem, value ) {\n\t\t\t\tvar style = elem.style,\n\t\t\t\t\tcurrentStyle = elem.currentStyle,\n\t\t\t\t\topacity = jQuery.isNumeric( value ) ? \"alpha(opacity=\" + value * 100 + \")\" : \"\",\n\t\t\t\t\tfilter = currentStyle && currentStyle.filter || style.filter || \"\";\n\n\t\t\t\t// IE has trouble with opacity if it does not have layout\n\t\t\t\t// Force it by setting the zoom level\n\t\t\t\tstyle.zoom = 1;\n\n\t\t\t\t// if setting opacity to 1, and no other filters exist -\n\t\t\t\t// attempt to remove filter attribute #6652\n\t\t\t\t// if value === \"\", then remove inline opacity #12685\n\t\t\t\tif ( ( value >= 1 || value === \"\" ) &&\n\t\t\t\t\tjQuery.trim( filter.replace( ralpha, \"\" ) ) === \"\" &&\n\t\t\t\t\tstyle.removeAttribute ) {\n\n\t\t\t\t\t// Setting style.filter to null, \"\" & \" \" still leave \"filter:\" in the cssText\n\t\t\t\t\t// if \"filter:\" is present at all, clearType is disabled, we want to avoid this\n\t\t\t\t\t// style.removeAttribute is IE Only, but so apparently is this code path...\n\t\t\t\t\tstyle.removeAttribute( \"filter\" );\n\n\t\t\t\t\t// if there is no filter style applied in a css rule\n\t\t\t\t\t// or unset inline opacity, we are done\n\t\t\t\t\tif ( value === \"\" || currentStyle && !currentStyle.filter ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// otherwise, set new filter values\n\t\t\t\tstyle.filter = ralpha.test( filter ) ?\n\t\t\t\t\tfilter.replace( ralpha, opacity ) :\n\t\t\t\tfilter + \" \" + opacity;\n\t\t\t}\n\t\t};\n\t}\n\n\tjQuery.cssHooks.marginRight = addGetHookIf( support.reliableMarginRight,\n\t\tfunction( elem, computed ) {\n\t\t\tif ( computed ) {\n\t\t\t\treturn swap( elem, { \"display\": \"inline-block\" },\n\t\t\t\t\tcurCSS, [ elem, \"marginRight\" ] );\n\t\t\t}\n\t\t}\n\t);\n\n\tjQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,\n\t\tfunction( elem, computed ) {\n\t\t\tif ( computed ) {\n\t\t\t\treturn (\n\t\t\t\t\t\tparseFloat( curCSS( elem, \"marginLeft\" ) ) ||\n\n\t\t\t\t\t\t// Support: IE<=11+\n\t\t\t\t\t\t// Running getBoundingClientRect on a disconnected node in IE throws an error\n\t\t\t\t\t\t// Support: IE8 only\n\t\t\t\t\t\t// getClientRects() errors on disconnected elems\n\t\t\t\t\t\t( jQuery.contains( elem.ownerDocument, elem ) ?\n\t\t\t\t\t\t\telem.getBoundingClientRect().left -\n\t\t\t\t\t\t\tswap( elem, { marginLeft: 0 }, function() {\n\t\t\t\t\t\t\t\treturn elem.getBoundingClientRect().left;\n\t\t\t\t\t\t\t} ) :\n\t\t\t\t\t\t\t\t0\n\t\t\t\t\t\t)\n\t\t\t\t\t) + \"px\";\n\t\t\t}\n\t\t}\n\t);\n\n// These hooks are used by animate to expand properties\n\tjQuery.each( {\n\t\tmargin: \"\",\n\t\tpadding: \"\",\n\t\tborder: \"Width\"\n\t}, function( prefix, suffix ) {\n\t\tjQuery.cssHooks[ prefix + suffix ] = {\n\t\t\texpand: function( value ) {\n\t\t\t\tvar i = 0,\n\t\t\t\t\texpanded = {},\n\n\t\t\t\t\t// assumes a single number if not a string\n\t\t\t\t\tparts = typeof value === \"string\" ? value.split( \" \" ) : [ value ];\n\n\t\t\t\tfor ( ; i < 4; i++ ) {\n\t\t\t\t\texpanded[ prefix + cssExpand[ i ] + suffix ] =\n\t\t\t\t\t\tparts[ i ] || parts[ i - 2 ] || parts[ 0 ];\n\t\t\t\t}\n\n\t\t\t\treturn expanded;\n\t\t\t}\n\t\t};\n\n\t\tif ( !rmargin.test( prefix ) ) {\n\t\t\tjQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;\n\t\t}\n\t} );\n\n\tjQuery.fn.extend( {\n\t\tcss: function( name, value ) {\n\t\t\treturn access( this, function( elem, name, value ) {\n\t\t\t\tvar styles, len,\n\t\t\t\t\tmap = {},\n\t\t\t\t\ti = 0;\n\n\t\t\t\tif ( jQuery.isArray( name ) ) {\n\t\t\t\t\tstyles = getStyles( elem );\n\t\t\t\t\tlen = name.length;\n\n\t\t\t\t\tfor ( ; i < len; i++ ) {\n\t\t\t\t\t\tmap[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );\n\t\t\t\t\t}\n\n\t\t\t\t\treturn map;\n\t\t\t\t}\n\n\t\t\t\treturn value !== undefined ?\n\t\t\t\t\tjQuery.style( elem, name, value ) :\n\t\t\t\t\tjQuery.css( elem, name );\n\t\t\t}, name, value, arguments.length > 1 );\n\t\t},\n\t\tshow: function() {\n\t\t\treturn showHide( this, true );\n\t\t},\n\t\thide: function() {\n\t\t\treturn showHide( this );\n\t\t},\n\t\ttoggle: function( state ) {\n\t\t\tif ( typeof state === \"boolean\" ) {\n\t\t\t\treturn state ? this.show() : this.hide();\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tif ( isHidden( this ) ) {\n\t\t\t\t\tjQuery( this ).show();\n\t\t\t\t} else {\n\t\t\t\t\tjQuery( this ).hide();\n\t\t\t\t}\n\t\t\t} );\n\t\t}\n\t} );\n\n\n\tfunction Tween( elem, options, prop, end, easing ) {\n\t\treturn new Tween.prototype.init( elem, options, prop, end, easing );\n\t}\n\tjQuery.Tween = Tween;\n\n\tTween.prototype = {\n\t\tconstructor: Tween,\n\t\tinit: function( elem, options, prop, end, easing, unit ) {\n\t\t\tthis.elem = elem;\n\t\t\tthis.prop = prop;\n\t\t\tthis.easing = easing || jQuery.easing._default;\n\t\t\tthis.options = options;\n\t\t\tthis.start = this.now = this.cur();\n\t\t\tthis.end = end;\n\t\t\tthis.unit = unit || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" );\n\t\t},\n\t\tcur: function() {\n\t\t\tvar hooks = Tween.propHooks[ this.prop ];\n\n\t\t\treturn hooks && hooks.get ?\n\t\t\t\thooks.get( this ) :\n\t\t\t\tTween.propHooks._default.get( this );\n\t\t},\n\t\trun: function( percent ) {\n\t\t\tvar eased,\n\t\t\t\thooks = Tween.propHooks[ this.prop ];\n\n\t\t\tif ( this.options.duration ) {\n\t\t\t\tthis.pos = eased = jQuery.easing[ this.easing ](\n\t\t\t\t\tpercent, this.options.duration * percent, 0, 1, this.options.duration\n\t\t\t\t);\n\t\t\t} else {\n\t\t\t\tthis.pos = eased = percent;\n\t\t\t}\n\t\t\tthis.now = ( this.end - this.start ) * eased + this.start;\n\n\t\t\tif ( this.options.step ) {\n\t\t\t\tthis.options.step.call( this.elem, this.now, this );\n\t\t\t}\n\n\t\t\tif ( hooks && hooks.set ) {\n\t\t\t\thooks.set( this );\n\t\t\t} else {\n\t\t\t\tTween.propHooks._default.set( this );\n\t\t\t}\n\t\t\treturn this;\n\t\t}\n\t};\n\n\tTween.prototype.init.prototype = Tween.prototype;\n\n\tTween.propHooks = {\n\t\t_default: {\n\t\t\tget: function( tween ) {\n\t\t\t\tvar result;\n\n\t\t\t\t// Use a property on the element directly when it is not a DOM element,\n\t\t\t\t// or when there is no matching style property that exists.\n\t\t\t\tif ( tween.elem.nodeType !== 1 ||\n\t\t\t\t\ttween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {\n\t\t\t\t\treturn tween.elem[ tween.prop ];\n\t\t\t\t}\n\n\t\t\t\t// passing an empty string as a 3rd parameter to .css will automatically\n\t\t\t\t// attempt a parseFloat and fallback to a string if the parse fails\n\t\t\t\t// so, simple values such as \"10px\" are parsed to Float.\n\t\t\t\t// complex values such as \"rotate(1rad)\" are returned as is.\n\t\t\t\tresult = jQuery.css( tween.elem, tween.prop, \"\" );\n\n\t\t\t\t// Empty strings, null, undefined and \"auto\" are converted to 0.\n\t\t\t\treturn !result || result === \"auto\" ? 0 : result;\n\t\t\t},\n\t\t\tset: function( tween ) {\n\n\t\t\t\t// use step hook for back compat - use cssHook if its there - use .style if its\n\t\t\t\t// available and use plain properties where available\n\t\t\t\tif ( jQuery.fx.step[ tween.prop ] ) {\n\t\t\t\t\tjQuery.fx.step[ tween.prop ]( tween );\n\t\t\t\t} else if ( tween.elem.nodeType === 1 &&\n\t\t\t\t\t( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null ||\n\t\t\t\t\tjQuery.cssHooks[ tween.prop ] ) ) {\n\t\t\t\t\tjQuery.style( tween.elem, tween.prop, tween.now + tween.unit );\n\t\t\t\t} else {\n\t\t\t\t\ttween.elem[ tween.prop ] = tween.now;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n\n// Support: IE <=9\n// Panic based approach to setting things on disconnected nodes\n\n\tTween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {\n\t\tset: function( tween ) {\n\t\t\tif ( tween.elem.nodeType && tween.elem.parentNode ) {\n\t\t\t\ttween.elem[ tween.prop ] = tween.now;\n\t\t\t}\n\t\t}\n\t};\n\n\tjQuery.easing = {\n\t\tlinear: function( p ) {\n\t\t\treturn p;\n\t\t},\n\t\tswing: function( p ) {\n\t\t\treturn 0.5 - Math.cos( p * Math.PI ) / 2;\n\t\t},\n\t\t_default: \"swing\"\n\t};\n\n\tjQuery.fx = Tween.prototype.init;\n\n// Back Compat <1.8 extension point\n\tjQuery.fx.step = {};\n\n\n\n\n\tvar\n\t\tfxNow, timerId,\n\t\trfxtypes = /^(?:toggle|show|hide)$/,\n\t\trrun = /queueHooks$/;\n\n// Animations created synchronously will run synchronously\n\tfunction createFxNow() {\n\t\twindow.setTimeout( function() {\n\t\t\tfxNow = undefined;\n\t\t} );\n\t\treturn ( fxNow = jQuery.now() );\n\t}\n\n// Generate parameters to create a standard animation\n\tfunction genFx( type, includeWidth ) {\n\t\tvar which,\n\t\t\tattrs = { height: type },\n\t\t\ti = 0;\n\n\t\t// if we include width, step value is 1 to do all cssExpand values,\n\t\t// if we don't include width, step value is 2 to skip over Left and Right\n\t\tincludeWidth = includeWidth ? 1 : 0;\n\t\tfor ( ; i < 4 ; i += 2 - includeWidth ) {\n\t\t\twhich = cssExpand[ i ];\n\t\t\tattrs[ \"margin\" + which ] = attrs[ \"padding\" + which ] = type;\n\t\t}\n\n\t\tif ( includeWidth ) {\n\t\t\tattrs.opacity = attrs.width = type;\n\t\t}\n\n\t\treturn attrs;\n\t}\n\n\tfunction createTween( value, prop, animation ) {\n\t\tvar tween,\n\t\t\tcollection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ \"*\" ] ),\n\t\t\tindex = 0,\n\t\t\tlength = collection.length;\n\t\tfor ( ; index < length; index++ ) {\n\t\t\tif ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {\n\n\t\t\t\t// we're done with this property\n\t\t\t\treturn tween;\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction defaultPrefilter( elem, props, opts ) {\n\t\t/* jshint validthis: true */\n\t\tvar prop, value, toggle, tween, hooks, oldfire, display, checkDisplay,\n\t\t\tanim = this,\n\t\t\torig = {},\n\t\t\tstyle = elem.style,\n\t\t\thidden = elem.nodeType && isHidden( elem ),\n\t\t\tdataShow = jQuery._data( elem, \"fxshow\" );\n\n\t\t// handle queue: false promises\n\t\tif ( !opts.queue ) {\n\t\t\thooks = jQuery._queueHooks( elem, \"fx\" );\n\t\t\tif ( hooks.unqueued == null ) {\n\t\t\t\thooks.unqueued = 0;\n\t\t\t\toldfire = hooks.empty.fire;\n\t\t\t\thooks.empty.fire = function() {\n\t\t\t\t\tif ( !hooks.unqueued ) {\n\t\t\t\t\t\toldfire();\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\t\t\thooks.unqueued++;\n\n\t\t\tanim.always( function() {\n\n\t\t\t\t// doing this makes sure that the complete handler will be called\n\t\t\t\t// before this completes\n\t\t\t\tanim.always( function() {\n\t\t\t\t\thooks.unqueued--;\n\t\t\t\t\tif ( !jQuery.queue( elem, \"fx\" ).length ) {\n\t\t\t\t\t\thooks.empty.fire();\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t} );\n\t\t}\n\n\t\t// height/width overflow pass\n\t\tif ( elem.nodeType === 1 && ( \"height\" in props || \"width\" in props ) ) {\n\n\t\t\t// Make sure that nothing sneaks out\n\t\t\t// Record all 3 overflow attributes because IE does not\n\t\t\t// change the overflow attribute when overflowX and\n\t\t\t// overflowY are set to the same value\n\t\t\topts.overflow = [ style.overflow, style.overflowX, style.overflowY ];\n\n\t\t\t// Set display property to inline-block for height/width\n\t\t\t// animations on inline elements that are having width/height animated\n\t\t\tdisplay = jQuery.css( elem, \"display\" );\n\n\t\t\t// Test default display if display is currently \"none\"\n\t\t\tcheckDisplay = display === \"none\" ?\n\t\t\tjQuery._data( elem, \"olddisplay\" ) || defaultDisplay( elem.nodeName ) : display;\n\n\t\t\tif ( checkDisplay === \"inline\" && jQuery.css( elem, \"float\" ) === \"none\" ) {\n\n\t\t\t\t// inline-level elements accept inline-block;\n\t\t\t\t// block-level elements need to be inline with layout\n\t\t\t\tif ( !support.inlineBlockNeedsLayout || defaultDisplay( elem.nodeName ) === \"inline\" ) {\n\t\t\t\t\tstyle.display = \"inline-block\";\n\t\t\t\t} else {\n\t\t\t\t\tstyle.zoom = 1;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif ( opts.overflow ) {\n\t\t\tstyle.overflow = \"hidden\";\n\t\t\tif ( !support.shrinkWrapBlocks() ) {\n\t\t\t\tanim.always( function() {\n\t\t\t\t\tstyle.overflow = opts.overflow[ 0 ];\n\t\t\t\t\tstyle.overflowX = opts.overflow[ 1 ];\n\t\t\t\t\tstyle.overflowY = opts.overflow[ 2 ];\n\t\t\t\t} );\n\t\t\t}\n\t\t}\n\n\t\t// show/hide pass\n\t\tfor ( prop in props ) {\n\t\t\tvalue = props[ prop ];\n\t\t\tif ( rfxtypes.exec( value ) ) {\n\t\t\t\tdelete props[ prop ];\n\t\t\t\ttoggle = toggle || value === \"toggle\";\n\t\t\t\tif ( value === ( hidden ? \"hide\" : \"show\" ) ) {\n\n\t\t\t\t\t// If there is dataShow left over from a stopped hide or show\n\t\t\t\t\t// and we are going to proceed with show, we should pretend to be hidden\n\t\t\t\t\tif ( value === \"show\" && dataShow && dataShow[ prop ] !== undefined ) {\n\t\t\t\t\t\thidden = true;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\torig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );\n\n\t\t\t\t// Any non-fx value stops us from restoring the original display value\n\t\t\t} else {\n\t\t\t\tdisplay = undefined;\n\t\t\t}\n\t\t}\n\n\t\tif ( !jQuery.isEmptyObject( orig ) ) {\n\t\t\tif ( dataShow ) {\n\t\t\t\tif ( \"hidden\" in dataShow ) {\n\t\t\t\t\thidden = dataShow.hidden;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tdataShow = jQuery._data( elem, \"fxshow\", {} );\n\t\t\t}\n\n\t\t\t// store state if its toggle - enables .stop().toggle() to \"reverse\"\n\t\t\tif ( toggle ) {\n\t\t\t\tdataShow.hidden = !hidden;\n\t\t\t}\n\t\t\tif ( hidden ) {\n\t\t\t\tjQuery( elem ).show();\n\t\t\t} else {\n\t\t\t\tanim.done( function() {\n\t\t\t\t\tjQuery( elem ).hide();\n\t\t\t\t} );\n\t\t\t}\n\t\t\tanim.done( function() {\n\t\t\t\tvar prop;\n\t\t\t\tjQuery._removeData( elem, \"fxshow\" );\n\t\t\t\tfor ( prop in orig ) {\n\t\t\t\t\tjQuery.style( elem, prop, orig[ prop ] );\n\t\t\t\t}\n\t\t\t} );\n\t\t\tfor ( prop in orig ) {\n\t\t\t\ttween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );\n\n\t\t\t\tif ( !( prop in dataShow ) ) {\n\t\t\t\t\tdataShow[ prop ] = tween.start;\n\t\t\t\t\tif ( hidden ) {\n\t\t\t\t\t\ttween.end = tween.start;\n\t\t\t\t\t\ttween.start = prop === \"width\" || prop === \"height\" ? 1 : 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// If this is a noop like .hide().hide(), restore an overwritten display value\n\t\t} else if ( ( display === \"none\" ? defaultDisplay( elem.nodeName ) : display ) === \"inline\" ) {\n\t\t\tstyle.display = display;\n\t\t}\n\t}\n\n\tfunction propFilter( props, specialEasing ) {\n\t\tvar index, name, easing, value, hooks;\n\n\t\t// camelCase, specialEasing and expand cssHook pass\n\t\tfor ( index in props ) {\n\t\t\tname = jQuery.camelCase( index );\n\t\t\teasing = specialEasing[ name ];\n\t\t\tvalue = props[ index ];\n\t\t\tif ( jQuery.isArray( value ) ) {\n\t\t\t\teasing = value[ 1 ];\n\t\t\t\tvalue = props[ index ] = value[ 0 ];\n\t\t\t}\n\n\t\t\tif ( index !== name ) {\n\t\t\t\tprops[ name ] = value;\n\t\t\t\tdelete props[ index ];\n\t\t\t}\n\n\t\t\thooks = jQuery.cssHooks[ name ];\n\t\t\tif ( hooks && \"expand\" in hooks ) {\n\t\t\t\tvalue = hooks.expand( value );\n\t\t\t\tdelete props[ name ];\n\n\t\t\t\t// not quite $.extend, this wont overwrite keys already present.\n\t\t\t\t// also - reusing 'index' from above because we have the correct \"name\"\n\t\t\t\tfor ( index in value ) {\n\t\t\t\t\tif ( !( index in props ) ) {\n\t\t\t\t\t\tprops[ index ] = value[ index ];\n\t\t\t\t\t\tspecialEasing[ index ] = easing;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tspecialEasing[ name ] = easing;\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction Animation( elem, properties, options ) {\n\t\tvar result,\n\t\t\tstopped,\n\t\t\tindex = 0,\n\t\t\tlength = Animation.prefilters.length,\n\t\t\tdeferred = jQuery.Deferred().always( function() {\n\n\t\t\t\t// don't match elem in the :animated selector\n\t\t\t\tdelete tick.elem;\n\t\t\t} ),\n\t\t\ttick = function() {\n\t\t\t\tif ( stopped ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tvar currentTime = fxNow || createFxNow(),\n\t\t\t\t\tremaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),\n\n\t\t\t\t\t// Support: Android 2.3\n\t\t\t\t\t// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)\n\t\t\t\t\ttemp = remaining / animation.duration || 0,\n\t\t\t\t\tpercent = 1 - temp,\n\t\t\t\t\tindex = 0,\n\t\t\t\t\tlength = animation.tweens.length;\n\n\t\t\t\tfor ( ; index < length ; index++ ) {\n\t\t\t\t\tanimation.tweens[ index ].run( percent );\n\t\t\t\t}\n\n\t\t\t\tdeferred.notifyWith( elem, [ animation, percent, remaining ] );\n\n\t\t\t\tif ( percent < 1 && length ) {\n\t\t\t\t\treturn remaining;\n\t\t\t\t} else {\n\t\t\t\t\tdeferred.resolveWith( elem, [ animation ] );\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t},\n\t\t\tanimation = deferred.promise( {\n\t\t\t\telem: elem,\n\t\t\t\tprops: jQuery.extend( {}, properties ),\n\t\t\t\topts: jQuery.extend( true, {\n\t\t\t\t\tspecialEasing: {},\n\t\t\t\t\teasing: jQuery.easing._default\n\t\t\t\t}, options ),\n\t\t\t\toriginalProperties: properties,\n\t\t\t\toriginalOptions: options,\n\t\t\t\tstartTime: fxNow || createFxNow(),\n\t\t\t\tduration: options.duration,\n\t\t\t\ttweens: [],\n\t\t\t\tcreateTween: function( prop, end ) {\n\t\t\t\t\tvar tween = jQuery.Tween( elem, animation.opts, prop, end,\n\t\t\t\t\t\tanimation.opts.specialEasing[ prop ] || animation.opts.easing );\n\t\t\t\t\tanimation.tweens.push( tween );\n\t\t\t\t\treturn tween;\n\t\t\t\t},\n\t\t\t\tstop: function( gotoEnd ) {\n\t\t\t\t\tvar index = 0,\n\n\t\t\t\t\t\t// if we are going to the end, we want to run all the tweens\n\t\t\t\t\t\t// otherwise we skip this part\n\t\t\t\t\t\tlength = gotoEnd ? animation.tweens.length : 0;\n\t\t\t\t\tif ( stopped ) {\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t}\n\t\t\t\t\tstopped = true;\n\t\t\t\t\tfor ( ; index < length ; index++ ) {\n\t\t\t\t\t\tanimation.tweens[ index ].run( 1 );\n\t\t\t\t\t}\n\n\t\t\t\t\t// resolve when we played the last frame\n\t\t\t\t\t// otherwise, reject\n\t\t\t\t\tif ( gotoEnd ) {\n\t\t\t\t\t\tdeferred.notifyWith( elem, [ animation, 1, 0 ] );\n\t\t\t\t\t\tdeferred.resolveWith( elem, [ animation, gotoEnd ] );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tdeferred.rejectWith( elem, [ animation, gotoEnd ] );\n\t\t\t\t\t}\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t} ),\n\t\t\tprops = animation.props;\n\n\t\tpropFilter( props, animation.opts.specialEasing );\n\n\t\tfor ( ; index < length ; index++ ) {\n\t\t\tresult = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );\n\t\t\tif ( result ) {\n\t\t\t\tif ( jQuery.isFunction( result.stop ) ) {\n\t\t\t\t\tjQuery._queueHooks( animation.elem, animation.opts.queue ).stop =\n\t\t\t\t\t\tjQuery.proxy( result.stop, result );\n\t\t\t\t}\n\t\t\t\treturn result;\n\t\t\t}\n\t\t}\n\n\t\tjQuery.map( props, createTween, animation );\n\n\t\tif ( jQuery.isFunction( animation.opts.start ) ) {\n\t\t\tanimation.opts.start.call( elem, animation );\n\t\t}\n\n\t\tjQuery.fx.timer(\n\t\t\tjQuery.extend( tick, {\n\t\t\t\telem: elem,\n\t\t\t\tanim: animation,\n\t\t\t\tqueue: animation.opts.queue\n\t\t\t} )\n\t\t);\n\n\t\t// attach callbacks from options\n\t\treturn animation.progress( animation.opts.progress )\n\t\t\t.done( animation.opts.done, animation.opts.complete )\n\t\t\t.fail( animation.opts.fail )\n\t\t\t.always( animation.opts.always );\n\t}\n\n\tjQuery.Animation = jQuery.extend( Animation, {\n\n\t\ttweeners: {\n\t\t\t\"*\": [ function( prop, value ) {\n\t\t\t\tvar tween = this.createTween( prop, value );\n\t\t\t\tadjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );\n\t\t\t\treturn tween;\n\t\t\t} ]\n\t\t},\n\n\t\ttweener: function( props, callback ) {\n\t\t\tif ( jQuery.isFunction( props ) ) {\n\t\t\t\tcallback = props;\n\t\t\t\tprops = [ \"*\" ];\n\t\t\t} else {\n\t\t\t\tprops = props.match( rnotwhite );\n\t\t\t}\n\n\t\t\tvar prop,\n\t\t\t\tindex = 0,\n\t\t\t\tlength = props.length;\n\n\t\t\tfor ( ; index < length ; index++ ) {\n\t\t\t\tprop = props[ index ];\n\t\t\t\tAnimation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];\n\t\t\t\tAnimation.tweeners[ prop ].unshift( callback );\n\t\t\t}\n\t\t},\n\n\t\tprefilters: [ defaultPrefilter ],\n\n\t\tprefilter: function( callback, prepend ) {\n\t\t\tif ( prepend ) {\n\t\t\t\tAnimation.prefilters.unshift( callback );\n\t\t\t} else {\n\t\t\t\tAnimation.prefilters.push( callback );\n\t\t\t}\n\t\t}\n\t} );\n\n\tjQuery.speed = function( speed, easing, fn ) {\n\t\tvar opt = speed && typeof speed === \"object\" ? jQuery.extend( {}, speed ) : {\n\t\t\tcomplete: fn || !fn && easing ||\n\t\t\tjQuery.isFunction( speed ) && speed,\n\t\t\tduration: speed,\n\t\t\teasing: fn && easing || easing && !jQuery.isFunction( easing ) && easing\n\t\t};\n\n\t\topt.duration = jQuery.fx.off ? 0 : typeof opt.duration === \"number\" ? opt.duration :\n\t\t\topt.duration in jQuery.fx.speeds ?\n\t\t\t\tjQuery.fx.speeds[ opt.duration ] : jQuery.fx.speeds._default;\n\n\t\t// normalize opt.queue - true/undefined/null -> \"fx\"\n\t\tif ( opt.queue == null || opt.queue === true ) {\n\t\t\topt.queue = \"fx\";\n\t\t}\n\n\t\t// Queueing\n\t\topt.old = opt.complete;\n\n\t\topt.complete = function() {\n\t\t\tif ( jQuery.isFunction( opt.old ) ) {\n\t\t\t\topt.old.call( this );\n\t\t\t}\n\n\t\t\tif ( opt.queue ) {\n\t\t\t\tjQuery.dequeue( this, opt.queue );\n\t\t\t}\n\t\t};\n\n\t\treturn opt;\n\t};\n\n\tjQuery.fn.extend( {\n\t\tfadeTo: function( speed, to, easing, callback ) {\n\n\t\t\t// show any hidden elements after setting opacity to 0\n\t\t\treturn this.filter( isHidden ).css( \"opacity\", 0 ).show()\n\n\t\t\t// animate to the value specified\n\t\t\t\t.end().animate( { opacity: to }, speed, easing, callback );\n\t\t},\n\t\tanimate: function( prop, speed, easing, callback ) {\n\t\t\tvar empty = jQuery.isEmptyObject( prop ),\n\t\t\t\toptall = jQuery.speed( speed, easing, callback ),\n\t\t\t\tdoAnimation = function() {\n\n\t\t\t\t\t// Operate on a copy of prop so per-property easing won't be lost\n\t\t\t\t\tvar anim = Animation( this, jQuery.extend( {}, prop ), optall );\n\n\t\t\t\t\t// Empty animations, or finishing resolves immediately\n\t\t\t\t\tif ( empty || jQuery._data( this, \"finish\" ) ) {\n\t\t\t\t\t\tanim.stop( true );\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\tdoAnimation.finish = doAnimation;\n\n\t\t\treturn empty || optall.queue === false ?\n\t\t\t\tthis.each( doAnimation ) :\n\t\t\t\tthis.queue( optall.queue, doAnimation );\n\t\t},\n\t\tstop: function( type, clearQueue, gotoEnd ) {\n\t\t\tvar stopQueue = function( hooks ) {\n\t\t\t\tvar stop = hooks.stop;\n\t\t\t\tdelete hooks.stop;\n\t\t\t\tstop( gotoEnd );\n\t\t\t};\n\n\t\t\tif ( typeof type !== \"string\" ) {\n\t\t\t\tgotoEnd = clearQueue;\n\t\t\t\tclearQueue = type;\n\t\t\t\ttype = undefined;\n\t\t\t}\n\t\t\tif ( clearQueue && type !== false ) {\n\t\t\t\tthis.queue( type || \"fx\", [] );\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tvar dequeue = true,\n\t\t\t\t\tindex = type != null && type + \"queueHooks\",\n\t\t\t\t\ttimers = jQuery.timers,\n\t\t\t\t\tdata = jQuery._data( this );\n\n\t\t\t\tif ( index ) {\n\t\t\t\t\tif ( data[ index ] && data[ index ].stop ) {\n\t\t\t\t\t\tstopQueue( data[ index ] );\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tfor ( index in data ) {\n\t\t\t\t\t\tif ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {\n\t\t\t\t\t\t\tstopQueue( data[ index ] );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor ( index = timers.length; index--; ) {\n\t\t\t\t\tif ( timers[ index ].elem === this &&\n\t\t\t\t\t\t( type == null || timers[ index ].queue === type ) ) {\n\n\t\t\t\t\t\ttimers[ index ].anim.stop( gotoEnd );\n\t\t\t\t\t\tdequeue = false;\n\t\t\t\t\t\ttimers.splice( index, 1 );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// start the next in the queue if the last step wasn't forced\n\t\t\t\t// timers currently will call their complete callbacks, which will dequeue\n\t\t\t\t// but only if they were gotoEnd\n\t\t\t\tif ( dequeue || !gotoEnd ) {\n\t\t\t\t\tjQuery.dequeue( this, type );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\t\tfinish: function( type ) {\n\t\t\tif ( type !== false ) {\n\t\t\t\ttype = type || \"fx\";\n\t\t\t}\n\t\t\treturn this.each( function() {\n\t\t\t\tvar index,\n\t\t\t\t\tdata = jQuery._data( this ),\n\t\t\t\t\tqueue = data[ type + \"queue\" ],\n\t\t\t\t\thooks = data[ type + \"queueHooks\" ],\n\t\t\t\t\ttimers = jQuery.timers,\n\t\t\t\t\tlength = queue ? queue.length : 0;\n\n\t\t\t\t// enable finishing flag on private data\n\t\t\t\tdata.finish = true;\n\n\t\t\t\t// empty the queue first\n\t\t\t\tjQuery.queue( this, type, [] );\n\n\t\t\t\tif ( hooks && hooks.stop ) {\n\t\t\t\t\thooks.stop.call( this, true );\n\t\t\t\t}\n\n\t\t\t\t// look for any active animations, and finish them\n\t\t\t\tfor ( index = timers.length; index--; ) {\n\t\t\t\t\tif ( timers[ index ].elem === this && timers[ index ].queue === type ) {\n\t\t\t\t\t\ttimers[ index ].anim.stop( true );\n\t\t\t\t\t\ttimers.splice( index, 1 );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// look for any animations in the old queue and finish them\n\t\t\t\tfor ( index = 0; index < length; index++ ) {\n\t\t\t\t\tif ( queue[ index ] && queue[ index ].finish ) {\n\t\t\t\t\t\tqueue[ index ].finish.call( this );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// turn off finishing flag\n\t\t\t\tdelete data.finish;\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.each( [ \"toggle\", \"show\", \"hide\" ], function( i, name ) {\n\t\tvar cssFn = jQuery.fn[ name ];\n\t\tjQuery.fn[ name ] = function( speed, easing, callback ) {\n\t\t\treturn speed == null || typeof speed === \"boolean\" ?\n\t\t\t\tcssFn.apply( this, arguments ) :\n\t\t\t\tthis.animate( genFx( name, true ), speed, easing, callback );\n\t\t};\n\t} );\n\n// Generate shortcuts for custom animations\n\tjQuery.each( {\n\t\tslideDown: genFx( \"show\" ),\n\t\tslideUp: genFx( \"hide\" ),\n\t\tslideToggle: genFx( \"toggle\" ),\n\t\tfadeIn: { opacity: \"show\" },\n\t\tfadeOut: { opacity: \"hide\" },\n\t\tfadeToggle: { opacity: \"toggle\" }\n\t}, function( name, props ) {\n\t\tjQuery.fn[ name ] = function( speed, easing, callback ) {\n\t\t\treturn this.animate( props, speed, easing, callback );\n\t\t};\n\t} );\n\n\tjQuery.timers = [];\n\tjQuery.fx.tick = function() {\n\t\tvar timer,\n\t\t\ttimers = jQuery.timers,\n\t\t\ti = 0;\n\n\t\tfxNow = jQuery.now();\n\n\t\tfor ( ; i < timers.length; i++ ) {\n\t\t\ttimer = timers[ i ];\n\n\t\t\t// Checks the timer has not already been removed\n\t\t\tif ( !timer() && timers[ i ] === timer ) {\n\t\t\t\ttimers.splice( i--, 1 );\n\t\t\t}\n\t\t}\n\n\t\tif ( !timers.length ) {\n\t\t\tjQuery.fx.stop();\n\t\t}\n\t\tfxNow = undefined;\n\t};\n\n\tjQuery.fx.timer = function( timer ) {\n\t\tjQuery.timers.push( timer );\n\t\tif ( timer() ) {\n\t\t\tjQuery.fx.start();\n\t\t} else {\n\t\t\tjQuery.timers.pop();\n\t\t}\n\t};\n\n\tjQuery.fx.interval = 13;\n\n\tjQuery.fx.start = function() {\n\t\tif ( !timerId ) {\n\t\t\ttimerId = window.setInterval( jQuery.fx.tick, jQuery.fx.interval );\n\t\t}\n\t};\n\n\tjQuery.fx.stop = function() {\n\t\twindow.clearInterval( timerId );\n\t\ttimerId = null;\n\t};\n\n\tjQuery.fx.speeds = {\n\t\tslow: 600,\n\t\tfast: 200,\n\n\t\t// Default speed\n\t\t_default: 400\n\t};\n\n\n// Based off of the plugin by Clint Helfers, with permission.\n// http://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/\n\tjQuery.fn.delay = function( time, type ) {\n\t\ttime = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;\n\t\ttype = type || \"fx\";\n\n\t\treturn this.queue( type, function( next, hooks ) {\n\t\t\tvar timeout = window.setTimeout( next, time );\n\t\t\thooks.stop = function() {\n\t\t\t\twindow.clearTimeout( timeout );\n\t\t\t};\n\t\t} );\n\t};\n\n\n\t( function() {\n\t\tvar a,\n\t\t\tinput = document.createElement( \"input\" ),\n\t\t\tdiv = document.createElement( \"div\" ),\n\t\t\tselect = document.createElement( \"select\" ),\n\t\t\topt = select.appendChild( document.createElement( \"option\" ) );\n\n\t\t// Setup\n\t\tdiv = document.createElement( \"div\" );\n\t\tdiv.setAttribute( \"className\", \"t\" );\n\t\tdiv.innerHTML = \"  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>\";\n\t\ta = div.getElementsByTagName( \"a\" )[ 0 ];\n\n\t\t// Support: Windows Web Apps (WWA)\n\t\t// `type` must use .setAttribute for WWA (#14901)\n\t\tinput.setAttribute( \"type\", \"checkbox\" );\n\t\tdiv.appendChild( input );\n\n\t\ta = div.getElementsByTagName( \"a\" )[ 0 ];\n\n\t\t// First batch of tests.\n\t\ta.style.cssText = \"top:1px\";\n\n\t\t// Test setAttribute on camelCase class.\n\t\t// If it works, we need attrFixes when doing get/setAttribute (ie6/7)\n\t\tsupport.getSetAttribute = div.className !== \"t\";\n\n\t\t// Get the style information from getAttribute\n\t\t// (IE uses .cssText instead)\n\t\tsupport.style = /top/.test( a.getAttribute( \"style\" ) );\n\n\t\t// Make sure that URLs aren't manipulated\n\t\t// (IE normalizes it by default)\n\t\tsupport.hrefNormalized = a.getAttribute( \"href\" ) === \"/a\";\n\n\t\t// Check the default checkbox/radio value (\"\" on WebKit; \"on\" elsewhere)\n\t\tsupport.checkOn = !!input.value;\n\n\t\t// Make sure that a selected-by-default option has a working selected property.\n\t\t// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)\n\t\tsupport.optSelected = opt.selected;\n\n\t\t// Tests for enctype support on a form (#6743)\n\t\tsupport.enctype = !!document.createElement( \"form\" ).enctype;\n\n\t\t// Make sure that the options inside disabled selects aren't marked as disabled\n\t\t// (WebKit marks them as disabled)\n\t\tselect.disabled = true;\n\t\tsupport.optDisabled = !opt.disabled;\n\n\t\t// Support: IE8 only\n\t\t// Check if we can trust getAttribute(\"value\")\n\t\tinput = document.createElement( \"input\" );\n\t\tinput.setAttribute( \"value\", \"\" );\n\t\tsupport.input = input.getAttribute( \"value\" ) === \"\";\n\n\t\t// Check if an input maintains its value after becoming a radio\n\t\tinput.value = \"t\";\n\t\tinput.setAttribute( \"type\", \"radio\" );\n\t\tsupport.radioValue = input.value === \"t\";\n\t} )();\n\n\n\tvar rreturn = /\\r/g,\n\t\trspaces = /[\\x20\\t\\r\\n\\f]+/g;\n\n\tjQuery.fn.extend( {\n\t\tval: function( value ) {\n\t\t\tvar hooks, ret, isFunction,\n\t\t\t\telem = this[ 0 ];\n\n\t\t\tif ( !arguments.length ) {\n\t\t\t\tif ( elem ) {\n\t\t\t\t\thooks = jQuery.valHooks[ elem.type ] ||\n\t\t\t\t\t\tjQuery.valHooks[ elem.nodeName.toLowerCase() ];\n\n\t\t\t\t\tif (\n\t\t\t\t\t\thooks &&\n\t\t\t\t\t\t\"get\" in hooks &&\n\t\t\t\t\t\t( ret = hooks.get( elem, \"value\" ) ) !== undefined\n\t\t\t\t\t) {\n\t\t\t\t\t\treturn ret;\n\t\t\t\t\t}\n\n\t\t\t\t\tret = elem.value;\n\n\t\t\t\t\treturn typeof ret === \"string\" ?\n\n\t\t\t\t\t\t// handle most common string cases\n\t\t\t\t\t\tret.replace( rreturn, \"\" ) :\n\n\t\t\t\t\t\t// handle cases where value is null/undef or number\n\t\t\t\t\t\tret == null ? \"\" : ret;\n\t\t\t\t}\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tisFunction = jQuery.isFunction( value );\n\n\t\t\treturn this.each( function( i ) {\n\t\t\t\tvar val;\n\n\t\t\t\tif ( this.nodeType !== 1 ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif ( isFunction ) {\n\t\t\t\t\tval = value.call( this, i, jQuery( this ).val() );\n\t\t\t\t} else {\n\t\t\t\t\tval = value;\n\t\t\t\t}\n\n\t\t\t\t// Treat null/undefined as \"\"; convert numbers to string\n\t\t\t\tif ( val == null ) {\n\t\t\t\t\tval = \"\";\n\t\t\t\t} else if ( typeof val === \"number\" ) {\n\t\t\t\t\tval += \"\";\n\t\t\t\t} else if ( jQuery.isArray( val ) ) {\n\t\t\t\t\tval = jQuery.map( val, function( value ) {\n\t\t\t\t\t\treturn value == null ? \"\" : value + \"\";\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\thooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];\n\n\t\t\t\t// If set returns undefined, fall back to normal setting\n\t\t\t\tif ( !hooks || !( \"set\" in hooks ) || hooks.set( this, val, \"value\" ) === undefined ) {\n\t\t\t\t\tthis.value = val;\n\t\t\t\t}\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.extend( {\n\t\tvalHooks: {\n\t\t\toption: {\n\t\t\t\tget: function( elem ) {\n\t\t\t\t\tvar val = jQuery.find.attr( elem, \"value\" );\n\t\t\t\t\treturn val != null ?\n\t\t\t\t\t\tval :\n\n\t\t\t\t\t\t// Support: IE10-11+\n\t\t\t\t\t\t// option.text throws exceptions (#14686, #14858)\n\t\t\t\t\t\t// Strip and collapse whitespace\n\t\t\t\t\t\t// https://html.spec.whatwg.org/#strip-and-collapse-whitespace\n\t\t\t\t\t\tjQuery.trim( jQuery.text( elem ) ).replace( rspaces, \" \" );\n\t\t\t\t}\n\t\t\t},\n\t\t\tselect: {\n\t\t\t\tget: function( elem ) {\n\t\t\t\t\tvar value, option,\n\t\t\t\t\t\toptions = elem.options,\n\t\t\t\t\t\tindex = elem.selectedIndex,\n\t\t\t\t\t\tone = elem.type === \"select-one\" || index < 0,\n\t\t\t\t\t\tvalues = one ? null : [],\n\t\t\t\t\t\tmax = one ? index + 1 : options.length,\n\t\t\t\t\t\ti = index < 0 ?\n\t\t\t\t\t\t\tmax :\n\t\t\t\t\t\t\tone ? index : 0;\n\n\t\t\t\t\t// Loop through all the selected options\n\t\t\t\t\tfor ( ; i < max; i++ ) {\n\t\t\t\t\t\toption = options[ i ];\n\n\t\t\t\t\t\t// oldIE doesn't update selected after form reset (#2551)\n\t\t\t\t\t\tif ( ( option.selected || i === index ) &&\n\n\t\t\t\t\t\t\t// Don't return options that are disabled or in a disabled optgroup\n\t\t\t\t\t\t\t( support.optDisabled ?\n\t\t\t\t\t\t\t\t!option.disabled :\n\t\t\t\t\t\t\toption.getAttribute( \"disabled\" ) === null ) &&\n\t\t\t\t\t\t\t( !option.parentNode.disabled ||\n\t\t\t\t\t\t\t!jQuery.nodeName( option.parentNode, \"optgroup\" ) ) ) {\n\n\t\t\t\t\t\t\t// Get the specific value for the option\n\t\t\t\t\t\t\tvalue = jQuery( option ).val();\n\n\t\t\t\t\t\t\t// We don't need an array for one selects\n\t\t\t\t\t\t\tif ( one ) {\n\t\t\t\t\t\t\t\treturn value;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Multi-Selects return an array\n\t\t\t\t\t\t\tvalues.push( value );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn values;\n\t\t\t\t},\n\n\t\t\t\tset: function( elem, value ) {\n\t\t\t\t\tvar optionSet, option,\n\t\t\t\t\t\toptions = elem.options,\n\t\t\t\t\t\tvalues = jQuery.makeArray( value ),\n\t\t\t\t\t\ti = options.length;\n\n\t\t\t\t\twhile ( i-- ) {\n\t\t\t\t\t\toption = options[ i ];\n\n\t\t\t\t\t\tif ( jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1 ) {\n\n\t\t\t\t\t\t\t// Support: IE6\n\t\t\t\t\t\t\t// When new option element is added to select box we need to\n\t\t\t\t\t\t\t// force reflow of newly added node in order to workaround delay\n\t\t\t\t\t\t\t// of initialization properties\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\toption.selected = optionSet = true;\n\n\t\t\t\t\t\t\t} catch ( _ ) {\n\n\t\t\t\t\t\t\t\t// Will be executed only in IE6\n\t\t\t\t\t\t\t\toption.scrollHeight;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\toption.selected = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Force browsers to behave consistently when non-matching value is set\n\t\t\t\t\tif ( !optionSet ) {\n\t\t\t\t\t\telem.selectedIndex = -1;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn options;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} );\n\n// Radios and checkboxes getter/setter\n\tjQuery.each( [ \"radio\", \"checkbox\" ], function() {\n\t\tjQuery.valHooks[ this ] = {\n\t\t\tset: function( elem, value ) {\n\t\t\t\tif ( jQuery.isArray( value ) ) {\n\t\t\t\t\treturn ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t\tif ( !support.checkOn ) {\n\t\t\tjQuery.valHooks[ this ].get = function( elem ) {\n\t\t\t\treturn elem.getAttribute( \"value\" ) === null ? \"on\" : elem.value;\n\t\t\t};\n\t\t}\n\t} );\n\n\n\n\n\tvar nodeHook, boolHook,\n\t\tattrHandle = jQuery.expr.attrHandle,\n\t\truseDefault = /^(?:checked|selected)$/i,\n\t\tgetSetAttribute = support.getSetAttribute,\n\t\tgetSetInput = support.input;\n\n\tjQuery.fn.extend( {\n\t\tattr: function( name, value ) {\n\t\t\treturn access( this, jQuery.attr, name, value, arguments.length > 1 );\n\t\t},\n\n\t\tremoveAttr: function( name ) {\n\t\t\treturn this.each( function() {\n\t\t\t\tjQuery.removeAttr( this, name );\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.extend( {\n\t\tattr: function( elem, name, value ) {\n\t\t\tvar ret, hooks,\n\t\t\t\tnType = elem.nodeType;\n\n\t\t\t// Don't get/set attributes on text, comment and attribute nodes\n\t\t\tif ( nType === 3 || nType === 8 || nType === 2 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Fallback to prop when attributes are not supported\n\t\t\tif ( typeof elem.getAttribute === \"undefined\" ) {\n\t\t\t\treturn jQuery.prop( elem, name, value );\n\t\t\t}\n\n\t\t\t// All attributes are lowercase\n\t\t\t// Grab necessary hook if one is defined\n\t\t\tif ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {\n\t\t\t\tname = name.toLowerCase();\n\t\t\t\thooks = jQuery.attrHooks[ name ] ||\n\t\t\t\t\t( jQuery.expr.match.bool.test( name ) ? boolHook : nodeHook );\n\t\t\t}\n\n\t\t\tif ( value !== undefined ) {\n\t\t\t\tif ( value === null ) {\n\t\t\t\t\tjQuery.removeAttr( elem, name );\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif ( hooks && \"set\" in hooks &&\n\t\t\t\t\t( ret = hooks.set( elem, value, name ) ) !== undefined ) {\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\n\t\t\t\telem.setAttribute( name, value + \"\" );\n\t\t\t\treturn value;\n\t\t\t}\n\n\t\t\tif ( hooks && \"get\" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {\n\t\t\t\treturn ret;\n\t\t\t}\n\n\t\t\tret = jQuery.find.attr( elem, name );\n\n\t\t\t// Non-existent attributes return null, we normalize to undefined\n\t\t\treturn ret == null ? undefined : ret;\n\t\t},\n\n\t\tattrHooks: {\n\t\t\ttype: {\n\t\t\t\tset: function( elem, value ) {\n\t\t\t\t\tif ( !support.radioValue && value === \"radio\" &&\n\t\t\t\t\t\tjQuery.nodeName( elem, \"input\" ) ) {\n\n\t\t\t\t\t\t// Setting the type on a radio button after the value resets the value in IE8-9\n\t\t\t\t\t\t// Reset value to default in case type is set after value during creation\n\t\t\t\t\t\tvar val = elem.value;\n\t\t\t\t\t\telem.setAttribute( \"type\", value );\n\t\t\t\t\t\tif ( val ) {\n\t\t\t\t\t\t\telem.value = val;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn value;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tremoveAttr: function( elem, value ) {\n\t\t\tvar name, propName,\n\t\t\t\ti = 0,\n\t\t\t\tattrNames = value && value.match( rnotwhite );\n\n\t\t\tif ( attrNames && elem.nodeType === 1 ) {\n\t\t\t\twhile ( ( name = attrNames[ i++ ] ) ) {\n\t\t\t\t\tpropName = jQuery.propFix[ name ] || name;\n\n\t\t\t\t\t// Boolean attributes get special treatment (#10870)\n\t\t\t\t\tif ( jQuery.expr.match.bool.test( name ) ) {\n\n\t\t\t\t\t\t// Set corresponding property to false\n\t\t\t\t\t\tif ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {\n\t\t\t\t\t\t\telem[ propName ] = false;\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// Also clear defaultChecked/defaultSelected (if appropriate)\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\telem[ jQuery.camelCase( \"default-\" + name ) ] =\n\t\t\t\t\t\t\t\telem[ propName ] = false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// See #9699 for explanation of this approach (setting first, then removal)\n\t\t\t\t\t} else {\n\t\t\t\t\t\tjQuery.attr( elem, name, \"\" );\n\t\t\t\t\t}\n\n\t\t\t\t\telem.removeAttribute( getSetAttribute ? name : propName );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} );\n\n// Hooks for boolean attributes\n\tboolHook = {\n\t\tset: function( elem, value, name ) {\n\t\t\tif ( value === false ) {\n\n\t\t\t\t// Remove boolean attributes when set to false\n\t\t\t\tjQuery.removeAttr( elem, name );\n\t\t\t} else if ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {\n\n\t\t\t\t// IE<8 needs the *property* name\n\t\t\t\telem.setAttribute( !getSetAttribute && jQuery.propFix[ name ] || name, name );\n\n\t\t\t} else {\n\n\t\t\t\t// Support: IE<9\n\t\t\t\t// Use defaultChecked and defaultSelected for oldIE\n\t\t\t\telem[ jQuery.camelCase( \"default-\" + name ) ] = elem[ name ] = true;\n\t\t\t}\n\t\t\treturn name;\n\t\t}\n\t};\n\n\tjQuery.each( jQuery.expr.match.bool.source.match( /\\w+/g ), function( i, name ) {\n\t\tvar getter = attrHandle[ name ] || jQuery.find.attr;\n\n\t\tif ( getSetInput && getSetAttribute || !ruseDefault.test( name ) ) {\n\t\t\tattrHandle[ name ] = function( elem, name, isXML ) {\n\t\t\t\tvar ret, handle;\n\t\t\t\tif ( !isXML ) {\n\n\t\t\t\t\t// Avoid an infinite loop by temporarily removing this function from the getter\n\t\t\t\t\thandle = attrHandle[ name ];\n\t\t\t\t\tattrHandle[ name ] = ret;\n\t\t\t\t\tret = getter( elem, name, isXML ) != null ?\n\t\t\t\t\t\tname.toLowerCase() :\n\t\t\t\t\t\tnull;\n\t\t\t\t\tattrHandle[ name ] = handle;\n\t\t\t\t}\n\t\t\t\treturn ret;\n\t\t\t};\n\t\t} else {\n\t\t\tattrHandle[ name ] = function( elem, name, isXML ) {\n\t\t\t\tif ( !isXML ) {\n\t\t\t\t\treturn elem[ jQuery.camelCase( \"default-\" + name ) ] ?\n\t\t\t\t\t\tname.toLowerCase() :\n\t\t\t\t\t\tnull;\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t} );\n\n// fix oldIE attroperties\n\tif ( !getSetInput || !getSetAttribute ) {\n\t\tjQuery.attrHooks.value = {\n\t\t\tset: function( elem, value, name ) {\n\t\t\t\tif ( jQuery.nodeName( elem, \"input\" ) ) {\n\n\t\t\t\t\t// Does not return so that setAttribute is also used\n\t\t\t\t\telem.defaultValue = value;\n\t\t\t\t} else {\n\n\t\t\t\t\t// Use nodeHook if defined (#1954); otherwise setAttribute is fine\n\t\t\t\t\treturn nodeHook && nodeHook.set( elem, value, name );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n// IE6/7 do not support getting/setting some attributes with get/setAttribute\n\tif ( !getSetAttribute ) {\n\n\t\t// Use this for any attribute in IE6/7\n\t\t// This fixes almost every IE6/7 issue\n\t\tnodeHook = {\n\t\t\tset: function( elem, value, name ) {\n\n\t\t\t\t// Set the existing or create a new attribute node\n\t\t\t\tvar ret = elem.getAttributeNode( name );\n\t\t\t\tif ( !ret ) {\n\t\t\t\t\telem.setAttributeNode(\n\t\t\t\t\t\t( ret = elem.ownerDocument.createAttribute( name ) )\n\t\t\t\t\t);\n\t\t\t\t}\n\n\t\t\t\tret.value = value += \"\";\n\n\t\t\t\t// Break association with cloned elements by also using setAttribute (#9646)\n\t\t\t\tif ( name === \"value\" || value === elem.getAttribute( name ) ) {\n\t\t\t\t\treturn value;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t// Some attributes are constructed with empty-string values when not defined\n\t\tattrHandle.id = attrHandle.name = attrHandle.coords =\n\t\t\tfunction( elem, name, isXML ) {\n\t\t\t\tvar ret;\n\t\t\t\tif ( !isXML ) {\n\t\t\t\t\treturn ( ret = elem.getAttributeNode( name ) ) && ret.value !== \"\" ?\n\t\t\t\t\t\tret.value :\n\t\t\t\t\t\tnull;\n\t\t\t\t}\n\t\t\t};\n\n\t\t// Fixing value retrieval on a button requires this module\n\t\tjQuery.valHooks.button = {\n\t\t\tget: function( elem, name ) {\n\t\t\t\tvar ret = elem.getAttributeNode( name );\n\t\t\t\tif ( ret && ret.specified ) {\n\t\t\t\t\treturn ret.value;\n\t\t\t\t}\n\t\t\t},\n\t\t\tset: nodeHook.set\n\t\t};\n\n\t\t// Set contenteditable to false on removals(#10429)\n\t\t// Setting to empty string throws an error as an invalid value\n\t\tjQuery.attrHooks.contenteditable = {\n\t\t\tset: function( elem, value, name ) {\n\t\t\t\tnodeHook.set( elem, value === \"\" ? false : value, name );\n\t\t\t}\n\t\t};\n\n\t\t// Set width and height to auto instead of 0 on empty string( Bug #8150 )\n\t\t// This is for removals\n\t\tjQuery.each( [ \"width\", \"height\" ], function( i, name ) {\n\t\t\tjQuery.attrHooks[ name ] = {\n\t\t\t\tset: function( elem, value ) {\n\t\t\t\t\tif ( value === \"\" ) {\n\t\t\t\t\t\telem.setAttribute( name, \"auto\" );\n\t\t\t\t\t\treturn value;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t} );\n\t}\n\n\tif ( !support.style ) {\n\t\tjQuery.attrHooks.style = {\n\t\t\tget: function( elem ) {\n\n\t\t\t\t// Return undefined in the case of empty string\n\t\t\t\t// Note: IE uppercases css property names, but if we were to .toLowerCase()\n\t\t\t\t// .cssText, that would destroy case sensitivity in URL's, like in \"background\"\n\t\t\t\treturn elem.style.cssText || undefined;\n\t\t\t},\n\t\t\tset: function( elem, value ) {\n\t\t\t\treturn ( elem.style.cssText = value + \"\" );\n\t\t\t}\n\t\t};\n\t}\n\n\n\n\n\tvar rfocusable = /^(?:input|select|textarea|button|object)$/i,\n\t\trclickable = /^(?:a|area)$/i;\n\n\tjQuery.fn.extend( {\n\t\tprop: function( name, value ) {\n\t\t\treturn access( this, jQuery.prop, name, value, arguments.length > 1 );\n\t\t},\n\n\t\tremoveProp: function( name ) {\n\t\t\tname = jQuery.propFix[ name ] || name;\n\t\t\treturn this.each( function() {\n\n\t\t\t\t// try/catch handles cases where IE balks (such as removing a property on window)\n\t\t\t\ttry {\n\t\t\t\t\tthis[ name ] = undefined;\n\t\t\t\t\tdelete this[ name ];\n\t\t\t\t} catch ( e ) {}\n\t\t\t} );\n\t\t}\n\t} );\n\n\tjQuery.extend( {\n\t\tprop: function( elem, name, value ) {\n\t\t\tvar ret, hooks,\n\t\t\t\tnType = elem.nodeType;\n\n\t\t\t// Don't get/set properties on text, comment and attribute nodes\n\t\t\tif ( nType === 3 || nType === 8 || nType === 2 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {\n\n\t\t\t\t// Fix name and attach hooks\n\t\t\t\tname = jQuery.propFix[ name ] || name;\n\t\t\t\thooks = jQuery.propHooks[ name ];\n\t\t\t}\n\n\t\t\tif ( value !== undefined ) {\n\t\t\t\tif ( hooks && \"set\" in hooks &&\n\t\t\t\t\t( ret = hooks.set( elem, value, name ) ) !== undefined ) {\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\n\t\t\t\treturn ( elem[ name ] = value );\n\t\t\t}\n\n\t\t\tif ( hooks && \"get\" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {\n\t\t\t\treturn ret;\n\t\t\t}\n\n\t\t\treturn elem[ name ];\n\t\t},\n\n\t\tpropHooks: {\n\t\t\ttabIndex: {\n\t\t\t\tget: function( elem ) {\n\n\t\t\t\t\t// elem.tabIndex doesn't always return the\n\t\t\t\t\t// correct value when it hasn't been explicitly set\n\t\t\t\t\t// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/\n\t\t\t\t\t// Use proper attribute retrieval(#12072)\n\t\t\t\t\tvar tabindex = jQuery.find.attr( elem, \"tabindex\" );\n\n\t\t\t\t\treturn tabindex ?\n\t\t\t\t\t\tparseInt( tabindex, 10 ) :\n\t\t\t\t\t\trfocusable.test( elem.nodeName ) ||\n\t\t\t\t\t\trclickable.test( elem.nodeName ) && elem.href ?\n\t\t\t\t\t\t\t0 :\n\t\t\t\t\t\t\t-1;\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tpropFix: {\n\t\t\t\"for\": \"htmlFor\",\n\t\t\t\"class\": \"className\"\n\t\t}\n\t} );\n\n// Some attributes require a special call on IE\n// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx\n\tif ( !support.hrefNormalized ) {\n\n\t\t// href/src property should get the full normalized URL (#10299/#12915)\n\t\tjQuery.each( [ \"href\", \"src\" ], function( i, name ) {\n\t\t\tjQuery.propHooks[ name ] = {\n\t\t\t\tget: function( elem ) {\n\t\t\t\t\treturn elem.getAttribute( name, 4 );\n\t\t\t\t}\n\t\t\t};\n\t\t} );\n\t}\n\n// Support: Safari, IE9+\n// Accessing the selectedIndex property\n// forces the browser to respect setting selected\n// on the option\n// The getter ensures a default option is selected\n// when in an optgroup\n\tif ( !support.optSelected ) {\n\t\tjQuery.propHooks.selected = {\n\t\t\tget: function( elem ) {\n\t\t\t\tvar parent = elem.parentNode;\n\n\t\t\t\tif ( parent ) {\n\t\t\t\t\tparent.selectedIndex;\n\n\t\t\t\t\t// Make sure that it also works with optgroups, see #5701\n\t\t\t\t\tif ( parent.parentNode ) {\n\t\t\t\t\t\tparent.parentNode.selectedIndex;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn null;\n\t\t\t},\n\t\t\tset: function( elem ) {\n\t\t\t\tvar parent = elem.parentNode;\n\t\t\t\tif ( parent ) {\n\t\t\t\t\tparent.selectedIndex;\n\n\t\t\t\t\tif ( parent.parentNode ) {\n\t\t\t\t\t\tparent.parentNode.selectedIndex;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n\tjQuery.each( [\n\t\t\"tabIndex\",\n\t\t\"readOnly\",\n\t\t\"maxLength\",\n\t\t\"cellSpacing\",\n\t\t\"cellPadding\",\n\t\t\"rowSpan\",\n\t\t\"colSpan\",\n\t\t\"useMap\",\n\t\t\"frameBorder\",\n\t\t\"contentEditable\"\n\t], function() {\n\t\tjQuery.propFix[ this.toLowerCase() ] = this;\n\t} );\n\n// IE6/7 call enctype encoding\n\tif ( !support.enctype ) {\n\t\tjQuery.propFix.enctype = \"encoding\";\n\t}\n\n\n\n\n\tvar rclass = /[\\t\\r\\n\\f]/g;\n\n\tfunction getClass( elem ) {\n\t\treturn jQuery.attr( elem, \"class\" ) || \"\";\n\t}\n\n\tjQuery.fn.extend( {\n\t\taddClass: function( value ) {\n\t\t\tvar classes, elem, cur, curValue, clazz, j, finalValue,\n\t\t\t\ti = 0;\n\n\t\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\t\treturn this.each( function( j ) {\n\t\t\t\t\tjQuery( this ).addClass( value.call( this, j, getClass( this ) ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( typeof value === \"string\" && value ) {\n\t\t\t\tclasses = value.match( rnotwhite ) || [];\n\n\t\t\t\twhile ( ( elem = this[ i++ ] ) ) {\n\t\t\t\t\tcurValue = getClass( elem );\n\t\t\t\t\tcur = elem.nodeType === 1 &&\n\t\t\t\t\t\t( \" \" + curValue + \" \" ).replace( rclass, \" \" );\n\n\t\t\t\t\tif ( cur ) {\n\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\twhile ( ( clazz = classes[ j++ ] ) ) {\n\t\t\t\t\t\t\tif ( cur.indexOf( \" \" + clazz + \" \" ) < 0 ) {\n\t\t\t\t\t\t\t\tcur += clazz + \" \";\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// only assign if different to avoid unneeded rendering.\n\t\t\t\t\t\tfinalValue = jQuery.trim( cur );\n\t\t\t\t\t\tif ( curValue !== finalValue ) {\n\t\t\t\t\t\t\tjQuery.attr( elem, \"class\", finalValue );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\tremoveClass: function( value ) {\n\t\t\tvar classes, elem, cur, curValue, clazz, j, finalValue,\n\t\t\t\ti = 0;\n\n\t\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\t\treturn this.each( function( j ) {\n\t\t\t\t\tjQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( !arguments.length ) {\n\t\t\t\treturn this.attr( \"class\", \"\" );\n\t\t\t}\n\n\t\t\tif ( typeof value === \"string\" && value ) {\n\t\t\t\tclasses = value.match( rnotwhite ) || [];\n\n\t\t\t\twhile ( ( elem = this[ i++ ] ) ) {\n\t\t\t\t\tcurValue = getClass( elem );\n\n\t\t\t\t\t// This expression is here for better compressibility (see addClass)\n\t\t\t\t\tcur = elem.nodeType === 1 &&\n\t\t\t\t\t\t( \" \" + curValue + \" \" ).replace( rclass, \" \" );\n\n\t\t\t\t\tif ( cur ) {\n\t\t\t\t\t\tj = 0;\n\t\t\t\t\t\twhile ( ( clazz = classes[ j++ ] ) ) {\n\n\t\t\t\t\t\t\t// Remove *all* instances\n\t\t\t\t\t\t\twhile ( cur.indexOf( \" \" + clazz + \" \" ) > -1 ) {\n\t\t\t\t\t\t\t\tcur = cur.replace( \" \" + clazz + \" \", \" \" );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Only assign if different to avoid unneeded rendering.\n\t\t\t\t\t\tfinalValue = jQuery.trim( cur );\n\t\t\t\t\t\tif ( curValue !== finalValue ) {\n\t\t\t\t\t\t\tjQuery.attr( elem, \"class\", finalValue );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\ttoggleClass: function( value, stateVal ) {\n\t\t\tvar type = typeof value;\n\n\t\t\tif ( typeof stateVal === \"boolean\" && type === \"string\" ) {\n\t\t\t\treturn stateVal ? this.addClass( value ) : this.removeClass( value );\n\t\t\t}\n\n\t\t\tif ( jQuery.isFunction( value ) ) {\n\t\t\t\treturn this.each( function( i ) {\n\t\t\t\t\tjQuery( this ).toggleClass(\n\t\t\t\t\t\tvalue.call( this, i, getClass( this ), stateVal ),\n\t\t\t\t\t\tstateVal\n\t\t\t\t\t);\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tvar className, i, self, classNames;\n\n\t\t\t\tif ( type === \"string\" ) {\n\n\t\t\t\t\t// Toggle individual class names\n\t\t\t\t\ti = 0;\n\t\t\t\t\tself = jQuery( this );\n\t\t\t\t\tclassNames = value.match( rnotwhite ) || [];\n\n\t\t\t\t\twhile ( ( className = classNames[ i++ ] ) ) {\n\n\t\t\t\t\t\t// Check each className given, space separated list\n\t\t\t\t\t\tif ( self.hasClass( className ) ) {\n\t\t\t\t\t\t\tself.removeClass( className );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tself.addClass( className );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Toggle whole class name\n\t\t\t\t} else if ( value === undefined || type === \"boolean\" ) {\n\t\t\t\t\tclassName = getClass( this );\n\t\t\t\t\tif ( className ) {\n\n\t\t\t\t\t\t// store className if set\n\t\t\t\t\t\tjQuery._data( this, \"__className__\", className );\n\t\t\t\t\t}\n\n\t\t\t\t\t// If the element has a class name or if we're passed \"false\",\n\t\t\t\t\t// then remove the whole classname (if there was one, the above saved it).\n\t\t\t\t\t// Otherwise bring back whatever was previously saved (if anything),\n\t\t\t\t\t// falling back to the empty string if nothing was stored.\n\t\t\t\t\tjQuery.attr( this, \"class\",\n\t\t\t\t\t\tclassName || value === false ?\n\t\t\t\t\t\t\t\"\" :\n\t\t\t\t\t\tjQuery._data( this, \"__className__\" ) || \"\"\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\thasClass: function( selector ) {\n\t\t\tvar className, elem,\n\t\t\t\ti = 0;\n\n\t\t\tclassName = \" \" + selector + \" \";\n\t\t\twhile ( ( elem = this[ i++ ] ) ) {\n\t\t\t\tif ( elem.nodeType === 1 &&\n\t\t\t\t\t( \" \" + getClass( elem ) + \" \" ).replace( rclass, \" \" )\n\t\t\t\t\t\t.indexOf( className ) > -1\n\t\t\t\t) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn false;\n\t\t}\n\t} );\n\n\n\n\n// Return jQuery for attributes-only inclusion\n\n\n\tjQuery.each( ( \"blur focus focusin focusout load resize scroll unload click dblclick \" +\n\t\t\"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave \" +\n\t\t\"change select submit keydown keypress keyup error contextmenu\" ).split( \" \" ),\n\t\tfunction( i, name ) {\n\n\t\t\t// Handle event binding\n\t\t\tjQuery.fn[ name ] = function( data, fn ) {\n\t\t\t\treturn arguments.length > 0 ?\n\t\t\t\t\tthis.on( name, null, data, fn ) :\n\t\t\t\t\tthis.trigger( name );\n\t\t\t};\n\t\t} );\n\n\tjQuery.fn.extend( {\n\t\thover: function( fnOver, fnOut ) {\n\t\t\treturn this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );\n\t\t}\n\t} );\n\n\n\tvar location = window.location;\n\n\tvar nonce = jQuery.now();\n\n\tvar rquery = ( /\\?/ );\n\n\n\n\tvar rvalidtokens = /(,)|(\\[|{)|(}|])|\"(?:[^\"\\\\\\r\\n]|\\\\[\"\\\\\\/bfnrt]|\\\\u[\\da-fA-F]{4})*\"\\s*:?|true|false|null|-?(?!0\\d)\\d+(?:\\.\\d+|)(?:[eE][+-]?\\d+|)/g;\n\n\tjQuery.parseJSON = function( data ) {\n\n\t\t// Attempt to parse using the native JSON parser first\n\t\tif ( window.JSON && window.JSON.parse ) {\n\n\t\t\t// Support: Android 2.3\n\t\t\t// Workaround failure to string-cast null input\n\t\t\treturn window.JSON.parse( data + \"\" );\n\t\t}\n\n\t\tvar requireNonComma,\n\t\t\tdepth = null,\n\t\t\tstr = jQuery.trim( data + \"\" );\n\n\t\t// Guard against invalid (and possibly dangerous) input by ensuring that nothing remains\n\t\t// after removing valid tokens\n\t\treturn str && !jQuery.trim( str.replace( rvalidtokens, function( token, comma, open, close ) {\n\n\t\t\t// Force termination if we see a misplaced comma\n\t\t\tif ( requireNonComma && comma ) {\n\t\t\t\tdepth = 0;\n\t\t\t}\n\n\t\t\t// Perform no more replacements after returning to outermost depth\n\t\t\tif ( depth === 0 ) {\n\t\t\t\treturn token;\n\t\t\t}\n\n\t\t\t// Commas must not follow \"[\", \"{\", or \",\"\n\t\t\trequireNonComma = open || comma;\n\n\t\t\t// Determine new depth\n\t\t\t// array/object open (\"[\" or \"{\"): depth += true - false (increment)\n\t\t\t// array/object close (\"]\" or \"}\"): depth += false - true (decrement)\n\t\t\t// other cases (\",\" or primitive): depth += true - true (numeric cast)\n\t\t\tdepth += !close - !open;\n\n\t\t\t// Remove this token\n\t\t\treturn \"\";\n\t\t} ) ) ?\n\t\t\t( Function( \"return \" + str ) )() :\n\t\t\tjQuery.error( \"Invalid JSON: \" + data );\n\t};\n\n\n// Cross-browser xml parsing\n\tjQuery.parseXML = function( data ) {\n\t\tvar xml, tmp;\n\t\tif ( !data || typeof data !== \"string\" ) {\n\t\t\treturn null;\n\t\t}\n\t\ttry {\n\t\t\tif ( window.DOMParser ) { // Standard\n\t\t\t\ttmp = new window.DOMParser();\n\t\t\t\txml = tmp.parseFromString( data, \"text/xml\" );\n\t\t\t} else { // IE\n\t\t\t\txml = new window.ActiveXObject( \"Microsoft.XMLDOM\" );\n\t\t\t\txml.async = \"false\";\n\t\t\t\txml.loadXML( data );\n\t\t\t}\n\t\t} catch ( e ) {\n\t\t\txml = undefined;\n\t\t}\n\t\tif ( !xml || !xml.documentElement || xml.getElementsByTagName( \"parsererror\" ).length ) {\n\t\t\tjQuery.error( \"Invalid XML: \" + data );\n\t\t}\n\t\treturn xml;\n\t};\n\n\n\tvar\n\t\trhash = /#.*$/,\n\t\trts = /([?&])_=[^&]*/,\n\n\t\t// IE leaves an \\r character at EOL\n\t\trheaders = /^(.*?):[ \\t]*([^\\r\\n]*)\\r?$/mg,\n\n\t\t// #7653, #8125, #8152: local protocol detection\n\t\trlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,\n\t\trnoContent = /^(?:GET|HEAD)$/,\n\t\trprotocol = /^\\/\\//,\n\t\trurl = /^([\\w.+-]+:)(?:\\/\\/(?:[^\\/?#]*@|)([^\\/?#:]*)(?::(\\d+)|)|)/,\n\n\t\t/* Prefilters\n\t\t * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)\n\t\t * 2) These are called:\n\t\t *    - BEFORE asking for a transport\n\t\t *    - AFTER param serialization (s.data is a string if s.processData is true)\n\t\t * 3) key is the dataType\n\t\t * 4) the catchall symbol \"*\" can be used\n\t\t * 5) execution will start with transport dataType and THEN continue down to \"*\" if needed\n\t\t */\n\t\tprefilters = {},\n\n\t\t/* Transports bindings\n\t\t * 1) key is the dataType\n\t\t * 2) the catchall symbol \"*\" can be used\n\t\t * 3) selection will start with transport dataType and THEN go to \"*\" if needed\n\t\t */\n\t\ttransports = {},\n\n\t\t// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression\n\t\tallTypes = \"*/\".concat( \"*\" ),\n\n\t\t// Document location\n\t\tajaxLocation = location.href,\n\n\t\t// Segment location into parts\n\t\tajaxLocParts = rurl.exec( ajaxLocation.toLowerCase() ) || [];\n\n// Base \"constructor\" for jQuery.ajaxPrefilter and jQuery.ajaxTransport\n\tfunction addToPrefiltersOrTransports( structure ) {\n\n\t\t// dataTypeExpression is optional and defaults to \"*\"\n\t\treturn function( dataTypeExpression, func ) {\n\n\t\t\tif ( typeof dataTypeExpression !== \"string\" ) {\n\t\t\t\tfunc = dataTypeExpression;\n\t\t\t\tdataTypeExpression = \"*\";\n\t\t\t}\n\n\t\t\tvar dataType,\n\t\t\t\ti = 0,\n\t\t\t\tdataTypes = dataTypeExpression.toLowerCase().match( rnotwhite ) || [];\n\n\t\t\tif ( jQuery.isFunction( func ) ) {\n\n\t\t\t\t// For each dataType in the dataTypeExpression\n\t\t\t\twhile ( ( dataType = dataTypes[ i++ ] ) ) {\n\n\t\t\t\t\t// Prepend if requested\n\t\t\t\t\tif ( dataType.charAt( 0 ) === \"+\" ) {\n\t\t\t\t\t\tdataType = dataType.slice( 1 ) || \"*\";\n\t\t\t\t\t\t( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );\n\n\t\t\t\t\t\t// Otherwise append\n\t\t\t\t\t} else {\n\t\t\t\t\t\t( structure[ dataType ] = structure[ dataType ] || [] ).push( func );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n// Base inspection function for prefilters and transports\n\tfunction inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {\n\n\t\tvar inspected = {},\n\t\t\tseekingTransport = ( structure === transports );\n\n\t\tfunction inspect( dataType ) {\n\t\t\tvar selected;\n\t\t\tinspected[ dataType ] = true;\n\t\t\tjQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {\n\t\t\t\tvar dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );\n\t\t\t\tif ( typeof dataTypeOrTransport === \"string\" &&\n\t\t\t\t\t!seekingTransport && !inspected[ dataTypeOrTransport ] ) {\n\n\t\t\t\t\toptions.dataTypes.unshift( dataTypeOrTransport );\n\t\t\t\t\tinspect( dataTypeOrTransport );\n\t\t\t\t\treturn false;\n\t\t\t\t} else if ( seekingTransport ) {\n\t\t\t\t\treturn !( selected = dataTypeOrTransport );\n\t\t\t\t}\n\t\t\t} );\n\t\t\treturn selected;\n\t\t}\n\n\t\treturn inspect( options.dataTypes[ 0 ] ) || !inspected[ \"*\" ] && inspect( \"*\" );\n\t}\n\n// A special extend for ajax options\n// that takes \"flat\" options (not to be deep extended)\n// Fixes #9887\n\tfunction ajaxExtend( target, src ) {\n\t\tvar deep, key,\n\t\t\tflatOptions = jQuery.ajaxSettings.flatOptions || {};\n\n\t\tfor ( key in src ) {\n\t\t\tif ( src[ key ] !== undefined ) {\n\t\t\t\t( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];\n\t\t\t}\n\t\t}\n\t\tif ( deep ) {\n\t\t\tjQuery.extend( true, target, deep );\n\t\t}\n\n\t\treturn target;\n\t}\n\n\t/* Handles responses to an ajax request:\n\t * - finds the right dataType (mediates between content-type and expected dataType)\n\t * - returns the corresponding response\n\t */\n\tfunction ajaxHandleResponses( s, jqXHR, responses ) {\n\t\tvar firstDataType, ct, finalDataType, type,\n\t\t\tcontents = s.contents,\n\t\t\tdataTypes = s.dataTypes;\n\n\t\t// Remove auto dataType and get content-type in the process\n\t\twhile ( dataTypes[ 0 ] === \"*\" ) {\n\t\t\tdataTypes.shift();\n\t\t\tif ( ct === undefined ) {\n\t\t\t\tct = s.mimeType || jqXHR.getResponseHeader( \"Content-Type\" );\n\t\t\t}\n\t\t}\n\n\t\t// Check if we're dealing with a known content-type\n\t\tif ( ct ) {\n\t\t\tfor ( type in contents ) {\n\t\t\t\tif ( contents[ type ] && contents[ type ].test( ct ) ) {\n\t\t\t\t\tdataTypes.unshift( type );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Check to see if we have a response for the expected dataType\n\t\tif ( dataTypes[ 0 ] in responses ) {\n\t\t\tfinalDataType = dataTypes[ 0 ];\n\t\t} else {\n\n\t\t\t// Try convertible dataTypes\n\t\t\tfor ( type in responses ) {\n\t\t\t\tif ( !dataTypes[ 0 ] || s.converters[ type + \" \" + dataTypes[ 0 ] ] ) {\n\t\t\t\t\tfinalDataType = type;\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tif ( !firstDataType ) {\n\t\t\t\t\tfirstDataType = type;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Or just use first one\n\t\t\tfinalDataType = finalDataType || firstDataType;\n\t\t}\n\n\t\t// If we found a dataType\n\t\t// We add the dataType to the list if needed\n\t\t// and return the corresponding response\n\t\tif ( finalDataType ) {\n\t\t\tif ( finalDataType !== dataTypes[ 0 ] ) {\n\t\t\t\tdataTypes.unshift( finalDataType );\n\t\t\t}\n\t\t\treturn responses[ finalDataType ];\n\t\t}\n\t}\n\n\t/* Chain conversions given the request and the original response\n\t * Also sets the responseXXX fields on the jqXHR instance\n\t */\n\tfunction ajaxConvert( s, response, jqXHR, isSuccess ) {\n\t\tvar conv2, current, conv, tmp, prev,\n\t\t\tconverters = {},\n\n\t\t\t// Work with a copy of dataTypes in case we need to modify it for conversion\n\t\t\tdataTypes = s.dataTypes.slice();\n\n\t\t// Create converters map with lowercased keys\n\t\tif ( dataTypes[ 1 ] ) {\n\t\t\tfor ( conv in s.converters ) {\n\t\t\t\tconverters[ conv.toLowerCase() ] = s.converters[ conv ];\n\t\t\t}\n\t\t}\n\n\t\tcurrent = dataTypes.shift();\n\n\t\t// Convert to each sequential dataType\n\t\twhile ( current ) {\n\n\t\t\tif ( s.responseFields[ current ] ) {\n\t\t\t\tjqXHR[ s.responseFields[ current ] ] = response;\n\t\t\t}\n\n\t\t\t// Apply the dataFilter if provided\n\t\t\tif ( !prev && isSuccess && s.dataFilter ) {\n\t\t\t\tresponse = s.dataFilter( response, s.dataType );\n\t\t\t}\n\n\t\t\tprev = current;\n\t\t\tcurrent = dataTypes.shift();\n\n\t\t\tif ( current ) {\n\n\t\t\t\t// There's only work to do if current dataType is non-auto\n\t\t\t\tif ( current === \"*\" ) {\n\n\t\t\t\t\tcurrent = prev;\n\n\t\t\t\t\t// Convert response if prev dataType is non-auto and differs from current\n\t\t\t\t} else if ( prev !== \"*\" && prev !== current ) {\n\n\t\t\t\t\t// Seek a direct converter\n\t\t\t\t\tconv = converters[ prev + \" \" + current ] || converters[ \"* \" + current ];\n\n\t\t\t\t\t// If none found, seek a pair\n\t\t\t\t\tif ( !conv ) {\n\t\t\t\t\t\tfor ( conv2 in converters ) {\n\n\t\t\t\t\t\t\t// If conv2 outputs current\n\t\t\t\t\t\t\ttmp = conv2.split( \" \" );\n\t\t\t\t\t\t\tif ( tmp[ 1 ] === current ) {\n\n\t\t\t\t\t\t\t\t// If prev can be converted to accepted input\n\t\t\t\t\t\t\t\tconv = converters[ prev + \" \" + tmp[ 0 ] ] ||\n\t\t\t\t\t\t\t\t\tconverters[ \"* \" + tmp[ 0 ] ];\n\t\t\t\t\t\t\t\tif ( conv ) {\n\n\t\t\t\t\t\t\t\t\t// Condense equivalence converters\n\t\t\t\t\t\t\t\t\tif ( conv === true ) {\n\t\t\t\t\t\t\t\t\t\tconv = converters[ conv2 ];\n\n\t\t\t\t\t\t\t\t\t\t// Otherwise, insert the intermediate dataType\n\t\t\t\t\t\t\t\t\t} else if ( converters[ conv2 ] !== true ) {\n\t\t\t\t\t\t\t\t\t\tcurrent = tmp[ 0 ];\n\t\t\t\t\t\t\t\t\t\tdataTypes.unshift( tmp[ 1 ] );\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Apply converter (if not an equivalence)\n\t\t\t\t\tif ( conv !== true ) {\n\n\t\t\t\t\t\t// Unless errors are allowed to bubble, catch and return them\n\t\t\t\t\t\tif ( conv && s[ \"throws\" ] ) { // jscs:ignore requireDotNotation\n\t\t\t\t\t\t\tresponse = conv( response );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tresponse = conv( response );\n\t\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\t\t\tstate: \"parsererror\",\n\t\t\t\t\t\t\t\t\terror: conv ? e : \"No conversion from \" + prev + \" to \" + current\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn { state: \"success\", data: response };\n\t}\n\n\tjQuery.extend( {\n\n\t\t// Counter for holding the number of active queries\n\t\tactive: 0,\n\n\t\t// Last-Modified header cache for next request\n\t\tlastModified: {},\n\t\tetag: {},\n\n\t\tajaxSettings: {\n\t\t\turl: ajaxLocation,\n\t\t\ttype: \"GET\",\n\t\t\tisLocal: rlocalProtocol.test( ajaxLocParts[ 1 ] ),\n\t\t\tglobal: true,\n\t\t\tprocessData: true,\n\t\t\tasync: true,\n\t\t\tcontentType: \"application/x-www-form-urlencoded; charset=UTF-8\",\n\t\t\t/*\n\t\t\t timeout: 0,\n\t\t\t data: null,\n\t\t\t dataType: null,\n\t\t\t username: null,\n\t\t\t password: null,\n\t\t\t cache: null,\n\t\t\t throws: false,\n\t\t\t traditional: false,\n\t\t\t headers: {},\n\t\t\t */\n\n\t\t\taccepts: {\n\t\t\t\t\"*\": allTypes,\n\t\t\t\ttext: \"text/plain\",\n\t\t\t\thtml: \"text/html\",\n\t\t\t\txml: \"application/xml, text/xml\",\n\t\t\t\tjson: \"application/json, text/javascript\"\n\t\t\t},\n\n\t\t\tcontents: {\n\t\t\t\txml: /\\bxml\\b/,\n\t\t\t\thtml: /\\bhtml/,\n\t\t\t\tjson: /\\bjson\\b/\n\t\t\t},\n\n\t\t\tresponseFields: {\n\t\t\t\txml: \"responseXML\",\n\t\t\t\ttext: \"responseText\",\n\t\t\t\tjson: \"responseJSON\"\n\t\t\t},\n\n\t\t\t// Data converters\n\t\t\t// Keys separate source (or catchall \"*\") and destination types with a single space\n\t\t\tconverters: {\n\n\t\t\t\t// Convert anything to text\n\t\t\t\t\"* text\": String,\n\n\t\t\t\t// Text to html (true = no transformation)\n\t\t\t\t\"text html\": true,\n\n\t\t\t\t// Evaluate text as a json expression\n\t\t\t\t\"text json\": jQuery.parseJSON,\n\n\t\t\t\t// Parse text as xml\n\t\t\t\t\"text xml\": jQuery.parseXML\n\t\t\t},\n\n\t\t\t// For options that shouldn't be deep extended:\n\t\t\t// you can add your own custom options here if\n\t\t\t// and when you create one that shouldn't be\n\t\t\t// deep extended (see ajaxExtend)\n\t\t\tflatOptions: {\n\t\t\t\turl: true,\n\t\t\t\tcontext: true\n\t\t\t}\n\t\t},\n\n\t\t// Creates a full fledged settings object into target\n\t\t// with both ajaxSettings and settings fields.\n\t\t// If target is omitted, writes into ajaxSettings.\n\t\tajaxSetup: function( target, settings ) {\n\t\t\treturn settings ?\n\n\t\t\t\t// Building a settings object\n\t\t\t\tajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :\n\n\t\t\t\t// Extending ajaxSettings\n\t\t\t\tajaxExtend( jQuery.ajaxSettings, target );\n\t\t},\n\n\t\tajaxPrefilter: addToPrefiltersOrTransports( prefilters ),\n\t\tajaxTransport: addToPrefiltersOrTransports( transports ),\n\n\t\t// Main method\n\t\tajax: function( url, options ) {\n\n\t\t\t// If url is an object, simulate pre-1.5 signature\n\t\t\tif ( typeof url === \"object\" ) {\n\t\t\t\toptions = url;\n\t\t\t\turl = undefined;\n\t\t\t}\n\n\t\t\t// Force options to be an object\n\t\t\toptions = options || {};\n\n\t\t\tvar\n\n\t\t\t\t// Cross-domain detection vars\n\t\t\t\tparts,\n\n\t\t\t\t// Loop variable\n\t\t\t\ti,\n\n\t\t\t\t// URL without anti-cache param\n\t\t\t\tcacheURL,\n\n\t\t\t\t// Response headers as string\n\t\t\t\tresponseHeadersString,\n\n\t\t\t\t// timeout handle\n\t\t\t\ttimeoutTimer,\n\n\t\t\t\t// To know if global events are to be dispatched\n\t\t\t\tfireGlobals,\n\n\t\t\t\ttransport,\n\n\t\t\t\t// Response headers\n\t\t\t\tresponseHeaders,\n\n\t\t\t\t// Create the final options object\n\t\t\t\ts = jQuery.ajaxSetup( {}, options ),\n\n\t\t\t\t// Callbacks context\n\t\t\t\tcallbackContext = s.context || s,\n\n\t\t\t\t// Context for global events is callbackContext if it is a DOM node or jQuery collection\n\t\t\t\tglobalEventContext = s.context &&\n\t\t\t\t( callbackContext.nodeType || callbackContext.jquery ) ?\n\t\t\t\t\tjQuery( callbackContext ) :\n\t\t\t\t\tjQuery.event,\n\n\t\t\t\t// Deferreds\n\t\t\t\tdeferred = jQuery.Deferred(),\n\t\t\t\tcompleteDeferred = jQuery.Callbacks( \"once memory\" ),\n\n\t\t\t\t// Status-dependent callbacks\n\t\t\t\tstatusCode = s.statusCode || {},\n\n\t\t\t\t// Headers (they are sent all at once)\n\t\t\t\trequestHeaders = {},\n\t\t\t\trequestHeadersNames = {},\n\n\t\t\t\t// The jqXHR state\n\t\t\t\tstate = 0,\n\n\t\t\t\t// Default abort message\n\t\t\t\tstrAbort = \"canceled\",\n\n\t\t\t\t// Fake xhr\n\t\t\t\tjqXHR = {\n\t\t\t\t\treadyState: 0,\n\n\t\t\t\t\t// Builds headers hashtable if needed\n\t\t\t\t\tgetResponseHeader: function( key ) {\n\t\t\t\t\t\tvar match;\n\t\t\t\t\t\tif ( state === 2 ) {\n\t\t\t\t\t\t\tif ( !responseHeaders ) {\n\t\t\t\t\t\t\t\tresponseHeaders = {};\n\t\t\t\t\t\t\t\twhile ( ( match = rheaders.exec( responseHeadersString ) ) ) {\n\t\t\t\t\t\t\t\t\tresponseHeaders[ match[ 1 ].toLowerCase() ] = match[ 2 ];\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tmatch = responseHeaders[ key.toLowerCase() ];\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn match == null ? null : match;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Raw string\n\t\t\t\t\tgetAllResponseHeaders: function() {\n\t\t\t\t\t\treturn state === 2 ? responseHeadersString : null;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Caches the header\n\t\t\t\t\tsetRequestHeader: function( name, value ) {\n\t\t\t\t\t\tvar lname = name.toLowerCase();\n\t\t\t\t\t\tif ( !state ) {\n\t\t\t\t\t\t\tname = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;\n\t\t\t\t\t\t\trequestHeaders[ name ] = value;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Overrides response content-type header\n\t\t\t\t\toverrideMimeType: function( type ) {\n\t\t\t\t\t\tif ( !state ) {\n\t\t\t\t\t\t\ts.mimeType = type;\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Status-dependent callbacks\n\t\t\t\t\tstatusCode: function( map ) {\n\t\t\t\t\t\tvar code;\n\t\t\t\t\t\tif ( map ) {\n\t\t\t\t\t\t\tif ( state < 2 ) {\n\t\t\t\t\t\t\t\tfor ( code in map ) {\n\n\t\t\t\t\t\t\t\t\t// Lazy-add the new callback in a way that preserves old ones\n\t\t\t\t\t\t\t\t\tstatusCode[ code ] = [ statusCode[ code ], map[ code ] ];\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\t\t// Execute the appropriate callbacks\n\t\t\t\t\t\t\t\tjqXHR.always( map[ jqXHR.status ] );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t},\n\n\t\t\t\t\t// Cancel the request\n\t\t\t\t\tabort: function( statusText ) {\n\t\t\t\t\t\tvar finalText = statusText || strAbort;\n\t\t\t\t\t\tif ( transport ) {\n\t\t\t\t\t\t\ttransport.abort( finalText );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tdone( 0, finalText );\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t// Attach deferreds\n\t\t\tdeferred.promise( jqXHR ).complete = completeDeferred.add;\n\t\t\tjqXHR.success = jqXHR.done;\n\t\t\tjqXHR.error = jqXHR.fail;\n\n\t\t\t// Remove hash character (#7531: and string promotion)\n\t\t\t// Add protocol if not provided (#5866: IE7 issue with protocol-less urls)\n\t\t\t// Handle falsy url in the settings object (#10093: consistency with old signature)\n\t\t\t// We also use the url parameter if available\n\t\t\ts.url = ( ( url || s.url || ajaxLocation ) + \"\" )\n\t\t\t\t.replace( rhash, \"\" )\n\t\t\t\t.replace( rprotocol, ajaxLocParts[ 1 ] + \"//\" );\n\n\t\t\t// Alias method option to type as per ticket #12004\n\t\t\ts.type = options.method || options.type || s.method || s.type;\n\n\t\t\t// Extract dataTypes list\n\t\t\ts.dataTypes = jQuery.trim( s.dataType || \"*\" ).toLowerCase().match( rnotwhite ) || [ \"\" ];\n\n\t\t\t// A cross-domain request is in order when we have a protocol:host:port mismatch\n\t\t\tif ( s.crossDomain == null ) {\n\t\t\t\tparts = rurl.exec( s.url.toLowerCase() );\n\t\t\t\ts.crossDomain = !!( parts &&\n\t\t\t\t\t( parts[ 1 ] !== ajaxLocParts[ 1 ] || parts[ 2 ] !== ajaxLocParts[ 2 ] ||\n\t\t\t\t\t( parts[ 3 ] || ( parts[ 1 ] === \"http:\" ? \"80\" : \"443\" ) ) !==\n\t\t\t\t\t( ajaxLocParts[ 3 ] || ( ajaxLocParts[ 1 ] === \"http:\" ? \"80\" : \"443\" ) ) )\n\t\t\t\t);\n\t\t\t}\n\n\t\t\t// Convert data if not already a string\n\t\t\tif ( s.data && s.processData && typeof s.data !== \"string\" ) {\n\t\t\t\ts.data = jQuery.param( s.data, s.traditional );\n\t\t\t}\n\n\t\t\t// Apply prefilters\n\t\t\tinspectPrefiltersOrTransports( prefilters, s, options, jqXHR );\n\n\t\t\t// If request was aborted inside a prefilter, stop there\n\t\t\tif ( state === 2 ) {\n\t\t\t\treturn jqXHR;\n\t\t\t}\n\n\t\t\t// We can fire global events as of now if asked to\n\t\t\t// Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)\n\t\t\tfireGlobals = jQuery.event && s.global;\n\n\t\t\t// Watch for a new set of requests\n\t\t\tif ( fireGlobals && jQuery.active++ === 0 ) {\n\t\t\t\tjQuery.event.trigger( \"ajaxStart\" );\n\t\t\t}\n\n\t\t\t// Uppercase the type\n\t\t\ts.type = s.type.toUpperCase();\n\n\t\t\t// Determine if request has content\n\t\t\ts.hasContent = !rnoContent.test( s.type );\n\n\t\t\t// Save the URL in case we're toying with the If-Modified-Since\n\t\t\t// and/or If-None-Match header later on\n\t\t\tcacheURL = s.url;\n\n\t\t\t// More options handling for requests with no content\n\t\t\tif ( !s.hasContent ) {\n\n\t\t\t\t// If data is available, append data to url\n\t\t\t\tif ( s.data ) {\n\t\t\t\t\tcacheURL = ( s.url += ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + s.data );\n\n\t\t\t\t\t// #9682: remove data so that it's not used in an eventual retry\n\t\t\t\t\tdelete s.data;\n\t\t\t\t}\n\n\t\t\t\t// Add anti-cache in url if needed\n\t\t\t\tif ( s.cache === false ) {\n\t\t\t\t\ts.url = rts.test( cacheURL ) ?\n\n\t\t\t\t\t\t// If there is already a '_' parameter, set its value\n\t\t\t\t\t\tcacheURL.replace( rts, \"$1_=\" + nonce++ ) :\n\n\t\t\t\t\t\t// Otherwise add one to the end\n\t\t\t\t\tcacheURL + ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + \"_=\" + nonce++;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n\t\t\tif ( s.ifModified ) {\n\t\t\t\tif ( jQuery.lastModified[ cacheURL ] ) {\n\t\t\t\t\tjqXHR.setRequestHeader( \"If-Modified-Since\", jQuery.lastModified[ cacheURL ] );\n\t\t\t\t}\n\t\t\t\tif ( jQuery.etag[ cacheURL ] ) {\n\t\t\t\t\tjqXHR.setRequestHeader( \"If-None-Match\", jQuery.etag[ cacheURL ] );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set the correct header, if data is being sent\n\t\t\tif ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {\n\t\t\t\tjqXHR.setRequestHeader( \"Content-Type\", s.contentType );\n\t\t\t}\n\n\t\t\t// Set the Accepts header for the server, depending on the dataType\n\t\t\tjqXHR.setRequestHeader(\n\t\t\t\t\"Accept\",\n\t\t\t\ts.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?\n\t\t\t\ts.accepts[ s.dataTypes[ 0 ] ] +\n\t\t\t\t( s.dataTypes[ 0 ] !== \"*\" ? \", \" + allTypes + \"; q=0.01\" : \"\" ) :\n\t\t\t\t\ts.accepts[ \"*\" ]\n\t\t\t);\n\n\t\t\t// Check for headers option\n\t\t\tfor ( i in s.headers ) {\n\t\t\t\tjqXHR.setRequestHeader( i, s.headers[ i ] );\n\t\t\t}\n\n\t\t\t// Allow custom headers/mimetypes and early abort\n\t\t\tif ( s.beforeSend &&\n\t\t\t\t( s.beforeSend.call( callbackContext, jqXHR, s ) === false || state === 2 ) ) {\n\n\t\t\t\t// Abort if not done already and return\n\t\t\t\treturn jqXHR.abort();\n\t\t\t}\n\n\t\t\t// aborting is no longer a cancellation\n\t\t\tstrAbort = \"abort\";\n\n\t\t\t// Install callbacks on deferreds\n\t\t\tfor ( i in { success: 1, error: 1, complete: 1 } ) {\n\t\t\t\tjqXHR[ i ]( s[ i ] );\n\t\t\t}\n\n\t\t\t// Get transport\n\t\t\ttransport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );\n\n\t\t\t// If no transport, we auto-abort\n\t\t\tif ( !transport ) {\n\t\t\t\tdone( -1, \"No Transport\" );\n\t\t\t} else {\n\t\t\t\tjqXHR.readyState = 1;\n\n\t\t\t\t// Send global event\n\t\t\t\tif ( fireGlobals ) {\n\t\t\t\t\tglobalEventContext.trigger( \"ajaxSend\", [ jqXHR, s ] );\n\t\t\t\t}\n\n\t\t\t\t// If request was aborted inside ajaxSend, stop there\n\t\t\t\tif ( state === 2 ) {\n\t\t\t\t\treturn jqXHR;\n\t\t\t\t}\n\n\t\t\t\t// Timeout\n\t\t\t\tif ( s.async && s.timeout > 0 ) {\n\t\t\t\t\ttimeoutTimer = window.setTimeout( function() {\n\t\t\t\t\t\tjqXHR.abort( \"timeout\" );\n\t\t\t\t\t}, s.timeout );\n\t\t\t\t}\n\n\t\t\t\ttry {\n\t\t\t\t\tstate = 1;\n\t\t\t\t\ttransport.send( requestHeaders, done );\n\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t// Propagate exception as error if not done\n\t\t\t\t\tif ( state < 2 ) {\n\t\t\t\t\t\tdone( -1, e );\n\n\t\t\t\t\t\t// Simply rethrow otherwise\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthrow e;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Callback for when everything is done\n\t\t\tfunction done( status, nativeStatusText, responses, headers ) {\n\t\t\t\tvar isSuccess, success, error, response, modified,\n\t\t\t\t\tstatusText = nativeStatusText;\n\n\t\t\t\t// Called once\n\t\t\t\tif ( state === 2 ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// State is \"done\" now\n\t\t\t\tstate = 2;\n\n\t\t\t\t// Clear timeout if it exists\n\t\t\t\tif ( timeoutTimer ) {\n\t\t\t\t\twindow.clearTimeout( timeoutTimer );\n\t\t\t\t}\n\n\t\t\t\t// Dereference transport for early garbage collection\n\t\t\t\t// (no matter how long the jqXHR object will be used)\n\t\t\t\ttransport = undefined;\n\n\t\t\t\t// Cache response headers\n\t\t\t\tresponseHeadersString = headers || \"\";\n\n\t\t\t\t// Set readyState\n\t\t\t\tjqXHR.readyState = status > 0 ? 4 : 0;\n\n\t\t\t\t// Determine if successful\n\t\t\t\tisSuccess = status >= 200 && status < 300 || status === 304;\n\n\t\t\t\t// Get response data\n\t\t\t\tif ( responses ) {\n\t\t\t\t\tresponse = ajaxHandleResponses( s, jqXHR, responses );\n\t\t\t\t}\n\n\t\t\t\t// Convert no matter what (that way responseXXX fields are always set)\n\t\t\t\tresponse = ajaxConvert( s, response, jqXHR, isSuccess );\n\n\t\t\t\t// If successful, handle type chaining\n\t\t\t\tif ( isSuccess ) {\n\n\t\t\t\t\t// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n\t\t\t\t\tif ( s.ifModified ) {\n\t\t\t\t\t\tmodified = jqXHR.getResponseHeader( \"Last-Modified\" );\n\t\t\t\t\t\tif ( modified ) {\n\t\t\t\t\t\t\tjQuery.lastModified[ cacheURL ] = modified;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tmodified = jqXHR.getResponseHeader( \"etag\" );\n\t\t\t\t\t\tif ( modified ) {\n\t\t\t\t\t\t\tjQuery.etag[ cacheURL ] = modified;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// if no content\n\t\t\t\t\tif ( status === 204 || s.type === \"HEAD\" ) {\n\t\t\t\t\t\tstatusText = \"nocontent\";\n\n\t\t\t\t\t\t// if not modified\n\t\t\t\t\t} else if ( status === 304 ) {\n\t\t\t\t\t\tstatusText = \"notmodified\";\n\n\t\t\t\t\t\t// If we have data, let's convert it\n\t\t\t\t\t} else {\n\t\t\t\t\t\tstatusText = response.state;\n\t\t\t\t\t\tsuccess = response.data;\n\t\t\t\t\t\terror = response.error;\n\t\t\t\t\t\tisSuccess = !error;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\n\t\t\t\t\t// We extract error from statusText\n\t\t\t\t\t// then normalize statusText and status for non-aborts\n\t\t\t\t\terror = statusText;\n\t\t\t\t\tif ( status || !statusText ) {\n\t\t\t\t\t\tstatusText = \"error\";\n\t\t\t\t\t\tif ( status < 0 ) {\n\t\t\t\t\t\t\tstatus = 0;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Set data for the fake xhr object\n\t\t\t\tjqXHR.status = status;\n\t\t\t\tjqXHR.statusText = ( nativeStatusText || statusText ) + \"\";\n\n\t\t\t\t// Success/Error\n\t\t\t\tif ( isSuccess ) {\n\t\t\t\t\tdeferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );\n\t\t\t\t} else {\n\t\t\t\t\tdeferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );\n\t\t\t\t}\n\n\t\t\t\t// Status-dependent callbacks\n\t\t\t\tjqXHR.statusCode( statusCode );\n\t\t\t\tstatusCode = undefined;\n\n\t\t\t\tif ( fireGlobals ) {\n\t\t\t\t\tglobalEventContext.trigger( isSuccess ? \"ajaxSuccess\" : \"ajaxError\",\n\t\t\t\t\t\t[ jqXHR, s, isSuccess ? success : error ] );\n\t\t\t\t}\n\n\t\t\t\t// Complete\n\t\t\t\tcompleteDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );\n\n\t\t\t\tif ( fireGlobals ) {\n\t\t\t\t\tglobalEventContext.trigger( \"ajaxComplete\", [ jqXHR, s ] );\n\n\t\t\t\t\t// Handle the global AJAX counter\n\t\t\t\t\tif ( !( --jQuery.active ) ) {\n\t\t\t\t\t\tjQuery.event.trigger( \"ajaxStop\" );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn jqXHR;\n\t\t},\n\n\t\tgetJSON: function( url, data, callback ) {\n\t\t\treturn jQuery.get( url, data, callback, \"json\" );\n\t\t},\n\n\t\tgetScript: function( url, callback ) {\n\t\t\treturn jQuery.get( url, undefined, callback, \"script\" );\n\t\t}\n\t} );\n\n\tjQuery.each( [ \"get\", \"post\" ], function( i, method ) {\n\t\tjQuery[ method ] = function( url, data, callback, type ) {\n\n\t\t\t// shift arguments if data argument was omitted\n\t\t\tif ( jQuery.isFunction( data ) ) {\n\t\t\t\ttype = type || callback;\n\t\t\t\tcallback = data;\n\t\t\t\tdata = undefined;\n\t\t\t}\n\n\t\t\t// The url can be an options object (which then must have .url)\n\t\t\treturn jQuery.ajax( jQuery.extend( {\n\t\t\t\turl: url,\n\t\t\t\ttype: method,\n\t\t\t\tdataType: type,\n\t\t\t\tdata: data,\n\t\t\t\tsuccess: callback\n\t\t\t}, jQuery.isPlainObject( url ) && url ) );\n\t\t};\n\t} );\n\n\n\tjQuery._evalUrl = function( url ) {\n\t\treturn jQuery.ajax( {\n\t\t\turl: url,\n\n\t\t\t// Make this explicit, since user can override this through ajaxSetup (#11264)\n\t\t\ttype: \"GET\",\n\t\t\tdataType: \"script\",\n\t\t\tcache: true,\n\t\t\tasync: false,\n\t\t\tglobal: false,\n\t\t\t\"throws\": true\n\t\t} );\n\t};\n\n\n\tjQuery.fn.extend( {\n\t\twrapAll: function( html ) {\n\t\t\tif ( jQuery.isFunction( html ) ) {\n\t\t\t\treturn this.each( function( i ) {\n\t\t\t\t\tjQuery( this ).wrapAll( html.call( this, i ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tif ( this[ 0 ] ) {\n\n\t\t\t\t// The elements to wrap the target around\n\t\t\t\tvar wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );\n\n\t\t\t\tif ( this[ 0 ].parentNode ) {\n\t\t\t\t\twrap.insertBefore( this[ 0 ] );\n\t\t\t\t}\n\n\t\t\t\twrap.map( function() {\n\t\t\t\t\tvar elem = this;\n\n\t\t\t\t\twhile ( elem.firstChild && elem.firstChild.nodeType === 1 ) {\n\t\t\t\t\t\telem = elem.firstChild;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn elem;\n\t\t\t\t} ).append( this );\n\t\t\t}\n\n\t\t\treturn this;\n\t\t},\n\n\t\twrapInner: function( html ) {\n\t\t\tif ( jQuery.isFunction( html ) ) {\n\t\t\t\treturn this.each( function( i ) {\n\t\t\t\t\tjQuery( this ).wrapInner( html.call( this, i ) );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn this.each( function() {\n\t\t\t\tvar self = jQuery( this ),\n\t\t\t\t\tcontents = self.contents();\n\n\t\t\t\tif ( contents.length ) {\n\t\t\t\t\tcontents.wrapAll( html );\n\n\t\t\t\t} else {\n\t\t\t\t\tself.append( html );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\twrap: function( html ) {\n\t\t\tvar isFunction = jQuery.isFunction( html );\n\n\t\t\treturn this.each( function( i ) {\n\t\t\t\tjQuery( this ).wrapAll( isFunction ? html.call( this, i ) : html );\n\t\t\t} );\n\t\t},\n\n\t\tunwrap: function() {\n\t\t\treturn this.parent().each( function() {\n\t\t\t\tif ( !jQuery.nodeName( this, \"body\" ) ) {\n\t\t\t\t\tjQuery( this ).replaceWith( this.childNodes );\n\t\t\t\t}\n\t\t\t} ).end();\n\t\t}\n\t} );\n\n\n\tfunction getDisplay( elem ) {\n\t\treturn elem.style && elem.style.display || jQuery.css( elem, \"display\" );\n\t}\n\n\tfunction filterHidden( elem ) {\n\n\t\t// Disconnected elements are considered hidden\n\t\tif ( !jQuery.contains( elem.ownerDocument || document, elem ) ) {\n\t\t\treturn true;\n\t\t}\n\t\twhile ( elem && elem.nodeType === 1 ) {\n\t\t\tif ( getDisplay( elem ) === \"none\" || elem.type === \"hidden\" ) {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\telem = elem.parentNode;\n\t\t}\n\t\treturn false;\n\t}\n\n\tjQuery.expr.filters.hidden = function( elem ) {\n\n\t\t// Support: Opera <= 12.12\n\t\t// Opera reports offsetWidths and offsetHeights less than zero on some elements\n\t\treturn support.reliableHiddenOffsets() ?\n\t\t\t( elem.offsetWidth <= 0 && elem.offsetHeight <= 0 &&\n\t\t\t!elem.getClientRects().length ) :\n\t\t\tfilterHidden( elem );\n\t};\n\n\tjQuery.expr.filters.visible = function( elem ) {\n\t\treturn !jQuery.expr.filters.hidden( elem );\n\t};\n\n\n\n\n\tvar r20 = /%20/g,\n\t\trbracket = /\\[\\]$/,\n\t\trCRLF = /\\r?\\n/g,\n\t\trsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,\n\t\trsubmittable = /^(?:input|select|textarea|keygen)/i;\n\n\tfunction buildParams( prefix, obj, traditional, add ) {\n\t\tvar name;\n\n\t\tif ( jQuery.isArray( obj ) ) {\n\n\t\t\t// Serialize array item.\n\t\t\tjQuery.each( obj, function( i, v ) {\n\t\t\t\tif ( traditional || rbracket.test( prefix ) ) {\n\n\t\t\t\t\t// Treat each array item as a scalar.\n\t\t\t\t\tadd( prefix, v );\n\n\t\t\t\t} else {\n\n\t\t\t\t\t// Item is non-scalar (array or object), encode its numeric index.\n\t\t\t\t\tbuildParams(\n\t\t\t\t\t\tprefix + \"[\" + ( typeof v === \"object\" && v != null ? i : \"\" ) + \"]\",\n\t\t\t\t\t\tv,\n\t\t\t\t\t\ttraditional,\n\t\t\t\t\t\tadd\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t} );\n\n\t\t} else if ( !traditional && jQuery.type( obj ) === \"object\" ) {\n\n\t\t\t// Serialize object item.\n\t\t\tfor ( name in obj ) {\n\t\t\t\tbuildParams( prefix + \"[\" + name + \"]\", obj[ name ], traditional, add );\n\t\t\t}\n\n\t\t} else {\n\n\t\t\t// Serialize scalar item.\n\t\t\tadd( prefix, obj );\n\t\t}\n\t}\n\n// Serialize an array of form elements or a set of\n// key/values into a query string\n\tjQuery.param = function( a, traditional ) {\n\t\tvar prefix,\n\t\t\ts = [],\n\t\t\tadd = function( key, value ) {\n\n\t\t\t\t// If value is a function, invoke it and return its value\n\t\t\t\tvalue = jQuery.isFunction( value ) ? value() : ( value == null ? \"\" : value );\n\t\t\t\ts[ s.length ] = encodeURIComponent( key ) + \"=\" + encodeURIComponent( value );\n\t\t\t};\n\n\t\t// Set traditional to true for jQuery <= 1.3.2 behavior.\n\t\tif ( traditional === undefined ) {\n\t\t\ttraditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;\n\t\t}\n\n\t\t// If an array was passed in, assume that it is an array of form elements.\n\t\tif ( jQuery.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {\n\n\t\t\t// Serialize the form elements\n\t\t\tjQuery.each( a, function() {\n\t\t\t\tadd( this.name, this.value );\n\t\t\t} );\n\n\t\t} else {\n\n\t\t\t// If traditional, encode the \"old\" way (the way 1.3.2 or older\n\t\t\t// did it), otherwise encode params recursively.\n\t\t\tfor ( prefix in a ) {\n\t\t\t\tbuildParams( prefix, a[ prefix ], traditional, add );\n\t\t\t}\n\t\t}\n\n\t\t// Return the resulting serialization\n\t\treturn s.join( \"&\" ).replace( r20, \"+\" );\n\t};\n\n\tjQuery.fn.extend( {\n\t\tserialize: function() {\n\t\t\treturn jQuery.param( this.serializeArray() );\n\t\t},\n\t\tserializeArray: function() {\n\t\t\treturn this.map( function() {\n\n\t\t\t\t// Can add propHook for \"elements\" to filter or add form elements\n\t\t\t\tvar elements = jQuery.prop( this, \"elements\" );\n\t\t\t\treturn elements ? jQuery.makeArray( elements ) : this;\n\t\t\t} )\n\t\t\t\t.filter( function() {\n\t\t\t\t\tvar type = this.type;\n\n\t\t\t\t\t// Use .is(\":disabled\") so that fieldset[disabled] works\n\t\t\t\t\treturn this.name && !jQuery( this ).is( \":disabled\" ) &&\n\t\t\t\t\t\trsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&\n\t\t\t\t\t\t( this.checked || !rcheckableType.test( type ) );\n\t\t\t\t} )\n\t\t\t\t.map( function( i, elem ) {\n\t\t\t\t\tvar val = jQuery( this ).val();\n\n\t\t\t\t\treturn val == null ?\n\t\t\t\t\t\tnull :\n\t\t\t\t\t\tjQuery.isArray( val ) ?\n\t\t\t\t\t\t\tjQuery.map( val, function( val ) {\n\t\t\t\t\t\t\t\treturn { name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n\t\t\t\t\t\t\t} ) :\n\t\t\t\t\t\t{ name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n\t\t\t\t} ).get();\n\t\t}\n\t} );\n\n\n// Create the request object\n// (This is still attached to ajaxSettings for backward compatibility)\n\tjQuery.ajaxSettings.xhr = window.ActiveXObject !== undefined ?\n\n\t\t// Support: IE6-IE8\n\t\tfunction() {\n\n\t\t\t// XHR cannot access local files, always use ActiveX for that case\n\t\t\tif ( this.isLocal ) {\n\t\t\t\treturn createActiveXHR();\n\t\t\t}\n\n\t\t\t// Support: IE 9-11\n\t\t\t// IE seems to error on cross-domain PATCH requests when ActiveX XHR\n\t\t\t// is used. In IE 9+ always use the native XHR.\n\t\t\t// Note: this condition won't catch Edge as it doesn't define\n\t\t\t// document.documentMode but it also doesn't support ActiveX so it won't\n\t\t\t// reach this code.\n\t\t\tif ( document.documentMode > 8 ) {\n\t\t\t\treturn createStandardXHR();\n\t\t\t}\n\n\t\t\t// Support: IE<9\n\t\t\t// oldIE XHR does not support non-RFC2616 methods (#13240)\n\t\t\t// See http://msdn.microsoft.com/en-us/library/ie/ms536648(v=vs.85).aspx\n\t\t\t// and http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9\n\t\t\t// Although this check for six methods instead of eight\n\t\t\t// since IE also does not support \"trace\" and \"connect\"\n\t\t\treturn /^(get|post|head|put|delete|options)$/i.test( this.type ) &&\n\t\t\t\tcreateStandardXHR() || createActiveXHR();\n\t\t} :\n\n\t\t// For all other browsers, use the standard XMLHttpRequest object\n\t\tcreateStandardXHR;\n\n\tvar xhrId = 0,\n\t\txhrCallbacks = {},\n\t\txhrSupported = jQuery.ajaxSettings.xhr();\n\n// Support: IE<10\n// Open requests must be manually aborted on unload (#5280)\n// See https://support.microsoft.com/kb/2856746 for more info\n\tif ( window.attachEvent ) {\n\t\twindow.attachEvent( \"onunload\", function() {\n\t\t\tfor ( var key in xhrCallbacks ) {\n\t\t\t\txhrCallbacks[ key ]( undefined, true );\n\t\t\t}\n\t\t} );\n\t}\n\n// Determine support properties\n\tsupport.cors = !!xhrSupported && ( \"withCredentials\" in xhrSupported );\n\txhrSupported = support.ajax = !!xhrSupported;\n\n// Create transport if the browser can provide an xhr\n\tif ( xhrSupported ) {\n\n\t\tjQuery.ajaxTransport( function( options ) {\n\n\t\t\t// Cross domain only allowed if supported through XMLHttpRequest\n\t\t\tif ( !options.crossDomain || support.cors ) {\n\n\t\t\t\tvar callback;\n\n\t\t\t\treturn {\n\t\t\t\t\tsend: function( headers, complete ) {\n\t\t\t\t\t\tvar i,\n\t\t\t\t\t\t\txhr = options.xhr(),\n\t\t\t\t\t\t\tid = ++xhrId;\n\n\t\t\t\t\t\t// Open the socket\n\t\t\t\t\t\txhr.open(\n\t\t\t\t\t\t\toptions.type,\n\t\t\t\t\t\t\toptions.url,\n\t\t\t\t\t\t\toptions.async,\n\t\t\t\t\t\t\toptions.username,\n\t\t\t\t\t\t\toptions.password\n\t\t\t\t\t\t);\n\n\t\t\t\t\t\t// Apply custom fields if provided\n\t\t\t\t\t\tif ( options.xhrFields ) {\n\t\t\t\t\t\t\tfor ( i in options.xhrFields ) {\n\t\t\t\t\t\t\t\txhr[ i ] = options.xhrFields[ i ];\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Override mime type if needed\n\t\t\t\t\t\tif ( options.mimeType && xhr.overrideMimeType ) {\n\t\t\t\t\t\t\txhr.overrideMimeType( options.mimeType );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// X-Requested-With header\n\t\t\t\t\t\t// For cross-domain requests, seeing as conditions for a preflight are\n\t\t\t\t\t\t// akin to a jigsaw puzzle, we simply never set it to be sure.\n\t\t\t\t\t\t// (it can always be set on a per-request basis or even using ajaxSetup)\n\t\t\t\t\t\t// For same-domain requests, won't change header if already provided.\n\t\t\t\t\t\tif ( !options.crossDomain && !headers[ \"X-Requested-With\" ] ) {\n\t\t\t\t\t\t\theaders[ \"X-Requested-With\" ] = \"XMLHttpRequest\";\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Set headers\n\t\t\t\t\t\tfor ( i in headers ) {\n\n\t\t\t\t\t\t\t// Support: IE<9\n\t\t\t\t\t\t\t// IE's ActiveXObject throws a 'Type Mismatch' exception when setting\n\t\t\t\t\t\t\t// request header to a null-value.\n\t\t\t\t\t\t\t//\n\t\t\t\t\t\t\t// To keep consistent with other XHR implementations, cast the value\n\t\t\t\t\t\t\t// to string and ignore `undefined`.\n\t\t\t\t\t\t\tif ( headers[ i ] !== undefined ) {\n\t\t\t\t\t\t\t\txhr.setRequestHeader( i, headers[ i ] + \"\" );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Do send the request\n\t\t\t\t\t\t// This may raise an exception which is actually\n\t\t\t\t\t\t// handled in jQuery.ajax (so no try/catch here)\n\t\t\t\t\t\txhr.send( ( options.hasContent && options.data ) || null );\n\n\t\t\t\t\t\t// Listener\n\t\t\t\t\t\tcallback = function( _, isAbort ) {\n\t\t\t\t\t\t\tvar status, statusText, responses;\n\n\t\t\t\t\t\t\t// Was never called and is aborted or complete\n\t\t\t\t\t\t\tif ( callback && ( isAbort || xhr.readyState === 4 ) ) {\n\n\t\t\t\t\t\t\t\t// Clean up\n\t\t\t\t\t\t\t\tdelete xhrCallbacks[ id ];\n\t\t\t\t\t\t\t\tcallback = undefined;\n\t\t\t\t\t\t\t\txhr.onreadystatechange = jQuery.noop;\n\n\t\t\t\t\t\t\t\t// Abort manually if needed\n\t\t\t\t\t\t\t\tif ( isAbort ) {\n\t\t\t\t\t\t\t\t\tif ( xhr.readyState !== 4 ) {\n\t\t\t\t\t\t\t\t\t\txhr.abort();\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tresponses = {};\n\t\t\t\t\t\t\t\t\tstatus = xhr.status;\n\n\t\t\t\t\t\t\t\t\t// Support: IE<10\n\t\t\t\t\t\t\t\t\t// Accessing binary-data responseText throws an exception\n\t\t\t\t\t\t\t\t\t// (#11426)\n\t\t\t\t\t\t\t\t\tif ( typeof xhr.responseText === \"string\" ) {\n\t\t\t\t\t\t\t\t\t\tresponses.text = xhr.responseText;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Firefox throws an exception when accessing\n\t\t\t\t\t\t\t\t\t// statusText for faulty cross-domain requests\n\t\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\t\tstatusText = xhr.statusText;\n\t\t\t\t\t\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t\t\t\t\t\t// We normalize with Webkit giving an empty statusText\n\t\t\t\t\t\t\t\t\t\tstatusText = \"\";\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Filter status for non standard behaviors\n\n\t\t\t\t\t\t\t\t\t// If the request is local and we have data: assume a success\n\t\t\t\t\t\t\t\t\t// (success with no data won't get notified, that's the best we\n\t\t\t\t\t\t\t\t\t// can do given current implementations)\n\t\t\t\t\t\t\t\t\tif ( !status && options.isLocal && !options.crossDomain ) {\n\t\t\t\t\t\t\t\t\t\tstatus = responses.text ? 200 : 404;\n\n\t\t\t\t\t\t\t\t\t\t// IE - #1450: sometimes returns 1223 when it should be 204\n\t\t\t\t\t\t\t\t\t} else if ( status === 1223 ) {\n\t\t\t\t\t\t\t\t\t\tstatus = 204;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Call complete if needed\n\t\t\t\t\t\t\tif ( responses ) {\n\t\t\t\t\t\t\t\tcomplete( status, statusText, responses, xhr.getAllResponseHeaders() );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\t// Do send the request\n\t\t\t\t\t\t// `xhr.send` may raise an exception, but it will be\n\t\t\t\t\t\t// handled in jQuery.ajax (so no try/catch here)\n\t\t\t\t\t\tif ( !options.async ) {\n\n\t\t\t\t\t\t\t// If we're in sync mode we fire the callback\n\t\t\t\t\t\t\tcallback();\n\t\t\t\t\t\t} else if ( xhr.readyState === 4 ) {\n\n\t\t\t\t\t\t\t// (IE6 & IE7) if it's in cache and has been\n\t\t\t\t\t\t\t// retrieved directly we need to fire the callback\n\t\t\t\t\t\t\twindow.setTimeout( callback );\n\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\t// Register the callback, but delay it in case `xhr.send` throws\n\t\t\t\t\t\t\t// Add to the list of active xhr callbacks\n\t\t\t\t\t\t\txhr.onreadystatechange = xhrCallbacks[ id ] = callback;\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\n\t\t\t\t\tabort: function() {\n\t\t\t\t\t\tif ( callback ) {\n\t\t\t\t\t\t\tcallback( undefined, true );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\t\t} );\n\t}\n\n// Functions to create xhrs\n\tfunction createStandardXHR() {\n\t\ttry {\n\t\t\treturn new window.XMLHttpRequest();\n\t\t} catch ( e ) {}\n\t}\n\n\tfunction createActiveXHR() {\n\t\ttry {\n\t\t\treturn new window.ActiveXObject( \"Microsoft.XMLHTTP\" );\n\t\t} catch ( e ) {}\n\t}\n\n\n\n\n// Install script dataType\n\tjQuery.ajaxSetup( {\n\t\taccepts: {\n\t\t\tscript: \"text/javascript, application/javascript, \" +\n\t\t\t\"application/ecmascript, application/x-ecmascript\"\n\t\t},\n\t\tcontents: {\n\t\t\tscript: /\\b(?:java|ecma)script\\b/\n\t\t},\n\t\tconverters: {\n\t\t\t\"text script\": function( text ) {\n\t\t\t\tjQuery.globalEval( text );\n\t\t\t\treturn text;\n\t\t\t}\n\t\t}\n\t} );\n\n// Handle cache's special case and global\n\tjQuery.ajaxPrefilter( \"script\", function( s ) {\n\t\tif ( s.cache === undefined ) {\n\t\t\ts.cache = false;\n\t\t}\n\t\tif ( s.crossDomain ) {\n\t\t\ts.type = \"GET\";\n\t\t\ts.global = false;\n\t\t}\n\t} );\n\n// Bind script tag hack transport\n\tjQuery.ajaxTransport( \"script\", function( s ) {\n\n\t\t// This transport only deals with cross domain requests\n\t\tif ( s.crossDomain ) {\n\n\t\t\tvar script,\n\t\t\t\thead = document.head || jQuery( \"head\" )[ 0 ] || document.documentElement;\n\n\t\t\treturn {\n\n\t\t\t\tsend: function( _, callback ) {\n\n\t\t\t\t\tscript = document.createElement( \"script\" );\n\n\t\t\t\t\tscript.async = true;\n\n\t\t\t\t\tif ( s.scriptCharset ) {\n\t\t\t\t\t\tscript.charset = s.scriptCharset;\n\t\t\t\t\t}\n\n\t\t\t\t\tscript.src = s.url;\n\n\t\t\t\t\t// Attach handlers for all browsers\n\t\t\t\t\tscript.onload = script.onreadystatechange = function( _, isAbort ) {\n\n\t\t\t\t\t\tif ( isAbort || !script.readyState || /loaded|complete/.test( script.readyState ) ) {\n\n\t\t\t\t\t\t\t// Handle memory leak in IE\n\t\t\t\t\t\t\tscript.onload = script.onreadystatechange = null;\n\n\t\t\t\t\t\t\t// Remove the script\n\t\t\t\t\t\t\tif ( script.parentNode ) {\n\t\t\t\t\t\t\t\tscript.parentNode.removeChild( script );\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Dereference the script\n\t\t\t\t\t\t\tscript = null;\n\n\t\t\t\t\t\t\t// Callback if not abort\n\t\t\t\t\t\t\tif ( !isAbort ) {\n\t\t\t\t\t\t\t\tcallback( 200, \"success\" );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\t// Circumvent IE6 bugs with base elements (#2709 and #4378) by prepending\n\t\t\t\t\t// Use native DOM manipulation to avoid our domManip AJAX trickery\n\t\t\t\t\thead.insertBefore( script, head.firstChild );\n\t\t\t\t},\n\n\t\t\t\tabort: function() {\n\t\t\t\t\tif ( script ) {\n\t\t\t\t\t\tscript.onload( undefined, true );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t} );\n\n\n\n\n\tvar oldCallbacks = [],\n\t\trjsonp = /(=)\\?(?=&|$)|\\?\\?/;\n\n// Default jsonp settings\n\tjQuery.ajaxSetup( {\n\t\tjsonp: \"callback\",\n\t\tjsonpCallback: function() {\n\t\t\tvar callback = oldCallbacks.pop() || ( jQuery.expando + \"_\" + ( nonce++ ) );\n\t\t\tthis[ callback ] = true;\n\t\t\treturn callback;\n\t\t}\n\t} );\n\n// Detect, normalize options and install callbacks for jsonp requests\n\tjQuery.ajaxPrefilter( \"json jsonp\", function( s, originalSettings, jqXHR ) {\n\n\t\tvar callbackName, overwritten, responseContainer,\n\t\t\tjsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?\n\t\t\t\t\t\t\"url\" :\n\t\t\t\t\ttypeof s.data === \"string\" &&\n\t\t\t\t\t( s.contentType || \"\" )\n\t\t\t\t\t\t.indexOf( \"application/x-www-form-urlencoded\" ) === 0 &&\n\t\t\t\t\trjsonp.test( s.data ) && \"data\"\n\t\t\t\t);\n\n\t\t// Handle iff the expected data type is \"jsonp\" or we have a parameter to set\n\t\tif ( jsonProp || s.dataTypes[ 0 ] === \"jsonp\" ) {\n\n\t\t\t// Get callback name, remembering preexisting value associated with it\n\t\t\tcallbackName = s.jsonpCallback = jQuery.isFunction( s.jsonpCallback ) ?\n\t\t\t\ts.jsonpCallback() :\n\t\t\t\ts.jsonpCallback;\n\n\t\t\t// Insert callback into url or form data\n\t\t\tif ( jsonProp ) {\n\t\t\t\ts[ jsonProp ] = s[ jsonProp ].replace( rjsonp, \"$1\" + callbackName );\n\t\t\t} else if ( s.jsonp !== false ) {\n\t\t\t\ts.url += ( rquery.test( s.url ) ? \"&\" : \"?\" ) + s.jsonp + \"=\" + callbackName;\n\t\t\t}\n\n\t\t\t// Use data converter to retrieve json after script execution\n\t\t\ts.converters[ \"script json\" ] = function() {\n\t\t\t\tif ( !responseContainer ) {\n\t\t\t\t\tjQuery.error( callbackName + \" was not called\" );\n\t\t\t\t}\n\t\t\t\treturn responseContainer[ 0 ];\n\t\t\t};\n\n\t\t\t// force json dataType\n\t\t\ts.dataTypes[ 0 ] = \"json\";\n\n\t\t\t// Install callback\n\t\t\toverwritten = window[ callbackName ];\n\t\t\twindow[ callbackName ] = function() {\n\t\t\t\tresponseContainer = arguments;\n\t\t\t};\n\n\t\t\t// Clean-up function (fires after converters)\n\t\t\tjqXHR.always( function() {\n\n\t\t\t\t// If previous value didn't exist - remove it\n\t\t\t\tif ( overwritten === undefined ) {\n\t\t\t\t\tjQuery( window ).removeProp( callbackName );\n\n\t\t\t\t\t// Otherwise restore preexisting value\n\t\t\t\t} else {\n\t\t\t\t\twindow[ callbackName ] = overwritten;\n\t\t\t\t}\n\n\t\t\t\t// Save back as free\n\t\t\t\tif ( s[ callbackName ] ) {\n\n\t\t\t\t\t// make sure that re-using the options doesn't screw things around\n\t\t\t\t\ts.jsonpCallback = originalSettings.jsonpCallback;\n\n\t\t\t\t\t// save the callback name for future use\n\t\t\t\t\toldCallbacks.push( callbackName );\n\t\t\t\t}\n\n\t\t\t\t// Call if it was a function and we have a response\n\t\t\t\tif ( responseContainer && jQuery.isFunction( overwritten ) ) {\n\t\t\t\t\toverwritten( responseContainer[ 0 ] );\n\t\t\t\t}\n\n\t\t\t\tresponseContainer = overwritten = undefined;\n\t\t\t} );\n\n\t\t\t// Delegate to script\n\t\t\treturn \"script\";\n\t\t}\n\t} );\n\n\n\n\n// data: string of html\n// context (optional): If specified, the fragment will be created in this context,\n// defaults to document\n// keepScripts (optional): If true, will include scripts passed in the html string\n\tjQuery.parseHTML = function( data, context, keepScripts ) {\n\t\tif ( !data || typeof data !== \"string\" ) {\n\t\t\treturn null;\n\t\t}\n\t\tif ( typeof context === \"boolean\" ) {\n\t\t\tkeepScripts = context;\n\t\t\tcontext = false;\n\t\t}\n\t\tcontext = context || document;\n\n\t\tvar parsed = rsingleTag.exec( data ),\n\t\t\tscripts = !keepScripts && [];\n\n\t\t// Single tag\n\t\tif ( parsed ) {\n\t\t\treturn [ context.createElement( parsed[ 1 ] ) ];\n\t\t}\n\n\t\tparsed = buildFragment( [ data ], context, scripts );\n\n\t\tif ( scripts && scripts.length ) {\n\t\t\tjQuery( scripts ).remove();\n\t\t}\n\n\t\treturn jQuery.merge( [], parsed.childNodes );\n\t};\n\n\n// Keep a copy of the old load method\n\tvar _load = jQuery.fn.load;\n\n\t/**\n\t * Load a url into a page\n\t */\n\tjQuery.fn.load = function( url, params, callback ) {\n\t\tif ( typeof url !== \"string\" && _load ) {\n\t\t\treturn _load.apply( this, arguments );\n\t\t}\n\n\t\tvar selector, type, response,\n\t\t\tself = this,\n\t\t\toff = url.indexOf( \" \" );\n\n\t\tif ( off > -1 ) {\n\t\t\tselector = jQuery.trim( url.slice( off, url.length ) );\n\t\t\turl = url.slice( 0, off );\n\t\t}\n\n\t\t// If it's a function\n\t\tif ( jQuery.isFunction( params ) ) {\n\n\t\t\t// We assume that it's the callback\n\t\t\tcallback = params;\n\t\t\tparams = undefined;\n\n\t\t\t// Otherwise, build a param string\n\t\t} else if ( params && typeof params === \"object\" ) {\n\t\t\ttype = \"POST\";\n\t\t}\n\n\t\t// If we have elements to modify, make the request\n\t\tif ( self.length > 0 ) {\n\t\t\tjQuery.ajax( {\n\t\t\t\turl: url,\n\n\t\t\t\t// If \"type\" variable is undefined, then \"GET\" method will be used.\n\t\t\t\t// Make value of this field explicit since\n\t\t\t\t// user can override it through ajaxSetup method\n\t\t\t\ttype: type || \"GET\",\n\t\t\t\tdataType: \"html\",\n\t\t\t\tdata: params\n\t\t\t} ).done( function( responseText ) {\n\n\t\t\t\t// Save response for use in complete callback\n\t\t\t\tresponse = arguments;\n\n\t\t\t\tself.html( selector ?\n\n\t\t\t\t\t// If a selector was specified, locate the right elements in a dummy div\n\t\t\t\t\t// Exclude scripts to avoid IE 'Permission Denied' errors\n\t\t\t\t\tjQuery( \"<div>\" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :\n\n\t\t\t\t\t// Otherwise use the full result\n\t\t\t\t\tresponseText );\n\n\t\t\t\t// If the request succeeds, this function gets \"data\", \"status\", \"jqXHR\"\n\t\t\t\t// but they are ignored because response was set above.\n\t\t\t\t// If it fails, this function gets \"jqXHR\", \"status\", \"error\"\n\t\t\t} ).always( callback && function( jqXHR, status ) {\n\t\t\t\t\tself.each( function() {\n\t\t\t\t\t\tcallback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );\n\t\t\t\t\t} );\n\t\t\t\t} );\n\t\t}\n\n\t\treturn this;\n\t};\n\n\n\n\n// Attach a bunch of functions for handling common AJAX events\n\tjQuery.each( [\n\t\t\"ajaxStart\",\n\t\t\"ajaxStop\",\n\t\t\"ajaxComplete\",\n\t\t\"ajaxError\",\n\t\t\"ajaxSuccess\",\n\t\t\"ajaxSend\"\n\t], function( i, type ) {\n\t\tjQuery.fn[ type ] = function( fn ) {\n\t\t\treturn this.on( type, fn );\n\t\t};\n\t} );\n\n\n\n\n\tjQuery.expr.filters.animated = function( elem ) {\n\t\treturn jQuery.grep( jQuery.timers, function( fn ) {\n\t\t\treturn elem === fn.elem;\n\t\t} ).length;\n\t};\n\n\n\n\n\n\t/**\n\t * Gets a window from an element\n\t */\n\tfunction getWindow( elem ) {\n\t\treturn jQuery.isWindow( elem ) ?\n\t\t\telem :\n\t\t\telem.nodeType === 9 ?\n\t\t\telem.defaultView || elem.parentWindow :\n\t\t\t\tfalse;\n\t}\n\n\tjQuery.offset = {\n\t\tsetOffset: function( elem, options, i ) {\n\t\t\tvar curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,\n\t\t\t\tposition = jQuery.css( elem, \"position\" ),\n\t\t\t\tcurElem = jQuery( elem ),\n\t\t\t\tprops = {};\n\n\t\t\t// set position first, in-case top/left are set even on static elem\n\t\t\tif ( position === \"static\" ) {\n\t\t\t\telem.style.position = \"relative\";\n\t\t\t}\n\n\t\t\tcurOffset = curElem.offset();\n\t\t\tcurCSSTop = jQuery.css( elem, \"top\" );\n\t\t\tcurCSSLeft = jQuery.css( elem, \"left\" );\n\t\t\tcalculatePosition = ( position === \"absolute\" || position === \"fixed\" ) &&\n\t\t\t\tjQuery.inArray( \"auto\", [ curCSSTop, curCSSLeft ] ) > -1;\n\n\t\t\t// need to be able to calculate position if either top or left\n\t\t\t// is auto and position is either absolute or fixed\n\t\t\tif ( calculatePosition ) {\n\t\t\t\tcurPosition = curElem.position();\n\t\t\t\tcurTop = curPosition.top;\n\t\t\t\tcurLeft = curPosition.left;\n\t\t\t} else {\n\t\t\t\tcurTop = parseFloat( curCSSTop ) || 0;\n\t\t\t\tcurLeft = parseFloat( curCSSLeft ) || 0;\n\t\t\t}\n\n\t\t\tif ( jQuery.isFunction( options ) ) {\n\n\t\t\t\t// Use jQuery.extend here to allow modification of coordinates argument (gh-1848)\n\t\t\t\toptions = options.call( elem, i, jQuery.extend( {}, curOffset ) );\n\t\t\t}\n\n\t\t\tif ( options.top != null ) {\n\t\t\t\tprops.top = ( options.top - curOffset.top ) + curTop;\n\t\t\t}\n\t\t\tif ( options.left != null ) {\n\t\t\t\tprops.left = ( options.left - curOffset.left ) + curLeft;\n\t\t\t}\n\n\t\t\tif ( \"using\" in options ) {\n\t\t\t\toptions.using.call( elem, props );\n\t\t\t} else {\n\t\t\t\tcurElem.css( props );\n\t\t\t}\n\t\t}\n\t};\n\n\tjQuery.fn.extend( {\n\t\toffset: function( options ) {\n\t\t\tif ( arguments.length ) {\n\t\t\t\treturn options === undefined ?\n\t\t\t\t\tthis :\n\t\t\t\t\tthis.each( function( i ) {\n\t\t\t\t\t\tjQuery.offset.setOffset( this, options, i );\n\t\t\t\t\t} );\n\t\t\t}\n\n\t\t\tvar docElem, win,\n\t\t\t\tbox = { top: 0, left: 0 },\n\t\t\t\telem = this[ 0 ],\n\t\t\t\tdoc = elem && elem.ownerDocument;\n\n\t\t\tif ( !doc ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tdocElem = doc.documentElement;\n\n\t\t\t// Make sure it's not a disconnected DOM node\n\t\t\tif ( !jQuery.contains( docElem, elem ) ) {\n\t\t\t\treturn box;\n\t\t\t}\n\n\t\t\t// If we don't have gBCR, just use 0,0 rather than error\n\t\t\t// BlackBerry 5, iOS 3 (original iPhone)\n\t\t\tif ( typeof elem.getBoundingClientRect !== \"undefined\" ) {\n\t\t\t\tbox = elem.getBoundingClientRect();\n\t\t\t}\n\t\t\twin = getWindow( doc );\n\t\t\treturn {\n\t\t\t\ttop: box.top  + ( win.pageYOffset || docElem.scrollTop )  - ( docElem.clientTop  || 0 ),\n\t\t\t\tleft: box.left + ( win.pageXOffset || docElem.scrollLeft ) - ( docElem.clientLeft || 0 )\n\t\t\t};\n\t\t},\n\n\t\tposition: function() {\n\t\t\tif ( !this[ 0 ] ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tvar offsetParent, offset,\n\t\t\t\tparentOffset = { top: 0, left: 0 },\n\t\t\t\telem = this[ 0 ];\n\n\t\t\t// Fixed elements are offset from window (parentOffset = {top:0, left: 0},\n\t\t\t// because it is its only offset parent\n\t\t\tif ( jQuery.css( elem, \"position\" ) === \"fixed\" ) {\n\n\t\t\t\t// we assume that getBoundingClientRect is available when computed position is fixed\n\t\t\t\toffset = elem.getBoundingClientRect();\n\t\t\t} else {\n\n\t\t\t\t// Get *real* offsetParent\n\t\t\t\toffsetParent = this.offsetParent();\n\n\t\t\t\t// Get correct offsets\n\t\t\t\toffset = this.offset();\n\t\t\t\tif ( !jQuery.nodeName( offsetParent[ 0 ], \"html\" ) ) {\n\t\t\t\t\tparentOffset = offsetParent.offset();\n\t\t\t\t}\n\n\t\t\t\t// Add offsetParent borders\n\t\t\t\tparentOffset.top  += jQuery.css( offsetParent[ 0 ], \"borderTopWidth\", true );\n\t\t\t\tparentOffset.left += jQuery.css( offsetParent[ 0 ], \"borderLeftWidth\", true );\n\t\t\t}\n\n\t\t\t// Subtract parent offsets and element margins\n\t\t\t// note: when an element has margin: auto the offsetLeft and marginLeft\n\t\t\t// are the same in Safari causing offset.left to incorrectly be 0\n\t\t\treturn {\n\t\t\t\ttop:  offset.top  - parentOffset.top - jQuery.css( elem, \"marginTop\", true ),\n\t\t\t\tleft: offset.left - parentOffset.left - jQuery.css( elem, \"marginLeft\", true )\n\t\t\t};\n\t\t},\n\n\t\toffsetParent: function() {\n\t\t\treturn this.map( function() {\n\t\t\t\tvar offsetParent = this.offsetParent;\n\n\t\t\t\twhile ( offsetParent && ( !jQuery.nodeName( offsetParent, \"html\" ) &&\n\t\t\t\tjQuery.css( offsetParent, \"position\" ) === \"static\" ) ) {\n\t\t\t\t\toffsetParent = offsetParent.offsetParent;\n\t\t\t\t}\n\t\t\t\treturn offsetParent || documentElement;\n\t\t\t} );\n\t\t}\n\t} );\n\n// Create scrollLeft and scrollTop methods\n\tjQuery.each( { scrollLeft: \"pageXOffset\", scrollTop: \"pageYOffset\" }, function( method, prop ) {\n\t\tvar top = /Y/.test( prop );\n\n\t\tjQuery.fn[ method ] = function( val ) {\n\t\t\treturn access( this, function( elem, method, val ) {\n\t\t\t\tvar win = getWindow( elem );\n\n\t\t\t\tif ( val === undefined ) {\n\t\t\t\t\treturn win ? ( prop in win ) ? win[ prop ] :\n\t\t\t\t\t\twin.document.documentElement[ method ] :\n\t\t\t\t\t\telem[ method ];\n\t\t\t\t}\n\n\t\t\t\tif ( win ) {\n\t\t\t\t\twin.scrollTo(\n\t\t\t\t\t\t!top ? val : jQuery( win ).scrollLeft(),\n\t\t\t\t\t\ttop ? val : jQuery( win ).scrollTop()\n\t\t\t\t\t);\n\n\t\t\t\t} else {\n\t\t\t\t\telem[ method ] = val;\n\t\t\t\t}\n\t\t\t}, method, val, arguments.length, null );\n\t\t};\n\t} );\n\n// Support: Safari<7-8+, Chrome<37-44+\n// Add the top/left cssHooks using jQuery.fn.position\n// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084\n// getComputedStyle returns percent when specified for top/left/bottom/right\n// rather than make the css module depend on the offset module, we just check for it here\n\tjQuery.each( [ \"top\", \"left\" ], function( i, prop ) {\n\t\tjQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,\n\t\t\tfunction( elem, computed ) {\n\t\t\t\tif ( computed ) {\n\t\t\t\t\tcomputed = curCSS( elem, prop );\n\n\t\t\t\t\t// if curCSS returns percentage, fallback to offset\n\t\t\t\t\treturn rnumnonpx.test( computed ) ?\n\t\t\t\t\tjQuery( elem ).position()[ prop ] + \"px\" :\n\t\t\t\t\t\tcomputed;\n\t\t\t\t}\n\t\t\t}\n\t\t);\n\t} );\n\n\n// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods\n\tjQuery.each( { Height: \"height\", Width: \"width\" }, function( name, type ) {\n\t\tjQuery.each( { padding: \"inner\" + name, content: type, \"\": \"outer\" + name },\n\t\t\tfunction( defaultExtra, funcName ) {\n\n\t\t\t\t// margin is only for outerHeight, outerWidth\n\t\t\t\tjQuery.fn[ funcName ] = function( margin, value ) {\n\t\t\t\t\tvar chainable = arguments.length && ( defaultExtra || typeof margin !== \"boolean\" ),\n\t\t\t\t\t\textra = defaultExtra || ( margin === true || value === true ? \"margin\" : \"border\" );\n\n\t\t\t\t\treturn access( this, function( elem, type, value ) {\n\t\t\t\t\t\tvar doc;\n\n\t\t\t\t\t\tif ( jQuery.isWindow( elem ) ) {\n\n\t\t\t\t\t\t\t// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there\n\t\t\t\t\t\t\t// isn't a whole lot we can do. See pull request at this URL for discussion:\n\t\t\t\t\t\t\t// https://github.com/jquery/jquery/pull/764\n\t\t\t\t\t\t\treturn elem.document.documentElement[ \"client\" + name ];\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Get document width or height\n\t\t\t\t\t\tif ( elem.nodeType === 9 ) {\n\t\t\t\t\t\t\tdoc = elem.documentElement;\n\n\t\t\t\t\t\t\t// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],\n\t\t\t\t\t\t\t// whichever is greatest\n\t\t\t\t\t\t\t// unfortunately, this causes bug #3838 in IE6/8 only,\n\t\t\t\t\t\t\t// but there is currently no good, small way to fix it.\n\t\t\t\t\t\t\treturn Math.max(\n\t\t\t\t\t\t\t\telem.body[ \"scroll\" + name ], doc[ \"scroll\" + name ],\n\t\t\t\t\t\t\t\telem.body[ \"offset\" + name ], doc[ \"offset\" + name ],\n\t\t\t\t\t\t\t\tdoc[ \"client\" + name ]\n\t\t\t\t\t\t\t);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn value === undefined ?\n\n\t\t\t\t\t\t\t// Get width or height on the element, requesting but not forcing parseFloat\n\t\t\t\t\t\t\tjQuery.css( elem, type, extra ) :\n\n\t\t\t\t\t\t\t// Set width or height on the element\n\t\t\t\t\t\t\tjQuery.style( elem, type, value, extra );\n\t\t\t\t\t}, type, chainable ? margin : undefined, chainable, null );\n\t\t\t\t};\n\t\t\t} );\n\t} );\n\n\n\tjQuery.fn.extend( {\n\n\t\tbind: function( types, data, fn ) {\n\t\t\treturn this.on( types, null, data, fn );\n\t\t},\n\t\tunbind: function( types, fn ) {\n\t\t\treturn this.off( types, null, fn );\n\t\t},\n\n\t\tdelegate: function( selector, types, data, fn ) {\n\t\t\treturn this.on( types, selector, data, fn );\n\t\t},\n\t\tundelegate: function( selector, types, fn ) {\n\n\t\t\t// ( namespace ) or ( selector, types [, fn] )\n\t\t\treturn arguments.length === 1 ?\n\t\t\t\tthis.off( selector, \"**\" ) :\n\t\t\t\tthis.off( types, selector || \"**\", fn );\n\t\t}\n\t} );\n\n// The number of elements contained in the matched element set\n\tjQuery.fn.size = function() {\n\t\treturn this.length;\n\t};\n\n\tjQuery.fn.andSelf = jQuery.fn.addBack;\n\n\n\n\n// Register as a named AMD module, since jQuery can be concatenated with other\n// files that may use define, but not via a proper concatenation script that\n// understands anonymous AMD modules. A named AMD is safest and most robust\n// way to register. Lowercase jquery is used because AMD module names are\n// derived from file names, and jQuery is normally delivered in a lowercase\n// file name. Do this after creating the global so that if an AMD module wants\n// to call noConflict to hide this version of jQuery, it will work.\n\n// Note that for maximum portability, libraries that are not jQuery should\n// declare themselves as anonymous modules, and avoid setting a global if an\n// AMD loader is present. jQuery is a special case. For more information, see\n// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\t\tdefine( \"jquery\", [], function() {\n\t\t\treturn jQuery;\n\t\t} );\n\t}\n\n\n\n\tvar\n\n\t\t// Map over jQuery in case of overwrite\n\t\t_jQuery = window.jQuery,\n\n\t\t// Map over the $ in case of overwrite\n\t\t_$ = window.$;\n\n\tjQuery.noConflict = function( deep ) {\n\t\tif ( window.$ === jQuery ) {\n\t\t\twindow.$ = _$;\n\t\t}\n\n\t\tif ( deep && window.jQuery === jQuery ) {\n\t\t\twindow.jQuery = _jQuery;\n\t\t}\n\n\t\treturn jQuery;\n\t};\n\n// Expose jQuery and $ identifiers, even in\n// AMD (#7102#comment:10, https://github.com/jquery/jquery/pull/557)\n// and CommonJS for browser emulators (#13566)\n\tif ( !noGlobal ) {\n\t\twindow.jQuery = window.$ = jQuery;\n\t}\n\n\treturn jQuery;\n}));","underscore.js":"//     Underscore.js 1.8.2\n//     http://underscorejs.org\n//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors\n//     Underscore may be freely distributed under the MIT license.\n\n(function() {\n\n  // Baseline setup\n  // --------------\n\n  // Establish the root object, `window` in the browser, or `exports` on the server.\n  var root = this;\n\n  // Save the previous value of the `_` variable.\n  var previousUnderscore = root._;\n\n  // Save bytes in the minified (but not gzipped) version:\n  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;\n\n  // Create quick reference variables for speed access to core prototypes.\n  var\n    push             = ArrayProto.push,\n    slice            = ArrayProto.slice,\n    toString         = ObjProto.toString,\n    hasOwnProperty   = ObjProto.hasOwnProperty;\n\n  // All **ECMAScript 5** native function implementations that we hope to use\n  // are declared here.\n  var\n    nativeIsArray      = Array.isArray,\n    nativeKeys         = Object.keys,\n    nativeBind         = FuncProto.bind,\n    nativeCreate       = Object.create;\n\n  // Naked function reference for surrogate-prototype-swapping.\n  var Ctor = function(){};\n\n  // Create a safe reference to the Underscore object for use below.\n  var _ = function(obj) {\n    if (obj instanceof _) return obj;\n    if (!(this instanceof _)) return new _(obj);\n    this._wrapped = obj;\n  };\n\n  // Export the Underscore object for **Node.js**, with\n  // backwards-compatibility for the old `require()` API. If we're in\n  // the browser, add `_` as a global object.\n  if (typeof exports !== 'undefined') {\n    if (typeof module !== 'undefined' && module.exports) {\n      exports = module.exports = _;\n    }\n    exports._ = _;\n  } else {\n    root._ = _;\n  }\n\n  // Current version.\n  _.VERSION = '1.8.2';\n\n  // Internal function that returns an efficient (for current engines) version\n  // of the passed-in callback, to be repeatedly applied in other Underscore\n  // functions.\n  var optimizeCb = function(func, context, argCount) {\n    if (context === void 0) return func;\n    switch (argCount == null ? 3 : argCount) {\n      case 1: return function(value) {\n        return func.call(context, value);\n      };\n      case 2: return function(value, other) {\n        return func.call(context, value, other);\n      };\n      case 3: return function(value, index, collection) {\n        return func.call(context, value, index, collection);\n      };\n      case 4: return function(accumulator, value, index, collection) {\n        return func.call(context, accumulator, value, index, collection);\n      };\n    }\n    return function() {\n      return func.apply(context, arguments);\n    };\n  };\n\n  // A mostly-internal function to generate callbacks that can be applied\n  // to each element in a collection, returning the desired result \u2014 either\n  // identity, an arbitrary callback, a property matcher, or a property accessor.\n  var cb = function(value, context, argCount) {\n    if (value == null) return _.identity;\n    if (_.isFunction(value)) return optimizeCb(value, context, argCount);\n    if (_.isObject(value)) return _.matcher(value);\n    return _.property(value);\n  };\n  _.iteratee = function(value, context) {\n    return cb(value, context, Infinity);\n  };\n\n  // An internal function for creating assigner functions.\n  var createAssigner = function(keysFunc, undefinedOnly) {\n    return function(obj) {\n      var length = arguments.length;\n      if (length < 2 || obj == null) return obj;\n      for (var index = 1; index < length; index++) {\n        var source = arguments[index],\n            keys = keysFunc(source),\n            l = keys.length;\n        for (var i = 0; i < l; i++) {\n          var key = keys[i];\n          if (!undefinedOnly || obj[key] === void 0) obj[key] = source[key];\n        }\n      }\n      return obj;\n    };\n  };\n\n  // An internal function for creating a new object that inherits from another.\n  var baseCreate = function(prototype) {\n    if (!_.isObject(prototype)) return {};\n    if (nativeCreate) return nativeCreate(prototype);\n    Ctor.prototype = prototype;\n    var result = new Ctor;\n    Ctor.prototype = null;\n    return result;\n  };\n\n  // Helper for collection methods to determine whether a collection\n  // should be iterated as an array or as an object\n  // Related: http://people.mozilla.org/~jorendorff/es6-draft.html#sec-tolength\n  var MAX_ARRAY_INDEX = Math.pow(2, 53) - 1;\n  var isArrayLike = function(collection) {\n    var length = collection && collection.length;\n    return typeof length == 'number' && length >= 0 && length <= MAX_ARRAY_INDEX;\n  };\n\n  // Collection Functions\n  // --------------------\n\n  // The cornerstone, an `each` implementation, aka `forEach`.\n  // Handles raw objects in addition to array-likes. Treats all\n  // sparse array-likes as if they were dense.\n  _.each = _.forEach = function(obj, iteratee, context) {\n    iteratee = optimizeCb(iteratee, context);\n    var i, length;\n    if (isArrayLike(obj)) {\n      for (i = 0, length = obj.length; i < length; i++) {\n        iteratee(obj[i], i, obj);\n      }\n    } else {\n      var keys = _.keys(obj);\n      for (i = 0, length = keys.length; i < length; i++) {\n        iteratee(obj[keys[i]], keys[i], obj);\n      }\n    }\n    return obj;\n  };\n\n  // Return the results of applying the iteratee to each element.\n  _.map = _.collect = function(obj, iteratee, context) {\n    iteratee = cb(iteratee, context);\n    var keys = !isArrayLike(obj) && _.keys(obj),\n        length = (keys || obj).length,\n        results = Array(length);\n    for (var index = 0; index < length; index++) {\n      var currentKey = keys ? keys[index] : index;\n      results[index] = iteratee(obj[currentKey], currentKey, obj);\n    }\n    return results;\n  };\n\n  // Create a reducing function iterating left or right.\n  function createReduce(dir) {\n    // Optimized iterator function as using arguments.length\n    // in the main function will deoptimize the, see #1991.\n    function iterator(obj, iteratee, memo, keys, index, length) {\n      for (; index >= 0 && index < length; index += dir) {\n        var currentKey = keys ? keys[index] : index;\n        memo = iteratee(memo, obj[currentKey], currentKey, obj);\n      }\n      return memo;\n    }\n\n    return function(obj, iteratee, memo, context) {\n      iteratee = optimizeCb(iteratee, context, 4);\n      var keys = !isArrayLike(obj) && _.keys(obj),\n          length = (keys || obj).length,\n          index = dir > 0 ? 0 : length - 1;\n      // Determine the initial value if none is provided.\n      if (arguments.length < 3) {\n        memo = obj[keys ? keys[index] : index];\n        index += dir;\n      }\n      return iterator(obj, iteratee, memo, keys, index, length);\n    };\n  }\n\n  // **Reduce** builds up a single result from a list of values, aka `inject`,\n  // or `foldl`.\n  _.reduce = _.foldl = _.inject = createReduce(1);\n\n  // The right-associative version of reduce, also known as `foldr`.\n  _.reduceRight = _.foldr = createReduce(-1);\n\n  // Return the first value which passes a truth test. Aliased as `detect`.\n  _.find = _.detect = function(obj, predicate, context) {\n    var key;\n    if (isArrayLike(obj)) {\n      key = _.findIndex(obj, predicate, context);\n    } else {\n      key = _.findKey(obj, predicate, context);\n    }\n    if (key !== void 0 && key !== -1) return obj[key];\n  };\n\n  // Return all the elements that pass a truth test.\n  // Aliased as `select`.\n  _.filter = _.select = function(obj, predicate, context) {\n    var results = [];\n    predicate = cb(predicate, context);\n    _.each(obj, function(value, index, list) {\n      if (predicate(value, index, list)) results.push(value);\n    });\n    return results;\n  };\n\n  // Return all the elements for which a truth test fails.\n  _.reject = function(obj, predicate, context) {\n    return _.filter(obj, _.negate(cb(predicate)), context);\n  };\n\n  // Determine whether all of the elements match a truth test.\n  // Aliased as `all`.\n  _.every = _.all = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var keys = !isArrayLike(obj) && _.keys(obj),\n        length = (keys || obj).length;\n    for (var index = 0; index < length; index++) {\n      var currentKey = keys ? keys[index] : index;\n      if (!predicate(obj[currentKey], currentKey, obj)) return false;\n    }\n    return true;\n  };\n\n  // Determine if at least one element in the object matches a truth test.\n  // Aliased as `any`.\n  _.some = _.any = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var keys = !isArrayLike(obj) && _.keys(obj),\n        length = (keys || obj).length;\n    for (var index = 0; index < length; index++) {\n      var currentKey = keys ? keys[index] : index;\n      if (predicate(obj[currentKey], currentKey, obj)) return true;\n    }\n    return false;\n  };\n\n  // Determine if the array or object contains a given value (using `===`).\n  // Aliased as `includes` and `include`.\n  _.contains = _.includes = _.include = function(obj, target, fromIndex) {\n    if (!isArrayLike(obj)) obj = _.values(obj);\n    return _.indexOf(obj, target, typeof fromIndex == 'number' && fromIndex) >= 0;\n  };\n\n  // Invoke a method (with arguments) on every item in a collection.\n  _.invoke = function(obj, method) {\n    var args = slice.call(arguments, 2);\n    var isFunc = _.isFunction(method);\n    return _.map(obj, function(value) {\n      var func = isFunc ? method : value[method];\n      return func == null ? func : func.apply(value, args);\n    });\n  };\n\n  // Convenience version of a common use case of `map`: fetching a property.\n  _.pluck = function(obj, key) {\n    return _.map(obj, _.property(key));\n  };\n\n  // Convenience version of a common use case of `filter`: selecting only objects\n  // containing specific `key:value` pairs.\n  _.where = function(obj, attrs) {\n    return _.filter(obj, _.matcher(attrs));\n  };\n\n  // Convenience version of a common use case of `find`: getting the first object\n  // containing specific `key:value` pairs.\n  _.findWhere = function(obj, attrs) {\n    return _.find(obj, _.matcher(attrs));\n  };\n\n  // Return the maximum element (or element-based computation).\n  _.max = function(obj, iteratee, context) {\n    var result = -Infinity, lastComputed = -Infinity,\n        value, computed;\n    if (iteratee == null && obj != null) {\n      obj = isArrayLike(obj) ? obj : _.values(obj);\n      for (var i = 0, length = obj.length; i < length; i++) {\n        value = obj[i];\n        if (value > result) {\n          result = value;\n        }\n      }\n    } else {\n      iteratee = cb(iteratee, context);\n      _.each(obj, function(value, index, list) {\n        computed = iteratee(value, index, list);\n        if (computed > lastComputed || computed === -Infinity && result === -Infinity) {\n          result = value;\n          lastComputed = computed;\n        }\n      });\n    }\n    return result;\n  };\n\n  // Return the minimum element (or element-based computation).\n  _.min = function(obj, iteratee, context) {\n    var result = Infinity, lastComputed = Infinity,\n        value, computed;\n    if (iteratee == null && obj != null) {\n      obj = isArrayLike(obj) ? obj : _.values(obj);\n      for (var i = 0, length = obj.length; i < length; i++) {\n        value = obj[i];\n        if (value < result) {\n          result = value;\n        }\n      }\n    } else {\n      iteratee = cb(iteratee, context);\n      _.each(obj, function(value, index, list) {\n        computed = iteratee(value, index, list);\n        if (computed < lastComputed || computed === Infinity && result === Infinity) {\n          result = value;\n          lastComputed = computed;\n        }\n      });\n    }\n    return result;\n  };\n\n  // Shuffle a collection, using the modern version of the\n  // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher\u2013Yates_shuffle).\n  _.shuffle = function(obj) {\n    var set = isArrayLike(obj) ? obj : _.values(obj);\n    var length = set.length;\n    var shuffled = Array(length);\n    for (var index = 0, rand; index < length; index++) {\n      rand = _.random(0, index);\n      if (rand !== index) shuffled[index] = shuffled[rand];\n      shuffled[rand] = set[index];\n    }\n    return shuffled;\n  };\n\n  // Sample **n** random values from a collection.\n  // If **n** is not specified, returns a single random element.\n  // The internal `guard` argument allows it to work with `map`.\n  _.sample = function(obj, n, guard) {\n    if (n == null || guard) {\n      if (!isArrayLike(obj)) obj = _.values(obj);\n      return obj[_.random(obj.length - 1)];\n    }\n    return _.shuffle(obj).slice(0, Math.max(0, n));\n  };\n\n  // Sort the object's values by a criterion produced by an iteratee.\n  _.sortBy = function(obj, iteratee, context) {\n    iteratee = cb(iteratee, context);\n    return _.pluck(_.map(obj, function(value, index, list) {\n      return {\n        value: value,\n        index: index,\n        criteria: iteratee(value, index, list)\n      };\n    }).sort(function(left, right) {\n      var a = left.criteria;\n      var b = right.criteria;\n      if (a !== b) {\n        if (a > b || a === void 0) return 1;\n        if (a < b || b === void 0) return -1;\n      }\n      return left.index - right.index;\n    }), 'value');\n  };\n\n  // An internal function used for aggregate \"group by\" operations.\n  var group = function(behavior) {\n    return function(obj, iteratee, context) {\n      var result = {};\n      iteratee = cb(iteratee, context);\n      _.each(obj, function(value, index) {\n        var key = iteratee(value, index, obj);\n        behavior(result, value, key);\n      });\n      return result;\n    };\n  };\n\n  // Groups the object's values by a criterion. Pass either a string attribute\n  // to group by, or a function that returns the criterion.\n  _.groupBy = group(function(result, value, key) {\n    if (_.has(result, key)) result[key].push(value); else result[key] = [value];\n  });\n\n  // Indexes the object's values by a criterion, similar to `groupBy`, but for\n  // when you know that your index values will be unique.\n  _.indexBy = group(function(result, value, key) {\n    result[key] = value;\n  });\n\n  // Counts instances of an object that group by a certain criterion. Pass\n  // either a string attribute to count by, or a function that returns the\n  // criterion.\n  _.countBy = group(function(result, value, key) {\n    if (_.has(result, key)) result[key]++; else result[key] = 1;\n  });\n\n  // Safely create a real, live array from anything iterable.\n  _.toArray = function(obj) {\n    if (!obj) return [];\n    if (_.isArray(obj)) return slice.call(obj);\n    if (isArrayLike(obj)) return _.map(obj, _.identity);\n    return _.values(obj);\n  };\n\n  // Return the number of elements in an object.\n  _.size = function(obj) {\n    if (obj == null) return 0;\n    return isArrayLike(obj) ? obj.length : _.keys(obj).length;\n  };\n\n  // Split a collection into two arrays: one whose elements all satisfy the given\n  // predicate, and one whose elements all do not satisfy the predicate.\n  _.partition = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var pass = [], fail = [];\n    _.each(obj, function(value, key, obj) {\n      (predicate(value, key, obj) ? pass : fail).push(value);\n    });\n    return [pass, fail];\n  };\n\n  // Array Functions\n  // ---------------\n\n  // Get the first element of an array. Passing **n** will return the first N\n  // values in the array. Aliased as `head` and `take`. The **guard** check\n  // allows it to work with `_.map`.\n  _.first = _.head = _.take = function(array, n, guard) {\n    if (array == null) return void 0;\n    if (n == null || guard) return array[0];\n    return _.initial(array, array.length - n);\n  };\n\n  // Returns everything but the last entry of the array. Especially useful on\n  // the arguments object. Passing **n** will return all the values in\n  // the array, excluding the last N.\n  _.initial = function(array, n, guard) {\n    return slice.call(array, 0, Math.max(0, array.length - (n == null || guard ? 1 : n)));\n  };\n\n  // Get the last element of an array. Passing **n** will return the last N\n  // values in the array.\n  _.last = function(array, n, guard) {\n    if (array == null) return void 0;\n    if (n == null || guard) return array[array.length - 1];\n    return _.rest(array, Math.max(0, array.length - n));\n  };\n\n  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.\n  // Especially useful on the arguments object. Passing an **n** will return\n  // the rest N values in the array.\n  _.rest = _.tail = _.drop = function(array, n, guard) {\n    return slice.call(array, n == null || guard ? 1 : n);\n  };\n\n  // Trim out all falsy values from an array.\n  _.compact = function(array) {\n    return _.filter(array, _.identity);\n  };\n\n  // Internal implementation of a recursive `flatten` function.\n  var flatten = function(input, shallow, strict, startIndex) {\n    var output = [], idx = 0;\n    for (var i = startIndex || 0, length = input && input.length; i < length; i++) {\n      var value = input[i];\n      if (isArrayLike(value) && (_.isArray(value) || _.isArguments(value))) {\n        //flatten current level of array or arguments object\n        if (!shallow) value = flatten(value, shallow, strict);\n        var j = 0, len = value.length;\n        output.length += len;\n        while (j < len) {\n          output[idx++] = value[j++];\n        }\n      } else if (!strict) {\n        output[idx++] = value;\n      }\n    }\n    return output;\n  };\n\n  // Flatten out an array, either recursively (by default), or just one level.\n  _.flatten = function(array, shallow) {\n    return flatten(array, shallow, false);\n  };\n\n  // Return a version of the array that does not contain the specified value(s).\n  _.without = function(array) {\n    return _.difference(array, slice.call(arguments, 1));\n  };\n\n  // Produce a duplicate-free version of the array. If the array has already\n  // been sorted, you have the option of using a faster algorithm.\n  // Aliased as `unique`.\n  _.uniq = _.unique = function(array, isSorted, iteratee, context) {\n    if (array == null) return [];\n    if (!_.isBoolean(isSorted)) {\n      context = iteratee;\n      iteratee = isSorted;\n      isSorted = false;\n    }\n    if (iteratee != null) iteratee = cb(iteratee, context);\n    var result = [];\n    var seen = [];\n    for (var i = 0, length = array.length; i < length; i++) {\n      var value = array[i],\n          computed = iteratee ? iteratee(value, i, array) : value;\n      if (isSorted) {\n        if (!i || seen !== computed) result.push(value);\n        seen = computed;\n      } else if (iteratee) {\n        if (!_.contains(seen, computed)) {\n          seen.push(computed);\n          result.push(value);\n        }\n      } else if (!_.contains(result, value)) {\n        result.push(value);\n      }\n    }\n    return result;\n  };\n\n  // Produce an array that contains the union: each distinct element from all of\n  // the passed-in arrays.\n  _.union = function() {\n    return _.uniq(flatten(arguments, true, true));\n  };\n\n  // Produce an array that contains every item shared between all the\n  // passed-in arrays.\n  _.intersection = function(array) {\n    if (array == null) return [];\n    var result = [];\n    var argsLength = arguments.length;\n    for (var i = 0, length = array.length; i < length; i++) {\n      var item = array[i];\n      if (_.contains(result, item)) continue;\n      for (var j = 1; j < argsLength; j++) {\n        if (!_.contains(arguments[j], item)) break;\n      }\n      if (j === argsLength) result.push(item);\n    }\n    return result;\n  };\n\n  // Take the difference between one array and a number of other arrays.\n  // Only the elements present in just the first array will remain.\n  _.difference = function(array) {\n    var rest = flatten(arguments, true, true, 1);\n    return _.filter(array, function(value){\n      return !_.contains(rest, value);\n    });\n  };\n\n  // Zip together multiple lists into a single array -- elements that share\n  // an index go together.\n  _.zip = function() {\n    return _.unzip(arguments);\n  };\n\n  // Complement of _.zip. Unzip accepts an array of arrays and groups\n  // each array's elements on shared indices\n  _.unzip = function(array) {\n    var length = array && _.max(array, 'length').length || 0;\n    var result = Array(length);\n\n    for (var index = 0; index < length; index++) {\n      result[index] = _.pluck(array, index);\n    }\n    return result;\n  };\n\n  // Converts lists into objects. Pass either a single array of `[key, value]`\n  // pairs, or two parallel arrays of the same length -- one of keys, and one of\n  // the corresponding values.\n  _.object = function(list, values) {\n    var result = {};\n    for (var i = 0, length = list && list.length; i < length; i++) {\n      if (values) {\n        result[list[i]] = values[i];\n      } else {\n        result[list[i][0]] = list[i][1];\n      }\n    }\n    return result;\n  };\n\n  // Return the position of the first occurrence of an item in an array,\n  // or -1 if the item is not included in the array.\n  // If the array is large and already in sort order, pass `true`\n  // for **isSorted** to use binary search.\n  _.indexOf = function(array, item, isSorted) {\n    var i = 0, length = array && array.length;\n    if (typeof isSorted == 'number') {\n      i = isSorted < 0 ? Math.max(0, length + isSorted) : isSorted;\n    } else if (isSorted && length) {\n      i = _.sortedIndex(array, item);\n      return array[i] === item ? i : -1;\n    }\n    if (item !== item) {\n      return _.findIndex(slice.call(array, i), _.isNaN);\n    }\n    for (; i < length; i++) if (array[i] === item) return i;\n    return -1;\n  };\n\n  _.lastIndexOf = function(array, item, from) {\n    var idx = array ? array.length : 0;\n    if (typeof from == 'number') {\n      idx = from < 0 ? idx + from + 1 : Math.min(idx, from + 1);\n    }\n    if (item !== item) {\n      return _.findLastIndex(slice.call(array, 0, idx), _.isNaN);\n    }\n    while (--idx >= 0) if (array[idx] === item) return idx;\n    return -1;\n  };\n\n  // Generator function to create the findIndex and findLastIndex functions\n  function createIndexFinder(dir) {\n    return function(array, predicate, context) {\n      predicate = cb(predicate, context);\n      var length = array != null && array.length;\n      var index = dir > 0 ? 0 : length - 1;\n      for (; index >= 0 && index < length; index += dir) {\n        if (predicate(array[index], index, array)) return index;\n      }\n      return -1;\n    };\n  }\n\n  // Returns the first index on an array-like that passes a predicate test\n  _.findIndex = createIndexFinder(1);\n\n  _.findLastIndex = createIndexFinder(-1);\n\n  // Use a comparator function to figure out the smallest index at which\n  // an object should be inserted so as to maintain order. Uses binary search.\n  _.sortedIndex = function(array, obj, iteratee, context) {\n    iteratee = cb(iteratee, context, 1);\n    var value = iteratee(obj);\n    var low = 0, high = array.length;\n    while (low < high) {\n      var mid = Math.floor((low + high) / 2);\n      if (iteratee(array[mid]) < value) low = mid + 1; else high = mid;\n    }\n    return low;\n  };\n\n  // Generate an integer Array containing an arithmetic progression. A port of\n  // the native Python `range()` function. See\n  // [the Python documentation](http://docs.python.org/library/functions.html#range).\n  _.range = function(start, stop, step) {\n    if (arguments.length <= 1) {\n      stop = start || 0;\n      start = 0;\n    }\n    step = step || 1;\n\n    var length = Math.max(Math.ceil((stop - start) / step), 0);\n    var range = Array(length);\n\n    for (var idx = 0; idx < length; idx++, start += step) {\n      range[idx] = start;\n    }\n\n    return range;\n  };\n\n  // Function (ahem) Functions\n  // ------------------\n\n  // Determines whether to execute a function as a constructor\n  // or a normal function with the provided arguments\n  var executeBound = function(sourceFunc, boundFunc, context, callingContext, args) {\n    if (!(callingContext instanceof boundFunc)) return sourceFunc.apply(context, args);\n    var self = baseCreate(sourceFunc.prototype);\n    var result = sourceFunc.apply(self, args);\n    if (_.isObject(result)) return result;\n    return self;\n  };\n\n  // Create a function bound to a given object (assigning `this`, and arguments,\n  // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if\n  // available.\n  _.bind = function(func, context) {\n    if (nativeBind && func.bind === nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));\n    if (!_.isFunction(func)) throw new TypeError('Bind must be called on a function');\n    var args = slice.call(arguments, 2);\n    var bound = function() {\n      return executeBound(func, bound, context, this, args.concat(slice.call(arguments)));\n    };\n    return bound;\n  };\n\n  // Partially apply a function by creating a version that has had some of its\n  // arguments pre-filled, without changing its dynamic `this` context. _ acts\n  // as a placeholder, allowing any combination of arguments to be pre-filled.\n  _.partial = function(func) {\n    var boundArgs = slice.call(arguments, 1);\n    var bound = function() {\n      var position = 0, length = boundArgs.length;\n      var args = Array(length);\n      for (var i = 0; i < length; i++) {\n        args[i] = boundArgs[i] === _ ? arguments[position++] : boundArgs[i];\n      }\n      while (position < arguments.length) args.push(arguments[position++]);\n      return executeBound(func, bound, this, this, args);\n    };\n    return bound;\n  };\n\n  // Bind a number of an object's methods to that object. Remaining arguments\n  // are the method names to be bound. Useful for ensuring that all callbacks\n  // defined on an object belong to it.\n  _.bindAll = function(obj) {\n    var i, length = arguments.length, key;\n    if (length <= 1) throw new Error('bindAll must be passed function names');\n    for (i = 1; i < length; i++) {\n      key = arguments[i];\n      obj[key] = _.bind(obj[key], obj);\n    }\n    return obj;\n  };\n\n  // Memoize an expensive function by storing its results.\n  _.memoize = function(func, hasher) {\n    var memoize = function(key) {\n      var cache = memoize.cache;\n      var address = '' + (hasher ? hasher.apply(this, arguments) : key);\n      if (!_.has(cache, address)) cache[address] = func.apply(this, arguments);\n      return cache[address];\n    };\n    memoize.cache = {};\n    return memoize;\n  };\n\n  // Delays a function for the given number of milliseconds, and then calls\n  // it with the arguments supplied.\n  _.delay = function(func, wait) {\n    var args = slice.call(arguments, 2);\n    return setTimeout(function(){\n      return func.apply(null, args);\n    }, wait);\n  };\n\n  // Defers a function, scheduling it to run after the current call stack has\n  // cleared.\n  _.defer = _.partial(_.delay, _, 1);\n\n  // Returns a function, that, when invoked, will only be triggered at most once\n  // during a given window of time. Normally, the throttled function will run\n  // as much as it can, without ever going more than once per `wait` duration;\n  // but if you'd like to disable the execution on the leading edge, pass\n  // `{leading: false}`. To disable execution on the trailing edge, ditto.\n  _.throttle = function(func, wait, options) {\n    var context, args, result;\n    var timeout = null;\n    var previous = 0;\n    if (!options) options = {};\n    var later = function() {\n      previous = options.leading === false ? 0 : _.now();\n      timeout = null;\n      result = func.apply(context, args);\n      if (!timeout) context = args = null;\n    };\n    return function() {\n      var now = _.now();\n      if (!previous && options.leading === false) previous = now;\n      var remaining = wait - (now - previous);\n      context = this;\n      args = arguments;\n      if (remaining <= 0 || remaining > wait) {\n        if (timeout) {\n          clearTimeout(timeout);\n          timeout = null;\n        }\n        previous = now;\n        result = func.apply(context, args);\n        if (!timeout) context = args = null;\n      } else if (!timeout && options.trailing !== false) {\n        timeout = setTimeout(later, remaining);\n      }\n      return result;\n    };\n  };\n\n  // Returns a function, that, as long as it continues to be invoked, will not\n  // be triggered. The function will be called after it stops being called for\n  // N milliseconds. If `immediate` is passed, trigger the function on the\n  // leading edge, instead of the trailing.\n  _.debounce = function(func, wait, immediate) {\n    var timeout, args, context, timestamp, result;\n\n    var later = function() {\n      var last = _.now() - timestamp;\n\n      if (last < wait && last >= 0) {\n        timeout = setTimeout(later, wait - last);\n      } else {\n        timeout = null;\n        if (!immediate) {\n          result = func.apply(context, args);\n          if (!timeout) context = args = null;\n        }\n      }\n    };\n\n    return function() {\n      context = this;\n      args = arguments;\n      timestamp = _.now();\n      var callNow = immediate && !timeout;\n      if (!timeout) timeout = setTimeout(later, wait);\n      if (callNow) {\n        result = func.apply(context, args);\n        context = args = null;\n      }\n\n      return result;\n    };\n  };\n\n  // Returns the first function passed as an argument to the second,\n  // allowing you to adjust arguments, run code before and after, and\n  // conditionally execute the original function.\n  _.wrap = function(func, wrapper) {\n    return _.partial(wrapper, func);\n  };\n\n  // Returns a negated version of the passed-in predicate.\n  _.negate = function(predicate) {\n    return function() {\n      return !predicate.apply(this, arguments);\n    };\n  };\n\n  // Returns a function that is the composition of a list of functions, each\n  // consuming the return value of the function that follows.\n  _.compose = function() {\n    var args = arguments;\n    var start = args.length - 1;\n    return function() {\n      var i = start;\n      var result = args[start].apply(this, arguments);\n      while (i--) result = args[i].call(this, result);\n      return result;\n    };\n  };\n\n  // Returns a function that will only be executed on and after the Nth call.\n  _.after = function(times, func) {\n    return function() {\n      if (--times < 1) {\n        return func.apply(this, arguments);\n      }\n    };\n  };\n\n  // Returns a function that will only be executed up to (but not including) the Nth call.\n  _.before = function(times, func) {\n    var memo;\n    return function() {\n      if (--times > 0) {\n        memo = func.apply(this, arguments);\n      }\n      if (times <= 1) func = null;\n      return memo;\n    };\n  };\n\n  // Returns a function that will be executed at most one time, no matter how\n  // often you call it. Useful for lazy initialization.\n  _.once = _.partial(_.before, 2);\n\n  // Object Functions\n  // ----------------\n\n  // Keys in IE < 9 that won't be iterated by `for key in ...` and thus missed.\n  var hasEnumBug = !{toString: null}.propertyIsEnumerable('toString');\n  var nonEnumerableProps = ['valueOf', 'isPrototypeOf', 'toString',\n                      'propertyIsEnumerable', 'hasOwnProperty', 'toLocaleString'];\n\n  function collectNonEnumProps(obj, keys) {\n    var nonEnumIdx = nonEnumerableProps.length;\n    var constructor = obj.constructor;\n    var proto = (_.isFunction(constructor) && constructor.prototype) || ObjProto;\n\n    // Constructor is a special case.\n    var prop = 'constructor';\n    if (_.has(obj, prop) && !_.contains(keys, prop)) keys.push(prop);\n\n    while (nonEnumIdx--) {\n      prop = nonEnumerableProps[nonEnumIdx];\n      if (prop in obj && obj[prop] !== proto[prop] && !_.contains(keys, prop)) {\n        keys.push(prop);\n      }\n    }\n  }\n\n  // Retrieve the names of an object's own properties.\n  // Delegates to **ECMAScript 5**'s native `Object.keys`\n  _.keys = function(obj) {\n    if (!_.isObject(obj)) return [];\n    if (nativeKeys) return nativeKeys(obj);\n    var keys = [];\n    for (var key in obj) if (_.has(obj, key)) keys.push(key);\n    // Ahem, IE < 9.\n    if (hasEnumBug) collectNonEnumProps(obj, keys);\n    return keys;\n  };\n\n  // Retrieve all the property names of an object.\n  _.allKeys = function(obj) {\n    if (!_.isObject(obj)) return [];\n    var keys = [];\n    for (var key in obj) keys.push(key);\n    // Ahem, IE < 9.\n    if (hasEnumBug) collectNonEnumProps(obj, keys);\n    return keys;\n  };\n\n  // Retrieve the values of an object's properties.\n  _.values = function(obj) {\n    var keys = _.keys(obj);\n    var length = keys.length;\n    var values = Array(length);\n    for (var i = 0; i < length; i++) {\n      values[i] = obj[keys[i]];\n    }\n    return values;\n  };\n\n  // Returns the results of applying the iteratee to each element of the object\n  // In contrast to _.map it returns an object\n  _.mapObject = function(obj, iteratee, context) {\n    iteratee = cb(iteratee, context);\n    var keys =  _.keys(obj),\n          length = keys.length,\n          results = {},\n          currentKey;\n      for (var index = 0; index < length; index++) {\n        currentKey = keys[index];\n        results[currentKey] = iteratee(obj[currentKey], currentKey, obj);\n      }\n      return results;\n  };\n\n  // Convert an object into a list of `[key, value]` pairs.\n  _.pairs = function(obj) {\n    var keys = _.keys(obj);\n    var length = keys.length;\n    var pairs = Array(length);\n    for (var i = 0; i < length; i++) {\n      pairs[i] = [keys[i], obj[keys[i]]];\n    }\n    return pairs;\n  };\n\n  // Invert the keys and values of an object. The values must be serializable.\n  _.invert = function(obj) {\n    var result = {};\n    var keys = _.keys(obj);\n    for (var i = 0, length = keys.length; i < length; i++) {\n      result[obj[keys[i]]] = keys[i];\n    }\n    return result;\n  };\n\n  // Return a sorted list of the function names available on the object.\n  // Aliased as `methods`\n  _.functions = _.methods = function(obj) {\n    var names = [];\n    for (var key in obj) {\n      if (_.isFunction(obj[key])) names.push(key);\n    }\n    return names.sort();\n  };\n\n  // Extend a given object with all the properties in passed-in object(s).\n  _.extend = createAssigner(_.allKeys);\n\n  // Assigns a given object with all the own properties in the passed-in object(s)\n  // (https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/assign)\n  _.extendOwn = _.assign = createAssigner(_.keys);\n\n  // Returns the first key on an object that passes a predicate test\n  _.findKey = function(obj, predicate, context) {\n    predicate = cb(predicate, context);\n    var keys = _.keys(obj), key;\n    for (var i = 0, length = keys.length; i < length; i++) {\n      key = keys[i];\n      if (predicate(obj[key], key, obj)) return key;\n    }\n  };\n\n  // Return a copy of the object only containing the whitelisted properties.\n  _.pick = function(object, oiteratee, context) {\n    var result = {}, obj = object, iteratee, keys;\n    if (obj == null) return result;\n    if (_.isFunction(oiteratee)) {\n      keys = _.allKeys(obj);\n      iteratee = optimizeCb(oiteratee, context);\n    } else {\n      keys = flatten(arguments, false, false, 1);\n      iteratee = function(value, key, obj) { return key in obj; };\n      obj = Object(obj);\n    }\n    for (var i = 0, length = keys.length; i < length; i++) {\n      var key = keys[i];\n      var value = obj[key];\n      if (iteratee(value, key, obj)) result[key] = value;\n    }\n    return result;\n  };\n\n   // Return a copy of the object without the blacklisted properties.\n  _.omit = function(obj, iteratee, context) {\n    if (_.isFunction(iteratee)) {\n      iteratee = _.negate(iteratee);\n    } else {\n      var keys = _.map(flatten(arguments, false, false, 1), String);\n      iteratee = function(value, key) {\n        return !_.contains(keys, key);\n      };\n    }\n    return _.pick(obj, iteratee, context);\n  };\n\n  // Fill in a given object with default properties.\n  _.defaults = createAssigner(_.allKeys, true);\n\n  // Create a (shallow-cloned) duplicate of an object.\n  _.clone = function(obj) {\n    if (!_.isObject(obj)) return obj;\n    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);\n  };\n\n  // Invokes interceptor with the obj, and then returns obj.\n  // The primary purpose of this method is to \"tap into\" a method chain, in\n  // order to perform operations on intermediate results within the chain.\n  _.tap = function(obj, interceptor) {\n    interceptor(obj);\n    return obj;\n  };\n\n  // Returns whether an object has a given set of `key:value` pairs.\n  _.isMatch = function(object, attrs) {\n    var keys = _.keys(attrs), length = keys.length;\n    if (object == null) return !length;\n    var obj = Object(object);\n    for (var i = 0; i < length; i++) {\n      var key = keys[i];\n      if (attrs[key] !== obj[key] || !(key in obj)) return false;\n    }\n    return true;\n  };\n\n\n  // Internal recursive comparison function for `isEqual`.\n  var eq = function(a, b, aStack, bStack) {\n    // Identical objects are equal. `0 === -0`, but they aren't identical.\n    // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).\n    if (a === b) return a !== 0 || 1 / a === 1 / b;\n    // A strict comparison is necessary because `null == undefined`.\n    if (a == null || b == null) return a === b;\n    // Unwrap any wrapped objects.\n    if (a instanceof _) a = a._wrapped;\n    if (b instanceof _) b = b._wrapped;\n    // Compare `[[Class]]` names.\n    var className = toString.call(a);\n    if (className !== toString.call(b)) return false;\n    switch (className) {\n      // Strings, numbers, regular expressions, dates, and booleans are compared by value.\n      case '[object RegExp]':\n      // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')\n      case '[object String]':\n        // Primitives and their corresponding object wrappers are equivalent; thus, `\"5\"` is\n        // equivalent to `new String(\"5\")`.\n        return '' + a === '' + b;\n      case '[object Number]':\n        // `NaN`s are equivalent, but non-reflexive.\n        // Object(NaN) is equivalent to NaN\n        if (+a !== +a) return +b !== +b;\n        // An `egal` comparison is performed for other numeric values.\n        return +a === 0 ? 1 / +a === 1 / b : +a === +b;\n      case '[object Date]':\n      case '[object Boolean]':\n        // Coerce dates and booleans to numeric primitive values. Dates are compared by their\n        // millisecond representations. Note that invalid dates with millisecond representations\n        // of `NaN` are not equivalent.\n        return +a === +b;\n    }\n\n    var areArrays = className === '[object Array]';\n    if (!areArrays) {\n      if (typeof a != 'object' || typeof b != 'object') return false;\n\n      // Objects with different constructors are not equivalent, but `Object`s or `Array`s\n      // from different frames are.\n      var aCtor = a.constructor, bCtor = b.constructor;\n      if (aCtor !== bCtor && !(_.isFunction(aCtor) && aCtor instanceof aCtor &&\n                               _.isFunction(bCtor) && bCtor instanceof bCtor)\n                          && ('constructor' in a && 'constructor' in b)) {\n        return false;\n      }\n    }\n    // Assume equality for cyclic structures. The algorithm for detecting cyclic\n    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.\n    \n    // Initializing stack of traversed objects.\n    // It's done here since we only need them for objects and arrays comparison.\n    aStack = aStack || [];\n    bStack = bStack || [];\n    var length = aStack.length;\n    while (length--) {\n      // Linear search. Performance is inversely proportional to the number of\n      // unique nested structures.\n      if (aStack[length] === a) return bStack[length] === b;\n    }\n\n    // Add the first object to the stack of traversed objects.\n    aStack.push(a);\n    bStack.push(b);\n\n    // Recursively compare objects and arrays.\n    if (areArrays) {\n      // Compare array lengths to determine if a deep comparison is necessary.\n      length = a.length;\n      if (length !== b.length) return false;\n      // Deep compare the contents, ignoring non-numeric properties.\n      while (length--) {\n        if (!eq(a[length], b[length], aStack, bStack)) return false;\n      }\n    } else {\n      // Deep compare objects.\n      var keys = _.keys(a), key;\n      length = keys.length;\n      // Ensure that both objects contain the same number of properties before comparing deep equality.\n      if (_.keys(b).length !== length) return false;\n      while (length--) {\n        // Deep compare each member\n        key = keys[length];\n        if (!(_.has(b, key) && eq(a[key], b[key], aStack, bStack))) return false;\n      }\n    }\n    // Remove the first object from the stack of traversed objects.\n    aStack.pop();\n    bStack.pop();\n    return true;\n  };\n\n  // Perform a deep comparison to check if two objects are equal.\n  _.isEqual = function(a, b) {\n    return eq(a, b);\n  };\n\n  // Is a given array, string, or object empty?\n  // An \"empty\" object has no enumerable own-properties.\n  _.isEmpty = function(obj) {\n    if (obj == null) return true;\n    if (isArrayLike(obj) && (_.isArray(obj) || _.isString(obj) || _.isArguments(obj))) return obj.length === 0;\n    return _.keys(obj).length === 0;\n  };\n\n  // Is a given value a DOM element?\n  _.isElement = function(obj) {\n    return !!(obj && obj.nodeType === 1);\n  };\n\n  // Is a given value an array?\n  // Delegates to ECMA5's native Array.isArray\n  _.isArray = nativeIsArray || function(obj) {\n    return toString.call(obj) === '[object Array]';\n  };\n\n  // Is a given variable an object?\n  _.isObject = function(obj) {\n    var type = typeof obj;\n    return type === 'function' || type === 'object' && !!obj;\n  };\n\n  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp, isError.\n  _.each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp', 'Error'], function(name) {\n    _['is' + name] = function(obj) {\n      return toString.call(obj) === '[object ' + name + ']';\n    };\n  });\n\n  // Define a fallback version of the method in browsers (ahem, IE < 9), where\n  // there isn't any inspectable \"Arguments\" type.\n  if (!_.isArguments(arguments)) {\n    _.isArguments = function(obj) {\n      return _.has(obj, 'callee');\n    };\n  }\n\n  // Optimize `isFunction` if appropriate. Work around some typeof bugs in old v8,\n  // IE 11 (#1621), and in Safari 8 (#1929).\n  if (typeof /./ != 'function' && typeof Int8Array != 'object') {\n    _.isFunction = function(obj) {\n      return typeof obj == 'function' || false;\n    };\n  }\n\n  // Is a given object a finite number?\n  _.isFinite = function(obj) {\n    return isFinite(obj) && !isNaN(parseFloat(obj));\n  };\n\n  // Is the given value `NaN`? (NaN is the only number which does not equal itself).\n  _.isNaN = function(obj) {\n    return _.isNumber(obj) && obj !== +obj;\n  };\n\n  // Is a given value a boolean?\n  _.isBoolean = function(obj) {\n    return obj === true || obj === false || toString.call(obj) === '[object Boolean]';\n  };\n\n  // Is a given value equal to null?\n  _.isNull = function(obj) {\n    return obj === null;\n  };\n\n  // Is a given variable undefined?\n  _.isUndefined = function(obj) {\n    return obj === void 0;\n  };\n\n  // Shortcut function for checking if an object has a given property directly\n  // on itself (in other words, not on a prototype).\n  _.has = function(obj, key) {\n    return obj != null && hasOwnProperty.call(obj, key);\n  };\n\n  // Utility Functions\n  // -----------------\n\n  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its\n  // previous owner. Returns a reference to the Underscore object.\n  _.noConflict = function() {\n    root._ = previousUnderscore;\n    return this;\n  };\n\n  // Keep the identity function around for default iteratees.\n  _.identity = function(value) {\n    return value;\n  };\n\n  // Predicate-generating functions. Often useful outside of Underscore.\n  _.constant = function(value) {\n    return function() {\n      return value;\n    };\n  };\n\n  _.noop = function(){};\n\n  _.property = function(key) {\n    return function(obj) {\n      return obj == null ? void 0 : obj[key];\n    };\n  };\n\n  // Generates a function for a given object that returns a given property.\n  _.propertyOf = function(obj) {\n    return obj == null ? function(){} : function(key) {\n      return obj[key];\n    };\n  };\n\n  // Returns a predicate for checking whether an object has a given set of \n  // `key:value` pairs.\n  _.matcher = _.matches = function(attrs) {\n    attrs = _.extendOwn({}, attrs);\n    return function(obj) {\n      return _.isMatch(obj, attrs);\n    };\n  };\n\n  // Run a function **n** times.\n  _.times = function(n, iteratee, context) {\n    var accum = Array(Math.max(0, n));\n    iteratee = optimizeCb(iteratee, context, 1);\n    for (var i = 0; i < n; i++) accum[i] = iteratee(i);\n    return accum;\n  };\n\n  // Return a random integer between min and max (inclusive).\n  _.random = function(min, max) {\n    if (max == null) {\n      max = min;\n      min = 0;\n    }\n    return min + Math.floor(Math.random() * (max - min + 1));\n  };\n\n  // A (possibly faster) way to get the current timestamp as an integer.\n  _.now = Date.now || function() {\n    return new Date().getTime();\n  };\n\n   // List of HTML entities for escaping.\n  var escapeMap = {\n    '&': '&amp;',\n    '<': '&lt;',\n    '>': '&gt;',\n    '\"': '&quot;',\n    \"'\": '&#x27;',\n    '`': '&#x60;'\n  };\n  var unescapeMap = _.invert(escapeMap);\n\n  // Functions for escaping and unescaping strings to/from HTML interpolation.\n  var createEscaper = function(map) {\n    var escaper = function(match) {\n      return map[match];\n    };\n    // Regexes for identifying a key that needs to be escaped\n    var source = '(?:' + _.keys(map).join('|') + ')';\n    var testRegexp = RegExp(source);\n    var replaceRegexp = RegExp(source, 'g');\n    return function(string) {\n      string = string == null ? '' : '' + string;\n      return testRegexp.test(string) ? string.replace(replaceRegexp, escaper) : string;\n    };\n  };\n  _.escape = createEscaper(escapeMap);\n  _.unescape = createEscaper(unescapeMap);\n\n  // If the value of the named `property` is a function then invoke it with the\n  // `object` as context; otherwise, return it.\n  _.result = function(object, property, fallback) {\n    var value = object == null ? void 0 : object[property];\n    if (value === void 0) {\n      value = fallback;\n    }\n    return _.isFunction(value) ? value.call(object) : value;\n  };\n\n  // Generate a unique integer id (unique within the entire client session).\n  // Useful for temporary DOM ids.\n  var idCounter = 0;\n  _.uniqueId = function(prefix) {\n    var id = ++idCounter + '';\n    return prefix ? prefix + id : id;\n  };\n\n  // By default, Underscore uses ERB-style template delimiters, change the\n  // following template settings to use alternative delimiters.\n  _.templateSettings = {\n    evaluate    : /<%([\\s\\S]+?)%>/g,\n    interpolate : /<%=([\\s\\S]+?)%>/g,\n    escape      : /<%-([\\s\\S]+?)%>/g\n  };\n\n  // When customizing `templateSettings`, if you don't want to define an\n  // interpolation, evaluation or escaping regex, we need one that is\n  // guaranteed not to match.\n  var noMatch = /(.)^/;\n\n  // Certain characters need to be escaped so that they can be put into a\n  // string literal.\n  var escapes = {\n    \"'\":      \"'\",\n    '\\\\':     '\\\\',\n    '\\r':     'r',\n    '\\n':     'n',\n    '\\u2028': 'u2028',\n    '\\u2029': 'u2029'\n  };\n\n  var escaper = /\\\\|'|\\r|\\n|\\u2028|\\u2029/g;\n\n  var escapeChar = function(match) {\n    return '\\\\' + escapes[match];\n  };\n\n  // JavaScript micro-templating, similar to John Resig's implementation.\n  // Underscore templating handles arbitrary delimiters, preserves whitespace,\n  // and correctly escapes quotes within interpolated code.\n  // NB: `oldSettings` only exists for backwards compatibility.\n  _.template = function(text, settings, oldSettings) {\n    if (!settings && oldSettings) settings = oldSettings;\n    settings = _.defaults({}, settings, _.templateSettings);\n\n    // Combine delimiters into one regular expression via alternation.\n    var matcher = RegExp([\n      (settings.escape || noMatch).source,\n      (settings.interpolate || noMatch).source,\n      (settings.evaluate || noMatch).source\n    ].join('|') + '|$', 'g');\n\n    // Compile the template source, escaping string literals appropriately.\n    var index = 0;\n    var source = \"__p+='\";\n    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {\n      source += text.slice(index, offset).replace(escaper, escapeChar);\n      index = offset + match.length;\n\n      if (escape) {\n        source += \"'+\\n((__t=(\" + escape + \"))==null?'':_.escape(__t))+\\n'\";\n      } else if (interpolate) {\n        source += \"'+\\n((__t=(\" + interpolate + \"))==null?'':__t)+\\n'\";\n      } else if (evaluate) {\n        source += \"';\\n\" + evaluate + \"\\n__p+='\";\n      }\n\n      // Adobe VMs need the match returned to produce the correct offest.\n      return match;\n    });\n    source += \"';\\n\";\n\n    // If a variable is not specified, place data values in local scope.\n    if (!settings.variable) source = 'with(obj||{}){\\n' + source + '}\\n';\n\n    source = \"var __t,__p='',__j=Array.prototype.join,\" +\n      \"print=function(){__p+=__j.call(arguments,'');};\\n\" +\n      source + 'return __p;\\n';\n\n    try {\n      var render = new Function(settings.variable || 'obj', '_', source);\n    } catch (e) {\n      e.source = source;\n      throw e;\n    }\n\n    var template = function(data) {\n      return render.call(this, data, _);\n    };\n\n    // Provide the compiled source as a convenience for precompilation.\n    var argument = settings.variable || 'obj';\n    template.source = 'function(' + argument + '){\\n' + source + '}';\n\n    return template;\n  };\n\n  // Add a \"chain\" function. Start chaining a wrapped Underscore object.\n  _.chain = function(obj) {\n    var instance = _(obj);\n    instance._chain = true;\n    return instance;\n  };\n\n  // OOP\n  // ---------------\n  // If Underscore is called as a function, it returns a wrapped object that\n  // can be used OO-style. This wrapper holds altered versions of all the\n  // underscore functions. Wrapped objects may be chained.\n\n  // Helper function to continue chaining intermediate results.\n  var result = function(instance, obj) {\n    return instance._chain ? _(obj).chain() : obj;\n  };\n\n  // Add your own custom functions to the Underscore object.\n  _.mixin = function(obj) {\n    _.each(_.functions(obj), function(name) {\n      var func = _[name] = obj[name];\n      _.prototype[name] = function() {\n        var args = [this._wrapped];\n        push.apply(args, arguments);\n        return result(this, func.apply(_, args));\n      };\n    });\n  };\n\n  // Add all of the Underscore functions to the wrapper object.\n  _.mixin(_);\n\n  // Add all mutator Array functions to the wrapper.\n  _.each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {\n    var method = ArrayProto[name];\n    _.prototype[name] = function() {\n      var obj = this._wrapped;\n      method.apply(obj, arguments);\n      if ((name === 'shift' || name === 'splice') && obj.length === 0) delete obj[0];\n      return result(this, obj);\n    };\n  });\n\n  // Add all accessor Array functions to the wrapper.\n  _.each(['concat', 'join', 'slice'], function(name) {\n    var method = ArrayProto[name];\n    _.prototype[name] = function() {\n      return result(this, method.apply(this._wrapped, arguments));\n    };\n  });\n\n  // Extracts the result from a wrapped and chained object.\n  _.prototype.value = function() {\n    return this._wrapped;\n  };\n\n  // Provide unwrapping proxy for some methods used in engine operations\n  // such as arithmetic and JSON stringification.\n  _.prototype.valueOf = _.prototype.toJSON = _.prototype.value;\n  \n  _.prototype.toString = function() {\n    return '' + this._wrapped;\n  };\n\n  // AMD registration happens at the end for compatibility with AMD loaders\n  // that may not enforce next-turn semantics on modules. Even though general\n  // practice for AMD registration is to be anonymous, underscore registers\n  // as a named module because, like jQuery, it is a base library that is\n  // popular enough to be bundled in a third party lib, but not be part of\n  // an AMD load request. Those cases could generate an error when an\n  // anonymous define() is called outside of a loader request.\n  if (typeof define === 'function' && define.amd) {\n    define('underscore', [], function() {\n      return _;\n    });\n  }\n}.call(this));","moment.js":"//! moment.js\n//! version : 2.17.1\n//! authors : Tim Wood, Iskren Chernev, Moment.js contributors\n//! license : MIT\n//! momentjs.com\n!function(a,b){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=b():\"function\"==typeof define&&define.amd?define(b):a.moment=b()}(this,function(){\"use strict\";function a(){return od.apply(null,arguments)}\n// This is done to register the method called with moment()\n// without creating circular dependencies.\n    function b(a){od=a}function c(a){return a instanceof Array||\"[object Array]\"===Object.prototype.toString.call(a)}function d(a){\n// IE8 will treat undefined and null as object if it wasn't for\n// input != null\n        return null!=a&&\"[object Object]\"===Object.prototype.toString.call(a)}function e(a){var b;for(b in a)\n// even if its not own property I'd still call it non-empty\n        return!1;return!0}function f(a){return\"number\"==typeof a||\"[object Number]\"===Object.prototype.toString.call(a)}function g(a){return a instanceof Date||\"[object Date]\"===Object.prototype.toString.call(a)}function h(a,b){var c,d=[];for(c=0;c<a.length;++c)d.push(b(a[c],c));return d}function i(a,b){return Object.prototype.hasOwnProperty.call(a,b)}function j(a,b){for(var c in b)i(b,c)&&(a[c]=b[c]);return i(b,\"toString\")&&(a.toString=b.toString),i(b,\"valueOf\")&&(a.valueOf=b.valueOf),a}function k(a,b,c,d){return rb(a,b,c,d,!0).utc()}function l(){\n// We need to deep clone this object.\n        return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null}}function m(a){return null==a._pf&&(a._pf=l()),a._pf}function n(a){if(null==a._isValid){var b=m(a),c=qd.call(b.parsedDateParts,function(a){return null!=a}),d=!isNaN(a._d.getTime())&&b.overflow<0&&!b.empty&&!b.invalidMonth&&!b.invalidWeekday&&!b.nullInput&&!b.invalidFormat&&!b.userInvalidated&&(!b.meridiem||b.meridiem&&c);if(a._strict&&(d=d&&0===b.charsLeftOver&&0===b.unusedTokens.length&&void 0===b.bigHour),null!=Object.isFrozen&&Object.isFrozen(a))return d;a._isValid=d}return a._isValid}function o(a){var b=k(NaN);return null!=a?j(m(b),a):m(b).userInvalidated=!0,b}function p(a){return void 0===a}function q(a,b){var c,d,e;if(p(b._isAMomentObject)||(a._isAMomentObject=b._isAMomentObject),p(b._i)||(a._i=b._i),p(b._f)||(a._f=b._f),p(b._l)||(a._l=b._l),p(b._strict)||(a._strict=b._strict),p(b._tzm)||(a._tzm=b._tzm),p(b._isUTC)||(a._isUTC=b._isUTC),p(b._offset)||(a._offset=b._offset),p(b._pf)||(a._pf=m(b)),p(b._locale)||(a._locale=b._locale),rd.length>0)for(c in rd)d=rd[c],e=b[d],p(e)||(a[d]=e);return a}\n// Moment prototype object\n    function r(b){q(this,b),this._d=new Date(null!=b._d?b._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),\n// Prevent infinite loop in case updateOffset creates new moment\n// objects.\n    sd===!1&&(sd=!0,a.updateOffset(this),sd=!1)}function s(a){return a instanceof r||null!=a&&null!=a._isAMomentObject}function t(a){return a<0?Math.ceil(a)||0:Math.floor(a)}function u(a){var b=+a,c=0;return 0!==b&&isFinite(b)&&(c=t(b)),c}\n// compare two arrays, return the number of differences\n    function v(a,b,c){var d,e=Math.min(a.length,b.length),f=Math.abs(a.length-b.length),g=0;for(d=0;d<e;d++)(c&&a[d]!==b[d]||!c&&u(a[d])!==u(b[d]))&&g++;return g+f}function w(b){a.suppressDeprecationWarnings===!1&&\"undefined\"!=typeof console&&console.warn&&console.warn(\"Deprecation warning: \"+b)}function x(b,c){var d=!0;return j(function(){if(null!=a.deprecationHandler&&a.deprecationHandler(null,b),d){for(var e,f=[],g=0;g<arguments.length;g++){if(e=\"\",\"object\"==typeof arguments[g]){e+=\"\\n[\"+g+\"] \";for(var h in arguments[0])e+=h+\": \"+arguments[0][h]+\", \";e=e.slice(0,-2)}else e=arguments[g];f.push(e)}w(b+\"\\nArguments: \"+Array.prototype.slice.call(f).join(\"\")+\"\\n\"+(new Error).stack),d=!1}return c.apply(this,arguments)},c)}function y(b,c){null!=a.deprecationHandler&&a.deprecationHandler(b,c),td[b]||(w(c),td[b]=!0)}function z(a){return a instanceof Function||\"[object Function]\"===Object.prototype.toString.call(a)}function A(a){var b,c;for(c in a)b=a[c],z(b)?this[c]=b:this[\"_\"+c]=b;this._config=a,\n// Lenient ordinal parsing accepts just a number in addition to\n// number + (possibly) stuff coming from _ordinalParseLenient.\n        this._ordinalParseLenient=new RegExp(this._ordinalParse.source+\"|\"+/\\d{1,2}/.source)}function B(a,b){var c,e=j({},a);for(c in b)i(b,c)&&(d(a[c])&&d(b[c])?(e[c]={},j(e[c],a[c]),j(e[c],b[c])):null!=b[c]?e[c]=b[c]:delete e[c]);for(c in a)i(a,c)&&!i(b,c)&&d(a[c])&&(\n// make sure changes to properties don't modify parent config\n        e[c]=j({},e[c]));return e}function C(a){null!=a&&this.set(a)}function D(a,b,c){var d=this._calendar[a]||this._calendar.sameElse;return z(d)?d.call(b,c):d}function E(a){var b=this._longDateFormat[a],c=this._longDateFormat[a.toUpperCase()];return b||!c?b:(this._longDateFormat[a]=c.replace(/MMMM|MM|DD|dddd/g,function(a){return a.slice(1)}),this._longDateFormat[a])}function F(){return this._invalidDate}function G(a){return this._ordinal.replace(\"%d\",a)}function H(a,b,c,d){var e=this._relativeTime[c];return z(e)?e(a,b,c,d):e.replace(/%d/i,a)}function I(a,b){var c=this._relativeTime[a>0?\"future\":\"past\"];return z(c)?c(b):c.replace(/%s/i,b)}function J(a,b){var c=a.toLowerCase();Dd[c]=Dd[c+\"s\"]=Dd[b]=a}function K(a){return\"string\"==typeof a?Dd[a]||Dd[a.toLowerCase()]:void 0}function L(a){var b,c,d={};for(c in a)i(a,c)&&(b=K(c),b&&(d[b]=a[c]));return d}function M(a,b){Ed[a]=b}function N(a){var b=[];for(var c in a)b.push({unit:c,priority:Ed[c]});return b.sort(function(a,b){return a.priority-b.priority}),b}function O(b,c){return function(d){return null!=d?(Q(this,b,d),a.updateOffset(this,c),this):P(this,b)}}function P(a,b){return a.isValid()?a._d[\"get\"+(a._isUTC?\"UTC\":\"\")+b]():NaN}function Q(a,b,c){a.isValid()&&a._d[\"set\"+(a._isUTC?\"UTC\":\"\")+b](c)}\n// MOMENTS\n    function R(a){return a=K(a),z(this[a])?this[a]():this}function S(a,b){if(\"object\"==typeof a){a=L(a);for(var c=N(a),d=0;d<c.length;d++)this[c[d].unit](a[c[d].unit])}else if(a=K(a),z(this[a]))return this[a](b);return this}function T(a,b,c){var d=\"\"+Math.abs(a),e=b-d.length,f=a>=0;return(f?c?\"+\":\"\":\"-\")+Math.pow(10,Math.max(0,e)).toString().substr(1)+d}\n// token:    'M'\n// padded:   ['MM', 2]\n// ordinal:  'Mo'\n// callback: function () { this.month() + 1 }\n    function U(a,b,c,d){var e=d;\"string\"==typeof d&&(e=function(){return this[d]()}),a&&(Id[a]=e),b&&(Id[b[0]]=function(){return T(e.apply(this,arguments),b[1],b[2])}),c&&(Id[c]=function(){return this.localeData().ordinal(e.apply(this,arguments),a)})}function V(a){return a.match(/\\[[\\s\\S]/)?a.replace(/^\\[|\\]$/g,\"\"):a.replace(/\\\\/g,\"\")}function W(a){var b,c,d=a.match(Fd);for(b=0,c=d.length;b<c;b++)Id[d[b]]?d[b]=Id[d[b]]:d[b]=V(d[b]);return function(b){var e,f=\"\";for(e=0;e<c;e++)f+=d[e]instanceof Function?d[e].call(b,a):d[e];return f}}\n// format date using native date object\n    function X(a,b){return a.isValid()?(b=Y(b,a.localeData()),Hd[b]=Hd[b]||W(b),Hd[b](a)):a.localeData().invalidDate()}function Y(a,b){function c(a){return b.longDateFormat(a)||a}var d=5;for(Gd.lastIndex=0;d>=0&&Gd.test(a);)a=a.replace(Gd,c),Gd.lastIndex=0,d-=1;return a}function Z(a,b,c){$d[a]=z(b)?b:function(a,d){return a&&c?c:b}}function $(a,b){return i($d,a)?$d[a](b._strict,b._locale):new RegExp(_(a))}\n// Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript\n    function _(a){return aa(a.replace(\"\\\\\",\"\").replace(/\\\\(\\[)|\\\\(\\])|\\[([^\\]\\[]*)\\]|\\\\(.)/g,function(a,b,c,d,e){return b||c||d||e}))}function aa(a){return a.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g,\"\\\\$&\")}function ba(a,b){var c,d=b;for(\"string\"==typeof a&&(a=[a]),f(b)&&(d=function(a,c){c[b]=u(a)}),c=0;c<a.length;c++)_d[a[c]]=d}function ca(a,b){ba(a,function(a,c,d,e){d._w=d._w||{},b(a,d._w,d,e)})}function da(a,b,c){null!=b&&i(_d,a)&&_d[a](b,c._a,c,a)}function ea(a,b){return new Date(Date.UTC(a,b+1,0)).getUTCDate()}function fa(a,b){return a?c(this._months)?this._months[a.month()]:this._months[(this._months.isFormat||ke).test(b)?\"format\":\"standalone\"][a.month()]:this._months}function ga(a,b){return a?c(this._monthsShort)?this._monthsShort[a.month()]:this._monthsShort[ke.test(b)?\"format\":\"standalone\"][a.month()]:this._monthsShort}function ha(a,b,c){var d,e,f,g=a.toLocaleLowerCase();if(!this._monthsParse)for(\n// this is not used\n        this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],d=0;d<12;++d)f=k([2e3,d]),this._shortMonthsParse[d]=this.monthsShort(f,\"\").toLocaleLowerCase(),this._longMonthsParse[d]=this.months(f,\"\").toLocaleLowerCase();return c?\"MMM\"===b?(e=je.call(this._shortMonthsParse,g),e!==-1?e:null):(e=je.call(this._longMonthsParse,g),e!==-1?e:null):\"MMM\"===b?(e=je.call(this._shortMonthsParse,g),e!==-1?e:(e=je.call(this._longMonthsParse,g),e!==-1?e:null)):(e=je.call(this._longMonthsParse,g),e!==-1?e:(e=je.call(this._shortMonthsParse,g),e!==-1?e:null))}function ia(a,b,c){var d,e,f;if(this._monthsParseExact)return ha.call(this,a,b,c);\n// TODO: add sorting\n// Sorting makes sure if one month (or abbr) is a prefix of another\n// see sorting in computeMonthsParse\n        for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),d=0;d<12;d++){\n// test the regex\n            if(\n// make the regex if we don't have it already\n                e=k([2e3,d]),c&&!this._longMonthsParse[d]&&(this._longMonthsParse[d]=new RegExp(\"^\"+this.months(e,\"\").replace(\".\",\"\")+\"$\",\"i\"),this._shortMonthsParse[d]=new RegExp(\"^\"+this.monthsShort(e,\"\").replace(\".\",\"\")+\"$\",\"i\")),c||this._monthsParse[d]||(f=\"^\"+this.months(e,\"\")+\"|^\"+this.monthsShort(e,\"\"),this._monthsParse[d]=new RegExp(f.replace(\".\",\"\"),\"i\")),c&&\"MMMM\"===b&&this._longMonthsParse[d].test(a))return d;if(c&&\"MMM\"===b&&this._shortMonthsParse[d].test(a))return d;if(!c&&this._monthsParse[d].test(a))return d}}\n// MOMENTS\n    function ja(a,b){var c;if(!a.isValid())\n// No op\n        return a;if(\"string\"==typeof b)if(/^\\d+$/.test(b))b=u(b);else\n// TODO: Another silent failure?\n    if(b=a.localeData().monthsParse(b),!f(b))return a;return c=Math.min(a.date(),ea(a.year(),b)),a._d[\"set\"+(a._isUTC?\"UTC\":\"\")+\"Month\"](b,c),a}function ka(b){return null!=b?(ja(this,b),a.updateOffset(this,!0),this):P(this,\"Month\")}function la(){return ea(this.year(),this.month())}function ma(a){return this._monthsParseExact?(i(this,\"_monthsRegex\")||oa.call(this),a?this._monthsShortStrictRegex:this._monthsShortRegex):(i(this,\"_monthsShortRegex\")||(this._monthsShortRegex=ne),this._monthsShortStrictRegex&&a?this._monthsShortStrictRegex:this._monthsShortRegex)}function na(a){return this._monthsParseExact?(i(this,\"_monthsRegex\")||oa.call(this),a?this._monthsStrictRegex:this._monthsRegex):(i(this,\"_monthsRegex\")||(this._monthsRegex=oe),this._monthsStrictRegex&&a?this._monthsStrictRegex:this._monthsRegex)}function oa(){function a(a,b){return b.length-a.length}var b,c,d=[],e=[],f=[];for(b=0;b<12;b++)\n// make the regex if we don't have it already\n        c=k([2e3,b]),d.push(this.monthsShort(c,\"\")),e.push(this.months(c,\"\")),f.push(this.months(c,\"\")),f.push(this.monthsShort(c,\"\"));for(\n// Sorting makes sure if one month (or abbr) is a prefix of another it\n// will match the longer piece.\n        d.sort(a),e.sort(a),f.sort(a),b=0;b<12;b++)d[b]=aa(d[b]),e[b]=aa(e[b]);for(b=0;b<24;b++)f[b]=aa(f[b]);this._monthsRegex=new RegExp(\"^(\"+f.join(\"|\")+\")\",\"i\"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp(\"^(\"+e.join(\"|\")+\")\",\"i\"),this._monthsShortStrictRegex=new RegExp(\"^(\"+d.join(\"|\")+\")\",\"i\")}\n// HELPERS\n    function pa(a){return qa(a)?366:365}function qa(a){return a%4===0&&a%100!==0||a%400===0}function ra(){return qa(this.year())}function sa(a,b,c,d,e,f,g){\n//can't just apply() to create a date:\n//http://stackoverflow.com/questions/181348/instantiating-a-javascript-object-by-calling-prototype-constructor-apply\n        var h=new Date(a,b,c,d,e,f,g);\n//the date constructor remaps years 0-99 to 1900-1999\n        return a<100&&a>=0&&isFinite(h.getFullYear())&&h.setFullYear(a),h}function ta(a){var b=new Date(Date.UTC.apply(null,arguments));\n//the Date.UTC function remaps years 0-99 to 1900-1999\n        return a<100&&a>=0&&isFinite(b.getUTCFullYear())&&b.setUTCFullYear(a),b}\n// start-of-first-week - start-of-year\n    function ua(a,b,c){var// first-week day -- which january is always in the first week (4 for iso, 1 for other)\n        d=7+b-c,\n// first-week day local weekday -- which local weekday is fwd\n        e=(7+ta(a,0,d).getUTCDay()-b)%7;return-e+d-1}\n//http://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday\n    function va(a,b,c,d,e){var f,g,h=(7+c-d)%7,i=ua(a,d,e),j=1+7*(b-1)+h+i;return j<=0?(f=a-1,g=pa(f)+j):j>pa(a)?(f=a+1,g=j-pa(a)):(f=a,g=j),{year:f,dayOfYear:g}}function wa(a,b,c){var d,e,f=ua(a.year(),b,c),g=Math.floor((a.dayOfYear()-f-1)/7)+1;return g<1?(e=a.year()-1,d=g+xa(e,b,c)):g>xa(a.year(),b,c)?(d=g-xa(a.year(),b,c),e=a.year()+1):(e=a.year(),d=g),{week:d,year:e}}function xa(a,b,c){var d=ua(a,b,c),e=ua(a+1,b,c);return(pa(a)-d+e)/7}\n// HELPERS\n// LOCALES\n    function ya(a){return wa(a,this._week.dow,this._week.doy).week}function za(){return this._week.dow}function Aa(){return this._week.doy}\n// MOMENTS\n    function Ba(a){var b=this.localeData().week(this);return null==a?b:this.add(7*(a-b),\"d\")}function Ca(a){var b=wa(this,1,4).week;return null==a?b:this.add(7*(a-b),\"d\")}\n// HELPERS\n    function Da(a,b){return\"string\"!=typeof a?a:isNaN(a)?(a=b.weekdaysParse(a),\"number\"==typeof a?a:null):parseInt(a,10)}function Ea(a,b){return\"string\"==typeof a?b.weekdaysParse(a)%7||7:isNaN(a)?null:a}function Fa(a,b){return a?c(this._weekdays)?this._weekdays[a.day()]:this._weekdays[this._weekdays.isFormat.test(b)?\"format\":\"standalone\"][a.day()]:this._weekdays}function Ga(a){return a?this._weekdaysShort[a.day()]:this._weekdaysShort}function Ha(a){return a?this._weekdaysMin[a.day()]:this._weekdaysMin}function Ia(a,b,c){var d,e,f,g=a.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],d=0;d<7;++d)f=k([2e3,1]).day(d),this._minWeekdaysParse[d]=this.weekdaysMin(f,\"\").toLocaleLowerCase(),this._shortWeekdaysParse[d]=this.weekdaysShort(f,\"\").toLocaleLowerCase(),this._weekdaysParse[d]=this.weekdays(f,\"\").toLocaleLowerCase();return c?\"dddd\"===b?(e=je.call(this._weekdaysParse,g),e!==-1?e:null):\"ddd\"===b?(e=je.call(this._shortWeekdaysParse,g),e!==-1?e:null):(e=je.call(this._minWeekdaysParse,g),e!==-1?e:null):\"dddd\"===b?(e=je.call(this._weekdaysParse,g),e!==-1?e:(e=je.call(this._shortWeekdaysParse,g),e!==-1?e:(e=je.call(this._minWeekdaysParse,g),e!==-1?e:null))):\"ddd\"===b?(e=je.call(this._shortWeekdaysParse,g),e!==-1?e:(e=je.call(this._weekdaysParse,g),e!==-1?e:(e=je.call(this._minWeekdaysParse,g),e!==-1?e:null))):(e=je.call(this._minWeekdaysParse,g),e!==-1?e:(e=je.call(this._weekdaysParse,g),e!==-1?e:(e=je.call(this._shortWeekdaysParse,g),e!==-1?e:null)))}function Ja(a,b,c){var d,e,f;if(this._weekdaysParseExact)return Ia.call(this,a,b,c);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),d=0;d<7;d++){\n// test the regex\n        if(\n// make the regex if we don't have it already\n            e=k([2e3,1]).day(d),c&&!this._fullWeekdaysParse[d]&&(this._fullWeekdaysParse[d]=new RegExp(\"^\"+this.weekdays(e,\"\").replace(\".\",\".?\")+\"$\",\"i\"),this._shortWeekdaysParse[d]=new RegExp(\"^\"+this.weekdaysShort(e,\"\").replace(\".\",\".?\")+\"$\",\"i\"),this._minWeekdaysParse[d]=new RegExp(\"^\"+this.weekdaysMin(e,\"\").replace(\".\",\".?\")+\"$\",\"i\")),this._weekdaysParse[d]||(f=\"^\"+this.weekdays(e,\"\")+\"|^\"+this.weekdaysShort(e,\"\")+\"|^\"+this.weekdaysMin(e,\"\"),this._weekdaysParse[d]=new RegExp(f.replace(\".\",\"\"),\"i\")),c&&\"dddd\"===b&&this._fullWeekdaysParse[d].test(a))return d;if(c&&\"ddd\"===b&&this._shortWeekdaysParse[d].test(a))return d;if(c&&\"dd\"===b&&this._minWeekdaysParse[d].test(a))return d;if(!c&&this._weekdaysParse[d].test(a))return d}}\n// MOMENTS\n    function Ka(a){if(!this.isValid())return null!=a?this:NaN;var b=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=a?(a=Da(a,this.localeData()),this.add(a-b,\"d\")):b}function La(a){if(!this.isValid())return null!=a?this:NaN;var b=(this.day()+7-this.localeData()._week.dow)%7;return null==a?b:this.add(a-b,\"d\")}function Ma(a){if(!this.isValid())return null!=a?this:NaN;\n// behaves the same as moment#day except\n// as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)\n// as a setter, sunday should belong to the previous week.\n        if(null!=a){var b=Ea(a,this.localeData());return this.day(this.day()%7?b:b-7)}return this.day()||7}function Na(a){return this._weekdaysParseExact?(i(this,\"_weekdaysRegex\")||Qa.call(this),a?this._weekdaysStrictRegex:this._weekdaysRegex):(i(this,\"_weekdaysRegex\")||(this._weekdaysRegex=ue),this._weekdaysStrictRegex&&a?this._weekdaysStrictRegex:this._weekdaysRegex)}function Oa(a){return this._weekdaysParseExact?(i(this,\"_weekdaysRegex\")||Qa.call(this),a?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(i(this,\"_weekdaysShortRegex\")||(this._weekdaysShortRegex=ve),this._weekdaysShortStrictRegex&&a?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function Pa(a){return this._weekdaysParseExact?(i(this,\"_weekdaysRegex\")||Qa.call(this),a?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(i(this,\"_weekdaysMinRegex\")||(this._weekdaysMinRegex=we),this._weekdaysMinStrictRegex&&a?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function Qa(){function a(a,b){return b.length-a.length}var b,c,d,e,f,g=[],h=[],i=[],j=[];for(b=0;b<7;b++)\n// make the regex if we don't have it already\n        c=k([2e3,1]).day(b),d=this.weekdaysMin(c,\"\"),e=this.weekdaysShort(c,\"\"),f=this.weekdays(c,\"\"),g.push(d),h.push(e),i.push(f),j.push(d),j.push(e),j.push(f);for(\n// Sorting makes sure if one weekday (or abbr) is a prefix of another it\n// will match the longer piece.\n        g.sort(a),h.sort(a),i.sort(a),j.sort(a),b=0;b<7;b++)h[b]=aa(h[b]),i[b]=aa(i[b]),j[b]=aa(j[b]);this._weekdaysRegex=new RegExp(\"^(\"+j.join(\"|\")+\")\",\"i\"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp(\"^(\"+i.join(\"|\")+\")\",\"i\"),this._weekdaysShortStrictRegex=new RegExp(\"^(\"+h.join(\"|\")+\")\",\"i\"),this._weekdaysMinStrictRegex=new RegExp(\"^(\"+g.join(\"|\")+\")\",\"i\")}\n// FORMATTING\n    function Ra(){return this.hours()%12||12}function Sa(){return this.hours()||24}function Ta(a,b){U(a,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),b)})}\n// PARSING\n    function Ua(a,b){return b._meridiemParse}\n// LOCALES\n    function Va(a){\n// IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays\n// Using charAt should be more compatible.\n        return\"p\"===(a+\"\").toLowerCase().charAt(0)}function Wa(a,b,c){return a>11?c?\"pm\":\"PM\":c?\"am\":\"AM\"}function Xa(a){return a?a.toLowerCase().replace(\"_\",\"-\"):a}\n// pick the locale from the array\n// try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each\n// substring from most specific to least, but move to the next array item if it's a more specific variant than the current root\n    function Ya(a){for(var b,c,d,e,f=0;f<a.length;){for(e=Xa(a[f]).split(\"-\"),b=e.length,c=Xa(a[f+1]),c=c?c.split(\"-\"):null;b>0;){if(d=Za(e.slice(0,b).join(\"-\")))return d;if(c&&c.length>=b&&v(e,c,!0)>=b-1)\n//the next array item is better than a shallower substring of this one\n        break;b--}f++}return null}function Za(a){var b=null;\n// TODO: Find a better way to register and load all the locales in Node\n        if(!Be[a]&&\"undefined\"!=typeof module&&module&&module.exports)try{b=xe._abbr,require(\"./locale/\"+a),\n// because defineLocale currently also sets the global locale, we\n// want to undo that for lazy loaded locales\n            $a(b)}catch(a){}return Be[a]}\n// This function will load locale and then set the global locale.  If\n// no arguments are passed in, it will simply return the current global\n// locale key.\n    function $a(a,b){var c;\n// moment.duration._locale = moment._locale = data;\n        return a&&(c=p(b)?bb(a):_a(a,b),c&&(xe=c)),xe._abbr}function _a(a,b){if(null!==b){var c=Ae;if(b.abbr=a,null!=Be[a])y(\"defineLocaleOverride\",\"use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info.\"),c=Be[a]._config;else if(null!=b.parentLocale){if(null==Be[b.parentLocale])return Ce[b.parentLocale]||(Ce[b.parentLocale]=[]),Ce[b.parentLocale].push({name:a,config:b}),null;c=Be[b.parentLocale]._config}\n// backwards compat for now: also set the locale\n// make sure we set the locale AFTER all child locales have been\n// created, so we won't end up with the child locale set.\n        return Be[a]=new C(B(c,b)),Ce[a]&&Ce[a].forEach(function(a){_a(a.name,a.config)}),$a(a),Be[a]}\n// useful for testing\n        return delete Be[a],null}function ab(a,b){if(null!=b){var c,d=Ae;\n// MERGE\n        null!=Be[a]&&(d=Be[a]._config),b=B(d,b),c=new C(b),c.parentLocale=Be[a],Be[a]=c,\n// backwards compat for now: also set the locale\n            $a(a)}else\n// pass null for config to unupdate, useful for tests\n        null!=Be[a]&&(null!=Be[a].parentLocale?Be[a]=Be[a].parentLocale:null!=Be[a]&&delete Be[a]);return Be[a]}\n// returns locale data\n    function bb(a){var b;if(a&&a._locale&&a._locale._abbr&&(a=a._locale._abbr),!a)return xe;if(!c(a)){if(\n//short-circuit everything else\n        b=Za(a))return b;a=[a]}return Ya(a)}function cb(){return wd(Be)}function db(a){var b,c=a._a;return c&&m(a).overflow===-2&&(b=c[be]<0||c[be]>11?be:c[ce]<1||c[ce]>ea(c[ae],c[be])?ce:c[de]<0||c[de]>24||24===c[de]&&(0!==c[ee]||0!==c[fe]||0!==c[ge])?de:c[ee]<0||c[ee]>59?ee:c[fe]<0||c[fe]>59?fe:c[ge]<0||c[ge]>999?ge:-1,m(a)._overflowDayOfYear&&(b<ae||b>ce)&&(b=ce),m(a)._overflowWeeks&&b===-1&&(b=he),m(a)._overflowWeekday&&b===-1&&(b=ie),m(a).overflow=b),a}\n// date from iso format\n    function eb(a){var b,c,d,e,f,g,h=a._i,i=De.exec(h)||Ee.exec(h);if(i){for(m(a).iso=!0,b=0,c=Ge.length;b<c;b++)if(Ge[b][1].exec(i[1])){e=Ge[b][0],d=Ge[b][2]!==!1;break}if(null==e)return void(a._isValid=!1);if(i[3]){for(b=0,c=He.length;b<c;b++)if(He[b][1].exec(i[3])){\n// match[2] should be 'T' or space\n        f=(i[2]||\" \")+He[b][0];break}if(null==f)return void(a._isValid=!1)}if(!d&&null!=f)return void(a._isValid=!1);if(i[4]){if(!Fe.exec(i[4]))return void(a._isValid=!1);g=\"Z\"}a._f=e+(f||\"\")+(g||\"\"),kb(a)}else a._isValid=!1}\n// date from iso format or fallback\n    function fb(b){var c=Ie.exec(b._i);return null!==c?void(b._d=new Date(+c[1])):(eb(b),void(b._isValid===!1&&(delete b._isValid,a.createFromInputFallback(b))))}\n// Pick the first defined of two or three arguments.\n    function gb(a,b,c){return null!=a?a:null!=b?b:c}function hb(b){\n// hooks is actually the exported moment object\n        var c=new Date(a.now());return b._useUTC?[c.getUTCFullYear(),c.getUTCMonth(),c.getUTCDate()]:[c.getFullYear(),c.getMonth(),c.getDate()]}\n// convert an array to a date.\n// the array should mirror the parameters below\n// note: all values past the year are optional and will default to the lowest possible value.\n// [year, month, day , hour, minute, second, millisecond]\n    function ib(a){var b,c,d,e,f=[];if(!a._d){\n// Default to current date.\n// * if no year, month, day of month are given, default to today\n// * if day of month is given, default month and year\n// * if month is given, default only year\n// * if year is given, don't default anything\n        for(d=hb(a),\n//compute day of the year from weeks and weekdays\n            a._w&&null==a._a[ce]&&null==a._a[be]&&jb(a),\n//if the day of the year is set, figure out what it is\n            a._dayOfYear&&(e=gb(a._a[ae],d[ae]),a._dayOfYear>pa(e)&&(m(a)._overflowDayOfYear=!0),c=ta(e,0,a._dayOfYear),a._a[be]=c.getUTCMonth(),a._a[ce]=c.getUTCDate()),b=0;b<3&&null==a._a[b];++b)a._a[b]=f[b]=d[b];\n// Zero out whatever was not defaulted, including time\n        for(;b<7;b++)a._a[b]=f[b]=null==a._a[b]?2===b?1:0:a._a[b];\n// Check for 24:00:00.000\n        24===a._a[de]&&0===a._a[ee]&&0===a._a[fe]&&0===a._a[ge]&&(a._nextDay=!0,a._a[de]=0),a._d=(a._useUTC?ta:sa).apply(null,f),\n// Apply timezone offset from input. The actual utcOffset can be changed\n// with parseZone.\n        null!=a._tzm&&a._d.setUTCMinutes(a._d.getUTCMinutes()-a._tzm),a._nextDay&&(a._a[de]=24)}}function jb(a){var b,c,d,e,f,g,h,i;if(b=a._w,null!=b.GG||null!=b.W||null!=b.E)f=1,g=4,\n// TODO: We need to take the current isoWeekYear, but that depends on\n// how we interpret now (local, utc, fixed offset). So create\n// a now version of current config (take local/utc/offset flags, and\n// create now).\n        c=gb(b.GG,a._a[ae],wa(sb(),1,4).year),d=gb(b.W,1),e=gb(b.E,1),(e<1||e>7)&&(i=!0);else{f=a._locale._week.dow,g=a._locale._week.doy;var j=wa(sb(),f,g);c=gb(b.gg,a._a[ae],j.year),\n// Default to current week.\n        d=gb(b.w,j.week),null!=b.d?(\n// weekday -- low day numbers are considered next week\n        e=b.d,(e<0||e>6)&&(i=!0)):null!=b.e?(\n// local weekday -- counting starts from begining of week\n        e=b.e+f,(b.e<0||b.e>6)&&(i=!0)):\n// default to begining of week\n        e=f}d<1||d>xa(c,f,g)?m(a)._overflowWeeks=!0:null!=i?m(a)._overflowWeekday=!0:(h=va(c,d,e,f,g),a._a[ae]=h.year,a._dayOfYear=h.dayOfYear)}\n// date from string and format string\n    function kb(b){\n// TODO: Move this to another part of the creation flow to prevent circular deps\n        if(b._f===a.ISO_8601)return void eb(b);b._a=[],m(b).empty=!0;\n// This array is used to make a Date, either with `new Date` or `Date.UTC`\n        var c,d,e,f,g,h=\"\"+b._i,i=h.length,j=0;for(e=Y(b._f,b._locale).match(Fd)||[],c=0;c<e.length;c++)f=e[c],d=(h.match($(f,b))||[])[0],\n// console.log('token', token, 'parsedInput', parsedInput,\n//         'regex', getParseRegexForToken(token, config));\n        d&&(g=h.substr(0,h.indexOf(d)),g.length>0&&m(b).unusedInput.push(g),h=h.slice(h.indexOf(d)+d.length),j+=d.length),\n// don't parse if it's not a known token\n            Id[f]?(d?m(b).empty=!1:m(b).unusedTokens.push(f),da(f,d,b)):b._strict&&!d&&m(b).unusedTokens.push(f);\n// add remaining unparsed input length to the string\n        m(b).charsLeftOver=i-j,h.length>0&&m(b).unusedInput.push(h),\n// clear _12h flag if hour is <= 12\n        b._a[de]<=12&&m(b).bigHour===!0&&b._a[de]>0&&(m(b).bigHour=void 0),m(b).parsedDateParts=b._a.slice(0),m(b).meridiem=b._meridiem,\n// handle meridiem\n            b._a[de]=lb(b._locale,b._a[de],b._meridiem),ib(b),db(b)}function lb(a,b,c){var d;\n// Fallback\n        return null==c?b:null!=a.meridiemHour?a.meridiemHour(b,c):null!=a.isPM?(d=a.isPM(c),d&&b<12&&(b+=12),d||12!==b||(b=0),b):b}\n// date from string and array of format strings\n    function mb(a){var b,c,d,e,f;if(0===a._f.length)return m(a).invalidFormat=!0,void(a._d=new Date(NaN));for(e=0;e<a._f.length;e++)f=0,b=q({},a),null!=a._useUTC&&(b._useUTC=a._useUTC),b._f=a._f[e],kb(b),n(b)&&(\n// if there is any input that was not parsed add a penalty for that format\n        f+=m(b).charsLeftOver,\n//or tokens\n        f+=10*m(b).unusedTokens.length,m(b).score=f,(null==d||f<d)&&(d=f,c=b));j(a,c||b)}function nb(a){if(!a._d){var b=L(a._i);a._a=h([b.year,b.month,b.day||b.date,b.hour,b.minute,b.second,b.millisecond],function(a){return a&&parseInt(a,10)}),ib(a)}}function ob(a){var b=new r(db(pb(a)));\n// Adding is smart enough around DST\n        return b._nextDay&&(b.add(1,\"d\"),b._nextDay=void 0),b}function pb(a){var b=a._i,d=a._f;return a._locale=a._locale||bb(a._l),null===b||void 0===d&&\"\"===b?o({nullInput:!0}):(\"string\"==typeof b&&(a._i=b=a._locale.preparse(b)),s(b)?new r(db(b)):(g(b)?a._d=b:c(d)?mb(a):d?kb(a):qb(a),n(a)||(a._d=null),a))}function qb(b){var d=b._i;void 0===d?b._d=new Date(a.now()):g(d)?b._d=new Date(d.valueOf()):\"string\"==typeof d?fb(b):c(d)?(b._a=h(d.slice(0),function(a){return parseInt(a,10)}),ib(b)):\"object\"==typeof d?nb(b):f(d)?\n// from milliseconds\n        b._d=new Date(d):a.createFromInputFallback(b)}function rb(a,b,f,g,h){var i={};\n// object construction must be done this way.\n// https://github.com/moment/moment/issues/1423\n        return f!==!0&&f!==!1||(g=f,f=void 0),(d(a)&&e(a)||c(a)&&0===a.length)&&(a=void 0),i._isAMomentObject=!0,i._useUTC=i._isUTC=h,i._l=f,i._i=a,i._f=b,i._strict=g,ob(i)}function sb(a,b,c,d){return rb(a,b,c,d,!1)}\n// Pick a moment m from moments so that m[fn](other) is true for all\n// other. This relies on the function fn to be transitive.\n//\n// moments should either be an array of moment objects or an array, whose\n// first element is an array of moment objects.\n    function tb(a,b){var d,e;if(1===b.length&&c(b[0])&&(b=b[0]),!b.length)return sb();for(d=b[0],e=1;e<b.length;++e)b[e].isValid()&&!b[e][a](d)||(d=b[e]);return d}\n// TODO: Use [].sort instead?\n    function ub(){var a=[].slice.call(arguments,0);return tb(\"isBefore\",a)}function vb(){var a=[].slice.call(arguments,0);return tb(\"isAfter\",a)}function wb(a){var b=L(a),c=b.year||0,d=b.quarter||0,e=b.month||0,f=b.week||0,g=b.day||0,h=b.hour||0,i=b.minute||0,j=b.second||0,k=b.millisecond||0;\n// representation for dateAddRemove\n        this._milliseconds=+k+1e3*j+// 1000\n            6e4*i+// 1000 * 60\n            1e3*h*60*60,//using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978\n// Because of dateAddRemove treats 24 hours as different from a\n// day when working around DST, we need to store them separately\n            this._days=+g+7*f,\n// It is impossible translate months into days without knowing\n// which months you are are talking about, so we have to store\n// it separately.\n            this._months=+e+3*d+12*c,this._data={},this._locale=bb(),this._bubble()}function xb(a){return a instanceof wb}function yb(a){return a<0?Math.round(-1*a)*-1:Math.round(a)}\n// FORMATTING\n    function zb(a,b){U(a,0,0,function(){var a=this.utcOffset(),c=\"+\";return a<0&&(a=-a,c=\"-\"),c+T(~~(a/60),2)+b+T(~~a%60,2)})}function Ab(a,b){var c=(b||\"\").match(a);if(null===c)return null;var d=c[c.length-1]||[],e=(d+\"\").match(Me)||[\"-\",0,0],f=+(60*e[1])+u(e[2]);return 0===f?0:\"+\"===e[0]?f:-f}\n// Return a moment from input, that is local/utc/zone equivalent to model.\n    function Bb(b,c){var d,e;\n// Use low-level api, because this fn is low-level api.\n        return c._isUTC?(d=c.clone(),e=(s(b)||g(b)?b.valueOf():sb(b).valueOf())-d.valueOf(),d._d.setTime(d._d.valueOf()+e),a.updateOffset(d,!1),d):sb(b).local()}function Cb(a){\n// On Firefox.24 Date#getTimezoneOffset returns a floating point.\n// https://github.com/moment/moment/pull/1871\n        return 15*-Math.round(a._d.getTimezoneOffset()/15)}\n// MOMENTS\n// keepLocalTime = true means only change the timezone, without\n// affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->\n// 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset\n// +0200, so we adjust the time as needed, to be valid.\n//\n// Keeping the time actually adds/subtracts (one hour)\n// from the actual represented time. That is why we call updateOffset\n// a second time. In case it wants us to change the offset again\n// _changeInProgress == true case, then we have to adjust, because\n// there is no such time in the given timezone.\n    function Db(b,c){var d,e=this._offset||0;if(!this.isValid())return null!=b?this:NaN;if(null!=b){if(\"string\"==typeof b){if(b=Ab(Xd,b),null===b)return this}else Math.abs(b)<16&&(b=60*b);return!this._isUTC&&c&&(d=Cb(this)),this._offset=b,this._isUTC=!0,null!=d&&this.add(d,\"m\"),e!==b&&(!c||this._changeInProgress?Tb(this,Ob(b-e,\"m\"),1,!1):this._changeInProgress||(this._changeInProgress=!0,a.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?e:Cb(this)}function Eb(a,b){return null!=a?(\"string\"!=typeof a&&(a=-a),this.utcOffset(a,b),this):-this.utcOffset()}function Fb(a){return this.utcOffset(0,a)}function Gb(a){return this._isUTC&&(this.utcOffset(0,a),this._isUTC=!1,a&&this.subtract(Cb(this),\"m\")),this}function Hb(){if(null!=this._tzm)this.utcOffset(this._tzm);else if(\"string\"==typeof this._i){var a=Ab(Wd,this._i);null!=a?this.utcOffset(a):this.utcOffset(0,!0)}return this}function Ib(a){return!!this.isValid()&&(a=a?sb(a).utcOffset():0,(this.utcOffset()-a)%60===0)}function Jb(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function Kb(){if(!p(this._isDSTShifted))return this._isDSTShifted;var a={};if(q(a,this),a=pb(a),a._a){var b=a._isUTC?k(a._a):sb(a._a);this._isDSTShifted=this.isValid()&&v(a._a,b.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted}function Lb(){return!!this.isValid()&&!this._isUTC}function Mb(){return!!this.isValid()&&this._isUTC}function Nb(){return!!this.isValid()&&(this._isUTC&&0===this._offset)}function Ob(a,b){var c,d,e,g=a,\n// matching against regexp is expensive, do it on demand\n        h=null;// checks for null or undefined\n        return xb(a)?g={ms:a._milliseconds,d:a._days,M:a._months}:f(a)?(g={},b?g[b]=a:g.milliseconds=a):(h=Ne.exec(a))?(c=\"-\"===h[1]?-1:1,g={y:0,d:u(h[ce])*c,h:u(h[de])*c,m:u(h[ee])*c,s:u(h[fe])*c,ms:u(yb(1e3*h[ge]))*c}):(h=Oe.exec(a))?(c=\"-\"===h[1]?-1:1,g={y:Pb(h[2],c),M:Pb(h[3],c),w:Pb(h[4],c),d:Pb(h[5],c),h:Pb(h[6],c),m:Pb(h[7],c),s:Pb(h[8],c)}):null==g?g={}:\"object\"==typeof g&&(\"from\"in g||\"to\"in g)&&(e=Rb(sb(g.from),sb(g.to)),g={},g.ms=e.milliseconds,g.M=e.months),d=new wb(g),xb(a)&&i(a,\"_locale\")&&(d._locale=a._locale),d}function Pb(a,b){\n// We'd normally use ~~inp for this, but unfortunately it also\n// converts floats to ints.\n// inp may be undefined, so careful calling replace on it.\n        var c=a&&parseFloat(a.replace(\",\",\".\"));\n// apply sign while we're at it\n        return(isNaN(c)?0:c)*b}function Qb(a,b){var c={milliseconds:0,months:0};return c.months=b.month()-a.month()+12*(b.year()-a.year()),a.clone().add(c.months,\"M\").isAfter(b)&&--c.months,c.milliseconds=+b-+a.clone().add(c.months,\"M\"),c}function Rb(a,b){var c;return a.isValid()&&b.isValid()?(b=Bb(b,a),a.isBefore(b)?c=Qb(a,b):(c=Qb(b,a),c.milliseconds=-c.milliseconds,c.months=-c.months),c):{milliseconds:0,months:0}}\n// TODO: remove 'name' arg after deprecation is removed\n    function Sb(a,b){return function(c,d){var e,f;\n//invert the arguments, but complain about it\n        return null===d||isNaN(+d)||(y(b,\"moment().\"+b+\"(period, number) is deprecated. Please use moment().\"+b+\"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.\"),f=c,c=d,d=f),c=\"string\"==typeof c?+c:c,e=Ob(c,d),Tb(this,e,a),this}}function Tb(b,c,d,e){var f=c._milliseconds,g=yb(c._days),h=yb(c._months);b.isValid()&&(e=null==e||e,f&&b._d.setTime(b._d.valueOf()+f*d),g&&Q(b,\"Date\",P(b,\"Date\")+g*d),h&&ja(b,P(b,\"Month\")+h*d),e&&a.updateOffset(b,g||h))}function Ub(a,b){var c=a.diff(b,\"days\",!0);return c<-6?\"sameElse\":c<-1?\"lastWeek\":c<0?\"lastDay\":c<1?\"sameDay\":c<2?\"nextDay\":c<7?\"nextWeek\":\"sameElse\"}function Vb(b,c){\n// We want to compare the start of today, vs this.\n// Getting start-of-today depends on whether we're local/utc/offset or not.\n        var d=b||sb(),e=Bb(d,this).startOf(\"day\"),f=a.calendarFormat(this,e)||\"sameElse\",g=c&&(z(c[f])?c[f].call(this,d):c[f]);return this.format(g||this.localeData().calendar(f,this,sb(d)))}function Wb(){return new r(this)}function Xb(a,b){var c=s(a)?a:sb(a);return!(!this.isValid()||!c.isValid())&&(b=K(p(b)?\"millisecond\":b),\"millisecond\"===b?this.valueOf()>c.valueOf():c.valueOf()<this.clone().startOf(b).valueOf())}function Yb(a,b){var c=s(a)?a:sb(a);return!(!this.isValid()||!c.isValid())&&(b=K(p(b)?\"millisecond\":b),\"millisecond\"===b?this.valueOf()<c.valueOf():this.clone().endOf(b).valueOf()<c.valueOf())}function Zb(a,b,c,d){return d=d||\"()\",(\"(\"===d[0]?this.isAfter(a,c):!this.isBefore(a,c))&&(\")\"===d[1]?this.isBefore(b,c):!this.isAfter(b,c))}function $b(a,b){var c,d=s(a)?a:sb(a);return!(!this.isValid()||!d.isValid())&&(b=K(b||\"millisecond\"),\"millisecond\"===b?this.valueOf()===d.valueOf():(c=d.valueOf(),this.clone().startOf(b).valueOf()<=c&&c<=this.clone().endOf(b).valueOf()))}function _b(a,b){return this.isSame(a,b)||this.isAfter(a,b)}function ac(a,b){return this.isSame(a,b)||this.isBefore(a,b)}function bc(a,b,c){var d,e,f,g;// 1000\n// 1000 * 60\n// 1000 * 60 * 60\n// 1000 * 60 * 60 * 24, negate dst\n// 1000 * 60 * 60 * 24 * 7, negate dst\n        return this.isValid()?(d=Bb(a,this),d.isValid()?(e=6e4*(d.utcOffset()-this.utcOffset()),b=K(b),\"year\"===b||\"month\"===b||\"quarter\"===b?(g=cc(this,d),\"quarter\"===b?g/=3:\"year\"===b&&(g/=12)):(f=this-d,g=\"second\"===b?f/1e3:\"minute\"===b?f/6e4:\"hour\"===b?f/36e5:\"day\"===b?(f-e)/864e5:\"week\"===b?(f-e)/6048e5:f),c?g:t(g)):NaN):NaN}function cc(a,b){\n// difference in months\n        var c,d,e=12*(b.year()-a.year())+(b.month()-a.month()),\n// b is in (anchor - 1 month, anchor + 1 month)\n            f=a.clone().add(e,\"months\");\n//check for negative zero, return zero if negative zero\n// linear across the month\n// linear across the month\n        return b-f<0?(c=a.clone().add(e-1,\"months\"),d=(b-f)/(f-c)):(c=a.clone().add(e+1,\"months\"),d=(b-f)/(c-f)),-(e+d)||0}function dc(){return this.clone().locale(\"en\").format(\"ddd MMM DD YYYY HH:mm:ss [GMT]ZZ\")}function ec(){var a=this.clone().utc();return 0<a.year()&&a.year()<=9999?z(Date.prototype.toISOString)?this.toDate().toISOString():X(a,\"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]\"):X(a,\"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]\")}/**\n     * Return a human readable representation of a moment that can\n     * also be evaluated to get a new moment which is the same\n     *\n     * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects\n     */\n    function fc(){if(!this.isValid())return\"moment.invalid(/* \"+this._i+\" */)\";var a=\"moment\",b=\"\";this.isLocal()||(a=0===this.utcOffset()?\"moment.utc\":\"moment.parseZone\",b=\"Z\");var c=\"[\"+a+'(\"]',d=0<this.year()&&this.year()<=9999?\"YYYY\":\"YYYYYY\",e=\"-MM-DD[T]HH:mm:ss.SSS\",f=b+'[\")]';return this.format(c+d+e+f)}function gc(b){b||(b=this.isUtc()?a.defaultFormatUtc:a.defaultFormat);var c=X(this,b);return this.localeData().postformat(c)}function hc(a,b){return this.isValid()&&(s(a)&&a.isValid()||sb(a).isValid())?Ob({to:this,from:a}).locale(this.locale()).humanize(!b):this.localeData().invalidDate()}function ic(a){return this.from(sb(),a)}function jc(a,b){return this.isValid()&&(s(a)&&a.isValid()||sb(a).isValid())?Ob({from:this,to:a}).locale(this.locale()).humanize(!b):this.localeData().invalidDate()}function kc(a){return this.to(sb(),a)}\n// If passed a locale key, it will set the locale for this\n// instance.  Otherwise, it will return the locale configuration\n// variables for this instance.\n    function lc(a){var b;return void 0===a?this._locale._abbr:(b=bb(a),null!=b&&(this._locale=b),this)}function mc(){return this._locale}function nc(a){\n// the following switch intentionally omits break keywords\n// to utilize falling through the cases.\n        switch(a=K(a)){case\"year\":this.month(0);/* falls through */\n            case\"quarter\":case\"month\":this.date(1);/* falls through */\n            case\"week\":case\"isoWeek\":case\"day\":case\"date\":this.hours(0);/* falls through */\n            case\"hour\":this.minutes(0);/* falls through */\n            case\"minute\":this.seconds(0);/* falls through */\n            case\"second\":this.milliseconds(0)}\n// weeks are a special case\n// quarters are also special\n        return\"week\"===a&&this.weekday(0),\"isoWeek\"===a&&this.isoWeekday(1),\"quarter\"===a&&this.month(3*Math.floor(this.month()/3)),this}function oc(a){\n// 'date' is an alias for 'day', so it should be considered as such.\n        return a=K(a),void 0===a||\"millisecond\"===a?this:(\"date\"===a&&(a=\"day\"),this.startOf(a).add(1,\"isoWeek\"===a?\"week\":a).subtract(1,\"ms\"))}function pc(){return this._d.valueOf()-6e4*(this._offset||0)}function qc(){return Math.floor(this.valueOf()/1e3)}function rc(){return new Date(this.valueOf())}function sc(){var a=this;return[a.year(),a.month(),a.date(),a.hour(),a.minute(),a.second(),a.millisecond()]}function tc(){var a=this;return{years:a.year(),months:a.month(),date:a.date(),hours:a.hours(),minutes:a.minutes(),seconds:a.seconds(),milliseconds:a.milliseconds()}}function uc(){\n// new Date(NaN).toJSON() === null\n        return this.isValid()?this.toISOString():null}function vc(){return n(this)}function wc(){return j({},m(this))}function xc(){return m(this).overflow}function yc(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function zc(a,b){U(0,[a,a.length],0,b)}\n// MOMENTS\n    function Ac(a){return Ec.call(this,a,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function Bc(a){return Ec.call(this,a,this.isoWeek(),this.isoWeekday(),1,4)}function Cc(){return xa(this.year(),1,4)}function Dc(){var a=this.localeData()._week;return xa(this.year(),a.dow,a.doy)}function Ec(a,b,c,d,e){var f;return null==a?wa(this,d,e).year:(f=xa(a,d,e),b>f&&(b=f),Fc.call(this,a,b,c,d,e))}function Fc(a,b,c,d,e){var f=va(a,b,c,d,e),g=ta(f.year,0,f.dayOfYear);return this.year(g.getUTCFullYear()),this.month(g.getUTCMonth()),this.date(g.getUTCDate()),this}\n// MOMENTS\n    function Gc(a){return null==a?Math.ceil((this.month()+1)/3):this.month(3*(a-1)+this.month()%3)}\n// HELPERS\n// MOMENTS\n    function Hc(a){var b=Math.round((this.clone().startOf(\"day\")-this.clone().startOf(\"year\"))/864e5)+1;return null==a?b:this.add(a-b,\"d\")}function Ic(a,b){b[ge]=u(1e3*(\"0.\"+a))}\n// MOMENTS\n    function Jc(){return this._isUTC?\"UTC\":\"\"}function Kc(){return this._isUTC?\"Coordinated Universal Time\":\"\"}function Lc(a){return sb(1e3*a)}function Mc(){return sb.apply(null,arguments).parseZone()}function Nc(a){return a}function Oc(a,b,c,d){var e=bb(),f=k().set(d,b);return e[c](f,a)}function Pc(a,b,c){if(f(a)&&(b=a,a=void 0),a=a||\"\",null!=b)return Oc(a,b,c,\"month\");var d,e=[];for(d=0;d<12;d++)e[d]=Oc(a,d,c,\"month\");return e}\n// ()\n// (5)\n// (fmt, 5)\n// (fmt)\n// (true)\n// (true, 5)\n// (true, fmt, 5)\n// (true, fmt)\n    function Qc(a,b,c,d){\"boolean\"==typeof a?(f(b)&&(c=b,b=void 0),b=b||\"\"):(b=a,c=b,a=!1,f(b)&&(c=b,b=void 0),b=b||\"\");var e=bb(),g=a?e._week.dow:0;if(null!=c)return Oc(b,(c+g)%7,d,\"day\");var h,i=[];for(h=0;h<7;h++)i[h]=Oc(b,(h+g)%7,d,\"day\");return i}function Rc(a,b){return Pc(a,b,\"months\")}function Sc(a,b){return Pc(a,b,\"monthsShort\")}function Tc(a,b,c){return Qc(a,b,c,\"weekdays\")}function Uc(a,b,c){return Qc(a,b,c,\"weekdaysShort\")}function Vc(a,b,c){return Qc(a,b,c,\"weekdaysMin\")}function Wc(){var a=this._data;return this._milliseconds=Ze(this._milliseconds),this._days=Ze(this._days),this._months=Ze(this._months),a.milliseconds=Ze(a.milliseconds),a.seconds=Ze(a.seconds),a.minutes=Ze(a.minutes),a.hours=Ze(a.hours),a.months=Ze(a.months),a.years=Ze(a.years),this}function Xc(a,b,c,d){var e=Ob(b,c);return a._milliseconds+=d*e._milliseconds,a._days+=d*e._days,a._months+=d*e._months,a._bubble()}\n// supports only 2.0-style add(1, 's') or add(duration)\n    function Yc(a,b){return Xc(this,a,b,1)}\n// supports only 2.0-style subtract(1, 's') or subtract(duration)\n    function Zc(a,b){return Xc(this,a,b,-1)}function $c(a){return a<0?Math.floor(a):Math.ceil(a)}function _c(){var a,b,c,d,e,f=this._milliseconds,g=this._days,h=this._months,i=this._data;\n// if we have a mix of positive and negative values, bubble down first\n// check: https://github.com/moment/moment/issues/2166\n// The following code bubbles up values, see the tests for\n// examples of what that means.\n// convert days to months\n// 12 months -> 1 year\n        return f>=0&&g>=0&&h>=0||f<=0&&g<=0&&h<=0||(f+=864e5*$c(bd(h)+g),g=0,h=0),i.milliseconds=f%1e3,a=t(f/1e3),i.seconds=a%60,b=t(a/60),i.minutes=b%60,c=t(b/60),i.hours=c%24,g+=t(c/24),e=t(ad(g)),h+=e,g-=$c(bd(e)),d=t(h/12),h%=12,i.days=g,i.months=h,i.years=d,this}function ad(a){\n// 400 years have 146097 days (taking into account leap year rules)\n// 400 years have 12 months === 4800\n        return 4800*a/146097}function bd(a){\n// the reverse of daysToMonths\n        return 146097*a/4800}function cd(a){var b,c,d=this._milliseconds;if(a=K(a),\"month\"===a||\"year\"===a)return b=this._days+d/864e5,c=this._months+ad(b),\"month\"===a?c:c/12;switch(\n// handle milliseconds separately because of floating point math errors (issue #1867)\n        b=this._days+Math.round(bd(this._months)),a){case\"week\":return b/7+d/6048e5;case\"day\":return b+d/864e5;case\"hour\":return 24*b+d/36e5;case\"minute\":return 1440*b+d/6e4;case\"second\":return 86400*b+d/1e3;\n// Math.floor prevents floating point math errors here\n        case\"millisecond\":return Math.floor(864e5*b)+d;default:throw new Error(\"Unknown unit \"+a)}}\n// TODO: Use this.as('ms')?\n    function dd(){return this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*u(this._months/12)}function ed(a){return function(){return this.as(a)}}function fd(a){return a=K(a),this[a+\"s\"]()}function gd(a){return function(){return this._data[a]}}function hd(){return t(this.days()/7)}\n// helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize\n    function id(a,b,c,d,e){return e.relativeTime(b||1,!!c,a,d)}function jd(a,b,c){var d=Ob(a).abs(),e=of(d.as(\"s\")),f=of(d.as(\"m\")),g=of(d.as(\"h\")),h=of(d.as(\"d\")),i=of(d.as(\"M\")),j=of(d.as(\"y\")),k=e<pf.s&&[\"s\",e]||f<=1&&[\"m\"]||f<pf.m&&[\"mm\",f]||g<=1&&[\"h\"]||g<pf.h&&[\"hh\",g]||h<=1&&[\"d\"]||h<pf.d&&[\"dd\",h]||i<=1&&[\"M\"]||i<pf.M&&[\"MM\",i]||j<=1&&[\"y\"]||[\"yy\",j];return k[2]=b,k[3]=+a>0,k[4]=c,id.apply(null,k)}\n// This function allows you to set the rounding function for relative time strings\n    function kd(a){return void 0===a?of:\"function\"==typeof a&&(of=a,!0)}\n// This function allows you to set a threshold for relative time strings\n    function ld(a,b){return void 0!==pf[a]&&(void 0===b?pf[a]:(pf[a]=b,!0))}function md(a){var b=this.localeData(),c=jd(this,!a,b);return a&&(c=b.pastFuture(+this,c)),b.postformat(c)}function nd(){\n// for ISO strings we do not use the normal bubbling rules:\n//  * milliseconds bubble up until they become hours\n//  * days do not bubble at all\n//  * months bubble up until they become years\n// This is because there is no context-free conversion between hours and days\n// (think of clock changes)\n// and also not between days and months (28-31 days per month)\n        var a,b,c,d=qf(this._milliseconds)/1e3,e=qf(this._days),f=qf(this._months);\n// 3600 seconds -> 60 minutes -> 1 hour\n        a=t(d/60),b=t(a/60),d%=60,a%=60,\n// 12 months -> 1 year\n            c=t(f/12),f%=12;\n// inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js\n        var g=c,h=f,i=e,j=b,k=a,l=d,m=this.asSeconds();return m?(m<0?\"-\":\"\")+\"P\"+(g?g+\"Y\":\"\")+(h?h+\"M\":\"\")+(i?i+\"D\":\"\")+(j||k||l?\"T\":\"\")+(j?j+\"H\":\"\")+(k?k+\"M\":\"\")+(l?l+\"S\":\"\"):\"P0D\"}var od,pd;pd=Array.prototype.some?Array.prototype.some:function(a){for(var b=Object(this),c=b.length>>>0,d=0;d<c;d++)if(d in b&&a.call(this,b[d],d,b))return!0;return!1};var qd=pd,rd=a.momentProperties=[],sd=!1,td={};a.suppressDeprecationWarnings=!1,a.deprecationHandler=null;var ud;ud=Object.keys?Object.keys:function(a){var b,c=[];for(b in a)i(a,b)&&c.push(b);return c};var vd,wd=ud,xd={sameDay:\"[Today at] LT\",nextDay:\"[Tomorrow at] LT\",nextWeek:\"dddd [at] LT\",lastDay:\"[Yesterday at] LT\",lastWeek:\"[Last] dddd [at] LT\",sameElse:\"L\"},yd={LTS:\"h:mm:ss A\",LT:\"h:mm A\",L:\"MM/DD/YYYY\",LL:\"MMMM D, YYYY\",LLL:\"MMMM D, YYYY h:mm A\",LLLL:\"dddd, MMMM D, YYYY h:mm A\"},zd=\"Invalid date\",Ad=\"%d\",Bd=/\\d{1,2}/,Cd={future:\"in %s\",past:\"%s ago\",s:\"a few seconds\",m:\"a minute\",mm:\"%d minutes\",h:\"an hour\",hh:\"%d hours\",d:\"a day\",dd:\"%d days\",M:\"a month\",MM:\"%d months\",y:\"a year\",yy:\"%d years\"},Dd={},Ed={},Fd=/(\\[[^\\[]*\\])|(\\\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,Gd=/(\\[[^\\[]*\\])|(\\\\)?(LTS|LT|LL?L?L?|l{1,4})/g,Hd={},Id={},Jd=/\\d/,Kd=/\\d\\d/,Ld=/\\d{3}/,Md=/\\d{4}/,Nd=/[+-]?\\d{6}/,Od=/\\d\\d?/,Pd=/\\d\\d\\d\\d?/,Qd=/\\d\\d\\d\\d\\d\\d?/,Rd=/\\d{1,3}/,Sd=/\\d{1,4}/,Td=/[+-]?\\d{1,6}/,Ud=/\\d+/,Vd=/[+-]?\\d+/,Wd=/Z|[+-]\\d\\d:?\\d\\d/gi,Xd=/Z|[+-]\\d\\d(?::?\\d\\d)?/gi,Yd=/[+-]?\\d+(\\.\\d{1,3})?/,Zd=/[0-9]*['a-z\\u00A0-\\u05FF\\u0700-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]+|[\\u0600-\\u06FF\\/]+(\\s*?[\\u0600-\\u06FF]+){1,2}/i,$d={},_d={},ae=0,be=1,ce=2,de=3,ee=4,fe=5,ge=6,he=7,ie=8;vd=Array.prototype.indexOf?Array.prototype.indexOf:function(a){\n// I know\n        var b;for(b=0;b<this.length;++b)if(this[b]===a)return b;return-1};var je=vd;\n// FORMATTING\n    U(\"M\",[\"MM\",2],\"Mo\",function(){return this.month()+1}),U(\"MMM\",0,0,function(a){return this.localeData().monthsShort(this,a)}),U(\"MMMM\",0,0,function(a){return this.localeData().months(this,a)}),\n// ALIASES\n        J(\"month\",\"M\"),\n// PRIORITY\n        M(\"month\",8),\n// PARSING\n        Z(\"M\",Od),Z(\"MM\",Od,Kd),Z(\"MMM\",function(a,b){return b.monthsShortRegex(a)}),Z(\"MMMM\",function(a,b){return b.monthsRegex(a)}),ba([\"M\",\"MM\"],function(a,b){b[be]=u(a)-1}),ba([\"MMM\",\"MMMM\"],function(a,b,c,d){var e=c._locale.monthsParse(a,d,c._strict);\n// if we didn't find a month name, mark the date as invalid.\n        null!=e?b[be]=e:m(c).invalidMonth=a});\n// LOCALES\n    var ke=/D[oD]?(\\[[^\\[\\]]*\\]|\\s)+MMMM?/,le=\"January_February_March_April_May_June_July_August_September_October_November_December\".split(\"_\"),me=\"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec\".split(\"_\"),ne=Zd,oe=Zd;\n// FORMATTING\n    U(\"Y\",0,0,function(){var a=this.year();return a<=9999?\"\"+a:\"+\"+a}),U(0,[\"YY\",2],0,function(){return this.year()%100}),U(0,[\"YYYY\",4],0,\"year\"),U(0,[\"YYYYY\",5],0,\"year\"),U(0,[\"YYYYYY\",6,!0],0,\"year\"),\n// ALIASES\n        J(\"year\",\"y\"),\n// PRIORITIES\n        M(\"year\",1),\n// PARSING\n        Z(\"Y\",Vd),Z(\"YY\",Od,Kd),Z(\"YYYY\",Sd,Md),Z(\"YYYYY\",Td,Nd),Z(\"YYYYYY\",Td,Nd),ba([\"YYYYY\",\"YYYYYY\"],ae),ba(\"YYYY\",function(b,c){c[ae]=2===b.length?a.parseTwoDigitYear(b):u(b)}),ba(\"YY\",function(b,c){c[ae]=a.parseTwoDigitYear(b)}),ba(\"Y\",function(a,b){b[ae]=parseInt(a,10)}),\n// HOOKS\n        a.parseTwoDigitYear=function(a){return u(a)+(u(a)>68?1900:2e3)};\n// MOMENTS\n    var pe=O(\"FullYear\",!0);\n// FORMATTING\n    U(\"w\",[\"ww\",2],\"wo\",\"week\"),U(\"W\",[\"WW\",2],\"Wo\",\"isoWeek\"),\n// ALIASES\n        J(\"week\",\"w\"),J(\"isoWeek\",\"W\"),\n// PRIORITIES\n        M(\"week\",5),M(\"isoWeek\",5),\n// PARSING\n        Z(\"w\",Od),Z(\"ww\",Od,Kd),Z(\"W\",Od),Z(\"WW\",Od,Kd),ca([\"w\",\"ww\",\"W\",\"WW\"],function(a,b,c,d){b[d.substr(0,1)]=u(a)});var qe={dow:0,// Sunday is the first day of the week.\n        doy:6};\n// FORMATTING\n    U(\"d\",0,\"do\",\"day\"),U(\"dd\",0,0,function(a){return this.localeData().weekdaysMin(this,a)}),U(\"ddd\",0,0,function(a){return this.localeData().weekdaysShort(this,a)}),U(\"dddd\",0,0,function(a){return this.localeData().weekdays(this,a)}),U(\"e\",0,0,\"weekday\"),U(\"E\",0,0,\"isoWeekday\"),\n// ALIASES\n        J(\"day\",\"d\"),J(\"weekday\",\"e\"),J(\"isoWeekday\",\"E\"),\n// PRIORITY\n        M(\"day\",11),M(\"weekday\",11),M(\"isoWeekday\",11),\n// PARSING\n        Z(\"d\",Od),Z(\"e\",Od),Z(\"E\",Od),Z(\"dd\",function(a,b){return b.weekdaysMinRegex(a)}),Z(\"ddd\",function(a,b){return b.weekdaysShortRegex(a)}),Z(\"dddd\",function(a,b){return b.weekdaysRegex(a)}),ca([\"dd\",\"ddd\",\"dddd\"],function(a,b,c,d){var e=c._locale.weekdaysParse(a,d,c._strict);\n// if we didn't get a weekday name, mark the date as invalid\n        null!=e?b.d=e:m(c).invalidWeekday=a}),ca([\"d\",\"e\",\"E\"],function(a,b,c,d){b[d]=u(a)});\n// LOCALES\n    var re=\"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday\".split(\"_\"),se=\"Sun_Mon_Tue_Wed_Thu_Fri_Sat\".split(\"_\"),te=\"Su_Mo_Tu_We_Th_Fr_Sa\".split(\"_\"),ue=Zd,ve=Zd,we=Zd;U(\"H\",[\"HH\",2],0,\"hour\"),U(\"h\",[\"hh\",2],0,Ra),U(\"k\",[\"kk\",2],0,Sa),U(\"hmm\",0,0,function(){return\"\"+Ra.apply(this)+T(this.minutes(),2)}),U(\"hmmss\",0,0,function(){return\"\"+Ra.apply(this)+T(this.minutes(),2)+T(this.seconds(),2)}),U(\"Hmm\",0,0,function(){return\"\"+this.hours()+T(this.minutes(),2)}),U(\"Hmmss\",0,0,function(){return\"\"+this.hours()+T(this.minutes(),2)+T(this.seconds(),2)}),Ta(\"a\",!0),Ta(\"A\",!1),\n// ALIASES\n        J(\"hour\",\"h\"),\n// PRIORITY\n        M(\"hour\",13),Z(\"a\",Ua),Z(\"A\",Ua),Z(\"H\",Od),Z(\"h\",Od),Z(\"HH\",Od,Kd),Z(\"hh\",Od,Kd),Z(\"hmm\",Pd),Z(\"hmmss\",Qd),Z(\"Hmm\",Pd),Z(\"Hmmss\",Qd),ba([\"H\",\"HH\"],de),ba([\"a\",\"A\"],function(a,b,c){c._isPm=c._locale.isPM(a),c._meridiem=a}),ba([\"h\",\"hh\"],function(a,b,c){b[de]=u(a),m(c).bigHour=!0}),ba(\"hmm\",function(a,b,c){var d=a.length-2;b[de]=u(a.substr(0,d)),b[ee]=u(a.substr(d)),m(c).bigHour=!0}),ba(\"hmmss\",function(a,b,c){var d=a.length-4,e=a.length-2;b[de]=u(a.substr(0,d)),b[ee]=u(a.substr(d,2)),b[fe]=u(a.substr(e)),m(c).bigHour=!0}),ba(\"Hmm\",function(a,b,c){var d=a.length-2;b[de]=u(a.substr(0,d)),b[ee]=u(a.substr(d))}),ba(\"Hmmss\",function(a,b,c){var d=a.length-4,e=a.length-2;b[de]=u(a.substr(0,d)),b[ee]=u(a.substr(d,2)),b[fe]=u(a.substr(e))});var xe,ye=/[ap]\\.?m?\\.?/i,ze=O(\"Hours\",!0),Ae={calendar:xd,longDateFormat:yd,invalidDate:zd,ordinal:Ad,ordinalParse:Bd,relativeTime:Cd,months:le,monthsShort:me,week:qe,weekdays:re,weekdaysMin:te,weekdaysShort:se,meridiemParse:ye},Be={},Ce={},De=/^\\s*((?:[+-]\\d{6}|\\d{4})-(?:\\d\\d-\\d\\d|W\\d\\d-\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?::\\d\\d(?::\\d\\d(?:[.,]\\d+)?)?)?)([\\+\\-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,Ee=/^\\s*((?:[+-]\\d{6}|\\d{4})(?:\\d\\d\\d\\d|W\\d\\d\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?:\\d\\d(?:\\d\\d(?:[.,]\\d+)?)?)?)([\\+\\-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,Fe=/Z|[+-]\\d\\d(?::?\\d\\d)?/,Ge=[[\"YYYYYY-MM-DD\",/[+-]\\d{6}-\\d\\d-\\d\\d/],[\"YYYY-MM-DD\",/\\d{4}-\\d\\d-\\d\\d/],[\"GGGG-[W]WW-E\",/\\d{4}-W\\d\\d-\\d/],[\"GGGG-[W]WW\",/\\d{4}-W\\d\\d/,!1],[\"YYYY-DDD\",/\\d{4}-\\d{3}/],[\"YYYY-MM\",/\\d{4}-\\d\\d/,!1],[\"YYYYYYMMDD\",/[+-]\\d{10}/],[\"YYYYMMDD\",/\\d{8}/],\n// YYYYMM is NOT allowed by the standard\n        [\"GGGG[W]WWE\",/\\d{4}W\\d{3}/],[\"GGGG[W]WW\",/\\d{4}W\\d{2}/,!1],[\"YYYYDDD\",/\\d{7}/]],He=[[\"HH:mm:ss.SSSS\",/\\d\\d:\\d\\d:\\d\\d\\.\\d+/],[\"HH:mm:ss,SSSS\",/\\d\\d:\\d\\d:\\d\\d,\\d+/],[\"HH:mm:ss\",/\\d\\d:\\d\\d:\\d\\d/],[\"HH:mm\",/\\d\\d:\\d\\d/],[\"HHmmss.SSSS\",/\\d\\d\\d\\d\\d\\d\\.\\d+/],[\"HHmmss,SSSS\",/\\d\\d\\d\\d\\d\\d,\\d+/],[\"HHmmss\",/\\d\\d\\d\\d\\d\\d/],[\"HHmm\",/\\d\\d\\d\\d/],[\"HH\",/\\d\\d/]],Ie=/^\\/?Date\\((\\-?\\d+)/i;a.createFromInputFallback=x(\"value provided is not in a recognized ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.\",function(a){a._d=new Date(a._i+(a._useUTC?\" UTC\":\"\"))}),\n// constant that refers to the ISO standard\n        a.ISO_8601=function(){};var Je=x(\"moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var a=sb.apply(null,arguments);return this.isValid()&&a.isValid()?a<this?this:a:o()}),Ke=x(\"moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var a=sb.apply(null,arguments);return this.isValid()&&a.isValid()?a>this?this:a:o()}),Le=function(){return Date.now?Date.now():+new Date};zb(\"Z\",\":\"),zb(\"ZZ\",\"\"),\n// PARSING\n        Z(\"Z\",Xd),Z(\"ZZ\",Xd),ba([\"Z\",\"ZZ\"],function(a,b,c){c._useUTC=!0,c._tzm=Ab(Xd,a)});\n// HELPERS\n// timezone chunker\n// '+10:00' > ['10',  '00']\n// '-1530'  > ['-15', '30']\n    var Me=/([\\+\\-]|\\d\\d)/gi;\n// HOOKS\n// This function will be called whenever a moment is mutated.\n// It is intended to keep the offset in sync with the timezone.\n    a.updateOffset=function(){};\n// ASP.NET json date format regex\n    var Ne=/^(\\-)?(?:(\\d*)[. ])?(\\d+)\\:(\\d+)(?:\\:(\\d+)(\\.\\d*)?)?$/,Oe=/^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;Ob.fn=wb.prototype;var Pe=Sb(1,\"add\"),Qe=Sb(-1,\"subtract\");a.defaultFormat=\"YYYY-MM-DDTHH:mm:ssZ\",a.defaultFormatUtc=\"YYYY-MM-DDTHH:mm:ss[Z]\";var Re=x(\"moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.\",function(a){return void 0===a?this.localeData():this.locale(a)});\n// FORMATTING\n    U(0,[\"gg\",2],0,function(){return this.weekYear()%100}),U(0,[\"GG\",2],0,function(){return this.isoWeekYear()%100}),zc(\"gggg\",\"weekYear\"),zc(\"ggggg\",\"weekYear\"),zc(\"GGGG\",\"isoWeekYear\"),zc(\"GGGGG\",\"isoWeekYear\"),\n// ALIASES\n        J(\"weekYear\",\"gg\"),J(\"isoWeekYear\",\"GG\"),\n// PRIORITY\n        M(\"weekYear\",1),M(\"isoWeekYear\",1),\n// PARSING\n        Z(\"G\",Vd),Z(\"g\",Vd),Z(\"GG\",Od,Kd),Z(\"gg\",Od,Kd),Z(\"GGGG\",Sd,Md),Z(\"gggg\",Sd,Md),Z(\"GGGGG\",Td,Nd),Z(\"ggggg\",Td,Nd),ca([\"gggg\",\"ggggg\",\"GGGG\",\"GGGGG\"],function(a,b,c,d){b[d.substr(0,2)]=u(a)}),ca([\"gg\",\"GG\"],function(b,c,d,e){c[e]=a.parseTwoDigitYear(b)}),\n// FORMATTING\n        U(\"Q\",0,\"Qo\",\"quarter\"),\n// ALIASES\n        J(\"quarter\",\"Q\"),\n// PRIORITY\n        M(\"quarter\",7),\n// PARSING\n        Z(\"Q\",Jd),ba(\"Q\",function(a,b){b[be]=3*(u(a)-1)}),\n// FORMATTING\n        U(\"D\",[\"DD\",2],\"Do\",\"date\"),\n// ALIASES\n        J(\"date\",\"D\"),\n// PRIOROITY\n        M(\"date\",9),\n// PARSING\n        Z(\"D\",Od),Z(\"DD\",Od,Kd),Z(\"Do\",function(a,b){return a?b._ordinalParse:b._ordinalParseLenient}),ba([\"D\",\"DD\"],ce),ba(\"Do\",function(a,b){b[ce]=u(a.match(Od)[0],10)});\n// MOMENTS\n    var Se=O(\"Date\",!0);\n// FORMATTING\n    U(\"DDD\",[\"DDDD\",3],\"DDDo\",\"dayOfYear\"),\n// ALIASES\n        J(\"dayOfYear\",\"DDD\"),\n// PRIORITY\n        M(\"dayOfYear\",4),\n// PARSING\n        Z(\"DDD\",Rd),Z(\"DDDD\",Ld),ba([\"DDD\",\"DDDD\"],function(a,b,c){c._dayOfYear=u(a)}),\n// FORMATTING\n        U(\"m\",[\"mm\",2],0,\"minute\"),\n// ALIASES\n        J(\"minute\",\"m\"),\n// PRIORITY\n        M(\"minute\",14),\n// PARSING\n        Z(\"m\",Od),Z(\"mm\",Od,Kd),ba([\"m\",\"mm\"],ee);\n// MOMENTS\n    var Te=O(\"Minutes\",!1);\n// FORMATTING\n    U(\"s\",[\"ss\",2],0,\"second\"),\n// ALIASES\n        J(\"second\",\"s\"),\n// PRIORITY\n        M(\"second\",15),\n// PARSING\n        Z(\"s\",Od),Z(\"ss\",Od,Kd),ba([\"s\",\"ss\"],fe);\n// MOMENTS\n    var Ue=O(\"Seconds\",!1);\n// FORMATTING\n    U(\"S\",0,0,function(){return~~(this.millisecond()/100)}),U(0,[\"SS\",2],0,function(){return~~(this.millisecond()/10)}),U(0,[\"SSS\",3],0,\"millisecond\"),U(0,[\"SSSS\",4],0,function(){return 10*this.millisecond()}),U(0,[\"SSSSS\",5],0,function(){return 100*this.millisecond()}),U(0,[\"SSSSSS\",6],0,function(){return 1e3*this.millisecond()}),U(0,[\"SSSSSSS\",7],0,function(){return 1e4*this.millisecond()}),U(0,[\"SSSSSSSS\",8],0,function(){return 1e5*this.millisecond()}),U(0,[\"SSSSSSSSS\",9],0,function(){return 1e6*this.millisecond()}),\n// ALIASES\n        J(\"millisecond\",\"ms\"),\n// PRIORITY\n        M(\"millisecond\",16),\n// PARSING\n        Z(\"S\",Rd,Jd),Z(\"SS\",Rd,Kd),Z(\"SSS\",Rd,Ld);var Ve;for(Ve=\"SSSS\";Ve.length<=9;Ve+=\"S\")Z(Ve,Ud);for(Ve=\"S\";Ve.length<=9;Ve+=\"S\")ba(Ve,Ic);\n// MOMENTS\n    var We=O(\"Milliseconds\",!1);\n// FORMATTING\n    U(\"z\",0,0,\"zoneAbbr\"),U(\"zz\",0,0,\"zoneName\");var Xe=r.prototype;Xe.add=Pe,Xe.calendar=Vb,Xe.clone=Wb,Xe.diff=bc,Xe.endOf=oc,Xe.format=gc,Xe.from=hc,Xe.fromNow=ic,Xe.to=jc,Xe.toNow=kc,Xe.get=R,Xe.invalidAt=xc,Xe.isAfter=Xb,Xe.isBefore=Yb,Xe.isBetween=Zb,Xe.isSame=$b,Xe.isSameOrAfter=_b,Xe.isSameOrBefore=ac,Xe.isValid=vc,Xe.lang=Re,Xe.locale=lc,Xe.localeData=mc,Xe.max=Ke,Xe.min=Je,Xe.parsingFlags=wc,Xe.set=S,Xe.startOf=nc,Xe.subtract=Qe,Xe.toArray=sc,Xe.toObject=tc,Xe.toDate=rc,Xe.toISOString=ec,Xe.inspect=fc,Xe.toJSON=uc,Xe.toString=dc,Xe.unix=qc,Xe.valueOf=pc,Xe.creationData=yc,\n// Year\n        Xe.year=pe,Xe.isLeapYear=ra,\n// Week Year\n        Xe.weekYear=Ac,Xe.isoWeekYear=Bc,\n// Quarter\n        Xe.quarter=Xe.quarters=Gc,\n// Month\n        Xe.month=ka,Xe.daysInMonth=la,\n// Week\n        Xe.week=Xe.weeks=Ba,Xe.isoWeek=Xe.isoWeeks=Ca,Xe.weeksInYear=Dc,Xe.isoWeeksInYear=Cc,\n// Day\n        Xe.date=Se,Xe.day=Xe.days=Ka,Xe.weekday=La,Xe.isoWeekday=Ma,Xe.dayOfYear=Hc,\n// Hour\n        Xe.hour=Xe.hours=ze,\n// Minute\n        Xe.minute=Xe.minutes=Te,\n// Second\n        Xe.second=Xe.seconds=Ue,\n// Millisecond\n        Xe.millisecond=Xe.milliseconds=We,\n// Offset\n        Xe.utcOffset=Db,Xe.utc=Fb,Xe.local=Gb,Xe.parseZone=Hb,Xe.hasAlignedHourOffset=Ib,Xe.isDST=Jb,Xe.isLocal=Lb,Xe.isUtcOffset=Mb,Xe.isUtc=Nb,Xe.isUTC=Nb,\n// Timezone\n        Xe.zoneAbbr=Jc,Xe.zoneName=Kc,\n// Deprecations\n        Xe.dates=x(\"dates accessor is deprecated. Use date instead.\",Se),Xe.months=x(\"months accessor is deprecated. Use month instead\",ka),Xe.years=x(\"years accessor is deprecated. Use year instead\",pe),Xe.zone=x(\"moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/\",Eb),Xe.isDSTShifted=x(\"isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information\",Kb);var Ye=C.prototype;Ye.calendar=D,Ye.longDateFormat=E,Ye.invalidDate=F,Ye.ordinal=G,Ye.preparse=Nc,Ye.postformat=Nc,Ye.relativeTime=H,Ye.pastFuture=I,Ye.set=A,\n// Month\n        Ye.months=fa,Ye.monthsShort=ga,Ye.monthsParse=ia,Ye.monthsRegex=na,Ye.monthsShortRegex=ma,\n// Week\n        Ye.week=ya,Ye.firstDayOfYear=Aa,Ye.firstDayOfWeek=za,\n// Day of Week\n        Ye.weekdays=Fa,Ye.weekdaysMin=Ha,Ye.weekdaysShort=Ga,Ye.weekdaysParse=Ja,Ye.weekdaysRegex=Na,Ye.weekdaysShortRegex=Oa,Ye.weekdaysMinRegex=Pa,\n// Hours\n        Ye.isPM=Va,Ye.meridiem=Wa,$a(\"en\",{ordinalParse:/\\d{1,2}(th|st|nd|rd)/,ordinal:function(a){var b=a%10,c=1===u(a%100/10)?\"th\":1===b?\"st\":2===b?\"nd\":3===b?\"rd\":\"th\";return a+c}}),\n// Side effect imports\n        a.lang=x(\"moment.lang is deprecated. Use moment.locale instead.\",$a),a.langData=x(\"moment.langData is deprecated. Use moment.localeData instead.\",bb);var Ze=Math.abs,$e=ed(\"ms\"),_e=ed(\"s\"),af=ed(\"m\"),bf=ed(\"h\"),cf=ed(\"d\"),df=ed(\"w\"),ef=ed(\"M\"),ff=ed(\"y\"),gf=gd(\"milliseconds\"),hf=gd(\"seconds\"),jf=gd(\"minutes\"),kf=gd(\"hours\"),lf=gd(\"days\"),mf=gd(\"months\"),nf=gd(\"years\"),of=Math.round,pf={s:45,// seconds to minute\n        m:45,// minutes to hour\n        h:22,// hours to day\n        d:26,// days to month\n        M:11},qf=Math.abs,rf=wb.prototype;\n// Deprecations\n// Side effect imports\n// FORMATTING\n// PARSING\n// Side effect imports\n    return rf.abs=Wc,rf.add=Yc,rf.subtract=Zc,rf.as=cd,rf.asMilliseconds=$e,rf.asSeconds=_e,rf.asMinutes=af,rf.asHours=bf,rf.asDays=cf,rf.asWeeks=df,rf.asMonths=ef,rf.asYears=ff,rf.valueOf=dd,rf._bubble=_c,rf.get=fd,rf.milliseconds=gf,rf.seconds=hf,rf.minutes=jf,rf.hours=kf,rf.days=lf,rf.weeks=hd,rf.months=mf,rf.years=nf,rf.humanize=md,rf.toISOString=nd,rf.toString=nd,rf.toJSON=nd,rf.locale=lc,rf.localeData=mc,rf.toIsoString=x(\"toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)\",nd),rf.lang=Re,U(\"X\",0,0,\"unix\"),U(\"x\",0,0,\"valueOf\"),Z(\"x\",Vd),Z(\"X\",Yd),ba(\"X\",function(a,b,c){c._d=new Date(1e3*parseFloat(a,10))}),ba(\"x\",function(a,b,c){c._d=new Date(u(a))}),a.version=\"2.17.1\",b(sb),a.fn=Xe,a.min=ub,a.max=vb,a.now=Le,a.utc=k,a.unix=Lc,a.months=Rc,a.isDate=g,a.locale=$a,a.invalid=o,a.duration=Ob,a.isMoment=s,a.weekdays=Tc,a.parseZone=Mc,a.localeData=bb,a.isDuration=xb,a.monthsShort=Sc,a.weekdaysMin=Vc,a.defineLocale=_a,a.updateLocale=ab,a.locales=cb,a.weekdaysShort=Uc,a.normalizeUnits=K,a.relativeTimeRounding=kd,a.relativeTimeThreshold=ld,a.calendarFormat=Ub,a.prototype=Xe,a});","requirejs-config.js":"(function(require){\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    'waitSeconds': 0,\n    'map': {\n        '*': {\n            'ko': 'knockoutjs/knockout',\n            'knockout': 'knockoutjs/knockout',\n            'mageUtils': 'mage/utils/main',\n            'rjsResolver': 'mage/requirejs/resolver'\n        }\n    },\n    'shim': {\n        'jquery/jquery-migrate': ['jquery'],\n        'jquery/jquery.hashchange': ['jquery', 'jquery/jquery-migrate'],\n        'jquery/jstree/jquery.hotkeys': ['jquery'],\n        'jquery/hover-intent': ['jquery'],\n        'mage/adminhtml/backup': ['prototype'],\n        'mage/captcha': ['prototype'],\n        'mage/common': ['jquery'],\n        'mage/new-gallery': ['jquery'],\n        'mage/webapi': ['jquery'],\n        'jquery/ui': ['jquery'],\n        'MutationObserver': ['es6-collections'],\n        'tinymce': {\n            'exports': 'tinymce'\n        },\n        'moment': {\n            'exports': 'moment'\n        },\n        'matchMedia': {\n            'exports': 'mediaCheck'\n        },\n        'jquery/jquery-storageapi': {\n            'deps': ['jquery/jquery.cookie']\n        }\n    },\n    'paths': {\n        'jquery/validate': 'jquery/jquery.validate',\n        'jquery/hover-intent': 'jquery/jquery.hoverIntent',\n        'jquery/file-uploader': 'jquery/fileUploader/jquery.fileupload-fp',\n        'jquery/jquery.hashchange': 'jquery/jquery.ba-hashchange.min',\n        'prototype': 'legacy-build.min',\n        'jquery/jquery-storageapi': 'jquery/jquery.storageapi.min',\n        'text': 'mage/requirejs/text',\n        'domReady': 'requirejs/domReady',\n        'tinymce': 'tiny_mce/tiny_mce_src'\n    },\n    'deps': [\n        'jquery/jquery-migrate'\n    ],\n    'config': {\n        'mixins': {\n            'jquery/jstree/jquery.jstree': {\n                'mage/backend/jstree-mixin': true\n            }\n        },\n        'text': {\n            'headers': {\n                'X-Requested-With': 'XMLHttpRequest'\n            }\n        }\n    }\n};\n\nrequire(['jquery'], function ($) {\n    'use strict';\n\n    $.noConflict();\n});\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'rowBuilder':             'Magento_Theme/js/row-builder',\n            'toggleAdvanced':         'mage/toggle',\n            'translateInline':        'mage/translate-inline',\n            'sticky':                 'mage/sticky',\n            'tabs':                   'mage/tabs',\n            'zoom':                   'mage/zoom',\n            'collapsible':            'mage/collapsible',\n            'dropdownDialog':         'mage/dropdown',\n            'dropdown':               'mage/dropdowns',\n            'accordion':              'mage/accordion',\n            'loader':                 'mage/loader',\n            'tooltip':                'mage/tooltip',\n            'deletableItem':          'mage/deletable-item',\n            'itemTable':              'mage/item-table',\n            'fieldsetControls':       'mage/fieldset-controls',\n            'fieldsetResetControl':   'mage/fieldset-controls',\n            'redirectUrl':            'mage/redirect-url',\n            'loaderAjax':             'mage/loader',\n            'menu':                   'mage/menu',\n            'popupWindow':            'mage/popup-window',\n            'validation':             'mage/validation/validation',\n            'welcome':                'Magento_Theme/js/view/welcome'\n        }\n    },\n    paths: {\n        'jquery/ui': 'jquery/jquery-ui'\n    },\n    deps: [\n        'jquery/jquery.mobile.custom',\n        'mage/common',\n        'mage/dataPost',\n        'mage/bootstrap'\n    ]\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            checkoutBalance:    'Magento_Customer/js/checkout-balance',\n            address:            'Magento_Customer/address',\n            changeEmailPassword: 'Magento_Customer/change-email-password',\n            passwordStrengthIndicator: 'Magento_Customer/js/password-strength-indicator',\n            zxcvbn: 'Magento_Customer/js/zxcvbn',\n            addressValidation: 'Magento_Customer/js/addressValidation'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            compareList:            'Magento_Catalog/js/list',\n            relatedProducts:        'Magento_Catalog/js/related-products',\n            upsellProducts:         'Magento_Catalog/js/upsell-products',\n            productListToolbarForm: 'Magento_Catalog/js/product/list/toolbar',\n            catalogGallery:         'Magento_Catalog/js/gallery',\n            priceBox:               'Magento_Catalog/js/price-box',\n            priceOptionDate:        'Magento_Catalog/js/price-option-date',\n            priceOptionFile:        'Magento_Catalog/js/price-option-file',\n            priceOptions:           'Magento_Catalog/js/price-options',\n            priceUtils:             'Magento_Catalog/js/price-utils',\n            catalogAddToCart:       'Magento_Catalog/js/catalog-add-to-cart'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            quickSearch: 'Magento_Search/form-mini'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            creditCardType: 'Magento_Payment/cc-type'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            addToCart: 'Magento_Msrp/js/msrp'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            requireCookie: 'Magento_Cookie/js/require-cookie',\n            cookieNotices: 'Magento_Cookie/js/notices'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            giftMessage:    'Magento_Sales/gift-message',\n            ordersReturns:  'Magento_Sales/orders-returns'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            downloadable: 'Magento_Downloadable/downloadable'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            bundleOption:   'Magento_Bundle/bundle',\n            priceBundle:    'Magento_Bundle/js/price-bundle',\n            slide:          'Magento_Bundle/js/slide',\n            productSummary: 'Magento_Bundle/js/product-summary'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            giftOptions:    'Magento_GiftMessage/gift-options',\n            extraOptions:   'Magento_GiftMessage/extra-options'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            discountCode:           'Magento_Checkout/js/discount-codes',\n            shoppingCart:           'Magento_Checkout/js/shopping-cart',\n            regionUpdater:          'Magento_Checkout/js/region-updater',\n            sidebar:                'Magento_Checkout/js/sidebar',\n            checkoutLoader:         'Magento_Checkout/js/checkout-loader',\n            checkoutData:           'Magento_Checkout/js/checkout-data',\n            proceedToCheckout:      'Magento_Checkout/js/proceed-to-checkout'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    paths: {\n        'ui/template': 'Magento_Ui/templates'\n    },\n    map: {\n        '*': {\n            uiElement:      'Magento_Ui/js/lib/core/element/element',\n            uiCollection:   'Magento_Ui/js/lib/core/collection',\n            uiComponent:    'Magento_Ui/js/lib/core/collection',\n            uiClass:        'Magento_Ui/js/lib/core/class',\n            uiEvents:       'Magento_Ui/js/lib/core/events',\n            uiRegistry:     'Magento_Ui/js/lib/registry/registry',\n            consoleLogger:  'Magento_Ui/js/lib/logger/console-logger',\n            uiLayout:       'Magento_Ui/js/core/renderer/layout',\n            buttonAdapter:  'Magento_Ui/js/form/button-adapter'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            configurable: 'Magento_ConfigurableProduct/js/configurable'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            multiShipping: 'Magento_Multishipping/js/multi-shipping',\n            orderOverview: 'Magento_Multishipping/js/overview',\n            payment: 'Magento_Multishipping/js/payment'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            recentlyViewedProducts: 'Magento_Reports/js/recently-viewed'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            pageCache:  'Magento_PageCache/js/page-cache'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            orderReview: 'Magento_Paypal/order-review',\n            paypalCheckout: 'Magento_Paypal/js/paypal-checkout'\n        }\n    },\n    paths: {\n        paypalInContextExpressCheckout: 'https://www.paypalobjects.com/api/checkout'\n    },\n    shim: {\n        paypalInContextExpressCheckout: {\n            exports: 'paypal'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            transparent: 'Magento_Payment/transparent'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            loadPlayer: 'Magento_ProductVideo/js/load-player',\n            fotoramaVideoEvents: 'Magento_ProductVideo/js/fotorama-add-video-events'\n        }\n    },\n    shim: {\n        vimeoAPI: {}\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/action/place-order': {\n                'Magento_CheckoutAgreements/js/model/place-order-mixin': true\n            },\n            'Magento_Checkout/js/action/set-payment-information': {\n                'Magento_CheckoutAgreements/js/model/set-payment-information-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            captcha: 'Magento_Captcha/captcha'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            catalogSearch: 'Magento_CatalogSearch/form-mini'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            wishlist:       'Magento_Wishlist/js/wishlist',\n            addToWishlist:  'Magento_Wishlist/js/add-to-wishlist',\n            wishlistSearch: 'Magento_Wishlist/js/search'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            transparent: 'Magento_Payment/transparent'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            editTrigger: 'mage/edit-trigger',\n            addClass: 'Magento_Translation/add-class'\n        }\n    },\n    deps: [\n        'mage/translate-inline'\n    ]\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            braintree: 'https://js.braintreegateway.com/js/braintree-2.32.0.min.js'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'taxToggle': 'Magento_Weee/tax-toggle'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    'paths': {\n        'trackingCode': 'Dotdigitalgroup_Email/js/trackingCode'\n    },\n    'shim': {\n        'trackingCode': {\n            exports: '_dmTrack'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    paths: {\n        temandoCheckoutFieldsDefinition: 'Temando_Shipping/js/model/fields-definition',\n        temandoCustomerAddressRateProcessor: 'Temando_Shipping/js/model/shipping-rate-processor/customer-address',\n        temandoNewAddressRateProcessor: 'Temando_Shipping/js/model/shipping-rate-processor/new-address',\n        temandoShippingRatesValidator: 'Temando_Shipping/js/model/shipping-rates-validator/temando',\n        temandoShippingRatesValidationRules: 'Temando_Shipping/js/model/shipping-rates-validation-rules/temando'\n    },\n    map: {\n        'Magento_Checkout/js/model/shipping-rate-service': {\n            'Magento_Checkout/js/model/shipping-rate-processor/customer-address' : 'temandoCustomerAddressRateProcessor',\n            'Magento_Checkout/js/model/shipping-rate-processor/new-address' : 'temandoNewAddressRateProcessor'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    deps: [\n        'Magento_Theme/js/responsive',\n        'Magento_Theme/js/theme'\n    ]\n};\n\nrequire.config(config);\n})();\n\n\n\n})(require);","matchMedia.js":"/*! matchMedia() polyfill - Test a CSS media type/query in JS. Authors & copyright (c) 2012: Scott Jehl, Paul Irish, Nicholas Zakas, David Knight. Dual MIT/BSD license */\n\nwindow.matchMedia || (window.matchMedia = function() {\n    \"use strict\";\n\n    // For browsers that support matchMedium api such as IE 9 and webkit\n    var styleMedia = (window.styleMedia || window.media);\n\n    // For those that don't support matchMedium\n    if (!styleMedia) {\n        var style = document.createElement('style'),\n            script = document.getElementsByTagName('script')[0],\n            info = null;\n\n        style.type = 'text/css';\n        style.id = 'matchmediajs-test';\n\n        script.parentNode.insertBefore(style, script);\n\n        // 'style.currentStyle' is used by IE <= 8 and 'window.getComputedStyle' for all other browsers\n        info = ('getComputedStyle' in window) && window.getComputedStyle(style, null) || style.currentStyle;\n\n        styleMedia = {\n            matchMedium: function(media) {\n                var text = '@media ' + media + '{ #matchmediajs-test { width: 1px; } }';\n\n                // 'style.styleSheet' is used by IE <= 8 and 'style.textContent' for all other browsers\n                if (style.styleSheet) {\n                    style.styleSheet.cssText = text;\n                } else {\n                    style.textContent = text;\n                }\n\n                // Test if media query is true or false\n                return info.width === '1px';\n            }\n        };\n    }\n\n    return function(media) {\n        return {\n            matches: styleMedia.matchMedium(media || 'all'),\n            media: media || 'all'\n        };\n    };\n}());\n\n/*! matchMedia() polyfill addListener/removeListener extension. Author & copyright (c) 2012: Scott Jehl. Dual MIT/BSD license */\n(function() {\n    // Bail out for browsers that have addListener support\n    if (window.matchMedia && window.matchMedia('all').addListener) {\n        return false;\n    }\n\n    var localMatchMedia = window.matchMedia,\n        hasMediaQueries = localMatchMedia('only all').matches,\n        isListening = false,\n        timeoutID = 0, // setTimeout for debouncing 'handleChange'\n        queries = [], // Contains each 'mql' and associated 'listeners' if 'addListener' is used\n        handleChange = function(evt) {\n            // Debounce\n            clearTimeout(timeoutID);\n\n            timeoutID = setTimeout(function() {\n                for (var i = 0, il = queries.length; i < il; i++) {\n                    var mql = queries[i].mql,\n                        listeners = queries[i].listeners || [],\n                        matches = localMatchMedia(mql.media).matches;\n\n                    // Update mql.matches value and call listeners\n                    // Fire listeners only if transitioning to or from matched state\n                    if (matches !== mql.matches) {\n                        mql.matches = matches;\n\n                        for (var j = 0, jl = listeners.length; j < jl; j++) {\n                            listeners[j].call(window, mql);\n                        }\n                    }\n                }\n            }, 30);\n        };\n\n    window.matchMedia = function(media) {\n        var mql = localMatchMedia(media),\n            listeners = [],\n            index = 0;\n\n        mql.addListener = function(listener) {\n            // Changes would not occur to css media type so return now (Affects IE <= 8)\n            if (!hasMediaQueries) {\n                return;\n            }\n\n            // Set up 'resize' listener for browsers that support CSS3 media queries (Not for IE <= 8)\n            // There should only ever be 1 resize listener running for performance\n            if (!isListening) {\n                isListening = true;\n                window.addEventListener('resize', handleChange, true);\n            }\n\n            // Push object only if it has not been pushed already\n            if (index === 0) {\n                index = queries.push({\n                    mql: mql,\n                    listeners: listeners\n                });\n            }\n\n            listeners.push(listener);\n        };\n\n        mql.removeListener = function(listener) {\n            for (var i = 0, il = listeners.length; i < il; i++) {\n                if (listeners[i] === listener) {\n                    listeners.splice(i, 1);\n                }\n            }\n        };\n\n        return mql;\n    };\n}());\n\nwindow.mediaCheck = function(options) {\n    var mq;\n\n    function mqChange(mq, options) {\n        if (mq.matches) {\n            if (typeof options.entry === \"function\") {\n                options.entry();\n            }\n        } else if (typeof options.exit === \"function\") {\n            options.exit();\n        }\n    };\n\n    mq = window.matchMedia(options.media);\n\n    mq.addListener(function() {\n        mqChange(mq, options);\n    });\n\n    mqChange(mq, options);\n};","es6-collections.js":"(function (exports) {'use strict';\n  //shared pointer\n  var i;\n  //shortcuts\n  var defineProperty = Object.defineProperty, is = function(a,b) { return isNaN(a)? isNaN(b): a === b; };\n\n\n  //Polyfill global objects\n  if (typeof WeakMap == 'undefined') {\n    exports.WeakMap = createCollection({\n      // WeakMap#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // WeakMap#clear():\n      clear: sharedClear,\n      // WeakMap#get(key:void*):void*\n      get: sharedGet,\n      // WeakMap#has(key:void*):boolean\n      has: mapHas,\n      // WeakMap#set(key:void*, value:void*):void\n      set: sharedSet\n    }, true);\n  }\n\n  if (typeof Map == 'undefined' || typeof ((new Map).values) !== 'function' || !(new Map).values().next) {\n    exports.Map = createCollection({\n      // WeakMap#delete(key:void*):boolean\n      'delete': sharedDelete,\n      //:was Map#get(key:void*[, d3fault:void*]):void*\n      // Map#has(key:void*):boolean\n      has: mapHas,\n      // Map#get(key:void*):boolean\n      get: sharedGet,\n      // Map#set(key:void*, value:void*):void\n      set: sharedSet,\n      // Map#keys(void):Iterator\n      keys: sharedKeys,\n      // Map#values(void):Iterator\n      values: sharedValues,\n      // Map#entries(void):Iterator\n      entries: mapEntries,\n      // Map#forEach(callback:Function, context:void*):void ==> callback.call(context, key, value, mapObject) === not in specs`\n      forEach: sharedForEach,\n      // Map#clear():\n      clear: sharedClear\n    });\n  }\n\n  if (typeof Set == 'undefined' || typeof ((new Set).values) !== 'function' || !(new Set).values().next) {\n    exports.Set = createCollection({\n      // Set#has(value:void*):boolean\n      has: setHas,\n      // Set#add(value:void*):boolean\n      add: sharedAdd,\n      // Set#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // Set#clear():\n      clear: sharedClear,\n      // Set#keys(void):Iterator\n      keys: sharedValues, // specs actually say \"the same function object as the initial value of the values property\"\n      // Set#values(void):Iterator\n      values: sharedValues,\n      // Set#entries(void):Iterator\n      entries: setEntries,\n      // Set#forEach(callback:Function, context:void*):void ==> callback.call(context, value, index) === not in specs\n      forEach: sharedForEach\n    });\n  }\n\n  if (typeof WeakSet == 'undefined') {\n    exports.WeakSet = createCollection({\n      // WeakSet#delete(key:void*):boolean\n      'delete': sharedDelete,\n      // WeakSet#add(value:void*):boolean\n      add: sharedAdd,\n      // WeakSet#clear():\n      clear: sharedClear,\n      // WeakSet#has(value:void*):boolean\n      has: setHas\n    }, true);\n  }\n\n\n  /**\n   * ES6 collection constructor\n   * @return {Function} a collection class\n   */\n  function createCollection(proto, objectOnly){\n    function Collection(a){\n      if (!this || this.constructor !== Collection) return new Collection(a);\n      this._keys = [];\n      this._values = [];\n      this._itp = []; // iteration pointers\n      this.objectOnly = objectOnly;\n\n      //parse initial iterable argument passed\n      if (a) init.call(this, a);\n    }\n\n    //define size for non object-only collections\n    if (!objectOnly) {\n      defineProperty(proto, 'size', {\n        get: sharedSize\n      });\n    }\n\n    //set prototype\n    proto.constructor = Collection;\n    Collection.prototype = proto;\n\n    return Collection;\n  }\n\n\n  /** parse initial iterable argument passed */\n  function init(a){\n    var i;\n    //init Set argument, like `[1,2,3,{}]`\n    if (this.add)\n      a.forEach(this.add, this);\n    //init Map argument like `[[1,2], [{}, 4]]`\n    else\n      a.forEach(function(a){this.set(a[0],a[1])}, this);\n  }\n\n\n  /** delete */\n  function sharedDelete(key) {\n    if (this.has(key)) {\n      this._keys.splice(i, 1);\n      this._values.splice(i, 1);\n      // update iteration pointers\n      this._itp.forEach(function(p) { if (i < p[0]) p[0]--; });\n    }\n    // Aurora here does it while Canary doesn't\n    return -1 < i;\n  };\n\n  function sharedGet(key) {\n    return this.has(key) ? this._values[i] : undefined;\n  }\n\n  function has(list, key) {\n    if (this.objectOnly && key !== Object(key))\n      throw new TypeError(\"Invalid value used as weak collection key\");\n    //NaN or 0 passed\n    if (key != key || key === 0) for (i = list.length; i-- && !is(list[i], key);){}\n    else i = list.indexOf(key);\n    return -1 < i;\n  }\n\n  function setHas(value) {\n    return has.call(this, this._values, value);\n  }\n\n  function mapHas(value) {\n    return has.call(this, this._keys, value);\n  }\n\n  /** @chainable */\n  function sharedSet(key, value) {\n    this.has(key) ?\n      this._values[i] = value\n      :\n      this._values[this._keys.push(key) - 1] = value\n    ;\n    return this;\n  }\n\n  /** @chainable */\n  function sharedAdd(value) {\n    if (!this.has(value)) this._values.push(value);\n    return this;\n  }\n\n  function sharedClear() {\n    this._values.length = 0;\n  }\n\n  /** keys, values, and iterate related methods */\n  function sharedKeys() {\n    return sharedIterator(this._itp, this._keys);\n  }\n\n  function sharedValues() {\n    return sharedIterator(this._itp, this._values);\n  }\n\n  function mapEntries() {\n    return sharedIterator(this._itp, this._keys, this._values);\n  }\n\n  function setEntries() {\n    return sharedIterator(this._itp, this._values, this._values);\n  }\n\n  function sharedIterator(itp, array, array2) {\n    var p = [0], done = false;\n    itp.push(p);\n    return {\n      next: function() {\n        var v, k = p[0];\n        if (!done && k < array.length) {\n          v = array2 ? [array[k], array2[k]]: array[k];\n          p[0]++;\n        } else {\n          done = true;\n          itp.splice(itp.indexOf(p), 1);\n        }\n        return { done: done, value: v };\n      }\n    };\n  }\n\n  function sharedSize() {\n    return this._values.length;\n  }\n\n  function sharedForEach(callback, context) {\n    var it = this.entries();\n    for (;;) {\n      var r = it.next();\n      if (r.done) break;\n      callback.call(context, r.value[1], r.value[0], this);\n    }\n  }\n\n})(typeof exports != 'undefined' && typeof global != 'undefined' ? global : window );","FormData.js":"/*\n * FormData for XMLHttpRequest 2  -  Polyfill for Web Worker\n * (c) 2014 Rob Wu <rob@robwu.nl>\n * License: MIT\n * - append(name, value[, filename])\n * - XMLHttpRequest.prototype.send(object FormData)\n * \n * Specification: http://www.w3.org/TR/XMLHttpRequest/#formdata\n *                http://www.w3.org/TR/XMLHttpRequest/#the-send-method\n * The .append() implementation also accepts Uint8Array and ArrayBuffer objects\n * Web Workers do not natively support FormData:\n *                http://dev.w3.org/html5/workers/#apis-available-to-workers\n * Originally released in 2012 as a part of http://stackoverflow.com/a/10002486.\n * Updates since initial release:\n * - Forward-compatibility by testing whether FormData exists before defining it.\n * - Increased robustness of .append.\n * - Allow any typed array in .append.\n * - Remove use of String.prototype.toString to work around a Firefox bug.\n * - Use typed array in xhr.send instead of arraybuffer to get rid of deprecation\n *   warnings.\n **/\n(function(exports) {\n    if (exports.FormData) {\n        // Don't replace FormData if it already exists\n        return;\n    }\n    // Export variable to the global scope\n    exports.FormData = FormData;\n\n    var ___send$rw = XMLHttpRequest.prototype.send;\n    XMLHttpRequest.prototype.send = function(data) {\n        if (data instanceof FormData) {\n            if (!data.__endedMultipart) data.__append('--' + data.boundary + '--\\r\\n');\n            data.__endedMultipart = true;\n            this.setRequestHeader('Content-Type', 'multipart/form-data; boundary=' + data.boundary);\n            data = new Uint8Array(data.data);\n        }\n        // Invoke original XHR.send\n        return ___send$rw.call(this, data);\n    };\n\n    function FormData() {\n        // Force a Constructor\n        if (!(this instanceof FormData)) return new FormData();\n        // Generate a random boundary - This must be unique with respect to the form's contents.\n        this.boundary = '------RWWorkerFormDataBoundary' + Math.random().toString(36);\n        var internal_data = this.data = [];\n        /**\n         * Internal method.\n         * @param inp String | ArrayBuffer | Uint8Array  Input\n         */\n        this.__append = function(inp) {\n            var i = 0, len;\n            if (typeof inp == 'string') {\n                for (len = inp.length; i < len; ++i)\n                    internal_data.push(inp.charCodeAt(i) & 0xff);\n            } else if (inp && inp.byteLength) {/*If ArrayBuffer or typed array */\n                if (!('byteOffset' in inp))   /* If ArrayBuffer, wrap in view */\n                    inp = new Uint8Array(inp);\n                for (len = inp.byteLength; i < len; ++i)\n                    internal_data.push(inp[i] & 0xff);\n            }\n        };\n    }\n    /**\n     * @param name     String                                   Key name\n     * @param value    String|Blob|File|typed array|ArrayBuffer Value\n     * @param filename String                                   Optional File name (when value is not a string).\n     **/\n    FormData.prototype.append = function(name, value, filename) {\n        if (this.__endedMultipart) {\n            // Truncate the closing boundary\n            this.data.length -= this.boundary.length + 6;\n            this.__endedMultipart = false;\n        }\n        if (arguments.length < 2) {\n            throw new SyntaxError('Not enough arguments');\n        }\n        var part = '--' + this.boundary + '\\r\\n' +\n            'Content-Disposition: form-data; name=\"' + name + '\"';\n\n        if (value instanceof File || value instanceof Blob) {\n            return this.append(name,\n                new Uint8Array(new FileReaderSync().readAsArrayBuffer(value)),\n                filename || value.name);\n        } else if (typeof value.byteLength == 'number') {\n            // Duck-typed typed array or array buffer\n            part += '; filename=\"'+ (filename || 'blob').replace(/\"/g,'%22') +'\"\\r\\n';\n            part += 'Content-Type: application/octet-stream\\r\\n\\r\\n';\n            this.__append(part);\n            this.__append(value);\n            part = '\\r\\n';\n        } else {\n            part += '\\r\\n\\r\\n' + value + '\\r\\n';\n        }\n        this.__append(part);\n    };\n})(this || self);\n","moment-timezone-with-data.js":"//! moment-timezone.js\n//! version : 0.5.5\n//! author : Tim Wood\n//! license : MIT\n//! github.com/moment/moment-timezone\n!function(a,b){\"use strict\";\"function\"==typeof define&&define.amd?define([\"moment\"],b):\"object\"==typeof module&&module.exports?module.exports=b(require(\"moment\")):b(a.moment)}(this,function(a){\"use strict\";function b(a){return a>96?a-87:a>64?a-29:a-48}function c(a){var c,d=0,e=a.split(\".\"),f=e[0],g=e[1]||\"\",h=1,i=0,j=1;for(45===a.charCodeAt(0)&&(d=1,j=-1),d;d<f.length;d++)c=b(f.charCodeAt(d)),i=60*i+c;for(d=0;d<g.length;d++)h/=60,c=b(g.charCodeAt(d)),i+=c*h;return i*j}function d(a){for(var b=0;b<a.length;b++)a[b]=c(a[b])}function e(a,b){for(var c=0;c<b;c++)a[c]=Math.round((a[c-1]||0)+6e4*a[c]);a[b-1]=1/0}function f(a,b){var c,d=[];for(c=0;c<b.length;c++)d[c]=a[b[c]];return d}function g(a){var b=a.split(\"|\"),c=b[2].split(\" \"),g=b[3].split(\"\"),h=b[4].split(\" \");return d(c),d(g),d(h),e(h,g.length),{name:b[0],abbrs:f(b[1].split(\" \"),g),offsets:f(c,g),untils:h,population:0|b[5]}}function h(a){a&&this._set(g(a))}function i(a){var b=a.toTimeString(),c=b.match(/\\([a-z ]+\\)/i);c&&c[0]?(c=c[0].match(/[A-Z]/g),c=c?c.join(\"\"):void 0):(c=b.match(/[A-Z]{3,5}/g),c=c?c[0]:void 0),\"GMT\"===c&&(c=void 0),this.at=+a,this.abbr=c,this.offset=a.getTimezoneOffset()}function j(a){this.zone=a,this.offsetScore=0,this.abbrScore=0}function k(a,b){for(var c,d;d=6e4*((b.at-a.at)/12e4|0);)c=new i(new Date(a.at+d)),c.offset===a.offset?a=c:b=c;return a}function l(){var a,b,c,d=(new Date).getFullYear()-2,e=new i(new Date(d,0,1)),f=[e];for(c=1;c<48;c++)b=new i(new Date(d,c,1)),b.offset!==e.offset&&(a=k(e,b),f.push(a),f.push(new i(new Date(a.at+6e4)))),e=b;for(c=0;c<4;c++)f.push(new i(new Date(d+c,0,1))),f.push(new i(new Date(d+c,6,1)));return f}function m(a,b){return a.offsetScore!==b.offsetScore?a.offsetScore-b.offsetScore:a.abbrScore!==b.abbrScore?a.abbrScore-b.abbrScore:b.zone.population-a.zone.population}function n(a,b){var c,e;for(d(b),c=0;c<b.length;c++)e=b[c],I[e]=I[e]||{},I[e][a]=!0}function o(a){var b,c,d,e=a.length,f={},g=[];for(b=0;b<e;b++){d=I[a[b].offset]||{};for(c in d)d.hasOwnProperty(c)&&(f[c]=!0)}for(b in f)f.hasOwnProperty(b)&&g.push(H[b]);return g}function p(){try{var a=Intl.DateTimeFormat().resolvedOptions().timeZone;if(a){var b=H[r(a)];if(b)return b;z(\"Moment Timezone found \"+a+\" from the Intl api, but did not have that data loaded.\")}}catch(c){}var d,e,f,g=l(),h=g.length,i=o(g),k=[];for(e=0;e<i.length;e++){for(d=new j(t(i[e]),h),f=0;f<h;f++)d.scoreOffsetAt(g[f]);k.push(d)}return k.sort(m),k.length>0?k[0].zone.name:void 0}function q(a){return D&&!a||(D=p()),D}function r(a){return(a||\"\").toLowerCase().replace(/\\//g,\"_\")}function s(a){var b,c,d,e;for(\"string\"==typeof a&&(a=[a]),b=0;b<a.length;b++)d=a[b].split(\"|\"),c=d[0],e=r(c),F[e]=a[b],H[e]=c,d[5]&&n(e,d[2].split(\" \"))}function t(a,b){a=r(a);var c,d=F[a];return d instanceof h?d:\"string\"==typeof d?(d=new h(d),F[a]=d,d):G[a]&&b!==t&&(c=t(G[a],t))?(d=F[a]=new h,d._set(c),d.name=H[a],d):null}function u(){var a,b=[];for(a in H)H.hasOwnProperty(a)&&(F[a]||F[G[a]])&&H[a]&&b.push(H[a]);return b.sort()}function v(a){var b,c,d,e;for(\"string\"==typeof a&&(a=[a]),b=0;b<a.length;b++)c=a[b].split(\"|\"),d=r(c[0]),e=r(c[1]),G[d]=e,H[d]=c[0],G[e]=d,H[e]=c[1]}function w(a){s(a.zones),v(a.links),A.dataVersion=a.version}function x(a){return x.didShowError||(x.didShowError=!0,z(\"moment.tz.zoneExists('\"+a+\"') has been deprecated in favor of !moment.tz.zone('\"+a+\"')\")),!!t(a)}function y(a){return!(!a._a||void 0!==a._tzm)}function z(a){\"undefined\"!=typeof console&&\"function\"==typeof console.error&&console.error(a)}function A(b){var c=Array.prototype.slice.call(arguments,0,-1),d=arguments[arguments.length-1],e=t(d),f=a.utc.apply(null,c);return e&&!a.isMoment(b)&&y(f)&&f.add(e.parse(f),\"minutes\"),f.tz(d),f}function B(a){return function(){return this._z?this._z.abbr(this):a.call(this)}}function C(a){return function(){return this._z=null,a.apply(this,arguments)}}if(void 0!==a.tz)return z(\"Moment Timezone \"+a.tz.version+\" was already loaded \"+(a.tz.dataVersion?\"with data from \":\"without any data\")+a.tz.dataVersion),a;var D,E=\"0.5.5\",F={},G={},H={},I={},J=a.version.split(\".\"),K=+J[0],L=+J[1];(K<2||2===K&&L<6)&&z(\"Moment Timezone requires Moment.js >= 2.6.0. You are using Moment.js \"+a.version+\". See momentjs.com\"),h.prototype={_set:function(a){this.name=a.name,this.abbrs=a.abbrs,this.untils=a.untils,this.offsets=a.offsets,this.population=a.population},_index:function(a){var b,c=+a,d=this.untils;for(b=0;b<d.length;b++)if(c<d[b])return b},parse:function(a){var b,c,d,e,f=+a,g=this.offsets,h=this.untils,i=h.length-1;for(e=0;e<i;e++)if(b=g[e],c=g[e+1],d=g[e?e-1:e],b<c&&A.moveAmbiguousForward?b=c:b>d&&A.moveInvalidForward&&(b=d),f<h[e]-6e4*b)return g[e];return g[i]},abbr:function(a){return this.abbrs[this._index(a)]},offset:function(a){return this.offsets[this._index(a)]}},j.prototype.scoreOffsetAt=function(a){this.offsetScore+=Math.abs(this.zone.offset(a.at)-a.offset),this.zone.abbr(a.at).replace(/[^A-Z]/g,\"\")!==a.abbr&&this.abbrScore++},A.version=E,A.dataVersion=\"\",A._zones=F,A._links=G,A._names=H,A.add=s,A.link=v,A.load=w,A.zone=t,A.zoneExists=x,A.guess=q,A.names=u,A.Zone=h,A.unpack=g,A.unpackBase60=c,A.needsOffset=y,A.moveInvalidForward=!0,A.moveAmbiguousForward=!1;var M=a.fn;a.tz=A,a.defaultZone=null,a.updateOffset=function(b,c){var d,e=a.defaultZone;void 0===b._z&&(e&&y(b)&&!b._isUTC&&(b._d=a.utc(b._a)._d,b.utc().add(e.parse(b),\"minutes\")),b._z=e),b._z&&(d=b._z.offset(b),Math.abs(d)<16&&(d/=60),void 0!==b.utcOffset?b.utcOffset(-d,c):b.zone(d,c))},M.tz=function(b){return b?(this._z=t(b),this._z?a.updateOffset(this):z(\"Moment Timezone has no data for \"+b+\". See http://momentjs.com/timezone/docs/#/data-loading/.\"),this):this._z?this._z.name:void 0},M.zoneName=B(M.zoneName),M.zoneAbbr=B(M.zoneAbbr),M.utc=C(M.utc),a.tz.setDefault=function(b){return(K<2||2===K&&L<9)&&z(\"Moment Timezone setDefault() requires Moment.js >= 2.9.0. You are using Moment.js \"+a.version+\".\"),a.defaultZone=b?t(b):null,a};var N=a.momentProperties;return\"[object Array]\"===Object.prototype.toString.call(N)?(N.push(\"_z\"),N.push(\"_a\")):N&&(N._z=null),w({version:\"2016f\",zones:[\"Africa/Abidjan|LMT GMT|g.8 0|01|-2ldXH.Q|48e5\",\"Africa/Accra|LMT GMT GHST|.Q 0 -k|012121212121212121212121212121212121212121212121|-26BbX.8 6tzX.8 MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE 1BAk MnE 1C0k MnE 1BAk MnE 1BAk MnE|41e5\",\"Africa/Nairobi|LMT EAT BEAT BEAUT|-2r.g -30 -2u -2J|01231|-1F3Cr.g 3Dzr.g okMu MFXJ|47e5\",\"Africa/Algiers|PMT WET WEST CET CEST|-9.l 0 -10 -10 -20|0121212121212121343431312123431213|-2nco9.l cNb9.l HA0 19A0 1iM0 11c0 1oo0 Wo0 1rc0 QM0 1EM0 UM0 DA0 Imo0 rd0 De0 9Xz0 1fb0 1ap0 16K0 2yo0 mEp0 hwL0 jxA0 11A0 dDd0 17b0 11B0 1cN0 2Dy0 1cN0 1fB0 1cL0|26e5\",\"Africa/Lagos|LMT WAT|-d.A -10|01|-22y0d.A|17e6\",\"Africa/Bissau|LMT WAT GMT|12.k 10 0|012|-2ldWV.E 2xonV.E|39e4\",\"Africa/Maputo|LMT CAT|-2a.k -20|01|-2GJea.k|26e5\",\"Africa/Cairo|EET EEST|-20 -30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-1bIO0 vb0 1ip0 11z0 1iN0 1nz0 12p0 1pz0 10N0 1pz0 16p0 1jz0 s3d0 Vz0 1oN0 11b0 1oO0 10N0 1pz0 10N0 1pb0 10N0 1pb0 10N0 1pb0 10N0 1pz0 10N0 1pb0 10N0 1pb0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1WL0 rd0 1Rz0 wp0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1qL0 Xd0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1ny0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 WL0 1qN0 Rb0 1wp0 On0 1zd0 Lz0 1EN0 Fb0 c10 8n0 8Nd0 gL0 e10 mn0|15e6\",\"Africa/Casablanca|LMT WET WEST CET|u.k 0 -10 -10|0121212121212121213121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2gMnt.E 130Lt.E rb0 Dd0 dVb0 b6p0 TX0 EoB0 LL0 gnd0 rz0 43d0 AL0 1Nd0 XX0 1Cp0 pz0 dEp0 4mn0 SyN0 AL0 1Nd0 wn0 1FB0 Db0 1zd0 Lz0 1Nf0 wM0 co0 go0 1o00 s00 dA0 vc0 11A0 A00 e00 y00 11A0 uM0 e00 Dc0 11A0 s00 e00 IM0 WM0 mo0 gM0 LA0 WM0 jA0 e00 Rc0 11A0 e00 e00 U00 11A0 8o0 e00 11A0 11A0 5A0 e00 17c0 1fA0 1a00 1a00 1fA0 17c0 1io0 14o0 1lc0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1lc0 14o0 1fA0|32e5\",\"Africa/Ceuta|WET WEST CET CEST|0 -10 -10 -20|010101010101010101010232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-25KN0 11z0 drd0 18o0 3I00 17c0 1fA0 1a00 1io0 1a00 1y7p0 LL0 gnd0 rz0 43d0 AL0 1Nd0 XX0 1Cp0 pz0 dEp0 4VB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|85e3\",\"Africa/El_Aaiun|LMT WAT WET WEST|Q.M 10 0 -10|01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1rDz7.c 1GVA7.c 6L0 AL0 1Nd0 XX0 1Cp0 pz0 1cBB0 AL0 1Nd0 wn0 1FB0 Db0 1zd0 Lz0 1Nf0 wM0 co0 go0 1o00 s00 dA0 vc0 11A0 A00 e00 y00 11A0 uM0 e00 Dc0 11A0 s00 e00 IM0 WM0 mo0 gM0 LA0 WM0 jA0 e00 Rc0 11A0 e00 e00 U00 11A0 8o0 e00 11A0 11A0 5A0 e00 17c0 1fA0 1a00 1a00 1fA0 17c0 1io0 14o0 1lc0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1lc0 14o0 1fA0|20e4\",\"Africa/Johannesburg|SAST SAST SAST|-1u -20 -30|012121|-2GJdu 1Ajdu 1cL0 1cN0 1cL0|84e5\",\"Africa/Khartoum|LMT CAT CAST EAT|-2a.8 -20 -30 -30|01212121212121212121212121212121213|-1yW2a.8 1zK0a.8 16L0 1iN0 17b0 1jd0 17b0 1ip0 17z0 1i10 17X0 1hB0 18n0 1hd0 19b0 1gp0 19z0 1iN0 17b0 1ip0 17z0 1i10 18n0 1hd0 18L0 1gN0 19b0 1gp0 19z0 1iN0 17z0 1i10 17X0 yGd0|51e5\",\"Africa/Monrovia|MMT LRT GMT|H.8 I.u 0|012|-23Lzg.Q 29s01.m|11e5\",\"Africa/Ndjamena|LMT WAT WAST|-10.c -10 -20|0121|-2le10.c 2J3c0.c Wn0|13e5\",\"Africa/Tripoli|LMT CET CEST EET|-Q.I -10 -20 -20|012121213121212121212121213123123|-21JcQ.I 1hnBQ.I vx0 4iP0 xx0 4eN0 Bb0 7ip0 U0n0 A10 1db0 1cN0 1db0 1dd0 1db0 1eN0 1bb0 1e10 1cL0 1c10 1db0 1dd0 1db0 1cN0 1db0 1q10 fAn0 1ep0 1db0 AKq0 TA0 1o00|11e5\",\"Africa/Tunis|PMT CET CEST|-9.l -10 -20|0121212121212121212121212121212121|-2nco9.l 18pa9.l 1qM0 DA0 3Tc0 11B0 1ze0 WM0 7z0 3d0 14L0 1cN0 1f90 1ar0 16J0 1gXB0 WM0 1rA0 11c0 nwo0 Ko0 1cM0 1cM0 1rA0 10M0 zuM0 10N0 1aN0 1qM0 WM0 1qM0 11A0 1o00|20e5\",\"Africa/Windhoek|SWAT SAST SAST CAT WAT WAST|-1u -20 -30 -20 -10 -20|012134545454545454545454545454545454545454545454545454545454545454545454545454545454545454545|-2GJdu 1Ajdu 1cL0 1SqL0 9NA0 11D0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 11B0 1nX0 11B0|32e4\",\"America/Adak|NST NWT NPT BST BDT AHST HST HDT|b0 a0 a0 b0 a0 a0 a0 90|012034343434343434343434343434343456767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17SX0 8wW0 iB0 Qlb0 52O0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cm0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|326\",\"America/Anchorage|CAT CAWT CAPT AHST AHDT YST AKST AKDT|a0 90 90 a0 90 90 90 80|012034343434343434343434343434343456767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17T00 8wX0 iA0 Qlb0 52O0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cm0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|30e4\",\"America/Port_of_Spain|LMT AST|46.4 40|01|-2kNvR.U|43e3\",\"America/Araguaina|LMT BRT BRST|3c.M 30 20|0121212121212121212121212121212121212121212121212121|-2glwL.c HdKL.c 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 dMN0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 ny10 Lz0|14e4\",\"America/Argentina/Buenos_Aires|CMT ART ARST ART ARST|4g.M 40 30 30 20|0121212121212121212121212121212121212121213434343434343234343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 g0p0 10M0 j3c0 uL0 1qN0 WL0\",\"America/Argentina/Catamarca|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343454343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 ako0 7B0 8zb0 uL0\",\"America/Argentina/Cordoba|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343454343234343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 j3c0 uL0 1qN0 WL0\",\"America/Argentina/Jujuy|CMT ART ARST ART ARST WART WARST|4g.M 40 30 30 20 40 30|01212121212121212121212121212121212121212134343456543432343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1ze0 TX0 1ld0 WK0 1wp0 TX0 g0p0 10M0 j3c0 uL0\",\"America/Argentina/La_Rioja|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|01212121212121212121212121212121212121212134343434534343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Qn0 qO0 16n0 Rb0 1wp0 TX0 g0p0 10M0 ako0 7B0 8zb0 uL0\",\"America/Argentina/Mendoza|CMT ART ARST ART ARST WART WARST|4g.M 40 30 30 20 40 30|0121212121212121212121212121212121212121213434345656543235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1u20 SL0 1vd0 Tb0 1wp0 TW0 g0p0 10M0 agM0 Op0 7TX0 uL0\",\"America/Argentina/Rio_Gallegos|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343434343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 g0p0 10M0 ako0 7B0 8zb0 uL0\",\"America/Argentina/Salta|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|01212121212121212121212121212121212121212134343434543432343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 j3c0 uL0\",\"America/Argentina/San_Juan|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|01212121212121212121212121212121212121212134343434534343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Qn0 qO0 16n0 Rb0 1wp0 TX0 g0p0 10M0 ak00 m10 8lb0 uL0\",\"America/Argentina/San_Luis|CMT ART ARST ART ARST WART WARST|4g.M 40 30 30 20 40 30|01212121212121212121212121212121212121212134343456536353465653|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 XX0 1q20 SL0 AN0 kin0 10M0 ak00 m10 8lb0 8L0 jd0 1qN0 WL0 1qN0\",\"America/Argentina/Tucuman|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|012121212121212121212121212121212121212121343434345434323534343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 g0p0 10M0 ako0 4N0 8BX0 uL0 1qN0 WL0\",\"America/Argentina/Ushuaia|CMT ART ARST ART ARST WART|4g.M 40 30 30 20 40|0121212121212121212121212121212121212121213434343434343235343|-20UHH.c pKnH.c Mn0 1iN0 Tb0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 1C10 LX0 1C10 LX0 1C10 LX0 1C10 Mn0 MN0 2jz0 MN0 4lX0 u10 5Lb0 1pB0 Fnz0 u10 uL0 1vd0 SL0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 g0p0 10M0 ajA0 8p0 8zb0 uL0\",\"America/Curacao|LMT ANT AST|4z.L 4u 40|012|-2kV7o.d 28KLS.d|15e4\",\"America/Asuncion|AMT PYT PYT PYST|3O.E 40 30 30|012131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313|-1x589.k 1DKM9.k 3CL0 3Dd0 10L0 1pB0 10n0 1pB0 10n0 1pB0 1cL0 1dd0 1db0 1dd0 1cL0 1dd0 1cL0 1dd0 1cL0 1dd0 1db0 1dd0 1cL0 1dd0 1cL0 1dd0 1cL0 1dd0 1db0 1dd0 1cL0 1lB0 14n0 1dd0 1cL0 1fd0 WL0 1rd0 1aL0 1dB0 Xz0 1qp0 Xb0 1qN0 10L0 1rB0 TX0 1tB0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 1cL0 WN0 1qL0 11B0 1nX0 1ip0 WL0 1qN0 WL0 1qN0 WL0 1tB0 TX0 1tB0 TX0 1tB0 19X0 1a10 1fz0 1a10 1fz0 1cN0 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0|28e5\",\"America/Atikokan|CST CDT CWT CPT EST|60 50 50 50 50|0101234|-25TQ0 1in0 Rnb0 3je0 8x30 iw0|28e2\",\"America/Bahia|LMT BRT BRST|2y.4 30 20|01212121212121212121212121212121212121212121212121212121212121|-2glxp.U HdLp.U 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 l5B0 Rb0|27e5\",\"America/Bahia_Banderas|LMT MST CST PST MDT CDT|71 70 60 80 60 50|0121212131414141414141414141414141414152525252525252525252525252525252525252525252525252525252|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 otX0 gmN0 P2N0 13Vd0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nW0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|84e3\",\"America/Barbados|LMT BMT AST ADT|3W.t 3W.t 40 30|01232323232|-1Q0I1.v jsM0 1ODC1.v IL0 1ip0 17b0 1ip0 17b0 1ld0 13b0|28e4\",\"America/Belem|LMT BRT BRST|3d.U 30 20|012121212121212121212121212121|-2glwK.4 HdKK.4 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0|20e5\",\"America/Belize|LMT CST CHDT CDT|5Q.M 60 5u 50|01212121212121212121212121212121212121212121212121213131|-2kBu7.c fPA7.c Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1wou Rbu 1zcu Onu 1zcu Onu 1zcu Rbu 1wou Rbu 1f0Mu qn0 lxB0 mn0|57e3\",\"America/Blanc-Sablon|AST ADT AWT APT|40 30 30 30|010230|-25TS0 1in0 UGp0 8x50 iu0|11e2\",\"America/Boa_Vista|LMT AMT AMST|42.E 40 30|0121212121212121212121212121212121|-2glvV.k HdKV.k 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 smp0 WL0 1tB0 2L0|62e2\",\"America/Bogota|BMT COT COST|4U.g 50 40|0121|-2eb73.I 38yo3.I 2en0|90e5\",\"America/Boise|PST PDT MST MWT MPT MDT|80 70 70 60 60 60|0101023425252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252|-261q0 1nX0 11B0 1nX0 8C10 JCL0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 Dd0 1Kn0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|21e4\",\"America/Cambridge_Bay|-00 MST MWT MPT MDDT MDT CST CDT EST|0 70 60 60 50 60 60 50 50|0123141515151515151515151515151515151515151515678651515151515151515151515151515151515151515151515151515151515151515151515151|-21Jc0 RO90 8x20 ix0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11A0 1nX0 2K0 WQ0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|15e2\",\"America/Campo_Grande|LMT AMT AMST|3C.s 40 30|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-2glwl.w HdLl.w 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 1C10 Lz0 1Ip0 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0|77e4\",\"America/Cancun|LMT CST EST EDT CDT|5L.4 60 50 40 50|0123232341414141414141414141414141414141412|-1UQG0 2q2o0 yLB0 1lb0 14p0 1lb0 14p0 Lz0 xB0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 Dd0|63e4\",\"America/Caracas|CMT VET VET|4r.E 4u 40|01212|-2kV7w.k 28KM2.k 1IwOu kqo0|29e5\",\"America/Cayenne|LMT GFT GFT|3t.k 40 30|012|-2mrwu.E 2gWou.E|58e3\",\"America/Panama|CMT EST|5j.A 50|01|-2uduE.o|15e5\",\"America/Chicago|CST CDT EST CWT CPT|60 50 50 50 50|01010101010101010101010101010101010102010101010103401010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 1wp0 TX0 WN0 1qL0 1cN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 11B0 1Hz0 14p0 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 RB0 8x30 iw0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|92e5\",\"America/Chihuahua|LMT MST CST CDT MDT|74.k 70 60 50 60|0121212323241414141414141414141414141414141414141414141414141414141414141414141414141414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 2zQN0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|81e4\",\"America/Costa_Rica|SJMT CST CDT|5A.d 60 50|0121212121|-1Xd6n.L 2lu0n.L Db0 1Kp0 Db0 pRB0 15b0 1kp0 mL0|12e5\",\"America/Creston|MST PST|70 80|010|-29DR0 43B0|53e2\",\"America/Cuiaba|LMT AMT AMST|3I.k 40 30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-2glwf.E HdLf.E 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 4a10 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0|54e4\",\"America/Danmarkshavn|LMT WGT WGST GMT|1e.E 30 20 0|01212121212121212121212121212121213|-2a5WJ.k 2z5fJ.k 19U0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 DC0|8\",\"America/Dawson|YST YDT YWT YPT YDDT PST PDT|90 80 80 80 70 80 70|0101023040565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565|-25TN0 1in0 1o10 13V0 Ser0 8x00 iz0 LCL0 1fA0 jrA0 fNd0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|13e2\",\"America/Dawson_Creek|PST PDT PWT PPT MST|80 70 70 70 70|0102301010101010101010101010101010101010101010101010101014|-25TO0 1in0 UGp0 8x10 iy0 3NB0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 ML0|12e3\",\"America/Denver|MST MDT MWT MPT|70 60 60 60|01010101023010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261r0 1nX0 11B0 1nX0 11B0 1qL0 WN0 mn0 Ord0 8x20 ix0 LCN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|26e5\",\"America/Detroit|LMT CST EST EWT EPT EDT|5w.b 60 50 40 40 40|01234252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252|-2Cgir.N peqr.N 156L0 8x40 iv0 6fd0 11z0 Jy10 SL0 dnB0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|37e5\",\"America/Edmonton|LMT MST MDT MWT MPT|7x.Q 70 60 60 60|01212121212121341212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2yd4q.8 shdq.8 1in0 17d0 hz0 2dB0 1fz0 1a10 11z0 1qN0 WL0 1qN0 11z0 IGN0 8x20 ix0 3NB0 11z0 LFB0 1cL0 3Cp0 1cL0 66N0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|10e5\",\"America/Eirunepe|LMT ACT ACST AMT|4D.s 50 40 40|0121212121212121212121212121212131|-2glvk.w HdLk.w 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 dPB0 On0 yTd0 d5X0|31e3\",\"America/El_Salvador|LMT CST CDT|5U.M 60 50|012121|-1XiG3.c 2Fvc3.c WL0 1qN0 WL0|11e5\",\"America/Tijuana|LMT MST PST PDT PWT PPT|7M.4 70 80 70 70 70|012123245232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1UQE0 4PX0 8mM0 8lc0 SN0 1cL0 pHB0 83r0 zI0 5O10 1Rz0 cOP0 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 BUp0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|20e5\",\"America/Fort_Nelson|PST PDT PWT PPT MST|80 70 70 70 70|01023010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010104|-25TO0 1in0 UGp0 8x10 iy0 3NB0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0|39e2\",\"America/Fort_Wayne|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|010101023010101010101010101040454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 QI10 Db0 RB0 8x30 iw0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 5Tz0 1o10 qLb0 1cL0 1cN0 1cL0 1qhd0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Fortaleza|LMT BRT BRST|2y 30 20|0121212121212121212121212121212121212121|-2glxq HdLq 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 5z0 2mN0 On0|34e5\",\"America/Glace_Bay|LMT AST ADT AWT APT|3X.M 40 30 30 30|012134121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2IsI0.c CwO0.c 1in0 UGp0 8x50 iu0 iq10 11z0 Jg10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|19e3\",\"America/Godthab|LMT WGT WGST|3q.U 30 20|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2a5Ux.4 2z5dx.4 19U0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|17e3\",\"America/Goose_Bay|NST NDT NST NDT NWT NPT AST ADT ADDT|3u.Q 2u.Q 3u 2u 2u 2u 40 30 20|010232323232323245232323232323232323232323232323232323232326767676767676767676767676767676767676767676768676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-25TSt.8 1in0 DXb0 2HbX.8 WL0 1qN0 WL0 1qN0 WL0 1tB0 TX0 1tB0 WL0 1qN0 WL0 1qN0 7UHu itu 1tB0 WL0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1tB0 WL0 1ld0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 S10 g0u 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14n1 1lb0 14p0 1nW0 11C0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zcX Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|76e2\",\"America/Grand_Turk|KMT EST EDT AST|57.b 50 40 40|0121212121212121212121212121212121212121212121212121212121212121212121212123|-2l1uQ.N 2HHBQ.N 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|37e2\",\"America/Guatemala|LMT CST CDT|62.4 60 50|0121212121|-24KhV.U 2efXV.U An0 mtd0 Nz0 ifB0 17b0 zDB0 11z0|13e5\",\"America/Guayaquil|QMT ECT|5e 50|01|-1yVSK|27e5\",\"America/Guyana|LMT GBGT GYT GYT GYT|3Q.E 3J 3J 30 40|01234|-2dvU7.k 24JzQ.k mlc0 Bxbf|80e4\",\"America/Halifax|LMT AST ADT AWT APT|4e.o 40 30 30 30|0121212121212121212121212121212121212121212121212134121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2IsHJ.A xzzJ.A 1db0 3I30 1in0 3HX0 IL0 1E10 ML0 1yN0 Pb0 1Bd0 Mn0 1Bd0 Rz0 1w10 Xb0 1w10 LX0 1w10 Xb0 1w10 Lz0 1C10 Jz0 1E10 OL0 1yN0 Un0 1qp0 Xb0 1qp0 11X0 1w10 Lz0 1HB0 LX0 1C10 FX0 1w10 Xb0 1qp0 Xb0 1BB0 LX0 1td0 Xb0 1qp0 Xb0 Rf0 8x50 iu0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 3Qp0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 3Qp0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 6i10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|39e4\",\"America/Havana|HMT CST CDT|5t.A 50 40|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1Meuu.o 72zu.o ML0 sld0 An0 1Nd0 Db0 1Nd0 An0 6Ep0 An0 1Nd0 An0 JDd0 Mn0 1Ap0 On0 1fd0 11X0 1qN0 WL0 1wp0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 14n0 1ld0 14L0 1kN0 15b0 1kp0 1cL0 1cN0 1fz0 1a10 1fz0 1fB0 11z0 14p0 1nX0 11B0 1nX0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 14n0 1ld0 14n0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 1a10 1in0 1a10 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 17c0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 11A0 6i00 Rc0 1wo0 U00 1tA0 Rc0 1wo0 U00 1wo0 U00 1zc0 U00 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0|21e5\",\"America/Hermosillo|LMT MST CST PST MDT|7n.Q 70 60 80 60|0121212131414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 otX0 gmN0 P2N0 13Vd0 1lb0 14p0 1lb0 14p0 1lb0|64e4\",\"America/Indiana/Knox|CST CDT CWT CPT EST|60 50 50 50 50|0101023010101010101010101010101010101040101010101010101010101010101010101010101010101010141010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 3NB0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 11z0 1o10 11z0 1o10 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 3Cn0 8wp0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 z8o0 1o00 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Marengo|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|0101023010101010101010104545454545414545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 dyN0 11z0 6fd0 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 jrz0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1VA0 LA0 1BX0 1e6p0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Petersburg|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010104010101010101010101010141014545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 njX0 WN0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 3Fb0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 19co0 1o00 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Tell_City|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010101010454541010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 g0p0 11z0 1o10 11z0 1qL0 WN0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 caL0 1cL0 1cN0 1cL0 1qhd0 1o00 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Vevay|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|010102304545454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 kPB0 Awn0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1lnd0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Vincennes|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010101010454541014545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 g0p0 11z0 1o10 11z0 1qL0 WN0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 caL0 1cL0 1cN0 1cL0 1qhd0 1o00 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Indiana/Winamac|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|01010230101010101010101010101010101010454541054545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 jrz0 1cL0 1cN0 1cL0 1qhd0 1o00 Rd0 1za0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Inuvik|-00 PST PDDT MST MDT|0 80 60 70 60|0121343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|-FnA0 tWU0 1fA0 wPe0 2pz0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|35e2\",\"America/Iqaluit|-00 EWT EPT EST EDDT EDT CST CDT|0 40 40 50 30 40 60 50|01234353535353535353535353535353535353535353567353535353535353535353535353535353535353535353535353535353535353535353535353|-16K00 7nX0 iv0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11C0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|67e2\",\"America/Jamaica|KMT EST EDT|57.b 50 40|0121212121212121212121|-2l1uQ.N 2uM1Q.N 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0|94e4\",\"America/Juneau|PST PWT PPT PDT YDT YST AKST AKDT|80 70 70 70 80 90 90 80|01203030303030303030303030403030356767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17T20 8x10 iy0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cM0 1cM0 1cL0 1cN0 1fz0 1a10 1fz0 co0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|33e3\",\"America/Kentucky/Louisville|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|0101010102301010101010101010101010101454545454545414545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 3Fd0 Nb0 LPd0 11z0 RB0 8x30 iw0 Bb0 10N0 2bB0 8in0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 xz0 gso0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1VA0 LA0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Kentucky/Monticello|CST CDT CWT CPT EST EDT|60 50 50 50 50 40|0101023010101010101010101010101010101010101010101010101010101010101010101454545454545454545454545454545454545454545454545454545454545454545454545454|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 SWp0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/La_Paz|CMT BOST BOT|4w.A 3w.A 40|012|-1x37r.o 13b0|19e5\",\"America/Lima|LMT PET PEST|58.A 50 40|0121212121212121|-2tyGP.o 1bDzP.o zX0 1aN0 1cL0 1cN0 1cL0 1PrB0 zX0 1O10 zX0 6Gp0 zX0 98p0 zX0|11e6\",\"America/Los_Angeles|PST PDT PWT PPT|80 70 70 70|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261q0 1nX0 11B0 1nX0 SgN0 8x10 iy0 5Wp0 1Vb0 3dB0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|15e6\",\"America/Maceio|LMT BRT BRST|2m.Q 30 20|012121212121212121212121212121212121212121|-2glxB.8 HdLB.8 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 dMN0 Lz0 8Q10 WL0 1tB0 5z0 2mN0 On0|93e4\",\"America/Managua|MMT CST EST CDT|5J.c 60 50 50|0121313121213131|-1quie.M 1yAMe.M 4mn0 9Up0 Dz0 1K10 Dz0 s3F0 1KH0 DB0 9In0 k8p0 19X0 1o30 11y0|22e5\",\"America/Manaus|LMT AMT AMST|40.4 40 30|01212121212121212121212121212121|-2glvX.U HdKX.U 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 dPB0 On0|19e5\",\"America/Martinique|FFMT AST ADT|44.k 40 30|0121|-2mPTT.E 2LPbT.E 19X0|39e4\",\"America/Matamoros|LMT CST CDT|6E 60 50|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1UQG0 2FjC0 1nX0 i6p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|45e4\",\"America/Mazatlan|LMT MST CST PST MDT|75.E 70 60 80 60|0121212131414141414141414141414141414141414141414141414141414141414141414141414141414141414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 otX0 gmN0 P2N0 13Vd0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|44e4\",\"America/Menominee|CST CDT CWT CPT EST|60 50 50 50 50|01010230101041010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 1o10 11z0 LCN0 1fz0 6410 9Jb0 1cM0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|85e2\",\"America/Merida|LMT CST EST CDT|5W.s 60 50 50|0121313131313131313131313131313131313131313131313131313131313131313131313131313131313131|-1UQG0 2q2o0 2hz0 wu30 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|11e5\",\"America/Metlakatla|PST PWT PPT PDT AKST AKDT|80 70 70 70 90 80|0120303030303030303030303030303030454545454545454545454545454545454545454545454|-17T20 8x10 iy0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1hU10 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|14e2\",\"America/Mexico_City|LMT MST CST CDT CWT|6A.A 70 60 50 50|012121232324232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 gEn0 TX0 3xd0 Jb0 6zB0 SL0 e5d0 17b0 1Pff0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|20e6\",\"America/Miquelon|LMT AST PMST PMDT|3I.E 40 30 20|012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-2mKkf.k 2LTAf.k gQ10 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|61e2\",\"America/Moncton|EST AST ADT AWT APT|50 40 30 30 30|012121212121212121212134121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2IsH0 CwN0 1in0 zAo0 An0 1Nd0 An0 1Nd0 An0 1Nd0 An0 1Nd0 An0 1Nd0 An0 1K10 Lz0 1zB0 NX0 1u10 Wn0 S20 8x50 iu0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 3Cp0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14n1 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 ReX 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|64e3\",\"America/Monterrey|LMT CST CDT|6F.g 60 50|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1UQG0 2FjC0 1nX0 i6p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0|41e5\",\"America/Montevideo|MMT UYT UYHST UYST UYT UYHST|3I.I 3u 30 20 30 2u|012121212121212121212121213434343434345454543453434343434343434343434343434343434343434|-20UIf.g 8jzJ.g 1cLu 1dcu 1cLu 1dcu 1cLu ircu 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 1qMu WLu 1qMu WLu 1qMu 11zu 1o0u 11zu NAu 11bu 2iMu zWu Dq10 19X0 pd0 jz0 cm10 19X0 1fB0 1on0 11d0 1oL0 1nB0 1fzu 1aou 1fzu 1aou 1fzu 3nAu Jb0 3MN0 1SLu 4jzu 2PB0 Lb0 3Dd0 1pb0 ixd0 An0 1MN0 An0 1wp0 On0 1wp0 Rb0 1zd0 On0 1wp0 Rb0 s8p0 1fB0 1ip0 11z0 1ld0 14n0 1o10 11z0 1o10 11z0 1o10 14n0 1ld0 14n0 1ld0 14n0 1o10 11z0 1o10 11z0 1o10 11z0|17e5\",\"America/Toronto|EST EDT EWT EPT|50 40 40 40|01010101010101010101010101010101010101010101012301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TR0 1in0 11Wu 1nzu 1fD0 WJ0 1wr0 Nb0 1Ap0 On0 1zd0 On0 1wp0 TX0 1tB0 TX0 1tB0 TX0 1tB0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 4kM0 8x40 iv0 1o10 11z0 1nX0 11z0 1o10 11z0 1o10 1qL0 11D0 1nX0 11B0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|65e5\",\"America/Nassau|LMT EST EDT|59.u 50 40|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2kNuO.u 26XdO.u 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|24e4\",\"America/New_York|EST EDT EWT EPT|50 40 40 40|01010101010101010101010101010101010101010101010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261t0 1nX0 11B0 1nX0 11B0 1qL0 1a10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 RB0 8x40 iv0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|21e6\",\"America/Nipigon|EST EDT EWT EPT|50 40 40 40|010123010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TR0 1in0 Rnb0 3je0 8x40 iv0 19yN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|16e2\",\"America/Nome|NST NWT NPT BST BDT YST AKST AKDT|b0 a0 a0 b0 a0 90 90 80|012034343434343434343434343434343456767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676767676|-17SX0 8wW0 iB0 Qlb0 52O0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cl0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|38e2\",\"America/Noronha|LMT FNT FNST|29.E 20 10|0121212121212121212121212121212121212121|-2glxO.k HdKO.k 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 2L0 2pB0 On0|30e2\",\"America/North_Dakota/Beulah|MST MDT MWT MPT CST CDT|70 60 60 60 60 50|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101014545454545454545454545454545454545454545454545454545454|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/North_Dakota/Center|MST MDT MWT MPT CST CDT|70 60 60 60 60 50|010102301010101010101010101010101010101010101010101010101014545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14o0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/North_Dakota/New_Salem|MST MDT MWT MPT CST CDT|70 60 60 60 60 50|010102301010101010101010101010101010101010101010101010101010101010101010101010101454545454545454545454545454545454545454545454545454545454545454545454|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14o0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"America/Ojinaga|LMT MST CST CDT MDT|6V.E 70 60 50 60|0121212323241414141414141414141414141414141414141414141414141414141414141414141414141414141|-1UQF0 deL0 8lc0 17c0 10M0 1dd0 2zQN0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e3\",\"America/Pangnirtung|-00 AST AWT APT ADDT ADT EDT EST CST CDT|0 40 30 30 20 30 40 50 60 50|012314151515151515151515151515151515167676767689767676767676767676767676767676767676767676767676767676767676767676767676767|-1XiM0 PnG0 8x50 iu0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1o00 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11C0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|14e2\",\"America/Paramaribo|LMT PMT PMT NEGT SRT SRT|3E.E 3E.Q 3E.A 3u 3u 30|012345|-2nDUj.k Wqo0.c qanX.I 1dmLN.o lzc0|24e4\",\"America/Phoenix|MST MDT MWT|70 60 60|01010202010|-261r0 1nX0 11B0 1nX0 SgN0 4Al1 Ap0 1db0 SWqX 1cL0|42e5\",\"America/Port-au-Prince|PPMT EST EDT|4N 50 40|01212121212121212121212121212121212121212121|-28RHb 2FnMb 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14q0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 i6n0 1nX0 11B0 1nX0 d430 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e5\",\"America/Rio_Branco|LMT ACT ACST AMT|4v.c 50 40 40|01212121212121212121212121212131|-2glvs.M HdLs.M 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 NBd0 d5X0|31e4\",\"America/Porto_Velho|LMT AMT AMST|4f.A 40 30|012121212121212121212121212121|-2glvI.o HdKI.o 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0|37e4\",\"America/Puerto_Rico|AST AWT APT|40 30 30|0120|-17lU0 7XT0 iu0|24e5\",\"America/Rainy_River|CST CDT CWT CPT|60 50 50 50|010123010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TQ0 1in0 Rnb0 3je0 8x30 iw0 19yN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|842\",\"America/Rankin_Inlet|-00 CST CDDT CDT EST|0 60 40 50 50|012131313131313131313131313131313131313131313431313131313131313131313131313131313131313131313131313131313131313131313131|-vDc0 keu0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|26e2\",\"America/Recife|LMT BRT BRST|2j.A 30 20|0121212121212121212121212121212121212121|-2glxE.o HdLE.o 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 2L0 2pB0 On0|33e5\",\"America/Regina|LMT MST MDT MWT MPT CST|6W.A 70 60 60 60 60|012121212121212121212121341212121212121212121212121215|-2AD51.o uHe1.o 1in0 s2L0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 66N0 1cL0 1cN0 19X0 1fB0 1cL0 1fB0 1cL0 1cN0 1cL0 M30 8x20 ix0 1ip0 1cL0 1ip0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 3NB0 1cL0 1cN0|19e4\",\"America/Resolute|-00 CST CDDT CDT EST|0 60 40 50 50|012131313131313131313131313131313131313131313431313131313431313131313131313131313131313131313131313131313131313131313131|-SnA0 GWS0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|229\",\"America/Santarem|LMT AMT AMST BRT|3C.M 40 30 30|0121212121212121212121212121213|-2glwl.c HdLl.c 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 qe10 xb0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 NBd0|21e4\",\"America/Santiago|SMT CLT CLT CLST CLST|4G.K 50 40 40 30|010203131313131212421242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424|-2q2jh.e fJAh.e 5knG.K 1Vzh.e jRAG.K 1pbh.e 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 nHX0 op0 9Bz0 jb0 1oN0 ko0 Qeo0 WL0 1zd0 On0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0|62e5\",\"America/Santo_Domingo|SDMT EST EDT EHDT AST|4E 50 40 4u 40|01213131313131414|-1ttjk 1lJMk Mn0 6sp0 Lbu 1Cou yLu 1RAu wLu 1QMu xzu 1Q0u xXu 1PAu 13jB0 e00|29e5\",\"America/Sao_Paulo|LMT BRT BRST|36.s 30 20|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-2glwR.w HdKR.w 1cc0 1e10 1bX0 Ezd0 So0 1vA0 Mn0 1BB0 ML0 1BB0 zX0 pTd0 PX0 2ep0 nz0 1C10 zX0 1C10 LX0 1C10 Mn0 H210 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 1C10 Lz0 1Ip0 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1C10 Lz0 1C10 Lz0 1C10 Lz0 1C10 On0 1zd0 Rb0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0|20e6\",\"America/Scoresbysund|LMT CGT CGST EGST EGT|1r.Q 20 10 0 10|0121343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434|-2a5Ww.8 2z5ew.8 1a00 1cK0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|452\",\"America/Sitka|PST PWT PPT PDT YST AKST AKDT|80 70 70 70 90 90 80|01203030303030303030303030303030345656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565|-17T20 8x10 iy0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 co0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|90e2\",\"America/St_Johns|NST NDT NST NDT NWT NPT NDDT|3u.Q 2u.Q 3u 2u 2u 2u 1u|01010101010101010101010101010101010102323232323232324523232323232323232323232323232323232323232323232323232323232323232323232323232323232326232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-28oit.8 14L0 1nB0 1in0 1gm0 Dz0 1JB0 1cL0 1cN0 1cL0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 1cL0 1cN0 1cL0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1fB0 1cL0 1fB0 19X0 1fB0 19X0 10O0 eKX.8 19X0 1iq0 WL0 1qN0 WL0 1qN0 WL0 1tB0 TX0 1tB0 WL0 1qN0 WL0 1qN0 7UHu itu 1tB0 WL0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1tB0 WL0 1ld0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14n1 1lb0 14p0 1nW0 11C0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zcX Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|11e4\",\"America/Swift_Current|LMT MST MDT MWT MPT CST|7b.k 70 60 60 60 60|012134121212121212121215|-2AD4M.E uHdM.E 1in0 UGp0 8x20 ix0 1o10 17b0 1ip0 11z0 1o10 11z0 1o10 11z0 isN0 1cL0 3Cp0 1cL0 1cN0 11z0 1qN0 WL0 pMp0|16e3\",\"America/Tegucigalpa|LMT CST CDT|5M.Q 60 50|01212121|-1WGGb.8 2ETcb.8 WL0 1qN0 WL0 GRd0 AL0|11e5\",\"America/Thule|LMT AST ADT|4z.8 40 30|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2a5To.Q 31NBo.Q 1cL0 1cN0 1cL0 1fB0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|656\",\"America/Thunder_Bay|CST EST EWT EPT EDT|60 50 40 40 40|0123141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141|-2q5S0 1iaN0 8x40 iv0 XNB0 1cL0 1cN0 1fz0 1cN0 1cL0 3Cp0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|11e4\",\"America/Vancouver|PST PDT PWT PPT|80 70 70 70|0102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-25TO0 1in0 UGp0 8x10 iy0 1o10 17b0 1ip0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e5\",\"America/Whitehorse|YST YDT YWT YPT YDDT PST PDT|90 80 80 80 70 80 70|0101023040565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565|-25TN0 1in0 1o10 13V0 Ser0 8x00 iz0 LCL0 1fA0 3NA0 vrd0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e3\",\"America/Winnipeg|CST CDT CWT CPT|60 50 50 50|010101023010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aIi0 WL0 3ND0 1in0 Jap0 Rb0 aCN0 8x30 iw0 1tB0 11z0 1ip0 11z0 1o10 11z0 1o10 11z0 1rd0 10L0 1op0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 1cL0 1cN0 11z0 6i10 WL0 6i10 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|66e4\",\"America/Yakutat|YST YWT YPT YDT AKST AKDT|90 80 80 80 90 80|01203030303030303030303030303030304545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-17T10 8x00 iz0 Vo10 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cn0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|642\",\"America/Yellowknife|-00 MST MWT MPT MDDT MDT|0 70 60 60 50 60|012314151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151515151|-1pdA0 hix0 8x20 ix0 LCL0 1fA0 zgO0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|19e3\",\"Antarctica/Casey|-00 AWST CAST|0 -80 -b0|012121|-2q00 1DjS0 T90 40P0 KL0|10\",\"Antarctica/Davis|-00 DAVT DAVT|0 -70 -50|01012121|-vyo0 iXt0 alj0 1D7v0 VB0 3Wn0 KN0|70\",\"Antarctica/DumontDUrville|-00 PMT DDUT|0 -a0 -a0|0102|-U0o0 cfq0 bFm0|80\",\"Antarctica/Macquarie|AEST AEDT -00 MIST|-a0 -b0 0 -b0|0102010101010101010101010101010101010101010101010101010101010101010101010101010101010101013|-29E80 19X0 4SL0 1ayy0 Lvs0 1cM0 1o00 Rc0 1wo0 Rc0 1wo0 U00 1wo0 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0|1\",\"Antarctica/Mawson|-00 MAWT MAWT|0 -60 -50|012|-CEo0 2fyk0|60\",\"Pacific/Auckland|NZMT NZST NZST NZDT|-bu -cu -c0 -d0|01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323|-1GCVu Lz0 1tB0 11zu 1o0u 11zu 1o0u 11zu 1o0u 14nu 1lcu 14nu 1lcu 1lbu 11Au 1nXu 11Au 1nXu 11Au 1nXu 11Au 1nXu 11Au 1qLu WMu 1qLu 11Au 1n1bu IM0 1C00 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1qM0 14o0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1io0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00|14e5\",\"Antarctica/Palmer|-00 ARST ART ART ARST CLT CLST|0 30 40 30 20 40 30|0121212121234356565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656|-cao0 nD0 1vd0 SL0 1vd0 17z0 1cN0 1fz0 1cN0 1cL0 1cN0 asn0 Db0 jsN0 14N0 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0|40\",\"Antarctica/Rothera|-00 ROTT|0 30|01|gOo0|130\",\"Antarctica/Syowa|-00 SYOT|0 -30|01|-vs00|20\",\"Antarctica/Troll|-00 UTC CEST|0 0 -20|01212121212121212121212121212121212121212121212121212121212121212121|1puo0 hd0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|40\",\"Antarctica/Vostok|-00 VOST|0 -60|01|-tjA0|25\",\"Europe/Oslo|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2awM0 Qm0 W6o0 5pf0 WM0 1fA0 1cM0 1cM0 1cM0 1cM0 wJc0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1qM0 WM0 zpc0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|62e4\",\"Asia/Riyadh|LMT AST|-36.Q -30|01|-TvD6.Q|57e5\",\"Asia/Almaty|LMT +05 +06 +07|-57.M -50 -60 -70|012323232323232323232321232323232323232323232323232|-1Pc57.M eUo7.M 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0|15e5\",\"Asia/Amman|LMT EET EEST|-2n.I -20 -30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1yW2n.I 1HiMn.I KL0 1oN0 11b0 1oN0 11b0 1pd0 1dz0 1cp0 11b0 1op0 11b0 fO10 1db0 1e10 1cL0 1cN0 1cL0 1cN0 1fz0 1pd0 10n0 1ld0 14n0 1hB0 15b0 1ip0 19X0 1cN0 1cL0 1cN0 17b0 1ld0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1So0 y00 1fc0 1dc0 1co0 1dc0 1cM0 1cM0 1cM0 1o00 11A0 1lc0 17c0 1cM0 1cM0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 4bX0 Dd0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0|25e5\",\"Asia/Anadyr|LMT ANAT ANAT ANAST ANAST ANAST ANAT|-bN.U -c0 -d0 -e0 -d0 -c0 -b0|01232414141414141414141561414141414141414141414141414141414141561|-1PcbN.U eUnN.U 23CL0 1db0 1cN0 1dc0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qN0 WM0|13e3\",\"Asia/Aqtau|LMT +04 +05 +06|-3l.4 -40 -50 -60|012323232323232323232123232312121212121212121212|-1Pc3l.4 eUnl.4 24PX0 2pX0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|15e4\",\"Asia/Aqtobe|LMT +04 +05 +06|-3M.E -40 -50 -60|0123232323232323232321232323232323232323232323232|-1Pc3M.E eUnM.E 23CL0 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0|27e4\",\"Asia/Ashgabat|LMT ASHT ASHT ASHST ASHST TMT TMT|-3R.w -40 -50 -60 -50 -40 -50|012323232323232323232324156|-1Pc3R.w eUnR.w 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 ba0 xC0|41e4\",\"Asia/Baghdad|BMT AST ADT|-2V.A -30 -40|012121212121212121212121212121212121212121212121212121|-26BeV.A 2ACnV.A 11b0 1cp0 1dz0 1dd0 1db0 1cN0 1cp0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1de0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0|66e5\",\"Asia/Qatar|LMT GST AST|-3q.8 -40 -30|012|-21Jfq.8 27BXq.8|96e4\",\"Asia/Baku|LMT BAKT BAKT BAKST BAKST AZST AZT AZT AZST|-3j.o -30 -40 -50 -40 -40 -30 -40 -50|01232323232323232323232456578787878787878787878787878787878787878787|-1Pc3j.o 1jUoj.o WCL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 10K0 c30 1cM0 1cM0 8wq0 1o00 11z0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00|27e5\",\"Asia/Bangkok|BMT ICT|-6G.4 -70|01|-218SG.4|15e6\",\"Asia/Barnaul|LMT +06 +07 +08|-5z -60 -70 -80|0123232323232323232323212323232321212121212121212121212121212121212|-21S5z pCnz 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 p90 LE0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0\",\"Asia/Beirut|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-21aq0 1on0 1410 1db0 19B0 1in0 1ip0 WL0 1lQp0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 q6N0 En0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1op0 11b0 dA10 17b0 1iN0 17b0 1iN0 17b0 1iN0 17b0 1vB0 SL0 1mp0 13z0 1iN0 17b0 1iN0 17b0 1jd0 12n0 1a10 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0|22e5\",\"Asia/Bishkek|LMT FRUT FRUT FRUST FRUST KGT KGST KGT|-4W.o -50 -60 -70 -60 -50 -60 -60|01232323232323232323232456565656565656565656565656567|-1Pc4W.o eUnW.o 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 11c0 1tX0 17b0 1ip0 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1cPu 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 T8u|87e4\",\"Asia/Brunei|LMT BNT BNT|-7D.E -7u -80|012|-1KITD.E gDc9.E|42e4\",\"Asia/Kolkata|HMT BURT IST IST|-5R.k -6u -5u -6u|01232|-18LFR.k 1unn.k HB0 7zX0|15e6\",\"Asia/Chita|LMT YAKT YAKT YAKST YAKST YAKT IRKT|-7x.Q -80 -90 -a0 -90 -a0 -80|0123232323232323232323241232323232323232323232323232323232323232562|-21Q7x.Q pAnx.Q 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3re0|33e4\",\"Asia/Choibalsan|LMT ULAT ULAT CHOST CHOT CHOT CHOST|-7C -70 -80 -a0 -90 -80 -90|0123434343434343434343434343434343434343434343456565656565656565656565656565656565656565656565|-2APHC 2UkoC cKn0 1da0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 3Db0 h1f0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0|38e3\",\"Asia/Shanghai|CST CDT|-80 -90|01010101010101010|-1c1I0 LX0 16p0 1jz0 1Myp0 Rb0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0|23e6\",\"Asia/Colombo|MMT IST IHST IST LKT LKT|-5j.w -5u -60 -6u -6u -60|01231451|-2zOtj.w 1rFbN.w 1zzu 7Apu 23dz0 11zu n3cu|22e5\",\"Asia/Dhaka|HMT BURT IST DACT BDT BDST|-5R.k -6u -5u -60 -60 -70|01213454|-18LFR.k 1unn.k HB0 m6n0 LqMu 1x6n0 1i00|16e6\",\"Asia/Damascus|LMT EET EEST|-2p.c -20 -30|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-21Jep.c Hep.c 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1xRB0 11X0 1oN0 10L0 1pB0 11b0 1oN0 10L0 1mp0 13X0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 Nb0 1AN0 Nb0 bcp0 19X0 1gp0 19X0 3ld0 1xX0 Vd0 1Bz0 Sp0 1vX0 10p0 1dz0 1cN0 1cL0 1db0 1db0 1g10 1an0 1ap0 1db0 1fd0 1db0 1cN0 1db0 1dd0 1db0 1cp0 1dz0 1c10 1dX0 1cN0 1db0 1dd0 1db0 1cN0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1db0 1cN0 1db0 1cN0 19z0 1fB0 1qL0 11B0 1on0 Wp0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0|26e5\",\"Asia/Dili|LMT TLT JST TLT WITA|-8m.k -80 -90 -90 -80|012343|-2le8m.k 1dnXm.k 8HA0 1ew00 Xld0|19e4\",\"Asia/Dubai|LMT GST|-3F.c -40|01|-21JfF.c|39e5\",\"Asia/Dushanbe|LMT DUST DUST DUSST DUSST TJT|-4z.c -50 -60 -70 -60 -50|0123232323232323232323245|-1Pc4z.c eUnz.c 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 14N0|76e4\",\"Asia/Gaza|EET EET EEST IST IDT|-20 -30 -30 -20 -30|010101010102020202020202020202023434343434343434343434343430202020202020202020202020202020202020202020202020202020202020202020202020202020202020|-1c2q0 5Rb0 10r0 1px0 10N0 1pz0 16p0 1jB0 16p0 1jx0 pBd0 Vz0 1oN0 11b0 1oO0 10N0 1pz0 10N0 1pb0 10N0 1pb0 10N0 1pb0 10N0 1pz0 10N0 1pb0 10N0 1pb0 11d0 1oL0 dW0 hfB0 Db0 1fB0 Rb0 npB0 11z0 1C10 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 M10 C00 17c0 1io0 17c0 1io0 17c0 1o00 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 17c0 1io0 18N0 1bz0 19z0 1gp0 1610 1iL0 11z0 1o10 14o0 1lA1 SKX 1xd1 MKX 1AN0 1a00 1fA0 1cL0 1cN0 1nX0 1210 1nz0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0|18e5\",\"Asia/Hebron|EET EET EEST IST IDT|-20 -30 -30 -20 -30|01010101010202020202020202020202343434343434343434343434343020202020202020202020202020202020202020202020202020202020202020202020202020202020202020|-1c2q0 5Rb0 10r0 1px0 10N0 1pz0 16p0 1jB0 16p0 1jx0 pBd0 Vz0 1oN0 11b0 1oO0 10N0 1pz0 10N0 1pb0 10N0 1pb0 10N0 1pb0 10N0 1pz0 10N0 1pb0 10N0 1pb0 11d0 1oL0 dW0 hfB0 Db0 1fB0 Rb0 npB0 11z0 1C10 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 M10 C00 17c0 1io0 17c0 1io0 17c0 1o00 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 17c0 1io0 18N0 1bz0 19z0 1gp0 1610 1iL0 12L0 1mN0 14o0 1lc0 Tb0 1xd1 MKX bB0 cn0 1cN0 1a00 1fA0 1cL0 1cN0 1nX0 1210 1nz0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1ny0 1220 1qm0 1220 1ny0 1220 1ny0 1220 1ny0|25e4\",\"Asia/Ho_Chi_Minh|LMT PLMT ICT IDT JST|-76.E -76.u -70 -80 -90|0123423232|-2yC76.E bK00.a 1h7b6.u 5lz0 18o0 3Oq0 k5b0 aW00 BAM0|90e5\",\"Asia/Hong_Kong|LMT HKT HKST JST|-7A.G -80 -90 -90|0121312121212121212121212121212121212121212121212121212121212121212121|-2CFHA.G 1sEP6.G 1cL0 ylu 93X0 1qQu 1tX0 Rd0 1In0 NB0 1cL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1kL0 14N0 1nX0 U10 1tz0 U10 1wn0 Rd0 1wn0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1wn0 Rd0 1wn0 Rd0 1wn0 U10 1tz0 U10 1tz0 17d0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1cL0 6fd0 14n0|73e5\",\"Asia/Hovd|LMT HOVT HOVT HOVST|-66.A -60 -70 -80|012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-2APG6.A 2Uko6.A cKn0 1db0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 kEp0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0|81e3\",\"Asia/Irkutsk|IMT IRKT IRKT IRKST IRKST IRKT|-6V.5 -70 -80 -90 -80 -90|012323232323232323232324123232323232323232323232323232323232323252|-21zGV.5 pjXV.5 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|60e4\",\"Europe/Istanbul|IMT EET EEST TRST TRT|-1U.U -20 -30 -40 -30|012121212121212121212121212121212121212121212121212121234343434342121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ogNU.U dzzU.U 11b0 8tB0 1on0 1410 1db0 19B0 1in0 3Rd0 Un0 1oN0 11b0 zSp0 CL0 mN0 1Vz0 1gN0 1pz0 5Rd0 1fz0 1yp0 ML0 1kp0 17b0 1ip0 17b0 1fB0 19X0 1jB0 18L0 1ip0 17z0 qdd0 xX0 3S10 Tz0 dA10 11z0 1o10 11z0 1qN0 11z0 1ze0 11B0 WM0 1qO0 WI0 1nX0 1rB0 10L0 11B0 1in0 17d0 1in0 2pX0 19E0 1fU0 16Q0 1iI0 16Q0 1iI0 1Vd0 pb0 3Kp0 14o0 1df0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WO0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 Xc0 1qo0 WM0 1qM0 11A0 1o00 1200 1nA0 11A0 1tA0 U00 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|13e6\",\"Asia/Jakarta|BMT JAVT WIB JST WIB WIB|-77.c -7k -7u -90 -80 -70|01232425|-1Q0Tk luM0 mPzO 8vWu 6kpu 4PXu xhcu|31e6\",\"Asia/Jayapura|LMT WIT ACST|-9m.M -90 -9u|0121|-1uu9m.M sMMm.M L4nu|26e4\",\"Asia/Jerusalem|JMT IST IDT IDDT|-2k.E -20 -30 -40|01212121212132121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-26Bek.E SyMk.E 5Rb0 10r0 1px0 10N0 1pz0 16p0 1jB0 16p0 1jx0 3LB0 Em0 or0 1cn0 1dB0 16n0 10O0 1ja0 1tC0 14o0 1cM0 1a00 11A0 1Na0 An0 1MP0 AJ0 1Kp0 LC0 1oo0 Wl0 EQN0 Db0 1fB0 Rb0 npB0 11z0 1C10 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 1hB0 1dX0 1ep0 1aL0 1eN0 17X0 1nf0 11z0 1tB0 19W0 1e10 17b0 1ep0 1gL0 18N0 1fz0 1eN0 17b0 1gq0 1gn0 19d0 1dz0 1c10 17X0 1hB0 1gn0 19d0 1dz0 1c10 17X0 1kp0 1dz0 1c10 1aL0 1eN0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0|81e4\",\"Asia/Kabul|AFT AFT|-40 -4u|01|-10Qs0|46e5\",\"Asia/Kamchatka|LMT PETT PETT PETST PETST|-ay.A -b0 -c0 -d0 -c0|01232323232323232323232412323232323232323232323232323232323232412|-1SLKy.A ivXy.A 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qN0 WM0|18e4\",\"Asia/Karachi|LMT IST IST KART PKT PKST|-4s.c -5u -6u -50 -50 -60|012134545454|-2xoss.c 1qOKW.c 7zX0 eup0 LqMu 1fy00 1cL0 dK10 11b0 1610 1jX0|24e6\",\"Asia/Urumqi|LMT XJT|-5O.k -60|01|-1GgtO.k|32e5\",\"Asia/Kathmandu|LMT IST NPT|-5F.g -5u -5J|012|-21JhF.g 2EGMb.g|12e5\",\"Asia/Khandyga|LMT YAKT YAKT YAKST YAKST VLAT VLAST VLAT YAKT|-92.d -80 -90 -a0 -90 -a0 -b0 -b0 -a0|01232323232323232323232412323232323232323232323232565656565656565782|-21Q92.d pAp2.d 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 qK0 yN0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 17V0 7zD0|66e2\",\"Asia/Krasnoyarsk|LMT KRAT KRAT KRAST KRAST KRAT|-6b.q -60 -70 -80 -70 -80|012323232323232323232324123232323232323232323232323232323232323252|-21Hib.q prAb.q 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|10e5\",\"Asia/Kuala_Lumpur|SMT MALT MALST MALT MALT JST MYT|-6T.p -70 -7k -7k -7u -90 -80|01234546|-2Bg6T.p 17anT.p 7hXE dM00 17bO 8Fyu 1so1u|71e5\",\"Asia/Kuching|LMT BORT BORT BORTST JST MYT|-7l.k -7u -80 -8k -90 -80|01232323232323232425|-1KITl.k gDbP.k 6ynu AnE 1O0k AnE 1NAk AnE 1NAk AnE 1NAk AnE 1O0k AnE 1NAk AnE pAk 8Fz0 1so10|13e4\",\"Asia/Macau|LMT MOT MOST CST|-7y.k -80 -90 -80|0121212121212121212121212121212121212121213|-2le7y.k 1XO34.k 1wn0 Rd0 1wn0 R9u 1wqu U10 1tz0 TVu 1tz0 17gu 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cJu 1cL0 1cN0 1fz0 1cN0 1cOu 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cJu 1cL0 1cN0 1fz0 1cN0 1cL0 KEp0|57e4\",\"Asia/Magadan|LMT MAGT MAGT MAGST MAGST MAGT|-a3.c -a0 -b0 -c0 -b0 -c0|0123232323232323232323241232323232323232323232323232323232323232512|-1Pca3.c eUo3.c 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3Cq0|95e3\",\"Asia/Makassar|LMT MMT WITA JST|-7V.A -7V.A -80 -90|01232|-21JjV.A vfc0 myLV.A 8ML0|15e5\",\"Asia/Manila|PHT PHST JST|-80 -90 -90|010201010|-1kJI0 AL0 cK10 65X0 mXB0 vX0 VK10 1db0|24e6\",\"Asia/Nicosia|LMT EET EEST|-2d.s -20 -30|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1Vc2d.s 2a3cd.s 1cL0 1qp0 Xz0 19B0 19X0 1fB0 1db0 1cp0 1cL0 1fB0 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1o30 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|32e4\",\"Asia/Novokuznetsk|LMT +06 +07 +08|-5M.M -60 -70 -80|012323232323232323232321232323232323232323232323232323232323212|-1PctM.M eULM.M 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0|55e4\",\"Asia/Novosibirsk|LMT +06 +07 +08|-5v.E -60 -70 -80|0123232323232323232323212323212121212121212121212121212121212121212|-21Qnv.E pAFv.E 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 ml0 Os0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 4eN0|15e5\",\"Asia/Omsk|LMT OMST OMST OMSST OMSST OMST|-4R.u -50 -60 -70 -60 -70|012323232323232323232324123232323232323232323232323232323232323252|-224sR.u pMLR.u 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|12e5\",\"Asia/Oral|LMT +04 +05 +06|-3p.o -40 -50 -60|01232323232323232121212121212121212121212121212|-1Pc3p.o eUnp.o 23CL0 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 1cM0 IM0 1EM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|27e4\",\"Asia/Pontianak|LMT PMT WIB JST WIB WITA WIB|-7h.k -7h.k -7u -90 -80 -80 -70|012324256|-2ua7h.k XE00 munL.k 8Rau 6kpu 4PXu xhcu Wqnu|23e4\",\"Asia/Pyongyang|LMT KST JCST JST KST|-8n -8u -90 -90 -90|012341|-2um8n 97XR 12FXu jdA0 2Onc0|29e5\",\"Asia/Qyzylorda|LMT +04 +05 +06|-4l.Q -40 -50 -60|0123232323232323232323232323232323232323232323|-1Pc4l.Q eUol.Q 23CL0 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 3ao0 1EM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|73e4\",\"Asia/Rangoon|RMT BURT JST MMT|-6o.E -6u -90 -6u|0123|-21Jio.E SmnS.E 7j9u|48e5\",\"Asia/Sakhalin|LMT JCST JST SAKT SAKST SAKST SAKT|-9u.M -90 -90 -b0 -c0 -b0 -a0|01234343434343434343434356343434343435656565656565656565656565656363|-2AGVu.M 1iaMu.M je00 1qFa0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o10 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0|58e4\",\"Asia/Samarkand|LMT SAMT SAMT SAMST TAST UZST UZT|-4r.R -40 -50 -60 -60 -60 -50|01234323232323232323232356|-1Pc4r.R eUor.R 23CL0 1db0 1cM0 1dc0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 11x0 bf0|36e4\",\"Asia/Seoul|LMT KST JCST JST KST KDT KDT|-8r.Q -8u -90 -90 -90 -9u -a0|01234151515151515146464|-2um8r.Q 97XV.Q 12FXu jjA0 kKo0 2I0u OL0 1FB0 Rb0 1qN0 TX0 1tB0 TX0 1tB0 TX0 1tB0 TX0 2ap0 12FBu 11A0 1o00 11A0|23e6\",\"Asia/Singapore|SMT MALT MALST MALT MALT JST SGT SGT|-6T.p -70 -7k -7k -7u -90 -7u -80|012345467|-2Bg6T.p 17anT.p 7hXE dM00 17bO 8Fyu Mspu DTA0|56e5\",\"Asia/Srednekolymsk|LMT MAGT MAGT MAGST MAGST MAGT SRET|-ae.Q -a0 -b0 -c0 -b0 -c0 -b0|012323232323232323232324123232323232323232323232323232323232323256|-1Pcae.Q eUoe.Q 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|35e2\",\"Asia/Taipei|JWST JST CST CDT|-80 -90 -80 -90|01232323232323232323232323232323232323232|-1iw80 joM0 1yo0 Tz0 1ip0 1jX0 1cN0 11b0 1oN0 11b0 1oN0 11b0 1oN0 11b0 10N0 1BX0 10p0 1pz0 10p0 1pz0 10p0 1db0 1dd0 1db0 1cN0 1db0 1cN0 1db0 1cN0 1db0 1BB0 ML0 1Bd0 ML0 uq10 1db0 1cN0 1db0 97B0 AL0|74e5\",\"Asia/Tashkent|LMT TAST TAST TASST TASST UZST UZT|-4B.b -50 -60 -70 -60 -60 -50|01232323232323232323232456|-1Pc4B.b eUnB.b 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 11y0 bf0|23e5\",\"Asia/Tbilisi|TBMT TBIT TBIT TBIST TBIST GEST GET GET GEST|-2X.b -30 -40 -50 -40 -40 -30 -40 -50|0123232323232323232323245656565787878787878787878567|-1Pc2X.b 1jUnX.b WCL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 3y0 19f0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cM0 1cL0 1fB0 3Nz0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 An0 Os0 WM0|11e5\",\"Asia/Tehran|LMT TMT IRST IRST IRDT IRDT|-3p.I -3p.I -3u -40 -50 -4u|01234325252525252525252525252525252525252525252525252525252525252525252525252525252525252525252525252|-2btDp.I 1d3c0 1huLT.I TXu 1pz0 sN0 vAu 1cL0 1dB0 1en0 pNB0 UL0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 64p0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0|14e6\",\"Asia/Thimphu|LMT IST BTT|-5W.A -5u -60|012|-Su5W.A 1BGMs.A|79e3\",\"Asia/Tokyo|JCST JST JDT|-90 -90 -a0|0121212121|-1iw90 pKq0 QL0 1lB0 13X0 1zB0 NX0 1zB0 NX0|38e6\",\"Asia/Tomsk|LMT +06 +07 +08|-5D.P -60 -70 -80|0123232323232323232323212323232323232323232323212121212121212121212|-21NhD.P pxzD.P 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 co0 1bB0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3Qp0|10e5\",\"Asia/Ulaanbaatar|LMT ULAT ULAT ULAST|-77.w -70 -80 -90|012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-2APH7.w 2Uko7.w cKn0 1db0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 kEp0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1fx0 1cP0 1cJ0 1cP0 1cJ0 1cP0 1cJ0|12e5\",\"Asia/Ust-Nera|LMT YAKT YAKT MAGST MAGT MAGST MAGT MAGT VLAT VLAT|-9w.S -80 -90 -c0 -b0 -b0 -a0 -c0 -b0 -a0|0123434343434343434343456434343434343434343434343434343434343434789|-21Q9w.S pApw.S 23CL0 1d90 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 17V0 7zD0|65e2\",\"Asia/Vladivostok|LMT VLAT VLAT VLAST VLAST VLAT|-8L.v -90 -a0 -b0 -a0 -b0|012323232323232323232324123232323232323232323232323232323232323252|-1SJIL.v itXL.v 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|60e4\",\"Asia/Yakutsk|LMT YAKT YAKT YAKST YAKST YAKT|-8C.W -80 -90 -a0 -90 -a0|012323232323232323232324123232323232323232323232323232323232323252|-21Q8C.W pAoC.W 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|28e4\",\"Asia/Yekaterinburg|LMT PMT SVET SVET SVEST SVEST YEKT YEKST YEKT|-42.x -3J.5 -40 -50 -60 -50 -50 -60 -60|0123434343434343434343435267676767676767676767676767676767676767686|-2ag42.x 7mQh.s qBvJ.5 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|14e5\",\"Asia/Yerevan|LMT YERT YERT YERST YERST AMST AMT AMT AMST|-2W -30 -40 -50 -40 -40 -30 -40 -50|0123232323232323232323245656565657878787878787878787878787878787|-1Pc2W 1jUnW WCL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1am0 2r0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 3Fb0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0|13e5\",\"Atlantic/Azores|HMT AZOT AZOST AZOMT AZOT AZOST WET|1S.w 20 10 0 10 0 0|01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121454545454545454545454545454545456545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-2ldW5.s aPX5.s Sp0 LX0 1vc0 Tc0 1uM0 SM0 1vc0 Tc0 1vc0 SM0 1vc0 6600 1co0 3E00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 3I00 17c0 1cM0 1cM0 3Fc0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 1tA0 1cM0 1dc0 1400 gL0 IM0 s10 U00 dX0 Rc0 pd0 Rc0 gL0 Oo0 pd0 Rc0 gL0 Oo0 pd0 14o0 1cM0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 3Co0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 qIl0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|25e4\",\"Atlantic/Bermuda|LMT AST ADT|4j.i 40 30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1BnRE.G 1LTbE.G 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|65e3\",\"Atlantic/Canary|LMT CANT WET WEST|11.A 10 0 -10|01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-1UtaW.o XPAW.o 1lAK0 1a10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|54e4\",\"Atlantic/Cape_Verde|LMT CVT CVST CVT|1y.4 20 10 10|01213|-2xomp.U 1qOMp.U 7zX0 1djf0|50e4\",\"Atlantic/Faroe|LMT WET WEST|r.4 0 -10|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2uSnw.U 2Wgow.U 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|49e3\",\"Atlantic/Madeira|FMT MADT MADST MADMT WET WEST|17.A 10 0 -10 0 -10|01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-2ldWQ.o aPWQ.o Sp0 LX0 1vc0 Tc0 1uM0 SM0 1vc0 Tc0 1vc0 SM0 1vc0 6600 1co0 3E00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 3I00 17c0 1cM0 1cM0 3Fc0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 1tA0 1cM0 1dc0 1400 gL0 IM0 s10 U00 dX0 Rc0 pd0 Rc0 gL0 Oo0 pd0 Rc0 gL0 Oo0 pd0 14o0 1cM0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 3Co0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 qIl0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|27e4\",\"Atlantic/Reykjavik|LMT IST ISST GMT|1s 10 0 0|012121212121212121212121212121212121212121212121212121212121212121213|-2uWmw mfaw 1Bd0 ML0 1LB0 Cn0 1LB0 3fX0 C10 HrX0 1cO0 LB0 1EL0 LA0 1C00 Oo0 1wo0 Rc0 1wo0 Rc0 1wo0 Rc0 1zc0 Oo0 1zc0 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1lc0 14o0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 14o0|12e4\",\"Atlantic/South_Georgia|GST|20|0||30\",\"Atlantic/Stanley|SMT FKT FKST FKT FKST|3P.o 40 30 30 20|0121212121212134343212121212121212121212121212121212121212121212121212|-2kJw8.A 12bA8.A 19X0 1fB0 19X0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 Cn0 1Cc10 WL0 1qL0 U10 1tz0 U10 1qM0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1tz0 U10 1tz0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1tz0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qN0 U10 1wn0 Rd0 1wn0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1wn0 U10 1tz0 U10 1tz0 U10|21e2\",\"Australia/Sydney|AEST AEDT|-a0 -b0|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 14o0 1o00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 11A0 1o00 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|40e5\",\"Australia/Adelaide|ACST ACDT|-9u -au|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lt xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 Oo0 1zc0 WM0 1qM0 Rc0 1zc0 U00 1tA0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|11e5\",\"Australia/Brisbane|AEST AEDT|-a0 -b0|01010101010101010|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 H1A0 Oo0 1zc0 Oo0 1zc0 Oo0|20e5\",\"Australia/Broken_Hill|ACST ACDT|-9u -au|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lt xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 14o0 1o00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|18e3\",\"Australia/Currie|AEST AEDT|-a0 -b0|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-29E80 19X0 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|746\",\"Australia/Darwin|ACST ACDT|-9u -au|010101010|-293lt xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0|12e4\",\"Australia/Eucla|ACWST ACWDT|-8J -9J|0101010101010101010|-293kI xcX 10jd0 yL0 1cN0 1cL0 1gSp0 Oo0 l5A0 Oo0 iJA0 G00 zU00 IM0 1qM0 11A0 1o00 11A0|368\",\"Australia/Hobart|AEST AEDT|-a0 -b0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-29E80 19X0 10jd0 yL0 1cN0 1cL0 1fB0 19X0 VfB0 1cM0 1o00 Rc0 1wo0 Rc0 1wo0 U00 1wo0 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|21e4\",\"Australia/Lord_Howe|AEST LHST LHDT LHDT|-a0 -au -bu -b0|0121212121313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313|raC0 1zdu Rb0 1zd0 On0 1zd0 On0 1zd0 On0 1zd0 TXu 1qMu WLu 1tAu WLu 1tAu TXu 1tAu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu 11zu 1o0u 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 11Au 1nXu 1qMu 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 1qMu 11zu 1o0u WLu 1qMu 14nu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1fzu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu|347\",\"Australia/Lindeman|AEST AEDT|-a0 -b0|010101010101010101010|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 H1A0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0|10\",\"Australia/Melbourne|AEST AEDT|-a0 -b0|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|-293lX xcX 10jd0 yL0 1cN0 1cL0 1fB0 19X0 17c10 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1qM0 11A0 1tA0 U00 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 11A0 1o00 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0|39e5\",\"Australia/Perth|AWST AWDT|-80 -90|0101010101010101010|-293jX xcX 10jd0 yL0 1cN0 1cL0 1gSp0 Oo0 l5A0 Oo0 iJA0 G00 zU00 IM0 1qM0 11A0 1o00 11A0|18e5\",\"CET|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 1cM0 16M0 1gMM0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\",\"CST6CDT|CST CDT CWT CPT|60 50 50 50|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261s0 1nX0 11B0 1nX0 SgN0 8x30 iw0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Pacific/Easter|EMT EAST EASST EAST EASST|7h.s 70 60 60 50|0121212121212121212121212121234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434|-1uSgG.w 1s4IG.w WL0 1zd0 On0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Dd0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1Nb0 Ap0|30e2\",\"EET|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\",\"EST|EST|50|0|\",\"EST5EDT|EST EDT EWT EPT|50 40 40 40|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261t0 1nX0 11B0 1nX0 SgN0 8x40 iv0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Europe/Dublin|DMT IST GMT BST IST|p.l -y.D 0 -10 -10|01232323232324242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242|-2ax9y.D Rc0 1fzy.D 14M0 1fc0 1g00 1co0 1dc0 1co0 1oo0 1400 1dc0 19A0 1io0 1io0 WM0 1o00 14o0 1o00 17c0 1io0 17c0 1fA0 1a00 1lc0 17c0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1cM0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1io0 1qM0 Dc0 g5X0 14p0 1wn0 17d0 1io0 11A0 1o00 17c0 1fA0 1a00 1fA0 1cM0 1fA0 1a00 17c0 1fA0 1a00 1io0 17c0 1lc0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1a00 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1tA0 IM0 90o0 U00 1tA0 U00 1tA0 U00 1tA0 U00 1tA0 WM0 1qM0 WM0 1qM0 WM0 1tA0 U00 1tA0 U00 1tA0 11z0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 14o0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Etc/GMT+0|GMT|0|0|\",\"Etc/GMT+1|GMT+1|10|0|\",\"Etc/GMT+10|GMT+10|a0|0|\",\"Etc/GMT+11|GMT+11|b0|0|\",\"Etc/GMT+12|GMT+12|c0|0|\",\"Etc/GMT+2|GMT+2|20|0|\",\"Etc/GMT+3|GMT+3|30|0|\",\"Etc/GMT+4|GMT+4|40|0|\",\"Etc/GMT+5|GMT+5|50|0|\",\"Etc/GMT+6|GMT+6|60|0|\",\"Etc/GMT+7|GMT+7|70|0|\",\"Etc/GMT+8|GMT+8|80|0|\",\"Etc/GMT+9|GMT+9|90|0|\",\"Etc/GMT-1|GMT-1|-10|0|\",\"Etc/GMT-10|GMT-10|-a0|0|\",\"Etc/GMT-11|GMT-11|-b0|0|\",\"Etc/GMT-12|GMT-12|-c0|0|\",\"Etc/GMT-13|GMT-13|-d0|0|\",\"Etc/GMT-14|GMT-14|-e0|0|\",\"Etc/GMT-2|GMT-2|-20|0|\",\"Etc/GMT-3|GMT-3|-30|0|\",\"Etc/GMT-4|GMT-4|-40|0|\",\"Etc/GMT-5|GMT-5|-50|0|\",\"Etc/GMT-6|GMT-6|-60|0|\",\"Etc/GMT-7|GMT-7|-70|0|\",\"Etc/GMT-8|GMT-8|-80|0|\",\"Etc/GMT-9|GMT-9|-90|0|\",\"Etc/UCT|UCT|0|0|\",\"Etc/UTC|UTC|0|0|\",\"Europe/Amsterdam|AMT NST NEST NET CEST CET|-j.w -1j.w -1k -k -20 -10|010101010101010101010101010101010101010101012323234545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545|-2aFcj.w 11b0 1iP0 11A0 1io0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1co0 1io0 1yo0 Pc0 1a00 1fA0 1Bc0 Mo0 1tc0 Uo0 1tA0 U00 1uo0 W00 1s00 VA0 1so0 Vc0 1sM0 UM0 1wo0 Rc0 1u00 Wo0 1rA0 W00 1s00 VA0 1sM0 UM0 1w00 fV0 BCX.w 1tA0 U00 1u00 Wo0 1sm0 601k WM0 1fA0 1cM0 1cM0 1cM0 16M0 1gMM0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|16e5\",\"Europe/Andorra|WET CET CEST|0 -10 -20|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-UBA0 1xIN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|79e3\",\"Europe/Astrakhan|LMT +03 +04 +05|-3c.c -30 -40 -50|012323232323232323212121212121212121212121212121212121212121212|-1Pcrc.c eUMc.c 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 3Co0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0\",\"Europe/Athens|AMT EET EEST CEST CET|-1y.Q -20 -30 -20 -10|012123434121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2a61x.Q CNbx.Q mn0 kU10 9b0 3Es0 Xa0 1fb0 1dd0 k3X0 Nz0 SCp0 1vc0 SO0 1cM0 1a00 1ao0 1fc0 1a10 1fG0 1cg0 1dX0 1bX0 1cQ0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|35e5\",\"Europe/London|GMT BST BDST|0 -10 -20|0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2axa0 Rc0 1fA0 14M0 1fc0 1g00 1co0 1dc0 1co0 1oo0 1400 1dc0 19A0 1io0 1io0 WM0 1o00 14o0 1o00 17c0 1io0 17c0 1fA0 1a00 1lc0 17c0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1cM0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1io0 1qM0 Dc0 2Rz0 Dc0 1zc0 Oo0 1zc0 Rc0 1wo0 17c0 1iM0 FA0 xB0 1fA0 1a00 14o0 bb0 LA0 xB0 Rc0 1wo0 11A0 1o00 17c0 1fA0 1a00 1fA0 1cM0 1fA0 1a00 17c0 1fA0 1a00 1io0 17c0 1lc0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1a00 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1tA0 IM0 90o0 U00 1tA0 U00 1tA0 U00 1tA0 U00 1tA0 WM0 1qM0 WM0 1qM0 WM0 1tA0 U00 1tA0 U00 1tA0 11z0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 14o0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|10e6\",\"Europe/Belgrade|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-19RC0 3IP0 WM0 1fA0 1cM0 1cM0 1rc0 Qo0 1vmo0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Berlin|CET CEST CEMT|-10 -20 -30|01010101010101210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 1cM0 kL0 Nc0 m10 WM0 1ao0 1cp0 dX0 jz0 Dd0 1io0 17c0 1fA0 1a00 1ehA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|41e5\",\"Europe/Prague|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 16M0 1lc0 1tA0 17A0 11c0 1io0 17c0 1io0 17c0 1fc0 1ao0 1bNc0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|13e5\",\"Europe/Brussels|WET CET CEST WEST|0 -10 -20 -10|0121212103030303030303030303030303030303030303030303212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ehc0 3zX0 11c0 1iO0 11A0 1o00 11A0 my0 Ic0 1qM0 Rc0 1EM0 UM0 1u00 10o0 1io0 1io0 17c0 1a00 1fA0 1cM0 1cM0 1io0 17c0 1fA0 1a00 1io0 1a30 1io0 17c0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 y00 5Wn0 WM0 1fA0 1cM0 16M0 1iM0 16M0 1C00 Uo0 1eeo0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|21e5\",\"Europe/Bucharest|BMT EET EEST|-1I.o -20 -30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1xApI.o 20LI.o RA0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1Axc0 On0 1fA0 1a10 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cK0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cL0 1cN0 1cL0 1fB0 1nX0 11E0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|19e5\",\"Europe/Budapest|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1ip0 17b0 1op0 1tb0 Q2m0 3Ne0 WM0 1fA0 1cM0 1cM0 1oJ0 1dc0 1030 1fA0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1iM0 1fA0 8Ha0 Rb0 1wN0 Rb0 1BB0 Lz0 1C20 LB0 SNX0 1a10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|17e5\",\"Europe/Zurich|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-19Lc0 11A0 1o00 11A0 1xG10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|38e4\",\"Europe/Chisinau|CMT BMT EET EEST CEST CET MSK MSD|-1T -1I.o -20 -30 -20 -10 -30 -40|012323232323232323234545467676767676767676767323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|-26jdT wGMa.A 20LI.o RA0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 27A0 2en0 39g0 WM0 1fA0 1cM0 V90 1t7z0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 gL0 WO0 1cM0 1cM0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1nX0 11D0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|67e4\",\"Europe/Copenhagen|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2azC0 Tz0 VuO0 60q0 WM0 1fA0 1cM0 1cM0 1cM0 S00 1HA0 Nc0 1C00 Dc0 1Nc0 Ao0 1h5A0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Gibraltar|GMT BST BDST CET CEST|0 -10 -20 -10 -20|010101010101010101010101010101010101010101010101012121212121010121010101010101010101034343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|-2axa0 Rc0 1fA0 14M0 1fc0 1g00 1co0 1dc0 1co0 1oo0 1400 1dc0 19A0 1io0 1io0 WM0 1o00 14o0 1o00 17c0 1io0 17c0 1fA0 1a00 1lc0 17c0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1cM0 1io0 17c0 1fA0 1a00 1io0 17c0 1io0 17c0 1fA0 1a00 1io0 1qM0 Dc0 2Rz0 Dc0 1zc0 Oo0 1zc0 Rc0 1wo0 17c0 1iM0 FA0 xB0 1fA0 1a00 14o0 bb0 LA0 xB0 Rc0 1wo0 11A0 1o00 17c0 1fA0 1a00 1fA0 1cM0 1fA0 1a00 17c0 1fA0 1a00 1io0 17c0 1lc0 17c0 1fA0 10Jz0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|30e3\",\"Europe/Helsinki|HMT EET EEST|-1D.N -20 -30|0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-1WuND.N OULD.N 1dA0 1xGq0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Kaliningrad|CET CEST CET CEST MSK MSD EEST EET FET|-10 -20 -20 -30 -30 -40 -30 -20 -30|0101010101010232454545454545454546767676767676767676767676767676767676767676787|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 Am0 Lb0 1en0 op0 1pNz0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|44e4\",\"Europe/Kiev|KMT EET MSK CEST CET MSD EEST|-22.4 -20 -30 -20 -10 -40 -30|0123434252525252525252525256161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161|-1Pc22.4 eUo2.4 rnz0 2Hg0 WM0 1fA0 da0 1v4m0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 Db0 3220 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cQ0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|34e5\",\"Europe/Kirov|LMT +03 +04 +05|-3i.M -30 -40 -50|01232323232323232321212121212121212121212121212121212121212121|-22WNi.M qHai.M 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 3Co0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|48e4\",\"Europe/Lisbon|LMT WET WEST WEMT CET CEST|A.J 0 -10 -20 -10 -20|012121212121212121212121212121212121212121212321232123212321212121212121212121212121212121212121214121212121212121212121212121212124545454212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ldXn.f aPWn.f Sp0 LX0 1vc0 Tc0 1uM0 SM0 1vc0 Tc0 1vc0 SM0 1vc0 6600 1co0 3E00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 3I00 17c0 1cM0 1cM0 3Fc0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 1tA0 1cM0 1dc0 1400 gL0 IM0 s10 U00 dX0 Rc0 pd0 Rc0 gL0 Oo0 pd0 Rc0 gL0 Oo0 pd0 14o0 1cM0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 3Co0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 pvy0 1cM0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|27e5\",\"Europe/Luxembourg|LMT CET CEST WET WEST WEST WET|-o.A -10 -20 0 -10 -20 -10|0121212134343434343434343434343434343434343434343434565651212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2DG0o.A t6mo.A TB0 1nX0 Up0 1o20 11A0 rW0 CM0 1qP0 R90 1EO0 UK0 1u20 10m0 1ip0 1in0 17e0 19W0 1fB0 1db0 1cp0 1in0 17d0 1fz0 1a10 1in0 1a10 1in0 17f0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Dc0 vA0 60L0 WM0 1fA0 1cM0 17c0 1io0 16M0 1C00 Uo0 1eeo0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|54e4\",\"Europe/Madrid|WET WEST WEMT CET CEST|0 -10 -20 -10 -20|01010101010101010101010121212121234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|-28dd0 11A0 1go0 19A0 1co0 1dA0 b1A0 18o0 3I00 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 iyo0 Rc0 18o0 1hc0 1io0 1a00 14o0 5aL0 MM0 1vc0 17A0 1i00 1bc0 1eo0 17d0 1in0 17A0 6hA0 10N0 XIL0 1a10 1in0 17d0 19X0 1cN0 1fz0 1a10 1fX0 1cp0 1cO0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|62e5\",\"Europe/Malta|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2as10 M00 1cM0 1cM0 14o0 1o00 WM0 1qM0 17c0 1cM0 M3A0 5M20 WM0 1fA0 1cM0 1cM0 1cM0 16m0 1de0 1lc0 14m0 1lc0 WO0 1qM0 GTW0 On0 1C10 Lz0 1C10 Lz0 1EN0 Lz0 1C10 Lz0 1zd0 Oo0 1C00 On0 1cp0 1cM0 1lA0 Xc0 1qq0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1iN0 19z0 1fB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|42e4\",\"Europe/Minsk|MMT EET MSK CEST CET MSD EEST FET|-1O -20 -30 -20 -10 -40 -30 -30|012343432525252525252525252616161616161616161616161616161616161616172|-1Pc1O eUnO qNX0 3gQ0 WM0 1fA0 1cM0 Al0 1tsn0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 3Fc0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hy0|19e5\",\"Europe/Monaco|PMT WET WEST WEMT CET CEST|-9.l 0 -10 -20 -10 -20|01212121212121212121212121212121212121212121212121232323232345454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-2nco9.l cNb9.l HA0 19A0 1iM0 11c0 1oo0 Wo0 1rc0 QM0 1EM0 UM0 1u00 10o0 1io0 1wo0 Rc0 1a00 1fA0 1cM0 1cM0 1io0 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Df0 2RV0 11z0 11B0 1ze0 WM0 1fA0 1cM0 1fa0 1aq0 16M0 1ekn0 1cL0 1fC0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|38e3\",\"Europe/Moscow|MMT MMT MST MDST MSD MSK MSM EET EEST MSK|-2u.h -2v.j -3v.j -4v.j -40 -30 -50 -20 -30 -40|012132345464575454545454545454545458754545454545454545454545454545454545454595|-2ag2u.h 2pyW.W 1bA0 11X0 GN0 1Hb0 c20 imv.j 3DA0 dz0 15A0 c10 2q10 iM10 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|16e6\",\"Europe/Paris|PMT WET WEST CEST CET WEMT|-9.l 0 -10 -20 -10 -20|0121212121212121212121212121212121212121212121212123434352543434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434|-2nco8.l cNb8.l HA0 19A0 1iM0 11c0 1oo0 Wo0 1rc0 QM0 1EM0 UM0 1u00 10o0 1io0 1wo0 Rc0 1a00 1fA0 1cM0 1cM0 1io0 17c0 1fA0 1a00 1io0 1a00 1io0 17c0 1fA0 1a00 1io0 17c0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1a00 1fA0 1io0 17c0 1cM0 1cM0 1a00 1fA0 1io0 1qM0 Df0 Ik0 5M30 WM0 1fA0 1cM0 Vx0 hB0 1aq0 16M0 1ekn0 1cL0 1fC0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|11e6\",\"Europe/Riga|RMT LST EET MSK CEST CET MSD EEST|-1A.y -2A.y -20 -30 -20 -10 -40 -30|010102345454536363636363636363727272727272727272727272727272727272727272727272727272727272727272727272727272727272727272727272|-25TzA.y 11A0 1iM0 ko0 gWm0 yDXA.y 2bX0 3fE0 WM0 1fA0 1cM0 1cM0 4m0 1sLy0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 1o00 11A0 1o00 11A0 1qM0 3oo0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|64e4\",\"Europe/Rome|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2as10 M00 1cM0 1cM0 14o0 1o00 WM0 1qM0 17c0 1cM0 M3A0 5M20 WM0 1fA0 1cM0 16K0 1iO0 16m0 1de0 1lc0 14m0 1lc0 WO0 1qM0 GTW0 On0 1C10 Lz0 1C10 Lz0 1EN0 Lz0 1C10 Lz0 1zd0 Oo0 1C00 On0 1C10 Lz0 1zd0 On0 1C10 LA0 1C00 LA0 1zc0 Oo0 1C00 Oo0 1zc0 Oo0 1fC0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|39e5\",\"Europe/Samara|LMT SAMT SAMT KUYT KUYST MSD MSK EEST SAMST SAMST|-3k.k -30 -40 -40 -50 -40 -30 -30 -50 -40|012343434343434343435656712828282828282828282828282828282828282912|-22WNk.k qHak.k bcn0 1Qqo0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cN0 8o0 14m0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qN0 WM0|12e5\",\"Europe/Simferopol|SMT EET MSK CEST CET MSD EEST MSK|-2g -20 -30 -20 -10 -40 -30 -40|012343432525252525252525252161616525252616161616161616161616161616161616172|-1Pc2g eUog rEn0 2qs0 WM0 1fA0 1cM0 3V0 1u0L0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1Q00 4eL0 1cL0 1cN0 1cL0 1cN0 dX0 WL0 1cN0 1cL0 1fB0 1o30 11B0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11z0 1nW0|33e4\",\"Europe/Sofia|EET CET CEST EEST|-20 -10 -20 -30|01212103030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030|-168L0 WM0 1fA0 1cM0 1cM0 1cN0 1mKH0 1dd0 1fb0 1ap0 1fb0 1a20 1fy0 1a30 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1nX0 11E0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|12e5\",\"Europe/Stockholm|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2azC0 TB0 2yDe0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|15e5\",\"Europe/Tallinn|TMT CET CEST EET MSK MSD EEST|-1D -10 -20 -20 -30 -40 -30|012103421212454545454545454546363636363636363636363636363636363636363636363636363636363636363636363636363636363636363636363|-26oND teD 11A0 1Ta0 4rXl KSLD 2FX0 2Jg0 WM0 1fA0 1cM0 18J0 1sTX0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o10 11A0 1qM0 5QM0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|41e4\",\"Europe/Tirane|LMT CET CEST|-1j.k -10 -20|01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2glBj.k 14pcj.k 5LC0 WM0 4M0 1fCK0 10n0 1op0 11z0 1pd0 11z0 1qN0 WL0 1qp0 Xb0 1qp0 Xb0 1qp0 11z0 1lB0 11z0 1qN0 11z0 1iN0 16n0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|42e4\",\"Europe/Ulyanovsk|LMT +03 +04 +05 +02|-3d.A -30 -40 -50 -20|01232323232323232321214121212121212121212121212121212121212121212|-22WNd.A qHad.A 23CL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0\",\"Europe/Uzhgorod|CET CEST MSK MSD EET EEST|-10 -20 -30 -40 -20 -30|010101023232323232323232320454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|-1cqL0 6i00 WM0 1fA0 1cM0 1ml0 1Cp0 1r3W0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1Q00 1Nf0 2pw0 1cL0 1cN0 1cL0 1cN0 1cL0 1cQ0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|11e4\",\"Europe/Vienna|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 3KM0 14o0 LA00 6i00 WM0 1fA0 1cM0 1cM0 1cM0 400 2qM0 1a00 1cM0 1cM0 1io0 17c0 1gHa0 19X0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|18e5\",\"Europe/Vilnius|WMT KMT CET EET MSK CEST MSD EEST|-1o -1z.A -10 -20 -30 -20 -40 -30|012324525254646464646464646473737373737373737352537373737373737373737373737373737373737373737373737373737373737373737373|-293do 6ILM.o 1Ooz.A zz0 Mfd0 29W0 3is0 WM0 1fA0 1cM0 LV0 1tgL0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11B0 1o00 11A0 1qM0 8io0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|54e4\",\"Europe/Volgograd|LMT TSAT STAT STAT VOLT VOLST VOLST VOLT MSD MSK MSK|-2V.E -30 -30 -40 -40 -50 -40 -30 -40 -30 -40|0123454545454545454676767489898989898989898989898989898989898989a9|-21IqV.E cLXV.E cEM0 1gqn0 Lco0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1cM0 1fA0 1cM0 2pz0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|10e5\",\"Europe/Warsaw|WMT CET CEST EET EEST|-1o -10 -20 -20 -30|012121234312121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|-2ctdo 1LXo 11d0 1iO0 11A0 1o00 11A0 1on0 11A0 6zy0 HWP0 5IM0 WM0 1fA0 1cM0 1dz0 1mL0 1en0 15B0 1aq0 1nA0 11A0 1io0 17c0 1fA0 1a00 iDX0 LA0 1cM0 1cM0 1C00 Oo0 1cM0 1cM0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1C00 LA0 uso0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|17e5\",\"Europe/Zaporozhye|CUT EET MSK CEST CET MSD EEST|-2k -20 -30 -20 -10 -40 -30|01234342525252525252525252526161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161|-1Pc2k eUok rdb0 2RE0 WM0 1fA0 8m0 1v9a0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cK0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cQ0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00|77e4\",\"HST|HST|a0|0|\",\"Indian/Chagos|LMT IOT IOT|-4N.E -50 -60|012|-2xosN.E 3AGLN.E|30e2\",\"Indian/Christmas|CXT|-70|0||21e2\",\"Indian/Cocos|CCT|-6u|0||596\",\"Indian/Kerguelen|-00 TFT|0 -50|01|-MG00|130\",\"Indian/Mahe|LMT SCT|-3F.M -40|01|-2yO3F.M|79e3\",\"Indian/Maldives|MMT MVT|-4S -50|01|-olgS|35e4\",\"Indian/Mauritius|LMT MUT MUST|-3O -40 -50|012121|-2xorO 34unO 14L0 12kr0 11z0|15e4\",\"Indian/Reunion|LMT RET|-3F.Q -40|01|-2mDDF.Q|84e4\",\"Pacific/Kwajalein|MHT KWAT MHT|-b0 c0 -c0|012|-AX0 W9X0|14e3\",\"MET|MET MEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-2aFe0 11d0 1iO0 11A0 1o00 11A0 Qrc0 6i00 WM0 1fA0 1cM0 1cM0 1cM0 16M0 1gMM0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\",\"MST|MST|70|0|\",\"MST7MDT|MST MDT MWT MPT|70 60 60 60|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261r0 1nX0 11B0 1nX0 SgN0 8x20 ix0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Pacific/Chatham|CHAST CHAST CHADT|-cf -cJ -dJ|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|-WqAf 1adef IM0 1C00 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1qM0 14o0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1io0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00|600\",\"PST8PDT|PST PDT PWT PPT|80 70 70 70|010102301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|-261q0 1nX0 11B0 1nX0 SgN0 8x10 iy0 QwN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0\",\"Pacific/Apia|LMT WSST SST SDT WSDT WSST|bq.U bu b0 a0 -e0 -d0|01232345454545454545454545454545454545454545454545454545454|-2nDMx.4 1yW03.4 2rRbu 1ff0 1a00 CI0 AQ0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00|37e3\",\"Pacific/Bougainville|PGT JST BST|-a0 -90 -b0|0102|-16Wy0 7CN0 2MQp0|18e4\",\"Pacific/Chuuk|CHUT|-a0|0||49e3\",\"Pacific/Efate|LMT VUT VUST|-bd.g -b0 -c0|0121212121212121212121|-2l9nd.g 2Szcd.g 1cL0 1oN0 10L0 1fB0 19X0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 Lz0 1Nd0 An0|66e3\",\"Pacific/Enderbury|PHOT PHOT PHOT|c0 b0 -d0|012|nIc0 B8n0|1\",\"Pacific/Fakaofo|TKT TKT|b0 -d0|01|1Gfn0|483\",\"Pacific/Fiji|LMT FJT FJST|-bT.I -c0 -d0|0121212121212121212121212121212121212121212121212121212121212121|-2bUzT.I 3m8NT.I LA0 1EM0 IM0 nJc0 LA0 1o00 Rc0 1wo0 Ao0 1Nc0 Ao0 1Q00 xz0 1SN0 uM0 1SM0 uM0 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 uM0 1SM0 uM0 1SM0 uM0 1SM0 uM0|88e4\",\"Pacific/Funafuti|TVT|-c0|0||45e2\",\"Pacific/Galapagos|LMT ECT GALT|5W.o 50 60|012|-1yVS1.A 2dTz1.A|25e3\",\"Pacific/Gambier|LMT GAMT|8X.M 90|01|-2jof0.c|125\",\"Pacific/Guadalcanal|LMT SBT|-aD.M -b0|01|-2joyD.M|11e4\",\"Pacific/Guam|GST ChST|-a0 -a0|01|1fpq0|17e4\",\"Pacific/Honolulu|HST HDT HST|au 9u a0|010102|-1thLu 8x0 lef0 8Pz0 46p0|37e4\",\"Pacific/Kiritimati|LINT LINT LINT|aE a0 -e0|012|nIaE B8nk|51e2\",\"Pacific/Kosrae|KOST KOST|-b0 -c0|010|-AX0 1bdz0|66e2\",\"Pacific/Majuro|MHT MHT|-b0 -c0|01|-AX0|28e3\",\"Pacific/Marquesas|LMT MART|9i 9u|01|-2joeG|86e2\",\"Pacific/Pago_Pago|LMT NST BST SST|bm.M b0 b0 b0|0123|-2nDMB.c 2gVzB.c EyM0|37e2\",\"Pacific/Nauru|LMT NRT JST NRT|-b7.E -bu -90 -c0|01213|-1Xdn7.E PvzB.E 5RCu 1ouJu|10e3\",\"Pacific/Niue|NUT NUT NUT|bk bu b0|012|-KfME 17y0a|12e2\",\"Pacific/Norfolk|NMT NFT NFST NFT|-bc -bu -cu -b0|01213|-Kgbc W01G On0 1COp0|25e4\",\"Pacific/Noumea|LMT NCT NCST|-b5.M -b0 -c0|01212121|-2l9n5.M 2EqM5.M xX0 1PB0 yn0 HeP0 Ao0|98e3\",\"Pacific/Palau|PWT|-90|0||21e3\",\"Pacific/Pitcairn|PNT PST|8u 80|01|18Vku|56\",\"Pacific/Pohnpei|PONT|-b0|0||34e3\",\"Pacific/Port_Moresby|PGT|-a0|0||25e4\",\"Pacific/Rarotonga|CKT CKHST CKT|au 9u a0|012121212121212121212121212|lyWu IL0 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu Onu|13e3\",\"Pacific/Tahiti|LMT TAHT|9W.g a0|01|-2joe1.I|18e4\",\"Pacific/Tarawa|GILT|-c0|0||29e3\",\"Pacific/Tongatapu|TOT TOT TOST|-ck -d0 -e0|01212121|-1aB0k 2n5dk 15A0 1wo0 xz0 1Q10 xz0|75e3\",\"Pacific/Wake|WAKT|-c0|0||16e3\",\"Pacific/Wallis|WFT|-c0|0||94\",\"WET|WET WEST|0 -10|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00\"],\n    links:[\"Africa/Abidjan|Africa/Bamako\",\"Africa/Abidjan|Africa/Banjul\",\"Africa/Abidjan|Africa/Conakry\",\"Africa/Abidjan|Africa/Dakar\",\"Africa/Abidjan|Africa/Freetown\",\"Africa/Abidjan|Africa/Lome\",\"Africa/Abidjan|Africa/Nouakchott\",\"Africa/Abidjan|Africa/Ouagadougou\",\"Africa/Abidjan|Africa/Sao_Tome\",\"Africa/Abidjan|Africa/Timbuktu\",\"Africa/Abidjan|Atlantic/St_Helena\",\"Africa/Cairo|Egypt\",\"Africa/Johannesburg|Africa/Maseru\",\"Africa/Johannesburg|Africa/Mbabane\",\"Africa/Khartoum|Africa/Juba\",\"Africa/Lagos|Africa/Bangui\",\"Africa/Lagos|Africa/Brazzaville\",\"Africa/Lagos|Africa/Douala\",\"Africa/Lagos|Africa/Kinshasa\",\"Africa/Lagos|Africa/Libreville\",\"Africa/Lagos|Africa/Luanda\",\"Africa/Lagos|Africa/Malabo\",\"Africa/Lagos|Africa/Niamey\",\"Africa/Lagos|Africa/Porto-Novo\",\"Africa/Maputo|Africa/Blantyre\",\"Africa/Maputo|Africa/Bujumbura\",\"Africa/Maputo|Africa/Gaborone\",\"Africa/Maputo|Africa/Harare\",\"Africa/Maputo|Africa/Kigali\",\"Africa/Maputo|Africa/Lubumbashi\",\"Africa/Maputo|Africa/Lusaka\",\"Africa/Nairobi|Africa/Addis_Ababa\",\"Africa/Nairobi|Africa/Asmara\",\"Africa/Nairobi|Africa/Asmera\",\"Africa/Nairobi|Africa/Dar_es_Salaam\",\"Africa/Nairobi|Africa/Djibouti\",\"Africa/Nairobi|Africa/Kampala\",\"Africa/Nairobi|Africa/Mogadishu\",\"Africa/Nairobi|Indian/Antananarivo\",\"Africa/Nairobi|Indian/Comoro\",\"Africa/Nairobi|Indian/Mayotte\",\"Africa/Tripoli|Libya\",\"America/Adak|America/Atka\",\"America/Adak|US/Aleutian\",\"America/Anchorage|US/Alaska\",\"America/Argentina/Buenos_Aires|America/Buenos_Aires\",\"America/Argentina/Catamarca|America/Argentina/ComodRivadavia\",\"America/Argentina/Catamarca|America/Catamarca\",\"America/Argentina/Cordoba|America/Cordoba\",\"America/Argentina/Cordoba|America/Rosario\",\"America/Argentina/Jujuy|America/Jujuy\",\"America/Argentina/Mendoza|America/Mendoza\",\"America/Atikokan|America/Coral_Harbour\",\"America/Chicago|US/Central\",\"America/Curacao|America/Aruba\",\"America/Curacao|America/Kralendijk\",\"America/Curacao|America/Lower_Princes\",\"America/Denver|America/Shiprock\",\"America/Denver|Navajo\",\"America/Denver|US/Mountain\",\"America/Detroit|US/Michigan\",\"America/Edmonton|Canada/Mountain\",\"America/Fort_Wayne|America/Indiana/Indianapolis\",\"America/Fort_Wayne|America/Indianapolis\",\"America/Fort_Wayne|US/East-Indiana\",\"America/Halifax|Canada/Atlantic\",\"America/Havana|Cuba\",\"America/Indiana/Knox|America/Knox_IN\",\"America/Indiana/Knox|US/Indiana-Starke\",\"America/Jamaica|Jamaica\",\"America/Kentucky/Louisville|America/Louisville\",\"America/Los_Angeles|US/Pacific\",\"America/Los_Angeles|US/Pacific-New\",\"America/Manaus|Brazil/West\",\"America/Mazatlan|Mexico/BajaSur\",\"America/Mexico_City|Mexico/General\",\"America/New_York|US/Eastern\",\"America/Noronha|Brazil/DeNoronha\",\"America/Panama|America/Cayman\",\"America/Phoenix|US/Arizona\",\"America/Port_of_Spain|America/Anguilla\",\"America/Port_of_Spain|America/Antigua\",\"America/Port_of_Spain|America/Dominica\",\"America/Port_of_Spain|America/Grenada\",\"America/Port_of_Spain|America/Guadeloupe\",\"America/Port_of_Spain|America/Marigot\",\"America/Port_of_Spain|America/Montserrat\",\"America/Port_of_Spain|America/St_Barthelemy\",\"America/Port_of_Spain|America/St_Kitts\",\"America/Port_of_Spain|America/St_Lucia\",\"America/Port_of_Spain|America/St_Thomas\",\"America/Port_of_Spain|America/St_Vincent\",\"America/Port_of_Spain|America/Tortola\",\"America/Port_of_Spain|America/Virgin\",\"America/Regina|Canada/East-Saskatchewan\",\"America/Regina|Canada/Saskatchewan\",\"America/Rio_Branco|America/Porto_Acre\",\"America/Rio_Branco|Brazil/Acre\",\"America/Santiago|Chile/Continental\",\"America/Sao_Paulo|Brazil/East\",\"America/St_Johns|Canada/Newfoundland\",\"America/Tijuana|America/Ensenada\",\"America/Tijuana|America/Santa_Isabel\",\"America/Tijuana|Mexico/BajaNorte\",\"America/Toronto|America/Montreal\",\"America/Toronto|Canada/Eastern\",\"America/Vancouver|Canada/Pacific\",\"America/Whitehorse|Canada/Yukon\",\"America/Winnipeg|Canada/Central\",\"Asia/Ashgabat|Asia/Ashkhabad\",\"Asia/Bangkok|Asia/Phnom_Penh\",\"Asia/Bangkok|Asia/Vientiane\",\"Asia/Dhaka|Asia/Dacca\",\"Asia/Dubai|Asia/Muscat\",\"Asia/Ho_Chi_Minh|Asia/Saigon\",\"Asia/Hong_Kong|Hongkong\",\"Asia/Jerusalem|Asia/Tel_Aviv\",\"Asia/Jerusalem|Israel\",\"Asia/Kathmandu|Asia/Katmandu\",\"Asia/Kolkata|Asia/Calcutta\",\"Asia/Macau|Asia/Macao\",\"Asia/Makassar|Asia/Ujung_Pandang\",\"Asia/Nicosia|Europe/Nicosia\",\"Asia/Qatar|Asia/Bahrain\",\"Asia/Riyadh|Asia/Aden\",\"Asia/Riyadh|Asia/Kuwait\",\"Asia/Seoul|ROK\",\"Asia/Shanghai|Asia/Chongqing\",\"Asia/Shanghai|Asia/Chungking\",\"Asia/Shanghai|Asia/Harbin\",\"Asia/Shanghai|PRC\",\"Asia/Singapore|Singapore\",\"Asia/Taipei|ROC\",\"Asia/Tehran|Iran\",\"Asia/Thimphu|Asia/Thimbu\",\"Asia/Tokyo|Japan\",\"Asia/Ulaanbaatar|Asia/Ulan_Bator\",\"Asia/Urumqi|Asia/Kashgar\",\"Atlantic/Faroe|Atlantic/Faeroe\",\"Atlantic/Reykjavik|Iceland\",\"Australia/Adelaide|Australia/South\",\"Australia/Brisbane|Australia/Queensland\",\"Australia/Broken_Hill|Australia/Yancowinna\",\"Australia/Darwin|Australia/North\",\"Australia/Hobart|Australia/Tasmania\",\"Australia/Lord_Howe|Australia/LHI\",\"Australia/Melbourne|Australia/Victoria\",\"Australia/Perth|Australia/West\",\"Australia/Sydney|Australia/ACT\",\"Australia/Sydney|Australia/Canberra\",\"Australia/Sydney|Australia/NSW\",\"Etc/GMT+0|Etc/GMT\",\"Etc/GMT+0|Etc/GMT-0\",\"Etc/GMT+0|Etc/GMT0\",\"Etc/GMT+0|Etc/Greenwich\",\"Etc/GMT+0|GMT\",\"Etc/GMT+0|GMT+0\",\"Etc/GMT+0|GMT-0\",\"Etc/GMT+0|GMT0\",\"Etc/GMT+0|Greenwich\",\"Etc/UCT|UCT\",\"Etc/UTC|Etc/Universal\",\"Etc/UTC|Etc/Zulu\",\"Etc/UTC|UTC\",\"Etc/UTC|Universal\",\"Etc/UTC|Zulu\",\"Europe/Belgrade|Europe/Ljubljana\",\"Europe/Belgrade|Europe/Podgorica\",\"Europe/Belgrade|Europe/Sarajevo\",\"Europe/Belgrade|Europe/Skopje\",\"Europe/Belgrade|Europe/Zagreb\",\"Europe/Chisinau|Europe/Tiraspol\",\"Europe/Dublin|Eire\",\"Europe/Helsinki|Europe/Mariehamn\",\"Europe/Istanbul|Asia/Istanbul\",\"Europe/Istanbul|Turkey\",\"Europe/Lisbon|Portugal\",\"Europe/London|Europe/Belfast\",\"Europe/London|Europe/Guernsey\",\"Europe/London|Europe/Isle_of_Man\",\"Europe/London|Europe/Jersey\",\"Europe/London|GB\",\"Europe/London|GB-Eire\",\"Europe/Moscow|W-SU\",\"Europe/Oslo|Arctic/Longyearbyen\",\"Europe/Oslo|Atlantic/Jan_Mayen\",\"Europe/Prague|Europe/Bratislava\",\"Europe/Rome|Europe/San_Marino\",\"Europe/Rome|Europe/Vatican\",\"Europe/Warsaw|Poland\",\"Europe/Zurich|Europe/Busingen\",\"Europe/Zurich|Europe/Vaduz\",\"Pacific/Auckland|Antarctica/McMurdo\",\"Pacific/Auckland|Antarctica/South_Pole\",\"Pacific/Auckland|NZ\",\"Pacific/Chatham|NZ-CHAT\",\"Pacific/Chuuk|Pacific/Truk\",\"Pacific/Chuuk|Pacific/Yap\",\"Pacific/Easter|Chile/EasterIsland\",\"Pacific/Guam|Pacific/Saipan\",\"Pacific/Honolulu|Pacific/Johnston\",\"Pacific/Honolulu|US/Hawaii\",\"Pacific/Kwajalein|Kwajalein\",\"Pacific/Pago_Pago|Pacific/Midway\",\"Pacific/Pago_Pago|Pacific/Samoa\",\"Pacific/Pago_Pago|US/Samoa\",\"Pacific/Pohnpei|Pacific/Ponape\"]}),a});\n","MutationObserver.js":"/**\n * @license\n * Copyright (c) 2014 The Polymer Project Authors. All rights reserved.\n * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt\n * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt\n * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt\n * Code distributed by Google as part of the polymer project is also\n * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt\n */\n\n(function(global) {\n\n  var registrationsTable = new WeakMap();\n\n  var setImmediate;\n\n  // As much as we would like to use the native implementation, IE\n  // (all versions) suffers a rather annoying bug where it will drop or defer\n  // callbacks when heavy DOM operations are being performed concurrently.\n  //\n  // For a thorough discussion on this, see:\n  // http://codeforhire.com/2013/09/21/setimmediate-and-messagechannel-broken-on-internet-explorer-10/\n  if (/Trident|Edge/.test(navigator.userAgent)) {\n    // Sadly, this bug also affects postMessage and MessageQueues.\n    //\n    // We would like to use the onreadystatechange hack for IE <= 10, but it is\n    // dangerous in the polyfilled environment due to requiring that the\n    // observed script element be in the document.\n    setImmediate = setTimeout;\n\n  // If some other browser ever implements it, let's prefer their native\n  // implementation:\n  } else if (window.setImmediate) {\n    setImmediate = window.setImmediate;\n\n  // Otherwise, we fall back to postMessage as a means of emulating the next\n  // task semantics of setImmediate.\n  } else {\n    var setImmediateQueue = [];\n    var sentinel = String(Math.random());\n    window.addEventListener('message', function(e) {\n      if (e.data === sentinel) {\n        var queue = setImmediateQueue;\n        setImmediateQueue = [];\n        queue.forEach(function(func) {\n          func();\n        });\n      }\n    });\n    setImmediate = function(func) {\n      setImmediateQueue.push(func);\n      window.postMessage(sentinel, '*');\n    };\n  }\n\n  // This is used to ensure that we never schedule 2 callas to setImmediate\n  var isScheduled = false;\n\n  // Keep track of observers that needs to be notified next time.\n  var scheduledObservers = [];\n\n  /**\n   * Schedules |dispatchCallback| to be called in the future.\n   * @param {MutationObserver} observer\n   */\n  function scheduleCallback(observer) {\n    scheduledObservers.push(observer);\n    if (!isScheduled) {\n      isScheduled = true;\n      setImmediate(dispatchCallbacks);\n    }\n  }\n\n  function wrapIfNeeded(node) {\n    return window.ShadowDOMPolyfill &&\n        window.ShadowDOMPolyfill.wrapIfNeeded(node) ||\n        node;\n  }\n\n  function dispatchCallbacks() {\n    // http://dom.spec.whatwg.org/#mutation-observers\n\n    isScheduled = false; // Used to allow a new setImmediate call above.\n\n    var observers = scheduledObservers;\n    scheduledObservers = [];\n    // Sort observers based on their creation UID (incremental).\n    observers.sort(function(o1, o2) {\n      return o1.uid_ - o2.uid_;\n    });\n\n    var anyNonEmpty = false;\n    observers.forEach(function(observer) {\n\n      // 2.1, 2.2\n      var queue = observer.takeRecords();\n      // 2.3. Remove all transient registered observers whose observer is mo.\n      removeTransientObserversFor(observer);\n\n      // 2.4\n      if (queue.length) {\n        observer.callback_(queue, observer);\n        anyNonEmpty = true;\n      }\n    });\n\n    // 3.\n    if (anyNonEmpty)\n      dispatchCallbacks();\n  }\n\n  function removeTransientObserversFor(observer) {\n    observer.nodes_.forEach(function(node) {\n      var registrations = registrationsTable.get(node);\n      if (!registrations)\n        return;\n      registrations.forEach(function(registration) {\n        if (registration.observer === observer)\n          registration.removeTransientObservers();\n      });\n    });\n  }\n\n  /**\n   * This function is used for the \"For each registered observer observer (with\n   * observer's options as options) in target's list of registered observers,\n   * run these substeps:\" and the \"For each ancestor ancestor of target, and for\n   * each registered observer observer (with options options) in ancestor's list\n   * of registered observers, run these substeps:\" part of the algorithms. The\n   * |options.subtree| is checked to ensure that the callback is called\n   * correctly.\n   *\n   * @param {Node} target\n   * @param {function(MutationObserverInit):MutationRecord} callback\n   */\n  function forEachAncestorAndObserverEnqueueRecord(target, callback) {\n    for (var node = target; node; node = node.parentNode) {\n      var registrations = registrationsTable.get(node);\n\n      if (registrations) {\n        for (var j = 0; j < registrations.length; j++) {\n          var registration = registrations[j];\n          var options = registration.options;\n\n          // Only target ignores subtree.\n          if (node !== target && !options.subtree)\n            continue;\n\n          var record = callback(options);\n          if (record)\n            registration.enqueue(record);\n        }\n      }\n    }\n  }\n\n  var uidCounter = 0;\n\n  /**\n   * The class that maps to the DOM MutationObserver interface.\n   * @param {Function} callback.\n   * @constructor\n   */\n  function JsMutationObserver(callback) {\n    this.callback_ = callback;\n    this.nodes_ = [];\n    this.records_ = [];\n    this.uid_ = ++uidCounter;\n  }\n\n  JsMutationObserver.prototype = {\n    observe: function(target, options) {\n      target = wrapIfNeeded(target);\n\n      // 1.1\n      if (!options.childList && !options.attributes && !options.characterData ||\n\n          // 1.2\n          options.attributeOldValue && !options.attributes ||\n\n          // 1.3\n          options.attributeFilter && options.attributeFilter.length &&\n              !options.attributes ||\n\n          // 1.4\n          options.characterDataOldValue && !options.characterData) {\n\n        throw new SyntaxError();\n      }\n\n      var registrations = registrationsTable.get(target);\n      if (!registrations)\n        registrationsTable.set(target, registrations = []);\n\n      // 2\n      // If target's list of registered observers already includes a registered\n      // observer associated with the context object, replace that registered\n      // observer's options with options.\n      var registration;\n      for (var i = 0; i < registrations.length; i++) {\n        if (registrations[i].observer === this) {\n          registration = registrations[i];\n          registration.removeListeners();\n          registration.options = options;\n          break;\n        }\n      }\n\n      // 3.\n      // Otherwise, add a new registered observer to target's list of registered\n      // observers with the context object as the observer and options as the\n      // options, and add target to context object's list of nodes on which it\n      // is registered.\n      if (!registration) {\n        registration = new Registration(this, target, options);\n        registrations.push(registration);\n        this.nodes_.push(target);\n      }\n\n      registration.addListeners();\n    },\n\n    disconnect: function() {\n      this.nodes_.forEach(function(node) {\n        var registrations = registrationsTable.get(node);\n        for (var i = 0; i < registrations.length; i++) {\n          var registration = registrations[i];\n          if (registration.observer === this) {\n            registration.removeListeners();\n            registrations.splice(i, 1);\n            // Each node can only have one registered observer associated with\n            // this observer.\n            break;\n          }\n        }\n      }, this);\n      this.records_ = [];\n    },\n\n    takeRecords: function() {\n      var copyOfRecords = this.records_;\n      this.records_ = [];\n      return copyOfRecords;\n    }\n  };\n\n  /**\n   * @param {string} type\n   * @param {Node} target\n   * @constructor\n   */\n  function MutationRecord(type, target) {\n    this.type = type;\n    this.target = target;\n    this.addedNodes = [];\n    this.removedNodes = [];\n    this.previousSibling = null;\n    this.nextSibling = null;\n    this.attributeName = null;\n    this.attributeNamespace = null;\n    this.oldValue = null;\n  }\n\n  function copyMutationRecord(original) {\n    var record = new MutationRecord(original.type, original.target);\n    record.addedNodes = original.addedNodes.slice();\n    record.removedNodes = original.removedNodes.slice();\n    record.previousSibling = original.previousSibling;\n    record.nextSibling = original.nextSibling;\n    record.attributeName = original.attributeName;\n    record.attributeNamespace = original.attributeNamespace;\n    record.oldValue = original.oldValue;\n    return record;\n  };\n\n  // We keep track of the two (possibly one) records used in a single mutation.\n  var currentRecord, recordWithOldValue;\n\n  /**\n   * Creates a record without |oldValue| and caches it as |currentRecord| for\n   * later use.\n   * @param {string} oldValue\n   * @return {MutationRecord}\n   */\n  function getRecord(type, target) {\n    return currentRecord = new MutationRecord(type, target);\n  }\n\n  /**\n   * Gets or creates a record with |oldValue| based in the |currentRecord|\n   * @param {string} oldValue\n   * @return {MutationRecord}\n   */\n  function getRecordWithOldValue(oldValue) {\n    if (recordWithOldValue)\n      return recordWithOldValue;\n    recordWithOldValue = copyMutationRecord(currentRecord);\n    recordWithOldValue.oldValue = oldValue;\n    return recordWithOldValue;\n  }\n\n  function clearRecords() {\n    currentRecord = recordWithOldValue = undefined;\n  }\n\n  /**\n   * @param {MutationRecord} record\n   * @return {boolean} Whether the record represents a record from the current\n   * mutation event.\n   */\n  function recordRepresentsCurrentMutation(record) {\n    return record === recordWithOldValue || record === currentRecord;\n  }\n\n  /**\n   * Selects which record, if any, to replace the last record in the queue.\n   * This returns |null| if no record should be replaced.\n   *\n   * @param {MutationRecord} lastRecord\n   * @param {MutationRecord} newRecord\n   * @param {MutationRecord}\n   */\n  function selectRecord(lastRecord, newRecord) {\n    if (lastRecord === newRecord)\n      return lastRecord;\n\n    // Check if the the record we are adding represents the same record. If\n    // so, we keep the one with the oldValue in it.\n    if (recordWithOldValue && recordRepresentsCurrentMutation(lastRecord))\n      return recordWithOldValue;\n\n    return null;\n  }\n\n  /**\n   * Class used to represent a registered observer.\n   * @param {MutationObserver} observer\n   * @param {Node} target\n   * @param {MutationObserverInit} options\n   * @constructor\n   */\n  function Registration(observer, target, options) {\n    this.observer = observer;\n    this.target = target;\n    this.options = options;\n    this.transientObservedNodes = [];\n  }\n\n  Registration.prototype = {\n    enqueue: function(record) {\n      var records = this.observer.records_;\n      var length = records.length;\n\n      // There are cases where we replace the last record with the new record.\n      // For example if the record represents the same mutation we need to use\n      // the one with the oldValue. If we get same record (this can happen as we\n      // walk up the tree) we ignore the new record.\n      if (records.length > 0) {\n        var lastRecord = records[length - 1];\n        var recordToReplaceLast = selectRecord(lastRecord, record);\n        if (recordToReplaceLast) {\n          records[length - 1] = recordToReplaceLast;\n          return;\n        }\n      } else {\n        scheduleCallback(this.observer);\n      }\n\n      records[length] = record;\n    },\n\n    addListeners: function() {\n      this.addListeners_(this.target);\n    },\n\n    addListeners_: function(node) {\n      var options = this.options;\n      if (options.attributes)\n        node.addEventListener('DOMAttrModified', this, true);\n\n      if (options.characterData)\n        node.addEventListener('DOMCharacterDataModified', this, true);\n\n      if (options.childList)\n        node.addEventListener('DOMNodeInserted', this, true);\n\n      if (options.childList || options.subtree)\n        node.addEventListener('DOMNodeRemoved', this, true);\n    },\n\n    removeListeners: function() {\n      this.removeListeners_(this.target);\n    },\n\n    removeListeners_: function(node) {\n      var options = this.options;\n      if (options.attributes)\n        node.removeEventListener('DOMAttrModified', this, true);\n\n      if (options.characterData)\n        node.removeEventListener('DOMCharacterDataModified', this, true);\n\n      if (options.childList)\n        node.removeEventListener('DOMNodeInserted', this, true);\n\n      if (options.childList || options.subtree)\n        node.removeEventListener('DOMNodeRemoved', this, true);\n    },\n\n    /**\n     * Adds a transient observer on node. The transient observer gets removed\n     * next time we deliver the change records.\n     * @param {Node} node\n     */\n    addTransientObserver: function(node) {\n      // Don't add transient observers on the target itself. We already have all\n      // the required listeners set up on the target.\n      if (node === this.target)\n        return;\n\n      this.addListeners_(node);\n      this.transientObservedNodes.push(node);\n      var registrations = registrationsTable.get(node);\n      if (!registrations)\n        registrationsTable.set(node, registrations = []);\n\n      // We know that registrations does not contain this because we already\n      // checked if node === this.target.\n      registrations.push(this);\n    },\n\n    removeTransientObservers: function() {\n      var transientObservedNodes = this.transientObservedNodes;\n      this.transientObservedNodes = [];\n\n      transientObservedNodes.forEach(function(node) {\n        // Transient observers are never added to the target.\n        this.removeListeners_(node);\n\n        var registrations = registrationsTable.get(node);\n        for (var i = 0; i < registrations.length; i++) {\n          if (registrations[i] === this) {\n            registrations.splice(i, 1);\n            // Each node can only have one registered observer associated with\n            // this observer.\n            break;\n          }\n        }\n      }, this);\n    },\n\n    handleEvent: function(e) {\n      // Stop propagation since we are managing the propagation manually.\n      // This means that other mutation events on the page will not work\n      // correctly but that is by design.\n      e.stopImmediatePropagation();\n\n      switch (e.type) {\n        case 'DOMAttrModified':\n          // http://dom.spec.whatwg.org/#concept-mo-queue-attributes\n\n          var name = e.attrName;\n          var namespace = e.relatedNode.namespaceURI;\n          var target = e.target;\n\n          // 1.\n          var record = new getRecord('attributes', target);\n          record.attributeName = name;\n          record.attributeNamespace = namespace;\n\n          // 2.\n          var oldValue =\n              e.attrChange === MutationEvent.ADDITION ? null : e.prevValue;\n\n          forEachAncestorAndObserverEnqueueRecord(target, function(options) {\n            // 3.1, 4.2\n            if (!options.attributes)\n              return;\n\n            // 3.2, 4.3\n            if (options.attributeFilter && options.attributeFilter.length &&\n                options.attributeFilter.indexOf(name) === -1 &&\n                options.attributeFilter.indexOf(namespace) === -1) {\n              return;\n            }\n            // 3.3, 4.4\n            if (options.attributeOldValue)\n              return getRecordWithOldValue(oldValue);\n\n            // 3.4, 4.5\n            return record;\n          });\n\n          break;\n\n        case 'DOMCharacterDataModified':\n          // http://dom.spec.whatwg.org/#concept-mo-queue-characterdata\n          var target = e.target;\n\n          // 1.\n          var record = getRecord('characterData', target);\n\n          // 2.\n          var oldValue = e.prevValue;\n\n\n          forEachAncestorAndObserverEnqueueRecord(target, function(options) {\n            // 3.1, 4.2\n            if (!options.characterData)\n              return;\n\n            // 3.2, 4.3\n            if (options.characterDataOldValue)\n              return getRecordWithOldValue(oldValue);\n\n            // 3.3, 4.4\n            return record;\n          });\n\n          break;\n\n        case 'DOMNodeRemoved':\n          this.addTransientObserver(e.target);\n          // Fall through.\n        case 'DOMNodeInserted':\n          // http://dom.spec.whatwg.org/#concept-mo-queue-childlist\n          var changedNode = e.target;\n          var addedNodes, removedNodes;\n          if (e.type === 'DOMNodeInserted') {\n            addedNodes = [changedNode];\n            removedNodes = [];\n          } else {\n\n            addedNodes = [];\n            removedNodes = [changedNode];\n          }\n          var previousSibling = changedNode.previousSibling;\n          var nextSibling = changedNode.nextSibling;\n\n          // 1.\n          var record = getRecord('childList', e.target.parentNode);\n          record.addedNodes = addedNodes;\n          record.removedNodes = removedNodes;\n          record.previousSibling = previousSibling;\n          record.nextSibling = nextSibling;\n\n          forEachAncestorAndObserverEnqueueRecord(e.relatedNode, function(options) {\n            // 2.1, 3.2\n            if (!options.childList)\n              return;\n\n            // 2.2, 3.3\n            return record;\n          });\n\n      }\n\n      clearRecords();\n    }\n  };\n\n  global.JsMutationObserver = JsMutationObserver;\n\n  if (!global.MutationObserver)\n    global.MutationObserver = JsMutationObserver;\n\n\n})(this);","requirejs-min-resolver.js":"    var ctx = require.s.contexts._,\n        origNameToUrl = ctx.nameToUrl;\n\n    ctx.nameToUrl = function() {\n        var url = origNameToUrl.apply(ctx, arguments);\n        if (!url.match(/\\/tiny_mce\\//)&&!url.match(/\\/Temando_Shipping\\/static\\/js\\//)) {\n            url = url.replace(/(\\.min)?\\.js$/, '.min.js');\n        }\n        return url;\n    };\n","Magento_Persistent/js/view/remember-me.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'ko',\n    'uiComponent'\n], function (ko, Component) {\n    'use strict';\n\n    var persistenceConfig = window.checkoutConfig.persistenceConfig;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Persistent/remember-me'\n        },\n        dataScope: 'global',\n        isRememberMeCheckboxVisible: ko.observable(persistenceConfig.isRememberMeCheckboxVisible),\n        isRememberMeCheckboxChecked: ko.observable(persistenceConfig.isRememberMeCheckboxChecked)\n    });\n});\n","Magento_GoogleAnalytics/js/google-analytics_original.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* jscs:disable */\n/* eslint-disable */\ndefine([\n    'jquery',\n    'mage/cookies'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} config\n     */\n    return function (config) {\n        var allowServices = false,\n            allowedCookies,\n            allowedWebsites;\n\n        if (config.isCookieRestrictionModeEnabled) {\n            allowedCookies = $.mage.cookies.get(config.cookieName);\n\n            if (allowedCookies !== null) {\n                allowedWebsites = JSON.parse(allowedCookies);\n\n                if (allowedWebsites[config.currentWebsite] === 1) {\n                    allowServices = true;\n                }\n            }\n        } else {\n            allowServices = true;\n        }\n\n        if (allowServices) {\n            (function (i, s, o, g, r, a, m) {\n                i.GoogleAnalyticsObject = r;\n                i[r] = i[r] || function () {\n                        (i[r].q = i[r].q || []).push(arguments)\n                    }, i[r].l = 1 * new Date();\n                a = s.createElement(o),\n                    m = s.getElementsByTagName(o)[0];\n                a.async = 1;\n                a.src = g;\n                m.parentNode.insertBefore(a, m)\n            })(window, document, 'script', '//www.google-analytics.com/analytics.js', 'ga');\n\n            // Process page info\n            ga('create', config.pageTrackingData.accountId, 'auto');\n\n            if (config.pageTrackingData.isAnonymizedIpActive) {\n                ga('set', 'anonymizeIp', true);\n            }\n            ga('send', 'pageview' + config.pageTrackingData.optPageUrl);\n\n            // Process orders data\n            if (config.ordersTrackingData) {\n                ga('require', 'ec', 'ec.js');\n\n                //Set currency code\n                ga('set', 'currencyCode', config.ordersTrackingData.currency);\n\n                // Collect product data for GA\n                if (config.ordersTrackingData.products) {\n                    $.each(config.ordersTrackingData.products, function (index, value) {\n                        ga('ec:addProduct', value);\n                    });\n                }\n\n                // Collect orders data for GA\n                if (config.ordersTrackingData.orders) {\n                    $.each(config.ordersTrackingData.orders, function (index, value) {\n                        ga('ec:setAction', 'purchase', value);\n                    });\n                }\n\n                ga('send', 'pageview');\n            }\n        }\n    }\n});\n","Magento_GoogleAnalytics/js/google-analytics.js":"/**\r\n * Copyright \u00a9 Magento, Inc. All rights reserved.\r\n * See COPYING.txt for license details.\r\n */\r\n/* jscs:disable */\r\n/* eslint-disable */\r\ndefine([\r\n    'jquery',\r\n    'mage/cookies'\r\n], function ($) {\r\n    'use strict';\r\n\r\n    /**\r\n     * @param {Object} config\r\n     */\r\n    return function (config) {\r\n        var allowServices = false,\r\n            allowedCookies,\r\n            allowedWebsites;\r\n\r\n        if (config.isCookieRestrictionModeEnabled) {\r\n            allowedCookies = $.mage.cookies.get(config.cookieName);\r\n\r\n            if (allowedCookies !== null) {\r\n                allowedWebsites = JSON.parse(allowedCookies);\r\n\r\n                if (allowedWebsites[config.currentWebsite] === 1) {\r\n                    allowServices = true;\r\n                }\r\n            }\r\n        } else {\r\n            allowServices = true;\r\n        }\r\n\r\n        if (allowServices) {\r\n            (function (i, s, o, g, r, a, m) {\r\n                i.GoogleAnalyticsObject = r;\r\n                i[r] = i[r] || function () {\r\n                        (i[r].q = i[r].q || []).push(arguments)\r\n                    }, i[r].l = 1 * new Date();\r\n                a = s.createElement(o),\r\n                    m = s.getElementsByTagName(o)[0];\r\n                a.async = 1;\r\n                a.src = g;\r\n                m.parentNode.insertBefore(a, m)\r\n            })(window, document, 'script', '//www.google-analytics.com/analytics.js', 'ga');\r\n\r\n            // Process page info\r\n            ga('create', config.pageTrackingData.accountId, 'auto');\r\n\r\n            if (config.pageTrackingData.isAnonymizedIpActive) {\r\n                ga('set', 'anonymizeIp', true);\r\n            }\r\n\r\n            // Process orders data\r\n            if (config.ordersTrackingData.hasOwnProperty('currency')) {\r\n                ga('require', 'ec', 'ec.js');\r\n\r\n                //Set currency code\r\n                ga('set', 'currencyCode', config.ordersTrackingData.currency);\r\n\r\n                // Collect product data for GA\r\n                if (config.ordersTrackingData.products) {\r\n                    $.each(config.ordersTrackingData.products, function (index, value) {\r\n                        ga('ec:addProduct', value);\r\n                    });\r\n                }\r\n\r\n                // Collect orders data for GA\r\n                if (config.ordersTrackingData.orders) {\r\n                    $.each(config.ordersTrackingData.orders, function (index, value) {\r\n                        ga('ec:setAction', 'purchase', value);\r\n                    });\r\n                }\r\n\r\n                ga('send', 'pageview');\r\n            }else{\r\n                // Process Data if not orders\r\n                ga('send', 'pageview' + config.pageTrackingData.optPageUrl);\r\n            }\r\n        }\r\n    }\r\n});\r\n","Magento_InstantPurchase/js/view/instant-purchase.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data',\n    'mage/url',\n    'mage/template',\n    'mage/translate',\n    'text!Magento_InstantPurchase/template/confirmation.html',\n    'mage/validation'\n], function (ko, $, _, Component, confirm, customerData, urlBuilder, mageTemplate, $t, confirmationTemplate) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_InstantPurchase/instant-purchase',\n            buttonText: $t('Instant Purchase'),\n            purchaseUrl: urlBuilder.build('instantpurchase/button/placeOrder'),\n            showButton: false,\n            paymentToken: null,\n            shippingAddress: null,\n            billingAddress: null,\n            shippingMethod: null,\n            productFormSelector: '#product_addtocart_form',\n            confirmationTitle: $t('Instant Purchase Confirmation'),\n            confirmationData: {\n                message: $t('Are you sure you want to place order and pay?'),\n                shippingAddressTitle: $t('Shipping Address'),\n                billingAddressTitle: $t('Billing Address'),\n                paymentMethodTitle: $t('Payment Method'),\n                shippingMethodTitle: $t('Shipping Method')\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var instantPurchase = customerData.get('instant-purchase');\n\n            this._super();\n\n            this.setPurchaseData(instantPurchase());\n            instantPurchase.subscribe(this.setPurchaseData, this);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('showButton paymentToken shippingAddress billingAddress shippingMethod');\n\n            return this;\n        },\n\n        /**\n         * Set data from customerData.\n         *\n         * @param {Object} data\n         */\n        setPurchaseData: function (data) {\n            this.showButton(data.available);\n            this.paymentToken(data.paymentToken);\n            this.shippingAddress(data.shippingAddress);\n            this.billingAddress(data.billingAddress);\n            this.shippingMethod(data.shippingMethod);\n        },\n\n        /**\n         * Confirmation method\n         */\n        instantPurchase: function () {\n            var form = $(this.productFormSelector),\n                confirmTemplate = mageTemplate(confirmationTemplate),\n                confirmData = _.extend({}, this.confirmationData, {\n                    paymentToken: this.paymentToken().summary,\n                    shippingAddress: this.shippingAddress().summary,\n                    billingAddress: this.billingAddress().summary,\n                    shippingMethod: this.shippingMethod().summary\n                });\n\n            if (!(form.validation() && form.validation('isValid'))) {\n                return;\n            }\n\n            confirm({\n                title: this.confirmationTitle,\n                content: confirmTemplate({\n                    data: confirmData\n                }),\n                actions: {\n                    /** @inheritdoc */\n                    confirm: function () {\n                        $.ajax({\n                            url: this.purchaseUrl,\n                            data: form.serialize(),\n                            type: 'post',\n                            dataType: 'json',\n\n                            /** Show loader before send */\n                            beforeSend: function () {\n                                $('body').trigger('processStart');\n                            }\n                        }).always(function () {\n                            $('body').trigger('processStop');\n                        });\n                    }.bind(this)\n                }\n            });\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'ko',\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (ko, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        displaySubtotal: ko.observable(true),\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.cart = customerData.get('cart');\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/grand-total'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        isDisplayed: function () {\n            return true;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/tax',\n    'Magento_Checkout/js/model/totals'\n], function (Component, totals) {\n    'use strict';\n\n    var isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed,\n        isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed;\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        ifShowValue: function () {\n            if (this.getPureValue() === 0) {\n                return isZeroTaxDisplayed;\n            }\n\n            return true;\n        },\n\n        /**\n         * @override\n         */\n        ifShowDetails: function () {\n            return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n        },\n\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return this.totals() && totals.getSegment('tax') !== null;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return !!quote.shippingMethod();\n        },\n\n        /**\n         * @override\n         */\n        getShippingMethodTitle: function () {\n            return '(' + this._super() + ')';\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/shipping_method/price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils'\n], function (Component, quote, priceUtils) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Tax/checkout/shipping_method/price'\n        },\n        isDisplayShippingPriceExclTax: window.checkoutConfig.isDisplayShippingPriceExclTax,\n        isDisplayShippingBothPrices: window.checkoutConfig.isDisplayShippingBothPrices,\n\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         */\n        isPriceEqual: function (item) {\n            return item['price_excl_tax'] != item['price_incl_tax']; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            //todo add format data\n            return priceUtils.formatPrice(price, quote.getPriceFormat());\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals'\n], function (Component, quote, priceUtils, totals) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isFullTaxSummaryDisplayed: window.checkoutConfig.isFullTaxSummaryDisplayed || false,\n            template: 'Magento_Tax/checkout/summary/grand-total'\n        },\n        totals: quote.getTotals(),\n        isTaxDisplayedInGrandTotal: window.checkoutConfig.includeTaxInGrandTotal || false,\n\n        /**\n         * @return {*}\n         */\n        isDisplayed: function () {\n            return this.isFullMode();\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = totals.getSegment('grand_total').value;\n            }\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getBaseValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals()['base_grand_total'];\n            }\n\n            return priceUtils.formatPrice(price, quote.getBasePriceFormat());\n        },\n\n        /**\n         * @return {*}\n         */\n        getGrandTotalExclTax: function () {\n            var total = this.totals();\n\n            if (!total) {\n                return 0;\n            }\n\n            return this.getFormattedPrice(total['grand_total']);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBaseGrandTotalDisplayNeeded: function () {\n            var total = this.totals();\n\n            if (!total) {\n                return false;\n            }\n\n            return total['base_currency_code'] != total['quote_currency_code']; //eslint-disable-line eqeqeq\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    var displaySubtotalMode = window.checkoutConfig.reviewTotalsDisplayMode;\n\n    return Component.extend({\n        defaults: {\n            displaySubtotalMode: displaySubtotalMode,\n            template: 'Magento_Tax/checkout/summary/subtotal'\n        },\n        totals: quote.getTotals(),\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals().subtotal;\n            }\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBothPricesDisplayed: function () {\n            return this.displaySubtotalMode == 'both'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isIncludingTaxDisplayed: function () {\n            return this.displaySubtotalMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValueInclTax: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals()['subtotal_incl_tax'];\n            }\n\n            return this.getFormattedPrice(price);\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/totals'\n], function (ko, Component, quote, totals) {\n    'use strict';\n\n    var isTaxDisplayedInGrandTotal = window.checkoutConfig.includeTaxInGrandTotal,\n        isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed,\n        isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed;\n\n    return Component.extend({\n        defaults: {\n            isTaxDisplayedInGrandTotal: isTaxDisplayedInGrandTotal,\n            notCalculatedMessage: 'Not yet calculated',\n            template: 'Magento_Tax/checkout/summary/tax'\n        },\n        totals: quote.getTotals(),\n        isFullTaxSummaryDisplayed: isFullTaxSummaryDisplayed,\n\n        /**\n         * @return {Boolean}\n         */\n        ifShowValue: function () {\n            if (this.isFullMode() && this.getPureValue() == 0) { //eslint-disable-line eqeqeq\n                return isZeroTaxDisplayed;\n            }\n\n            return true;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        ifShowDetails: function () {\n            if (!this.isFullMode()) {\n                return false;\n            }\n\n            return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            var amount = 0,\n                taxTotal;\n\n            if (this.totals()) {\n                taxTotal = totals.getSegment('tax');\n\n                if (taxTotal) {\n                    amount = taxTotal.value;\n                }\n            }\n\n            return amount;\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && totals.getSegment('tax') != null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getValue: function () {\n            var amount;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            amount = totals.getSegment('tax').value;\n\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @param {*} amount\n         * @return {*|String}\n         */\n        formatPrice: function (amount) {\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @return {Array}\n         */\n        getDetails: function () {\n            var taxSegment = totals.getSegment('tax');\n\n            if (taxSegment && taxSegment['extension_attributes']) {\n                return taxSegment['extension_attributes']['tax_grandtotal_details'];\n            }\n\n            return [];\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function ($, Component, quote) {\n    'use strict';\n\n    var displayMode = window.checkoutConfig.reviewShippingDisplayMode;\n\n    return Component.extend({\n        defaults: {\n            displayMode: displayMode,\n            template: 'Magento_Tax/checkout/summary/shipping'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBothPricesDisplayed: function () {\n            return this.displayMode == 'both'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isIncludingDisplayed: function () {\n            return this.displayMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isExcludingDisplayed: function () {\n            return this.displayMode == 'excluding'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && quote.shippingMethod() != null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getIncludingValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price = this.totals()['shipping_incl_tax'];\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {*}\n         */\n        getExcludingValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price = this.totals()['shipping_amount'];\n\n            return this.getFormattedPrice(price);\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/item/details/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/item/details/subtotal'\n], function (subtotal) {\n    'use strict';\n\n    var displayPriceMode = window.checkoutConfig.reviewItemPriceDisplayMode || 'including';\n\n    return subtotal.extend({\n        defaults: {\n            displayPriceMode: displayPriceMode,\n            template: 'Magento_Tax/checkout/summary/item/details/subtotal'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isPriceInclTaxDisplayed: function () {\n            return displayPriceMode == 'both' || displayPriceMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isPriceExclTaxDisplayed: function () {\n            return displayPriceMode == 'both' || displayPriceMode == 'excluding'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValueInclTax: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total_incl_tax']);\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValueExclTax: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total']);\n        }\n\n    });\n});\n","Magento_Tax/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Tax/price/adjustment',\n            taxPriceType: 'final_price',\n            taxPriceCssClass: 'price-including-tax',\n            bothPrices: 3,\n            inclTax: 2,\n            exclTax: 1,\n            modules: {\n                price: '${ $.parentName }'\n            },\n            listens: {\n                price: 'initializePriceAttributes'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super()\n                .initializePriceAttributes();\n\n            return this;\n        },\n\n        /**\n         * Update parent price.\n         *\n         * @returns {Object} Chainable.\n         */\n        initializePriceAttributes: function () {\n            if (this.displayBothPrices && this.price()) {\n                this.price().priceWrapperCssClasses = this.taxPriceCssClass;\n                this.price().priceWrapperAttr = {\n                    'data-label': $t('Incl. Tax')\n                };\n            }\n\n            return this;\n        },\n\n        /**\n         * Get price tax adjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTax: function (row) {\n            return row['price_info']['extension_attributes']['tax_adjustments']['formatted_prices'][this.taxPriceType];\n        },\n\n        /**\n         * Set price taax type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPrices: function () {\n            return +this.source.data.displayTaxes === this.bothPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceIncludeTax: function () {\n            return +this.source.data.displayTaxes === this.inclTax;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.exclTax;\n        }\n    });\n});\n","fotorama/fotorama.min.js":"/*!\n * Fotorama 4.6.4 | http://fotorama.io/license/\n */\nfotoramaVersion=\"4.6.4\",function(a,b,c,d,e){\"use strict\";function Ba(a){var b=\"bez_\"+d.makeArray(arguments).join(\"_\").replace(\".\",\"p\");if(\"function\"!=typeof d.easing[b]){var c=function(a,b){var c=[null,null],d=[null,null],e=[null,null],f=function(f,g){return e[g]=3*a[g],d[g]=3*(b[g]-a[g])-e[g],c[g]=1-e[g]-d[g],f*(e[g]+f*(d[g]+f*c[g]))},g=function(a){return e[0]+a*(2*d[0]+3*c[0]*a)},h=function(a){for(var d,b=a,c=0;++c<14&&(d=f(b,0)-a,!(Math.abs(d)<.001));)b-=d/g(b);return b};return function(a){return f(h(a),1)}};d.easing[b]=function(b,d,e,f,g){return f*c([a[0],a[1]],[a[2],a[3]])(d/g)+e}}return b}function eb(){}function fb(a,b,c){return Math.max(isNaN(b)?-(1/0):b,Math.min(isNaN(c)?1/0:c,a))}function gb(a,b){return a.match(/ma/)&&a.match(/-?\\d+(?!d)/g)[a.match(/3d/)?\"vertical\"===b?13:12:\"vertical\"===b?5:4]}function hb(a,b){return Ia?+gb(a.css(\"transform\"),b):+a.css(\"vertical\"===b?\"top\":\"left\").replace(\"px\",\"\")}function ib(a,b){var c={};if(Ia)switch(b){case\"vertical\":c.transform=\"translate3d(0, \"+a+\"px,0)\";break;case\"list\":break;default:c.transform=\"translate3d(\"+a+\"px,0,0)\"}else\"vertical\"===b?c.top=a:c.left=a;return c}function jb(a){return{\"transition-duration\":a+\"ms\"}}function kb(a,b){return isNaN(a)?b:a}function lb(a,b){return kb(+String(a).replace(b||\"px\",\"\"))}function mb(a){return/%$/.test(a)?lb(a,\"%\"):e}function nb(a,b){return kb(mb(a)/100*b,lb(a))}function ob(a){return(!isNaN(lb(a))||!isNaN(lb(a,\"%\")))&&a}function pb(a,b,c,d){return(a-(d||0))*(b+(c||0))}function qb(a,b,c,d){return-Math.round(a/(b+(c||0))-(d||0))}function rb(a){var b=a.data();if(!b.tEnd){var c=a[0],d={WebkitTransition:\"webkitTransitionEnd\",MozTransition:\"transitionend\",OTransition:\"oTransitionEnd otransitionend\",msTransition:\"MSTransitionEnd\",transition:\"transitionend\"};Rb(c,d[wa.prefixed(\"transition\")],function(a){b.tProp&&a.propertyName.match(b.tProp)&&b.onEndFn()}),b.tEnd=!0}}function sb(a,b,c,d){var e,f=a.data();f&&(f.onEndFn=function(){e||(e=!0,clearTimeout(f.tT),c())},f.tProp=b,clearTimeout(f.tT),f.tT=setTimeout(function(){f.onEndFn()},1.5*d),rb(a))}function tb(a,b){var c=a.navdir||\"horizontal\";if(a.length){var d=a.data();Ia?(a.css(jb(0)),d.onEndFn=eb,clearTimeout(d.tT)):a.stop();var e=ub(b,function(){return hb(a,c)});return a.css(ib(e,c)),e}}function ub(){for(var a,b=0,c=arguments.length;b<c&&(a=b?arguments[b]():arguments[b],\"number\"!=typeof a);b++);return a}function vb(a,b){return Math.round(a+(b-a)/1.5)}function wb(){return wb.p=wb.p||(\"https:\"===c.protocol?\"https://\":\"http://\"),wb.p}function xb(a){var c=b.createElement(\"a\");return c.href=a,c}function yb(a,b){if(\"string\"!=typeof a)return a;a=xb(a);var c,d;if(a.host.match(/youtube\\.com/)&&a.search){if(c=a.search.split(\"v=\")[1]){var e=c.indexOf(\"&\");e!==-1&&(c=c.substring(0,e)),d=\"youtube\"}}else a.host.match(/youtube\\.com|youtu\\.be/)?(c=a.pathname.replace(/^\\/(embed\\/|v\\/)?/,\"\").replace(/\\/.*/,\"\"),d=\"youtube\"):a.host.match(/vimeo\\.com/)&&(d=\"vimeo\",c=a.pathname.replace(/^\\/(video\\/)?/,\"\").replace(/\\/.*/,\"\"));return c&&d||!b||(c=a.href,d=\"custom\"),!!c&&{id:c,type:d,s:a.search.replace(/^\\?/,\"\"),p:wb()}}function zb(a,b,c){var e,f,g=a.video;return\"youtube\"===g.type?(f=wb()+\"img.youtube.com/vi/\"+g.id+\"/default.jpg\",e=f.replace(/\\/default.jpg$/,\"/hqdefault.jpg\"),a.thumbsReady=!0):\"vimeo\"===g.type?d.ajax({url:wb()+\"vimeo.com/api/v2/video/\"+g.id+\".json\",dataType:\"jsonp\",success:function(d){a.thumbsReady=!0,Ab(b,{img:d[0].thumbnail_large,thumb:d[0].thumbnail_small},a.i,c)}}):a.thumbsReady=!0,{img:e,thumb:f}}function Ab(a,b,c,e){for(var f=0,g=a.length;f<g;f++){var h=a[f];if(h.i===c&&h.thumbsReady){var i={videoReady:!0};i[Xa]=i[Za]=i[Ya]=!1,e.splice(f,1,d.extend({},h,i,b));break}}}function Bb(a){function c(a,b,c){var f=a.children(\"img\").eq(0),g=a.attr(\"href\"),h=a.attr(\"src\"),i=f.attr(\"src\"),j=b.video,k=!!c&&yb(g,j===!0);k?g=!1:k=j,e(a,f,d.extend(b,{video:k,img:b.img||g||h||i,thumb:b.thumb||i||h||g}))}function e(a,b,c){var e=c.thumb&&c.img!==c.thumb,f=lb(c.width||a.attr(\"width\")),g=lb(c.height||a.attr(\"height\"));d.extend(c,{width:f,height:g,thumbratio:Qb(c.thumbratio||lb(c.thumbwidth||b&&b.attr(\"width\")||e||f)/lb(c.thumbheight||b&&b.attr(\"height\")||e||g))})}var b=[];return a.children().each(function(){var a=d(this),f=Pb(d.extend(a.data(),{id:a.attr(\"id\")}));if(a.is(\"a, img\"))c(a,f,!0);else{if(a.is(\":empty\"))return;e(a,null,d.extend(f,{html:this,_html:a.html()}))}b.push(f)}),b}function Cb(a){return 0===a.offsetWidth&&0===a.offsetHeight}function Db(a){return!d.contains(b.documentElement,a)}function Eb(a,b,c,d){return Eb.i||(Eb.i=1,Eb.ii=[!0]),d=d||Eb.i,\"undefined\"==typeof Eb.ii[d]&&(Eb.ii[d]=!0),a()?b():Eb.ii[d]&&setTimeout(function(){Eb.ii[d]&&Eb(a,b,c,d)},c||100),Eb.i++}function Fb(a,b){var c=a.data(),d=c.measures;if(d&&(!c.l||c.l.W!==d.width||c.l.H!==d.height||c.l.r!==d.ratio||c.l.w!==b.w||c.l.h!==b.h)){var e=fb(b.h,0,d.height),f=e*d.ratio;$b.setRatio(a,f,e),c.l={W:d.width,H:d.height,r:d.ratio,w:b.w,h:b.h}}return!0}function Gb(a,b){var c=a[0];c.styleSheet?c.styleSheet.cssText=b:a.html(b)}function Hb(a,b,c,d){return b!==c&&(\"vertical\"===d?a<=b?\"top\":a>=c?\"bottom\":\"top bottom\":a<=b?\"left\":a>=c?\"right\":\"left right\")}function Ib(a,b,c){c=c||{},a.each(function(){var f,a=d(this),e=a.data();e.clickOn||(e.clickOn=!0,d.extend(hc(a,{onStart:function(a){f=a,(c.onStart||eb).call(this,a)},onMove:c.onMove||eb,onTouchEnd:c.onTouchEnd||eb,onEnd:function(a){a.moved||b.call(this,f)}}),{noMove:!0}))})}function Jb(a,b){return'<div class=\"'+a+'\">'+(b||\"\")+\"</div>\"}function Kb(a){return\".\"+a}function Lb(a){var b='<iframe src=\"'+a.p+a.type+\".com/embed/\"+a.id+'\" frameborder=\"0\" allowfullscreen></iframe>';return b}function Mb(a){for(var b=a.length;b;){var c=Math.floor(Math.random()*b--),d=a[b];a[b]=a[c],a[c]=d}return a}function Nb(a){return\"[object Array]\"==Object.prototype.toString.call(a)&&d.map(a,function(a){return d.extend({},a)})}function Ob(a,b,c){a.scrollLeft(b||0).scrollTop(c||0)}function Pb(a){if(a){var b={};return d.each(a,function(a,c){b[a.toLowerCase()]=c}),b}}function Qb(a){if(a){var b=+a;return isNaN(b)?(b=a.split(\"/\"),+b[0]/+b[1]||e):b}}function Rb(a,b,c,d){b&&(a.addEventListener?a.addEventListener(b,c,!!d):a.attachEvent(\"on\"+b,c))}function Sb(a,b){return a>b.max?a=b.max:a<b.min&&(a=b.min),a}function Tb(a,b,c,d,e,f,g){var h,i,j;return\"horizontal\"===g?(i=a.thumbwidth,j=f.width()):(i=a.thumbheight,j=f.height()),h=(i+a.margin)*(c+1)>=j-d?\"horizontal\"===g?-e.position().left:-e.position().top:(i+a.margin)*c<=Math.abs(d)?\"horizontal\"===g?-e.position().left+j-(i+a.margin):-e.position().top+j-(i+a.margin):d,h=Sb(h,b),h||0}function Ub(a){return!!a.getAttribute(\"disabled\")}function Vb(a,b){return b?{disabled:a}:{tabindex:a*-1+\"\",disabled:a}}function Wb(a,b){Rb(a,\"keyup\",function(c){Ub(a)||13==c.keyCode&&b.call(a,c)})}function Xb(a,b){Rb(a,\"focus\",a.onfocusin=function(c){b.call(a,c)},!0)}function Yb(a,b){a.preventDefault?a.preventDefault():a.returnValue=!1,b&&a.stopPropagation&&a.stopPropagation()}function Zb(a){return a?\">\":\"<\"}function _b(a,b){var c=a.data(),e=Math.round(b.pos),f=function(){c&&c.sliding&&(c.sliding=!1),(b.onEnd||eb)()};\"undefined\"!=typeof b.overPos&&b.overPos!==b.pos&&(e=b.overPos);var g=d.extend(ib(e,b.direction),b.width&&{width:b.width},b.height&&{height:b.height});c&&c.sliding&&(c.sliding=!0),Ia?(a.css(d.extend(jb(b.time),g)),b.time>10?sb(a,\"transform\",f,b.time):f()):a.stop().animate(g,b.time,_a,f)}function ac(a,b,c,e,f,g){var h=\"undefined\"!=typeof g;if(h||(f.push(arguments),Array.prototype.push.call(arguments,f.length),!(f.length>1))){a=a||d(a),b=b||d(b);var i=a[0],j=b[0],k=\"crossfade\"===e.method,l=function(){if(!l.done){l.done=!0;var a=(h||f.shift())&&f.shift();a&&ac.apply(this,a),(e.onEnd||eb)(!!a)}},m=e.time/(g||1);c.removeClass(P+\" \"+O),a.stop().addClass(P),b.stop().addClass(O),k&&j&&a.fadeTo(0,0),a.fadeTo(k?m:0,1,k&&l),b.fadeTo(m,0,l),i&&k||j||l()}}function gc(a){var b=(a.touches||[])[0]||a;a._x=b.pageX||b.originalEvent.pageX,a._y=b.clientY||b.originalEvent.clientY,a._now=d.now()}function hc(a,c){function p(a){return i=d(a.target),f.checked=l=m=o=!1,g||f.flow||a.touches&&a.touches.length>1||a.which>1||bc&&bc.type!==a.type&&dc||(l=c.select&&i.is(c.select,e))?l:(k=\"touchstart\"===a.type,m=i.is(\"a, a *\",e),j=f.control,n=f.noMove||f.noSwipe||j?16:f.snap?0:4,gc(a),h=bc=a,cc=a.type.replace(/down|start/,\"move\").replace(/Down/,\"Move\"),(c.onStart||eb).call(e,a,{control:j,$target:i}),g=f.flow=!0,void(k&&!f.go||Yb(a)))}function q(a){if(a.touches&&a.touches.length>1||Na&&!a.isPrimary||cc!==a.type||!g)return g&&r(),void(c.onTouchEnd||eb)();gc(a);var b=Math.abs(a._x-h._x),d=Math.abs(a._y-h._y),i=b-d,j=(f.go||f.x||i>=0)&&!f.noSwipe,l=i<0;k&&!f.checked?(g=j)&&Yb(a):(Yb(a),(c.onMove||eb).call(e,a,{touch:k})),!o&&Math.sqrt(Math.pow(b,2)+Math.pow(d,2))>n&&(o=!0),f.checked=f.checked||j||l}function r(a){(c.onTouchEnd||eb)();var b=g;f.control=g=!1,b&&(f.flow=!1),!b||m&&!f.checked||(a&&Yb(a),dc=!0,clearTimeout(ec),ec=setTimeout(function(){dc=!1},1e3),(c.onEnd||eb).call(e,{moved:o,$target:i,control:j,touch:k,startEvent:h,aborted:!a||\"MSPointerCancel\"===a.type}))}function s(){f.flow||(f.flow=!0)}function t(){f.flow&&(f.flow=!1)}var g,h,i,j,k,l,m,n,o,e=a[0],f={};return Na?(Rb(e,\"MSPointerDown\",p),Rb(b,\"MSPointerMove\",q),Rb(b,\"MSPointerCancel\",r),Rb(b,\"MSPointerUp\",r)):(Rb(e,\"touchstart\",p),Rb(e,\"touchmove\",q),Rb(e,\"touchend\",r),Rb(b,\"touchstart\",s),Rb(b,\"touchend\",t),Rb(b,\"touchcancel\",t),Ca.on(\"scroll\",t),a.on(\"mousedown pointerdown\",p),Da.on(\"mousemove pointermove\",q).on(\"mouseup pointerup\",r)),fc=wa.touch?\"a\":\"div\",a.on(\"click\",fc,function(a){f.checked&&Yb(a)}),f}function ic(a,b){function w(d,e){v=!0,g=h=\"vertical\"===r?d._y:d._x,m=d._now,l=[[m,g]],i=j=f.noMove||e?0:tb(a,(b.getPos||eb)()),(b.onStart||eb).call(c,d)}function x(b,c){o=f.min,p=f.max,q=f.snap,r=f.direction||\"horizontal\",a.navdir=r,s=b.altKey,v=u=!1,t=c.control,t||e.sliding||w(b)}function y(d,e){f.noSwipe||(v||w(d),h=\"vertical\"===r?d._y:d._x,l.push([d._now,h]),j=i-(g-h),k=Hb(j,o,p,r),j<=o?j=vb(j,o):j>=p&&(j=vb(j,p)),f.noMove||(a.css(ib(j,r)),u||(u=!0,e.touch||Na||a.addClass(ea)),(b.onMove||eb).call(c,d,{pos:j,edge:k})))}function z(e){if(!f.noSwipe||!e.moved){v||w(e.startEvent,!0),e.touch||Na||a.removeClass(ea),n=d.now();for(var k,m,t,x,y,z,A,B,D,g=n-Pa,u=null,C=Qa,E=b.friction,F=l.length-1;F>=0;F--){if(k=l[F][0],m=Math.abs(k-g),null===u||m<t)u=k,x=l[F][1];else if(u===g||m>t)break;t=m}A=fb(j,o,p);var G=x-h,H=G>=0,I=n-u,J=I>Pa,K=!J&&j!==i&&A===j;q&&(A=fb(Math[K?H?\"floor\":\"ceil\":\"round\"](j/q)*q,o,p),o=p=A),K&&(q||A===j)&&(D=-(G/I),C*=fb(Math.abs(D),b.timeLow,b.timeHigh),y=Math.round(j+D*C/E),q||(A=y),(!H&&y>p||H&&y<o)&&(z=H?o:p,B=y-z,q||(A=z),B=fb(A+.03*B,z-50,z+50),C=Math.abs((j-B)/(D/E)))),C*=s?10:1,(b.onEnd||eb).call(c,d.extend(e,{moved:e.moved||J&&q,pos:j,newPos:A,overPos:B,time:C,dir:r}))}}var g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,c=a[0],e=a.data(),f={};return f=d.extend(hc(b.$wrap,d.extend({},b,{onStart:x,onMove:y,onEnd:z})),f)}function jc(a,b){var e,f,g,c=a[0],h={prevent:{}};return Rb(c,Oa,function(a){var c=a.wheelDeltaY||-1*a.deltaY||0,i=a.wheelDeltaX||-1*a.deltaX||0,j=Math.abs(i)&&!Math.abs(c),k=Zb(i<0),l=f===k,m=d.now(),n=m-g<Pa;f=k,g=m,j&&h.ok&&(!h.prevent[k]||e)&&(Yb(a,!0),e&&l&&n||(b.shift&&(e=!0,clearTimeout(h.t),h.t=setTimeout(function(){e=!1},Ra)),(b.onEnd||eb)(a,b.shift?k:i)))}),h}function kc(){d.each(d.Fotorama.instances,function(a,b){b.index=a})}function lc(a){d.Fotorama.instances.push(a),kc()}function mc(a){d.Fotorama.instances.splice(a.index,1),kc()}var f=\"fotorama\",g=\"fotorama__fullscreen\",h=f+\"__wrap\",i=h+\"--css2\",j=h+\"--css3\",k=h+\"--video\",l=h+\"--fade\",m=h+\"--slide\",n=h+\"--no-controls\",o=h+\"--no-shadows\",p=h+\"--pan-y\",q=h+\"--rtl\",s=h+\"--no-captions\",t=h+\"--toggle-arrows\",u=f+\"__stage\",v=u+\"__frame\",w=v+\"--video\",x=u+\"__shaft\",y=f+\"__grab\",z=f+\"__pointer\",A=f+\"__arr\",B=A+\"--disabled\",C=A+\"--prev\",D=A+\"--next\",E=f+\"__nav\",F=E+\"-wrap\",G=E+\"__shaft\",H=F+\"--vertical\",I=F+\"--list\",J=F+\"--horizontal\",K=E+\"--dots\",L=E+\"--thumbs\",M=E+\"__frame\",N=f+\"__fade\",O=N+\"-front\",P=N+\"-rear\",Q=f+\"__shadow\",R=Q+\"s\",S=R+\"--left\",T=R+\"--right\",U=R+\"--top\",V=R+\"--bottom\",W=f+\"__active\",X=f+\"__select\",Y=f+\"--hidden\",Z=f+\"--fullscreen\",$=f+\"__fullscreen-icon\",_=f+\"__error\",aa=f+\"__loading\",ba=f+\"__loaded\",ca=ba+\"--full\",da=ba+\"--img\",ea=f+\"__grabbing\",fa=f+\"__img\",ga=fa+\"--full\",ha=f+\"__thumb\",ia=ha+\"__arr--left\",ja=ha+\"__arr--right\",ka=ha+\"-border\",la=f+\"__html\",ma=f+\"-video-container\",na=f+\"__video\",oa=na+\"-play\",pa=na+\"-close\",qa=f+\"_horizontal_ratio\",ra=f+\"_vertical_ratio\",sa=f+\"__spinner\",ta=sa+\"--show\",ua=d&&d.fn.jquery.split(\".\");if(!ua||ua[0]<1||1==ua[0]&&ua[1]<8)throw\"Fotorama requires jQuery 1.8 or later and will not run without it.\";var va={},wa=function(a,b,c){function y(a){i.cssText=a}function A(a,b){return typeof a===b}function B(a,b){return!!~(\"\"+a).indexOf(b)}function C(a,b){for(var d in a){var e=a[d];if(!B(e,\"-\")&&i[e]!==c)return\"pfx\"!=b||e}return!1}function D(a,b,d){for(var e in a){var f=b[a[e]];if(f!==c)return d===!1?a[e]:A(f,\"function\")?f.bind(d||b):f}return!1}function E(a,b,c){var d=a.charAt(0).toUpperCase()+a.slice(1),e=(a+\" \"+n.join(d+\" \")+d).split(\" \");return A(b,\"string\")||A(b,\"undefined\")?C(e,b):(e=(a+\" \"+o.join(d+\" \")+d).split(\" \"),D(e,b,c))}var j,u,x,d=\"2.8.3\",e={},f=b.documentElement,g=\"modernizr\",h=b.createElement(g),i=h.style,l=({}.toString,\" -webkit- -moz- -o- -ms- \".split(\" \")),m=\"Webkit Moz O ms\",n=m.split(\" \"),o=m.toLowerCase().split(\" \"),p={},s=[],t=s.slice,v=function(a,c,d,e){var h,i,j,k,l=b.createElement(\"div\"),m=b.body,n=m||b.createElement(\"body\");if(parseInt(d,10))for(;d--;)j=b.createElement(\"div\"),j.id=e?e[d]:g+(d+1),l.appendChild(j);return h=[\"&#173;\",'<style id=\"s',g,'\">',a,\"</style>\"].join(\"\"),l.id=g,(m?l:n).innerHTML+=h,n.appendChild(l),m||(n.style.background=\"\",n.style.overflow=\"hidden\",k=f.style.overflow,f.style.overflow=\"hidden\",f.appendChild(n)),i=c(l,a),m?l.parentNode.removeChild(l):(n.parentNode.removeChild(n),f.style.overflow=k),!!i},w={}.hasOwnProperty;x=A(w,\"undefined\")||A(w.call,\"undefined\")?function(a,b){return b in a&&A(a.constructor.prototype[b],\"undefined\")}:function(a,b){return w.call(a,b)},Function.prototype.bind||(Function.prototype.bind=function(b){var c=this;if(\"function\"!=typeof c)throw new TypeError;var d=t.call(arguments,1),e=function(){if(this instanceof e){var a=function(){};a.prototype=c.prototype;var f=new a,g=c.apply(f,d.concat(t.call(arguments)));return Object(g)===g?g:f}return c.apply(b,d.concat(t.call(arguments)))};return e}),p.touch=function(){var c;return\"ontouchstart\"in a||a.DocumentTouch&&b instanceof DocumentTouch?c=!0:v([\"@media (\",l.join(\"touch-enabled),(\"),g,\")\",\"{#modernizr{top:9px;position:absolute}}\"].join(\"\"),function(a){c=9===a.offsetTop}),c},p.csstransforms3d=function(){var a=!!E(\"perspective\");return a&&\"webkitPerspective\"in f.style&&v(\"@media (transform-3d),(-webkit-transform-3d){#modernizr{left:9px;position:absolute;height:3px;}}\",function(b,c){a=9===b.offsetLeft&&3===b.offsetHeight}),a},p.csstransitions=function(){return E(\"transition\")};for(var F in p)x(p,F)&&(u=F.toLowerCase(),e[u]=p[F](),s.push((e[u]?\"\":\"no-\")+u));return e.addTest=function(a,b){if(\"object\"==typeof a)for(var d in a)x(a,d)&&e.addTest(d,a[d]);else{if(a=a.toLowerCase(),e[a]!==c)return e;b=\"function\"==typeof b?b():b,\"undefined\"!=typeof enableClasses&&enableClasses&&(f.className+=\" \"+(b?\"\":\"no-\")+a),e[a]=b}return e},y(\"\"),h=j=null,e._version=d,e._prefixes=l,e._domPrefixes=o,e._cssomPrefixes=n,e.testProp=function(a){return C([a])},e.testAllProps=E,e.testStyles=v,e.prefixed=function(a,b,c){return b?E(a,b,c):E(a,\"pfx\")},e}(a,b),xa={ok:!1,is:function(){return!1},request:function(){},cancel:function(){},event:\"\",prefix:\"\"},ya=\"webkit moz o ms khtml\".split(\" \");if(\"undefined\"!=typeof b.cancelFullScreen)xa.ok=!0;else for(var za=0,Aa=ya.length;za<Aa;za++)if(xa.prefix=ya[za],\"undefined\"!=typeof b[xa.prefix+\"CancelFullScreen\"]){xa.ok=!0;break}xa.ok&&(xa.event=xa.prefix+\"fullscreenchange\",xa.is=function(){switch(this.prefix){case\"\":return b.fullScreen;case\"webkit\":return b.webkitIsFullScreen;default:return b[this.prefix+\"FullScreen\"]}},xa.request=function(a){return\"\"===this.prefix?a.requestFullScreen():a[this.prefix+\"RequestFullScreen\"]()},xa.cancel=function(a){return\"\"===this.prefix?b.cancelFullScreen():b[this.prefix+\"CancelFullScreen\"]()});var Ea,Fa,Ca=d(a),Da=d(b),Ga=\"quirks\"===c.hash.replace(\"#\",\"\"),Ha=wa.csstransforms3d,Ia=Ha&&!Ga,Ja=Ha||\"CSS1Compat\"===b.compatMode,Ka=xa.ok,La=navigator.userAgent.match(/Android|webOS|iPhone|iPad|iPod|BlackBerry|Windows Phone/i),Ma=!Ia||La,Na=navigator.msPointerEnabled,Oa=\"onwheel\"in b.createElement(\"div\")?\"wheel\":b.onmousewheel!==e?\"mousewheel\":\"DOMMouseScroll\",Pa=250,Qa=300,Ra=1400,Sa=5e3,Ta=2,Ua=64,Va=500,Wa=333,Xa=\"$stageFrame\",Ya=\"$navDotFrame\",Za=\"$navThumbFrame\",$a=\"auto\",_a=Ba([.1,0,.25,1]),ab=1200,bb=1,cb={width:null,minwidth:null,maxwidth:\"100%\",height:null,minheight:null,maxheight:null,ratio:null,margin:Ta,nav:\"dots\",navposition:\"bottom\",navwidth:null,thumbwidth:Ua,thumbheight:Ua,thumbmargin:Ta,thumbborderwidth:Ta,allowfullscreen:!1,transition:\"slide\",clicktransition:null,transitionduration:Qa,captions:!0,startindex:0,loop:!1,autoplay:!1,stopautoplayontouch:!0,keyboard:!1,arrows:!0,click:!0,swipe:!1,trackpad:!1,shuffle:!1,direction:\"ltr\",shadows:!0,showcaption:!0,navdir:\"horizontal\",navarrows:!0,navtype:\"thumbs\"},db={left:!0,right:!0,down:!0,up:!0,space:!1,home:!1,end:!1};Eb.stop=function(a){Eb.ii[a]=!1};var bc,cc,dc,ec,fc,$b=function(){function a(a,b,c){var d=b/c;d<=1?(a.parent().removeClass(qa),a.parent().addClass(ra)):(a.parent().removeClass(ra),a.parent().addClass(qa))}function b(a,b,c){var f=c;a.attr(f)||a.attr(f)===e||a.attr(f,b),a.find(\"[\"+f+\"]\").length&&a.find(\"[\"+f+\"]\").each(function(){d(this).attr(f,b)})}function c(a,b,c){var e,d=!1;return e=a.showCaption===c||a.showCaption===!0,!!b&&(a.caption&&e&&(d=!0),d)}return{setRatio:a,setThumbAttr:b,isExpectedCaption:c}}($b||{},jQuery);jQuery.Fotorama=function(c,r){function Yc(){d.each(ea,function(a,b){if(!b.i){b.i=ha++;var c=yb(b.video,!0);if(c){var d={};b.video=c,b.img||b.thumb?b.thumbsReady=!0:d=zb(b,ea,N),Ab(ea,{img:d.img,thumb:d.thumb},b.i,N)}}})}function Zc(a){return Dc[a]}function $c(){if(ya!==e)if(\"vertical\"==r.navdir){var a=r.thumbwidth+r.thumbmargin;ya.css(\"left\",a),Ha.css(\"right\",a),vb.css(\"right\",a),wa.css(\"width\",wa.css(\"width\")+a),Aa.css(\"max-width\",wa.width()-a)}else ya.css(\"left\",\"\"),Ha.css(\"right\",\"\"),vb.css(\"right\",\"\"),wa.css(\"width\",wa.css(\"width\")+a),Aa.css(\"max-width\",\"\")}function _c(a){var j,b=\"keydown.\"+f,c=f+O,e=\"keydown.\"+c,h=\"keyup.\"+c,i=\"resize.\"+c+\" orientationchange.\"+c;a?(Da.on(e,function(a){var b,c;bc&&27===a.keyCode?(b=!0,Vd(bc,!0,!0)):(N.fullScreen||r.keyboard&&!N.index)&&(27===a.keyCode?(b=!0,N.cancelFullScreen()):a.shiftKey&&32===a.keyCode&&Zc(\"space\")||37===a.keyCode&&Zc(\"left\")||38===a.keyCode&&Zc(\"up\")&&d(\":focus\").attr(\"data-gallery-role\")?(N.longPress.progress(),c=\"<\"):32===a.keyCode&&Zc(\"space\")||39===a.keyCode&&Zc(\"right\")||40===a.keyCode&&Zc(\"down\")&&d(\":focus\").attr(\"data-gallery-role\")?(N.longPress.progress(),c=\">\"):36===a.keyCode&&Zc(\"home\")?(N.longPress.progress(),c=\"<<\"):35===a.keyCode&&Zc(\"end\")&&(N.longPress.progress(),c=\">>\")),(b||c)&&Yb(a),j={index:c,slow:a.altKey,user:!0},c&&(N.longPress.inProgress?N.showWhileLongPress(j):N.show(j))}),a&&Da.on(h,function(a){N.longPress.inProgress&&N.showEndLongPress({user:!0}),N.longPress.reset()}),N.index||Da.off(b).on(b,\"textarea, input, select\",function(a){!Fa.hasClass(g)&&a.stopPropagation()}),Ca.on(i,N.resize)):(Da.off(e),Ca.off(i))}function ad(a){a!==ad.f&&(a?(c.addClass(f+\" \"+P).before(va).before(ua),lc(N)):(va.detach(),ua.detach(),c.html(qa.urtext).removeClass(P),mc(N)),_c(a),ad.f=a)}function bd(){ea=N.data=ea||Nb(r.data)||Bb(c),ra=N.size=ea.length,ee.ok&&r.shuffle&&Mb(ea),Yc(),cc=id(cc),ra&&ad(!0)}function cd(){var a=ra<2||bc;Hc.noMove=a||wc,Hc.noSwipe=a||!r.swipe,!Ac&&Aa.toggleClass(y,!r.click&&!Hc.noMove&&!Hc.noSwipe),Na&&wa.toggleClass(p,!Hc.noSwipe)}function dd(a){a===!0&&(a=\"\"),r.autoplay=Math.max(+a||Sa,1.5*zc)}function ed(a){a.navarrows&&\"thumbs\"===a.nav?(rb.show(),sb.show()):(rb.hide(),sb.hide())}function fd(a,b){return Math.floor(wa.width()/(b.thumbwidth+b.thumbmargin))}function gd(){function b(b,c){a[b?\"add\":\"remove\"].push(c)}r.nav&&\"dots\"!==r.nav||(r.navdir=\"horizontal\"),N.options=r=Pb(r),bb=fd(wa,r),wc=\"crossfade\"===r.transition||\"dissolve\"===r.transition,qc=r.loop&&(ra>2||wc&&(!Ac||\"slide\"!==Ac)),zc=+r.transitionduration||Qa,Cc=\"rtl\"===r.direction,Dc=d.extend({},r.keyboard&&db,r.keyboard),ed(r);var a={add:[],remove:[]};ra>1?(rc=r.nav,tc=\"top\"===r.navposition,a.remove.push(X),La.toggle(r.arrows)):(rc=!1,La.hide()),Ad(),Cd(),Bd(),r.autoplay&&dd(r.autoplay),xc=lb(r.thumbwidth)||Ua,yc=lb(r.thumbheight)||Ua,Ic.ok=Kc.ok=r.trackpad&&!Ma,cd(),Kd(r,[Fc]),sc=\"thumbs\"===rc,Oa.filter(\":hidden\")&&rc&&Oa.show(),sc?(td(ra,\"navThumb\"),_a=eb,Vc=Za,Gb(ua,d.Fotorama.jst.style({w:xc,h:yc,b:r.thumbborderwidth,m:r.thumbmargin,s:O,q:!Ja})),Ra.addClass(L).removeClass(K)):\"dots\"===rc?(td(ra,\"navDot\"),_a=cb,Vc=Ya,Ra.addClass(K).removeClass(L)):(Oa.hide(),rc=!1,Ra.removeClass(L+\" \"+K)),rc&&(tc?Oa.insertBefore(ya):Oa.insertAfter(ya),xd.nav=!1,xd(_a,Ta,\"nav\")),uc=r.allowfullscreen,uc?(vb.prependTo(ya),vc=Ka&&\"native\"===uc):(vb.detach(),vc=!1),b(wc,l),b(!wc,m),b(!r.captions,s),b(Cc,q),b(r.arrows,t),Bc=r.shadows&&!Ma,b(!Bc,o),wa.addClass(a.add.join(\" \")).removeClass(a.remove.join(\" \")),Ec=d.extend({},r),$c()}function hd(a){return a<0?(ra+a%ra)%ra:a>=ra?a%ra:a}function id(a){return fb(a,0,ra-1)}function jd(a){return qc?hd(a):id(a)}function kd(a){return!!(a>0||qc)&&a-1}function ld(a){return!!(a<ra-1||qc)&&a+1}function md(){Hc.min=qc?-(1/0):-pb(ra-1,Fc.w,r.margin,fc),Hc.max=qc?1/0:-pb(0,Fc.w,r.margin,fc),Hc.snap=Fc.w+r.margin}function nd(){var a=\"vertical\"===r.navdir,b=a?Ta.height():Ta.width(),c=a?Fc.h:Fc.nw;Jc.min=Math.min(0,c-b),Jc.max=0,Jc.direction=r.navdir,Ta.toggleClass(y,!(Jc.noMove=Jc.min===Jc.max))}function od(a,b,c){if(\"number\"==typeof a){a=new Array(a);var e=!0}return d.each(a,function(a,d){if(e&&(d=a),\"number\"==typeof d){var f=ea[hd(d)];if(f){var g=\"$\"+b+\"Frame\",h=f[g];c.call(this,a,d,f,h,g,h&&h.data())}}})}function pd(a,b,c,d){(!Gc||\"*\"===Gc&&d===pc)&&(a=ob(r.width)||ob(a)||Va,b=ob(r.height)||ob(b)||Wa,N.resize({width:a,ratio:r.ratio||c||a/b},0,d!==pc&&\"*\"))}function qd(a,b,c,e){od(a,b,function(a,f,g,h,i,j){function s(a){var b=hd(f);Ld(a,{index:b,src:p,frame:ea[b]})}function t(){m.remove(),d.Fotorama.cache[p]=\"error\",g.html&&\"stage\"===b||!q||q===p?(!p||g.html||k?\"stage\"===b&&(h.trigger(\"f:load\").removeClass(aa+\" \"+_).addClass(ba),s(\"load\"),pd()):(h.trigger(\"f:error\").removeClass(aa).addClass(_),s(\"error\")),j.state=\"error\",!(ra>1&&ea[f]===g)||g.html||g.deleted||g.video||k||(g.deleted=!0,N.splice(f,1))):(g[o]=p=q,j.$full=null,qd([f],b,c,!0))}function u(){d.Fotorama.measures[p]=n.measures=d.Fotorama.measures[p]||{width:l.width,height:l.height,ratio:l.width/l.height},pd(n.measures.width,n.measures.height,n.measures.ratio,f),m.off(\"load error\").addClass(\"\"+(k?ga:fa)).attr(\"aria-hidden\",\"false\").prependTo(h),h.hasClass(v)&&!h.hasClass(ma)&&h.attr(\"href\",m.attr(\"src\")),Fb(m,(d.isFunction(c)?c():c)||Fc),d.Fotorama.cache[p]=j.state=\"loaded\",setTimeout(function(){h.trigger(\"f:load\").removeClass(aa+\" \"+_).addClass(ba+\" \"+(k?ca:da)),\"stage\"===b?s(\"load\"):(g.thumbratio===$a||!g.thumbratio&&r.thumbratio===$a)&&(g.thumbratio=n.measures.ratio,ce())},0)}function w(){var a=10;Eb(function(){return!Tc||!a--&&!Ma},function(){u()})}if(h){var k=N.fullScreen&&!j.$full&&\"stage\"===b;if(!j.$img||e||k){var l=new Image,m=d(l),n=m.data();j[k?\"$full\":\"$img\"]=m;var o=\"stage\"===b?k?\"full\":\"img\":\"thumb\",p=g[o],q=k?g.img:g[\"stage\"===b?\"thumb\":\"img\"];if(\"navThumb\"===b&&(h=j.$wrap),!p)return void t();d.Fotorama.cache[p]?!function a(){\"error\"===d.Fotorama.cache[p]?t():\"loaded\"===d.Fotorama.cache[p]?setTimeout(w,0):setTimeout(a,100)}():(d.Fotorama.cache[p]=\"*\",m.on(\"load\",w).on(\"error\",t)),j.state=\"\",l.src=p,j.data.caption&&(l.alt=j.data.caption||\"\"),j.data.full&&d(l).data(\"original\",j.data.full),$b.isExpectedCaption(g,r.showcaption)&&d(l).attr(\"aria-labelledby\",g.labelledby)}}})}function rd(){var a=dc[Xa];a&&!a.data().state&&(Ub.addClass(ta),a.on(\"f:load f:error\",function(){a.off(\"f:load f:error\"),Ub.removeClass(ta)}))}function sd(a){Wb(a,_d),Xb(a,function(){setTimeout(function(){Ob(Ra)},0),Fd({time:zc,guessIndex:d(this).data().eq,minMax:Jc})})}function td(a,b){od(a,b,function(a,c,e,f,g,h){if(!f){f=e[g]=wa[g].clone(),h=f.data(),h.data=e;var i=f[0],j=\"labelledby\"+d.now();\"stage\"===b?(e.html&&d('<div class=\"'+la+'\"></div>').append(e._html?d(e.html).removeAttr(\"id\").html(e._html):e.html).appendTo(f),e.id&&(j=e.id||j),e.labelledby=j,$b.isExpectedCaption(e,r.showcaption)&&d(d.Fotorama.jst.frameCaption({caption:e.caption,labelledby:j})).appendTo(f),e.video&&f.addClass(w).append(xb.clone()),Xb(i,function(){setTimeout(function(){Ob(ya)},0),Yd({index:h.eq,user:!0})}),Ba=Ba.add(f)):\"navDot\"===b?(sd(i),cb=cb.add(f)):\"navThumb\"===b&&(sd(i),h.$wrap=f.children(\":first\"),eb=eb.add(f),e.video&&h.$wrap.append(xb.clone()))}})}function ud(a,b){return a&&a.length&&Fb(a,b)}function vd(a){od(a,\"stage\",function(a,b,c,e,f,g){if(e){var h=hd(b);g.eq=h,Rc[Xa][h]=e.css(d.extend({left:wc?0:pb(b,Fc.w,r.margin,fc)},wc&&jb(0))),Db(e[0])&&(e.appendTo(Aa),Vd(c.$video)),ud(g.$img,Fc),ud(g.$full,Fc),!e.hasClass(v)||\"false\"===e.attr(\"aria-hidden\")&&e.hasClass(W)||e.attr(\"aria-hidden\",\"true\")}})}function wd(a,b){var c,e;\"thumbs\"!==rc||isNaN(a)||(c=-a,e=-a+Fc.nw,\"vertical\"===r.navdir&&(a-=r.thumbheight,e=-a+Fc.h),eb.each(function(){var a=d(this),f=a.data(),g=f.eq,h=function(){return{h:yc,w:f.w}},i=h(),j=\"vertical\"===r.navdir?f.t>e:f.l>e;i.w=f.w,f.l+f.w<c||j||ud(f.$img,i)||b&&qd([g],\"navThumb\",h)}))}function xd(a,b,c){if(!xd[c]){var e=\"nav\"===c&&sc,f=0,g=0;b.append(a.filter(function(){for(var a,b=d(this),c=b.data(),e=0,f=ea.length;e<f;e++)if(c.data===ea[e]){a=!0,c.eq=e;break}return a||b.remove()&&!1}).sort(function(a,b){return d(a).data().eq-d(b).data().eq}).each(function(){var a=d(this),b=a.data();$b.setThumbAttr(a,b.data.caption,\"aria-label\")}).each(function(){if(e){var a=d(this),b=a.data(),c=Math.round(yc*b.data.thumbratio)||xc,h=Math.round(xc/b.data.thumbratio)||yc;b.t=g,b.h=h,b.l=f,b.w=c,a.css({width:c}),g+=h+r.thumbmargin,f+=c+r.thumbmargin}})),xd[c]=!0}}function yd(a){return a-Wc>Fc.w/3}function zd(a){return!(qc||cc+a&&cc-ra+a||bc)}function Ad(){var a=zd(0),b=zd(1);Ga.toggleClass(B,a).attr(Vb(a,!1)),Ha.toggleClass(B,b).attr(Vb(b,!1))}function Bd(){var a=!1,b=!1;if(\"thumbs\"!==r.navtype||r.loop||(a=0==cc,b=cc==r.data.length-1),\"slides\"===r.navtype){var c=hb(Ta,r.navdir);a=c>=Jc.max,b=c<=Jc.min}rb.toggleClass(B,a).attr(Vb(a,!0)),sb.toggleClass(B,b).attr(Vb(b,!0))}function Cd(){Ic.ok&&(Ic.prevent={\"<\":zd(0),\">\":zd(1)})}function Dd(a){var c,d,e,f,b=a.data();sc?(c=b.l,d=b.t,e=b.w,f=b.h):(c=a.position().left,e=a.width());var g={c:c+e/2,min:-c+10*r.thumbmargin,max:-c+Fc.w-e-10*r.thumbmargin},h={c:d+f/2,min:-d+10*r.thumbmargin,max:-d+Fc.h-f-10*r.thumbmargin};return\"vertical\"===r.navdir?h:g}function Ed(a){var b=dc[Vc].data();_b(mb,{time:1.2*a,pos:\"vertical\"===r.navdir?b.t:b.l,width:b.w,height:b.h,direction:r.navdir})}function Fd(a){var d,e,f,g,h,i,j,k,b=ea[a.guessIndex][Vc],c=r.navtype;b&&(\"thumbs\"===c?(d=Jc.min!==Jc.max,f=a.minMax||d&&Dd(dc[Vc]),g=d&&(a.keep&&Fd.t?Fd.l:fb((a.coo||Fc.nw/2)-Dd(b).c,f.min,f.max)),h=d&&(a.keep&&Fd.l?Fd.l:fb((a.coo||Fc.nw/2)-Dd(b).c,f.min,f.max)),i=\"vertical\"===r.navdir?g:h,j=d&&fb(i,Jc.min,Jc.max)||0,e=1.1*a.time,_b(Ta,{time:e,pos:j,direction:r.navdir,onEnd:function(){wd(j,!0),Bd()}}),Ud(Ra,Hb(j,Jc.min,Jc.max,r.navdir)),Fd.l=i):(k=hb(Ta,r.navdir),e=1.11*a.time,j=Tb(r,Jc,a.guessIndex,k,b,Oa,r.navdir),_b(Ta,{time:e,pos:j,direction:r.navdir,onEnd:function(){wd(j,!0),Bd()}}),Ud(Ra,Hb(j,Jc.min,Jc.max,r.navdir))))}function Gd(){Hd(Vc),Qc[Vc].push(dc[Vc].addClass(W).attr(\"data-active\",!0))}function Hd(a){for(var b=Qc[a];b.length;)b.shift().removeClass(W).attr(\"data-active\",!1)}function Id(a){var b=Rc[a];d.each(ec,function(a,c){delete b[hd(c)]}),d.each(b,function(a,c){delete b[a],c.detach()})}function Jd(a){fc=gc=cc;var b=dc[Xa];b&&(Hd(Xa),Qc[Xa].push(b.addClass(W).attr(\"data-active\",!0)),b.hasClass(v)&&b.attr(\"aria-hidden\",\"false\"),a||N.showStage.onEnd(!0),tb(Aa,0,!0),Id(Xa),vd(ec),md(),nd(),Wb(Aa[0],function(){c.hasClass(Z)||(N.requestFullScreen(),vb.focus())}))}function Kd(a,b){a&&d.each(b,function(b,c){c&&d.extend(c,{width:a.width||c.width,height:a.height,minwidth:a.minwidth,maxwidth:a.maxwidth,minheight:a.minheight,maxheight:a.maxheight,ratio:Qb(a.ratio)})})}function Ld(a,b){c.trigger(f+\":\"+a,[N,b])}function Md(){clearTimeout(Nd.t),Tc=1,r.stopautoplayontouch?N.stopAutoplay():Oc=!0}function Nd(){Tc&&(r.stopautoplayontouch||(Od(),Pd()),Nd.t=setTimeout(function(){Tc=0},Qa+Pa))}function Od(){Oc=!(!bc&&!Pc)}function Pd(){if(clearTimeout(Pd.t),Eb.stop(Pd.w),!r.autoplay||Oc)return void(N.autoplay&&(N.autoplay=!1,Ld(\"stopautoplay\")));N.autoplay||(N.autoplay=!0,Ld(\"startautoplay\"));var a=cc,b=dc[Xa].data();Pd.w=Eb(function(){return b.state||a!==cc},function(){Pd.t=setTimeout(function(){if(!Oc&&a===cc){var b=oc,c=ea[b][Xa].data();Pd.w=Eb(function(){return c.state||b!==oc},function(){Oc||b!==oc||N.show(qc?Zb(!Cc):oc)})}},r.autoplay)})}function Qd(a){var b;return\"object\"!=typeof a?(b=a,a={}):b=a.index,b=\">\"===b?gc+1:\"<\"===b?gc-1:\"<<\"===b?0:\">>\"===b?ra-1:b,b=isNaN(b)?e:b,b=\"undefined\"==typeof b?cc||0:b}function Rd(a){N.activeIndex=cc=jd(a),kc=kd(cc),nc=ld(cc),oc=hd(cc+(Cc?-1:1)),ec=[cc,kc,nc],gc=qc?a:cc}function Sd(a){var b=Math.abs(hc-gc),c=ub(a.time,function(){return Math.min(zc*(1+(b-1)/12),2*zc)});return a.slow&&(c*=10),c}function Td(){N.fullScreen&&(N.fullScreen=!1,Ka&&xa.cancel(Q),Fa.removeClass(g),Ea.removeClass(g),c.removeClass(Z).insertAfter(va),Fc=d.extend({},Sc),Vd(bc,!0,!0),$d(\"x\",!1),N.resize(),qd(ec,\"stage\"),Ob(Ca,Mc,Lc),Ld(\"fullscreenexit\"))}function Ud(a,b){Bc&&(a.removeClass(S+\" \"+T),a.removeClass(U+\" \"+V),b&&!bc&&a.addClass(b.replace(/^|\\s/g,\" \"+R+\"--\")))}function Vd(a,b,c){b&&(wa.removeClass(k),bc=!1,cd()),a&&a!==bc&&(a.remove(),Ld(\"unloadvideo\")),c&&(Od(),Pd())}function Wd(a){wa.toggleClass(n,a)}function Xd(a){if(!Hc.flow){var b=a?a.pageX:Xd.x,c=b&&!zd(yd(b))&&r.click;Xd.p!==c&&ya.toggleClass(z,c)&&(Xd.p=c,Xd.x=b)}}function Yd(a){clearTimeout(Yd.t),r.clicktransition&&r.clicktransition!==r.transition?setTimeout(function(){var b=r.transition;N.setOptions({transition:r.clicktransition}),Ac=b,Yd.t=setTimeout(function(){N.show(a)},10)},0):N.show(a)}function Zd(a,b){var e=a.target,f=d(e);f.hasClass(oa)?N.playVideo():e===wb?N.toggleFullScreen():bc?e===Rb&&Vd(bc,!0,!0):c.hasClass(Z)||N.requestFullScreen()}function $d(a,b){Hc[a]=Jc[a]=b}function _d(a){var b=d(this).data().eq;Yd(\"thumbs\"===r.navtype?{index:b,slow:a.altKey,user:!0,coo:a._x-Ra.offset().left}:{index:b,slow:a.altKey,user:!0})}function ae(a){Yd({index:La.index(this)?\">\":\"<\",slow:a.altKey,user:!0})}function be(a){Xb(a,function(){setTimeout(function(){Ob(ya)},0),Wd(!1)})}function ce(){if(bd(),gd(),!ce.i){ce.i=!0;var a=r.startindex;cc=fc=gc=hc=pc=jd(a)||0}if(ra){if(de())return;bc&&Vd(bc,!0),ec=[],Id(Xa),ce.ok=!0,N.show({index:cc,time:0}),N.resize()}else N.destroy()}function de(){if(!de.f===Cc)return de.f=Cc,cc=ra-1-cc,N.reverse(),!0}function ee(){ee.ok&&(ee.ok=!1,Ld(\"ready\"))}Ea=d(\"html\"),Fa=d(\"body\");var ea,ra,_a,bc,dc,ec,fc,gc,hc,kc,nc,oc,pc,qc,rc,sc,tc,uc,vc,wc,xc,yc,zc,Ac,Bc,Cc,Dc,Gc,Lc,Mc,Nc,Oc,Pc,Sc,Tc,Uc,Vc,N=this,O=d.now(),P=f+O,Q=c[0],ha=1,qa=c.data(),ua=d(\"<style></style>\"),va=d(Jb(Y)),wa=c.find(Kb(h)),ya=wa.find(Kb(u)),Aa=(ya[0],c.find(Kb(x))),Ba=d(),Ga=c.find(Kb(C)),Ha=c.find(Kb(D)),La=c.find(Kb(A)),Oa=c.find(Kb(F)),Ra=Oa.find(Kb(E)),Ta=Ra.find(Kb(G)),cb=d(),eb=d(),mb=(Aa.data(),Ta.data(),c.find(Kb(ka))),rb=c.find(Kb(ia)),sb=c.find(Kb(ja)),vb=c.find(Kb($)),wb=vb[0],xb=d(Jb(oa)),Cb=c.find(Kb(pa)),Rb=Cb[0],Ub=c.find(Kb(sa)),cc=!1,Ec={},Fc={},Hc={},Ic={},Jc={},Kc={},Qc={},Rc={},Wc=0,Xc=[];wa[Xa]=d('<div class=\"'+v+'\"></div>'),wa[Za]=d(d.Fotorama.jst.thumb()),wa[Ya]=d(d.Fotorama.jst.dots()),\n    Qc[Xa]=[],Qc[Za]=[],Qc[Ya]=[],Rc[Xa]={},wa.addClass(Ia?j:i),qa.fotorama=this,N.startAutoplay=function(a){return N.autoplay?this:(Oc=Pc=!1,dd(a||r.autoplay),Pd(),this)},N.stopAutoplay=function(){return N.autoplay&&(Oc=Pc=!0,Pd()),this},N.showSlide=function(a){var c,b=hb(Ta,r.navdir),d=550,e=\"horizontal\"===r.navdir?r.thumbwidth:r.thumbheight,f=function(){Bd()};\"next\"===a&&(c=b-(e+r.margin)*bb),\"prev\"===a&&(c=b+(e+r.margin)*bb),c=Sb(c,Jc),wd(c,!0),_b(Ta,{time:d,pos:c,direction:r.navdir,onEnd:f})},N.showWhileLongPress=function(a){if(!N.longPress.singlePressInProgress){var b=Qd(a);Rd(b);var c=Sd(a)/50,d=dc;N.activeFrame=dc=ea[cc];var e=d===dc&&!a.user;return N.showNav(e,a,c),this}},N.showEndLongPress=function(a){if(!N.longPress.singlePressInProgress){var b=Qd(a);Rd(b);var c=Sd(a)/50,d=dc;N.activeFrame=dc=ea[cc];var e=d===dc&&!a.user;return N.showStage(e,a,c),Nc=\"undefined\"!=typeof hc&&hc!==cc,hc=cc,this}},N.showStage=function(a,b,c){Vd(bc,dc.i!==ea[hd(fc)].i),td(ec,\"stage\"),vd(Ma?[gc]:[gc,kd(gc),ld(gc)]),$d(\"go\",!0),a||Ld(\"show\",{user:b.user,time:c}),Oc=!0;var d=b.overPos,e=N.showStage.onEnd=function(c){if(!e.ok){if(e.ok=!0,c||Jd(!0),a||Ld(\"showend\",{user:b.user}),!c&&Ac&&Ac!==r.transition)return N.setOptions({transition:Ac}),void(Ac=!1);rd(),qd(ec,\"stage\"),$d(\"go\",!1),Cd(),Xd(),Od(),Pd(),N.fullScreen?(dc[Xa].find(\".\"+ga).attr(\"aria-hidden\",!1),dc[Xa].find(\".\"+fa).attr(\"aria-hidden\",!0)):(dc[Xa].find(\".\"+ga).attr(\"aria-hidden\",!0),dc[Xa].find(\".\"+fa).attr(\"aria-hidden\",!1))}};if(wc){var f=dc[Xa],g=ea[hc]&&cc!==hc?ea[hc][Xa]:null;ac(f,g,Ba,{time:c,method:r.transition,onEnd:e},Xc)}else _b(Aa,{pos:-pb(gc,Fc.w,r.margin,fc),overPos:d,time:c,onEnd:e});Ad()},N.showNav=function(a,b,c){if(Bd(),rc){Gd();var d=id(cc+fb(gc-hc,-1,1));Fd({time:c,coo:d!==cc&&b.coo,guessIndex:\"undefined\"!=typeof b.coo?d:cc,keep:a}),sc&&Ed(c)}},N.show=function(a){N.longPress.singlePressInProgress=!0;var b=Qd(a);Rd(b);var c=Sd(a),d=dc;N.activeFrame=dc=ea[cc];var e=d===dc&&!a.user;return N.showStage(e,a,c),N.showNav(e,a,c),Nc=\"undefined\"!=typeof hc&&hc!==cc,hc=cc,N.longPress.singlePressInProgress=!1,this},N.requestFullScreen=function(){if(uc&&!N.fullScreen){var b=d((N.activeFrame||{}).$stageFrame||{}).hasClass(\"fotorama-video-container\");if(b)return;Lc=Ca.scrollTop(),Mc=Ca.scrollLeft(),Ob(Ca),$d(\"x\",!0),Sc=d.extend({},Fc),c.addClass(Z).appendTo(Fa.addClass(g)),Ea.addClass(g),Vd(bc,!0,!0),N.fullScreen=!0,vc&&xa.request(Q),N.resize(),qd(ec,\"stage\"),rd(),Ld(\"fullscreenenter\"),\"ontouchstart\"in a||vb.focus()}return this},N.cancelFullScreen=function(){return vc&&xa.is()?xa.cancel(b):Td(),this},N.toggleFullScreen=function(){return N[(N.fullScreen?\"cancel\":\"request\")+\"FullScreen\"]()},N.resize=function(b){if(!ea)return this;var c=arguments[1]||0,e=arguments[2];bb=fd(wa,r),Kd(N.fullScreen?{width:d(a).width(),maxwidth:null,minwidth:null,height:d(a).height(),maxheight:null,minheight:null}:Pb(b),[Fc,e||N.fullScreen||r]);var f=Fc.width,g=Fc.height,h=Fc.ratio,i=Ca.height()-(rc?Ra.height():0);if(ob(f)&&(wa.css({width:\"\"}),wa.css({height:\"\"}),ya.css({width:\"\"}),ya.css({height:\"\"}),Aa.css({width:\"\"}),Aa.css({height:\"\"}),Ra.css({width:\"\"}),Ra.css({height:\"\"}),wa.css({minWidth:Fc.minwidth||0,maxWidth:Fc.maxwidth||ab}),\"dots\"===rc&&Oa.hide(),f=Fc.W=Fc.w=wa.width(),Fc.nw=rc&&nb(r.navwidth,f)||f,Aa.css({width:Fc.w,marginLeft:(Fc.W-Fc.w)/2}),g=nb(g,i),g=g||h&&f/h)){if(f=Math.round(f),g=Fc.h=Math.round(fb(g,nb(Fc.minheight,i),nb(Fc.maxheight,i))),ya.css({width:f,height:g}),\"vertical\"!==r.navdir||N.fullscreen||Ra.width(r.thumbwidth+2*r.thumbmargin),\"horizontal\"!==r.navdir||N.fullscreen||Ra.height(r.thumbheight+2*r.thumbmargin),\"dots\"===rc&&(Ra.width(f).height(\"auto\"),Oa.show()),\"vertical\"===r.navdir&&N.fullScreen&&ya.css(\"height\",Ca.height()),\"horizontal\"===r.navdir&&N.fullScreen&&ya.css(\"height\",Ca.height()-Ra.height()),rc){switch(r.navdir){case\"vertical\":Oa.removeClass(J),Oa.removeClass(I),Oa.addClass(H),Ra.stop().animate({height:Fc.h,width:r.thumbwidth},c);break;case\"list\":Oa.removeClass(H),Oa.removeClass(J),Oa.addClass(I);break;default:Oa.removeClass(H),Oa.removeClass(I),Oa.addClass(J),Ra.stop().animate({width:Fc.nw},c)}Jd(),Fd({guessIndex:cc,time:c,keep:!0}),sc&&xd.nav&&Ed(c)}Gc=e||!0,ee.ok=!0,ee()}return Wc=ya.offset().left,$c(),this},N.setOptions=function(a){return d.extend(r,a),ce(),this},N.shuffle=function(){return ea&&Mb(ea)&&ce(),this},N.longPress={threshold:1,count:0,thumbSlideTime:20,progress:function(){this.inProgress||(this.count++,this.inProgress=this.count>this.threshold)},end:function(){this.inProgress&&(this.isEnded=!0)},reset:function(){this.count=0,this.inProgress=!1,this.isEnded=!1}},N.destroy=function(){return N.cancelFullScreen(),N.stopAutoplay(),ea=N.data=null,ad(),ec=[],Id(Xa),ce.ok=!1,this},N.playVideo=function(){var a=dc,b=a.video,c=cc;return\"object\"==typeof b&&a.videoReady&&(vc&&N.fullScreen&&N.cancelFullScreen(),Eb(function(){return!xa.is()||c!==cc},function(){c===cc&&(a.$video=a.$video||d(Jb(na)).append(Lb(b)),a.$video.appendTo(a[Xa]),wa.addClass(k),bc=a.$video,cd(),La.blur(),vb.blur(),Ld(\"loadvideo\"))})),this},N.stopVideo=function(){return Vd(bc,!0,!0),this},N.spliceByIndex=function(a,b){b.i=a+1,b.img&&d.ajax({url:b.img,type:\"HEAD\",success:function(){ea.splice(a,1,b),ce()}})},ya.on(\"mousemove\",Xd),Hc=ic(Aa,{onStart:Md,onMove:function(a,b){Ud(ya,b.edge)},onTouchEnd:Nd,onEnd:function(a){var b;if(Ud(ya),b=(Na&&!Uc||a.touch)&&r.arrows,(a.moved||b&&a.pos!==a.newPos&&!a.control)&&a.$target[0]!==vb[0]){var c=qb(a.newPos,Fc.w,r.margin,fc);N.show({index:c,time:wc?zc:a.time,overPos:a.overPos,user:!0})}else a.aborted||a.control||Zd(a.startEvent,b)},timeLow:1,timeHigh:1,friction:2,select:\".\"+X+\", .\"+X+\" *\",$wrap:ya,direction:\"horizontal\"}),Jc=ic(Ta,{onStart:Md,onMove:function(a,b){Ud(Ra,b.edge)},onTouchEnd:Nd,onEnd:function(a){function b(){Fd.l=a.newPos,Od(),Pd(),wd(a.newPos,!0),Bd()}if(a.moved)a.pos!==a.newPos?(Oc=!0,_b(Ta,{time:a.time,pos:a.newPos,overPos:a.overPos,direction:r.navdir,onEnd:b}),wd(a.newPos),Bc&&Ud(Ra,Hb(a.newPos,Jc.min,Jc.max,a.dir))):b();else{var c=a.$target.closest(\".\"+M,Ta)[0];c&&_d.call(c,a.startEvent)}},timeLow:.5,timeHigh:2,friction:5,$wrap:Ra,direction:r.navdir}),Ic=jc(ya,{shift:!0,onEnd:function(a,b){Md(),Nd(),N.show({index:b,slow:a.altKey})}}),Kc=jc(Ra,{onEnd:function(a,b){Md(),Nd();var c=tb(Ta)+.25*b;Ta.css(ib(fb(c,Jc.min,Jc.max),r.navdir)),Bc&&Ud(Ra,Hb(c,Jc.min,Jc.max,r.navdir)),Kc.prevent={\"<\":c>=Jc.max,\">\":c<=Jc.min},clearTimeout(Kc.t),Kc.t=setTimeout(function(){Fd.l=c,wd(c,!0)},Pa),wd(c)}}),wa.hover(function(){setTimeout(function(){Tc||Wd(!(Uc=!0))},0)},function(){Uc&&Wd(!(Uc=!1))}),Ib(La,function(a){Yb(a),ae.call(this,a)},{onStart:function(){Md(),Hc.control=!0},onTouchEnd:Nd}),Ib(rb,function(a){Yb(a),\"thumbs\"===r.navtype?N.show(\"<\"):N.showSlide(\"prev\")}),Ib(sb,function(a){Yb(a),\"thumbs\"===r.navtype?N.show(\">\"):N.showSlide(\"next\")}),La.each(function(){Wb(this,function(a){ae.call(this,a)}),be(this)}),Wb(wb,function(){c.hasClass(Z)?(N.cancelFullScreen(),Aa.focus()):(N.requestFullScreen(),vb.focus())}),be(wb),d.each(\"load push pop shift unshift reverse sort splice\".split(\" \"),function(a,b){N[b]=function(){return ea=ea||[],\"load\"!==b?Array.prototype[b].apply(ea,arguments):arguments[0]&&\"object\"==typeof arguments[0]&&arguments[0].length&&(ea=Nb(arguments[0])),ce(),N}}),ce()},d.fn.fotorama=function(b){return this.each(function(){var c=this,e=d(this),f=e.data(),g=f.fotorama;g?g.setOptions(b,!0):Eb(function(){return!Cb(c)},function(){f.urtext=e.html(),new d.Fotorama(e,d.extend({},cb,a.fotoramaDefaults,b,f))})})},d.Fotorama.instances=[],d.Fotorama.cache={},d.Fotorama.measures={},d=d||{},d.Fotorama=d.Fotorama||{},d.Fotorama.jst=d.Fotorama.jst||{},d.Fotorama.jst.dots=function(a){var c=\"\";va.escape;return c+='<div class=\"fotorama__nav__frame fotorama__nav__frame--dot\" tabindex=\"0\" role=\"button\" data-gallery-role=\"nav-frame\" data-nav-type=\"thumb\" aria-label>\\r\\n    <div class=\"fotorama__dot\"></div>\\r\\n</div>'},d.Fotorama.jst.frameCaption=function(a){var b,c=\"\";va.escape;return c+='<div class=\"fotorama__caption\" aria-hidden=\"true\">\\r\\n    <div class=\"fotorama__caption__wrap\" id=\"'+(null==(b=a.labelledby)?\"\":b)+'\">'+(null==(b=a.caption)?\"\":b)+\"</div>\\r\\n</div>\\r\\n\"},d.Fotorama.jst.style=function(a){var b,c=\"\";va.escape;return c+=\".fotorama\"+(null==(b=a.s)?\"\":b)+\" .fotorama__nav--thumbs .fotorama__nav__frame{\\r\\npadding:\"+(null==(b=a.m)?\"\":b)+\"px;\\r\\nheight:\"+(null==(b=a.h)?\"\":b)+\"px}\\r\\n.fotorama\"+(null==(b=a.s)?\"\":b)+\" .fotorama__thumb-border{\\r\\nheight:\"+(null==(b=a.h)?\"\":b)+\"px;\\r\\nborder-width:\"+(null==(b=a.b)?\"\":b)+\"px;\\r\\nmargin-top:\"+(null==(b=a.m)?\"\":b)+\"px}\"},d.Fotorama.jst.thumb=function(a){var c=\"\";va.escape;return c+='<div class=\"fotorama__nav__frame fotorama__nav__frame--thumb\" tabindex=\"0\" role=\"button\" data-gallery-role=\"nav-frame\" data-nav-type=\"thumb\" aria-label>\\r\\n    <div class=\"fotorama__thumb\">\\r\\n    </div>\\r\\n</div>'}}(window,document,location,\"undefined\"!=typeof jQuery&&jQuery);","fotorama/fotorama.js":"/*!\n * Fotorama 4.6.4 | http://fotorama.io/license/\n */\nfotoramaVersion = '4.6.4';\n(function (window, document, location, $, undefined) {\n    \"use strict\";\n    var _fotoramaClass = 'fotorama',\n        _fullscreenClass = 'fotorama__fullscreen',\n\n        wrapClass = _fotoramaClass + '__wrap',\n        wrapCss2Class = wrapClass + '--css2',\n        wrapCss3Class = wrapClass + '--css3',\n        wrapVideoClass = wrapClass + '--video',\n        wrapFadeClass = wrapClass + '--fade',\n        wrapSlideClass = wrapClass + '--slide',\n        wrapNoControlsClass = wrapClass + '--no-controls',\n        wrapNoShadowsClass = wrapClass + '--no-shadows',\n        wrapPanYClass = wrapClass + '--pan-y',\n        wrapRtlClass = wrapClass + '--rtl',\n        wrapOnlyActiveClass = wrapClass + '--only-active',\n        wrapNoCaptionsClass = wrapClass + '--no-captions',\n        wrapToggleArrowsClass = wrapClass + '--toggle-arrows',\n\n        stageClass = _fotoramaClass + '__stage',\n        stageFrameClass = stageClass + '__frame',\n        stageFrameVideoClass = stageFrameClass + '--video',\n        stageShaftClass = stageClass + '__shaft',\n\n        grabClass = _fotoramaClass + '__grab',\n        pointerClass = _fotoramaClass + '__pointer',\n\n        arrClass = _fotoramaClass + '__arr',\n        arrDisabledClass = arrClass + '--disabled',\n        arrPrevClass = arrClass + '--prev',\n        arrNextClass = arrClass + '--next',\n\n        navClass = _fotoramaClass + '__nav',\n        navWrapClass = navClass + '-wrap',\n        navShaftClass = navClass + '__shaft',\n        navShaftVerticalClass = navWrapClass + '--vertical',\n        navShaftListClass = navWrapClass + '--list',\n        navShafthorizontalClass = navWrapClass + '--horizontal',\n        navDotsClass = navClass + '--dots',\n        navThumbsClass = navClass + '--thumbs',\n        navFrameClass = navClass + '__frame',\n\n        fadeClass = _fotoramaClass + '__fade',\n        fadeFrontClass = fadeClass + '-front',\n        fadeRearClass = fadeClass + '-rear',\n\n        shadowClass = _fotoramaClass + '__shadow',\n        shadowsClass = shadowClass + 's',\n        shadowsLeftClass = shadowsClass + '--left',\n        shadowsRightClass = shadowsClass + '--right',\n        shadowsTopClass = shadowsClass + '--top',\n        shadowsBottomClass = shadowsClass + '--bottom',\n\n        activeClass = _fotoramaClass + '__active',\n        selectClass = _fotoramaClass + '__select',\n\n        hiddenClass = _fotoramaClass + '--hidden',\n\n        fullscreenClass = _fotoramaClass + '--fullscreen',\n        fullscreenIconClass = _fotoramaClass + '__fullscreen-icon',\n\n        errorClass = _fotoramaClass + '__error',\n        loadingClass = _fotoramaClass + '__loading',\n        loadedClass = _fotoramaClass + '__loaded',\n        loadedFullClass = loadedClass + '--full',\n        loadedImgClass = loadedClass + '--img',\n\n        grabbingClass = _fotoramaClass + '__grabbing',\n\n        imgClass = _fotoramaClass + '__img',\n        imgFullClass = imgClass + '--full',\n\n        thumbClass = _fotoramaClass + '__thumb',\n        thumbArrLeft = thumbClass + '__arr--left',\n        thumbArrRight = thumbClass + '__arr--right',\n        thumbBorderClass = thumbClass + '-border',\n\n        htmlClass = _fotoramaClass + '__html',\n\n        videoContainerClass = _fotoramaClass + '-video-container',\n        videoClass = _fotoramaClass + '__video',\n        videoPlayClass = videoClass + '-play',\n        videoCloseClass = videoClass + '-close',\n\n\n        horizontalImageClass = _fotoramaClass + '_horizontal_ratio',\n        verticalImageClass = _fotoramaClass + '_vertical_ratio',\n        fotoramaSpinnerClass = _fotoramaClass + '__spinner',\n        spinnerShowClass = fotoramaSpinnerClass + '--show';\n    var JQUERY_VERSION = $ && $.fn.jquery.split('.');\n\n    if (!JQUERY_VERSION\n        || JQUERY_VERSION[0] < 1\n        || (JQUERY_VERSION[0] == 1 && JQUERY_VERSION[1] < 8)) {\n        throw 'Fotorama requires jQuery 1.8 or later and will not run without it.';\n    }\n\n    var _ = {};\n    /* Modernizr 2.8.3 (Custom Build) | MIT & BSD\n     * Build: http://modernizr.com/download/#-csstransforms3d-csstransitions-touch-prefixed\n     */\n\n    var Modernizr = (function (window, document, undefined) {\n        var version = '2.8.3',\n            Modernizr = {},\n\n\n            docElement = document.documentElement,\n\n            mod = 'modernizr',\n            modElem = document.createElement(mod),\n            mStyle = modElem.style,\n            inputElem,\n\n\n            toString = {}.toString,\n\n            prefixes = ' -webkit- -moz- -o- -ms- '.split(' '),\n\n\n            omPrefixes = 'Webkit Moz O ms',\n\n            cssomPrefixes = omPrefixes.split(' '),\n\n            domPrefixes = omPrefixes.toLowerCase().split(' '),\n\n\n            tests = {},\n            inputs = {},\n            attrs = {},\n\n            classes = [],\n\n            slice = classes.slice,\n\n            featureName,\n\n\n            injectElementWithStyles = function (rule, callback, nodes, testnames) {\n\n                var style, ret, node, docOverflow,\n                    div = document.createElement('div'),\n                    body = document.body,\n                    fakeBody = body || document.createElement('body');\n\n                if (parseInt(nodes, 10)) {\n                    while (nodes--) {\n                        node = document.createElement('div');\n                        node.id = testnames ? testnames[nodes] : mod + (nodes + 1);\n                        div.appendChild(node);\n                    }\n                }\n\n                style = ['&#173;', '<style id=\"s', mod, '\">', rule, '</style>'].join('');\n                div.id = mod;\n                (body ? div : fakeBody).innerHTML += style;\n                fakeBody.appendChild(div);\n                if (!body) {\n                    fakeBody.style.background = '';\n                    fakeBody.style.overflow = 'hidden';\n                    docOverflow = docElement.style.overflow;\n                    docElement.style.overflow = 'hidden';\n                    docElement.appendChild(fakeBody);\n                }\n\n                ret = callback(div, rule);\n                if (!body) {\n                    fakeBody.parentNode.removeChild(fakeBody);\n                    docElement.style.overflow = docOverflow;\n                } else {\n                    div.parentNode.removeChild(div);\n                }\n\n                return !!ret;\n\n            },\n            _hasOwnProperty = ({}).hasOwnProperty, hasOwnProp;\n\n        if (!is(_hasOwnProperty, 'undefined') && !is(_hasOwnProperty.call, 'undefined')) {\n            hasOwnProp = function (object, property) {\n                return _hasOwnProperty.call(object, property);\n            };\n        }\n        else {\n            hasOwnProp = function (object, property) {\n                return ((property in object) && is(object.constructor.prototype[property], 'undefined'));\n            };\n        }\n\n\n        if (!Function.prototype.bind) {\n            Function.prototype.bind = function bind(that) {\n\n                var target = this;\n\n                if (typeof target != \"function\") {\n                    throw new TypeError();\n                }\n\n                var args = slice.call(arguments, 1),\n                    bound = function () {\n\n                        if (this instanceof bound) {\n\n                            var F = function () {\n                            };\n                            F.prototype = target.prototype;\n                            var self = new F();\n\n                            var result = target.apply(\n                                self,\n                                args.concat(slice.call(arguments))\n                            );\n                            if (Object(result) === result) {\n                                return result;\n                            }\n                            return self;\n\n                        } else {\n\n                            return target.apply(\n                                that,\n                                args.concat(slice.call(arguments))\n                            );\n\n                        }\n\n                    };\n\n                return bound;\n            };\n        }\n\n        function setCss(str) {\n            mStyle.cssText = str;\n        }\n\n        function setCssAll(str1, str2) {\n            return setCss(prefixes.join(str1 + ';') + ( str2 || '' ));\n        }\n\n        function is(obj, type) {\n            return typeof obj === type;\n        }\n\n        function contains(str, substr) {\n            return !!~('' + str).indexOf(substr);\n        }\n\n        function testProps(props, prefixed) {\n            for (var i in props) {\n                var prop = props[i];\n                if (!contains(prop, \"-\") && mStyle[prop] !== undefined) {\n                    return prefixed == 'pfx' ? prop : true;\n                }\n            }\n            return false;\n        }\n\n        function testDOMProps(props, obj, elem) {\n            for (var i in props) {\n                var item = obj[props[i]];\n                if (item !== undefined) {\n\n                    if (elem === false) return props[i];\n\n                    if (is(item, 'function')) {\n                        return item.bind(elem || obj);\n                    }\n\n                    return item;\n                }\n            }\n            return false;\n        }\n\n        function testPropsAll(prop, prefixed, elem) {\n\n            var ucProp = prop.charAt(0).toUpperCase() + prop.slice(1),\n                props = (prop + ' ' + cssomPrefixes.join(ucProp + ' ') + ucProp).split(' ');\n\n            if (is(prefixed, \"string\") || is(prefixed, \"undefined\")) {\n                return testProps(props, prefixed);\n\n            } else {\n                props = (prop + ' ' + (domPrefixes).join(ucProp + ' ') + ucProp).split(' ');\n                return testDOMProps(props, prefixed, elem);\n            }\n        }\n\n        tests['touch'] = function () {\n            var bool;\n\n            if (('ontouchstart' in window) || window.DocumentTouch && document instanceof DocumentTouch) {\n                bool = true;\n            } else {\n                injectElementWithStyles(['@media (', prefixes.join('touch-enabled),('), mod, ')', '{#modernizr{top:9px;position:absolute}}'].join(''), function (node) {\n                    bool = node.offsetTop === 9;\n                });\n            }\n\n            return bool;\n        };\n        tests['csstransforms3d'] = function () {\n\n            var ret = !!testPropsAll('perspective');\n\n            if (ret && 'webkitPerspective' in docElement.style) {\n\n                injectElementWithStyles('@media (transform-3d),(-webkit-transform-3d){#modernizr{left:9px;position:absolute;height:3px;}}', function (node, rule) {\n                    ret = node.offsetLeft === 9 && node.offsetHeight === 3;\n                });\n            }\n            return ret;\n        };\n\n\n        tests['csstransitions'] = function () {\n            return testPropsAll('transition');\n        };\n\n\n        for (var feature in tests) {\n            if (hasOwnProp(tests, feature)) {\n                featureName = feature.toLowerCase();\n                Modernizr[featureName] = tests[feature]();\n\n                classes.push((Modernizr[featureName] ? '' : 'no-') + featureName);\n            }\n        }\n\n\n        Modernizr.addTest = function (feature, test) {\n            if (typeof feature == 'object') {\n                for (var key in feature) {\n                    if (hasOwnProp(feature, key)) {\n                        Modernizr.addTest(key, feature[key]);\n                    }\n                }\n            } else {\n\n                feature = feature.toLowerCase();\n\n                if (Modernizr[feature] !== undefined) {\n                    return Modernizr;\n                }\n\n                test = typeof test == 'function' ? test() : test;\n\n                if (typeof enableClasses !== \"undefined\" && enableClasses) {\n                    docElement.className += ' ' + (test ? '' : 'no-') + feature;\n                }\n                Modernizr[feature] = test;\n\n            }\n\n            return Modernizr;\n        };\n\n\n        setCss('');\n        modElem = inputElem = null;\n\n\n        Modernizr._version = version;\n\n        Modernizr._prefixes = prefixes;\n        Modernizr._domPrefixes = domPrefixes;\n        Modernizr._cssomPrefixes = cssomPrefixes;\n\n\n        Modernizr.testProp = function (prop) {\n            return testProps([prop]);\n        };\n\n        Modernizr.testAllProps = testPropsAll;\n        Modernizr.testStyles = injectElementWithStyles;\n        Modernizr.prefixed = function (prop, obj, elem) {\n            if (!obj) {\n                return testPropsAll(prop, 'pfx');\n            } else {\n                return testPropsAll(prop, obj, elem);\n            }\n        };\n        return Modernizr;\n    })(window, document);\n\n    var fullScreenApi = {\n            ok: false,\n            is: function () {\n                return false;\n            },\n            request: function () {\n            },\n            cancel: function () {\n            },\n            event: '',\n            prefix: ''\n        },\n        browserPrefixes = 'webkit moz o ms khtml'.split(' ');\n\n// check for native support\n    if (typeof document.cancelFullScreen != 'undefined') {\n        fullScreenApi.ok = true;\n    } else {\n        // check for fullscreen support by vendor prefix\n        for (var i = 0, il = browserPrefixes.length; i < il; i++) {\n            fullScreenApi.prefix = browserPrefixes[i];\n            if (typeof document[fullScreenApi.prefix + 'CancelFullScreen'] != 'undefined') {\n                fullScreenApi.ok = true;\n                break;\n            }\n        }\n    }\n\n// update methods to do something useful\n    if (fullScreenApi.ok) {\n        fullScreenApi.event = fullScreenApi.prefix + 'fullscreenchange';\n        fullScreenApi.is = function () {\n            switch (this.prefix) {\n                case '':\n                    return document.fullScreen;\n                case 'webkit':\n                    return document.webkitIsFullScreen;\n                default:\n                    return document[this.prefix + 'FullScreen'];\n            }\n        };\n        fullScreenApi.request = function (el) {\n            return (this.prefix === '') ? el.requestFullScreen() : el[this.prefix + 'RequestFullScreen']();\n        };\n        fullScreenApi.cancel = function (el) {\n            return (this.prefix === '') ? document.cancelFullScreen() : document[this.prefix + 'CancelFullScreen']();\n        };\n    }\n    /* Bez v1.0.10-g5ae0136\n     * http://github.com/rdallasgray/bez\n     *\n     * A plugin to convert CSS3 cubic-bezier co-ordinates to jQuery-compatible easing functions\n     *\n     * With thanks to Nikolay Nemshilov for clarification on the cubic-bezier maths\n     * See http://st-on-it.blogspot.com/2011/05/calculating-cubic-bezier-function.html\n     *\n     * Copyright 2011 Robert Dallas Gray. All rights reserved.\n     * Provided under the FreeBSD license: https://github.com/rdallasgray/bez/blob/master/LICENSE.txt\n     */\n    function bez(coOrdArray) {\n        var encodedFuncName = \"bez_\" + $.makeArray(arguments).join(\"_\").replace(\".\", \"p\");\n        if (typeof $['easing'][encodedFuncName] !== \"function\") {\n            var polyBez = function (p1, p2) {\n                var A = [null, null],\n                    B = [null, null],\n                    C = [null, null],\n                    bezCoOrd = function (t, ax) {\n                        C[ax] = 3 * p1[ax];\n                        B[ax] = 3 * (p2[ax] - p1[ax]) - C[ax];\n                        A[ax] = 1 - C[ax] - B[ax];\n                        return t * (C[ax] + t * (B[ax] + t * A[ax]));\n                    },\n                    xDeriv = function (t) {\n                        return C[0] + t * (2 * B[0] + 3 * A[0] * t);\n                    },\n                    xForT = function (t) {\n                        var x = t, i = 0, z;\n                        while (++i < 14) {\n                            z = bezCoOrd(x, 0) - t;\n                            if (Math.abs(z) < 1e-3) break;\n                            x -= z / xDeriv(x);\n                        }\n                        return x;\n                    };\n                return function (t) {\n                    return bezCoOrd(xForT(t), 1);\n                }\n            };\n            $['easing'][encodedFuncName] = function (x, t, b, c, d) {\n                return c * polyBez([coOrdArray[0], coOrdArray[1]], [coOrdArray[2], coOrdArray[3]])(t / d) + b;\n            }\n        }\n        return encodedFuncName;\n    }\n\n    var $WINDOW = $(window),\n        $DOCUMENT = $(document),\n        $HTML,\n        $BODY,\n\n        QUIRKS_FORCE = location.hash.replace('#', '') === 'quirks',\n        TRANSFORMS3D = Modernizr.csstransforms3d,\n        CSS3 = TRANSFORMS3D && !QUIRKS_FORCE,\n        COMPAT = TRANSFORMS3D || document.compatMode === 'CSS1Compat',\n        FULLSCREEN = fullScreenApi.ok,\n\n        MOBILE = navigator.userAgent.match(/Android|webOS|iPhone|iPad|iPod|BlackBerry|Windows Phone/i),\n        SLOW = !CSS3 || MOBILE,\n\n        MS_POINTER = navigator.msPointerEnabled,\n\n        WHEEL = \"onwheel\" in document.createElement(\"div\") ? \"wheel\" : document.onmousewheel !== undefined ? \"mousewheel\" : \"DOMMouseScroll\",\n\n        TOUCH_TIMEOUT = 250,\n        TRANSITION_DURATION = 300,\n\n        SCROLL_LOCK_TIMEOUT = 1400,\n\n        AUTOPLAY_INTERVAL = 5000,\n        MARGIN = 2,\n        THUMB_SIZE = 64,\n\n        WIDTH = 500,\n        HEIGHT = 333,\n\n        STAGE_FRAME_KEY = '$stageFrame',\n        NAV_DOT_FRAME_KEY = '$navDotFrame',\n        NAV_THUMB_FRAME_KEY = '$navThumbFrame',\n\n        AUTO = 'auto',\n\n        BEZIER = bez([.1, 0, .25, 1]),\n\n        MAX_WIDTH = 1200,\n\n        /**\n         * Number of thumbnails in slide. Calculated only on setOptions and resize.\n         * @type {number}\n         */\n        thumbsPerSlide = 1,\n\n        OPTIONS = {\n\n            /**\n             * Set width for gallery.\n             * Default value - width of first image\n             * Number - set value in px\n             * String - set value in quotes\n             *\n             */\n            width: null,\n\n            /**\n             * Set min-width for gallery\n             *\n             */\n            minwidth: null,\n\n            /**\n             * Set max-width for gallery\n             *\n             */\n            maxwidth: '100%',\n\n            /**\n             * Set height for gallery\n             * Default value - height of first image\n             * Number - set value in px\n             * String - set value in quotes\n             *\n             */\n            height: null,\n\n            /**\n             * Set min-height for gallery\n             *\n             */\n            minheight: null,\n\n            /**\n             * Set max-height for gallery\n             *\n             */\n            maxheight: null,\n\n            /**\n             * Set proportion ratio for gallery depends of image\n             *\n             */\n            ratio: null, // '16/9' || 500/333 || 1.5\n\n            margin: MARGIN,\n\n            nav: 'dots', // 'thumbs' || false\n            navposition: 'bottom', // 'top'\n            navwidth: null,\n            thumbwidth: THUMB_SIZE,\n            thumbheight: THUMB_SIZE,\n            thumbmargin: MARGIN,\n            thumbborderwidth: MARGIN,\n\n            allowfullscreen: false, // true || 'native'\n\n            transition: 'slide', // 'crossfade' || 'dissolve'\n            clicktransition: null,\n            transitionduration: TRANSITION_DURATION,\n\n            captions: true,\n\n            startindex: 0,\n\n            loop: false,\n\n            autoplay: false,\n            stopautoplayontouch: true,\n\n            keyboard: false,\n\n            arrows: true,\n            click: true,\n            swipe: false,\n            trackpad: false,\n\n            shuffle: false,\n\n            direction: 'ltr', // 'rtl'\n\n            shadows: true,\n\n            showcaption: true,\n\n            /**\n             * Set type of thumbnail navigation\n             */\n            navdir: 'horizontal',\n\n            /**\n             * Set configuration to show or hide arrows in thumb navigation\n             */\n            navarrows: true,\n\n            /**\n             * Set type of navigation. Can be thumbs or slides\n             */\n            navtype: 'thumbs'\n\n        },\n\n        KEYBOARD_OPTIONS = {\n            left: true,\n            right: true,\n            down: true,\n            up: true,\n            space: false,\n            home: false,\n            end: false\n        };\n\n    function noop() {\n    }\n\n    function minMaxLimit(value, min, max) {\n        return Math.max(isNaN(min) ? -Infinity : min, Math.min(isNaN(max) ? Infinity : max, value));\n    }\n\n    function readTransform(css, dir) {\n        return css.match(/ma/) && css.match(/-?\\d+(?!d)/g)[css.match(/3d/) ?\n                (dir === 'vertical' ? 13 : 12) : (dir === 'vertical' ? 5 : 4)\n                ]\n    }\n\n    function readPosition($el, dir) {\n        if (CSS3) {\n            return +readTransform($el.css('transform'), dir);\n        } else {\n            return +$el.css(dir === 'vertical' ? 'top' : 'left').replace('px', '');\n        }\n    }\n\n    function getTranslate(pos, direction) {\n        var obj = {};\n\n        if (CSS3) {\n\n            switch (direction) {\n                case 'vertical':\n                    obj.transform = 'translate3d(0, ' + (pos) + 'px,0)';\n                    break;\n                case 'list':\n                    break;\n                default :\n                    obj.transform = 'translate3d(' + (pos) + 'px,0,0)';\n                    break;\n            }\n        } else {\n            direction === 'vertical' ?\n                obj.top = pos :\n                obj.left = pos;\n        }\n        return obj;\n    }\n\n    function getDuration(time) {\n        return {'transition-duration': time + 'ms'};\n    }\n\n    function unlessNaN(value, alternative) {\n        return isNaN(value) ? alternative : value;\n    }\n\n    function numberFromMeasure(value, measure) {\n        return unlessNaN(+String(value).replace(measure || 'px', ''));\n    }\n\n    function numberFromPercent(value) {\n        return /%$/.test(value) ? numberFromMeasure(value, '%') : undefined;\n    }\n\n    function numberFromWhatever(value, whole) {\n        return unlessNaN(numberFromPercent(value) / 100 * whole, numberFromMeasure(value));\n    }\n\n    function measureIsValid(value) {\n        return (!isNaN(numberFromMeasure(value)) || !isNaN(numberFromMeasure(value, '%'))) && value;\n    }\n\n    function getPosByIndex(index, side, margin, baseIndex) {\n\n        return (index - (baseIndex || 0)) * (side + (margin || 0));\n    }\n\n    function getIndexByPos(pos, side, margin, baseIndex) {\n        return -Math.round(pos / (side + (margin || 0)) - (baseIndex || 0));\n    }\n\n    function bindTransitionEnd($el) {\n        var elData = $el.data();\n\n        if (elData.tEnd) return;\n\n        var el = $el[0],\n            transitionEndEvent = {\n                WebkitTransition: 'webkitTransitionEnd',\n                MozTransition: 'transitionend',\n                OTransition: 'oTransitionEnd otransitionend',\n                msTransition: 'MSTransitionEnd',\n                transition: 'transitionend'\n            };\n        addEvent(el, transitionEndEvent[Modernizr.prefixed('transition')], function (e) {\n            elData.tProp && e.propertyName.match(elData.tProp) && elData.onEndFn();\n        });\n        elData.tEnd = true;\n    }\n\n    function afterTransition($el, property, fn, time) {\n        var ok,\n            elData = $el.data();\n\n        if (elData) {\n            elData.onEndFn = function () {\n                if (ok) return;\n                ok = true;\n                clearTimeout(elData.tT);\n                fn();\n            };\n            elData.tProp = property;\n\n            // Passive call, just in case of fail of native transition-end event\n            clearTimeout(elData.tT);\n            elData.tT = setTimeout(function () {\n                elData.onEndFn();\n            }, time * 1.5);\n\n            bindTransitionEnd($el);\n        }\n    }\n\n\n    function stop($el, pos/*, _001*/) {\n        var dir = $el.navdir || 'horizontal';\n        if ($el.length) {\n            var elData = $el.data();\n            if (CSS3) {\n                $el.css(getDuration(0));\n                elData.onEndFn = noop;\n                clearTimeout(elData.tT);\n            } else {\n                $el.stop();\n            }\n            var lockedPos = getNumber(pos, function () {\n                return readPosition($el, dir);\n            });\n\n            $el.css(getTranslate(lockedPos, dir/*, _001*/));//.width(); // `.width()` for reflow\n            return lockedPos;\n        }\n    }\n\n    function getNumber() {\n        var number;\n        for (var _i = 0, _l = arguments.length; _i < _l; _i++) {\n            number = _i ? arguments[_i]() : arguments[_i];\n            if (typeof number === 'number') {\n                break;\n            }\n        }\n\n        return number;\n    }\n\n    function edgeResistance(pos, edge) {\n        return Math.round(pos + ((edge - pos) / 1.5));\n    }\n\n    function getProtocol() {\n        getProtocol.p = getProtocol.p || (location.protocol === 'https:' ? 'https://' : 'http://');\n        return getProtocol.p;\n    }\n\n    function parseHref(href) {\n        var a = document.createElement('a');\n        a.href = href;\n        return a;\n    }\n\n    function findVideoId(href, forceVideo) {\n        if (typeof href !== 'string') return href;\n        href = parseHref(href);\n\n        var id,\n            type;\n\n        if (href.host.match(/youtube\\.com/) && href.search) {\n            //.log();\n            id = href.search.split('v=')[1];\n            if (id) {\n                var ampersandPosition = id.indexOf('&');\n                if (ampersandPosition !== -1) {\n                    id = id.substring(0, ampersandPosition);\n                }\n                type = 'youtube';\n            }\n        } else if (href.host.match(/youtube\\.com|youtu\\.be/)) {\n            id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n            type = 'youtube';\n        } else if (href.host.match(/vimeo\\.com/)) {\n            type = 'vimeo';\n            id = href.pathname.replace(/^\\/(video\\/)?/, '').replace(/\\/.*/, '');\n        }\n\n        if ((!id || !type) && forceVideo) {\n            id = href.href;\n            type = 'custom';\n        }\n\n        return id ? {id: id, type: type, s: href.search.replace(/^\\?/, ''), p: getProtocol()} : false;\n    }\n\n    function getVideoThumbs(dataFrame, data, fotorama) {\n        var img, thumb, video = dataFrame.video;\n        if (video.type === 'youtube') {\n            thumb = getProtocol() + 'img.youtube.com/vi/' + video.id + '/default.jpg';\n            img = thumb.replace(/\\/default.jpg$/, '/hqdefault.jpg');\n            dataFrame.thumbsReady = true;\n        } else if (video.type === 'vimeo') {\n            $.ajax({\n                url: getProtocol() + 'vimeo.com/api/v2/video/' + video.id + '.json',\n                dataType: 'jsonp',\n                success: function (json) {\n                    dataFrame.thumbsReady = true;\n                    updateData(data, {\n                        img: json[0].thumbnail_large,\n                        thumb: json[0].thumbnail_small\n                    }, dataFrame.i, fotorama);\n                }\n            });\n        } else {\n            dataFrame.thumbsReady = true;\n        }\n\n        return {\n            img: img,\n            thumb: thumb\n        }\n    }\n\n    function updateData(data, _dataFrame, i, fotorama) {\n        for (var _i = 0, _l = data.length; _i < _l; _i++) {\n            var dataFrame = data[_i];\n\n            if (dataFrame.i === i && dataFrame.thumbsReady) {\n                var clear = {videoReady: true};\n                clear[STAGE_FRAME_KEY] = clear[NAV_THUMB_FRAME_KEY] = clear[NAV_DOT_FRAME_KEY] = false;\n\n                fotorama.splice(_i, 1, $.extend(\n                    {},\n                    dataFrame,\n                    clear,\n                    _dataFrame\n                ));\n\n                break;\n            }\n        }\n    }\n\n    function getDataFromHtml($el) {\n        var data = [];\n\n        function getDataFromImg($img, imgData, checkVideo) {\n            var $child = $img.children('img').eq(0),\n                _imgHref = $img.attr('href'),\n                _imgSrc = $img.attr('src'),\n                _thumbSrc = $child.attr('src'),\n                _video = imgData.video,\n                video = checkVideo ? findVideoId(_imgHref, _video === true) : false;\n\n            if (video) {\n                _imgHref = false;\n            } else {\n                video = _video;\n            }\n\n            getDimensions($img, $child, $.extend(imgData, {\n                video: video,\n                img: imgData.img || _imgHref || _imgSrc || _thumbSrc,\n                thumb: imgData.thumb || _thumbSrc || _imgSrc || _imgHref\n            }));\n        }\n\n        function getDimensions($img, $child, imgData) {\n            var separateThumbFLAG = imgData.thumb && imgData.img !== imgData.thumb,\n                width = numberFromMeasure(imgData.width || $img.attr('width')),\n                height = numberFromMeasure(imgData.height || $img.attr('height'));\n\n            $.extend(imgData, {\n                width: width,\n                height: height,\n                thumbratio: getRatio(imgData.thumbratio || (numberFromMeasure(imgData.thumbwidth || ($child && $child.attr('width')) || separateThumbFLAG || width) / numberFromMeasure(imgData.thumbheight || ($child && $child.attr('height')) || separateThumbFLAG || height)))\n            });\n        }\n\n        $el.children().each(function () {\n            var $this = $(this),\n                dataFrame = optionsToLowerCase($.extend($this.data(), {id: $this.attr('id')}));\n            if ($this.is('a, img')) {\n                getDataFromImg($this, dataFrame, true);\n            } else if (!$this.is(':empty')) {\n                getDimensions($this, null, $.extend(dataFrame, {\n                    html: this,\n                    _html: $this.html() // Because of IE\n                }));\n            } else return;\n\n            data.push(dataFrame);\n        });\n\n        return data;\n    }\n\n    function isHidden(el) {\n        return el.offsetWidth === 0 && el.offsetHeight === 0;\n    }\n\n    function isDetached(el) {\n        return !$.contains(document.documentElement, el);\n    }\n\n    function waitFor(test, fn, timeout, i) {\n        if (!waitFor.i) {\n            waitFor.i = 1;\n            waitFor.ii = [true];\n        }\n\n        i = i || waitFor.i;\n\n        if (typeof waitFor.ii[i] === 'undefined') {\n            waitFor.ii[i] = true;\n        }\n\n        if (test()) {\n            fn();\n        } else {\n            waitFor.ii[i] && setTimeout(function () {\n                waitFor.ii[i] && waitFor(test, fn, timeout, i);\n            }, timeout || 100);\n        }\n\n        return waitFor.i++;\n    }\n\n    waitFor.stop = function (i) {\n        waitFor.ii[i] = false;\n    };\n\n    function fit($el, measuresToFit) {\n        var elData = $el.data(),\n            measures = elData.measures;\n\n        if (measures && (!elData.l ||\n            elData.l.W !== measures.width ||\n            elData.l.H !== measures.height ||\n            elData.l.r !== measures.ratio ||\n            elData.l.w !== measuresToFit.w ||\n            elData.l.h !== measuresToFit.h)) {\n\n            var height = minMaxLimit(measuresToFit.h, 0, measures.height),\n                width = height * measures.ratio;\n\n            UTIL.setRatio($el, width, height);\n\n            elData.l = {\n                W: measures.width,\n                H: measures.height,\n                r: measures.ratio,\n                w: measuresToFit.w,\n                h: measuresToFit.h\n            };\n        }\n\n        return true;\n    }\n\n    function setStyle($el, style) {\n        var el = $el[0];\n        if (el.styleSheet) {\n            el.styleSheet.cssText = style;\n        } else {\n            $el.html(style);\n        }\n    }\n\n    function findShadowEdge(pos, min, max, dir) {\n        return min === max ? false :\n            dir === 'vertical' ?\n                (pos <= min ? 'top' : pos >= max ? 'bottom' : 'top bottom') :\n                (pos <= min ? 'left' : pos >= max ? 'right' : 'left right');\n    }\n\n    function smartClick($el, fn, _options) {\n        _options = _options || {};\n\n        $el.each(function () {\n            var $this = $(this),\n                thisData = $this.data(),\n                startEvent;\n\n            if (thisData.clickOn) return;\n\n            thisData.clickOn = true;\n\n            $.extend(touch($this, {\n                onStart: function (e) {\n                    startEvent = e;\n                    (_options.onStart || noop).call(this, e);\n                },\n                onMove: _options.onMove || noop,\n                onTouchEnd: _options.onTouchEnd || noop,\n                onEnd: function (result) {\n                    if (result.moved) return;\n                    fn.call(this, startEvent);\n                }\n            }), {noMove: true});\n        });\n    }\n\n    function div(classes, child) {\n        return '<div class=\"' + classes + '\">' + (child || '') + '</div>';\n    }\n\n\n    /**\n     * Function transforming into valid classname\n     * @param className - name of the class\n     * @returns {string} - dom format of class name\n     */\n    function cls(className) {\n        return \".\" + className;\n    }\n\n    /**\n     *\n     * @param {json-object} videoItem Parsed object from data.video item or href from link a in input dates\n     * @returns {string} DOM view of video iframe\n     */\n    function createVideoFrame(videoItem) {\n        var frame = '<iframe src=\"' + videoItem.p + videoItem.type + '.com/embed/' + videoItem.id + '\" frameborder=\"0\" allowfullscreen></iframe>';\n        return frame;\n    }\n\n// Fisher\u2013Yates Shuffle\n// http://bost.ocks.org/mike/shuffle/\n    function shuffle(array) {\n        // While there remain elements to shuffle\n        var l = array.length;\n        while (l) {\n            // Pick a remaining element\n            var i = Math.floor(Math.random() * l--);\n\n            // And swap it with the current element\n            var t = array[l];\n            array[l] = array[i];\n            array[i] = t;\n        }\n\n        return array;\n    }\n\n    function clone(array) {\n        return Object.prototype.toString.call(array) == '[object Array]'\n            && $.map(array, function (frame) {\n                return $.extend({}, frame);\n            });\n    }\n\n    function lockScroll($el, left, top) {\n        $el\n            .scrollLeft(left || 0)\n            .scrollTop(top || 0);\n    }\n\n    function optionsToLowerCase(options) {\n        if (options) {\n            var opts = {};\n            $.each(options, function (key, value) {\n                opts[key.toLowerCase()] = value;\n            });\n\n            return opts;\n        }\n    }\n\n    function getRatio(_ratio) {\n        if (!_ratio) return;\n        var ratio = +_ratio;\n        if (!isNaN(ratio)) {\n            return ratio;\n        } else {\n            ratio = _ratio.split('/');\n            return +ratio[0] / +ratio[1] || undefined;\n        }\n    }\n\n    function addEvent(el, e, fn, bool) {\n        if (!e) return;\n        el.addEventListener ? el.addEventListener(e, fn, !!bool) : el.attachEvent('on' + e, fn);\n    }\n\n    /**\n     *\n     * @param position guess position for navShaft\n     * @param restriction object contains min and max values for position\n     * @returns {*} filtered value of position\n     */\n    function validateRestrictions(position, restriction) {\n        if (position > restriction.max) {\n            position = restriction.max;\n        } else {\n            if (position < restriction.min) {\n                position = restriction.min;\n            }\n        }\n        return position;\n    }\n\n    function validateSlidePos(opt, navShaftTouchTail, guessIndex, offsetNav, $guessNavFrame, $navWrap, dir) {\n        var position,\n            size,\n            wrapSize;\n        if (dir === 'horizontal') {\n            size = opt.thumbwidth;\n            wrapSize = $navWrap.width();\n        } else {\n            size = opt.thumbheight;\n            wrapSize = $navWrap.height();\n        }\n        if ( (size + opt.margin) * (guessIndex + 1) >= (wrapSize - offsetNav) ) {\n            if (dir === 'horizontal') {\n                position = -$guessNavFrame.position().left;\n            } else {\n                position = -$guessNavFrame.position().top;\n            }\n        } else {\n            if ((size + opt.margin) * (guessIndex) <= Math.abs(offsetNav)) {\n                if (dir === 'horizontal') {\n                    position = -$guessNavFrame.position().left + wrapSize - (size + opt.margin);\n                } else {\n                    position = -$guessNavFrame.position().top + wrapSize - (size + opt.margin);\n                }\n            } else {\n                position = offsetNav;\n            }\n        }\n        position = validateRestrictions(position, navShaftTouchTail);\n\n        return position || 0;\n    }\n\n    function elIsDisabled(el) {\n        return !!el.getAttribute('disabled');\n    }\n\n    function disableAttr(FLAG, disable) {\n        if (disable) {\n            return {disabled: FLAG};\n        } else {\n            return {tabindex: FLAG * -1 + '', disabled: FLAG};\n\n        }\n    }\n\n    function addEnterUp(el, fn) {\n        addEvent(el, 'keyup', function (e) {\n            elIsDisabled(el) || e.keyCode == 13 && fn.call(el, e);\n        });\n    }\n\n    function addFocus(el, fn) {\n        addEvent(el, 'focus', el.onfocusin = function (e) {\n            fn.call(el, e);\n        }, true);\n    }\n\n    function stopEvent(e, stopPropagation) {\n        e.preventDefault ? e.preventDefault() : (e.returnValue = false);\n        stopPropagation && e.stopPropagation && e.stopPropagation();\n    }\n\n    function stubEvent($el, eventType) {\n        $el.on(eventType, function (e) {\n            stopEvent(e, true);\n\n            return false;\n        });\n    }\n\n    function getDirectionSign(forward) {\n        return forward ? '>' : '<';\n    }\n\n    var UTIL = (function () {\n\n        function setRatioClass($el, wh, ht) {\n            var rateImg = wh / ht;\n\n            if (rateImg <= 1) {\n                $el.parent().removeClass(horizontalImageClass);\n                $el.parent().addClass(verticalImageClass);\n            } else {\n                $el.parent().removeClass(verticalImageClass);\n                $el.parent().addClass(horizontalImageClass);\n            }\n        }\n\n        /**\n         * Set specific attribute in thumbnail template\n         * @param $frame DOM item of specific thumbnail\n         * @param value Value which must be setted into specific attribute\n         * @param searchAttr Name of attribute where value must be included\n         */\n        function setThumbAttr($frame, value, searchAttr) {\n            var attr = searchAttr;\n\n            if (!$frame.attr(attr) && $frame.attr(attr) !== undefined) {\n                $frame.attr(attr, value);\n            }\n\n            if ($frame.find(\"[\" + attr + \"]\").length) {\n                $frame.find(\"[\" + attr + \"]\")\n                    .each(function () {\n                        $(this).attr(attr, value);\n                    });\n            }\n        }\n\n        /**\n         * Method describe behavior need to render caption on preview or not\n         * @param frameItem specific item from data\n         * @param isExpected {bool} if items with caption need render them or not\n         * @returns {boolean} if true then caption should be rendered\n         */\n        function isExpectedCaption(frameItem, isExpected, undefined) {\n            var expected = false,\n                frameExpected;\n\n            frameItem.showCaption === undefined || frameItem.showCaption === true ? frameExpected = true : frameExpected = false;\n\n            if (!isExpected) {\n                return false;\n            }\n\n            if (frameItem.caption && frameExpected) {\n                expected = true;\n            }\n\n            return expected;\n        }\n\n        return {\n            setRatio: setRatioClass,\n            setThumbAttr: setThumbAttr,\n            isExpectedCaption: isExpectedCaption\n        };\n\n    }(UTIL || {}, jQuery));\n\n    function slide($el, options) {\n        var elData = $el.data(),\n            elPos = Math.round(options.pos),\n            onEndFn = function () {\n                if (elData && elData.sliding) {\n                    elData.sliding = false;\n                }\n                (options.onEnd || noop)();\n            };\n\n        if (typeof options.overPos !== 'undefined' && options.overPos !== options.pos) {\n            elPos = options.overPos;\n        }\n\n        var translate = $.extend(getTranslate(elPos, options.direction), options.width && {width: options.width}, options.height && {height: options.height});\n        if (elData && elData.sliding) {\n            elData.sliding = true;\n        }\n\n        if (CSS3) {\n            $el.css($.extend(getDuration(options.time), translate));\n\n            if (options.time > 10) {\n                afterTransition($el, 'transform', onEndFn, options.time);\n            } else {\n                onEndFn();\n            }\n        } else {\n            $el.stop().animate(translate, options.time, BEZIER, onEndFn);\n        }\n    }\n\n    function fade($el1, $el2, $frames, options, fadeStack, chain) {\n        var chainedFLAG = typeof chain !== 'undefined';\n        if (!chainedFLAG) {\n            fadeStack.push(arguments);\n            Array.prototype.push.call(arguments, fadeStack.length);\n            if (fadeStack.length > 1) return;\n        }\n\n        $el1 = $el1 || $($el1);\n        $el2 = $el2 || $($el2);\n\n        var _$el1 = $el1[0],\n            _$el2 = $el2[0],\n            crossfadeFLAG = options.method === 'crossfade',\n            onEndFn = function () {\n                if (!onEndFn.done) {\n                    onEndFn.done = true;\n                    var args = (chainedFLAG || fadeStack.shift()) && fadeStack.shift();\n                    args && fade.apply(this, args);\n                    (options.onEnd || noop)(!!args);\n                }\n            },\n            time = options.time / (chain || 1);\n\n        $frames.removeClass(fadeRearClass + ' ' + fadeFrontClass);\n\n        $el1\n            .stop()\n            .addClass(fadeRearClass);\n        $el2\n            .stop()\n            .addClass(fadeFrontClass);\n\n        crossfadeFLAG && _$el2 && $el1.fadeTo(0, 0);\n\n        $el1.fadeTo(crossfadeFLAG ? time : 0, 1, crossfadeFLAG && onEndFn);\n        $el2.fadeTo(time, 0, onEndFn);\n\n        (_$el1 && crossfadeFLAG) || _$el2 || onEndFn();\n    }\n\n    var lastEvent,\n        moveEventType,\n        preventEvent,\n        preventEventTimeout,\n        dragDomEl;\n\n    function extendEvent(e) {\n        var touch = (e.touches || [])[0] || e;\n        e._x = touch.pageX || touch.originalEvent.pageX;\n        e._y = touch.clientY || touch.originalEvent.clientY;\n        e._now = $.now();\n    }\n\n    function touch($el, options) {\n        var el = $el[0],\n            tail = {},\n            touchEnabledFLAG,\n            startEvent,\n            $target,\n            controlTouch,\n            touchFLAG,\n            targetIsSelectFLAG,\n            targetIsLinkFlag,\n            tolerance,\n            moved;\n\n        function onStart(e) {\n            $target = $(e.target);\n            tail.checked = targetIsSelectFLAG = targetIsLinkFlag = moved = false;\n\n            if (touchEnabledFLAG\n                || tail.flow\n                || (e.touches && e.touches.length > 1)\n                || e.which > 1\n                || (lastEvent && lastEvent.type !== e.type && preventEvent)\n                || (targetIsSelectFLAG = options.select && $target.is(options.select, el))) return targetIsSelectFLAG;\n\n            touchFLAG = e.type === 'touchstart';\n            targetIsLinkFlag = $target.is('a, a *', el);\n            controlTouch = tail.control;\n\n            tolerance = (tail.noMove || tail.noSwipe || controlTouch) ? 16 : !tail.snap ? 4 : 0;\n\n            extendEvent(e);\n\n            startEvent = lastEvent = e;\n            moveEventType = e.type.replace(/down|start/, 'move').replace(/Down/, 'Move');\n\n            (options.onStart || noop).call(el, e, {control: controlTouch, $target: $target});\n\n            touchEnabledFLAG = tail.flow = true;\n\n            if (!touchFLAG || tail.go) stopEvent(e);\n        }\n\n        function onMove(e) {\n            if ((e.touches && e.touches.length > 1)\n                || (MS_POINTER && !e.isPrimary)\n                || moveEventType !== e.type\n                || !touchEnabledFLAG) {\n                touchEnabledFLAG && onEnd();\n                (options.onTouchEnd || noop)();\n                return;\n            }\n\n            extendEvent(e);\n\n            var xDiff = Math.abs(e._x - startEvent._x), // opt _x \u2192 _pageX\n                yDiff = Math.abs(e._y - startEvent._y),\n                xyDiff = xDiff - yDiff,\n                xWin = (tail.go || tail.x || xyDiff >= 0) && !tail.noSwipe,\n                yWin = xyDiff < 0;\n\n            if (touchFLAG && !tail.checked) {\n                if (touchEnabledFLAG = xWin) {\n                    stopEvent(e);\n                }\n            } else {\n                stopEvent(e);\n                (options.onMove || noop).call(el, e, {touch: touchFLAG});\n            }\n\n            if (!moved && Math.sqrt(Math.pow(xDiff, 2) + Math.pow(yDiff, 2)) > tolerance) {\n                moved = true;\n            }\n\n            tail.checked = tail.checked || xWin || yWin;\n        }\n\n        function onEnd(e) {\n            (options.onTouchEnd || noop)();\n\n            var _touchEnabledFLAG = touchEnabledFLAG;\n            tail.control = touchEnabledFLAG = false;\n\n            if (_touchEnabledFLAG) {\n                tail.flow = false;\n            }\n\n            if (!_touchEnabledFLAG || (targetIsLinkFlag && !tail.checked)) return;\n\n            e && stopEvent(e);\n\n            preventEvent = true;\n            clearTimeout(preventEventTimeout);\n            preventEventTimeout = setTimeout(function () {\n                preventEvent = false;\n            }, 1000);\n\n            (options.onEnd || noop).call(el, {\n                moved: moved,\n                $target: $target,\n                control: controlTouch,\n                touch: touchFLAG,\n                startEvent: startEvent,\n                aborted: !e || e.type === 'MSPointerCancel'\n            });\n        }\n\n        function onOtherStart() {\n            if (tail.flow) return;\n            tail.flow = true;\n        }\n\n        function onOtherEnd() {\n            if (!tail.flow) return;\n            tail.flow = false;\n        }\n\n        if (MS_POINTER) {\n            addEvent(el, 'MSPointerDown', onStart);\n            addEvent(document, 'MSPointerMove', onMove);\n            addEvent(document, 'MSPointerCancel', onEnd);\n            addEvent(document, 'MSPointerUp', onEnd);\n        } else {\n            addEvent(el, 'touchstart', onStart);\n            addEvent(el, 'touchmove', onMove);\n            addEvent(el, 'touchend', onEnd);\n\n            addEvent(document, 'touchstart', onOtherStart);\n            addEvent(document, 'touchend', onOtherEnd);\n            addEvent(document, 'touchcancel', onOtherEnd);\n\n            $WINDOW.on('scroll', onOtherEnd);\n\n            $el.on('mousedown pointerdown', onStart);\n            $DOCUMENT\n                .on('mousemove pointermove', onMove)\n                .on('mouseup pointerup', onEnd);\n        }\n        if (Modernizr.touch) {\n            dragDomEl = 'a';\n        } else {\n            dragDomEl = 'div';\n        }\n        $el.on('click', dragDomEl, function (e) {\n            tail.checked && stopEvent(e);\n        });\n\n        return tail;\n    }\n\n    function moveOnTouch($el, options) {\n        var el = $el[0],\n            elData = $el.data(),\n            tail = {},\n            startCoo,\n            coo,\n            startElPos,\n            moveElPos,\n            edge,\n            moveTrack,\n            startTime,\n            endTime,\n            min,\n            max,\n            snap,\n            dir,\n            slowFLAG,\n            controlFLAG,\n            moved,\n            tracked;\n\n        function startTracking(e, noStop) {\n            tracked = true;\n            startCoo = coo = (dir === 'vertical') ? e._y : e._x;\n            startTime = e._now;\n\n            moveTrack = [\n                [startTime, startCoo]\n            ];\n\n            startElPos = moveElPos = tail.noMove || noStop ? 0 : stop($el, (options.getPos || noop)()/*, options._001*/);\n\n            (options.onStart || noop).call(el, e);\n        }\n\n        function onStart(e, result) {\n            min = tail.min;\n            max = tail.max;\n            snap = tail.snap,\n                dir = tail.direction || 'horizontal',\n                $el.navdir = dir;\n\n            slowFLAG = e.altKey;\n            tracked = moved = false;\n\n            controlFLAG = result.control;\n\n            if (!controlFLAG && !elData.sliding) {\n                startTracking(e);\n            }\n        }\n\n        function onMove(e, result) {\n            if (!tail.noSwipe) {\n                if (!tracked) {\n                    startTracking(e);\n                }\n                coo = (dir === 'vertical') ? e._y : e._x;\n\n                moveTrack.push([e._now, coo]);\n\n                moveElPos = startElPos - (startCoo - coo);\n\n                edge = findShadowEdge(moveElPos, min, max, dir);\n\n                if (moveElPos <= min) {\n                    moveElPos = edgeResistance(moveElPos, min);\n                } else if (moveElPos >= max) {\n                    moveElPos = edgeResistance(moveElPos, max);\n                }\n\n                if (!tail.noMove) {\n                    $el.css(getTranslate(moveElPos, dir));\n                    if (!moved) {\n                        moved = true;\n                        // only for mouse\n                        result.touch || MS_POINTER || $el.addClass(grabbingClass);\n                    }\n\n                    (options.onMove || noop).call(el, e, {pos: moveElPos, edge: edge});\n                }\n            }\n        }\n\n        function onEnd(result) {\n            if (tail.noSwipe && result.moved) return;\n\n            if (!tracked) {\n                startTracking(result.startEvent, true);\n            }\n\n            result.touch || MS_POINTER || $el.removeClass(grabbingClass);\n\n            endTime = $.now();\n\n            var _backTimeIdeal = endTime - TOUCH_TIMEOUT,\n                _backTime,\n                _timeDiff,\n                _timeDiffLast,\n                backTime = null,\n                backCoo,\n                virtualPos,\n                limitPos,\n                newPos,\n                overPos,\n                time = TRANSITION_DURATION,\n                speed,\n                friction = options.friction;\n\n            for (var _i = moveTrack.length - 1; _i >= 0; _i--) {\n                _backTime = moveTrack[_i][0];\n                _timeDiff = Math.abs(_backTime - _backTimeIdeal);\n                if (backTime === null || _timeDiff < _timeDiffLast) {\n                    backTime = _backTime;\n                    backCoo = moveTrack[_i][1];\n                } else if (backTime === _backTimeIdeal || _timeDiff > _timeDiffLast) {\n                    break;\n                }\n                _timeDiffLast = _timeDiff;\n            }\n\n            newPos = minMaxLimit(moveElPos, min, max);\n\n            var cooDiff = backCoo - coo,\n                forwardFLAG = cooDiff >= 0,\n                timeDiff = endTime - backTime,\n                longTouchFLAG = timeDiff > TOUCH_TIMEOUT,\n                swipeFLAG = !longTouchFLAG && moveElPos !== startElPos && newPos === moveElPos;\n\n            if (snap) {\n                newPos = minMaxLimit(Math[swipeFLAG ? (forwardFLAG ? 'floor' : 'ceil') : 'round'](moveElPos / snap) * snap, min, max);\n                min = max = newPos;\n            }\n\n            if (swipeFLAG && (snap || newPos === moveElPos)) {\n                speed = -(cooDiff / timeDiff);\n                time *= minMaxLimit(Math.abs(speed), options.timeLow, options.timeHigh);\n                virtualPos = Math.round(moveElPos + speed * time / friction);\n\n                if (!snap) {\n                    newPos = virtualPos;\n                }\n\n                if (!forwardFLAG && virtualPos > max || forwardFLAG && virtualPos < min) {\n                    limitPos = forwardFLAG ? min : max;\n                    overPos = virtualPos - limitPos;\n                    if (!snap) {\n                        newPos = limitPos;\n                    }\n                    overPos = minMaxLimit(newPos + overPos * .03, limitPos - 50, limitPos + 50);\n                    time = Math.abs((moveElPos - overPos) / (speed / friction));\n                }\n            }\n\n            time *= slowFLAG ? 10 : 1;\n\n            (options.onEnd || noop).call(el, $.extend(result, {\n                moved: result.moved || longTouchFLAG && snap,\n                pos: moveElPos,\n                newPos: newPos,\n                overPos: overPos,\n                time: time,\n                dir: dir\n            }));\n        }\n\n        tail = $.extend(touch(options.$wrap, $.extend({}, options, {\n            onStart: onStart,\n            onMove: onMove,\n            onEnd: onEnd\n        })), tail);\n\n        return tail;\n    }\n\n    function wheel($el, options) {\n        var el = $el[0],\n            lockFLAG,\n            lastDirection,\n            lastNow,\n            tail = {\n                prevent: {}\n            };\n\n        addEvent(el, WHEEL, function (e) {\n            var yDelta = e.wheelDeltaY || -1 * e.deltaY || 0,\n                xDelta = e.wheelDeltaX || -1 * e.deltaX || 0,\n                xWin = Math.abs(xDelta) && !Math.abs(yDelta),\n                direction = getDirectionSign(xDelta < 0),\n                sameDirection = lastDirection === direction,\n                now = $.now(),\n                tooFast = now - lastNow < TOUCH_TIMEOUT;\n\n            lastDirection = direction;\n            lastNow = now;\n\n            if (!xWin || !tail.ok || tail.prevent[direction] && !lockFLAG) {\n                return;\n            } else {\n                stopEvent(e, true);\n                if (lockFLAG && sameDirection && tooFast) {\n                    return;\n                }\n            }\n\n            if (options.shift) {\n                lockFLAG = true;\n                clearTimeout(tail.t);\n                tail.t = setTimeout(function () {\n                    lockFLAG = false;\n                }, SCROLL_LOCK_TIMEOUT);\n            }\n\n            (options.onEnd || noop)(e, options.shift ? direction : xDelta);\n\n        });\n\n        return tail;\n    }\n\n    jQuery.Fotorama = function ($fotorama, opts) {\n        $HTML = $('html');\n        $BODY = $('body');\n\n        var that = this,\n            stamp = $.now(),\n            stampClass = _fotoramaClass + stamp,\n            fotorama = $fotorama[0],\n            data,\n            dataFrameCount = 1,\n            fotoramaData = $fotorama.data(),\n            size,\n\n            $style = $('<style></style>'),\n\n            $anchor = $(div(hiddenClass)),\n            $wrap = $fotorama.find(cls(wrapClass)),\n            $stage = $wrap.find(cls(stageClass)),\n            stage = $stage[0],\n\n            $stageShaft = $fotorama.find(cls(stageShaftClass)),\n            $stageFrame = $(),\n            $arrPrev = $fotorama.find(cls(arrPrevClass)),\n            $arrNext = $fotorama.find(cls(arrNextClass)),\n            $arrs = $fotorama.find(cls(arrClass)),\n            $navWrap = $fotorama.find(cls(navWrapClass)),\n            $nav = $navWrap.find(cls(navClass)),\n            $navShaft = $nav.find(cls(navShaftClass)),\n            $navFrame,\n            $navDotFrame = $(),\n            $navThumbFrame = $(),\n\n            stageShaftData = $stageShaft.data(),\n            navShaftData = $navShaft.data(),\n\n            $thumbBorder = $fotorama.find(cls(thumbBorderClass)),\n            $thumbArrLeft = $fotorama.find(cls(thumbArrLeft)),\n            $thumbArrRight = $fotorama.find(cls(thumbArrRight)),\n\n            $fullscreenIcon = $fotorama.find(cls(fullscreenIconClass)),\n            fullscreenIcon = $fullscreenIcon[0],\n            $videoPlay = $(div(videoPlayClass)),\n            $videoClose = $fotorama.find(cls(videoCloseClass)),\n            videoClose = $videoClose[0],\n\n            $spinner = $fotorama.find(cls(fotoramaSpinnerClass)),\n\n            $videoPlaying,\n\n            activeIndex = false,\n            activeFrame,\n            activeIndexes,\n            repositionIndex,\n            dirtyIndex,\n            lastActiveIndex,\n            prevIndex,\n            nextIndex,\n            nextAutoplayIndex,\n            startIndex,\n\n            o_loop,\n            o_nav,\n            o_navThumbs,\n            o_navTop,\n            o_allowFullScreen,\n            o_nativeFullScreen,\n            o_fade,\n            o_thumbSide,\n            o_thumbSide2,\n            o_transitionDuration,\n            o_transition,\n            o_shadows,\n            o_rtl,\n            o_keyboard,\n            lastOptions = {},\n\n            measures = {},\n            measuresSetFLAG,\n\n            stageShaftTouchTail = {},\n            stageWheelTail = {},\n            navShaftTouchTail = {},\n            navWheelTail = {},\n\n            scrollTop,\n            scrollLeft,\n\n            showedFLAG,\n            pausedAutoplayFLAG,\n            stoppedAutoplayFLAG,\n\n            toDeactivate = {},\n            toDetach = {},\n\n            measuresStash,\n\n            touchedFLAG,\n\n            hoverFLAG,\n\n            navFrameKey,\n            stageLeft = 0,\n\n            fadeStack = [];\n\n        $wrap[STAGE_FRAME_KEY] = $('<div class=\"' + stageFrameClass + '\"></div>');\n        $wrap[NAV_THUMB_FRAME_KEY] = $($.Fotorama.jst.thumb());\n        $wrap[NAV_DOT_FRAME_KEY] = $($.Fotorama.jst.dots());\n\n        toDeactivate[STAGE_FRAME_KEY] = [];\n        toDeactivate[NAV_THUMB_FRAME_KEY] = [];\n        toDeactivate[NAV_DOT_FRAME_KEY] = [];\n        toDetach[STAGE_FRAME_KEY] = {};\n\n        $wrap.addClass(CSS3 ? wrapCss3Class : wrapCss2Class);\n\n        fotoramaData.fotorama = this;\n\n        /**\n         * Search video items in incomming data and transform object for video layout.\n         *\n         */\n        function checkForVideo() {\n            $.each(data, function (i, dataFrame) {\n                if (!dataFrame.i) {\n                    dataFrame.i = dataFrameCount++;\n                    var video = findVideoId(dataFrame.video, true);\n                    if (video) {\n                        var thumbs = {};\n                        dataFrame.video = video;\n                        if (!dataFrame.img && !dataFrame.thumb) {\n                            thumbs = getVideoThumbs(dataFrame, data, that);\n                        } else {\n                            dataFrame.thumbsReady = true;\n                        }\n                        updateData(data, {img: thumbs.img, thumb: thumbs.thumb}, dataFrame.i, that);\n                    }\n                }\n            });\n        }\n\n        function allowKey(key) {\n            return o_keyboard[key];\n        }\n\n        function setStagePosition() {\n            if ($stage !== undefined) {\n\n                if (opts.navdir == 'vertical') {\n                    var padding = opts.thumbwidth + opts.thumbmargin;\n\n                    $stage.css('left', padding);\n                    $arrNext.css('right', padding);\n                    $fullscreenIcon.css('right', padding);\n                    $wrap.css('width', $wrap.css('width') + padding);\n                    $stageShaft.css('max-width', $wrap.width() - padding);\n                } else {\n                    $stage.css('left', '');\n                    $arrNext.css('right', '');\n                    $fullscreenIcon.css('right', '');\n                    $wrap.css('width', $wrap.css('width') + padding);\n                    $stageShaft.css('max-width', '');\n                }\n            }\n        }\n\n        function bindGlobalEvents(FLAG) {\n            var keydownCommon = 'keydown.' + _fotoramaClass,\n                localStamp = _fotoramaClass + stamp,\n                keydownLocal = 'keydown.' + localStamp,\n                keyupLocal = 'keyup.' + localStamp,\n                resizeLocal = 'resize.' + localStamp + ' ' + 'orientationchange.' + localStamp,\n                showParams;\n\n            if (FLAG) {\n                $DOCUMENT\n                    .on(keydownLocal, function (e) {\n                        var catched,\n                            index;\n\n                        if ($videoPlaying && e.keyCode === 27) {\n                            catched = true;\n                            unloadVideo($videoPlaying, true, true);\n                        } else if (that.fullScreen || (opts.keyboard && !that.index)) {\n                            if (e.keyCode === 27) {\n                                catched = true;\n                                that.cancelFullScreen();\n                            } else if ((e.shiftKey && e.keyCode === 32 && allowKey('space')) || (e.keyCode === 37 && allowKey('left')) || (e.keyCode === 38 && allowKey('up') && $(':focus').attr('data-gallery-role'))) {\n                                that.longPress.progress();\n                                index = '<';\n                            } else if ((e.keyCode === 32 && allowKey('space')) || (e.keyCode === 39 && allowKey('right')) || (e.keyCode === 40 && allowKey('down') && $(':focus').attr('data-gallery-role'))) {\n                                that.longPress.progress();\n                                index = '>';\n                            } else if (e.keyCode === 36 && allowKey('home')) {\n                                that.longPress.progress();\n                                index = '<<';\n                            } else if (e.keyCode === 35 && allowKey('end')) {\n                                that.longPress.progress();\n                                index = '>>';\n                            }\n                        }\n\n                        (catched || index) && stopEvent(e);\n                        showParams = {index: index, slow: e.altKey, user: true};\n                        index && (that.longPress.inProgress ?\n                            that.showWhileLongPress(showParams) :\n                            that.show(showParams));\n                    });\n\n                if (FLAG) {\n                    $DOCUMENT\n                        .on(keyupLocal, function (e) {\n                            if (that.longPress.inProgress) {\n                                that.showEndLongPress({user: true});\n                            }\n                            that.longPress.reset();\n                        });\n                }\n\n                if (!that.index) {\n                    $DOCUMENT\n                        .off(keydownCommon)\n                        .on(keydownCommon, 'textarea, input, select', function (e) {\n                            !$BODY.hasClass(_fullscreenClass) && e.stopPropagation();\n                        });\n                }\n\n                $WINDOW.on(resizeLocal, that.resize);\n            } else {\n                $DOCUMENT.off(keydownLocal);\n                $WINDOW.off(resizeLocal);\n            }\n        }\n\n        function appendElements(FLAG) {\n            if (FLAG === appendElements.f) return;\n\n            if (FLAG) {\n                $fotorama\n                    .addClass(_fotoramaClass + ' ' + stampClass)\n                    .before($anchor)\n                    .before($style);\n                addInstance(that);\n            } else {\n                $anchor.detach();\n                $style.detach();\n                $fotorama\n                    .html(fotoramaData.urtext)\n                    .removeClass(stampClass);\n\n                hideInstance(that);\n            }\n\n            bindGlobalEvents(FLAG);\n            appendElements.f = FLAG;\n        }\n\n        /**\n         * Set and install data from incomming @param {JSON} options or takes data attr from data-\"name\"=... values.\n         */\n        function setData() {\n            data = that.data = data || clone(opts.data) || getDataFromHtml($fotorama);\n            size = that.size = data.length;\n\n            ready.ok && opts.shuffle && shuffle(data);\n\n            checkForVideo();\n\n            activeIndex = limitIndex(activeIndex);\n\n            size && appendElements(true);\n        }\n\n        function stageNoMove() {\n            var _noMove = size < 2 || $videoPlaying;\n            stageShaftTouchTail.noMove = _noMove || o_fade;\n            stageShaftTouchTail.noSwipe = _noMove || !opts.swipe;\n\n            !o_transition && $stageShaft.toggleClass(grabClass, !opts.click && !stageShaftTouchTail.noMove && !stageShaftTouchTail.noSwipe);\n            MS_POINTER && $wrap.toggleClass(wrapPanYClass, !stageShaftTouchTail.noSwipe);\n        }\n\n        function setAutoplayInterval(interval) {\n            if (interval === true) interval = '';\n            opts.autoplay = Math.max(+interval || AUTOPLAY_INTERVAL, o_transitionDuration * 1.5);\n        }\n\n        function updateThumbArrow(opt) {\n            if (opt.navarrows && opt.nav === 'thumbs') {\n                $thumbArrLeft.show();\n                $thumbArrRight.show();\n            } else {\n                $thumbArrLeft.hide();\n                $thumbArrRight.hide();\n            }\n\n        }\n\n        function getThumbsInSlide($el, opts) {\n            return Math.floor($wrap.width() / (opts.thumbwidth + opts.thumbmargin));\n        }\n\n        /**\n         * Options on the fly\n         * */\n        function setOptions() {\n            if (!opts.nav || opts.nav === 'dots') {\n                opts.navdir = 'horizontal'\n            }\n\n            that.options = opts = optionsToLowerCase(opts);\n            thumbsPerSlide = getThumbsInSlide($wrap, opts);\n\n            o_fade = (opts.transition === 'crossfade' || opts.transition === 'dissolve');\n\n            o_loop = opts.loop && (size > 2 || (o_fade && (!o_transition || o_transition !== 'slide')));\n\n            o_transitionDuration = +opts.transitionduration || TRANSITION_DURATION;\n\n            o_rtl = opts.direction === 'rtl';\n\n            o_keyboard = $.extend({}, opts.keyboard && KEYBOARD_OPTIONS, opts.keyboard);\n            updateThumbArrow(opts);\n            var classes = {add: [], remove: []};\n\n            function addOrRemoveClass(FLAG, value) {\n                classes[FLAG ? 'add' : 'remove'].push(value);\n            }\n\n            if (size > 1) {\n                o_nav = opts.nav;\n                o_navTop = opts.navposition === 'top';\n                classes.remove.push(selectClass);\n\n                $arrs.toggle(opts.arrows);\n            } else {\n                o_nav = false;\n                $arrs.hide();\n            }\n\n            arrsUpdate();\n            stageWheelUpdate();\n            thumbArrUpdate();\n            if (opts.autoplay) setAutoplayInterval(opts.autoplay);\n\n            o_thumbSide = numberFromMeasure(opts.thumbwidth) || THUMB_SIZE;\n            o_thumbSide2 = numberFromMeasure(opts.thumbheight) || THUMB_SIZE;\n\n            stageWheelTail.ok = navWheelTail.ok = opts.trackpad && !SLOW;\n\n            stageNoMove();\n\n            extendMeasures(opts, [measures]);\n\n            o_navThumbs = o_nav === 'thumbs';\n\n            if ($navWrap.filter(':hidden') && !!o_nav) {\n                $navWrap.show();\n            }\n            if (o_navThumbs) {\n                frameDraw(size, 'navThumb');\n\n                $navFrame = $navThumbFrame;\n                navFrameKey = NAV_THUMB_FRAME_KEY;\n\n                setStyle($style, $.Fotorama.jst.style({\n                    w: o_thumbSide,\n                    h: o_thumbSide2,\n                    b: opts.thumbborderwidth,\n                    m: opts.thumbmargin,\n                    s: stamp,\n                    q: !COMPAT\n                }));\n\n                $nav\n                    .addClass(navThumbsClass)\n                    .removeClass(navDotsClass);\n            } else if (o_nav === 'dots') {\n                frameDraw(size, 'navDot');\n\n                $navFrame = $navDotFrame;\n                navFrameKey = NAV_DOT_FRAME_KEY;\n\n                $nav\n                    .addClass(navDotsClass)\n                    .removeClass(navThumbsClass);\n            } else {\n                $navWrap.hide();\n                o_nav = false;\n                $nav.removeClass(navThumbsClass + ' ' + navDotsClass);\n            }\n\n            if (o_nav) {\n                if (o_navTop) {\n                    $navWrap.insertBefore($stage);\n                } else {\n                    $navWrap.insertAfter($stage);\n                }\n                frameAppend.nav = false;\n\n                frameAppend($navFrame, $navShaft, 'nav');\n            }\n\n            o_allowFullScreen = opts.allowfullscreen;\n\n            if (o_allowFullScreen) {\n                $fullscreenIcon.prependTo($stage);\n                o_nativeFullScreen = FULLSCREEN && o_allowFullScreen === 'native';\n\n                // Due 300ms click delay on mobile devices\n                // we stub touchend and fallback to click.\n                // MAGETWO-69567\n                stubEvent($fullscreenIcon, 'touchend');\n            } else {\n                $fullscreenIcon.detach();\n                o_nativeFullScreen = false;\n            }\n\n            addOrRemoveClass(o_fade, wrapFadeClass);\n            addOrRemoveClass(!o_fade, wrapSlideClass);\n            addOrRemoveClass(!opts.captions, wrapNoCaptionsClass);\n            addOrRemoveClass(o_rtl, wrapRtlClass);\n            addOrRemoveClass(opts.arrows, wrapToggleArrowsClass);\n\n            o_shadows = opts.shadows && !SLOW;\n            addOrRemoveClass(!o_shadows, wrapNoShadowsClass);\n\n            $wrap\n                .addClass(classes.add.join(' '))\n                .removeClass(classes.remove.join(' '));\n\n            lastOptions = $.extend({}, opts);\n            setStagePosition();\n        }\n\n        function normalizeIndex(index) {\n            return index < 0 ? (size + (index % size)) % size : index >= size ? index % size : index;\n        }\n\n        function limitIndex(index) {\n            return minMaxLimit(index, 0, size - 1);\n        }\n\n        function edgeIndex(index) {\n            return o_loop ? normalizeIndex(index) : limitIndex(index);\n        }\n\n        function getPrevIndex(index) {\n            return index > 0 || o_loop ? index - 1 : false;\n        }\n\n        function getNextIndex(index) {\n            return index < size - 1 || o_loop ? index + 1 : false;\n        }\n\n        function setStageShaftMinmaxAndSnap() {\n            stageShaftTouchTail.min = o_loop ? -Infinity : -getPosByIndex(size - 1, measures.w, opts.margin, repositionIndex);\n            stageShaftTouchTail.max = o_loop ? Infinity : -getPosByIndex(0, measures.w, opts.margin, repositionIndex);\n            stageShaftTouchTail.snap = measures.w + opts.margin;\n        }\n\n        function setNavShaftMinMax() {\n\n            var isVerticalDir = (opts.navdir === 'vertical');\n            var param = isVerticalDir ? $navShaft.height() : $navShaft.width();\n            var mainParam = isVerticalDir ? measures.h : measures.nw;\n            navShaftTouchTail.min = Math.min(0, mainParam - param);\n            navShaftTouchTail.max = 0;\n            navShaftTouchTail.direction = opts.navdir;\n            $navShaft.toggleClass(grabClass, !(navShaftTouchTail.noMove = navShaftTouchTail.min === navShaftTouchTail.max));\n        }\n\n        function eachIndex(indexes, type, fn) {\n            if (typeof indexes === 'number') {\n                indexes = new Array(indexes);\n                var rangeFLAG = true;\n            }\n            return $.each(indexes, function (i, index) {\n                if (rangeFLAG) index = i;\n                if (typeof index === 'number') {\n                    var dataFrame = data[normalizeIndex(index)];\n\n                    if (dataFrame) {\n                        var key = '$' + type + 'Frame',\n                            $frame = dataFrame[key];\n\n                        fn.call(this, i, index, dataFrame, $frame, key, $frame && $frame.data());\n                    }\n                }\n            });\n        }\n\n        function setMeasures(width, height, ratio, index) {\n            if (!measuresSetFLAG || (measuresSetFLAG === '*' && index === startIndex)) {\n\n                width = measureIsValid(opts.width) || measureIsValid(width) || WIDTH;\n                height = measureIsValid(opts.height) || measureIsValid(height) || HEIGHT;\n                that.resize({\n                    width: width,\n                    ratio: opts.ratio || ratio || width / height\n                }, 0, index !== startIndex && '*');\n            }\n        }\n\n        function loadImg(indexes, type, specialMeasures, again) {\n\n            eachIndex(indexes, type, function (i, index, dataFrame, $frame, key, frameData) {\n\n                if (!$frame) return;\n\n                var fullFLAG = that.fullScreen && !frameData.$full && type === 'stage';\n\n                if (frameData.$img && !again && !fullFLAG) return;\n\n                var img = new Image(),\n                    $img = $(img),\n                    imgData = $img.data();\n\n                frameData[fullFLAG ? '$full' : '$img'] = $img;\n\n                var srcKey = type === 'stage' ? (fullFLAG ? 'full' : 'img') : 'thumb',\n                    src = dataFrame[srcKey],\n                    dummy = fullFLAG ? dataFrame['img'] : dataFrame[type === 'stage' ? 'thumb' : 'img'];\n\n                if (type === 'navThumb') $frame = frameData.$wrap;\n\n                function triggerTriggerEvent(event) {\n                    var _index = normalizeIndex(index);\n                    triggerEvent(event, {\n                        index: _index,\n                        src: src,\n                        frame: data[_index]\n                    });\n                }\n\n                function error() {\n                    $img.remove();\n\n                    $.Fotorama.cache[src] = 'error';\n\n                    if ((!dataFrame.html || type !== 'stage') && dummy && dummy !== src) {\n                        dataFrame[srcKey] = src = dummy;\n                        frameData.$full = null;\n                        loadImg([index], type, specialMeasures, true);\n                    } else {\n                        if (src && !dataFrame.html && !fullFLAG) {\n                            $frame\n                                .trigger('f:error')\n                                .removeClass(loadingClass)\n                                .addClass(errorClass);\n\n                            triggerTriggerEvent('error');\n                        } else if (type === 'stage') {\n                            $frame\n                                .trigger('f:load')\n                                .removeClass(loadingClass + ' ' + errorClass)\n                                .addClass(loadedClass);\n\n                            triggerTriggerEvent('load');\n                            setMeasures();\n                        }\n\n                        frameData.state = 'error';\n\n                        if (size > 1 && data[index] === dataFrame && !dataFrame.html && !dataFrame.deleted && !dataFrame.video && !fullFLAG) {\n                            dataFrame.deleted = true;\n                            that.splice(index, 1);\n                        }\n                    }\n                }\n\n                function loaded() {\n                    $.Fotorama.measures[src] = imgData.measures = $.Fotorama.measures[src] || {\n                            width: img.width,\n                            height: img.height,\n                            ratio: img.width / img.height\n                        };\n\n                    setMeasures(imgData.measures.width, imgData.measures.height, imgData.measures.ratio, index);\n\n                    $img\n                        .off('load error')\n                        .addClass('' + (fullFLAG ? imgFullClass: imgClass))\n                        .attr('aria-hidden', 'false')\n                        .prependTo($frame);\n\n                    if ($frame.hasClass(stageFrameClass) && !$frame.hasClass(videoContainerClass)) {\n                        $frame.attr(\"href\", $img.attr(\"src\"));\n                    }\n\n                    fit($img, (\n                            $.isFunction(specialMeasures) ? specialMeasures() : specialMeasures) || measures);\n\n                    $.Fotorama.cache[src] = frameData.state = 'loaded';\n\n                    setTimeout(function () {\n                        $frame\n                            .trigger('f:load')\n                            .removeClass(loadingClass + ' ' + errorClass)\n                            .addClass(loadedClass + ' ' + (fullFLAG ? loadedFullClass : loadedImgClass));\n\n                        if (type === 'stage') {\n                            triggerTriggerEvent('load');\n                        } else if (dataFrame.thumbratio === AUTO || !dataFrame.thumbratio && opts.thumbratio === AUTO) {\n                            // danger! reflow for all thumbnails\n                            dataFrame.thumbratio = imgData.measures.ratio;\n                            reset();\n                        }\n                    }, 0);\n                }\n\n                if (!src) {\n                    error();\n                    return;\n                }\n\n                function waitAndLoad() {\n                    var _i = 10;\n                    waitFor(function () {\n                        return !touchedFLAG || !_i-- && !SLOW;\n                    }, function () {\n                        loaded();\n                    });\n                }\n\n                if (!$.Fotorama.cache[src]) {\n                    $.Fotorama.cache[src] = '*';\n\n                    $img\n                        .on('load', waitAndLoad)\n                        .on('error', error);\n                } else {\n                    (function justWait() {\n                        if ($.Fotorama.cache[src] === 'error') {\n                            error();\n                        } else if ($.Fotorama.cache[src] === 'loaded') {\n                            setTimeout(waitAndLoad, 0);\n                        } else {\n                            setTimeout(justWait, 100);\n                        }\n                    })();\n                }\n\n                frameData.state = '';\n                img.src = src;\n\n                if (frameData.data.caption) {\n                    img.alt = frameData.data.caption || \"\";\n                }\n\n                if (frameData.data.full) {\n                    $(img).data('original', frameData.data.full);\n                }\n\n                if (UTIL.isExpectedCaption(dataFrame, opts.showcaption)) {\n                    $(img).attr('aria-labelledby', dataFrame.labelledby);\n                }\n            });\n        }\n\n        function updateFotoramaState() {\n            var $frame = activeFrame[STAGE_FRAME_KEY];\n\n            if ($frame && !$frame.data().state) {\n                $spinner.addClass(spinnerShowClass);\n                $frame.on('f:load f:error', function () {\n                    $frame.off('f:load f:error');\n                    $spinner.removeClass(spinnerShowClass);\n                });\n            }\n        }\n\n        function addNavFrameEvents(frame) {\n            addEnterUp(frame, onNavFrameClick);\n            addFocus(frame, function () {\n\n                setTimeout(function () {\n                    lockScroll($nav);\n                }, 0);\n                slideNavShaft({time: o_transitionDuration, guessIndex: $(this).data().eq, minMax: navShaftTouchTail});\n            });\n        }\n\n        function frameDraw(indexes, type) {\n            eachIndex(indexes, type, function (i, index, dataFrame, $frame, key, frameData) {\n                if ($frame) return;\n\n                $frame = dataFrame[key] = $wrap[key].clone();\n                frameData = $frame.data();\n                frameData.data = dataFrame;\n                var frame = $frame[0],\n                    labelledbyValue = \"labelledby\" + $.now();\n\n                if (type === 'stage') {\n\n                    if (dataFrame.html) {\n                        $('<div class=\"' + htmlClass + '\"></div>')\n                            .append(\n                            dataFrame._html ? $(dataFrame.html)\n                                .removeAttr('id')\n                                .html(dataFrame._html) // Because of IE\n                                : dataFrame.html\n                        )\n                            .appendTo($frame);\n                    }\n\n                    if (dataFrame.id) {\n                        labelledbyValue = dataFrame.id || labelledbyValue;\n                    }\n                    dataFrame.labelledby = labelledbyValue;\n\n                    if (UTIL.isExpectedCaption(dataFrame, opts.showcaption)) {\n                        $($.Fotorama.jst.frameCaption({\n                            caption: dataFrame.caption,\n                            labelledby: labelledbyValue\n                        })).appendTo($frame);\n                    }\n\n                    dataFrame.video && $frame\n                        .addClass(stageFrameVideoClass)\n                        .append($videoPlay.clone());\n\n                    // This solves tabbing problems\n                    addFocus(frame, function () {\n                        setTimeout(function () {\n                            lockScroll($stage);\n                        }, 0);\n                        clickToShow({index: frameData.eq, user: true});\n                    });\n\n                    $stageFrame = $stageFrame.add($frame);\n                } else if (type === 'navDot') {\n                    addNavFrameEvents(frame);\n                    $navDotFrame = $navDotFrame.add($frame);\n                } else if (type === 'navThumb') {\n                    addNavFrameEvents(frame);\n                    frameData.$wrap = $frame.children(':first');\n\n                    $navThumbFrame = $navThumbFrame.add($frame);\n                    if (dataFrame.video) {\n                        frameData.$wrap.append($videoPlay.clone());\n                    }\n                }\n            });\n        }\n\n        function callFit($img, measuresToFit) {\n            return $img && $img.length && fit($img, measuresToFit);\n        }\n\n        function stageFramePosition(indexes) {\n            eachIndex(indexes, 'stage', function (i, index, dataFrame, $frame, key, frameData) {\n                if (!$frame) return;\n\n                var normalizedIndex = normalizeIndex(index);\n                frameData.eq = normalizedIndex;\n\n                toDetach[STAGE_FRAME_KEY][normalizedIndex] = $frame.css($.extend({left: o_fade ? 0 : getPosByIndex(index, measures.w, opts.margin, repositionIndex)}, o_fade && getDuration(0)));\n\n                if (isDetached($frame[0])) {\n                    $frame.appendTo($stageShaft);\n                    unloadVideo(dataFrame.$video);\n                }\n\n                callFit(frameData.$img, measures);\n                callFit(frameData.$full, measures);\n\n                if ($frame.hasClass(stageFrameClass) && !($frame.attr('aria-hidden') === \"false\" && $frame.hasClass(activeClass))) {\n                    $frame.attr('aria-hidden', 'true');\n                }\n            });\n        }\n\n        function thumbsDraw(pos, loadFLAG) {\n            var leftLimit,\n                rightLimit,\n                exceedLimit;\n\n\n            if (o_nav !== 'thumbs' || isNaN(pos)) return;\n\n            leftLimit = -pos;\n            rightLimit = -pos + measures.nw;\n\n            if (opts.navdir === 'vertical') {\n                pos = pos - opts.thumbheight;\n                rightLimit = -pos + measures.h;\n            }\n\n            $navThumbFrame.each(function () {\n                var $this = $(this),\n                    thisData = $this.data(),\n                    eq = thisData.eq,\n                    getSpecialMeasures = function () {\n                        return {\n                            h: o_thumbSide2,\n                            w: thisData.w\n                        }\n                    },\n                    specialMeasures = getSpecialMeasures(),\n                    exceedLimit = opts.navdir === 'vertical' ?\n                    thisData.t > rightLimit : thisData.l > rightLimit;\n                specialMeasures.w = thisData.w;\n\n                if (thisData.l + thisData.w < leftLimit\n                    || exceedLimit\n                    || callFit(thisData.$img, specialMeasures)) return;\n\n                loadFLAG && loadImg([eq], 'navThumb', getSpecialMeasures);\n            });\n        }\n\n        function frameAppend($frames, $shaft, type) {\n            if (!frameAppend[type]) {\n\n                var thumbsFLAG = type === 'nav' && o_navThumbs,\n                    left = 0,\n                    top = 0;\n\n                $shaft.append(\n                    $frames\n                        .filter(function () {\n                            var actual,\n                                $this = $(this),\n                                frameData = $this.data();\n                            for (var _i = 0, _l = data.length; _i < _l; _i++) {\n                                if (frameData.data === data[_i]) {\n                                    actual = true;\n                                    frameData.eq = _i;\n                                    break;\n                                }\n                            }\n                            return actual || $this.remove() && false;\n                        })\n                        .sort(function (a, b) {\n                            return $(a).data().eq - $(b).data().eq;\n                        })\n                        .each(function () {\n                            var $this = $(this),\n                                frameData = $this.data();\n                            UTIL.setThumbAttr($this, frameData.data.caption, \"aria-label\");\n                        })\n                        .each(function () {\n\n                            if (!thumbsFLAG) return;\n\n                            var $this = $(this),\n                                frameData = $this.data(),\n                                thumbwidth = Math.round(o_thumbSide2 * frameData.data.thumbratio) || o_thumbSide,\n                                thumbheight = Math.round(o_thumbSide / frameData.data.thumbratio) || o_thumbSide2;\n                            frameData.t = top;\n                            frameData.h = thumbheight;\n                            frameData.l = left;\n                            frameData.w = thumbwidth;\n\n                            $this.css({width: thumbwidth});\n\n                            top += thumbheight + opts.thumbmargin;\n                            left += thumbwidth + opts.thumbmargin;\n                        })\n                );\n\n                frameAppend[type] = true;\n            }\n        }\n\n        function getDirection(x) {\n            return x - stageLeft > measures.w / 3;\n        }\n\n        function disableDirrection(i) {\n            return !o_loop && (!(activeIndex + i) || !(activeIndex - size + i)) && !$videoPlaying;\n        }\n\n        function arrsUpdate() {\n            var disablePrev = disableDirrection(0),\n                disableNext = disableDirrection(1);\n            $arrPrev\n                .toggleClass(arrDisabledClass, disablePrev)\n                .attr(disableAttr(disablePrev, false));\n            $arrNext\n                .toggleClass(arrDisabledClass, disableNext)\n                .attr(disableAttr(disableNext, false));\n        }\n\n        function thumbArrUpdate() {\n            var isLeftDisable = false,\n                isRightDisable = false;\n            if (opts.navtype === 'thumbs' && !opts.loop) {\n                (activeIndex == 0) ? isLeftDisable = true : isLeftDisable = false;\n                (activeIndex == opts.data.length - 1) ? isRightDisable = true : isRightDisable = false;\n            }\n            if (opts.navtype === 'slides') {\n                var pos = readPosition($navShaft, opts.navdir);\n                pos >= navShaftTouchTail.max ? isLeftDisable = true : isLeftDisable = false;\n                pos <= navShaftTouchTail.min ? isRightDisable = true : isRightDisable = false;\n            }\n            $thumbArrLeft\n                .toggleClass(arrDisabledClass, isLeftDisable)\n                .attr(disableAttr(isLeftDisable, true));\n            $thumbArrRight\n                .toggleClass(arrDisabledClass, isRightDisable)\n                .attr(disableAttr(isRightDisable, true));\n        }\n\n        function stageWheelUpdate() {\n            if (stageWheelTail.ok) {\n                stageWheelTail.prevent = {'<': disableDirrection(0), '>': disableDirrection(1)};\n            }\n        }\n\n        function getNavFrameBounds($navFrame) {\n            var navFrameData = $navFrame.data(),\n                left,\n                top,\n                width,\n                height;\n\n            if (o_navThumbs) {\n                left = navFrameData.l;\n                top = navFrameData.t;\n                width = navFrameData.w;\n                height = navFrameData.h;\n            } else {\n                left = $navFrame.position().left;\n                width = $navFrame.width();\n            }\n\n            var horizontalBounds = {\n                c: left + width / 2,\n                min: -left + opts.thumbmargin * 10,\n                max: -left + measures.w - width - opts.thumbmargin * 10\n            };\n\n            var verticalBounds = {\n                c: top + height / 2,\n                min: -top + opts.thumbmargin * 10,\n                max: -top + measures.h - height - opts.thumbmargin * 10\n            };\n\n            return opts.navdir === 'vertical' ? verticalBounds : horizontalBounds;\n        }\n\n        function slideThumbBorder(time) {\n            var navFrameData = activeFrame[navFrameKey].data();\n            slide($thumbBorder, {\n                time: time * 1.2,\n                pos: (opts.navdir === 'vertical' ? navFrameData.t : navFrameData.l),\n                width: navFrameData.w,\n                height: navFrameData.h,\n                direction: opts.navdir\n            });\n        }\n\n        function slideNavShaft(options) {\n            var $guessNavFrame = data[options.guessIndex][navFrameKey],\n                typeOfAnimation = opts.navtype;\n\n            var overflowFLAG,\n                time,\n                minMax,\n                boundTop,\n                boundLeft,\n                l,\n                pos,\n                x;\n\n            if ($guessNavFrame) {\n                if (typeOfAnimation === 'thumbs') {\n                    overflowFLAG = navShaftTouchTail.min !== navShaftTouchTail.max;\n                    minMax = options.minMax || overflowFLAG && getNavFrameBounds(activeFrame[navFrameKey]);\n                    boundTop = overflowFLAG && (options.keep && slideNavShaft.t ? slideNavShaft.l : minMaxLimit((options.coo || measures.nw / 2) - getNavFrameBounds($guessNavFrame).c, minMax.min, minMax.max));\n                    boundLeft = overflowFLAG && (options.keep && slideNavShaft.l ? slideNavShaft.l : minMaxLimit((options.coo || measures.nw / 2) - getNavFrameBounds($guessNavFrame).c, minMax.min, minMax.max));\n                    l = (opts.navdir === 'vertical' ? boundTop : boundLeft);\n                    pos = overflowFLAG && minMaxLimit(l, navShaftTouchTail.min, navShaftTouchTail.max) || 0;\n                    time = options.time * 1.1;\n                    slide($navShaft, {\n                        time: time,\n                        pos: pos,\n                        direction: opts.navdir,\n                        onEnd: function () {\n                            thumbsDraw(pos, true);\n                            thumbArrUpdate();\n                        }\n                    });\n\n                    setShadow($nav, findShadowEdge(pos, navShaftTouchTail.min, navShaftTouchTail.max, opts.navdir));\n                    slideNavShaft.l = l;\n                } else {\n                    x = readPosition($navShaft, opts.navdir);\n                    time = options.time * 1.11;\n\n                    pos = validateSlidePos(opts, navShaftTouchTail, options.guessIndex, x, $guessNavFrame, $navWrap, opts.navdir);\n\n                    slide($navShaft, {\n                        time: time,\n                        pos: pos,\n                        direction: opts.navdir,\n                        onEnd: function () {\n                            thumbsDraw(pos, true);\n                            thumbArrUpdate();\n                        }\n                    });\n                    setShadow($nav, findShadowEdge(pos, navShaftTouchTail.min, navShaftTouchTail.max, opts.navdir));\n                }\n            }\n        }\n\n        function navUpdate() {\n            deactivateFrames(navFrameKey);\n            toDeactivate[navFrameKey].push(activeFrame[navFrameKey].addClass(activeClass).attr('data-active', true));\n        }\n\n        function deactivateFrames(key) {\n            var _toDeactivate = toDeactivate[key];\n\n            while (_toDeactivate.length) {\n                _toDeactivate.shift().removeClass(activeClass).attr('data-active', false);\n            }\n        }\n\n        function detachFrames(key) {\n            var _toDetach = toDetach[key];\n\n            $.each(activeIndexes, function (i, index) {\n                delete _toDetach[normalizeIndex(index)];\n            });\n\n            $.each(_toDetach, function (index, $frame) {\n                delete _toDetach[index];\n                $frame.detach();\n            });\n        }\n\n        function stageShaftReposition(skipOnEnd) {\n\n            repositionIndex = dirtyIndex = activeIndex;\n\n            var $frame = activeFrame[STAGE_FRAME_KEY];\n\n            if ($frame) {\n                deactivateFrames(STAGE_FRAME_KEY);\n                toDeactivate[STAGE_FRAME_KEY].push($frame.addClass(activeClass).attr('data-active', true));\n\n                if ($frame.hasClass(stageFrameClass)) {\n                    $frame.attr('aria-hidden', 'false');\n                }\n\n                skipOnEnd || that.showStage.onEnd(true);\n                stop($stageShaft, 0, true);\n\n                detachFrames(STAGE_FRAME_KEY);\n                stageFramePosition(activeIndexes);\n                setStageShaftMinmaxAndSnap();\n                setNavShaftMinMax();\n                addEnterUp($stageShaft[0], function () {\n                    if (!$fotorama.hasClass(fullscreenClass)) {\n                        that.requestFullScreen();\n                        $fullscreenIcon.focus();\n                    }\n                });\n            }\n        }\n\n        function extendMeasures(options, measuresArray) {\n            if (!options) return;\n\n            $.each(measuresArray, function (i, measures) {\n                if (!measures) return;\n\n                $.extend(measures, {\n                    width: options.width || measures.width,\n                    height: options.height,\n                    minwidth: options.minwidth,\n                    maxwidth: options.maxwidth,\n                    minheight: options.minheight,\n                    maxheight: options.maxheight,\n                    ratio: getRatio(options.ratio)\n                })\n            });\n        }\n\n        function triggerEvent(event, extra) {\n            $fotorama.trigger(_fotoramaClass + ':' + event, [that, extra]);\n        }\n\n        function onTouchStart() {\n            clearTimeout(onTouchEnd.t);\n            touchedFLAG = 1;\n\n            if (opts.stopautoplayontouch) {\n                that.stopAutoplay();\n            } else {\n                pausedAutoplayFLAG = true;\n            }\n        }\n\n        function onTouchEnd() {\n            if (!touchedFLAG) return;\n            if (!opts.stopautoplayontouch) {\n                releaseAutoplay();\n                changeAutoplay();\n            }\n\n            onTouchEnd.t = setTimeout(function () {\n                touchedFLAG = 0;\n            }, TRANSITION_DURATION + TOUCH_TIMEOUT);\n        }\n\n        function releaseAutoplay() {\n            pausedAutoplayFLAG = !!($videoPlaying || stoppedAutoplayFLAG);\n        }\n\n        function changeAutoplay() {\n\n            clearTimeout(changeAutoplay.t);\n            waitFor.stop(changeAutoplay.w);\n\n            if (!opts.autoplay || pausedAutoplayFLAG) {\n                if (that.autoplay) {\n                    that.autoplay = false;\n                    triggerEvent('stopautoplay');\n                }\n\n                return;\n            }\n\n            if (!that.autoplay) {\n                that.autoplay = true;\n                triggerEvent('startautoplay');\n            }\n\n            var _activeIndex = activeIndex;\n\n\n            var frameData = activeFrame[STAGE_FRAME_KEY].data();\n            changeAutoplay.w = waitFor(function () {\n                return frameData.state || _activeIndex !== activeIndex;\n            }, function () {\n                changeAutoplay.t = setTimeout(function () {\n\n                    if (pausedAutoplayFLAG || _activeIndex !== activeIndex) return;\n\n                    var _nextAutoplayIndex = nextAutoplayIndex,\n                        nextFrameData = data[_nextAutoplayIndex][STAGE_FRAME_KEY].data();\n\n                    changeAutoplay.w = waitFor(function () {\n\n                        return nextFrameData.state || _nextAutoplayIndex !== nextAutoplayIndex;\n                    }, function () {\n                        if (pausedAutoplayFLAG || _nextAutoplayIndex !== nextAutoplayIndex) return;\n                        that.show(o_loop ? getDirectionSign(!o_rtl) : nextAutoplayIndex);\n                    });\n                }, opts.autoplay);\n            });\n\n        }\n\n        that.startAutoplay = function (interval) {\n            if (that.autoplay) return this;\n            pausedAutoplayFLAG = stoppedAutoplayFLAG = false;\n            setAutoplayInterval(interval || opts.autoplay);\n            changeAutoplay();\n\n            return this;\n        };\n\n        that.stopAutoplay = function () {\n            if (that.autoplay) {\n                pausedAutoplayFLAG = stoppedAutoplayFLAG = true;\n                changeAutoplay();\n            }\n            return this;\n        };\n\n        that.showSlide = function (slideDir) {\n            var currentPosition = readPosition($navShaft, opts.navdir),\n                pos,\n                time = 500 * 1.1,\n                size = opts.navdir === 'horizontal' ? opts.thumbwidth : opts.thumbheight,\n                onEnd = function () {\n                    thumbArrUpdate();\n                };\n            if (slideDir === 'next') {\n                pos = currentPosition - (size + opts.margin) * thumbsPerSlide;\n            }\n            if (slideDir === 'prev') {\n                pos = currentPosition + (size + opts.margin) * thumbsPerSlide;\n            }\n            pos = validateRestrictions(pos, navShaftTouchTail);\n            thumbsDraw(pos, true);\n            slide($navShaft, {\n                time: time,\n                pos: pos,\n                direction: opts.navdir,\n                onEnd: onEnd\n            });\n        };\n\n        that.showWhileLongPress = function (options) {\n            if (that.longPress.singlePressInProgress) {\n                return;\n            }\n\n            var index = calcActiveIndex(options);\n            calcGlobalIndexes(index);\n            var time = calcTime(options) / 50;\n            var _activeFrame = activeFrame;\n            that.activeFrame = activeFrame = data[activeIndex];\n            var silent = _activeFrame === activeFrame && !options.user;\n\n            that.showNav(silent, options, time);\n\n            return this;\n        };\n\n        that.showEndLongPress = function (options) {\n            if (that.longPress.singlePressInProgress) {\n                return;\n            }\n\n            var index = calcActiveIndex(options);\n            calcGlobalIndexes(index);\n            var time = calcTime(options) / 50;\n            var _activeFrame = activeFrame;\n            that.activeFrame = activeFrame = data[activeIndex];\n\n            var silent = _activeFrame === activeFrame && !options.user;\n\n            that.showStage(silent, options, time);\n\n            showedFLAG = typeof lastActiveIndex !== 'undefined' && lastActiveIndex !== activeIndex;\n            lastActiveIndex = activeIndex;\n            return this;\n        };\n\n        function calcActiveIndex (options) {\n            var index;\n\n            if (typeof options !== 'object') {\n                index = options;\n                options = {};\n            } else {\n                index = options.index;\n            }\n\n            index = index === '>' ? dirtyIndex + 1 : index === '<' ? dirtyIndex - 1 : index === '<<' ? 0 : index === '>>' ? size - 1 : index;\n            index = isNaN(index) ? undefined : index;\n            index = typeof index === 'undefined' ? activeIndex || 0 : index;\n\n            return index;\n        }\n\n        function calcGlobalIndexes (index) {\n            that.activeIndex = activeIndex = edgeIndex(index);\n            prevIndex = getPrevIndex(activeIndex);\n            nextIndex = getNextIndex(activeIndex);\n            nextAutoplayIndex = normalizeIndex(activeIndex + (o_rtl ? -1 : 1));\n            activeIndexes = [activeIndex, prevIndex, nextIndex];\n\n            dirtyIndex = o_loop ? index : activeIndex;\n        }\n\n        function calcTime (options) {\n            var diffIndex = Math.abs(lastActiveIndex - dirtyIndex),\n                time = getNumber(options.time, function () {\n                    return Math.min(o_transitionDuration * (1 + (diffIndex - 1) / 12), o_transitionDuration * 2);\n                });\n\n            if (options.slow) {\n                time *= 10;\n            }\n\n            return time;\n        }\n\n        that.showStage = function (silent, options, time) {\n            unloadVideo($videoPlaying, activeFrame.i !== data[normalizeIndex(repositionIndex)].i);\n            frameDraw(activeIndexes, 'stage');\n            stageFramePosition(SLOW ? [dirtyIndex] : [dirtyIndex, getPrevIndex(dirtyIndex), getNextIndex(dirtyIndex)]);\n            updateTouchTails('go', true);\n\n            silent || triggerEvent('show', {\n                user: options.user,\n                time: time\n            });\n\n            pausedAutoplayFLAG = true;\n\n            var overPos = options.overPos;\n            var onEnd = that.showStage.onEnd = function (skipReposition) {\n                if (onEnd.ok) return;\n                onEnd.ok = true;\n\n                skipReposition || stageShaftReposition(true);\n\n                if (!silent) {\n                    triggerEvent('showend', {\n                        user: options.user\n                    });\n                }\n\n                if (!skipReposition && o_transition && o_transition !== opts.transition) {\n                    that.setOptions({transition: o_transition});\n                    o_transition = false;\n                    return;\n                }\n\n                updateFotoramaState();\n                loadImg(activeIndexes, 'stage');\n\n                updateTouchTails('go', false);\n                stageWheelUpdate();\n\n                stageCursor();\n                releaseAutoplay();\n                changeAutoplay();\n\n                if (that.fullScreen) {\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgFullClass).attr('aria-hidden', false);\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgClass).attr('aria-hidden', true)\n                } else {\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgFullClass).attr('aria-hidden', true);\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgClass).attr('aria-hidden', false)\n                }\n            };\n\n            if (!o_fade) {\n                slide($stageShaft, {\n                    pos: -getPosByIndex(dirtyIndex, measures.w, opts.margin, repositionIndex),\n                    overPos: overPos,\n                    time: time,\n                    onEnd: onEnd\n                });\n            } else {\n                var $activeFrame = activeFrame[STAGE_FRAME_KEY],\n                    $prevActiveFrame = data[lastActiveIndex] && activeIndex !== lastActiveIndex ? data[lastActiveIndex][STAGE_FRAME_KEY] : null;\n\n                fade($activeFrame, $prevActiveFrame, $stageFrame, {\n                    time: time,\n                    method: opts.transition,\n                    onEnd: onEnd\n                }, fadeStack);\n            }\n\n            arrsUpdate();\n        };\n\n        that.showNav = function(silent, options, time){\n            thumbArrUpdate();\n            if (o_nav) {\n                navUpdate();\n\n                var guessIndex = limitIndex(activeIndex + minMaxLimit(dirtyIndex - lastActiveIndex, -1, 1));\n                slideNavShaft({\n                    time: time,\n                    coo: guessIndex !== activeIndex && options.coo,\n                    guessIndex: typeof options.coo !== 'undefined' ? guessIndex : activeIndex,\n                    keep: silent\n                });\n                if (o_navThumbs) slideThumbBorder(time);\n            }\n        };\n\n        that.show = function (options) {\n            that.longPress.singlePressInProgress = true;\n\n            var index = calcActiveIndex(options);\n            calcGlobalIndexes(index);\n            var time = calcTime(options);\n            var _activeFrame = activeFrame;\n            that.activeFrame = activeFrame = data[activeIndex];\n\n            var silent = _activeFrame === activeFrame && !options.user;\n\n            that.showStage(silent, options, time);\n            that.showNav(silent, options, time);\n\n            showedFLAG = typeof lastActiveIndex !== 'undefined' && lastActiveIndex !== activeIndex;\n            lastActiveIndex = activeIndex;\n            that.longPress.singlePressInProgress = false;\n\n            return this;\n        };\n\n        that.requestFullScreen = function () {\n            if (o_allowFullScreen && !that.fullScreen) {\n\n                //check that this is not video\n                var isVideo = $((that.activeFrame || {}).$stageFrame || {}).hasClass('fotorama-video-container');\n                if(isVideo) {\n                    return;\n                }\n\n                scrollTop = $WINDOW.scrollTop();\n                scrollLeft = $WINDOW.scrollLeft();\n\n                lockScroll($WINDOW);\n\n                updateTouchTails('x', true);\n\n                measuresStash = $.extend({}, measures);\n\n                $fotorama\n                    .addClass(fullscreenClass)\n                    .appendTo($BODY.addClass(_fullscreenClass));\n\n                $HTML.addClass(_fullscreenClass);\n\n                unloadVideo($videoPlaying, true, true);\n\n                that.fullScreen = true;\n\n                if (o_nativeFullScreen) {\n                    fullScreenApi.request(fotorama);\n                }\n\n                that.resize();\n                loadImg(activeIndexes, 'stage');\n                updateFotoramaState();\n                triggerEvent('fullscreenenter');\n\n                if (!('ontouchstart' in window)) {\n                    $fullscreenIcon.focus();\n                }\n            }\n\n            return this;\n        };\n\n        function cancelFullScreen() {\n            if (that.fullScreen) {\n                that.fullScreen = false;\n\n                if (FULLSCREEN) {\n                    fullScreenApi.cancel(fotorama);\n                }\n\n                $BODY.removeClass(_fullscreenClass);\n                $HTML.removeClass(_fullscreenClass);\n\n                $fotorama\n                    .removeClass(fullscreenClass)\n                    .insertAfter($anchor);\n\n                measures = $.extend({}, measuresStash);\n\n                unloadVideo($videoPlaying, true, true);\n\n                updateTouchTails('x', false);\n\n                that.resize();\n                loadImg(activeIndexes, 'stage');\n\n                lockScroll($WINDOW, scrollLeft, scrollTop);\n\n                triggerEvent('fullscreenexit');\n            }\n        }\n\n        that.cancelFullScreen = function () {\n            if (o_nativeFullScreen && fullScreenApi.is()) {\n                fullScreenApi.cancel(document);\n            } else {\n                cancelFullScreen();\n            }\n\n            return this;\n        };\n\n        that.toggleFullScreen = function () {\n            return that[(that.fullScreen ? 'cancel' : 'request') + 'FullScreen']();\n        };\n\n        that.resize = function (options) {\n            if (!data) return this;\n\n            var time = arguments[1] || 0,\n                setFLAG = arguments[2];\n\n            thumbsPerSlide = getThumbsInSlide($wrap, opts);\n            extendMeasures(!that.fullScreen ? optionsToLowerCase(options) : {\n                width: $(window).width(),\n                maxwidth: null,\n                minwidth: null,\n                height: $(window).height(),\n                maxheight: null,\n                minheight: null\n            }, [measures, setFLAG || that.fullScreen || opts]);\n\n            var width = measures.width,\n                height = measures.height,\n                ratio = measures.ratio,\n                windowHeight = $WINDOW.height() - (o_nav ? $nav.height() : 0);\n\n            if (measureIsValid(width)) {\n                $wrap.css({width: ''});\n                $wrap.css({height: ''});\n                $stage.css({width: ''});\n                $stage.css({height: ''});\n                $stageShaft.css({width: ''});\n                $stageShaft.css({height: ''});\n                $nav.css({width: ''});\n                $nav.css({height: ''});\n                $wrap.css({minWidth: measures.minwidth || 0, maxWidth: measures.maxwidth || MAX_WIDTH});\n\n                if (o_nav === 'dots') {\n                    $navWrap.hide();\n                }\n                width = measures.W = measures.w = $wrap.width();\n                measures.nw = o_nav && numberFromWhatever(opts.navwidth, width) || width;\n\n                $stageShaft.css({width: measures.w, marginLeft: (measures.W - measures.w) / 2});\n\n                height = numberFromWhatever(height, windowHeight);\n\n                height = height || (ratio && width / ratio);\n\n                if (height) {\n                    width = Math.round(width);\n                    height = measures.h = Math.round(minMaxLimit(height, numberFromWhatever(measures.minheight, windowHeight), numberFromWhatever(measures.maxheight, windowHeight)));\n                    $stage.css({'width': width, 'height': height});\n\n                    if (opts.navdir === 'vertical' && !that.fullscreen) {\n                        $nav.width(opts.thumbwidth + opts.thumbmargin * 2);\n                    }\n\n                    if (opts.navdir === 'horizontal' && !that.fullscreen) {\n                        $nav.height(opts.thumbheight + opts.thumbmargin * 2);\n                    }\n\n                    if (o_nav === 'dots') {\n                        $nav.width(width)\n                            .height('auto');\n                        $navWrap.show();\n                    }\n\n                    if (opts.navdir === 'vertical' && that.fullScreen) {\n                        $stage.css('height', $WINDOW.height());\n                    }\n\n                    if (opts.navdir === 'horizontal' && that.fullScreen) {\n                        $stage.css('height', $WINDOW.height() - $nav.height());\n                    }\n\n                    if (o_nav) {\n                        switch (opts.navdir) {\n                            case 'vertical':\n                                $navWrap.removeClass(navShafthorizontalClass);\n                                $navWrap.removeClass(navShaftListClass);\n                                $navWrap.addClass(navShaftVerticalClass);\n                                $nav\n                                    .stop()\n                                    .animate({height: measures.h, width: opts.thumbwidth}, time);\n                                break;\n                            case 'list':\n                                $navWrap.removeClass(navShaftVerticalClass);\n                                $navWrap.removeClass(navShafthorizontalClass);\n                                $navWrap.addClass(navShaftListClass);\n                                break;\n                            default:\n                                $navWrap.removeClass(navShaftVerticalClass);\n                                $navWrap.removeClass(navShaftListClass);\n                                $navWrap.addClass(navShafthorizontalClass);\n                                $nav\n                                    .stop()\n                                    .animate({width: measures.nw}, time);\n                                break;\n                        }\n\n                        stageShaftReposition();\n                        slideNavShaft({guessIndex: activeIndex, time: time, keep: true});\n                        if (o_navThumbs && frameAppend.nav) slideThumbBorder(time);\n                    }\n\n                    measuresSetFLAG = setFLAG || true;\n\n                    ready.ok = true;\n                    ready();\n                }\n            }\n\n            stageLeft = $stage.offset().left;\n            setStagePosition();\n\n            return this;\n        };\n\n        that.setOptions = function (options) {\n            $.extend(opts, options);\n            reset();\n            return this;\n        };\n\n        that.shuffle = function () {\n            data && shuffle(data) && reset();\n            return this;\n        };\n\n        function setShadow($el, edge) {\n            if (o_shadows) {\n                $el.removeClass(shadowsLeftClass + ' ' + shadowsRightClass);\n                $el.removeClass(shadowsTopClass + ' ' + shadowsBottomClass);\n                edge && !$videoPlaying && $el.addClass(edge.replace(/^|\\s/g, ' ' + shadowsClass + '--'));\n            }\n        }\n\n        that.longPress = {\n            threshold: 1,\n            count: 0,\n            thumbSlideTime: 20,\n            progress: function(){\n                if (!this.inProgress) {\n                    this.count++;\n                    this.inProgress = this.count > this.threshold;\n                }\n            },\n            end: function(){\n                if(this.inProgress) {\n                    this.isEnded = true\n                }\n            },\n            reset: function(){\n                this.count = 0;\n                this.inProgress = false;\n                this.isEnded = false;\n            }\n        };\n\n        that.destroy = function () {\n            that.cancelFullScreen();\n            that.stopAutoplay();\n\n            data = that.data = null;\n\n            appendElements();\n\n            activeIndexes = [];\n            detachFrames(STAGE_FRAME_KEY);\n\n            reset.ok = false;\n\n            return this;\n        };\n\n        /**\n         *\n         * @returns {jQuery.Fotorama}\n         */\n        that.playVideo = function () {\n            var dataFrame = activeFrame,\n                video = dataFrame.video,\n                _activeIndex = activeIndex;\n\n            if (typeof video === 'object' && dataFrame.videoReady) {\n                o_nativeFullScreen && that.fullScreen && that.cancelFullScreen();\n\n                waitFor(function () {\n                    return !fullScreenApi.is() || _activeIndex !== activeIndex;\n                }, function () {\n                    if (_activeIndex === activeIndex) {\n                        dataFrame.$video = dataFrame.$video || $(div(videoClass)).append(createVideoFrame(video));\n                        dataFrame.$video.appendTo(dataFrame[STAGE_FRAME_KEY]);\n\n                        $wrap.addClass(wrapVideoClass);\n                        $videoPlaying = dataFrame.$video;\n\n                        stageNoMove();\n\n                        $arrs.blur();\n                        $fullscreenIcon.blur();\n\n                        triggerEvent('loadvideo');\n                    }\n                });\n            }\n\n            return this;\n        };\n\n        that.stopVideo = function () {\n            unloadVideo($videoPlaying, true, true);\n            return this;\n        };\n\n        that.spliceByIndex = function (index, newImgObj) {\n            newImgObj.i = index + 1;\n            newImgObj.img && $.ajax({\n                url: newImgObj.img,\n                type: 'HEAD',\n                success: function () {\n                    data.splice(index, 1, newImgObj);\n                    reset();\n                }\n            });\n        };\n\n        function unloadVideo($video, unloadActiveFLAG, releaseAutoplayFLAG) {\n            if (unloadActiveFLAG) {\n                $wrap.removeClass(wrapVideoClass);\n                $videoPlaying = false;\n\n                stageNoMove();\n            }\n\n            if ($video && $video !== $videoPlaying) {\n                $video.remove();\n                triggerEvent('unloadvideo');\n            }\n\n            if (releaseAutoplayFLAG) {\n                releaseAutoplay();\n                changeAutoplay();\n            }\n        }\n\n        function toggleControlsClass(FLAG) {\n            $wrap.toggleClass(wrapNoControlsClass, FLAG);\n        }\n\n        function stageCursor(e) {\n            if (stageShaftTouchTail.flow) return;\n\n            var x = e ? e.pageX : stageCursor.x,\n                pointerFLAG = x && !disableDirrection(getDirection(x)) && opts.click;\n\n            if (stageCursor.p !== pointerFLAG\n                && $stage.toggleClass(pointerClass, pointerFLAG)) {\n                stageCursor.p = pointerFLAG;\n                stageCursor.x = x;\n            }\n        }\n\n        $stage.on('mousemove', stageCursor);\n\n        function clickToShow(showOptions) {\n            clearTimeout(clickToShow.t);\n\n            if (opts.clicktransition && opts.clicktransition !== opts.transition) {\n                setTimeout(function () {\n                    var _o_transition = opts.transition;\n\n                    that.setOptions({transition: opts.clicktransition});\n\n                    // now safe to pass base transition to o_transition, so that.show will restor it\n                    o_transition = _o_transition;\n                    // this timeout is here to prevent jerking in some browsers\n                    clickToShow.t = setTimeout(function () {\n                        that.show(showOptions);\n                    }, 10);\n                }, 0);\n            } else {\n                that.show(showOptions);\n            }\n        }\n\n        function onStageTap(e, toggleControlsFLAG) {\n            var target = e.target,\n                $target = $(target);\n            if ($target.hasClass(videoPlayClass)) {\n                that.playVideo();\n            } else if (target === fullscreenIcon) {\n                that.toggleFullScreen();\n            } else if ($videoPlaying) {\n                target === videoClose && unloadVideo($videoPlaying, true, true);\n            } else if (!$fotorama.hasClass(fullscreenClass)) {\n                that.requestFullScreen();\n            }\n        }\n\n        function updateTouchTails(key, value) {\n            stageShaftTouchTail[key] = navShaftTouchTail[key] = value;\n        }\n\n        stageShaftTouchTail = moveOnTouch($stageShaft, {\n            onStart: onTouchStart,\n            onMove: function (e, result) {\n                setShadow($stage, result.edge);\n            },\n            onTouchEnd: onTouchEnd,\n            onEnd: function (result) {\n                var toggleControlsFLAG;\n\n                setShadow($stage);\n                toggleControlsFLAG = (MS_POINTER && !hoverFLAG || result.touch) &&\n                    opts.arrows;\n\n                if ((result.moved || (toggleControlsFLAG && result.pos !== result.newPos && !result.control)) && result.$target[0] !== $fullscreenIcon[0]) {\n                    var index = getIndexByPos(result.newPos, measures.w, opts.margin, repositionIndex);\n                    \n                    that.show({\n                        index: index,\n                        time: o_fade ? o_transitionDuration : result.time,\n                        overPos: result.overPos,\n                        user: true\n                    });\n                } else if (!result.aborted && !result.control) {\n                    onStageTap(result.startEvent, toggleControlsFLAG);\n                }\n            },\n            timeLow: 1,\n            timeHigh: 1,\n            friction: 2,\n            select: '.' + selectClass + ', .' + selectClass + ' *',\n            $wrap: $stage,\n            direction: 'horizontal'\n\n        });\n\n        navShaftTouchTail = moveOnTouch($navShaft, {\n            onStart: onTouchStart,\n            onMove: function (e, result) {\n                setShadow($nav, result.edge);\n            },\n            onTouchEnd: onTouchEnd,\n            onEnd: function (result) {\n\n                function onEnd() {\n                    slideNavShaft.l = result.newPos;\n                    releaseAutoplay();\n                    changeAutoplay();\n                    thumbsDraw(result.newPos, true);\n                    thumbArrUpdate();\n                }\n\n                if (!result.moved) {\n                    var target = result.$target.closest('.' + navFrameClass, $navShaft)[0];\n                    target && onNavFrameClick.call(target, result.startEvent);\n                } else if (result.pos !== result.newPos) {\n                    pausedAutoplayFLAG = true;\n                    slide($navShaft, {\n                        time: result.time,\n                        pos: result.newPos,\n                        overPos: result.overPos,\n                        direction: opts.navdir,\n                        onEnd: onEnd\n                    });\n                    thumbsDraw(result.newPos);\n                    o_shadows && setShadow($nav, findShadowEdge(result.newPos, navShaftTouchTail.min, navShaftTouchTail.max, result.dir));\n                } else {\n                    onEnd();\n                }\n            },\n            timeLow: .5,\n            timeHigh: 2,\n            friction: 5,\n            $wrap: $nav,\n            direction: opts.navdir\n        });\n\n        stageWheelTail = wheel($stage, {\n            shift: true,\n            onEnd: function (e, direction) {\n                onTouchStart();\n                onTouchEnd();\n                that.show({index: direction, slow: e.altKey})\n            }\n        });\n\n        navWheelTail = wheel($nav, {\n            onEnd: function (e, direction) {\n                onTouchStart();\n                onTouchEnd();\n                var newPos = stop($navShaft) + direction * .25;\n                $navShaft.css(getTranslate(minMaxLimit(newPos, navShaftTouchTail.min, navShaftTouchTail.max), opts.navdir));\n                o_shadows && setShadow($nav, findShadowEdge(newPos, navShaftTouchTail.min, navShaftTouchTail.max, opts.navdir));\n                navWheelTail.prevent = {'<': newPos >= navShaftTouchTail.max, '>': newPos <= navShaftTouchTail.min};\n                clearTimeout(navWheelTail.t);\n                navWheelTail.t = setTimeout(function () {\n                    slideNavShaft.l = newPos;\n                    thumbsDraw(newPos, true)\n                }, TOUCH_TIMEOUT);\n                thumbsDraw(newPos);\n            }\n        });\n\n        $wrap.hover(\n            function () {\n                setTimeout(function () {\n                    if (touchedFLAG) return;\n                    toggleControlsClass(!(hoverFLAG = true));\n                }, 0);\n            },\n            function () {\n                if (!hoverFLAG) return;\n                toggleControlsClass(!(hoverFLAG = false));\n            }\n        );\n\n        function onNavFrameClick(e) {\n            var index = $(this).data().eq;\n\n            if (opts.navtype === 'thumbs') {\n                clickToShow({index: index, slow: e.altKey, user: true, coo: e._x - $nav.offset().left});\n            } else {\n                clickToShow({index: index, slow: e.altKey, user: true});\n            }\n        }\n\n        function onArrClick(e) {\n            clickToShow({index: $arrs.index(this) ? '>' : '<', slow: e.altKey, user: true});\n        }\n\n        smartClick($arrs, function (e) {\n            stopEvent(e);\n            onArrClick.call(this, e);\n        }, {\n            onStart: function () {\n                onTouchStart();\n                stageShaftTouchTail.control = true;\n            },\n            onTouchEnd: onTouchEnd\n        });\n\n        smartClick($thumbArrLeft, function (e) {\n            stopEvent(e);\n            if (opts.navtype === 'thumbs') {\n\n                that.show('<');\n            } else {\n                that.showSlide('prev')\n            }\n        });\n\n        smartClick($thumbArrRight, function (e) {\n            stopEvent(e);\n            if (opts.navtype === 'thumbs') {\n                that.show('>');\n            } else {\n                that.showSlide('next')\n            }\n\n        });\n\n\n        function addFocusOnControls(el) {\n            addFocus(el, function () {\n                setTimeout(function () {\n                    lockScroll($stage);\n                }, 0);\n                toggleControlsClass(false);\n            });\n        }\n\n        $arrs.each(function () {\n            addEnterUp(this, function (e) {\n                onArrClick.call(this, e);\n            });\n            addFocusOnControls(this);\n        });\n\n        addEnterUp(fullscreenIcon, function () {\n            if ($fotorama.hasClass(fullscreenClass)) {\n                that.cancelFullScreen();\n                $stageShaft.focus();\n            } else {\n                that.requestFullScreen();\n                $fullscreenIcon.focus();\n            }\n\n        });\n        addFocusOnControls(fullscreenIcon);\n\n        function reset() {\n            setData();\n            setOptions();\n\n            if (!reset.i) {\n                reset.i = true;\n                // Only once\n                var _startindex = opts.startindex;\n                activeIndex = repositionIndex = dirtyIndex = lastActiveIndex = startIndex = edgeIndex(_startindex) || 0;\n                /*(o_rtl ? size - 1 : 0)*///;\n            }\n\n            if (size) {\n                if (changeToRtl()) return;\n\n                if ($videoPlaying) {\n                    unloadVideo($videoPlaying, true);\n                }\n\n                activeIndexes = [];\n                detachFrames(STAGE_FRAME_KEY);\n\n                reset.ok = true;\n\n                that.show({index: activeIndex, time: 0});\n                that.resize();\n            } else {\n                that.destroy();\n            }\n        }\n\n        function changeToRtl() {\n\n            if (!changeToRtl.f === o_rtl) {\n                changeToRtl.f = o_rtl;\n                activeIndex = size - 1 - activeIndex;\n                that.reverse();\n\n                return true;\n            }\n        }\n\n        $.each('load push pop shift unshift reverse sort splice'.split(' '), function (i, method) {\n            that[method] = function () {\n                data = data || [];\n                if (method !== 'load') {\n                    Array.prototype[method].apply(data, arguments);\n                } else if (arguments[0] && typeof arguments[0] === 'object' && arguments[0].length) {\n                    data = clone(arguments[0]);\n                }\n                reset();\n                return that;\n            }\n        });\n\n        function ready() {\n            if (ready.ok) {\n                ready.ok = false;\n                triggerEvent('ready');\n            }\n        }\n\n        reset();\n    };\n    $.fn.fotorama = function (opts) {\n        return this.each(function () {\n            var that = this,\n                $fotorama = $(this),\n                fotoramaData = $fotorama.data(),\n                fotorama = fotoramaData.fotorama;\n\n            if (!fotorama) {\n                waitFor(function () {\n                    return !isHidden(that);\n                }, function () {\n                    fotoramaData.urtext = $fotorama.html();\n                    new $.Fotorama($fotorama,\n                        $.extend(\n                            {},\n                            OPTIONS,\n                            window.fotoramaDefaults,\n                            opts,\n                            fotoramaData\n                        )\n                    );\n                });\n            } else {\n                fotorama.setOptions(opts, true);\n            }\n        });\n    };\n    $.Fotorama.instances = [];\n\n    function calculateIndexes() {\n        $.each($.Fotorama.instances, function (index, instance) {\n            instance.index = index;\n        });\n    }\n\n    function addInstance(instance) {\n        $.Fotorama.instances.push(instance);\n        calculateIndexes();\n    }\n\n    function hideInstance(instance) {\n        $.Fotorama.instances.splice(instance.index, 1);\n        calculateIndexes();\n    }\n\n    $.Fotorama.cache = {};\n    $.Fotorama.measures = {};\n    $ = $ || {};\n    $.Fotorama = $.Fotorama || {};\n    $.Fotorama.jst = $.Fotorama.jst || {};\n\n    $.Fotorama.jst.dots = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '<div class=\"fotorama__nav__frame fotorama__nav__frame--dot\" tabindex=\"0\" role=\"button\" data-gallery-role=\"nav-frame\" data-nav-type=\"thumb\" aria-label>\\r\\n    <div class=\"fotorama__dot\"></div>\\r\\n</div>';\n        return __p\n    };\n\n    $.Fotorama.jst.frameCaption = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '<div class=\"fotorama__caption\" aria-hidden=\"true\">\\r\\n    <div class=\"fotorama__caption__wrap\" id=\"' +\n            ((__t = ( v.labelledby )) == null ? '' : __t) +\n            '\">' +\n            ((__t = ( v.caption )) == null ? '' : __t) +\n            '</div>\\r\\n</div>\\r\\n';\n        return __p\n    };\n\n    $.Fotorama.jst.style = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '.fotorama' +\n            ((__t = ( v.s )) == null ? '' : __t) +\n            ' .fotorama__nav--thumbs .fotorama__nav__frame{\\r\\npadding:' +\n            ((__t = ( v.m )) == null ? '' : __t) +\n            'px;\\r\\nheight:' +\n            ((__t = ( v.h )) == null ? '' : __t) +\n            'px}\\r\\n.fotorama' +\n            ((__t = ( v.s )) == null ? '' : __t) +\n            ' .fotorama__thumb-border{\\r\\nheight:' +\n            ((__t = ( v.h )) == null ? '' : __t) +\n            'px;\\r\\nborder-width:' +\n            ((__t = ( v.b )) == null ? '' : __t) +\n            'px;\\r\\nmargin-top:' +\n            ((__t = ( v.m )) == null ? '' : __t) +\n            'px}';\n        return __p\n    };\n\n    $.Fotorama.jst.thumb = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '<div class=\"fotorama__nav__frame fotorama__nav__frame--thumb\" tabindex=\"0\" role=\"button\" data-gallery-role=\"nav-frame\" data-nav-type=\"thumb\" aria-label>\\r\\n    <div class=\"fotorama__thumb\">\\r\\n    </div>\\r\\n</div>';\n        return __p\n    };\n})(window, document, location, typeof jQuery !== 'undefined' && jQuery);\n\n","mage/dialog.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    /**\n     * Dialog Widget - this widget is a wrapper for the jQuery UI Dialog\n     */\n    $.widget('mage.dialog', $.ui.dialog, {});\n\n    return $.mage.dialog;\n});\n","mage/storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery', 'mage/url'], function ($, urlBuilder) {\n    'use strict';\n\n    return {\n        /**\n         * Perform asynchronous GET request to server.\n         * @param {String} url\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        get: function (url, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'GET',\n                global: global,\n                contentType: contentType\n            });\n        },\n\n        /**\n         * Perform asynchronous POST request to server.\n         * @param {String} url\n         * @param {String} data\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        post: function (url, data, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'POST',\n                data: data,\n                global: global,\n                contentType: contentType\n            });\n        },\n\n        /**\n         * Perform asynchronous PUT request to server.\n         * @param {String} url\n         * @param {String} data\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        put: function (url, data, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'PUT',\n                data: data,\n                global: global,\n                contentType: contentType\n            });\n        },\n\n        /**\n         * Perform asynchronous DELETE request to server.\n         * @param {String} url\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        delete: function (url, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'DELETE',\n                global: global,\n                contentType: contentType\n            });\n        }\n    };\n});\n","mage/dropdowns.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} options\n     */\n    $.fn.dropdown = function (options) {\n        var defaults = {\n                parent: null,\n                autoclose: true,\n                btnArrow: '.arrow',\n                menu: '[data-target=\"dropdown\"]',\n                activeClass: 'active'\n            },\n            actionElem = $(this),\n            self = this;\n\n        options = $.extend(defaults, options);\n        actionElem = $(this);\n        self = this;\n\n        /**\n         * @param {HTMLElement} elem\n         */\n        this.openDropdown = function (elem) {\n            elem\n                .addClass(options.activeClass)\n                .attr('aria-expanded', true)\n                .parent()\n                    .addClass(options.activeClass);\n\n            elem.parent()\n                .find(options.menu)\n                .attr('aria-hidden', false);\n\n            $(options.btnArrow, elem).text('-');\n        };\n\n        /**\n         * @param {HTMLElement} elem\n         */\n        this.closeDropdown = function (elem) {\n            elem.removeClass(options.activeClass)\n                .attr('aria-expanded', false)\n                .parent()\n                    .removeClass(options.activeClass);\n\n            elem.parent()\n                .find(options.menu)\n                .attr('aria-hidden', true);\n\n            $(options.btnArrow, elem).text('+');\n        };\n\n        /**\n         * Reset all dropdowns.\n         *\n         * @param {Object} param\n         */\n        this.reset = function (param) {\n            var params = param || {},\n                dropdowns = params.elems || actionElem;\n\n            dropdowns.each(function (index, elem) {\n                self.closeDropdown($(elem));\n            });\n        };\n\n        /* document Event bindings */\n        if (options.autoclose === true) {\n            $(document).on('click.hideDropdown', this.reset);\n            $(document).on('keyup.hideDropdown', function (e) {\n                var ESC_CODE = '27';\n\n                if (e.keyCode == ESC_CODE) { //eslint-disable-line eqeqeq\n                    self.reset();\n                }\n            });\n        }\n\n        if (options.events) {\n            $.each(options.events, function (index, event) {\n                $(document).on(event.name, event.selector, event.action);\n            });\n        }\n\n        return this.each(function () {\n            var elem = $(this),\n                parent = $(options.parent).length > 0 ? $(options.parent) : elem.parent(),\n                menu = $(options.menu, parent) || $('.dropdown-menu', parent);\n\n            // ARIA (adding aria attributes)\n            if (menu.length) {\n                elem.attr('aria-haspopup', true);\n            }\n\n            if (!elem.hasClass(options.activeClass)) {\n                elem.attr('aria-expanded', false);\n                menu.attr('aria-hidden', true);\n            } else {\n                elem.attr('aria-expanded', true);\n                menu.attr('aria-hidden', false);\n            }\n\n            if (!elem.is('a, button')) {\n                elem.attr('role', 'button');\n                elem.attr('tabindex', 0);\n            }\n\n            if (elem.attr('data-trigger-keypress-button')) {\n                elem.on('keypress', function (e) {\n                    var keyCode = e.keyCode || e.which,\n                        ENTER_CODE = 13;\n\n                    if (keyCode === ENTER_CODE) {\n                        e.preventDefault();\n                        elem.trigger('click.toggleDropdown');\n                    }\n                });\n            }\n\n            elem.on('click.toggleDropdown', function () {\n                var el;\n\n                if (options.autoclose === true) {\n                    el = actionElem;\n\n                    actionElem = $();\n                    $(document).trigger('click.hideDropdown');\n                    actionElem = el;\n                }\n\n                self[el.hasClass(options.activeClass) ? 'closeDropdown' : 'openDropdown'](elem);\n\n                return false;\n            });\n        });\n    };\n\n    return function (data, el) {\n        $(el).dropdown(data);\n    };\n});\n","mage/popup-window.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.popupWindow', {\n        options: {\n            centerBrowser: 0, // center window over browser window? {1 (YES) or 0 (NO)}. overrides top and left\n            centerScreen: 0, // center window over entire screen? {1 (YES) or 0 (NO)}. overrides top and left\n            height: 500, // sets the height in pixels of the window.\n            left: 0, // left position when the window appears.\n            location: 0, // determines whether the address bar is displayed {1 (YES) or 0 (NO)}.\n            menubar: 0, // determines whether the menu bar is displayed {1 (YES) or 0 (NO)}.\n            resizable: 0, // whether the window can be resized {1 (YES) or 0 (NO)}.\n            scrollbars: 0, // determines whether scrollbars appear on the window {1 (YES) or 0 (NO)}.\n            status: 0, // whether a status line appears at the bottom of the window {1 (YES) or 0 (NO)}.\n            width: 500, // sets the width in pixels of the window.\n            windowName: null, // name of window set from the name attribute of the element that invokes the click\n            windowURL: null, // url used for the popup\n            top: 0, // top position when the window appears.\n            toolbar: 0 // determines whether a toolbar is displayed {1 (YES) or 0 (NO)}.\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', $.proxy(this._openPopupWindow, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _openPopupWindow: function (event) {\n            var element = $(event.target),\n                settings = this.options,\n                windowFeatures =\n                    'height=' + settings.height +\n                        ',width=' + settings.width +\n                        ',toolbar=' + settings.toolbar +\n                        ',scrollbars=' + settings.scrollbars +\n                        ',status=' + settings.status +\n                        ',resizable=' + settings.resizable +\n                        ',location=' + settings.location +\n                        ',menuBar=' + settings.menubar,\n                centeredX,\n                centeredY;\n\n            settings.windowName = settings.windowName || element.attr('name');\n            settings.windowURL = settings.windowURL || element.attr('href');\n\n            if (settings.centerBrowser) {\n                if ($.browser.msie) { // Hacked together for IE browsers\n                    centeredY = window.screenTop - 120 +\n                        (((document.documentElement.clientHeight + 120) / 2 - settings.height / 2));\n                    centeredX = window.screenLeft + (((document.body.offsetWidth + 20) / 2 - settings.width / 2));\n                } else {\n                    centeredY = window.screenY + ((window.outerHeight / 2 - settings.height / 2));\n                    centeredX = window.screenX + ((window.outerWidth / 2 - settings.width / 2));\n                }\n                windowFeatures += ',left=' + centeredX + ',top=' + centeredY;\n            } else if (settings.centerScreen) {\n                centeredY = (screen.height - settings.height) / 2;\n                centeredX = (screen.width - settings.width) / 2;\n                windowFeatures += ',left=' + centeredX + ',top=' + centeredY;\n            } else {\n                windowFeatures += ',left=' + settings.left + ',top=' + settings.top;\n            }\n\n            window.open(settings.windowURL, settings.windowName, windowFeatures).focus();\n            event.preventDefault();\n        }\n    });\n\n    return $.mage.popupWindow;\n});\n","mage/calendar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint max-depth: 0*/\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui',\n            'jquery/jquery-ui-timepicker-addon'\n        ], factory);\n    } else {\n        factory(window.jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    var calendarBasePrototype,\n        datepickerPrototype = $.datepicker.constructor.prototype;\n\n    $.datepicker.markerClassName = '_has-datepicker';\n\n    /**\n     * Extend JQuery date picker prototype with store local time methods\n     */\n    $.extend(datepickerPrototype, {\n        /**\n         * Get date/time according to store settings.\n         * We use serverTimezoneOffset (in seconds) instead of serverTimezoneSeconds\n         * in order to have ability to know actual store time even if page hadn't been reloaded\n         * @returns {Date}\n         */\n        _getTimezoneDate: function (options) {\n            // local time in ms\n            var ms = Date.now();\n\n            options = options || $.calendarConfig || {};\n\n            // Adjust milliseconds according to store timezone offset,\n            // mind the GMT zero offset\n            if (typeof options.serverTimezoneOffset !== 'undefined') {\n                // Make UTC time and add store timezone offset in seconds\n                ms += new Date().getTimezoneOffset() * 60 * 1000 + options.serverTimezoneOffset * 1000;\n            } else if (typeof options.serverTimezoneSeconds !== 'undefined') {\n                //Set milliseconds according to client local timezone offset\n                ms = (options.serverTimezoneSeconds + new Date().getTimezoneOffset() * 60) * 1000;\n            }\n\n            return new Date(ms);\n        },\n\n        /**\n         * Set date/time according to store settings.\n         * @param {String|Object} target - the target input field or division or span\n         */\n        _setTimezoneDateDatepicker: function (target) {\n            this._setDateDatepicker(target, this._getTimezoneDate());\n        }\n    });\n\n    /**\n     * Widget calendar\n     */\n    $.widget('mage.calendar', {\n\n        /**\n         * Merge global options with options passed to widget invoke\n         * @protected\n         */\n        _create: function () {\n            this._enableAMPM();\n            this.options = $.extend(\n                {},\n                $.calendarConfig ? $.calendarConfig : {},\n                this.options.showsTime ? {\n                    showTime: true,\n                    showHour: true,\n                    showMinute: true\n                } : {},\n                this.options\n            );\n            this._initPicker(this.element);\n            this._overwriteGenerateHtml();\n        },\n\n        /**\n         * Get picker name\n         * @protected\n         */\n        _picker: function () {\n            return this.options.showsTime ? 'datetimepicker' : 'datepicker';\n        },\n\n        /**\n         * Fix for Timepicker - Set ampm option for Timepicker if timeformat contains string 'tt'\n         * @protected\n         */\n        _enableAMPM: function () {\n            if (this.options.timeFormat && this.options.timeFormat.indexOf('tt') >= 0) {\n                this.options.ampm = true;\n            }\n        },\n\n        /**\n         * Wrapper for overwrite jQuery UI datepicker function.\n         */\n        _overwriteGenerateHtml: function () {\n            /**\n             * Overwrite jQuery UI datepicker function.\n             * Reason: magento date could be set before calendar show\n             * but local date will be styled as current in original _generateHTML\n             *\n             * @param {Object} inst - instance datepicker.\n             * @return {String} html template\n             */\n            $.datepicker.constructor.prototype._generateHTML = function (inst) {\n                var today = this._getTimezoneDate(),\n                    isRTL = this._get(inst, 'isRTL'),\n                    showButtonPanel = this._get(inst, 'showButtonPanel'),\n                    hideIfNoPrevNext = this._get(inst, 'hideIfNoPrevNext'),\n                    navigationAsDateFormat = this._get(inst, 'navigationAsDateFormat'),\n                    numMonths = this._getNumberOfMonths(inst),\n                    showCurrentAtPos = this._get(inst, 'showCurrentAtPos'),\n                    stepMonths = this._get(inst, 'stepMonths'),\n                    isMultiMonth = parseInt(numMonths[0], 10) !== 1 || parseInt(numMonths[1], 10) !== 1,\n                    currentDate = this._daylightSavingAdjust(!inst.currentDay ? new Date(9999, 9, 9) :\n                        new Date(inst.currentYear, inst.currentMonth, inst.currentDay)),\n                    minDate = this._getMinMaxDate(inst, 'min'),\n                    maxDate = this._getMinMaxDate(inst, 'max'),\n                    drawMonth = inst.drawMonth - showCurrentAtPos,\n                    drawYear = inst.drawYear,\n                    maxDraw,\n                    prevText = this._get(inst, 'prevText'),\n                    prev,\n                    nextText = this._get(inst, 'nextText'),\n                    next,\n                    currentText = this._get(inst, 'currentText'),\n                    gotoDate,\n                    controls,\n                    buttonPanel,\n                    firstDay,\n                    showWeek = this._get(inst, 'showWeek'),\n                    dayNames = this._get(inst, 'dayNames'),\n                    dayNamesMin = this._get(inst, 'dayNamesMin'),\n                    monthNames = this._get(inst, 'monthNames'),\n                    monthNamesShort =  this._get(inst, 'monthNamesShort'),\n                    beforeShowDay = this._get(inst, 'beforeShowDay'),\n                    showOtherMonths = this._get(inst, 'showOtherMonths'),\n                    selectOtherMonths = this._get(inst, 'selectOtherMonths'),\n                    defaultDate = this._getDefaultDate(inst),\n                    html = '',\n                    row = 0,\n                    col = 0,\n                    selectedDate,\n                    cornerClass = ' ui-corner-all',\n                    group = '',\n                    calender = '',\n                    dow = 0,\n                    thead,\n                    day,\n                    daysInMonth,\n                    leadDays,\n                    curRows,\n                    numRows,\n                    printDate,\n                    dRow = 0,\n                    tbody,\n                    daySettings,\n                    otherMonth,\n                    unselectable;\n\n                if (drawMonth < 0) {\n                    drawMonth += 12;\n                    drawYear--;\n                }\n\n                if (maxDate) {\n                    maxDraw = this._daylightSavingAdjust(new Date(maxDate.getFullYear(),\n                        maxDate.getMonth() - numMonths[0] * numMonths[1] + 1, maxDate.getDate()));\n                    maxDraw = minDate && maxDraw < minDate ? minDate : maxDraw;\n\n                    while (this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1)) > maxDraw) {\n                        drawMonth--;\n\n                        if (drawMonth < 0) {\n                            drawMonth = 11;\n                            drawYear--;\n\n                        }\n                    }\n                }\n                inst.drawMonth = drawMonth;\n                inst.drawYear = drawYear;\n                prevText = !navigationAsDateFormat ? prevText : this.formatDate(prevText,\n                    this._daylightSavingAdjust(new Date(drawYear, drawMonth - stepMonths, 1)),\n                    this._getFormatConfig(inst));\n                prev = this._canAdjustMonth(inst, -1, drawYear, drawMonth) ?\n                    '<a class=\"ui-datepicker-prev ui-corner-all\" data-handler=\"prev\" data-event=\"click\"' +\n                    ' title=\"' + prevText + '\">' +\n                    '<span class=\"ui-icon ui-icon-circle-triangle-' + (isRTL ? 'e' : 'w') + '\">' +\n                    '' + prevText + '</span></a>'\n                    : hideIfNoPrevNext ? ''\n                        :   '<a class=\"ui-datepicker-prev ui-corner-all ui-state-disabled\" title=\"' +\n                            '' + prevText + '\"><span class=\"ui-icon ui-icon-circle-triangle-' +\n                            '' + (isRTL ? 'e' : 'w') + '\">' + prevText + '</span></a>';\n                nextText = !navigationAsDateFormat ?\n                    nextText\n                    :   this.formatDate(nextText,\n                        this._daylightSavingAdjust(new Date(drawYear, drawMonth + stepMonths, 1)),\n                        this._getFormatConfig(inst));\n                next = this._canAdjustMonth(inst, +1, drawYear, drawMonth) ?\n                    '<a class=\"ui-datepicker-next ui-corner-all\" data-handler=\"next\" data-event=\"click\"' +\n                    'title=\"' + nextText + '\"><span class=\"ui-icon ui-icon-circle-triangle-' +\n                    '' + (isRTL ? 'w' : 'e') + '\">' + nextText + '</span></a>'\n                    : hideIfNoPrevNext ? ''\n                        :   '<a class=\"ui-datepicker-next ui-corner-all ui-state-disabled\" title=\"' + nextText + '\">' +\n                            '<span class=\"ui-icon ui-icon-circle-triangle-' + (isRTL ? 'w' : 'e') + '\">' + nextText +\n                            '</span></a>';\n                gotoDate = this._get(inst, 'gotoCurrent') && inst.currentDay ? currentDate : today;\n                currentText = !navigationAsDateFormat ? currentText :\n                    this.formatDate(currentText, gotoDate, this._getFormatConfig(inst));\n                controls = !inst.inline ?\n                    '<button type=\"button\" class=\"ui-datepicker-close ui-state-default ui-priority-primary ' +\n                    'ui-corner-all\" data-handler=\"hide\" data-event=\"click\">' +\n                    this._get(inst, 'closeText') + '</button>'\n                    : '';\n                buttonPanel = showButtonPanel ?\n                    '<div class=\"ui-datepicker-buttonpane ui-widget-content\">' + (isRTL ? controls : '') +\n                    (this._isInRange(inst, gotoDate) ? '<button type=\"button\" class=\"ui-datepicker-current ' +\n                    'ui-state-default ui-priority-secondary ui-corner-all\" data-handler=\"today\" data-event=\"click\"' +\n                    '>' + currentText + '</button>' : '') + (isRTL ? '' : controls) + '</div>' : '';\n                firstDay = parseInt(this._get(inst, 'firstDay'), 10);\n                firstDay = isNaN(firstDay) ? 0 : firstDay;\n\n                for (row; row < numMonths[0]; row++) {\n                    this.maxRows = 4;\n\n                    for (col; col < numMonths[1]; col++) {\n                        selectedDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, inst.selectedDay));\n\n                        if (isMultiMonth) {\n                            calender += '<div class=\"ui-datepicker-group';\n\n                            if (numMonths[1] > 1) {\n                                switch (col) {\n                                    case 0: calender += ' ui-datepicker-group-first';\n                                        cornerClass = ' ui-corner-' + (isRTL ? 'right' : 'left');\n                                        break;\n\n                                    case numMonths[1] - 1: calender += ' ui-datepicker-group-last';\n                                        cornerClass = ' ui-corner-' + (isRTL ? 'left' : 'right');\n                                        break;\n\n                                    default: calender += ' ui-datepicker-group-middle'; cornerClass = '';\n                                }\n                            }\n                            calender += '\">';\n                        }\n                        calender += '<div class=\"ui-datepicker-header ' +\n                            'ui-widget-header ui-helper-clearfix' + cornerClass + '\">' +\n                            (/all|left/.test(cornerClass) && parseInt(row, 10) === 0 ? isRTL ? next : prev : '') +\n                            (/all|right/.test(cornerClass) && parseInt(row, 10) === 0 ? isRTL ? prev : next : '') +\n                            this._generateMonthYearHeader(inst, drawMonth, drawYear, minDate, maxDate,\n                            row > 0 || col > 0, monthNames, monthNamesShort) + // draw month headers\n                            '</div><table class=\"ui-datepicker-calendar\"><thead>' +\n                            '<tr>';\n                        thead = showWeek ?\n                            '<th class=\"ui-datepicker-week-col\">' + this._get(inst, 'weekHeader') + '</th>' : '';\n\n                        for (dow; dow < 7; dow++) { // days of the week\n                            day = (dow + firstDay) % 7;\n                            thead += '<th' + ((dow + firstDay + 6) % 7 >= 5 ?\n                                ' class=\"ui-datepicker-week-end\"' : '') + '>' +\n                                '<span title=\"' + dayNames[day] + '\">' + dayNamesMin[day] + '</span></th>';\n                        }\n                        calender += thead + '</tr></thead><tbody>';\n                        daysInMonth = this._getDaysInMonth(drawYear, drawMonth);\n\n                        if (drawYear === inst.selectedYear && drawMonth === inst.selectedMonth) {\n                            inst.selectedDay = Math.min(inst.selectedDay, daysInMonth);\n                        }\n                        leadDays = (this._getFirstDayOfMonth(drawYear, drawMonth) - firstDay + 7) % 7;\n                        curRows = Math.ceil((leadDays + daysInMonth) / 7); // calculate the number of rows to generate\n                        numRows = isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows;\n                        this.maxRows = numRows;\n                        printDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1 - leadDays));\n\n                        for (dRow; dRow < numRows; dRow++) { // create date picker rows\n                            calender += '<tr>';\n                            tbody = !showWeek ? '' : '<td class=\"ui-datepicker-week-col\">' +\n                            this._get(inst, 'calculateWeek')(printDate) + '</td>';\n\n                            for (dow = 0; dow < 7; dow++) { // create date picker days\n                                daySettings = beforeShowDay ?\n                                    beforeShowDay.apply(inst.input ? inst.input[0] : null, [printDate]) : [true, ''];\n                                otherMonth = printDate.getMonth() !== drawMonth;\n                                unselectable = otherMonth && !selectOtherMonths || !daySettings[0] ||\n                                minDate && printDate < minDate || maxDate && printDate > maxDate;\n                                tbody += '<td class=\"' +\n                                ((dow + firstDay + 6) % 7 >= 5 ? ' ui-datepicker-week-end' : '') + // highlight weekends\n                                (otherMonth ? ' ui-datepicker-other-month' : '') + // highlight days from other months\n                                (printDate.getTime() === selectedDate.getTime() &&\n                                drawMonth === inst.selectedMonth && inst._keyEvent || // user pressed key\n                                defaultDate.getTime() === printDate.getTime() &&\n                                defaultDate.getTime() === selectedDate.getTime() ?\n                                    // or defaultDate is current printedDate and defaultDate is selectedDate\n                                ' ' + this._dayOverClass : '') + // highlight selected day\n                                (unselectable ? ' ' + this._unselectableClass + ' ui-state-disabled' : '') +\n                                (otherMonth && !showOtherMonths ? '' : ' ' + daySettings[1] + // highlight custom dates\n                                (printDate.getTime() === currentDate.getTime() ? ' ' + this._currentClass : '') +\n                                (printDate.getDate() === today.getDate() && printDate.getMonth() === today.getMonth() &&\n                                printDate.getYear() === today.getYear() ? ' ui-datepicker-today' : '')) + '\"' +\n                                ((!otherMonth || showOtherMonths) && daySettings[2] ?\n                                ' title=\"' + daySettings[2] + '\"' : '') + // cell title\n                                (unselectable ? '' : ' data-handler=\"selectDay\" data-event=\"click\" data-month=\"' +\n                                '' + printDate.getMonth() + '\" data-year=\"' + printDate.getFullYear() + '\"') + '>' +\n                                (otherMonth && !showOtherMonths ? '&#xa0;' : // display for other months\n                                    unselectable ? '<span class=\"ui-state-default\">' + printDate.getDate() + '</span>'\n                                        : '<a class=\"ui-state-default' +\n                                    (printDate.getTime() === today.getTime() ? ' ' : '') +\n                                    (printDate.getTime() === currentDate.getTime() ? ' ui-state-active' : '') +\n                                    (otherMonth ? ' ui-priority-secondary' : '') +\n                                    '\" href=\"#\">' + printDate.getDate() + '</a>') + '</td>';\n                                printDate.setDate(printDate.getDate() + 1);\n                                printDate = this._daylightSavingAdjust(printDate);\n                            }\n                            calender += tbody + '</tr>';\n                        }\n                        drawMonth++;\n\n                        if (drawMonth > 11) {\n                            drawMonth = 0;\n                            drawYear++;\n                        }\n                        calender += '</tbody></table>' + (isMultiMonth ? '</div>' +\n                        (numMonths[0] > 0 && col === numMonths[1] - 1 ? '<div class=\"ui-datepicker-row-break\"></div>'\n                            : '') : '');\n                        group += calender;\n                    }\n                    html += group;\n                }\n                html += buttonPanel + ($.ui.ie6 && !inst.inline ?\n                    '<iframe src=\"javascript:false;\" class=\"ui-datepicker-cover\" frameborder=\"0\"></iframe>' : '');\n                inst._keyEvent = false;\n\n                return html;\n            };\n        },\n\n        /**\n         * Set current date if the date is not set\n         * @protected\n         * @param {Object} element\n         */\n        _setCurrentDate: function (element) {\n            if (!element.val()) {\n                element[this._picker()]('setTimezoneDate').val('');\n            }\n        },\n\n        /**\n         * Init Datetimepicker\n         * @protected\n         * @param {Object} element\n         */\n        _initPicker: function (element) {\n            var picker = element[this._picker()](this.options),\n                pickerButtonText = picker.next('.ui-datepicker-trigger')\n                    .find('img')\n                    .attr('title');\n\n            picker.next('.ui-datepicker-trigger')\n                .addClass('v-middle')\n                .text('') // Remove jQuery UI datepicker generated image\n                .append('<span>' + pickerButtonText + '</span>');\n            this._setCurrentDate(element);\n        },\n\n        /**\n         * destroy instance of datetimepicker\n         */\n        _destroy: function () {\n            this.element[this._picker()]('destroy');\n            this._super();\n        },\n\n        /**\n         * Method is kept for backward compatibility and unit-tests acceptance\n         * see \\mage\\calendar\\calendar-test.js\n         * @return {Object} date\n         */\n        getTimezoneDate: function () {\n            return datepickerPrototype._getTimezoneDate.call(this, this.options);\n        }\n    });\n\n    calendarBasePrototype = $.mage.calendar.prototype;\n\n    /**\n     * Extension for Calendar - date and time format convert functionality\n     * @var {Object}\n     */\n    $.widget('mage.calendar', $.extend({}, calendarBasePrototype,\n            /** @lends {$.mage.calendar.prototype} */ {\n                /**\n                 * key - backend format, value - jquery format\n                 * @type {Object}\n                 * @private\n                 */\n                dateTimeFormat: {\n                    date: {\n                        'EEEE': 'DD',\n                        'EEE': 'D',\n                        'EE': 'D',\n                        'E': 'D',\n                        'D': 'o',\n                        'MMMM': 'MM',\n                        'MMM': 'M',\n                        'MM': 'mm',\n                        'M': 'mm',\n                        'yyyy': 'yy',\n                        'y': 'yy',\n                        'Y': 'yy',\n                        'yy': 'yy' // Always long year format on frontend\n                    },\n                    time: {\n                        'a': 'TT'\n                    }\n                },\n\n                /**\n                 * Add Date and Time converting to _create method\n                 * @protected\n                 */\n                _create: function () {\n                    if (this.options.dateFormat) {\n                        this.options.dateFormat = this._convertFormat(this.options.dateFormat, 'date');\n                    }\n\n                    if (this.options.timeFormat) {\n                        this.options.timeFormat = this._convertFormat(this.options.timeFormat, 'time');\n                    }\n                    calendarBasePrototype._create.apply(this, arguments);\n                },\n\n                /**\n                 * Converting date or time format\n                 * @protected\n                 * @param {String} format\n                 * @param {String} type\n                 * @return {String}\n                 */\n                _convertFormat: function (format, type) {\n                    var symbols = format.match(/([a-z]+)/ig),\n                        separators = format.match(/([^a-z]+)/ig),\n                        self = this,\n                        convertedFormat = '';\n\n                    if (symbols) {\n                        $.each(symbols, function (key, val) {\n                            convertedFormat +=\n                                (self.dateTimeFormat[type][val] || val) +\n                                (separators[key] || '');\n                        });\n                    }\n\n                    return convertedFormat;\n                }\n            })\n    );\n\n    /**\n     * Widget dateRange\n     * @extends $.mage.calendar\n     */\n    $.widget('mage.dateRange', $.mage.calendar, {\n\n        /**\n         * creates two instances of datetimepicker for date range selection\n         * @protected\n         */\n        _initPicker: function () {\n            var from,\n                to;\n\n            if (this.options.from && this.options.to) {\n                from = this.element.find('#' + this.options.from.id);\n                to = this.element.find('#' + this.options.to.id);\n                this.options.onSelect = $.proxy(function (selectedDate) {\n                    to[this._picker()]('option', 'minDate', selectedDate);\n                }, this);\n                $.mage.calendar.prototype._initPicker.call(this, from);\n                from.on('change', $.proxy(function () {\n                    to[this._picker()]('option', 'minDate', from[this._picker()]('getDate'));\n                }, this));\n                this.options.onSelect = $.proxy(function (selectedDate) {\n                    from[this._picker()]('option', 'maxDate', selectedDate);\n                }, this);\n                $.mage.calendar.prototype._initPicker.call(this, to);\n                to.on('change', $.proxy(function () {\n                    from[this._picker()]('option', 'maxDate', to[this._picker()]('getDate'));\n                }, this));\n            }\n        },\n\n        /**\n         * destroy two instances of datetimepicker\n         */\n        _destroy: function () {\n            if (this.options.from) {\n                this.element.find('#' + this.options.from.id)[this._picker()]('destroy');\n            }\n\n            if (this.options.to) {\n                this.element.find('#' + this.options.to.id)[this._picker()]('destroy');\n            }\n            this._super();\n        }\n    });\n\n    // Overrides the \"today\" button functionality to select today's date when clicked.\n    $.datepicker._gotoTodayOriginal = $.datepicker._gotoToday;\n\n    /**\n     * overwrite jQuery UI _showDatepicker function for proper HTML generation conditions.\n     *\n     */\n    $.datepicker._showDatepickerOriginal = $.datepicker._showDatepicker;\n\n    /**\n     * Triggers original method showDataPicker for rendering calendar\n     * @param {HTMLObject} input\n     * @private\n     */\n    $.datepicker._showDatepicker = function (input) {\n        if (!input.disabled) {\n            $.datepicker._showDatepickerOriginal.call(this, input);\n        }\n    };\n\n    /**\n     * _gotoToday\n     * @param {Object} el\n     */\n    $.datepicker._gotoToday = function (el) {\n        //Set date/time according to timezone offset\n        $(el).datepicker('setTimezoneDate')\n            // To ensure that user can re-select date field without clicking outside it first.\n            .blur().trigger('change');\n    };\n\n    return {\n        dateRange:  $.mage.dateRange,\n        calendar:   $.mage.calendar\n    };\n}));\n","mage/tooltip.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    //Widget Wrapper\n    $.widget('mage.tooltip', $.ui.tooltip, {});\n\n    return $.mage.tooltip;\n});\n","mage/item-table.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.itemTable', {\n        options: {\n            addBlock: '[data-template=\"add-block\"]',\n            addBlockData: {},\n            addEvent: 'click',\n            addSelector: '[data-role=\"add\"]',\n            itemsSelector: '[data-container=\"items\"]',\n            keepLastRow: true\n        },\n\n        /**\n         * This method adds a new instance of the block to the items.\n         * @private\n         */\n        _add: function () {\n            var hideShowDelete,\n                deletableItems,\n                addedBlock;\n\n            // adding a new row, so increment the count to give each row a unique index\n            this.rowIndex++;\n\n            // make sure the block data has the rowIndex\n            this.options.addBlockData.rowIndex = this.rowIndex;\n\n            // render the form\n            addedBlock = $(this.addBlockTmpl({\n                data: this.options.addBlockData\n            }));\n\n            // add the row to the item block\n            this.element.find(this.options.itemsSelector).append(addedBlock);\n\n            // initialize all mage content\n            addedBlock.trigger('contentUpdated');\n\n            // determine all existing items in the collection\n            deletableItems = this._getDeletableItems();\n\n            // for the most part, show the delete mechanism, except in the case where there is only one it should not\n            // be deleted\n            hideShowDelete = 'showDelete';\n\n            if (this.options.keepLastRow && deletableItems.length === 1) {\n                hideShowDelete = 'hideDelete';\n            }\n\n            // loop through each control and perform that action on the deletable item\n            $.each(deletableItems, function (index) {\n                $(deletableItems[index]).trigger(hideShowDelete);\n            });\n        },\n\n        /**\n         * This method binds elements found in this widget.\n         * @private\n         */\n        _bind: function () {\n            var handlers = {};\n\n            // since the first handler is dynamic, generate the object using array notation\n            handlers[this.options.addEvent + ' ' + this.options.addSelector] = '_add';\n            handlers.deleteItem = '_onDeleteItem';\n\n            this._on(handlers);\n        },\n\n        /**\n         * This method constructs a new widget.\n         * @private\n         */\n        _create: function () {\n            this._bind();\n\n            this.addBlockTmpl = mageTemplate(this.options.addBlock);\n\n            // nothing in the table, so indicate that\n            this.rowIndex = -1;\n\n            // make sure the block data is an object\n            if (this.options.addBlockData == null || typeof this.options.addBlockData !== 'object') {\n                // reset the block data to an empty object\n                this.options.addBlockData = {};\n            }\n\n            // add the first row to the table\n            this._add();\n        },\n\n        /**\n         * This method returns the list of widgets associated with deletable items from the container (direct children\n         * only).\n         * @private\n         */\n        _getDeletableItems: function () {\n            return this.element.find(this.options.itemsSelector + '> .deletableItem');\n        },\n\n        /**\n         * This method removes the item associated with the message.\n         * @private\n         */\n        _onDeleteItem: function (e) {\n            var deletableItems;\n\n            // parent elements don't need to see this event\n            e.stopPropagation();\n\n            // remove the deletable item\n            $(e.target).remove();\n\n            if (this.options.keepLastRow) {\n                // determine if there is only one element remaining, in which case, disable the delete mechanism on it\n                deletableItems = this._getDeletableItems();\n\n                if (deletableItems.length === 1) {\n                    $(deletableItems[0]).trigger('hideDelete');\n                }\n            }\n        }\n    });\n\n    return $.mage.itemTable;\n});\n","mage/smart-keyboard-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * @return {Object}\n     * @constructor\n     */\n    function KeyboardHandler() {\n        var body = $('body'),\n            focusState = false,\n            tabFocusClass = '_keyfocus',\n            productsGrid = '[data-container=\"product-grid\"]',\n            catalogProductsGrid = $(productsGrid),\n            CODE_TAB = 9;\n\n        /**\n         * Handle logic, when onTabKeyPress fired at first.\n         * Then it changes state.\n         */\n        function onFocusInHandler() {\n            focusState = true;\n            body.addClass(tabFocusClass)\n                .off('focusin.keyboardHandler', onFocusInHandler);\n        }\n\n        /**\n         * Handle logic to remove state after onTabKeyPress to normal.\n         */\n        function onClickHandler() {\n            focusState = false;\n            body.removeClass(tabFocusClass)\n                .off('click', onClickHandler);\n        }\n\n        /**\n         * Tab key onKeypress handler. Apply main logic:\n         *  - call differ actions onTabKeyPress and onClick\n         */\n        function smartKeyboardFocus() {\n            $(document).on('keydown keypress', function (event) {\n                if (event.which === CODE_TAB && !focusState) {\n                    body\n                        .on('focusin.keyboardHandler', onFocusInHandler)\n                        .on('click', onClickHandler);\n                }\n            });\n\n            // ARIA support for catalog grid products\n            if (catalogProductsGrid.length) {\n                body.on('focusin.gridProducts', productsGrid, function () {\n                    if (body.hasClass(tabFocusClass)) {\n                        $(this).addClass('active');\n                    }\n                });\n                body.on('focusout.gridProducts', productsGrid, function () {\n                    $(this).removeClass('active');\n                });\n            }\n        }\n\n        /**\n         * Attach smart focus on specific element.\n         * @param {jQuery} element\n         */\n        function handleFocus(element) {\n            element.on('focusin.emulateTabFocus', function () {\n                focusState = true;\n                body.addClass(tabFocusClass);\n                element.off();\n            });\n\n            element.on('focusout.emulateTabFocus', function () {\n                focusState = false;\n                body.removeClass(tabFocusClass);\n                element.off();\n            });\n        }\n\n        return {\n            apply: smartKeyboardFocus,\n            focus: handleFocus\n        };\n    }\n\n    return new KeyboardHandler;\n});\n","mage/cookies.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/mage',\n            'jquery/jquery.cookie'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    /**\n     * Helper for cookies manipulation\n     * @returns {CookieHelper}\n     * @constructor\n     */\n    var CookieHelper = function () {\n\n        /**\n         * Cookie default values.\n         * @type {Object}\n         */\n        this.defaults = {\n            expires: null,\n            path: '/',\n            domain: null,\n            secure: false,\n            lifetime: null\n        };\n\n        /**\n         * Calculate cookie expiration date based on its lifetime.\n         * @param {Object} options - Cookie option values\n         * @return {Date|null} Calculated cookie expiration date or null if no lifetime provided.\n         * @private\n         */\n        function lifetimeToExpires(options, defaults) {\n            var expires,\n                lifetime;\n\n            lifetime = options.lifetime || defaults.lifetime;\n\n            if (lifetime && lifetime > 0) {\n                expires = options.expires || new Date();\n\n                return new Date(expires.getTime() + lifetime * 1000);\n            }\n\n            return null;\n        }\n\n        /**\n         * Set a cookie's value by cookie name based on optional cookie options.\n         * @param {String} name - The name of the cookie.\n         * @param {String} value - The cookie's value.\n         * @param {Object} options - Optional options (e.g. lifetime, expires, path, etc.)\n         */\n        this.set = function (name, value, options) {\n            var expires,\n                path,\n                domain,\n                secure;\n\n            options = $.extend({}, this.defaults, options || {});\n            expires = lifetimeToExpires(options, this.defaults) || options.expires;\n            path = options.path;\n            domain = options.domain;\n            secure = options.secure;\n\n            document.cookie = name + '=' + encodeURIComponent(value) +\n                (expires ? '; expires=' + expires.toUTCString() :  '') +\n                (path ? '; path=' + path : '') +\n                (domain ? '; domain=' + domain : '') +\n                (secure ? '; secure' : '');\n        };\n\n        /**\n         * Get a cookie's value by cookie name.\n         * @param {String} name  - The name of the cookie.\n         * @return {(null|String)}\n         */\n        this.get = function (name) {\n            var arg = name + '=',\n                aLength = arg.length,\n                cookie = document.cookie,\n                cLength = cookie.length,\n                i = 0,\n                j = 0;\n\n            while (i < cLength) {\n                j = i + aLength;\n\n                if (cookie.substring(i, j) === arg) {\n                    return this.getCookieVal(j);\n                }\n                i = cookie.indexOf(' ', i) + 1;\n\n                if (i === 0) {\n                    break;\n                }\n            }\n\n            return null;\n        };\n\n        /**\n         * Clear a cookie's value by name.\n         * @param {String} name - The name of the cookie being cleared.\n         */\n        this.clear = function (name) {\n            if (this.get(name)) {\n                this.set(name, '', {\n                    expires: new Date('Jan 01 1970 00:00:01 GMT')\n                });\n            }\n        };\n\n        /**\n         * Return URI decoded cookie component value (e.g. expires, path, etc.) based on a\n         * numeric offset in the document's cookie value.\n         * @param {Number} offset - Offset into the document's cookie value.\n         * @return {String}\n         */\n        this.getCookieVal = function (offset) {\n            var cookie = document.cookie,\n                endstr = cookie.indexOf(';', offset);\n\n            if (endstr === -1) {\n                endstr = cookie.length;\n            }\n\n            return decodeURIComponent(cookie.substring(offset, endstr));\n        };\n\n        return this;\n    };\n\n    $.extend(true, $, {\n        mage: {\n            cookies: new CookieHelper()\n        }\n    });\n\n    return function (pageOptions) {\n        $.extend($.mage.cookies.defaults, pageOptions);\n        $.extend($.cookie.defaults, $.mage.cookies.defaults);\n    };\n}));\n","mage/mage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/apply/main'\n        ], factory);\n    } else {\n        factory(root.jQuery);\n    }\n}(this, function ($, mage) {\n    'use strict';\n\n    /**\n     * Main namespace for Magento extensions\n     * @type {Object}\n     */\n    $.mage = $.mage || {};\n\n    /**\n     * Plugin mage, initialize components on elements\n     * @param {String} name - Components' path.\n     * @param {Object} config - Components' config.\n     * @returns {JQuery} Chainable.\n     */\n    $.fn.mage = function (name, config) {\n        config = config || {};\n\n        this.each(function (index, el) {\n            mage.applyFor(el, config, name);\n        });\n\n        return this;\n    };\n\n    $.extend($.mage, {\n        /**\n         * Handle all components declared via data attribute\n         * @return {Object} $.mage\n         */\n        init: function () {\n            mage.apply();\n\n            return this;\n        },\n\n        /**\n         * Method handling redirects and page refresh\n         * @param {String} url - redirect URL\n         * @param {(undefined|String)} type - 'assign', 'reload', 'replace'\n         * @param {(undefined|Number)} timeout - timeout in milliseconds before processing the redirect or reload\n         * @param {(undefined|Boolean)} forced - true|false used for 'reload' only\n         */\n        redirect: function (url, type, timeout, forced) {\n            var _redirect;\n\n            forced  = !!forced;\n            timeout = timeout || 0;\n            type    = type || 'assign';\n\n            /**\n             * @private\n             */\n            _redirect = function () {\n                window.location[type](type === 'reload' ? forced : url);\n            };\n\n            timeout ? setTimeout(_redirect, timeout) : _redirect();\n        },\n\n        /**\n         * Checks if provided string is a valid selector.\n         * @param {String} selector - Selector to check.\n         * @returns {Boolean}\n         */\n        isValidSelector: function (selector) {\n            try {\n                document.querySelector(selector);\n\n                return true;\n            } catch (e) {\n                return false;\n            }\n        }\n    });\n\n    /**\n     * Init components inside of dynamically updated elements\n     */\n    $('body').on('contentUpdated', function () {\n        if (mage) {\n            mage.apply();\n        }\n    });\n\n    return $.mage;\n}));\n","mage/collapsible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/jquery-storageapi',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    var hideProps = {},\n        showProps = {};\n\n    hideProps.height =  'hide';\n    showProps.height =  'show';\n\n    $.widget('mage.collapsible', {\n        options: {\n            active: false,\n            disabled: false,\n            collapsible: true,\n            header: '[data-role=title]',\n            content: '[data-role=content]',\n            trigger: '[data-role=trigger]',\n            closedState: null,\n            openedState: null,\n            disabledState: null,\n            ajaxUrlElement: '[data-ajax=true]',\n            ajaxContent: false,\n            loadingClass: null,\n            saveState: false,\n            animate: false,\n            icons: {\n                activeHeader: null,\n                header: null\n            },\n            collateral: {\n                element: null,\n                openedState: null\n            }\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.storage = $.localStorage;\n            this.icons = false;\n\n            if (typeof this.options.icons === 'string') {\n                this.options.icons = $.parseJSON(this.options.icons);\n            }\n\n            this._processPanels();\n            this._processState();\n            this._refresh();\n\n            if (this.options.icons.header && this.options.icons.activeHeader) {\n                this._createIcons();\n                this.icons = true;\n            }\n\n            this._bind('click');\n            this._trigger('created');\n        },\n\n        /**\n         * @private\n         */\n        _refresh: function () {\n            this.trigger.attr('tabIndex', 0);\n\n            if (this.options.active && !this.options.disabled) {\n                if (this.options.openedState) {\n                    this.element.addClass(this.options.openedState);\n                }\n\n                if (this.options.collateral.element && this.options.collateral.openedState) {\n                    $(this.options.collateral.element).addClass(this.options.collateral.openedState);\n                }\n\n                if (this.options.ajaxContent) {\n                    this._loadContent();\n                }\n                // ARIA (updates aria attributes)\n                this.header.attr({\n                    'aria-selected': false\n                });\n            } else if (this.options.disabled) {\n                this.disable();\n            } else {\n                this.content.hide();\n\n                if (this.options.closedState) {\n                    this.element.addClass(this.options.closedState);\n                }\n            }\n        },\n\n        /**\n         * Processing the state:\n         *     If deep linking is used and the anchor is the id of the content or the content contains this id,\n         *     and the collapsible element is a nested one having collapsible parents, in order to see the content,\n         *     all the parents must be expanded.\n         * @private\n         */\n        _processState: function () {\n            var anchor = window.location.hash,\n                isValid = $.mage.isValidSelector(anchor),\n                urlPath = window.location.pathname.replace('.', ''),\n                state;\n\n            this.stateKey = encodeURIComponent(urlPath + this.element.attr('id'));\n\n            if (isValid &&\n                ($(this.content.find(anchor)).length > 0 || this.content.attr('id') === anchor.replace('#', ''))\n            ) {\n                this.element.parents('[data-collapsible=true]').collapsible('forceActivate');\n\n                if (!this.options.disabled) {\n                    this.options.active = true;\n\n                    if (this.options.saveState) { //eslint-disable-line max-depth\n                        this.storage.set(this.stateKey, true);\n                    }\n                }\n            } else if (this.options.saveState && !this.options.disabled) {\n                state = this.storage.get(this.stateKey);\n\n                if (typeof state === 'undefined' || state === null) {\n                    this.storage.set(this.stateKey, this.options.active);\n                } else if (state === true) {\n                    this.options.active = true;\n                } else if (state === false) {\n                    this.options.active = false;\n                }\n            }\n        },\n\n        /**\n         * @private\n         */\n        _createIcons: function () {\n            var icons = this.options.icons;\n\n            if (icons) {\n                $('<span>')\n                    .addClass(icons.header)\n                    .attr('data-role', 'icons')\n                    .prependTo(this.header);\n\n                if (this.options.active && !this.options.disabled) {\n                    this.header.children('[data-role=icons]')\n                        .removeClass(icons.header)\n                        .addClass(icons.activeHeader);\n                }\n            }\n        },\n\n        /**\n         * @private\n         */\n        _destroyIcons: function () {\n            this.header\n                .children('[data-role=icons]')\n                .remove();\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            var options = this.options;\n\n            this.element.removeAttr('data-collapsible');\n\n            this.trigger.removeAttr('tabIndex');\n\n            if (options.openedState) {\n                this.element.removeClass(options.openedState);\n            }\n\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).removeClass(this.options.collateral.openedState);\n            }\n\n            if (options.closedState) {\n                this.element.removeClass(options.closedState);\n            }\n\n            if (options.disabledState) {\n                this.element.removeClass(options.disabledState);\n            }\n\n            if (this.icons) {\n                this._destroyIcons();\n            }\n        },\n\n        /**\n         * @private\n         */\n        _processPanels: function () {\n            var headers, triggers;\n\n            this.element.attr('data-collapsible', 'true');\n\n            if (typeof this.options.header === 'object') {\n                this.header = this.options.header;\n            } else {\n                headers = this.element.find(this.options.header);\n\n                if (headers.length > 0) {\n                    this.header = headers.eq(0);\n                } else {\n                    this.header = this.element;\n                }\n            }\n\n            if (typeof this.options.content === 'object') {\n                this.content = this.options.content;\n            } else {\n                this.content = this.header.next(this.options.content).eq(0);\n            }\n\n            // ARIA (init aria attributes)\n            if (this.header.attr('id')) {\n                this.content.attr('aria-labelledby', this.header.attr('id'));\n            }\n\n            if (this.content.attr('id')) {\n                this.header.attr('aria-controls', this.content.attr('id'));\n            }\n\n            this.header\n                .attr({\n                    'role': 'tab',\n                    'aria-selected': this.options.active,\n                    'aria-expanded': this.options.active\n                });\n\n            // For collapsible widget only (not tabs or accordion)\n            if (this.header.parent().attr('role') != 'presentation') { //eslint-disable-line eqeqeq\n                this.header\n                    .parent()\n                    .attr('role', 'tablist');\n            }\n\n            this.content.attr({\n                'role': 'tabpanel',\n                'aria-hidden': !this.options.active\n            });\n\n            if (typeof this.options.trigger === 'object') {\n                this.trigger = this.options.trigger;\n            } else {\n                triggers = this.header.find(this.options.trigger);\n\n                if (triggers.length > 0) {\n                    this.trigger = triggers.eq(0);\n                } else {\n                    this.trigger = this.header;\n                }\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _keydown: function (event) {\n            var keyCode;\n\n            if (event.altKey || event.ctrlKey) {\n                return;\n            }\n\n            keyCode = $.ui.keyCode;\n\n            switch (event.keyCode) {\n                case keyCode.SPACE:\n                case keyCode.ENTER:\n                    this._eventHandler(event);\n                    break;\n            }\n\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _bind: function (event) {\n            var self = this;\n\n            this.events = {\n                keydown: '_keydown'\n            };\n\n            if (event) {\n                $.each(event.split(' '), function (index, eventName) {\n                    self.events[ eventName ] = '_eventHandler';\n                });\n            }\n            this._off(this.trigger);\n\n            if (!this.options.disabled) {\n                this._on(this.trigger, this.events);\n            }\n        },\n\n        /**\n         * Disable.\n         */\n        disable: function () {\n            this._off(this.trigger);\n            this.forceDeactivate();\n            this.options.disabled = true;\n\n            if (this.options.disabledState) {\n                this.element.addClass(this.options.disabledState);\n            }\n            this.trigger.attr('tabIndex', -1);\n        },\n\n        /**\n         * Enable.\n         */\n        enable: function () {\n            this._on(this.trigger, this.events);\n            this.options.disabled = false;\n\n            if (this.options.disabledState) {\n                this.element.removeClass(this.options.disabledState);\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _eventHandler: function (event) {\n\n            if (this.options.active && this.options.collapsible) {\n                this.deactivate();\n            } else {\n                this.activate();\n\n            }\n            event.preventDefault();\n\n        },\n\n        /**\n         * @param {*} prop\n         * @private\n         */\n        _animate: function (prop) {\n            var duration,\n                easing,\n                animate = this.options.animate;\n\n            if (typeof animate === 'number') {\n                duration = animate;\n            }\n\n            if (typeof animate === 'string') {\n                animate = $.parseJSON(animate);\n            }\n            duration = duration || animate.duration;\n            easing = animate.easing;\n            this.content.animate(prop, duration, easing);\n        },\n\n        /**\n         * Deactivate.\n         */\n        deactivate: function () {\n            if (this.options.animate) {\n                this._animate(hideProps);\n            } else {\n                this.content.hide();\n            }\n            this._close();\n        },\n\n        /**\n         * Force deactivate.\n         */\n        forceDeactivate: function () {\n            this.content.hide();\n            this._close();\n\n        },\n\n        /**\n         * @private\n         */\n        _close: function () {\n            this.options.active = false;\n\n            if (this.options.saveState) {\n                this.storage.set(this.stateKey, false);\n            }\n\n            if (this.options.openedState) {\n                this.element.removeClass(this.options.openedState);\n            }\n\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).removeClass(this.options.collateral.openedState);\n            }\n\n            if (this.options.closedState) {\n                this.element.addClass(this.options.closedState);\n            }\n\n            if (this.icons) {\n                this.header.children('[data-role=icons]')\n                    .removeClass(this.options.icons.activeHeader)\n                    .addClass(this.options.icons.header);\n            }\n\n            // ARIA (updates aria attributes)\n            this.header.attr({\n                'aria-selected': 'false',\n                'aria-expanded': 'false'\n            });\n            this.content.attr({\n                'aria-hidden': 'true'\n            });\n\n            this.element.trigger('dimensionsChanged', {\n                opened: false\n            });\n        },\n\n        /**\n         * Activate.\n         */\n        activate: function () {\n            if (!this.options.disabled) {\n                if (this.options.animate) {\n                    this._animate(showProps);\n                } else {\n                    this.content.show();\n                }\n                this._open();\n            }\n        },\n\n        /**\n         * Force activate.\n         */\n        forceActivate: function () {\n            if (!this.options.disabled) {\n                this.content.show();\n                this._open();\n            }\n        },\n\n        /**\n         * @private\n         */\n        _open: function () {\n            this.element.trigger('beforeOpen');\n            this.options.active = true;\n\n            if (this.options.ajaxContent) {\n                this._loadContent();\n            }\n\n            if (this.options.saveState) {\n                this.storage.set(this.stateKey, true);\n            }\n\n            if (this.options.openedState) {\n                this.element.addClass(this.options.openedState);\n            }\n\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).addClass(this.options.collateral.openedState);\n            }\n\n            if (this.options.closedState) {\n                this.element.removeClass(this.options.closedState);\n            }\n\n            if (this.icons) {\n                this.header.children('[data-role=icons]')\n                    .removeClass(this.options.icons.header)\n                    .addClass(this.options.icons.activeHeader);\n            }\n\n            // ARIA (updates aria attributes)\n            this.header.attr({\n                'aria-selected': 'true',\n                'aria-expanded': 'true'\n            });\n            this.content.attr({\n                'aria-hidden': 'false'\n            });\n\n            this.element.trigger('dimensionsChanged', {\n                opened: true\n            });\n        },\n\n        /**\n         * @private\n         */\n        _loadContent: function () {\n            var url = this.element.find(this.options.ajaxUrlElement).attr('href'),\n                that = this;\n\n            if (url) {\n                this.xhr = $.get({\n                    url: url,\n                    dataType: 'html'\n                }, function () {\n                });\n            }\n\n            if (that.xhr && that.xhr.statusText !== 'canceled') {\n                if (that.options.loadingClass) {\n                    that.element.addClass(that.options.loadingClass);\n                }\n                that.content.attr('aria-busy', 'true');\n                that.xhr.success(function (response) {\n                    setTimeout(function () {\n                        that.content.html(response);\n                    }, 1);\n                }).complete(function (jqXHR, status) {\n                    setTimeout(function () {\n                        if (status === 'abort') {\n                            that.content.stop(false, true);\n                        }\n\n                        if (that.options.loadingClass) {\n                            that.element.removeClass(that.options.loadingClass);\n                        }\n                        that.content.removeAttr('aria-busy');\n\n                        if (jqXHR === that.xhr) {\n                            delete that.xhr;\n                        }\n                    }, 1);\n                });\n            }\n        }\n    });\n\n    return $.mage.collapsible;\n});\n","mage/fieldset-controls.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    /**\n     * This widget will allow a control with the fieldsetResetControl widget attached to reset a set of input fields.\n     * The input fields to reset are defined by the inputSelector selector. The widget will store a clone of the fields\n     * on create, and on trigger of fieldsetReset event it resets the defined fields. The event is triggered by the\n     * reset control widget.\n     *\n     * For inputs of type file, the whole dom element is replaced as changing the value is a security violation\n     * For inputs of type checkbox or radio, the checked attribute is added or removed as appropriate\n     * For all others the jquery .val method is used to update to value to the original.\n     */\n    $.widget('mage.fieldsetControls', {\n        original: undefined,\n        options: {\n            inputSelector: '[data-reset=\"true\"]'\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.original = this.element.find(this.options.inputSelector).clone(true);\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this._on({\n                'fieldsetReset': '_onReset'\n            });\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _onReset: function (e) {\n            var items;\n\n            e.stopPropagation();\n            // find all the ones we have to remove\n            items = this.element.find(this.options.inputSelector);\n            // loop over replacing each one.\n            items.each($.proxy(function (index, item) {\n                if ($(item).attr('type') == 'file') { //eslint-disable-line eqeqeq\n                    // Replace the current one we found with a clone of the original saved earlier\n                    $(item).replaceWith($(this.original[index]).clone(true));\n                } else if ($(item).attr('type') == 'checkbox' || $(item).attr('type') == 'radio') { //eslint-disable-line\n                    // Return to original state.\n                    if ($(this.original[index]).attr('checked') === undefined) {\n                        $(item).removeAttr('checked');\n                    } else {\n                        $(item).attr('checked', $(this.original[index]).attr('checked'));\n                    }\n                } else {\n                    // Replace the value with the original\n                    $(item).val($(this.original[index]).val());\n                }\n            }, this));\n        }\n    });\n\n    $.widget('mage.fieldsetResetControl', {\n        /**\n         * @private\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this._on({\n                click: '_onClick'\n            });\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _onClick: function (e) {\n            e.stopPropagation();\n            $(this.element).trigger('fieldsetReset');\n        }\n    });\n\n    return {\n        fieldsetControls: $.mage.fieldsetControls,\n        fieldsetResetControl: $.mage.fieldsetResetControl\n    };\n});\n","mage/multiselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'text!mage/multiselect.html',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'jquery/editableMultiselect/js/jquery.multiselect'\n], function (_, $, searchTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.multiselect2', {\n        options: {\n            mselectContainer: 'section.mselect-list',\n            mselectItemsWrapperClass: 'mselect-items-wrapper',\n            mselectCheckedClass: 'mselect-checked',\n            containerClass: 'paginated',\n            searchInputClass: 'admin__action-multiselect-search',\n            selectedItemsCountClass: 'admin__action-multiselect-items-selected',\n            currentPage: 1,\n            lastAppendValue: 0,\n            updateDelay: 1000,\n            optionsLoaded: false\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            $.fn.multiselect.call(this.element, this.options);\n        },\n\n        /** @inheritdoc */\n        _init: function () {\n            this.domElement = this.element.get(0);\n\n            this.$container = $(this.options.mselectContainer);\n            this.$wrapper = this.$container.find('.' + this.options.mselectItemsWrapperClass);\n            this.$item = this.$wrapper.find('div').first();\n            this.selectedValues = [];\n            this.values = {};\n\n            this.$container.addClass(this.options.containerClass).prepend(searchTemplate);\n            this.$input = this.$container.find('.' + this.options.searchInputClass);\n            this.$selectedCounter = this.$container.find('.' + this.options.selectedItemsCountClass);\n            this.filter = '';\n\n            if (this.domElement.options.length) {\n                this._setLastAppendOption(this.domElement.options[this.domElement.options.length - 1].value);\n            }\n\n            this._initElement();\n            this._events();\n        },\n\n        /**\n         * Leave only saved/selected options in select element.\n         *\n         * @private\n         */\n        _initElement: function () {\n            this.element.empty();\n            _.each(this.options.selectedValues, function (value) {\n                this._createSelectedOption({\n                    value: value,\n                    label: value\n                });\n            }, this);\n        },\n\n        /**\n         * Attach required events.\n         *\n         * @private\n         */\n        _events: function () {\n            var onKeyUp = _.debounce(this.onKeyUp, this.options.updateDelay);\n\n            _.bindAll(this, 'onScroll', 'onCheck', 'onOptionsChange');\n\n            this.$wrapper.on('scroll', this.onScroll);\n            this.$wrapper.on('change.mselectCheck', '[type=checkbox]', this.onCheck);\n            this.$input.on('keyup', _.bind(onKeyUp, this));\n            this.element.on('change.hiddenSelect', this.onOptionsChange);\n        },\n\n        /**\n         * Behaves multiselect scroll.\n         */\n        onScroll: function () {\n            var height = this.$wrapper.height(),\n                scrollHeight = this.$wrapper.prop('scrollHeight'),\n                scrollTop = Math.ceil(this.$wrapper.prop('scrollTop'));\n\n            if (!this.options.optionsLoaded && scrollHeight - height <= scrollTop) {\n                this.loadOptions();\n            }\n        },\n\n        /**\n         * Behaves keyup event on input search\n         */\n        onKeyUp: function () {\n            if (this.getSearchCriteria() === this.filter) {\n                return false;\n            }\n\n            this.setFilter();\n            this.clearMultiselectOptions();\n            this.setCurrentPage(0);\n            this.loadOptions();\n        },\n\n        /**\n         * Callback for select change event\n         */\n        onOptionsChange: function () {\n            this.selectedValues = _.map(this.domElement.options, function (option) {\n                this.values[option.value] = true;\n\n                return option.value;\n            }, this);\n\n            this._updateSelectedCounter();\n        },\n\n        /**\n         * Overrides native check behaviour.\n         *\n         * @param {Event} event\n         */\n        onCheck: function (event) {\n            var checkbox = event.target,\n                option = {\n                    value: checkbox.value,\n                    label: $(checkbox).parent('label').text()\n                };\n\n            checkbox.checked ? this._createSelectedOption(option) : this._removeSelectedOption(option);\n            event.stopPropagation();\n        },\n\n        /**\n         * Show error message.\n         *\n         * @param {String} message\n         */\n        onError: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Updates current filter state.\n         */\n        setFilter: function () {\n            this.filter = this.getSearchCriteria() || '';\n        },\n\n        /**\n         * Reads search input value.\n         *\n         * @return {String}\n         */\n        getSearchCriteria: function () {\n            return $.trim(this.$input.val());\n        },\n\n        /**\n         * Load options data.\n         */\n        loadOptions: function () {\n            var nextPage = this.getCurrentPage() + 1;\n\n            this.$wrapper.trigger('processStart');\n            this.$input.prop('disabled', true);\n\n            $.get(this.options.nextPageUrl, {\n                p: nextPage,\n                s: this.filter\n            })\n            .done(function (response) {\n                if (response.success) {\n                    this.appendOptions(response.result);\n                    this.setCurrentPage(nextPage);\n                } else {\n                    this.onError(response.errorMessage);\n                }\n            }.bind(this))\n            .always(function () {\n                this.$wrapper.trigger('processStop');\n                this.$input.prop('disabled', false);\n\n                if (this.filter) {\n                    this.$input.focus();\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Append loaded options\n         *\n         * @param {Array} options\n         */\n        appendOptions: function (options) {\n            var divOptions = [];\n\n            if (!options.length) {\n                return false;\n            }\n\n            if (this.isOptionsLoaded(options)) {\n                return;\n            }\n\n            options.forEach(function (option) {\n                if (!this.values[option.value]) {\n                    this.values[option.value] = true;\n                    option.selected = this._isOptionSelected(option);\n                    divOptions.push(this._createMultiSelectOption(option));\n                    this._setLastAppendOption(option.value);\n                }\n            }, this);\n\n            this.$wrapper.append(divOptions);\n        },\n\n        /**\n         * Clear multiselect options\n         */\n        clearMultiselectOptions: function () {\n            this._setLastAppendOption(0);\n            this.values = {};\n            this.$wrapper.empty();\n        },\n\n        /**\n         * Checks if all options are already loaded\n         *\n         * @return {Boolean}\n         */\n        isOptionsLoaded: function (options) {\n            this.options.optionsLoaded = this.options.lastAppendValue === options[options.length - 1].value;\n\n            return this.options.optionsLoaded;\n        },\n\n        /**\n         * Setter for current page.\n         *\n         * @param {Number} page\n         */\n        setCurrentPage: function (page) {\n            this.options.currentPage = page;\n        },\n\n        /**\n         * Getter for current page.\n         *\n         * @return {Number}\n         */\n        getCurrentPage: function () {\n            return this.options.currentPage;\n        },\n\n        /**\n         * Creates new selected option for select element\n         *\n         * @param {Object} option - option object\n         * @param {String} option.value - option value\n         * @param {String} option.label - option label\n         * @private\n         */\n        _createSelectedOption: function (option) {\n            var selectOption = 