require.config({"config": {
        "jsbuild":{"Magento_Catalog/js/price-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery/ui'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        optionTemplate: '<%= data.label %>' +\n        '<% if (data.finalPrice.value) { %>' +\n        ' +<%- data.finalPrice.formatted %>' +\n        '<% } %>',\n        controlContainer: 'dd'\n    };\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig) {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            $(this.options.optionsSelector, this.element).trigger('change');\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions() {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            this._applyOptionNodeFix(options);\n\n            options.on('change', this._onOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event) {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionConfig = config.optionConfig && config.optionConfig[optionId];\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue] ? optionConfig[optionValue].prices : null;\n\n                    if (prices) {\n                        _.each(prices, function (price, type) {\n                            var value = +price.amount;\n\n                            value += _.reduce(price.adjustments, function (sum, x) { //eslint-disable-line\n                                return sum + x;\n                            }, 0);\n                            toTemplate.data[type] = {\n                                value: value,\n                                formatted: utils.formatPrice(value, format)\n                            };\n                        });\n\n                        $option.text(template(toTemplate));\n                    }\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         * @private\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n            this._super(options);\n\n            return this;\n        }\n    });\n\n    return $.mage.priceOptions;\n});\n","Magento_Catalog/js/price-option-file.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.priceOptionFile', {\n        options: {\n            fileName: '',\n            fileNamed: '',\n            fieldNameAction: '',\n            changeFileSelector: '',\n            deleteFileSelector: ''\n        },\n\n        /**\n         * Creates instance of widget\n         * @private\n         */\n        _create: function () {\n            this.fileDeleteFlag = this.fileChangeFlag = false;\n            this.inputField = this.element.find('input[name=' + this.options.fileName + ']')[0];\n            this.inputFieldAction = this.element.find('input[name=' + this.options.fieldNameAction + ']')[0];\n            this.fileNameSpan = this.element.parent('dd').find('.' + this.options.fileNamed);\n\n            $(this.options.changeFileSelector).on('click', $.proxy(function () {\n                this._toggleFileChange();\n            }, this));\n            $(this.options.deleteFileSelector).on('click', $.proxy(function () {\n                this._toggleFileDelete();\n            }, this));\n        },\n\n        /**\n         * Toggles whether the current file is being changed or not. If the file is being deleted\n         * then the option to change the file is disabled.\n         * @private\n         */\n        _toggleFileChange: function () {\n            this.element.toggle();\n            this.fileChangeFlag = !this.fileChangeFlag;\n\n            if (!this.fileDeleteFlag) {\n                $(this.inputFieldAction).attr('value', this.fileChangeFlag ? 'save_new' : 'save_old');\n                this.inputField.disabled = !this.fileChangeFlag;\n            }\n        },\n\n        /**\n         * Toggles whether the file is to be deleted. When the file is being deleted, the name of\n         * the file is decorated with strike-through text and the option to change the file is\n         * disabled.\n         * @private\n         */\n        _toggleFileDelete: function () {\n            this.fileDeleteFlag = $(this.options.deleteFileSelector + ':checked').val();\n            $(this.inputFieldAction).attr('value',\n                this.fileDeleteFlag ? '' : this.fileChangeFlag ? 'save_new' : 'save_old');\n            this.inputField.disabled = this.fileDeleteFlag || !this.fileChangeFlag;\n            this.fileNameSpan.css('text-decoration', this.fileDeleteFlag ? 'line-through' : 'none');\n        }\n    });\n\n    return $.mage.priceOptionFile;\n});\n","Magento_Catalog/js/catalog-add-to-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'jquery/ui'\n], function ($, $t) {\n    'use strict';\n\n    $.widget('mage.catalogAddToCart', {\n        options: {\n            processStart: null,\n            processStop: null,\n            bindSubmit: true,\n            minicartSelector: '[data-block=\"minicart\"]',\n            messagesSelector: '[data-placeholder=\"messages\"]',\n            productStatusSelector: '.stock.available',\n            addToCartButtonSelector: '.action.tocart',\n            addToCartButtonDisabledClass: 'disabled',\n            addToCartButtonTextWhileAdding: '',\n            addToCartButtonTextAdded: '',\n            addToCartButtonTextDefault: ''\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            if (this.options.bindSubmit) {\n                this._bindSubmit();\n            }\n        },\n\n        /**\n         * @private\n         */\n        _bindSubmit: function () {\n            var self = this;\n\n            this.element.on('submit', function (e) {\n                e.preventDefault();\n                self.submitForm($(this));\n            });\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isLoaderEnabled: function () {\n            return this.options.processStart && this.options.processStop;\n        },\n\n        /**\n         * Handler for the form 'submit' event\n         *\n         * @param {Object} form\n         */\n        submitForm: function (form) {\n            var addToCartButton, self = this;\n\n            if (form.has('input[type=\"file\"]').length && form.find('input[type=\"file\"]').val() !== '') {\n                self.element.off('submit');\n                // disable 'Add to Cart' button\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n                addToCartButton.prop('disabled', true);\n                addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n                form.submit();\n            } else {\n                self.ajaxSubmit(form);\n            }\n        },\n\n        /**\n         * @param {String} form\n         */\n        ajaxSubmit: function (form) {\n            var self = this;\n\n            $(self.options.minicartSelector).trigger('contentLoading');\n            self.disableAddToCartButton(form);\n\n            $.ajax({\n                url: form.attr('action'),\n                data: form.serialize(),\n                type: 'post',\n                dataType: 'json',\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStart);\n                    }\n                },\n\n                /** @inheritdoc */\n                success: function (res) {\n                    var eventData, parameters;\n\n                    $(document).trigger('ajax:addToCart', form.data().productSku);\n\n                    if (self.isLoaderEnabled()) {\n                        $('body').trigger(self.options.processStop);\n                    }\n\n                    if (res.backUrl) {\n                        eventData = {\n                            'form': form,\n                            'redirectParameters': []\n                        };\n                        // trigger global event, so other modules will be able add parameters to redirect url\n                        $('body').trigger('catalogCategoryAddToCartRedirect', eventData);\n\n                        if (eventData.redirectParameters.length > 0) {\n                            parameters = res.backUrl.split('#');\n                            parameters.push(eventData.redirectParameters.join('&'));\n                            res.backUrl = parameters.join('#');\n                        }\n                        window.location = res.backUrl;\n\n                        return;\n                    }\n\n                    if (res.messages) {\n                        $(self.options.messagesSelector).html(res.messages);\n                    }\n\n                    if (res.minicart) {\n                        $(self.options.minicartSelector).replaceWith(res.minicart);\n                        $(self.options.minicartSelector).trigger('contentUpdated');\n                    }\n\n                    if (res.product && res.product.statusText) {\n                        $(self.options.productStatusSelector)\n                            .removeClass('available')\n                            .addClass('unavailable')\n                            .find('span')\n                            .html(res.product.statusText);\n                    }\n                    self.enableAddToCartButton(form);\n                }\n            });\n        },\n\n        /**\n         * @param {String} form\n         */\n        disableAddToCartButton: function (form) {\n            var addToCartButtonTextWhileAdding = this.options.addToCartButtonTextWhileAdding || $t('Adding...'),\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.addClass(this.options.addToCartButtonDisabledClass);\n            addToCartButton.find('span').text(addToCartButtonTextWhileAdding);\n            addToCartButton.attr('title', addToCartButtonTextWhileAdding);\n        },\n\n        /**\n         * @param {String} form\n         */\n        enableAddToCartButton: function (form) {\n            var addToCartButtonTextAdded = this.options.addToCartButtonTextAdded || $t('Added'),\n                self = this,\n                addToCartButton = $(form).find(this.options.addToCartButtonSelector);\n\n            addToCartButton.find('span').text(addToCartButtonTextAdded);\n            addToCartButton.attr('title', addToCartButtonTextAdded);\n\n            setTimeout(function () {\n                var addToCartButtonTextDefault = self.options.addToCartButtonTextDefault || $t('Add to Cart');\n\n                addToCartButton.removeClass(self.options.addToCartButtonDisabledClass);\n                addToCartButton.find('span').text(addToCartButtonTextDefault);\n                addToCartButton.attr('title', addToCartButtonTextDefault);\n            }, 1000);\n        }\n    });\n\n    return $.mage.catalogAddToCart;\n});\n","Magento_Catalog/js/price-utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var globalPriceFormat = {\n        requiredPrecision: 2,\n        integerRequired: 1,\n        decimalSymbol: ',',\n        groupSymbol: ',',\n        groupLength: ','\n    };\n\n    /**\n     * Repeats {string} {times} times\n     * @param  {String} string\n     * @param  {Number} times\n     * @return {String}\n     */\n    function stringPad(string, times) {\n        return (new Array(times + 1)).join(string);\n    }\n\n    /**\n     * Formatter for price amount\n     * @param  {Number}  amount\n     * @param  {Object}  format\n     * @param  {Boolean} isShowSign\n     * @return {String}              Formatted value\n     */\n    function formatPrice(amount, format, isShowSign) {\n        var s = '',\n            precision, integerRequired, decimalSymbol, groupSymbol, groupLength, pattern, i, pad, j, re, r, am;\n\n        format = _.extend(globalPriceFormat, format);\n\n        // copied from price-option.js | Could be refactored with varien/js.js\n\n        precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision;\n        integerRequired = isNaN(format.integerRequired = Math.abs(format.integerRequired)) ? 1 : format.integerRequired;\n        decimalSymbol = format.decimalSymbol === undefined ? ',' : format.decimalSymbol;\n        groupSymbol = format.groupSymbol === undefined ? '.' : format.groupSymbol;\n        groupLength = format.groupLength === undefined ? 3 : format.groupLength;\n        pattern = format.pattern || '%s';\n\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : isShowSign ? '+' : '';\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n\n        // we're avoiding the usage of to fixed, and using round instead with the e representation to address\n        // numbers like 1.005 = 1.01. Using ToFixed to only provide trailig zeroes in case we have a whole number\n        i = parseInt(\n                amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision)),\n                10\n            ) + '';\n        pad = i.length < integerRequired ? integerRequired - i.length : 0;\n\n        i = stringPad('0', pad) + i;\n\n        j = i.length > groupLength ? i.length % groupLength : 0;\n        re = new RegExp('(\\\\d{' + groupLength + '})(?=\\\\d)', 'g');\n\n        // replace(/-/, 0) is only for fixing Safari bug which appears\n        // when Math.abs(0).toFixed() executed on '0' number.\n        // Result is '0.-0' :(\n\n        am = Number(Math.round(Math.abs(amount - i) + 'e+' + precision) + ('e-' + precision));\n        r = (j ? i.substr(0, j) + groupSymbol : '') +\n            i.substr(j).replace(re, '$1' + groupSymbol) +\n            (precision ? decimalSymbol + am.toFixed(2).replace(/-/, 0).slice(2) : '');\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Deep clone of Object. Doesn't support functions\n     * @param {Object} obj\n     * @return {Object}\n     */\n    function objectDeepClone(obj) {\n        return JSON.parse(JSON.stringify(obj));\n    }\n\n    /**\n     * Helper to find ID in name attribute\n     * @param   {jQuery} element\n     * @returns {undefined|String}\n     */\n    function findOptionId(element) {\n        var re, id, name;\n\n        if (!element) {\n            return id;\n        }\n        name = $(element).attr('name');\n\n        if (name.indexOf('[') !== -1) {\n            re = /\\[([^\\]]+)?\\]/;\n        } else {\n            re = /_([^\\]]+)?_/; // just to support file-type-option\n        }\n        id = re.exec(name) && re.exec(name)[1];\n\n        if (id) {\n            return id;\n        }\n    }\n\n    return {\n        formatPrice: formatPrice,\n        deepClone: objectDeepClone,\n        strPad: stringPad,\n        findOptionId: findOptionId\n    };\n});\n","Magento_Catalog/js/storage-manager.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    'mageUtils',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/section-config',\n    'jquery'\n], function (_, Element, utils, storage, sectionConfig, $) {\n    'use strict';\n\n    /**\n     * Flush events, that are clones of the same customer data sections\n     * Events listener\n     */\n    $(document).on('submit', function (event) {\n        var sections;\n\n        if (event.target.method.match(/post|put|delete/i)) {\n            sections = sectionConfig.getAffectedSections(event.target.action);\n\n            if (sections && window.localStorage) {\n                _.each(sections, function (section) {\n                    window.localStorage.removeItem(section);\n                });\n            }\n        }\n    });\n\n    return Element.extend({\n        defaults: {\n            defaultNamespace: {\n                lifetime: 1000\n            },\n            storagesConfiguration: {\n                'recently_viewed_product': {\n                    namespace: 'recently_viewed_product',\n                    className: 'IdsStorage',\n                    lifetime: '${ $.defaultNamespace.lifetime }',\n                    requestConfig: {\n                        typeId: '${ $.storagesConfiguration.recently_viewed_product.namespace }'\n                    },\n                    savePrevious: {\n                        namespace: '${ $.storagesConfiguration.recently_viewed_product.namespace }' + '_previous',\n                        className: '${ $.storagesConfiguration.recently_viewed_product.className }'\n                    },\n                    allowToSendRequest: 0\n                },\n                'recently_compared_product': {\n                    namespace: 'recently_compared_product',\n                    className: 'IdsStorageCompare',\n                    provider: 'compare-products',\n                    lifetime: '${ $.defaultNamespace.lifetime }',\n                    requestConfig: {\n                        typeId: '${ $.storagesConfiguration.recently_compared_product.namespace }'\n                    },\n                    savePrevious: {\n                        namespace: '${ $.storagesConfiguration.recently_compared_product.namespace }' + '_previous',\n                        className: '${ $.storagesConfiguration.recently_compared_product.className }'\n                    },\n                    allowToSendRequest: 0\n                },\n                'product_data_storage': {\n                    namespace: 'product_data_storage',\n                    className: 'DataStorage',\n                    allowToSendRequest: 0,\n                    updateRequestConfig: {\n                        url: '',\n                        method: 'GET',\n                        dataType: 'json'\n                    }\n                }\n            },\n            requestConfig: {\n                method: 'POST',\n                dataType: 'json',\n                ajaxSaveType: 'default',\n                ignoreProcessEvents: true\n            },\n            requestSent: 0\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .prepareStoragesConfig()\n                .initStorages()\n                .initStartData()\n                .initUpdateStorageDataListener();\n\n            return this;\n        },\n\n        /**\n         * Initializes storages.\n         *\n         * @returns {Object} Chainable.\n         */\n        initStorages: function () {\n            _.each(this.storagesNamespace, function (name) {\n                this[name] = storage.createStorage(this.storagesConfiguration[name]);\n\n                if (this.storagesConfiguration[name].savePrevious) {\n                    this[name].previous = storage.createStorage(this.storagesConfiguration[name].savePrevious);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes start data.\n         *\n         * @returns {Object} Chainable.\n         */\n        initStartData: function () {\n            _.each(this.storagesNamespace, function (name) {\n                this.updateDataHandler(name, this[name].get());\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Prepare storages congfig.\n         *\n         * @returns {Object} Chainable.\n         */\n        prepareStoragesConfig: function () {\n            this.storagesNamespace = _.keys(this.storagesConfiguration);\n\n            _.each(this.storagesNamespace, function (name) {\n                this.storagesConfiguration[name].requestConfig = _.extend(\n                    utils.copy(this.requestConfig),\n                    this.storagesConfiguration[name].requestConfig\n                );\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Prepare date in UTC format (in GMT), and calculate unix timestamp based in seconds\n         *\n         * @returns {Number}\n         * @private\n         */\n        getUtcTime: function () {\n            return new Date().getTime() / 1000;\n        },\n\n        /**\n         * Initializes listeners to storages \"data\" property.\n         */\n        initUpdateStorageDataListener: function () {\n            _.each(this.storagesNamespace, function (name) {\n                this[name].data.subscribe(this.updateDataHandler.bind(this, name));\n            }.bind(this));\n        },\n\n        /**\n         * Handlers for storages \"data\" property\n         */\n        updateDataHandler: function (name, data) {\n            var previousData = this[name].previous ? this[name].previous.get() : false;\n\n            if (!_.isEmpty(previousData) &&\n                !_.isEmpty(data) &&\n                !utils.compare(data, previousData).equal) {\n                this[name].set(data);\n                this[name].previous.set(data);\n                this.sendRequest(name, data);\n            } else if (\n                _.isEmpty(previousData) &&\n                !_.isEmpty(data)\n            ) {\n                this[name].set(data);\n                this.sendRequest(name, data);\n            }\n        },\n\n        /**\n         * Gets last updated time\n         *\n         * @param {String} name - storage name\n         */\n        getLastUpdate: function (name) {\n            return window.localStorage.getItem(this[name].namespace + '_last_update');\n        },\n\n        /**\n         * Sets last updated time\n         *\n         * @param {String} name - storage name\n         */\n        setLastUpdate: function (name) {\n            window.localStorage.setItem(this[name].namespace + '_last_update', this.getUtcTime());\n        },\n\n        /**\n         * Request handler\n         *\n         * @param {String} name - storage name\n         */\n        requestHandler: function (name) {\n            this.setLastUpdate(name);\n            this.requestSent = 1;\n        },\n\n        /**\n         * Sends request to server to gets data\n         *\n         * @param {String} name - storage name\n         * @param {Object} data - ids\n         */\n        sendRequest: function (name, data) {\n            var params  = utils.copy(this.storagesConfiguration[name].requestConfig),\n                url = params.syncUrl,\n                typeId = params.typeId;\n\n            if (this.requestSent || !~~this.storagesConfiguration[name].allowToSendRequest) {\n                return;\n            }\n\n            delete params.typeId;\n            delete params.url;\n\n            return utils.ajaxSubmit({\n                url: url,\n                data: {\n                    ids: data,\n                    'type_id': typeId\n                }\n            }, params).done(this.requestHandler.bind(this, name));\n        }\n    });\n});\n","Magento_Catalog/js/view/compare-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'jquery',\n    'mage/mage',\n    'mage/decorate'\n], function (Component, customerData, $) {\n    'use strict';\n\n    var sidebarInitialized = false;\n\n    /**\n     * Initialize sidebar\n     */\n    function initSidebar() {\n        if (sidebarInitialized) {\n            return;\n        }\n\n        sidebarInitialized = true;\n        $('[data-role=compare-products-sidebar]').decorate('list', true);\n    }\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.compareProducts = customerData.get('compare-products');\n\n            initSidebar();\n        }\n    });\n});\n","Magento_Catalog/js/view/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.template = window.checkout.imageTemplate || this.template;\n        }\n    });\n});\n","Magento_Catalog/js/product/provider-compared.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    './provider',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/customer-data'\n], function (_, Provider, storage, customerData) {\n    'use strict';\n\n    return Provider.extend({\n\n        /**\n         * Ids update handler\n         *\n         * @param {Object} data\n         */\n        idsHandler: function (data) {\n            this.productStorage.setIds(this.data.currency, this.data.store, this.dataFilter(data));\n        },\n\n        /**\n         * Filters data by provider\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        dataFilter: function (data) {\n            var providerData = this.idsStorage.prepareData(customerData.get(this.identifiersConfig.provider)().items),\n                result = {};\n\n            _.each(data, function (value, key) {\n                if (!providerData[key]) {\n                    result[key] = value;\n                }\n            });\n\n            return result;\n        },\n\n        /**\n         * Filters data from product storage by ids\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var result = {},\n                i = 0,\n                ids = _.keys(this.dataFilter(this.ids())),\n                length = ids.length;\n\n            for (i; i < length; i++) {\n                if (ids[i] && data[ids[i]]) {\n                    result[ids[i]] = data[ids[i]];\n                }\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/name.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        /**\n         * Depends on this option, product name can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'name', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/uenc-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n        'use strict';\n\n        /**\n         * Check data to JSON.\n         *\n         * @returns {Boolean}\n         */\n        function _isJSON(data) {\n            try {\n                JSON.parse(data);\n            } catch (e) {\n                return false;\n            }\n\n            return true;\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         * @param {String} uenc\n         *\n         * @returns {String}\n         */\n        function _stringProcessor(data, placeholder, uenc) {\n            if (data && ~data.indexOf(placeholder)) {\n                return data.replace(placeholder, uenc);\n            }\n\n            return data;\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         * @param {String} uenc\n         *\n         * @returns {String}\n         */\n        function _objectProcessor(data, placeholder, uenc) {\n            data = JSON.parse(data);\n\n            if (data.hasOwnProperty('action')) {\n                data.action = _stringProcessor(data.action, placeholder, uenc);\n            }\n\n            if (data.hasOwnProperty('data') && data.data.hasOwnProperty('uenc')) {\n                data.data.uenc = uenc;\n            }\n\n            return JSON.stringify(data);\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         *\n         * @returns {String}\n         */\n        return function (data, placeholder) {\n            var uenc = btoa(window.location.href).replace('+/=', '-_,');\n\n            placeholder = placeholder || encodeURI('%uenc%');\n\n            return _isJSON(data) ?\n                _objectProcessor(data, placeholder, uenc) :\n                _stringProcessor(data, placeholder, uenc);\n\n        };\n    }\n);\n","Magento_Catalog/js/product/addtocompare-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @returns {Array}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_compare_button'].url ||\n                    row['add_to_compare_button']['post_data']);\n        },\n\n        /**\n         * Depends on this option, \"Add to compare\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_compare', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/addtocart-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Element, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare data, that will be inserted as data-mage-init attribute into button. With help of this attribute\n         * Add To * buttons can understand post data and urls\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getDataMageInit: function (row) {\n            return '{\"redirectUrl\": { \"url\" : \"'  + uencProcessor(row['add_to_cart_button'].url) + '\"}}';\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_cart_button']['post_data']);\n        },\n\n        /**\n         * Check if product has required options.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasRequiredOptions: function (row) {\n            return row['add_to_cart_button']['required_options'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_cart', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiElement',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/customer-data'\n], function (_, utils, Element, storage, customerData) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            identifiersConfig: {\n                namespace: ''\n            },\n            productStorageConfig: {\n                namespace: 'product_data_storage',\n                customerDataProvider: 'product_data_storage',\n                updateRequestConfig: {\n                    url: '',\n                    method: 'GET',\n                    dataType: 'json'\n                },\n                className: 'DataStorage'\n            },\n            ids: {},\n            listens: {\n                ids: 'idsHandler'\n            }\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initIdsStorage();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('ids');\n\n            return this;\n        },\n\n        /**\n         * Initializes ids storage.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initIdsStorage: function () {\n            storage.onStorageInit(this.identifiersConfig.namespace, this.idsStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes ids storage handler.\n         *\n         * @param {Object} idsStorage\n         */\n        idsStorageHandler: function (idsStorage) {\n            this.idsStorage = idsStorage;\n            this.productStorage = storage.createStorage(this.productStorageConfig);\n            this.productStorage.data.subscribe(this.dataCollectionHandler.bind(this));\n\n            if (~~this.idsStorage.allowToSendRequest) {\n                customerData.reload([idsStorage.namespace]).done(this._resolveDataByIds.bind(this));\n            } else {\n                this._resolveDataByIds();\n            }\n        },\n\n        /**\n         * Callback, which load by ids from ids-storage product data\n         *\n         * @private\n         */\n        _resolveDataByIds: function () {\n            this.initIdsListener();\n            this.idsMerger(\n                this.idsStorage.get(),\n                this.prepareDataFromCustomerData(customerData.get(this.identifiersConfig.namespace)())\n            );\n\n            if (!_.isEmpty(this.productStorage.data())) {\n                this.dataCollectionHandler(this.productStorage.data());\n            } else {\n                this.productStorage.setIds(this.data.currency, this.data.store, this.ids());\n            }\n        },\n\n        /**\n         * Init ids storage listener.\n         */\n        initIdsListener: function () {\n            customerData.get(this.identifiersConfig.namespace).subscribe(function (data) {\n                this.idsMerger(this.prepareDataFromCustomerData(data));\n            }.bind(this));\n            this.idsStorage.data.subscribe(this.idsMerger.bind(this));\n        },\n\n        /**\n         * Prepare data from customerData.\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        prepareDataFromCustomerData: function (data) {\n            data = data.items ? data.items : data;\n\n            return data;\n        },\n\n        /**\n         * Filter ids by their lifetime in order to show only hot ids :)\n         *\n         * @param {Object} ids\n         * @returns {Array}\n         */\n        filterIds: function (ids) {\n            var _ids = {},\n                currentTime = new Date().getTime() / 1000;\n\n            _.each(ids, function (id) {\n                if (currentTime - id['added_at'] < ~~this.idsStorage.lifetime) {\n                    _ids[id['product_id']] = id;\n                }\n            }, this);\n\n            return _ids;\n        },\n\n        /**\n         * Merges id from storage and customer data\n         *\n         * @param {Object} data\n         * @param {Object} optionalData\n         */\n        idsMerger: function (data, optionalData) {\n            if (data && optionalData) {\n                data = _.extend(data, optionalData);\n            }\n\n            if (!_.isEmpty(data)) {\n                this.ids(\n                    this.filterIds(_.extend(this.ids(), data))\n                );\n            }\n        },\n\n        /**\n         * Ids update handler\n         *\n         * @param {Object} data\n         */\n        idsHandler: function (data) {\n            this.productStorage.setIds(this.data.currency, this.data.store, data);\n        },\n\n        /**\n         * Process data\n         *\n         * @param {Object} data\n         */\n        processData: function (data) {\n            var curData = utils.copy(this.data),\n                ids = this.ids();\n\n            delete data['data_id'];\n            data = _.values(data);\n\n            _.each(data, function (record, index) {\n                record._rowIndex = index;\n                record['added_at'] = ids[record.id]['added_at'];\n            }, this);\n\n            curData.items = data;\n            this.set('data', curData);\n        },\n\n        /**\n         * Product storage data handler\n         *\n         * @param {Object} data\n         */\n        dataCollectionHandler: function (data) {\n            data = this.filterData(data);\n            this.processData(data);\n        },\n\n        /**\n         * Filters data from product storage by ids\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var result = {},\n                i = 0,\n                ids = _.keys(this.ids()),\n                length = ids.length;\n\n            for (i; i < length; i++) {\n                if (ids[i] && data[ids[i]]) {\n                    result[ids[i]] = data[ids[i]];\n                }\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/learn-more.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        /**\n         * Depends on this option, \"Learn More\" link can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'learn_more', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/query-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'underscore'\n    ], function (_) {\n        'use strict';\n\n        return {\n\n            /**\n             * Build query to get id\n             *\n             * @param {Object} data\n             */\n            buildQuery: function (data) {\n                var filters = [];\n\n                _.each(data, function (value, key) {\n                    filters.push({\n                        field: key,\n                        value: value,\n                        'condition_type': 'in'\n                    });\n                });\n\n                return {\n                    searchCriteria: {\n                        filterGroups: [\n                            {\n                                filters: filters\n                            }\n                        ]\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Catalog/js/product/storage/data-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'mageUtils',\n    'Magento_Catalog/js/product/query-builder',\n    'Magento_Customer/js/customer-data',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, utils, queryBuilder, customerData) {\n    'use strict';\n\n    /**\n     * Process data from API request\n     *\n     * @param {Object} data\n     * @returns {Object}\n     */\n    function getParsedDataFromServer(data) {\n        var result = {};\n\n        _.each(data.items, function (item) {\n                if (item.id) {\n                    result[item.id] = item;\n                }\n            }\n        );\n\n        return {\n            items: result\n        };\n    }\n\n    return {\n\n        /**\n         * Class name\n         */\n        name: 'DataStorage',\n        request: {},\n        customerDataProvider: 'product_data_storage',\n\n        /**\n         * Initialize class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            this.initLocalStorage()\n                .initCustomerDataReloadListener()\n                .cachesDataFromLocalStorage()\n                .initDataListener()\n                .initProvideStorage()\n                .initProviderListener();\n\n            return this;\n        },\n\n        /**\n         * Initialize listener to customer data reload\n         *\n         * @return Chainable.\n         */\n        initCustomerDataReloadListener: function () {\n            $(document).on('customer-data-invalidate', this._flushProductStorage.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Flush product storage\n         *\n         * @private\n         * @return void\n         */\n        _flushProductStorage: function (event, sections) {\n            if (_.isEmpty(sections) || _.contains(sections, 'product_data_storage')) {\n                this.localStorage.removeAll();\n            }\n        },\n\n        /**\n         * Initialize listener to data property\n         *\n         * @return Chainable.\n         */\n        initDataListener: function () {\n            this.data.subscribe(this.dataHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initialize provider storage\n         *\n         * @return Chainable.\n         */\n        initProvideStorage: function () {\n            this.providerHandler(customerData.get(this.customerDataProvider)());\n\n            return this;\n        },\n\n        /**\n         * Handler to update \"data\" property.\n         * Sets data to localStorage\n         *\n         * @param {Object} data\n         */\n        dataHandler: function (data) {\n            if (_.isEmpty(data)) {\n                this.localStorage.removeAll();\n            } else {\n                this.localStorage.set(data);\n            }\n        },\n\n        /**\n         * Handler to update data in provider.\n         *\n         * @param {Object} data\n         */\n        providerHandler: function (data) {\n            var currentData = utils.copy(this.data()),\n                ids = _.keys(data.items);\n\n            if (data.items && ids.length) {\n                //we can extend only items\n                data = data.items;\n                this.data(_.extend(data, currentData));\n            }\n        },\n\n        /**\n         * Sets data ids\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         */\n        setIds: function (currency, store, ids) {\n            if (!this.hasInCache(currency, store, ids)) {\n                this.loadDataFromServer(currency, store, ids);\n            } else {\n                this.data.valueHasMutated();\n            }\n        },\n\n        /**\n         * Gets data from \"data\" property by identifiers\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} productIdentifiers\n         *\n         * @return {Object} data.\n         */\n        getDataByIdentifiers: function (currency, store, productIdentifiers) {\n            var data = {},\n                dataCollection = this.data(),\n                id;\n\n            for (id in productIdentifiers) {\n                if (productIdentifiers.hasOwnProperty(id)) {\n                    data[id] = dataCollection[id];\n                }\n            }\n\n            return data;\n        },\n\n        /**\n         * Checks has cached data or not\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         *\n         * @return {Boolean}\n         */\n        hasInCache: function (currency, store, ids) {\n            var data = this.data(),\n                id;\n\n            for (id in ids) {\n                if (!data.hasOwnProperty(id) ||\n                    data[id]['currency_code'] !== currency ||\n                    ~~data[id]['store_id'] !== ~~store\n                ) {\n                    return false;\n                }\n            }\n\n            return true;\n        },\n\n        /**\n         * Load data from server by ids\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         *\n         * @return void\n         */\n        loadDataFromServer: function (currency, store, ids) {\n            var idsArray = _.keys(ids),\n                prepareAjaxParams = {\n                    'entity_id': idsArray.join(',')\n                };\n\n            if (this.request.sent && this.hasIdsInSentRequest(ids)) {\n                return;\n            }\n\n            this.request = {\n                sent: true,\n                data: ids\n            };\n\n            this.updateRequestConfig.data = queryBuilder.buildQuery(prepareAjaxParams);\n            this.updateRequestConfig.data['store_id'] = store;\n            this.updateRequestConfig.data['currency_code'] = currency;\n            $.ajax(this.updateRequestConfig).success(function (data) {\n                this.request = {};\n                this.providerHandler(getParsedDataFromServer(data));\n            }.bind(this));\n        },\n\n        /**\n         * Each product page consist product cache data,\n         * this function prepare those data to appropriate view, and save it\n         *\n         * @param {Object} data\n         */\n        addDataFromPageCache: function (data) {\n            this.providerHandler(getParsedDataFromServer(data));\n        },\n\n        /**\n         * @param {Object} ids\n         * @returns {Boolean}\n         */\n        hasIdsInSentRequest: function (ids) {\n            var sentDataIds,\n                currentDataIds;\n\n            if (this.request.data) {\n                sentDataIds = _.keys(this.request.data);\n                currentDataIds = _.keys(ids);\n\n                _.each(currentDataIds, function (id) {\n                    if (_.lastIndexOf(sentDataIds, id) === -1) {\n                        return false;\n                    }\n                });\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Initialize provider listener\n         *\n         * @return Chainable.\n         */\n        initProviderListener: function () {\n            customerData.get(this.customerDataProvider).subscribe(this.providerHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Caches data from local storage to local scope\n         *\n         * @return Chainable.\n         */\n        cachesDataFromLocalStorage: function () {\n            this.data(this.getDataFromLocalStorage());\n\n            return this;\n        },\n\n        /**\n         * Gets data from local storage by current namespace\n         *\n         * @return {Object}.\n         */\n        getDataFromLocalStorage: function () {\n            return this.localStorage.get();\n        },\n\n        /**\n         * Initialize localStorage\n         *\n         * @return Chainable.\n         */\n        initLocalStorage: function () {\n            this.localStorage = $.initNamespaceStorage(this.namespace).localStorage;\n\n            return this;\n        }\n    };\n});\n","Magento_Catalog/js/product/storage/ids-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'mageUtils',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, utils) {\n    'use strict';\n\n    return {\n\n        /**\n         * Class name\n         */\n        name: 'IdsStorage',\n\n        /**\n         * Initializes class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            this.initCustomerDataReloadListener()\n                .initLocalStorage()\n                .cachesDataFromLocalStorage()\n                .initDataListener();\n\n            return this;\n        },\n\n        /**\n         * Gets data from local storage by current namespace\n         *\n         * @return {Object}.\n         */\n        getDataFromLocalStorage: function () {\n            return this.localStorage.get();\n        },\n\n        /**\n         * Caches data from local storage to local scope\n         *\n         * @return Chainable.\n         */\n        cachesDataFromLocalStorage: function () {\n            this.data(this.getDataFromLocalStorage());\n\n            return this;\n        },\n\n        /**\n         * Initialize localStorage\n         *\n         * @return Chainable.\n         */\n        initLocalStorage: function () {\n            this.localStorage = $.initNamespaceStorage(this.namespace).localStorage;\n\n            return this;\n        },\n\n        /**\n         * Initializes listener to \"data\" property\n         */\n        initDataListener: function () {\n            this.data.subscribe(this.internalDataHandler.bind(this));\n        },\n\n        /**\n         * Initialize listener to customer data reload\n         *\n         * @return Chainable.\n         */\n        initCustomerDataReloadListener: function () {\n            $(document).on('customer-data-reload', function (event, sections) {\n                if ((_.isEmpty(sections) || _.contains(sections, this.namespace)) && ~~this.allowToSendRequest) {\n                    this.localStorage.removeAll();\n                    this.data();\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes handler to \"data\" property update\n         */\n        internalDataHandler: function (data) {\n            var localStorage = this.localStorage.get();\n\n            if (!utils.compare(data, localStorage).equal) {\n                this.localStorage.set(data);\n            }\n        },\n\n        /**\n         * Initializes handler to storage update\n         */\n        externalDataHandler: function (data) {\n            data = data.items ? data.items : data;\n\n            this.set(_.extend(utils.copy(this.data()), data));\n        }\n    };\n});\n\n","Magento_Catalog/js/product/storage/storage-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'Magento_Catalog/js/product/storage/ids-storage',\n    'Magento_Catalog/js/product/storage/data-storage',\n    'Magento_Catalog/js/product/storage/ids-storage-compare'\n], function ($, _, utils, $t, IdsStorage, DataStore, IdsStorageCompare) {\n    'use strict';\n\n    return (function () {\n\n        var /**\n             * {Object} storages - list of storages\n             */\n            storages = {},\n\n            /**\n             * {Object} classes - list of classes\n             */\n            classes = {},\n\n            /**\n             * {Object} prototype - methods that will be added to all storage classes to prototype property.\n             */\n            prototype = {\n\n                /**\n                 * Sets data to storage\n                 *\n                 * @param {*} data\n                 */\n                set: function (data) {\n                    if (!utils.compare(data, this.data()).equal) {\n                        this.data(data);\n                    }\n                },\n\n                /**\n                 * Adds some data to current storage data\n                 *\n                 * @param {*} data\n                 */\n                add: function (data) {\n                    if (!utils.compare(data, this.data()).equal) {\n                        this.data(_.extend(utils.copy(this.data()), data));\n                    }\n                },\n\n                /**\n                 * Gets current storage data\n                 *\n                 * @returns {*} data\n                 */\n                get: function () {\n                    return this.data();\n                }\n            },\n\n            /**\n             * Required properties to storage\n             */\n            storagesInterface =  {\n                data: 'function',\n                initialize: 'function',\n                namespace: 'string'\n            },\n\n            /**\n             * Private service methods\n             */\n            _private = {\n\n                /**\n                 * Overrides class method and add ability use _super to call parent method\n                 *\n                 * @param {Object} extensionMethods\n                 * @param {Object} originInstance\n                 */\n                overrideClassMethods: function (extensionMethods, originInstance) {\n                    var methodsName = _.keys(extensionMethods),\n                        i = 0,\n                        length = methodsName.length;\n\n                    for (i; i < length; i++) {\n                        if (_.isFunction(originInstance[methodsName[i]])) {\n                            originInstance[methodsName[i]] = extensionMethods[methodsName[i]];\n                        }\n                    }\n\n                    return originInstance;\n                },\n\n                /**\n                 * Checks is storage implement interface\n                 *\n                 * @param {Object} classInstance\n                 *\n                 * @returns {Boolean}\n                 */\n                isImplementInterface: function (classInstance) {\n                    _.each(storagesInterface, function (key, value) {\n                        if (typeof classInstance[key] !== value) {\n                            return false;\n                        }\n                    });\n\n                    return true;\n                }\n            },\n\n            /**\n             * Subscribers list\n             */\n            subsctibers = {};\n\n        (function () {\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[IdsStorage.name] = function (config) {\n                _.extend(this, IdsStorage, config);\n            };\n\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[IdsStorageCompare.name] = function (config) {\n                _.extend(this, IdsStorageCompare, config);\n            };\n\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[DataStore.name] = function (config) {\n                _.extend(this, DataStore, config);\n            };\n\n            _.each(classes, function (classItem) {\n                classItem.prototype = prototype;\n            });\n        })();\n\n        return {\n\n            /**\n             * Creates new storage or returns if storage with declared namespace exist\n             *\n             * @param {Object} config - storage config\n             * @throws {Error}\n             * @returns {Object} storage instance\n             */\n            createStorage: function (config) {\n                var instance,\n                    initialized;\n\n                if (storages[config.namespace]) {\n                    return storages[config.namespace];\n                }\n\n                instance = new classes[config.className](config);\n\n                if (_private.isImplementInterface(instance)) {\n                    initialized = storages[config.namespace] = instance.initialize();\n                    this.processSubscribers(initialized, config);\n\n                    return initialized;\n                }\n\n                throw new Error('Class ' + config.className + $t('does not implement Storage Interface'));\n            },\n\n            /**\n             * Process subscribers\n             *\n             * Differentiate subscribers by their namespaces: recently_viewed or recently_compared\n             * and process callbacks. Callbacks can be add through onStorageInit function\n             *\n             * @param {Object} initialized\n             * @param {Object} config\n             * @return void\n             */\n            processSubscribers: function (initialized, config) {\n                if (subsctibers[config.namespace]) {\n                    _.each(subsctibers[config.namespace], function (callback) {\n                        callback(initialized);\n                    });\n\n                    delete subsctibers[config.namespace];\n                }\n            },\n\n            /**\n             * Listens storage creating by namespace\n             *\n             * @param {String} namespace\n             * @param {Function} callback\n             * @return void\n             */\n            onStorageInit: function (namespace, callback) {\n                if (storages[namespace]) {\n                    callback(storages[namespace]);\n                } else {\n                    subsctibers[namespace] ?\n                        subsctibers[namespace].push(callback) :\n                        subsctibers[namespace] = [callback];\n                }\n            },\n\n            /**\n             * Gets storage by namespace\n             *\n             * @param {String} namespace\n             *\n             * @returns {Object} storage insance\n             */\n            getStorage: function (namespace) {\n                return storages[namespace];\n            }\n        };\n    })();\n});\n\n","Magento_Catalog/js/product/storage/ids-storage-compare.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'Magento_Customer/js/customer-data',\n    'Magento_Catalog/js/product/storage/ids-storage'\n], function (_, ko, utils, customerData, idsStorage) {\n    'use strict';\n\n    return _.extend(utils.copy(idsStorage), {\n\n        /**\n         * Class name\n         */\n        name: 'IdsStorageCompare',\n\n        /**\n         * Initializes class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            if (this.provider) {\n                this.providerDataHandler(customerData.get(this.provider)());\n                this.initProviderListener();\n            }\n\n            this.initLocalStorage()\n                .cachesDataFromLocalStorage()\n                .initDataListener();\n\n            return this;\n        },\n\n        /**\n         * Initializes listener for external data provider\n         */\n        initProviderListener: function () {\n            customerData.get(this.provider).subscribe(this.providerDataHandler.bind(this));\n        },\n\n        /**\n         * Initializes handler for external data provider update\n         *\n         * @param {Object} data\n         */\n        providerDataHandler: function (data) {\n            data = data.items || data;\n            data = this.prepareData(data);\n\n            this.add(data);\n        },\n\n        /**\n         * Prepares data to correct interface\n         *\n         * @param {Object} data\n         *\n         * @returns {Object} data\n         */\n        prepareData: function (data) {\n            var result = {};\n\n            _.each(data, function (item) {\n                result[item.id] = {\n                    'added_at': new Date().getTime() / 1000,\n                    'product_id': item.id\n                };\n            });\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/view/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    'Magento_Catalog/js/product/storage/storage-service'\n], function (_, Element, storage) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            identifiersConfig: {\n                namespace: 'recently_viewed_product'\n            },\n            productStorageConfig: {\n                namespace: 'product_data_storage',\n                updateRequestConfig: {\n                    method: 'GET',\n                    dataType: 'json'\n                },\n                className: 'DataStorage'\n            }\n        },\n\n        /**\n         * Initializes\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initIdsStorage()\n                .initDataStorage();\n\n            return this;\n        },\n\n        /**\n         * Init ids storage\n         *\n         * @returns {Object} Chainable.\n         */\n        initIdsStorage: function () {\n            storage.onStorageInit(this.identifiersConfig.namespace, this.idsStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init data storage\n         *\n         * @returns {Object} Chainable.\n         */\n        initDataStorage: function () {\n            storage.onStorageInit(this.productStorageConfig.namespace, this.dataStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init data storage handler\n         *\n         * @param {Object} dataStorage - storage instance\n         */\n        dataStorageHandler: function (dataStorage) {\n            this.productStorage = dataStorage;\n            this.productStorage.add(this.data.items);\n        },\n\n        /**\n         * Init ids storage handler\n         *\n         * @param {Object} idsStorage - storage instance\n         */\n        idsStorageHandler: function (idsStorage) {\n            this.idsStorage = idsStorage;\n            this.idsStorage.add(this.getIdentifiers());\n        },\n\n        /**\n         * Gets ids from items\n         *\n         * @returns {Object}\n         */\n        getIdentifiers: function () {\n            var result = {};\n\n            _.each(this.data.items, function (item, key) {\n                result[key] = {\n                    'added_at': new Date().getTime() / 1000,\n                    'product_id': key\n                };\n            }, this);\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/column-status-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return _.extend({\n        /**\n         * Check whether we can show column depends on server settings or not\n         *\n         * @param {Object} source\n         * @param {String} attributeCode\n         * @param {String} type\n         * @returns {Boolean}\n         */\n        isValid: function (source, attributeCode, type) {\n            var attributes;\n\n            if (!source[type]) {\n                return false;\n            }\n\n            attributes = source[type].split(',');\n\n            return _.contains(attributes, attributeCode);\n        }\n    });\n});\n","Magento_Catalog/js/product/list/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/listing'\n], function (ko, _, Listing) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            additionalClasses: '',\n            filteredRows: {},\n            limit: 5,\n            listens: {\n                elems: 'filterRowsFromCache',\n                '${ $.provider }:data.items': 'filterRowsFromServer'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.filteredRows = ko.observable();\n            this.initProductsLimit();\n            this.hideLoader();\n        },\n\n        /**\n         * Initialize product limit\n         * Product limit can be configured through Ui component.\n         * Product limit are present in widget form\n         *\n         * @returns {exports}\n         */\n        initProductsLimit: function () {\n            if (this.source['page_size']) {\n                this.limit = this.source['page_size'];\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Sort and filter rows, that are already in magento storage cache\n         *\n         * @return void\n         */\n        filterRowsFromCache: function () {\n            this._filterRows(this.rows);\n        },\n\n        /**\n         * Sort and filter rows, that are come from backend\n         *\n         * @param {Object} rows\n         */\n        filterRowsFromServer: function (rows) {\n            this._filterRows(rows);\n        },\n\n        /**\n         * Filter rows by limit and sort them\n         *\n         * @param {Array} rows\n         * @private\n         */\n        _filterRows: function (rows) {\n            this.filteredRows(_.sortBy(rows, 'added_at').reverse().slice(0, this.limit));\n        },\n\n        /**\n         * Can retrieve product url\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getUrl: function (row) {\n            return row.url;\n        },\n\n        /**\n         * Get product attribute by code.\n         *\n         * @param {String} code\n         * @return {Object}\n         */\n        getComponentByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                component;\n\n            component = _.filter(elems, function (elem) {\n                return elem.index === code;\n            }, this).pop();\n\n            return component;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/toolbar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    /**\n     * ProductListToolbarForm Widget - this widget is setting cookie and submitting form according to toolbar controls\n     */\n    $.widget('mage.productListToolbarForm', {\n\n        options: {\n            modeControl: '[data-role=\"mode-switcher\"]',\n            directionControl: '[data-role=\"direction-switcher\"]',\n            orderControl: '[data-role=\"sorter\"]',\n            limitControl: '[data-role=\"limiter\"]',\n            mode: 'product_list_mode',\n            direction: 'product_list_dir',\n            order: 'product_list_order',\n            limit: 'product_list_limit',\n            modeDefault: 'grid',\n            directionDefault: 'asc',\n            orderDefault: 'position',\n            limitDefault: '9',\n            url: ''\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._bind($(this.options.modeControl), this.options.mode, this.options.modeDefault);\n            this._bind($(this.options.directionControl), this.options.direction, this.options.directionDefault);\n            this._bind($(this.options.orderControl), this.options.order, this.options.orderDefault);\n            this._bind($(this.options.limitControl), this.options.limit, this.options.limitDefault);\n        },\n\n        /** @inheritdoc */\n        _bind: function (element, paramName, defaultValue) {\n            if (element.is('select')) {\n                element.on('change', {\n                    paramName: paramName,\n                    'default': defaultValue\n                }, $.proxy(this._processSelect, this));\n            } else {\n                element.on('click', {\n                    paramName: paramName,\n                    'default': defaultValue\n                }, $.proxy(this._processLink, this));\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _processLink: function (event) {\n            event.preventDefault();\n            this.changeUrl(\n                event.data.paramName,\n                $(event.currentTarget).data('value'),\n                event.data.default\n            );\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _processSelect: function (event) {\n            this.changeUrl(\n                event.data.paramName,\n                event.currentTarget.options[event.currentTarget.selectedIndex].value,\n                event.data.default\n            );\n        },\n\n        /**\n         * @param {String} paramName\n         * @param {*} paramValue\n         * @param {*} defaultValue\n         */\n        changeUrl: function (paramName, paramValue, defaultValue) {\n            var decode = window.decodeURIComponent,\n                urlPaths = this.options.url.split('?'),\n                baseUrl = urlPaths[0],\n                urlParams = urlPaths[1] ? urlPaths[1].split('&') : [],\n                paramData = {},\n                parameters, i;\n\n            for (i = 0; i < urlParams.length; i++) {\n                parameters = urlParams[i].split('=');\n                paramData[decode(parameters[0])] = parameters[1] !== undefined ?\n                    decode(parameters[1].replace(/\\+/g, '%20')) :\n                    '';\n            }\n            paramData[paramName] = paramValue;\n\n            if (paramValue == defaultValue) { //eslint-disable-line eqeqeq\n                delete paramData[paramName];\n            }\n            paramData = $.param(paramData);\n\n            location.href = baseUrl + (paramData.length ? '?' + paramData : '');\n        }\n    });\n\n    return $.mage.productListToolbarForm;\n});\n","Magento_Catalog/js/product/list/columns/pricetype-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiCollection'\n], function (ko, _, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        /**\n         * Find from all price ui components, price with specific code, init source on it and set priceType\n         *\n         * @param {String} code\n         * @returns {*|T}\n         */\n        getPriceByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                price;\n\n            price = _.filter(elems, function (elem) {\n                return elem.index.split('.').shift() === code;\n            }, this).pop();\n\n            price.source = this.source();\n            price.priceType = code;\n\n            return price;\n        },\n\n        /**\n         * Retrieve body template\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Check whether price has price range, depends on different options, that can be choose\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'uiLayout'\n], function (ko, _, registry, utils, Collection, columnStatusValidator, layout) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: '',\n            hasSpecialPrice: false,\n            showMinimalPrice: false,\n            useLinkForAsLowAs: false,\n            visible: true,\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'Magento_Catalog/product/price/price_box',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: false,\n            sorting: false,\n            draggable: true,\n            fieldClass: {},\n            renders: {\n                default: {}\n            },\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                elems: ''\n            },\n            modules: {\n                source: '${ $.provider }'\n            },\n            pricesInit: {}\n        },\n\n        /**\n         * Sort prices api\n         *\n         * @returns {exports}\n         */\n        sort: function () {\n            return this;\n        },\n\n        /**\n         * Check whether is allowed to render price or not\n         *\n         * @returns {*}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'price', 'show_attributes');\n        },\n\n        /**\n         * Retrieve array of prices, that should be rendered for specific product\n         *\n         * @param {Array} row\n         * @return {Array}\n         */\n        getPrices: function (row) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                result;\n\n            //we cant take type of product from row\n            this.initPrices(row);\n            result = _.filter(elems, function (elem) {\n                return elem.productType === row.type;\n            });\n\n            return result;\n        },\n\n        /**\n         * Recursive Merging of objects\n         *\n         * @param {Array} target\n         * @param {Array} source\n         * @returns {Array}\n         * @private\n         */\n        _deepObjectExtend: function (target, source) {\n            var _target = utils.copy(target);\n\n            _.each(source, function (value, key) {\n                if (_.keys(value).length && typeof _target[key] !== 'undefined') {\n                    _target[key] = this._deepObjectExtend(_target[key], value);\n                } else {\n                    _target[key] = value;\n                }\n            }, this);\n\n            return _target;\n        },\n\n        /**\n         * Init price type box, in cases when product type has custom component or bodyTmpl\n         *\n         * @param {String} productType\n         * @private\n         */\n        _initPriceWithCustomMetaData: function (productType) {\n            var price = this._deepObjectExtend(\n                this.renders.prices['default'],\n                this.renders.prices[productType]\n            );\n\n            price.name = productType + '.default';\n            price.parent = this.name;\n            price.source = this.source;\n            price.productType = productType;\n            layout([price]);\n        },\n\n        /**\n         * Init Prices by product type and add them to layout\n         *\n         * @param {Array} _priceData\n         * @param {String} productType\n         * @private\n         */\n        _initPricesForProductType: function (_priceData, productType) {\n            var prices = [];\n\n            this._setPriceNamesToPrices(_priceData, productType);\n            _.sortBy(_priceData, this._comparePrices);\n\n            _.each(_priceData, function (priceData) {\n                if (!priceData.component) {\n                    return;\n                }\n\n                priceData.parent = this.name;\n                priceData.provider = this.provider;\n                priceData.productType = productType;\n                priceData = utils.template(priceData, this);\n                prices.push(priceData);\n            }, this);\n\n            layout(prices);\n        },\n\n        /**\n         * Init dynamic price components\n         *\n         * @param {Array} row\n         * @returns {void}\n         */\n        initPrices: function (row) {\n            var _priceData = [],\n                productType = row.type,\n                defaultPrice = this.renders.prices['default'];\n\n            if (this.pricesInit[productType]) {\n                return true;\n            }\n\n            this.pricesInit[productType] = true;\n\n            if (this.renders.prices[productType] && this._needToApplyCustomTemplate(this.renders.prices[productType])) {\n                return this._initPriceWithCustomMetaData(productType);\n            }\n\n            if (this.renders.prices[productType] && this.renders.prices[productType].children) {\n                _priceData = this._deepObjectExtend(defaultPrice.children, this.renders.prices[productType].children);\n            } else {\n                _priceData = defaultPrice.children;\n            }\n\n            return this._initPricesForProductType(_priceData, productType);\n        },\n\n        /**\n         * Set name to all price components\n         *\n         * @param {Array} prices\n         * @param {String} productType\n         * @private\n         */\n        _setPriceNamesToPrices: function (prices, productType) {\n            _.each(prices, function (price, name) {\n                price.priceType = name;\n                price.name = name + '.' + productType;\n            });\n\n            return prices;\n        },\n\n        /**\n         * Sort callback to compare prices by sort order\n         *\n         * @param {Number} firstPrice\n         * @param {Number} secondPrice\n         * @returns {Number}\n         * @private\n         */\n        _comparePrices: function (firstPrice, secondPrice) {\n            if (firstPrice.sortOrder < secondPrice.sortOrder) {\n                return -1;\n            }\n\n            if (firstPrice.sortOrder > secondPrice.sortOrder) {\n                return 1;\n            }\n\n            return 0;\n        },\n\n        /**\n         * Check whether metadata of product type prices was changed, and we should\n         * to apply custom template or custom component\n         *\n         * @param {Array} productData\n         * @returns {*}\n         * @private\n         */\n        _needToApplyCustomTemplate: function (productData) {\n            return productData.bodyTmpl || productData.component;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get price label.\n         *\n         * @returns {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/final-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection'\n], function (_, registry, utils, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: false,\n            headerTmpl: 'ui/grid/columns/text',\n            showMinimalPrice: false,\n            showMaximumPrice: false,\n            useLinkForAsLowAs: false,\n            bodyTmpl: 'Magento_Catalog/product/final_price',\n            priceWrapperCssClasses: '',\n            priceWrapperAttr: {}\n        },\n\n        /**\n         * Get product final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPrice: function (row) {\n            return row['price_info']['formatted_prices']['final_price'];\n        },\n\n        /**\n         * Get product regular price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['regular_price'];\n        },\n\n        /**\n         * Check if product has a price range.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Check if product has special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} special price html\n         */\n        hasSpecialPrice: function (row) {\n            return row['price_info']['regular_price'] > row['price_info']['final_price'];\n        },\n\n        /**\n         * Check if product has minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        isMinimalPrice: function (row) {\n            return row['price_info']['minimal_price'] < row['price_info']['final_price'];\n        },\n\n        /**\n         * Get product minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPrice: function (row) {\n            return row['price_info']['formatted_prices']['minimal_price'];\n        },\n\n        /**\n         * Check if product is salable.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Get product maximum price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_price'];\n        },\n\n        /**\n         * Get product maximum regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_regular_price'];\n        },\n\n        /**\n         * Get product minimal regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['min_regular_price'];\n        },\n\n        /**\n         * Get adjustments names and return as string.\n         *\n         * @return {String} adjustments classes\n         */\n        getAdjustmentCssClasses: function () {\n            return _.pluck(this.getAdjustments(), 'index').join(' ');\n        },\n\n        /**\n         * Get product minimal price as number.\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmount: function (row) {\n            return row['price_info']['minimal_price'];\n        },\n\n        /**\n         * Get product minimal regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} minimal regular price amount\n         */\n        getMinimalRegularPriceAmount: function (row) {\n            return row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Get product maximum price as number.\n         *\n         * @param {Object} row\n         * @return {Number} maximum price amount\n         */\n        getMaximumPriceAmount: function (row) {\n            return row['price_info']['max_price'];\n        },\n\n        /**\n         * Get product maximum regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} maximum regular price amount\n         */\n        getMaximumRegularPriceAmount: function (row) {\n            return row['price_info']['max_regular_price'];\n        },\n\n        /**\n         * Check if minimal regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMinRegularPrice: function (row) {\n            return this.getMinimalPriceAmount(row) < this.getMinimalRegularPriceAmount(row);\n        },\n\n        /**\n         * Check if maximum regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMaxRegularPrice: function (row) {\n            return this.getMaximumPriceAmount(row) < this.getMaximumRegularPriceAmount(row);\n        },\n\n        /**\n         * Get path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get all price adjustments.\n         *\n         * @returns {Object}\n         */\n        getAdjustments: function () {\n            var adjustments = this.elems();\n\n            _.each(adjustments, function (adjustment) {\n                adjustment.setPriceType(this.priceType);\n                adjustment.source = this.source;\n            }, this);\n\n            return adjustments;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (_, Element, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Catalog/product/list/columns/image',\n            imageCode: 'default',\n            image: {}\n        },\n\n        /**\n         * Find image by code in scope of images\n         *\n         * @param {Object} images\n         * @returns {*|T}\n         */\n        getImage: function (images) {\n            return _.filter(images, function (image) {\n                return this.imageCode === image.code;\n            }, this).pop();\n        },\n\n        /**\n         * Get image path.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getImageUrl: function (row) {\n            return this.getImage(row.images).url;\n        },\n\n        /**\n         * Get image box width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getWidth: function (row) {\n            return this.getImage(row.images).width;\n        },\n\n        /**\n         * Get image box height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getHeight: function (row) {\n            return this.getImage(row.images).height;\n        },\n\n        /**\n         * Get resized image width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageWidth: function (row) {\n            return this.getImage(row.images)['resized_width'];\n        },\n\n        /**\n         * Get resized image height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageHeight: function (row) {\n            return this.getImage(row.images)['resized_height'];\n        },\n\n        /**\n         * Get image alt text.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getLabel: function (row) {\n            if (!this.imageExists(row)) {\n                return this._super();\n            }\n\n            return this.getImage(row.images).label;\n        },\n\n        /**\n         * Check if image exist.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        imageExists: function (row) {\n            return this.getImage(row.images) !== 'undefined';\n        },\n\n        /**\n         * Check if component must be shown.\n         *\n         * @return {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'image', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/product/view/validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui',\n            'mage/validation/validation'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    $.widget('mage.validation', $.mage.validation, {\n        options: {\n            radioCheckboxClosest: 'ul, ol',\n\n            /**\n             * @param {*} error\n             * @param {HTMLElement} element\n             */\n            errorPlacement: function (error, element) {\n                var messageBox,\n                    dataValidate;\n\n                if ($(element).hasClass('datetime-picker')) {\n                    element = $(element).parent();\n\n                    if (element.parent().find('[generated=true].mage-error').length) {\n                        return;\n                    }\n                }\n\n                if (element.attr('data-errors-message-box')) {\n                    messageBox = $(element.attr('data-errors-message-box'));\n                    messageBox.html(error);\n\n                    return;\n                }\n\n                dataValidate = element.attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-one-checkbox-required-by-name') > 0) {\n                    error.appendTo('#links-advice-container');\n                } else if (element.is(':radio, :checkbox')) {\n                    element.closest(this.radioCheckboxClosest).after(error);\n                } else {\n                    element.after(error);\n                }\n            },\n\n            /**\n             * @param {HTMLElement} element\n             * @param {String} errorClass\n             */\n            highlight: function (element, errorClass) {\n                var dataValidate = $(element).attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-required-datetime') > 0) {\n                    $(element).parent().find('.datetime-picker').each(function () {\n                        $(this).removeClass(errorClass);\n\n                        if ($(this).val().length === 0) {\n                            $(this).addClass(errorClass);\n                        }\n                    });\n                } else if ($(element).is(':radio, :checkbox')) {\n                    $(element).closest(this.radioCheckboxClosest).addClass(errorClass);\n                } else {\n                    $(element).addClass(errorClass);\n                }\n            },\n\n            /**\n             * @param {HTMLElement} element\n             * @param {String} errorClass\n             */\n            unhighlight: function (element, errorClass) {\n                var dataValidate = $(element).attr('data-validate');\n\n                if (dataValidate && dataValidate.indexOf('validate-required-datetime') > 0) {\n                    $(element).parent().find('.datetime-picker').removeClass(errorClass);\n                } else if ($(element).is(':radio, :checkbox')) {\n                    $(element).closest(this.radioCheckboxClosest).removeClass(errorClass);\n                } else {\n                    $(element).removeClass(errorClass);\n                }\n            }\n        }\n    });\n\n    return $.mage.validation;\n}));\n","Temando_Shipping/js/model/fields-definition.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'underscore',\n    'ko',\n    'Magento_Customer/js/customer-data'\n], function (_, ko, customerData) {\n    'use strict';\n\n    var cacheKey = 'checkout-fields';\n\n    return {\n        getFields: function () {\n            var sectionData = customerData.get(cacheKey);\n\n            _.each(sectionData().fields, function (field) {\n                if ((field.value === undefined) && field.defaultValue) {\n                    field.value = field.defaultValue;\n                }\n            });\n            return sectionData().fields;\n        },\n\n        updateFieldValue: function (fieldId, fieldValue) {\n            var sectionData = customerData.get(cacheKey);\n\n            if (fieldValue === undefined) {\n                fieldValue = '';\n            }\n\n            _.each(sectionData().fields, function (field) {\n                if (field.id === fieldId) {\n                    field.value = fieldValue;\n                }\n            });\n\n            customerData.set(cacheKey, sectionData());\n        }\n    };\n});\n","Temando_Shipping/js/model/shipping-rates-validator/temando.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'temandoShippingRatesValidationRules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Temando_Shipping/js/model/shipping-rate-processor/new-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor',\n    'temandoCheckoutFieldsDefinition'\n], function (_, resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor, fieldsDefinition) {\n    'use strict';\n\n    return {\n        /**\n         * Get shipping rates for specified address.\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache, cacheKey, serviceUrl, payload;\n\n            // init extension attributes\n            if (!address.extensionAttributes) {\n                address.extensionAttributes = {};\n            }\n            if (!address.extensionAttributes.checkoutFields) {\n                address.extensionAttributes.checkoutFields = {};\n            }\n\n            // add current checkout field configuration to extension attributes\n            _.each(fieldsDefinition.getFields(), function (field) {\n                address.extensionAttributes.checkoutFields[field.id] = {\n                    attributeCode: field.id,\n                    value: field.value\n                };\n            });\n\n            shippingService.isLoading(true);\n            cacheKey = address.getCacheKey().concat(JSON.stringify(address.extensionAttributes));\n            cache = rateRegistry.get(cacheKey);\n            serviceUrl = resourceUrlManager.getUrlForEstimationShippingMethodsForNewAddress(quote);\n            payload = JSON.stringify({\n                    address: {\n                        'street': address.street,\n                        'city': address.city,\n                        'region_id': address.regionId,\n                        'region': address.region,\n                        'country_id': address.countryId,\n                        'postcode': address.postcode,\n                        'email': address.email,\n                        'customer_id': address.customerId,\n                        'firstname': address.firstname,\n                        'lastname': address.lastname,\n                        'middlename': address.middlename,\n                        'prefix': address.prefix,\n                        'suffix': address.suffix,\n                        'vat_id': address.vatId,\n                        'company': address.company,\n                        'telephone': address.telephone,\n                        'fax': address.fax,\n                        'custom_attributes': address.customAttributes,\n                        'extension_attributes': address.extensionAttributes || {},\n                        'save_in_address_book': address.saveInAddressBook\n                    }\n                }\n            );\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                storage.post(\n                    serviceUrl, payload, false\n                ).done(function (result) {\n                    rateRegistry.set(cacheKey, result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                });\n            }\n        }\n    };\n});\n","Temando_Shipping/js/model/shipping-rate-processor/customer-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor',\n    'temandoCheckoutFieldsDefinition'\n], function (_, resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor, fieldsDefinition) {\n    'use strict';\n\n    return {\n        /**\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache,\n                cacheKey;\n\n            if (!address.extensionAttributes) {\n                address.extensionAttributes = {};\n            }\n            if (!address.extensionAttributes.checkoutFields) {\n                address.extensionAttributes.checkoutFields = {};\n            }\n\n            _.each(fieldsDefinition.getFields(), function (field) {\n                address.extensionAttributes.checkoutFields[field.id] = {\n                    attributeCode: field.id,\n                    value: field.value\n                };\n            });\n\n            cacheKey = address.getCacheKey().concat(JSON.stringify(address.extensionAttributes));\n\n            shippingService.isLoading(true);\n            cache = rateRegistry.get(cacheKey);\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                storage.post(\n                    resourceUrlManager.getUrlForEstimationShippingMethodsByAddressId(quote),\n                    JSON.stringify({\n                        addressId: address.customerAddressId,\n                        extensionAttributes: address.extensionAttributes || {},\n                    }),\n                    false\n                ).done(function (result) {\n                    rateRegistry.set(cacheKey, result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                }\n                );\n            }\n        }\n    };\n});\n","Temando_Shipping/js/model/shipping-rates-validation-rules/temando.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'lastname': {\n                    'required': false\n                },\n                'postcode': {\n                    'required': false\n                },\n                'city': {\n                    'required': false\n                },\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Temando_Shipping/js/view/checkout/shipping/checkout-fields.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'underscore',\n    'uiComponent',\n    'ko',\n    'temandoCheckoutFieldsDefinition',\n    'Magento_Checkout/js/model/quote'\n], function (_, Component, ko, fieldsDefinition, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Temando_Shipping/checkout/shipping/checkout-fields',\n            fields: []\n        },\n\n        /**\n         *\n         * @returns {*} Array of fields with observable values\n         */\n        getFields: function () {\n            if (_.isEmpty(this.fields)) {\n                _.each(fieldsDefinition.getFields(), function (fieldDefinition) {\n                    // init field for template rendering\n                    var field = {\n                        id: fieldDefinition.id,\n                        label: fieldDefinition.label,\n                        type: fieldDefinition.type,\n                        options: fieldDefinition.options,\n                        value: ko.observable(fieldDefinition.value)\n                    };\n\n                    field.value.subscribe(function (fieldValue) {\n                        // on value change, update section data and trigger rate request\n                        fieldsDefinition.updateFieldValue(fieldDefinition.id, fieldValue);\n                        quote.shippingAddress.valueHasMutated();\n                    });\n\n                    // push field definition to component property for template rendering\n                    this.fields.push(field);\n                }, this);\n            }\n\n            return this.fields;\n        }\n    });\n});\n","Temando_Shipping/js/view/shipping-rates-validation/temando.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    'temandoShippingRatesValidator',\n    'temandoShippingRatesValidationRules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    temandoShippingRatesValidator,\n    temandoShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('temando', temandoShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('temando', temandoShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_Braintree/js/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Braintree/js/paypal/button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'rjsResolver',\n        'uiRegistry',\n        'uiComponent',\n        'underscore',\n        'jquery',\n        'braintree',\n        'Magento_Braintree/js/paypal/form-builder',\n        'domReady!'\n    ],\n    function (\n        resolver,\n        registry,\n        Component,\n        _,\n        $,\n        braintree,\n        formBuilder\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n\n                integrationName: 'braintreePaypal.currentIntegration',\n\n                /**\n                 * {String}\n                 */\n                displayName: null,\n\n                /**\n                 * {String}\n                 */\n                clientToken: null,\n\n                /**\n                 * {Object}\n                 */\n                clientConfig: {\n\n                    /**\n                     * @param {Object} integration\n                     */\n                    onReady: function (integration) {\n                        resolver(function () {\n                            registry.set(this.integrationName, integration);\n                            $('#' + this.id).removeAttr('disabled');\n                        }, this);\n                    },\n\n                    /**\n                     * @param {Object} payload\n                     */\n                    onPaymentMethodReceived: function (payload) {\n                        $('body').trigger('processStart');\n\n                        formBuilder.build(\n                            {\n                                action: this.actionSuccess,\n                                fields: {\n                                    result: JSON.stringify(payload)\n                                }\n                            }\n                        ).submit();\n                    }\n                }\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super()\n                    .initComponent();\n\n                return this;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initComponent: function () {\n                var currentIntegration = registry.get(this.integrationName),\n                    $this = $('#' + this.id),\n                    self = this,\n                    data = {\n                        amount: $this.data('amount'),\n                        locale: $this.data('locale'),\n                        currency: $this.data('currency')\n                    },\n                    initCallback = function () {\n                        $this.attr('disabled', 'disabled');\n                        registry.remove(this.integrationName);\n                        braintree.setup(this.clientToken, 'custom', this.getClientConfig(data));\n\n                        $this.off('click')\n                            .on('click', function (event) {\n                                event.preventDefault();\n\n                                registry.get(self.integrationName, function (integration) {\n                                    try {\n                                        integration.paypal.initAuthFlow();\n                                    } catch (e) {\n                                        $this.attr('disabled', 'disabled');\n                                    }\n                                });\n                            });\n                    }.bind(this);\n\n                currentIntegration ?\n                    currentIntegration.teardown(initCallback) :\n                    initCallback();\n\n                return this;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            getClientConfig: function (data) {\n                this.clientConfig.paypal = {\n                    singleUse: true,\n                    amount: data.amount,\n                    currency: data.currency,\n                    locale: data.locale,\n                    enableShippingAddress: true,\n                    headless: true\n                };\n\n                if (this.displayName) {\n                    this.clientConfig.paypal.displayName = this.displayName;\n                }\n\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n\n                return this.clientConfig;\n            }\n        });\n    }\n);\n","Magento_Braintree/js/paypal/form-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","Magento_Braintree/js/view/payment/3d-secure.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Braintree/js/view/payment/adapter',\n    'Magento_Checkout/js/model/quote',\n    'mage/translate'\n], function ($, braintree, quote, $t) {\n    'use strict';\n\n    return {\n        config: null,\n\n        /**\n         * Set 3d secure config\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n            this.config.thresholdAmount = parseFloat(config.thresholdAmount);\n        },\n\n        /**\n         * Get code\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'three_d_secure';\n        },\n\n        /**\n         * Validate Braintree payment nonce\n         * @param {Object} context\n         * @returns {Object}\n         */\n        validate: function (context) {\n            var client = braintree.getApiClient(),\n                state = $.Deferred(),\n                totalAmount = quote.totals()['base_grand_total'],\n                billingAddress = quote.billingAddress();\n\n            if (!this.isAmountAvailable(totalAmount) || !this.isCountryAvailable(billingAddress.countryId)) {\n                state.resolve();\n\n                return state.promise();\n            }\n\n            client.verify3DS({\n                amount: totalAmount,\n                creditCard: context.paymentMethodNonce\n            }, function (error, response) {\n                var liability;\n\n                if (error) {\n                    state.reject(error.message);\n\n                    return;\n                }\n\n                liability = {\n                    shifted: response.verificationDetails.liabilityShifted,\n                    shiftPossible: response.verificationDetails.liabilityShiftPossible\n                };\n\n                if (liability.shifted || !liability.shifted && !liability.shiftPossible) {\n                    context.paymentMethodNonce = response.nonce;\n                    state.resolve();\n                } else {\n                    state.reject($t('Please try again with another form of payment.'));\n                }\n            });\n\n            return state.promise();\n        },\n\n        /**\n         * Check minimal amount for 3d secure activation\n         * @param {Number} amount\n         * @returns {Boolean}\n         */\n        isAmountAvailable: function (amount) {\n            amount = parseFloat(amount);\n\n            return amount >= this.config.thresholdAmount;\n        },\n\n        /**\n         * Check if current country is available for 3d secure\n         * @param {String} countryId\n         * @returns {Boolean}\n         */\n        isCountryAvailable: function (countryId) {\n            var key,\n                specificCountries = this.config.specificCountries;\n\n            // all countries are available\n            if (!specificCountries.length) {\n                return true;\n            }\n\n            for (key in specificCountries) {\n                if (countryId === specificCountries[key]) {\n                    return true;\n                }\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Braintree/js/view/payment/validator-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Braintree/js/view/payment/3d-secure'\n], function ($, globalMessageList, verify3DSecure) {\n    'use strict';\n\n    return {\n        validators: [],\n\n        /**\n         * Get payment config\n         * @returns {Object}\n         */\n        getConfig: function () {\n            return window.checkoutConfig.payment;\n        },\n\n        /**\n         * Init list of validators\n         */\n        initialize: function () {\n            var config = this.getConfig();\n\n            if (config[verify3DSecure.getCode()].enabled) {\n                verify3DSecure.setConfig(config[verify3DSecure.getCode()]);\n                this.add(verify3DSecure);\n            }\n        },\n\n        /**\n         * Add new validator\n         * @param {Object} validator\n         */\n        add: function (validator) {\n            this.validators.push(validator);\n        },\n\n        /**\n         * Run pull of validators\n         * @param {Object} context\n         * @param {Function} callback\n         */\n        validate: function (context, callback) {\n            var self = this,\n                deferred;\n\n            // no available validators\n            if (!self.validators.length) {\n                callback();\n\n                return;\n            }\n\n            // get list of deferred validators\n            deferred = $.map(self.validators, function (current) {\n                return current.validate(context);\n            });\n\n            $.when.apply($, deferred)\n                .done(function () {\n                    callback();\n                }).fail(function (error) {\n                    self.showError(error);\n                });\n        },\n\n        /**\n         * Show error message\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n        }\n    };\n});\n","Magento_Braintree/js/view/payment/braintree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        var config = window.checkoutConfig.payment,\n            braintreeType = 'braintree',\n            payPalType = 'braintree_paypal';\n\n        if (config[braintreeType].isActive) {\n            rendererList.push(\n                {\n                    type: braintreeType,\n                    component: 'Magento_Braintree/js/view/payment/method-renderer/hosted-fields'\n                }\n            );\n        }\n\n        if (config[payPalType].isActive) {\n            rendererList.push(\n                {\n                    type: payPalType,\n                    component: 'Magento_Braintree/js/view/payment/method-renderer/paypal'\n                }\n            );\n        }\n\n        /** Add view logic here if needed */\n        return Component.extend({});\n    }\n);\n","Magento_Braintree/js/view/payment/adapter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'braintree',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n], function ($, braintree, globalMessageList, $t) {\n    'use strict';\n\n    return {\n        apiClient: null,\n        config: {},\n        checkout: null,\n\n        /**\n         * Get Braintree api client\n         * @returns {Object}\n         */\n        getApiClient: function () {\n            if (!this.apiClient) {\n                this.apiClient = new braintree.api.Client({\n                    clientToken: this.getClientToken()\n                });\n            }\n\n            return this.apiClient;\n        },\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        setup: function () {\n            if (!this.getClientToken()) {\n                this.showError($t('Sorry, but something went wrong.'));\n            }\n\n            braintree.setup(this.getClientToken(), 'custom', this.config);\n        },\n\n        /**\n         * Get payment name\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'braintree';\n        },\n\n        /**\n         * Get client token\n         * @returns {String|*}\n         */\n        getClientToken: function () {\n\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * Show error message\n         *\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n        },\n\n        /**\n         * May be triggered on Braintree SDK setup\n         */\n        onReady: function () {}\n    };\n});\n","Magento_Braintree/js/view/payment/method-renderer/hosted-fields.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n\ndefine([\n    'jquery',\n    'Magento_Braintree/js/view/payment/method-renderer/cc-form',\n    'Magento_Braintree/js/validator',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'mage/translate'\n], function ($, Component, validator, VaultEnabler, $t) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            template: 'Magento_Braintree/payment/form',\n            clientConfig: {\n\n                /**\n                 * {String}\n                 */\n                id: 'co-transparent-form-braintree'\n            },\n            isValidCardNumber: false\n        },\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this._super();\n\n            // Hosted fields settings\n            this.clientConfig.hostedFields = this.getHostedFields();\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = this._super();\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        isVaultEnabled: function () {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * Get Braintree Hosted Fields\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number')\n                    },\n                    expirationMonth: {\n                        selector: self.getSelector('expirationMonth'),\n                        placeholder: $t('MM')\n                    },\n                    expirationYear: {\n                        selector: self.getSelector('expirationYear'),\n                        placeholder: $t('YY')\n                    }\n                };\n\n            if (self.hasVerification()) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid')\n                };\n            }\n\n            /**\n             * Triggers on Hosted Field changes\n             * @param {Object} event\n             * @returns {Boolean}\n             */\n            fields.onFieldEvent = function (event) {\n                if (event.isEmpty === false) {\n                    self.validateCardType();\n                }\n\n                if (event.type !== 'fieldStateChange') {\n\n                    return false;\n                }\n\n                // Handle a change in validation or card type\n                if (event.target.fieldKey === 'number') {\n                    self.selectedCardType(null);\n                }\n\n                if (event.target.fieldKey === 'number' && event.card) {\n                    self.isValidCardNumber = event.isValid;\n                    self.selectedCardType(\n                        validator.getMageCardType(event.card.type, self.getCcAvailableTypes())\n                    );\n                }\n            };\n\n            return fields;\n        },\n\n        /**\n         * Validate current credit card type\n         * @returns {Boolean}\n         */\n        validateCardType: function () {\n            var $selector = $(this.getSelector('cc_number')),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            $selector.removeClass(invalidClass);\n\n            if (this.selectedCardType() === null || !this.isValidCardNumber) {\n                $(this.getSelector('cc_number')).addClass(invalidClass);\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Returns state of place order button\n         * @returns {Boolean}\n         */\n        isButtonActive: function () {\n            return this.isActive() && this.isPlaceOrderActionAllowed();\n        },\n\n        /**\n         * Triggers order placing\n         */\n        placeOrderClick: function () {\n            if (this.validateCardType()) {\n                this.isPlaceOrderActionAllowed(false);\n                $(this.getSelector('submit')).trigger('click');\n            }\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].ccVaultCode;\n        }\n    });\n});\n","Magento_Braintree/js/view/payment/method-renderer/paypal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Braintree/js/view/payment/adapter',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'Magento_Checkout/js/action/create-billing-address',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Component,\n    Braintree,\n    quote,\n    fullScreenLoader,\n    additionalValidators,\n    VaultEnabler,\n    createBillingAddress,\n    $t\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Braintree/payment/paypal',\n            code: 'braintree_paypal',\n            active: false,\n            paymentMethodNonce: null,\n            grandTotalAmount: null,\n            isReviewRequired: false,\n            customerEmail: null,\n\n            /**\n             * Additional payment data\n             *\n             * {Object}\n             */\n            additionalData: {},\n\n            /**\n             * PayPal client configuration\n             * {Object}\n             */\n            clientConfig: {\n                dataCollector: {\n                    paypal: true\n                },\n\n                /**\n                 * Triggers when widget is loaded\n                 * @param {Object} checkout\n                 */\n                onReady: function (checkout) {\n                    Braintree.checkout = checkout;\n                    this.additionalData['device_data'] = checkout.deviceData;\n                    this.enableButton();\n                    Braintree.onReady();\n                },\n\n                /**\n                 * Triggers on payment nonce receive\n                 * @param {Object} response\n                 */\n                onPaymentMethodReceived: function (response) {\n                    this.beforePlaceOrder(response);\n                }\n            },\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            this._super()\n                .observe(['active', 'isReviewRequired', 'customerEmail']);\n\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n            this.vaultEnabler.isActivePaymentTokenEnabler.subscribe(function () {\n                self.onVaultPaymentTokenEnablerChange();\n            });\n\n            this.grandTotalAmount = quote.totals()['base_grand_total'];\n\n            quote.totals.subscribe(function () {\n                if (self.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    self.grandTotalAmount = quote.totals()['base_grand_total'];\n                }\n            });\n\n            // for each component initialization need update property\n            this.isReviewRequired(false);\n            this.initClientConfig();\n\n            return this;\n        },\n\n        /**\n         * Get payment name\n         *\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Get payment title\n         *\n         * @returns {String}\n         */\n        getTitle: function () {\n            return window.checkoutConfig.payment[this.getCode()].title;\n        },\n\n        /**\n         * Check if payment is active\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            var active = this.getCode() === this.isChecked();\n\n            this.active(active);\n\n            return active;\n        },\n\n        /**\n         * Triggers when payment method change\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                return;\n            }\n\n            // need always re-init Braintree with PayPal configuration\n            this.reInitPayPal();\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n        },\n\n        /**\n         * Set payment nonce\n         * @param {String} paymentMethodNonce\n         */\n        setPaymentMethodNonce: function (paymentMethodNonce) {\n            this.paymentMethodNonce = paymentMethodNonce;\n        },\n\n        /**\n         * Update quote billing address\n         * @param {Object}customer\n         * @param {Object}address\n         */\n        setBillingAddress: function (customer, address) {\n            var billingAddress = {\n                street: [address.streetAddress],\n                city: address.locality,\n                postcode: address.postalCode,\n                countryId: address.countryCodeAlpha2,\n                email: customer.email,\n                firstname: customer.firstName,\n                lastname: customer.lastName,\n                telephone: customer.phone\n            };\n\n            billingAddress['region_code'] = address.region;\n            billingAddress = createBillingAddress(billingAddress);\n            quote.billingAddress(billingAddress);\n        },\n\n        /**\n         * Prepare data to place order\n         * @param {Object} data\n         */\n        beforePlaceOrder: function (data) {\n            this.setPaymentMethodNonce(data.nonce);\n\n            if (quote.billingAddress() === null && typeof data.details.billingAddress !== 'undefined') {\n                this.setBillingAddress(data.details, data.details.billingAddress);\n            }\n\n            if (this.isSkipOrderReview()) {\n                this.placeOrder();\n            } else {\n                this.customerEmail(data.details.email);\n                this.isReviewRequired(true);\n            }\n        },\n\n        /**\n         * Re-init PayPal Auth Flow\n         */\n        reInitPayPal: function () {\n            if (Braintree.checkout) {\n                Braintree.checkout.teardown(function () {\n                    Braintree.checkout = null;\n                });\n            }\n\n            this.disableButton();\n            this.clientConfig.paypal.amount = this.grandTotalAmount;\n\n            Braintree.setConfig(this.clientConfig);\n            Braintree.setup();\n        },\n\n        /**\n         * Get locale\n         * @returns {String}\n         */\n        getLocale: function () {\n            return window.checkoutConfig.payment[this.getCode()].locale;\n        },\n\n        /**\n         * Is shipping address can be editable on PayPal side\n         * @returns {Boolean}\n         */\n        isAllowOverrideShippingAddress: function () {\n            return window.checkoutConfig.payment[this.getCode()].isAllowShippingAddressOverride;\n        },\n\n        /**\n         * Get configuration for PayPal\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            var totals = quote.totals(),\n                config = {},\n                isActiveVaultEnabler = this.isActiveVault();\n\n            config.paypal = {\n                container: 'paypal-container',\n                singleUse: !isActiveVaultEnabler,\n                headless: true,\n                amount: this.grandTotalAmount,\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n                enableShippingAddress: true,\n\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            config.paypal.shippingAddressOverride = this.getShippingAddress();\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        /**\n         * Get shipping address\n         * @returns {Object}\n         */\n        getShippingAddress: function () {\n            var address = quote.shippingAddress();\n\n            if (_.isNull(address.postcode) || _.isUndefined(address.postcode)) {\n\n                return {};\n            }\n\n            return {\n                recipientName: address.firstname + ' ' + address.lastname,\n                streetAddress: address.street[0],\n                locality: address.city,\n                countryCodeAlpha2: address.countryId,\n                postalCode: address.postcode,\n                region: address.regionCode,\n                phone: address.telephone,\n                editable: this.isAllowOverrideShippingAddress()\n            };\n        },\n\n        /**\n         * Get merchant name\n         * @returns {String}\n         */\n        getMerchantName: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantName;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * Returns payment acceptance mark image path\n         * @returns {String}\n         */\n        getPaymentAcceptanceMarkSrc: function () {\n\n            return window.checkoutConfig.payment[this.getCode()].paymentAcceptanceMarkSrc;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].vaultCode;\n        },\n\n        /**\n         * Check if need to skip order review\n         * @returns {Boolean}\n         */\n        isSkipOrderReview: function () {\n            return window.checkoutConfig.payment[this.getCode()].skipOrderReview;\n        },\n\n        /**\n         * Checks if vault is active\n         * @returns {Boolean}\n         */\n        isActiveVault: function () {\n            return this.vaultEnabler.isVaultEnabled() && this.vaultEnabler.isActivePaymentTokenEnabler();\n        },\n\n        /**\n         * Re-init PayPal Auth flow to use Vault\n         */\n        onVaultPaymentTokenEnablerChange: function () {\n            this.clientConfig.paypal.singleUse = !this.isActiveVault();\n            this.reInitPayPal();\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader(true);\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader();\n        },\n\n        /**\n         * Triggers when customer click \"Continue to PayPal\" button\n         */\n        payWithPayPal: function () {\n            if (additionalValidators.validate()) {\n                try {\n                    Braintree.checkout.paypal.initAuthFlow();\n                } catch (e) {\n                    this.messageContainer.addErrorMessage({\n                        message: $t('Payment ' + this.getTitle() + ' can\\'t be initialized.')\n                    });\n                }\n            }\n        },\n\n        /**\n         * Get button title\n         * @returns {String}\n         */\n        getButtonTitle: function () {\n            return this.isSkipOrderReview() ? 'Pay with PayPal' : 'Continue to PayPal';\n        },\n\n        /**\n         * Get button id\n         * @returns {String}\n         */\n        getButtonId: function () {\n            return this.getCode() + (this.isSkipOrderReview() ? '_pay_with' : '_continue_to');\n        }\n    });\n});\n","Magento_Braintree/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Braintree/js/view/payment/adapter',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, VaultComponent, Braintree, globalMessageList, fullScreenLoader) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'Magento_Vault/payment/form',\n            modules: {\n                hostedFields: '${ $.parentName }.braintree'\n            }\n        },\n\n        /**\n         * Get last 4 digits of card\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details.maskedCC;\n        },\n\n        /**\n         * Get expiration date\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details.expirationDate;\n        },\n\n        /**\n         * Get card type\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details.type;\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            var self = this;\n\n            /**\n             * Define onReady callback\n             */\n            Braintree.onReady = function () {\n                self.getPaymentMethodNonce();\n            };\n            self.hostedFields(function (formComponent) {\n                formComponent.initBraintree();\n            });\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            })\n                .done(function (response) {\n                    fullScreenLoader.stopLoader();\n                    self.hostedFields(function (formComponent) {\n                        formComponent.setPaymentMethodNonce(response.paymentMethodNonce);\n                        formComponent.additionalData['public_hash'] = self.publicHash;\n                        formComponent.code = self.code;\n                        formComponent.messageContainer = self.messageContainer;\n                        formComponent.placeOrder();\n                    });\n                })\n                .fail(function (response) {\n                    var error = JSON.parse(response.responseText);\n\n                    fullScreenLoader.stopLoader();\n                    globalMessageList.addErrorMessage({\n                        message: error.message\n                    });\n                });\n        }\n    });\n});\n","Magento_Braintree/js/view/payment/method-renderer/cc-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'Magento_Payment/js/view/payment/cc-form',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Braintree/js/view/payment/adapter',\n        'mage/translate',\n        'Magento_Braintree/js/validator',\n        'Magento_Braintree/js/view/payment/validator-handler',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        quote,\n        braintree,\n        $t,\n        validator,\n        validatorManager,\n        fullScreenLoader\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                active: false,\n                braintreeClient: null,\n                braintreeDeviceData: null,\n                paymentMethodNonce: null,\n                lastBillingAddress: null,\n                ccCode: null,\n                ccMessageContainer: null,\n                validatorManager: validatorManager,\n                code: 'braintree',\n\n                /**\n                 * Additional payment data\n                 *\n                 * {Object}\n                 */\n                additionalData: {},\n\n                /**\n                 * Braintree client configuration\n                 *\n                 * {Object}\n                 */\n                clientConfig: {\n\n                    /**\n                     * Triggers on payment nonce receive\n                     * @param {Object} response\n                     */\n                    onPaymentMethodReceived: function (response) {\n                        this.beforePlaceOrder(response);\n                    },\n\n                    /**\n                     * Device data initialization\n                     *\n                     * @param {Object} checkout\n                     */\n                    onReady: function (checkout) {\n                        braintree.checkout = checkout;\n                        braintree.onReady();\n                    },\n\n                    /**\n                     * Triggers on any Braintree error\n                     * @param {Object} response\n                     */\n                    onError: function (response) {\n                        braintree.showError($t('Payment ' + this.getTitle() + ' can\\'t be initialized'));\n                        throw response.message;\n                    },\n\n                    /**\n                     * Triggers when customer click \"Cancel\"\n                     */\n                    onCancelled: function () {\n                        this.paymentMethodNonce = null;\n                    }\n                },\n                imports: {\n                    onActiveChange: 'active'\n                }\n            },\n\n            /**\n             * Set list of observable attributes\n             *\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                validator.setConfig(window.checkoutConfig.payment[this.getCode()]);\n                this._super()\n                    .observe(['active']);\n                this.validatorManager.initialize();\n                this.initClientConfig();\n\n                return this;\n            },\n\n            /**\n             * Get payment name\n             *\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Check if payment is active\n             *\n             * @returns {Boolean}\n             */\n            isActive: function () {\n                var active = this.getCode() === this.isChecked();\n\n                this.active(active);\n\n                return active;\n            },\n\n            /**\n             * Triggers when payment method change\n             * @param {Boolean} isActive\n             */\n            onActiveChange: function (isActive) {\n                if (!isActive) {\n                    return;\n                }\n\n                this.restoreMessageContainer();\n                this.restoreCode();\n\n                /**\n                 * Define onReady callback\n                 */\n                braintree.onReady = function () {};\n                this.initBraintree();\n            },\n\n            /**\n             * Restore original message container for cc-form component\n             */\n            restoreMessageContainer: function () {\n                this.messageContainer = this.ccMessageContainer;\n            },\n\n            /**\n             * Restore original code for cc-form component\n             */\n            restoreCode: function () {\n                this.code = this.ccCode;\n            },\n\n            /** @inheritdoc */\n            initChildren: function () {\n                this._super();\n                this.ccMessageContainer = this.messageContainer;\n                this.ccCode = this.code;\n\n                return this;\n            },\n\n            /**\n             * Init config\n             */\n            initClientConfig: function () {\n                // Advanced fraud tools settings\n                if (this.hasFraudProtection()) {\n                    this.clientConfig = _.extend(this.clientConfig, this.kountConfig());\n                }\n\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n            },\n\n            /**\n             * Init Braintree configuration\n             */\n            initBraintree: function () {\n                var intervalId = setInterval(function () {\n                    // stop loader when frame will be loaded\n                    if ($('#braintree-hosted-field-number').length) {\n                        clearInterval(intervalId);\n                        fullScreenLoader.stopLoader();\n                    }\n                }, 500);\n\n                if (braintree.checkout) {\n                    braintree.checkout.teardown(function () {\n                        braintree.checkout = null;\n                    });\n                }\n\n                fullScreenLoader.startLoader();\n                braintree.setConfig(this.clientConfig);\n                braintree.setup();\n            },\n\n            /**\n             * @returns {Object}\n             */\n            kountConfig: function () {\n                var config = {\n                    dataCollector: {\n                        kount: {\n                            environment: this.getEnvironment()\n                        }\n                    },\n\n                    /**\n                     * Device data initialization\n                     *\n                     * @param {Object} checkout\n                     */\n                    onReady: function (checkout) {\n                        braintree.checkout = checkout;\n                        this.additionalData['device_data'] = checkout.deviceData;\n                        braintree.onReady();\n                    }\n                };\n\n                if (this.getKountMerchantId()) {\n                    config.dataCollector.kount.merchantId = this.getKountMerchantId();\n                }\n\n                return config;\n            },\n\n            /**\n             * Get full selector name\n             *\n             * @param {String} field\n             * @returns {String}\n             */\n            getSelector: function (field) {\n                return '#' + this.getCode() + '_' + field;\n            },\n\n            /**\n             * Get list of available CC types\n             *\n             * @returns {Object}\n             */\n            getCcAvailableTypes: function () {\n                var availableTypes = validator.getAvailableCardTypes(),\n                    billingAddress = quote.billingAddress(),\n                    billingCountryId;\n\n                this.lastBillingAddress = quote.shippingAddress();\n\n                if (!billingAddress) {\n                    billingAddress = this.lastBillingAddress;\n                }\n\n                billingCountryId = billingAddress.countryId;\n\n                if (billingCountryId && validator.getCountrySpecificCardTypes(billingCountryId)) {\n\n                    return validator.collectTypes(\n                        availableTypes, validator.getCountrySpecificCardTypes(billingCountryId)\n                    );\n                }\n\n                return availableTypes;\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            hasFraudProtection: function () {\n                return window.checkoutConfig.payment[this.getCode()].hasFraudProtection;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getEnvironment: function () {\n                return window.checkoutConfig.payment[this.getCode()].environment;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getKountMerchantId: function () {\n                return window.checkoutConfig.payment[this.getCode()].kountMerchantId;\n            },\n\n            /**\n             * Get data\n             *\n             * @returns {Object}\n             */\n            getData: function () {\n                var data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            /**\n             * Set payment nonce\n             * @param {String} paymentMethodNonce\n             */\n            setPaymentMethodNonce: function (paymentMethodNonce) {\n                this.paymentMethodNonce = paymentMethodNonce;\n            },\n\n            /**\n             * Prepare data to place order\n             * @param {Object} data\n             */\n            beforePlaceOrder: function (data) {\n                this.setPaymentMethodNonce(data.nonce);\n                this.placeOrder();\n            },\n\n            /**\n             * Action to place order\n             * @param {String} key\n             */\n            placeOrder: function (key) {\n                var self = this;\n\n                if (key) {\n                    return self._super();\n                }\n                // place order on success validation\n                self.validatorManager.validate(self, function () {\n                    return self.placeOrder('parent');\n                });\n\n                return false;\n            }\n        });\n    }\n);\n","Magento_Braintree/js/view/payment/method-renderer/paypal-vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, _, VaultComponent, globalMessageList, fullScreenLoader) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'Magento_Braintree/payment/paypal/vault',\n            additionalData: {}\n        },\n\n        /**\n         * Get PayPal payer email\n         * @returns {String}\n         */\n        getPayerEmail: function () {\n            return this.details.payerEmail;\n        },\n\n        /**\n         * Get type of payment\n         * @returns {String}\n         */\n        getPaymentIcon: function () {\n            return window.checkoutConfig.payment['braintree_paypal'].paymentIcon;\n        },\n\n        /**\n         * Place order\n         */\n        beforePlaceOrder: function () {\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            })\n                .done(function (response) {\n                    fullScreenLoader.stopLoader();\n                    self.additionalData['payment_method_nonce'] = response.paymentMethodNonce;\n                    self.placeOrder();\n                })\n                .fail(function (response) {\n                    var error = JSON.parse(response.responseText);\n\n                    fullScreenLoader.stopLoader();\n                    globalMessageList.addErrorMessage({\n                        message: error.message\n                    });\n                });\n        },\n\n        /**\n         * Get payment method data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.code,\n                'additional_data': {\n                    'public_hash': this.publicHash\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            return data;\n        }\n    });\n});\n","Magento_Downloadable/downloadable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui',\n    'Magento_Catalog/js/price-box'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.downloadable', {\n        options: {\n            priceHolderSelector: '.price-box'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var self = this;\n\n            this.element.find(this.options.linkElement).on('change', $.proxy(function () {\n                this._reloadPrice();\n            }, this));\n\n            this.element.find(this.options.allElements).on('change', function () {\n                if (this.checked) {\n                    $('label[for=\"' + this.id + '\"] > span').text($(this).attr('data-checked'));\n                    self.element.find(self.options.linkElement + ':not(:checked)').each(function () {\n                        $(this).trigger('click');\n                    });\n                } else {\n                    $('[for=\"' + this.id + '\"] > span').text($(this).attr('data-notchecked'));\n                    self.element.find(self.options.linkElement + ':checked').each(function () {\n                        $(this).trigger('click');\n                    });\n                }\n            });\n        },\n\n        /**\n         * Reload product price with selected link price included\n         * @private\n         */\n        _reloadPrice: function () {\n            var finalPrice = 0,\n                basePrice = 0;\n\n            this.element.find(this.options.linkElement + ':checked').each($.proxy(function (index, element) {\n                finalPrice += this.options.config.links[$(element).val()].finalPrice;\n                basePrice += this.options.config.links[$(element).val()].basePrice;\n            }, this));\n\n            $(this.options.priceHolderSelector).trigger('updatePrice', {\n                'prices': {\n                    'finalPrice': {\n                        'amount': finalPrice\n                    },\n                    'basePrice': {\n                        'amount': basePrice\n                    }\n                }\n            });\n        }\n    });\n\n    return $.mage.downloadable;\n});\n","Magento_SalesRule/js/model/payment/discount-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/model/messages'\n], function (Messages) {\n    'use strict';\n\n    return new Messages();\n});\n","Magento_SalesRule/js/action/cancel-coupon.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Customer store credit(balance) application\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_SalesRule/js/model/payment/discount-messages',\n    'mage/storage',\n    'Magento_Checkout/js/action/get-payment-information',\n    'Magento_Checkout/js/model/totals',\n    'mage/translate',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, quote, urlManager, errorProcessor, messageContainer, storage, getPaymentInformationAction, totals, $t,\n  fullScreenLoader\n) {\n    'use strict';\n\n    return function (isApplied) {\n        var quoteId = quote.getQuoteId(),\n            url = urlManager.getCancelCouponUrl(quoteId),\n            message = $t('Your coupon was successfully removed.');\n\n        messageContainer.clear();\n        fullScreenLoader.startLoader();\n\n        return storage.delete(\n            url,\n            false\n        ).done(function () {\n            var deferred = $.Deferred();\n\n            totals.isLoading(true);\n            getPaymentInformationAction(deferred);\n            $.when(deferred).done(function () {\n                isApplied(false);\n                totals.isLoading(false);\n                fullScreenLoader.stopLoader();\n            });\n            messageContainer.addSuccessMessage({\n                'message': message\n            });\n        }).fail(function (response) {\n            totals.isLoading(false);\n            fullScreenLoader.stopLoader();\n            errorProcessor.process(response, messageContainer);\n        });\n    };\n});\n","Magento_SalesRule/js/action/set-coupon-code.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Customer store credit(balance) application\n */\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_SalesRule/js/model/payment/discount-messages',\n    'mage/storage',\n    'mage/translate',\n    'Magento_Checkout/js/action/get-payment-information',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function (ko, $, quote, urlManager, errorProcessor, messageContainer, storage, $t, getPaymentInformationAction,\n    totals, fullScreenLoader\n) {\n    'use strict';\n\n    return function (couponCode, isApplied) {\n        var quoteId = quote.getQuoteId(),\n            url = urlManager.getApplyCouponUrl(couponCode, quoteId),\n            message = $t('Your coupon was successfully applied.');\n\n        fullScreenLoader.startLoader();\n\n        return storage.put(\n            url,\n            {},\n            false\n        ).done(function (response) {\n            var deferred;\n\n            if (response) {\n                deferred = $.Deferred();\n\n                isApplied(true);\n                totals.isLoading(true);\n                getPaymentInformationAction(deferred);\n                $.when(deferred).done(function () {\n                    fullScreenLoader.stopLoader();\n                    totals.isLoading(false);\n                });\n                messageContainer.addSuccessMessage({\n                    'message': message\n                });\n            }\n        }).fail(function (response) {\n            fullScreenLoader.stopLoader();\n            totals.isLoading(false);\n            errorProcessor.process(response, messageContainer);\n        });\n    };\n});\n","Magento_SalesRule/js/view/cart/totals/discount.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_SalesRule/js/view/summary/discount'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_SalesRule/cart/totals/discount'\n        },\n\n        /**\n         * @override\n         *\n         * @returns {Boolean}\n         */\n        isDisplayed: function () {\n            return this.getPureValue() != 0; //eslint-disable-line eqeqeq\n        }\n    });\n});\n","Magento_SalesRule/js/view/payment/discount.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_SalesRule/js/action/set-coupon-code',\n    'Magento_SalesRule/js/action/cancel-coupon'\n], function ($, ko, Component, quote, setCouponCodeAction, cancelCouponAction) {\n    'use strict';\n\n    var totals = quote.getTotals(),\n        couponCode = ko.observable(null),\n        isApplied;\n\n    if (totals()) {\n        couponCode(totals()['coupon_code']);\n    }\n    isApplied = ko.observable(couponCode() != null);\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_SalesRule/payment/discount'\n        },\n        couponCode: couponCode,\n\n        /**\n         * Applied flag\n         */\n        isApplied: isApplied,\n\n        /**\n         * Coupon code application procedure\n         */\n        apply: function () {\n            if (this.validate()) {\n                setCouponCodeAction(couponCode(), isApplied);\n            }\n        },\n\n        /**\n         * Cancel using coupon\n         */\n        cancel: function () {\n            if (this.validate()) {\n                couponCode('');\n                cancelCouponAction(isApplied);\n            }\n        },\n\n        /**\n         * Coupon form validation\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            var form = '#discount-form';\n\n            return $(form).validation() && $(form).validation('isValid');\n        }\n    });\n});\n","Magento_SalesRule/js/view/payment/discount-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/view/messages',\n    '../../model/payment/discount-messages'\n], function (Component, messageContainer) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function (config) {\n            return this._super(config, messageContainer);\n        }\n    });\n});\n","Magento_SalesRule/js/view/summary/discount.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_SalesRule/summary/discount'\n        },\n        totals: quote.getTotals(),\n\n        /**\n         * @return {*|Boolean}\n         */\n        isDisplayed: function () {\n            return this.isFullMode() && this.getPureValue() != 0; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*}\n         */\n        getCouponCode: function () {\n            if (!this.totals()) {\n                return null;\n            }\n\n            return this.totals()['coupon_code'];\n        },\n\n        /**\n         * @return {*}\n         */\n        getCouponLabel: function () {\n            if (!this.totals()) {\n                return null;\n            }\n\n            return this.totals()['coupon_label'];\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            var price = 0;\n\n            if (this.totals() && this.totals()['discount_amount']) {\n                price = parseFloat(this.totals()['discount_amount']);\n            }\n\n            return price;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/coupon-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/select'\n], function (_, uiRegistry, select) {\n    'use strict';\n\n    return select.extend({\n\n        /**\n         * Hide fields on coupon tab\n         */\n        onUpdate: function () {\n\n            /* eslint-disable eqeqeq */\n            if (this.value() != this.displayOnlyForCouponType) {\n                uiRegistry.get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation').checked(false);\n            }\n\n            this.enableDisableFields();\n        },\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/manage-coupon-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (_, uiRegistry, fieldset, async) {\n    'use strict';\n\n    return fieldset.extend({\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Initialize element\n         *\n         * @returns {Abstract} Chainable\n         */\n        initialize: function (elems, position) {\n            var obj = this;\n\n            this._super();\n\n            async.async('#sales-rule-form-tab-coupons', document.getElementById('container'), function (node) {\n                var useAutoGeneration = uiRegistry.get(\n                    'sales_rule_form.sales_rule_form.rule_information.use_auto_generation'\n                );\n\n                useAutoGeneration.on('checked', function () {\n                    obj.enableDisableFields();\n                });\n                obj.enableDisableFields();\n            });\n\n            return this;\n        },\n\n        /*eslint-enable no-unused-vars*/\n        /*eslint-disable lines-around-comment*/\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            /**\n             * \\Magento\\Rule\\Model\\AbstractModel::COUPON_TYPE_AUTO\n             */\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Dotdigitalgroup_Email/js/roiCode.js":"define(['trackingCode', 'domReady!'], function (_dmTrack) {\n    'use strict';\n\n    /**\n     * ROI\n     * @param {Array} items\n     * @param {Float} total\n     */\n    function init(items, total) {\n        var fLen = items.length,\n            i = 0;\n\n        for (i; i < fLen; i++) {\n            _dmTrack('product', items[i]);\n        }\n        _dmTrack('CheckOutAmount', total);\n    }\n\n    /**\n     * Export/return tracking code init\n     * @param {Object} roiCode\n     */\n    return function (roiCode) {\n        if (roiCode.isEnabled) {\n            init(roiCode.items, roiCode.total);\n        }\n    };\n});\n\n","Dotdigitalgroup_Email/js/newsletterPreferences.js":"require([\n    'jquery',\n    'mage/calendar',\n    'domReady!'\n    ], function ($) {\n    'use strict';\n\n    $('.date-field').each(function () {\n        $(this).calendar({\n            showTime: false\n        });\n    });\n});\n","Dotdigitalgroup_Email/js/trackingCode.js":"define(['domReady!'], function () {\n    'use strict';\n\n    /**\n     * Create script tag\n     */\n    function createTag() {\n        var connector = document.createElement('script'),\n            s = document.getElementsByTagName('script')[0];\n\n        connector.type = 'text/javascript';\n        connector.src =\n            (document.location.protocol === 'https:' ? 'https://' : 'http://') + 't.trackedlink.net/_dmpt.js';\n        s.parentNode.insertBefore(connector, s);\n    }\n\n    /**\n     * Export/return tracking code init\n     * @param {Object} trackingCode\n     */\n    return function (trackingCode) {\n        if (trackingCode.isEnabled) {\n            createTag();\n        }\n    };\n});\n\n","Dotdigitalgroup_Email/js/emailCapture.js":"define(['jquery', 'domReady!'], function ($) {\n    'use strict';\n\n    /**\n     * Email validation\n     * @param {String} sEmail\n     * @returns {Boolean}\n     */\n    function validateEmail(sEmail) {\n        var filter\n            = /^([\\w-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([\\w-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$/;\n\n        return filter.test(sEmail);\n    }\n\n    /**\n     * Email capture for checkout\n     * @param {String} url\n     */\n    function emailCaptureCheckout(url) {\n        $('body').on('blur', 'input[id=customer-email]', function () {\n            var email = $(this).val();\n\n            if (email && validateEmail(email)) {\n                $.post(url, {\n                    email: email\n                });\n            }\n        });\n    }\n\n    /**\n     * Email capture for newsletter field\n     * @param {String} url\n     */\n    function emailCaptureNewsletter(url) {\n        $('input[id=newsletter]').each(function (index, element) {\n            // Observe onblur event on element\n            $(element).on('blur', function () {\n                var email = $(element).val();\n\n                if (email && validateEmail(email)) {\n                    $.post(url, {\n                        email: email\n                    });\n                }\n            });\n        });\n    }\n\n    /**\n     * Exported/return email capture\n     * @param {Object} emailCapture\n     */\n    return function (emailCapture) {\n        if (emailCapture.isEnabled && emailCapture.type === 'checkout') {\n            emailCaptureCheckout(emailCapture.url);\n        }\n\n        if (emailCapture.isEnabled && emailCapture.type === 'newsletter') {\n            emailCaptureNewsletter(emailCapture.url);\n        }\n    };\n});\n","Magento_Checkout/js/shopping-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.shoppingCart', {\n        /** @inheritdoc */\n        _create: function () {\n            var items, i;\n\n            $(this.options.emptyCartButton).on('click', $.proxy(function () {\n                $(this.options.emptyCartButton).attr('name', 'update_cart_action_temp');\n                $(this.options.updateCartActionContainer)\n                    .attr('name', 'update_cart_action').attr('value', 'empty_cart');\n            }, this));\n            items = $.find('[data-role=\"cart-item-qty\"]');\n\n            for (i = 0; i < items.length; i++) {\n                $(items[i]).on('keypress', $.proxy(function (event) { //eslint-disable-line no-loop-func\n                    var keyCode = event.keyCode ? event.keyCode : event.which;\n\n                    if (keyCode == 13) { //eslint-disable-line eqeqeq\n                        $(this.options.emptyCartButton).attr('name', 'update_cart_action_temp');\n                        $(this.options.updateCartActionContainer)\n                            .attr('name', 'update_cart_action').attr('value', 'update_qty');\n\n                    }\n                }, this));\n            }\n            $(this.options.continueShoppingButton).on('click', $.proxy(function () {\n                location.href = this.options.continueShoppingUrl;\n            }, this));\n        }\n    });\n\n    return $.mage.shoppingCart;\n});\n","Magento_Checkout/js/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/authentication-popup',\n    'Magento_Customer/js/customer-data',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'jquery/ui',\n    'mage/decorate',\n    'mage/collapsible',\n    'mage/cookies'\n], function ($, authenticationPopup, customerData, alert, confirm) {\n    'use strict';\n\n    $.widget('mage.sidebar', {\n        options: {\n            isRecursive: true,\n            minicart: {\n                maxItemsVisible: 3\n            }\n        },\n        scrollHeight: 0,\n\n        /**\n         * Create sidebar.\n         * @private\n         */\n        _create: function () {\n            this._initContent();\n        },\n\n        /**\n         * Update sidebar block.\n         */\n        update: function () {\n            $(this.options.targetElement).trigger('contentUpdated');\n            this._calcHeight();\n            this._isOverflowed();\n        },\n\n        /**\n         * @private\n         */\n        _initContent: function () {\n            var self = this,\n                events = {};\n\n            this.element.decorate('list', this.options.isRecursive);\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.button.close] = function (event) {\n                event.stopPropagation();\n                $(self.options.targetElement).dropdownDialog('close');\n            };\n            events['click ' + this.options.button.checkout] = $.proxy(function () {\n                var cart = customerData.get('cart'),\n                    customer = customerData.get('customer');\n\n                if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {\n                    // set URL for redirect on successful login/registration. It's postprocessed on backend.\n                    $.cookie('login_redirect', this.options.url.checkout);\n\n                    if (this.options.url.isRedirectRequired) {\n                        location.href = this.options.url.loginUrl;\n                    } else {\n                        authenticationPopup.showModal();\n                    }\n\n                    return false;\n                }\n                location.href = this.options.url.checkout;\n            }, this);\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.button.remove] =  function (event) {\n                event.stopPropagation();\n                confirm({\n                    content: self.options.confirmMessage,\n                    actions: {\n                        /** @inheritdoc */\n                        confirm: function () {\n                            self._removeItem($(event.currentTarget));\n                        },\n\n                        /** @inheritdoc */\n                        always: function (e) {\n                            e.stopImmediatePropagation();\n                        }\n                    }\n                });\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['keyup ' + this.options.item.qty] = function (event) {\n                self._showItemButton($(event.target));\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.item.button] = function (event) {\n                event.stopPropagation();\n                self._updateItemQty($(event.currentTarget));\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['focusout ' + this.options.item.qty] = function (event) {\n                self._validateQty($(event.currentTarget));\n            };\n\n            this._on(this.element, events);\n            this._calcHeight();\n            this._isOverflowed();\n        },\n\n        /**\n         * Add 'overflowed' class to minicart items wrapper element\n         *\n         * @private\n         */\n        _isOverflowed: function () {\n            var list = $(this.options.minicart.list),\n                cssOverflowClass = 'overflowed';\n\n            if (this.scrollHeight > list.innerHeight()) {\n                list.parent().addClass(cssOverflowClass);\n            } else {\n                list.parent().removeClass(cssOverflowClass);\n            }\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _showItemButton: function (elem) {\n            var itemId = elem.data('cart-item'),\n                itemQty = elem.data('item-qty');\n\n            if (this._isValidQty(itemQty, elem.val())) {\n                $('#update-cart-item-' + itemId).show('fade', 300);\n            } else if (elem.val() == 0) { //eslint-disable-line eqeqeq\n                this._hideItemButton(elem);\n            } else {\n                this._hideItemButton(elem);\n            }\n        },\n\n        /**\n         * @param {*} origin - origin qty. 'data-item-qty' attribute.\n         * @param {*} changed - new qty.\n         * @returns {Boolean}\n         * @private\n         */\n        _isValidQty: function (origin, changed) {\n            return origin != changed && //eslint-disable-line eqeqeq\n                changed.length > 0 &&\n                changed - 0 == changed && //eslint-disable-line eqeqeq\n                changed - 0 > 0;\n        },\n\n        /**\n         * @param {Object} elem\n         * @private\n         */\n        _validateQty: function (elem) {\n            var itemQty = elem.data('item-qty');\n\n            if (!this._isValidQty(itemQty, elem.val())) {\n                elem.val(itemQty);\n            }\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _hideItemButton: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            $('#update-cart-item-' + itemId).hide('fade', 300);\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _updateItemQty: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            this._ajax(this.options.url.update, {\n                'item_id': itemId,\n                'item_qty': $('#cart-item-' + itemId + '-qty').val()\n            }, elem, this._updateItemQtyAfter);\n        },\n\n        /**\n         * Update content after update qty\n         *\n         * @param {HTMLElement} elem\n         */\n        _updateItemQtyAfter: function (elem) {\n            this._hideItemButton(elem);\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _removeItem: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            this._ajax(this.options.url.remove, {\n                'item_id': itemId\n            }, elem, this._removeItemAfter);\n        },\n\n        /**\n         * Update content after item remove\n         *\n         * @param {Object} elem\n         * @private\n         */\n        _removeItemAfter: function (elem) {\n            var productData = customerData.get('cart')().items.find(function (item) {\n                return Number(elem.data('cart-item')) === Number(item['item_id']);\n            });\n\n            $(document).trigger('ajax:removeFromCart', productData['product_sku']);\n        },\n\n        /**\n         * @param {String} url - ajax url\n         * @param {Object} data - post data for ajax call\n         * @param {Object} elem - element that initiated the event\n         * @param {Function} callback - callback method to execute after AJAX success\n         */\n        _ajax: function (url, data, elem, callback) {\n            $.extend(data, {\n                'form_key': $.mage.cookies.get('form_key')\n            });\n\n            $.ajax({\n                url: url,\n                data: data,\n                type: 'post',\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    elem.attr('disabled', 'disabled');\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    elem.attr('disabled', null);\n                }\n            })\n                .done(function (response) {\n                    var msg;\n\n                    if (response.success) {\n                        callback.call(this, elem, response);\n                    } else {\n                        msg = response['error_message'];\n\n                        if (msg) {\n                            alert({\n                                content: msg\n                            });\n                        }\n                    }\n                })\n                .fail(function (error) {\n                    console.log(JSON.stringify(error));\n                });\n        },\n\n        /**\n         * Calculate height of minicart list\n         *\n         * @private\n         */\n        _calcHeight: function () {\n            var self = this,\n                height = 0,\n                counter = this.options.minicart.maxItemsVisible,\n                target = $(this.options.minicart.list),\n                outerHeight;\n\n            self.scrollHeight = 0;\n            target.children().each(function () {\n\n                if ($(this).find('.options').length > 0) {\n                    $(this).collapsible();\n                }\n                outerHeight = $(this).outerHeight();\n\n                if (counter-- > 0) {\n                    height += outerHeight;\n                }\n                self.scrollHeight += outerHeight;\n            });\n\n            target.parent().height(height);\n        }\n    });\n\n    return $.mage.sidebar;\n});\n","Magento_Checkout/js/region-updater.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'underscore',\n    'jquery/ui',\n    'mage/validation'\n], function ($, mageTemplate, _) {\n    'use strict';\n\n    $.widget('mage.regionUpdater', {\n        options: {\n            regionTemplate:\n                '<option value=\"<%- data.value %>\" <% if (data.isSelected) { %>selected=\"selected\"<% } %>>' +\n                    '<%- data.title %>' +\n                '</option>',\n            isRegionRequired: true,\n            isZipRequired: true,\n            isCountryRequired: true,\n            currentRegion: null,\n            isMultipleCountriesAllowed: true\n        },\n\n        /**\n         *\n         * @private\n         */\n        _create: function () {\n            this._initCountryElement();\n\n            this.currentRegionOption = this.options.currentRegion;\n            this.regionTmpl = mageTemplate(this.options.regionTemplate);\n\n            this._updateRegion(this.element.find('option:selected').val());\n\n            $(this.options.regionListId).on('change', $.proxy(function (e) {\n                this.setOption = false;\n                this.currentRegionOption = $(e.target).val();\n            }, this));\n\n            $(this.options.regionInputId).on('focusout', $.proxy(function () {\n                this.setOption = true;\n            }, this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initCountryElement: function () {\n\n            if (this.options.isMultipleCountriesAllowed) {\n                this.element.parents('div.field').show();\n                this.element.on('change', $.proxy(function (e) {\n                    this._updateRegion($(e.target).val());\n                }, this));\n\n                if (this.options.isCountryRequired) {\n                    this.element.addClass('required-entry');\n                    this.element.parents('div.field').addClass('required');\n                }\n            } else {\n                this.element.parents('div.field').hide();\n            }\n        },\n\n        /**\n         * Remove options from dropdown list\n         *\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @private\n         */\n        _removeSelectOptions: function (selectElement) {\n            selectElement.find('option').each(function (index) {\n                if (index) {\n                    $(this).remove();\n                }\n            });\n        },\n\n        /**\n         * Render dropdown list\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @param {String} key - region code\n         * @param {Object} value - region object\n         * @private\n         */\n        _renderSelectOption: function (selectElement, key, value) {\n            selectElement.append($.proxy(function () {\n                var name = value.name.replace(/[!\"#$%&'()*+,.\\/:;<=>?@[\\\\\\]^`{|}~]/g, '\\\\$&'),\n                    tmplData,\n                    tmpl;\n\n                if (value.code && $(name).is('span')) {\n                    key = value.code;\n                    value.name = $(name).text();\n                }\n\n                tmplData = {\n                    value: key,\n                    title: value.name,\n                    isSelected: false\n                };\n\n                if (this.options.defaultRegion === key) {\n                    tmplData.isSelected = true;\n                }\n\n                tmpl = this.regionTmpl({\n                    data: tmplData\n                });\n\n                return $(tmpl);\n            }, this));\n        },\n\n        /**\n         * Takes clearError callback function as first option\n         * If no form is passed as option, look up the closest form and call clearError method.\n         * @private\n         */\n        _clearError: function () {\n            var args = ['clearError', this.options.regionListId, this.options.regionInputId, this.options.postcodeId];\n\n            if (this.options.clearError && typeof this.options.clearError === 'function') {\n                this.options.clearError.call(this);\n            } else {\n                if (!this.options.form) {\n                    this.options.form = this.element.closest('form').length ? $(this.element.closest('form')[0]) : null;\n                }\n\n                this.options.form = $(this.options.form);\n\n                this.options.form && this.options.form.data('validator') &&\n                    this.options.form.validation.apply(this.options.form, _.compact(args));\n\n                // Clean up errors on region & zip fix\n                $(this.options.regionInputId).removeClass('mage-error').parent().find('[generated]').remove();\n                $(this.options.regionListId).removeClass('mage-error').parent().find('[generated]').remove();\n                $(this.options.postcodeId).removeClass('mage-error').parent().find('[generated]').remove();\n            }\n        },\n\n        /**\n         * Update dropdown list based on the country selected\n         *\n         * @param {String} country - 2 uppercase letter for country code\n         * @private\n         */\n        _updateRegion: function (country) {\n            // Clear validation error messages\n            var regionList = $(this.options.regionListId),\n                regionInput = $(this.options.regionInputId),\n                postcode = $(this.options.postcodeId),\n                label = regionList.parent().siblings('label'),\n                requiredLabel = regionList.parents('div.field');\n\n            this._clearError();\n            this._checkRegionRequired(country);\n\n            // Populate state/province dropdown list if available or use input box\n            if (this.options.regionJson[country]) {\n                this._removeSelectOptions(regionList);\n                $.each(this.options.regionJson[country], $.proxy(function (key, value) {\n                    this._renderSelectOption(regionList, key, value);\n                }, this));\n\n                if (this.currentRegionOption) {\n                    regionList.val(this.currentRegionOption);\n                }\n\n                if (this.setOption) {\n                    regionList.find('option').filter(function () {\n                        return this.text === regionInput.val();\n                    }).attr('selected', true);\n                }\n\n                if (this.options.isRegionRequired) {\n                    regionList.addClass('required-entry').removeAttr('disabled');\n                    requiredLabel.addClass('required');\n                } else {\n                    regionList.removeClass('required-entry validate-select').removeAttr('data-validate');\n                    requiredLabel.removeClass('required');\n\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionList.attr('disabled', 'disabled');\n                    }\n                }\n\n                regionList.show();\n                regionInput.hide();\n                label.attr('for', regionList.attr('id'));\n            } else {\n                if (this.options.isRegionRequired) {\n                    regionInput.addClass('required-entry').removeAttr('disabled');\n                    requiredLabel.addClass('required');\n                } else {\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionInput.attr('disabled', 'disabled');\n                    }\n                    requiredLabel.removeClass('required');\n                    regionInput.removeClass('required-entry');\n                }\n\n                regionList.removeClass('required-entry').prop('disabled', 'disabled').hide();\n                regionInput.show();\n                label.attr('for', regionInput.attr('id'));\n            }\n\n            // If country is in optionalzip list, make postcode input not required\n            if (this.options.isZipRequired) {\n                $.inArray(country, this.options.countriesWithOptionalZip) >= 0 ?\n                    postcode.removeClass('required-entry').closest('.field').removeClass('required') :\n                    postcode.addClass('required-entry').closest('.field').addClass('required');\n            }\n\n            // Add defaultvalue attribute to state/province select element\n            regionList.attr('defaultvalue', this.options.defaultRegion);\n        },\n\n        /**\n         * Check if the selected country has a mandatory region selection\n         *\n         * @param {String} country - Code of the country - 2 uppercase letter for country code\n         * @private\n         */\n        _checkRegionRequired: function (country) {\n            var self = this;\n\n            this.options.isRegionRequired = false;\n            $.each(this.options.regionJson.config['regions_required'], function (index, elem) {\n                if (elem === country) {\n                    self.options.isRegionRequired = true;\n                }\n            });\n        }\n    });\n\n    return $.mage.regionUpdater;\n});\n","Magento_Checkout/js/checkout-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'rjsResolver'\n], function (resolver) {\n    'use strict';\n\n    /**\n     * Removes provided loader element from DOM.\n     *\n     * @param {HTMLElement} $loader - Loader DOM element.\n     */\n    function hideLoader($loader) {\n        $loader.parentNode.removeChild($loader);\n    }\n\n    /**\n     * Initializes assets loading process listener.\n     *\n     * @param {Object} config - Optional configuration\n     * @param {HTMLElement} $loader - Loader DOM element.\n     */\n    function init(config, $loader) {\n        resolver(hideLoader.bind(null, $loader));\n    }\n\n    return init;\n});\n","Magento_Checkout/js/discount-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.discountCode', {\n        options: {\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.couponCode = $(this.options.couponCodeSelector);\n            this.removeCoupon = $(this.options.removeCouponSelector);\n\n            $(this.options.applyButton).on('click', $.proxy(function () {\n                this.couponCode.attr('data-validate', '{required:true}');\n                this.removeCoupon.attr('value', '0');\n                $(this.element).validation().submit();\n            }, this));\n\n            $(this.options.cancelButton).on('click', $.proxy(function () {\n                this.couponCode.removeAttr('data-validate');\n                this.removeCoupon.attr('value', '1');\n                this.element.submit();\n            }, this));\n        }\n    });\n\n    return $.mage.discountCode;\n});\n","Magento_Checkout/js/checkout-data.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Checkout adapter for customer data storage\n *\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data'\n], function ($, storage) {\n    'use strict';\n\n    var cacheKey = 'checkout-data',\n\n        /**\n         * @param {Object} data\n         */\n        saveData = function (data) {\n            storage.set(cacheKey, data);\n        },\n\n        /**\n         * @return {*}\n         */\n        getData = function () {\n            var data = storage.get(cacheKey)();\n\n            if ($.isEmptyObject(data)) {\n                data = {\n                    'selectedShippingAddress': null, //Selected shipping address pulled from persistence storage\n                    'shippingAddressFromData': null, //Shipping address pulled from persistence storage\n                    'newCustomerShippingAddress': null, //Shipping address pulled from persistence storage for customer\n                    'selectedShippingRate': null, //Shipping rate pulled from persistence storage\n                    'selectedPaymentMethod': null, //Payment method pulled from persistence storage\n                    'selectedBillingAddress': null, //Selected billing address pulled from persistence storage\n                    'billingAddressFromData': null, //Billing address pulled from persistence storage\n                    'newCustomerBillingAddress': null //Billing address pulled from persistence storage for new customer\n                };\n                saveData(data);\n            }\n\n            return data;\n        };\n\n    return {\n        /**\n         * Setting the selected shipping address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedShippingAddress: function (data) {\n            var obj = getData();\n\n            obj.selectedShippingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected shipping address from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedShippingAddress: function () {\n            return getData().selectedShippingAddress;\n        },\n\n        /**\n         * Setting the shipping address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setShippingAddressFromData: function (data) {\n            var obj = getData();\n\n            obj.shippingAddressFromData = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the shipping address from persistence storage\n         *\n         * @return {*}\n         */\n        getShippingAddressFromData: function () {\n            return getData().shippingAddressFromData;\n        },\n\n        /**\n         * Setting the shipping address pulled from persistence storage for new customer\n         *\n         * @param {Object} data\n         */\n        setNewCustomerShippingAddress: function (data) {\n            var obj = getData();\n\n            obj.newCustomerShippingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the shipping address from persistence storage for new customer\n         *\n         * @return {*}\n         */\n        getNewCustomerShippingAddress: function () {\n            return getData().newCustomerShippingAddress;\n        },\n\n        /**\n         * Setting the selected shipping rate pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedShippingRate: function (data) {\n            var obj = getData();\n\n            obj.selectedShippingRate = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected shipping rate from local storage\n         *\n         * @return {*}\n         */\n        getSelectedShippingRate: function () {\n            return getData().selectedShippingRate;\n        },\n\n        /**\n         * Setting the selected payment method pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedPaymentMethod: function (data) {\n            var obj = getData();\n\n            obj.selectedPaymentMethod = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the payment method from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedPaymentMethod: function () {\n            return getData().selectedPaymentMethod;\n        },\n\n        /**\n         * Setting the selected billing address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedBillingAddress: function (data) {\n            var obj = getData();\n\n            obj.selectedBillingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected billing address from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedBillingAddress: function () {\n            return getData().selectedBillingAddress;\n        },\n\n        /**\n         * Setting the billing address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setBillingAddressFromData: function (data) {\n            var obj = getData();\n\n            obj.billingAddressFromData = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the billing address from persistence storage\n         *\n         * @return {*}\n         */\n        getBillingAddressFromData: function () {\n            return getData().billingAddressFromData;\n        },\n\n        /**\n         * Setting the billing address pulled from persistence storage for new customer\n         *\n         * @param {Object} data\n         */\n        setNewCustomerBillingAddress: function (data) {\n            var obj = getData();\n\n            obj.newCustomerBillingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the billing address from persistence storage for new customer\n         *\n         * @return {*}\n         */\n        getNewCustomerBillingAddress: function () {\n            return getData().newCustomerBillingAddress;\n        },\n\n        /**\n         * Pulling the email address from persistence storage\n         *\n         * @return {*}\n         */\n        getValidatedEmailValue: function () {\n            var obj = getData();\n\n            return obj.validatedEmailValue ? obj.validatedEmailValue : '';\n        },\n\n        /**\n         * Setting the email address pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setValidatedEmailValue: function (email) {\n            var obj = getData();\n\n            obj.validatedEmailValue = email;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the email input field value from persistence storage\n         *\n         * @return {*}\n         */\n        getInputFieldEmailValue: function () {\n            var obj = getData();\n\n            return obj.inputFieldEmailValue ? obj.inputFieldEmailValue : '';\n        },\n\n        /**\n         * Setting the email input field value pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setInputFieldEmailValue: function (email) {\n            var obj = getData();\n\n            obj.inputFieldEmailValue = email;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the checked email value from persistence storage\n         *\n         * @return {*}\n         */\n        getCheckedEmailValue: function () {\n            var obj = getData();\n\n            return obj.checkedEmailValue ? obj.checkedEmailValue : '';\n        },\n\n        /**\n         * Setting the checked email value pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setCheckedEmailValue: function (email) {\n            var obj = getData();\n\n            obj.checkedEmailValue = email;\n            saveData(obj);\n        }\n    };\n});\n","Magento_Checkout/js/proceed-to-checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/authentication-popup',\n    'Magento_Customer/js/customer-data'\n], function ($, authenticationPopup, customerData) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).click(function (event) {\n            var cart = customerData.get('cart'),\n                customer = customerData.get('customer');\n\n            event.preventDefault();\n\n            if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {\n                authenticationPopup.showModal();\n\n                return false;\n            }\n            location.href = config.checkoutUrl;\n        });\n\n    };\n});\n","Magento_Checkout/js/model/quote.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore'\n], function (ko, _) {\n    'use strict';\n\n    /**\n     * Get totals data from the extension attributes.\n     * @param {*} data\n     * @returns {*}\n     */\n    var proceedTotalsData = function (data) {\n            if (_.isObject(data) && _.isObject(data['extension_attributes'])) {\n                _.each(data['extension_attributes'], function (element, index) {\n                    data[index] = element;\n                });\n            }\n\n            return data;\n        },\n        billingAddress = ko.observable(null),\n        shippingAddress = ko.observable(null),\n        shippingMethod = ko.observable(null),\n        paymentMethod = ko.observable(null),\n        quoteData = window.checkoutConfig.quoteData,\n        basePriceFormat = window.checkoutConfig.basePriceFormat,\n        priceFormat = window.checkoutConfig.priceFormat,\n        storeCode = window.checkoutConfig.storeCode,\n        totalsData = proceedTotalsData(window.checkoutConfig.totalsData),\n        totals = ko.observable(totalsData),\n        collectedTotals = ko.observable({});\n\n    return {\n        totals: totals,\n        shippingAddress: shippingAddress,\n        shippingMethod: shippingMethod,\n        billingAddress: billingAddress,\n        paymentMethod: paymentMethod,\n        guestEmail: null,\n\n        /**\n         * @return {*}\n         */\n        getQuoteId: function () {\n            return quoteData['entity_id'];\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isVirtual: function () {\n            return !!Number(quoteData['is_virtual']);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPriceFormat: function () {\n            return priceFormat;\n        },\n\n        /**\n         * @return {*}\n         */\n        getBasePriceFormat: function () {\n            return basePriceFormat;\n        },\n\n        /**\n         * @return {*}\n         */\n        getItems: function () {\n            return window.checkoutConfig.quoteItemData;\n        },\n\n        /**\n         *\n         * @return {*}\n         */\n        getTotals: function () {\n            return totals;\n        },\n\n        /**\n         * @param {Object} data\n         */\n        setTotals: function (data) {\n            data = proceedTotalsData(data);\n            totals(data);\n            this.setCollectedTotals('subtotal_with_discount', parseFloat(data['subtotal_with_discount']));\n        },\n\n        /**\n         * @param {*} paymentMethodCode\n         */\n        setPaymentMethod: function (paymentMethodCode) {\n            paymentMethod(paymentMethodCode);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPaymentMethod: function () {\n            return paymentMethod;\n        },\n\n        /**\n         * @return {*}\n         */\n        getStoreCode: function () {\n            return storeCode;\n        },\n\n        /**\n         * @param {String} code\n         * @param {*} value\n         */\n        setCollectedTotals: function (code, value) {\n            var colTotals = collectedTotals();\n\n            colTotals[code] = value;\n            collectedTotals(colTotals);\n        },\n\n        /**\n         * @return {Number}\n         */\n        getCalculatedTotal: function () {\n            var total = 0.; //eslint-disable-line no-floating-decimal\n\n            _.each(collectedTotals(), function (value) {\n                total += value;\n            });\n\n            return total;\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko',\n    './shipping-rates-validation-rules',\n    '../model/address-converter',\n    '../action/select-shipping-address',\n    './postcode-validator',\n    './default-validator',\n    'mage/translate',\n    'uiRegistry',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/model/quote'\n], function (\n    $,\n    ko,\n    shippingRatesValidationRules,\n    addressConverter,\n    selectShippingAddress,\n    postcodeValidator,\n    defaultValidator,\n    $t,\n    uiRegistry,\n    formPopUpState\n) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig,\n        validators = [],\n        observedElements = [],\n        postcodeElement = null,\n        postcodeElementName = 'postcode';\n\n    validators.push(defaultValidator);\n\n    return {\n        validateAddressTimeout: 0,\n        validateDelay: 2000,\n\n        /**\n         * @param {String} carrier\n         * @param {Object} validator\n         */\n        registerValidator: function (carrier, validator) {\n            if (checkoutConfig.activeCarriers.indexOf(carrier) !== -1) {\n                validators.push(validator);\n            }\n        },\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validateAddressData: function (address) {\n            return validators.some(function (validator) {\n                return validator.validate(address);\n            });\n        },\n\n        /**\n         * Perform postponed binding for fieldset elements\n         *\n         * @param {String} formPath\n         */\n        initFields: function (formPath) {\n            var self = this,\n                elements = shippingRatesValidationRules.getObservableFields();\n\n            if ($.inArray(postcodeElementName, elements) === -1) {\n                // Add postcode field to observables if not exist for zip code validation support\n                elements.push(postcodeElementName);\n            }\n\n            $.each(elements, function (index, field) {\n                uiRegistry.async(formPath + '.' + field)(self.doElementBinding.bind(self));\n            });\n        },\n\n        /**\n         * Bind shipping rates request to form element\n         *\n         * @param {Object} element\n         * @param {Boolean} force\n         * @param {Number} delay\n         */\n        doElementBinding: function (element, force, delay) {\n            var observableFields = shippingRatesValidationRules.getObservableFields();\n\n            if (element && (observableFields.indexOf(element.index) !== -1 || force)) {\n                if (element.index !== postcodeElementName) {\n                    this.bindHandler(element, delay);\n                }\n            }\n\n            if (element.index === postcodeElementName) {\n                this.bindHandler(element, delay);\n                postcodeElement = element;\n            }\n        },\n\n        /**\n         * @param {*} elements\n         * @param {Boolean} force\n         * @param {Number} delay\n         */\n        bindChangeHandlers: function (elements, force, delay) {\n            var self = this;\n\n            $.each(elements, function (index, elem) {\n                self.doElementBinding(elem, force, delay);\n            });\n        },\n\n        /**\n         * @param {Object} element\n         * @param {Number} delay\n         */\n        bindHandler: function (element, delay) {\n            var self = this;\n\n            delay = typeof delay === 'undefined' ? self.validateDelay : delay;\n\n            if (element.component.indexOf('/group') !== -1) {\n                $.each(element.elems(), function (index, elem) {\n                    self.bindHandler(elem);\n                });\n            } else {\n                element.on('value', function () {\n                    if (!formPopUpState.isVisible()) {\n                        clearTimeout(self.validateAddressTimeout);\n                        self.validateAddressTimeout = setTimeout(function () {\n                            self.postcodeValidation();\n                            self.validateFields();\n                        }, delay);\n                    }\n                });\n                observedElements.push(element);\n            }\n        },\n\n        /**\n         * @return {*}\n         */\n        postcodeValidation: function () {\n            var countryId = $('select[name=\"country_id\"]').val(),\n                validationResult,\n                warnMessage;\n\n            if (postcodeElement == null || postcodeElement.value() == null) {\n                return true;\n            }\n\n            postcodeElement.warn(null);\n            validationResult = postcodeValidator.validate(postcodeElement.value(), countryId);\n\n            if (!validationResult) {\n                warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                if (postcodeValidator.validatedPostCodeExample.length) {\n                    warnMessage += $t(' Example: ') + postcodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                }\n                warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n                postcodeElement.warn(warnMessage);\n            }\n\n            return validationResult;\n        },\n\n        /**\n         * Convert form data to quote address and validate fields for shipping rates\n         */\n        validateFields: function () {\n            var addressFlat = addressConverter.formDataProviderToFlatData(\n                    this.collectObservedData(),\n                    'shippingAddress'\n                ),\n                address;\n\n            if (this.validateAddressData(addressFlat)) {\n                addressFlat = uiRegistry.get('checkoutProvider').shippingAddress;\n                address = addressConverter.formAddressDataToQuoteAddress(addressFlat);\n                selectShippingAddress(address);\n            }\n        },\n\n        /**\n         * Collect observed fields data to object\n         *\n         * @returns {*}\n         */\n        collectObservedData: function () {\n            var observedValues = {};\n\n            $.each(observedElements, function (index, field) {\n                observedValues[field.dataScope] = field.value();\n            });\n\n            return observedValues;\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-registry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var cache = [];\n\n    return {\n        /**\n         * @param {String} addressKey\n         * @return {*}\n         */\n        get: function (addressKey) {\n            if (cache[addressKey]) {\n                return cache[addressKey];\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {String} addressKey\n         * @param {*} data\n         */\n        set: function (addressKey, data) {\n            cache[addressKey] = data;\n        }\n    };\n});\n","Magento_Checkout/js/model/address-converter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/new-customer-address',\n    'Magento_Customer/js/customer-data',\n    'mage/utils/objects'\n], function ($, address, customerData, mageUtils) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return {\n        /**\n         * Convert address form data to Address object\n         * @param {Object} formData\n         * @returns {Object}\n         */\n        formAddressDataToQuoteAddress: function (formData) {\n            // clone address form data to new object\n            var addressData = $.extend(true, {}, formData),\n                region,\n                regionName = addressData.region;\n\n            if (mageUtils.isObject(addressData.street)) {\n                addressData.street = this.objectToArray(addressData.street);\n            }\n\n            addressData.region = {\n                'region_id': addressData['region_id'],\n                'region_code': addressData['region_code'],\n                region: regionName\n            };\n\n            if (addressData['region_id'] &&\n                countryData()[addressData['country_id']] &&\n                countryData()[addressData['country_id']].regions\n            ) {\n                region = countryData()[addressData['country_id']].regions[addressData['region_id']];\n\n                if (region) {\n                    addressData.region['region_id'] = addressData['region_id'];\n                    addressData.region['region_code'] = region.code;\n                    addressData.region.region = region.name;\n                }\n            } else if (\n                !addressData['region_id'] &&\n                countryData()[addressData['country_id']] &&\n                countryData()[addressData['country_id']].regions\n            ) {\n                addressData.region['region_code'] = '';\n                addressData.region.region = '';\n            }\n            delete addressData['region_id'];\n\n            return address(addressData);\n        },\n\n        /**\n         * Convert Address object to address form data.\n         *\n         * @param {Object} addrs\n         * @returns {Object}\n         */\n        quoteAddressToFormAddressData: function (addrs) {\n            var self = this,\n                output = {},\n                streetObject;\n\n            if ($.isArray(addrs.street)) {\n                streetObject = {};\n                addrs.street.forEach(function (value, index) {\n                    streetObject[index] = value;\n                });\n                addrs.street = streetObject;\n            }\n\n            $.each(addrs, function (key) {\n                if (addrs.hasOwnProperty(key) && !$.isFunction(addrs[key])) {\n                    output[self.toUnderscore(key)] = addrs[key];\n                }\n            });\n\n            return output;\n        },\n\n        /**\n         * @param {String} string\n         */\n        toUnderscore: function (string) {\n            return string.replace(/([A-Z])/g, function ($1) {\n                return '_' + $1.toLowerCase();\n            });\n        },\n\n        /**\n         * @param {Object} formProviderData\n         * @param {String} formIndex\n         * @return {Object}\n         */\n        formDataProviderToFlatData: function (formProviderData, formIndex) {\n            var addressData = {};\n\n            $.each(formProviderData, function (path, value) {\n                var pathComponents = path.split('.'),\n                    dataObject = {};\n\n                pathComponents.splice(pathComponents.indexOf(formIndex), 1);\n                pathComponents.reverse();\n                $.each(pathComponents, function (index, pathPart) {\n                    var parent = {};\n\n                    if (index == 0) { //eslint-disable-line eqeqeq\n                        dataObject[pathPart] = value;\n                    } else {\n                        parent[pathPart] = dataObject;\n                        dataObject = parent;\n                    }\n                });\n                $.extend(true, addressData, dataObject);\n            });\n\n            return addressData;\n        },\n\n        /**\n         * Convert object to array\n         * @param {Object} object\n         * @returns {Array}\n         */\n        objectToArray: function (object) {\n            var convertedArray = [];\n\n            $.each(object, function (key) {\n                return typeof object[key] === 'string' ? convertedArray.push(object[key]) : false;\n            });\n\n            return convertedArray.slice(0);\n        },\n\n        /**\n         * @param {Object} addrs\n         * @return {*|Object}\n         */\n        addressToEstimationAddress: function (addrs) {\n            var self = this,\n                estimatedAddressData = {};\n\n            $.each(addrs, function (key) {\n                estimatedAddressData[self.toUnderscore(key)] = addrs[key];\n            });\n\n            return this.formAddressDataToQuoteAddress(estimatedAddressData);\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    var ratesRules = {},\n        checkoutConfig = window.checkoutConfig;\n\n    return {\n        /**\n         * @param {String} carrier\n         * @param {Object} rules\n         */\n        registerRules: function (carrier, rules) {\n            if (checkoutConfig.activeCarriers.indexOf(carrier) !== -1) {\n                ratesRules[carrier] = rules.getRules();\n            }\n        },\n\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return ratesRules;\n        },\n\n        /**\n         * @return {Array}\n         */\n        getObservableFields: function () {\n            var self = this,\n                observableFields = [];\n\n            $.each(self.getRules(), function (carrier, fields) {\n                $.each(fields, function (field) {\n                    if (observableFields.indexOf(field) === -1) {\n                        observableFields.push(field);\n                    }\n                });\n            });\n\n            return observableFields;\n        }\n    };\n});\n","Magento_Checkout/js/model/default-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    './default-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Checkout/js/model/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        popUp: false,\n\n        /**\n         * @param {Object} popUp\n         */\n        setPopup: function (popUp) {\n            this.popUp = popUp;\n        },\n\n        /**\n         * Show popup.\n         */\n        show: function () {\n            if (this.popUp) {\n                this.popUp.modal('openModal');\n            }\n        },\n\n        /**\n         * Hide popup.\n         */\n        hide: function () {\n            if (this.popUp) {\n                this.popUp.modal('closeModal');\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/url-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return {\n        method: 'rest',\n        storeCode: window.checkoutConfig.storeCode,\n        version: 'V1',\n        serviceUrl: ':method/:storeCode/:version',\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        createUrl: function (url, params) {\n            var completeUrl = this.serviceUrl + url;\n\n            return this.bindParams(completeUrl, params);\n        },\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        bindParams: function (url, params) {\n            var urlParts;\n\n            params.method = this.method;\n            params.storeCode = this.storeCode;\n            params.version = this.version;\n\n            urlParts = url.split('/');\n            urlParts = urlParts.filter(Boolean);\n\n            $.each(urlParts, function (key, part) {\n                part = part.replace(':', '');\n\n                if (params[part] != undefined) { //eslint-disable-line eqeqeq\n                    urlParts[key] = params[part];\n                }\n            });\n\n            return urlParts.join('/');\n        }\n    };\n});\n","Magento_Checkout/js/model/new-customer-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/default-post-code-resolver'\n], function (_, DefaultPostCodeResolver) {\n    'use strict';\n\n    /**\n     * @param {Object} addressData\n     * Returns new address object\n     */\n    return function (addressData) {\n        var identifier = Date.now(),\n            regionId;\n\n        if (addressData.region && addressData.region['region_id']) {\n            regionId = addressData.region['region_id'];\n        } else if (addressData['country_id'] && addressData['country_id'] == window.checkoutConfig.defaultCountryId) { //eslint-disable-line\n            regionId = window.checkoutConfig.defaultRegionId || undefined;\n        }\n\n        return {\n            email: addressData.email,\n            countryId: addressData['country_id'] || addressData.countryId || window.checkoutConfig.defaultCountryId,\n            regionId: regionId || addressData.regionId,\n            regionCode: addressData.region ? addressData.region['region_code'] : null,\n            region: addressData.region ? addressData.region.region : null,\n            customerId: addressData['customer_id'] || addressData.customerId,\n            street: addressData.street ? _.compact(addressData.street) : addressData.street,\n            company: addressData.company,\n            telephone: addressData.telephone,\n            fax: addressData.fax,\n            postcode: addressData.postcode ? addressData.postcode : DefaultPostCodeResolver.resolve(),\n            city: addressData.city,\n            firstname: addressData.firstname,\n            lastname: addressData.lastname,\n            middlename: addressData.middlename,\n            prefix: addressData.prefix,\n            suffix: addressData.suffix,\n            vatId: addressData['vat_id'],\n            saveInAddressBook: addressData['save_in_address_book'],\n            customAttributes: addressData['custom_attributes'],\n\n            /**\n             * @return {*}\n             */\n            isDefaultShipping: function () {\n                return addressData['default_shipping'];\n            },\n\n            /**\n             * @return {*}\n             */\n            isDefaultBilling: function () {\n                return addressData['default_billing'];\n            },\n\n            /**\n             * @return {String}\n             */\n            getType: function () {\n                return 'new-customer-address';\n            },\n\n            /**\n             * @return {String}\n             */\n            getKey: function () {\n                return this.getType();\n            },\n\n            /**\n             * @return {String}\n             */\n            getCacheKey: function () {\n                return this.getType() + identifier;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            isEditable: function () {\n                return true;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            canUseForBilling: function () {\n                return true;\n            }\n        };\n    };\n});\n","Magento_Checkout/js/model/step-navigator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko'\n], function ($, ko) {\n    'use strict';\n\n    var steps = ko.observableArray();\n\n    return {\n        steps: steps,\n        stepCodes: [],\n        validCodes: [],\n\n        /**\n         * @return {Boolean}\n         */\n        handleHash: function () {\n            var hashString = window.location.hash.replace('#', ''),\n                isRequestedStepVisible;\n\n            if (hashString === '') {\n                return false;\n            }\n\n            if ($.inArray(hashString, this.validCodes) === -1) {\n                window.location.href = window.checkoutConfig.pageNotFoundUrl;\n\n                return false;\n            }\n\n            isRequestedStepVisible = steps.sort(this.sortItems).some(function (element) {\n                return (element.code == hashString || element.alias == hashString) && element.isVisible(); //eslint-disable-line\n            });\n\n            //if requested step is visible, then we don't need to load step data from server\n            if (isRequestedStepVisible) {\n                return false;\n            }\n\n            steps.sort(this.sortItems).forEach(function (element) {\n                if (element.code == hashString || element.alias == hashString) { //eslint-disable-line eqeqeq\n                    element.navigate(element);\n                } else {\n                    element.isVisible(false);\n                }\n\n            });\n\n            return false;\n        },\n\n        /**\n         * @param {String} code\n         * @param {*} alias\n         * @param {*} title\n         * @param {Function} isVisible\n         * @param {*} navigate\n         * @param {*} sortOrder\n         */\n        registerStep: function (code, alias, title, isVisible, navigate, sortOrder) {\n            var hash;\n\n            if ($.inArray(code, this.validCodes) !== -1) {\n                throw new DOMException('Step code [' + code + '] already registered in step navigator');\n            }\n\n            if (alias != null) {\n                if ($.inArray(alias, this.validCodes) !== -1) {\n                    throw new DOMException('Step code [' + alias + '] already registered in step navigator');\n                }\n                this.validCodes.push(alias);\n            }\n            this.validCodes.push(code);\n            steps.push({\n                code: code,\n                alias: alias != null ? alias : code,\n                title: title,\n                isVisible: isVisible,\n                navigate: navigate,\n                sortOrder: sortOrder\n            });\n            this.stepCodes.push(code);\n            hash = window.location.hash.replace('#', '');\n\n            if (hash != '' && hash != code) { //eslint-disable-line eqeqeq\n                //Force hiding of not active step\n                isVisible(false);\n            }\n        },\n\n        /**\n         * @param {Object} itemOne\n         * @param {Object} itemTwo\n         * @return {Number}\n         */\n        sortItems: function (itemOne, itemTwo) {\n            return itemOne.sortOrder > itemTwo.sortOrder ? 1 : -1;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getActiveItemIndex: function () {\n            var activeIndex = 0;\n\n            steps.sort(this.sortItems).forEach(function (element, index) {\n                if (element.isVisible()) {\n                    activeIndex = index;\n                }\n            });\n\n            return activeIndex;\n        },\n\n        /**\n         * @param {*} code\n         * @return {Boolean}\n         */\n        isProcessed: function (code) {\n            var activeItemIndex = this.getActiveItemIndex(),\n                sortedItems = steps.sort(this.sortItems),\n                requestedItemIndex = -1;\n\n            sortedItems.forEach(function (element, index) {\n                if (element.code == code) { //eslint-disable-line eqeqeq\n                    requestedItemIndex = index;\n                }\n            });\n\n            return activeItemIndex > requestedItemIndex;\n        },\n\n        /**\n         * @param {*} code\n         * @param {*} scrollToElementId\n         */\n        navigateTo: function (code, scrollToElementId) {\n            var sortedItems = steps.sort(this.sortItems),\n                bodyElem = $.browser.safari || $.browser.chrome ? $('body') : $('html');\n\n            scrollToElementId = scrollToElementId || null;\n\n            if (!this.isProcessed(code)) {\n                return;\n            }\n            sortedItems.forEach(function (element) {\n                if (element.code == code) { //eslint-disable-line eqeqeq\n                    element.isVisible(true);\n                    bodyElem.animate({\n                        scrollTop: $('#' + code).offset().top\n                    }, 0, function () {\n                        window.location = window.checkoutConfig.checkoutUrl + '#' + code;\n                    });\n\n                    if (scrollToElementId && $('#' + scrollToElementId).length) {\n                        bodyElem.animate({\n                            scrollTop: $('#' + scrollToElementId).offset().top\n                        }, 0);\n                    }\n                } else {\n                    element.isVisible(false);\n                }\n\n            });\n        },\n\n        /**\n         * Next step.\n         */\n        next: function () {\n            var activeIndex = 0,\n                code;\n\n            steps.sort(this.sortItems).forEach(function (element, index) {\n                if (element.isVisible()) {\n                    element.isVisible(false);\n                    activeIndex = index;\n                }\n            });\n\n            if (steps().length > activeIndex + 1) {\n                code = steps()[activeIndex + 1].code;\n                steps()[activeIndex + 1].isVisible(true);\n                window.location = window.checkoutConfig.checkoutUrl + '#' + code;\n                document.body.scrollTop = document.documentElement.scrollTop = 0;\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/checkout-data-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Checkout adapter for customer data storage\n */\ndefine([\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/action/create-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/action/select-payment-method',\n    'Magento_Checkout/js/model/address-converter',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/action/create-billing-address',\n    'underscore'\n], function (\n    addressList,\n    quote,\n    checkoutData,\n    createShippingAddress,\n    selectShippingAddress,\n    selectShippingMethodAction,\n    paymentService,\n    selectPaymentMethodAction,\n    addressConverter,\n    selectBillingAddress,\n    createBillingAddress,\n    _\n) {\n    'use strict';\n\n    return {\n\n        /**\n         * Resolve estimation address. Used local storage\n         */\n        resolveEstimationAddress: function () {\n            var address;\n\n            if (checkoutData.getShippingAddressFromData()) {\n                address = addressConverter.formAddressDataToQuoteAddress(checkoutData.getShippingAddressFromData());\n                selectShippingAddress(address);\n            } else {\n                this.resolveShippingAddress();\n            }\n\n            if (quote.isVirtual()) {\n                if (checkoutData.getBillingAddressFromData()) {\n                    address = addressConverter.formAddressDataToQuoteAddress(\n                        checkoutData.getBillingAddressFromData()\n                    );\n                    selectBillingAddress(address);\n                } else {\n                    this.resolveBillingAddress();\n                }\n            }\n\n        },\n\n        /**\n         * Resolve shipping address. Used local storage\n         */\n        resolveShippingAddress: function () {\n            var newCustomerShippingAddress = checkoutData.getNewCustomerShippingAddress();\n\n            if (newCustomerShippingAddress) {\n                createShippingAddress(newCustomerShippingAddress);\n            }\n            this.applyShippingAddress();\n        },\n\n        /**\n         * Apply resolved estimated address to quote\n         *\n         * @param {Object} isEstimatedAddress\n         */\n        applyShippingAddress: function (isEstimatedAddress) {\n            var address,\n                shippingAddress,\n                isConvertAddress,\n                addressData,\n                isShippingAddressInitialized;\n\n            if (addressList().length === 0) {\n                address = addressConverter.formAddressDataToQuoteAddress(\n                    checkoutData.getShippingAddressFromData()\n                );\n                selectShippingAddress(address);\n            }\n            shippingAddress = quote.shippingAddress();\n            isConvertAddress = isEstimatedAddress || false;\n\n            if (!shippingAddress) {\n                isShippingAddressInitialized = addressList.some(function (addressFromList) {\n                    if (checkoutData.getSelectedShippingAddress() == addressFromList.getKey()) { //eslint-disable-line\n                        addressData = isConvertAddress ?\n                            addressConverter.addressToEstimationAddress(addressFromList)\n                            : addressFromList;\n                        selectShippingAddress(addressData);\n\n                        return true;\n                    }\n\n                    return false;\n                });\n\n                if (!isShippingAddressInitialized) {\n                    isShippingAddressInitialized = addressList.some(function (addrs) {\n                        if (addrs.isDefaultShipping()) {\n                            addressData = isConvertAddress ?\n                                addressConverter.addressToEstimationAddress(addrs)\n                                : addrs;\n                            selectShippingAddress(addressData);\n\n                            return true;\n                        }\n\n                        return false;\n                    });\n                }\n\n                if (!isShippingAddressInitialized && addressList().length === 1) {\n                    addressData = isConvertAddress ?\n                        addressConverter.addressToEstimationAddress(addressList()[0])\n                        : addressList()[0];\n                    selectShippingAddress(addressData);\n                }\n            }\n        },\n\n        /**\n         * @param {Object} ratesData\n         */\n        resolveShippingRates: function (ratesData) {\n            var selectedShippingRate = checkoutData.getSelectedShippingRate(),\n                availableRate = false;\n\n            if (ratesData.length === 1) {\n                //set shipping rate if we have only one available shipping rate\n                selectShippingMethodAction(ratesData[0]);\n\n                return;\n            }\n\n            if (quote.shippingMethod()) {\n                availableRate = _.find(ratesData, function (rate) {\n                    return rate['carrier_code'] == quote.shippingMethod()['carrier_code'] && //eslint-disable-line\n                        rate['method_code'] == quote.shippingMethod()['method_code']; //eslint-disable-line eqeqeq\n                });\n            }\n\n            if (!availableRate && selectedShippingRate) {\n                availableRate = _.find(ratesData, function (rate) {\n                    return rate['carrier_code'] + '_' + rate['method_code'] === selectedShippingRate;\n                });\n            }\n\n            if (!availableRate && window.checkoutConfig.selectedShippingMethod) {\n                availableRate = window.checkoutConfig.selectedShippingMethod;\n                selectShippingMethodAction(window.checkoutConfig.selectedShippingMethod);\n\n                return;\n            }\n\n            //Unset selected shipping method if not available\n            if (!availableRate) {\n                selectShippingMethodAction(null);\n            } else {\n                selectShippingMethodAction(availableRate);\n            }\n        },\n\n        /**\n         * Resolve payment method. Used local storage\n         */\n        resolvePaymentMethod: function () {\n            var availablePaymentMethods = paymentService.getAvailablePaymentMethods(),\n                selectedPaymentMethod = checkoutData.getSelectedPaymentMethod();\n\n            if (selectedPaymentMethod) {\n                availablePaymentMethods.some(function (payment) {\n                    if (payment.method == selectedPaymentMethod) { //eslint-disable-line eqeqeq\n                        selectPaymentMethodAction(payment);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Resolve billing address. Used local storage\n         */\n        resolveBillingAddress: function () {\n            var selectedBillingAddress = checkoutData.getSelectedBillingAddress(),\n                newCustomerBillingAddressData = checkoutData.getNewCustomerBillingAddress();\n\n            if (selectedBillingAddress) {\n                if (selectedBillingAddress == 'new-customer-address' && newCustomerBillingAddressData) { //eslint-disable-line\n                    selectBillingAddress(createBillingAddress(newCustomerBillingAddressData));\n                } else {\n                    addressList.some(function (address) {\n                        if (selectedBillingAddress == address.getKey()) { //eslint-disable-line eqeqeq\n                            selectBillingAddress(address);\n                        }\n                    });\n                }\n            } else {\n                this.applyBillingAddress();\n            }\n        },\n\n        /**\n         * Apply resolved billing address to quote\n         */\n        applyBillingAddress: function () {\n            var shippingAddress;\n\n            if (quote.billingAddress()) {\n                selectBillingAddress(quote.billingAddress());\n\n                return;\n            }\n            shippingAddress = quote.shippingAddress();\n\n            if (shippingAddress &&\n                shippingAddress.canUseForBilling() &&\n                (shippingAddress.isDefaultShipping() || !quote.isVirtual())\n            ) {\n                //set billing address same as shipping by default if it is not empty\n                selectBillingAddress(quote.shippingAddress());\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/shipping-save-processor/default'\n], function (defaultProcessor) {\n    'use strict';\n\n    var processors = [];\n\n    processors['default'] =  defaultProcessor;\n\n    return {\n        /**\n         * @param {String} type\n         * @param {*} processor\n         */\n        registerProcessor: function (type, processor) {\n            processors[type] = processor;\n        },\n\n        /**\n         * @param {String} type\n         * @return {Array}\n         */\n        saveShippingInformation: function (type) {\n            var rates = [];\n\n            if (processors[type]) {\n                rates = processors[type].saveShippingInformation();\n            } else {\n                rates = processors['default'].saveShippingInformation();\n            }\n\n            return rates;\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/checkout-data-resolver'\n], function (ko, checkoutDataResolver) {\n    'use strict';\n\n    var shippingRates = ko.observableArray([]);\n\n    return {\n        isLoading: ko.observable(false),\n\n        /**\n         * Set shipping rates\n         *\n         * @param {*} ratesData\n         */\n        setShippingRates: function (ratesData) {\n            shippingRates(ratesData);\n            shippingRates.valueHasMutated();\n            checkoutDataResolver.resolveShippingRates(ratesData);\n        },\n\n        /**\n         * Get shipping rates\n         *\n         * @returns {*}\n         */\n        getShippingRates: function () {\n            return shippingRates;\n        }\n    };\n});\n","Magento_Checkout/js/model/default-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Checkout/js/model/place-order.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine(\n    [\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (storage, errorProcessor, fullScreenLoader) {\n        'use strict';\n\n        return function (serviceUrl, payload, messageContainer) {\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload)\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                }\n            ).always(\n                function () {\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/model/error-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mage/url',\n    'Magento_Ui/js/model/messageList'\n], function (url, globalMessageList) {\n    'use strict';\n\n    return {\n        /**\n         * @param {Object} response\n         * @param {Object} messageContainer\n         */\n        process: function (response, messageContainer) {\n            var error;\n\n            messageContainer = messageContainer || globalMessageList;\n\n            if (response.status == 401) { //eslint-disable-line eqeqeq\n                window.location.replace(url.build('customer/account/login/'));\n            } else {\n                error = JSON.parse(response.responseText);\n                messageContainer.addErrorMessage(error);\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/postcode-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'mageUtils'\n], function (utils) {\n    'use strict';\n\n    return {\n        validatedPostCodeExample: [],\n\n        /**\n         * @param {*} postCode\n         * @param {*} countryId\n         * @return {Boolean}\n         */\n        validate: function (postCode, countryId) {\n            var patterns = window.checkoutConfig.postCodes[countryId],\n                pattern, regex;\n\n            this.validatedPostCodeExample = [];\n\n            if (!utils.isEmpty(postCode) && !utils.isEmpty(patterns)) {\n                for (pattern in patterns) {\n                    if (patterns.hasOwnProperty(pattern)) { //eslint-disable-line max-depth\n                        this.validatedPostCodeExample.push(patterns[pattern].example);\n                        regex = new RegExp(patterns[pattern].pattern);\n\n                        if (regex.test(postCode)) { //eslint-disable-line max-depth\n                            return true;\n                        }\n                    }\n                }\n\n                return false;\n            }\n\n            return true;\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n    'Magento_Checkout/js/model/shipping-rate-processor/customer-address'\n], function (quote, defaultProcessor, customerAddressProcessor) {\n    'use strict';\n\n    var processors = [];\n\n    processors.default =  defaultProcessor;\n    processors['customer-address'] = customerAddressProcessor;\n\n    quote.shippingAddress.subscribe(function () {\n        var type = quote.shippingAddress().getType();\n\n        if (processors[type]) {\n            processors[type].getRates(quote.shippingAddress());\n        } else {\n            processors.default.getRates(quote.shippingAddress());\n        }\n    });\n\n    return {\n        /**\n         * @param {String} type\n         * @param {*} processor\n         */\n        registerProcessor: function (type, processor) {\n            processors[type] = processor;\n        }\n    };\n});\n","Magento_Checkout/js/model/full-screen-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'rjsResolver'\n], function ($, resolver) {\n    'use strict';\n\n    var containerId = '#checkout';\n\n    return {\n\n        /**\n         * Start full page loader action\n         */\n        startLoader: function () {\n            $(containerId).trigger('processStart');\n        },\n\n        /**\n         * Stop full page loader action\n         *\n         * @param {Boolean} [forceStop]\n         */\n        stopLoader: function (forceStop) {\n            var $elem = $(containerId),\n                stop = $elem.trigger.bind($elem, 'processStop');\n\n            forceStop ? stop() : resolver(stop);\n        }\n    };\n});\n","Magento_Checkout/js/model/payment-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/payment/method-list',\n    'Magento_Checkout/js/action/select-payment-method'\n], function (_, quote, methodList, selectPaymentMethod) {\n    'use strict';\n\n    /**\n    * Free method filter\n    * @param {Object} paymentMethod\n    * @return {Boolean}\n    */\n    var isFreePaymentMethod = function (paymentMethod) {\n            return paymentMethod.method === 'free';\n        },\n\n        /**\n         * Grabs the grand total from quote\n         * @return {Number}\n         */\n        getGrandTotal = function () {\n            return quote.totals()['grand_total'];\n        };\n\n    return {\n        isFreeAvailable: false,\n\n        /**\n         * Populate the list of payment methods\n         * @param {Array} methods\n         */\n        setPaymentMethods: function (methods) {\n            var freeMethod,\n                filteredMethods,\n                methodIsAvailable,\n                methodNames;\n\n            freeMethod = _.find(methods, isFreePaymentMethod);\n            this.isFreeAvailable = !!freeMethod;\n\n            if (freeMethod && getGrandTotal() <= 0) {\n                methods.splice(0, methods.length, freeMethod);\n                selectPaymentMethod(freeMethod);\n            }\n\n            filteredMethods = _.without(methods, freeMethod);\n\n            if (filteredMethods.length === 1) {\n                selectPaymentMethod(filteredMethods[0]);\n            } else if (quote.paymentMethod()) {\n                methodIsAvailable = methods.some(function (item) {\n                    return item.method === quote.paymentMethod().method;\n                });\n                //Unset selected payment method if not available\n                if (!methodIsAvailable) {\n                    selectPaymentMethod(null);\n                }\n            }\n\n            /**\n             * Overwrite methods with existing methods to preserve ko array references.\n             * This prevent ko from re-rendering those methods.\n             */\n            methodNames = _.pluck(methods, 'method');\n            _.map(methodList(), function (existingMethod) {\n                var existingMethodIndex = methodNames.indexOf(existingMethod.method);\n\n                if (existingMethodIndex !== -1) {\n                    methods[existingMethodIndex] = existingMethod;\n                }\n            });\n\n            methodList(methods);\n        },\n\n        /**\n         * Get the list of available payment methods.\n         * @return {Array}\n         */\n        getAvailablePaymentMethods: function () {\n            var allMethods = methodList().slice(),\n                grandTotalOverZero = getGrandTotal() > 0;\n\n            if (!this.isFreeAvailable) {\n                return allMethods;\n            }\n\n            if (grandTotalOverZero) {\n                return _.reject(allMethods, isFreePaymentMethod);\n            }\n\n            return _.filter(allMethods, isFreePaymentMethod);\n        }\n    };\n});\n","Magento_Checkout/js/model/authentication-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Ui/js/model/messages'\n], function (ko, Messages) {\n    'use strict';\n\n    return new Messages();\n});\n","Magento_Checkout/js/model/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/customer-data'\n], function (ko, quote, customerData) {\n    'use strict';\n\n    var quoteItems = ko.observable(quote.totals().items),\n        cartData = customerData.get('cart'),\n        quoteSubtotal = parseFloat(quote.totals().subtotal),\n        subtotalAmount = parseFloat(cartData().subtotalAmount);\n\n    quote.totals.subscribe(function (newValue) {\n        quoteItems(newValue.items);\n    });\n\n    if (quoteSubtotal !== subtotalAmount) {\n        customerData.reload(['cart'], false);\n    }\n\n    return {\n        totals: quote.totals,\n        isLoading: ko.observable(false),\n\n        /**\n         * @return {Function}\n         */\n        getItems: function () {\n            return quoteItems;\n        },\n\n        /**\n         * @param {*} code\n         * @return {*}\n         */\n        getSegment: function (code) {\n            var i, total;\n\n            if (!this.totals()) {\n                return null;\n            }\n\n            for (i in this.totals()['total_segments']) { //eslint-disable-line guard-for-in\n                total = this.totals()['total_segments'][i];\n\n                if (total.code == code) { //eslint-disable-line eqeqeq\n                    return total;\n                }\n            }\n\n            return null;\n        }\n    };\n});\n","Magento_Checkout/js/model/customer-email-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/customer',\n    'mage/validation'\n], function ($, customer) {\n    'use strict';\n\n    return {\n        /**\n         * Validate checkout agreements\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            var emailValidationResult = customer.isLoggedIn(),\n                loginFormSelector = 'form[data-role=email-with-possible-login]';\n\n            if (!customer.isLoggedIn()) {\n                $(loginFormSelector).validation();\n                emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());\n            }\n\n            return emailValidationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/default-post-code-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Define necessity of using default post code value\n     */\n    var useDefaultPostCode;\n\n    return {\n        /**\n         * Resolve default post code\n         *\n         * @returns {String|null}\n         */\n        resolve: function () {\n            return useDefaultPostCode ?  window.checkoutConfig.defaultPostcode : null;\n        },\n\n        /**\n         * Set state to useDefaultPostCode variable\n         *\n         * @param {Boolean} shouldUseDefaultPostCode\n         * @returns {underscore}\n         */\n        setUseDefaultPostCode: function (shouldUseDefaultPostCode) {\n            useDefaultPostCode = shouldUseDefaultPostCode;\n\n            return this;\n        }\n    };\n});\n","Magento_Checkout/js/model/resource-url-manager.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/url-builder',\n    'mageUtils'\n], function (customer, urlBuilder, utils) {\n        'use strict';\n\n        return {\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForTotalsEstimationForNewAddress: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            cartId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:cartId/totals-information',\n                        'customer': '/carts/mine/totals-information'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForEstimationShippingMethodsForNewAddress: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:quoteId/estimate-shipping-methods',\n                        'customer': '/carts/mine/estimate-shipping-methods'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForEstimationShippingMethodsByAddressId: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'default': '/carts/mine/estimate-shipping-methods-by-address-id'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {String} couponCode\n             * @param {String} quoteId\n             * @return {*}\n             */\n            getApplyCouponUrl: function (couponCode, quoteId) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quoteId\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/' + quoteId + '/coupons/' + encodeURIComponent(couponCode),\n                        'customer': '/carts/mine/coupons/' + encodeURIComponent(couponCode)\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {String} quoteId\n             * @return {*}\n             */\n            getCancelCouponUrl: function (quoteId) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quoteId\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/' + quoteId + '/coupons/',\n                        'customer': '/carts/mine/coupons/'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForCartTotals: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:quoteId/totals',\n                        'customer': '/carts/mine/totals'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForSetShippingInformation: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            cartId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:cartId/shipping-information',\n                        'customer': '/carts/mine/shipping-information'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * Get url for service.\n             *\n             * @param {*} urls\n             * @param {*} urlParams\n             * @return {String|*}\n             */\n            getUrl: function (urls, urlParams) {\n                var url;\n\n                if (utils.isEmpty(urls)) {\n                    return 'Provided service call does not exist.';\n                }\n\n                if (!utils.isEmpty(urls['default'])) {\n                    url = urls['default'];\n                } else {\n                    url = urls[this.getCheckoutMethod()];\n                }\n\n                return urlBuilder.createUrl(url, urlParams);\n            },\n\n            /**\n             * @return {String}\n             */\n            getCheckoutMethod: function () {\n                return customer.isLoggedIn() ? 'customer' : 'guest';\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/shipping-address/form-popup-state.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return {\n        isVisible: ko.observable(false)\n    };\n});\n","Magento_Checkout/js/model/cart/cache.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Cart adapter for customer data storage.\n * It stores cart data in customer data(localStorage) without saving on server.\n * Adapter is created for shipping rates and totals data caching. It eliminates unneeded calculations requests.\n */\ndefine([\n    'underscore',\n    'Magento_Customer/js/customer-data',\n    'mageUtils'\n], function (_, storage, utils) {\n    'use strict';\n\n    var cacheKey = 'cart-data',\n        cartData = {\n            totals: null,\n            address: null,\n            cartVersion: null,\n            shippingMethodCode: null,\n            shippingCarrierCode: null,\n            rates: null\n        },\n\n        /**\n         * Set data to local storage.\n         *\n         * @param {Object} checkoutData\n         */\n        setData = function (checkoutData) {\n            storage.set(cacheKey, checkoutData);\n        },\n\n        /**\n         * Get data from local storage.\n         *\n         * @param {String} [key]\n         * @returns {*}\n         */\n        getData = function (key) {\n            var data = key ? storage.get(cacheKey)()[key] : storage.get(cacheKey)();\n\n            if (_.isEmpty(storage.get(cacheKey)())) {\n                setData(utils.copy(cartData));\n            }\n\n            return data;\n        },\n\n        /**\n         * Build method name base on name, prefix and suffix.\n         *\n         * @param {String} name\n         * @param {String} prefix\n         * @param {String} suffix\n         * @return {String}\n         */\n        getMethodName = function (name, prefix, suffix) {\n            prefix = prefix || '';\n            suffix = suffix || '';\n\n            return prefix + name.charAt(0).toUpperCase() + name.slice(1) + suffix;\n        };\n\n    /**\n     * Provides get/set/isChanged/clear methods for work with cart data.\n     * Can be customized via mixin functionality.\n     */\n    return {\n        cartData: cartData,\n\n        /**\n         * Array of required address fields\n         */\n        requiredFields: ['countryId', 'region', 'regionId', 'postcode'],\n\n        /**\n         * Get data from customer data.\n         * Concatenate provided key with method name and call method if it exist or makes get by key.\n         *\n         * @param {String} key\n         * @return {*}\n         */\n        get: function (key) {\n            var methodName = getMethodName(key, '_get');\n\n            if (key === cacheKey) {\n                return getData();\n            }\n\n            if (this[methodName]) {\n                return this[methodName]();\n            }\n\n            return getData(key);\n        },\n\n        /**\n         * Set data to customer data.\n         * Concatenate provided key with method name and call method if it exist or makes set by key.\n         * @example _setCustomAddress method will be called, if it exists.\n         *  set('address', customAddressValue)\n         * @example Will set value by provided key.\n         *  set('rates', ratesToCompare)\n         *\n         * @param {String} key\n         * @param {*} value\n         */\n        set: function (key, value) {\n            var methodName = getMethodName(key, '_set'),\n                obj;\n\n            if (key === cacheKey) {\n                _.each(value, function (val, k) {\n                    this.set(k, val);\n                }, this);\n\n                return;\n            }\n\n            if (this[methodName]) {\n                this[methodName](value);\n            } else {\n                obj = getData();\n                obj[key] = value;\n                setData(obj);\n            }\n        },\n\n        /**\n         * Clear data in cache.\n         * Concatenate provided key with method name and call method if it exist or clear by key.\n         * @example _clearCustomAddress method will be called, if it exist.\n         *  clear('customAddress')\n         * @example Will clear data by provided key.\n         *  clear('rates')\n         *\n         * @param {String} key\n         */\n        clear: function (key) {\n            var methodName = getMethodName(key, '_clear');\n\n            if (key === cacheKey) {\n                setData(this.cartData);\n\n                return;\n            }\n\n            if (this[methodName]) {\n                this[methodName]();\n            } else {\n                this.set(key, null);\n            }\n        },\n\n        /**\n         * Check if provided data has difference with cached data.\n         * Concatenate provided key with method name and call method if it exist or makes strict equality.\n         * @example Will call existing _isAddressChanged.\n         *  isChanged('address', addressToCompare)\n         * @example Will get data by provided key and make strict equality with provided value.\n         *  isChanged('rates', ratesToCompare)\n         *\n         * @param {String} key\n         * @param {*} value\n         * @return {Boolean}\n         */\n        isChanged: function (key, value) {\n            var methodName = getMethodName(key, '_is', 'Changed');\n\n            if (this[methodName]) {\n                return this[methodName](value);\n            }\n\n            return this.get(key) !== value;\n        },\n\n        /**\n         * Compare cached address with provided.\n         * Custom method for check object equality.\n         *\n         * @param {Object} address\n         * @returns {Boolean}\n         */\n        _isAddressChanged: function (address) {\n            return JSON.stringify(_.pick(this.get('address'), this.requiredFields)) !==\n                JSON.stringify(_.pick(address, this.requiredFields));\n        },\n\n        /**\n         * Compare cached subtotal with provided.\n         * Custom method for check object equality.\n         *\n         * @param {float} subtotal\n         * @returns {Boolean}\n         */\n        _isSubtotalChanged: function (subtotal) {\n            var cached = parseFloat(this.get('totals').subtotal);\n\n            return subtotal !== cached;\n        }\n    };\n});\n","Magento_Checkout/js/model/cart/estimate-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n    'Magento_Checkout/js/model/cart/totals-processor/default',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/cart/cache',\n    'Magento_Customer/js/customer-data'\n], function (quote, defaultProcessor, totalsDefaultProvider, shippingService, cartCache, customerData) {\n    'use strict';\n\n    var rateProcessors = [],\n        totalsProcessors = [];\n\n    quote.shippingAddress.subscribe(function () {\n        var type = quote.shippingAddress().getType();\n\n        if (\n            quote.isVirtual() ||\n            window.checkoutConfig.activeCarriers && window.checkoutConfig.activeCarriers.length === 0\n        ) {\n            // update totals block when estimated address was set\n            totalsProcessors['default'] = totalsDefaultProvider;\n            totalsProcessors[type] ?\n                totalsProcessors[type].estimateTotals(quote.shippingAddress()) :\n                totalsProcessors['default'].estimateTotals(quote.shippingAddress());\n        } else {\n            // check if user data not changed -> load rates from cache\n            if (!cartCache.isChanged('address', quote.shippingAddress()) &&\n                !cartCache.isChanged('cartVersion', customerData.get('cart')()['data_id']) &&\n                cartCache.get('rates')\n            ) {\n                shippingService.setShippingRates(cartCache.get('rates'));\n\n                return;\n            }\n\n            // update rates list when estimated address was set\n            rateProcessors['default'] = defaultProcessor;\n            rateProcessors[type] ?\n                rateProcessors[type].getRates(quote.shippingAddress()) :\n                rateProcessors['default'].getRates(quote.shippingAddress());\n\n            // save rates to cache after load\n            shippingService.getShippingRates().subscribe(function (rates) {\n                cartCache.set('rates', rates);\n            });\n        }\n    });\n    quote.shippingMethod.subscribe(function () {\n        totalsDefaultProvider.estimateTotals(quote.shippingAddress());\n    });\n    quote.billingAddress.subscribe(function () {\n        var type = quote.billingAddress().getType();\n\n        if (quote.isVirtual()) {\n            // update totals block when estimated address was set\n            totalsProcessors['default'] = totalsDefaultProvider;\n            totalsProcessors[type] ?\n                totalsProcessors[type].estimateTotals(quote.billingAddress()) :\n                totalsProcessors['default'].estimateTotals(quote.billingAddress());\n        }\n    });\n});\n","Magento_Checkout/js/model/cart/totals-processor/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Checkout/js/model/cart/cache',\n    'Magento_Customer/js/customer-data'\n], function (_, resourceUrlManager, quote, storage, totalsService, errorProcessor, cartCache, customerData) {\n    'use strict';\n\n    /**\n     * Load data from server.\n     *\n     * @param {Object} address\n     */\n    var loadFromServer = function (address) {\n        var serviceUrl,\n            payload;\n\n        // Start loader for totals block\n        totalsService.isLoading(true);\n        serviceUrl = resourceUrlManager.getUrlForTotalsEstimationForNewAddress(quote);\n        payload = {\n            addressInformation: {\n                address: _.pick(address, cartCache.requiredFields)\n            }\n        };\n\n        if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n            payload.addressInformation['shipping_method_code'] = quote.shippingMethod()['method_code'];\n            payload.addressInformation['shipping_carrier_code'] = quote.shippingMethod()['carrier_code'];\n        }\n\n        storage.post(\n            serviceUrl, JSON.stringify(payload), false\n        ).done(function (result) {\n            var data = {\n                totals: result,\n                address: address,\n                cartVersion: customerData.get('cart')()['data_id'],\n                shippingMethodCode: null,\n                shippingCarrierCode: null\n            };\n\n            if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n                data.shippingMethodCode = quote.shippingMethod()['method_code'];\n                data.shippingCarrierCode = quote.shippingMethod()['carrier_code'];\n            }\n\n            quote.setTotals(result);\n            cartCache.set('cart-data', data);\n        }).fail(function (response) {\n            errorProcessor.process(response);\n        }).always(function () {\n            // Stop loader for totals block\n            totalsService.isLoading(false);\n        });\n    };\n\n    return {\n        /**\n         * Array of required address fields.\n         * @property {Array.String} requiredFields\n         * @deprecated Use cart cache.\n         */\n        requiredFields: cartCache.requiredFields,\n\n        /**\n         * Get shipping rates for specified address.\n         * @param {Object} address\n         */\n        estimateTotals: function (address) {\n            var data = {\n                shippingMethodCode: null,\n                shippingCarrierCode: null\n            };\n\n            if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n                data.shippingMethodCode = quote.shippingMethod()['method_code'];\n                data.shippingCarrierCode = quote.shippingMethod()['carrier_code'];\n            }\n\n            if (!cartCache.isChanged('cartVersion', customerData.get('cart')()['data_id']) &&\n                !cartCache.isChanged('shippingMethodCode', data.shippingMethodCode) &&\n                !cartCache.isChanged('shippingCarrierCode', data.shippingCarrierCode) &&\n                !cartCache.isChanged('address', address) &&\n                cartCache.get('totals') &&\n                !cartCache.isChanged('subtotal', parseFloat(quote.totals().subtotal))\n            ) {\n                quote.setTotals(cartCache.get('totals'));\n            } else {\n                loadFromServer(address);\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor/payload-extender.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return function (payload) {\n        payload.addressInformation['extension_attributes'] = {};\n\n        return payload;\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'mage/storage',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/model/shipping-save-processor/payload-extender'\n], function (\n    ko,\n    quote,\n    resourceUrlManager,\n    storage,\n    paymentService,\n    methodConverter,\n    errorProcessor,\n    fullScreenLoader,\n    selectBillingAddressAction,\n    payloadExtender\n) {\n    'use strict';\n\n    return {\n        /**\n         * @return {jQuery.Deferred}\n         */\n        saveShippingInformation: function () {\n            var payload;\n\n            if (!quote.billingAddress()) {\n                selectBillingAddressAction(quote.shippingAddress());\n            }\n\n            payload = {\n                addressInformation: {\n                    'shipping_address': quote.shippingAddress(),\n                    'billing_address': quote.billingAddress(),\n                    'shipping_method_code': quote.shippingMethod()['method_code'],\n                    'shipping_carrier_code': quote.shippingMethod()['carrier_code']\n                }\n            };\n\n            payloadExtender(payload);\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                resourceUrlManager.getUrlForSetShippingInformation(quote),\n                JSON.stringify(payload)\n            ).done(\n                function (response) {\n                    quote.setTotals(response.totals);\n                    paymentService.setPaymentMethods(methodConverter(response['payment_methods']));\n                    fullScreenLoader.stopLoader();\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-processor/new-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor'\n], function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n    'use strict';\n\n    return {\n        /**\n         * Get shipping rates for specified address.\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache, serviceUrl, payload;\n\n            shippingService.isLoading(true);\n            cache = rateRegistry.get(address.getCacheKey());\n            serviceUrl = resourceUrlManager.getUrlForEstimationShippingMethodsForNewAddress(quote);\n            payload = JSON.stringify({\n                    address: {\n                        'street': address.street,\n                        'city': address.city,\n                        'region_id': address.regionId,\n                        'region': address.region,\n                        'country_id': address.countryId,\n                        'postcode': address.postcode,\n                        'email': address.email,\n                        'customer_id': address.customerId,\n                        'firstname': address.firstname,\n                        'lastname': address.lastname,\n                        'middlename': address.middlename,\n                        'prefix': address.prefix,\n                        'suffix': address.suffix,\n                        'vat_id': address.vatId,\n                        'company': address.company,\n                        'telephone': address.telephone,\n                        'fax': address.fax,\n                        'custom_attributes': address.customAttributes,\n                        'save_in_address_book': address.saveInAddressBook\n                    }\n                }\n            );\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                storage.post(\n                    serviceUrl, payload, false\n                ).done(function (result) {\n                    rateRegistry.set(address.getCacheKey(), result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                });\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-processor/customer-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor'\n], function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n    'use strict';\n\n    return {\n        /**\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache;\n\n            shippingService.isLoading(true);\n            cache = rateRegistry.get(address.getKey());\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                storage.post(\n                    resourceUrlManager.getUrlForEstimationShippingMethodsByAddressId(),\n                    JSON.stringify({\n                        addressId: address.customerAddressId\n                    }),\n                    false\n                ).done(function (result) {\n                    rateRegistry.set(address.getKey(), result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                }\n                );\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/payment/method-converter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return function (methods) {\n        _.each(methods, function (method) {\n            if (method.hasOwnProperty('code')) {\n                method.method = method.code;\n                delete method.code;\n            }\n        });\n\n        return methods;\n    };\n});\n","Magento_Checkout/js/model/payment/additional-validators.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    var validators = [];\n\n    return {\n        /**\n         * Register unique validator\n         *\n         * @param {*} validator\n         */\n        registerValidator: function (validator) {\n            validators.push(validator);\n        },\n\n        /**\n         * Returns array of registered validators\n         *\n         * @returns {Array}\n         */\n        getValidators: function () {\n            return validators;\n        },\n\n        /**\n         * Process validators\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            var validationResult = true;\n\n            if (validators.length <= 0) {\n                return validationResult;\n            }\n\n            validators.forEach(function (item) {\n                if (item.validate() == false) { //eslint-disable-line eqeqeq\n                    validationResult = false;\n\n                    return false;\n                }\n            });\n\n            return validationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/payment/renderer-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Checkout/js/model/payment/method-group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'uiElement',\n        'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    var DEFAULT_GROUP_ALIAS = 'default';\n\n    return Element.extend({\n        defaults: {\n            alias: DEFAULT_GROUP_ALIAS,\n            title: $t('Payment Method'),\n            sortOrder: 100,\n            displayArea: 'payment-methods-items-${ $.alias }'\n        },\n\n        /**\n         * Checks if group instance is default\n         *\n         * @returns {Boolean}\n         */\n        isDefault: function () {\n            return this.alias === DEFAULT_GROUP_ALIAS;\n        }\n    });\n});\n","Magento_Checkout/js/model/payment/method-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Checkout/js/action/get-totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    '../model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/error-processor',\n    'mage/storage',\n    'Magento_Checkout/js/model/totals'\n], function ($, quote, resourceUrlManager, errorProcessor, storage, totals) {\n    'use strict';\n\n    return function (callbacks, deferred) {\n        deferred = deferred || $.Deferred();\n        totals.isLoading(true);\n\n        return storage.get(\n            resourceUrlManager.getUrlForCartTotals(quote),\n            false\n        ).done(function (response) {\n            var proceed = true;\n\n            totals.isLoading(false);\n\n            if (callbacks.length > 0) {\n                $.each(callbacks, function (index, callback) {\n                    proceed = proceed && callback();\n                });\n            }\n\n            if (proceed) {\n                quote.setTotals(response);\n                deferred.resolve();\n            }\n        }).error(function (response) {\n            totals.isLoading(false);\n            deferred.reject();\n            errorProcessor.process(response);\n        }).always(function () {\n            totals.isLoading(false);\n        });\n    };\n});\n","Magento_Checkout/js/action/select-payment-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    '../model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (paymentMethod) {\n        quote.paymentMethod(paymentMethod);\n    };\n});\n","Magento_Checkout/js/action/select-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    '../model/quote'\n], function ($, quote) {\n    'use strict';\n\n    return function (billingAddress) {\n        var address = null;\n\n        if (quote.shippingAddress() && billingAddress.getCacheKey() == //eslint-disable-line eqeqeq\n            quote.shippingAddress().getCacheKey()\n        ) {\n            address = $.extend({}, billingAddress);\n            address.saveInAddressBook = null;\n        } else {\n            address = billingAddress;\n        }\n        quote.billingAddress(address);\n    };\n});\n","Magento_Checkout/js/action/select-shipping-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (shippingAddress) {\n        quote.shippingAddress(shippingAddress);\n    };\n});\n","Magento_Checkout/js/action/set-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/action/get-payment-information'\n    ],\n    function ($,\n              quote,\n              urlBuilder,\n              storage,\n              errorProcessor,\n              customer,\n              fullScreenLoader,\n              getPaymentInformationAction\n    ) {\n        'use strict';\n\n        return function (messageContainer) {\n            var serviceUrl,\n                payload;\n\n            /**\n             * Checkout for guest and registered customer.\n             */\n            if (!customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/billing-address', {\n                    cartId: quote.getQuoteId()\n                });\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            } else {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/billing-address', {});\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            }\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload)\n            ).done(\n                function () {\n                    var deferred = $.Deferred();\n\n                    getPaymentInformationAction(deferred);\n                    $.when(deferred).done(function () {\n                        fullScreenLoader.stopLoader();\n                    });\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/action/get-payment-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'mage/storage',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/model/payment-service'\n], function ($, quote, urlBuilder, storage, errorProcessor, customer, methodConverter, paymentService) {\n    'use strict';\n\n    return function (deferred, messageContainer) {\n        var serviceUrl;\n\n        deferred = deferred || $.Deferred();\n\n        /**\n         * Checkout for guest and registered customer.\n         */\n        if (!customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/payment-information', {\n                cartId: quote.getQuoteId()\n            });\n        } else {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n        }\n\n        return storage.get(\n            serviceUrl, false\n        ).done(function (response) {\n            quote.setTotals(response.totals);\n            paymentService.setPaymentMethods(methodConverter(response['payment_methods']));\n            deferred.resolve();\n        }).fail(function (response) {\n            errorProcessor.process(response, messageContainer);\n            deferred.reject();\n        });\n    };\n});\n","Magento_Checkout/js/action/set-payment-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'mage/storage',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/action/get-totals',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function (quote, urlBuilder, storage, errorProcessor, customer, getTotalsAction, fullScreenLoader) {\n    'use strict';\n\n    return function (messageContainer, paymentData) {\n        var serviceUrl,\n            payload;\n\n        /**\n         * Checkout for guest and registered customer.\n         */\n        if (!customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/set-payment-information', {\n                cartId: quote.getQuoteId()\n            });\n            payload = {\n                cartId: quote.getQuoteId(),\n                email: quote.guestEmail,\n                paymentMethod: paymentData,\n                billingAddress: quote.billingAddress()\n            };\n        } else {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/set-payment-information', {});\n            payload = {\n                cartId: quote.getQuoteId(),\n                paymentMethod: paymentData,\n                billingAddress: quote.billingAddress()\n            };\n        }\n\n        fullScreenLoader.startLoader();\n\n        return storage.post(\n            serviceUrl, JSON.stringify(payload)\n        ).fail(\n            function (response) {\n                errorProcessor.process(response, messageContainer);\n            }\n        ).always(\n            function () {\n                fullScreenLoader.stopLoader();\n            }\n        );\n    };\n});\n","Magento_Checkout/js/action/redirect-on-success.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(\n    [\n        'mage/url',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (url, fullScreenLoader) {\n        'use strict';\n\n        return {\n            redirectUrl: window.checkoutConfig.defaultSuccessPageUrl,\n\n            /**\n             * Provide redirect to page\n             */\n            execute: function () {\n                fullScreenLoader.startLoader();\n                window.location.replace(url.build(this.redirectUrl));\n            }\n        };\n    }\n);\n","Magento_Checkout/js/action/place-order.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/place-order'\n], function (quote, urlBuilder, customer, placeOrderService) {\n    'use strict';\n\n    return function (paymentData, messageContainer) {\n        var serviceUrl, payload;\n\n        payload = {\n            cartId: quote.getQuoteId(),\n            billingAddress: quote.billingAddress(),\n            paymentMethod: paymentData\n        };\n\n        if (customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n        } else {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:quoteId/payment-information', {\n                quoteId: quote.getQuoteId()\n            });\n            payload.email = quote.guestEmail;\n        }\n\n        return placeOrderService(serviceUrl, payload, messageContainer);\n    };\n});\n","Magento_Checkout/js/action/set-shipping-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    '../model/quote',\n    'Magento_Checkout/js/model/shipping-save-processor'\n], function (quote, shippingSaveProcessor) {\n    'use strict';\n\n    return function () {\n        return shippingSaveProcessor.saveShippingInformation(quote.shippingAddress().getType());\n    };\n});\n","Magento_Checkout/js/action/create-shipping-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/address-converter'\n], function (addressList, addressConverter) {\n    'use strict';\n\n    return function (addressData) {\n        var address = addressConverter.formAddressDataToQuoteAddress(addressData),\n            isAddressUpdated = addressList().some(function (currentAddress, index, addresses) {\n                if (currentAddress.getKey() == address.getKey()) { //eslint-disable-line eqeqeq\n                    addresses[index] = address;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n        if (!isAddressUpdated) {\n            addressList.push(address);\n        } else {\n            addressList.valueHasMutated();\n        }\n\n        return address;\n    };\n});\n","Magento_Checkout/js/action/select-shipping-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    '../model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (shippingMethod) {\n        quote.shippingMethod(shippingMethod);\n    };\n});\n","Magento_Checkout/js/action/create-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/address-converter'\n], function (addressConverter) {\n    'use strict';\n\n    return function (addressData) {\n        return addressConverter.formAddressDataToQuoteAddress(addressData);\n    };\n});\n","Magento_Checkout/js/view/shipping-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/model/sidebar'\n], function ($, Component, quote, stepNavigator, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isVisible: function () {\n            return !quote.isVirtual() && stepNavigator.isProcessed('shipping');\n        },\n\n        /**\n         * @return {String}\n         */\n        getShippingMethodTitle: function () {\n            var shippingMethod = quote.shippingMethod();\n\n            return shippingMethod ? shippingMethod['carrier_title'] + ' - ' + shippingMethod['method_title'] : '';\n        },\n\n        /**\n         * Back step.\n         */\n        back: function () {\n            sidebarModel.hide();\n            stepNavigator.navigateTo('shipping');\n        },\n\n        /**\n         * Back to shipping method.\n         */\n        backToShippingMethod: function () {\n            sidebarModel.hide();\n            stepNavigator.navigateTo('shipping', 'opc-shipping_method');\n        }\n    });\n});\n","Magento_Checkout/js/view/payment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/action/get-payment-information',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Component,\n    ko,\n    quote,\n    stepNavigator,\n    paymentService,\n    methodConverter,\n    getPaymentInformation,\n    checkoutDataResolver,\n    $t\n) {\n    'use strict';\n\n    /** Set payment methods to collection */\n    paymentService.setPaymentMethods(methodConverter(window.checkoutConfig.paymentMethods));\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/payment',\n            activeMethod: ''\n        },\n        isVisible: ko.observable(quote.isVirtual()),\n        quoteIsVirtual: quote.isVirtual(),\n        isPaymentMethodsAvailable: ko.computed(function () {\n            return paymentService.getAvailablePaymentMethods().length > 0;\n        }),\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            checkoutDataResolver.resolvePaymentMethod();\n            stepNavigator.registerStep(\n                'payment',\n                null,\n                $t('Review & Payments'),\n                this.isVisible,\n                _.bind(this.navigate, this),\n                20\n            );\n\n            return this;\n        },\n\n        /**\n         * Navigate method.\n         */\n        navigate: function () {\n            var self = this;\n\n            getPaymentInformation().done(function () {\n                self.isVisible(true);\n            });\n        },\n\n        /**\n         * @return {*}\n         */\n        getFormKey: function () {\n            return window.checkoutConfig.formKey;\n        }\n    });\n});\n","Magento_Checkout/js/view/estimation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/sidebar'\n], function (Component, quote, priceUtils, totals, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        isLoading: totals.isLoading,\n\n        /**\n         * @return {Number}\n         */\n        getQuantity: function () {\n            if (totals.totals()) {\n                return parseFloat(totals.totals()['items_qty']);\n            }\n\n            return 0;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            if (totals.totals()) {\n                return parseFloat(totals.getSegment('grand_total').value);\n            }\n\n            return 0;\n        },\n\n        /**\n         * Show sidebar.\n         */\n        showSidebar: function () {\n            sidebarModel.show();\n        },\n\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            return priceUtils.formatPrice(price, quote.getPriceFormat());\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n    });\n});\n","Magento_Checkout/js/view/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'ko',\n    'jquery',\n    'Magento_Checkout/js/model/sidebar'\n], function (Component, ko, $, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @param {HTMLElement} element\n         */\n        setModalElement: function (element) {\n            sidebarModel.setPopup($(element));\n        }\n    });\n});\n","Magento_Checkout/js/view/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/totals'\n], function (Component, totals) {\n    'use strict';\n\n    return Component.extend({\n        isLoading: totals.isLoading\n    });\n});\n","Magento_Checkout/js/view/authentication.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/form',\n    'Magento_Customer/js/action/login',\n    'Magento_Customer/js/model/customer',\n    'mage/validation',\n    'Magento_Checkout/js/model/authentication-messages',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, Component, loginAction, customer, validation, messageContainer, fullScreenLoader) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig;\n\n    return Component.extend({\n        isGuestCheckoutAllowed: checkoutConfig.isGuestCheckoutAllowed,\n        isCustomerLoginRequired: checkoutConfig.isCustomerLoginRequired,\n        registerUrl: checkoutConfig.registerUrl,\n        forgotPasswordUrl: checkoutConfig.forgotPasswordUrl,\n        autocomplete: checkoutConfig.autocomplete,\n        defaults: {\n            template: 'Magento_Checkout/authentication'\n        },\n\n        /**\n         * Is login form enabled for current customer.\n         *\n         * @return {Boolean}\n         */\n        isActive: function () {\n            return !customer.isLoggedIn();\n        },\n\n        /**\n         * Provide login action.\n         *\n         * @param {HTMLElement} loginForm\n         */\n        login: function (loginForm) {\n            var loginData = {},\n                formDataArray = $(loginForm).serializeArray();\n\n            formDataArray.forEach(function (entry) {\n                loginData[entry.name] = entry.value;\n            });\n\n            if ($(loginForm).validation() &&\n                $(loginForm).validation('isValid')\n            ) {\n                fullScreenLoader.startLoader();\n                loginAction(loginData, checkoutConfig.checkoutUrl, undefined, messageContainer).always(function () {\n                    fullScreenLoader.stopLoader();\n                });\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/registration.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/model/messageList'\n], function ($, Component, messageList) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/registration',\n            accountCreated: false,\n            creationStarted: false,\n            isFormVisible: true\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super()\n                .observe('accountCreated')\n                .observe('isFormVisible')\n                .observe('creationStarted');\n\n            return this;\n        },\n\n        /**\n         * @return {*}\n         */\n        getEmailAddress: function () {\n            return this.email;\n        },\n\n        /**\n         * Create new user account\n         */\n        createAccount: function () {\n            this.creationStarted(true);\n            $.post(\n                this.registrationUrl\n            ).done(\n                function (response) {\n\n                    if (response.errors == false) { //eslint-disable-line eqeqeq\n                        this.accountCreated(true);\n                    } else {\n                        messageList.addErrorMessage(response);\n                    }\n                    this.isFormVisible(false);\n                }.bind(this)\n            ).fail(\n                function (response) {\n                    this.accountCreated(false);\n                    this.isFormVisible(false);\n                    messageList.addErrorMessage(response);\n                }.bind(this)\n            );\n        }\n    });\n});\n","Magento_Checkout/js/view/beforePlaceOrder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine(['uiComponent'], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            displayArea: 'beforePlaceOrder'\n        }\n    });\n});\n","Magento_Checkout/js/view/authentication-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/view/messages',\n    'Magento_Checkout/js/model/authentication-messages'\n], function (Component, messageContainer) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function (config) {\n            return this._super(config, messageContainer);\n        }\n    });\n});\n","Magento_Checkout/js/view/progress-bar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'uiComponent',\n    'Magento_Checkout/js/model/step-navigator',\n    'jquery/jquery.hashchange'\n], function ($, _, ko, Component, stepNavigator) {\n    'use strict';\n\n    var steps = stepNavigator.steps;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/progress-bar',\n            visible: true\n        },\n        steps: steps,\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            $(window).hashchange(_.bind(stepNavigator.handleHash, stepNavigator));\n            stepNavigator.handleHash();\n        },\n\n        /**\n         * @param {*} itemOne\n         * @param {*} itemTwo\n         * @return {*|Number}\n         */\n        sortItems: function (itemOne, itemTwo) {\n            return stepNavigator.sortItems(itemOne, itemTwo);\n        },\n\n        /**\n         * @param {Object} step\n         */\n        navigateTo: function (step) {\n            stepNavigator.navigateTo(step.code);\n        },\n\n        /**\n         * @param {Object} item\n         * @return {*|Boolean}\n         */\n        isProcessed: function (item) {\n            return stepNavigator.isProcessed(item.code);\n        }\n    });\n});\n","Magento_Checkout/js/view/minicart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'jquery',\n    'ko',\n    'underscore',\n    'sidebar',\n    'mage/translate'\n], function (Component, customerData, $, ko, _) {\n    'use strict';\n\n    var sidebarInitialized = false,\n        addToCartCalls = 0,\n        miniCart;\n\n    miniCart = $('[data-block=\\'minicart\\']');\n\n    /**\n     * @return {Boolean}\n     */\n    function initSidebar() {\n        if (miniCart.data('mageSidebar')) {\n            miniCart.sidebar('update');\n        }\n\n        if (!$('[data-role=product-item]').length) {\n            return false;\n        }\n        miniCart.trigger('contentUpdated');\n\n        if (sidebarInitialized) {\n            return false;\n        }\n        sidebarInitialized = true;\n        miniCart.sidebar({\n            'targetElement': 'div.block.block-minicart',\n            'url': {\n                'checkout': window.checkout.checkoutUrl,\n                'update': window.checkout.updateItemQtyUrl,\n                'remove': window.checkout.removeItemUrl,\n                'loginUrl': window.checkout.customerLoginUrl,\n                'isRedirectRequired': window.checkout.isRedirectRequired\n            },\n            'button': {\n                'checkout': '#top-cart-btn-checkout',\n                'remove': '#mini-cart a.action.delete',\n                'close': '#btn-minicart-close'\n            },\n            'showcart': {\n                'parent': 'span.counter',\n                'qty': 'span.counter-number',\n                'label': 'span.counter-label'\n            },\n            'minicart': {\n                'list': '#mini-cart',\n                'content': '#minicart-content-wrapper',\n                'qty': 'div.items-total',\n                'subtotal': 'div.subtotal span.price',\n                'maxItemsVisible': window.checkout.minicartMaxItemsVisible\n            },\n            'item': {\n                'qty': ':input.cart-item-qty',\n                'button': ':button.update-cart-item'\n            },\n            'confirmMessage': $.mage.__('Are you sure you would like to remove this item from the shopping cart?')\n        });\n    }\n\n    miniCart.on('dropdowndialogopen', function () {\n        initSidebar();\n    });\n\n    return Component.extend({\n        shoppingCartUrl: window.checkout.shoppingCartUrl,\n        maxItemsToDisplay: window.checkout.maxItemsToDisplay,\n        cart: {},\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            var self = this,\n                cartData = customerData.get('cart');\n\n            this.update(cartData());\n            cartData.subscribe(function (updatedCart) {\n                addToCartCalls--;\n                this.isLoading(addToCartCalls > 0);\n                sidebarInitialized = false;\n                this.update(updatedCart);\n                initSidebar();\n            }, this);\n            $('[data-block=\"minicart\"]').on('contentLoading', function () {\n                addToCartCalls++;\n                self.isLoading(true);\n            });\n\n            if (cartData()['website_id'] !== window.checkout.websiteId) {\n                customerData.reload(['cart'], false);\n            }\n\n            return this._super();\n        },\n        isLoading: ko.observable(false),\n        initSidebar: initSidebar,\n\n        /**\n         * Close mini shopping cart.\n         */\n        closeMinicart: function () {\n            $('[data-block=\"minicart\"]').find('[data-role=\"dropdownDialog\"]').dropdownDialog('close');\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        closeSidebar: function () {\n            var minicart = $('[data-block=\"minicart\"]');\n\n            minicart.on('click', '[data-action=\"close\"]', function (event) {\n                event.stopPropagation();\n                minicart.find('[data-role=\"dropdownDialog\"]').dropdownDialog('close');\n            });\n\n            return true;\n        },\n\n        /**\n         * @param {String} productType\n         * @return {*|String}\n         */\n        getItemRenderer: function (productType) {\n            return this.itemRenderer[productType] || 'defaultRenderer';\n        },\n\n        /**\n         * Update mini shopping cart content.\n         *\n         * @param {Object} updatedCart\n         * @returns void\n         */\n        update: function (updatedCart) {\n            _.each(updatedCart, function (value, key) {\n                if (!this.cart.hasOwnProperty(key)) {\n                    this.cart[key] = ko.observable();\n                }\n                this.cart[key](value);\n            }, this);\n        },\n\n        /**\n         * Get cart param by name.\n         * @param {String} name\n         * @returns {*}\n         */\n        getCartParam: function (name) {\n            if (!_.isUndefined(name)) {\n                if (!this.cart.hasOwnProperty(name)) {\n                    this.cart[name] = ko.observable();\n                }\n            }\n\n            return this.cart[name]();\n        },\n\n        /**\n         * Returns array of cart items, limited by 'maxItemsToDisplay' setting\n         * @returns []\n         */\n        getCartItems: function () {\n            var items = this.getCartParam('items') || [];\n\n            items = items.slice(parseInt(-this.maxItemsToDisplay, 10));\n\n            return items;\n        },\n\n        /**\n         * Returns count of cart line items\n         * @returns {Number}\n         */\n        getCartLineItemsCount: function () {\n            var items = this.getCartParam('items') || [];\n\n            return parseInt(items.length, 10);\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/form/form',\n    'ko',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/address-converter',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/create-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/action/set-shipping-information',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Ui/js/modal/modal',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'Magento_Checkout/js/checkout-data',\n    'uiRegistry',\n    'mage/translate',\n    'Magento_Checkout/js/model/shipping-rate-service'\n], function (\n    $,\n    _,\n    Component,\n    ko,\n    customer,\n    addressList,\n    addressConverter,\n    quote,\n    createShippingAddress,\n    selectShippingAddress,\n    shippingRatesValidator,\n    formPopUpState,\n    shippingService,\n    selectShippingMethodAction,\n    rateRegistry,\n    setShippingInformationAction,\n    stepNavigator,\n    modal,\n    checkoutDataResolver,\n    checkoutData,\n    registry,\n    $t\n) {\n    'use strict';\n\n    var popUp = null;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping',\n            shippingFormTemplate: 'Magento_Checkout/shipping-address/form',\n            shippingMethodListTemplate: 'Magento_Checkout/shipping-address/shipping-method-list',\n            shippingMethodItemTemplate: 'Magento_Checkout/shipping-address/shipping-method-item'\n        },\n        visible: ko.observable(!quote.isVirtual()),\n        errorValidationMessage: ko.observable(false),\n        isCustomerLoggedIn: customer.isLoggedIn,\n        isFormPopUpVisible: formPopUpState.isVisible,\n        isFormInline: addressList().length === 0,\n        isNewAddressAdded: ko.observable(false),\n        saveInAddressBook: 1,\n        quoteIsVirtual: quote.isVirtual(),\n\n        /**\n         * @return {exports}\n         */\n        initialize: function () {\n            var self = this,\n                hasNewAddress,\n                fieldsetName = 'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset';\n\n            this._super();\n\n            if (!quote.isVirtual()) {\n                stepNavigator.registerStep(\n                    'shipping',\n                    '',\n                    $t('Shipping'),\n                    this.visible, _.bind(this.navigate, this),\n                    10\n                );\n            }\n            checkoutDataResolver.resolveShippingAddress();\n\n            hasNewAddress = addressList.some(function (address) {\n                return address.getType() == 'new-customer-address'; //eslint-disable-line eqeqeq\n            });\n\n            this.isNewAddressAdded(hasNewAddress);\n\n            this.isFormPopUpVisible.subscribe(function (value) {\n                if (value) {\n                    self.getPopUp().openModal();\n                }\n            });\n\n            quote.shippingMethod.subscribe(function () {\n                self.errorValidationMessage(false);\n            });\n\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                var shippingAddressData = checkoutData.getShippingAddressFromData();\n\n                if (shippingAddressData) {\n                    checkoutProvider.set(\n                        'shippingAddress',\n                        $.extend(true, {}, checkoutProvider.get('shippingAddress'), shippingAddressData)\n                    );\n                }\n                checkoutProvider.on('shippingAddress', function (shippingAddrsData) {\n                    checkoutData.setShippingAddressFromData(shippingAddrsData);\n                });\n                shippingRatesValidator.initFields(fieldsetName);\n            });\n\n            return this;\n        },\n\n        /**\n         * Navigator change hash handler.\n         *\n         * @param {Object} step - navigation step\n         */\n        navigate: function (step) {\n            step && step.isVisible(true);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPopUp: function () {\n            var self = this,\n                buttons;\n\n            if (!popUp) {\n                buttons = this.popUpForm.options.buttons;\n                this.popUpForm.options.buttons = [\n                    {\n                        text: buttons.save.text ? buttons.save.text : $t('Save Address'),\n                        class: buttons.save.class ? buttons.save.class : 'action primary action-save-address',\n                        click: self.saveNewAddress.bind(self)\n                    },\n                    {\n                        text: buttons.cancel.text ? buttons.cancel.text : $t('Cancel'),\n                        class: buttons.cancel.class ? buttons.cancel.class : 'action secondary action-hide-popup',\n\n                        /** @inheritdoc */\n                        click: this.onClosePopUp.bind(this)\n                    }\n                ];\n\n                /** @inheritdoc */\n                this.popUpForm.options.closed = function () {\n                    self.isFormPopUpVisible(false);\n                };\n\n                this.popUpForm.options.modalCloseBtnHandler = this.onClosePopUp.bind(this);\n                this.popUpForm.options.keyEventHandlers = {\n                    escapeKey: this.onClosePopUp.bind(this)\n                };\n\n                /** @inheritdoc */\n                this.popUpForm.options.opened = function () {\n                    // Store temporary address for revert action in case when user click cancel action\n                    self.temporaryAddress = $.extend(true, {}, checkoutData.getShippingAddressFromData());\n                };\n                popUp = modal(this.popUpForm.options, $(this.popUpForm.element));\n            }\n\n            return popUp;\n        },\n\n        /**\n         * Revert address and close modal.\n         */\n        onClosePopUp: function () {\n            checkoutData.setShippingAddressFromData($.extend(true, {}, this.temporaryAddress));\n            this.getPopUp().closeModal();\n        },\n\n        /**\n         * Show address form popup\n         */\n        showFormPopUp: function () {\n            this.isFormPopUpVisible(true);\n        },\n\n        /**\n         * Save new shipping address\n         */\n        saveNewAddress: function () {\n            var addressData,\n                newShippingAddress;\n\n            this.source.set('params.invalid', false);\n            this.triggerShippingDataValidateEvent();\n\n            if (!this.source.get('params.invalid')) {\n                addressData = this.source.get('shippingAddress');\n                // if user clicked the checkbox, its value is true or false. Need to convert.\n                addressData['save_in_address_book'] = this.saveInAddressBook ? 1 : 0;\n\n                // New address must be selected as a shipping address\n                newShippingAddress = createShippingAddress(addressData);\n                selectShippingAddress(newShippingAddress);\n                checkoutData.setSelectedShippingAddress(newShippingAddress.getKey());\n                checkoutData.setNewCustomerShippingAddress($.extend(true, {}, addressData));\n                this.getPopUp().closeModal();\n                this.isNewAddressAdded(true);\n            }\n        },\n\n        /**\n         * Shipping Method View\n         */\n        rates: shippingService.getShippingRates(),\n        isLoading: shippingService.isLoading,\n        isSelected: ko.computed(function () {\n            return quote.shippingMethod() ?\n                quote.shippingMethod()['carrier_code'] + '_' + quote.shippingMethod()['method_code'] :\n                null;\n        }),\n\n        /**\n         * @param {Object} shippingMethod\n         * @return {Boolean}\n         */\n        selectShippingMethod: function (shippingMethod) {\n            selectShippingMethodAction(shippingMethod);\n            checkoutData.setSelectedShippingRate(shippingMethod['carrier_code'] + '_' + shippingMethod['method_code']);\n\n            return true;\n        },\n\n        /**\n         * Set shipping information handler\n         */\n        setShippingInformation: function () {\n            if (this.validateShippingInformation()) {\n                setShippingInformationAction().done(\n                    function () {\n                        stepNavigator.next();\n                    }\n                );\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        validateShippingInformation: function () {\n            var shippingAddress,\n                addressData,\n                loginFormSelector = 'form[data-role=email-with-possible-login]',\n                emailValidationResult = customer.isLoggedIn(),\n                field;\n\n            if (!quote.shippingMethod()) {\n                this.errorValidationMessage($t('Please specify a shipping method.'));\n\n                return false;\n            }\n\n            if (!customer.isLoggedIn()) {\n                $(loginFormSelector).validation();\n                emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());\n            }\n\n            if (this.isFormInline) {\n                this.source.set('params.invalid', false);\n                this.triggerShippingDataValidateEvent();\n\n                if (emailValidationResult &&\n                    this.source.get('params.invalid') ||\n                    !quote.shippingMethod()['method_code'] ||\n                    !quote.shippingMethod()['carrier_code']\n                ) {\n                    this.focusInvalid();\n\n                    return false;\n                }\n\n                shippingAddress = quote.shippingAddress();\n                addressData = addressConverter.formAddressDataToQuoteAddress(\n                    this.source.get('shippingAddress')\n                );\n\n                //Copy form data to quote shipping address object\n                for (field in addressData) {\n                    if (addressData.hasOwnProperty(field) &&  //eslint-disable-line max-depth\n                        shippingAddress.hasOwnProperty(field) &&\n                        typeof addressData[field] != 'function' &&\n                        _.isEqual(shippingAddress[field], addressData[field])\n                    ) {\n                        shippingAddress[field] = addressData[field];\n                    } else if (typeof addressData[field] != 'function' &&\n                        !_.isEqual(shippingAddress[field], addressData[field])) {\n                        shippingAddress = addressData;\n                        break;\n                    }\n                }\n\n                if (customer.isLoggedIn()) {\n                    shippingAddress['save_in_address_book'] = 1;\n                }\n                selectShippingAddress(shippingAddress);\n            }\n\n            if (!emailValidationResult) {\n                $(loginFormSelector + ' input[name=username]').focus();\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Trigger Shipping data Validate Event.\n         */\n        triggerShippingDataValidateEvent: function () {\n            this.source.trigger('shippingAddress.data.validate');\n\n            if (this.source.get('shippingAddress.custom_attributes')) {\n                this.source.trigger('shippingAddress.custom_attributes.data.validate');\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/form/form',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/create-billing-address',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'Magento_Customer/js/customer-data',\n    'Magento_Checkout/js/action/set-billing-address',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n],\nfunction (\n    ko,\n    _,\n    Component,\n    customer,\n    addressList,\n    quote,\n    createBillingAddress,\n    selectBillingAddress,\n    checkoutData,\n    checkoutDataResolver,\n    customerData,\n    setBillingAddressAction,\n    globalMessageList,\n    $t\n) {\n    'use strict';\n\n    var lastSelectedBillingAddress = null,\n        newAddressOption = {\n            /**\n             * Get new address label\n             * @returns {String}\n             */\n            getAddressInline: function () {\n                return $t('New Address');\n            },\n            customerAddressId: null\n        },\n        countryData = customerData.get('directory-data'),\n        addressOptions = addressList().filter(function (address) {\n            return address.getType() == 'customer-address'; //eslint-disable-line eqeqeq\n        });\n\n    addressOptions.push(newAddressOption);\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/billing-address'\n        },\n        currentBillingAddress: quote.billingAddress,\n        addressOptions: addressOptions,\n        customerHasAddresses: addressOptions.length > 1,\n\n        /**\n         * Init component\n         */\n        initialize: function () {\n            this._super();\n            quote.paymentMethod.subscribe(function () {\n                checkoutDataResolver.resolveBillingAddress();\n            }, this);\n        },\n\n        /**\n         * @return {exports.initObservable}\n         */\n        initObservable: function () {\n            this._super()\n                .observe({\n                    selectedAddress: null,\n                    isAddressDetailsVisible: quote.billingAddress() != null,\n                    isAddressFormVisible: !customer.isLoggedIn() || addressOptions.length === 1,\n                    isAddressSameAsShipping: false,\n                    saveInAddressBook: 1\n                });\n\n            quote.billingAddress.subscribe(function (newAddress) {\n                if (quote.isVirtual()) {\n                    this.isAddressSameAsShipping(false);\n                } else {\n                    this.isAddressSameAsShipping(\n                        newAddress != null &&\n                        newAddress.getCacheKey() == quote.shippingAddress().getCacheKey() //eslint-disable-line eqeqeq\n                    );\n                }\n\n                if (newAddress != null && newAddress.saveInAddressBook !== undefined) {\n                    this.saveInAddressBook(newAddress.saveInAddressBook);\n                } else {\n                    this.saveInAddressBook(1);\n                }\n                this.isAddressDetailsVisible(true);\n            }, this);\n\n            return this;\n        },\n\n        canUseShippingAddress: ko.computed(function () {\n            return !quote.isVirtual() && quote.shippingAddress() && quote.shippingAddress().canUseForBilling();\n        }),\n\n        /**\n         * @param {Object} address\n         * @return {*}\n         */\n        addressOptionsText: function (address) {\n            return address.getAddressInline();\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        useShippingAddress: function () {\n            if (this.isAddressSameAsShipping()) {\n                selectBillingAddress(quote.shippingAddress());\n\n                this.updateAddresses();\n                this.isAddressDetailsVisible(true);\n            } else {\n                lastSelectedBillingAddress = quote.billingAddress();\n                quote.billingAddress(null);\n                this.isAddressDetailsVisible(false);\n            }\n            checkoutData.setSelectedBillingAddress(null);\n\n            return true;\n        },\n\n        /**\n         * Update address action\n         */\n        updateAddress: function () {\n            var addressData, newBillingAddress;\n\n            if (this.selectedAddress() && this.selectedAddress() != newAddressOption) { //eslint-disable-line eqeqeq\n                selectBillingAddress(this.selectedAddress());\n                checkoutData.setSelectedBillingAddress(this.selectedAddress().getKey());\n            } else {\n                this.source.set('params.invalid', false);\n                this.source.trigger(this.dataScopePrefix + '.data.validate');\n\n                if (this.source.get(this.dataScopePrefix + '.custom_attributes')) {\n                    this.source.trigger(this.dataScopePrefix + '.custom_attributes.data.validate');\n                }\n\n                if (!this.source.get('params.invalid')) {\n                    addressData = this.source.get(this.dataScopePrefix);\n\n                    if (customer.isLoggedIn() && !this.customerHasAddresses) { //eslint-disable-line max-depth\n                        this.saveInAddressBook(1);\n                    }\n                    addressData['save_in_address_book'] = this.saveInAddressBook() ? 1 : 0;\n                    newBillingAddress = createBillingAddress(addressData);\n\n                    // New address must be selected as a billing address\n                    selectBillingAddress(newBillingAddress);\n                    checkoutData.setSelectedBillingAddress(newBillingAddress.getKey());\n                    checkoutData.setNewCustomerBillingAddress(addressData);\n                }\n            }\n            this.updateAddresses();\n        },\n\n        /**\n         * Edit address action\n         */\n        editAddress: function () {\n            lastSelectedBillingAddress = quote.billingAddress();\n            quote.billingAddress(null);\n            this.isAddressDetailsVisible(false);\n        },\n\n        /**\n         * Cancel address edit action\n         */\n        cancelAddressEdit: function () {\n            this.restoreBillingAddress();\n\n            if (quote.billingAddress()) {\n                // restore 'Same As Shipping' checkbox state\n                this.isAddressSameAsShipping(\n                    quote.billingAddress() != null &&\n                        quote.billingAddress().getCacheKey() == quote.shippingAddress().getCacheKey() && //eslint-disable-line\n                        !quote.isVirtual()\n                );\n                this.isAddressDetailsVisible(true);\n            }\n        },\n\n        /**\n         * Restore billing address\n         */\n        restoreBillingAddress: function () {\n            if (lastSelectedBillingAddress != null) {\n                selectBillingAddress(lastSelectedBillingAddress);\n            }\n        },\n\n        /**\n         * @param {Object} address\n         */\n        onAddressChange: function (address) {\n            this.isAddressFormVisible(address == newAddressOption); //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @param {Number} countryId\n         * @return {*}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        },\n\n        /**\n         * Trigger action to update shipping and billing addresses\n         */\n        updateAddresses: function () {\n            if (window.checkoutConfig.reloadOnBillingAddress ||\n                !window.checkoutConfig.displayBillingOnPaymentMethod\n            ) {\n                setBillingAddressAction(globalMessageList);\n            }\n        },\n\n        /**\n         * Get code\n         * @param {Object} parent\n         * @returns {String}\n         */\n        getCode: function (parent) {\n            return _.isFunction(parent.getCode) ? parent.getCode() : 'shared';\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-address/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Customer/js/model/address-list'\n], function (_, ko, utils, Component, layout, addressList) {\n    'use strict';\n\n    var defaultRendererTemplate = {\n        parent: '${ $.$data.parentName }',\n        name: '${ $.$data.name }',\n        component: 'Magento_Checkout/js/view/shipping-address/address-renderer/default'\n    };\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-address/list',\n            visible: addressList().length > 0,\n            rendererTemplates: []\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n                .initChildren();\n\n            addressList.subscribe(function (changes) {\n                    var self = this;\n\n                    changes.forEach(function (change) {\n                        if (change.status === 'added') {\n                            self.createRendererComponent(change.value, change.index);\n                        }\n                    });\n                },\n                this,\n                'arrayChange'\n            );\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n            // the list of child components that are responsible for address rendering\n            this.rendererComponents = [];\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initChildren: function () {\n            _.each(addressList(), this.createRendererComponent, this);\n\n            return this;\n        },\n\n        /**\n         * Create new component that will render given address in the address list\n         *\n         * @param {Object} address\n         * @param {*} index\n         */\n        createRendererComponent: function (address, index) {\n            var rendererTemplate, templateData, rendererComponent;\n\n            if (index in this.rendererComponents) {\n                this.rendererComponents[index].address(address);\n            } else {\n                // rendererTemplates are provided via layout\n                rendererTemplate = address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined ? //eslint-disable-line\n                    utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()]) :\n                    defaultRendererTemplate;\n                templateData = {\n                    parentName: this.name,\n                    name: index\n                };\n                rendererComponent = utils.template(rendererTemplate, templateData);\n                utils.extend(rendererComponent, {\n                    address: ko.observable(address)\n                });\n                layout([rendererComponent]);\n                this.rendererComponents[index] = rendererComponent;\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-address/address-renderer/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Customer/js/customer-data'\n], function ($, ko, Component, selectShippingAddressAction, quote, formPopUpState, checkoutData, customerData) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-address/address-renderer/default'\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super();\n            this.isSelected = ko.computed(function () {\n                var isSelected = false,\n                    shippingAddress = quote.shippingAddress();\n\n                if (shippingAddress) {\n                    isSelected = shippingAddress.getKey() == this.address().getKey(); //eslint-disable-line eqeqeq\n                }\n\n                return isSelected;\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * @param {String} countryId\n         * @return {String}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        },\n\n        /** Set selected customer shipping address  */\n        selectAddress: function () {\n            selectShippingAddressAction(this.address());\n            checkoutData.setSelectedShippingAddress(this.address().getKey());\n        },\n\n        /**\n         * Edit address.\n         */\n        editAddress: function () {\n            formPopUpState.isVisible(true);\n            this.showPopup();\n\n        },\n\n        /**\n         * Show popup.\n         */\n        showPopup: function () {\n            $('[data-open-modal=\"opc-new-shipping-address\"]').trigger('click');\n        }\n    });\n});\n","Magento_Checkout/js/view/cart/shipping-estimation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Ui/js/form/form',\n        'Magento_Checkout/js/action/select-shipping-address',\n        'Magento_Checkout/js/model/address-converter',\n        'Magento_Checkout/js/model/cart/estimate-service',\n        'Magento_Checkout/js/checkout-data',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'uiRegistry',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/checkout-data-resolver',\n        'mage/validation'\n    ],\n    function (\n        $,\n        Component,\n        selectShippingAddress,\n        addressConverter,\n        estimateService,\n        checkoutData,\n        shippingRatesValidator,\n        registry,\n        quote,\n        checkoutDataResolver\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Checkout/cart/shipping-estimation'\n            },\n            isVirtual: quote.isVirtual(),\n\n            /**\n             * @override\n             */\n            initialize: function () {\n                this._super();\n                registry.async('checkoutProvider')(function (checkoutProvider) {\n                    var address, estimatedAddress;\n\n                    checkoutDataResolver.resolveEstimationAddress();\n                    address = quote.isVirtual() ? quote.billingAddress() : quote.shippingAddress();\n\n                    if (address) {\n                        estimatedAddress = address.isEditable() ?\n                            addressConverter.quoteAddressToFormAddressData(address) :\n                            {\n                                // only the following fields must be used by estimation form data provider\n                                'country_id': address.countryId,\n                                region: address.region,\n                                'region_id': address.regionId,\n                                postcode: address.postcode\n                            };\n                        checkoutProvider.set(\n                            'shippingAddress',\n                            $.extend({}, checkoutProvider.get('shippingAddress'), estimatedAddress)\n                        );\n                    }\n\n                    if (!quote.isVirtual()) {\n                        checkoutProvider.on('shippingAddress', function (shippingAddressData) {\n                            checkoutData.setShippingAddressFromData(shippingAddressData);\n                        });\n                    } else {\n                        checkoutProvider.on('shippingAddress', function (shippingAddressData) {\n                            checkoutData.setBillingAddressFromData(shippingAddressData);\n                        });\n                    }\n                });\n\n                return this;\n            },\n\n            /**\n             * @override\n             */\n            initElement: function (element) {\n                this._super();\n\n                if (element.index === 'address-fieldsets') {\n                    shippingRatesValidator.bindChangeHandlers(element.elems(), true, 500);\n                    element.elems.subscribe(function (elems) {\n                        shippingRatesValidator.doElementBinding(elems[elems.length - 1], true, 500);\n                    });\n                }\n\n                return this;\n            },\n\n            /**\n             * Returns shipping rates for address\n             * @returns void\n             */\n            getEstimationInfo: function () {\n                var addressData = null;\n\n                this.source.set('params.invalid', false);\n                this.source.trigger('shippingAddress.data.validate');\n\n                if (!this.source.get('params.invalid')) {\n                    addressData = this.source.get('shippingAddress');\n                    selectShippingAddress(addressConverter.formAddressDataToQuoteAddress(addressData));\n                }\n            }\n        });\n    }\n);\n","Magento_Checkout/js/view/cart/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/shipping-service'\n], function ($, Component, totalsService, shippingService) {\n    'use strict';\n\n    return Component.extend({\n        isLoading: totalsService.isLoading,\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            totalsService.totals.subscribe(function () {\n                $(window).trigger('resize');\n            });\n            shippingService.getShippingRates().subscribe(function () {\n                $(window).trigger('resize');\n            });\n        }\n    });\n});\n","Magento_Checkout/js/view/cart/shipping-rates.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/checkout-data'\n], function (ko, _, Component, shippingService, priceUtils, quote, selectShippingMethodAction, checkoutData) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/cart/shipping-rates'\n        },\n        isVisible: ko.observable(!quote.isVirtual()),\n        isLoading: shippingService.isLoading,\n        shippingRates: shippingService.getShippingRates(),\n        shippingRateGroups: ko.observableArray([]),\n        selectedShippingMethod: ko.computed(function () {\n            return quote.shippingMethod() ?\n                quote.shippingMethod()['carrier_code'] + '_' + quote.shippingMethod()['method_code'] :\n                null;\n        }),\n\n        /**\n         * @override\n         */\n        initObservable: function () {\n            var self = this;\n\n            this._super();\n\n            this.shippingRates.subscribe(function (rates) {\n                self.shippingRateGroups([]);\n                _.each(rates, function (rate) {\n                    var carrierTitle = rate['carrier_title'];\n\n                    if (self.shippingRateGroups.indexOf(carrierTitle) === -1) {\n                        self.shippingRateGroups.push(carrierTitle);\n                    }\n                });\n            });\n\n            return this;\n        },\n\n        /**\n         * Get shipping rates for specific group based on title.\n         * @returns Array\n         */\n        getRatesForGroup: function (shippingRateGroupTitle) {\n            return _.filter(this.shippingRates(), function (rate) {\n                return shippingRateGroupTitle === rate['carrier_title'];\n            });\n        },\n\n        /**\n         * Format shipping price.\n         * @returns {String}\n         */\n        getFormattedPrice: function (price) {\n            return priceUtils.formatPrice(price, quote.getPriceFormat());\n        },\n\n        /**\n         * Set shipping method.\n         * @param {String} methodData\n         * @returns bool\n         */\n        selectShippingMethod: function (methodData) {\n            selectShippingMethodAction(methodData);\n            checkoutData.setSelectedShippingRate(methodData['carrier_code'] + '_' + methodData['method_code']);\n\n            return true;\n        }\n    });\n});\n","Magento_Checkout/js/view/cart/totals/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return !!quote.shippingMethod();\n        }\n    });\n});\n","Magento_Checkout/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (ko, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        displaySubtotal: ko.observable(true),\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.cart = customerData.get('cart');\n        }\n    });\n});\n","Magento_Checkout/js/view/review/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'underscore'\n], function (Component, quote, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/review/actions',\n            displayArea: 'actions'\n        },\n\n        /**\n         * @return {*}\n         */\n        getActiveView: function () {\n            var view = this.getViewByCode(quote.paymentMethod());\n\n            return view ? view : this.getDefaultView();\n        },\n\n        /**\n         * @param {*} code\n         * @return {Object}\n         */\n        getViewByCode: function (code) {\n            return _.find(this.elems(), function (elem) {\n                return elem.index == code && !elem.isDefault; //eslint-disable-line eqeqeq\n            });\n        },\n\n        /**\n         * Get default view.\n         *\n         * @return {Object}\n         */\n        getDefaultView: function () {\n            return _.find(this.elems(), function (elem) {\n                return elem.isDefault;\n            });\n        }\n    });\n});\n","Magento_Checkout/js/view/review/actions/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/review/actions/default'\n        },\n\n        /**\n         * @param {Object} parent\n         * @return {Function}\n         */\n        placeOrder: function (parent) {\n            return parent.placeOrder.bind(parent);\n        }\n    });\n});\n","Magento_Checkout/js/view/configure/product-customer-data.js":"require([\n    'jquery',\n    'Magento_Customer/js/customer-data'\n], function ($, customerData) {\n    'use strict';\n\n    var selectors = {\n        qtySelector: '#product_addtocart_form [name=\"qty\"]',\n        productIdSelector: '#product_addtocart_form [name=\"product\"]'\n    },\n    cartData = customerData.get('cart'),\n    productId = $(selectors.productIdSelector).val(),\n    productQty,\n    productQtyInput,\n\n    /**\n    * Updates product's qty input value according to actual data\n    */\n    updateQty = function () {\n\n        if (productQty || productQty === 0) {\n            productQtyInput = productQtyInput || $(selectors.qtySelector);\n\n            if (productQtyInput && productQty.toString() !== productQtyInput.val()) {\n                productQtyInput.val(productQty);\n            }\n        }\n    },\n\n    /**\n    * Sets productQty according to cart data from customer-data\n    *\n    * @param {Object} data - cart data from customer-data\n    */\n    setProductQty = function (data) {\n        var product;\n\n        if (!(data && data.items && data.items.length && productId)) {\n            return;\n        }\n        product = data.items.find(function (item) {\n            return item['product_id'] === productId ||\n                item['item_id'] === productId;\n        });\n\n        if (!product) {\n            return;\n        }\n        productQty = product.qty;\n    };\n\n    cartData.subscribe(function (updateCartData) {\n        setProductQty(updateCartData);\n        updateQty();\n    });\n\n    setProductQty(cartData());\n    updateQty();\n});\n","Magento_Checkout/js/view/form/element/email.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'ko',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/action/check-email-availability',\n    'Magento_Customer/js/action/login',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'mage/validation'\n], function ($, Component, ko, customer, checkEmailAvailability, loginAction, quote, checkoutData, fullScreenLoader) {\n    'use strict';\n\n    var validatedEmail = checkoutData.getValidatedEmailValue();\n\n    if (validatedEmail && !customer.isLoggedIn()) {\n        quote.guestEmail = validatedEmail;\n    }\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/form/element/email',\n            email: checkoutData.getInputFieldEmailValue(),\n            emailFocused: false,\n            isLoading: false,\n            isPasswordVisible: false,\n            listens: {\n                email: 'emailHasChanged',\n                emailFocused: 'validateEmail'\n            }\n        },\n        checkDelay: 2000,\n        checkRequest: null,\n        isEmailCheckComplete: null,\n        isCustomerLoggedIn: customer.isLoggedIn,\n        forgotPasswordUrl: window.checkoutConfig.forgotPasswordUrl,\n        emailCheckTimeout: 0,\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['email', 'emailFocused', 'isLoading', 'isPasswordVisible']);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n\n            this.isPasswordVisible = this.resolveInitialPasswordVisibility();\n\n            return this;\n        },\n\n        /**\n         * Callback on changing email property\n         */\n        emailHasChanged: function () {\n            var self = this;\n\n            clearTimeout(this.emailCheckTimeout);\n\n            if (self.validateEmail()) {\n                quote.guestEmail = self.email();\n                checkoutData.setValidatedEmailValue(self.email());\n            }\n            this.emailCheckTimeout = setTimeout(function () {\n                if (self.validateEmail()) {\n                    self.checkEmailAvailability();\n                } else {\n                    self.isPasswordVisible(false);\n                }\n            }, self.checkDelay);\n\n            checkoutData.setInputFieldEmailValue(self.email());\n        },\n\n        /**\n         * Check email existing.\n         */\n        checkEmailAvailability: function () {\n            this.validateRequest();\n            this.isEmailCheckComplete = $.Deferred();\n            this.isLoading(true);\n            this.checkRequest = checkEmailAvailability(this.isEmailCheckComplete, this.email());\n\n            $.when(this.isEmailCheckComplete).done(function () {\n                this.isPasswordVisible(false);\n            }.bind(this)).fail(function () {\n                this.isPasswordVisible(true);\n                checkoutData.setCheckedEmailValue(this.email());\n            }.bind(this)).always(function () {\n                this.isLoading(false);\n            }.bind(this));\n        },\n\n        /**\n         * If request has been sent -> abort it.\n         * ReadyStates for request aborting:\n         * 1 - The request has been set up\n         * 2 - The request has been sent\n         * 3 - The request is in process\n         */\n        validateRequest: function () {\n            if (this.checkRequest != null && $.inArray(this.checkRequest.readyState, [1, 2, 3])) {\n                this.checkRequest.abort();\n                this.checkRequest = null;\n            }\n        },\n\n        /**\n         * Local email validation.\n         *\n         * @param {Boolean} focused - input focus.\n         * @returns {Boolean} - validation result.\n         */\n        validateEmail: function (focused) {\n            var loginFormSelector = 'form[data-role=email-with-possible-login]',\n                usernameSelector = loginFormSelector + ' input[name=username]',\n                loginForm = $(loginFormSelector),\n                validator;\n\n            loginForm.validation();\n\n            if (focused === false && !!this.email()) {\n                return !!$(usernameSelector).valid();\n            }\n\n            validator = loginForm.validate();\n\n            return validator.check(usernameSelector);\n        },\n\n        /**\n         * Log in form submitting callback.\n         *\n         * @param {HTMLElement} loginForm - form element.\n         */\n        login: function (loginForm) {\n            var loginData = {},\n                formDataArray = $(loginForm).serializeArray();\n\n            formDataArray.forEach(function (entry) {\n                loginData[entry.name] = entry.value;\n            });\n\n            if (this.isPasswordVisible() && $(loginForm).validation() && $(loginForm).validation('isValid')) {\n                fullScreenLoader.startLoader();\n                loginAction(loginData).always(function () {\n                    fullScreenLoader.stopLoader();\n                });\n            }\n        },\n\n        /**\n         * Resolves an initial sate of a login form.\n         *\n         * @returns {Boolean} - initial visibility state.\n         */\n        resolveInitialPasswordVisibility: function () {\n            if (checkoutData.getInputFieldEmailValue() !== '') {\n                return checkoutData.getInputFieldEmailValue() === checkoutData.getCheckedEmailValue();\n            }\n\n            return false;\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Checkout/js/model/quote'\n], function ($, ko, utils, Component, layout, quote) {\n    'use strict';\n\n    var defaultRendererTemplate = {\n        parent: '${ $.$data.parentName }',\n        name: '${ $.$data.name }',\n        component: 'Magento_Checkout/js/view/shipping-information/address-renderer/default'\n    };\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information/list',\n            rendererTemplates: {}\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this;\n\n            this._super()\n                .initChildren();\n\n            quote.shippingAddress.subscribe(function (address) {\n                self.createRendererComponent(address);\n            });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n            // the list of child components that are responsible for address rendering\n            this.rendererComponents = {};\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initChildren: function () {\n            return this;\n        },\n\n        /**\n         * Create new component that will render given address in the address list\n         *\n         * @param {Object} address\n         */\n        createRendererComponent: function (address) {\n            var rendererTemplate, templateData, rendererComponent;\n\n            $.each(this.rendererComponents, function (index, component) {\n                component.visible(false);\n            });\n\n            if (this.rendererComponents[address.getType()]) {\n                this.rendererComponents[address.getType()].address(address);\n                this.rendererComponents[address.getType()].visible(true);\n            } else {\n                // rendererTemplates are provided via layout\n                rendererTemplate = address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined ? //eslint-disable-line\n                    utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()]) :\n                    defaultRendererTemplate;\n                templateData = {\n                    parentName: this.name,\n                    name: address.getType()\n                };\n\n                rendererComponent = utils.template(rendererTemplate, templateData);\n                utils.extend(\n                    rendererComponent,\n                    {\n                        address: ko.observable(address),\n                        visible: ko.observable(true)\n                    }\n                );\n                layout([rendererComponent]);\n                this.rendererComponents[address.getType()] = rendererComponent;\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information/address-renderer/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (Component, customerData) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information/address-renderer/default'\n        },\n\n        /**\n         * @param {*} countryId\n         * @return {String}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        }\n    });\n});\n","Magento_Checkout/js/view/payment/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/method-list',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'uiLayout',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'mage/translate',\n    'uiRegistry'\n], function (_, ko, utils, Component, paymentMethods, rendererList, layout, checkoutDataResolver, $t, registry) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/payment-methods/list',\n            visible: paymentMethods().length > 0,\n            configDefaultGroup: {\n                name: 'methodGroup',\n                component: 'Magento_Checkout/js/model/payment/method-group'\n            },\n            paymentGroupsList: [],\n            defaultGroupTitle: $t('Select a new payment method')\n        },\n\n        /**\n         * Initialize view.\n         *\n         * @returns {Component} Chainable.\n         */\n        initialize: function () {\n            this._super().initDefaulGroup().initChildren();\n            paymentMethods.subscribe(\n                function (changes) {\n                    checkoutDataResolver.resolvePaymentMethod();\n                    //remove renderer for \"deleted\" payment methods\n                    _.each(changes, function (change) {\n                        if (change.status === 'deleted') {\n                            this.removeRenderer(change.value.method);\n                        }\n                    }, this);\n                    //add renderer for \"added\" payment methods\n                    _.each(changes, function (change) {\n                        if (change.status === 'added') {\n                            this.createRenderer(change.value);\n                        }\n                    }, this);\n                }, this, 'arrayChange');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().\n                observe(['paymentGroupsList']);\n\n            return this;\n        },\n\n        /**\n         * Creates default group\n         *\n         * @returns {Component} Chainable.\n         */\n        initDefaulGroup: function () {\n            layout([\n                this.configDefaultGroup\n            ]);\n\n            return this;\n        },\n\n        /**\n         * Create renders for child payment methods.\n         *\n         * @returns {Component} Chainable.\n         */\n        initChildren: function () {\n            var self = this;\n\n            _.each(paymentMethods(), function (paymentMethodData) {\n                self.createRenderer(paymentMethodData);\n            });\n\n            return this;\n        },\n\n        /**\n         * @returns\n         */\n        createComponent: function (payment) {\n            var rendererTemplate,\n                rendererComponent,\n                templateData;\n\n            templateData = {\n                parentName: this.name,\n                name: payment.name\n            };\n            rendererTemplate = {\n                parent: '${ $.$data.parentName }',\n                name: '${ $.$data.name }',\n                displayArea: payment.displayArea,\n                component: payment.component\n            };\n            rendererComponent = utils.template(rendererTemplate, templateData);\n            utils.extend(rendererComponent, {\n                item: payment.item,\n                config: payment.config\n            });\n\n            return rendererComponent;\n        },\n\n        /**\n         * Create renderer.\n         *\n         * @param {Object} paymentMethodData\n         */\n        createRenderer: function (paymentMethodData) {\n            var isRendererForMethod = false,\n                currentGroup;\n\n            registry.get(this.configDefaultGroup.name, function (defaultGroup) {\n                _.each(rendererList(), function (renderer) {\n\n                    if (renderer.hasOwnProperty('typeComparatorCallback') &&\n                        typeof renderer.typeComparatorCallback == 'function'\n                    ) {\n                        isRendererForMethod = renderer.typeComparatorCallback(renderer.type, paymentMethodData.method);\n                    } else {\n                        isRendererForMethod = renderer.type === paymentMethodData.method;\n                    }\n\n                    if (isRendererForMethod) {\n                        currentGroup = renderer.group ? renderer.group : defaultGroup;\n\n                        this.collectPaymentGroups(currentGroup);\n\n                        layout([\n                            this.createComponent(\n                                {\n                                    config: renderer.config,\n                                    component: renderer.component,\n                                    name: renderer.type,\n                                    method: paymentMethodData.method,\n                                    item: paymentMethodData,\n                                    displayArea: currentGroup.displayArea\n                                }\n                            )]);\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Collects unique groups of available payment methods\n         *\n         * @param {Object} group\n         */\n        collectPaymentGroups: function (group) {\n            var groupsList = this.paymentGroupsList(),\n                isGroupExists = _.some(groupsList, function (existsGroup) {\n                    return existsGroup.alias === group.alias;\n                });\n\n            if (!isGroupExists) {\n                groupsList.push(group);\n                groupsList = _.sortBy(groupsList, function (existsGroup) {\n                    return existsGroup.sortOrder;\n                });\n                this.paymentGroupsList(groupsList);\n            }\n        },\n\n        /**\n         * Returns payment group title\n         *\n         * @param {Object} group\n         * @returns {String}\n         */\n        getGroupTitle: function (group) {\n            var title = group().title;\n\n            if (group().isDefault() && this.paymentGroupsList().length > 1) {\n                title = this.defaultGroupTitle;\n            }\n\n            return title + ':';\n        },\n\n        /**\n         * Checks if at least one payment method available\n         *\n         * @returns {String}\n         */\n        isPaymentMethodsAvailable: function () {\n            return _.some(this.paymentGroupsList(), function (group) {\n                return this.getRegion(group.displayArea)().length;\n            }, this);\n        },\n\n        /**\n         * Remove view renderer.\n         *\n         * @param {String} paymentMethodCode\n         */\n        removeRenderer: function (paymentMethodCode) {\n            var items;\n\n            _.each(this.paymentGroupsList(), function (group) {\n                items = this.getRegion(group.displayArea);\n\n                _.find(items(), function (value) {\n                    if (value.item.method.indexOf(paymentMethodCode) === 0) {\n                        value.disposeSubscriptions();\n                        value.destroy();\n                    }\n                });\n            }, this);\n        }\n    });\n});\n","Magento_Checkout/js/view/payment/email-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Checkout/js/model/customer-email-validator'\n    ],\n    function (Component, additionalValidators, agreementValidator) {\n        'use strict';\n\n        additionalValidators.registerValidator(agreementValidator);\n\n        return Component.extend({});\n    }\n);\n","Magento_Checkout/js/view/payment/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'uiComponent',\n    'Magento_Checkout/js/action/place-order',\n    'Magento_Checkout/js/action/select-payment-method',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'uiRegistry',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Ui/js/model/messages',\n    'uiLayout',\n    'Magento_Checkout/js/action/redirect-on-success'\n], function (\n    ko,\n    $,\n    Component,\n    placeOrderAction,\n    selectPaymentMethodAction,\n    quote,\n    customer,\n    paymentService,\n    checkoutData,\n    checkoutDataResolver,\n    registry,\n    additionalValidators,\n    Messages,\n    layout,\n    redirectOnSuccessAction\n) {\n    'use strict';\n\n    return Component.extend({\n        redirectAfterPlaceOrder: true,\n        isPlaceOrderActionAllowed: ko.observable(quote.billingAddress() != null),\n\n        /**\n         * After place order callback\n         */\n        afterPlaceOrder: function () {\n            // Override this function and put after place order logic here\n        },\n\n        /**\n         * Initialize view.\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            var billingAddressCode,\n                billingAddressData,\n                defaultAddressData;\n\n            this._super().initChildren();\n            quote.billingAddress.subscribe(function (address) {\n                this.isPlaceOrderActionAllowed(address !== null);\n            }, this);\n            checkoutDataResolver.resolveBillingAddress();\n\n            billingAddressCode = 'billingAddress' + this.getCode();\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                defaultAddressData = checkoutProvider.get(billingAddressCode);\n\n                if (defaultAddressData === undefined) {\n                    // Skip if payment does not have a billing address form\n                    return;\n                }\n                billingAddressData = checkoutData.getBillingAddressFromData();\n\n                if (billingAddressData) {\n                    checkoutProvider.set(\n                        billingAddressCode,\n                        $.extend(true, {}, defaultAddressData, billingAddressData)\n                    );\n                }\n                checkoutProvider.on(billingAddressCode, function (providerBillingAddressData) {\n                    checkoutData.setBillingAddressFromData(providerBillingAddressData);\n                }, billingAddressCode);\n            });\n\n            return this;\n        },\n\n        /**\n         * Initialize child elements\n         *\n         * @returns {Component} Chainable.\n         */\n        initChildren: function () {\n            this.messageContainer = new Messages();\n            this.createMessagesComponent();\n\n            return this;\n        },\n\n        /**\n         * Create child message renderer component\n         *\n         * @returns {Component} Chainable.\n         */\n        createMessagesComponent: function () {\n\n            var messagesComponent = {\n                parent: this.name,\n                name: this.name + '.messages',\n                displayArea: 'messages',\n                component: 'Magento_Ui/js/view/messages',\n                config: {\n                    messageContainer: this.messageContainer\n                }\n            };\n\n            layout([messagesComponent]);\n\n            return this;\n        },\n\n        /**\n         * Place order.\n         */\n        placeOrder: function (data, event) {\n            var self = this;\n\n            if (event) {\n                event.preventDefault();\n            }\n\n            if (this.validate() && additionalValidators.validate()) {\n                this.isPlaceOrderActionAllowed(false);\n\n                this.getPlaceOrderDeferredObject()\n                    .fail(\n                        function () {\n                            self.isPlaceOrderActionAllowed(true);\n                        }\n                    ).done(\n                        function () {\n                            self.afterPlaceOrder();\n\n                            if (self.redirectAfterPlaceOrder) {\n                                redirectOnSuccessAction.execute();\n                            }\n                        }\n                    );\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * @return {*}\n         */\n        getPlaceOrderDeferredObject: function () {\n            return $.when(\n                placeOrderAction(this.getData(), this.messageContainer)\n            );\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        selectPaymentMethod: function () {\n            selectPaymentMethodAction(this.getData());\n            checkoutData.setSelectedPaymentMethod(this.item.method);\n\n            return true;\n        },\n\n        isChecked: ko.computed(function () {\n            return quote.paymentMethod() ? quote.paymentMethod().method : null;\n        }),\n\n        isRadioButtonVisible: ko.computed(function () {\n            return paymentService.getAvailablePaymentMethods().length !== 1;\n        }),\n\n        /**\n         * Get payment method data\n         */\n        getData: function () {\n            return {\n                'method': this.item.method,\n                'po_number': null,\n                'additional_data': null\n            };\n        },\n\n        /**\n         * Get payment method type.\n         */\n        getTitle: function () {\n            return this.item.title;\n        },\n\n        /**\n         * Get payment method code.\n         */\n        getCode: function () {\n            return this.item.method;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        validate: function () {\n            return true;\n        },\n\n        /**\n         * @return {String}\n         */\n        getBillingAddressFormName: function () {\n            return 'billing-address-form-' + this.item.method;\n        },\n\n        /**\n         * Dispose billing address subscriptions\n         */\n        disposeSubscriptions: function () {\n            // dispose all active subscriptions\n            var billingAddressCode = 'billingAddress' + this.getCode();\n\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                checkoutProvider.off(billingAddressCode);\n            });\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/grand-total'\n        },\n\n        /**\n         * @return {*}\n         */\n        isDisplayed: function () {\n            return this.isFullMode();\n        },\n\n        /**\n         * Get pure value.\n         */\n        getPureValue: function () {\n            var totals = quote.getTotals()();\n\n            if (totals) {\n                return totals['grand_total'];\n            }\n\n            return quote['grand_total'];\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/subtotal'\n        },\n\n        /**\n         * Get pure value.\n         *\n         * @return {*}\n         */\n        getPureValue: function () {\n            var totals = quote.getTotals()();\n\n            if (totals) {\n                return totals.subtotal;\n            }\n\n            return quote.subtotal;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n\n    });\n});\n","Magento_Checkout/js/view/summary/cart-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/totals',\n    'uiComponent',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/model/quote'\n], function (ko, totals, Component, stepNavigator, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/cart-items'\n        },\n        totals: totals.totals(),\n        items: ko.observable([]),\n        maxCartItemsToDisplay: window.checkoutConfig.maxCartItemsToDisplay,\n        cartUrl: window.checkoutConfig.cartUrl,\n\n        /**\n         * @deprecated Please use observable property (this.items())\n         */\n        getItems: totals.getItems(),\n\n        /**\n         * Returns cart items qty\n         *\n         * @returns {Number}\n         */\n        getItemsQty: function () {\n            return parseFloat(this.totals['items_qty']);\n        },\n\n        /**\n         * Returns count of cart line items\n         *\n         * @returns {Number}\n         */\n        getCartLineItemsCount: function () {\n            return parseInt(totals.getItems()().length, 10);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n            // Set initial items to observable field\n            this.setItems(totals.getItems()());\n            // Subscribe for items data changes and refresh items in view\n            totals.getItems().subscribe(function (items) {\n                this.setItems(items);\n            }.bind(this));\n        },\n\n        /**\n         * Set items to observable field\n         *\n         * @param {Object} items\n         */\n        setItems: function (items) {\n            if (items && items.length > 0) {\n                items = items.slice(parseInt(-this.maxCartItemsToDisplay, 10));\n            }\n            this.items(items);\n        },\n\n        /**\n         * Returns bool value for items block state (expanded or not)\n         *\n         * @returns {*|Boolean}\n         */\n        isItemsBlockExpanded: function () {\n            return quote.isVirtual() || stepNavigator.isProcessed('shipping');\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/abstract-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/step-navigator'\n], function (Component, quote, priceUtils, totals, stepNavigator) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            return priceUtils.formatPrice(price, quote.getPriceFormat());\n        },\n\n        /**\n         * @return {*}\n         */\n        getTotals: function () {\n            return totals.totals();\n        },\n\n        /**\n         * @return {*}\n         */\n        isFullMode: function () {\n            if (!this.getTotals()) {\n                return false;\n            }\n\n            return stepNavigator.isProcessed('shipping');\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function ($, Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/shipping'\n        },\n        quoteIsVirtual: quote.isVirtual(),\n        totals: quote.getTotals(),\n\n        /**\n         * @return {*}\n         */\n        getShippingMethodTitle: function () {\n            var shippingMethod;\n\n            if (!this.isCalculated()) {\n                return '';\n            }\n            shippingMethod = quote.shippingMethod();\n\n            return shippingMethod ? shippingMethod['carrier_title'] + ' - ' + shippingMethod['method_title'] : '';\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && quote.shippingMethod() != null; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*}\n         */\n        getValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price =  this.totals()['shipping_amount'];\n\n            return this.getFormattedPrice(price);\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @return {*}\n         */\n        isDisplayed: function () {\n            return this.isFullMode();\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/item/details.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/item/details'\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {String}\n         */\n        getValue: function (quoteItem) {\n            return quoteItem.name;\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/item/details/thumbnail.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['uiComponent'], function (Component) {\n    'use strict';\n\n    var imageData = window.checkoutConfig.imageData;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/summary/item/details/thumbnail'\n        },\n        displayArea: 'before_details',\n        imageData: imageData,\n\n        /**\n         * @param {Object} item\n         * @return {Array}\n         */\n        getImageItem: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']];\n            }\n\n            return [];\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getSrc: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].src;\n            }\n\n            return null;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getWidth: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].width;\n            }\n\n            return null;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getHeight: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].height;\n            }\n\n            return null;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {null}\n         */\n        getAlt: function (item) {\n            if (this.imageData[item['item_id']]) {\n                return this.imageData[item['item_id']].alt;\n            }\n\n            return null;\n        }\n    });\n});\n","Magento_Checkout/js/view/summary/item/details/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total'\n], function (viewModel) {\n    'use strict';\n\n    return viewModel.extend({\n        defaults: {\n            displayArea: 'after_details',\n            template: 'Magento_Checkout/summary/item/details/subtotal'\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValue: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total']);\n        }\n    });\n});\n","Magento_Paypal/order-review.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate',\n    'mage/mage',\n    'mage/validation'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.orderReview', {\n        options: {\n            orderReviewSubmitSelector: '#review-button',\n            shippingSelector: '#shipping_method',\n            shippingSubmitFormSelector: null,\n            updateOrderSelector: '#update-order',\n            billingAsShippingSelector: '#billing\\\\:as_shipping',\n            updateContainerSelector: '#details-reload',\n            waitLoadingContainer: '#review-please-wait',\n            shippingMethodContainer: '#shipping-method-container',\n            agreementSelector: 'div.checkout-agreements input',\n            isAjax: false,\n            updateShippingMethodSubmitSelector: '#update-shipping-method-submit',\n            reviewSubmitSelector: '#review-submit',\n            shippingMethodUpdateUrl: null,\n            updateOrderSubmitUrl: null,\n            canEditShippingMethod: false\n        },\n\n        /**\n         * Widget instance properties\n         */\n        triggerPropertyChange: true,\n        isShippingSubmitForm: false,\n\n        /** @inheritdoc */\n        _create: function () {\n            var isDisable;\n\n            //change handler for ajaxEnabled\n            if (this.options.isAjax) {\n                this._submitOrder = this._ajaxSubmitOrder;\n            }\n\n            this.element.on('click', this.options.orderReviewSubmitSelector, $.proxy(this._submitOrder, this))\n                .on('click', this.options.billingAsShippingSelector, $.proxy(this._shippingTobilling, this))\n                .on('change',\n                    this.options.shippingSelector,\n                    $.proxy(this._submitUpdateOrder,\n                        this,\n                        this.options.updateOrderSubmitUrl,\n                        this.options.updateContainerSelector\n                    )\n                ).find(this.options.updateOrderSelector).on('click', $.proxy(this._updateOrderHandler, this)).end()\n                .find(this.options.updateShippingMethodSubmitSelector).hide().end()\n                .find(this.options.reviewSubmitSelector).hide();\n            this._shippingTobilling();\n\n            if ($(this.options.shippingSubmitFormSelector).length && this.options.canEditShippingMethod) {\n                this.isShippingSubmitForm = true;\n                $(this.options.shippingSubmitFormSelector)\n                    .find(this.options.updateShippingMethodSubmitSelector).hide().end()\n                    .on('change',\n                        this.options.shippingSelector,\n                        $.proxy(\n                            this._submitUpdateOrder,\n                            this,\n                            $(this.options.shippingSubmitFormSelector).prop('action'),\n                            this.options.updateContainerSelector\n                        )\n                    );\n                this._updateOrderSubmit(!$(this.options.shippingSubmitFormSelector)\n                    .find(this.options.shippingSelector).val());\n            } else {\n                isDisable = this.isShippingSubmitForm && this.element.find(this.options.shippingSelector).val();\n                this.element\n                    .on('input propertychange', ':input[name]',\n                        $.proxy(this._updateOrderSubmit, this, isDisable, this._onShippingChange)\n                    ).find('select').not(this.options.shippingSelector).on('change', this._propertyChange);\n                this._updateOrderSubmit(isDisable);\n            }\n        },\n\n        /**\n         * show ajax loader\n         */\n        _ajaxBeforeSend: function () {\n            this.element.find(this.options.waitLoadingContainer).show();\n        },\n\n        /**\n         * hide ajax loader\n         */\n        _ajaxComplete: function () {\n            this.element.find(this.options.waitLoadingContainer).hide();\n        },\n\n        /**\n         * trigger propertychange for input type select\n         */\n        _propertyChange: function () {\n            $(this).trigger('propertychange');\n        },\n\n        /**\n         * trigger change for the update of shippping methods from server\n         */\n        _updateOrderHandler: function () {\n            $(this.options.shippingSelector).trigger('change');\n        },\n\n        /**\n         * Attempt to submit order\n         */\n        _submitOrder: function () {\n            if (this._validateForm()) {\n                this.element.find(this.options.updateOrderSelector).fadeTo(0, 0.5)\n                    .end().find(this.options.waitLoadingContainer).show()\n                    .end().submit();\n                this._updateOrderSubmit(true);\n            }\n        },\n\n        /**\n         * Attempt to ajax submit order\n         */\n        _ajaxSubmitOrder: function () {\n            if (this.element.find(this.options.waitLoadingContainer).is(':visible')) {\n                return false;\n            }\n            $.ajax({\n                url: this.element.prop('action'),\n                type: 'post',\n                context: this,\n                data: {\n                    isAjax: 1\n                },\n                dataType: 'json',\n                beforeSend: this._ajaxBeforeSend,\n                complete: this._ajaxComplete,\n\n                /** @inheritdoc */\n                success: function (response) {\n                    var msg;\n\n                    if ($.type(response) === 'object' && !$.isEmptyObject(response)) {\n                        if (response['error_messages']) {\n                            this._ajaxComplete();\n                            msg = response['error_messages'];\n\n                            /* eslint-disable max-depth */\n                            if (msg) {\n                                if ($.type(msg) === 'array') {\n                                    msg = msg.join('\\n');\n                                }\n                            }\n\n                            /* eslint-enablemax-depth */\n                            alert({\n                                content: msg\n                            });\n\n                            return false;\n                        }\n\n                        if (response.redirect) {\n                            $.mage.redirect(response.redirect);\n\n                            return false;\n                        } else if (response.success) {\n                            $.mage.redirect(this.options.successUrl);\n\n                            return false;\n                        }\n                        this._ajaxComplete();\n                        alert({\n                            content: $.mage.__('Sorry, something went wrong.')\n                        });\n                    }\n                },\n\n                /** @inheritdoc */\n                error: function () {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    this._ajaxComplete();\n                }\n            });\n        },\n\n        /**\n         * Validate Order form\n         */\n        _validateForm: function () {\n            this.element.find(this.options.agreementSelector).off('change').on('change', $.proxy(function () {\n                var isValid = this._validateForm();\n\n                this._updateOrderSubmit(!isValid);\n            }, this));\n\n            if (this.element.data('mageValidation')) {\n                return this.element.validation().valid();\n            }\n\n            return true;\n        },\n\n        /**\n         * Check/Set whether order can be submitted\n         * Also disables form submission element, if any\n         * @param {*} shouldDisable - whether should prevent order submission explicitly\n         * @param {Function} [fn] - function for shipping change handler\n         * @param {*} [*] - if true the property change will be set to true\n         */\n        _updateOrderSubmit: function (shouldDisable, fn) {\n            this._toggleButton(this.options.orderReviewSubmitSelector, shouldDisable);\n\n            if ($.type(fn) === 'function') {\n                fn.call(this);\n            }\n        },\n\n        /**\n         * Enable/Disable button\n         * @param {jQuery} button - button selector to be toggled\n         * @param {*} disable - boolean for toggling\n         */\n        _toggleButton: function (button, disable) {\n            $(button).prop({\n                'disabled': disable\n            }).toggleClass('no-checkout', disable).fadeTo(0, disable ? 0.5 : 1);\n        },\n\n        /**\n         * Copy element value from shipping to billing address\n         * @param {jQuery.Event} e - optional\n         */\n        _shippingTobilling: function (e) {\n            var isChecked, opacity;\n\n            if (this.options.shippingSubmitFormSelector) {\n                return false;\n            }\n            isChecked = $(this.options.billingAsShippingSelector).is(':checked');\n            opacity = isChecked ? 0.5 : 1;\n\n            if (isChecked) {\n                this.element.validation('clearError', ':input[name^=\"billing\"]');\n            }\n            $(':input[name^=\"shipping\"]', this.element).each($.proxy(function (key, value) {\n                var fieldObj = $(value.id.replace('shipping:', '#billing\\\\:'));\n\n                if (isChecked) {\n                    fieldObj = fieldObj.val($(value).val());\n                }\n                fieldObj.prop({\n                    'readonly': isChecked,\n                    'disabled': isChecked\n                }).fadeTo(0, opacity);\n\n                if (fieldObj.is('select')) {\n                    this.triggerPropertyChange = false;\n                    fieldObj.trigger('change');\n                }\n            }, this));\n\n            if (isChecked || e) {\n                this._updateOrderSubmit(true);\n            }\n            this.triggerPropertyChange = true;\n        },\n\n        /**\n         * Dispatch an ajax request of Update Order submission\n         * @param {*} url - url where to submit shipping method\n         * @param {*} resultId - id of element to be updated\n         */\n        _submitUpdateOrder: function (url, resultId) {\n            var isChecked, formData, callBackResponseHandler, shippingMethod;\n\n            if (this.element.find(this.options.waitLoadingContainer).is(':visible')) {\n                return false;\n            }\n            isChecked = $(this.options.billingAsShippingSelector).is(':checked');\n            formData = null;\n            callBackResponseHandler = null;\n            shippingMethod = $.trim($(this.options.shippingSelector).val());\n            this._shippingTobilling();\n\n            if (url && resultId && shippingMethod) {\n                this._updateOrderSubmit(true);\n                this._toggleButton(this.options.updateOrderSelector, true);\n\n                // form data and callBack updated based on the shippping Form element\n                if (this.isShippingSubmitForm) {\n                    formData = $(this.options.shippingSubmitFormSelector).serialize() + '&isAjax=true';\n\n                    /**\n                     * @param {Object} response\n                     */\n                    callBackResponseHandler = function (response) {\n                        $(resultId).html(response);\n                        this._updateOrderSubmit(false);\n                        this._ajaxComplete();\n                    };\n                } else {\n                    formData = this.element.serialize() + '&isAjax=true';\n\n                    /**\n                     * @param {Object} response\n                     */\n                    callBackResponseHandler = function (response) {\n                        $(resultId).html(response);\n                        this._ajaxShippingUpdate(shippingMethod);\n                    };\n                }\n\n                if (isChecked) {\n                    $(this.options.shippingSelect).prop('disabled', true);\n                }\n                $.ajax({\n                    url: url,\n                    type: 'post',\n                    context: this,\n                    beforeSend: this._ajaxBeforeSend,\n                    data: formData,\n                    success: callBackResponseHandler\n                });\n            }\n        },\n\n        /**\n         * Update Shipping Methods Element from server\n         * @param {*} shippingMethod\n         */\n        _ajaxShippingUpdate: function (shippingMethod) {\n            $.ajax({\n                url: this.options.shippingMethodUpdateUrl,\n                data: {\n                    isAjax: true,\n                    'shipping_method': shippingMethod\n                },\n                type: 'post',\n                context: this,\n\n                /** @inheritdoc */\n                success: function (response) {\n                    $(this.options.shippingMethodContainer).parent().html(response);\n                    this._toggleButton(this.options.updateOrderSelector, false);\n                    this._updateOrderSubmit(false);\n                },\n                complete: this._ajaxComplete\n            });\n        },\n\n        /**\n         * Actions on change Shipping Address data\n         */\n        _onShippingChange: function () {\n            if (this.triggerPropertyChange && $.trim($(this.options.shippingSelector).val())) {\n                this.element.find(this.options.shippingSelector).hide().end()\n                    .find(this.options.shippingSelector + '_update').show();\n            }\n        }\n    });\n\n    return $.mage.orderReview;\n});\n","Magento_Paypal/js/paypal-checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data',\n    'jquery/ui',\n    'mage/mage'\n], function ($, confirm, customerData) {\n    'use strict';\n\n    $.widget('mage.paypalCheckout', {\n        options: {\n            originalForm:\n                'form:not(#product_addtocart_form_from_popup):has(input[name=\"product\"][value=%1])',\n            productId: 'input[type=\"hidden\"][name=\"product\"]',\n            ppCheckoutSelector: '[data-role=pp-checkout-url]',\n            ppCheckoutInput: '<input type=\"hidden\" data-role=\"pp-checkout-url\" name=\"return_url\" value=\"\"/>'\n        },\n\n        /**\n         * Initialize store credit events\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', '[data-action=\"checkout-form-submit\"]', $.proxy(function (e) {\n                var $target = $(e.target),\n                    returnUrl = $target.data('checkout-url'),\n                    productId = $target.closest('form').find(this.options.productId).val(),\n                    originalForm = this.options.originalForm.replace('%1', productId),\n                    self = this,\n                    billingAgreement = customerData.get('paypal-billing-agreement');\n\n                e.preventDefault();\n\n                if (billingAgreement().askToCreate) {\n                    confirm({\n                        content: billingAgreement().confirmMessage,\n                        actions: {\n\n                            /**\n                             * Confirmation handler\n                             *\n                             */\n                            confirm: function () {\n                                returnUrl = billingAgreement().confirmUrl;\n                                self._redirect(returnUrl, originalForm);\n                            },\n\n                            /**\n                             * Cancel confirmation handler\n                             *\n                             */\n                            cancel: function (event) {\n                                if (event && !$(event.target).hasClass('action-close')) {\n                                    self._redirect(returnUrl);\n                                }\n                            }\n                        }\n                    });\n                } else {\n                    this._redirect(returnUrl, originalForm);\n                }\n            }, this));\n        },\n\n        /**\n         * Redirect to certain url, with optional form\n         * @param {String} returnUrl\n         * @param {HTMLElement} originalForm\n         *\n         */\n        _redirect: function (returnUrl, originalForm) {\n            var $form,\n                ppCheckoutInput;\n\n            if (this.options.isCatalogProduct) {\n                // find the form from which the button was clicked\n                $form = originalForm ? $(originalForm) : $($(this.options.shortcutContainerClass).closest('form'));\n\n                ppCheckoutInput = $form.find(this.options.ppCheckoutSelector)[0];\n\n                if (!ppCheckoutInput) {\n                    ppCheckoutInput = $(this.options.ppCheckoutInput);\n                    ppCheckoutInput.appendTo($form);\n                }\n                $(ppCheckoutInput).val(returnUrl);\n\n                $form.submit();\n            } else {\n                $.mage.redirect(returnUrl);\n            }\n        }\n    });\n\n    return $.mage.paypalCheckout;\n});\n","Magento_Paypal/js/model/iframe-redirect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Paypal/js/model/iframe',\n    'Magento_Ui/js/model/messageList'\n],\nfunction (ko, iframe, messageList) {\n    'use strict';\n\n    return function (cartUrl, errorMessage, goToSuccessPage, successUrl) {\n        if (this === window.self) {\n            window.location = cartUrl;\n        }\n\n        if (!!errorMessage.message) { //eslint-disable-line no-extra-boolean-cast\n            document.removeEventListener('click', iframe.stopEventPropagation, true);\n            iframe.isInAction(false);\n            messageList.addErrorMessage(errorMessage);\n        } else if (!!goToSuccessPage) { //eslint-disable-line no-extra-boolean-cast\n            window.location = successUrl;\n        } else {\n            window.location = cartUrl;\n        }\n    };\n});\n","Magento_Paypal/js/model/iframe.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['ko'], function (ko) {\n    'use strict';\n\n    var isInAction = ko.observable(false);\n\n    return {\n        isInAction: isInAction,\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        stopEventPropagation: function (event) {\n            event.stopImmediatePropagation();\n            event.preventDefault();\n        }\n    };\n});\n","Magento_Paypal/js/action/set-payment-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'mage/storage',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, quote, urlBuilder, storage, errorProcessor, customer, fullScreenLoader) {\n    'use strict';\n\n    return function (messageContainer) {\n        var serviceUrl,\n            payload,\n            paymentData = quote.paymentMethod();\n\n        /**\n         * Checkout for guest and registered customer.\n         */\n        if (!customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/set-payment-information', {\n                cartId: quote.getQuoteId()\n            });\n            payload = {\n                cartId: quote.getQuoteId(),\n                email: quote.guestEmail,\n                paymentMethod: paymentData\n            };\n        } else {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/set-payment-information', {});\n            payload = {\n                cartId: quote.getQuoteId(),\n                paymentMethod: paymentData\n            };\n        }\n        fullScreenLoader.startLoader();\n\n        return storage.post(\n            serviceUrl, JSON.stringify(payload)\n        ).fail(function (response) {\n            errorProcessor.process(response, messageContainer);\n        }).always(function () {\n            fullScreenLoader.stopLoader();\n        });\n    };\n});\n","Magento_Paypal/js/view/review/actions/iframe.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'uiComponent',\n    'ko',\n    'Magento_Paypal/js/model/iframe'\n], function (Component, ko, iframe) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/review/actions/iframe'\n        },\n\n        /**\n         * @return {*}\n         */\n        getCode: function () {\n            return this.index;\n        },\n\n        /**\n         * @return {String}\n         */\n        getActionUrl: function () {\n            return this.isInAction() ? window.checkoutConfig.payment.paypalIframe.actionUrl[this.getCode()] : '';\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        afterSave: function () {\n            iframe.setIsInAction(true);\n\n            return false;\n        },\n\n        /**\n         * @return {*}\n         */\n        isInAction: function () {\n            return iframe.getIsInAction()();\n        },\n\n        /**\n         * @param {Object} context\n         * @return {Function}\n         */\n        placeOrder: function (context) {\n            return context.placeOrder.bind(context, this.afterSave);\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/paypal-payments.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    var isContextCheckout = window.checkoutConfig.payment.paypalExpress.isContextCheckout,\n        paypalExpress = 'Magento_Paypal/js/view/payment/method-renderer' +\n            (isContextCheckout ? '/in-context/checkout-express' : '/paypal-express');\n\n    rendererList.push(\n        {\n            type: 'paypal_express',\n            component: paypalExpress,\n            config: window.checkoutConfig.payment.paypalExpress.inContextConfig\n        },\n        {\n            type: 'paypal_express_bml',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/paypal-express-bml'\n        },\n        {\n            type: 'payflow_express',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/payflow-express'\n        },\n        {\n            type: 'payflow_express_bml',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/payflow-express-bml'\n        },\n        {\n            type: 'payflowpro',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method'\n        },\n        {\n            type: 'payflow_link',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n        },\n        {\n            type: 'payflow_advanced',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n        },\n        {\n            type: 'hosted_pro',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n        },\n        {\n            type: 'paypal_billing_agreement',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/paypal-billing-agreement'\n        }\n    );\n\n    /**\n     * Add view logic here if needed\n     **/\n    return Component.extend({});\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflow-express.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/payflow-express'\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express-bml.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/paypal-express-bml'\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Paypal/js/action/set-payment-method',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/customer-data'\n], function ($, Component, setPaymentMethodAction, additionalValidators, quote, customerData) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/paypal-express-bml',\n            billingAgreement: ''\n        },\n\n        /** Init observable variables */\n        initObservable: function () {\n            this._super()\n                .observe('billingAgreement');\n\n            return this;\n        },\n\n        /** Open window with  */\n        showAcceptanceWindow: function (data, event) {\n            window.open(\n                $(event.currentTarget).attr('href'),\n                'olcwhatispaypal',\n                'toolbar=no, location=no,' +\n                ' directories=no, status=no,' +\n                ' menubar=no, scrollbars=yes,' +\n                ' resizable=yes, ,left=0,' +\n                ' top=0, width=400, height=350'\n            );\n\n            return false;\n        },\n\n        /** Returns payment acceptance mark link path */\n        getPaymentAcceptanceMarkHref: function () {\n            return window.checkoutConfig.payment.paypalExpress.paymentAcceptanceMarkHref;\n        },\n\n        /** Returns payment acceptance mark image path */\n        getPaymentAcceptanceMarkSrc: function () {\n            return window.checkoutConfig.payment.paypalExpress.paymentAcceptanceMarkSrc;\n        },\n\n        /** Returns billing agreement data */\n        getBillingAgreementCode: function () {\n            return window.checkoutConfig.payment.paypalExpress.billingAgreementCode[this.item.method];\n        },\n\n        /** Returns payment information data */\n        getData: function () {\n            var parent = this._super(),\n                additionalData = null;\n\n            if (this.getBillingAgreementCode()) {\n                additionalData = {};\n                additionalData[this.getBillingAgreementCode()] = this.billingAgreement();\n            }\n\n            return $.extend(true, parent, {\n                'additional_data': additionalData\n            });\n        },\n\n        /** Redirect to paypal */\n        continueToPayPal: function () {\n            if (additionalValidators.validate()) {\n                //update payment method information if additional data was changed\n                this.selectPaymentMethod();\n                setPaymentMethodAction(this.messageContainer).done(\n                    function () {\n                        customerData.invalidate(['cart']);\n                        $.mage.redirect(\n                            window.checkoutConfig.payment.paypalExpress.redirectUrl[quote.paymentMethod().method]\n                        );\n                    }\n                );\n\n                return false;\n            }\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/paypal-express'\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/paypal-billing-agreement.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/payment/default',\n    'mage/validation'\n], function ($, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/paypal_billing_agreement-form',\n            selectedBillingAgreement: ''\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('selectedBillingAgreement');\n\n            return this;\n        },\n\n        /**\n         * @return {*}\n         */\n        getTransportName: function () {\n            return window.checkoutConfig.payment.paypalBillingAgreement.transportName;\n        },\n\n        /**\n         * @return {*}\n         */\n        getBillingAgreements: function () {\n            return window.checkoutConfig.payment.paypalBillingAgreement.agreements;\n        },\n\n        /**\n         * @return {Object}\n         */\n        getData: function () {\n            var additionalData = null;\n\n            if (this.getTransportName()) {\n                additionalData = {};\n                additionalData[this.getTransportName()] = this.selectedBillingAgreement();\n            }\n\n            return {\n                'method': this.item.method,\n                'additional_data': additionalData\n            };\n        },\n\n        /**\n         * @return {jQuery}\n         */\n        validate: function () {\n            var form = '#billing-agreement-form';\n\n            return $(form).validation() && $(form).validation('isValid');\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflowpro-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Payment/js/view/payment/iframe',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Vault/js/view/payment/vault-enabler'\n], function ($, Component, additionalValidators, setPaymentInformationAction, fullScreenLoader, VaultEnabler) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/payflowpro-form'\n        },\n        placeOrderHandler: null,\n        validateHandler: null,\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * @param {Function} handler\n         */\n        setPlaceOrderHandler: function (handler) {\n            this.placeOrderHandler = handler;\n        },\n\n        /**\n         * @param {Function} handler\n         */\n        setValidateHandler: function (handler) {\n            this.validateHandler = handler;\n        },\n\n        /**\n         * @returns {Object}\n         */\n        context: function () {\n            return this;\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        isShowLegend: function () {\n            return true;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'payflowpro';\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            return true;\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            var self = this;\n\n            if (this.validateHandler() && additionalValidators.validate()) {\n                this.isPlaceOrderActionAllowed(false);\n                fullScreenLoader.startLoader();\n                $.when(\n                    setPaymentInformationAction(this.messageContainer, self.getData())\n                ).done(\n                    function () {\n                        self.placeOrderHandler().fail(\n                            function () {\n                                fullScreenLoader.stopLoader();\n                            }\n                        );\n                    }\n                ).always(\n                    function () {\n                        self.isPlaceOrderActionAllowed(true);\n                        fullScreenLoader.stopLoader();\n                    }\n                );\n            }\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'cc_type': this.creditCardType(),\n                    'cc_exp_year': this.creditCardExpYear(),\n                    'cc_exp_month': this.creditCardExpMonth(),\n                    'cc_last_4': this.creditCardNumber().substr(-4)\n                }\n            };\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * @returns {Bool}\n         */\n        isVaultEnabled: function () {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return 'payflowpro_cc_vault';\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflow-express-bml.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/payflow-express-bml'\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/iframe-methods.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'ko',\n    'Magento_Paypal/js/model/iframe',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function (Component, ko, iframe, fullScreenLoader) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/iframe-methods',\n            paymentReady: false\n        },\n        redirectAfterPlaceOrder: false,\n        isInAction: iframe.isInAction,\n\n        /**\n         * @return {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe('paymentReady');\n\n            return this;\n        },\n\n        /**\n         * @return {*}\n         */\n        isPaymentReady: function () {\n            return this.paymentReady();\n        },\n\n        /**\n         * Get action url for payment method iframe.\n         * @returns {String}\n         */\n        getActionUrl: function () {\n            return this.isInAction() ? window.checkoutConfig.payment.paypalIframe.actionUrl[this.getCode()] : '';\n        },\n\n        /**\n         * Places order in pending payment status.\n         */\n        placePendingPaymentOrder: function () {\n            if (this.placeOrder()) {\n                fullScreenLoader.startLoader();\n                this.isInAction(true);\n                // capture all click events\n                document.addEventListener('click', iframe.stopEventPropagation, true);\n            }\n        },\n\n        /**\n         * @return {*}\n         */\n        getPlaceOrderDeferredObject: function () {\n            var self = this;\n\n            return this._super().fail(function () {\n                fullScreenLoader.stopLoader();\n                self.isInAction(false);\n                document.removeEventListener('click', iframe.stopEventPropagation, true);\n            });\n        },\n\n        /**\n         * After place order callback\n         */\n        afterPlaceOrder: function () {\n            if (this.iframeIsLoaded) {\n                document.getElementById(this.getCode() + '-iframe')\n                    .contentWindow.location.reload();\n            }\n\n            this.paymentReady(true);\n            this.iframeIsLoaded = true;\n            this.isPlaceOrderActionAllowed(true);\n            fullScreenLoader.stopLoader();\n        },\n\n        /**\n         * Hide loader when iframe is fully loaded.\n         */\n        iframeLoaded: function () {\n            fullScreenLoader.stopLoader();\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflowpro/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'Magento_Vault/js/view/payment/method-renderer/vault'\n], function ($, VaultComponent) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'Magento_Vault/payment/form'\n        },\n\n        /**\n         * @returns {String}\n         */\n        getToken: function () {\n            return this.publicHash;\n        },\n\n        /**\n         * Get last 4 digits of card\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details['cc_last_4'];\n        },\n\n        /**\n         * Get expiration date\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details['cc_exp_month'] + '/' + this.details['cc_exp_year'];\n        },\n\n        /**\n         * Get card type\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details['cc_type'];\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/in-context/checkout-express.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract',\n        'Magento_Paypal/js/action/set-payment-method',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Ui/js/lib/view/utils/dom-observer',\n        'paypalInContextExpressCheckout',\n        'Magento_Customer/js/customer-data',\n        'Magento_Ui/js/model/messageList'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        setPaymentMethodAction,\n        additionalValidators,\n        domObserver,\n        paypalExpressCheckout,\n        customerData,\n        messageList\n    ) {\n        'use strict';\n\n        // State of PayPal module initialization\n        var clientInit = false;\n\n        return Component.extend({\n\n            defaults: {\n                template: 'Magento_Paypal/payment/paypal-express-in-context',\n                clientConfig: {\n                    /**\n                     * @param {Object} event\n                     */\n                    click: function (event) {\n                        event.preventDefault();\n\n                        if (additionalValidators.validate()) {\n                            paypalExpressCheckout.checkout.initXO();\n\n                            this.selectPaymentMethod();\n                            setPaymentMethodAction(this.messageContainer).done(function () {\n                                $('body').trigger('processStart');\n\n                                $.getJSON(this.path, {\n                                    button: 0\n                                }).done(function (response) {\n                                    var message = response && response.message;\n\n                                    if (message) {\n                                        if (message.type === 'error') {\n                                            messageList.addErrorMessage({\n                                                message: message.text\n                                            });\n                                        } else {\n                                            messageList.addSuccessMessage({\n                                                message: message.text\n                                            });\n                                        }\n                                    }\n\n                                    if (response && response.url) {\n                                        paypalExpressCheckout.checkout.startFlow(response.url);\n\n                                        return;\n                                    }\n\n                                    paypalExpressCheckout.checkout.closeFlow();\n                                }).fail(function () {\n                                    paypalExpressCheckout.checkout.closeFlow();\n                                }).always(function () {\n                                    $('body').trigger('processStop');\n                                    customerData.invalidate(['cart']);\n                                });\n                            }.bind(this)).fail(function () {\n                                paypalExpressCheckout.checkout.closeFlow();\n                            });\n                        }\n                    }\n                }\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n                this.initClient();\n\n                return this;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initClient: function () {\n                var selector = '#' + this.getButtonId();\n\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n\n                if (!clientInit) {\n                    domObserver.get(selector, function () {\n                        paypalExpressCheckout.checkout.setup(this.merchantId, this.clientConfig);\n                        clientInit = true;\n                        domObserver.off(selector);\n                    }.bind(this));\n                } else {\n                    domObserver.get(selector, function () {\n                        $(selector).on('click', this.clientConfig.click);\n                        domObserver.off(selector);\n                    }.bind(this));\n                }\n\n                return this;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getButtonId: function () {\n                return this.inContextId;\n            }\n        });\n    }\n);\n","Magento_Paypal/js/in-context/billing-agreement.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data'\n], function ($, confirm, customerData) {\n    'use strict';\n\n    $.widget('mage.billingAgreement', {\n        options: {\n            invalidateOnLoad: false,\n            cancelButtonSelector: '.block-billing-agreements-view button.cancel',\n            cancelMessage: '',\n            cancelUrl: ''\n        },\n\n        /**\n         * Initialize billing agreements events\n         * @private\n         */\n        _create: function () {\n            var self = this;\n\n            if (this.options.invalidateOnLoad) {\n                this.invalidate();\n            }\n            $(this.options.cancelButtonSelector).on('click', function () {\n                confirm({\n                    content: self.options.cancelMessage,\n                    actions: {\n                        /**\n                         * 'Confirm' action handler.\n                         */\n                        confirm: function () {\n                            self.invalidate();\n                            window.location.href = self.options.cancelUrl;\n                        }\n                    }\n                });\n\n                return false;\n            });\n        },\n\n        /**\n         * clear paypal billing agreement customer data\n         * @returns void\n         */\n        invalidate: function () {\n            customerData.invalidate(['paypal-billing-agreement']);\n        }\n    });\n\n    return $.mage.billingAgreement;\n});\n","Magento_Paypal/js/in-context/express-checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    'uiComponent',\n    'paypalInContextExpressCheckout',\n    'Magento_Customer/js/customer-data',\n    'domReady!'\n], function (_, $, Component, paypalExpressCheckout, customerData) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            clientConfig: {\n\n                checkoutInited: false,\n\n                /**\n                 * @param {Object} event\n                 */\n                click: function (event) {\n                    $('body').trigger('processStart');\n\n                    event.preventDefault();\n\n                    if (!this.clientConfig.checkoutInited) {\n                        paypalExpressCheckout.checkout.initXO();\n                        this.clientConfig.checkoutInited = true;\n                    } else {\n                        paypalExpressCheckout.checkout.closeFlow();\n                    }\n\n                    $.getJSON(this.path, {\n                        button: 1\n                    }).done(function (response) {\n                        var message = response && response.message;\n\n                        if (message) {\n                            customerData.set('messages', {\n                                messages: [message]\n                            });\n                        }\n\n                        if (response && response.url) {\n                            paypalExpressCheckout.checkout.startFlow(response.url);\n\n                            return;\n                        }\n\n                        paypalExpressCheckout.checkout.closeFlow();\n                    }).fail(function () {\n                        paypalExpressCheckout.checkout.closeFlow();\n                    }).always(function () {\n                        $('body').trigger('processStop');\n                        customerData.invalidate(['cart']);\n                    });\n                }\n            }\n        },\n\n        /**\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n\n            return this.initClient();\n        },\n\n        /**\n         * @returns {Object}\n         */\n        initClient: function () {\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n\n            paypalExpressCheckout.checkout.setup(this.merchantId, this.clientConfig);\n\n            return this;\n        }\n    });\n});\n","Magento_Paypal/js/in-context/button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'jquery',\n        'domReady!'\n    ],\n    function (\n        Component,\n        $\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {},\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n\n                return this.initEvents();\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initEvents: function () {\n                $('a[data-action=\"' + this.linkDataAction + '\"]').off('click.' + this.id)\n                    .on('click.' + this.id, this.click.bind(this));\n\n                return this;\n            },\n\n            /**\n             * @param {Object} event\n             * @returns void\n             */\n            click: function (event) {\n                event.preventDefault();\n\n                $('#' + this.paypalButton).click();\n            }\n        });\n    }\n);\n","Magento_ProductVideo/js/load-player.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n @version 0.0.1\n @requires jQuery & jQuery UI\n */\ndefine(['jquery', 'jquery/ui'], function ($) {\n    'use strict';\n\n    var videoRegister = {\n        _register: {},\n\n        /**\n         * Checks, if api is already registered\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isRegistered: function (api) {\n            return this._register[api] !== undefined;\n        },\n\n        /**\n         * Checks, if api is loaded\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isLoaded: function (api) {\n            return this._register[api] !== undefined && this._register[api] === true;\n        },\n\n        /**\n         * Register new video api\n         * @param {String} api\n         * @param {bool} loaded\n         */\n        register: function (api, loaded) {\n            loaded = loaded || false;\n            this._register[api] = loaded;\n        }\n    };\n\n    $.widget('mage.productVideoLoader', {\n\n        /**\n         * @private\n         */\n        _create: function () {\n            switch (this.element.data('type')) {\n                case 'youtube':\n                    this.element.videoYoutube();\n                    this._player = this.element.data('mageVideoYoutube');\n                    break;\n\n                case 'vimeo':\n                    this.element.videoVimeo();\n                    this._player = this.element.data('mageVideoVimeo');\n                    break;\n                default:\n                    throw {\n                        name: 'Video Error',\n                        message: 'Unknown video type',\n\n                        /**\n                         * join name with message\n                         */\n                        toString: function () {\n                            return this.name + ': ' + this.message;\n                        }\n                    };\n            }\n        },\n\n        /**\n         * Initializes variables\n         * @private\n         */\n        _initialize: function () {\n            this._params = this.element.data('params') || {};\n            this._code = this.element.data('code');\n            this._width = this.element.data('width');\n            this._height = this.element.data('height');\n            this._autoplay = !!this.element.data('autoplay');\n            this._playing = this._autoplay || false;\n            this._loop = this.element.data('loop');\n            this._rel = this.element.data('related');\n\n            this._responsive = this.element.data('responsive') !== false;\n\n            if (this._responsive === true) {\n                this.element.addClass('responsive');\n            }\n\n            this._calculateRatio();\n        },\n\n        /**\n         * Abstract play command\n         */\n        play: function () {\n            this._player.play();\n        },\n\n        /**\n         * Abstract pause command\n         */\n        pause: function () {\n            this._player.pause();\n        },\n\n        /**\n         * Abstract stop command\n         */\n        stop: function () {\n            this._player.stop();\n        },\n\n        /**\n         * Abstract playing command\n         */\n        playing: function () {\n            return this._player.playing();\n        },\n\n        /**\n         * Destroyer\n         */\n        destroy: function () {\n            this._player.destroy();\n        },\n\n        /**\n         * Calculates ratio for responsive videos\n         * @private\n         */\n        _calculateRatio: function () {\n            if (!this._responsive) {\n                return;\n            }\n            this.element.css('paddingBottom', this._height / this._width * 100 + '%');\n        }\n    });\n\n    $.widget('mage.videoYoutube', $.mage.productVideoLoader, {\n\n        /**\n         * Initialization of the Youtube widget\n         * @private\n         */\n        _create: function () {\n            var self = this;\n\n            this._initialize();\n\n            this.element.append('<div/>');\n\n            this._on(window, {\n\n                /**\n                 * Handle event\n                 */\n                'youtubeapiready': function () {\n                    if (self._player !== undefined) {\n                        return;\n                    }\n                    self._autoplay = true;\n\n                    if (self._autoplay) {\n                        self._params.autoplay = 1;\n                    }\n\n                    if (!self._rel) {\n                        self._params.rel = 0;\n                    }\n\n                    self._player = new window.YT.Player(self.element.children(':first')[0], {\n                        height: self._height,\n                        width: self._width,\n                        videoId: self._code,\n                        playerVars: self._params,\n                        events: {\n\n                            /**\n                             * Get duration\n                             */\n                            'onReady': function onPlayerReady() {\n                                self._player.getDuration();\n                                self.element.closest('.fotorama__stage__frame')\n                                    .addClass('fotorama__product-video--loaded');\n                            },\n\n                            /**\n                             * Event observer\n                             */\n                            onStateChange: function (data) {\n                                switch (window.parseInt(data.data, 10)) {\n                                    case 1:\n                                        self._playing = true;\n                                        break;\n                                    default:\n                                        self._playing = false;\n                                        break;\n                                }\n\n                                self._trigger('statechange', {}, data);\n\n                                if (data.data === window.YT.PlayerState.ENDED && self._loop) {\n                                    self._player.playVideo();\n                                }\n                            }\n                        }\n\n                    });\n                }\n            });\n\n            this._loadApi();\n        },\n\n        /**\n         * Loads Youtube API and triggers event, when loaded\n         * @private\n         */\n        _loadApi: function () {\n            var element,\n                scriptTag;\n\n            if (videoRegister.isRegistered('youtube')) {\n                if (videoRegister.isLoaded('youtube')) {\n                    $(window).trigger('youtubeapiready');\n                }\n\n                return;\n            }\n            videoRegister.register('youtube');\n\n            element = document.createElement('script');\n            scriptTag = document.getElementsByTagName('script')[0];\n\n            element.async = true;\n            element.src = 'https://www.youtube.com/iframe_api';\n            scriptTag.parentNode.insertBefore(element, scriptTag);\n\n            /**\n             * Event observe and handle\n             */\n            window.onYouTubeIframeAPIReady = function () {\n                $(window).trigger('youtubeapiready');\n                videoRegister.register('youtube', true);\n            };\n        },\n\n        /**\n         * Play command for Youtube\n         */\n        play: function () {\n            this._player.playVideo();\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Youtube\n         */\n        pause: function () {\n            this._player.pauseVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Youtube\n         */\n        stop: function () {\n            this._player.stopVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Youtube\n         */\n        playing: function () {\n            return this._playing;\n        },\n\n        /**\n         * stops and unloads player\n         * @private\n         */\n        destroy: function () {\n            this.stop();\n            this._player.destroy();\n        }\n    });\n\n    $.widget('mage.videoVimeo', $.mage.productVideoLoader, {\n\n        /**\n         * Initialize the Vimeo widget\n         * @private\n         */\n        _create: function () {\n            var timestamp,\n                additionalParams = '',\n                src;\n\n            this._initialize();\n            timestamp = new Date().getTime();\n            this._autoplay = true;\n\n            if (this._autoplay) {\n                additionalParams += '&autoplay=1';\n            }\n\n            if (this._loop) {\n                additionalParams += '&loop=1';\n            }\n            src = window.location.protocol + '//player.vimeo.com/video/' +\n                this._code + '?api=1&player_id=vimeo' +\n                this._code +\n                timestamp +\n                additionalParams;\n            this.element.append(\n                $('<iframe/>')\n                    .attr('frameborder', 0)\n                    .attr('id', 'vimeo' + this._code + timestamp)\n                    .attr('width', this._width)\n                    .attr('height', this._height)\n                    .attr('src', src)\n                    .attr('webkitallowfullscreen', '')\n                    .attr('mozallowfullscreen', '')\n                    .attr('allowfullscreen', '')\n                    .attr('referrerPolicy', 'origin')\n            );\n            this._player = window.$f(this.element.children(':first')[0]);\n\n            // Froogaloop throws error without a registered ready event\n            this._player.addEvent('ready', function (id) {\n                $('#' + id).closest('.fotorama__stage__frame').addClass('fotorama__product-video--loaded');\n            });\n        },\n\n        /**\n         * Play command for Vimeo\n         */\n        play: function () {\n            this._player.api('play');\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Vimeo\n         */\n        pause: function () {\n            this._player.api('pause');\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Vimeo\n         */\n        stop: function () {\n            this._player.api('unload');\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Vimeo\n         */\n        playing: function () {\n            return this._playing;\n        }\n    });\n});\n","Magento_ProductVideo/js/fotorama-add-video-events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'catalogGallery',\n    'loadPlayer'\n], function ($) {\n    'use strict';\n\n    /**\n     * @private\n     */\n    var allowBase = true; //global var is needed because fotorama always fully reloads events in case of fullscreen\n\n    /**\n     * @private\n     */\n    function parseHref(href) {\n        var a = document.createElement('a');\n\n        a.href = href;\n\n        return a;\n    }\n\n    /**\n     * @private\n     */\n    function parseURL(href, forceVideo) {\n        var id,\n            type,\n            ampersandPosition,\n            vimeoRegex;\n\n        /**\n         * Get youtube ID\n         * @param {String} srcid\n         * @returns {{}}\n         */\n        function _getYoutubeId(srcid) {\n            if (srcid) {\n                ampersandPosition = srcid.indexOf('&');\n\n                if (ampersandPosition === -1) {\n                    return srcid;\n                }\n\n                srcid = srcid.substring(0, ampersandPosition);\n            }\n\n            return srcid;\n        }\n\n        if (typeof href !== 'string') {\n            return href;\n        }\n\n        href = parseHref(href);\n\n        if (href.host.match(/youtube\\.com/) && href.search) {\n            id = href.search.split('v=')[1];\n\n            if (id) {\n                id = _getYoutubeId(id);\n                type = 'youtube';\n            }\n        } else if (href.host.match(/youtube\\.com|youtu\\.be/)) {\n            id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n            type = 'youtube';\n        } else if (href.host.match(/vimeo\\.com/)) {\n            type = 'vimeo';\n            vimeoRegex = new RegExp(['https?:\\\\/\\\\/(?:www\\\\.|player\\\\.)?vimeo.com\\\\/(?:channels\\\\/(?:\\\\w+\\\\/)',\n                '?|groups\\\\/([^\\\\/]*)\\\\/videos\\\\/|album\\\\/(\\\\d+)\\\\/video\\\\/|video\\\\/|)(\\\\d+)(?:$|\\\\/|\\\\?)'\n            ].join(''));\n            id = href.href.match(vimeoRegex)[3];\n        }\n\n        if ((!id || !type) && forceVideo) {\n            id = href.href;\n            type = 'custom';\n        }\n\n        return id ? {\n            id: id, type: type, s: href.search.replace(/^\\?/, '')\n        } : false;\n    }\n\n    //create AddFotoramaVideoEvents widget\n    $.widget('mage.AddFotoramaVideoEvents', {\n        options: {\n            videoData: '',\n            videoSettings: '',\n            optionsVideoData: '',\n            dataMergeStrategy: 'replace',\n            vimeoJSFrameworkLoaded: false\n        },\n\n        /**\n         * @private\n         */\n        onVimeoJSFramework: function () {},\n        defaultVideoData: [],\n        PV: 'product-video', // [CONST]\n        VU: 'video-unplayed',\n        PVLOADED: 'fotorama__product-video--loaded', // [CONST]\n        PVLOADING: 'fotorama__product-video--loading', // [CONST]\n        VID: 'video', // [CONST]\n        VI: 'vimeo', // [CONST]\n        FTVC: 'fotorama__video-close',\n        FTAR: 'fotorama__arr',\n        fotoramaSpinner: 'fotorama__spinner',\n        fotoramaSpinnerShow: 'fotorama__spinner--show',\n        TI: 'video-thumb-icon',\n        isFullscreen: false,\n        FTCF: '[data-gallery-role=\"fotorama__fullscreen-icon\"]',\n        Base: 0, //on check for video is base this setting become true if there is any video with base role\n        MobileMaxWidth: 767,\n        GP: 'gallery-placeholder', //gallery placeholder class is needed to find and erase <script> tag\n        videoData: null,\n        videoDataPlaceholder: [{\n            id: '',\n            isBase: true,\n            mediaType: 'image',\n            provider: ''\n        }],\n\n        /**\n         * Creates widget\n         * @private\n         */\n        _create: function () {\n            $(this.element).on('gallery:loaded',  $.proxy(function () {\n                this._initialize();\n            }, this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initialize: function () {\n            if (!this.defaultVideoData.length) {\n                this.defaultVideoData = this.options.videoData;\n            }\n\n            // If product does not have images, no video data generated,\n            // but for configurable product we still need a video data, in case of 'prepend' gallery strategy.\n            if (!this.defaultVideoData.length && !this.options.videoData.length) {\n                this.defaultVideoData = this.options.videoData = this.videoDataPlaceholder;\n            }\n\n            this.fotoramaItem = $(this.element).find('.fotorama-item');\n            this.clearEvents();\n\n            if (this._checkForVideoExist()) {\n                this._checkFullscreen();\n                this._listenForFullscreen();\n                this._checkForVimeo();\n                this._isVideoBase();\n                this._initFotoramaVideo();\n                this._attachFotoramaEvents();\n            }\n\n            this.element.trigger('AddFotoramaVideoEvents:loaded');\n        },\n\n        /**\n         * Clear gallery events to prevent duplicated calls.\n         *\n         * @private\n         */\n        clearEvents: function () {\n            this.fotoramaItem.off(\n                'fotorama:show ' +\n                'fotorama:showend ' +\n                'fotorama:fullscreenenter ' +\n                'fotorama:fullscreenexit'\n            );\n        },\n\n        /**\n         *\n         * @param {Object} options\n         * @private\n         */\n        _setOptions: function (options) {\n            if (options.videoData && options.videoData.length) {\n                this.options.videoData = options.videoData;\n            }\n\n            this._loadVideoData(options);\n            this._initialize();\n        },\n\n        /**\n         * Set video data for configurable product.\n         *\n         * @param {Object} options\n         * @private\n         */\n        _loadVideoData: function (options) {\n            if (options.selectedOption) {\n                if (options.dataMergeStrategy === 'prepend') {\n                    this.options.videoData = [].concat(\n                        this.options.optionsVideoData[options.selectedOption],\n                        this.options.videoData\n                    );\n                } else {\n                    this.options.videoData = this.options.optionsVideoData[options.selectedOption];\n                }\n            } else {\n                this.options.videoData = this.defaultVideoData;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _checkFullscreen: function () {\n            if (this.fotoramaItem.data('fotorama').fullScreen || false) {\n                this.isFullscreen = true;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _listenForFullscreen: function () {\n            this.fotoramaItem.on('fotorama:fullscreenenter', $.proxy(function () {\n                this.isFullscreen = true;\n            }, this));\n\n            this.fotoramaItem.on('fotorama:fullscreenexit', $.proxy(function () {\n                this.isFullscreen = false;\n                this._hideVideoArrows();\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} inputData\n         * @param {bool} isJSON\n         * @returns {{}}\n         * @private\n         */\n        _createVideoData: function (inputData, isJSON) {\n            var videoData = [],\n                dataUrl,\n                tmpVideoData,\n                tmpInputData,\n                i;\n\n            if (isJSON) {\n                inputData = $.parseJSON(inputData);\n            }\n\n            for (i = 0; i < inputData.length; i++) {\n                tmpInputData = inputData[i];\n                dataUrl = '';\n                tmpVideoData = {\n                    mediaType: '',\n                    isBase: '',\n                    id: '',\n                    provider: ''\n                };\n                tmpVideoData.mediaType = this.VID;\n\n                if (tmpInputData.mediaType !== 'external-video') {\n                    tmpVideoData.mediaType = tmpInputData.mediaType;\n                }\n\n                tmpVideoData.isBase = tmpInputData.isBase;\n\n                if (tmpInputData.videoUrl && tmpInputData.videoUrl !== null) {\n                    dataUrl = tmpInputData.videoUrl;\n                    dataUrl = parseURL(dataUrl);\n                    tmpVideoData.id = dataUrl.id;\n                    tmpVideoData.provider = dataUrl.type;\n                    tmpVideoData.videoUrl = tmpInputData.videoUrl;\n                }\n\n                videoData.push(tmpVideoData);\n            }\n\n            return videoData;\n        },\n\n        /**\n         *\n         * @param {Object} fotorama\n         * @param {bool} isBase\n         * @private\n         */\n        _createCloseVideo: function (fotorama, isBase) {\n            var closeVideo;\n\n            this.fotoramaItem.find('.' + this.FTVC).remove();\n            this.fotoramaItem.append('<div class=\"' + this.FTVC + '\"></div>');\n            this.fotoramaItem.css('position', 'relative');\n            closeVideo = this.fotoramaItem.find('.' + this.FTVC);\n            this._closeVideoSetEvents(closeVideo, fotorama);\n\n            if (\n                isBase &&\n                this.options.videoData[fotorama.activeIndex].isBase &&\n                $(window).width() > this.MobileMaxWidth) {\n                this._showCloseVideo();\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _hideCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .removeClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @private\n         */\n        _showCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .addClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @param {jQuery} $closeVideo\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _closeVideoSetEvents: function ($closeVideo, fotorama) {\n            $closeVideo.on('click', $.proxy(function () {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n                this._hideCloseVideo();\n            }, this));\n        },\n\n        /**\n         *\n         * @returns {Boolean}\n         * @private\n         */\n        _checkForVideoExist: function () {\n            var key, result, checker, videoSettings;\n\n            if (!this.options.videoData) {\n                return false;\n            }\n\n            if (!this.options.videoSettings) {\n                return false;\n            }\n\n            result = this._createVideoData(this.options.videoData, false);\n            checker = false;\n            videoSettings = this.options.videoSettings[0];\n            videoSettings.playIfBase = parseInt(videoSettings.playIfBase, 10);\n            videoSettings.showRelated = parseInt(videoSettings.showRelated, 10);\n            videoSettings.videoAutoRestart = parseInt(videoSettings.videoAutoRestart, 10);\n\n            for (key in result) {\n                if (result[key].mediaType === this.VID) {\n                    checker = true;\n                }\n            }\n\n            if (checker) {\n                this.options.videoData = result;\n            }\n\n            return checker;\n        },\n\n        /**\n         *\n         * @private\n         */\n        _checkForVimeo: function () {\n            var allVideoData = this.options.videoData,\n                videoItem;\n\n            if (window.Froogaloop) { // prevent duplicated initialization\n                return;\n            }\n\n            for (videoItem in allVideoData) {\n                if (allVideoData[videoItem].provider === this.VI) {\n                    this._loadVimeoJSFramework();\n\n                    return;\n                }\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _isVideoBase: function () {\n            var allVideoData = this.options.videoData,\n                videoItem,\n                allVideoDataKeys,\n                key,\n                i;\n\n            allVideoDataKeys = Object.keys(allVideoData);\n\n            for (i = 0; i < allVideoDataKeys.length; i++) {\n                key = allVideoDataKeys[i];\n                videoItem = allVideoData[key];\n\n                if (\n                    videoItem.mediaType === this.VID && videoItem.isBase &&\n                    this.options.videoSettings[0].playIfBase && allowBase\n                ) {\n                    this.Base = true;\n                    allowBase = false;\n                }\n            }\n\n            if (!this.isFullscreen) {\n                this._createCloseVideo(this.fotoramaItem.data('fotorama'), this.Base);\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _loadVimeoJSFramework: function () {\n            var element = document.createElement('script'),\n                scriptTag = document.getElementsByTagName('script')[0];\n\n            element.async = true;\n            element.src = 'https://secure-a.vimeocdn.com/js/froogaloop2.min.js';\n\n            /**\n             * Vimeo js framework on load callback.\n             */\n            element.onload = function () {\n                this.onVimeoJSFramework();\n                this.vimeoJSFrameworkLoaded = true;\n            }.bind(this);\n            scriptTag.parentNode.insertBefore(element, scriptTag);\n        },\n\n        /**\n         *\n         * @param {Event} e\n         * @private\n         */\n        _initFotoramaVideo: function (e) {\n            var fotorama = this.fotoramaItem.data('fotorama'),\n                thumbsParent,\n                thumbs,\n                t;\n\n            if (!fotorama.activeFrame.$navThumbFrame) {\n                this.fotoramaItem.on('fotorama:showend', $.proxy(function (evt, fotoramaData) {\n                    $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n                }, this));\n\n                this._startPrepareForPlayer(e, fotorama);\n\n                return null;\n            }\n\n            fotorama.data.map($.proxy(this._setItemType, this));\n            thumbsParent = fotorama.activeFrame.$navThumbFrame.parent();\n            thumbs = thumbsParent.find('.fotorama__nav__frame:visible');\n\n            for (t = 0; t < thumbs.length; t++) {\n                this._setThumbsIcon(thumbs.eq(t), t);\n                this._checkForVideo(e, fotorama, t + 1);\n            }\n\n            this.fotoramaItem.on('fotorama:showend', $.proxy(function (evt, fotoramaData) {\n                $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} elem\n         * @param {Number} i\n         * @private\n         */\n        _setThumbsIcon: function (elem, i) {\n            var fotorama = this.fotoramaItem.data('fotorama');\n\n            if (fotorama.options.nav === 'dots' && elem.hasClass(this.TI)) {\n                elem.removeClass(this.TI);\n            }\n\n            if (this.options.videoData[i].mediaType === this.VID &&\n                fotorama.data[i].type ===  this.VID &&\n                fotorama.options.nav === 'thumbs') {\n                elem.addClass(this.TI);\n            }\n        },\n\n        /**\n         * Temporary solution with adding types for configurable product items\n         *\n         * @param {Object} item\n         * @param {Number} i\n         * @private\n         */\n        _setItemType: function (item, i) {\n            !item.type && (item.type = this.options.videoData[i].mediaType);\n        },\n\n        /**\n         * Attach\n         *\n         * @private\n         */\n        _attachFotoramaEvents: function () {\n            this.fotoramaItem.on('fotorama:showend', $.proxy(function (e, fotorama) {\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n\n            this.fotoramaItem.on('fotorama:show', $.proxy(function (e, fotorama) {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n            }, this));\n\n            this.fotoramaItem.on('fotorama:fullscreenexit', $.proxy(function (e, fotorama) {\n                fotorama.activeFrame.$stageFrame.find('.' + this.PV).remove();\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n        },\n\n        /**\n         * Start prepare for player\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _startPrepareForPlayer: function (e, fotorama) {\n            this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, false);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i - 1);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i + 1);\n        },\n\n        /**\n         * Check for video\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _checkForVideo: function (e, fotorama, number) {\n            var videoData = this.options.videoData[number - 1],\n                $image = fotorama.data[number - 1];\n\n            if ($image) {\n                !$image.type && this._setItemType($image, number - 1);\n\n                if ($image.type === 'image') {\n                    $image.$navThumbFrame && $image.$navThumbFrame.removeClass(this.TI);\n                    this._hideCloseVideo();\n\n                    return;\n                } else if ($image.$navThumbFrame && $image.type === 'video') {\n                    !$image.$navThumbFrame.hasClass(this.TI) && $image.$navThumbFrame.addClass(this.TI);\n                }\n\n                $image = $image.$stageFrame;\n            }\n\n            if ($image && videoData && videoData.mediaType === this.VID) {\n                $(fotorama.activeFrame.$stageFrame).removeAttr('href');\n                this._prepareForVideoContainer($image, videoData, fotorama, number);\n            }\n\n            if (this.isFullscreen && this.fotoramaItem.data('fotorama').activeFrame.i === number) {\n                this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n            }\n        },\n\n        /**\n         * Prepare for video container\n         *\n         * @param {jQuery} $image\n         * @param {Object} videoData\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _prepareForVideoContainer: function ($image, videoData, fotorama, number) {\n            $image.addClass('fotorama-video-container').addClass(this.VU);\n            this._createVideoContainer(videoData, $image);\n            this._setVideoEvent($image, this.PV, fotorama, number);\n        },\n\n        /**\n         * Create video container\n         *\n         * @param {Object} videoData\n         * @param {jQuery} $image\n         * @private\n         */\n        _createVideoContainer: function (videoData, $image) {\n            var videoSettings;\n\n            videoSettings = this.options.videoSettings[0];\n            $image.find('.' + this.PV).remove();\n            $image.append(\n                '<div class=\"' +\n                this.PV +\n                '\" data-related=\"' +\n                videoSettings.showRelated +\n                '\" data-loop=\"' +\n                videoSettings.videoAutoRestart +\n                '\" data-type=\"' +\n                videoData.provider +\n                '\" data-code=\"' +\n                videoData.id +\n                '\" data-width=\"100%\" data-height=\"100%\"></div>'\n            );\n        },\n\n        /**\n         *\n         * @param {Object} $image\n         * @param {Object} PV\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _setVideoEvent: function ($image, PV, fotorama, number) {\n            $image.find('.magnify-lens').remove();\n            $image\n                .off('click tap', $.proxy(this._clickHandler, this))\n                .on('click tap', $.proxy(this._clickHandler, this));\n            this._handleBaseVideo(fotorama, number); //check for video is it base and handle it if it's base\n        },\n\n        /**\n         * Hides preview arrows above video player.\n         * @private\n         */\n        _hideVideoArrows: function () {\n            var arrows = $('.' + this.FTAR);\n\n            arrows.removeClass('fotorama__arr--shown');\n            arrows.removeClass('fotorama__arr--hidden');\n        },\n\n        /**\n         * @private\n         */\n        _showLoader: function () {\n            var spinner = this.fotoramaItem.find('.' + this.fotoramaSpinner);\n\n            spinner.addClass(this.fotoramaSpinnerShow);\n            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.addClass(this.PVLOADING);\n        },\n\n        /**\n         * @private\n         */\n        _hideLoader: function () {\n            var spinner = this.fotoramaItem.find('.' + this.fotoramaSpinner);\n\n            spinner.removeClass(this.fotoramaSpinnerShow);\n            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.removeClass(this.PVLOADING);\n        },\n\n        /**\n         * @param {Event} event\n         * @private\n         */\n        _clickHandler: function (event) {\n            var type;\n\n            if ($(event.target).hasClass(this.VU) && $(event.target).find('iframe').length === 0) {\n                $(event.target).removeClass(this.VU);\n                type = $(event.target).find('.' + this.PV).data('type');\n\n                if (this.vimeoJSFrameworkLoaded && type === this.VI) {\n                    $(event.target).find('.' + this.PV).productVideoLoader();\n                } else if (type === this.VI) {\n                    this._showLoader();\n                    this.onVimeoJSFramework = function () {\n                        $(event.target).find('.' + this.PV).productVideoLoader();\n                        this._hideLoader();\n                    }.bind(this);\n                } else {\n                    $(event.target).find('.' + this.PV).productVideoLoader();\n                }\n\n                $('.' + this.FTAR).addClass(this.isFullscreen ? 'fotorama__arr--shown' : 'fotorama__arr--hidden');\n            }\n        },\n\n        /**\n         * Handle base video\n         * @param {Object} fotorama\n         * @param {Number} srcNumber\n         * @private\n         */\n        _handleBaseVideo: function (fotorama, srcNumber) {\n            var waitForFroogaloop,\n                videoData = this.options.videoData,\n                activeIndex = fotorama.activeIndex,\n                number = parseInt(srcNumber, 10),\n                activeIndexIsBase = videoData[activeIndex];\n\n            if (!this.Base) {\n                return;\n            }\n\n            if (activeIndexIsBase && number === 1 && $(window).width() > this.MobileMaxWidth) {\n                if (this.options.videoData[fotorama.activeIndex].provider === this.VI) {\n                    waitForFroogaloop = setInterval($.proxy(function () {\n                        if (window.Froogaloop) {\n                            clearInterval(waitForFroogaloop);\n                            fotorama.requestFullScreen();\n                            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n                            this.Base = false;\n                        }\n                    }, this), 50);\n                } else { //if not a vimeo - play it immediately with a little lag in case for fotorama fullscreen\n                    setTimeout($.proxy(function () {\n                        fotorama.requestFullScreen();\n                        this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n                        this.Base = false;\n                    }, this), 50);\n                }\n            }\n        },\n\n        /**\n         * Destroy video player\n         * @param {jQuery} $wrapper\n         * @param {jQuery} current\n         * @param {bool} close\n         * @private\n         */\n        _unloadVideoPlayer: function ($wrapper, current, close) {\n            var self = this;\n\n            if (!$wrapper) {\n                return;\n            }\n\n            $wrapper.find('.' + this.PVLOADED).removeClass(this.PVLOADED);\n            this._hideLoader();\n\n            $wrapper.find('.' + this.PV).each(function () {\n                var $item = $(this).parent(),\n                    cloneVideoDiv,\n                    iframeElement = $(this).find('iframe'),\n                    currentIndex,\n                    itemIndex;\n\n                if (iframeElement.length === 0) {\n                    return;\n                }\n\n                currentIndex = current.activeFrame.$stageFrame.index();\n                itemIndex = $item.index();\n\n                if (currentIndex === itemIndex && !close) {\n                    return;\n                }\n\n                if (currentIndex !== itemIndex && close) {\n                    return;\n                }\n\n                iframeElement.remove();\n                cloneVideoDiv = $(this).clone();\n                $(this).remove();\n                $item.append(cloneVideoDiv);\n                $item.addClass(self.VU);\n\n                self._hideCloseVideo();\n                self._hideVideoArrows();\n\n                if (self.isFullscreen && !self.fotoramaItem.data('fotorama').options.fullscreen.arrows) {\n                    if ($('.' + self.FTAR + '--prev').is(':focus') || $('.' + self.FTAR + '--next').is(':focus')) {\n                        $(self.FTCF).focus();\n                    }\n                }\n            });\n        }\n    });\n\n    return $.mage.AddFotoramaVideoEvents;\n});\n","magnifier/magnifier.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function ($) {\n    $.fn.magnify = function (options) {\n        'use strict';\n\n        var magnify = new Magnify($(this), options);\n\n        /*events must be tracked here*/\n\n        /**\n         * Return that from _init function\n         *\n         */\n        return magnify;\n\n    };\n\n    function Magnify(element, options) {\n        var gOptions = options || {},\n            $box = $(element),\n            $thumb,\n            that = this,\n            largeWrapper = options.largeWrapper ||  '.magnifier-preview',\n            $largeWrapper = $(largeWrapper);\n\n        curThumb = null,\n            currentOpts = {\n                x: 0,\n                y: 0,\n                w: 0,\n                h: 0,\n                lensW: 0,\n                lensH: 0,\n                lensBgX: 0,\n                lensBgY: 0,\n                largeW: 0,\n                largeH: 0,\n                largeL: 0,\n                largeT: 0,\n                zoom: 2,\n                zoomMin: 1.1,\n                zoomMax: 5,\n                mode: 'outside',\n                eventType: 'click',\n                status: 0,\n                zoomAttached: false,\n                zoomable: gOptions.zoomable !== undefined ?\n                    gOptions.zoomable\n                    : false,\n                onthumbenter: gOptions.onthumbenter !== undefined ?\n                    gOptions.onthumbenter\n                    : null,\n                onthumbmove: gOptions.onthumbmove !== undefined ?\n                    gOptions.onthumbmove\n                    : null,\n                onthumbleave: gOptions.onthumbleave !== undefined ?\n                    gOptions.onthumbleave\n                    : null,\n                onzoom: gOptions.onzoom !== undefined ?\n                    gOptions.onzoom\n                    : null\n            },\n            pos = {\n                t: 0,\n                l: 0,\n                x: 0,\n                y: 0\n            },\n            gId = 0,\n            status = 0,\n            curIdx = '',\n            curLens = null,\n            curLarge = null,\n            lensbg = gOptions.bg !== undefined ? gOptions.lensbg : true,\n            gZoom = gOptions.zoom !== undefined ?\n                gOptions.zoom\n                : currentOpts.zoom,\n            gZoomMin = gOptions.zoomMin !== undefined ?\n                gOptions.zoomMin\n                : currentOpts.zoomMin,\n            gZoomMax = gOptions.zoomMax !== undefined ?\n                gOptions.zoomMax\n                : currentOpts.zoomMax,\n            gMode = gOptions.mode || currentOpts.mode,\n            gEventType = gOptions.eventType || currentOpts.eventType,\n            data = {},\n            inBounds = false,\n            isOverThumb = false,\n            rate = 1,\n            paddingX = 0,\n            paddingY = 0,\n            enabled = true,\n            showWrapper = true;\n\n        var MagnifyCls = {\n            magnifyHidden: 'magnify-hidden',\n            magnifyOpaque: 'magnify-opaque',\n            magnifyFull: 'magnify-fullimage'\n\n        };\n\n\n        /**\n         * Update Lens positon on.\n         *\n         */\n        that.update = function () {\n            updateLensOnLoad();\n        };\n\n        /**\n         * Init new Magnifier\n         *\n         */\n        that.init = function () {\n            _init($box, options);\n        };\n\n        function _toBoolean(str) {\n            if (typeof str === 'string') {\n                if (str === 'true') {\n                    return true;\n                } else if (str === 'false' || '') {\n                    return false;\n                }\n                console.warn('Wrong type: can\\'t be transformed to Boolean');\n\n            } else if (typeof str === 'boolean') {\n                return str;\n            }\n        }\n\n        function createLens(thumb) {\n            if ($(thumb).siblings('.magnify-lens').length) {\n                return false;\n            }\n            var lens = $('<div class=\"magnify-lens magnify-hidden\" data-gallery-role=\"magnifier-zoom\"></div>');\n\n            $(thumb).parent().append(lens);\n        }\n\n        function updateLensOnLoad(idx, thumb, large, largeWrapper) {\n            var lens = $box.find('.magnify-lens'),\n                textWrapper;\n\n            if (data[idx].status === 1) {\n                textWrapper = $('<div class=\"magnifier-loader-text\"></div>');\n                lens.className = 'magnifier-loader magnify-hidden';\n                textWrapper.html('Loading...');\n                lens.html('').append(textWrapper);\n            } else if (data[idx].status === 2) {\n                lens.addClass(MagnifyCls.magnifyHidden);\n                lens.html('');\n                large.id = idx + '-large';\n                large.style.width = data[idx].largeW * rate + 'px';\n                large.style.height = data[idx].largeH + 'px';\n                large.className = 'magnifier-large magnify-hidden';\n\n                if (data[idx].mode === 'inside') {\n                    lens.append(large);\n                } else {\n                    largeWrapper.html('').append(large);\n                }\n            }\n\n            data[idx].lensH = data[idx].lensH > $thumb.height() ? $thumb.height() : data[idx].lensH;\n\n            if (Math.round(data[idx].lensW) === 0) {\n                lens.css('display', 'none');\n            } else {\n                lens.css({\n                    width: data[idx].lensW + 1 + 'px',\n                    height: data[idx].lensH - 1 + 'px',\n                    display: ''\n                });\n            }\n        }\n\n        function getMousePos() {\n            var xPos = pos.x - currentOpts.x,\n                yPos = pos.y - currentOpts.y,\n                t,\n                l;\n\n            inBounds =  xPos < 0 || yPos < 0 || xPos > currentOpts.w || yPos > currentOpts.h  ? false : true;\n\n            l = xPos - currentOpts.lensW / 2;\n            t = yPos - currentOpts.lensH / 2;\n\n            if (currentOpts.mode !== 'inside') {\n                if (xPos < currentOpts.lensW / 2) {\n                    l = 0;\n                }\n\n                if (yPos < currentOpts.lensH / 2) {\n                    t = 0;\n                }\n\n                if (xPos - currentOpts.w + Math.ceil(currentOpts.lensW / 2) > 0) {\n                    l = currentOpts.w - Math.ceil(currentOpts.lensW + 2);\n                }\n\n                if (yPos - currentOpts.h + Math.ceil(currentOpts.lensH / 2) > 0) {\n                    t = currentOpts.h - Math.ceil(currentOpts.lensH);\n                }\n\n                pos.l = l;\n                pos.t = t;\n\n                currentOpts.lensBgX = pos.l;\n                currentOpts.lensBgY = pos.t;\n\n                if (currentOpts.mode === 'inside') {\n                    currentOpts.largeL = xPos * (currentOpts.zoom - currentOpts.lensW / currentOpts.w);\n                    currentOpts.largeT = yPos * (currentOpts.zoom - currentOpts.lensH / currentOpts.h);\n                } else {\n                    currentOpts.largeL = currentOpts.lensBgX * currentOpts.zoom * (currentOpts.largeWrapperW / currentOpts.w) * rate;\n                    currentOpts.largeT = currentOpts.lensBgY * currentOpts.zoom * (currentOpts.largeWrapperH / currentOpts.h);\n                }\n            }\n        }\n\n        function onThumbEnter() {\n            if (_toBoolean(enabled)) {\n                currentOpts = data[curIdx];\n                curLens = $box.find('.magnify-lens');\n\n                if (currentOpts.status === 2) {\n                    curLens.removeClass(MagnifyCls.magnifyOpaque);\n                    curLarge = $('#' + curIdx + '-large');\n                    curLarge.removeClass(MagnifyCls.magnifyHidden);\n                } else if (currentOpts.status === 1) {\n                    curLens.className = 'magnifier-loader';\n                }\n            }\n        }\n\n        function onThumbLeave() {\n            if (currentOpts.status > 0) {\n                var handler = currentOpts.onthumbleave;\n\n                if (handler !== null) {\n                    handler({\n                        thumb: curThumb,\n                        lens: curLens,\n                        large: curLarge,\n                        x: pos.x,\n                        y: pos.y\n                    });\n                }\n\n                if (!curLens.hasClass(MagnifyCls.magnifyHidden)) {\n                    curLens.addClass(MagnifyCls.magnifyHidden);\n\n                    //$curThumb.removeClass(MagnifyCls.magnifyOpaque);\n                    if (curLarge !== null) {\n                        curLarge.addClass(MagnifyCls.magnifyHidden);\n                    }\n                }\n            }\n        }\n\n        function move() {\n            if (_toBoolean(enabled)) {\n                if (status !== currentOpts.status) {\n                    onThumbEnter();\n                }\n\n                if (currentOpts.status > 0) {\n                    curThumb.className = currentOpts.thumbCssClass + ' magnify-opaque';\n\n                    if (currentOpts.status === 1) {\n                        curLens.className = 'magnifier-loader';\n                    } else if (currentOpts.status === 2) {\n                        curLens.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.css({\n                            left: '-' + currentOpts.largeL + 'px',\n                            top: '-' + currentOpts.largeT + 'px'\n                        });\n                    }\n\n                    pos.t = pos.t <= 0 ? 0 : pos.t;\n                    curLens.css({\n                        left: pos.l + paddingX + 'px',\n                        top: pos.t + 1 + paddingY + 'px'\n                    });\n\n                    if (lensbg) {\n                        curLens.css({\n                            'background-color': 'rgba(f,f,f,.5)'\n                        });\n                    } else {\n                        curLens.get(0).style.backgroundPosition = '-' +\n                        currentOpts.lensBgX + 'px -' +\n                        currentOpts.lensBgY + 'px';\n                    }\n                    var handler = currentOpts.onthumbmove;\n\n                    if (handler !== null) {\n                        handler({\n                            thumb: curThumb,\n                            lens: curLens,\n                            large: curLarge,\n                            x: pos.x,\n                            y: pos.y\n                        });\n                    }\n                }\n\n                status = currentOpts.status;\n            }\n        }\n\n        function setThumbData(thumb, thumbData) {\n            var thumbBounds = thumb.getBoundingClientRect(),\n                w = 0,\n                h = 0;\n\n            thumbData.x = thumbBounds.left;\n            thumbData.y = thumbBounds.top;\n            thumbData.w = thumbBounds.right - thumbData.x;\n            thumbData.h = thumbBounds.bottom - thumbData.y;\n\n            if (thumbData.mode === 'inside') {\n                w = thumbData.w;\n                h = thumbData.h;\n            } else {\n                w = thumbData.largeWrapperW;\n                h = thumbData.largeWrapperH;\n            }\n\n            thumbData.largeW = thumbData.zoom * w;\n            thumbData.largeH = thumbData.zoom * h;\n\n            thumbData.lensW = thumbData.w / thumbData.zoom / rate;\n            thumbData.lensH = thumbData.h / thumbData.zoom;\n        }\n\n        function _init($box, options) {\n            var opts = {};\n\n            if (options.thumb === undefined) {\n                return false;\n            }\n\n            $thumb = $box.find(options.thumb);\n\n            if ($thumb.length) {\n                for (var key in options) {\n                    opts[key] = options[key];\n                }\n\n                opts.thumb = $thumb;\n                enabled = opts.enabled;\n\n                if (_toBoolean(enabled)) {\n\n                    $largeWrapper.show().css('display', '');\n                    $largeWrapper.addClass(MagnifyCls.magnifyHidden);\n                    set(opts);\n                } else {\n                    $largeWrapper.empty().hide();\n                }\n            }\n\n            return that;\n        }\n\n        function hoverEvents(thumb) {\n            $(thumb).on('mouseover', function (e) {\n\n                if (showWrapper) {\n\n                    if (currentOpts.status !== 0) {\n                        onThumbLeave();\n                    }\n                    handleEvents(e);\n                    isOverThumb = inBounds;\n                }\n            }).trigger('mouseover');\n        }\n\n        function clickEvents(thumb) {\n            $(thumb).on('click', function (e) {\n\n                if (showWrapper) {\n                    if (!isOverThumb) {\n                        if (currentOpts.status !== 0) {\n                            onThumbLeave();\n                        }\n                        handleEvents(e);\n                        isOverThumb = true;\n                    }\n                }\n            });\n        }\n\n        function bindEvents(eType, thumb) {\n            switch (eType) {\n                case 'hover':\n                    hoverEvents(thumb);\n                    break;\n\n                case 'click':\n                    clickEvents(thumb);\n                    break;\n            }\n        }\n\n        function handleEvents(e) {\n            var src = e.target;\n\n            curIdx = src.id;\n            curThumb = src;\n\n            onThumbEnter(src);\n\n            setThumbData(curThumb, currentOpts);\n\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n            move();\n\n            var handler = currentOpts.onthumbenter;\n\n            if (handler !== null) {\n                handler({\n                    thumb: curThumb,\n                    lens: curLens,\n                    large: curLarge,\n                    x: pos.x,\n                    y: pos.y\n                });\n            }\n        }\n\n        function set(options) {\n            if (data[options.thumb.id] !== undefined) {\n                curThumb = options.thumb;\n\n                return false;\n            }\n\n            var thumbObj = new Image(),\n                largeObj = new Image(),\n                $thumb = options.thumb,\n                thumb = $thumb.get(0),\n                idx = thumb.id,\n                largeUrl,\n                largeWrapper = $(options.largeWrapper),\n                zoom = options.zoom || thumb.getAttribute('data-zoom') || gZoom,\n                zoomMin = options.zoomMin || gZoomMin,\n                zoomMax = options.zoomMax || gZoomMax,\n                mode = options.mode || thumb.getAttribute('data-mode') || gMode,\n                eventType = options.eventType || thumb.getAttribute('data-eventType') || gEventType,\n                onthumbenter = options.onthumbenter !== undefined ?\n                    options.onthumbenter\n                    : currentOpts.onthumbenter,\n                onthumbleave = options.onthumbleave !== undefined ?\n                    options.onthumbleave\n                    : currentOpts.onthumbleave,\n                onthumbmove = options.onthumbmove !== undefined ?\n                    options.onthumbmove\n                    : currentOpts.onthumbmove;\n\n            largeUrl = $thumb.data('original') || gOptions.full || $thumb.attr('src');\n\n            if (thumb.id === '') {\n                idx = thumb.id = 'magnifier-item-' + gId;\n                gId += 1;\n            }\n\n            createLens(thumb, idx);\n\n            if (options.width) {\n                largeWrapper.width(options.width);\n            }\n\n            if (options.height) {\n                largeWrapper.height(options.height);\n            }\n\n            if (options.top) {\n                if (typeof options.top == 'function') {\n                    var top = options.top() + 'px';\n                } else {\n                    var top = options.top + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.top = top.replace('%px', '%');\n                }\n            }\n\n            if (options.left) {\n                if (typeof options.left == 'function') {\n                    var left = options.left() + 'px';\n                } else {\n                    var left = options.left + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.left = left.replace('%px', '%');\n                }\n            }\n\n            data[idx] = {\n                zoom: zoom,\n                zoomMin: zoomMin,\n                zoomMax: zoomMax,\n                mode: mode,\n                eventType: eventType,\n                thumbCssClass: thumb.className,\n                zoomAttached: false,\n                status: 0,\n                largeUrl: largeUrl,\n                largeWrapperId: mode === 'outside' ? largeWrapper.attr('id') : null,\n                largeWrapperW: mode === 'outside' ? largeWrapper.width() : null,\n                largeWrapperH: mode === 'outside' ? largeWrapper.height() : null,\n                onthumbenter: onthumbenter,\n                onthumbleave: onthumbleave,\n                onthumbmove: onthumbmove\n            };\n\n            rate = $thumb.width() / $thumb.height() / (data[idx].largeWrapperW / data[idx].largeWrapperH);\n            paddingX = ($thumb.parent().width() - $thumb.width()) / 2;\n            paddingY = ($thumb.parent().height() - $thumb.height()) / 2;\n\n            showWrapper = false;\n            $(thumbObj).on('load', function () {\n                data[idx].status = 1;\n\n                $(largeObj).on('load', function () {\n\n                    if (largeObj.width > largeWrapper.width() || largeObj.height > largeWrapper.height()) {\n                        showWrapper = true;\n                        bindEvents(eventType, thumb);\n                        data[idx].status = 2;\n                        data[idx].zoom = largeObj.height / largeWrapper.height();\n                        setThumbData(thumb, data[idx]);\n                        updateLensOnLoad(idx, thumb, largeObj, largeWrapper);\n                    }\n                });\n\n                largeObj.src = data[idx].largeUrl;\n            });\n\n            thumbObj.src = thumb.src;\n        }\n\n        function onMousemove(e) {\n\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n\n            if (gEventType === 'hover') {\n                isOverThumb = inBounds;\n            }\n\n            if (inBounds && isOverThumb) {\n                $largeWrapper.removeClass(MagnifyCls.magnifyHidden);\n                move();\n            } else {\n                onThumbLeave();\n                isOverThumb = false;\n                $largeWrapper.addClass(MagnifyCls.magnifyHidden);\n            }\n        }\n\n        function onScroll() {\n\n            if (curThumb !== null) {\n                setThumbData(curThumb, currentOpts);\n            }\n        }\n\n        $(window).on('scroll', onScroll);\n        $(window).resize(function () {\n            _init($box, gOptions);\n        });\n\n        $(document).on('mousemove', onMousemove);\n        _init($box, gOptions);\n\n    }\n}(jQuery));\n","magnifier/magnify.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'magnifier/magnifier'\n], function ($, _) {\n    'use strict';\n\n    return function (config, element) {\n\n        var isTouchEnabled = 'ontouchstart' in document.documentElement,\n            gallerySelector = '[data-gallery-role=\"gallery\"]',\n            magnifierSelector = '[data-gallery-role=\"magnifier\"]',\n            magnifierZoomSelector = '[data-gallery-role=\"magnifier-zoom\"]',\n            zoomInButtonSelector = '[data-gallery-role=\"fotorama__zoom-in\"]',\n            zoomOutButtonSelector = '[data-gallery-role=\"fotorama__zoom-out\"]',\n            fullscreenImageSelector = '[data-gallery-role=\"stage-shaft\"] [data-active=\"true\"] .fotorama__img--full',\n            imageDraggableClass = 'fotorama__img--draggable',\n            imageZoommable = 'fotorama__img--zoommable',\n            zoomInLoaded = 'zoom-in-loaded',\n            zoomOutLoaded = 'zoom-out-loaded',\n            zoomInDisabled = 'fotorama__zoom-in--disabled',\n            zoomOutDisabled = 'fotorama__zoom-out--disabled',\n            keyboardNavigation,\n            videoContainerClass = 'fotorama-video-container',\n            hideMagnifier,\n            dragFlag,\n            endX,\n            transitionEnabled,\n            transitionActive = false,\n            tapFlag = 0,\n            allowZoomOut = false,\n            allowZoomIn = true;\n\n        if (isTouchEnabled) {\n            $(element).on('fotorama:showend fotorama:load', function () {\n                $(magnifierSelector).remove();\n                $(magnifierZoomSelector).remove();\n            });\n        }\n\n        (function () {\n            var style = document.documentElement.style,\n                transitionEnabled = style.transition !== undefined ||\n                style.WebkitTransition !== undefined ||\n                style.MozTransition !== undefined ||\n                style.MsTransition !== undefined ||\n                style.OTransition !== undefined;\n        })();\n\n        /**\n         * Return width and height of original image\n         * @param src path for original image\n         * @returns {{rw: number, rh: number}}\n         */\n        function getImageSize(src) {\n            var img = new Image(),\n                imgSize = {\n                    rw: 0,\n                    rh: 0\n                };\n\n            img.src = src;\n            imgSize.rw = img.width;\n            imgSize.rh = img.height;\n\n            return imgSize;\n        }\n\n        /**\n         * Sets min-height and min-width for image to avoid transition bug\n         * @param $image - fullscreen image\n         */\n        function calculateMinSize($image) {\n\n            var minHeight,\n                minWidth,\n                height = $image.height(),\n                width = $image.width(),\n                parentHeight = $image.parent().height(),\n                parentWidth = $image.parent().width();\n\n            if (width > parentWidth || height > parentHeight) {\n\n                if (width / height < parentWidth / parentHeight) {\n                    minHeight = parentHeight;\n                    minWidth = width * (parentHeight / height);\n                } else {\n                    minWidth = parentWidth;\n                    minHeight = height * parentWidth / width;\n                }\n                $image.css({\n                    'min-width': minWidth,\n                    'min-height': minHeight\n                });\n            }\n        }\n\n        function toggleZoomable($image, flag) {\n            if (flag) {\n                $image.css({\n                    'min-width': $image.width(),\n                    'min-height': $image.height(),\n                    'width': $image.width(),\n                    'height': $image.height()\n                }).addClass(imageZoommable);\n            } else {\n                $image.css({\n                    width: '',\n                    height: '',\n                    top: '',\n                    left: '',\n                    right: '',\n                    bottom: ''\n                }).removeClass(imageZoommable);\n                calculateMinSize($image);\n            }\n        }\n\n        function resetVars($image) {\n            allowZoomIn = true;\n            allowZoomOut = dragFlag = transitionActive = false;\n            $image.hasClass(imageDraggableClass) && $image.removeClass(imageDraggableClass);\n            toggleZoomable($image, false);\n        }\n\n        /**\n         * Set state for zoom controls.\n         * If state is true, zoom controls will be visible.\n         * IF state is false, zoom controls will be hidden.\n         * @param isHide\n         */\n        function hideZoomControls(isHide) {\n            if (isHide) {\n                $(zoomInButtonSelector).addClass(zoomInDisabled);\n                $(zoomOutButtonSelector).addClass(zoomOutDisabled);\n            } else {\n                $(zoomInButtonSelector).removeClass(zoomInDisabled);\n                $(zoomOutButtonSelector).removeClass(zoomOutDisabled);\n            }\n        }\n\n        /**\n         * Asynchronus control visibility of zoom buttons.\n         * If image bigger than her wrapper. Zoom controls must visible.\n         * @param path - image source path\n         * @param $image\n         */\n        function asyncToggleZoomButtons(path, $image) {\n            var img = new Image();\n\n            img.onload = function () {\n                this.height > $image.parent().height() || this.width > $image.parent().width() ?\n                    hideZoomControls(false) : hideZoomControls(true);\n            };\n            img.src = path;\n        }\n\n        /**\n         * Control visibility of zoom buttons.\n         * Zoom controls must be invisible for video content and touch devices.\n         * On touch devices active pinchIn/pinchOut.\n         * @param $image\n         * @param isTouchScreen - true for touch devices\n         * @param isVideoActiveFrame - true for active video frame\n         */\n        function toggleZoomButtons($image, isTouchScreen, isVideoActiveFrame) {\n            var path = $image.attr('src');\n\n            if (path && !isTouchScreen && !isVideoActiveFrame) {\n                asyncToggleZoomButtons(path, $image);\n            } else {\n                hideZoomControls(true);\n            }\n        }\n\n        /**\n         * Handle resize event in fullscreen.\n         * @param $image - Fullscreen image.\n         * @param e - Event.\n         */\n        function resizeHandler(e, $image) {\n            var imageSize,\n                parentWidth,\n                parentHeight,\n                isImageSmall,\n                isImageFit;\n\n            if (!e.data.$image || !e.data.$image.length)\n                return;\n\n            imageSize = getImageSize($(fullscreenImageSelector)[0].src);\n            parentWidth = e.data.$image.parent().width();\n            parentHeight = e.data.$image.parent().height();\n            isImageSmall = parentWidth >= imageSize.rw && parentHeight >= imageSize.rh;\n            isImageFit = parentWidth > e.data.$image.width() && parentHeight > e.data.$image.height();\n\n            toggleZoomButtons(e.data.$image, isTouchEnabled, checkForVideo(e.data.fotorama.activeFrame.$stageFrame));\n            calculateMinSize(e.data.$image);\n\n            if (e.data.$image.hasClass(imageZoommable) && !allowZoomOut || isImageSmall || isImageFit) {\n                resetVars(e.data.$image);\n            }\n\n            if (!isImageSmall) {\n                toggleStandartNavigation();\n            }\n        }\n\n        function getTopValue($image, topProp, step, height, containerHeight) {\n            var top;\n\n            if (parseInt($image.css('marginTop')) || parseInt($image.css('marginLeft'))) {\n                top = dragFlag ? topProp - step / 4 : 0;\n                top = top < containerHeight - height ? containerHeight - height : top;\n                top = top > height - containerHeight ? height - containerHeight : top;\n            } else {\n                top = topProp + step / 2;\n                top = top < containerHeight - height ? containerHeight - height : top;\n                top = top > 0 ? 0 : top;\n\n                if (!dragFlag && step < 0) {\n                    top = top < (containerHeight - height) / 2 ? (containerHeight - height) / 2 : top;\n                }\n            }\n\n            return top;\n        }\n\n        function getLeftValue(leftProp, step, width, containerWidth) {\n            var left;\n\n            left = leftProp + step / 2;\n            left = left < containerWidth - width ? containerWidth - width : left;\n            left = left > 0 ? 0 : left;\n\n            if (!dragFlag && step < 0) {\n                left = left < (containerWidth - width) / 2 ? (containerWidth - width) / 2 : left;\n            }\n\n            return left;\n        }\n\n        function checkFullscreenImagePosition($image, dimentions, widthStep, heightStep) {\n            var $imageContainer,\n                containerWidth,\n                containerHeight,\n                settings,\n                top,\n                left,\n                right,\n                bottom,\n                ratio;\n\n            if ($(gallerySelector).data('fotorama').fullScreen) {\n                transitionActive = true;\n                $imageContainer = $image.parent();\n                containerWidth = $imageContainer.width();\n                containerHeight = $imageContainer.height();\n                top = $image.position().top;\n                left = $image.position().left;\n                ratio = $image.width() / $image.height();\n                dimentions.height = isNaN(dimentions.height) ? dimentions.width / ratio : dimentions.height;\n                dimentions.width = isNaN(dimentions.width) ? dimentions.height * ratio : dimentions.width;\n\n                top = dimentions.height >= containerHeight ?\n                    getTopValue($image, top, heightStep, dimentions.height, containerHeight) : 0;\n\n                left = dimentions.width >= containerWidth ?\n                    getLeftValue(left, widthStep, dimentions.width, containerWidth) : 0;\n\n                right = dragFlag && left < (containerWidth - dimentions.width) / 2 ? 0 : left;\n                bottom = dragFlag ? 0 : top;\n\n                settings = $.extend(dimentions, {\n                    top: top,\n                    bottom: bottom,\n                    left: left,\n                    right: right\n                });\n\n                $image.css(settings);\n            }\n        }\n\n        /**\n         * Toggles fotorama's keyboard and mouse/touch navigation.\n         */\n        function toggleStandartNavigation() {\n            var $selectable =\n                    $('a[href], area[href], input, select, textarea, button, iframe, object, embed, *[tabindex], *[contenteditable]')\n                    .not('[tabindex=-1], [disabled], :hidden'),\n                fotorama = $(gallerySelector).data('fotorama'),\n                $focus = $(':focus'),\n                index;\n\n            if (fotorama.fullScreen) {\n\n                $selectable.each(function (number) {\n\n                    if ($(this).is($focus)) {\n                        index = number;\n                    }\n                });\n\n                fotorama.setOptions({\n                    swipe: !allowZoomOut,\n                    keyboard: !allowZoomOut\n                });\n\n                if (_.isNumber(index)) {\n                    $selectable.eq(index).focus();\n                }\n            }\n        }\n\n        function zoomIn(e, xStep, yStep) {\n            var $image,\n                imgOriginalSize,\n                imageWidth,\n                imageHeight,\n                zoomWidthStep,\n                zoomHeightStep,\n                widthResult,\n                heightResult,\n                ratio,\n                dimentions = {};\n\n            if (allowZoomIn && (!transitionEnabled || !transitionActive) && (isTouchEnabled ||\n                !$(zoomInButtonSelector).hasClass(zoomInDisabled))) {\n                $image = $(fullscreenImageSelector);\n                imgOriginalSize = getImageSize($image[0].src);\n                imageWidth = $image.width();\n                imageHeight = $image.height();\n                ratio = imageWidth / imageHeight;\n                allowZoomOut = true;\n                toggleStandartNavigation();\n\n                if (!$image.hasClass(imageZoommable)) {\n                    toggleZoomable($image, true);\n                }\n\n                e.preventDefault();\n\n                if (imageWidth >= imageHeight) {\n                    zoomWidthStep = xStep || Math.ceil(imageWidth * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    widthResult = imageWidth + zoomWidthStep;\n\n                    if (widthResult >= imgOriginalSize.rw) {\n                        widthResult = imgOriginalSize.rw;\n                        zoomWidthStep = xStep || widthResult - imageWidth;\n                        allowZoomIn = false;\n                    }\n                    heightResult = widthResult / ratio;\n                    zoomHeightStep = yStep || heightResult - imageHeight;\n                } else {\n                    zoomHeightStep = yStep || Math.ceil(imageHeight * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    heightResult = imageHeight + zoomHeightStep;\n\n                    if (heightResult >= imgOriginalSize.rh) {\n                        heightResult = imgOriginalSize.rh;\n                        zoomHeightStep = yStep || heightResult - imageHeight;\n                        allowZoomIn = false;\n                    }\n                    widthResult = heightResult * ratio;\n                    zoomWidthStep = xStep || widthResult - imageWidth;\n                }\n\n                if (imageWidth >= imageHeight && imageWidth !== imgOriginalSize.rw) {\n                    dimentions = $.extend(dimentions, {\n                        width: widthResult,\n                        height: 'auto'\n                    });\n                    checkFullscreenImagePosition($image, dimentions, -zoomWidthStep, -zoomHeightStep);\n\n                } else if (imageWidth < imageHeight && imageHeight !== imgOriginalSize.rh) {\n                    dimentions = $.extend(dimentions, {\n                        width: 'auto',\n                        height: heightResult\n                    });\n                    checkFullscreenImagePosition($image, dimentions, -zoomWidthStep, -zoomHeightStep);\n                }\n            }\n\n            return false;\n        }\n\n        function zoomOut(e, xStep, yStep) {\n            var $image,\n                widthResult,\n                heightResult,\n                dimentions,\n                parentWidth,\n                parentHeight,\n                imageWidth,\n                imageHeight,\n                zoomWidthStep,\n                zoomHeightStep,\n                ratio,\n                fitIntoParent;\n\n            if (allowZoomOut && (!transitionEnabled || !transitionActive) && (isTouchEnabled ||\n                !$(zoomOutButtonSelector).hasClass(zoomOutDisabled))) {\n                allowZoomIn = true;\n                $image = $(fullscreenImageSelector);\n                parentWidth = $image.parent().width();\n                parentHeight = $image.parent().height();\n                imageWidth = $image.width();\n                imageHeight = $image.height();\n                ratio = imageWidth / imageHeight;\n\n                e.preventDefault();\n\n                if (imageWidth >= imageHeight) {\n                    zoomWidthStep = xStep || Math.ceil(imageWidth * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    widthResult = imageWidth - zoomWidthStep;\n                    heightResult = widthResult / ratio;\n                    zoomHeightStep = yStep || imageHeight - heightResult;\n                } else {\n                    zoomHeightStep = yStep || Math.ceil(imageHeight * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    heightResult = imageHeight - zoomHeightStep;\n                    widthResult = heightResult * ratio;\n                    zoomWidthStep = xStep || imageWidth - widthResult;\n                }\n\n                fitIntoParent = function () {\n                    if (ratio > parentWidth / parentHeight) {\n                        widthResult = parentWidth;\n                        zoomWidthStep = imageWidth - widthResult;\n                        heightResult = widthResult / ratio;\n                        zoomHeightStep = imageHeight - heightResult;\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                    } else {\n                        heightResult = parentHeight;\n                        zoomHeightStep = imageHeight - heightResult;\n                        widthResult = heightResult * ratio;\n                        zoomWidthStep = imageWidth - widthResult;\n                        dimentions = {\n                            width: 'auto',\n                            height: heightResult\n                        };\n                    }\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                };\n\n                if (imageWidth >= imageHeight) {\n                    if (widthResult > parentWidth) {\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                        checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                    } else if (heightResult > parentHeight) {\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                        checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                    } else {\n                        allowZoomOut = dragFlag = false;\n                        toggleStandartNavigation();\n                        fitIntoParent();\n                    }\n                } else if (heightResult > parentHeight) {\n                    dimentions = {\n                        width: 'auto',\n                        height: heightResult\n                    };\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                } else if (widthResult > parentWidth) {\n                    dimentions = {\n                        width: 'auto',\n                        height: heightResult\n                    };\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                } else {\n                    allowZoomOut = dragFlag = false;\n                    toggleStandartNavigation();\n                    fitIntoParent();\n                }\n            }\n\n            return false;\n        }\n\n        /**\n         * Bind event on scroll on active item in fotorama\n         * @param e\n         * @param fotorama - object of fotorama\n         */\n        function mousewheel(e, fotorama, element) {\n            var $fotoramaStage = fotorama.activeFrame.$stageFrame,\n                fotoramaStage = $fotoramaStage.get(0);\n\n            function onWheel(e) {\n                var delta = e.deltaY || e.wheelDelta,\n                    ev = e || window.event;\n\n                if ($(gallerySelector).data('fotorama').fullScreen) {\n\n                    if (e.deltaY) {\n                        if (delta > 0) {\n                            zoomOut(ev);\n                        } else {\n                            zoomIn(ev);\n                        }\n                    } else if (delta > 0) {\n                        zoomIn(ev);\n                    } else {\n                        zoomOut(ev);\n                    }\n\n                    e.preventDefault ? e.preventDefault() : e.returnValue = false;\n                }\n            }\n\n            if (!$fotoramaStage.hasClass('magnify-wheel-loaded')) {\n                if (fotoramaStage && fotoramaStage.addEventListener) {\n                    if ('onwheel' in document) {\n                        fotoramaStage.addEventListener('wheel', onWheel);\n                    } else if ('onmousewheel' in document) {\n                        fotoramaStage.addEventListener('mousewheel', onWheel);\n                    } else {\n                        fotoramaStage.addEventListener('MozMousePixelScroll', onWheel);\n                    }\n                    $fotoramaStage.addClass('magnify-wheel-loaded');\n                }\n            }\n        }\n\n        /**\n         * Method which makes draggable picture. Also work on touch devices.\n         */\n        function magnifierFullscreen(fotorama) {\n            var isDragActive = false,\n                startX,\n                startY,\n                imagePosX,\n                imagePosY,\n                touch,\n                swipeSlide,\n                $gallery = $(gallerySelector),\n                $image = $(fullscreenImageSelector, $gallery),\n                $imageContainer = $('[data-gallery-role=\"stage-shaft\"] [data-active=\"true\"]'),\n                gallery = $gallery.data('fotorama'),\n                pinchDimention;\n\n            swipeSlide = _.throttle(function (direction) {\n                $(gallerySelector).data('fotorama').show(direction);\n            }, 500, {\n                trailing: false\n            });\n\n            function shiftImage(dx, dy, e) {\n                var top = +imagePosY + dy,\n                    left = +imagePosX + dx,\n                    swipeCondition = $image.width() / 10 + 20;\n\n                dragFlag = true;\n\n                if ($image.offset().left === $imageContainer.offset().left + $imageContainer.width() - $image.width() && e.keyCode === 39 ||\n                    endX - 1 < $imageContainer.offset().left + $imageContainer.width() - $image.width() && dx < 0 &&\n                    _.isNumber(endX) &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    endX = null;\n                    swipeSlide('>');\n\n                    return;\n                }\n\n                if ($image.offset().left === $imageContainer.offset().left && dx !== 0 && e.keyCode === 37 ||\n                    endX === $imageContainer.offset().left && dx > 0 &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    endX = null;\n                    swipeSlide('<');\n\n                    return;\n                }\n\n                if ($image.height() > $imageContainer.height()) {\n\n                    if ($imageContainer.offset().top + $imageContainer.height() > top + $image.height()) {\n                        top = $imageContainer.offset().top + $imageContainer.height() - $image.height();\n                    } else {\n                        top = $imageContainer.offset().top < top ? 0 : top;\n                    }\n                    $image.offset({\n                        'top': top\n                    });\n                    $image.css('bottom', '');\n                }\n\n                if ($image.width() > $imageContainer.width()) {\n\n                    if ($imageContainer.offset().left + $imageContainer.width() > left + $image.width()) {\n                        left = $imageContainer.offset().left + $imageContainer.width() - $image.width();\n                    } else {\n                        left = $imageContainer.offset().left < left ? $imageContainer.offset().left : left;\n                    }\n                    $image.offset({\n                        'left': left\n                    });\n                    $image.css('right', '');\n                } else if (Math.abs(dy) < 1 && allowZoomOut &&\n                    !(e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    dx < 0 ? $(gallerySelector).data('fotorama').show('>') : $(gallerySelector).data('fotorama').show('<');\n                }\n\n                if ($image.width() <= $imageContainer.width() && allowZoomOut &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove') &&\n                    Math.abs(dx) > Math.abs(dy) && Math.abs(dx) > swipeCondition) {\n                    dx < 0 ? swipeSlide('>') : swipeSlide('<');\n                }\n            }\n\n            /**\n             * Sets image size to original or fit in parent block\n             * @param e - event object\n             */\n            function dblClickHandler(e) {\n                var imgOriginalSize = getImageSize($image[0].src),\n                    proportions;\n\n                if (imgOriginalSize.rh < $image.parent().height() && imgOriginalSize.rw < $image.parent().width()) {\n                    return;\n                }\n\n                proportions = imgOriginalSize.rw / imgOriginalSize.rh;\n\n                if (allowZoomIn) {\n                    zoomIn(e, imgOriginalSize.rw - $image.width(), imgOriginalSize.rh - $image.height());\n                } else if (proportions > $imageContainer.width() / $imageContainer.height()) {\n                    zoomOut(e, imgOriginalSize.rw - $imageContainer.width(), imgOriginalSize.rw / proportions);\n                } else {\n                    zoomOut(e, imgOriginalSize.rw * proportions, imgOriginalSize.rh - $imageContainer.height());\n                }\n            }\n\n            function detectDoubleTap(e) {\n                var now = new Date().getTime(),\n                    timesince = now - tapFlag;\n\n                if (timesince < 400 && timesince > 0) {\n                    transitionActive = false;\n                    tapFlag = 0;\n                    dblClickHandler(e);\n                } else {\n                    tapFlag = new Date().getTime();\n                }\n            }\n\n            if (isTouchEnabled) {\n                $image.off('tap');\n                $image.on('tap', function (e) {\n                    if (e.originalEvent.originalEvent.touches.length === 0) {\n                        detectDoubleTap(e);\n                    }\n                });\n            } else {\n                $image.unbind('dblclick');\n                $image.dblclick(dblClickHandler);\n            }\n\n            if (gallery.fullScreen) {\n                toggleZoomButtons($image, isTouchEnabled, checkForVideo(fotorama.activeFrame.$stageFrame));\n            }\n\n            function getDimention(event) {\n                return Math.sqrt(\n                    (event.touches[0].clientX - event.touches[1].clientX) * (event.touches[0].clientX - event.touches[1].clientX) +\n                    (event.touches[0].clientY - event.touches[1].clientY) * (event.touches[0].clientY - event.touches[1].clientY));\n            }\n\n            $image.off(isTouchEnabled ? 'touchstart' : 'pointerdown mousedown MSPointerDown');\n            $image.on(isTouchEnabled ? 'touchstart' : 'pointerdown mousedown MSPointerDown', function (e) {\n                if (e && e.originalEvent.touches && e.originalEvent.touches.length >= 2) {\n                    e.preventDefault();\n                    pinchDimention = getDimention(e.originalEvent);\n                    isDragActive = false;\n\n                    if ($image.hasClass(imageDraggableClass)) {\n                        $image.removeClass(imageDraggableClass);\n                    }\n                } else if (gallery.fullScreen && (!transitionEnabled || !transitionActive)) {\n                    e.preventDefault();\n\n                    imagePosY = $image.offset().top;\n                    imagePosX = $image.offset().left;\n\n                    if (isTouchEnabled) {\n                        touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];\n                        e.clientX = touch.pageX;\n                        e.clientY = touch.pageY;\n                    }\n                    startX = e.clientX || e.originalEvent.clientX;\n                    startY = e.clientY || e.originalEvent.clientY;\n                    isDragActive = true;\n                }\n\n                if ($image.offset() && $image.width() > $imageContainer.width()) {\n                    endX = $image.offset().left;\n                }\n            });\n\n            $image.off(isTouchEnabled ? 'touchmove' : 'mousemove pointermove MSPointerMove');\n            $image.on(isTouchEnabled ? 'touchmove' : 'mousemove pointermove MSPointerMove', function (e) {\n                if (e && e.originalEvent.touches && e.originalEvent.touches.length >= 2) {\n                    e.preventDefault();\n                    var currentDimention = getDimention(e.originalEvent);\n\n                    if ($image.hasClass(imageDraggableClass)) {\n                        $image.removeClass(imageDraggableClass);\n                    }\n\n                    if (currentDimention < pinchDimention) {\n                        zoomOut(e);\n                        pinchDimention = currentDimention;\n                    } else if (currentDimention > pinchDimention) {\n                        zoomIn(e);\n                        pinchDimention = currentDimention;\n                    }\n                } else {\n                    var clientX,\n                        clientY;\n\n                    if (gallery.fullScreen && isDragActive && (!transitionEnabled || !transitionActive)) {\n\n                        if (allowZoomOut && !$image.hasClass(imageDraggableClass)) {\n                            $image.addClass(imageDraggableClass);\n                        }\n                        clientX = e.clientX || e.originalEvent.clientX;\n                        clientY = e.clientY || e.originalEvent.clientY;\n\n                        e.preventDefault();\n\n                        if (isTouchEnabled) {\n                            touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];\n                            clientX = touch.pageX;\n                            clientY = touch.pageY;\n                        }\n\n                        if (allowZoomOut) {\n                            shiftImage(clientX - startX, clientY - startY, e);\n                        }\n                    }\n                }\n            });\n\n            $image.off('transitionend webkitTransitionEnd mozTransitionEnd msTransitionEnd ');\n            $image.on('transitionend webkitTransitionEnd mozTransitionEnd msTransitionEnd', function () {\n                transitionActive = false;\n            });\n\n            if (keyboardNavigation) {\n                $(document).unbind('keydown', keyboardNavigation);\n            }\n\n            /**\n             * Replaces original navigations with better one\n             * @param e - event object\n             */\n            keyboardNavigation = function (e) {\n                var step = 40,\n                    $focus = $(':focus'),\n                    isFullScreen = $(gallerySelector).data('fotorama').fullScreen,\n                    initVars = function () {\n                        imagePosX = $(fullscreenImageSelector, $gallery).offset().left;\n                        imagePosY = $(fullscreenImageSelector, $gallery).offset().top;\n                    };\n\n                if (($focus.attr('data-gallery-role') || !$focus.length) && allowZoomOut) {\n                    if (isFullScreen) {\n                        imagePosX = $(fullscreenImageSelector, $(gallerySelector)).offset().left;\n                        imagePosY = $(fullscreenImageSelector, $(gallerySelector)).offset().top;\n                    }\n\n                    if (e.keyCode === 39) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(-step, 0, e);\n                        }\n                    }\n\n                    if (e.keyCode === 38) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(0, step, e);\n                        }\n                    }\n\n                    if (e.keyCode === 37) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(step, 0, e);\n                        }\n                    }\n\n                    if (e.keyCode === 40) {\n\n                        if (isFullScreen) {\n                            e.preventDefault();\n                            initVars();\n                            shiftImage(0, -step, e);\n                        }\n                    }\n                }\n\n                if (e.keyCode === 27 && isFullScreen && allowZoomOut) {\n                    $(gallerySelector).data('fotorama').cancelFullScreen();\n                }\n            };\n\n            /**\n             * @todo keyboard navigation through Fotorama Api.\n             */\n            $(document).keydown(keyboardNavigation);\n\n            $(document).on(isTouchEnabled ? 'touchend' : 'mouseup pointerup MSPointerUp', function (e) {\n                if (gallery.fullScreen) {\n\n                    if ($image.offset() && $image.width() > $imageContainer.width()) {\n                        endX = $image.offset().left;\n                    }\n\n                    isDragActive = false;\n                    $image.removeClass(imageDraggableClass);\n                }\n            });\n\n            $(window).off('resize', resizeHandler);\n            $(window).on('resize', {\n                $image: $image,\n                fotorama: fotorama\n            }, resizeHandler);\n        }\n\n        /**\n         * Hides magnifier preview and zoom blocks.\n         */\n        hideMagnifier = function () {\n            $(magnifierSelector).empty().hide();\n            $(magnifierZoomSelector).remove();\n        };\n\n        /**\n         * Check is active frame in gallery include video content.\n         * If true activeFrame contain video.\n         * @param $stageFrame - active frame in gallery\n         * @returns {*|Boolean}\n         */\n        function checkForVideo($stageFrame) {\n            return $stageFrame.hasClass(videoContainerClass);\n        }\n\n        /**\n         * Hides magnifier on drag and while arrow click.\n         */\n        function behaveOnDrag(e, initPos) {\n            var pos = [e.pageX, e.pageY],\n                isArrow = $(e.target).data('gallery-role') === 'arrow',\n                isClick = initPos[0] === pos[0] && initPos[1] === pos[1],\n                isImg = $(e.target).parent().data('active');\n\n            if (isArrow || isImg && !isClick) {\n                hideMagnifier();\n            }\n        }\n\n        if (config.magnifierOpts.enabled) {\n            $(element).on('pointerdown mousedown MSPointerDown', function (e) {\n                var pos = [e.pageX, e.pageY];\n\n                $(element).on('mousemove pointermove MSPointerMove', function (ev) {\n                    navigator.msPointerEnabled ? hideMagnifier() : behaveOnDrag(ev, pos);\n                });\n                $(document).on('mouseup pointerup MSPointerUp', function () {\n                    $(element).off('mousemove pointermove MSPointerMove');\n                });\n            });\n        }\n\n        $.extend(config.magnifierOpts, {\n            zoomable: false,\n            thumb: '.fotorama__img',\n            largeWrapper: '[data-gallery-role=\"magnifier\"]',\n            height: config.magnifierOpts.height || function () {\n                return $('[data-active=\"true\"]').height();\n            },\n            width: config.magnifierOpts.width || function () {\n                var productMedia = $(gallerySelector).parent().parent();\n\n                return productMedia.parent().width() - productMedia.width() - 20;\n            },\n            left: config.magnifierOpts.left || function () {\n                return $(gallerySelector).offset().left + $(gallerySelector).width() + 20;\n            },\n            top: config.magnifierOpts.top || function () {\n                return $(gallerySelector).offset().top;\n            }\n        });\n\n        $(element).on('fotorama:load fotorama:showend fotorama:fullscreenexit fotorama:ready', function (e, fotorama) {\n            var $activeStageFrame = $(gallerySelector).data('fotorama').activeFrame.$stageFrame;\n\n            if (!$activeStageFrame.find(magnifierZoomSelector).length) {\n                hideMagnifier();\n\n                if (config.magnifierOpts) {\n                    config.magnifierOpts.large = $(gallerySelector).data('fotorama').activeFrame.img;\n                    config.magnifierOpts.full = fotorama.data[fotorama.activeIndex].original;\n                    !checkForVideo($activeStageFrame) && $($activeStageFrame).magnify(config.magnifierOpts);\n                }\n            }\n        });\n\n        $(element).on('gallery:loaded', function (e) {\n            var $prevImage;\n\n            $(element).find(gallerySelector)\n                .on('fotorama:ready', function (e, fotorama) {\n                    var $zoomIn = $(zoomInButtonSelector),\n                        $zoomOut = $(zoomOutButtonSelector);\n\n                    if (!$zoomIn.hasClass(zoomInLoaded)) {\n                        $zoomIn.on('click touchstart', zoomIn);\n                        $zoomIn.on('mousedown', function (e) {\n                            e.stopPropagation();\n                        });\n\n                        $zoomIn.keyup(function (e) {\n\n                            if (e.keyCode === 13) {\n                                zoomIn(e);\n                            }\n                        });\n\n                        $(window).keyup(function (e) {\n\n                            if (e.keyCode === 107 || fotorama.fullscreen) {\n                                zoomIn(e);\n                            }\n                        });\n\n                        $zoomIn.addClass(zoomInLoaded);\n                    }\n\n                    if (!$zoomOut.hasClass(zoomOutLoaded)) {\n                        $zoomOut.on('click touchstart', zoomOut);\n                        $zoomOut.on('mousedown', function (e) {\n                            e.stopPropagation();\n                        });\n\n                        $zoomOut.keyup(function (e) {\n\n                            if (e.keyCode === 13) {\n                                zoomOut(e);\n                            }\n                        });\n\n                        $(window).keyup(function (e) {\n\n                            if (e.keyCode === 109 || fotorama.fullscreen) {\n                                zoomOut(e);\n                            }\n                        });\n\n                        $zoomOut.addClass(zoomOutLoaded);\n                    }\n                })\n                .on('fotorama:fullscreenenter fotorama:showend', function (e, fotorama) {\n                    hideMagnifier();\n\n                    if (!$(fullscreenImageSelector).is($prevImage)) {\n                        resetVars($(fullscreenImageSelector));\n                    }\n                    magnifierFullscreen(fotorama);\n                    mousewheel(e, fotorama, element);\n\n                    if ($prevImage) {\n                        calculateMinSize($prevImage);\n\n                        if (!$(fullscreenImageSelector).is($prevImage)) {\n                            resetVars($prevImage);\n                        }\n                    }\n\n                    toggleStandartNavigation();\n                })\n                .on('fotorama:load', function (e, fotorama) {\n                    if ($(gallerySelector).data('fotorama').fullScreen) {\n                        toggleZoomButtons($(fullscreenImageSelector), isTouchEnabled,\n                            checkForVideo(fotorama.activeFrame.$stageFrame));\n                    }\n                    magnifierFullscreen(fotorama);\n                })\n                .on('fotorama:show', function (e, fotorama) {\n                    $prevImage = _.clone($(fullscreenImageSelector));\n                    hideMagnifier();\n                })\n                .on('fotorama:fullscreenexit', function (e, fotorama) {\n                    resetVars($(fullscreenImageSelector));\n                    hideMagnifier();\n                    hideZoomControls(true);\n                });\n        });\n\n        return config;\n    };\n});\n","Magento_Usps/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    './shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig;\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var rules = validationRules.getRules(),\n                self = this;\n\n            $.each(rules, function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            if (!this.validationErrors.length) {\n                if (address['country_id'] == checkoutConfig.originCountryCode) { //eslint-disable-line eqeqeq\n                    return !utils.isEmpty(address.postcode);\n                }\n\n                return true;\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Usps/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                },\n                'postcode': {\n                    'required': false\n                }\n            };\n        }\n    };\n});\n","Magento_Usps/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    '../model/shipping-rates-validator',\n    '../model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    uspsShippingRatesValidator,\n    uspsShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('usps', uspsShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('usps', uspsShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_Msrp/js/msrp.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'jquery/ui',\n    'mage/dropdown',\n    'mage/template'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.addToCart', {\n        options: {\n            showAddToCart: true,\n            submitUrl: '',\n            cartButtonId: '',\n            singleOpenDropDown: true,\n            dialog: {}, // Options for mage/dropdown\n            dialogDelay: 500, // Delay in ms after resize dropdown shown again\n            origin: '', //Required, type of popup: 'msrp', 'tier' or 'info' popup\n\n            // Selectors\n            cartForm: '.form.map.checkout',\n            msrpLabelId: '#map-popup-msrp',\n            priceLabelId: '#map-popup-price',\n            popUpAttr: '[data-role=msrp-popup-template]',\n            popupCartButtonId: '#map-popup-button',\n            paypalCheckoutButons: '[data-action=checkout-form-submit]',\n            popupId: '',\n            realPrice: '',\n            isSaleable: '',\n            msrpPrice: '',\n            helpLinkId: '',\n            addToCartButton: '',\n\n            // Text options\n            productName: '',\n            addToCartUrl: ''\n        },\n\n        openDropDown: null,\n        triggerClass: 'dropdown-active',\n\n        popUpOptions: {\n            appendTo: 'body',\n            dialogContentClass: 'active',\n            closeOnMouseLeave: false,\n            autoPosition: true,\n            closeOnClickOutside: false,\n            'dialogClass': 'popup map-popup-wrapper',\n            position: {\n                my: 'left top',\n                collision: 'fit none',\n                at: 'left bottom',\n                within: 'body'\n            },\n            shadowHinter: 'popup popup-pointer'\n        },\n        popupOpened: false,\n\n        /**\n         * Creates widget instance\n         * @private\n         */\n        _create: function () {\n            if (this.options.origin === 'msrp') {\n                this.initMsrpPopup();\n            } else if (this.options.origin === 'info') {\n                this.initInfoPopup();\n            } else if (this.options.origin === 'tier') {\n                this.initTierPopup();\n            }\n            $(this.options.cartButtonId).on('click', this._addToCartSubmit.bind(this));\n        },\n\n        /**\n         * Init msrp popup\n         * @private\n         */\n        initMsrpPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $msrpPopup = $(popupDOM.innerHTML.trim());\n\n            $msrpPopup.find(this.options.productIdInput).val(this.options.productId);\n            $('body').append($msrpPopup);\n            $msrpPopup.trigger('contentUpdated');\n\n            $msrpPopup.find('button')\n                .on('click',\n                this.handleMsrpAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $msrpPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleMsrpPaypalCheckout.bind(this));\n\n            $(this.options.popupId).on('click',\n                this.openPopup.bind(this));\n\n            this.$popup = $msrpPopup;\n        },\n\n        /**\n         * Init info popup\n         * @private\n         */\n        initInfoPopup: function () {\n            var infoPopupDOM = $('[data-role=msrp-info-template]')[0],\n                $infoPopup = $(infoPopupDOM.innerHTML.trim());\n\n            $('body').append($infoPopup);\n\n            $(this.options.helpLinkId).on('click', function (e) {\n                this.popUpOptions.position.of = $(e.target);\n                $infoPopup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n                this._toggle($infoPopup);\n            }.bind(this));\n\n            this.$popup = $infoPopup;\n        },\n\n        /**\n         * Init tier price popup\n         * @private\n         */\n        initTierPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $tierPopup = $(popupDOM.innerHTML.trim());\n\n            $('body').append($tierPopup);\n            $tierPopup.find(this.options.productIdInput).val(this.options.productId);\n            this.popUpOptions.position.of = $(this.options.helpLinkId);\n\n            $tierPopup.find('button').on('click',\n                this.handleTierAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $tierPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleTierPaypalCheckout.bind(this));\n\n            $(this.options.attr).on('click', function (e) {\n                this.$popup = $tierPopup;\n                this.tierOptions = $(e.target).data('tier-price');\n                this.openPopup(e);\n            }.bind(this));\n        },\n\n        /**\n         * handle 'AddToCart' click on Msrp popup\n         * @param {Object} ev\n         *\n         * @private\n         */\n        handleMsrpAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Msrp popup\n         *\n         * @private\n         */\n        handleMsrpPaypalCheckout: function () {\n            this.closePopup(this.$popup);\n        },\n\n        /**\n         * handle 'AddToCart' click on Tier popup\n         *\n         * @param {Object} ev\n         * @private\n         */\n        handleTierAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton &&\n                this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Tier popup\n         *\n         * @private\n         */\n        handleTierPaypalCheckout: function () {\n            if (this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * Open and set up popup\n         *\n         * @param {Object} event\n         */\n        openPopup: function (event) {\n            var options = this.tierOptions || this.options;\n\n            this.popUpOptions.position.of = $(event.target);\n            this.$popup.find(this.options.msrpLabelId).html(options.msrpPrice);\n            this.$popup.find(this.options.priceLabelId).html(options.realPrice);\n            this.$popup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n            this._toggle(this.$popup);\n\n            if (!this.options.isSaleable) {\n                this.$popup.find('form').hide();\n            }\n        },\n\n        /**\n         *\n         * @param {HTMLElement} $elem\n         * @private\n         */\n        _toggle: function ($elem) {\n            $(document).on('mouseup.msrp touchend.msrp', function (e) {\n                if (!$elem.is(e.target) && $elem.has(e.target).length === 0) {\n                    this.closePopup($elem);\n                }\n            }.bind(this));\n            $(window).on('resize', function () {\n                this.closePopup($elem);\n            }.bind(this));\n        },\n\n        /**\n         *\n         * @param {HTMLElement} $elem\n         */\n        closePopup: function ($elem) {\n            $elem.dropdownDialog('close');\n            $(document).off('mouseup.msrp touchend.msrp');\n        },\n\n        /**\n         * Handler for addToCart action\n         */\n        _addToCartSubmit: function () {\n            this.element.trigger('addToCart', this.element);\n\n            if (this.element.data('stop-processing')) {\n                return false;\n            }\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n\n                return false;\n            }\n\n            if (this.options.addToCartUrl) {\n                $('.mage-dropdown-dialog > .ui-dialog-content').dropdownDialog('close');\n            }\n            $(this.options.cartForm).submit();\n\n        }\n    });\n\n    return $.mage.addToCart;\n});\n","Magento_Msrp/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/minicart/subtotal/totals',\n    'underscore'\n], function (Component, _) {\n    'use strict';\n\n    return Component.extend({\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.displaySubtotal(this.isMsrpApplied(this.cart().items));\n            this.cart.subscribe(function (updatedCart) {\n\n                this.displaySubtotal(this.isMsrpApplied(updatedCart.items));\n            }, this);\n        },\n\n        /**\n         * Determine if subtotal should be hidden.\n         * @param {Array} cartItems\n         * @return {Boolean}\n         */\n        isMsrpApplied: function (cartItems) {\n            return !_.find(cartItems, function (item) {\n                if (_.has(item, 'canApplyMsrp')) {\n                    return item.canApplyMsrp;\n                }\n\n                return false;\n            });\n        }\n    });\n});\n","Magento_Msrp/js/product/list/columns/msrp-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Catalog/js/product/list/columns/price-box',\n    'Magento_Catalog/js/product/addtocart-button',\n    'mage/dropdown'\n], function ($, _, PriceBox) {\n    'use strict';\n\n    return PriceBox.extend({\n        defaults: {\n            priceBoxSelector: '[data-role=msrp-price-box]',\n            popupTmpl: 'Magento_Msrp/product/item/popup',\n            popupTriggerSelector: '[data-role=msrp-popup-trigger]',\n            popupSelector: '[data-role=msrp-popup]',\n            popupOptions: {\n                appendTo: 'body',\n                dialogContentClass: 'active',\n                closeOnMouseLeave: false,\n                autoPosition: true,\n                dialogClass: 'popup map-popup-wrapper',\n                position: {\n                    my: 'left top',\n                    collision: 'fit none',\n                    at: 'left bottom',\n                    within: 'body'\n                },\n                shadowHinter: 'popup popup-pointer'\n            }\n        },\n\n        /**\n         * Create and open popup with Msrp information.\n         *\n         * @param {Object} data - element data\n         * @param {DOMElement} elem - element\n         * @param {Event} event - event object\n         */\n        openPopup: function (data, elem, event) {\n            var $elem = $(elem),\n                $popup = $elem.find(this.popupSelector),\n                $trigger = $elem.find(this.popupTriggerSelector);\n\n            event.stopPropagation();\n\n            this.popupOptions.position.of = $trigger;\n            this.popupOptions.triggerTarget = $trigger;\n\n            $popup.dropdownDialog(this.popupOptions)\n                  .dropdownDialog('open');\n        },\n\n        /**\n         * Set listeners.\n         *\n         * @param {DOMElement} elem - DOM element\n         * @param {Object} data - element data\n         */\n        initListeners: function (elem, data) {\n            var $trigger = $(elem).find(this.popupTriggerSelector);\n\n            $trigger.on('click', this.openPopup.bind(this, data, elem));\n        },\n\n        /**\n         * Check whether we can apply msrp, or should use standard price.\n         *\n         * @param {Object} row\n         * @returns {Bool}\n         */\n        isMsrpApplicable: function (row) {\n            return this.getPrice(row)['is_applicable'];\n        },\n\n        /**\n         * Retrieve msrp formatted price\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getPrice: function (row) {\n            return row['price_info']['extension_attributes'].msrp;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Check if popup with actual price must be shown.\n         *\n         * @returns {Boolean}\n         */\n        isShowPriceOnGesture: function (row) {\n            return this.getPrice(row)['is_shown_price_on_gesture'];\n        },\n\n        /**\n         * Get msrp price supporting text.\n         *\n         * @returns {String}\n         */\n        getMsrpPriceMessage: function (row) {\n            return this.getPrice(row)['msrp_message'];\n        },\n\n        /**\n         * Get msrp price supporting text, when actual price is hidden.\n         *\n         * @returns {String}\n         */\n        getExplanationMessage: function (row) {\n            return this.getPrice(row)['explanation_message'];\n        }\n    });\n});\n","Magento_Ups/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'Magento_Ups/js/model/shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Ups/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'postcode': {\n                    'required': true\n                },\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Ups/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    'Magento_Ups/js/model/shipping-rates-validator',\n    'Magento_Ups/js/model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    upsShippingRatesValidator,\n    upsShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('ups', upsShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('ups', upsShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_Translation/add-class.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).addClass(config.class);\n    };\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_Weee/tax-toggle.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} config\n     * @param {jQuery.Event} e\n     */\n    function onToggle(config, e) {\n        var elem = $(e.currentTarget),\n            expandedClassName = config.expandedClassName || 'cart-tax-total-expanded';\n\n        elem.toggleClass(expandedClassName);\n\n        $(config.itemTaxId).toggle();\n    }\n\n    return function (data, el) {\n        $(el).on('click', onToggle.bind(null, data));\n    };\n});\n","Magento_Weee/js/view/cart/totals/weee.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Weee/js/view/checkout/summary/weee'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n\n        /**\n         * @override\n         */\n        isFullMode: function () {\n            return true;\n        }\n    });\n});\n","Magento_Weee/js/view/checkout/summary/weee.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Catalog/js/price-utils'\n], function (Component, quote, totals) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Weee/checkout/summary/weee'\n        },\n        isIncludedInSubtotal: window.checkoutConfig.isIncludedInSubtotal,\n        totals: totals.totals,\n\n        /**\n         * @returns {Number}\n         */\n        getWeeeTaxSegment: function () {\n            var weee = totals.getSegment('weee_tax') || totals.getSegment('weee');\n\n            if (weee !== null && weee.hasOwnProperty('value')) {\n                return weee.value;\n            }\n\n            return 0;\n        },\n\n        /**\n         * Get weee value\n         * @returns {String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getWeeeTaxSegment());\n        },\n\n        /**\n         * Weee display flag\n         * @returns {Boolean}\n         */\n        isDisplayed: function () {\n            return this.isFullMode() && this.getWeeeTaxSegment() > 0;\n        }\n    });\n});\n","Magento_Weee/js/view/checkout/summary/item/price/weee.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         */\n        isDisplayPriceWithWeeeDetails: function (item) {\n            if (!parseFloat(item['weee_tax_applied_amount']) || parseFloat(item['weee_tax_applied_amount'] <= 0)) {\n                return false;\n            }\n\n            return window.checkoutConfig.isDisplayPriceWithWeeeDetails;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         */\n        isDisplayFinalPrice: function (item) {\n            if (!parseFloat(item['weee_tax_applied_amount'])) {\n                return false;\n            }\n\n            return window.checkoutConfig.isDisplayFinalPrice;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Array}\n         */\n        getWeeeTaxApplied: function (item) {\n            if (item['weee_tax_applied']) {\n                return JSON.parse(item['weee_tax_applied']);\n            }\n\n            return [];\n        }\n    });\n});\n","Magento_Weee/js/view/checkout/summary/item/price/row_excl_tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Weee/js/view/checkout/summary/item/price/weee'\n], function (weee) {\n    'use strict';\n\n    return weee.extend({\n        defaults: {\n            template: 'Magento_Weee/checkout/summary/item/price/row_excl_tax'\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getFinalRowDisplayPriceExclTax: function (item) {\n            var rowTotalExclTax = parseFloat(item['row_total']);\n\n            if (!window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalExclTax += parseFloat(item['weee_tax_applied_amount']);\n            }\n\n            return rowTotalExclTax;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getRowDisplayPriceExclTax: function (item) {\n            var rowTotalExclTax = parseFloat(item['row_total']);\n\n            if (window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalExclTax += this.getRowWeeeTaxExclTax(item);\n            }\n\n            return rowTotalExclTax;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getRowWeeeTaxExclTax: function (item) {\n            var totalWeeeTaxExclTaxApplied = 0,\n                weeeTaxAppliedAmounts;\n\n            if (item['weee_tax_applied']) {\n                weeeTaxAppliedAmounts = JSON.parse(item['weee_tax_applied']);\n                weeeTaxAppliedAmounts.forEach(function (weeeTaxAppliedAmount) {\n                    totalWeeeTaxExclTaxApplied += parseFloat(Math.max(weeeTaxAppliedAmount['row_amount'], 0));\n                });\n            }\n\n            return totalWeeeTaxExclTaxApplied;\n        }\n\n    });\n});\n","Magento_Weee/js/view/checkout/summary/item/price/row_incl_tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Weee/js/view/checkout/summary/item/price/weee'\n], function (weee) {\n    'use strict';\n\n    return weee.extend({\n        defaults: {\n            template: 'Magento_Weee/checkout/summary/item/price/row_incl_tax',\n            displayArea: 'row_incl_tax'\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getFinalRowDisplayPriceInclTax: function (item) {\n            var rowTotalInclTax = parseFloat(item['row_total_incl_tax']);\n\n            if (!window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalInclTax += this.getRowWeeeTaxInclTax(item);\n            }\n\n            return rowTotalInclTax;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getRowDisplayPriceInclTax: function (item) {\n            var rowTotalInclTax = parseFloat(item['row_total_incl_tax']);\n\n            if (window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalInclTax += this.getRowWeeeTaxInclTax(item);\n            }\n\n            return rowTotalInclTax;\n        },\n\n        /**\n         * @param {Object}item\n         * @return {Number}\n         */\n        getRowWeeeTaxInclTax: function (item) {\n            var totalWeeeTaxInclTaxApplied = 0,\n                weeeTaxAppliedAmounts;\n\n            if (item['weee_tax_applied']) {\n                weeeTaxAppliedAmounts = JSON.parse(item['weee_tax_applied']);\n                weeeTaxAppliedAmounts.forEach(function (weeeTaxAppliedAmount) {\n                    totalWeeeTaxInclTaxApplied += parseFloat(Math.max(weeeTaxAppliedAmount['row_amount_incl_tax'], 0));\n                });\n            }\n\n            return totalWeeeTaxInclTaxApplied;\n        }\n\n    });\n});\n","Magento_Weee/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Weee/price/adjustment',\n            dataSource: '${ $.parentName }.provider',\n            //Weee configuration constants can be configured from backend\n            inclFptWithDesc: 1,//show FPT and description\n            inclFpt: 0, //show FPT attribute\n            exclFpt: 2, //do not show FPT\n            bothFptPrices: 3 //show price without FPT and with FPT and with description\n        },\n\n        /**\n         * Get Weee attributes.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeAttributes: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'];\n        },\n\n        /**\n         * Get Weee without Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTax: function (taxAmount) {\n            return taxAmount['amount_excl_tax'];\n        },\n\n        /**\n         * Get Weee with Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTax: function (taxAmount) {\n            return taxAmount['tax_amount_incl_tax'];\n        },\n\n        /**\n         * Get Weee Tax name.\n         *\n         * @param {String} taxAmount\n         * @return {String} Weee name\n         */\n        getWeeTaxAttributeName: function (taxAmount) {\n            return taxAmount['attribute_code'];\n        },\n\n        /**\n         * Set price type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Check if Weee Tax must be shown.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isShown: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'].length;\n        },\n\n        /**\n         * Get Weee final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustment: function (row) {\n            return row['price_info']['extension_attributes']['weee_adjustment'];\n        },\n\n        /**\n         * Return whether display setting is to display price including FPT only.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFpt: function () {\n            return +this.source.data.displayWeee === this.inclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * price including FPT and FPT description.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFptDescr: function () {\n            return +this.source.data.displayWeee === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price\n         * excluding FPT but including FPT description and final price.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFptDescr: function () {\n            return +this.source.data.displayWeee === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding FPT.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFpt: function () {\n            return +this.source.data.displayWeee === this.bothFptPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclTax: function () {\n            return +this.source.data.displayTaxes === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPricesTax: function () {\n            return +this.source.data.displayTaxes === this.bothFptPrices;\n        }\n    });\n});\n","ExtensionHawk_Stamps/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [\n        'jquery',\n        'mageUtils',\n        './shipping-rates-validation-rules',\n        'mage/translate'\n    ],\n    function ($, utils, validationRules, $t) {\n        \"use strict\";\n        return {\n            validationErrors: [],\n            validate: function (address) {\n                var self = this;\n                this.validationErrors = [];\n                $.each(validationRules.getRules(), function (field, rule) {\n                    if (rule.required && utils.isEmpty(address[field])) {\n                        var message = $t('Field ') + field + $t(' is required.');\n                        self.validationErrors.push(message);\n                    }\n                });\n                return !Boolean(this.validationErrors.length);\n            }\n        };\n\n    }\n);","ExtensionHawk_Stamps/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*global define*/\ndefine(\n    [],\n    function () {\n        \"use strict\";\n        return {\n            getRules: function () {\n                return {\n                    'postcode': {\n                        'required': true\n                    },\n                    'country_id': {\n                        'required': true\n                    }\n                };\n            }\n        };\n    \n    }\n);","ExtensionHawk_Stamps/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/shipping-rates-validator',\n        'Magento_Checkout/js/model/shipping-rates-validation-rules',\n        '../model/shipping-rates-validator',\n        '../model/shipping-rates-validation-rules'\n    ],\n    function (\n        Component,\n        defaultShippingRatesValidator,\n        defaultShippingRatesValidationRules,\n        stampsShippingRatesValidator,\n        stampsShippingRatesValidationRules\n    ) {\n        \"use strict\";\n        defaultShippingRatesValidator.registerValidator('stamps', stampsShippingRatesValidator);\n        defaultShippingRatesValidationRules.registerRules('stamps', stampsShippingRatesValidationRules);\n        return Component;\n    }\n);\n","knockoutjs/knockout.js":"/*!\n * Knockout JavaScript library v3.3.0\n * (c) Steven Sanderson - http://knockoutjs.com/\n * License: MIT (http://www.opensource.org/licenses/mit-license.php)\n */\n\n(function(){\nvar DEBUG=true;\n(function(undefined){\n    // (0, eval)('this') is a robust way of getting a reference to the global object\n    // For details, see http://stackoverflow.com/questions/14119988/return-this-0-evalthis/14120023#14120023\n    var window = this || (0, eval)('this'),\n        document = window['document'],\n        navigator = window['navigator'],\n        jQueryInstance = window[\"jQuery\"],\n        JSON = window[\"JSON\"];\n(function(factory) {\n    // Support three module loading scenarios\n    if (typeof define === 'function' && define['amd']) {\n        // [1] AMD anonymous module\n        define(['exports', 'require'], factory);\n    } else if (typeof require === 'function' && typeof exports === 'object' && typeof module === 'object') {\n        // [2] CommonJS/Node.js\n        factory(module['exports'] || exports);  // module.exports is for Node.js\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window['ko'] = {});\n    }\n}(function(koExports, amdRequire){\n// Internally, all KO objects are attached to koExports (even the non-exported ones whose names will be minified by the closure compiler).\n// In the future, the following \"ko\" variable may be made distinct from \"koExports\" so that private objects are not externally reachable.\nvar ko = typeof koExports !== 'undefined' ? koExports : {};\n// Google Closure Compiler helpers (used only to make the minified file smaller)\nko.exportSymbol = function(koPath, object) {\n    var tokens = koPath.split(\".\");\n\n    // In the future, \"ko\" may become distinct from \"koExports\" (so that non-exported objects are not reachable)\n    // At that point, \"target\" would be set to: (typeof koExports !== \"undefined\" ? koExports : ko)\n    var target = ko;\n\n    for (var i = 0; i < tokens.length - 1; i++)\n        target = target[tokens[i]];\n    target[tokens[tokens.length - 1]] = object;\n};\nko.exportProperty = function(owner, publicName, object) {\n    owner[publicName] = object;\n};\nko.version = \"3.3.0\";\n\nko.exportSymbol('version', ko.version);\nko.utils = (function () {\n    function objectForEach(obj, action) {\n        for (var prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                action(prop, obj[prop]);\n            }\n        }\n    }\n\n    function extend(target, source) {\n        if (source) {\n            for(var prop in source) {\n                if(source.hasOwnProperty(prop)) {\n                    target[prop] = source[prop];\n                }\n            }\n        }\n        return target;\n    }\n\n    function setPrototypeOf(obj, proto) {\n        obj.__proto__ = proto;\n        return obj;\n    }\n\n    var canSetPrototype = ({ __proto__: [] } instanceof Array);\n\n    // Represent the known event types in a compact way, then at runtime transform it into a hash with event name as key (for fast lookup)\n    var knownEvents = {}, knownEventTypesByEventName = {};\n    var keyEventTypeName = (navigator && /Firefox\\/2/i.test(navigator.userAgent)) ? 'KeyboardEvent' : 'UIEvents';\n    knownEvents[keyEventTypeName] = ['keyup', 'keydown', 'keypress'];\n    knownEvents['MouseEvents'] = ['click', 'dblclick', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout', 'mouseenter', 'mouseleave'];\n    objectForEach(knownEvents, function(eventType, knownEventsForType) {\n        if (knownEventsForType.length) {\n            for (var i = 0, j = knownEventsForType.length; i < j; i++)\n                knownEventTypesByEventName[knownEventsForType[i]] = eventType;\n        }\n    });\n    var eventsThatMustBeRegisteredUsingAttachEvent = { 'propertychange': true }; // Workaround for an IE9 issue - https://github.com/SteveSanderson/knockout/issues/406\n\n    // Detect IE versions for bug workarounds (uses IE conditionals, not UA string, for robustness)\n    // Note that, since IE 10 does not support conditional comments, the following logic only detects IE < 10.\n    // Currently this is by design, since IE 10+ behaves correctly when treated as a standard browser.\n    // If there is a future need to detect specific versions of IE10+, we will amend this.\n    var ieVersion = document && (function() {\n        var version = 3, div = document.createElement('div'), iElems = div.getElementsByTagName('i');\n\n        // Keep constructing conditional HTML blocks until we hit one that resolves to an empty fragment\n        while (\n            div.innerHTML = '<!--[if gt IE ' + (++version) + ']><i></i><![endif]-->',\n            iElems[0]\n        ) {}\n        return version > 4 ? version : undefined;\n    }());\n    var isIe6 = ieVersion === 6,\n        isIe7 = ieVersion === 7;\n\n    function isClickOnCheckableElement(element, eventType) {\n        if ((ko.utils.tagNameLower(element) !== \"input\") || !element.type) return false;\n        if (eventType.toLowerCase() != \"click\") return false;\n        var inputType = element.type;\n        return (inputType == \"checkbox\") || (inputType == \"radio\");\n    }\n\n    // For details on the pattern for changing node classes\n    // see: https://github.com/knockout/knockout/issues/1597\n    var cssClassNameRegex = /\\S+/g;\n\n    function toggleDomNodeCssClass(node, classNames, shouldHaveClass) {\n        var addOrRemoveFn;\n        if (classNames) {\n            if (typeof node.classList === 'object') {\n                addOrRemoveFn = node.classList[shouldHaveClass ? 'add' : 'remove'];\n                ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                    addOrRemoveFn.call(node.classList, className);\n                });\n            } else if (typeof node.className['baseVal'] === 'string') {\n                // SVG tag .classNames is an SVGAnimatedString instance\n                toggleObjectClassPropertyString(node.className, 'baseVal', classNames, shouldHaveClass);\n            } else {\n                // node.className ought to be a string.\n                toggleObjectClassPropertyString(node, 'className', classNames, shouldHaveClass);\n            }\n        }\n    }\n\n    function toggleObjectClassPropertyString(obj, prop, classNames, shouldHaveClass) {\n        // obj/prop is either a node/'className' or a SVGAnimatedString/'baseVal'.\n        var currentClassNames = obj[prop].match(cssClassNameRegex) || [];\n        ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n            ko.utils.addOrRemoveItem(currentClassNames, className, shouldHaveClass);\n        });\n        obj[prop] = currentClassNames.join(\" \");\n    }\n\n    return {\n        fieldsIncludedWithJsonPost: ['authenticity_token', /^__RequestVerificationToken(_.*)?$/],\n\n        arrayForEach: function (array, action) {\n            for (var i = 0, j = array.length; i < j; i++)\n                action(array[i], i);\n        },\n\n        arrayIndexOf: function (array, item) {\n            if (typeof Array.prototype.indexOf == \"function\")\n                return Array.prototype.indexOf.call(array, item);\n            for (var i = 0, j = array.length; i < j; i++)\n                if (array[i] === item)\n                    return i;\n            return -1;\n        },\n\n        arrayFirst: function (array, predicate, predicateOwner) {\n            for (var i = 0, j = array.length; i < j; i++)\n                if (predicate.call(predicateOwner, array[i], i))\n                    return array[i];\n            return null;\n        },\n\n        arrayRemoveItem: function (array, itemToRemove) {\n            var index = ko.utils.arrayIndexOf(array, itemToRemove);\n            if (index > 0) {\n                array.splice(index, 1);\n            }\n            else if (index === 0) {\n                array.shift();\n            }\n        },\n\n        arrayGetDistinctValues: function (array) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++) {\n                if (ko.utils.arrayIndexOf(result, array[i]) < 0)\n                    result.push(array[i]);\n            }\n            return result;\n        },\n\n        arrayMap: function (array, mapping) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++)\n                result.push(mapping(array[i], i));\n            return result;\n        },\n\n        arrayFilter: function (array, predicate) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++)\n                if (predicate(array[i], i))\n                    result.push(array[i]);\n            return result;\n        },\n\n        arrayPushAll: function (array, valuesToPush) {\n            if (valuesToPush instanceof Array)\n                array.push.apply(array, valuesToPush);\n            else\n                for (var i = 0, j = valuesToPush.length; i < j; i++)\n                    array.push(valuesToPush[i]);\n            return array;\n        },\n\n        addOrRemoveItem: function(array, value, included) {\n            var existingEntryIndex = ko.utils.arrayIndexOf(ko.utils.peekObservable(array), value);\n            if (existingEntryIndex < 0) {\n                if (included)\n                    array.push(value);\n            } else {\n                if (!included)\n                    array.splice(existingEntryIndex, 1);\n            }\n        },\n\n        canSetPrototype: canSetPrototype,\n\n        extend: extend,\n\n        setPrototypeOf: setPrototypeOf,\n\n        setPrototypeOfOrExtend: canSetPrototype ? setPrototypeOf : extend,\n\n        objectForEach: objectForEach,\n\n        objectMap: function(source, mapping) {\n            if (!source)\n                return source;\n            var target = {};\n            for (var prop in source) {\n                if (source.hasOwnProperty(prop)) {\n                    target[prop] = mapping(source[prop], prop, source);\n                }\n            }\n            return target;\n        },\n\n        emptyDomNode: function (domNode) {\n            while (domNode.firstChild) {\n                ko.removeNode(domNode.firstChild);\n            }\n        },\n\n        moveCleanedNodesToContainerElement: function(nodes) {\n            // Ensure it's a real array, as we're about to reparent the nodes and\n            // we don't want the underlying collection to change while we're doing that.\n            var nodesArray = ko.utils.makeArray(nodes);\n            var templateDocument = (nodesArray[0] && nodesArray[0].ownerDocument) || document;\n\n            var container = templateDocument.createElement('div');\n            for (var i = 0, j = nodesArray.length; i < j; i++) {\n                container.appendChild(ko.cleanNode(nodesArray[i]));\n            }\n            return container;\n        },\n\n        cloneNodes: function (nodesArray, shouldCleanNodes) {\n            for (var i = 0, j = nodesArray.length, newNodesArray = []; i < j; i++) {\n                var clonedNode = nodesArray[i].cloneNode(true);\n                newNodesArray.push(shouldCleanNodes ? ko.cleanNode(clonedNode) : clonedNode);\n            }\n            return newNodesArray;\n        },\n\n        setDomNodeChildren: function (domNode, childNodes) {\n            ko.utils.emptyDomNode(domNode);\n            if (childNodes) {\n                for (var i = 0, j = childNodes.length; i < j; i++)\n                    domNode.appendChild(childNodes[i]);\n            }\n        },\n\n        replaceDomNodes: function (nodeToReplaceOrNodeArray, newNodesArray) {\n            var nodesToReplaceArray = nodeToReplaceOrNodeArray.nodeType ? [nodeToReplaceOrNodeArray] : nodeToReplaceOrNodeArray;\n            if (nodesToReplaceArray.length > 0) {\n                var insertionPoint = nodesToReplaceArray[0];\n                var parent = insertionPoint.parentNode;\n                for (var i = 0, j = newNodesArray.length; i < j; i++)\n                    parent.insertBefore(newNodesArray[i], insertionPoint);\n                for (var i = 0, j = nodesToReplaceArray.length; i < j; i++) {\n                    ko.removeNode(nodesToReplaceArray[i]);\n                }\n            }\n        },\n\n        fixUpContinuousNodeArray: function(continuousNodeArray, parentNode) {\n            // Before acting on a set of nodes that were previously outputted by a template function, we have to reconcile\n            // them against what is in the DOM right now. It may be that some of the nodes have already been removed, or that\n            // new nodes might have been inserted in the middle, for example by a binding. Also, there may previously have been\n            // leading comment nodes (created by rewritten string-based templates) that have since been removed during binding.\n            // So, this function translates the old \"map\" output array into its best guess of the set of current DOM nodes.\n            //\n            // Rules:\n            //   [A] Any leading nodes that have been removed should be ignored\n            //       These most likely correspond to memoization nodes that were already removed during binding\n            //       See https://github.com/SteveSanderson/knockout/pull/440\n            //   [B] We want to output a continuous series of nodes. So, ignore any nodes that have already been removed,\n            //       and include any nodes that have been inserted among the previous collection\n\n            if (continuousNodeArray.length) {\n                // The parent node can be a virtual element; so get the real parent node\n                parentNode = (parentNode.nodeType === 8 && parentNode.parentNode) || parentNode;\n\n                // Rule [A]\n                while (continuousNodeArray.length && continuousNodeArray[0].parentNode !== parentNode)\n                    continuousNodeArray.splice(0, 1);\n\n                // Rule [B]\n                if (continuousNodeArray.length > 1) {\n                    var current = continuousNodeArray[0], last = continuousNodeArray[continuousNodeArray.length - 1];\n                    // Replace with the actual new continuous node set\n                    continuousNodeArray.length = 0;\n                    while (current !== last) {\n                        continuousNodeArray.push(current);\n                        current = current.nextSibling;\n                        if (!current) // Won't happen, except if the developer has manually removed some DOM elements (then we're in an undefined scenario)\n                            return;\n                    }\n                    continuousNodeArray.push(last);\n                }\n            }\n            return continuousNodeArray;\n        },\n\n        setOptionNodeSelectionState: function (optionNode, isSelected) {\n            // IE6 sometimes throws \"unknown error\" if you try to write to .selected directly, whereas Firefox struggles with setAttribute. Pick one based on browser.\n            if (ieVersion < 7)\n                optionNode.setAttribute(\"selected\", isSelected);\n            else\n                optionNode.selected = isSelected;\n        },\n\n        stringTrim: function (string) {\n            return string === null || string === undefined ? '' :\n                string.trim ?\n                    string.trim() :\n                    string.toString().replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, '');\n        },\n\n        stringStartsWith: function (string, startsWith) {\n            string = string || \"\";\n            if (startsWith.length > string.length)\n                return false;\n            return string.substring(0, startsWith.length) === startsWith;\n        },\n\n        domNodeIsContainedBy: function (node, containedByNode) {\n            if (node === containedByNode)\n                return true;\n            if (node.nodeType === 11)\n                return false; // Fixes issue #1162 - can't use node.contains for document fragments on IE8\n            if (containedByNode.contains)\n                return containedByNode.contains(node.nodeType === 3 ? node.parentNode : node);\n            if (containedByNode.compareDocumentPosition)\n                return (containedByNode.compareDocumentPosition(node) & 16) == 16;\n            while (node && node != containedByNode) {\n                node = node.parentNode;\n            }\n            return !!node;\n        },\n\n        domNodeIsAttachedToDocument: function (node) {\n            return ko.utils.domNodeIsContainedBy(node, node.ownerDocument.documentElement);\n        },\n\n        anyDomNodeIsAttachedToDocument: function(nodes) {\n            return !!ko.utils.arrayFirst(nodes, ko.utils.domNodeIsAttachedToDocument);\n        },\n\n        tagNameLower: function(element) {\n            // For HTML elements, tagName will always be upper case; for XHTML elements, it'll be lower case.\n            // Possible future optimization: If we know it's an element from an XHTML document (not HTML),\n            // we don't need to do the .toLowerCase() as it will always be lower case anyway.\n            return element && element.tagName && element.tagName.toLowerCase();\n        },\n\n        registerEventHandler: function (element, eventType, handler) {\n            var mustUseAttachEvent = ieVersion && eventsThatMustBeRegisteredUsingAttachEvent[eventType];\n            if (!mustUseAttachEvent && jQueryInstance) {\n                jQueryInstance(element)['bind'](eventType, handler);\n            } else if (!mustUseAttachEvent && typeof element.addEventListener == \"function\")\n                element.addEventListener(eventType, handler, false);\n            else if (typeof element.attachEvent != \"undefined\") {\n                var attachEventHandler = function (event) { handler.call(element, event); },\n                    attachEventName = \"on\" + eventType;\n                element.attachEvent(attachEventName, attachEventHandler);\n\n                // IE does not dispose attachEvent handlers automatically (unlike with addEventListener)\n                // so to avoid leaks, we have to remove them manually. See bug #856\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function() {\n                    element.detachEvent(attachEventName, attachEventHandler);\n                });\n            } else\n                throw new Error(\"Browser doesn't support addEventListener or attachEvent\");\n        },\n\n        triggerEvent: function (element, eventType) {\n            if (!(element && element.nodeType))\n                throw new Error(\"element must be a DOM node when calling triggerEvent\");\n\n            // For click events on checkboxes and radio buttons, jQuery toggles the element checked state *after* the\n            // event handler runs instead of *before*. (This was fixed in 1.9 for checkboxes but not for radio buttons.)\n            // IE doesn't change the checked state when you trigger the click event using \"fireEvent\".\n            // In both cases, we'll use the click method instead.\n            var useClickWorkaround = isClickOnCheckableElement(element, eventType);\n\n            if (jQueryInstance && !useClickWorkaround) {\n                jQueryInstance(element)['trigger'](eventType);\n            } else if (typeof document.createEvent == \"function\") {\n                if (typeof element.dispatchEvent == \"function\") {\n                    var eventCategory = knownEventTypesByEventName[eventType] || \"HTMLEvents\";\n                    var event = document.createEvent(eventCategory);\n                    event.initEvent(eventType, true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, element);\n                    element.dispatchEvent(event);\n                }\n                else\n                    throw new Error(\"The supplied element doesn't support dispatchEvent\");\n            } else if (useClickWorkaround && element.click) {\n                element.click();\n            } else if (typeof element.fireEvent != \"undefined\") {\n                element.fireEvent(\"on\" + eventType);\n            } else {\n                throw new Error(\"Browser doesn't support triggering events\");\n            }\n        },\n\n        unwrapObservable: function (value) {\n            return ko.isObservable(value) ? value() : value;\n        },\n\n        peekObservable: function (value) {\n            return ko.isObservable(value) ? value.peek() : value;\n        },\n\n        toggleDomNodeCssClass: toggleDomNodeCssClass,\n\n        setTextContent: function(element, textContent) {\n            var value = ko.utils.unwrapObservable(textContent);\n            if ((value === null) || (value === undefined))\n                value = \"\";\n\n            // We need there to be exactly one child: a text node.\n            // If there are no children, more than one, or if it's not a text node,\n            // we'll clear everything and create a single text node.\n            var innerTextNode = ko.virtualElements.firstChild(element);\n            if (!innerTextNode || innerTextNode.nodeType != 3 || ko.virtualElements.nextSibling(innerTextNode)) {\n                ko.virtualElements.setDomNodeChildren(element, [element.ownerDocument.createTextNode(value)]);\n            } else {\n                innerTextNode.data = value;\n            }\n\n            ko.utils.forceRefresh(element);\n        },\n\n        setElementName: function(element, name) {\n            element.name = name;\n\n            // Workaround IE 6/7 issue\n            // - https://github.com/SteveSanderson/knockout/issues/197\n            // - http://www.matts411.com/post/setting_the_name_attribute_in_ie_dom/\n            if (ieVersion <= 7) {\n                try {\n                    element.mergeAttributes(document.createElement(\"<input name='\" + element.name + \"'/>\"), false);\n                }\n                catch(e) {} // For IE9 with doc mode \"IE9 Standards\" and browser mode \"IE9 Compatibility View\"\n            }\n        },\n\n        forceRefresh: function(node) {\n            // Workaround for an IE9 rendering bug - https://github.com/SteveSanderson/knockout/issues/209\n            if (ieVersion >= 9) {\n                // For text nodes and comment nodes (most likely virtual elements), we will have to refresh the container\n                var elem = node.nodeType == 1 ? node : node.parentNode;\n                if (elem.style)\n                    elem.style.zoom = elem.style.zoom;\n            }\n        },\n\n        ensureSelectElementIsRenderedCorrectly: function(selectElement) {\n            // Workaround for IE9 rendering bug - it doesn't reliably display all the text in dynamically-added select boxes unless you force it to re-render by updating the width.\n            // (See https://github.com/SteveSanderson/knockout/issues/312, http://stackoverflow.com/questions/5908494/select-only-shows-first-char-of-selected-option)\n            // Also fixes IE7 and IE8 bug that causes selects to be zero width if enclosed by 'if' or 'with'. (See issue #839)\n            if (ieVersion) {\n                var originalWidth = selectElement.style.width;\n                selectElement.style.width = 0;\n                selectElement.style.width = originalWidth;\n            }\n        },\n\n        range: function (min, max) {\n            min = ko.utils.unwrapObservable(min);\n            max = ko.utils.unwrapObservable(max);\n            var result = [];\n            for (var i = min; i <= max; i++)\n                result.push(i);\n            return result;\n        },\n\n        makeArray: function(arrayLikeObject) {\n            var result = [];\n            for (var i = 0, j = arrayLikeObject.length; i < j; i++) {\n                result.push(arrayLikeObject[i]);\n            };\n            return result;\n        },\n\n        isIe6 : isIe6,\n        isIe7 : isIe7,\n        ieVersion : ieVersion,\n\n        getFormFields: function(form, fieldName) {\n            var fields = ko.utils.makeArray(form.getElementsByTagName(\"input\")).concat(ko.utils.makeArray(form.getElementsByTagName(\"textarea\")));\n            var isMatchingField = (typeof fieldName == 'string')\n                ? function(field) { return field.name === fieldName }\n                : function(field) { return fieldName.test(field.name) }; // Treat fieldName as regex or object containing predicate\n            var matches = [];\n            for (var i = fields.length - 1; i >= 0; i--) {\n                if (isMatchingField(fields[i]))\n                    matches.push(fields[i]);\n            };\n            return matches;\n        },\n\n        parseJson: function (jsonString) {\n            if (typeof jsonString == \"string\") {\n                jsonString = ko.utils.stringTrim(jsonString);\n                if (jsonString) {\n                    if (JSON && JSON.parse) // Use native parsing where available\n                        return JSON.parse(jsonString);\n                    return (new Function(\"return \" + jsonString))(); // Fallback on less safe parsing for older browsers\n                }\n            }\n            return null;\n        },\n\n        stringifyJson: function (data, replacer, space) {   // replacer and space are optional\n            if (!JSON || !JSON.stringify)\n                throw new Error(\"Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js\");\n            return JSON.stringify(ko.utils.unwrapObservable(data), replacer, space);\n        },\n\n        postJson: function (urlOrForm, data, options) {\n            options = options || {};\n            var params = options['params'] || {};\n            var includeFields = options['includeFields'] || this.fieldsIncludedWithJsonPost;\n            var url = urlOrForm;\n\n            // If we were given a form, use its 'action' URL and pick out any requested field values\n            if((typeof urlOrForm == 'object') && (ko.utils.tagNameLower(urlOrForm) === \"form\")) {\n                var originalForm = urlOrForm;\n                url = originalForm.action;\n                for (var i = includeFields.length - 1; i >= 0; i--) {\n                    var fields = ko.utils.getFormFields(originalForm, includeFields[i]);\n                    for (var j = fields.length - 1; j >= 0; j--)\n                        params[fields[j].name] = fields[j].value;\n                }\n            }\n\n            data = ko.utils.unwrapObservable(data);\n            var form = document.createElement(\"form\");\n            form.style.display = \"none\";\n            form.action = url;\n            form.method = \"post\";\n            for (var key in data) {\n                // Since 'data' this is a model object, we include all properties including those inherited from its prototype\n                var input = document.createElement(\"input\");\n                input.type = \"hidden\";\n                input.name = key;\n                input.value = ko.utils.stringifyJson(ko.utils.unwrapObservable(data[key]));\n                form.appendChild(input);\n            }\n            objectForEach(params, function(key, value) {\n                var input = document.createElement(\"input\");\n                input.type = \"hidden\";\n                input.name = key;\n                input.value = value;\n                form.appendChild(input);\n            });\n            document.body.appendChild(form);\n            options['submitter'] ? options['submitter'](form) : form.submit();\n            setTimeout(function () { form.parentNode.removeChild(form); }, 0);\n        }\n    }\n}());\n\nko.exportSymbol('utils', ko.utils);\nko.exportSymbol('utils.arrayForEach', ko.utils.arrayForEach);\nko.exportSymbol('utils.arrayFirst', ko.utils.arrayFirst);\nko.exportSymbol('utils.arrayFilter', ko.utils.arrayFilter);\nko.exportSymbol('utils.arrayGetDistinctValues', ko.utils.arrayGetDistinctValues);\nko.exportSymbol('utils.arrayIndexOf', ko.utils.arrayIndexOf);\nko.exportSymbol('utils.arrayMap', ko.utils.arrayMap);\nko.exportSymbol('utils.arrayPushAll', ko.utils.arrayPushAll);\nko.exportSymbol('utils.arrayRemoveItem', ko.utils.arrayRemoveItem);\nko.exportSymbol('utils.extend', ko.utils.extend);\nko.exportSymbol('utils.fieldsIncludedWithJsonPost', ko.utils.fieldsIncludedWithJsonPost);\nko.exportSymbol('utils.getFormFields', ko.utils.getFormFields);\nko.exportSymbol('utils.peekObservable', ko.utils.peekObservable);\nko.exportSymbol('utils.postJson', ko.utils.postJson);\nko.exportSymbol('utils.parseJson', ko.utils.parseJson);\nko.exportSymbol('utils.registerEventHandler', ko.utils.registerEventHandler);\nko.exportSymbol('utils.stringifyJson', ko.utils.stringifyJson);\nko.exportSymbol('utils.range', ko.utils.range);\nko.exportSymbol('utils.toggleDomNodeCssClass', ko.utils.toggleDomNodeCssClass);\nko.exportSymbol('utils.triggerEvent', ko.utils.triggerEvent);\nko.exportSymbol('utils.unwrapObservable', ko.utils.unwrapObservable);\nko.exportSymbol('utils.objectForEach', ko.utils.objectForEach);\nko.exportSymbol('utils.addOrRemoveItem', ko.utils.addOrRemoveItem);\nko.exportSymbol('utils.setTextContent', ko.utils.setTextContent);\nko.exportSymbol('unwrap', ko.utils.unwrapObservable); // Convenient shorthand, because this is used so commonly\n\nif (!Function.prototype['bind']) {\n    // Function.prototype.bind is a standard part of ECMAScript 5th Edition (December 2009, http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf)\n    // In case the browser doesn't implement it natively, provide a JavaScript implementation. This implementation is based on the one in prototype.js\n    Function.prototype['bind'] = function (object) {\n        var originalFunction = this;\n        if (arguments.length === 1) {\n            return function () {\n                return originalFunction.apply(object, arguments);\n            };\n        } else {\n            var partialArgs = Array.prototype.slice.call(arguments, 1);\n            return function () {\n                var args = partialArgs.slice(0);\n                args.push.apply(args, arguments);\n                return originalFunction.apply(object, args);\n            };\n        }\n    };\n}\n\nko.utils.domData = new (function () {\n    var uniqueId = 0;\n    var dataStoreKeyExpandoPropertyName = \"__ko__\" + (new Date).getTime();\n    var dataStore = {};\n\n    function getAll(node, createIfNotFound) {\n        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n        var hasExistingDataStore = dataStoreKey && (dataStoreKey !== \"null\") && dataStore[dataStoreKey];\n        if (!hasExistingDataStore) {\n            if (!createIfNotFound)\n                return undefined;\n            dataStoreKey = node[dataStoreKeyExpandoPropertyName] = \"ko\" + uniqueId++;\n            dataStore[dataStoreKey] = {};\n        }\n        return dataStore[dataStoreKey];\n    }\n\n    return {\n        get: function (node, key) {\n            var allDataForNode = getAll(node, false);\n            return allDataForNode === undefined ? undefined : allDataForNode[key];\n        },\n        set: function (node, key, value) {\n            if (value === undefined) {\n                // Make sure we don't actually create a new domData key if we are actually deleting a value\n                if (getAll(node, false) === undefined)\n                    return;\n            }\n            var allDataForNode = getAll(node, true);\n            allDataForNode[key] = value;\n        },\n        clear: function (node) {\n            var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n            if (dataStoreKey) {\n                delete dataStore[dataStoreKey];\n                node[dataStoreKeyExpandoPropertyName] = null;\n                return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n            }\n            return false;\n        },\n\n        nextKey: function () {\n            return (uniqueId++) + dataStoreKeyExpandoPropertyName;\n        }\n    };\n})();\n\nko.exportSymbol('utils.domData', ko.utils.domData);\nko.exportSymbol('utils.domData.clear', ko.utils.domData.clear); // Exporting only so specs can clear up after themselves fully\n\nko.utils.domNodeDisposal = new (function () {\n    var domDataKey = ko.utils.domData.nextKey();\n    var cleanableNodeTypes = { 1: true, 8: true, 9: true };       // Element, Comment, Document\n    var cleanableNodeTypesWithDescendants = { 1: true, 9: true }; // Element, Document\n\n    function getDisposeCallbacksCollection(node, createIfNotFound) {\n        var allDisposeCallbacks = ko.utils.domData.get(node, domDataKey);\n        if ((allDisposeCallbacks === undefined) && createIfNotFound) {\n            allDisposeCallbacks = [];\n            ko.utils.domData.set(node, domDataKey, allDisposeCallbacks);\n        }\n        return allDisposeCallbacks;\n    }\n    function destroyCallbacksCollection(node) {\n        ko.utils.domData.set(node, domDataKey, undefined);\n    }\n\n    function cleanSingleNode(node) {\n        // Run all the dispose callbacks\n        var callbacks = getDisposeCallbacksCollection(node, false);\n        if (callbacks) {\n            callbacks = callbacks.slice(0); // Clone, as the array may be modified during iteration (typically, callbacks will remove themselves)\n            for (var i = 0; i < callbacks.length; i++)\n                callbacks[i](node);\n        }\n\n        // Erase the DOM data\n        ko.utils.domData.clear(node);\n\n        // Perform cleanup needed by external libraries (currently only jQuery, but can be extended)\n        ko.utils.domNodeDisposal[\"cleanExternalData\"](node);\n\n        // Clear any immediate-child comment nodes, as these wouldn't have been found by\n        // node.getElementsByTagName(\"*\") in cleanNode() (comment nodes aren't elements)\n        if (cleanableNodeTypesWithDescendants[node.nodeType])\n            cleanImmediateCommentTypeChildren(node);\n    }\n\n    function cleanImmediateCommentTypeChildren(nodeWithChildren) {\n        var child, nextChild = nodeWithChildren.firstChild;\n        while (child = nextChild) {\n            nextChild = child.nextSibling;\n            if (child.nodeType === 8)\n                cleanSingleNode(child);\n        }\n    }\n\n    return {\n        addDisposeCallback : function(node, callback) {\n            if (typeof callback != \"function\")\n                throw new Error(\"Callback must be a function\");\n            getDisposeCallbacksCollection(node, true).push(callback);\n        },\n\n        removeDisposeCallback : function(node, callback) {\n            var callbacksCollection = getDisposeCallbacksCollection(node, false);\n            if (callbacksCollection) {\n                ko.utils.arrayRemoveItem(callbacksCollection, callback);\n                if (callbacksCollection.length == 0)\n                    destroyCallbacksCollection(node);\n            }\n        },\n\n        cleanNode : function(node) {\n            // First clean this node, where applicable\n            if (cleanableNodeTypes[node.nodeType]) {\n                cleanSingleNode(node);\n\n                // ... then its descendants, where applicable\n                if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                    // Clone the descendants list in case it changes during iteration\n                    var descendants = [];\n                    ko.utils.arrayPushAll(descendants, node.getElementsByTagName(\"*\"));\n                    for (var i = 0, j = descendants.length; i < j; i++)\n                        cleanSingleNode(descendants[i]);\n                }\n            }\n            return node;\n        },\n\n        removeNode : function(node) {\n            ko.cleanNode(node);\n            if (node.parentNode)\n                node.parentNode.removeChild(node);\n        },\n\n        \"cleanExternalData\" : function (node) {\n            // Special support for jQuery here because it's so commonly used.\n            // Many jQuery plugins (including jquery.tmpl) store data using jQuery's equivalent of domData\n            // so notify it to tear down any resources associated with the node & descendants here.\n            if (jQueryInstance && (typeof jQueryInstance['cleanData'] == \"function\"))\n                jQueryInstance['cleanData']([node]);\n        }\n    };\n})();\nko.cleanNode = ko.utils.domNodeDisposal.cleanNode; // Shorthand name for convenience\nko.removeNode = ko.utils.domNodeDisposal.removeNode; // Shorthand name for convenience\nko.exportSymbol('cleanNode', ko.cleanNode);\nko.exportSymbol('removeNode', ko.removeNode);\nko.exportSymbol('utils.domNodeDisposal', ko.utils.domNodeDisposal);\nko.exportSymbol('utils.domNodeDisposal.addDisposeCallback', ko.utils.domNodeDisposal.addDisposeCallback);\nko.exportSymbol('utils.domNodeDisposal.removeDisposeCallback', ko.utils.domNodeDisposal.removeDisposeCallback);\n(function () {\n    var leadingCommentRegex = /^(\\s*)<!--(.*?)-->/;\n\n    function simpleHtmlParse(html, documentContext) {\n        documentContext || (documentContext = document);\n        var windowContext = documentContext['parentWindow'] || documentContext['defaultView'] || window;\n\n        // Based on jQuery's \"clean\" function, but only accounting for table-related elements.\n        // If you have referenced jQuery, this won't be used anyway - KO will use jQuery's \"clean\" function directly\n\n        // Note that there's still an issue in IE < 9 whereby it will discard comment nodes that are the first child of\n        // a descendant node. For example: \"<div><!-- mycomment -->abc</div>\" will get parsed as \"<div>abc</div>\"\n        // This won't affect anyone who has referenced jQuery, and there's always the workaround of inserting a dummy node\n        // (possibly a text node) in front of the comment. So, KO does not attempt to workaround this IE issue automatically at present.\n\n        // Trim whitespace, otherwise indexOf won't work as expected\n        var tags = ko.utils.stringTrim(html).toLowerCase(), div = documentContext.createElement(\"div\");\n\n        // Finds the first match from the left column, and returns the corresponding \"wrap\" data from the right column\n        var wrap = tags.match(/^<(thead|tbody|tfoot)/)              && [1, \"<table>\", \"</table>\"] ||\n                   !tags.indexOf(\"<tr\")                             && [2, \"<table><tbody>\", \"</tbody></table>\"] ||\n                   (!tags.indexOf(\"<td\") || !tags.indexOf(\"<th\"))   && [3, \"<table><tbody><tr>\", \"</tr></tbody></table>\"] ||\n                   /* anything else */                                 [0, \"\", \"\"];\n\n        // Go to html and back, then peel off extra wrappers\n        // Note that we always prefix with some dummy text, because otherwise, IE<9 will strip out leading comment nodes in descendants. Total madness.\n        var markup = \"ignored<div>\" + wrap[1] + html + wrap[2] + \"</div>\";\n        if (typeof windowContext['innerShiv'] == \"function\") {\n            div.appendChild(windowContext['innerShiv'](markup));\n        } else {\n            div.innerHTML = markup;\n        }\n\n        // Move to the right depth\n        while (wrap[0]--)\n            div = div.lastChild;\n\n        return ko.utils.makeArray(div.lastChild.childNodes);\n    }\n\n    function jQueryHtmlParse(html, documentContext) {\n        // jQuery's \"parseHTML\" function was introduced in jQuery 1.8.0 and is a documented public API.\n        if (jQueryInstance['parseHTML']) {\n            return jQueryInstance['parseHTML'](html, documentContext) || []; // Ensure we always return an array and never null\n        } else {\n            // For jQuery < 1.8.0, we fall back on the undocumented internal \"clean\" function.\n            var elems = jQueryInstance['clean']([html], documentContext);\n\n            // As of jQuery 1.7.1, jQuery parses the HTML by appending it to some dummy parent nodes held in an in-memory document fragment.\n            // Unfortunately, it never clears the dummy parent nodes from the document fragment, so it leaks memory over time.\n            // Fix this by finding the top-most dummy parent element, and detaching it from its owner fragment.\n            if (elems && elems[0]) {\n                // Find the top-most parent element that's a direct child of a document fragment\n                var elem = elems[0];\n                while (elem.parentNode && elem.parentNode.nodeType !== 11 /* i.e., DocumentFragment */)\n                    elem = elem.parentNode;\n                // ... then detach it\n                if (elem.parentNode)\n                    elem.parentNode.removeChild(elem);\n            }\n\n            return elems;\n        }\n    }\n\n    ko.utils.parseHtmlFragment = function(html, documentContext) {\n        return jQueryInstance ? jQueryHtmlParse(html, documentContext)   // As below, benefit from jQuery's optimisations where possible\n                              : simpleHtmlParse(html, documentContext);  // ... otherwise, this simple logic will do in most common cases.\n    };\n\n    ko.utils.setHtml = function(node, html) {\n        ko.utils.emptyDomNode(node);\n\n        // There's no legitimate reason to display a stringified observable without unwrapping it, so we'll unwrap it\n        html = ko.utils.unwrapObservable(html);\n\n        if ((html !== null) && (html !== undefined)) {\n            if (typeof html != 'string')\n                html = html.toString();\n\n            // jQuery contains a lot of sophisticated code to parse arbitrary HTML fragments,\n            // for example <tr> elements which are not normally allowed to exist on their own.\n            // If you've referenced jQuery we'll use that rather than duplicating its code.\n            if (jQueryInstance) {\n                jQueryInstance(node)['html'](html);\n            } else {\n                // ... otherwise, use KO's own parsing logic.\n                var parsedNodes = ko.utils.parseHtmlFragment(html, node.ownerDocument);\n                for (var i = 0; i < parsedNodes.length; i++)\n                    node.appendChild(parsedNodes[i]);\n            }\n        }\n    };\n})();\n\nko.exportSymbol('utils.parseHtmlFragment', ko.utils.parseHtmlFragment);\nko.exportSymbol('utils.setHtml', ko.utils.setHtml);\n\nko.memoization = (function () {\n    var memos = {};\n\n    function randomMax8HexChars() {\n        return (((1 + Math.random()) * 0x100000000) | 0).toString(16).substring(1);\n    }\n    function generateRandomId() {\n        return randomMax8HexChars() + randomMax8HexChars();\n    }\n    function findMemoNodes(rootNode, appendToArray) {\n        if (!rootNode)\n            return;\n        if (rootNode.nodeType == 8) {\n            var memoId = ko.memoization.parseMemoText(rootNode.nodeValue);\n            if (memoId != null)\n                appendToArray.push({ domNode: rootNode, memoId: memoId });\n        } else if (rootNode.nodeType == 1) {\n            for (var i = 0, childNodes = rootNode.childNodes, j = childNodes.length; i < j; i++)\n                findMemoNodes(childNodes[i], appendToArray);\n        }\n    }\n\n    return {\n        memoize: function (callback) {\n            if (typeof callback != \"function\")\n                throw new Error(\"You can only pass a function to ko.memoization.memoize()\");\n            var memoId = generateRandomId();\n            memos[memoId] = callback;\n            return \"<!--[ko_memo:\" + memoId + \"]-->\";\n        },\n\n        unmemoize: function (memoId, callbackParams) {\n            var callback = memos[memoId];\n            if (callback === undefined)\n                throw new Error(\"Couldn't find any memo with ID \" + memoId + \". Perhaps it's already been unmemoized.\");\n            try {\n                callback.apply(null, callbackParams || []);\n                return true;\n            }\n            finally { delete memos[memoId]; }\n        },\n\n        unmemoizeDomNodeAndDescendants: function (domNode, extraCallbackParamsArray) {\n            var memos = [];\n            findMemoNodes(domNode, memos);\n            for (var i = 0, j = memos.length; i < j; i++) {\n                var node = memos[i].domNode;\n                var combinedParams = [node];\n                if (extraCallbackParamsArray)\n                    ko.utils.arrayPushAll(combinedParams, extraCallbackParamsArray);\n                ko.memoization.unmemoize(memos[i].memoId, combinedParams);\n                node.nodeValue = \"\"; // Neuter this node so we don't try to unmemoize it again\n                if (node.parentNode)\n                    node.parentNode.removeChild(node); // If possible, erase it totally (not always possible - someone else might just hold a reference to it then call unmemoizeDomNodeAndDescendants again)\n            }\n        },\n\n        parseMemoText: function (memoText) {\n            var match = memoText.match(/^\\[ko_memo\\:(.*?)\\]$/);\n            return match ? match[1] : null;\n        }\n    };\n})();\n\nko.exportSymbol('memoization', ko.memoization);\nko.exportSymbol('memoization.memoize', ko.memoization.memoize);\nko.exportSymbol('memoization.unmemoize', ko.memoization.unmemoize);\nko.exportSymbol('memoization.parseMemoText', ko.memoization.parseMemoText);\nko.exportSymbol('memoization.unmemoizeDomNodeAndDescendants', ko.memoization.unmemoizeDomNodeAndDescendants);\nko.extenders = {\n    'throttle': function(target, timeout) {\n        // Throttling means two things:\n\n        // (1) For dependent observables, we throttle *evaluations* so that, no matter how fast its dependencies\n        //     notify updates, the target doesn't re-evaluate (and hence doesn't notify) faster than a certain rate\n        target['throttleEvaluation'] = timeout;\n\n        // (2) For writable targets (observables, or writable dependent observables), we throttle *writes*\n        //     so the target cannot change value synchronously or faster than a certain rate\n        var writeTimeoutInstance = null;\n        return ko.dependentObservable({\n            'read': target,\n            'write': function(value) {\n                clearTimeout(writeTimeoutInstance);\n                writeTimeoutInstance = setTimeout(function() {\n                    target(value);\n                }, timeout);\n            }\n        });\n    },\n\n    'rateLimit': function(target, options) {\n        var timeout, method, limitFunction;\n\n        if (typeof options == 'number') {\n            timeout = options;\n        } else {\n            timeout = options['timeout'];\n            method = options['method'];\n        }\n\n        limitFunction = method == 'notifyWhenChangesStop' ?  debounce : throttle;\n        target.limit(function(callback) {\n            return limitFunction(callback, timeout);\n        });\n    },\n\n    'notify': function(target, notifyWhen) {\n        target[\"equalityComparer\"] = notifyWhen == \"always\" ?\n            null :  // null equalityComparer means to always notify\n            valuesArePrimitiveAndEqual;\n    }\n};\n\nvar primitiveTypes = { 'undefined':1, 'boolean':1, 'number':1, 'string':1 };\nfunction valuesArePrimitiveAndEqual(a, b) {\n    var oldValueIsPrimitive = (a === null) || (typeof(a) in primitiveTypes);\n    return oldValueIsPrimitive ? (a === b) : false;\n}\n\nfunction throttle(callback, timeout) {\n    var timeoutInstance;\n    return function () {\n        if (!timeoutInstance) {\n            timeoutInstance = setTimeout(function() {\n                timeoutInstance = undefined;\n                callback();\n            }, timeout);\n        }\n    };\n}\n\nfunction debounce(callback, timeout) {\n    var timeoutInstance;\n    return function () {\n        clearTimeout(timeoutInstance);\n        timeoutInstance = setTimeout(callback, timeout);\n    };\n}\n\nfunction applyExtenders(requestedExtenders) {\n    var target = this;\n    if (requestedExtenders) {\n        ko.utils.objectForEach(requestedExtenders, function(key, value) {\n            var extenderHandler = ko.extenders[key];\n            if (typeof extenderHandler == 'function') {\n                target = extenderHandler(target, value) || target;\n            }\n        });\n    }\n    return target;\n}\n\nko.exportSymbol('extenders', ko.extenders);\n\nko.subscription = function (target, callback, disposeCallback) {\n    this._target = target;\n    this.callback = callback;\n    this.disposeCallback = disposeCallback;\n    this.isDisposed = false;\n    ko.exportProperty(this, 'dispose', this.dispose);\n};\nko.subscription.prototype.dispose = function () {\n    this.isDisposed = true;\n    this.disposeCallback();\n};\n\nko.subscribable = function () {\n    ko.utils.setPrototypeOfOrExtend(this, ko.subscribable['fn']);\n    this._subscriptions = {};\n    this._versionNumber = 1;\n}\n\nvar defaultEvent = \"change\";\n\nvar ko_subscribable_fn = {\n    subscribe: function (callback, callbackTarget, event) {\n        var self = this;\n\n        event = event || defaultEvent;\n        var boundCallback = callbackTarget ? callback.bind(callbackTarget) : callback;\n\n        var subscription = new ko.subscription(self, boundCallback, function () {\n            ko.utils.arrayRemoveItem(self._subscriptions[event], subscription);\n            if (self.afterSubscriptionRemove)\n                self.afterSubscriptionRemove(event);\n        });\n\n        if (self.beforeSubscriptionAdd)\n            self.beforeSubscriptionAdd(event);\n\n        if (!self._subscriptions[event])\n            self._subscriptions[event] = [];\n        self._subscriptions[event].push(subscription);\n\n        return subscription;\n    },\n\n    \"notifySubscribers\": function (valueToNotify, event) {\n        event = event || defaultEvent;\n        if (event === defaultEvent) {\n            this.updateVersion();\n        }\n        if (this.hasSubscriptionsForEvent(event)) {\n            try {\n                ko.dependencyDetection.begin(); // Begin suppressing dependency detection (by setting the top frame to undefined)\n                for (var a = this._subscriptions[event].slice(0), i = 0, subscription; subscription = a[i]; ++i) {\n                    // In case a subscription was disposed during the arrayForEach cycle, check\n                    // for isDisposed on each subscription before invoking its callback\n                    if (!subscription.isDisposed)\n                        subscription.callback(valueToNotify);\n                }\n            } finally {\n                ko.dependencyDetection.end(); // End suppressing dependency detection\n            }\n        }\n    },\n\n    getVersion: function () {\n        return this._versionNumber;\n    },\n\n    hasChanged: function (versionToCheck) {\n        return this.getVersion() !== versionToCheck;\n    },\n\n    updateVersion: function () {\n        ++this._versionNumber;\n    },\n\n    limit: function(limitFunction) {\n        var self = this, selfIsObservable = ko.isObservable(self),\n            isPending, previousValue, pendingValue, beforeChange = 'beforeChange';\n\n        if (!self._origNotifySubscribers) {\n            self._origNotifySubscribers = self[\"notifySubscribers\"];\n            self[\"notifySubscribers\"] = function(value, event) {\n                if (!event || event === defaultEvent) {\n                    self._rateLimitedChange(value);\n                } else if (event === beforeChange) {\n                    self._rateLimitedBeforeChange(value);\n                } else {\n                    self._origNotifySubscribers(value, event);\n                }\n            };\n        }\n\n        var finish = limitFunction(function() {\n            // If an observable provided a reference to itself, access it to get the latest value.\n            // This allows computed observables to delay calculating their value until needed.\n            if (selfIsObservable && pendingValue === self) {\n                pendingValue = self();\n            }\n            isPending = false;\n            if (self.isDifferent(previousValue, pendingValue)) {\n                self._origNotifySubscribers(previousValue = pendingValue);\n            }\n        });\n\n        self._rateLimitedChange = function(value) {\n            isPending = true;\n            pendingValue = value;\n            finish();\n        };\n        self._rateLimitedBeforeChange = function(value) {\n            if (!isPending) {\n                previousValue = value;\n                self._origNotifySubscribers(value, beforeChange);\n            }\n        };\n    },\n\n    hasSubscriptionsForEvent: function(event) {\n        return this._subscriptions[event] && this._subscriptions[event].length;\n    },\n\n    getSubscriptionsCount: function (event) {\n        if (event) {\n            return this._subscriptions[event] && this._subscriptions[event].length || 0;\n        } else {\n            var total = 0;\n            ko.utils.objectForEach(this._subscriptions, function(eventName, subscriptions) {\n                total += subscriptions.length;\n            });\n            return total;\n        }\n    },\n\n    isDifferent: function(oldValue, newValue) {\n        return !this['equalityComparer'] || !this['equalityComparer'](oldValue, newValue);\n    },\n\n    extend: applyExtenders\n};\n\nko.exportProperty(ko_subscribable_fn, 'subscribe', ko_subscribable_fn.subscribe);\nko.exportProperty(ko_subscribable_fn, 'extend', ko_subscribable_fn.extend);\nko.exportProperty(ko_subscribable_fn, 'getSubscriptionsCount', ko_subscribable_fn.getSubscriptionsCount);\n\n// For browsers that support proto assignment, we overwrite the prototype of each\n// observable instance. Since observables are functions, we need Function.prototype\n// to still be in the prototype chain.\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko_subscribable_fn, Function.prototype);\n}\n\nko.subscribable['fn'] = ko_subscribable_fn;\n\n\nko.isSubscribable = function (instance) {\n    return instance != null && typeof instance.subscribe == \"function\" && typeof instance[\"notifySubscribers\"] == \"function\";\n};\n\nko.exportSymbol('subscribable', ko.subscribable);\nko.exportSymbol('isSubscribable', ko.isSubscribable);\n\nko.computedContext = ko.dependencyDetection = (function () {\n    var outerFrames = [],\n        currentFrame,\n        lastId = 0;\n\n    // Return a unique ID that can be assigned to an observable for dependency tracking.\n    // Theoretically, you could eventually overflow the number storage size, resulting\n    // in duplicate IDs. But in JavaScript, the largest exact integral value is 2^53\n    // or 9,007,199,254,740,992. If you created 1,000,000 IDs per second, it would\n    // take over 285 years to reach that number.\n    // Reference http://blog.vjeux.com/2010/javascript/javascript-max_int-number-limits.html\n    function getId() {\n        return ++lastId;\n    }\n\n    function begin(options) {\n        outerFrames.push(currentFrame);\n        currentFrame = options;\n    }\n\n    function end() {\n        currentFrame = outerFrames.pop();\n    }\n\n    return {\n        begin: begin,\n\n        end: end,\n\n        registerDependency: function (subscribable) {\n            if (currentFrame) {\n                if (!ko.isSubscribable(subscribable))\n                    throw new Error(\"Only subscribable things can act as dependencies\");\n                currentFrame.callback(subscribable, subscribable._id || (subscribable._id = getId()));\n            }\n        },\n\n        ignore: function (callback, callbackTarget, callbackArgs) {\n            try {\n                begin();\n                return callback.apply(callbackTarget, callbackArgs || []);\n            } finally {\n                end();\n            }\n        },\n\n        getDependenciesCount: function () {\n            if (currentFrame)\n                return currentFrame.computed.getDependenciesCount();\n        },\n\n        isInitial: function() {\n            if (currentFrame)\n                return currentFrame.isInitial;\n        }\n    };\n})();\n\nko.exportSymbol('computedContext', ko.computedContext);\nko.exportSymbol('computedContext.getDependenciesCount', ko.computedContext.getDependenciesCount);\nko.exportSymbol('computedContext.isInitial', ko.computedContext.isInitial);\nko.exportSymbol('computedContext.isSleeping', ko.computedContext.isSleeping);\n\nko.exportSymbol('ignoreDependencies', ko.ignoreDependencies = ko.dependencyDetection.ignore);\nko.observable = function (initialValue) {\n    var _latestValue = initialValue;\n\n    function observable() {\n        if (arguments.length > 0) {\n            // Write\n\n            // Ignore writes if the value hasn't changed\n            if (observable.isDifferent(_latestValue, arguments[0])) {\n                observable.valueWillMutate();\n                _latestValue = arguments[0];\n                if (DEBUG) observable._latestValue = _latestValue;\n                observable.valueHasMutated();\n            }\n            return this; // Permits chained assignments\n        }\n        else {\n            // Read\n            ko.dependencyDetection.registerDependency(observable); // The caller only needs to be notified of changes if they did a \"read\" operation\n            return _latestValue;\n        }\n    }\n    ko.subscribable.call(observable);\n    ko.utils.setPrototypeOfOrExtend(observable, ko.observable['fn']);\n\n    if (DEBUG) observable._latestValue = _latestValue;\n    observable.peek = function() { return _latestValue };\n    observable.valueHasMutated = function () { observable[\"notifySubscribers\"](_latestValue); }\n    observable.valueWillMutate = function () { observable[\"notifySubscribers\"](_latestValue, \"beforeChange\"); }\n\n    ko.exportProperty(observable, 'peek', observable.peek);\n    ko.exportProperty(observable, \"valueHasMutated\", observable.valueHasMutated);\n    ko.exportProperty(observable, \"valueWillMutate\", observable.valueWillMutate);\n\n    return observable;\n}\n\nko.observable['fn'] = {\n    \"equalityComparer\": valuesArePrimitiveAndEqual\n};\n\nvar protoProperty = ko.observable.protoProperty = \"__ko_proto__\";\nko.observable['fn'][protoProperty] = ko.observable;\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observable constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko.observable['fn'], ko.subscribable['fn']);\n}\n\nko.hasPrototype = function(instance, prototype) {\n    if ((instance === null) || (instance === undefined) || (instance[protoProperty] === undefined)) return false;\n    if (instance[protoProperty] === prototype) return true;\n    return ko.hasPrototype(instance[protoProperty], prototype); // Walk the prototype chain\n};\n\nko.isObservable = function (instance) {\n    return ko.hasPrototype(instance, ko.observable);\n}\nko.isWriteableObservable = function (instance) {\n    // Observable\n    if ((typeof instance == \"function\") && instance[protoProperty] === ko.observable)\n        return true;\n    // Writeable dependent observable\n    if ((typeof instance == \"function\") && (instance[protoProperty] === ko.dependentObservable) && (instance.hasWriteFunction))\n        return true;\n    // Anything else\n    return false;\n}\n\n\nko.exportSymbol('observable', ko.observable);\nko.exportSymbol('isObservable', ko.isObservable);\nko.exportSymbol('isWriteableObservable', ko.isWriteableObservable);\nko.exportSymbol('isWritableObservable', ko.isWriteableObservable);\nko.observableArray = function (initialValues) {\n    initialValues = initialValues || [];\n\n    if (typeof initialValues != 'object' || !('length' in initialValues))\n        throw new Error(\"The argument passed when initializing an observable array must be an array, or null, or undefined.\");\n\n    var result = ko.observable(initialValues);\n    ko.utils.setPrototypeOfOrExtend(result, ko.observableArray['fn']);\n    return result.extend({'trackArrayChanges':true});\n};\n\nko.observableArray['fn'] = {\n    'remove': function (valueOrPredicate) {\n        var underlyingArray = this.peek();\n        var removedValues = [];\n        var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n        for (var i = 0; i < underlyingArray.length; i++) {\n            var value = underlyingArray[i];\n            if (predicate(value)) {\n                if (removedValues.length === 0) {\n                    this.valueWillMutate();\n                }\n                removedValues.push(value);\n                underlyingArray.splice(i, 1);\n                i--;\n            }\n        }\n        if (removedValues.length) {\n            this.valueHasMutated();\n        }\n        return removedValues;\n    },\n\n    'removeAll': function (arrayOfValues) {\n        // If you passed zero args, we remove everything\n        if (arrayOfValues === undefined) {\n            var underlyingArray = this.peek();\n            var allValues = underlyingArray.slice(0);\n            this.valueWillMutate();\n            underlyingArray.splice(0, underlyingArray.length);\n            this.valueHasMutated();\n            return allValues;\n        }\n        // If you passed an arg, we interpret it as an array of entries to remove\n        if (!arrayOfValues)\n            return [];\n        return this['remove'](function (value) {\n            return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n        });\n    },\n\n    'destroy': function (valueOrPredicate) {\n        var underlyingArray = this.peek();\n        var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n        this.valueWillMutate();\n        for (var i = underlyingArray.length - 1; i >= 0; i--) {\n            var value = underlyingArray[i];\n            if (predicate(value))\n                underlyingArray[i][\"_destroy\"] = true;\n        }\n        this.valueHasMutated();\n    },\n\n    'destroyAll': function (arrayOfValues) {\n        // If you passed zero args, we destroy everything\n        if (arrayOfValues === undefined)\n            return this['destroy'](function() { return true });\n\n        // If you passed an arg, we interpret it as an array of entries to destroy\n        if (!arrayOfValues)\n            return [];\n        return this['destroy'](function (value) {\n            return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n        });\n    },\n\n    'indexOf': function (item) {\n        var underlyingArray = this();\n        return ko.utils.arrayIndexOf(underlyingArray, item);\n    },\n\n    'replace': function(oldItem, newItem) {\n        var index = this['indexOf'](oldItem);\n        if (index >= 0) {\n            this.valueWillMutate();\n            this.peek()[index] = newItem;\n            this.valueHasMutated();\n        }\n    }\n};\n\n// Populate ko.observableArray.fn with read/write functions from native arrays\n// Important: Do not add any additional functions here that may reasonably be used to *read* data from the array\n// because we'll eval them without causing subscriptions, so ko.computed output could end up getting stale\nko.utils.arrayForEach([\"pop\", \"push\", \"reverse\", \"shift\", \"sort\", \"splice\", \"unshift\"], function (methodName) {\n    ko.observableArray['fn'][methodName] = function () {\n        // Use \"peek\" to avoid creating a subscription in any computed that we're executing in the context of\n        // (for consistency with mutating regular observables)\n        var underlyingArray = this.peek();\n        this.valueWillMutate();\n        this.cacheDiffForKnownOperation(underlyingArray, methodName, arguments);\n        var methodCallResult = underlyingArray[methodName].apply(underlyingArray, arguments);\n        this.valueHasMutated();\n        return methodCallResult;\n    };\n});\n\n// Populate ko.observableArray.fn with read-only functions from native arrays\nko.utils.arrayForEach([\"slice\"], function (methodName) {\n    ko.observableArray['fn'][methodName] = function () {\n        var underlyingArray = this();\n        return underlyingArray[methodName].apply(underlyingArray, arguments);\n    };\n});\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observableArray constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko.observableArray['fn'], ko.observable['fn']);\n}\n\nko.exportSymbol('observableArray', ko.observableArray);\nvar arrayChangeEventName = 'arrayChange';\nko.extenders['trackArrayChanges'] = function(target) {\n    // Only modify the target observable once\n    if (target.cacheDiffForKnownOperation) {\n        return;\n    }\n    var trackingChanges = false,\n        cachedDiff = null,\n        arrayChangeSubscription,\n        pendingNotifications = 0,\n        underlyingBeforeSubscriptionAddFunction = target.beforeSubscriptionAdd,\n        underlyingAfterSubscriptionRemoveFunction = target.afterSubscriptionRemove;\n\n    // Watch \"subscribe\" calls, and for array change events, ensure change tracking is enabled\n    target.beforeSubscriptionAdd = function (event) {\n        if (underlyingBeforeSubscriptionAddFunction)\n            underlyingBeforeSubscriptionAddFunction.call(target, event);\n        if (event === arrayChangeEventName) {\n            trackChanges();\n        }\n    };\n    // Watch \"dispose\" calls, and for array change events, ensure change tracking is disabled when all are disposed\n    target.afterSubscriptionRemove = function (event) {\n        if (underlyingAfterSubscriptionRemoveFunction)\n            underlyingAfterSubscriptionRemoveFunction.call(target, event);\n        if (event === arrayChangeEventName && !target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n            arrayChangeSubscription.dispose();\n            trackingChanges = false;\n        }\n    };\n\n    function trackChanges() {\n        // Calling 'trackChanges' multiple times is the same as calling it once\n        if (trackingChanges) {\n            return;\n        }\n\n        trackingChanges = true;\n\n        // Intercept \"notifySubscribers\" to track how many times it was called.\n        var underlyingNotifySubscribersFunction = target['notifySubscribers'];\n        target['notifySubscribers'] = function(valueToNotify, event) {\n            if (!event || event === defaultEvent) {\n                ++pendingNotifications;\n            }\n            return underlyingNotifySubscribersFunction.apply(this, arguments);\n        };\n\n        // Each time the array changes value, capture a clone so that on the next\n        // change it's possible to produce a diff\n        var previousContents = [].concat(target.peek() || []);\n        cachedDiff = null;\n        arrayChangeSubscription = target.subscribe(function(currentContents) {\n            // Make a copy of the current contents and ensure it's an array\n            currentContents = [].concat(currentContents || []);\n\n            // Compute the diff and issue notifications, but only if someone is listening\n            if (target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                var changes = getChanges(previousContents, currentContents);\n            }\n\n            // Eliminate references to the old, removed items, so they can be GCed\n            previousContents = currentContents;\n            cachedDiff = null;\n            pendingNotifications = 0;\n\n            if (changes && changes.length) {\n                target['notifySubscribers'](changes, arrayChangeEventName);\n            }\n        });\n    }\n\n    function getChanges(previousContents, currentContents) {\n        // We try to re-use cached diffs.\n        // The scenarios where pendingNotifications > 1 are when using rate-limiting or the Deferred Updates\n        // plugin, which without this check would not be compatible with arrayChange notifications. Normally,\n        // notifications are issued immediately so we wouldn't be queueing up more than one.\n        if (!cachedDiff || pendingNotifications > 1) {\n            cachedDiff = ko.utils.compareArrays(previousContents, currentContents, { 'sparse': true });\n        }\n\n        return cachedDiff;\n    }\n\n    target.cacheDiffForKnownOperation = function(rawArray, operationName, args) {\n        // Only run if we're currently tracking changes for this observable array\n        // and there aren't any pending deferred notifications.\n        if (!trackingChanges || pendingNotifications) {\n            return;\n        }\n        var diff = [],\n            arrayLength = rawArray.length,\n            argsLength = args.length,\n            offset = 0;\n\n        function pushDiff(status, value, index) {\n            return diff[diff.length] = { 'status': status, 'value': value, 'index': index };\n        }\n        switch (operationName) {\n            case 'push':\n                offset = arrayLength;\n            case 'unshift':\n                for (var index = 0; index < argsLength; index++) {\n                    pushDiff('added', args[index], offset + index);\n                }\n                break;\n\n            case 'pop':\n                offset = arrayLength - 1;\n            case 'shift':\n                if (arrayLength) {\n                    pushDiff('deleted', rawArray[offset], offset);\n                }\n                break;\n\n            case 'splice':\n                // Negative start index means 'from end of array'. After that we clamp to [0...arrayLength].\n                // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\n                var startIndex = Math.min(Math.max(0, args[0] < 0 ? arrayLength + args[0] : args[0]), arrayLength),\n                    endDeleteIndex = argsLength === 1 ? arrayLength : Math.min(startIndex + (args[1] || 0), arrayLength),\n                    endAddIndex = startIndex + argsLength - 2,\n                    endIndex = Math.max(endDeleteIndex, endAddIndex),\n                    additions = [], deletions = [];\n                for (var index = startIndex, argsIndex = 2; index < endIndex; ++index, ++argsIndex) {\n                    if (index < endDeleteIndex)\n                        deletions.push(pushDiff('deleted', rawArray[index], index));\n                    if (index < endAddIndex)\n                        additions.push(pushDiff('added', args[argsIndex], index));\n                }\n                ko.utils.findMovesInArrayComparison(deletions, additions);\n                break;\n\n            default:\n                return;\n        }\n        cachedDiff = diff;\n    };\n};\nko.computed = ko.dependentObservable = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget, options) {\n    var _latestValue,\n        _needsEvaluation = true,\n        _isBeingEvaluated = false,\n        _suppressDisposalUntilDisposeWhenReturnsFalse = false,\n        _isDisposed = false,\n        readFunction = evaluatorFunctionOrOptions,\n        pure = false,\n        isSleeping = false;\n\n    if (readFunction && typeof readFunction == \"object\") {\n        // Single-parameter syntax - everything is on this \"options\" param\n        options = readFunction;\n        readFunction = options[\"read\"];\n    } else {\n        // Multi-parameter syntax - construct the options according to the params passed\n        options = options || {};\n        if (!readFunction)\n            readFunction = options[\"read\"];\n    }\n    if (typeof readFunction != \"function\")\n        throw new Error(\"Pass a function that returns the value of the ko.computed\");\n\n    function addDependencyTracking(id, target, trackingObj) {\n        if (pure && target === dependentObservable) {\n            throw Error(\"A 'pure' computed must not be called recursively\");\n        }\n\n        dependencyTracking[id] = trackingObj;\n        trackingObj._order = _dependenciesCount++;\n        trackingObj._version = target.getVersion();\n    }\n\n    function haveDependenciesChanged() {\n        var id, dependency;\n        for (id in dependencyTracking) {\n            if (dependencyTracking.hasOwnProperty(id)) {\n                dependency = dependencyTracking[id];\n                if (dependency._target.hasChanged(dependency._version)) {\n                    return true;\n                }\n            }\n        }\n    }\n\n    function disposeComputed() {\n        if (!isSleeping && dependencyTracking) {\n            ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                if (dependency.dispose)\n                    dependency.dispose();\n            });\n        }\n        dependencyTracking = null;\n        _dependenciesCount = 0;\n        _isDisposed = true;\n        _needsEvaluation = false;\n        isSleeping = false;\n    }\n\n    function evaluatePossiblyAsync() {\n        var throttleEvaluationTimeout = dependentObservable['throttleEvaluation'];\n        if (throttleEvaluationTimeout && throttleEvaluationTimeout >= 0) {\n            clearTimeout(evaluationTimeoutInstance);\n            evaluationTimeoutInstance = setTimeout(function () {\n                evaluateImmediate(true /*notifyChange*/);\n            }, throttleEvaluationTimeout);\n        } else if (dependentObservable._evalRateLimited) {\n            dependentObservable._evalRateLimited();\n        } else {\n            evaluateImmediate(true /*notifyChange*/);\n        }\n    }\n\n    function evaluateImmediate(notifyChange) {\n        if (_isBeingEvaluated) {\n            // If the evaluation of a ko.computed causes side effects, it's possible that it will trigger its own re-evaluation.\n            // This is not desirable (it's hard for a developer to realise a chain of dependencies might cause this, and they almost\n            // certainly didn't intend infinite re-evaluations). So, for predictability, we simply prevent ko.computeds from causing\n            // their own re-evaluation. Further discussion at https://github.com/SteveSanderson/knockout/pull/387\n            return;\n        }\n\n        // Do not evaluate (and possibly capture new dependencies) if disposed\n        if (_isDisposed) {\n            return;\n        }\n\n        if (disposeWhen && disposeWhen()) {\n            // See comment below about _suppressDisposalUntilDisposeWhenReturnsFalse\n            if (!_suppressDisposalUntilDisposeWhenReturnsFalse) {\n                dispose();\n                return;\n            }\n        } else {\n            // It just did return false, so we can stop suppressing now\n            _suppressDisposalUntilDisposeWhenReturnsFalse = false;\n        }\n\n        _isBeingEvaluated = true;\n\n        try {\n            // Initially, we assume that none of the subscriptions are still being used (i.e., all are candidates for disposal).\n            // Then, during evaluation, we cross off any that are in fact still being used.\n            var disposalCandidates = dependencyTracking,\n                disposalCount = _dependenciesCount,\n                isInitial = pure ? undefined : !_dependenciesCount;   // If we're evaluating when there are no previous dependencies, it must be the first time\n\n            ko.dependencyDetection.begin({\n                callback: function(subscribable, id) {\n                    if (!_isDisposed) {\n                        if (disposalCount && disposalCandidates[id]) {\n                            // Don't want to dispose this subscription, as it's still being used\n                            addDependencyTracking(id, subscribable, disposalCandidates[id]);\n                            delete disposalCandidates[id];\n                            --disposalCount;\n                        } else if (!dependencyTracking[id]) {\n                            // Brand new subscription - add it\n                            addDependencyTracking(id, subscribable, isSleeping ? { _target: subscribable } : subscribable.subscribe(evaluatePossiblyAsync));\n                        }\n                    }\n                },\n                computed: dependentObservable,\n                isInitial: isInitial\n            });\n\n            dependencyTracking = {};\n            _dependenciesCount = 0;\n\n            try {\n                var newValue = evaluatorFunctionTarget ? readFunction.call(evaluatorFunctionTarget) : readFunction();\n\n            } finally {\n                ko.dependencyDetection.end();\n\n                // For each subscription no longer being used, remove it from the active subscriptions list and dispose it\n                if (disposalCount && !isSleeping) {\n                    ko.utils.objectForEach(disposalCandidates, function(id, toDispose) {\n                        if (toDispose.dispose)\n                            toDispose.dispose();\n                    });\n                }\n\n                _needsEvaluation = false;\n            }\n\n            if (dependentObservable.isDifferent(_latestValue, newValue)) {\n                if (!isSleeping) {\n                    notify(_latestValue, \"beforeChange\");\n                }\n\n                _latestValue = newValue;\n                if (DEBUG) dependentObservable._latestValue = _latestValue;\n\n                if (isSleeping) {\n                    dependentObservable.updateVersion();\n                } else if (notifyChange) {\n                    notify(_latestValue);\n                }\n            }\n\n            if (isInitial) {\n                notify(_latestValue, \"awake\");\n            }\n        } finally {\n            _isBeingEvaluated = false;\n        }\n\n        if (!_dependenciesCount)\n            dispose();\n    }\n\n    function dependentObservable() {\n        if (arguments.length > 0) {\n            if (typeof writeFunction === \"function\") {\n                // Writing a value\n                writeFunction.apply(evaluatorFunctionTarget, arguments);\n            } else {\n                throw new Error(\"Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.\");\n            }\n            return this; // Permits chained assignments\n        } else {\n            // Reading the value\n            ko.dependencyDetection.registerDependency(dependentObservable);\n            if (_needsEvaluation || (isSleeping && haveDependenciesChanged())) {\n                evaluateImmediate();\n            }\n            return _latestValue;\n        }\n    }\n\n    function peek() {\n        // Peek won't re-evaluate, except while the computed is sleeping or to get the initial value when \"deferEvaluation\" is set.\n        if ((_needsEvaluation && !_dependenciesCount) || (isSleeping && haveDependenciesChanged())) {\n            evaluateImmediate();\n        }\n        return _latestValue;\n    }\n\n    function isActive() {\n        return _needsEvaluation || _dependenciesCount > 0;\n    }\n\n    function notify(value, event) {\n        dependentObservable[\"notifySubscribers\"](value, event);\n    }\n\n    // By here, \"options\" is always non-null\n    var writeFunction = options[\"write\"],\n        disposeWhenNodeIsRemoved = options[\"disposeWhenNodeIsRemoved\"] || options.disposeWhenNodeIsRemoved || null,\n        disposeWhenOption = options[\"disposeWhen\"] || options.disposeWhen,\n        disposeWhen = disposeWhenOption,\n        dispose = disposeComputed,\n        dependencyTracking = {},\n        _dependenciesCount = 0,\n        evaluationTimeoutInstance = null;\n\n    if (!evaluatorFunctionTarget)\n        evaluatorFunctionTarget = options[\"owner\"];\n\n    ko.subscribable.call(dependentObservable);\n    ko.utils.setPrototypeOfOrExtend(dependentObservable, ko.dependentObservable['fn']);\n\n    dependentObservable.peek = peek;\n    dependentObservable.getDependenciesCount = function () { return _dependenciesCount; };\n    dependentObservable.hasWriteFunction = typeof writeFunction === \"function\";\n    dependentObservable.dispose = function () { dispose(); };\n    dependentObservable.isActive = isActive;\n\n    // Replace the limit function with one that delays evaluation as well.\n    var originalLimit = dependentObservable.limit;\n    dependentObservable.limit = function(limitFunction) {\n        originalLimit.call(dependentObservable, limitFunction);\n        dependentObservable._evalRateLimited = function() {\n            dependentObservable._rateLimitedBeforeChange(_latestValue);\n\n            _needsEvaluation = true;    // Mark as dirty\n\n            // Pass the observable to the rate-limit code, which will access it when\n            // it's time to do the notification.\n            dependentObservable._rateLimitedChange(dependentObservable);\n        }\n    };\n\n    if (options['pure']) {\n        pure = true;\n        isSleeping = true;     // Starts off sleeping; will awake on the first subscription\n        dependentObservable.beforeSubscriptionAdd = function (event) {\n            // If asleep, wake up the computed by subscribing to any dependencies.\n            if (!_isDisposed && isSleeping && event == 'change') {\n                isSleeping = false;\n                if (_needsEvaluation || haveDependenciesChanged()) {\n                    dependencyTracking = null;\n                    _dependenciesCount = 0;\n                    _needsEvaluation = true;\n                    evaluateImmediate();\n                } else {\n                    // First put the dependencies in order\n                    var dependeciesOrder = [];\n                    ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                        dependeciesOrder[dependency._order] = id;\n                    });\n                    // Next, subscribe to each one\n                    ko.utils.arrayForEach(dependeciesOrder, function(id, order) {\n                        var dependency = dependencyTracking[id],\n                            subscription = dependency._target.subscribe(evaluatePossiblyAsync);\n                        subscription._order = order;\n                        subscription._version = dependency._version;\n                        dependencyTracking[id] = subscription;\n                    });\n                }\n                if (!_isDisposed) {     // test since evaluating could trigger disposal\n                    notify(_latestValue, \"awake\");\n                }\n            }\n        };\n\n        dependentObservable.afterSubscriptionRemove = function (event) {\n            if (!_isDisposed && event == 'change' && !dependentObservable.hasSubscriptionsForEvent('change')) {\n                ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                    if (dependency.dispose) {\n                        dependencyTracking[id] = {\n                            _target: dependency._target,\n                            _order: dependency._order,\n                            _version: dependency._version\n                        };\n                        dependency.dispose();\n                    }\n                });\n                isSleeping = true;\n                notify(undefined, \"asleep\");\n            }\n        };\n\n        // Because a pure computed is not automatically updated while it is sleeping, we can't\n        // simply return the version number. Instead, we check if any of the dependencies have\n        // changed and conditionally re-evaluate the computed observable.\n        dependentObservable._originalGetVersion = dependentObservable.getVersion;\n        dependentObservable.getVersion = function () {\n            if (isSleeping && (_needsEvaluation || haveDependenciesChanged())) {\n                evaluateImmediate();\n            }\n            return dependentObservable._originalGetVersion();\n        };\n    } else if (options['deferEvaluation']) {\n        // This will force a computed with deferEvaluation to evaluate when the first subscriptions is registered.\n        dependentObservable.beforeSubscriptionAdd = function (event) {\n            if (event == 'change' || event == 'beforeChange') {\n                peek();\n            }\n        }\n    }\n\n    ko.exportProperty(dependentObservable, 'peek', dependentObservable.peek);\n    ko.exportProperty(dependentObservable, 'dispose', dependentObservable.dispose);\n    ko.exportProperty(dependentObservable, 'isActive', dependentObservable.isActive);\n    ko.exportProperty(dependentObservable, 'getDependenciesCount', dependentObservable.getDependenciesCount);\n\n    // Add a \"disposeWhen\" callback that, on each evaluation, disposes if the node was removed without using ko.removeNode.\n    if (disposeWhenNodeIsRemoved) {\n        // Since this computed is associated with a DOM node, and we don't want to dispose the computed\n        // until the DOM node is *removed* from the document (as opposed to never having been in the document),\n        // we'll prevent disposal until \"disposeWhen\" first returns false.\n        _suppressDisposalUntilDisposeWhenReturnsFalse = true;\n\n        // Only watch for the node's disposal if the value really is a node. It might not be,\n        // e.g., { disposeWhenNodeIsRemoved: true } can be used to opt into the \"only dispose\n        // after first false result\" behaviour even if there's no specific node to watch. This\n        // technique is intended for KO's internal use only and shouldn't be documented or used\n        // by application code, as it's likely to change in a future version of KO.\n        if (disposeWhenNodeIsRemoved.nodeType) {\n            disposeWhen = function () {\n                return !ko.utils.domNodeIsAttachedToDocument(disposeWhenNodeIsRemoved) || (disposeWhenOption && disposeWhenOption());\n            };\n        }\n    }\n\n    // Evaluate, unless sleeping or deferEvaluation is true\n    if (!isSleeping && !options['deferEvaluation'])\n        evaluateImmediate();\n\n    // Attach a DOM node disposal callback so that the computed will be proactively disposed as soon as the node is\n    // removed using ko.removeNode. But skip if isActive is false (there will never be any dependencies to dispose).\n    if (disposeWhenNodeIsRemoved && isActive() && disposeWhenNodeIsRemoved.nodeType) {\n        dispose = function() {\n            ko.utils.domNodeDisposal.removeDisposeCallback(disposeWhenNodeIsRemoved, dispose);\n            disposeComputed();\n        };\n        ko.utils.domNodeDisposal.addDisposeCallback(disposeWhenNodeIsRemoved, dispose);\n    }\n\n    return dependentObservable;\n};\n\nko.isComputed = function(instance) {\n    return ko.hasPrototype(instance, ko.dependentObservable);\n};\n\nvar protoProp = ko.observable.protoProperty; // == \"__ko_proto__\"\nko.dependentObservable[protoProp] = ko.observable;\n\nko.dependentObservable['fn'] = {\n    \"equalityComparer\": valuesArePrimitiveAndEqual\n};\nko.dependentObservable['fn'][protoProp] = ko.dependentObservable;\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.dependentObservable constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko.dependentObservable['fn'], ko.subscribable['fn']);\n}\n\nko.exportSymbol('dependentObservable', ko.dependentObservable);\nko.exportSymbol('computed', ko.dependentObservable); // Make \"ko.computed\" an alias for \"ko.dependentObservable\"\nko.exportSymbol('isComputed', ko.isComputed);\n\nko.pureComputed = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget) {\n    if (typeof evaluatorFunctionOrOptions === 'function') {\n        return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget, {'pure':true});\n    } else {\n        evaluatorFunctionOrOptions = ko.utils.extend({}, evaluatorFunctionOrOptions);   // make a copy of the parameter object\n        evaluatorFunctionOrOptions['pure'] = true;\n        return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget);\n    }\n}\nko.exportSymbol('pureComputed', ko.pureComputed);\n\n(function() {\n    var maxNestedObservableDepth = 10; // Escape the (unlikely) pathalogical case where an observable's current value is itself (or similar reference cycle)\n\n    ko.toJS = function(rootObject) {\n        if (arguments.length == 0)\n            throw new Error(\"When calling ko.toJS, pass the object you want to convert.\");\n\n        // We just unwrap everything at every level in the object graph\n        return mapJsObjectGraph(rootObject, function(valueToMap) {\n            // Loop because an observable's value might in turn be another observable wrapper\n            for (var i = 0; ko.isObservable(valueToMap) && (i < maxNestedObservableDepth); i++)\n                valueToMap = valueToMap();\n            return valueToMap;\n        });\n    };\n\n    ko.toJSON = function(rootObject, replacer, space) {     // replacer and space are optional\n        var plainJavaScriptObject = ko.toJS(rootObject);\n        return ko.utils.stringifyJson(plainJavaScriptObject, replacer, space);\n    };\n\n    function mapJsObjectGraph(rootObject, mapInputCallback, visitedObjects) {\n        visitedObjects = visitedObjects || new objectLookup();\n\n        rootObject = mapInputCallback(rootObject);\n        var canHaveProperties = (typeof rootObject == \"object\") && (rootObject !== null) && (rootObject !== undefined) && (!(rootObject instanceof Date)) && (!(rootObject instanceof String)) && (!(rootObject instanceof Number)) && (!(rootObject instanceof Boolean));\n        if (!canHaveProperties)\n            return rootObject;\n\n        var outputProperties = rootObject instanceof Array ? [] : {};\n        visitedObjects.save(rootObject, outputProperties);\n\n        visitPropertiesOrArrayEntries(rootObject, function(indexer) {\n            var propertyValue = mapInputCallback(rootObject[indexer]);\n\n            switch (typeof propertyValue) {\n                case \"boolean\":\n                case \"number\":\n                case \"string\":\n                case \"function\":\n                    outputProperties[indexer] = propertyValue;\n                    break;\n                case \"object\":\n                case \"undefined\":\n                    var previouslyMappedValue = visitedObjects.get(propertyValue);\n                    outputProperties[indexer] = (previouslyMappedValue !== undefined)\n                        ? previouslyMappedValue\n                        : mapJsObjectGraph(propertyValue, mapInputCallback, visitedObjects);\n                    break;\n            }\n        });\n\n        return outputProperties;\n    }\n\n    function visitPropertiesOrArrayEntries(rootObject, visitorCallback) {\n        if (rootObject instanceof Array) {\n            for (var i = 0; i < rootObject.length; i++)\n                visitorCallback(i);\n\n            // For arrays, also respect toJSON property for custom mappings (fixes #278)\n            if (typeof rootObject['toJSON'] == 'function')\n                visitorCallback('toJSON');\n        } else {\n            for (var propertyName in rootObject) {\n                visitorCallback(propertyName);\n            }\n        }\n    };\n\n    function objectLookup() {\n        this.keys = [];\n        this.values = [];\n    };\n\n    objectLookup.prototype = {\n        constructor: objectLookup,\n        save: function(key, value) {\n            var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n            if (existingIndex >= 0)\n                this.values[existingIndex] = value;\n            else {\n                this.keys.push(key);\n                this.values.push(value);\n            }\n        },\n        get: function(key) {\n            var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n            return (existingIndex >= 0) ? this.values[existingIndex] : undefined;\n        }\n    };\n})();\n\nko.exportSymbol('toJS', ko.toJS);\nko.exportSymbol('toJSON', ko.toJSON);\n(function () {\n    var hasDomDataExpandoProperty = '__ko__hasDomDataOptionValue__';\n\n    // Normally, SELECT elements and their OPTIONs can only take value of type 'string' (because the values\n    // are stored on DOM attributes). ko.selectExtensions provides a way for SELECTs/OPTIONs to have values\n    // that are arbitrary objects. This is very convenient when implementing things like cascading dropdowns.\n    ko.selectExtensions = {\n        readValue : function(element) {\n            switch (ko.utils.tagNameLower(element)) {\n                case 'option':\n                    if (element[hasDomDataExpandoProperty] === true)\n                        return ko.utils.domData.get(element, ko.bindingHandlers.options.optionValueDomDataKey);\n                    return ko.utils.ieVersion <= 7\n                        ? (element.getAttributeNode('value') && element.getAttributeNode('value').specified ? element.value : element.text)\n                        : element.value;\n                case 'select':\n                    return element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) : undefined;\n                default:\n                    return element.value;\n            }\n        },\n\n        writeValue: function(element, value, allowUnset) {\n            switch (ko.utils.tagNameLower(element)) {\n                case 'option':\n                    switch(typeof value) {\n                        case \"string\":\n                            ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, undefined);\n                            if (hasDomDataExpandoProperty in element) { // IE <= 8 throws errors if you delete non-existent properties from a DOM node\n                                delete element[hasDomDataExpandoProperty];\n                            }\n                            element.value = value;\n                            break;\n                        default:\n                            // Store arbitrary object using DomData\n                            ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, value);\n                            element[hasDomDataExpandoProperty] = true;\n\n                            // Special treatment of numbers is just for backward compatibility. KO 1.2.1 wrote numerical values to element.value.\n                            element.value = typeof value === \"number\" ? value : \"\";\n                            break;\n                    }\n                    break;\n                case 'select':\n                    if (value === \"\" || value === null)       // A blank string or null value will select the caption\n                        value = undefined;\n                    var selection = -1;\n                    for (var i = 0, n = element.options.length, optionValue; i < n; ++i) {\n                        optionValue = ko.selectExtensions.readValue(element.options[i]);\n                        // Include special check to handle selecting a caption with a blank string value\n                        if (optionValue == value || (optionValue == \"\" && value === undefined)) {\n                            selection = i;\n                            break;\n                        }\n                    }\n                    if (allowUnset || selection >= 0 || (value === undefined && element.size > 1)) {\n                        element.selectedIndex = selection;\n                    }\n                    break;\n                default:\n                    if ((value === null) || (value === undefined))\n                        value = \"\";\n                    element.value = value;\n                    break;\n            }\n        }\n    };\n})();\n\nko.exportSymbol('selectExtensions', ko.selectExtensions);\nko.exportSymbol('selectExtensions.readValue', ko.selectExtensions.readValue);\nko.exportSymbol('selectExtensions.writeValue', ko.selectExtensions.writeValue);\nko.expressionRewriting = (function () {\n    var javaScriptReservedWords = [\"true\", \"false\", \"null\", \"undefined\"];\n\n    // Matches something that can be assigned to--either an isolated identifier or something ending with a property accessor\n    // This is designed to be simple and avoid false negatives, but could produce false positives (e.g., a+b.c).\n    // This also will not properly handle nested brackets (e.g., obj1[obj2['prop']]; see #911).\n    var javaScriptAssignmentTarget = /^(?:[$_a-z][$\\w]*|(.+)(\\.\\s*[$_a-z][$\\w]*|\\[.+\\]))$/i;\n\n    function getWriteableValue(expression) {\n        if (ko.utils.arrayIndexOf(javaScriptReservedWords, expression) >= 0)\n            return false;\n        var match = expression.match(javaScriptAssignmentTarget);\n        return match === null ? false : match[1] ? ('Object(' + match[1] + ')' + match[2]) : expression;\n    }\n\n    // The following regular expressions will be used to split an object-literal string into tokens\n\n        // These two match strings, either with double quotes or single quotes\n    var stringDouble = '\"(?:[^\"\\\\\\\\]|\\\\\\\\.)*\"',\n        stringSingle = \"'(?:[^'\\\\\\\\]|\\\\\\\\.)*'\",\n        // Matches a regular expression (text enclosed by slashes), but will also match sets of divisions\n        // as a regular expression (this is handled by the parsing loop below).\n        stringRegexp = '/(?:[^/\\\\\\\\]|\\\\\\\\.)*/\\w*',\n        // These characters have special meaning to the parser and must not appear in the middle of a\n        // token, except as part of a string.\n        specials = ',\"\\'{}()/:[\\\\]',\n        // Match text (at least two characters) that does not contain any of the above special characters,\n        // although some of the special characters are allowed to start it (all but the colon and comma).\n        // The text can contain spaces, but leading or trailing spaces are skipped.\n        everyThingElse = '[^\\\\s:,/][^' + specials + ']*[^\\\\s' + specials + ']',\n        // Match any non-space character not matched already. This will match colons and commas, since they're\n        // not matched by \"everyThingElse\", but will also match any other single character that wasn't already\n        // matched (for example: in \"a: 1, b: 2\", each of the non-space characters will be matched by oneNotSpace).\n        oneNotSpace = '[^\\\\s]',\n\n        // Create the actual regular expression by or-ing the above strings. The order is important.\n        bindingToken = RegExp(stringDouble + '|' + stringSingle + '|' + stringRegexp + '|' + everyThingElse + '|' + oneNotSpace, 'g'),\n\n        // Match end of previous token to determine whether a slash is a division or regex.\n        divisionLookBehind = /[\\])\"'A-Za-z0-9_$]+$/,\n        keywordRegexLookBehind = {'in':1,'return':1,'typeof':1};\n\n    function parseObjectLiteral(objectLiteralString) {\n        // Trim leading and trailing spaces from the string\n        var str = ko.utils.stringTrim(objectLiteralString);\n\n        // Trim braces '{' surrounding the whole object literal\n        if (str.charCodeAt(0) === 123) str = str.slice(1, -1);\n\n        // Split into tokens\n        var result = [], toks = str.match(bindingToken), key, values = [], depth = 0;\n\n        if (toks) {\n            // Append a comma so that we don't need a separate code block to deal with the last item\n            toks.push(',');\n\n            for (var i = 0, tok; tok = toks[i]; ++i) {\n                var c = tok.charCodeAt(0);\n                // A comma signals the end of a key/value pair if depth is zero\n                if (c === 44) { // \",\"\n                    if (depth <= 0) {\n                        result.push((key && values.length) ? {key: key, value: values.join('')} : {'unknown': key || values.join('')});\n                        key = depth = 0;\n                        values = [];\n                        continue;\n                    }\n                // Simply skip the colon that separates the name and value\n                } else if (c === 58) { // \":\"\n                    if (!depth && !key && values.length === 1) {\n                        key = values.pop();\n                        continue;\n                    }\n                // A set of slashes is initially matched as a regular expression, but could be division\n                } else if (c === 47 && i && tok.length > 1) {  // \"/\"\n                    // Look at the end of the previous token to determine if the slash is actually division\n                    var match = toks[i-1].match(divisionLookBehind);\n                    if (match && !keywordRegexLookBehind[match[0]]) {\n                        // The slash is actually a division punctuator; re-parse the remainder of the string (not including the slash)\n                        str = str.substr(str.indexOf(tok) + 1);\n                        toks = str.match(bindingToken);\n                        toks.push(',');\n                        i = -1;\n                        // Continue with just the slash\n                        tok = '/';\n                    }\n                // Increment depth for parentheses, braces, and brackets so that interior commas are ignored\n                } else if (c === 40 || c === 123 || c === 91) { // '(', '{', '['\n                    ++depth;\n                } else if (c === 41 || c === 125 || c === 93) { // ')', '}', ']'\n                    --depth;\n                // The key will be the first token; if it's a string, trim the quotes\n                } else if (!key && !values.length && (c === 34 || c === 39)) { // '\"', \"'\"\n                    tok = tok.slice(1, -1);\n                }\n                values.push(tok);\n            }\n        }\n        return result;\n    }\n\n    // Two-way bindings include a write function that allow the handler to update the value even if it's not an observable.\n    var twoWayBindings = {};\n\n    function preProcessBindings(bindingsStringOrKeyValueArray, bindingOptions) {\n        bindingOptions = bindingOptions || {};\n\n        function processKeyValue(key, val) {\n            var writableVal;\n            function callPreprocessHook(obj) {\n                return (obj && obj['preprocess']) ? (val = obj['preprocess'](val, key, processKeyValue)) : true;\n            }\n            if (!bindingParams) {\n                if (!callPreprocessHook(ko['getBindingHandler'](key)))\n                    return;\n\n                if (twoWayBindings[key] && (writableVal = getWriteableValue(val))) {\n                    // For two-way bindings, provide a write method in case the value\n                    // isn't a writable observable.\n                    propertyAccessorResultStrings.push(\"'\" + key + \"':function(_z){\" + writableVal + \"=_z}\");\n                }\n            }\n            // Values are wrapped in a function so that each value can be accessed independently\n            if (makeValueAccessors) {\n                val = 'function(){return ' + val + ' }';\n            }\n            resultStrings.push(\"'\" + key + \"':\" + val);\n        }\n\n        var resultStrings = [],\n            propertyAccessorResultStrings = [],\n            makeValueAccessors = bindingOptions['valueAccessors'],\n            bindingParams = bindingOptions['bindingParams'],\n            keyValueArray = typeof bindingsStringOrKeyValueArray === \"string\" ?\n                parseObjectLiteral(bindingsStringOrKeyValueArray) : bindingsStringOrKeyValueArray;\n\n        ko.utils.arrayForEach(keyValueArray, function(keyValue) {\n            processKeyValue(keyValue.key || keyValue['unknown'], keyValue.value);\n        });\n\n        if (propertyAccessorResultStrings.length)\n            processKeyValue('_ko_property_writers', \"{\" + propertyAccessorResultStrings.join(\",\") + \" }\");\n\n        return resultStrings.join(\",\");\n    }\n\n    return {\n        bindingRewriteValidators: [],\n\n        twoWayBindings: twoWayBindings,\n\n        parseObjectLiteral: parseObjectLiteral,\n\n        preProcessBindings: preProcessBindings,\n\n        keyValueArrayContainsKey: function(keyValueArray, key) {\n            for (var i = 0; i < keyValueArray.length; i++)\n                if (keyValueArray[i]['key'] == key)\n                    return true;\n            return false;\n        },\n\n        // Internal, private KO utility for updating model properties from within bindings\n        // property:            If the property being updated is (or might be) an observable, pass it here\n        //                      If it turns out to be a writable observable, it will be written to directly\n        // allBindings:         An object with a get method to retrieve bindings in the current execution context.\n        //                      This will be searched for a '_ko_property_writers' property in case you're writing to a non-observable\n        // key:                 The key identifying the property to be written. Example: for { hasFocus: myValue }, write to 'myValue' by specifying the key 'hasFocus'\n        // value:               The value to be written\n        // checkIfDifferent:    If true, and if the property being written is a writable observable, the value will only be written if\n        //                      it is !== existing value on that writable observable\n        writeValueToProperty: function(property, allBindings, key, value, checkIfDifferent) {\n            if (!property || !ko.isObservable(property)) {\n                var propWriters = allBindings.get('_ko_property_writers');\n                if (propWriters && propWriters[key])\n                    propWriters[key](value);\n            } else if (ko.isWriteableObservable(property) && (!checkIfDifferent || property.peek() !== value)) {\n                property(value);\n            }\n        }\n    };\n})();\n\nko.exportSymbol('expressionRewriting', ko.expressionRewriting);\nko.exportSymbol('expressionRewriting.bindingRewriteValidators', ko.expressionRewriting.bindingRewriteValidators);\nko.exportSymbol('expressionRewriting.parseObjectLiteral', ko.expressionRewriting.parseObjectLiteral);\nko.exportSymbol('expressionRewriting.preProcessBindings', ko.expressionRewriting.preProcessBindings);\n\n// Making bindings explicitly declare themselves as \"two way\" isn't ideal in the long term (it would be better if\n// all bindings could use an official 'property writer' API without needing to declare that they might). However,\n// since this is not, and has never been, a public API (_ko_property_writers was never documented), it's acceptable\n// as an internal implementation detail in the short term.\n// For those developers who rely on _ko_property_writers in their custom bindings, we expose _twoWayBindings as an\n// undocumented feature that makes it relatively easy to upgrade to KO 3.0. However, this is still not an official\n// public API, and we reserve the right to remove it at any time if we create a real public property writers API.\nko.exportSymbol('expressionRewriting._twoWayBindings', ko.expressionRewriting.twoWayBindings);\n\n// For backward compatibility, define the following aliases. (Previously, these function names were misleading because\n// they referred to JSON specifically, even though they actually work with arbitrary JavaScript object literal expressions.)\nko.exportSymbol('jsonExpressionRewriting', ko.expressionRewriting);\nko.exportSymbol('jsonExpressionRewriting.insertPropertyAccessorsIntoJson', ko.expressionRewriting.preProcessBindings);\n(function() {\n    // \"Virtual elements\" is an abstraction on top of the usual DOM API which understands the notion that comment nodes\n    // may be used to represent hierarchy (in addition to the DOM's natural hierarchy).\n    // If you call the DOM-manipulating functions on ko.virtualElements, you will be able to read and write the state\n    // of that virtual hierarchy\n    //\n    // The point of all this is to support containerless templates (e.g., <!-- ko foreach:someCollection -->blah<!-- /ko -->)\n    // without having to scatter special cases all over the binding and templating code.\n\n    // IE 9 cannot reliably read the \"nodeValue\" property of a comment node (see https://github.com/SteveSanderson/knockout/issues/186)\n    // but it does give them a nonstandard alternative property called \"text\" that it can read reliably. Other browsers don't have that property.\n    // So, use node.text where available, and node.nodeValue elsewhere\n    var commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\n\n    var startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\n    var endCommentRegex =   commentNodesHaveTextProperty ? /^<!--\\s*\\/ko\\s*-->$/ : /^\\s*\\/ko\\s*$/;\n    var htmlTagsWithOptionallyClosingChildren = { 'ul': true, 'ol': true };\n\n    function isStartComment(node) {\n        return (node.nodeType == 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n    }\n\n    function isEndComment(node) {\n        return (node.nodeType == 8) && endCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n    }\n\n    function getVirtualChildren(startComment, allowUnbalanced) {\n        var currentNode = startComment;\n        var depth = 1;\n        var children = [];\n        while (currentNode = currentNode.nextSibling) {\n            if (isEndComment(currentNode)) {\n                depth--;\n                if (depth === 0)\n                    return children;\n            }\n\n            children.push(currentNode);\n\n            if (isStartComment(currentNode))\n                depth++;\n        }\n        if (!allowUnbalanced)\n            throw new Error(\"Cannot find closing comment tag to match: \" + startComment.nodeValue);\n        return null;\n    }\n\n    function getMatchingEndComment(startComment, allowUnbalanced) {\n        var allVirtualChildren = getVirtualChildren(startComment, allowUnbalanced);\n        if (allVirtualChildren) {\n            if (allVirtualChildren.length > 0)\n                return allVirtualChildren[allVirtualChildren.length - 1].nextSibling;\n            return startComment.nextSibling;\n        } else\n            return null; // Must have no matching end comment, and allowUnbalanced is true\n    }\n\n    function getUnbalancedChildTags(node) {\n        // e.g., from <div>OK</div><!-- ko blah --><span>Another</span>, returns: <!-- ko blah --><span>Another</span>\n        //       from <div>OK</div><!-- /ko --><!-- /ko -->,             returns: <!-- /ko --><!-- /ko -->\n        var childNode = node.firstChild, captureRemaining = null;\n        if (childNode) {\n            do {\n                if (captureRemaining)                   // We already hit an unbalanced node and are now just scooping up all subsequent nodes\n                    captureRemaining.push(childNode);\n                else if (isStartComment(childNode)) {\n                    var matchingEndComment = getMatchingEndComment(childNode, /* allowUnbalanced: */ true);\n                    if (matchingEndComment)             // It's a balanced tag, so skip immediately to the end of this virtual set\n                        childNode = matchingEndComment;\n                    else\n                        captureRemaining = [childNode]; // It's unbalanced, so start capturing from this point\n                } else if (isEndComment(childNode)) {\n                    captureRemaining = [childNode];     // It's unbalanced (if it wasn't, we'd have skipped over it already), so start capturing\n                }\n            } while (childNode = childNode.nextSibling);\n        }\n        return captureRemaining;\n    }\n\n    ko.virtualElements = {\n        allowedBindings: {},\n\n        childNodes: function(node) {\n            return isStartComment(node) ? getVirtualChildren(node) : node.childNodes;\n        },\n\n        emptyNode: function(node) {\n            if (!isStartComment(node))\n                ko.utils.emptyDomNode(node);\n            else {\n                var virtualChildren = ko.virtualElements.childNodes(node);\n                for (var i = 0, j = virtualChildren.length; i < j; i++)\n                    ko.removeNode(virtualChildren[i]);\n            }\n        },\n\n        setDomNodeChildren: function(node, childNodes) {\n            if (!isStartComment(node))\n                ko.utils.setDomNodeChildren(node, childNodes);\n            else {\n                ko.virtualElements.emptyNode(node);\n                var endCommentNode = node.nextSibling; // Must be the next sibling, as we just emptied the children\n                for (var i = 0, j = childNodes.length; i < j; i++)\n                    endCommentNode.parentNode.insertBefore(childNodes[i], endCommentNode);\n            }\n        },\n\n        prepend: function(containerNode, nodeToPrepend) {\n            if (!isStartComment(containerNode)) {\n                if (containerNode.firstChild)\n                    containerNode.insertBefore(nodeToPrepend, containerNode.firstChild);\n                else\n                    containerNode.appendChild(nodeToPrepend);\n            } else {\n                // Start comments must always have a parent and at least one following sibling (the end comment)\n                containerNode.parentNode.insertBefore(nodeToPrepend, containerNode.nextSibling);\n            }\n        },\n\n        insertAfter: function(containerNode, nodeToInsert, insertAfterNode) {\n            if (!insertAfterNode) {\n                ko.virtualElements.prepend(containerNode, nodeToInsert);\n            } else if (!isStartComment(containerNode)) {\n                // Insert after insertion point\n                if (insertAfterNode.nextSibling)\n                    containerNode.insertBefore(nodeToInsert, insertAfterNode.nextSibling);\n                else\n                    containerNode.appendChild(nodeToInsert);\n            } else {\n                // Children of start comments must always have a parent and at least one following sibling (the end comment)\n                containerNode.parentNode.insertBefore(nodeToInsert, insertAfterNode.nextSibling);\n            }\n        },\n\n        firstChild: function(node) {\n            if (!isStartComment(node))\n                return node.firstChild;\n            if (!node.nextSibling || isEndComment(node.nextSibling))\n                return null;\n            return node.nextSibling;\n        },\n\n        nextSibling: function(node) {\n            if (isStartComment(node))\n                node = getMatchingEndComment(node);\n            if (node.nextSibling && isEndComment(node.nextSibling))\n                return null;\n            return node.nextSibling;\n        },\n\n        hasBindingValue: isStartComment,\n\n        virtualNodeBindingValue: function(node) {\n            var regexMatch = (commentNodesHaveTextProperty ? node.text : node.nodeValue).match(startCommentRegex);\n            return regexMatch ? regexMatch[1] : null;\n        },\n\n        normaliseVirtualElementDomStructure: function(elementVerified) {\n            // Workaround for https://github.com/SteveSanderson/knockout/issues/155\n            // (IE <= 8 or IE 9 quirks mode parses your HTML weirdly, treating closing </li> tags as if they don't exist, thereby moving comment nodes\n            // that are direct descendants of <ul> into the preceding <li>)\n            if (!htmlTagsWithOptionallyClosingChildren[ko.utils.tagNameLower(elementVerified)])\n                return;\n\n            // Scan immediate children to see if they contain unbalanced comment tags. If they do, those comment tags\n            // must be intended to appear *after* that child, so move them there.\n            var childNode = elementVerified.firstChild;\n            if (childNode) {\n                do {\n                    if (childNode.nodeType === 1) {\n                        var unbalancedTags = getUnbalancedChildTags(childNode);\n                        if (unbalancedTags) {\n                            // Fix up the DOM by moving the unbalanced tags to where they most likely were intended to be placed - *after* the child\n                            var nodeToInsertBefore = childNode.nextSibling;\n                            for (var i = 0; i < unbalancedTags.length; i++) {\n                                if (nodeToInsertBefore)\n                                    elementVerified.insertBefore(unbalancedTags[i], nodeToInsertBefore);\n                                else\n                                    elementVerified.appendChild(unbalancedTags[i]);\n                            }\n                        }\n                    }\n                } while (childNode = childNode.nextSibling);\n            }\n        }\n    };\n})();\nko.exportSymbol('virtualElements', ko.virtualElements);\nko.exportSymbol('virtualElements.allowedBindings', ko.virtualElements.allowedBindings);\nko.exportSymbol('virtualElements.emptyNode', ko.virtualElements.emptyNode);\n//ko.exportSymbol('virtualElements.firstChild', ko.virtualElements.firstChild);     // firstChild is not minified\nko.exportSymbol('virtualElements.insertAfter', ko.virtualElements.insertAfter);\n//ko.exportSymbol('virtualElements.nextSibling', ko.virtualElements.nextSibling);   // nextSibling is not minified\nko.exportSymbol('virtualElements.prepend', ko.virtualElements.prepend);\nko.exportSymbol('virtualElements.setDomNodeChildren', ko.virtualElements.setDomNodeChildren);\n(function() {\n    var defaultBindingAttributeName = \"data-bind\";\n\n    ko.bindingProvider = function() {\n        this.bindingCache = {};\n    };\n\n    ko.utils.extend(ko.bindingProvider.prototype, {\n        'nodeHasBindings': function(node) {\n            switch (node.nodeType) {\n                case 1: // Element\n                    return node.getAttribute(defaultBindingAttributeName) != null\n                        || ko.components['getComponentNameForNode'](node);\n                case 8: // Comment node\n                    return ko.virtualElements.hasBindingValue(node);\n                default: return false;\n            }\n        },\n\n        'getBindings': function(node, bindingContext) {\n            var bindingsString = this['getBindingsString'](node, bindingContext),\n                parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node) : null;\n            return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ false);\n        },\n\n        'getBindingAccessors': function(node, bindingContext) {\n            var bindingsString = this['getBindingsString'](node, bindingContext),\n                parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node, { 'valueAccessors': true }) : null;\n            return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ true);\n        },\n\n        // The following function is only used internally by this default provider.\n        // It's not part of the interface definition for a general binding provider.\n        'getBindingsString': function(node, bindingContext) {\n            switch (node.nodeType) {\n                case 1: return node.getAttribute(defaultBindingAttributeName);   // Element\n                case 8: return ko.virtualElements.virtualNodeBindingValue(node); // Comment node\n                default: return null;\n            }\n        },\n\n        // The following function is only used internally by this default provider.\n        // It's not part of the interface definition for a general binding provider.\n        'parseBindingsString': function(bindingsString, bindingContext, node, options) {\n            try {\n                var bindingFunction = createBindingsStringEvaluatorViaCache(bindingsString, this.bindingCache, options);\n                return bindingFunction(bindingContext, node);\n            } catch (ex) {\n                ex.message = \"Unable to parse bindings.\\nBindings value: \" + bindingsString + \"\\nMessage: \" + ex.message;\n                throw ex;\n            }\n        }\n    });\n\n    ko.bindingProvider['instance'] = new ko.bindingProvider();\n\n    function createBindingsStringEvaluatorViaCache(bindingsString, cache, options) {\n        var cacheKey = bindingsString + (options && options['valueAccessors'] || '');\n        return cache[cacheKey]\n            || (cache[cacheKey] = createBindingsStringEvaluator(bindingsString, options));\n    }\n\n    function createBindingsStringEvaluator(bindingsString, options) {\n        // Build the source for a function that evaluates \"expression\"\n        // For each scope variable, add an extra level of \"with\" nesting\n        // Example result: with(sc1) { with(sc0) { return (expression) } }\n        var rewrittenBindings = ko.expressionRewriting.preProcessBindings(bindingsString, options),\n            functionBody = \"with($context){with($data||{}){return{\" + rewrittenBindings + \"}}}\";\n        return new Function(\"$context\", \"$element\", functionBody);\n    }\n})();\n\nko.exportSymbol('bindingProvider', ko.bindingProvider);\n(function () {\n    ko.bindingHandlers = {};\n\n    // The following element types will not be recursed into during binding. In the future, we\n    // may consider adding <template> to this list, because such elements' contents are always\n    // intended to be bound in a different context from where they appear in the document.\n    var bindingDoesNotRecurseIntoElementTypes = {\n        // Don't want bindings that operate on text nodes to mutate <script> and <textarea> contents,\n        // because it's unexpected and a potential XSS issue\n        'script': true,\n        'textarea': true\n    };\n\n    // Use an overridable method for retrieving binding handlers so that a plugins may support dynamically created handlers\n    ko['getBindingHandler'] = function(bindingKey) {\n        return ko.bindingHandlers[bindingKey];\n    };\n\n    // The ko.bindingContext constructor is only called directly to create the root context. For child\n    // contexts, use bindingContext.createChildContext or bindingContext.extend.\n    ko.bindingContext = function(dataItemOrAccessor, parentContext, dataItemAlias, extendCallback) {\n\n        // The binding context object includes static properties for the current, parent, and root view models.\n        // If a view model is actually stored in an observable, the corresponding binding context object, and\n        // any child contexts, must be updated when the view model is changed.\n        function updateContext() {\n            // Most of the time, the context will directly get a view model object, but if a function is given,\n            // we call the function to retrieve the view model. If the function accesses any obsevables or returns\n            // an observable, the dependency is tracked, and those observables can later cause the binding\n            // context to be updated.\n            var dataItemOrObservable = isFunc ? dataItemOrAccessor() : dataItemOrAccessor,\n                dataItem = ko.utils.unwrapObservable(dataItemOrObservable);\n\n            if (parentContext) {\n                // When a \"parent\" context is given, register a dependency on the parent context. Thus whenever the\n                // parent context is updated, this context will also be updated.\n                if (parentContext._subscribable)\n                    parentContext._subscribable();\n\n                // Copy $root and any custom properties from the parent context\n                ko.utils.extend(self, parentContext);\n\n                // Because the above copy overwrites our own properties, we need to reset them.\n                // During the first execution, \"subscribable\" isn't set, so don't bother doing the update then.\n                if (subscribable) {\n                    self._subscribable = subscribable;\n                }\n            } else {\n                self['$parents'] = [];\n                self['$root'] = dataItem;\n\n                // Export 'ko' in the binding context so it will be available in bindings and templates\n                // even if 'ko' isn't exported as a global, such as when using an AMD loader.\n                // See https://github.com/SteveSanderson/knockout/issues/490\n                self['ko'] = ko;\n            }\n            self['$rawData'] = dataItemOrObservable;\n            self['$data'] = dataItem;\n            if (dataItemAlias)\n                self[dataItemAlias] = dataItem;\n\n            // The extendCallback function is provided when creating a child context or extending a context.\n            // It handles the specific actions needed to finish setting up the binding context. Actions in this\n            // function could also add dependencies to this binding context.\n            if (extendCallback)\n                extendCallback(self, parentContext, dataItem);\n\n            return self['$data'];\n        }\n        function disposeWhen() {\n            return nodes && !ko.utils.anyDomNodeIsAttachedToDocument(nodes);\n        }\n\n        var self = this,\n            isFunc = typeof(dataItemOrAccessor) == \"function\" && !ko.isObservable(dataItemOrAccessor),\n            nodes,\n            subscribable = ko.dependentObservable(updateContext, null, { disposeWhen: disposeWhen, disposeWhenNodeIsRemoved: true });\n\n        // At this point, the binding context has been initialized, and the \"subscribable\" computed observable is\n        // subscribed to any observables that were accessed in the process. If there is nothing to track, the\n        // computed will be inactive, and we can safely throw it away. If it's active, the computed is stored in\n        // the context object.\n        if (subscribable.isActive()) {\n            self._subscribable = subscribable;\n\n            // Always notify because even if the model ($data) hasn't changed, other context properties might have changed\n            subscribable['equalityComparer'] = null;\n\n            // We need to be able to dispose of this computed observable when it's no longer needed. This would be\n            // easy if we had a single node to watch, but binding contexts can be used by many different nodes, and\n            // we cannot assume that those nodes have any relation to each other. So instead we track any node that\n            // the context is attached to, and dispose the computed when all of those nodes have been cleaned.\n\n            // Add properties to *subscribable* instead of *self* because any properties added to *self* may be overwritten on updates\n            nodes = [];\n            subscribable._addNode = function(node) {\n                nodes.push(node);\n                ko.utils.domNodeDisposal.addDisposeCallback(node, function(node) {\n                    ko.utils.arrayRemoveItem(nodes, node);\n                    if (!nodes.length) {\n                        subscribable.dispose();\n                        self._subscribable = subscribable = undefined;\n                    }\n                });\n            };\n        }\n    }\n\n    // Extend the binding context hierarchy with a new view model object. If the parent context is watching\n    // any obsevables, the new child context will automatically get a dependency on the parent context.\n    // But this does not mean that the $data value of the child context will also get updated. If the child\n    // view model also depends on the parent view model, you must provide a function that returns the correct\n    // view model on each update.\n    ko.bindingContext.prototype['createChildContext'] = function (dataItemOrAccessor, dataItemAlias, extendCallback) {\n        return new ko.bindingContext(dataItemOrAccessor, this, dataItemAlias, function(self, parentContext) {\n            // Extend the context hierarchy by setting the appropriate pointers\n            self['$parentContext'] = parentContext;\n            self['$parent'] = parentContext['$data'];\n            self['$parents'] = (parentContext['$parents'] || []).slice(0);\n            self['$parents'].unshift(self['$parent']);\n            if (extendCallback)\n                extendCallback(self);\n        });\n    };\n\n    // Extend the binding context with new custom properties. This doesn't change the context hierarchy.\n    // Similarly to \"child\" contexts, provide a function here to make sure that the correct values are set\n    // when an observable view model is updated.\n    ko.bindingContext.prototype['extend'] = function(properties) {\n        // If the parent context references an observable view model, \"_subscribable\" will always be the\n        // latest view model object. If not, \"_subscribable\" isn't set, and we can use the static \"$data\" value.\n        return new ko.bindingContext(this._subscribable || this['$data'], this, null, function(self, parentContext) {\n            // This \"child\" context doesn't directly track a parent observable view model,\n            // so we need to manually set the $rawData value to match the parent.\n            self['$rawData'] = parentContext['$rawData'];\n            ko.utils.extend(self, typeof(properties) == \"function\" ? properties() : properties);\n        });\n    };\n\n    // Returns the valueAccesor function for a binding value\n    function makeValueAccessor(value) {\n        return function() {\n            return value;\n        };\n    }\n\n    // Returns the value of a valueAccessor function\n    function evaluateValueAccessor(valueAccessor) {\n        return valueAccessor();\n    }\n\n    // Given a function that returns bindings, create and return a new object that contains\n    // binding value-accessors functions. Each accessor function calls the original function\n    // so that it always gets the latest value and all dependencies are captured. This is used\n    // by ko.applyBindingsToNode and getBindingsAndMakeAccessors.\n    function makeAccessorsFromFunction(callback) {\n        return ko.utils.objectMap(ko.dependencyDetection.ignore(callback), function(value, key) {\n            return function() {\n                return callback()[key];\n            };\n        });\n    }\n\n    // Given a bindings function or object, create and return a new object that contains\n    // binding value-accessors functions. This is used by ko.applyBindingsToNode.\n    function makeBindingAccessors(bindings, context, node) {\n        if (typeof bindings === 'function') {\n            return makeAccessorsFromFunction(bindings.bind(null, context, node));\n        } else {\n            return ko.utils.objectMap(bindings, makeValueAccessor);\n        }\n    }\n\n    // This function is used if the binding provider doesn't include a getBindingAccessors function.\n    // It must be called with 'this' set to the provider instance.\n    function getBindingsAndMakeAccessors(node, context) {\n        return makeAccessorsFromFunction(this['getBindings'].bind(this, node, context));\n    }\n\n    function validateThatBindingIsAllowedForVirtualElements(bindingName) {\n        var validator = ko.virtualElements.allowedBindings[bindingName];\n        if (!validator)\n            throw new Error(\"The binding '\" + bindingName + \"' cannot be used with virtual elements\")\n    }\n\n    function applyBindingsToDescendantsInternal (bindingContext, elementOrVirtualElement, bindingContextsMayDifferFromDomParentElement) {\n        var currentChild,\n            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement),\n            provider = ko.bindingProvider['instance'],\n            preprocessNode = provider['preprocessNode'];\n\n        // Preprocessing allows a binding provider to mutate a node before bindings are applied to it. For example it's\n        // possible to insert new siblings after it, and/or replace the node with a different one. This can be used to\n        // implement custom binding syntaxes, such as {{ value }} for string interpolation, or custom element types that\n        // trigger insertion of <template> contents at that point in the document.\n        if (preprocessNode) {\n            while (currentChild = nextInQueue) {\n                nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                preprocessNode.call(provider, currentChild);\n            }\n            // Reset nextInQueue for the next loop\n            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n        }\n\n        while (currentChild = nextInQueue) {\n            // Keep a record of the next child *before* applying bindings, in case the binding removes the current child from its position\n            nextInQueue = ko.virtualElements.nextSibling(currentChild);\n            applyBindingsToNodeAndDescendantsInternal(bindingContext, currentChild, bindingContextsMayDifferFromDomParentElement);\n        }\n    }\n\n    function applyBindingsToNodeAndDescendantsInternal (bindingContext, nodeVerified, bindingContextMayDifferFromDomParentElement) {\n        var shouldBindDescendants = true;\n\n        // Perf optimisation: Apply bindings only if...\n        // (1) We need to store the binding context on this node (because it may differ from the DOM parent node's binding context)\n        //     Note that we can't store binding contexts on non-elements (e.g., text nodes), as IE doesn't allow expando properties for those\n        // (2) It might have bindings (e.g., it has a data-bind attribute, or it's a marker for a containerless template)\n        var isElement = (nodeVerified.nodeType === 1);\n        if (isElement) // Workaround IE <= 8 HTML parsing weirdness\n            ko.virtualElements.normaliseVirtualElementDomStructure(nodeVerified);\n\n        var shouldApplyBindings = (isElement && bindingContextMayDifferFromDomParentElement)             // Case (1)\n                               || ko.bindingProvider['instance']['nodeHasBindings'](nodeVerified);       // Case (2)\n        if (shouldApplyBindings)\n            shouldBindDescendants = applyBindingsToNodeInternal(nodeVerified, null, bindingContext, bindingContextMayDifferFromDomParentElement)['shouldBindDescendants'];\n\n        if (shouldBindDescendants && !bindingDoesNotRecurseIntoElementTypes[ko.utils.tagNameLower(nodeVerified)]) {\n            // We're recursing automatically into (real or virtual) child nodes without changing binding contexts. So,\n            //  * For children of a *real* element, the binding context is certainly the same as on their DOM .parentNode,\n            //    hence bindingContextsMayDifferFromDomParentElement is false\n            //  * For children of a *virtual* element, we can't be sure. Evaluating .parentNode on those children may\n            //    skip over any number of intermediate virtual elements, any of which might define a custom binding context,\n            //    hence bindingContextsMayDifferFromDomParentElement is true\n            applyBindingsToDescendantsInternal(bindingContext, nodeVerified, /* bindingContextsMayDifferFromDomParentElement: */ !isElement);\n        }\n    }\n\n    var boundElementDomDataKey = ko.utils.domData.nextKey();\n\n\n    function topologicalSortBindings(bindings) {\n        // Depth-first sort\n        var result = [],                // The list of key/handler pairs that we will return\n            bindingsConsidered = {},    // A temporary record of which bindings are already in 'result'\n            cyclicDependencyStack = []; // Keeps track of a depth-search so that, if there's a cycle, we know which bindings caused it\n        ko.utils.objectForEach(bindings, function pushBinding(bindingKey) {\n            if (!bindingsConsidered[bindingKey]) {\n                var binding = ko['getBindingHandler'](bindingKey);\n                if (binding) {\n                    // First add dependencies (if any) of the current binding\n                    if (binding['after']) {\n                        cyclicDependencyStack.push(bindingKey);\n                        ko.utils.arrayForEach(binding['after'], function(bindingDependencyKey) {\n                            if (bindings[bindingDependencyKey]) {\n                                if (ko.utils.arrayIndexOf(cyclicDependencyStack, bindingDependencyKey) !== -1) {\n                                    throw Error(\"Cannot combine the following bindings, because they have a cyclic dependency: \" + cyclicDependencyStack.join(\", \"));\n                                } else {\n                                    pushBinding(bindingDependencyKey);\n                                }\n                            }\n                        });\n                        cyclicDependencyStack.length--;\n                    }\n                    // Next add the current binding\n                    result.push({ key: bindingKey, handler: binding });\n                }\n                bindingsConsidered[bindingKey] = true;\n            }\n        });\n\n        return result;\n    }\n\n    function applyBindingsToNodeInternal(node, sourceBindings, bindingContext, bindingContextMayDifferFromDomParentElement) {\n        // Prevent multiple applyBindings calls for the same node, except when a binding value is specified\n        var alreadyBound = ko.utils.domData.get(node, boundElementDomDataKey);\n        if (!sourceBindings) {\n            if (alreadyBound) {\n                throw Error(\"You cannot apply bindings multiple times to the same element.\");\n            }\n            ko.utils.domData.set(node, boundElementDomDataKey, true);\n        }\n\n        // Optimization: Don't store the binding context on this node if it's definitely the same as on node.parentNode, because\n        // we can easily recover it just by scanning up the node's ancestors in the DOM\n        // (note: here, parent node means \"real DOM parent\" not \"virtual parent\", as there's no O(1) way to find the virtual parent)\n        if (!alreadyBound && bindingContextMayDifferFromDomParentElement)\n            ko.storedBindingContextForNode(node, bindingContext);\n\n        // Use bindings if given, otherwise fall back on asking the bindings provider to give us some bindings\n        var bindings;\n        if (sourceBindings && typeof sourceBindings !== 'function') {\n            bindings = sourceBindings;\n        } else {\n            var provider = ko.bindingProvider['instance'],\n                getBindings = provider['getBindingAccessors'] || getBindingsAndMakeAccessors;\n\n            // Get the binding from the provider within a computed observable so that we can update the bindings whenever\n            // the binding context is updated or if the binding provider accesses observables.\n            var bindingsUpdater = ko.dependentObservable(\n                function() {\n                    bindings = sourceBindings ? sourceBindings(bindingContext, node) : getBindings.call(provider, node, bindingContext);\n                    // Register a dependency on the binding context to support obsevable view models.\n                    if (bindings && bindingContext._subscribable)\n                        bindingContext._subscribable();\n                    return bindings;\n                },\n                null, { disposeWhenNodeIsRemoved: node }\n            );\n\n            if (!bindings || !bindingsUpdater.isActive())\n                bindingsUpdater = null;\n        }\n\n        var bindingHandlerThatControlsDescendantBindings;\n        if (bindings) {\n            // Return the value accessor for a given binding. When bindings are static (won't be updated because of a binding\n            // context update), just return the value accessor from the binding. Otherwise, return a function that always gets\n            // the latest binding value and registers a dependency on the binding updater.\n            var getValueAccessor = bindingsUpdater\n                ? function(bindingKey) {\n                    return function() {\n                        return evaluateValueAccessor(bindingsUpdater()[bindingKey]);\n                    };\n                } : function(bindingKey) {\n                    return bindings[bindingKey];\n                };\n\n            // Use of allBindings as a function is maintained for backwards compatibility, but its use is deprecated\n            function allBindings() {\n                return ko.utils.objectMap(bindingsUpdater ? bindingsUpdater() : bindings, evaluateValueAccessor);\n            }\n            // The following is the 3.x allBindings API\n            allBindings['get'] = function(key) {\n                return bindings[key] && evaluateValueAccessor(getValueAccessor(key));\n            };\n            allBindings['has'] = function(key) {\n                return key in bindings;\n            };\n\n            // First put the bindings into the right order\n            var orderedBindings = topologicalSortBindings(bindings);\n\n            // Go through the sorted bindings, calling init and update for each\n            ko.utils.arrayForEach(orderedBindings, function(bindingKeyAndHandler) {\n                // Note that topologicalSortBindings has already filtered out any nonexistent binding handlers,\n                // so bindingKeyAndHandler.handler will always be nonnull.\n                var handlerInitFn = bindingKeyAndHandler.handler[\"init\"],\n                    handlerUpdateFn = bindingKeyAndHandler.handler[\"update\"],\n                    bindingKey = bindingKeyAndHandler.key;\n\n                if (node.nodeType === 8) {\n                    validateThatBindingIsAllowedForVirtualElements(bindingKey);\n                }\n\n                try {\n                    // Run init, ignoring any dependencies\n                    if (typeof handlerInitFn == \"function\") {\n                        ko.dependencyDetection.ignore(function() {\n                            var initResult = handlerInitFn(node, getValueAccessor(bindingKey), allBindings, bindingContext['$data'], bindingContext);\n\n                            // If this binding handler claims to control descendant bindings, make a note of this\n                            if (initResult && initResult['controlsDescendantBindings']) {\n                                if (bindingHandlerThatControlsDescendantBindings !== undefined)\n                                    throw new Error(\"Multiple bindings (\" + bindingHandlerThatControlsDescendantBindings + \" and \" + bindingKey + \") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.\");\n                                bindingHandlerThatControlsDescendantBindings = bindingKey;\n                            }\n                        });\n                    }\n\n                    // Run update in its own computed wrapper\n                    if (typeof handlerUpdateFn == \"function\") {\n                        ko.dependentObservable(\n                            function() {\n                                handlerUpdateFn(node, getValueAccessor(bindingKey), allBindings, bindingContext['$data'], bindingContext);\n                            },\n                            null,\n                            { disposeWhenNodeIsRemoved: node }\n                        );\n                    }\n                } catch (ex) {\n                    ex.message = \"Unable to process binding \\\"\" + bindingKey + \": \" + bindings[bindingKey] + \"\\\"\\nMessage: \" + ex.message;\n                    throw ex;\n                }\n            });\n        }\n\n        return {\n            'shouldBindDescendants': bindingHandlerThatControlsDescendantBindings === undefined\n        };\n    };\n\n    var storedBindingContextDomDataKey = ko.utils.domData.nextKey();\n    ko.storedBindingContextForNode = function (node, bindingContext) {\n        if (arguments.length == 2) {\n            ko.utils.domData.set(node, storedBindingContextDomDataKey, bindingContext);\n            if (bindingContext._subscribable)\n                bindingContext._subscribable._addNode(node);\n        } else {\n            return ko.utils.domData.get(node, storedBindingContextDomDataKey);\n        }\n    }\n\n    function getBindingContext(viewModelOrBindingContext) {\n        return viewModelOrBindingContext && (viewModelOrBindingContext instanceof ko.bindingContext)\n            ? viewModelOrBindingContext\n            : new ko.bindingContext(viewModelOrBindingContext);\n    }\n\n    ko.applyBindingAccessorsToNode = function (node, bindings, viewModelOrBindingContext) {\n        if (node.nodeType === 1) // If it's an element, workaround IE <= 8 HTML parsing weirdness\n            ko.virtualElements.normaliseVirtualElementDomStructure(node);\n        return applyBindingsToNodeInternal(node, bindings, getBindingContext(viewModelOrBindingContext), true);\n    };\n\n    ko.applyBindingsToNode = function (node, bindings, viewModelOrBindingContext) {\n        var context = getBindingContext(viewModelOrBindingContext);\n        return ko.applyBindingAccessorsToNode(node, makeBindingAccessors(bindings, context, node), context);\n    };\n\n    ko.applyBindingsToDescendants = function(viewModelOrBindingContext, rootNode) {\n        if (rootNode.nodeType === 1 || rootNode.nodeType === 8)\n            applyBindingsToDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode, true);\n    };\n\n    ko.applyBindings = function (viewModelOrBindingContext, rootNode) {\n        // If jQuery is loaded after Knockout, we won't initially have access to it. So save it here.\n        if (!jQueryInstance && window['jQuery']) {\n            jQueryInstance = window['jQuery'];\n        }\n\n        if (rootNode && (rootNode.nodeType !== 1) && (rootNode.nodeType !== 8))\n            throw new Error(\"ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node\");\n        rootNode = rootNode || window.document.body; // Make \"rootNode\" parameter optional\n\n        applyBindingsToNodeAndDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode, true);\n    };\n\n    // Retrieving binding context from arbitrary nodes\n    ko.contextFor = function(node) {\n        // We can only do something meaningful for elements and comment nodes (in particular, not text nodes, as IE can't store domdata for them)\n        switch (node.nodeType) {\n            case 1:\n            case 8:\n                var context = ko.storedBindingContextForNode(node);\n                if (context) return context;\n                if (node.parentNode) return ko.contextFor(node.parentNode);\n                break;\n        }\n        return undefined;\n    };\n    ko.dataFor = function(node) {\n        var context = ko.contextFor(node);\n        return context ? context['$data'] : undefined;\n    };\n\n    ko.exportSymbol('bindingHandlers', ko.bindingHandlers);\n    ko.exportSymbol('applyBindings', ko.applyBindings);\n    ko.exportSymbol('applyBindingsToDescendants', ko.applyBindingsToDescendants);\n    ko.exportSymbol('applyBindingAccessorsToNode', ko.applyBindingAccessorsToNode);\n    ko.exportSymbol('applyBindingsToNode', ko.applyBindingsToNode);\n    ko.exportSymbol('contextFor', ko.contextFor);\n    ko.exportSymbol('dataFor', ko.dataFor);\n})();\n(function(undefined) {\n    var loadingSubscribablesCache = {}, // Tracks component loads that are currently in flight\n        loadedDefinitionsCache = {};    // Tracks component loads that have already completed\n\n    ko.components = {\n        get: function(componentName, callback) {\n            var cachedDefinition = getObjectOwnProperty(loadedDefinitionsCache, componentName);\n            if (cachedDefinition) {\n                // It's already loaded and cached. Reuse the same definition object.\n                // Note that for API consistency, even cache hits complete asynchronously by default.\n                // You can bypass this by putting synchronous:true on your component config.\n                if (cachedDefinition.isSynchronousComponent) {\n                    ko.dependencyDetection.ignore(function() { // See comment in loaderRegistryBehaviors.js for reasoning\n                        callback(cachedDefinition.definition);\n                    });\n                } else {\n                    setTimeout(function() { callback(cachedDefinition.definition); }, 0);\n                }\n            } else {\n                // Join the loading process that is already underway, or start a new one.\n                loadComponentAndNotify(componentName, callback);\n            }\n        },\n\n        clearCachedDefinition: function(componentName) {\n            delete loadedDefinitionsCache[componentName];\n        },\n\n        _getFirstResultFromLoaders: getFirstResultFromLoaders\n    };\n\n    function getObjectOwnProperty(obj, propName) {\n        return obj.hasOwnProperty(propName) ? obj[propName] : undefined;\n    }\n\n    function loadComponentAndNotify(componentName, callback) {\n        var subscribable = getObjectOwnProperty(loadingSubscribablesCache, componentName),\n            completedAsync;\n        if (!subscribable) {\n            // It's not started loading yet. Start loading, and when it's done, move it to loadedDefinitionsCache.\n            subscribable = loadingSubscribablesCache[componentName] = new ko.subscribable();\n            subscribable.subscribe(callback);\n\n            beginLoadingComponent(componentName, function(definition, config) {\n                var isSynchronousComponent = !!(config && config['synchronous']);\n                loadedDefinitionsCache[componentName] = { definition: definition, isSynchronousComponent: isSynchronousComponent };\n                delete loadingSubscribablesCache[componentName];\n\n                // For API consistency, all loads complete asynchronously. However we want to avoid\n                // adding an extra setTimeout if it's unnecessary (i.e., the completion is already\n                // async) since setTimeout(..., 0) still takes about 16ms or more on most browsers.\n                //\n                // You can bypass the 'always synchronous' feature by putting the synchronous:true\n                // flag on your component configuration when you register it.\n                if (completedAsync || isSynchronousComponent) {\n                    // Note that notifySubscribers ignores any dependencies read within the callback.\n                    // See comment in loaderRegistryBehaviors.js for reasoning\n                    subscribable['notifySubscribers'](definition);\n                } else {\n                    setTimeout(function() {\n                        subscribable['notifySubscribers'](definition);\n                    }, 0);\n                }\n            });\n            completedAsync = true;\n        } else {\n            subscribable.subscribe(callback);\n        }\n    }\n\n    function beginLoadingComponent(componentName, callback) {\n        getFirstResultFromLoaders('getConfig', [componentName], function(config) {\n            if (config) {\n                // We have a config, so now load its definition\n                getFirstResultFromLoaders('loadComponent', [componentName, config], function(definition) {\n                    callback(definition, config);\n                });\n            } else {\n                // The component has no config - it's unknown to all the loaders.\n                // Note that this is not an error (e.g., a module loading error) - that would abort the\n                // process and this callback would not run. For this callback to run, all loaders must\n                // have confirmed they don't know about this component.\n                callback(null, null);\n            }\n        });\n    }\n\n    function getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders) {\n        // On the first call in the stack, start with the full set of loaders\n        if (!candidateLoaders) {\n            candidateLoaders = ko.components['loaders'].slice(0); // Use a copy, because we'll be mutating this array\n        }\n\n        // Try the next candidate\n        var currentCandidateLoader = candidateLoaders.shift();\n        if (currentCandidateLoader) {\n            var methodInstance = currentCandidateLoader[methodName];\n            if (methodInstance) {\n                var wasAborted = false,\n                    synchronousReturnValue = methodInstance.apply(currentCandidateLoader, argsExceptCallback.concat(function(result) {\n                        if (wasAborted) {\n                            callback(null);\n                        } else if (result !== null) {\n                            // This candidate returned a value. Use it.\n                            callback(result);\n                        } else {\n                            // Try the next candidate\n                            getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                        }\n                    }));\n\n                // Currently, loaders may not return anything synchronously. This leaves open the possibility\n                // that we'll extend the API to support synchronous return values in the future. It won't be\n                // a breaking change, because currently no loader is allowed to return anything except undefined.\n                if (synchronousReturnValue !== undefined) {\n                    wasAborted = true;\n\n                    // Method to suppress exceptions will remain undocumented. This is only to keep\n                    // KO's specs running tidily, since we can observe the loading got aborted without\n                    // having exceptions cluttering up the console too.\n                    if (!currentCandidateLoader['suppressLoaderExceptions']) {\n                        throw new Error('Component loaders must supply values by invoking the callback, not by returning values synchronously.');\n                    }\n                }\n            } else {\n                // This candidate doesn't have the relevant handler. Synchronously move on to the next one.\n                getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n            }\n        } else {\n            // No candidates returned a value\n            callback(null);\n        }\n    }\n\n    // Reference the loaders via string name so it's possible for developers\n    // to replace the whole array by assigning to ko.components.loaders\n    ko.components['loaders'] = [];\n\n    ko.exportSymbol('components', ko.components);\n    ko.exportSymbol('components.get', ko.components.get);\n    ko.exportSymbol('components.clearCachedDefinition', ko.components.clearCachedDefinition);\n})();\n(function(undefined) {\n\n    // The default loader is responsible for two things:\n    // 1. Maintaining the default in-memory registry of component configuration objects\n    //    (i.e., the thing you're writing to when you call ko.components.register(someName, ...))\n    // 2. Answering requests for components by fetching configuration objects\n    //    from that default in-memory registry and resolving them into standard\n    //    component definition objects (of the form { createViewModel: ..., template: ... })\n    // Custom loaders may override either of these facilities, i.e.,\n    // 1. To supply configuration objects from some other source (e.g., conventions)\n    // 2. Or, to resolve configuration objects by loading viewmodels/templates via arbitrary logic.\n\n    var defaultConfigRegistry = {};\n\n    ko.components.register = function(componentName, config) {\n        if (!config) {\n            throw new Error('Invalid configuration for ' + componentName);\n        }\n\n        if (ko.components.isRegistered(componentName)) {\n            throw new Error('Component ' + componentName + ' is already registered');\n        }\n\n        defaultConfigRegistry[componentName] = config;\n    }\n\n    ko.components.isRegistered = function(componentName) {\n        return componentName in defaultConfigRegistry;\n    }\n\n    ko.components.unregister = function(componentName) {\n        delete defaultConfigRegistry[componentName];\n        ko.components.clearCachedDefinition(componentName);\n    }\n\n    ko.components.defaultLoader = {\n        'getConfig': function(componentName, callback) {\n            var result = defaultConfigRegistry.hasOwnProperty(componentName)\n                ? defaultConfigRegistry[componentName]\n                : null;\n            callback(result);\n        },\n\n        'loadComponent': function(componentName, config, callback) {\n            var errorCallback = makeErrorCallback(componentName);\n            possiblyGetConfigFromAmd(errorCallback, config, function(loadedConfig) {\n                resolveConfig(componentName, errorCallback, loadedConfig, callback);\n            });\n        },\n\n        'loadTemplate': function(componentName, templateConfig, callback) {\n            resolveTemplate(makeErrorCallback(componentName), templateConfig, callback);\n        },\n\n        'loadViewModel': function(componentName, viewModelConfig, callback) {\n            resolveViewModel(makeErrorCallback(componentName), viewModelConfig, callback);\n        }\n    };\n\n    var createViewModelKey = 'createViewModel';\n\n    // Takes a config object of the form { template: ..., viewModel: ... }, and asynchronously convert it\n    // into the standard component definition format:\n    //    { template: <ArrayOfDomNodes>, createViewModel: function(params, componentInfo) { ... } }.\n    // Since both template and viewModel may need to be resolved asynchronously, both tasks are performed\n    // in parallel, and the results joined when both are ready. We don't depend on any promises infrastructure,\n    // so this is implemented manually below.\n    function resolveConfig(componentName, errorCallback, config, callback) {\n        var result = {},\n            makeCallBackWhenZero = 2,\n            tryIssueCallback = function() {\n                if (--makeCallBackWhenZero === 0) {\n                    callback(result);\n                }\n            },\n            templateConfig = config['template'],\n            viewModelConfig = config['viewModel'];\n\n        if (templateConfig) {\n            possiblyGetConfigFromAmd(errorCallback, templateConfig, function(loadedConfig) {\n                ko.components._getFirstResultFromLoaders('loadTemplate', [componentName, loadedConfig], function(resolvedTemplate) {\n                    result['template'] = resolvedTemplate;\n                    tryIssueCallback();\n                });\n            });\n        } else {\n            tryIssueCallback();\n        }\n\n        if (viewModelConfig) {\n            possiblyGetConfigFromAmd(errorCallback, viewModelConfig, function(loadedConfig) {\n                ko.components._getFirstResultFromLoaders('loadViewModel', [componentName, loadedConfig], function(resolvedViewModel) {\n                    result[createViewModelKey] = resolvedViewModel;\n                    tryIssueCallback();\n                });\n            });\n        } else {\n            tryIssueCallback();\n        }\n    }\n\n    function resolveTemplate(errorCallback, templateConfig, callback) {\n        if (typeof templateConfig === 'string') {\n            // Markup - parse it\n            callback(ko.utils.parseHtmlFragment(templateConfig));\n        } else if (templateConfig instanceof Array) {\n            // Assume already an array of DOM nodes - pass through unchanged\n            callback(templateConfig);\n        } else if (isDocumentFragment(templateConfig)) {\n            // Document fragment - use its child nodes\n            callback(ko.utils.makeArray(templateConfig.childNodes));\n        } else if (templateConfig['element']) {\n            var element = templateConfig['element'];\n            if (isDomElement(element)) {\n                // Element instance - copy its child nodes\n                callback(cloneNodesFromTemplateSourceElement(element));\n            } else if (typeof element === 'string') {\n                // Element ID - find it, then copy its child nodes\n                var elemInstance = document.getElementById(element);\n                if (elemInstance) {\n                    callback(cloneNodesFromTemplateSourceElement(elemInstance));\n                } else {\n                    errorCallback('Cannot find element with ID ' + element);\n                }\n            } else {\n                errorCallback('Unknown element type: ' + element);\n            }\n        } else {\n            errorCallback('Unknown template value: ' + templateConfig);\n        }\n    }\n\n    function resolveViewModel(errorCallback, viewModelConfig, callback) {\n        if (typeof viewModelConfig === 'function') {\n            // Constructor - convert to standard factory function format\n            // By design, this does *not* supply componentInfo to the constructor, as the intent is that\n            // componentInfo contains non-viewmodel data (e.g., the component's element) that should only\n            // be used in factory functions, not viewmodel constructors.\n            callback(function (params /*, componentInfo */) {\n                return new viewModelConfig(params);\n            });\n        } else if (typeof viewModelConfig[createViewModelKey] === 'function') {\n            // Already a factory function - use it as-is\n            callback(viewModelConfig[createViewModelKey]);\n        } else if ('instance' in viewModelConfig) {\n            // Fixed object instance - promote to createViewModel format for API consistency\n            var fixedInstance = viewModelConfig['instance'];\n            callback(function (params, componentInfo) {\n                return fixedInstance;\n            });\n        } else if ('viewModel' in viewModelConfig) {\n            // Resolved AMD module whose value is of the form { viewModel: ... }\n            resolveViewModel(errorCallback, viewModelConfig['viewModel'], callback);\n        } else {\n            errorCallback('Unknown viewModel value: ' + viewModelConfig);\n        }\n    }\n\n    function cloneNodesFromTemplateSourceElement(elemInstance) {\n        switch (ko.utils.tagNameLower(elemInstance)) {\n            case 'script':\n                return ko.utils.parseHtmlFragment(elemInstance.text);\n            case 'textarea':\n                return ko.utils.parseHtmlFragment(elemInstance.value);\n            case 'template':\n                // For browsers with proper <template> element support (i.e., where the .content property\n                // gives a document fragment), use that document fragment.\n                if (isDocumentFragment(elemInstance.content)) {\n                    return ko.utils.cloneNodes(elemInstance.content.childNodes);\n                }\n        }\n\n        // Regular elements such as <div>, and <template> elements on old browsers that don't really\n        // understand <template> and just treat it as a regular container\n        return ko.utils.cloneNodes(elemInstance.childNodes);\n    }\n\n    function isDomElement(obj) {\n        if (window['HTMLElement']) {\n            return obj instanceof HTMLElement;\n        } else {\n            return obj && obj.tagName && obj.nodeType === 1;\n        }\n    }\n\n    function isDocumentFragment(obj) {\n        if (window['DocumentFragment']) {\n            return obj instanceof DocumentFragment;\n        } else {\n            return obj && obj.nodeType === 11;\n        }\n    }\n\n    function possiblyGetConfigFromAmd(errorCallback, config, callback) {\n        if (typeof config['require'] === 'string') {\n            // The config is the value of an AMD module\n            if (amdRequire || window['require']) {\n                (amdRequire || window['require'])([config['require']], callback);\n            } else {\n                errorCallback('Uses require, but no AMD loader is present');\n            }\n        } else {\n            callback(config);\n        }\n    }\n\n    function makeErrorCallback(componentName) {\n        return function (message) {\n            throw new Error('Component \\'' + componentName + '\\': ' + message);\n        };\n    }\n\n    ko.exportSymbol('components.register', ko.components.register);\n    ko.exportSymbol('components.isRegistered', ko.components.isRegistered);\n    ko.exportSymbol('components.unregister', ko.components.unregister);\n\n    // Expose the default loader so that developers can directly ask it for configuration\n    // or to resolve configuration\n    ko.exportSymbol('components.defaultLoader', ko.components.defaultLoader);\n\n    // By default, the default loader is the only registered component loader\n    ko.components['loaders'].push(ko.components.defaultLoader);\n\n    // Privately expose the underlying config registry for use in old-IE shim\n    ko.components._allRegisteredComponents = defaultConfigRegistry;\n})();\n(function (undefined) {\n    // Overridable API for determining which component name applies to a given node. By overriding this,\n    // you can for example map specific tagNames to components that are not preregistered.\n    ko.components['getComponentNameForNode'] = function(node) {\n        var tagNameLower = ko.utils.tagNameLower(node);\n        return ko.components.isRegistered(tagNameLower) && tagNameLower;\n    };\n\n    ko.components.addBindingsForCustomElement = function(allBindings, node, bindingContext, valueAccessors) {\n        // Determine if it's really a custom element matching a component\n        if (node.nodeType === 1) {\n            var componentName = ko.components['getComponentNameForNode'](node);\n            if (componentName) {\n                // It does represent a component, so add a component binding for it\n                allBindings = allBindings || {};\n\n                if (allBindings['component']) {\n                    // Avoid silently overwriting some other 'component' binding that may already be on the element\n                    throw new Error('Cannot use the \"component\" binding on a custom element matching a component');\n                }\n\n                var componentBindingValue = { 'name': componentName, 'params': getComponentParamsFromCustomElement(node, bindingContext) };\n\n                allBindings['component'] = valueAccessors\n                    ? function() { return componentBindingValue; }\n                    : componentBindingValue;\n            }\n        }\n\n        return allBindings;\n    }\n\n    var nativeBindingProviderInstance = new ko.bindingProvider();\n\n    function getComponentParamsFromCustomElement(elem, bindingContext) {\n        var paramsAttribute = elem.getAttribute('params');\n\n        if (paramsAttribute) {\n            var params = nativeBindingProviderInstance['parseBindingsString'](paramsAttribute, bindingContext, elem, { 'valueAccessors': true, 'bindingParams': true }),\n                rawParamComputedValues = ko.utils.objectMap(params, function(paramValue, paramName) {\n                    return ko.computed(paramValue, null, { disposeWhenNodeIsRemoved: elem });\n                }),\n                result = ko.utils.objectMap(rawParamComputedValues, function(paramValueComputed, paramName) {\n                    var paramValue = paramValueComputed.peek();\n                    // Does the evaluation of the parameter value unwrap any observables?\n                    if (!paramValueComputed.isActive()) {\n                        // No it doesn't, so there's no need for any computed wrapper. Just pass through the supplied value directly.\n                        // Example: \"someVal: firstName, age: 123\" (whether or not firstName is an observable/computed)\n                        return paramValue;\n                    } else {\n                        // Yes it does. Supply a computed property that unwraps both the outer (binding expression)\n                        // level of observability, and any inner (resulting model value) level of observability.\n                        // This means the component doesn't have to worry about multiple unwrapping. If the value is a\n                        // writable observable, the computed will also be writable and pass the value on to the observable.\n                        return ko.computed({\n                            'read': function() {\n                                return ko.utils.unwrapObservable(paramValueComputed());\n                            },\n                            'write': ko.isWriteableObservable(paramValue) && function(value) {\n                                paramValueComputed()(value);\n                            },\n                            disposeWhenNodeIsRemoved: elem\n                        });\n                    }\n                });\n\n            // Give access to the raw computeds, as long as that wouldn't overwrite any custom param also called '$raw'\n            // This is in case the developer wants to react to outer (binding) observability separately from inner\n            // (model value) observability, or in case the model value observable has subobservables.\n            if (!result.hasOwnProperty('$raw')) {\n                result['$raw'] = rawParamComputedValues;\n            }\n\n            return result;\n        } else {\n            // For consistency, absence of a \"params\" attribute is treated the same as the presence of\n            // any empty one. Otherwise component viewmodels need special code to check whether or not\n            // 'params' or 'params.$raw' is null/undefined before reading subproperties, which is annoying.\n            return { '$raw': {} };\n        }\n    }\n\n    // --------------------------------------------------------------------------------\n    // Compatibility code for older (pre-HTML5) IE browsers\n\n    if (ko.utils.ieVersion < 9) {\n        // Whenever you preregister a component, enable it as a custom element in the current document\n        ko.components['register'] = (function(originalFunction) {\n            return function(componentName) {\n                document.createElement(componentName); // Allows IE<9 to parse markup containing the custom element\n                return originalFunction.apply(this, arguments);\n            }\n        })(ko.components['register']);\n\n        // Whenever you create a document fragment, enable all preregistered component names as custom elements\n        // This is needed to make innerShiv/jQuery HTML parsing correctly handle the custom elements\n        document.createDocumentFragment = (function(originalFunction) {\n            return function() {\n                var newDocFrag = originalFunction(),\n                    allComponents = ko.components._allRegisteredComponents;\n                for (var componentName in allComponents) {\n                    if (allComponents.hasOwnProperty(componentName)) {\n                        newDocFrag.createElement(componentName);\n                    }\n                }\n                return newDocFrag;\n            };\n        })(document.createDocumentFragment);\n    }\n})();(function(undefined) {\n\n    var componentLoadingOperationUniqueId = 0;\n\n    ko.bindingHandlers['component'] = {\n        'init': function(element, valueAccessor, ignored1, ignored2, bindingContext) {\n            var currentViewModel,\n                currentLoadingOperationId,\n                disposeAssociatedComponentViewModel = function () {\n                    var currentViewModelDispose = currentViewModel && currentViewModel['dispose'];\n                    if (typeof currentViewModelDispose === 'function') {\n                        currentViewModelDispose.call(currentViewModel);\n                    }\n\n                    // Any in-flight loading operation is no longer relevant, so make sure we ignore its completion\n                    currentLoadingOperationId = null;\n                },\n                originalChildNodes = ko.utils.makeArray(ko.virtualElements.childNodes(element));\n\n            ko.utils.domNodeDisposal.addDisposeCallback(element, disposeAssociatedComponentViewModel);\n\n            ko.computed(function () {\n                var value = ko.utils.unwrapObservable(valueAccessor()),\n                    componentName, componentParams;\n\n                if (typeof value === 'string') {\n                    componentName = value;\n                } else {\n                    componentName = ko.utils.unwrapObservable(value['name']);\n                    componentParams = ko.utils.unwrapObservable(value['params']);\n                }\n\n                if (!componentName) {\n                    throw new Error('No component name specified');\n                }\n\n                var loadingOperationId = currentLoadingOperationId = ++componentLoadingOperationUniqueId;\n                ko.components.get(componentName, function(componentDefinition) {\n                    // If this is not the current load operation for this element, ignore it.\n                    if (currentLoadingOperationId !== loadingOperationId) {\n                        return;\n                    }\n\n                    // Clean up previous state\n                    disposeAssociatedComponentViewModel();\n\n                    // Instantiate and bind new component. Implicitly this cleans any old DOM nodes.\n                    if (!componentDefinition) {\n                        throw new Error('Unknown component \\'' + componentName + '\\'');\n                    }\n                    cloneTemplateIntoElement(componentName, componentDefinition, element);\n                    var componentViewModel = createViewModel(componentDefinition, element, originalChildNodes, componentParams),\n                        childBindingContext = bindingContext['createChildContext'](componentViewModel, /* dataItemAlias */ undefined, function(ctx) {\n                            ctx['$component'] = componentViewModel;\n                            ctx['$componentTemplateNodes'] = originalChildNodes;\n                        });\n                    currentViewModel = componentViewModel;\n                    ko.applyBindingsToDescendants(childBindingContext, element);\n                });\n            }, null, { disposeWhenNodeIsRemoved: element });\n\n            return { 'controlsDescendantBindings': true };\n        }\n    };\n\n    ko.virtualElements.allowedBindings['component'] = true;\n\n    function cloneTemplateIntoElement(componentName, componentDefinition, element) {\n        var template = componentDefinition['template'];\n        if (!template) {\n            throw new Error('Component \\'' + componentName + '\\' has no template');\n        }\n\n        var clonedNodesArray = ko.utils.cloneNodes(template);\n        ko.virtualElements.setDomNodeChildren(element, clonedNodesArray);\n    }\n\n    function createViewModel(componentDefinition, element, originalChildNodes, componentParams) {\n        var componentViewModelFactory = componentDefinition['createViewModel'];\n        return componentViewModelFactory\n            ? componentViewModelFactory.call(componentDefinition, componentParams, { 'element': element, 'templateNodes': originalChildNodes })\n            : componentParams; // Template-only component\n    }\n\n})();\nvar attrHtmlToJavascriptMap = { 'class': 'className', 'for': 'htmlFor' };\nko.bindingHandlers['attr'] = {\n    'update': function(element, valueAccessor, allBindings) {\n        var value = ko.utils.unwrapObservable(valueAccessor()) || {};\n        ko.utils.objectForEach(value, function(attrName, attrValue) {\n            attrValue = ko.utils.unwrapObservable(attrValue);\n\n            // To cover cases like \"attr: { checked:someProp }\", we want to remove the attribute entirely\n            // when someProp is a \"no value\"-like value (strictly null, false, or undefined)\n            // (because the absence of the \"checked\" attr is how to mark an element as not checked, etc.)\n            var toRemove = (attrValue === false) || (attrValue === null) || (attrValue === undefined);\n            if (toRemove)\n                element.removeAttribute(attrName);\n\n            // In IE <= 7 and IE8 Quirks Mode, you have to use the Javascript property name instead of the\n            // HTML attribute name for certain attributes. IE8 Standards Mode supports the correct behavior,\n            // but instead of figuring out the mode, we'll just set the attribute through the Javascript\n            // property for IE <= 8.\n            if (ko.utils.ieVersion <= 8 && attrName in attrHtmlToJavascriptMap) {\n                attrName = attrHtmlToJavascriptMap[attrName];\n                if (toRemove)\n                    element.removeAttribute(attrName);\n                else\n                    element[attrName] = attrValue;\n            } else if (!toRemove) {\n                element.setAttribute(attrName, attrValue.toString());\n            }\n\n            // Treat \"name\" specially - although you can think of it as an attribute, it also needs\n            // special handling on older versions of IE (https://github.com/SteveSanderson/knockout/pull/333)\n            // Deliberately being case-sensitive here because XHTML would regard \"Name\" as a different thing\n            // entirely, and there's no strong reason to allow for such casing in HTML.\n            if (attrName === \"name\") {\n                ko.utils.setElementName(element, toRemove ? \"\" : attrValue.toString());\n            }\n        });\n    }\n};\n(function() {\n\nko.bindingHandlers['checked'] = {\n    'after': ['value', 'attr'],\n    'init': function (element, valueAccessor, allBindings) {\n        var checkedValue = ko.pureComputed(function() {\n            // Treat \"value\" like \"checkedValue\" when it is included with \"checked\" binding\n            if (allBindings['has']('checkedValue')) {\n                return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n            } else if (allBindings['has']('value')) {\n                return ko.utils.unwrapObservable(allBindings.get('value'));\n            }\n\n            return element.value;\n        });\n\n        function updateModel() {\n            // This updates the model value from the view value.\n            // It runs in response to DOM events (click) and changes in checkedValue.\n            var isChecked = element.checked,\n                elemValue = useCheckedValue ? checkedValue() : isChecked;\n\n            // When we're first setting up this computed, don't change any model state.\n            if (ko.computedContext.isInitial()) {\n                return;\n            }\n\n            // We can ignore unchecked radio buttons, because some other radio\n            // button will be getting checked, and that one can take care of updating state.\n            if (isRadio && !isChecked) {\n                return;\n            }\n\n            var modelValue = ko.dependencyDetection.ignore(valueAccessor);\n            if (isValueArray) {\n                if (oldElemValue !== elemValue) {\n                    // When we're responding to the checkedValue changing, and the element is\n                    // currently checked, replace the old elem value with the new elem value\n                    // in the model array.\n                    if (isChecked) {\n                        ko.utils.addOrRemoveItem(modelValue, elemValue, true);\n                        ko.utils.addOrRemoveItem(modelValue, oldElemValue, false);\n                    }\n\n                    oldElemValue = elemValue;\n                } else {\n                    // When we're responding to the user having checked/unchecked a checkbox,\n                    // add/remove the element value to the model array.\n                    ko.utils.addOrRemoveItem(modelValue, elemValue, isChecked);\n                }\n            } else {\n                ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n            }\n        };\n\n        function updateView() {\n            // This updates the view value from the model value.\n            // It runs in response to changes in the bound (checked) value.\n            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n            if (isValueArray) {\n                // When a checkbox is bound to an array, being checked represents its value being present in that array\n                element.checked = ko.utils.arrayIndexOf(modelValue, checkedValue()) >= 0;\n            } else if (isCheckbox) {\n                // When a checkbox is bound to any other value (not an array), being checked represents the value being trueish\n                element.checked = modelValue;\n            } else {\n                // For radio buttons, being checked means that the radio button's value corresponds to the model value\n                element.checked = (checkedValue() === modelValue);\n            }\n        };\n\n        var isCheckbox = element.type == \"checkbox\",\n            isRadio = element.type == \"radio\";\n\n        // Only bind to check boxes and radio buttons\n        if (!isCheckbox && !isRadio) {\n            return;\n        }\n\n        var isValueArray = isCheckbox && (ko.utils.unwrapObservable(valueAccessor()) instanceof Array),\n            oldElemValue = isValueArray ? checkedValue() : undefined,\n            useCheckedValue = isRadio || isValueArray;\n\n        // IE 6 won't allow radio buttons to be selected unless they have a name\n        if (isRadio && !element.name)\n            ko.bindingHandlers['uniqueName']['init'](element, function() { return true });\n\n        // Set up two computeds to update the binding:\n\n        // The first responds to changes in the checkedValue value and to element clicks\n        ko.computed(updateModel, null, { disposeWhenNodeIsRemoved: element });\n        ko.utils.registerEventHandler(element, \"click\", updateModel);\n\n        // The second responds to changes in the model value (the one associated with the checked binding)\n        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n    }\n};\nko.expressionRewriting.twoWayBindings['checked'] = true;\n\nko.bindingHandlers['checkedValue'] = {\n    'update': function (element, valueAccessor) {\n        element.value = ko.utils.unwrapObservable(valueAccessor());\n    }\n};\n\n})();var classesWrittenByBindingKey = '__ko__cssValue';\nko.bindingHandlers['css'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        if (value !== null && typeof value == \"object\") {\n            ko.utils.objectForEach(value, function(className, shouldHaveClass) {\n                shouldHaveClass = ko.utils.unwrapObservable(shouldHaveClass);\n                ko.utils.toggleDomNodeCssClass(element, className, shouldHaveClass);\n            });\n        } else {\n            value = String(value || ''); // Make sure we don't try to store or set a non-string value\n            ko.utils.toggleDomNodeCssClass(element, element[classesWrittenByBindingKey], false);\n            element[classesWrittenByBindingKey] = value;\n            ko.utils.toggleDomNodeCssClass(element, value, true);\n        }\n    }\n};\nko.bindingHandlers['enable'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        if (value && element.disabled)\n            element.removeAttribute(\"disabled\");\n        else if ((!value) && (!element.disabled))\n            element.disabled = true;\n    }\n};\n\nko.bindingHandlers['disable'] = {\n    'update': function (element, valueAccessor) {\n        ko.bindingHandlers['enable']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n    }\n};\n// For certain common events (currently just 'click'), allow a simplified data-binding syntax\n// e.g. click:handler instead of the usual full-length event:{click:handler}\nfunction makeEventHandlerShortcut(eventName) {\n    ko.bindingHandlers[eventName] = {\n        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var newValueAccessor = function () {\n                var result = {};\n                result[eventName] = valueAccessor();\n                return result;\n            };\n            return ko.bindingHandlers['event']['init'].call(this, element, newValueAccessor, allBindings, viewModel, bindingContext);\n        }\n    }\n}\n\nko.bindingHandlers['event'] = {\n    'init' : function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n        var eventsToHandle = valueAccessor() || {};\n        ko.utils.objectForEach(eventsToHandle, function(eventName) {\n            if (typeof eventName == \"string\") {\n                ko.utils.registerEventHandler(element, eventName, function (event) {\n                    var handlerReturnValue;\n                    var handlerFunction = valueAccessor()[eventName];\n                    if (!handlerFunction)\n                        return;\n\n                    try {\n                        // Take all the event args, and prefix with the viewmodel\n                        var argsForHandler = ko.utils.makeArray(arguments);\n                        viewModel = bindingContext['$data'];\n                        argsForHandler.unshift(viewModel);\n                        handlerReturnValue = handlerFunction.apply(viewModel, argsForHandler);\n                    } finally {\n                        if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                            if (event.preventDefault)\n                                event.preventDefault();\n                            else\n                                event.returnValue = false;\n                        }\n                    }\n\n                    var bubble = allBindings.get(eventName + 'Bubble') !== false;\n                    if (!bubble) {\n                        event.cancelBubble = true;\n                        if (event.stopPropagation)\n                            event.stopPropagation();\n                    }\n                });\n            }\n        });\n    }\n};\n// \"foreach: someExpression\" is equivalent to \"template: { foreach: someExpression }\"\n// \"foreach: { data: someExpression, afterAdd: myfn }\" is equivalent to \"template: { foreach: someExpression, afterAdd: myfn }\"\nko.bindingHandlers['foreach'] = {\n    makeTemplateValueAccessor: function(valueAccessor) {\n        return function() {\n            var modelValue = valueAccessor(),\n                unwrappedValue = ko.utils.peekObservable(modelValue);    // Unwrap without setting a dependency here\n\n            // If unwrappedValue is the array, pass in the wrapped value on its own\n            // The value will be unwrapped and tracked within the template binding\n            // (See https://github.com/SteveSanderson/knockout/issues/523)\n            if ((!unwrappedValue) || typeof unwrappedValue.length == \"number\")\n                return { 'foreach': modelValue, 'templateEngine': ko.nativeTemplateEngine.instance };\n\n            // If unwrappedValue.data is the array, preserve all relevant options and unwrap again value so we get updates\n            ko.utils.unwrapObservable(modelValue);\n            return {\n                'foreach': unwrappedValue['data'],\n                'as': unwrappedValue['as'],\n                'includeDestroyed': unwrappedValue['includeDestroyed'],\n                'afterAdd': unwrappedValue['afterAdd'],\n                'beforeRemove': unwrappedValue['beforeRemove'],\n                'afterRender': unwrappedValue['afterRender'],\n                'beforeMove': unwrappedValue['beforeMove'],\n                'afterMove': unwrappedValue['afterMove'],\n                'templateEngine': ko.nativeTemplateEngine.instance\n            };\n        };\n    },\n    'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n        return ko.bindingHandlers['template']['init'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor));\n    },\n    'update': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n        return ko.bindingHandlers['template']['update'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor), allBindings, viewModel, bindingContext);\n    }\n};\nko.expressionRewriting.bindingRewriteValidators['foreach'] = false; // Can't rewrite control flow bindings\nko.virtualElements.allowedBindings['foreach'] = true;\nvar hasfocusUpdatingProperty = '__ko_hasfocusUpdating';\nvar hasfocusLastValue = '__ko_hasfocusLastValue';\nko.bindingHandlers['hasfocus'] = {\n    'init': function(element, valueAccessor, allBindings) {\n        var handleElementFocusChange = function(isFocused) {\n            // Where possible, ignore which event was raised and determine focus state using activeElement,\n            // as this avoids phantom focus/blur events raised when changing tabs in modern browsers.\n            // However, not all KO-targeted browsers (Firefox 2) support activeElement. For those browsers,\n            // prevent a loss of focus when changing tabs/windows by setting a flag that prevents hasfocus\n            // from calling 'blur()' on the element when it loses focus.\n            // Discussion at https://github.com/SteveSanderson/knockout/pull/352\n            element[hasfocusUpdatingProperty] = true;\n            var ownerDoc = element.ownerDocument;\n            if (\"activeElement\" in ownerDoc) {\n                var active;\n                try {\n                    active = ownerDoc.activeElement;\n                } catch(e) {\n                    // IE9 throws if you access activeElement during page load (see issue #703)\n                    active = ownerDoc.body;\n                }\n                isFocused = (active === element);\n            }\n            var modelValue = valueAccessor();\n            ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'hasfocus', isFocused, true);\n\n            //cache the latest value, so we can avoid unnecessarily calling focus/blur in the update function\n            element[hasfocusLastValue] = isFocused;\n            element[hasfocusUpdatingProperty] = false;\n        };\n        var handleElementFocusIn = handleElementFocusChange.bind(null, true);\n        var handleElementFocusOut = handleElementFocusChange.bind(null, false);\n\n        ko.utils.registerEventHandler(element, \"focus\", handleElementFocusIn);\n        ko.utils.registerEventHandler(element, \"focusin\", handleElementFocusIn); // For IE\n        ko.utils.registerEventHandler(element, \"blur\",  handleElementFocusOut);\n        ko.utils.registerEventHandler(element, \"focusout\",  handleElementFocusOut); // For IE\n    },\n    'update': function(element, valueAccessor) {\n        var value = !!ko.utils.unwrapObservable(valueAccessor()); //force boolean to compare with last value\n        if (!element[hasfocusUpdatingProperty] && element[hasfocusLastValue] !== value) {\n            value ? element.focus() : element.blur();\n            ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, value ? \"focusin\" : \"focusout\"]); // For IE, which doesn't reliably fire \"focus\" or \"blur\" events synchronously\n        }\n    }\n};\nko.expressionRewriting.twoWayBindings['hasfocus'] = true;\n\nko.bindingHandlers['hasFocus'] = ko.bindingHandlers['hasfocus']; // Make \"hasFocus\" an alias\nko.expressionRewriting.twoWayBindings['hasFocus'] = true;\nko.bindingHandlers['html'] = {\n    'init': function() {\n        // Prevent binding on the dynamically-injected HTML (as developers are unlikely to expect that, and it has security implications)\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor) {\n        // setHtml will unwrap the value if needed\n        ko.utils.setHtml(element, valueAccessor());\n    }\n};\n// Makes a binding like with or if\nfunction makeWithIfBinding(bindingKey, isWith, isNot, makeContextCallback) {\n    ko.bindingHandlers[bindingKey] = {\n        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var didDisplayOnLastUpdate,\n                savedNodes;\n            ko.computed(function() {\n                var dataValue = ko.utils.unwrapObservable(valueAccessor()),\n                    shouldDisplay = !isNot !== !dataValue, // equivalent to isNot ? !dataValue : !!dataValue\n                    isFirstRender = !savedNodes,\n                    needsRefresh = isFirstRender || isWith || (shouldDisplay !== didDisplayOnLastUpdate);\n\n                if (needsRefresh) {\n                    // Save a copy of the inner nodes on the initial update, but only if we have dependencies.\n                    if (isFirstRender && ko.computedContext.getDependenciesCount()) {\n                        savedNodes = ko.utils.cloneNodes(ko.virtualElements.childNodes(element), true /* shouldCleanNodes */);\n                    }\n\n                    if (shouldDisplay) {\n                        if (!isFirstRender) {\n                            ko.virtualElements.setDomNodeChildren(element, ko.utils.cloneNodes(savedNodes));\n                        }\n                        ko.applyBindingsToDescendants(makeContextCallback ? makeContextCallback(bindingContext, dataValue) : bindingContext, element);\n                    } else {\n                        ko.virtualElements.emptyNode(element);\n                    }\n\n                    didDisplayOnLastUpdate = shouldDisplay;\n                }\n            }, null, { disposeWhenNodeIsRemoved: element });\n            return { 'controlsDescendantBindings': true };\n        }\n    };\n    ko.expressionRewriting.bindingRewriteValidators[bindingKey] = false; // Can't rewrite control flow bindings\n    ko.virtualElements.allowedBindings[bindingKey] = true;\n}\n\n// Construct the actual binding handlers\nmakeWithIfBinding('if');\nmakeWithIfBinding('ifnot', false /* isWith */, true /* isNot */);\nmakeWithIfBinding('with', true /* isWith */, false /* isNot */,\n    function(bindingContext, dataValue) {\n        return bindingContext['createChildContext'](dataValue);\n    }\n);\nvar captionPlaceholder = {};\nko.bindingHandlers['options'] = {\n    'init': function(element) {\n        if (ko.utils.tagNameLower(element) !== \"select\")\n            throw new Error(\"options binding applies only to SELECT elements\");\n\n        // Remove all existing <option>s.\n        while (element.length > 0) {\n            element.remove(0);\n        }\n\n        // Ensures that the binding processor doesn't try to bind the options\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor, allBindings) {\n        function selectedOptions() {\n            return ko.utils.arrayFilter(element.options, function (node) { return node.selected; });\n        }\n\n        var selectWasPreviouslyEmpty = element.length == 0,\n            multiple = element.multiple,\n            previousScrollTop = (!selectWasPreviouslyEmpty && multiple) ? element.scrollTop : null,\n            unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n            valueAllowUnset = allBindings.get('valueAllowUnset') && allBindings['has']('value'),\n            includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n            arrayToDomNodeChildrenOptions = {},\n            captionValue,\n            filteredArray,\n            previousSelectedValues = [];\n\n        if (!valueAllowUnset) {\n            if (multiple) {\n                previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);\n            } else if (element.selectedIndex >= 0) {\n                previousSelectedValues.push(ko.selectExtensions.readValue(element.options[element.selectedIndex]));\n            }\n        }\n\n        if (unwrappedArray) {\n            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                unwrappedArray = [unwrappedArray];\n\n            // Filter out any entries marked as destroyed\n            filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n            });\n\n            // If caption is included, add it to the array\n            if (allBindings['has']('optionsCaption')) {\n                captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                // If caption value is null or undefined, don't show a caption\n                if (captionValue !== null && captionValue !== undefined) {\n                    filteredArray.unshift(captionPlaceholder);\n                }\n            }\n        } else {\n            // If a falsy value is provided (e.g. null), we'll simply empty the select element\n        }\n\n        function applyToObject(object, predicate, defaultValue) {\n            var predicateType = typeof predicate;\n            if (predicateType == \"function\")    // Given a function; run it against the data value\n                return predicate(object);\n            else if (predicateType == \"string\") // Given a string; treat it as a property name on the data value\n                return object[predicate];\n            else                                // Given no optionsText arg; use the data value itself\n                return defaultValue;\n        }\n\n        // The following functions can run at two different times:\n        // The first is when the whole array is being updated directly from this binding handler.\n        // The second is when an observable value for a specific array entry is updated.\n        // oldOptions will be empty in the first case, but will be filled with the previously generated option in the second.\n        var itemUpdate = false;\n        function optionForArrayItem(arrayEntry, index, oldOptions) {\n            if (oldOptions.length) {\n                previousSelectedValues = !valueAllowUnset && oldOptions[0].selected ? [ ko.selectExtensions.readValue(oldOptions[0]) ] : [];\n                itemUpdate = true;\n            }\n            var option = element.ownerDocument.createElement(\"option\");\n            if (arrayEntry === captionPlaceholder) {\n                ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                ko.selectExtensions.writeValue(option, undefined);\n            } else {\n                // Apply a value to the option element\n                var optionValue = applyToObject(arrayEntry, allBindings.get('optionsValue'), arrayEntry);\n                ko.selectExtensions.writeValue(option, ko.utils.unwrapObservable(optionValue));\n\n                // Apply some text to the option element\n                var optionText = applyToObject(arrayEntry, allBindings.get('optionsText'), optionValue);\n                ko.utils.setTextContent(option, optionText);\n            }\n            return [option];\n        }\n\n        // By using a beforeRemove callback, we delay the removal until after new items are added. This fixes a selection\n        // problem in IE<=8 and Firefox. See https://github.com/knockout/knockout/issues/1208\n        arrayToDomNodeChildrenOptions['beforeRemove'] =\n            function (option) {\n                element.removeChild(option);\n            };\n\n        function setSelectionCallback(arrayEntry, newOptions) {\n            if (itemUpdate && valueAllowUnset) {\n                // The model value is authoritative, so make sure its value is the one selected\n                // There is no need to use dependencyDetection.ignore since setDomNodeChildrenFromArrayMapping does so already.\n                ko.selectExtensions.writeValue(element, ko.utils.unwrapObservable(allBindings.get('value')), true /* allowUnset */);\n            } else if (previousSelectedValues.length) {\n                // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                // That's why we first added them without selection. Now it's time to set the selection.\n                var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions[0])) >= 0;\n                ko.utils.setOptionNodeSelectionState(newOptions[0], isSelected);\n\n                // If this option was changed from being selected during a single-item update, notify the change\n                if (itemUpdate && !isSelected) {\n                    ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                }\n            }\n        }\n\n        var callback = setSelectionCallback;\n        if (allBindings['has']('optionsAfterRender') && typeof allBindings.get('optionsAfterRender') == \"function\") {\n            callback = function(arrayEntry, newOptions) {\n                setSelectionCallback(arrayEntry, newOptions);\n                ko.dependencyDetection.ignore(allBindings.get('optionsAfterRender'), null, [newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined]);\n            }\n        }\n\n        ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionForArrayItem, arrayToDomNodeChildrenOptions, callback);\n\n        ko.dependencyDetection.ignore(function () {\n            if (valueAllowUnset) {\n                // The model value is authoritative, so make sure its value is the one selected\n                ko.selectExtensions.writeValue(element, ko.utils.unwrapObservable(allBindings.get('value')), true /* allowUnset */);\n            } else {\n                // Determine if the selection has changed as a result of updating the options list\n                var selectionChanged;\n                if (multiple) {\n                    // For a multiple-select box, compare the new selection count to the previous one\n                    // But if nothing was selected before, the selection can't have changed\n                    selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;\n                } else {\n                    // For a single-select box, compare the current value to the previous value\n                    // But if nothing was selected before or nothing is selected now, just look for a change in selection\n                    selectionChanged = (previousSelectedValues.length && element.selectedIndex >= 0)\n                        ? (ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0])\n                        : (previousSelectedValues.length || element.selectedIndex >= 0);\n                }\n\n                // Ensure consistency between model value and selected option.\n                // If the dropdown was changed so that selection is no longer the same,\n                // notify the value or selectedOptions binding.\n                if (selectionChanged) {\n                    ko.utils.triggerEvent(element, \"change\");\n                }\n            }\n        });\n\n        // Workaround for IE bug\n        ko.utils.ensureSelectElementIsRenderedCorrectly(element);\n\n        if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20)\n            element.scrollTop = previousScrollTop;\n    }\n};\nko.bindingHandlers['options'].optionValueDomDataKey = ko.utils.domData.nextKey();\nko.bindingHandlers['selectedOptions'] = {\n    'after': ['options', 'foreach'],\n    'init': function (element, valueAccessor, allBindings) {\n        ko.utils.registerEventHandler(element, \"change\", function () {\n            var value = valueAccessor(), valueToWrite = [];\n            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                if (node.selected)\n                    valueToWrite.push(ko.selectExtensions.readValue(node));\n            });\n            ko.expressionRewriting.writeValueToProperty(value, allBindings, 'selectedOptions', valueToWrite);\n        });\n    },\n    'update': function (element, valueAccessor) {\n        if (ko.utils.tagNameLower(element) != \"select\")\n            throw new Error(\"values binding applies only to SELECT elements\");\n\n        var newValue = ko.utils.unwrapObservable(valueAccessor());\n        if (newValue && typeof newValue.length == \"number\") {\n            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                var isSelected = ko.utils.arrayIndexOf(newValue, ko.selectExtensions.readValue(node)) >= 0;\n                ko.utils.setOptionNodeSelectionState(node, isSelected);\n            });\n        }\n    }\n};\nko.expressionRewriting.twoWayBindings['selectedOptions'] = true;\nko.bindingHandlers['style'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor() || {});\n        ko.utils.objectForEach(value, function(styleName, styleValue) {\n            styleValue = ko.utils.unwrapObservable(styleValue);\n\n            if (styleValue === null || styleValue === undefined || styleValue === false) {\n                // Empty string removes the value, whereas null/undefined have no effect\n                styleValue = \"\";\n            }\n\n            element.style[styleName] = styleValue;\n        });\n    }\n};\nko.bindingHandlers['submit'] = {\n    'init': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n        if (typeof valueAccessor() != \"function\")\n            throw new Error(\"The value for a submit binding must be a function\");\n        ko.utils.registerEventHandler(element, \"submit\", function (event) {\n            var handlerReturnValue;\n            var value = valueAccessor();\n            try { handlerReturnValue = value.call(bindingContext['$data'], element); }\n            finally {\n                if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                    if (event.preventDefault)\n                        event.preventDefault();\n                    else\n                        event.returnValue = false;\n                }\n            }\n        });\n    }\n};\nko.bindingHandlers['text'] = {\n    'init': function() {\n        // Prevent binding on the dynamically-injected text node (as developers are unlikely to expect that, and it has security implications).\n        // It should also make things faster, as we no longer have to consider whether the text node might be bindable.\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor) {\n        ko.utils.setTextContent(element, valueAccessor());\n    }\n};\nko.virtualElements.allowedBindings['text'] = true;\n(function () {\n\nif (window && window.navigator) {\n    var parseVersion = function (matches) {\n        if (matches) {\n            return parseFloat(matches[1]);\n        }\n    };\n\n    // Detect various browser versions because some old versions don't fully support the 'input' event\n    var operaVersion = window.opera && window.opera.version && parseInt(window.opera.version()),\n        userAgent = window.navigator.userAgent,\n        safariVersion = parseVersion(userAgent.match(/^(?:(?!chrome).)*version\\/([^ ]*) safari/i)),\n        firefoxVersion = parseVersion(userAgent.match(/Firefox\\/([^ ]*)/));\n}\n\n// IE 8 and 9 have bugs that prevent the normal events from firing when the value changes.\n// But it does fire the 'selectionchange' event on many of those, presumably because the\n// cursor is moving and that counts as the selection changing. The 'selectionchange' event is\n// fired at the document level only and doesn't directly indicate which element changed. We\n// set up just one event handler for the document and use 'activeElement' to determine which\n// element was changed.\nif (ko.utils.ieVersion < 10) {\n    var selectionChangeRegisteredName = ko.utils.domData.nextKey(),\n        selectionChangeHandlerName = ko.utils.domData.nextKey();\n    var selectionChangeHandler = function(event) {\n        var target = this.activeElement,\n            handler = target && ko.utils.domData.get(target, selectionChangeHandlerName);\n        if (handler) {\n            handler(event);\n        }\n    };\n    var registerForSelectionChangeEvent = function (element, handler) {\n        var ownerDoc = element.ownerDocument;\n        if (!ko.utils.domData.get(ownerDoc, selectionChangeRegisteredName)) {\n            ko.utils.domData.set(ownerDoc, selectionChangeRegisteredName, true);\n            ko.utils.registerEventHandler(ownerDoc, 'selectionchange', selectionChangeHandler);\n        }\n        ko.utils.domData.set(element, selectionChangeHandlerName, handler);\n    };\n}\n\nko.bindingHandlers['textInput'] = {\n    'init': function (element, valueAccessor, allBindings) {\n\n        var previousElementValue = element.value,\n            timeoutHandle,\n            elementValueBeforeEvent;\n\n        var updateModel = function (event) {\n            clearTimeout(timeoutHandle);\n            elementValueBeforeEvent = timeoutHandle = undefined;\n\n            var elementValue = element.value;\n            if (previousElementValue !== elementValue) {\n                // Provide a way for tests to know exactly which event was processed\n                if (DEBUG && event) element['_ko_textInputProcessedEvent'] = event.type;\n                previousElementValue = elementValue;\n                ko.expressionRewriting.writeValueToProperty(valueAccessor(), allBindings, 'textInput', elementValue);\n            }\n        };\n\n        var deferUpdateModel = function (event) {\n            if (!timeoutHandle) {\n                // The elementValueBeforeEvent variable is set *only* during the brief gap between an\n                // event firing and the updateModel function running. This allows us to ignore model\n                // updates that are from the previous state of the element, usually due to techniques\n                // such as rateLimit. Such updates, if not ignored, can cause keystrokes to be lost.\n                elementValueBeforeEvent = element.value;\n                var handler = DEBUG ? updateModel.bind(element, {type: event.type}) : updateModel;\n                timeoutHandle = setTimeout(handler, 4);\n            }\n        };\n\n        var updateView = function () {\n            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n            if (modelValue === null || modelValue === undefined) {\n                modelValue = '';\n            }\n\n            if (elementValueBeforeEvent !== undefined && modelValue === elementValueBeforeEvent) {\n                setTimeout(updateView, 4);\n                return;\n            }\n\n            // Update the element only if the element and model are different. On some browsers, updating the value\n            // will move the cursor to the end of the input, which would be bad while the user is typing.\n            if (element.value !== modelValue) {\n                previousElementValue = modelValue;  // Make sure we ignore events (propertychange) that result from updating the value\n                element.value = modelValue;\n            }\n        };\n\n        var onEvent = function (event, handler) {\n            ko.utils.registerEventHandler(element, event, handler);\n        };\n\n        if (DEBUG && ko.bindingHandlers['textInput']['_forceUpdateOn']) {\n            // Provide a way for tests to specify exactly which events are bound\n            ko.utils.arrayForEach(ko.bindingHandlers['textInput']['_forceUpdateOn'], function(eventName) {\n                if (eventName.slice(0,5) == 'after') {\n                    onEvent(eventName.slice(5), deferUpdateModel);\n                } else {\n                    onEvent(eventName, updateModel);\n                }\n            });\n        } else {\n            if (ko.utils.ieVersion < 10) {\n                // Internet Explorer <= 8 doesn't support the 'input' event, but does include 'propertychange' that fires whenever\n                // any property of an element changes. Unlike 'input', it also fires if a property is changed from JavaScript code,\n                // but that's an acceptable compromise for this binding. IE 9 does support 'input', but since it doesn't fire it\n                // when using autocomplete, we'll use 'propertychange' for it also.\n                onEvent('propertychange', function(event) {\n                    if (event.propertyName === 'value') {\n                        updateModel(event);\n                    }\n                });\n\n                if (ko.utils.ieVersion == 8) {\n                    // IE 8 has a bug where it fails to fire 'propertychange' on the first update following a value change from\n                    // JavaScript code. It also doesn't fire if you clear the entire value. To fix this, we bind to the following\n                    // events too.\n                    onEvent('keyup', updateModel);      // A single keystoke\n                    onEvent('keydown', updateModel);    // The first character when a key is held down\n                }\n                if (ko.utils.ieVersion >= 8) {\n                    // Internet Explorer 9 doesn't fire the 'input' event when deleting text, including using\n                    // the backspace, delete, or ctrl-x keys, clicking the 'x' to clear the input, dragging text\n                    // out of the field, and cutting or deleting text using the context menu. 'selectionchange'\n                    // can detect all of those except dragging text out of the field, for which we use 'dragend'.\n                    // These are also needed in IE8 because of the bug described above.\n                    registerForSelectionChangeEvent(element, updateModel);  // 'selectionchange' covers cut, paste, drop, delete, etc.\n                    onEvent('dragend', deferUpdateModel);\n                }\n            } else {\n                // All other supported browsers support the 'input' event, which fires whenever the content of the element is changed\n                // through the user interface.\n                onEvent('input', updateModel);\n\n                if (safariVersion < 5 && ko.utils.tagNameLower(element) === \"textarea\") {\n                    // Safari <5 doesn't fire the 'input' event for <textarea> elements (it does fire 'textInput'\n                    // but only when typing). So we'll just catch as much as we can with keydown, cut, and paste.\n                    onEvent('keydown', deferUpdateModel);\n                    onEvent('paste', deferUpdateModel);\n                    onEvent('cut', deferUpdateModel);\n                } else if (operaVersion < 11) {\n                    // Opera 10 doesn't always fire the 'input' event for cut, paste, undo & drop operations.\n                    // We can try to catch some of those using 'keydown'.\n                    onEvent('keydown', deferUpdateModel);\n                } else if (firefoxVersion < 4.0) {\n                    // Firefox <= 3.6 doesn't fire the 'input' event when text is filled in through autocomplete\n                    onEvent('DOMAutoComplete', updateModel);\n\n                    // Firefox <=3.5 doesn't fire the 'input' event when text is dropped into the input.\n                    onEvent('dragdrop', updateModel);       // <3.5\n                    onEvent('drop', updateModel);           // 3.5\n                }\n            }\n        }\n\n        // Bind to the change event so that we can catch programmatic updates of the value that fire this event.\n        onEvent('change', updateModel);\n\n        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n    }\n};\nko.expressionRewriting.twoWayBindings['textInput'] = true;\n\n// textinput is an alias for textInput\nko.bindingHandlers['textinput'] = {\n    // preprocess is the only way to set up a full alias\n    'preprocess': function (value, name, addBinding) {\n        addBinding('textInput', value);\n    }\n};\n\n})();ko.bindingHandlers['uniqueName'] = {\n    'init': function (element, valueAccessor) {\n        if (valueAccessor()) {\n            var name = \"ko_unique_\" + (++ko.bindingHandlers['uniqueName'].currentIndex);\n            ko.utils.setElementName(element, name);\n        }\n    }\n};\nko.bindingHandlers['uniqueName'].currentIndex = 0;\nko.bindingHandlers['value'] = {\n    'after': ['options', 'foreach'],\n    'init': function (element, valueAccessor, allBindings) {\n        // If the value binding is placed on a radio/checkbox, then just pass through to checkedValue and quit\n        if (element.tagName.toLowerCase() == \"input\" && (element.type == \"checkbox\" || element.type == \"radio\")) {\n            ko.applyBindingAccessorsToNode(element, { 'checkedValue': valueAccessor });\n            return;\n        }\n\n        // Always catch \"change\" event; possibly other events too if asked\n        var eventsToCatch = [\"change\"];\n        var requestedEventsToCatch = allBindings.get(\"valueUpdate\");\n        var propertyChangedFired = false;\n        var elementValueBeforeEvent = null;\n\n        if (requestedEventsToCatch) {\n            if (typeof requestedEventsToCatch == \"string\") // Allow both individual event names, and arrays of event names\n                requestedEventsToCatch = [requestedEventsToCatch];\n            ko.utils.arrayPushAll(eventsToCatch, requestedEventsToCatch);\n            eventsToCatch = ko.utils.arrayGetDistinctValues(eventsToCatch);\n        }\n\n        var valueUpdateHandler = function() {\n            elementValueBeforeEvent = null;\n            propertyChangedFired = false;\n            var modelValue = valueAccessor();\n            var elementValue = ko.selectExtensions.readValue(element);\n            ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'value', elementValue);\n        }\n\n        // Workaround for https://github.com/SteveSanderson/knockout/issues/122\n        // IE doesn't fire \"change\" events on textboxes if the user selects a value from its autocomplete list\n        var ieAutoCompleteHackNeeded = ko.utils.ieVersion && element.tagName.toLowerCase() == \"input\" && element.type == \"text\"\n                                       && element.autocomplete != \"off\" && (!element.form || element.form.autocomplete != \"off\");\n        if (ieAutoCompleteHackNeeded && ko.utils.arrayIndexOf(eventsToCatch, \"propertychange\") == -1) {\n            ko.utils.registerEventHandler(element, \"propertychange\", function () { propertyChangedFired = true });\n            ko.utils.registerEventHandler(element, \"focus\", function () { propertyChangedFired = false });\n            ko.utils.registerEventHandler(element, \"blur\", function() {\n                if (propertyChangedFired) {\n                    valueUpdateHandler();\n                }\n            });\n        }\n\n        ko.utils.arrayForEach(eventsToCatch, function(eventName) {\n            // The syntax \"after<eventname>\" means \"run the handler asynchronously after the event\"\n            // This is useful, for example, to catch \"keydown\" events after the browser has updated the control\n            // (otherwise, ko.selectExtensions.readValue(this) will receive the control's value *before* the key event)\n            var handler = valueUpdateHandler;\n            if (ko.utils.stringStartsWith(eventName, \"after\")) {\n                handler = function() {\n                    // The elementValueBeforeEvent variable is non-null *only* during the brief gap between\n                    // a keyX event firing and the valueUpdateHandler running, which is scheduled to happen\n                    // at the earliest asynchronous opportunity. We store this temporary information so that\n                    // if, between keyX and valueUpdateHandler, the underlying model value changes separately,\n                    // we can overwrite that model value change with the value the user just typed. Otherwise,\n                    // techniques like rateLimit can trigger model changes at critical moments that will\n                    // override the user's inputs, causing keystrokes to be lost.\n                    elementValueBeforeEvent = ko.selectExtensions.readValue(element);\n                    setTimeout(valueUpdateHandler, 0);\n                };\n                eventName = eventName.substring(\"after\".length);\n            }\n            ko.utils.registerEventHandler(element, eventName, handler);\n        });\n\n        var updateFromModel = function () {\n            var newValue = ko.utils.unwrapObservable(valueAccessor());\n            var elementValue = ko.selectExtensions.readValue(element);\n\n            if (elementValueBeforeEvent !== null && newValue === elementValueBeforeEvent) {\n                setTimeout(updateFromModel, 0);\n                return;\n            }\n\n            var valueHasChanged = (newValue !== elementValue);\n\n            if (valueHasChanged) {\n                if (ko.utils.tagNameLower(element) === \"select\") {\n                    var allowUnset = allBindings.get('valueAllowUnset');\n                    var applyValueAction = function () {\n                        ko.selectExtensions.writeValue(element, newValue, allowUnset);\n                    };\n                    applyValueAction();\n\n                    if (!allowUnset && newValue !== ko.selectExtensions.readValue(element)) {\n                        // If you try to set a model value that can't be represented in an already-populated dropdown, reject that change,\n                        // because you're not allowed to have a model value that disagrees with a visible UI selection.\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                    } else {\n                        // Workaround for IE6 bug: It won't reliably apply values to SELECT nodes during the same execution thread\n                        // right after you've changed the set of OPTION nodes on it. So for that node type, we'll schedule a second thread\n                        // to apply the value as well.\n                        setTimeout(applyValueAction, 0);\n                    }\n                } else {\n                    ko.selectExtensions.writeValue(element, newValue);\n                }\n            }\n        };\n\n        ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n    },\n    'update': function() {} // Keep for backwards compatibility with code that may have wrapped value binding\n};\nko.expressionRewriting.twoWayBindings['value'] = true;\nko.bindingHandlers['visible'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        var isCurrentlyVisible = !(element.style.display == \"none\");\n        if (value && !isCurrentlyVisible)\n            element.style.display = \"\";\n        else if ((!value) && isCurrentlyVisible)\n            element.style.display = \"none\";\n    }\n};\n// 'click' is just a shorthand for the usual full-length event:{click:handler}\nmakeEventHandlerShortcut('click');\n// If you want to make a custom template engine,\n//\n// [1] Inherit from this class (like ko.nativeTemplateEngine does)\n// [2] Override 'renderTemplateSource', supplying a function with this signature:\n//\n//        function (templateSource, bindingContext, options) {\n//            // - templateSource.text() is the text of the template you should render\n//            // - bindingContext.$data is the data you should pass into the template\n//            //   - you might also want to make bindingContext.$parent, bindingContext.$parents,\n//            //     and bindingContext.$root available in the template too\n//            // - options gives you access to any other properties set on \"data-bind: { template: options }\"\n//            // - templateDocument is the document object of the template\n//            //\n//            // Return value: an array of DOM nodes\n//        }\n//\n// [3] Override 'createJavaScriptEvaluatorBlock', supplying a function with this signature:\n//\n//        function (script) {\n//            // Return value: Whatever syntax means \"Evaluate the JavaScript statement 'script' and output the result\"\n//            //               For example, the jquery.tmpl template engine converts 'someScript' to '${ someScript }'\n//        }\n//\n//     This is only necessary if you want to allow data-bind attributes to reference arbitrary template variables.\n//     If you don't want to allow that, you can set the property 'allowTemplateRewriting' to false (like ko.nativeTemplateEngine does)\n//     and then you don't need to override 'createJavaScriptEvaluatorBlock'.\n\nko.templateEngine = function () { };\n\nko.templateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n    throw new Error(\"Override renderTemplateSource\");\n};\n\nko.templateEngine.prototype['createJavaScriptEvaluatorBlock'] = function (script) {\n    throw new Error(\"Override createJavaScriptEvaluatorBlock\");\n};\n\nko.templateEngine.prototype['makeTemplateSource'] = function(template, templateDocument) {\n    // Named template\n    if (typeof template == \"string\") {\n        templateDocument = templateDocument || document;\n        var elem = templateDocument.getElementById(template);\n        if (!elem)\n            throw new Error(\"Cannot find template with ID \" + template);\n        return new ko.templateSources.domElement(elem);\n    } else if ((template.nodeType == 1) || (template.nodeType == 8)) {\n        // Anonymous template\n        return new ko.templateSources.anonymousTemplate(template);\n    } else\n        throw new Error(\"Unknown template type: \" + template);\n};\n\nko.templateEngine.prototype['renderTemplate'] = function (template, bindingContext, options, templateDocument) {\n    var templateSource = this['makeTemplateSource'](template, templateDocument);\n    return this['renderTemplateSource'](templateSource, bindingContext, options, templateDocument);\n};\n\nko.templateEngine.prototype['isTemplateRewritten'] = function (template, templateDocument) {\n    // Skip rewriting if requested\n    if (this['allowTemplateRewriting'] === false)\n        return true;\n    return this['makeTemplateSource'](template, templateDocument)['data'](\"isRewritten\");\n};\n\nko.templateEngine.prototype['rewriteTemplate'] = function (template, rewriterCallback, templateDocument) {\n    var templateSource = this['makeTemplateSource'](template, templateDocument);\n    var rewritten = rewriterCallback(templateSource['text']());\n    templateSource['text'](rewritten);\n    templateSource['data'](\"isRewritten\", true);\n};\n\nko.exportSymbol('templateEngine', ko.templateEngine);\n\nko.templateRewriting = (function () {\n    var memoizeDataBindingAttributeSyntaxRegex = /(<([a-z]+\\d*)(?:\\s+(?!data-bind\\s*=\\s*)[a-z0-9\\-]+(?:=(?:\\\"[^\\\"]*\\\"|\\'[^\\']*\\'|[^>]*))?)*\\s+)data-bind\\s*=\\s*([\"'])([\\s\\S]*?)\\3/gi;\n    var memoizeVirtualContainerBindingSyntaxRegex = /<!--\\s*ko\\b\\s*([\\s\\S]*?)\\s*-->/g;\n\n    function validateDataBindValuesForRewriting(keyValueArray) {\n        var allValidators = ko.expressionRewriting.bindingRewriteValidators;\n        for (var i = 0; i < keyValueArray.length; i++) {\n            var key = keyValueArray[i]['key'];\n            if (allValidators.hasOwnProperty(key)) {\n                var validator = allValidators[key];\n\n                if (typeof validator === \"function\") {\n                    var possibleErrorMessage = validator(keyValueArray[i]['value']);\n                    if (possibleErrorMessage)\n                        throw new Error(possibleErrorMessage);\n                } else if (!validator) {\n                    throw new Error(\"This template engine does not support the '\" + key + \"' binding within its templates\");\n                }\n            }\n        }\n    }\n\n    function constructMemoizedTagReplacement(dataBindAttributeValue, tagToRetain, nodeName, templateEngine) {\n        var dataBindKeyValueArray = ko.expressionRewriting.parseObjectLiteral(dataBindAttributeValue);\n        validateDataBindValuesForRewriting(dataBindKeyValueArray);\n        var rewrittenDataBindAttributeValue = ko.expressionRewriting.preProcessBindings(dataBindKeyValueArray, {'valueAccessors':true});\n\n        // For no obvious reason, Opera fails to evaluate rewrittenDataBindAttributeValue unless it's wrapped in an additional\n        // anonymous function, even though Opera's built-in debugger can evaluate it anyway. No other browser requires this\n        // extra indirection.\n        var applyBindingsToNextSiblingScript =\n            \"ko.__tr_ambtns(function($context,$element){return(function(){return{ \" + rewrittenDataBindAttributeValue + \" } })()},'\" + nodeName.toLowerCase() + \"')\";\n        return templateEngine['createJavaScriptEvaluatorBlock'](applyBindingsToNextSiblingScript) + tagToRetain;\n    }\n\n    return {\n        ensureTemplateIsRewritten: function (template, templateEngine, templateDocument) {\n            if (!templateEngine['isTemplateRewritten'](template, templateDocument))\n                templateEngine['rewriteTemplate'](template, function (htmlString) {\n                    return ko.templateRewriting.memoizeBindingAttributeSyntax(htmlString, templateEngine);\n                }, templateDocument);\n        },\n\n        memoizeBindingAttributeSyntax: function (htmlString, templateEngine) {\n            return htmlString.replace(memoizeDataBindingAttributeSyntaxRegex, function () {\n                return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[4], /* tagToRetain: */ arguments[1], /* nodeName: */ arguments[2], templateEngine);\n            }).replace(memoizeVirtualContainerBindingSyntaxRegex, function() {\n                return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[1], /* tagToRetain: */ \"<!-- ko -->\", /* nodeName: */ \"#comment\", templateEngine);\n            });\n        },\n\n        applyMemoizedBindingsToNextSibling: function (bindings, nodeName) {\n            return ko.memoization.memoize(function (domNode, bindingContext) {\n                var nodeToBind = domNode.nextSibling;\n                if (nodeToBind && nodeToBind.nodeName.toLowerCase() === nodeName) {\n                    ko.applyBindingAccessorsToNode(nodeToBind, bindings, bindingContext);\n                }\n            });\n        }\n    }\n})();\n\n\n// Exported only because it has to be referenced by string lookup from within rewritten template\nko.exportSymbol('__tr_ambtns', ko.templateRewriting.applyMemoizedBindingsToNextSibling);\n(function() {\n    // A template source represents a read/write way of accessing a template. This is to eliminate the need for template loading/saving\n    // logic to be duplicated in every template engine (and means they can all work with anonymous templates, etc.)\n    //\n    // Two are provided by default:\n    //  1. ko.templateSources.domElement       - reads/writes the text content of an arbitrary DOM element\n    //  2. ko.templateSources.anonymousElement - uses ko.utils.domData to read/write text *associated* with the DOM element, but\n    //                                           without reading/writing the actual element text content, since it will be overwritten\n    //                                           with the rendered template output.\n    // You can implement your own template source if you want to fetch/store templates somewhere other than in DOM elements.\n    // Template sources need to have the following functions:\n    //   text()             - returns the template text from your storage location\n    //   text(value)        - writes the supplied template text to your storage location\n    //   data(key)          - reads values stored using data(key, value) - see below\n    //   data(key, value)   - associates \"value\" with this template and the key \"key\". Is used to store information like \"isRewritten\".\n    //\n    // Optionally, template sources can also have the following functions:\n    //   nodes()            - returns a DOM element containing the nodes of this template, where available\n    //   nodes(value)       - writes the given DOM element to your storage location\n    // If a DOM element is available for a given template source, template engines are encouraged to use it in preference over text()\n    // for improved speed. However, all templateSources must supply text() even if they don't supply nodes().\n    //\n    // Once you've implemented a templateSource, make your template engine use it by subclassing whatever template engine you were\n    // using and overriding \"makeTemplateSource\" to return an instance of your custom template source.\n\n    ko.templateSources = {};\n\n    // ---- ko.templateSources.domElement -----\n\n    ko.templateSources.domElement = function(element) {\n        this.domElement = element;\n    }\n\n    ko.templateSources.domElement.prototype['text'] = function(/* valueToWrite */) {\n        var tagNameLower = ko.utils.tagNameLower(this.domElement),\n            elemContentsProperty = tagNameLower === \"script\" ? \"text\"\n                                 : tagNameLower === \"textarea\" ? \"value\"\n                                 : \"innerHTML\";\n\n        if (arguments.length == 0) {\n            return this.domElement[elemContentsProperty];\n        } else {\n            var valueToWrite = arguments[0];\n            if (elemContentsProperty === \"innerHTML\")\n                ko.utils.setHtml(this.domElement, valueToWrite);\n            else\n                this.domElement[elemContentsProperty] = valueToWrite;\n        }\n    };\n\n    var dataDomDataPrefix = ko.utils.domData.nextKey() + \"_\";\n    ko.templateSources.domElement.prototype['data'] = function(key /*, valueToWrite */) {\n        if (arguments.length === 1) {\n            return ko.utils.domData.get(this.domElement, dataDomDataPrefix + key);\n        } else {\n            ko.utils.domData.set(this.domElement, dataDomDataPrefix + key, arguments[1]);\n        }\n    };\n\n    // ---- ko.templateSources.anonymousTemplate -----\n    // Anonymous templates are normally saved/retrieved as DOM nodes through \"nodes\".\n    // For compatibility, you can also read \"text\"; it will be serialized from the nodes on demand.\n    // Writing to \"text\" is still supported, but then the template data will not be available as DOM nodes.\n\n    var anonymousTemplatesDomDataKey = ko.utils.domData.nextKey();\n    ko.templateSources.anonymousTemplate = function(element) {\n        this.domElement = element;\n    }\n    ko.templateSources.anonymousTemplate.prototype = new ko.templateSources.domElement();\n    ko.templateSources.anonymousTemplate.prototype.constructor = ko.templateSources.anonymousTemplate;\n    ko.templateSources.anonymousTemplate.prototype['text'] = function(/* valueToWrite */) {\n        if (arguments.length == 0) {\n            var templateData = ko.utils.domData.get(this.domElement, anonymousTemplatesDomDataKey) || {};\n            if (templateData.textData === undefined && templateData.containerData)\n                templateData.textData = templateData.containerData.innerHTML;\n            return templateData.textData;\n        } else {\n            var valueToWrite = arguments[0];\n            ko.utils.domData.set(this.domElement, anonymousTemplatesDomDataKey, {textData: valueToWrite});\n        }\n    };\n    ko.templateSources.domElement.prototype['nodes'] = function(/* valueToWrite */) {\n        if (arguments.length == 0) {\n            var templateData = ko.utils.domData.get(this.domElement, anonymousTemplatesDomDataKey) || {};\n            return templateData.containerData;\n        } else {\n            var valueToWrite = arguments[0];\n            ko.utils.domData.set(this.domElement, anonymousTemplatesDomDataKey, {containerData: valueToWrite});\n        }\n    };\n\n    ko.exportSymbol('templateSources', ko.templateSources);\n    ko.exportSymbol('templateSources.domElement', ko.templateSources.domElement);\n    ko.exportSymbol('templateSources.anonymousTemplate', ko.templateSources.anonymousTemplate);\n})();\n(function () {\n    var _templateEngine;\n    ko.setTemplateEngine = function (templateEngine) {\n        if ((templateEngine != undefined) && !(templateEngine instanceof ko.templateEngine))\n            throw new Error(\"templateEngine must inherit from ko.templateEngine\");\n        _templateEngine = templateEngine;\n    }\n\n    function invokeForEachNodeInContinuousRange(firstNode, lastNode, action) {\n        var node, nextInQueue = firstNode, firstOutOfRangeNode = ko.virtualElements.nextSibling(lastNode);\n        while (nextInQueue && ((node = nextInQueue) !== firstOutOfRangeNode)) {\n            nextInQueue = ko.virtualElements.nextSibling(node);\n            action(node, nextInQueue);\n        }\n    }\n\n    function activateBindingsOnContinuousNodeArray(continuousNodeArray, bindingContext) {\n        // To be used on any nodes that have been rendered by a template and have been inserted into some parent element\n        // Walks through continuousNodeArray (which *must* be continuous, i.e., an uninterrupted sequence of sibling nodes, because\n        // the algorithm for walking them relies on this), and for each top-level item in the virtual-element sense,\n        // (1) Does a regular \"applyBindings\" to associate bindingContext with this node and to activate any non-memoized bindings\n        // (2) Unmemoizes any memos in the DOM subtree (e.g., to activate bindings that had been memoized during template rewriting)\n\n        if (continuousNodeArray.length) {\n            var firstNode = continuousNodeArray[0],\n                lastNode = continuousNodeArray[continuousNodeArray.length - 1],\n                parentNode = firstNode.parentNode,\n                provider = ko.bindingProvider['instance'],\n                preprocessNode = provider['preprocessNode'];\n\n            if (preprocessNode) {\n                invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node, nextNodeInRange) {\n                    var nodePreviousSibling = node.previousSibling;\n                    var newNodes = preprocessNode.call(provider, node);\n                    if (newNodes) {\n                        if (node === firstNode)\n                            firstNode = newNodes[0] || nextNodeInRange;\n                        if (node === lastNode)\n                            lastNode = newNodes[newNodes.length - 1] || nodePreviousSibling;\n                    }\n                });\n\n                // Because preprocessNode can change the nodes, including the first and last nodes, update continuousNodeArray to match.\n                // We need the full set, including inner nodes, because the unmemoize step might remove the first node (and so the real\n                // first node needs to be in the array).\n                continuousNodeArray.length = 0;\n                if (!firstNode) { // preprocessNode might have removed all the nodes, in which case there's nothing left to do\n                    return;\n                }\n                if (firstNode === lastNode) {\n                    continuousNodeArray.push(firstNode);\n                } else {\n                    continuousNodeArray.push(firstNode, lastNode);\n                    ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                }\n            }\n\n            // Need to applyBindings *before* unmemoziation, because unmemoization might introduce extra nodes (that we don't want to re-bind)\n            // whereas a regular applyBindings won't introduce new memoized nodes\n            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                if (node.nodeType === 1 || node.nodeType === 8)\n                    ko.applyBindings(bindingContext, node);\n            });\n            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                if (node.nodeType === 1 || node.nodeType === 8)\n                    ko.memoization.unmemoizeDomNodeAndDescendants(node, [bindingContext]);\n            });\n\n            // Make sure any changes done by applyBindings or unmemoize are reflected in the array\n            ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n        }\n    }\n\n    function getFirstNodeFromPossibleArray(nodeOrNodeArray) {\n        return nodeOrNodeArray.nodeType ? nodeOrNodeArray\n                                        : nodeOrNodeArray.length > 0 ? nodeOrNodeArray[0]\n                                        : null;\n    }\n\n    function executeTemplate(targetNodeOrNodeArray, renderMode, template, bindingContext, options) {\n        options = options || {};\n        var firstTargetNode = targetNodeOrNodeArray && getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n        var templateDocument = (firstTargetNode || template || {}).ownerDocument;\n        var templateEngineToUse = (options['templateEngine'] || _templateEngine);\n        ko.templateRewriting.ensureTemplateIsRewritten(template, templateEngineToUse, templateDocument);\n        var renderedNodesArray = templateEngineToUse['renderTemplate'](template, bindingContext, options, templateDocument);\n\n        // Loosely check result is an array of DOM nodes\n        if ((typeof renderedNodesArray.length != \"number\") || (renderedNodesArray.length > 0 && typeof renderedNodesArray[0].nodeType != \"number\"))\n            throw new Error(\"Template engine must return an array of DOM nodes\");\n\n        var haveAddedNodesToParent = false;\n        switch (renderMode) {\n            case \"replaceChildren\":\n                ko.virtualElements.setDomNodeChildren(targetNodeOrNodeArray, renderedNodesArray);\n                haveAddedNodesToParent = true;\n                break;\n            case \"replaceNode\":\n                ko.utils.replaceDomNodes(targetNodeOrNodeArray, renderedNodesArray);\n                haveAddedNodesToParent = true;\n                break;\n            case \"ignoreTargetNode\": break;\n            default:\n                throw new Error(\"Unknown renderMode: \" + renderMode);\n        }\n\n        if (haveAddedNodesToParent) {\n            activateBindingsOnContinuousNodeArray(renderedNodesArray, bindingContext);\n            if (options['afterRender'])\n                ko.dependencyDetection.ignore(options['afterRender'], null, [renderedNodesArray, bindingContext['$data']]);\n        }\n\n        return renderedNodesArray;\n    }\n\n    function resolveTemplateName(template, data, context) {\n        // The template can be specified as:\n        if (ko.isObservable(template)) {\n            // 1. An observable, with string value\n            return template();\n        } else if (typeof template === 'function') {\n            // 2. A function of (data, context) returning a string\n            return template(data, context);\n        } else {\n            // 3. A string\n            return template;\n        }\n    }\n\n    ko.renderTemplate = function (template, dataOrBindingContext, options, targetNodeOrNodeArray, renderMode) {\n        options = options || {};\n        if ((options['templateEngine'] || _templateEngine) == undefined)\n            throw new Error(\"Set a template engine before calling renderTemplate\");\n        renderMode = renderMode || \"replaceChildren\";\n\n        if (targetNodeOrNodeArray) {\n            var firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n\n            var whenToDispose = function () { return (!firstTargetNode) || !ko.utils.domNodeIsAttachedToDocument(firstTargetNode); }; // Passive disposal (on next evaluation)\n            var activelyDisposeWhenNodeIsRemoved = (firstTargetNode && renderMode == \"replaceNode\") ? firstTargetNode.parentNode : firstTargetNode;\n\n            return ko.dependentObservable( // So the DOM is automatically updated when any dependency changes\n                function () {\n                    // Ensure we've got a proper binding context to work with\n                    var bindingContext = (dataOrBindingContext && (dataOrBindingContext instanceof ko.bindingContext))\n                        ? dataOrBindingContext\n                        : new ko.bindingContext(ko.utils.unwrapObservable(dataOrBindingContext));\n\n                    var templateName = resolveTemplateName(template, bindingContext['$data'], bindingContext),\n                        renderedNodesArray = executeTemplate(targetNodeOrNodeArray, renderMode, templateName, bindingContext, options);\n\n                    if (renderMode == \"replaceNode\") {\n                        targetNodeOrNodeArray = renderedNodesArray;\n                        firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                    }\n                },\n                null,\n                { disposeWhen: whenToDispose, disposeWhenNodeIsRemoved: activelyDisposeWhenNodeIsRemoved }\n            );\n        } else {\n            // We don't yet have a DOM node to evaluate, so use a memo and render the template later when there is a DOM node\n            return ko.memoization.memoize(function (domNode) {\n                ko.renderTemplate(template, dataOrBindingContext, options, domNode, \"replaceNode\");\n            });\n        }\n    };\n\n    ko.renderTemplateForEach = function (template, arrayOrObservableArray, options, targetNode, parentBindingContext) {\n        // Since setDomNodeChildrenFromArrayMapping always calls executeTemplateForArrayItem and then\n        // activateBindingsCallback for added items, we can store the binding context in the former to use in the latter.\n        var arrayItemContext;\n\n        // This will be called by setDomNodeChildrenFromArrayMapping to get the nodes to add to targetNode\n        var executeTemplateForArrayItem = function (arrayValue, index) {\n            // Support selecting template as a function of the data being rendered\n            arrayItemContext = parentBindingContext['createChildContext'](arrayValue, options['as'], function(context) {\n                context['$index'] = index;\n            });\n\n            var templateName = resolveTemplateName(template, arrayValue, arrayItemContext);\n            return executeTemplate(null, \"ignoreTargetNode\", templateName, arrayItemContext, options);\n        }\n\n        // This will be called whenever setDomNodeChildrenFromArrayMapping has added nodes to targetNode\n        var activateBindingsCallback = function(arrayValue, addedNodesArray, index) {\n            activateBindingsOnContinuousNodeArray(addedNodesArray, arrayItemContext);\n            if (options['afterRender'])\n                options['afterRender'](addedNodesArray, arrayValue);\n\n            // release the \"cache\" variable, so that it can be collected by\n            // the GC when its value isn't used from within the bindings anymore.\n            arrayItemContext = null;\n        };\n\n        return ko.dependentObservable(function () {\n            var unwrappedArray = ko.utils.unwrapObservable(arrayOrObservableArray) || [];\n            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                unwrappedArray = [unwrappedArray];\n\n            // Filter out any entries marked as destroyed\n            var filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                return options['includeDestroyed'] || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n            });\n\n            // Call setDomNodeChildrenFromArrayMapping, ignoring any observables unwrapped within (most likely from a callback function).\n            // If the array items are observables, though, they will be unwrapped in executeTemplateForArrayItem and managed within setDomNodeChildrenFromArrayMapping.\n            ko.dependencyDetection.ignore(ko.utils.setDomNodeChildrenFromArrayMapping, null, [targetNode, filteredArray, executeTemplateForArrayItem, options, activateBindingsCallback]);\n\n        }, null, { disposeWhenNodeIsRemoved: targetNode });\n    };\n\n    var templateComputedDomDataKey = ko.utils.domData.nextKey();\n    function disposeOldComputedAndStoreNewOne(element, newComputed) {\n        var oldComputed = ko.utils.domData.get(element, templateComputedDomDataKey);\n        if (oldComputed && (typeof(oldComputed.dispose) == 'function'))\n            oldComputed.dispose();\n        ko.utils.domData.set(element, templateComputedDomDataKey, (newComputed && newComputed.isActive()) ? newComputed : undefined);\n    }\n\n    ko.bindingHandlers['template'] = {\n        'init': function(element, valueAccessor) {\n            // Support anonymous templates\n            var bindingValue = ko.utils.unwrapObservable(valueAccessor());\n            if (typeof bindingValue == \"string\" || bindingValue['name']) {\n                // It's a named template - clear the element\n                ko.virtualElements.emptyNode(element);\n            } else if ('nodes' in bindingValue) {\n                // We've been given an array of DOM nodes. Save them as the template source.\n                // There is no known use case for the node array being an observable array (if the output\n                // varies, put that behavior *into* your template - that's what templates are for), and\n                // the implementation would be a mess, so assert that it's not observable.\n                var nodes = bindingValue['nodes'] || [];\n                if (ko.isObservable(nodes)) {\n                    throw new Error('The \"nodes\" option must be a plain, non-observable array.');\n                }\n                var container = ko.utils.moveCleanedNodesToContainerElement(nodes); // This also removes the nodes from their current parent\n                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n            } else {\n                // It's an anonymous template - store the element contents, then clear the element\n                var templateNodes = ko.virtualElements.childNodes(element),\n                    container = ko.utils.moveCleanedNodesToContainerElement(templateNodes); // This also removes the nodes from their current parent\n                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n            }\n            return { 'controlsDescendantBindings': true };\n        },\n        'update': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var value = valueAccessor(),\n                dataValue,\n                options = ko.utils.unwrapObservable(value),\n                shouldDisplay = true,\n                templateComputed = null,\n                templateName;\n\n            if (typeof options == \"string\") {\n                templateName = value;\n                options = {};\n            } else {\n                templateName = options['name'];\n\n                // Support \"if\"/\"ifnot\" conditions\n                if ('if' in options)\n                    shouldDisplay = ko.utils.unwrapObservable(options['if']);\n                if (shouldDisplay && 'ifnot' in options)\n                    shouldDisplay = !ko.utils.unwrapObservable(options['ifnot']);\n\n                dataValue = ko.utils.unwrapObservable(options['data']);\n            }\n\n            if ('foreach' in options) {\n                // Render once for each data point (treating data set as empty if shouldDisplay==false)\n                var dataArray = (shouldDisplay && options['foreach']) || [];\n                templateComputed = ko.renderTemplateForEach(templateName || element, dataArray, options, element, bindingContext);\n            } else if (!shouldDisplay) {\n                ko.virtualElements.emptyNode(element);\n            } else {\n                // Render once for this single data point (or use the viewModel if no data was provided)\n                var innerBindingContext = ('data' in options) ?\n                    bindingContext['createChildContext'](dataValue, options['as']) :  // Given an explitit 'data' value, we create a child binding context for it\n                    bindingContext;                                                        // Given no explicit 'data' value, we retain the same binding context\n                templateComputed = ko.renderTemplate(templateName || element, innerBindingContext, options, element);\n            }\n\n            // It only makes sense to have a single template computed per element (otherwise which one should have its output displayed?)\n            disposeOldComputedAndStoreNewOne(element, templateComputed);\n        }\n    };\n\n    // Anonymous templates can't be rewritten. Give a nice error message if you try to do it.\n    ko.expressionRewriting.bindingRewriteValidators['template'] = function(bindingValue) {\n        var parsedBindingValue = ko.expressionRewriting.parseObjectLiteral(bindingValue);\n\n        if ((parsedBindingValue.length == 1) && parsedBindingValue[0]['unknown'])\n            return null; // It looks like a string literal, not an object literal, so treat it as a named template (which is allowed for rewriting)\n\n        if (ko.expressionRewriting.keyValueArrayContainsKey(parsedBindingValue, \"name\"))\n            return null; // Named templates can be rewritten, so return \"no error\"\n        return \"This template engine does not support anonymous templates nested within its templates\";\n    };\n\n    ko.virtualElements.allowedBindings['template'] = true;\n})();\n\nko.exportSymbol('setTemplateEngine', ko.setTemplateEngine);\nko.exportSymbol('renderTemplate', ko.renderTemplate);\n// Go through the items that have been added and deleted and try to find matches between them.\nko.utils.findMovesInArrayComparison = function (left, right, limitFailedCompares) {\n    if (left.length && right.length) {\n        var failedCompares, l, r, leftItem, rightItem;\n        for (failedCompares = l = 0; (!limitFailedCompares || failedCompares < limitFailedCompares) && (leftItem = left[l]); ++l) {\n            for (r = 0; rightItem = right[r]; ++r) {\n                if (leftItem['value'] === rightItem['value']) {\n                    leftItem['moved'] = rightItem['index'];\n                    rightItem['moved'] = leftItem['index'];\n                    right.splice(r, 1);         // This item is marked as moved; so remove it from right list\n                    failedCompares = r = 0;     // Reset failed compares count because we're checking for consecutive failures\n                    break;\n                }\n            }\n            failedCompares += r;\n        }\n    }\n};\n\nko.utils.compareArrays = (function () {\n    var statusNotInOld = 'added', statusNotInNew = 'deleted';\n\n    // Simple calculation based on Levenshtein distance.\n    function compareArrays(oldArray, newArray, options) {\n        // For backward compatibility, if the third arg is actually a bool, interpret\n        // it as the old parameter 'dontLimitMoves'. Newer code should use { dontLimitMoves: true }.\n        options = (typeof options === 'boolean') ? { 'dontLimitMoves': options } : (options || {});\n        oldArray = oldArray || [];\n        newArray = newArray || [];\n\n        if (oldArray.length <= newArray.length)\n            return compareSmallArrayToBigArray(oldArray, newArray, statusNotInOld, statusNotInNew, options);\n        else\n            return compareSmallArrayToBigArray(newArray, oldArray, statusNotInNew, statusNotInOld, options);\n    }\n\n    function compareSmallArrayToBigArray(smlArray, bigArray, statusNotInSml, statusNotInBig, options) {\n        var myMin = Math.min,\n            myMax = Math.max,\n            editDistanceMatrix = [],\n            smlIndex, smlIndexMax = smlArray.length,\n            bigIndex, bigIndexMax = bigArray.length,\n            compareRange = (bigIndexMax - smlIndexMax) || 1,\n            maxDistance = smlIndexMax + bigIndexMax + 1,\n            thisRow, lastRow,\n            bigIndexMaxForRow, bigIndexMinForRow;\n\n        for (smlIndex = 0; smlIndex <= smlIndexMax; smlIndex++) {\n            lastRow = thisRow;\n            editDistanceMatrix.push(thisRow = []);\n            bigIndexMaxForRow = myMin(bigIndexMax, smlIndex + compareRange);\n            bigIndexMinForRow = myMax(0, smlIndex - 1);\n            for (bigIndex = bigIndexMinForRow; bigIndex <= bigIndexMaxForRow; bigIndex++) {\n                if (!bigIndex)\n                    thisRow[bigIndex] = smlIndex + 1;\n                else if (!smlIndex)  // Top row - transform empty array into new array via additions\n                    thisRow[bigIndex] = bigIndex + 1;\n                else if (smlArray[smlIndex - 1] === bigArray[bigIndex - 1])\n                    thisRow[bigIndex] = lastRow[bigIndex - 1];                  // copy value (no edit)\n                else {\n                    var northDistance = lastRow[bigIndex] || maxDistance;       // not in big (deletion)\n                    var westDistance = thisRow[bigIndex - 1] || maxDistance;    // not in small (addition)\n                    thisRow[bigIndex] = myMin(northDistance, westDistance) + 1;\n                }\n            }\n        }\n\n        var editScript = [], meMinusOne, notInSml = [], notInBig = [];\n        for (smlIndex = smlIndexMax, bigIndex = bigIndexMax; smlIndex || bigIndex;) {\n            meMinusOne = editDistanceMatrix[smlIndex][bigIndex] - 1;\n            if (bigIndex && meMinusOne === editDistanceMatrix[smlIndex][bigIndex-1]) {\n                notInSml.push(editScript[editScript.length] = {     // added\n                    'status': statusNotInSml,\n                    'value': bigArray[--bigIndex],\n                    'index': bigIndex });\n            } else if (smlIndex && meMinusOne === editDistanceMatrix[smlIndex - 1][bigIndex]) {\n                notInBig.push(editScript[editScript.length] = {     // deleted\n                    'status': statusNotInBig,\n                    'value': smlArray[--smlIndex],\n                    'index': smlIndex });\n            } else {\n                --bigIndex;\n                --smlIndex;\n                if (!options['sparse']) {\n                    editScript.push({\n                        'status': \"retained\",\n                        'value': bigArray[bigIndex] });\n                }\n            }\n        }\n\n        // Set a limit on the number of consecutive non-matching comparisons; having it a multiple of\n        // smlIndexMax keeps the time complexity of this algorithm linear.\n        ko.utils.findMovesInArrayComparison(notInSml, notInBig, smlIndexMax * 10);\n\n        return editScript.reverse();\n    }\n\n    return compareArrays;\n})();\n\nko.exportSymbol('utils.compareArrays', ko.utils.compareArrays);\n(function () {\n    // Objective:\n    // * Given an input array, a container DOM node, and a function from array elements to arrays of DOM nodes,\n    //   map the array elements to arrays of DOM nodes, concatenate together all these arrays, and use them to populate the container DOM node\n    // * Next time we're given the same combination of things (with the array possibly having mutated), update the container DOM node\n    //   so that its children is again the concatenation of the mappings of the array elements, but don't re-map any array elements that we\n    //   previously mapped - retain those nodes, and just insert/delete other ones\n\n    // \"callbackAfterAddingNodes\" will be invoked after any \"mapping\"-generated nodes are inserted into the container node\n    // You can use this, for example, to activate bindings on those nodes.\n\n    function mapNodeAndRefreshWhenChanged(containerNode, mapping, valueToMap, callbackAfterAddingNodes, index) {\n        // Map this array value inside a dependentObservable so we re-map when any dependency changes\n        var mappedNodes = [];\n        var dependentObservable = ko.dependentObservable(function() {\n            var newMappedNodes = mapping(valueToMap, index, ko.utils.fixUpContinuousNodeArray(mappedNodes, containerNode)) || [];\n\n            // On subsequent evaluations, just replace the previously-inserted DOM nodes\n            if (mappedNodes.length > 0) {\n                ko.utils.replaceDomNodes(mappedNodes, newMappedNodes);\n                if (callbackAfterAddingNodes)\n                    ko.dependencyDetection.ignore(callbackAfterAddingNodes, null, [valueToMap, newMappedNodes, index]);\n            }\n\n            // Replace the contents of the mappedNodes array, thereby updating the record\n            // of which nodes would be deleted if valueToMap was itself later removed\n            mappedNodes.length = 0;\n            ko.utils.arrayPushAll(mappedNodes, newMappedNodes);\n        }, null, { disposeWhenNodeIsRemoved: containerNode, disposeWhen: function() { return !ko.utils.anyDomNodeIsAttachedToDocument(mappedNodes); } });\n        return { mappedNodes : mappedNodes, dependentObservable : (dependentObservable.isActive() ? dependentObservable : undefined) };\n    }\n\n    var lastMappingResultDomDataKey = ko.utils.domData.nextKey();\n\n    ko.utils.setDomNodeChildrenFromArrayMapping = function (domNode, array, mapping, options, callbackAfterAddingNodes) {\n        // Compare the provided array against the previous one\n        array = array || [];\n        options = options || {};\n        var isFirstExecution = ko.utils.domData.get(domNode, lastMappingResultDomDataKey) === undefined;\n        var lastMappingResult = ko.utils.domData.get(domNode, lastMappingResultDomDataKey) || [];\n        var lastArray = ko.utils.arrayMap(lastMappingResult, function (x) { return x.arrayEntry; });\n        var editScript = ko.utils.compareArrays(lastArray, array, options['dontLimitMoves']);\n\n        // Build the new mapping result\n        var newMappingResult = [];\n        var lastMappingResultIndex = 0;\n        var newMappingResultIndex = 0;\n\n        var nodesToDelete = [];\n        var itemsToProcess = [];\n        var itemsForBeforeRemoveCallbacks = [];\n        var itemsForMoveCallbacks = [];\n        var itemsForAfterAddCallbacks = [];\n        var mapData;\n\n        function itemMovedOrRetained(editScriptIndex, oldPosition) {\n            mapData = lastMappingResult[oldPosition];\n            if (newMappingResultIndex !== oldPosition)\n                itemsForMoveCallbacks[editScriptIndex] = mapData;\n            // Since updating the index might change the nodes, do so before calling fixUpContinuousNodeArray\n            mapData.indexObservable(newMappingResultIndex++);\n            ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode);\n            newMappingResult.push(mapData);\n            itemsToProcess.push(mapData);\n        }\n\n        function callCallback(callback, items) {\n            if (callback) {\n                for (var i = 0, n = items.length; i < n; i++) {\n                    if (items[i]) {\n                        ko.utils.arrayForEach(items[i].mappedNodes, function(node) {\n                            callback(node, i, items[i].arrayEntry);\n                        });\n                    }\n                }\n            }\n        }\n\n        for (var i = 0, editScriptItem, movedIndex; editScriptItem = editScript[i]; i++) {\n            movedIndex = editScriptItem['moved'];\n            switch (editScriptItem['status']) {\n                case \"deleted\":\n                    if (movedIndex === undefined) {\n                        mapData = lastMappingResult[lastMappingResultIndex];\n\n                        // Stop tracking changes to the mapping for these nodes\n                        if (mapData.dependentObservable)\n                            mapData.dependentObservable.dispose();\n\n                        // Queue these nodes for later removal\n                        nodesToDelete.push.apply(nodesToDelete, ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode));\n                        if (options['beforeRemove']) {\n                            itemsForBeforeRemoveCallbacks[i] = mapData;\n                            itemsToProcess.push(mapData);\n                        }\n                    }\n                    lastMappingResultIndex++;\n                    break;\n\n                case \"retained\":\n                    itemMovedOrRetained(i, lastMappingResultIndex++);\n                    break;\n\n                case \"added\":\n                    if (movedIndex !== undefined) {\n                        itemMovedOrRetained(i, movedIndex);\n                    } else {\n                        mapData = { arrayEntry: editScriptItem['value'], indexObservable: ko.observable(newMappingResultIndex++) };\n                        newMappingResult.push(mapData);\n                        itemsToProcess.push(mapData);\n                        if (!isFirstExecution)\n                            itemsForAfterAddCallbacks[i] = mapData;\n                    }\n                    break;\n            }\n        }\n\n        // Call beforeMove first before any changes have been made to the DOM\n        callCallback(options['beforeMove'], itemsForMoveCallbacks);\n\n        // Next remove nodes for deleted items (or just clean if there's a beforeRemove callback)\n        ko.utils.arrayForEach(nodesToDelete, options['beforeRemove'] ? ko.cleanNode : ko.removeNode);\n\n        // Next add/reorder the remaining items (will include deleted items if there's a beforeRemove callback)\n        for (var i = 0, nextNode = ko.virtualElements.firstChild(domNode), lastNode, node; mapData = itemsToProcess[i]; i++) {\n            // Get nodes for newly added items\n            if (!mapData.mappedNodes)\n                ko.utils.extend(mapData, mapNodeAndRefreshWhenChanged(domNode, mapping, mapData.arrayEntry, callbackAfterAddingNodes, mapData.indexObservable));\n\n            // Put nodes in the right place if they aren't there already\n            for (var j = 0; node = mapData.mappedNodes[j]; nextNode = node.nextSibling, lastNode = node, j++) {\n                if (node !== nextNode)\n                    ko.virtualElements.insertAfter(domNode, node, lastNode);\n            }\n\n            // Run the callbacks for newly added nodes (for example, to apply bindings, etc.)\n            if (!mapData.initialized && callbackAfterAddingNodes) {\n                callbackAfterAddingNodes(mapData.arrayEntry, mapData.mappedNodes, mapData.indexObservable);\n                mapData.initialized = true;\n            }\n        }\n\n        // If there's a beforeRemove callback, call it after reordering.\n        // Note that we assume that the beforeRemove callback will usually be used to remove the nodes using\n        // some sort of animation, which is why we first reorder the nodes that will be removed. If the\n        // callback instead removes the nodes right away, it would be more efficient to skip reordering them.\n        // Perhaps we'll make that change in the future if this scenario becomes more common.\n        callCallback(options['beforeRemove'], itemsForBeforeRemoveCallbacks);\n\n        // Finally call afterMove and afterAdd callbacks\n        callCallback(options['afterMove'], itemsForMoveCallbacks);\n        callCallback(options['afterAdd'], itemsForAfterAddCallbacks);\n\n        // Store a copy of the array items we just considered so we can difference it next time\n        ko.utils.domData.set(domNode, lastMappingResultDomDataKey, newMappingResult);\n    }\n})();\n\nko.exportSymbol('utils.setDomNodeChildrenFromArrayMapping', ko.utils.setDomNodeChildrenFromArrayMapping);\nko.nativeTemplateEngine = function () {\n    this['allowTemplateRewriting'] = false;\n}\n\nko.nativeTemplateEngine.prototype = new ko.templateEngine();\nko.nativeTemplateEngine.prototype.constructor = ko.nativeTemplateEngine;\nko.nativeTemplateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n    var useNodesIfAvailable = !(ko.utils.ieVersion < 9), // IE<9 cloneNode doesn't work properly\n        templateNodesFunc = useNodesIfAvailable ? templateSource['nodes'] : null,\n        templateNodes = templateNodesFunc ? templateSource['nodes']() : null;\n\n    if (templateNodes) {\n        return ko.utils.makeArray(templateNodes.cloneNode(true).childNodes);\n    } else {\n        var templateText = templateSource['text']();\n        return ko.utils.parseHtmlFragment(templateText, templateDocument);\n    }\n};\n\nko.nativeTemplateEngine.instance = new ko.nativeTemplateEngine();\nko.setTemplateEngine(ko.nativeTemplateEngine.instance);\n\nko.exportSymbol('nativeTemplateEngine', ko.nativeTemplateEngine);\n(function() {\n    ko.jqueryTmplTemplateEngine = function () {\n        // Detect which version of jquery-tmpl you're using. Unfortunately jquery-tmpl\n        // doesn't expose a version number, so we have to infer it.\n        // Note that as of Knockout 1.3, we only support jQuery.tmpl 1.0.0pre and later,\n        // which KO internally refers to as version \"2\", so older versions are no longer detected.\n        var jQueryTmplVersion = this.jQueryTmplVersion = (function() {\n            if (!jQueryInstance || !(jQueryInstance['tmpl']))\n                return 0;\n            // Since it exposes no official version number, we use our own numbering system. To be updated as jquery-tmpl evolves.\n            try {\n                if (jQueryInstance['tmpl']['tag']['tmpl']['open'].toString().indexOf('__') >= 0) {\n                    // Since 1.0.0pre, custom tags should append markup to an array called \"__\"\n                    return 2; // Final version of jquery.tmpl\n                }\n            } catch(ex) { /* Apparently not the version we were looking for */ }\n\n            return 1; // Any older version that we don't support\n        })();\n\n        function ensureHasReferencedJQueryTemplates() {\n            if (jQueryTmplVersion < 2)\n                throw new Error(\"Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.\");\n        }\n\n        function executeTemplate(compiledTemplate, data, jQueryTemplateOptions) {\n            return jQueryInstance['tmpl'](compiledTemplate, data, jQueryTemplateOptions);\n        }\n\n        this['renderTemplateSource'] = function(templateSource, bindingContext, options, templateDocument) {\n            templateDocument = templateDocument || document;\n            options = options || {};\n            ensureHasReferencedJQueryTemplates();\n\n            // Ensure we have stored a precompiled version of this template (don't want to reparse on every render)\n            var precompiled = templateSource['data']('precompiled');\n            if (!precompiled) {\n                var templateText = templateSource['text']() || \"\";\n                // Wrap in \"with($whatever.koBindingContext) { ... }\"\n                templateText = \"{{ko_with $item.koBindingContext}}\" + templateText + \"{{/ko_with}}\";\n\n                precompiled = jQueryInstance['template'](null, templateText);\n                templateSource['data']('precompiled', precompiled);\n            }\n\n            var data = [bindingContext['$data']]; // Prewrap the data in an array to stop jquery.tmpl from trying to unwrap any arrays\n            var jQueryTemplateOptions = jQueryInstance['extend']({ 'koBindingContext': bindingContext }, options['templateOptions']);\n\n            var resultNodes = executeTemplate(precompiled, data, jQueryTemplateOptions);\n            resultNodes['appendTo'](templateDocument.createElement(\"div\")); // Using \"appendTo\" forces jQuery/jQuery.tmpl to perform necessary cleanup work\n\n            jQueryInstance['fragments'] = {}; // Clear jQuery's fragment cache to avoid a memory leak after a large number of template renders\n            return resultNodes;\n        };\n\n        this['createJavaScriptEvaluatorBlock'] = function(script) {\n            return \"{{ko_code ((function() { return \" + script + \" })()) }}\";\n        };\n\n        this['addTemplate'] = function(templateName, templateMarkup) {\n            document.write(\"<script type='text/html' id='\" + templateName + \"'>\" + templateMarkup + \"<\" + \"/script>\");\n        };\n\n        if (jQueryTmplVersion > 0) {\n            jQueryInstance['tmpl']['tag']['ko_code'] = {\n                open: \"__.push($1 || '');\"\n            };\n            jQueryInstance['tmpl']['tag']['ko_with'] = {\n                open: \"with($1) {\",\n                close: \"} \"\n            };\n        }\n    };\n\n    ko.jqueryTmplTemplateEngine.prototype = new ko.templateEngine();\n    ko.jqueryTmplTemplateEngine.prototype.constructor = ko.jqueryTmplTemplateEngine;\n\n    // Use this one by default *only if jquery.tmpl is referenced*\n    var jqueryTmplTemplateEngineInstance = new ko.jqueryTmplTemplateEngine();\n    if (jqueryTmplTemplateEngineInstance.jQueryTmplVersion > 0)\n        ko.setTemplateEngine(jqueryTmplTemplateEngineInstance);\n\n    ko.exportSymbol('jqueryTmplTemplateEngine', ko.jqueryTmplTemplateEngine);\n})();\n}));\n}());\n})();\n","knockoutjs/knockout-fast-foreach.js":"/*!\n  Knockout Fast Foreach v0.4.1 (2015-07-17T14:06:15.974Z)\n  By: Brian M Hunt (C) 2015\n  License: MIT\n\n  Adds `fastForEach` to `ko.bindingHandlers`.\n*/\n(function (root, factory) {\n  if (typeof define === 'function' && define.amd) {\n    define(['knockout'], factory);\n  } else if (typeof exports === 'object') {\n    module.exports = factory(require('knockout'));\n  } else {\n    root.KnockoutFastForeach = factory(root.ko);\n  }\n}(this, function (ko) {\n  \"use strict\";\n// index.js\n// --------\n// Fast For Each\n//\n// Employing sound techniques to make a faster Knockout foreach binding.\n// --------\n\n//      Utilities\n\n// from https://github.com/jonschlinkert/is-plain-object\nfunction isPlainObject(o) {\n  return !!o && typeof o === 'object' && o.constructor === Object;\n}\n\n// From knockout/src/virtualElements.js\nvar commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\nvar startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\nvar supportsDocumentFragment = document && typeof document.createDocumentFragment === \"function\";\nfunction isVirtualNode(node) {\n  return (node.nodeType === 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n}\n\n\n// Get a copy of the (possibly virtual) child nodes of the given element,\n// put them into a container, then empty the given node.\nfunction makeTemplateNode(sourceNode) {\n  var container = document.createElement(\"div\");\n  var parentNode;\n  if (sourceNode.content) {\n    // For e.g. <template> tags\n    parentNode = sourceNode.content;\n  } else if (sourceNode.tagName === 'SCRIPT') {\n    parentNode = document.createElement(\"div\");\n    parentNode.innerHTML = sourceNode.text;\n  } else {\n    // Anything else e.g. <div>\n    parentNode = sourceNode;\n  }\n  ko.utils.arrayForEach(ko.virtualElements.childNodes(parentNode), function (child) {\n    // FIXME - This cloneNode could be expensive; we may prefer to iterate over the\n    // parentNode children in reverse (so as not to foul the indexes as childNodes are\n    // removed from parentNode when inserted into the container)\n    if (child) {\n      container.insertBefore(child.cloneNode(true), null);\n    }\n  });\n  return container;\n}\n\nfunction insertAllAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode) {\n  var frag, len, i;\n  // poor man's node and array check, should be enough for this\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\" && typeof nodeOrNodeArrayToInsert.length === \"undefined\") {\n    throw new Error(\"Expected a single node or a node array\");\n  }\n\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\") {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode);\n    return;\n  }\n\n  if (nodeOrNodeArrayToInsert.length === 1) {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert[0], insertAfterNode);\n    return;\n  }\n\n  if (supportsDocumentFragment) {\n    frag = document.createDocumentFragment();\n\n    for (i = 0, len = nodeOrNodeArrayToInsert.length; i !== len; ++i) {\n      frag.appendChild(nodeOrNodeArrayToInsert[i]);\n    }\n    ko.virtualElements.insertAfter(containerNode, frag, insertAfterNode);\n  } else {\n    // Nodes are inserted in reverse order - pushed down immediately after\n    // the last node for the previous item or as the first node of element.\n    for (i = nodeOrNodeArrayToInsert.length - 1; i >= 0; --i) {\n      var child = nodeOrNodeArrayToInsert[i];\n      if (!child) {\n        return;\n      }\n      ko.virtualElements.insertAfter(containerNode, child, insertAfterNode);\n    }\n  }\n}\n\n// Mimic a KO change item 'add'\nfunction valueToChangeAddItem(value, index) {\n  return {\n    status: 'added',\n    value: value,\n    index: index\n  };\n}\n\nfunction isAdditionAdjacentToLast(changeIndex, arrayChanges) {\n  return changeIndex > 0 &&\n    changeIndex < arrayChanges.length &&\n    arrayChanges[changeIndex].status === \"added\" &&\n    arrayChanges[changeIndex - 1].status === \"added\" &&\n    arrayChanges[changeIndex - 1].index === arrayChanges[changeIndex].index - 1;\n}\n\nfunction FastForEach(spec) {\n  this.element = spec.element;\n  this.container = isVirtualNode(this.element) ?\n                   this.element.parentNode : this.element;\n  this.$context = spec.$context;\n  this.data = spec.data;\n  this.as = spec.as;\n  this.noContext = spec.noContext;\n  this.templateNode = makeTemplateNode(\n    spec.name ? document.getElementById(spec.name).cloneNode(true) : spec.element\n  );\n  this.afterQueueFlush = spec.afterQueueFlush;\n  this.beforeQueueFlush = spec.beforeQueueFlush;\n  this.changeQueue = [];\n  this.lastNodesList = [];\n  this.indexesToDelete = [];\n  this.rendering_queued = false;\n\n  // Remove existing content.\n  ko.virtualElements.emptyNode(this.element);\n\n  // Prime content\n  var primeData = ko.unwrap(this.data);\n  if (primeData.map) {\n    this.onArrayChange(primeData.map(valueToChangeAddItem));\n  }\n\n  // Watch for changes\n  if (ko.isObservable(this.data)) {\n    if (!this.data.indexOf) {\n      // Make sure the observable is trackable.\n      this.data = this.data.extend({trackArrayChanges: true});\n    }\n    this.changeSubs = this.data.subscribe(this.onArrayChange, this, 'arrayChange');\n  }\n}\n\n\nFastForEach.animateFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame ||\n  window.mozRequestAnimationFrame || window.msRequestAnimationFrame ||\n  function(cb) { return window.setTimeout(cb, 1000 / 60); };\n\n\nFastForEach.prototype.dispose = function () {\n  if (this.changeSubs) {\n    this.changeSubs.dispose();\n  }\n};\n\n\n// If the array changes we register the change.\nFastForEach.prototype.onArrayChange = function (changeSet) {\n  var self = this;\n  var changeMap = {\n    added: [],\n    deleted: []\n  };\n  for (var i = 0, len = changeSet.length; i < len; i++) {\n    // the change is appended to a last change info object when both are 'added' and have indexes next to each other\n    // here I presume that ko is sending changes in monotonic order (in index variable) which happens to be true, tested with push and splice with multiple pushed values\n    if (isAdditionAdjacentToLast(i, changeSet)) {\n      var batchValues = changeMap.added[changeMap.added.length - 1].values;\n      if (!batchValues) {\n        // transform the last addition into a batch addition object\n        var lastAddition = changeMap.added.pop();\n        var batchAddition = {\n          isBatch: true,\n          status: 'added',\n          index: lastAddition.index,\n          values: [lastAddition.value]\n        };\n        batchValues = batchAddition.values;\n        changeMap.added.push(batchAddition);\n      }\n      batchValues.push(changeSet[i].value);\n    } else {\n      changeMap[changeSet[i].status].push(changeSet[i]);\n    }\n  }\n  if (changeMap.deleted.length > 0) {\n    this.changeQueue.push.apply(this.changeQueue, changeMap.deleted);\n    this.changeQueue.push({status: 'clearDeletedIndexes'});\n  }\n  this.changeQueue.push.apply(this.changeQueue, changeMap.added);\n  // Once a change is registered, the ticking count-down starts for the processQueue.\n  if (this.changeQueue.length > 0 && !this.rendering_queued) {\n    this.rendering_queued = true;\n    FastForEach.animateFrame.call(window, function () { self.processQueue(); });\n  }\n};\n\n\n// Reflect all the changes in the queue in the DOM, then wipe the queue.\nFastForEach.prototype.processQueue = function () {\n  var self = this;\n\n  // Callback so folks can do things before the queue flush.\n  if (typeof this.beforeQueueFlush === 'function') {\n    this.beforeQueueFlush(this.changeQueue);\n  }\n\n  ko.utils.arrayForEach(this.changeQueue, function (changeItem) {\n    // console.log(self.data(), \"CI\", JSON.stringify(changeItem, null, 2), JSON.stringify($(self.element).text()))\n    self[changeItem.status](changeItem);\n    // console.log(\"  ==> \", JSON.stringify($(self.element).text()))\n  });\n  this.rendering_queued = false;\n  // Callback so folks can do things.\n  if (typeof this.afterQueueFlush === 'function') {\n    this.afterQueueFlush(this.changeQueue);\n  }\n  this.changeQueue = [];\n};\n\n\n// Process a changeItem with {status: 'added', ...}\nFastForEach.prototype.added = function (changeItem) {\n  var index = changeItem.index;\n  var valuesToAdd = changeItem.isBatch ? changeItem.values : [changeItem.value];\n  var referenceElement = this.lastNodesList[index - 1] || null;\n  // gather all childnodes for a possible batch insertion\n  var allChildNodes = [];\n\n  for (var i = 0, len = valuesToAdd.length; i < len; ++i) {\n    var templateClone = this.templateNode.cloneNode(true);\n    var childContext;\n\n    if (this.noContext) {\n      childContext = this.$context.extend({\n        '$item': valuesToAdd[i]\n      });\n    } else {\n      childContext = this.$context.createChildContext(valuesToAdd[i], this.as || null);\n    }\n\n    // apply bindings first, and then process child nodes, because bindings can add childnodes\n    ko.applyBindingsToDescendants(childContext, templateClone);\n\n    var childNodes = ko.virtualElements.childNodes(templateClone);\n    // Note discussion at https://github.com/angular/angular.js/issues/7851\n    allChildNodes.push.apply(allChildNodes, Array.prototype.slice.call(childNodes));\n    this.lastNodesList.splice(index + i, 0, childNodes[childNodes.length - 1]);\n  }\n\n  insertAllAfter(this.element, allChildNodes, referenceElement);\n};\n\n\n// Process a changeItem with {status: 'deleted', ...}\nFastForEach.prototype.deleted = function (changeItem) {\n  var index = changeItem.index;\n  var ptr = this.lastNodesList[index],\n      // We use this.element because that will be the last previous node\n      // for virtual element lists.\n      lastNode = this.lastNodesList[index - 1] || this.element;\n  do {\n    ptr = ptr.previousSibling;\n    ko.removeNode((ptr && ptr.nextSibling) || ko.virtualElements.firstChild(this.element));\n  } while (ptr && ptr !== lastNode);\n  // The \"last node\" in the DOM from which we begin our delets of the next adjacent node is\n  // now the sibling that preceded the first node of this item.\n  this.lastNodesList[index] = this.lastNodesList[index - 1];\n  this.indexesToDelete.push(index);\n};\n\n\n// We batch our deletion of item indexes in our parallel array.\n// See brianmhunt/knockout-fast-foreach#6/#8\nFastForEach.prototype.clearDeletedIndexes = function () {\n  // We iterate in reverse on the presumption (following the unit tests) that KO's diff engine\n  // processes diffs (esp. deletes) monotonically ascending i.e. from index 0 -> N.\n  for (var i = this.indexesToDelete.length - 1; i >= 0; --i) {\n    this.lastNodesList.splice(this.indexesToDelete[i], 1);\n  }\n  this.indexesToDelete = [];\n};\n\n\nko.bindingHandlers.fastForEach = {\n  // Valid valueAccessors:\n  //    []\n  //    ko.observable([])\n  //    ko.observableArray([])\n  //    ko.computed\n  //    {data: array, name: string, as: string}\n  init: function init(element, valueAccessor, bindings, vm, context) {\n    var value = valueAccessor(),\n        ffe;\n    if (isPlainObject(value)) {\n      value.element = value.element || element;\n      value.$context = context;\n      ffe = new FastForEach(value);\n    } else {\n      ffe = new FastForEach({\n        element: element,\n        data: ko.unwrap(context.$rawData) === value ? context.$rawData : value,\n        $context: context\n      });\n    }\n    ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n      ffe.dispose();\n    });\n    return {controlsDescendantBindings: true};\n  },\n\n  // Export for testing, debugging, and overloading.\n  FastForEach: FastForEach\n};\n\nko.virtualElements.allowedBindings.fastForEach = true;\n}));","knockoutjs/knockout-es5.js":"/*!\n * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5\n * Copyright (c) Steve Sanderson\n * MIT license\n */\n\n(function(global, undefined) {\n  'use strict';\n\n  var ko;\n\n  // Model tracking\n  // --------------\n  //\n  // This is the central feature of Knockout-ES5. We augment model objects by converting properties\n  // into ES5 getter/setter pairs that read/write an underlying Knockout observable. This means you can\n  // use plain JavaScript syntax to read/write the property while still getting the full benefits of\n  // Knockout's automatic dependency detection and notification triggering.\n  //\n  // For comparison, here's Knockout ES3-compatible syntax:\n  //\n  //     var firstNameLength = myModel.user().firstName().length; // Read\n  //     myModel.user().firstName('Bert'); // Write\n  //\n  // ... versus Knockout-ES5 syntax:\n  //\n  //     var firstNameLength = myModel.user.firstName.length; // Read\n  //     myModel.user.firstName = 'Bert'; // Write\n\n  // `ko.track(model)` converts each property on the given model object into a getter/setter pair that\n  // wraps a Knockout observable. Optionally specify an array of property names to wrap; otherwise we\n  // wrap all properties. If any of the properties are already observables, we replace them with\n  // ES5 getter/setter pairs that wrap your original observable instances. In the case of readonly\n  // ko.computed properties, we simply do not define a setter (so attempted writes will be ignored,\n  // which is how ES5 readonly properties normally behave).\n  //\n  // By design, this does *not* recursively walk child object properties, because making literally\n  // everything everywhere independently observable is usually unhelpful. When you do want to track\n  // child object properties independently, define your own class for those child objects and put\n  // a separate ko.track call into its constructor --- this gives you far more control.\n  /**\n   * @param {object} obj\n   * @param {object|array.<string>} propertyNamesOrSettings\n   * @param {boolean} propertyNamesOrSettings.deep Use deep track.\n   * @param {array.<string>} propertyNamesOrSettings.fields Array of property names to wrap.\n   * todo: @param {array.<string>} propertyNamesOrSettings.exclude Array of exclude property names to wrap.\n   * todo: @param {function(string, *):boolean} propertyNamesOrSettings.filter Function to filter property \n   *   names to wrap. A function that takes ... params\n   * @return {object}\n   */\n  function track(obj, propertyNamesOrSettings) {\n    if (!obj || typeof obj !== 'object') {\n      throw new Error('When calling ko.track, you must pass an object as the first parameter.');\n    }\n\n    var propertyNames;\n\n    if ( isPlainObject(propertyNamesOrSettings) ) {\n      // defaults\n      propertyNamesOrSettings.deep = propertyNamesOrSettings.deep || false;\n      propertyNamesOrSettings.fields = propertyNamesOrSettings.fields || Object.getOwnPropertyNames(obj);\n      propertyNamesOrSettings.lazy = propertyNamesOrSettings.lazy || false;\n\n      wrap(obj, propertyNamesOrSettings.fields, propertyNamesOrSettings);\n    } else {\n      propertyNames = propertyNamesOrSettings || Object.getOwnPropertyNames(obj);\n      wrap(obj, propertyNames, {});\n    }\n\n    return obj;\n  }\n\n  // fix for ie\n  var rFunctionName = /^function\\s*([^\\s(]+)/;\n  function getFunctionName( ctor ){\n    if (ctor.name) {\n      return ctor.name;\n    }\n    return (ctor.toString().trim().match( rFunctionName ) || [])[1];\n  }\n\n  function canTrack(obj) {\n    return obj && typeof obj === 'object' && getFunctionName(obj.constructor) === 'Object';\n  }\n\n  function createPropertyDescriptor(originalValue, prop, map) {\n    var isObservable = ko.isObservable(originalValue);\n    var isArray = !isObservable && Array.isArray(originalValue);\n    var observable = isObservable ? originalValue\n        : isArray ? ko.observableArray(originalValue)\n        : ko.observable(originalValue);\n\n    map[prop] = function () { return observable; };\n\n    // add check in case the object is already an observable array\n    if (isArray || (isObservable && 'push' in observable)) {\n      notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n    }\n\n    return {\n      configurable: true,\n      enumerable: true,\n      get: observable,\n      set: ko.isWriteableObservable(observable) ? observable : undefined\n    };\n  }\n\n  function createLazyPropertyDescriptor(originalValue, prop, map) {\n    if (ko.isObservable(originalValue)) {\n      // no need to be lazy if we already have an observable\n      return createPropertyDescriptor(originalValue, prop, map);\n    }\n\n    var observable;\n\n    function getOrCreateObservable(value, writing) {\n      if (observable) {\n        return writing ? observable(value) : observable;\n      }\n\n      if (Array.isArray(value)) {\n        observable = ko.observableArray(value);\n        notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n        return observable;\n      }\n\n      return (observable = ko.observable(value));\n    }\n\n    map[prop] = function () { return getOrCreateObservable(originalValue); };\n    return {\n      configurable: true,\n      enumerable: true,\n      get: function () { return getOrCreateObservable(originalValue)(); },\n      set: function (value) { getOrCreateObservable(value, true); }\n    };\n  }\n\n  function wrap(obj, props, options) {\n    if (!props.length) {\n      return;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, true);\n    var descriptors = {};\n\n    props.forEach(function (prop) {\n      // Skip properties that are already tracked\n      if (prop in allObservablesForObject) {\n        return;\n      }\n\n      // Skip properties where descriptor can't be redefined\n      if (Object.getOwnPropertyDescriptor(obj, prop).configurable === false){\n        return;\n      }\n\n      var originalValue = obj[prop];\n      descriptors[prop] = (options.lazy ? createLazyPropertyDescriptor : createPropertyDescriptor)\n        (originalValue, prop, allObservablesForObject);\n\n      if (options.deep && canTrack(originalValue)) {\n        wrap(originalValue, Object.keys(originalValue), options);\n      }\n    });\n\n    Object.defineProperties(obj, descriptors);\n  }\n\n  function isPlainObject( obj ){\n    return !!obj && typeof obj === 'object' && obj.constructor === Object;\n  }\n\n  // Lazily created by `getAllObservablesForObject` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var objectToObservableMap;\n\n  // Gets or creates the hidden internal key-value collection of observables corresponding to\n  // properties on the model object.\n  function getAllObservablesForObject(obj, createIfNotDefined) {\n    if (!objectToObservableMap) {\n      objectToObservableMap = weakMapFactory();\n    }\n\n    var result = objectToObservableMap.get(obj);\n    if (!result && createIfNotDefined) {\n      result = {};\n      objectToObservableMap.set(obj, result);\n    }\n    return result;\n  }\n\n  // Removes the internal references to observables mapped to the specified properties\n  // or the entire object reference if no properties are passed in. This allows the\n  // observables to be replaced and tracked again.\n  function untrack(obj, propertyNames) {\n    if (!objectToObservableMap) {\n      return;\n    }\n\n    if (arguments.length === 1) {\n      objectToObservableMap['delete'](obj);\n    } else {\n      var allObservablesForObject = getAllObservablesForObject(obj, false);\n      if (allObservablesForObject) {\n        propertyNames.forEach(function(propertyName) {\n          delete allObservablesForObject[propertyName];\n        });\n      }\n    }\n  }\n\n  // Computed properties\n  // -------------------\n  //\n  // The preceding code is already sufficient to upgrade ko.computed model properties to ES5\n  // getter/setter pairs (or in the case of readonly ko.computed properties, just a getter).\n  // These then behave like a regular property with a getter function, except they are smarter:\n  // your evaluator is only invoked when one of its dependencies changes. The result is cached\n  // and used for all evaluations until the next time a dependency changes).\n  //\n  // However, instead of forcing developers to declare a ko.computed property explicitly, it's\n  // nice to offer a utility function that declares a computed getter directly.\n\n  // Implements `ko.defineProperty`\n  function defineComputedProperty(obj, propertyName, evaluatorOrOptions) {\n    var ko = this,\n      computedOptions = { owner: obj, deferEvaluation: true };\n\n    if (typeof evaluatorOrOptions === 'function') {\n      computedOptions.read = evaluatorOrOptions;\n    } else {\n      if ('value' in evaluatorOrOptions) {\n        throw new Error('For ko.defineProperty, you must not specify a \"value\" for the property. ' +\n                        'You must provide a \"get\" function.');\n      }\n\n      if (typeof evaluatorOrOptions.get !== 'function') {\n        throw new Error('For ko.defineProperty, the third parameter must be either an evaluator function, ' +\n                        'or an options object containing a function called \"get\".');\n      }\n\n      computedOptions.read = evaluatorOrOptions.get;\n      computedOptions.write = evaluatorOrOptions.set;\n    }\n\n    obj[propertyName] = ko.computed(computedOptions);\n    track.call(ko, obj, [propertyName]);\n    return obj;\n  }\n\n  // Array handling\n  // --------------\n  //\n  // Arrays are special, because unlike other property types, they have standard mutator functions\n  // (`push`/`pop`/`splice`/etc.) and it's desirable to trigger a change notification whenever one of\n  // those mutator functions is invoked.\n  //\n  // Traditionally, Knockout handles this by putting special versions of `push`/`pop`/etc. on observable\n  // arrays that mutate the underlying array and then trigger a notification. That approach doesn't\n  // work for Knockout-ES5 because properties now return the underlying arrays, so the mutator runs\n  // in the context of the underlying array, not any particular observable:\n  //\n  //     // Operates on the underlying array value\n  //     myModel.someCollection.push('New value');\n  //\n  // To solve this, Knockout-ES5 detects array values, and modifies them as follows:\n  //  1. Associates a hidden subscribable with each array instance that it encounters\n  //  2. Intercepts standard mutators (`push`/`pop`/etc.) and makes them trigger the subscribable\n  // Then, for model properties whose values are arrays, the property's underlying observable\n  // subscribes to the array subscribable, so it can trigger a change notification after mutation.\n\n  // Given an observable that underlies a model property, watch for any array value that might\n  // be assigned as the property value, and hook into its change events\n  function notifyWhenPresentOrFutureArrayValuesMutate(ko, observable) {\n    var watchingArraySubscription = null;\n    ko.computed(function () {\n      // Unsubscribe to any earlier array instance\n      if (watchingArraySubscription) {\n        watchingArraySubscription.dispose();\n        watchingArraySubscription = null;\n      }\n\n      // Subscribe to the new array instance\n      var newArrayInstance = observable();\n      if (newArrayInstance instanceof Array) {\n        watchingArraySubscription = startWatchingArrayInstance(ko, observable, newArrayInstance);\n      }\n    });\n  }\n\n  // Listens for array mutations, and when they happen, cause the observable to fire notifications.\n  // This is used to make model properties of type array fire notifications when the array changes.\n  // Returns a subscribable that can later be disposed.\n  function startWatchingArrayInstance(ko, observable, arrayInstance) {\n    var subscribable = getSubscribableForArray(ko, arrayInstance);\n    return subscribable.subscribe(observable);\n  }\n\n  // Lazily created by `getSubscribableForArray` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var arraySubscribablesMap;\n\n  // Gets or creates a subscribable that fires after each array mutation\n  function getSubscribableForArray(ko, arrayInstance) {\n    if (!arraySubscribablesMap) {\n      arraySubscribablesMap = weakMapFactory();\n    }\n\n    var subscribable = arraySubscribablesMap.get(arrayInstance);\n    if (!subscribable) {\n      subscribable = new ko.subscribable();\n      arraySubscribablesMap.set(arrayInstance, subscribable);\n\n      var notificationPauseSignal = {};\n      wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal);\n      addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal);\n    }\n\n    return subscribable;\n  }\n\n  // After each array mutation, fires a notification on the given subscribable\n  function wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal) {\n    ['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'].forEach(function(fnName) {\n      var origMutator = arrayInstance[fnName];\n      arrayInstance[fnName] = function() {\n        var result = origMutator.apply(this, arguments);\n        if (notificationPauseSignal.pause !== true) {\n          subscribable.notifySubscribers(this);\n        }\n        return result;\n      };\n    });\n  }\n\n  // Adds Knockout's additional array mutation functions to the array\n  function addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal) {\n    ['remove', 'removeAll', 'destroy', 'destroyAll', 'replace'].forEach(function(fnName) {\n      // Make it a non-enumerable property for consistency with standard Array functions\n      Object.defineProperty(arrayInstance, fnName, {\n        enumerable: false,\n        value: function() {\n          var result;\n\n          // These additional array mutators are built using the underlying push/pop/etc.\n          // mutators, which are wrapped to trigger notifications. But we don't want to\n          // trigger multiple notifications, so pause the push/pop/etc. wrappers and\n          // delivery only one notification at the end of the process.\n          notificationPauseSignal.pause = true;\n          try {\n            // Creates a temporary observableArray that can perform the operation.\n            result = ko.observableArray.fn[fnName].apply(ko.observableArray(arrayInstance), arguments);\n          }\n          finally {\n            notificationPauseSignal.pause = false;\n          }\n          subscribable.notifySubscribers(arrayInstance);\n          return result;\n        }\n      });\n    });\n  }\n\n  // Static utility functions\n  // ------------------------\n  //\n  // Since Knockout-ES5 sets up properties that return values, not observables, you can't\n  // trivially subscribe to the underlying observables (e.g., `someProperty.subscribe(...)`),\n  // or tell them that object values have mutated, etc. To handle this, we set up some\n  // extra utility functions that can return or work with the underlying observables.\n\n  // Returns the underlying observable associated with a model property (or `null` if the\n  // model or property doesn't exist, or isn't associated with an observable). This means\n  // you can subscribe to the property, e.g.:\n  //\n  //     ko.getObservable(model, 'propertyName')\n  //       .subscribe(function(newValue) { ... });\n  function getObservable(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return null;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    if (allObservablesForObject && propertyName in allObservablesForObject) {\n      return allObservablesForObject[propertyName]();\n    }\n\n    return null;\n  }\n  \n  // Returns a boolean indicating whether the property on the object has an underlying\n  // observables. This does the check in a way not to create an observable if the\n  // object was created with lazily created observables\n  function isTracked(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return false;\n    }\n    \n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    return !!allObservablesForObject && propertyName in allObservablesForObject;\n  }\n\n  // Causes a property's associated observable to fire a change notification. Useful when\n  // the property value is a complex object and you've modified a child property.\n  function valueHasMutated(obj, propertyName) {\n    var observable = getObservable(obj, propertyName);\n\n    if (observable) {\n      observable.valueHasMutated();\n    }\n  }\n\n  // Module initialisation\n  // ---------------------\n  //\n  // When this script is first evaluated, it works out what kind of module loading scenario\n  // it is in (Node.js or a browser `<script>` tag), stashes a reference to its dependencies\n  // (currently that's just the WeakMap shim), and then finally attaches itself to whichever\n  // instance of Knockout.js it can find.\n\n  // A function that returns a new ES6-compatible WeakMap instance (using ES5 shim if needed).\n  // Instantiated by prepareExports, accounting for which module loader is being used.\n  var weakMapFactory;\n\n  // Extends a Knockout instance with Knockout-ES5 functionality\n  function attachToKo(ko) {\n    ko.track = track;\n    ko.untrack = untrack;\n    ko.getObservable = getObservable;\n    ko.valueHasMutated = valueHasMutated;\n    ko.defineProperty = defineComputedProperty;\n\n    // todo: test it, maybe added it to ko. directly\n    ko.es5 = {\n      getAllObservablesForObject: getAllObservablesForObject,\n      notifyWhenPresentOrFutureArrayValuesMutate: notifyWhenPresentOrFutureArrayValuesMutate,\n      isTracked: isTracked\n    };\n  }\n\n  // Determines which module loading scenario we're in, grabs dependencies, and attaches to KO\n  function prepareExports() {\n    if (typeof exports === 'object' && typeof module === 'object') {\n      // Node.js case - load KO and WeakMap modules synchronously\n      ko = require('knockout');\n      var WM = require('../lib/weakmap');\n      attachToKo(ko);\n      weakMapFactory = function() { return new WM(); };\n      module.exports = ko;\n    } else if (typeof define === 'function' && define.amd) {\n      define(['knockout'], function(koModule) {\n        ko = koModule;\n        attachToKo(koModule);\n        weakMapFactory = function() { return new global.WeakMap(); };\n        return koModule;\n      });\n    } else if ('ko' in global) {\n      // Non-module case - attach to the global instance, and assume a global WeakMap constructor\n      ko = global.ko;\n      attachToKo(global.ko);\n      weakMapFactory = function() { return new global.WeakMap(); };\n    }\n  }\n\n  prepareExports();\n\n})(this);","knockoutjs/knockout-repeat.js":"// REPEAT binding for Knockout http://knockoutjs.com/\n// (c) Michael Best\n// License: MIT (http://www.opensource.org/licenses/mit-license.php)\n// Version 2.1.0\n\n(function(factory) {\n    if (typeof define === 'function' && define.amd) {\n        // [1] AMD anonymous module\n        define(['knockout'], factory);\n    } else if (typeof exports === 'object') {\n        // [2] commonJS\n        factory(require('knockout'));\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window.ko);\n    }\n})(function(ko) {\n\nif (!ko.virtualElements)\n    throw Error('Repeat requires at least Knockout 2.1');\n\nvar ko_bindingFlags = ko.bindingFlags || {};\nvar ko_unwrap = ko.utils.unwrapObservable;\n\nvar koProtoName = '__ko_proto__';\n\nif (ko.version >= \"3.0.0\") {\n    // In Knockout 3.0.0, use the node preprocessor to replace a node with a repeat binding with a virtual element\n    var provider = ko.bindingProvider.instance, previousPreprocessFn = provider.preprocessNode;\n    provider.preprocessNode = function(node) {\n        var newNodes, nodeBinding;\n        if (!previousPreprocessFn || !(newNodes = previousPreprocessFn.call(this, node))) {\n            if (node.nodeType === 1 && (nodeBinding = node.getAttribute('data-bind'))) {\n                if (/^\\s*repeat\\s*:/.test(nodeBinding)) {\n                    var leadingComment = node.ownerDocument.createComment('ko ' + nodeBinding),\n                        trailingComment = node.ownerDocument.createComment('/ko');\n                    node.parentNode.insertBefore(leadingComment, node);\n                    node.parentNode.insertBefore(trailingComment, node.nextSibling);\n                    node.removeAttribute('data-bind');\n                    newNodes = [leadingComment, node, trailingComment];\n                }\n            }\n        }\n        return newNodes;\n    };\n}\n\nko.virtualElements.allowedBindings.repeat = true;\nko.bindingHandlers.repeat = {\n    flags: ko_bindingFlags.contentBind | ko_bindingFlags.canUseVirtual,\n    init: function(element, valueAccessor, allBindingsAccessor, xxx, bindingContext) {\n\n        // Read and set fixed options--these options cannot be changed\n        var repeatParam = ko_unwrap(valueAccessor());\n        if (repeatParam && typeof repeatParam == 'object' && !('length' in repeatParam)) {\n            var repeatIndex = repeatParam.index,\n                repeatData = repeatParam.item,\n                repeatStep = repeatParam.step,\n                repeatReversed = repeatParam.reverse,\n                repeatBind = repeatParam.bind,\n                repeatInit = repeatParam.init,\n                repeatUpdate = repeatParam.update;\n        }\n        // Set default values for options that need it\n        repeatIndex = repeatIndex || '$index';\n        repeatData = repeatData || ko.bindingHandlers.repeat.itemName || '$item';\n        repeatStep = repeatStep || 1;\n        repeatReversed = repeatReversed || false;\n\n        var parent = element.parentNode, placeholder;\n        if (element.nodeType == 8) {    // virtual element\n            // Extract the \"children\" and find the single element node\n            var childNodes = ko.utils.arrayFilter(ko.virtualElements.childNodes(element), function(node) { return node.nodeType == 1;});\n            if (childNodes.length !== 1) {\n                throw Error(\"Repeat binding requires a single element to repeat\");\n            }\n            ko.virtualElements.emptyNode(element);\n\n            // The placeholder is the closing comment normally, or the opening comment if reversed\n            placeholder = repeatReversed ? element : element.nextSibling;\n            // The element to repeat is the contained element\n            element = childNodes[0];\n        } else {    // regular element\n            // First clean the element node and remove node's binding\n            var origBindString = element.getAttribute('data-bind');\n            ko.cleanNode(element);\n            element.removeAttribute('data-bind');\n\n            // Original element is no longer needed: delete it and create a placeholder comment\n            placeholder = element.ownerDocument.createComment('ko_repeatplaceholder ' + origBindString);\n            parent.replaceChild(placeholder, element);\n        }\n\n        // extract and remove a data-repeat-bind attribute, if present\n        if (!repeatBind) {\n            repeatBind = element.getAttribute('data-repeat-bind');\n            if (repeatBind) {\n                element.removeAttribute('data-repeat-bind');\n            }\n        }\n\n        // Make a copy of the element node to be copied for each repetition\n        var cleanNode = element.cloneNode(true);\n        if (typeof repeatBind == \"string\") {\n            cleanNode.setAttribute('data-bind', repeatBind);\n            repeatBind = null;\n        }\n\n        // Set up persistent data\n        var lastRepeatCount = 0,\n            notificationObservable = ko.observable(),\n            repeatArray, arrayObservable;\n\n        if (repeatInit) {\n            repeatInit(parent);\n        }\n\n        var subscribable = ko.computed(function() {\n            function makeArrayItemAccessor(index) {\n                var f = function(newValue) {\n                    var item = repeatArray[index];\n                    // Reading the value of the item\n                    if (!arguments.length) {\n                        notificationObservable();   // for dependency tracking\n                        return ko_unwrap(item);\n                    }\n                    // Writing a value to the item\n                    if (ko.isObservable(item)) {\n                        item(newValue);\n                    } else if (arrayObservable && arrayObservable.splice) {\n                        arrayObservable.splice(index, 1, newValue);\n                    } else {\n                        repeatArray[index] = newValue;\n                    }\n                    return this;\n                };\n                // Pretend that our accessor function is an observable\n                f[koProtoName] = ko.observable;\n                return f;\n            }\n\n            function makeBinding(item, index, context) {\n                return repeatArray\n                    ? function() { return repeatBind.call(bindingContext.$data, item, index, context); }\n                    : function() { return repeatBind.call(bindingContext.$data, index, context); }\n            }\n\n            // Read and set up variable options--these options can change and will update the binding\n            var paramObservable = valueAccessor(), repeatParam = ko_unwrap(paramObservable), repeatCount = 0;\n            if (repeatParam && typeof repeatParam == 'object') {\n                if ('length' in repeatParam) {\n                    repeatArray = repeatParam;\n                    repeatCount = repeatArray.length;\n                } else {\n                    if ('foreach' in repeatParam) {\n                        repeatArray = ko_unwrap(paramObservable = repeatParam.foreach);\n                        if (repeatArray && typeof repeatArray == 'object' && 'length' in repeatArray) {\n                            repeatCount = repeatArray.length || 0;\n                        } else {\n                            repeatCount = repeatArray || 0;\n                            repeatArray = null;\n                        }\n                    }\n                    // If a count value is provided (>0), always output that number of items\n                    if ('count' in repeatParam)\n                        repeatCount = ko_unwrap(repeatParam.count) || repeatCount;\n                    // If a limit is provided, don't output more than the limit\n                    if ('limit' in repeatParam)\n                        repeatCount = Math.min(repeatCount, ko_unwrap(repeatParam.limit)) || repeatCount;\n                }\n                arrayObservable = repeatArray && ko.isObservable(paramObservable) ? paramObservable : null;\n            } else {\n                repeatCount = repeatParam || 0;\n            }\n\n            // Remove nodes from end if array is shorter\n            for (; lastRepeatCount > repeatCount; lastRepeatCount-=repeatStep) {\n                ko.removeNode(repeatReversed ? placeholder.nextSibling : placeholder.previousSibling);\n            }\n\n            // Notify existing nodes of change\n            notificationObservable.notifySubscribers();\n\n            // Add nodes to end if array is longer (also initially populates nodes)\n            for (; lastRepeatCount < repeatCount; lastRepeatCount+=repeatStep) {\n                // Clone node and add to document\n                var newNode = cleanNode.cloneNode(true);\n                parent.insertBefore(newNode, repeatReversed ? placeholder.nextSibling : placeholder);\n                newNode.setAttribute('data-repeat-index', lastRepeatCount);\n\n                // Apply bindings to inserted node\n                if (repeatArray && repeatData == '$data') {\n                    var newContext = bindingContext.createChildContext(makeArrayItemAccessor(lastRepeatCount));\n                } else {\n                    var newContext = bindingContext.extend();\n                    if (repeatArray)\n                        newContext[repeatData] = makeArrayItemAccessor(lastRepeatCount);\n                }\n                newContext[repeatIndex] = lastRepeatCount;\n                if (repeatBind) {\n                    var result = ko.applyBindingsToNode(newNode, makeBinding(newContext[repeatData], lastRepeatCount, newContext), newContext, true),\n                        shouldBindDescendants = result && result.shouldBindDescendants;\n                }\n                if (!repeatBind || (result && shouldBindDescendants !== false)) {\n                    ko.applyBindings(newContext, newNode);\n                }\n            }\n            if (repeatUpdate) {\n                repeatUpdate(parent);\n            }\n        }, null, {disposeWhenNodeIsRemoved: placeholder});\n\n        return { controlsDescendantBindings: true, subscribable: subscribable };\n    }\n};\n});","Magento_Vault/js/customer_account/deleteWidget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modalToggle',\n    'mage/translate'\n], function ($, modalToggle) {\n    'use strict';\n\n    return function (config, deleteButton) {\n        config.buttons = [\n            {\n                text: $.mage.__('Cancel'),\n                class: 'action secondary cancel'\n            }, {\n                text: $.mage.__('Delete'),\n                class: 'action primary',\n\n                /**\n                 * Default action on button click\n                 */\n                click: function (event) { //eslint-disable-line no-unused-vars\n                    $(deleteButton.form).submit();\n                }\n            }\n        ];\n\n        modalToggle(config, deleteButton);\n    };\n});\n","Magento_Vault/js/view/payment/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n/* @api */\ndefine([\n    'underscore',\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'uiLayout',\n    'uiRegistry'\n], function (_, Component, rendererList, layout, registry) {\n    'use strict';\n\n    var vaultGroupName = 'vaultGroup';\n\n    layout([{\n        name: vaultGroupName,\n        component: 'Magento_Checkout/js/model/payment/method-group',\n        alias: 'vault',\n        sortOrder: 10\n    }]);\n\n    registry.get(vaultGroupName, function (vaultGroup) {\n        _.each(window.checkoutConfig.payment.vault, function (config, index) {\n            rendererList.push(\n                {\n                    type: index,\n                    config: config.config,\n                    component: config.component,\n                    group: vaultGroup,\n\n                    /**\n                     * Custom payment method types comparator\n                     * @param {String} typeA\n                     * @param {String} typeB\n                     * @return {Boolean}\n                     */\n                    typeComparatorCallback: function (typeA, typeB) {\n                        // vault token items have the same name as vault payment without index\n                        return typeA.substring(0, typeA.lastIndexOf('_')) === typeB;\n                    }\n                }\n            );\n        });\n    });\n\n    /**\n     * Add view logic here if needed\n     */\n    return Component.extend({});\n});\n","Magento_Vault/js/view/payment/vault-enabler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n/* @api */\ndefine(\n    [\n        'uiElement'\n    ],\n    function (\n        Component\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                isActivePaymentTokenEnabler: true\n            },\n\n            /**\n             * @param {String} paymentCode\n             */\n            setPaymentCode: function (paymentCode) {\n                this.paymentCode = paymentCode;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([\n                        'isActivePaymentTokenEnabler'\n                    ]);\n\n                return this;\n            },\n\n            /**\n             * @param {Object} data\n             */\n            visitAdditionalData: function (data) {\n                if (!this.isVaultEnabled()) {\n                    return;\n                }\n\n                if (!('additional_data' in data)) {\n                    data['additional_data'] = {};\n                }\n\n                data['additional_data']['is_active_payment_token_enabler'] = this.isActivePaymentTokenEnabler();\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isVaultEnabled: function () {\n                return typeof window.checkoutConfig.vault[this.paymentCode] !== 'undefined' &&\n                    window.checkoutConfig.vault[this.paymentCode]['is_enabled'] === true;\n            }\n        });\n    }\n);\n","Magento_Vault/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Checkout/js/action/select-payment-method',\n        'Magento_Checkout/js/checkout-data'\n    ],\n    function (Component, selectPaymentMethod, checkoutData) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Vault/payment/form'\n            },\n\n            /**\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([]);\n\n                return this;\n            },\n\n            /**\n             * @returns\n             */\n            selectPaymentMethod: function () {\n                selectPaymentMethod(\n                    {\n                        method: this.getId()\n                    }\n                );\n                checkoutData.setSelectedPaymentMethod(this.getId());\n\n                return true;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getTitle: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getToken: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getId: function () {\n                return this.index;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Get last 4 digits of card\n             * @returns {String}\n             */\n            getMaskedCard: function () {\n                return '';\n            },\n\n            /**\n             * Get expiration date\n             * @returns {String}\n             */\n            getExpirationDate: function () {\n                return '';\n            },\n\n            /**\n             * Get card type\n             * @returns {String}\n             */\n            getCardType: function () {\n                return '';\n            },\n\n            /**\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.ccform.icons[type]\n                    : false;\n            },\n\n            /**\n             * @returns {*}\n             */\n            getData: function () {\n                var data = {\n                    method: this.getCode()\n                };\n\n                data['additional_data'] = {};\n                data['additional_data']['public_hash'] = this.getToken();\n\n                return data;\n            }\n        });\n    }\n);\n","Magento_Payment/cc-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.creditCardType', {\n        options: {\n            typeCodes: ['SS', 'SM', 'SO'] // Type codes for Switch/Maestro/Solo credit cards.\n        },\n\n        /**\n         * Bind change handler to select element and trigger the event to show/hide\n         * the Switch/Maestro or Solo credit card type container for those credit card types.\n         * @private\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(this._toggleCardType, this)).trigger('change');\n        },\n\n        /**\n         * Toggle the Switch/Maestro and Solo credit card type container depending on which\n         * credit card type is selected.\n         * @private\n         */\n        _toggleCardType: function () {\n            $(this.options.creditCardTypeContainer)\n                .toggle($.inArray(this.element.val(), this.options.typeCodes) !== -1);\n        }\n    });\n\n    return $.mage.creditCardType;\n});\n","Magento_Payment/transparent.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'Magento_Payment/js/model/credit-card-validation/validator',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, mageTemplate, alert, ui, validator, fullScreenLoader) {\n    'use strict';\n\n    $.widget('mage.transparent', {\n        options: {\n            context: null,\n            placeOrderSelector: '[data-role=\"review-save\"]',\n            paymentFormSelector: '#co-payment-form',\n            updateSelectorPrefix: '#checkout-',\n            updateSelectorSuffix: '-load',\n            hiddenFormTmpl:\n                '<form target=\"<%= data.target %>\" action=\"<%= data.action %>\" method=\"POST\" ' +\n                'hidden enctype=\"application/x-www-form-urlencoded\" class=\"no-display\">' +\n                    '<% _.each(data.inputs, function(val, key){ %>' +\n                    '<input value=\"<%= val %>\" name=\"<%= key %>\" type=\"hidden\">' +\n                    '<% }); %>' +\n                '</form>',\n            reviewAgreementForm: '#checkout-agreements',\n            cgiUrl: null,\n            orderSaveUrl: null,\n            controller: null,\n            gateway: null,\n            dateDelim: null,\n            cardFieldsMap: null,\n            expireYearLength: 2\n        },\n\n        /**\n         * {Function}\n         * @private\n         */\n        _create: function () {\n            this.hiddenFormTmpl = mageTemplate(this.options.hiddenFormTmpl);\n\n            if (this.options.context) {\n                this.options.context.setPlaceOrderHandler($.proxy(this._orderSave, this));\n                this.options.context.setValidateHandler($.proxy(this._validateHandler, this));\n            } else {\n                $(this.options.placeOrderSelector)\n                    .off('click')\n                    .on('click', $.proxy(this._placeOrderHandler, this));\n            }\n\n            this.element.validation();\n            $('[data-container=\"' + this.options.gateway + '-cc-number\"]').on('focusout', function () {\n                $(this).valid();\n            });\n        },\n\n        /**\n         * handler for credit card validation\n         * @return {Boolean}\n         * @private\n         */\n        _validateHandler: function () {\n            return this.element.validation && this.element.validation('isValid');\n        },\n\n        /**\n         * handler for Place Order button to call gateway for credit card validation\n         * @return {Boolean}\n         * @private\n         */\n        _placeOrderHandler: function () {\n            if (this._validateHandler()) {\n                this._orderSave();\n            }\n\n            return false;\n        },\n\n        /**\n         * Save order and generate post data for gateway call\n         * @private\n         */\n        _orderSave: function () {\n            var postData = $(this.options.paymentFormSelector).serialize();\n\n            if ($(this.options.reviewAgreementForm).length) {\n                postData += '&' + $(this.options.reviewAgreementForm).serialize();\n            }\n            postData += '&controller=' + this.options.controller;\n            postData += '&cc_type=' + this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-type\"]'\n            ).val();\n\n            return $.ajax({\n                url: this.options.orderSaveUrl,\n                type: 'post',\n                context: this,\n                data: postData,\n                dataType: 'json',\n\n                /**\n                 * {Function}\n                 */\n                beforeSend: function () {\n                    fullScreenLoader.startLoader();\n                },\n\n                /**\n                 * {Function}\n                 */\n                success: function (response) {\n                    var preparedData,\n                        msg,\n\n                        /**\n                         * {Function}\n                         */\n                        alertActionHandler = function () {\n                            // default action\n                        };\n\n                    if (response.success && response[this.options.gateway]) {\n                        preparedData = this._preparePaymentData(\n                            response[this.options.gateway].fields,\n                            this.options.cardFieldsMap\n                        );\n                        this._postPaymentToGateway(preparedData);\n                    } else {\n                        fullScreenLoader.stopLoader(true);\n\n                        msg = response['error_messages'];\n\n                        if (this.options.context) {\n                            this.options.context.clearTimeout().fail();\n                            alertActionHandler = this.options.context.alertActionHandler;\n                        }\n\n                        if (typeof msg === 'object') {\n                            msg = msg.join('\\n');\n                        }\n\n                        if (msg) {\n                            alert(\n                                {\n                                    content: msg,\n                                    actions: {\n\n                                        /**\n                                         * {Function}\n                                         */\n                                        always: alertActionHandler\n                                    }\n                                }\n                            );\n                        }\n                    }\n                }.bind(this)\n            });\n        },\n\n        /**\n         * Post data to gateway for credit card validation\n         * @param {Object} data\n         * @private\n         */\n        _postPaymentToGateway: function (data) {\n            var tmpl,\n                iframeSelector = '[data-container=\"' + this.options.gateway + '-transparent-iframe\"]';\n\n            tmpl = this.hiddenFormTmpl({\n                data: {\n                    target: $(iframeSelector).attr('name'),\n                    action: this.options.cgiUrl,\n                    inputs: data\n                }\n            });\n            $(tmpl).appendTo($(iframeSelector)).submit();\n        },\n\n        /**\n         * Add credit card fields to post data for gateway\n         * @param {Object} data\n         * @param {Object} ccfields\n         * @private\n         */\n        _preparePaymentData: function (data, ccfields) {\n            var preparedata;\n\n            if (this.element.find('[data-container=\"' + this.options.gateway + '-cc-cvv\"]').length) {\n                data[ccfields.cccvv] = this.element.find(\n                    '[data-container=\"' + this.options.gateway + '-cc-cvv\"]'\n                ).val();\n            }\n            preparedata = this._prepareExpDate();\n            data[ccfields.ccexpdate] = preparedata.month + this.options.dateDelim + preparedata.year;\n            data[ccfields.ccnum] = this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-number\"]'\n            ).val();\n\n            return data;\n        },\n\n        /**\n         * Grab Month and Year into one\n         * @returns {Object}\n         * @private\n         */\n        _prepareExpDate: function () {\n            var year = this.element.find('[data-container=\"' + this.options.gateway + '-cc-year\"]').val(),\n                month = parseInt(\n                    this.element.find('[data-container=\"' + this.options.gateway + '-cc-month\"]').val(),\n                    10\n                );\n\n            if (year.length > this.options.expireYearLength) {\n                year = year.substring(year.length - this.options.expireYearLength);\n            }\n\n            if (month < 10) {\n                month = '0' + month;\n            }\n\n            return {\n                month: month, year: year\n            };\n        }\n    });\n\n    return $.mage.transparent;\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-data.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([], function () {\n    'use strict';\n\n    return {\n        creditCard: null,\n        creditCardNumber: null,\n        expirationMonth: null,\n        expirationYear: null,\n        cvvCode: null\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/cvv-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    /**\n     * CVV number validation.\n     * Validate digit count fot CVV code.\n     *\n     * @param {*} value\n     * @param {Number} maxLength\n     * @return {Object}\n     */\n    return function (value, maxLength) {\n        var DEFAULT_LENGTH = 3;\n\n        maxLength = maxLength || DEFAULT_LENGTH;\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (value.length === maxLength) {\n            return resultWrapper(true, true);\n        }\n\n        if (value.length < maxLength) {\n            return resultWrapper(false, true);\n        }\n\n        if (value.length > maxLength) {\n            return resultWrapper(false, false);\n        }\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'mageUtils',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type'\n], function (utils, luhn10, creditCardTypes) {\n    'use strict';\n\n    /**\n     * @param {*} card\n     * @param {*} isPotentiallyValid\n     * @param {*} isValid\n     * @return {Object}\n     */\n    function resultWrapper(card, isPotentiallyValid, isValid) {\n        return {\n            card: card,\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var potentialTypes,\n            cardType,\n            valid,\n            i,\n            maxLength;\n\n        if (utils.isEmpty(value)) {\n            return resultWrapper(null, false, false);\n        }\n\n        value = value.replace(/\\-|\\s/g, '');\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(null, false, false);\n        }\n\n        potentialTypes = creditCardTypes.getCardTypes(value);\n\n        if (potentialTypes.length === 0) {\n            return resultWrapper(null, false, false);\n        } else if (potentialTypes.length !== 1) {\n            return resultWrapper(null, true, false);\n        }\n\n        cardType = potentialTypes[0];\n\n        if (cardType.type === 'unionpay') {  // UnionPay is not Luhn 10 compliant\n            valid = true;\n        } else {\n            valid = luhn10(value);\n        }\n\n        for (i = 0; i < cardType.lengths.length; i++) {\n            if (cardType.lengths[i] === value.length) {\n                return resultWrapper(cardType, valid, valid);\n            }\n        }\n\n        maxLength = Math.max.apply(null, cardType.lengths);\n\n        if (value.length < maxLength) {\n            return resultWrapper(cardType, true, false);\n        }\n\n        return resultWrapper(cardType, false, false);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'Magento_Payment/js/model/credit-card-validation/cvv-validator',\n            'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',\n            'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator',\n            'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n            'Magento_Payment/js/model/credit-card-validation/credit-card-data',\n            'mage/translate'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($, cvvValidator, creditCardNumberValidator, yearValidator, monthValidator, creditCardData) {\n    'use strict';\n\n    $.each({\n        'validate-card-type': [\n            function (number, item, allowedTypes) {\n                var cardInfo,\n                    i,\n                    l;\n\n                if (!creditCardNumberValidator(number).isValid) {\n                    return false;\n                }\n\n                cardInfo = creditCardNumberValidator(number).card;\n\n                for (i = 0, l = allowedTypes.length; i < l; i++) {\n                    if (cardInfo.title == allowedTypes[i].type) { //eslint-disable-line eqeqeq\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card type number.')\n        ],\n        'validate-card-number': [\n\n            /**\n             * Validate credit card number based on mod 10\n             *\n             * @param {*} number - credit card number\n             * @return {Boolean}\n             */\n            function (number) {\n                return creditCardNumberValidator(number).isValid;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'validate-card-date': [\n\n            /**\n             * Validate credit card expiration month\n             *\n             * @param {String} date - month\n             * @return {Boolean}\n             */\n            function (date) {\n                return monthValidator(date).isValid;\n            },\n            $.mage.__('Incorrect credit card expiration month.')\n        ],\n        'validate-card-cvv': [\n\n            /**\n             * Validate cvv\n             *\n             * @param {String} cvv - card verification value\n             * @return {Boolean}\n             */\n            function (cvv) {\n                var maxLength = creditCardData.creditCard ? creditCardData.creditCard.code.size : 3;\n\n                return cvvValidator(cvv, maxLength).isValid;\n            },\n            $.mage.__('Please enter a valid credit card verification number.')\n        ],\n        'validate-card-year': [\n\n            /**\n             * Validate credit card expiration year\n             *\n             * @param {String} date - year\n             * @return {Boolean}\n             */\n            function (date) {\n                return yearValidator(date).isValid;\n            },\n            $.mage.__('Incorrect credit card expiration year.')\n        ]\n\n    }, function (i, rule) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n}));\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'mageUtils',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator'\n], function (utils, parseDate, expirationMonth, expirationYear) {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @param {*} month\n     * @param {*} year\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid, month, year) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid,\n            month: month,\n            year: year\n        };\n    }\n\n    return function (value) {\n        var date,\n            monthValid,\n            yearValid;\n\n        if (utils.isEmpty(value)) {\n            return resultWrapper(false, false, null, null);\n        }\n\n        value = value.replace(/^(\\d\\d) (\\d\\d(\\d\\d)?)$/, '$1/$2');\n        date = parseDate(value);\n        monthValid = expirationMonth(date.month);\n        yearValid = expirationYear(date.year);\n\n        if (monthValid.isValid && yearValid.isValid) {\n            return resultWrapper(true, true, date.month, date.year);\n        }\n\n        if (monthValid.isPotentiallyValid && yearValid.isPotentiallyValid) {\n            return resultWrapper(false, true, null, null);\n        }\n\n        return resultWrapper(false, false, null, null);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var month,\n            monthValid;\n\n        if (value.replace(/\\s/g, '') === '' || value === '0') {\n            return resultWrapper(false, true);\n        }\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (isNaN(value)) {\n            return resultWrapper(false, false);\n        }\n\n        month = parseInt(value, 10);\n        monthValid = month > 0 && month < 13;\n\n        return resultWrapper(monthValid, monthValid);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var currentYear = new Date().getFullYear(),\n            len = value.length,\n            valid,\n            expMaxLifetime = 19;\n\n        if (value.replace(/\\s/g, '') === '') {\n            return resultWrapper(false, true);\n        }\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (len !== 4) {\n            return resultWrapper(false, true);\n        }\n\n        value = parseInt(value, 10);\n        valid = value >= currentYear && value <= currentYear + expMaxLifetime;\n\n        return resultWrapper(valid, valid);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return function (value) {\n        var month, len;\n\n        if (value.match('/')) {\n            value = value.split(/\\s*\\/\\s*/g);\n\n            return {\n                month: value[0],\n                year: value.slice(1).join()\n            };\n        }\n\n        len = value[0] === '0' || value.length > 5 || value.length === 4 || value.length === 3 ? 2 : 1;\n        month = value.substr(0, len);\n\n        return {\n            month: month,\n            year: value.substr(month.length, 4)\n        };\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'mageUtils'\n], function ($, utils) {\n    'use strict';\n\n    var types = [\n        {\n            title: 'Visa',\n            type: 'VI',\n            pattern: '^4\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'MasterCard',\n            type: 'MC',\n            pattern: '^(?:5[1-5][0-9]{2}|222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12}$',\n            gaps: [4, 8, 12],\n            lengths: [16],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'American Express',\n            type: 'AE',\n            pattern: '^3([47]\\\\d*)?$',\n            isAmex: true,\n            gaps: [4, 10],\n            lengths: [15],\n            code: {\n                name: 'CID',\n                size: 4\n            }\n        },\n        {\n            title: 'Diners',\n            type: 'DN',\n            pattern: '^(3(0[0-5]|095|6|[8-9]))\\\\d*$',\n            gaps: [4, 10],\n            lengths: [14, 16, 17, 18, 19],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'Discover',\n            type: 'DI',\n            pattern: '^(6011(0|[2-4]|74|7[7-9]|8[6-9]|9)|6(4[4-9]|5))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CID',\n                size: 3\n            }\n        },\n        {\n            title: 'JCB',\n            type: 'JCB',\n            pattern: '^35(2[8-9]|[3-8])\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'UnionPay',\n            type: 'UN',\n            pattern: '^(622(1(2[6-9]|[3-9])|[3-8]|9([[0-1]|2[0-5]))|62[4-6]|628([2-8]))\\\\d*?$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CVN',\n                size: 3\n            }\n        },\n        {\n            title: 'Maestro International',\n            type: 'MI',\n            pattern: '^(5(0|[6-9])|63|67(?!59|6770|6774))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Maestro Domestic',\n            type: 'MD',\n            pattern: '^6759(?!24|38|40|6[3-9]|70|76)|676770|676774\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        }\n    ];\n\n    return {\n        /**\n         * @param {*} cardNumber\n         * @return {Array}\n         */\n        getCardTypes: function (cardNumber) {\n            var i, value,\n                result = [];\n\n            if (utils.isEmpty(cardNumber)) {\n                return result;\n            }\n\n            if (cardNumber === '') {\n                return $.extend(true, {}, types);\n            }\n\n            for (i = 0; i < types.length; i++) {\n                value = types[i];\n\n                if (new RegExp(value.pattern).test(cardNumber)) {\n                    result.push($.extend(true, {}, value));\n                }\n            }\n\n            return result;\n        }\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Luhn algorithm verification\n     */\n    return function (a, b, c, d, e) {\n        for (d = +a[b = a.length - 1], e = 0; b--;) {\n            c = +a[b];\n            d += ++e % 2 ? 2 * c % 10 + (c > 4) : c;\n        }\n\n        return !(d % 10);\n    };\n});\n","Magento_Payment/js/view/payment/payments.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    rendererList.push(\n        {\n            type: 'free',\n            component: 'Magento_Payment/js/view/payment/method-renderer/free-method'\n        }\n    );\n\n    /** Add view logic here if needed */\n    return Component.extend({});\n});\n","Magento_Payment/js/view/payment/cc-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-data',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',\n    'mage/translate'\n], function (_, Component, creditCardData, cardNumberValidator, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            creditCardType: '',\n            creditCardExpYear: '',\n            creditCardExpMonth: '',\n            creditCardNumber: '',\n            creditCardSsStartMonth: '',\n            creditCardSsStartYear: '',\n            creditCardSsIssue: '',\n            creditCardVerificationNumber: '',\n            selectedCardType: null\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'creditCardType',\n                    'creditCardExpYear',\n                    'creditCardExpMonth',\n                    'creditCardNumber',\n                    'creditCardVerificationNumber',\n                    'creditCardSsStartMonth',\n                    'creditCardSsStartYear',\n                    'creditCardSsIssue',\n                    'selectedCardType'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init component\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            //Set credit card number to credit card data object\n            this.creditCardNumber.subscribe(function (value) {\n                var result;\n\n                self.selectedCardType(null);\n\n                if (value === '' || value === null) {\n                    return false;\n                }\n                result = cardNumberValidator(value);\n\n                if (!result.isPotentiallyValid && !result.isValid) {\n                    return false;\n                }\n\n                if (result.card !== null) {\n                    self.selectedCardType(result.card.type);\n                    creditCardData.creditCard = result.card;\n                }\n\n                if (result.isValid) {\n                    creditCardData.creditCardNumber = value;\n                    self.creditCardType(result.card.type);\n                }\n            });\n\n            //Set expiration year to credit card data object\n            this.creditCardExpYear.subscribe(function (value) {\n                creditCardData.expirationYear = value;\n            });\n\n            //Set expiration month to credit card data object\n            this.creditCardExpMonth.subscribe(function (value) {\n                creditCardData.expirationMonth = value;\n            });\n\n            //Set cvv code to credit card data object\n            this.creditCardVerificationNumber.subscribe(function (value) {\n                creditCardData.cvvCode = value;\n            });\n        },\n\n        /**\n         * Get code\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'cc';\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            return {\n                'method': this.item.method,\n                'additional_data': {\n                    'cc_cid': this.creditCardVerificationNumber(),\n                    'cc_ss_start_month': this.creditCardSsStartMonth(),\n                    'cc_ss_start_year': this.creditCardSsStartYear(),\n                    'cc_ss_issue': this.creditCardSsIssue(),\n                    'cc_type': this.creditCardType(),\n                    'cc_exp_year': this.creditCardExpYear(),\n                    'cc_exp_month': this.creditCardExpMonth(),\n                    'cc_number': this.creditCardNumber()\n                }\n            };\n        },\n\n        /**\n         * Get list of available credit card types\n         * @returns {Object}\n         */\n        getCcAvailableTypes: function () {\n            return window.checkoutConfig.payment.ccform.availableTypes[this.getCode()];\n        },\n\n        /**\n         * Get payment icons\n         * @param {String} type\n         * @returns {Boolean}\n         */\n        getIcons: function (type) {\n            return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                window.checkoutConfig.payment.ccform.icons[type]\n                : false;\n        },\n\n        /**\n         * Get list of months\n         * @returns {Object}\n         */\n        getCcMonths: function () {\n            return window.checkoutConfig.payment.ccform.months[this.getCode()];\n        },\n\n        /**\n         * Get list of years\n         * @returns {Object}\n         */\n        getCcYears: function () {\n            return window.checkoutConfig.payment.ccform.years[this.getCode()];\n        },\n\n        /**\n         * Check if current payment has verification\n         * @returns {Boolean}\n         */\n        hasVerification: function () {\n            return window.checkoutConfig.payment.ccform.hasVerification[this.getCode()];\n        },\n\n        /**\n         * @deprecated\n         * @returns {Boolean}\n         */\n        hasSsCardType: function () {\n            return window.checkoutConfig.payment.ccform.hasSsCardType[this.getCode()];\n        },\n\n        /**\n         * Get image url for CVV\n         * @returns {String}\n         */\n        getCvvImageUrl: function () {\n            return window.checkoutConfig.payment.ccform.cvvImageUrl[this.getCode()];\n        },\n\n        /**\n         * Get image for CVV\n         * @returns {String}\n         */\n        getCvvImageHtml: function () {\n            return '<img src=\"' + this.getCvvImageUrl() +\n                '\" alt=\"' + $t('Card Verification Number Visual Reference') +\n                '\" title=\"' + $t('Card Verification Number Visual Reference') +\n                '\" />';\n        },\n\n        /**\n         * @deprecated\n         * @returns {Object}\n         */\n        getSsStartYears: function () {\n            return window.checkoutConfig.payment.ccform.ssStartYears[this.getCode()];\n        },\n\n        /**\n         * Get list of available credit card types values\n         * @returns {Object}\n         */\n        getCcAvailableTypesValues: function () {\n            return _.map(this.getCcAvailableTypes(), function (value, key) {\n                return {\n                    'value': key,\n                    'type': value\n                };\n            });\n        },\n\n        /**\n         * Get list of available month values\n         * @returns {Object}\n         */\n        getCcMonthsValues: function () {\n            return _.map(this.getCcMonths(), function (value, key) {\n                return {\n                    'value': key,\n                    'month': value\n                };\n            });\n        },\n\n        /**\n         * Get list of available year values\n         * @returns {Object}\n         */\n        getCcYearsValues: function () {\n            return _.map(this.getCcYears(), function (value, key) {\n                return {\n                    'value': key,\n                    'year': value\n                };\n            });\n        },\n\n        /**\n         * @deprecated\n         * @returns {Object}\n         */\n        getSsStartYearsValues: function () {\n            return _.map(this.getSsStartYears(), function (value, key) {\n                return {\n                    'value': key,\n                    'year': value\n                };\n            });\n        },\n\n        /**\n         * Is legend available to display\n         * @returns {Boolean}\n         */\n        isShowLegend: function () {\n            return false;\n        },\n\n        /**\n         * Get available credit card type by code\n         * @param {String} code\n         * @returns {String}\n         */\n        getCcTypeTitleByCode: function (code) {\n            var title = '',\n                keyValue = 'value',\n                keyType = 'type';\n\n            _.each(this.getCcAvailableTypesValues(), function (value) {\n                if (value[keyValue] === code) {\n                    title = value[keyType];\n                }\n            });\n\n            return title;\n        },\n\n        /**\n         * Prepare credit card number to output\n         * @param {String} number\n         * @returns {String}\n         */\n        formatDisplayCcNumber: function (number) {\n            return 'xxxx-' + number.substr(-4);\n        },\n\n        /**\n         * Get credit card details\n         * @returns {Array}\n         */\n        getInfo: function () {\n            return [\n                {\n                    'name': 'Credit Card Type', value: this.getCcTypeTitleByCode(this.creditCardType())\n                },\n                {\n                    'name': 'Credit Card Number', value: this.formatDisplayCcNumber(this.creditCardNumber())\n                }\n            ];\n        }\n    });\n});\n","Magento_Payment/js/view/payment/iframe.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'Magento_Payment/js/view/payment/cc-form',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Ui/js/modal/alert'\n], function (\n    $,\n    Component,\n    messageList,\n    $t,\n    fullScreenLoader,\n    setPaymentInformationAction,\n    additionalValidators,\n    alert\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Payment/payment/iframe',\n            timeoutId: null,\n            timeoutMessage: 'Sorry, but something went wrong.'\n        },\n\n        /**\n         * @returns {String}\n         */\n        getSource: function () {\n            return window.checkoutConfig.payment.iframe.source[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getControllerName: function () {\n            return window.checkoutConfig.payment.iframe.controllerName[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getPlaceOrderUrl: function () {\n            return window.checkoutConfig.payment.iframe.placeOrderUrl[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getCgiUrl: function () {\n            return window.checkoutConfig.payment.iframe.cgiUrl[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getSaveOrderUrl: function () {\n            return window.checkoutConfig.payment.iframe.saveOrderUrl[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getDateDelim: function () {\n            return window.checkoutConfig.payment.iframe.dateDelim[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getCardFieldsMap: function () {\n            return window.checkoutConfig.payment.iframe.cardFieldsMap[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getExpireYearLength: function () {\n            return window.checkoutConfig.payment.iframe.expireYearLength[this.getCode()];\n        },\n\n        /**\n         * @param {Object} parent\n         * @returns {Function}\n         */\n        originalPlaceOrder: function (parent) {\n            return parent.placeOrder.bind(parent);\n        },\n\n        /**\n         * @returns {Number}\n         */\n        getTimeoutTime: function () {\n            return window.checkoutConfig.payment.iframe.timeoutTime[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getTimeoutMessage: function () {\n            return $t(this.timeoutMessage);\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            if (this.validateHandler() && additionalValidators.validate()) {\n\n                fullScreenLoader.startLoader();\n\n                this.isPlaceOrderActionAllowed(false);\n\n                $.when(\n                    setPaymentInformationAction(\n                        this.messageContainer,\n                        {\n                            method: this.getCode()\n                        }\n                    )\n                ).done(this.done.bind(this))\n                    .fail(this.fail.bind(this));\n\n                this.initTimeoutHandler();\n            }\n        },\n\n        /**\n         * {Function}\n         */\n        initTimeoutHandler: function () {\n            this.timeoutId = setTimeout(\n                this.timeoutHandler.bind(this),\n                this.getTimeoutTime()\n            );\n\n            $(window).off('clearTimeout')\n                .on('clearTimeout', this.clearTimeout.bind(this));\n        },\n\n        /**\n         * {Function}\n         */\n        clearTimeout: function () {\n            clearTimeout(this.timeoutId);\n            this.fail();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        timeoutHandler: function () {\n            this.clearTimeout();\n\n            alert(\n                {\n                    content: this.getTimeoutMessage(),\n                    actions: {\n\n                        /**\n                         * {Function}\n                         */\n                        always: this.alertActionHandler.bind(this)\n                    }\n                }\n            );\n\n            this.fail();\n        },\n\n        /**\n         * {Function}\n         */\n        alertActionHandler: function () {\n            fullScreenLoader.startLoader();\n            window.location.reload();\n        },\n\n        /**\n         * {Function}\n         */\n        fail: function () {\n            fullScreenLoader.stopLoader();\n            this.isPlaceOrderActionAllowed(true);\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        done: function () {\n            this.placeOrderHandler().fail(function () {\n                fullScreenLoader.stopLoader();\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Payment/js/view/payment/method-renderer/free-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Payment/payment/free'\n        },\n\n        /** Returns is method available */\n        isAvailable: function () {\n            return quote.totals()['grand_total'] <= 0;\n        }\n    });\n});\n","Magento_Sales/gift-message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.giftMessage', {\n        options: {\n            rowPrefix: '#order-item-row-', // Selector prefix for item's row in the table.\n            linkPrefix: '#order-item-gift-message-link-', // Selector prefix for the 'Gift Message' link.\n            duration: 100, // Toggle duration.\n            expandedClass: 'expanded', // Class added/removed to/from the 'Gift Message' link.\n            expandedContentClass: 'expanded-content', // Class added/removed to/from the 'Gift Message' content.\n            lastClass: 'last' // Class added/removed to/from the last item's row in the products table.\n        },\n\n        /**\n         * Bind a click handler on the widget's element to toggle the gift message.\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', $.proxy(this._toggleGiftMessage, this));\n        },\n\n        /**\n         * Toggle the display of the item's corresponding gift message.\n         * @private\n         * @param {jQuery.Event} event - Click event.\n         */\n        _toggleGiftMessage: function (event) {\n            var element = $(event.target), // Click target. The 'Gift Message' link or 'Close' button.\n                options = this.options, // Cached widget options.\n                itemId = element.data('item-id'), // The individual item's numeric id.\n                link = $(options.linkPrefix + itemId), // The 'Gift Message' expandable link.\n                row = $(options.rowPrefix + itemId), // The item's row in the products table.\n                region = $('#' + element.attr('aria-controls')); // The gift message container region.\n\n            region.toggleClass(options.expandedContentClass, options.duration, function () {\n                if (region.attr('aria-expanded') === 'true') {\n                    region.attr('aria-expanded', 'false');\n\n                    if (region.hasClass(options.lastClass)) {\n                        row.addClass(options.lastClass);\n                    }\n                } else {\n                    region.attr('aria-expanded', 'true');\n\n                    if (region.hasClass(options.lastClass)) {\n                        row.removeClass(options.lastClass);\n                    }\n                }\n                link.toggleClass(options.expandedClass);\n            });\n            event.preventDefault(); // Prevent event propagation and avoid going to the link's href.\n        }\n    });\n\n    return $.mage.giftMessage;\n});\n","Magento_Sales/orders-returns.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.ordersReturns', {\n        options: {\n            zipCode: '#oar-zip', // Search by zip code.\n            emailAddress: '#oar-email', // Search by email address.\n            searchType: '#quick-search-type-id' // Search element used for choosing between the two.\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            $(this.options.searchType).on('change', $.proxy(this._showIdentifyBlock, this)).trigger('change');\n        },\n\n        /**\n         * Show either the search by zip code option or the search by email address option.\n         * @private\n         * @param {jQuery.Event} e - Change event. Event target value is either 'zip' or 'email'.\n         */\n        _showIdentifyBlock: function (e) {\n            var value = $(e.target).val();\n\n            $(this.options.zipCode).toggle(value === 'zip');\n            $(this.options.emailAddress).toggle(value === 'email');\n        }\n    });\n\n    return $.mage.ordersReturns;\n});\n","Magento_Sales/js/view/last-ordered-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            var isShowAddToCart = false,\n                item;\n\n            this._super();\n            this.lastOrderedItems = customerData.get('last-ordered-items');\n\n            for (item in this.lastOrderedItems.items) {\n                if (item['is_saleable']) {\n                    isShowAddToCart = true;\n                    break;\n                }\n            }\n\n            this.lastOrderedItems.isShowAddToCart = isShowAddToCart;\n        }\n    });\n});\n","Magento_Customer/change-email-password.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.changeEmailPassword', {\n        options: {\n            changeEmailSelector: '[data-role=change-email]',\n            changePasswordSelector: '[data-role=change-password]',\n            mainContainerSelector: '[data-container=change-email-password]',\n            titleSelector: '[data-title=change-email-password]',\n            emailContainerSelector: '[data-container=change-email]',\n            newPasswordContainerSelector: '[data-container=new-password]',\n            confirmPasswordContainerSelector: '[data-container=confirm-password]',\n            currentPasswordSelector: '[data-input=current-password]',\n            emailSelector: '[data-input=change-email]',\n            newPasswordSelector: '[data-input=new-password]',\n            confirmPasswordSelector: '[data-input=confirm-password]'\n        },\n\n        /**\n         * Create widget\n         * @private\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(function () {\n                this._checkChoice();\n            }, this));\n\n            this._checkChoice();\n            this._bind();\n        },\n\n        /**\n         * Event binding, will monitor change, keyup and paste events.\n         * @private\n         */\n        _bind: function () {\n            this._on($(this.options.emailSelector), {\n                'change': this._updatePasswordFieldWithEmailValue,\n                'keyup': this._updatePasswordFieldWithEmailValue,\n                'paste': this._updatePasswordFieldWithEmailValue\n            });\n        },\n\n        /**\n         * Check choice\n         * @private\n         */\n        _checkChoice: function () {\n            if ($(this.options.changeEmailSelector).is(':checked') &&\n                $(this.options.changePasswordSelector).is(':checked')) {\n                this._showAll();\n            } else if ($(this.options.changeEmailSelector).is(':checked')) {\n                this._showEmail();\n            } else if ($(this.options.changePasswordSelector).is(':checked')) {\n                this._showPassword();\n            } else {\n                this._hideAll();\n            }\n        },\n\n        /**\n         * Show email and password input fields\n         * @private\n         */\n        _showAll: function () {\n            $(this.options.titleSelector).html(this.options.titleChangeEmailAndPassword);\n\n            $(this.options.mainContainerSelector).show();\n            $(this.options.emailContainerSelector).show();\n            $(this.options.newPasswordContainerSelector).show();\n            $(this.options.confirmPasswordContainerSelector).show();\n\n            $(this.options.currentPasswordSelector).attr('data-validate', '{required:true}').prop('disabled', false);\n            $(this.options.emailSelector).attr('data-validate', '{required:true}').prop('disabled', false);\n            this._updatePasswordFieldWithEmailValue();\n            $(this.options.confirmPasswordSelector).attr(\n                'data-validate',\n                '{required:true, equalTo:\"' + this.options.newPasswordSelector + '\"}'\n            ).prop('disabled', false);\n        },\n\n        /**\n         * Hide email and password input fields\n         * @private\n         */\n        _hideAll: function () {\n            $(this.options.mainContainerSelector).hide();\n            $(this.options.emailContainerSelector).hide();\n            $(this.options.newPasswordContainerSelector).hide();\n            $(this.options.confirmPasswordContainerSelector).hide();\n\n            $(this.options.currentPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.emailSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.newPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.confirmPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n        },\n\n        /**\n         * Show email input fields\n         * @private\n         */\n        _showEmail: function () {\n            this._showAll();\n            $(this.options.titleSelector).html(this.options.titleChangeEmail);\n\n            $(this.options.newPasswordContainerSelector).hide();\n            $(this.options.confirmPasswordContainerSelector).hide();\n\n            $(this.options.newPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.confirmPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n        },\n\n        /**\n         * Show password input fields\n         * @private\n         */\n        _showPassword: function () {\n            this._showAll();\n            $(this.options.titleSelector).html(this.options.titleChangePassword);\n\n            $(this.options.emailContainerSelector).hide();\n\n            $(this.options.emailSelector).removeAttr('data-validate').prop('disabled', true);\n        },\n\n        /**\n         * Update password validation rules with email input field value\n         * @private\n         */\n        _updatePasswordFieldWithEmailValue: function () {\n            $(this.options.newPasswordSelector).attr(\n                'data-validate',\n                '{required:true, ' +\n                '\\'validate-customer-password\\':true, ' +\n                '\\'password-not-equal-to-user-name\\':\\'' + $(this.options.emailSelector).val() + '\\'}'\n            ).prop('disabled', false);\n        }\n    });\n\n    return $.mage.changeEmailPassword;\n});\n","Magento_Customer/address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'jquery/ui',\n    'mage/translate'\n], function ($, confirm) {\n    'use strict';\n\n    $.widget('mage.address', {\n        /**\n         * Options common to all instances of this widget.\n         * @type {Object}\n         */\n        options: {\n            deleteConfirmMessage: $.mage.__('Are you sure you want to delete this address?')\n        },\n\n        /**\n         * Bind event handlers for adding and deleting addresses.\n         * @private\n         */\n        _create: function () {\n            var options         = this.options,\n                addAddress      = options.addAddress,\n                deleteAddress   = options.deleteAddress;\n\n            if (addAddress) {\n                $(document).on('click', addAddress, this._addAddress.bind(this));\n            }\n\n            if (deleteAddress) {\n                $(document).on('click', deleteAddress, this._deleteAddress.bind(this));\n            }\n        },\n\n        /**\n         * Add a new address.\n         * @private\n         */\n        _addAddress: function () {\n            window.location = this.options.addAddressLocation;\n        },\n\n        /**\n         * Delete the address whose id is specified in a data attribute after confirmation from the user.\n         * @private\n         * @param {jQuery.Event} e\n         * @return {Boolean}\n         */\n        _deleteAddress: function (e) {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteConfirmMessage,\n                actions: {\n\n                    /** @inheritdoc */\n                    confirm: function () {\n                        if (typeof $(e.target).parent().data('address') !== 'undefined') {\n                            window.location = self.options.deleteUrlPrefix + $(e.target).parent().data('address') +\n                                '/form_key/' + $.mage.cookies.get('form_key');\n                        } else {\n                            window.location = self.options.deleteUrlPrefix + $(e.target).data('address') +\n                                '/form_key/' + $.mage.cookies.get('form_key');\n                        }\n                    }\n                }\n            });\n\n            return false;\n        }\n    });\n\n    return $.mage.address;\n});\n","Magento_Customer/js/addressValidation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'validation'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.addressValidation', {\n        options: {\n            selectors: {\n                button: '[data-action=save-address]'\n            }\n        },\n\n        /**\n         * Validation creation\n         * @protected\n         */\n        _create: function () {\n            var button = $(this.options.selectors.button, this.element);\n\n            this.element.validation({\n\n                /**\n                 * Submit Handler\n                 * @param {Element} form - address form\n                 */\n                submitHandler: function (form) {\n\n                    button.attr('disabled', true);\n                    form.submit();\n                }\n            });\n        }\n    });\n\n    return $.mage.addressValidation;\n});\n","Magento_Customer/js/invalidation-processor.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    'Magento_Customer/js/customer-data'\n], function (_, Element, customerData) {\n    'use strict';\n\n    return Element.extend({\n        /**\n         * Initialize object\n         */\n        initialize: function () {\n            this._super();\n            this.process(customerData);\n        },\n\n        /**\n         * Process all rules in loop, each rule can invalidate some sections in customer data\n         *\n         * @param {Object} customerDataObject\n         */\n        process: function (customerDataObject) {\n            _.each(this.invalidationRules, function (rule, ruleName) {\n                _.each(rule, function (ruleArgs, rulePath) {\n                    require([rulePath], function (Rule) {\n                        var currentRule = new Rule(ruleArgs);\n\n                        if (!_.isFunction(currentRule.process)) {\n                            throw new Error('Rule ' + ruleName + ' should implement invalidationProcessor interface');\n                        }\n                        currentRule.process(customerDataObject);\n                    });\n                });\n            });\n        }\n    });\n});\n","Magento_Customer/js/section-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['underscore'], function (_) {\n    'use strict';\n\n    var baseUrls, sections, clientSideSections, canonize;\n\n    /**\n     * @param {String} url\n     * @return {String}\n     */\n    canonize = function (url) {\n        var route = url,\n            key;\n\n        for (key in baseUrls) { //eslint-disable-line guard-for-in\n            route = url.replace(baseUrls[key], '');\n\n            if (route != url) { //eslint-disable-line eqeqeq\n                break;\n            }\n        }\n\n        return route.replace(/^\\/?index.php\\/?/, '').toLowerCase();\n    };\n\n    return {\n        /**\n         * @param {String} url\n         * @return {Array}\n         */\n        getAffectedSections: function (url) {\n            var route = canonize(url),\n                actions = _.find(sections, function (val, section) {\n                    var matched;\n\n                    if (section.indexOf('*') >= 0) {\n                        section = section.replace(/\\*/g, '[^/]+') + '$';\n                        matched = route.match(section);\n\n                        return matched && matched[0] == route; //eslint-disable-line eqeqeq\n                    }\n\n                    return route.indexOf(section) === 0;\n                });\n\n            return _.union(_.toArray(actions), _.toArray(sections['*']));\n        },\n\n        /**\n         * @param {*} allSections\n         * @return {*}\n         */\n        filterClientSideSections: function (allSections) {\n            if (Array.isArray(allSections)) {\n                return _.difference(allSections, clientSideSections);\n            }\n\n            return allSections;\n        },\n\n        /**\n         * @param {String} sectionName\n         * @return {Boolean}\n         */\n        isClientSideSection: function (sectionName) {\n            return _.contains(clientSideSections, sectionName);\n        },\n\n        /**\n         * @param {Object} options\n         * @constructor\n         */\n        'Magento_Customer/js/section-config': function (options) {\n            baseUrls = options.baseUrls;\n            sections = options.sections;\n            clientSideSections = options.clientSideSections;\n        }\n    };\n});\n","Magento_Customer/js/password-strength-indicator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/zxcvbn',\n    'mage/translate',\n    'mage/validation'\n], function ($, zxcvbn, $t) {\n    'use strict';\n\n    $.widget('mage.passwordStrengthIndicator', {\n        options: {\n            cache: {},\n            passwordSelector: '[type=password]',\n            passwordStrengthMeterSelector: '[data-role=password-strength-meter]',\n            passwordStrengthMeterLabelSelector: '[data-role=password-strength-meter-label]',\n            formSelector: 'form',\n            emailSelector: 'input[type=\"email\"]'\n        },\n\n        /**\n         * Widget initialization\n         * @private\n         */\n        _create: function () {\n            this.options.cache.input = $(this.options.passwordSelector, this.element);\n            this.options.cache.meter = $(this.options.passwordStrengthMeterSelector, this.element);\n            this.options.cache.label = $(this.options.passwordStrengthMeterLabelSelector, this.element);\n\n            // We need to look outside the module for backward compatibility, since someone can already use the module.\n            this.options.cache.email = $(this.options.formSelector).find(this.options.emailSelector);\n            this._bind();\n        },\n\n        /**\n         * Event binding, will monitor change, keyup and paste events.\n         * @private\n         */\n        _bind: function () {\n            this._on(this.options.cache.input, {\n                'change': this._calculateStrength,\n                'keyup': this._calculateStrength,\n                'paste': this._calculateStrength\n            });\n\n            if (this.options.cache.email.length) {\n                this._on(this.options.cache.email, {\n                    'change': this._calculateStrength,\n                    'keyup': this._calculateStrength,\n                    'paste': this._calculateStrength\n                });\n            }\n        },\n\n        /**\n         * Calculate password strength\n         * @private\n         */\n        _calculateStrength: function () {\n            var password = this._getPassword(),\n                isEmpty = password.length === 0,\n                zxcvbnScore,\n                displayScore,\n                isValid;\n\n            // Display score is based on combination of whether password is empty, valid, and zxcvbn strength\n            if (isEmpty) {\n                displayScore = 0;\n            } else {\n                this.options.cache.input.rules('add', {\n                    'password-not-equal-to-user-name': this.options.cache.email.val()\n                });\n\n                if (password.toLowerCase() === this.options.cache.email.val().toLowerCase()) {\n                    displayScore = 1;\n                } else {\n                    isValid = $.validator.validateSingleElement(this.options.cache.input);\n                    zxcvbnScore = zxcvbn(password).score;\n                    displayScore = isValid ? zxcvbnScore : 1;\n                }\n            }\n\n            // Update label\n            this._displayStrength(displayScore);\n        },\n\n        /**\n         * Display strength\n         * @param {Number} displayScore\n         * @private\n         */\n        _displayStrength: function (displayScore) {\n            var strengthLabel = '',\n                className;\n\n            switch (displayScore) {\n                case 0:\n                    strengthLabel = $t('No Password');\n                    className = 'password-none';\n                    break;\n\n                case 1:\n                    strengthLabel = $t('Weak');\n                    className = 'password-weak';\n                    break;\n\n                case 2:\n                    strengthLabel = $t('Medium');\n                    className = 'password-medium';\n                    break;\n\n                case 3:\n                    strengthLabel = $t('Strong');\n                    className = 'password-strong';\n                    break;\n\n                case 4:\n                    strengthLabel = $t('Very Strong');\n                    className = 'password-very-strong';\n                    break;\n            }\n\n            this.options.cache.meter\n                .removeClass()\n                .addClass(className);\n            this.options.cache.label.text(strengthLabel);\n        },\n\n        /**\n         * Get password value\n         * @returns {*}\n         * @private\n         */\n        _getPassword: function () {\n            return this.options.cache.input.val();\n        }\n    });\n\n    return $.mage.passwordStrengthIndicator;\n});\n","Magento_Customer/js/customer-data.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'Magento_Customer/js/section-config',\n    'mage/storage',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, sectionConfig) {\n    'use strict';\n\n    var options,\n        storage,\n        storageInvalidation,\n        invalidateCacheBySessionTimeOut,\n        invalidateCacheByCloseCookieSession,\n        dataProvider,\n        buffer,\n        customerData;\n\n    //TODO: remove global change, in this case made for initNamespaceStorage\n    $.cookieStorage.setConf({\n        path: '/'\n    });\n\n    storage = $.initNamespaceStorage('mage-cache-storage').localStorage;\n    storageInvalidation = $.initNamespaceStorage('mage-cache-storage-section-invalidation').localStorage;\n\n    /**\n     * @param {Object} invalidateOptions\n     */\n    invalidateCacheBySessionTimeOut = function (invalidateOptions) {\n        var date;\n\n        if (new Date($.localStorage.get('mage-cache-timeout')) < new Date()) {\n            storage.removeAll();\n            date = new Date(Date.now() + parseInt(invalidateOptions.cookieLifeTime, 10) * 1000);\n            $.localStorage.set('mage-cache-timeout', date);\n        }\n    };\n\n    /**\n     * Invalidate Cache By Close Cookie Session\n     */\n    invalidateCacheByCloseCookieSession = function () {\n        if (!$.cookieStorage.isSet('mage-cache-sessid')) {\n            $.cookieStorage.set('mage-cache-sessid', true);\n            storage.removeAll();\n        }\n    };\n\n    dataProvider = {\n\n        /**\n         * @param {Object} sectionNames\n         * @return {Object}\n         */\n        getFromStorage: function (sectionNames) {\n            var result = {};\n\n            _.each(sectionNames, function (sectionName) {\n                result[sectionName] = storage.get(sectionName);\n            });\n\n            return result;\n        },\n\n        /**\n         * @param {Object} sectionNames\n         * @param {Number} updateSectionId\n         * @return {*}\n         */\n        getFromServer: function (sectionNames, updateSectionId) {\n            var parameters;\n\n            sectionNames = sectionConfig.filterClientSideSections(sectionNames);\n            parameters = _.isArray(sectionNames) ? {\n                sections: sectionNames.join(',')\n            } : [];\n            parameters['update_section_id'] = updateSectionId;\n\n            return $.getJSON(options.sectionLoadUrl, parameters).fail(function (jqXHR) {\n                throw new Error(jqXHR);\n            });\n        }\n    };\n\n    /**\n     * @param {Function} target\n     * @param {String} sectionName\n     * @return {*}\n     */\n    ko.extenders.disposableCustomerData = function (target, sectionName) {\n        var sectionDataIds, newSectionDataIds = {};\n\n        target.subscribe(function () {\n            setTimeout(function () {\n                storage.remove(sectionName);\n                sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n                _.each(sectionDataIds, function (data, name) {\n                    if (name != sectionName) { //eslint-disable-line eqeqeq\n                        newSectionDataIds[name] = data;\n                    }\n                });\n                $.cookieStorage.set('section_data_ids', newSectionDataIds);\n            }, 3000);\n        });\n\n        return target;\n    };\n\n    buffer = {\n        data: {},\n\n        /**\n         * @param {String} sectionName\n         */\n        bind: function (sectionName) {\n            this.data[sectionName] = ko.observable({});\n        },\n\n        /**\n         * @param {String} sectionName\n         * @return {Object}\n         */\n        get: function (sectionName) {\n            if (!this.data[sectionName]) {\n                this.bind(sectionName);\n            }\n\n            return this.data[sectionName];\n        },\n\n        /**\n         * @return {Array}\n         */\n        keys: function () {\n            return _.keys(this.data);\n        },\n\n        /**\n         * @param {String} sectionName\n         * @param {Object} sectionData\n         */\n        notify: function (sectionName, sectionData) {\n            if (!this.data[sectionName]) {\n                this.bind(sectionName);\n            }\n            this.data[sectionName](sectionData);\n        },\n\n        /**\n         * @param {Object} sections\n         */\n        update: function (sections) {\n            var sectionId = 0,\n                sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n\n            _.each(sections, function (sectionData, sectionName) {\n                sectionId = sectionData['data_id'];\n                sectionDataIds[sectionName] = sectionId;\n                storage.set(sectionName, sectionData);\n                storageInvalidation.remove(sectionName);\n                buffer.notify(sectionName, sectionData);\n            });\n            $.cookieStorage.set('section_data_ids', sectionDataIds);\n        },\n\n        /**\n         * @param {Object} sections\n         */\n        remove: function (sections) {\n            _.each(sections, function (sectionName) {\n                storage.remove(sectionName);\n\n                if (!sectionConfig.isClientSideSection(sectionName)) {\n                    storageInvalidation.set(sectionName, true);\n                }\n            });\n        }\n    };\n\n    customerData = {\n\n        /**\n         * Customer data initialization\n         */\n        init: function () {\n            var countryData,\n                privateContentVersion = 'private_content_version',\n                privateContent = $.cookieStorage.get(privateContentVersion),\n                localPrivateContent = $.localStorage.get(privateContentVersion),\n                needVersion = 'need_version',\n                expiredSectionNames = this.getExpiredSectionNames();\n\n            if (privateContent &&\n                !$.cookieStorage.isSet(privateContentVersion) &&\n                !$.localStorage.isSet(privateContentVersion)\n            ) {\n                $.cookieStorage.set(privateContentVersion, needVersion);\n                $.localStorage.set(privateContentVersion, needVersion);\n                this.reload([], false);\n            } else if (localPrivateContent !== privateContent) {\n                if (!$.cookieStorage.isSet(privateContentVersion)) {\n                    privateContent = needVersion;\n                    $.cookieStorage.set(privateContentVersion, privateContent);\n                }\n                $.localStorage.set(privateContentVersion, privateContent);\n                this.reload([], false);\n            } else if (expiredSectionNames.length > 0) {\n                _.each(dataProvider.getFromStorage(storage.keys()), function (sectionData, sectionName) {\n                    buffer.notify(sectionName, sectionData);\n                });\n                this.reload(expiredSectionNames, false);\n            } else {\n                _.each(dataProvider.getFromStorage(storage.keys()), function (sectionData, sectionName) {\n                    buffer.notify(sectionName, sectionData);\n                });\n\n                if (!_.isEmpty(storageInvalidation.keys())) {\n                    this.reload(storageInvalidation.keys(), false);\n                }\n            }\n\n            if (!_.isEmpty(privateContent)) {\n                countryData = this.get('directory-data');\n\n                if (_.isEmpty(countryData())) {\n                    customerData.reload(['directory-data'], false);\n                }\n            }\n        },\n\n        /**\n         * Retrieve the list of sections that has expired since last page reload.\n         *\n         * Sections can expire due to lifetime constraints or due to inconsistent storage information\n         * (validated by cookie data).\n         *\n         * @return {Array}\n         */\n        getExpiredSectionNames: function () {\n            var expiredSectionNames = [],\n                cookieSectionTimestamps = $.cookieStorage.get('section_data_ids') || {},\n                sectionLifetime = options.expirableSectionLifetime * 60,\n                currentTimestamp = Math.floor(Date.now() / 1000),\n                sectionData;\n\n            // process sections that can expire due to lifetime constraints\n            _.each(options.expirableSectionNames, function (sectionName) {\n                sectionData = storage.get(sectionName);\n\n                if (typeof sectionData === 'object' && sectionData['data_id'] + sectionLifetime <= currentTimestamp) {\n                    expiredSectionNames.push(sectionName);\n                }\n            });\n\n            // process sections that can expire due to storage information inconsistency\n            _.each(cookieSectionTimestamps, function (cookieSectionTimestamp, sectionName) {\n                sectionData = storage.get(sectionName);\n\n                if (typeof sectionData === 'undefined' ||\n                    typeof sectionData === 'object' &&\n                    cookieSectionTimestamp != sectionData['data_id'] //eslint-disable-line\n                ) {\n                    expiredSectionNames.push(sectionName);\n                }\n            });\n\n            return _.uniq(expiredSectionNames);\n        },\n\n        /**\n         * Check if some sections have to be reloaded.\n         *\n         * @deprecated Use getExpiredSectionNames instead.\n         *\n         * @return {Boolean}\n         */\n        needReload: function () {\n            var expiredSectionNames = this.getExpiredSectionNames();\n\n            return expiredSectionNames.length > 0;\n        },\n\n        /**\n         * Retrieve the list of expired keys.\n         *\n         * @deprecated Use getExpiredSectionNames instead.\n         *\n         * @return {Array}\n         */\n        getExpiredKeys: function () {\n            return this.getExpiredSectionNames();\n        },\n\n        /**\n         * @param {String} sectionName\n         * @return {*}\n         */\n        get: function (sectionName) {\n            return buffer.get(sectionName);\n        },\n\n        /**\n         * @param {String} sectionName\n         * @param {Object} sectionData\n         */\n        set: function (sectionName, sectionData) {\n            var data = {};\n\n            data[sectionName] = sectionData;\n            buffer.update(data);\n        },\n\n        /**\n         * @param {Array} sectionNames\n         * @param {Number} updateSectionId\n         * @return {*}\n         */\n        reload: function (sectionNames, updateSectionId) {\n            return dataProvider.getFromServer(sectionNames, updateSectionId).done(function (sections) {\n                $(document).trigger('customer-data-reload', [sectionNames]);\n                buffer.update(sections);\n            });\n        },\n\n        /**\n         * @param {Array} sectionNames\n         */\n        invalidate: function (sectionNames) {\n            var sectionDataIds,\n                sectionsNamesForInvalidation;\n\n            sectionsNamesForInvalidation = _.contains(sectionNames, '*') ? buffer.keys() : sectionNames;\n            $(document).trigger('customer-data-invalidate', [sectionsNamesForInvalidation]);\n            buffer.remove(sectionsNamesForInvalidation);\n            sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n\n            // Invalidate section in cookie (increase version of section with 1000)\n            _.each(sectionsNamesForInvalidation, function (sectionName) {\n                if (!sectionConfig.isClientSideSection(sectionName)) {\n                    sectionDataIds[sectionName] += 1000;\n                }\n            });\n            $.cookieStorage.set('section_data_ids', sectionDataIds);\n        },\n\n        /**\n         * @param {Object} settings\n         * @constructor\n         */\n        'Magento_Customer/js/customer-data': function (settings) {\n            options = settings;\n            invalidateCacheBySessionTimeOut(settings);\n            invalidateCacheByCloseCookieSession();\n            customerData.init();\n        }\n    };\n\n    /**\n     * Events listener\n     */\n    $(document).on('ajaxComplete', function (event, xhr, settings) {\n        var sections,\n            redirects;\n\n        if (settings.type.match(/post|put|delete/i)) {\n            sections = sectionConfig.getAffectedSections(settings.url);\n\n            if (sections) {\n                customerData.invalidate(sections);\n                redirects = ['redirect', 'backUrl'];\n\n                if (_.isObject(xhr.responseJSON) && !_.isEmpty(_.pick(xhr.responseJSON, redirects))) { //eslint-disable-line\n                    return;\n                }\n                customerData.reload(sections, true);\n            }\n        }\n    });\n\n    /**\n     * Events listener\n     */\n    $(document).on('submit', function (event) {\n        var sections;\n\n        if (event.target.method.match(/post|put|delete/i)) {\n            sections = sectionConfig.getAffectedSections(event.target.action);\n\n            if (sections) {\n                customerData.invalidate(sections);\n            }\n        }\n    });\n\n    return customerData;\n});\n","Magento_Customer/js/checkout-balance.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.checkoutBalance', {\n        /**\n         * Initialize store credit events\n         * @private\n         */\n        _create: function () {\n            this.eventData = {\n                price: this.options.balance,\n                totalPrice: 0\n            };\n            this.element.on('change', $.proxy(function (e) {\n                if ($(e.target).is(':checked')) {\n                    this.eventData.price = -1 * this.options.balance;\n                } else {\n                    if (this.options.amountSubstracted) { //eslint-disable-line no-lonely-if\n                        this.eventData.price = parseFloat(this.options.usedAmount);\n                        this.options.amountSubstracted = false;\n                    } else {\n                        this.eventData.price = parseFloat(this.options.balance);\n                    }\n                }\n                this.element.trigger('updateCheckoutPrice', this.eventData);\n            }, this));\n        }\n    });\n\n    return $.mage.checkoutBalance;\n});\n","Magento_Customer/js/invalidation-rules/website-rule.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiClass'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n\n        defaults: {\n            scopeConfig: {}\n        },\n\n        /**\n         * Takes website id from current customer data and compare it with current website id\n         * If customer belongs to another scope, we need to invalidate current section\n         *\n         * @param {Object} customerData\n         */\n        process: function (customerData) {\n            var customer = customerData.get('customer');\n\n            if (this.scopeConfig && customer() &&\n                ~~customer().websiteId !== ~~this.scopeConfig.websiteId && ~~customer().websiteId !== 0) {\n                customerData.reload(['customer']);\n            }\n        }\n    });\n});\n","Magento_Customer/js/model/address-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    './customer-addresses'\n], function (ko, defaultProvider) {\n    'use strict';\n\n    return ko.observableArray(defaultProvider.getAddressItems());\n});\n","Magento_Customer/js/model/customer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko',\n    'underscore',\n    './address-list'\n], function ($, ko, _, addressList) {\n    'use strict';\n\n    var isLoggedIn = ko.observable(window.isCustomerLoggedIn),\n        customerData = {};\n\n    if (isLoggedIn()) {\n        customerData = window.customerData;\n    } else {\n        customerData = {};\n    }\n\n    return {\n        customerData: customerData,\n        customerDetails: {},\n        isLoggedIn: isLoggedIn,\n\n        /**\n         * @param {Boolean} flag\n         */\n        setIsLoggedIn: function (flag) {\n            isLoggedIn(flag);\n        },\n\n        /**\n         * @return {Array}\n         */\n        getBillingAddressList: function () {\n            return addressList();\n        },\n\n        /**\n         * @return {Array}\n         */\n        getShippingAddressList: function () {\n            return addressList();\n        },\n\n        /**\n         * @param {String} fieldName\n         * @param {*} value\n         */\n        setDetails: function (fieldName, value) {\n            if (fieldName) {\n                this.customerDetails[fieldName] = value;\n            }\n        },\n\n        /**\n         * @param {String} fieldName\n         * @return {*}\n         */\n        getDetails: function (fieldName) {\n            if (fieldName) {\n                if (this.customerDetails.hasOwnProperty(fieldName)) {\n                    return this.customerDetails[fieldName];\n                }\n\n                return undefined;\n            }\n\n            return this.customerDetails;\n        },\n\n        /**\n         * @param {Array} address\n         * @return {Number}\n         */\n        addCustomerAddress: function (address) {\n            var fields = [\n                    'customer_id', 'country_id', 'street', 'company', 'telephone', 'fax', 'postcode', 'city',\n                    'firstname', 'lastname', 'middlename', 'prefix', 'suffix', 'vat_id', 'default_billing',\n                    'default_shipping'\n                ],\n                customerAddress = {},\n                hasAddress = 0,\n                existingAddress;\n\n            if (!this.customerData.addresses) {\n                this.customerData.addresses = [];\n            }\n\n            customerAddress = _.pick(address, fields);\n\n            if (address.hasOwnProperty('region_id')) {\n                customerAddress.region = {\n                    'region_id': address['region_id'],\n                    region: address.region\n                };\n            }\n\n            for (existingAddress in this.customerData.addresses) {\n                if (this.customerData.addresses.hasOwnProperty(existingAddress)) {\n                    if (_.isEqual(this.customerData.addresses[existingAddress], customerAddress)) { //eslint-disable-line\n                        hasAddress = existingAddress;\n                        break;\n                    }\n                }\n            }\n\n            if (hasAddress === 0) {\n                return this.customerData.addresses.push(customerAddress) - 1;\n            }\n\n            return hasAddress;\n        },\n\n        /**\n         * @param {*} addressI