# BasePath

While most URLs generated by the framework have the base URL prepended
automatically, developers will need to prepend the base URL to their own URLs
(usually inside an `href` attribute) in order for paths to resources to be
correct.

If you're running a zend-mvc application, `basePath()` will point to the
`public` folder of the application's root.

## Basic Usage

```php
/*
 * The following assume that the base URL of the page/application is "/mypage".
 */

/*
 * Prints:
 * <base href="/mypage/" />
 */
<base href="<?= $this->basePath() ?>" />

/*
 * Prints:
 * <link rel="stylesheet" type="text/css" href="/mypage/css/base.css" />
 */
<link rel="stylesheet" type="text/css"
     href="<?= $this->basePath('css/base.css') ?>" />
```

> ### index.php script
>
> For simplicity's sake, we strip out the entry PHP file (e.g., `index.php`)
> from the base URL. However, in some situations this may cause a problem. If
> one occurs, use `$this->plugin('basePath')->setBasePath()` to manually set the
> base path.
